sap.ui.require.preload({
	"sap/ui/unified/Calendar.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/core/Control\",\"sap/ui/core/LocaleData\",\"sap/ui/unified/calendar/CalendarUtils\",\"./calendar/Header\",\"./calendar/Month\",\"./calendar/MonthPicker\",\"./calendar/YearPicker\",\"./calendar/CalendarDate\",\"./library\",\"sap/ui/Device\",\"sap/ui/core/format/DateFormat\",\"sap/ui/core/ResizeHandler\",\"sap/ui/core/Locale\",\"./CalendarRenderer\"],function(e,t,a,i,o,s,r,n,h,g,d,c,l,p,u){\"use strict\";function _(){var e=this.getSelectedDates(),t=this.getPrimaryCalendarType();e&&e[0]&&e[0].getStartDate()?this._oFocusedDate=h.fromLocalJSDate(e[0].getStartDate(),t):this._oFocusedDate=h.fromLocalJSDate(new Date,t),this._oFocusedDate.isBefore(this._oMinDate)?this._oFocusedDate=new h(this._oMinDate,t):this._oFocusedDate.isAfter(this._oMaxDate)&&(this._oFocusedDate=new h(this._oMaxDate,t))}function D(){if(this._bNamesLengthChecked)m.call(this)>1&&this._focusDate(this._getFocusedDate(),!0,!0);else{this._showMonthPicker(!0),this._hideMonthPicker(!0);var e=this.getAggregation(\"monthPicker\");if(this._bLongMonth=e._bLongMonth,this._bNamesLengthChecked=!0,!this._bLongMonth){var t,a=this.getAggregation(\"month\");t=a.length>1?h.fromLocalJSDate(a[0].getDate(),this.getPrimaryCalendarType()):this._getFocusedDate(),this._setHeaderText(t)}}}function f(e,t){if(e){var a=h.fromLocalJSDate(e,this.getPrimaryCalendarType()),o=a.getYear();if(i._checkYearInValidRange(o),i._isOutside(a,this._oMinDate,this._oMaxDate))throw new Error(\"Date must not be in valid range (minDate and maxDate); \"+this);this._setFocusedDate(a),this.getDomRef()&&0==this._iMode&&this._renderMonth(t,!1,!0)}}function m(){return d.system.phone?1:this.getMonths()}function y(e){this.fireEvent(\"_renderMonth\",{days:e.getParameter(\"days\")})}function v(e){if(m.call(this)>1)for(var t=this.getAggregation(\"month\"),a=0;a<t.length;a++){var i=t[a];i.getId()!=e.oSource.getId()&&i._updateSelection()}this._oSelectedMonth=e.oSource,this.fireSelect()}function M(e){if(m.call(this)>1)for(var t=this.getAggregation(\"month\"),a=0;a<t.length;a++){var i=t[a];i.getId()!=e.oSource.getId()&&i._bindMousemove()}}function P(e){if(m.call(this)>1)for(var t=this.getAggregation(\"month\"),a=0;a<t.length;a++){var i=t[a];i.getId()!=e.oSource.getId()&&i._unbindMousemove()}}function S(e){var t=e.size.width;if(!(t<=0)){var a=this._iSize;t<this._iBreakPointTablet?this._iSize=0:t<this._iBreakPointDesktop?this._iSize=1:t<this._iBreakPointLargeDesktop?this._iSize=2:this._iSize=3;var i,o=m.call(this);if(a!=this._iSize||this._bInitMonth){switch(this._iSize){case 1:i=2;break;case 2:i=3;break;case 3:i=4;break;default:i=1}if(o<i&&(i=o),i>2&&o>i){for(var s=i,r=0,n=i;s>=2;){var h=o%s;if(0==h){n=s;break}var g=h/s;g>r&&(r=g,n=s),s--}i=n}var d,c=this.getAggregation(\"month\");i>1?(d=100/i+\"%\",this.$(\"content\").removeClass(\"sapUiCalContentSingle\")):(d=\"100%\",this.$(\"content\").addClass(\"sapUiCalContentSingle\"));for(var l=0;l<c.length;l++){c[l].setWidth(d)}}}}function b(e){var t=new h(e,this.getPrimaryCalendarType());t.setDate(1);var a=m.call(this);if(a<=12){var i=e.getMonth();i-=i%a,12%a>0&&i+a>11&&(i=12-a),t.setMonth(i)}return t}var C=t.extend(\"sap.ui.unified.Calendar\",{metadata:{library:\"sap.ui.unified\",designtime:\"sap/ui/unified/designtime/Calendar.designtime\",properties:{intervalSelection:{type:\"boolean\",group:\"Behavior\",defaultValue:!1},singleSelection:{type:\"boolean\",group:\"Behavior\",defaultValue:!0},months:{type:\"int\",group:\"Appearance\",defaultValue:1},firstDayOfWeek:{type:\"int\",group:\"Appearance\",defaultValue:-1},nonWorkingDays:{type:\"int[]\",group:\"Appearance\",defaultValue:null},primaryCalendarType:{type:\"sap.ui.core.CalendarType\",group:\"Appearance\",defaultValue:null},secondaryCalendarType:{type:\"sap.ui.core.CalendarType\",group:\"Appearance\",defaultValue:null},width:{type:\"sap.ui.core.CSSSize\",group:\"Dimension\",defaultValue:null},minDate:{type:\"object\",group:\"Misc\",defaultValue:null},maxDate:{type:\"object\",group:\"Misc\",defaultValue:null},showWeekNumbers:{type:\"boolean\",group:\"Appearance\",defaultValue:!0}},aggregations:{selectedDates:{type:\"sap.ui.unified.DateRange\",multiple:!0,singularName:\"selectedDate\"},specialDates:{type:\"sap.ui.unified.DateTypeRange\",multiple:!0,singularName:\"specialDate\"},disabledDates:{type:\"sap.ui.unified.DateRange\",multiple:!0,singularName:\"disabledDate\"},header:{type:\"sap.ui.unified.calendar.Header\",multiple:!1,visibility:\"hidden\"},month:{type:\"sap.ui.unified.calendar.Month\",multiple:!0,visibility:\"hidden\"},monthPicker:{type:\"sap.ui.unified.calendar.MonthPicker\",multiple:!1,visibility:\"hidden\"},yearPicker:{type:\"sap.ui.unified.calendar.YearPicker\",multiple:!1,visibility:\"hidden\"}},associations:{ariaLabelledBy:{type:\"sap.ui.core.Control\",multiple:!0,singularName:\"ariaLabelledBy\"},legend:{type:\"sap.ui.unified.CalendarLegend\",multiple:!1}},events:{select:{},cancel:{},startDateChange:{}}}});return C.prototype.init=function(){this._iBreakPointTablet=d.media._predefinedRangeSets[d.media.RANGESETS.SAP_STANDARD_EXTENDED].points[0],this._iBreakPointDesktop=d.media._predefinedRangeSets[d.media.RANGESETS.SAP_STANDARD_EXTENDED].points[1],this._iBreakPointLargeDesktop=d.media._predefinedRangeSets[d.media.RANGESETS.SAP_STANDARD_EXTENDED].points[2];var t=sap.ui.getCore().getConfiguration().getCalendarType();this.setProperty(\"primaryCalendarType\",t),this.setProperty(\"secondaryCalendarType\",t),this._iMode=0,this._oYearFormat=c.getDateInstance({format:\"y\",calendarType:t}),this.data(\"sap-ui-fastnavgroup\",\"true\",!0),this._oMinDate=i._minDate(this.getPrimaryCalendarType()),this._oMaxDate=i._maxDate(this.getPrimaryCalendarType()),this._initializeHeader();var a=this._createMonth(this.getId()+\"--Month0\");a.attachEvent(\"focus\",this._handleFocus,this),a.attachEvent(\"select\",v,this),a.attachEvent(\"_renderMonth\",y,this),a.attachEvent(\"_bindMousemove\",M,this),a.attachEvent(\"_unbindMousemove\",P,this),a._bNoThemeChange=!0,this.addAggregation(\"month\",a),this._initilizeMonthPicker(),this._initilizeYearPicker(),this._resizeProxy=e.proxy(S,this),this._oSelectedMonth},C.prototype._createHeader=function(e){return new o(e)},C.prototype.exit=function(){this._sInvalidateMonth&&e.sap.clearDelayedCall(this._sInvalidateMonth),this._sResizeListener&&(l.deregister(this._sResizeListener),this._sResizeListener=void 0),this._oSelectedMonth=null},C.prototype._initializeHeader=function(){var e=this._createHeader(this.getId()+\"--Head\");e.attachEvent(\"pressPrevious\",this._handlePrevious,this),e.attachEvent(\"pressNext\",this._handleNext,this),e.attachEvent(\"pressButton1\",this._handleButton1,this),e.attachEvent(\"pressButton2\",this._handleButton2,this),this.setAggregation(\"header\",e)},C.prototype._initilizeMonthPicker=function(){var e=new r(this.getId()+\"--MP\");e.attachEvent(\"select\",this._selectMonth,this),e._bNoThemeChange=!0,this.setAggregation(\"monthPicker\",e)},C.prototype._initilizeYearPicker=function(){var e=new n(this.getId()+\"--YP\");e.attachEvent(\"select\",this._selectYear,this),this.setAggregation(\"yearPicker\",e)},C.prototype._createMonth=function(e){var t=new s(e);return t.attachEvent(\"datehovered\",this._handleDateHovered,this),t},C.prototype._handleDateHovered=function(e){var t,a=this.getAggregation(\"month\"),i=e.getParameter(\"date1\"),o=e.getParameter(\"date2\");for(t=0;t<a.length;t++)a[t]._markDatesBetweenStartAndHoveredDate(i,o)},C.prototype.onBeforeRendering=function(){var e,t=this.getAggregation(\"month\"),a=t[0].getDate(),i=this._getFocusedDate();e=t.length>1&&a?h.fromLocalJSDate(a,this.getPrimaryCalendarType()):t.length>1?b.call(this,this._getFocusedDate()):i;for(var o=0;o<t.length;o++){a=new h(e),o>0&&(a.setDate(1),a.setMonth(a.getMonth()+o));var s=a;i.getYear()===a.getYear()&&i.getMonth()===a.getMonth()&&(s=i),t[o].displayDate(s.toLocalJSDate()),t[o].setShowWeekNumbers(this.getShowWeekNumbers())}this._updateHeader(e),this._iSize=0},C.prototype.onAfterRendering=function(e){this._getSucessorsPickerPopup()||D.call(this),(m.call(this)>1||this._bInitMonth)&&(e.size={width:this.getDomRef().offsetWidth},S.call(this,e,!0),this._sResizeListener||(this._sResizeListener=l.register(this,this._resizeProxy)),this._bInitMonth=void 0)},C.prototype.invalidate=function(a){this._bDateRangeChanged||a&&a instanceof sap.ui.unified.DateRange?this.getDomRef()&&0==this._iMode&&!this._sInvalidateMonth&&(this._sInvalidateMonth=e.sap.delayedCall(0,this,this._invalidateMonth,[a])):t.prototype.invalidate.apply(this,arguments)},C.prototype.removeSelectedDate=function(e){return this._bDateRangeChanged=!0,this.removeAggregation(\"selectedDates\",e)},C.prototype.removeAllSelectedDates=function(){return this._bDateRangeChanged=!0,this.removeAllAggregation(\"selectedDates\")},C.prototype.destroySelectedDates=function(){return this._bDateRangeChanged=!0,this.destroyAggregation(\"selectedDates\")},C.prototype.removeAllSpecialDates=function(){return this._bDateRangeChanged=!0,this.removeAllAggregation(\"specialDates\")},C.prototype.destroySpecialDates=function(){return this._bDateRangeChanged=!0,this.destroyAggregation(\"specialDates\")},C.prototype.getSpecialDates=function(){var e=this.getParent();return e&&e.getSpecialDates?e.getSpecialDates():this.getAggregation(\"specialDates\",[])},C.prototype.removeAllDisabledDates=function(){return this._bDateRangeChanged=!0,this.removeAllAggregation(\"disabledDates\")},C.prototype.destroyDisabledDates=function(){return this._bDateRangeChanged=!0,this.destroyAggregation(\"disabledDates\")},C.prototype.setLocale=function(e){return this._sLocale!=e&&(this._sLocale=e,this._oLocaleData=void 0,this.invalidate()),this},C.prototype.getLocale=function(){return this._sLocale||(this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString()),this._sLocale},C.prototype._getFocusedDate=function(){return this._oFocusedDate||_.call(this),this._oFocusedDate},C.prototype._setFocusedDate=function(e){i._checkCalendarDate(e),this._oFocusedDate=new h(e,this.getPrimaryCalendarType())},C.prototype.focusDate=function(e){return f.call(this,e,!1),this},C.prototype.displayDate=function(e){return f.call(this,e,!0),this},C.prototype.getStartDate=function(){var e;if(this.getDomRef()){var t=this.getAggregation(\"month\");e=h.fromLocalJSDate(t[0].getDate(),this.getPrimaryCalendarType())}else e=new h(this._getFocusedDate());return e.setDate(1),e.toLocalJSDate()},C.prototype.setPopupMode=function(e){return this._bPoupupMode=e,this},C.prototype.setMonths=function(e){this._bDateRangeChanged=void 0,this.setProperty(\"months\",e,!1),e=m.call(this);var t,a=this.getAggregation(\"month\"),i=0;if(a.length<e)for(i=a.length;i<e;i++)t=this._createMonth(this.getId()+\"--Month\"+i),t.attachEvent(\"focus\",this._handleFocus,this),t.attachEvent(\"select\",v,this),t.attachEvent(\"_renderMonth\",y,this),t.attachEvent(\"_bindMousemove\",M,this),t.attachEvent(\"_unbindMousemove\",P,this),t._bNoThemeChange=!0,this.addAggregation(\"month\",t);else if(a.length>e){for(i=a.length;i>e;i--)t=this.removeAggregation(\"month\",i-1),t.destroy();1==e&&(this._bInitMonth=!0)}return e>1&&a[0].getDate()&&a[0].setProperty(\"date\",null,!0),this},C.prototype.setPrimaryCalendarType=function(e){var t=this.getAggregation(\"month\"),a=!1;t.length>1&&(a=!0),this.setProperty(\"primaryCalendarType\",e,!a),this._oYearFormat=c.getDateInstance({format:\"y\",calendarType:e}),this._oFocusedDate&&(this._oFocusedDate=new h(this._oFocusedDate,e)),this._oMinDate=new h(this._oMinDate,e),this._oMaxDate=new h(this._oMaxDate,e);for(var i=0;i<t.length;i++){t[i].setPrimaryCalendarType(e)}if(!this._getSucessorsPickerPopup()){var o=this.getAggregation(\"monthPicker\");o.setPrimaryCalendarType(e);var s=this.getAggregation(\"yearPicker\");s.setPrimaryCalendarType(e)}return this.getDomRef()&&(this._updateHeader(this._oFocusedDate),this._getSucessorsPickerPopup()||(1!=this.iMode&&o.getDomRef()&&o.$().remove(),2!=this.iMode&&s.getDomRef()&&s.$().remove())),this},C.prototype.setSecondaryCalendarType=function(e){this._bSecondaryCalendarTypeSet=!0,this.setProperty(\"secondaryCalendarType\",e,!0),this._oYearFormatSecondary=c.getDateInstance({format:\"y\",calendarType:e});for(var t=this.getAggregation(\"month\"),a=0;a<t.length;a++){t[a].setSecondaryCalendarType(e)}return this.getDomRef()&&(this._updateHeader(this._getFocusedDate()),this.$().toggleClass(\"sapUiCalSecType\",!!this._getSecondaryCalendarType())),this},C.prototype._getSecondaryCalendarType=function(){var e;if(this._bSecondaryCalendarTypeSet){e=this.getSecondaryCalendarType();e==this.getPrimaryCalendarType()&&(e=void 0)}return e},C.prototype.setMinDate=function(t){if(e.sap.equal(t,this.getMinDate()))return this;if(t){i._checkJSDateObject(t),this._oMinDate=h.fromLocalJSDate(t,this.getPrimaryCalendarType());var a=this._oMinDate.getYear();i._checkYearInValidRange(a),this._oMaxDate.isBefore(this._oMinDate)&&(e.sap.log.warning(\"minDate > maxDate -> maxDate set to end of the month\",this),this._oMaxDate=h.fromLocalJSDate(t,this.getPrimaryCalendarType()),this._oMaxDate.setDate(i._daysInMonth(this._oMaxDate)),this.setProperty(\"maxDate\",this._oMaxDate.toLocalJSDate(),!0)),this._setMinMaxDateExtend(h.fromLocalJSDate(t,this.getPrimaryCalendarType()))}else this._oMinDate=i._minDate(this.getPrimaryCalendarType());if(this.setProperty(\"minDate\",t,!1),!this._getSucessorsPickerPopup()){this.getAggregation(\"yearPicker\")._oMinDate.setYear(this._oMinDate.getYear())}return this},C.prototype.setMaxDate=function(t){if(e.sap.equal(t,this.getMaxDate()))return this;if(t){i._checkJSDateObject(t),this._oMaxDate=h.fromLocalJSDate(t,this.getPrimaryCalendarType());var a=this._oMaxDate.getYear();i._checkYearInValidRange(a),this._oMinDate.isAfter(this._oMaxDate)&&(e.sap.log.warning(\"maxDate < minDate -> minDate set to begin of the month\",this),this._oMinDate=h.fromLocalJSDate(t,this.getPrimaryCalendarType()),this._oMinDate.setDate(1),this.setProperty(\"minDate\",this._oMinDate.toLocalJSDate(),!0)),this._setMinMaxDateExtend(h.fromLocalJSDate(t,this.getPrimaryCalendarType()))}else this._oMaxDate=i._maxDate(this.getPrimaryCalendarType());if(this.setProperty(\"maxDate\",t,!1),!this._getSucessorsPickerPopup()){this.getAggregation(\"yearPicker\")._oMaxDate.setYear(this._oMaxDate.getYear())}return this},C.prototype._setMinMaxDateExtend=function(t){this._oFocusedDate&&i._isOutside(this._oFocusedDate,this._oMinDate,this._oMaxDate)&&(e.sap.log.warning(\"focused date is not between [minDate - maxDate] -> refocus to the new max/min date: \"+t.toString(),this),this.focusDate(t.toLocalJSDate()))},C.prototype._getLocaleData=function(){if(!this._oLocaleData){var e=this.getLocale(),t=new p(e);this._oLocaleData=a.getInstance(t)}return this._oLocaleData},C.prototype._getShowMonthHeader=function(){return m.call(this)>2},C.prototype.setWidth=function(e){return this.setProperty(\"width\",e,!0),this.getDomRef()&&(e=this.getWidth(),this.$().css(\"width\",e),e?this.$().addClass(\"sapUiCalWidth\"):this.$().removeClass(\"sapUiCalWidth\")),this},C.prototype.onclick=function(e){e.isMarked(\"delayedMouseEvent\")||e.target.id==this.getId()+\"-cancel\"&&this.onsapescape(e)},C.prototype.onmousedown=function(e){e.preventDefault(),e.setMark(\"cancelAutoClose\")},C.prototype.onsapescape=function(e){0==this._iMode&&this.fireCancel(),this._closedPickers()},C.prototype.onsapshow=function(e){this._bPoupupMode&&(this._closedPickers(),this.fireCancel(),e.preventDefault())},C.prototype.onsaphide=C.prototype.onsapshow,C.prototype.onsaptabnext=function(t){var a=this.getAggregation(\"header\");if(e.sap.containsOrEquals(this.getDomRef(\"content\"),t.target)){if(this._shouldFocusB2OnTabNext(t)?e.sap.focus(a.getDomRef(\"B2\")):e.sap.focus(a.getDomRef(\"B1\")),!this._bPoupupMode){for(var i=this.getAggregation(\"month\"),o=0;o<i.length;o++){var s=i[o];e(s._oItemNavigation.getItemDomRefs()[s._oItemNavigation.getFocusedIndex()]).attr(\"tabindex\",\"-1\")}if(!this._getSucessorsPickerPopup()){var r=this.getAggregation(\"monthPicker\"),n=this.getAggregation(\"yearPicker\");r.getDomRef()&&e(r._oItemNavigation.getItemDomRefs()[r._oItemNavigation.getFocusedIndex()]).attr(\"tabindex\",\"-1\"),n.getDomRef()&&e(n._oItemNavigation.getItemDomRefs()[n._oItemNavigation.getFocusedIndex()]).attr(\"tabindex\",\"-1\")}}t.preventDefault()}else this._shouldFocusB2OnTabNext(t)&&(e.sap.focus(a.getDomRef(\"B2\")),t.preventDefault())},C.prototype._shouldFocusB2OnTabNext=function(e){var t=this.getAggregation(\"header\");return e.target.id==t.getId()+\"-B1\"},C.prototype._shouldFocusB2OnTabPrevious=function(e){return this._bPoupupMode},C.prototype.onsaptabprevious=function(t){var a=this.getAggregation(\"header\");if(e.sap.containsOrEquals(this.getDomRef(\"content\"),t.target))this._shouldFocusB2OnTabPrevious()&&(e.sap.focus(a.getDomRef(\"B2\")),t.preventDefault());else if(t.target.id==a.getId()+\"-B1\"){var i,o=this.getAggregation(\"month\");switch(this._iMode){case 0:i=this._getFocusedDate();for(var s=0;s<o.length;s++){var r=o[s],n=h.fromLocalJSDate(r.getDate(),this.getPrimaryCalendarType());i.isSame(n)?r._oItemNavigation.focusItem(r._oItemNavigation.getFocusedIndex()):e(r._oItemNavigation.getItemDomRefs()[r._oItemNavigation.getFocusedIndex()]).attr(\"tabindex\",\"0\")}break;case 1:if(!this._getSucessorsPickerPopup()){var g=this.getAggregation(\"monthPicker\");g._oItemNavigation.focusItem(g._oItemNavigation.getFocusedIndex())}break;case 2:if(!this._getSucessorsPickerPopup()){var d=this.getAggregation(\"yearPicker\");d._oItemNavigation.focusItem(d._oItemNavigation.getFocusedIndex())}}t.preventDefault()}else t.target.id==a.getId()+\"-B2\"&&(e.sap.focus(a.getDomRef(\"B1\")),t.preventDefault())},C.prototype.onfocusin=function(t){if(t.target.id==this.getId()+\"-end\"){var a=this.getAggregation(\"month\");if(this._focusOnShiftTab(),!this._bPoupupMode){for(var i=0;i<a.length;i++){var o=a[i];e(o._oItemNavigation.getItemDomRefs()[o._oItemNavigation.getFocusedIndex()]).attr(\"tabindex\",\"-1\")}if(!this._getSucessorsPickerPopup()){var s=this.getAggregation(\"monthPicker\"),r=this.getAggregation(\"yearPicker\");s.getDomRef()&&e(s._oItemNavigation.getItemDomRefs()[s._oItemNavigation.getFocusedIndex()]).attr(\"tabindex\",\"-1\"),r.getDomRef()&&e(r._oItemNavigation.getItemDomRefs()[r._oItemNavigation.getFocusedIndex()]).attr(\"tabindex\",\"-1\")}}}this.$(\"end\").attr(\"tabindex\",\"-1\")},C.prototype._focusOnShiftTab=function(){var t=this.getAggregation(\"header\");e.sap.focus(t.getDomRef(\"B2\"))},C.prototype.onsapfocusleave=function(t){var a,i,o,s;if(!(t.relatedControlId&&e.sap.containsOrEquals(this.getDomRef(),sap.ui.getCore().byId(t.relatedControlId).getFocusDomRef())||(this.$(\"end\").attr(\"tabindex\",\"0\"),this._bPoupupMode)))switch(a=this.getAggregation(\"month\"),this._iMode){case 0:for(var r=0;r<a.length;r++)i=a[r],e(i._oItemNavigation.getItemDomRefs()[i._oItemNavigation.getFocusedIndex()]).attr(\"tabindex\",\"0\");break;case 1:this._getSucessorsPickerPopup()||(o=this.getAggregation(\"monthPicker\"),e(o._oItemNavigation.getItemDomRefs()[o._oItemNavigation.getFocusedIndex()]).attr(\"tabindex\",\"0\"));break;case 2:this._getSucessorsPickerPopup()||(s=this.getAggregation(\"yearPicker\"),e(s._oItemNavigation.getItemDomRefs()[s._oItemNavigation.getFocusedIndex()]).attr(\"tabindex\",\"0\"))}},C.prototype.getFocusDomRef=function(){var e=this._oSelectedMonth?this._oSelectedMonth:this.getAggregation(\"month\")[0];return e._oItemNavigation.getItemDomRefs()[e._oItemNavigation.getFocusedIndex()]},C.prototype.onThemeChanged=function(){var e;if(this.getDomRef()){this._bNamesLengthChecked=void 0,this._getSucessorsPickerPopup()||(e=this.getAggregation(\"monthPicker\"),this._showMonthPicker(!0),e._bNoThemeChange=!1,e.onThemeChanged(arguments),e._bNoThemeChange=!0,this._bLongMonth=e._bLongMonth,this._hideMonthPicker(!0));for(var t=this.getAggregation(\"month\"),a=0;a<t.length;a++){var i=t[a];i._bNoThemeChange=!1,i.onThemeChanged(arguments),i._bNoThemeChange=!0}var o;o=t.length>1?h.fromLocalJSDate(t[0].getDate(),this.getPrimaryCalendarType()):this._getFocusedDate(),this._setHeaderText(o),this._getSucessorsPickerPopup()||D.call(this)}},C.prototype._updateHeader=function(e){this._setHeaderText(e),this._togglePrevNext(e,!0)},C.prototype._togglePrevNext=function(e,t){var a=this._oMaxDate.getYear(),o=this._oMinDate.getYear(),s=this._oMaxDate.getMonth(),r=this._oMinDate.getMonth(),n=this.getAggregation(\"header\"),g=m.call(this),d=new h(e,this.getPrimaryCalendarType());0==this._iMode&&g>1?(d=b.call(this,e),d.setMonth(d.getMonth()+g-1),d.setDate(i._daysInMonth(d))):d.setDate(i._daysInMonth(d));var c=d.getYear(),l=d.getMonth();c>a||c==a&&(!t||l>=s)||1==this._iMode&&this._getSucessorsPickerPopup()?n.setEnabledNext(!1):n.setEnabledNext(!0),0==this._iMode&&g>1?(d.setMonth(d.getMonth()-g+1),d.setDate(1)):d.setDate(1),c=d.getYear(),l=d.getMonth(),c<o||c==o&&(!t||l<=r)||1==this._iMode&&this._getSucessorsPickerPopup()?n.setEnabledPrevious(!1):n.setEnabledPrevious(!0)},C.prototype._togglePrevNexYearPicker=function(){var e=this.getAggregation(\"yearPicker\"),t=e.getYears(),a=h.fromLocalJSDate(e.getFirstRenderedDate());a.setYear(a.getYear()+Math.floor(t/2));var i=this.getAggregation(\"header\"),o=new h(this._oMaxDate,this.getPrimaryCalendarType());o.setYear(o.getYear()-Math.ceil(t/2)),o.setMonth(11),o.setDate(31);var s=new h(this._oMinDate,this.getPrimaryCalendarType());s.setYear(s.getYear()+Math.floor(t/2)+1),s.setMonth(0),s.setDate(1),i.setEnabledNext(a.isSameOrBefore(o)),i.setEnabledPrevious(a.isSameOrAfter(s))},C.prototype._handlePrevious=function(e){var t,a,i=this._getFocusedDate(),o=this.getAggregation(\"header\"),s=this.getAggregation(\"yearPicker\"),r=m.call(this);switch(this._iMode){case 0:r>1?(t=h.fromLocalJSDate(this.getAggregation(\"month\")[0].getDate(),this.getPrimaryCalendarType()),t.setDate(1),this._setFocusedDate(t),i=this._getFocusedDate()):i.setDate(1),i.setDate(i.getDate()-1),this._renderMonth(!1,!0);break;case 1:i.setYear(i.getYear()-1),o.setTextButton2(this._oYearFormat.format(i.toUTCJSDate(),!0)),o.setAriaLabelButton1(this._oYearFormat.format(i.toUTCJSDate(),!0));var n=this._getSecondaryCalendarType();n?(a=new h(i,n),a.setMonth(0),a.setDate(1),o.setAdditionalTextButton2(this._oYearFormatSecondary.format(a.toUTCJSDate(),!0))):o.setAdditionalTextButton2(),this._togglePrevNext(i),this._setDisabledMonths(i.getYear());break;case 2:s.previousPage(),this._togglePrevNexYearPicker()}},C.prototype._handleNext=function(e){var t,a,i=this._getFocusedDate(),o=this.getAggregation(\"header\"),s=this.getAggregation(\"yearPicker\"),r=m.call(this);switch(this._iMode){case 0:r>1&&(t=h.fromLocalJSDate(this.getAggregation(\"month\")[0].getDate(),this.getPrimaryCalendarType()),this._setFocusedDate(t),i=this._getFocusedDate()),i.setDate(1),i.setMonth(i.getMonth()+r),this._renderMonth();break;case 1:i.setYear(i.getYear()+1),o.setTextButton2(this._oYearFormat.format(i.toUTCJSDate(),!0)),o.setAriaLabelButton1(this._oYearFormat.format(i.toUTCJSDate(),!0));var n=this._getSecondaryCalendarType();n?(a=new h(i,n),a.setMonth(0),a.setDate(1),o.setAdditionalTextButton2(this._oYearFormatSecondary.format(a.toUTCJSDate(),!0))):o.setAdditionalTextButton2(),this._togglePrevNext(i),this._setDisabledMonths(i.getYear());break;case 2:s.nextPage(),this._togglePrevNexYearPicker()}},C.prototype._getDisplayedMonths=function(e){var t=[],a=e.getMonth(),i=m.call(this);if(i>1)for(var o=0;o<i;o++)t.push((a+o)%12);else t.push(a);return t},C.prototype._getDisplayedSecondaryMonths=function(e,t){var a=this.getAggregation(\"month\"),o=h.fromLocalJSDate(a[0].getDate(),e);o.setDate(1),o=new h(o,t);var s=o.getMonth(),r=h.fromLocalJSDate(a[a.length-1].getDate(),e);return r.setDate(i._daysInMonth(r)),r=new h(r,t),{start:s,end:r.getMonth()}},C.prototype._closedPickers=function(){switch(this._iMode){case 0:break;case 1:this._hideMonthPicker();break;case 2:this._hideYearPicker()}},C.prototype._setDisabledMonths=function(e,t){var a=0,i=11;e==this._oMinDate.getYear()&&(a=this._oMinDate.getMonth()),e==this._oMaxDate.getYear()&&(i=this._oMaxDate.getMonth()),t||(t=this.getAggregation(\"monthPicker\")),t.setMinMax(a,i)},C.prototype._renderMonth=function(e,t,a){_renderMonth.call(this,e,t,a)},C.prototype._handleFocus=function(t){var a=h.fromLocalJSDate(t.getParameter(\"date\"),this.getPrimaryCalendarType()),i=t.getParameter(\"otherMonth\");t.getParameter(\"restoreOldDate\")?e.sap.equal(this._getFocusedDate(),a)||this._renderMonth(!1,!1,!0):this._focusDate(a,i)},C.prototype._getVisibleDays=function(){var e=this.getAggregation(\"month\")[0];return e._getVisibleDays(e._getDate(),!1)},C.prototype._renderMonth=function(e,t,a){var o,s,r,n=this._getFocusedDate(),g=this.getAggregation(\"month\"),d=!1,c=0;for(c=0;c<g.length;c++)if(o=g[c],o.checkDateFocusable(n.toLocalJSDate())&&(d=!0),d||1==g.length){e?o.displayDate(n.toLocalJSDate()):o.setDate(n.toLocalJSDate());break}if(!d){if(r=new h(n,this.getPrimaryCalendarType()),g.length>1)for(r=b.call(this,r),c=0;c<g.length;c++)o=g[c],s=new h(r,this.getPrimaryCalendarType()),s.setMonth(r.getMonth()+c),!e&&i._isSameMonthAndYear(s,n)?o.setDate(n.toLocalJSDate()):o.displayDate(s.toLocalJSDate());this._updateHeader(r),a||this.fireStartDateChange()}},C.prototype._showMonthPicker=function(t){2==this._iMode&&this._hideYearPicker(!0);var a=this._getFocusedDate(),i=this.getAggregation(\"monthPicker\");if(i.getDomRef())i.$().css(\"display\",\"\");else{var o=sap.ui.getCore().createRenderManager(),s=this.$(\"content\");o.renderControl(i),o.flush(s[0],!1,!0),o.destroy()}if(this._showOverlay(),!t&&(i.setMonth(a.getMonth()),this._setDisabledMonths(a.getYear(),i),0==this._iMode))for(var r=this.getAggregation(\"month\"),n=0;n<r.length;n++){var h=r[n];e(h._oItemNavigation.getItemDomRefs()[h._oItemNavigation.getFocusedIndex()]).attr(\"tabindex\",\"-1\")}this._iMode=1,this._togglePrevNext(a,!1)},C.prototype._hideMonthPicker=function(t){if(this._iMode=0,this.getAggregation(\"monthPicker\").$().css(\"display\",\"none\"),this._hideOverlay(),!t&&(this._renderMonth(),m.call(this)>1))for(var a=this.getAggregation(\"month\"),i=0;i<a.length;i++){var o=a[i];e(o._oItemNavigation.getItemDomRefs()[o._oItemNavigation.getFocusedIndex()]).attr(\"tabindex\",\"0\")}this._togglePrevNext(this._getFocusedDate(),!0)},C.prototype._showYearPicker=function(){1==this._iMode&&this._hideMonthPicker(!0);var t=this._getFocusedDate(),a=this.getAggregation(\"yearPicker\");if(a.getDomRef())a.$().css(\"display\",\"\");else{var i=sap.ui.getCore().createRenderManager(),o=this.$(\"content\");i.renderControl(a),i.flush(o[0],!1,!0),i.destroy()}this._showOverlay(),a.setDate(t.toLocalJSDate());var s;if(1==m.call(this)){s=this.getAggregation(\"month\")[0];28==s.$(\"days\").find(\".sapUiCalItem\").length?a.$().addClass(\"sapUiCalYearNoTop\"):a.$().removeClass(\"sapUiCalYearNoTop\")}if(0==this._iMode)for(var r=this.getAggregation(\"month\"),n=0;n<r.length;n++)s=r[n],e(s._oItemNavigation.getItemDomRefs()[s._oItemNavigation.getFocusedIndex()]).attr(\"tabindex\",\"-1\");this._togglePrevNexYearPicker(),this._iMode=2},C.prototype._hideYearPicker=function(t){if(this._iMode=0,this.getAggregation(\"yearPicker\").$().css(\"display\",\"none\"),this._hideOverlay(),!t&&(this._renderMonth(),m.call(this)>1))for(var a=this.getAggregation(\"month\"),i=0;i<a.length;i++){var o=a[i];e(o._oItemNavigation.getItemDomRefs()[o._oItemNavigation.getFocusedIndex()]).attr(\"tabindex\",\"0\")}this._togglePrevNext(this._getFocusedDate(),!0)},C.prototype._focusDate=function(e,t,a){var i,o=!1,s=!1;e.isBefore(this._oMinDate)?(i=this._oMinDate,o=!0):e.isAfter(this._oMaxDate)?(i=this._oMaxDate,o=!0):i=e,this._focusDateExtend&&(s=this._focusDateExtend(e,t,a));var r=i.isBefore(this._getFocusedDate());this._setFocusedDate(i),(o||t)&&this._renderMonth(!1,r,a),s&&this.fireStartDateChange()},C.prototype._invalidateMonth=function(e){this._sInvalidateMonth=void 0;var t=this.getAggregation(\"month\");if(t)for(var a=0;a<t.length;a++){var i=t[a];i._bDateRangeChanged=!0,i._bInvalidateSync=!0,i._bNoFocus=!0,i.invalidate(e),i._bInvalidateSync=void 0}this._bDateRangeChanged=void 0},C.prototype._setHeaderText=function(e){var t,a,i,o,s=this.getAggregation(\"header\"),r=this._getLocaleData(),n=[],g=[],d=[],c=!1,l=this.getPrimaryCalendarType(),p=this._getSecondaryCalendarType();if(this._bLongMonth||!this._bNamesLengthChecked?n=r.getMonthsStandAlone(\"wide\",l):(c=!0,n=r.getMonthsStandAlone(\"abbreviated\",l),g=r.getMonthsStandAlone(\"wide\",l)),p){d=r.getMonthsStandAlone(\"abbreviated\",p);var u=this._getDisplayedSecondaryMonths(l,p);u.start==u.end?a=d[u.start]:(o=r.getIntervalPattern(),a=o.replace(/\\{0\\}/,d[u.start]).replace(/\\{1\\}/,d[u.end]))}s.setAdditionalTextButton1(a);var _=this._getDisplayedMonths(e);_.length>1&&!this._bShowOneMonth?(o||(o=r.getIntervalPattern()),n=r.getMonthsStandAlone(\"abbreviated\",l),a=o.replace(/\\{0\\}/,n[_[0]]).replace(/\\{1\\}/,n[_[_.length-1]]),t=g.length?o.replace(/\\{0\\}/,g[_[0]]).replace(/\\{1\\}/,g[_[_.length-1]]):a):(a=n[_[0]],t=g[_[0]]||a),s.setTextButton1(a),s.setAriaLabelButton1(t);var D=new h(e,l);return D.setDate(1),i=this._oYearFormat.format(D.toUTCJSDate(),!0),s.setTextButton2(i),s.setAriaLabelButton2(i),p?(D=new h(D,p),s.setAdditionalTextButton2(this._oYearFormatSecondary.format(D.toUTCJSDate(),!0))):s.setAdditionalTextButton2(),{sMonth:a,sYear:i,sAriaLabel:t,bShort:c}},C.prototype._handleButton1=function(e){1!=this._iMode?this._showMonthPicker():this._hideMonthPicker()},C.prototype._handleButton2=function(e){2!=this._iMode?this._showYearPicker():this._hideYearPicker()},C.prototype._selectMonth=function(){var e=new h(this._getFocusedDate(),this.getPrimaryCalendarType()),t=this.getAggregation(\"monthPicker\"),a=t.getMonth();e.setMonth(a),a!=e.getMonth()&&e.setDate(0),this._focusDate(e,!0),this._hideMonthPicker()},C.prototype._getSucessorsPickerPopup=function(){return this.getPickerPopup&&this.getPickerPopup()},C.prototype._selectYear=function(){var e=new h(this._getFocusedDate(),this.getPrimaryCalendarType()),t=this.getAggregation(\"yearPicker\"),a=h.fromLocalJSDate(t.getDate(),this.getPrimaryCalendarType());a.setMonth(e.getMonth()),a.setDate(e.getDate()),e=a,this._focusDate(e,!0),this._hideYearPicker()},C.prototype._showOverlay=function(){this.$(\"contentOver\").css(\"display\",\"\")},C.prototype._hideOverlay=function(){this.$(\"contentOver\").css(\"display\",\"none\")},C});",
	"sap/ui/unified/calendar/CalendarDate.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"sap/ui/base/Object\",\"sap/ui/core/date/UniversalDate\"],function(t,e){\"use strict\";function a(t,a){return a?e.getInstance(n(t),a):new e(n(t).getTime())}function n(t){var e=new Date(Date.UTC(0,0,1));return e.setUTCFullYear(t.getFullYear(),t.getMonth(),t.getDate()),e}function r(t){if(!(t instanceof i))throw\"Invalid calendar date: [\"+t+\"]. Expected: sap.ui.unified.calendar.CalendarDate\"}function o(t,e){if(void 0==t||t===1/0||isNaN(t))throw e}var i=t.extend(\"sap.ui.unified.calendar.CalendarDate\",{constructor:function(){var t,e,n,r=arguments;switch(r.length){case 0:return e=new Date,this.constructor(e.getFullYear(),e.getMonth(),e.getDate());case 1:case 2:if(!(r[0]instanceof i))throw\"Invalid arguments: the first argument must be of type sap.ui.unified.calendar.CalendarDate.\";n=r[1]?r[1]:r[0]._oUDate.sCalendarType,t=new Date(r[0].valueOf()),t.setFullYear(t.getUTCFullYear(),t.getUTCMonth(),t.getUTCDate()),t.setHours(t.getUTCHours(),t.getUTCMinutes(),t.getUTCSeconds(),t.getUTCMilliseconds()),this._oUDate=a(t,n);break;case 3:case 4:o(r[0],\"Invalid year: \"+r[0]),o(r[1],\"Invalid month: \"+r[1]),o(r[2],\"Invalid date: \"+r[2]),t=new Date(0,0,1),t.setFullYear(r[0],r[1],r[2]),r[3]&&(n=r[3]),this._oUDate=a(t,n);break;default:throw\"Invalid arguments. Accepted arguments are: 1) oCalendarDate, (optional)calendarTypeor 2) year, month, date, (optional) calendarType\"+r}}});return i.prototype.getYear=function(){return this._oUDate.getUTCFullYear()},i.prototype.setYear=function(t){return o(t,\"Invalid year: \"+t),this._oUDate.setUTCFullYear(t),this},i.prototype.getMonth=function(){return this._oUDate.getUTCMonth()},i.prototype.setMonth=function(t){return o(t,\"Invalid month: \"+t),this._oUDate.setUTCMonth(t),this},i.prototype.getDate=function(){return this._oUDate.getUTCDate()},i.prototype.setDate=function(t){return o(t,\"Invalid date: \"+t),this._oUDate.setUTCDate(t),this},i.prototype.getDay=function(){return this._oUDate.getUTCDay()},i.prototype.getCalendarType=function(){return this._oUDate.sCalendarType},i.prototype.isBefore=function(t){return r(t),this.valueOf()<t.valueOf()},i.prototype.isAfter=function(t){return r(t),this.valueOf()>t.valueOf()},i.prototype.isSameOrBefore=function(t){return r(t),this.valueOf()<=t.valueOf()},i.prototype.isSameOrAfter=function(t){return r(t),this.valueOf()>=t.valueOf()},i.prototype.isSame=function(t){return r(t),this.valueOf()===t.valueOf()},i.prototype.toLocalJSDate=function(){var t=new Date(this._oUDate.getTime());return t.setFullYear(t.getUTCFullYear(),t.getUTCMonth(),t.getUTCDate()),t.setHours(0,0,0,0),t},i.prototype.toUTCJSDate=function(){var t=new Date(this._oUDate.getTime());return t.setUTCHours(0,0,0,0),t},i.prototype.toString=function(){return this._oUDate.sCalendarType+\": \"+this.getYear()+\"/\"+(this.getMonth()+1)+\"/\"+this.getDate()},i.prototype.valueOf=function(){return this._oUDate.getTime()},i.fromLocalJSDate=function(t,e){if(\"date\"!==jQuery.type(t))throw new Error(\"Date parameter must be a JavaScript Date object: [\"+t+\"].\");return new i(t.getFullYear(),t.getMonth(),t.getDate(),e)},i});",
	"sap/ui/unified/calendar/CalendarUtils.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/core/date/UniversalDate\",\"./CalendarDate\",\"sap/ui/core/Locale\",\"sap/ui/core/LocaleData\"],function(e,t,a,n,r){\"use strict\";var i={};return i.MAX_MILLISECONDS=864e13,i.HOURS24=864e5,i._createLocalDate=function(e,a){var n;if(e){var r;r=e instanceof t?e.getJSDate():e,n=new Date(r.getUTCFullYear(),r.getUTCMonth(),r.getUTCDate()),r.getFullYear()<1e3&&n.setFullYear(r.getFullYear()),a&&(n.setHours(r.getUTCHours()),n.setMinutes(r.getUTCMinutes()),n.setSeconds(r.getUTCSeconds()),n.setMilliseconds(r.getUTCMilliseconds()))}return n},i._createUTCDate=function(e,a){var n;if(e){var r;r=e instanceof t?e.getJSDate():e,n=new Date(Date.UTC(r.getFullYear(),r.getMonth(),r.getDate())),r.getFullYear()<1e3&&n.setUTCFullYear(r.getFullYear()),a&&(n.setUTCHours(r.getHours()),n.setUTCMinutes(r.getMinutes()),n.setUTCSeconds(r.getSeconds()),n.setUTCMilliseconds(r.getMilliseconds()))}return n},i._createUniversalUTCDate=function(e,a,n){return a?t.getInstance(this._createUTCDate(e,n),a):new t(this._createUTCDate(e,n).getTime())},i.calculateWeekNumber=function(e,a,r,i){var s=0,g=0,u=i.getFirstDayOfWeek(),o=new n(r);if(o&&\"en\"==o.getLanguage()&&\"US\"==o.getRegion()){var c=new t(e.getTime());c.setUTCFullYear(a,0,1),g=c.getUTCDay();var l=new t(e.getTime());l.setUTCDate(l.getUTCDate()-l.getUTCDay()+g),s=Math.round((l.getTime()-c.getTime())/864e5/7)+1}else{var C=new t(e.getTime());C.setUTCDate(C.getUTCDate()-u),g=C.getUTCDay(),C.setUTCDate(C.getUTCDate()-g+4);var D=new t(C.getTime());D.setUTCMonth(0,1),g=D.getUTCDay();var T=0;g>4&&(T=7);var U=new t(D.getTime());U.setUTCDate(1-g+4+T),s=Math.round((C.getTime()-U.getTime())/864e5/7)+1}return s},i.getFirstDateOfWeek=function(e){var a,n,i,s=new t(e.getTime()),g=r.getInstance(sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale()),u=g.getFirstDayOfWeek();for(i=t.getWeekByDate(s.getCalendarType(),s.getUTCFullYear(),s.getUTCMonth(),s.getUTCDate()),a=t.getFirstDateOfWeek(s.getCalendarType(),i.year,i.week),n=new t(Date.UTC(a.year,a.month,a.day));n.getUTCDay()!==u;)n.setUTCDate(n.getUTCDate()-1);return new t(Date.UTC(n.getUTCFullYear(),n.getUTCMonth(),n.getUTCDate(),e.getUTCHours(),e.getUTCMinutes(),e.getUTCSeconds())).getJSDate()},i.getFirstDateOfMonth=function(e){var a=new t(e.getTime());return a.setUTCDate(1),a},i._getNumberOfWeeksForYear=function(e){var t=sap.ui.getCore().getConfiguration().getFormatLocale(),a=r.getInstance(new n(t)),i=new Date(Date.UTC(e,0,1)),s=i.getUTCDay(),g=52;return 0===a.getFirstDayOfWeek()?5!==s&&6!==s||(g=53):3!==s&&4!==s||(g=53),g},i.monthsDiffer=function(e,t){return e.getMonth()!==t.getMonth()||e.getFullYear()!==t.getFullYear()},i.isDateLastInMonth=function(e){return new Date(e.getTime()+864e5).getUTCDate()<e.getUTCDate()},i._updateUTCDate=function(t,a,n,r,i,s,g,u){e.isNumeric(a)&&t.setUTCFullYear(a),e.isNumeric(n)&&t.setUTCMonth(n),e.isNumeric(r)&&t.setUTCDate(r),e.isNumeric(i)&&t.setUTCHours(i),e.isNumeric(s)&&t.setUTCMinutes(s),e.isNumeric(g)&&t.setUTCSeconds(g),e.isNumeric(u)&&t.setUTCMilliseconds(u)},i._checkJSDateObject=function(t){if(\"date\"!==e.type(t))throw new Error(\"Date must be a JavaScript date object.\")},i._checkYearInValidRange=function(t){if(!e.isNumeric(t)||t<1||t>9999)throw new Error(\"Year must be in valid range (between year 0001 and year 9999).\")},i._isNextMonth=function(e,t){return e.getMonth()>t.getMonth()&&e.getFullYear()===t.getFullYear()||e.getFullYear()>t.getFullYear()},i._daysInMonth=function(e){return this._checkCalendarDate(e),e=new a(e),e.setDate(1),e.setMonth(e.getMonth()+1),e.setDate(0),e.getDate()},i._isLastDateInMonth=function(e){return e.getDate()===i._daysInMonth(e)},i._getFirstDateOfWeek=function(e){this._checkCalendarDate(e);var t=i.getFirstDateOfWeek(e.toUTCJSDate());return t.setFullYear(t.getUTCFullYear(),t.getUTCMonth(),t.getUTCDate()),a.fromLocalJSDate(t,e.getCalendarType())},i._getFirstDateOfMonth=function(e){this._checkCalendarDate(e);var t=i.getFirstDateOfMonth(e.toUTCJSDate()).getJSDate();return t.setFullYear(t.getUTCFullYear(),t.getUTCMonth(),t.getUTCDate()),a.fromLocalJSDate(t,e.getCalendarType())},i._minDate=function(e){return new a(1,0,1,e)},i._maxDate=function(e){var t=new a(9999,11,1,e);return t.setDate(this._daysInMonth(t)),new a(t)},i._isBetween=function(e,t,a,n){return this._checkCalendarDate(e),this._checkCalendarDate(t),this._checkCalendarDate(a),n?e.isSameOrAfter(t)&&e.isSameOrBefore(a):e.isAfter(t)&&e.isBefore(a)},i._daysBetween=function(e,t){return this._checkCalendarDate(e),this._checkCalendarDate(t),Math.ceil((e.valueOf()-t.valueOf())/this.HOURS24)},i._isOutside=function(e,t,a){return!this._isBetween(e,t,a,!0)},i._isSameMonthAndYear=function(e,t){return this._checkCalendarDate(e),this._checkCalendarDate(t),e.getYear()===t.getYear()&&e.getMonth()===t.getMonth()},i._checkCalendarDate=function(e){if(!(e&&e instanceof a))throw\"Invalid calendar date: [\"+e+\"]. Expected: sap.ui.unified.calendar.CalendarDate\"},i._getWeek=function(e){return this._checkCalendarDate(e),t.getWeekByDate(e.getCalendarType(),e.getYear(),e.getMonth(),e.getDate())},i},!0);",
	"sap/ui/unified/calendar/DatesRow.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/unified/calendar/CalendarUtils\",\"sap/ui/unified/calendar/CalendarDate\",\"sap/ui/unified/calendar/Month\",\"sap/ui/unified/library\",\"./DatesRowRenderer\"],function(e,t,a,r,i,s){\"use strict\";var n=r.extend(\"sap.ui.unified.calendar.DatesRow\",{metadata:{library:\"sap.ui.unified\",properties:{startDate:{type:\"object\",group:\"Data\"},days:{type:\"int\",group:\"Appearance\",defaultValue:7},showDayNamesLine:{type:\"boolean\",group:\"Appearance\",defaultValue:!0}}}});return n.prototype.init=function(){r.prototype.init.apply(this,arguments),this._iColumns=1,this._aWeekNumbers=[]},n.prototype.setStartDate=function(e){t._checkJSDateObject(e);var r=e.getFullYear();if(t._checkYearInValidRange(r),this.setProperty(\"startDate\",e,!0),this._oStartDate=a.fromLocalJSDate(e,this.getPrimaryCalendarType()),this.getDomRef()){var i=this._getDate().toLocalJSDate();this._bNoRangeCheck=!0,this.displayDate(e),this._bNoRangeCheck=!1,i&&this.checkDateFocusable(i)&&this.displayDate(i)}return this},n.prototype._getStartDate=function(){return this._oStartDate||(this._oStartDate=a.fromLocalJSDate(new Date,this.getPrimaryCalendarType())),this._oStartDate},n.prototype.setDate=function(e){if(!this._bNoRangeCheck&&!this.checkDateFocusable(e))throw new Error(\"Date must be in visible date range; \"+this);return r.prototype.setDate.apply(this,arguments),this},n.prototype.displayDate=function(e){if(!this._bNoRangeCheck&&!this.checkDateFocusable(e))throw new Error(\"Date must be in visible date range; \"+this);return r.prototype.displayDate.apply(this,arguments),this},n.prototype.setPrimaryCalendarType=function(e){return r.prototype.setPrimaryCalendarType.apply(this,arguments),this._oStartDate&&(this._oStartDate=new a(this._oStartDate,e)),this},n.prototype.setFirstDayOfWeek=function(e){if(-1==e)return this.setProperty(\"firstDayOfWeek\",e,!1);throw new Error(\"Property firstDayOfWeek not supported \"+this)},n.prototype._handleBorderReached=function(e){var t=e.getParameter(\"event\"),r=this.getDays(),i=this._getDate(),s=new a(i,this.getPrimaryCalendarType());if(t.type){switch(t.type){case\"sapnext\":case\"sapnextmodifiers\":s.setDate(s.getDate()+1);break;case\"sapprevious\":case\"sappreviousmodifiers\":s.setDate(s.getDate()-1);break;case\"sappagedown\":s.setDate(s.getDate()+r);break;case\"sappageup\":s.setDate(s.getDate()-r)}this.fireFocus({date:s.toLocalJSDate(),otherMonth:!0,_outsideBorder:!0})}},n.prototype.checkDateFocusable=function(e){if(t._checkJSDateObject(e),this._bNoRangeCheck)return!1;var r=this._getStartDate(),i=new a(r,this.getPrimaryCalendarType());i.setDate(i.getDate()+this.getDays());var s=a.fromLocalJSDate(e,this.getPrimaryCalendarType());return s.isSameOrAfter(r)&&s.isBefore(i)},n.prototype._renderHeader=function(){var t=this._getStartDate(),a=t.getDay(),r=this._getLocaleData(),i=this.$(\"Names\").children(),s=[];s=this._bLongWeekDays||!this._bNamesLengthChecked?r.getDaysStandAlone(\"abbreviated\"):r.getDaysStandAlone(\"narrow\");var n=r.getDaysStandAlone(\"wide\"),o=0;for(o=0;o<i.length;o++){var h=e(i[o]);h.text(s[(o+a)%7]),h.attr(\"aria-label\",n[(o+a)%7])}if(this._getShowHeader()){var p=this.$(\"Head\");if(p.length>0){var u=sap.ui.getCore().createRenderManager();this.getRenderer().renderHeaderLine(u,this,r,t),u.flush(p[0]),u.destroy()}}},n.prototype._getFirstWeekDay=function(){return this._getStartDate().getDay()},n.prototype.getWeekNumbers=function(){for(var e=this.getDays(),r=this._getLocale(),i=this._getLocaleData(),s=this.getPrimaryCalendarType(),n=this._getStartDate(),o=new a(n,s),h=new a(n,s).setDate(o.getDate()+e),p=[];o.isBefore(h);)p.push(new a(o,s)),o.setDate(o.getDate()+1);return this._aWeekNumbers=p.reduce(function(e,a){var s=t.calculateWeekNumber(a.toUTCJSDate(),a.getYear(),r,i);return e.length&&e[e.length-1].number===s||e.push({len:0,number:s}),e[e.length-1].len++,e},[]),this._aWeekNumbers},n.prototype._getCachedWeekNumbers=function(){return this._aWeekNumbers},n});",
	"sap/ui/unified/calendar/DatesRowRenderer.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"sap/ui/core/Renderer\",\"sap/ui/unified/calendar/CalendarDate\",\"./MonthRenderer\"],function(e,a,t){\"use strict\";var r=e.extend(t);return r.getStartDate=function(e){return e._getStartDate()},r.getClass=function(e,a){var t=\"sapUiCalDatesRow sapUiCalRow\";return a.getShowDayNamesLine()||(t+=\" sapUiCalNoNameLine\"),t},r.renderMonth=function(e,a,r){t.renderMonth.apply(this,arguments),this.renderWeekNumbers(e,a)},r.renderWeekNumbers=function(e,a){var t,r,i,n;a.getShowWeekNumbers()&&a.getPrimaryCalendarType()===sap.ui.core.CalendarType.Gregorian&&(t=sap.ui.getCore().getLibraryResourceBundle(\"sap.ui.unified\"),e.write('<div id=\"'+a.getId()+'-weeks\"'),e.addClass(\"sapUiCalRowWeekNumbers\"),e.writeClasses(),e.write(\">\"),r=a.getDays(),i=100/r,n=a.getWeekNumbers(),n.forEach(function(a){e.write(\"<div\"),e.addClass(\"sapUiCalRowWeekNumber\"),e.writeClasses(),e.addStyle(\"width\",a.len*i+\"%\"),e.writeStyles(),e.writeAttribute(\"data-sap-ui-week\",a.number),e.write(\">\"+t.getText(\"CALENDAR_DATES_ROW_WEEK_NUMBER\",[a.number])+\"</div>\")}),e.write(\"</div>\"))},r.renderHeader=function(e,a,t){var r=a._getLocaleData(),i=a.getId(),n=a.getDays(),s=\"\";a._getShowHeader()&&(e.write('<div id=\"'+i+'-Head\">'),this.renderHeaderLine(e,a,r,t),e.write(\"</div>\")),s=100/n+\"%\",a.getShowDayNamesLine()&&(e.write('<div id=\"'+i+'-Names\" style=\"display: inline;\">'),this.renderDayNames(e,a,r,t.getDay(),n,!1,s),e.write(\"</div>\"))},r.renderHeaderLine=function(e,t,r,i){var n=t.getId(),s=t.getDays(),d=new a(i,t.getPrimaryCalendarType()),o=\"\",g=0,l=[],D=0;for(D=0;D<s;D++)g=d.getMonth(),l.length>0&&l[l.length-1].iMonth==g?l[l.length-1].iDays++:l.push({iMonth:g,iDays:1}),d.setDate(d.getDate()+1);var y=r.getMonthsStandAlone(\"wide\");for(D=0;D<l.length;D++){var u=l[D];o=100/s*u.iDays+\"%\",e.write('<div id=\"'+n+\"-Head\"+D+'\"class=\"sapUiCalHeadText\" style=\"width:'+o+'\">'),e.write(y[u.iMonth]),e.write(\"</div>\")}},r.renderDays=function(e,t,r){var i=t.getDays(),n=100/i+\"%\",s=t.getShowDayNamesLine();r||(r=t._getFocusedDate());var d=this.getDayHelper(t,r);s||(t._bLongWeekDays||!t._bNamesLengthChecked?d.aWeekDays=d.oLocaleData.getDaysStandAlone(\"abbreviated\"):d.aWeekDays=d.oLocaleData.getDaysStandAlone(\"narrow\"),d.aWeekDaysWide=d.oLocaleData.getDaysStandAlone(\"wide\"));for(var o=new a(r,t.getPrimaryCalendarType()),g=0;g<i;g++)this.renderDay(e,t,o,d,!1,!1,g,n,!s),o.setDate(o.getDate()+1)},r},!0);",
	"sap/ui/unified/calendar/Header.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/core/Control\",\"sap/ui/unified/library\",\"./HeaderRenderer\"],function(t,e,i,s){\"use strict\";function o(t,e){this.setProperty(\"textButton\"+t,e,!0),this.getDomRef()&&this[\"getVisibleButton\"+t]()&&(this.$(\"B\"+t+\"-Text\").get(0)?this.$(\"B\"+t+\"-Text\").text(e):this.$(\"B\"+t).text(e))}function r(t,e){var i=!1,s=this[\"getAdditionalTextButton\"+t]();s!=e&&((!s&&e||s&&!e)&&(i=!0),this.setProperty(\"additionalTextButton\"+t,e,!i),!i&&this.getDomRef()&&this[\"getVisibleButton\"+t]()&&this.$(\"B\"+t+\"-AddText\").text(e))}function a(t,e){this.setProperty(\"ariaLabelButton\"+t,e,!0),this.getDomRef()&&this[\"getVisibleButton\"+t]()&&(e?this.$(\"B\"+t).attr(\"aria-label\",e):this.$(\"B\"+t).removeAttr(\"aria-label\"))}var n=e.extend(\"sap.ui.unified.calendar.Header\",{metadata:{library:\"sap.ui.unified\",properties:{textButton0:{type:\"string\",group:\"Appearance\"},additionalTextButton0:{type:\"string\",group:\"Appearance\"},ariaLabelButton0:{type:\"string\",group:\"Misc\"},visibleButton0:{type:\"boolean\",group:\"Appearance\",defaultValue:!1},textButton1:{type:\"string\",group:\"Appearance\"},additionalTextButton1:{type:\"string\",group:\"Appearance\"},ariaLabelButton1:{type:\"string\",group:\"Misc\"},visibleButton1:{type:\"boolean\",group:\"Appearance\",defaultValue:!0},textButton2:{type:\"string\",group:\"Appearance\"},additionalTextButton2:{type:\"string\",group:\"Appearance\"},ariaLabelButton2:{type:\"string\",group:\"Misc\"},visibleButton2:{type:\"boolean\",group:\"Appearance\",defaultValue:!0},enabledPrevious:{type:\"boolean\",group:\"Behavior\",defaultValue:!0},enabledNext:{type:\"boolean\",group:\"Behavior\",defaultValue:!0}},events:{pressPrevious:{},pressNext:{},pressButton0:{},pressButton1:{},pressButton2:{}}}});return n.prototype.setTextButton0=function(t){return o.call(this,0,t),this},n.prototype.setAdditionalTextButton0=function(t){return r.call(this,0,t),this},n.prototype.setAriaLabelButton0=function(t){return a.call(this,0,t),this},n.prototype.setTextButton1=function(t){return o.call(this,1,t),this},n.prototype.setAdditionalTextButton1=function(t){return r.call(this,1,t),this},n.prototype.setAriaLabelButton1=function(t){return a.call(this,1,t),this},n.prototype.setTextButton2=function(t){return o.call(this,2,t),this},n.prototype.setAdditionalTextButton2=function(t){return r.call(this,2,t),this},n.prototype.setAriaLabelButton2=function(t){return a.call(this,2,t),this},n.prototype.setEnabledPrevious=function(t){return this.setProperty(\"enabledPrevious\",t,!0),this.getDomRef()&&(t?this.$(\"prev\").toggleClass(\"sapUiCalDsbl\",!1).removeAttr(\"disabled\"):this.$(\"prev\").toggleClass(\"sapUiCalDsbl\",!0).attr(\"disabled\",\"disabled\")),this},n.prototype.setEnabledNext=function(t){return this.setProperty(\"enabledNext\",t,!0),this.getDomRef()&&(t?this.$(\"next\").toggleClass(\"sapUiCalDsbl\",!1).removeAttr(\"disabled\"):this.$(\"next\").toggleClass(\"sapUiCalDsbl\",!0).attr(\"disabled\",\"disabled\")),this},n.prototype.onclick=function(e){e.isMarked(\"delayedMouseEvent\")||(t.sap.containsOrEquals(this.getDomRef(\"prev\"),e.target)&&this.getEnabledPrevious()?this.firePressPrevious():t.sap.containsOrEquals(this.getDomRef(\"next\"),e.target)&&this.getEnabledNext()?this.firePressNext():t.sap.containsOrEquals(this.getDomRef(\"B0\"),e.target)?this.firePressButton0():t.sap.containsOrEquals(this.getDomRef(\"B1\"),e.target)?this.firePressButton1():t.sap.containsOrEquals(this.getDomRef(\"B2\"),e.target)&&this.firePressButton2())},n.prototype.onsapnext=function(t){t.preventDefault()},n});",
	"sap/ui/unified/calendar/HeaderRenderer.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\"],function(t){\"use strict\";var e={};return e.render=function(t,e){var i=sap.ui.getCore().getConfiguration().getLocale().getLanguage(),a=e.getTooltip_AsString(),r=e.getId(),s={};t.write(\"<div\"),t.writeControlData(e),t.addClass(\"sapUiCalHead\"),t.writeClasses(),a&&t.writeAttributeEscaped(\"title\",a),t.writeAccessibilityState(e),t.write(\">\"),t.write(\"<button\"),t.writeAttributeEscaped(\"id\",r+\"-prev\"),t.writeAttributeEscaped(\"title\",this.getPreviousTooltip(e)),t.writeAccessibilityState(null,{label:this.getPreviousTooltip(e)}),t.addClass(\"sapUiCalHeadPrev\"),e.getEnabledPrevious()||(t.addClass(\"sapUiCalDsbl\"),t.writeAttribute(\"disabled\",\"disabled\")),t.writeAttribute(\"tabindex\",\"-1\"),t.writeClasses(),t.write(\">\"),this.renderHeaderPreviousIcon(t,e),t.write(\"</button>\");var l,d=-1,n=-1,o=0;for(o=0;o<3;o++)e[\"getVisibleButton\"+o]()&&(d<0&&(d=o),n=o);for(o=0;o<3;o++)l=\"ja\"===i.toLowerCase()||\"zh\"===i.toLowerCase()?2-o:o,this.renderCalendarButtons(t,e,r,d,n,s,l);t.write(\"<button\"),t.writeAttributeEscaped(\"id\",r+\"-next\"),t.writeAttribute(\"title\",this.getNextTooltip(e)),t.writeAccessibilityState(null,{label:this.getNextTooltip(e)}),t.addClass(\"sapUiCalHeadNext\"),e.getEnabledNext()||(t.addClass(\"sapUiCalDsbl\"),t.writeAttribute(\"disabled\",\"disabled\")),t.writeAttribute(\"tabindex\",\"-1\"),t.writeClasses(),t.write(\">\"),this.renderHeaderNextIcon(t,e),t.write(\"</button>\"),t.write(\"</div>\")},e.renderCalendarButtons=function(e,i,a,r,s,l,d){if(i[\"getVisibleButton\"+d]()){e.write(\"<button\"),e.writeAttributeEscaped(\"id\",a+\"-B\"+d),e.addClass(\"sapUiCalHeadB\"),e.addClass(\"sapUiCalHeadB\"+d),r==d&&e.addClass(\"sapUiCalHeadBFirst\"),s==d&&e.addClass(\"sapUiCalHeadBLast\"),e.writeAttribute(\"tabindex\",\"-1\"),e.writeClasses(),i[\"getAriaLabelButton\"+d]()&&(l.label=t.sap.encodeHTML(i[\"getAriaLabelButton\"+d]())),e.writeAccessibilityState(null,l),l={},e.write(\">\");var n=i[\"getTextButton\"+d]()||\"\",o=i[\"getAdditionalTextButton\"+d]()||\"\";o?(e.write(\"<span\"),e.writeAttributeEscaped(\"id\",a+\"-B\"+d+\"-Text\"),e.addClass(\"sapUiCalHeadBText\"),e.writeClasses(),e.write(\">\"),e.writeEscaped(n),e.write(\"</span>\"),e.write(\"<span\"),e.writeAttributeEscaped(\"id\",a+\"-B\"+d+\"-AddText\"),e.addClass(\"sapUiCalHeadBAddText\"),e.writeClasses(),e.write(\">\"),e.writeEscaped(o),e.write(\"</span>\")):e.writeEscaped(n),e.write(\"</button>\")}},e.renderHeaderPreviousIcon=function(t,e){t.writeIcon(\"sap-icon://slim-arrow-left\",null,{title:null})},e.renderHeaderNextIcon=function(t,e){t.writeIcon(\"sap-icon://slim-arrow-right\",null,{title:null})},e.getPreviousTooltip=function(){return sap.ui.getCore().getLibraryResourceBundle(\"sap.ui.unified\").getText(\"CALENDAR_BTN_PREV\")},e.getNextTooltip=function(){return sap.ui.getCore().getLibraryResourceBundle(\"sap.ui.unified\").getText(\"CALENDAR_BTN_NEXT\")},e},!0);",
	"sap/ui/unified/calendar/Month.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/core/Control\",\"sap/ui/Device\",\"sap/ui/core/LocaleData\",\"sap/ui/core/delegate/ItemNavigation\",\"sap/ui/unified/calendar/CalendarUtils\",\"sap/ui/unified/calendar/CalendarDate\",\"sap/ui/unified/library\",\"sap/ui/core/format/DateFormat\",\"sap/ui/core/library\",\"sap/ui/core/Locale\",\"./MonthRenderer\",\"jquery.sap.keycodes\"],function(e,t,a,s,i,o,r,n,l,h,d,g){\"use strict\";function p(){for(var t=this._oFormatYyyymmdd.format(this._getDate().toUTCJSDate(),!0),a=0,s=this.$(\"days\").get(0),o=this.$(\"days\").find(\".sapUiCalItem\"),r=0;r<o.length;r++){if(e(o[r]).attr(\"data-sap-day\")===t){a=r;break}}this._oItemNavigation||(this._oItemNavigation=new i,this._oItemNavigation.attachEvent(i.Events.AfterFocus,c,this),this._oItemNavigation.attachEvent(i.Events.FocusAgain,y,this),this._oItemNavigation.attachEvent(i.Events.BorderReached,this._handleBorderReached,this),this.addDelegate(this._oItemNavigation),this._iColumns>1&&this._oItemNavigation.setHomeEndColumnMode(!0,!0),this._oItemNavigation.setDisabledModifiers({sapnext:[\"alt\"],sapprevious:[\"alt\"],saphome:[\"alt\"],sapend:[\"alt\"]}),this._oItemNavigation.setCycling(!1),this._oItemNavigation.setColumns(this._iColumns,!0)),this._oItemNavigation.setRootDomRef(s),this._oItemNavigation.setItemDomRefs(o),this._oItemNavigation.setFocusedIndex(a),this._oItemNavigation.setPageSize(o.length)}function c(t){var a=t.getParameter(\"index\"),s=t.getParameter(\"event\");if(s){var i,o=this._getDate(),n=new r(o,this.getPrimaryCalendarType()),l=!1,h=!0,d=this._oItemNavigation.getItemDomRefs(),g=0,p=e(d[a]);if(p.hasClass(\"sapUiCalItemOtherMonth\"))if(\"saphomemodifiers\"==s.type&&(s.metaKey||s.ctrlKey))n.setDate(1),this._focusDate(n);else if(\"sapendmodifiers\"==s.type&&(s.metaKey||s.ctrlKey)){for(g=d.length-1;g>0;g--)if(i=e(d[g]),!i.hasClass(\"sapUiCalItemOtherMonth\")){n=r.fromLocalJSDate(this._oFormatYyyymmdd.parse(i.attr(\"data-sap-day\")),this.getPrimaryCalendarType());break}this._focusDate(n)}else l=!0,n=r.fromLocalJSDate(this._oFormatYyyymmdd.parse(p.attr(\"data-sap-day\")),this.getPrimaryCalendarType()),n||(n=new r(o)),this._focusDate(o),(\"mousedown\"==s.type||this._sTouchstartYyyyMMdd&&\"focusin\"==s.type&&this._sTouchstartYyyyMMdd==p.attr(\"data-sap-day\"))&&(h=!1,this.fireFocus({date:o.toLocalJSDate(),otherMonth:!1,restoreOldDate:!0})),s.originalEvent&&\"touchstart\"==s.originalEvent.type?this._sTouchstartYyyyMMdd=p.attr(\"data-sap-day\"):this._sTouchstartYyyyMMdd=void 0;else e(s.target).hasClass(\"sapUiCalWeekNum\")?this._focusDate(n):(n=r.fromLocalJSDate(this._oFormatYyyymmdd.parse(p.attr(\"data-sap-day\")),this.getPrimaryCalendarType()),this._setDate(n)),this._sTouchstartYyyyMMdd=void 0;\"mousedown\"==s.type&&this.getIntervalSelection()&&(this._sLastTargetId=p.attr(\"id\")),h&&this.fireFocus({date:n.toLocalJSDate(),otherMonth:l}),\"mousedown\"==s.type&&m.call(this,s,n,a)}}function y(e){var t=e.getParameter(\"index\"),a=e.getParameter(\"event\");if(a&&\"mousedown\"==a.type){var s=this._getDate();if(this.getIntervalSelection()){var i=this._oItemNavigation.getItemDomRefs();this._sLastTargetId=i[t].id}m.call(this,a,s,t)}}function m(e,t,s){if(!e.button&&!a.support.touch){var i=f.call(this,t);i&&(this._bMousedownChange=!0),this._bMouseMove?(this._unbindMousemove(!0),this._bMoveChange=!1,this._oMoveSelectedDate=void 0):i&&this.getIntervalSelection()&&this.$().is(\":visible\")&&(this._bindMousemove(!0),this._oMoveSelectedDate=new r(t,this.getPrimaryCalendarType())),e.preventDefault(),e.setMark(\"cancelAutoClose\")}}function u(e,t){o._checkCalendarDate(e);var a=e.getYear();o._checkYearInValidRange(a);var s=!0;if(!this.getDate()||!e.isSame(r.fromLocalJSDate(this.getDate(),e.getCalendarType()))){var i=new r(e);s=this.checkDateFocusable(e.toLocalJSDate()),this.setProperty(\"date\",e.toLocalJSDate(),!0),this._oDate=i}this.getDomRef()&&(s?this._focusDate(this._oDate,!0,t):D.call(this,t))}function D(t){var a,s,i=this.getRenderer().getStartDate(this),o=this.$(\"days\"),r=this.$(\"weeks\"),n=0,l=0;if(this._sLastTargetId)for(a=this._oItemNavigation.getItemDomRefs(),n=0;n<a.length;n++)if(s=e(a[n]),s.attr(\"id\")==this._sLastTargetId){l=n;break}if(o.length>0){var h=sap.ui.getCore().createRenderManager();this.getRenderer().renderDays(h,this,i),h.flush(o[0]),r.length&&(this.getRenderer().renderWeekNumbers(h,this),h.flush(r[0])),h.destroy()}this._renderHeader(),this.fireEvent(\"_renderMonth\",{days:o.find(\".sapUiCalItem\").length}),p.call(this),t||this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex()),this._sLastTargetId&&(a=this._oItemNavigation.getItemDomRefs(),l<=a.length-1&&(s=e(a[l]),this._sLastTargetId=s.attr(\"id\")))}function f(t,a){if(!this._checkDateEnabled(t))return!1;var s,i,o,n,l=this.getSelectedDates(),h=this._oItemNavigation.getItemDomRefs(),d=0,g=this.getParent(),p=this,c=this.getPrimaryCalendarType();if(g&&g.getSelectedDates&&(p=g),this.getSingleSelection())if(l.length>0?(s=l[0],(n=s.getStartDate())&&(n=r.fromLocalJSDate(n,c))):(s=new sap.ui.unified.DateRange,p.addAggregation(\"selectedDates\",s,!0)),this.getIntervalSelection()&&(!s.getEndDate()||a)&&n){var y;t.isBefore(n)?(y=n,n=t,a||(s.setProperty(\"startDate\",n.toLocalJSDate(),!0),s.setProperty(\"endDate\",y.toLocalJSDate(),!0))):t.isSameOrAfter(n)&&(y=t,a||s.setProperty(\"endDate\",y.toLocalJSDate(),!0)),_.call(this,n,y)}else _.call(this,t),s.setProperty(\"startDate\",t.toLocalJSDate(),!0),s.setProperty(\"endDate\",void 0,!0);else{if(this.getIntervalSelection())throw new Error(\"Calender don't support multiple interval selection\");var m=this._checkDateSelected(t);if(m>0){for(d=0;d<l.length;d++)if((n=l[d].getStartDate())&&t.isSame(r.fromLocalJSDate(n,c))){p.removeAggregation(\"selectedDates\",d,!0);break}}else s=new sap.ui.unified.DateRange({startDate:t.toLocalJSDate()}),p.addAggregation(\"selectedDates\",s,!0);for(o=this._oFormatYyyymmdd.format(t.toUTCJSDate(),!0),d=0;d<h.length;d++)i=e(h[d]),i.attr(\"data-sap-day\")==o&&(m>0?(i.removeClass(\"sapUiCalItemSel\"),i.attr(\"aria-selected\",\"false\")):(i.addClass(\"sapUiCalItemSel\"),i.attr(\"aria-selected\",\"true\")))}return!0}function _(t,a){Array.isArray(t)||(t=[t]);var s,i=this._oItemNavigation.getItemDomRefs(),n=0,l=!1,h=!1;if(a){var d;for(n=0;n<i.length;n++)s=e(i[n]),l=!1,h=!1,d=r.fromLocalJSDate(this._oFormatYyyymmdd.parse(s.attr(\"data-sap-day\")),I.Gregorian),d.isSame(t[0])?(s.addClass(\"sapUiCalItemSelStart\"),l=!0,s.addClass(\"sapUiCalItemSel\"),s.attr(\"aria-selected\",\"true\"),a&&d.isSame(a)&&(s.addClass(\"sapUiCalItemSelEnd\"),h=!0),s.removeClass(\"sapUiCalItemSelBetween\")):a&&o._isBetween(d,t[0],a)?(s.addClass(\"sapUiCalItemSel\"),s.attr(\"aria-selected\",\"true\"),s.addClass(\"sapUiCalItemSelBetween\"),s.removeClass(\"sapUiCalItemSelStart\"),s.removeClass(\"sapUiCalItemSelEnd\")):a&&d.isSame(a)?(s.addClass(\"sapUiCalItemSelEnd\"),h=!0,s.addClass(\"sapUiCalItemSel\"),s.attr(\"aria-selected\",\"true\"),s.removeClass(\"sapUiCalItemSelStart\"),s.removeClass(\"sapUiCalItemSelBetween\")):(s.hasClass(\"sapUiCalItemSel\")&&(s.removeClass(\"sapUiCalItemSel\"),s.attr(\"aria-selected\",\"false\")),s.hasClass(\"sapUiCalItemSelStart\")?s.removeClass(\"sapUiCalItemSelStart\"):s.hasClass(\"sapUiCalItemSelBetween\")?s.removeClass(\"sapUiCalItemSelBetween\"):s.hasClass(\"sapUiCalItemSelEnd\")&&s.removeClass(\"sapUiCalItemSelEnd\")),v.call(this,s,l,h)}else{var g=t.map(function(e){return this._oFormatYyyymmdd.format(e.toUTCJSDate(),!0)},this);for(n=0;n<i.length;n++)s=e(i[n]),l=!1,h=!1,g.indexOf(s.attr(\"data-sap-day\"))>-1?(s.addClass(\"sapUiCalItemSel\"),s.attr(\"aria-selected\",\"true\"),l=!0):s.hasClass(\"sapUiCalItemSel\")&&(s.removeClass(\"sapUiCalItemSel\"),s.attr(\"aria-selected\",\"false\")),s.hasClass(\"sapUiCalItemSelStart\")?s.removeClass(\"sapUiCalItemSelStart\"):s.hasClass(\"sapUiCalItemSelBetween\")?s.removeClass(\"sapUiCalItemSelBetween\"):s.hasClass(\"sapUiCalItemSelEnd\")&&s.removeClass(\"sapUiCalItemSelEnd\"),v.call(this,s,l,h)}}function v(e,t,a){if(this.getIntervalSelection()){var s=\"\",i=[],o=this.getId(),r=!1;s=e.attr(\"aria-describedby\"),s&&(i=s.split(\" \"));for(var n=-1,l=-1,h=0;h<i.length;h++){var d=i[h];d==o+\"-Start\"&&(n=h),d==o+\"-End\"&&(l=h)}n>=0&&!t&&(i.splice(n,1),r=!0,l>n&&l--),l>=0&&!a&&(i.splice(l,1),r=!0),n<0&&t&&(i.push(o+\"-Start\"),r=!0),l<0&&a&&(i.push(o+\"-End\"),r=!0),r&&(s=i.join(\" \"),e.attr(\"aria-describedby\",s))}}function C(){this._bMouseMove&&this._unbindMousemove(!0),this.fireSelect()}function S(){if(!this._bNamesLengthChecked){var t,a=this.$().find(\".sapUiCalWH\"),s=this._isMonthNameLong(a),i=0;if(s){this._bLongWeekDays=!1;var o=this._getLocaleData(),r=this._getFirstWeekDay(),n=o.getDaysStandAlone(\"narrow\",this.getPrimaryCalendarType());for(i=0;i<a.length;i++)t=a[i],e(t).text(n[(i+r)%7])}else this._bLongWeekDays=!0;this._bNamesLengthChecked=!0}}var I=h.CalendarType,b=n.CalendarDayType,M=t.extend(\"sap.ui.unified.calendar.Month\",{metadata:{library:\"sap.ui.unified\",properties:{date:{type:\"object\",group:\"Data\"},intervalSelection:{type:\"boolean\",group:\"Behavior\",defaultValue:!1},singleSelection:{type:\"boolean\",group:\"Behavior\",defaultValue:!0},showHeader:{type:\"boolean\",group:\"Appearance\",defaultValue:!1},firstDayOfWeek:{type:\"int\",group:\"Appearance\",defaultValue:-1},nonWorkingDays:{type:\"int[]\",group:\"Appearance\",defaultValue:null},primaryCalendarType:{type:\"sap.ui.core.CalendarType\",group:\"Appearance\"},secondaryCalendarType:{type:\"sap.ui.core.CalendarType\",group:\"Appearance\"},width:{type:\"sap.ui.core.CSSSize\",group:\"Dimension\",defaultValue:null},showWeekNumbers:{type:\"boolean\",group:\"Appearance\",defaultValue:!0}},aggregations:{selectedDates:{type:\"sap.ui.unified.DateRange\",multiple:!0,singularName:\"selectedDate\"},specialDates:{type:\"sap.ui.unified.DateTypeRange\",multiple:!0,singularName:\"specialDate\"},disabledDates:{type:\"sap.ui.unified.DateRange\",multiple:!0,singularName:\"disabledDate\"}},associations:{ariaLabelledBy:{type:\"sap.ui.core.Control\",multiple:!0,singularName:\"ariaLabelledBy\"},legend:{type:\"sap.ui.unified.CalendarLegend\",multiple:!1}},events:{select:{},focus:{parameters:{date:{type:\"object\"},otherMonth:{type:\"boolean\"},restoreOldDate:{type:\"boolean\"}}}}}});return M.prototype.init=function(){var t=sap.ui.getCore().getConfiguration().getCalendarType();this.setProperty(\"primaryCalendarType\",t),this.setProperty(\"secondaryCalendarType\",t),this._oFormatYyyymmdd=l.getInstance({pattern:\"yyyyMMdd\",calendarType:I.Gregorian}),this._oFormatLong=l.getInstance({style:\"long\",calendarType:t}),this._mouseMoveProxy=e.proxy(this._handleMouseMove,this),this._iColumns=7,this._aVisibleDays=[]},M.prototype.exit=function(){this._oItemNavigation&&(this.removeDelegate(this._oItemNavigation),this._oItemNavigation.destroy(),delete this._oItemNavigation),this._sInvalidateMonth&&e.sap.clearDelayedCall(this._sInvalidateMonth),this._aVisibleDays=null},M.prototype.onAfterRendering=function(){p.call(this),S.call(this)},M.prototype.onmouseover=function(t){var a,s,i,o=e(t.target);this.getIntervalSelection()&&(a=this.getSelectedDates()[0])&&a.getStartDate()&&!a.getEndDate()&&(o.hasClass(\"sapUiCalItemText\")||o.hasClass(\"sapUiCalItem\"))&&(o.hasClass(\"sapUiCalItemText\")&&(o=o.parent()),s=parseInt(this._oFormatYyyymmdd.format(a.getStartDate()),10),i=o.data(\"sapDay\"),s>i&&(s+=i,i=s-i,s-=i),this.hasListeners(\"datehovered\")?this.fireEvent(\"datehovered\",{date1:s,date2:i}):this._markDatesBetweenStartAndHoveredDate(s,i))},M.prototype._markDatesBetweenStartAndHoveredDate=function(t,a){var s,i,o,r;for(s=this.$().find(\".sapUiCalItem\"),r=0;r<s.length;r++)i=e(s[r]),o=i.data(\"sapDay\"),o>t&&o<a?i.addClass(\"sapUiCalItemSelBetween\"):i.removeClass(\"sapUiCalItemSelBetween\")},M.prototype.onsapfocusleave=function(t){if(!t.relatedControlId||!e.sap.containsOrEquals(this.getDomRef(),sap.ui.getCore().byId(t.relatedControlId).getFocusDomRef())){if(this._bMouseMove){this._unbindMousemove(!0);!f.call(this,this._getDate())&&this._oMoveSelectedDate&&f.call(this,this._oMoveSelectedDate),this._bMoveChange=!1,this._bMousedownChange=!1,this._oMoveSelectedDate=void 0,C.call(this)}this._bMousedownChange&&(this._bMousedownChange=!1,C.call(this))}},M.prototype.removeAllSelectedDates=function(){return this._bDateRangeChanged=!0,this.removeAllAggregation(\"selectedDates\")},M.prototype.destroySelectedDates=function(){return this._bDateRangeChanged=!0,this.destroyAggregation(\"selectedDates\")},M.prototype.removeAllSpecialDates=function(){return this._bDateRangeChanged=!0,this.removeAllAggregation(\"specialDates\")},M.prototype.destroySpecialDates=function(){return this._bDateRangeChanged=!0,this.destroyAggregation(\"specialDates\")},M.prototype.removeAllDisabledDates=function(){return this._bDateRangeChanged=!0,this.removeAllAggregation(\"disabledDates\")},M.prototype.destroyDisabledDates=function(){return this._bDateRangeChanged=!0,this.destroyAggregation(\"disabledDates\")},M.prototype.setDate=function(e){var t=r.fromLocalJSDate(e,this.getPrimaryCalendarType());return u.call(this,t,!1),this},M.prototype._setDate=function(e){var t=e.toLocalJSDate();this.setProperty(\"date\",t,!0),this._oDate=e},M.prototype._getDate=function(){return this._oDate||(this._oDate=r.fromLocalJSDate(new Date,this.getPrimaryCalendarType())),this._oDate},M.prototype.displayDate=function(e){var t=r.fromLocalJSDate(e,this.getPrimaryCalendarType());return u.call(this,t,!0),this},M.prototype.setPrimaryCalendarType=function(e){return this.setProperty(\"primaryCalendarType\",e),this._oFormatLong=l.getInstance({style:\"long\",calendarType:e}),this._oDate&&(this._oDate=new r(this._oDate,e)),this},M.prototype.setSecondaryCalendarType=function(e){return this._bSecondaryCalendarTypeSet=!0,this.setProperty(\"secondaryCalendarType\",e),this.invalidate(),this._oFormatSecondaryLong=l.getInstance({style:\"long\",calendarType:e}),this},M.prototype._getSecondaryCalendarType=function(){var e;if(this._bSecondaryCalendarTypeSet){e=this.getSecondaryCalendarType();e==this.getPrimaryCalendarType()&&(e=void 0)}return e},M.prototype._getLocale=function(){var e=this.getParent();return e&&e.getLocale?e.getLocale():(this._sLocale||(this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString()),this._sLocale)},M.prototype._getLocaleData=function(){var e=this.getParent();if(e&&e._getLocaleData)return e._getLocaleData();if(!this._oLocaleData){var t=this._getLocale(),a=new d(t);this._oLocaleData=s.getInstance(a)}return this._oLocaleData},M.prototype._getFormatLong=function(){var e=this._getLocale();if(this._oFormatLong.oLocale.toString()!=e){var t=new d(e);this._oFormatLong=l.getInstance({style:\"long\",calendarType:this.getPrimaryCalendarType()},t),this._oFormatSecondaryLong&&(this._oFormatSecondaryLong=l.getInstance({style:\"long\",calendarType:this._getSecondaryCalendarType()},t))}return this._oFormatLong},M.prototype.getIntervalSelection=function(){var e=this.getParent();return e&&e.getIntervalSelection?e.getIntervalSelection():this.getProperty(\"intervalSelection\")},M.prototype.getSingleSelection=function(){var e=this.getParent();return e&&e.getSingleSelection?e.getSingleSelection():this.getProperty(\"singleSelection\")},M.prototype.getSelectedDates=function(){var e=this.getParent();return e&&e.getSelectedDates?e.getSelectedDates():this.getAggregation(\"selectedDates\",[])},M.prototype.getSpecialDates=function(){var e=this.getParent();return e&&e.getSpecialDates?e.getSpecialDates():this.getAggregation(\"specialDates\",[])},M.prototype.getDisabledDates=function(){var e=this.getParent();return e&&e.getDisabledDates?e.getDisabledDates():this.getAggregation(\"disabledDates\",[])},M.prototype._getShowHeader=function(){var e=this.getParent();return e&&e._getShowMonthHeader?e._getShowMonthHeader():this.getProperty(\"showHeader\")},M.prototype.getAriaLabelledBy=function(){var e=this.getParent();return e&&e.getAriaLabelledBy?e.getAriaLabelledBy():this.getAssociation(\"ariaLabelledBy\",[])},M.prototype.getLegend=function(){var e=this.getParent();return e&&e.getLegend?e.getLegend():this.getAssociation(\"legend\",[])},M.prototype._getFirstDayOfWeek=function(){var e=this.getParent(),t=0;if((t=e&&e.getFirstDayOfWeek?e.getFirstDayOfWeek():this.getProperty(\"firstDayOfWeek\"))<0||t>6){t=this._getLocaleData().getFirstDayOfWeek()}return t},M.prototype._getNonWorkingDays=function(){var t,a=this.getParent();return t=a&&a.getNonWorkingDays?a.getNonWorkingDays():this.getProperty(\"nonWorkingDays\"),t&&!e.isArray(t)&&(t=[]),t},M.prototype._checkDateSelected=function(e){o._checkCalendarDate(e);for(var t=0,a=this.getSelectedDates(),s=e.toUTCJSDate().getTime(),i=this.getPrimaryCalendarType(),n=0;n<a.length;n++){var l=a[n],h=l.getStartDate(),d=0;h&&(h=r.fromLocalJSDate(h,i),d=h.toUTCJSDate().getTime());var g=l.getEndDate(),p=0;if(g&&(g=r.fromLocalJSDate(g,i),p=g.toUTCJSDate().getTime()),s==d&&!g){t=1;break}if(s==d&&g){t=2,g&&s==p&&(t=5);break}if(g&&s==p){t=3;break}if(g&&s>d&&s<p){t=4;break}if(this.getSingleSelection())break}return t},M.prototype._getDateTypes=function(e){o._checkCalendarDate(e);for(var t,a,s,i=[],n=this.getSpecialDates(),l=e.toUTCJSDate().getTime(),h=this.getPrimaryCalendarType(),d=0;d<n.length;d++){var g=n[d],p=g.getStartDate(),c=o.MAX_MILLISECONDS;p&&(p=r.fromLocalJSDate(p,h),c=p.toUTCJSDate().getTime());var y=g.getEndDate(),m=-o.MAX_MILLISECONDS;if(y&&(y=r.fromLocalJSDate(y,h),m=y.toUTCJSDate().getTime()),s=g.getType()===b.NonWorking,(l==c&&!y||l>=c&&l<=m)&&(s||t?s&&!a&&(a={type:g.getType(),tooltip:g.getTooltip_AsString()},i.push(a)):(t={type:g.getType(),tooltip:g.getTooltip_AsString()},i.push(t)),t&&a))break}return i},M.prototype._checkDateEnabled=function(e){o._checkCalendarDate(e);var t=!0,a=this.getDisabledDates(),s=e.toUTCJSDate().getTime(),i=this.getPrimaryCalendarType(),n=this.getParent();if(n&&n._oMinDate&&n._oMaxDate&&(s<n._oMinDate.valueOf()||s>n._oMaxDate.valueOf()))return!1;for(var l=0;l<a.length;l++){var h=a[l],d=h.getStartDate(),g=0;d&&(d=r.fromLocalJSDate(d,i),g=d.toUTCJSDate().getTime());var p=h.getEndDate(),c=0;if(p&&(p=r.fromLocalJSDate(p,i),c=p.toUTCJSDate().getTime()),p){if(s>g&&s<c){t=!1;break}}else if(s==g){t=!1;break}}return t},M.prototype.setWidth=function(e){return this.setProperty(\"width\",e,!0),this.getDomRef()&&(e=this.getWidth(),this.$().css(\"width\",e)),this},M.prototype._handleMouseMove=function(t){this.$().is(\":visible\")||this._unbindMousemove(!0);var a=e(t.target);if(a.hasClass(\"sapUiCalItemText\")&&(a=a.parent()),(!this._sLastTargetId||this._sLastTargetId!=a.attr(\"id\"))&&(this._sLastTargetId=a.attr(\"id\"),a.hasClass(\"sapUiCalItem\"))){var s=this._getDate();if(e.sap.containsOrEquals(this.getDomRef(),t.target)){var i=r.fromLocalJSDate(this._oFormatYyyymmdd.parse(a.attr(\"data-sap-day\")),this.getPrimaryCalendarType());if(!i.isSame(s))if(a.hasClass(\"sapUiCalItemOtherMonth\"))this.fireFocus({date:i.toLocalJSDate(),otherMonth:!0});else{this._setDate(i);var o=f.call(this,i,!0);o&&(this._oMoveSelectedDate=new r(i,this.getPrimaryCalendarType())),this._bMoveChange=!0}}else{var n=this.getSelectedDates();if(n.length>0&&this.getSingleSelection()){var l=n[0].getStartDate();l&&(l=r.fromLocalJSDate(l,this.getPrimaryCalendarType()));var h=r.fromLocalJSDate(this._oFormatYyyymmdd.parse(a.attr(\"data-sap-day\")));h.isSameOrAfter(l)?_.call(this,l,h):_.call(this,h,l)}}}},M.prototype.onmousedown=function(e){this._oMousedownPosition={clientX:e.clientX,clientY:e.clientY}},M.prototype.onmouseup=function(t){if(this._bMouseMove){this._unbindMousemove(!0);for(var s=this._getDate(),i=this._oItemNavigation.getItemDomRefs(),o=0;o<i.length;o++){var n=e(i[o]);if(!n.hasClass(\"sapUiCalItemOtherMonth\")&&n.attr(\"data-sap-day\")==this._oFormatYyyymmdd.format(s.toUTCJSDate(),!0)){n.focus();break}}if(this._bMoveChange){!f.call(this,s)&&this._oMoveSelectedDate&&f.call(this,this._oMoveSelectedDate),this._bMoveChange=!1,this._bMousedownChange=!1,this._oMoveSelectedDate=void 0,C.call(this)}}if(this._bMousedownChange)this._bMousedownChange=!1,C.call(this);else if(a.support.touch&&this._isValueInThreshold(this._oMousedownPosition.clientX,t.clientX,10)&&this._isValueInThreshold(this._oMousedownPosition.clientY,t.clientY,10)&&t.target.classList.contains(\"sapUiCalItemText\")){var l=r.fromLocalJSDate(this._oFormatYyyymmdd.parse(e(t.target).parent().attr(\"data-sap-day\")),this.getPrimaryCalendarType());f.call(this,l,!1,!1),C.call(this)}},M.prototype.onsapselect=function(e){f.call(this,this._getDate())&&C.call(this),e.stopPropagation(),e.preventDefault()},M.prototype.onsapselectmodifiers=function(e){this.onsapselect(e)},M.prototype.onsappageupmodifiers=function(e){var t=new r(this._getDate(),this.getPrimaryCalendarType()),a=t.getYear();e.metaKey||e.ctrlKey?t.setYear(a-10):t.setYear(a-1),this.fireFocus({date:t.toLocalJSDate(),otherMonth:!0}),e.preventDefault()},M.prototype.onsappagedownmodifiers=function(e){var t=new r(this._getDate(),this.getPrimaryCalendarType()),a=t.getYear();e.metaKey||e.ctrlKey?t.setYear(a+10):t.setYear(a+1),this.fireFocus({date:t.toLocalJSDate(),otherMonth:!0}),e.preventDefault()},M.prototype._updateSelection=function(){var e=this.getSelectedDates();if(e.length>0){var t=this.getPrimaryCalendarType(),a=e.map(function(e){var a=e.getStartDate();if(a)return r.fromLocalJSDate(a,t)}),s=e[0].getEndDate();s&&(s=r.fromLocalJSDate(s,t)),_.call(this,a,s)}},M.prototype._isValueInThreshold=function(e,t,a){var s=e-a,i=e+a;return t>=s&&t<=i},M.prototype._bindMousemove=function(t){e(window.document).bind(\"mousemove\",this._mouseMoveProxy),this._bMouseMove=!0,t&&this.fireEvent(\"_bindMousemove\")},M.prototype._unbindMousemove=function(t){e(window.document).unbind(\"mousemove\",this._mouseMoveProxy),this._bMouseMove=void 0,this._sLastTargetId=void 0,t&&this.fireEvent(\"_unbindMousemove\")},M.prototype.onThemeChanged=function(){if(!this._bNoThemeChange){this._bNamesLengthChecked=void 0,this._bLongWeekDays=void 0;for(var t=this.$().find(\".sapUiCalWH\"),a=this._getLocaleData(),s=this._getFirstWeekDay(),i=a.getDaysStandAlone(\"abbreviated\",this.getPrimaryCalendarType()),o=0;o<t.length;o++){var r=t[o];e(r).text(i[(o+s)%7])}S.call(this)}},M.prototype._handleBorderReached=function(t){var a=t.getParameter(\"event\"),s=0,i=this._getDate(),o=new r(i,this.getPrimaryCalendarType());if(a.type){switch(a.type){case\"sapnext\":case\"sapnextmodifiers\":a.keyCode==e.sap.KeyCodes.ARROW_DOWN?o.setDate(o.getDate()+7):o.setDate(o.getDate()+1);break;case\"sapprevious\":case\"sappreviousmodifiers\":a.keyCode==e.sap.KeyCodes.ARROW_UP?o.setDate(o.getDate()-7):o.setDate(o.getDate()-1);break;case\"sappagedown\":if(s=o.getMonth()+1,o.setMonth(s),s%12!=o.getMonth())for(;s!=o.getMonth();)o.setDate(o.getDate()-1);break;case\"sappageup\":if(s=o.getMonth()-1,o.setMonth(s),s<0&&(s=11),s!=o.getMonth())for(;s!=o.getMonth();)o.setDate(o.getDate()-1)}this.fireFocus({date:o.toLocalJSDate(),otherMonth:!0})}},M.prototype.checkDateFocusable=function(e){o._checkJSDateObject(e);var t=this._getDate(),a=r.fromLocalJSDate(e,this.getPrimaryCalendarType());return o._isSameMonthAndYear(a,t)},M.prototype.applyFocusInfo=function(e){return this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex()),this},M.prototype._renderHeader=function(){if(this._getShowHeader()){var e=this._getDate(),t=this._getLocaleData(),a=t.getMonthsStandAlone(\"wide\",this.getPrimaryCalendarType());this.$(\"Head\").text(a[e.getMonth()])}},M.prototype._getFirstWeekDay=function(){return this._getFirstDayOfWeek()},M.prototype._isMonthNameLong=function(e){var t,a;for(t=0;t<e.length;t++)if(a=e[t],Math.abs(a.clientWidth-a.scrollWidth)>1)return!0;return!1},M.prototype.selectDay=function(e){f.call(this,e)},M.prototype._getVisibleDays=function(e,t){var a,s,i,o,n,l,h;if(!e)return this._aVisibleDays;this._aVisibleDays=[],l=this._getFirstDayOfWeek(),n=new r(e,this.getPrimaryCalendarType()),n.setDate(1),o=n.getDay()-l,o<0&&(o=7+o),o>0&&n.setDate(1-o),s=new r(n),a=(e.getMonth()+1)%12;do{h=s.getYear(),i=new r(s,this.getPrimaryCalendarType()),t&&h<1?(i._bBeforeFirstYear=!0,this._aVisibleDays.push(i)):h>0&&h<1e4&&this._aVisibleDays.push(i),s.setDate(s.getDate()+1)}while(s.getMonth()!==a||s.getDay()!==l);return this._aVisibleDays},M.prototype._focusDate=function(t,a,s){a||this.setDate(t.toLocalJSDate());for(var i,o=this._oFormatYyyymmdd.format(t.toUTCJSDate(),!0),r=this._oItemNavigation.getItemDomRefs(),n=0;n<r.length;n++)if(i=e(r[n]),i.attr(\"data-sap-day\")==o){document.activeElement!=r[n]&&(s?this._oItemNavigation.setFocusedIndex(n):this._oItemNavigation.focusItem(n));break}},M});",
	"sap/ui/unified/calendar/MonthPicker.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/core/Control\",\"sap/ui/Device\",\"sap/ui/core/LocaleData\",\"sap/ui/core/delegate/ItemNavigation\",\"sap/ui/unified/library\",\"sap/ui/core/Locale\",\"./MonthPickerRenderer\"],function(t,e,a,i,o,s,n,h){\"use strict\";function r(){var t=this.getDomRef(),e=this.$().find(\".sapUiCalItem\"),a=this.getColumns(),i=this.getMonths(),s=!0;i<12&&(s=!1),this._oItemNavigation||(this._oItemNavigation=new o,this._oItemNavigation.attachEvent(o.Events.AfterFocus,l,this),this._oItemNavigation.attachEvent(o.Events.FocusAgain,g,this),this._oItemNavigation.attachEvent(o.Events.BorderReached,p,this),this.addDelegate(this._oItemNavigation),this._oItemNavigation.setHomeEndColumnMode(!0,!0),this._oItemNavigation.setDisabledModifiers({sapnext:[\"alt\"],sapprevious:[\"alt\"],saphome:[\"alt\"],sapend:[\"alt\"]})),this._oItemNavigation.setRootDomRef(t),this._oItemNavigation.setItemDomRefs(e),this._oItemNavigation.setCycling(s),this._oItemNavigation.setColumns(a,!s);var n=this.getMonth()-this.getStartMonth();this._oItemNavigation.setFocusedIndex(n),this._oItemNavigation.setPageSize(e.length)}function l(t){var e=t.getParameter(\"index\"),a=t.getParameter(\"event\");a&&\"mousedown\"==a.type&&c.call(this,a,e)}function g(t){var e=t.getParameter(\"index\"),a=t.getParameter(\"event\");a&&\"mousedown\"==a.type&&c.call(this,a,e)}function c(t,e){if(!t.button&&!a.support.touch){var i=e+this.getStartMonth();i>=this._iMinMonth&&i<=this._iMaxMonth&&(u.call(this,i),this._bMousedownChange=!0),t.preventDefault(),t.setMark(\"cancelAutoClose\")}}function p(t){var e=t.getParameter(\"event\");if(e.type){var a=this.getStartMonth(),i=this._oItemNavigation.getFocusedIndex(),o=i+a,s=this.getMonths();switch(e.type){case\"sapnext\":case\"sapnextmodifiers\":o<11&&(o++,m.call(this,o,!0));break;case\"sapprevious\":case\"sappreviousmodifiers\":o>0&&(o--,m.call(this,o,!0));break;case\"sappagedown\":o<12-s&&(o+=s,m.call(this,o,!0));break;case\"sappageup\":o>s&&(o-=s,m.call(this,o,!0))}}}function u(e,a){for(var i,o=this._oItemNavigation.getItemDomRefs(),s=this.getId()+\"-m\"+e,n=0;n<o.length;n++)i=t(o[n]),i.attr(\"id\")==s?(i.addClass(\"sapUiCalItemSel\"),i.attr(\"aria-selected\",\"true\")):(i.removeClass(\"sapUiCalItemSel\"),i.attr(\"aria-selected\",\"false\"));a||this.setProperty(\"month\",e,!0)}function d(){if(!this._bNamesLengthChecked){for(var e=0,a=this._oItemNavigation.getItemDomRefs(),i=!1,o=this.getMonths(),s=Math.ceil(12/o),n=o-1,h=0;h<s;h++){for(o<12&&(m.call(this,n),(n+=o)>11&&(n=11)),e=0;e<a.length;e++){var r=a[e];if(Math.abs(r.clientWidth-r.scrollWidth)>1){i=!0;break}}if(i)break}if(o<12&&(n=this.getMonth(),m.call(this,n)),i){this._bLongMonth=!1;var l=this._getLocaleData(),g=this.getPrimaryCalendarType(),c=l.getMonthsStandAlone(\"abbreviated\",g),p=l.getMonthsStandAlone(\"wide\",g);for(e=0;e<a.length;e++){var u=t(a[e]);u.text(c[e]),u.attr(\"aria-label\",p[e])}}else this._bLongMonth=!0;this._bNamesLengthChecked=!0}}function m(e,a){var i=this._oItemNavigation.getItemDomRefs();if(!(i.legth>11)){var o=i.length,s=Math.floor(e/o)*o;s+o>12&&(s=12-o);var n=this._getLocaleData(),h=[],r=[],l=this.getPrimaryCalendarType();this._bLongMonth||!this._bNamesLengthChecked?h=n.getMonthsStandAlone(\"wide\",l):(h=n.getMonthsStandAlone(\"abbreviated\",l),r=n.getMonthsStandAlone(\"wide\",l));for(var g=this.getMonth(),c=0;c<i.length;c++){var p=c+s,u=t(i[c]);u.text(h[c+s]),u.attr(\"id\",this.getId()+\"-m\"+(c+s)),this._bLongMonth||u.attr(\"aria-label\",r[c+s]),p==g?(u.addClass(\"sapUiCalItemSel\"),u.attr(\"aria-selected\",\"true\")):(u.removeClass(\"sapUiCalItemSel\"),u.attr(\"aria-selected\",\"false\")),p<this._iMinMonth||p>this._iMaxMonth?(u.addClass(\"sapUiCalItemDsbl\"),u.attr(\"aria-disabled\",!0)):(u.removeClass(\"sapUiCalItemDsbl\"),u.removeAttr(\"aria-disabled\"))}this._oItemNavigation.focusItem(e-s),a&&this.firePageChange()}}var f=e.extend(\"sap.ui.unified.calendar.MonthPicker\",{metadata:{library:\"sap.ui.unified\",properties:{month:{type:\"int\",group:\"Data\",defaultValue:0},months:{type:\"int\",group:\"Appearance\",defaultValue:12},columns:{type:\"int\",group:\"Appearance\",defaultValue:3},primaryCalendarType:{type:\"sap.ui.core.CalendarType\",group:\"Appearance\"}},events:{select:{},pageChange:{}}}});return f.prototype.init=function(){var t=sap.ui.getCore().getConfiguration().getCalendarType();this.setProperty(\"primaryCalendarType\",t),this._iMinMonth=0,this._iMaxMonth=11},f.prototype.onAfterRendering=function(){r.call(this),d.call(this)},f.prototype.setMonth=function(t){if(this.setProperty(\"month\",t,!0),(t=this.getProperty(\"month\"))<0||t>11)throw new Error(\"Property month must be between 0 and 11; \"+this);if(this.getDomRef())if(this.getMonths()<12){var e=this.getStartMonth();t>=e&&t<=e+this.getMonths()-1?(u.call(this,t,!0),this._oItemNavigation.focusItem(t-e)):m.call(this,t)}else u.call(this,t,!0),this._oItemNavigation.focusItem(t);return this},f.prototype._getLocale=function(){var t=this.getParent();return t&&t._getLocale?t._getLocale():(this._sLocale||(this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString()),this._sLocale)},f.prototype._getLocaleData=function(){var t=this.getParent();if(t&&t._getLocaleData)return t._getLocaleData();if(!this._oLocaleData){var e=this._getLocale(),a=new n(e);this._oLocaleData=i.getInstance(a)}return this._oLocaleData},f.prototype.onsapspace=function(t){t.preventDefault()},f.prototype.onsapselect=function(t){var e=this._oItemNavigation.getFocusedIndex(),a=e+this.getStartMonth();a>=this._iMinMonth&&a<=this._iMaxMonth&&(u.call(this,a),this.fireSelect())},f.prototype.onmousedown=function(t){this._oMousedownPosition={clientX:t.clientX,clientY:t.clientY}},f.prototype.onmouseup=function(t){if(this._bMousedownChange)this._bMousedownChange=!1,this.fireSelect();else if(a.support.touch&&this._isValueInThreshold(this._oMousedownPosition.clientX,t.clientX,10)&&this._isValueInThreshold(this._oMousedownPosition.clientY,t.clientY,10)){var e=this._oItemNavigation.getFocusedIndex(),i=e+this.getStartMonth();u.call(this,i),this.fireSelect()}},f.prototype.onThemeChanged=function(){if(!this._bNoThemeChange&&this.getDomRef()){this._bNamesLengthChecked=void 0;var e=this._oItemNavigation.getItemDomRefs();this._bLongMonth=!1;for(var a=this._getLocaleData(),i=a.getMonthsStandAlone(\"wide\",this.getPrimaryCalendarType()),o=0;o<e.length;o++){t(e[o]).text(i[o])}d.call(this)}},f.prototype.nextPage=function(){var t=this.getStartMonth(),e=this._oItemNavigation.getFocusedIndex(),a=e+t;return a+=this.getMonths(),a>11&&(a=11),m.call(this,a),this},f.prototype.previousPage=function(){var t=this.getStartMonth(),e=this._oItemNavigation.getFocusedIndex(),a=e+t;return a-=this.getMonths(),a<0&&(a=0),m.call(this,a),this},f.prototype.setMinMax=function(e,a){if(e==this._iMinMonth&&a==this._iMaxMonth)return this;if(e=parseInt(e,10),(isNaN(e)||e<0||e>11)&&(e=0),a=parseInt(a,10),(isNaN(a)||a<0||a>11)&&(a=11),e<=a?(this._iMinMonth=e,this._iMaxMonth=a):(this._iMaxMonth=e,this._iMinMonth=a),this.getDomRef())for(var i=this._oItemNavigation.getItemDomRefs(),o=this.getId().length+2,s=0;s<i.length;s++){var n=t(i[s]),h=parseInt(n.attr(\"id\").slice(o),10);h<this._iMinMonth||h>this._iMaxMonth?(n.addClass(\"sapUiCalItemDsbl\"),n.attr(\"aria-disabled\",!0)):(n.removeClass(\"sapUiCalItemDsbl\"),n.removeAttr(\"aria-disabled\"))}return this},f.prototype.getStartMonth=function(){if(this.getMonths()<12){var t=this._oItemNavigation.getItemDomRefs()[0];return parseInt(t.id.slice(this.getId().length+2),10)}return 0},f.prototype._isValueInThreshold=function(t,e,a){var i=t-a,o=t+a;return e>=i&&e<=o},f});",
	"sap/ui/unified/calendar/MonthPickerRenderer.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([],function(){\"use strict\";var e={};return e.render=function(e,t){var i=t.getMonth(),a=t.getMonths(),r=0,l=t.getColumns(),s=t.getTooltip_AsString(),d=t._getLocaleData(),n=t.getId(),o=\"\",w=[],c=[],b=t.getPrimaryCalendarType();t._bLongMonth||!t._bNamesLengthChecked?w=d.getMonthsStandAlone(\"wide\",b):(w=d.getMonthsStandAlone(\"abbreviated\",b),c=d.getMonthsStandAlone(\"wide\",b)),e.write(\"<div\"),e.writeControlData(t),e.addClass(\"sapUiCalMonthPicker\"),e.writeClasses(),s&&e.writeAttributeEscaped(\"title\",s),e.writeAccessibilityState(t,{role:\"grid\",readonly:\"true\",multiselectable:\"false\"}),e.write(\">\");var g;a>12?a=12:a<12&&(r=Math.floor(i/a)*a)+a>12&&(r=12-a),o=l>0?100/l+\"%\":100/a+\"%\";for(var h=0;h<a;h++){var C=h+r;g={role:\"gridcell\"},!t._bLongMonth&&t._bNamesLengthChecked&&(g.label=c[C]),l>0&&h%l==0&&(e.write(\"<div\"),e.writeAccessibilityState(null,{role:\"row\"}),e.write(\">\")),e.write(\"<div\"),e.writeAttribute(\"id\",n+\"-m\"+C),e.addClass(\"sapUiCalItem\"),C==i?(e.addClass(\"sapUiCalItemSel\"),g.selected=!0):g.selected=!1,(C<t._iMinMonth||C>t._iMaxMonth)&&(e.addClass(\"sapUiCalItemDsbl\"),g.disabled=!0),e.writeAttribute(\"tabindex\",\"-1\"),e.addStyle(\"width\",o),e.writeClasses(),e.writeStyles(),e.writeAccessibilityState(null,g),e.write(\">\"),e.write(w[C]),e.write(\"</div>\"),l>0&&(h+1)%l==0&&e.write(\"</div>\")}e.write(\"</div>\")},e},!0);",
	"sap/ui/unified/calendar/MonthRenderer.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/unified/calendar/CalendarUtils\",\"sap/ui/unified/calendar/CalendarDate\",\"sap/ui/unified/CalendarLegend\",\"sap/ui/unified/CalendarLegendRenderer\",\"sap/ui/core/library\",\"sap/ui/unified/library\"],function(e,a,t,i,r,d,s){\"use strict\";var n=s.CalendarDayType,l=d.CalendarType,o={};return o.render=function(e,a){var t=this.getStartDate(a),i=a.getTooltip_AsString(),r=sap.ui.getCore().getLibraryResourceBundle(\"sap.ui.unified\"),d=a.getId(),s={value:d+\"-Descr\",append:!0},n=a.getWidth();e.write(\"<div\"),e.writeControlData(a),e.addClass(this.getClass(e,a)),a._getSecondaryCalendarType()&&e.addClass(\"sapUiCalMonthSecType\"),e.writeClasses(),i&&e.writeAttributeEscaped(\"title\",i),a._getShowHeader()&&(s.value=s.value+\" \"+d+\"-Head\"),n&&(e.addStyle(\"width\",n),e.writeStyles()),e.writeAccessibilityState(a,{role:sap.ui.Device.browser.chrome?\"\":\"grid\",readonly:\"true\",multiselectable:!a.getSingleSelection()||a.getIntervalSelection(),labelledby:s}),e.write(\">\"),e.write('<span id=\"'+d+'-Descr\" style=\"display: none;\">'+r.getText(\"CALENDAR_DIALOG\")+\"</span>\"),a.getIntervalSelection()&&(e.write('<span id=\"'+d+'-Start\" style=\"display: none;\">'+r.getText(\"CALENDAR_START_DATE\")+\"</span>\"),e.write('<span id=\"'+d+'-End\" style=\"display: none;\">'+r.getText(\"CALENDAR_END_DATE\")+\"</span>\")),this.renderMonth(e,a,t),e.write(\"</div>\")},o.getStartDate=function(e){return e._getDate()},o.getClass=function(e,a){var t=\"sapUiCalMonthView\",i=a.getPrimaryCalendarType(),r=a.getShowWeekNumbers();return i!=l.Islamic&&r||(t+=\" sapUiCalNoWeekNum\"),t},o.renderMonth=function(e,a,t){var i=a.getId();this.renderHeader(e,a,t),e.write('<div id=\"'+i+'-days\" class=\"sapUiCalItems\">'),this.renderDays(e,a,t),e.write(\"</div>\")},o.renderHeader=function(e,a,t){var i=a._getLocaleData(),r=a._getFirstDayOfWeek(),d=a.getId(),s=sap.ui.getCore().getLibraryResourceBundle(\"sap.ui.unified\");this.renderHeaderLine(e,a,i,t),e.write(\"<div\"),e.writeAttribute(\"id\",d+\"-CW\"),e.addStyle(\"display\",\"none\"),e.writeStyles(),sap.ui.Device.browser.chrome&&e.writeAccessibilityState(null,{role:\"columnheader\"}),e.write(\">\"),e.write(s.getText(\"CALENDAR_WEEK\")),e.write(\"</div>\"),e.write(\"<div\"),sap.ui.Device.browser.chrome&&e.writeAccessibilityState(null,{role:\"row\"}),e.addStyle(\"overflow\",\"hidden\"),e.writeStyles(),e.write(\">\"),this.renderDayNames(e,a,i,r,7,!0,void 0),e.write(\"</div>\")},o.renderHeaderLine=function(e,t,i,r){if(a._checkCalendarDate(r),t._getShowHeader()){var d=t.getId(),s=t.getPrimaryCalendarType(),n=i.getMonthsStandAlone(\"wide\",s);e.write('<div id=\"'+d+'-Head\"class=\"sapUiCalHeadText\" >'),e.write(n[r.getMonth()]),e.write(\"</div>\")}},o.renderDayNames=function(e,a,t,i,r,d,s){var n=a._getFirstDayOfWeek(),l=a.getId(),o=\"\",y=a.getPrimaryCalendarType(),c=[];c=a._bLongWeekDays||!a._bNamesLengthChecked?t.getDaysStandAlone(\"short\",y):t.getDaysStandAlone(\"narrow\",y);for(var C=t.getDaysStandAlone(\"wide\",y),g=0;g<r;g++)e.write(\"<div\"),e.addClass(\"sapUiCalWH\"),o=d?l+\"-WH\"+(g+n)%7:l+\"-WH\"+g,e.writeAttribute(\"id\",o),0==g&&e.addClass(\"sapUiCalFirstWDay\"),s&&e.addStyle(\"width\",s),sap.ui.Device.browser.chrome?e.writeAccessibilityState(null,{label:C[(g+i)%7]}):e.writeAccessibilityState(null,{role:\"columnheader\",label:C[(g+i)%7]}),e.writeClasses(),e.writeStyles(),e.write(\">\"),e.write(c[(g+i)%7]),e.write(\"</div>\")},o.renderDays=function(e,t,i){var r,d,s,n,o,y,c;if(a._checkCalendarDate(i),i||(i=t._getFocusedDate()),!(y=i.toUTCJSDate().getTime())&&0!==y)throw new Error(\"Date is invalid \"+t);for(n=this.getDayHelper(t,i),d=t._getVisibleDays(i,!0),c=t.getShowWeekNumbers(),r=t.getPrimaryCalendarType()!==l.Islamic&&c,s=d.length,o=0;o<s;o++)this.renderDay(e,t,d[o],n,!0,r,-1)},o.getDayHelper=function(a,r){var d,s,n=a._getLocaleData(),l={sLocale:a._getLocale(),oLocaleData:n,iMonth:r.getMonth(),iYear:r.getYear(),iFirstDayOfWeek:a._getFirstDayOfWeek(),iWeekendStart:n.getWeekendStart(),iWeekendEnd:n.getWeekendEnd(),aNonWorkingDays:a._getNonWorkingDays(),sToday:n.getRelativeDay(0),oToday:t.fromLocalJSDate(new Date,a.getPrimaryCalendarType()),sId:a.getId(),oFormatLong:a._getFormatLong(),sSecondaryCalendarType:a._getSecondaryCalendarType(),oLegend:void 0};if((s=a.getLegend())&&\"string\"==typeof s)if(d=sap.ui.getCore().byId(s)){if(!(d instanceof i))throw new Error(d+\" is not an sap.ui.unified.CalendarLegend. \"+a);l.oLegend=d}else e.sap.log.warning(\"CalendarLegend \"+s+\" does not exist!\",a);return l},o.renderDay=function(e,i,d,s,l,o,y,c,C){a._checkCalendarDate(d);var g=new t(d,s.sSecondaryCalendarType),w={role:sap.ui.Device.browser.chrome?\"\":\"gridcell\",selected:!1,label:\"\",describedby:\"\"},p=d._bBeforeFirstYear,u=\"\",b=i._oFormatYyyymmdd.format(d.toUTCJSDate(),!0),D=d.getDay(),S=i._checkDateSelected(d),m=i._getDateTypes(d),h=i._checkDateEnabled(d),f=0;p&&(h=!1);var W=0;if(o&&(W=a.calculateWeekNumber(d.toUTCJSDate(),s.iYear,s.sLocale,s.oLocaleData),w.describedby=s.sId+\"-CW \"+s.sId+\"-WNum-\"+W),!C){var I=\"\";I=y<0?s.sId+\"-WH\"+D:s.sId+\"-WH\"+y,w.describedby=w.describedby+\" \"+I}if(e.write(\"<div\"),e.writeAttribute(\"id\",s.sId+\"-\"+b),e.addClass(\"sapUiCalItem\"),e.addClass(\"sapUiCalWDay\"+D),c&&e.addStyle(\"width\",c),D==s.iFirstDayOfWeek&&e.addClass(\"sapUiCalFirstWDay\"),l&&s.iMonth!=d.getMonth()&&(e.addClass(\"sapUiCalItemOtherMonth\"),w.disabled=!0),d.isSame(s.oToday)&&(e.addClass(\"sapUiCalItemNow\"),w.label=s.sToday+\" \"),S>0?(e.addClass(\"sapUiCalItemSel\"),w.selected=!0):w.selected=!1,2==S?(e.addClass(\"sapUiCalItemSelStart\"),w.describedby=w.describedby+\" \"+s.sId+\"-Start\"):3==S?(e.addClass(\"sapUiCalItemSelEnd\"),w.describedby=w.describedby+\" \"+s.sId+\"-End\"):4==S?e.addClass(\"sapUiCalItemSelBetween\"):5==S&&(e.addClass(\"sapUiCalItemSelStart\"),e.addClass(\"sapUiCalItemSelEnd\"),w.describedby=w.describedby+\" \"+s.sId+\"-Start\",w.describedby=w.describedby+\" \"+s.sId+\"-End\"),m.forEach(function(a){if(a.type!=n.None){if(a.type===n.NonWorking)return void e.addClass(\"sasUiCalItemNonWorkday\");e.addClass(\"sapUiCalItem\"+a.type),u=a.type,a.tooltip&&e.writeAttributeEscaped(\"title\",a.tooltip)}}),i.getParent()&&\"sap.ui.unified.CalendarOneMonthInterval\"===i.getParent().getMetadata().getName()&&d.getMonth()!==i.getStartDate().getMonth()&&e.addClass(\"sapUiCalItemOtherMonth\"),h||(e.addClass(\"sapUiCalItemDsbl\"),w.disabled=!0),s.aNonWorkingDays){for(f=0;f<s.aNonWorkingDays.length;f++)if(D==s.aNonWorkingDays[f]){e.addClass(\"sasUiCalItemNonWorkday\");break}}else(D>=s.iWeekendStart&&D<=s.iWeekendEnd||s.iWeekendEnd<s.iWeekendStart&&(D>=s.iWeekendStart||D<=s.iWeekendEnd))&&this.addWeekendStyle(e,i);e.writeAttribute(\"tabindex\",\"-1\"),e.writeAttribute(\"data-sap-day\",b),C&&(w.label=w.label+s.aWeekDaysWide[D]+\" \"),w.label=w.label+s.oFormatLong.format(d.toUTCJSDate(),!0),\"\"!==u&&r.addCalendarTypeAccInfo(w,u,s.oLegend),s.sSecondaryCalendarType&&(w.label=w.label+\" \"+i._oFormatSecondaryLong.format(g.toUTCJSDate(),!0)),e.writeAccessibilityState(null,w),e.writeClasses(),e.writeStyles(),e.write(\">\"),e.write(\"<span\"),e.writeAttribute(\"id\",s.sId+\"-\"+b+\"-span\"),e.addClass(\"sapUiCalItemText\"),e.writeClasses(),e.write(\">\"),p||e.write(d.getDate()),e.write(\"</span>\"),o&&D==s.iFirstDayOfWeek&&(e.write(\"<span\"),e.writeAttribute(\"id\",s.sId+\"-WNum-\"+W),e.addClass(\"sapUiCalWeekNum\"),e.writeClasses(),sap.ui.Device.browser.chrome?e.writeAccessibilityState(null,{desribedby:s.sId+\"-CW\"}):e.writeAccessibilityState(null,{role:\"rowheader\",desribedby:s.sId+\"-CW\"}),e.write(\">\"),e.write(W),e.write(\"</span>\")),C&&(e.write(\"<span\"),e.addClass(\"sapUiCalDayName\"),e.writeClasses(),e.write(\">\"),e.write(s.aWeekDays[D]),e.write(\"</span>\")),s.sSecondaryCalendarType&&(e.write(\"<span\"),e.addClass(\"sapUiCalItemSecText\"),e.writeClasses(),e.write(\">\"),e.write(g.getDate()),e.write(\"</span>\")),e.write(\"</div>\")},o.addWeekendStyle=function(e,a){e.addClass(\"sapUiCalItemWeekEnd\")},o},!0);",
	"sap/ui/unified/calendar/MonthsRow.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/core/Control\",\"sap/ui/core/LocaleData\",\"sap/ui/core/delegate/ItemNavigation\",\"sap/ui/unified/calendar/CalendarUtils\",\"sap/ui/unified/calendar/CalendarDate\",\"sap/ui/unified/library\",\"sap/ui/core/format/DateFormat\",\"sap/ui/core/library\",\"sap/ui/core/Locale\",\"./MonthsRowRenderer\"],function(t,e,a,s,i,o,n,r,l,h,g){\"use strict\";function c(){for(var e=this._getDate(),a=this._oFormatYyyymm.format(e.toUTCJSDate(),!0),i=0,o=this.$(\"months\").get(0),n=this.$(\"months\").children(\".sapUiCalItem\"),r=0;r<n.length;r++){if(t(n[r]).attr(\"data-sap-month\")===a){i=r;break}}this._oItemNavigation||(this._oItemNavigation=new s,this._oItemNavigation.attachEvent(s.Events.AfterFocus,p,this),this._oItemNavigation.attachEvent(s.Events.FocusAgain,d,this),this._oItemNavigation.attachEvent(s.Events.BorderReached,m,this),this.addDelegate(this._oItemNavigation),this._oItemNavigation.setDisabledModifiers({sapnext:[\"alt\"],sapprevious:[\"alt\"],saphome:[\"alt\"],sapend:[\"alt\"]}),this._oItemNavigation.setCycling(!1),this._oItemNavigation.setColumns(1,!0)),this._oItemNavigation.setRootDomRef(o),this._oItemNavigation.setItemDomRefs(n),this._oItemNavigation.setFocusedIndex(i),this._oItemNavigation.setPageSize(n.length)}function p(e){var a=e.getParameter(\"index\"),s=e.getParameter(\"event\");if(s){var i=this._getDate(),n=new o(i),r=this._oItemNavigation.getItemDomRefs(),l=t(r[a]);n=o.fromLocalJSDate(this._oFormatYyyymm.parse(l.attr(\"data-sap-month\"))),n.setDate(1),this._setDate(n),this.fireFocus({date:n.toLocalJSDate(),notVisible:!1}),\"mousedown\"==s.type&&u.call(this,s,n,a)}}function d(t){var e=t.getParameter(\"index\"),a=t.getParameter(\"event\");if(a&&\"mousedown\"==a.type){var s=this._getDate();u.call(this,a,s,e)}}function m(t){var e=t.getParameter(\"event\"),a=this.getMonths(),s=this._getDate(),i=new o(s);if(e.type){switch(e.type){case\"sapnext\":case\"sapnextmodifiers\":i.setMonth(i.getMonth()+1);break;case\"sapprevious\":case\"sappreviousmodifiers\":i.setMonth(i.getMonth()-1);break;case\"sappagedown\":i.setMonth(i.getMonth()+a);break;case\"sappageup\":i.setMonth(i.getMonth()-a)}this.fireFocus({date:i.toLocalJSDate(),notVisible:!0})}}function u(t,e,a){if(!t.button){var s=S.call(this,e);s&&(this._bMousedownChange=!0),this._bMouseMove?(w.call(this,!0),this._bMoveChange=!1):s&&this.getIntervalSelection()&&this.$().is(\":visible\")&&L.call(this,!0),t.preventDefault(),t.setMark(\"cancelAutoClose\")}}function D(t,e){i._checkCalendarDate(t);var a=t.getYear();i._checkYearInValidRange(a);var s=!0;if(!this.getDate()||!t.isSame(o.fromLocalJSDate(this.getDate()))){var n=new o(t);if(n.setDate(1),s=this.checkDateFocusable(t.toLocalJSDate()),!this._bNoRangeCheck&&!s)throw new Error(\"Date must be in visible date range; \"+this);this.setProperty(\"date\",t.toLocalJSDate(),!0),this._oDate=n}this.getDomRef()&&(s?f.call(this,this._oDate,e):v.call(this,e))}function f(e,a){for(var s,i=this._oFormatYyyymm.format(e.toUTCJSDate(),!0),o=this._oItemNavigation.getItemDomRefs(),n=0;n<o.length;n++)if(s=t(o[n]),s.attr(\"data-sap-month\")==i){document.activeElement!=o[n]&&(a?this._oItemNavigation.setFocusedIndex(n):this._oItemNavigation.focusItem(n));break}}function v(t){var e=this._getStartDate(),a=this.$(\"months\");if(a.length>0){var s=sap.ui.getCore().createRenderManager();this.getRenderer().renderMonths(s,this,e),s.flush(a[0]),s.destroy()}_.call(this),c.call(this),t||this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex())}function _(){var t=this._getStartDate();if(this._getShowHeader()){var e=this.$(\"Head\");if(e.length>0){var a=this._getLocaleData(),s=sap.ui.getCore().createRenderManager();this.getRenderer().renderHeaderLine(s,this,a,t),s.flush(e[0]),s.destroy()}}}function S(e,a){if(!this._checkMonthEnabled(e))return!1;var s,i,n,r,l=this.getSelectedDates(),h=this._oItemNavigation.getItemDomRefs(),g=0,c=this.getParent(),p=this;if(c&&c.getSelectedDates&&(p=c),this.getSingleSelection())if(l.length>0?(s=l[0],(r=s.getStartDate())&&(r=o.fromLocalJSDate(r),r.setDate(1))):(s=new sap.ui.unified.DateRange,p.addAggregation(\"selectedDates\",s,!0)),this.getIntervalSelection()&&(!s.getEndDate()||a)&&r){var d;e.isBefore(r)?(d=r,r=e,a||(s.setProperty(\"startDate\",r.toLocalJSDate(),!0),s.setProperty(\"endDate\",d.toLocalJSDate(),!0))):e.isSameOrAfter(r)&&(d=e,a||s.setProperty(\"endDate\",d.toLocalJSDate(),!0)),y.call(this,r,d)}else y.call(this,e),s.setProperty(\"startDate\",e.toLocalJSDate(),!0),s.setProperty(\"endDate\",void 0,!0);else{if(this.getIntervalSelection())throw new Error(\"Calender don't support multiple interval selection\");var m=this._checkDateSelected(e);if(m>0){for(g=0;g<l.length;g++)if((r=l[g].getStartDate())&&(r=o.fromLocalJSDate(r),r.setDate(1),e.isSame(r))){p.removeAggregation(\"selectedDates\",g,!0);break}}else s=new sap.ui.unified.DateRange({startDate:e.toLocalJSDate()}),p.addAggregation(\"selectedDates\",s,!0);for(n=this._oFormatYyyymm.format(e.toUTCJSDate(),!0),g=0;g<h.length;g++)i=t(h[g]),i.attr(\"data-sap-month\")==n&&(m>0?(i.removeClass(\"sapUiCalItemSel\"),i.attr(\"aria-selected\",\"false\")):(i.addClass(\"sapUiCalItemSel\"),i.attr(\"aria-selected\",\"true\")))}return!0}function y(e,a){var s,n=this._oItemNavigation.getItemDomRefs(),r=0,l=!1,h=!1;if(a){var g;for(r=0;r<n.length;r++)s=t(n[r]),l=!1,h=!1,g=o.fromLocalJSDate(this._oFormatYyyymm.parse(s.attr(\"data-sap-month\"))),g.setDate(1),g.isSame(e)?(s.addClass(\"sapUiCalItemSelStart\"),l=!0,s.addClass(\"sapUiCalItemSel\"),s.attr(\"aria-selected\",\"true\"),a&&g.isSame(a)&&(s.addClass(\"sapUiCalItemSelEnd\"),h=!0),s.removeClass(\"sapUiCalItemSelBetween\")):a&&i._isBetween(g,e,a)?(s.addClass(\"sapUiCalItemSel\"),s.attr(\"aria-selected\",\"true\"),s.addClass(\"sapUiCalItemSelBetween\"),s.removeClass(\"sapUiCalItemSelStart\"),s.removeClass(\"sapUiCalItemSelEnd\")):a&&g.isSame(a)?(s.addClass(\"sapUiCalItemSelEnd\"),h=!0,s.addClass(\"sapUiCalItemSel\"),s.attr(\"aria-selected\",\"true\"),s.removeClass(\"sapUiCalItemSelStart\"),s.removeClass(\"sapUiCalItemSelBetween\")):(s.hasClass(\"sapUiCalItemSel\")&&(s.removeClass(\"sapUiCalItemSel\"),s.attr(\"aria-selected\",\"false\")),s.hasClass(\"sapUiCalItemSelStart\")?s.removeClass(\"sapUiCalItemSelStart\"):s.hasClass(\"sapUiCalItemSelBetween\")?s.removeClass(\"sapUiCalItemSelBetween\"):s.hasClass(\"sapUiCalItemSelEnd\")&&s.removeClass(\"sapUiCalItemSelEnd\")),C.call(this,s,l,h)}else{var c=this._oFormatYyyymm.format(e.toUTCJSDate(),!0);for(r=0;r<n.length;r++)s=t(n[r]),l=!1,h=!1,s.attr(\"data-sap-month\")==c?(s.addClass(\"sapUiCalItemSel\"),s.attr(\"aria-selected\",\"true\"),l=!0):s.hasClass(\"sapUiCalItemSel\")&&(s.removeClass(\"sapUiCalItemSel\"),s.attr(\"aria-selected\",\"false\")),s.hasClass(\"sapUiCalItemSelStart\")?s.removeClass(\"sapUiCalItemSelStart\"):s.hasClass(\"sapUiCalItemSelBetween\")?s.removeClass(\"sapUiCalItemSelBetween\"):s.hasClass(\"sapUiCalItemSelEnd\")&&s.removeClass(\"sapUiCalItemSelEnd\"),C.call(this,s,l,h)}}function C(t,e,a){if(this.getIntervalSelection()){var s=\"\",i=[],o=this.getId(),n=!1;s=t.attr(\"aria-describedby\"),s&&(i=s.split(\" \"));for(var r=-1,l=-1,h=0;h<i.length;h++){var g=i[h];g==o+\"-Start\"&&(r=h),g==o+\"-End\"&&(l=h)}r>=0&&!e&&(i.splice(r,1),n=!0,l>r&&l--),l>=0&&!a&&(i.splice(l,1),n=!0),r<0&&e&&(i.push(o+\"-Start\"),n=!0),l<0&&a&&(i.push(o+\"-End\"),n=!0),n&&(s=i.join(\" \"),t.attr(\"aria-describedby\",s))}}function I(){this._bMouseMove&&w.call(this,!0),this.fireSelect()}function b(){if(!this._bNamesLengthChecked){for(var e,a=0,s=this.$(\"months\").children(),i=!1,o=this.getMonths(),n=Math.ceil(12/o),r=0,l=this._getLocaleData(),h=l.getMonthsStandAlone(\"wide\"),g=0;g<n;g++){if(o<12){for(a=0;a<s.length;a++)e=t(t(s[a]).children(\".sapUiCalItemText\")),e.text(h[(a+r)%12]);r+=o,r>11&&(r=11)}for(a=0;a<s.length;a++){var c=s[a];if(Math.abs(c.clientWidth-c.scrollWidth)>1){i=!0;break}}if(i)break}if(o<12)for(r=this._getStartDate().getMonth(),a=0;a<s.length;a++)e=t(t(s[a]).children(\".sapUiCalItemText\")),e.text(h[(a+r)%12]);if(i){this._bLongMonth=!1;var p=l.getMonthsStandAlone(\"abbreviated\");for(r=this._getStartDate().getMonth(),a=0;a<s.length;a++)e=t(t(s[a]).children(\".sapUiCalItemText\")),e.text(p[(a+r)%12])}else this._bLongMonth=!0;this._bNamesLengthChecked=!0}}function M(){this._sInvalidateMonths=void 0,v.call(this,this._bNoFocus),this._bDateRangeChanged=void 0,this._bNoFocus=void 0}function L(){t(window.document).bind(\"mousemove\",this._mouseMoveProxy),this._bMouseMove=!0}function w(){t(window.document).unbind(\"mousemove\",this._mouseMoveProxy),this._bMouseMove=void 0}var U=l.CalendarType,N=e.extend(\"sap.ui.unified.calendar.MonthsRow\",{metadata:{library:\"sap.ui.unified\",properties:{date:{type:\"object\",group:\"Data\"},startDate:{type:\"object\",group:\"Data\"},months:{type:\"int\",group:\"Appearance\",defaultValue:12},intervalSelection:{type:\"boolean\",group:\"Behavior\",defaultValue:!1},singleSelection:{type:\"boolean\",group:\"Behavior\",defaultValue:!0},showHeader:{type:\"boolean\",group:\"Appearance\",defaultValue:!1}},aggregations:{selectedDates:{type:\"sap.ui.unified.DateRange\",multiple:!0,singularName:\"selectedDate\"},specialDates:{type:\"sap.ui.unified.DateTypeRange\",multiple:!0,singularName:\"specialDate\"}},associations:{ariaLabelledBy:{type:\"sap.ui.core.Control\",multiple:!0,singularName:\"ariaLabelledBy\"},legend:{type:\"sap.ui.unified.CalendarLegend\",multiple:!1}},events:{select:{},focus:{parameters:{date:{type:\"object\"},notVisible:{type:\"boolean\"}}}}}});return N.prototype.init=function(){this._oFormatYyyymm=r.getInstance({pattern:\"yyyyMMdd\",calendarType:U.Gregorian}),this._oFormatLong=r.getInstance({pattern:\"MMMM y\"}),this._mouseMoveProxy=t.proxy(this._handleMouseMove,this),this._rb=sap.ui.getCore().getLibraryResourceBundle(\"sap.ui.unified\")},N.prototype.exit=function(){this._oItemNavigation&&(this.removeDelegate(this._oItemNavigation),this._oItemNavigation.destroy(),delete this._oItemNavigation),this._sInvalidateMonths&&t.sap.clearDelayedCall(this._sInvalidateMonths)},N.prototype.onAfterRendering=function(){c.call(this),b.call(this)},N.prototype.onsapfocusleave=function(e){e.relatedControlId&&t.sap.containsOrEquals(this.getDomRef(),sap.ui.getCore().byId(e.relatedControlId).getFocusDomRef())||(this._bMouseMove&&(w.call(this,!0),S.call(this,this._getDate()),this._bMoveChange=!1,this._bMousedownChange=!1,I.call(this)),this._bMousedownChange&&(this._bMousedownChange=!1,I.call(this)))},N.prototype.invalidate=function(a){this._bDateRangeChanged||a&&a instanceof sap.ui.unified.DateRange?this.getDomRef()&&!this._sInvalidateMonths&&(this._bInvalidateSync?M.call(this):this._sInvalidateMonths=t.sap.delayedCall(0,this,M)):e.prototype.invalidate.apply(this,arguments)},N.prototype.removeAllSelectedDates=function(){return this._bDateRangeChanged=!0,this.removeAllAggregation(\"selectedDates\")},N.prototype.destroySelectedDates=function(){return this._bDateRangeChanged=!0,this.destroyAggregation(\"selectedDates\")},N.prototype.removeAllSpecialDates=function(){return this._bDateRangeChanged=!0,this.removeAllAggregation(\"specialDates\")},N.prototype.destroySpecialDates=function(){return this._bDateRangeChanged=!0,this.destroyAggregation(\"specialDates\")},N.prototype.setDate=function(t){return D.call(this,o.fromLocalJSDate(t),!1),this},N.prototype._setDate=function(t){var e=t.toLocalJSDate();this.setProperty(\"date\",e,!0),this._oDate=t},N.prototype._getDate=function(){return this._oDate||(this._oDate=new o),this._oDate},N.prototype.setStartDate=function(t){i._checkJSDateObject(t);var e,a,s;return a=t.getFullYear(),i._checkYearInValidRange(a),e=o.fromLocalJSDate(t),this.setProperty(\"startDate\",t,!0),this._oStartDate=e,this._oStartDate.setDate(1),this.getDomRef()&&(s=this._getDate().toLocalJSDate(),this._bNoRangeCheck=!0,this.displayDate(t),this._bNoRangeCheck=!1,s&&this.checkDateFocusable(s)&&this.setDate(s)),this},N.prototype._getStartDate=function(){return this._oStartDate||(this._oStartDate=new o,this._oStartDate.setDate(1)),this._oStartDate},N.prototype.displayDate=function(t){return D.call(this,o.fromLocalJSDate(t),!0),this},N.prototype._getLocale=function(){var t=this.getParent();return t&&t.getLocale?t.getLocale():(this._sLocale||(this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString()),this._sLocale)},N.prototype._getLocaleData=function(){var t=this.getParent();if(t&&t._getLocaleData)return t._getLocaleData();if(!this._oLocaleData){var e=this._getLocale(),s=new h(e);this._oLocaleData=a.getInstance(s)}return this._oLocaleData},N.prototype._getFormatLong=function(){var t=this._getLocale();if(this._oFormatLong.oLocale.toString()!=t){var e=new h(t);this._oFormatLong=r.getInstance({style:\"long\"},e)}return this._oFormatLong},N.prototype.getIntervalSelection=function(){var t=this.getParent();return t&&t.getIntervalSelection?t.getIntervalSelection():this.getProperty(\"intervalSelection\")},N.prototype.getSingleSelection=function(){var t=this.getParent();return t&&t.getSingleSelection?t.getSingleSelection():this.getProperty(\"singleSelection\")},N.prototype.getSelectedDates=function(){var t=this.getParent();return t&&t.getSelectedDates?t.getSelectedDates():this.getAggregation(\"selectedDates\",[])},N.prototype.getSpecialDates=function(){var t=this.getParent();return t&&t.getSpecialDates?t.getSpecialDates():this.getAggregation(\"specialDates\",[])},N.prototype._getShowHeader=function(){var t=this.getParent();return t&&t._getShowItemHeader?t._getShowItemHeader():this.getProperty(\"showHeader\")},N.prototype.getAriaLabelledBy=function(){var t=this.getParent();return t&&t.getAriaLabelledBy?t.getAriaLabelledBy():this.getAssociation(\"ariaLabelledBy\",[])},N.prototype.getLegend=function(){var t=this.getParent();return t&&t.getLegend?t.getLegend():this.getAssociation(\"ariaLabelledBy\",[])},N.prototype._checkDateSelected=function(t){var e,a,s,n,r,l,h,g=0,c=0,p=0;for(i._checkCalendarDate(t),l=this.getSelectedDates(),h=new o(t),h.setDate(1),n=h.toUTCJSDate().getTime(),r=0;r<l.length;r++){if(e=l[r],a=e.getStartDate(),g=0,a&&(a=o.fromLocalJSDate(a),a.setDate(1),g=a.toUTCJSDate().getTime()),s=e.getEndDate(),c=0,s&&(s=o.fromLocalJSDate(s),s.setDate(1),c=s.toUTCJSDate().getTime()),n==g&&!s){p=1;break}if(n==g&&s){p=2,s&&n==c&&(p=5);break}if(s&&n==c){p=3;break}if(s&&n>g&&n<c){p=4;break}if(this.getSingleSelection())break}return p},N.prototype._getDateType=function(t){i._checkCalendarDate(t);var e,a,s,n,r,l,h=0,g=0,c=this.getSpecialDates(),p=new o(t);for(p.setDate(1),l=p.toUTCJSDate().getTime(),s=0;s<c.length;s++)if(a=c[s],n=a.getStartDate(),h=0,n&&(n=o.fromLocalJSDate(n),n.setDate(1),h=n.toUTCJSDate().getTime()),r=a.getEndDate(),g=0,r&&(r=o.fromLocalJSDate(r),r.setDate(i._daysInMonth(r)),g=r.toUTCJSDate().getTime()),l==h&&!r||l>=h&&l<=g){e={type:a.getType(),tooltip:a.getTooltip_AsString()};break}return e},N.prototype._checkMonthEnabled=function(t){i._checkCalendarDate(t);var e=this.getParent();return!(e&&e._oMinDate&&e._oMaxDate&&i._isOutside(t,e._oMinDate,e._oMaxDate))},N.prototype._handleMouseMove=function(e){this.$().is(\":visible\")||w.call(this,!0);var a=t(e.target);if(a.hasClass(\"sapUiCalItemText\")&&(a=a.parent()),a.hasClass(\"sapUiCalItem\")){var s=this._getDate(),i=o.fromLocalJSDate(this._oFormatYyyymm.parse(a.attr(\"data-sap-month\")));i.setDate(1),i.isSame(s)||(this._setDate(i),S.call(this,i,!0),this._bMoveChange=!0)}},N.prototype.onmouseup=function(e){if(this._bMouseMove){w.call(this,!0);for(var a=this._getDate(),s=this._oItemNavigation.getItemDomRefs(),i=0;i<s.length;i++){var n=t(s[i]);if(n.attr(\"data-sap-month\")==this._oFormatYyyymm.format(a.toUTCJSDate(),!0)){n.focus();break}}if(this._bMoveChange){var r=t(e.target);r.hasClass(\"sapUiCalItemText\")&&(r=r.parent()),r.hasClass(\"sapUiCalItem\")&&(a=o.fromLocalJSDate(this._oFormatYyyymm.parse(r.attr(\"data-sap-month\"))),a.setDate(1)),S.call(this,a),this._bMoveChange=!1,this._bMousedownChange=!1,I.call(this)}}this._bMousedownChange&&(this._bMousedownChange=!1,I.call(this))},N.prototype.onsapselect=function(t){S.call(this,this._getDate())&&I.call(this),t.stopPropagation(),t.preventDefault()},N.prototype.onsapselectmodifiers=function(t){this.onsapselect(t)},N.prototype.onsappageupmodifiers=function(t){var e=new o(this._getDate()),a=e.getYear();if(t.metaKey||t.ctrlKey)e.setYear(a-10);else{var s=this.getMonths();s<=12?e.setYear(a-1):e.setMonth(e.getMonth()-s)}this.fireFocus({date:e.toLocalJSDate(),notVisible:!0}),t.preventDefault()},N.prototype.onsappagedownmodifiers=function(t){var e=new o(this._getDate()),a=e.getYear();if(t.metaKey||t.ctrlKey)e.setYear(a+10);else{var s=this.getMonths();s<=12?e.setYear(a+1):e.setMonth(e.getMonth()+s)}this.fireFocus({date:e.toLocalJSDate(),notVisible:!0}),t.preventDefault()},N.prototype.onThemeChanged=function(){if(!this._bNoThemeChange){this._bNamesLengthChecked=void 0,this._bLongWeekDays=void 0;for(var e=this._getLocaleData(),a=e.getMonthsStandAlone(\"wide\"),s=this.$(\"months\").children(),i=this._getStartDate().getMonth(),o=0;o<s.length;o++){t(t(s[o]).children(\".sapUiCalItemText\")).text(a[(o+i)%12])}b.call(this)}},N.prototype.checkDateFocusable=function(t){if(i._checkJSDateObject(t),this._bNoRangeCheck)return!1;var e=this._getStartDate(),a=new o(e);a.setDate(1),a.setMonth(a.getMonth()+this.getMonths());var s=o.fromLocalJSDate(t);return s.isSameOrAfter(e)&&s.isBefore(a)},N.prototype.applyFocusInfo=function(t){return this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex()),this},N});",
	"sap/ui/unified/calendar/MonthsRowRenderer.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/unified/calendar/CalendarUtils\",\"sap/ui/unified/calendar/CalendarDate\",\"sap/ui/unified/CalendarLegendRenderer\",\"sap/ui/unified/library\"],function(e,t,a,d,i){\"use strict\";var r=i.CalendarDayType,n={};return n.render=function(e,t){var a=t._getStartDate(),d=t.getTooltip_AsString(),i=t.getId(),r={value:i+\"-Descr\",append:!0};e.write(\"<div\"),e.writeControlData(t),e.addClass(\"sapUiCalMonthsRow\"),e.addClass(\"sapUiCalRow\"),e.writeClasses(),d&&e.writeAttributeEscaped(\"title\",d),t._getShowHeader()&&(r.value=r.value+\" \"+i+\"-Head\"),e.writeAccessibilityState(t,{role:\"grid\",readonly:\"true\",multiselectable:!t.getSingleSelection()||t.getIntervalSelection(),labelledby:r}),e.write(\">\"),e.write('<span id=\"'+i+'-Descr\" style=\"display: none;\">'+t._rb.getText(\"CALENDAR_DIALOG\")+\"</span>\"),t.getIntervalSelection()&&(e.write('<span id=\"'+i+'-Start\" style=\"display: none;\">'+t._rb.getText(\"CALENDAR_START_MONTH\")+\"</span>\"),e.write('<span id=\"'+i+'-End\" style=\"display: none;\">'+t._rb.getText(\"CALENDAR_END_MONTH\")+\"</span>\")),this.renderRow(e,t,a),e.write(\"</div>\")},n.renderRow=function(e,t,a){var d=t.getId();this.renderHeader(e,t,a),e.write('<div id=\"'+d+'-months\" class=\"sapUiCalItems\">'),this.renderMonths(e,t,a),e.write(\"</div>\")},n.renderHeader=function(e,a,d){if(t._checkCalendarDate(d),a._getShowHeader()){var i=a._getLocaleData(),r=a.getId();e.write('<div id=\"'+r+'-Head\">'),this.renderHeaderLine(e,a,i,d),e.write(\"</div>\")}},n.renderHeaderLine=function(e,d,i,r){t._checkCalendarDate(r);var n=d.getId(),s=d.getMonths(),l=new a(r),o=\"\",c=0,g=[],h=0;for(h=0;h<s;h++)c=l.getYear(),g.length>0&&g[g.length-1].iYear==c?g[g.length-1].iMonths++:g.push({iYear:c,iMonths:1}),l.setMonth(l.getMonth()+1);for(h=0;h<g.length;h++){var C=g[h];o=100/s*C.iMonths+\"%\",e.write('<div id=\"'+n+\"-Head\"+h+'\"class=\"sapUiCalHeadText\" style=\"width:'+o+'\">'),e.write(C.iYear),e.write(\"</div>\")}},n.renderMonths=function(e,t,d){var i=this.getHelper(t,d),r=t.getMonths(),n=100/r+\"%\",s=new a(d);s.setDate(1);for(var l=0;l<r;l++)this.renderMonth(e,t,s,i,n),s.setMonth(s.getMonth()+1)},n.getHelper=function(d,i){t._checkCalendarDate(i);var r={};r.sLocale=d._getLocale(),r.oLocaleData=d._getLocaleData(),r.oToday=new a,r.sCurrentMonth=d._rb.getText(\"CALENDAR_CURRENT_MONTH\"),r.sId=d.getId(),r.oFormatLong=d._getFormatLong(),d._bLongMonth||!d._bNamesLengthChecked?r.aMonthNames=r.oLocaleData.getMonthsStandAlone(\"wide\"):(r.aMonthNames=r.oLocaleData.getMonthsStandAlone(\"abbreviated\"),r.aMonthNamesWide=r.oLocaleData.getMonthsStandAlone(\"wide\"));var n=d.getLegend();if(n){var s=sap.ui.getCore().byId(n);if(s){if(!(s instanceof sap.ui.unified.CalendarLegend))throw new Error(s+\" is not an sap.ui.unified.CalendarLegend. \"+d);r.oLegend=s}else e.sap.log.warning(\"CalendarLegend \"+n+\" does not exist!\",d)}return r},n.renderMonth=function(e,a,i,n,s){t._checkCalendarDate(i);var l={role:\"gridcell\",selected:!1,label:\"\",describedby:\"\"};!a._bLongMonth&&a._bNamesLengthChecked&&(l.label=n.aMonthNamesWide[i.getMonth()]);var o=a._oFormatYyyymm.format(i.toUTCJSDate(),!0),c=a._checkDateSelected(i),g=a._getDateType(i),h=a._checkMonthEnabled(i);e.write(\"<div\"),e.writeAttribute(\"id\",n.sId+\"-\"+o),e.addClass(\"sapUiCalItem\"),s&&e.addStyle(\"width\",s),t._isSameMonthAndYear(i,n.oToday)&&(e.addClass(\"sapUiCalItemNow\"),l.label=n.sCurrentMonth+\" \"),c>0&&(e.addClass(\"sapUiCalItemSel\"),l.selected=!0),2==c?(e.addClass(\"sapUiCalItemSelStart\"),l.describedby=l.describedby+\" \"+n.sId+\"-Start\"):3==c?(e.addClass(\"sapUiCalItemSelEnd\"),l.describedby=l.describedby+\" \"+n.sId+\"-End\"):4==c?e.addClass(\"sapUiCalItemSelBetween\"):5==c&&(e.addClass(\"sapUiCalItemSelStart\"),e.addClass(\"sapUiCalItemSelEnd\"),l.describedby=l.describedby+\" \"+n.sId+\"-Start\",l.describedby=l.describedby+\" \"+n.sId+\"-End\"),g&&g.type!=r.None&&(e.addClass(\"sapUiCalItem\"+g.type),g.tooltip&&e.writeAttributeEscaped(\"title\",g.tooltip)),h||(e.addClass(\"sapUiCalItemDsbl\"),l.disabled=!0),e.writeAttribute(\"tabindex\",\"-1\"),e.writeAttribute(\"data-sap-month\",o),l.label=l.label+n.oFormatLong.format(i.toUTCJSDate(),!0),g&&g.type!=r.None&&d.addCalendarTypeAccInfo(l,g.type,n.oLegend),e.writeAccessibilityState(null,l),e.writeClasses(),e.writeStyles(),e.write(\">\"),e.write(\"<span\"),e.addClass(\"sapUiCalItemText\"),e.writeClasses(),e.write(\">\"),e.write(n.aMonthNames[i.getMonth()]),e.write(\"</span>\"),e.write(\"</div>\")},n},!0);",
	"sap/ui/unified/calendar/OneMonthDatesRow.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"sap/ui/unified/calendar/DatesRow\",\"sap/ui/unified/calendar/CalendarUtils\",\"sap/ui/unified/calendar/CalendarDate\",\"sap/ui/unified/library\",\"./OneMonthDatesRowRenderer\"],function(t,e,a,i,o){\"use strict\";function s(t){t.stopPropagation(),t.preventDefault(),t.stopImmediatePropagation(!0)}var n=t.extend(\"sap.ui.unified.calendar.OneMonthDatesRow\",{metadata:{library:\"sap.ui.unified\"}});return n.prototype.init=function(){t.prototype.init.apply(this,arguments),this.iMode=2},n.prototype.setMode=function(t){var e,a=this.getSelectedDates(),i=this.iMode!==t;return this.iMode=t,i&&a.length&&(this.iMode<2&&(e=this.getStartDate()),a[0].setProperty(\"startDate\",e,!0)),this},n.prototype.getMode=function(){return this.iMode},n.prototype.selectDate=function(t){return this.iMode<2&&this.getSelectedDates().length&&this.getSelectedDates()[0].setStartDate(t),this},n.prototype.setDate=function(e){return this._bNoRangeCheck||this.checkDateFocusable(e)?(t.prototype.setDate.apply(this,arguments),this):this},n.prototype.displayDate=function(e){return this._bNoRangeCheck||this.checkDateFocusable(e)?(t.prototype.displayDate.apply(this,arguments),this):this},n.prototype.onsaphome=function(t){var e=a.fromLocalJSDate(this.getStartDate());s(t),this._setDate(e),this._focusDate(e),this.fireFocus({date:e.toLocalJSDate(),otherMonth:!1})},n.prototype.onsapend=function(t){var i,o=this.getStartDate();i=a.fromLocalJSDate(o),i.setDate(e._daysInMonth(i)),s(t),this._setDate(i),this._focusDate(i),this.fireFocus({date:i.toLocalJSDate(),otherMonth:!1})},n});",
	"sap/ui/unified/calendar/OneMonthDatesRowRenderer.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"sap/ui/core/Renderer\",\"./MonthRenderer\",\"./DatesRowRenderer\"],function(e,r,n){\"use strict\";var t=e.extend(n);return[\"getClass\",\"renderMonth\",\"renderDays\",\"renderHeader\"].forEach(function(e){t[e]=function(t,a){return a.iMode<2?r[e].apply(r,arguments):n[e].apply(n,arguments)}}),t},!0);",
	"sap/ui/unified/calendar/TimesRow.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/core/Control\",\"sap/ui/core/LocaleData\",\"sap/ui/core/delegate/ItemNavigation\",\"sap/ui/unified/calendar/CalendarUtils\",\"sap/ui/core/date/UniversalDate\",\"sap/ui/unified/library\",\"sap/ui/core/format/DateFormat\",\"sap/ui/core/library\",\"sap/ui/core/Locale\",\"./TimesRowRenderer\"],function(e,t,a,i,s,r,o,n,l,g,h){\"use strict\";function c(){for(var t=this._getDate(),a=this._oFormatYyyyMMddHHmm.format(t.getJSDate(),!0),s=0,r=this.$(\"times\").get(0),o=this.$(\"times\").children(\".sapUiCalItem\"),n=0;n<o.length;n++){if(e(o[n]).attr(\"data-sap-time\")===a){s=n;break}}this._oItemNavigation||(this._oItemNavigation=new i,this._oItemNavigation.attachEvent(i.Events.AfterFocus,m,this),this._oItemNavigation.attachEvent(i.Events.FocusAgain,p,this),this._oItemNavigation.attachEvent(i.Events.BorderReached,u,this),this.addDelegate(this._oItemNavigation),this._oItemNavigation.setDisabledModifiers({sapnext:[\"alt\"],sapprevious:[\"alt\"],saphome:[\"alt\"],sapend:[\"alt\"]}),this._oItemNavigation.setCycling(!1),this._oItemNavigation.setColumns(1,!0)),this._oItemNavigation.setRootDomRef(r),this._oItemNavigation.setItemDomRefs(o),this._oItemNavigation.setFocusedIndex(s),this._oItemNavigation.setPageSize(o.length)}function m(t){var a=t.getParameter(\"index\"),i=t.getParameter(\"event\");if(i){var o=this._getDate(),n=new r(o.getTime()),l=this._oItemNavigation.getItemDomRefs(),g=e(l[a]);n=new r(this._oFormatYyyyMMddHHmm.parse(g.attr(\"data-sap-time\"),!0).getTime()),this._setDate(n),this.fireFocus({date:s._createLocalDate(n,!0),notVisible:!1}),\"mousedown\"==i.type&&d.call(this,i,n,a)}}function p(e){var t=e.getParameter(\"index\"),a=e.getParameter(\"event\");if(a&&\"mousedown\"==a.type){var i=this._getDate();d.call(this,a,i,t)}}function u(e){var t=e.getParameter(\"event\"),a=this.getItems(),i=this.getIntervalMinutes(),o=this._getDate(),n=new r(o.getTime());if(t.type){switch(t.type){case\"sapnext\":case\"sapnextmodifiers\":n.setUTCMinutes(n.getUTCMinutes()+i);break;case\"sapprevious\":case\"sappreviousmodifiers\":n.setUTCMinutes(n.getUTCMinutes()-i);break;case\"sappagedown\":n.setUTCMinutes(n.getUTCMinutes()+i*a);break;case\"sappageup\":n.setUTCMinutes(n.getUTCMinutes()-i*a)}this.fireFocus({date:s._createLocalDate(n,!0),notVisible:!0})}}function d(e,t,a){if(!e.button){C.call(this,t)&&(this._bMousedownChange=!0),this._bMouseMove?(b.call(this,!0),this._bMoveChange=!1):this.getIntervalSelection()&&this.$().is(\":visible\")&&U.call(this,!0),e.preventDefault(),e.setMark(\"cancelAutoClose\")}}function v(t,a){s._checkJSDateObject(t);var i=t.getFullYear();s._checkYearInValidRange(i);var r=!0;if(!e.sap.equal(this.getDate(),t)){var o=s._createUniversalUTCDate(t,void 0,!0);if(o=this._getIntervalStart(o),r=this.checkDateFocusable(t),!this._bNoRangeCheck&&!r)throw new Error(\"Date must be in visible date range; \"+this);this.setProperty(\"date\",t,!0),this._oUTCDate=o}this.getDomRef()&&(r?_.call(this,this._oUTCDate,a):D.call(this,a))}function _(t,a){for(var i,s=this._oFormatYyyyMMddHHmm.format(t.getJSDate(),!0),r=this._oItemNavigation.getItemDomRefs(),o=0;o<r.length;o++)if(i=e(r[o]),i.attr(\"data-sap-time\")==s){document.activeElement!=r[o]&&(a?this._oItemNavigation.setFocusedIndex(o):this._oItemNavigation.focusItem(o));break}}function D(e){var t=this._getStartDate(),a=this.$(\"times\");if(a.length>0){var i=sap.ui.getCore().createRenderManager();this.getRenderer().renderTimes(i,this,t),i.flush(a[0]),i.destroy()}f.call(this),c.call(this),e||this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex())}function f(){var e=this._getStartDate();if(this._getShowHeader()){var t=this.$(\"Head\");if(t.length>0){var a=this._getLocaleData(),i=sap.ui.getCore().createRenderManager();this.getRenderer().renderHeaderLine(i,this,a,e),i.flush(t[0]),i.destroy()}}}function C(t,a){if(!this._checkTimeEnabled(t))return!1;var i,r,o,n,l=this.getSelectedDates(),g=this._oItemNavigation.getItemDomRefs(),h=0,c=this.getParent(),m=this;if(c&&c.getSelectedDates&&(m=c),this.getSingleSelection())if(l.length>0?(i=l[0],(n=i.getStartDate())&&(n=s._createUniversalUTCDate(n,void 0,!0),n=this._getIntervalStart(n))):(i=new sap.ui.unified.DateRange,m.addAggregation(\"selectedDates\",i,!0)),this.getIntervalSelection()&&(!i.getEndDate()||a)&&n){var p;t.getTime()<n.getTime()?(p=n,n=t,a||(i.setProperty(\"startDate\",s._createLocalDate(new Date(n.getTime()),!0),!0),i.setProperty(\"endDate\",s._createLocalDate(new Date(p.getTime()),!0),!0))):t.getTime()>=n.getTime()&&(p=t,a||i.setProperty(\"endDate\",s._createLocalDate(new Date(p.getTime()),!0),!0)),y.call(this,n,p)}else y.call(this,t),i.setProperty(\"startDate\",s._createLocalDate(new Date(t.getTime()),!0),!0),i.setProperty(\"endDate\",void 0,!0);else{if(this.getIntervalSelection())throw new Error(\"Calender don't support multiple interval selection\");var u=this._checkDateSelected(t);if(u>0){for(h=0;h<l.length;h++)if((n=l[h].getStartDate())&&(n=s._createUniversalUTCDate(n,void 0,!0),n=this._getIntervalStart(n),t.getTime()==n.getTime())){m.removeAggregation(\"selectedDates\",h,!0);break}}else i=new sap.ui.unified.DateRange({startDate:s._createLocalDate(new Date(t.getTime()),!0)}),m.addAggregation(\"selectedDates\",i,!0);for(o=this._oFormatYyyyMMddHHmm.format(t.getJSDate(),!0),h=0;h<g.length;h++)r=e(g[h]),r.attr(\"data-sap-time\")==o&&(u>0?(r.removeClass(\"sapUiCalItemSel\"),r.attr(\"aria-selected\",\"false\")):(r.addClass(\"sapUiCalItemSel\"),r.attr(\"aria-selected\",\"true\")))}return!0}function y(t,a){var i,s=this._oItemNavigation.getItemDomRefs(),o=0,n=!1,l=!1;if(a){var g;for(o=0;o<s.length;o++)i=e(s[o]),n=!1,l=!1,g=new r(this._oFormatYyyyMMddHHmm.parse(i.attr(\"data-sap-time\"),!0).getTime()),g.getTime()==t.getTime()?(i.addClass(\"sapUiCalItemSelStart\"),n=!0,i.addClass(\"sapUiCalItemSel\"),i.attr(\"aria-selected\",\"true\"),a&&g.getTime()==a.getTime()&&(i.addClass(\"sapUiCalItemSelEnd\"),l=!0),i.removeClass(\"sapUiCalItemSelBetween\")):a&&g.getTime()>t.getTime()&&g.getTime()<a.getTime()?(i.addClass(\"sapUiCalItemSel\"),i.attr(\"aria-selected\",\"true\"),i.addClass(\"sapUiCalItemSelBetween\"),i.removeClass(\"sapUiCalItemSelStart\"),i.removeClass(\"sapUiCalItemSelEnd\")):a&&g.getTime()==a.getTime()?(i.addClass(\"sapUiCalItemSelEnd\"),l=!0,i.addClass(\"sapUiCalItemSel\"),i.attr(\"aria-selected\",\"true\"),i.removeClass(\"sapUiCalItemSelStart\"),i.removeClass(\"sapUiCalItemSelBetween\")):(i.hasClass(\"sapUiCalItemSel\")&&(i.removeClass(\"sapUiCalItemSel\"),i.attr(\"aria-selected\",\"false\")),i.hasClass(\"sapUiCalItemSelStart\")?i.removeClass(\"sapUiCalItemSelStart\"):i.hasClass(\"sapUiCalItemSelBetween\")?i.removeClass(\"sapUiCalItemSelBetween\"):i.hasClass(\"sapUiCalItemSelEnd\")&&i.removeClass(\"sapUiCalItemSelEnd\")),T.call(this,i,n,l)}else{var h=this._oFormatYyyyMMddHHmm.format(t.getJSDate(),!0);for(o=0;o<s.length;o++)i=e(s[o]),n=!1,l=!1,i.attr(\"data-sap-time\")==h?(i.addClass(\"sapUiCalItemSel\"),i.attr(\"aria-selected\",\"true\"),n=!0):i.hasClass(\"sapUiCalItemSel\")&&(i.removeClass(\"sapUiCalItemSel\"),i.attr(\"aria-selected\",\"false\")),i.hasClass(\"sapUiCalItemSelStart\")?i.removeClass(\"sapUiCalItemSelStart\"):i.hasClass(\"sapUiCalItemSelBetween\")?i.removeClass(\"sapUiCalItemSelBetween\"):i.hasClass(\"sapUiCalItemSelEnd\")&&i.removeClass(\"sapUiCalItemSelEnd\"),T.call(this,i,n,l)}}function T(e,t,a){if(this.getIntervalSelection()){var i=\"\",s=[],r=this.getId(),o=!1;i=e.attr(\"aria-describedby\"),i&&(s=i.split(\" \"));for(var n=-1,l=-1,g=0;g<s.length;g++){var h=s[g];h==r+\"-Start\"&&(n=g),h==r+\"-End\"&&(l=g)}n>=0&&!t&&(s.splice(n,1),o=!0,l>n&&l--),l>=0&&!a&&(s.splice(l,1),o=!0),n<0&&t&&(s.push(r+\"-Start\"),o=!0),l<0&&a&&(s.push(r+\"-End\"),o=!0),o&&(i=s.join(\" \"),e.attr(\"aria-describedby\",i))}}function I(){this._bMouseMove&&b.call(this,!0),this.fireSelect()}function S(){this._sInvalidateTimes=void 0,D.call(this,this._bNoFocus),this._bDateRangeChanged=void 0,this._bNoFocus=void 0}function U(){e(window.document).bind(\"mousemove\",this._mouseMoveProxy),this._bMouseMove=!0}function b(){e(window.document).unbind(\"mousemove\",this._mouseMoveProxy),this._bMouseMove=void 0}var M=l.CalendarType,w=t.extend(\"sap.ui.unified.calendar.TimesRow\",{metadata:{library:\"sap.ui.unified\",properties:{date:{type:\"object\",group:\"Data\"},startDate:{type:\"object\",group:\"Data\"},items:{type:\"int\",group:\"Appearance\",defaultValue:12},intervalMinutes:{type:\"int\",group:\"Appearance\",defaultValue:60},intervalSelection:{type:\"boolean\",group:\"Behavior\",defaultValue:!1},singleSelection:{type:\"boolean\",group:\"Behavior\",defaultValue:!0},showHeader:{type:\"boolean\",group:\"Appearance\",defaultValue:!1}},aggregations:{selectedDates:{type:\"sap.ui.unified.DateRange\",multiple:!0,singularName:\"selectedDate\"},specialDates:{type:\"sap.ui.unified.DateTypeRange\",multiple:!0,singularName:\"specialDate\"}},associations:{ariaLabelledBy:{type:\"sap.ui.core.Control\",multiple:!0,singularName:\"ariaLabelledBy\"},legend:{type:\"sap.ui.unified.CalendarLegend\",multiple:!1}},events:{select:{},focus:{parameters:{date:{type:\"object\"},notVisible:{type:\"boolean\"}}}}}});return w.prototype.init=function(){this._oFormatYyyyMMddHHmm=n.getInstance({pattern:\"yyyyMMddHHmm\",calendarType:M.Gregorian}),this._oFormatLong=n.getDateTimeInstance({style:\"long/short\"}),this._oFormatDate=n.getDateInstance({style:\"medium\"}),this._mouseMoveProxy=e.proxy(this._handleMouseMove,this),this._rb=sap.ui.getCore().getLibraryResourceBundle(\"sap.ui.unified\")},w.prototype.exit=function(){this._oItemNavigation&&(this.removeDelegate(this._oItemNavigation),this._oItemNavigation.destroy(),delete this._oItemNavigation),this._sInvalidateTimes&&e.sap.clearDelayedCall(this._sInvalidateTimes)},w.prototype.onAfterRendering=function(){c.call(this)},w.prototype.onsapfocusleave=function(t){t.relatedControlId&&e.sap.containsOrEquals(this.getDomRef(),sap.ui.getCore().byId(t.relatedControlId).getFocusDomRef())||(this._bMouseMove&&(b.call(this,!0),C.call(this,this._getDate()),this._bMoveChange=!1,this._bMousedownChange=!1,I.call(this)),this._bMousedownChange&&(this._bMousedownChange=!1,I.call(this)))},w.prototype.invalidate=function(a){this._bDateRangeChanged||a&&a instanceof sap.ui.unified.DateRange?this.getDomRef()&&!this._sInvalidateTimes&&(this._bInvalidateSync?S.call(this):this._sInvalidateTimes=e.sap.delayedCall(0,this,S)):t.prototype.invalidate.apply(this,arguments)},w.prototype.removeAllSelectedDates=function(){return this._bDateRangeChanged=!0,this.removeAllAggregation(\"selectedDates\")},w.prototype.destroySelectedDates=function(){return this._bDateRangeChanged=!0,this.destroyAggregation(\"selectedDates\")},w.prototype.removeAllSpecialDates=function(){return this._bDateRangeChanged=!0,this.removeAllAggregation(\"specialDates\")},w.prototype.destroySpecialDates=function(){return this._bDateRangeChanged=!0,this.destroyAggregation(\"specialDates\")},w.prototype.setIntervalMinutes=function(e){if(e>=720)throw new Error(\"Only intervals < 720 minutes are allowed; \"+this);if(1440%e>0)throw new Error(\"A day must be divisible by the interval size; \"+this);return this.setProperty(\"intervalMinutes\",e,!1),this._oFormatTime=void 0,this},w.prototype.setDate=function(e){return v.call(this,e,!1),this},w.prototype._setDate=function(e){var t=s._createLocalDate(e,!0);this.setProperty(\"date\",t,!0),this._oUTCDate=e},w.prototype._getDate=function(){return this._oUTCDate||(this._oUTCDate=s._createUniversalUTCDate(new Date,void 0,!0)),this._oUTCDate},w.prototype.setStartDate=function(e){s._checkJSDateObject(e);var t=e.getFullYear();s._checkYearInValidRange(t);var a=s._createUniversalUTCDate(e,void 0,!0);if(this.setProperty(\"startDate\",e,!0),this._oUTCStartDate=this._getIntervalStart(a),this.getDomRef()){var i=s._createLocalDate(this._getDate(),!0);this._bNoRangeCheck=!0,this.displayDate(e),this._bNoRangeCheck=!1,i&&this.checkDateFocusable(i)&&this.displayDate(i)}return this},w.prototype._getStartDate=function(){return this._oUTCStartDate||(this._oUTCStartDate=s._createUniversalUTCDate(new Date,void 0,!0),this._oUTCStartDate=this._getIntervalStart(this._oUTCStartDate)),this._oUTCStartDate},w.prototype.displayDate=function(e){return v.call(this,e,!0),this},w.prototype._getLocale=function(){var e=this.getParent();return e&&e.getLocale?e.getLocale():(this._sLocale||(this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString()),this._sLocale)},w.prototype._getLocaleData=function(){var e=this.getParent();if(e&&e._getLocaleData)return e._getLocaleData();if(!this._oLocaleData){var t=this._getLocale(),i=new g(t);this._oLocaleData=a.getInstance(i)}return this._oLocaleData},w.prototype._getFormatLong=function(){var e=this._getLocale();if(this._oFormatLong.oLocale.toString()!=e){var t=new g(e);this._oFormatLong=n.getInstance({style:\"long/short\"},t)}return this._oFormatLong},w.prototype._getFormatTime=function(){var e=this._getLocale();if(!this._oFormatTime||this._oFormatTime.oLocale.toString()!=e){var t,a=new g(e),i=this.getIntervalMinutes(),s=this._getLocaleData();this._oFormatTimeAmPm=void 0,i%60==0?(t=s.getPreferredHourSymbol(),s.getTimePattern(\"short\").search(\"a\")>=0&&(this._oFormatTimeAmPm=n.getTimeInstance({pattern:\"a\"},a))):(t=s.getTimePattern(\"short\"),t=t.replace(\"HH\",\"H\"),t=t.replace(\"hh\",\"h\"),t.search(\"a\")>=0&&(this._oFormatTimeAmPm=n.getTimeInstance({pattern:\"a\"},a),t=t.replace(\"a\",\"\").trim())),this._oFormatTime=n.getTimeInstance({pattern:t},a)}return this._oFormatTime},w.prototype._getFormatDate=function(){var e=this._getLocale();if(this._oFormatDate.oLocale.toString()!=e){var t=new g(e);this._oFormatDate=n.getDateInstance({style:\"medium\"},t)}return this._oFormatDate},w.prototype.getIntervalSelection=function(){var e=this.getParent();return e&&e.getIntervalSelection?e.getIntervalSelection():this.getProperty(\"intervalSelection\")},w.prototype.getSingleSelection=function(){var e=this.getParent();return e&&e.getSingleSelection?e.getSingleSelection():this.getProperty(\"singleSelection\")},w.prototype.getSelectedDates=function(){var e=this.getParent();return e&&e.getSelectedDates?e.getSelectedDates():this.getAggregation(\"selectedDates\",[])},w.prototype.getSpecialDates=function(){var e=this.getParent();return e&&e.getSpecialDates?e.getSpecialDates():this.getAggregation(\"specialDates\",[])},w.prototype._getShowHeader=function(){var e=this.getParent();return e&&e._getShowItemHeader?e._getShowItemHeader():this.getProperty(\"showHeader\")},w.prototype.getIntervalMinutes=function(){var e=this.getParent();return e&&e.getIntervalMinutes?e.getIntervalMinutes():this.getProperty(\"intervalMinutes\")},w.prototype.getAriaLabelledBy=function(){var e=this.getParent();return e&&e.getAriaLabelledBy?e.getAriaLabelledBy():this.getAssociation(\"ariaLabelledBy\",[])},w.prototype.getLegend=function(){var e=this.getParent();return e&&e.getLegend?e.getLegend():this.getAssociation(\"ariaLabelledBy\",[])},w.prototype._checkDateSelected=function(e){if(!(e instanceof r))throw new Error(\"Date must be a UniversalDate object \"+this);var t=0,a=this.getSelectedDates(),i=new r(e.getTime());i=this._getIntervalStart(i);for(var o=i.getTime(),n=0;n<a.length;n++){var l=a[n],g=l.getStartDate(),h=0;g&&(g=s._createUniversalUTCDate(g,void 0,!0),g=this._getIntervalStart(g),h=g.getTime());var c=l.getEndDate(),m=0;if(c&&(c=s._createUniversalUTCDate(c,void 0,!0),c=this._getIntervalStart(c),m=c.getTime()),o==h&&!c){t=1;break}if(o==h&&c){t=2,c&&o==m&&(t=5);break}if(c&&o==m){t=3;break}if(c&&o>h&&o<m){t=4;break}if(this.getSingleSelection())break}return t},w.prototype._getDateType=function(e){if(!(e instanceof r))throw new Error(\"Date must be a UniversalDate object \"+this);var t,a=this.getSpecialDates(),i=new r(e.getTime());i=this._getIntervalStart(i);for(var o=i.getTime(),n=0;n<a.length;n++){var l=a[n],g=l.getStartDate(),h=0;g&&(g=s._createUniversalUTCDate(g,void 0,!0),g=this._getIntervalStart(g),h=g.getTime());var c=l.getEndDate(),m=0;if(c?(c=s._createUniversalUTCDate(c,void 0,!0),c=this._getIntervalStart(c),c.setUTCMinutes(c.getUTCMinutes()+this.getIntervalMinutes()-1),m=c.getTime()):0==g.getUTCHours()&&0==g.getUTCMinutes()&&0==g.getUTCSeconds()&&0==g.getUTCMilliseconds()&&(c=new r(g.getTime()),c.setUTCDate(c.getUTCDate()+1),m=c.getTime()),o==h&&!c||o>=h&&o<=m){t={type:l.getType(),tooltip:l.getTooltip_AsString()};break}}return t},w.prototype._checkTimeEnabled=function(e){if(!(e instanceof r))throw new Error(\"Date must be a UniversalDate object \"+this);var t=e.getTime(),a=this.getParent();return!(a&&a._oMinDate&&a._oMaxDate&&(t<a._oMinDate.getTime()||t>a._oMaxDate.getTime()))},w.prototype._handleMouseMove=function(t){this.$().is(\":visible\")||b.call(this,!0);var a=e(t.target);if(a.hasClass(\"sapUiCalItemText\")&&(a=a.parent()),a.hasClass(\"sapUiCalItem\")){var i=this._getDate(),s=new r(this._oFormatYyyyMMddHHmm.parse(a.attr(\"data-sap-time\"),!0).getTime());s.getTime()!=i.getTime()&&(this._setDate(s),C.call(this,s,!0),this._bMoveChange=!0)}},w.prototype.onmouseup=function(t){if(this._bMouseMove){b.call(this,!0);for(var a=this._getDate(),i=this._oItemNavigation.getItemDomRefs(),s=0;s<i.length;s++){var o=e(i[s]);if(o.attr(\"data-sap-time\")==this._oFormatYyyyMMddHHmm.format(a.getJSDate(),!0)){o.focus();break}}if(this._bMoveChange){var n=e(t.target);n.hasClass(\"sapUiCalItemText\")&&(n=n.parent()),n.hasClass(\"sapUiCalItem\")&&(a=new r(this._oFormatYyyyMMddHHmm.parse(n.attr(\"data-sap-time\"),!0).getTime())),C.call(this,a),this._bMoveChange=!1,this._bMousedownChange=!1,I.call(this)}}this._bMousedownChange&&(this._bMousedownChange=!1,I.call(this))},w.prototype.onsapselect=function(e){C.call(this,this._getDate())&&I.call(this),e.stopPropagation(),e.preventDefault()},w.prototype.onsapselectmodifiers=function(e){this.onsapselect(e)},w.prototype.onsappageupmodifiers=function(e){var t=new r(this._getDate().getTime()),a=t.getUTCDate();e.metaKey||e.ctrlKey?t.setUTCDate(a-7):t.setUTCDate(a-1),this.fireFocus({date:s._createLocalDate(t,!0),notVisible:!0}),e.preventDefault()},w.prototype.onsappagedownmodifiers=function(e){var t=new r(this._getDate().getTime()),a=t.getUTCDate();e.metaKey||e.ctrlKey?t.setUTCDate(a+7):t.setUTCDate(a+1),this.fireFocus({date:s._createLocalDate(t,!0),notVisible:!0}),e.preventDefault()},w.prototype.checkDateFocusable=function(e){if(s._checkJSDateObject(e),this._bNoRangeCheck)return!1;var t=this._getStartDate(),a=new r(t.getTime());a.setUTCMinutes(a.getUTCMinutes()+this.getItems()*this.getIntervalMinutes());var i=s._createUniversalUTCDate(e,void 0,!0);return i.getTime()>=t.getTime()&&i.getTime()<a.getTime()},w.prototype.applyFocusInfo=function(e){return this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex()),this},w.prototype._getIntervalStart=function(e){var t=e.getTime(),a=new r(e.getTime());a.setUTCHours(0),a.setUTCMinutes(0),a.setUTCSeconds(0),a.setUTCMilliseconds(0);for(var i=this.getIntervalMinutes();a.getTime()<=t;)a.setUTCMinutes(a.getUTCMinutes()+i);var s=new r(a.getTime());return s.setUTCMinutes(s.getUTCMinutes()-i),s},w});",
	"sap/ui/unified/calendar/TimesRowRenderer.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/unified/calendar/CalendarUtils\",\"sap/ui/core/date/UniversalDate\",\"sap/ui/unified/CalendarLegendRenderer\",\"sap/ui/unified/library\"],function(e,t,a,i,r){\"use strict\";var s=r.CalendarDayType,d={};return d.render=function(e,t){var a=t._getStartDate(),i=t.getTooltip_AsString(),r=t.getId(),s={value:r+\"-Descr\",append:!0};e.write(\"<div\"),e.writeControlData(t),e.addClass(\"sapUiCalTimesRow\"),e.addClass(\"sapUiCalRow\"),e.writeClasses(),i&&e.writeAttributeEscaped(\"title\",i),t._getShowHeader()&&(s.value=s.value+\" \"+r+\"-Head\"),e.writeAccessibilityState(t,{role:\"grid\",readonly:\"true\",multiselectable:!t.getSingleSelection()||t.getIntervalSelection(),labelledby:s}),e.write(\">\"),e.write('<span id=\"'+r+'-Descr\" style=\"display: none;\">'+t._rb.getText(\"CALENDAR_DIALOG\")+\"</span>\"),t.getIntervalSelection()&&(e.write('<span id=\"'+r+'-Start\" style=\"display: none;\">'+t._rb.getText(\"CALENDAR_START_TIME\")+\"</span>\"),e.write('<span id=\"'+r+'-End\" style=\"display: none;\">'+t._rb.getText(\"CALENDAR_END_TIME\")+\"</span>\")),this.renderRow(e,t,a),e.write(\"</div>\")},d.renderRow=function(e,t,a){var i=t.getId();this.renderHeader(e,t,a),e.write('<div id=\"'+i+'-times\" class=\"sapUiCalItems\">'),this.renderTimes(e,t,a),e.write(\"</div>\")},d.renderHeader=function(e,t,a){if(t._getShowHeader()){var i=t._getLocaleData(),r=t.getId();e.write('<div id=\"'+r+'-Head\">'),this.renderHeaderLine(e,t,i,a),e.write(\"</div>\")}},d.renderHeaderLine=function(e,t,a,i){var r=t._getFormatDate(),s=t.getId(),d=t.getItems(),n=t._getIntervalStart(i),l=t.getIntervalMinutes(),o=\"\",m=0,g=[],p=0;for(p=0;p<d;p++)m=r.format(n,!0),g.length>0&&g[g.length-1].sDay==m?g[g.length-1].iItems++:g.push({sDay:m,iItems:1}),n.setUTCMinutes(n.getUTCMinutes()+l);for(p=0;p<g.length;p++){var C=g[p];o=100/d*C.iItems+\"%\",e.write('<div id=\"'+s+\"-Head\"+p+'\"class=\"sapUiCalHeadText\" style=\"width:'+o+'\">'),e.write(C.sDay),e.write(\"</div>\")}},d.renderTimes=function(e,t,a){for(var i=this.getHelper(t,a),r=t.getItems(),s=100/r+\"%\",d=t._getIntervalStart(a),n=\"\",l=\"\",o=0;o<r;o++)i.oFormatTimeAmPm&&(l=i.oFormatTimeAmPm.format(d,!0),n==l?l=\"\":n=l),this.renderTime(e,t,d,i,s,l),d.setUTCMinutes(d.getUTCMinutes()+i.iMinutes)},d.getHelper=function(a,i){var r={};r.sLocale=a._getLocale(),r.oLocaleData=a._getLocaleData(),r.oNow=t._createUniversalUTCDate(new Date,void 0,!0),r.sCurrentTime=a._rb.getText(\"CALENDAR_CURRENT_TIME\"),r.sId=a.getId(),r.oFormatLong=a._getFormatLong(),r.oFormatTime=a._getFormatTime(),r.oFormatTimeAmPm=a._oFormatTimeAmPm,r.iMinutes=a.getIntervalMinutes();var s=a.getLegend();if(s){var d=sap.ui.getCore().byId(s);if(d){if(!(d instanceof sap.ui.unified.CalendarLegend))throw new Error(d+\" is not an sap.ui.unified.CalendarLegend. \"+a);r.oLegend=d}else e.sap.log.warning(\"CalendarLegend \"+s+\" does not exist!\",a)}return r},d.renderTime=function(e,t,r,d,n,l){var o={role:\"gridcell\",selected:!1,label:\"\",describedby:\"\"},m=t._oFormatYyyyMMddHHmm.format(r.getJSDate(),!0),g=t._checkDateSelected(r),p=t._getDateType(r),C=t._checkTimeEnabled(r);e.write(\"<div\"),e.writeAttribute(\"id\",d.sId+\"-\"+m),e.addClass(\"sapUiCalItem\"),n&&e.addStyle(\"width\",n);var w=new a(r.getTime());w.setUTCMinutes(w.getUTCMinutes()+d.iMinutes),r.getTime()<=d.oNow.getTime()&&w.getTime()>d.oNow.getTime()&&(e.addClass(\"sapUiCalItemNow\"),o.label=d.sCurrentTime+\" \"),g>0&&(e.addClass(\"sapUiCalItemSel\"),o.selected=!0),2==g?(e.addClass(\"sapUiCalItemSelStart\"),o.describedby=o.describedby+\" \"+d.sId+\"-Start\"):3==g?(e.addClass(\"sapUiCalItemSelEnd\"),o.describedby=o.describedby+\" \"+d.sId+\"-End\"):4==g?e.addClass(\"sapUiCalItemSelBetween\"):5==g&&(e.addClass(\"sapUiCalItemSelStart\"),e.addClass(\"sapUiCalItemSelEnd\"),o.describedby=o.describedby+\" \"+d.sId+\"-Start\",o.describedby=o.describedby+\" \"+d.sId+\"-End\"),p&&p.type!=s.None&&(e.addClass(\"sapUiCalItem\"+p.type),p.tooltip&&e.writeAttributeEscaped(\"title\",p.tooltip)),C||(e.addClass(\"sapUiCalItemDsbl\"),o.disabled=!0),e.writeAttribute(\"tabindex\",\"-1\"),e.writeAttribute(\"data-sap-time\",m),o.label=o.label+d.oFormatLong.format(r,!0),p&&p.type!=s.None&&i.addCalendarTypeAccInfo(o,p.type,d.oLegend),e.writeAccessibilityState(null,o),e.writeClasses(),e.writeStyles(),e.write(\">\"),e.write(\"<span\"),e.addClass(\"sapUiCalItemText\"),e.writeClasses(),e.write(\">\"),e.write(d.oFormatTime.format(r,!0)),l&&(e.write(\"<span\"),e.addClass(\"sapUiCalItemTextAmPm\"),e.writeClasses(),e.write(\">\"),e.write(l),e.write(\"</span>\")),e.write(\"</span>\"),e.write(\"</div>\")},d},!0);",
	"sap/ui/unified/calendar/YearPicker.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/core/Control\",\"sap/ui/Device\",\"sap/ui/core/delegate/ItemNavigation\",\"sap/ui/unified/calendar/CalendarUtils\",\"sap/ui/unified/calendar/CalendarDate\",\"sap/ui/core/date/UniversalDate\",\"sap/ui/unified/library\",\"sap/ui/core/format/DateFormat\",\"sap/ui/core/library\",\"./YearPickerRenderer\",\"jquery.sap.keycodes\"],function(e,t,a,i,s,r,o,n,h,l,p){\"use strict\";function d(){var e=this.getYears(),t=this._getDate().getYear(),a=this._oMinDate.getYear(),s=this._oMaxDate.getYear(),r=this.getDomRef(),o=this.$().find(\".sapUiCalItem\"),n=Math.floor(e/2);t>s-Math.floor(e/2)?n=n+t-s+Math.floor(e/2):t<=a+Math.floor(e/2)&&(n=t-a),this._oItemNavigation||(this._oItemNavigation=new i,this._oItemNavigation.attachEvent(i.Events.AfterFocus,g,this),this._oItemNavigation.attachEvent(i.Events.FocusAgain,c,this),this._oItemNavigation.attachEvent(i.Events.BorderReached,y,this),this.addDelegate(this._oItemNavigation),this._oItemNavigation.setHomeEndColumnMode(!0,!0),this._oItemNavigation.setDisabledModifiers({sapnext:[\"alt\"],sapprevious:[\"alt\"],saphome:[\"alt\"],sapend:[\"alt\"]})),this._oItemNavigation.setRootDomRef(r),this._oItemNavigation.setItemDomRefs(o),this._oItemNavigation.setCycling(!1),this._oItemNavigation.setColumns(this.getColumns(),!0),this._oItemNavigation.setFocusedIndex(n),this._oItemNavigation.setPageSize(o.length)}function g(e){var t=e.getParameter(\"index\"),a=e.getParameter(\"event\");a&&\"mousedown\"==a.type&&m.call(this,a,t)}function c(e){var t=e.getParameter(\"index\"),a=e.getParameter(\"event\");a&&\"mousedown\"==a.type&&m.call(this,a,t)}function m(e,t){if(!e.button&&!a.support.touch){u.call(this,t)&&(this._bMousedownChange=!0),e.preventDefault(),e.setMark(\"cancelAutoClose\")}}function y(t){var a=t.getParameter(\"event\");if(a.type){var i=this.getYears(),s=this.getColumns();switch(0==s&&(s=i),a.type){case\"sapnext\":case\"sapnextmodifiers\":a.keyCode==e.sap.KeyCodes.ARROW_DOWN&&s<i?f.call(this,!0,this._oItemNavigation.getFocusedIndex()-i+s,!0):f.call(this,!0,0,!0);break;case\"sapprevious\":case\"sappreviousmodifiers\":a.keyCode==e.sap.KeyCodes.ARROW_UP&&s<i?f.call(this,!1,i-s+this._oItemNavigation.getFocusedIndex(),!0):f.call(this,!1,i-1,!0);break;case\"sappagedown\":f.call(this,!0,this._oItemNavigation.getFocusedIndex(),!0);break;case\"sappageup\":f.call(this,!1,this._oItemNavigation.getFocusedIndex(),!0)}}}function u(t){var a=this._oItemNavigation.getItemDomRefs(),i=e(a[t]);if(i.hasClass(\"sapUiCalItemDsbl\"))return!1;for(var s=i.attr(\"data-sap-year-start\"),o=r.fromLocalJSDate(this._oFormatYyyymmdd.parse(s)),n=this.getId()+\"-y\"+s,h=0;h<a.length;h++)i=e(a[h]),i.attr(\"id\")==n?(i.addClass(\"sapUiCalItemSel\"),i.attr(\"aria-selected\",\"true\")):(i.removeClass(\"sapUiCalItemSel\"),i.attr(\"aria-selected\",\"false\"));return this.setProperty(\"date\",o.toLocalJSDate(),!0),this.setProperty(\"year\",o.getYear(),!0),!0}function f(t,a,i){var s=this._oItemNavigation.getItemDomRefs(),o=r.fromLocalJSDate(this._oFormatYyyymmdd.parse(e(s[0]).attr(\"data-sap-year-start\")),this.getPrimaryCalendarType()),n=this.getYears();if(t){var h=new r(this._oMaxDate,this.getPrimaryCalendarType());if(h.setYear(h.getYear()-n+1),!o.isBefore(h))return;o.setYear(o.getYear()+n),o.isAfter(h)&&(a+=o.getYear()-h.getYear(),a>n-1&&(a=n-1),o=this._oMaxDate,o.setMonth(0),o.setDate(1))}else{if(!o.isAfter(this._oMinDate))return;o.setYear(o.getYear()-n),o.isBefore(this._oMinDate)&&(a-=this._oMinDate.getYear()-o.getYear(),a<0&&(a=0),o=new r(this._oMinDate,this.getPrimaryCalendarType()))}_.call(this,o,a),i&&this.firePageChange()}function _(t,a){var i,s=this._oFormatYyyymmdd.format(this._getDate().toUTCJSDate(),!0),n=!1,h=this._checkFirstDate(t);h.isSame(t)||(i=new r(t,this.getPrimaryCalendarType()),i.setYear(i.getYear()+a),t=h,n=!0);for(var l=this._oItemNavigation.getItemDomRefs(),p=new r(t,this.getPrimaryCalendarType()),d=0;d<l.length;d++){var g=this._oFormatYyyymmdd.format(p.toUTCJSDate(),!0),c=e(l[d]);c.attr(\"id\",this.getId()+\"-y\"+g),c.text(this._oYearFormat.format(o.getInstance(p.toUTCJSDate(),p.getCalendarType()),!0)),c.attr(\"data-sap-year-start\",g),c.hasClass(\"sapUiCalItemSel\")&&g!=s?(c.removeClass(\"sapUiCalItemSel\"),c.attr(\"aria-selected\",\"false\")):c.hasClass(\"sapUiCalItemSel\")||g!=s||(c.addClass(\"sapUiCalItemSel\"),c.attr(\"aria-selected\",\"true\"));var m=!0;n&&(m=this._checkDateEnabled(p),p.isSame(i)&&(a=d)),m?(c.removeClass(\"sapUiCalItemDsbl\"),c.removeAttr(\"aria-disabled\")):(c.addClass(\"sapUiCalItemDsbl\"),c.attr(\"aria-disabled\",!0)),p.setYear(p.getYear()+1)}this._oItemNavigation.focusItem(a)}var D=l.CalendarType,v=t.extend(\"sap.ui.unified.calendar.YearPicker\",{metadata:{library:\"sap.ui.unified\",properties:{year:{type:\"int\",group:\"Data\",defaultValue:2e3},years:{type:\"int\",group:\"Appearance\",defaultValue:20},columns:{type:\"int\",group:\"Appearance\",defaultValue:4},date:{type:\"object\",group:\"Data\"},primaryCalendarType:{type:\"sap.ui.core.CalendarType\",group:\"Appearance\"}},events:{select:{},pageChange:{}}}});return v.prototype.init=function(){var e=sap.ui.getCore().getConfiguration().getCalendarType();this.setProperty(\"primaryCalendarType\",e),this._oYearFormat=h.getDateInstance({format:\"y\",calendarType:e}),this._oFormatYyyymmdd=h.getInstance({pattern:\"yyyyMMdd\",calendarType:D.Gregorian}),this._oMinDate=s._minDate(this.getPrimaryCalendarType()),this._oMaxDate=s._maxDate(this.getPrimaryCalendarType())},v.prototype.onAfterRendering=function(){d.call(this)},v.prototype.setYear=function(e){this.setProperty(\"year\",e,!0),e=this.getProperty(\"year\");var t=r.fromLocalJSDate(new Date,this.getPrimaryCalendarType());return t.setDate(1),t.setMonth(0),t.setYear(e),this.setDate(t.toLocalJSDate()),this},v.prototype.setDate=function(e){var t,a,i,o;return e&&s._checkJSDateObject(e),a=e.getFullYear(),s._checkYearInValidRange(a),t=r.fromLocalJSDate(e,this.getPrimaryCalendarType()),t.setMonth(0),t.setDate(1),this.setProperty(\"date\",e,!0),this.setProperty(\"year\",t.getYear(),!0),this._oDate=t,this.getDomRef()&&(i=this.getYears(),o=new r(this._oDate,this.getPrimaryCalendarType()),o.setYear(o.getYear()-Math.floor(i/2)),_.call(this,o,Math.floor(i/2))),this},v.prototype._getDate=function(){if(!this._oDate){var e=this.getYear();this._oDate=new r(e,0,1,this.getPrimaryCalendarType())}return this._oDate},v.prototype.setPrimaryCalendarType=function(e){return this.setProperty(\"primaryCalendarType\",e),this._oYearFormat=h.getDateInstance({format:\"y\",calendarType:e}),this._oDate&&(this._oDate=new r(this._oDate,e),this._oDate.setMonth(0),this._oDate.setDate(1)),this._oMinDate=new r(this._oMinDate,e),this._oMaxDate=new r(this._oMaxDate,e),this},v.prototype.nextPage=function(){return f.call(this,!0,this._oItemNavigation.getFocusedIndex()),this},v.prototype.previousPage=function(){return f.call(this,!1,this._oItemNavigation.getFocusedIndex()),this},v.prototype.onsapspace=function(e){e.preventDefault()},v.prototype.onsapselect=function(e){var t=this._oItemNavigation.getFocusedIndex();u.call(this,t)&&this.fireSelect()},v.prototype.onmousedown=function(e){this._oMousedownPosition={clientX:e.clientX,clientY:e.clientY}},v.prototype.onmouseup=function(e){if(this._bMousedownChange)this._bMousedownChange=!1,this.fireSelect();else if(a.support.touch&&this._isValueInThreshold(this._oMousedownPosition.clientX,e.clientX,10)&&this._isValueInThreshold(this._oMousedownPosition.clientY,e.clientY,10)){var t=this._oItemNavigation.getFocusedIndex();u.call(this,t),this.fireSelect()}},v.prototype.getFirstRenderedDate=function(){var t;if(this.getDomRef()){var a=this._oItemNavigation.getItemDomRefs();t=this._oFormatYyyymmdd.parse(e(a[0]).attr(\"data-sap-year-start\"),!0)}return t},v.prototype._isValueInThreshold=function(e,t,a){var i=e-a,s=e+a;return t>=i&&t<=s},v.prototype._checkFirstDate=function(e){var t=this.getYears(),a=new r(this._oMaxDate,this.getPrimaryCalendarType());return a.setYear(a.getYear()-t+1),e.isAfter(a)&&e.getYear()!=a.getYear()?(e=new r(a,this.getPrimaryCalendarType()),e.setMonth(0),e.setDate(1)):e.isBefore(this._oMinDate)&&e.getYear()!=this._oMinDate.getYear()&&(e=new r(this._oMinDate,this.getPrimaryCalendarType()),e.setMonth(0),e.setDate(1)),e},v.prototype._checkDateEnabled=function(e){var t=!0;return(e.isAfter(this._oMaxDate)&&e.getYear()!=this._oMaxDate.getYear()||e.isBefore(this._oMinDate)&&e.getYear()!=this._oMinDate.getYear())&&(t=!1),t},v});",
	"sap/ui/unified/calendar/YearPickerRenderer.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"sap/ui/unified/calendar/CalendarDate\",\"sap/ui/core/date/UniversalDate\"],function(e,t){\"use strict\";var a={};return a.render=function(a,r){var i=r.getTooltip_AsString(),s=r.getId(),l=r._getDate(),d=l.getYear(),n=r.getYears(),o=r.getColumns(),w=\"\";a.write(\"<div\"),a.writeControlData(r),a.addClass(\"sapUiCalYearPicker\"),a.writeClasses(),i&&a.writeAttributeEscaped(\"title\",i),a.writeAccessibilityState(r,{role:\"grid\",readonly:\"true\",multiselectable:\"false\"}),a.write(\">\");var c=new e(l,r.getPrimaryCalendarType());c.setYear(c.getYear()-Math.floor(n/2));var u=!1,C=r._checkFirstDate(c);C.isSame(c)||(c=C,u=!0),w=o>0?100/o+\"%\":100/n+\"%\";for(var g=0;g<n;g++){var y=r._oFormatYyyymmdd.format(c.toUTCJSDate(),!0),m={role:\"gridcell\"},v=!0;u&&(v=r._checkDateEnabled(c)),o>0&&g%o==0&&(a.write(\"<div\"),a.writeAccessibilityState(null,{role:\"row\"}),a.write(\">\")),a.write(\"<div\"),a.writeAttribute(\"id\",s+\"-y\"+y),a.addClass(\"sapUiCalItem\"),c.getYear()==d?(a.addClass(\"sapUiCalItemSel\"),m.selected=!0):m.selected=!1,v||(a.addClass(\"sapUiCalItemDsbl\"),m.disabled=!0),a.writeAttribute(\"tabindex\",\"-1\"),a.writeAttribute(\"data-sap-year-start\",y),a.addStyle(\"width\",w),a.writeClasses(),a.writeStyles(),a.writeAccessibilityState(null,m),a.write(\">\"),a.write(r._oYearFormat.format(t.getInstance(c.toUTCJSDate(),c.getCalendarType()),!0)),a.write(\"</div>\"),c.setYear(c.getYear()+1),o>0&&(g+1)%o==0&&a.write(\"</div>\")}a.write(\"</div>\")},a},!0);",
	"sap/ui/unified/CalendarAppointment.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"./DateTypeRange\",\"sap/ui/core/format/DateFormat\",\"./library\"],function(e,t,a,r){\"use strict\";var n=t.extend(\"sap.ui.unified.CalendarAppointment\",{metadata:{library:\"sap.ui.unified\",properties:{title:{type:\"string\",group:\"Data\"},text:{type:\"string\",group:\"Data\"},icon:{type:\"sap.ui.core.URI\",group:\"Data\",defaultValue:null},tentative:{type:\"boolean\",group:\"Data\",defaultValue:!1},selected:{type:\"boolean\",group:\"Data\",defaultValue:!1},key:{type:\"string\",group:\"Data\",defaultValue:null},color:{type:\"sap.ui.core.CSSColor\",group:\"Appearance\",defaultValue:null}}}});return n.prototype.applyFocusInfo=function(e){var t=this.getParent();return t&&t.applyFocusInfo(e),this},n.prototype._getDateRangeIntersectionText=function(e){var t=this.getStartDate(),r=this.getEndDate()?this.getEndDate():new Date(864e12),n=new Date(e.getFullYear(),e.getMonth(),e.getDate(),0,0,0),o=new Date(n.getTime()+864e5),i=a.getTimeInstance({pattern:\"HH:mm\"}),p=sap.ui.getCore().getLibraryResourceBundle(\"sap.m\");return t.getTime()>o.getTime()||r.getTime()<n.getTime()?\"\":t.getTime()<n.getTime()&&r.getTime()>o.getTime()?p.getText(\"PLANNINGCALENDAR_ALLDAY\"):t.getTime()<n.getTime()?p.getText(\"PLANNINGCALENDAR_UNTIL\",[i.format(r)]):r.getTime()>o.getTime()?i.format(t):i.format(t)+\" - \"+i.format(r)},n._getComparer=function(e){var t=new Date(e.getFullYear(),e.getMonth(),e.getDate(),0,0,0).getTime(),a=t+864e5;return function(e,r){var n,o=e.appointment.getStartDate().getTime(),i=r.appointment.getStartDate().getTime(),p=e.appointment.getEndDate()?e.appointment.getEndDate().getTime():864e12,g=r.appointment.getEndDate()?r.appointment.getEndDate().getTime():864e12,u=o<=t&&p>=a,l=i<=t&&g>=a;return u&&l||!u&&!l?0===(n=o-i)&&(n=g-p):n=u?-1:1,n}},n.prototype.setColor=function(t){return t&&t.match(/^#[0-9a-f]{6}$/i)&&e.sap.log.warning(\"setColor accepts only full hex color value with pound symbol.\"),this.setProperty(\"color\",t)},n.prototype._getCSSColorForBackground=function(e){return\"rgba(\"+[parseInt(e.substr(1,2),16),parseInt(e.substr(3,2),16),parseInt(e.substr(5,2),16)].join(\",\")+\", 0.2)\"},n});",
	"sap/ui/unified/CalendarLegend.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/core/Control\",\"./library\",\"sap/ui/Device\",\"./CalendarLegendRenderer\"],function(e,t,n,r,a){\"use strict\";var i=n.CalendarDayType,d=n.StandardCalendarLegendItem,s=t.extend(\"sap.ui.unified.CalendarLegend\",{metadata:{library:\"sap.ui.unified\",properties:{standardItems:{type:\"string[]\",group:\"Misc\",defaultValue:[\"Today\",\"Selected\",\"WorkingDay\",\"NonWorkingDay\"]},columnWidth:{type:\"sap.ui.core.CSSSize\",group:\"Misc\",defaultValue:\"120px\"}},aggregations:{items:{type:\"sap.ui.unified.CalendarLegendItem\",multiple:!0,singularName:\"item\"},_standardItems:{type:\"sap.ui.unified.CalendarLegendItem\",multiple:!0,visibility:\"hidden\"}},designtime:\"sap/ui/unified/designtime/CalendarLegend.designtime\"},constructor:function(e,n){t.prototype.constructor.apply(this,arguments),\"string\"!=typeof e&&(n=e),(!n||n&&!n.standardItems)&&this._addStandardItems(this.getStandardItems())}});return s.prototype.onAfterRendering=function(){r.browser.msie&&r.browser.version<10&&e(\".sapUiUnifiedLegendItem\").css(\"width\",this.getColumnWidth()+4+\"px\").css(\"display\",\"inline-block\")},s.prototype.setStandardItems=function(e){var t;if(e&&1===e.length&&\"\"===e[0]&&(e=[]),e&&e.length)for(e=this.validateProperty(\"standardItems\",e),t=0;t<e.length;t++)if(!d[e[t]])throw new Error(\"Invalid value '\"+e[t]+\"'. Property standardItems must contain values from sap.ui.unified.StandardCalendarLegendItem.\");return this.setProperty(\"standardItems\",e),this._addStandardItems(this.getStandardItems(),!0),this},s.prototype._addStandardItems=function(e,t){var n,r=sap.ui.getCore().getLibraryResourceBundle(\"sap.ui.unified\"),a=this.getId();for(t&&this.destroyAggregation(\"_standardItems\"),n=0;n<e.length;n++){var i=new sap.ui.unified.CalendarLegendItem(a+\"-\"+e[n],{text:r.getText(s._Standard_Items_TextKeys[e[n]])});this.addAggregation(\"_standardItems\",i)}},s._Standard_Items_TextKeys={Today:\"LEGEND_TODAY\",Selected:\"LEGEND_SELECTED\",WorkingDay:\"LEGEND_NORMAL_DAY\",NonWorkingDay:\"LEGEND_NON_WORKING_DAY\"},s.prototype._getItemType=function(t,n){var r,a,d=t.getType();return d&&d!==i.None?d:(a=this._getUnusedItemTypes(n),(r=n.filter(function(e){return!e.getType()||e.getType()===i.None}).indexOf(t))<0?(e.sap.log.error(\"Legend item is not in the legend\",this),d):d=a[r]?a[r]:\"Type\"+(Object.keys(i).length+r-a.length-1))},s.prototype._getItemByType=function(e){var t,n,r=this.getItems();for(n=0;n<r.length;n++)if(this._getItemType(r[n],r)===e){t=r[n];break}return t},s.prototype._getUnusedItemTypes=function(t){var n,r,a=e.extend({},i);for(delete a[i.None],delete a[i.NonWorking],r=0;r<t.length;r++)n=t[r].getType(),a[n]&&delete a[n];return Object.keys(a)},s});",
	"sap/ui/unified/CalendarLegendItem.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"sap/ui/core/Element\",\"./library\"],function(e,a){\"use strict\";var r=a.CalendarDayType;return e.extend(\"sap.ui.unified.CalendarLegendItem\",{metadata:{library:\"sap.ui.unified\",properties:{text:{type:\"string\",group:\"Misc\",defaultValue:null},type:{type:\"sap.ui.unified.CalendarDayType\",group:\"Appearance\",defaultValue:r.None},color:{type:\"sap.ui.core.CSSColor\",group:\"Appearance\",defaultValue:null}}}})});",
	"sap/ui/unified/CalendarLegendRenderer.js": "/*\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"sap/ui/core/InvisibleText\"],function(e){\"use strict\";var t={};return t.render=function(e,t){var i,r,d,s=t.getAggregation(\"_standardItems\"),n=t.getItems();if(e.write(\"<div\"),e.writeControlData(t),e.addClass(\"sapUiUnifiedLegend\"),e.writeClasses(),e.write(\">\"),this.renderItemsHeader(e,t),s||n){if(e.write(\"<div\"),e.addClass(\"sapUiUnifiedLegendItems\"),e.writeClasses(),d=t.getColumnWidth(),e.writeAttribute(\"style\",\"column-width:\"+d+\";-moz-column-width:\"+d+\";-webkit-column-width:\"+d+\";\"),e.writeStyles(),e.write(\">\"),s)for(r=t.getId().length+1,i=0;i<s.length;++i){var a=\"sapUiUnifiedLegend\"+s[i].getId().slice(r);this.renderLegendItem(e,a,s[i],[\"sapUiUnifiedLegendSquareColor\"])}if(n)for(i=0;i<n.length;i++)this.renderLegendItem(e,\"sapUiCalLegDayType\"+t._getItemType(n[i],n).slice(4),n[i],[\"sapUiUnifiedLegendSquareColor\"]);e.write(\"</div>\")}this.renderAdditionalContent(e,t),e.write(\"</div>\")},t.renderLegendItem=function(e,t,i,r){var d=i.getText(),s=i.getTooltip_AsString();e.write(\"<div\"),e.writeElementData(i),s&&e.writeAttributeEscaped(\"title\",s),e.addClass(\"sapUiUnifiedLegendItem\"),e.addClass(t),e.writeClasses(),e.write(\">\"),e.write(\"<div\"),e.addClass(\"sapUiUnifiedLegendSquare\"),e.writeClasses(),e.write(\">\"),this.renderColor(e,i.getColor(),r),e.write(\"</div>\"),e.write(\"<div\"),e.writeAttribute(\"id\",i.getId()+\"-Text\"),e.addClass(\"sapUiUnifiedLegendDescription\"),e.writeClasses(),e.write(\">\"),e.writeEscaped(d),e.write(\"</div></div>\")},t.renderItemsHeader=function(e,t){},t.renderAdditionalContent=function(e,t){},t.renderColor=function(e,t,i){e.write(\"<div\");for(var r=0;r<i.length;r++)e.addClass(i[r]);t&&(e.addStyle(\"background-color\",t),e.writeStyles()),e.writeClasses(),e.write(\"></div>\")},t.addCalendarTypeAccInfo=function(e,i,r){var d,s;if(r){var n=r._getItemByType(i);n&&(d=n.getText())}d?e.label=e.label?e.label+\"; \"+d:d:(s=t.getTypeAriaText(i))&&(e.describedby=e.describedby?e.describedby+\" \"+s.getId():s.getId())},t.typeARIATexts={},t.getTypeAriaText=function(i){var r,d;if(0===i.indexOf(\"Type\"))return t.typeARIATexts[i]||(r=sap.ui.getCore().getLibraryResourceBundle(\"sap.ui.unified\"),d=r.getText(\"LEGEND_UNNAMED_TYPE\",parseInt(i.slice(4),10).toString()),t.typeARIATexts[i]=new e({text:d}),t.typeARIATexts[i].toStatic()),t.typeARIATexts[i]},t},!0);",
	"sap/ui/unified/CalendarMonthInterval.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/Device\",\"sap/ui/core/Control\",\"sap/ui/core/Locale\",\"sap/ui/core/LocaleData\",\"sap/ui/core/Renderer\",\"sap/ui/core/format/DateFormat\",\"./calendar/CalendarUtils\",\"./calendar/Header\",\"./calendar/MonthsRow\",\"./calendar/YearPicker\",\"./calendar/CalendarDate\",\"./Calendar\",\"./CalendarRenderer\",\"./CalendarMonthIntervalRenderer\"],function(t,e,a,i,o,s,n,r,h,g,c,l,u,p,d){\"use strict\";function D(t,e,a){var i=new l(this._oMaxDate);i.setDate(1),i.setMonth(i.getMonth()-this._getMonths()+1),i.isBefore(this._oMinDate)&&(i=new l(this._oMinDate),i.setMonth(i.getMonth()+this._getMonths()-1)),t.isBefore(this._oMinDate)?t=new l(this._oMinDate):t.isAfter(i)&&(t=i),t.setDate(1);var o=t.toLocalJSDate();this.setProperty(\"startDate\",o,!0),this._oStartDate=t;var s=this.getAggregation(\"monthsRow\");if(s.setStartDate(o),y.call(this),e){var n=this._getFocusedDate().toLocalJSDate();s.checkDateFocusable(n)?s.setDate(n):(this._setFocusedDate(t),s.setDate(o))}a||this.fireStartDateChange()}function _(){return this._oStartDate||(this._oStartDate=this._getFocusedDate(),this._oStartDate.setDate(1)),this._oStartDate}function f(t){var e=this._getFocusedDate(),a=this.getAggregation(\"monthsRow\");t?a.displayDate(e.toLocalJSDate()):a.setDate(e.toLocalJSDate()),y.call(this)}function m(){var t=this.getSelectedDates();t&&t[0]&&t[0].getStartDate()?this._oFocusedDate=l.fromLocalJSDate(t[0].getStartDate()):this._oFocusedDate=new l,this._oFocusedDate.setDate(1),this._oFocusedDate.isBefore(this._oMinDate)?this._oFocusedDate=new l(this._oMinDate):this._oFocusedDate.isAfter(this._oMaxDate)&&(this._oFocusedDate=new l(this._oMaxDate))}function v(){var e=this._getFocusedDate(),a=this.getAggregation(\"yearPicker\");if(a.getDomRef())a.$().css(\"display\",\"\");else{var i=sap.ui.getCore().createRenderManager(),o=this.$(\"content\");i.renderControl(a),i.flush(o[0],!1,!0),i.destroy()}if(this._showOverlay(),a.setDate(e.toLocalJSDate()),0==this._iMode){var s=this.getAggregation(\"monthsRow\");t(s._oItemNavigation.getItemDomRefs()[s._oItemNavigation.getFocusedIndex()]).attr(\"tabindex\",\"-1\")}x.call(this),this._iMode=1}function M(e){if(this._iMode=0,this.getAggregation(\"yearPicker\").$().css(\"display\",\"none\"),this._hideOverlay(),!e){f.call(this);var a=this.getAggregation(\"monthsRow\");t(a._oItemNavigation.getItemDomRefs()[a._oItemNavigation.getFocusedIndex()]).attr(\"tabindex\",\"0\")}}function y(){I.call(this),P.call(this)}function P(){var t=new l(_.call(this)),e=this._getMonths(),a=t.getYear(),i=this._oMaxDate.getYear(),o=this._oMinDate.getYear(),s=t.getMonth(),n=this._oMaxDate.getMonth(),r=this._oMinDate.getMonth(),h=this.getAggregation(\"header\");a<o||a==o&&s<=r?h.setEnabledPrevious(!1):h.setEnabledPrevious(!0),t.setMonth(t.getMonth()+e-1),a=t.getYear(),s=t.getMonth(),a>i||a==i&&s>=n?h.setEnabledNext(!1):h.setEnabledNext(!0)}function x(){var t=this.getAggregation(\"yearPicker\"),e=t.getYears(),a=l.fromLocalJSDate(t.getFirstRenderedDate());a.setYear(a.getYear()+Math.floor(e/2));var i=this.getAggregation(\"header\"),o=new l(this._oMaxDate);o.setYear(o.getYear()-Math.ceil(e/2)),o.setMonth(11,31);var s=new l(this._oMinDate);s.setYear(s.getYear()+Math.floor(e/2)+1),s.setMonth(0,1),i.setEnabledNext(!a.isAfter(o)),i.setEnabledPrevious(!a.isBefore(s))}function I(){var t,e=_.call(this),a=this._oYearFormat.format(e.toUTCJSDate(),!0),i=new l(e);i.setMonth(i.getMonth()+this._getMonths()-1);var o=this._oYearFormat.format(i.toUTCJSDate(),!0);if(a!=o){t=this._getLocaleData().getIntervalPattern().replace(/\\{0\\}/,a).replace(/\\{1\\}/,o)}else t=a;this.getAggregation(\"header\").setTextButton2(t)}function S(t,e){var a,i=!1;t.isBefore(this._oMinDate)?(a=this._oMinDate,i=!0):t.isAfter(this._oMaxDate)?(a=this._oMaxDate,i=!0):a=t,this._setFocusedDate(a),(i||e)&&(Y.call(this,a),f.call(this,!1),this.fireStartDateChange())}function k(t,e){if(t){var a=l.fromLocalJSDate(t);if(!this._oFocusedDate||!this._oFocusedDate.isSame(a)){var i=a.getYear();if(r._checkYearInValidRange(i),r._isOutside(a,this._oMinDate,this._oMaxDate))throw new Error(\"Date must not be in valid range (minDate and maxDate); \"+this);this._setFocusedDate(a),this.getDomRef()&&0==this._iMode&&f.call(this,e)}}}function A(t){this.getPickerPopup()?this._showCalendarPicker():1!=this._iMode?v.call(this):M.call(this)}function w(e){if(this._oPopup&&this._oPopup.isOpen()&&this._oPopup.close(),this._hideOverlay(),!e){f.call(this);var a=this.getAggregation(\"monthsRow\");t(a._oItemNavigation.getItemDomRefs()[a._oItemNavigation.getFocusedIndex()]).attr(\"tabindex\",\"0\")}}function b(t){this.fireSelect()}function C(t){var e=l.fromLocalJSDate(t.getParameter(\"date\")),a=t.getParameter(\"notVisible\");S.call(this,e,a)}function R(t){var e=new l(this._getFocusedDate()),a=this._getCalendarPicker(),i=a.getSelectedDates()[0].getStartDate(),o=l.fromLocalJSDate(i);o.setMonth(e.getMonth()),o.setDate(e.getDate()),S.call(this,o,!0),w.call(this)}function F(t){var e=new l(this._getFocusedDate()),a=this.getAggregation(\"yearPicker\"),i=l.fromLocalJSDate(a.getDate());i.setMonth(e.getMonth()),i.setDate(e.getDate()),e=i,S.call(this,e,!0),M.call(this)}function L(){this._sInvalidateContent=void 0;var t=this.getAggregation(\"monthsRow\");t._bDateRangeChanged=!0,t._bInvalidateSync=!0,t.invalidate(),t._bInvalidateSync=void 0,this._bDateRangeChanged=void 0}function Y(t){var e=this.getAggregation(\"monthsRow\"),a=_.call(this),i=e._oItemNavigation.getFocusedIndex();a=new l(t),a.setMonth(a.getMonth()-i),D.call(this,a,!1,!0)}function N(e){this._oPopup||(t.sap.require(\"sap.ui.core.Popup\"),this._oPopup=new sap.ui.core.Popup,this._oPopup.setAutoClose(!0),this._oPopup.setAutoCloseAreas([this.getDomRef()]),this._oPopup.setDurations(0,0),this._oPopup._oCalendar=this,this._oPopup.attachClosed(J,this),this._oPopup.onsapescape=function(t){this._oCalendar.onsapescape(t)}),this._oPopup.setContent(e);var a=this.getAggregation(\"header\"),i=sap.ui.core.Popup.Dock;this._oPopup.open(0,i.CenterTop,i.CenterTop,a,null,\"flipfit\",!0)}function J(t){w.call(this)}function B(t){x.call(this)}var E=a.extend(\"sap.ui.unified.CalendarMonthInterval\",{metadata:{library:\"sap.ui.unified\",properties:{width:{type:\"sap.ui.core.CSSSize\",group:\"Dimension\",defaultValue:null},startDate:{type:\"object\",group:\"Data\"},intervalSelection:{type:\"boolean\",group:\"Behavior\",defaultValue:!1},singleSelection:{type:\"boolean\",group:\"Behavior\",defaultValue:!0},months:{type:\"int\",group:\"Appearance\",defaultValue:12},pickerPopup:{type:\"boolean\",group:\"Appearance\",defaultValue:!1},minDate:{type:\"object\",group:\"Misc\",defaultValue:null},maxDate:{type:\"object\",group:\"Misc\",defaultValue:null}},aggregations:{selectedDates:{type:\"sap.ui.unified.DateRange\",multiple:!0,singularName:\"selectedDate\"},specialDates:{type:\"sap.ui.unified.DateTypeRange\",multiple:!0,singularName:\"specialDate\"},header:{type:\"sap.ui.unified.calendar.Header\",multiple:!1,visibility:\"hidden\"},monthsRow:{type:\"sap.ui.unified.calendar.MonthsRow\",multiple:!1,visibility:\"hidden\"},yearPicker:{type:\"sap.ui.unified.calendar.YearPicker\",multiple:!1,visibility:\"hidden\"},calendarPicker:{type:\"sap.ui.unified.Calendar\",multiple:!1,visibility:\"hidden\"}},associations:{ariaLabelledBy:{type:\"sap.ui.core.Control\",multiple:!0,singularName:\"ariaLabelledBy\"},legend:{type:\"sap.ui.unified.CalendarLegend\",multiple:!1}},events:{select:{},cancel:{},startDateChange:{}}}});E.prototype.init=function(){this._iMode=0,this.data(\"sap-ui-fastnavgroup\",\"true\",!0),this._oYearFormat=n.getDateInstance({format:\"y\"}),this._oMinDate=r._minDate(),this._oMaxDate=r._maxDate(),this._initializeHeader(),this._initializeMonthsRow(),this._initilizeYearPicker(),this._iDaysMonthsHead=15},E.prototype.exit=function(){this._sInvalidateContent&&t.sap.clearDelayedCall(this._sInvalidateContent)},E.prototype.onBeforeRendering=function(){var t=this.getAggregation(\"monthsRow\"),e=this._getFocusedDate();y.call(this),t.displayDate(e.toLocalJSDate())},E.prototype._initializeHeader=function(){var t=new h(this.getId()+\"--Head\",{visibleButton0:!1,visibleButton1:!1,visibleButton2:!0});t.attachEvent(\"pressPrevious\",this._handlePrevious,this),t.attachEvent(\"pressNext\",this._handleNext,this),t.attachEvent(\"pressButton2\",A,this),this.setAggregation(\"header\",t)},E.prototype._initializeMonthsRow=function(){var t=new g(this.getId()+\"--MonthsRow\");t.attachEvent(\"focus\",C,this),t.attachEvent(\"select\",b,this),t._bNoThemeChange=!0,this.setAggregation(\"monthsRow\",t)},E.prototype._initilizeYearPicker=function(){this.setAggregation(\"yearPicker\",this._createYearPicker())},E.prototype._createYearPicker=function(){var t=new c(this.getId()+\"--YP\",{columns:0,years:6});return t.attachEvent(\"select\",F,this),t.attachEvent(\"pageChange\",B,this),t._oMinDate.setYear(this._oMinDate.getYear()),t._oMaxDate.setYear(this._oMaxDate.getYear()),t},E.prototype._getCalendarPicker=function(){var t=this.getAggregation(\"calendarPicker\");return t||(t=new O(this.getId()+\"--Cal\"),t.setPopupMode(!0),t.attachEvent(\"select\",R,this),t.attachEvent(\"cancel\",function(t){this._oPopup.close()},this),this.setAggregation(\"calendarPicker\",t)),t},E.prototype.setStartDate=function(e){if(r._checkJSDateObject(e),t.sap.equal(this.getStartDate(),e))return this;var a=e.getFullYear();r._checkYearInValidRange(a),this.setProperty(\"startDate\",e,!0),this._oStartDate=l.fromLocalJSDate(e),this._oStartDate.setDate(1);var i=this.getAggregation(\"monthsRow\");i.setStartDate(e),y.call(this);var o=this._getFocusedDate().toLocalJSDate();return i.checkDateFocusable(o)||(this._setFocusedDate(this._oStartDate),i.displayDate(e)),this},E.prototype.invalidate=function(e){this._bDateRangeChanged||e&&e instanceof sap.ui.unified.DateRange?this.getDomRef()&&0==this._iMode&&!this._sInvalidateContent&&(this._sInvalidateContent=t.sap.delayedCall(0,this,L)):a.prototype.invalidate.apply(this,arguments)},E.prototype.removeAllSelectedDates=function(){return this._bDateRangeChanged=!0,this.removeAllAggregation(\"selectedDates\")},E.prototype.destroySelectedDates=function(){return this._bDateRangeChanged=!0,this.destroyAggregation(\"selectedDates\")},E.prototype.removeAllSpecialDates=function(){return this._bDateRangeChanged=!0,this.removeAllAggregation(\"specialDates\")},E.prototype.destroySpecialDates=function(){return this._bDateRangeChanged=!0,this.destroyAggregation(\"specialDates\")},E.prototype.setLocale=function(t){return this._sLocale!=t&&(this._sLocale=t,this._oLocaleData=void 0,this.invalidate()),this},E.prototype.getLocale=function(){return this._sLocale||(this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString()),this._sLocale},E.prototype._getFocusedDate=function(){return this._oFocusedDate||m.call(this),this._oFocusedDate},E.prototype._setFocusedDate=function(t){r._checkCalendarDate(t),this._oFocusedDate=new l(t)},E.prototype.focusDate=function(t){var e=!1,a=this.getAggregation(\"monthsRow\");return t&&!a.checkDateFocusable(t)&&(Y.call(this,l.fromLocalJSDate(t)),e=!0),k.call(this,t,!1),e&&this.fireStartDateChange(),this},E.prototype.displayDate=function(t){return k.call(this,t,!0),this},E.prototype.setMonths=function(t){this.setProperty(\"months\",t,!0),t=this._getMonths();var e=this.getAggregation(\"monthsRow\");if(e.setMonths(t),!e.checkDateFocusable(this._getFocusedDate().toLocalJSDate())){var a=_.call(this);this._setFocusedDate(this._oStartDate),e.setDate(a.toLocalJSDate())}if(!this.getPickerPopup()){var i=this.getAggregation(\"yearPicker\"),o=Math.floor(t/2);o>20&&(o=20),i.setYears(o)}return y.call(this),this.getDomRef()&&(this._getShowItemHeader()?this.$().addClass(\"sapUiCalIntHead\"):this.$().removeClass(\"sapUiCalIntHead\")),this},E.prototype._getMonths=function(){var t=this.getMonths();return e.system.phone&&t>6?6:t},E.prototype._getLocaleData=function(){if(!this._oLocaleData){var t=this.getLocale(),e=new i(t);this._oLocaleData=o.getInstance(e)}return this._oLocaleData},E.prototype.setPickerPopup=function(t){var e;return this.setProperty(\"pickerPopup\",t,!0),t?this.getAggregation(\"yearPicker\")&&this.getAggregation(\"yearPicker\").destroy():(this.getAggregation(\"yearPicker\")||this.setAggregation(\"yearPicker\",this._createYearPicker()),e=this.getAggregation(\"yearPicker\"),e.setColumns(0),e.setYears(6)),this},E.prototype.setMinDate=function(e){if(t.sap.equal(e,this.getMinDate()))return this;if(e){r._checkJSDateObject(e),this._oMinDate=l.fromLocalJSDate(e),this._oMinDate.setDate(1);var a=this._oMinDate.getYear();r._checkYearInValidRange(a),this._oMaxDate.isBefore(this._oMinDate)&&(t.sap.log.warning(\"minDate > maxDate -> maxDate set to end of the month\",this),this._oMaxDate=l.fromLocalJSDate(e),this._oMaxDate.setDate(r._daysInMonth(this._oMaxDate)),this.setProperty(\"maxDate\",this._oMaxDate.toLocalJSDate(),!0)),this._oFocusedDate&&this._oFocusedDate.isBefore(this._oMinDate)&&(t.sap.log.warning(\"focused date < minDate -> minDate focused\",this),this.focusDate(e)),this._oStartDate&&this._oStartDate.isBefore(this._oMinDate)&&(t.sap.log.warning(\"start date < minDate -> minDate set as start date\",this),D.call(this,new l(this._oMinDate),!0,!0))}else this._oMinDate=r._minDate();if(this.setProperty(\"minDate\",e,!1),this.getPickerPopup()){this._getCalendarPicker().setMinDate(e)}else{this.getAggregation(\"yearPicker\")._oMinDate.setYear(this._oMinDate.getYear())}return this},E.prototype.setMaxDate=function(e){if(t.sap.equal(e,this.getMaxDate()))return this;if(e){r._checkJSDateObject(e),this._oMaxDate=l.fromLocalJSDate(e),this._oMaxDate.setDate(r._daysInMonth(this._oMaxDate));var a=this._oMaxDate.getYear();if(r._checkYearInValidRange(a),this._oMinDate.isAfter(this._oMaxDate)&&(t.sap.log.warning(\"maxDate < minDate -> minDate set to begin of the month\",this),this._oMinDate=l.fromLocalJSDate(e),this._oMinDate.setDate(1),this.setProperty(\"minDate\",this._oMinDate.toLocalJSDate(),!0)),this._oFocusedDate&&this._oFocusedDate.isAfter(this._oMaxDate)&&(t.sap.log.warning(\"focused date > maxDate -> maxDate focused\",this),this.focusDate(e)),this._oStartDate){var i=new l(this._oStartDate);if(i.setDate(1),i.setMonth(i.getMonth()+this._getMonths()),i.setDate(0),i.isAfter(this._oMaxDate)){var o=new l(this._oMaxDate);o.setDate(1),o.setMonth(o.getMonth()-this._getMonths()+1),o.isSameOrAfter(this._oMinDate)&&(t.sap.log.warning(\"end date > maxDate -> maxDate set as end date\",this),D.call(this,o,!0,!0))}}}else this._oMaxDate=r._maxDate();if(this.setProperty(\"maxDate\",e,!1),this.getPickerPopup()){this._getCalendarPicker().setMaxDate(e)}else{this.getAggregation(\"yearPicker\")._oMaxDate.setYear(this._oMaxDate.getYear())}return this},E.prototype.onclick=function(t){t.isMarked(\"delayedMouseEvent\")||t.target.id==this.getId()+\"-cancel\"&&this.onsapescape(t)},E.prototype.onmousedown=function(t){t.preventDefault(),t.setMark(\"cancelAutoClose\")},E.prototype.onsapescape=function(t){if(this.getPickerPopup())w.call(this),this.fireCancel();else switch(this._iMode){case 0:this.fireCancel();break;case 1:M.call(this)}},E.prototype.onsaptabnext=function(e){var a,i,o=this.getAggregation(\"header\");t.sap.containsOrEquals(this.getDomRef(\"content\"),e.target)&&(t.sap.focus(o.getDomRef(\"B2\")),this._bPoupupMode||(i=this.getAggregation(\"monthsRow\"),t(i._oItemNavigation.getItemDomRefs()[i._oItemNavigation.getFocusedIndex()]).attr(\"tabindex\",\"-1\"),this.getPickerPopup()||(a=this.getAggregation(\"yearPicker\"),a.getDomRef()&&t(a._oItemNavigation.getItemDomRefs()[a._oItemNavigation.getFocusedIndex()]).attr(\"tabindex\",\"-1\"))),e.preventDefault())},E.prototype.onsaptabprevious=function(e){var a,i,o=this.getAggregation(\"header\");if(t.sap.containsOrEquals(this.getDomRef(\"content\"),e.target))this._bPoupupMode&&(t.sap.focus(o.getDomRef(\"B2\")),e.preventDefault());else if(e.target.id==o.getId()+\"-B2\"){switch(this._iMode){case 0:a=this.getAggregation(\"monthsRow\"),a._oItemNavigation.focusItem(a._oItemNavigation.getFocusedIndex());break;case 1:this.getPickerPopup()||(i=this.getAggregation(\"yearPicker\"),i._oItemNavigation.focusItem(i._oItemNavigation.getFocusedIndex()))}e.preventDefault()}},E.prototype.onfocusin=function(e){if(e.target.id==this.getId()+\"-end\"){var a,i,o=this.getAggregation(\"header\");t.sap.focus(o.getDomRef(\"B2\")),this._bPoupupMode||(a=this.getAggregation(\"monthsRow\"),t(a._oItemNavigation.getItemDomRefs()[a._oItemNavigation.getFocusedIndex()]).attr(\"tabindex\",\"-1\"),this.getPickerPopup()||(i=this.getAggregation(\"yearPicker\"),i.getDomRef()&&t(i._oItemNavigation.getItemDomRefs()[i._oItemNavigation.getFocusedIndex()]).attr(\"tabindex\",\"-1\")))}this.$(\"end\").attr(\"tabindex\",\"-1\")},E.prototype.onsapfocusleave=function(e){var a,i;if(!(e.relatedControlId&&t.sap.containsOrEquals(this.getDomRef(),sap.ui.getCore().byId(e.relatedControlId).getFocusDomRef())||(this.$(\"end\").attr(\"tabindex\",\"0\"),this._bPoupupMode)))switch(this._iMode){case 0:a=this.getAggregation(\"monthsRow\"),t(a._oItemNavigation.getItemDomRefs()[a._oItemNavigation.getFocusedIndex()]).attr(\"tabindex\",\"0\");break;case 1:this.getPickerPopup()||(i=this.getAggregation(\"yearPicker\"),t(i._oItemNavigation.getItemDomRefs()[i._oItemNavigation.getFocusedIndex()]).attr(\"tabindex\",\"0\"))}},E.prototype._handlePrevious=function(t){var e,a,i,o;switch(this._iMode){case 0:e=this._getFocusedDate(),a=this._getMonths(),i=new l(_.call(this)),i.setMonth(i.getMonth()-a),e.setMonth(e.getMonth()-a),this._setFocusedDate(e),D.call(this,i,!0);break;case 1:this.getPickerPopup()||(o=this.getAggregation(\"yearPicker\"),o.previousPage(),x.call(this))}},E.prototype._handleNext=function(t){var e,a,i,o;switch(this._iMode){case 0:e=this._getFocusedDate(),a=this._getMonths(),i=new l(_.call(this)),i.setMonth(i.getMonth()+a),e.setMonth(e.getMonth()+a),this._setFocusedDate(e),D.call(this,i,!0);break;case 1:this.getPickerPopup()||(o=this.getAggregation(\"yearPicker\"),o.nextPage(),x.call(this))}},E.prototype._showOverlay=function(){this.$(\"contentOver\").css(\"display\",\"\")},E.prototype._hideOverlay=function(){this.$(\"contentOver\").css(\"display\",\"none\")},E.prototype._getShowItemHeader=function(){return this.getMonths()>this._iDaysMonthsHead},E.prototype._showCalendarPicker=function(){var t=this._getFocusedDate(!0).toLocalJSDate(),e=this._getCalendarPicker(),a=new sap.ui.unified.DateRange({startDate:t});e.displayDate(t,!1),e.removeAllSelectedDates(),e.addSelectedDate(a),e.setMinDate(this.getMinDate()),e.setMaxDate(this.getMaxDate()),N.call(this,e),this._showOverlay()};var O=u.extend(\"CustomYearPicker\",{renderer:s.extend(p)});return O.prototype._initializeHeader=function(){var t=new h(this.getId()+\"--Head\",{visibleButton1:!1});t.attachEvent(\"pressPrevious\",this._handlePrevious,this),t.attachEvent(\"pressNext\",this._handleNext,this),t.attachEvent(\"pressButton2\",this._handleButton2,this),this.setAggregation(\"header\",t)},O.prototype.onAfterRendering=function(){u.prototype.onAfterRendering.apply(this,arguments),this.getAggregation(\"header\").$(\"B2\").css(\"background-color\",\"inherit\").css(\"color\",\"inherit\").css(\"cursor\",\"inherit\").css(\"pointer-events\",\"none\"),this._showYearPicker()},O.prototype.onThemeChanged=function(){u.prototype.onThemeChanged.apply(this,arguments),this.getAggregation(\"header\").$(\"B2\").css(\"background-color\",\"inherit\").css(\"color\",\"inherit\").css(\"cursor\",\"inherit\").css(\"pointer-events\",\"none\")},O.prototype._selectYear=function(){var t=this.getAggregation(\"yearPicker\"),e=this.getSelectedDates()[0];e||(e=new sap.ui.unified.DateRange),e.setStartDate(t.getDate()),this.addSelectedDate(e),this.fireSelect()},O.prototype.onsapescape=function(t){this.fireCancel()},O.prototype._shouldFocusB2OnTabPrevious=function(t){return!1},E});",
	"sap/ui/unified/CalendarMonthIntervalRenderer.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([],function(){\"use strict\";var t={};return t.render=function(t,e){e._iMode=0;var i=e.getId(),a=e.getTooltip_AsString(),r=e.getAggregation(\"monthsRow\");t.write(\"<div\"),t.writeControlData(e),t.addClass(\"sapUiCal\"),t.addClass(\"sapUiCalInt\"),t.addClass(\"sapUiCalMonthInt\"),e._getShowItemHeader()&&t.addClass(\"sapUiCalIntHead\"),t.writeAttribute(\"tabindex\",\"-1\");var d=sap.ui.getCore().getLibraryResourceBundle(\"sap.ui.unified\"),n={labelledby:{value:\"\",append:!1}};e._bPoupupMode&&(n.role=\"dialog\"),t.writeAccessibilityState(e,n),a&&t.writeAttributeEscaped(\"title\",a);var s=e.getWidth();s&&\"\"!=s&&(t.addStyle(\"width\",s),t.writeStyles()),t.writeClasses(),t.write(\">\");var l=e.getAggregation(\"header\");t.renderControl(l),t.write('<div id=\"'+i+'-content\" class=\"sapUiCalContent\">'),t.renderControl(r),t.write(\"</div>\"),t.write('<button id=\"'+i+'-cancel\" class=\"sapUiCalCancel\" tabindex=\"-1\">'),t.write(d.getText(\"CALENDAR_CANCEL\")),t.write(\"</button>\"),t.write('<div id=\"'+i+'-end\" tabindex=\"0\" style=\"width:0;height:0;position:absolute;right:0;bottom:0;\"></div>'),e.getPickerPopup()&&t.write('<div id=\"'+i+'-contentOver\" class=\"sapUiCalContentOver\" style=\"display:none;\"></div>'),t.write(\"</div>\")},t},!0);",
	"sap/ui/unified/CalendarOneMonthInterval.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/unified/calendar/CalendarUtils\",\"sap/ui/unified/calendar/CalendarDate\",\"./library\",\"sap/ui/unified/CalendarDateInterval\",\"sap/ui/unified/CalendarDateIntervalRenderer\",\"sap/ui/unified/calendar/OneMonthDatesRow\",\"sap/ui/core/Renderer\",\"sap/ui/unified/Calendar\",\"sap/ui/unified/CalendarRenderer\",\"./CalendarOneMonthIntervalRenderer\"],function(t,e,a,n,o,i,s,r,h,c,u){\"use strict\";var d=o.extend(\"sap.ui.unified.CalendarOneMonthInterval\",{});d.prototype.init=function(){o.prototype.init.apply(this,arguments),this._bShowOneMonth=!0},d.prototype._getCalendarPicker=function(){var t=this.getAggregation(\"calendarPicker\");return t||(t=new g(this.getId()+\"--Cal\"),t.setPopupMode(!0),t.attachEvent(\"select\",function(){var t=this._getCalendarPicker(),a=t._getFocusedDate(),n=e._getFirstDateOfMonth(a);this._setStartDate(n),this._adjustSelectedDate(n,!1),this._oFocusDateOneMonth=n,this._closeCalendarPicker(!0),this._focusDate(a,!1,!0)},this),t.attachEvent(\"cancel\",function(t){var e=this._getCalendarPicker(),a=e._getFocusedDate();this._closeCalendarPicker(!0),this._oFocusDateOneMonth=a,this._focusDate(a,!0)},this),this.setAggregation(\"calendarPicker\",t)),t},d.prototype._createMonth=function(t){return new s(t)},d.prototype._handleFocus=function(t){var n,i,s,r=!!t.getParameter(\"_outsideBorder\"),h=t.getParameter(\"date\"),c=a.fromLocalJSDate(h),u=a.fromLocalJSDate(this.getStartDate()),d=!e._isSameMonthAndYear(c,u);return(r||d)&&(e._isLastDateInMonth(c)?this._oFocusDateOneMonth=c:this._oFocusDateOneMonth=e._getFirstDateOfMonth(c),n=c.isBefore(u)?-1:1,i=new a(this._getFocusedDate(),this.getPrimaryCalendarType()),s=new a(this._getStartDate(),this.getPrimaryCalendarType()),o.prototype._shiftStartFocusDates.call(this,i,s,n)),o.prototype._handleFocus.apply(this,arguments)},d.prototype._focusDateExtend=function(t,e,a){var n,i;return this._oFocusDateOneMonth?(n=this.getAggregation(\"month\")[0],i=this._oFocusDateOneMonth.toLocalJSDate(),this._setFocusedDate(this._oFocusDateOneMonth),n._bNoRangeCheck=!0,n.setDate(i),n._bNoRangeCheck=!1,this._oFocusDateOneMonth=null,!a):o.prototype._focusDateExtend.apply(this,arguments)},d.prototype._setDisplayMode=function(t){this.getAggregation(\"month\")[0].setMode(t)},d.prototype._shiftStartFocusDates=function(t,e,a){var n=a,o=this.getAggregation(\"month\")[0];0!==n&&(n=n>0?1:-1),t.setMonth(t.getMonth()+n),e.setYear(t.getYear()),e.setMonth(t.getMonth()),e.setDate(t.getDate()),this._setFocusedDate(e),this._setStartDate(t,!0),o.selectDate(t.toLocalJSDate())},d.prototype._adjustSelectedDate=function(t,a){var n,o=this.getAggregation(\"month\")[0];n=a?e._getFirstDateOfMonth(t):t,o.getMode&&o.getMode()<2&&this._selectDate(n)},d.prototype._selectDate=function(t){var e=this.getAggregation(\"month\")[0],a=t.toLocalJSDate();this.removeAllSelectedDates(),this.addSelectedDate(new sap.ui.unified.DateRange({startDate:a})),e.selectDate(a),this._bDateRangeChanged=void 0},d.prototype._dateMatchesVisibleRange=function(t){return e._isSameMonthAndYear(a.fromLocalJSDate(this.getStartDate()),a.fromLocalJSDate(t))};var g=h.extend(\"CustomMonthPicker\",{renderer:r.extend(c)});return g.prototype._initializeHeader=function(){var t=new sap.ui.unified.calendar.Header(this.getId()+\"--Head\",{visibleButton1:!1});t.attachEvent(\"pressPrevious\",this._handlePrevious,this),t.attachEvent(\"pressNext\",this._handleNext,this),t.attachEvent(\"pressButton2\",this._handleButton2,this),this.setAggregation(\"header\",t)},g.prototype._shouldFocusB2OnTabNext=function(e){return t.sap.containsOrEquals(this.getDomRef(\"content\"),e.target)},g.prototype.onAfterRendering=function(){this._showMonthPicker()},g.prototype._selectYear=function(){var t=this.getAggregation(\"yearPicker\"),e=this._getFocusedDate();e.setYear(t.getYear()),this._focusDate(e,!0),this._showMonthPicker()},g.prototype._selectMonth=function(){var t=this.getAggregation(\"monthPicker\"),e=this.getSelectedDates()[0],a=this._getFocusedDate();a.setMonth(t.getMonth()),e||(e=new sap.ui.unified.DateRange),e.setStartDate(a.toLocalJSDate()),this.addSelectedDate(e),this.fireSelect()},g.prototype.onsapescape=function(t){this.fireCancel()},d});",
	"sap/ui/unified/CalendarOneMonthIntervalRenderer.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"sap/ui/core/Renderer\",\"./CalendarDateIntervalRenderer\"],function(e,t){\"use strict\";var a=e.extend(t);return a.addAttributes=function(e,a){t.addAttributes.apply(this,arguments),e.addClass(\"sapUiCalOneMonthInt\")},a},!0);",
	"sap/ui/unified/CalendarRenderer.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([],function(){\"use strict\";var t={};return t.render=function(t,e){e._iMode=0;var i=e.getId(),r=e.getTooltip_AsString(),a=e.getAggregation(\"month\"),n=e.getWidth();t.write(\"<div\"),t.writeControlData(e),t.addClass(\"sapUiCal\"),a.length>1&&t.addClass(\"sapUiCalMulti\"),t.writeAttribute(\"tabindex\",\"-1\");var d=sap.ui.getCore().getLibraryResourceBundle(\"sap.ui.unified\"),s={labelledby:{value:\"\",append:!1}};e._bPoupupMode&&(s.role=\"dialog\"),t.writeAccessibilityState(e,s),r&&t.writeAttributeEscaped(\"title\",r),n&&(t.addClass(\"sapUiCalWidth\"),t.addStyle(\"width\",n),t.writeStyles()),e._getSecondaryCalendarType()&&t.addClass(\"sapUiCalSecType\"),this.addAttributes&&this.addAttributes(t,e),t.writeClasses(),t.write(\">\");var l=e.getAggregation(\"header\");t.renderControl(l),t.write('<div id=\"'+i+'-content\" class=\"sapUiCalContent'),this.writeAdditionalStyleClasses(t,e),t.write('\">');for(var o=0;o<a.length;o++){var C=a[o];t.renderControl(C),o<a.length-1&&t.write('<hr class=\"sasUiCalDivider\">')}if(this.writeAdditionalControls(t,e),this.renderCalContentOverlay(t,e,i),!e._bNamesLengthChecked){var g=e.getAggregation(\"monthPicker\");t.renderControl(g)}t.write(\"</div>\"),t.write('<button id=\"'+i+'-cancel\" class=\"sapUiCalCancel\" tabindex=\"-1\">'),t.write(d.getText(\"CALENDAR_CANCEL\")),t.write(\"</button>\"),t.write('<div id=\"'+i+'-end\" tabindex=\"0\" style=\"width:0;height:0;position:absolute;right:0;bottom:0;\"></div>'),this.renderCalContentAndArrowsOverlay(t,e,i),t.write(\"</div>\")},t.renderCalContentOverlay=function(t,e,i){t.write('<div id=\"'+i+'-contentOver\" class=\"sapUiCalContentOver\" style=\"display:none;\"></div>')},t.renderCalContentAndArrowsOverlay=function(t,e,i){},t.writeAdditionalControls=function(t,e){},t.writeAdditionalStyleClasses=function(t,e){},t},!0);",
	"sap/ui/unified/CalendarRow.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/core/Control\",\"sap/ui/Device\",\"sap/ui/core/LocaleData\",\"sap/ui/unified/calendar/CalendarUtils\",\"sap/ui/core/date/UniversalDate\",\"./library\",\"sap/ui/core/InvisibleText\",\"sap/ui/core/format/DateFormat\",\"sap/ui/core/ResizeHandler\",\"sap/ui/core/Locale\",\"./CalendarRowRenderer\"],function(e,t,i,n,a,s,o,r,p,l,g,h){\"use strict\";function u(){return this._sLocale||(this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString()),this._sLocale}function d(){if(!this._oLocaleData){var e=u.call(this),t=new g(e);this._oLocaleData=n.getInstance(t)}return this._oLocaleData}function c(){var e,t=this.getStartDate(),i=this.getIntervals(),n=this.getIntervalType();switch(this._oUTCStartDate=m.call(this,t),n){case F.Hour:e=new s(this._oUTCStartDate.getTime()),e.setUTCHours(e.getUTCHours()+i),this._iMinDelta=this._iHoursMinDelta;break;case F.Day:case F.Week:case F.OneMonth:e=new s(this._oUTCStartDate.getTime()),e.setUTCDate(e.getUTCDate()+i),this._iMinDelta=this._iDaysMinDelta;break;case F.Month:e=new s(this._oUTCStartDate.getTime()),e.setUTCMonth(e.getUTCMonth()+i),this._iMinDelta=this._iMonthsMinDelta;break;default:throw new Error(\"Unknown IntervalType: \"+n+\"; \"+this)}e.setUTCMilliseconds(-1),this._iRowSize=e.getTime()-this._oUTCStartDate.getTime(),this._iIntervalSize=Math.floor(this._iRowSize/i),this._oUTCEndDate=e}function m(e){var t=this.getIntervalType(),i=a._createUniversalUTCDate(e,void 0,!0);switch(t){case F.Hour:i.setUTCMinutes(0),i.setUTCSeconds(0),i.setUTCMilliseconds(0);break;case F.Day:case F.Week:case F.OneMonth:i.setUTCHours(0),i.setUTCMinutes(0),i.setUTCSeconds(0),i.setUTCMilliseconds(0);break;case F.Month:i.setUTCDate(1),i.setUTCHours(0),i.setUTCMinutes(0),i.setUTCSeconds(0),i.setUTCMilliseconds(0);break;default:throw new Error(\"Unknown IntervalType: \"+t+\"; \"+this)}return i}function T(){return i.system.phone||this.getGroupAppointmentsMode()===L.Collapsed}function f(){var e,t,i,n=this._aVisibleAppointments||[],o=this._getAppointmentsSorted(),r=this.getIntervals(),p=this.getIntervalType(),l=this._getStartDate(),g=l.getTime(),h=this._oUTCEndDate,u=h.getTime(),d=[],c=!1,m=0,f=0,U=T.call(this);for(this.destroyAggregation(\"groupAppointments\",!0),m=0;m<o.length;m++){e=o[m];var A=a._createUniversalUTCDate(e.getStartDate(),void 0,!0);A.setUTCSeconds(0),A.setUTCMilliseconds(0);var D=e.getEndDate()?a._createUniversalUTCDate(e.getEndDate(),void 0,!0):a._createUniversalUTCDate(new Date(864e12),void 0,!0);D.setUTCSeconds(0),D.setUTCMilliseconds(0);var y=!1;A.getTime()<g&&D.getTime()>=g&&(A=new s(g),y=!0),D.getTime()>u&&A.getTime()<=u&&(D=new s(u),y=!0);var b=60*A.getUTCHours()+A.getUTCMinutes();A.setUTCMinutes(A.getUTCMinutes()-b%this._iMinDelta);var M=(D.getTime()-A.getTime())/6e4;if(!y||0!=M){var S=0,I=0,w=-1;if(t=void 0,i=void 0,A&&A.getTime()<=u&&D&&D.getTime()>=g){if(U&&p==F.Month&&D.getTime()-A.getTime()<6048e5){t=C.call(this,A,e,p,r,l,h,g,d);var H=a._createUniversalUTCDate(t.getEndDate(),void 0,!0);D.getTime()>H.getTime()&&(i=C.call(this,D,e,p,r,l,h,g,d))}for(S=v.call(this,p,r,l,h,g,A),I=_.call(this,p,r,l,h,g,D),f=0;f<n.length;f++){var k=n[f];e==k.appointment&&(w=k.level)}if(t){t._iBegin=S,t._iEnd=I,t._iLevel=w,i&&(i._iBegin=S,i._iEnd=I,i._iLevel=w);continue}d.push({appointment:e,begin:S,end:I,calculatedEnd:I,level:w}),this._sFocusedAppointmentId&&this._sFocusedAppointmentId==e.getId()&&(c=!0)}}}var R=this.getAggregation(\"groupAppointments\",[]);if(R.length>0)for(m=0;m<d.length;m++)if(e=d[m],e.appointment._aAppointments&&e.appointment._aAppointments.length<=1){t=e.appointment;var V=!1;if(0==t._aAppointments.length)V=!0;else for(f=0;f<d.length;f++)if(d[f].appointment==t._aAppointments[0]){V=!0;break}if(V)d.splice(m,1),m--;else{for(f=0;f<R.length;f++)if(i=R[f],t!=i)for(var E=0;E<i._aAppointments.length;E++)if(t._aAppointments[0]==i._aAppointments[E]){i._aAppointments.splice(E,1),1==i._aAppointments.length?(this.removeAggregation(\"groupAppointments\",i),i.destroy(),R=this.getAggregation(\"groupAppointments\",[])):i.setProperty(\"title\",i._aAppointments.length,!0);break}e.begin=t._iBegin,e.end=t._iEnd,e.calculatedEnd=t._iEnd,e.level=t._iLevel,e.appointment=t._aAppointments[0]}this.removeAggregation(\"groupAppointments\",t),t.destroy(),R=this.getAggregation(\"groupAppointments\",[])}return c||(d.length>0?this._sFocusedAppointmentId=d[0].appointment.getId():this._sFocusedAppointmentId=void 0),this._aVisibleAppointments=d,this._aVisibleAppointments}function C(e,t,i,n,o,r,p,l){var g,h=this.getAggregation(\"groupAppointments\",[]),u=d.call(this),c=u.getFirstDayOfWeek(),m=e.getUTCDay(),T=new s(e.getTime());T.setUTCHours(0),T.setUTCMinutes(0),T.setUTCSeconds(0),T.setUTCMilliseconds(0),c<=m?T.setDate(T.getDate()-(m-c)):T.setDate(T.getDate()-(7-m-c));for(var f=0;f<h.length;f++){g=h[f];if(a._createUniversalUTCDate(g.getStartDate(),void 0,!0).getTime()==T.getTime())break;g=void 0}if(!g){var C=new s(T.getTime());C.setDate(C.getDate()+7),C.setMilliseconds(-1),g=new sap.ui.unified.CalendarAppointment(this.getId()+\"-Group\"+h.length,{type:t.getType(),startDate:a._createLocalDate(new Date(T.getTime()),!0),endDate:a._createLocalDate(new Date(C.getTime()),!0)}),g._aAppointments=[],this.addAggregation(\"groupAppointments\",g,!0);var U=v.call(this,i,n,o,r,p,T),A=_.call(this,i,n,o,r,p,C);l.push({appointment:g,begin:U,end:A,calculatedEnd:A,level:-1})}return g._aAppointments.push(t),g.getType()!=V.None&&g.getType()!=t.getType()&&g.setType(V.None),g.setProperty(\"title\",g._aAppointments.length,!0),g}function v(e,t,i,n,a,o){var r=0;if(e!=F.Month)r=100*(o.getTime()-a)/this._iRowSize;else{var p=new s(o.getTime());p.setUTCDate(1),p.setUTCHours(0),p.setUTCMinutes(0),p.setUTCSeconds(0),p.setUTCMilliseconds(0);var l=new s(p.getTime());l.setUTCMonth(l.getUTCMonth()+1),l.setMilliseconds(-1);var g=l.getTime()-p.getTime();r=100*(12*(p.getUTCFullYear()-i.getUTCFullYear())+p.getUTCMonth()-i.getUTCMonth())/t+100*(o.getTime()-p.getTime())/g/t}return r<0&&(r=0),r=Math.round(1e5*r)/1e5}function _(e,t,i,n,a,o){var r=0;if(e!=F.Month)r=100-100*(o.getTime()-a)/this._iRowSize;else{var p=new s(o.getTime());p.setUTCDate(1),p.setUTCHours(0),p.setUTCMinutes(0),p.setUTCSeconds(0),p.setUTCMilliseconds(0);var l=new s(p.getTime());l.setUTCMonth(l.getUTCMonth()+1),l.setMilliseconds(-1);var g=l.getTime()-p.getTime();r=100-(100*(12*(p.getUTCFullYear()-i.getUTCFullYear())+p.getUTCMonth()-i.getUTCMonth())/t+100*(o.getTime()-p.getTime())/g/t)}return r<0&&(r=0),r=Math.round(1e5*r)/1e5}function U(){var e=[];if(this.getShowIntervalHeaders()){var t,i=this.getIntervalHeaders(),n=this.getIntervals(),o=this.getIntervalType(),r=this._getStartDate(),p=r.getTime(),l=this._oUTCEndDate,g=l.getTime(),h=0,u=0;for(h=0;h<i.length;h++){t=i[h];var d=a._createUniversalUTCDate(t.getStartDate(),void 0,!0);d.setUTCSeconds(0),d.setUTCMilliseconds(0);var c=t.getEndDate()?a._createUniversalUTCDate(t.getEndDate(),void 0,!0):a._createUniversalUTCDate(new Date(864e12),void 0,!0);if(c.setUTCSeconds(0),c.setUTCMilliseconds(0),d&&d.getTime()<=g&&c&&c.getTime()>=p){var m=new s(r.getTime()),T=new s(r.getTime());T.setUTCMinutes(T.getUTCMinutes()-1);var f=-1,C=-1;for(u=0;u<n;u++){switch(o){case F.Hour:T.setUTCHours(T.getUTCHours()+1),u>0&&m.setUTCHours(m.getUTCHours()+1);break;case F.Day:case F.Week:case F.OneMonth:T.setUTCDate(T.getUTCDate()+1),u>0&&m.setUTCDate(m.getUTCDate()+1);break;case F.Month:T.setUTCDate(1),T.setUTCMonth(T.getUTCMonth()+2),T.setUTCDate(0),u>0&&m.setUTCMonth(m.getUTCMonth()+1);break;default:throw new Error(\"Unknown IntervalType: \"+o+\"; \"+this)}d&&d.getTime()<=m.getTime()&&c&&c.getTime()>=T.getTime()&&(f<0&&(f=u),C=u)}f>=0&&e.push({interval:f,appointment:t,last:C})}}}return this._aVisibleIntervalHeaders=e,this._aVisibleIntervalHeaders}function A(){if(!this._isOneMonthIntervalOnSmallSizes()){var t=this.$(\"Apps\"),n=t.innerWidth();if(!(n<=0)){var a=this.$(\"DummyApp\"),s=a.outerHeight(!0);if(!(s<=0)){var o,r,p=a.outerWidth(),l=p/n*100,g=Math.ceil(1e3*l)/1e3,h=0,u=0,d=0,c=!i.system.phone&&this.getAppointmentsReducedHeight();for(this.getShowIntervalHeaders()&&(this.getShowEmptyIntervalHeaders()||this._getVisibleIntervalHeaders().length>0)&&(h=e(this.$(\"AppsInt0\").children(\".sapUiCalendarRowAppsIntHead\")[0]).outerHeight(!0)),d=0;d<this._aVisibleAppointments.length;d++){o=this._aVisibleAppointments[d],r=o.appointment.$();var m=Math.floor(1e3*(100-o.calculatedEnd-o.begin))/1e3,T=!1;m<g?(o.end=100-o.begin-l,o.end<0&&(o.end=0),o.level=-1,T=!0,r.addClass(\"sapUiCalendarAppSmall\")):r.hasClass(\"sapUiCalendarAppSmall\")&&(o.end=o.calculatedEnd,T=!0,r.removeClass(\"sapUiCalendarAppSmall\")),T&&(this._bRTL?r.css(\"left\",o.end+\"%\"):r.css(\"right\",o.end+\"%\"))}for(d=0;d<this._aVisibleAppointments.length;d++){o=this._aVisibleAppointments[d],r=o.appointment.$();var f={},C=c&&!this._getAppointmentReducedHeight(o.appointment);if(o.level<0){for(var v=0;v<this._aVisibleAppointments.length;v++){var _=this._aVisibleAppointments[v];o!=_&&o.begin<Math.floor(1e3*(100-_.end))/1e3&&Math.floor(1e3*(100-o.end))/1e3>_.begin&&_.level>=0&&(f[_.level]?f[_.level]++:f[_.level]=1,c&&!this._getAppointmentReducedHeight(_.appointment)&&(f[_.level+1]?f[_.level+1]++:f[_.level+1]=1))}for(o.level=0;f[o.level]||C&&f[o.level+1];)o.level++;r.attr(\"data-sap-level\",o.level)}r.css(\"top\",s*o.level+h+\"px\");var U=o.level;C&&U++,u<U&&(u=U)}if(u++,s=s*u+h,this.getHeight()){var A=this.$(\"Apps\").children(\".sapUiCalendarRowAppsInt\");for(d=0;d<A.length;d++){e(A[d]).outerHeight(s)}}else t.outerHeight(s);a.css(\"display\",\"none\")}}}}function D(t,i){var n,a,s,o,p=0,l=r.getStaticId(\"sap.ui.unified\",\"APPOINTMENT_SELECTED\");if(i){var g=this.getAppointments(),h=this.getAggregation(\"groupAppointments\",[]);for(e.merge(g,h),p=0;p<g.length;p++)if(n=g[p],n.getId()!==t.getId()&&n.getSelected()){n.setProperty(\"selected\",!1,!0),n.$().removeClass(\"sapUiCalendarAppSel\");for(var p=0;p<this.aSelectedAppointments.length;p++)this.aSelectedAppointments[p]!==n.getId()&&this.aSelectedAppointments.splice(p);a=n.$().attr(\"aria-labelledby\"),s=a?a.replace(l,\"\"):\"\",n.$().attr(\"aria-labelledby\",s)}}if(t.getSelected()?(t.setProperty(\"selected\",!1,!0),t.$().removeClass(\"sapUiCalendarAppSel\"),this.aSelectedAppointments=this.aSelectedAppointments.filter(function(e){return e!==t.getId()}),M(this,i)):(t.setProperty(\"selected\",!0,!0),t.$().addClass(\"sapUiCalendarAppSel\"),M(this,i),this.aSelectedAppointments.push(t.getId())),o=t.$().attr(\"aria-labelledby\")+\" \"+l,t.$().attr(\"aria-labelledby\",o),t._aAppointments){for(p=0;p<t._aAppointments.length;p++)n=t._aAppointments[p],n.setProperty(\"selected\",!0,!0),o=n.$().attr(\"aria-labelledby\")+\" \"+l,n.$().attr(\"aria-labelledby\",o);this.fireSelect({appointments:t._aAppointments,multiSelect:!i,domRefId:t.getId()})}else this.fireSelect({appointment:t,multiSelect:!i,domRefId:t.getId()})}function y(e){var t=b.call(this);t&&t[\"_onRow\"+e]()}function b(){for(var e=this;null!==e.getParent();){if(\"sap.m.PlanningCalendar\"===e.getMetadata().getName())return e;e=e.getParent()}}function M(e,t){t&&y.call(e,\"DeselectAppointment\")}function S(e){for(var t,i=this.getAggregation(\"groupAppointments\",[]),n=!1,a=0;a<i.length;a++){for(var s=i[a]._aAppointments,o=0;o<s.length;o++)if(s[o].getId()==e){t=i[a],n=!0;break}if(n)break}return t}function I(t){if(this._sFocusedAppointmentId!=t){var i,n=this._getAppointmentsSorted(),s=this._aVisibleAppointments,o=0;for(i=S.call(this,t),i&&(t=i.getId(),i=void 0),o=0;o<s.length;o++)if(s[o].appointment.getId()==t){i=s[o].appointment;break}if(i){var r=this.getFocusedAppointment().$(),p=i.$();this._sFocusedAppointmentId=i.getId(),r.attr(\"tabindex\",\"-1\"),p.attr(\"tabindex\",\"0\"),p.focus()}else{for(o=0;o<n.length;o++)if(n[o].getId()==t){i=n[o];break}if(i){this._sFocusedAppointmentId=i.getId();var l=m.call(this,i.getStartDate());this.setStartDate(a._createLocalDate(l,!0)),e.sap.containsOrEquals(this.getDomRef(),document.activeElement)||e.sap.delayedCall(0,this,function(){this.getFocusedAppointment().focus()}),this.fireStartDateChange()}}}}function w(e,t){var i,n=this._sFocusedAppointmentId,a=this._getAppointmentsSorted(),s=this.getAggregation(\"groupAppointments\",[]),o=0,r=0;for(r=0;r<s.length;r++)if(s[r].getId()==n){var p=s[r]._aAppointments;n=e?p[p.length-1].getId():p[0].getId();break}for(r=0;r<a.length;r++)if(a[r].getId()==n){o=r;break}e?o+=t:o-=t,o<0?o=0:o>=a.length&&(o=a.length-1),i=a[o],I.call(this,i.getId())}function H(e){var t,i,n,o=this._getAppointmentsSorted(),r=new s(this._getStartDate()),p=new s(this._oUTCEndDate),l=this.getIntervalType();switch(r.setUTCHours(0),p.setUTCHours(0),p.setUTCMinutes(0),p.setUTCSeconds(0),l){case F.Hour:p.setUTCDate(p.getUTCDate()+1),p.setUTCMilliseconds(-1);break;case F.Day:case F.Week:case F.OneMonth:r.setUTCDate(1),p.setUTCMonth(p.getUTCMonth()+1),p.setUTCDate(1),p.setUTCMilliseconds(-1);break;case F.Month:r.setUTCMonth(0),r.setUTCDate(1),p.setUTCFullYear(p.getUTCFullYear()+1),p.setUTCMonth(1),p.setUTCDate(1),p.setUTCMilliseconds(-1);break;default:throw new Error(\"Unknown IntervalType: \"+l+\"; \"+this)}for(var g=a._createLocalDate(r,!0),h=a._createLocalDate(p,!0),u=0;u<o.length;u++)if(o[u].getStartDate()>=g&&o[u].getStartDate()<=h){if(t=o[u],i=t.getId(),\"saphome\"==e.type)break}else if(o[u].getStartDate()>h)break;n=S.call(this,i),n&&(t=n,i=t.getId()),i&&i!=this._sFocusedAppointmentId?I.call(this,i):e._bPlanningCalendar&&t?t.focus():this.fireLeaveRow({type:e.type})}function k(t,i){var n,o=this.getIntervalType(),r=this._getStartDate(),p=new s(r.getTime()),l=!1,g=0,h=0;if(e(i).hasClass(\"sapUiCalendarRowAppsSubInt\")){l=!0;var u=e(e(i).parent()).children(\".sapUiCalendarRowAppsSubInt\");for(h=u.length,g=0;g<h;g++){if(u[g]==i)break}}switch(o){case F.Hour:p.setUTCHours(p.getUTCHours()+t),l?(p.setUTCMinutes(p.getUTCMinutes()+60*g/h),n=new s(p.getTime()),n.setUTCMinutes(n.getUTCMinutes()+60/h)):(n=new s(p.getTime()),n.setUTCHours(n.getUTCHours()+1));break;case F.Day:case F.Week:case F.OneMonth:p.setUTCDate(p.getUTCDate()+t),l?(p.setUTCHours(p.getUTCHours()+24*g/h),n=new s(p.getTime()),n.setUTCHours(n.getUTCHours()+24/h)):(n=new s(p.getTime()),n.setUTCDate(n.getUTCDate()+1));break;case F.Month:p.setUTCMonth(p.getUTCMonth()+t),l?(p.setUTCDate(p.getUTCDate()+g),n=new s(p.getTime()),n.setUTCDate(n.getUTCDate()+1)):(n=new s(p.getTime()),n.setUTCMonth(n.getUTCMonth()+1));break;default:throw new Error(\"Unknown IntervalType: \"+o+\"; \"+this)}n.setUTCMilliseconds(n.getUTCMilliseconds()-1),p=a._createLocalDate(p,!0),n=a._createLocalDate(n,!0),this.fireIntervalSelect({startDate:p,endDate:n,subInterval:l})}function R(e,t){var i=e.getStartDate()-t.getStartDate();return 0==i&&(i=t.getEndDate()-e.getEndDate()),i}var V=o.CalendarDayType,E=o.CalendarAppointmentVisualization,L=o.GroupAppointmentsMode,F=o.CalendarIntervalType,z=t.extend(\"sap.ui.unified.CalendarRow\",{metadata:{library:\"sap.ui.unified\",properties:{startDate:{type:\"object\",group:\"Data\"},intervals:{type:\"int\",group:\"Appearance\",defaultValue:12},intervalType:{type:\"sap.ui.unified.CalendarIntervalType\",group:\"Appearance\",defaultValue:F.Hour},showSubIntervals:{type:\"boolean\",group:\"Appearance\",defaultValue:!1},showIntervalHeaders:{type:\"boolean\",group:\"Appearance\",defaultValue:!0},showEmptyIntervalHeaders:{type:\"boolean\",group:\"Appearance\",defaultValue:!0},nonWorkingDays:{type:\"int[]\",group:\"Misc\",defaultValue:null},nonWorkingHours:{type:\"int[]\",group:\"Misc\",defaultValue:null},width:{type:\"sap.ui.core.CSSSize\",group:\"Dimension\",defaultValue:null},height:{type:\"sap.ui.core.CSSSize\",group:\"Dimension\",defaultValue:null},checkResize:{type:\"boolean\",group:\"Behavior\",defaultValue:!0},updateCurrentTime:{type:\"boolean\",group:\"Behavior\",defaultValue:!0},groupAppointmentsMode:{type:\"sap.ui.unified.GroupAppointmentsMode\",group:\"Appearance\",defaultValue:L.Collapsed},appointmentsReducedHeight:{type:\"boolean\",group:\"Appearance\",defaultValue:!1},appointmentsVisualization:{type:\"sap.ui.unified.CalendarAppointmentVisualization\",group:\"Appearance\",defaultValue:E.Standard}},aggregations:{appointments:{type:\"sap.ui.unified.CalendarAppointment\",multiple:!0,singularName:\"appointment\"},intervalHeaders:{type:\"sap.ui.unified.CalendarAppointment\",multiple:!0,singularName:\"intervalHeader\"},groupAppointments:{type:\"sap.ui.unified.CalendarAppointment\",multiple:!0,singularName:\"groupAppointment\",visibility:\"hidden\"},_nonWorkingDates:{type:\"sap.ui.unified.DateRange\",multiple:!0,visibility:\"hidden\"}},associations:{ariaLabelledBy:{type:\"sap.ui.core.Control\",multiple:!0,singularName:\"ariaLabelledBy\"},legend:{type:\"sap.ui.unified.CalendarLegend\",multiple:!1}},events:{select:{parameters:{appointment:{type:\"sap.ui.unified.CalendarAppointment\"},appointments:{type:\"sap.ui.unified.CalendarAppointment[]\"},multiSelect:{type:\"boolean\"},domRefId:{type:\"string\"}}},startDateChange:{},leaveRow:{parameters:{type:{type:\"string\"}}},intervalSelect:{parameters:{startDate:{type:\"object\"},endDate:{type:\"object\"},subInterval:{type:\"boolean\"}}}}}});return z.PCROW_FOREIGN_KEY_NAME=\"relatedToPCRowDateRange\",z.AGGR_NONWORKING_DATES_NAME=\"_nonWorkingDates\",z.prototype.init=function(){this._bRTL=sap.ui.getCore().getConfiguration().getRTL(),this._oRb=sap.ui.getCore().getLibraryResourceBundle(\"sap.ui.unified\"),this._oFormatAria=p.getDateTimeInstance({pattern:\"EEEE dd/MM/YYYY 'at' HH:mm:ss a\"}),this._iHoursMinDelta=1,this._iDaysMinDelta=30,this._iMonthsMinDelta=720,this._aVisibleAppointments=[],this._aVisibleIntervalHeaders=[],this.setStartDate(new Date),this._resizeProxy=e.proxy(this.handleResize,this),this.aSelectedAppointments=[],this._fnCustomSortedAppointments=void 0},z.prototype.exit=function(){this._sResizeListener&&(l.deregister(this._sResizeListener),this._sResizeListener=void 0),this._sUpdateCurrentTime&&(e.sap.clearDelayedCall(this._sUpdateCurrentTime),this._sUpdateCurrentTime=void 0),this._fnCustomSortedAppointments=void 0},z.prototype.onBeforeRendering=function(){c.call(this),f.call(this),U.call(this),this._sUpdateCurrentTime&&(e.sap.clearDelayedCall(this._sUpdateCurrentTime),this._sUpdateCurrentTime=void 0)},z.prototype.onAfterRendering=function(){A.call(this),this.updateCurrentTimeVisualization(),this.getCheckResize()&&!this._sResizeListener&&(this._sResizeListener=l.register(this,this._resizeProxy))},z.prototype.onThemeChanged=function(e){if(this.getDomRef()){for(var t=0;t<this._aVisibleAppointments.length;t++){this._aVisibleAppointments[t].level=-1}this.handleResize(e)}},z.prototype.invalidate=function(e){if(e&&e instanceof sap.ui.unified.CalendarAppointment){for(var i=!1,n=0;n<this._aVisibleAppointments.length;n++)if(this._aVisibleAppointments[n].appointment==e){i=!0;break}i&&(this._aVisibleAppointments=[])}t.prototype.invalidate.apply(this,arguments)},z.prototype.setStartDate=function(e){e||(e=new Date),a._checkJSDateObject(e);var t=e.getFullYear();return a._checkYearInValidRange(t),this.setProperty(\"startDate\",e),this},z.prototype._getStartDate=function(){return this._oUTCStartDate||(this._oUTCStartDate=a._createUniversalUTCDate(this.getStartDate(),void 0,!0)),this._oUTCStartDate},z.prototype.setIntervalType=function(e){return this.setProperty(\"intervalType\",e),this._aVisibleAppointments=[],this},z.prototype.setGroupAppointmentsMode=function(e){return this.setProperty(\"groupAppointmentsMode\",e),this._aVisibleAppointments=[],this},z.prototype.setAppointmentsReducedHeight=function(e){return this.setProperty(\"appointmentsReducedHeight\",e),this._aVisibleAppointments=[],this},z.prototype._getAppointmentReducedHeight=function(e){var t=!1;return i.system.phone||!this.getAppointmentsReducedHeight()||e.getText()||(t=!0),t},z.prototype.onfocusin=function(t){if(e(t.target).hasClass(\"sapUiCalendarApp\"))I.call(this,t.target.id);else{for(var i,n=this._getVisibleAppointments(),a=!1,s=0;s<n.length;s++)if(i=n[s].appointment,e.sap.containsOrEquals(i.getDomRef(),t.target)){a=!0,i.focus();break}a||(i=this.getFocusedAppointment())&&i.focus()}},z.prototype.applyFocusInfo=function(e){return this._sFocusedAppointmentId&&this.getFocusedAppointment().focus(),this},z.prototype.onsapleft=function(t){e(t.target).hasClass(\"sapUiCalendarApp\")&&w.call(this,this._bRTL,1),t.preventDefault(),t.stopPropagation()},z.prototype.onsapright=function(t){e(t.target).hasClass(\"sapUiCalendarApp\")&&w.call(this,!this._bRTL,1),t.preventDefault(),t.stopPropagation()},z.prototype.onsapup=function(e){this.fireLeaveRow({type:e.type})},z.prototype.onsapdown=function(e){this.fireLeaveRow({type:e.type})},z.prototype.onsaphome=function(e){H.call(this,e),e.preventDefault(),e.stopPropagation()},z.prototype.onsapend=function(e){H.call(this,e),e.preventDefault(),e.stopPropagation()},z.prototype.onsapselect=function(t){for(var i=this._getVisibleAppointments(),n=0;n<i.length;n++){var a=i[n].appointment;if(e.sap.containsOrEquals(a.getDomRef(),t.target)){D.call(this,a,!t.ctrlKey);break}}t.stopPropagation(),t.preventDefault()},z.prototype.ontap=function(t){var i=this.$(\"Apps\").children(\".sapUiCalendarRowAppsInt\"),n=0,a=!1;for(n=0;n<i.length;n++){var s=i[n];if(!this._isOneMonthIntervalOnSmallSizes()&&e.sap.containsOrEquals(s,t.target)){a=!0;break}}a?k.call(this,n,t.target):this.onsapselect(t)},z.prototype.onsapselectmodifiers=function(e){this.onsapselect(e)},z.prototype.handleResize=function(e){return e&&e.size&&e.size.width<=0?this:(this.$(\"DummyApp\").css(\"display\",\"\"),A.call(this),this)},z.prototype.updateCurrentTimeVisualization=function(){var t=this.$(\"Now\"),i=a._createUniversalUTCDate(new Date,void 0,!0),n=this.getIntervals(),s=this.getIntervalType(),o=this._getStartDate(),r=o.getTime(),p=this._oUTCEndDate,l=p.getTime();if(this._sUpdateCurrentTime=void 0,i.getTime()<=l&&i.getTime()>=r){var g=v.call(this,s,n,o,p,r,i),h=0;if(this._bRTL?t.css(\"right\",g+\"%\"):t.css(\"left\",g+\"%\"),t.css(\"display\",\"\"),this.getUpdateCurrentTime()){switch(s){case F.Hour:h=6e4;break;case F.Day:case F.Week:case F.OneMonth:h=18e5;break;default:h=-1}h>0&&(this._sUpdateCurrentTime=e.sap.delayedCall(h,this,this.updateCurrentTimeVisualization))}}else t.css(\"display\",\"none\");return this},z.prototype.getFocusedAppointment=function(){var e,t=this._getAppointmentsSorted(),i=this.getAggregation(\"groupAppointments\",[]),n=0;for(n=0;n<i.length;n++)if(i[n].getId()==this._sFocusedAppointmentId){e=i[n];break}if(!e)for(n=0;n<t.length;n++)if(t[n].getId()==this._sFocusedAppointmentId){e=t[n];break}return e},z.prototype.focusAppointment=function(e){if(!(e&&e instanceof sap.ui.unified.CalendarAppointment))throw new Error(\"Appointment must be a CalendarAppointment; \"+this);var t=e.getId();return this._sFocusedAppointmentId!=t?I.call(this,t):e.focus(),this},z.prototype.focusNearestAppointment=function(e){a._checkJSDateObject(e);for(var t,i,n,s=this._getAppointmentsSorted(),o=0;o<s.length;o++)if(t=s[o],t.getStartDate()>e){i=o>0?s[o-1]:t;break}return t&&(n=i&&Math.abs(t.getStartDate()-e)>=Math.abs(i.getStartDate()-e)?i:t,this.focusAppointment(n)),this},z.prototype._getVisibleAppointments=function(){return this._aVisibleAppointments},z.prototype._getVisibleIntervalHeaders=function(){return this._aVisibleIntervalHeaders},z.prototype._getNonWorkingDays=function(){var t=this.getNonWorkingDays();if(t)e.isArray(t)||(t=[]);else{var i=d.call(this),n=i.getWeekendStart(),a=i.getWeekendEnd();t=[];for(var s=0;s<=6;s++)(n<=a&&s>=n&&s<=a||n>a&&(s>=n||s<=a))&&t.push(s)}return t},z.prototype._isOneMonthIntervalOnSmallSizes=function(){return this.getIntervalType()===F.OneMonth&&1===this.getIntervals()},z.prototype._getAppointmentsSorted=function(){var e=this.getAppointments(),t=R;return e.sort(this._fnCustomSortedAppointments?this._fnCustomSortedAppointments:t),e},z.prototype._setCustomAppointmentsSorterCallback=function(e){this._fnCustomSortedAppointments=e},z});",
	"sap/ui/unified/CalendarRowRenderer.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/core/date/UniversalDate\",\"sap/ui/unified/CalendarAppointment\",\"sap/ui/unified/CalendarLegendRenderer\",\"sap/ui/Device\",\"sap/ui/unified/library\",\"sap/ui/core/InvisibleText\"],function(e,t,a,i,r,s,n){\"use strict\";var d=s.CalendarDayType,l=s.CalendarIntervalType,p=s.CalendarAppointmentVisualization,o={};return o.render=function(e,t){var a=t.getTooltip_AsString(),i=t.getAppointmentsVisualization(),s=this.getLegendItems(t);e.write(\"<div\"),e.writeControlData(t),e.addClass(\"sapUiCalendarRow\"),!r.system.phone&&t.getAppointmentsReducedHeight()&&e.addClass(\"sapUiCalendarRowAppsRedHeight\"),i!=p.Standard&&e.addClass(\"sapUiCalendarRowVis\"+i),a&&e.writeAttributeEscaped(\"title\",a);var n=t.getWidth();n&&e.addStyle(\"width\",n);var d=t.getHeight();d&&e.addStyle(\"height\",d),e.writeAccessibilityState(t),e.writeClasses(),e.writeStyles(),e.write(\">\"),this.renderAppointmentsRow(e,t,s),e.write(\"</div>\")},o.renderAppointmentsRow=function(e,t,a){var i=t.getId();e.write('<div id=\"'+i+'-Apps\" class=\"sapUiCalendarRowApps\">'),this.renderBeforeAppointments(e,t),this.renderAppointments(e,t,a),this.renderAfterAppointments(e,t),e.write(\"</div>\")},o.renderBeforeAppointments=function(e,t){},o.renderAfterAppointments=function(e,t){},o.renderAppointments=function(e,a,i){var r=a._getVisibleAppointments(),s=a._getVisibleIntervalHeaders(),n=a._getStartDate(),d=[],p=[],o=0,g=0,w=[],C=0,v=0,A=a.getIntervals(),T=a.getIntervalType(),u=100/A,c=0,I=new t(n),h=!1,y=!1;switch(T){case l.Hour:d=a.getNonWorkingHours()||[],o=n.getUTCHours(),g=24;break;case l.Day:case l.Week:case l.OneMonth:d=a._getNonWorkingDays(),p=a.getAggregation(\"_nonWorkingDates\"),o=n.getUTCDay(),g=7,w=a.getNonWorkingHours()||[],C=n.getUTCHours(),v=24;break;case l.Month:w=a._getNonWorkingDays(),C=n.getUTCDay(),v=7}if(a._isOneMonthIntervalOnSmallSizes())this.renderSingleDayInterval(e,a,r,i,s,d,o,g,w,C,v,!0,!0);else{for(c=0;c<A;c++){switch(h=!!y,y=!1,T){case l.Hour:I.setUTCHours(I.getUTCHours()+1),0==I.getUTCHours()&&(y=!0);break;case l.Day:case l.Week:case l.OneMonth:I.setUTCDate(I.getUTCDate()+1),1==I.getUTCDate()&&(y=!0);break;case l.Month:I.setUTCMonth(I.getUTCMonth()+1),0==I.getUTCMonth()&&(y=!0)}this.renderInterval(e,a,c,u,s,d,p,o,g,w,C,v,h,y)}for(this.renderIntervalHeaders(e,a,u,s,A),e.write('<div id=\"'+a.getId()+'-Now\" class=\"sapUiCalendarRowNow\"></div>'),c=0;c<r.length;c++){var U=r[c];this.renderAppointment(e,a,U,i)}e.write('<div id=\"'+a.getId()+'-DummyApp\" class=\"sapUiCalendarApp sapUiCalendarAppTitleOnly sapUiCalendarAppDummy\"></div>')}},o.renderInterval=function(e,a,i,r,s,n,d,p,o,g,w,C,v,A){var T,u,c,I,h=a.getId()+\"-AppsInt\"+i,y=a.getShowIntervalHeaders()&&(a.getShowEmptyIntervalHeaders()||s.length>0),U=a.getStartDate().getMonth(),b=new Date(a.getStartDate().getFullYear(),U+1,0).getDate(),S=a.getStartDate();for(e.write('<div id=\"'+h+'\"'),e.addClass(\"sapUiCalendarRowAppsInt\"),e.addStyle(\"width\",r+\"%\"),i>=b&&a.getIntervalType()===l.OneMonth&&e.addClass(\"sapUiCalItemOtherMonth\"),T=0;T<n.length;T++)if((i+p)%o==n[T]){e.addClass(\"sapUiCalendarRowAppsNoWork\");break}if(d&&d.length){u=new Date(S.getTime()),u.setHours(0,0,0),u.setDate(S.getDate()+i);var m=function(e){return e===u.getDay()};for(T=0;T<d.length;T++)if(d[T].getStartDate()&&(c=new Date(d[T].getStartDate().getTime())),d[T].getEndDate()?I=new Date(d[T].getEndDate().getTime()):(I=new Date(d[T].getStartDate().getTime()),I.setHours(23,59,59)),u.getTime()>=c.getTime()&&u.getTime()<=I.getTime()){var D=n.some(m);D||e.addClass(\"sapUiCalendarRowAppsNoWork\")}}if(y||e.addClass(\"sapUiCalendarRowAppsIntNoHead\"),v&&e.addClass(\"sapUiCalendarRowAppsIntFirst\"),A&&e.addClass(\"sapUiCalendarRowAppsIntLast\"),e.writeClasses(),e.writeStyles(),e.write(\">\"),y&&(e.write(\"<div\"),e.addClass(\"sapUiCalendarRowAppsIntHead\"),e.writeClasses(),e.write(\">\"),e.write(\"</div>\")),a.getShowSubIntervals()){var f=a.getIntervalType(),R=0;switch(f){case l.Hour:R=4;break;case l.Day:case l.Week:case l.OneMonth:R=24;break;case l.Month:var H=a._getStartDate(),N=new t(H);N.setUTCMonth(N.getUTCMonth()+i+1,0),R=N.getUTCDate(),N.setUTCDate(1),p=N.getUTCDay()}var _=100/R;for(T=0;T<R;T++){e.write(\"<div\"),e.addClass(\"sapUiCalendarRowAppsSubInt\"),e.addStyle(\"width\",_+\"%\");for(var k=0;k<g.length;k++)if((T+w)%C==g[k]){e.addClass(\"sapUiCalendarRowAppsNoWork\");break}e.writeStyles(),e.writeClasses(),e.write(\">\"),e.write(\"</div>\")}}e.write(\"</div>\")},o.renderIntervalHeaders=function(e,t,a,i,r){if(t.getShowIntervalHeaders()&&(t.getShowEmptyIntervalHeaders()||i.length>0))for(var s=0;s<i.length;s++){var n,d,l=i[s];t._bRTL?(d=a*l.interval,n=a*(r-l.last-1)):(n=a*l.interval,d=a*(r-l.last-1)),this.renderIntervalHeader(e,l,t._bRTL,n,d)}},o.renderIntervalHeader=function(e,t,a,i,r){var s=t.appointment.getId();e.write(\"<div\"),e.addClass(\"sapUiCalendarRowAppsIntHead\"),void 0!==i&&e.addStyle(\"left\",i+\"%\"),void 0!==r&&e.addStyle(\"right\",r+\"%\"),e.writeElementData(t.appointment),e.addClass(\"sapUiCalendarRowAppsIntHeadFirst\"),t.appointment.getSelected()&&e.addClass(\"sapUiCalendarRowAppsIntHeadSel\"),t.appointment.getTentative()&&e.addClass(\"sapUiCalendarRowAppsIntHeadTent\");var n=t.appointment.getTooltip_AsString();n&&e.writeAttributeEscaped(\"title\",n);var l=t.appointment.getType(),p=t.appointment.getColor();!p&&l&&l!=d.None&&e.addClass(\"sapUiCalendarRowAppsIntHead\"+l),p&&(a?e.addStyle(\"border-right-color\",p):e.addStyle(\"border-left-color\",p)),e.writeStyles(),e.writeClasses(),e.write(\">\"),e.write(\"<div\"),e.addClass(\"sapUiCalendarIntervalHeaderCont\"),e.writeClasses(),p&&(e.addStyle(\"background-color\",t.appointment._getCSSColorForBackground(p)),e.writeStyles()),e.write(\">\");var o=t.appointment.getIcon();if(o){var g=[\"sapUiCalendarRowAppsIntHeadIcon\"],w={};w.id=s+\"-Icon\",w.title=null,e.writeIcon(o,g,w)}var C=t.appointment.getTitle();C&&(e.write(\"<span\"),e.writeAttribute(\"id\",s+\"-Title\"),e.addClass(\"sapUiCalendarRowAppsIntHeadTitle\"),e.writeClasses(),e.write(\">\"),e.writeEscaped(C,!0),e.write(\"</span>\"));var v=t.appointment.getText();v&&(e.write(\"<span\"),e.writeAttribute(\"id\",s+\"-Text\"),e.addClass(\"sapUiCalendarRowAppsIntHeadText\"),e.writeClasses(),e.write(\">\"),e.writeEscaped(v,!0),e.write(\"</span>\")),e.write(\"</div>\"),e.write(\"</div>\")},o.renderAppointment=function(e,t,a,i,r){var s=a.appointment,l=s.getTooltip_AsString(),o=s.getType(),g=s.getColor(),w=s.getTitle(),C=s.getText(),v=s.getIcon(),A=s.getId(),T={labelledby:{value:n.getStaticId(\"sap.ui.unified\",\"APPOINTMENT\")+\" \"+A+\"-Descr\",append:!0}},u=t.getAriaLabelledBy();if(u.length>0&&(T.labelledby.value=T.labelledby.value+\" \"+u.join(\" \")),w&&(T.labelledby.value=T.labelledby.value+\" \"+A+\"-Title\"),C&&(T.labelledby.value=T.labelledby.value+\" \"+A+\"-Text\"),e.write(\"<div\"),e.writeElementData(s),e.addClass(\"sapUiCalendarApp\"),s.getSelected()&&(e.addClass(\"sapUiCalendarAppSel\"),T.labelledby.value=T.labelledby.value+\" \"+n.getStaticId(\"sap.ui.unified\",\"APPOINTMENT_SELECTED\")),s.getTentative()&&(e.addClass(\"sapUiCalendarAppTent\"),T.labelledby.value=T.labelledby.value+\" \"+n.getStaticId(\"sap.ui.unified\",\"APPOINTMENT_TENTATIVE\")),C||e.addClass(\"sapUiCalendarAppTitleOnly\"),v&&e.addClass(\"sapUiCalendarAppWithIcon\"),r||(t._bRTL?(e.addStyle(\"right\",a.begin+\"%\"),e.addStyle(\"left\",a.end+\"%\")):(e.addStyle(\"left\",a.begin+\"%\"),e.addStyle(\"right\",a.end+\"%\"))),e.writeAttribute(\"data-sap-level\",a.level),t._sFocusedAppointmentId==A?e.writeAttribute(\"tabindex\",\"0\"):e.writeAttribute(\"tabindex\",\"-1\"),l&&e.writeAttributeEscaped(\"title\",l),!g&&o&&o!=d.None&&e.addClass(\"sapUiCalendarApp\"+o),g&&(t._bRTL?e.addStyle(\"border-right-color\",g):e.addStyle(\"border-left-color\",g)),e.writeAccessibilityState(s,T),e.writeClasses(),e.writeStyles(),e.write(\">\"),e.write(\"<div\"),e.addClass(\"sapUiCalendarAppCont\"),g&&t.getAppointmentsVisualization()===p.Filled&&(e.addStyle(\"background-color\",s._getCSSColorForBackground(g)),e.writeStyles()),e.writeClasses(),e.write(\">\"),v){var c=[\"sapUiCalendarAppIcon\"],I={};I.id=A+\"-Icon\",I.title=null,e.writeIcon(v,c,I)}w&&(e.write(\"<span\"),e.writeAttribute(\"id\",A+\"-Title\"),e.addClass(\"sapUiCalendarAppTitle\"),e.writeClasses(),e.write(\">\"),e.writeEscaped(w,!0),e.write(\"</span>\")),C&&(e.write(\"<span\"),e.writeAttribute(\"id\",A+\"-Text\"),e.addClass(\"sapUiCalendarAppText\"),e.writeClasses(),e.write(\">\"),e.writeEscaped(C,!0),e.write(\"</span>\"));var h=t._oRb.getText(\"CALENDAR_START_TIME\")+\": \"+t._oFormatAria.format(s.getStartDate());h=h+\"; \"+t._oRb.getText(\"CALENDAR_END_TIME\")+\": \"+t._oFormatAria.format(s.getEndDate()),l&&(h=h+\"; \"+l),o&&o!=d.None&&(h=h+\"; \"+this.getAriaTextForType(o,i)),e.write('<span id=\"'+A+'-Descr\" class=\"sapUiInvisibleText\">'+h+\"</span>\"),e.write(\"</div>\"),e.write(\"</div>\")},o.renderSingleDayInterval=function(e,i,r,s,n,d,p,o,g,w,C,v,A){var T,u,c,I=i.getId()+\"-AppsInt1\",h=i.getShowIntervalHeaders()&&(i.getShowEmptyIntervalHeaders()||n.length>0),y=i.getStartDate(),U=y.getMonth(),b=new Date(y.getFullYear(),U+1,0).getDate(),S=r.concat(i.getIntervalHeaders().filter(function(e){var t=e.getStartDate().getTime(),a=e.getStartDate().getTime(),i=y.getTime(),r=i+864e5;return t>=i&&t<r||a>=i&&a<r}).map(function(e){return{appointment:e,isHeader:!0}})).sort(a._getComparer(y));for(e.write('<div id=\"'+I+'\"'),e.addClass(\"sapUiCalendarRowAppsInt\"),e.addClass(\"sapUiCalendarMonthRowAppsS\"),e.addStyle(\"width\",\"100%\"),1>=b&&i.getIntervalType()===l.OneMonth&&e.addClass(\"sapUiCalItemOtherMonth\"),T=0;T<d.length;T++)if((1+p)%o==d[T]){e.addClass(\"sapUiCalendarRowAppsNoWork\");break}for(h||e.addClass(\"sapUiCalendarRowAppsIntNoHead\"),v&&e.addClass(\"sapUiCalendarRowAppsIntFirst\"),A&&e.addClass(\"sapUiCalendarRowAppsIntLast\"),e.writeClasses(),e.writeStyles(),e.write(\">\"),h&&(e.write(\"<div\"),e.addClass(\"sapUiCalendarRowAppsIntHead\"),e.writeClasses(),e.write(\">\"),e.write(\"</div>\")),T=0;T<S.length;T++)c=S[T],e.write('<div class=\"sapUiCalendarAppContainer\">'),e.write('<div class=\"sapUiCalendarAppContainerLeft\">'),e.write(\"<div>\"+c.appointment._getDateRangeIntersectionText(y)+\"</div>\"),e.write(\"</div>\"),e.write('<div class=\"sapUiCalendarAppContainerRight\">'),c.isHeader?this.renderIntervalHeader(e,c):this.renderAppointment(e,i,c,s,!0),e.write(\"</div>\"),e.write(\"</div>\");if(0===r.length&&(e.write('<div class=\"sapUiCalendarNoApps\">'),u=sap.ui.getCore().getLibraryResourceBundle(\"sap.m\").getText(\"PLANNINGCALENDAR_ROW_NO_APPOINTMENTS\"),e.write(u),e.write(\"</div>\")),e.write('<div id=\"'+i.getId()+'-Now\" class=\"sapUiCalendarRowNow\"></div>'),e.write('<div id=\"'+i.getId()+'-DummyApp\" class=\"sapUiCalendarApp sapUiCalendarAppTitleOnly sapUiCalendarAppDummy\" style=\\'margin:0; height:0px;\\'></div>'),i.getShowSubIntervals()){var m=i.getIntervalType(),D=0;switch(m){case l.Hour:D=4;break;case l.Day:case l.Week:case l.OneMonth:D=24;break;case l.Month:var f=new t(y);f.setUTCMonth(f.getUTCMonth()+1+1,0),D=f.getUTCDate(),f.setUTCDate(1),p=f.getUTCDay()}var R=100/D;for(T=0;T<D;T++){e.write(\"<div\"),e.addClass(\"sapUiCalendarRowAppsSubInt\"),e.addStyle(\"width\",R+\"%\");for(var H=0;H<g.length;H++)if((T+w)%C==g[H]){e.addClass(\"sapUiCalendarRowAppsNoWork\");break}e.writeStyles(),e.writeClasses(),e.write(\">\"),e.write(\"</div>\")}}e.write(\"</div>\")},o.getLegendItems=function(t){var a,i=[],r=t.getLegend();return r&&(a=sap.ui.getCore().byId(r),a?i=a.getItems():e.sap.log.error(\"CalendarLegend with id '\"+r+\"' does not exist!\",t)),i},o.getAriaTextForType=function(e,t){var a,r,s,n;if(t&&t.length)for(var n=0;n<t.length;n++)if(s=t[n],s.getType()===e){a=s.getText();break}return a||(r=i.getTypeAriaText(e))&&(a=r.getText()),a},o},!0);",
	"sap/ui/unified/CalendarTimeInterval.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/core/Control\",\"sap/ui/core/LocaleData\",\"sap/ui/unified/calendar/CalendarUtils\",\"./calendar/Header\",\"./calendar/TimesRow\",\"./calendar/DatesRow\",\"./calendar/MonthPicker\",\"./calendar/YearPicker\",\"sap/ui/core/date/UniversalDate\",\"./library\",\"sap/ui/core/format/DateFormat\",\"sap/ui/Device\",\"sap/ui/core/Locale\",\"sap/ui/core/library\",\"./CalendarTimeIntervalRenderer\"],function(t,e,a,i,s,o,n,r,g,h,c,l,u,D,d,p){\"use strict\";function _(t,e,a){var s=new h(this._oMaxDate.getTime());s.setUTCMinutes(s.getUTCMinutes()-this.getIntervalMinutes()*(this._getItems()-1)),s.getTime()<this._oMinDate.getTime()&&(s=new h(this._oMinDate.getTime()),s.setUTCMinutes(s.getUTCMinutes()+this.getIntervalMinutes()*(this._getItems()-1))),t.getTime()<this._oMinDate.getTime()?t=new h(this._oMinDate.getTime()):t.getTime()>s.getTime()&&(t=s);var o=this.getAggregation(\"timesRow\"),n=i._createLocalDate(t,!0);if(o.setStartDate(n),this._oUTCStartDate=new h(o._getStartDate().getTime()),n=i._createLocalDate(this._oUTCStartDate,!0),this.setProperty(\"startDate\",n,!0),w.call(this),e){var r=i._createLocalDate(this._getFocusedDate(),!0);o.checkDateFocusable(r)?o.setDate(r):(this._setFocusedDate(t),o.setDate(n))}a||this.fireStartDateChange()}function m(){if(!this._oUTCStartDate){var t=this.getAggregation(\"timesRow\");t.setStartDate(i._createLocalDate(this._getFocusedDate(),!0)),this._oUTCStartDate=new h(t._getStartDate().getTime()),this._setFocusedDate(this._oUTCStartDate)}return this._oUTCStartDate}function v(t){var e=this._getFocusedDate(),a=this.getAggregation(\"timesRow\");t?a.displayDate(i._createLocalDate(e,!0)):a.setDate(i._createLocalDate(e,!0)),w.call(this)}function T(){var t=this.getSelectedDates();if(t&&t[0]&&t[0].getStartDate())this._oFocusedDate=i._createUniversalUTCDate(t[0].getStartDate(),void 0,!0);else{var e=new Date;this._oFocusedDate=i._createUniversalUTCDate(e,void 0,!0)}this._oFocusedDate.getTime()<this._oMinDate.getTime()?this._oFocusedDate=new h(this._oMinDate.getTime()):this._oFocusedDate.getTime()>this._oMaxDate.getTime()&&(this._oFocusedDate=new h(this._oMaxDate.getTime()))}function f(e){if(this._oPopup&&this._oPopup.isOpen()&&this._oPopup.close(),this._hideOverlay(),!e){v.call(this);var a=this.getAggregation(\"timesRow\");t(a._oItemNavigation.getItemDomRefs()[a._oItemNavigation.getFocusedIndex()]).attr(\"tabindex\",\"0\")}}function C(){3==this._iMode?I.call(this,!0):2==this._iMode&&P.call(this,!0);var e=this._getFocusedDate(),a=this._getItems(),s=this.getAggregation(\"datesRow\");s.getSelectedDates()[0].setStartDate(i._createLocalDate(e,!0));var o=new h(e.getTime());o.setUTCDate(1),o.setUTCMonth(o.getUTCMonth()+1),o.setUTCDate(0);var n=o.getUTCDate(),r=Math.floor(1.5*a);if(r>n&&(r=n),s.setDays(r),s.getDomRef())s.$().css(\"display\",\"\");else{var g=sap.ui.getCore().createRenderManager(),c=this.$(\"content\");g.renderControl(s),g.flush(c[0],!1,!0),g.destroy()}if(this._showOverlay(),z.call(this,e),0==this._iMode){var l=this.getAggregation(\"timesRow\");t(l._oItemNavigation.getItemDomRefs()[l._oItemNavigation.getFocusedIndex()]).attr(\"tabindex\",\"-1\")}this._iMode=1}function M(e){if(this._iMode=0,this.getAggregation(\"datesRow\").$().css(\"display\",\"none\"),this._hideOverlay(),!e){v.call(this);var a=this.getAggregation(\"timesRow\");t(a._oItemNavigation.getItemDomRefs()[a._oItemNavigation.getFocusedIndex()]).attr(\"tabindex\",\"0\")}}function U(){1==this._iMode?M.call(this,!0):3==this._iMode&&I.call(this,!0);var e=this._getFocusedDate(),a=this.getAggregation(\"monthPicker\");if(a.getDomRef())a.$().css(\"display\",\"\");else{var i=sap.ui.getCore().createRenderManager(),s=this.$(\"content\");i.renderControl(a),i.flush(s[0],!1,!0),i.destroy()}if(this._showOverlay(),a.setMonth(e.getUTCMonth()),G.call(this,e.getUTCFullYear(),a),0==this._iMode){var o=this.getAggregation(\"timesRow\");t(o._oItemNavigation.getItemDomRefs()[o._oItemNavigation.getFocusedIndex()]).attr(\"tabindex\",\"-1\")}this._iMode=2,k.call(this)}function P(e){if(this._iMode=0,this.getAggregation(\"monthPicker\").$().css(\"display\",\"none\"),this._hideOverlay(),!e){v.call(this);var a=this.getAggregation(\"timesRow\");t(a._oItemNavigation.getItemDomRefs()[a._oItemNavigation.getFocusedIndex()]).attr(\"tabindex\",\"0\")}}function y(){1==this._iMode?M.call(this,!0):2==this._iMode&&P.call(this,!0);var e=this._getFocusedDate(),a=this.getAggregation(\"yearPicker\");if(a.getDomRef())a.$().css(\"display\",\"\");else{var i=sap.ui.getCore().createRenderManager(),s=this.$(\"content\");i.renderControl(a),i.flush(s[0],!1,!0),i.destroy()}if(this._showOverlay(),a.setDate(e.getJSDate()),0==this._iMode){var o=this.getAggregation(\"timesRow\");t(o._oItemNavigation.getItemDomRefs()[o._oItemNavigation.getFocusedIndex()]).attr(\"tabindex\",\"-1\")}x.call(this),this._iMode=3}function I(e){if(this._iMode=0,this.getAggregation(\"yearPicker\").$().css(\"display\",\"none\"),this._hideOverlay(),!e){v.call(this);var a=this.getAggregation(\"timesRow\");t(a._oItemNavigation.getItemDomRefs()[a._oItemNavigation.getFocusedIndex()]).attr(\"tabindex\",\"0\")}}function w(){b.call(this),k.call(this,!0)}function k(t){var e=new h(m.call(this).getTime()),a=this._getItems(),i=e.getJSDate().getUTCFullYear(),s=this._oMaxDate.getJSDate().getUTCFullYear(),o=this._oMinDate.getJSDate().getUTCFullYear(),n=e.getJSDate().getUTCMonth(),r=this._oMaxDate.getJSDate().getUTCMonth(),g=this._oMinDate.getJSDate().getUTCMonth(),c=e.getJSDate().getUTCDate(),l=this._oMaxDate.getJSDate().getUTCDate(),u=this._oMinDate.getJSDate().getUTCDate(),D=e.getJSDate().getUTCHours(),d=this._oMaxDate.getJSDate().getUTCHours(),p=this._oMinDate.getJSDate().getUTCHours(),_=e.getJSDate().getUTCMinutes(),v=this._oMaxDate.getJSDate().getUTCMinutes(),T=this._oMinDate.getJSDate().getUTCMinutes(),f=this.getAggregation(\"header\");if(2==this._iMode&&!t){var C=this.getAggregation(\"monthPicker\"),M=C.getMonths(),U=C.getStartMonth(),P=U+M-1;return 0==U||i==o&&U<=g?f.setEnabledPrevious(!1):f.setEnabledPrevious(!0),void(P>10||i==s&&P>=r?f.setEnabledNext(!1):f.setEnabledNext(!0))}i<o||i==o&&(!t||n<g||n==g&&(c<u||c==u&&(D<p||D==p&&_<=T)))||(1==this._iMode||2==this._iMode)&&this.getPickerPopup()?f.setEnabledPrevious(!1):f.setEnabledPrevious(!0),e.setUTCMinutes(e.getUTCMinutes()+a*this.getIntervalMinutes()-1),i=e.getJSDate().getUTCFullYear(),n=e.getJSDate().getUTCMonth(),c=e.getJSDate().getUTCDate(),D=e.getJSDate().getUTCHours(),_=e.getJSDate().getUTCMinutes(),i>s||i==s&&(!t||n>r||n==r&&(c>l||c==l&&(D>d||D==d&&_>=v)))||(1==this._iMode||2==this._iMode)&&this.getPickerPopup()?f.setEnabledNext(!1):f.setEnabledNext(!0)}function x(){var t=this.getAggregation(\"yearPicker\"),e=t.getYears(),a=i._createUniversalUTCDate(t.getFirstRenderedDate());a.setUTCFullYear(a.getUTCFullYear()+Math.floor(e/2));var s=this.getAggregation(\"header\"),o=new h(this._oMaxDate);o.setUTCFullYear(o.getUTCFullYear()-Math.ceil(e/2)),o.setUTCMonth(11,31);var n=new h(this._oMinDate);n.setUTCFullYear(n.getUTCFullYear()+Math.floor(e/2)+1),n.setUTCMonth(0,1),a.getTime()>o.getTime()?s.setEnabledNext(!1):s.setEnabledNext(!0),a.getTime()<n.getTime()?s.setEnabledPrevious(!1):s.setEnabledPrevious(!0)}function b(){var t,e,a,s,o=this.getAggregation(\"header\"),n=m.call(this),r=this._getLocaleData(),g=[],h=[],c=!1,u=W.Gregorian;s=\"ja\"===r.oLocale.sLanguage.toLowerCase()||\"zh\"===r.oLocale.sLanguage.toLowerCase()?l.getDateInstance({format:\"d\"}).format(n,!0):n.getUTCDate().toString(),this._bLongMonth||!this._bNamesLengthChecked?g=r.getMonthsStandAlone(\"wide\"):(c=!0,g=r.getMonthsStandAlone(\"abbreviated\"),h=r.getMonthsStandAlone(\"wide\"));var D=n.getUTCMonth();t=g[D],c&&(a=h[g[D]]),this.getPickerPopup()?(e=l.getInstance({style:\"long\",strictParsing:!0,relative:!1,calendarType:u},r.oLocale),a=s=e.format(i._createLocalDate(n,!0)),o.setTextButton1(s)):(o.setTextButton0(s),o.setTextButton1(t),o.setTextButton2(this._oYearFormat.format(n,!0))),c&&o.setAriaLabelButton1(a)}function F(t,e){var a,i=!1;t.getTime()<this._oMinDate.getTime()?(a=this._oMinDate,i=!0):t.getTime()>this._oMaxDate.getTime()?(a=this._oMaxDate,i=!0):a=t,this._setFocusedDate(a),(i||e)&&($.call(this,a),v.call(this,!1),this.fireStartDateChange())}function R(t,e){if(t&&(!this._oFocusedDate||this._oFocusedDate.getTime()!=t.getTime())){i._checkJSDateObject(t),t=i._createUniversalUTCDate(t,void 0,!0);var a=t.getUTCFullYear();if(i._checkYearInValidRange(a),t.getTime()<this._oMinDate.getTime()||t.getTime()>this._oMaxDate.getTime())throw new Error(\"Date must not be in valid range (minDate and maxDate); \"+this);this._setFocusedDate(t),this.getDomRef()&&0==this._iMode&&v.call(this,e)}}function A(t){1!=this._iMode?C.call(this):M.call(this)}function S(t){this.getPickerPopup()?this._showCalendarPicker():2!=this._iMode?U.call(this):P.call(this)}function N(t){3!=this._iMode?y.call(this):I.call(this)}function Y(t){this.fireSelect()}function L(t){var e=i._createUniversalUTCDate(t.getParameter(\"date\"),void 0,!0),a=t.getParameter(\"notVisible\");F.call(this,e,a)}function E(t){var e=t.getSource(),a=e.getSelectedDates()[0].getStartDate(),s=new h(this._getFocusedDate().getTime()),o=i._createUniversalUTCDate(a);s.setUTCDate(o.getUTCDate()),s.setUTCMonth(o.getUTCMonth()),s.setUTCFullYear(o.getUTCFullYear()),F.call(this,s,!0),f.call(this)}function B(t){var e=new h(this._getFocusedDate().getTime()),a=t.oSource,s=a.getSelectedDates()[0],o=i._createUniversalUTCDate(s.getStartDate());this.getPickerPopup()&&o.getUTCMonth()!=e.getUTCMonth()||(e.setUTCDate(o.getUTCDate()),e.setUTCMonth(o.getUTCMonth()),e.setUTCFullYear(o.getUTCFullYear()),F.call(this,e,!0),M.call(this))}function J(t){var e=new h(this._getFocusedDate().getTime()),a=i._createUniversalUTCDate(t.getParameter(\"date\"),void 0,!0);t.getParameter(\"otherMonth\")&&a.getUTCMonth()==e.getUTCMonth()&&a.getUTCFullYear()==e.getUTCFullYear()&&z.call(this,a)}function O(t){var e=new h(this._getFocusedDate().getTime()),a=this.getAggregation(\"monthPicker\"),i=a.getMonth();e.setUTCMonth(i),i!=e.getUTCMonth()&&e.setUTCDate(0),F.call(this,e,!0),P.call(this)}function V(t){var e=new h(this._getFocusedDate().getTime()),a=this.getAggregation(\"yearPicker\"),s=i._createUniversalUTCDate(a.getDate()),o=e.getUTCMonth();s.setUTCMonth(e.getUTCMonth(),e.getUTCDate()),s.setUTCHours(e.getUTCHours()),s.setUTCMinutes(e.getUTCMinutes()),e=s,o!=e.getUTCMonth()&&e.setUTCDate(0),F.call(this,e,!0),I.call(this)}function H(){this._sInvalidateContent=void 0;var t=this.getAggregation(\"timesRow\");t._bDateRangeChanged=!0,t._bInvalidateSync=!0,t.invalidate(),t._bInvalidateSync=void 0,this._bDateRangeChanged=void 0}function $(t){var e=this.getAggregation(\"timesRow\"),a=m.call(this),i=e._oItemNavigation.getFocusedIndex();a=new h(t.getTime()),a.setUTCMinutes(a.getUTCMinutes()-i*this.getIntervalMinutes()),_.call(this,a,!1,!0)}function z(t){var e=this.getAggregation(\"datesRow\"),a=this.getAggregation(\"header\");if(this.getPickerPopup())a.setEnabledPrevious(!1),a.setEnabledNext(!1);else{var s=new h(t.getTime());s.setUTCDate(1),s.setUTCMonth(s.getUTCMonth()+1),s.setUTCDate(0);var o=e.getDays(),n=new h(t.getTime());n.setUTCDate(1+(Math.ceil(t.getUTCDate()/o)-1)*o),s.getUTCDate()-n.getUTCDate()<o&&n.setUTCDate(s.getUTCDate()-o+1),e.setStartDate(i._createLocalDate(n,!0));var r=n.getJSDate().getUTCFullYear(),g=this._oMaxDate.getJSDate().getUTCFullYear(),c=this._oMinDate.getJSDate().getUTCFullYear(),l=n.getJSDate().getUTCMonth(),u=this._oMaxDate.getJSDate().getUTCMonth(),D=this._oMinDate.getJSDate().getUTCMonth(),d=n.getJSDate().getUTCDate(),p=this._oMaxDate.getJSDate().getUTCDate(),_=this._oMinDate.getJSDate().getUTCDate();d<=1||r==c&&l==D&&d<=_?a.setEnabledPrevious(!1):a.setEnabledPrevious(!0),d+o>=s.getUTCDate()||r==g&&l==u&&d>=p?a.setEnabledNext(!1):a.setEnabledNext(!0)}e.setDate(i._createLocalDate(t,!0))}function j(e){this._oPopup||(t.sap.require(\"sap.ui.core.Popup\"),this._oPopup=new sap.ui.core.Popup,this._oPopup.setAutoClose(!0),this._oPopup.setAutoCloseAreas([this.getDomRef()]),this._oPopup.setDurations(0,0),this._oPopup._oCalendar=this,this._oPopup.attachClosed(q,this),this._oPopup.onsapescape=function(t){this._oCalendar.onsapescape(t)}),this._oPopup.setContent(e);var a=this.getAggregation(\"header\"),i=sap.ui.core.Popup.Dock;this._oPopup.open(0,i.CenterTop,i.CenterTop,a,null,\"flipfit\",!0)}function q(t){f.call(this)}function G(t,e){var a=0,i=11;t==this._oMinDate.getUTCFullYear()&&(a=this._oMinDate.getUTCMonth()),t==this._oMaxDate.getUTCFullYear()&&(i=this._oMaxDate.getUTCMonth()),e.setMinMax(a,i)}function K(t){k.call(this)}function Q(t){x.call(this)}var W=d.CalendarType,X=e.extend(\"sap.ui.unified.CalendarTimeInterval\",{metadata:{library:\"sap.ui.unified\",properties:{width:{type:\"sap.ui.core.CSSSize\",group:\"Dimension\",defaultValue:null},startDate:{type:\"object\",group:\"Data\"},intervalSelection:{type:\"boolean\",group:\"Behavior\",defaultValue:!1},singleSelection:{type:\"boolean\",group:\"Behavior\",defaultValue:!0},items:{type:\"int\",group:\"Appearance\",defaultValue:12},intervalMinutes:{type:\"int\",group:\"Appearance\",defaultValue:60},pickerPopup:{type:\"boolean\",group:\"Appearance\",defaultValue:!1},minDate:{type:\"object\",group:\"Misc\",defaultValue:null},maxDate:{type:\"object\",group:\"Misc\",defaultValue:null}},aggregations:{selectedDates:{type:\"sap.ui.unified.DateRange\",multiple:!0,singularName:\"selectedDate\"},specialDates:{type:\"sap.ui.unified.DateTypeRange\",multiple:!0,singularName:\"specialDate\"},header:{type:\"sap.ui.unified.calendar.Header\",multiple:!1,visibility:\"hidden\"},timesRow:{type:\"sap.ui.unified.calendar.TimesRow\",multiple:!1,visibility:\"hidden\"},datesRow:{type:\"sap.ui.unified.calendar.Month\",multiple:!1,visibility:\"hidden\"},monthPicker:{type:\"sap.ui.unified.calendar.MonthPicker\",multiple:!1,visibility:\"hidden\"},yearPicker:{type:\"sap.ui.unified.calendar.YearPicker\",multiple:!1,visibility:\"hidden\"},calendarPicker:{type:\"sap.ui.unified.Calendar\",multiple:!1,visibility:\"hidden\"}},associations:{ariaLabelledBy:{type:\"sap.ui.core.Control\",multiple:!0,singularName:\"ariaLabelledBy\"},legend:{type:\"sap.ui.unified.CalendarLegend\",multiple:!1}},events:{select:{},cancel:{},startDateChange:{}}}});return X.prototype.init=function(){this._iMode=0,this._oYearFormat=l.getDateInstance({format:\"y\"}),this.data(\"sap-ui-fastnavgroup\",\"true\",!0),this._oMinDate=new h(new Date(Date.UTC(1,0,1))),this._oMinDate.getJSDate().setUTCFullYear(1),this._oMaxDate=new h(new Date(Date.UTC(9999,11,31,23,59,59))),this._initializeHeader(),this._initializeTimesRow(),this._initilizeMonthPicker(),this._initilizeYearPicker(),this.setPickerPopup(!1),this._iItemsHead=15},X.prototype._initializeHeader=function(){var t=new s(this.getId()+\"--Head\");t.attachEvent(\"pressPrevious\",this._handlePrevious,this),t.attachEvent(\"pressNext\",this._handleNext,this),this.setAggregation(\"header\",t)},X.prototype._initializeTimesRow=function(){var t=new o(this.getId()+\"--TimesRow\");t.attachEvent(\"focus\",L,this),t.attachEvent(\"select\",Y,this),t._bNoThemeChange=!0,this.setAggregation(\"timesRow\",t)},X.prototype._initilizeMonthPicker=function(){this.setAggregation(\"monthPicker\",this._createMonthPicker())},X.prototype._initilizeYearPicker=function(){this.setAggregation(\"yearPicker\",this._createYearPicker())},X.prototype._createDatesRow=function(){var t=new n(this.getId()+\"--DatesRow\",{days:18,selectedDates:[new sap.ui.unified.DateRange(this.getId()+\"--Range\")]});return t.attachEvent(\"focus\",J,this),t.attachEvent(\"select\",B,this),t._bNoThemeChange=!0,t.getIntervalSelection=function(){return this.getProperty(\"intervalSelection\")},t.getSingleSelection=function(){return this.getProperty(\"singleSelection\")},t.getSelectedDates=function(){return this.getAggregation(\"selectedDates\",[])},t.getSpecialDates=function(){return this.getAggregation(\"specialDates\",[])},t.getAriaLabelledBy=function(){return this.getAssociation(\"ariaLabelledBy\",[])},t},X.prototype._createMonthPicker=function(){var t=new r(this.getId()+\"--MP\",{columns:0,months:6});return t.attachEvent(\"select\",O,this),t._bNoThemeChange=!0,t.attachEvent(\"pageChange\",K,this),t},X.prototype._createYearPicker=function(){var t=new g(this.getId()+\"--YP\",{columns:0,years:6});return t.attachEvent(\"select\",V,this),t.attachEvent(\"pageChange\",Q,this),t._oMinDate.setYear(this._oMinDate.getUTCFullYear()),t._oMaxDate.setYear(this._oMaxDate.getUTCFullYear()),t},X.prototype.exit=function(){this._sInvalidateContent&&t.sap.clearDelayedCall(this._sInvalidateContent)},X.prototype.onBeforeRendering=function(){var t=this.getAggregation(\"timesRow\"),e=this._getFocusedDate();w.call(this),t.displayDate(i._createLocalDate(e,!0))},X.prototype._getCalendarPicker=function(){var t=this.getAggregation(\"calendarPicker\");return t||(t=new sap.ui.unified.Calendar(this.getId()+\"--Cal\",{}),t.setPopupMode(!0),t.attachEvent(\"select\",E,this),t.attachEvent(\"cancel\",function(t){this._oPopup.close()},this),this.setAggregation(\"calendarPicker\",t)),t},X.prototype.setStartDate=function(e){if(i._checkJSDateObject(e),t.sap.equal(this.getStartDate(),e))return this;var a=e.getFullYear();i._checkYearInValidRange(a);var s=this.getMinDate();s&&e.getTime()<s.getTime()&&(t.sap.log.warning(\"startDate < minDate -> minDate as startDate set\",this),e=new Date(s));var o=this.getMaxDate();o&&e.getTime()>o.getTime()&&(t.sap.log.warning(\"startDate > maxDate -> maxDate as startDate set\",this),e=new Date(o)),this.setProperty(\"startDate\",e,!0);var n=this.getAggregation(\"timesRow\");n.setStartDate(e),this._oUTCStartDate=new h(n._getStartDate().getTime()),w.call(this);var r=i._createLocalDate(this._getFocusedDate(),!0);return n.checkDateFocusable(r)||(this._setFocusedDate(this._oUTCStartDate),n.displayDate(e)),this},X.prototype.invalidate=function(a){this._bDateRangeChanged||a&&a instanceof sap.ui.unified.DateRange?this.getDomRef()&&0==this._iMode&&!this._sInvalidateContent&&(this._sInvalidateContent=t.sap.delayedCall(0,this,H)):a&&(a instanceof n||a instanceof r||a instanceof g||a instanceof s)||e.prototype.invalidate.apply(this,arguments)},X.prototype.removeAllSelectedDates=function(){return this._bDateRangeChanged=!0,this.removeAllAggregation(\"selectedDates\")},X.prototype.destroySelectedDates=function(){return this._bDateRangeChanged=!0,this.destroyAggregation(\"selectedDates\")},X.prototype.removeAllSpecialDates=function(){return this._bDateRangeChanged=!0,this.removeAllAggregation(\"specialDates\")},X.prototype.destroySpecialDates=function(){return this._bDateRangeChanged=!0,this.destroyAggregation(\"specialDates\")},X.prototype.setIntervalMinutes=function(t){if(t>=720)throw new Error(\"Only intervals < 720 minutes are allowed; \"+this);if(1440%t>0)throw new Error(\"A day must be divisible by the interval size; \"+this);this.setProperty(\"intervalMinutes\",t,!1);var e=this.getAggregation(\"timesRow\"),a=i._createLocalDate(this._getFocusedDate(),!0);if(!e.checkDateFocusable(a)){var s=m.call(this);this._setFocusedDate(s),e.setDate(i._createLocalDate(s,!0))}return this},X.prototype.setLocale=function(t){return this._sLocale!=t&&(this._sLocale=t,this._oLocaleData=void 0,this.invalidate()),this},X.prototype.getLocale=function(){return this._sLocale||(this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString()),this._sLocale},X.prototype._getFocusedDate=function(){return this._oFocusedDate||T.call(this),this._oFocusedDate},X.prototype._setFocusedDate=function(t){if(!(t instanceof h))throw new Error(\"Date must be a UniversalDate object \"+this);this._oFocusedDate=new h(t.getTime())},X.prototype.focusDate=function(t){var e=!1;if(!this.getAggregation(\"timesRow\").checkDateFocusable(t)){var a=i._createUniversalUTCDate(t,void 0,!0);$.call(this,a),e=!0}return R.call(this,t,!1),e&&this.fireStartDateChange(),this},X.prototype.displayDate=function(t){return R.call(this,t,!0),this},X.prototype.setItems=function(t){this.setProperty(\"items\",t,!0),t=this._getItems();var e=this.getAggregation(\"timesRow\");e.setItems(t);var a=i._createLocalDate(this._getFocusedDate(),!0);if(!e.checkDateFocusable(a)){var s=m.call(this);this._setFocusedDate(s),e.setDate(i._createLocalDate(s,!0))}if(!this.getPickerPopup()){var o=this.getAggregation(\"datesRow\"),n=Math.floor(1.5*t);n>31&&(n=31),o.setDays(n);var r=this.getAggregation(\"monthPicker\"),g=Math.floor(t/2);g>12&&(g=12),r.setMonths(g);var h=this.getAggregation(\"yearPicker\"),c=Math.floor(t/2);c>20&&(c=20),h.setYears(c)}return w.call(this),this.getDomRef()&&(this._getShowItemHeader()?this.$().addClass(\"sapUiCalIntHead\"):this.$().removeClass(\"sapUiCalIntHead\")),this},X.prototype._getItems=function(){var t=this.getItems();return u.system.phone&&t>6?6:t},X.prototype._getLocaleData=function(){if(!this._oLocaleData){var t=this.getLocale(),e=new D(t);this._oLocaleData=a.getInstance(e)}return this._oLocaleData},X.prototype.setPickerPopup=function(t){var e,a,i,s=this.getAggregation(\"header\");return this.setProperty(\"pickerPopup\",t,!0),e&&e.destroy(),t?(s.setVisibleButton0(!1),s.setVisibleButton1(!0),s.setVisibleButton2(!1),s.detachEvent(\"pressButton1\",S,this),s.attachEvent(\"pressButton1\",S,this),this.getAggregation(\"datesRow\")&&this.getAggregation(\"datesRow\").destroy(),this.getAggregation(\"monthPicker\")&&this.getAggregation(\"monthPicker\").destroy(),this.getAggregation(\"yearPicker\")&&this.getAggregation(\"yearPicker\").destroy()):(s.setVisibleButton0(!0),s.setVisibleButton1(!0),s.setVisibleButton2(!0),s.detachEvent(\"pressButton0\",A,this),s.attachEvent(\"pressButton0\",A,this),s.detachEvent(\"pressButton1\",S,this),s.attachEvent(\"pressButton1\",S,this),s.detachEvent(\"pressButton2\",N,this),s.attachEvent(\"pressButton2\",N,this),this.getAggregation(\"datesRow\")||this.setAggregation(\"datesRow\",this._createDatesRow()),this.getAggregation(\"yearPicker\")||this.setAggregation(\"yearPicker\",this._createYearPicker()),this.getAggregation(\"monthPicker\")||this.setAggregation(\"monthPicker\",this._createMonthPicker()),a=this.getAggregation(\"monthPicker\"),i=this.getAggregation(\"yearPicker\"),a.setColumns(0),a.setMonths(6),i.setColumns(0),i.setYears(6)),this},X.prototype.setMinDate=function(e){var a,s,o,n;return t.sap.equal(e,this.getMinDate())?this:(e?(i._checkJSDateObject(e),this._oMinDate=i._createUniversalUTCDate(e,void 0,!0),a=this.getAggregation(\"timesRow\"),this._oMinDate=a._getIntervalStart(this._oMinDate),s=this._oMinDate.getUTCFullYear(),i._checkYearInValidRange(s),this._oMaxDate.getTime()<this._oMinDate.getTime()&&(t.sap.log.warning(\"minDate > maxDate -> maxDate set to end of the month\",this),this._oMaxDate=i._createUniversalUTCDate(e,void 0,!0),i._updateUTCDate(this._oMaxDate,null,this._oMaxDate.getUTCMonth()+1,0,23,59,59,0),this.setProperty(\"maxDate\",i._createLocalDate(this._oMaxDate,!0),!0)),this._oFocusedDate&&this._oFocusedDate.getTime()<this._oMinDate.getTime()&&(t.sap.log.warning(\"focused date < minDate -> minDate focused\",this),this.focusDate(e)),this._oUTCStartDate&&this._oUTCStartDate.getTime()<this._oMinDate.getTime()&&(t.sap.log.warning(\"start date < minDate -> minDate set as start date\",this),_.call(this,new h(this._oMinDate.getTime()),!0,!0))):i._updateUTCDate(this._oMinDate.getJSDate(),1,0,1,0,0,0,0),this.setProperty(\"minDate\",e,!1),this.getPickerPopup()?(n=this._getCalendarPicker(),n.setMinDate(e)):(o=this.getAggregation(\"yearPicker\"),o._oMinDate.setYear(this._oMinDate.getUTCFullYear())),this)},X.prototype.setMaxDate=function(e){var a,s,o,n,r,g;return t.sap.equal(e,this.getMaxDate())?this:(e?(i._checkJSDateObject(e),this._oMaxDate=i._createUniversalUTCDate(e,void 0,!0),a=this.getAggregation(\"timesRow\"),this._oMaxDate=a._getIntervalStart(this._oMaxDate),this._oMaxDate.setUTCMinutes(this._oMaxDate.getUTCMinutes()+this.getIntervalMinutes()),this._oMaxDate.setUTCMilliseconds(-1),s=this._oMaxDate.getUTCFullYear(),i._checkYearInValidRange(s),this._oMinDate.getTime()>this._oMaxDate.getTime()&&(t.sap.log.warning(\"maxDate < minDate -> minDate set to begin of the month\",this),this._oMinDate=i._createUniversalUTCDate(e,void 0,!0),i._updateUTCDate(this._oMinDate,null,null,1,0,0,0,0),this.setProperty(\"minDate\",i._createLocalDate(this._oMinDate,!0),!0)),this._oFocusedDate&&this._oFocusedDate.getTime()>this._oMaxDate.getTime()&&(t.sap.log.warning(\"focused date > maxDate -> maxDate focused\",this),this.focusDate(e)),this._oUTCStartDate&&(o=new h(this._oUTCStartDate.getTime()),o.setUTCMinutes(o.getUTCMinutes()+this.getIntervalMinutes()*(this._getItems()-1)),o.getTime()>this._oMaxDate.getTime()&&(n=new h(this._oMaxDate.getTime()),n.setUTCMinutes(n.getUTCMinutes()-this.getIntervalMinutes()*(this._getItems()-1)),n.getTime()>=this._oMinDate.getTime()&&(t.sap.log.warning(\"end date > maxDate -> maxDate set as end date\",this),_.call(this,n,!0,!0))))):i._updateUTCDate(this._oMaxDate.getJSDate(),9999,11,31,23,59,59,0),this.setProperty(\"maxDate\",e,!1),this.getPickerPopup()?(g=this._getCalendarPicker(),g.setMaxDate(e)):(r=this.getAggregation(\"yearPicker\"),r._oMaxDate.setYear(this._oMaxDate.getUTCFullYear())),this)},X.prototype.onclick=function(t){t.isMarked(\"delayedMouseEvent\")||t.target.id==this.getId()+\"-cancel\"&&this.onsapescape(t)},X.prototype.onmousedown=function(t){t.preventDefault(),t.setMark(\"cancelAutoClose\")},X.prototype.onsapescape=function(t){if(this.getPickerPopup())f.call(this),this.fireCancel();else switch(this._iMode){case 0:this.fireCancel();break;case 1:M.call(this);break;case 2:P.call(this);break;case 3:I.call(this)}},X.prototype.onsaptabnext=function(e){var a,i,s,o=this.getAggregation(\"header\");t.sap.containsOrEquals(this.getDomRef(\"content\"),e.target)?(this.getPickerPopup()?t.sap.focus(o.getDomRef(\"B1\")):t.sap.focus(o.getDomRef(\"B0\")),this._bPoupupMode||(s=this.getAggregation(\"timesRow\"),t(s._oItemNavigation.getItemDomRefs()[s._oItemNavigation.getFocusedIndex()]).attr(\"tabindex\",\"-1\"),this.getPickerPopup()||(a=this.getAggregation(\"monthPicker\"),i=this.getAggregation(\"yearPicker\"),a.getDomRef()&&t(a._oItemNavigation.getItemDomRefs()[a._oItemNavigation.getFocusedIndex()]).attr(\"tabindex\",\"-1\"),i.getDomRef()&&t(i._oItemNavigation.getItemDomRefs()[i._oItemNavigation.getFocusedIndex()]).attr(\"tabindex\",\"-1\"))),e.preventDefault()):e.target.id==o.getId()+\"-B0\"?(t.sap.focus(o.getDomRef(\"B1\")),e.preventDefault()):this.getPickerPopup()||e.target.id!=o.getId()+\"-B1\"||(t.sap.focus(o.getDomRef(\"B2\")),e.preventDefault())},X.prototype.onsaptabprevious=function(e){var a,i,s,o=this.getAggregation(\"header\");if(t.sap.containsOrEquals(this.getDomRef(\"content\"),e.target))this._bPoupupMode&&(t.sap.focus(o.getDomRef(\"B2\")),e.preventDefault());else if(e.target.id==o.getId()+\"-B0\"){switch(s=this.getAggregation(\"timesRow\"),this._iMode){case 0:s._oItemNavigation.focusItem(s._oItemNavigation.getFocusedIndex());break;case 2:this.getPickerPopup()||(a=this.getAggregation(\"monthPicker\"),a._oItemNavigation.focusItem(a._oItemNavigation.getFocusedIndex()));break;case 3:this.getPickerPopup()||(i=this.getAggregation(\"yearPicker\"),i._oItemNavigation.focusItem(i._oItemNavigation.getFocusedIndex()))}e.preventDefault()}else e.target.id==o.getId()+\"-B2\"?(t.sap.focus(o.getDomRef(\"B1\")),e.preventDefault()):e.target.id==o.getId()+\"-B1\"&&(this.getPickerPopup()?(s=this.getAggregation(\"timesRow\"),s._oItemNavigation.focusItem(s._oItemNavigation.getFocusedIndex())):t.sap.focus(o.getDomRef(\"B0\")),e.preventDefault())},X.prototype.onfocusin=function(e){if(e.target.id==this.getId()+\"-end\"){var a,i,s,o=this.getAggregation(\"header\");this.getPickerPopup()?t.sap.focus(o.getDomRef(\"B1\")):t.sap.focus(o.getDomRef(\"B2\")),this._bPoupupMode||(a=this.getAggregation(\"timesRow\"),t(a._oItemNavigation.getItemDomRefs()[a._oItemNavigation.getFocusedIndex()]).attr(\"tabindex\",\"-1\"),this.getPickerPopup()||(i=this.getAggregation(\"monthPicker\"),s=this.getAggregation(\"yearPicker\"),i.getDomRef()&&t(i._oItemNavigation.getItemDomRefs()[i._oItemNavigation.getFocusedIndex()]).attr(\"tabindex\",\"-1\"),s.getDomRef()&&t(s._oItemNavigation.getItemDomRefs()[s._oItemNavigation.getFocusedIndex()]).attr(\"tabindex\",\"-1\")))}this.$(\"end\").attr(\"tabindex\",\"-1\")},X.prototype.onsapfocusleave=function(e){if(!(e.relatedControlId&&t.sap.containsOrEquals(this.getDomRef(),sap.ui.getCore().byId(e.relatedControlId).getFocusDomRef())||(this.$(\"end\").attr(\"tabindex\",\"0\"),this._bPoupupMode))){var a,i,s;switch(this._iMode){case 0:a=this.getAggregation(\"timesRow\"),t(a._oItemNavigation.getItemDomRefs()[a._oItemNavigation.getFocusedIndex()]).attr(\"tabindex\",\"0\");break;case 2:this.getPickerPopup()||(i=this.getAggregation(\"monthPicker\"),t(i._oItemNavigation.getItemDomRefs()[i._oItemNavigation.getFocusedIndex()]).attr(\"tabindex\",\"0\"));break;case 3:this.getPickerPopup()||(s=this.getAggregation(\"yearPicker\"),t(s._oItemNavigation.getItemDomRefs()[s._oItemNavigation.getFocusedIndex()]).attr(\"tabindex\",\"0\"))}}},X.prototype._handlePrevious=function(t){var e,a,s,o,n,r,g,c,l=this._getFocusedDate();switch(this._iMode){case 0:e=this._getItems(),a=new h(m.call(this).getTime()),s=this.getIntervalMinutes(),a.setUTCMinutes(a.getUTCMinutes()-e*s),l.setUTCMinutes(l.getUTCMinutes()-e*s),this._setFocusedDate(l),_.call(this,a,!0);break;case 1:this.getPickerPopup()||(o=this.getAggregation(\"datesRow\"),n=i._createUniversalUTCDate(o.getDate()),r=o.getDays(),n.getUTCDate()<=r?n.setUTCDate(1):n.setUTCDate(n.getUTCDate()-r),z.call(this,n));break;case 2:this.getPickerPopup()||(g=this.getAggregation(\"monthPicker\"),g.getMonths()<12?(g.previousPage(),k.call(this)):(l.setUTCFullYear(l.getUTCFullYear()-1),$.call(this,l),this._setFocusedDate(l),w.call(this),G.call(this,l.getUTCFullYear(),g),this.fireStartDateChange()));break;case 3:this.getPickerPopup()||(c=this.getAggregation(\"yearPicker\"),c.previousPage(),x.call(this))}},X.prototype._handleNext=function(t){var e=this._getFocusedDate();switch(this._iMode){case 0:var a=this._getItems(),s=new h(m.call(this).getTime()),o=this.getIntervalMinutes();s.setUTCMinutes(s.getUTCMinutes()+a*o),e.setUTCMinutes(e.getUTCMinutes()+a*o),this._setFocusedDate(e),_.call(this,s,!0);break;case 1:if(!this.getPickerPopup()){var n=this.getAggregation(\"datesRow\"),r=i._createUniversalUTCDate(n.getDate()),g=new h(r.getTime());g.setUTCDate(1),g.setUTCMonth(g.getUTCMonth()+1),g.setUTCDate(0);var c=n.getDays();r.getUTCDate()+c>g.getUTCDate()?r.setUTCDate(g.getUTCDate()):r.setUTCDate(r.getUTCDate()+c),z.call(this,r)}break;case 2:if(!this.getPickerPopup()){var l=this.getAggregation(\"monthPicker\");l.getMonths()<12?(l.nextPage(),k.call(this)):(e.setUTCFullYear(e.getUTCFullYear()+1),$.call(this,e),this._setFocusedDate(e),w.call(this),G.call(this,e.getUTCFullYear(),l),this.fireStartDateChange())}break;case 3:if(!this.getPickerPopup()){this.getAggregation(\"yearPicker\").nextPage(),x.call(this)}}},X.prototype._getShowItemHeader=function(){return this.getItems()>this._iItemsHead},X.prototype._showCalendarPicker=function(){var t=i._createLocalDate(this._getFocusedDate(),!0),e=this._getCalendarPicker(),a=new sap.ui.unified.DateRange({startDate:t});e.displayDate(t,!1),e.removeAllSelectedDates(),e.addSelectedDate(a),e.setMinDate(this.getMinDate()),e.setMaxDate(this.getMaxDate()),j.call(this,e),this._showOverlay()},X.prototype._showOverlay=function(){this.$(\"contentOver\").css(\"display\",\"\")},X.prototype._hideOverlay=function(){this.$(\"contentOver\").css(\"display\",\"none\")},X});",
	"sap/ui/unified/CalendarTimeIntervalRenderer.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([],function(){\"use strict\";var e={};return e.render=function(e,t){t._iMode=0;var i=t.getId(),a=t.getTooltip_AsString(),r=t.getAggregation(\"timesRow\");e.write(\"<div\"),e.writeControlData(t),e.addClass(\"sapUiCal\"),e.addClass(\"sapUiCalInt\"),e.addClass(\"sapUiCalTimeInt\"),t._getShowItemHeader()&&e.addClass(\"sapUiCalIntHead\"),t.getPickerPopup()&&e.addClass(\"sapUiCalIntLarge\"),e.writeAttribute(\"tabindex\",\"-1\");var d=sap.ui.getCore().getLibraryResourceBundle(\"sap.ui.unified\"),s={labelledby:{value:\"\",append:!1}};t._bPoupupMode&&(s.role=\"dialog\"),e.writeAccessibilityState(t,s),a&&e.writeAttributeEscaped(\"title\",a);var n=t.getWidth();n&&\"\"!=n&&(e.addStyle(\"width\",n),e.writeStyles()),e.writeClasses(),e.write(\">\");var l=t.getAggregation(\"header\");e.renderControl(l),e.write('<div id=\"'+i+'-content\" class=\"sapUiCalContent\">'),e.renderControl(r),e.write(\"</div>\"),e.write('<button id=\"'+i+'-cancel\" class=\"sapUiCalCancel\" tabindex=\"-1\">'),e.write(d.getText(\"CALENDAR_CANCEL\")),e.write(\"</button>\"),e.write('<div id=\"'+i+'-end\" tabindex=\"0\" style=\"width:0;height:0;position:absolute;right:0;bottom:0;\"></div>'),t.getPickerPopup()&&e.write('<div id=\"'+i+'-contentOver\" class=\"sapUiCalContentOver\" style=\"display:none;\"></div>'),e.write(\"</div>\")},e},!0);",
	"sap/ui/unified/CalendarWeekInterval.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"sap/ui/unified/calendar/CalendarUtils\",\"sap/ui/unified/calendar/CalendarDate\",\"./library\",\"sap/ui/unified/CalendarDateInterval\",\"sap/ui/unified/CalendarDateIntervalRenderer\"],function(e,t,a,s,o){\"use strict\";var i=s.extend(\"sap.ui.unified.CalendarWeekInterval\",{renderer:o});return i.prototype._getDaysLarge=function(){return 6},i.prototype._handleFocus=function(a){var o,i,r,n=!!a.getParameter(\"_outsideBorder\");return n&&(o=a.getParameter(\"date\"),this._oFocusDateWeek=t.fromLocalJSDate(o),i=e._getFirstDateOfWeek(this._oFocusDateWeek),r=this.getAggregation(\"month\")[0],r.getDomRef()&&this._setStartDate(i,!1,!0)),s.prototype._handleFocus.apply(this,arguments)},i.prototype._focusDateExtend=function(e,t,a){var o,i;return this._oFocusDateWeek?(o=this.getAggregation(\"month\")[0],i=this._oFocusDateWeek.toLocalJSDate(),this._setFocusedDate(this._oFocusDateWeek),o.setDate(i),this._oFocusDateWeek=null,!a):s.prototype._focusDateExtend.apply(this,arguments)},i.prototype._dateMatchesVisibleRange=function(e){var a=this.getDays(),s=t.fromLocalJSDate(e),o=t.fromLocalJSDate(this.getStartDate()),i=t.fromLocalJSDate(this.getStartDate());return i.setDate(i.getDate()+a),s.isSameOrAfter(o)&&s.isBefore(i)},i.prototype._showCalendarPicker=function(){var e,a=this._getFocusedDate(),s=this._getStartDate(),o=this._getCalendarPicker(),i=new sap.ui.unified.DateRange;e=new t(s),e.setDate(e.getDate()+this._getDays()-1),i.setStartDate(s.toLocalJSDate()),i.setEndDate(e.toLocalJSDate()),o.displayDate(a.toLocalJSDate(),!1),o.removeAllSelectedDates(),o.addSelectedDate(i),o.setMinDate(this.getMinDate()),o.setMaxDate(this.getMaxDate()),this._openPickerPopup(o),this._showOverlay()},i.prototype._handleCalendarPickerDateSelect=function(t){var a,s=this._getCalendarPicker(),o=s._getFocusedDate();this._dateMatchesVisibleRange(o.toLocalJSDate())?(this._oFocusDateWeek=s._getFocusedDate(),this._focusDate(this._oFocusDateWeek,!1,!0)):(a=e._getFirstDateOfWeek(o),this._setStartDate(a),this._oFocusDateWeek=s._getFocusedDate(),this._focusDate(this._oFocusDateWeek,!1,!0)),this._closeCalendarPicker(!0)},i});",
	"sap/ui/unified/ColorPicker.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"./library\",\"sap/ui/core/Control\",\"sap/ui/core/HTML\",\"sap/ui/core/ResizeHandler\",\"sap/ui/layout/Grid\",\"sap/ui/layout/GridData\",\"sap/ui/layout/VerticalLayout\",\"sap/ui/layout/HorizontalLayout\",\"sap/ui/core/Icon\",\"sap/ui/core/theming/Parameters\",\"sap/ui/core/InvisibleText\",\"sap/ui/Device\",\"sap/ui/core/library\",\"./ColorPickerRenderer\",\"sap/ui/Global\"],function(e,t,o,s,i,a,r,l,h,n,d,u,C,p,c){\"use strict\";var g=p.ValueState,f=t.ColorPickerMode,S=o.extend(\"sap.ui.unified.ColorPicker\",{metadata:{library:\"sap.ui.unified\",properties:{colorString:{type:\"string\",group:\"Misc\",defaultValue:null},mode:{type:\"sap.ui.unified.ColorPickerMode\",group:\"Appearance\",defaultValue:f.HSV}},aggregations:{_grid:{type:\"sap.ui.layout.Grid\",group:\"Appearance\",multiple:!1,visibility:\"hidden\"},_invisibleTexts:{type:\"sap.ui.core.InvisibleText\",multiple:!0,visibility:\"hidden\"}},events:{change:{parameters:{r:{type:\"int\"},g:{type:\"int\"},b:{type:\"int\"},h:{type:\"int\"},s:{type:\"int\"},v:{type:\"int\"},l:{type:\"int\"},hex:{type:\"string\"},alpha:{type:\"string\"}}},liveChange:{parameters:{r:{type:\"int\"},g:{type:\"int\"},b:{type:\"int\"},h:{type:\"int\"},s:{type:\"int\"},v:{type:\"int\"},l:{type:\"int\"},hex:{type:\"string\"},alpha:{type:\"string\"}}}}}}),b=\"\",_=sap.ui.resource(\"sap.ui.unified\",\"img/ColorPicker/Alphaslider_BG.png\"),y=sap.ui.getCore().getLibraryResourceBundle(\"sap.ui.unified\"),L=t.ColorPickerHelper,R=L.factory,v={};Object.defineProperties(v,{RGB:{value:\"RGB\"},CPResponsiveClass:{value:\"sapUnifiedColorPicker\"},CPMatrixClass:{value:\"sapUiColorPicker-ColorPickerMatrix\"},HSLClass:{value:\"sapUiColorPickerHSL\"},LabelClass:{value:\"sapUiColorPicker-ColorPickerLabels\"},UnitLabelClass:{value:\"sapUiCPUnitLabel\"},HEXClass:{value:\"sapUiColorPicker-ColorPickerHexField\"},LeftColumnInputClass:{value:\"sapUiColorPicker-ColorPickerInputFieldsLeft\"},RightColumnInputClass:{value:\"sapUiColorPicker-ColorPickerInputFieldsRight\"},SliderClass:{value:\"sapUiColorPicker-ColorPickerSlider\"},AlphaSliderClass:{value:\"sapUiColorPicker-ColorPickerAlphaSlider\"},OutputSelectorClass:{value:\"sapUiColorPickerHSL-RB\"},OutputSelectorRowClass:{value:\"sapUiColorPicker-RBRow\"},CPBoxClass:{value:\"sapUiColorPicker-ColorPickerBox\"},CPCircleClass:{value:\"sapUiColorPicker-ColorPickerCircle\"},LastColumnClass:{value:\"sapUiColorPicker-ColorPickerLastColumn\"},HideForHSVClass:{value:\"hideForHSV\"},HideForHSLClass:{value:\"hideForHSL\"},OldColorClass:{value:\"sapUiColorPicker-ColorPickerOldColor\"},NewColorClass:{value:\"sapUiColorPicker-ColorPickerNewColor\"},SwatchesClass:{value:\"sapUiColorPicker-swatches\"},ArrowClass:{value:\"sapUiColorPicker-Arrow\"},Colors:{value:{aliceblue:\"f0f8ff\",antiquewhite:\"faebd7\",aqua:\"00ffff\",aquamarine:\"7fffd4\",azure:\"f0ffff\",beige:\"f5f5dc\",bisque:\"ffe4c4\",black:\"000000\",blanchedalmond:\"ffebcd\",blue:\"0000ff\",blueviolet:\"8a2be2\",brown:\"a52a2a\",burlywood:\"deb887\",cadetblue:\"5f9ea0\",chartreuse:\"7fff00\",chocolate:\"d2691e\",coral:\"ff7f50\",cornflowerblue:\"6495ed\",cornsilk:\"fff8dc\",crimson:\"dc143c\",cyan:\"00ffff\",darkblue:\"00008b\",darkcyan:\"008b8b\",darkgoldenrod:\"b8860b\",darkgray:\"a9a9a9\",darkgrey:\"a9a9a9\",darkgreen:\"006400\",darkkhaki:\"bdb76b\",darkmagenta:\"8b008b\",darkolivegreen:\"556b2f\",darkorange:\"ff8c00\",darkorchid:\"9932cc\",darkred:\"8b0000\",darksalmon:\"e9967a\",darkseagreen:\"8fbc8f\",darkslateblue:\"483d8b\",darkslategray:\"2f4f4f\",darkslategrey:\"2f4f4f\",darkturquoise:\"00ced1\",darkviolet:\"9400d3\",deeppink:\"ff1493\",deepskyblue:\"00bfff\",dimgray:\"696969\",dimgrey:\"696969\",dodgerblue:\"1e90ff\",firebrick:\"b22222\",floralwhite:\"fffaf0\",forestgreen:\"228b22\",fuchsia:\"ff00ff\",gainsboro:\"dcdcdc\",ghostwhite:\"f8f8ff\",gold:\"ffd700\",goldenrod:\"daa520\",gray:\"808080\",grey:\"808080\",green:\"008000\",greenyellow:\"adff2f\",honeydew:\"f0fff0\",hotpink:\"ff69b4\",indianred:\"cd5c5c\",indigo:\"4b0082\",ivory:\"fffff0\",khaki:\"f0e68c\",lavender:\"e6e6fa\",lavenderblush:\"fff0f5\",lawngreen:\"7cfc00\",lemonchiffon:\"fffacd\",lightblue:\"add8e6\",lightcoral:\"f08080\",lightcyan:\"e0ffff\",lightgoldenrodyellow:\"fafad2\",lightgray:\"d3d3d3\",lightgrey:\"d3d3d3\",lightgreen:\"90ee90\",lightpink:\"ffb6c1\",lightsalmon:\"ffa07a\",lightseagreen:\"20b2aa\",lightskyblue:\"87cefa\",lightslategray:\"778899\",lightslategrey:\"778899\",lightsteelblue:\"b0c4de\",lightyellow:\"ffffe0\",lime:\"00ff00\",limegreen:\"32cd32\",linen:\"faf0e6\",magenta:\"ff00ff\",maroon:\"800000\",mediumaquamarine:\"66cdaa\",mediumblue:\"0000cd\",mediumorchid:\"ba55d3\",mediumpurple:\"9370db\",mediumseagreen:\"3cb371\",mediumslateblue:\"7b68ee\",mediumspringgreen:\"00fa9a\",mediumturquoise:\"48d1cc\",mediumvioletred:\"c71585\",midnightblue:\"191970\",mintcream:\"f5fffa\",mistyrose:\"ffe4e1\",moccasin:\"ffe4b5\",navajowhite:\"ffdead\",navy:\"000080\",oldlace:\"fdf5e6\",olive:\"808000\",olivedrab:\"6b8e23\",orange:\"ffa500\",orangered:\"ff4500\",orchid:\"da70d6\",palegoldenrod:\"eee8aa\",palegreen:\"98fb98\",paleturquoise:\"afeeee\",palevioletred:\"db7093\",papayawhip:\"ffefd5\",peachpuff:\"ffdab9\",peru:\"cd853f\",pink:\"ffc0cb\",plum:\"dda0dd\",powderblue:\"b0e0e6\",purple:\"800080\",red:\"ff0000\",rosybrown:\"bc8f8f\",royalblue:\"4169e1\",saddlebrown:\"8b4513\",salmon:\"fa8072\",sandybrown:\"f4a460\",seagreen:\"2e8b57\",seashell:\"fff5ee\",sienna:\"a0522d\",silver:\"c0c0c0\",skyblue:\"87ceeb\",slateblue:\"6a5acd\",slategray:\"708090\",slategrey:\"708090\",snow:\"fffafa\",springgreen:\"00ff7f\",steelblue:\"4682b4\",tan:\"d2b48c\",teal:\"008080\",thistle:\"d8bfd8\",tomato:\"ff6347\",turquoise:\"40e0d0\",violet:\"ee82ee\",wheat:\"f5deb3\",white:\"ffffff\",whitesmoke:\"f5f5f5\",yellow:\"ffff00\",yellowgreen:\"9acd32\",transparent:\"00000000\"}}}),S.prototype.init=function(){b=C.browser.firefox?\"-moz-linear-gradient\":C.browser.msie?\"-ms-linear-gradient\":C.browser.webkit?\"-webkit-linear-gradient\":\"linear-gradient\",this.Color={r:255,g:255,b:255,h:0,s:0,l:100,v:100,a:1,oldA:1,hex:\"#ffffff\",old:\"#ffffff\"},this.sHexString=\"ffffff\",this.$CPBox=null,this.$CPCur=null,this.RGB={r:0,g:0,b:0},this.bRtl=sap.ui.getCore().getConfiguration().getRTL(),this.data(\"sap-ui-fastnavgroup\",\"true\",!0),this.bResponsive=L.isResponsive(),this._iCPCursorSize=parseInt(d.get(\"_sap_ui_unified_ColorPicker_CircleSize\"),10),this._processChanges=this._processHSVChanges,this._bHSLMode=!1};var F=o.extend(\"sap.ui.unified._ColorPickerBox\",{metadata:{events:{select:{parameters:{value:{type:\"int\"},saturation:{type:\"int\"}}},resize:{parameters:{size:{type:\"int\"}}}}},init:function(){this.bRtl=sap.ui.getCore().getConfiguration().getRTL()},exit:function(){this._sResizeListener&&i.deregister(this._sResizeListener)},getWidth:function(){return this.$().width()},getOffset:function(){return this.$().offset()},onBeforeRendering:function(){this._sResizeListener&&i.deregister(this._sResizeListener)},onAfterRendering:function(){this._handle=this.$().find(\"> div.\"+v.CPCircleClass),this._sResizeListener=i.register(this.getDomRef(),this.handleResize.bind(this))},handleResize:function(e){this.fireResize({size:e.size.width})},getHandle:function(){return this._handle},ontouchstart:function(e){this.handleTouch(e)},ontouchend:function(e){this.handleTouch(e)},ontouchmove:function(e){this.handleTouch(e)},handleTouch:function(e){var t=this.calculateValuesFromEvent(e);t&&this.fireSelect(t)},calculateValuesFromEvent:function(e){var t,o,s,i=e.offsetX,a=e.offsetY,r=t=this.getWidth();if(e.preventDefault&&e.preventDefault(),!i){if(o=e.targetTouches?e.targetTouches[0]:e,o&&o.pageX||(o=e)&&o.pageX||!e.changedTouches||(o=e.changedTouches[0]),!o.pageX)return!1;s=this.getOffset(),i=o.pageX-s.left,a=o.pageY-s.top}return i=Math.min(Math.max(i,0),r),a=Math.min(Math.max(a,0),t),this.bRtl&&(i=r-i),{value:i/r*100,saturation:100*(1-a/t)}},renderer:function(e,t){e.write(\"<div\"),e.addClass(v.CPBoxClass),e.writeControlData(t),e.writeClasses(),e.write(\">\"),e.write(\"<div\"),e.writeAttributeEscaped(\"id\",t.getId()+\"-cpCur\"),e.writeAttribute(\"tabindex\",0),e.addClass(v.CPCircleClass),e.writeClasses(),e.write(\"></div>\"),e.write(\"</div>\")}});return S.prototype._createRowFromInput=function(e,t,o,s){var i,a=y.getText(t);return i=new h({content:[R.createLabel({text:o,tooltip:a,labelFor:e}).addStyleClass(v.LabelClass),e.setTooltip(a)]}),s&&i.addContent(R.createLabel({text:s,labelFor:e}).addStyleClass(v.UnitLabelClass).addStyleClass(v.LabelClass)),i},S.prototype._updateColorStringProperty=function(e,t){var o=this._getCSSColorString();this.setProperty(\"colorString\",o,!0),t&&this.fireLiveChange({r:this.Color.r,g:this.Color.g,b:this.Color.b,h:this.Color.h,s:this.Color.s,v:this.Color.v,l:this.Color.l,alpha:this.Color.a,hex:this.Color.hex,formatHSL:this.Color.formatHSL,colorString:o}),e&&this.fireChange({r:this.Color.r,g:this.Color.g,b:this.Color.b,h:this.Color.h,s:this.Color.s,v:this.Color.v,l:this.Color.l,alpha:this.Color.a,hex:this.Color.hex,formatHSL:this.Color.formatHSL,colorString:o})},S.prototype._handleCPBoxSelectEvent=function(e){var t=e.getParameter(\"value\"),o=e.getParameter(\"saturation\");this.oSatField.setValue(o),this._bHSLMode?this.oLitField.setValue(t):this.oValField.setValue(t),this._processChanges(),this._updateColorStringProperty(!1,!0),$(this.$CPCur).focus()},S.prototype._handleCPBoxResizeEvent=function(e){this._iCPBoxSize=e.getParameter(\"size\"),this._updateCursorPosition()},S.prototype._handleCPBoxTouchEndEvent=function(e){this._updateColorStringProperty(!0,!1)},S.prototype.createRGBHexFields=function(){var e=this.getId();this.oHexField=R.createInput(e+\"-hxF\",{value:this.Color.hex.substr(1),change:this._handleHexValueChange.bind(this)}).addStyleClass(v.HEXClass),this.oRedField=R.createInput(e+\"-rF\",{value:this.Color.r,change:this._handleRedValueChange.bind(this)}).addStyleClass(v.LeftColumnInputClass),this.oGreenField=R.createInput(e+\"-gF\",{value:this.Color.g,change:this._handleGreenValueChange.bind(this)}).addStyleClass(v.LeftColumnInputClass),this.oBlueField=R.createInput(e+\"-bF\",{value:this.Color.b,change:this._handleBlueValueChange.bind(this)}).addStyleClass(v.LeftColumnInputClass)},S.prototype._createInteractionControls=function(){var e,o,s=this.getId();this.oCPBox=new F(s+\"-cpBox\",{select:this._handleCPBoxSelectEvent.bind(this),resize:this._handleCPBoxResizeEvent.bind(this)}),this.oCPBox.addDelegate({ontouchend:this._handleCPBoxTouchEndEvent.bind(this)}),this.createRGBHexFields(),this.oHueField=R.createInput(s+\"-hF\",{value:this.Color.h,change:this._handleHueValueChange.bind(this)}).addStyleClass(v.RightColumnInputClass),this.oSatField=R.createInput(s+\"-sF\",{value:this.Color.s,change:this._handleSatValueChange.bind(this)}).addStyleClass(v.RightColumnInputClass),this.oLitField=R.createInput(s+\"-lF\",{value:this.Color.l,change:this._handleLitValueChange.bind(this)}).addStyleClass(v.RightColumnInputClass),this.oAlphaField=R.createInput(s+\"-aF\",{value:this.Color.a,change:this._handleAlphaValueChange.bind(this)}).addStyleClass(v.RightColumnInputClass),this.oValField=R.createInput(s+\"-vF\",{value:this.Color.v,change:this._handleValValueChange.bind(this)}).addStyleClass(v.RightColumnInputClass),this.oRGBorHSLRBGroup=R.createRadioButtonGroup({columns:2,buttons:[R.createRadioButtonItem({text:v.RGB}),R.createRadioButtonItem({text:t.ColorPickerMode.HSL})],select:this._handleRGBorHSLValueChange.bind(this),selectedIndex:this.Color.formatHSL?1:0}).addStyleClass(v.OutputSelectorClass),e=new u({text:y.getText(\"COLORPICKER_HUE_SLIDER\")}).toStatic(),this.addAggregation(\"_invisibleTexts\",e,!0),S.prototype.createSlider=R.createSlider,this.oSlider=this.createSlider(s+\"-hSLD\",{max:360,step:1,tooltip:y.getText(\"COLORPICKER_HUE\"),value:parseInt(this.oHueField.getValue(),10)}),this.oSlider.addStyleClass(v.SliderClass).addAriaLabelledBy&&this.oSlider.addStyleClass(v.SliderClass).addAriaLabelledBy(e),this.oSlider.attachEvent(\"liveChange\",\"liveChange\",this._handleSliderChange.bind(this)),this.oSlider.attachEvent(\"change\",\"change\",this._handleSliderChange.bind(this)),o=new u({text:y.getText(\"COLORPICKER_ALPHA_SLIDER\")}).toStatic(),this.addAggregation(\"_invisibleTexts\",o,!0),this.oAlphaSlider=R.createSlider(s+\"-aSLD\",{max:1,value:1,step:.01,tooltip:y.getText(\"COLORPICKER_ALPHA\")}).addStyleClass(v.AlphaSliderClass).addAriaLabelledBy(o),this.oAlphaSlider.attachEvent(\"liveChange\",\"liveChange\",this._handleAlphaSliderChange.bind(this)),this.oAlphaSlider.attachEvent(\"change\",\"change\",this._handleAlphaSliderChange.bind(this))},S.prototype._createLayout=function(){var e,t=this.getId();this._bLayoutControlsCreated||(this._createInteractionControls(),e=new a({containerQuery:!0,content:[this.oCPBox.setLayoutData(this._oLayoutData.oCPBox),new l({content:[this._createRowFromInput(this.oRedField,\"COLORPICKER_RED\",\"R:\"),this._createRowFromInput(this.oGreenField,\"COLORPICKER_GREEN\",\"G:\"),this._createRowFromInput(this.oBlueField,\"COLORPICKER_BLUE\",\"B:\"),this._createRowFromInput(this.oHexField,\"COLORPICKER_HEX\",\"#:\")],layoutData:this._oLayoutData.icOne}),new l({content:[this._createRowFromInput(this.oHueField,\"COLORPICKER_HUE\",\"H:\"),this._createRowFromInput(this.oSatField,\"COLORPICKER_SAT\",\"S:\",\"%\"),this._createRowFromInput(this.oLitField,\"COLORPICKER_LIGHTNESS\",\"L:\",\"%\").addStyleClass(v.HideForHSVClass),this._createRowFromInput(this.oAlphaField,\"COLORPICKER_ALPHA\",\"A:\").addStyleClass(v.HideForHSVClass),this._createRowFromInput(this.oValField,\"COLORPICKER_VALUE\",\"V:\").addStyleClass(v.HideForHSLClass)],layoutData:this._oLayoutData.icTwo}).addStyleClass(v.LastColumnClass),new h({content:[new s({content:[\"<div id='\",t,\"-ocBox' class='\",v.OldColorClass,\"'></div>\"].join(\"\")}),new n({backgroundColor:\"transparent\",src:\"sap-icon://arrow-right\",tooltip:y.getText(\"COLORPICKER_NEW_OLD_COLOR\")}).addStyleClass(v.HideForHSVClass).addStyleClass(v.ArrowClass),new s({content:[\"<div id='\",t,\"-ncBox' class='\",v.NewColorClass,\"'></div>\"].join(\"\")})],layoutData:this._oLayoutData.swatches}).addStyleClass(v.SwatchesClass),new h({content:[R.createLabel({text:\"Output:\",labelFor:this.oRGBorHSLRBGroup}),this.oRGBorHSLRBGroup],layoutData:this._oLayoutData.rbg}).addStyleClass(v.HideForHSVClass).addStyleClass(v.OutputSelectorRowClass),this.oSlider.setLayoutData(new r({span:\"L6 M6 S12\",linebreak:!0})),this.oAlphaSlider.setLayoutData(new r({span:\"L6 M6 S12\"}))]}).addStyleClass(v.CPMatrixClass),this.setAggregation(\"_grid\",e,!0),this._bLayoutControlsCreated=!0,this._adaptControlToLibrary())},S.prototype._adaptControlToLibrary=function(){var t;this._bLayoutControlsCreated&&(t=this.getAggregation(\"_grid\"),this.bResponsive?(C.system.phone||e(\"html\").hasClass(\"sapUiMedia-Std-Phone\")||t._setBreakPointTablet(400),t.addStyleClass(v.CPResponsiveClass)):(t.setProperty(\"hSpacing\",0,!0),t.setProperty(\"vSpacing\",0,!0),this._oLayoutData.oCPBox.setSpanS(5),this._oLayoutData.icOne.setSpanS(4),this._oLayoutData.icTwo.setSpanS(3),this._oLayoutData.rbg.setSpanS(8)),this._adaptControlToLibrary=e.noop)},S.prototype._updateControlVisualState=function(){var e=this.getAggregation(\"_grid\");this._bLayoutControlsCreated&&(this.bResponsive?this._bHSLMode?(e.addStyleClass(v.HSLClass),this._oLayoutData.swatches.setSpanM(4).setLinebreak(!0)):(e.removeStyleClass(v.HSLClass),this._oLayoutData.swatches.setSpanM(3).setLinebreak(!1)):this._bHSLMode?(e.addStyleClass(v.HSLClass),this._oLayoutData.swatches.setSpanS(4).setLinebreak(!0)):(e.removeStyleClass(v.HSLClass),this._oLayoutData.swatches.setSpanS(3).setLinebreak(!1)))},S.prototype._processChanges=e.noop,S.prototype.setMode=function(o,s){switch(o){case t.ColorPickerMode.HSL:this._processChanges=this._processHSLChanges;break;case t.ColorPickerMode.HSV:this._processChanges=this._processHSVChanges;break;default:e.sap.log.error(\"Control must have a valid mode set to work correct\")}return this._bHSLMode=o===t.ColorPickerMode.HSL,this.setProperty(\"mode\",o,s)},S.prototype.onBeforeRendering=function(){this.createLayoutData(),this._createLayout(),this._updateControlVisualState(),this._updateColorString()},S.prototype.createLayoutData=function(){this._oLayoutData={oCPBox:new r({span:\"L6 M6 S12\"}),icOne:new r({span:\"L3 M3 S6\"}),icTwo:new r({span:\"L3 M3 S6\"}),swatches:new r({span:\"L3 M3 S12\"}),rbg:new r({span:\"L6 M8 S12\"})}},S.prototype._updateColorString=function(){this._parseColorString(this.getColorString()),this.oHexField.setValue(this.Color.hex.substr(1).toUpperCase()),this.oRedField.setValue(this.Color.r),this.oGreenField.setValue(this.Color.g),this.oBlueField.setValue(this.Color.b),this.oHueField.setValue(this.Color.h),this.oSatField.setValue(this.Color.s),this._bHSLMode?(this.oLitField.setValue(this.Color.l),this.oAlphaField.setValue(this.Color.a),this.oSlider.setValue(this.Color.h),this.oAlphaSlider.setValue(this.Color.a),this.oRGBorHSLRBGroup.setSelectedIndex(this.Color.formatHSL?1:0)):(this.oValField.setValue(this.Color.v),this.oSlider.setValue(this.Color.h),this.oAlphaSlider.setValue(this.Color.a),this.oAlphaField.setValue(this.Color.a)),this._updateColorStringProperty(!0,!0)},S.prototype.isColor=function(e){return this._parseColorString(e,!0)},S.prototype._handleSliderChange=function(e,t){var o=parseInt(this.oSlider.getValue(),10);this.oHueField.setValue(o),this._processChanges(),this._updateColorStringProperty(\"change\"===t,\"liveChange\"===t)},S.prototype._handleAlphaSliderChange=function(e,t){this.Color.a=this.oAlphaSlider.getValue(),this._bHSLMode&&this.oAlphaField.setValue(this.Color.a),this.Color.formatHSL?this._processChanges():this._processRGBChanges(),this._updateColorStringProperty(\"change\"===t,\"liveChange\"===t)},S.prototype._getValueInRange=function(e,t,o){return isNaN(e)&&(e=0),Math.min(Math.max(e,t),o)},S.prototype._handleAlphaValueChange=function(){var e=parseFloat(this.oAlphaField.getValue(),10);e=this._getValueInRange(e,0,1),this.Color.a=e,this.oAlphaField.setValue(e),this.oAlphaSlider.setValue(e),this.Color.formatHSL?this._processChanges():this._processRGBChanges(),this._updateColorStringProperty(!0,!0)},S.prototype._handleRGBorHSLValueChange=function(){this.Color.formatHSL=1===this.oRGBorHSLRBGroup.getSelectedIndex(),this._updateColorStringProperty(!0,!0)},S.prototype._handleHueValueChange=function(){var e=parseInt(this.oHueField.getValue(),10);e=this._getValueInRange(e,0,360),this.oHueField.setValue(e),this.oSlider.setValue(e),this._processChanges(),this._updateColorStringProperty(!0,!0)},S.prototype._handleSatValueChange=function(){var e=parseInt(this.oSatField.getValue(),10);e=this._getValueInRange(e,0,100),this.oSatField.setValue(e),this._processChanges(),this._updateColorStringProperty(!0,!0)},S.prototype._handleValValueChange=function(){var e=parseInt(this.oValField.getValue(),10);e=this._getValueInRange(e,0,100),this.oValField.setValue(e),this._processHSVChanges(),this._updateColorStringProperty(!0,!0)},S.prototype._handleLitValueChange=function(){var e=parseInt(this.oLitField.getValue(),10);e=this._getValueInRange(e,0,100),this.oLitField.setValue(e),this._processHSLChanges(),this._updateColorStringProperty(!0,!0)},S.prototype._handleRedValueChange=function(){var e=parseInt(this.oRedField.getValue(),10);e=this._getValueInRange(e,0,255),this.oRedField.setValue(e),this._processRGBChanges(),this._updateColorStringProperty(!0,!0)},S.prototype._handleGreenValueChange=function(){var e=parseInt(this.oGreenField.getValue(),10);e=this._getValueInRange(e,0,255),this.oGreenField.setValue(e),this._processRGBChanges(),this._updateColorStringProperty(!0,!0)},S.prototype._handleBlueValueChange=function(){var e=parseInt(this.oBlueField.getValue(),10);e=this._getValueInRange(e,0,255),this.oBlueField.setValue(e),this._processRGBChanges(),this._updateColorStringProperty(!0,!0)},S.prototype._processHSVChanges=function(){var e=parseInt(this.oHueField.getValue(),10),t=parseInt(this.oSatField.getValue(),10),o=parseInt(this.oValField.getValue(),10);this._calculateRGB(e,t,o),this.Color.r=this.RGB.r,this.Color.g=this.RGB.g,this.Color.b=this.RGB.b,this.oRedField.setValue(this.Color.r),this.oGreenField.setValue(this.Color.g),this.oBlueField.setValue(this.Color.b),this._calculateHEX(this.Color.r,this.Color.g,this.Color.b),this.oHexField.setValue(this.sHexString.toUpperCase()),this.Color.hex=\"#\"+this.oHexField.getValue(),this.Color.h=e,this.Color.s=t,this.Color.v=o,this.oHueField.setValue(this.Color.h),this.oSatField.setValue(this.Color.s),this.oValField.setValue(this.Color.v),this._updateGradientBoxBackground(this.Color.h),this._updateCursorPosition(),this._updateSelColorBackground()},S.prototype._processHSLChanges=function(){var e=parseInt(this.oHueField.getValue(),10),t=parseInt(this.oSatField.getValue(),10),o=parseInt(this.oLitField.getValue(),10);e>360&&(e%=360),this._calculateRGB(e,t,o),this.Color.r=this.RGB.r,this.Color.g=this.RGB.g,this.Color.b=this.RGB.b,this.oRedField.setValue(this.Color.r),this.oGreenField.setValue(this.Color.g),this.oBlueField.setValue(this.Color.b),this._calculateHEX(this.Color.r,this.Color.g,this.Color.b),this.oHexField.setValue(this.sHexString.toUpperCase()),this.Color.hex=\"#\"+this.oHexField.getValue(),this.Color.h=e,this.Color.s=t,this.Color.l=o,this.oHueField.setValue(this.Color.h),this.oSatField.setValue(this.Color.s),this.oLitField.setValue(this.Color.l),this._updateGradientBoxBackground(this.Color.h),this._updateCursorPosition(),this._updateAlphaBackground(),this._updateSelColorBackground()},S.prototype._processRGBChanges=function(){var e=Math.round(parseInt(this.oRedField.getValue(),10)),t=Math.round(parseInt(this.oGreenField.getValue(),10)),o=Math.round(parseInt(this.oBlueField.getValue(),10)),s=e+t+o===765;this._calculateHEX(e,t,o),this.oHexField.setValue(this.sHexString.toUpperCase()),this._bHSLMode?(this._calculateHSL(e,t,o),this.oLitField.setValue(this.Color.l)):(s||this._calculateHSV(e,t,o),this.oValField.setValue(this.Color.v)),s||this.oHueField.setValue(this.Color.h),this.oSatField.setValue(this.Color.s),this.oSlider.setValue(parseInt(this.oHueField.getValue(),10)),this.Color.r=e,this.Color.g=t,this.Color.b=o,this.Color.hex=\"#\"+this.oHexField.getValue(),this._updateGradientBoxBackground(this.Color.h),this._updateCursorPosition(),this._updateSelColorBackground()},S.prototype._handleHexValueChange=function(){var e,t=this.oHexField.getValue().toLowerCase(),o=1;if(\"#\"===t.substr(0,1)&&(t=t.substr(1)),e=/^([0-9a-fA-F]{8})$/,!1!==e.test(t)&&(o=Number((parseInt(t.substr(6,2),16)/255).toFixed(2)),t=t.substr(0,6)),e=/^([0-9a-fA-F]{3}|[0-9a-fA-F]{6})$/,!1===e.test(t))return this.oHexField.setValueState(g.Error),this.oSlider.setEnabled(!1),this.oAlphaSlider.setEnabled(!1),this.oHueField.setEnabled(!1),this.oRedField.setEnabled(!1),this.oGreenField.setEnabled(!1),this.oBlueField.setEnabled(!1),this.oSatField.setEnabled(!1),void(this._bHSLMode?(this.oLitField.setEnabled(!1),this.oAlphaField.setEnabled(!1)):this.oValField.setEnabled(!1));this.oHexField.getValueState()===g.Error&&(this.oHexField.setValueState(g.None),this.oSlider.setEnabled(!0),this.oAlphaSlider.setEnabled(!0),this.oHueField.setEnabled(!0),this.oRedField.setEnabled(!0),this.oGreenField.setEnabled(!0),this.oBlueField.setEnabled(!0),this.oSatField.setEnabled(!0),this._bHSLMode?(this.oLitField.setEnabled(!0),this.oAlphaField.setEnabled(!0)):this.oValField.setEnabled(!0)),3===t.length&&(t=t.charAt(0)+t.charAt(0)+t.charAt(1)+t.charAt(1)+t.charAt(2)+t.charAt(2)),this._processHexChanges(t),this.oHexField.setValue(t.toUpperCase()),this.oRedField.setValue(this.Color.r),this.oGreenField.setValue(this.Color.g),this.oBlueField.setValue(this.Color.b),this.oHueField.setValue(this.Color.h),this.oSatField.setValue(this.Color.s),this._bHSLMode?(this.oLitField.setValue(this.Color.l),this.oAlphaField.setValue(1)):this.oValField.setValue(this.Color.v),this.oSlider.setValue(parseInt(this.oHueField.getValue(),10)),this.oAlphaSlider.setValue(o),this.Color.a=o,this._bHSLMode&&this.oAlphaField.setValue(o),this._updateGradientBoxBackground(this.Color.h),this._updateCursorPosition(),this._updateSelColorBackground(),this._updateColorStringProperty(!0,!0)},S.prototype._processHexChanges=function(e){this._convertRGB(e),this._bHSLMode?this._calculateHSL(this.Color.r,this.Color.g,this.Color.b):this._calculateHSV(this.Color.r,this.Color.g,this.Color.b),this.Color.hex=\"#\"+e.toLowerCase()},S.prototype._updateAlphaBackground=function(){var e=[this.Color.r,this.Color.g,this.Color.b].join(\",\"),t=b+\"(left,rgba(\"+e+\",0),rgba(\"+e+\",1)),url(\"+_+\")\";this.lastAlphaSliderGradient!==t&&(this.oAlphaSlider.$().find(this.bResponsive?\".sapMSliderInner\":\".sapUiSliBar\").css(\"background-image\",t),this.lastAlphaSliderGradient=t)},S.prototype._updateCursorPosition=function(){var e,t;this._iCPBoxSize&&(e=this._bHSLMode?Math.round(this.oLitField.getValue()*this._iCPBoxSize/100):Math.round(this.oValField.getValue()*this._iCPBoxSize/100),this.bRtl&&(e=this._iCPBoxSize-e),t=Math.round((1-this.oSatField.getValue()/100)*this._iCPBoxSize),e=Math.round(Math.max(e,0)-this._iCPCursorSize/2-1),t=Math.round(Math.max(t,0)-this._iCPCursorSize/2-1),this.$CPCur.css(\"left\",e).css(\"top\",t))},S.prototype._calculateRGB=function(e,t,o){var s,i,a,r,l,h;if(this._bHSLMode)return void this._calculateRGBAdvanced(e,t,o);switch(e%=360,e/=60,t/=100,o/=100,h=o*t,l=h*(1-Math.abs(e%2-1)),r=o-h,s=0,i=0,a=0,Math.floor(e)){case 0:s=h,i=l;break;case 1:s=l,i=h;break;case 2:i=h,a=l;break;case 3:i=l,a=h;break;case 4:s=l,a=h;break;case 5:s=h,a=l;break;default:s=0,a=0,i=0}this.RGB.r=Math.floor(255*(s+r)),this.RGB.g=Math.floor(255*(i+r)),this.RGB.b=Math.floor(255*(a+r))},S.prototype._calculateRGBAdvanced=function(e,t,o){var s,i,a,r,l,h,n,d,u;switch(e=this._getValueInRange(e,0,360),t>100?t=1:t<0?t=0:t/=100,o>100?o=1:o<0?o=0:o/=100,d=t*(1-Math.abs(2*o-1)),n=255*(o-.5*d),h=d*(1-Math.abs(e/60%2-1)),u=Math.floor(e/60),l=n+255*h,r=n+255*d,u){case 0:s=r,i=l,a=n;break;case 1:s=l,i=r,a=n;break;case 2:s=n,i=r,a=l;break;case 3:s=n,i=l,a=r;break;case 4:s=l,i=n,a=r;break;case 5:s=r,i=n,a=l;break;default:s=0,i=0,a=0}this.RGB.r=Math.round(s),this.RGB.g=Math.round(i),this.RGB.b=Math.round(a)},S.prototype._getCSSColorString=function(){return this.Color.formatHSL?this.Color.a<1?\"hsla(\"+this.Color.h+\",\"+this.Color.s+\"%,\"+this.Color.l+\"%, \"+this.Color.a+\")\":\"hsl(\"+this.Color.h+\",\"+this.Color.s+\"%,\"+this.Color.l+\"%)\":this.Color.a<1?\"rgba(\"+this.Color.r+\",\"+this.Color.g+\",\"+this.Color.b+\", \"+this.Color.a+\")\":\"rgb(\"+this.Color.r+\",\"+this.Color.g+\",\"+this.Color.b+\")\"},S.prototype._calculateHEX=function(e,t,o){var s=e.toString(16),i=t.toString(16),a=o.toString(16);1===s.length&&(s=\"0\"+s),1===i.length&&(i=\"0\"+i),1===a.length&&(a=\"0\"+a),this.sHexString=(s+i+a).toLowerCase()},S.prototype._calculateHSV=function(e,t,o){var s=Math.max(Math.max(e,t),o),i=Math.min(Math.min(e,t),o),a=s-i,r=Math.round(100*s/255),l=0===s?0:100*a/s,h=0;0===l?h=0:e===s?h=60*(t-o)/a:t===s?h=120+60*(o-e)/a:o===s&&(h=240+60*(e-t)/a),h<0&&(h+=359.9),h=Math.round(h),l=Math.round(l),this.Color.h=h,this.Color.s=l,this.Color.v=r},S.prototype._calculateHSL=function(e,t,o){var s=Math.max(e,t,o),i=Math.min(e,t,o),a=(s-i)/255,r=(s+i)/510,l=1-Math.abs(2*r-1),h=0===r?0:a/l,n=0!==l?h:0,d=0;if(r=Math.round(100*r),n=Math.round(100*n),0===r||0===n||e+t+o===765)d=0;else{var u=s-i;s===e&&(d=(t-o)/u%6),s===t&&(d=(o-e)/u+2),s===o&&(d=(e-t)/u+4),0===u&&(d=0),d*=60,d<0&&(d+=360)}this.Color.h=Math.round(d),this.Color.s=n,this.Color.l=r},S.prototype._convertRGB=function(e){this.Color.r=parseInt(e.substr(0,2),16),this.Color.g=parseInt(e.substr(2,2),16),this.Color.b=parseInt(e.substr(4,2),16)},S.prototype._updateGradientBoxBackground=function(e){this._bHSLMode?this._calculateRGBAdvanced(e,100,50):this._calculateRGB(e,100,100),this._calculateHEX(this.RGB.r,this.RGB.g,this.RGB.b),this.$CPBox.css(\"background-color\",\"rgb(\"+[this.RGB.r,this.RGB.g,this.RGB.b].join(\",\")+\")\")},S.prototype._updateSelColorBackground=function(){this.$(\"ncBox\").css(\"background-color\",this._getCSSColorString())},S.prototype._parseColorString=function(e,t){var o;return\"#\"===e.substr(0,1)&&(e=e.substr(1)),e=e.trim().toLowerCase(),o=this._parseColorName(e),o?!!t||(8===o.length&&(this.Color.a=this.Color.oldA=Number((parseInt(o.substr(6,2),16)/255).toFixed(2)),o=o.substring(0,6)),this._processHexChanges(o),this.Color.old=this.Color.hex,this._bHSLMode&&(this.Color.formatHSL=!1),!0):/^([0-9a-fA-F]{3}|[0-9a-fA-F]{6})$/.test(e)?!!t||(o=3===e.length?e[0]+e[0]+e[1]+e[1]+e[2]+e[2]:e,this._processHexChanges(o),this.Color.old=this.Color.hex,this._bHSLMode&&(this.Color.formatHSL=!1),!0):\"rgb\"===e.substr(0,3)?this._parseRGB(e,t):this._bHSLMode?this._parseHSL(e,t):\"hsv\"===e.substr(0,3)&&this._parseHSV(e,t)},S.prototype._parseHSV=function(e,t){var o,s,i,a,r=/^(((\\d{1,2})|([1,2]\\d{2})|(3[0-5]\\d)|(360)),)(((\\d{1,2})|(100)),)((\\d{1,2})|(100))$/;return e=e.substr(3).replace(\"(\",\"\").replace(\")\",\"\").split(\" \").join(\"\"),!0===r.test(e)&&(!!t||(o=e.split(\",\"),s=parseInt(o[0],10),i=parseInt(o[1],10),a=parseInt(o[2],10),this._calculateRGB(s,i,a),this._calculateHEX(this.RGB.r,this.RGB.g,this.RGB.b),this.Color.r=this.RGB.r,this.Color.g=this.RGB.g,this.Color.b=this.RGB.b,this.Color.h=s,this.Color.s=i,this.Color.v=a,this.Color.hex=\"#\"+this.sHexString,this.Color.old=this.Color.hex,!0))},S.prototype._parseHSL=function(e,t){var o,s,i,a,r,l,h=e.substr(0,4);if(\"hsla\"===h)s=!0;else{if(\"hsl(\"!==h)return!1;s=!1}if(e=e.substr(s?4:3).replace(\"(\",\"\").replace(\")\",\"\").split(\" \").join(\"\"),o=e.split(\",\"),i=parseInt(o[0],10),a=parseFloat(o[1]),r=parseFloat(o[2]),s)l=parseFloat(o[3]);else{if(o[3]&&parseFloat(o[3])>=0)return!1;l=1}return a=a<1&&a>0?100*a:a,r=r<1&&r>0?100*r:r,i>=0&&i<=360&&a>=0&&a<=100&&r>=0&&r<=100&&l>=0&&l<=1&&(!!t||(this._calculateRGB(i,a,r),this._calculateHEX(this.RGB.r,this.RGB.g,this.RGB.b),this.Color.r=this.RGB.r,this.Color.g=this.RGB.g,this.Color.b=this.RGB.b,this.Color.h=i,this.Color.s=a,this.Color.l=r,this.Color.hex=\"#\"+this.sHexString,this.Color.old=this.Color.hex,this.Color.a=this.Color.oldA=l,this.Color.formatHSL=!0,!0))},S.prototype._parseRGB=function(e,t){var o,s,i,a;if(\"rgba\"===(s=e.substring(0,4)))a=/^(((\\d{1,2})|(1\\d{2})|(2[0-4]\\d)|(25[0-5])),){2}(((\\d{1,2})|(1\\d{2})|(2[0-4]\\d)|(25[0-5])),)([0]|([0]\\.[0-9]+)|(\\.[0-9]+)|[1])$/,i=!0;else{if(\"rgb\"!==s.substring(0,3))return!1;a=/^(((\\d{1,2})|(1\\d{2})|(2[0-4]\\d)|(25[0-5])),){2}(((\\d{1,2})|(1\\d{2})|(2[0-4]\\d)|(25[0-5])))$/,i=!1}return e=e.substr(i?4:3).replace(\"(\",\"\").replace(\")\",\"\").split(\" \").join(\"\"),a.test(e)?!!t||(o=e.split(\",\"),this._calculateHEX(parseInt(o[0],10),parseInt(o[1],10),parseInt(o[2],10)),this._processHexChanges(this.sHexString),this.Color.old=this.Color.hex,i&&(this.Color.a=this.Color.oldA=parseFloat(o[3])),!0):(this._bHSLMode&&(this.Color.formatHSL=!1),!1)},S.prototype._parseColorName=function(e){return v.Colors[e]},S.prototype.onAfterRendering=function(){var t=this._getCSSColorString();this.$CPBox=this.oCPBox.$(),this.$CPCur=this.oCPBox.getHandle(),this.$(\"ncBox\").css(\"background-color\",t),this.$(\"ocBox\").css(\"background-color\",t),this._updateGradientBoxBackground(this.Color.h),this._iCPBoxSize=this.oCPBox.getWidth(),this._updateCursorPosition(),this._bHSLMode&&this._updateAlphaBackground(),this.oSlider.iShiftGrip=Math.round(e(this.oSlider.oGrip).outerWidth()/2),this.oAlphaSlider.iShiftGrip=Math.round(e(this.oAlphaSlider.oGrip).outerWidth()/2)},S.prototype.getRGB=function(){return{r:this.Color.r,g:this.Color.g,b:this.Color.b}},S.prototype._getConstants=function(){return v},S});",
	"sap/ui/unified/ColorPickerRenderer.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([],function(){\"use strict\";var r={};return r.render=function(r,e){r.write(\"<div\"),r.writeControlData(e),r.writeClasses(),r.write(\">\"),r.renderControl(e.getAggregation(\"_grid\")),r.write(\"</div>\")},r},!0);",
	"sap/ui/unified/ContentSwitcher.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/core/Control\",\"./library\",\"./ContentSwitcherRenderer\"],function(t,e,n,i){\"use strict\";var o=n.ContentSwitcherAnimation,r=e.extend(\"sap.ui.unified.ContentSwitcher\",{metadata:{deprecated:!0,library:\"sap.ui.unified\",properties:{animation:{type:\"string\",group:\"Appearance\",defaultValue:\"None\"},activeContent:{type:\"int\",group:\"Behavior\",defaultValue:1}},aggregations:{content1:{type:\"sap.ui.core.Control\",multiple:!0,singularName:\"content1\"},content2:{type:\"sap.ui.core.Control\",multiple:!0,singularName:\"content2\"}}}});return function(e){r.prototype.init=function(){},r.prototype.switchContent=function(){return this.setActiveContent(1==this.getActiveContent()?2:1),this},r.prototype.onAfterRendering=function(){this._$Contents=[this.$(\"content1\"),this.$(\"content2\")]},r.prototype._showActiveContent=function(t){this._$Contents&&(this._$Contents[0].toggleClass(\"sapUiUfdCSwitcherVisible\",1===t),this._$Contents[1].toggleClass(\"sapUiUfdCSwitcherVisible\",2===t))},r.prototype.setActiveContent=function(e){return e=parseInt(e,10),isNaN(e)||e<1?(e=1,t.sap.log.warning(\"setActiveContent argument must be either 1 or 2. Active content set to 1.\")):e>2&&(e=2,t.sap.log.warning(\"setActiveContent argument must be either 1 or 2. Active content set to 2.\")),this.setProperty(\"activeContent\",e,!0),this._showActiveContent(e),this},r.prototype.setAnimation=function(e,n){\"string\"!=typeof e&&(e=o.None,t.sap.log.warning('setAnimation argument must be a string. Animation was set to \"'+o.None+'\".')),e=e.replace(/[^a-zA-Z0-9]/g,\"\");var i=this.getProperty(\"animation\");if(e===i)return this;var r=this.$();return r[0]&&(r.toggleClass(\"sapUiUfdCSwitcherAnimation\"+i,!1),r.toggleClass(\"sapUiUfdCSwitcherAnimation\"+e,!0)),this.setProperty(\"animation\",e,n)}}(window),r});",
	"sap/ui/unified/ContentSwitcherRenderer.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/unified/library\"],function(t,e){\"use strict\";var i=e.ContentSwitcherAnimation,n={};return n.render=function(e,n){var r=n.getId(),o=n.getAnimation();sap.ui.getCore().getConfiguration().getAnimation()||(o=i.None);var s=n.getActiveContent();e.write(\"<div\"),e.writeControlData(n),e.addClass(\"sapUiUfdCSwitcher\"),e.addClass(\"sapUiUfdCSwitcherAnimation\"+t.sap.encodeHTML(o)),e.writeClasses(),e.write(\">\"),e.write('<section id=\"'+r+'-content1\" class=\"sapUiUfdCSwitcherContent sapUiUfdCSwitcherContent1'+(1==s?\" sapUiUfdCSwitcherVisible\":\"\")+'\">'),this.renderContent(e,n.getContent1()),e.write(\"</section>\"),e.write('<section id=\"'+r+'-content2\" class=\"sapUiUfdCSwitcherContent sapUiUfdCSwitcherContent2'+(2==s?\" sapUiUfdCSwitcherVisible\":\"\")+'\">'),this.renderContent(e,n.getContent2()),e.write(\"</section>\"),e.write(\"</div>\")},n.renderContent=function(t,e){for(var i=0;i<e.length;++i)t.renderControl(e[i])},n},!0);",
	"sap/ui/unified/Currency.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/core/Control\",\"sap/ui/core/format/NumberFormat\",\"./CurrencyRenderer\"],function(t,e,r,i){\"use strict\";var s=e.extend(\"sap.ui.unified.Currency\",{metadata:{library:\"sap.ui.unified\",properties:{value:{type:\"float\",group:\"Appearance\",defaultValue:0},stringValue:{type:\"string\",group:\"Appearance\",defaultValue:null},currency:{type:\"string\",group:\"Appearance\",defaultValue:null},maxPrecision:{type:\"int\",group:\"Appearance\",defaultValue:3},useSymbol:{type:\"boolean\",group:\"Appearance\",defaultValue:!0}},designtime:\"sap/ui/unified/designtime/Currency.designtime\"}});return s.FIGURE_SPACE=\" \",s.PUNCTUATION_SPACE=\" \",s.prototype.init=function(){this._oFormat=r.getCurrencyInstance({showMeasure:!1})},s.prototype.exit=function(){this._oFormat=null,this._$Value=null,this._$Currency=null,this._sLastCurrency=null,this._iLastCurrencyDigits=null,this._bRenderNoValClass=null},s.prototype.onAfterRendering=function(){this.$()&&(this._$Value=this.$().find(\".sapUiUfdCurrencyValue\"),this._$Currency=this.$().find(\".sapUiUfdCurrencyCurrency\"))},s.prototype.setValue=function(t){return this.isBound(\"value\")&&(this._bRenderNoValClass=null==t,this.$()&&this.$().toggleClass(\"sapUiUfdCurrencyNoVal\",this._bRenderNoValClass)),this.setProperty(\"value\",t,!0),this._renderValue(),this},s.prototype.unbindProperty=function(t){e.prototype.unbindProperty.apply(this,arguments),\"value\"===t&&(this._bRenderNoValClass=!1,this.$()&&this.$().toggleClass(\"sapUiUfdCurrencyNoVal\",!1))},s.prototype.setCurrency=function(e){var r,i;return this.setProperty(\"currency\",e,!0),this._renderCurrency(),r=this._oFormat.oLocaleData.getCurrencyDigits(e),t.isNumeric(this._iLastCurrencyDigits)&&this._iLastCurrencyDigits!==r&&(i=!0),this._iLastCurrencyDigits=r,\"*\"!==this._sLastCurrency&&\"*\"!==e||(i=!0),this._sLastCurrency=e,i&&(this._renderValue(),\"*\"===e&&this.$()&&(this._bRenderNoValClass=!1,this.$().toggleClass(\"sapUiUfdCurrencyNoVal\",!1))),this},s.prototype.setUseSymbol=function(t){return this.setProperty(\"useSymbol\",t,!0),this._renderCurrency(),this},s.prototype.setMaxPrecision=function(t){return this.setProperty(\"maxPrecision\",t,!0),this._renderValue(),this},s.prototype._renderValue=function(){this._$Value&&this._$Value.text(this.getFormattedValue())},s.prototype._renderCurrency=function(){this._$Currency&&this._$Currency.text(this._getCurrency())},s.prototype._getCurrency=function(){return this.getUseSymbol()?this.getCurrencySymbol():this.getCurrency()},s.prototype.getFormattedValue=function(){var e,r,i,n,u=this.getCurrency();return\"*\"===u?\"\":(i=this._oFormat.oLocaleData.getCurrencyDigits(u),e=this.getMaxPrecision(),e=e<=0&&i>0?e-1:e,r=e-i,n=this._oFormat.format(this.getStringValue()||this.getValue(),u),r==e&&e>0&&(n+=s.PUNCTUATION_SPACE),r>0?n=t.sap.padRight(n,s.FIGURE_SPACE,n.length+r):r<0&&(n=n.substr(0,n.length+r)),n)},s.prototype.getCurrencySymbol=function(){return this._oFormat.oLocaleData.getCurrencySymbol(this.getCurrency())},s.prototype.getAccessibilityInfo=function(){return this._bRenderNoValClass?{}:{description:(this.getFormattedValue()||\"\")+\" \"+(this.getCurrency()||\"\").trim()}},s});",
	"sap/ui/unified/CurrencyRenderer.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([],function(){\"use strict\";var e={};return e.render=function(e,r){var t=r.getTooltip_AsString();e.write(\"<div\"),e.writeControlData(r),t&&e.writeAttributeEscaped(\"title\",t),e.addClass(\"sapUiUfdCurrency\"),r._bRenderNoValClass&&e.addClass(\"sapUiUfdCurrencyNoVal\"),e.writeClasses(),e.write(\">\"),e.write(\"<div\"),e.addClass(\"sapUiUfdCurrencyAlign\"),e.writeClasses(),e.write(\">\"),e.write(\"<span\"),e.writeAttribute(\"dir\",\"ltr\"),e.addClass(\"sapUiUfdCurrencyValue\"),e.writeClasses(),e.write(\">\"),e.writeEscaped(r.getFormattedValue()),e.write(\"</span>\"),e.write(\"<span\"),e.addClass(\"sapUiUfdCurrencyCurrency\"),e.writeClasses(),e.write(\">\"),e.writeEscaped(r._getCurrency()),e.write(\"</span>\"),e.write(\"</div>\"),e.write(\"</div>\")},e},!0);",
	"sap/ui/unified/DateRange.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"sap/ui/core/Element\",\"./library\",\"sap/ui/unified/calendar/CalendarUtils\"],function(e,t,a){\"use strict\";var r=e.extend(\"sap.ui.unified.DateRange\",{metadata:{library:\"sap.ui.unified\",properties:{startDate:{type:\"object\",group:\"Misc\",defaultValue:null},endDate:{type:\"object\",group:\"Misc\",defaultValue:null}}}});return r.prototype.setStartDate=function(e){if(e){a._checkJSDateObject(e);var t=e.getFullYear();a._checkYearInValidRange(t)}return this.setProperty(\"startDate\",e),this},r.prototype.setEndDate=function(e){if(e){a._checkJSDateObject(e);var t=e.getFullYear();a._checkYearInValidRange(t)}return this.setProperty(\"endDate\",e),this},r});",
	"sap/ui/unified/DateTypeRange.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"./DateRange\",\"./library\"],function(e,a){\"use strict\";var i=a.CalendarDayType;return e.extend(\"sap.ui.unified.DateTypeRange\",{metadata:{library:\"sap.ui.unified\",properties:{type:{type:\"sap.ui.unified.CalendarDayType\",group:\"Appearance\",defaultValue:i.Type01}}}})});",
	"sap/ui/unified/FileUploader.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/core/Control\",\"./library\",\"sap/ui/core/LabelEnablement\",\"sap/ui/core/library\",\"sap/ui/Device\",\"./FileUploaderRenderer\",\"sap/ui/core/EnabledPropagator\",\"jquery.sap.keycodes\"],function(e,t,i,s,o,r,a,l){\"use strict\";var n=o.ValueState,p=t.extend(\"sap.ui.unified.FileUploader\",{metadata:{interfaces:[\"sap.ui.core.IFormContent\",\"sap.ui.unified.IProcessableBlobs\"],library:\"sap.ui.unified\",designtime:\"sap/ui/unified/designtime/FileUploader.designtime\",properties:{value:{type:\"string\",group:\"Data\",defaultValue:\"\"},enabled:{type:\"boolean\",group:\"Behavior\",defaultValue:!0},uploadUrl:{type:\"sap.ui.core.URI\",group:\"Data\",defaultValue:\"\"},name:{type:\"string\",group:\"Data\",defaultValue:null},width:{type:\"sap.ui.core.CSSSize\",group:\"Misc\",defaultValue:\"\"},uploadOnChange:{type:\"boolean\",group:\"Behavior\",defaultValue:!1},additionalData:{type:\"string\",group:\"Data\",defaultValue:null},sameFilenameAllowed:{type:\"boolean\",group:\"Behavior\",defaultValue:!1},buttonText:{type:\"string\",group:\"Misc\",defaultValue:null},fileType:{type:\"string[]\",group:\"Data\",defaultValue:null},multiple:{type:\"boolean\",group:\"Behavior\",defaultValue:!1},maximumFileSize:{type:\"float\",group:\"Data\",defaultValue:null},mimeType:{type:\"string[]\",group:\"Data\",defaultValue:null},sendXHR:{type:\"boolean\",group:\"Behavior\",defaultValue:!1},placeholder:{type:\"string\",group:\"Appearance\",defaultValue:null},style:{type:\"string\",group:\"Appearance\",defaultValue:null},buttonOnly:{type:\"boolean\",group:\"Appearance\",defaultValue:!1},useMultipart:{type:\"boolean\",group:\"Behavior\",defaultValue:!0},maximumFilenameLength:{type:\"int\",group:\"Data\",defaultValue:null},valueState:{type:\"sap.ui.core.ValueState\",group:\"Data\",defaultValue:n.None},valueStateText:{type:\"string\",group:\"Misc\",defaultValue:null},icon:{type:\"sap.ui.core.URI\",group:\"Appearance\",defaultValue:\"\"},iconHovered:{type:\"sap.ui.core.URI\",group:\"Appearance\",defaultValue:\"\"},iconSelected:{type:\"sap.ui.core.URI\",group:\"Appearance\",defaultValue:\"\"},iconFirst:{type:\"boolean\",group:\"Appearance\",defaultValue:!0},iconOnly:{type:\"boolean\",group:\"Appearance\",defaultValue:!1}},aggregations:{parameters:{type:\"sap.ui.unified.FileUploaderParameter\",multiple:!0,singularName:\"parameter\"},headerParameters:{type:\"sap.ui.unified.FileUploaderParameter\",multiple:!0,singularName:\"headerParameter\"},xhrSettings:{type:\"sap.ui.unified.FileUploaderXHRSettings\",multiple:!1}},events:{change:{parameters:{newValue:{type:\"string\"},files:{type:\"object[]\"}}},uploadComplete:{parameters:{fileName:{type:\"string\"},response:{type:\"string\"},readyStateXHR:{type:\"string\"},status:{type:\"string\"},responseRaw:{type:\"string\"},headers:{type:\"object\"},requestHeaders:{type:\"object[]\"}}},typeMissmatch:{parameters:{fileName:{type:\"string\"},fileType:{type:\"string\"},mimeType:{type:\"string\"}}},fileSizeExceed:{parameters:{fileName:{type:\"string\"},fileSize:{type:\"string\"}}},fileAllowed:{},uploadProgress:{parameters:{lengthComputable:{type:\"boolean\"},loaded:{type:\"float\"},total:{type:\"float\"},fileName:{type:\"string\"},requestHeaders:{type:\"object[]\"}}},uploadAborted:{parameters:{fileName:{type:\"string\"},requestHeaders:{type:\"object[]\"}}},filenameLengthExceed:{parameters:{fileName:{type:\"string\"}}},uploadStart:{parameters:{fileName:{type:\"string\"},requestHeaders:{type:\"object[]\"}}}}}});return l.call(p.prototype),p.prototype.init=function(){if(this.oFilePath=i.FileUploaderHelper.createTextField(this.getId()+\"-fu_input\"),this.oBrowse=i.FileUploaderHelper.createButton(),this.oFilePath.setParent(this),this.oBrowse.setParent(this),this.oFileUpload=null,this.bMobileLib=\"sap.m.Button\"==this.oBrowse.getMetadata().getName(),this.getIconOnly()?this.oBrowse.setTooltip(this.getBrowseText()):this.oBrowse.setText(this.getBrowseText()),sap.ui.getCore().getConfiguration().getAccessibility()){if(!p.prototype._sAccText){var e=sap.ui.getCore().getLibraryResourceBundle(\"sap.ui.unified\");p.prototype._sAccText=e.getText(\"FILEUPLOAD_ACC\")}this.oBrowse.addAriaDescribedBy&&this.oBrowse.addAriaDescribedBy(this.getId()+\"-AccDescr\")}},p.prototype.setButtonText=function(e){return this.setProperty(\"buttonText\",e,!1),this.getIconOnly()?this.oBrowse.setTooltip(e||this.getBrowseText()):this.oBrowse.setText(e||this.getBrowseText()),this},p.prototype.setIcon=function(e){return this.oBrowse.setIcon(e),this.setProperty(\"icon\",e,!1),this},p.prototype.setIconHovered=function(e){return this.setProperty(\"iconHovered\",e,!1),this.oBrowse.setIconHovered&&this.oBrowse.setIconHovered(e),this},p.prototype.setIconSelected=function(e){return this.setProperty(\"iconSelected\",e,!1),this.oBrowse.setIconSelected?this.oBrowse.setIconSelected(e):this.oBrowse.setActiveIcon(e),this},p.prototype.setIconFirst=function(e){return this.oBrowse.setIconFirst(e),this.setProperty(\"iconFirst\",e,!1),this},p.prototype.setIconOnly=function(e){return this.setProperty(\"iconOnly\",e,!1),e?(this.oBrowse.setText(\"\"),this.oBrowse.setTooltip(this.getButtonText()||this.getBrowseText())):(this.oBrowse.setText(this.getButtonText()||this.getBrowseText()),this.oBrowse.setTooltip(\"\")),this},p.prototype.getIdForLabel=function(){return this.oBrowse.getId()},p.prototype.setFileType=function(e){var t=this._convertTypesToArray(e);return this.setProperty(\"fileType\",t,!1),this},p.prototype.setMimeType=function(e){var t=this._convertTypesToArray(e);return this.setProperty(\"mimeType\",t,!1),this},p.prototype.setTooltip=function(e){var t,i;return this._refreshTooltipBaseDelegate(e),this.setAggregation(\"tooltip\",e,!0),this.oFileUpload&&\"string\"==typeof e&&(t=this.getTooltip_AsString(),i=this.$().find(\".sapUiFupInputMask\")[0],t?(this.oFileUpload.setAttribute(\"title\",t),i&&i.setAttribute(\"title\",t)):(this.oFileUpload.removeAttribute(\"title\"),i&&i.removeAttribute(\"title\"))),this},p.prototype.setXhrSettings=function(e){return this.setAggregation(\"xhrSettings\",e,!0),this},p.prototype._convertTypesToArray=function(e){return\"string\"==typeof e?\"\"===e?[]:e.split(\",\").map(function(e){return e.trim()}):e},p.prototype.exit=function(){this.oFilePath.destroy(),this.oBrowse.destroy(),this.oIFrameRef&&(e(this.oIFrameRef).unbind(),sap.ui.getCore().getStaticAreaRef().removeChild(this.oIFrameRef),this.oIFrameRef=null)},p.prototype.onBeforeRendering=function(){var t=sap.ui.getCore().getStaticAreaRef();e(this.oFileUpload).appendTo(t),e(this.oFileUpload).unbind()},p.prototype.onAfterRendering=function(){this.prepareFileUploadAndIFrame(),this._cacheDOMEls(),this._addLabelFeaturesToBrowse(),e(this.oFileUpload).change(e.proxy(this.handlechange,this)),this.bMobileLib?this.oFilePath.$().find(\"input\").attr(\"tabindex\",\"-1\"):this.oFilePath.$().attr(\"tabindex\",\"-1\"),r.browser.internet_explorer&&9==r.browser.version&&this.oBrowse.$().attr(\"tabindex\",\"-1\"),s.isRequired(this)&&this.oBrowse.$().attr(\"aria-required\",\"true\"),e.sap.delayedCall(0,this,this._recalculateWidth),this.oFilePath.$().find(\"input\").removeAttr(\"role\").attr(\"aria-live\",\"polite\"),this.getValueState()==n.Error&&this.oBrowse.$().attr(\"aria-invalid\",\"true\")},p.prototype._cacheDOMEls=function(){this.FUEl=this.getDomRef(\"fu\"),this.FUDataEl=this.getDomRef(\"fu_data\")},p.prototype.onfocusin=function(e){this.oFilePath.shouldValueStateMessageBeOpened&&!this.oFilePath.shouldValueStateMessageBeOpened()||this.openValueStateMessage()},p.prototype.onsapfocusleave=function(t){t.relatedControlId&&e.sap.containsOrEquals(this.getDomRef(),sap.ui.getCore().byId(t.relatedControlId).getFocusDomRef())||this.closeValueStateMessage()},p.prototype._recalculateWidth=function(){this.getWidth()&&(this.getButtonOnly()&&this.oBrowse.getDomRef()&&(this.oBrowse.getDomRef().style.width=this.getWidth()),this._resizeDomElements())},p.prototype.getFocusDomRef=function(){return this.$(\"fu\").get(0)},p.prototype._resizeDomElements=function(){var t=this.getId();this._oBrowseDomRef=this.oBrowse.getDomRef();var i=e(this._oBrowseDomRef),s=i.parent().outerWidth(!0);this._oFilePathDomRef=this.oFilePath.getDomRef();var o=this._oFilePathDomRef,a=this.getWidth();if(\"%\"==a.substr(-1)&&o){for(;o.id!=t;)o.style.width=\"100%\",o=o.parentNode;o.style.width=a}else if(o){o.style.width=a;var l=e(this._oFilePathDomRef),n=l.outerWidth()-s;n<0?(this.oFilePath.getDomRef().style.width=\"0px\",r.browser.internet_explorer||(this.oFileUpload.style.width=i.outerWidth(!0))):this.oFilePath.getDomRef().style.width=n+\"px\"}this.$().removeClass(\"sapUiHidden\")},p.prototype.onresize=function(){this._recalculateWidth()},p.prototype.onThemeChanged=function(){this._recalculateWidth()},p.prototype.setEnabled=function(t){var i=e(this.oFileUpload);return this.setProperty(\"enabled\",t,!0),this.oFilePath.setEnabled(t),this.oBrowse.setEnabled(t),t?i.removeAttr(\"disabled\"):i.attr(\"disabled\",\"disabled\"),this.$().toggleClass(\"sapUiFupDisabled\",!t),this},p.prototype.setValueState=function(t){if(this.setProperty(\"valueState\",t,!0),this.oFilePath.setValueState?this.oFilePath.setValueState(t):e.sap.log.warning(\"Setting the valueState property with the combination of libraries used is not supported.\",this),this.oBrowse.getDomRef()&&(t==n.Error?this.oBrowse.$().attr(\"aria-invalid\",\"true\"):this.oBrowse.$().removeAttr(\"aria-invalid\")),e.sap.containsOrEquals(this.getDomRef(),document.activeElement))switch(t){case n.Error:case n.Warning:case n.Success:this.openValueStateMessage();break;default:this.closeValueStateMessage()}return this},p.prototype.setValueStateText=function(t){return this.oFilePath.setValueStateText?this.oFilePath.setValueStateText(t):e.sap.log.warning(\"Setting the valueStateText property with the combination of libraries used is not supported.\",this),this.setProperty(\"valueStateText\",t,!0)},p.prototype.setUploadUrl=function(e,t){return this.setProperty(\"uploadUrl\",e,!0),this.$(\"fu_form\").attr(\"action\",this.getUploadUrl()),this},p.prototype.setPlaceholder=function(e){return this.setProperty(\"placeholder\",e,!0),this.oFilePath.setPlaceholder(e),this},p.prototype.setStyle=function(e){return this.setProperty(\"style\",e,!0),e&&(\"Transparent\"==e?this.oBrowse.setLite?this.oBrowse.setLite(!0):this.oBrowse.setType(\"Transparent\"):this.oBrowse.setType?this.oBrowse.setType(e):(\"Emphasized\"==e&&(e=\"Emph\"),this.oBrowse.setStyle(e))),this},p.prototype.setValue=function(t,i,s){var o,r=this.getValue();if(r!=t||this.getSameFilenameAllowed()){var a=this.getUploadOnChange()&&t;this.setProperty(\"value\",t,a),this.oFilePath&&(this.oFilePath.setValue(t),this.oBrowse.getDomRef()&&!s&&e.sap.containsOrEquals(this.getDomRef(),document.activeElement)&&this.oBrowse.focus());var l=this.getDomRef(\"fu_form\"),n=this.getDomRef(\"fu_input-inner\");this.oFileUpload&&l&&!t&&(l.reset(),this.getDomRef(\"fu_input\").value=\"\",n&&(n.value=\"\"),e(this.FUDataEl).val(this.getAdditionalData())),i&&(window.File&&(o=this.FUEl.files),this.getSameFilenameAllowed()&&!t||this.fireChange({id:this.getId(),newValue:t,files:o})),a&&this.upload()}return this},p.prototype.clear=function(){var e=this.getDomRef(\"fu_form\");return e&&e.reset(),this.setValue(\"\",!1,!0)},p.prototype.onmousedown=function(e){this.bMobileLib||this.oBrowse.onmousedown(e)},p.prototype.onmouseup=function(e){this.bMobileLib||this.oBrowse.onmouseup(e)},p.prototype.onmouseover=function(t){this.bMobileLib||(e(this.oBrowse.getDomRef()).addClass(\"sapUiBtnStdHover\"),this.oBrowse.onmouseover(t))},p.prototype.onmouseout=function(t){this.bMobileLib||(e(this.oBrowse.getDomRef()).removeClass(\"sapUiBtnStdHover\"),this.oBrowse.onmouseout(t))},p.prototype.setAdditionalData=function(e){this.setProperty(\"additionalData\",e,!0);var t=this.FUDataEl;return t&&(e=this.getAdditionalData()||\"\",t.value=e),this},p.prototype.sendFiles=function(e,t){for(var i=this,s=!0,o=0;o<e.length;o++)if(!e[o].bPosted){s=!1;break}if(s)return void(this.getSameFilenameAllowed()&&this.getUploadOnChange()&&i.setValue(\"\",!0));var a=e[t],l=a.file.name?a.file.name:\"MultipartFile\";if((r.browser.edge||r.browser.internet_explorer)&&a.file.type&&1==a.xhr.readyState){for(var n=a.requestHeaders,p=n?n.length:0,h=!1,u=0;u<p;u++)if(\"Content-Type\"===n[u].name){h=!0;break}if(!h){var d=a.file.type;a.xhr.setRequestHeader(\"Content-Type\",d),a.requestHeaders.push({name:\"Content-Type\",value:d})}}var f=a.requestHeaders,g=function(e){var t={lengthComputable:!!e.lengthComputable,loaded:e.loaded,total:e.total};i.fireUploadProgress({lengthComputable:t.lengthComputable,loaded:t.loaded,total:t.total,fileName:l,requestHeaders:f})};a.xhr.upload.addEventListener(\"progress\",g),a.xhr.onreadystatechange=function(){var e,t,s,o,r,n,p={};n=a.xhr.readyState;var h=a.xhr.status;if(4==a.xhr.readyState){if(a.xhr.responseXML&&(e=a.xhr.responseXML.documentElement.textContent),t=a.xhr.response,s=a.xhr.getAllResponseHeaders()){o=s.split(\"\\r\\n\");for(var u=0;u<o.length;u++)o[u]&&(r=o[u].indexOf(\": \"),p[o[u].substring(0,r)]=o[u].substring(r+2))}i.fireUploadComplete({fileName:l,headers:p,response:e,responseRaw:t,readyStateXHR:n,status:h,requestHeaders:f})}i._bUploading=!1},0===a.xhr.readyState||a.bPosted?(t++,i.sendFiles(e,t)):(a.xhr.send(a.file),a.bPosted=!0,t++,i.sendFiles(e,t))},p.prototype.upload=function(t){if(this.getEnabled()){var i=this.getDomRef(\"fu_form\");try{if(this._bUploading=!0,this.getSendXHR()&&window.File){var s=this.FUEl.files;t?this._sendProcessedFilesWithXHR(s):this._sendFilesWithXHR(s)}else i&&(i.submit(),this._resetValueAfterUploadStart())}catch(t){e.sap.log.error(\"File upload failed:\\n\"+t.message)}}},p.prototype.abort=function(t,i){if(this.getUseMultipart())this._uploadXHR&&this._uploadXHR.abort&&(this._uploadXHR.abort(),this.fireUploadAborted({fileName:null,requestHeaders:null}),e.sap.log.info(\"File upload aborted.\"));else for(var s=this._aXhr.length-1,o=s;o>-1;o--)if(t&&i)for(var r=0;r<this._aXhr[o].requestHeaders.length;r++){var a=this._aXhr[o].requestHeaders[r].name,l=this._aXhr[o].requestHeaders[r].value;if(a==t&&l==i){this._aXhr[o].xhr.abort(),this.fireUploadAborted({fileName:this._aXhr[o].fileName,requestHeaders:this._aXhr[o].requestHeaders}),this._aXhr.splice(o,1),e.sap.log.info(\"File upload aborted.\");break}}else this._aXhr[o].xhr.abort(),this.fireUploadAborted({fileName:this._aXhr[o].fileName,requestHeaders:this._aXhr[o].requestHeaders}),this._aXhr.splice(o,1),e.sap.log.info(\"File upload aborted.\")},p.prototype.onkeypress=function(e){this.onkeydown(e)},p.prototype.onclick=function(t){this.getSameFilenameAllowed()&&this.getEnabled()&&this.setValue(\"\",!0),this.oBrowse.getDomRef()&&e.sap.containsOrEquals(this.getDomRef(),document.activeElement)&&this.oBrowse.focus()},p.prototype.onkeydown=function(t){if(this.getEnabled()){this.getSameFilenameAllowed()&&this.getUploadOnChange()&&this.setValue(\"\",!0);var i=t.keyCode,s=e.sap.KeyCodes;i==s.DELETE||i==s.BACKSPACE?this.oFileUpload&&this.setValue(\"\",!0):i==s.SPACE||i==s.ENTER?r.browser.internet_explorer&&r.browser.version<=9||!this.oFileUpload||(this.oFileUpload.click(),t.preventDefault(),t.stopPropagation()):i!=s.TAB&&i!=s.ESCAPE&&i!=s.SHIFT&&i!=s.F6&&i!=s.PAGE_UP&&i!=s.PAGE_DOWN&&i!=s.END&&i!=s.HOME&&i!=s.ARROW_LEFT&&i!=s.ARROW_UP&&i!=s.ARROW_RIGHT&&i!=s.ARROW_DOWN&&(t.preventDefault(),t.stopPropagation())}},p.prototype._isFilenameTooLong=function(t){var i=this.getMaximumFilenameLength();return 0!==i&&t.length>i&&(e.sap.log.info(\"The filename of \"+t+\" (\"+t.length+\" characters)  is longer than the maximum of \"+i+\" characters.\"),!0)},p.prototype.handlechange=function(t){if(this.oFileUpload&&this.getEnabled()){var i,s,o,a,l=this.getFileType(),n=\"\",p=this.getDomRef(\"fu_form\");if(window.File){var h=t.target.files;if(!this._areFilesAllowed(h))return p.reset(),void this.setValue(\"\",!0,!0);this.fireFileAllowed(),n=this._generateInputValue(h)}else if(l&&l.length>0){i=!0,s=this.oFileUpload.value||\"\",o=s.lastIndexOf(\".\"),a=s.substring(o+1);for(var u=0;u<l.length;u++)a==l[u]&&(i=!1);if(i)return e.sap.log.info(\"File: \"+s+\" is of type \"+a+\". Allowed types are: \"+l+\".\"),this.fireTypeMissmatch({fileName:s,fileType:a}),p.reset(),void this.setValue(\"\",!0,!0);if(this._isFilenameTooLong(s))return this.fireFilenameLengthExceed({fileName:s}),p.reset(),void this.setValue(\"\",!0,!0);s&&this.fireFileAllowed()}var d=this.oFileUpload.value||\"\",f=d.lastIndexOf(\"\\\\\");f>=0&&(d=d.substring(f+1)),this.getMultiple()&&(r.browser.internet_explorer&&r.browser.version<=9||(d=n)),(d||r.browser.chrome)&&this.setValue(d,!0)}},p.prototype._sendFilesWithXHR=function(e){var t,i,s,o,r=this.getXhrSettings();if(e.length>0){t=this.getUseMultipart()?1:e.length,this._aXhr=this._aXhr||[];for(var a=0;a<t;a++){if(this._uploadXHR=new window.XMLHttpRequest,o={xhr:this._uploadXHR,requestHeaders:[]},this._aXhr.push(o),o.xhr.open(\"POST\",this.getUploadUrl(),!0),r&&(o.xhr.withCredentials=r.getWithCredentials()),this.getHeaderParameters())for(var l=this.getHeaderParameters(),n=0;n<l.length;n++)i=l[n].getName(),s=l[n].getValue(),o.requestHeaders.push({name:i,value:s});var p=e[a].name,h=o.requestHeaders;o.fileName=p,o.file=e[a],this.fireUploadStart({fileName:p,requestHeaders:h});for(var u=0;u<h.length&&0!==o.xhr.readyState;u++)i=h[u].name,s=h[u].value,o.xhr.setRequestHeader(i,s)}if(this.getUseMultipart()){for(var d=new window.FormData,f=this.FUEl.name,g=0;g<e.length;g++)this._appendFileToFormData(d,f,e[g]);d.append(\"_charset_\",\"UTF-8\");var c=this.FUDataEl.name;if(this.getAdditionalData()){var m=this.getAdditionalData();d.append(c,m)}else d.append(c,\"\");if(this.getParameters())for(var y=this.getParameters(),F=0;F<y.length;F++){var b=y[F].getName();s=y[F].getValue(),d.append(b,s)}o.file=d,this.sendFiles(this._aXhr,0)}else this.sendFiles(this._aXhr,0);this._bUploading=!1,this._resetValueAfterUploadStart()}return this},p.prototype._appendFileToFormData=function(e,t,i){i instanceof window.Blob&&i.name?e.append(t,i,i.name):e.append(t,i)},p.prototype._sendProcessedFilesWithXHR=function(t){return this.getProcessedBlobsFromArray(t).then(function(e){this._sendFilesWithXHR(e)}.bind(this)).catch(function(t){e.sap.log.error(t.message?t.message:\"no details available\")}),this},p.prototype._areFilesAllowed=function(t){for(var i,s,o,r,a,l=this.getMaximumFileSize(),n=this.getMimeType(),p=this.getFileType(),h=0;h<t.length;h++){i=t[h].name,a=t[h].type,a||(a=\"unknown\");var u=t[h].size/1024/1024;if(l&&u>l)return e.sap.log.info(\"File: \"+i+\" is of size \"+u+\" MB which exceeds the file size limit of \"+l+\" MB.\"),this.fireFileSizeExceed({fileName:i,fileSize:u}),!1;if(this._isFilenameTooLong(i))return this.fireFilenameLengthExceed({fileName:i}),!1;if(n&&n.length>0){for(var d=!0,f=0;f<n.length;f++)(a==n[f]||\"*/*\"==n[f]||a.match(n[f]))&&(d=!1);if(d)return e.sap.log.info(\"File: \"+i+\" is of type \"+a+\". Allowed types are: \"+n+\".\"),this.fireTypeMissmatch({fileName:i,mimeType:a}),!1}if(p&&p.length>0){s=!0,o=i.lastIndexOf(\".\"),r=i.substring(o+1);for(var g=0;g<p.length;g++)r.toLowerCase()==p[g].toLowerCase()&&(s=!1);if(s)return e.sap.log.info(\"File: \"+i+\" is of type \"+r+\". Allowed types are: \"+p+\".\"),this.fireTypeMissmatch({fileName:i,fileType:r}),!1}}return!0},p.prototype._sendFilesFromDragAndDrop=function(e){return this._areFilesAllowed(e)&&this._sendFilesWithXHR(e),this},p.prototype._generateInputValue=function(e){for(var t=\"\",i=0;i<e.length;i++)t=t+'\"'+e[i].name+'\" ';return t},p.prototype.getBrowseText=function(){if(!p.prototype._sBrowseText){var e=sap.ui.getCore().getLibraryResourceBundle(\"sap.ui.unified\");p.prototype._sBrowseText=e.getText(\"FILEUPLOAD_BROWSE\")}return p.prototype._sBrowseText?p.prototype._sBrowseText:\"Browse...\"},p.prototype.getShortenValue=function(){return this.getValue()},p.prototype.prepareFileUploadAndIFrame=function(){if(this.oFileUpload)e(this.oFileUpload).prependTo(this.$().find(\".sapUiFupInputMask\"));else{var t=[];if(t.push(\"<input \"),t.push('type=\"file\" '),t.push('aria-hidden=\"true\" '),this.getName()?this.getMultiple()?r.browser.internet_explorer&&r.browser.version<=9||t.push('name=\"'+this.getName()+'[]\" '):t.push('name=\"'+this.getName()+'\" '):this.getMultiple()?r.browser.internet_explorer&&r.browser.version<=9||t.push('name=\"'+this.getId()+'[]\" '):t.push('name=\"'+this.getId()+'\" '),t.push('id=\"'+this.getId()+'-fu\" '),r.browser.internet_explorer&&9==r.browser.version||t.push('tabindex=\"-1\" '),t.push('size=\"1\" '),this.getTooltip_AsString()?t.push('title=\"'+e.sap.encodeHTML(this.getTooltip_AsString())+'\" '):\"\"!==this.getValue()&&t.push('title=\"'+e.sap.encodeHTML(this.getValue())+'\" '),this.getEnabled()||t.push('disabled=\"disabled\" '),this.getMultiple()&&(r.browser.internet_explorer&&r.browser.version<=9||t.push(\"multiple \")),this.getMimeType()&&window.File){var i=this.getMimeType(),s=i.join(\",\");t.push('accept=\"'+s+'\" ')}t.push(\">\"),this.oFileUpload=e(t.join(\"\")).prependTo(this.$().find(\".sapUiFupInputMask\")).get(0)}if(!this.oIFrameRef){var o=document.createElement(\"iframe\");o.style.display=\"none\",o.id=this.sId+\"-frame\",sap.ui.getCore().getStaticAreaRef().appendChild(o),o.contentWindow.name=this.sId+\"-frame\";var a=this;this._bUploading=!1,e(o).load(function(t){if(a._bUploading){e.sap.log.info(\"File uploaded to \"+a.getUploadUrl());var i;try{i=a.oIFrameRef.contentDocument.body.innerHTML}catch(e){}a.fireUploadComplete({response:i}),a._bUploading=!1}}),this.oIFrameRef=o}},p.prototype.openValueStateMessage=function(){this.oFilePath.openValueStateMessage&&(this.oFilePath.openValueStateMessage(),this.oBrowse.$().addAriaDescribedBy(this.oFilePath.getId()+\"-message\"))},p.prototype.closeValueStateMessage=function(){this.oFilePath.closeValueStateMessage&&(this.oFilePath.closeValueStateMessage(),this.oBrowse.$().removeAriaDescribedBy(this.oFilePath.getId()+\"-message\"))},p.prototype._resetValueAfterUploadStart=function(){e.sap.log.info(\"File uploading to \"+this.getUploadUrl()),this.getSameFilenameAllowed()&&this.getUploadOnChange()&&this.getUseMultipart()&&this.setValue(\"\",!0)},p.prototype._addLabelFeaturesToBrowse=function(){var e;this.oBrowse&&this.oBrowse.$().length&&(e=this.oBrowse.$(),e.attr(\"type', 'button\"),e.click(function(e){e.preventDefault(),e.stopPropagation(),this.FUEl.click()}.bind(this)))},p.prototype.getProcessedBlobsFromArray=function(e){return new Promise(function(t){t(e)})},p});",
	"sap/ui/unified/FileUploaderParameter.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"sap/ui/core/Element\",\"./library\"],function(e,a){\"use strict\";return e.extend(\"sap.ui.unified.FileUploaderParameter\",{metadata:{library:\"sap.ui.unified\",properties:{name:{type:\"string\",group:\"Data\",defaultValue:null},value:{type:\"string\",group:\"Data\",defaultValue:null}}}})});",
	"sap/ui/unified/FileUploaderRenderer.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/unified/library\"],function(e,t){\"use strict\";var i=function(){};return i.render=function(i,r){var a=sap.ui.getCore().getConfiguration().getAccessibility(),d=r.getEnabled();i.write(\"<div\"),i.writeControlData(r),i.addClass(\"sapUiFup\"),r.getWidth()&&i.addClass(\"sapUiHidden\"),r.getButtonOnly()&&i.addClass(\"sapUiFupButtonOnly\");var s=t.FileUploaderHelper.addFormClass();s&&i.addClass(s),d||i.addClass(\"sapUiFupDisabled\"),i.writeClasses(),i.write(' aria-haspopup=\"true\">'),i.write('<form style=\"display:inline-block\" encType=\"multipart/form-data\" method=\"post\"'),i.writeAttribute(\"id\",r.getId()+\"-fu_form\"),i.writeAttributeEscaped(\"action\",r.getUploadUrl()),i.writeAttribute(\"target\",r.getId()+\"-frame\"),i.write(\">\"),i.write(\"<div \"),r.bMobileLib||i.write('class=\"sapUiFupInp\"'),a&&(i.writeAttribute(\"role\",\"textbox\"),i.writeAttribute(\"aria-readonly\",\"true\")),i.write(\">\"),r.getButtonOnly()?i.write('<div class=\"sapUiFupGroup\" border=\"0\" cellPadding=\"0\" cellSpacing=\"0\"><div><div style=\"display:none\">'):i.write('<div class=\"sapUiFupGroup\" border=\"0\" cellPadding=\"0\" cellSpacing=\"0\"><div><div>'),i.renderControl(r.oFilePath),i.write(\"</div><div>\"),i.renderControl(r.oBrowse);var l,n=\"\";r.getTooltip()&&(n=r.getTooltip_AsString());var u=\"\";r.getPlaceholder()&&(u=r.getPlaceholder());var p=\"\";r.getValue()&&(p=r.getValue());var o=\"\";o=r.getButtonText()?r.getButtonText():r.getBrowseText(),l=p?n+\" \"+p+\" \"+o:n+\" \"+u+\" \"+o,i.write('<span id=\"'+r.getId()+'-AccDescr\" class=\"sapUiInvisibleText\" aria-hidden=\"true\">'),i.writeEscaped(l+\" \"+r._sAccText),i.write(\"</span>\"),i.write(\"</div></div></div>\");var w=r.getName()||r.getId();i.write('<div class=\"sapUiFupInputMask\"'),n&&n.length&&i.writeAttributeEscaped(\"title\",n),i.write(\">\"),i.write('<input type=\"hidden\" name=\"_charset_\" aria-hidden=\"true\">'),i.write('<input type=\"hidden\" id=\"'+r.getId()+'-fu_data\" aria-hidden=\"true\"'),i.writeAttributeEscaped(\"name\",w+\"-data\"),i.writeAttributeEscaped(\"value\",r.getAdditionalData()||\"\"),i.write(\">\"),e.each(r.getParameters(),function(e,t){i.write('<input type=\"hidden\" aria-hidden=\"true\" '),i.writeAttributeEscaped(\"name\",t.getName()||\"\"),i.writeAttributeEscaped(\"value\",t.getValue()||\"\"),i.write(\">\")}),i.write(\"</div>\"),i.write(\"</div>\"),i.write(\"</form>\"),i.write(\"</div>\")},i},!0);",
	"sap/ui/unified/FileUploaderXHRSettings.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"sap/ui/core/Element\",\"./library\"],function(e){\"use strict\";return e.extend(\"sap.ui.unified.FileUploaderXHRSettings\",{metadata:{library:\"sap.ui.unified\",properties:{withCredentials:{type:\"boolean\",group:\"Data\",defaultValue:!1}}}})});",
	"sap/ui/unified/library.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/core/Core\",\"sap/ui/base/Object\",\"jquery.sap.dom\",\"jquery.sap.script\"],function(e,i,n){\"use strict\";sap.ui.getCore().initLibrary({name:\"sap.ui.unified\",version:\"904001.7.0.20251118090100_f0htmcm94p\",dependencies:[\"sap.ui.core\"],designtime:\"sap/ui/unified/designtime/library.designtime\",types:[\"sap.ui.unified.CalendarDayType\",\"sap.ui.unified.GroupAppointmentsMode\",\"sap.ui.unified.ContentSwitcherAnimation\",\"sap.ui.unified.ColorPickerMode\"],interfaces:[\"sap.ui.unified.IProcessableBlobs\"],controls:[\"sap.ui.unified.calendar.DatesRow\",\"sap.ui.unified.calendar.Header\",\"sap.ui.unified.calendar.Month\",\"sap.ui.unified.calendar.MonthPicker\",\"sap.ui.unified.calendar.MonthsRow\",\"sap.ui.unified.calendar.TimesRow\",\"sap.ui.unified.calendar.YearPicker\",\"sap.ui.unified.Calendar\",\"sap.ui.unified.CalendarDateInterval\",\"sap.ui.unified.CalendarWeekInterval\",\"sap.ui.unified.CalendarMonthInterval\",\"sap.ui.unified.CalendarTimeInterval\",\"sap.ui.unified.CalendarLegend\",\"sap.ui.unified.CalendarRow\",\"sap.ui.unified.ContentSwitcher\",\"sap.ui.unified.ColorPicker\",\"sap.ui.unified.Currency\",\"sap.ui.unified.FileUploader\",\"sap.ui.unified.Menu\",\"sap.ui.unified.Shell\",\"sap.ui.unified.ShellLayout\",\"sap.ui.unified.ShellOverlay\",\"sap.ui.unified.SplitContainer\"],elements:[\"sap.ui.unified.CalendarAppointment\",\"sap.ui.unified.CalendarLegendItem\",\"sap.ui.unified.DateRange\",\"sap.ui.unified.DateTypeRange\",\"sap.ui.unified.FileUploaderParameter\",\"sap.ui.unified.FileUploaderXHRSettings\",\"sap.ui.unified.MenuItem\",\"sap.ui.unified.MenuItemBase\",\"sap.ui.unified.MenuTextFieldItem\",\"sap.ui.unified.ShellHeadItem\",\"sap.ui.unified.ShellHeadUserItem\"],extensions:{\"sap.ui.support\":{publicRules:!0}}});var a=sap.ui.unified;return a.CalendarDayType={None:\"None\",NonWorking:\"NonWorking\",Type01:\"Type01\",Type02:\"Type02\",Type03:\"Type03\",Type04:\"Type04\",Type05:\"Type05\",Type06:\"Type06\",Type07:\"Type07\",Type08:\"Type08\",Type09:\"Type09\",Type10:\"Type10\",Type11:\"Type11\",Type12:\"Type12\",Type13:\"Type13\",Type14:\"Type14\",Type15:\"Type15\",Type16:\"Type16\",Type17:\"Type17\",Type18:\"Type18\",Type19:\"Type19\",Type20:\"Type20\"},a.StandardCalendarLegendItem={Today:\"Today\",WorkingDay:\"WorkingDay\",NonWorkingDay:\"NonWorkingDay\",Selected:\"Selected\"},a.CalendarIntervalType={Hour:\"Hour\",Day:\"Day\",Month:\"Month\",Week:\"Week\",OneMonth:\"One Month\"},a.GroupAppointmentsMode={Collapsed:\"Collapsed\",Expanded:\"Expanded\"},a.CalendarAppointmentVisualization={Standard:\"Standard\",Filled:\"Filled\"},a.ContentSwitcherAnimation={None:\"None\",Fade:\"Fade\",ZoomIn:\"ZoomIn\",ZoomOut:\"ZoomOut\",Rotate:\"Rotate\",SlideRight:\"SlideRight\",SlideOver:\"SlideOver\"},a.ColorPickerMode={HSV:\"HSV\",HSL:\"HSL\"},a._ContentRenderer=n.extend(\"sap.ui.unified._ContentRenderer\",{constructor:function(e,i,a,r){n.apply(this),this._id=i,this._cntnt=a,this._ctrl=e,this._rm=sap.ui.getCore().createRenderManager(),this._cb=r||function(){}},destroy:function(){this._rm.destroy(),delete this._rm,delete this._id,delete this._cntnt,delete this._cb,delete this._ctrl,this._rerenderTimer&&(e.sap.clearDelayedCall(this._rerenderTimer),delete this._rerenderTimer),n.prototype.destroy.apply(this,arguments)},render:function(){this._rm&&(this._rerenderTimer&&e.sap.clearDelayedCall(this._rerenderTimer),this._rerenderTimer=e.sap.delayedCall(0,this,function(){var i=e.sap.byId(this._id),n=i.length>0;if(n){if(\"string\"==typeof this._cntnt)for(var a=this._ctrl.getAggregation(this._cntnt,[]),r=0;r<a.length;r++)this._rm.renderControl(a[r]);else this._cntnt(this._rm);this._rm.flush(i[0])}this._cb(n)}))}}),a._iNumberOfOpenedShellOverlays=0,a.ColorPickerHelper||(a.ColorPickerHelper={isResponsive:function(){return!1},factory:{createLabel:function(){throw new Error(\"no Label control available\")},createInput:function(){throw new Error(\"no Input control available\")},createSlider:function(){throw new Error(\"no Slider control available\")},createRadioButtonGroup:function(){throw new Error(\"no RadioButtonGroup control available\")},createRadioButtonItem:function(){throw new Error(\"no RadioButtonItem control available\")}},bFinal:!1}),a.FileUploaderHelper||(a.FileUploaderHelper={createTextField:function(e){throw new Error(\"no TextField control available!\")},setTextFieldContent:function(e,i){throw new Error(\"no TextField control available!\")},createButton:function(){throw new Error(\"no Button control available!\")},addFormClass:function(){return null},bFinal:!1}),a.calendar=a.calendar||{},a});",
	"sap/ui/unified/library.support.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/support/library\",\"./rules/FileUploader.support\"],function(e,i,r){\"use strict\";return{name:\"sap.ui.unified\",niceName:\"UI5 Main Library\",ruleset:[r]}},!0);",
	"sap/ui/unified/Menu.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/core/Element\",\"sap/ui/core/Control\",\"sap/ui/Device\",\"sap/ui/core/Popup\",\"./MenuItemBase\",\"./library\",\"sap/ui/core/library\",\"sap/ui/unified/MenuRenderer\",\"jquery.sap.script\",\"jquery.sap.keycodes\",\"jquery.sap.events\"],function(e,t,o,i,s,n,r,a,p){\"use strict\";var u=s.Dock,l=a.OpenState,h=o.extend(\"sap.ui.unified.Menu\",{metadata:{interfaces:[\"sap.ui.core.IContextMenu\"],library:\"sap.ui.unified\",properties:{enabled:{type:\"boolean\",group:\"Behavior\",defaultValue:!0},ariaDescription:{type:\"string\",group:\"Accessibility\",defaultValue:null},maxVisibleItems:{type:\"int\",group:\"Behavior\",defaultValue:0},pageSize:{type:\"int\",group:\"Behavior\",defaultValue:5}},defaultAggregation:\"items\",aggregations:{items:{type:\"sap.ui.unified.MenuItemBase\",multiple:!0,singularName:\"item\"}},associations:{ariaLabelledBy:{type:\"sap.ui.core.Control\",multiple:!0,singularName:\"ariaLabelledBy\"}},events:{itemSelect:{parameters:{item:{type:\"sap.ui.unified.MenuItemBase\"}}},tabPressed:{}}}});return function(r){function a(t){return!!t&&(t=t.$?t.$():e(t),t.closest(\".sapUiSizeCompact,.sapUiSizeCondensed,.sapUiSizeCozy\").hasClass(\"sapUiSizeCozy\"))}function d(e,t){var o=e.getParent();o&&o instanceof n&&o.onSubmenuToggle(t)}function f(e){var t=e.getMaxVisibleItems(),o=document.documentElement.clientHeight,i=e.$();if(t>0)for(var s=e.getItems(),n=0;n<s.length;n++)if(s[n].getDomRef()){o=Math.min(o,s[n].$().outerHeight(!0)*t);break}i.outerHeight(!0)>o?i.css(\"top\",\"0px\").toggleClass(\"sapUiMnuScroll\",!0):$(\"ul\",i).outerHeight(!0)>i.outerHeight(!1)?i.toggleClass(\"sapUiMnuScroll\",!0):i.css(\"max-height\",\"\").toggleClass(\"sapUiMnuScroll\",!1)}/*!\n\t * The following code is taken from\n\t * jQuery UI 1.10.3 - 2013-11-18\n\t * jquery.ui.position.js\n\t *\n\t * http://jqueryui.com\n\t * Copyright 2013 jQuery Foundation and other contributors; Licensed MIT\n\t */\nfunction g(t){var o=e(r);return t.within={element:o,isWindow:!0,offset:o.offset()||{left:0,top:0},scrollLeft:o.scrollLeft(),scrollTop:o.scrollTop(),width:o.width(),height:o.height()},t.collisionPosition={marginLeft:0,marginTop:0},t}h.prototype.bCozySupported=!0,h._DELAY_SUBMENU_TIMER=300,h._DELAY_SUBMENU_TIMER_EXT=400,h.prototype.init=function(){var t=this;this.bOpen=!1,this.oOpenedSubMenu=null,this.oHoveredItem=null,this.oPopup=null,this._bOpenedAsContextMenu=!1,this.fAnyEventHandlerProxy=e.proxy(function(e){var t=this.getRootMenu();t==this&&this.bOpen&&this.getDomRef()&&(\"mousedown\"==e.type||\"touchstart\"==e.type)&&t.handleOuterEvent(this.getId(),e)},this),this.fOrientationChangeHandler=function(){t.close()},this.bUseTopStyle=!1},h.prototype.exit=function(){this.oPopup&&(this.oPopup.detachClosed(this._menuClosed,this),this.oPopup.destroy(),delete this.oPopup),e.sap.unbindAnyEvent(this.fAnyEventHandlerProxy),this._bOrientationChangeBound&&(e(r).unbind(\"orientationchange\",this.fOrientationChangeHandler),this._bOrientationChangeBound=!1),this._resetDelayedRerenderItems(),i.resize.detachHandler(this._handleResizeChange,this)},h.prototype.invalidate=function(e){e instanceof n&&this.getDomRef()?this._delayedRerenderItems():o.prototype.invalidate.apply(this,arguments)},h.prototype.onBeforeRendering=function(){this._resetDelayedRerenderItems()},h.prototype.onAfterRendering=function(){\"sap-ui-static\"!=this.$().parent().attr(\"id\")&&(e.sap.log.error(\"sap.ui.unified.Menu: The Menu is popup based and must not be rendered directly as content of the page.\"),this.close(),this.$().remove());for(var t=this.getItems(),o=0;o<t.length;o++)t[o].onAfterRendering&&t[o].getDomRef()&&t[o].onAfterRendering();this.oHoveredItem&&this.oHoveredItem.hover(!0,this);var i=this,s=this.getDomRef();s&&e(\".sapUiMnuItmTxt\",s).bind(\"mouseenter\",function(){var t,o=this.length>1?this.eq(0):this;if(i.getAggregation(\"items\").forEach(function(e){if(e.sId===o.parentElement.id)return t=e,!1}),!t)return void e.sap.log.warning(\"sap.ui.unified.Menu: menuitem doesn't exist for this dom reference: \"+o.parentElement.id);if(t&&!t.getMetadata().getProperty(\"text\")){var s=e(\".sapUiMnuTfItemLbl\",o);o=s[0]}!t||t.getTooltip()&&0!==t.getTooltip().length||t.getSubmenu()&&0!=t.getSubmenu().getItems().length||((sap.ui.Device.browser.msie?o.offsetWidth+1:o.offsetWidth)<o.scrollWidth&&!e(o).attr(\"title\")?(t.getMetadata().getProperty(\"text\")?e(o).attr(\"title\",t.getText()):t.getMetadata().getProperty(\"label\")&&e(o).attr(\"title\",t.getLabel()),t._titleSetInternally=!0):e(o).attr(\"title\")&&t._titleSetInternally&&o.offsetWidth>=o.scrollWidth&&(e(o).removeAttr(\"title\"),t._titleSetInternally=!1))}),f(this)},h.prototype.onThemeChanged=function(){this.getDomRef()&&this.getPopup().getOpenState()===l.OPEN&&(f(this),this.getPopup()._applyPosition(this.getPopup()._oLastPosition))},h.prototype.setPageSize=function(e){return this.setProperty(\"pageSize\",e,!0)},h.prototype.addItem=function(e){return this.addAggregation(\"items\",e,!!this.getDomRef()),this._delayedRerenderItems(),this},h.prototype.insertItem=function(e,t){return this.insertAggregation(\"items\",e,t,!!this.getDomRef()),this._delayedRerenderItems(),this},h.prototype.removeItem=function(e){return this.removeAggregation(\"items\",e,!!this.getDomRef()),this._delayedRerenderItems(),this},h.prototype.removeAllItems=function(){var e=this.removeAllAggregation(\"items\",!!this.getDomRef());return this._delayedRerenderItems(),e},h.prototype.destroyItems=function(){return this.destroyAggregation(\"items\",!!this.getDomRef()),this._delayedRerenderItems(),this},h.prototype.isItemChecked=function(e){return!1},h.prototype.isItemDeletable=function(e){return!1},h.prototype.isItemHeader=function(e){return!1},h.prototype.isItemOverflowFirst=function(e){return!1},h.prototype.isItemOverflowLast=function(e){return!1},h.prototype._delayedRerenderItems=function(){this.getDomRef()&&(this._resetDelayedRerenderItems(),this._discardOpenSubMenuDelayed(),this._itemRerenderTimer=e.sap.delayedCall(0,this,function(){var e=this.getDomRef();if(e){var t=sap.ui.getCore().createRenderManager();p.renderItems(t,this),t.flush(e),t.destroy(),this.onAfterRendering(),this.getPopup()._applyPosition(this.getPopup()._oLastPosition)}}))},h.prototype._resetDelayedRerenderItems=function(){this._itemRerenderTimer&&(e.sap.clearDelayedCall(this._itemRerenderTimer),delete this._itemRerenderTimer)},h.prototype.open=function(t,o,s,n,a,p,u){if(!this.bOpen){d(this,!0),this.oOpenerRef=o,this.bIgnoreOpenerDOMRef=!1,this.getPopup().open(0,s,n,a,p||\"0 0\",u||\"_sapUiCommonsMenuFlip _sapUiCommonsMenuFlip\",!0),this.bOpen=!0,i.resize.attachHandler(this._handleResizeChange,this);var l=this.getDomRef();e(l).attr(\"tabIndex\",0).focus(),t&&this.setHoveredItem(this.getNextSelectableItem(-1)),e.sap.bindAnyEvent(this.fAnyEventHandlerProxy),i.support.orientation&&this.getRootMenu()===this&&(e(r).bind(\"orientationchange\",this.fOrientationChangeHandler),this._bOrientationChangeBound=!0)}},h.prototype._handleResizeChange=function(){this.getPopup()._applyPosition(this.getPopup()._oLastPosition)},h.prototype.openAsContextMenu=function(o,i){i=i instanceof t?i.getDomRef():i;var s=o.pageX-e(i).offset().left,n=o.pageY-e(i).offset().top,r=sap.ui.getCore().getConfiguration().getRTL(),a=u;r&&(s=i.clientWidth-s),this._iX=o.clientX,this._iY=o.clientY,this._bOpenedAsContextMenu=!0,this.open(!0,i,a.BeginTop,a.BeginTop,i,s+\" \"+n,\"fit\")},h.prototype._handleOpened=function(){var t,o,i,s,n,a,p,u,l,h;this._bOpenedAsContextMenu&&(t=this.$(),o=e(r),i=this._iX,s=this._iY,n=o.scrollLeft()+o.width(),a=o.scrollTop()+o.height(),p=sap.ui.getCore().getConfiguration().getRTL(),u=!1,l=t.width(),h=t.height(),s+h>a&&(s-=h,u=!0),p?n-i+l>n?(i=n-(i+l),u=!0):(i=n-i,u=!0):i+l>n&&(i-=l,u=!0),this._bOpenedAsContextMenu=!1,u&&this.oPopup.setPosition(\"begin top\",\"begin top\",o,i+\" \"+s,\"flip\"))},h.prototype.close=function(){this.bOpen&&!h._dbg&&(this._discardOpenSubMenuDelayed(),d(this,!1),delete this._bFixed,e.sap.unbindAnyEvent(this.fAnyEventHandlerProxy),this._bOrientationChangeBound&&(e(r).unbind(\"orientationchange\",this.fOrientationChangeHandler),this._bOrientationChangeBound=!1),this.bOpen=!1,this.closeSubmenu(),this.setHoveredItem(),e(this.getDomRef()).attr(\"tabIndex\",-1),this.getPopup().close(0),i.resize.detachHandler(this._handleResizeChange,this),this._resetDelayedRerenderItems(),this.$().remove(),this.bOutput=!1,this.isSubMenu()&&(this.getParent().getParent().oOpenedSubMenu=null))},h.prototype._menuClosed=function(){if(this.oOpenerRef){if(!this.bIgnoreOpenerDOMRef)try{this.oOpenerRef.focus()}catch(t){e.sap.log.warning(\"Menu.close cannot restore the focus on opener \"+this.oOpenerRef+\", \"+t)}this.oOpenerRef=void 0}},h.prototype.onclick=function(e){this.selectItem(this.getItemByDomRef(e.target),!1,!(!e.metaKey&&!e.ctrlKey)),e.preventDefault(),e.stopPropagation()},h.prototype.onsapnext=function(t){if(t.keyCode!=e.sap.KeyCodes.ARROW_DOWN)return void(this.oHoveredItem&&this.oHoveredItem.getSubmenu()&&this.checkEnabled(this.oHoveredItem)&&this.openSubmenu(this.oHoveredItem,!0));var o=this.oHoveredItem?this.indexOfAggregation(\"items\",this.oHoveredItem):-1;$(\".sapUiMnuItm\",this.$()).removeClass(\"sasUiMnuItmDisabledFocus\"),$(\".sapUiMnuItm\",this.$()).removeClass(\"sasUiMnuItmDisabledFocusEnabled\");var i=this.getNextSelectableItem(o);i.getEnabled()?this.setHoveredItem(i):(this.oHoveredItem&&this.oHoveredItem.getEnabled()&&this.oHoveredItem.$().addClass(\"sasUiMnuItmDisabledFocusEnabled\"),this.setHoveredItem(i),this._setActiveDescendant(i),i.$().addClass(\"sasUiMnuItmDisabledFocus\")),t.preventDefault(),t.stopPropagation()},h.prototype.onsapprevious=function(t){if(t.keyCode!=e.sap.KeyCodes.ARROW_UP)return this.isSubMenu()&&this.close(),t.preventDefault(),void t.stopPropagation();var o=this.oHoveredItem?this.indexOfAggregation(\"items\",this.oHoveredItem):-1,i=this.getPreviousSelectableItem(o);$(\".sapUiMnuItm\",this.$()).removeClass(\"sasUiMnuItmDisabledFocus\"),$(\".sapUiMnuItm\",this.$()).removeClass(\"sasUiMnuItmDisabledFocusEnabled\"),i.getEnabled()?this.setHoveredItem(i):(this.oHoveredItem&&this.oHoveredItem.getEnabled()&&this.oHoveredItem.$().addClass(\"sasUiMnuItmDisabledFocusEnabled\"),this.setHoveredItem(i),this._setActiveDescendant(i),i.$().addClass(\"sasUiMnuItmDisabledFocus\")),t.preventDefault(),t.stopPropagation()},h.prototype.onsaphome=function(e){var t=this.getNextSelectableItem(-1);$(\".sapUiMnuItm\",this.$()).removeClass(\"sasUiMnuItmDisabledFocus\"),$(\".sapUiMnuItm\",this.$()).removeClass(\"sasUiMnuItmDisabledFocusEnabled\"),t.getEnabled()?this.setHoveredItem(t):(this.oHoveredItem&&this.oHoveredItem.getEnabled()&&this.oHoveredItem.$().addClass(\"sasUiMnuItmDisabledFocusEnabled\"),this.setHoveredItem(t),t.$().addClass(\"sasUiMnuItmDisabledFocus\")),e.preventDefault(),e.stopPropagation()},h.prototype.onsapend=function(e){var t=this.getPreviousSelectableItem(this.getItems().length);$(\".sapUiMnuItm\",this.$()).removeClass(\"sasUiMnuItmDisabledFocus\"),$(\".sapUiMnuItm\",this.$()).removeClass(\"sasUiMnuItmDisabledFocusEnabled\"),t.getEnabled()?this.setHoveredItem(t):(this.oHoveredItem&&this.oHoveredItem.getEnabled()&&this.oHoveredItem.$().addClass(\"sasUiMnuItmDisabledFocusEnabled\"),this.setHoveredItem(t),t.$().addClass(\"sasUiMnuItmDisabledFocus\")),e.preventDefault(),e.stopPropagation()},h.prototype.onsappagedown=function(e){if(this.getPageSize()<1)return void this.onsapend(e);var t=this.oHoveredItem?this.indexOfAggregation(\"items\",this.oHoveredItem):-1;if((t+=this.getPageSize())>=this.getItems().length)return void this.onsapend(e);this.setHoveredItem(this.getNextSelectableItem(t-1)),e.preventDefault(),e.stopPropagation()},h.prototype.onsappageup=function(e){if(this.getPageSize()<1)return void this.onsaphome(e);var t=this.oHoveredItem?this.indexOfAggregation(\"items\",this.oHoveredItem):-1;if((t-=this.getPageSize())<0)return void this.onsaphome(e);this.setHoveredItem(this.getPreviousSelectableItem(t+1)),e.preventDefault(),e.stopPropagation()},h.prototype.onsapselect=function(e){this._sapSelectOnKeyDown=!0,e.preventDefault(),e.stopPropagation()},h.prototype.onkeyup=function(t){if(t.which===e.sap.KeyCodes.CONTEXT_MENU)return t.preventDefault(),void t.stopPropagation();if(this.oHoveredItem&&\"INPUT\"!=e(t.target).prop(\"tagName\")){var o=this.oHoveredItem.getDomRef();e(o).attr(\"tabIndex\",0).focus()}this._sapSelectOnKeyDown&&(this._sapSelectOnKeyDown=!1,e.sap.PseudoEvents.sapselect.fnCheck(t)&&(this.selectItem(this.oHoveredItem,!0,!1),t.preventDefault(),t.stopPropagation()))},h.prototype.onsapbackspace=function(t){\"INPUT\"!=e(t.target).prop(\"tagName\")&&t.preventDefault()},h.prototype.onsapbackspacemodifiers=h.prototype.onsapbackspace,h.prototype.onsapescape=function(e){this.close(),e.preventDefault(),e.stopPropagation()},h.prototype.onsaptabnext=function(e){this.getRootMenu().close(),this.fireTabPressed(e)},h.prototype.onsaptabprevious=function(e){this.getRootMenu().close(),this.fireTabPressed(e)},h.prototype.onmouseover=function(t){if(i.system.desktop){var o=this.getItemByDomRef(t.target);this.bOpen&&o&&o!=this.oHoveredItem&&(this.oOpenedSubMenu&&e.sap.containsOrEquals(this.oOpenedSubMenu.getDomRef(),t.target)||(this.oOpenedSubMenu&&!o.getSubmenu()&&this.closeSubmenu(!0),this.setHoveredItem(o),e.sap.checkMouseEnterOrLeave(t,this.getDomRef())&&(i.browser.msie||i.browser.edge||this.getDomRef().focus()),i.browser.msie&&this.getDomRef().focus(),this._openSubMenuDelayed(o)))}},h.prototype._openSubMenuDelayed=function(t){t&&(this._discardOpenSubMenuDelayed(),this._delayedSubMenuTimer=e.sap.delayedCall(t.getSubmenu()&&this.checkEnabled(t)?h._DELAY_SUBMENU_TIMER:h._DELAY_SUBMENU_TIMER_EXT,this,function(){this.closeSubmenu(),t.getSubmenu()&&this.checkEnabled(t)&&(this.setHoveredItem(t),this.openSubmenu(t,!1,!0))}))},h.prototype._discardOpenSubMenuDelayed=function(t){this._delayedSubMenuTimer&&(e.sap.clearDelayedCall(this._delayedSubMenuTimer),this._delayedSubMenuTimer=null)},h.prototype.onmouseout=function(t){i.system.desktop&&e.sap.checkMouseEnterOrLeave(t,this.getDomRef())&&(this.oOpenedSubMenu&&this.oOpenedSubMenu.getParent()===this.oHoveredItem||this.setHoveredItem(null),this._discardOpenSubMenuDelayed())},h.prototype._checkRelatedControl=function(e){return!1},h.prototype.onsapfocusleave=function(e){this.oOpenedSubMenu||!this.bOpen||this._checkRelatedControl(e)||this.getRootMenu().handleOuterEvent(this.getId(),e)},h.prototype.handleOuterEvent=function(t,o){var i=!1,s=!1,n=null,r=this.getRootMenu(),a=this.getPopup().touchEnabled;if(this.bIgnoreOpenerDOMRef=!1,\"mousedown\"==o.type||\"touchstart\"==o.type){if(a&&(o.isMarked(\"delayedMouseEvent\")||o.isMarked(\"cancelAutoClose\")))return;for(var p=this;p&&!i;)e.sap.containsOrEquals(p.getDomRef(),o.target)&&(i=!0),p=p.oOpenedSubMenu}else if(\"sapfocusleave\"==o.type){if(a||this._checkRelatedControl(o))return;if(o.relatedControlId)for(var p=this;p&&!i;)(p.oOpenedSubMenu&&p.oOpenedSubMenu.getId()==o.relatedControlId||e.sap.containsOrEquals(p.getDomRef(),e.sap.byId(o.relatedControlId).get(0)))&&(i=!0),p=p.oOpenedSubMenu;if(!i)for(this.bIgnoreOpenerDOMRef=!0;r&&!s;)r instanceof sap.m.Popover&&r.isOpen()&&r.oPopup&&r.oPopup.getAutoClose()?(n=r,s=!0):r=r.getParent()}i||this.close(),s&&n&&setTimeout(function(){n.focus()},10)},h.prototype.getItemByDomRef=function(t){for(var o=this.getItems(),i=o.length,s=0;s<i;s++){var n=o[s],r=n.getDomRef();if(e.sap.containsOrEquals(r,t))return n}return null},h.prototype.selectItem=function(e,t,o){if(e&&e instanceof n&&this.checkEnabled(e)){var s=e.getSubmenu();this.isItemHeader(e)||(this.getRootMenu().fireItemSelect({item:e}),s?i.system.desktop||this.oOpenedSubMenu!==s?this.openSubmenu(e,t):this.closeSubmenu():this.getRootMenu().close(),e.fireSelect({item:e,ctrlKey:o}))}},h.prototype.isSubMenu=function(){return this.getParent()&&this.getParent().getParent&&this.getParent().getParent()instanceof h},h.prototype.getRootMenu=function(){for(var e=this;e.isSubMenu();)e=e.getParent().getParent();return e},h.prototype.getMenuLevel=function(){for(var e=1,t=this;t.isSubMenu();)t=t.getParent().getParent(),e++;return e},h.prototype.getPopup=function(){return this.oPopup||(this.oPopup=new s(this,!1,!0,!1),this.oPopup.setDurations(0,0),this.oPopup.attachClosed(this._menuClosed,this),this.oPopup.attachOpened(this._handleOpened,this)),this.oPopup},h.prototype.setHoveredItem=function(t){if(this.oHoveredItem&&this.oHoveredItem.hover(!1,this),!t)return this.oHoveredItem=null,void e(this.getDomRef()).removeAttr(\"aria-activedescendant\");this.oHoveredItem=t,t.hover(!0,this),this._setActiveDescendant(this.oHoveredItem),this.scrollToItem(this.oHoveredItem)},h.prototype._setActiveDescendant=function(e){if(sap.ui.getCore().getConfiguration().getAccessibility()&&e){var t=this;t.$().removeAttr(\"aria-activedescendant\"),setTimeout(function(){t.oHoveredItem===e&&t.$().attr(\"aria-activedescendant\",t.oHoveredItem.getId())},10)}},h.prototype.openSubmenu=function(e,t,o){var i=e.getSubmenu();if(i)if(this.oOpenedSubMenu&&this.oOpenedSubMenu!==i&&this.closeSubmenu(),this.oOpenedSubMenu)this.oOpenedSubMenu._bFixed=o&&this.oOpenedSubMenu._bFixed||!o&&!this.oOpenedSubMenu._bFixed,this.oOpenedSubMenu._bringToFront();else{this.oOpenedSubMenu=i;var n=s.Dock;i.open(t,this,n.BeginTop,n.EndTop,e,\"0 0\")}},h.prototype.closeSubmenu=function(e,t){if(this.oOpenedSubMenu){if(e&&this.oOpenedSubMenu._bFixed)return;t&&(this.oOpenedSubMenu.bIgnoreOpenerDOMRef=!0),this.oOpenedSubMenu.close(),this.oOpenedSubMenu=null}},h.prototype.scrollToItem=function(t){var o=this.getDomRef(),i=t?t.getDomRef():null;if(i&&o){var s=o.scrollTop,n=i.offsetTop,r=e(o).height(),a=e(i).height();s>n?o.scrollTop=n:n+a>s+r&&(o.scrollTop=Math.ceil(n+a-r))}},h.prototype._bringToFront=function(){e.sap.byId(this.getPopup().getId()).mousedown()},h.prototype.checkEnabled=function(e){return e&&e.getEnabled()&&this.getEnabled()},h.prototype.getNextSelectableItem=function(e){for(var t=null,o=this.getItems(),i=e+1;i<o.length;i++)if(o[i].getVisible()){t=o[i];break}if(!t)for(var i=0;i<=e;i++)if(o[i].getVisible()){t=o[i];break}return t},h.prototype.getPreviousSelectableItem=function(e){for(var t=null,o=this.getItems(),i=e-1;i>=0;i--)if(o[i].getVisible()){t=o[i];break}if(!t)for(var i=o.length-1;i>=0&&i>=e;i--)if(o[i].getVisible()){t=o[i];break}return t},h.prototype.setRootMenuTopStyle=function(e){this.getRootMenu().bUseTopStyle=e,h.rerenderMenu(this.getRootMenu())},h.rerenderMenu=function(e){for(var t=e.getItems(),o=0;o<t.length;o++){var i=t[o].getSubmenu();i&&h.rerenderMenu(i)}e.invalidate(),e.rerender()},h.prototype.focus=function(){this.bOpen&&(o.prototype.focus.apply(this,arguments),this._setActiveDescendant(this.oHoveredItem))},h.prototype.isCozy=function(){return!!this.bCozySupported&&(!!this.hasStyleClass(\"sapUiSizeCozy\")||(!!a(this.oOpenerRef)||!!a(this.getParent())))};var c={fit:{left:function(e,t){var o,i=t.within,s=i.isWindow?i.scrollLeft:i.offset.left,n=i.width,r=e.left-t.collisionPosition.marginLeft,a=s-r,p=r+t.collisionWidth-n-s;t.collisionWidth>n?a>0&&p<=0?(o=e.left+a+t.collisionWidth-n-s,e.left+=a-o):e.left=p>0&&a<=0?s:a>p?s+n-t.collisionWidth:s:a>0?e.left+=a:p>0?e.left-=p:e.left=Math.max(e.left-r,e.left)},top:function(e,t){var o,i=t.within,s=i.isWindow?i.scrollTop:i.offset.top,n=t.within.height,r=e.top-t.collisionPosition.marginTop,a=s-r,p=r+t.collisionHeight-n-s;t.collisionHeight>n?a>0&&p<=0?(o=e.top+a+t.collisionHeight-n-s,e.top+=a-o):e.top=p>0&&a<=0?s:a>p?s+n-t.collisionHeight:s:a>0?e.top+=a:p>0?e.top-=p:e.top=Math.max(e.top-r,e.top)}},flip:{left:function(e,t){var o,i,s=t.within,n=s.offset.left+s.scrollLeft,r=s.width,a=s.isWindow?s.scrollLeft:s.offset.left,p=e.left-t.collisionPosition.marginLeft,u=p-a,l=p+t.collisionWidth-r-a,h=\"left\"===t.my[0]?-t.elemWidth:\"right\"===t.my[0]?t.elemWidth:0,d=\"left\"===t.at[0]?t.targetWidth:\"right\"===t.at[0]?-t.targetWidth:0,f=-2*t.offset[0];u<0?((o=e.left+h+d+f+t.collisionWidth-r-n)<0||o<Math.abs(u))&&(e.left+=h+d+f):l>0&&((i=e.left-t.collisionPosition.marginLeft+h+d+f-a)>0||Math.abs(i)<l)&&(e.left+=h+d+f)},top:function(e,t){var o,i,s=t.within,n=s.offset.top+s.scrollTop,r=s.height,a=s.isWindow?s.scrollTop:s.offset.top,p=e.top-t.collisionPosition.marginTop,u=p-a,l=p+t.collisionHeight-r-a,h=\"top\"===t.my[1],d=h?-t.elemHeight:\"bottom\"===t.my[1]?t.elemHeight:0,f=\"top\"===t.at[1]?t.targetHeight:\"bottom\"===t.at[1]?-t.targetHeight:0,g=-2*t.offset[1];u<0?(i=e.top+d+f+g+t.collisionHeight-r-n,e.top+d+f+g>u&&(i<0||i<Math.abs(u))&&(e.top+=d+f+g)):l>0&&(o=e.top-t.collisionPosition.marginTop+d+f+g-a,e.top+d+f+g>l&&(o>0||Math.abs(o)<l)&&(e.top+=d+f+g))}},flipfit:{left:function(){c.flip.left.apply(this,arguments),c.fit.left.apply(this,arguments)},top:function(){c.flip.top.apply(this,arguments),c.fit.top.apply(this,arguments)}}};e.ui.position._sapUiCommonsMenuFlip={left:function(t,o){if(e.ui.position.flipfit)return void e.ui.position.flipfit.left.apply(this,arguments);o=g(o),c.flipfit.left.apply(this,arguments)},top:function(t,o){if(e.ui.position.flipfit)return void e.ui.position.flipfit.top.apply(this,arguments);o=g(o),c.flipfit.top.apply(this,arguments)}}}(window),h});",
	"sap/ui/unified/MenuItem.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"sap/ui/core/IconPool\",\"./MenuItemBase\",\"./library\"],function(t,e,i){\"use strict\";var r=e.extend(\"sap.ui.unified.MenuItem\",{metadata:{library:\"sap.ui.unified\",properties:{text:{type:\"string\",group:\"Appearance\",defaultValue:\"\"},icon:{type:\"sap.ui.core.URI\",group:\"Appearance\",defaultValue:\"\"}},_titleSetInternally:!1}});return t.getIconInfo(\"\",\"\"),r.prototype.render=function(t,e,i,r,s){var n=t,a=e.getSubmenu();n.write(\"<li \");var o=\"sapUiMnuItm\";1==r.iItemNo?o+=\" sapUiMnuItmFirst\":r.iItemNo==r.iTotalItems&&(o+=\" sapUiMnuItmLast\"),i.checkEnabled(e)||(o+=\" sapUiMnuItmDsbl\"),e.getStartsSection()&&(o+=\" sapUiMnuItmSepBefore\"),i.isItemHeader(e)&&(o+=!1===s?\" sasUiMnuItmSingleHeader\":\" sasUiMnuItmMultipleHeaders\"),i.isItemOverflowFirst(e)&&(o+=\" sasToggleButtonOverflowFirst\"),i.isItemOverflowLast(e)&&(o+=\" sasToggleButtonOverflowLast\"),n.writeAttribute(\"class\",o),e.getTooltip_AsString()&&n.writeAttributeEscaped(\"title\",e.getTooltip_AsString()),this.writeAdditionalItemAttributes&&\"function\"==typeof this.writeAdditionalItemAttributes&&this.writeAdditionalItemAttributes(t,e,i,r),n.writeElementData(e),r.bAccessible&&(n.writeAccessibilityState(e,{role:\"menuitem\",disabled:!i.checkEnabled(e),posinset:r.iItemNo,setsize:r.iTotalItems}),a&&(n.writeAttribute(\"aria-haspopup\",!0),n.writeAttribute(\"aria-owns\",a.getId()))),n.write('><div class=\"sapUiMnuItmL\"></div>'),this.renderCheckColumn(t,e,i,r),!1===i.isItemHeader(e)&&(n.write('<div class=\"sapUiMnuItmIco\">'),e.getIcon()&&n.writeIcon(e.getIcon(),null,{title:null}),n.write(\"</div>\")),n.write('<div id=\"'+this.getId()+'-txt\" class=\"sapUiMnuItmTxt\">'),n.writeEscaped(e.getText()),n.write(\"</div>\"),this.renderDeleteColumn(t,e,i,r),n.write('<div id=\"'+this.getId()+'-scuttxt\" class=\"sapUiMnuItmSCut\"></div>'),this.renderSubMenuColumn(t,e,i,r),n.write('<div class=\"sapUiMnuItmR\"></div>'),n.write(\"</li>\")},r.prototype.renderSubMenuColumn=function(t,e,i,r){var s=e.getSubmenu();t.write('<div class=\"sapUiMnuItmSbMnu\">'),s&&t.write('<div class=\"sapUiIconMirrorInRTL\"></div>'),t.write(\"</div>\")},r.prototype.renderCheckColumn=function(t,e,i,r){},r.prototype.renderDeleteColumn=function(t,e,i,r){},r.prototype.hover=function(t,e){this.$().toggleClass(\"sapUiMnuItmHov\",t)},r.prototype.exit=function(){var t=this.getDomRef();t&&jQuery(\".sapUiMnuItmTxt\",t).unbind(\"mouseenter\")},r});",
	"sap/ui/unified/MenuItemBase.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"sap/ui/core/Element\",\"./library\"],function(e,t){\"use strict\";var i=e.extend(\"sap.ui.unified.MenuItemBase\",{metadata:{library:\"sap.ui.unified\",properties:{enabled:{type:\"boolean\",group:\"Behavior\",defaultValue:!0},visible:{type:\"boolean\",group:\"Behavior\",defaultValue:!0},startsSection:{type:\"boolean\",group:\"Behavior\",defaultValue:!1}},defaultAggregation:\"submenu\",aggregations:{submenu:{type:\"sap.ui.unified.Menu\",multiple:!1}},events:{select:{parameters:{item:{type:\"sap.ui.unified.MenuItemBase\"}}}}}});return i.prototype.init=function(){},i.prototype.render=function(e,t,i){var n=e;n.write(\"<li\"),n.writeElementData(t),n.write('><div style=\"white-space:nowrap;display:inline-block;padding:1px;color:black;\" id=\"'+this.getId()+'-txt\">'),n.write(t.getId()),this.getSubmenu()&&n.write(\"&nbsp;&nbsp;->\"),n.write(\"</div></li>\")},i.prototype.hover=function(e,t){this.$(\"txt\").attr(\"style\",e?\"white-space:nowrap;display:inline-block;padding:1px;color:red;\":\"white-space:nowrap;display:inline-block;padding:1px;color:black;\")},i.prototype.onSubmenuToggle=function(e){this.$().toggleClass(\"sapUiMnuItmSubMnuOpen\",e)},i.prototype.onAfterRendering=function(){},i.prototype.onmouseover=function(e){var t=this.getParent();t&&t instanceof sap.ui.unified.Menu&&this.getTooltip()instanceof sap.ui.core.TooltipBase&&t.onmouseover(e)},i});",
	"sap/ui/unified/MenuRenderer.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([],function(){\"use strict\";var e={};return e.render=function(t,i){i.oHoveredItem&&i.indexOfItem(i.oHoveredItem)<0&&(i.oHoveredItem=null),t.write('<div tabindex=\"-1\" hideFocus=\"true\"'),i.getTooltip_AsString()&&t.writeAttributeEscaped(\"title\",i.getTooltip_AsString());var s=sap.ui.getCore().getConfiguration().getAccessibility();s&&(t.writeAccessibilityState(i,{role:\"menu\",disabled:null,labelledby:{value:i.getId()+\"-label\",append:!0}}),i.oHoveredItem&&t.writeAttribute(\"aria-activedescendant\",i.oHoveredItem.getId())),this.addCSSClasses(t,i),i.getRootMenu().isCozy()&&t.addClass(\"sapUiSizeCozy\"),i.bCozySupported&&t.addClass(\"sapUiMnuCozySupport\"),t.writeClasses(),t.writeControlData(i),t.write(\">\"),e.renderItems(t,i),s&&(t.write(\"<span id='\",i.getId(),\"-label' class='sapUiInvisibleText' aria-hidden='true'>\"),t.writeEscaped(i.getAriaDescription()?i.getAriaDescription():\"\"),t.write(\"</span>\")),t.write(\"</div>\")},e.addCSSClasses=function(e,t){e.addClass(\"sapUiMnu\"),t.getRootMenu().bUseTopStyle&&e.addClass(\"sapUiMnuTop\")},e.renderItems=function(e,t){var i=t.getItems(),s=sap.ui.getCore().getConfiguration().getAccessibility();e.write('<ul class=\"sapUiMnuLst');for(var r=!1,a=!1,n=!1,o=!1,d=0,l=0;l<i.length;l++)i[l].getIcon&&i[l].getIcon()&&(r=!0),i[l].getSubmenu()&&(a=!0),t.isItemChecked(i[l])&&(n=!0),t.isItemDeletable(i[l])&&(o=!0),t.isItemHeader(i[l])&&d++;r||e.write(\" sapUiMnuNoIco\"),a||e.write(\" sapUiMnuNoSbMnu\"),n||e.write(\" sapUiMnuNoChk\"),o||e.write(\" sapUiMnuNoDlt\"),e.write('\">');for(var u=0,p=0;p<i.length;p++)i[p].getVisible()&&i[p].render&&u++;for(var c=0,p=0;p<i.length;p++){var g=i[p];g.getVisible()&&g.render&&(c++,g.getStartsSection()&&(e.write(\"<li \"),s&&e.write('role=\"separator\" '),e.write('class=\"sapUiMnuDiv\"><div class=\"sapUiMnuDivL\"></div><hr><div class=\"sapUiMnuDivR\"></div></li>')),g.render(e,g,t,{bAccessible:s,iItemNo:c,iTotalItems:u},d>1))}e.write(\"</ul>\")},e},!0);",
	"sap/ui/unified/MenuTextFieldItem.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/core/ValueStateSupport\",\"./MenuItemBase\",\"./library\",\"sap/ui/core/library\",\"sap/ui/Device\",\"jquery.sap.events\"],function(t,e,i,s,a,n){\"use strict\";var o=a.ValueState,r=i.extend(\"sap.ui.unified.MenuTextFieldItem\",{metadata:{library:\"sap.ui.unified\",properties:{label:{type:\"string\",group:\"Appearance\",defaultValue:null},icon:{type:\"sap.ui.core.URI\",group:\"Appearance\",defaultValue:null},value:{type:\"string\",group:\"Misc\",defaultValue:null},valueState:{type:\"sap.ui.core.ValueState\",group:\"Appearance\",defaultValue:o.None}}}});return function(){r.prototype.render=function(t,e,i,s){var a=t,n=i.checkEnabled(e),o=e.getId(),r=\"sapUiMnuItm sapUiMnuTfItm\";1==s.iItemNo?r+=\" sapUiMnuItmFirst\":s.iItemNo==s.iTotalItems&&(r+=\" sapUiMnuItmLast\"),i.checkEnabled(e)||(r+=\" sapUiMnuItmDsbl\"),e.getStartsSection()&&(r+=\" sapUiMnuItmSepBefore\"),a.write(\"<li \"),a.writeAttribute(\"class\",r),a.writeElementData(e),s.bAccessible&&(a.writeAttribute(\"role\",\"menuitem\"),a.writeAttribute(\"aria-disabled\",!n),a.writeAttribute(\"aria-posinset\",s.iItemNo),a.writeAttribute(\"aria-setsize\",s.iTotalItems)),a.write('><div class=\"sapUiMnuItmL\"></div>'),a.write('<div class=\"sapUiMnuItmIco\">'),e.getIcon()&&a.writeIcon(e.getIcon(),null,{title:null}),a.write(\"</div>\"),a.write('<div id=\"'+o+'-txt\" class=\"sapUiMnuItmTxt\">'),a.write('<label id=\"'+o+'-lbl\" class=\"sapUiMnuTfItemLbl\">'),a.writeEscaped(e.getLabel()||\"\"),a.write(\"</label>\"),a.write('<div id=\"'+o+'-str\" class=\"sapUiMnuTfItmStretch\"></div>'),a.write('<div class=\"sapUiMnuTfItemWrppr\">'),a.write('<input id=\"'+o+'-tf\" tabindex=\"-1\"'),a.writeAttributeEscaped(\"value\",e.getValue()||\"\"),a.writeAttribute(\"class\",n?\"sapUiMnuTfItemTf sapUiMnuTfItemTfEnbl\":\"sapUiMnuTfItemTf sapUiMnuTfItemTfDsbl\"),n||a.writeAttribute(\"disabled\",\"disabled\"),s.bAccessible&&a.writeAccessibilityState(e,{role:\"textbox\",disabled:!n,multiline:!1,autocomplete:\"none\",labelledby:{value:o+\"-lbl\",append:!0}}),a.write(\"></div></div>\"),a.write('<div class=\"sapUiMnuItmR\"></div>'),a.write(\"</li>\")},r.prototype.hover=function(t,e){this.$().toggleClass(\"sapUiMnuItmHov\",t),t&&e.checkEnabled(this)&&(e.closeSubmenu(!1,!0),this.$(\"tf\").focus())},r.prototype.onAfterRendering=function(){this._adaptSizes(),this.setValueState(this.getValueState())},r.prototype.onsapup=function(t){this.getParent().focus(),this.getParent().onsapprevious(t)},r.prototype.onsapdown=function(t){this.getParent().focus(),this.getParent().onsapnext(t)},r.prototype.onsaphome=function(t){this._checkCursorPosForNav(!1)&&(this.getParent().focus(),this.getParent().onsaphome(t))},r.prototype.onsapend=function(t){this._checkCursorPosForNav(!0)&&(this.getParent().focus(),this.getParent().onsapend(t))},r.prototype.onsappageup=function(t){this.getParent().focus(),this.getParent().onsappageup(t)},r.prototype.onsappagedown=function(t){this.getParent().focus(),this.getParent().onsappagedown(t)},r.prototype.onsapescape=function(t){this.getParent().onsapescape(t)},r.prototype.onkeydown=function(t){t.stopPropagation()},r.prototype.onclick=function(t){this.getParent().closeSubmenu(!1,!0),!n.system.desktop&&this.getParent().checkEnabled(this)&&this.focus(),t.stopPropagation()},r.prototype.onkeyup=function(e){if(t.sap.PseudoEvents.sapenter.fnCheck(e)){var i=this.$(\"tf\").val();this.setValue(i),this.getParent().selectItem(this),e.preventDefault(),e.stopPropagation()}},r.prototype.setSubmenu=function(e){return t.sap.log.warning(\"The aggregation 'submenu' is not supported for this type of menu item.\",\"\",\"sap.ui.unified.MenuTextFieldItem\"),this},r.prototype.setLabel=function(t){return this.setProperty(\"label\",t,!0),this.$(\"lbl\").text(t),this._adaptSizes(),this},r.prototype.setValue=function(t){return this.setProperty(\"value\",t,!0),this.$(\"tf\").val(t),this},r.prototype.setValueState=function(t){this.setProperty(\"valueState\",t,!0);var i=this.$(\"tf\");i.toggleClass(\"sapUiMnuTfItemTfErr\",t==o.Error),i.toggleClass(\"sapUiMnuTfItemTfWarn\",t==o.Warning);var s=e.enrichTooltip(this,this.getTooltip_AsString());return this.$().attr(\"title\",s||\"\"),this},r.prototype.getFocusDomRef=function(){var t=this.$(\"tf\");return t.length?t.get(0):null},r.prototype._adaptSizes=function(){var t=this.$(\"tf\"),e=this.$(\"lbl\"),i=e.length?e.get(0).offsetLeft:0;sap.ui.getCore().getConfiguration().getRTL()?t.parent().css({width:\"auto\",right:this.$().outerWidth(!0)-i+(e.outerWidth(!0)-e.outerWidth())+\"px\"}):t.parent().css({width:\"auto\",left:i+e.outerWidth(!0)+\"px\"})},r.prototype._checkCursorPosForNav=function(t){var e=sap.ui.getCore().getConfiguration().getRTL(),i=t?e:!e,s=this.$(\"tf\"),a=s.cursorPos(),n=s.val().length;return e&&(a=n-a),!(!i&&a!=n||i&&0!=a)}}(),r});",
	"sap/ui/unified/rules/FileUploader.support.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/support/library\"],function(e,a){\"use strict\";var i=a.Categories,t=a.Severity,r=a.Audiences;return[{id:\"nonMultipartFileUploadRequiresXHR\",audiences:[r.Control],categories:[i.Usability],enabled:!0,minversion:\"1.28\",title:\"FileUploader: To disable multipart upload you should enable XHR\",description:\"The FileUploader 'useMultipart' property is disabled, but the required 'sendXHR' property is not enabled\",resolution:\"Either enable the 'sendXHR' property of the FileUploader or set the 'useMultipart' property to true\",resolutionurls:[{text:\"API Reference: FileUploader\",href:\"https://sapui5.hana.ondemand.com/#/api/sap.ui.unified.FileUploader\"}],check:function(e,a,i){i.getElementsByClassName(\"sap.ui.unified.FileUploader\").forEach(function(a){if(!a.getUseMultipart()&&!a.getSendXHR()){var i=a.getId(),r=a.getMetadata().getElementName();e.addIssue({severity:t.High,details:\"FileUploader '\"+r+\"' (\"+i+\") multipart upload cannot be disabled\",context:{id:i}})}})}},{id:\"fileUploaderParametersRequireXHRDisabled\",audiences:[r.Control],categories:[i.Usability],enabled:!0,minversion:\"1.28\",title:\"FileUploader: XHR enabled but non-XHR parameter aggregation specified\",description:\"The FileUploader XHR is enabled but parameters are specified into the non-XHR (i.e. form-based) upload 'parameters' aggregation\",resolution:\"Either disable the 'sendXHR' property of the FileUploader, or use the 'headerParameters' aggregation to specify parameters for XHR upload\",resolutionurls:[{text:\"API Reference: FileUploader\",href:\"https://sapui5.hana.ondemand.com/#/api/sap.ui.unified.FileUploader\"}],check:function(e,a,i){i.getElementsByClassName(\"sap.ui.unified.FileUploader\").forEach(function(a){if(a.getParameters()&&a.getSendXHR()){var i=a.getId(),r=a.getMetadata().getElementName();e.addIssue({severity:t.High,details:\"FileUploader '\"+r+\"' (\"+i+\") has enabled XHR but specified non-XHR parameter aggregation\",context:{id:i}})}})}},{id:\"fileUploaderHeaderParametersRequireXHREnabled\",audiences:[r.Control],categories:[i.Usability],enabled:!0,minversion:\"1.28\",title:\"FileUploader: XHR disabled but XHR parameter aggregation specified\",description:\"The FileUploader has specified headerParameters, but the required XHR is disabled\",resolution:\"Either enable the 'sendXHR' property of the FileUploader, or use the 'parameters' aggregation to specify parameters for form-based upload\",resolutionurls:[{text:\"API Reference: FileUploader\",href:\"https://sapui5.hana.ondemand.com/#/api/sap.ui.unified.FileUploader\"}],check:function(e,a,i){i.getElementsByClassName(\"sap.ui.unified.FileUploader\").forEach(function(a){if(a.getHeaderParameters()&&!a.getSendXHR()){var i=a.getId(),r=a.getMetadata().getElementName();e.addIssue({severity:t.High,details:\"FileUploader '\"+r+\"' (\"+i+\") headerParameters require XHR\",context:{id:i}})}})}}]},!0);",
	"sap/ui/unified/Shell.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"./ShellHeader\",\"./ShellLayout\",\"./library\",\"./ShellRenderer\"],function(e,t,r,i){\"use strict\";var a=t.extend(\"sap.ui.unified.Shell\",{metadata:{library:\"sap.ui.unified\",properties:{icon:{type:\"sap.ui.core.URI\",group:\"Appearance\",defaultValue:null},showCurtain:{type:\"boolean\",group:\"Appearance\",defaultValue:null,deprecated:!0},showCurtainPane:{type:\"boolean\",group:\"Appearance\",defaultValue:null,deprecated:!0},searchVisible:{type:\"boolean\",group:\"Appearance\",defaultValue:!0}},aggregations:{curtainContent:{type:\"sap.ui.core.Control\",multiple:!0,singularName:\"curtainContent\"},curtainPaneContent:{type:\"sap.ui.core.Control\",multiple:!0,singularName:\"curtainPaneContent\"},headItems:{type:\"sap.ui.unified.ShellHeadItem\",multiple:!0,singularName:\"headItem\",forwarding:{idSuffix:\"-header\",aggregation:\"headItems\"}},headEndItems:{type:\"sap.ui.unified.ShellHeadItem\",multiple:!0,singularName:\"headEndItem\",forwarding:{idSuffix:\"-header\",aggregation:\"headEndItems\"}},search:{type:\"sap.ui.core.Control\",multiple:!1,forwarding:{idSuffix:\"-header\",aggregation:\"search\"}},user:{type:\"sap.ui.unified.ShellHeadUserItem\",multiple:!1,forwarding:{idSuffix:\"-header\",aggregation:\"user\"}}}}});return a.prototype.init=function(){t.prototype.init.apply(this,arguments),this._header=new e(this.getId()+\"-header\"),this.setHeader(this._header)},a.prototype.exit=function(){t.prototype.exit.apply(this,arguments),this._header.destroy(),delete this._header},a.prototype._getSearchWidth=function(){if(this._header===this.getHeader()&&this._header.getDomRef()){var e=this._header.$(\"hdr-center\").children();if(e.length)return e.width()}return-1},a.prototype.setIcon=function(e){return this.setProperty(\"icon\",e,!0),this._header.setLogo(e),this},a.prototype.getIcon=function(){return this._header.getLogo()},a.prototype.setSearchVisible=function(e){return this.setProperty(\"searchVisible\",e,!0),this._header.setSearchVisible(e),this},a.prototype.getSearchVisible=function(){return this._header.getSearchVisible()},a.prototype.setHeader=function(e){return t.prototype.setHeader.apply(this,[e||this._header])},a.prototype.destroyHeader=function(){return this.getHeader()===this._header?this:t.prototype.destroyHeader.apply(this,[])},a});",
	"sap/ui/unified/ShellHeader.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"./library\",\"sap/ui/core/Control\",\"sap/ui/Device\"],function(e,t,i,a){\"use strict\";var r=i.extend(\"sap.ui.unified.ShellHeader\",{metadata:{properties:{logo:{type:\"sap.ui.core.URI\",defaultValue:\"\"},searchVisible:{type:\"boolean\",defaultValue:!0}},aggregations:{headItems:{type:\"sap.ui.unified.ShellHeadItem\",multiple:!0},headEndItems:{type:\"sap.ui.unified.ShellHeadItem\",multiple:!0},search:{type:\"sap.ui.core.Control\",multiple:!1},user:{type:\"sap.ui.unified.ShellHeadUserItem\",multiple:!1}}},renderer:{render:function(e,t){var i=t.getId();e.write(\"<div\"),e.writeControlData(t),e.writeAttribute(\"class\",\"sapUiUfdShellHeader\"),sap.ui.getCore().getConfiguration().getAccessibility()&&e.writeAttribute(\"role\",\"toolbar\"),e.write(\">\"),e.write(\"<div id='\",i,\"-hdr-begin' class='sapUiUfdShellHeadBegin'>\"),this.renderHeaderItems(e,t,!0),e.write(\"</div>\"),e.write(\"<div id='\",i,\"-hdr-center' class='sapUiUfdShellHeadCenter'>\"),this.renderSearch(e,t),e.write(\"</div>\"),e.write(\"<div id='\",i,\"-hdr-end' class='sapUiUfdShellHeadEnd'>\"),this.renderHeaderItems(e,t,!1),e.write(\"</div>\"),e.write(\"</div>\")},renderSearch:function(e,t){var i=t.getSearch();e.write(\"<div id='\",t.getId(),\"-hdr-search'\"),sap.ui.getCore().getConfiguration().getAccessibility()&&e.writeAttribute(\"role\",\"search\"),e.writeAttribute(\"class\",\"sapUiUfdShellSearch\"+(t.getSearchVisible()?\"\":\" sapUiUfdShellHidden\")),e.write(\"><div>\"),i&&e.renderControl(i),e.write(\"</div></div>\")},renderHeaderItems:function(e,t,i){e.write(\"<div class='sapUiUfdShellHeadContainer'>\");for(var a=i?t.getHeadItems():t.getHeadEndItems(),r=0;r<a.length;r++){e.write(\"<div tabindex='0'\"),e.writeElementData(a[r]),e.addClass(\"sapUiUfdShellHeadItm\"),a[r].getStartsSection()&&e.addClass(\"sapUiUfdShellHeadItmDelim\"),a[r].getShowSeparator()&&e.addClass(\"sapUiUfdShellHeadItmSep\"),a[r].getVisible()||e.addClass(\"sapUiUfdShellHidden\"),a[r].getSelected()&&a[r].getToggleEnabled()&&e.addClass(\"sapUiUfdShellHeadItmSel\"),a[r].getShowMarker()&&e.addClass(\"sapUiUfdShellHeadItmMark\"),e.writeClasses();var s=a[r].getTooltip_AsString();s&&e.writeAttributeEscaped(\"title\",s),sap.ui.getCore().getConfiguration().getAccessibility()&&e.writeAccessibilityState(a[r],{role:\"button\",selected:null,pressed:a[r].getToggleEnabled()?a[r].getSelected():null}),e.write(\"><span></span><div class='sapUiUfdShellHeadItmMarker'><div></div></div></div>\")}var d=t.getUser();if(!i&&d){e.write(\"<div tabindex='0'\"),e.writeElementData(d),e.addClass(\"sapUiUfdShellHeadUsrItm\"),d.getShowPopupIndicator()||e.addClass(\"sapUiUfdShellHeadUsrItmWithoutPopup\"),e.writeClasses();var s=d.getTooltip_AsString();s&&e.writeAttributeEscaped(\"title\",s),sap.ui.getCore().getConfiguration().getAccessibility()&&(e.writeAccessibilityState(d,{role:\"button\"}),d.getShowPopupIndicator()&&e.writeAttribute(\"aria-haspopup\",\"true\")),e.write(\"><span id='\",d.getId(),\"-img' aria-hidden='true' class='sapUiUfdShellHeadUsrItmImg'></span>\"),e.write(\"<span id='\"+d.getId()+\"-name' class='sapUiUfdShellHeadUsrItmName'\");var l=d.getUsername()||\"\";e.writeAttributeEscaped(\"title\",l),e.write(\">\"),e.writeEscaped(l),e.write(\"</span><span class='sapUiUfdShellHeadUsrItmExp' aria-hidden='true'></span></div>\")}e.write(\"</div>\"),i&&this._renderLogo(e,t)},_renderLogo:function(e,t){var i=sap.ui.getCore().getLibraryResourceBundle(\"sap.ui.unified\"),a=i.getText(\"SHELL_LOGO_TOOLTIP\"),r=t._getLogo();e.write(\"<div class='sapUiUfdShellIco'>\"),e.write(\"<img id='\",t.getId(),\"-icon'\"),e.writeAttributeEscaped(\"title\",a),e.writeAttributeEscaped(\"alt\",a),e.write(\"src='\"),e.writeEscaped(r),e.write(\"' style='\",r?\"\":\"display:none;\",\"'>\"),e.write(\"</div>\")}}});return r.prototype.init=function(){var e=this;this._rtl=sap.ui.getCore().getConfiguration().getRTL(),this._handleMediaChange=function(t){e.getDomRef()&&e._refresh()},a.media.attachHandler(this._handleMediaChange,this,a.media.RANGESETS.SAP_STANDARD),this._handleResizeChange=function(t){if(e.getDomRef()&&e.getUser()){this.getUser()._checkAndAdaptWidth(!e.$(\"hdr-search\").hasClass(\"sapUiUfdShellHidden\")&&!!e.getSearch())&&e._refresh()}},a.resize.attachHandler(this._handleResizeChange,this),this.data(\"sap-ui-fastnavgroup\",\"true\",!0)},r.prototype.exit=function(){a.media.detachHandler(this._handleMediaChange,this,a.media.RANGESETS.SAP_STANDARD),delete this._handleMediaChange,a.resize.detachHandler(this._handleResizeChange,this),delete this._handleResizeChange},r.prototype.onAfterRendering=function(){this._refresh(),this.$(\"hdr-center\").toggleClass(\"sapUiUfdShellAnim\",!this._noHeadCenterAnim)},r.prototype.onThemeChanged=function(){this.getDomRef()&&this.invalidate()},r.prototype._getLogo=function(){var t=this.getLogo();return t||(e.sap.require(\"sap.ui.core.theming.Parameters\"),t=sap.ui.core.theming.Parameters._getThemeImage(null,!0)),t},r.prototype._refresh=function(){function t(e){for(var t=0;t<e.length;t++)e[t]._refreshIcon()}t(this.getHeadItems()),t(this.getHeadEndItems());var i=this.getUser(),a=e(\"html\").hasClass(\"sapUiMedia-Std-Phone\"),r=!this.$(\"hdr-search\").hasClass(\"sapUiUfdShellHidden\"),s=this.$(\"icon\");i&&(i._refreshImage(),i._checkAndAdaptWidth(r&&!!this.getSearch())),s.parent().toggleClass(\"sapUiUfdShellHidden\",a&&r&&!!this.getSearch());var d=this.$(\"hdr-end\").outerWidth(),l=this.$(\"hdr-begin\").outerWidth(),n=Math.max(d,l),h=(a&&r?l:n)+\"px\",o=(a&&r?d:n)+\"px\";this.$(\"hdr-center\").css({left:this._rtl?o:h,right:this._rtl?h:o})},r});",
	"sap/ui/unified/ShellHeadItem.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/core/Element\",\"sap/ui/core/IconPool\",\"./library\"],function(e,t,r,a){\"use strict\";function o(){var e=this.$(),t=this.getToggleEnabled(),r=this.getSelected();e.length&&(t?(e.toggleClass(\"sapUiUfdShellHeadItmSel\",r),e.attr(\"aria-pressed\",r)):(e.removeClass(\"sapUiUfdShellHeadItmSel\"),e.removeAttr(\"aria-pressed\")))}var s=t.extend(\"sap.ui.unified.ShellHeadItem\",{metadata:{library:\"sap.ui.unified\",properties:{startsSection:{type:\"boolean\",group:\"Appearance\",defaultValue:!1,deprecated:!0},showSeparator:{type:\"boolean\",group:\"Appearance\",defaultValue:!0},selected:{type:\"boolean\",group:\"Appearance\",defaultValue:!1},toggleEnabled:{type:\"boolean\",group:\"Appearance\",defaultValue:!0},showMarker:{type:\"boolean\",group:\"Appearance\",defaultValue:!1,deprecated:!0},icon:{type:\"sap.ui.core.URI\",group:\"Appearance\",defaultValue:null},visible:{type:\"boolean\",group:\"Appearance\",defaultValue:!0}},associations:{ariaLabelledBy:{type:\"sap.ui.core.Control\",multiple:!0,singularName:\"ariaLabelledBy\"}},events:{press:{}}}});return s.prototype.onclick=function(e){this.firePress(),e.preventDefault()},s.prototype.onsapspace=s.prototype.onclick,s.prototype.onsapenter=s.prototype.onclick,s.prototype.setStartsSection=function(e){return e=!!e,this.setProperty(\"startsSection\",e,!0),this.$().toggleClass(\"sapUiUfdShellHeadItmDelim\",e),this},s.prototype.setShowSeparator=function(e){return e=!!e,this.setProperty(\"showSeparator\",e,!0),this.$().toggleClass(\"sapUiUfdShellHeadItmSep\",e),this},s.prototype.setToggleEnabled=function(e){return this.setProperty(\"toggleEnabled\",!!e,!0),o.apply(this),this},s.prototype.setSelected=function(e){return this.setProperty(\"selected\",!!e,!0),o.apply(this),this},s.prototype.setVisible=function(e){return this.setProperty(\"visible\",!!e),this},s.prototype.setShowMarker=function(e){return e=!!e,this.setProperty(\"showMarker\",e,!0),this.$().toggleClass(\"sapUiUfdShellHeadItmMark\",e),this},s.prototype.setIcon=function(e){return this.setProperty(\"icon\",e,!0),this.getDomRef()&&this._refreshIcon(),this},s.prototype._refreshIcon=function(){var t=e(this.$().children()[0]),a=this.getIcon();if(r.isIconURI(a)){var o=r.getIconInfo(a);t.html(\"\").css(\"style\",\"\"),o&&t.text(o.content).attr(\"role\",\"presentation\").attr(\"aria-label\",o.text||o.name).css(\"font-family\",\"'\"+o.fontFamily+\"'\")}else{var s=this.$(\"img-inner\");0!=s.length&&s.attr(\"src\")==a||t.css(\"style\",\"\").attr(\"aria-label\",null).html(\"<img role='presentation' id='\"+this.getId()+\"-img-inner' src='\"+e.sap.encodeHTML(a)+\"'>\")}},s});",
	"sap/ui/unified/ShellHeadUserItem.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/core/Element\",\"sap/ui/core/IconPool\",\"./library\"],function(e,t,i,a){\"use strict\";var s=t.extend(\"sap.ui.unified.ShellHeadUserItem\",{metadata:{library:\"sap.ui.unified\",properties:{username:{type:\"string\",group:\"Appearance\",defaultValue:\"\"},showPopupIndicator:{type:\"boolean\",group:\"Accessibility\",defaultValue:!0},image:{type:\"sap.ui.core.URI\",group:\"Appearance\",defaultValue:null}},associations:{ariaLabelledBy:{type:\"sap.ui.core.Control\",multiple:!0,singularName:\"ariaLabelledBy\"}},events:{press:{}}}});return i.getIconInfo(\"\",\"\"),s.prototype.onclick=function(e){this.firePress(),e.preventDefault()},s.prototype.onsapspace=s.prototype.onclick,s.prototype.onsapenter=s.prototype.onclick,s.prototype.setImage=function(e){return this.setProperty(\"image\",e,!0),this.getDomRef()&&this._refreshImage(),this},s.prototype._refreshImage=function(){var t=this.$(\"img\"),a=this.getImage();if(a)if(i.isIconURI(a)){var s=i.getIconInfo(a);t.html(\"\").css(\"style\",\"\"),s&&t.text(s.content).attr(\"role\",\"presentation\").attr(\"aria-label\",s.text||s.name).css(\"font-family\",\"'\"+s.fontFamily+\"'\")}else{var r=this.$(\"img-inner\");0!=r.length&&r.attr(\"src\")==a||t.css(\"style\",\"\").attr(\"aria-label\",null).html(\"<img role='presentation' id='\"+this.getId()+\"-img-inner' src='\"+e.sap.encodeHTML(a)+\"'>\")}else t.html(\"\").css(\"style\",\"\").css(\"display\",\"none\")},s.prototype._checkAndAdaptWidth=function(e){if(!this.getDomRef())return!1;var t=this.$(),i=this.$(\"name\"),a=t.width();t.toggleClass(\"sapUiUfdShellHeadUsrItmLimit\",!1);var s=240;return e&&(s=Math.min(s,.5*document.documentElement.clientWidth-225)),s<i.width()&&t.toggleClass(\"sapUiUfdShellHeadUsrItmLimit\",!0),a!=t.width()},s});",
	"sap/ui/unified/ShellLayout.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/Device\",\"sap/ui/core/Control\",\"sap/ui/core/Popup\",\"sap/ui/core/theming/Parameters\",\"./SplitContainer\",\"./library\",\"./ShellLayoutRenderer\",\"jquery.sap.dom\",\"jquery.sap.script\"],function(t,e,n,i,r,o,s,a){\"use strict\";var d=n.extend(\"sap.ui.unified.ShellLayout\",{metadata:{library:\"sap.ui.unified\",properties:{showPane:{type:\"boolean\",group:\"Appearance\",defaultValue:!1},headerHiding:{type:\"boolean\",group:\"Appearance\",defaultValue:!1},headerVisible:{type:\"boolean\",group:\"Appearance\",defaultValue:!0}},defaultAggregation:\"content\",aggregations:{content:{type:\"sap.ui.core.Control\",multiple:!0,singularName:\"content\",forwarding:{idSuffix:\"-container\",aggregation:\"content\"}},paneContent:{type:\"sap.ui.core.Control\",multiple:!0,singularName:\"paneContent\",forwarding:{idSuffix:\"-container\",aggregation:\"secondaryContent\"}},header:{type:\"sap.ui.core.Control\",multiple:!1},canvasSplitContainer:{type:\"sap.ui.unified.SplitContainer\",multiple:!1,visibility:\"hidden\"},curtainSplitContainer:{type:\"sap.ui.unified.SplitContainer\",multiple:!1,visibility:\"hidden\"}}}});return d._SIDEPANE_WIDTH_PHONE=208,d._SIDEPANE_WIDTH_TABLET=208,d._SIDEPANE_WIDTH_DESKTOP=240,d._HEADER_ALWAYS_VISIBLE=!0,d._HEADER_AUTO_CLOSE=!0,d._HEADER_TOUCH_TRESHOLD=15,e.browser.chrome&&e.browser.version<36&&(d._HEADER_TOUCH_TRESHOLD=10),d.prototype.init=function(){if(this._rtl=sap.ui.getCore().getConfiguration().getRTL(),this._animation=sap.ui.getCore().getConfiguration().getAnimation(),this._showHeader=!0,this._showCurtain=!1,this._iHeaderHidingDelay=3e3,this._useStrongBG=!1,this._cont=new o(this.getId()+\"-container\"),this._cont._bRootContent=!0,sap.ui.getCore().getConfiguration().getAccessibility()){var t=this;this._cont.addEventDelegate({onAfterRendering:function(){t._cont.$(\"canvas\").attr(\"role\",\"main\"),t._cont.$(\"pane\").attr(\"role\",\"complementary\")}})}this.setAggregation(\"canvasSplitContainer\",this._cont,!0),this._curtCont=new o(this.getId()+\"-curt-container\"),this._curtCont._bRootContent=!0,this.setAggregation(\"curtainSplitContainer\",this._curtCont,!0),this._setSidePaneWidth(),e.media.attachHandler(this._handleMediaChange,this,e.media.RANGESETS.SAP_STANDARD),e.resize.attachHandler(this._handleResizeChange,this)},d.prototype.exit=function(){e.media.detachHandler(this._handleMediaChange,this,e.media.RANGESETS.SAP_STANDARD),e.resize.detachHandler(this._handleResizeChange,this),delete this._cont,delete this._curtCont},d.prototype.onAfterRendering=function(){function e(e){var i=t.event.fix(e);t.sap.containsOrEquals(n.getDomRef(\"hdr\"),i.target)&&n._timedHideHeader(\"focus\"===i.type)}var n=this;if(window.addEventListener&&!d._HEADER_ALWAYS_VISIBLE){var i=this.getDomRef(\"hdr\");i.addEventListener(\"focus\",e,!0),i.addEventListener(\"blur\",e,!0)}this._refreshAfterRendering()},d.prototype.onThemeChanged=function(){this._refreshAfterRendering()},d.prototype.onfocusin=function(e){var n=this.getId();e.target.id===n+\"-curt-focusDummyOut\"?t.sap.focus(this.$(\"hdrcntnt\").firstFocusableDomRef()):e.target.id===n+\"-main-focusDummyOut\"&&t.sap.focus(this.$(\"curtcntnt\").firstFocusableDomRef())},function(){function t(t){if(void 0!==t._startY&&void 0!==t._currY){var e=t._currY-t._startY;Math.abs(e)>d._HEADER_TOUCH_TRESHOLD&&(t._doShowHeader(e>0),t._startY=t._currY)}}e.support.touch&&(d._HEADER_ALWAYS_VISIBLE=!1,d.prototype.ontouchstart=function(t){this._startY=t.touches[0].pageY,this._startY>96&&(this._startY=void 0),this._currY=this._startY},d.prototype.ontouchend=function(e){t(this),this._startY=void 0,this._currY=void 0},d.prototype.ontouchcancel=d.prototype.ontouchend,d.prototype.ontouchmove=function(e){this._currY=e.touches[0].pageY,t(this)})}(),d.prototype.setHeaderHiding=function(t){return t=!!t,this._mod(function(e){return this.setProperty(\"headerHiding\",t,e)},function(){this._doShowHeader(!t||this._showHeader)})},d.prototype.setHeaderHidingDelay=function(t){return this._iHeaderHidingDelay=t,this},d.prototype.getHeaderHidingDelay=function(){return this._iHeaderHidingDelay},d.prototype.getShowPane=function(){return this._cont.getShowSecondaryContent()},d.prototype.setShowPane=function(t){return this._cont.setShowSecondaryContent(t),this.setProperty(\"showPane\",!!t,!0),this},d.prototype.setShowCurtainPane=function(t){return this._curtCont.setShowSecondaryContent(t),this},d.prototype.getShowCurtainPane=function(){return this._curtCont.getShowSecondaryContent()},d.prototype.setHeaderVisible=function(t){return t=!!t,this.setProperty(\"headerVisible\",t,!0),this.$().toggleClass(\"sapUiUfdShellNoHead\",!t),this},d.prototype.setShowCurtain=function(t){return t=!!t,this._mod(function(e){return this._showCurtain=t,this},function(){if(this.$(\"main-focusDummyOut\").attr(\"tabindex\",t?0:-1),this.$().toggleClass(\"sapUiUfdShellCurtainHidden\",!t).toggleClass(\"sapUiUfdShellCurtainVisible\",t),t){var e=i.getNextZIndex();this.$(\"curt\").css(\"z-index\",e+1),this.$(\"hdr\").css(\"z-index\",e+3),this.$(\"brand\").css(\"z-index\",e+7),this.$().toggleClass(\"sapUiUfdShellCurtainClosed\",!1)}this._timedCurtainClosed(t),this._doShowHeader(!0)})},d.prototype.getShowCurtain=function(){return this._showCurtain},d.prototype.setHeader=function(t){if(this.setAggregation(\"header\",t,!0),t=this.getHeader(),this.getDomRef())if(t){var e=sap.ui.getCore().createRenderManager();e.renderControl(t),e.flush(this.getDomRef(\"hdrcntnt\")),e.destroy()}else this.$(\"hdrcntnt\").html(\"\");return this},d.prototype.destroyHeader=function(){return this.destroyAggregation(\"header\",!0),this.$(\"hdrcntnt\").html(\"\"),this},d.prototype.getCurtainContent=function(){return this._curtCont.getContent()},d.prototype.insertCurtainContent=function(t,e){return this._curtCont.insertContent(t,e),this},d.prototype.addCurtainContent=function(t){return this._curtCont.addContent(t),this},d.prototype.removeCurtainContent=function(t){return this._curtCont.removeContent(t)},d.prototype.removeAllCurtainContent=function(){return this._curtCont.removeAllContent()},d.prototype.destroyCurtainContent=function(){return this._curtCont.destroyContent(),this},d.prototype.indexOfCurtainContent=function(t){return this._curtCont.indexOfCurtainContent(t)},d.prototype.getCurtainPaneContent=function(){return this._curtCont.getSecondaryContent()},d.prototype.insertCurtainPaneContent=function(t,e){return this._curtCont.insertSecondaryContent(t,e),this},d.prototype.addCurtainPaneContent=function(t){return this._curtCont.addSecondaryContent(t),this},d.prototype.removeCurtainPaneContent=function(t){return this._curtCont.removeSecondaryContent(t)},d.prototype.removeAllCurtainPaneContent=function(){return this._curtCont.removeAllSecondaryContent()},d.prototype.destroyCurtainPaneContent=function(){return this._curtCont.destroySecondaryContent(),this},d.prototype.indexOfCurtainPaneContent=function(t){return this._curtCont.indexOfSecondaryContent(t)},d.prototype._setStrongBackground=function(t){this._useStrongBG=!!t,this.$(\"strgbg\").toggleClass(\"sapUiStrongBackgroundColor\",this._useStrongBG)},d.prototype._mod=function(t,e){var n=!!this.getDomRef(),i=t.apply(this,[n]);return n&&e&&(e instanceof s._ContentRenderer?e.render():e.apply(this)),i},d.prototype._doShowHeader=function(e){var n=this._showHeader;this._showHeader=!this._isHeaderHidingActive()||!!e,this.$().toggleClass(\"sapUiUfdShellHeadHidden\",!this._showHeader).toggleClass(\"sapUiUfdShellHeadVisible\",this._showHeader),this._showHeader&&this._timedHideHeader(),n!=this._showHeader&&this._isHeaderHidingActive()&&t.sap.delayedCall(500,this,function(){try{var e=document.createEvent(\"UIEvents\");e.initUIEvent(\"resize\",!0,!1,window,0),window.dispatchEvent(e)}catch(e){t.sap.log.error(e)}})},d.prototype._timedHideHeader=function(e){this._headerHidingTimer&&(t.sap.clearDelayedCall(this._headerHidingTimer),this._headerHidingTimer=null),e||!d._HEADER_AUTO_CLOSE||!this._isHeaderHidingActive()||this._iHeaderHidingDelay<=0||(this._headerHidingTimer=t.sap.delayedCall(this._iHeaderHidingDelay,this,function(){this._isHeaderHidingActive()&&this._iHeaderHidingDelay>0&&!t.sap.containsOrEquals(this.getDomRef(\"hdr\"),document.activeElement)&&this._doShowHeader(!1)}))},d.prototype._timedCurtainClosed=function(n){if(this._curtainClosedTimer&&(t.sap.clearDelayedCall(this._curtainClosedTimer),this._curtainClosedTimer=null),!n){var i=parseInt(r.get(\"_sap_ui_unified_ShellLayout_AnimDuration\"),10);(!this._animation||e.browser.internet_explorer&&e.browser.version<10)&&(i=0),this._curtainClosedTimer=t.sap.delayedCall(i,this,function(){this._curtainClosedTimer=null,this.$(\"curt\").css(\"z-index\",\"\"),this.$(\"hdr\").css(\"z-index\",\"\"),this.$(\"brand\").css(\"z-index\",\"\"),this.$().toggleClass(\"sapUiUfdShellCurtainClosed\",!0)})}},d.prototype._isHeaderHidingActive=function(){return!(d._HEADER_ALWAYS_VISIBLE||this.getShowCurtain()||!this.getHeaderHiding()||s._iNumberOfOpenedShellOverlays>0||!this.getHeaderVisible())},d.prototype._refreshCSSWorkaround=function(){e.browser.webkit&&e.support.touch&&(this._cssWorkaroundTimer&&(t.sap.clearDelayedCall(this._cssWorkaroundTimer),this._cssWorkaroundTimer=null),this.$(\"css\").remove(),this._cssWorkaroundTimer=t.sap.delayedCall(10,this,function(){this._cssWorkaroundTimer=null,t.sap.log.debug(\"sap.ui.unified.ShellLayout: CSS Workaround applied.\"),t(\"head\").append(\"<link type='text/css' rel='stylesheet' id='\"+this.getId()+\"-css' href='data:text/css;base64,LnNhcFVpVWZkU2hlbGxDaHJvbWVSZXBhaW50e291dGxpbmUtY29sb3I6aW5pdGlhbDt9'/>\"),this._cssWorkaroundTimer=t.sap.delayedCall(100,this,function(){this.$(\"css\").remove()})}))},d.prototype._setSidePaneWidth=function(t){t||(t=e.media.getCurrentRange(e.media.RANGESETS.SAP_STANDARD).name);var n=d[\"_SIDEPANE_WIDTH_\"+t.toUpperCase()]+\"px\";this._cont.setSecondaryContentSize(n),this._curtCont.setSecondaryContentSize(n)},d.prototype._handleMediaChange=function(t){if(!this.getDomRef())return!1;this._setSidePaneWidth(t.name)},d.prototype._handleResizeChange=function(t){},d.prototype._refreshAfterRendering=function(){var t=this.getDomRef();return!!t&&(this._repaint(t),this._timedHideHeader(),!0)},d.prototype._repaint=function(t){if(e.browser.webkit){var n=t.style.display;t.style.display=\"none\",t.offsetHeight,t.style.display=n,this._refreshCSSWorkaround()}},d.prototype._getSearchWidth=function(){return-1},d});",
	"sap/ui/unified/ShellLayoutRenderer.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([],function(){\"use strict\";var i={};return i.render=function(i,e){var a=e.getId();i.write(\"<div\"),i.writeControlData(e),i.addClass(\"sapUiUfdShell\"),e._animation&&i.addClass(\"sapUiUfdShellAnim\"),e.getHeaderVisible()||i.addClass(\"sapUiUfdShellNoHead\"),i.addClass(\"sapUiUfdShellHead\"+(e._showHeader?\"Visible\":\"Hidden\")),e.getShowCurtain()?i.addClass(\"sapUiUfdShellCurtainVisible\"):(i.addClass(\"sapUiUfdShellCurtainHidden\"),i.addClass(\"sapUiUfdShellCurtainClosed\")),i.writeClasses(),i.write(\">\"),i.write(\"<hr id='\",a,\"-brand' class='sapUiUfdShellBrand'>\"),i.write(\"<header id='\",a,\"-hdr'  class='sapUiUfdShellHead'\"),sap.ui.getCore().getConfiguration().getAccessibility()&&i.writeAttribute(\"role\",\"banner\"),i.write(\"><div><div id='\",a,\"-hdrcntnt' class='sapUiUfdShellCntnt'>\"),e.getHeader()&&i.renderControl(e.getHeader()),i.write(\"</div>\",\"</div>\",\"</header>\"),i.write(\"<section id='\",a,\"-curt' class='sapUiUfdShellCntnt sapUiUfdShellCurtain'>\"),i.write(\"<div id='\",a,\"-curtcntnt' class='sapUiUfdShellCntnt'>\"),i.renderControl(e._curtCont),i.write(\"</div>\"),i.write(\"<span id='\",a,\"-curt-focusDummyOut' tabindex='0'></span>\"),i.write(\"</section>\"),i.write(\"<div id='\",a,\"-cntnt' class='sapUiUfdShellCntnt sapUiUfdShellCanvas sapUiGlobalBackgroundColor sapUiGlobalBackgroundColorForce'>\"),i.write(\"<div id='\",a,\"-strgbg' class='sapUiUfdShellBG\"+(e._useStrongBG?\" sapUiStrongBackgroundColor\":\"\")+\"'></div>\"),i.write(\"<div class='sapUiGlobalBackgroundImage sapUiGlobalBackgroundImageForce sapUiUfdShellBG'></div>\"),i.renderControl(e._cont),i.write(\"</div>\"),i.write(\"<span id='\",a,\"-main-focusDummyOut' tabindex='\"+(e.getShowCurtain()?0:-1)+\"'></span>\"),i.write(\"</div>\")},i},!0);",
	"sap/ui/unified/ShellOverlay.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/Device\",\"sap/ui/core/Control\",\"sap/ui/core/Popup\",\"./library\",\"sap/ui/unified/ShellOverlayRenderer\",\"jquery.sap.script\"],function(t,e,i,n,o,r){\"use strict\";var s=i.extend(\"sap.ui.unified.ShellOverlay\",{metadata:{library:\"sap.ui.unified\",defaultAggregation:\"content\",aggregations:{content:{type:\"sap.ui.core.Control\",multiple:!0,singularName:\"content\"},search:{type:\"sap.ui.core.Control\",multiple:!1}},associations:{shell:{type:\"sap.ui.unified.ShellLayout\",multiple:!1},ariaLabelledBy:{type:\"sap.ui.core.Control\",multiple:!0,singularName:\"ariaLabelledBy\"}},events:{closed:{}}}});return s.prototype.open=function(){if(!this._getPopup().isOpen()){this._opening=!0,this._forceShellHeaderVisible(),this._getPopup().setModal(!0,0==n.blStack.length&&this._getAnimActive()?\"sapUiUfdShellOvrlyBly sapUiUfdShellOvrlyBlyTp\":\"\"),this._getPopup().open(0,n.Dock.BeginTop,n.Dock.BeginTop,window,\"0 0\",\"none\");var e=this.getSearch();e&&e.focus(),this._opening=!1,this._getAnimActive()&&t.sap.delayedCall(50,this,function(){t.sap.byId(\"sap-ui-blocklayer-popup\").toggleClass(\"sapUiUfdShellOvrlyBlyTp\",!1)}),t.sap.delayedCall(this._getAnimDuration(!0),this,function(){this.$().toggleClass(\"sapUiUfdShellOvrlyOpening\",!1)})}},s.prototype.close=function(){this._getPopup().isOpen()&&(this.$().toggleClass(\"sapUiUfdShellOvrlyCntntHidden\",!0).toggleClass(\"sapUiUfdShellOvrlyClosing\",!0),this._setSearchWidth(),t.sap.delayedCall(Math.max(this._getAnimDuration(!1)-this._getBLAnimDuration(),0),this,function(){var e=t.sap.byId(\"sap-ui-blocklayer-popup\");1==n.blStack.length&&this._getAnimActive()&&e.hasClass(\"sapUiUfdShellOvrlyBly\")&&e.toggleClass(\"sapUiUfdShellOvrlyBlyTp\",!0)}),t.sap.delayedCall(this._getAnimDuration(!1),this,function(){this._getPopup().close(0),this.$().remove(),this._forceShellHeaderVisible(),this.fireClosed()}))},s.prototype.setShell=function(t){return this.setAssociation(\"shell\",t,!0)},s.prototype.setSearch=function(t){return this.setAggregation(\"search\",t,!0),this.getDomRef()&&this._headRenderer.render(),this},s.prototype.insertContent=function(t,e){var i=this.insertAggregation(\"content\",t,e,!0);return this.getDomRef()&&this._contentRenderer.render(),i},s.prototype.addContent=function(t){var e=this.addAggregation(\"content\",t,!0);return this.getDomRef()&&this._contentRenderer.render(),e},s.prototype.removeContent=function(t){var e=this.removeAggregation(\"content\",t,!0);return this.getDomRef()&&this._contentRenderer.render(),e},s.prototype.removeAllContent=function(){var t=this.removeAllAggregation(\"content\",!0);return this.getDomRef()&&this._contentRenderer.render(),t},s.prototype.destroyContent=function(){var t=this.destroyAggregation(\"content\",!0);return this.getDomRef()&&this._contentRenderer.render(),t},s.prototype.init=function(){this._animOpenDuration=-1,this._animCloseDuration=-1,this._animBlockLayerDuration=-1,this._animation=sap.ui.getCore().getConfiguration().getAnimation(),this._opening=!1;var t=this;this._headRenderer=new o._ContentRenderer(this,this.getId()+\"-hdr-center\",function(e){r.renderSearch(e,t)}),this._contentRenderer=new o._ContentRenderer(this,this.getId()+\"-cntnt\",function(e){r.renderContent(e,t)})},s.prototype.exit=function(){this._popup&&(this._popup.close(0),this._popup.destroy(),this._popup=null),this._getPopup=function(){return null},this._headRenderer.destroy(),delete this._headRenderer,this._contentRenderer.destroy(),delete this._contentRenderer},s.prototype.onAfterRendering=function(){this._opening&&this._setSearchWidth(),t.sap.delayedCall(10,this,function(){this.$().toggleClass(\"sapUiUfdShellOvrlyCntntHidden\",!1),this.$(\"search\").css(\"width\",\"\")})},s.prototype.onclick=function(e){t(e.target).attr(\"id\")===this.getId()+\"-close\"&&(this.close(),e.preventDefault())},s.prototype.onsapspace=s.prototype.onclick,s.prototype.onThemeChanged=function(){this._animOpenDuration=-1,this._animCloseDuration=-1,this._animBlockLayerDuration=-1},s.prototype.onfocusin=function(e){var i,n;e.target.id==this.getId()+\"-focfirst\"?(i=t(\":sapTabbable\",this.$(\"inner\")),n=i.get(i.length-1)):e.target.id==this.getId()+\"-foclast\"&&(i=t(\":sapTabbable\",this.$(\"inner\")),n=i.get(0)),n&&t.sap.focus(n)},s.prototype._getAnimDurationThemeParam=function(t,e){var i=parseInt(sap.ui.core.theming.Parameters.get(t),10);return!this._getAnimActive()&&e&&(i=0),i},s.prototype._getAnimDuration=function(t){if(t&&-1==this._animOpenDuration||!t&&-1==this._animCloseDuration){var e=t?\"Open\":\"Close\";this[\"_anim\"+e+\"Duration\"]=this._getAnimDurationThemeParam(\"_sap_ui_unified_ShellOverlay_\"+e+\"AnimOverAll\",!0)}return t?this._animOpenDuration:this._animCloseDuration},s.prototype._getBLAnimDuration=function(){return-1==this._animBlockLayerDuration&&(this._animBlockLayerDuration=this._getAnimDurationThemeParam(\"_sap_ui_unified_ShellOverlay_BlockLayerAnimDuration\",!0)),this._animBlockLayerDuration},s.prototype._getAnimActive=function(){return!(!this._animation||e.browser.internet_explorer&&e.browser.version<10)},s.prototype._getPopup=function(){return this._popup||(this._popup=new n(this,!0,!1,!1),this._popup._applyPosition=function(e){this._$().css(\"left\",\"0\").css(\"top\",\"0\"),this._oLastPosition=e,this._oLastOfRect=t(window).rect()},this._popup.attachOpened(function(){o._iNumberOfOpenedShellOverlays++}),this._popup.attachClosed(function(){o._iNumberOfOpenedShellOverlays--})),this._popup},s.prototype._getShell=function(){var t=this.getShell();if(t){var e=sap.ui.getCore().byId(t);if(e&&e instanceof sap.ui.unified.ShellLayout)return e}},s.prototype._forceShellHeaderVisible=function(){var t=this._getShell();t&&t._doShowHeader(!0)},s.prototype._getSearchWidth=function(){var t=this._getShell();return t?t._getSearchWidth():-1},s.prototype._setSearchWidth=function(){var t=this._getSearchWidth();if(!(t<=0)){var i=t+\"px\";if(e.browser.safari){var n=this.$(\"hdr-center\").width();i=n>t?Math.round(100*t/n)+\"%\":\"100%\"}this.$(\"search\").css(\"width\",i)}},s});",
	"sap/ui/unified/ShellOverlayRenderer.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([],function(){\"use strict\";var e={};return e.render=function(i,t){i.write(\"<div\"),i.writeControlData(t),i.addClass(\"sapUiUfdShellOvrly\"),t._opening&&(i.addClass(\"sapUiUfdShellOvrlyCntntHidden\"),i.addClass(\"sapUiUfdShellOvrlyOpening\")),t._getAnimActive()&&i.addClass(\"sapUiUfdShellOvrlyAnim\"),i.writeClasses(),sap.ui.getCore().getConfiguration().getAccessibility()&&i.writeAccessibilityState(t,{role:\"dialog\"}),i.write(\"><span id='\",t.getId(),\"-focfirst' tabIndex='0'></span><div id='\",t.getId(),\"-inner'>\"),i.write(\"<header class='sapUiUfdShellOvrlyHead'>\"),i.write(\"<hr class='sapUiUfdShellOvrlyBrand'>\"),i.write(\"<div class='sapUiUfdShellOvrlyHeadCntnt'\"),sap.ui.getCore().getConfiguration().getAccessibility()&&i.writeAttribute(\"role\",\"toolbar\"),i.write(\"><div id='\"+t.getId()+\"-hdr-center' class='sapUiUfdShellOvrlyHeadCenter'>\"),e.renderSearch(i,t),i.write(\"</div>\");var r=sap.ui.getCore().getLibraryResourceBundle(\"sap.ui.unified\"),d=r.getText(\"SHELL_OVERLAY_CLOSE\");i.write(\"<a tabindex='0' href='#' id='\"+t.getId()+\"-close' class='sapUiUfdShellOvrlyHeadClose'\"),i.writeAttributeEscaped(\"title\",d),sap.ui.getCore().getConfiguration().getAccessibility()&&i.writeAttribute(\"role\",\"button\"),i.write(\">\"),i.writeEscaped(d),i.write(\"</a></div></header>\"),i.write(\"<div id='\"+t.getId()+\"-cntnt' class='sapUiUfdShellOvrlyCntnt'>\"),e.renderContent(i,t),i.write(\"</div>\"),i.write(\"</div><span id='\",t.getId(),\"-foclast' tabIndex='0'></span></div>\")},e.renderSearch=function(e,i){var t=i._getSearchWidth(),r=\"\";t>0&&i._opening&&(r=\"style='width:\"+t+\"px'\"),e.write(\"<div id='\"+i.getId()+\"-search' class='sapUiUfdShellOvrlySearch' \"+r+\"><div>\");var d=i.getSearch();d&&e.renderControl(d),e.write(\"</div></div>\")},e.renderContent=function(e,i){e.write(\"<div>\");for(var t=i.getContent(),r=0;r<t.length;r++)e.renderControl(t[r]);e.write(\"</div>\")},e},!0);",
	"sap/ui/unified/ShellRenderer.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"sap/ui/core/Renderer\",\"./ShellLayoutRenderer\"],function(e,r){\"use strict\";return e.extend(r)},!0);",
	"sap/ui/unified/SplitContainer.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/core/Control\",\"sap/ui/core/theming/Parameters\",\"./library\",\"sap/ui/core/library\",\"./SplitContainerRenderer\"],function(t,e,n,o,r,i){\"use strict\";var a=r.Orientation,s=e.extend(\"sap.ui.unified.SplitContainer\",{metadata:{library:\"sap.ui.unified\",properties:{showSecondaryContent:{type:\"boolean\",group:\"Appearance\",defaultValue:null},secondaryContentSize:{type:\"sap.ui.core.CSSSize\",group:\"Appearance\",defaultValue:\"250px\"},secondaryContentWidth:{type:\"sap.ui.core.CSSSize\",group:\"Appearance\",defaultValue:\"250px\",deprecated:!0},orientation:{type:\"sap.ui.core.Orientation\",group:\"Appearance\",defaultValue:a.Horizontal}},defaultAggregation:\"content\",aggregations:{content:{type:\"sap.ui.core.Control\",multiple:!0,singularName:\"content\"},secondaryContent:{type:\"sap.ui.core.Control\",multiple:!0,singularName:\"secondaryContent\"}}}});return function(e){s.prototype.init=function(){this.bRtl=sap.ui.getCore().getConfiguration().getRTL(),this._paneRenderer=new o._ContentRenderer(this,this.getId()+\"-panecntnt\",\"secondaryContent\"),this._canvasRenderer=new o._ContentRenderer(this,this.getId()+\"-canvascntnt\",\"content\"),this._moveContent=!0},s.prototype.exit=function(){this._paneRenderer.destroy(),delete this._paneRenderer,this._canvasRenderer.destroy(),delete this._canvasRenderer,this._closeContentDelayId&&(t.sap.clearDelayedCall(this._closeContentDelayId),delete this._closeContentDelayId),delete this._contentContainer,delete this._secondaryContentContainer},s.prototype.onAfterRendering=function(){this.bRtl=sap.ui.getCore().getConfiguration().getRTL(),this._contentContainer=this.$(\"canvas\"),this._secondaryContentContainer=this.$(\"pane\"),this._applySecondaryContentSize()},s.prototype._applySecondaryContentSize=function(){if(this.getDomRef()){var e,o,r,i,s=this.getOrientation()==a.Vertical,d=this.getSecondaryContentSize(),c=this.getShowSecondaryContent();if(s?(e=\"height\",o=\"width\",r=\"top\",i=this.bRtl?\"right\":\"left\"):(e=\"width\",o=\"height\",r=this.bRtl?\"right\":\"left\",i=\"top\"),this._closeContentDelayId&&(t.sap.clearDelayedCall(this._closeContentDelayId),delete this._closeContentDelayId),this._secondaryContentContainer.css(e,d),this._secondaryContentContainer.css(o,\"\"),this._secondaryContentContainer.css(r,c?\"0\":\"-\"+d),this._secondaryContentContainer.css(i,\"\"),this._moveContent?this._contentContainer.css(r,c?d:\"0\"):this._contentContainer.css(r,\"0\"),c)this._secondaryContentContainer.toggleClass(\"sapUiUfdSplitContSecondClosed\",!1);else{var p=parseInt(n.get(\"_sap_ui_unified_SplitContainer_AnimationDuration\"),10);this._closeContentDelayId=t.sap.delayedCall(p,this,function(){this._secondaryContentContainer.toggleClass(\"sapUiUfdSplitContSecondClosed\",!0)})}}},s.prototype._mod=function(t,e){var n=!!this.getDomRef(),o=t.apply(this,[n]);return n&&e&&e.render(),o},s.prototype.setShowSecondaryContent=function(t){var e=this.getDomRef();return this.setProperty(\"showSecondaryContent\",!!t,e),this._applySecondaryContentSize(),this},s.prototype.setSecondaryContentSize=function(t){return this.setProperty(\"secondaryContentSize\",t,!0),this._applySecondaryContentSize(),this},s.prototype.getSecondaryContentWidth=function(){return t.sap.log.warning('SplitContainer: Use of deprecated property \"SecondaryContentWidth\", please use \"SecondaryContentSize\" instead.'),this.getSecondaryContentSize.apply(this,arguments)},s.prototype.setSecondaryContentWidth=function(){return t.sap.log.warning('SplitContainer: Use of deprecated property \"SecondaryContentWidth\", please use \"SecondaryContentSize\" instead.'),this.setSecondaryContentSize.apply(this,arguments)},s.prototype.insertContent=function(t,e){return this._mod(function(n){return this.insertAggregation(\"content\",t,e,n)},this._canvasRenderer)},s.prototype.addContent=function(t){return this._mod(function(e){return this.addAggregation(\"content\",t,e)},this._canvasRenderer)},s.prototype.removeContent=function(t){return this._mod(function(e){return this.removeAggregation(\"content\",t,e)},this._canvasRenderer)},s.prototype.removeAllContent=function(){return this._mod(function(t){return this.removeAllAggregation(\"content\",t)},this._canvasRenderer)},s.prototype.destroyContent=function(){return this._mod(function(t){return this.destroyAggregation(\"content\",t)},this._canvasRenderer)},s.prototype.insertSecondaryContent=function(t,e){return this._mod(function(n){return this.insertAggregation(\"secondaryContent\",t,e,n)},this._paneRenderer)},s.prototype.addSecondaryContent=function(t){return this._mod(function(e){return this.addAggregation(\"secondaryContent\",t,e)},this._paneRenderer)},s.prototype.removeSecondaryContent=function(t){return this._mod(function(e){return this.removeAggregation(\"secondaryContent\",t,e)},this._paneRenderer)},s.prototype.removeAllSecondaryContent=function(){return this._mod(function(t){return this.removeAllAggregation(\"secondaryContent\",t)},this._paneRenderer)},s.prototype.destroySecondaryContent=function(){return this._mod(function(t){return this.destroyAggregation(\"secondaryContent\",t)},this._paneRenderer)}}(window),s});",
	"sap/ui/unified/SplitContainerRenderer.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"sap/ui/core/library\"],function(t){\"use strict\";var e=t.Orientation,n={};return n.render=function(t,n){var i=n.getId(),a=n.getOrientation()==e.Vertical;t.write(\"<div\"),t.writeControlData(n),t.addClass(\"sapUiUfdSpltCont\"),t.addClass(\"sapUiUfdSpltCont\"+(a?\"V\":\"H\")),sap.ui.getCore().getConfiguration().getAnimation()&&t.addClass(\"sapUiUfdSpltContAnim\"),n.getShowSecondaryContent()||t.addClass(\"sapUiUfdSpltContPaneHidden\"),t.writeClasses(),t.write(\">\");var o=i+\"-canvas\";t.write(\"<section id='\",o,\"' class='sapUiUfdSpltContCanvas'>\"),this.renderContent(t,o,n.getContent(),n._bRootContent),t.write(\"</section>\");var r=i+\"-pane\",d=n.getShowSecondaryContent()?n.getSecondaryContentSize():\"0\";t.write(\"<aside id='\",r,\"' style='width:\",d,\"'\"),t.addClass(\"sapUiUfdSpltContPane\"),n.getShowSecondaryContent()||t.addClass(\"sapUiUfdSplitContSecondClosed\"),t.writeClasses(),t.write(\">\"),this.renderContent(t,r,n.getSecondaryContent(),n._bRootContent),t.write(\"</aside>\"),t.write(\"</div>\")},n.renderContent=function(t,e,n,i){t.write(\"<div id='\",e,\"cntnt' class='sapUiUfdSpltContCntnt'\"),i&&t.writeAttribute(\"data-sap-ui-root-content\",\"true\"),t.write(\">\");for(var a=0;a<n.length;a++)t.renderControl(n[a]);t.write(\"</div>\")},n},!0);",
	"sap/ui/unified/designtime/CalendarDateInterval.create.fragment.xml": "<core:FragmentDefinition\n\txmlns=\"sap.ui.unified\"\n\txmlns:core=\"sap.ui.core\"><CalendarDateInterval days=\"21\" /></core:FragmentDefinition>",
	"sap/ui/unified/designtime/CalendarLegend.create.fragment.xml": "<core:FragmentDefinition\n\txmlns=\"sap.ui.unified\"\n\txmlns:core=\"sap.ui.core\"><CalendarLegend><items><CalendarLegendItem text=\"Legend Item 1\" type=\"Type01\" /><CalendarLegendItem text=\"Legend Item 2\" type=\"Type02\" /><CalendarLegendItem text=\"Legend Item 3\" type=\"Type03\" /></items></CalendarLegend></core:FragmentDefinition>",
	"sap/ui/unified/designtime/Currency.create.fragment.xml": "<core:FragmentDefinition\n\txmlns=\"sap.ui.unified\"\n\txmlns:core=\"sap.ui.core\"><Currency value=\"100\" currency=\"USD\" /></core:FragmentDefinition>",
	"sap/ui/unified/manifest.json": "{\"_version\":\"1.9.0\",\"sap.app\":{\"_version\":\"1.2.0\",\"id\":\"sap.ui.unified\",\"type\":\"library\",\"applicationVersion\":{\"version\":\"9.4.0-0\"},\"title\":\"The OpenUI5-based library, sap.ui.unified.\"},\"sap.ui5\":{\"_version\":\"1.1.0\",\"dependencies\":{\"libs\":{\"sap.ui.core\":{}}},\"library\":{\"i18n\":\"messagebundle.properties\"}}}"
}, "sap/ui/unified/library-preload");