sap.ui.require.preload({
	"sap/ui/table/AnalyticalColumn.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"./Column\",\"./library\",\"sap/ui/core/Element\",\"sap/ui/model/type/Boolean\",\"sap/ui/model/type/DateTime\",\"sap/ui/model/type/Float\",\"sap/ui/model/type/Integer\",\"sap/ui/model/type/Time\",\"./TableUtils\",\"./AnalyticalColumnMenu\"],function(e,t,r,i,a,n,o,p,s,u,l){\"use strict\";function g(e){return u.isInstanceOf(e,\"sap/ui/table/AnalyticalTable\")}var y=t.extend(\"sap.ui.table.AnalyticalColumn\",{metadata:{library:\"sap.ui.table\",properties:{leadingProperty:{type:\"string\",group:\"Misc\",defaultValue:null},summed:{type:\"boolean\",group:\"Misc\",defaultValue:!1},inResult:{type:\"boolean\",group:\"Misc\",defaultValue:!1},showIfGrouped:{type:\"boolean\",group:\"Appearance\",defaultValue:!1},groupHeaderFormatter:{type:\"any\",group:\"Behavior\",defaultValue:null}}}});return y.prototype.init=function(){t.prototype.init.apply(this,arguments)},y._DEFAULT_FILTERTYPES={Time:new s({UTC:!0}),DateTime:new n({UTC:!0}),Float:new o,Integer:new p,Boolean:new a},y.prototype._createMenu=function(){return new l(this.getId()+\"-menu\")},y.prototype.setGrouped=function(e,t){var r=this.getParent();g(r)&&(e?r._addGroupedColumn(this.getId()):r._removeGroupedColumn(this.getId()));var i=this.setProperty(\"grouped\",e,t);return this._updateColumns(),i},y.prototype.setSummed=function(e){var t=this.setProperty(\"summed\",e,!0);return this._updateTableAnalyticalInfo(),t},y.prototype.setVisible=function(e,t){return this.setProperty(\"visible\",e,t),this._updateColumns(),this},y.prototype.getLabel=function(){var e=this.getAggregation(\"label\");if(!e){if(!this._oBindingLabel){var t=this.getParent();if(g(t)){var i=t.getBinding(\"rows\");i&&(this._oBindingLabel=r.TableHelper.createLabel(),u.Binding.metadataLoaded(t).then(function(){this._oBindingLabel.setText(i.getPropertyLabel(this.getLeadingProperty()))}.bind(this)))}}e=this._oBindingLabel}return e},y.prototype.getFilterProperty=function(){var t=this.getProperty(\"filterProperty\");if(!t){var r=this.getParent();if(g(r)){var i=r.getBinding(\"rows\"),a=this.getLeadingProperty();i&&e.inArray(a,i.getFilterablePropertyNames())>-1&&(t=a)}}return t},y.prototype.getSortProperty=function(){var t=this.getProperty(\"sortProperty\");if(!t){var r=this.getParent();if(g(r)){var i=r.getBinding(\"rows\"),a=this.getLeadingProperty();i&&e.inArray(a,i.getSortablePropertyNames())>-1&&(t=a)}}return t},y.prototype.getFilterType=function(){var e=this.getProperty(\"filterType\");if(!e){var t=this.getParent();if(g(t)){var r=t.getBinding(\"rows\"),i=this.getLeadingProperty(),a=r&&r.getProperty(i);if(a)switch(a.type){case\"Edm.Time\":e=y._DEFAULT_FILTERTYPES.Time;break;case\"Edm.DateTime\":case\"Edm.DateTimeOffset\":e=y._DEFAULT_FILTERTYPES.DateTime;break;case\"Edm.Single\":case\"Edm.Double\":case\"Edm.Decimal\":e=y._DEFAULT_FILTERTYPES.Float;break;case\"Edm.SByte\":case\"Edm.Int16\":case\"Edm.Int32\":case\"Edm.Int64\":e=y._DEFAULT_FILTERTYPES.Integer;break;case\"Edm.Boolean\":e=y._DEFAULT_FILTERTYPES.Boolean}}}return e},y.prototype._updateColumns=function(e,t){var r=this.getParent();g(r)&&r._updateColumns(e,t)},y.prototype._updateTableAnalyticalInfo=function(e){var t=this.getParent();t&&g(t)&&!t._bSuspendUpdateAnalyticalInfo&&t.updateAnalyticalInfo(e)},y.prototype._updateTableColumnDetails=function(){var e=this.getParent();e&&g(e)&&!e._bSuspendUpdateAnalyticalInfo&&e._updateTableColumnDetails()},y.prototype.shouldRender=function(){return!(!this.getVisible()||null==this.getTemplate())&&((!this.getGrouped()||this._bLastGroupAndGrouped||this.getShowIfGrouped())&&(!this._bDependendGrouped||this._bLastGroupAndGrouped))},y.prototype.getTooltip_AsString=function(){var e=i.prototype.getTooltip_AsString.apply(this),t=this.getParent();if(!e&&g(t)){var r=t.getBinding(\"rows\");r&&this.getLeadingProperty()&&(e=r.getPropertyQuickInfo(this.getLeadingProperty()))}return e},y.prototype._menuHasItems=function(){var e=function(){var e=this.getParent(),t=e.getBinding(\"rows\"),r=t&&t.getAnalyticalQueryResult();return e&&r&&r.findMeasureByPropertyName(this.getLeadingProperty())}.bind(this);return t.prototype._menuHasItems.apply(this)||e()},y.prototype.isFilterableByMenu=function(){var t=this.getFilterProperty();if(!t||!this.getShowFilterMenuEntry())return!1;var r=this.getParent();if(g(r)){var i=r.getBinding(\"rows\");if(i&&e.inArray(t,i.getFilterablePropertyNames())>-1&&i.getProperty(t))return!0}return!1},y.prototype.isGroupable=function(){var t=this.getParent();if(g(t)){var r=t.getBinding(\"rows\");if(r){var i=r.getAnalyticalQueryResult();if(i&&i.findDimensionByPropertyName(this.getLeadingProperty())&&e.inArray(this.getLeadingProperty(),r.getSortablePropertyNames())>-1&&e.inArray(this.getLeadingProperty(),r.getFilterablePropertyNames())>-1)return!0}}return!1},y});",
	"sap/ui/table/AnalyticalColumnMenu.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"./ColumnMenu\",\"./library\"],function(e,t,o){\"use strict\";var u=o.GroupEventType,n=t.extend(\"sap.ui.table.AnalyticalColumnMenu\",{metadata:{library:\"sap.ui.table\"},renderer:\"sap.ui.table.ColumnMenuRenderer\"});return n.prototype._addMenuItems=function(){t.prototype._addMenuItems.apply(this),this._oColumn&&this._addSumMenuItem()},n.prototype._addGroupMenuItem=function(){var e=this._oColumn,t=this._oTable;e.isGroupable()&&(this._oGroupIcon=this._createMenuItem(\"group\",\"TBL_GROUP\",e.getGrouped()?\"accept\":null,function(o){var n=o.getSource(),p=e.getGrouped(),r=p?u.group:u.ungroup;e.setGrouped(!p),t.fireGroup({column:e,groupedColumns:t._aGroupedColumns,type:r}),n.setIcon(p?null:\"sap-icon://accept\")}),this.addItem(this._oGroupIcon))},n.prototype._addSumMenuItem=function(){var t=this._oColumn,o=this._oTable,u=o.getBinding(\"rows\"),n=u&&u.getAnalyticalQueryResult();o&&n&&n.findMeasureByPropertyName(t.getLeadingProperty())&&(this._oSumItem=this._createMenuItem(\"total\",\"TBL_TOTAL\",t.getSummed()?\"accept\":null,e.proxy(function(e){var o=e.getSource(),u=t.getSummed();t.setSummed(!u),o.setIcon(u?null:\"sap-icon://accept\")},this)),this.addItem(this._oSumItem))},n.prototype.open=function(){t.prototype.open.apply(this,arguments);var e=this._oColumn;this._oSumItem&&this._oSumItem.setIcon(e.getSummed()?\"sap-icon://accept\":null),this._oGroupIcon&&this._oGroupIcon.setIcon(e.getGrouped()?\"sap-icon://accept\":null)},n});",
	"sap/ui/table/AnalyticalColumnMenuRenderer.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"sap/ui/table/AnalyticalColumnMenu\"],function(e){\"use strict\";return e.getMetadata().getRenderer()},!0);",
	"sap/ui/table/AnalyticalTable.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"./AnalyticalColumn\",\"./Table\",\"./TreeTable\",\"./library\",\"sap/ui/model/analytics/ODataModelAdapter\",\"sap/ui/model/SelectionModel\",\"sap/ui/model/Sorter\",\"sap/ui/core/Popup\",\"sap/ui/unified/Menu\",\"sap/ui/unified/MenuItem\",\"./TableUtils\"],function(e,t,o,n,r,a,i,s,l,p,u,d){\"use strict\";var g=r.GroupEventType,c=r.SelectionMode,h=r.SortOrder,y=r.TreeAutoExpandMode,m=o.extend(\"sap.ui.table.AnalyticalTable\",{metadata:{library:\"sap.ui.table\",properties:{sumOnTop:{type:\"boolean\",group:\"Appearance\",defaultValue:!1,deprecated:!0},numberOfExpandedLevels:{type:\"int\",group:\"Misc\",defaultValue:0,deprecated:!0},autoExpandMode:{type:\"string\",group:\"Misc\",defaultValue:\"Bundled\",deprecated:!0},columnVisibilityMenuSorter:{type:\"any\",group:\"Appearance\",defaultValue:null},collapseRecursive:{type:\"boolean\",defaultValue:!0},dirty:{type:\"boolean\",group:\"Appearance\",defaultValue:null,deprecated:!0}},designtime:\"sap/ui/table/designtime/AnalyticalTable.designtime\"},renderer:\"sap.ui.table.TableRenderer\"});return m.prototype._getFixedBottomRowContexts=function(){var e=this.getBinding(\"rows\");if(e)return[e.getGrandTotalNode()]},m.prototype._getContexts=n.prototype._getContexts,m.prototype.init=function(){o.prototype.init.apply(this,arguments),this.addStyleClass(\"sapUiAnalyticalTable\"),this.attachBrowserEvent(\"contextmenu\",this._onContextMenu),this.setSelectionMode(c.MultiToggle),this.setShowColumnVisibilityMenu(!0),this.setEnableColumnFreeze(!0),this.setEnableCellFilter(!0),this._aGroupedColumns=[],this._bSuspendUpdateAnalyticalInfo=!1,d.Grouping.setGroupMode(this)},m.prototype.exit=function(){this._cleanupGroupHeaderMenu(),o.prototype.exit.apply(this,arguments)},m.prototype._adaptLocalization=function(e,t){o.prototype._adaptLocalization.apply(this,arguments),t&&this._cleanupGroupHeaderMenu()},m.prototype.setFixedRowCount=function(){return e.sap.log.error(\"The property fixedRowCount is not supported by control sap.ui.table.AnalyticalTable!\"),this},m.prototype.setFixedBottomRowCount=function(){return e.sap.log.error(\"The property fixedBottomRowCount is managed by control sap.ui.table.AnalyticalTable!\"),this},m.prototype.setDirty=function(t){return e.sap.log.error(\"The property dirty of control sap.ui.table.AnalyticalTable is deprecated. Please use showOverlay instead.\"),this.setProperty(\"dirty\",t,!0),this.setShowOverlay(this.getDirty()),this},m.prototype.setEnableGrouping=function(){return e.sap.log.error(\"The property enableGrouping is not supported by the sap.ui.table.AnalyticalTable control\"),this},m.prototype.setGroupBy=function(){return e.sap.log.warning(\"The groupBy association is not supported by the sap.ui.table.AnalyticalTable control\"),this},m.prototype.getModel=function(e){var t=o.prototype.getModel.apply(this,arguments),n=this.getBindingInfo(\"rows\");return t&&n&&n.model==e&&a.apply(t),t},m.prototype._onBindingChange=function(e){o.prototype._onBindingChange.apply(this,arguments),\"sort\"!==(\"object\"==typeof e?e.getParameter(\"reason\"):e)&&this._invalidateColumnMenus()},m.prototype._bindAggregation=function(e,t){\"rows\"===e&&(this.setProperty(\"firstVisibleRow\",0,!0),this._applyAnalyticalBindingInfo(t),this._updateTotalRow(!0),this._applyODataModelAnalyticalAdapter(t.model),o._addBindingListener(t,\"selectionChanged\",this._onSelectionChanged.bind(this))),o.prototype._bindAggregation.call(this,e,t),\"rows\"===e&&d.Binding.metadataLoaded(this).then(function(){this._updateColumns(!0)}.bind(this))},m.prototype._initSelectionModel=function(e){return this._oSelection=new i(e),this},m.prototype.setSelectionMode=n.prototype.setSelectionMode,m.prototype._applyAnalyticalBindingInfo=function(e){for(var t=this.getColumns(),o=0,n=t.length;o<n;o++)t[o].getSorted()&&(e.sorter=e.sorter||[],e.sorter.push(new s(t[o].getSortProperty()||t[o].getLeadingProperty(),t[o].getSortOrder()===h.Descending)));if(e.parameters=e.parameters||{},e.parameters.analyticalInfo=this._getColumnInformation(),e.parameters.hasOwnProperty(\"sumOnTop\")||(e.parameters.sumOnTop=this.getSumOnTop()),e.parameters.hasOwnProperty(\"numberOfExpandedLevels\")||(e.parameters.numberOfExpandedLevels=this.getNumberOfExpandedLevels()),e.parameters.numberOfExpandedLevels>this._aGroupedColumns.length&&(e.parameters.numberOfExpandedLevels=0),!e.parameters.hasOwnProperty(\"autoExpandMode\")){var r=this.getAutoExpandMode();r!=y.Bundled&&r!=y.Sequential&&(r=y.Bundled),e.parameters.autoExpandMode=r}},m.prototype._applyODataModelAnalyticalAdapter=function(e){null!=e&&a.apply(e)},m.prototype._getColumnInformation=function(){for(var o=[],n=this.getColumns(),r=0;r<this._aGroupedColumns.length;r++){var a=sap.ui.getCore().byId(this._aGroupedColumns[r]);a&&o.push({name:a.getLeadingProperty(),visible:a.getVisible(),grouped:a.getGrouped(),total:a.getSummed(),sorted:a.getSorted(),sortOrder:a.getSortOrder(),inResult:a.getInResult(),formatter:a.getGroupHeaderFormatter()})}for(var r=0;r<n.length;r++){var a=n[r];e.inArray(a.getId(),this._aGroupedColumns)>-1||(!a instanceof t&&e.sap.log.error(\"You have to use AnalyticalColumns for the Analytical table\"),o.push({name:a.getLeadingProperty(),visible:a.getVisible(),grouped:a.getGrouped(),total:a.getSummed(),sorted:a.getSorted(),sortOrder:a.getSortOrder(),inResult:a.getInResult(),formatter:a.getGroupHeaderFormatter()}))}return o},m.prototype._updateTableContent=function(){var t=this.getBinding(\"rows\"),o=this.getFirstVisibleRow(),n=this.getFixedBottomRowCount(),r=this.getVisibleRowCount(),a=this.getColumns(),i=this.getRows();if(t)for(var s=this.getBindingInfo(\"rows\"),l=0,p=Math.min(r,i.length);l<p;l++){var u,g=l>r-n-1&&this._getTotalRowCount()>r,c=g?this._getTotalRowCount()-1-(r-1-l):o+l,h=i[l],y=h.$(),m=this.$().find(\"div[data-sap-ui-rowindex=\"+y.attr(\"data-sap-ui-rowindex\")+\"]\");u=g&&t.bProvideGrandTotals?t.getGrandTotalContextInfo():this.getContextInfoByIndex(c);var f=u?u.level:0;if(u&&u.context){t.nodeHasChildren&&t.nodeHasChildren(u)?d.Grouping.updateTableRowForGrouping(this,h,!0,u.nodeState.expanded,u.nodeState.expanded&&!s.parameters.sumOnTop,!1,f,t.getGroupName(u.context,u.level)):d.Grouping.updateTableRowForGrouping(this,h,!1,!1,!1,u.nodeState.sum,f,u.nodeState.sum&&u.level>0?t.getGroupName(u.context,u.level):null);for(var _=h.getCells(),C=0,G=_.length;C<G;C++){var v=_[C].data(\"sap-ui-colindex\"),b=a[v],I=e(_[C].$().closest(\"td\"));t.isMeasure(b.getLeadingProperty())?(I.addClass(\"sapUiTableMeasureCell\"),I.toggleClass(\"sapUiTableCellHidden\",u.nodeState.sum&&!b.getSummed())):I.removeClass(\"sapUiTableMeasureCell\")}}else d.Grouping.cleanupTableRowForGrouping(this,h),u&&!u.context&&(y.addClass(\"sapUiAnalyticalTableDummy\"),m.addClass(\"sapUiAnalyticalTableDummy\"))}else for(var C=0;C<i.length;C++)d.Grouping.cleanupTableRowForGrouping(this,i[C])},m.prototype._onContextMenu=function(t){if(e(t.target).closest(\"tr\").hasClass(\"sapUiTableGroupHeader\")||e(t.target).closest(\".sapUiTableRowHdr.sapUiTableGroupHeader\").length>0){this._iGroupedLevel=e(t.target).closest(\"[data-sap-ui-level]\").data(\"sap-ui-level\");var o=this._getGroupHeaderMenu(),n=l.Dock,r=t.pageX||t.clientX,a=t.pageY||t.clientY;return o.open(!1,t.target,n.LeftTop,n.LeftTop,document,r-2+\" \"+(a-2)),t.preventDefault(),void t.stopPropagation()}return!0},m.prototype._getGroupHeaderMenu=function(){function t(){var e=o._iGroupedLevel-1;if(o._aGroupedColumns[e]){return{column:o.getColumns().filter(function(t){return o._aGroupedColumns[e]===t.getId()})[0],index:e}}}var o=this;this._oGroupHeaderMenu||(this._oGroupHeaderMenu=new p,this._oGroupHeaderMenuVisibilityItem=new u({text:this._oResBundle.getText(\"TBL_SHOW_COLUMN\"),select:function(){var e=t();if(e){var n=e.column,r=n.getShowIfGrouped();n.setShowIfGrouped(!r),o.fireGroup({column:n,groupedColumns:n.getParent()._aGroupedColumns,type:r?g.hideGroupedColumn:g.showGroupedColumn})}}}),this._oGroupHeaderMenu.addItem(this._oGroupHeaderMenuVisibilityItem),this._oGroupHeaderMenu.addItem(new u({text:this._oResBundle.getText(\"TBL_UNGROUP\"),select:function(){var e=t();if(null!=e&&null!=e.column){var n=e.column;n.setGrouped(!1),o.fireGroup({column:n,groupedColumns:o._aGroupedColumns,type:g.ungroup})}}})),this._oGroupHeaderMenu.addItem(new u({text:this._oResBundle.getText(\"TBL_UNGROUP_ALL\"),select:function(){var e=o.getColumns();o.suspendUpdateAnalyticalInfo();for(var t=0;t<e.length;t++)e[t].setGrouped(!1);o.resumeUpdateAnalyticalInfo(),o.fireGroup({column:void 0,groupedColumns:[],type:g.ungroupAll})}})),this._oGroupHeaderMoveUpItem=new u({text:this._oResBundle.getText(\"TBL_MOVE_UP\"),select:function(){var n=t();if(n){var r=n.column,a=e.inArray(r.getId(),o._aGroupedColumns);a>0&&(o._aGroupedColumns[a]=o._aGroupedColumns.splice(a-1,1,o._aGroupedColumns[a])[0],o.updateAnalyticalInfo(),o.fireGroup({column:r,groupedColumns:r.getParent()._aGroupedColumns,type:g.moveUp}))}},icon:\"sap-icon://arrow-top\"}),this._oGroupHeaderMenu.addItem(this._oGroupHeaderMoveUpItem),this._oGroupHeaderMoveDownItem=new u({text:this._oResBundle.getText(\"TBL_MOVE_DOWN\"),select:function(){var n=t();if(n){var r=n.column,a=e.inArray(r.getId(),o._aGroupedColumns);a<o._aGroupedColumns.length&&(o._aGroupedColumns[a]=o._aGroupedColumns.splice(a+1,1,o._aGroupedColumns[a])[0],o.updateAnalyticalInfo(),o.fireGroup({column:r,groupedColumns:r.getParent()._aGroupedColumns,type:g.moveDown}))}},icon:\"sap-icon://arrow-bottom\"}),this._oGroupHeaderMenu.addItem(this._oGroupHeaderMoveDownItem),this._oGroupHeaderMenu.addItem(new u({text:this._oResBundle.getText(\"TBL_SORT_ASC\"),select:function(){var e=t();if(e){e.column.sort(!1)}},icon:\"sap-icon://up\"})),this._oGroupHeaderMenu.addItem(new u({text:this._oResBundle.getText(\"TBL_SORT_DESC\"),select:function(){var e=t();if(e){e.column.sort(!0)}},icon:\"sap-icon://down\"})),this._oGroupHeaderMenu.addItem(new u({text:this._oResBundle.getText(\"TBL_COLLAPSE_LEVEL\"),select:function(){o.getBinding(\"rows\").collapseToLevel(o._iGroupedLevel-1),o.setFirstVisibleRow(0),o.clearSelection()}})),this._oGroupHeaderMenu.addItem(new u({text:this._oResBundle.getText(\"TBL_COLLAPSE_ALL\"),select:function(){o.getBinding(\"rows\").collapseToLevel(0),o.setFirstVisibleRow(0),o.clearSelection()}})));var n=t();if(n){n.column.getShowIfGrouped()?this._oGroupHeaderMenuVisibilityItem.setText(this._oResBundle.getText(\"TBL_HIDE_COLUMN\")):this._oGroupHeaderMenuVisibilityItem.setText(this._oResBundle.getText(\"TBL_SHOW_COLUMN\")),this._oGroupHeaderMoveUpItem.setEnabled(n.index>0),this._oGroupHeaderMoveDownItem.setEnabled(n.index<this._aGroupedColumns.length-1)}else this._oGroupHeaderMoveUpItem.setEnabled(!0),this._oGroupHeaderMoveDownItem.setEnabled(!0);return this._oGroupHeaderMenu},m.prototype._cleanupGroupHeaderMenu=function(){this._oGroupHeaderMenu&&(this._oGroupHeaderMenu.destroy(),this._oGroupHeaderMenu=null,this._oGroupHeaderMenuVisibilityItem=null,this._oGroupHeaderMoveUpItem=null,this._oGroupHeaderMoveDownItem=null)},m.prototype.getContextByIndex=function(e){var t=this.getBinding(\"rows\");return e>=0&&t?t.getContextByIndex(e):null},m.prototype.getContextInfoByIndex=function(e){var t=this.getBinding(\"rows\");return e>=0&&t?t.getNodeByIndex(e):null},m.prototype.suspendUpdateAnalyticalInfo=function(){this._bSuspendUpdateAnalyticalInfo=!0},m.prototype.resumeUpdateAnalyticalInfo=function(e,t){this._bSuspendUpdateAnalyticalInfo=!1,this._updateColumns(e,t)},m.prototype.addColumn=function(e,t){var n=this._getColumn(e);return n.getGrouped()&&this._addGroupedColumn(n.getId()),o.prototype.addColumn.call(this,n,t),this._updateColumns(t),this},m.prototype.insertColumn=function(e,t,n){var r=this._getColumn(e);return r.getGrouped()&&this._addGroupedColumn(r.getId()),o.prototype.insertColumn.call(this,r,t,n),this._updateColumns(n),this},m.prototype.removeColumn=function(t,n){var r=o.prototype.removeColumn.apply(this,arguments);return this._bReorderInProcess||(this._aGroupedColumns=e.grep(this._aGroupedColumns,function(e){return t.getId?e!=t.getId():e==t})),this.updateAnalyticalInfo(n),r},m.prototype.removeAllColumns=function(e){this._aGroupedColumns=[];var t=o.prototype.removeAllColumns.apply(this,arguments);return this._updateColumns(e),t},m.prototype._getColumn=function(e){if(\"string\"==typeof e){return new t({leadingProperty:e,template:e,managed:!0})}if(e instanceof t)return e;throw new Error(\"Wrong column type. You need to define a string (property) or pass an AnalyticalColumnObject\")},m.prototype._updateColumns=function(e,t){this._bSuspendUpdateAnalyticalInfo||(this._updateTableColumnDetails(),this.updateAnalyticalInfo(e,t),this.bOutput&&this.invalidate())},m.prototype.updateAnalyticalInfo=function(e,t){if(!this._bSuspendUpdateAnalyticalInfo){var o=this.getBinding(\"rows\");if(o){var n=this._getColumnInformation();(o.getNumberOfExpandedLevels()||0)>this._aGroupedColumns.length&&o.setNumberOfExpandedLevels(0),o.updateAnalyticalInfo(n,t),this._updateTotalRow(e),e||this._getRowContexts()}}},m.prototype.refreshRows=function(){o.prototype.refreshRows.apply(this,arguments),this._updateTotalRow()},m.prototype._updateTotalRow=function(e){var t=this.getBinding(\"rows\"),o=this.getFixedBottomRowCount();t&&t.providesGrandTotal()&&t.hasTotaledMeasures()?1!==o&&this.setProperty(\"fixedBottomRowCount\",1,e):0!==o&&this.setProperty(\"fixedBottomRowCount\",0,e)},m.prototype._updateTableColumnDetails=function(){if(!this._bSuspendUpdateAnalyticalInfo){var t=this.getBinding(\"rows\"),o=t&&t.getAnalyticalQueryResult();if(o){for(var n,r,a=this.getColumns(),i=[],s=[],l=[],p={},u=0;u<a.length;u++)if(n=a[u],n._isLastGroupableLeft=!1,n._bLastGroupAndGrouped=!1,n._bDependendGrouped=!1,n.getVisible()){var d=n.getLeadingProperty();if(r=o.findDimensionByPropertyName(d)){var g=r.getName();p[g]?p[g].columns.push(n):p[g]={dimension:r,columns:[n]},n.getGrouped()&&-1==e.inArray(g,i)&&i.push(g),-1==e.inArray(g,l)&&l.push(g)}}if(s=e.grep(l,function(t){return-1==e.inArray(t,i)}),i.length>0&&(e.each(i,function(t,o){e.each(p[o].columns,function(e,t){t.getGrouped()||(t._bDependendGrouped=!0)})}),i.length==l.length)){r=o.findDimensionByPropertyName(sap.ui.getCore().byId(this._aGroupedColumns[this._aGroupedColumns.length-1]).getLeadingProperty());var c=p[r.getName()].columns;e.each(c,function(e,t){t._bLastGroupAndGrouped=!0})}1==s.length&&e.each(p[s[0]].columns,function(e,t){t._isLastGroupableLeft=!0})}}},m.prototype._getFirstMeasureColumnIndex=function(){var e=this.getBinding(\"rows\"),t=e&&e.getAnalyticalQueryResult(),o=this._getVisibleColumns();if(!t)return-1;for(var n=0;n<o.length;n++){var r=o[n],a=r.getLeadingProperty();if(t.findMeasureByName(a)||t.findMeasureByPropertyName(a))return n}},m.prototype.getTotalSize=function(){var e=this.getBinding(\"rows\");return e?e.getTotalSize():0},m.prototype._onPersoApplied=function(){o.prototype._onPersoApplied.apply(this,arguments),this._aGroupedColumns=[];for(var e=this.getColumns(),t=0,n=e.length;t<n;t++)e[t].getGrouped()&&this._addGroupedColumn(e[t].getId());this._updateColumns()},m.prototype._addGroupedColumn=function(e){-1===this._aGroupedColumns.indexOf(e)&&this._aGroupedColumns.push(e)},m.prototype._removeGroupedColumn=function(e){var t=this._aGroupedColumns.indexOf(e);t>=0&&this._aGroupedColumns.splice(t,1)},m.prototype.getGroupedColumns=function(){return this._aGroupedColumns},m.prototype.setCollapseRecursive=function(t){var o=this.getBinding(\"rows\");return o&&(e.sap.assert(o.setCollapseRecursive,\"Collapse Recursive is not supported by the used binding\"),o.setCollapseRecursive&&o.setCollapseRecursive(t)),this.setProperty(\"collapseRecursive\",!!t,!0),this},m.prototype._getSelectableRowCount=function(){var e=this.getBinding(\"rows\");if(null==e)return 0;var t=e.getGrandTotalContextInfo();return null==t?0:t.totalNumberOfLeafs},m.prototype.isIndexSelected=n.prototype.isIndexSelected,m.prototype.setSelectedIndex=n.prototype.setSelectedIndex,m.prototype.getSelectedIndices=n.prototype.getSelectedIndices,m.prototype.setSelectionInterval=n.prototype.setSelectionInterval,m.prototype.addSelectionInterval=n.prototype.addSelectionInterval,m.prototype.removeSelectionInterval=n.prototype.removeSelectionInterval,m.prototype.selectAll=n.prototype.selectAll,m.prototype.getSelectedIndex=n.prototype.getSelectedIndex,m.prototype.clearSelection=n.prototype.clearSelection,m.prototype.expand=n.prototype.expand,m.prototype.collapse=n.prototype.collapse,m.prototype.collapseAll=n.prototype.collapseAll,m.prototype.isExpanded=n.prototype.isExpanded,m.prototype._isRowSelectable=function(e){var t=this.getBinding(\"rows\");return!!t&&t.isIndexSelectable(e)},m.prototype._getSelectedIndicesCount=n.prototype._getSelectedIndicesCount,m.prototype.getAnalyticalInfoOfRow=function(e){if(!this._validateRow(e))return null;var t=this.getBindingInfo(\"rows\"),o=this.getBinding(\"rows\");if(!t||!o)return null;var n=e.getBindingContext(t.model);if(!n)return null;var r=n===o.getGrandTotalContext(),a=null,i=-1;r?(a=o.getGrandTotalContextInfo(),i=0):(a=this.getContextInfoByIndex(e.getIndex()))&&(i=a.level);var s=a&&o.nodeHasChildren&&o.nodeHasChildren(a),l=!s&&!r&&a&&a.nodeState&&a.nodeState.sum,p=[];if(l||s){var u=this.getGroupedColumns();if(u.length>0&&i>0&&i<=u.length)for(var d=0;d<i;d++)p.push(u[d])}return{grandTotal:r,group:s,groupTotal:l,level:i,context:n,groupedColumns:p}},m});",
	"sap/ui/table/AnalyticalTableRenderer.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"sap/ui/table/AnalyticalTable\"],function(e){\"use strict\";return e.getMetadata().getRenderer()},!0);",
	"sap/ui/table/Column.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/core/Element\",\"sap/ui/core/library\",\"sap/ui/core/Popup\",\"sap/ui/model/Filter\",\"sap/ui/model/FilterOperator\",\"sap/ui/model/FilterType\",\"sap/ui/model/Sorter\",\"sap/ui/model/Type\",\"sap/ui/model/type/String\",\"./TableUtils\",\"./library\",\"./ColumnMenu\"],function(e,t,r,i,o,n,s,a,l,p,u,h,g){\"use strict\";var f=r.HorizontalAlign,d=h.SortOrder,y=r.ValueState,c=t.extend(\"sap.ui.table.Column\",{metadata:{library:\"sap.ui.table\",properties:{width:{type:\"sap.ui.core.CSSSize\",group:\"Dimension\",defaultValue:null},minWidth:{type:\"int\",group:\"Dimension\",defaultValue:0},flexible:{type:\"boolean\",group:\"Behavior\",defaultValue:!0},resizable:{type:\"boolean\",group:\"Behavior\",defaultValue:!0},hAlign:{type:\"sap.ui.core.HorizontalAlign\",group:\"Appearance\",defaultValue:f.Begin},sorted:{type:\"boolean\",group:\"Appearance\",defaultValue:!1},sortOrder:{type:\"sap.ui.table.SortOrder\",group:\"Appearance\",defaultValue:d.Ascending},sortProperty:{type:\"string\",group:\"Behavior\",defaultValue:null},filtered:{type:\"boolean\",group:\"Appearance\",defaultValue:!1},filterProperty:{type:\"string\",group:\"Behavior\",defaultValue:null},filterValue:{type:\"string\",group:\"Behavior\",defaultValue:null},filterOperator:{type:\"string\",group:\"Behavior\",defaultValue:null},defaultFilterOperator:{type:\"string\",group:\"Behavior\",defaultValue:null},filterType:{type:\"any\",group:\"Misc\",defaultValue:null},grouped:{type:\"boolean\",group:\"Appearance\",defaultValue:!1},visible:{type:\"boolean\",group:\"Appearance\",defaultValue:!0},name:{type:\"string\",group:\"Appearance\",defaultValue:null},showFilterMenuEntry:{type:\"boolean\",group:\"Appearance\",defaultValue:!0},showSortMenuEntry:{type:\"boolean\",group:\"Appearance\",defaultValue:!0},headerSpan:{type:\"any\",group:\"Behavior\",defaultValue:1},autoResizable:{type:\"boolean\",group:\"Behavior\",defaultValue:!1}},defaultAggregation:\"label\",aggregations:{label:{type:\"sap.ui.core.Control\",altTypes:[\"string\"],multiple:!1},multiLabels:{type:\"sap.ui.core.Control\",multiple:!0,singularName:\"multiLabel\"},template:{type:\"sap.ui.core.Control\",altTypes:[\"string\"],multiple:!1},menu:{type:\"sap.ui.unified.Menu\",multiple:!1}},events:{columnMenuOpen:{allowPreventDefault:!0,parameters:{menu:{type:\"sap.ui.unified.Menu\"}}}}}});return c._DEFAULT_FILTER_TYPE=new p,c.prototype.init=function(){this._oSorter=null,this.mSkipPropagation={template:!0},this._aTemplateClones=[]},c.prototype.exit=function(){this._destroyTemplateClones()},c.prototype.setParent=function(e,r,i){t.prototype.setParent.apply(this,arguments);var o=this.getAggregation(\"menu\");o&&\"function\"==typeof o._updateReferences&&o._updateReferences(this)},c.prototype.invalidate=function(e){e===this.getTemplate()||u.isInstanceOf(e,\"sap/ui/table/ColumnMenu\")||t.prototype.invalidate.apply(this,arguments)},c.prototype.setLabel=function(e){var t=e;return\"string\"==typeof e&&(t=h.TableHelper.createLabel({text:e})),this.setAggregation(\"label\",t),this},c.prototype.setTemplate=function(e){var t=e;\"string\"==typeof e&&(t=h.TableHelper.createTextView().bindProperty(\"text\",e)),this.setAggregation(\"template\",t),this.invalidate(),this._destroyTemplateClones();var r=this.getParent();return r&&r.invalidateRowsAggregation&&1==this.getVisible()&&r.invalidateRowsAggregation(),this},c.prototype.getMenu=function(){var e=this.getAggregation(\"menu\");return e||(e=this._createMenu(),this.setMenu(e)),e},c.prototype.invalidateMenu=function(e){var t=this.getAggregation(\"menu\");this._bMenuIsColumnMenu&&(e?t._updateResourceBundle():t._invalidate())},c.prototype._menuHasItems=function(){var e=this.getAggregation(\"menu\"),t=this.getParent(),r=function(){return this.isSortableByMenu()||this.isFilterableByMenu()||this.isGroupable()||t&&t.getEnableColumnFreeze()||t&&t.getShowColumnVisibilityMenu()}.bind(this);return!!(e&&e.getItems().length>0||r())},c.prototype.isFilterableByMenu=function(){return!(!this.getFilterProperty()||!this.getShowFilterMenuEntry())},c.prototype.isSortableByMenu=function(){return!(!this.getSortProperty()||!this.getShowSortMenuEntry())},c.prototype.isGroupable=function(){var e=this.getParent();return!!(e&&e.getEnableGrouping&&e.getEnableGrouping()&&this.getSortProperty())},c.prototype.setMenu=function(e){return this.setAggregation(\"menu\",e,!0),this._bMenuIsColumnMenu=u.isInstanceOf(e,\"sap/ui/table/ColumnMenu\"),this},c.prototype._createMenu=function(){return this._defaultMenu||(this._defaultMenu=new g(this.getId()+\"-menu\",{ariaLabelledBy:this})),this._defaultMenu},c.prototype._setAppDefault=function(e,t){this._appDefaults||(this._appDefaults={}),\"sorted\"==e?this._appDefaults.sorted=t:\"sortOrder\"==e?this._appDefaults.sortOrder=t:\"filtered\"==e?this._appDefaults.filtered=t:\"filterValue\"==e?this._appDefaults.filterValue=t:\"filterOperator\"==e&&(this._appDefaults.filterOperator=t)},c.prototype._restoreAppDefaults=function(){this._appDefaults&&(this.setProperty(\"sorted\",this._appDefaults.sorted,!0),this.setProperty(\"sortOrder\",this._appDefaults.sortOrder,!0),this.setProperty(\"filtered\",this._appDefaults.filtered,!0),this.setProperty(\"filterValue\",this._appDefaults.filterValue,!0),this.setProperty(\"filterOperator\",this._appDefaults.filterOperator,!0),this._updateIcons())},c.prototype.setSortProperty=function(e){return this.setProperty(\"sortProperty\",e),this.invalidateMenu(),this},c.prototype.setSorted=function(e){return this.setProperty(\"sorted\",e,!0),this._setAppDefault(\"sorted\",e),this._updateIcons(),this},c.prototype.setSortOrder=function(e){return this.setProperty(\"sortOrder\",e,!0),this._setAppDefault(\"sortOrder\",e),this._updateIcons(),this},c.prototype.setFilterProperty=function(e){return this.invalidateMenu(),this.setProperty(\"filterProperty\",e)},c.prototype.setFiltered=function(e){return this.setProperty(\"filtered\",e,!0),this._setAppDefault(\"filtered\",e),this._updateIcons(),this},c.prototype.setFilterValue=function(e){this.setProperty(\"filterValue\",e,!0),this._setAppDefault(\"filterValue\",e);var t=this.getMenu();return this._bMenuIsColumnMenu&&t._setFilterValue(e),this},c.prototype.setFilterOperator=function(e){return this._setAppDefault(\"filterOperator\",e),this.setProperty(\"filterOperator\",e,!0)},c.prototype._openMenu=function(e,t){var r=this.getMenu();if(this.fireColumnMenuOpen({menu:r})){var o=i.Dock,n=e;e||(e=this.getDomRef(),n=this.getFocusDomRef()),r.open(!!t,n,o.BeginTop,o.BeginBottom,e,\"none none\")}},c.prototype.toggleSort=function(){this.sort(this.getSorted()&&this.getSortOrder()===d.Ascending)},c.prototype.sort=function(t,r){var i=this.getParent();if(i){i.pushSortedColumn(this,r);var o=t?d.Descending:d.Ascending;if(i.fireSort({column:this,sortOrder:o,columnAdded:r})){for(var n=i.getSortedColumns(),s=i.getColumns(),l=0,p=s.length;l<p;l++)e.inArray(s[l],n)<0&&(s[l].setProperty(\"sorted\",!1,!0),s[l].setProperty(\"sortOrder\",d.Ascending,!0),s[l]._updateIcons(),delete s[l]._oSorter);this.setProperty(\"sorted\",!0,!0),this.setProperty(\"sortOrder\",o,!0),this._oSorter=new a(this.getSortProperty(),this.getSortOrder()===d.Descending);for(var u=[],l=0,p=n.length;l<p;l++)n[l]._updateIcons(),u.push(n[l]._oSorter);var h=i.getBinding(\"rows\");h?(this._updateTableAnalyticalInfo&&this._updateTableAnalyticalInfo(!0),h.sort(u)):e.sap.log.warning(\"Sorting not performed because no binding present\",this)}}return this},c.prototype._updateIcons=function(){var e=this.getParent(),t=this.getSorted(),r=this.getFiltered();e&&e.getDomRef()&&(this.$().parents(\".sapUiTableCHT\").find('td[data-sap-ui-colindex=\"'+this.getIndex()+'\"]').filter(\":not([colspan]):visible\").first().find(\".sapUiTableColCell\").toggleClass(\"sapUiTableColSF\",t||r).toggleClass(\"sapUiTableColFiltered\",r).toggleClass(\"sapUiTableColSorted\",t).toggleClass(\"sapUiTableColSortedD\",t&&this.getSortOrder()===d.Descending),e._getAccExtension().updateAriaStateOfColumn(this))},c.prototype._renderSortIcon=function(){this._updateIcons()},c.prototype._getFilter=function(){var e,t,r,i,s=this.getFilterProperty(),a=this.getFilterValue(),l=this.getFilterOperator(),u=this.getFilterType()||c._DEFAULT_FILTER_TYPE,h=u instanceof p;return a&&(l?e=new o(s,l,this._parseFilterValue(a)):(i=a.match(/(.*)\\s*\\.\\.\\s*(.*)/),0==a.indexOf(\"=\")?(l=n.EQ,t=a.substr(1)):0==a.indexOf(\"!=\")?(l=n.NE,t=a.substr(2)):0==a.indexOf(\"<=\")?(l=n.LE,t=a.substr(2)):0==a.indexOf(\"<\")?(l=n.LT,t=a.substr(1)):0==a.indexOf(\">=\")?(l=n.GE,t=a.substr(2)):0==a.indexOf(\">\")?(l=n.GT,t=a.substr(1)):i?i[1]&&i[2]?(l=n.BT,t=i[1],r=i[2]):i[1]&&!i[2]?(l=n.GE,t=i[1]):(l=n.LE,t=i[2]):h&&0==a.indexOf(\"*\")&&a.lastIndexOf(\"*\")==a.length-1?(l=n.Contains,t=a.substr(1,a.length-2)):h&&0==a.indexOf(\"*\")?(l=n.EndsWith,t=a.substr(1)):h&&a.lastIndexOf(\"*\")==a.length-1?(l=n.StartsWith,t=a.substr(0,a.length-1)):(l=this.getDefaultFilterOperator()?this.getDefaultFilterOperator():h?n.Contains:n.EQ,t=a.substr(0)),e=r?new o(s,l,this._parseFilterValue(t),this._parseFilterValue(r)):new o(s,l,this._parseFilterValue(t)))),e},c.prototype.filter=function(e){var t=this.getParent();if(t&&t.isBound(\"rows\")){if(t.fireFilter({column:this,value:e})){this.setProperty(\"filtered\",!!e,!0),this.setProperty(\"filterValue\",e,!0);var r=this.getMenu();this._bMenuIsColumnMenu&&r._setFilterValue(e);for(var i=[],o=t.getColumns(),n=0,a=o.length;n<a;n++){var l,p=o[n];r=p.getMenu();try{l=p._getFilter(),p._bMenuIsColumnMenu&&r._setFilterState(y.None)}catch(e){p._bMenuIsColumnMenu&&r._setFilterState(y.Error);continue}l&&i.push(l)}t.getBinding(\"rows\").filter(i,s.Control),this._updateIcons()}}return this},c.prototype._parseFilterValue=function(t){var r=this.getFilterType();return r&&(t=e.isFunction(r)?r(t):r.parseValue(t,\"string\")),t},c.prototype._restoreIcons=function(){this._updateIcons()},c.prototype.shouldRender=function(){return this.getVisible()&&!this.getGrouped()&&null!=this.getTemplate()},c.PROPERTIES_FOR_ROW_INVALIDATION={visible:!0,flexible:!0,headerSpan:!0},c.prototype.setProperty=function(e,r){var i=this.getParent();return i&&i.invalidateRowsAggregation&&this.getProperty(e)!=r&&c.PROPERTIES_FOR_ROW_INVALIDATION[e]&&(this.getVisible()||\"visible\"==e)&&i.invalidateRowsAggregation(),t.prototype.setProperty.apply(this,arguments)},c.prototype.setFilterType=function(t){var r=t;if(\"string\"==typeof t){try{var i=e.sap.parseJS(t);if(\"string\"==typeof i.type){var o=e.sap.getObject(i.type);r=o&&new o(i.formatOptions,i.constraints)}}catch(i){var o=e.sap.getObject(t);r=o&&new o}r instanceof l||(e.sap.log.error(\"The filter type is not an instance of sap.ui.model.Type! Ignoring the filter type!\"),r=void 0)}return this.setProperty(\"filterType\",r,!0),this},c.prototype.getIndex=function(){var e=this.getParent();return e?e.indexOfColumn(this):-1},c.prototype._getFreeTemplateClone=function(){for(var e=null,t=0;t<this._aTemplateClones.length;t++)null==this._aTemplateClones[t]||this._aTemplateClones[t].bIsDestroyed?(this._aTemplateClones.splice(t,1),t--):null===e&&null==this._aTemplateClones[t].getParent()&&(e=this._aTemplateClones[t]);return e},c.prototype.getTemplateClone=function(e){if(null==e)return null;var t=this._getFreeTemplateClone();if(null===t){var r=this.getTemplate();r&&(t=r.clone(),this._aTemplateClones.push(t))}if(null!=t){t.data(\"sap-ui-colindex\",e),t.data(\"sap-ui-colid\",this.getId());var i=this.getParent();null!=i&&i._getAccExtension().addColumnHeaderLabel(this,t)}return t},c.prototype._destroyTemplateClones=function(){for(var e=0;e<this._aTemplateClones.length;e++)null==this._aTemplateClones[e]||this._aTemplateClones[e].bIsDestroyed||this._aTemplateClones[e].destroy();this._aTemplateClones=[]},c});",
	"sap/ui/table/ColumnMenu.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"./library\",\"sap/ui/unified/Menu\",\"sap/ui/unified/MenuItem\",\"sap/ui/unified/MenuTextFieldItem\",\"sap/ui/Device\",\"./TableUtils\"],function(t,e,i,n,o,a,s){\"use strict\";var u=i.extend(\"sap.ui.table.ColumnMenu\",{metadata:{library:\"sap.ui.table\"},renderer:\"sap.ui.unified.MenuRenderer\"});return u.prototype.init=function(){i.prototype.init&&i.prototype.init.apply(this,arguments),this.addStyleClass(\"sapUiTableColumnMenu\"),this._oResBundle=sap.ui.getCore().getLibraryResourceBundle(\"sap.ui.table\"),this._bInvalidated=!0,this._iPopupClosedTimeoutId=null,this._oColumn=null,this._oTable=null,this._attachPopupClosed()},u.prototype.exit=function(){i.prototype.exit&&i.prototype.exit.apply(this,arguments),window.clearTimeout(this._iPopupClosedTimeoutId),this._detachEvents(),this._oColumn=this._oTable=null},u.prototype.onThemeChanged=function(){this.getDomRef()&&this._invalidate()},u.prototype.setParent=function(t){return this._detachEvents(),this._invalidate(),this._updateReferences(t),this._attachEvents(),i.prototype.setParent.apply(this,arguments)},u.prototype._updateReferences=function(e){this._oColumn=e,e&&(t.sap.assert(s.isInstanceOf(e,\"sap/ui/table/Column\"),\"ColumnMenu.setParent: parent must be a subclass of sap.ui.table.Column\"),this._oTable=this._oColumn.getParent(),this._oTable&&t.sap.assert(s.isInstanceOf(this._oTable,\"sap/ui/table/Table\"),\"ColumnMenu.setParent: parent of parent must be subclass of sap.ui.table.Table\"))},u.prototype._attachEvents=function(){this._oTable&&(this._oTable.attachColumnVisibility(this._invalidate,this),this._oTable.attachColumnMove(this._invalidate,this))},u.prototype._detachEvents=function(){this._oTable&&(this._oTable.detachColumnVisibility(this._invalidate,this),this._oTable.detachColumnMove(this._invalidate,this))},u.prototype._invalidate=function(){this._bInvalidated=!0},u.prototype._updateResourceBundle=function(){this._oResBundle=sap.ui.getCore().getLibraryResourceBundle(\"sap.ui.table\"),this._invalidate()},u.prototype._attachPopupClosed=function(){var t=this;a.support.touch||this.getPopup().attachClosed(function(){t._iPopupClosedTimeoutId=window.setTimeout(function(){t._oColumn&&(t._lastFocusedDomRef?t._lastFocusedDomRef.focus():t._oColumn.focus())},0)})},u.prototype.open=function(){this._bInvalidated&&(this._bInvalidated=!1,this.destroyItems(),this._addMenuItems()),this.getItems().length>0&&(this._lastFocusedDomRef=arguments[4],i.prototype.open.apply(this,arguments))},u.prototype._addMenuItems=function(){this._oColumn&&(this._addSortMenuItem(!1),this._addSortMenuItem(!0),this._addFilterMenuItem(),this._addGroupMenuItem(),this._addFreezeMenuItem(),this._addColumnVisibilityMenuItem())},u.prototype._addSortMenuItem=function(t){var e=this._oColumn;if(e.isSortableByMenu()){var i=t?\"desc\":\"asc\",n=t?\"sort-descending\":\"sort-ascending\";this.addItem(this._createMenuItem(i,\"TBL_SORT_\"+i.toUpperCase(),n,function(i){e.sort(t,!0===i.getParameter(\"ctrlKey\"))}))}},u.prototype._addFilterMenuItem=function(){var t=this._oColumn;if(t.isFilterableByMenu()){var e=t.getParent();e&&e.getEnableCustomFilter()?this.addItem(this._createMenuItem(\"filter\",\"TBL_FILTER_ITEM\",\"filter\",function(){e.fireCustomFilter({column:t})})):this.addItem(this._createMenuTextFieldItem(\"filter\",\"TBL_FILTER\",\"filter\",t.getFilterValue(),function(){t.filter(this.getValue())}))}},u.prototype._addGroupMenuItem=function(){var t=this._oColumn;if(t.isGroupable()){var e=this._oTable;this.addItem(this._createMenuItem(\"group\",\"TBL_GROUP\",null,function(){e.setGroupBy(t)}))}},u.prototype._addFreezeMenuItem=function(){var t=this._oColumn,e=this._oTable;if(e&&e.getEnableColumnFreeze()){var i=t.getIndex(),n=i+s.Column.getHeaderSpan(t)==e.getFixedColumnCount();this.addItem(this._createMenuItem(\"freeze\",n?\"TBL_UNFREEZE\":\"TBL_FREEZE\",null,function(){e.fireColumnFreeze({column:t})&&(n?e.setFixedColumnCount(0):e.setFixedColumnCount(i+1))}))}},u.prototype._addColumnVisibilityMenuItem=function(){var t=this._oTable;if(t&&t.getShowColumnVisibilityMenu()){var e=this._createMenuItem(\"column-visibilty\",\"TBL_COLUMNS\");this.addItem(e);var n=new i(e.getId()+\"-menu\");e.setSubmenu(n);var o=t.getColumns();if(t.getColumnVisibilityMenuSorter&&\"function\"==typeof t.getColumnVisibilityMenuSorter){var a=t.getColumnVisibilityMenuSorter();\"function\"==typeof a&&(o=o.sort(a))}for(var u=t.getBinding(),l=s.isInstanceOf(u,\"sap/ui/model/analytics/AnalyticalBinding\"),r=t._getVisibleColumns(),p=0,d=o.length;p<d;p++){var c=o[p];if(l&&s.isInstanceOf(c,\"sap/ui/table/AnalyticalColumn\")){var h=u.getAnalyticalQueryResult(),m=h.getEntityType(),_=u.getModel().getProperty(\"/#\"+m.getTypeDescription().name+\"/\"+c.getLeadingProperty()+\"/sap:visible\");if(_&&(\"false\"===_.value||!1===_.value))continue}var f=this._createColumnVisibilityMenuItem(n.getId()+\"-item-\"+p,c);n.addItem(f),1==r.length&&r[0]===c&&f.setEnabled(!1)}}},u.prototype._createColumnVisibilityMenuItem=function(e,i){function o(t){return t&&t.getText&&t.getText()}var a=i.getName()||o(i.getLabel());return a||i.getMultiLabels().forEach(function(t,e){1===s.Column.getHeaderSpan(i,e)&&(a=o(t)||a)}),new n(e,{text:a,icon:i.getVisible()?\"sap-icon://accept\":null,select:t.proxy(function(t){var e=t.getSource(),n=!i.getVisible();if(n||s.getVisibleColumnCount(this._oTable)>1){var o=i.getParent(),a=!0;o&&s.isInstanceOf(o,\"sap/ui/table/Table\")&&(a=o.fireColumnVisibility({column:i,newVisible:n})),a&&i.setVisible(n),e.setIcon(n?\"sap-icon://accept\":null)}},this)})},u.prototype._createMenuItem=function(t,e,i,o){return new n(this.getId()+\"-\"+t,{text:this._oResBundle.getText(e),icon:i?\"sap-icon://\"+i:null,select:o||function(){}})},u.prototype._createMenuTextFieldItem=function(t,e,i,n,a){return a=a||function(){},new o(this.getId()+\"-\"+t,{label:this._oResBundle.getText(e),icon:i?\"sap-icon://\"+i:null,value:n,select:a||function(){}})},u.prototype._setFilterValue=function(t){var e=this.getParent(),i=e?e.getParent():void 0,n=sap.ui.getCore().byId(this.getId()+\"-filter\");return n&&i&&!i.getEnableCustomFilter()&&n.setValue(t),this},u.prototype._setFilterState=function(t){var e=this.getParent(),i=e?e.getParent():void 0,n=sap.ui.getCore().byId(this.getId()+\"-filter\");return n&&i&&!i.getEnableCustomFilter()&&n.setValueState(t),this},u});",
	"sap/ui/table/ColumnMenuRenderer.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"sap/ui/table/ColumnMenu\"],function(e){\"use strict\";return e.getMetadata().getRenderer()},!0);",
	"sap/ui/table/library.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"sap/ui/core/Core\",\"sap/ui/model/TreeAutoExpandMode\",\"sap/ui/core/library\",\"sap/ui/unified/library\"],function(e,a){\"use strict\";sap.ui.getCore().initLibrary({name:\"sap.ui.table\",version:\"904001.7.0.20251118090100_f0htmcm94p\",dependencies:[\"sap.ui.core\",\"sap.ui.unified\"],designtime:\"sap/ui/table/designtime/library.designtime\",types:[\"sap.ui.table.NavigationMode\",\"sap.ui.table.RowActionType\",\"sap.ui.table.SelectionBehavior\",\"sap.ui.table.SelectionMode\",\"sap.ui.table.SortOrder\",\"sap.ui.table.VisibleRowCountMode\",\"sap.ui.table.SharedDomRef\",\"sap.ui.table.TreeAutoExpandMode\"],interfaces:[],controls:[\"sap.ui.table.AnalyticalColumnMenu\",\"sap.ui.table.AnalyticalTable\",\"sap.ui.table.ColumnMenu\",\"sap.ui.table.Table\",\"sap.ui.table.TreeTable\",\"sap.ui.table.RowAction\"],elements:[\"sap.ui.table.AnalyticalColumn\",\"sap.ui.table.Column\",\"sap.ui.table.Row\",\"sap.ui.table.RowActionItem\",\"sap.ui.table.RowSettings\"],extensions:{flChangeHandlers:{\"sap.ui.table.Column\":{propertyChange:\"default\"},\"sap.ui.table.Table\":{moveElements:\"default\"},\"sap.ui.table.AnalyticalTable\":{moveElements:\"default\"}},\"sap.ui.support\":{publicRules:!0}}});var o=sap.ui.table;return o.NavigationMode={Scrollbar:\"Scrollbar\",Paginator:\"Paginator\"},o.RowActionType={Custom:\"Custom\",Navigation:\"Navigation\",Delete:\"Delete\"},o.SelectionBehavior={Row:\"Row\",RowSelector:\"RowSelector\",RowOnly:\"RowOnly\"},o.SelectionMode={MultiToggle:\"MultiToggle\",Multi:\"Multi\",Single:\"Single\",None:\"None\"},o.SortOrder={Ascending:\"Ascending\",Descending:\"Descending\"},o.VisibleRowCountMode={Fixed:\"Fixed\",Interactive:\"Interactive\",Auto:\"Auto\"},o.SharedDomRef={HorizontalScrollBar:\"hsb\",VerticalScrollBar:\"vsb\"},o.GroupEventType={group:\"group\",ungroup:\"ungroup\",ungroupAll:\"ungroupAll\",moveUp:\"moveUp\",moveDown:\"moveDown\",showGroupedColumn:\"showGroupedColumn\",hideGroupedColumn:\"hideGroupedColumn\"},o.ColumnHeader=o.Column,o.TreeAutoExpandMode=a,o.TableHelper||(o.TableHelper={addTableClass:function(){return\"\"},createLabel:function(e){throw new Error(\"no Label control available!\")},createTextView:function(e){throw new Error(\"no TextView control available!\")},bFinal:!1}),o});",
	"sap/ui/table/library.support.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/support/library\",\"sap/ui/support/supportRules/RuleSet\",\"./rules/TableHelper.support\",\"sap/ui/Device\"],function(e,t,i,o,n){\"use strict\";function a(e){e.id=\"gridTable\"+e.id,o.addRuleToRuleset(e,u)}function s(e,t,i){for(var n,a,s=o.find(t,!0,\"sap/ui/table/Table\"),r=0;r<s.length;r++){n=s[r].getColumns();for(var l=0;l<n.length;l++)!(a=n[l].getTemplate())||i&&!o.isInstanceOf(a,i)||e(s[r],n[l],a)}}var r=t.Categories,l=t.Severity,c={name:\"sap.ui.table\",niceName:\"UI5 Table library\"},u=new i(c);return a({id:\"ContentDensity\",categories:[r.Usage],title:\"Content Density Usage\",description:\"Checks whether the content densities 'Cozy', 'Compact' and 'Condensed' are used correctly.\",resolution:\"Ensure that either only the 'Cozy' or 'Compact' content density is used or the 'Condensed' and 'Compact' content densities in combination are used.\",resolutionurls:[o.createDocuRef(\"Documentation: Content Densities\",\"#docs/guide/e54f729da8e3405fae5e4fe8ae7784c1.html\")],check:function(t,i,n){function a(i,n,a){var s=!1;return i.each(function(){e(this).closest(n).length&&(s=!0)}),s&&a&&o.reportIssue(t,a,l.High),s}var s=e(\"html\"),r=s.find(\".sapUiSizeCozy\"),c=s.find(\".sapUiSizeCompact\"),u=s.find(\".sapUiSizeCondensed\");if(a(c,\".sapUiSizeCozy\",\"'Compact' content density is used within 'Cozy' area.\"),a(r,\".sapUiSizeCompact\",\"'Cozy' content density is used within 'Compact' area.\"),a(u,\".sapUiSizeCozy\",\"'Condensed' content density is used within 'Cozy' area.\"),a(r,\".sapUiSizeCondensed\",\"'Cozy' content density is used within 'Condensed' area.\"),u.length>0){a(u,\".sapUiSizeCompact\")||o.reportIssue(t,\"'Condensed' content density must be used in combination with 'Compact'.\",l.High)}}}),a({id:\"AccessibleLabel\",categories:[r.Accessibility],title:\"Accessible Label\",description:\"Checks whether 'sap.ui.table.Table' controls have an accessible label.\",resolution:\"Use the 'title' aggregation or the 'ariaLabelledBy' association of the 'sap.ui.table.Table' control to define a proper accessible labeling.\",check:function(e,t,i){for(var n=o.find(i,!0,\"sap/ui/table/Table\"),a=0;a<n.length;a++)n[a].getTitle()||0!=n[a].getAriaLabelledBy().length||o.reportIssue(e,\"Table '\"+n[a].getId()+\"' does not have an accessible label.\",l.High,n[a].getId())}}),a({id:\"ColumnTemplateIcon\",categories:[r.Accessibility],title:\"Column template validation - 'sap.ui.core.Icon'\",description:\"The 'decorative' property of control 'sap.ui.core.Icon' is set to 'true' although the control is used as column template.\",resolution:\"Set the 'decorative' property of control 'sap.ui.core.Icon' to 'false' if the control is used as column template.\",check:function(e,t,i){s(function(t,i,n){if(!n.isBound(\"decorative\")&&n.getDecorative()){var a=i.getId();o.reportIssue(e,\"Column '\"+a+\"' of table '\"+t.getId()+\"' uses decorative 'sap.ui.core.Icon' control.\",l.High,a)}},i,\"sap/ui/core/Icon\")}}),a({id:\"ColumnTemplateTextWrapping\",categories:[r.Usage],title:\"Column template validation - 'sap.m.Text'\",description:\"The 'wrapping' and/or 'renderWhitespace' property of the control 'sap.m.Text' is set to 'true' although the control is used as a column template.\",resolution:\"Set the 'wrapping' and 'renderWhitespace' property of the control 'sap.m.Text' to 'false' if the control is used as a column template.\",check:function(e,t,i){s(function(t,i,n){if(n.isBound(\"wrapping\")||!n.isBound(\"wrapping\")&&n.getWrapping()){var a=i.getId();o.reportIssue(e,\"Column '\"+a+\"' of table '\"+t.getId()+\"' uses an 'sap.m.Text' control with wrapping enabled.\",l.High,a)}if(n.isBound(\"renderWhitespace\")||!n.isBound(\"renderWhitespace\")&&n.getRenderWhitespace()){var a=i.getId();o.reportIssue(e,\"Column '\"+a+\"' of table '\"+t.getId()+\"' uses an 'sap.m.Text' control with renderWhitespace enabled.\",l.High,a)}},i,\"sap/m/Text\")}}),a({id:\"AnalyticsNoDeviatingUnits\",categories:[r.Bindings],title:\"Analytical Binding reports 'No deviating units found...'\",description:\"The analytical service returns duplicate IDs. This could also lead to many requests, but the analytical service expects to receive just one record\",resolution:\"Adjust the service implementation.\",check:function(t,i,n){var a=o.find(n,!0,\"sap/ui/table/AnalyticalTable\"),s={};o.checkLogEntries(function(t){if(t.level!=e.sap.log.Level.ERROR&&t.level!=e.sap.log.Level.FATAL)return!1;var i=t.supportInfo;return!(!i||\"sap.ui.model.analytics.AnalyticalBinding\"!==i.type||\"NO_DEVIATING_UNITS\"!==i.analyticalError)},function(e){var i=e.supportInfo.analyticalBindingId;if(i&&!s[\"NO_DEVIATING_UNITS-\"+i])for(var n,r=0;r<a.length;r++)(n=a[r].getBinding(\"rows\"))&&n.__supportUID===i&&(s[\"NO_DEVIATING_UNITS-\"+i]=!0,o.reportIssue(t,\"Analytical Binding reports 'No deviating units found...'\",l.High,a[r].getId()))})}}),a({id:\"RowHeights\",categories:[r.Usage],title:\"Row heights\",description:\"Checks whether the currently visible rows have the expected height.\",resolution:'Check whether content densities are correctly used, and only the supported controls are used as column templates, with their wrapping property set to \"false\"',resolutionurls:[o.createDocuRef(\"Documentation: Content Densities\",\"#/topic/e54f729da8e3405fae5e4fe8ae7784c1\"),o.createDocuRef(\"Documentation: Supported controls\",\"#/topic/148892ff9aea4a18b912829791e38f3e\"),o.createDocuRef(\"API Reference: sap.ui.table.Column#getTemplate\",\"#/api/sap.ui.table.Column/methods/getTemplate\"),{text:\"SAP Fiori Design Guidelines: Grid Table\",href:\"https://experience.sap.com/fiori-design-web/grid-table/\"}],check:function(e,t,i){for(var a,s,r,c,u=o.find(i,!0,\"sap/ui/table/Table\"),p=n.browser.chrome&&1!=window.devicePixelRatio,d=!1,h=0;h<u.length;h++){a=u[h].getRows(),r=u[h]._getDefaultRowHeight();for(var g=0;g<a.length;g++)if(null!=(c=a[g].getDomRef())){if(s=c.getBoundingClientRect().height,p){var f=Math.abs(r-s);f>1&&(d=!0)}else s!==r&&(d=!0);if(d){o.reportIssue(e,\"The row height was expected to be \"+r+\"px, but was \"+s+\"px instead. This causes issues with vertical scrolling.\",l.High,a[g].getId());break}}}}}),{lib:c,ruleset:u}},!0);",
	"sap/ui/table/Row.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/core/Element\",\"sap/ui/model/Context\",\"./TableUtils\"],function(e,t,o,i){\"use strict\";var r=t.extend(\"sap.ui.table.Row\",{metadata:{library:\"sap.ui.table\",defaultAggregation:\"cells\",aggregations:{cells:{type:\"sap.ui.core.Control\",multiple:!0,singularName:\"cell\"},_rowAction:{type:\"sap.ui.table.RowAction\",multiple:!1,visibility:\"hidden\"},_settings:{type:\"sap.ui.table.RowSettings\",multiple:!1,visibility:\"hidden\"}}}});return r.prototype.init=function(){this.initDomRefs()},r.prototype.exit=function(){this.initDomRefs()},r.prototype.getFocusInfo=function(){var e=this.getParent();return e?e.getFocusInfo():t.prototype.getFocusInfo.apply(this,arguments)},r.prototype.applyFocusInfo=function(e){var o=this.getParent();return o?o.applyFocusInfo(e):t.prototype.applyFocusInfo.apply(this,arguments),this},r.prototype.addStyleClass=function(t){e(this.getDomRefs(!1,!0)).addClass(t)},r.prototype.removeStyleClass=function(t){e(this.getDomRefs(!1,!0)).removeClass(t)},r.prototype.initDomRefs=function(){this._mDomRefs={}},r.prototype.getIndex=function(){var e=this.getParent();if(e){var t=e.indexOfRow(this),o=e.getFixedRowCount();if(o>0&&t<o)return t;var i=e.getFixedBottomRowCount(),r=e.getVisibleRowCount();if(i>0&&t>=r-i){var n=e._getTotalRowCount();return n>=r?n-(r-t):t}return e._getFirstRenderedRowIndex()+t}return-1},r.prototype.getDomRefs=function(t,o){var i=!0===t?\"jQuery\":\"dom\",r=!0===t?e.sap.byId:e.sap.domById,n=this._mDomRefs;if(!n[i]){n[i]={};var l=this.getParent();if(l){var s=l.indexOfRow(this);n[i].rowSelector=r(l.getId()+\"-rowsel\"+s),n[i].rowAction=r(l.getId()+\"-rowact\"+s)}n[i].rowScrollPart=r(this.getId()),n[i].rowFixedPart=r(this.getId()+\"-fixed\"),n[i].rowSelectorText=r(this.getId()+\"-rowselecttext\"),!0===t&&(n[i].row=n[i].rowScrollPart,n[i].rowFixedPart.length>0?n[i].row=n[i].row.add(n[i].rowFixedPart):n[i].rowFixedPart=void 0,n[i].rowSelector&&n[i].rowSelector.length>0?n[i].row=n[i].row.add(n[i].rowSelector):n[i].rowSelector=void 0,n[i].rowAction&&n[i].rowAction.length>0?n[i].row=n[i].row.add(n[i].rowAction):n[i].rowAction=void 0)}var a=n[i];return o?Object.keys(a).map(function(e){return a[e]}).filter(Boolean):a},r.prototype._updateSelection=function(e,t,o){var r=e.isIndexSelected(this.getIndex()),n=this.getDomRefs(!0),l=\"rowSelect\";if(r&&(l=\"rowDeselect\"),n.rowSelector&&n.rowSelector.attr(\"title\",this._bHidden?\"\":t.mouse[l]),n.rowSelectorText){var s=\"\";this._bHidden||i.Grouping.isInSumRow(n.rowSelector)||i.Grouping.isInGroupingRow(n.rowSelector)||(s=t.keyboard[l]),n.rowSelectorText.text(s)}var a=n.rowScrollPart;n.rowFixedPart&&(a=a.add(n.rowFixedPart)),o&&!this._bHidden?a.attr(\"title\",t.mouse[l]):a.removeAttr(\"title\"),n.row&&(n.row.toggleClass(\"sapUiTableRowSel\",r),e._getAccExtension().updateAriaStateOfRow(this,n,r))},r.prototype.setRowBindingContext=function(e,t,i){var r;!e||e instanceof o||(r=e,e=e.context);var n=this.getDomRefs(!0).row;this._bHidden=!e,n.toggleClass(\"sapUiTableRowHidden\",this._bHidden),this._collectRenderingInformation(e,r,i),this.setBindingContext(e,t)},r.prototype.setBindingContext=function(e,o){var i=t.prototype.setBindingContext.call(this,e||null,o);return this._updateTableCells(e),i},r.prototype._updateTableCells=function(e){var t=this.getParent();if(t)for(var o,i,r,n=this.getCells(),l=this.getIndex(),s=!!t._updateTableCell,a=0;a<n.length;a++)o=n[a],r=!!o._updateTableCell,i=r||s?o.$().closest(\"td\"):null,r&&o._updateTableCell(o,e,i,l),s&&t._updateTableCell(o,e,i,l)},r.prototype._collectRenderingInformation=function(e,t,o){this._oNodeState=void 0,this._iLevel=0,this._bIsExpanded=!1,this._bHasChildren=!1,this._sTreeIconClass=\"\",t&&(this._oNodeState=t.nodeState,this._iLevel=t.level,this._bIsExpanded=!1,this._bHasChildren=!1,this._sTreeIconClass=\"sapUiTableTreeIconLeaf\",this._sGroupIconClass=\"\",o&&(o.getLevel?this._bIsExpanded=o.isExpanded(this.getIndex()):o.findNode&&(this._bIsExpanded=!(!this||!this._oNodeState)&&this._oNodeState.expanded),o.nodeHasChildren?this._oNodeState&&(this._bHasChildren=o.nodeHasChildren(t)):o.hasChildren&&(this._bHasChildren=o.hasChildren(e)),this._bHasChildren&&(this._sTreeIconClass=this._bIsExpanded?\"sapUiTableTreeIconNodeOpen\":\"sapUiTableTreeIconNodeClosed\",this._sGroupIconClass=this._bIsExpanded?\"sapUiTableGroupIconOpen\":\"sapUiTableGroupIconClosed\")))},r.prototype.destroy=function(){return this.removeAllCells(),t.prototype.destroy.apply(this,arguments)},r.prototype.getDragGhost=function(){function e(t){t.removeAttribute(\"id\"),t.removeAttribute(\"data-sap-ui\"),t.removeAttribute(\"data-sap-ui-related\");for(var o=t.children.length,i=0;i<o;i++)e(t.children[i])}function t(e,t){var o=e.cloneNode(),i=e.querySelector(\"thead\").cloneNode(!0),r=e.querySelector(\"tbody\").cloneNode(),n=t.cloneNode(!0);return r.appendChild(n),o.appendChild(i),o.appendChild(r),o}var o,i,r,n=this.getParent(),l=n.getDomRef(),s=this.getDomRefs(),a=n._getSelectedIndicesCount();if(o=l.cloneNode(),o.classList.add(\"sapUiTableRowGhost\"),o.classList.remove(\"sapUiTableVScr\"),o.classList.remove(\"sapUiTableHScr\"),o.style.width=l.getBoundingClientRect().width+\"px\",null!=s.rowSelector&&(i=n.getDomRef(\"sapUiTableRowHdrScr\").cloneNode(),r=s.rowSelector.cloneNode(!0),i.appendChild(r),o.appendChild(i)),null!=s.rowFixedPart&&(i=n.getDomRef(\"sapUiTableCtrlScrFixed\").cloneNode(),r=t(n.getDomRef(\"table-fixed\"),s.rowFixedPart),i.appendChild(r),o.appendChild(i)),null!=s.rowScrollPart){i=n.getDomRef(\"sapUiTableCtrlScr\").cloneNode(),r=t(n.getDomRef(\"table\"),s.rowScrollPart),i.appendChild(n.getDomRef(\"tableCtrlCnt\").cloneNode()),i.firstChild.appendChild(r),o.appendChild(i)}if(null!=s.rowAction&&(i=n.getDomRef(\"sapUiTableRowActionScr\").cloneNode(),r=s.rowAction.cloneNode(!0),i.appendChild(r),o.appendChild(i)),a>1){i=document.createElement(\"div\"),i.classList.add(\"sapUiTableRowGhostCount\");var d=document.createElement(\"div\");d.textContent=a,i.appendChild(d),o.appendChild(i)}return e(o),o},r});",
	"sap/ui/table/RowAction.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/core/Control\",\"./library\",\"sap/ui/core/Icon\",\"sap/ui/unified/Menu\",\"sap/ui/core/Popup\",\"./RowActionRenderer\",\"jquery.sap.keycodes\"],function(t,e,i,s,o,n,a){\"use strict\";var r=e.extend(\"sap.ui.table.RowAction\",{metadata:{library:\"sap.ui.table\",properties:{visible:{type:\"boolean\",group:\"Misc\",defaultValue:!0}},defaultAggregation:\"items\",aggregations:{items:{type:\"sap.ui.table.RowActionItem\",multiple:!0},_icons:{type:\"sap.ui.core.Icon\",multiple:!0,visibility:\"hidden\"},_menu:{type:\"sap.ui.unified.Menu\",multiple:!1,visibility:\"hidden\"}},events:{}}});return r.prototype.init=function(){var e=function(t){return this.setAggregation(\"tooltip\",t,!0),this.setSrc(this.getSrc()),this},i=function(e){this._bKeyboard=e.which===t.sap.KeyCodes.SPACE||e.which===t.sap.KeyCodes.ENTER,s.prototype.onkeyup.apply(this,arguments)},o=this,n=new s(this.getId()+\"-icon0\",{decorative:!1,press:function(t){o._handlePress(t,!0)}});n.addStyleClass(\"sapUiTableActionIcon\"),n.setTooltip=e,n.onkeyup=i,this.addAggregation(\"_icons\",n),n=new s(this.getId()+\"-icon1\",{decorative:!1,press:function(t){o._handlePress(t,!1)}}),n.addStyleClass(\"sapUiTableActionIcon\"),n.setTooltip=e,n.onkeyup=i,this.addAggregation(\"_icons\",n),this._oResBundle=sap.ui.getCore().getLibraryResourceBundle(\"sap.ui.table\"),this._iLen=0,this._iCount=2,this._aActions=[\"\",\"\"],this._iLastCloseTime=0},r.prototype.onAfterRendering=function(){this._updateIcons()},r.prototype.setVisible=function(t){return this.setProperty(\"visible\",t,!0),this.$().toggleClass(\"sapUiTableActionHidden\",!t),this},r.prototype.setTooltip=function(t){this.setAggregation(\"tooltip\",t,!0);var e=this.getTooltip_AsString();return e?this.$().attr(\"title\",e):this.$().removeAttr(\"title\"),this},r.prototype.insertItem=function(t,e){return this.insertAggregation(\"items\",t,e,!0),this._updateIcons(!0),this},r.prototype.addItem=function(t){return this.addAggregation(\"items\",t,!0),this._updateIcons(!0),this},r.prototype.removeItem=function(t){var e=this.removeAggregation(\"items\",t,!0);return this._updateIcons(!0),e},r.prototype.removeAllItems=function(){var t=this.removeAllAggregation(\"items\",!0);return this._updateIcons(!0),t},r.prototype.destroyItems=function(){return this.destroyAggregation(\"items\",!0),this._updateIcons(!0),this},r.prototype.getAccessibilityInfo=function(){var t,e=this.$().parent(),i=this.getVisible()&&this._iLen>0&&this._iCount>0&&!e.hasClass(\"sapUiTableRowHidden\")&&!e.hasClass(\"sapUiTableGroupHeader\")&&!e.hasClass(\"sapUiAnalyticalTableSum\");return t=i?this._oResBundle.getText(1==this._iLen?\"TBL_ROW_ACTION_SINGLE_ACTION\":\"TBL_ROW_ACTION_MULTIPLE_ACTION\",[this._iLen]):this._oResBundle.getText(\"TBL_ROW_ACTION_NO_ACTION\"),{focusable:i,enabled:i,description:t}},r.prototype._getVisibleItems=function(t){if(!this._aVisibleItems||t){this._aVisibleItems=[],this._iLen=0;for(var e=this.getItems(),i=0;i<e.length;i++)e[i].getVisible()&&(this._aVisibleItems.push(e[i]),this._iLen++)}return this._aVisibleItems},r.prototype._getRow=function(){return this.getParent()},r.prototype._getCount=function(){return this._iCount},r.prototype._setCount=function(t){t<0?this._iCount=0:t>=0&&(this._iCount=Math.min(t,2)),this._updateIcons()},r.prototype._setFixedLayout=function(t){this._bFixedLayout=!!t,this._updateIcons()},r.prototype._setIconLabel=function(t){for(var e=this.getAggregation(\"_icons\"),i=0;i<e.length;i++)e[i].removeAllAriaLabelledBy(),t&&e[i].addAriaLabelledBy(t)},r.prototype._handlePress=function(t,e){var i=e?0:1,s=this.getAggregation(\"_icons\")[i],a=this._aActions[i],r=s._bKeyboard;if(s._bKeyboard=!1,\"action\"==a)this._getVisibleItems()[i]._doFirePress();else if(\"action_fixed\"==a)this._getVisibleItems()[0]._doFirePress();else if(\"menu\"==a){var l=this.getAggregation(\"_menu\");if(l||(l=new o,this.setAggregation(\"_menu\",l,!0),l.getPopup().attachClosed(function(){this._iLastCloseTime=Date.now()},this)),l.removeAllItems(),Date.now()-this._iLastCloseTime<500)return;for(var p=this.getItems(),u=e?0:1;u<p.length;u++)l.addItem(p[u]._getMenuItem());l.open(!!r,s,n.Dock.EndTop,n.Dock.EndBottom,s)}},r.prototype._updateIcons=function(e){function i(t){o[0].$()[0==t?\"attr\":\"removeAttr\"](\"aria-haspopup\",0==t?\"true\":void 0),o[1].$()[1==t?\"attr\":\"removeAttr\"](\"aria-haspopup\",1==t?\"true\":void 0)}var s=this._getVisibleItems(e),o=this.getAggregation(\"_icons\"),n=this.$().children();if(this._bFixedLayout&&1==this._iLen&&2==this._iCount){var a=this.getItems();if(a.length>1&&s[0]===a[1])return s[0]._syncIcon(o[1]),t(n.get(0)).toggleClass(\"sapUiTableActionHidden\",!0),t(n.get(1)).toggleClass(\"sapUiTableActionHidden\",!1),i(-1),void(this._aActions=[\"\",\"action_fixed\"])}0==this._iLen||0==this._iCount?(n.toggleClass(\"sapUiTableActionHidden\",!0),i(-1),this._aActions=[\"\",\"\"]):1==this._iLen&&this._iCount>0?(s[0]._syncIcon(o[0]),t(n.get(0)).toggleClass(\"sapUiTableActionHidden\",!1),t(n.get(1)).toggleClass(\"sapUiTableActionHidden\",!0),i(-1),this._aActions=[\"action\",\"\"]):2==this._iLen&&2==this._iCount?(s[0]._syncIcon(o[0]),s[1]._syncIcon(o[1]),n.toggleClass(\"sapUiTableActionHidden\",!1),i(-1),this._aActions=[\"action\",\"action\"]):this._iLen>2&&2==this._iCount?(s[0]._syncIcon(o[0]),o[1].setSrc(\"sap-icon://overflow\"),o[1].setTooltip(this._oResBundle.getText(\"TBL_ROW_ACTION_MORE\")),n.toggleClass(\"sapUiTableActionHidden\",!1),i(1),this._aActions=[\"action\",\"menu\"]):(o[0].setSrc(\"sap-icon://overflow\"),o[0].setTooltip(this._oResBundle.getText(\"TBL_ROW_ACTION_MORE\")),t(n.get(0)).toggleClass(\"sapUiTableActionHidden\",!1),t(n.get(1)).toggleClass(\"sapUiTableActionHidden\",!0),i(0),this._aActions=[\"menu\",\"\"])},r});",
	"sap/ui/table/RowActionItem.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"sap/ui/core/Element\",\"./library\",\"sap/ui/unified/MenuItem\"],function(t,e,i){\"use strict\";var o=e.RowActionType,s=t.extend(\"sap.ui.table.RowActionItem\",{metadata:{library:\"sap.ui.table\",properties:{icon:{type:\"sap.ui.core.URI\",group:\"Data\",defaultValue:null},visible:{type:\"boolean\",group:\"Misc\",defaultValue:!0},text:{type:\"string\",group:\"Misc\",defaultValue:\"\"},type:{type:\"sap.ui.table.RowActionType\",group:\"Behavior\",defaultValue:o.Custom}},events:{press:{item:{type:\"sap.ui.table.RowActionItem\"},row:{type:\"sap.ui.table.Row\"}}}}});return s.prototype.exit=function(){this._menuItem&&(this._menuItem.destroy(),this._menuItem=null)},s.prototype.setIcon=function(t){return this.setProperty(\"icon\",t,!0),this._updateRowAction(),this},s.prototype.setText=function(t){return this.setProperty(\"text\",t,!0),this._updateRowAction(),this},s.prototype.setType=function(t){return this.setProperty(\"type\",t,!0),this._updateRowAction(),this},s.prototype.setVisible=function(t){return this.setProperty(\"visible\",t,!0),this._updateRowAction(!0),this},s.prototype.setTooltip=function(t){return this.setAggregation(\"tooltip\",t,!0),this._updateRowAction(),this},s.prototype._doFirePress=function(){var t=this.getParent();this.firePress({item:this,row:t&&t._getRow?t._getRow():null})},s.prototype._getMenuItem=function(){if(!this._menuItem){var t=this;this._menuItem=new i({select:function(e){t._doFirePress()}})}return this._menuItem.setIcon(this._getIcon()),this._menuItem.setVisible(this.getVisible()),this._menuItem.setText(this._getText(!1)),this._menuItem},s.prototype._getIcon=function(){var t=this.getIcon();return t||(this.getType()==o.Navigation?\"sap-icon://navigation-right-arrow\":this.getType()==o.Delete?\"sap-icon://sys-cancel\":null)},s.prototype._getText=function(t){var e=t?this.getTooltip_AsString()||this.getText():this.getText()||this.getTooltip_AsString();return e||(this.getType()==o.Navigation?this.getParent()._oResBundle.getText(\"TBL_ROW_ACTION_NAVIGATE\"):this.getType()==o.Delete?this.getParent()._oResBundle.getText(\"TBL_ROW_ACTION_DELETE\"):null)},s.prototype._syncIcon=function(t){t.setSrc(this._getIcon()),t.setTooltip(this._getText(!0))},s.prototype._updateRowAction=function(t){var e=this.getParent();e&&e._updateIcons&&e._updateIcons(t)},s});",
	"sap/ui/table/RowActionRenderer.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"sap/ui/table/Row\"],function(e){\"use strict\";var t={};return t.render=function(t,i){t.write(\"<div\"),t.writeControlData(i),t.addClass(\"sapUiTableAction\"),i.getParent()instanceof e||t.addStyle(\"display\",\"none\"),i.getVisible()||t.addClass(\"sapUiTableActionHidden\"),t.writeClasses(),t.writeStyles();var r=i.getTooltip_AsString();r&&t.writeAttributeEscaped(\"title\",r),t.write(\">\");var a=i.getAggregation(\"_icons\");t.write(\"<div>\"),t.renderControl(a[0]),t.write(\"</div>\"),t.write(\"<div>\"),t.renderControl(a[1]),t.write(\"</div>\"),t.write(\"</div>\")},t},!0);",
	"sap/ui/table/RowSettings.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"sap/ui/core/Element\",\"./TableUtils\",\"./library\",\"sap/ui/core/library\"],function(t,e,i,a){\"use strict\";var r=a.MessageType,s=t.extend(\"sap.ui.table.RowSettings\",{metadata:{library:\"sap.ui.table\",properties:{highlight:{type:\"sap.ui.core.MessageType\",group:\"Appearance\",defaultValue:\"None\"}}}});return s.prototype.init=function(){this._oResBundle=sap.ui.getCore().getLibraryResourceBundle(\"sap.ui.table\")},s.prototype.setHighlight=function(t){var e,i;if(this.setProperty(\"highlight\",t,!0),null==(e=this._getRow()))return this;if(null==(i=e.getDomRef(\"highlight\")))return this;for(var a in r)i.classList.remove(\"sapUiTableRowHighlight\"+a);i.classList.add(this._getHighlightCSSClassName());var s=e.getParent(),l=null!=s?s._getAccExtension():null;return null!=l&&l.updateAriaStateOfRowHighlight(this),this},s.prototype._getHighlightCSSClassName=function(){var t=this.getHighlight();return null==t&&(t=r.None),\"sapUiTableRowHighlight\"+t},s.prototype._getHighlightText=function(){var t=this.getHighlight();return null==t||t===r.None?\"\":this._oResBundle.getText(\"TBL_ROW_STATE_\"+t.toUpperCase())},s.prototype._getRow=function(){var t=this.getParent();return e.isInstanceOf(t,\"sap/ui/table/Row\")?t:null},s});",
	"sap/ui/table/rules/TableHelper.support.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/support/library\"],function(e,n){\"use strict\";var r=n.Audiences,t=n.Categories,i=n.Severity,u={DOCU_REF:\"https://sapui5.hana.ondemand.com/\",DEFAULT_RULE_DEF:{audiences:[r.Application],categories:[t.Other],enabled:!0,minversion:\"1.38\",maxversion:\"-\",title:\"\",description:\"\",resolution:\"\",resolutionurls:[],check:function(e,n,r){}},normalizeRule:function(n){return e.extend({},u.DEFAULT_RULE_DEF,n)},addRuleToRuleset:function(n,r){n=u.normalizeRule(n);var t=r.addRule(n);\"success\"!=t&&e.sap.log.warning(\"Support Rule '\"+n.id+\"' for library sap.ui.table not applied: \"+t)},createDocuRef:function(e,n){return{text:e,href:u.DOCU_REF+n}},reportIssue:function(e,n,r,t){e.addIssue({severity:r||i.Medium,details:n,context:{id:t||\"WEBPAGE\"}})},isInstanceOf:function(e,n){if(!e||!n)return!1;var r=sap.ui.require(n);return!!(r&&e instanceof r)},find:function(e,n,r){var t=e.getElements(),i=[];for(var s in t){var a=t[s];u.isInstanceOf(a,r)&&(n&&a.getDomRef()||!n)&&i.push(a)}return i},checkLogEntries:function(n,r){for(var t,i=e.sap.log.getLogEntries(),u=0;u<i.length;u++)if(t=i[u],n(t)&&r(t))return}};return u},!0);",
	"sap/ui/table/Table.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/Device\",\"sap/ui/core/Control\",\"sap/ui/core/Element\",\"sap/ui/core/IconPool\",\"sap/ui/model/ChangeReason\",\"sap/ui/model/Filter\",\"sap/ui/model/SelectionModel\",\"sap/ui/model/Sorter\",\"sap/ui/model/BindingMode\",\"./Column\",\"./Row\",\"./library\",\"./TableUtils\",\"./TableExtension\",\"./TableAccExtension\",\"./TableKeyboardExtension\",\"./TablePointerExtension\",\"./TableScrollExtension\",\"./TableDragAndDropExtension\",\"./TableRenderer\",\"jquery.sap.dom\",\"jquery.sap.trace\",\"jquery.sap.events\"],function(t,e,i,o,n,s,r,a,l,u,h,d,p,g,c,w,R,f,m,b,C){\"use strict\";var _=p.GroupEventType,y=p.NavigationMode,v=p.SelectionMode,S=p.SelectionBehavior,T=p.SortOrder,x=p.VisibleRowCountMode,A=i.extend(\"sap.ui.table.Table\",{metadata:{library:\"sap.ui.table\",properties:{width:{type:\"sap.ui.core.CSSSize\",group:\"Dimension\",defaultValue:\"auto\"},rowHeight:{type:\"int\",group:\"Appearance\",defaultValue:null},columnHeaderHeight:{type:\"int\",group:\"Appearance\",defaultValue:null},columnHeaderVisible:{type:\"boolean\",group:\"Appearance\",defaultValue:!0},visibleRowCount:{type:\"int\",group:\"Appearance\",defaultValue:10},firstVisibleRow:{type:\"int\",group:\"Appearance\",defaultValue:0},selectionMode:{type:\"sap.ui.table.SelectionMode\",group:\"Behavior\",defaultValue:v.MultiToggle},selectionBehavior:{type:\"sap.ui.table.SelectionBehavior\",group:\"Behavior\",defaultValue:S.RowSelector},selectedIndex:{type:\"int\",group:\"Appearance\",defaultValue:-1},editable:{type:\"boolean\",group:\"Behavior\",defaultValue:!0},navigationMode:{type:\"sap.ui.table.NavigationMode\",group:\"Behavior\",defaultValue:y.Scrollbar},threshold:{type:\"int\",group:\"Appearance\",defaultValue:100},enableColumnReordering:{type:\"boolean\",group:\"Behavior\",defaultValue:!0},enableGrouping:{type:\"boolean\",group:\"Behavior\",defaultValue:!1},showColumnVisibilityMenu:{type:\"boolean\",group:\"Appearance\",defaultValue:!1},showNoData:{type:\"boolean\",group:\"Appearance\",defaultValue:!0},visibleRowCountMode:{type:\"sap.ui.table.VisibleRowCountMode\",group:\"Appearance\",defaultValue:x.Fixed},minAutoRowCount:{type:\"int\",group:\"Appearance\",defaultValue:5},fixedColumnCount:{type:\"int\",group:\"Appearance\",defaultValue:0},fixedRowCount:{type:\"int\",group:\"Appearance\",defaultValue:0},fixedBottomRowCount:{type:\"int\",group:\"Appearance\",defaultValue:0},enableColumnFreeze:{type:\"boolean\",group:\"Behavior\",defaultValue:!1},enableCellFilter:{type:\"boolean\",group:\"Behavior\",defaultValue:!1},showOverlay:{type:\"boolean\",group:\"Appearance\",defaultValue:!1},enableSelectAll:{type:\"boolean\",group:\"Behavior\",defaultValue:!0},enableCustomFilter:{type:\"boolean\",group:\"Behavior\",defaultValue:!1},enableBusyIndicator:{type:\"boolean\",group:\"Behavior\",defaultValue:!1},rowActionCount:{type:\"int\",group:\"Appearance\",defaultValue:0},alternateRowColors:{type:\"boolean\",group:\"Appearance\",defaultValue:!1}},defaultAggregation:\"columns\",aggregations:{title:{type:\"sap.ui.core.Control\",altTypes:[\"string\"],multiple:!1},footer:{type:\"sap.ui.core.Control\",altTypes:[\"string\"],multiple:!1},toolbar:{type:\"sap.ui.core.Toolbar\",multiple:!1,deprecated:!0},extension:{type:\"sap.ui.core.Control\",multiple:!0,singularName:\"extension\"},columns:{type:\"sap.ui.table.Column\",multiple:!0,singularName:\"column\",bindable:\"bindable\"},rows:{type:\"sap.ui.table.Row\",multiple:!0,singularName:\"row\",bindable:\"bindable\"},noData:{type:\"sap.ui.core.Control\",altTypes:[\"string\"],multiple:!1},rowActionTemplate:{type:\"sap.ui.table.RowAction\",multiple:!1},rowSettingsTemplate:{type:\"sap.ui.table.RowSettings\",multiple:!1},dragDropConfig:{name:\"dragDropConfig\",type:\"sap.ui.core.dnd.DragDropBase\",multiple:!0,singularName:\"dragDropConfig\"},contextMenu:{type:\"sap.ui.core.IContextMenu\",multiple:!1}},associations:{groupBy:{type:\"sap.ui.table.Column\",multiple:!1},ariaLabelledBy:{type:\"sap.ui.core.Control\",multiple:!0,singularName:\"ariaLabelledBy\"}},events:{rowSelectionChange:{parameters:{rowIndex:{type:\"int\"},rowContext:{type:\"object\"},rowIndices:{type:\"int[]\"},selectAll:{type:\"boolean\"},userInteraction:{type:\"boolean\"}}},columnSelect:{allowPreventDefault:!0,parameters:{column:{type:\"sap.ui.table.Column\"}}},columnResize:{allowPreventDefault:!0,parameters:{column:{type:\"sap.ui.table.Column\"},width:{type:\"sap.ui.core.CSSSize\"}}},columnMove:{allowPreventDefault:!0,parameters:{column:{type:\"sap.ui.table.Column\"},newPos:{type:\"int\"}}},sort:{allowPreventDefault:!0,parameters:{column:{type:\"sap.ui.table.Column\"},sortOrder:{type:\"sap.ui.table.SortOrder\"},columnAdded:{type:\"boolean\"}}},filter:{allowPreventDefault:!0,parameters:{column:{type:\"sap.ui.table.Column\"},value:{type:\"string\"}}},group:{allowPreventDefault:!0,parameters:{column:{type:\"sap.ui.table.Column\"}}},columnVisibility:{allowPreventDefault:!0,parameters:{column:{type:\"sap.ui.table.Column\"},visible:{type:\"boolean\"}}},cellClick:{allowPreventDefault:!0,parameters:{cellControl:{type:\"sap.ui.core.Control\"},cellDomRef:{type:\"Object\"},rowIndex:{type:\"int\"},columnIndex:{type:\"int\"},columnId:{type:\"string\"},rowBindingContext:{type:\"sap.ui.model.Context\"}}},cellContextmenu:{allowPreventDefault:!0,parameters:{cellControl:{type:\"sap.ui.core.Control\"},cellDomRef:{type:\"Object\"},rowIndex:{type:\"int\"},columnIndex:{type:\"int\"},columnId:{type:\"string\"},rowBindingContext:{type:\"sap.ui.model.Context\"}}},beforeOpenContextMenu:{allowPreventDefault:!0,parameters:{rowIndex:{type:\"int\"},columnIndex:{type:\"int\"},contextMenu:{type:\"sap.ui.core.IContextMenu\"}}},columnFreeze:{allowPreventDefault:!0,parameters:{column:{type:\"sap.ui.table.Column\"}}},customFilter:{column:{type:\"sap.ui.table.Column\"},value:{type:\"string\"}},firstVisibleRowChanged:{firstVisibleRow:{type:\"int\"}},busyStateChanged:{busy:{type:\"boolean\"}}},designtime:\"sap/ui/table/designtime/Table.designtime\"}});return n.insertFontFaceStyle(),A.prototype.init=function(){this._iBaseFontSize=parseFloat(t(\"body\").css(\"font-size\"))||16,this._oResBundle=sap.ui.getCore().getLibraryResourceBundle(\"sap.ui.table\"),this._bRtlMode=sap.ui.getCore().getConfiguration().getRTL(),this._attachExtensions(),this._bRowAggregationInvalid=!0,this._mTimeouts={},this._mAnimationFrames={},this._bHideStandardTooltips=!1,this._lastCalledUpdateRows=0,this._iBindingTimerDelay=50,this._aRowHeights=[],this._iRenderedFirstVisibleRow=0,this._aSortedColumns=[];var e=this;this._performUpdateRows=function(t){e.bIsDestroyed||(e._lastCalledUpdateRows=Date.now(),e._updateBindingContexts(),e._bInvalid||(e._updateTableContent(),e._getAccExtension().updateAccForCurrentCell(!1),e._updateSelection(),e._collectTableSizes(),e._aRowHeights=e._collectRowHeights(!1),e._updateRowHeights(e._collectRowHeights(!0),!0),e._updateRowHeights(e._aRowHeights,!1),g.isVariableRowHeightEnabled(e)&&(e._iRenderedFirstVisibleRow=this._getFirstRenderedRowIndex()),e._getScrollExtension().updateVerticalScrollbarVisibility()),e._mTimeouts.bindingTimer=void 0,e._fireRowsUpdated(t))},this._initSelectionModel(a.MULTI_SELECTION),this._aTableHeaders=[],this._aIdxCols2Cells=[],this._bInheritEditableToControls=!1,this._bAllowColumnHeaderTextSelection=!1,this._iPendingRequests=0,this._bPendingRequest=!1,this._iBindingLength=null,this._iTableRowContentHeight=0,this._bFirstRendering=!0,this._nDevicePixelRatio=window.devicePixelRatio,this._bInvalid=!0},A.prototype._attachExtensions=function(){this._bExtensionsInitialized||(c.enrich(this,f),c.enrich(this,m),c.enrich(this,R),c.enrich(this,w),c.enrich(this,b),this._bExtensionsInitialized=!0)},A.prototype.exit=function(){this._bExitCalled=!0,this.invalidateRowsAggregation(),this._detachExtensions(),null!=this._dataReceivedHandlerId&&(t.sap.clearDelayedCall(this._dataReceivedHandlerId),delete this._dataReceivedHandlerId),this._cleanUpTimers(),this._detachEvents(),this._oSelection&&this._oSelection.destroy(),delete this._aTableHeaders},A.prototype._detachExtensions=function(){c.cleanup(this)},A.prototype.onThemeChanged=function(){this.getDomRef()&&this.invalidate()},A.prototype.onlocalizationChanged=function(t){var e=t.changes||{},i=e.hasOwnProperty(\"rtl\"),o=e.hasOwnProperty(\"language\");(i||o)&&(this._adaptLocalization(i,o),this.invalidate())},A.prototype._adaptLocalization=function(t,e){if(t&&(this._bRtlMode=sap.ui.getCore().getConfiguration().getRTL()),e){var i,o=this.getRows();this._oResBundle=sap.ui.getCore().getLibraryResourceBundle(\"sap.ui.table\");var n;for(i=0;i<o.length;i++)(n=o[i].getAggregation(\"_rowAction\"))&&(n._oResBundle=this._oResBundle);var s;for(i=0;i<o.length;i++)(s=o[i].getAggregation(\"_settings\"))&&(s._oResBundle=this._oResBundle);g.Menu.cleanupDataCellContextMenu(this),this._invalidateColumnMenus(!0)}},A.prototype._collectRowHeights=function(t){var i=this.getDomRef();if(!i)return[];if(t&&this.getColumnHeaderHeight())return[];for(var o=this._getDefaultRowHeight(),n=t?\".sapUiTableColHdrTr\":\".sapUiTableTr\",s=i.querySelectorAll(\".sapUiTableCtrlFixed > tbody > tr\"+n),r=i.querySelectorAll(\".sapUiTableCtrlScroll > tbody > tr\"+n),a=this.getRows().length,l=[],u=e.browser.chrome&&1!=window.devicePixelRatio,h=0;h<a;h++){var d=null==s[h]?0:s[h].getBoundingClientRect().height,p=null==r[h]?0:r[h].getBoundingClientRect().height,g=Math.max(d,p);if(u){var c=o-g;if(c>0&&c<1){l.push(Math.max(g,o-1));continue}}l.push(Math.max(g,o))}return l},A.prototype._resetRowHeights=function(){var t=this._getDefaultRowHeight(),e=\"\";t&&(e=t+\"px\");var i=this.getDomRef();if(i)for(var o=i.querySelectorAll(\".sapUiTableTr\"),n=0;n<o.length;n++)o[n].style.height=e},A.prototype._resetColumnHeaderHeights=function(){if(!this.getColumnHeaderHeight()){var t=this.getDomRef();if(t)for(var e=t.querySelectorAll(\".sapUiTableColHdrTr\"),i=0;i<e.length;i++)e[i].style.height=null}},A.prototype._determineAvailableSpace=function(){var i=this.getDomRef();if(i&&i.parentNode){var o=i.querySelector(\".sapUiTableCCnt\");if(o){var n=i.scrollHeight-o.clientHeight,s=0;if(i.parentNode.firstChild!==i){var r=parseFloat(window.getComputedStyle(i.parentNode).paddingTop);isNaN(r)&&(r=0),s=i.offsetTop-r}var a=this._getScrollExtension();if(null==a.getHorizontalScrollbar()||!a.isHorizontalScrollbarVisible()){var l={};l[e.browser.BROWSER.CHROME]=16,l[e.browser.BROWSER.FIREFOX]=16,l[e.browser.BROWSER.INTERNET_EXPLORER]=18,l[e.browser.BROWSER.EDGE]=12,l[e.browser.BROWSER.SAFARI]=16,l[e.browser.BROWSER.ANDROID]=8,n+=l[e.browser.name]}null==this._iLastAvailableSpace&&(this._iLastAvailableSpace=0);var u=Math.floor(t(i.parentNode).height()-n-s);return Math.abs(u-this._iLastAvailableSpace)>=5&&(this._iLastAvailableSpace=u),this._iLastAvailableSpace}}return 0},A.prototype._collectTableSizes=function(){var t={tableCtrlScrollWidth:0,tableRowHdrScrWidth:0,tableCtrlScrWidth:0,tableHSbScrollLeft:0,tableCtrlFixedWidth:0,tableCntHeight:0,tableCntWidth:0},e=this.getDomRef();if(!e)return t;var i=e.querySelector(\".sapUiTableCnt\");i&&(t.tableCntHeight=i.clientHeight,t.tableCntWidth=i.clientWidth);var o=e.querySelector(\".sapUiTableCtrlScroll:not(.sapUiTableCHT)\");o&&(t.tableCtrlScrollWidth=o.clientWidth);var n=e.querySelector(\".sapUiTableRowHdrScr\");n&&(t.tableRowHdrScrWidth=n.clientWidth);var s=e.querySelector(\".sapUiTableCtrlScr:not(.sapUiTableCHA)\");s&&(t.tableCtrlScrWidth=s.clientWidth);var r=this._getScrollExtension().getHorizontalScrollbar();r&&(t.tableHSbScrollLeft=r.scrollLeft);var a=e.querySelector(\".sapUiTableCtrlScrFixed:not(.sapUiTableCHA) > .sapUiTableCtrlFixed\");a&&(t.tableCtrlFixedWidth=a.clientWidth);var l=this.getProperty(\"fixedColumnCount\"),u=0;if(l)for(var h=e.querySelectorAll(\".sapUiTableCtrlFirstCol:not(.sapUiTableCHTHR) > th\"),d=0;d<h.length;d++){var p=parseInt(h[d].getAttribute(\"data-sap-ui-headcolindex\"),10);!isNaN(p)&&p<l&&(u+=h[d].getBoundingClientRect().width)}if(u>0){var c=t.tableRowHdrScrWidth,w=this.getDomRef(\"vsb\");if(w&&(c+=w.offsetWidth),g.hasRowActions(this)){var R=this.getDomRef(\"sapUiTableRowActionScr\");R&&(c+=R.offsetWidth)}var f=t.tableCtrlScrollWidth===t.tableCtrlScrWidth;f||(c+=g.Column.getMinColumnWidth());var m=t.tableCtrlFixedWidth+c<=t.tableCntWidth,b=!1;f&&m||(b=t.tableCntWidth-c<u),this._bIgnoreFixedColumnCount!==b&&(this._bIgnoreFixedColumnCount=b,this.invalidate())}return t},A.prototype.getAggregationDomRef=function(t){if(\"rows\"==t)return this.getDomRef(\"tableCCnt\")},A.prototype._updateRowHeights=function(t,e){function i(e,i){var o=t[i];o&&(e.style.height=o+\"px\")}var o=this.getDomRef();if(o&&(!e||!this.getColumnHeaderHeight())){var n=e?\".sapUiTableColHdrTr\":\".sapUiTableTr\",s=e?[]:o.querySelectorAll(\".sapUiTableRowHdr\"),r=e?[]:o.querySelectorAll(\".sapUiTableRowAction\"),a=o.querySelectorAll(\".sapUiTableCtrlFixed > tbody > tr\"+n),l=o.querySelectorAll(\".sapUiTableCtrlScroll > tbody > tr\"+n),u=[];u.forEach.call(s,i),u.forEach.call(r,i),u.forEach.call(a,i),u.forEach.call(l,i)}},A.prototype.onBeforeRendering=function(t){if(!t||!t.isMarked(\"renderRows\")){this._mTimeouts.bindingTimer&&this._updateBindingContexts(),this._cleanUpTimers(),this._detachEvents();var e=this.getVisibleRowCountMode(),i=this.getRows();e==x.Interactive||e==x.Fixed||e==x.Auto&&this._iTableRowContentHeight&&0==i.length?(this.getBinding(\"rows\"),this._updateRows(this._calculateRowsToDisplay(),g.RowsUpdateReason.Render)):this._bRowAggregationInvalid&&i.length>0&&this._updateRows(i.length,g.RowsUpdateReason.Render),this._aTableHeaders=[]}},A.prototype.onAfterRendering=function(t){var e=t&&t.isMarked(\"renderRows\");this._bInvalid=!1,this._bOnAfterRendering=!0;var i=this.$();this._attachEvents(),this._initRowDomRefs();for(var o=this.getColumns(),n=0,s=o.length;n<s;n++)o[n].getVisible()&&o[n]._restoreIcons();this._bAllowColumnHeaderTextSelection||e||this._disableTextSelection(i.find(\".sapUiTableColHdrCnt\")),this._bOnAfterRendering=!1,this._getKeyboardExtension().invalidateItemNavigation(),this._updateTableContent(),this._bFirstRendering&&this.getVisibleRowCountMode()==x.Auto?(this._bFirstRendering=!1,Promise.resolve().then(this._updateTableSizes.bind(this,g.RowsUpdateReason.Render,!0))):this._updateTableSizes(g.RowsUpdateReason.Render,null,e,e&&g.isVariableRowHeightEnabled(this)),e||(this._aTableHeaders=this.$().find(\".sapUiTableColHdrCnt th\"),this.getBinding(\"rows\")&&this._fireRowsUpdated(g.RowsUpdateReason.Render))},A.prototype.invalidate=function(){if(!this._ignoreInvalidateOfChildControls){this._bInvalid=!0;var t=i.prototype.invalidate.call(this);g.Column.invalidateColumnUtils(this)}return t},A.prototype._initRowDomRefs=function(){for(var t=this.getRows(),e=0;e<t.length;e++)t[e].initDomRefs()},A.prototype._updateTableSizes=function(t,e,i,o){function n(){g.registerResizeHandler(r,\"\",r._onTableResize.bind(r),!0)}var s=this.getDomRef(),r=this;if(!this._bInvalid&&s){if(!s.offsetWidth)return g.deregisterResizeHandler(this,\"\"),void n();this._resetRowHeights(),this._resetColumnHeaderHeights(),this._aRowHeights=this._collectRowHeights(!1);var a=this._collectRowHeights(!0);g.isVariableRowHeightEnabled(this)&&this._getScrollExtension().updateInnerVerticalScrollPosition();var l=null;if(i||this.getVisibleRowCountMode()!=x.Auto||(l=this._determineAvailableSpace(),!this._handleRowCountModeAuto(l,t)||e)){if(g.deregisterResizeHandler(this,\"\"),function(t){function e(t,e){return t<=e?Math.max(t,e-5,s)+\"px\":-1}function i(i){var o,l,u,h=Math.max(i._minWidth||0,s,i.getMinWidth()),d=i.getWidth();if(g.isVariableWidth(d)&&!g.isFixedColumn(t,i.getIndex())&&(o=n.querySelectorAll('th[data-sap-ui-colid=\"'+i.getId()+'\"]'),l=o[a?0:1],null!==(u=l?l.offsetWidth:null))){if(u<=h)return{headers:o,newWidth:e(u,h)};if(l&&l.style.width!=d)return r.push({col:i,header:l,minWidth:h,headers:o}),{headers:o,newWidth:d};r.push({col:i,header:l,minWidth:h,headers:o})}return null}function o(t){t&&Array.prototype.forEach.call(t.headers,function(e){e.style.width=t.newWidth})}var n=t.getDomRef(),s=g.Column.getMinColumnWidth(),r=[],a=t.getColumnHeaderVisible();if(t._getVisibleColumns().map(i).forEach(o),r.length)for(var l,u=0;u<r.length;u++)l=r[u].header&&r[u].header.offsetWidth,r[u].newWidth=e(l,r[u].minWidth),parseInt(r[u].newWidth,10)>=0&&o(r[u])}(this),this._updateRowHeights(this._aRowHeights,!1),this._updateRowHeights(a,!0),i&&!o||this._setRowContentHeight(l),this.getVisibleRowCountMode()==x.Auto){this._calculateRowsToDisplay(null!=l?l:this._determineAvailableSpace())==this._determineMinAutoRowCount()?this.$().height(\"auto\"):this.$().height(\"0px\")}var u=this._collectTableSizes();if(0==u.tableCntHeight&&0==u.tableCntWidth)return void g.registerResizeHandler(this,\"\",this._onTableResize.bind(this),!0);var h=this._getScrollExtension();h.updateHorizontalScrollbar(u),h.updateVerticalScrollbarPosition(),h.updateVerticalScrollbarVisibility();var d=this.$();if(g.hasRowActions(this)){var p=d.hasClass(\"sapUiTableRActFlexible\"),c=this.getDomRef(\"dummycolhdr\"),w=c?c.clientWidth:0;if(!p&&w>0){var R=u.tableCtrlScrWidth+u.tableRowHdrScrWidth+u.tableCtrlFixedWidth-w,f={width:\"auto\"};f[this._bRtlMode?\"right\":\"left\"]=R,this.$(\"sapUiTableRowActionScr\").css(f),this.$(\"rowacthdr\").css(f),d.toggleClass(\"sapUiTableRActFlexible\",!0)}else p&&w<=0&&(this.$(\"sapUiTableRowActionScr\").removeAttr(\"style\"),this.$(\"rowacthdr\").removeAttr(\"style\"),d.toggleClass(\"sapUiTableRActFlexible\",!1))}d.find(\".sapUiTableNoOpacity\").addBack().removeClass(\"sapUiTableNoOpacity\"),d.closest(\".sapUiLoSplitter\").length?n():Promise.resolve().then(n)}}},A.prototype.setShowOverlay=function(t){if(t=!!t,this.setProperty(\"showOverlay\",t,!0),this.getDomRef()){var e=document.activeElement;this.$().toggleClass(\"sapUiTableOverlay\",t),this._getAccExtension().updateAriaStateForOverlayAndNoData(),this._getKeyboardExtension().updateNoDataAndOverlayFocus(e)}return this},A.prototype._updateFixedBottomRows=function(){var e=this.getFixedBottomRowCount(),i=this.getDomRef();if(i&&e>0){t(i).find(\".sapUiTableFixedPreBottomRow\").removeClass(\"sapUiTableFixedPreBottomRow\");t(i).find(\".sapUiTableFixedFirstBottomRow\").removeClass(\"sapUiTableFixedFirstBottomRow\");var o,n=g.getFirstFixedButtomRowIndex(this),s=this.getRows();n>=0&&n<s.length&&(o=s[n].getDomRefs(!0),o.row.addClass(\"sapUiTableFixedFirstBottomRow\",!0)),n>=1&&n<s.length&&(o=s[n-1].getDomRefs(!0),o.row.addClass(\"sapUiTableFixedPreBottomRow\",!0))}},A.prototype.getFocusInfo=function(){var t=this.$().find(\":focus\").attr(\"id\");return t?{customId:t}:o.prototype.getFocusInfo.apply(this,arguments)},A.prototype.applyFocusInfo=function(t){return t&&t.customId?this.$().find(\"#\"+t.customId).focus():o.prototype.getFocusInfo.apply(this,arguments),this},A.prototype.setTitle=function(t){var e=t;return(\"string\"==typeof t||t instanceof String)&&(e=p.TableHelper.createTextView({text:t,width:\"100%\"}),e.addStyleClass(\"sapUiTableHdrTitle\")),this.setAggregation(\"title\",e),this},A.prototype.setFooter=function(t){var e=t;return(\"string\"==typeof t||t instanceof String)&&(e=p.TableHelper.createTextView({text:t,width:\"100%\"})),this.setAggregation(\"footer\",e),this},A.prototype.setSelectionMode=function(t){return this.clearSelection(),t===v.Single?this._oSelection.setSelectionMode(a.SINGLE_SELECTION):this._oSelection.setSelectionMode(a.MULTI_SELECTION),t=g.sanitizeSelectionMode(this,t),this.setProperty(\"selectionMode\",t),this},A.prototype.setFirstVisibleRow=function(e,i,o){if(parseInt(e,10)<0&&(t.sap.log.error(\"The index of the first visible row must be greater than or equal to 0. The value has been set to 0.\",this),e=0),this._getTotalRowCount()>0){var n=this._getMaxFirstVisibleRowIndex();n<e&&(t.sap.log.warning(\"The index of the first visible row must be lesser or equal than the scrollable row count minus the visible row count. The value has been set to \"+n+\".\",this),e=n)}var s=this.getFirstVisibleRow()!=e,r=this._getScrollExtension();if(s){var a=this._getFirstRenderedRowIndex();this.setProperty(\"firstVisibleRow\",e,!0);var l=this._getFirstRenderedRowIndex()!==a;if(this.getBinding(\"rows\")){if(l){var u=!0===i?g.RowsUpdateReason.VerticalScroll:g.RowsUpdateReason.FirstVisibleRowChange;this.updateRows(u)}i||r.updateVerticalScrollPosition()}o||this.fireFirstVisibleRowChanged({firstVisibleRow:e})}else i||r.updateVerticalScrollPosition();return this},A.getMetadata().getAggregation(\"rows\")._doesNotRequireFactory=!0,A.prototype.bindAggregation=function(t){return\"rows\"===t?this.bindRows.apply(this,[].slice.call(arguments,1)):i.prototype.bindAggregation.apply(this,arguments)},A.prototype.bindRows=function(t){return this.getEnableBusyIndicator()&&this.setBusy(!1),this._iPendingRequests=0,this._bPendingRequest=!1,i.prototype.bindAggregation.call(this,\"rows\",A._getSanitizedBindingInfo(arguments))},A.prototype._bindAggregation=function(e,i){\"rows\"===e&&(A._addBindingListener(i,\"change\",this._onBindingChange.bind(this)),A._addBindingListener(i,\"dataRequested\",this._onBindingDataRequested.bind(this)),A._addBindingListener(i,\"dataReceived\",this._onBindingDataReceived.bind(this)),this._bContextsRequested=!1),o.prototype._bindAggregation.call(this,e,i);var n=this.getBinding(\"rows\");if(\"rows\"===e&&null!=n){var s=n.getModel();null!=s&&s.getDefaultBindingMode()===u.OneTime&&t.sap.log.error('The binding mode of the model is set to \"OneTime\". This binding mode is not supported for the \"rows\" aggregation! Scrolling can not be performed.',this)}this._initSelectionModel(a.MULTI_SELECTION)},A._getSanitizedBindingInfo=function(e){var i;if(null==e||null==e[0])i=null;else if(\"string\"==typeof e[0]){var o=e[0],n=e[1],s=e[2],a=e[3];(n instanceof l||t.isArray(s)&&s[0]instanceof r)&&(a=s,s=n,n=void 0),i={path:o,sorter:s,filters:a,template:n}}else i=e[0];return i},A._addBindingListener=function(t,e,i){if(null==t.events&&(t.events={}),null==t.events[e])t.events[e]=i;else{var o=t.events[e];t.events[e]=function(){i.apply(this,arguments),o.apply(this,arguments)}}},A.prototype._initSelectionModel=function(t){return this._oSelection&&this._oSelection.detachSelectionChanged(this._onSelectionChanged,this),this._oSelection=new a(t),this._oSelection.attachSelectionChanged(this._onSelectionChanged,this),this},A.prototype._onBindingChange=function(t){var e=\"object\"==typeof t?t.getParameter(\"reason\"):t;\"sort\"!==e&&\"filter\"!==e||(this.clearSelection(),this.setFirstVisibleRow(0))},A.prototype.unbindAggregation=function(t,e){var i=this.getBinding(\"rows\");\"rows\"===t&&this.isBound(\"rows\")&&(e=!0);var n=o.prototype.unbindAggregation.apply(this,[t,e]);return\"rows\"===t&&i&&(this._restoreAppDefaultsColumnHeaderSortFilter(),this._invalidateColumnMenus(),this._updateTotalRowCount(!0),this.updateRows(g.RowsUpdateReason.Unbind)),n},A.prototype.setVisibleRowCount=function(e){if(null!=e&&!isFinite(e))return this;if(this.getVisibleRowCountMode()==x.Auto)return t.sap.log.error(\"VisibleRowCount will be ignored since VisibleRowCountMode is set to Auto\",this),this;var i=this.getFixedRowCount()+this.getFixedBottomRowCount();return e<=i&&i>0?(t.sap.log.error(\"Table: \"+this.getId()+\" visibleRowCount('\"+e+\"') must be bigger than number of fixed rows('\"+(this.getFixedRowCount()+this.getFixedBottomRowCount())+\"')\",this),this):(e=this.validateProperty(\"visibleRowCount\",e),null!=this.getBinding(\"rows\")&&this._getTotalRowCount()<=e&&this.setProperty(\"firstVisibleRow\",0),this.setProperty(\"visibleRowCount\",e),this._setRowContentHeight(e*this._getDefaultRowHeight()),this)},A.prototype.setMinAutoRowCount=function(e){parseInt(e,10)<1&&(t.sap.log.error(\"The minAutoRowCount property must be greater than 0. The value has been set to 1.\",this),e=1),this.setProperty(\"minAutoRowCount\",e)},A.prototype.setRowHeight=function(t){return this.setProperty(\"rowHeight\",t),this._iTableRowContentHeight=void 0,this},A.prototype.setTooltip=function(e){return t.sap.log.warning(\"The aggregation tooltip is not supported for sap.ui.table.Table\"),this.setAggregation(\"tooltip\",e,!0)},A.prototype.setNavigationMode=function(){this.setProperty(\"navigationMode\",y.Scrollbar,!0),t.sap.log.error(\"The navigationMode property is deprecated and must not be used anymore. Your setting was defaulted to 'Scrollbar'\",this)},A.prototype._getFixedBottomRowContexts=function(t,e){var i=this.getBinding(\"rows\"),o=[];if(!i)return o;t=t||this.getFixedBottomRowCount(),e=e||this._getTotalRowCount();var n=this.getVisibleRowCount();return t>0&&n-t<e&&(o=this._getContexts(e-t,t,1)),o},A.prototype._getFixedRowContexts=function(t){return t=t||this.getFixedRowCount(),t>0?this._getContexts(0,t):[]},A.prototype._getContexts=function(t,e,i){var o=this.getBinding(\"rows\");return o?o.getContexts(t,e,i):[]},A.prototype._computeRequestLength=function(t){if(this.getVisibleRowCountMode()===x.Auto&&!this._bContextsRequested){var i=Math.ceil(e.resize.height/g.DEFAULT_ROW_HEIGHT.sapUiSizeCondensed);return Math.max(t,i)}return t},A.prototype._getRowContexts=function(t,e,i){var o=this.getBinding(\"rows\"),n=null==t?this.getRows().length:t;if(!o||n<=0)return[];e=!0===e,i=!0===i;var s,r,a=this._getFirstRenderedRowIndex(),l=this.getFixedRowCount(),u=this.getFixedBottomRowCount(),h=0,d=[],p=n-u,g=0,c=p,w=this.getThreshold();w=w?Math.max(n,w):0;var R=a,f=function(t,e,i){for(var o=0;o<e.length;o++)t[i+o]=e[o]};l>0&&a>0&&(R=a+l,p-=l,g=l,r=this._getFixedRowContexts(l),h+=r.length,d=d.concat(r)),r=this._getContexts(R,this._computeRequestLength(p),w);var m=this._updateTotalRowCount(!e);this._bContextsRequested=!0,s=r.length<Math.min(p,m-u),h+=r.length,f(d,r,g),c=Math.min(c,Math.max(m-u,0)),u>0&&(r=this._getFixedBottomRowContexts(u,m),h+=r.length,f(d,r,c));var b=this._getMaxFirstRenderedRowIndex();return s&&m>0&&b<a&&!i&&(a=b,this.setProperty(\"firstVisibleRow\",a,!0),d=this._getRowContexts(n,e,!0)),d},A.prototype._updateTotalRowCount=function(t){null===this._iBindingLength&&(this._iBindingLength=0);var e=this.getBinding(\"rows\"),i=this._getTotalRowCount(),o=null==e?0:e.getLength();if(i!==o&&(this._iBindingLength=o,!1!==t)){var n=this._getScrollExtension(),s=g.isInstanceOf(e,\"sap/ui/model/ClientListBinding\")||g.isInstanceOf(e,\"sap/ui/model/ClientTreeBinding\");this._updateFixedBottomRows(),n.updateVerticalScrollbarVisibility(),n.updateVerticalScrollHeight(),(null==e||s)&&this._updateNoData()}return o},A.prototype.refreshRows=function(e){var i=this.getBinding(\"rows\");if(!i)return void t.sap.log.error(\"RefreshRows must not be called without a binding\",this);var o=this,n=\"object\"==typeof e?e.getParameter(\"reason\"):e,r=this.getVisibleRowCountMode();(this.bOutput&&r===x.Auto||r!==x.Auto)&&(this.bOutput&&i.attachEventOnce(\"dataRequested\",function(){o._mTimeouts.refreshRowsAdjustRows&&window.clearTimeout(o._mTimeouts.refreshRowsAdjustRows),o._mTimeouts.refreshRowsAdjustRows=window.setTimeout(function(){o._updateRows(o._calculateRowsToDisplay(),n,!1)},0)}),n!==s.Filter&&n!==s.Sort||this.setFirstVisibleRow(0),this._updateBindingContexts(this._calculateRowsToDisplay(),!0))},A.prototype.updateRows=function(t){if(!this._bExitCalled){var e=this.getVisibleRowCountMode();if((this.getRows().length<=0||this._bRowAggregationInvalid)&&(e==x.Auto&&this.bOutput||e!=x.Auto)&&this._iTableRowContentHeight&&this._updateRows(this._calculateRowsToDisplay(),t),!this.bIsDestroyed){var i=t===s.Change||!this._mTimeouts.bindingTimer&&Date.now()-this._lastCalledUpdateRows>this._iBindingTimerDelay||t===g.RowsUpdateReason.Unbind?0:this._iBindingTimerDelay,o=this;0===i&&t?Promise.resolve().then(function(){o._performUpdateRows(t)}):this._mTimeouts.bindingTimer=this._mTimeouts.bindingTimer||window.setTimeout(function(){o._performUpdateRows(t)},i)}}},A.prototype.insertRow=function(){t.sap.log.error('The control manages the rows aggregation. The method \"insertRow\" cannot be used programmatically!',this)},A.prototype.addRow=function(){t.sap.log.error('The control manages the rows aggregation. The method \"addRow\" cannot be used programmatically!',this)},A.prototype.removeRow=function(){t.sap.log.error('The control manages the rows aggregation. The method \"removeRow\" cannot be used programmatically!',this)},A.prototype.removeAllRows=function(){t.sap.log.error('The control manages the rows aggregation. The method \"removeAllRows\" cannot be used programmatically!',this)},A.prototype.destroyRows=function(){t.sap.log.error('The control manages the rows aggregation. The method \"destroyRows\" cannot be used programmatically!',this)},A.prototype.autoResizeColumn=function(t){this._getPointerExtension().doAutoResizeColumn(t)},A.prototype._attachEvents=function(){var i=this.$();sap.ui.getCore().getConfiguration().getAnimation()&&t(document.body).on(\"webkitTransitionEnd transitionend\",function(e){t(e.target).has(i).length>0&&this._updateTableSizes(g.RowsUpdateReason.Animation)}.bind(this)),e.resize.attachHandler(this._onWindowResize,this),c.attachEvents(this)},A.prototype._detachEvents=function(){t(document.body).off(\"webkitTransitionEnd transitionend\"),g.deregisterResizeHandler(this),e.resize.detachHandler(this._onWindowResize,this),c.detachEvents(this)},A.prototype._cleanUpTimers=function(){var t;for(t in this._mTimeouts)this._mTimeouts[t]&&(window.clearTimeout(this._mTimeouts[t]),delete this._mTimeouts[t]);for(t in this._mAnimationFrames)this._mAnimationFrames[t]&&(window.cancelAnimationFrame(this._mAnimationFrames[t]),delete this._mAnimationFrames[t])},A.prototype._updateBindingContexts=function(t,e){var i,o=this.getBinding(\"rows\");if(e=!0===e,null!=o&&(i=this._getRowContexts(t,e)),!e){this._resetRowHeights();for(var n=this.getRows(),s=this.mBindingInfos.rows,r=s&&s.model,a=n.length-1;a>=0;a--){var l=i?i[a]:void 0,u=n[a];u&&u.setRowBindingContext(l,r,o)}}},A.prototype._updateNoData=function(){if(this.getDomRef()){var t=document.activeElement;this.$().toggleClass(\"sapUiTableEmpty\",g.isNoDataVisible(this)),this._getAccExtension().updateAriaStateForOverlayAndNoData(),this._getKeyboardExtension().updateNoDataAndOverlayFocus(t)}},A.prototype.removeColumn=function(e,i){var o=this.removeAggregation(\"columns\",e,i);\"number\"==typeof e&&e>-1&&(e=this.getColumns()[e]);var n=t.inArray(e,this._aSortedColumns);return!this._bReorderInProcess&&n>=0&&this._aSortedColumns.splice(n,1),this.invalidateRowsAggregation(),o},A.prototype.removeAllColumns=function(){var t=this.removeAllAggregation(\"columns\");return this._aSortedColumns=[],this.invalidateRowsAggregation(),t},A.prototype.destroyColumns=function(){var t=this.destroyAggregation(\"columns\");return this._aSortedColumns=[],this.invalidateRowsAggregation(),t},A.prototype.addColumn=function(t,e){return this.addAggregation(\"columns\",t,e),this.invalidateRowsAggregation(),this},A.prototype.insertColumn=function(t,e,i){return this.insertAggregation(\"columns\",t,e,i),this.invalidateRowsAggregation(),this},A.prototype._getTotalRowCount=function(t){if(null===this._iBindingLength||!0===t){var e=this.getBinding(\"rows\");return null==e?0:e.getLength()}return this._iBindingLength},A.prototype._getSelectableRowCount=function(){return this._getTotalRowCount()},A.prototype._getMaxFirstVisibleRowIndex=function(){var t;return t=g.isVariableRowHeightEnabled(this)?this._getTotalRowCount(!0)-1:this._getTotalRowCount(!0)-this.getVisibleRowCount(),Math.max(0,t)},A.prototype._getMaxFirstRenderedRowIndex=function(){var t;return t=g.isVariableRowHeightEnabled(this)?this._getTotalRowCount(!0)-this.getVisibleRowCount()-1:this._getTotalRowCount(!0)-this.getVisibleRowCount(),Math.max(0,t)},A.prototype._getFirstRenderedRowIndex=function(){var t=this.getFirstVisibleRow();return g.isVariableRowHeightEnabled(this)&&t>this._getMaxFirstRenderedRowIndex()?this._getMaxFirstRenderedRowIndex():t},A.prototype._getVisibleColumns=function(){for(var t=[],e=this.getColumns(),i=0,o=e.length;i<o;i++)e[i].shouldRender()&&t.push(e[i]);return t},A.prototype._getColumnsWidth=function(t,e){var i=this.getColumns(),o=0;0===t||t||(t=0),0===e||e||(e=i.length);for(var n=t,s=e;n<s;n++)i[n]&&i[n].shouldRender()&&(o+=this._CSSSizeToPixel(i[n].getWidth()));return o},A.prototype._CSSSizeToPixel=function(e,i){var o=g.Column.getMinColumnWidth();return e&&(t.sap.endsWith(e,\"px\")?o=parseInt(e,10):(t.sap.endsWith(e,\"em\")||t.sap.endsWith(e,\"rem\"))&&(o=Math.ceil(parseFloat(e)*this._getBaseFontSize()))),i?o+\"px\":parseInt(o,10)},A.prototype._getBaseFontSize=function(){return this._iBaseFontSize},A.prototype._onTableResize=function(){!this._bInvalid&&this.getDomRef()&&this._updateTableSizes(g.RowsUpdateReason.Resize)},\nA.prototype._onWindowResize=function(){!this._bInvalid&&this.getDomRef()&&e.browser.chrome&&window.devicePixelRatio!==this._nDevicePixelRatio&&(this._nDevicePixelRatio=window.devicePixelRatio,this._updateTableSizes(g.RowsUpdateReason.Zoom))},A.prototype._handleRowCountModeAuto=function(t,e){t=t||this._determineAvailableSpace();var i=this.getBinding(\"rows\"),o=this._calculateRowsToDisplay(t);if(i&&this.getRows().length>0)return this._updateRows(o,e);var n=!this._mTimeouts.handleRowCountModeAutoAdjustRows,s=this;return t&&this._setRowContentHeight(t),this._mTimeouts.handleRowCountModeAutoAdjustRows=this._mTimeouts.handleRowCountModeAutoAdjustRows||window.setTimeout(function(){s._updateRows(o,e)||s._updateTableSizes(e,!1,!0),delete s._mTimeouts.handleRowCountModeAutoAdjustRows},0),n},A.prototype._disableTextSelection=function(e){t(e||document.body).attr(\"unselectable\",\"on\").css({\"-moz-user-select\":\"none\",\"-webkit-user-select\":\"none\",\"user-select\":\"none\"}).bind(\"selectstart\",function(t){return t.preventDefault(),!1})},A.prototype._enableTextSelection=function(e){t(e||document.body).attr(\"unselectable\",\"off\").css({\"-moz-user-select\":\"\",\"-webkit-user-select\":\"\",\"user-select\":\"\"}).unbind(\"selectstart\")},A.prototype._clearTextSelection=function(){if(window.getSelection)window.getSelection().empty?window.getSelection().empty():window.getSelection().removeAllRanges&&window.getSelection().removeAllRanges();else if(document.selection&&document.selection.empty)try{document.selection.empty()}catch(t){}},A.prototype._findAndfireCellEvent=function(e,i,o){var n=t(i.target),s=n.closest(\"td.sapUiTableTd\"),r=s.attr(\"id\"),a=/.*-row(\\d*)-col(\\d*)/i.exec(r),l=!1;if(a){var u,h=a[1],d=a[2],p=this.getRows()[h],g=p&&p.getCells()[d],c=p&&p.getIndex(),w=g.data(\"sap-ui-colid\");this.getBindingInfo(\"rows\")&&(u=p.getBindingContext(this.getBindingInfo(\"rows\").model));var R={rowIndex:c,columnIndex:d,columnId:w,cellControl:g,rowBindingContext:u,cellDomRef:s.get(0)};l=!e.call(this,R),l||\"function\"!=typeof o||(R.cellDomRef=s[0],l=o.call(this,R))}return l},A.prototype.getFocusDomRef=function(){this._getKeyboardExtension().initItemNavigation();var t=g.getFocusedItemInfo(this);return null!==t?t.domRef||i.prototype.getFocusDomRef.apply(this,arguments):null},A.prototype._isRowSelectable=function(t){return t>=0&&t<this._getTotalRowCount()},A.prototype.pushSortedColumn=function(t,e){e||(this._aSortedColumns=[]),this._aSortedColumns.push(t)},A.prototype.getSortedColumns=function(){return this._aSortedColumns.slice()},A.prototype.sort=function(e,i,o){if(!e){for(var n=0;n<this._aSortedColumns.length;n++)this._aSortedColumns[n].setSorted(!1);var s=this.getBinding(\"rows\");s&&s.sort(),this._aSortedColumns=[]}t.inArray(e,this.getColumns())>=0&&e.sort(i===T.Descending,o)},A.prototype.filter=function(e,i){t.inArray(e,this.getColumns())>=0&&e.filter(i)},A.prototype._updateSelection=function(){if(this.getSelectionMode()!==v.None){for(var t=this._getAccExtension().getAriaTextsForSelectionMode(!0),e=g.isRowSelectionAllowed(this),i=this.getRows(),o=0;o<i.length;o++)i[o]._updateSelection(this,t,e);if(this.setProperty(\"selectedIndex\",this.getSelectedIndex(),!0),g.hasSelectAll(this)){var n=this.$(\"selall\"),s=g.areAllRowsSelected(this);if(n.toggleClass(\"sapUiTableSelAll\",!s),this._getAccExtension().setSelectAllState(s),this._getShowStandardTooltips()){var r=s?\"TBL_DESELECT_ALL\":\"TBL_SELECT_ALL\";n.attr(\"title\",this._oResBundle.getText(r))}}}},A.prototype._getShowStandardTooltips=function(){return!this._bHideStandardTooltips},A.prototype._onSelectionChanged=function(t){var e=t.getParameter(\"rowIndices\"),i=t.getParameter(\"selectAll\"),o=void 0!==this._iSourceRowIndex?this._iSourceRowIndex:this.getSelectedIndex();this._updateSelection(),this.fireRowSelectionChange({rowIndex:o,rowContext:this.getContextByIndex(o),rowIndices:e,selectAll:i,userInteraction:void 0!==this._iSourceRowIndex})},A.prototype.getContextByIndex=function(t){var e=this.getBinding(\"rows\");return t>=0&&e?e.getContexts(t,1)[0]:null},A.prototype.getSelectedIndex=function(){return this._oSelection.getLeadSelectedIndex()},A.prototype.setSelectedIndex=function(t){return-1===t?this.clearSelection():this._oSelection.setSelectionInterval(t,t),this},A.prototype.clearSelection=function(){return this._oSelection.clearSelection(),this},A.prototype.selectAll=function(){return g.hasSelectAll(this)?(this.getBinding(\"rows\")&&this._oSelection.selectAll(this._getTotalRowCount()-1),this):this},A.prototype.getSelectedIndices=function(){return this._oSelection.getSelectedIndices()},A.prototype.addSelectionInterval=function(t,e){return this.getSelectionMode()===p.SelectionMode.None?this:(this._oSelection.addSelectionInterval(t,e),this)},A.prototype.setSelectionInterval=function(t,e){return this.getSelectionMode()===p.SelectionMode.None?this:(this._oSelection.setSelectionInterval(t,e),this)},A.prototype.removeSelectionInterval=function(t,e){return this._oSelection.removeSelectionInterval(t,e),this},A.prototype.isIndexSelected=function(t){return this._oSelection.isSelectedIndex(t)},A.prototype.setGroupBy=function(e){var i=e,o=sap.ui.getCore().byId(this.getGroupBy());\"string\"==typeof i&&(i=sap.ui.getCore().byId(i));var n=!1;if(null!=i&&i instanceof h&&i!==o){if(-1===t.inArray(i,this.getColumns()))throw new Error(\"Column has to be part of the columns aggregation!\");var s=this.fireGroup({column:i,groupedColumns:[i.getId()],type:_.group});null!=o&&(o.setGrouped(!1),n=!0),s&&this.getEnableGrouping()&&i.setGrouped(!0)}return(null==i||n)&&(null!=o&&o.setGrouped(!1),g.Grouping.resetExperimentalGrouping(this)),this.setAssociation(\"groupBy\",i)},A.prototype.getBinding=function(t){return g.Grouping.setupExperimentalGrouping(this),o.prototype.getBinding.call(this,[t||\"rows\"])},A.prototype.setEnableGrouping=function(t){var e=sap.ui.getCore().byId(this.getGroupBy());return this.setProperty(\"enableGrouping\",t),null!=e&&e.setGrouped(t),g.Grouping.resetExperimentalGrouping(this),this._invalidateColumnMenus(),this},A.prototype.setEnableCustomFilter=function(t){return this.setProperty(\"enableCustomFilter\",t),this._invalidateColumnMenus(),this},A.prototype.setEnableColumnFreeze=function(t){return this.setProperty(\"enableColumnFreeze\",t),this._invalidateColumnMenus(),this},A.prototype.setShowColumnVisibilityMenu=function(t){return this.setProperty(\"showColumnVisibilityMenu\",t),this._invalidateColumnMenus(),this},A.prototype.getFixedColumnCount=function(){return this._bIgnoreFixedColumnCount?0:this.getProperty(\"fixedColumnCount\")},A.prototype.setFixedColumnCount=function(t,e){var i,o,n=this.getColumns();for(o=t-1;o>=0;o--)if((i=n[o])&&i.getVisible()){t=Math.max(t,i.getIndex()+g.Column.getHeaderSpan(i));break}var s=this.$().find(\".sapUiTableCtrlFirstCol > th\");for(o=t-1;o>=0;o--)(i=n[o])&&g.isVariableWidth(i.getWidth())&&(i._iFixWidth=s.filter(\"[data-sap-ui-headcolindex='\"+i.getIndex()+\"']\").width());return this.setProperty(\"fixedColumnCount\",t,e),this._collectTableSizes(),this._invalidateColumnMenus(),this},A.prototype.setFixedRowCount=function(e){return parseInt(e,10)>=0?(e+this.getFixedBottomRowCount()<this.getVisibleRowCount()?(this.setProperty(\"fixedRowCount\",e),this._updateBindingContexts()):t.sap.log.error(\"Table '\"+this.getId()+\"' fixed rows('\"+(e+this.getFixedBottomRowCount())+\"') must be smaller than numberOfVisibleRows('\"+this.getVisibleRowCount()+\"')\",this),this):(t.sap.log.error(\"Number of fixed rows must be greater or equal 0\",this),this)},A.prototype.setFixedBottomRowCount=function(e){return parseInt(e,10)>=0?(e+this.getFixedRowCount()<this.getVisibleRowCount()?(this.setProperty(\"fixedBottomRowCount\",e),this._updateBindingContexts()):t.sap.log.error(\"Table '\"+this.getId()+\"' fixed rows('\"+(e+this.getFixedRowCount())+\"') must be smaller than numberOfVisibleRows('\"+this.getVisibleRowCount()+\"')\",this),this):(t.sap.log.error(\"Number of fixed bottom rows must be greater or equal 0\",this),this)},A.prototype.setThreshold=function(t){this.setProperty(\"threshold\",t,!0)},A.prototype._invalidateColumnMenus=function(t){for(var e=this.getColumns(),i=0,o=e.length;i<o;i++)e[i].invalidateMenu(t)},A.prototype._isTouchEvent=function(t){return null!=t&&null!=t.originalEvent&&null!=t.originalEvent.touches},A.prototype._getRowClone=function(t){for(var e=new d(this.getId()+\"-rows-row\"+t),i=this.getColumns(),o=0,n=i.length;o<n;o++)if(i[o].getVisible()){var s=i[o].getTemplateClone(o);s&&e.addCell(s)}if(g.hasRowActions(this)){var r=this.getRowActionTemplate().clone();r._setFixedLayout(!0),r._setCount(this.getRowActionCount()),r._setIconLabel(this.getId()+\"-rowacthdr\"),e.setAggregation(\"_rowAction\",r,!0)}var a=this.getRowSettingsTemplate();if(a){var l=a.clone();e.setAggregation(\"_settings\",l,!0)}return e},A.prototype.invalidateRowsAggregation=function(){this._bRowAggregationInvalid=!0},A.prototype._updateRows=function(t,e,i){if(isNaN(t))return!1;null==i&&(i=!0),g.isVariableRowHeightEnabled(this)&&(t+=1);var o,n=this.getRows();if(this._bRowAggregationInvalid&&n.length>0&&(this.destroyAggregation(\"rows\",!0),n=[]),t==n.length)return!1;for(o=n.length-1;o>=t;o--)this.removeAggregation(\"rows\",o,!0).destroy();g.isVariableRowHeightEnabled(this)?this.setProperty(\"visibleRowCount\",t-1,!0):this.setProperty(\"visibleRowCount\",t,!0),this._ignoreInvalidateOfChildControls=!0;var s,r,a,l=this.getBinding(\"rows\");if(i)for(r=this.getBindingInfo(\"rows\"),a=r&&r.model,s=this._getRowContexts(t),o=0;o<n.length;o++)n[o].setRowBindingContext(s[o],a,l);if(n.length<t)for(o=n.length;o<t;o++){var u=this._getRowClone(o);i&&u.setRowBindingContext(s[o],a,l),this.addAggregation(\"rows\",u,!0),this._bRowAggregationInvalid=!1,i&&u._updateTableCells(s[o])}this._ignoreInvalidateOfChildControls=!1;var h=i&&s.length>0;return this._renderRows(e,h)},A.prototype._renderRows=function(e,i){var o=!1;if(i=!0===i,!this._bInvalid){var n=this.getDomRef(\"tableCCnt\");if(0===this.getRows().length||!n)return!1;if(this._detachEvents(),this.getVisibleRowCountMode()===x.Auto){var s=this.getDomRef();s&&(s.style.height=\"0px\")}var r=t.Event(\"BeforeRendering\");r.setMarked(\"renderRows\"),r.srcControl=this,this._handleEvent(r);var a=(new sap.ui.getCore).createRenderManager();this.getRenderer().renderTableCCnt(a,this),a.flush(n,!1,!1),a.destroy(),r=t.Event(\"AfterRendering\"),r.setMarked(\"renderRows\"),r.srcControl=this,this._handleEvent(r),o=!0}if(i&&!this._bInvalid&&this.getBinding(\"rows\")){var l=this;this._mTimeouts._rowsUpdated&&window.clearTimeout(this._mTimeouts._rowsUpdated),this._mTimeouts._rowsUpdated=window.setTimeout(function(){l._fireRowsUpdated(e)},0)}return o},A.prototype._getDefaultRowHeight=function(){var t=this.getRowHeight();if(t>0)return t+g.ROW_HORIZONTAL_FRAME_SIZE;var e=g.getContentDensity(this);return g.DEFAULT_ROW_HEIGHT[e]},A.prototype._setRowContentHeight=function(e){e=e||0;var i,o=this.getVisibleRowCountMode(),n=this.getVisibleRowCount(),s=this._getDefaultRowHeight(),r=this.getMinAutoRowCount();o==x.Interactive||o==x.Fixed?this._iTableRowContentHeight&&o==x.Interactive?(i=r*s,e||(e=this._iTableRowContentHeight)):(i=n*s,e=i):o==x.Auto&&(i=r*s);var a=Math.max(e,i);o==x.Fixed&&0==this.getRows().length||o!=x.Fixed?this._iTableRowContentHeight=Math.floor(a/s)*s:this._iTableRowContentHeight=void 0,g.isVariableRowHeightEnabled(this)?t(this.getDomRef(\"tableCCnt\")).css(\"height\",s*n+\"px\"):(o==x.Fixed||o==x.Interactive)&&this.getRows().length>0?t(this.getDomRef(\"tableCtrlCnt\")).css(\"height\",\"auto\"):t(this.getDomRef(\"tableCtrlCnt\")).css(\"height\",this._iTableRowContentHeight+\"px\")},A.prototype._determineMinAutoRowCount=function(){var t=this.getMinAutoRowCount();return this.getVisibleRowCountMode()!=x.Interactive||this.bOutput||(t=this.getVisibleRowCount()||t),t},A.prototype._calculateRowsToDisplay=function(t){this._iRowsToDisplayHeight=t||this._iRowsToDisplayHeight||this._iTableRowContentHeight,t=this._iRowsToDisplayHeight;var e=this.getVisibleRowCountMode(),i=0;if(e==x.Fixed)i=this.getVisibleRowCount()||0;else if(e==x.Interactive||e==x.Auto){var o=this._determineMinAutoRowCount(),n=this._getDefaultRowHeight();if(n&&t){var s=Math.min(t,5e4),r=Math.floor(s/n);i=Math.max(this.getFixedRowCount()+this.getFixedBottomRowCount()+1,Math.max(o,r))}else i=o}return Math.max(i,0)},A.prototype.setShowNoData=function(t){return this.setProperty(\"showNoData\",t,!0),this._updateNoData(),this},A.prototype.setNoData=function(t){var e=g.getNoDataText(this);this.setAggregation(\"noData\",t,!0);var i=g.getNoDataText(this);return null!=e&&null!=i&&e!=i?this.$(\"noDataMsg\").text(i):this.invalidate(),this},A.prototype.exportData=function(t){var e=sap.ui.requireSync(\"sap/ui/core/util/Export\");if(t=t||{},!t.rows){var i=this.getBinding(\"rows\"),o=this.getBindingInfo(\"rows\"),n=i.aFilters.concat(i.aApplicationFilters);t.rows={path:o.path,model:o.model,sorter:i.aSorters,filters:n,parameters:o.parameters}}if(!t.exportType){var s=sap.ui.requireSync(\"sap/ui/core/util/ExportTypeCSV\");t.exportType=new s}var r=t.rows.model;if(!r){var a=t.rows.path,l=a.indexOf(\">\");l>0&&(r=a.substr(0,l))}if(!t.columns){t.columns=[];for(var u=this.getColumns(),h=0,d=u.length;h<d;h++){var p=u[h];p.getSortProperty()&&t.columns.push({name:p.getLabel().getText(),template:{content:{path:p.getSortProperty(),model:r}}})}}var g=new e(t);return this.addDependent(g),g},A.prototype._onPersoApplied=function(){for(var t=this.getColumns(),e=[],i=0,o=t.length;i<o;i++){var n=t[i];n.getSorted()&&e.push(new l(n.getSortProperty(),n.getSortOrder()===T.Descending))}var s=this.getBinding(\"rows\");s&&(e.length>0&&s.sort(e),this.refreshRows())},A.prototype._toggleSelectAll=function(){g.hasData(this)&&(g.areAllRowsSelected(this)?(this._iSourceRowIndex=-1,this.clearSelection()):(this._iSourceRowIndex=0,this.selectAll()),this._iSourceRowIndex=void 0)},A.prototype._restoreAppDefaultsColumnHeaderSortFilter=function(){var e=this.getColumns();t.each(e,function(t,e){e._restoreAppDefaults()})},A.prototype.setBusy=function(t,e){var o=this.getBusy()!=t;e=\"sapUiTableCnt\";var n=i.prototype.setBusy.call(this,t,e);return o&&this.fireBusyStateChanged({busy:t}),n},A.prototype.setEnableBusyIndicator=function(t){this.setProperty(\"enableBusyIndicator\",t,!0),t||this.setBusy(!1)},A.prototype._onBindingDataRequested=function(e){if(e.getSource()==this.getBinding(\"rows\")&&!e.getParameter(\"__simulateAsyncAnalyticalBinding\")){this._iPendingRequests++,this._bPendingRequest=!0;var i=g.canUsePendingRequestsCounter(this);this.getEnableBusyIndicator()&&(i&&1===this._iPendingRequests||!i)&&this.setBusy(!0),null!=this._dataReceivedHandlerId&&(t.sap.clearDelayedCall(this._dataReceivedHandlerId),delete this._dataReceivedHandlerId)}},A.prototype._onBindingDataReceived=function(e){e.getSource()!=this.getBinding(\"rows\")||e.getParameter(\"__simulateAsyncAnalyticalBinding\")||(this._iPendingRequests--,this._bPendingRequest=!1,this._updateTotalRowCount(!0),g.hasPendingRequests(this)||(this._dataReceivedHandlerId=t.sap.delayedCall(0,this,function(){this.getEnableBusyIndicator()&&this.setBusy(!1),this._updateNoData(),delete this._dataReceivedHandlerId})))},A.prototype._setLargeDataScrolling=function(t){this._bLargeDataScrolling=!!t},A.prototype._getSelectedIndicesCount=function(){return this.getSelectedIndices().length},A.prototype._updateTableContent=function(){g.Grouping.updateGroups(this)},A.prototype.setRowActionTemplate=function(t){return this.setAggregation(\"rowActionTemplate\",t),t=this.getRowActionTemplate(),t&&t._setCount(this.getRowActionCount()),this.invalidateRowsAggregation(),this},A.prototype.setRowActionCount=function(t){this.setProperty(\"rowActionCount\",t),t=this.getRowActionCount();var e=this.getRowActionTemplate();e&&e._setCount(t);for(var i=this.getRows(),o=0;o<i.length;o++)(e=i[o].getAggregation(\"_rowAction\"))&&e._setCount(t);return this},A.prototype.setRowSettingsTemplate=function(t){return this.setAggregation(\"rowSettingsTemplate\",t),this.invalidateRowsAggregation(),this},A.prototype._validateRow=function(t){return t&&t instanceof d&&t.getParent()===this},A.prototype.getRowForCell=function(t){if(t){var e=t.getParent();if(this._validateRow(e))return e}return null},A.prototype.getColumnForCell=function(t){if(this.getRowForCell(t)){var e=t.data(\"sap-ui-colindex\"),i=this.getColumns();if(e>=0&&e<i.length)return i[e]}return null},A.prototype.getCellControl=function(t,e,i){return g.getRowColCell(this,t,e,!i).cell},A.prototype._fireRowsUpdated=function(t){null==t&&(t=g.RowsUpdateReason.Unknown),this.fireEvent(\"_rowsUpdated\",{reason:t})},A});",
	"sap/ui/table/TableAccExtension.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/core/Control\",\"./library\",\"./TableExtension\",\"./TableAccRenderExtension\",\"./TableUtils\",\"sap/ui/Device\"],function(e,t,a,l,i,r,o){\"use strict\";var n=a.SelectionMode,s=r.CELLTYPE,d={getAccInfoOfControl:function(e,t){if(e&&\"function\"==typeof e.getAccessibilityInfo){if(\"function\"==typeof e.getVisible&&!e.getVisible())return d._normalize({});var a=e.getAccessibilityInfo();if(a){var l={};return d._flatten(a,l,t),l}}return null},_normalize:function(e){return e?e._normalized?e:(e.role=e.role||\"\",e.type=e.type||\"\",e.description=e.description||\"\",e.focusable=!!e.focusable,e.enabled=!0===e.enabled||!1===e.enabled?e.enabled:null,e.editable=!0===e.editable||!1===e.editable?e.editable:null,e.children=e.children||[],e._normalized=!0,e):null},_flatten:function(e,t,a,l){l=l||0,d._normalize(e),0==l&&(d._normalize(t),t._descriptions=[]),t.focusable=t.focusable||e.focusable,t._descriptions.push(d._getFullDescription(e,a)),e.children.forEach(function(e){if(e.getAccessibilityInfo&&(!e.getVisible||e.getVisible())){var i=e.getAccessibilityInfo();i&&d._flatten(i,t,a,l+1)}}),0==l&&(t.description=t._descriptions.join(\" \").trim(),t._descriptions=void 0)},_getFullDescription:function(e,t){var a=e.type+\" \"+e.description;return null==e.enabled||e.enabled?null==e.editable||e.editable||(a=a+\" \"+t.getText(\"TBL_CTRL_STATE_READONLY\")):a=a+\" \"+t.getText(\"TBL_CTRL_STATE_DISABLED\"),a.trim()}},u={getColumnIndexOfFocusedCell:function(e){var t=e.getTable();return r.getFocusedItemInfo(t).cellInRow-(r.hasRowHeader(t)?1:0)},getInfoOfFocusedCell:function(e){var t=e.getTable(),a=t._getItemNavigation(),l=t.getDomRef();if(!e.getAccMode()||!l||!a)return null;var i=a.getFocusedDomRef();return i&&i===document.activeElement?r.getCellInfo(i):null},getRelevantColumnHeaders:function(e,t){if(!e||!t)return[];var a=r.getHeaderRowCount(e),l=t.getId(),i=[l];if(a>1){for(var o=1;o<a;o++)i.push(l+\"_\"+o);var n=r.Column.getParentSpannedColumns(e,l);if(n&&n.length)for(var o=0;o<n.length;o++){var s=n[o].level,d=n[o].column.getId();i[s]=0===s?d:d+\"_\"+s}}return i},isHiddenCell:function(e,t){var a=r.Grouping.isInGroupingRow(e),l=r.Grouping.isInSumRow(e),i=!!t&&!!t.hasStyleClass,o=e.parent().hasClass(\"sapUiTableRowHidden\"),n=e.hasClass(\"sapUiTableCellHidden\"),s=a&&e.hasClass(\"sapUiTableTdFirst\")&&!e.hasClass(\"sapUiTableMeasureCell\"),d=a&&i&&t.hasStyleClass(\"sapUiAnalyticalTableGroupCellHidden\"),u=l&&i&&t.hasStyleClass(\"sapUiAnalyticalTableSumCellHidden\");return o||n||s||d||u},isTreeColumnCell:function(e,t){return r.Grouping.isTreeMode(e.getTable())&&t.hasClass(\"sapUiTableTdFirst\")},getColumnTooltip:function(e){if(!e)return null;var a=e.getTooltip_AsString();if(a)return a;var l=e.getLabel();return l instanceof t&&(a=l.getTooltip_AsString()),a||null},updateRowColCount:function(e){var t=e.getTable(),a=t._getItemNavigation(),l=!1,i=!1,o=!1;if(a){var n=u.getColumnIndexOfFocusedCell(e)+1,s=r.getRowIndexOfFocusedCell(t)+t._getFirstRenderedRowIndex()+1,d=r.getVisibleColumnCount(t)+(r.hasRowActions(t)?1:0),c=r.isNoDataVisible(t)?0:r.getTotalRowCount(t,!0);l=e._iLastRowNumber!=s||e._iLastRowNumber==s&&e._iLastColumnNumber==n,i=e._iLastColumnNumber!=n,o=!e._iLastRowNumber&&!e._iLastColumnNumber,t.$(\"rownumberofrows\").text(l?t._oResBundle.getText(\"TBL_ROW_ROWCOUNT\",[s,c]):\" \"),t.$(\"colnumberofcols\").text(i?t._oResBundle.getText(\"TBL_COL_COLCOUNT\",[n,d]):\" \"),t.$(\"ariacount\").text(o?t._oResBundle.getText(\"TBL_DATA_ROWS_COLS\",[c,d]):\" \"),e._iLastRowNumber=s,e._iLastColumnNumber=n}return{rowChange:l,colChange:i,initial:o}},cleanupCellModifications:function(e){e._cleanupInfo&&(e._cleanupInfo.cell.attr(e._cleanupInfo.attr),e._cleanupInfo=null)},storeDefaultsBeforeCellModifications:function(e,t,a,l){e._cleanupInfo={cell:t,attr:{\"aria-labelledby\":a&&a.length?a.join(\" \"):null,\"aria-describedby\":l&&l.length?l.join(\" \"):null}}},performCellModifications:function(e,t,a,l,i,r,o,s){u.storeDefaultsBeforeCellModifications(e,t,a,l);var d=u.updateRowColCount(e);e.getTable().$(\"cellacc\").text(o||\" \"),s&&s(i,r,d.rowChange,d.colChange,d.initial);var c=\"\";if(d.initial){var E=e.getTable();c=E.getAriaLabelledBy().join(\" \")+\" \"+E.getId()+\"-ariadesc \"+E.getId()+\"-ariacount\",E.getSelectionMode()!==n.None&&(c=c+\" \"+E.getId()+\"-ariaselection\")}i&&i.length&&(c=c+\" \"+i.join(\" \")),t.attr({\"aria-labelledby\":c||null,\"aria-describedby\":r&&r.length?r.join(\" \"):null})},modifyAccOfDATACELL:function(e,t){var a=this.getTable(),l=a.getId();if(a._getItemNavigation()){var i=r.getRowIndexOfFocusedCell(a),o=u.getColumnIndexOfFocusedCell(this),n=r.getRowColCell(a,i,o,!1),s=null,E=u.isHiddenCell(e,n.cell),T=u.isTreeColumnCell(this,e),g=r.Grouping.isInGroupingRow(e),b=r.Grouping.isInSumRow(e),p=u.getAriaAttributesFor(this,c.ELEMENTTYPES.DATACELL,{index:o,column:n.column,fixed:r.isFixedColumn(a,o)})[\"aria-labelledby\"]||[],C=[],f=[l+\"-rownumberofrows\",l+\"-colnumberofcols\"];if(g&&(f.push(l+\"-ariarowgrouplabel\"),f.push(l+\"-rows-row\"+i+\"-groupHeader\")),b){var h=e.parent().data(\"sap-ui-level\");0==h?f.push(l+\"-ariagrandtotallabel\"):h>0&&(f.push(l+\"-ariagrouptotallabel\"),f.push(l+\"-rows-row\"+i+\"-groupHeader\"))}!r.hasRowHighlights(a)||g||b||f.push(n.row.getId()+\"-highlighttext\"),f=f.concat(p),E||(s=d.getAccInfoOfControl(n.cell,a._oResBundle),f.push(s?l+\"-cellacc\":n.cell.getId()),((!s||s.focusable)&&!this._readonly||T&&n.row&&n.row._bHasChildren)&&C.push(l+\"-toggleedit\"),r.Grouping.isTreeMode(a)&&e.parent().attr(\"aria-selected\")&&f.push(l+\"-ariarowselected\"));var A=s?s.description:\" \";if(T&&!E){var R=u.getAriaAttributesFor(this,c.ELEMENTTYPES.TREEICON,{row:n.row});R&&R[\"aria-label\"]&&(A=R[\"aria-label\"]+\" \"+A)}u.performCellModifications(this,e,p,null,f,C,A,function(e,t,l,i,o){!E&&r.isRowSelectionAllowed(a)&&l&&t.push(n.row.getId()+\"-rowselecttext\")})}},modifyAccOfROWHEADER:function(e,t){var a=this.getTable(),l=a.getId(),i=r.Grouping.isInGroupingRow(e),o=r.Grouping.isInSumRow(e),n=a.getRows()[e.attr(\"data-sap-ui-rowindex\")],s=u.getAriaAttributesFor(this,c.ELEMENTTYPES.ROWHEADER)[\"aria-labelledby\"]||[],d=s.concat([l+\"-rownumberofrows\"]);if(o||i||e.hasClass(\"sapUiTableRowHidden\")||(d.push(n.getId()+\"-rowselecttext\"),r.hasRowHighlights(a)&&d.push(n.getId()+\"-highlighttext\")),i&&d.push(l+\"-ariarowgrouplabel\"),o){var E=e.data(\"sap-ui-level\");0==E?d.push(l+\"-ariagrandtotallabel\"):E>0&&d.push(l+\"-ariagrouptotallabel\")}u.performCellModifications(this,e,s,null,d,null,null)},modifyAccOfCOLUMNHEADER:function(e,t){var a=this.getTable(),l=sap.ui.getCore().byId(e.attr(\"data-sap-ui-colid\")),i=u.getAriaAttributesFor(this,c.ELEMENTTYPES.COLUMNHEADER,{headerId:e.attr(\"id\"),column:l,index:e.attr(\"data-sap-ui-colindex\")}),o=u.getColumnTooltip(l),n=[a.getId()+\"-colnumberofcols\"].concat(i[\"aria-labelledby\"]),s=r.getCellInfo(e),d=s.columnSpan;d>1&&(n.push(a.getId()+\"-ariacolspan\"),a.$(\"ariacolspan\").text(a._oResBundle.getText(\"TBL_COL_DESC_SPAN\",[\"\"+d]))),o&&n.push(a.getId()+\"-cellacc\"),d<=1&&l&&l.getSorted()&&n.push(a.getId()+(\"Ascending\"===l.getSortOrder()?\"-ariacolsortedasc\":\"-ariacolsorteddes\")),d<=1&&l&&l.getFiltered()&&n.push(a.getId()+\"-ariacolfiltered\"),d<=1&&\"true\"===e.attr(\"aria-haspopup\")&&n.push(a.getId()+\"-ariacolmenu\"),u.performCellModifications(this,e,i[\"aria-labelledby\"],i[\"aria-describedby\"],n,i[\"aria-describedby\"],o)},modifyAccOfCOLUMNROWHEADER:function(e,t){var a=this.getTable(),l=e.hasClass(\"sapUiTableSelAllEnabled\");a.$(\"sapUiTableGridCnt\").removeAttr(\"role\");var i=u.getAriaAttributesFor(this,c.ELEMENTTYPES.COLUMNROWHEADER,{enabled:l,checked:l&&!a.$().hasClass(\"sapUiTableSelAll\")});u.performCellModifications(this,e,i[\"aria-labelledby\"],i[\"aria-describedby\"],i[\"aria-labelledby\"],i[\"aria-describedby\"],null)},modifyAccOfROWACTION:function(e,t){var a=this.getTable(),l=a.getId(),i=r.Grouping.isInGroupingRow(e),o=r.Grouping.isInSumRow(e),n=e.attr(\"data-sap-ui-rowindex\"),s=a.getRows()[n],d=u.isHiddenCell(e),E=u.getAriaAttributesFor(this,c.ELEMENTTYPES.ROWACTION)[\"aria-labelledby\"]||[],T=[l+\"-rownumberofrows\",l+\"-colnumberofcols\"].concat(E),g=[];if(i&&(T.push(l+\"-ariarowgrouplabel\"),T.push(l+\"-rows-row\"+n+\"-groupHeader\")),o){var b=e.data(\"sap-ui-level\");0==b?T.push(l+\"-ariagrandtotallabel\"):b>0&&(T.push(l+\"-ariagrouptotallabel\"),T.push(l+\"-rows-row\"+n+\"-groupHeader\"))}o||i||\"true\"!=e.attr(\"aria-selected\")||T.push(l+\"-ariarowselected\"),!r.hasRowHighlights(a)||i||o||T.push(s.getId()+\"-highlighttext\");var p=\"\";if(!d){var C=s.getAggregation(\"_rowAction\");if(C){var f=C.getAccessibilityInfo();f&&(T.push(l+\"-cellacc\"),p=f.description,f.focusable&&g.push(l+\"-toggleedit\"))}}u.performCellModifications(this,e,E,[],T,g,p)},getAriaAttributesFor:function(a,l,i){function o(e,t,a,l){var i=\"\";a&&l?i=\"overlay,nodata\":a&&!l?i=\"overlay\":!a&&l&&(i=\"nodata\");var o=!1;(a&&e.getShowOverlay()||l&&r.isNoDataVisible(e))&&(o=!0),o&&(s[\"aria-hidden\"]=\"true\"),i&&(s[\"data-sap-ui-table-acc-covered\"]=i)}var s={},d=a.getTable(),E=d.getId();switch(l){case c.ELEMENTTYPES.COLUMNROWHEADER:s[\"aria-labelledby\"]=[E+\"-ariacolrowheaderlabel\"];var T=!1;s.role=[\"button\"],i&&i.enabled?s[\"aria-pressed\"]=i.checked?\"true\":\"false\":(T=!0,s[\"aria-disabled\"]=\"true\",s[\"aria-pressed\"]=\"false\"),!T&&d._getShowStandardTooltips()||s[\"aria-labelledby\"].push(E+\"-ariaselectall\");break;case c.ELEMENTTYPES.ROWHEADER:if(s[\"aria-labelledby\"]=[E+\"-ariarowheaderlabel\"],r.Grouping.isTreeMode(d)||(s.role=[\"rowheader\"]),!(d.getSelectionMode()===n.None||i&&i.rowHidden)){var g=i&&i.rowSelected;s[\"aria-selected\"]=\"\"+g;var b=a.getAriaTextsForSelectionMode(!0);s.title=b.mouse[g?\"rowDeselect\":\"rowSelect\"]}break;case c.ELEMENTTYPES.ROWACTION:if(s.role=[\"gridcell\"],s[\"aria-labelledby\"]=[E+\"-rowacthdr\"],!(d.getSelectionMode()===n.None||i&&i.rowHidden)){var g=i&&i.rowSelected;s[\"aria-selected\"]=\"\"+g}break;case c.ELEMENTTYPES.COLUMNHEADER:var p=i&&i.column,C=i&&i.colspan;s.role=\"columnheader\";var f=[];if(i&&i.headerId){var h=u.getRelevantColumnHeaders(d,p),A=e.inArray(i.headerId,h);f=A>0?h.slice(0,A+1):[i.headerId]}for(var R=0;R<f.length;R++)f[R]=f[R]+\"-inner\";s[\"aria-labelledby\"]=f,i&&i.index<d.getFixedColumnCount()&&s[\"aria-labelledby\"].push(E+\"-ariafixedcolumn\"),!C&&p&&p.getSorted()&&(s[\"aria-sort\"]=\"Ascending\"===p.getSortOrder()?\"ascending\":\"descending\"),!C&&p&&p._menuHasItems()&&(s[\"aria-haspopup\"]=\"true\");break;case c.ELEMENTTYPES.DATACELL:s.role=\"gridcell\";var f=[],p=i&&i.column?i.column:null;if(p){f=u.getRelevantColumnHeaders(d,p),s.headers=f.join(\" \");for(var R=0;R<f.length;R++)f[R]=f[R]+\"-inner\";i&&i.fixed&&f.push(E+\"-ariafixedcolumn\")}if(s[\"aria-labelledby\"]=f,r.Grouping.isTreeMode(d)&&i&&i.firstCol&&i.row){var _=d.mBindingInfos.rows;i.row.getBindingContext(_&&_.model)&&(s[\"aria-level\"]=i.row._iLevel+1,s[\"aria-expanded\"]=\"\"+i.row._bIsExpanded)}break;case c.ELEMENTTYPES.ROOT:break;case c.ELEMENTTYPES.TABLE:s.role=\"presentation\",o(d,s,!0,!0);break;case c.ELEMENTTYPES.CONTENT:s.role=r.Grouping.isGroupMode(d)||r.Grouping.isTreeMode(d)?\"treegrid\":\"grid\",s[\"aria-labelledby\"]=[].concat(d.getAriaLabelledBy()),d.getTitle()&&s[\"aria-labelledby\"].push(d.getTitle().getId()),d.getSelectionMode()!==n.Multi&&d.getSelectionMode()!==n.MultiToggle||(s[\"aria-multiselectable\"]=\"true\");break;case c.ELEMENTTYPES.TABLEHEADER:s.role=\"heading\",o(d,s,!0,!1);break;case c.ELEMENTTYPES.COLUMNHEADER_TBL:s.role=\"presentation\";break;case c.ELEMENTTYPES.COLUMNHEADER_ROW:s.role=\"row\",o(d,s,!0,!1);break;case c.ELEMENTTYPES.ROWHEADER_COL:o(d,s,!0,!0);break;case c.ELEMENTTYPES.TH:var L=d.getFixedColumnCount()>0;L||(s.role=\"presentation\"),s.scope=\"col\",L?i&&i.column&&(s[\"aria-owns\"]=i.column.getId(),s[\"aria-labelledby\"]=[i.column.getId()]):s[\"aria-hidden\"]=\"true\";break;case c.ELEMENTTYPES.ROWHEADER_TD:if(s.role=\"rowheader\",s[\"aria-labelledby\"]=[E+\"-ariarowheaderlabel\"],s.headers=E+\"-colsel\",i&&\"number\"==typeof i.index&&(s[\"aria-owns\"]=E+\"-rowsel\"+i.index),d.getSelectionMode()!==n.None){var g=i&&i.rowSelected;s[\"aria-selected\"]=\"\"+g}break;case c.ELEMENTTYPES.TR:s.role=\"row\";var g=!1;if(i&&\"number\"==typeof i.index&&d.getSelectionMode()!==n.None&&d.isIndexSelected(i.index)&&(s[\"aria-selected\"]=\"true\",g=!0),r.isRowSelectionAllowed(d)&&d.getContextByIndex(i.index)){var b=a.getAriaTextsForSelectionMode(!0);s.title=b.mouse[g?\"rowDeselect\":\"rowSelect\"]}break;case c.ELEMENTTYPES.TREEICON:if(r.Grouping.isTreeMode(d)&&(s={\"aria-label\":\"\",title:\"\",role:\"\"},d.getBinding(\"rows\")&&(s.role=\"button\",i&&i.row)))if(i.row._bHasChildren){var O=d._oResBundle.getText(i.row._bIsExpanded?\"TBL_COLLAPSE\":\"TBL_EXPAND\");d._getShowStandardTooltips()?s.title=O:s[\"aria-label\"]=O,s[\"aria-expanded\"]=\"\"+!!i.row._bIsExpanded}else s[\"aria-label\"]=d._oResBundle.getText(\"TBL_LEAF\");break;case c.ELEMENTTYPES.NODATA:s.role=\"gridcell\";var m=d.getNoData();s[\"aria-labelledby\"]=[m instanceof t?m.getId():E+\"-noDataMsg\"],o(d,s,!0,!1);break;case c.ELEMENTTYPES.OVERLAY:s.role=\"region\",s[\"aria-labelledby\"]=[].concat(d.getAriaLabelledBy()),d.getTitle()&&s[\"aria-labelledby\"].push(d.getTitle().getId()),s[\"aria-labelledby\"].push(E+\"-ariainvalid\");break;case c.ELEMENTTYPES.TABLEFOOTER:case c.ELEMENTTYPES.TABLESUBHEADER:o(d,s,!0,!1);break;case c.ELEMENTTYPES.ROWACTIONHEADER:s[\"aria-hidden\"]=\"true\";break;case\"PRESENTATION\":s.role=\"presentation\"}return s}},c=l.extend(\"sap.ui.table.TableAccExtension\",{_init:function(e,t,a){return this._accMode=sap.ui.getCore().getConfiguration().getAccessibility(),this._readonly=t===l.TABLETYPES.ANALYTICAL,this._busyCells=[],e.addEventDelegate(this),l.enrich(e,i),\"AccExtension\"},_debug:function(){this._ExtensionHelper=u,this._ACCInfoHelper=d},destroy:function(){this.getTable().removeEventDelegate(this),this._readonly=!1,this._busyCells=[],l.prototype.destroy.apply(this,arguments)},getAriaAttributesFor:function(e,t){return u.getAriaAttributesFor(this,e,t)},onfocusin:function(t){var a=this.getTable();a&&null!=r.getCellInfo(t.target).cell&&(a._mTimeouts._cleanupACCExtension&&(e.sap.clearDelayedCall(a._mTimeouts._cleanupACCExtension),a._mTimeouts._cleanupACCExtension=null),this.updateAccForCurrentCell(!0))},onfocusout:function(t){var a=this.getTable();a&&(a.$(\"sapUiTableGridCnt\").attr(\"role\",u.getAriaAttributesFor(this,\"CONTENT\",{}).role),a._mTimeouts._cleanupACCExtension=e.sap.delayedCall(100,this,function(){var e=this.getTable();e&&(this._iLastRowNumber=null,this._iLastColumnNumber=null,u.cleanupCellModifications(this),e._mTimeouts._cleanupACCExtension=null)}))}});return c.ELEMENTTYPES={DATACELL:\"DATACELL\",COLUMNHEADER:\"COLUMNHEADER\",ROWHEADER:\"ROWHEADER\",ROWACTION:\"ROWACTION\",COLUMNROWHEADER:\"COLUMNROWHEADER\",ROOT:\"ROOT\",CONTENT:\"CONTENT\",TABLE:\"TABLE\",TABLEHEADER:\"TABLEHEADER\",TABLEFOOTER:\"TABLEFOOTER\",TABLESUBHEADER:\"TABLESUBHEADER\",COLUMNHEADER_TBL:\"COLUMNHEADER_TABLE\",COLUMNHEADER_ROW:\"COLUMNHEADER_ROW\",ROWHEADER_COL:\"ROWHEADER_COL\",TH:\"TH\",ROWHEADER_TD:\"ROWHEADER_TD\",TR:\"TR\",TREEICON:\"TREEICON\",ROWACTIONHEADER:\"ROWACTIONHEADER\",NODATA:\"NODATA\",OVERLAY:\"OVERLAY\"},c.prototype.getAccMode=function(){return this._accMode},c.prototype.updateAccForCurrentCell=function(t){if(this._accMode&&this.getTable()._getItemNavigation()){var a=this.getTable();t&&u.cleanupCellModifications(this);var l,i=u.getInfoOfFocusedCell(this);if(i&&i.cell&&(i.isOfType(s.DATACELL)?l=c.ELEMENTTYPES.DATACELL:i.isOfType(s.COLUMNHEADER)?l=c.ELEMENTTYPES.COLUMNHEADER:i.isOfType(s.ROWHEADER)?l=c.ELEMENTTYPES.ROWHEADER:i.isOfType(s.ROWACTION)?l=c.ELEMENTTYPES.ROWACTION:i.isOfType(s.COLUMNROWHEADER)&&(l=c.ELEMENTTYPES.COLUMNROWHEADER),u[\"modifyAccOf\"+l])){if(!t){if(!i.isOfType(s.DATACELL|s.ROWHEADER))return;a._mTimeouts._cleanupACCCellBusy&&(e.sap.clearDelayedCall(a._mTimeouts._cleanupACCCellBusy),a._mTimeouts._cleanupACCCellBusy=null),a._mTimeouts._cleanupACCCellBusy=e.sap.delayedCall(100,this,function(){for(var e=0;e<this._busyCells.length;e++)this._busyCells[e].removeAttr(\"aria-hidden\"),this._busyCells[e].removeAttr(\"aria-busy\");a._mTimeouts._cleanupACCCellBusy=null,this._busyCells=[]}),o.browser.chrome&&i.cell.attr(\"aria-hidden\",\"true\"),i.cell.attr(\"aria-busy\",\"true\"),this._busyCells.push(i.cell)}u[\"modifyAccOf\"+l].apply(this,[i.cell,t])}}},c.prototype.updateAriaStateOfColumn=function(t){if(this._accMode)for(var a=u.getAriaAttributesFor(this,c.ELEMENTTYPES.COLUMNHEADER,{headerId:t.getId(),column:t,index:this.getTable().indexOfColumn(t)}),l=u.getRelevantColumnHeaders(this.getTable(),t),i=0;i<l.length;i++){var r=e.sap.byId(l[i]);r.attr(\"colspan\")||r.attr({\"aria-sort\":a[\"aria-sort\"]||null})}},c.prototype.updateAriaStateOfRow=function(e,t,a){if(this._accMode&&(t||(t=e.getDomRefs(!0)),t.row&&(t.row.children(\"td\").add(t.row).attr(\"aria-selected\",a?\"true\":null),a&&t.rowSelectorText))){var l=t.rowSelectorText.text();l&&(l=this.getTable()._oResBundle.getText(\"TBL_ROW_DESC_SELECTED\")+\" \"+l),t.rowSelectorText.text(l)}},c.prototype.updateAriaExpandAndLevelState=function(e,t,a,l,i,r,o,n,s){if(this._accMode){var d=null,E=this.getTable(),T=[t,t.children(),a,l,l?l.children():null,i],g=!!s,b=E.getBinding(\"rows\");if(!r&&a&&!g){var p=a.attr(\"data-sap-ui-rowindex\");d=u.getAriaAttributesFor(this,c.ELEMENTTYPES.ROWHEADER,{rowSelected:!e._bHidden&&E.isIndexSelected(p)}).title||null}a&&!g&&a.attr({\"aria-haspopup\":r?\"true\":null,title:d}),!(b&&b.hasTotaledMeasures&&n>0)||b.bProvideGrandTotals&&b.hasTotaledMeasures()||(n-=1);for(var C=0;C<T.length;C++)T[C]&&T[C].attr({\"aria-expanded\":r?o+\"\":null,\"aria-level\":n<0?null:n+1});g&&s.attr(u.getAriaAttributesFor(this,c.ELEMENTTYPES.TREEICON,{row:e}))}},c.prototype.updateAriaStateOfRowHighlight=function(e){if(this._accMode&&null!=e){var t=e._getRow();if(null!=t){t.getDomRef(\"highlighttext\").innerText=e._getHighlightText()}}},c.prototype.updateAriaStateForOverlayAndNoData=function(){var e=this.getTable();e&&e.getDomRef()&&this._accMode&&(e.getShowOverlay()?e.$().find(\"[data-sap-ui-table-acc-covered*='overlay']\").attr(\"aria-hidden\",\"true\"):(e.$().find(\"[data-sap-ui-table-acc-covered*='overlay']\").removeAttr(\"aria-hidden\"),r.isNoDataVisible(e)?e.$().find(\"[data-sap-ui-table-acc-covered*='nodata']\").attr(\"aria-hidden\",\"true\"):e.$().find(\"[data-sap-ui-table-acc-covered*='nodata']\").removeAttr(\"aria-hidden\")))},c.prototype.getAriaTextsForSelectionMode=function(e,t){var a=this.getTable();t||(t=a.getSelectionMode());var l=a._oResBundle,i=a._getShowStandardTooltips(),r={mouse:{rowSelect:\"\",rowDeselect:\"\"},keyboard:{rowSelect:\"\",rowDeselect:\"\"}},o=a._getSelectedIndicesCount();return t===n.Single?(r.mouse.rowSelect=i?l.getText(\"TBL_ROW_SELECT\"):\"\",r.mouse.rowDeselect=i?l.getText(\"TBL_ROW_DESELECT\"):\"\",r.keyboard.rowSelect=l.getText(\"TBL_ROW_SELECT_KEY\"),r.keyboard.rowDeselect=l.getText(\"TBL_ROW_DESELECT_KEY\")):t===n.MultiToggle&&(r.mouse.rowSelect=i?l.getText(\"TBL_ROW_SELECT_MULTI_TOGGLE\"):\"\",r.mouse.rowDeselect=i?l.getText(\"TBL_ROW_DESELECT\"):\"\",r.keyboard.rowSelect=l.getText(\"TBL_ROW_SELECT_MULTI_TOGGLE_KEY\"),r.keyboard.rowDeselect=l.getText(\"TBL_ROW_DESELECT_KEY\"),!0===e&&0===o&&(r.mouse.rowSelect=i?l.getText(\"TBL_ROW_SELECT\"):\"\",r.keyboard.rowSelect=l.getText(\"TBL_ROW_SELECT_KEY\"))),r},c.prototype.setSelectAllState=function(e){var t=this.getTable();t&&t.$(\"selall\").attr(\"aria-pressed\",e?\"true\":\"false\")},c.prototype.addColumnHeaderLabel=function(t,a){var l=this.getTable();if(this._accMode&&a.getAriaLabelledBy&&l){var i=l.getColumnHeaderVisible()?t.getId():null;if(!i){var r=t.getAggregation(\"label\");r&&(i=r.getId())}var o=a.getAriaLabelledBy();i&&e.inArray(i,o)<0&&a.addAriaLabelledBy(i)}},c});",
	"sap/ui/table/TableAccRenderExtension.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"./TableExtension\",\"./library\"],function(e,t,i){\"use strict\";var r=i.SelectionMode,a=function(e,t,i,r,a){a=a||[],a.push(\"sapUiInvisibleText\"),e.write(\"<span\"),e.writeAttribute(\"id\",t+\"-\"+i),e.writeAttribute(\"class\",a.join(\" \")),e.writeAttribute(\"aria-hidden\",\"true\"),e.write(\">\"),r&&e.writeEscaped(r),e.write(\"</span>\")};return t.extend(\"sap.ui.table.TableAccRenderExtension\",{_init:function(e,t,i){return\"AccRenderExtension\"},writeHiddenAccTexts:function(e,t){if(t._getAccExtension().getAccMode()){var i=t._oResBundle,o=t.getId();e.write(\"<div class='sapUiTableHiddenTexts' style='display:none;' aria-hidden='true'>\");var n=t.getTitle()&&t.getTitle().getText&&\"\"!=t.getTitle().getText()?t.getTitle().getText():\"\";a(e,o,\"ariadesc\",n),a(e,o,\"ariacount\"),a(e,o,\"toggleedit\",i.getText(\"TBL_TOGGLE_EDIT_KEY\")),a(e,o,\"ariaselectall\",i.getText(\"TBL_SELECT_ALL\")),a(e,o,\"ariarowheaderlabel\",i.getText(\"TBL_ROW_HEADER_LABEL\")),a(e,o,\"ariarowgrouplabel\",i.getText(\"TBL_ROW_GROUP_LABEL\")),a(e,o,\"ariagrandtotallabel\",i.getText(\"TBL_GRAND_TOTAL_ROW\")),a(e,o,\"ariagrouptotallabel\",i.getText(\"TBL_GROUP_TOTAL_ROW\")),a(e,o,\"ariacolrowheaderlabel\",i.getText(\"TBL_ROW_COL_HEADER_LABEL\")),a(e,o,\"rownumberofrows\"),a(e,o,\"colnumberofcols\"),a(e,o,\"cellacc\"),a(e,o,\"ariarowselected\",i.getText(\"TBL_ROW_DESC_SELECTED\")),a(e,o,\"ariacolmenu\",i.getText(\"TBL_COL_DESC_MENU\")),a(e,o,\"ariacolspan\"),a(e,o,\"ariacolfiltered\",i.getText(\"TBL_COL_DESC_FILTERED\")),a(e,o,\"ariacolsortedasc\",i.getText(\"TBL_COL_DESC_SORTED_ASC\")),a(e,o,\"ariacolsorteddes\",i.getText(\"TBL_COL_DESC_SORTED_DES\")),a(e,o,\"ariainvalid\",i.getText(\"TBL_TABLE_INVALID\"));var T=t.getSelectionMode();T!==r.None&&a(e,o,\"ariaselection\",i.getText(T==r.MultiToggle?\"TBL_TABLE_SELECTION_MULTI\":\"TBL_TABLE_SELECTION_SINGLE\")),t.getFixedColumnCount()>0&&a(e,o,\"ariafixedcolumn\",i.getText(\"TBL_FIXED_COLUMN\")),e.write(\"</div>\")}},writeAriaAttributesFor:function(t,i,r,a){var o=i._getAccExtension();if(o.getAccMode()){var n,T,c=o.getAriaAttributesFor(r,a);for(T in c)n=c[T],e.isArray(n)&&(n=n.join(\" \")),n&&t.writeAttributeEscaped(T,n)}},writeAccRowSelectorText:function(e,t,i,r){if(t._getAccExtension().getAccMode()){var o=t.isIndexSelected(r),n=t._getAccExtension().getAriaTextsForSelectionMode(!0),T=n.keyboard[o?\"rowDeselect\":\"rowSelect\"];a(e,i.getId(),\"rowselecttext\",i._bHidden?\"\":T,[\"sapUiTableAriaRowSel\"])}},writeAccRowHighlightText:function(e,t,i,r){if(t._getAccExtension().getAccMode()){var o=i.getAggregation(\"_settings\"),n=o._getHighlightText();a(e,i.getId(),\"highlighttext\",n)}}})});",
	"sap/ui/table/TableBindingUtils.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([],function(){\"use strict\";return{TableUtils:null,metadataLoaded:function(a){var t=a.getBinding(\"rows\"),n=null!=t?t.getModel():null,e=null,d=null,l=new Promise(function(a,t){e=a,d=t});return null==n?(d(),l):(null!=n.metadataLoaded?n.metadataLoaded().then(function(){e()}):null!=n.attachMetadataLoaded&&(null!=n.oMetadata&&n.oMetadata.isLoaded()?e():n.attachMetadataLoaded(function(){e()})),l)}}},!0);",
	"sap/ui/table/TableColumnUtils.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/Device\",\"./library\"],function(n,e,t){\"use strict\";var r={TableUtils:null,initColumnUtils:function(n){n._oColumnInfo||r.updateColumnInfo(n,r.collectColumnInfo(n))},invalidateColumnUtils:function(n){n._oColumnInfo=null},updateColumnInfo:function(n,e){n._oColumnInfo=e},collectColumnInfo:function(n){return{columnCount:n.getColumns().length,visibleColumnCount:r.TableUtils.getVisibleColumnCount(n),columnMap:r._getColumnMap(n)}},_getColumnMap:function(n){for(var e,t,l={},o={},u=n.getColumns(),a=r.TableUtils.getHeaderRowCount(n),i={},m=0;m<u.length;m++){t=u[m],l={},l.id=t.getId(),l.column=t,l.levelInfo=[],l.parents=[];for(var d=0;d<a;d++){l.levelInfo[d]={},l.levelInfo[d].spannedColumns=[];var s=r.getHeaderSpan(t,d);for(e=1;e<s;e++){var g=u[m+e];if(g){var f=g.getId();l.levelInfo[d].spannedColumns.push(u[m+e]),i[f]||(i[f]=[]),i[f].push({column:t,level:d})}}}o[l.id]=l}var C=Object.keys(i);for(e=0;e<C.length;e++){var v=C[e];o[v].parents=i[v]}return o},_getColumnMapItem:function(e,t){r.initColumnUtils(e);var l=e._oColumnInfo.columnMap[t];if(l)return l;n.sap.log.error(\"Column with ID '\"+t+\"' not found\",e)},getParentSpannedColumns:function(n,e,t){var l=r._getColumnMapItem(n,e);if(l){for(var o=[],u=0;u<l.parents.length;u++){var a=l.parents[u];void 0!==t&&a.level!==t||o.push(a)}return o}},getChildrenSpannedColumns:function(n,e,t){var l=r._getColumnMapItem(n,e);if(l){var o,u=[];o=void 0===t?l.levelInfo.length:t+1;for(var a=t||0;a<o;a++)for(var i=l.levelInfo[a],m=0;m<i.spannedColumns.length;m++)u.push({column:i.spannedColumns[m],level:a});return u}},getHeaderSpan:function(n,e){function t(n){var e=parseInt(n,10);return isNaN(e)?1:e}var r,l=n.getHeaderSpan();return l?(Array.isArray(l)||(l=(l+\"\").split(\",\")),r=isNaN(e)?Math.max.apply(null,l.map(t)):t(l[e]),Math.max(r,1)):1},getMaxHeaderSpan:function(n){return r.getHeaderSpan(n)},hasHeaderSpan:function(n){return r.getHeaderSpan(n)>1},getColumnBoundaries:function(n,e){var t=r._getColumnMapItem(n,e);if(t){var l={};e&&(l[e]=t.column);var o=function(e,t){var l,u,a=[];for(t=t||[],u=0;u<t.length;u++)l=e[t[u]],a=a.concat(r.getParentSpannedColumns(n,l.getId())),a=a.concat(r.getChildrenSpannedColumns(n,l.getId()));for(t=[],u=0;u<a.length;u++){l=a[u].column;var i=l.getId();e[i]||(t.push(i),e[i]=l)}return t.length>0?o(e,t):e};l=o(l,[e]);for(var u=n.indexOfColumn(t.column),a={startColumn:t.column,startIndex:u,endColumn:t.column,endIndex:-1},i=n.getColumns(),m=Object.getOwnPropertyNames(l),d=0;d<m.length;d++){var s=l[m[d]];u=n.indexOfColumn(s);var g=r.getMaxHeaderSpan(s);u<a.startIndex&&(a.startIndex=u,a.startColumn=s);var f=u+g-1;f>a.endIndex&&(a.endIndex=f,a.endColumn=i[f])}return a}},isColumnMovable:function(n){var e=n.getParent();if(!e||!e.getEnableColumnReordering())return!1;var t=e.indexOfColumn(n);return!(t<e.getFixedColumnCount()||t<e._iFirstReorderableIndex)&&(!r.hasHeaderSpan(n)&&0==r.getParentSpannedColumns(e,n.getId()).length)},_normalizeColumnMoveTargetIndex:function(n,e){var t=n.getParent(),r=t.indexOfColumn(n),l=t.getColumns();return e>r&&e--,e<0?e=0:e>l.length&&(e=l.length),e},isColumnMovableTo:function(n,e){var t=n.getParent();if(!t||void 0===e||!r.isColumnMovable(n))return!1;if((e=r._normalizeColumnMoveTargetIndex(n,e))<t.getFixedColumnCount()||e<t._iFirstReorderableIndex)return!1;var l=t.indexOfColumn(n),o=t.getColumns();if(e>l){var u=o[e>=o.length?o.length-1:e],a=r.getColumnBoundaries(t,u.getId());if(r.hasHeaderSpan(u)||a.endIndex>e)return!1}else{var i=o[e];if(0!=r.getParentSpannedColumns(t,i.getId()).length)return!1}return!0},moveColumnTo:function(n,e){if(!r.isColumnMovableTo(n,e))return!1;var t=n.getParent();return e!==t.indexOfColumn(n)&&(e=r._normalizeColumnMoveTargetIndex(n,e),!!t.fireColumnMove({column:n,newPos:e})&&(t._bReorderInProcess=!0,t.removeColumn(n),t.insertColumn(n,e),t._bReorderInProcess=!1,!0))},getMinColumnWidth:function(){return this._iColMinWidth?this._iColMinWidth:(this._iColMinWidth=48,e.system.desktop||(this._iColMinWidth=88),this._iColMinWidth)},resizeColumn:function(n,e,t,l,o){if(null==n||null==e||e<0||null==t||t<=0)return!1;(null==o||o<=0)&&(o=1),null==l&&(l=!0);var u=n.getColumns();if(e>=u.length||!u[e].getVisible())return!1;for(var a=[],i=e;i<u.length;i++){var m=u[i];if(m.getVisible()&&(a.push(m),a.length===o))break}for(var d=[],i=0;i<a.length;i++){var s=a[i];s.getResizable()&&d.push(s)}if(0===d.length)return!1;for(var g=0,i=0;i<a.length;i++){var s=a[i];g+=r.getColumnWidth(n,s.getIndex())}var f=t-g,C=Math.round(f/d.length),v=!1,h=n.getDomRef();r.TableUtils.isFixedColumn(n,e)||n._getVisibleColumns().forEach(function(n){var e,t=n.getWidth();h&&d.indexOf(n)<0&&r.TableUtils.isVariableWidth(t)&&(e=h.querySelector('th[data-sap-ui-colid=\"'+n.getId()+'\"]'))&&(n._minWidth=Math.max(e.offsetWidth,r.getMinColumnWidth()))});for(var i=0;i<d.length;i++){var c=d[i],p=r.getColumnWidth(n,c.getIndex()),I=p+C,x=r.getMinColumnWidth();I<x&&(I=x);var M=I-p;if(Math.abs(M)<Math.abs(C)){var b=d.length-(i+1);f-=M,C=Math.round(f/b)}if(0!==M){var _=!0,S=I+\"px\";l&&(_=n.fireColumnResize({column:c,width:S})),_&&(c.setWidth(S),v=!0)}}return v},getColumnWidth:function(n,e){if(null==n||null==e||e<0)return null;var t=n.getColumns();if(e>=t.length)return null;var r=t[e],l=r.getWidth();if(\"\"===l||\"auto\"===l||l.match(/%$/)){if(r.getVisible()){var o=r.getDomRef();return null!=o?o.offsetWidth:0}return 0}return n._CSSSizeToPixel(l)},getFixedColumnCount:function(n,e){var t=n.getFixedColumnCount();if(!e)return t;if(t<=0||n._bIgnoreFixedColumnCount)return 0;var r=n.getColumns(),l=0;t=Math.min(t,r.length);for(var o=0;o<t;o++)r[o].shouldRender()&&l++;return l}};return r},!0);",
	"sap/ui/table/TableDragAndDropExtension.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"./TableExtension\",\"sap/ui/table/TableUtils\"],function(t,e){\"use strict\";var n={getSessionData:function(t,e){return t.getComplexData(\"sap.ui.table\"+(null==e?\"\":\"-\"+e))},setSessionData:function(t,e,n){t.setComplexData(\"sap.ui.table\"+(null==n?\"\":\"-\"+n),e)},getInstanceSessionData:function(t,e){return this.getSessionData(t,e.getId())},setInstanceSessionData:function(t,e,n){this.setSessionData(t,n,e.getId())}},l={ondragstart:function(t){var l=t.dragSession;if(null!=l&&null!=l.draggedControl){var a=l.draggedControl,o={};if(e.isInstanceOf(a,\"sap/ui/table/Row\")){var i=this.getContextByIndex(a.getIndex()),s=a.getDomRef();if(null==i||s.classList.contains(\"sapUiTableGroupHeader\")||s.classList.contains(\"sapUiAnalyticalTableSum\"))return void t.preventDefault();o.draggedRowContext=i}if(e.isInstanceOf(a,\"sap/ui/table/Column\"))return void t.preventDefault();n.setInstanceSessionData(l,this,o)}},ondragenter:function(t){var l=t.dragSession;if(null!=l&&null!=l.dropControl){var a=n.getInstanceSessionData(l,this),o=l.draggedControl,i=l.dropControl;if(null==a&&(a={}),e.isInstanceOf(i,\"sap/ui/table/Row\")){var s=a.draggedRowContext,r=this.getContextByIndex(i.getIndex()),g=i.getDomRef(),u=0===this._getTotalRowCount();if(null==r&&!u||null!=s&&s===r||g.classList.contains(\"sapUiTableGroupHeader\")||g.classList.contains(\"sapUiAnalyticalTableSum\"))t.preventDefault();else{var d=this._getScrollExtension().isVerticalScrollbarVisible(),c=this.getDomRef(\"sapUiTableCnt\").getBoundingClientRect();a.indicatorSize={width:c.width-(d?16:0),left:c.left+(this._bRtlMode&&d?16:0)}}}else e.isInstanceOf(i,\"sap/ui/table/Column\")?t.preventDefault():o===i?t.preventDefault():delete a.indicatorSize;if(null==a.verticalScrollEdge){var f=window.pageYOffset,p=this.getDomRef(\"table\").getBoundingClientRect();a.verticalScrollEdge={bottom:p.bottom+f,top:p.top+f}}var h=window.pageXOffset,v=this.getDomRef(\"sapUiTableCtrlScr\").getBoundingClientRect();a.horizontalScrollEdge={left:v.left+h,right:v.right+h},n.setInstanceSessionData(l,this,a)}},ondragover:function(t){var e=t.dragSession;if(null!=e){var l=n.getInstanceSessionData(e,this);if(null!=l){var a=e.dropControl,o=jQuery(e.getIndicator()),i=this._getScrollExtension(),s=i.getVerticalScrollbar(),r=i.getHorizontalScrollbar(),g=l.verticalScrollEdge,u=l.horizontalScrollEdge,d=l.indicatorSize;if(null!=g&&null!=s&&a!==this){var c=t.pageY;c>=g.top-50&&c<=g.top+50?s.scrollTop-=32:c<=g.bottom+50&&c>=g.bottom-50&&(s.scrollTop+=32)}if(null!=u&&null!=r&&a!==this){var f=t.pageX;f>=u.left-50&&f<=u.left+50?r.scrollLeft-=32:f<=u.right+50&&f>=u.right-50&&(r.scrollLeft+=32)}null!=o&&null!=d&&null!=a&&o.css(d)}}},onlongdragover:function(t){var n=t.dragSession;if(null!=n){var l=e.getCell(this,t.target),a=e.getCellInfo(l).rowIndex,o=null==a?null:this.getRows()[a],i=n.dropControl;null==o||i!=o&&null!=i||e.Grouping.toggleGroupHeader(this,o.getIndex(),!0)}}};return t.extend(\"sap.ui.table.TableDragAndDropExtension\",{_init:function(t,e,n){return this._oDelegate=l,t.addEventDelegate(this._oDelegate,t),\"DragAndDropExtension\"},_debug:function(){this._ExtensionDelegate=l},destroy:function(){var e=this.getTable();e&&e.removeEventDelegate(this._oDelegate),this._oDelegate=null,t.prototype.destroy.apply(this,arguments)}})});",
	"sap/ui/table/TableExtension.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"sap/ui/base/Object\",\"./TableUtils\"],function(t,n){\"use strict\";var e=t.extend(\"sap.ui.table.TableExtension\",{_table:null,_type:null,_settings:null,constructor:function(s,i){t.call(this),this._table=s,this._settings=i||{},this._type=e.TABLETYPES.STANDARD,n.isInstanceOf(s,\"sap/ui/table/TreeTable\")?this._type=e.TABLETYPES.TREE:n.isInstanceOf(s,\"sap/ui/table/AnalyticalTable\")&&(this._type=e.TABLETYPES.ANALYTICAL);var a=this._init(this._table,this._type,this._settings);if(a){var o=this;s[\"_get\"+a]=function(){return o}}},destroy:function(){this._table=null,this._type=null,this.bIsDestroyed=!0,t.prototype.destroy.apply(this,arguments)},getInterface:function(){return this}});return e.TABLETYPES={TREE:\"TREE\",ANALYTICAL:\"ANALYTICAL\",STANDARD:\"STANDARD\"},e.prototype.getTable=function(){return this._table},e.prototype._init=function(t,n,e){return null},e.prototype._attachEvents=function(){},e.prototype._detachEvents=function(){},e.attachEvents=function(t){if(t._aExtensions)for(var n=0;n<t._aExtensions.length;n++)t._aExtensions[n]._attachEvents()},e.detachEvents=function(t){if(t._aExtensions)for(var n=0;n<t._aExtensions.length;n++)t._aExtensions[n]._detachEvents()},e.enrich=function(t,n,s){if(!(n&&n.prototype instanceof e))return null;var i=new n(t,s);return t._aExtensions||(t._aExtensions=[]),t._aExtensions.push(i),i},e.cleanup=function(t){if(t._bExtensionsInitialized&&t._aExtensions){for(var n=0;n<t._aExtensions.length;n++)t._aExtensions[n].destroy();delete t._aExtensions,delete t._bExtensionsInitialized}},e});",
	"sap/ui/table/TableGrouping.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/core/Element\",\"sap/ui/model/Sorter\",\"sap/ui/Device\",\"./library\"],function(e,n,o,r,t){\"use strict\";var a={TableUtils:null,clearMode:function(e){e._mode=null},setGroupMode:function(e){e._mode=\"Group\"},isGroupMode:function(e){return\"Group\"==e._mode},setTreeMode:function(e){e._mode=\"Tree\"},isTreeMode:function(e){return\"Tree\"==e._mode},getModeCssClass:function(e){return e._mode?\"sapUiTable\"+e._mode+\"Mode\":null},showGroupMenuButton:function(e){return!0===e._bShowGroupMenuButton||!1===e._bShowGroupMenuButton?e._bShowGroupMenuButton:(!r.system.desktop&&a.TableUtils.isInstanceOf(e,\"sap/ui/table/AnalyticalTable\")?e._bShowGroupMenuButton=!0:e._bShowGroupMenuButton=!1,e._bShowGroupMenuButton)},toggleGroupHeader:function(e,n,o){var r=[],t=null!=e?e.getBinding(\"rows\"):null;if(null==e||null==t||null==t.expand||null==n)return null;if(\"number\"==typeof n)r=[n];else if(Array.isArray(n)){if(null==o&&n.length>1)return null;r=n}var a=e._getTotalRowCount(!0),i=r.filter(function(e){var n=t.isExpanded(e),r=!0;return null!=t.nodeHasChildren&&(r=null!=t.getNodeByIndex&&!t.nodeHasChildren(t.getNodeByIndex(e))),e>=0&&e<a&&!r&&o!==n}).sort();if(0===i.length)return null;for(var l=i.length-1;l>0;l--)o?t.expand(i[l],!0):t.collapse(i[l],!0);return!0===o?t.expand(i[0],!1):!1===o?t.collapse(i[0],!1):t.toggleIndex(i[0]),t.isExpanded(i[0])},toggleGroupHeaderByRef:function(n,o,r){var t,i=e(o);t=i.hasClass(\"sapUiTableTreeIcon\")||a.isTreeMode(n)&&i.hasClass(\"sapUiTableTdFirst\")?i.closest(\"tr\",n.getDomRef()):i.closest(\".sapUiTableGroupHeader\",n.getDomRef());var l=n.getBinding(\"rows\");if(t.length>0&&l){var s=t.data(\"sap-ui-rowindex\"),u=n.getRows()[s];if(null!=u){var d=u.getIndex(),p=a.toggleGroupHeader(n,d,r),g=!0===p||!1===p;return g&&n._onGroupHeaderChanged&&n._onGroupHeaderChanged(d,p),g}}return!1},isInGroupingRow:function(e){var n=a.TableUtils.getCellInfo(e);return n.isOfType(a.TableUtils.CELLTYPE.DATACELL)?n.cell.parent().hasClass(\"sapUiTableGroupHeader\"):!!n.isOfType(a.TableUtils.CELLTYPE.ROWHEADER|a.TableUtils.CELLTYPE.ROWACTION)&&n.cell.hasClass(\"sapUiTableGroupHeader\")},isGroupingRow:function(n){return!!n&&e(n).hasClass(\"sapUiTableGroupHeader\")},isInSumRow:function(e){var n=a.TableUtils.getCellInfo(e);return n.isOfType(a.TableUtils.CELLTYPE.DATACELL)?n.cell.parent().hasClass(\"sapUiAnalyticalTableSum\"):!!n.isOfType(a.TableUtils.CELLTYPE.ROWHEADER|a.TableUtils.CELLTYPE.ROWACTION)&&n.cell.hasClass(\"sapUiAnalyticalTableSum\")},_calcGroupIndent:function(e,n,o,r){if(a.TableUtils.isInstanceOf(e,\"sap/ui/table/TreeTable\")){for(var t=0,i=0;i<n;i++)t+=i<2?12:8;return t}if(a.TableUtils.isInstanceOf(e,\"sap/ui/table/AnalyticalTable\")){var t=0;n-=1,n=o||r?n:n-1,n=Math.max(n,0);for(var i=0;i<n;i++)0==t&&(t=12),t+=i<2?12:8;return t}var t=0;n=o?n:n-1,n=Math.max(n,0);for(var i=0;i<n;i++)t+=i<2?12:8;return t},_setIndent:function(e,n,o,r){var t=e._bRtlMode,a=n.find(\"td.sapUiTableTdFirst > .sapUiTableCell\"),i=o.find(\".sapUiTableGroupShield\");r<=0?(o.css(t?\"right\":\"left\",\"\"),i.css(\"width\",\"\").css(t?\"margin-right\":\"margin-left\",\"\"),a.css(t?\"padding-right\":\"padding-left\",\"\")):(o.css(t?\"right\":\"left\",r+\"px\"),i.css(\"width\",r+\"px\").css(t?\"margin-right\":\"margin-left\",-1*r+\"px\"),a.css(t?\"padding-right\":\"padding-left\",r+8+\"px\"))},updateTableRowForGrouping:function(n,o,r,t,i,l,s,u){var d=o.getDomRefs(!0),p=d.row,g=d.rowScrollPart,f=d.rowFixedPart,c=d.rowSelector,T=d.rowAction;p.attr({\"data-sap-ui-level\":s}),p.data(\"sap-ui-level\",s),a.isGroupMode(n)&&(p.toggleClass(\"sapUiAnalyticalTableSum\",!r&&l).toggleClass(\"sapUiAnalyticalTableDummy\",!1).toggleClass(\"sapUiTableGroupHeader\",r).toggleClass(\"sapUiTableRowHidden\",r&&i||o._bHidden),e.sap.byId(o.getId()+\"-groupHeader\").toggleClass(\"sapUiTableGroupIconOpen\",r&&t).toggleClass(\"sapUiTableGroupIconClosed\",r&&!t).attr(\"title\",n._getShowStandardTooltips()&&u?u:null).text(u||\"\"),a._setIndent(n,p,c,a._calcGroupIndent(n,s,r,l)));var _=null;if(a.isTreeMode(n)&&(_=p.find(\".sapUiTableTreeIcon\"),_.css(n._bRtlMode?\"margin-right\":\"margin-left\",17*s+\"px\").toggleClass(\"sapUiTableTreeIconLeaf\",!r).toggleClass(\"sapUiTableTreeIconNodeOpen\",r&&t).toggleClass(\"sapUiTableTreeIconNodeClosed\",r&&!t)),a.showGroupMenuButton(n)){var b=0,h=n.$();h.hasClass(\"sapUiTableVScr\")&&(b+=h.find(\".sapUiTableVSb\").width());var C=c.find(\".sapUiTableGroupMenuButton\");n._bRtlMode?C.css(\"right\",h.width()-C.width()+c.position().left-b-5+\"px\"):C.css(\"left\",h.width()-C.width()-c.position().left-b-5+\"px\")}n._getAccExtension().updateAriaExpandAndLevelState(o,g,c,f,T,r,t,s,_)},cleanupTableRowForGrouping:function(e,n){var o=n.getDomRefs(!0);o.row.removeAttr(\"data-sap-ui-level\"),o.row.removeData(\"sap-ui-level\"),a.isGroupMode(e)&&(o.row.removeClass(\"sapUiTableGroupHeader sapUiAnalyticalTableSum sapUiAnalyticalTableDummy\"),a._setIndent(e,o.row,o.rowSelector,0));var r=null;a.isTreeMode(e)&&(r=o.row.find(\".sapUiTableTreeIcon\"),r.removeClass(\"sapUiTableTreeIconLeaf\").removeClass(\"sapUiTableTreeIconNodeOpen\").removeClass(\"sapUiTableTreeIconNodeClosed\").css(this._bRtlMode?\"margin-right\":\"margin-left\",\"\")),e._getAccExtension().updateAriaExpandAndLevelState(n,o.rowScrollPart,o.rowSelector,o.rowFixedPart,o.rowAction,!1,!1,-1,r)},updateGroups:function(e){if(a.isGroupMode(e)||a.isTreeMode(e)){var n=e.getBinding(\"rows\"),o=e.getBindingInfo(\"rows\"),r=e.getRows(),t=r.length;if(n)for(var i,l=0;l<t;l++)i=a._getRowGroupInfo(e,r[l],n,o),a.updateTableRowForGrouping(e,r[l],i.isHeader,i.expanded,i.hidden,!1,i.level,i.title);else for(var l=0;l<t;l++)a.cleanupTableRowForGrouping(e,r[l])}},_getRowGroupInfo:function(e,n,o,r){var t={isHeader:!1,expanded:!1,hidden:!1,title:\"\",level:0};if(e.getGroupHeaderProperty){t.isHeader=n._bHasChildren,t.expanded=n._bIsExpanded,t.hidden=t.isHeader,t.level=n._iLevel;var i=e.getGroupHeaderProperty();if(a.isGroupMode(e)&&i){var l=r&&r.model;t.title=e.getModel(l).getProperty(i,n.getBindingContext(l))}}else{var s=n.getIndex();t.isHeader=!!o.isGroupHeader(s),t.level=t.isHeader?0:1,t.isHeader&&(t.expanded=!!o.isExpanded(s),t.hidden=!0,t.title=o.getTitle(s))}return t},setupExperimentalGrouping:function(r){if(r.getEnableGrouping()){var t=n.prototype.getBinding.call(r,\"rows\"),i=sap.ui.getCore().byId(r.getGroupBy());if(i&&i.getGrouped()&&t&&a.TableUtils.isInstanceOf(t,\"sap/ui/model/ClientListBinding\")&&!t._modified){t._modified=!0,a.setGroupMode(r);var l=i.getSortProperty();t.sort(new o(l));for(var s,u=r._getTotalRowCount(),d=t.getContexts(0,u),p=0,g=u-1;g>=0;g--){var f=d[g].getProperty(l);if(s||(s=f),s!==f){var c=d[g+1].getModel().getContext(\"/sap.ui.table.GroupInfo\"+g);c.__groupInfo={oContext:d[g+1],name:s,count:p,groupHeader:!0,expanded:!0},d.splice(g+1,0,c),s=f,p=0}p++}var c=d[0].getModel().getContext(\"/sap.ui.table.GroupInfo\");c.__groupInfo={oContext:d[0],name:s,count:p,groupHeader:!0,expanded:!0},d.splice(0,0,c),e.extend(t,{getLength:function(){return d.length},getContexts:function(e,n){return d.slice(e,e+n)},isGroupHeader:function(e){var n=d[e];return!0===(n&&n.__groupInfo&&n.__groupInfo.groupHeader)},getTitle:function(e){var n=d[e];return n&&n.__groupInfo&&n.__groupInfo.name+\" - \"+n.__groupInfo.count},isExpanded:function(e){var n=d[e];return this.isGroupHeader(e)&&n.__groupInfo&&n.__groupInfo.expanded},expand:function(e){if(this.isGroupHeader(e)&&!d[e].__groupInfo.expanded){for(var n=0;n<d[e].__childs.length;n++)d.splice(e+1+n,0,d[e].__childs[n]);delete d[e].__childs,d[e].__groupInfo.expanded=!0,this._fireChange()}},collapse:function(e){this.isGroupHeader(e)&&d[e].__groupInfo.expanded&&(d[e].__childs=d.splice(e+1,d[e].__groupInfo.count),d[e].__groupInfo.expanded=!1,this._fireChange())},toggleIndex:function(e){this.isExpanded(e)?this.collapse(e):this.expand(e)},nodeHasChildren:function(e){return null!=e&&null!=e.__groupInfo&&!0===e.__groupInfo.groupHeader},getNodeByIndex:function(e){return d[e]}}),r._mTimeouts.groupingFireBindingChange=r._mTimeouts.groupingFireBindingChange||window.setTimeout(function(){t._fireChange()},0)}}},resetExperimentalGrouping:function(e){var n=e.getBinding(\"rows\");if(n&&n._modified){a.clearMode(e);var o=e.getBindingInfo(\"rows\");e.unbindRows(),e.bindRows(o)}}};return a},!0);",
	"sap/ui/table/TableKeyboardDelegate2.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/base/Object\",\"sap/ui/Device\",\"./library\",\"./TableUtils\",\"jquery.sap.keycodes\"],function(e,t,o,i,n){\"use strict\";function s(e,t){e.setMarked(\"sapUiTableSkipItemNavigation\",!1!==t)}var l=n.CELLTYPE,r=i.SelectionMode,a={CTRL:1,SHIFT:2,ALT:4},u={LEFT:\"Left\",RIGHT:\"Right\",UP:\"Up\",DOWN:\"Down\"},f=t.extend(\"sap.ui.table.TableKeyboardDelegate2\",{constructor:function(e){t.call(this)},destroy:function(){t.prototype.destroy.apply(this,arguments)},getInterface:function(){return this}});return f._restoreFocusOnLastFocusedDataCell=function(e,t){var o=n.getFocusedItemInfo(e),i=e._getKeyboardExtension()._getLastFocusedCellInfo();n.focusItem(e,o.cellInRow+o.columnCount*i.row,t)},f._setFocusOnColumnHeaderOfLastFocusedDataCell=function(e,t){var o=n.getFocusedItemInfo(e);n.focusItem(e,o.cellInRow,t)},f._forwardFocusToTabDummy=function(e,t){e._getKeyboardExtension()._setSilentFocus(e.$().find(\".\"+t))},f._isKeyCombination=function(t,i,n){null==n&&(n=0);var s=\"string\"==typeof i?String.fromCharCode(t.charCode):t.keyCode,l=0;l|=(o.os.macintosh?t.metaKey:t.ctrlKey)&&i!==e.sap.KeyCodes.CONTROL?a.CTRL:0,l|=t.shiftKey&&i!==e.sap.KeyCodes.SHIFT?a.SHIFT:0,l|=t.altKey&&i!==e.sap.KeyCodes.ALT?a.ALT:0;var r=null==i||s===i,u=n===l;return r&&u},f._handleSpaceAndEnter=function(e,t){var o=n.getCellInfo(t.target);if(o.isOfType(l.COLUMNROWHEADER))e._toggleSelectAll();else if(f._isElementGroupToggler(e,t.target))n.Grouping.toggleGroupHeaderByRef(e,t.target);else if(o.isOfType(l.ROWHEADER))n.toggleRowSelection(e,t.target);else if(o.isOfType(l.DATACELL|l.ROWACTION)){var i=!e.hasListeners(\"cellClick\");if(e._findAndfireCellEvent(e.fireCellClick,t)||n.isRowSelectionAllowed(e)&&(n.toggleRowSelection(e,t.target),i=!1),i){var s=f._getInteractiveElements(t.target);null!==s&&e._getKeyboardExtension().setActionMode(!0)}}},f._moveColumn=function(e,t){var o,i=e.getParent(),s=i._getVisibleColumns(),l=s.indexOf(e);t&&l<s.length-1?o=i.indexOfColumn(s[l+1])+1:!t&&l>0&&(o=i.indexOfColumn(s[l-1])),null!=o&&n.Column.moveColumnTo(e,o)},f._getVisibleAndGroupedColumns=function(e){return e.getColumns().filter(function(e){return e.getVisible()||e.getGrouped()})},f._getColumnIndexInVisibleAndGroupedColumns=function(e,t){for(var o=f._getVisibleAndGroupedColumns(e),i=0;i<o.length;i++){if(o[i]===t)return i}return-1},f._focusElement=function(e,t,o){function i(e){return e instanceof window.HTMLInputElement&&/^(text|password|search|tel|url)$/.test(e.type)}null!=e&&null!=t&&(null==o&&(o=!1),i(document.activeElement)&&document.activeElement.setSelectionRange(0,0),o?e._getKeyboardExtension()._setSilentFocus(t):t.focus(),i(t)&&t.select())},f._focusCell=function(e,t,o,i,s){if(!(null==e||null==t||null==o||o<0||o>=e.getRows().length)){var r,a=e.getRows()[o];if(t===l.ROWHEADER)return void e._getKeyboardExtension()._setFocus(e.getDomRef(\"rowsel\"+o));if(t===l.ROWACTION)r=e.getDomRef(\"rowact\"+o);else if(t===l.DATACELL&&null!=i&&i>=0){var u=e.getColumns()[i],g=f._getColumnIndexInVisibleAndGroupedColumns(e,u);g>=0&&g<n.getVisibleColumnCount(e)&&(r=a.getDomRef(\"col\"+g))}if(null!=r){if(s){var c=f._getInteractiveElements(r);if(null!=c)return void f._focusElement(e,c[0])}r.focus()}}},f._navigate=function(e,t,o){if(!t.isMarked()){var i=e._getKeyboardExtension(),r=i.isInActionMode(),g=n.getCellInfo(n.getCell(e,t.target)),c=!1;if(o!==u.UP&&o!==u.DOWN||!g.isOfType(l.ANYCONTENTCELL)){if(o===u.DOWN&&g.isOfType(l.ANYCOLUMNHEADER)){var p=n.getHeaderRowCount(e);if(n.isNoDataVisible(e)){var C=n.getFocusedItemInfo(e);C.row-p<=1&&s(t)}else g.isOfType(l.COLUMNROWHEADER)&&p>1&&(s(t),n.focusItem(e,p*(n.getVisibleColumnCount(e)+1),t))}else if(o===u.LEFT&&!r){var h=sap.ui.getCore().getConfiguration().getRTL();if(g.isOfType(l.COLUMNHEADER)&&h){var d=n.getFocusedItemInfo(e),m=d.cellInRow-(n.hasRowHeader(e)?1:0),I=n.getVisibleColumnCount(e);n.hasRowActions(e)&&m===I-1&&s(t)}}}else{var E=f._isKeyCombination(t,null,a.CTRL),R=E||r,y=n.getParentCell(e,t.target);if(!E&&(t.target instanceof window.HTMLInputElement||t.target instanceof window.HTMLTextAreaElement))return;if(!R&&null!=y)return void y.focus();if(s(t),o===u.UP?n.isFirstScrollableRow(e,g.cell)&&(c=e._getScrollExtension().scrollVertically(!1,!1,!0)):n.isLastScrollableRow(e,g.cell)&&(c=e._getScrollExtension().scrollVertically(!0,!1,!0)),c)t.preventDefault(),R&&e.attachEventOnce(\"_rowsUpdated\",function(){setTimeout(function(){f._focusCell(e,g.type,g.rowIndex,g.columnIndex,!0)},0)});else if(o===u.UP&&0===g.rowIndex)s(t,g.isOfType(l.ROWACTION)||R),r||null==y?i.setActionMode(!1):y.focus();else if(o===u.DOWN&&g.rowIndex===e.getVisibleRowCount()-1)r||null==y?i.setActionMode(!1):y.focus();else{var T=o===u.DOWN?1:-1;f._focusCell(e,g.type,g.rowIndex+T,g.columnIndex,R),t.preventDefault()}}}},f._isElementGroupToggler=function(e,t){return n.Grouping.isInGroupingRow(t)||n.Grouping.isTreeMode(e)&&t.classList.contains(\"sapUiTableTdFirst\")&&(null!=t.querySelector(\".sapUiTableTreeIconNodeOpen\")||null!=t.querySelector(\".sapUiTableTreeIconNodeClosed\"))||t.classList.contains(\"sapUiTableTreeIconNodeOpen\")||t.classList.contains(\"sapUiTableTreeIconNodeClosed\")},f._isElementInteractive=function(t){return null!=t&&e(t).is(\":sapTabbable, input:sapFocusable, .sapUiTableTreeIcon:not(.sapUiTableTreeIconLeaf)\")},f._getInteractiveElements=function(t){if(null==t)return null;var o=e(t);if(n.getCellInfo(o).isOfType(l.DATACELL|l.ROWACTION)){var i=o.find(\":sapTabbable, input:sapFocusable, .sapUiTableTreeIcon:not(.sapUiTableTreeIconLeaf)\");if(i.length>0)return i}return null},f._getFirstInteractiveElement=function(e){if(null==e)return null;var t,o,i=e.getParent(),s=e.getCells();n.hasRowActions(i)&&s.push(e.getAggregation(\"_rowAction\"));for(var l=0;l<s.length;l++)if(t=n.getParentCell(i,s[l].getDomRef()),null!==(o=this._getInteractiveElements(t)))return o.first();return null},f._getLastInteractiveElement=function(e){if(null==e)return null;var t,o,i=e.getParent(),s=e.getCells();n.hasRowActions(i)&&s.push(e.getAggregation(\"_rowAction\"));for(var l=s.length-1;l>=0;l--)if(t=n.getParentCell(i,s[l].getDomRef()),null!==(o=this._getInteractiveElements(t)))return o.last();return null},f._getPreviousInteractiveElement=function(t,o){if(null==t||null==o)return null;var i=e(o);if(!this._isElementInteractive(i))return null;var s,r,a,u,g,c,p,C=n.getParentCell(t,o);if(s=this._getInteractiveElements(C),s[0]!==i[0])return s.eq(s.index(o)-1);r=n.getCellInfo(C),u=t.getRows()[r.rowIndex].getCells(),r.isOfType(l.ROWACTION)?p=u.length-1:(g=t.getColumns()[r.columnIndex],c=f._getColumnIndexInVisibleAndGroupedColumns(t,g),p=c-1);for(var h=p;h>=0;h--)if(a=u[h].getDomRef(),C=n.getParentCell(t,a),null!==(s=this._getInteractiveElements(C)))return s.last();return null},f._getNextInteractiveElement=function(t,o){if(null==t||null==o)return null;var i=e(o);if(!this._isElementInteractive(i))return null;var s,r,a,u,g,c,p,C=n.getParentCell(t,o);if(s=this._getInteractiveElements(C),s.get(-1)!==i[0])return s.eq(s.index(o)+1);if(r=n.getCellInfo(C),r.isOfType(l.ROWACTION))return null;c=t.getRows()[r.rowIndex],u=c.getCells(),g=t.getColumns()[r.columnIndex],p=f._getColumnIndexInVisibleAndGroupedColumns(t,g);for(var h=p+1;h<u.length;h++)if(a=u[h].getDomRef(),C=n.getParentCell(t,a),null!==(s=this._getInteractiveElements(C)))return s.first();return n.hasRowActions(t)&&(C=n.getParentCell(t,c.getAggregation(\"_rowAction\").getDomRef()),s=this._getInteractiveElements(C),s.get(-1)!==i[0])?s.eq(s.index(o)+1):null},f.prototype.enterActionMode=function(){var e=this._getKeyboardExtension(),t=document.activeElement,o=f._getInteractiveElements(t),i=n.getParentCell(this,t);return null!==o?(e._suspendItemNavigation(),t.tabIndex=-1,f._focusElement(this,o[0],!0),!0):null!==i&&(this._getKeyboardExtension()._suspendItemNavigation(),!0)},f.prototype.leaveActionMode=function(e){e=null==e||e;var t=this._getKeyboardExtension(),o=document.activeElement,i=n.getParentCell(this,o);t._resumeItemNavigation(),e&&(null!==i?f._focusElement(this,i[0],!0):t._setSilentFocus(o))},f.prototype.onfocusin=function(t){if(!t.isMarked(\"sapUiTableIgnoreFocusIn\")){var o=e(t.target);if(o.hasClass(\"sapUiTableOuterBefore\")||o.hasClass(\"sapUiTableOuterAfter\")||t.target!=this.getDomRef(\"overlay\")&&this.getShowOverlay())this.$(\"overlay\").focus();else if(o.hasClass(\"sapUiTableCtrlBefore\")){var i=n.isNoDataVisible(this);!i||i&&this.getColumnHeaderVisible()?f._setFocusOnColumnHeaderOfLastFocusedDataCell(this,t):this._getKeyboardExtension()._setSilentFocus(this.$(\"noDataCnt\"))}else o.hasClass(\"sapUiTableCtrlAfter\")&&(n.isNoDataVisible(this)||f._restoreFocusOnLastFocusedDataCell(this,t));var s=n.getParentCell(this,o),r=null!==s,a=r&&f._isElementInteractive(o);if(this._getKeyboardExtension().isInActionMode()){var u=n.getCellInfo(t.target),g=null!=u.cell,c=u.isOfType(l.ROWHEADER)&&n.Grouping.isInGroupingRow(t.target),p=u.isOfType(l.ROWHEADER)&&!c&&n.isRowSelectorSelectionAllowed(this);!g||c||p?r&&!a&&this._getKeyboardExtension().setActionMode(!1,!1):this._getKeyboardExtension().setActionMode(!1)}else a&&this._getKeyboardExtension().setActionMode(!0)}},f.prototype.onkeydown=function(t){var o=this._getKeyboardExtension();if(f._isKeyCombination(t,e.sap.KeyCodes.F2)){var i=o.isInActionMode(),s=n.getParentCell(this,t.target);return void(i||null==s?o.setActionMode(!i):s.focus())}if(f._isKeyCombination(t,e.sap.KeyCodes.F4)&&f._isElementGroupToggler(this,t.target))return void n.Grouping.toggleGroupHeaderByRef(this,t.target);if(!this._getKeyboardExtension().isInActionMode()){f._isKeyCombination(t,e.sap.KeyCodes.SPACE)&&n.getCellInfo(t.target).type&&t.preventDefault();var u=e(t.target),g=n.getCellInfo(u),c=this.getSelectionMode();if(f._isKeyCombination(t,e.sap.KeyCodes.SHIFT)&&c===r.MultiToggle&&(g.isOfType(l.ROWHEADER)&&n.isRowSelectorSelectionAllowed(this)||g.isOfType(l.DATACELL|l.ROWACTION)&&n.isRowSelectionAllowed(this))){var p=n.getRowIndexOfFocusedCell(this),C=this.getRows()[p].getIndex();this._oRangeSelection={startIndex:C,selected:this.isIndexSelected(C)}}else f._isKeyCombination(t,e.sap.KeyCodes.A,a.CTRL)?(t.preventDefault(),g.isOfType(l.ANYCONTENTCELL|l.COLUMNROWHEADER)&&c===r.MultiToggle&&this._toggleSelectAll()):f._isKeyCombination(t,e.sap.KeyCodes.A,a.CTRL+a.SHIFT)?g.isOfType(l.ANYCONTENTCELL|l.COLUMNROWHEADER)&&this.clearSelection():f._isKeyCombination(t,e.sap.KeyCodes.F4)?g.isOfType(l.DATACELL)&&o.setActionMode(!0):f._isKeyCombination(t,e.sap.KeyCodes.F10,a.SHIFT)&&(t.preventDefault(),n.Menu.openContextMenu(this,t.target,!0,null,t))}},f.prototype.onkeypress=function(e){var t=this._getKeyboardExtension(),o=n.getCellInfo(e.target);f._isKeyCombination(e,\"+\")?f._isElementGroupToggler(this,e.target)?n.Grouping.toggleGroupHeaderByRef(this,e.target,!0):o.isOfType(l.DATACELL|l.ROWACTION)&&t.setActionMode(!0):f._isKeyCombination(e,\"-\")&&(f._isElementGroupToggler(this,e.target)?n.Grouping.toggleGroupHeaderByRef(this,e.target,!1):o.isOfType(l.DATACELL|l.ROWACTION)&&t.setActionMode(!0))},f.prototype.oncontextmenu=function(e){if(!e.isMarked(\"handledByPointerExtension\")){e.preventDefault();var t=n.getCell(this,e.target);n.getCellInfo(t).isOfType(l.COLUMNHEADER|l.ANYCONTENTCELL)&&n.Menu.openContextMenu(this,e.target,!0,null,e)}},f.prototype.onkeyup=function(t){var o=n.getCellInfo(t.target);f._isKeyCombination(t,e.sap.KeyCodes.SHIFT)&&delete this._oRangeSelection,f._isKeyCombination(t,e.sap.KeyCodes.SPACE)&&(o.isOfType(l.COLUMNHEADER)?n.Menu.openContextMenu(this,t.target,!0):f._handleSpaceAndEnter(this,t)),f._isKeyCombination(t,e.sap.KeyCodes.ENTER)&&o.isOfType(l.COLUMNHEADER)&&n.Menu.openContextMenu(this,t.target,!0)},f.prototype.onsaptabnext=function(e){var t,o=this._getKeyboardExtension(),i=n.getCellInfo(e.target);if(o.isInActionMode()){var s;if(t=n.getCell(this,e.target),i=n.getCellInfo(t),null===t)return;var r=this.getRows()[i.rowIndex],a=f._getLastInteractiveElement(r);if(null===a||a[0]===e.target){var u=r.getIndex(),g=n.isLastScrollableRow(this,t),c=this._getTotalRowCount()-1===u,p=n.isRowSelectorSelectionAllowed(this),C=!1;if(!c&&g&&(C=this._getScrollExtension().scrollVertically(!0,null,!0)),c)e.preventDefault(),o.setActionMode(!1);else if(C)e.preventDefault(),this.attachEventOnce(\"_rowsUpdated\",function(){setTimeout(function(){var e=n.Grouping.isGroupingRow(r.getDomRef());p||e?f._focusCell(this,l.ROWHEADER,i.rowIndex):(s=f._getFirstInteractiveElement(r),f._focusElement(this,s[0]))}.bind(this),0)}.bind(this));else{e.preventDefault();var h=i.rowIndex+1,d=this.getRows()[h],m=n.Grouping.isGroupingRow(d.getDomRef());p||m?f._focusCell(this,l.ROWHEADER,h):(s=f._getFirstInteractiveElement(d),f._focusElement(this,s[0]))}}else i.isOfType(l.ROWHEADER)?(e.preventDefault(),s=f._getFirstInteractiveElement(r),f._focusElement(this,s[0])):(e.preventDefault(),s=f._getNextInteractiveElement(this,e.target),f._focusElement(this,s[0]))}else i.isOfType(l.ANYCOLUMNHEADER)?(n.isNoDataVisible(this)?this.$(\"noDataCnt\").focus():f._restoreFocusOnLastFocusedDataCell(this,e),e.preventDefault()):i.isOfType(l.ANYCONTENTCELL)?f._forwardFocusToTabDummy(this,\"sapUiTableCtrlAfter\"):e.target===this.getDomRef(\"overlay\")?o._setSilentFocus(this.$().find(\".sapUiTableOuterAfter\")):null===i.cell&&null!==(t=n.getParentCell(this,e.target))&&(e.preventDefault(),t.focus())},f.prototype.onsaptabprevious=function(e){var t,o=this._getKeyboardExtension(),i=n.getCellInfo(e.target);if(o.isInActionMode()){var s;if(t=n.getCell(this,e.target),i=n.getCellInfo(t),null===t)return;var r=this.getRows()[i.rowIndex],a=r.getIndex(),u=f._getFirstInteractiveElement(r),g=null!==u&&u[0]===e.target,c=n.isRowSelectorSelectionAllowed(this),p=n.Grouping.isGroupingRow(r),C=c||p;if(g&&C)e.preventDefault(),f._focusCell(this,l.ROWHEADER,i.rowIndex);else if(g&&!C||i.isOfType(l.ROWHEADER)){var h=n.isFirstScrollableRow(this,t),d=0===a,m=!1;if(!d&&h&&(m=this._getScrollExtension().scrollVertically(!1,null,!0)),d)e.preventDefault(),o.setActionMode(!1);else if(m)e.preventDefault(),this.attachEventOnce(\"_rowsUpdated\",function(){setTimeout(function(){n.Grouping.isGroupingRow(r.getDomRef())?f._focusCell(this,l.ROWHEADER,i.rowIndex):(s=f._getLastInteractiveElement(r),f._focusElement(this,s[0]))}.bind(this),0)}.bind(this));else{e.preventDefault();var I=i.rowIndex-1,E=this.getRows()[I],R=n.Grouping.isGroupingRow(E.getDomRef());R?f._focusCell(this,l.ROWHEADER,I):(s=f._getLastInteractiveElement(E),f._focusElement(this,s[0]))}}else e.preventDefault(),s=f._getPreviousInteractiveElement(this,e.target),f._focusElement(this,s[0])}else i.isOfType(l.ANYCONTENTCELL)||e.target===this.getDomRef(\"noDataCnt\")?this.getColumnHeaderVisible()&&!i.isOfType(l.ROWACTION)?(f._setFocusOnColumnHeaderOfLastFocusedDataCell(this,e),e.preventDefault()):f._forwardFocusToTabDummy(this,\"sapUiTableCtrlBefore\"):e.target===this.getDomRef(\"overlay\")?this._getKeyboardExtension()._setSilentFocus(this.$().find(\".sapUiTableOuterBefore\")):null===i.cell&&null!==(t=n.getParentCell(this,e.target))&&(e.preventDefault(),t.focus())},f.prototype.onsapdown=function(e){f._navigate(this,e,u.DOWN)},f.prototype.onsapdownmodifiers=function(e){if(f._isKeyCombination(e,null,a.CTRL))return void f._navigate(this,e,u.DOWN);var t=this._getKeyboardExtension();if(f._isKeyCombination(e,null,a.ALT)&&f._isElementGroupToggler(this,e.target))return s(e),void n.Grouping.toggleGroupHeaderByRef(this,e.target,!0);if(!t.isInActionMode()){var o=n.getCellInfo(e.target);if(f._isKeyCombination(e,null,a.SHIFT))if(e.preventDefault(),o.isOfType(l.ANYCONTENTCELL)){if(!this._oRangeSelection)return void s(e);var i=n.getRowIndexOfFocusedCell(this),r=this.getRows()[i].getIndex();if(r===this._getTotalRowCount()-1)return;if(n.isLastScrollableRow(this,e.target)){var g=this._getScrollExtension().scrollVertically(!0,!1,!0);g&&s(e)}this._oRangeSelection.startIndex<=r?(r++,this._oRangeSelection.selected?n.toggleRowSelection(this,r,!0):n.toggleRowSelection(this,r,!1)):n.toggleRowSelection(this,r,!1)}else s(e);f._isKeyCombination(e,null,a.ALT)&&(o.isOfType(l.DATACELL)&&t.setActionMode(!0),s(e))}},f.prototype.onsapup=function(e){f._navigate(this,e,u.UP)},f.prototype.onsapupmodifiers=function(e){var t=this._getKeyboardExtension();if(f._isKeyCombination(e,null,a.CTRL))return void f._navigate(this,e,u.UP);if(f._isKeyCombination(e,null,a.ALT)&&f._isElementGroupToggler(this,e.target))return s(e),void n.Grouping.toggleGroupHeaderByRef(this,e.target,!1);if(!t.isInActionMode()){var o=n.getCellInfo(e.target);if(f._isKeyCombination(e,null,a.SHIFT))if(e.preventDefault(),o.isOfType(l.ANYCONTENTCELL)){if(!this._oRangeSelection)return void s(e);var i=n.getRowIndexOfFocusedCell(this),r=this.getRows()[i].getIndex();if(0===r)return void s(e);if(n.isFirstScrollableRow(this,e.target)){var g=this._getScrollExtension().scrollVertically(!1,!1,!0);g&&s(e)}this._oRangeSelection.startIndex>=r?(r--,this._oRangeSelection.selected?n.toggleRowSelection(this,r,!0):n.toggleRowSelection(this,r,!1)):n.toggleRowSelection(this,r,!1)}else s(e);f._isKeyCombination(e,null,a.ALT)&&(o.isOfType(l.DATACELL)&&t.setActionMode(!0),s(e))}},f.prototype.onsapleft=function(e){f._navigate(this,e,u.LEFT)},f.prototype.onsapleftmodifiers=function(e){if(!this._getKeyboardExtension().isInActionMode()){var t=n.getCellInfo(e.target),o=sap.ui.getCore().getConfiguration().getRTL();if(f._isKeyCombination(e,null,a.SHIFT)){if(e.preventDefault(),t.isOfType(l.DATACELL)){if(!this._oRangeSelection)return void s(e);var i=n.getFocusedItemInfo(this),r=n.hasRowHeader(this)&&1===i.cellInRow;r&&!n.isRowSelectorSelectionAllowed(this)&&s(e)}else if(t.isOfType(l.ROWACTION))this._oRangeSelection||s(e);else if(t.isOfType(l.ROWHEADER)&&o)n.isRowSelectionAllowed(this)||s(e);else if(t.isOfType(l.COLUMNROWHEADER)&&o)s(e);else if(t.isOfType(l.COLUMNHEADER)){var u=-this._CSSSizeToPixel(\"1em\"),g=0;o&&(u*=-1);for(var c=t.columnIndex;c<t.columnIndex+t.columnSpan;c++)g+=n.Column.getColumnWidth(this,c);n.Column.resizeColumn(this,t.columnIndex,g+u,!0,t.columnSpan),s(e)}}else if(f._isKeyCombination(e,null,a.CTRL)&&t.isOfType(l.COLUMNHEADER)){e.preventDefault(),e.stopImmediatePropagation();var p=this.getColumns()[t.columnIndex];f._moveColumn(p,o)}}},f.prototype.onsaprightmodifiers=function(e){if(!this._getKeyboardExtension().isInActionMode()){var t=n.getCellInfo(e.target),o=sap.ui.getCore().getConfiguration().getRTL();if(f._isKeyCombination(e,null,a.SHIFT))if(e.preventDefault(),t.isOfType(l.DATACELL))this._oRangeSelection||s(e);else if(t.isOfType(l.ROWHEADER))n.isRowSelectionAllowed(this)||s(e);else if(t.isOfType(l.ROWACTION)&&o)this._oRangeSelection||s(e);else if(t.isOfType(l.COLUMNHEADER)){var i=this._CSSSizeToPixel(\"1em\"),r=0;o&&(i*=-1);for(var u=t.columnIndex;u<t.columnIndex+t.columnSpan;u++)r+=n.Column.getColumnWidth(this,u);n.Column.resizeColumn(this,t.columnIndex,r+i,!0,t.columnSpan),s(e)}else t.isOfType(l.COLUMNROWHEADER)&&s(e);else if(f._isKeyCombination(e,null,a.CTRL)&&t.isOfType(l.COLUMNHEADER)){e.preventDefault(),e.stopImmediatePropagation();var g=this.getColumns()[t.columnIndex];f._moveColumn(g,!o)}}},f.prototype.onsaphome=function(e){if(!this._getKeyboardExtension().isInActionMode()){if(n.Grouping.isInGroupingRow(e.target))return s(e),void e.preventDefault();var t=n.getCellInfo(e.target);if(t.isOfType(l.ANY)&&e.preventDefault(),t.isOfType(l.DATACELL|l.ROWACTION|l.COLUMNHEADER)){var o=n.getFocusedItemInfo(this),i=o.cell,r=o.cellInRow,a=this.getFixedColumnCount(),u=n.hasRowHeader(this),f=u?1:0;n.hasFixedColumns(this)&&r>a+f?(s(e),n.focusItem(this,i-r+a+f,null)):u&&r>1&&(s(e),n.focusItem(this,i-r+f,null))}}},f.prototype.onsapend=function(e){if(!this._getKeyboardExtension().isInActionMode()){if(n.Grouping.isInGroupingRow(e.target))return e.preventDefault(),void s(e);var t=n.getCellInfo(e.target);if(t.isOfType(l.ANY)){e.preventDefault();var o=n.getFocusedItemInfo(this),i=o.cell,r=o.columnCount,a=this.getFixedColumnCount(),u=o.cellInRow,f=n.hasRowHeader(this),g=f?1:0,c=!1;if(t.isOfType(l.COLUMNHEADER)&&n.hasFixedColumns(this)){var p=parseInt(t.cell.attr(\"colspan\")||1,10);p>1&&u+p-g===a&&(c=!0)}f&&0===u?(s(e),n.focusItem(this,i+1,null)):n.hasFixedColumns(this)&&u<a-1+g&&!c?(s(e),n.focusItem(this,i+a-u,null)):n.hasRowActions(this)&&t.isOfType(l.DATACELL)&&u<r-2&&(s(e),n.focusItem(this,i-u+r-2,null))}}},f.prototype.onsaphomemodifiers=function(e){if(!this._getKeyboardExtension().isInActionMode()&&f._isKeyCombination(e,null,a.CTRL)){e.preventDefault();var t=n.getCellInfo(e.target);if(t.isOfType(l.ANYCONTENTCELL|l.COLUMNHEADER)){s(e);var o=n.getFocusedItemInfo(this),i=o.row;if(i>0){var r=o.cell,u=o.columnCount,g=n.getHeaderRowCount(this),c=this.getFixedRowCount(),p=this.getFixedBottomRowCount();i<g+c?t.isOfType(l.ROWACTION)?n.focusItem(this,r-u*(i-g),e):n.focusItem(this,r-u*i,e):i>=g+c&&i<g+n.getNonEmptyVisibleRowCount(this)-p?(this._getScrollExtension().scrollVerticallyMax(!1,!0),c>0||t.isOfType(l.ROWACTION)?n.focusItem(this,r-u*(i-g),e):n.focusItem(this,r-u*i,e)):(this._getScrollExtension().scrollVerticallyMax(!1,!0),n.focusItem(this,r-u*(i-g-c),e))}}}},f.prototype.onsapendmodifiers=function(e){if(!this._getKeyboardExtension().isInActionMode()&&f._isKeyCombination(e,null,a.CTRL)){e.preventDefault();if(n.getCellInfo(e.target).isOfType(l.ANY)){var t=n.getFocusedItemInfo(this),o=t.row,i=n.getHeaderRowCount(this),r=n.getNonEmptyVisibleRowCount(this),u=this.getFixedRowCount(),g=this.getFixedBottomRowCount();if(s(e),0===g||o<i+r-1||n.isNoDataVisible(this)&&o<i-1){var c=t.cell,p=t.columnCount;n.isNoDataVisible(this)?n.focusItem(this,c+p*(i-o-1),e):o<i?u>0?n.focusItem(this,c+p*(i+u-o-1),e):(this._getScrollExtension().scrollVerticallyMax(!0,!0),n.focusItem(this,c+p*(i+r-g-o-1),e)):o>=i&&o<i+u?(this._getScrollExtension().scrollVerticallyMax(!0,!0),n.focusItem(this,c+p*(i+r-g-o-1),e)):o>=i+u&&o<i+r-g?(this._getScrollExtension().scrollVerticallyMax(!0,!0),n.focusItem(this,c+p*(i+r-o-1),e)):n.focusItem(this,c+p*(i+r-o-1),e)}}}},f.prototype.onsappageup=function(e){if(!this._getKeyboardExtension().isInActionMode()){e.preventDefault();var t=n.getCellInfo(e.target);if(t.isOfType(l.ANYCONTENTCELL|l.COLUMNHEADER)){var o=n.getFocusedItemInfo(this),i=o.row,r=n.getHeaderRowCount(this),a=this.getFixedRowCount(),u=this.getFixedBottomRowCount();if(0===a&&i>=r||a>0&&i>r){s(e);var f=o.cell,g=o.columnCount;if(i<r+a)n.focusItem(this,f-g*(i-r),e);else if(i===r+a){var c=n.getNonEmptyVisibleRowCount(this)-a-u,p=this.getFirstVisibleRow();this._getScrollExtension().scrollVertically(!1,!0,!0),p<c&&(a>0||t.isOfType(l.ROWACTION)?n.focusItem(this,f-g*(i-r),e):n.focusItem(this,f-g*r,e))}else i>r+a&&i<r+n.getNonEmptyVisibleRowCount(this)?n.focusItem(this,f-g*(i-r-a),e):n.focusItem(this,f-g*(i-r-n.getNonEmptyVisibleRowCount(this)+1),e)}t.isOfType(l.ROWACTION)&&i===r&&a>0&&s(e)}}},f.prototype.onsappagedown=function(e){if(!this._getKeyboardExtension().isInActionMode()){e.preventDefault();var t=n.getCellInfo(e.target);if(t.isOfType(l.ANY)){var o=n.getFocusedItemInfo(this),i=o.row,r=n.getHeaderRowCount(this),a=n.getNonEmptyVisibleRowCount(this),u=this.getFixedRowCount(),f=this.getFixedBottomRowCount();if(s(e),n.isNoDataVisible(this)&&i<r-1||0===f||i<r+a-1){var g=o.cell,c=o.columnCount;if(i<r-1&&!t.isOfType(l.COLUMNROWHEADER))n.focusItem(this,g+c*(r-i-1),e);else if(i<r)n.isNoDataVisible(this)||n.focusItem(this,g+c*(r-i),e);else if(i>=r&&i<r+a-f-1)n.focusItem(this,g+c*(r+a-f-i-1),e);else if(i===r+a-f-1){var p=n.getNonEmptyVisibleRowCount(this)-u-f,C=this._getTotalRowCount()-f-this.getFirstVisibleRow()-2*p;this._getScrollExtension().scrollVertically(!0,!0,!0),C<p&&f>0&&n.focusItem(this,g+c*(r+a-i-1),e)}else n.focusItem(this,g+c*(r+a-i-1),e)}}}},f.prototype.onsappageupmodifiers=function(e){if(!this._getKeyboardExtension().isInActionMode()&&f._isKeyCombination(e,null,a.ALT)){var t=n.getCellInfo(e.target),o=n.getFocusedItemInfo(this);if(t.isOfType(l.DATACELL|l.COLUMNHEADER)){var i=o.cell,r=o.cellInRow,u=n.hasRowHeader(this),g=u?1:0;s(e),u&&(n.Grouping.isInGroupingRow(e.target)||1===r)?n.focusItem(this,i-r,null):r-g<5?n.focusItem(this,i-r+g,null):n.focusItem(this,i-5,null)}else t.isOfType(l.ROWACTION)&&n.focusItem(this,o.cell-1,null)}},f.prototype.onsappagedownmodifiers=function(e){if(!this._getKeyboardExtension().isInActionMode()&&f._isKeyCombination(e,null,a.ALT)){var t=n.getCellInfo(e.target);if(t.isOfType(l.DATACELL|l.ROWHEADER|l.ANYCOLUMNHEADER)){var o=n.getFocusedItemInfo(this),i=o.cellInRow,r=n.hasRowHeader(this),u=r?1:0,g=n.getVisibleColumnCount(this),c=parseInt(t.cell.attr(\"colspan\")||1,10);if(s(e),i+c-u<g){var p=o.cell;r&&0===i?n.focusItem(this,p+1,null):c>5?n.focusItem(this,p+c,null):i+c-u+5>g?n.focusItem(this,p+g-i-1+u,null):n.Grouping.isInGroupingRow(e.target)||n.focusItem(this,p+5,null)}else t.isOfType(l.DATACELL)&&n.hasRowActions(this)&&i===o.columnCount-2&&n.focusItem(this,o.cell+1,null)}}},f.prototype.onsapenter=function(e){f._handleSpaceAndEnter(this,e)},f});",
	"sap/ui/table/TableKeyboardExtension.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"./TableExtension\",\"sap/ui/core/delegate/ItemNavigation\",\"./TableUtils\",\"./TableKeyboardDelegate2\",\"sap/ui/Device\"],function(t,e,i,a,o,n){\"use strict\";function s(e){if(n.browser.msie){l||(t(\"head\").append('<style type=\"text/css\">/* Avoid focus outline problems in tables */\\n.sapUiTableStatic[data-sap-ui-table-focus]{}</style>'),l=!0);var i=a.getCellInfo(e)||{};i.cell&&i.cell.attr(\"data-sap-ui-table-focus\",Date.now())}}var l=!1,d={_forward:function(t,e){var i=t._getItemNavigation();null==i||t._getKeyboardExtension()._isItemNavigationSuspended()||e.isMarked(\"sapUiTableSkipItemNavigation\")||i[\"on\"+e.type](e)},onfocusin:function(t){d._forward(this,t),s(t.target)},onsapfocusleave:function(t){d._forward(this,t)},onmousedown:function(t){d._forward(this,t)},onsapnext:function(t){d._forward(this,t)},onsapnextmodifiers:function(t){d._forward(this,t)},onsapprevious:function(t){d._forward(this,t)},onsappreviousmodifiers:function(t){d._forward(this,t)},onsappageup:function(t){d._forward(this,t)},onsappagedown:function(t){d._forward(this,t)},onsaphome:function(t){d._forward(this,t)},onsaphomemodifiers:function(t){d._forward(this,t)},onsapend:function(t){d._forward(this,t)},onsapendmodifiers:function(t){d._forward(this,t)},onsapkeyup:function(t){d._forward(this,t)}},r={onfocusin:function(t){var e=this._getKeyboardExtension();e._bIgnoreFocusIn?t.setMarked(\"sapUiTableIgnoreFocusIn\"):(e.initItemNavigation(),u.isItemNavigationInvalid(this)&&t.setMarked(\"sapUiTableInitItemNavigation\")),t.target&&t.target.id===this.getId()+\"-rsz\"&&(t.preventDefault(),t.setMarked(\"sapUiTableSkipItemNavigation\"))}},u={_initItemNavigation:function(e){var o,n,s,l,d,r=e.getTable(),g=r.$(),c=a.getVisibleColumnCount(r),f=c,p=a.hasRowHeader(r),v=a.hasRowActions(r),m=a.hasFixedColumns(r),h=[];m&&(s=g.find(\".sapUiTableCtrlFixed.sapUiTableCtrlRowFixed:not(.sapUiTableCHT)\"),l=g.find(\".sapUiTableCtrlFixed.sapUiTableCtrlRowScroll:not(.sapUiTableCHT)\"),d=g.find(\".sapUiTableCtrlFixed.sapUiTableCtrlRowFixedBottom:not(.sapUiTableCHT)\"));var b=g.find(\".sapUiTableCtrlScroll.sapUiTableCtrlRowFixed:not(.sapUiTableCHT)\"),_=g.find(\".sapUiTableCtrlScroll.sapUiTableCtrlRowScroll:not(.sapUiTableCHT)\"),I=g.find(\".sapUiTableCtrlScroll.sapUiTableCtrlRowFixedBottom:not(.sapUiTableCHT)\");p&&(o=g.find(\".sapUiTableRowHdr\").get(),f++),v&&(n=g.find(\".sapUiTableRowAction\").get(),f++);for(var T=0;T<r.getVisibleRowCount();T++)p&&h.push(o[T]),m&&(h=h.concat(s.find('tr[data-sap-ui-rowindex=\"'+T+'\"]').find(\"td[tabindex]\").get())),h=h.concat(b.find('tr[data-sap-ui-rowindex=\"'+T+'\"]').find(\"td[tabindex]\").get()),m&&(h=h.concat(l.find('tr[data-sap-ui-rowindex=\"'+T+'\"]').find(\"td[tabindex]\").get())),h=h.concat(_.find('tr[data-sap-ui-rowindex=\"'+T+'\"]').find(\"td[tabindex]\").get()),m&&(h=h.concat(d.find('tr[data-sap-ui-rowindex=\"'+T+'\"]').find(\"td[tabindex]\").get())),h=h.concat(I.find('tr[data-sap-ui-rowindex=\"'+T+'\"]').find(\"td[tabindex]\").get()),v&&h.push(n[T]);if(r.getColumnHeaderVisible()){for(var C=[],N=g.find(\".sapUiTableCHT.sapUiTableCtrlFixed>tbody>tr\"),w=g.find(\".sapUiTableCHT.sapUiTableCtrlScroll>tbody>tr\"),T=0;T<a.getHeaderRowCount(r);T++)p&&C.push(r.getDomRef(\"selall\")),N.length&&(C=C.concat(t(N.get(T)).find(\".sapUiTableCol\").get())),w.length&&(C=C.concat(t(w.get(T)).find(\".sapUiTableCol\").get())),v&&C.push(g.find(\".sapUiTableRowActionHeader\").children().get(0));h=C.concat(h)}e._itemNavigation||(e._itemNavigation=new i,e._itemNavigation.setTableMode(!0),e._itemNavigation.attachEvent(i.Events.AfterFocus,function(t){var i=a.getFocusedItemInfo(r);i.header=a.getHeaderRowCount(r),i.domRef=null,i.row>=i.header&&(e._oLastFocusedCellInfo=i)},r)),e._itemNavigation.setColumns(f),e._itemNavigation.setRootDomRef(g.find(\".sapUiTableCnt\").get(0)),e._itemNavigation.setItemDomRefs(h),e._itemNavigation.setFocusedIndex(u.getInitialItemNavigationIndex(e)),e._itemNavigationInvalidated=!1},getInitialItemNavigationIndex:function(t){return a.hasRowHeader(t.getTable())?1:0},isItemNavigationInvalid:function(t){return!t._itemNavigation||t._itemNavigationInvalidated}},g=e.extend(\"sap.ui.table.TableKeyboardExtension\",{_init:function(t,e,i){return this._itemNavigation=null,this._itemNavigationInvalidated=!1,this._itemNavigationSuspended=!1,this._delegate=new o(e),this._actionMode=!1,t.addEventDelegate(r,t),t.addEventDelegate(this._delegate,t),t.addEventDelegate(d,t),t._getItemNavigation=function(){return this._itemNavigation}.bind(this),\"KeyboardExtension\"},_debug:function(){this._ExtensionHelper=u,this._ItemNavigationDelegate=d,this._ExtensionDelegate=r},destroy:function(){var t=this.getTable();t&&(t.removeEventDelegate(r),t.removeEventDelegate(this._delegate),t.removeEventDelegate(d)),this._itemNavigation&&(this._itemNavigation.destroy(),this._itemNavigation=null),this._delegate&&(this._delegate.destroy(),this._delegate=null),e.prototype.destroy.apply(this,arguments)}});return g.prototype.initItemNavigation=function(){u.isItemNavigationInvalid(this)&&u._initItemNavigation(this)},g.prototype.invalidateItemNavigation=function(){this._itemNavigationInvalidated=!0},g.prototype.setActionMode=function(t){!0===t&&!this._actionMode&&this._delegate.enterActionMode?this._actionMode=!0===this._delegate.enterActionMode.apply(this.getTable(),Array.prototype.slice.call(arguments,1)):!1===t&&this._actionMode&&this._delegate.leaveActionMode&&(this._actionMode=!1,this._delegate.leaveActionMode.apply(this.getTable(),Array.prototype.slice.call(arguments,1)))},g.prototype.isInActionMode=function(){return this._actionMode},g.prototype.updateNoDataAndOverlayFocus=function(e){var i=this.getTable();i&&i.getDomRef()&&(i.getShowOverlay()?t.sap.containsOrEquals(i.getDomRef(),e)&&i.$(\"overlay\").focus():a.isNoDataVisible(i)?t.sap.containsOrEquals(i.getDomRef(\"sapUiTableCnt\"),e)&&i.$(\"noDataCnt\").focus():(t.sap.containsOrEquals(i.getDomRef(\"noDataCnt\"),e)||t.sap.containsOrEquals(i.getDomRef(\"overlay\"),e))&&a.focusItem(i,u.getInitialItemNavigationIndex(this)))},g.prototype._suspendItemNavigation=function(){this._itemNavigationSuspended=!0},g.prototype._resumeItemNavigation=function(){this._itemNavigationSuspended=!1},g.prototype._isItemNavigationSuspended=function(){return this._itemNavigationSuspended},g.prototype._getLastFocusedCellInfo=function(){var t=a.getHeaderRowCount(this.getTable());if(!this._oLastFocusedCellInfo||this._oLastFocusedCellInfo.header!=t){var e=a.getFocusedItemInfo(this.getTable()),i=u.getInitialItemNavigationIndex(this);return{cellInRow:i,row:t,header:t,cellCount:e.cellCount,columnCount:e.columnCount,cell:e.columnCount*t+i}}return this._oLastFocusedCellInfo},g.prototype._setSilentFocus=function(t){this._bIgnoreFocusIn=!0,this._setFocus(t),this._bIgnoreFocusIn=!1},g.prototype._setFocus=function(e){if(e){var i=this.getTable();if(a.getCellInfo(e).cell&&i){var o=t(e);if(\"0\"!=o.attr(\"tabindex\")){var n=i._getItemNavigation();if(n&&n.aItemDomRefs)for(var s=0;s<n.aItemDomRefs.length;s++)n.aItemDomRefs[s]&&n.aItemDomRefs[s].setAttribute(\"tabindex\",\"-1\");o.attr(\"tabindex\",\"0\")}}e.focus()}},g.prototype._getTableType=function(){return this._type},g});",
	"sap/ui/table/TableMenuUtils.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/Device\",\"sap/ui/unified/Menu\",\"sap/ui/unified/MenuItem\",\"sap/ui/core/Popup\"],function(e,n,l,t,o){\"use strict\";o.setInitialZIndex(10);var u={TableUtils:null,openContextMenu:function(l,t,o,i,a){if(null!=l&&null!=t){null==i&&(i=!0);var C=e(t),s=u.TableUtils.getCell(l,C);if(null!==s){var r,f=u.TableUtils.getCellInfo(s),c=f.columnIndex,d=f.rowIndex;if(f.isOfType(u.TableUtils.CELLTYPE.COLUMNHEADER)){var g=s.find(\".sapUiTableColDropDown\").length>0;n.system.desktop||g?(u.removeColumnHeaderCellMenu(l,c),r=!0,i&&(r=l.fireColumnSelect({column:l.getColumns()[c]})),r&&u.openColumnContextMenu(l,c,o,s)):u.applyColumnHeaderCellMenu(l,c,s)}else if(f.isOfType(u.TableUtils.CELLTYPE.ANYCONTENTCELL)){if(r=!0,i){var x,p=u.TableUtils.getRowColCell(l,d,c,c>=0),m=p.row,M=l.getBindingInfo(\"rows\");null!=M&&(x=m.getBindingContext(M.model));var v=l.getContextMenu();v&&v.setBindingContext(x),c>=0&&(r=l.fireCellContextmenu({rowIndex:m.getIndex(),columnIndex:c,columnId:p.column.getId(),cellControl:p.cell,rowBindingContext:x,cellDomRef:s[0]})),r&&(r=l.fireBeforeOpenContextMenu({rowIndex:m.getIndex(),columnIndex:null===p.column?null:c,contextMenu:v}))}r&&u.openDataCellContextMenu(l,f,o,a)}}}},openColumnContextMenu:function(e,n,l,t){if(!(null==e||null==n||n<0)){null==l&&(l=!1);var o=e.getColumns();if(!(n>=o.length)){var i=o[n];if(i.getVisible()){for(var a=0;a<o.length;a++)o[a]!==i&&u.closeColumnContextMenu(e,a);u.closeDataCellContextMenu(e);var C=t&&t.attr(\"colspan\");C&&\"1\"!==C||i._openMenu(t&&t[0]||i.getDomRef(),l)}}}},closeColumnContextMenu:function(e,n){if(!(null==e||null==n||n<0)){var l=e.getColumns();if(!(n>=l.length)){l[n].getMenu().close()}}},openDataCellContextMenu:function(e,n,i,a){if(!(null==e||null==n||null==n.cell||n.rowIndex>=u.TableUtils.getNonEmptyVisibleRowCount(e))){var C=n.columnIndex,s=n.rowIndex;null==i&&(i=!1);var r=e.getColumns();if(!(C>=r.length)){var f=r[C];if(!f||f.getVisible()){var c=e.getRows()[s];if(u.hasContextMenu(e)){var d=c.$(),g=d.hasClass(\"sapUiAnalyticalTableSum\"),x=d.hasClass(\"sapUiTableGroupHeader\");g||x||e.getContextMenu().openAsContextMenu(a,n.cell)}else if(e.getEnableCellFilter()&&f&&f.isFilterableByMenu()){if(null==e._oCellContextMenu){e._oCellContextMenu=new l(e.getId()+\"-cellcontextmenu\");var p=new t({text:e._oResBundle.getText(\"TBL_FILTER\")});p._onSelect=function(e,n){var l=this.getContextByIndex(n),t=e.getFilterProperty(),o=l.getProperty(t);this.getEnableCustomFilter()?this.fireCustomFilter({column:e,value:o}):this.filter(e,o)},p.attachSelect(p._onSelect.bind(e,f,c.getIndex())),e._oCellContextMenu.addItem(p),e.addDependent(e._oCellContextMenu)}else{var m=e._oCellContextMenu.getItems()[0];m.mEventRegistry.select[0].fFunction=m._onSelect.bind(e,f,c.getIndex())}var M=c.getCells()[C],v=u.TableUtils.getParentCell(e,M.getDomRef());if(null!==v&&!u.TableUtils.Grouping.isInGroupingRow(v)){M=v[0];var b=e._oCellContextMenu.bOpen&&e._oCellContextMenu.oOpenerRef!==M;b&&u.closeDataCellContextMenu(e);for(var T=0;T<r.length;T++)u.closeColumnContextMenu(e,T);e._oCellContextMenu.open(i,M,o.Dock.BeginTop,o.Dock.BeginBottom,M,\"none none\")}}}}}},closeDataCellContextMenu:function(e){if(null!=e){var n=e._oCellContextMenu;null!=n&&n.bOpen&&n.close()}},cleanupDataCellContextMenu:function(e){e&&e._oCellContextMenu&&(e._oCellContextMenu.destroy(),e._oCellContextMenu=null)},applyColumnHeaderCellMenu:function(n,l,t){if(!(null==n||null==l||l<0)){var o=n.getColumns();if(!(l>=o.length)){var i=t&&t.attr(\"colspan\");if(!i||\"1\"===i){var a=o[l];if(a.getVisible()&&(a.getResizable()||a._menuHasItems())){var C=t||a.$(),s=C.find(\".sapUiTableColCell\");if(!(C.find(\".sapUiTableColCellMenu\").length>0)){u.removeColumnHeaderCellMenu(n),s.hide();var r=\"\";a._menuHasItems()&&(r=\"<div class='sapUiTableColDropDown'></div>\");var f=\"\";a.getResizable()&&(f=\"<div class='sapUiTableColResizer''></div>\");var c=e(\"<div class='sapUiTableColCellMenu'>\"+r+f+\"</div>\");C.append(c),C.on(\"focusout\",function(e,n){u.removeColumnHeaderCellMenu(e),this.off(\"focusout\")}.bind(C,n,l))}}}}}},removeColumnHeaderCellMenu:function(e){var n=e&&e.$().find(\".sapUiTableCHT .sapUiTableColCellMenu\");n.length&&(n.parent().find(\".sapUiTableColCell\").show(),n.remove())},hasContextMenu:function(e){return e&&e.getContextMenu()}};return u},!0);",
	"sap/ui/table/TablePersoController.js": "/*\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/base/ManagedObject\"],function(e,t){\"use strict\";var r=t.extend(\"sap.ui.table.TablePersoController\",{constructor:function(e,r){t.apply(this,arguments)},metadata:{properties:{autoSave:{type:\"boolean\",defaultValue:!0},persoService:{type:\"any\"},customDataKey:{type:\"string\",defaultValue:\"persoKey\"}},associations:{table:{type:\"sap.ui.table.Table\",multiple:!1}},library:\"sap.ui.table\"}});return r.prototype.init=function(){this._schemaProperty=\"_persoSchemaVersion\",this._schemaVersion=\"1.0\",this._oInitialPersoData=null,this._aTableEvents=[\"columnResize\",\"columnMove\",\"columnVisibility\",\"sort\",\"filter\",\"group\"],this._aColumnProperties=[\"visible\",\"width\",\"sorted\",\"sortOrder\",\"grouped\",\"summed\"],this._bSaveFilters=!1,this._bSaveFilters&&(this._aTableEvents.push(\"filter\"),this._aColumnProperties.push(\"filtered\"),this._aColumnProperties.push(\"filterValue\"))},r.prototype.exit=function(){var e=this._getTable();e&&this._manageTableEventHandlers(e,!1),delete this._schemaProperty,delete this._schemaVersion,delete this._oInitialPersoData,delete this._oDialog},r.prototype.setPersoService=function(t){if((t=this.validateProperty(\"persoService\",t))&&(!e.isFunction(t.getPersData)||!e.isFunction(t.setPersData)||!e.isFunction(t.delPersData)))throw new Error('Value of property \"persoService\" needs to be null/undefined or an object that has the methods \"getPersData\", \"setPersData\" and \"delPersData\".');var r=this.getPersoService();this.setProperty(\"persoService\",t,!0);var a=this.getPersoService();return a&&a!==r&&this._getTable()&&(this.getAutoSave()||!r)&&this.refresh(),this},r.prototype.setAutoSave=function(e){var t=this.getAutoSave();return this.setProperty(\"autoSave\",e,!0),this.getAutoSave()&&!t&&this.savePersonalizations(),this},r.prototype.setTable=function(e){var t=this._getTable();t&&(t._oPersoController=void 0),this.setAssociation(\"table\",e,!0);var r=this._getTable();return r&&(r._oPersoController=this),t&&this._manageTableEventHandlers(t,!1),r&&r!==t?(this._oInitialPersoData=this._getCurrentTablePersoData(!0),this._manageTableEventHandlers(r,!0),!this.getPersoService()||!this.getAutoSave()&&t||this.refresh()):r||(this._oInitialPersoData=null),this},r.prototype.setCustomDataKey=function(e){var t=this.getCustomDataKey();return this.setProperty(\"customDataKey\",e,!0),t!==this.getCustomDataKey()&&this.getAutoSave()&&this.savePersonalizations(),this},r.prototype._manageTableEventHandlers=function(e,t){for(var r=0,a=this._aTableEvents.length;r<a;r++){e[t?\"attachEvent\":\"detachEvent\"].apply(e,[this._aTableEvents[r],this._tableEventHandler,this])}},r.prototype.refresh=function(){var t=this,r=this.getPersoService();if(r)return r.getPersData().done(function(r){var a=r&&e.isArray(r.aColumns)?r:t._oInitialPersoData;t._adjustTable(a)}).fail(function(){e.sap.log.error(\"Problem reading persisted personalization data.\")});e.sap.log.error(\"The Personalization Service is not available!\");var a=e.Deferred();return a.reject(),a.promise()},r.prototype.savePersonalizations=function(){var t=this.getPersoService();if(t){var r=this._getCurrentTablePersoData();return r[this._schemaProperty]=this._schemaVersion,t.setPersData(r).fail(function(){e.sap.log.error(\"Problem persisting personalization data.\")})}e.sap.log.error(\"The Personalization Service is not available!\");var a=e.Deferred();return a.reject(),a.promise()},r.prototype._adjustTable=function(t){var r=this._getTable();if(r&&t&&e.isArray(t.aColumns)){for(var a={},o=r.getColumns(),s=0,i=o.length;s<i;s++)a[this._getColumnPersoKey(o[s])]=o[s];for(var n=t.aColumns,s=0,i=n.length;s<i;s++){var l=n[s],u=a[l.id];if(u){r.indexOfColumn(u)!==l.order&&(r.removeColumn(u),r.insertColumn(u,l.order));for(var h=u.getMetadata(),p=0,g=this._aColumnProperties.length;p<g;p++){var v=this._aColumnProperties[p];if(void 0!==l[v])try{h.hasProperty(v)&&u.getProperty(v)!=l[v]&&u.setProperty(v,l[v])}catch(t){e.sap.log.error('sap.ui.table.TablePersoController: failed to apply the value \"'+u[v]+'\" for the property + \"'+v+'\".')}}}}\"function\"==typeof r._onPersoApplied&&r._onPersoApplied()}},r.prototype._tableEventHandler=function(e){if(this.getAutoSave()&&!this._iTriggerSaveTimeout){var t=this;this._iTriggerSaveTimeout=setTimeout(function(){t.savePersonalizations(),t._iTriggerSaveTimeout=null},0)}},r.prototype._getCurrentTablePersoData=function(e){for(var t=this._getTable(),r=t.getColumns(),a={aColumns:[]},o=0,s=r.length;o<s;o++){for(var i=r[o],n=this._getColumnPersoKey(i),l={id:n,order:o},u=i.getMetadata(),h=0,p=this._aColumnProperties.length;h<p;h++){var g=this._aColumnProperties[h];u.hasProperty(g)&&(l[g]=i.getProperty(g))}e&&(l.text=i.getLabel()&&i.getLabel().getText()||n),a.aColumns.push(l)}return a},r.prototype._getTable=function(){return sap.ui.getCore().byId(this.getTable())},r.prototype._getColumnPersoKey=function(e){return this._getPersoKey(this._getTable())+\"-\"+this._getPersoKey(e)},r.prototype._getPersoKey=function(t){var r=t.data(this.getCustomDataKey());return r||(r=t.getId(),0===r.indexOf(sap.ui.getCore().getConfiguration().getUIDPrefix())&&e.sap.log.warning('Generated IDs should not be used as personalization keys! The stability cannot be ensured! (Control: \"'+t.getId()+'\")')),r},r.prototype.openDialog=function(t){sap.ui.getCore().loadLibrary(\"sap.m\");var r=sap.ui.requireSync(\"sap/m/TablePersoDialog\");if(!this._oDialog){var a=this;this._oDialog=new r({persoService:this.getPersoService(),showSelectAll:!0,showResetAll:!0,grouping:!1,contentWidth:t&&t.contentWidth,contentHeight:t&&t.contentHeight||\"20rem\",initialColumnState:this._oInitialPersoData.aColumns,columnInfoCallback:function(e,t,r){return a._getCurrentTablePersoData(!0).aColumns},confirm:function(){a._adjustTable(this.retrievePersonalizations()),a.getAutoSave()&&a.savePersonalizations()}}),this._oDialog._oDialog.removeStyleClass(\"sapUiPopupWithPadding\"),e.sap.syncStyleClass(\"sapUiSizeCompact\",this._getTable(),this._oDialog._oDialog)}this._oDialog.open()},r});",
	"sap/ui/table/TablePointerExtension.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"./library\",\"jquery.sap.global\",\"./TableExtension\",\"./TableUtils\",\"sap/ui/Device\",\"sap/ui/core/Popup\"],function(e,t,i,o,n,s){\"use strict\";var l=e.SelectionMode,a=[\"sapMBtnBase\",\"sapMInputBase\",\"sapMLnk\",\"sapMSlt\",\"sapMCb\",\"sapMRI\",\"sapMSegBBtn\",\"sapUiIconPointer\",\"sapMBtnIcon\"],r={_getEventPosition:function(e,t){var i;return i=function(i){if(!t._isTouchEvent(i))return null;for(var o=[\"touches\",\"targetTouches\",\"changedTouches\"],n=0;n<o.length;n++){var s=o[n];if(e[s]&&e[s][0])return e[s][0];if(e.originalEvent[s]&&e.originalEvent[s][0])return e.originalEvent[s][0]}return null}(e)||e,{x:i.pageX,y:i.pageY}},_skipClick:function(e,i,n){if(!n.isOfType(o.CELLTYPE.DATACELL|o.CELLTYPE.ROWACTION))return!1;if(e.isMarked())return!0;var s=i.control(0);if(s){var l=s.$();if(l.length)for(var r=0;r<a.length;r++)if(l.hasClass(a[r]))return\"function\"!=typeof s.getEnabled||s.getEnabled()}var d=!1;if(window.getSelection){var u=window.getSelection();d=!!u.rangeCount&&!u.getRangeAt(0).collapsed}return!!d&&(t.sap.log.debug(\"DOM Selection detected -> Click event on table skipped, Target: \"+e.target),!0)},_handleClickSelection:function(e,t,i){o.toggleRowSelection(i,t,null,function(t){(n.browser.msie||n.browser.edge)&&e.shiftKey&&i._clearTextSelection();var o=i.getSelectionMode();if(o===l.Single)i.isIndexSelected(t)?i.clearSelection():i.setSelectedIndex(t);else{var s=!(!e.metaKey&&!e.ctrlKey);if(o===l.MultiToggle&&(s=!0),e.shiftKey){var a=i.getSelectedIndex();a>=0?i.addSelectionInterval(a,t):i.setSelectedIndex(t)}else i.isIndexSelected(t)?s?i.removeSelectionInterval(t,t):1===i._getSelectedIndicesCount()?i.clearSelection():i.setSelectedIndex(t):s?i.addSelectionInterval(t,t):i.setSelectedIndex(t)}return!0})}},d={initColumnResizing:function(e,i){if(!e._bIsColumnResizerMoving){e._bIsColumnResizerMoving=!0,e.$().toggleClass(\"sapUiTableResizing\",!0);var o=t(document),n=e._isTouchEvent(i);e._$colResize=e.$(\"rsz\"),e._iColumnResizeStart=r._getEventPosition(i,e).x,o.bind((n?\"touchend\":\"mouseup\")+\".sapUiTableColumnResize\",d.exitColumnResizing.bind(e)),o.bind((n?\"touchmove\":\"mousemove\")+\".sapUiTableColumnResize\",d.onMouseMoveWhileColumnResizing.bind(e)),e._disableTextSelection()}},exitColumnResizing:function(e){d._resizeColumn(this,this._iLastHoveredColumnIndex)},onMouseMoveWhileColumnResizing:function(e){var t=r._getEventPosition(e,this).x;if(!(this._iColumnResizeStart&&t<this._iColumnResizeStart+3&&t>this._iColumnResizeStart-3)){this._isTouchEvent(e)&&(e.stopPropagation(),e.preventDefault()),this._$colResize.toggleClass(\"sapUiTableColRszActive\",!0);var i=this._getVisibleColumns()[this._iLastHoveredColumnIndex],n=t-this._iColumnResizeStart,s=this.$().find('th[data-sap-ui-colid=\"'+i.getId()+'\"]').width(),l=Math.max(s+n*(this._bRtlMode?-1:1),o.Column.getMinColumnWidth()),a=this.$().find(\".sapUiTableCnt\").offset().left,d=Math.floor(t-a-this._$colResize.width()/2);this._$colResize.css(\"left\",d+\"px\"),i._iNewWidth=l}},_cleanupColumResizing:function(e){e._$colResize&&(e._$colResize.toggleClass(\"sapUiTableColRszActive\",!1),e._$colResize=null),e._iColumnResizeStart=null,e._bIsColumnResizerMoving=!1,e.$().toggleClass(\"sapUiTableResizing\",!1),e._enableTextSelection();var i=t(document);i.unbind(\"touchmove.sapUiTableColumnResize\"),i.unbind(\"touchend.sapUiTableColumnResize\"),i.unbind(\"mousemove.sapUiTableColumnResize\"),i.unbind(\"mouseup.sapUiTableColumnResize\")},_resizeColumn:function(e,t){var i,n=e._getVisibleColumns(),s=!1;t>=0&&t<n.length&&(i=n[t],i._iNewWidth&&(o.Column.resizeColumn(e,e.indexOfColumn(i),i._iNewWidth),delete i._iNewWidth,s=!0)),d._cleanupColumResizing(e),i.focus(),s&&e.invalidate()},doAutoResizeColumn:function(e,t){var i,o=e._getVisibleColumns();if(t>=0&&t<o.length){if(i=o[t],!i.getAutoResizable()||!i.getResizable())return;var n=d._calculateAutomaticColumnWidth.apply(e,[i,t]);n&&(i._iNewWidth=n,d._resizeColumn(e,t))}},_calculateAutomaticColumnWidth:function(e,i){e=e||this.getColumns()[i];var n=this.$(),s=t(\"<div>\").addClass(\"sapUiTableHiddenSizeDetector\");n.append(s);var l=n.find('td[data-sap-ui-colid = \"'+e.getId()+'\"]:not([colspan])').filter(function(e,t){return\"none\"!=t.style.display}).children().clone();l.find(\"[id]\").removeAttr(\"id\");var a=s.append(l).width()+4;return a=Math.min(a,n.find(\".sapUiTableCnt\").width()),a=Math.max(a+4,o.Column.getMinColumnWidth()),s.remove(),a},initColumnTracking:function(e){e.$().find(\".sapUiTableCtrlScr, .sapUiTableCtrlScrFixed\").mousemove(function(e){var t=this.getDomRef();if(t&&!this._bIsColumnResizerMoving){for(var i=e.clientX,o=t.getBoundingClientRect(),n=0,s=this._bRtlMode?1e4:-1e4,l=0;l<this._aTableHeaders.length;l++){var a=this._aTableHeaders[l].getBoundingClientRect();if(this._bRtlMode){if(i<a.right-5&&i>=a.left){n=l,s=a.left-o.left;break}}else if(i>a.left+5&&i<=a.right){n=l,s=a.right-o.left;break}}var r=this._getVisibleColumns()[n];r&&r.getResizable()&&(this.$(\"rsz\").css(\"left\",s+\"px\"),this._iLastHoveredColumnIndex=n)}}.bind(e))}},u={initInteractiveResizing:function(e,i){var o=t(document.body),n=e.$(\"sb\"),s=t(document),l=n.offset(),a=n.height(),r=n.width(),d=e._isTouchEvent(i);o.bind(\"selectstart\",u.onSelectStartWhileInteractiveResizing),o.append('<div id=\"'+e.getId()+'-ghost\" class=\"sapUiTableInteractiveResizerGhost\" style =\" height:'+a+\"px; width:\"+r+\"px; left:\"+l.left+\"px; top:\"+l.top+'px\" ></div>'),n.append('<div id=\"'+e.getId()+'-rzoverlay\" style =\"left: 0px; right: 0px; bottom: 0px; top: 0px; position:absolute\" ></div>'),s.bind((d?\"touchend\":\"mouseup\")+\".sapUiTableInteractiveResize\",u.exitInteractiveResizing.bind(e)),s.bind((d?\"touchmove\":\"mousemove\")+\".sapUiTableInteractiveResize\",u.onMouseMoveWhileInteractiveResizing.bind(e)),e._disableTextSelection()},exitInteractiveResizing:function(e){var i=t(document.body),n=t(document),s=this.$(),l=this.$(\"ghost\"),a=r._getEventPosition(e,this).y,d=a-s.find(\".sapUiTableCCnt\").offset().top-l.height()-s.find(\".sapUiTableFtr\").height();this._setRowContentHeight(d),this._updateRows(this._calculateRowsToDisplay(d),o.RowsUpdateReason.Resize),l.remove(),this.$(\"rzoverlay\").remove(),i.unbind(\"selectstart\",u.onSelectStartWhileInteractiveResizing),n.unbind(\"touchend.sapUiTableInteractiveResize\"),n.unbind(\"touchmove.sapUiTableInteractiveResize\"),n.unbind(\"mouseup.sapUiTableInteractiveResize\"),n.unbind(\"mousemove.sapUiTableInteractiveResize\"),this._enableTextSelection()},onSelectStartWhileInteractiveResizing:function(e){return e.preventDefault(),e.stopPropagation(),!1},onMouseMoveWhileInteractiveResizing:function(e){var t=r._getEventPosition(e,this).y;t>this.$().offset().top&&this.$(\"ghost\").css(\"top\",t+\"px\")}},h={initReordering:function(e,i,n){var l=e.getColumns()[i],a=l.$(),r=e.$();e._disableTextSelection(),r.addClass(\"sapUiTableDragDrop\");var d=a.clone();d.find(\"*\").addBack(d).removeAttr(\"id\").removeAttr(\"data-sap-ui\").removeAttr(\"tabindex\"),d.attr(\"id\",e.getId()+\"-roghost\").addClass(\"sapUiTableColReorderGhost\").css({left:-1e4,top:-1e4,\"z-index\":s.getNextZIndex()}),d.toggleClass(o.getContentDensity(e),!0),d.appendTo(document.body),e._$ReorderGhost=e.getDomRef(\"roghost\"),r.find(\"td[data-sap-ui-colid='\"+l.getId()+\"']\").toggleClass(\"sapUiTableColReorderFade\",!0),t(\"<div id='\"+e.getId()+\"-roind' class='sapUiTableColReorderIndicator'><div class='sapUiTableColReorderIndicatorArrow'></div><div class='sapUiTableColReorderIndicatorInner'></div></div>\").appendTo(e.getDomRef(\"sapUiTableCnt\")),e._$ReorderIndicator=e.getDomRef(\"roind\"),e._iDnDColIndex=i;var u=t(document),c=e._isTouchEvent(n);u.bind((c?\"touchend\":\"mouseup\")+\".sapUiColumnMove\",h.exitReordering.bind(e)),u.bind((c?\"touchmove\":\"mousemove\")+\".sapUiColumnMove\",h.onMouseMoveWhileReordering.bind(e))},onMouseMoveWhileReordering:function(e){var i=r._getEventPosition(e,this),n=i.x,s=i.y,l=this._iNewColPos;this._iNewColPos=this._iDnDColIndex,e.preventDefault();var a=h.findColumnForPosition(this,n);if(!a||!a.id)return void(this._iNewColPos=l);var d=this.getDomRef(\"sapUiTableCtrlScr\"),u=t(d),c=d.getBoundingClientRect(),g=u.outerWidth(),f=this._bRtlMode?u.scrollLeftRTL():u.scrollLeft();this._bReorderScroll=!1,n>c.left+g-40&&f+g<d.scrollWidth?(this._bReorderScroll=!0,h.doScroll(this,!this._bRtlMode),h.adaptReorderMarkerPosition(this,a,!1)):n<c.left+40&&f>0&&(this._bReorderScroll=!0,h.doScroll(this,this._bRtlMode),h.adaptReorderMarkerPosition(this,a,!1)),t(this._$ReorderGhost).css({left:n+5,top:s+5}),!this._bReorderScroll&&a&&(a.before||a.after&&a.index==this._iDnDColIndex?this._iNewColPos=a.index:a.after&&a.index!=this._iDnDColIndex&&(this._iNewColPos=a.index+1),o.Column.isColumnMovableTo(this.getColumns()[this._iDnDColIndex],this._iNewColPos)?h.adaptReorderMarkerPosition(this,a,!0):this._iNewColPos=l)},exitReordering:function(e){var i=this._iDnDColIndex,n=this._iNewColPos,s=t(document);s.unbind(\"touchmove.sapUiColumnMove\"),s.unbind(\"touchend.sapUiColumnMove\"),s.unbind(\"mousemove.sapUiColumnMove\"),s.unbind(\"mouseup.sapUiColumnMove\"),this._bReorderScroll=!1,this.$().removeClass(\"sapUiTableDragDrop\"),delete this._iDnDColIndex,delete this._iNewColPos,t(this._$ReorderGhost).remove(),delete this._$ReorderGhost,t(this._$ReorderIndicator).remove(),delete this._$ReorderIndicator,this.$().find(\".sapUiTableColReorderFade\").removeClass(\"sapUiTableColReorderFade\"),this._enableTextSelection(),o.Column.moveColumnTo(this.getColumns()[i],n),this._mTimeouts.reApplyFocusTimerId&&window.clearTimeout(this._mTimeouts.reApplyFocusTimerId);var l=this;this._mTimeouts.reApplyFocusTimerId=window.setTimeout(function(){var t=o.getFocusedItemInfo(l).cell;o.focusItem(l,0,e),o.focusItem(l,t,e)},0),this.updateAnalyticalInfo&&this.updateAnalyticalInfo(!0,!0)},findColumnForPosition:function(e,i){for(var o,n,s,l,a,r,d,u=0;u<e._aTableHeaders.length;u++)if(o=e._aTableHeaders[u],n=t(o),s=o.getBoundingClientRect(),l=n.outerWidth(),a={left:s.left,center:s.left+l/2,right:s.left+l,width:l,index:parseInt(n.attr(\"data-sap-ui-headcolindex\"),10),id:n.attr(\"data-sap-ui-colid\")},r=i>=a.left&&i<=a.center,d=i>=a.center&&i<=a.right,r||d)return a.before=e._bRtlMode?d:r,a.after=e._bRtlMode?r:d,a;return null},doScroll:function(e,i){if(e._mTimeouts.horizontalReorderScrollTimerId&&(window.clearTimeout(e._mTimeouts.horizontalReorderScrollTimerId),e._mTimeouts.horizontalReorderScrollTimerId=null),e._bReorderScroll){var o=i?30:-30;e._bRtlMode&&(o*=-1),e._mTimeouts.horizontalReorderScrollTimerId=t.sap.delayedCall(60,e,h.doScroll,[e,i]);var n=e.$(\"sapUiTableCtrlScr\"),s=e._bRtlMode?\"scrollLeftRTL\":\"scrollLeft\";n[s](n[s]()+o)}},adaptReorderMarkerPosition:function(e,i,o){if(i&&e._$ReorderIndicator){var n=i.left-e.getDomRef().getBoundingClientRect().left;(e._bRtlMode&&i.before||!e._bRtlMode&&i.after)&&(n+=i.width),t(e._$ReorderIndicator).css({left:n+\"px\"}).toggleClass(\"sapUiTableColReorderIndicatorActive\",o)}}},c={ROWAREAS:[\".sapUiTableRowHdr\",\".sapUiTableRowAction\",\".sapUiTableCtrlFixed > tbody > .sapUiTableTr\",\".sapUiTableCtrlScroll > tbody > .sapUiTableTr\"],initRowHovering:function(e){for(var t=e.$(),i=0;i<c.ROWAREAS.length;i++)c._initRowHoveringForArea(t,c.ROWAREAS[i])},_initRowHoveringForArea:function(e,t){e.find(t).hover(function(){c._onHover(this,e,t)},function(){c._onUnhover(this,e)})},_onHover:function(e,t,i){for(var o=t.find(i).index(e),n=0;n<c.ROWAREAS.length;n++)t.find(c.ROWAREAS[n]).filter(\":eq(\"+o+\")\").addClass(\"sapUiTableRowHvr\")},_onUnhover:function(e,t){for(var i=0;i<c.ROWAREAS.length;i++)t.find(c.ROWAREAS[i]).removeClass(\"sapUiTableRowHvr\")}},g={onmousedown:function(e){var i,s,l,a=this._getPointerExtension(),h=o.getCell(this,e.target),c=o.getCellInfo(h),g=t(e.target);if(this._getKeyboardExtension().initItemNavigation(),0===e.button){if(e.target===this.getDomRef(\"sb\"))u.initInteractiveResizing(this,e);else if(e.target===this.getDomRef(\"rsz\"))d.initColumnResizing(this,e);else if(g.hasClass(\"sapUiTableColResizer\")){var f=g.closest(\".sapUiTableCol\").attr(\"data-sap-ui-colindex\");this._iLastHoveredColumnIndex=parseInt(f,10),d.initColumnResizing(this,e)}else c.isOfType(o.CELLTYPE.COLUMNHEADER)&&(i=this.getColumns()[c.columnIndex],s=i.getAggregation(\"menu\"),l=s&&s.bOpen,l||(a._bShowMenu=!0,this._mTimeouts.delayedMenuTimerId=t.sap.delayedCall(200,this,function(){delete a._bShowMenu})),!this.getEnableColumnReordering()||this._isTouchEvent(e)&&g.hasClass(\"sapUiTableColDropDown\")||this._getPointerExtension().doReorderColumn(c.columnIndex,e));(n.browser.firefox&&(e.metaKey||e.ctrlKey)||1===g.closest(\".sapUiTableHSb\",this.getDomRef()).length||1===g.closest(\".sapUiTableVSb\",this.getDomRef()).length)&&e.preventDefault()}if(2===e.button){if(r._skipClick(e,g,c))return void(a._bShowDefaultMenu=!0);if(c.isOfType(o.CELLTYPE.COLUMNHEADER))i=this.getColumns()[c.columnIndex],s=i.getAggregation(\"menu\"),l=s&&s.bOpen,l?a._bHideMenu=!0:a._bShowMenu=!0;else if(c.isOfType(o.CELLTYPE.ANYCONTENTCELL))if(o.Menu.hasContextMenu(this))a._bShowMenu=!0;else{l=this._oCellContextMenu&&this._oCellContextMenu.bOpen;var p=l&&this._oCellContextMenu.oOpenerRef!==h[0];!l||p?a._bShowMenu=!0:a._bHideMenu=!0}else a._bShowDefaultMenu=!0}},onmouseup:function(e){t.sap.clearDelayedCall(this._mTimeouts.delayedColumnReorderTimerId)},ondblclick:function(e){n.system.desktop&&e.target===this.getDomRef(\"rsz\")&&(e.preventDefault(),d.doAutoResizeColumn(this,this._iLastHoveredColumnIndex))},onclick:function(e){if(t.sap.clearDelayedCall(this._mTimeouts.delayedColumnReorderTimerId),!e.isMarked()){var i=t(e.target);if(i.hasClass(\"sapUiAnalyticalTableSum\"))return void e.preventDefault();if(i.hasClass(\"sapUiTableGroupMenuButton\"))return this._onContextMenu(e),void e.preventDefault();if(!i.hasClass(\"sapUiTableGroupIcon\")&&!i.hasClass(\"sapUiTableTreeIcon\")||!o.Grouping.toggleGroupHeaderByRef(this,e.target)){var n=o.getCell(this,e.target),s=o.getCellInfo(n);if(s.isOfType(o.CELLTYPE.COLUMNHEADER)){var l=this._getPointerExtension();l._bShowMenu&&(o.Menu.openContextMenu(this,e.target,!1),delete l._bShowMenu)}else{if(r._skipClick(e,i,s))return;this._findAndfireCellEvent(this.fireCellClick,e)?e.preventDefault():s.isOfType(o.CELLTYPE.COLUMNROWHEADER)?this._toggleSelectAll():r._handleClickSelection(e,n,this)}}}},oncontextmenu:function(e){var t=this._getPointerExtension();t._bShowDefaultMenu?(e.setMarked(\"handledByPointerExtension\"),delete t._bShowDefaultMenu):t._bShowMenu?(e.setMarked(\"handledByPointerExtension\"),e.preventDefault(),o.Menu.openContextMenu(this,e.target,!1,null,e),delete t._bShowMenu):t._bHideMenu&&(e.setMarked(\"handledByPointerExtension\"),e.preventDefault(),delete t._bHideMenu)}};return i.extend(\"sap.ui.table.TablePointerExtension\",{_init:function(e,t,o){return this._delegate=g,e.addEventDelegate(this._delegate,e),e._iLastHoveredColumnIndex=0,e._bIsColumnResizerMoving=!1,e._iFirstReorderableIndex=t==i.TABLETYPES.TREE?1:0,\"PointerExtension\"},_attachEvents:function(){var e=this.getTable();e&&(d.initColumnTracking(e),c.initRowHovering(e))},_detachEvents:function(){var e=this.getTable();if(e){var t=e.$();t.find(\".sapUiTableCtrlScr, .sapUiTableCtrlScrFixed\").unbind(),t.find(\".sapUiTableCtrl > tbody > tr\").unbind(),t.find(\".sapUiTableRowHdr\").unbind()}},_debug:function(){this._ExtensionHelper=r,this._ColumnResizeHelper=d,this._InteractiveResizeHelper=u,this._ReorderHelper=h,this._ExtensionDelegate=g,this._RowHoverHandler=c,this._KNOWNCLICKABLECONTROLS=a},doAutoResizeColumn:function(e){var t=this.getTable();t&&d.doAutoResizeColumn(t,e)},doReorderColumn:function(e,i){var n=this.getTable();n&&o.Column.isColumnMovable(n.getColumns()[e])&&(n._mTimeouts.delayedColumnReorderTimerId=t.sap.delayedCall(200,n,function(){h.initReordering(this,e,i)}))},destroy:function(){var e=this.getTable();e&&e.removeEventDelegate(this._delegate),this._delegate=null,i.prototype.destroy.apply(this,arguments)}})});",
	"sap/ui/table/TableRenderer.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"sap/ui/core/Control\",\"sap/ui/core/theming/Parameters\",\"sap/ui/Device\",\"./library\",\"./TableUtils\",\"sap/ui/core/Renderer\",\"sap/ui/core/IconPool\"],function(e,t,i,r,a,d,s){\"use strict\";var l=r.SelectionMode,n=r.VisibleRowCountMode,o={};return o.render=function(e,t){delete t._iHeaderRowCount,e.write(\"<div\"),t._getAccRenderExtension().writeAriaAttributesFor(e,t,\"ROOT\"),e.writeControlData(t),e.addClass(\"sapUiTable\"),\"ontouchstart\"in document&&e.addClass(\"sapUiTableTouch\"),e.addClass(\"sapUiTableSelMode\"+t.getSelectionMode()),t.getColumnHeaderVisible()&&e.addClass(\"sapUiTableCHdr\"),a.hasRowHeader(t)&&e.addClass(\"sapUiTableRowSelectors\"),a.hasRowHighlights(t)&&e.addClass(\"sapUiTableRowHighlights\");var i=r.TableHelper.addTableClass();if(i&&e.addClass(i),t._getScrollExtension().isVerticalScrollbarRequired()&&e.addClass(\"sapUiTableVScr\"),t.getEditable()&&e.addClass(\"sapUiTableEdt\"),a.hasRowActions(t)){var d=a.getRowActionCount(t);e.addClass(1==d?\"sapUiTableRActS\":\"sapUiTableRAct\")}a.isNoDataVisible(t)&&!a.hasPendingRequests(t)&&e.addClass(\"sapUiTableEmpty\"),t.getShowOverlay()&&e.addClass(\"sapUiTableOverlay\");var s=a.Grouping.getModeCssClass(t);s&&e.addClass(s),t.getWidth()&&e.addStyle(\"width\",t.getWidth()),t.getVisibleRowCountMode()==n.Auto&&(e.addStyle(\"height\",\"0px\"),t._bFirstRendering&&e.addClass(\"sapUiTableNoOpacity\")),e.writeClasses(),e.writeStyles(),e.write(\">\"),this.renderTabElement(e,\"sapUiTableOuterBefore\"),t.getTitle()&&this.renderHeader(e,t,t.getTitle()),t.getToolbar()&&this.renderToolbar(e,t,t.getToolbar()),t.getExtension()&&t.getExtension().length>0&&this.renderExtensions(e,t,t.getExtension()),e.write(\"<div\"),e.writeAttribute(\"id\",t.getId()+\"-sapUiTableCnt\"),e.addClass(\"sapUiTableCnt\"),e.writeClasses(),e.writeAttribute(\"data-sap-ui-fastnavgroup\",\"true\"),e.write(\">\"),e.write(\"<div\"),e.writeAttribute(\"id\",t.getId()+\"-sapUiTableGridCnt\"),t._getAccRenderExtension().writeAriaAttributesFor(e,t,\"CONTENT\"),e.write(\">\"),this.renderColRsz(e,t),this.renderColHdr(e,t),this.renderTable(e,t),e.write(\"</div>\"),t._getAccRenderExtension().writeHiddenAccTexts(e,t),e.write(\"<div\"),e.addClass(\"sapUiTableOverlayArea\"),e.writeClasses(),e.writeAttribute(\"tabindex\",\"0\"),e.writeAttribute(\"id\",t.getId()+\"-overlay\"),t._getAccRenderExtension().writeAriaAttributesFor(e,t,\"OVERLAY\"),e.write(\"></div>\"),e.write(\"</div>\"),t.getFooter()&&this.renderFooter(e,t,t.getFooter()),t.getVisibleRowCountMode()==n.Interactive&&this.renderVariableHeight(e,t),this.renderTabElement(e,\"sapUiTableOuterAfter\"),e.write(\"</div>\")},o.renderHeader=function(e,t,i){e.write(\"<div\"),e.addClass(\"sapUiTableHdr\"),e.writeClasses(),t._getAccRenderExtension().writeAriaAttributesFor(e,t,\"TABLEHEADER\"),e.write(\">\"),e.renderControl(i),e.write(\"</div>\")},o.renderToolbar=function(e,i,r){e.write(\"<div\"),e.addClass(\"sapUiTableTbr\"),\"function\"==typeof r.getStandalone&&r.getStandalone()&&r.setStandalone(!1),a.isInstanceOf(r,\"sap/m/Toolbar\")&&(r.setDesign(t.get(\"_sap_ui_table_Table_ToolbarDesign\"),!0),r.addStyleClass(\"sapMTBHeader-CTX\"),e.addClass(\"sapUiTableMTbr\")),e.writeClasses(),i._getAccRenderExtension().writeAriaAttributesFor(e,i,\"TABLESUBHEADER\"),e.write(\">\"),e.renderControl(r),e.write(\"</div>\")},o.renderExtensions=function(e,t,i){for(var r=0,a=i.length;r<a;r++)this.renderExtension(e,t,i[r])},o.renderExtension=function(e,t,i){e.write(\"<div\"),e.addClass(\"sapUiTableExt\"),e.writeClasses(),t._getAccRenderExtension().writeAriaAttributesFor(e,t,\"TABLESUBHEADER\"),e.write(\">\"),e.renderControl(i),e.write(\"</div>\")},o.renderTable=function(e,t){this.renderTabElement(e,\"sapUiTableCtrlBefore\"),e.write(\"<div\"),e.writeAttribute(\"id\",t.getId()+\"-tableCCnt\"),e.addClass(\"sapUiTableCCnt\"),e.writeClasses(),e.write(\">\"),this.renderTableCCnt(e,t),e.write(\"</div>\"),this.renderTabElement(e,\"sapUiTableCtrlAfter\"),this.renderVSb(e,t),this.renderHSb(e,t)},o.renderTableCCnt=function(t,i){this.renderTableCtrl(t,i),this.renderRowHdr(t,i),this.renderRowActions(t,i),t.write(\"<div\"),t.addClass(\"sapUiTableCtrlEmpty\"),t.writeClasses(),t.writeAttribute(\"tabindex\",\"0\"),t.writeAttribute(\"id\",i.getId()+\"-noDataCnt\"),i._getAccRenderExtension().writeAriaAttributesFor(t,i,\"NODATA\"),t.write(\">\"),i.getNoData()instanceof e?t.renderControl(i.getNoData()):(t.write(\"<span\"),t.writeAttribute(\"id\",i.getId()+\"-noDataMsg\"),t.addClass(\"sapUiTableCtrlEmptyMsg\"),t.writeClasses(),t.write(\">\"),t.writeEscaped(a.getNoDataText(i)),t.write(\"</span>\")),t.write(\"</div>\")},o.renderFooter=function(e,t,i){e.write(\"<div\"),e.addClass(\"sapUiTableFtr\"),e.writeClasses(),t._getAccRenderExtension().writeAriaAttributesFor(e,t,\"TABLEFOOTER\"),e.write(\">\"),e.renderControl(i),e.write(\"</div>\")},o.renderVariableHeight=function(e,t){e.write('<div id=\"'+t.getId()+'-sb\" tabIndex=\"-1\"'),e.addClass(\"sapUiTableHeightResizer\"),e.addStyle(\"height\",\"5px\"),e.writeClasses(),e.writeStyles(),e.write(\">\"),e.write(\"</div>\")},o.renderColHdr=function(e,t){var i=a.getHeaderRowCount(t),r=t.getColumns(),d=t.getFixedColumnCount();e.write(\"<div\"),e.addClass(\"sapUiTableColHdrCnt\"),e.writeClasses(),t.getColumnHeaderHeight()>0&&e.addStyle(\"height\",t.getColumnHeaderHeight()*i+\"px\"),e.writeStyles(),e.write(\">\"),this.renderColRowHdr(e,t),d>0&&(e.write(\"<div\"),e.addClass(\"sapUiTableCHA\"),e.addClass(\"sapUiTableCtrlScrFixed\"),e.addClass(\"sapUiTableNoOpacity\"),e.writeClasses(),e.write(\">\"),this.renderTableControlCnt(e,t,!0,0,d,!0,!1,0,i,!0),e.write(\"</div>\")),e.write(\"<div\"),e.writeAttribute(\"id\",t.getId()+\"-sapUiTableColHdrScr\"),e.addClass(\"sapUiTableCHA\"),e.addClass(\"sapUiTableCtrlScr\"),0==r.length&&e.addClass(\"sapUiTableHasNoColumns\"),e.writeClasses(),d>0&&(t._bRtlMode?e.addStyle(\"margin-right\",\"0\"):e.addStyle(\"margin-left\",\"0\"),e.writeStyles()),e.write(\">\"),this.renderTableControlCnt(e,t,!1,d,r.length,!1,!1,0,i,!0),e.write(\"</div>\"),a.hasRowActions(t)&&(e.write(\"<div class='sapUiTableRowActionHeader' id='\"+t.getId()+\"-rowacthdr'\"),t._getAccRenderExtension().writeAriaAttributesFor(e,t,\"ROWACTIONHEADER\"),e.write(\"><span>\"),e.writeEscaped(t._oResBundle.getText(\"TBL_ROW_ACTION_COLUMN_LABEL\")),e.write(\"</span></div>\")),e.write(\"</div>\")},o.renderColRowHdr=function(e,t){var i=!1,r=!1;if(e.write(\"<div\"),e.writeAttribute(\"id\",t.getId()+\"-selall\"),a.hasSelectAll(t)){var d=a.areAllRowsSelected(t);if(t._getShowStandardTooltips()){var s=d?\"TBL_DESELECT_ALL\":\"TBL_SELECT_ALL\";e.writeAttributeEscaped(\"title\",t._oResBundle.getText(s))}d?r=!0:e.addClass(\"sapUiTableSelAll\"),e.addClass(\"sapUiTableSelAllEnabled\"),i=!0}else e.addClass(\"sapUiTableSelAllDisabled\");e.addClass(\"sapUiTableColRowHdr\"),e.writeClasses(),e.writeAttribute(\"tabindex\",\"-1\"),t._getAccRenderExtension().writeAriaAttributesFor(e,t,\"COLUMNROWHEADER\",{enabled:i,checked:r}),e.write(\">\"),t.getSelectionMode()!==l.Single&&(e.write(\"<div\"),e.addClass(\"sapUiTableColRowHdrIco\"),e.writeClasses(),t.getColumnHeaderHeight()>0&&e.addStyle(\"height\",t.getColumnHeaderHeight()+\"px\"),e.write(\">\"),e.write(\"</div>\")),e.write(\"</div>\")},o.renderCol=function(e,t,i,r,a,s){var l,n=!a,o=i.getIndex(),w=i.getMultiLabels();w.length>0?l=w[r]:0==r&&(l=i.getLabel()),e.write(\"<td\");var C=i.getId();0===r?e.writeElementData(i):(C=C+\"_\"+r,e.writeAttribute(\"id\",C)),e.writeAttribute(\"data-sap-ui-colid\",i.getId()),e.writeAttribute(\"data-sap-ui-colindex\",o),e.writeAttribute(\"tabindex\",\"-1\");var b={column:i,headerId:C,index:o};a>1&&(e.writeAttribute(\"colspan\",a),b.colspan=!0),t._getAccRenderExtension().writeAriaAttributesFor(e,t,\"COLUMNHEADER\",b),e.addClass(\"sapUiTableCol\"),s&&e.addClass(\"sapUiTableColLastFixed\"),e.writeClasses(),t.getColumnHeaderHeight()>0&&e.addStyle(\"height\",t.getColumnHeaderHeight()+\"px\"),n&&e.addStyle(\"display\",\"none\"),e.writeStyles();var g=i.getTooltip_AsString();g&&e.writeAttributeEscaped(\"title\",g),e.write(\"><div\"),e.addClass(\"sapUiTableColCell\"),e.writeAttribute(\"id\",C+\"-inner\"),e.writeClasses();var u=d.getTextAlign(i.getHAlign(),l&&l.getTextDirection&&l.getTextDirection());u&&e.addStyle(\"text-align\",u),e.writeStyles(),e.write(\">\"),l&&e.renderControl(l),e.write(\"</div></td>\")},o.renderColRsz=function(e,t){e.write(\"<div\"),e.writeAttribute(\"id\",t.getId()+\"-rsz\"),e.addClass(\"sapUiTableColRsz\"),e.writeClasses(),e.write(\"></div>\")},o.renderRowHdr=function(e,t){e.write(\"<div\"),e.writeAttribute(\"id\",t.getId()+\"-sapUiTableRowHdrScr\"),e.addClass(\"sapUiTableRowHdrScr\"),e.addClass(\"sapUiTableNoOpacity\"),e.writeClasses(),t._getAccRenderExtension().writeAriaAttributesFor(e,t,\"ROWHEADER_COL\"),e.write(\">\");for(var i=0,r=t.getRows().length;i<r;i++)this.renderRowAddon(e,t,t.getRows()[i],i,!0);e.write(\"</div>\")},o.renderRowActions=function(e,t){if(a.hasRowActions(t)){e.write(\"<div\"),e.writeAttribute(\"id\",t.getId()+\"-sapUiTableRowActionScr\"),e.addClass(\"sapUiTableRowActionScr\"),e.addClass(\"sapUiTableNoOpacity\"),e.writeClasses(),e.write(\">\");for(var i=0,r=t.getRows().length;i<r;i++)this.renderRowAddon(e,t,t.getRows()[i],i,!1);e.write(\"</div>\")}},o._addFixedRowCSSClasses=function(e,t,i){var r=t.getFixedRowCount(),d=a.getFirstFixedButtomRowIndex(t);r>0&&(i<r&&e.addClass(\"sapUiTableFixedTopRow\"),i==r-1&&e.addClass(\"sapUiTableFixedLastTopRow\")),d>=0&&d===i?e.addClass(\"sapUiTableFixedFirstBottomRow\"):d>=1&&d-1===i&&e.addClass(\"sapUiTableFixedPreBottomRow\")},o.renderRowAddon=function(e,t,i,r,d){e.write(\"<div\"),e.writeAttribute(\"id\",t.getId()+(d?\"-rowsel\":\"-rowact\")+r),e.writeAttribute(\"data-sap-ui-related\",i.getId()),e.writeAttribute(\"data-sap-ui-rowindex\",r),e.addClass(d?\"sapUiTableRowHdr\":\"sapUiTableRowAction\"),r%2!=0&&t.getAlternateRowColors()&&!a.Grouping.isTreeMode(t)&&e.addClass(\"sapUiTableRowAlternate\"),this._addFixedRowCSSClasses(e,t,r);var s=!1,l=!1;if(i._bHidden?(e.addClass(\"sapUiTableRowHidden\"),l=!0):t.isIndexSelected(i.getIndex())&&(e.addClass(\"sapUiTableRowSel\"),s=!0),e.writeClasses(),t.getRowHeight()>0&&e.addStyle(\"height\",t._getDefaultRowHeight()+\"px\"),e.writeAttribute(\"tabindex\",\"-1\"),t._getAccRenderExtension().writeAriaAttributesFor(e,t,d?\"ROWHEADER\":\"ROWACTION\",{rowSelected:s,rowHidden:l}),e.writeStyles(),e.write(\">\"),d)this.writeRowHighlightContent(e,t,i,r),this.writeRowSelectorContent(e,t,i,r);else{var n=i.getAggregation(\"_rowAction\");n&&e.renderControl(n)}e.write(\"</div>\")},o.renderTableCtrl=function(e,t){t.getFixedColumnCount()>0&&(e.write(\"<div\"),e.writeAttribute(\"id\",t.getId()+\"-sapUiTableCtrlScrFixed\"),e.addClass(\"sapUiTableCtrlScrFixed\"),e.writeClasses(),e.write(\">\"),this.renderTableControl(e,t,!0),e.write(\"</div>\")),e.write(\"<div\"),e.writeAttribute(\"id\",t.getId()+\"-sapUiTableCtrlScr\"),e.addClass(\"sapUiTableCtrlScr\"),e.writeClasses(),t.getFixedColumnCount()>0&&(t._bRtlMode?e.addStyle(\"margin-right\",\"0\"):e.addStyle(\"margin-left\",\"0\"),e.writeStyles()),e.write(\">\"),e.write(\"<div\"),e.writeAttribute(\"id\",t.getId()+\"-tableCtrlCnt\"),e.addClass(\"sapUiTableCtrlCnt\"),e.writeClasses();var i=t.getVisibleRowCountMode();if(t._iTableRowContentHeight&&(i==n.Fixed||i==n.Interactive)){var r=\"height\";t.getVisibleRowCountMode()==n.Fixed&&(r=\"min-height\"),e.addStyle(r,t._iTableRowContentHeight+\"px\"),e.writeStyles()}e.write(\">\"),this.renderTableControl(e,t,!1),e.write(\"</div></div>\")},o.renderTableControl=function(e,t,i){var r,a;i?(r=0,a=t.getFixedColumnCount()):(r=t.getFixedColumnCount(),a=t.getColumns().length);var d=t.getFixedRowCount(),s=t.getFixedBottomRowCount(),l=t.getRows();d>0&&this.renderTableControlCnt(e,t,i,r,a,!0,!1,0,d),this.renderTableControlCnt(e,t,i,r,a,!1,!1,d,l.length-s),s>0&&l.length>0&&this.renderTableControlCnt(e,t,i,r,a,!1,!0,l.length-s,l.length)},o.renderTableControlCnt=function(e,t,r,d,s,l,n,o,w,C){e.write(\"<table\");var b=C?\"-header\":\"-table\",g=t.getId()+b;r?(g+=\"-fixed\",e.addClass(\"sapUiTableCtrlFixed\")):e.addClass(\"sapUiTableCtrlScroll\"),l?(g+=\"-fixrow\",e.addClass(\"sapUiTableCtrlRowFixed\")):n?(g+=\"-fixrow-bottom\",e.addClass(\"sapUiTableCtrlRowFixedBottom\")):e.addClass(\"sapUiTableCtrlRowScroll\"),e.writeAttribute(\"id\",g),t._getAccRenderExtension().writeAriaAttributesFor(e,t,C?\"COLUMNHEADER_TABLE\":\"TABLE\"),e.addClass(\"sapUiTableCtrl\"),C&&e.addClass(\"sapUiTableCHT\"),e.writeClasses(),e.addStyle(\"min-width\",t._getColumnsWidth(d,s)+\"px\"),r&&(i.browser.firefox||i.browser.chrome||i.browser.safari)&&e.addStyle(\"width\",t._getColumnsWidth(d,s)+\"px\"),e.writeStyles(),e.write(\">\"),e.write(\"<thead>\"),e.write(\"<tr\"),e.addClass(\"sapUiTableCtrlCol\"),0==o&&e.addClass(\"sapUiTableCtrlFirstCol\"),C&&e.addClass(\"sapUiTableCHTHR\"),e.writeClasses(),e.write(\">\");var u,c,T=t.getColumns(),A=new Array(s),p=!1,h=!r&&s>d;for(u=d;u<s;u++){c=T[u];var R={shouldRender:!(!c||!c.shouldRender())};if(R.shouldRender){var x=c.getWidth();a.isVariableWidth(x)&&(h=!1,r?x=(c._iFixWidth||160)+\"px\":x&&x.indexOf(\"%\")>0&&(p=!0)),R.width=x}A[u]=R}for(a.hasRowHeader(t)&&!C?(e.write(\"<th\"),p?e.addStyle(\"width\",\"0%\"):e.addStyle(\"width\",\"0px\"),e.writeStyles(),0==o&&(t._getAccRenderExtension().writeAriaAttributesFor(e,t,\"TH\"),C||e.writeAttribute(\"id\",t.getId()+\"-colsel\"),e.addClass(\"sapUiTableColSel\"),e.writeClasses()),e.write(\"></th>\")):0===T.length&&e.write(\"<th></th>\"),u=d;u<s;u++)b=C?\"_hdr\":\"_col\",c=T[u],R=A[u],R.shouldRender&&(e.write(\"<th\"),R.width&&(e.addStyle(\"width\",R.width),e.writeStyles()),0==o&&(t._getAccRenderExtension().writeAriaAttributesFor(e,t,\"TH\",{column:c}),e.writeAttribute(\"id\",t.getId()+b+u)),e.writeAttribute(\"data-sap-ui-headcolindex\",u),e.writeAttribute(\"data-sap-ui-colid\",c.getId()),e.write(\">\"),0!=o||0!=a.getHeaderRowCount(t)||C||(c.getMultiLabels().length>0?e.renderControl(c.getMultiLabels()[0]):e.renderControl(c.getLabel())),e.write(\"</th>\"));h&&(e.write(\"<th\"),C&&e.writeAttribute(\"id\",t.getId()+\"-dummycolhdr\"),t._getAccRenderExtension().writeAriaAttributesFor(e,t,\"PRESENTATION\"),e.write(\"></th>\")),e.write(\"</tr>\"),e.write(\"</thead>\"),e.write(\"<tbody>\");var v,S,U=t._getVisibleColumns(),E=t.getRows();if(C)for(v=o,S=w;v<S;v++)this.renderColumnHeaderRow(e,t,v,r,d,s,h);else{var H=t._getAccExtension().getAriaTextsForSelectionMode(!0),f=a.isRowSelectionAllowed(t),_=t.getDragDropConfig().some(function(e){return e.getMetadata().isInstanceOf(\"sap.ui.core.dnd.IDragInfo\")&&\"rows\"===e.getSourceAggregation()});for(v=o,S=w;v<S;v++)this.renderTableRow(e,t,E[v],v,r,d,s,!1,U,h,H,f,_)}e.write(\"</tbody>\"),e.write(\"</table>\")},o.addTrClasses=function(e,t,i,r){},o.writeRowSelectorContent=function(e,t,i,r){if(t._getAccRenderExtension().writeAccRowSelectorText(e,t,i,r),a.Grouping.isGroupMode(t)&&(e.write(\"<div\"),e.writeAttribute(\"class\",\"sapUiTableGroupShield\"),e.write(\"></div>\"),e.write(\"<div\"),e.writeAttribute(\"id\",i.getId()+\"-groupHeader\"),e.writeAttribute(\"class\",\"sapUiTableGroupIcon\"),e.write(\"></div>\"),a.Grouping.showGroupMenuButton(t))){var d=s.getIconInfo(\"sap-icon://drop-down-list\");e.write(\"<div class='sapUiTableGroupMenuButton'>\"),e.writeEscaped(d.content),e.write(\"</div>\")}},o.writeRowHighlightContent=function(e,t,i,r){if(a.hasRowHighlights(t)){var d=i.getAggregation(\"_settings\"),s=d._getHighlightCSSClassName();e.write(\"<div\"),e.writeAttribute(\"id\",i.getId()+\"-highlight\"),e.addClass(\"sapUiTableRowHighlight\"),e.addClass(s),e.writeClasses(),e.write(\">\"),t._getAccRenderExtension().writeAccRowHighlightText(e,t,i,r),e.write(\"</div>\")}},o.renderColumnHeaderRow=function(e,t,i,r,d,s,l){function n(e,t,r){var d,s=a.Column.getHeaderSpan(e,i);C<1?(s>1&&(d=e.getIndex(),s=r.slice(t+1,t+s).reduce(function(e,t){return t.getIndex()-d<s?e+1:e},1)),e._nSpan=C=s,b=t):e._nSpan=0,C--}function o(a,d){this.renderCol(e,t,a,i,a._nSpan,r&&d==b),a._nSpan=void 0}e.write(\"<tr\"),e.addClass(\"sapUiTableColHdrTr\"),e.writeClasses(),t._getAccRenderExtension().writeAriaAttributesFor(e,t,\"COLUMNHEADER_ROW\"),e.write(\">\");var w,C=0,b=-1;w=t.getColumns().slice(d,s).filter(function(e){return!!e&&e.shouldRender()}),w.forEach(n),w.forEach(o.bind(this)),!r&&l&&w.length>0&&(e.write('<td class=\"sapUiTableTDDummy\"'),t._getAccRenderExtension().writeAriaAttributesFor(e,t,\"PRESENTATION\"),e.write(\"></td>\")),e.write(\"</tr>\")},o.renderTableRow=function(e,t,i,r,d,s,l,n,o,w,C,b,g){if(i){e.write(\"<tr\"),i._bDummyRow&&e.addStyle(\"opacity\",\"0\"),e.addClass(\"sapUiTableTr\"),d?(e.writeAttribute(\"id\",i.getId()+\"-fixed\"),e.writeAttribute(\"data-sap-ui-related\",i.getId())):e.writeElementData(i),i._bHidden?e.addClass(\"sapUiTableRowHidden\"):(g&&d&&e.writeAttribute(\"draggable\",!0),t.isIndexSelected(i.getIndex())&&e.addClass(\"sapUiTableRowSel\"),this.addTrClasses(e,t,i,r)),r%2!=0&&t.getAlternateRowColors()&&!a.Grouping.isTreeMode(t)&&e.addClass(\"sapUiTableRowAlternate\");var u=t.getRows(),c=u.length;c>0&&u[c-1]===i?e.addClass(\"sapUiTableLastRow\"):c>0&&u[0]===i&&e.addClass(\"sapUiTableFirstRow\"),this._addFixedRowCSSClasses(e,t,r),e.writeClasses(),e.writeAttribute(\"data-sap-ui-rowindex\",r),t.getRowHeight()>0&&e.addStyle(\"height\",t._getDefaultRowHeight()+\"px\"),e.writeStyles(),t._getAccRenderExtension().writeAriaAttributesFor(e,t,\"TR\",{index:r}),e.write(\">\");var T=i.getCells();(a.hasRowHeader(t)||0===T.length)&&(e.write(\"<td\"),t._getAccRenderExtension().writeAriaAttributesFor(e,t,\"ROWHEADER_TD\",{rowSelected:!i._bHidden&&t.isIndexSelected(i.getIndex()),index:r}),e.write(\"></td>\"));for(var A=0,p=T.length;A<p;A++)this.renderTableCell(e,t,i,T[A],A,d,s,l,o);!d&&w&&T.length>0&&(e.write('<td class=\"sapUiTableTDDummy\"'),t._getAccRenderExtension().writeAriaAttributesFor(e,t,\"PRESENTATION\"),e.write(\"></td>\")),e.write(\"</tr>\")}},o.renderTableCell=function(e,t,i,r,s,l,o,w,C){var b=r.data(\"sap-ui-colindex\"),g=t.getColumns()[b];if(g.shouldRender()&&o<=b&&w>b){e.write(\"<td\");var u=i.getId()+\"-col\"+s;e.writeAttribute(\"id\",u),e.writeAttribute(\"tabindex\",\"-1\"),e.writeAttribute(\"data-sap-ui-colid\",g.getId());var c=C.length,T=c>0&&C[0]===g,A=c>0&&C[c-1]===g;t._getAccRenderExtension().writeAriaAttributesFor(e,t,\"DATACELL\",{index:b,column:g,row:i,fixed:l,firstCol:T});var p=d.getTextAlign(g.getHAlign(),r&&r.getTextDirection&&r.getTextDirection());p&&e.addStyle(\"text-align\",p),e.writeStyles(),e.addClass(\"sapUiTableTd\"),T&&e.addClass(\"sapUiTableTdFirst\"),A&&e.addClass(\"sapUiTableTdLast\"),g.getGrouped()&&e.addClass(\"sapUiTableTdGroup\");var h=t.getBinding(\"rows\");h&&g.getLeadingProperty&&h.isMeasure(g.getLeadingProperty())&&e.addClass(\"sapUiTableMeasureCell\"),e.writeClasses(),e.write(\"><div\"),e.addClass(\"sapUiTableCell\"),T&&a.Grouping.isTreeMode(t)&&e.addClass(\"sapUiTableCellFlex\"),e.writeClasses(),t.getRowHeight()&&t.getVisibleRowCountMode()==n.Auto&&e.addStyle(\"max-height\",t.getRowHeight()+\"px\"),e.writeStyles(),e.write(\">\"),this.renderTableCellControl(e,t,r,T),e.write(\"</div></td>\")}},o.renderTableCellControl=function(e,t,i,r){if(r&&a.Grouping.isTreeMode(t)&&!t._bFlatMode){var d=i.getParent();e.write(\"<span class='sapUiTableTreeIcon' tabindex='-1' id='\"+d.getId()+\"-treeicon'\"),t._getAccRenderExtension().writeAriaAttributesFor(e,t,\"TREEICON\",{row:d}),e.write(\"></span>\")}e.renderControl(i)},o.renderVSb=function(e,t){var i=t._getScrollExtension();e.write(\"<div\"),e.addClass(\"sapUiTableVSbBg\"),e.writeAttribute(\"id\",t.getId()+\"-vsb-bg\"),e.writeClasses(),e.write(\"></div>\"),e.write(\"<div\"),e.addClass(\"sapUiTableVSb\"),e.writeClasses(),e.writeAttribute(\"id\",t.getId()+\"-vsb\"),e.writeAttribute(\"tabindex\",\"-1\"),e.addStyle(\"max-height\",i.getVerticalScrollbarHeight()+\"px\"),t.getFixedRowCount()>0&&(t._iVsbTop=t.getFixedRowCount()*t._getDefaultRowHeight()-1,e.addStyle(\"top\",t._iVsbTop+\"px\")),e.writeStyles(),e.write(\">\"),e.write(\"<div\"),e.writeAttribute(\"id\",t.getId()+\"-vsb-content\"),e.addClass(\"sapUiTableVSbContent\"),e.writeClasses(),e.addStyle(\"height\",i.getVerticalScrollHeight()+\"px\"),e.writeStyles(),e.write(\">\"),e.write(\"</div>\"),e.write(\"</div>\")},o.renderHSb=function(e,t){e.write(\"<div\"),e.addClass(\"sapUiTableHSbBg\"),e.writeAttribute(\"id\",t.getId()+\"-hsb-bg\"),e.writeClasses(),e.write(\"></div>\"),e.write(\"<div\"),e.addClass(\"sapUiTableHSb\"),e.writeClasses(),e.writeAttribute(\"id\",t.getId()+\"-hsb\"),e.writeAttribute(\"tabindex\",\"-1\"),e.write(\">\"),e.write(\"<div\"),e.writeAttribute(\"id\",t.getId()+\"-hsb-content\"),e.addClass(\"sapUiTableHSbContent\"),e.writeClasses(),e.write(\">\"),e.write(\"</div>\"),e.write(\"</div>\")},o.renderTabElement=function(e,t){e.write(\"<div\"),t&&(e.addClass(t),e.writeClasses()),e.writeAttribute(\"tabindex\",\"0\"),e.write(\"></div>\")},o},!0);",
	"sap/ui/table/TableRendererUtils.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/core/Control\"],function(e,t){\"use strict\";var r=null,n={addClass:function(e,t,a){return t&&(a||2==arguments.length)&&(e.addClass(t),r&&(r.writeClasses=!0)),n},addStyle:function(e,t,a,i){return t&&a&&(i||3==arguments.length)&&(e.addStyle(t,a),r&&(r.writeStyles=!0)),n},startElement:function(a,i,s){if(s=s||{},a.write(\"<\",s.tag||\"div\"),r=s,s.furtherSettings&&s.furtherSettings(a,i),e.isArray(s.classname)&&s.classname.length)for(var l=0;l<s.classname.length;l++)n.addClass(a,s.classname[l]);else s.classname&&n.addClass(a,s.classname);if(s.id?a.writeAttribute(\"id\",(s.element||i).getId()+\"-\"+s.id):s.element&&(s.element instanceof t?a.writeControlData(s.element):a.writeElementData(s.element)),s.attributes)for(var u in s.attributes)s.attributes.hasOwnProperty(u)&&a.writeAttribute(u,s.attributes[u]);return\"number\"==typeof s.tabindex&&a.writeAttribute(\"tabindex\",\"\"+s.tabindex),s.aria&&i._getAccRenderExtension().writeAriaAttributesFor(a,i,s.aria,s.ariaconfig),r.writeClasses&&a.writeClasses(),r.writeStyles&&a.writeStyles(),r=null,a.write(\">\"),n},endElement:function(e,t){return e.write(\"</\",t||\"div\",\">\"),n},renderElement:function(e,t,r){return n.startElement(e,t,r),n.endElement(e,r?r.tag:null),n}};return n},!0);",
	"sap/ui/table/TableScrollExtension.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"./TableExtension\",\"./TableUtils\",\"sap/ui/Device\",\"./library\",\"jquery.sap.trace\",\"jquery.sap.events\"],function(e,t,l,o,r){\"use strict\";var i=r.SharedDomRef,n={onScroll:function(t){var l=this._getScrollExtension();if(e.sap.interaction.notifyScrollEvent&&e.sap.interaction.notifyScrollEvent(t),!this._bOnAfterRendering){var o=t.target.scrollLeft;if(o!==t.target._scrollLeft){var r=n.getScrollAreas(this);t.target._scrollLeft=o;for(var i=0;i<r.length;i++){var a=r[i];a!==t.target&&a.scrollLeft!==o&&(a.scrollLeft=o,a._scrollLeft=o)}l._iHorizontalScrollPosition=o}}},restoreScrollPosition:function(t){var l=t._getScrollExtension(),o=l.getHorizontalScrollbar();if(null!==o&&null!==l._iHorizontalScrollPosition){for(var r=n.getScrollAreas(t),i=0;i<r.length;i++){delete r[i]._scrollLeft}if(o.scrollLeft!==l._iHorizontalScrollPosition)o.scrollLeft=l._iHorizontalScrollPosition;else{var a=e.Event(\"scroll\");a.target=o,n.onScroll.call(t,a)}}},addEventListeners:function(e){var t=e._getScrollExtension(),l=n.getScrollAreas(e);null==t._onHorizontalScrollEventHandler&&(t._onHorizontalScrollEventHandler=n.onScroll.bind(e));for(var o=0;o<l.length;o++)l[o].addEventListener(\"scroll\",t._onHorizontalScrollEventHandler)},removeEventListeners:function(e){var t=e._getScrollExtension(),l=n.getScrollAreas(e);if(null!=t._onHorizontalScrollEventHandler){for(var o=0;o<l.length;o++)l[o].removeEventListener(\"scroll\",t._onHorizontalScrollEventHandler),delete l[o]._scrollLeft;delete t._onHorizontalScrollEventHandler}},getScrollAreas:function(e){return[e._getScrollExtension().getHorizontalScrollbar(),e.getDomRef(\"sapUiTableColHdrScr\"),e.getDomRef(\"sapUiTableCtrlScr\")].filter(function(e){return null!=e})}},a={onScroll:function(t){var l=this._getScrollExtension();if(e.sap.interaction.notifyScrollEvent&&e.sap.interaction.notifyScrollEvent(t),l._bIsScrolledVerticallyByKeyboard||a.isUpdatePending(this))return void e.sap.log.debug(\"sap.ui.table.TableScrollExtension\",\"Vertical scroll event handler aborted: \"+(l._bIsScrolledVerticallyByKeyboard?\"Scrolled by keyboard\":\"Waiting for pending update\"),this);this._getKeyboardExtension().setActionMode(!1);var o=t.target.scrollTop;o!==t.target._scrollTop&&(e.sap.log.debug(\"sap.ui.table.TableScrollExtension\",\"Scroll position changed by setting scrollTop: From \"+l._nVerticalScrollPosition+\" to \"+o,this),delete t.target._scrollTop,l._nVerticalScrollPosition=o,l._iFirstVisibleRowInBuffer=null),e.sap.clearDelayedCall(this._mTimeouts.largeDataScrolling),delete this._mTimeouts.largeDataScrolling,this._bLargeDataScrolling&&!l._bIsScrolledVerticallyByWheel?this._mTimeouts.largeDataScrolling=e.sap.delayedCall(300,this,function(){delete this._mTimeouts.largeDataScrolling,a.updateFirstVisibleRow(this)}):a.updateFirstVisibleRow(this),l._bIsScrolledVerticallyByWheel=!1},updateFirstVisibleRow:function(t){var o=t._getScrollExtension(),r=o.getRowIndexAtCurrentScrollPosition(),i=t.getFirstVisibleRow(),n=r<0,a=i>=t._getMaxFirstRenderedRowIndex();r===i||n&&a?l.isVariableRowHeightEnabled(t)&&(e.sap.log.debug(\"sap.ui.table.TableScrollExtension\",\"updateFirstVisibleRow: Update inner vertical scroll position\",t),o.updateInnerVerticalScrollPosition()):(n&&(r=t._getMaxFirstRenderedRowIndex()),e.sap.log.debug(\"sap.ui.table.TableScrollExtension\",\"updateFirstVisibleRow: From \"+i+\" to \"+r,t),t.setFirstVisibleRow(r,!0),t._bIgnoreOnRowsUpdatedOnScroll=!0,t.attachEventOnce(\"_rowsUpdated\",function(){o.updateInnerVerticalScrollPosition(),delete t._bIgnoreOnRowsUpdatedOnScroll}))},onScrollbarMouseDown:function(e){var t=this._getScrollExtension();t._bIsScrolledVerticallyByWheel=!1,t._bIsScrolledVerticallyByKeyboard=!1},onRowsUpdated:function(e){if(!this._bIgnoreOnRowsUpdatedOnScroll&&l.isVariableRowHeightEnabled(this)){var t=e.getParameters().reason,o=this._getScrollExtension(),r=this.getFirstVisibleRow()-this._getMaxFirstRenderedRowIndex();r>=0&&(t===l.RowsUpdateReason.Expand||t===l.RowsUpdateReason.Collapse)&&(o._iFirstVisibleRowInBuffer=r,o.updateInnerVerticalScrollPosition())}},restoreScrollPosition:function(e){var t=e._getScrollExtension();t.updateVerticalScrollPosition(t._nVerticalScrollPosition)},addEventListeners:function(e){var t=e._getScrollExtension(),l=a.getScrollAreas(e),o=t.getVerticalScrollbar();null==t._onVerticalScrollEventHandler&&(t._onVerticalScrollEventHandler=a.onScroll.bind(e));for(var r=0;r<l.length;r++)l[r].addEventListener(\"scroll\",t._onVerticalScrollEventHandler);null!==o&&(null==t._onVerticalScrollbarMouseDownEventHandler&&(t._onVerticalScrollbarMouseDownEventHandler=a.onScrollbarMouseDown.bind(e)),o.addEventListener(\"mousedown\",t._onVerticalScrollbarMouseDownEventHandler)),e.attachEvent(\"_rowsUpdated\",a.onRowsUpdated)},removeEventListeners:function(e){var t=e._getScrollExtension(),l=a.getScrollAreas(e),o=t.getVerticalScrollbar();if(null!=t._onVerticalScrollEventHandler){for(var r=0;r<l.length;r++)l[r].removeEventListener(\"scroll\",t._onVerticalScrollEventHandler);delete t._onVerticalScrollEventHandler}null!==o&&null!=t._onVerticalScrollbarMouseDownEventHandler&&(o.removeEventListener(\"mousedown\",t._onVerticalScrollbarMouseDownEventHandler),delete t._onVerticalScrollbarMouseDownEventHandler),e.detachEvent(\"_rowsUpdated\",a.onRowsUpdated)},isUpdatePending:function(e){return null!=e&&(null!=e._mAnimationFrames.verticalScrollUpdate||null!=e._mTimeouts.verticalScrollUpdate)},getScrollAreas:function(e){return[e._getScrollExtension().getVerticalScrollbar()].filter(function(e){return null!=e})}},s={onMouseWheelScrolling:function(e){var t=this._getScrollExtension(),o=Math.abs(e.deltaY)>Math.abs(e.deltaX),r=o?e.deltaY:e.deltaX,i=o&&e.shiftKey||!o,n=r>0,a=!1;if(0!==r)if(i){var s=t.getHorizontalScrollbar();if(e.deltaMode>0){var c=l.Column.getMinColumnWidth();r=n?c:-c}a=n?s.scrollLeft===s.scrollWidth-s.offsetWidth:0===s.scrollLeft,t.isHorizontalScrollbarVisible()&&!a&&(s.scrollLeft=s.scrollLeft+r),e.preventDefault(),e.stopPropagation()}else{var u=t.getVerticalScrollbar();if(1===e.deltaMode?r*=t.getVerticalScrollRangeRowFraction():2===e.deltaMode&&(r*=t.getVerticalScrollRangeRowFraction()*this.getVisibleRowCount()),a=n?u.scrollTop===u.scrollHeight-u.offsetWidth:0===u.scrollTop,t.isVerticalScrollbarVisible()&&!a){e.preventDefault(),e.stopPropagation();var d=t.getVerticalScrollPosition(),g=r,h=t.getVerticalScrollRangeRowFraction();if(t.isVerticalScrollPositionInBuffer()){if(!n){var S=d-this._getFirstRenderedRowIndex()*h;S<=0?g=-t.getVerticalScrollRangeRowFraction():S+g<0&&(g=-S)}}else{var b=r/this._getDefaultRowHeight();b>1?b=Math.floor(b):b<-1&&(b=Math.ceil(b)),g=b*h}t._bIsScrolledVerticallyByWheel=!0,t._bIsScrolledVerticallyByKeyboard=!1,t.updateVerticalScrollPosition(d+g)}}},onTouchStart:function(e){if(\"touchstart\"===e.type||\"touch\"===e.pointerType){var t=this._getScrollExtension(),l=t.getHorizontalScrollbar(),o=t.getVerticalScrollbar(),r=e.touches?e.touches[0]:e;t._mTouchSessionData={initialPageX:r.pageX,initialPageY:r.pageY,initialScrollTop:null==o?0:o.scrollTop,initialScrollLeft:null==l?0:l.scrollLeft,initialScrolledToEnd:null,touchMoveDirection:null}}},onTouchMoveScrolling:function(e){if(\"touchmove\"===e.type||\"touch\"===e.pointerType){var t=this._getScrollExtension(),l=t._mTouchSessionData;if(null==l)return;var o=e.touches?e.touches[0]:e,r=o.pageX-l.initialPageX,i=o.pageY-l.initialPageY,n=!1,a=!1;if(null===l.touchMoveDirection){if(0===r&&0===i)return;l.touchMoveDirection=Math.abs(r)>Math.abs(i)?\"horizontal\":\"vertical\"}switch(l.touchMoveDirection){case\"horizontal\":var s=t.getHorizontalScrollbar();null!=s&&(n=r<0?s.scrollLeft===s.scrollWidth-s.offsetWidth:0===s.scrollLeft,null===l.initialScrolledToEnd&&(l.initialScrolledToEnd=n),n||l.initialScrolledToEnd||(s.scrollLeft=l.initialScrollLeft-r,a=!0));break;case\"vertical\":var c=t.getVerticalScrollbar();null!=c&&(n=i<0?c.scrollTop===c.scrollHeight-c.offsetHeight:0===c.scrollTop,null===l.initialScrolledToEnd&&(l.initialScrolledToEnd=n),n||l.initialScrolledToEnd||(c.scrollTop=l.initialScrollTop-i,a=!0))}a&&e.preventDefault()}},addEventListeners:function(e){var t=e._getScrollExtension(),l=s.getEventListenerTargets(e);null==t._onMouseWheelEventHandler&&(t._onMouseWheelEventHandler=s.onMouseWheelScrolling.bind(e)),null==t._onTouchStartEventHandler&&(t._onTouchStartEventHandler=s.onTouchStart.bind(e)),null==t._onTouchMoveEventHandler&&(t._onTouchMoveEventHandler=s.onTouchMoveScrolling.bind(e));for(var r=0;r<l.length;r++)l[r].addEventListener(\"wheel\",t._onMouseWheelEventHandler),o.support.pointer&&o.system.desktop?(l[r].addEventListener(\"pointerdown\",t._onTouchStartEventHandler),l[r].addEventListener(\"pointermove\",t._onTouchMoveEventHandler,!!o.browser.chrome&&{passive:!0})):o.support.touch&&(l[r].addEventListener(\"touchstart\",t._onTouchStartEventHandler),l[r].addEventListener(\"touchmove\",t._onTouchMoveEventHandler))},removeEventListeners:function(e){for(var t=e._getScrollExtension(),l=s.getEventListenerTargets(e),r=0;r<l.length;r++)null!=t._onMouseWheelEventHandler&&l[r].removeEventListener(\"wheel\",t._onMouseWheelEventHandler),null!=t._onTouchStartEventHandler&&null!=t._onTouchMoveEventHandler&&(o.support.pointer&&o.system.desktop?(l[r].removeEventListener(\"pointerdown\",t._onTouchStartEventHandler),l[r].removeEventListener(\"pointermove\",t._onTouchMoveEventHandler,!!o.browser.chrome&&{passive:!0})):o.support.touch&&(l[r].removeEventListener(\"touchstart\",t._onTouchStartEventHandler),l[r].removeEventListener(\"touchmove\",t._onTouchMoveEventHandler)));delete t._onMouseWheelEventHandler,delete t._onTouchStartEventHandler,delete t._onTouchMoveEventHandler},getEventListenerTargets:function(e){return[e.getDomRef(\"tableCCnt\")].filter(function(e){return null!=e})}},c={onBeforeRendering:function(e){this._getScrollExtension()._clearCache()},onAfterRendering:function(e){var t=this._getScrollExtension();e&&e.isMarked(\"renderRows\")&&(t.updateVerticalScrollbarHeight(),t.updateVerticalScrollHeight()),a.restoreScrollPosition(this),n.restoreScrollPosition(this)},onfocusin:function(e){var t,o=l.getCellInfo(e.target);if(o.isOfType(l.CELLTYPE.DATACELL)?t=this.getDomRef(\"sapUiTableCtrlScr\"):o.isOfType(l.CELLTYPE.COLUMNHEADER)&&(t=this.getDomRef(\"sapUiTableColHdrScr\")),null!=t&&o.columnIndex>=this.getFixedColumnCount()){var r=o.cell[0],i=t.scrollLeft,n=t.clientWidth,a=r.offsetLeft,s=a+r.offsetWidth,c=a-i,u=s-n-i,d=this._getScrollExtension().getHorizontalScrollbar();c<0&&u<0?d.scrollLeft=i+c:u>0&&c>0&&(d.scrollLeft=i+u)}var g=l.getParentCell(this,e.target);null!=g&&Promise.resolve().then(function(){var e=g.find(\".sapUiTableCell\")[0];null!=e&&(e.scrollLeft=0,e.scrollTop=0)})}},u=t.extend(\"sap.ui.table.TableScrollExtension\",{_init:function(e,t,l){return this._delegate=c,this._oHorizontalScrollbar=null,this._iHorizontalScrollPosition=null,this._oVerticalScrollbar=null,this._nVerticalScrollPosition=null,this._iVerticalScrollHeight=null,this._iVerticalScrollbarHeight=null,this._iFirstVisibleRowInBuffer=null,this._bIsScrolledVerticallyByWheel=!1,this._bIsScrolledVerticallyByKeyboard=!1,this._mTouchSessionData=null,e.addEventDelegate(this._delegate,e),\"ScrollExtension\"},_attachEvents:function(){var e=this.getTable();n.addEventListeners(e),a.addEventListeners(e),s.addEventListeners(e)},_detachEvents:function(){var e=this.getTable();n.removeEventListeners(e),a.removeEventListeners(e),s.removeEventListeners(e)},_debug:function(){this._ScrollingHelper=s,this._ExtensionDelegate=c,this._HorizontalScrollingHelper=n,this._VerticalScrollingHelper=a},destroy:function(){var e=this.getTable();null!=e&&e.removeEventDelegate(this._delegate),this._delegate=null,this._clearCache(),t.prototype.destroy.apply(this,arguments)}});return u.prototype.scrollVertically=function(e,t,l){var o=this.getTable();if(null==o)return!1;null==e&&(e=!1),null==t&&(t=!1),null==l&&(l=!1);var r=!1,i=o._getTotalRowCount(),n=o.getVisibleRowCount(),a=n-o.getFixedRowCount()-o.getFixedBottomRowCount(),s=o.getFirstVisibleRow(),c=t?a:1;return e?s+n<i&&(o.setFirstVisibleRow(Math.min(s+c,i-n)),r=!0):s>0&&(o.setFirstVisibleRow(Math.max(s-c,0)),r=!0),r&&l&&(this._bIsScrolledVerticallyByKeyboard=!0),r},u.prototype.scrollVerticallyMax=function(e,t){var o=this.getTable();if(null==o)return!1;null==e&&(e=!1),null==t&&(t=!1);var r=!1,i=o.getFirstVisibleRow();if(e){var n=o._getTotalRowCount()-l.getNonEmptyVisibleRowCount(o);i<n&&(o.setFirstVisibleRow(n),r=!0)}else i>0&&(o.setFirstVisibleRow(0),r=!0);return r&&t&&(this._bIsScrolledVerticallyByKeyboard=!0),r},u.prototype.getHorizontalScrollbar=function(){var e=this.getTable();return null!=e&&null===this._oHorizontalScrollbar&&(this._oHorizontalScrollbar=e.getDomRef(i.HorizontalScrollBar)),this._oHorizontalScrollbar},u.prototype.getVerticalScrollbar=function(){var e=this.getTable();return null!=e&&null===this._oVerticalScrollbar&&(this._oVerticalScrollbar=e.getDomRef(i.VerticalScrollBar)),this._oVerticalScrollbar},u.prototype.isHorizontalScrollbarVisible=function(){var e=this.getTable(),t=null==e?null:e.getDomRef();return null!=t&&t.classList.contains(\"sapUiTableHScr\")},u.prototype.isVerticalScrollbarVisible=function(){var e=this.getTable(),t=null==e?null:e.getDomRef();return null!=t&&t.classList.contains(\"sapUiTableVScr\")},u.prototype.updateHorizontalScrollbar=function(e){var t=this.getTable(),l=this.getHorizontalScrollbar();if(null!=t&&null!=l&&null!=e){var r=t.$(),i=e.tableCtrlScrollWidth;o.browser.safari&&(i=Math.max(i,t._getColumnsWidth(t.getFixedColumnCount())));var n=i>e.tableCtrlScrWidth;if(n){if(!this.isHorizontalScrollbarVisible()&&(r.addClass(\"sapUiTableHScr\"),o.browser.safari)){r.find(\".sapUiTableCtrlScroll, .sapUiTableColHdrScr > .sapUiTableColHdr\").outerWidth(i)}var a=e.tableCtrlFixedWidth;r.find(\".sapUiTableRowHdrScr\").length>0&&(a+=e.tableRowHdrScrWidth),t.getRows().length>0&&(t._bRtlMode?(l.style.marginRight=a+\"px\",l.style.marginLeft=\"\"):(l.style.marginLeft=a+\"px\",l.style.marginRight=\"\"));var s=t.getDomRef(\"hsb-content\");s&&(s.style.width=i+\"px\")}!n&&this.isHorizontalScrollbarVisible()&&(r.removeClass(\"sapUiTableHScr\"),o.browser.safari&&r.find(\".sapUiTableCtrlScroll, .sapUiTableColHdr\").css(\"width\",\"\"))}},u.prototype.updateVerticalScrollbarHeight=function(){var e=this.getTable(),t=this.getVerticalScrollbar();if(null!=e&&null!=t){var l=this.getVerticalScrollbarHeight();t.style.maxHeight=l+\"px\",this._iVerticalScrollbarHeight!==l&&(this._iVerticalScrollbarHeight=l,this.updateVerticalScrollPosition())}},u.prototype.getVerticalScrollbarHeight=function(){var e=this.getTable();return null==e?0:Math.max(1,e.getVisibleRowCount()-e.getFixedRowCount()-e.getFixedBottomRowCount())*e._getDefaultRowHeight()},u.prototype.updateVerticalScrollbarPosition=function(){var e=this.getTable(),t=this.getVerticalScrollbar();if(null!=e&&null!=t){var l=e.getDomRef(\"tableCCnt\");if(l){var o=l.offsetTop;e.getDomRef(\"vsb-bg\").style.top=o+\"px\";e.getFixedRowCount()>0&&(o+=e._iVsbTop),t.style.top=o+\"px\"}}},u.prototype.updateVerticalScrollPosition=function(t){var l=this.getTable(),o=this.getVerticalScrollbar();if(null!=l&&null!=o&&this.isVerticalScrollbarRequired()){var r=this._nVerticalScrollPosition,i=0,n=this.getVerticalScrollRange();if(null==t){var s=l.getFirstVisibleRow(),c=l._getMaxFirstRenderedRowIndex();s>c?(this._nVerticalScrollPosition=this.getVerticalScrollRange(),this._iFirstVisibleRowInBuffer=s-c):(this._nVerticalScrollPosition=s*this.getVerticalScrollRangeRowFraction(),this._iFirstVisibleRowInBuffer=null)}else{var u=this.getVerticalScrollRange();this._nVerticalScrollPosition=Math.min(Math.max(0,t),u),this._iFirstVisibleRowInBuffer=null}e.sap.log.debug(\"sap.ui.table.TableScrollExtension\",\"updateVerticalScrollPosition: From \"+r+\" to \"+this._nVerticalScrollPosition+\" (diff: \"+(this._nVerticalScrollPosition-r)+\")\",l),i=this._nVerticalScrollPosition>0&&this._nVerticalScrollPosition<.5?1:this._nVerticalScrollPosition>=n-.5&&this._nVerticalScrollPosition<n?n-1:Math.round(this._nVerticalScrollPosition),o.scrollTop!==i?(null!=l._mAnimationFrames.verticalScrollUpdate&&window.cancelAnimationFrame(l._mAnimationFrames.verticalScrollUpdate),e.sap.clearDelayedCall(l._mTimeouts.verticalScrollUpdate),delete l._mTimeouts.verticalScrollUpdate,e.sap.log.debug(\"sap.ui.table.TableScrollExtension\",\"updateVerticalScrollPosition: scrollTop will be set asynchronously\",l),l._mAnimationFrames.verticalScrollUpdate=window.requestAnimationFrame(function(){var t=o.scrollTop;delete l._mAnimationFrames.verticalScrollUpdate,e.sap.log.debug(\"sap.ui.table.TableScrollExtension\",\"updateVerticalScrollPosition: (async) Set scrollTop from \"+t+\" to \"+i,l),o.scrollTop=i,o._scrollTop=o.scrollTop,o.scrollTop===t&&a.updateFirstVisibleRow(l)})):this._nVerticalScrollPosition!==r?(null!=l._mAnimationFrames.verticalScrollUpdate&&(window.cancelAnimationFrame(l._mAnimationFrames.verticalScrollUpdate),delete l._mAnimationFrames.verticalScrollUpdate),e.sap.clearDelayedCall(l._mTimeouts.verticalScrollUpdate),e.sap.log.debug(\"sap.ui.table.TableScrollExtension\",\"updateVerticalScrollPosition: firstVisibleRow will be set asynchronously\",l),l._mTimeouts.verticalScrollUpdate=e.sap.delayedCall(0,this,function(){delete l._mTimeouts.verticalScrollUpdate,a.updateFirstVisibleRow(l)})):(e.sap.log.debug(\"sap.ui.table.TableScrollExtension\",\"updateVerticalScrollPosition: scrollTop and nVerticalScrollPosition not changed -> update inner vertical scroll position\",l),this.updateInnerVerticalScrollPosition())}},u.prototype.updateVerticalScrollHeight=function(){var e=this.getTable(),t=null==e?null:e.getDomRef(\"vsb-content\");if(null!=t){var l=this.getVerticalScrollHeight(!0);t.style.height=this.getVerticalScrollHeight()+\"px\",this._iVerticalScrollHeight!==l&&(this._iVerticalScrollHeight=l,this.updateVerticalScrollPosition())}},u.prototype.getVerticalScrollHeight=function(e){var t=this.getTable();if(null==t)return 0;var o,r,i=t._getTotalRowCount(),n=t.getVisibleRowCount(),a=t._getDefaultRowHeight();return l.isVariableRowHeightEnabled(t)?(o=Math.max(i,n+1),r=a*(o-1)+this.getVerticalScrollRangeBuffer()):(o=Math.max(i,n),r=a*o),!0===e?r:Math.min(1e6,r)},u.prototype.updateVerticalScrollbarVisibility=function(){var e=this.getTable(),t=null==e?null:e.getDomRef(),l=this.getVerticalScrollbar();if(null!=t&&null!=l){var o=this.isVerticalScrollbarRequired();o&&!this.isVerticalScrollbarVisible()&&(t.classList.add(\"sapUiTableVScr\"),this.updateVerticalScrollPosition(0)),!o&&this.isVerticalScrollbarVisible()&&t.classList.remove(\"sapUiTableVScr\")}},u.prototype.isVerticalScrollbarRequired=function(){var e=this.getTable();return null!=e&&(this.getInnerVerticalScrollRange()>0||e._getTotalRowCount()>e.getVisibleRowCount())},u.prototype.getRowIndexAtCurrentScrollPosition=function(){var e=this.getTable();if(null==e)return-1;var t=e._getMaxFirstVisibleRowIndex();if(0===t)return 0;var o=this.getVerticalScrollPosition(),r=this.getVerticalScrollRange(),i=this.getVerticalScrollRangeRowFraction();if(l.isVariableRowHeightEnabled(e))return this.isVerticalScrollPositionInBuffer()?-1:Math.min(t,Math.floor(o/i));var n=Math.floor(o/i),a=r-o,s=null==this.getVerticalScrollbar()._scrollTop,c=a<1;return c&&s&&(this._nVerticalScrollPosition=r),c&&s?t:Math.min(t,n)},u.prototype.getVerticalScrollRange=function(){var e=this.getVerticalScrollHeight()-this.getVerticalScrollbarHeight();return Math.max(0,e)},u.prototype.getVerticalScrollRangeBuffer=function(){var e=this.getTable();return null!=e&&l.isVariableRowHeightEnabled(e)?2*e._getDefaultRowHeight():0},u.prototype.getVerticalScrollPosition=function(){return null!=this._nVerticalScrollPosition?this._nVerticalScrollPosition:this.isVerticalScrollbarVisible()?this._oVerticalScrollbar.scrollTop:0},u.prototype.getVerticalScrollRangeRowFraction=function(){var e=this.getTable();if(null==e)return 0;var t,o=e._getTotalRowCount()-e.getVisibleRowCount();if(l.isVariableRowHeightEnabled(e)){t=this.getVerticalScrollRange()-this.getVerticalScrollRangeBuffer();1e6===this.getVerticalScrollHeight()||(t+=e._getDefaultRowHeight())}else t=this.getVerticalScrollRange();return t/Math.max(1,o)},u.prototype.updateInnerVerticalScrollPosition=function(){var t=this.getTable(),l=null==t?null:t.getDomRef(\"tableCCnt\");if(null!=l&&!a.isUpdatePending(t)){var o=this.getInnerVerticalScrollRange();if(0===o)return e.sap.log.debug(\"sap.ui.table.TableScrollExtension\",\"updateInnerVerticalScrollPosition: 0\",t),void(l.scrollTop=0);if(t._getFirstRenderedRowIndex()===t._iRenderedFirstVisibleRow){var r,i,n=t.getFirstVisibleRow(),s=this.getVerticalScrollPosition(),c=this.isVerticalScrollPositionInBuffer(),u=0,d=null,g=t._aRowHeights;if(c){var h,S=0,b=0;for(h=0;h<g.length&&b<o;h++)S++,b+=g[h];var p=this.getVerticalScrollRange(),f=this.getVerticalScrollRangeBuffer(),v=f/S;if(null!=this._iFirstVisibleRowInBuffer){var V=p-f;u=this._iFirstVisibleRowInBuffer*v;var _=V+u;return i=0,e.sap.log.debug(\"sap.ui.table.TableScrollExtension\",\"updateInnerVerticalScrollPosition: Set scroll position to \"+_,t),void this.updateVerticalScrollPosition(_)}u=s-p+f;var R=Math.min(Math.floor(u/v),S);for(r=g[R]||0,i=Math.max(0,Math.min((u-v*R)/v,1)),h=0;h<R;h++)d+=g[h];d+=r*i,d=Math.min(d,o);var E=t._getMaxFirstRenderedRowIndex()+R;E!==n&&(e.sap.log.debug(\"sap.ui.table.TableScrollExtension\",\"updateInnerVerticalScrollPosition: Set firstVisibleRow from \"+n+\" to \"+E,t),t.setFirstVisibleRow(E,!0))}else{var T=this.getVerticalScrollRangeRowFraction();u=s-n*T,r=g[0],i=Math.max(0,Math.min(u/T,1)),d=Math.round(r*i)}e.sap.log.debug(\"sap.ui.table.TableScrollExtension\",\"updateInnerVerticalScrollPosition: \"+d+\" of \"+r+\" (\"+100*i+\"%) (in buffer: \"+c+\")\",t),l.scrollTop=d}}},u.prototype.isVerticalScrollPositionInBuffer=function(){var e=this.getTable();return!(null==e||!l.isVariableRowHeightEnabled(e))&&this.getVerticalScrollRange()-this.getVerticalScrollPosition()<=this.getVerticalScrollRangeBuffer()},u.prototype.getInnerVerticalScrollRange=function(){var e=this.getTable();if(null==e||null==e._aRowHeights)return 0;var t=e._aRowHeights,l=e._getDefaultRowHeight()*e.getVisibleRowCount();e.getVisibleRowCount()>=e._getTotalRowCount()&&(t=t.slice(0,e._getTotalRowCount()));var o=t.reduce(function(e,t){return e+t},0)-l;return o>0&&(o=Math.ceil(o)),Math.max(0,o)},u.prototype._clearCache=function(){this._oVerticalScrollbar=null,this._oHorizontalScrollbar=null},u});",
	"sap/ui/table/TableUtils.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/core/Control\",\"sap/ui/core/ResizeHandler\",\"sap/ui/core/library\",\"sap/ui/model/ChangeReason\",\"./TableGrouping\",\"./TableColumnUtils\",\"./TableMenuUtils\",\"./TableBindingUtils\",\"./library\"],function(e,n,t,o,i,l,a,r,s,u){\"use strict\";var d=u.SelectionBehavior,g=u.SelectionMode,c=o.MessageType,R={DATACELL:1,COLUMNHEADER:2,ROWHEADER:4,ROWACTION:8,COLUMNROWHEADER:16};R.ANYCONTENTCELL=R.ROWHEADER|R.DATACELL|R.ROWACTION,R.ANYCOLUMNHEADER=R.COLUMNHEADER|R.COLUMNROWHEADER,R.ANYROWHEADER=R.ROWHEADER|R.COLUMNROWHEADER,R.ANY=R.ANYCONTENTCELL|R.ANYCOLUMNHEADER;var f={sapUiSizeCozy:48,sapUiSizeCompact:32,sapUiSizeCondensed:24,undefined:32},C={sapUiSizeCozy:f.sapUiSizeCozy+1,sapUiSizeCompact:f.sapUiSizeCompact+1,sapUiSizeCondensed:f.sapUiSizeCondensed+1,undefined:f.undefined+1},p={Render:\"Render\",VerticalScroll:\"VerticalScroll\",FirstVisibleRowChange:\"FirstVisibleRowChange\",Unbind:\"Unbind\",Animation:\"Animation\",Resize:\"Resize\",Unknown:\"Unknown\"};for(var w in i)p[w]=i[w];var m={Grouping:l,Column:a,Menu:r,Binding:s,CELLTYPE:R,ROW_HORIZONTAL_FRAME_SIZE:1,DEFAULT_ROW_HEIGHT:C,RowsUpdateReason:p,hasRowHeader:function(e){return e.getSelectionMode()!==g.None&&e.getSelectionBehavior()!==d.RowOnly||l.isGroupMode(e)},hasSelectAll:function(e){var n=null!=e?e.getSelectionMode():g.None;return(n===g.Multi||n===g.MultiToggle)&&e.getEnableSelectAll()},hasRowHighlights:function(e){if(null==e)return!1;var n=e.getRowSettingsTemplate();if(null==n)return!1;var t=n.getHighlight();return n.isBound(\"highlight\")||null!=t&&t!==c.None},getRowActionCount:function(e){var n=e.getRowActionTemplate();return n?n._getCount():0},hasRowActions:function(e){var n=e.getRowActionTemplate();return null!=n&&(n.isBound(\"visible\")||n.getVisible())&&m.getRowActionCount(e)>0},isRowSelectionAllowed:function(e){return e.getSelectionMode()!==g.None&&(e.getSelectionBehavior()===d.Row||e.getSelectionBehavior()===d.RowOnly)},isRowSelectorSelectionAllowed:function(e){return e.getSelectionMode()!==g.None&&m.hasRowHeader(e)},areAllRowsSelected:function(e){if(null==e)return!1;var n=e._getSelectableRowCount();return n>0&&n===e._getSelectedIndicesCount()},isNoDataVisible:function(e){return!!e.getShowNoData()&&!m.hasData(e)},hasData:function(e){var n=e.getBinding(\"rows\"),t=e._getTotalRowCount(),o=!!n&&!!t;if(n&&n.providesGrandTotal){var i=n.providesGrandTotal()&&n.hasTotaledMeasures();o=!(i&&t<2||!i&&0===t)}return o},isBusyIndicatorVisible:function(e){return null!=e&&null!=e.getDomRef()&&null!=e.getDomRef().querySelector(\".sapUiTableCnt > .sapUiLocalBusyIndicator\")},hasPendingRequests:function(e){return null!=e&&(m.canUsePendingRequestsCounter(e)?e._iPendingRequests>0:e._bPendingRequest)},canUsePendingRequestsCounter:function(e){var n=null!=e?e.getBinding(\"rows\"):null;return m.isInstanceOf(n,\"sap/ui/model/analytics/AnalyticalBinding\")?n.bUseBatchRequests:!m.isInstanceOf(n,\"sap/ui/model/TreeBinding\")},isInstanceOf:function(e,n){if(!e||!n)return!1;var t=sap.ui.require(n);return!!(t&&e instanceof t)},toggleRowSelection:function(n,t,o,i){function l(e){if(!n._isRowSelectable(e))return!1;n._iSourceRowIndex=e;var t=!0;if(i)t=i(e,o);else if(n.isIndexSelected(e)){if(null!=o&&o)return!1;n.removeSelectionInterval(e,e)}else{if(null!=o&&!o)return!1;n.addSelectionInterval(e,e)}return delete n._iSourceRowIndex,t}if(null==n||null==n.getBinding(\"rows\")||n.getSelectionMode()===g.None||null==t)return!1;if(\"number\"==typeof t)return!(t<0||t>=n._getTotalRowCount())&&l(t);var a=e(t),r=m.getCellInfo(a[0]),s=m.isRowSelectionAllowed(n);if(!m.Grouping.isInGroupingRow(a[0])&&(r.isOfType(m.CELLTYPE.DATACELL|m.CELLTYPE.ROWACTION)&&s||r.isOfType(m.CELLTYPE.ROWHEADER)&&m.isRowSelectorSelectionAllowed(n))){var u;return u=r.isOfType(m.CELLTYPE.DATACELL)?n.getRows()[parseInt(a.closest(\"tr\",n.getDomRef()).attr(\"data-sap-ui-rowindex\"),10)].getIndex():n.getRows()[parseInt(a.attr(\"data-sap-ui-rowindex\"),10)].getIndex(),l(u)}return!1},getNoDataText:function(e){var t=e.getNoData();return t instanceof n?null:\"string\"==typeof t||e.getNoData()instanceof String?t:e._oResBundle.getText(\"TBL_NO_DATA\")},getVisibleColumnCount:function(e){return e._getVisibleColumns().length},getHeaderRowCount:function(e){if(void 0===e._iHeaderRowCount)if(e.getColumnHeaderVisible()){for(var n=1,t=e.getColumns(),o=0;o<t.length;o++)t[o].shouldRender()&&(n=Math.max(n,t[o].getMultiLabels().length));e._iHeaderRowCount=n}else e._iHeaderRowCount=0;return e._iHeaderRowCount},isVariableRowHeightEnabled:function(e){return e._bVariableRowHeightEnabled&&e.getFixedRowCount()<=0&&e.getFixedBottomRowCount()<=0},getTotalRowCount:function(e,n){var t=e._getTotalRowCount();return n&&(t=Math.max(t,e.getVisibleRowCount())),t},getNonEmptyVisibleRowCount:function(e){return Math.min(e.getVisibleRowCount(),e._getTotalRowCount())},getFocusedItemInfo:function(e){var n=e._getItemNavigation();return n?{cell:n.getFocusedIndex(),columnCount:n.iColumns,cellInRow:n.getFocusedIndex()%n.iColumns,row:Math.floor(n.getFocusedIndex()/n.iColumns),cellCount:n.getItemDomRefs().length,domRef:n.getFocusedDomRef()}:null},getRowIndexOfFocusedCell:function(e){return m.getFocusedItemInfo(e).row-m.getHeaderRowCount(e)},isFixedColumn:function(e,n){return n<e.getFixedColumnCount()},hasFixedColumns:function(e){return e.getFixedColumnCount()>0},focusItem:function(e,n,t){var o=e._getItemNavigation();o&&o.focusItem(n,t)},getCellInfo:function(n){var t,o,i,l,a,r,s=e(n);return t={type:0,cell:null,rowIndex:null,columnIndex:null,columnSpan:null},s.hasClass(\"sapUiTableTd\")?(o=s.data(\"sap-ui-colid\"),i=sap.ui.getCore().byId(o),t.type=m.CELLTYPE.DATACELL,t.rowIndex=parseInt(s.parent().data(\"sap-ui-rowindex\"),10),t.columnIndex=i.getIndex(),t.columnSpan=1):s.hasClass(\"sapUiTableCol\")?(l=/_([\\d]+)/,o=s.attr(\"id\"),a=l.exec(o),r=null==a||null==a[1]?0:parseInt(a[1],10),t.type=m.CELLTYPE.COLUMNHEADER,t.rowIndex=r,t.columnIndex=parseInt(s.data(\"sap-ui-colindex\"),10),t.columnSpan=parseInt(s.attr(\"colspan\")||1,10)):s.hasClass(\"sapUiTableRowHdr\")?(t.type=m.CELLTYPE.ROWHEADER,t.rowIndex=parseInt(s.data(\"sap-ui-rowindex\"),10),t.columnIndex=-1,t.columnSpan=1):s.hasClass(\"sapUiTableRowAction\")?(t.type=m.CELLTYPE.ROWACTION,t.rowIndex=parseInt(s.data(\"sap-ui-rowindex\"),10),t.columnIndex=-2,t.columnSpan=1):s.hasClass(\"sapUiTableColRowHdr\")&&(t.type=m.CELLTYPE.COLUMNROWHEADER,t.columnIndex=-1,t.columnSpan=1),0!==t.type&&(t.cell=s),t.isOfType=function(e){return null!=e&&(this.type&e)>0},t},getRowColCell:function(e,n,t,o){var i=n>=0&&n<e.getRows().length?e.getRows()[n]:null,l=o?e.getColumns():e._getVisibleColumns(),a=t>=0&&t<l.length?l[t]:null,r=null;if(i&&a){if(o){if(a.shouldRender())for(var s=e._getVisibleColumns(),u=0;u<s.length;u++)if(s[u]===a){r=i.getCells()[u];break}}else r=i.getCells()[t];if(r&&r.data(\"sap-ui-colid\")!=a.getId())for(var d=i.getCells(),u=0;u<d.length;u++)if(d[u].data(\"sap-ui-colid\")===a.getId()){r=d[u];break}}return{row:i,column:a,cell:r}},getCell:function(n,t){if(null==n||null==t)return null;for(var o,i,l=e(t),a=n.getDomRef(),r=[\".sapUiTableTd\",\".sapUiTableCol\",\".sapUiTableRowHdr\",\".sapUiTableRowAction\",\".sapUiTableColRowHdr\"],s=0;s<r.length;s++)if(i=r[s],o=l.closest(i,a),o.length>0)return o;return null},getParentCell:function(n,t){var o=e(t),i=m.getCell(n,t);return null===i||i[0]===o[0]?null:i},registerResizeHandler:function(n,o,i,l){var a;return\"string\"!=typeof o?void e.sap.log.error(\"sIdSuffix must be a string\",n):(a=n.getDomRef(o),\"function\"!=typeof i?void e.sap.log.error(\"fnHandler must be a function\",n):(m.deregisterResizeHandler(n,o),n._mResizeHandlerIds||(n._mResizeHandlerIds={}),l&&a&&(a=a.parentNode),a&&(n._mResizeHandlerIds[o]=t.register(a,i)),n._mResizeHandlerIds[o]))},deregisterResizeHandler:function(n,o){var i;if(n._mResizeHandlerIds){if(\"string\"==typeof o)i=[o];else if(void 0===o){i=[];for(var l in n._mResizeHandlerIds)\"string\"==typeof l&&n._mResizeHandlerIds.hasOwnProperty(l)&&i.push(l)}else e.isArray(o)&&(i=o);for(var a=0;a<i.length;a++){var r=i[a];n._mResizeHandlerIds[r]&&(t.deregister(n._mResizeHandlerIds[r]),n._mResizeHandlerIds[r]=void 0)}}},isFirstScrollableRow:function(n,t){if(isNaN(t)){var o=e(t);t=parseInt(o.add(o.parent()).filter(\"[data-sap-ui-rowindex]\").data(\"sap-ui-rowindex\"),10)}return t==(n.getFixedRowCount()||0)},isLastScrollableRow:function(n,t){if(isNaN(t)){var o=e(t);t=parseInt(o.add(o.parent()).filter(\"[data-sap-ui-rowindex]\").data(\"sap-ui-rowindex\"),10)}var i=n.getFixedBottomRowCount()||0;return t==n.getVisibleRowCount()-i-1},getContentDensity:function(n){var t,o=[\"sapUiSizeCompact\",\"sapUiSizeCondensed\",\"sapUiSizeCozy\"],i=function(e,n){if(n[e])for(var t=0;t<o.length;t++)if(n[e](o[t]))return o[t]},l=n.$();if(t=l.length>0?i(\"hasClass\",l):i(\"hasStyleClass\",n))return t;var a=null,r=n.getParent();if(r)do{if(t=i(\"hasStyleClass\",r))return t;r.getDomRef?a=r.getDomRef():r.getRootNode&&(a=r.getRootNode()),r=!a&&r.getParent?r.getParent():null}while(r&&!a);return l=e(a||document.body),t=i(\"hasClass\",l.closest(\".\"+o.join(\",.\")))},sanitizeSelectionMode:function(n,t){return t===g.Multi&&(t=g.MultiToggle,e.sap.log.warning(\"The selection mode 'Multi' is deprecated and must not be used anymore. Your setting was defaulted to selection mode 'MultiToggle'\")),t},isVariableWidth:function(e){return!e||\"auto\"==e||e.toString().match(/%$/)},getFirstFixedButtomRowIndex:function(e){var n=e.getFixedBottomRowCount(),t=e.getBinding(\"rows\"),o=-1;if(t&&n>0){var i=e.getVisibleRowCount(),l=e.getFirstVisibleRow(),a=e._getTotalRowCount();if(a>=i)o=i-n;else{var r=a-n-l;r>=0&&l+r<a&&(o=r)}}return o}};return l.TableUtils=m,a.TableUtils=m,r.TableUtils=m,s.TableUtils=m,m},!0);",
	"sap/ui/table/TreeTable.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"./Table\",\"sap/ui/model/ClientTreeBindingAdapter\",\"sap/ui/model/TreeBindingCompatibilityAdapter\",\"./library\",\"sap/ui/core/Element\",\"./TableUtils\"],function(e,t,o,n,i,r,s){\"use strict\";var l=t.extend(\"sap.ui.table.TreeTable\",{metadata:{library:\"sap.ui.table\",properties:{expandFirstLevel:{type:\"boolean\",defaultValue:!1,deprecated:!0},useGroupMode:{type:\"boolean\",group:\"Appearance\",defaultValue:!1},groupHeaderProperty:{type:\"string\",group:\"Data\",defaultValue:null},collapseRecursive:{type:\"boolean\",defaultValue:!0},rootLevel:{type:\"int\",group:\"Data\",defaultValue:0}},events:{toggleOpenState:{parameters:{rowIndex:{type:\"int\"},rowContext:{type:\"object\"},expanded:{type:\"boolean\"}}}}},renderer:\"sap.ui.table.TableRenderer\"});return l.prototype.init=function(){t.prototype.init.apply(this,arguments),s.Grouping.setTreeMode(this)},l.prototype.bindRows=function(e){return e=t._getSanitizedBindingInfo(arguments),null!=e&&(null==e.parameters&&(e.parameters={}),e.parameters.rootLevel=this.getRootLevel(),e.parameters.collapseRecursive=this.getCollapseRecursive(),e.parameters.numberOfExpandedLevels=e.parameters.numberOfExpandedLevels||(this.getExpandFirstLevel()?1:0)),t.prototype.bindRows.call(this,e)},l.prototype._bindAggregation=function(e,o){t.prototype._bindAggregation.call(this,e,o);var n=this.getBinding(\"rows\");\"rows\"===e&&null!=n&&n.attachEvents({selectionChanged:this._onSelectionChanged.bind(this)})},l.prototype.setSelectionMode=function(e){var o=this.getBinding(\"rows\");return o&&o.clearSelection?(o.clearSelection(),e=s.sanitizeSelectionMode(this,e),this.setProperty(\"selectionMode\",e)):t.prototype.setSelectionMode.call(this,e),this},l.prototype.setFixedRowCount=function(t){return e.sap.log.warning('TreeTable: the property \"fixedRowCount\" is not supported and will be ignored!'),this},l.prototype.isTreeBinding=function(e){return\"rows\"===(e=e||\"rows\")||r.prototype.isTreeBinding.apply(this,arguments)},l.prototype.getBinding=function(t){t=t||\"rows\";var i=r.prototype.getBinding.call(this,t);return i&&\"rows\"===t&&!i.getLength&&(s.isInstanceOf(i,\"sap/ui/model/odata/ODataTreeBinding\")?n(i,this):s.isInstanceOf(i,\"sap/ui/model/odata/v2/ODataTreeBinding\")?i.applyAdapterInterface():s.isInstanceOf(i,\"sap/ui/model/ClientTreeBinding\")?o.apply(i):e.sap.log.error(\"Binding not supported by sap.ui.table.TreeTable\")),i},l.prototype._getContexts=function(e,t,o){var n=this.getBinding(\"rows\");return n?n.getNodes(e,t,o):[]},l.prototype._onGroupHeaderChanged=function(e,t){this.fireToggleOpenState({rowIndex:e,rowContext:this.getContextByIndex(e),expanded:t})},l.prototype.expand=function(e){return s.Grouping.toggleGroupHeader(this,e,!0),this},l.prototype.collapse=function(e){return s.Grouping.toggleGroupHeader(this,e,!1),this},l.prototype.collapseAll=function(){var e=this.getBinding(\"rows\");return e&&(e.collapseToLevel(0),this.setFirstVisibleRow(0)),this},l.prototype.expandToLevel=function(t){var o=this.getBinding(\"rows\");return e.sap.assert(o&&o.expandToLevel,\"TreeTable.expandToLevel is not supported with your current Binding. Please check if you are running on an ODataModel V2.\"),o&&o.expandToLevel&&o.expandToLevel(t),this},l.prototype.isExpanded=function(e){var t=this.getBinding(\"rows\");return!!t&&t.isExpanded(e)},l.prototype.isIndexSelected=function(e){var o=this.getBinding(\"rows\");return o&&o.isIndexSelected?o.isIndexSelected(e):t.prototype.isIndexSelected.call(this,e)},l.prototype.setSelectedIndex=function(e){-1===e&&this.clearSelection();var o=this.getBinding(\"rows\");return o&&o.findNode&&o.setNodeSelection?o.setSelectedIndex(e):t.prototype.setSelectedIndex.call(this,e),this},l.prototype.getSelectedIndices=function(){var e=this.getBinding(\"rows\");return e&&e.findNode&&e.getSelectedIndices?e.getSelectedIndices():t.prototype.getSelectedIndices.call(this)},l.prototype.setSelectionInterval=function(e,o){var n=this.getSelectionMode();if(n===i.SelectionMode.None)return this;var r=this.getBinding(\"rows\");return r&&r.findNode&&r.setSelectionInterval?n===i.SelectionMode.Single?r.setSelectionInterval(e,e):r.setSelectionInterval(e,o):t.prototype.setSelectionInterval.call(this,e,o),this},l.prototype.addSelectionInterval=function(e,o){var n=this.getSelectionMode();if(n===i.SelectionMode.None)return this;var r=this.getBinding(\"rows\");return r&&r.findNode&&r.addSelectionInterval?n===i.SelectionMode.Single?r.setSelectionInterval(e,e):r.addSelectionInterval(e,o):t.prototype.addSelectionInterval.call(this,e,o),this},l.prototype.removeSelectionInterval=function(e,o){var n=this.getBinding(\"rows\");return n&&n.findNode&&n.removeSelectionInterval?n.removeSelectionInterval(e,o):t.prototype.removeSelectionInterval.call(this,e,o),this},l.prototype.selectAll=function(){if(!s.hasSelectAll(this))return this;var e=this.getBinding(\"rows\");return e&&e.selectAll?e.selectAll():t.prototype.selectAll.call(this),this},l.prototype.getSelectedIndex=function(){var e=this.getBinding(\"rows\");return e&&e.findNode?e.getSelectedIndex():t.prototype.getSelectedIndex.call(this)},l.prototype.clearSelection=function(){var e=this.getBinding(\"rows\");return e&&e.clearSelection?e.clearSelection():t.prototype.clearSelection.call(this),this},l.prototype.getContextByIndex=function(e){var t=this.getBinding(\"rows\");if(t)return t.getContextByIndex(e)},l.prototype.setRootLevel=function(t){this.setFirstVisibleRow(0);var o=this.getBinding(\"rows\");return o&&(e.sap.assert(o.setRootLevel,\"rootLevel is not supported by the used binding\"),o.setRootLevel&&o.setRootLevel(t)),this.setProperty(\"rootLevel\",t,!0),this},l.prototype.setCollapseRecursive=function(t){var o=this.getBinding(\"rows\");return o&&(e.sap.assert(o.setCollapseRecursive,\"Collapse Recursive is not supported by the used binding\"),o.setCollapseRecursive&&o.setCollapseRecursive(t)),this.setProperty(\"collapseRecursive\",!!t,!0),this},l.prototype._getSelectedIndicesCount=function(){var e=this.getBinding(\"rows\");return e&&e.getSelectedNodesCount?e.getSelectedNodesCount():t.prototype.getSelectedIndices.call(this)},l.prototype.setUseGroupMode=function(e){return this.setProperty(\"useGroupMode\",!!e),e?s.Grouping.setGroupMode(this):s.Grouping.setTreeMode(this),this},l.prototype.setEnableGrouping=function(){return e.sap.log.warning(\"The property enableGrouping is not supported by the sap.ui.table.TreeTable control\"),this},l.prototype.setGroupBy=function(){return e.sap.log.warning(\"The groupBy association is not supported by the sap.ui.table.TreeTable control\"),this},l.prototype.setUseFlatMode=function(e){return e=!!e,e!=this._bFlatMode&&(this._bFlatMode=e,this.getDomRef()&&s.Grouping.isTreeMode(this)&&this.invalidate()),this},l});",
	"sap/ui/table/TreeTableRenderer.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"sap/ui/table/TreeTable\"],function(e){\"use strict\";return e.getMetadata().getRenderer()},!0);",
	"sap/ui/table/manifest.json": "{\"_version\":\"1.9.0\",\"sap.app\":{\"_version\":\"1.2.0\",\"id\":\"sap.ui.table\",\"type\":\"library\",\"applicationVersion\":{\"version\":\"9.4.0-0\"},\"title\":\"The OpenUI5-based library, sap.ui.table.\"},\"sap.ui5\":{\"_version\":\"1.1.0\",\"dependencies\":{\"libs\":{\"sap.ui.core\":{},\"sap.ui.unified\":{}}},\"library\":{\"i18n\":\"messagebundle.properties\"}}}"
}, "sap/ui/table/library-preload");