/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

sap.ui.define([],
	function() {
		"use strict";


	/**
	 * <code>ObjectMarker</code> renderer.
	 * @namespace
	 */
	var ObjectMarkerRenderer = {};

	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	ObjectMarkerRenderer.render = function(oRm, oControl) {

		// start control wrapper
		oRm.write("<span ");
		oRm.writeControlData(oControl);
		oRm.addClass("sapMObjectMarker");
		if (oControl._isIconVisible()) {
			oRm.addClass("sapMObjectMarkerIcon");
		}
		if (oControl._isTextVisible()) {
			oRm.addClass("sapMObjectMarkerText");
		}
		oRm.writeClasses();
		// SAS Edit  Start
		if (oControl.getActive()) {
			oRm.writeAttribute("aria-haspopup", true);
		}
        // SAS Edit End
		oRm.write(">");

		//SAS Edit Start
		//S1404759
		this.renderInnerControl(oRm, oControl);
		//SAS Edit End
		// end control wrapper
		oRm.write("</span>");
	};

	//SAS Edit Start
	//S1404759
	ObjectMarkerRenderer.renderInnerControl = function(oRm, oControl) {
		oRm.renderControl(oControl._getInnerControl());
	};
	//SAS Edit End
	return ObjectMarkerRenderer;

}, /* bExport= */ true);