-- SAS9-32237 Updating BATCH_JOB_EXECUTION_PARAMS table columns as spring batch 5 migration (https://github.com/spring-projects/spring-batch/wiki/Spring-Batch-5.0-Migration-Guide)
/*ALTER TABLE BATCH_JOB_EXECUTION_PARAMS
    -- Add new columns
    ADD COLUMN PARAMETER_NAME VARCHAR(100) NOT NULL,
    ADD COLUMN PARAMETER_TYPE VARCHAR(100) NOT NULL,
    ADD COLUMN PARAMETER_VALUE TEXT,

    -- Remove the old columns (if needed, based on your requirement)
    DROP COLUMN TYPE_CD,
    DROP COLUMN KEY_NAME,
    DROP COLUMN STRING_VAL,
    DROP COLUMN DATE_VAL,
    DROP COLUMN LONG_VAL,
    DROP COLUMN DOUBLE_VAL;*/

ALTER TABLE BATCH_JOB_EXECUTION_PARAMS
    ADD COLUMN PARAMETER_NAME VARCHAR(100),
    ADD COLUMN PARAMETER_TYPE VARCHAR(100),
    ADD COLUMN PARAMETER_VALUE TEXT;


--Migrate the data from old column to newly added column (new column are combination of old column in spring batch 5)
UPDATE BATCH_JOB_EXECUTION_PARAMS
	set
		PARAMETER_NAME = KEY_NAME,
		PARAMETER_TYPE = case
	when STRING_VAL is not null and TYPE_CD = 'STRING' then 'java.lang.String'
	when DATE_VAL is not null and TYPE_CD = 'DATE' then 'java.util.Date'
	when LONG_VAL is not null and TYPE_CD = 'Long' then 'java.lang.Long'
	when DOUBLE_VAL is not null and TYPE_CD = 'Double' then 'java.lang.Double'
	else 'UNKNOWN'
	end,
	PARAMETER_VALUE = case
	when TYPE_CD = 'STRING' then STRING_VAL
	when TYPE_CD = 'DATE' then to_char(DATE_VAL, 'YYYY-MM-DD"T"HH24:MI:SS.MS')
	when TYPE_CD = 'Long' then cast (LONG_VAL as TEXT)
	when TYPE_CD = 'Double' then cast (DOUBLE_VAL as TEXT)
	else null
	end
	where
	PARAMETER_NAME is null and
	PARAMETER_TYPE is null and
	PARAMETER_VALUE is null
;


--Drop old columns, no more required.
ALTER TABLE batch_job_execution_params
	DROP COLUMN TYPE_CD,
	DROP COLUMN KEY_NAME,
	DROP COLUMN STRING_VAL,
	DROP COLUMN DATE_VAL,
	DROP COLUMN LONG_VAL,
	DROP COLUMN DOUBLE_VAL;
    
-- SAS9-32237 Creating new column CREATE_TIME in BATCH_STEP_EXECUTION table as spring batch 5 migration (https://github.com/spring-projects/spring-batch/wiki/Spring-Batch-5.0-Migration-Guide)
ALTER TABLE BATCH_STEP_EXECUTION ADD CREATE_TIME TIMESTAMP NOT NULL DEFAULT '1970-01-01 00:00:01';

-- SAS9-32237 Removing NOT NULL constraint of START_TIME column from BATCH_STEP_EXECUTION table as spring batch 5 migration (https://github.com/spring-projects/spring-batch/wiki/Spring-Batch-5.0-Migration-Guide)
ALTER TABLE BATCH_STEP_EXECUTION ALTER COLUMN START_TIME DROP NOT NULL;

-- SAS9-47288 add Z at end of Date values
UPDATE BATCH_JOB_EXECUTION_PARAMS
    SET PARAMETER_VALUE = CONCAT(PARAMETER_VALUE, 'Z')
    WHERE PARAMETER_VALUE NOT LIKE '%Z'
      and PARAMETER_TYPE = 'java.util.Date';