#!/bin/sh

#sasevagentM9_jarfix.sh
#Used as a wrapper for ant code sasevagentM9_jarfix.xml. Code located SAS delivered version of at and uses it to locate and update product specific picklists that reference unsecure jars


#check for parameters
if [ -n "$1" ] 
	then
		sashome_set="true"
	else
		sashome_set="false"
fi

if [ -n "$2" ]
	then
		sasconfig_set="true"
	else
		sasconfig_set="false"
fi

truevar="true"

#if both parameters for sashome and sasconfig are set
if [ $sashome_set = $truevar ]
	then
		if [ $sasconfig_set = $truevar ]
			then
				echo "Searching for SAS delivered JRE"
				privatejre_tmp=`grep -i "PRIVATEJREHOME" $1/sassw.config`
				echo "sassw.config = ${privatejre_tmp}"
				privatejre=`echo ${privatejre_tmp} | cut -c16-`
				echo "privatejre = ${privatejre}"
				
				echo "Searching for SASDeploymentManager in this SASHome location '$1'"
				deploywizpath=$1/SASDeploymentManager/9.4/products
				deploypath=`find ${deploywizpath} -name 'deploywiz__*' |sort| tail -1`
				numofdeploywizdirs=`find ${deploywizpath} -name 'deploywiz__*' | wc -l`
				echo "number of deploywiz versions = ${numofdeploywizdirs}"
				buildfilepath=sasevagentM9_jarfix.xml
				echo "Using ${deploypath}/deploywiz/ant-launcher.jar to launch ant scripts"
				#execute ant script
				${privatejre} -jar ${deploypath}/deploywiz/ant-launcher.jar -buildfile ${buildfilepath} -DSASHOME=$1 -DSASCONFIG=$2 -DPLAT=UNIX
			else
				echo "Searching for SAS delivered JRE"
				privatejre_tmp=`grep -i "PRIVATEJREHOME" $1/sassw.config`
				echo "sassw.config = ${privatejre_tmp}"
				privatejre=`echo ${privatejre_tmp} | cut -c16-`
				echo "privatejre = ${privatejre}"
				
				echo "Searching for SASDeploymentManager in this SASHome location '$1'"
				deploywizpath=$1/SASDeploymentManager/9.4/products
				deploypath=`find ${deploywizpath} -name 'deploywiz__*' |sort| tail -1`
				numofdeploywizdirs=`find ${deploywizpath} -name 'deploywiz__*' | wc -l`
				echo "number of deploywiz versions = ${numofdeploywizdirs}"
				buildfilepath=sasevagentM9_jarfix.xml
				echo "Using ${deploypath}/deploywiz/ant-launcher.jar to launch ant scripts"
				#execute ant script
				${privatejre} -jar ${deploypath}/deploywiz/ant-launcher.jar -buildfile ${buildfilepath} -DSASHOME=$1 -DPLAT=UNIX
		fi
	else
		#no params set
		echo "No parameter(SASHOME) was specified. Please try again"
fi
