/* 
SUPPORT: sinass Sharma, Ashish
*/ 
/****************************************************************************** 
 * Job:             Load_DM_Prf_sales_data_summary          A5W0V4GZ.BF0004A4 * 
 * Description:                                                               * 
 *                                                                            * 
 * Metadata Server: puneasd10.apac.sas.com                                    * 
 * Port:            8561                                                      * 
 * Location:        /Users/Sourabh/My Folder/Expidite                         * 
 *                                                                            * 
 * Server:          MIMain                                  A5W0V4GZ.AR000003 * 
 *                                                                            * 
 * Source Tables:   DATE_DM - DI_DM.DATE_DM                 A5W0V4GZ.BB0009QJ * 
 *                  PRF_SALES_FACT - DI_DM.PRF_SALES_FACT   A5W0V4GZ.BB0009TI * 
 * Target Table:    PRF_SALES_DATA_SUMMARY -                A5W0V4GZ.BB0009TH * 
 *                   DI_DM.PRF_SALES_DATA_SUMMARY                             * 
 *                                                                            * 
 * Generated on:    Friday, January 8, 2010 12:52:00 PM IST                   * 
 * Generated by:    sinsoj@row                                                * 
 * Version:         SAS Data Integration Studio 4.2                           * 
 ******************************************************************************/ 

/* General macro variables  */ 
%let jobID = %quote(A5W0V4GZ.BF0004A4);
%let etls_jobName = %nrquote(Load_DM_Prf_sales_data_summary);
%let etls_userID = %nrquote(sinsoj@row);

/* Setup to capture return codes  */ 
%global job_rc trans_rc sqlrc; 
%let sysrc = 0;
%let job_rc = 0;
%let trans_rc = 0;
%let sqlrc = 0;
%global syserr; 

%macro rcSet(error); 
   %if (&error gt &trans_rc) %then 
      %let trans_rc = &error;
   %if (&error gt &job_rc) %then 
      %let job_rc = &error;
%mend rcSet; 

%macro rcSetDS(error); 
   if &error gt input(symget('trans_rc'),12.) then 
      call symput('trans_rc',trim(left(put(&error,12.))));
   if &error gt input(symget('job_rc'),12.) then 
      call symput('job_rc',trim(left(put(&error,12.))));
%mend rcSetDS; 

%let IOMServer      = %nrquote(MIMain);

/* Parameter default value(s) for Load_DM_Prf_sales_data_summary  */ 
%let dyn_tab = newtab;


/* Setup for capturing job status  */ 
%let etls_startTime = %sysfunc(datetime(),datetime.);
%let etls_recordsBefore = 0;
%let etls_recordsAfter = 0;
%let etls_lib = 0;
%let etls_table = 0;

%global etls_debug; 
%macro etls_setDebug; 
   %if %str(&etls_debug) ne 0 %then 
      OPTIONS MPRINT%str(;); 
%mend; 
%etls_setDebug; 

/*---- Start of Pre-Process Code  ----*/ 

/**/
%etl_initjobparam (monlib=di_mon, jobname=%nrquote(&etls_jobName));
/**/
%etl_initchangeflags;
/*---- End of Pre-Process Code  ----*/ 

 %di_etl_rcset(error=&syserr,code=job_rc);

/*---- Start of User Written Code  ----*/ 

/*============================================================================* 
 * Step:            Uw_Lkp_prod_hier_assoc_dm               A5W0V4GZ.BH00096T * 
 * Transform:       User Written                                              * 
 * Description:                                                               * 
 *                                                                            * 
 * Source Table:    PRF_SALES_FACT - DI_DM.PRF_SALES_FACT   A5W0V4GZ.BB0004XP * 
 * Target Table:    Lkp_PRODUCT_HIER_ASSOC_DM -             A5W0V4GZ.BK0007GF * 
 *                   work.Lkp_PRODUCT_HIER_ASSOC_DM                           * 
 *                                                                            * 
 * User Written:    SourceCode                                                * 
 *============================================================================*/ 

%global g_profiling_work_prod_lvl g_meta_table_obs;

%macro etl_check_exist;
%let abort = 0 ;

/******************************************************/
/*    Check for existence of DI_DM.DATE_DM dataset    */
/******************************************************/

%if NOT %sysfunc(exist(DI_DM.DATE_DM)) %then 
%do;
   %let etl_msg = %etl_msg(mid=5005,args=DI_DM.DATE_DM);
   %put &etl_msg;
   %let abort = 1 ;
%end;

/*********************************************************/
/*  select PROD_PARTITION_LVL from GLOBAL_SETTING table  */
/*********************************************************/

proc sql noprint;
   select spec_value into :g_profiling_work_prod_lvl 
   from di_dm.global_setting
   where upcase(spec_nm)='PROD_PARTITION_LVL';
quit;

%if %sysfunc(compress("&g_profiling_work_prod_lvl")) eq "" %then 
%do;
   %let etl_msg = %etl_msg(mid=5013,args=PROD_PARTITION_LVL GLOBAL_SETTING);
   %put &etl_msg;    
   %let abort = 2 ;
%end;

%put PROD_PARTITION_LVL = &g_profiling_work_prod_lvl;

%if &abort gt 0 %then %do;
   %etl_abort;
%end;

%mend etl_check_exist;

%etl_check_exist;

%di_etl_rcset(error=&syserr,code=job_rc);

proc sql; 
   create view work.View_prod_hier as 
   select PROD_HIER_SK,
          PARENT_PROD_HIER_SK
   from DI_DM.PRODUCT_HIER_ASSOC_DM
   where PROD_HIER_ASSOC_CD =1 
   and PARENT_PROD_LVL = &g_profiling_work_prod_lvl;
quit;

%di_etl_rcset(error=&syserr,code=job_rc);

%macro check_partition;
	/*Identify the partitions and so as to assign libname to each partition in the loop below*/

%local dsn;

/*Create empty PRF_SALES_FACT in all the partition if not already present*/
/* this change was introduced to address the defect: S1148198 and 7611366281*/

%di_etl_create_empty_part_dataset(table = PRF_SALES_FACT);


%let dsn=%str();

	proc sql noprint;
	   select path into :path
	   from sashelp.vlibnam
	   where lowcase(libname)="di_dm"
	   and level in (0,1);
	quit;

	%let path=%trim(&path)/1;

	%di_util_dir(path=&path, pattern=, _res=list);

	data partitions;
		set list end=eof;
		retain c 0;
		if (entry ne ".") then do;
			path="%trim(&path)"||substr(entry,2);
			part_sk=compress(substr(entry,3));
			if input(part_sk,??best12.)>0 then do;
				c+1;
				call symput("libpath"||left(c),path);
				call symput("part_sk"||left(c),part_sk);
				output;
			end;
		end;
		if eof then call symput("parts",c);
	run;

   %di_etl_rcset(error=&syserr,code=job_rc);
	data Lkp_PRODUCT_HIER_ASSOC_DM;
	   attrib PARENT_PROD_HIER_SK length=6
			  DATE_SK length=4 format=Best12.;
		stop; 
	run;

	%do partnum = 1 %to &parts;/*loop to iterate into prf_sales_fact for each partition to create libname */
		
		libname lib&partnum "%trim(&&libpath&partnum)";	
        /*Changes Done for  IIOTTRIAGE-15 in Set statement*/ 		
		data  work.Lkp_PRODUCT_HIER_ASSOC_DM1( keep = PARENT_PROD_HIER_SK DATE_SK );
		set lib&partnum..prf_sales_fact (keep = PROD_HIER_SK DATE_SK);
		attrib	PARENT_PROD_HIER_SK length=6
				DATE_SK length=4 format=Best12.
				PROD_HIER_SK length= 6;    
		if (_n_ = 1) then do;           
			declare hash h0(dataset: "work.View_prod_hier", hashexp: 16);
			h0.defineKey( "PROD_HIER_SK");
			h0.defineData( "PARENT_PROD_HIER_SK");
			h0.defineDone();   
		end; 
		rc0 = h0.find();   
		if (rc0 = 0) then output;                    
		run; 
		proc append base=work.Lkp_PRODUCT_HIER_ASSOC_DM data=work.Lkp_PRODUCT_HIER_ASSOC_DM1 force; run;
		/*Deassign libname created for every partition*/
		libname lib&partnum ;
	%end;

    %di_etl_rcset(error=&syserr,code=job_rc);
%mend check_partition;
%check_partition;

proc datasets lib = work nolist memtype = (data view);
   delete  view_prod_hier;
quit;

 %di_etl_rcset(error=&syserr,code=job_rc);

/*---- End of User Written Code  ----*/ 

/*---- Start of User Written Code  ----*/ 

/*============================================================================* 
 * Step:            Uw_min_max_date                         A5W0V4GZ.BH00096U * 
 * Transform:       User Written                                              * 
 * Description:                                                               * 
 *                                                                            * 
 * Source Table:    Lkp_PRODUCT_HIER_ASSOC_DM -             A5W0V4GZ.BK0007GF * 
 *                   work.Lkp_PRODUCT_HIER_ASSOC_DM                           * 
 * Target Table:    prf_sales_data - work.prf_sales_data    A5W0V4GZ.BK0007GG * 
 *                                                                            * 
 * User Written:    SourceCode                                                * 
 *============================================================================*/
proc sql noprint;
 create table work.prf_sales_data as
 select PARENT_PROD_HIER_SK AS PROD_HIER_SK, min(DATE_SK) as START_DATE_SK, max(DATE_SK) as END_DATE_SK 
 from Lkp_Product_hier_assoc_dm
 group by PARENT_PROD_HIER_SK;
quit;

 %di_etl_rcset(error=&syserr,code=job_rc);

/*---- End of User Written Code  ----*/ 

/*============================================================================* 
 * Step:            Lkp_date_dm                             A5W0V4GZ.BH000KAN * 
 * Transform:       Lookup                                                    * 
 * Description:                                                               * 
 *                                                                            * 
 * Source Tables:   prf_sales_data - work.prf_sales_data    A5W0V4GZ.BK000GVK * 
 *                  DATE_DM - DI_DM.DATE_DM                 A5W0V4GZ.BB0009QJ * 
 * Target Table:    Lkp_date_dm - work.Lkp_date_dm          A5W0V4GZ.BK000GVL * 
 *============================================================================*/ 

%let transformID = %quote(A5W0V4GZ.BH000KAN);
%let trans_rc = 0;
%let etls_stepStartTime = %sysfunc(datetime(), datetime20.); 

%let runTime = %sysfunc(datetime()); 

proc datasets lib = work nolist nowarn memtype = (data view);
   delete Lkp_date_dm;
quit;

/*---- Begin DATA step to perform lookups  ----*/ 
DATA  work.Lkp_date_dm
         ( keep = PROD_HIER_SK START_DATE END_DATE )
      ; 
   
   attrib PROD_HIER_SK length=6 format=Best12.
          START_DATE length=8 format=date9.
          END_DATE length=8 format=date9.
          FISCAL_START_DT length= 8
          DATE_SK length= 4
          FISCAL_END_DT length= 8
          ; 
   
   retain missing0-missing1 0; 
   
   etls_assign_target_value = 0; 
   /* Build hash objects from lookup tables before reading first source row  */ 
   if (_n_ = 1) then 
   do; 
      /* Build hash h0 from lookup table DI_DM.DATE_DM */ 
      nlobs = .; 
      dsid = open("DI_DM.DATE_DM"); 
      if (dsid > 0) then 
      do; 
         if ( attrc(dsid, 'MTYPE') = 'DATA' ) then 
            nlobs = attrn(dsid, 'NLOBS'); 
         else 
            nlobs = -1; 
            
         dsid = close(dsid); 
         if (nlobs ^= 0) then 
         do; 
            if (nlobs > 0) then 
               exponent = ceil(log2(nlobs)); 
            else 
               exponent = 8; 
            declare hash h0(dataset: "DI_DM.DATE_DM", hashexp: exponent);
            h0.defineKey( "DATE_SK");
            h0.defineData( "FISCAL_START_DT");
            h0.defineDone();
            if (nlobs = -1) then 
            do; 
               if (h0.Num_Items < 1) then
               do; 
                  put "NOTE: Lookup table is empty: DI_DM.DATE_DM";
                  missing0 = 98; 
               end; 
            end; 
         end; 
         else 
         do; 
            put "NOTE: Lookup table is empty: DI_DM.DATE_DM";
            missing0 = 98; 
         end; 
      end; 
      else 
      do; 
         put "NOTE: Lookup table does not exist or cannot be opened: DI_DM.DATE_DM";
         
         put "NOTE: Abort action indicated, condition= Lookup table missing:"
              " DI_DM.DATE_DM";
         
         abort 9999; 
      end; 
      
      /* Build hash h1 from lookup table DI_DM.DATE_DM */ 
      nlobs = .; 
      dsid = open("DI_DM.DATE_DM"); 
      if (dsid > 0) then 
      do; 
         if ( attrc(dsid, 'MTYPE') = 'DATA' ) then 
            nlobs = attrn(dsid, 'NLOBS'); 
         else 
            nlobs = -1; 
            
         dsid = close(dsid); 
         if (nlobs ^= 0) then 
         do; 
            if (nlobs > 0) then 
               exponent = ceil(log2(nlobs)); 
            else 
               exponent = 8; 
            declare hash h1(dataset: "DI_DM.DATE_DM", hashexp: exponent);
            h1.defineKey( "DATE_SK");
            h1.defineData( "FISCAL_END_DT");
            h1.defineDone();
            if (nlobs = -1) then 
            do; 
               if (h1.Num_Items < 1) then
               do; 
                  put "NOTE: Lookup table is empty: DI_DM.DATE_DM";
                  missing1 = 98; 
               end; 
            end; 
         end; 
         else 
         do; 
            put "NOTE: Lookup table is empty: DI_DM.DATE_DM";
            missing1 = 98; 
         end; 
      end; 
      else 
      do; 
         put "NOTE: Lookup table does not exist or cannot be opened: DI_DM.DATE_DM";
         
         put "NOTE: Abort action indicated, condition= Lookup table missing:"
              " DI_DM.DATE_DM";
         
         abort 9999; 
      end; 
      
      call missing (DATE_SK, FISCAL_START_DT, FISCAL_END_DT); 
   
   end; /* All hash objects have been defined */
   
   /* Read a row from the source table  */ 
   set work.prf_sales_data end = eof;
   
   /* Is the current key value stored in hash h0?  */ 
   if (missing0 < 1) then 
   do; 
      DATE_SK = START_DATE_SK;
      rc0 = h0.find();
      START_DATE = FISCAL_START_DT;
   end; 
   else 
      rc0 = missing0; 
      
   /* Is the current key value stored in hash h1?  */ 
   if (missing1 < 1) then 
   do; 
      DATE_SK = END_DATE_SK;
      rc1 = h1.find();
      END_DATE = FISCAL_END_DT;
   end; 
   else 
      rc1 = missing1; 
      
   /* Examine success of lookups  */ 
   if ( rc0=0 and rc1=0 ) then 
   do; 
      /* Write row to target  */ 
      output work.Lkp_date_dm; 
      return; 
   end; 
   else 
   do; 
      error_total + 1; 
      
      if (rc0 ^= 0) then 
      do; 
         exception_total + 1; 
         if (rc0 = 98) then 
         do; 
            /* Check: Lookup table has no rows-Write exception row  */ 
            /* Check: Lookup table has no rows-Set target columns to value  */ 
         end; 
         
         else 
         do; 
            /* Check: Lookup value not found-Skip the record  */ 
            return; 
         end; 
      end; 
      
      if (rc1 ^= 0) then 
      do; 
         exception_total + 1; 
         if (rc1 = 98) then 
         do; 
            /* Check: Lookup table has no rows-Write exception row  */ 
            /* Check: Lookup table has no rows-Set target columns to value  */ 
         end; 
         
         else 
         do; 
            /* Check: Lookup value not found-Skip the record  */ 
            return; 
         end; 
      end; 
   
   end; /* One or more lookups failed */
   
   if (eof = 1) then 
   do; 
      put "Source records with errors: " error_total ; 
      put "Total lookup exceptions: " exception_total ; 
   end; 

run; 

 %di_etl_rcset(error=&syserr,code=job_rc);

proc datasets lib = work nolist memtype = (data view);
   delete prf_sales_data;
quit;

 %di_etl_rcset(error=&syserr,code=job_rc);


/**  Step end Lkp_date_dm **/

/*============================================================================* 
 * Step:            Load_prf_sales_data_summary             A5W0V4GZ.BH000KAO * 
 * Transform:       Table Loader (Version 2.1)                                * 
 * Description:                                                               * 
 *                                                                            * 
 * Source Table:    Lkp_date_dm - work.Lkp_date_dm          A5W0V4GZ.BK000GVL * 
 * Target Table:    PRF_SALES_DATA_SUMMARY -                A5W0V4GZ.BB0009TH * 
 *                   DI_DM.PRF_SALES_DATA_SUMMARY                             * 
 *============================================================================*/ 


/* --------------------------------------------------------------
   Load Technique Selection: Replace - EntireTable
   -------------------------------------------------------------- */
%macro etls_loader;

   /* Get number of records in table  */ 
   %let etls_recCheckExist = 0; 
   %let etls_recordsBefore = 0; 

   %let etls_recCheckExist = %eval(%sysfunc(exist(DI_DM.PRF_SALES_DATA_SUMMARY, DATA)) or 
   %sysfunc(exist(DI_DM.PRF_SALES_DATA_SUMMARY, VIEW))); 

   %put etls_recCheckExist = &etls_recCheckExist;
      
   %if &etls_recCheckExist > 0 %then %do;

      %put %str(NOTE: Truncating table ...);

      %di_util_truncate_table(DI_DM.PRF_SALES_DATA_SUMMARY);

      %di_etl_rcset(error=&syserr,code=job_rc);
      /*---- Append  ----*/ 
      %put %str(NOTE: Appending data ...);

      proc append base = DI_DM.PRF_SALES_DATA_SUMMARY 
         data = Lkp_date_dm(rename = (start_date = start_dt end_date = end_dt))
         force; 
      run; 
     
     %di_etl_rcset(error=&syserr,code=job_rc);
   
   %end;
   %else %if &etls_recCheckExist = 0 %then %do; 

      data DI_DM.PRF_SALES_DATA_SUMMARY;
         attrib PROD_HIER_SK                        length=6                                            ;
         attrib START_DT                            length=8      FORMAT=DATE9.      INFORMAT=DATE9.    ;
         attrib END_DT                              length=8      FORMAT=DATE9.      INFORMAT=DATE9.    ;
      stop; run;

      proc sql;
         alter table DI_DM.PRF_SALES_DATA_SUMMARY add CONSTRAINT PRIM_KEY PRIMARY KEY (PROD_HIER_SK);
      quit;

      proc append base = DI_DM.PRF_SALES_DATA_SUMMARY 
         data = Lkp_date_dm(rename = (start_date = start_dt end_date = end_dt)) force; 
      run; 

     %di_etl_rcset(error=&syserr,code=job_rc);

   %end;

   %let etls_recordsAfter = %di_util_nobs(DI_DM.PRF_SALES_DATA_SUMMARY);
   %let etls_table = %nrquote(PRF_SALES_DATA_SUMMARY);
   %let etls_lib   = %nrquote(DI_DM);

   %let etls_endTime = %sysfunc(datetime(),datetime.);

/*---- Job status macro  ----*/ 
%put NOTE: The Number of records in source columns(RSOURCE) in JOB_STATUS table contains the total number of records ;
%put NOTE: used in processing from all PRF_SALES_FACT partitions.;
%etls_sendjobstatus(source_table = Lkp_PRODUCT_HIER_ASSOC_DM);

proc datasets lib = work nolist memtype = (data view);
   delete Lkp_PRODUCT_HIER_ASSOC_DM Lkp_date_dm;
quit;
   
%mend etls_loader;
%etls_loader;

/**  Step end Load_prf_sales_data_summary **/



