/* 
SUPPORT: sinsro Rokde, Sangeeta
*/

/****************************************************************************** 
 * Job:             DI_ETL_geo_prod_purge_job                                 * 
 * Description:                                                               * 
 *                                                                            * 
 *                                                                            * 
 * Source Tables:   DIDM_STG.STG_GEO_PROD_PURGE_LIST                          * 
 *                  DI_DM.GEOGRAPHY_DM                                        * 
 *                  DI_DM.PRODUCT_DM                                          * 
 *                  DI_DM.GEO_PROD_PURGE_LIST                                 * 
 *                  DI_DM.GEOGRAPHY_HIER_ASSOC_DM                             * 
 *                  DI_MON.PROD_HIER_SK                                       * 
 *                  DI_DM.PRODUCT_HIER_ASSOC_DM                               * 
 * Target Table:    GEO_PROD_PURGE_LIST -                                     * 
 *                   DI_DM.GEO_PROD_PURGE_LIST                                * 
 *                                                                            * 
 * Generated on:    Tuesday, July 6, 2010 12:21:23 PM IST                     * 
 * Generated by:    sinmna@row                                                * 
 * Version:         SAS Data Integration Studio 4.2                           * 
 * History:         28 Feb 2011 sinsro, Modified the code to handle blank     *
 *                                      value in global parameter viz.        *
 *                                      min_weeks_not_purged                  * 
 *                  10 Mar 2011 sinsro, Modified the job to include SZPK      *
 * tables, return_fact, future_receipt, geo_prod_owned_inv tables partitioned *
 * by for HP logic and removed them from SAS DM partion list                  *
 *                                                                            *
 * S0744841:        16 Mar 2011 sinsro, Modified the job to exclude the VIEWS *
 *                  from being purged.                                        *
 * S0758334:        4 Jul 2011 sinsro, Modified the job to update             *
 *                  MDO_PLAN_GROUP after purging MDO_PLAN_MEMBER              *
 *                                                                            *
 * S0956329:        24May 2013, Modified the job to enhance the performnce    *
 *                  SAS, RDBMS and Partition tables, all will be purged       *
 *                  parallely                                                 *
 *                                                                            *
 * S1294221:        Purge RPP tables based on Geo/Prod provided through stage *
 ******************************************************************************/

/* General macro variables  */
%let etls_jobName = %nrquote(DI_ETL_Geo_prod_purge_job);

/* Setup to capture return codes  */
%global job_rc trans_rc sqlrc etls_startTime;
%let sysrc = 0;
%let job_rc = 0;
%let trans_rc = 0;
%let sqlrc = 0;
%let syscc = 0;
%global syserr;

%macro rcSet(error);
	%if (&error gt &trans_rc) %then
		%let trans_rc = &error;

	%if (&error gt &job_rc) %then
		%let job_rc = &error;
%mend rcSet;

%macro rcSetDS(error);
	if &error gt input(symget('trans_rc'),12.) then
		call symput('trans_rc',trim(left(put(&error,12.))));

	if &error gt input(symget('job_rc'),12.) then
		call symput('job_rc',trim(left(put(&error,12.))));
%mend rcSetDS;

/* Setup for capturing job status  */
%let etls_startTime = %sysfunc(datetime(),datetime.);
%let etls_StartTime_GP_purge=&etls_startTime;
%global start_time end_time;

%di_util_get_time(_time = start_time);
%let etls_recordsBefore = 0;
%let etls_recordsAfter = 0;
%let etls_lib = 0;
%let etls_table =;
%global etls_debug;

%macro etls_setDebug;
	%if %str(&etls_debug) ne 0 %then
		OPTIONS MPRINT%str(;);
%mend;

%etls_setDebug;

/*---- Start of Pre-Process Code  ----*/
/**/
%etl_initjobparam (monlib=di_mon, jobname=%nrquote(&etls_jobName));

/**/
%etl_initchangeflags;

/*---- End of Pre-Process Code  ----*/
%rcSet(&syserr);
%rcSet(&sqlrc);

/*---- End of Pre-Process Code  ----*/
%let etls_stepStartTime = %sysfunc(datetime(), datetime20.);
options mprint;

%macro etl_check_exist;
	%local product_dm_obs geography_dm_obs product_assoc_obs geography_assoc_obs abort;

	/*check global setting variable*/
	/* Check for existence of DI_DM.PRODUCT_DM dataset */
	%if NOT %sysfunc(exist(DI_DM.PRODUCT_DM)) %then
		%do;
			%let etl_msg = %etl_msg(mid=5005,args=DI_DM.PRODUCT_DM);
			%put ______: &etl_msg;
			%let abort = 1;
		%end;
	%else
		%do;
			%let product_dm_obs = %di_util_nobs(DI_DM.PRODUCT_DM);

			%if &product_dm_obs = 0 %then
				%do;
					%let etl_msg = %etl_msg(mid=5008,args=DI_DM.PRODUCT_DM);
					%put ______: &etl_msg;
				%end;
		%end;

	/* Check for existence of DI_DM.PRODUCT_HIER_ASSOC_DM dataset */
	%if NOT %sysfunc(exist(DI_DM.PRODUCT_HIER_ASSOC_DM)) %then
		%do;
			%let etl_msg = %etl_msg(mid=5005,args=DI_DM.PRODUCT_HIER_ASSOC_DM);
			%put ______: &etl_msg;
			%let abort = 2;
		%end;
	%else
		%do;
			%let product_assoc_obs = %di_util_nobs(DI_DM.PRODUCT_HIER_ASSOC_DM);

			%if &product_assoc_obs = 0 %then
				%do;
					%let etl_msg = %etl_msg(mid=5008,args=DI_DM.PRODUCT_HIER_ASSOC_DM);
					%put ______: &etl_msg;
				%end;
		%end;

	/* Check for existence of DI_DM.GEOGRAPHY_DM dataset */
	%if NOT %sysfunc(exist(DI_DM.GEOGRAPHY_DM)) %then
		%do;
			%let etl_msg = %etl_msg(mid=5005,args=DI_DM.GEOGRRPHY_DM);
			%put ______: &etl_msg;
			%let abort = 3;
		%end;
	%else
		%do;
			%let geography_dm_obs = %di_util_nobs(DI_DM.GEOGRAPHY_DM);

			%if &geography_dm_obs = 0 %then
				%do;
					%let etl_msg = %etl_msg(mid=5008,args=DI_DM.GEOGRAPHY_DM);
					%put ______: &etl_msg;
				%end;
		%end;

	/* Check for existence of DI_DM.GEOGRAPHY_HIER_ASSOC_DM dataset */
	%if NOT %sysfunc(exist(DI_DM.GEOGRAPHY_HIER_ASSOC_DM)) %then
		%do;
			%let etl_msg = %etl_msg(mid=5005,args=DI_DM.GEOGRAPHY_HIER_ASSOC_DM);
			%put ______: &etl_msg;
			%let abort = 4;
		%end;
	%else
		%do;
			%let geography_assoc_obs = %di_util_nobs(DI_DM.GEOGRAPHY_HIER_ASSOC_DM);

			%if &geography_assoc_obs = 0 %then
				%do;
					%let etl_msg = %etl_msg(mid=5008,args=DI_DM.GEOGRAPHY_HIER_ASSOC_DM);
					%put ______: &etl_msg;
				%end;
		%end;

	%if &abort gt 0 %then
		%do;
			%etl_abort;
		%end;
%mend etl_check_exist;

%macro check_object_type;
	/*%global exc_rec_cnt;*/
	/*%let exc_rec_cnt=0;*/
	/*Extract valid prod_id and geo_id where OBJECT_TYPE =P or G*/
	data work.STG_GEO_PROD_PURGE_LIST 
		(keep=%di_util_column_names(DIDM_STG.STG_GEO_PROD_PURGE_LIST))
		STG_GEO_PROD_PURGE_LIST_X;
		set DIDM_STG.STG_GEO_PROD_PURGE_LIST;
		OBJECT_TYPE = UPCASE(OBJECT_TYPE);

		if OBJECT_TYPE in ('P','G') then
			output work.STG_GEO_PROD_PURGE_LIST;
		else
			do;
				attrib ETLS_EXCEPTION_COND length = $100;
				ETLS_EXCEPTION_COND = Put(cats(ETLS_EXCEPTION_COND,'0a'x," * %etl_msg(mid=5333,args=OBJECT_TYPE P/G)"),$100.);
				format ETL_Error_JobRunTime datetime16.;
				ETL_Error_JobRunTime = "&etls_stepStartTime"dt;
				output STG_GEO_PROD_PURGE_LIST_X;
			end;
	run;

	proc append base=DI_MON.STG_GEO_PROD_PURGE_LIST_X
		data=WORK.STG_GEO_PROD_PURGE_LIST_X
		(keep=%di_util_column_names(DI_MON.STG_GEO_PROD_PURGE_LIST_X)) force;
	run;

	/*%if %di_util_nobs(WORK.STG_GEO_PROD_PURGE_LIST_X) gt 0 %then %do;*/
	/*   %let exc_rec_cnt=1;*/
	/*%end;*/
%mend;

%etl_check_exist
%check_object_type

%rcSet(&syserr);
%rcSet(&sqlrc);
%let etls_stepStartTime = %sysfunc(datetime(), datetime20.);

proc datasets lib=work nolist nowarn memtype = (data view);
	delete STG_GEO_PROD_PURGE_LIST_X;
quit;

%rcSet(&syserr);

/*============================================================================*
 * split stage data for geo and prods into Lkp_geo and Lkp_prod               * 
 *============================================================================*/
%let etls_stepStartTime = %sysfunc(datetime(), datetime20.);
%let runTime = %sysfunc(datetime());

%di_etl_keep_work_table(STG_GEO_PROD_PURGE_LIST);

proc datasets lib = work nolist nowarn memtype = (data view);
	delete Lkp_geo Lkp_prod Stg_geo_prod_purge_list_x;
quit;

/*---- Begin DATA step to perform lookups  ----*/
data work.Lkp_geo
	( keep = OBJECT_ID OBJECT_TYPE OBJECT_KEY OBJECT_LVL )
	work.Lkp_prod
	( keep = OBJECT_ID OBJECT_TYPE OBJECT_KEY )
	work.Stg_geo_prod_purge_list_x 
	(keep = OBJECT_ID OBJECT_TYPE ETLS_EXCEPTION_COND ETL_Error_JobRunTime)
;
	attrib etls_exception_action length=$32
		etls_lookup_table length=$41
		OBJECT_ID length=$32
		OBJECT_TYPE length=$1
		OBJECT_KEY length=6
		OBJECT_LVL length=4
		GEO_HIER_SK length= 4
		PROD_HIER_SK length = 4
		STD_HIER_GEO_LVL length= 4
		GEO_ID length= $32
		PROD_ID length= $32
		ETLS_EXCEPTION_COND length= $100
		ETL_Error_JobRunTime length=8 format=datetime16.
	;
	retain missing0-missing1 0;
	etls_assign_target_value = 0;

	/* Assign variables used for error/exception handling  */
	etls_source_row      = _n_;
	etls_write_to_error_table  = 0;

	/* Build hash objects from lookup tables before reading first source row  */
	if (_n_ = 1) then
		do;
			/* Build hash h0 from lookup table DI_DM.GEOGRAPHY_DM */
			%di_util_hash_define( h_num = 0, 
				dsn   = %QUOTE(DI_DM.GEOGRAPHY_DM ), 
				d_key = %QUOTE("GEO_ID"), 
				d_data= %QUOTE("GEO_HIER_SK","STD_HIER_GEO_LVL") 
				);

			/* Build hash h1 from lookup table work.product_dm */
			%di_util_hash_define( h_num = 1, 
				dsn   = %QUOTE(DI_MON.PROD_HIER_SK ), 
				d_key = %QUOTE("PROD_ID"), 
				d_data= %QUOTE("PROD_HIER_SK") 
				);
			call missing (GEO_ID, GEO_HIER_SK, PROD_ID, PROD_HIER_SK);
		end; /* All hash objects have been defined */

	/* Read a row from the source table  */
	set STG_GEO_PROD_PURGE_LIST end = eof;

	if OBJECT_TYPE in ('G') then
		do;
			if missing0 < 1 then
				do;
					GEO_ID = OBJECT_ID;
					rc0 = h0.find();
					OBJECT_KEY = GEO_HIER_SK;
					OBJECT_LVL = STD_HIER_GEO_LVL;
				end;
		end;

	if OBJECT_TYPE in ('P') then
		do;
			if missing1 < 1 then
				do;
					PROD_ID = OBJECT_ID;
					rc1 = h1.find();
					OBJECT_KEY = PROD_HIER_SK;
				end;
		end;

	etl_error_jobruntime = "&etls_stepStartTime"dt;

	if OBJECT_TYPE in ('G') and (missing(GEO_HIER_SK)) then
		do;
			ETLS_EXCEPTION_COND = Put(cats(ETLS_EXCEPTION_COND,'0a'x," * %etl_msg(mid=5306,args=GEO_ID)"),$100.);
			ETL_Error_JobRunTime="&etls_stepStartTime"dt;
		end;

	/*---- Custom Validation: Invalid PROD_ID  ----*/
	if OBJECT_TYPE in ('P') and (missing(PROD_HIER_SK)) then
		do;
			ETLS_EXCEPTION_COND = Put(cats(ETLS_EXCEPTION_COND,'0a'x," * %etl_msg(mid=5306,args=PROD_ID)"),$100.);
			ETL_Error_JobRunTime="&etls_stepStartTime"dt;
		end;

	if missing(ETLS_EXCEPTION_COND) and OBJECT_TYPE in ('G','P') then
		do;
			if OBJECT_TYPE = 'P' then
				do;
					output work.Lkp_prod;
				end;
			else if OBJECT_TYPE = 'G' then
				do;
					output work.Lkp_geo;
				end;
			else
				do;
					output work.Stg_geo_prod_purge_list_x;
				end;
		end;

	if not missing(ETLS_EXCEPTION_COND) then
		do;
			output work.Stg_geo_prod_purge_list_x;
		end;
run;

%rcSet(&syserr);

proc append base=DI_MON.STG_GEO_PROD_PURGE_LIST_X
	data=WORK.STG_GEO_PROD_PURGE_LIST_X
	(keep=%di_util_column_names(DI_MON.STG_GEO_PROD_PURGE_LIST_X)) force;
run;

%rcSet(&syserr);
%rcSet(&sqlrc);

/*Extract child nodes from geograhpy hierarchy*/
proc datasets lib = work nolist nowarn memtype = (data view);
	delete UW_GEO_NODES UW_PROD_NODES UW_PROD_PARENTS UW_GEO_PARENTS UW_PROD_PARENTS_TMP UW_GEO_PARENTS_TMP;
quit;

proc sql noprint;
	create table work.UW_GEO_NODES as 
		select distinct p.GEO_HIER_SK as OBJECT_KEY, 
			'G' as OBJECT_TYPE,
			c.GEO_ID as OBJECT_ID 
		from work.Lkp_geo d, di_data.GEOGRAPHY_HIER_ASSOC_DM p, di_data.GEOGRAPHY_DM c
			where p.parent_geo_hier_sk = d.OBJECT_KEY
				and p.GEO_HIER_ASSOC_CD = 1 
				and c.GEO_HIER_SK=p.GEO_HIER_SK
			order by OBJECT_KEY;
quit;

%rcSet(&syserr);
%rcSet(&sqlrc);

/* Extract child nodes from product hierarchy*/
proc sql noprint;
	create table work.UW_PROD_NODES as 
		select distinct p.PROD_HIER_SK as OBJECT_KEY, 
			'P' as OBJECT_TYPE,
			c.PROD_ID as OBJECT_ID 
		from work.LKP_PROD d, di_data.PRODUCT_HIER_ASSOC_DM p, di_data.product_dm c
			where p.parent_prod_hier_sk = d.OBJECT_KEY
				and p.prod_hier_assoc_cd = 1 
				and c.prod_hier_sk=p.prod_hier_sk
			order by OBJECT_KEY;
quit;

%rcSet(&syserr);
%rcSet(&sqlrc);

%global max_prod_lvl max_geo_lvl;

proc sql noprint;
	select max(prod_lvl) into: max_prod_lvl from di_dm.Product_lvl where PROD_HIER_ASSOC_CD=1;
quit;

%let max_prod_lvl=&max_prod_lvl;
%put ______: max_prod_lvl=&max_prod_lvl;

proc sql noprint;
	select max(geo_lvl) into: max_geo_lvl from di_dm.Geography_lvl where GEO_HIER_ASSOC_CD=1;
quit;

%let max_geo_lvl=&max_geo_lvl;
%put ______: max_geo_lvl=&max_geo_lvl;
			
/*=================================================================================================*
 * Create the final list of products and geographies to purge. This list will have                  *
 * prod_hier_sks and geo_hier_sks that are listed in stg_geo_prod_purge_list and their child nodes. *
 * In the following macro, the prod_hier_sks are extracted from product_dm based on the parameter   *
 * min_weeks_not_purged. Ans also extracts geo_hier_sks from geography_dm based on the parameter    *
 * min_weeks_not_purged. Finally all are appended to one single dataset named Append_geo_prod.      *
 *==================================================================================================*/
%macro Ext_geo_prod_by_min_week;
	%local g_min_weeks_not_purged g_min_days_not_purged ;
	
	%let etls_stepStartTime = %sysfunc(datetime(), datetime20.);

	%di_util_global_setting_spec(spec_nm=min_weeks_not_purged, 
		app=all,
		_spec_value=g_min_weeks_not_purged,
		optional=1
		);

	/*calculating number of days for which data not not be purged*/
	%let g_min_weeks_not_purged=&g_min_weeks_not_purged;
	%put ______: g_min_weeks_not_purged=&g_min_weeks_not_purged;

	%if &g_min_weeks_not_purged ne %str() %then
		%do;
			%let g_min_days_not_purged = %eval(&g_min_weeks_not_purged * 7);
			%put ______: g_min_days_not_purged = &g_min_days_not_purged;

			proc datasets lib = work nolist nowarn memtype = (data view);
				delete Ext_valid_geo_id Append_geo_prod Ext_valid_prod_id;
			quit;
			
			%local app_dt;

			proc sql noprint;
				select coalesce(input(spec_value,mmddyy10.), input("&sysdate9.",date9.) ) into :app_dt
					from &di_data..global_setting
						where upcase(spec_nm) = 'APP_DATE'
							and upcase(app) = 'ALL';
			quit;

			%let app_dt = &app_dt;

			proc sql noprint;
				create view work.Ext_valid_geo_id_vw as
					select
						GEO_HIER_SK as OBJECT_KEY length = 6,
						GEO_ID as OBJECT_ID,
						('G') as OBJECT_TYPE length = 1
					from DI_DM.GEOGRAPHY_DM
						where CLOSING_DT is not missing 
							and CLOSING_DT lt (&app_dt - &g_min_days_not_purged) 
							and STD_HIER_GEO_LVL eq  &max_geo_lvl
				;
			quit;

			proc sql noprint;
				create view work.Ext_valid_prod_id_vw as
					select
						PROD_HIER_SK as OBJECT_KEY,
						PROD_ID as OBJECT_ID,
						('P') as OBJECT_TYPE length = 1
					from DI_DM.PRODUCT_DM
						where PROD_DISCONTINUED_DT is not missing 
							and PROD_DISCONTINUED_DT lt (&app_dt - &g_min_days_not_purged )
							and STD_HIER_PROD_LVL eq &max_prod_lvl;
				;
			quit;

			data work.Append_geo_prod;
				set work.Ext_valid_geo_id_vw
					work.Ext_valid_prod_id_vw
					work.Uw_geo_nodes
					work.Uw_prod_nodes;
				keep OBJECT_ID OBJECT_TYPE OBJECT_KEY;
			run;

		%end;
	%else
		%do;

			data work.Append_geo_prod;
				set work.Uw_geo_nodes
					work.Uw_prod_nodes;
				keep OBJECT_ID OBJECT_TYPE OBJECT_KEY;
			run;

		%end;
%mend Ext_geo_prod_by_min_week;

%Ext_geo_prod_by_min_week;
%rcSet(&syserr);

/*Duplicates might occur after extracting Geos/Prods based on min_weeks_not_purged
hence extracting the distinct rows*/
proc datasets lib=work nolist nowarn memtype = (data view);
	delete Uw_distinct_geo_prod;
quit;

proc sql noprint;
	create table Uw_distinct_geo_prod as
		select distinct object_key , object_type, object_id
			from work.Append_geo_prod;
quit;

%rcSet(&sqlrc);
%rcSet(&syserr);

/*============================================================================* 
 * Step:            Ext_geo_prod_detail                                       * 
 * Description:                                                               * 
 *                                                                            * 
 * Source Table:    Uw_distinct_geo_prod -                                    * 
 *                   work.Uw_distinct_geo_prod                                * 
 * Target Table:    Ext_geo_prod_detail -                                     * 
 *                   work.Ext_geo_prod_detail                                 * 
 *============================================================================*/
%let etls_stepStartTime = %sysfunc(datetime(), datetime20.);

/*---- Map the columns  ----*/
proc datasets lib = work nolist nowarn memtype = (data view);
	delete Ext_geo_prod_detail;
quit;

%put ______: %str(NOTE: Mapping columns ...);

proc sql noprint;
	create table work.Ext_geo_prod_detail as
		select
			OBJECT_ID,
			OBJECT_TYPE,
			OBJECT_KEY,
			("N") as PURGED_FLG length = 1,
			("&etls_startTime"dt) as PURGED_DTTM length = 8
			format = NLDATM21.
			informat = NLDATM21.,
			("&etls_startTime"dt) as CREATED_DTTM length = 8
			format = NLDATM21.
			informat = NLDATM21.
		from Uw_distinct_geo_prod
	;
quit;

%rcSet(&sqlrc);
%rcSet(&syserr);

/*==================================================================================* 
 * The final list of Gep-Prods to be purged are stored in DI_DM.GEO_PROD_PURGE_LIST;*
 * this table will be populated with purged_flg=y and purge datetime                *
/*==================================================================================* 

/*==================================================================================* 
 * Step:            Load_geo_prod_purge_list                                        * 
 * Description:                                                                     * 
 *                                                                                  * 
 * Source Table:    Ext_geo_prod_detail -                                           * 
 *                   work.Ext_geo_prod_detail                                       * 
 * Target Table:    GEO_PROD_PURGE_LIST -                                           * 
 *                   DI_DM.GEO_PROD_PURGE_LIST                                      * 
 *=================================================================================*/
%let etls_stepStartTime = %sysfunc(datetime(), datetime20.);

/*---- Define load data macro  ----*/

/* --------------------------------------------------------------
 Load Technique Selection: Truncate load
 -------------------------------------------------------------- */
%macro etls_loader;
	%let etls_tableOptions =;

	/* Determine if the target table exists  */
	%let etls_tableExist = %eval(%sysfunc(exist(DI_DM.GEO_PROD_PURGE_LIST, DATA)) or 
		%sysfunc(exist(DI_DM.GEO_PROD_PURGE_LIST, VIEW)));

	/*---- Create a new table  ----*/
	%if (&etls_tableExist eq 0) %then
		%do;
			/* if table does not exist  */
			%put ______: %str(NOTE: Creating table ...);

			data DI_DM.GEO_PROD_PURGE_LIST;
				attrib OBJECT_KEY length = 6;
				attrib OBJECT_TYPE length = $1;
				attrib OBJECT_ID length = $32;
				attrib PURGED_FLG length = $1;
				attrib PURGED_DTTM length = 8
					format = NLDATM21.
					informat = NLDATM21.;
				attrib CREATED_DTTM length = 8
					format = NLDATM21.
					informat = NLDATM21.;
				call missing(of _all_);
				stop;
			run;

			%rcSet(&syserr);

			/*---- Create the integrity constraints for a table  ----*/
			%put ______: %str(NOTE: Creating integrity constraints ...);

			proc datasets library=DI_DM nolist;
				modify GEO_PROD_PURGE_LIST;
				ic create not null (OBJECT_KEY);
				ic create not null (OBJECT_TYPE);
				ic create PRIM_KEY = primary key (OBJECT_KEY OBJECT_TYPE);
			quit;

			%rcSet(&syserr);

		%end;  /* if table does not exist  */

	%di_util_truncate_table(DI_DM.GEO_PROD_PURGE_LIST);

	proc append data=work.Ext_geo_prod_detail base=DI_DM.GEO_PROD_PURGE_LIST force;
	run;

	%rcSet(&syserr);
%mend etls_loader;

%etls_loader;
%di_etl_keep_work_table(Ext_geo_prod_detail);

/*=====================================================================================*/
/* Define macros to be used in purge process                                           */
/*=====================================================================================*/
%macro create_arg_table(ds=,ds_type=,purge_lib=);
	/*=====================================================================================*/
	/* NAME:           create_arg_table                                                    */
	/* DESCRIPTION:    This macro creates the argument table to be used in mp_connect      */
	/* INPUTS:         purge_lib - Library from where tables to be purged.                 */
	/*                 ds        - Name of the dataset which is used for creating arg table*/
	/*                 ds_type   - Indicates if arg table is for SAS or RDBMS              */
	/*=====================================================================================*/
	%let ds=&ds;
	%let ds_type=&ds_type;
	%let purge_lib=&purge_lib;
	%global num_of_run;
	%local no_obs_sas;

	proc sort data=temp_lib.&ds out=temp_lib.&ds;
		by descending nobs;
		where  nobs ne 0 and nobs ne .;
	run;

	proc sql noprint;
		select count(*) into: no_obs_sas from temp_lib.&ds;
	quit;

	%let no_obs_sas=&no_obs_sas;
	%put ______: no_obs_sas=&no_obs_sas;
	%put ______: NUM_PARALLEL_EXECUTIONS=&num_parallel_executions;

	/*=====================================================================================*/
	/* Calculate the number of parallel sessions to be run.Depends of number of tables to  */
	/* be purged and number of parallel execution set as global parameter. Which ever is   */
	/* smaller is considered                                                               */
	/*=====================================================================================*/
	%let num_of_run =%sysfunc(min(&no_obs_sas,&num_parallel_executions));
	%put ______: number of parallel runs =  &num_of_run;

	/*=====================================================================================*/
	/* Ranking of the sorted dataset is done so that argument tables are created based on  */
	/* on number of rows in datasets and load balanceing can happen                        */
	/*=====================================================================================*/
	data temp_lib.&ds._ranked;
		set temp_lib.&ds;
		retain rank 0;
		rank=rank+1;

		if rank gt &num_of_run then
			do;
				rank=1;
			end;
	run;

	proc sql noprint;
		create table temp_lib.&ds._ranked_gp as
			select * from temp_lib.&ds._ranked
				order by rank;
	quit;

	/*=====================================================================================*/
	/* Create multiple tables that needs to be purged, these tables are used in mp-connect */
	/*=====================================================================================*/
	data %do i= 1 %to &num_of_run;
		temp_lib.&ds._arg_&i
		%end;
		;
		set temp_lib.&ds._ranked_gp;

		%do i= 1 %to &num_of_run;
			if rank=&i then
				output temp_lib.&ds._arg_&i;
		%end;
	run;

	/*======================================================================================*/
	/* Create the argument table mp_arg_table. this table will have list of table names.    */
	/* Each table name in mp_arg_table in turn will have table to be purged and lib it      */
	/* belongs to                                                                           */
	/*======================================================================================*/
	proc datasets lib = temp_lib nolist nowarn memtype = (data view);
		delete mp_arg_table_&ds_type;
	quit;

	data temp_lib.mp_arg_table_&ds_type;
		attrib table_to_purge length=$45;
		attrib purge_lib length=$8;
		attrib geo_filter_table length=$32;
		attrib prod_filter_table length=$32;
		attrib purge_result_table length=$32;
		attrib ds_type length=$8;
		attrib temp_work_path length=$200;
		attrib l_prefix length=$10;

		%do i= 1 %to &num_of_run;
			table_to_purge = "temp_lib.&ds._arg_&i";
			purge_lib="&purge_lib";
			geo_filter_table= "temp_lib.geo_purge_list";
			prod_filter_table ="temp_lib.prod_purge_list";
			purge_result_table ="di_dm.purge_result_table";
			temp_work_path="&temp_lib_path";
			ds_type="&ds_type";
			l_prefix="&ds_type";
			output;
		%end;
	run;

	proc datasets lib = temp_lib nolist nowarn memtype = (data view);
		delete &ds._ranked &ds._ranked_gp;
	quit;

%mend create_arg_table;

%macro act_app_name;
	%global application_cpo application_rpo application_rpp application_szpf application_szpk;
	%global valid_lic_cpo valid_lic_rpo valid_lic_rpp valid_lic_szpf valid_lic_szpk;
	%let valid_lic_cpo=0;
	%let valid_lic_rpo=0;
	%let valid_lic_rpp=0;
	%let valid_lic_szpf=0;
	%let valid_lic_szpk=0;

	/*the logic for checking active application has been copied from ucmacros\en\auto\di_autoexec.sas*/
	%if %sysfunc(exist(DI_DATA.GLOBAL_SETTING)) %then
		%do;

			proc sql noprint;
				select spec_value into :application_rpo from DI_DATA.GLOBAL_SETTING where upcase(spec_nm) = 'ACTIVE_APP_FLG' and upcase(APP) = 'RPO';
				select spec_value into :application_cpo from DI_DATA.GLOBAL_SETTING where upcase(spec_nm) = 'ACTIVE_APP_FLG' and upcase(APP) = 'CPO';
				select spec_value into :application_rpp from DI_DATA.GLOBAL_SETTING where upcase(spec_nm) = 'ACTIVE_APP_FLG' and upcase(APP) = 'RPP';
				select spec_value into :application_szpf from DI_DATA.GLOBAL_SETTING where upcase(spec_nm) = 'ACTIVE_APP_FLG' and upcase(APP) = 'SZPF';
				select spec_value into :application_szpk from DI_DATA.GLOBAL_SETTING where upcase(spec_nm) = 'ACTIVE_APP_FLG' and upcase(APP) = 'SZPK';
			quit;

			%let application_cpo = &application_cpo;
			%let application_rpo = &application_rpo;
			%let application_rpp = &application_rpp;
			%let application_szpf =&application_szpf;
			%let application_szpk =&application_szpk;
		%end;
	%else
		%do;
			%let application_rpo  = 1;
			%let application_cpo  = 1;
			%let application_szpf = 1;
			%let application_rpp  = 1;
			%let application_szpk = 1;
		%end;

	/* Validate License */
	%if "&application_rpp" eq "1" %then
		%do;
			%let application = RPP;

			%if %di_util_license_validate(RPP) ne 1 %then
				%do;
					%put NOTE: RPP license validation failed.;
					%let valid_lic_rpp=0;
				%end;
			%else
				%do;
					%let valid_lic_rpp=1;
				%end;
		%end;

	%if "&application_cpo" eq "1" %then
		%do;
			%let application = CPO;

			%if %di_util_license_validate(CPO) ne 1 %then
				%do;
					%put NOTE: CPO license validation failed.;
					%let valid_lic_cpo=0;
				%end;
			%else
				%do;
					%let valid_lic_cpo=1;
				%end;
		%end;

	%if "&application_rpo" eq "1" %then
		%do;
			%let application = RPO;

			%if %di_util_license_validate(RPO) ne 1 %then
				%do;
					%put NOTE: RPO license validation failed.;
					%let valid_lic_rpo=1;
				%end;
			%else
				%do;
					%let valid_lic_rpo=1;
				%end;
		%end;

	%if "&application_szpf" eq "1" %then
		%do;
			%let application = SZPF;

			%if %di_util_license_validate(SZPF) ne 1 %then
				%do;
					%put NOTE: SZPF license validation failed.;
					%let valid_lic_szpf=0;
				%end;
			%else
				%do;
					%let valid_lic_szpf=1;
				%end;
		%end;

	%if "&application_szpk" eq "1" %then
		%do;
			%let application = SZPK;

			%if %di_util_license_validate(SZPK) ne 1 %then
				%do;
					%put NOTE: SZPK license validation failed.;
					%let valid_lic_szpk=0;
				%end;
			%else
				%do;
					%let valid_lic_szpk=1;
				%end;
		%end;

%mend;

%macro update_rpp_plan;
	/* This macro is added in D4MICM541 release to address purging of Promotion Tables                               */
	/* The macro will perform the following actions after the purging is complete                                    */
	/* a. Update rpp_plan_result to mark data out-of-date. The rows to be updated                                    */
	/*    are identified the data present in temp_lib.UW_PROD_PARENTS and UW_GEO_PARENTS                             */
	/* b. set rpp_plan.eval_opt_req_cd=0 for which the prods ot locations have been purged from rpp_plan_prod_asgmnt */
	/* c. Update rpp_plan.notes: add [[ prod_id/geo_id being purged in the Notes column for the affected plans       */
	/* d. Update rpp_plan.plan_desc: add prefix GP_Purge to the existing description                                 */
	/* f. Update EVAL_OPT_REQ_CD to 0 to prevent the optimization of the affected plans through batch process.       */
	/* g. Update SCOPE_SK=100 so that in any case the plan will show up in the UI. the purge macro does not          */
	/*    rectify the scope_sk or objecive_sk of plan affected due to purge.                                         */
	/* The table temp_lib.Plans_affected has list of plans affected due to purge                                     */
	/* Before updating plans, check in di_dm.purge_result_table if rpp_plan_prod_asgmnt and/or scope_detail and/or   */
	/* Geo_prod_rpp was successfully purged. rpp_plan_prod_asgmnt/geo_prod_rpp for prod purge and scope_detail for   */
    /* Geo purge. Goe_prod_rpp table has child nodes of the products scope of a plan                                 */

	%local p_flg s_flg init_cnt fin_cnt sinit_cnt sfin_cnt gp_flg ginit_cnt gfin_cnt;

	proc sql noprint;
		select purged_flg,before_rows,after_rows into :p_flg, :init_cnt,:fin_cnt 
			from di_dm.purge_result_table
				where table_nm like '%RPP_PLAN_PROD_ASGMNT%' and datepart(purge_dttm) >= datepart(datetime());
	quit;

	proc sql noprint;
		select purged_flg,before_rows,after_rows into :s_flg, :sinit_cnt,:sfin_cnt 
			from di_dm.purge_result_table
				where table_nm like '%SCOPE_DETAIL%' and datepart(purge_dttm)=datepart(datetime());
	quit;

	proc sql noprint;
		select purged_flg,before_rows,after_rows into :gp_flg, :ginit_cnt,:gfin_cnt 
			from di_dm.purge_result_table
				where table_nm like '%GEO_PROD_RPP%' and datepart(purge_dttm)=datepart(datetime());
	quit;

	%let p_flg=&p_flg;
	%let init_cnt=&init_cnt;
	%let fin_cnt=&fin_cnt;
	%let s_flg=&s_flg;
	%let sinit_cnt=&sinit_cnt;
	%let sfin_cnt=&sfin_cnt;
	%let gp_flg=&gp_flg;
	%let ginit_cnt=&ginit_cnt;
	%let gfin_cnt=&gfin_cnt;
	%local plan_cnt;
	%let plan_cnt=%di_util_nobs(temp_lib.plans_affected);
	%put plans_affected_cnt=&plan_cnt;

	/*%put p_flg=&p_flg; %put init_cnt=&init_cnt; %put fin_cnt=&fin_cnt;*/
	/*%put s_flg=&s_flg; %put sinit_cnt=&sinit_cnt; %put sfin_cnt=&sfin_cnt;*/
	%if (
	      ((&p_flg=Y) and (&init_cnt gt &fin_cnt))
	 or ((&s_flg=Y) and (&sinit_cnt gt &sfin_cnt)) 
	 or ((&gp_flg=Y) and (&ginit_cnt gt &gfin_cnt))
	 or (&plan_cnt > 0)
	    ) %then
		%do;
			%put ______ Updating di_trans.rpp_plan;

			/* Fetch the plan name,desc, notes and status code of the affected plans */
			proc sql noprint;
				create table temp_lib.rpp_validation_checks as
					select a.*,
						b.plan_nm,
						b.plan_desc,
						b.status_cd,
						b.scope_sk as prev_scope_sk,
						b.notes
					from
						temp_lib.plans_affected a, di_trans.rpp_plan b
					where
						a.plan_sk = b.plan_sk
					order by plan_sk;
			quit;

			/*Fetch Prod Ids and Geo IDs from respective Dimensions*/
			%get_prod_id;

			/*Create a temp table having new Notes, Plan_desc and Scope columns, this table is used to update di_trans.rpp_plan*/
			data temp_lib.rpp_validation_checks2 (keep=plan_sk plan_nm plan_desc status_cd status notes PURGE_DT );
				set temp_lib.rpp_validation_checks1;
				format PURGE_DT NLDATM21.;
				format STATUS $20.;
				format NOTES $255.;
				format PURGE_NOTES $1000.;
				retain PURGE_NOTES;

				if first.plan_sk then
					PURGE_NOTES = "[[" || note;
				else PURGE_NOTES = catx(" and ", PURGE_NOTES, note);
				by plan_sk;

				if last.plan_sk;

				if index(Notes,"[[") > 0 then
					do;
						substr(Notes,index(Notes,"[[")) = "";
					end;

				if length(notes) = 0 then
					do;
						Notes = PURGE_NOTES || "]]";
					end;
				else
					do;
						Notes = catx(" ", Notes, PURGE_NOTES, "]]");
					end;

				PURGE_DT = "&etls_startTime"dt;

				if index(Plan_desc,"_GP_PURGE_") = 0 then
					do;
						Plan_Desc = catx(" ", "_GP_PURGE_", Plan_Desc);
					end;

				select ( status_cd );
					when ( 0 )
						do;
							Status = "Draft";
						end;

					when ( 2 )
						do;
							Status = "Approved";
						end;

					when ( 3 )
						do;
							Status = "Executing";
						end;

					when ( 4 )
						do;
							Status = "Executed";
						end;

					otherwise
						do;
							Status = "Tentatively Approved";
						end;
				end;
			run;

			/* These are the steps for merging Original notes and new notes*/
			proc sql noprint;
				create table temp_lib.rpp_validation_checks_unq as 
					select distinct plan_sk, notes as orig_notes from temp_lib.rpp_validation_checks;
			quit;

			/*this step replaces existing string beginning with [[ with space, to avoid having multiple notes being updated for GP purge */
			data temp_lib.rpp_validation_checks_unq;
				set temp_lib.rpp_validation_checks_unq;

				if index(orig_notes,'[[') > 0 then
					do;
						substr(orig_notes,index(orig_notes,'[[')) = "";
					end;
			run;

			proc sort data=temp_lib.rpp_validation_checks_unq;
				by plan_sk;
			run;

			proc sort data=temp_lib.Rpp_validation_checks2;
				by plan_sk;
			run;

			data temp_lib.Rpp_validation_checks3;
				merge temp_lib.Rpp_validation_checks_unq temp_lib.Rpp_validation_checks2;
				by plan_sk;
			run;

			data temp_lib.Rpp_validation_checks4 (rename=(p_notes=NOTES)drop=notes orig_notes);
				set temp_lib.Rpp_validation_checks3;
				format P_NOTES $255.;
				by plan_sk;

				if first.plan_sk then
					do;
						P_NOTES = trim(orig_notes)||" " ||trim(NOTES);
					end;
			run;

			/*
			Update EVAL_OPT_REQ_CD to 0 to prevent the optimization of the affected plans through batch process.
			Update SCOPE_SK=100 so that in any case the plan will show up in the UI. the purge macro does not
			rectify the scope_sk or objecive_sk of plan affected due to purge. 
			*/

			/* Update RPP_PLAN table */
			%local sql;
			%let sql= %str(update di_trans.rpp_plan a
				set EVAL_OPT_REQ_CD = 0,
				SCOPE_SK = 100,
				OBJECTIVE_SK = 100,
				NOTES = (select b.Notes from temp_lib.rpp_validation_checks4 b where a.plan_sk = b.plan_sk),
				PLAN_DESC = (select b.Plan_Desc from temp_lib.rpp_validation_checks4 b where a.plan_sk = b.plan_sk)
				where plan_sk in (SELECT plan_sk from temp_lib.rpp_validation_checks4));

			%di_dm_trans_update(upload_lib=temp_lib,
				upload_table=rpp_validation_checks4,
				update_table=rpp_plan,
				sql=&sql
				);

			/* Create a permanant dataset as DI_MON.INVALID_PLANS_GP_PURGE for reference */
			data DI_MON.INVALID_PLANS_GP_PURGE;
				set temp_lib.rpp_validation_checks4;
			run;

		%end;

	/* Update di_trans.rpp_plan_result to mark data out-of-date for all the parent nodes of */
	/* purged Geos and Prods                                                                */
	%put _____ updating rpp_plan_result to mark it out-of-date;

	%update_rpp_plan_result;

	/* Deleting temp tables */
	
	proc datasets lib=temp_lib nolist nowarn memtype = (data);
	   delete Rpp_validation_checks Rpp_validation_checks1 Rpp_validation_checks2 Rpp_validation_checks3 Rpp_validation_checks4 Rpp_validation_checks_unq
	   Update_note_scope Update_plan_notes Plans_affected_id Plans_affected;
	quit;
	
%mend update_rpp_plan;

%macro update_rpp_plan_result;
	/* Update di_trans.rpp_plan_result to mark data out-of-date for all the parent nodes of       */
	/* purged Geos and Prods                                                                      */
	/* The parnet nodes of purged prods and geos are stored in Uw_prod_parents and Uw_geo_parents */
	%if %sysfunc(exist(temp_lib.Uw_prod_parents)) and  %di_util_nobs(temp_lib.Uw_prod_parents) gt 0 %then
		%do;
			%put _______ Update RPP_PLAN_RESULT table for Product deletion;

			/* Update RPP_PLAN_RESULT table */
			%let sql = update di_trans.rpp_plan_results p1 set STATUS = (select 1 from temp_lib.Uw_prod_parents p2 where p1.prod_hier_sk = p2.prod_hier_sk)
				where p1.prod_hier_sk in (select prod_hier_sk from temp_lib.Uw_prod_parents);

			%di_dm_trans_update(upload_lib=temp_lib,upload_table=Uw_prod_parents,update_table=rpp_plan_results,sql=&sql);
		%end;

	%if %sysfunc(exist(temp_lib.Uw_geo_parents)) and %di_util_nobs(temp_lib.Uw_geo_parents) gt 0 %then
		%do;
			%put _______ Update RPP_PLAN_RESULT table for Geography deletion;

			/* Update RPP_PLAN_RESULT table */
			%let sql = update di_trans.rpp_plan_results p1 set STATUS = (select 1 from temp_lib.Uw_geo_parents p2 where p1.geo_hier_sk = p2.geo_hier_sk)
				where p1.geo_hier_sk in (select geo_hier_sk from temp_lib.Uw_geo_parents);

			%di_dm_trans_update(upload_lib=temp_lib,upload_table=Uw_geo_parents,update_table=rpp_plan_results,sql=&sql);
		%end;
%mend update_rpp_plan_result;

%macro get_prod_id;
	%put _____ get Prod ID and Geo ID of the products-geographies that are purged;

	/*
	proc sql;
		create table temp_lib.Plans_affected_id
			as select
				a.plan_sk,
				a.plan_nm,
				a.plan_desc,
				a.status_cd,
				a.prod_hier_sk,
				b.prod_id,
				a.geo_hier_sk,
				c.geo_id
			from temp_lib.rpp_validation_checks a
				left join di_data.product_dm b 
		on a.prod_hier_sk = b.prod_hier_sk
		left join di_data.geography_dm c
			on a.geo_hier_sk=c.geo_hier_sk
			order by plan_sk;
	quit;
   */

	/*create a table with Notes having list of purged Prod IDs and Geo Ids*/
	data temp_lib.update_plan_notes(keep=plan_sk plan_nm plan_desc status_cd note );
/*		set temp_lib.Plans_affected_id;*/
	    set temp_lib.plans_affected;
		format prod_ids $900.;
		retain prod_ids;
		format geo_ids $900.;
		retain geo_ids;
		format note $255.;

		if first.plan_sk then
			do;
				if not missing(prod_id) then
					do;
						prod_ids = prod_id;
					end;
				else prod_ids='';

				if not missing(geo_id) then
					do;
						geo_ids = geo_id;
					end;
				else geo_ids='';
			end;
		else
			do;
				if not missing(prod_id) then
					do;
						if missing(prod_ids) then
							prod_ids = prod_id;
						else prod_ids = cats(prod_ids,',', prod_id);
					end;

				if not missing(geo_id) then
					do;
						if missing(geo_ids) then
							geo_ids = geo_id;
						else geo_ids = cats(geo_ids,',', geo_id);
					end;
			end;

		by plan_sk;

		*Note = " Purged PROD(s)-" ||trim(prod_ids)||" GEO(s)-" ||trim(geo_ids);
		if lengthn(trim(prod_ids))>0 then
			do;
				Note1 = " PRODs-" ||trim(prod_ids);
			end;

		if lengthn(trim(geo_ids))>0 then
			do;
				Note2= " GEOs-" ||trim(geo_ids);
			end;

/*		Note = catx(" ","Purged",Note1,Note2);*/
        Note = catx(" ","Purged",Note1,Note2," and/or their child nodes");
		if last.plan_sk;
	run;

	/* Create a table with Scope having required comment along with old and new scope sk*/
	data temp_lib.update_note_scope (keep=plan_sk plan_nm plan_desc status_cd note scope_sk prev_scope_sk );
/*		set temp_lib.Rpp_validation_checks;*/
	    set temp_lib.plans_affected;
		format prod_ids $900.;
		format note $255.;
		retain prod_ids;
		by plan_sk;
		scope_sk=100;
		Note = catx(" ","Scope SK changed from",prev_scope_sk,"to",100);

		if last.plan_sk;
	run;

	/*Merge both, Notes and Scope related temp tables*/
	data temp_lib.rpp_validation_checks1;
		set temp_lib.update_note_scope temp_lib.update_plan_notes;
	run;

	proc sort data=temp_lib.rpp_validation_checks1 noduprec;
		by plan_sk;
	run;

%mend;

%macro update_num_geo_prd_mem;
	/* Update number of geos, prods and members in di_trans.MDO_PLAN_GROUP */
	%local sql work;
	%let work=work;
	%let sql = %str(select count (distinct(geo_hier_sk)) as num_geos,
		count (distinct(prod_hier_sk)) as num_prods,
		count(*) as num_members,
		mdo_plan_group_sk
		from di_trans.mdo_plan_member
		group by mdo_plan_group_sk);

	%di_dm_trans_exe(pass_through_sql=%str(&sql),_output_table=work.mdo_update);
	%let sql = %str(merge into di_trans.mdo_plan_group A using &work..mdo_update B
		on (A.mdo_plan_group_sk = B.mdo_plan_group_sk) when matched
		then update set A.num_members = B.num_members,
		A.num_prods = B.num_prods,
		A.num_geos = B.num_geos,
		A.updated_dttm = datetime());

	%if %upcase("&DI_TRANS_VENDOR") ne "SAS" %then
		%do;
			%di_dm_trans_update(upload_lib=&work,upload_table=mdo_update,update_table=mdo_plan_group,lock=0,sql=%str(&sql));
		%end;
	%else
		%do;

			proc sql noprint;
				update di_trans.mdo_plan_group A set num_members = (Select num_members from &work..mdo_update B where A.mdo_plan_group_sk = B.mdo_plan_group_sk),
					num_prods = (select num_prods from &work..mdo_update B where A.mdo_plan_group_sk = B.mdo_plan_group_sk),
					num_geos = (select num_Geos from &work..mdo_update B where A.mdo_plan_group_sk = B.mdo_plan_group_sk)
				where mdo_plan_group_sk = (select mdo_plan_Group_sk from &work..mdo_update B where A.mdo_plan_group_sk = B.mdo_plan_group_sk);
			quit;

		%end;
%mend;

%macro refresh_mdo_plan_group;
	/* Find common ancestor parent Keys and update MDO_PLAN_GROUP */
	%local prod_sql geo_sql work_path;

	%di_util_delete_tmp_folder(relative_dir = mpg_refresh, _return_code=_rc);
	%let work_path = %di_util_create_tmp_folder(relative_dir = mpg_refresh);
	libname m_parent "&work_path";
	%let work = m_parent;
	%let geo_sql = %str(select parent_geo_hier_Sk,parent_geo_lvl,mdo_plan_group_sk from (
		select min(parent_geo_hier_sk) as parent_geo_hier_sk,
		parent_geo_lvl, mdo_plan_group_sk,
		count(distinct(parent_geo_hier_sk)) as child_count
		from di_trans.geography_hier_assoc_dm pa, di_trans.mdo_plan_member b
		where pa.geo_hier_assoc_cd=1 and b.geo_hier_sk = pa.geo_hier_sk
		group by parent_geo_lvl,mdo_plan_group_sk ) J
		where child_count = 1 order by mdo_plan_group_sk,parent_geo_lvl desc );
	%let prod_sql = %str(select parent_prod_hier_Sk,parent_prod_lvl,mdo_plan_group_sk from (
		select min(parent_prod_hier_sk) as parent_prod_hier_sk,
		parent_prod_lvl, mdo_plan_group_sk,
		count(distinct(parent_prod_hier_sk)) as child_count
		from di_trans.product_hier_assoc_dm pa, di_trans.mdo_plan_member b
		where pa.prod_hier_assoc_cd=1 and b.prod_hier_sk = pa.prod_hier_sk
		group by parent_prod_lvl,mdo_plan_group_sk )J
		where child_count = 1 order by mdo_plan_group_sk,parent_prod_lvl desc );

	%di_dm_trans_exe(pass_through_sql=&prod_sql,_output_table=&work..prod_parent);
	%di_dm_trans_exe(pass_through_sql=&geo_sql,_output_table=&work..geo_parent);

	data &work..prod_parent;
		set &work..prod_parent (sortedby = mdo_plan_group_sk drop=parent_prod_lvl);
		by mdo_plan_group_sk;

		if first.mdo_plan_group_sk then
			output;
	run;

	data &work..geo_parent;
		set &work..geo_parent (sortedby = mdo_plan_group_sk drop=parent_geo_lvl);
		by mdo_plan_group_sk;

		if first.mdo_plan_group_sk then
			output;
	run;

	data &work..plan_update;
		merge &work..prod_parent &work..geo_parent;
		by mdo_plan_group_sk;
	run;

	%if "&DI_TRANS_VENDOR" EQ "SAS" %then
		%do;

			data di_trans.mdo_plan_group;
				modify di_trans.mdo_plan_group 
					&work..plan_update(keep=mdo_plan_group_sk parent_prod_hier_sk parent_geo_hier_sk)
					UPDATEMODE=NOMISSINGCHECK;
				by mdo_plan_group_sk;

				if _iorc_ eq 0 then
					replace;
				else
					do;
						_iorc_=0;
						_error_=0;
					end;
			run;

		%end;
	%else
		%do;
			%local plan_sql;
			%let plan_sql = %str(merge into di_trans.mdo_plan_group A using &work..plan_update B
				on (A.mdo_plan_group_sk = B.mdo_plan_group_sk) 
				when matched then update 
				set A.parent_prod_hier_sk = B.parent_prod_hier_sk,
				A.parent_geo_hier_sk = B.parent_geo_hier_sk );

			%di_dm_trans_update(
				upload_lib=&work,
				upload_table=&work..plan_update,
				update_table=mdo_plan_group,
				sql=&plan_sql,
				lock=0,
				chunk=0);
		%end;
%mend;
%macro get_child_nodes_parent_prod;
   %let j=1;
   %do i= 2 %to &max_prod_lvl.;
      %if %sysfunc(exist(lv&j.)) %then
	     %do;
		    proc sql;
               create table lv&i. as 
				   select prod_hier_sk from di_mon.parent_prod_hier_sk pp
					   where pp.parent_prod_hier_sk in (select lv1.prod_hier_sk from work.lv&j. lv1) and prod_hier_assoc_cd=1 
			    ;
		    quit;

			proc append data = work.lv&i.  base=temp_lib.all_child force;
			run;
         %end;
         %let j=&i;
	%end;
%mend get_child_nodes_parent_prod;

%macro get_child_nodes_parent_geo;
   %let j=1;
   %do i= 2 %to &max_geo_lvl.;
      %if %sysfunc(exist(lv&j.)) %then
	     %do;
		    proc sql;
               create table lv&i. as 
				  select geo_hier_sk from di_mon.Parent_geo_hier_sk pp
				      where pp.Parent_geo_hier_sk in (select lv1.geo_hier_sk from work.lv&j. lv1) and geo_hier_assoc_cd=1 
		    ;
			quit;
            proc append data = work.lv&i.  base=temp_lib.all_orphan_child force;
            run;
        %end;
        %let j=&i;
	%end;
%mend get_child_nodes_parent_geo;
%macro purge_dm_hier;
	/*================================================================================================*/
	/* This macro is used to purge Product_dm, Geography_dm, and their corresponding hierarchies from */
	/* DI_DATA and DI_TRANS                                                                           */
	/*================================================================================================*/
	%if %sysfunc(exist(DI_DM.purge_result_table)) %then
		%do;
			/*Purge only when purge_result_table do exist */
			%local l_prg_flg_cnt prg_flg geo_flg prod_flg geo_hier_flg prod_hier_flg l_res_tbl_cnt;

			proc sql noprint;
				select count(*) into: l_prg_flg_cnt from di_dm.Purge_result_table 
					where purged_flg='N' and purge_dttm >= "&etls_StartTime"dt;
			quit;

			%let l_prg_flg_cnt=&l_prg_flg_cnt;
			%let l_res_tbl_cnt = %di_util_nobs(di_dm.Purge_result_table);
			%put ______: No of records in purge_result_table = &l_res_tbl_cnt;
			%put ______: Count of records in purge_result_table with purged_flg=N = &l_prg_flg_cnt;

			%if (&l_prg_flg_cnt eq 0 and &l_res_tbl_cnt ne 0) %then
				%do;
					/*Purge only when purge_result_table has NO rows with purged_flg=N*/
					/*================================================================================================*/
					/*temp_lib.purge_sas_ind_tables: Will have entries for product_dm, Geo_dm, prod_hier_assoc_dm     */
					/*and geo_hier_assco_dm with lib-di_dm                                                            */
					/*temp_lib.purge_rdbms_ind_dm_tables: Will have entries for product_dm, Geo_dm with lib-di_dm2    */
					/*temp_lib.purge_rdbms_ind_hier_tables: Will have entries for product_hier_assoc_dm               */
					/*and geo_hier_assco_dm with lib-di_dm2. This table is separate as dangling nodes need to deleted */
					/*from only hierarchy tables and not from dim. The geo/prod filter tables for these are created   */
					/*separately                                                                                      */
					/*================================================================================================*/
					libname temp_lib "&temp_lib_path";

					data temp_lib.purge_sas_ind_tables
						temp_lib.purge_rdbms_ind_dm_tables (DROP=purge_table_name)
						temp_lib.purge_rdbms_ind_hier_tables (DROP=purge_table_name);
						attrib memname length=$40;
						attrib purge_table_name length=$100;
						prod_hier_sk_true=1;
						geo_hier_sk_true=0;
						libname='DI_DM_P';
						memname='PRODUCT_DM';
						purge_table_name='DI_DATA\PRODUCT_DM';
						output temp_lib.purge_sas_ind_tables;
						libname="DI_DM2";
						output temp_lib.purge_rdbms_ind_dm_tables;
						memname='PRODUCT_HIER_ASSOC_DM';
						output temp_lib.purge_rdbms_ind_hier_tables;
						libname='DI_DM_P';
						purge_table_name='DI_DATA\PRODUCT_HIER_ASSOC_DM';
						output temp_lib.purge_sas_ind_tables;
						prod_hier_sk_true=0;
						geo_hier_sk_true=1;
						libname='DI_DM_P';
						memname='GEOGRAPHY_DM';
						purge_table_name='DI_DATA\GEOGRAPHY_DM';
						output temp_lib.purge_sas_ind_tables;
						libname="DI_DM2";
						output temp_lib.purge_rdbms_ind_dm_tables;
						memname='GEOGRAPHY_HIER_ASSOC_DM';
						output temp_lib.purge_rdbms_ind_hier_tables;
						libname='DI_DM_P';
						purge_table_name='DI_DATA\GEOGRAPHY_HIER_ASSOC_DM';
						output temp_lib.purge_sas_ind_tables;
					run;

					%di_util_purge_unit_by_gp(
						table_to_purge=temp_lib.purge_sas_ind_tables, 
						purge_lib = di_dm_p,
						geo_filter_table = temp_lib.Geo_purge_list,
						prod_filter_table = temp_lib.Prod_purge_list,
						purge_result_table =di_dm.purge_result_table,
						ds_type=SAS,
						temp_work_path=&temp_lib_path,
						l_prefix=SAS);
					%di_util_purge_unit_by_gp(
						table_to_purge=temp_lib.purge_rdbms_ind_dm_tables, 
						purge_lib = di_dm2,
						geo_filter_table = temp_lib.Geo_purge_list,
						prod_filter_table = temp_lib.Prod_purge_list,
						purge_result_table =di_dm.purge_result_table,
						ds_type=RDBMS,
						temp_work_path=&temp_lib_path,
						l_prefix=RDBMS);
					%di_util_purge_unit_by_gp(
						table_to_purge=temp_lib.purge_rdbms_ind_hier_tables, 
						purge_lib = di_dm2,
						geo_filter_table = temp_lib.Geo_with_dangling_nodes,
						prod_filter_table = temp_lib.Prod_with_dangling_nodes,
						purge_result_table =di_dm.purge_result_table,
						ds_type=RDBMS,
						temp_work_path=&temp_lib_path,
						l_prefix=RDBMS);

									
					* Purge DI_MON.Unbalanced_product_hier;
					* defect: S1306311: CRP:DI_ETL_Geo_prod_purge_job does not purge DI_MON.UNBALANCED_*_HIER tables;
                   
                   /* Purge di_mon.parent_prod_hier_sk: DI_MON.PARENT_PROD_HIER_SK has entries for each PROD_HIER_SK and it's */
                   /* immediate parent. It will have entries for ALL the products irrespective of whether it has complete     */
                   /* hierarchy information or not The code below fetches the child nodes [from DI_MON.PARENT_PROD_HIER_SK]   */
                   /* of all the products lying in temp_lib.prod_purge_list these child nodes may be here coz of partail      */
                   /* hierarchy info and will not be present in DI_DATA.PRODUCT_HIER_ASSOC_DM.                                */
                   /* DI_MON.UNBALANCED_PRODUCT_HIER will get cleaned up when Load_st2dm_product_hier_assoc_dm runs           */
                   /* Same is applicable for DI_MON.UNBALANCED_GEOGRAPHY_HIER*/
                   /* Create an empty table work.all_child and work.all_orphan_child. These tables will be available even if  */
                   /* there no partial hier info fro prod and geo respectively                                                */

				   data temp_lib.all_orphan_child;
                      attrib geo_hier_sk length=8;
					  stop;
				   run;
				   data temp_lib.all_child;
                      attrib prod_hier_sk length=8;
					  stop;
				   run;

                   proc sql;
	                   create table work.lv1 as 
		                  select prod_hier_sk from di_mon.parent_prod_hier_sk pp
			                 where pp.parent_prod_hier_sk in (select prg.prod_hier_sk from temp_lib.prod_purge_list prg) and prod_hier_assoc_cd=1
				                except
			                 select prod_hier_sk from  di_mon.parent_prod_hier_sk pp where pp.prod_hier_sk in (select prod_hier_sk from temp_lib.prod_purge_list) and prod_hier_assoc_cd=1
	                   ;
                   quit;

                   proc append data=work.lv1  base=temp_lib.all_child force;
                   run;

                   /* work.lv1 created above will have immediate child of products from temp_lib.prod_purge_list    */
                   /* The macro get_child_nodes_parent_prod below will fetch child nodes of products fetched in     */
                   /* work.lv1 and loop thro' to get further child nodes having parent as the previous child node.  */
                   /* This will occur till max_prod_lvl. All these child nodes will be appended in work.all_orphan_child */

                  %get_child_nodes_parent_prod;

                    * Purge all the prods in temp_lib.prod_purge_list and work.all_child  from DI_MON.PARENT_PROD_HIER_SK;
					%if %sysfunc(exist(DI_MON.PARENT_PROD_HIER_SK)) %then
						%do;
							proc sql noprint;
								delete from DI_MON.PARENT_PROD_HIER_SK a
									where prod_hier_sk in (select prod_hier_sk
										from temp_lib.Prod_purge_list);
								delete from DI_MON.PARENT_PROD_HIER_SK a
									where prod_hier_sk in (select prod_hier_sk
										from temp_lib.all_child);
							quit;
						%end;

					* Purge DI_MON.Unbalanced_geography_hier;
					* defect: S1306311: CRP:DI_ETL_Geo_prod_purge_job does not purge DI_MON.UNBALANCED_*_HIER tables;

				   proc sql;
	                   create table work.lv1 as 
		                  select geo_hier_sk from di_mon.Parent_geo_hier_sk pp
			                 where pp.Parent_geo_hier_sk in (select prg.geo_hier_sk from temp_lib.geo_purge_list prg) and geo_hier_assoc_cd=1
				                except
			                 select geo_hier_sk from  di_mon.Parent_geo_hier_sk pp where pp.geo_hier_sk in (select geo_hier_sk from temp_lib.geo_purge_list) and geo_hier_assoc_cd=1
	                   ;
                   quit;

                   proc append data=work.lv1  base=temp_lib.all_orphan_child force;
                   run;

                   /* work.lv1 created above will have immediate child of locations from temp_lib.geo_purge_list     */
                   /* The macro below will fetch child nodes of locations fetched in work.lv1 and loop thro' to get  */
                   /* further child nodes having parent as the previous child node.This will occur till max_geo_lvl  */
                   /* All these child nodes will be appended in work.all_orphan_child                                */

				   %get_child_nodes_parent_geo;

                    * Purge all the geos in temp_lib.geo_purge_list and work.all_orphan_child  from DI_MON.PARENT_GEO_HIER_SK;
					%if %sysfunc(exist(DI_MON.PARENT_GEO_HIER_SK)) %then
						%do;
							proc sql noprint;
								delete from DI_MON.PARENT_GEO_HIER_SK a
									where geo_hier_sk in (select geo_hier_sk
										from temp_lib.geo_purge_list);
								delete from DI_MON.PARENT_GEO_HIER_SK a
									where geo_hier_sk in (select geo_hier_sk
										from temp_lib.all_orphan_child);
							quit;
						%end;
					

				%end; /*END: Purge only when purge_result_table has NO rows with purged_flg=N*/
			%else
				%do;
					%put ______: Either purge_result_table has NO rows with purged_flg=N or purge_result_table is empty;
				%end;

	%end;
		%else
			%do;
				%put _______: DI_DM.purge_result_table does not exist;
			%end;
%mend purge_dm_hier;

%macro copy_dm_to_partitions;
	/* This macro copies data from DI_DATA.PRODUCT_DM and DI_DATA.PRODUCT_HIER_ASSOC_DM */
	/* to respective partitons                                                          */
	data work.exclude_partition_tables (keep=Table_Nm);
		set di_trans.table_partition_meta;
		where PARTITION_FLG=1
			and TABLe_NM not in ('PRODUCT_DM','PRODUCT_HIER_ASSOC_DM');
	run;

	%let partition_exclude_list = work.exclude_partition_tables;

	%di_etl_partition_data(
		from_lib=di_data,
		increment_count=8000000,
		num_parallel_jobs=&num_parallel_executions,
		refresh_mapping=1,
		exclude_list=&partition_exclude_list,
		resume=0);
%mend copy_dm_to_partitions;

%macro refresh_product_group;
	%local g_max_prod_lvl;

	/*============================================================================* 
	 * Recalculate the NUM_PRODS and MIN_PROD_LVL in PRODUCT_GROUPS
 *============================================================================*/

	/*Get group sks present in current product group member*/
	%di_dm_trans_extract(
		di_trans      = di_dm2,
		trans_table   = Product_group_member,
		all_trans     = 0,
		_output_table = curr_grp_mem2
		);

	/*Get the group sks present in current product group*/
	%di_dm_trans_extract(
		di_trans      = di_dm2,
		trans_table   = Product_group,
		all_trans     = 0,
		_output_table = curr_grps2
		);

	proc sql noprint;
		select max(prod_lvl) 
			into :g_max_prod_lvl
				from di_dm.product_lvl
					where PROD_HIER_ASSOC_CD = 1;
	quit;

	%put g_max_prod_lvl=&g_max_prod_lvl;

	proc sql noprint;
		Create table to_update as 
			select prod_group_sk, 
				sum
			(case 
				when prod_hier_sk is null then 0 
				else 1 
			end)
		as num_prods,
			max(prod_lvl) as min_prod_lvl
		from  (  Select a.prod_group_sk ,
			c.prod_hier_sk,
			max(coalesce(c.PARENT_PROD_LVL,0)) as prod_lvl
		from curr_grps2 as a 
			left join 
				curr_grp_mem2 as b 
				on a.prod_group_sk = b.prod_group_sk
			left join 
				di_dm.Product_hier_assoc_dm as  c 
				on b.prod_hier_sk = c.parent_prod_hier_sk and
				c.PROD_LVL = &g_max_prod_lvl and
				c.prod_hier_assoc_cd=1
			group by a.prod_group_sk, c.prod_hier_sk )
			group by prod_group_sk;
	quit;

	%di_dm_trans_update(upload_lib=work,
		upload_table=to_update,
		update_table=product_group,
		sql=%str(update di_trans.product_group t1
		set num_prods = (select num_prods from work.to_update where t1.prod_group_sk = prod_group_sk)
		where prod_group_sk in (select distinct prod_group_sk from work.to_update)
		));
	%di_dm_trans_update(upload_lib=work,
		upload_table=to_update,
		update_table=product_group,
		sql=%str(    update di_trans.product_group t1
		set min_prod_lvl = (select min_prod_lvl from work.to_update where t1.prod_group_sk = prod_group_sk)
		where prod_group_sk in (select distinct prod_group_sk from work.to_update)
		));
%mend refresh_product_group;

%macro refresh_geography_group;
	/*============================================================================* 
	 * Recalculate the NUM_GEOS and MIN_GEO_LVL in GEOGRAPHY_GROUPS
 *============================================================================*/
	%local g_max_geo_lvl;

	proc sql noprint;
		select max(geo_lvl) 
			into :g_max_geo_lvl
				from di_dm.geography_lvl
					where GEO_HIER_ASSOC_CD = 1;
	quit;

	%let g_max_geo_lvl=&g_max_geo_lvl;
	%put g_max_geo_lvl=&g_max_geo_lvl;

	proc datasets lib = work nolist nowarn memtype = (data view);
		delete curr_grp_mem2 curr_grps2 to_update
		;
	quit;

	/*============================================================================* 
	 * Recalculate the NUM_GEOS and MIN_GEO_LVL in GEOGRAPHY_GROUPS
 *============================================================================*/

	/*Get group sks present in current geo group member*/
	%di_dm_trans_extract(
		di_trans      = di_dm2,
		trans_table   = geography_group_member,
		all_trans     = 0,
		_output_table = curr_grp_mem2
		);

	/*Get the group sks present in current geography group*/
	%di_dm_trans_extract(
		di_trans      = di_dm2,
		trans_table   = geography_group,
		all_trans     = 0,
		_output_table = curr_grps2
		);

	proc sql noprint;
		Create table work.to_update as 
			select geo_group_sk, 
				sum
			(case 
				when geo_hier_sk is null then 0 
				else 1 
			end)
		as num_geos,
			max(geo_lvl) as min_geo_lvl
		from  (  Select a.geo_group_sk ,
			c.geo_hier_sk,
			max(coalesce(c.PARENT_GEO_LVL,0)) as geo_lvl
		from work.curr_grps2 as a 
			left join 
				work.curr_grp_mem2 as b 
				on a.geo_group_sk = b.geo_group_sk
			left join 
				di_dm.geography_hier_assoc_dm as  c 
				on b.geo_hier_sk = c.parent_geo_hier_sk and
				c.geo_lvl = &g_max_geo_lvl and
				c.geo_hier_assoc_cd=1
			group by a.geo_group_sk, c.geo_hier_sk )
			group by geo_group_sk;
	quit;

	/*============================================================================* 
	 * Update the GEOGRAPHY_GROUP table in DI_TRANS based on the newly calculated
	 * values for NUM_GEOS and MIN_GEO_LVL
 *============================================================================*/
	%di_dm_trans_update(upload_lib=work,
		upload_table=to_update,
		update_table=geography_group,
		sql=%str(update di_trans.geography_group t1
		set num_geos = (select num_geos from work.to_update where t1.geo_group_sk = geo_group_sk)
		where geo_group_sk in (select distinct geo_group_sk from work.to_update)
		));
	%di_dm_trans_update(upload_lib=work,
		upload_table=to_update,
		update_table=geography_group,
		sql=%str(update di_trans.geography_group t1
		set min_geo_lvl = (select min_geo_lvl from work.to_update where t1.geo_group_sk = geo_group_sk)
		where geo_group_sk in (select distinct geo_group_sk from work.to_update)
		));
%mend refresh_geography_group;

%macro run_prf_sales_agg_summary;
	%local etljobpath;
	%let etljobpath=%bquote(%di_util_misc_path()/etlsas);
	%put &etljobpath;
	%put ______: Executing Load_DM_Prf_prod_agg....;

	%etl_exec_job(etlsaspath=&etljobpath,jobname=Load_DM_Prf_prod_agg);
	%put Value of syscc after executing Load_DM_Prf_prod_agg: &syscc;
	%put ______: Executing Load_DM_Prf_sales_data_summary....;

	%etl_exec_job(etlsaspath=&etljobpath,jobname=Load_DM_Prf_sales_data_summary);
%mend run_prf_sales_agg_summary;

%macro prepare_input_purge_so;
	/*===========================================================================================*/
	/* Purge geos and prods from tables related to Size Profile application                      */
	/*===========================================================================================*/
	/*===========================================================================================*/
	/* This change is to introduce purging of SO tables. The macro used for purging SO tables is */
	/* %szpf_prod_purge_reclass and is written by Eric Yang                                      */

	/* %macro szpf_prod_purge_reclass(
	   table_prod_remove=WORK.deleted_products,
	   table_prod_move=WORK.reclassed_products,
	   debug=0
	   );
	*/

	/* table_prod_move: reclassed_products - must be empty                                       */
	/* table_prod_remove: work.Deleted_products                                                  */
	/*                    Columns: Prod_hier_sk | Parent_prod_hier_sk                            */
	/*                    Content: the products that are being purged explicitly                 */
	/*-------------------------------------------------------------------------------------------*/

	/* %macro szpf_geo_purge_reclass(
	          table_geo_remove=WORK.deleted_geographies,
	          table_geo_move=WORK.reclassed_geographies,
	          debug=0
	    );
	*/

	/* table_geo_move: reclassed_geographies - must be empty                                     */
	/* table_geo_remove: work.deleted_geographies                                                */
	/*                    Columns: Geo_hier_sk | Parent_geo_hier_sk                              */
	/*                    Content: the geographies that are being purged explicitly              */
	/* The following code creates work.deleted products from temp_lib.Prod_purge_list            */
	/* And work.deleted geographies from temp_lib.Geo_purge_list                                 */
	/*-------------------------------------------------------------------------------------------*/
	/* Same input tables are required by SZPK macros too. Only the macro names are changed as    */

	/* %macro szpk_prod_purge_reclass(
	      table_prod_remove=WORK.deleted_products,
	      table_prod_move=WORK.reclassed_products,
	      debug=0
	    );
	   %macro szpk_geo_purge_reclass(
	      table_geo_remove=WORK.deleted_geographies,
	      table_geo_move=WORK.reclassed_geographies,
	      debug=0
	   );
	*/

	/*===========================================================================================*/
	%put ______: Preparing the input tables for purging SO tables;

	/* Prod section */
	proc datasets lib=work nolist nowarn memtype = (data view);
		delete View_prod_hier Prod_purge_list deleted_products reclassed_products;
	quit;

	proc sql;
		create view work.View_prod_hier as 
			select PROD_HIER_SK, STD_HIER_PROD_LVL as PROD_LVL
				from DI_DM.PRODUCT_DM;
	quit;

	data work.Prod_purge_list( keep = PROD_HIER_SK PROD_LVL);
		set temp_lib.Prod_purge_list;
		attrib PROD_LVL length=6
			PROD_HIER_SK length= 6;

		if (_n_ = 1) then
			do;
				%di_util_hash_define( h_num = 0, 
					dsn   = %QUOTE(work.View_prod_hier), 
					d_key = %QUOTE("PROD_HIER_SK"), 
					d_data= %QUOTE("PROD_LVL") 
					);
			end;

		rc0 = h0.find();

		if (rc0 = 0) then
			output;
	run;

	/*Extract the immediate parent of products to be purged*/
	proc sql;
		create table work.deleted_products as
			select tmp.prod_hier_sk as PROD_HIER_SK,
				ph.parent_prod_hier_sk 
			from Prod_purge_list as tmp
				inner join di_dm.Product_hier_assoc_dm as ph 
					on tmp.prod_hier_sk=ph.prod_hier_sk
				where
					(ph.parent_prod_lvl=tmp.prod_lvl-1
					or
					tmp.prod_hier_sk = 1)
					and ph.PROD_HIER_ASSOC_CD=1;
		;
	quit;

	proc datasets lib=work nolist nowarn memtype = (data view);
		delete View_prod_hier Prod_purge_list;
	quit;

	data work.reclassed_products;
		attrib Prod_hier_sk length=8;
		attrib Prev_parent_prod_hier_sk length=8;
		attrib New_Parent_prod_hier_sk length=8;
		stop;
	run;

	/* Geo section */
	proc datasets lib=work nolist nowarn memtype = (data view);
		delete View_geo_hier Geo_purge_list deleted_geographies reclassed_geographies;
	quit;

	proc sql;
		create view work.View_geo_hier as 
			select GEO_HIER_SK, STD_HIER_GEO_LVL as GEO_LVL
				from DI_DM.GEOGRAPHY_DM;
	quit;

	data work.geo_purge_list( keep = GEO_HIER_SK GEO_LVL);
		set temp_lib.Geo_purge_list;
		attrib GEO_LVL length=6
			GEO_HIER_SK length= 6;

		if (_n_ = 1) then
			do;
				%di_util_hash_define( h_num = 0, 
					dsn   = %QUOTE(work.View_geo_hier), 
					d_key = %QUOTE("GEO_HIER_SK"), 
					d_data= %QUOTE("GEO_LVL") 
					);
			end;

		rc0 = h0.find();

		if (rc0 = 0) then
			output;
	run;

	/*Extract the immediate parent of locations to be purged*/
	proc sql;
		create table work.deleted_geographies as
			select tmp.geo_hier_sk as GEO_HIER_SK,
				gh.parent_geo_hier_sk 
			from work.Geo_purge_list as tmp
				inner join di_dm.Geography_hier_assoc_dm as gh 
					on tmp.geo_hier_sk=gh.geo_hier_sk
				where
					(gh.parent_geo_lvl=tmp.geo_lvl-1
					or
					tmp.geo_hier_sk = 1)
					and gh.GEO_HIER_ASSOC_CD=1;
		;
	quit;

	proc datasets lib=work nolist nowarn memtype = (data view);
		delete View_geo_hier Geo_purge_list;
	quit;

	data work.reclassed_geographies;
		attrib Geo_hier_sk length=8;
		attrib Prev_parent_geo_hier_sk length=8;
		attrib New_Parent_geo_hier_sk length=8;
		stop;
	run;

%mend;

%macro run_post_purge_macros;
	/* Trigger post purge processes only when %call_purge was run which is decided by value in
	  the variable err_ext
	*/
	%if &err_ext = 0 %then
		%do;
			%put ______: [run_post_purge_macros];

			/*===========================================================================================*/
			/* Update attribute based hierarchy.                                                         */
			/* It updates attr_prod_dm, attr_prod_hier_assoc_dm, attr_geo_dm, attr_geo_hier_assoc_dm;    */
			/*===========================================================================================*/
			%local count data_lib_path dmlib;
			%put ______: Fetching active application flags;

			%act_app_name;
			%put valid_lic_cpo = &valid_lic_cpo;
			%put valid_lic_rpo = &valid_lic_rpo;
			%put valid_lic_rpp = &valid_lic_rpp;
			%put valid_lic_szpf =&valid_lic_szpf;
			%put valid_lic_szpk =&valid_lic_szpk;
			%put application_cpo=&application_cpo;
			%put application_szpf=&application_szpf;
			%put application_szpk=&application_szpk;
			%put application_rpo=&application_rpo;
			%put application_rpp=&application_rpp;

			/*the logic for checking active application has been copied from ucmacros\en\auto\di_autoexec.sas*/
			
			/*Prepare the input datasets required for pourging SO tables                                 */
			%if ((&application_szpf = 1 and &valid_lic_szpf=1) or (&application_szpk = 1 and &valid_lic_szpk=1)) %then
				%do;
					%prepare_input_purge_so;
				%end;

			%if (&application_szpf = 1 and &valid_lic_szpf=1) %then
				%do;
					
					/*===========================================================================================*/
					/* Purge Prods and Geos from Size Profile related tables using macro provided by Eric Yang   */
					/*===========================================================================================*/
					/* exceute the macro for purging PRODS from Size Profile related tables if there's any deleted products */
					%if %di_util_nobs(WORK.deleted_products) gt 0 or
						%di_util_nobs(WORK.reclassed_products) gt 0 %then
						%do;
							%put ______: Executing szpf_prod_purge_reclass;
							%let syscc=0;

							%szpf_prod_purge_reclass(
								table_prod_remove=WORK.deleted_products,
								table_prod_move=WORK.reclassed_products,
								debug=0
								);
							%put ______: Value of syscc after szpf_prod_purge_reclass = &syscc;
							%let etls_table = %nrquote(SZPF Tables);
							%let etls_jobName = %nrquote(DI_ETL_Geo_prod_purge_job : szpf_prod_purge_reclass);
							%let etls_endTime = %sysfunc(datetime(),datetime.);
							%let job_rc=&syscc;

							%etls_sendjobstatus(source_table = didm_stg.Stg_geo_prod_purge_list);
						%end;

					/* exceute the macro for purging GEOS from Size Profile related tables if there's any deleted locations */
					%if %di_util_nobs(WORK.deleted_geographies) gt 0 or
						%di_util_nobs(WORK.reclassed_geographies) gt 0 %then
						%do;
							%put ______: Executing szpf_geo_purge_reclass;
							%let syscc=0;

							%szpf_geo_purge_reclass(
								table_geo_remove=WORK.deleted_geographies,
								table_geo_move=WORK.reclassed_geographies,
								debug=0
								);
							%put ______: Value of syscc after szpf_geo_purge_reclass = &syscc;
							%let etls_table = %nrquote(SZPF Tables);
							%let etls_jobName = %nrquote(DI_ETL_Geo_prod_purge_job : szpf_geo_purge_reclass);
							%let etls_endTime = %sysfunc(datetime(),datetime.);
							%let job_rc=&syscc;

							%etls_sendjobstatus(source_table = didm_stg.Stg_geo_prod_purge_list);
						%end;
				%end;

			/*===========================================================================================*/
			/* Refresh Pack related tables using macro provided by Eric Yang                             */
			/*===========================================================================================*/
			%if (&application_szpk = 1 and &valid_lic_szpk = 1) %then
				%do;
					/*===========================================================================================*/
					/* Purge Prods and Geos from Size Packe related tables using macro provided by Eric Yang     */
					/*===========================================================================================*/
					%if %di_util_nobs(WORK.deleted_products) gt 0 or
						%di_util_nobs(WORK.reclassed_products) gt 0 %then
						%do;
							/* exceute the macro for purging PRODS from Size Pack related tables if there's any deleted products */
							%put ______: Executing szpk_prod_purge_reclass;
							%let syscc=0;

							%szpk_prod_purge_reclass(
								table_prod_remove=WORK.deleted_products,
								table_prod_move=WORK.reclassed_products,
								debug=0
								);
							%put ______: Value of syscc after szpk_prod_purge_reclass = &syscc;
							%let etls_table = %nrquote(SZPK Tables);
							%let etls_jobName = %nrquote(DI_ETL_Geo_prod_purge_job : szpk_prod_purge_reclass);
							%let etls_endTime = %sysfunc(datetime(),datetime.);
							%let job_rc=&syscc;

							%etls_sendjobstatus(source_table = didm_stg.Stg_geo_prod_purge_list);
						%end;

					/* exceute the macro for purging GEOS from Size Pack related tables if there's any deleted locations */
					%if %di_util_nobs(WORK.deleted_geographies) gt 0 or
						%di_util_nobs(WORK.reclassed_geographies) gt 0 %then
						%do;
							%put ______: Executing szpk_geo_purge_reclass;
							%let syscc=0;

							%szpk_geo_purge_reclass(
								table_geo_remove=WORK.deleted_geographies,
								table_geo_move=WORK.reclassed_geographies,
								debug=0
								);
							%put ______: Value of syscc after szpk_geo_purge_reclass = &syscc;
							%let etls_table = %nrquote(SZPK Tables);
							%let etls_jobName = %nrquote(DI_ETL_Geo_prod_purge_job : szpk_geo_purge_reclass);
							%let etls_endTime = %sysfunc(datetime(),datetime.);
							%let job_rc=&syscc;

							%etls_sendjobstatus(source_table = didm_stg.Stg_geo_prod_purge_list);
						%end;
				%end;

			/* delete the unwanted work tbles                                                          */
			%if ((&application_szpf = 1 and &valid_lic_szpf = 1) or (&application_szpk = 1 and &valid_lic_szpk = 1)) %then
				%do;

					proc datasets lib=work nolist nowarn memtype = (data view);
						delete deleted_geographies reclassed_geographies deleted_products reclassed_products;
					quit;

				%end;

			/*============================================================================================ */
			/* Purge PRODUCT_DM, GEOGRAPHY_DM, PRODUCT_HIER_ASSOC_DM and GEOGRAPHY_HIER_ASSOC_DM           */
			/* from di_dm and di_trans;                                                                    */
			/* Many of the macros executed below after purge_dm_hier are dependent on Product and Location */
			/* data along with hierarchy, hence purging prod-Geo dm and hierarchies first                  */
			/*============================================================================================ */
			%put ______: Executing purge_dm_hier...;
			%let syscc=0;

			%purge_dm_hier;
			%put ______: Value of syscc after purge_dm_hier() = &syscc;
			%let etls_jobName = %nrquote(DI_ETL_Geo_prod_purge_job : purge_dm_hier);
			%let etls_endTime = %sysfunc(datetime(),datetime.);
			%let job_rc=&syscc;

			%etls_sendjobstatus(source_table = didm_stg.Stg_geo_prod_purge_list);

			/*Refresh MDO related tables*/
			%if (&application_cpo eq 1 and &valid_lic_cpo = 1) %then
				%do;
					/*===========================================================================================*/
					/* Updates the number of products, geographies and members in di_trans.MDO_PLAN_GROUP;       */
					/*===========================================================================================*/
					%put ______: Executing update_num_geo_prd_mem...;
					%let syscc=0;

					%update_num_geo_prd_mem;
					%put ______: Value of syscc after update_num_geo_prd_mem() = &syscc;
					%let etls_jobName = %nrquote(DI_ETL_Geo_prod_purge_job : update_num_geo_prd_mem);
					%let etls_endTime = %sysfunc(datetime(),datetime.);
					%let job_rc=&syscc;

					%etls_sendjobstatus(source_table = didm_stg.Stg_geo_prod_purge_list);

					/*===========================================================================================*/
					/* Find common ancestor parent Keys and update MDO_PLAN_GROUP;                               */
					/*===========================================================================================*/
					%put ______: Executing refresh_mdo_plan_group...;
					%let syscc=0;

					%refresh_mdo_plan_group;
					%put ______: Value of syscc after refresh_mdo_plan_group() = &syscc;
					%let etls_jobName = %nrquote(DI_ETL_Geo_prod_purge_job : refresh_mdo_plan_group);
					%let etls_endTime = %sysfunc(datetime(),datetime.);
					%let job_rc=&syscc;

					%etls_sendjobstatus(source_table = didm_stg.Stg_geo_prod_purge_list);
				%end;

			/*===========================================================================================*/
			/* After purging di_trans.product_group_mbr, di_trans.product_group needs to be updated      */
			/* for NUM_PRODS and MIN_PROD_LVL                                                            */
			/*===========================================================================================*/
			%put ______: Executing refresh_product_group...;
			%let syscc=0;

			%refresh_product_group;
			%put ______: Value of syscc after refresh_product_group() = &syscc;
			%let etls_jobName = %nrquote(DI_ETL_Geo_prod_purge_job : refresh_product_group);
			%let etls_endTime = %sysfunc(datetime(),datetime.);
			%let job_rc=&syscc;

			%etls_sendjobstatus(source_table = didm_stg.Stg_geo_prod_purge_list);

			/*===========================================================================================*/
			/* After purging di_trans.Geography_group_mbr, di_trans.geography_group needs to be updated  */
			/* for NUM_GEOS and MIN_GEO_LVL                                                            */
			/*===========================================================================================*/
			%put ______: Executing refresh_geography_group...;
			%let syscc=0;

			%refresh_geography_group;
			%put ______: Value of syscc after refresh_geography_group() = &syscc;
			%let etls_jobName = %nrquote(DI_ETL_Geo_prod_purge_job : refresh_geography_group);
			%let etls_endTime = %sysfunc(datetime(),datetime.);
			%let job_rc=&syscc;

			%etls_sendjobstatus(source_table = didm_stg.Stg_geo_prod_purge_list);
            
			%if ((&application_cpo = 1 and &valid_lic_cpo=1) or (&application_rpo = 1 and &valid_lic_rpo=1) or (&application_rpp=1 and &valid_lic_rpp=1)) %then
				%do;
					/*===========================================================================================*/
					/* PRODUCT_DM and PRODUCT_HIER_ASSOC_DM were not purged from the partitions.                 */
					/* The data belonging to each partition from di_dm.PRODUCT_DM and di_dm.PRODUCT_HIER_ASSOC_DM*/
					/* will be copied to respective partitions using %di_etl_partition_data                      */
					/*===========================================================================================*/
					%put ______: Executing copy_dm_to_partitions...;
					%let syscc=0;

					%copy_dm_to_partitions;
					%put ______: Value of syscc after copy_dm_to_partitions() = &syscc;
					%let etls_jobName = %nrquote(DI_ETL_Geo_prod_purge_job : copy_dm_to_partitions);
					%let etls_endTime = %sysfunc(datetime(),datetime.);
					%let job_rc=&syscc;

					%etls_sendjobstatus(source_table = didm_stg.Stg_geo_prod_purge_list);
				%end;

			 /* Defect S1328465 - Refresh Attribute based tables */
			%if ((&application_cpo = 1 and &valid_lic_cpo=1) or (&application_rpo = 1 and &valid_lic_rpo=1) or (&application_rpp=1 and &valid_lic_rpp=1)) %then
				%do;
					%if %di_util_nobs(di_data.attr_prod_lvl) gt 0 or
						%di_util_nobs(di_data.attr_geo_lvl) gt 0 %then
						%do;
							%put ______: Executing di_hier_attr_job....;
							%let syscc=0;

							%di_hier_attr_job(
								di_data=di_data,
								refresh_mode=1);
						%end;

					%put ______: Value of syscc after di_hier_attr_job() = &syscc;
					%let etls_jobName = %nrquote(DI_ETL_Geo_prod_purge_job : di_hier_attr_job);
					%let etls_endTime = %sysfunc(datetime(),datetime.);
					%let job_rc=&syscc;

					%etls_sendjobstatus(source_table = didm_stg.Stg_geo_prod_purge_list);
				%end;

				/*===========================================================================================*/
			    /* Refresh PRF_PROD_AGG and PRF_SALES_DATA_SUMMARY                                           */
			    /*===========================================================================================*/

				%if (&application_szpf = 1 and &valid_lic_szpf=1) %then
				%do;
					%let syscc=0;
					%put ______: Updating the PRF summary and Aggregation tables...;

					%run_prf_sales_agg_summary;
					%put ______: Value of syscc after run_prf_sales_agg_summary() = &syscc;
					%let etls_table =;
				%end;

		%end;

	libname di_dm_p clear;
%mend run_post_purge_macros;

%macro call_purge_job;
	/*======================================================================================*/
	/* This is the main macro where the baisc initial checks are performed.                 */
	/* Geo/Prod filter tables are created.                                                  */
	/* List of tables to be ignored from being purged is SAS and RDBMS are created          */
	/* Metadata information like no of observations, indexes and constraints are extracted  */
	/* from the dictionary tables.                                                          */
	/*======================================================================================*/
	%put ______: Value of syscc=&syscc;
	%global temp_lib_path;
	%local obs_count max_dt work_path;
	%global num_parallel_executions err_ext;
	%let err_ext=0;

	/*======================================================================================*/
	/* Check in DI_DM.Geo_prod_purge_list, if it contains any Geo/Prods to be purged.       */
	/* This table has valid Geos/Prods from stg_geo_prod_purge_list                         */
	/*======================================================================================*/
	proc sql noprint;
		select max(datepart(CREATED_DTTM)) into: max_dt from DI_DM.Geo_prod_purge_list;
	quit;

	%let max_dt=&max_dt;
	%put ______: max_dt=&max_dt;

	proc sql noprint;
		select count(*) 
			into :obs_count
				from DI_DM.Geo_prod_purge_list
					where datepart(CREATED_DTTM)=&max_dt and
						upcase(PURGED_FLG) = 'N';
	quit;

	%let obs_count=&obs_count;
	%put ______: No. of obs in DI_DM.Geo_prod_purge_list =&obs_count;

	%if &obs_count = 0 %then
		%do;
			%put ______: WARNING: No Product or Geography to purge, hence existing...;
			%let job_rc=0;
			%put ______: Value of job_rc=&job_rc;
			%put ______: Value of syscc=&syscc;
			%let err_ext=1;

			%etls_sendjobstatus(source_table = didm_stg.Stg_geo_prod_purge_list);
			%goto ERROREXIT;
		%end;

	/*Fetch the vlaue of global parameter NUM_PARALLEL_EXECUTIONS*/
	%di_util_global_setting_spec(spec_nm=NUM_PARALLEL_EXECUTIONS,
		app=ALL,
		_spec_value=num_parallel_executions,
		optional=1);

	%if &num_parallel_executions =%str() %then
		%do;
			%let num_parallel_executions = 20;
		%end;

	%put ______: num_parallel_executions= &num_parallel_executions;

	/*==============================================================================*/
	/* Fetch the path of work library                                               */
	/*==============================================================================*/
	proc sql noprint;
		select cats(path,'/..') into :work_path
			from sashelp.vlibnam
				where libname = upcase("WORK")
					and level in (0 1);
	quit;

	%let work_path = &work_path;
	%put ______: work_path = &work_path;

	/*===============================================================================*/
	/* Creating temp_lib in work folder. This location is used to store the temporary*/
	/* tables like argument tables, ignore tables, filter tables etc. which are used */
	/* by purge job in multiple parallel SAS sessions                                */
	/*===============================================================================*/
	%let sub_dir_name = temp_dir;
	%let temp_lib_path = %di_util_create_folder(relative_dir=&sub_dir_name ,parent_dir=&work_path);
	libname temp_lib "&temp_lib_path";

	proc datasets library=temp_lib kill noprint;
	run;

	quit;

	/* Assignment of a library di_dm_p as di_data was required for previous version of   */
	/* code, to reduce the changes to support new requirement, kept this assignment as is*/
	/* di_dm isn't used as it is a concatenated lib whereas di_data isn't                */
	libname di_dm_p (di_data);

	/* Create the geo/prod filter tables in temp_lib with list of geos/prods to be purged */
	/* from the datamart                                                                  */
	proc datasets lib = temp_lib nolist nowarn memtype = (data view);
		delete geo_purge_list prod_purge_list;
	quit;

	data temp_lib.prod_purge_list(rename=(OBJECT_KEY=PROD_HIER_SK 
		OBJECT_ID=PROD_ID)
		drop = OBJECT_TYPE);
		set DI_DM.Geo_prod_purge_list (drop=PURGED_DTTM CREATED_DTTM);
		where upcase(object_type) = 'P'
			and upcase(PURGED_FLG) = 'N';
	run;

	data temp_lib.geo_purge_list(rename=(OBJECT_KEY=GEO_HIER_SK 
		OBJECT_ID=GEO_ID)
		drop = OBJECT_TYPE);
		set DI_DM.Geo_prod_purge_list (drop=PURGED_DTTM CREATED_DTTM);
		where upcase(object_type) = 'G'
			and upcase(PURGED_FLG) = 'N';
	run;


	%rcSet(&syserr);
	%rcSet(&sqlrc);

	
	/* Extract parent nodes from product hierarchy. These are required for marking data out-of-date in rpp_plan_result */
	
	proc sql noprint;
		create table temp_lib.UW_PROD_PARENTS_TMP as 
			select distinct P.PARENT_PROD_HIER_SK as PROD_HIER_SK, PDM.PROD_ID AS PROD_ID
				from TEMP_LIB.PROD_PURGE_LIST D,
					DI_DM.PRODUCT_HIER_ASSOC_DM P,
					DI_DM.PRODUCT_DM PDM
				where D.PROD_HIER_SK = P.PROD_HIER_SK
					and D.PROD_HIER_SK ne  P.PARENT_PROD_HIER_SK
					and P.PROD_HIER_ASSOC_CD = 1
					and PDM.PROD_HIER_SK=P.PARENT_PROD_HIER_SK
				order by PROD_HIER_SK;
	quit;

	proc sort data=temp_lib.UW_PROD_PARENTS_TMP out=temp_lib.uw_prod_parents  nodupkey;
		by prod_hier_sk;
	run;

	/* Extract parent nodes from geography hierarchy. These are required for marking data out-of-date in rpp_plan_result */

	proc sql noprint;
		create table temp_lib.UW_GEO_PARENTS_TMP as 
			select distinct P.PARENT_GEO_HIER_SK as GEO_HIER_SK, PDM.GEO_ID AS GEO_ID
				from TEMP_LIB.GEO_PURGE_LIST D,
					DI_DM.GEOGRAPHY_HIER_ASSOC_DM P,
					DI_DM.GEOGRAPHY_DM PDM
				where D.GEO_HIER_SK = P.GEO_HIER_SK
					and D.GEO_HIER_SK ne  P.PARENT_GEO_HIER_SK
					and P.GEO_HIER_ASSOC_CD = 1
					and PDM.GEO_HIER_SK=P.PARENT_GEO_HIER_SK
				order by GEO_HIER_SK;
	quit;

	proc sort data=temp_lib.UW_GEO_PARENTS_TMP out=temp_lib.UW_GEO_PARENTS  nodupkey;
		by geo_hier_sk;
	run;
    /* Create empty tables to eliminate errors*/
	data temp_lib.prod_to_plan;
	   attrib prod_id length=$32.;
       attrib prod_hier_sk length=8;
	stop;
	data temp_lib.geo_to_plan;
	   attrib geo_id length=$32.;
       attrib geo_hier_sk length=8;
	stop;

	/*Create a table with distinct prods from prods to be purged and from their Parent prods tables    */
	/*These products if happens to be the scope of plan, then plan is affected in some way due to purge*/
	/*Note that plans are affected not only due to the purging of products appearing in the scope but  */
	/*also if the child node of the product in scope is being purged                                   */
	/*rpp_plan_prod_asgmn has prods at higher level and if the child nodes of these products are purge */
	/*then the plans are affected due to purge and needs to be notified                                */
    %if %sysfunc(exist(temp_lib.UW_PROD_PARENTS)) and %sysfunc(exist(temp_lib.prod_purge_list)) %then %do;
    proc sql noprint;
		create table temp_lib.prod_to_plan as
			select d.prod_id,d.PROD_HIER_SK  from temp_lib.UW_PROD_PARENTS d
				union 
			select p.prod_id,p.PROD_HIER_SK from temp_lib.prod_purge_list p;
	quit;
	%end;
	%else %if %sysfunc(exist(temp_lib.prod_purge_list)) %then %do;
        proc sql noprint;
		   create table temp_lib.prod_to_plan as
		      select p.prod_id,p.PROD_HIER_SK from temp_lib.prod_purge_list p;
        quit;
 	%end;
    %else %if %sysfunc(exist(temp_lib.UW_PROD_PARENTS)) %then %do;
        proc sql noprint;
		create table temp_lib.prod_to_plan as
			select d.prod_id,d.PROD_HIER_SK  from temp_lib.UW_PROD_PARENTS d;
	    quit;
 	%end;


	%rcSet(&syserr);
	%rcSet(&sqlrc);

	/* Check if any of the prod parent nodes extracted above are in rpp_plan_prod_asgmnt   */
	/* Check if any of the Geo parent nodes extracted above are in scope_detail                        */
	/* if Yes to any of the above two que, then extract the plans as affected plans                    */
	/* mark these plans as affected due to child purge, in notes column instead of listing all the child */
	/* nodes, just say ' Child nodes are purged'                                                    	     */
	proc sql noprint;
		create table temp_lib.plans_affected_p as select 
               a.plan_sk,
               a.plan_nm,
               a.plan_desc,
			   a.status_cd,
	           a.scope_sk as prev_scope_sk,
			   a.notes,
			   b.prod_hier_sk,
               b.prod_id 
			from di_trans.rpp_plan_prod_asgmnt c,temp_lib.prod_to_plan b, di_trans.rpp_plan a
				where 
                  c.prod_hier_sk=b.prod_hier_sk
                  and c.plan_sk=a.plan_sk
               order by a.plan_sk, b.prod_hier_sk;
	quit;

    /*Remove duplicates from temp_lib.plans_affected_g*/
    proc sort data=temp_lib.plans_affected_p nodupkey;
	   by plan_sk prod_hier_sk;
    run; 

    %if %sysfunc(exist(temp_lib.UW_GEO_PARENTS)) and %sysfunc(exist(temp_lib.geo_purge_list)) %then %do;
       proc sql noprint;
		   create table temp_lib.geo_to_plan as
			   select d.geo_id,d.GEO_HIER_SK  from temp_lib.UW_GEO_PARENTS d
				   union 
			   select p.geo_id,p.GEO_HIER_SK from temp_lib.geo_purge_list p;
       quit;
	%end;
	%else %if %sysfunc(exist(temp_lib.geo_purge_list)) %then %do;
        proc sql noprint;
		create table temp_lib.geo_to_plan as
			select p.geo_id,p.GEO_HIER_SK from temp_lib.geo_purge_list p;
        quit;
 	%end;
    %else %if %sysfunc(exist(temp_lib.UW_GEO_PARENTS)) %then %do;
       proc sql noprint;
	      create table temp_lib.geo_to_plan as
			select d.geo_id,d.GEO_HIER_SK  from temp_lib.UW_GEO_PARENTS d;
       quit;
 	%end;

   %rcSet(&syserr);
   %rcSet(&sqlrc);

	/* Check if any of the geo parent nodes extracted above[geo_to_plan] are in scope_detail             */
	/* if Yes, then extract matching plans as affected plans                                             */
	/* mark these plans as affected due to child purge, in notes column instead of listing all the child */
	/* nodes, just say ' Child nodes are purged'                                                    	 */

	proc sql noprint;
		create table temp_lib.plans_affected_g as select 
               a.plan_sk,
               a.plan_nm,
               a.plan_desc,
			   a.status_cd,
	           a.scope_sk as prev_scope_sk,
			   a.notes,
			   b.geo_hier_sk,
               b.geo_id 
			from di_trans.scope_detail c,temp_lib.geo_to_plan b, di_trans.rpp_plan a
				where 
                  c.geo_hier_sk=b.geo_hier_sk
                  and c.scope_sk=a.scope_sk
               order by a.plan_sk, b.geo_hier_sk;
	quit;

    /*Remove duplicates from temp_lib.plans_affected_g*/
    proc sort data=temp_lib.plans_affected_g nodupkey;
	   by plan_sk geo_hier_sk;
    run;

	/*====================================================================================*/
	/*Extract part_sks from prf_*_meta tables and define libraries for each               */
	/*PRF_* tables will be purged based on part_sk's from their corresponding meta tables */
	/*====================================================================================*/
	proc sql noprint;
		create table temp_lib.prf_meta_part_sk_unq as 
			select distinct part_sk 
				from di_dm_p.prf_sales_fact_meta
					union 
				select distinct part_sk 
					from di_dm_p.Prf_geo_prod_status_meta
						union 
					select distinct part_sk 
						from di_dm_p.Prf_stockout_fact_meta
							union 
						select distinct part_sk 
							from di_dm_p.Prf_inventory_fact_meta;
		;
	quit;

	/*=====================================================================================*/
	/* %di_util_create_assign_libraries:                                                   */
	/* Define the libraries for sub-folders in di_data                                     */
	/* Define the libraries for sub-folders in di_data\1                                   */
	/* Extract meta info like indexes and constraints for tables belonging to above folders*/
	/* Create_lib=1 indicates library assignment is done as well as meta data information  */
	/* of each table is fetched and saved in temp_lib.sas_index_name                       */
	/* Create_lib=0 indicates only library assignments will be done                        */
	/* The job parameter etlp_incl_partition - name of sub-folder(s) from di_data to be    */
	/* considered for purging. Multiple folders can be specified using comma separation    */
	/* part_lib macro variable will have all the libnames along with DI_TRANS              */
	/*=====================================================================================*/
	%put ______: etlp_incl_partition in purge main job =&etlp_incl_partition;

	%di_util_create_assign_libraries(create_lib=0);
	%put ______: Final List of libraries=&part_lib;

	/*=====================================================================================*/
	/*   Create a temp work table form dictionary.tables. This temp table is used further  */
	/*   down to extract table meta information                                            */
	/*=====================================================================================*/
	proc sql noprint;
		create table work.dict_tables as
			select memname, libname, nobs, memtype from
				sashelp.vtable 
			where libname in %unquote((%upcase(&part_lib)))
				and memtype='DATA'
		;
	quit;

	/*=====================================================================================*/
	/* Note: PRF_ fact tables are purged form partitions denoted by part_sk in META tables */
	/* and not based on part_sks from product_hier_assoc_dm@prod_partition_lvl             */
	/* Deleting PRF_* tables from all libraries except for libraries that are defined based*/
	/* on part_sk's in corresponding META tables.                                          */
	/*=====================================================================================*/
	proc sql noprint;
		delete from work.dict_tables
			where memname in ('PRF_SALES_FACT','PRF_GEO_PROD_STATUS','PRF_STOCKOUT_FACT','PRF_INVENTORY_FACT')
				and libname not like "P^_%" escape "^" 
		;
	quit;

	/*=====================================================================================*/
	/* Deleting tables other that PRF_* from libraries especially defined for PRF_* facts  */
	/*=====================================================================================*/
	proc sql noprint;
		delete from work.dict_tables
			where memname not in ('PRF_SALES_FACT','PRF_GEO_PROD_STATUS','PRF_STOCKOUT_FACT','PRF_INVENTORY_FACT')
				and libname like "P^_%" escape "^" 
		;
	quit;

	/*=====================================================================================*/
	/* Deleting PRODUCT_DM and GEOGRAPHY_DM and their corresponding hierarchy tables as    */
	/* they are purged at the end after successful purging of all tables                   */
	/*=====================================================================================*/
	proc sql noprint;
		delete from work.dict_tables
			where memname in ('PRODUCT_DM','GEOGRAPHY_DM','PRODUCT_HIER_ASSOC_DM','GEOGRAPHY_HIER_ASSOC_DM','TABLE_PARTITION_META')
		;
	quit;

	/*=====================================================================================*/
	/*   Create a temp work table form dictionary.columns. This temp table is used further */
	/*   down to extract table meta information                                            */
	/*=====================================================================================*/
	proc sql noprint;
		create table work.dict_columns as
			select libname, memname, name from
				sashelp.vcolumn
			where libname in %unquote((%upcase(&part_lib)))
				and memtype='DATA'
		;
	quit;

	/*=====================================================================================*/
	/* Fetch the value of job parameter etlp_ignore_tbl_keyword with list of keywords.     */
	/* The tables containing these keywords will be ignored from being purged.             */
	/* If no value is provided to this parameter, then by default the keywords, REPORT     */
	/* and RESULT are considered.                                                          */
	/*=====================================================================================*/

	%if not %symexist(etlp_ignore_tbl_keyword) %then
		%do;
			%GLOBAL etlp_ignore_tbl_keyword;
			%let etlp_ignore_tbl_keyword=%str(REPORT RESULT SZPF SZPK);
		%end;
	%else %if &etlp_ignore_tbl_keyword eq %str() %then
		%do;
			%let etlp_ignore_tbl_keyword=%str(REPORT RESULT SZPF SZPK);
		%end;
	%else
		%do;
			%let etlp_ignore_tbl_keyword=%str(&etlp_ignore_tbl_keyword)%str( REPORT RESULT SZPF SZPK);
		%end;

	%global where_cond;
	%let where_cond=;
	%let etlp_ignore_tbl_keyword=&etlp_ignore_tbl_keyword;
	%put ______: etlp_ignore_tbl_keyword=&etlp_ignore_tbl_keyword;

	%do i = 1 %to %eval(%sysfunc(countc(%bquote(&etlp_ignore_tbl_keyword),%STR( )))+1);
		%let ignore&i=%qscan(%bquote(&etlp_ignore_tbl_keyword),&i,%str( ));

		%if %sysevalf(&i ne 1) %then
			%do;
				%let where_cond=%str( )%str(&where_cond)%str( OR );
			%end;

		%let where_cond=%str( )%str(&where_cond)%str(memname contains )%str(%')&&ignore&i%str(%');
	%end;

	%let where_cond=(&where_cond);
	%put ______: tables to be ignored: &where_cond;

	proc datasets lib = temp_lib nolist nowarn memtype = (data view);
		delete ignore_table_sas ignore_table_dbms sas_tables_with_obs;
	quit;

	data work.partition_tables (keep=table_nm rename=(table_nm=memname));
		set di_trans.table_partition_meta;
		where ETL_STG2DM=1;
	run;

	* Create table to hold the list of SAS tables that needs to be igored from being purged;
	proc sql noprint;
		create table temp_lib.ignore_table_sas as 
			select distinct memname, "DI_DM_P" as libname 
				from work.dict_tables 
					where libname=upcase("DI_DM_P") 
						and (%unquote(&where_cond) or memtype = 'VIEW') or 
						memname in ('PRODUCT_DM','GEOGRAPHY_DM','PRODUCT_HIER_ASSOC_DM','GEOGRAPHY_HIER_ASSOC_DM', 
						'ATTR_PROD_DM','ATTR_PROD_HIER_ASSOC_DM','ATTR_GEO_DM', 'ATTR_GEO_HIER_ASSOC_DM','GEO_PROD_PURGE_LIST','PURGE_RESULT_TABLE',
						'PRF_GEO_PROD_STATUS_META','PRF_SALES_FACT_META','PRF_STOCKOUT_FACT_META','PRF_INVENTORY_FACT_META') or
						memname in (select memname from  work.partition_tables);
	quit;

	proc sql noprint;
		create table work.ignore_table_sas2 as 
			select distinct memname, libname 
				from work.dict_tables 
					where
						(%unquote(&where_cond) or memtype = 'VIEW')
						and (libname not in ("DI_TRANS","DI_DM_P"));
	quit;

	proc append data=work.ignore_table_sas2
		base=temp_lib.ignore_table_sas force;
	run;

	/*=======================================================================================*/
	/* Fetch the value of job parameter etlp_ignore_view_purging with list of views to ignore*/
	/* If no view is provided via etlp_ignore_view_purging, then by default the views        */
	/* PKO_PRODUCT_DM_ALL and PKO_PRODUCT_HIER_ASSOC_DM_ALL will be ignored from being purged*/
	/*=======================================================================================*/
	%if not %symexist(etlp_ignore_view_purging) %then
		%do;
			%GLOBAL etlp_ignore_view_purging;
			%let etlp_ignore_view_purging=%bquote(PKO_PRODUCT_DM_ALL PKO_PRODUCT_HIER_ASSOC_DM_ALL);
		%end;
	%else %if &etlp_ignore_view_purging eq %str() %then
		%do;
			%let etlp_ignore_view_purging=%bquote(PKO_PRODUCT_DM_ALL PKO_PRODUCT_HIER_ASSOC_DM_ALL);
		%end;
	%else
		%do;
			%let etlp_ignore_view_purging=%str(&etlp_ignore_view_purging)%str( PKO_PRODUCT_DM_ALL PKO_PRODUCT_HIER_ASSOC_DM_ALL);
		%end;

	%let etlp_ignore_view_purging=%upcase(%bquote(&etlp_ignore_view_purging));
	%put ______: Views to ignore from purging: &etlp_ignore_view_purging;
	%local view_cnt view_cond;
	%let view_cond=;

	%do view_cnt = 1 %to %eval(%sysfunc(countc(%bquote(&etlp_ignore_view_purging),%STR( )))+1);
		%let ignore&view_cnt=%qscan(%bquote(&etlp_ignore_view_purging),&view_cnt,%str( ));

		%if %sysevalf(&view_cnt ne 1) %then
			%do;
				%let view_cond=%str(&view_cond)%str(,)%str(%')&&ignore&view_cnt%str(%');
			%end;
		%else
			%do;
				%let view_cond=%str(memname in )%str(%()%str(%')&&ignore&view_cnt%str(%');
			%end;
	%end;

	%let view_cond=%str(&view_cond)%str(%));
	%put ______: Views to be ignored: &view_cond;

	* Create temp table with SAS tables and number of observation in each;
	proc sql noprint;
		create table temp_lib.sas_tables_with_obs as
			select libname, memname, nobs
				from work.dict_tables a
					where libname ne "DI_TRANS"
						and memname not in (select c.memname from temp_lib.ignore_table_sas c where
						a.libname=c.libname);
	quit;

	* delete temp tables;
	proc datasets lib=temp_lib nolist nowarn memtype = (data view);
		delete sas_tables_to_purge dbms_tables;
	quit;

	/*================================================================================*/
	/* Preparation of input tables for purging SAS tables                             */
	/* Extract tables which contains PROD_HIER_SK or GEO_HIER_SK column from DI_DM_P. */
	/* At this stage even partitioned tables are included in this list                */
	/*================================================================================*/
	proc sql noprint;
		create table temp_lib.sas_tables_to_purge_temp as 
			select distinct libname, memname, nobs , max(prod_hier_sk_true) as prod_hier_sk_true,
				max(geo_hier_sk_true) as geo_hier_sk_true from 
				(
			select distinct a.libname, a.memname, b.nobs , 
				case 
					when a.name = 'PROD_HIER_SK' then 1 
					else 0 
				end 
			as prod_hier_sk_true, 
				case 
					when a.name = 'GEO_HIER_SK' then 1 
					else 0 
				end 
			as geo_hier_sk_true 
				from work.dict_columns a, temp_lib.sas_tables_with_obs b 
					where a.libname ne "DI_TRANS" 
						and (a.name = 'PROD_HIER_SK' or a.name = 'GEO_HIER_SK') 
						and a.memname=b.memname 
						and a.libname=b.libname
					)
				group by memname, nobs 
		;
	quit;

	proc datasets lib = temp_lib nolist nowarn memtype = (data view);
		delete sas_index_name;
	quit;

	proc datasets lib = work nolist nowarn memtype = (data view);
		delete sas_index;
	quit;

	proc datasets LIBRARY=DI_DM_P nolist noprint;
		contents data = _all_ OUT2=work.sas_index;
	quit;

	proc sql noprint;
		alter table work.sas_index
			add purge_table_name varchar(50);
		update work.sas_index
			set purge_table_name='DI_DATA\'||MEMBER;
	quit;

	proc append data=work.sas_index 
		base=temp_lib.sas_index_name force;
	run;

	%local nobs_geo_purge_list nobs_prod_purge_list;
	%let nobs_geo_purge_list=%di_util_nobs(temp_lib.geo_purge_list);
	%put _____: nobs_geo_purge_list=&nobs_geo_purge_list;
	%let nobs_prod_purge_list=%di_util_nobs(temp_lib.prod_purge_list);
	%put _____: nobs_prod_purge_list=&nobs_prod_purge_list;

	%if (&nobs_prod_purge_list gt 0) and (&nobs_geo_purge_list gt 0) %then
		%do;

			proc sql noprint;
				create table temp_lib.sas_tables_to_purge as
					select distinct a.libname, a.memname, a.nobs , a.prod_hier_sk_true,
						a.geo_hier_sk_true, 
					case 
						when missing(b.purge_table_name) then 
						cats(a.libname,'\',a.memname) 
						else upcase(b.purge_table_name) 
					end 
				as purge_table_name 
					from temp_lib.sas_tables_to_purge_temp a
						left join temp_lib.Sas_index_name b
							on a.libname=b.libname and a.memname=b.member;
			quit;

		%end;
	%else
		%do;
			%if &nobs_geo_purge_list gt 0 %then
				%do;

					proc sql noprint;
						create table temp_lib.sas_tables_to_purge as
							select distinct a.libname, a.memname, a.nobs , a.prod_hier_sk_true,
								a.geo_hier_sk_true, 
							case 
								when missing(b.purge_table_name) then 
								cats(a.libname,'\',a.memname) 
								else upcase(b.purge_table_name) 
							end 
						as purge_table_name 
							from temp_lib.sas_tables_to_purge_temp a
								left join temp_lib.Sas_index_name b
									on a.libname=b.libname and a.memname=b.member
								where a.geo_hier_sk_true=1;
					quit;

				%end;
			%else %if &nobs_prod_purge_list gt 0 %then
				%do;

					proc sql noprint;
						create table temp_lib.sas_tables_to_purge as
							select distinct a.libname, a.memname, a.nobs , a.prod_hier_sk_true,
								a.geo_hier_sk_true, 
							case 
								when missing(b.purge_table_name) then 
								cats(a.libname,'\',a.memname) 
								else upcase(b.purge_table_name) 
							end 
						as purge_table_name 
							from temp_lib.sas_tables_to_purge_temp a
								left join temp_lib.Sas_index_name b
									on a.libname=b.libname and a.memname=b.member
								where a.prod_hier_sk_true=1;
					quit;

				%end;
		%end;

	/*===========================================================*/
	/*Preparation of input tables for purging RDBMS tables       */
	/*===========================================================*/
	* Create temp table with the list of RDBMS tables;
	data work.dbms_tables;
		set work.dict_tables (where = (libname='DI_TRANS'));
	run;

	* Create table to hold the list of RDBMS tables that needs to be igored from being purged;
	proc sql noprint;
		create table temp_lib.ignore_table_dbms as
			select distinct memname 
				from work.dict_tables
					where libname='DI_TRANS'
						and (%unquote(&where_cond) or %unquote(&view_cond)) or 
						memname in ('PRODUCT_DM','GEOGRAPHY_DM','PRODUCT_HIER_ASSOC_DM','GEOGRAPHY_HIER_ASSOC_DM');
	quit;

	/*
	proc sql noprint;
	delete from temp_lib.ignore_table_dbms
	where (%unquote(&where_cond) or %unquote(&view_cond)) or 
	memname in ('PRODUCT_DM','GEOGRAPHY_DM','PRODUCT_HIER_ASSOC_DM','GEOGRAPHY_HIER_ASSOC_DM');
	quit;
	*/

	* Extract tables which contains PROD_HIER_SK column from DI_TRANS;
	proc sql noprint;
		create table temp_lib.dbms_tables as
			select memname, max(prod_hier_sk_true) as prod_hier_sk_true,
				max(geo_hier_sk_true) as geo_hier_sk_true from 
				(
			select distinct a.memname,
				case 
					when a.name = 'PROD_HIER_SK' then 1 
					else 0 
				end 
			as prod_hier_sk_true, 
				case 
					when a.name = 'GEO_HIER_SK' then 1 
					else 0 
				end 
			as geo_hier_sk_true 
				from work.dict_columns a, dbms_tables b
					where a.libname= "DI_TRANS"
						and (a.name = 'PROD_HIER_SK' or a.name = 'GEO_HIER_SK')
						and a.memname=b.memname
						and a.memname not in (select c.memname from temp_lib.Ignore_table_dbms c))
					group by memname
		;
	quit;

	/*Create a temp table user_tables that will have list of rdbms tables along with number of rows in each table */
	%if (%upcase(&DI_TRANS_VENDOR) eq SAS) %then
		%do;

			proc sql noprint;
				create table work.user_tables as
					select memname as table_name, nobs as num_rows from
						sashelp.vtable 
					where libname='DI_TRANS';
			quit;

		%end;
	%else
		%do;
			%let m_sql=%str(select table_name, num_rows FROM user_tables order by table_name);

			%di_dm_trans_exe(
				pass_through_sql=&m_sql,
				_output_table=user_tables,
				session_flg=1
				);
		%end;

	%if (&nobs_prod_purge_list gt 0) and (&nobs_geo_purge_list gt 0) %then
		%do;

			proc sql noprint;
				create table temp_lib.dbms_tables_to_purge as
					select b.memname, 'DI_DM2' as libname, a.num_rows as nobs,b.prod_hier_sk_true, b.geo_hier_sk_true 
						from work.user_tables a, temp_lib.dbms_tables b
							where a.num_rows gt 0 and upcase(a.table_name)=upcase(b.memname);
			quit;

		%end;
	%else
		%do;
			%if &nobs_geo_purge_list gt 0 %then
				%do;

					proc sql noprint;
						create table temp_lib.dbms_tables_to_purge as
							select b.memname, 'DI_DM2' as libname, a.num_rows as nobs,b.prod_hier_sk_true, b.geo_hier_sk_true 
								from work.user_tables a, temp_lib.dbms_tables b
									where a.num_rows gt 0 and upcase(a.table_name)=upcase(b.memname)
										and b.geo_hier_sk_true=1;
					quit;

				%end;
			%else %if &nobs_prod_purge_list gt 0 %then
				%do;

					proc sql noprint;
						create table temp_lib.dbms_tables_to_purge as
							select b.memname, 'DI_DM2' as libname, a.num_rows as nobs,b.prod_hier_sk_true, b.geo_hier_sk_true 
								from work.user_tables a, temp_lib.dbms_tables b
									where a.num_rows gt 0 and upcase(a.table_name)=upcase(b.memname)
										and b.prod_hier_sk_true=1;
					quit;

				%end;
		%end;

	/*========================================================================================*/
	/* Create argument tables based on no of rows in a table and num of parallel executions.  */
	/* The argument tables will be created in temp_lib and will be named as                   */
	/* Purge_list_dm_arg_1, Purge_list_dm_arg_2....n, where n= num of parallel executions     */
	/*========================================================================================*/
	%if &syscc le 4 %then
		%do;
			%if  %di_util_nobs(temp_lib.Sas_tables_to_purge) gt 0 %then
				%do;
					%let ds_type=SAS;

					%create_arg_table(ds=Sas_tables_to_purge,ds_type=&ds_type,purge_lib=di_dm);

					/* Call the macro di_util_purge_unit_by_gp to purge sas tables */
					%put ______: purging SAS tables;

					%di_util_mp_connect(
						mac_name=di_util_purge_unit_by_gp,
						arg_table=temp_lib.mp_arg_table_sas,
						nm_prll_exec=&num_parallel_executions);

					/* Delete all arg tables for sas i.e. purge_list_dm_arg_n */
					proc datasets lib = temp_lib nolist nowarn memtype = (data view);
						delete

							%do i= 1 %to &num_of_run;
								Sas_tables_to_purge_arg_&i
							%end;
						;
					quit;

					/*   proc datasets lib = temp_lib nolist nowarn memtype = (data view);*/
					/*      delete mp_arg_table_&ds_type;*/
					/*   quit;*/

				%end; /*%di_util_nobs(temp_lib.Sas_tables_to_purge) gt 0*/

			/*================================================================================*/
			/* Sorting all the Meta tables                                                    */
			/*================================================================================*/
			%put ______: Sorting di_dm.Prf_geo_prod_status_meta...;

			Proc sort data=di_dm.Prf_geo_prod_status_meta force;
				by part_sk prod_hier_sk;
			run;

			%put ______: Sorting di_dm.Prf_sales_fact_meta...;

			Proc sort data=di_dm.Prf_sales_fact_meta force;
				by part_sk prod_hier_sk;
			run;

			%put ______: Sorting di_dm.Prf_stockout_fact_meta...;

			Proc sort data=di_dm.Prf_stockout_fact_meta force;
				by part_sk prod_hier_sk;
			run;

			%put ______: Sorting di_dm.Prf_inventory_fact_meta...;

			Proc sort data=di_dm.Prf_inventory_fact_meta force;
				by part_sk prod_hier_sk;
			run;

			/*================================================================================*/
			/*  Purge data from di_trans library, except for Product_dm,                      */
			/*  Product_hier_assoc_dm, Geography_dm and Geography_hier_assoc_dm.              */
			/*  These four tables are purged at the end                                       */
			/*================================================================================*/
			%if  %di_util_nobs(temp_lib.Dbms_tables_to_purge) gt 0 %then
				%do;
					%put ______: purging RDBMS tables;

					/* This is a change introduced to restrict purging of all RDBMS tables except for geography_group_member
					       and product_group_member. Rest tables will be purged using solution specific purge macros */

					/* run the macro - act_app_nameto know which applications are active */
					%act_app_name;

					/*=====================================================================================*/
					/*  Purge from di_trans only those tables which are candidate for replication          */
					/*  We are not replicating them using replicate job coz of high performance.           */
					/*  These 7 RDBMS tables will be purged using trans_delete                             */
					/*  temp_lib.dbms_tables_to_purge has list of all RDBMS tables. The steps below        */
					/*  deletes all tables except for the ones to be purged                                */
					/*  temp_lib.dbms_tables_to_purge has all the RDBMS tables, but only tables present in */
					/*  macro variable db_tbls_lst will be purged, hence tables other than in db_tbls_lst  */
					/*  are deleted from temp_lib.dbms_tables_to_purge.                                    */
					/*  Include MDO_PLAN_MEMBER only MDO application is active.                            */
					/*=====================================================================================*/
					%local db_cmntbls;
					%let db_cmntbls=%str('GEOGRAPHY_GROUP_MEMBER','PRODUCT_GROUP_MEMBER','PRODUCT_ATTR_LOOKUP','GEOGRAPHY_ATTR_LOOKUP','COMP_PRICE_FACT','PRODUCT_ATTRIBUTES','GEOGRAPHY_ATTRIBUTES');

					data work.common_tbls;
						attrib table_nm length=$32;
						stop;
					run;

					proc sql noprint;
						insert into work.common_tbls values ('GEOGRAPHY_GROUP_MEMBER');
						insert into work.common_tbls values ('PRODUCT_GROUP_MEMBER');
						insert into work.common_tbls values ('PRODUCT_ATTR_LOOKUP');
						insert into work.common_tbls values ('GEOGRAPHY_ATTR_LOOKUP');
						insert into work.common_tbls values ('COMP_PRICE_FACT');
						insert into work.common_tbls values ('PRODUCT_ATTRIBUTES');
						insert into work.common_tbls values ('GEOGRAPHY_ATTRIBUTES');
					quit;

					data work.mdo_tables;
						attrib table_nm length=$32;
						table_nm='MDO_PLAN_MEMBER';
					run;

					/* Defect: S1294221 Common Metrics: Purginging of RPP table is being intorduced now along with Common metrics                           */
					/* make a copy of temp_lib.dbms_tables_to_purge as temp_lib.rdbms_tables_purge just to re-use it if required                            */
					/* temp_lib.rpp_tables will now have only those tables that have been identified for purging for RPP solution                           */
					/* along with the tables that are replicated [i.e. common tables &db_cmntbls] and conditionally include mdo_plan_member                 */
					
					data temp_lib.rdbms_tables_purge;
						set temp_lib.dbms_tables_to_purge;
					run;

					data work.rpp_tables;
						attrib table_nm length=$32;
						stop;
					run;

					/*work.rpp_tables: will have rpp tables + common/replicated tables */
					proc sql noprint;
						insert into work.rpp_tables values ('AGGREGATION_METRICS');
						insert into work.rpp_tables values ('BASE_FORECAST_OVERRIDE_GP');
						insert into work.rpp_tables values ('COMP_PRICE_FACT');
						insert into work.rpp_tables values ('CONFIG_AUDIT_TRAIL');
						insert into work.rpp_tables values ('COVERAGE_OUTPUT');
						insert into work.rpp_tables values ('CURRENCY_DM');
						insert into work.rpp_tables values ('DATA_CONFIG');
						insert into work.rpp_tables values ('FA_MONITORING_GEO');
						insert into work.rpp_tables values ('FA_MONITORING_PROD');
						insert into work.rpp_tables values ('FA_PRESEASON_GEO');
						insert into work.rpp_tables values ('FA_PRESEASON_PROD');
						insert into work.rpp_tables values ('FCST_EXPORT_INPUT');
						insert into work.rpp_tables values ('GEOGRAPHY_ATTRIBUTES');
						insert into work.rpp_tables values ('GEOGRAPHY_ATTR_LOOKUP');
						insert into work.rpp_tables values ('GEOGRAPHY_GROUP_MEMBER');
						insert into work.rpp_tables values ('GEO_PROD_AGG');
						insert into work.rpp_tables values ('GEO_PROD_AGG_FUTURE');
						insert into work.rpp_tables values ('GEO_PROD_RPP');
						insert into work.rpp_tables values ('GEO_PROD_SETTING');
						insert into work.rpp_tables values ('GEO_SCOPE_DETAIL');
						insert into work.rpp_tables values ('HALO_PRODUCTS');
						insert into work.rpp_tables values ('MARGIN_RULE_RESULT');
						insert into work.rpp_tables values ('MIN_MAX_PRICE_CHG_RULE');
						insert into work.rpp_tables values ('MIN_MAX_RULE_RESULT');
						insert into work.rpp_tables values ('MODEL_GROUP');
						insert into work.rpp_tables values ('NUM_GEO_PROD');
						insert into work.rpp_tables values ('PRICE_GRID');
						insert into work.rpp_tables values ('PRICING_RELATION');
						insert into work.rpp_tables values ('PRICING_RELN_RULE_RESULT');
						insert into work.rpp_tables values ('PROCESS_INPUT');
						insert into work.rpp_tables values ('PRODUCT_ATTRIBUTES');
						insert into work.rpp_tables values ('PRODUCT_ATTR_LOOKUP');
						insert into work.rpp_tables values ('PRODUCT_GROUP_MEMBER');
						insert into work.rpp_tables values ('PROD_DC_INV_AGG');
						insert into work.rpp_tables values ('PROD_RELN_GROUP');
						insert into work.rpp_tables values ('PROD_SCOPE_DETAIL');
						insert into work.rpp_tables values ('RPP_BATCH_EVAL_RULES');
						insert into work.rpp_tables values ('RPP_MESSAGE_DETAILS');
						insert into work.rpp_tables values ('RPP_METRICS');
						insert into work.rpp_tables values ('RPP_PLAN_ACTUALS_PART');
						insert into work.rpp_tables values ('RPP_PLAN_COST_FACT');
						insert into work.rpp_tables values ('RPP_PLAN_PROD_ASGMNT');
						insert into work.rpp_tables values ('RPP_PLAN_PROD_METRICS');
						insert into work.rpp_tables values ('RPP_PLAN_PROD_METRICS_PART');
						insert into work.rpp_tables values ('RPP_PLAN_RESULTS');
						insert into work.rpp_tables values ('RPP_PROCESS_GEO');
						insert into work.rpp_tables values ('RPP_PROCESS_PROD');
						insert into work.rpp_tables values ('SAME_PRICE_SET');
						insert into work.rpp_tables values ('SCOPE_DETAIL');
						insert into work.rpp_tables values ('SCORING_PARAM_DEFAULT');
						insert into work.rpp_tables values ('TKMI_GRID_DATA_MAP');
					quit;

					%local common_tbl;
					%let common_tbl=1;

					/* temp_lib.dbms_tables_to_purge has list of RDBMS tables                                                                                         */
					/* if both, MDO and RPP are active, then delete all tables from temp_lib.dbms_tables_to_purge except for common tables,MDO_PLAN_MEMBER, rpp_tables*/
					/* if CPO is active, then delete all tables from temp_lib.dbms_tables_to_purge except for common tables and MDO_PLAN_MEMBER                       */
					/* if RPP is active, then delete all tables from temp_lib.dbms_tables_to_purge except for common tables and rpp_tables                            */
					/* if both, RPP or MDO are inactive, then delete all tables from temp_lib.dbms_tables_to_purge except for common tables                           */
					/* nothing is done for SZPF and SZPK as there are separate macros that handle purging of SO tables                                                */
					%if (&application_cpo eq 1 and &valid_lic_cpo=1) and  (&application_rpp eq 1 and &valid_lic_rpp=1) %then
						%do;
							%let common_tbl=0;

							data work.merge_tables;
								set  work.rpp_tables work.Mdo_tables;
							run;

							proc sql noprint;
								delete from temp_lib.dbms_tables_to_purge 
									where upcase(memname) not in (select table_nm from work.merge_tables);
							quit;

						%end;
					%else
						%do;
							%if (&application_cpo eq 1 and &valid_lic_cpo=1) %then
								%do;
									%let common_tbl=0;

									proc sql noprint;
										delete from temp_lib.dbms_tables_to_purge 
											where upcase(memname) not in (&db_cmntbls,'MDO_PLAN_MEMBER');
									quit;

								%end;

							/*if RPP is active, then delete all tables from temp_lib.dbms_tables_to_purge except for common tables */
							/*and RPP specific tables listed in work.rpp_tables                                                    */
							%if (&application_rpp eq 1 and &valid_lic_rpp=1) %then
								%do;
									%let common_tbl=0;

									proc sql noprint;
										delete from temp_lib.dbms_tables_to_purge 
											where upcase(memname) not in (select table_nm from work.rpp_tables);
									quit;

								%end;
						%end;

					/*if mdo or rpp, none are active, then also the tables in &db_cmntbls needs to purged */
					/*as they are common and must be in synch with SAS datasets                            */
					%if &common_tbl=1 %then
						%do;

							proc sql noprint;
								delete from temp_lib.dbms_tables_to_purge 
									where upcase(memname) not in (&db_cmntbls);
							quit;

						%end;

					/* temp_lib.plans_affected_p and temp_lib.plans_affected_g:  Created in the previous steps */
					
					/*merge plan_sk from both Prod and Geo affected plans */
					data temp_lib.plans_affected_tmp;
						%if %sysfunc(exist(temp_lib.plans_affected_g)) and  %sysfunc(exist(temp_lib.plans_affected_p)) %then
							%do;
								set temp_lib.plans_affected_g temp_lib.plans_affected_p;
							%end;
						%else %if %sysfunc(exist(temp_lib.plans_affected_g)) %then
							%do;
								set temp_lib.plans_affected_g;
							%end;
						%else %if %sysfunc(exist(temp_lib.plans_affected_p)) %then
							%do;
								set temp_lib.plans_affected_p;
							%end;
						%else
							%do;
								attrib plan_sk length=4;
								attrib plan_nm length=$10;
                                attrib plan_desc length=$10;
								attrib status_cd length=1;
								attrib prev_scope_sk length=4;
                                attrib prod_hier_sk length=8;
								attrib geo_hier_sk length=8;
								attrib prod_id length=8;
								attrib geo_id length=8;
								stop;
							%end;
					run;

					proc sort data=temp_lib.plans_affected_tmp out=temp_lib.plans_affected; /*nodup;*/
						by plan_sk;
					run;

					proc datasets lib=temp_lib noprint;
						delete plans_affected_g plans_affected_p get_scope_g plans_affected_tmp;
					quit;

					/* Create argument table for purging RDBMS tables */
					%let ds_type=RDBMS;

					%create_arg_table(ds=Dbms_tables_to_purge,ds_type=&ds_type,purge_lib=di_dm2);

					%let rdbms_arg_nobs=%di_util_nobs(temp_lib.mp_arg_table_rdbms);
					%put rdbms_arg_nobs=&rdbms_arg_nobs;

					%di_util_mp_connect(
						mac_name=di_util_purge_unit_by_gp,
						arg_table=temp_lib.mp_arg_table_rdbms,
						nm_prll_exec=&num_parallel_executions);

					/* Delete temporary tables */
					proc datasets lib = temp_lib nolist nowarn memtype = (data view);
						delete

							%do i= 1 %to &num_of_run;
								Dbms_tables_to_purge_arg_&i
							%end;
						;
					quit;

					/*proc datasets lib = temp_lib nolist nowarn memtype = (data view);*/
					/*   delete mp_arg_table_&ds_type;*/
					/*quit;*/
					%put ______: Executing update_rpp_plan...;
					%let syscc=0;

					%update_rpp_plan;
					%put ______: Value of syscc after update_rpp_plan() = &syscc;
					%let etls_jobName = %nrquote(DI_ETL_Geo_prod_purge_job : update_rpp_plan);
					%let etls_endTime = %sysfunc(datetime(),datetime.);
					%let job_rc=&syscc;

					%etls_sendjobstatus(source_table = didm_stg.Stg_geo_prod_purge_list);
				%end;

			%di_util_get_time(_time = end_time);
			%put NOTE: Purge activity started at &start_time., ended at &end_time. with a return code=&syscc.;

			%di_util_get_time(_time = start_time);

			/* Run the post-purge macros */
			%run_post_purge_macros;

		%end; /*%if &syscc le 4 %then %do;*/
	%else
		%do;
			%put WARNING: The value of syscc=&syscc. The job DI_ETL_Geo_prod_purge terminated, please check the log for errors;
		%end;

	/*UPDATE PURGE_RESULT_TABLE*/
	/*================================================================================*/
	/*  Update di_dm.Geo_prod_purge_list                                              */
	/*================================================================================*/
	%local l_prg_flg_cnt prg_flg prg_cnt l_prg_exec_cnt;
        * HF - IIOTTRIAGE-15;
	proc sql noprint;
		select count(*) into: l_prg_exec_cnt from di_dm.Purge_result_table 
			where purge_dttm >= "&etls_StartTime_GP_purge"dt;
	quit;

	%put etls_StartTime=&etls_StartTime_GP_purge;
	%let l_prg_exec_cnt=&l_prg_exec_cnt;
	%put ______: Count of records with l_prg_exec_cnt = &l_prg_exec_cnt;
        * HF - IIOTTRIAGE-15;
	proc sql noprint;
		select count(*) into: l_prg_flg_cnt from di_dm.Purge_result_table 
			where purged_flg='N' and purge_dttm >= "&etls_StartTime_GP_purge"dt ;
	quit;

	%let l_prg_flg_cnt=&l_prg_flg_cnt;
	%put ______: Count of records with purged_flg=N = &l_prg_flg_cnt;

	/*
	%if &l_prg_flg_cnt > 0 and &l_prg_exec_cnt > 0 %then %do;
		  %let prg_flg='N';
	%end;
	*/
	%if &l_prg_flg_cnt = 0 and &l_prg_exec_cnt > 0 %then
		%do;
			%let prg_flg='Y';
		%end;
	%else
		%do;
			%let prg_flg='N';
		%end;

	%put prg_flg=&prg_flg;

	%if %sysfunc(exist(temp_lib.Prod_purge_list)) %then
		%do;

			proc sql noprint;
				update di_dm.Geo_prod_purge_list
					set PURGED_FLG = &prg_flg,
						PURGED_DTTM = "&etls_StartTime"dt
					where object_type = 'P' 
						and PURGED_FLG = 'N'
						and object_key in (select prod_hier_sk
					from temp_lib.Prod_purge_list);
			quit;

		%end;

	%if %sysfunc(exist(temp_lib.geo_purge_list)) %then
		%do;

			proc sql noprint;
				update di_dm.Geo_prod_purge_list
					set PURGED_FLG = &prg_flg,
						PURGED_DTTM = "&etls_StartTime"dt
					where object_type = 'G' 
						and PURGED_FLG = 'N'
						and object_key in (select geo_hier_sk
					from temp_lib.geo_purge_list);
			quit;

		%end;

	%di_etl_keep_work_table(Uw_distinct_geo_prod Ext_geo_prod_detail);

	proc sql noprint;
		select count(*) into: prg_cnt from di_dm.Geo_prod_purge_list
			where PURGED_FLG='N' and
				PURGED_DTTM ge "&etls_startTime"dt;
	quit;

	%put ______: Value of job_rc=&job_rc;
	%put ______: Value of syscc=&syscc;

	%if &syscc > 4 %then
		%do;
			%let job_rc=9999;
		%end;
	%else %if &prg_cnt gt 0 %then
		%do;
			%let job_rc=9999;
		%end;
	%else
		%do;
			%let job_rc=0;
		%end;

	%let etls_jobName = %nrquote(DI_ETL_Geo_prod_purge_job);

	%etls_sendjobstatus(source_table = didm_stg.Stg_geo_prod_purge_list);
	%di_util_get_time(_time = end_time);
	%put NOTE: Post Purge activities started at &start_time., ended at &end_time. with a return code=&syscc.;

%ERROREXIT:
	%di_util_get_time(_time = end_time);
	%put NOTE: DI_ETL_geo_prod_purge started at &etls_StartTime_GP_purge., ended at &end_time. with a return code=&syscc.;
%mend call_purge_job;

/*===========================================================================================*/
/*The macro call_purge_job will purge SAS tables, RDBMS tables and Partitioned Tables.       */
/*===========================================================================================*/
%call_purge_job;
