/* 
SUPPORT: sinsks Das, Sourav Kumar
*/ 
/******************************************************************************
 * Job:             Load_STG2DM_Prf_inventory_fact.sas                        *
 * Description:                                                               *
 * Source Tables:   GEOGRAPHY_DM - DI_DM.GEOGRAPHY_DM                         *
 *                  PROD_HIER_SK - DI_MON.PROD_HIER_SK                        *
 *                  DATE_DM - DI_DM.DATE_DM                                   *
 *                  STG_PRF_INVENTORY - DIDM_STG.STG_PRF_INVENTORY            *
 * Target Tables:   DI_DM.PRF_INVENTORY_FACT                                  *
 *                  DI_DM.PACK_INVENTORY_FACT                                 *
 *                  DI_DM.PRF_INVENTORY_FACT_META                             *
 *                  DI_MON.STG_PRF_INVENTORY_X                                *
 *                  PACK_INVENTORY_FACT - DI_DM.PACK_INVENTORY_FACT           *
 * Generated on:                                                              *
 * Generated by:    sinsks@ROW                                                *
 * Version:                                                                   *
 ******************************************************************************/

 %let etls_jobName = %nrquote(Load_STG2DM_Prf_inventory_fact);
 %let load_startTime = %sysfunc(datetime(),datetime.);

 /* Setup to capture return codes  */
 %global job_rc trans_rc sqlrc;
 %let sysrc = 0;
 %let job_rc = 0;
 %let trans_rc = 0;
 %let sqlrc = 0;
 %let syscc=0;
 %global syserr;

 %macro rcSet(error);
    %if (&error gt &trans_rc) %then
       %let trans_rc = &error;
    %if (&error gt &job_rc) %then
       %let job_rc = &error;
 %mend rcSet;

 %macro rcSetDS(error);
    if &error gt input(symget('trans_rc'),12.) then
       call symput('trans_rc',trim(left(put(&error,12.))));
    if &error gt input(symget('job_rc'),12.) then
       call symput('job_rc',trim(left(put(&error,12.))));
%mend rcSetDS;

/* Setup for capturing job status  */
%let etls_startTime = %sysfunc(datetime(),datetime.);
%let etls_recordsBefore = 0;
%let etls_recordsAfter = 0;
%let etls_lib = 0;
%let etls_table = 0;

%global error_count_partioned error_count;


%global etls_debug;
%macro etls_setDebug;
   %if %str(&etls_debug) ne 0 %then
      OPTIONS MPRINT%str(;);
%mend;
%etls_setDebug;

/*---- Start of Pre-Process Code  ----*/
%etl_initjobparam (monlib=di_mon, jobname=%nrquote(&etls_jobName));
%put ______: etlp_exception_table  &etlp_exception_table;


/*============================================================================*
 * Check the presence of the lookup tables                                    *
 *============================================================================*/

%macro etl_check_exist;

%put checking the presence of the lookup tables ;

%global len_excp_msg;
%local  abort etl_msg ;
%let abort = 0 ;

   /* Check for existence of DI_DM.GEOGRAPHY_DM dataset */
   %if NOT %sysfunc(exist(DI_DM.GEOGRAPHY_DM)) %then %do;
      %let etl_msg = %etl_msg(mid=5005,args=DI_DM.GEOGRAPHY_DM);
      %put &etl_msg;
      %let abort = 1 ;
   %end;

   /* Check for existence of DI_DM.PRODUCT_HIER_ASSOC_DM dataset */
   %if NOT %sysfunc(exist(DI_DM.PRODUCT_HIER_ASSOC_DM)) %then %do;
      %let etl_msg = %etl_msg(mid=5005,args=DI_DM.PRODUCT_HIER_ASSOC_DM);
      %put &etl_msg;
      %let abort = 2 ;
   %end;

   /* Check for existence of DI_DM.PRODUCT_DM dataset */
   %if NOT %sysfunc(exist(DI_DM.PRODUCT_DM)) %then %do;
      %let etl_msg = %etl_msg(mid=5005,args=DI_DM.PRODUCT_DM);
      %put &etl_msg;
      %let abort = 3 ;
   %end;

   /* Check for existence of DI_DM.DATE_DM dataset */
   %if NOT %sysfunc(exist(DI_DM.DATE_DM)) %then %do;
      %let etl_msg = %etl_msg(mid=5005,args=DI_DM.DATE_DM);
      %put &etl_msg;
      %let abort = 4 ;
   %end;

   /* Check for existence of DI_DM.PRF_INVENTORY_FACT_META dataset */
   %if NOT %sysfunc(exist(DI_DM.PRF_INVENTORY_FACT_META)) %then %do;
      %let etl_msg = %etl_msg(mid=5005,args=DI_DM.PRF_INVENTORY_FACT_META);
      %put &etl_msg;
     %let abort = 5 ;
   %end;

      /* Check for existence of DI_DM.DATA_LVL dataset */
   %if NOT %sysfunc(exist(DI_DM.DATA_LVL)) %then %do;
      %let etl_msg = %etl_msg(mid=5005,args=DI_DM.DATA_LVL);
      %put &etl_msg;
     %let abort = 5 ;
   %end;

%put fetching the length of exception msg variable ; 

    /* Get the length of exception msg variable in exception table */
         data _null_;
            dsid=open("&etlp_exception_table","I", ,'D');
            num=attrn(dsid,"nvars");
            do i=1 to num;
               name=varname(dsid,i);
               if upcase(name) = 'ETLS_EXCEPTION_COND' then do;
                  len_excp_msg = varlen(dsid,i);
                  call symput('len_excp_msg',compress(len_excp_msg));
               end;
            end;
            rc=close(dsid);
         run;
         %let len_excp_msg=&len_excp_msg;

         %if %eval(&len_excp_msg le 0) %then %do;
            %let etl_msg = %etl_msg(mid=5013,args=ETLS_EXCEPTION_COND &etlp_exception_table);
            %put &etl_msg;
            %let abort = 6 ;
      %end;

   %if &abort gt 0 %then %do;
      %etl_abort;
   %end;


%mend etl_check_exist;

%etl_check_exist;


/*============================================================================*
 * Check whether the application is active or not                             *
 *============================================================================*/

%global g_szpf_active_app_flg g_szpk_active_app_flg;

%macro application_chk;

/*Get ACTIVE_APP_FLG for SZPF application*/

%put checking if the Prf application is active or not;

   %di_util_global_setting_spec(spec_nm=ACTIVE_APP_FLG,
                                app=SZPF,
                                _spec_value=g_szpf_active_app_flg,
                                optional=0);

%di_etl_rcSet(error=&syscc,code=job_rc);

/* If Profile application is not set then continue running job after showing a warning message */

%if &g_szpf_active_app_flg ne 1 %then
%do;
     %let etl_msg = %etl_msg(mid=5116,args=ACTIVE_APP_FLG(SZPF) GLOBAL_SETTING);
     %put &etl_msg;
%end;


/*Get ACTIVE_APP_FLG for SZPK application*/
%di_util_global_setting_spec(spec_nm=ACTIVE_APP_FLG,
                             app=SZPK,
                             _spec_value=g_szpk_active_app_flg,
                             optional=0);

%rcSet(&sqlrc);

/* If Pack application is not set then stop running job */
%if &g_szpk_active_app_flg ne 1 %then
   %do;
      %let etl_msg = %etl_msg(mid=5116,args=ACTIVE_APP_FLG(SZPK) GLOBAL_SETTING);
      %put &etl_msg;
   %end;

 /*============================================================================*
  * Fetch all the global parameters from DI_MON.GLOBAL_SETTINGS                *
  *============================================================================*/

%global g_geo_prod_low_data_lvl_size g_szpk_prod_lvl g_szpk_geo_lvl g_szpk_date_lvl;

%put fetching the global parameters from Global settings;

%di_util_global_setting_spec(spec_nm=GEO_PROD_LOW_DATA_LVL_SIZE,
                                _spec_value=g_geo_prod_low_data_lvl_size,
                                optional=0);

%let g_geo_prod_low_data_lvl_size=&g_geo_prod_low_data_lvl_size;

 /* validation for geo_prod_low_data_lvl_size */

%if &g_geo_prod_low_data_lvl_size eq %str() %then
%do;
   %let etl_msg = %etl_msg(mid=5012,args=GEO_PROD_LOW_DATA_LVL_SIZE GLOBAL_SETTING);
   %put &etl_msg;
   %etl_abort;
%end;
%else
   %put g_geo_prod_low_data_lvl_size=&g_geo_prod_low_data_lvl_size;

 /* Extract from global_Setting, the Product Level at which data is partitioned*/

%global prod_partition_lvl num_parallel_executions;

%di_util_global_setting_spec(spec_nm=PROD_PARTITION_LVL,
                                _spec_value=prod_partition_lvl,
                                optional=0);

%if &prod_partition_lvl eq %str() and &g_szpf_active_app_flg eq 1 %then
%do;
   %let etl_msg = %etl_msg(mid=5012,args=PROD_PARTITION_LVL GLOBAL_SETTING);
   %put &etl_msg;
   %etl_abort;
%end;
%else
   %put prod_partition_lvl=&prod_partition_lvl;

%di_etl_rcSet(error=&sqlrc,code=job_rc);

%put ______: prod_partition_lvl=&prod_partition_lvl;

/* Extract from global_Setting, number of sas sessions runs in parallel*/

%di_util_global_setting_spec(spec_nm=NUM_PARALLEL_EXECUTIONS,
                                _spec_value=num_parallel_executions,
                                optional=0);

%if &num_parallel_executions eq %str() %then
%do;
   %let num_parallel_executions=20;
%end;

%put Number of Parallel Execution : &num_parallel_executions;

%di_etl_rcSet(error=&sqlrc,code=job_rc);


/*============================================================================*
 * Determining low levels for GEO and PROD using di_dm.data_lvl               *
 *============================================================================*/

proc sql noprint;
   select prod_lvl, geo_lvl ,date_lvl into :g_szpk_prod_lvl, :g_szpk_geo_lvl, :g_szpk_date_lvl
   from di_dm.data_lvl
   where data_lvl_id=&g_geo_prod_low_data_lvl_size and PROD_HIER_ASSOC_CD=1 and GEO_HIER_ASSOC_CD=1;
quit;


%let g_szpk_prod_lvl=&g_szpk_prod_lvl;
%let g_szpk_geo_lvl=&g_szpk_geo_lvl;

%if &sqlobs eq 0 %then
   %do;
      %let etl_msg = %etl_msg(mid=5012,args=GEO_PROD_LOW_DATA_LVL_SIZE DATA_LVL);
      %put &etl_msg;
     %etl_abort;
%end;
%else
   %do;
      %put Prf prod_lvl=&g_szpk_prod_lvl;
      %put Prf geo_lvl=&g_szpk_geo_lvl;
%end;

%mend application_chk;

%application_chk;


/*============================================================================*
 * Define product-parent relation with parent at PROD_PARTITION_LVL           *
 *============================================================================*/

proc datasets lib = work nolist nowarn memtype = (data view);
   delete hash_prod_filter_table;
quit;

proc sql;
   create table WORK.hash_prod_filter_table as
   select prod_hier_sk,
          parent_prod_hier_sk as part_sk
   from di_dm.product_hier_assoc_dm
   where prod_hier_assoc_cd eq 1
   and parent_prod_lvl eq &prod_partition_lvl;
quit;

%di_etl_rcSet(error=&syscc,code=job_rc);

 /*============================================================================*
  * Hashlookup with the required tables to fetch geo_hier_sk, prod_hier_sk,    *
  * date_sk and part_sk                                                        *
  * Perform the validations                                                    *
  *============================================================================*/

%let meta_table_obs = %di_util_nobs(DI_DM.PRF_INVENTORY_FACT_META);
%put Meta Table Observations = &meta_table_obs;

proc sql;
create view work.etl_lookup_product_dm
   as select (MAX(PROD_HIER_SK)) as PROD_HIER_SK length = 6,
              PROD_ID,
              (MAX(STD_HIER_PROD_LVL)) as STD_HIER_PROD_LVL length = 4
              from di_dm.product_dm
                 group by
                 PROD_ID;
quit;

%put Calculating the minimum start date and maximum end date of DI_DM.DATE_DM;

/* Calculating the minimum start date and maximum end date of DI_DM.DATE_DM */
%let min_start_dt=;
%let max_end_dt=;
%let max_date_lvl=;

proc sql noprint;
select
max(date_lvl) into :max_date_lvl 
from DI_DM.date_dm;
quit;

%put &max_date_lvl;

proc sql noprint;
select
put(min(FISCAL_START_DT),date9.),
put(max(FISCAL_END_DT),date9.)
into :min_start_dt , :max_end_dt
from DI_DM.date_dm
where date_lvl=&max_date_lvl.;
quit;

/*============================================================================* 
 * Extract Date_SK                                                            *
 *============================================================================*/ 
data work.date_sk_fmt (keep = fmtName start end label  date_sk type hlo); 
   length label 8 start 8 end 8; 
   set DI_DM.DATE_DM end = eof; 
   where DATE_LVL=&max_date_lvl.;
   start = FISCAL_START_DT; 
   end = FISCAL_END_DT; 
   label = DATE_SK;
   fmtName = "DATE_SK";
   type = "I";
   output; 
   if eof then 
   do; 
      start = "-9999999"; 
      hlo = "O"; 
      label = -1; 
      output; 
   end; 
run; 

proc sort data = work.date_sk_fmt nodupkey; 
   by start; 
run;

proc format cntlin = work.date_sk_fmt library = work; 
run;

%put hash lookup;
data WORK.STG_PRF_INVENTORY_FACT_part_sk (keep = PROD_HIER_SK GEO_HIER_SK DATE_SK INVENTORY_DT DISPLAY_UNITS CLOSE_INV_UNITS PART_SK )
     WORK.PRF_INVENTORY_FACT_err (keep = PROD_ID GEO_ID INVENTORY_DT DISPLAY_UNITS CLOSE_INV_UNITS PART_SK _EXCEPTION_COND);
     attrib PROD_ID length=$32;
     attrib GEO_ID length=$32;
     attrib PROD_HIER_SK length=6;
     attrib GEO_HIER_SK length=6;
     attrib DATE_SK length=8;
     attrib INVENTORY_DT FORMAT=DATE9.;
     attrib CLOSE_INV_UNITS length=8;
     attrib DISPLAY_UNITS length=8;
     attrib PART_SK length=6;
     attrib _EXCEPTION_COND length=$15;
     attrib STD_HIER_PROD_LVL length=4;
     attrib STD_HIER_GEO_LVL length=4;

     retain missing0 missing1 missing2 missing3 0;

     if _N_ =1 then
     do;
        %di_util_hash_define( h_num = 0,
               dsn   = %QUOTE(DI_DM.GEOGRAPHY_DM),
               d_key = %QUOTE("GEO_ID"),
               d_data= %QUOTE("GEO_HIER_SK","STD_HIER_GEO_LVL")
               );
        %di_util_hash_define( h_num = 1,
               dsn   = %QUOTE(work.etl_lookup_product_dm),
               d_key = %QUOTE("PROD_ID"),
               d_data= %QUOTE("PROD_HIER_SK","STD_HIER_PROD_LVL")
               );
        %di_util_hash_define( h_num = 2,
               dsn   = %QUOTE(WORK.hash_prod_filter_table),
               d_key = %QUOTE("PROD_HIER_SK"),
               d_data= %QUOTE("PART_SK")
               );
        %di_util_hash_define( h_num = 3,
               dsn   = %QUOTE(DI_DM.PRF_INVENTORY_FACT_META),
               d_key = %QUOTE("PROD_HIER_SK"),
               d_data= %QUOTE("PART_SK")
               );
        call missing(PROD_ID, PROD_HIER_SK, GEO_ID, GEO_HIER_SK, PART_SK, STD_HIER_GEO_LVL, STD_HIER_PROD_LVL  );
     end;
     set didm_stg.stg_prf_inventory end=eof;

     if missing0 < 1 then
        rc0 = h0.find();
     else
        rc0 = missing0;
        if missing1 < 1 then
           rc1 = h1.find();
        else
           rc1 = missing1;

     if %eval(&meta_table_obs gt 0) then do;
        if rc1 = 0 then do;
           rc3 = h3.find();
           if rc3 ne 0 then do;
              rc2 = h2.find();
              if rc2 ne 0 then do;
                 _EXCEPTION_COND = cats(_EXCEPTION_COND,'PH*');
              end;
           end;
        end;
        else do;
           _EXCEPTION_COND = cats(_EXCEPTION_COND,'P*');
        end;
     end;
     else do;
        if rc1 = 0 then do;
           rc2 = h2.find();
           if rc2 ne 0 then do;
              _EXCEPTION_COND = cats(_EXCEPTION_COND,'PH*');
           end;
        end;
        else do;
          _EXCEPTION_COND = cats(_EXCEPTION_COND,'P*');
        end;
     end;


   CLOSE_INV_UNITS=COALESCE(CLOSE_INV_UNITS,0);
   DISPLAY_UNITS=COALESCE(DISPLAY_UNITS,0);
   DATE_SK=(input(put(INVENTORY_DT,8.),DATE_SK.));

%put Validations;

/* Perform data validation */
/* Invalid PROD_ID */
   if rc0 ne 0 then do;
      _EXCEPTION_COND = cats(_EXCEPTION_COND,'G*');
   end;

/* PROD_ID not at level specified by GEO_PROD_LOW_DATA_LVL  */
   if rc1=0 and STD_HIER_PROD_LVL ne &g_szpk_prod_lvl then
      _EXCEPTION_COND = cats(_EXCEPTION_COND,'p*');

/* GEO_ID not at level specified by GEO_PROD_LOW_DATA_LVL  */
   if rc0=0 and STD_HIER_GEO_LVL ne &g_szpk_geo_lvl then
      _EXCEPTION_COND = cats(_EXCEPTION_COND,'g*');

   if CLOSE_INV_UNITS lt 0 then
      _EXCEPTION_COND = cats(_EXCEPTION_COND, 'f*');

   if DISPLAY_UNITS lt 0 then
      _EXCEPTION_COND = cats(_EXCEPTION_COND, 'w*');

   if INVENTORY_DT lt "&min_start_dt"d or INVENTORY_DT gt "&max_end_dt"d then do;
      _EXCEPTION_COND = cats(_EXCEPTION_COND, 'D*');
   end;

   if missing(_EXCEPTION_COND) then
      output STG_PRF_INVENTORY_FACT_part_sk ;
   else do;
      output PRF_INVENTORY_FACT_err;
   end;

   if eof then do;
   call symputx('stg_count',strip(put(_n_,32.)));
   end;
run;

   data WORK.PRF_INVENTORY_FACT_ERR(keep= %di_util_column_names(&etlp_exception_table));
   set WORK.PRF_INVENTORY_FACT_ERR;
      attrib ETLS_EXCEPTION_COND length=$&len_excp_msg.;
      attrib ETL_ERROR_JOBRUNTIME length=8 format=datetime16.;
      ETL_ERROR_JOBRUNTIME = "&etls_startTime"dt;

      if index(_EXCEPTION_COND,'P') then
         ETLS_EXCEPTION_COND = cats(ETLS_EXCEPTION_COND,'0a'x,"* %etl_msg(mid=5305,args=Prod_ID)");

      if index(_EXCEPTION_COND,'G') then
         ETLS_EXCEPTION_COND = cats(ETLS_EXCEPTION_COND,'0a'x,"* %etl_msg(mid=5305,args=Geo_ID)");

      if index(_EXCEPTION_COND,'p*') then
         ETLS_EXCEPTION_COND = cats(ETLS_EXCEPTION_COND,'0a'x,"* %etl_msg(mid=5353,args=PROD_ID)");

      if index(_EXCEPTION_COND,'g*') then
         ETLS_EXCEPTION_COND = cats(ETLS_EXCEPTION_COND,'0a'x,"* %etl_msg(mid=5353,args=GEO_ID)");

      if index(_EXCEPTION_COND,'f*') then
         ETLS_EXCEPTION_COND = cats(ETLS_EXCEPTION_COND,'0a'x,"* %etl_msg(mid=5328,args=CLOSE_INV_UNITS 0)");

      if index(_EXCEPTION_COND,'PH*') then
         ETLS_EXCEPTION_COND = cats(ETLS_EXCEPTION_COND,'0a'x,"* %etl_msg(mid=5306,args=PARENT_PROD[Partition-lvl])");

      if index(_EXCEPTION_COND,'w*') then
          ETLS_EXCEPTION_COND = cats(ETLS_EXCEPTION_COND,'0a'x,"* %etl_msg(mid=5328,args=DISPLAY_UNITS 0)");

      if index(_EXCEPTION_COND,'D*') then
         ETLS_EXCEPTION_COND = cats(ETLS_EXCEPTION_COND,'0a'x,"* %etl_msg(mid=5305,args=INVENTORY_DT)");
      drop _EXCEPTION_COND;
   run;
   
   %di_etl_rcset(error=&syscc,code=job_rc);

   %let stg_count=%di_util_nobs(didm_stg.stg_prf_inventory);
   %let etl_xobsbefore=%di_util_nobs(&etlp_exception_table.);

   /* Write to exception table */
   proc append base=&etlp_exception_table. data=work.PRF_INVENTORY_FACT_err force;
   run;

   %let error_count=%di_util_nobs(WORK.PRF_INVENTORY_FACT_err);

   %di_etl_rcset(error=&syscc,code=job_rc);

   %di_etl_keep_work_table(STG_PRF_INVENTORY_FACT_part_sk);

   %macro di_etl_load_prf_inventory;

   /*============================================================================*
   * Creating stg_lib for storing partitioned stage tables          *
   *============================================================================*/

   /* Fetch the work library base path */
   proc sql noprint;
      select cats(path,'/..') into :work_base_path
      from sashelp.vlibnam
      where upcase(libname) = upcase("WORK")
            and level in (0 1);
   quit;

   %let work_base_path = &work_base_path;

   %let sub_dir_name = prf_inventory_fact;
   %let stg_lib_path = %di_util_create_folder(relative_dir=&sub_dir_name ,parent_dir=&work_base_path);

   libname stg_lib "&stg_lib_path";
   %di_etl_rcset(error=&syserr,code=job_rc);

   proc datasets lib=stg_lib
      nolist kill;
   quit;

   /* Create Job_status in stg_lib if not exist */
   %if not %sysfunc( exist(stg_lib.job_status)) %then %do;
      %di_util_lock(di_mon.job_status);
         data stg_lib.job_status;
            set di_mon.job_status;
            stop;
         run;
         %di_util_unlock(di_mon.job_status);
   %end;

   %if &g_szpf_active_app_flg eq 1 %then
   %do;

   %put creating mp connect argument table ;
   /*============================================================================*
   * Creating MP Connect Argument table for partitions                          *
   *============================================================================*/
   proc sql noprint;
      create table work.mp_conn_arg as
      select distinct(part_sk) as PART_SK,
             "P_"||left(put(part_sk,20.)) as src_table,
             "&stg_lib_path" as stage_path
      from WORK.STG_PRF_INVENTORY_FACT_part_sk
   quit;

   %di_etl_rcset(error=&syscc,code=job_rc);

   /*============================================================================*
   * Prepare the macro variables                                                *
   *============================================================================*/

   %local t_subset_list list_part_sk num_parts_sk;

   %let num_parts_sk=0;

   proc sql noprint;
      select strip(put(part_sk,20.)),
             count(part_sk)
      into  :list_part_sk separated by ' ',
            :num_parts_sk
      from work.mp_conn_arg;
   quit;

   %put List of part_sk - &list_part_sk.;
   %put Number of part_sk - &num_parts_sk.;
   %put splitting stage table by part_sk;
   /*============================================================================*
   * Splitting stage table by PART_SK                                           *
   *============================================================================*/
   %local tmp_part iter out_table;

   %if &num_parts_sk gt 0 %then %do; /*Check the Argument table is empty.If it is empty no need to process*/
   /* Splitting stage table by PART_SK */
   /* chnage name of partition stg tables for RLOBTRIAGE-272 */
   data 
   %let mydataid=%sysfunc(open(work.mp_conn_arg));
   %let namenum=%sysfunc(varnum(&mydataid, src_table));
   %let nobs1=%sysfunc(attrn(&mydataid,NOBS));
   %do i = 1 %to &nobs1 ;
   %let rc=%sysfunc(fetchobs(&mydataid, &i));
   %let datasetname=%sysfunc(getvarc(&mydataid, &namenum));
		stg_lib.&datasetname 
   %end;
   %let rc=%sysfunc(close(&mydataid)); ;
      set WORK.STG_PRF_INVENTORY_FACT_part_sk ;
      %do iter=1 %to &num_parts_sk;
         %let tmp_part = %scan(&list_part_sk,&iter,%str( ));
         %let out_table = %sysfunc(cats(stg_lib.P_&tmp_part));
         %if &iter=1 %then %do;
            if part_sk eq &tmp_part then do;
               output &out_table;
            end;
         %end;
         %else %do;
          else if part_sk eq &tmp_part then do;
             output &out_table;
          end;
         %end;
      %end;
   drop part_sk;
   run;
   %end;
   %else %do;

   %let endTime = %sysfunc(datetime(),datetime.);

   %if &job_rc = 0 and &error_count = 0 %then
      %let jobstat_msg=%str(Job Successful);
   %else %if &job_rc le 4 or &error_count gt 0 %then
      %let jobstat_msg=%str(Job Ended with Data Exceptions or Warnings);
   %else %if &job_rc gt 4 %then
      %let jobstat_msg=%str(Job Ended with Errors);

   %put updating the job status table if there are no source table; 
   %di_util_lock(di_mon.job_status);
   proc sql noprint;
      insert into di_mon.job_status
               (USER,
               TABLE,
               LIB,
               JOBNAME,
               JOBSTAT,
               JOB_RC,
               RBEFORE,
               RAFTER,
               RSOURCE,
               RINEXCP,
               STTIME,
               ENDTIME)
            values(
               "&sysuserid" ,
               "PRF_INVENTORY_FACT" ,
               "DI_DM"  ,
               "&etls_jobName" ,
               "&jobstat_msg" ,
               &job_rc.,
               0,
               0,
               &stg_count. ,
               &error_count. ,
               "&load_startTime"dt ,
               "&endTime"dt );
   quit;
   %di_util_unlock(di_mon.job_status);
   %goto ERROREXIT;
   %end;

   %di_etl_rcset(error=&syscc,code=job_rc);

   /*============================================================================*
   * Using MPConnect macro to update FACT tables in parallel                    *
   *============================================================================*/

   %put calling mp_connect if there is valid source data;
   %if &job_rc le 4 %then %do;
    /* Call macro etl_exec_job to run ETL job in parallel*/
      %di_util_mp_connect(
         mac_name=di_etl_load_prf_inventory_fact ,
         arg_table=mp_conn_arg,
         nm_prll_exec=&num_parallel_executions
       );

      libname stg_lib  "&stg_lib_path";

   %end;
   %else %do;
      %put Updating the job status table if there are error thrown;
      %put job_rc=&job_rc;
      %put ERROR: Error while executing Load_STG2DM_Prf_inventory_fact;
      %let endTime = %sysfunc(datetime(),datetime.);

      proc sql noprint;
         insert into di_mon.job_status
              (USER,
               TABLE,
               LIB,
               JOBNAME,
               JOBSTAT,
               JOB_RC,
               RBEFORE,
               RAFTER,
               RSOURCE,
               RINEXCP,
               STTIME,
               ENDTIME)
            values(
               "&sysuserid" ,
               "PRF_INVENTORY_FACT" ,
               "DI_DM"  ,
               "&etls_jobName" ,
               "Job Ended with Errors" ,
               &job_rc.,
               . ,
               . ,
               &stg_count. ,
               0 ,
               "&load_startTime"dt ,
               "&endTime"dt );
      quit;
      %goto ERROREXIT;
   %end;

   %di_etl_rcset(error=&syscc,code=job_rc);

   /*============================================================================*
   *   UPDATE JOB STATUS                                                        *
   *============================================================================*/
   %let etls_lib = DI_DM;
   %let etls_table = PRF_INVENTORY_FACT;

   %let error_count_partioned=%di_util_nobs(stg_lib.PRF_INVENTORY_FACT_ERR);
   %let error_count=%eval(&error_count+&error_count_partioned);

   %put Meta Table Observations = &meta_table_obs;
   %put Appending to the main job status table from the status record of every partitions ; 
   /* Inserting job status record of every partition in di_mon.job_status */
   %di_util_lock(di_mon.job_status);
   proc sql noprint;
      insert into di_mon.job_status
        (USER,
         TABLE,
         LIB,
         JOBNAME,
         JOBSTAT,
         JOB_RC,
         RBEFORE,
         RAFTER,
         RSOURCE,
         RINEXCP,
         STTIME,
         ENDTIME)
      select
         USER as user,
         TABLE,
         LIB ,
         JOBNAME,
         JOBSTAT,
         JOB_RC,
         RBEFORE,
         RAFTER,
         RSOURCE,
         RINEXCP,
         STTIME,
         ENDTIME
      from stg_lib.job_status
      where JOBNAME="&etls_jobName"
      and STTIME ge "&load_startTime"dt;
   quit;

   %di_etl_rcset(error=&syscc,code=job_rc);


   Proc sql noprint;
      select max(max(JOB_RC),&job_rc) into :job_rc
      from stg_lib.job_status
      where JOBNAME="&etls_jobName"  and
      STTIME ge "&load_startTime"dt;
   quit;

   %di_etl_rcset(error=&syscc,code=job_rc);


   %if &job_rc = 0 and &error_count = 0 %then
      %let jobstat=%str(Job Successful);
   %else %if &job_rc le 4 or &error_count gt 0 %then
      %let jobstat=%str(Job Ended with Data Exceptions or Warnings);
   %else %if &job_rc gt 4 %then
      %let jobstat=%str(Job Ended with Errors);

   %let etls_endTime = %sysfunc(datetime(),datetime.);
   %put cummulative job status record for the whole prf inventory fact job;
   proc sql noprint;
      insert into di_mon.job_status
           (USER,
            TABLE,
            LIB,
            JOBNAME,
            JOBSTAT,
            JOB_RC,
            RBEFORE,
            RAFTER,
            RSOURCE,
            RINEXCP,
            STTIME,
            ENDTIME)
      select
            "&sysuserid" as user,
            TABLE,
            "DI_DM" as LIB ,
            JOBNAME,
            "&jobstat" as JOBSTAT,
            &job_rc as JOB_RC,
            sum(RBEFORE) as RBEFORE,
            sum(RAFTER) as RAFTER,
            &stg_count as RSOURCE,
            &error_count as RINEXCP,
            "&load_startTime"dt as STTIME,
            "&etls_endTime"dt as ENDTIME
      from stg_lib.job_status
      where JOBNAME="&etls_jobname"
      and STTIME ge "&load_startTime"dt
      group by TABLE, JOBNAME;
   quit;

   %di_util_unlock(di_mon.job_status);

   %ERROREXIT:
      %if %symexist(etls_jobName) and %symexist(load_startTime) %then %do;
         %di_util_lock(di_mon.job_status);
          data _null_;
             set di_mon.job_status;
             where jobname = "&etls_jobName";
             by jobname NOTSORTED;
             if sttime ge "&load_startTime"dt;
             put 'UNIT INFO: ' table '*** Records processed: ' rsource' Records rejected: ' rinexcp jobstat;
             if last.jobname then do;
                elapsetime = endtime - sttime;
                call symput('tot_units_processed',sum(input(symget('tot_units_processed'),32.),rsource));
                loadrate = floor(rsource/max(elapsetime,1));
                put 'UNIT INFO: Elapse Time: ' elapsetime's  Units: ' rsource 'Units/sec: ' loadrate;
             end;
          run;
          %di_util_unlock(di_mon.job_status);
       %end;

   %end;
   %di_etl_keep_work_table(PRF_INVENTORY_FACT_ERR STG_PRF_INVENTORY_FACT_part_sk);
   %mend di_etl_load_prf_inventory;

   %di_etl_load_prf_inventory;


/*============================================================================*
 *   LOAD PACK INVENTORY FACT                                                 *
 *============================================================================*/

/* Setup for capturing job status  */

%put Loading Pack Inventory fact data ;
%let etls_startTime = %sysfunc(datetime(),datetime.);
%let etls_recordsBefore = 0;
%let etls_recordsAfter = 0;
%let etls_lib = 0;
%let etls_table = 0;


%global g_curr_start_dt;


%macro load_pack_inventory;

%put Loading the pack inventory data only if the pack application is active; 
%if &g_szpk_active_app_flg eq 1 %then
%do;

   %put Pack prod_lvl=&g_szpk_prod_lvl;
   %put Pack geo_lvl=&g_szpk_geo_lvl;

   /* Identify the latest date from the stage data */
   %let current_date=;

   data _null_;
      call symput('current_date',put(today(),date9.));
   run;

/* Fetching the max inventory date of the stage data lesser than the processing date */
%put Fetching the max inventory date of the stage data lesser than the processing date;

   proc sql noprint;
      select max(INVENTORY_DT) format=date9.
             into :g_curr_start_dt
      from work.STG_PRF_INVENTORY_FACT_part_sk
      where INVENTORY_DT le "&current_date"d;
   quit;

   %put Current Week Start Date=&g_curr_start_dt;

   %if &g_curr_start_dt eq %str(.) or &sqlobs eq 0 %then
   %do;
      %put WARNING: No Data in Stage for current week;
   %end;

   %di_etl_rcset(error=&syscc,code=job_rc);


/*============================================================================*
 *   Extract the last max load date                                           *
 *   Last Load date is stored in a control table. This date is used to prevent*
 *   the loading of historical data into Pack inventory fact.                *
 *============================================================================*/

%put Extrating the last load date of Pack inventory date and storing it in a control table ;
   %let last_load_date=01JAN1960;

   %if %sysfunc(exist(di_mon.pack_control_table)) %then %do;
      proc sql noprint;
         select distinct(last_load_date) into :last_load_date from di_mon.pack_control_table;
      quit;
   %end;

   %di_etl_rcSet(error=&syscc,code=job_rc);

   %put last_load_date = &last_load_date.;

/*============================================================================*
 *   Extract current data                                                 *
 *============================================================================*/
   
   %put Extracting current data based on the last load date and max inventory date. ;
   proc datasets lib = work nolist nowarn memtype = (data view);
      delete tmp_stg_inv_pack_curr;
   quit;

   proc sql noprint;
      create table work.tmp_stg_inv_pack_curr as
      select
         PROD_HIER_SK,
         GEO_HIER_SK,
         INVENTORY_DT,
         CLOSE_INV_UNITS,
         DISPLAY_UNITS,
         0 as CLOSE_INV_VALUE_AT_RETAIL_AMT,
         0 as CLOSE_INV_VALUE_AT_COST_AMT
       from work.STG_PRF_INVENTORY_FACT_part_sk
       where INVENTORY_DT >= "&g_curr_start_dt"d AND INVENTORY_DT >= "&last_load_date"d
   ;
   quit;

   %di_etl_rcSet(error=&syscc,code=job_rc);

   %put refreshing the control table;
   %if %di_util_nobs(work.tmp_stg_inv_pack_curr) > 0 %then %do;
      proc sql noprint;
         create table di_mon.pack_control_table as
         select max(INVENTORY_DT) as last_load_date
                format = date9.
                informat = date9.
         from work.tmp_stg_inv_pack_curr;
      quit;
   %end;

   %di_etl_rcSet(error=&syscc,code=job_rc);

/*============================================================================*
 *   Sort and Remove duplicates                                                  *
 *============================================================================*/

   %put sorting and removing duplicates; 
   
   proc sort data = work.tmp_stg_inv_pack_curr
      out = work.stg_inv_pack_sorted;
      by
      GEO_HIER_SK
      PROD_HIER_SK
      INVENTORY_DT
   ;
   run;

    %di_etl_rcSet(error=&syscc,code=job_rc);

   data work.tmp_stg_inv_pack;
       set work.stg_inv_pack_sorted;
       by GEO_HIER_SK PROD_HIER_SK INVENTORY_DT;
       if last.INVENTORY_DT then
       output work.tmp_stg_inv_pack;
   run;

   %di_etl_keep_work_table(tmp_stg_inv_pack);

   /* Get number of records in table  */
   %let etls_recordsBefore = %di_util_nobs(DI_DM.PACK_INVENTORY_FACT);

   %let etls_table = %nrquote(PACK_INVENTORY_FACT);
   %let etls_lib   = %nrquote(DI_DM);

   %put Creating table if not present ;
   %if %eval(%sysfunc(exist(DI_DM.PACK_INVENTORY_FACT, DATA))) = 0 %then %do;

      %etl_create2(_SASSchemaFile=&etlp_ddl_path,
                _tableName=PACK_INVENTORY_FACT, _dataset=1, _constraints=1, _index=0,
                LIBREF=DI_DM,DTTMFMT=NLDATM21., DTFMT=DATE9.);
   %end;

   %put loading pack inventory data into the final fact table;
   data DI_DM.PACK_INVENTORY_FACT;
      set work.tmp_stg_inv_pack (rename=(CLOSE_INV_UNITS = etls_temp0));
      modify DI_DM.PACK_INVENTORY_FACT
            key = PRIM_KEY;
      if _iorc_ in( %sysrc(_DSENMR),%sysrc(_DSENOM),%sysrc(_DSEMTR)) or
         _iorc_ eq %sysrc(_SOK) then
      do;
	     CLOSE_INV_UNITS = etls_temp0;
         /* if the record exists in the master, then replace it  */
         if _iorc_ eq %sysrc(_SOK) then
            replace;
         /* if the record does not exist in the master, then add it  */
         else
            output;
      end;
      _iorc_ = 0;
      _error_ = 0;
   run;

   %di_etl_rcSet(error=&syscc,code=job_rc);

/* Get number of records in table  */
   %let etls_recordsAfter = %di_util_nobs(DI_DM.PACK_INVENTORY_FACT);
   %put etls_recordsAfter = &etls_recordsAfter.;

/**  Step end Load_pack_inventory_fact **/
   %let etls_endTime = %sysfunc(datetime(),datetime.);

/*---- Job status macro  ----*/
   
   %put updating job status table;
   %etls_sendJobStatus(source_table=DIDM_STG.STG_PRF_INVENTORY);


%end;
%mend load_pack_inventory;

%load_pack_inventory;

%macro clear_temp_dataset;
   %if "&etlp_delete_work_table" eq "Y" %then %do;

      %if %sysfunc(libref(stg_lib)) eq 0 %then %do;
         proc datasets lib=stg_lib
            nolist kill;
         quit;
      %end;
      proc datasets library = work kill nolist nowarn memtype=(data view);
      quit;
   %end;

%mend clear_temp_dataset;

%clear_temp_dataset;

 
