%macro apply_sas_data_model_changes(
m_di_trans_vendor=di_trans_vendor,    /* Database vendor */
m_di_trans=di_trans,                  /* libref for rdbms data mart library*/
m_di_data=di_data,                    /* libref for sas data mart library*/
m_di_mon=di_mon,                      /* libref for monitor library */
m_didm_stg=didm_stg,                  /* libref for stage library */
m_DTTMFMT=NLDATM21.,                  /* Date time format */
m_DTFMT=DATE9.,                       /* Date format */
m_stg_DTINFMT=NLDATE20.,              /* Date informat for stage tables */
m_experimental_changes=FALSE,         /* For developers only */
m_user=&sysuserid                     /* User Applying Change */
) / minoperator;
 
/* Use libref macro variable for legacy code */
%let libref=&m_di_data;
%let dtfmt=&m_DTFMT;
%let DTTMFMT=&m_DTTMFMT;
%let m_stg_DTINFMT=&m_stg_DTINFMT;
 
*Check if libref &m_di_data. is assigned;
%let didmExists = %sysfunc(libref(&m_di_data.));
 
%if not (&didmExists = 0) %then
%do;
%put ERROR: Library referenced by libref "&m_di_data." is not assigned.;
%put ERROR- Please assign the SAS library and rerun!;
%return;
%end;
 
 
*Convert old fixid table to new data_model_change_management table;
%*macro convert_fixid_table(m_di_data=di_data);
%let m_chgTable=data_model_change_management;
 
*  Create &m_chgTable table if it does not exist;
%if not %sysfunc(exist(&m_di_data..&m_chgTable)) %then
%do;
%put NOTE:  Table &m_di_data..&m_chgTable table does not exist.  Creating new!;
proc sql noprint;
create table &m_di_data..&m_chgTable
(
CHANGE_ID char(32),
CHANGE_DESC char(100),
DATE_CHANGE_APPLIED date format datetime18. informat datetime18.,
USER_APPLYING_CHANGE char(32)
);
 
alter table &m_di_data..&m_chgTable add CONSTRAINT PRIM_KEY PRIMARY KEY (change_id);
quit;
 
* Move data from fixid_applied table;
%if %sysfunc(exist(&m_di_data..fixid_applied)) %then
%do;
%put NOTE: Data from &m_di_data..fixid_applied will be moved to &m_chgTable.. ;
 
proc datasets library=&m_di_data. nolist ;
change fixid_applied=fixid_applied_old;
quit;
 
proc sql;
insert into &m_di_data..&m_chgTable
(CHANGE_ID, CHANGE_DESC, DATE_CHANGE_APPLIED, USER_APPLYING_CHANGE)
 
select fixid, "Changes applied in prior version",
DATE_APPLIED*24*60*60+(11*60*60+12*60+13), "Not known"
from  &m_di_data..FIXID_APPLIED_OLD
;
 
*drop table &m_di_data..FIXID_APPLIED_OLD;
 
quit;
 
%end;
%end;
 
run;
 
 
 
* Convert S0 to ID to disguise defect number;
data di_data.data_model_change_management;
set di_data.data_model_change_management;
 
if (substr(change_id,1,2)="S0") then do;
change_id="ID" || substr(change_id,3);
end;
run;
 
 
 
%*mend;
 
%*convert_fixid_table(m_di_data=di_data);
 
 
 
 
 
 
 
 
 
*Check baseline data model version;
%*macro check_baseline_dm_version(m_di_data=di_data);
%let m_baseline_dm_spec_name=BASELINE_DATA_MODEL_VERSION;
%let m_baseline_dm_spec_value=;
 
*  Code value in Global_setting if it does not exist;
%if not %sysfunc(exist(&m_di_data..global_setting)) %then
%do;
* quit if global_setting table is not present;
%return;
%end;
%else
%do;
 
proc sql noprint;
select spec_value
into :m_baseline_dm_spec_value
from &m_di_data..global_setting
where spec_nm="&m_baseline_dm_spec_name"
;
quit;
 
%put NOTE: The value of BASELINE_DATA_MODEL_VERSION global setting is &m_baseline_dm_spec_value.;
*If BASELINE_DATA_MODEL_VERSION is missing in global_setting table then quit;
%if (&m_baseline_dm_spec_value=) %then
%do;
%put ERROR: &m_di_data..global_setting table must have a spec_value for spec_nm=BASELINE_DATA_MODEL_VERSION and app=ALL.;
%put ERROR- Current valid values are F2TKMI43, M2TKMI43, M1TKMI43, D2TKMI42, M2MI42, F1MI42, M1MI42;
%let syscc=5000;
 
 
*------------------------------------------------------------------------------------------------------------------------;
 
%let column_chk =;
%let jparam_chk =;
%let purge_tbl_chk=;
%let etlp_units_fmt=;
%let _cnt_vend_attr = 0;
 
data _null_;
dsid=open("&m_didm_stg..STG_BUDGET");
call symput ("column_chk",varnum(dsid,"REVISED_BUDGET_AMT"));
rc=close(dsid);
run;
 
data _null_;
set &m_di_mon..JOB_PARAM (where=(upcase(jobname)="LOAD_STG2DM_PROMOTION_FACT"
and upcase(param_name)="ETLP_PRICE_HIST_WEEKS_KEEP"));
call symputx("jparam_chk", param_name);
run;
 
%if (%sysfunc(libref(DI_TRANS)) = 0) %then
%do;
data _null_;
set DI_TRANS.PURGE_QUERY (where=(upcase(table_nm)="CLEAN_ATTR_HIER_PROD" ));
call symputx("purge_tbl_chk", table_nm);
run;
%end;
 
data _null_;
set &m_di_mon..JOB_PARAM (where=(upcase(jobname)="DI_EXPORT_SALES_FORECAST"
and upcase(param_name)="ETLP_UNITS_FMT"));
call symputx("etlp_units_fmt", param_name);
run;
 
proc sql noprint;
select count(spec_nm) into :_cnt_vend_attr
from
&m_di_data..global_setting
where
upcase(spec_nm) = "VENDOR_ATTR"
;
quit;
 
%if %sysfunc(exist(&m_di_mon..JOB_STATUS_PARTITION)) %then
%do;
 
%if %upcase("&purge_tbl_chk") = "CLEAN_ATTR_HIER_PROD" %then
%do;
%let m_baseline_dm_spec_value=F2TKMI43;
%end;
%else %if %eval(&column_chk>0) %then
%do;
%let m_baseline_dm_spec_value=M2TKMI43;
%end;
%else %if %upcase("&jparam_chk") = "ETLP_PRICE_HIST_WEEKS_KEEP" %then
%do;
%let m_baseline_dm_spec_value=M1TKMI43;
%end;
%else
%do;
%let m_baseline_dm_spec_value=D2TKMI42;
%end;
%end;
%else %do;
%if %sysfunc(exist(&m_didm_stg..STG_RPP_PLAN_METRIC)) %then
%do;
%let m_baseline_dm_spec_value=M2MI42;
%end;
%else %if "&etlp_units_fmt" ne "" %then
%do;
%let m_baseline_dm_spec_value=F1MI42;
%end;
%else %if &_cnt_vend_attr > 0 %then
%do;
%let m_baseline_dm_spec_value=M1MI42;
%end;
%end;
 
*--------------------------------------------------------------------------------------------------------------------------;
 
%put NOTE:  Based on current state of schema BASELINE_DATA_MODEL_VERSION is &m_baseline_dm_spec_value;
%put NOTE-  This value is being inserted into global_setting table for spec_nm=BASELINE_DATA_MODEL_VERSION and app=ALL.;
%put NOTE-  Please ensure that this is correct and rerun.;
 
proc sql;
delete from &m_di_data..global_setting
where upper(spec_nm)="BASELINE_DATA_MODEL_VERSION"
and upper(app)="ALL";
 
insert into &m_di_data..global_setting
(spec_nm,app,spec_value,spec_desc)
values
("BASELINE_DATA_MODEL_VERSION","ALL","&m_baseline_dm_spec_value",
"Baseline (original) version of the data model before changes were applied")
;
quit;
 
%return;
%end;
%else
%do;
%let m_baseline_dm_spec_value=&m_baseline_dm_spec_value;
%put NOTE: BASELINE_DATA_MODEL_VERSION from di_data.global_setting table is &m_baseline_dm_spec_value;
%end;
 
%end;
 
run;
 
%*mend;
 
%*check_baseline_dm_version(m_di_data=di_data);
 
 
 
 
***********************************************************************************************;
************************************  Begin Change DATA_MODEL_VERSION_MGMT2 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: DATA_MODEL_VERSION_MGMT2;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("DATA_MODEL_VERSION_MGMT2")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%put NOTE: This change will be applied on every run.;
%put NOTE- Change ID :DATA_MODEL_VERSION_MGMT2;
 
 
data &m_di_data..DATA_MODEL_VERSION_MANAGEMENT;
attrib VERSION          length=$10  ;
attrib VERSION_INCLUDED length=$10  ;
 
VERSION='D2TKMI42'; VERSION_INCLUDED='D2TKMI42'; output;
 
VERSION='M1MI42';   VERSION_INCLUDED='M1MI42'; output;
 
VERSION='F1MI42';   VERSION_INCLUDED='F1MI42'; output;
VERSION='F1MI42';   VERSION_INCLUDED='M1MI42'; output;
 
VERSION='M2MI42';   VERSION_INCLUDED='M1MI42'; output;
VERSION='M2MI42';   VERSION_INCLUDED='F1MI42'; output;
VERSION='M2MI42';   VERSION_INCLUDED='M2MI42'; output;
 
VERSION='M1TKMI43'; VERSION_INCLUDED='M1TKMI43'; output;
VERSION='M1TKMI43'; VERSION_INCLUDED='D2TKMI42'; output;
 
VERSION='M2TKMI43'; VERSION_INCLUDED='M2TKMI43'; output;
VERSION='M2TKMI43'; VERSION_INCLUDED='M1TKMI43'; output;
VERSION='M2TKMI43'; VERSION_INCLUDED='D2TKMI42'; output;
 
VERSION='F2TKMI43'; VERSION_INCLUDED='F2TKMI43'; output;
VERSION='F2TKMI43'; VERSION_INCLUDED='M2TKMI43'; output;
VERSION='F2TKMI43'; VERSION_INCLUDED='M1TKMI43'; output;
VERSION='F2TKMI43'; VERSION_INCLUDED='D2TKMI42'; output;
run;
 
 
 
* Check for errors while processing CHANGE_ID: DATA_MODEL_VERSION_MGMT2;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: DATA_MODEL_VERSION_MGMT2;
%put ERROR- Description                              : Data model versions to enable migration from one version to another;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 24JUL2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: DATA_MODEL_VERSION_MGMT2;
proc sql;
insert  into di_data.data_model_change_management
values (
"DATA_MODEL_VERSION_MGMT2",
"Data model versions to enable migration from one version to another",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%DATA_MODEL_VERSION_MGMT2:;
 
 
* End of changes for CHANGE_ID:DATA_MODEL_VERSION_MGMT2;
 
 
***********************************************************************************************;
*************************************  End Change DATA_MODEL_VERSION_MGMT2 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change GET_DM_VERSIONS_FROM_BASE2 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: GET_DM_VERSIONS_FROM_BASE2;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("GET_DM_VERSIONS_FROM_BASE2")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%put NOTE: This change will be applied on every run.;
%put NOTE- Change ID :GET_DM_VERSIONS_FROM_BASE2;
 
 
 
 
proc sql noprint;
select version_included into :m_baseline_versions
separated by ","
from &m_di_data..DATA_MODEL_VERSION_MANAGEMENT
where version="&m_baseline_dm_spec_value"
;
 
quit;
 
%put NOTE: Baseline Version from global settings table is &m_baseline_dm_spec_value;
%put NOTE: This baseline version includes changes in tracks: &m_baseline_versions;
 
 
 
 
* Check for errors while processing CHANGE_ID: GET_DM_VERSIONS_FROM_BASE2;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: GET_DM_VERSIONS_FROM_BASE2;
%put ERROR- Description                              : Data model versions to enable migration from one version to another;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 24JUL2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: GET_DM_VERSIONS_FROM_BASE2;
proc sql;
insert  into di_data.data_model_change_management
values (
"GET_DM_VERSIONS_FROM_BASE2",
"Data model versions to enable migration from one version to another",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%GET_DM_VERSIONS_FROM_BASE2:;
 
 
* End of changes for CHANGE_ID:GET_DM_VERSIONS_FROM_BASE2;
 
 
***********************************************************************************************;
*************************************  End Change GET_DM_VERSIONS_FROM_BASE2 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change RENAME_RDM_TO_rdm ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: RENAME_RDM_TO_rdm;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("RENAME_RDM_TO_rdm")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : RENAME_RDM_TO_rdm;
%goto RENAME_RDM_TO_rdm;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : RENAME_RDM_TO_rdm;
* Insert record into change management table for CHANGE_ID: RENAME_RDM_TO_rdm;
proc sql;
insert  into di_data.data_model_change_management
values (
"RENAME_RDM_TO_rdm",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto RENAME_RDM_TO_rdm;
 
%end;
 
 
 
 
 
%let parentdir=%di_util_first_libpath(&m_di_data);
 
%let moveFromSubdir=RDM;
%let moveToSubdir=rdm;
 
%if "&sysscp"="WIN" %then
%do;
%let m_sepchar=\;
%let m_movecmd=move;
options noxwait;
%end;
 
%else
%do;
%let m_sepchar=/;
%let m_movecmd=mv;
 
%if %sysfunc(fileexist(%quote(&parentdir&m_sepchar.&moveFromSubdir))) %then
%do;
%put NOTE: Moving &parentdir&m_sepchar.&moveFromSubdir to &parentdir&m_sepchar.&moveToSubdir ;
X "&m_movecmd &parentdir&m_sepchar.&moveFromSubdir &parentdir&m_sepchar.&moveToSubdir" ;
%end;
 
 
%end;
 
 
 
* Check for errors while processing CHANGE_ID: RENAME_RDM_TO_rdm;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: RENAME_RDM_TO_rdm;
%put ERROR- Description                              : Rename RDM folder to rdm;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 09SEP2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: RENAME_RDM_TO_rdm;
proc sql;
insert  into di_data.data_model_change_management
values (
"RENAME_RDM_TO_rdm",
"Rename RDM folder to rdm",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%RENAME_RDM_TO_rdm:;
 
 
* End of changes for CHANGE_ID:RENAME_RDM_TO_rdm;
 
 
***********************************************************************************************;
*************************************  End Change RENAME_RDM_TO_rdm ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change STARTUP_FOLDERS_CREATE ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: STARTUP_FOLDERS_CREATE;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("STARTUP_FOLDERS_CREATE")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%put NOTE: This change will be applied on every run.;
%put NOTE- Change ID :STARTUP_FOLDERS_CREATE;
 
 
%create_startup_folders(%di_util_first_libpath(&m_di_data));
 
 
 
* Check for errors while processing CHANGE_ID: STARTUP_FOLDERS_CREATE;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: STARTUP_FOLDERS_CREATE;
%put ERROR- Description                              : Create required folders in di_data;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 09SEP2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: STARTUP_FOLDERS_CREATE;
proc sql;
insert  into di_data.data_model_change_management
values (
"STARTUP_FOLDERS_CREATE",
"Create required folders in di_data",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%STARTUP_FOLDERS_CREATE:;
 
 
* End of changes for CHANGE_ID:STARTUP_FOLDERS_CREATE;
 
 
***********************************************************************************************;
*************************************  End Change STARTUP_FOLDERS_CREATE ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change CHK_DUPS_IN_JOB_PARAM_SYS_PARAM ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: CHK_DUPS_IN_JOB_PARAM_SYS_PARAM;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("CHK_DUPS_IN_JOB_PARAM_SYS_PARAM")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(&m_di_mon)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_di_mon;
%put NOTE- Change ID                             :CHK_DUPS_IN_JOB_PARAM_SYS_PARAM;
%goto CHK_DUPS_IN_JOB_PARAM_SYS_PARAM;
 
%end;
%if not (%sysfunc(exist(&m_di_mon..job_param))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_mon..job_param;
%put NOTE- Change ID                             :CHK_DUPS_IN_JOB_PARAM_SYS_PARAM;
%goto CHK_DUPS_IN_JOB_PARAM_SYS_PARAM;
 
%end;
%if not (%sysfunc(exist(&m_di_mon..etl_sys_param))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_mon..etl_sys_param;
%put NOTE- Change ID                             :CHK_DUPS_IN_JOB_PARAM_SYS_PARAM;
%goto CHK_DUPS_IN_JOB_PARAM_SYS_PARAM;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : CHK_DUPS_IN_JOB_PARAM_SYS_PARAM;
%goto CHK_DUPS_IN_JOB_PARAM_SYS_PARAM;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : CHK_DUPS_IN_JOB_PARAM_SYS_PARAM;
* Insert record into change management table for CHANGE_ID: CHK_DUPS_IN_JOB_PARAM_SYS_PARAM;
proc sql;
insert  into di_data.data_model_change_management
values (
"CHK_DUPS_IN_JOB_PARAM_SYS_PARAM",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto CHK_DUPS_IN_JOB_PARAM_SYS_PARAM;
 
%end;
 
 
 
 
 
 
proc sql;
update &m_di_mon..job_param     set jobname = upcase(jobname);
quit;
 
%if &syscc >= 5 %then %do;
%put ERROR: There are duplicate entries in job_param table. Please delete duplicates.;
 
proc sql;
create table work.job_param_dups as
select upcase(jobname) as jobname, param_name, param_value, default_func
from di_mon.job_param
group by upcase(jobname), param_name
having count(*) > 1;
quit;
 
%put NOTE: Duplicate entries in job_param table. Please remove duplicates.;
%put NOTE- Duplicate most likely because of mixed case;
 
data _null_;
set work.job_param_dups end=last;
if _N_=1 then do;
put "NOTE: The following is a list of duplicate rows.  Delete duplicates.";
put "NOTE- ---------------------------------------------------------------------";
end;
put 'jobname=' jobname  'param_name=' param_name 'param_value=' param_value;
if last then do;
put "NOTE- ---------------------------------------------------------------------";
put ;
end;
run;
 
%end;
 
proc sql;
update &m_di_mon..etl_sys_param set jobname = upcase(jobname);
quit;
 
%if &syscc >= 5 %then %do;
%put ERROR: There are duplicate entries in etl_sys_param table. Please delete duplicates.;
 
proc sql;
create table work.etl_sys_param_dups as
select upcase(jobname) as jobname, param_name, param_value, default_func
from di_mon.etl_sys_param
group by upcase(jobname), param_name
having count(*) > 1;
quit;
 
%put NOTE: Duplicate entries in etl_sys_param table. Please remove duplicates.;
%put NOTE- Duplicate most likely because of mixed case;
 
data _null_;
set work.etl_sys_param_dups end=last;
if _N_=1 then do;
put "NOTE: The following is a list of duplicate rows.  Delete duplicates.";
put "NOTE- ---------------------------------------------------------------------";
end;
 
put 'jobname=' jobname  'param_name=' param_name 'param_value=' param_value;
if last then do;
put "NOTE- ---------------------------------------------------------------------";
put ;
end;
run;
 
%end;
 
 
 
 
 
* Check for errors while processing CHANGE_ID: CHK_DUPS_IN_JOB_PARAM_SYS_PARAM;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: CHK_DUPS_IN_JOB_PARAM_SYS_PARAM;
%put ERROR- Description                              : Change jobname to upcase in job_param and etl_sys_param table;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 01APR2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: CHK_DUPS_IN_JOB_PARAM_SYS_PARAM;
proc sql;
insert  into di_data.data_model_change_management
values (
"CHK_DUPS_IN_JOB_PARAM_SYS_PARAM",
"Change jobname to upcase in job_param and etl_sys_param table",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%CHK_DUPS_IN_JOB_PARAM_SYS_PARAM:;
 
 
* End of changes for CHANGE_ID:CHK_DUPS_IN_JOB_PARAM_SYS_PARAM;
 
 
***********************************************************************************************;
*************************************  End Change CHK_DUPS_IN_JOB_PARAM_SYS_PARAM ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ADD_MON_TABLES_FOR_M1MI42 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ADD_MON_TABLES_FOR_M1MI42;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ADD_MON_TABLES_FOR_M1MI42")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ADD_MON_TABLES_FOR_M1MI42;
%goto ADD_MON_TABLES_FOR_M1MI42;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D2TKMI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ADD_MON_TABLES_FOR_M1MI42;
* Insert record into change management table for CHANGE_ID: ADD_MON_TABLES_FOR_M1MI42;
proc sql;
insert  into di_data.data_model_change_management
values (
"ADD_MON_TABLES_FOR_M1MI42",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ADD_MON_TABLES_FOR_M1MI42;
 
%end;
 
 
 
 
 
%macro add_mon_tables_for_m1mi42;
 
data &m_di_mon..INV_CONTROL_TEMP;
attrib DIST_DATE_SK length= 4 label ='Distinct Date sk';
stop;run;
 
data &m_di_mon..SALES_CONTROL_TEMP;
attrib DIST_DATE_SK length= 4 label ='Distinct Date sk';
stop;run;
 
proc sql;
alter table &m_di_mon..STG_DIMENSION_LEVELS_X
modify ETLS_EXCEPTION_COND char(450) ;
quit;
 
%mend;
 
%add_mon_tables_for_m1mi42;
 
 
 
* Check for errors while processing CHANGE_ID: ADD_MON_TABLES_FOR_M1MI42;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ADD_MON_TABLES_FOR_M1MI42;
%put ERROR- Description                              : Tables that were added in 43;
%put ERROR- Version                                  : D2TKMI42;
%put ERROR- Date of Change                           : 29JUL2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ADD_MON_TABLES_FOR_M1MI42;
proc sql;
insert  into di_data.data_model_change_management
values (
"ADD_MON_TABLES_FOR_M1MI42",
"Tables that were added in 43",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ADD_MON_TABLES_FOR_M1MI42:;
 
 
* End of changes for CHANGE_ID:ADD_MON_TABLES_FOR_M1MI42;
 
 
***********************************************************************************************;
*************************************  End Change ADD_MON_TABLES_FOR_M1MI42 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID697407_2 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID697407_2;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID697407_2")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID697407_2;
%goto ID697407_2;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(M1MI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID697407_2;
* Insert record into change management table for CHANGE_ID: ID697407_2;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID697407_2",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID697407_2;
 
%end;
 
 
 
 
 
 
proc sql;
 
/* Next two lines are repeated on purpose to take care of some test environments */
*DELETE from &m_di_data..FA_SPEC where SPEC_NM = 'SEASON_TYPE_PERCENT';
*INSERT INTO &m_di_data..FA_SPEC (MODEL_GROUP_ID, SPEC_NM, SPEC_VALUE) VALUES (-1,'SEASON_TYPE_PERCENT','75');
 
 
DELETE FROM &m_di_data..GLOBAL_SETTING
WHERE SPEC_NM ='PACK_INCLUDE_SKU_THRESHOLD' and APP = 'SZPK';
 
INSERT INTO &m_di_data..GLOBAL_SETTING (SPEC_NM,APP,SPEC_VALUE,SPEC_DESC)
VALUES ('PACK_INCLUDE_SKU_THRESHOLD','SZPK','0.5',
'Specifies the threshold value to use when deciding whether a SKU can be excluded from a pack.');
 
 
DELETE FROM &m_di_data..GLOBAL_SETTING
WHERE SPEC_NM ='VENDOR_ATTR' and APP = 'SZPK';
 
INSERT INTO &m_di_data..GLOBAL_SETTING (SPEC_NM,APP,SPEC_VALUE,SPEC_DESC) VALUES
('VENDOR_ATTR','SZPK','SKU_VENDOR',
'Specifies the name of the custom product attribute for vendor.');
 
 
DELETE FROM &m_di_data..MODEL_SPEC_DEFAULT
WHERE SPEC_NM ='MULTIPLE_MARKDOWNS' and MODEL_COMP_NM='ALL';
 
INSERT INTO &m_di_data..MODEL_SPEC_DEFAULT
(SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES
('MULTIPLE_MARKDOWNS','ALL','-1','1',NULL);
 
 
 
/* vehicle_support_map should be populated by an expert from estimation team.  These sample entries from past being removed */
DELETE FROM &m_di_data..vehicle_support_map where vehicle_support_map_sk=1  and support_nm='PRICE';
DELETE FROM &m_di_data..vehicle_support_map where vehicle_support_map_sk=2  and support_nm='PS_1';
DELETE FROM &m_di_data..vehicle_support_map where vehicle_support_map_sk=3  and support_nm='PS_2';
DELETE FROM &m_di_data..vehicle_support_map where vehicle_support_map_sk=4  and support_nm='PS_3';
DELETE FROM &m_di_data..vehicle_support_map where vehicle_support_map_sk=19 and support_nm='DISCOUNT';
 
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID697407_2;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID697407_2;
%put ERROR- Description                              : Change from the past;
%put ERROR- Version                                  : M1MI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID697407_2;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID697407_2",
"Change from the past",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID697407_2:;
 
 
* End of changes for CHANGE_ID:ID697407_2;
 
 
***********************************************************************************************;
*************************************  End Change ID697407_2 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID0000A ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID0000A;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID0000A")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID0000A;
%goto ID0000A;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D2TKMI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID0000A;
* Insert record into change management table for CHANGE_ID: ID0000A;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID0000A",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID0000A;
 
%end;
 
 
 
 
 
***********************************************************************************************;
 
data &m_di_data..SALES_FACT;
attrib GEO_HIER_SK                         length=4                                            ;
attrib PROD_HIER_SK                        length=6                                            ;
attrib DATE_SK                             length=4                                            ;
attrib SALES_UNITS                         length=8      FORMAT=NLNUM12.2   INFORMAT=NLNUM12.2 ;
attrib SALES_AMT                           length=8      FORMAT=NLNUM20.3   INFORMAT=NLNUM20.3 ;
stop; run;
 
proc sql noprint;
alter table &m_di_data..SALES_FACT add CONSTRAINT PRIM_KEY PRIMARY KEY (GEO_HIER_SK, PROD_HIER_SK, DATE_SK);
quit;
 
 
***********************************************************************************************;
 
data &m_di_data..INVENTORY_FACT;
attrib GEO_HIER_SK                         length=4                                            ;
attrib PROD_HIER_SK                        length=6                                            ;
attrib DATE_SK                             length=4                                            ;
attrib CLOSE_INV_VALUE_AT_RETAIL_AMT       length=8      FORMAT=NLNUM20.3   INFORMAT=NLNUM20.3 ;
attrib CLOSE_INV_VALUE_AT_COST_AMT         length=8      FORMAT=NLNUM20.3   INFORMAT=NLNUM20.3 ;
attrib CLOSE_INV_UNITS                     length=8      FORMAT=NLNUM12.2   INFORMAT=NLNUM12.2 ;
stop; run;
 
proc sql noprint;
alter table &m_di_data..INVENTORY_FACT add CONSTRAINT PRIM_KEY PRIMARY KEY (GEO_HIER_SK, PROD_HIER_SK, DATE_SK);
quit;
 
 
***********************************************************************************************;
 
 
 
* Check for errors while processing CHANGE_ID: ID0000A;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID0000A;
%put ERROR- Description                              : Change from the past;
%put ERROR- Version                                  : D2TKMI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID0000A;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID0000A",
"Change from the past",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID0000A:;
 
 
* End of changes for CHANGE_ID:ID0000A;
 
 
***********************************************************************************************;
*************************************  End Change ID0000A ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID0000D ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID0000D;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID0000D")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID0000D;
%goto ID0000D;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D2TKMI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID0000D;
* Insert record into change management table for CHANGE_ID: ID0000D;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID0000D",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID0000D;
 
%end;
 
 
 
 
/*
28Jan2010 vekada   Added ANALYTICAL_PROD_PARTITION_LVL and PLANNING_PROD_PARTITION_LVL (a2mi52 track)
28Jan2010 vekada   Added ETL_WEBSERVICE_URL and ETL_WEBSERVICE_AUTHDOMAIN (a2mi52 track)
*/
proc sql noprint;
/* ETL  */
DELETE FROM &m_di_data..global_setting WHERE SPEC_NM IN ('ANALYTICAL_PROD_PARTITION_LVL', 'PLANNING_PROD_PARTITION_LVL');
DELETE FROM &m_di_data..global_setting WHERE SPEC_NM IN ('ETL_WEBSERVICE_URL', 'ETL_WEBSERVICE_AUTHDOMAIN');
 
INSERT INTO &m_di_data..global_setting (SPEC_NM,APP,SPEC_VALUE,SPEC_DESC)
VALUES  ('ANALYTICAL_PROD_PARTITION_LVL','ALL','','Analytical product partition level');
 
INSERT INTO &m_di_data..global_setting (SPEC_NM,APP,SPEC_VALUE,SPEC_DESC)
VALUES  ('PLANNING_PROD_PARTITION_LVL','ALL','','Planning product partition level');
 
INSERT INTO &m_di_data..global_setting (SPEC_NM,APP,SPEC_VALUE,SPEC_DESC)
VALUES  ('ETL_WEBSERVICE_URL','ALL','http://midtierserver:1444/miserver/services/DataService',
'URL where a Webservice that ETL needs to call for partitioning resides');
 
INSERT INTO &m_di_data..global_setting (SPEC_NM,APP,SPEC_VALUE,SPEC_DESC)
VALUES  ('ETL_WEBSERVICE_AUTHDOMAIN','ALL','DefaultAuth','Authentication domain for calling ETL Webservice');
 
 
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID0000D;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID0000D;
%put ERROR- Description                              : Change from the past;
%put ERROR- Version                                  : D2TKMI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID0000D;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID0000D",
"Change from the past",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID0000D:;
 
 
* End of changes for CHANGE_ID:ID0000D;
 
 
***********************************************************************************************;
*************************************  End Change ID0000D ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change MHA_CD ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: MHA_CD;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("MHA_CD")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : MHA_CD;
%goto MHA_CD;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D2TKMI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : MHA_CD;
* Insert record into change management table for CHANGE_ID: MHA_CD;
proc sql;
insert  into di_data.data_model_change_management
values (
"MHA_CD",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto MHA_CD;
 
%end;
 
 
 
 
 
proc sql noprint;
select spec_value into :geo_hier_type  from &m_di_data..global_setting where spec_nm = "GEO_HIER_TYPE";
select spec_value into :prod_hier_type from &m_di_data..global_setting where spec_nm = "PROD_HIER_TYPE";
quit;
 
%if (not %symexist(geo_hier_type)) %then
%let geo_hier_type =1;
 
%if %length(&geo_hier_type) = 0 %then
%let geo_hier_type =1;
 
%if (not %symexist(prod_hier_type)) %then
%let prod_hier_type =1;
 
%if %length(&prod_hier_type) = 0 %then
%let prod_hier_type =1;
 
proc sql noprint;
update &m_di_data..global_setting
set spec_value = %if %eval(&geo_hier_type) = 2 %then "0"; %else "1";
where spec_nm = "MODEL_GEO_HIER_ASSOC_CD";
quit;
 
 
proc sql noprint;
update &m_di_data..global_setting
set spec_value = %if %eval(&prod_hier_type) = 2 %then "0"; %else "1";
where spec_nm = "MODEL_PROD_HIER_ASSOC_CD";
quit;
 
 
 
 
* Check for errors while processing CHANGE_ID: MHA_CD;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: MHA_CD;
%put ERROR- Description                              : Change from the past;
%put ERROR- Version                                  : D2TKMI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: MHA_CD;
proc sql;
insert  into di_data.data_model_change_management
values (
"MHA_CD",
"Change from the past",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%MHA_CD:;
 
 
* End of changes for CHANGE_ID:MHA_CD;
 
 
***********************************************************************************************;
*************************************  End Change MHA_CD ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change P_WS_GS ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: P_WS_GS;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("P_WS_GS")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : P_WS_GS;
%goto P_WS_GS;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D2TKMI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : P_WS_GS;
* Insert record into change management table for CHANGE_ID: P_WS_GS;
proc sql;
insert  into di_data.data_model_change_management
values (
"P_WS_GS",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto P_WS_GS;
 
%end;
 
 
 
 
 
proc sql noprint;
DELETE from &m_di_data..global_setting where
SPEC_NM in ('ANALYTICAL_PROD_PARTITION_LVL', 'PLANNING_PROD_PARTITION_LVL', 'ETL_WEBSERVICE_URL', 'ETL_WEBSERVICE_AUTHDOMAIN');
INSERT INTO &m_di_data..global_setting (SPEC_NM,APP,SPEC_VALUE,SPEC_DESC) VALUES
('ANALYTICAL_PROD_PARTITION_LVL','ALL',NULL,'Analytical product partition level');
INSERT INTO &m_di_data..global_setting (SPEC_NM,APP,SPEC_VALUE,SPEC_DESC)
VALUES ('PLANNING_PROD_PARTITION_LVL','ALL',NULL,'Planning product partition level');
INSERT INTO &m_di_data..global_setting (SPEC_NM,APP,SPEC_VALUE,SPEC_DESC)
VALUES ('ETL_WEBSERVICE_URL','ALL','http://midtierserver:1444/miserver/services/DataService','ETL Webservice URL');
INSERT INTO &m_di_data..global_setting (SPEC_NM,APP,SPEC_VALUE,SPEC_DESC)
VALUES ('ETL_WEBSERVICE_AUTHDOMAIN','ALL','SOAPAuthDomain','Webservice Authentication Domain');
quit;
 
 
 
* Check for errors while processing CHANGE_ID: P_WS_GS;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: P_WS_GS;
%put ERROR- Description                              : Change from the past;
%put ERROR- Version                                  : D2TKMI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: P_WS_GS;
proc sql;
insert  into di_data.data_model_change_management
values (
"P_WS_GS",
"Change from the past",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%P_WS_GS:;
 
 
* End of changes for CHANGE_ID:P_WS_GS;
 
 
***********************************************************************************************;
*************************************  End Change P_WS_GS ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change DROP_ALERT ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: DROP_ALERT;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("DROP_ALERT")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : DROP_ALERT;
%goto DROP_ALERT;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D2TKMI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : DROP_ALERT;
* Insert record into change management table for CHANGE_ID: DROP_ALERT;
proc sql;
insert  into di_data.data_model_change_management
values (
"DROP_ALERT",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto DROP_ALERT;
 
%end;
 
 
 
 
 
proc sql noprint;
drop table &m_di_data..FA_ALERT                     ;
drop table &m_di_data..FA_ALERT_STATUS              ;
drop table &m_di_data..FA_MODEL_GROUP               ;
drop table &m_di_data..FA_MONITORING_FILTER_PROD_GEO;
drop table &m_di_data..FA_MONITORING_GEO            ;
drop table &m_di_data..FA_MONITORING_PROD           ;
drop table &m_di_data..FA_PRESEASON_FILTER_PROD_GEO ;
drop table &m_di_data..FA_PRESEASON_FILTER_PROD_GEO ;
drop table &m_di_data..FA_PRESEASON_GEO             ;
drop table &m_di_data..FA_PRESEASON_PROD            ;
drop table &m_di_data..FA_SCENARIO                  ;
drop table &m_di_data..FA_SCENARIO_SPEC             ;
drop table &m_di_data..FA_SCENARIO_STATUS           ;
drop table &m_di_data..FA_SCORE                     ;
drop table &m_di_data..FA_SPEC                      ;
quit;
 
 
 
* Check for errors while processing CHANGE_ID: DROP_ALERT;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: DROP_ALERT;
%put ERROR- Description                              : Change from the past;
%put ERROR- Version                                  : D2TKMI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: DROP_ALERT;
proc sql;
insert  into di_data.data_model_change_management
values (
"DROP_ALERT",
"Change from the past",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%DROP_ALERT:;
 
 
* End of changes for CHANGE_ID:DROP_ALERT;
 
 
***********************************************************************************************;
*************************************  End Change DROP_ALERT ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change GS_PLAN_CS ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: GS_PLAN_CS;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("GS_PLAN_CS")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : GS_PLAN_CS;
%goto GS_PLAN_CS;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D2TKMI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : GS_PLAN_CS;
* Insert record into change management table for CHANGE_ID: GS_PLAN_CS;
proc sql;
insert  into di_data.data_model_change_management
values (
"GS_PLAN_CS",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto GS_PLAN_CS;
 
%end;
 
 
 
 
 
proc sql noprint;
update &m_di_data..GLOBAL_SETTING set SPEC_VALUE = "1000"
where SPEC_NM = "PARALLEL_PLAN_MEM_CHUNK_SIZE";
quit;
 
 
 
* Check for errors while processing CHANGE_ID: GS_PLAN_CS;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: GS_PLAN_CS;
%put ERROR- Description                              : Change from the past;
%put ERROR- Version                                  : D2TKMI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: GS_PLAN_CS;
proc sql;
insert  into di_data.data_model_change_management
values (
"GS_PLAN_CS",
"Change from the past",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%GS_PLAN_CS:;
 
 
* End of changes for CHANGE_ID:GS_PLAN_CS;
 
 
***********************************************************************************************;
*************************************  End Change GS_PLAN_CS ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID660016 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID660016;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID660016")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID660016;
%goto ID660016;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D2TKMI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID660016;
* Insert record into change management table for CHANGE_ID: ID660016;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID660016",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID660016;
 
%end;
 
 
 
 
/*
28Jan2010 vekada   Remove ANALYTICAL_PROD_PARTITION_LVL and PLANNING_PROD_PARTITION_LVL
Make this changes before removing constants
PROD_PARTITION_LVL=PLANNING_PROD_PARTITION_LVL
and
PARALLEL_PROD_LVL=PLANNING_PROD_PARTITION_LVL
 
*/
 
 
%local  m_planning_ppl  m_analytical_ppl  m_prod_partition_lvl m_parallel_prod_lvl;
proc sql noprint;
 
select spec_value into :m_planning_ppl
from &m_di_data..global_setting
where SPEC_NM="PLANNING_PROD_PARTITION_LVL"
 
;
 
select spec_value into :m_analytical_ppl
from &m_di_data..global_setting
where SPEC_NM="ANALYTICAL_PROD_PARTITION_LVL"
 
;
 
select spec_value into :m_prod_partition_lvl
from &m_di_data..global_setting
where SPEC_NM="PROD_PARTITION_LVL"
 
;
 
select spec_value into :m_parallel_prod_lvl
from &m_di_data..global_setting
where SPEC_NM="PARALLEL_PROD_LVL"
 
;
 
quit;
 
%let m_planning_ppl       = &m_planning_ppl ;
%let m_analytical_ppl     = &m_analytical_ppl ;
%let m_prod_partition_lvl = &m_prod_partition_lvl ;
%let m_parallel_prod_lvl  = &m_parallel_prod_lvl ;
 
/* Change prod_partition_lvl to planning_prod_partition_lvl */
%if ( "&m_planning_ppl"="" ) %then
%do;
%put NOTE: There is no value in global setting for PLANNING_PROD_PARTITION_LVL;
%put NOTE- The global setting for PROD_PARTION_LVL will remain unchanged as "&m_prod_partition_lvl".;
%end;
%else
%do;
%if ("&m_prod_partition_lvl"="") %then
%do;
proc sql noprint;
update &m_di_data..global_setting
set spec_value="&m_planning_ppl"
where spec_nm="PROD_PARTITION_LVL"
;
 
quit;
 
%put NOTE: The global setting for PROD_PARTION_LVL changed from "&m_prod_partition_lvl" to "&m_planning_ppl".;
 
%end;
%else %if (%eval(&m_prod_partition_lvl) < %eval(&m_planning_ppl)) %then
%do;
proc sql noprint;
update &m_di_data..global_setting
set spec_value="&m_planning_ppl"
where spec_nm="PROD_PARTITION_LVL"
;
 
quit;
 
%put NOTE: The global setting for PROD_PARTION_LVL changed from "&m_prod_partition_lvl" to "&m_planning_ppl".;
 
%end;
%else %do;
%put NOTE: The global setting for PROD_PARTION_LVL will remain unchanged as "&m_prod_partition_lvl".;
%end;
%end;
 
/* Change parallel_prod_lvl to analytical_prod_partition_lvl */
%if ( "&m_analytical_ppl"="" ) %then
%do;
%put NOTE: There is no value in global setting for ANALYTICAL_PROD_PARTITION_LVL;
%put NOTE- The global setting for PARALLEL_PROD_LVL will remain unchanged as "&m_parallel_prod_lvl".;
%end;
%else
%do;
%if ("&m_parallel_prod_lvl"="") %then
%do;
proc sql noprint;
update &m_di_data..global_setting
set spec_value="&m_planning_ppl"
where spec_nm="PARALLEL_PROD_LVL"
;
quit;
%put NOTE: The global setting for PARALLEL_PROD_LVL changed from "&m_parallel_prod_lvl" to "&m_planning_ppl".;
 
%end;
/* if m_parallel_prod_lvl has some value then check this condition */
%else %if (%eval(&m_parallel_prod_lvl) < %eval(&m_planning_ppl)) %then
%do;
proc sql noprint;
update &m_di_data..global_setting
set spec_value="&m_planning_ppl"
where spec_nm="PARALLEL_PROD_LVL"
;
quit;
%put NOTE: The global setting for PARALLEL_PROD_LVL changed from "&m_parallel_prod_lvl" to "&m_planning_ppl".;
 
%end;
 
%else %do;
%put NOTE: The global setting for PARALLEL_PROD_LVL will remain unchanged as "&m_parallel_prod_lvl".;
%end;
%end;
 
/* Delete 2 constants from global setting table */
proc sql noprint;
 
DELETE FROM &m_di_data..global_setting WHERE SPEC_NM IN ('ANALYTICAL_PROD_PARTITION_LVL', 'PLANNING_PROD_PARTITION_LVL');
 
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID660016;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID660016;
%put ERROR- Description                              : Change from the past;
%put ERROR- Version                                  : D2TKMI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID660016;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID660016",
"Change from the past",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID660016:;
 
 
* End of changes for CHANGE_ID:ID660016;
 
 
***********************************************************************************************;
*************************************  End Change ID660016 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID660016_2 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID660016_2;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID660016_2")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID660016_2;
%goto ID660016_2;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D2TKMI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID660016_2;
* Insert record into change management table for CHANGE_ID: ID660016_2;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID660016_2",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID660016_2;
 
%end;
 
 
 
 
 
 
 
%local  m_planning_ppl  m_analytical_ppl  m_prod_partition_lvl m_parallel_prod_lvl;
proc sql noprint;
 
 
select spec_value into :m_prod_partition_lvl
from &m_di_data..global_setting
where SPEC_NM="PROD_PARTITION_LVL"
 
;
 
select spec_value into :m_parallel_prod_lvl
from &m_di_data..global_setting
where SPEC_NM="PARALLEL_PROD_LVL"
 
;
 
select count(*) into :m_prod_partition_lvl_cnt
from &m_di_data..global_setting
where SPEC_NM="PROD_PARTITION_LVL"
 
;
 
select count(*) into :m_parallel_prod_lvl_cnt
from &m_di_data..global_setting
where SPEC_NM="PARALLEL_PROD_LVL"
 
;
 
quit;
 
/* Give a value of 2 to PROD_PARTITION_LVL if there is no value */
%if ( &m_prod_partition_lvl_cnt<1) %then %do;
proc sql noprint;
INSERT INTO &m_di_data..global_setting (SPEC_NM,APP,SPEC_VALUE,SPEC_DESC)
VALUES  ('PROD_PARTITION_LVL','ALL','2','Specifies the level in the product hierarchy that is used to partition data in the data mart.');
quit;
%end;
 
 
/* Give a value of 2 to PARALLEL_PROD_LVL if there is no entry */
%if ( &m_parallel_prod_lvl_cnt<1) %then %do;
proc sql noprint;
INSERT INTO &m_di_data..global_setting (SPEC_NM,APP,SPEC_VALUE,SPEC_DESC)
VALUES  ('PARALLEL_PROD_LVL','ALL','2','Specifies the level in the product hierarchy for parallel processing.');
quit;
%end;
 
 
%let m_parallel_prod_lvl=&m_parallel_prod_lvl;
%let m_prod_partition_lvl = &m_prod_partition_lvl ;
%put m_parallel_prod_lvl=&m_parallel_prod_lvl;
%put m_prod_partition_lvl = &m_prod_partition_lvl ;
 
/* Give a value of 0 to PARALLEL_PROD_LVL if blank */
%if ( &m_parallel_prod_lvl=) %then %do;
%let m_parallel_prod_lvl= 0;
%end;
 
/* Give a value of 2 to PROD_PARTITION_LVL if blank */
%if ( &m_prod_partition_lvl=) %then %do;
%let m_prod_partition_lvl= 2;
proc sql noprint;
update &m_di_data..global_setting
set spec_value="&m_prod_partition_lvl"
where spec_nm="PROD_PARTITION_LVL"
;
 
quit;
 
%end;
 
%put m_parallel_prod_lvl=&m_parallel_prod_lvl;
%put m_prod_partition_lvl = &m_prod_partition_lvl ;
 
%if (%eval( &m_parallel_prod_lvl) < %eval(&m_prod_partition_lvl) ) %then
%do;
proc sql noprint;
update &m_di_data..global_setting
set spec_value="&m_prod_partition_lvl"
where spec_nm="PARALLEL_PROD_LVL"
;
 
quit;
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID660016_2;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID660016_2;
%put ERROR- Description                              : Change from the past;
%put ERROR- Version                                  : D2TKMI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID660016_2;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID660016_2",
"Change from the past",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID660016_2:;
 
 
* End of changes for CHANGE_ID:ID660016_2;
 
 
***********************************************************************************************;
*************************************  End Change ID660016_2 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change PARTMETA ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: PARTMETA;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("PARTMETA")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : PARTMETA;
%goto PARTMETA;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D2TKMI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : PARTMETA;
* Insert record into change management table for CHANGE_ID: PARTMETA;
proc sql;
insert  into di_data.data_model_change_management
values (
"PARTMETA",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto PARTMETA;
 
%end;
 
 
 
 
 
%let transExists = %sysfunc(libref(DI_TRANS));
 
%if (&transExists = 0) %then
%do;
%let pathToTransLib=%di_util_first_libpath(&m_di_trans);
%put NOTE: DI_TRANS=&pathToTransLib;
%if not %sysfunc(exist(DI_TRANS.TABLE_PARTITION_META))
%then %do;
option user=di_trans;
proc sql noprint;
CREATE TABLE TABLE_PARTITION_META
(
TABLE_NM VARCHAR(32),
FULL_COPY_FLG INTEGER,
PARTITION_FLG INTEGER,
ESTIMATION_FLG INTEGER
)
;
 
quit;
option user=work;
%end;
%end;
%else %do;
%put ERROR:  Please make sure that di_trans libref is assigned.;
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: PARTMETA;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: PARTMETA;
%put ERROR- Description                              : Change from the past;
%put ERROR- Version                                  : D2TKMI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: PARTMETA;
proc sql;
insert  into di_data.data_model_change_management
values (
"PARTMETA",
"Change from the past",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%PARTMETA:;
 
 
* End of changes for CHANGE_ID:PARTMETA;
 
 
***********************************************************************************************;
*************************************  End Change PARTMETA ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change COMMONLST ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: COMMONLST;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("COMMONLST")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(DI_TRANS)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: DI_TRANS;
%put NOTE- Change ID                             :COMMONLST;
%goto COMMONLST;
 
%end;
%if not (%sysfunc(exist(DI_TRANS.TABLE_PARTITION_META))) %then
%do;
%put NOTE: Skip this change since this table does not exist: DI_TRANS.TABLE_PARTITION_META;
%put NOTE- Change ID                             :COMMONLST;
%goto COMMONLST;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : COMMONLST;
%goto COMMONLST;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D2TKMI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : COMMONLST;
* Insert record into change management table for CHANGE_ID: COMMONLST;
proc sql;
insert  into di_data.data_model_change_management
values (
"COMMONLST",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto COMMONLST;
 
%end;
 
 
 
 
 
 
/* Create common files list */
 
%if %sysfunc(exist(DI_TRANS.TABLE_PARTITION_META))
%then %do;
filename comm "./common-files.lst";
data _null_;
file comm lrecl=32000;;
set di_trans.table_partition_meta (where=(full_copy_flg=1));
table_nm=lowcase(table_nm);
 
indfile=trim(table_nm) || ".sas7bdat" ;
put comm @1 indfile;
 
if (lowcase(table_nm) not in ("attr_spec","model_data_agg","psychological_points","model_exception") ) then do;
indfile=trim(table_nm) || ".sas7bndx" ;
put comm @1 indfile;
end;
run;
filename comm clear;
 
/* Populate TABLE_PARTITION_META from seed */
 
/* RDBMS seed file */
filename readFrom "%di_util_misc_path()/alterddl/baseline/seed_rdbms.sql" lrecl=400;
 
/* Read contents of seed file into work table */
data work.tpm  ;
infile readFrom dsd missover lrecl=400 dsd delimiter="~";
attrib allData length=$400.;
input allData ;
run;
 
filename TPMETA TEMP;
 
/* Keep seed content related to Table_Partition_Meta and remove everything else */
data _null_ ;
set work.tpm END=done;
file TPMETA lrecl=400;
retain flag 0;
 
indVal=index(allData,"delete from TABLE_PARTITION_META");
if indVal>0 then flag = 1;
 
indVal=index(allData,"-- End seed Table_partition_meta");
if index(allData,"-- End seed Table_partition_meta")>0 then flag = 0;
 
if _n_ = 1 then do;
 
put TPMETA @1 'option user=di_trans;' ;
put TPMETA @1 'proc sql noprint;' ;
end;
 
if done then do;
put TPMETA @1 'quit;' ;
put TPMETA @1 'option user=work;' ;
end;
 
if flag=0 then return;
if flag = 1 then do;
put TPMETA @1 allData;
end;
 
 
run;
 
%include TPMETA;
filename TPMETA clear;
 
%end;
 
 
 
* Check for errors while processing CHANGE_ID: COMMONLST;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: COMMONLST;
%put ERROR- Description                              : Refresh Table Partition Meta;
%put ERROR- Version                                  : D2TKMI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: COMMONLST;
proc sql;
insert  into di_data.data_model_change_management
values (
"COMMONLST",
"Refresh Table Partition Meta",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%COMMONLST:;
 
 
* End of changes for CHANGE_ID:COMMONLST;
 
 
***********************************************************************************************;
*************************************  End Change COMMONLST ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID738983 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID738983;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID738983")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID738983;
%goto ID738983;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID738983;
* Insert record into change management table for CHANGE_ID: ID738983;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID738983",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID738983;
 
%end;
 
 
 
 
 
 
 
proc sql;
ALTER TABLE &m_didm_stg..STG_GEO_PROD
ADD MIN_INV_LVL integer format = NLNUM12.2   INFORMAT=NLNUM12.2;
quit;
 
proc sql;
ALTER TABLE &m_didm_stg..STG_PRODUCT
DROP MIN_INV_LVL;
quit;
 
 
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID738983;
%put ERROR- Description                              : Move min_inv_lvl from PRODUCT_DM to GEO_PROD;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 30MAR2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
%else %do;
proc sql;
create table Geo_prod_temp as
select b.*, MIN_INV_LVL
from &m_di_data..PRODUCT_DM as a, &m_di_data..GEO_PROD as b
where a.prod_hier_sk = b.prod_hier_sk;
quit;
 
proc sql;
alter table
&m_di_data..PRODUCT_DM
drop column MIN_INV_LVL;
quit;
 
proc copy in = work out = &m_di_data;
select Geo_prod_temp;
quit;
%end;
 
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID738983;
%put ERROR- Description                              : Move min_inv_lvl from PRODUCT_DM to GEO_PROD;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 30MAR2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
%else %do;
proc datasets lib = &m_di_data nolist nowarn;
delete GEO_PROD;
change Geo_prod_temp = GEO_PROD;
quit;
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID738983;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID738983;
%put ERROR- Description                              : Move min_inv_lvl from PRODUCT_DM to GEO_PROD;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 30MAR2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID738983;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID738983",
"Move min_inv_lvl from PRODUCT_DM to GEO_PROD",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID738983:;
 
 
* End of changes for CHANGE_ID:ID738983;
 
 
***********************************************************************************************;
*************************************  End Change ID738983 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change RBLD_GEO_PROD_INDX_CONSTR ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: RBLD_GEO_PROD_INDX_CONSTR;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("RBLD_GEO_PROD_INDX_CONSTR")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : RBLD_GEO_PROD_INDX_CONSTR;
%goto RBLD_GEO_PROD_INDX_CONSTR;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : RBLD_GEO_PROD_INDX_CONSTR;
* Insert record into change management table for CHANGE_ID: RBLD_GEO_PROD_INDX_CONSTR;
proc sql;
insert  into di_data.data_model_change_management
values (
"RBLD_GEO_PROD_INDX_CONSTR",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto RBLD_GEO_PROD_INDX_CONSTR;
 
%end;
 
 
 
 
 
 
proc sql;
alter table &m_di_data..GEO_PROD add CONSTRAINT PRIM_KEY PRIMARY KEY (GEO_HIER_SK, PROD_HIER_SK);
alter table &m_di_data..GEO_PROD add NOT NULL (GEO_PROD_STATUS);
alter table &m_di_data..GEO_PROD add NOT NULL (DATA_LVL_ID);
alter table &m_di_data..GEO_PROD add NOT NULL (SALES_INTRODUCTION_DT);
alter table &m_di_data..GEO_PROD add NOT NULL (INITIAL_SEASON_CD);
alter table &m_di_data..GEO_PROD add NOT NULL (SEASON_CD);
quit;
 
proc sql;
CREATE INDEX PROD_HIER_SK ON &m_di_data..GEO_PROD(PROD_HIER_SK);
CREATE INDEX DATA_LVL_ID ON &m_di_data..GEO_PROD(DATA_LVL_ID);
CREATE INDEX VENDOR_SK ON &m_di_data..GEO_PROD(VENDOR_SK);
quit;
 
 
 
 
* Check for errors while processing CHANGE_ID: RBLD_GEO_PROD_INDX_CONSTR;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: RBLD_GEO_PROD_INDX_CONSTR;
%put ERROR- Description                              : Rebuild Constraints and indexes for GEO_PROD;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 01APR2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: RBLD_GEO_PROD_INDX_CONSTR;
proc sql;
insert  into di_data.data_model_change_management
values (
"RBLD_GEO_PROD_INDX_CONSTR",
"Rebuild Constraints and indexes for GEO_PROD",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%RBLD_GEO_PROD_INDX_CONSTR:;
 
 
* End of changes for CHANGE_ID:RBLD_GEO_PROD_INDX_CONSTR;
 
 
***********************************************************************************************;
*************************************  End Change RBLD_GEO_PROD_INDX_CONSTR ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change JOB_STATUS_PARTITION ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: JOB_STATUS_PARTITION;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("JOB_STATUS_PARTITION")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(&m_di_mon.)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_di_mon.;
%put NOTE- Change ID                             :JOB_STATUS_PARTITION;
%goto JOB_STATUS_PARTITION;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : JOB_STATUS_PARTITION;
%goto JOB_STATUS_PARTITION;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : JOB_STATUS_PARTITION;
* Insert record into change management table for CHANGE_ID: JOB_STATUS_PARTITION;
proc sql;
insert  into di_data.data_model_change_management
values (
"JOB_STATUS_PARTITION",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto JOB_STATUS_PARTITION;
 
%end;
 
 
 
 
 
Data &m_di_mon..JOB_STATUS_PARTITION ;
attrib USER length=$32 label='User id' ;
attrib TABLE length=$32 label='Table name' ;
attrib LIB length=$32 label='Library' ;
attrib JOBNAME length=$80 label='Job name' ;
attrib JOBSTAT length=$80 label='Job status' ;
attrib JOB_RC length=8 label='Job return code' ;
attrib RBEFORE length=8 label='No. Records before' ;
attrib RAFTER length=8 label='No. Records after' ;
attrib RSOURCE length=8 label='No. Records in source' ;
attrib RINEXCP length=8 label='No. Records rejected' ;
attrib STTIME length=8 format=&m_dttmfmt label='Job start time' ;
attrib ENDTIME length=8 format=&m_dttmfmt label='Job end time' ;
stop; run;
 
 
 
 
* Check for errors while processing CHANGE_ID: JOB_STATUS_PARTITION;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: JOB_STATUS_PARTITION;
%put ERROR- Description                              : Create an empty structure of JOB_STATUS_PARTITION;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 07SEP2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: JOB_STATUS_PARTITION;
proc sql;
insert  into di_data.data_model_change_management
values (
"JOB_STATUS_PARTITION",
"Create an empty structure of JOB_STATUS_PARTITION",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%JOB_STATUS_PARTITION:;
 
 
* End of changes for CHANGE_ID:JOB_STATUS_PARTITION;
 
 
***********************************************************************************************;
*************************************  End Change JOB_STATUS_PARTITION ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change SUBSET ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: SUBSET;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("SUBSET")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : SUBSET;
%goto SUBSET;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D2TKMI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : SUBSET;
* Insert record into change management table for CHANGE_ID: SUBSET;
proc sql;
insert  into di_data.data_model_change_management
values (
"SUBSET",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto SUBSET;
 
%end;
 
 
 
 
 
/* Create subfolder 1 under di_data if it does not exist */
%di_etl_set_lib (parent_lib=&libref, sub_folder=1, partition_lib=di_part);
 
/* Check if &m_di_mon. library exists.  If not create one under di_data and assign it */
%if %sysfunc(libref(&m_di_mon.)) ne 0 %then %do;
%di_etl_set_lib (parent_lib=&libref, sub_folder=_mon, partition_lib=&m_di_mon.);
%end;
 
/* Added this check on 06/02/2010.  Test scripts failing.  There cannot be dependency on DI_TRANS */
%if %sysfunc(exist(DI_TRANS.TABLE_PARTITION_META)) %then %do;
 
data work.exclude_tables;
attrib table_nm length=$40;
table_nm = 'SALES_FACT'; output;
table_nm = 'INVENTORY_FACT'; output;
table_nm = 'PROMOTION_FACT'; output;
table_nm = 'PROMOTION_FACT_FUTURE'; output;
run;
 
%di_etl_hp_migration( from_lib=&libref,
exclude_list=work.exclude_tables,
increment_count=8000000,
refresh_mapping=1,
partition_method=2);
%end;
%else %do;
%put ERROR: Table DI_TRANS.TABLE_PARTITION_META does not exist. ;
%put ERROR- This table should have been created as part of change in PARTMETA;
%put ERROR- Please create this table and rerun!;
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: SUBSET;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: SUBSET;
%put ERROR- Description                              : Change from the past;
%put ERROR- Version                                  : D2TKMI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: SUBSET;
proc sql;
insert  into di_data.data_model_change_management
values (
"SUBSET",
"Change from the past",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%SUBSET:;
 
 
* End of changes for CHANGE_ID:SUBSET;
 
 
***********************************************************************************************;
*************************************  End Change SUBSET ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID660160_1 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID660160_1;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID660160_1")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID660160_1;
%goto ID660160_1;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D2TKMI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID660160_1;
* Insert record into change management table for CHANGE_ID: ID660160_1;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID660160_1",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID660160_1;
 
%end;
 
 
 
 
 
/* GLOBAL_SETTING_DETAILS */
data work.GLOBAL_SETTING_DETAILS_TMP;
set &m_di_data..GLOBAL_SETTING_DETAILS;
CONFIG_CD = 3;
run;
 
data &m_di_data..GLOBAL_SETTING_DETAILS;
attrib SPEC_NM                             length=$32                                          ;
attrib APP                                 length=$40                                          ;
attrib DEFAULT_SPEC_VALUE                  length=$100                                         ;
attrib SPEC_DATATYPE                       length=$40                                          ;
attrib SPEC_DATATYPE_EXT                   length=$40                                          ;
attrib SPEC_VALUE_MIN                      length=8      FORMAT=NLNUM12.2   INFORMAT=NLNUM12.2 ;
attrib SPEC_VALUE_MAX                      length=8      FORMAT=NLNUM12.2   INFORMAT=NLNUM12.2 ;
attrib SPEC_VALUE_INCR                     length=8      FORMAT=NLNUM12.2   INFORMAT=NLNUM12.2 ;
attrib EDITABLE_FLG                        length=4                                            ;
attrib ENABLED_FLG                         length=4                                            ;
attrib REQUIRED_FLG                        length=4                                            ;
attrib HIDDEN_FLG                          length=4                                            ;
attrib MISSING_VAL_OK_FLG                  length=4                                            ;
attrib OVERRIDE_APP_LIST                   length=$100                                         ;
attrib REF_QUERY                           length=$500                                         ;
attrib GENERATE_PREFIX_NM                  length=$40                                          ;
attrib GENERATE_SUFFIX_MAX                 length=$40                                          ;
attrib SPEC_VALUE_LIST_DELIMITER           length=$3                                           ;
attrib DESC_KEY                            length=$100                                         ;
attrib CONFIG_CD                           length=4                                            ;
stop; run;
 
proc sql noprint;
alter table &m_di_data..GLOBAL_SETTING_DETAILS add CONSTRAINT PRIM_KEY PRIMARY KEY (SPEC_NM, APP, CONFIG_CD);
quit;
 
proc sql noprint;
DELETE from work.GLOBAL_SETTING_DETAILS_TMP WHERE SPEC_NM='MODEL_GEO_HIER_ASSOC_CD';
DELETE from work.GLOBAL_SETTING_DETAILS_TMP WHERE SPEC_NM='MODEL_PROD_HIER_ASSOC_CD';
quit;
 
proc append base=&m_di_data..GLOBAL_SETTING_DETAILS data=work.GLOBAL_SETTING_DETAILS_TMP force;
run;
 
proc sql noprint;
drop table work.GLOBAL_SETTING_DETAILS_TMP;
quit;
 
 
/* GLOBAL_SETTING_GROUP */
data work.GLOBAL_SETTING_GROUP_TMP;
set &m_di_data..GLOBAL_SETTING_GROUP;
CONFIG_CD = 1;
run;
 
data &m_di_data..GLOBAL_SETTING_GROUP;
attrib GLOBAL_SETTING_GROUP_NM             length=$40  ;
attrib GLOBAL_SETTING_GROUP_DESC           length=$100 ;
attrib GLOBAL_SETTING_GROUP_DESC_KEY       length=$100 ;
attrib GLOBAL_SETTING_CATEGORY_FLG         length=4    ;
attrib SETTING_GROUP_PERMISSION_ROLE       length=$100 ;
attrib CONFIG_CD                    length=4;
stop; run;
 
proc sql noprint;
alter table &m_di_data..GLOBAL_SETTING_GROUP add CONSTRAINT PRIM_KEY PRIMARY KEY (GLOBAL_SETTING_GROUP_NM);
quit;
 
proc append base=&m_di_data..GLOBAL_SETTING_GROUP data=work.GLOBAL_SETTING_GROUP_TMP force;
run;
 
proc sql noprint;
drop table work.GLOBAL_SETTING_GROUP_TMP;
quit;
 
proc sql noprint;
update &m_di_data..GLOBAL_SETTING_GROUP set CONFIG_CD = 2 where GLOBAL_SETTING_GROUP_NM = 'TK';
update &m_di_data..GLOBAL_SETTING_GROUP set GLOBAL_SETTING_GROUP_DESC = 'HP Markdown Optimization' where GLOBAL_SETTING_GROUP_NM = 'TK';
update &m_di_data..GLOBAL_SETTING_GROUP set GLOBAL_SETTING_GROUP_DESC_KEY = 'TKMI.txt' where GLOBAL_SETTING_GROUP_NM = 'TK';
update &m_di_data..GLOBAL_SETTING_GROUP set CONFIG_CD = 3 where GLOBAL_SETTING_GROUP_NM in ('SYS','CPO','ALL-MI','ALL-RO');
update &m_di_data..GLOBAL_SETTING_GROUP set CONFIG_CD = 3 where GLOBAL_SETTING_CATEGORY_FLG = 0;
quit;
 
 
 
/* MODEL_SPEC_DETAILS */
data work.MODEL_SPEC_DETAILS_TMP;
set &m_di_data..MODEL_SPEC_DETAILS;
CONFIG_CD = 1;
run;
 
data &m_di_data..MODEL_SPEC_DETAILS;
attrib MODEL_COMP_NM                       length=$5                                           ;
attrib SPEC_NM                             length=$32                                          ;
attrib SPEC_DATATYPE                       length=$40                                          ;
attrib SPEC_DATATYPE_EXT                   length=$40                                          ;
attrib SPEC_VALUE_MIN                      length=8      FORMAT=NLNUM12.2   INFORMAT=NLNUM12.2 ;
attrib SPEC_VALUE_MAX                      length=8      FORMAT=NLNUM12.2   INFORMAT=NLNUM12.2 ;
attrib SPEC_VALUE_INCR                     length=8      FORMAT=NLNUM12.2   INFORMAT=NLNUM12.2 ;
attrib EXPERIMENTAL_FLG                    length=4                                            ;
attrib KEY_SPEC_FLG                        length=4                                            ;
attrib HIDDEN_FLG                          length=4                                            ;
attrib OVERRIDE_MODEL_COMP_NM_LIST         length=$100                                         ;
attrib REF_QUERY                           length=$500                                         ;
attrib GENERATE_PREFIX_NM                  length=$40                                          ;
attrib GENERATE_SUFFIX_MAX                 length=$40                                          ;
attrib SPEC_VALUE_LIST_DELIMITER           length=$3                                           ;
attrib SPEC_DESC                           length=$100                                         ;
attrib DESC_KEY                            length=$100                                 ;
attrib CONFIG_CD                    length=4                                  ;
stop; run;
 
proc sql noprint;
alter table &m_di_data..MODEL_SPEC_DETAILS add CONSTRAINT PRIM_KEY PRIMARY KEY (MODEL_COMP_NM, SPEC_NM);
quit;
 
proc append base=&m_di_data..MODEL_SPEC_DETAILS data=work.MODEL_SPEC_DETAILS_TMP force;
run;
 
proc sql noprint;
drop table work.MODEL_SPEC_DETAILS_TMP;
quit;
 
/* MODEL_SPEC_WORKFLOW */
data work.MODEL_SPEC_WORKFLOW_TMP;
set &m_di_data..MODEL_SPEC_WORKFLOW;
CONFIG_CD = 3;
run;
 
data &m_di_data..MODEL_SPEC_WORKFLOW;
attrib TASK_NM                             length=$40                                          ;
attrib PARENT_TASK_NM                      length=$40                                          ;
attrib TASK_DESC                           length=$100                                         ;
attrib TASK_DESC_KEY                       length=$100                                         ;
attrib TASK_LVL                            length=4                                            ;
attrib SPEC_NM                             length=$32                                          ;
attrib SPEC_TYPE                           length=$5                                           ;
attrib MODEL_COMP_NM                       length=$5                                           ;
attrib CONFIG_CD                           length=4                                            ;
stop; run;
 
proc sql noprint;
alter table &m_di_data..MODEL_SPEC_WORKFLOW add CONSTRAINT PRIM_KEY PRIMARY KEY (TASK_NM);
quit;
 
proc append base=&m_di_data..MODEL_SPEC_WORKFLOW data=work.MODEL_SPEC_WORKFLOW_TMP force;
run;
 
proc sql noprint;
drop table work.MODEL_SPEC_WORKFLOW_TMP;
quit;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID660160_1;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID660160_1;
%put ERROR- Description                              : Change from the past;
%put ERROR- Version                                  : D2TKMI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID660160_1;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID660160_1",
"Change from the past",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID660160_1:;
 
 
* End of changes for CHANGE_ID:ID660160_1;
 
 
***********************************************************************************************;
*************************************  End Change ID660160_1 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID665967 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID665967;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID665967")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID665967;
%goto ID665967;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D2TKMI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID665967;
* Insert record into change management table for CHANGE_ID: ID665967;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID665967",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID665967;
 
%end;
 
 
 
 
 
 
/* Drop FA Tables from DI_TRANS.TABLE_PARTITION_META if these entries still exist */
 
%if %sysfunc(exist(DI_TRANS.TABLE_PARTITION_META))
%then %do;
proc sql noprint;
DELETE FROM DI_TRANS.TABLE_PARTITION_META WHERE UPCASE(SUBSTR(TABLE_NM,1,3))='FA_';
 
 
UPDATE DI_TRANS.TABLE_PARTITION_META
SET FULL_COPY_FLG=1,
PARTITION_FLG=0,
ESTIMATION_FLG=0
WHERE TABLE_NM in ("MODEL_GEO_PROD","MODEL_GEO_PROD_STATUS","MODEL_GEO_PROD_STATUS_RULE",
"MPLN_PERIOD_EST_MTS","MPLN_STORE_EST_MTS","PSYCHOLOGICAL_POINTS")
;
 
UPDATE DI_TRANS.TABLE_PARTITION_META
SET FULL_COPY_FLG=0,
PARTITION_FLG=0,
ESTIMATION_FLG=0
WHERE TABLE_NM in ("MODEL_GEO_PROD_STATUS_INC","")
;
 
 
quit;
%end;
 
 
 
* Check for errors while processing CHANGE_ID: ID665967;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID665967;
%put ERROR- Description                              : Change from the past;
%put ERROR- Version                                  : D2TKMI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID665967;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID665967",
"Change from the past",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID665967:;
 
 
* End of changes for CHANGE_ID:ID665967;
 
 
***********************************************************************************************;
*************************************  End Change ID665967 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID666192 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID666192;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID666192")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID666192;
%goto ID666192;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D2TKMI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID666192;
* Insert record into change management table for CHANGE_ID: ID666192;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID666192",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID666192;
 
%end;
 
 
 
 
 
proc sql noprint;
CREATE INDEX PROD_HIER_SK ON &m_di_data..COST_FACT_FUTURE(PROD_HIER_SK);
CREATE INDEX PROD_HIER_SK ON &m_di_data..COST_FACT_CURRENT(PROD_HIER_SK);
CREATE INDEX PROD_HIER_SK ON &m_di_data..COST_FACT_HISTORY(PROD_HIER_SK);
 
CREATE INDEX PROD_HIER_SK ON &m_di_data..PRICE_FACT_FUTURE(PROD_HIER_SK);
CREATE INDEX PROD_HIER_SK ON &m_di_data..PRICE_FACT_HISTORY(PROD_HIER_SK);
 
CREATE INDEX PROD_HIER_SK ON &m_di_data..SALES_FACT(PROD_HIER_SK);
 
CREATE INDEX PROD_HIER_SK ON &m_di_data..INVENTORY_FACT(PROD_HIER_SK);
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID666192;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID666192;
%put ERROR- Description                              : Change from the past;
%put ERROR- Version                                  : D2TKMI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID666192;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID666192",
"Change from the past",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID666192:;
 
 
* End of changes for CHANGE_ID:ID666192;
 
 
***********************************************************************************************;
*************************************  End Change ID666192 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID661123 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID661123;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID661123")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID661123;
%goto ID661123;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D2TKMI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID661123;
* Insert record into change management table for CHANGE_ID: ID661123;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID661123",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID661123;
 
%end;
 
 
 
 
 
proc sql noprint;
 
DELETE FROM &m_di_data..MODEL_SPEC_DEFAULT WHERE SPEC_NM = 'CREATE_HOLDOUT_DETAILS' AND MODEL_COMP_NM = 'FA';
INSERT INTO &m_di_data..MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('CREATE_HOLDOUT_DETAILS','FA','-1','1',NULL);
DELETE FROM &m_di_data..MODEL_SPEC_DEFAULT WHERE SPEC_NM = 'RUN_MDO_ANALYSIS' AND MODEL_COMP_NM = 'FA';
INSERT INTO &m_di_data..MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('RUN_MDO_ANALYSIS','FA','-1','1',NULL);
 
 
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID661123;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID661123;
%put ERROR- Description                              : Change from the past;
%put ERROR- Version                                  : D2TKMI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID661123;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID661123",
"Change from the past",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID661123:;
 
 
* End of changes for CHANGE_ID:ID661123;
 
 
***********************************************************************************************;
*************************************  End Change ID661123 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID670036 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID670036;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID670036")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID670036;
%goto ID670036;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D2TKMI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID670036;
* Insert record into change management table for CHANGE_ID: ID670036;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID670036",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID670036;
 
%end;
 
 
 
 
 
 
 
* Check for errors while processing CHANGE_ID: ID670036;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID670036;
%put ERROR- Description                              : Change from the past;
%put ERROR- Version                                  : D2TKMI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID670036;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID670036",
"Change from the past",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID670036:;
 
 
* End of changes for CHANGE_ID:ID670036;
 
 
***********************************************************************************************;
*************************************  End Change ID670036 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID670036_2 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID670036_2;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID670036_2")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID670036_2;
%goto ID670036_2;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D2TKMI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID670036_2;
* Insert record into change management table for CHANGE_ID: ID670036_2;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID670036_2",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID670036_2;
 
%end;
 
 
 
 
 
proc sql noprint;
 
select count(*)
into :_cnt_idx_phad
from sashelp.vindex
where upcase(libname)="DI_DATA"
and upcase(memname) = "PRODUCT_HIER_ASSOC_DM"
and upcase(indxname) = "PROD_HIER_IX7"
;
quit;
 
%if &_cnt_idx_phad > 0 %then
%do;
proc sql noprint;
DROP   INDEX PROD_HIER_IX7 FROM &m_di_data..PRODUCT_HIER_ASSOC_DM;
CREATE INDEX PROD_HIER_IX3 ON &m_di_data..PRODUCT_HIER_ASSOC_DM(PROD_HIER_ASSOC_CD, PARENT_PROD_HIER_SK);
quit;
 
%end;
 
 
 
* Check for errors while processing CHANGE_ID: ID670036_2;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID670036_2;
%put ERROR- Description                              : Change from the past;
%put ERROR- Version                                  : D2TKMI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID670036_2;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID670036_2",
"Change from the past",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID670036_2:;
 
 
* End of changes for CHANGE_ID:ID670036_2;
 
 
***********************************************************************************************;
*************************************  End Change ID670036_2 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID661123_1 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID661123_1;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID661123_1")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID661123_1;
%goto ID661123_1;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D2TKMI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID661123_1;
* Insert record into change management table for CHANGE_ID: ID661123_1;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID661123_1",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID661123_1;
 
%end;
 
 
 
 
 
proc sql noprint;
DELETE FROM &m_di_data..MODEL_SPEC_DEFAULT WHERE SPEC_NM = 'HOLDOUT_DETAILS_PROD_LVL' AND MODEL_COMP_NM = 'FA';
INSERT INTO &m_di_data..MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('HOLDOUT_DETAILS_PROD_LVL','FA','-1','',NULL);
DELETE FROM &m_di_data..MODEL_SPEC_DEFAULT WHERE SPEC_NM = 'HOLDOUT_DETAILS_GEO_LVL' AND MODEL_COMP_NM = 'FA';
INSERT INTO &m_di_data..MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('HOLDOUT_DETAILS_GEO_LVL','FA','-1','',NULL);
 
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID661123_1;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID661123_1;
%put ERROR- Description                              : Change from the past;
%put ERROR- Version                                  : D2TKMI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID661123_1;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID661123_1",
"Change from the past",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID661123_1:;
 
 
* End of changes for CHANGE_ID:ID661123_1;
 
 
***********************************************************************************************;
*************************************  End Change ID661123_1 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID674951 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID674951;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID674951")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID674951;
%goto ID674951;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D2TKMI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID674951;
* Insert record into change management table for CHANGE_ID: ID674951;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID674951",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID674951;
 
%end;
 
 
 
 
 
/* Find if there are entries in hierarchy_assoc_dm */
proc sql noprint;
select count(*) into :m_count
 
from &m_di_data..Hierarchy_assoc_dm
;
quit;
 
 
/* Insert entries in hierarchy_assoc_dm only if the table is empty */
%if &m_count=0 %then %do;
proc sql noprint;
 
insert into &m_di_data..Hierarchy_assoc_dm
(HIER_ASSOC_CD, HIER_TYPE, HIER_ASSOC_NM)
VALUES (1, 1, "Standard Hierarchy")
;
 
insert into &m_di_data..Hierarchy_assoc_dm
(HIER_ASSOC_CD, HIER_TYPE, HIER_ASSOC_NM)
VALUES (1, 2, "Standard Hierarchy")
;
 
quit;
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID674951;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID674951;
%put ERROR- Description                              : Change from the past;
%put ERROR- Version                                  : D2TKMI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID674951;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID674951",
"Change from the past",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID674951:;
 
 
* End of changes for CHANGE_ID:ID674951;
 
 
***********************************************************************************************;
*************************************  End Change ID674951 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID675274 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID675274;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID675274")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID675274;
%goto ID675274;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D2TKMI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID675274;
* Insert record into change management table for CHANGE_ID: ID675274;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID675274",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID675274;
 
%end;
 
 
 
 
 
/* As per Arin drop table and recreate with no DATA_CONFIG_SK column and no primary key */
/* No need to migrate data */
 
/* Drop table */
proc sql noprint;
drop table &m_di_data..MODEL_EXCEPTION;
quit;
 
/* create table */
data &m_di_data..MODEL_EXCEPTION;
attrib GEO_HIER_SK                         length=4                                            ;
attrib PROD_HIER_SK                        length=6                                            ;
attrib EXCEPTION_TYPE_ID                   length=4                                            ;
stop; run;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID675274;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID675274;
%put ERROR- Description                              : Change from the past;
%put ERROR- Version                                  : D2TKMI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID675274;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID675274",
"Change from the past",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID675274:;
 
 
* End of changes for CHANGE_ID:ID675274;
 
 
***********************************************************************************************;
*************************************  End Change ID675274 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID676674 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID676674;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID676674")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID676674;
%goto ID676674;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D2TKMI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID676674;
* Insert record into change management table for CHANGE_ID: ID676674;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID676674",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID676674;
 
%end;
 
 
 
 
 
proc sql noprint;
UPDATE &m_di_data..MODEL_SPEC_DETAILS set SPEC_DATATYPE = 'Equation'
where SPEC_NM = 'FA_SCORE_FUNC' and MODEL_COMP_NM = 'FA';
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID676674;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID676674;
%put ERROR- Description                              : Change from the past;
%put ERROR- Version                                  : D2TKMI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID676674;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID676674",
"Change from the past",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID676674:;
 
 
* End of changes for CHANGE_ID:ID676674;
 
 
***********************************************************************************************;
*************************************  End Change ID676674 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID678818 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID678818;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID678818")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID678818;
%goto ID678818;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D2TKMI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID678818;
* Insert record into change management table for CHANGE_ID: ID678818;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID678818",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID678818;
 
%end;
 
 
 
 
 
data &m_di_data..SCORING_PARAM_UNCAPPED;
attrib PROD_HIER_SK        length=6                                            ;
attrib GEO_HIER_SK         length=4                                            ;
attrib EFFECT_EST          length=8      FORMAT=NLNUM12.4   INFORMAT=NLNUM12.4 ;
attrib EFFECT_TYPE         length=$40                                          ;
attrib EFFECT_CATEGORY     length=$40                                          ;
attrib PROD_ATTR_KEY       length=$40                                          ;
attrib PROD_ATTR_SK        length=4                                            ;
stop; run;
 
proc sql noprint;
alter table &m_di_data..SCORING_PARAM_UNCAPPED add NOT NULL (PROD_HIER_SK);
alter table &m_di_data..SCORING_PARAM_UNCAPPED add NOT NULL (GEO_HIER_SK);
alter table &m_di_data..SCORING_PARAM_UNCAPPED add NOT NULL (EFFECT_TYPE);
alter table &m_di_data..SCORING_PARAM_UNCAPPED add NOT NULL (EFFECT_CATEGORY);
quit;
 
proc sql noprint;
CREATE INDEX scoring_param_ix1 ON
&m_di_data..SCORING_PARAM_UNCAPPED(GEO_HIER_SK, PROD_HIER_SK);
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID678818;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID678818;
%put ERROR- Description                              : Change from the past;
%put ERROR- Version                                  : D2TKMI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID678818;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID678818",
"Change from the past",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID678818:;
 
 
* End of changes for CHANGE_ID:ID678818;
 
 
***********************************************************************************************;
*************************************  End Change ID678818 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID679897 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID679897;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID679897")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID679897;
%goto ID679897;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D2TKMI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID679897;
* Insert record into change management table for CHANGE_ID: ID679897;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID679897",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID679897;
 
%end;
 
 
 
 
 
%let parentdir=%di_util_first_libpath(&m_di_data);
%let eraseFromDir=1;
%let _dir = %sysfunc(dcreate(&eraseFromDir,&parentdir));
 
%if "&sysscp"="WIN" %then %do;
%let m_sepchar=\;
%let m_erasecmd=erase;
%let m_options=%bquote(/s);
options noxwait;
%end;
 
%else %do;
%let m_sepchar=/;
%let m_erasecmd=rm;
%let m_options=%bquote(-rf);
%end;
 
 
%if "&sysscp"="WIN" %then
%do;
%if %sysfunc(fileexist(%quote(&parentdir&m_sepchar.&eraseFromDir))) %then %do;
X "&m_erasecmd &m_options &parentdir&m_sepchar.&eraseFromDir&m_sepchar.model_group.sas*" ;
%end;
%else %do;
%put NOTE: Directory "&parentdir&m_sepchar.&moveToSubdir" does not exist. ;
%put NOTE- No subsetting on Model_group table has been done which is correct. ;
%put NOTE- mig_ID679897 ;
%end;
%end;
%else;
%do;
%if %sysfunc(fileexist(%quote(&parentdir&m_sepchar.&eraseFromDir))) %then %do;
X "&m_erasecmd &m_options &parentdir/&eraseFromDir/*/model_group.sas*" ;
%end;
%else %do;
%put NOTE: Directory "&parentdir&m_sepchar.&moveToSubdir" does not exist. ;
%put NOTE- No subsetting on Model_group table has been done which is correct. ;
%put NOTE- mig_ID679897 ;
%end;
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID679897;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID679897;
%put ERROR- Description                              : Change from the past;
%put ERROR- Version                                  : D2TKMI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID679897;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID679897",
"Change from the past",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID679897:;
 
 
* End of changes for CHANGE_ID:ID679897;
 
 
***********************************************************************************************;
*************************************  End Change ID679897 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change SFDTSK_INVFDTSK ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: SFDTSK_INVFDTSK;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("SFDTSK_INVFDTSK")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : SFDTSK_INVFDTSK;
%goto SFDTSK_INVFDTSK;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : SFDTSK_INVFDTSK;
* Insert record into change management table for CHANGE_ID: SFDTSK_INVFDTSK;
proc sql;
insert  into di_data.data_model_change_management
values (
"SFDTSK_INVFDTSK",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto SFDTSK_INVFDTSK;
 
%end;
 
 
 
 
 
proc sql noprint;
drop table &m_di_data..SALES_FACT_DATE_SK ;
drop table &m_di_data..INVENTORY_FACT_DATE_SK;
quit;
 
 
 
* Check for errors while processing CHANGE_ID: SFDTSK_INVFDTSK;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: SFDTSK_INVFDTSK;
%put ERROR- Description                              : Change from the past;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: SFDTSK_INVFDTSK;
proc sql;
insert  into di_data.data_model_change_management
values (
"SFDTSK_INVFDTSK",
"Change from the past",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%SFDTSK_INVFDTSK:;
 
 
* End of changes for CHANGE_ID:SFDTSK_INVFDTSK;
 
 
***********************************************************************************************;
*************************************  End Change SFDTSK_INVFDTSK ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change GS_MDLSPEC ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: GS_MDLSPEC;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("GS_MDLSPEC")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : GS_MDLSPEC;
%goto GS_MDLSPEC;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D2TKMI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : GS_MDLSPEC;
* Insert record into change management table for CHANGE_ID: GS_MDLSPEC;
proc sql;
insert  into di_data.data_model_change_management
values (
"GS_MDLSPEC",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto GS_MDLSPEC;
 
%end;
 
 
 
 
%put NOTE: Skipping this change since this change should never be applied.;
%put NOTE- Change ID                             :GS_MDLSPEC;
%goto GS_MDLSPEC;
 
 
/* RDBMS seed file */
filename readFrom "%di_util_misc_path()/alterddl/baseline/seed_sas.sas" lrecl=255;
 
/* Read contents of seed file into work table */
data work.model_spec  ;
infile readFrom dsd missover lrecl=255 dsd delimiter="~";
attrib allData length=$255.;
input allData ;
run;
 
filename MDLSPEC TEMP lrecl=255;
 
/* Keep seed content related to Model Spec and remove everything else */
data _null_ ;
set work.model_spec END=done;
retain flag;
file MDLSPEC lrecl=255;
 
indVal_1=index(upcase(allData),"BEGIN GLOBAL_SETTING CONFIGURATION TABLES SEED");
indVal_2=index(upcase(allData),"BEGIN MODEL_SPEC CONFIGURATION TABLES SEED");
indVal_A=index(upcase(allData),"END GLOBAL_SETTING CONFIGURATION TABLES SEED");
indVal_B=index(upcase(allData),"END MODEL_SPEC CONFIGURATION TABLES SEED");
 
if (indVal_1 > 0 or indVal_2>0) then flag = 1;
if flag = 1 then do;
put MDLSPEC @1 allData;
end;
if (indVal_A > 0 or indVal_B>0) then flag = 0;
 
 
 
run;
 
%include MDLSPEC;
filename MDLSPEC clear;
 
 
 
 
* Check for errors while processing CHANGE_ID: GS_MDLSPEC;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: GS_MDLSPEC;
%put ERROR- Description                              : Change from the past;
%put ERROR- Version                                  : D2TKMI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: GS_MDLSPEC;
proc sql;
insert  into di_data.data_model_change_management
values (
"GS_MDLSPEC",
"Change from the past",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%GS_MDLSPEC:;
 
 
* End of changes for CHANGE_ID:GS_MDLSPEC;
 
 
***********************************************************************************************;
*************************************  End Change GS_MDLSPEC ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID682584 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID682584;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID682584")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID682584;
%goto ID682584;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D2TKMI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID682584;
* Insert record into change management table for CHANGE_ID: ID682584;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID682584",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID682584;
 
%end;
 
 
 
 
 
proc sql;
delete from &m_di_data..MODEL_GEO_PROD_STATUS_SPEC where SPEC_NM = 'PREV_GP_STATUS_DATE_SK';
delete from &m_di_data..MODEL_GEO_PROD_STATUS_SPEC where SPEC_NM = 'PAR_BY_WEEK_REFRESH';
delete from &m_di_data..MODEL_GEO_PROD_STATUS_DETAILS where SPEC_NM = 'PREV_GP_STATUS_DATE_SK';
delete from &m_di_data..MODEL_GEO_PROD_STATUS_DETAILS where SPEC_NM = 'PAR_BY_WEEK_REFRESH';
delete from &m_di_data..MODEL_GEO_PROD_STATUS_VALUES where SPEC_NM = 'PAR_BY_WEEK_REFRESH';
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID682584;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID682584;
%put ERROR- Description                              : Change from the past;
%put ERROR- Version                                  : D2TKMI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID682584;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID682584",
"Change from the past",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID682584:;
 
 
* End of changes for CHANGE_ID:ID682584;
 
 
***********************************************************************************************;
*************************************  End Change ID682584 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID680319 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID680319;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID680319")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID680319;
%goto ID680319;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D2TKMI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID680319;
* Insert record into change management table for CHANGE_ID: ID680319;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID680319",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID680319;
 
%end;
 
 
 
 
 
proc sql;
ALTER TABLE &m_di_data..MODEL_GEO_PROD_STATUS_SPEC DROP CONSTRAINT _NM0001_;
DELETE from &m_di_data..MODEL_GEO_PROD_STATUS_SPEC where SPEC_NM = 'SEASON_INACTIVE_DURATION';
INSERT INTO &m_di_data..MODEL_GEO_PROD_STATUS_SPEC
(SPEC_NM,SPEC_VALUE,CREATED_DTTM,CREATED_BY)
VALUES ('SEASON_INACTIVE_DURATION','',NULL,'SAS');
 
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID680319;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID680319;
%put ERROR- Description                              : Change from the past;
%put ERROR- Version                                  : D2TKMI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID680319;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID680319",
"Change from the past",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID680319:;
 
 
* End of changes for CHANGE_ID:ID680319;
 
 
***********************************************************************************************;
*************************************  End Change ID680319 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID685961 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID685961;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID685961")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID685961;
%goto ID685961;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D2TKMI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID685961;
* Insert record into change management table for CHANGE_ID: ID685961;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID685961",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID685961;
 
%end;
 
 
 
 
 
proc sql;
DELETE FROM &m_di_data..MODEL_GEO_PROD_STATUS_SPEC;
quit;
 
proc sql;
 
INSERT INTO &m_di_data..MODEL_GEO_PROD_STATUS_SPEC
(SPEC_NM,SPEC_VALUE,CREATED_DTTM,CREATED_BY)
VALUES ('GEO_GROUP_LVL','1',NULL,'SAS');
 
INSERT INTO &m_di_data..MODEL_GEO_PROD_STATUS_SPEC
(SPEC_NM,SPEC_VALUE,CREATED_DTTM,CREATED_BY)
VALUES ('GP_STATUS_HISTORY','104',NULL,'SAS');
 
INSERT INTO &m_di_data..MODEL_GEO_PROD_STATUS_SPEC
(SPEC_NM,SPEC_VALUE,CREATED_DTTM,CREATED_BY)
VALUES ('SEASON_FLG','1',NULL,'SAS');
quit;
 
 
 
 
proc sql;
DELETE FROM &m_di_data..MODEL_GEO_PROD_STATUS_RULE;
ALTER TABLE &m_di_data..MODEL_GEO_PROD_STATUS_RULE DROP CONSTRAINT _NM0001_;
quit;
 
proc sql;
INSERT INTO &m_di_data..MODEL_GEO_PROD_STATUS_RULE
(PROD_HIER_SK, RULE_NM, RULE_VALUE, CREATED_DTTM, CREATED_BY)
VALUES (1,'GP_STATUS_RULE','1', NULL, 'seed');
 
INSERT INTO &m_di_data..MODEL_GEO_PROD_STATUS_RULE
(PROD_HIER_SK, RULE_NM, RULE_VALUE, CREATED_DTTM, CREATED_BY)
VALUES (1,'GP_STATUS_FACT_DATA','1', NULL, 'seed');
 
INSERT INTO &m_di_data..MODEL_GEO_PROD_STATUS_RULE
(PROD_HIER_SK, RULE_NM, RULE_VALUE, CREATED_DTTM, CREATED_BY)
VALUES (1,'MIN_INV_UNITS','1', NULL, 'seed');
 
INSERT INTO &m_di_data..MODEL_GEO_PROD_STATUS_RULE
(PROD_HIER_SK, RULE_NM, RULE_VALUE, CREATED_DTTM, CREATED_BY)
VALUES (1,'MIN_STORE_PCT','0.2', NULL, 'seed');
 
INSERT INTO &m_di_data..MODEL_GEO_PROD_STATUS_RULE
(PROD_HIER_SK, RULE_NM, RULE_VALUE, CREATED_DTTM, CREATED_BY)
VALUES (1,'MIN_INV_COST_AMT','100', NULL, 'seed');
 
INSERT INTO &m_di_data..MODEL_GEO_PROD_STATUS_RULE
(PROD_HIER_SK, RULE_NM, RULE_VALUE, CREATED_DTTM, CREATED_BY)
VALUES (1,'MIN_SALES_AMT','100', NULL, 'seed');
 
INSERT INTO &m_di_data..MODEL_GEO_PROD_STATUS_RULE
(PROD_HIER_SK, RULE_NM, RULE_VALUE, CREATED_DTTM, CREATED_BY)
VALUES (1,'ONE_ACTIVE_PER_SEASON','1', NULL, 'seed');
 
INSERT INTO &m_di_data..MODEL_GEO_PROD_STATUS_RULE
(PROD_HIER_SK, RULE_NM, RULE_VALUE, CREATED_DTTM, CREATED_BY)
VALUES (1,'SEASON_ACTIVE_COEFF','0.3', NULL, 'seed');
 
INSERT INTO &m_di_data..MODEL_GEO_PROD_STATUS_RULE
(PROD_HIER_SK, RULE_NM, RULE_VALUE, CREATED_DTTM, CREATED_BY)
VALUES (1,'INACTIVE_CNT_VAL','3', NULL, 'seed');
 
INSERT INTO &m_di_data..MODEL_GEO_PROD_STATUS_RULE
(PROD_HIER_SK, RULE_NM, RULE_VALUE, CREATED_DTTM, CREATED_BY)
VALUES (1,'EXCLUDE_SEASON_START_WKS','2', NULL, 'seed');
 
INSERT INTO &m_di_data..MODEL_GEO_PROD_STATUS_RULE
(PROD_HIER_SK, RULE_NM, RULE_VALUE, CREATED_DTTM, CREATED_BY)
VALUES (1,'EXCLUDE_SEASON_END_WKS','2', NULL, 'seed');
 
INSERT INTO &m_di_data..MODEL_GEO_PROD_STATUS_RULE
(PROD_HIER_SK, RULE_NM, RULE_VALUE, CREATED_DTTM, CREATED_BY)
VALUES (1,'EXCLUDE_CLOSING_STORE_WKS','4', NULL, 'seed');
 
INSERT INTO &m_di_data..MODEL_GEO_PROD_STATUS_RULE
(PROD_HIER_SK, RULE_NM, RULE_VALUE, CREATED_DTTM, CREATED_BY)
VALUES (1,'SEASON_INACTIVE_DURATION','', NULL, 'seed');
 
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID685961;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID685961;
%put ERROR- Description                              : Change from the past;
%put ERROR- Version                                  : D2TKMI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID685961;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID685961",
"Change from the past",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID685961:;
 
 
* End of changes for CHANGE_ID:ID685961;
 
 
***********************************************************************************************;
*************************************  End Change ID685961 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID684209 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID684209;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID684209")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID684209;
%goto ID684209;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D2TKMI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID684209;
* Insert record into change management table for CHANGE_ID: ID684209;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID684209",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID684209;
 
%end;
 
 
 
 
 
proc sql noprint;
drop table &m_di_data..MPLN_GEO_PROD_ACCUM_MTS      ;
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID684209;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID684209;
%put ERROR- Description                              : Change from the past;
%put ERROR- Version                                  : D2TKMI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID684209;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID684209",
"Change from the past",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID684209:;
 
 
* End of changes for CHANGE_ID:ID684209;
 
 
***********************************************************************************************;
*************************************  End Change ID684209 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID688960 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID688960;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID688960")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID688960;
%goto ID688960;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D2TKMI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID688960;
* Insert record into change management table for CHANGE_ID: ID688960;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID688960",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID688960;
 
%end;
 
 
 
 
 
proc sql;
 
DELETE FROM &m_di_data..MODEL_SPEC_DEFAULT WHERE SPEC_NM = 'PCT_TAIL_CUTOFF' AND MODEL_COMP_NM = 'FA';
INSERT INTO &m_di_data..MODEL_SPEC_DEFAULT
(SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('PCT_TAIL_CUTOFF','FA','-1','1',NULL);
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID688960;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID688960;
%put ERROR- Description                              : Change from the past;
%put ERROR- Version                                  : D2TKMI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID688960;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID688960",
"Change from the past",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID688960:;
 
 
* End of changes for CHANGE_ID:ID688960;
 
 
***********************************************************************************************;
*************************************  End Change ID688960 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID688967 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID688967;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID688967")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID688967;
%goto ID688967;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D2TKMI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID688967;
* Insert record into change management table for CHANGE_ID: ID688967;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID688967",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID688967;
 
%end;
 
 
 
 
 
proc sql;
 
DELETE FROM &m_di_data..MODEL_SPEC_DEFAULT WHERE SPEC_NM = 'MIN_LIFE_FILTER' AND MODEL_COMP_NM = 'FA';
INSERT INTO &m_di_data..MODEL_SPEC_DEFAULT
(SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('MIN_LIFE_FILTER','FA','-1','8',NULL);
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID688967;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID688967;
%put ERROR- Description                              : Change from the past;
%put ERROR- Version                                  : D2TKMI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID688967;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID688967",
"Change from the past",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID688967:;
 
 
* End of changes for CHANGE_ID:ID688967;
 
 
***********************************************************************************************;
*************************************  End Change ID688967 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID693691 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID693691;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID693691")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID693691;
%goto ID693691;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D2TKMI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID693691;
* Insert record into change management table for CHANGE_ID: ID693691;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID693691",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID693691;
 
%end;
 
 
 
 
 
proc sql;
 
DELETE FROM &m_di_data..MODEL_SPEC_DEFAULT WHERE SPEC_NM = 'RUN_FA_MONITORING' AND MODEL_COMP_NM = 'FA';
INSERT INTO &m_di_data..MODEL_SPEC_DEFAULT
(SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('RUN_FA_MONITORING','FA','-1','0',NULL);
 
DELETE FROM &m_di_data..MODEL_SPEC_VALUES WHERE SPEC_NM = 'RUN_FA_MONITORING' AND MODEL_COMP_NM = 'FA';
INSERT INTO &m_di_data..MODEL_SPEC_VALUES
(SPEC_NM,MODEL_COMP_NM,SPEC_VALUE,SPEC_VALUE_DESC,SPEC_VALUE_DESC_KEY)
VALUES ('RUN_FA_MONITORING','FA','1','Run FA monitoring','faspec.RUN_FA_MONITORING.truemeans.txt');
INSERT INTO &m_di_data..MODEL_SPEC_VALUES
(SPEC_NM,MODEL_COMP_NM,SPEC_VALUE,SPEC_VALUE_DESC,SPEC_VALUE_DESC_KEY)
VALUES ('RUN_FA_MONITORING','FA','0','Do not run FA monitoring','faspec.RUN_FA_MONITORING.falsemeans.txt');
 
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID693691;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID693691;
%put ERROR- Description                              : Change from the past;
%put ERROR- Version                                  : D2TKMI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID693691;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID693691",
"Change from the past",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID693691:;
 
 
* End of changes for CHANGE_ID:ID693691;
 
 
***********************************************************************************************;
*************************************  End Change ID693691 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID695994 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID695994;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID695994")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(DI_MON)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: DI_MON;
%put NOTE- Change ID                             :ID695994;
%goto ID695994;
 
%end;
%if not (%sysfunc(exist(&m_di_mon..job_param))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_mon..job_param;
%put NOTE- Change ID                             :ID695994;
%goto ID695994;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID695994;
%goto ID695994;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D2TKMI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID695994;
* Insert record into change management table for CHANGE_ID: ID695994;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID695994",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID695994;
 
%end;
 
 
 
 
 
 
/* Check if &m_di_mon. library exists.  */
%let monExists = %sysfunc(libref(&m_di_mon.));
 
%if (&monExists = 0) %then
%do;
%if %sysfunc(exist(&m_di_mon..job_param))
%then %do;
proc sql;
select count(*) into :m_replicate_attrs
from &m_di_mon..job_param
where param_value="geography_attributes"
;
 
quit;
 
/* If these attributes do not exist add them to job_param */
%if ( &m_replicate_attrs<1) %then %do;
proc sql noprint;
insert into &m_di_mon..job_param
(jobname, param_name, param_value, default_func)
values("DI_REPLICATE_MULTIPLE_TABLES",        "etlp_src_tab7",             "product_attributes",         '"Y"'                           )
values("DI_REPLICATE_MULTIPLE_TABLES",        "etlp_src_tab8",             "geography_attributes",       '"Y"'                           )
;
quit;
%end;
%end;
%end;
 
 
* Check for errors while processing CHANGE_ID: ID695994;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID695994;
%put ERROR- Description                              : Change from the past;
%put ERROR- Version                                  : D2TKMI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID695994;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID695994",
"Change from the past",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID695994:;
 
 
* End of changes for CHANGE_ID:ID695994;
 
 
***********************************************************************************************;
*************************************  End Change ID695994 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID695068 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID695068;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID695068")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID695068;
%goto ID695068;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D2TKMI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID695068;
* Insert record into change management table for CHANGE_ID: ID695068;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID695068",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID695068;
 
%end;
 
 
 
 
 
/* SAS seed table */
proc sql;
DROP TABLE &m_di_data..MA_SPEC;
quit;
 
data &m_di_data..MA_SPEC;
attrib MODEL_GROUP_ID                      length=4                                            ;
attrib SPEC_NM                             length=$32                                          ;
attrib SPEC_VALUE                          length=$200                                         ;
attrib USER_NM                             length=$60                                          ;
stop; run;
 
proc sql;
alter table &m_di_data..MA_SPEC add CONSTRAINT PRIM_KEY PRIMARY KEY (MODEL_GROUP_ID, SPEC_NM, USER_NM);
quit;
 
proc sql;
INSERT INTO &m_di_data..MA_SPEC (MODEL_GROUP_ID, SPEC_NM, SPEC_VALUE, USER_NM)
VALUES (-1,'GP_SELECT_METHOD','inventory_cost','SEED');
INSERT INTO &m_di_data..MA_SPEC (MODEL_GROUP_ID, SPEC_NM, SPEC_VALUE, USER_NM)
VALUES (-1,'GP_SELECT_MODE','1','SEED');
INSERT INTO &m_di_data..MA_SPEC (MODEL_GROUP_ID, SPEC_NM, SPEC_VALUE, USER_NM)
VALUES (-1,'ERROR_PLOT_DISCARD_STD','3','SEED');
INSERT INTO &m_di_data..MA_SPEC (MODEL_GROUP_ID, SPEC_NM, SPEC_VALUE, USER_NM)
VALUES (-1,'HOLDOUT_PERIODS','4','SEED');
INSERT INTO &m_di_data..MA_SPEC (MODEL_GROUP_ID, SPEC_NM, SPEC_VALUE, USER_NM)
VALUES (-1,'HOLDOUT_DETAILS_PROD_LVL','1','SEED');
INSERT INTO &m_di_data..MA_SPEC (MODEL_GROUP_ID, SPEC_NM, SPEC_VALUE, USER_NM)
VALUES (-1,'HOLDOUT_DETAILS_GEO_LVL','1','SEED');
INSERT INTO &m_di_data..MA_SPEC (MODEL_GROUP_ID, SPEC_NM, SPEC_VALUE, USER_NM)
VALUES (-1,'PCT_TAIL_CUTOFF','1','SEED');
INSERT INTO &m_di_data..MA_SPEC (MODEL_GROUP_ID, SPEC_NM, SPEC_VALUE, USER_NM)
VALUES (-1,'MIN_LIFE_FILTER','8','SEED');
quit;
 
/* configuration tables */
 
proc sql;
DELETE FROM &m_di_data..MODEL_SPEC_DEFAULT WHERE MODEL_COMP_NM = 'MA';
INSERT INTO &m_di_data..MODEL_SPEC_DEFAULT
(SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('GP_SELECT_METHOD','MA','-1','inventory_cost',NULL);
INSERT INTO &m_di_data..MODEL_SPEC_DEFAULT
(SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('GP_SELECT_MODE','MA','-1','1',NULL);
INSERT INTO &m_di_data..MODEL_SPEC_DEFAULT
(SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('ERROR_PLOT_DISCARD_STD','MA','-1','3.0',NULL);
INSERT INTO &m_di_data..MODEL_SPEC_DEFAULT
(SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('HOLDOUT_PERIODS','MA','-1','4',NULL);
INSERT INTO &m_di_data..MODEL_SPEC_DEFAULT
(SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('HOLDOUT_DETAILS_PROD_LVL','MA','-1','1',NULL);
INSERT INTO &m_di_data..MODEL_SPEC_DEFAULT
(SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('HOLDOUT_DETAILS_GEO_LVL','MA','-1','1',NULL);
INSERT INTO &m_di_data..MODEL_SPEC_DEFAULT
(SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('PCT_TAIL_CUTOFF','MA','-1','1',NULL);
INSERT INTO &m_di_data..MODEL_SPEC_DEFAULT
(SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('MIN_LIFE_FILTER','MA','-1','8',NULL);
 
DELETE FROM &m_di_data..MODEL_SPEC_VALUES WHERE MODEL_COMP_NM = 'MA';
INSERT INTO &m_di_data..MODEL_SPEC_VALUES
(SPEC_NM,MODEL_COMP_NM,SPEC_VALUE,SPEC_VALUE_DESC,SPEC_VALUE_DESC_KEY)
VALUES ('GP_SELECT_METHOD','MA','inventory_cost','inventory cost','faspec.GP_SELECT_METHOD.pmeaning.inventory_cost.txt');
INSERT INTO &m_di_data..MODEL_SPEC_VALUES
(SPEC_NM,MODEL_COMP_NM,SPEC_VALUE,SPEC_VALUE_DESC,SPEC_VALUE_DESC_KEY)
VALUES ('GP_SELECT_METHOD','MA','inventory_units','inventory units','faspec.GP_SELECT_METHOD.pmeaning.inventory_units.txt');
INSERT INTO &m_di_data..MODEL_SPEC_VALUES
(SPEC_NM,MODEL_COMP_NM,SPEC_VALUE,SPEC_VALUE_DESC,SPEC_VALUE_DESC_KEY)
VALUES ('GP_SELECT_METHOD','MA','average_sales','average sales','faspec.GP_SELECT_METHOD.pmeaning.average_sales.txt');
INSERT INTO &m_di_data..MODEL_SPEC_VALUES
(SPEC_NM,MODEL_COMP_NM,SPEC_VALUE,SPEC_VALUE_DESC,SPEC_VALUE_DESC_KEY)
VALUES ('GP_SELECT_MODE','MA','1','FA process selects products and locations','faspec.GP_SELECT_MODE.pmeaning.1.txt');
INSERT INTO &m_di_data..MODEL_SPEC_VALUES
(SPEC_NM,MODEL_COMP_NM,SPEC_VALUE,SPEC_VALUE_DESC,SPEC_VALUE_DESC_KEY)
VALUES ('GP_SELECT_MODE','MA','2','all products and locations','faspec.GP_SELECT_MODE.pmeaning.2.txt');
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID695068;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID695068;
%put ERROR- Description                              : Change from the past;
%put ERROR- Version                                  : D2TKMI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID695068;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID695068",
"Change from the past",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID695068:;
 
 
* End of changes for CHANGE_ID:ID695068;
 
 
***********************************************************************************************;
*************************************  End Change ID695068 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID655358 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID655358;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID655358")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID655358;
%goto ID655358;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D2TKMI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID655358;
* Insert record into change management table for CHANGE_ID: ID655358;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID655358",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID655358;
 
%end;
 
 
 
 
 
proc sql noprint;
 
DELETE FROM &m_di_data..GLOBAL_SETTING where SPEC_NM = 'USE_SALES_FORECAST_MTS';
DELETE FROM &m_di_data..GLOBAL_SETTING_DETAILS where SPEC_NM = 'USE_SALES_FORECAST_MTS';
DELETE FROM &m_di_data..GLOBAL_SETTING_VALUES where SPEC_NM = 'USE_SALES_FORECAST_MTS';
DELETE FROM &m_di_data..GLOBAL_SETTING_GROUP_MEMBER where SPEC_NM = 'USE_SALES_FORECAST_MTS';
 
DELETE FROM &m_di_data..GLOBAL_SETTING where SPEC_NM = 'PRE_GP_ACCUM_DATE_SK';
DELETE FROM &m_di_data..GLOBAL_SETTING_DETAILS where SPEC_NM = 'PRE_GP_ACCUM_DATE_SK';
DELETE FROM &m_di_data..GLOBAL_SETTING_VALUES where SPEC_NM = 'PRE_GP_ACCUM_DATE_SK';
DELETE FROM &m_di_data..GLOBAL_SETTING_GROUP_MEMBER where SPEC_NM = 'PRE_GP_ACCUM_DATE_SK';
 
DROP TABLE &m_di_data..PROD_DATA_CONFIG;
 
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID655358;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID655358;
%put ERROR- Description                              : Change from the past;
%put ERROR- Version                                  : D2TKMI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID655358;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID655358",
"Change from the past",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID655358:;
 
 
* End of changes for CHANGE_ID:ID655358;
 
 
***********************************************************************************************;
*************************************  End Change ID655358 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID695068_1 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID695068_1;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID695068_1")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID695068_1;
%goto ID695068_1;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D2TKMI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID695068_1;
* Insert record into change management table for CHANGE_ID: ID695068_1;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID695068_1",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID695068_1;
 
%end;
 
 
 
 
 
/* SAS seed table */
proc sql;
INSERT INTO &m_di_data..MA_SPEC (MODEL_GROUP_ID, SPEC_NM, SPEC_VALUE, USER_NM)
VALUES (-1,'GP_SELECT_PCT_COVERAGE','75','SEED');
quit;
 
/* configuration tables */
proc sql;
DELETE FROM &m_di_data..MODEL_SPEC_DEFAULT WHERE SPEC_NM = 'GP_SELECT_PCT_COVERAGE';
INSERT INTO &m_di_data..MODEL_SPEC_DEFAULT
(SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('GP_SELECT_PCT_COVERAGE','MA','-1','75',NULL);
 
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID695068_1;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID695068_1;
%put ERROR- Description                              : Change from the past;
%put ERROR- Version                                  : D2TKMI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID695068_1;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID695068_1",
"Change from the past",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID695068_1:;
 
 
* End of changes for CHANGE_ID:ID695068_1;
 
 
***********************************************************************************************;
*************************************  End Change ID695068_1 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID696830 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID696830;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID696830")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID696830;
%goto ID696830;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D2TKMI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID696830;
* Insert record into change management table for CHANGE_ID: ID696830;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID696830",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID696830;
 
%end;
 
 
 
 
 
proc sql;
DELETE FROM &m_di_data..GLOBAL_SETTING where SPEC_NM = 'MAX_INMEM_GPS';
INSERT INTO &m_di_data..GLOBAL_SETTING
(SPEC_NM,APP,SPEC_VALUE,SPEC_DESC)
VALUES  ('MAX_INMEM_GPS','ALL','0',
'Specifies the maximum number of product-location pairs in model groups, markdown plans, and sub-partitions (defined by PARALLEL_PROD_LVL).');
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID696830;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID696830;
%put ERROR- Description                              : Change from the past;
%put ERROR- Version                                  : D2TKMI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID696830;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID696830",
"Change from the past",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID696830:;
 
 
* End of changes for CHANGE_ID:ID696830;
 
 
***********************************************************************************************;
*************************************  End Change ID696830 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID700983 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID700983;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID700983")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID700983;
%goto ID700983;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D2TKMI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID700983;
* Insert record into change management table for CHANGE_ID: ID700983;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID700983",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID700983;
 
%end;
 
 
 
 
 
proc sql;
UPDATE &m_di_data..MA_SPEC SET SPEC_VALUE = '8' WHERE SPEC_NM = 'HOLDOUT_PERIODS';
UPDATE &m_di_data..MODEL_SPEC_DEFAULT SET DEFAULT_SPEC_VALUE = '8'
WHERE SPEC_NM = 'HOLDOUT_PERIODS' AND MODEL_COMP_NM = 'MA';
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID700983;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID700983;
%put ERROR- Description                              : Change from the past;
%put ERROR- Version                                  : D2TKMI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID700983;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID700983",
"Change from the past",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID700983:;
 
 
* End of changes for CHANGE_ID:ID700983;
 
 
***********************************************************************************************;
*************************************  End Change ID700983 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID716071 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID716071;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID716071")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID716071;
%goto ID716071;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D2TKMI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID716071;
* Insert record into change management table for CHANGE_ID: ID716071;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID716071",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID716071;
 
%end;
 
 
 
 
 
proc sql;
DELETE FROM &m_di_data..MA_SPEC where SPEC_NM = 'LAST_INSAMPLE_WEEK';
INSERT INTO &m_di_data..MA_SPEC (MODEL_GROUP_ID, SPEC_NM, SPEC_VALUE, USER_NM)
VALUES (-1,'LAST_INSAMPLE_WEEK','','SEED');
 
DELETE FROM &m_di_data..MODEL_SPEC_DEFAULT where SPEC_NM = 'LAST_INSAMPLE_WEEK' AND MODEL_COMP_NM = 'MA';
INSERT INTO &m_di_data..MODEL_SPEC_DEFAULT
(SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('LAST_INSAMPLE_WEEK','MA','-1','',NULL);
 
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID716071;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID716071;
%put ERROR- Description                              : Change from the past;
%put ERROR- Version                                  : D2TKMI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID716071;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID716071",
"Change from the past",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID716071:;
 
 
* End of changes for CHANGE_ID:ID716071;
 
 
***********************************************************************************************;
*************************************  End Change ID716071 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID726837 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID726837;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID726837")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID726837;
%goto ID726837;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D2TKMI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID726837;
* Insert record into change management table for CHANGE_ID: ID726837;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID726837",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID726837;
 
%end;
 
 
 
 
 
proc sql;
DELETE FROM &m_di_data..GLOBAL_SETTING where SPEC_NM = 'PRE_GP_MPLN_ACCUM_DATE_SK';
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID726837;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID726837;
%put ERROR- Description                              : Change from the past;
%put ERROR- Version                                  : D2TKMI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID726837;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID726837",
"Change from the past",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID726837:;
 
 
* End of changes for CHANGE_ID:ID726837;
 
 
***********************************************************************************************;
*************************************  End Change ID726837 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID697407_1 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID697407_1;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID697407_1")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID697407_1;
%goto ID697407_1;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(M1MI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID697407_1;
* Insert record into change management table for CHANGE_ID: ID697407_1;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID697407_1",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID697407_1;
 
%end;
 
 
 
 
 
proc sql noprint;
* select count(*) into :cnt_faspec                  from &m_di_data..fa_spec;
select count(*) into :cnt_model_gp_status_spec    from &m_di_data..MODEL_GEO_PROD_STATUS_SPEC;
select count(*) into :cnt_model_gp_status_details from &m_di_data..MODEL_GEO_PROD_STATUS_DETAILS;
select count(*) into :cnt_model_gp_status_values  from &m_di_data..MODEL_GEO_PROD_STATUS_VALUES;
select count(*) into :cnt_model_gp_status_rules   from &m_di_data..MODEL_GEO_PROD_STATUS_RULE;
quit;
 
/*
%if (&cnt_faspec = 0) %then
%seed_fa_spec(libref=&libref.);
*/
%if (&cnt_model_gp_status_spec = 0) %then
%seed_model_gp_status_spec(libref=&libref.);
 
%if (&cnt_model_gp_status_details = 0) %then
%seed_model_gp_status_details(libref=&libref.);
 
%if (&cnt_model_gp_status_values = 0) %then
%seed_model_gp_status_values(libref=&libref.);
 
%if (&cnt_model_gp_status_rules = 0) %then
%seed_model_gp_status_rules(libref=&libref.);
 
 
 
* Check for errors while processing CHANGE_ID: ID697407_1;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID697407_1;
%put ERROR- Description                              : Change from the past;
%put ERROR- Version                                  : M1MI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID697407_1;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID697407_1",
"Change from the past",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID697407_1:;
 
 
* End of changes for CHANGE_ID:ID697407_1;
 
 
***********************************************************************************************;
*************************************  End Change ID697407_1 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID662097 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID662097;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID662097")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID662097;
%goto ID662097;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D2TKMI42,M1MI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID662097;
* Insert record into change management table for CHANGE_ID: ID662097;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID662097",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID662097;
 
%end;
 
 
 
 
***********************************************************************************************;
 
data &m_di_data..PRICING_RULES_COLUMN_META;
attrib PRICING_RULE_NUMBER                 length=4                                            ;
attrib TABLE_NAME                          length=$32                                         ;
attrib COL_NAME                            length=$32                                         ;
attrib COL_TYPE                            length=$4                                           ;
attrib CSV_COL_ORDER                       length=4                                            ;
attrib LENGTH                              length=6                                            ;
attrib FORMAT                              length=$50                                          ;
attrib INFORMAT                            length=$50                                          ;
attrib NOTNULL                             length=$3                                           ;
attrib CSV_RECORD_NUMBERS                  length=$10                                          ;
attrib EXPORT_TABLE_NAME                   length=$32                                          ;
attrib EXPORT_COL_NAME                     length=$32                                          ;
attrib EXPORT_COL_TYPE                     length=$4                                           ;
attrib EXPORT_LENGTH                       length=6                                            ;
attrib EXPORT_FORMAT                       length=$50                                          ;
attrib EXPORT_INFORMAT                     length=$50                                          ;
attrib IMPORT_RECORD_NUMBER                length=4                                            ;
attrib CSV_COL_NAME                        length=$32                                          ;
attrib COLUMN_CODE                         length=4                                            ;
attrib IMPORT_TABLE_NAME                   length=$32                                          ;
attrib IMPORT_COL_NAME                     length=$32                                          ;
attrib PRIMARY_KEY                         length=4                                            ;
stop; run;
 
proc sql;
alter table &m_di_data..PRICING_RULES_COLUMN_META add CONSTRAINT PRIM_KEY PRIMARY KEY (PRICING_RULE_NUMBER, TABLE_NAME, COL_NAME);
quit;
 
***********************************************************************************************;
 
data &m_di_data..PRICING_RULES_RULE_META;
attrib PRICING_RULE_NUMBER                 length=4                                            ;
attrib SPEC_NM                             length=$32                                          ;
attrib SPEC_MULTI                          length=6                                            ;
attrib COL_TYPE                            length=6                                            ;
attrib SPEC_VALUE                          length=$255                                         ;
attrib SPEC_DESC                           length=$255                                         ;
stop; run;
 
proc sql;
alter table &m_di_data..PRICING_RULES_RULE_META add CONSTRAINT PRIM_KEY PRIMARY KEY (PRICING_RULE_NUMBER, SPEC_NM, SPEC_MULTI);
quit;
 
 
***********************************************************************************************;
 
 
 
* Check for errors while processing CHANGE_ID: ID662097;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID662097;
%put ERROR- Description                              : Change from the past;
%put ERROR- Version                                  : D2TKMI42,M1MI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID662097;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID662097",
"Change from the past",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID662097:;
 
 
* End of changes for CHANGE_ID:ID662097;
 
 
***********************************************************************************************;
*************************************  End Change ID662097 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID664962 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID664962;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID664962")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID664962;
%goto ID664962;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(M1MI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID664962;
* Insert record into change management table for CHANGE_ID: ID664962;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID664962",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID664962;
 
%end;
 
 
 
 
 
proc sql;
DELETE FROM &m_di_data..field_lookup_values where (table_name='ALL' and field_nm='KPI_SK' and field_value='30');
INSERT INTO &m_di_data..field_lookup_values (table_name,field_nm,field_value,field_value_nm,field_value_desc,field_datatype)
VALUES ('ALL','KPI_SK','30','gm_amt_unweighted_min', 'gm_amt_unweighted_min', 'NUMERIC');
 
DELETE FROM &m_di_data..field_lookup_values where (table_name='ALL' and field_nm='KPI_SK' and field_value='31');
INSERT INTO &m_di_data..field_lookup_values (table_name,field_nm,field_value,field_value_nm,field_value_desc,field_datatype)
VALUES ('ALL','KPI_SK','31','gm_amt_unweighted_max', 'gm_amt_unweighted_max', 'NUMERIC');
 
DELETE FROM &m_di_data..field_lookup_values where (table_name='ALL' and field_nm='KPI_SK' and field_value='32');
INSERT INTO &m_di_data..field_lookup_values (table_name,field_nm,field_value,field_value_nm,field_value_desc,field_datatype)
VALUES ('ALL','KPI_SK','32','gm_pct_unweighted_min', 'gm_pct_unweighted_min', 'NUMERIC');
 
DELETE FROM &m_di_data..field_lookup_values where (table_name='ALL' and field_nm='KPI_SK' and field_value='33');
INSERT INTO &m_di_data..field_lookup_values (table_name,field_nm,field_value,field_value_nm,field_value_desc,field_datatype)
VALUES ('ALL','KPI_SK','33','gm_pct_unweighted_max', 'gm_pct_unweighted_max', 'NUMERIC');
quit;
 
 
* Check for errors while processing CHANGE_ID: ID664962;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID664962;
%put ERROR- Description                              : Change from the past;
%put ERROR- Version                                  : M1MI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID664962;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID664962",
"Change from the past",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID664962:;
 
 
* End of changes for CHANGE_ID:ID664962;
 
 
***********************************************************************************************;
*************************************  End Change ID664962 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID697407 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID697407;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID697407")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID697407;
%goto ID697407;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(M1MI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID697407;
* Insert record into change management table for CHANGE_ID: ID697407;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID697407",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID697407;
 
%end;
 
 
 
 
 
proc sql;
 
DELETE FROM &m_di_data..field_lookup_values where (table_name='ALL' and field_nm='RELATION_CD' and field_value='1');
INSERT INTO &m_di_data..field_lookup_values (table_name,field_nm,field_value,field_value_nm,field_value_desc,field_datatype)
VALUES  ('ALL','RELATION_CD','1','LIKE','LIKE PRODUCT','INTEGER');
 
DELETE FROM &m_di_data..field_lookup_values where (table_name='ALL' and field_nm='RELATION_CD' and field_value='2');
INSERT INTO &m_di_data..field_lookup_values (table_name,field_nm,field_value,field_value_nm,field_value_desc,field_datatype)
VALUES  ('ALL','RELATION_CD','2','REPLACE','REPLACED PRODUCT','INTEGER');
 
DELETE FROM &m_di_data..field_lookup_values where (table_name='ALL' and field_nm='RELATION_CD' and field_value='3');
INSERT INTO &m_di_data..field_lookup_values (table_name,field_nm,field_value,field_value_nm,field_value_desc,field_datatype)
VALUES  ('ALL','RELATION_CD','3','SPLIT','SPLITED PRODUCT','INTEGER');
 
DELETE FROM &m_di_data..field_lookup_values where (table_name='ALL' and field_nm='RELATION_CD' and field_value='4');
INSERT INTO &m_di_data..field_lookup_values (table_name,field_nm,field_value,field_value_nm,field_value_desc,field_datatype)
VALUES  ('ALL','RELATION_CD','4','MERGE','MERGED PRODUCT','INTEGER');
 
 
 
 
 
/* Condition_Type used in conditional promotion */
 
DELETE FROM &m_di_data..field_lookup_values
where (table_name='PROMOTION_FACT' and field_nm='CONDITION_TYPE' and field_value='0');
DELETE FROM &m_di_data..field_lookup_values
where (table_name='PROMOTION_FACT' and field_nm='CONDITION_TYPE' and field_value='1');
DELETE FROM &m_di_data..field_lookup_values
where (table_name='PROMOTION_FACT' and field_nm='CONDITION_TYPE' and field_value='2');
 
INSERT INTO &m_di_data..field_lookup_values (table_name,field_nm,field_value,field_value_nm,field_value_desc,field_datatype)
VALUES
('PROMOTION_FACT','CONDITION_TYPE','0','Unconditional','Unconditional promotions that apply to all products irrespective of whether the product is on regular price, promotion or on clearance.','INTEGER');
 
INSERT INTO &m_di_data..field_lookup_values (table_name,field_nm,field_value,field_value_nm,field_value_desc,field_datatype)
VALUES
('PROMOTION_FACT','CONDITION_TYPE','1','Conditional on Regular Price','Promotions conditional on whether the product is on regular price','INTEGER');
INSERT INTO &m_di_data..field_lookup_values (table_name,field_nm,field_value,field_value_nm,field_value_desc,field_datatype)
VALUES
('PROMOTION_FACT','CONDITION_TYPE','2','Conditional on Clearance Price','Promotions conditional on whether the product is on clearance','INTEGER');
quit;
 
 
 
 
 
 
* Check for errors while processing CHANGE_ID: ID697407;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID697407;
%put ERROR- Description                              : Change from the past;
%put ERROR- Version                                  : M1MI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID697407;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID697407",
"Change from the past",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID697407:;
 
 
* End of changes for CHANGE_ID:ID697407;
 
 
***********************************************************************************************;
*************************************  End Change ID697407 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change etl_seed_1 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: etl_seed_1;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("etl_seed_1")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : etl_seed_1;
%goto etl_seed_1;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(M1MI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : etl_seed_1;
* Insert record into change management table for CHANGE_ID: etl_seed_1;
proc sql;
insert  into di_data.data_model_change_management
values (
"etl_seed_1",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto etl_seed_1;
 
%end;
 
 
 
 
 
%let monExists = %sysfunc(libref(&m_di_mon.));
 
%if (&monExists = 0) %then
%do;
 
%if (%sysfunc(exist(&m_di_mon..job_param)))
%then %do;
 
proc sql noprint ;
DELETE FROM &m_di_mon..job_param where jobname = 'ALLJOBS' and param_name='etlp_exclude_recs_prev_export';
 
Insert into &m_di_mon..job_param
(jobname, param_name, param_value, default_func)
values("ALLJOBS",                             "etlp_exclude_recs_prev_export",   "0",                          '"0"'   )
;
quit;
proc sql noprint ;
DELETE FROM &m_di_mon..job_param where jobname = 'DI_EXPORT_RPP_PRICE' and param_name='Status_Cd';
DELETE FROM &m_di_mon..job_param where jobname = 'DI_EXPORT_RPP_PRICE' and param_name='Plan_State';
DELETE FROM &m_di_mon..job_param where jobname = 'DI_EXPORT_RPP_PRICE' and param_name='etlp_exclude_recs_prev_export';
 
Insert into &m_di_mon..job_param
(jobname, param_name, param_value, default_func)
values("DI_EXPORT_RPP_PRICE",                 "Status_Cd",                       "",                           '""'    )
values("DI_EXPORT_RPP_PRICE",                 "Plan_State",                      "",                           '""'    )
values("DI_EXPORT_RPP_PRICE",                 "etlp_exclude_recs_prev_export",   "",                           '"0"'   )
;
quit;
 
proc sql noprint ;
DELETE FROM &m_di_mon..job_param where jobname = 'LOAD_STG2DM_FUTURE_RECEIPT' and param_name='Full_refresh';
DELETE FROM &m_di_mon..job_param where jobname = 'LOAD_STG2DM_COST_FACT_FUTURE' and param_name='Full_refresh';
DELETE FROM &m_di_mon..job_param where jobname = 'LOAD_STG2DM_PACK_FUTURE_RECEIPT' and param_name='Full_refresh';
DELETE FROM &m_di_mon..job_param where jobname = 'LOAD_STG2DM_PRICE_FACT_FUTURE' and param_name='Full_refresh';
DELETE FROM &m_di_mon..job_param where jobname = 'LOAD_STG2DM_PRODUCT_ATTRIBUTES' and param_name='etlp_use_hash_lookup';
 
Insert into &m_di_mon..job_param
(jobname, param_name, param_value, default_func)
values("LOAD_STG2DM_FUTURE_RECEIPT",          "Full_refresh",                    "",                           '"0"'   )
values("LOAD_STG2DM_COST_FACT_FUTURE",        "Full_refresh",                    "",                           '"0"'   )
values("LOAD_STG2DM_PACK_FUTURE_RECEIPT",     "Full_refresh",                    "",                           '"0"'   )
values("LOAD_STG2DM_PRICE_FACT_FUTURE",       "Full_refresh",                    "",                           '"0"'   )
values("LOAD_STG2DM_PRODUCT_ATTRIBUTES",      "etlp_use_hash_lookup",            "1",                          '"1"'   )
;
quit;
 
%end;
 
%if (%sysfunc(exist(&m_di_mon..etl_sys_param)))
%then %do;
 
proc sql noprint ;
Select count(1) into :m_param_cnt
from &m_di_mon..etl_sys_param
where upcase(jobname)="DI_ETL_DELETE_HIERARCHY"
and lowcase(param_name) = "etlp_exception_table"
;
quit;
 
%if (&m_param_cnt = 0) %then
%do;
proc sql noprint ;
Insert into &m_di_mon..etl_sys_param
(jobname, param_name, param_value, default_func)
values("DI_ETL_DELETE_HIERARCHY",  "etlp_exception_table", "di_mon.STG_HIERARCHY_DELETE_X",  '"di_mon.STG_HIERARCHY_DELETE_X"'  )
;
quit;
%end;
 
proc sql noprint ;
update &m_di_mon..etl_sys_param set param_value = '"(1,2,3,4,10,11)"'
where upcase(jobname) = 'LOAD_STG2DM_SCOPE' and lowcase(param_name) = 'etlp_rpp_object_type'
;
 
update &m_di_mon..etl_sys_param set default_func = '"(1,2,3,4,10,11)"'
where upcase(jobname) = 'LOAD_STG2DM_SCOPE' and lowcase(param_name) = 'etlp_rpp_object_type'
;
quit;
 
%end;
 
%if (%sysfunc(exist(&m_di_mon..job_param)))
%then %do;
 
proc sql noprint ;
update &m_di_mon..job_param set param_value = '!SASROOT/misc/dibase/dbmsc/create_sas_datamart.sas'
where lowcase(param_name) = 'etlp_ddl_path'
;
 
update &m_di_mon..job_param set default_func = '"!SASROOT/misc/dibase/dbmsc/create_sas_datamart.sas"'
where lowcase(param_name) = 'etlp_ddl_path'
;
 
update &m_di_mon..job_param set default_func = '""'
where upcase(jobname) = 'DI_EXPORT_RPP_VEHICLE' and  upcase(param_name) = 'ETLP_VEHCAT'
;
quit;
 
proc sort data = &m_di_mon..job_param;
by jobname param_name;
quit;
 
proc sort data = &m_di_mon..etl_sys_param ;
by jobname param_name;
quit;
 
 
%end; /* job_param and etl_sys_param exist */
%end; /* if (&monExists = 0) */
 
 
 
* Check for errors while processing CHANGE_ID: etl_seed_1;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: etl_seed_1;
%put ERROR- Description                              : Change from the past;
%put ERROR- Version                                  : M1MI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: etl_seed_1;
proc sql;
insert  into di_data.data_model_change_management
values (
"etl_seed_1",
"Change from the past",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%etl_seed_1:;
 
 
* End of changes for CHANGE_ID:etl_seed_1;
 
 
***********************************************************************************************;
*************************************  End Change etl_seed_1 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change etl_stg_1 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: etl_stg_1;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("etl_stg_1")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : etl_stg_1;
%goto etl_stg_1;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(M1MI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : etl_stg_1;
* Insert record into change management table for CHANGE_ID: etl_stg_1;
proc sql;
insert  into di_data.data_model_change_management
values (
"etl_stg_1",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto etl_stg_1;
 
%end;
 
 
 
 
 
%let stageExists = %sysfunc(libref(DIDM_Stg));
 
%if (&stageExists = 0) %then
%do;
 
 
%if %sysfunc(exist(&m_didm_stg..STG_GEOGRAPHY_PARENT))
%then %do;
proc sql noprint ;
alter table &m_didm_stg..STG_GEOGRAPHY_PARENT drop constraint _NM0002_;
quit;
%end;
 
%if %sysfunc(exist(&m_didm_stg..STG_PROD_RELATION))
%then %do;
proc sql noprint ;
alter table &m_didm_stg..STG_PROD_RELATION
add ADJ_FACTOR NUM 8 FORMAT=NLNUM12.2 INFORMAT=NLNUM12.2 ;
quit;
%end;
 
%if %sysfunc(exist(&m_didm_stg..STG_PROMOTION))
%then %do;
proc sql noprint ;
alter table &m_didm_stg..STG_PROMOTION
add CONDITION_TYPE NUM 4,
RANGE_START_DISC_PCT NUM 8 FORMAT=NLNUM12.4 INFORMAT=NLNUM12.4,
RANGE_END_DISC_PCT NUM 8 FORMAT=NLNUM12.4 INFORMAT=NLNUM12.4 ;
quit;
%end;
 
 
%if %sysfunc(exist(&m_didm_stg..STG_RPP_PLAN))
%then %do;
proc sql noprint ;
alter table &m_didm_stg..STG_RPP_PLAN
add SUBSIDY_SCAN_AMT1 NUM 8 FORMAT=NLNUM20.3   INFORMAT=NLNUM20.3,
SUBSIDY_SCAN_TYPE1 NUM 4,
SUBSIDY_SCAN_AMT2 NUM 8 FORMAT=NLNUM20.3   INFORMAT=NLNUM20.3,
SUBSIDY_SCAN_TYPE2 NUM 4,
SUBSIDY_BILLBACK_AMT1 NUM 8 FORMAT=NLNUM20.3   INFORMAT=NLNUM20.3,
SUBSIDY_BILLBACK_AMT2 NUM 8 FORMAT=NLNUM20.3   INFORMAT=NLNUM20.3 ;
quit;
%end;
 
%if %sysfunc(exist(&m_didm_stg..STG_RPP_PLAN_PROD_ASGMNT))
%then %do;
proc sql noprint ;
alter table &m_didm_stg..STG_RPP_PLAN_PROD_ASGMNT
add SUBSIDY_SCAN_AMT1 NUM 8 FORMAT=NLNUM20.3   INFORMAT=NLNUM20.3,
SUBSIDY_SCAN_TYPE1 NUM 4,
SUBSIDY_SCAN_AMT2 NUM 8 FORMAT=NLNUM20.3   INFORMAT=NLNUM20.3,
SUBSIDY_SCAN_TYPE2 NUM 4,
SUBSIDY_BILLBACK_AMT1 NUM 8 FORMAT=NLNUM20.3   INFORMAT=NLNUM20.3,
SUBSIDY_BILLBACK_AMT2 NUM 8 FORMAT=NLNUM20.3   INFORMAT=NLNUM20.3 ;
quit;
%end;
 
data &m_didm_stg..STG_HIERARCHY_DELETE;
attrib DIMENSION_TYPE                            length=$40                                    ;
attrib HIER_ASSOC_CD                             length=4                                      ;
stop; run;
 
proc sql noprint ;
alter table &m_didm_stg..STG_HIERARCHY_DELETE add NOT NULL (DIMENSION_TYPE);
alter table &m_didm_stg..STG_HIERARCHY_DELETE add NOT NULL (HIER_ASSOC_CD);
quit;
 
data &m_didm_stg..STG_PRODUCT_REPLACEMENT;
attrib ORIG_PROD_ID                         length=$32                                          ;
attrib NEW_PROD_ID                          length=$32                                          ;
stop; run;
 
proc sql noprint ;
alter table &m_didm_stg..STG_PRODUCT_REPLACEMENT add NOT NULL (ORIG_PROD_ID);
alter table &m_didm_stg..STG_PRODUCT_REPLACEMENT add NOT NULL (NEW_PROD_ID);
quit;
 
 
%end;
 
 
 
* Check for errors while processing CHANGE_ID: etl_stg_1;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: etl_stg_1;
%put ERROR- Description                              : Change from the past;
%put ERROR- Version                                  : M1MI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: etl_stg_1;
proc sql;
insert  into di_data.data_model_change_management
values (
"etl_stg_1",
"Change from the past",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%etl_stg_1:;
 
 
* End of changes for CHANGE_ID:etl_stg_1;
 
 
***********************************************************************************************;
*************************************  End Change etl_stg_1 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ddl_mon_1 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ddl_mon_1;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ddl_mon_1")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ddl_mon_1;
%goto ddl_mon_1;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(M1MI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ddl_mon_1;
* Insert record into change management table for CHANGE_ID: ddl_mon_1;
proc sql;
insert  into di_data.data_model_change_management
values (
"ddl_mon_1",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ddl_mon_1;
 
%end;
 
 
 
 
 
%let monExists = %sysfunc(libref(&m_di_mon.));
 
%if (&monExists = 0) %then
%do;
 
 
data &m_di_mon..EXPORT_HISTORY ;
attrib EXPORTNAME length=$80 label='Export name' ;
attrib USER length=$32 label='User id' ;
attrib ROWSEXPORTED length=8 label='No. of Records exported' ;
attrib EXPORTTIME length=8 format=&m_dttmfmt label='Date and time of this export' ;
stop; run;
 
%if %sysfunc(exist(&m_di_mon..STG_PROD_RELATION_X))
%then %do;
proc sql noprint ;
alter table &m_di_mon..STG_PROD_RELATION_X
add ADJ_FACTOR NUM 8 FORMAT=NLNUM12.2 INFORMAT=NLNUM12.2 ;
quit;
%end;
 
%if %sysfunc(exist(&m_di_mon..STG_PROMOTION_X))
%then %do;
proc sql;
alter table &m_di_mon..STG_PROMOTION_X
add CONDITION_TYPE NUM 4,
RANGE_START_DISC_PCT  NUM 8 FORMAT=NLNUM12.4 INFORMAT=NLNUM12.4,
RANGE_END_DISC_PCT    NUM 8 FORMAT=NLNUM12.4 INFORMAT=NLNUM12.4
;
 
alter table &m_di_mon..STG_PROMOTION_X
modify END_DT FORMAT=&m_DTFMT
modify ETLS_EXCEPTION_COND char(350) ;
quit;
%end;
 
%if %sysfunc(exist(&m_di_mon..STG_RPP_PLAN_X))
%then %do;
proc sql;
alter table &m_di_mon..STG_RPP_PLAN_X
add SCAN_AMT1 NUM 8 FORMAT=NLNUM20.3   INFORMAT=NLNUM20.3,
SCAN_TYPE1    NUM 4,
SCAN_AMT2     NUM 8 FORMAT=NLNUM20.3   INFORMAT=NLNUM20.3,
SCAN_TYPE2    NUM 4,
SUBSIDY_SCAN_AMT1 NUM 8 FORMAT=NLNUM20.3   INFORMAT=NLNUM20.3,
SUBSIDY_SCAN_TYPE1 NUM 4,
SUBSIDY_SCAN_AMT2 NUM 8 FORMAT=NLNUM20.3   INFORMAT=NLNUM20.3,
SUBSIDY_SCAN_TYPE2 NUM 4,
SUBSIDY_BILLBACK_AMT1 NUM 8 FORMAT=NLNUM20.3   INFORMAT=NLNUM20.3,
SUBSIDY_BILLBACK_AMT2 NUM 8 FORMAT=NLNUM20.3   INFORMAT=NLNUM20.3
;
quit;
%end;
 
 
data &m_di_mon..STG_HIERARCHY_DELETE_X;
attrib DIMENSION_TYPE length=$40 ;
attrib HIER_ASSOC_CD length=4 ;
attrib ETLS_EXCEPTION_COND length = $100 ;
attrib ETL_ERROR_JOBRUNTIME length = 8 format =&m_dttmfmt ;
stop; run;
 
data &m_di_mon..STG_PRODUCT_REPLACEMENT_X;
attrib ORIG_PROD_ID length=$32 ;
attrib NEW_PROD_ID length=$32 ;
attrib ETLS_EXCEPTION_COND length = $100 ;
attrib ETL_ERROR_JOBRUNTIME length = 8 format =&m_dttmfmt ;
stop; run;
 
data &m_di_mon..PURGE_RESULT_TABLE;
attrib TABLE_NM length=$32 ;
attrib BEFORE_ROWS length = 4;
attrib AFTER_ROWS length = 4;
attrib PURGE_DTTM length = 8 format=&m_dttmfmt;
stop; run;
 
%end;
 
 
 
* Check for errors while processing CHANGE_ID: ddl_mon_1;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ddl_mon_1;
%put ERROR- Description                              : Change from the past;
%put ERROR- Version                                  : M1MI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ddl_mon_1;
proc sql;
insert  into di_data.data_model_change_management
values (
"ddl_mon_1",
"Change from the past",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ddl_mon_1:;
 
 
* End of changes for CHANGE_ID:ddl_mon_1;
 
 
***********************************************************************************************;
*************************************  End Change ddl_mon_1 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID703736 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID703736;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID703736")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID703736;
%goto ID703736;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(M1MI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID703736;
* Insert record into change management table for CHANGE_ID: ID703736;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID703736",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID703736;
 
%end;
 
 
 
 
 
proc sql;
DELETE FROM &m_di_data..GLOBAL_SETTING where SPEC_NM = 'ALLOW_MULTI_STYLE_PACK_REC';
INSERT INTO &m_di_data..global_setting (SPEC_NM,APP,SPEC_VALUE,SPEC_DESC)
VALUES  ('ALLOW_MULTI_STYLE_PACK_REC','SZPK','0','Specifies whether recommended packs can include more than one style-color pair');
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID703736;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID703736;
%put ERROR- Description                              : Change from the past;
%put ERROR- Version                                  : M1MI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID703736;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID703736",
"Change from the past",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID703736:;
 
 
* End of changes for CHANGE_ID:ID703736;
 
 
***********************************************************************************************;
*************************************  End Change ID703736 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID698072 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID698072;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID698072")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID698072;
%goto ID698072;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(M1MI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID698072;
* Insert record into change management table for CHANGE_ID: ID698072;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID698072",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID698072;
 
%end;
 
 
 
 
 
proc sql;
DELETE FROM &m_di_data..GLOBAL_SETTING WHERE SPEC_NM = 'PROFILE_AVG_CLUSTER';
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID698072;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID698072;
%put ERROR- Description                              : Change from the past;
%put ERROR- Version                                  : M1MI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID698072;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID698072",
"Change from the past",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID698072:;
 
 
* End of changes for CHANGE_ID:ID698072;
 
 
***********************************************************************************************;
*************************************  End Change ID698072 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID713209 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID713209;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID713209")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID713209;
%goto ID713209;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(M1MI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID713209;
* Insert record into change management table for CHANGE_ID: ID713209;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID713209",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID713209;
 
%end;
 
 
 
 
proc sql noprint;
delete from &m_di_data..field_lookup_values
where table_name='RPO_PLAN_MEMBER'
and field_nm='APPROVAL_REASON_CD'
and field_value='0'
;
 
INSERT INTO &m_di_data..field_lookup_values
(table_name,field_nm,field_value,field_value_nm,field_value_desc,field_datatype)
VALUES  ('RPO_PLAN_MEMBER','APPROVAL_REASON_CD','0','None','No approval reason','INTEGER');
quit;
 
 
* Check for errors while processing CHANGE_ID: ID713209;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID713209;
%put ERROR- Description                              : Change from the past;
%put ERROR- Version                                  : M1MI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID713209;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID713209",
"Change from the past",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID713209:;
 
 
* End of changes for CHANGE_ID:ID713209;
 
 
***********************************************************************************************;
*************************************  End Change ID713209 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID696903 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID696903;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID696903")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID696903;
%goto ID696903;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(M1MI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID696903;
* Insert record into change management table for CHANGE_ID: ID696903;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID696903",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID696903;
 
%end;
 
 
 
 
 
proc sql;
DELETE FROM &m_di_data..GLOBAL_SETTING WHERE SPEC_NM = 'ALLOW_MULTI_STYLE_PACK_REC';
INSERT INTO &m_di_data..GLOBAL_SETTING (SPEC_NM,APP,SPEC_VALUE,SPEC_DESC)
VALUES  ('ALLOW_MULTI_STYLE_PACK_REC','SZPK','0',
'Specifies whether recommended packs can include more than one style-color pair.');
UPDATE &m_di_data..GLOBAL_SETTING_DETAILS SET EDITABLE_FLG = 1, REQUIRED_FLG = 1
WHERE SPEC_NM = 'ALLOW_MULTI_STYLE_PACK_REC';
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID696903;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID696903;
%put ERROR- Description                              : Change from the past;
%put ERROR- Version                                  : M1MI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID696903;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID696903",
"Change from the past",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID696903:;
 
 
* End of changes for CHANGE_ID:ID696903;
 
 
***********************************************************************************************;
*************************************  End Change ID696903 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID713182 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID713182;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID713182")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID713182;
%goto ID713182;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(M1MI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID713182;
* Insert record into change management table for CHANGE_ID: ID713182;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID713182",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID713182;
 
%end;
 
 
 
 
 
proc sql;
DELETE FROM &m_di_data..MODEL_SPEC WHERE SPEC_NM = 'HEDONIC_VOL_TSF';
INSERT INTO &m_di_data..MODEL_SPEC (MODEL_GROUP_ID,MODEL_COMP_NM,SPEC_NM,SPEC_TYPE,SPEC_VALUE,PRIORITY,CREATED_DTTM,CREATED_BY)
VALUES  (-1,'ALL','HEDONIC_VOL_TSF','-1','1',NULL,NULL,'SEED');
 
DELETE FROM &m_di_data..MODEL_SPEC_DEFAULT WHERE SPEC_NM = 'HEDONIC_VOL_TSF';
INSERT INTO &m_di_data..MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('HEDONIC_VOL_TSF','ALL','-1','1',NULL);
 
quit;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID713182;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID713182;
%put ERROR- Description                              : Change from the past;
%put ERROR- Version                                  : M1MI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID713182;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID713182",
"Change from the past",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID713182:;
 
 
* End of changes for CHANGE_ID:ID713182;
 
 
***********************************************************************************************;
*************************************  End Change ID713182 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID718981 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID718981;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID718981")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID718981;
%goto ID718981;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(M1MI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID718981;
* Insert record into change management table for CHANGE_ID: ID718981;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID718981",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID718981;
 
%end;
 
 
 
 
%let monExists = %sysfunc(libref(&m_di_mon.));
%if (&monExists = 0) %then %do;
%if (%sysfunc(exist(&m_di_mon..job_param))) %then %do;
proc sql ;
DELETE FROM &m_di_mon..job_param  WHERE jobname = 'LOAD_STG2DM_COST_FACT' and param_name="etlp_move_futr_to_curr";
DELETE FROM &m_di_mon..job_param  WHERE jobname = 'LOAD_STG2DM_PRICE_FACT' and param_name="etlp_move_futr_to_curr";
 
Insert into &m_di_mon..job_param
(jobname, param_name, param_value, default_func)
values("LOAD_STG2DM_COST_FACT",               "etlp_move_futr_to_curr",          "",                           '"0"'   )
values("LOAD_STG2DM_PRICE_FACT",              "etlp_move_futr_to_curr",          "",                           '"0"'   )
;
quit;
%end;
%end;
 
 
* Check for errors while processing CHANGE_ID: ID718981;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID718981;
%put ERROR- Description                              : Change from the past;
%put ERROR- Version                                  : M1MI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID718981;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID718981",
"Change from the past",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID718981:;
 
 
* End of changes for CHANGE_ID:ID718981;
 
 
***********************************************************************************************;
*************************************  End Change ID718981 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID679287 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID679287;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID679287")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID679287;
%goto ID679287;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(M1MI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID679287;
* Insert record into change management table for CHANGE_ID: ID679287;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID679287",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID679287;
 
%end;
 
 
 
 
 
proc sql;
DELETE FROM &m_di_data..GLOBAL_SETTING WHERE SPEC_NM = 'GENERATED_BULK_PACK_PREFIX';
INSERT INTO &m_di_data..GLOBAL_SETTING (SPEC_NM,APP,SPEC_VALUE,SPEC_DESC)
VALUES  ('GENERATED_BULK_PACK_PREFIX','SZPK','GB',
'Prefix added to generated bulk packs (limited to 4 alphanumeric characters).');
 
 
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID679287;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID679287;
%put ERROR- Description                              : Change from the past;
%put ERROR- Version                                  : M1MI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID679287;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID679287",
"Change from the past",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID679287:;
 
 
* End of changes for CHANGE_ID:ID679287;
 
 
***********************************************************************************************;
*************************************  End Change ID679287 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID726328 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID726328;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID726328")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID726328;
%goto ID726328;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(M1MI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID726328;
* Insert record into change management table for CHANGE_ID: ID726328;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID726328",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID726328;
 
%end;
 
 
 
 
 
proc sql;
DELETE FROM &m_di_data..MODEL_SPEC_DEFAULT where SPEC_NM = 'EXCLUDE_NP_FROM_SHARE';
INSERT INTO &m_di_data..MODEL_SPEC_DEFAULT
(SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('EXCLUDE_NP_FROM_SHARE','FCST','2','0',NULL);
 
 
quit;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID726328;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID726328;
%put ERROR- Description                              : Change from the past;
%put ERROR- Version                                  : M1MI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID726328;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID726328",
"Change from the past",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID726328:;
 
 
* End of changes for CHANGE_ID:ID726328;
 
 
***********************************************************************************************;
*************************************  End Change ID726328 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID719510 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID719510;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID719510")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID719510;
%goto ID719510;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(M1MI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID719510;
* Insert record into change management table for CHANGE_ID: ID719510;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID719510",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID719510;
 
%end;
 
 
 
 
 
%if %sysfunc(exist(&m_di_mon..job_param)) %then
%do;
 
proc sql noprint;
select count(*) into :m_rpp_price_exp_parms
from &m_di_mon..job_param
where upcase(jobname)="DI_EXPORT_RPP_PRICE"
and param_name in ("etlp_export_at_lowest_prod_geo")
;
quit;
 
%if (&m_rpp_price_exp_parms <= 0) %then
%do;
proc sql noprint;
insert into &m_di_mon..job_param
(jobname, param_name, param_value, default_func)
values("DI_EXPORT_RPP_PRICE",    "etlp_export_at_lowest_prod_geo",    "",    '""'   )
;
quit;
%end;
%end;
 
 
%if %sysfunc(exist(&m_di_mon..job_param)) %then
%do;
 
proc sql noprint;
select count(*) into :m_rpp_veh_exp_parms
from &m_di_mon..job_param
where upcase(jobname)="DI_EXPORT_RPP_VEHICLE"
and param_name in ("etlp_export_at_lowest_prod_geo")
;
quit;
 
%if (&m_rpp_veh_exp_parms <= 0) %then
%do;
proc sql noprint;
insert into &m_di_mon..job_param
(jobname, param_name, param_value, default_func)
values("DI_EXPORT_RPP_VEHICLE",    "etlp_export_at_lowest_prod_geo",    "",    '""'   )
;
quit;
%end;
%end;
 
 
 
* Check for errors while processing CHANGE_ID: ID719510;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID719510;
%put ERROR- Description                              : Change from the past;
%put ERROR- Version                                  : M1MI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID719510;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID719510",
"Change from the past",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID719510:;
 
 
* End of changes for CHANGE_ID:ID719510;
 
 
***********************************************************************************************;
*************************************  End Change ID719510 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change rem_vndr0 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: rem_vndr0;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("rem_vndr0")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : rem_vndr0;
%goto rem_vndr0;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(M1MI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : rem_vndr0;
* Insert record into change management table for CHANGE_ID: rem_vndr0;
proc sql;
insert  into di_data.data_model_change_management
values (
"rem_vndr0",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto rem_vndr0;
 
%end;
 
 
 
 
proc sql;
DELETE FROM &m_di_data..VENDOR WHERE VENDOR_SK = 0 and VENDOR_ID='0';
quit;
 
 
* Check for errors while processing CHANGE_ID: rem_vndr0;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: rem_vndr0;
%put ERROR- Description                              : Change from the past;
%put ERROR- Version                                  : M1MI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: rem_vndr0;
proc sql;
insert  into di_data.data_model_change_management
values (
"rem_vndr0",
"Change from the past",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%rem_vndr0:;
 
 
* End of changes for CHANGE_ID:rem_vndr0;
 
 
***********************************************************************************************;
*************************************  End Change rem_vndr0 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change etl_seed_2 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: etl_seed_2;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("etl_seed_2")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : etl_seed_2;
%goto etl_seed_2;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(M1MI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : etl_seed_2;
* Insert record into change management table for CHANGE_ID: etl_seed_2;
proc sql;
insert  into di_data.data_model_change_management
values (
"etl_seed_2",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto etl_seed_2;
 
%end;
 
 
 
 
 
%let monExists = %sysfunc(libref(&m_di_mon.));
 
%if (&monExists = 0) %then
%do;
 
%if (%sysfunc(exist(&m_di_mon..etl_sys_param)))
%then %do;
 
proc sql noprint ;
Select count(1) into :m_param_cnt
from &m_di_mon..etl_sys_param
where upcase(jobname)="DI_ETL_DELETE_HIERARCHY"
and lowcase(param_name) = "etlp_exception_table"
;
quit;
 
%if (&m_param_cnt = 0) %then
%do;
proc sql noprint ;
Insert into &m_di_mon..etl_sys_param
(jobname, param_name, param_value, default_func)
values("DI_ETL_DELETE_HIERARCHY",  "etlp_exception_table", "di_mon.STG_HIERARCHY_DELETE_X",  '"di_mon.STG_HIERARCHY_DELETE_X"'  )
;
quit;
%end;
%end;
%end; /* if (&monExists = 0) */
 
 
 
* Check for errors while processing CHANGE_ID: etl_seed_2;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: etl_seed_2;
%put ERROR- Description                              : Change from the past;
%put ERROR- Version                                  : M1MI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: etl_seed_2;
proc sql;
insert  into di_data.data_model_change_management
values (
"etl_seed_2",
"Change from the past",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%etl_seed_2:;
 
 
* End of changes for CHANGE_ID:etl_seed_2;
 
 
***********************************************************************************************;
*************************************  End Change etl_seed_2 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change etl_seed_3 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: etl_seed_3;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("etl_seed_3")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : etl_seed_3;
%goto etl_seed_3;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(M1MI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : etl_seed_3;
* Insert record into change management table for CHANGE_ID: etl_seed_3;
proc sql;
insert  into di_data.data_model_change_management
values (
"etl_seed_3",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto etl_seed_3;
 
%end;
 
 
 
 
 
%let monExists = %sysfunc(libref(&m_di_mon.));
 
%if (&monExists = 0) %then
%do;
 
%if (%sysfunc(exist(&m_di_mon..job_param)))
%then %do;
 
proc sql noprint ;
Select count(1) into :m_param_cnt
from &m_di_mon..job_param
where upcase(jobname)="DI_EXPORT_RPP_VEHICLE"
and lowcase(param_name) = "etlp_exclude_recs_prev_export"
;
quit;
 
%if (&m_param_cnt = 0) %then
%do;
proc sql noprint ;
Insert into &m_di_mon..job_param
(jobname, param_name, param_value, default_func)
values("DI_EXPORT_RPP_VEHICLE",                 "etlp_exclude_recs_prev_export",   "",                           '"0"'   )
;
quit;
%end;
%end;
 
%end; /* if (&monExists = 0) */
 
 
 
* Check for errors while processing CHANGE_ID: etl_seed_3;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: etl_seed_3;
%put ERROR- Description                              : Change from the past;
%put ERROR- Version                                  : M1MI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: etl_seed_3;
proc sql;
insert  into di_data.data_model_change_management
values (
"etl_seed_3",
"Change from the past",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%etl_seed_3:;
 
 
* End of changes for CHANGE_ID:etl_seed_3;
 
 
***********************************************************************************************;
*************************************  End Change etl_seed_3 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID722967 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID722967;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID722967")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID722967;
%goto ID722967;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(M1MI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID722967;
* Insert record into change management table for CHANGE_ID: ID722967;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID722967",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID722967;
 
%end;
 
 
 
 
 
proc sql;
DELETE FROM &m_di_data..field_lookup_values where (table_name='ALL' and field_nm='KPI_SK' and field_value='30');
DELETE FROM &m_di_data..field_lookup_values where (table_name='ALL' and field_nm='KPI_SK' and field_value='31');
DELETE FROM &m_di_data..field_lookup_values where (table_name='ALL' and field_nm='KPI_SK' and field_value='32');
DELETE FROM &m_di_data..field_lookup_values where (table_name='ALL' and field_nm='KPI_SK' and field_value='33');
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID722967;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID722967;
%put ERROR- Description                              : Change from the past;
%put ERROR- Version                                  : M1MI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID722967;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID722967",
"Change from the past",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID722967:;
 
 
* End of changes for CHANGE_ID:ID722967;
 
 
***********************************************************************************************;
*************************************  End Change ID722967 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID727229 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID727229;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID727229")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID727229;
%goto ID727229;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(M1MI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID727229;
* Insert record into change management table for CHANGE_ID: ID727229;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID727229",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID727229;
 
%end;
 
 
 
 
 
%let monExists = %sysfunc(libref(&m_di_mon.));
 
%if (&monExists = 0) %then
%do;
 
%if (%sysfunc(exist(&m_di_mon..etl_sys_param)))
%then %do;
 
proc sql noprint ;
update &m_di_mon..etl_sys_param
set param_value = '(1,2,3,4,10,11)'
where      upcase(jobname)    = 'LOAD_STG2DM_SCOPE'
and lowcase(param_name) = 'etlp_rpp_object_type'
;
 
quit;
 
%end;
 
%end; /* if (&monExists = 0) */
 
 
 
* Check for errors while processing CHANGE_ID: ID727229;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID727229;
%put ERROR- Description                              : Change from the past;
%put ERROR- Version                                  : M1MI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID727229;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID727229",
"Change from the past",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID727229:;
 
 
* End of changes for CHANGE_ID:ID727229;
 
 
***********************************************************************************************;
*************************************  End Change ID727229 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID737056 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID737056;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID737056")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID737056;
%goto ID737056;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID737056;
* Insert record into change management table for CHANGE_ID: ID737056;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID737056",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID737056;
 
%end;
 
 
 
 
 
 
data _geo_date_old;
set &m_di_data..GEO_DATE;
PROD_HIER_SK = 1;
run;
data &m_di_data..GEO_DATE;
attrib GEO_HIER_SK                         length=4                                            ;
attrib PROD_HIER_SK                        length=6                                            ;
attrib GEO_DATE_TYPE                       length=4                                            ;
attrib START_DT                            length=8      FORMAT=&m_DTFMT      INFORMAT=&m_DTFMT    ;
attrib GEO_DATE_ID                         length=4                                            ;
attrib GEO_DATE_NM                         length=$40                                          ;
attrib END_DT                              length=8      FORMAT=&m_DTFMT      INFORMAT=&m_DTFMT    ;
stop; run;
 
proc sql;
alter table &m_di_data..GEO_DATE add CONSTRAINT PRIM_KEY PRIMARY KEY (GEO_HIER_SK, PROD_HIER_SK, GEO_DATE_TYPE, START_DT);
alter table &m_di_data..GEO_DATE add NOT NULL (END_DT);
quit;
 
proc sql;
CREATE INDEX GEO_DATE_IX1 ON &m_di_data..GEO_DATE(GEO_HIER_SK, GEO_DATE_TYPE);
quit;
proc append base=&m_di_data..GEO_DATE data=_geo_date_old force; quit;
proc sql; drop table _geo_date_old; quit;
 
 
 
 
data &m_di_data..DOW_SALES_FACT;
attrib PROD_HIER_SK                        length=6                                            ;
attrib GEO_HIER_SK                         length=4                                            ;
attrib DATE_SK                             length=4                                            ;
attrib DAY_OF_WEEK                         length=4                                            ;
attrib SALES_UNITS                         length=8      FORMAT=NLNUM12.2   INFORMAT=NLNUM12.2 ;
attrib SALES_AMT                           length=8      FORMAT=NLNUM20.3   INFORMAT=NLNUM20.3 ;
stop; run;
 
proc sql;
alter table &m_di_data..DOW_SALES_FACT add CONSTRAINT PRIM_KEY PRIMARY KEY (PROD_HIER_SK, GEO_HIER_SK, DATE_SK, DAY_OF_WEEK);
alter table &m_di_data..DOW_SALES_FACT add NOT NULL (SALES_UNITS);
alter table &m_di_data..DOW_SALES_FACT add NOT NULL (SALES_AMT);
quit;
 
 
 
data &m_di_data..DOW_EVENT_SALES_FACT;
attrib PROD_HIER_SK                        length=6                                            ;
attrib GEO_HIER_SK                         length=4                                            ;
attrib DATE_SK                             length=4                                            ;
attrib DAY_OF_WEEK                         length=4                                            ;
attrib SALES_UNITS                         length=8      FORMAT=NLNUM12.2   INFORMAT=NLNUM12.2 ;
attrib SALES_AMT                           length=8      FORMAT=NLNUM20.3   INFORMAT=NLNUM20.3 ;
stop; run;
 
proc sql;
alter table &m_di_data..DOW_EVENT_SALES_FACT add CONSTRAINT PRIM_KEY PRIMARY KEY (PROD_HIER_SK, GEO_HIER_SK, DATE_SK, DAY_OF_WEEK);
alter table &m_di_data..DOW_EVENT_SALES_FACT add NOT NULL (SALES_UNITS);
alter table &m_di_data..DOW_EVENT_SALES_FACT add NOT NULL (SALES_AMT);
quit;
 
 
data _model_geo_prod;
set &m_di_data..MODEL_GEO_PROD;
run;
data &m_di_data..MODEL_GEO_PROD;
attrib GEO_HIER_SK                         length=4                                            ;
attrib PROD_HIER_SK                        length=6                                            ;
attrib MODEL_GROUP_ID                      length=4                                            ;
attrib CLASS_CD                            length=4                                            ;
attrib DOW_GROUP_ID                        length=4                                            ;
stop; run;
proc sql;
CREATE INDEX MODEL_GROUP_ID ON &m_di_data..MODEL_GEO_PROD(MODEL_GROUP_ID);
CREATE INDEX MODEL_GEO_PROD ON &m_di_data..MODEL_GEO_PROD(GEO_HIER_SK, PROD_HIER_SK);
quit;
proc append base=&m_di_data..MODEL_GEO_PROD data=_model_geo_prod force; quit;
proc sql; drop table _model_geo_prod; quit;
 
 
 
data &m_di_data..DOW_PROFILE;
attrib MODEL_GROUP_ID                      length=4                                            ;
attrib DOW_GROUP_ID                        length=4                                            ;
attrib DAY_OF_WEEK                         length=4                                            ;
attrib DISTRIBUTION_PCT                    length=8     FORMAT=NLNUM12.4   INFORMAT=NLNUM12.4  ;
stop; run;
 
proc sql;
alter table &m_di_data..DOW_PROFILE add CONSTRAINT PRIM_KEY PRIMARY KEY (MODEL_GROUP_ID, DOW_GROUP_ID, DAY_OF_WEEK);
quit;
 
 
 
data &m_di_data..DOW_PROD_GEO_GROUP_ATTR;
attrib MODEL_GROUP_ID                      length=4                                            ;
attrib DOW_GROUP_ID                        length=4                                            ;
attrib ATTR_SK                             length=4                                            ;
attrib ATTR_VALUE                          length=$40                                          ;
attrib STAT_VALUE                          length=8     FORMAT=NLNUM12.4   INFORMAT=NLNUM12.4  ;
stop; run;
 
proc sql;
alter table &m_di_data..DOW_PROD_GEO_GROUP_ATTR add CONSTRAINT PRIM_KEY PRIMARY KEY (MODEL_GROUP_ID, DOW_GROUP_ID, ATTR_SK);
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID737056;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID737056;
%put ERROR- Description                              : DOW Profiling Schema Changes;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 11FEB2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID737056;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID737056",
"DOW Profiling Schema Changes",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID737056:;
 
 
* End of changes for CHANGE_ID:ID737056;
 
 
***********************************************************************************************;
*************************************  End Change ID737056 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID724371 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID724371;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID724371")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(DI_MON)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: DI_MON;
%put NOTE- Change ID                             :ID724371;
%goto ID724371;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID724371;
%goto ID724371;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID724371;
* Insert record into change management table for CHANGE_ID: ID724371;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID724371",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID724371;
 
%end;
 
 
 
 
 
 
%if %sysfunc(exist(&m_di_mon..job_param))
%then %do;
 
data temp_job_param;
attrib jobname length=$80 param_name length=$32 param_value length=$160 default_func length=$160 ;
jobname='LOAD_STG2DM_MDO_IMPORT_PLAN'; param_name='etlp_refresh_mdo_plan_group'; param_value='';default_func ='"1"';output;
jobname='LOAD_STG2DM_MDO_IMPORT_PLAN'; param_name='invalid_mbr_err_threshold_pct'; param_value='';default_func ='"0.15"';output;
jobname='LOAD_STG2DM_MDO_IMPORT_PLAN'; param_name='etlp_num_parallel_geo_prods'; param_value='';default_func ='"8"';output;
run;
 
data &m_di_mon..job_param;
set temp_job_param(rename=(param_value=etls_0 default_func=etls_1));
 
modify &m_di_mon..job_param key=PRIM_KEY;
param_value=etls_0 ;
default_func=etls_1;
 
if _iorc_ = 0 then do;
replace;
end;
else do;
output;
end;
 
_iorc_ = 0; _error_ = 0;
run;
 
%end;
 
 
 
* Check for errors while processing CHANGE_ID: ID724371;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID724371;
%put ERROR- Description                              : Add new job parameter for MDO Import;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 07MAR2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID724371;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID724371",
"Add new job parameter for MDO Import",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID724371:;
 
 
* End of changes for CHANGE_ID:ID724371;
 
 
***********************************************************************************************;
*************************************  End Change ID724371 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID681620 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID681620;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID681620")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(DI_MON)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: DI_MON;
%put NOTE- Change ID                             :ID681620;
%goto ID681620;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID681620;
%goto ID681620;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID681620;
* Insert record into change management table for CHANGE_ID: ID681620;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID681620",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID681620;
 
%end;
 
 
 
 
 
 
 
 
 
%if %sysfunc(exist(&m_di_mon..STG_PROD_GEO_RELATION_X))
%then %do;
 
Data &m_di_mon..STG_PROD_GEO_RELATION_X;
set &m_di_mon..STG_PROD_GEO_RELATION_X(keep=PROD_ID GEO_ID
REL_GEO_ID ADJ_FACTOR ETLS_EXCEPTION_COND ETL_ERROR_JOBRUNTIME);
run;
 
%end;
 
%if %sysfunc(exist(&m_di_mon..STG_PROD_RELATION_X))
%then %do;
 
Data &m_di_mon..STG_PROD_RELATION_X ;
set &m_di_mon..STG_PROD_RELATION_X (keep= PROD_ID RELATED_PROD_ID
RELATION_CD ADJ_FACTOR ETLS_EXCEPTION_COND ETL_ERROR_JOBRUNTIME);
run;
 
%end;
 
proc sql noprint;
delete from &m_di_data..global_setting
where spec_nm='PROD_RELATION_LVL';
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID681620;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID681620;
%put ERROR- Description                              : Remove validation on levels PROD_RELATION/GEO_PROD_RELATION;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 07MAR2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID681620;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID681620",
"Remove validation on levels PROD_RELATION/GEO_PROD_RELATION",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID681620:;
 
 
* End of changes for CHANGE_ID:ID681620;
 
 
***********************************************************************************************;
*************************************  End Change ID681620 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID740543 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID740543;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID740543")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID740543;
%goto ID740543;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID740543;
* Insert record into change management table for CHANGE_ID: ID740543;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID740543",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID740543;
 
%end;
 
 
 
 
 
%macro di_etl_mig_szpk_data(table_nm = );
 
%if %upcase(&m_delete_and_start_fresh) eq TRUE %then %do;
%put NOTE: New installation --> Skip checking for partition data &table_nm;
%return;
%end;
 
%if "&table_nm" = "" %then %do;
%put ERROR: Parameter table_nm is undefined. ;
%etl_abort;
%end;
 
 
proc sql noprint;
select path into :data_lib_path
from sashelp.vlibnam
where upcase(libname) = upcase("&m_di_data")
and level in (0,1);
quit;
 
 
%let complete_path = %di_util_create_folder(relative_dir=&table_nm,parent_dir=&data_lib_path);
libname SRC_LIB "&complete_path";
%local part_sk;
 
proc sql noprint;
create table prod_sk_part as
select input(scan(memname,2,'_'),20.) as part_sk
from dictionary.tables
where upper(libname) = 'SRC_LIB'
and upper(memname) like 'PARTITION_%'
and input(scan(memname,2,'_'),20.) >= 0;
quit;
 
%let number_of_part = %di_util_nobs(prod_sk_part);
%put number of partitions to move = &number_of_part;
 
%if &number_of_part > 0 %then %do;
%do loop = 1 %to &number_of_part;
data sel_row;
point_var = input("&loop",best12.);
set prod_sk_part point = point_var;
call symputx('partition_nm',part_sk, 'l');
output;
stop;
run;
 
%put Partition_nm = &partition_nm;
 
%let partition_value = %sysfunc(cats(Partition_,&partition_nm));
%put partition value = &partition_value;
 
%let trg_path = %di_util_create_folder(relative_dir=1/&partition_nm,parent_dir=&data_lib_path);
libname trg_lib "&trg_path";
 
%if %eval(%sysfunc(exist(src_lib.&partition_value))) %then %do;
 
 
%etl_drop(src_lib.&partition_value,index)
%etl_drop(src_lib.&partition_value,ic);
 
proc copy in = SRC_LIB out = trg_lib move;
select &partition_value;
quit;
 
proc datasets lib = trg_lib nolist nowarn;
delete &table_nm;
change &partition_value = &table_nm;
quit;
 
 
%end;
%else %do;
 
proc sql;
create table trg_lib.&table_nm like &m_di_data..&table_nm;
quit;
 
%etl_drop(trg_lib.&table_nm ,index);
%etl_drop(trg_lib.&table_nm ,ic);
 
%end;
 
 
proc sql;
create index prod_hier_sk on trg_lib.&table_nm(prod_hier_sk);
quit;
 
libname trg_lib;
 
%end; /* End of do loop */
 
%end;
 
libname SRC_LIB;
 
%mend di_etl_mig_szpk_data;
 
proc sql noprint;
select count(*) into :cnt
from &m_di_data..global_setting
where spec_nm = "ACTIVE_APP_FLG"
and APP in ('SZPK', 'SZPF')
and SPEC_VALUE = '1';
quit;
 
%put count = &cnt;
 
%if &cnt > 0 %then %do;
%di_etl_mig_szpk_data(table_nm = prf_sales_fact);
%di_etl_mig_szpk_data(table_nm = prf_stockout_fact);
%di_etl_mig_szpk_data(table_nm = prf_geo_prod_status);
%end;
 
 
 
* Check for errors while processing CHANGE_ID: ID740543;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID740543;
%put ERROR- Description                              : Rearrange size optimization data;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 29APR2013;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID740543;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID740543",
"Rearrange size optimization data",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID740543:;
 
 
* End of changes for CHANGE_ID:ID740543;
 
 
***********************************************************************************************;
*************************************  End Change ID740543 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID736734 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID736734;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID736734")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(DI_MON)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: DI_MON;
%put NOTE- Change ID                             :ID736734;
%goto ID736734;
 
%end;
%if not (%sysfunc(exist(&m_di_mon..job_param))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_mon..job_param;
%put NOTE- Change ID                             :ID736734;
%goto ID736734;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID736734;
%goto ID736734;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID736734;
* Insert record into change management table for CHANGE_ID: ID736734;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID736734",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID736734;
 
%end;
 
 
 
 
 
proc sql;
DELETE FROM &m_di_mon..job_param WHERE upcase(JOBNAME) = 'LOAD_STG2DM_PROMOTION_FACT'
and PARAM_NAME = 'etlp_current_record_window';
 
DELETE FROM &m_di_mon..job_param WHERE upcase(JOBNAME) = 'LOAD_STG2DM_PROMOTION_FACT'
and PARAM_NAME = 'etlp_price_hist_weeks_keep';
 
DELETE FROM &m_di_mon..job_param WHERE upcase(JOBNAME) = 'LOAD_STG2DM_PROMOTION_FACT'
and PARAM_NAME = 'etlp_pos_hist_weeks_keep';
 
INSERT INTO &m_di_mon..job_param VALUES ('LOAD_STG2DM_PROMOTION_FACT','etlp_price_hist_weeks_keep', "0", '"0"');
INSERT INTO &m_di_mon..job_param VALUES ('LOAD_STG2DM_PROMOTION_FACT','etlp_pos_hist_weeks_keep',   "0", '"14"');
quit;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID736734;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID736734;
%put ERROR- Description                              : Add new job parameter for Promotion fact;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 10MAR2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID736734;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID736734",
"Add new job parameter for Promotion fact",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID736734:;
 
 
* End of changes for CHANGE_ID:ID736734;
 
 
***********************************************************************************************;
*************************************  End Change ID736734 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change DROP_RPP_AGG_FROM_SAS ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: DROP_RPP_AGG_FROM_SAS;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("DROP_RPP_AGG_FROM_SAS")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_data..rpp_cal_agg))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_data..rpp_cal_agg;
%put NOTE- Change ID                             :DROP_RPP_AGG_FROM_SAS;
%goto DROP_RPP_AGG_FROM_SAS;
 
%end;
%if not (%sysfunc(exist(&m_di_data..rpp_cat_agg))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_data..rpp_cat_agg;
%put NOTE- Change ID                             :DROP_RPP_AGG_FROM_SAS;
%goto DROP_RPP_AGG_FROM_SAS;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : DROP_RPP_AGG_FROM_SAS;
%goto DROP_RPP_AGG_FROM_SAS;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : DROP_RPP_AGG_FROM_SAS;
* Insert record into change management table for CHANGE_ID: DROP_RPP_AGG_FROM_SAS;
proc sql;
insert  into di_data.data_model_change_management
values (
"DROP_RPP_AGG_FROM_SAS",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto DROP_RPP_AGG_FROM_SAS;
 
%end;
 
 
 
 
 
 
proc sql noprint;
drop table &m_di_data..rpp_cal_agg;
drop table &m_di_data..rpp_cat_agg;
quit;
 
 
 
* Check for errors while processing CHANGE_ID: DROP_RPP_AGG_FROM_SAS;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: DROP_RPP_AGG_FROM_SAS;
%put ERROR- Description                              : Drop RPP_CAL_AGG and RPP_CAT_AGG tables from SAS;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 23MAR2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: DROP_RPP_AGG_FROM_SAS;
proc sql;
insert  into di_data.data_model_change_management
values (
"DROP_RPP_AGG_FROM_SAS",
"Drop RPP_CAL_AGG and RPP_CAT_AGG tables from SAS",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%DROP_RPP_AGG_FROM_SAS:;
 
 
* End of changes for CHANGE_ID:DROP_RPP_AGG_FROM_SAS;
 
 
***********************************************************************************************;
*************************************  End Change DROP_RPP_AGG_FROM_SAS ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID742394 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID742394;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID742394")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_data..ATTR_SPEC))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_data..ATTR_SPEC;
%put NOTE- Change ID                             :ID742394;
%goto ID742394;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID742394;
%goto ID742394;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID742394;
* Insert record into change management table for CHANGE_ID: ID742394;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID742394",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID742394;
 
%end;
 
 
 
 
 
 
data work.ATTR_SPEC_OLD;
attrib USAGE                     length=6   ;
SET &m_di_data..ATTR_SPEC;
USAGE=1;
run;
 
data &m_di_data..ATTR_SPEC;
attrib MODEL_GROUP_ID                      length=4                                            ;
attrib ATTR_SK                             length=4                                            ;
attrib EFFECT_CLASS_NM                     length=$40                                          ;
attrib SELECTION_TYPE                      length=4                                            ;
attrib USAGE                               length=6                                            ;
attrib CREATED_DTTM                        length=8      FORMAT=&DTTMFMT    INFORMAT=&DTTMFMT  ;
attrib CREATED_BY                          length=$20                                          ;
stop;
run;
 
proc append base=&m_di_data..ATTR_SPEC
data=work.ATTR_SPEC_OLD force;
quit;
 
proc sql;
drop table work.ATTR_SPEC_OLD;
quit;
 
 
 
 
 
* Check for errors while processing CHANGE_ID: ID742394;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID742394;
%put ERROR- Description                              : Add column called USAGE to ATTR_SPEC table;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 24MAR2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID742394;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID742394",
"Add column called USAGE to ATTR_SPEC table",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID742394:;
 
 
* End of changes for CHANGE_ID:ID742394;
 
 
***********************************************************************************************;
*************************************  End Change ID742394 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID746640 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID746640;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID746640")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID746640;
%goto ID746640;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID746640;
* Insert record into change management table for CHANGE_ID: ID746640;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID746640",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID746640;
 
%end;
 
 
 
 
 
 
 
%macro get_part_sk;
data _promo_sales_fact1(drop = PARENT_PROD_HIER_SK rc0);
attrib PART_SK length=6;
if _N_ =1 then
do;
declare hash h2(dataset: "work.View_prod_hier", hashexp: 16);
h2.defineKey( "PROD_HIER_SK");
h2.defineData( "PARENT_PROD_HIER_SK");
h2.defineDone();
call missing(PROD_HIER_SK,PART_SK,PARENT_PROD_HIER_SK);
 
end;
set _promo_sales_fact;
rc0 = h2.find();
PART_SK=PARENT_PROD_HIER_SK;
if rc0>0 then PART_SK=0;
run;
%mend get_part_sk;
 
%macro di_etl_mig_promo_sales_data(table_nm = );
 
/* validating the input parameters */
%if "&table_nm" = "" %then %do;
%put ERROR: Parameter table_nm is undefined. ;
%etl_abort;
%end;
 
%local etl_partition_level part_sk;
 
%di_etl_create_empty_part_dataset(table = PROMO_SALES_FACT);
 
%di_util_global_setting_spec(spec_nm=PROD_PARTITION_LVL,
app=ALL,
_spec_value=etl_partition_level,
optional=1);
 
/* Getting the path of DI_DATA library */
proc sql noprint;
select path into :data_lib_path
from sashelp.vlibnam
where upcase(libname) = upcase("&m_di_data")
and level in (0,1);
quit;
 
/* Setting up path for source library from which partitions will be moved */
%let complete_path = %di_util_create_folder(relative_dir=&table_nm,parent_dir=&data_lib_path);
libname PSF_LIB "&complete_path";
 
proc sql noprint;
create table part_name as
select distinct(memname) as memname
from dictionary.columns
where libname = 'PSF_LIB'
;
quit;
 
proc sql;
create table _promo_sales_fact like &m_di_data..promo_sales_fact;
quit;
 
%let no_of_obs = %di_util_nobs(part_name);
%if &no_of_obs > 0 %then %do;
%do loop = 1 %to &no_of_obs;
data sel_row;
point_var = input("&loop",best12.);
set part_name point = point_var;
call symputx('partition_nm',memname, 'l');
output;
stop;
run;
 
proc append data = psf_lib.&partition_nm base = _promo_sales_fact force;
quit;
%end;
%end;
 
proc sql;
create view work.View_prod_hier as
select PROD_HIER_SK,
PARENT_PROD_HIER_SK
from &m_di_data..PRODUCT_HIER_ASSOC_DM
where PROD_HIER_ASSOC_CD =1
and PARENT_PROD_LVL = &etl_partition_level;
quit;
 
 
 
%get_part_sk;
 
 
proc sort data = _promo_sales_fact1;
by part_sk prod_hier_sk geo_hier_sk start_dt;
quit;
 
 
data map (keep = start end_r part_sk);
set _promo_sales_fact1;
by part_sk;
retain start;
if first.part_sk then do;
start = _n_;
end;
if last.part_sk then do;
end_r = _n_;
output;
end;
run;
 
%local i by_val start end_r;
%do i = 1 %to %di_util_nobs(map);
data _null_;
var = &i;
set map point=var;
call symputx('by_val',part_sk,'l');
call symputx('start',start,'l');
call symputx('end_r',end_r,'l');
stop;
run;
 
%let trg_path = %di_util_create_folder(relative_dir=1\&by_val,parent_dir=&data_lib_path);
libname trg_lib "&trg_path";
 
data trg_lib.&table_nm;
drop part_sk ;
do i=&start to &end_r;
set _promo_sales_fact1 point =i;
output;
end;
stop;
run;
 
proc datasets lib = trg_lib nolist nowarn memtype = (data view);
modify &table_nm;
format   promo_sales_units NLNUM12.2;
informat promo_sales_units NLNUM12.2;
format   promo_sales_amt   NLNUM20.3;
informat promo_sales_amt   NLNUM20.3;
format   avg_cost          NLNUM20.3;
informat avg_cost          NLNUM20.3;;
quit;
 
%etl_drop(trg_lib.&table_nm ,index);
%etl_drop(trg_lib.&table_nm ,ic);
 
/* simple index on prod_hier_sk defined */
proc sql;
create index prod_hier_sk on trg_lib.&table_nm(prod_hier_sk);
quit;
 
libname trg_lib;
 
%end;
 
proc datasets lib = psf_lib nolist nowarn memtype = (data view) kill;
quit;
 
proc datasets lib = work nolist nowarn memtype = (data view);
delete map sel_row part_name prod_sk_part view_prod_hier _promo_sales_fact _promo_sales_fact1;
quit;
 
 
%mend di_etl_mig_promo_sales_data;
 
%di_etl_mig_promo_sales_data(table_nm = promo_sales_fact);
 
proc datasets lib = &m_didm_stg nolist nowarn memtype = (data view);
modify stg_promotion_sales;
format promo_sales_units NLNUM12.2;
format promo_sales_amt   NLNUM20.3;
quit;
 
proc datasets lib = &m_di_mon nolist nowarn memtype = (data view);
modify stg_promotion_sales_x;
format   promo_sales_units NLNUM12.2;
informat promo_sales_units NLNUM12.2;
format   promo_sales_amt   NLNUM20.3;
informat promo_sales_amt   NLNUM20.3;
quit;
 
proc datasets lib = &m_di_data nolist nowarn memtype = (data view);
modify promo_sales_fact;
format   promo_sales_units NLNUM12.2;
informat promo_sales_units NLNUM12.2;
format   promo_sales_amt   NLNUM20.3;
informat promo_sales_amt   NLNUM20.3;
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID746640;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID746640;
%put ERROR- Description                              : Rearrange promo_sales_fact data as per TK architecture;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 25MAR2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID746640;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID746640",
"Rearrange promo_sales_fact data as per TK architecture",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID746640:;
 
 
* End of changes for CHANGE_ID:ID746640;
 
 
***********************************************************************************************;
*************************************  End Change ID746640 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID737097 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID737097;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID737097")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_data..MODEL_SPEC_DEFAULT))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_data..MODEL_SPEC_DEFAULT;
%put NOTE- Change ID                             :ID737097;
%goto ID737097;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID737097;
%goto ID737097;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID737097;
* Insert record into change management table for CHANGE_ID: ID737097;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID737097",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID737097;
 
%end;
 
 
 
 
 
proc sql;
DELETE FROM &m_di_data..model_spec_default WHERE spec_nm = 'BAYESIAN_DISCOUNT_FACTOR';
DELETE FROM &m_di_data..model_spec_default WHERE spec_nm = 'BAYESIAN_VARIANCE_FACTOR';
DELETE FROM &m_di_data..model_spec_default WHERE spec_nm = 'CHAR_L';
DELETE FROM &m_di_data..model_spec_default WHERE spec_nm = 'COMPRESS_SCORE_DATA';
DELETE FROM &m_di_data..model_spec_default WHERE spec_nm = 'DEFAULT_TOT_PERIOD';
DELETE FROM &m_di_data..model_spec_default WHERE spec_nm = 'FCST_EXT_MODEL_LIB';
DELETE FROM &m_di_data..model_spec_default WHERE spec_nm = 'FCST_LONG_TERM';
DELETE FROM &m_di_data..model_spec_default WHERE spec_nm = 'FCST_QUICK_UPDATE';
DELETE FROM &m_di_data..model_spec_default WHERE spec_nm = 'FCST_SECOND_SMOOTH';
DELETE FROM &m_di_data..model_spec_default WHERE spec_nm = 'FCST_SELECT';
DELETE FROM &m_di_data..model_spec_default WHERE spec_nm = 'FCST_TRANSFORM';
DELETE FROM &m_di_data..model_spec_default WHERE spec_nm = 'FCST_UPDATE_WIN';
DELETE FROM &m_di_data..model_spec_default WHERE spec_nm = 'FCST_USE_EXT_MODEL';
DELETE FROM &m_di_data..model_spec_default WHERE spec_nm = 'FCST_USE_HPFENGINE';
DELETE FROM &m_di_data..model_spec_default WHERE spec_nm = 'FCST_ZSALES';
DELETE FROM &m_di_data..model_spec_default WHERE spec_nm = 'FILL_MISSING_GP';
DELETE FROM &m_di_data..model_spec_default WHERE spec_nm = 'FULL_MODEL_REFRESH_FREQ';
DELETE FROM &m_di_data..model_spec_default WHERE spec_nm = 'HALO_FREQ';
DELETE FROM &m_di_data..model_spec_default WHERE spec_nm = 'HALO_GEO_LVL';
DELETE FROM &m_di_data..model_spec_default WHERE spec_nm = 'HALO_PROD_LVL';
DELETE FROM &m_di_data..model_spec_default WHERE spec_nm = 'HOLDOUT_ANALYSIS_MODE';
DELETE FROM &m_di_data..model_spec_default WHERE spec_nm = 'INT_DISAGG';
DELETE FROM &m_di_data..model_spec_default WHERE spec_nm = 'INT_DISAGG_BY_PROD';
DELETE FROM &m_di_data..model_spec_default WHERE spec_nm = 'INT_DISAGG_REG_PROD';
DELETE FROM &m_di_data..model_spec_default WHERE spec_nm = 'INT_FUTURE_WITH_TIME';
DELETE FROM &m_di_data..model_spec_default WHERE spec_nm = 'LAG_EFFECT';
DELETE FROM &m_di_data..model_spec_default WHERE spec_nm = 'LOAD_DATA_BY_GEO_LVL';
DELETE FROM &m_di_data..model_spec_default WHERE spec_nm = 'LOAD_DATA_BY_PROD_LVL';
DELETE FROM &m_di_data..model_spec_default WHERE spec_nm = 'LOAD_DATA_SUB_GROUP_SIZE';
DELETE FROM &m_di_data..model_spec_default WHERE spec_nm = 'LOAD_DATA_USE_HASH';
DELETE FROM &m_di_data..model_spec_default WHERE spec_nm = 'LTF_DATE_LVL_NM';
DELETE FROM &m_di_data..model_spec_default WHERE spec_nm = 'LTF_FORECAST_HORIZON';
DELETE FROM &m_di_data..model_spec_default WHERE spec_nm = 'LTF_GP_TIME_AGGR_OPT';
DELETE FROM &m_di_data..model_spec_default WHERE spec_nm = 'MAX_MODEL_STMT_LENGTH';
DELETE FROM &m_di_data..model_spec_default WHERE spec_nm = 'MIN_PARTITION_SIZE';
DELETE FROM &m_di_data..model_spec_default WHERE spec_nm = 'MISC_CODING_METHOD';
DELETE FROM &m_di_data..model_spec_default WHERE spec_nm = 'MISC_DEC_POWER';
DELETE FROM &m_di_data..model_spec_default WHERE spec_nm = 'MISC_MAX_POWER';
DELETE FROM &m_di_data..model_spec_default WHERE spec_nm = 'MODEL_DATA_DURATION';
DELETE FROM &m_di_data..model_spec_default WHERE spec_nm = 'MULTIPLE_MARKDOWNS';
DELETE FROM &m_di_data..model_spec_default WHERE spec_nm = 'NON_COMP_STORE_FCST';
DELETE FROM &m_di_data..model_spec_default WHERE spec_nm = 'OUTLIER_RATIO';
DELETE FROM &m_di_data..model_spec_default WHERE spec_nm = 'PARTITION_METHOD';
DELETE FROM &m_di_data..model_spec_default WHERE spec_nm = 'PARTITION_SEED';
DELETE FROM &m_di_data..model_spec_default WHERE spec_nm = 'PERSIST_LOW_MODEL_DATA';
DELETE FROM &m_di_data..model_spec_default WHERE spec_nm = 'REG_ENGINE';
DELETE FROM &m_di_data..model_spec_default WHERE spec_nm = 'REG_MIX_NAMELEN';
DELETE FROM &m_di_data..model_spec_default WHERE spec_nm = 'REPORT_WIN';
DELETE FROM &m_di_data..model_spec_default WHERE spec_nm = 'SEED';
DELETE FROM &m_di_data..model_spec_default WHERE spec_nm = 'SIM';
DELETE FROM &m_di_data..model_spec_default WHERE spec_nm = 'TRAINING_P';
DELETE FROM &m_di_data..model_spec_default WHERE spec_nm = 'TS_SEASON_SMOOTH';
DELETE FROM &m_di_data..model_spec_default WHERE spec_nm = 'TS_SMOOTH_FACTOR_1';
DELETE FROM &m_di_data..model_spec_default WHERE spec_nm = 'TS_SMOOTH_FACTOR_2';
DELETE FROM &m_di_data..model_spec_default WHERE spec_nm = 'USE_TS_AS_DEFAULT';
DELETE FROM &m_di_data..model_spec_default WHERE spec_nm = 'VALIDATION_P';
DELETE FROM &m_di_data..model_spec_default WHERE spec_nm = 'Z_LSALES';
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID737097;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID737097;
%put ERROR- Description                              : Remove model specs not used in 5.2;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 27MAR2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID737097;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID737097",
"Remove model specs not used in 5.2",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID737097:;
 
 
* End of changes for CHANGE_ID:ID737097;
 
 
***********************************************************************************************;
*************************************  End Change ID737097 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID736133 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID736133;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID736133")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_data..MODEL_SPEC_WORKFLOW))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_data..MODEL_SPEC_WORKFLOW;
%put NOTE- Change ID                             :ID736133;
%goto ID736133;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID736133;
%goto ID736133;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID736133;
* Insert record into change management table for CHANGE_ID: ID736133;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID736133",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID736133;
 
%end;
 
 
 
 
 
data _MODEL_SPEC_WORKFLOW;
set &m_di_data..MODEL_SPEC_WORKFLOW ;
drop config_cd;
DOW_FLG = 0;
HALO_FLG = 0;
run;
 
proc sql;
drop table MODEL_SPEC_WORKFLOW;
quit;
 
data &m_di_data..MODEL_SPEC_WORKFLOW;
attrib TASK_NM                             length=$40                                          ;
attrib PARENT_TASK_NM                      length=$40                                          ;
attrib TASK_DESC                           length=$100                                         ;
attrib TASK_DESC_KEY                       length=$100                                         ;
attrib TASK_LVL                            length=4                                            ;
attrib SPEC_NM                             length=$32                                          ;
attrib SPEC_TYPE                           length=$5                                           ;
attrib MODEL_COMP_NM                       length=$5                                           ;
attrib DOW_FLG                             length=4                                            ;
attrib HALO_FLG                            length=4                                            ;
stop;
run;
 
proc sql;
alter table &m_di_data..MODEL_SPEC_WORKFLOW add CONSTRAINT PRIM_KEY PRIMARY KEY
(TASK_NM);
quit;
 
proc append base=&m_di_data..MODEL_SPEC_WORKFLOW data=_MODEL_SPEC_WORKFLOW force;
run;
 
proc sql;
drop table _MODEL_SPEC_WORKFLOW;
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID736133;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID736133;
%put ERROR- Description                              : Add columns HALO_FLG and DOW_FLG to MODEL_SPEC_WORKFLOW table. Remove CONFIG_CD.;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 28MAR2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID736133;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID736133",
"Add columns HALO_FLG and DOW_FLG to MODEL_SPEC_WORKFLOW table. Remove CONFIG_CD.",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID736133:;
 
 
* End of changes for CHANGE_ID:ID736133;
 
 
***********************************************************************************************;
*************************************  End Change ID736133 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID739811 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID739811;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID739811")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_data..MODEL_SPEC_DEFAULT))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_data..MODEL_SPEC_DEFAULT;
%put NOTE- Change ID                             :ID739811;
%goto ID739811;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID739811;
%goto ID739811;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID739811;
* Insert record into change management table for CHANGE_ID: ID739811;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID739811",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID739811;
 
%end;
 
 
 
 
 
 
proc sql;
DELETE from &m_di_data..MODEL_SPEC_DEFAULT where SPEC_NM='REF_PRICE_COST_TYPE'
and MODEL_COMP_NM='ALL'
and SPEC_TYPE='-1';
INSERT INTO &m_di_data..MODEL_SPEC_DEFAULT
(SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('REF_PRICE_COST_TYPE','ALL','-1','2',NULL);
quit;
 
 
 
 
 
* Check for errors while processing CHANGE_ID: ID739811;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID739811;
%put ERROR- Description                              : New model spec REF_PRICE_TYPE;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 28MAR2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID739811;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID739811",
"New model spec REF_PRICE_TYPE",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID739811:;
 
 
* End of changes for CHANGE_ID:ID739811;
 
 
***********************************************************************************************;
*************************************  End Change ID739811 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID737420 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID737420;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID737420")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID737420;
%goto ID737420;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID737420;
* Insert record into change management table for CHANGE_ID: ID737420;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID737420",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID737420;
 
%end;
 
 
 
 
 
 
data &m_didm_stg..STG_GEO_DATE;
attrib GEO_ID                              length=$32                                          ;
attrib PROD_ID                             length=$32                                          ;
attrib GEO_DATE_TYPE                       length=4                                            ;
attrib START_DT                            length=8      FORMAT=&m_DTFMT      INFORMAT=&m_STG_DTINFMT ;
attrib GEO_DATE_ID                         length=4                                            ;
attrib GEO_DATE_NM                         length=$40                                          ;
attrib END_DT                              length=8      FORMAT=&m_DTFMT      INFORMAT=&m_STG_DTINFMT ;
stop; run;
 
proc sql;
alter table &m_didm_stg..STG_GEO_DATE add NOT NULL (GEO_ID);
alter table &m_didm_stg..STG_GEO_DATE add NOT NULL (PROD_ID);
alter table &m_didm_stg..STG_GEO_DATE add NOT NULL (GEO_DATE_TYPE);
alter table &m_didm_stg..STG_GEO_DATE add NOT NULL (START_DT);
alter table &m_didm_stg..STG_GEO_DATE add NOT NULL (END_DT);
quit;
 
 
Data &m_di_mon..STG_GEO_DATE_X ;
attrib GEO_ID length = $32 ;
attrib PROD_ID length = $32 ;
attrib GEO_DATE_TYPE length = 4 ;
attrib START_DT length = 8 format = &m_DTFMT informat = &m_DTFMT ;
attrib END_DT length = 8 format = &m_DTFMT informat = &m_DTFMT ;
attrib ETLS_EXCEPTION_COND length = $200 ;
attrib ETL_ERROR_JOBRUNTIME length = 8 format =DATETIME16. ;
stop; run;
 
 
 
data &m_didm_stg..STG_DOW_SALES;
attrib PROD_ID  length=$32;
attrib GEO_ID length=$32;
attrib SALES_DT length=8 FORMAT=&m_DTFMT INFORMAT=&m_STG_DTINFMT;
attrib SALES_UNITS length=8 FORMAT=NLNUM12.2  INFORMAT=NLNUM12.2;
attrib SALES_AMT length=8 FORMAT=NLNUM20.3  INFORMAT=NLNUM20.3;
attrib CHANGE_FLG length=$1;
stop;
run;
 
proc sql noprint;
alter table &m_didm_stg..STG_DOW_SALES add NOT NULL (PROD_ID);
alter table &m_didm_stg..STG_DOW_SALES add NOT NULL (GEO_ID);
alter table &m_didm_stg..STG_DOW_SALES add NOT NULL (SALES_DT);
alter table &m_didm_stg..STG_DOW_SALES add NOT NULL (SALES_UNITS);
alter table &m_didm_stg..STG_DOW_SALES add NOT NULL (SALES_AMT);
alter table &m_didm_stg..STG_DOW_SALES add NOT NULL (CHANGE_FLG);
quit;
 
 
data &m_di_mon..STG_DOW_SALES_X;
attrib PROD_ID  length=$32;
attrib GEO_ID length=$32;
attrib SALES_DT length=8 FORMAT=&m_DTFMT INFORMAT=&m_DTFMT;
attrib SALES_UNITS length=8 FORMAT=NLNUM12.2  INFORMAT=NLNUM12.2;
attrib SALES_AMT length=8 FORMAT=NLNUM20.3  INFORMAT=NLNUM20.3;
attrib CHANGE_FLG length=$1;
attrib ETLS_EXCEPTION_COND length = $200 ;
attrib ETL_ERROR_JOBRUNTIME length = 8 format =DATETIME16.;
stop; run;
 
proc sql;
delete from  &m_di_mon..job_param where jobname="LOAD_SRC2STG_DOW_SALES"
and param_name="etlp_src_file"
;
Insert into &m_di_mon..job_param
(jobname, param_name, param_value, default_func)
values("LOAD_SRC2STG_DOW_SALES","etlp_src_file","/data/stg_dow_sales.csv",'"Y"')
;
quit;
 
proc sql;
delete from  &m_di_mon..etl_sys_param where jobname="LOAD_STG2DM_DOW_SALES_FACT"
and param_name="etlp_exception_table"
;
Insert into &m_di_mon..etl_sys_param
(jobname, param_name, param_value, default_func)
values("LOAD_STG2DM_DOW_SALES_FACT","etlp_exception_table","DI_MON.STG_DOW_SALES_X",'"DI_MON.STG_DOW_SALES_X"')
;
quit;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID737420;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID737420;
%put ERROR- Description                              : ETL changes for DOW;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 17MAR2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID737420;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID737420",
"ETL changes for DOW",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID737420:;
 
 
* End of changes for CHANGE_ID:ID737420;
 
 
***********************************************************************************************;
*************************************  End Change ID737420 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID708556 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID708556;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID708556")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID708556;
%goto ID708556;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID708556;
* Insert record into change management table for CHANGE_ID: ID708556;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID708556",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID708556;
 
%end;
 
 
 
 
 
 
proc sql;
 
delete from  &m_di_mon..job_param
where jobname="LOAD_STG2DM_COST_FACT" and param_name="etlp_reload_history_data"        ;
delete from  &m_di_mon..job_param
where jobname="LOAD_STG2DM_PRICE_FACT" and param_name="etlp_reload_history_data"        ;
delete from  &m_di_mon..job_param
where jobname="LOAD_STG2DM_COST_FACT" and param_name="etlp_reload_history_from_dt"        ;
delete from  &m_di_mon..job_param
where jobname="LOAD_STG2DM_PRICE_FACT" and param_name="etlp_reload_history_from_dt"        ;
Insert into &m_di_mon..job_param
(jobname, param_name, param_value, default_func)
values("LOAD_STG2DM_COST_FACT","etlp_reload_history_data","0", '"0"' )
values("LOAD_STG2DM_PRICE_FACT","etlp_reload_history_data","0",'"0"' )
values("LOAD_STG2DM_COST_FACT","etlp_reload_history_from_dt","0",'"0"' )
values("LOAD_STG2DM_PRICE_FACT","etlp_reload_history_from_dt","0",'"0"' );
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID708556;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID708556;
%put ERROR- Description                              : Historical update of Price/Cost fact;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 29MAR2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID708556;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID708556",
"Historical update of Price/Cost fact",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID708556:;
 
 
* End of changes for CHANGE_ID:ID708556;
 
 
***********************************************************************************************;
*************************************  End Change ID708556 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID749340 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID749340;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID749340")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_data..MODEL_SPEC_DEFAULT))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_data..MODEL_SPEC_DEFAULT;
%put NOTE- Change ID                             :ID749340;
%goto ID749340;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID749340;
%goto ID749340;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID749340;
* Insert record into change management table for CHANGE_ID: ID749340;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID749340",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID749340;
 
%end;
 
 
 
 
 
 
proc sql;
DELETE from &m_di_data..MODEL_SPEC_DEFAULT where SPEC_NM = 'ARP';
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID749340;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID749340;
%put ERROR- Description                              : Drop model spec ARP;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 01APR2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID749340;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID749340",
"Drop model spec ARP",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID749340:;
 
 
* End of changes for CHANGE_ID:ID749340;
 
 
***********************************************************************************************;
*************************************  End Change ID749340 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID749631 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID749631;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID749631")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(DI_MON)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: DI_MON;
%put NOTE- Change ID                             :ID749631;
%goto ID749631;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID749631;
%goto ID749631;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52, M1TKMI43);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID749631;
* Insert record into change management table for CHANGE_ID: ID749631;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID749631",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID749631;
 
%end;
 
 
 
 
 
 
* Add new parameters to Job_param for Geo_prod_owned_inv;
 
data temp_job_param;
attrib jobname length=$80 param_name length=$32 param_value length=$160 default_func length=$160 ;
jobname='LOAD_STG2DM_GEO_PROD_OWNED_INV'; param_name='etlp_find_mixed_mode_excp'; param_value='';default_func ='"1"';output;
jobname='LOAD_STG2DM_GEO_PROD_OWNED_INV'; param_name='mixed_mode_excp_at_prod_lvl'; param_value='';default_func ='""';output;
jobname='LOAD_STG2DM_GEO_PROD_OWNED_INV'; param_name='etlp_num_wks_hist'; param_value='';default_func ='"26"';output;
run;
 
proc sql;
update &m_di_mon..job_param set jobname = upcase(jobname);
quit;
 
data &m_di_mon..job_param;
set temp_job_param(rename=(param_value=etls_0 default_func=etls_1));
 
modify &m_di_mon..job_param key=PRIM_KEY;
param_value=etls_0 ;
default_func=etls_1;
 
if _iorc_ = 0 then do;
replace;
end;
else do;
output;
end;
 
_iorc_ = 0; _error_ = 0;
run;
 
%if &syscc >= 5 %then %do;
%put ERROR: Job_param could not be updated. please check log;
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID749631;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID749631;
%put ERROR- Description                              : Adding Parametes in Job_param for GEO_PROD_OWNED_INV;
%put ERROR- Version                                  : D3MICM52, M1TKMI43;
%put ERROR- Date of Change                           : 01APR2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID749631;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID749631",
"Adding Parametes in Job_param for GEO_PROD_OWNED_INV",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID749631:;
 
 
* End of changes for CHANGE_ID:ID749631;
 
 
***********************************************************************************************;
*************************************  End Change ID749631 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID749340_1 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID749340_1;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID749340_1")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_data..MODEL_SPEC))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_data..MODEL_SPEC;
%put NOTE- Change ID                             :ID749340_1;
%goto ID749340_1;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID749340_1;
%goto ID749340_1;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID749340_1;
* Insert record into change management table for CHANGE_ID: ID749340_1;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID749340_1",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID749340_1;
 
%end;
 
 
 
 
 
 
proc sql;
DELETE from &m_di_data..MODEL_SPEC where SPEC_NM = 'ARP';
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID749340_1;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID749340_1;
%put ERROR- Description                              : Drop model spec ARP;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 01APR2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID749340_1;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID749340_1",
"Drop model spec ARP",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID749340_1:;
 
 
* End of changes for CHANGE_ID:ID749340_1;
 
 
***********************************************************************************************;
*************************************  End Change ID749340_1 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID749664 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID749664;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID749664")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_data..GLOBAL_SETTING))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_data..GLOBAL_SETTING;
%put NOTE- Change ID                             :ID749664;
%goto ID749664;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID749664;
%goto ID749664;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID749664;
* Insert record into change management table for CHANGE_ID: ID749664;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID749664",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID749664;
 
%end;
 
 
 
 
 
 
proc sql;
UPDATE &m_di_data..GLOBAL_SETTING set SPEC_VALUE = '2' where SPEC_NM = 'BASELINE_OFFSET';
UPDATE &m_di_data..GLOBAL_SETTING set SPEC_DESC = 'Specifies how baseline offset should be computed.' where SPEC_NM = 'BASELINE_OFFSET';
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID749664;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID749664;
%put ERROR- Description                              : Change values for BASELINE_OFFSET global setting;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 01APR2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID749664;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID749664",
"Change values for BASELINE_OFFSET global setting",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID749664:;
 
 
* End of changes for CHANGE_ID:ID749664;
 
 
***********************************************************************************************;
*************************************  End Change ID749664 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID737097_1 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID737097_1;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID737097_1")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_data..GLOBAL_SETTING))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_data..GLOBAL_SETTING;
%put NOTE- Change ID                             :ID737097_1;
%goto ID737097_1;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID737097_1;
%goto ID737097_1;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID737097_1;
* Insert record into change management table for CHANGE_ID: ID737097_1;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID737097_1",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID737097_1;
 
%end;
 
 
 
 
 
 
proc sql;
DELETE from &m_di_data..GLOBAL_SETTING where SPEC_NM = 'SALES_AVG_GEO_LVL';
DELETE from &m_di_data..GLOBAL_SETTING where SPEC_NM = 'SALES_AVG_PROD_LVL';
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID737097_1;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID737097_1;
%put ERROR- Description                              : Remove global settings SALES_AVG_GEO_LVL and SALES_AVG_PROD_LVL;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 01APR2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID737097_1;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID737097_1",
"Remove global settings SALES_AVG_GEO_LVL and SALES_AVG_PROD_LVL",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID737097_1:;
 
 
* End of changes for CHANGE_ID:ID737097_1;
 
 
***********************************************************************************************;
*************************************  End Change ID737097_1 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID749665 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID749665;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID749665")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_data..MODEL_SPEC_DEFAULT))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_data..MODEL_SPEC_DEFAULT;
%put NOTE- Change ID                             :ID749665;
%goto ID749665;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID749665;
%goto ID749665;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID749665;
* Insert record into change management table for CHANGE_ID: ID749665;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID749665",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID749665;
 
%end;
 
 
 
 
 
 
proc sql;
DELETE from &m_di_data..MODEL_SPEC_DEFAULT where SPEC_NM = 'BASELINE_OFFSET_PCTILE';
INSERT into &m_di_data..MODEL_SPEC_DEFAULT
(SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('BASELINE_OFFSET_PCTILE','ALL','1','0.9',NULL);
INSERT into &m_di_data..MODEL_SPEC_DEFAULT
(SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('BASELINE_OFFSET_PCTILE','ALL','2','0.9',NULL);
DELETE from &m_di_data..MODEL_SPEC_DEFAULT where SPEC_NM = 'BASELINE_OFFSET_NBINS';
INSERT into &m_di_data..MODEL_SPEC_DEFAULT
(SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('BASELINE_OFFSET_NBINS','ALL','1','10000',NULL);
INSERT into &m_di_data..MODEL_SPEC_DEFAULT
(SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('BASELINE_OFFSET_NBINS','ALL','2','10000',NULL);
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID749665;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID749665;
%put ERROR- Description                              : Add model specs BASELINE_OFFSET_PCTILE and BASELINE_OFFSET_NBINS;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 04APR2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID749665;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID749665",
"Add model specs BASELINE_OFFSET_PCTILE and BASELINE_OFFSET_NBINS",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID749665:;
 
 
* End of changes for CHANGE_ID:ID749665;
 
 
***********************************************************************************************;
*************************************  End Change ID749665 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID739353 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID739353;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID739353")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_data..MODEL_SPEC_DEFAULT))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_data..MODEL_SPEC_DEFAULT;
%put NOTE- Change ID                             :ID739353;
%goto ID739353;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID739353;
%goto ID739353;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID739353;
* Insert record into change management table for CHANGE_ID: ID739353;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID739353",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID739353;
 
%end;
 
 
 
 
 
proc sql;
DELETE from &m_di_data..MODEL_SPEC_DEFAULT where SPEC_NM = 'DOW_SIGNIFICANCE_LVL';
INSERT into &m_di_data..MODEL_SPEC_DEFAULT
(SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('DOW_SIGNIFICANCE_LVL','DOW','-1','0.05',NULL);
 
DELETE from &m_di_data..MODEL_SPEC_DEFAULT where SPEC_NM = 'DOW_NUM_WEEK_SAMPLE';
INSERT into &m_di_data..MODEL_SPEC_DEFAULT
(SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('DOW_NUM_WEEK_SAMPLE','DOW','-1','3',NULL);
 
DELETE from &m_di_data..MODEL_SPEC_DEFAULT where SPEC_NM = 'DOW_NUM_WEEK_SAMPLE_EXT';
INSERT into &m_di_data..MODEL_SPEC_DEFAULT
(SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('DOW_NUM_WEEK_SAMPLE_EXT','DOW','-1','8',NULL);
 
DELETE from &m_di_data..MODEL_SPEC_DEFAULT where SPEC_NM = 'DOW_LIKELIHOOD_SIG_LVL';
INSERT into &m_di_data..MODEL_SPEC_DEFAULT
(SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('DOW_LIKELIHOOD_SIG_LVL','DOW','-1','0.05',NULL);
 
DELETE from &m_di_data..MODEL_SPEC_DEFAULT where SPEC_NM = 'DOW_MAX_ATTR_LVL';
INSERT into &m_di_data..MODEL_SPEC_DEFAULT
(SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('DOW_MAX_ATTR_LVL','DOW','-1','5',NULL);
 
DELETE from &m_di_data..MODEL_SPEC_DEFAULT where SPEC_NM = 'DOW_MIN_SPLIT_PCT';
INSERT into &m_di_data..MODEL_SPEC_DEFAULT
(SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('DOW_MIN_SPLIT_PCT','DOW','-1','0.10',NULL);
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID739353;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID739353;
%put ERROR- Description                              : Add first 6 DOW model specs;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 04APR2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID739353;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID739353",
"Add first 6 DOW model specs",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID739353:;
 
 
* End of changes for CHANGE_ID:ID739353;
 
 
***********************************************************************************************;
*************************************  End Change ID739353 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ADD_PRICE_POINT_CORRECTION ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ADD_PRICE_POINT_CORRECTION;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ADD_PRICE_POINT_CORRECTION")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ADD_PRICE_POINT_CORRECTION;
%goto ADD_PRICE_POINT_CORRECTION;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ADD_PRICE_POINT_CORRECTION;
* Insert record into change management table for CHANGE_ID: ADD_PRICE_POINT_CORRECTION;
proc sql;
insert  into di_data.data_model_change_management
values (
"ADD_PRICE_POINT_CORRECTION",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ADD_PRICE_POINT_CORRECTION;
 
%end;
 
 
 
 
 
***********************************************************************************************;
 
data &m_di_data..PRICE_POINT_CORRECTION;
attrib PROD_HIER_SK         length=6                                      ;
attrib PRICE_POINT_LOWER    length=8 FORMAT=NLNUM20.3  INFORMAT=NLNUM20.3 ;
attrib PRICE_POINT_UPPER    length=8 FORMAT=NLNUM20.3  INFORMAT=NLNUM20.3 ;
attrib PRICE_INCREMENT      length=8 FORMAT=NLNUM20.3  INFORMAT=NLNUM20.3 ;
attrib ADJUST_PRICE_RANGE   length=8 FORMAT=NLNUM20.3  INFORMAT=NLNUM20.3 ;
stop; run;
 
 
 
* Check for errors while processing CHANGE_ID: ADD_PRICE_POINT_CORRECTION;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ADD_PRICE_POINT_CORRECTION;
%put ERROR- Description                              : Add PRICE_POINT_CORRECTION table to support price ending effect;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 04APR2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ADD_PRICE_POINT_CORRECTION;
proc sql;
insert  into di_data.data_model_change_management
values (
"ADD_PRICE_POINT_CORRECTION",
"Add PRICE_POINT_CORRECTION table to support price ending effect",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ADD_PRICE_POINT_CORRECTION:;
 
 
* End of changes for CHANGE_ID:ADD_PRICE_POINT_CORRECTION;
 
 
***********************************************************************************************;
*************************************  End Change ADD_PRICE_POINT_CORRECTION ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change GLOBAL_CONSTANTS ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: GLOBAL_CONSTANTS;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("GLOBAL_CONSTANTS")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : GLOBAL_CONSTANTS;
%goto GLOBAL_CONSTANTS;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : GLOBAL_CONSTANTS;
* Insert record into change management table for CHANGE_ID: GLOBAL_CONSTANTS;
proc sql;
insert  into di_data.data_model_change_management
values (
"GLOBAL_CONSTANTS",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto GLOBAL_CONSTANTS;
 
%end;
 
 
 
 
%put NOTE: Skipping this change since this change should never be applied.;
%put NOTE- Change ID                             :GLOBAL_CONSTANTS;
%goto GLOBAL_CONSTANTS;
 
 
 
 
 
filename importin "%di_util_misc_path()/dbmsc/GLOBAL_CONSTANTS.CPORT";
proc cimport infile=importin library=WORK memtype=DATA;
run;
 
%let m_refresh=%nrstr(proc sql; delete * from &m_di_data..&m_tn;
create table z as select * from &m_di_data..&m_tn outer union corr select * from work.&m_tn;
insert into &m_di_data..&m_tn select * from z; quit;);
 
 
%let m_tn=global_setting_details;
%unquote(&m_refresh);
 
%let m_tn=global_setting_group;
%unquote(&m_refresh);
;
 
%let m_tn=global_setting_group_member;
%unquote(&m_refresh);
 
%let m_tn=global_setting_values;
%unquote(&m_refresh);
 
%let m_tn=ma_spec;
%unquote(&m_refresh);
 
%let m_tn=model_geo_prod_status_details;
%unquote(&m_refresh);
 
%let m_tn=model_geo_prod_status_values;
%unquote(&m_refresh);
 
%let m_tn=model_spec_details;
%unquote(&m_refresh);
 
%let m_tn=model_spec_values;
%unquote(&m_refresh);
 
%let m_tn=model_spec_workflow;
%unquote(&m_refresh);
 
%let m_tn=scoring_param_config;
%unquote(&m_refresh);
 
 
 
* Check for errors while processing CHANGE_ID: GLOBAL_CONSTANTS;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: GLOBAL_CONSTANTS;
%put ERROR- Description                              : Refresh Global Constants;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 15FEB2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: GLOBAL_CONSTANTS;
proc sql;
insert  into di_data.data_model_change_management
values (
"GLOBAL_CONSTANTS",
"Refresh Global Constants",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%GLOBAL_CONSTANTS:;
 
 
* End of changes for CHANGE_ID:GLOBAL_CONSTANTS;
 
 
***********************************************************************************************;
*************************************  End Change GLOBAL_CONSTANTS ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID750328 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID750328;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID750328")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID750328;
%goto ID750328;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID750328;
* Insert record into change management table for CHANGE_ID: ID750328;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID750328",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID750328;
 
%end;
 
 
 
 
 
data &m_di_data..SIZESET_MBR;
attrib STD_SIZE_CD                         length=6                                            ;
attrib PROFILING_PROJECT_SK                length=6                                            ;
attrib SIZESET_ID                          length=8                                            ;
stop; run;
 
proc sql;
alter table &m_di_data..SIZESET_MBR add NOT NULL (STD_SIZE_CD);
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID750328;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID750328;
%put ERROR- Description                              : SIZE PROFILING 3.2 SCHEMA CHANGES;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 04APR2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID750328;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID750328",
"SIZE PROFILING 3.2 SCHEMA CHANGES",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID750328:;
 
 
* End of changes for CHANGE_ID:ID750328;
 
 
***********************************************************************************************;
*************************************  End Change ID750328 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID719792 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID719792;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID719792")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID719792;
%goto ID719792;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52,M2TKMI43);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID719792;
* Insert record into change management table for CHANGE_ID: ID719792;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID719792",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID719792;
 
%end;
 
 
 
 
 
 
proc sql;
alter table &m_didm_stg..STG_MDO_IMPORT_PLAN
add UNIFORM_TIMING_NUM_MARKDN num 4,
UNIFORM_TIMING_PROD_LVL num 4,
UNIFORM_TIMING_GEO_LVL num 4
;
quit;
 
proc sql;
alter table &m_di_mon..STG_MDO_IMPORT_PLAN_X
add UNIFORM_TIMING_NUM_MARKDN num 4,
UNIFORM_TIMING_PROD_LVL num 4,
UNIFORM_TIMING_GEO_LVL num 4
;
quit;
 
proc sql;
insert into &m_di_data..reference_values
(field_nm,field_value,field_short_desc)
values ('SETTING_TYPE','50','UNIFORM_TIMING_NUM_MARKDN')
values ('SETTING_TYPE','51','UNIFORM_TIMING_PROD_LVL')
values ('SETTING_TYPE','52','UNIFORM_TIMING_GEO_LVL');
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID719792;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID719792;
%put ERROR- Description                              : Schema and ETL enhancement for uniform timing (mdo_plan and stg_mdo_import_plan);
%put ERROR- Version                                  : D3MICM52,M2TKMI43;
%put ERROR- Date of Change                           : 30MAR2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID719792;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID719792",
"Schema and ETL enhancement for uniform timing (mdo_plan and stg_mdo_import_plan)",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID719792:;
 
 
* End of changes for CHANGE_ID:ID719792;
 
 
***********************************************************************************************;
*************************************  End Change ID719792 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID738983_1 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID738983_1;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID738983_1")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID738983_1;
%goto ID738983_1;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52, M1MI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID738983_1;
* Insert record into change management table for CHANGE_ID: ID738983_1;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID738983_1",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID738983_1;
 
%end;
 
 
 
 
 
/* Create subfolder 1 under di_data if it does not exist */
%di_etl_set_lib (parent_lib=&m_di_data , sub_folder=1, partition_lib=di_part);
 
proc sql noprint;
select spec_value into :num_parallel_executions
from &m_di_data..global_setting
where upcase(spec_nm)='NUM_PARALLEL_EXECUTIONS';
quit;
%let num_parallel_executions = &num_parallel_executions;
 
%if %sysfunc(exist(&m_di_data..GEO_PROD)) %then %do;
 
data work.exclude_tables;
attrib table_nm length=$40;
table_nm = 'SALES_FACT'; output;
run;
 
%di_etl_partition_data(
from_lib=&m_di_data,
table_nm=%quote(GEO_PROD),
increment_count=8000000,
exclude_list=work.exclude_tables,
num_parallel_jobs=&num_parallel_executions,
refresh_mapping=1);
 
 
%end;
 
%macro di_etl_del_col(table_nm = );
 
/* validating the input parameters*/
 
%if "&table_nm" = "" %then %do;
%put ERROR: Parameter table_nm is undefined. ;
%etl_abort;
%end;
 
/* Getting the path of DI_DATA library */
 
proc sql noprint;
select path into :data_lib_path
from sashelp.vlibnam
where upcase(libname) = upcase("&m_di_data")
and level in (0,1);
quit;
 
%put data lib path = &data_lib_path;
 
/* getting the  values of all partitions */
 
%local etl_partition_level part_sk;
 
%di_util_global_setting_spec(spec_nm=PROD_PARTITION_LVL,
app=ALL,
_spec_value=etl_partition_level,
optional=1);
 
proc sql;
create table work.prod_sk_part as
select distinct(PROD_HIER_SK) as part_sk
from &m_di_data..PRODUCT_HIER_ASSOC_DM
where PROD_HIER_ASSOC_CD =1
and PROD_LVL = &etl_partition_level;
quit;
 
proc sql;
insert into work.prod_sk_part values (0);
quit;
 
/* Setting up path for source library from which column MIN_INV_LVL to be deleted */
 
%let number_of_part = %di_util_nobs(prod_sk_part);
%put number of partitions to move = &number_of_part;
 
%do i = 1 %to &number_of_part;
data sel_row;
point_var = input("&i",best12.);
set prod_sk_part point = point_var;
call symputx('partition_nm',part_sk, 'l');
output;
stop;
run;
 
%put Partition_nm = &partition_nm;
 
%let trg_path = %di_util_create_folder(relative_dir=1\&partition_nm,parent_dir=&data_lib_path);
libname trg_lib "&trg_path";
 
%if (%sysfunc(exist(trg_lib.&table_nm)) eq 1) %then %do; /* if table exists under \1\part_sk\... */
proc sql;
alter table trg_lib.&table_nm
drop column MIN_INV_LVL;
quit;
%end;
 
%end;
 
%mend;
 
%di_etl_del_col(table_nm = PRODUCT_DM);
 
 
 
* Check for errors while processing CHANGE_ID: ID738983_1;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID738983_1;
%put ERROR- Description                              : Re-Partitioning of product_dm and GEO_PROD with change of MIN_INV_LVL column.;
%put ERROR- Version                                  : D3MICM52, M1MI42;
%put ERROR- Date of Change                           : 07APR2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID738983_1;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID738983_1",
"Re-Partitioning of product_dm and GEO_PROD with change of MIN_INV_LVL column.",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID738983_1:;
 
 
* End of changes for CHANGE_ID:ID738983_1;
 
 
***********************************************************************************************;
*************************************  End Change ID738983_1 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID727110 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID727110;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID727110")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_mon..PURGE_RESULT_TABLE))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_mon..PURGE_RESULT_TABLE;
%put NOTE- Change ID                             :ID727110;
%goto ID727110;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID727110;
%goto ID727110;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52,M2MI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID727110;
* Insert record into change management table for CHANGE_ID: ID727110;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID727110",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID727110;
 
%end;
 
 
 
 
 
 
%if (%di_util_varexist(dsname=&m_di_data..GEO_PROD_PURGE_LIST, varname=PURGED_DTTM)=0) %then
%do;
/* Delete any pre existing version of PURGE_RESULT_TABLE from DI_DATA */
 
proc datasets lib = &m_di_data nolist nowarn memtype = (data view);
delete PURGE_RESULT_TABLE;
quit;
 
/* Move PURGE_RESULT_TABLE from DI_MON to DI_DM and add PURGED_FLG column */
 
data &m_di_data..PURGE_RESULT_TABLE;
set &m_di_mon..PURGE_RESULT_TABLE;
attrib PURGED_FLG length=$1;
PURGED_FLG='Y';
run;
 
/* Delete existing version of PURGE_RESULT_TABLE from DI_MON */
 
proc datasets lib = &m_di_mon nolist nowarn memtype = (data view);
delete PURGE_RESULT_TABLE;
quit;
 
 
/* Drop columns PURGED_DT, CREATED_DT and add columns PURGED_DTTM and CREATED_DTTM */
 
proc sql;
alter table &m_di_data..GEO_PROD_PURGE_LIST
add PURGED_DTTM  NUM FORMAT=NLDATM21. INFORMAT=NLDATM21.,
CREATED_DTTM NUM FORMAT=NLDATM21. INFORMAT=NLDATM21.;
quit;
 
proc sql;
update &m_di_data..GEO_PROD_PURGE_LIST set PURGED_DTTM=PURGED_DT*24*60*60;
update &m_di_data..GEO_PROD_PURGE_LIST set CREATED_DTTM=CREATED_DT*24*60*60;
quit;
 
proc sql;
alter table &m_di_data..GEO_PROD_PURGE_LIST
drop PURGED_DT, CREATED_DT;
quit;
 
%end;
 
 
 
* Check for errors while processing CHANGE_ID: ID727110;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID727110;
%put ERROR- Description                              : Move PURGE_RESULT_TABLE from MON to DATA lib and replace date columns with datetime columns in DI_DATA.GEO_PROD_PURGE_LIST;
%put ERROR- Version                                  : D3MICM52,M2MI42;
%put ERROR- Date of Change                           : 12APR2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID727110;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID727110",
"Move PURGE_RESULT_TABLE from MON to DATA lib and replace date columns with datetime columns in DI_DATA.GEO_PROD_PURGE_LIST",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID727110:;
 
 
* End of changes for CHANGE_ID:ID727110;
 
 
***********************************************************************************************;
*************************************  End Change ID727110 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID734856 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID734856;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID734856")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_didm_stg..STG_PROFILE_CLUSTER))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_didm_stg..STG_PROFILE_CLUSTER;
%put NOTE- Change ID                             :ID734856;
%goto ID734856;
 
%end;
%if not (%sysfunc(exist(&m_di_mon..STG_PROFILE_CLUSTER_X))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_mon..STG_PROFILE_CLUSTER_X;
%put NOTE- Change ID                             :ID734856;
%goto ID734856;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID734856;
%goto ID734856;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID734856;
* Insert record into change management table for CHANGE_ID: ID734856;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID734856",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID734856;
 
%end;
 
 
 
 
 
proc sql;
alter table &m_didm_stg..STG_PROFILE_CLUSTER
add CLASSIFIED_FLG num 3
;
quit;
 
proc sql;
alter table &m_di_mon..STG_PROFILE_CLUSTER_X
add CLASSIFIED_FLG num 3
;
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID734856;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID734856;
%put ERROR- Description                              : Add Classified_flg to Profile_cluster stage table;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 11APR2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID734856;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID734856",
"Add Classified_flg to Profile_cluster stage table",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID734856:;
 
 
* End of changes for CHANGE_ID:ID734856;
 
 
***********************************************************************************************;
*************************************  End Change ID734856 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID725829 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID725829;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID725829")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(&m_di_mon.)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_di_mon.;
%put NOTE- Change ID                             :ID725829;
%goto ID725829;
 
%end;
%if not (%sysfunc(exist(&m_di_mon..STG_STD_SIZE_X))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_mon..STG_STD_SIZE_X;
%put NOTE- Change ID                             :ID725829;
%goto ID725829;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID725829;
%goto ID725829;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID725829;
* Insert record into change management table for CHANGE_ID: ID725829;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID725829",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID725829;
 
%end;
 
 
 
 
 
 
proc sql;
ALTER TABLE &m_di_mon..STG_STD_SIZE_X
DROP PROD_LVL;
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID725829;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID725829;
%put ERROR- Description                              : Revert changes that is add validation where it checks for product to be at size_translation_prod_lvl;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 14APR2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID725829;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID725829",
"Revert changes that is add validation where it checks for product to be at size_translation_prod_lvl",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID725829:;
 
 
* End of changes for CHANGE_ID:ID725829;
 
 
***********************************************************************************************;
*************************************  End Change ID725829 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID672986 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID672986;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID672986")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(&m_didm_stg.)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_didm_stg.;
%put NOTE- Change ID                             :ID672986;
%goto ID672986;
 
%end;
%if not (%sysfunc(exist(&m_didm_stg..STG_DIMENSION_LEVELS))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_didm_stg..STG_DIMENSION_LEVELS;
%put NOTE- Change ID                             :ID672986;
%goto ID672986;
 
%end;
%if not (%sysfunc(exist(&m_di_data..GEOGRAPHY_LVL))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_data..GEOGRAPHY_LVL;
%put NOTE- Change ID                             :ID672986;
%goto ID672986;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID672986;
%goto ID672986;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID672986;
* Insert record into change management table for CHANGE_ID: ID672986;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID672986",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID672986;
 
%end;
 
 
 
 
 
/* Modify LEVEL_DESC length in STAGE to 100 */
 
proc sql;
alter table &m_didm_stg..STG_DIMENSION_LEVELS
modify LEVEL_DESC char(100);
quit;
 
/* Modify GEO_LVL_DESC length in DI_DATA.GEOGRAPHY_LVL to 100 */
 
proc sql;
alter table &m_di_data..GEOGRAPHY_LVL
modify GEO_LVL_DESC char(100);
quit;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID672986;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID672986;
%put ERROR- Description                              : Modify length of LVL_DESC columns in stg.dimension_lvl and geography_lvl;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 15APR2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID672986;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID672986",
"Modify length of LVL_DESC columns in stg.dimension_lvl and geography_lvl",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID672986:;
 
 
* End of changes for CHANGE_ID:ID672986;
 
 
***********************************************************************************************;
*************************************  End Change ID672986 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID752806 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID752806;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID752806")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(&m_di_mon.)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_di_mon.;
%put NOTE- Change ID                             :ID752806;
%goto ID752806;
 
%end;
%if not (%sysfunc(exist(&m_di_mon..job_status))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_mon..job_status;
%put NOTE- Change ID                             :ID752806;
%goto ID752806;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID752806;
%goto ID752806;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52,D2TKMI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID752806;
* Insert record into change management table for CHANGE_ID: ID752806;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID752806",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID752806;
 
%end;
 
 
 
 
 
data &m_di_mon..job_status_bkp;
set &m_di_mon..job_status;
run;
 
proc sql noprint;
drop table &m_di_mon..job_status;
quit;
 
Data &m_di_mon..JOB_STATUS ;
attrib USER length=$32 label='User id' ;
attrib TABLE length=$32 label='Table name' ;
attrib LIB length=$32 label='Library' ;
attrib JOBNAME length=$80 label='Job name' ;
attrib JOBSTAT length=$80 label='Job status' ;
attrib JOB_RC length=8 label='Job return code' ;
attrib RBEFORE length=8 label='No. Records before' ;
attrib RAFTER length=8 label='No. Records after' ;
attrib RSOURCE length=8 label='No. Records in source' ;
attrib RINEXCP length=8 label='No. Records rejected' ;
attrib STTIME length=8 format=&m_dttmfmt label='Job start time' ;
attrib ENDTIME length=8 format=&m_dttmfmt label='Job end time' ;
stop; run;
 
proc sql;
create index JOBNAME on &m_di_mon..JOB_STATUS (JOBNAME);
quit;
 
proc sql noprint;
insert into &m_di_mon..job_status
(USER,
TABLE,
LIB,
JOBNAME,
JOBSTAT,
JOB_RC,
RBEFORE,
RAFTER,
STTIME,
ENDTIME)
select
USER,
TABLE,
LIB,
JOBNAME,
JOBSTAT,
JOB_RC,
RBEFORE,
RAFTER,
STTIME,
ENDTIME
from &m_di_mon..job_status_bkp;
quit;
 
proc sql noprint;
drop table &m_di_mon..job_status_bkp;
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID752806;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID752806;
%put ERROR- Description                              : Modify DI_MON.JOB_STATUS table;
%put ERROR- Version                                  : D3MICM52,D2TKMI42;
%put ERROR- Date of Change                           : 25APR2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID752806;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID752806",
"Modify DI_MON.JOB_STATUS table",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID752806:;
 
 
* End of changes for CHANGE_ID:ID752806;
 
 
***********************************************************************************************;
*************************************  End Change ID752806 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ADD_PARM ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ADD_PARM;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ADD_PARM")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(&m_di_mon.)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_di_mon.;
%put NOTE- Change ID                             :ADD_PARM;
%goto ADD_PARM;
 
%end;
%if not (%sysfunc(exist(&m_di_mon..JOB_PARAM))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_mon..JOB_PARAM;
%put NOTE- Change ID                             :ADD_PARM;
%goto ADD_PARM;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ADD_PARM;
%goto ADD_PARM;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ADD_PARM;
* Insert record into change management table for CHANGE_ID: ADD_PARM;
proc sql;
insert  into di_data.data_model_change_management
values (
"ADD_PARM",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ADD_PARM;
 
%end;
 
 
 
 
 
proc sql;
delete from &m_di_mon..JOB_PARAM
where upcase(jobname) = "LOAD_STG2DM_BUDGET" and upcase(PARAM_NAME)="FULL_REFRESH";
 
insert into &m_di_mon..JOB_PARAM values("LOAD_STG2DM_BUDGET", "Full_refresh",'','"0"');
quit;
 
 
 
 
 
* Check for errors while processing CHANGE_ID: ADD_PARM;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ADD_PARM;
%put ERROR- Description                              : Add parameter 'FULL_REFRESH' in DI_MON.JOB_PARAM for LOAD_STG2DM_BUDGET job;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 25APR2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ADD_PARM;
proc sql;
insert  into di_data.data_model_change_management
values (
"ADD_PARM",
"Add parameter 'FULL_REFRESH' in DI_MON.JOB_PARAM for LOAD_STG2DM_BUDGET job",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ADD_PARM:;
 
 
* End of changes for CHANGE_ID:ADD_PARM;
 
 
***********************************************************************************************;
*************************************  End Change ADD_PARM ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID745889 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID745889;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID745889")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(&m_di_mon.)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_di_mon.;
%put NOTE- Change ID                             :ID745889;
%goto ID745889;
 
%end;
%if not (%sysfunc(exist(&m_di_mon..ETL_SYS_PARAM))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_mon..ETL_SYS_PARAM;
%put NOTE- Change ID                             :ID745889;
%goto ID745889;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID745889;
%goto ID745889;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID745889;
* Insert record into change management table for CHANGE_ID: ID745889;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID745889",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID745889;
 
%end;
 
 
 
 
 
proc sql;
delete from &m_di_mon..ETL_SYS_PARAM
where upcase(jobname) = "ALLJOBS" and upcase(PARAM_NAME)="ETLP_BUDGET_TYPE";
 
insert into &m_di_mon..ETL_SYS_PARAM values("ALLJOBS", "etlp_budget_type", "2", '"2"');
quit;
 
 
 
 
 
* Check for errors while processing CHANGE_ID: ID745889;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID745889;
%put ERROR- Description                              : Set '2' as the only possible value for ETLP_BUDGET_TYPE parameter in DI_MON.ETL_SYS_PARAM table;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 25APR2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID745889;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID745889",
"Set '2' as the only possible value for ETLP_BUDGET_TYPE parameter in DI_MON.ETL_SYS_PARAM table",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID745889:;
 
 
* End of changes for CHANGE_ID:ID745889;
 
 
***********************************************************************************************;
*************************************  End Change ID745889 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID741891 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID741891;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID741891")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(&m_di_mon.)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_di_mon.;
%put NOTE- Change ID                             :ID741891;
%goto ID741891;
 
%end;
%if not (%sysfunc(exist(&m_di_mon..JOB_PARAM))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_mon..JOB_PARAM;
%put NOTE- Change ID                             :ID741891;
%goto ID741891;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID741891;
%goto ID741891;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID741891;
* Insert record into change management table for CHANGE_ID: ID741891;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID741891",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID741891;
 
%end;
 
 
 
 
 
proc sql;
delete from &m_di_mon..job_param where upcase(jobname) = "DI_PURGE_EXCEPTION_TABLES" and lowcase(param_name) = "etlp_excp_rec_retain_wks";
delete from &m_di_mon..job_param where upcase(jobname) = "DI_PURGE_EXCEPTION_TABLES" and lowcase(param_name) = "etlp_excp_archive_loc";
delete from &m_di_mon..job_param where upcase(jobname) = "DI_PURGE_EXCEPTION_TABLES" and lowcase(param_name) = "etlp_excp_table_list";
delete from &m_di_mon..job_param where upcase(jobname) = "DI_PURGE_EXCEPTION_TABLES" and lowcase(param_name) = "etlp_archive_cmd";
quit;
 
proc sql;
insert into &m_di_mon..job_param values ("DI_PURGE_EXCEPTION_TABLES", "etlp_excp_rec_retain_wks", '1', '"1"');
insert into &m_di_mon..job_param values ("DI_PURGE_EXCEPTION_TABLES", "etlp_excp_archive_loc", '', '" "');
insert into &m_di_mon..job_param values ("DI_PURGE_EXCEPTION_TABLES", "etlp_excp_table_list", '', '" "');
insert into &m_di_mon..job_param values ("DI_PURGE_EXCEPTION_TABLES", "etlp_archive_cmd", '', '" "');
quit;
 
 
 
 
 
* Check for errors while processing CHANGE_ID: ID741891;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID741891;
%put ERROR- Description                              : Setting up parameter for DI_PURGE_EXCEPTION_TABLES job;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 27APR2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID741891;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID741891",
"Setting up parameter for DI_PURGE_EXCEPTION_TABLES job",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID741891:;
 
 
* End of changes for CHANGE_ID:ID741891;
 
 
***********************************************************************************************;
*************************************  End Change ID741891 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID756442 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID756442;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID756442")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID756442;
%goto ID756442;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID756442;
* Insert record into change management table for CHANGE_ID: ID756442;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID756442",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID756442;
 
%end;
 
 
 
 
 
 
proc sql;
 
DELETE FROM &m_di_data..GLOBAL_SETTING
WHERE SPEC_NM ='NEW_PROFILE_ATTRS_TOP_PRIORITY' and APP = 'ALL';
 
INSERT INTO &m_di_data..GLOBAL_SETTING (SPEC_NM,APP,SPEC_VALUE,SPEC_DESC) VALUES
('NEW_PROFILE_ATTRS_TOP_PRIORITY','ALL','1',
'Specifies whether attributes of newly added profiles should have top priority for a product.');
 
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID756442;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID756442;
%put ERROR- Description                              : New global setting NEW_PROFILE_ATTRS_TOP_PRIORITY;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 03MAY2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID756442;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID756442",
"New global setting NEW_PROFILE_ATTRS_TOP_PRIORITY",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID756442:;
 
 
* End of changes for CHANGE_ID:ID756442;
 
 
***********************************************************************************************;
*************************************  End Change ID756442 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID749298 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID749298;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID749298")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(&m_di_data)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_di_data;
%put NOTE- Change ID                             :ID749298;
%goto ID749298;
 
%end;
%if not (%sysfunc(exist(&m_di_data..GLOBAL_SETTING))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_data..GLOBAL_SETTING;
%put NOTE- Change ID                             :ID749298;
%goto ID749298;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID749298;
%goto ID749298;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID749298;
* Insert record into change management table for CHANGE_ID: ID749298;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID749298",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID749298;
 
%end;
 
 
 
 
 
proc sql noprint ;
DELETE FROM &m_di_data..GLOBAL_SETTING where upcase(SPEC_NM) = 'UPDATE_COMP_PRICES_AFTER_RECLASS'
and upcase(APP) = 'RPO';
 
Insert into &m_di_data..GLOBAL_SETTING
(SPEC_NM, APP, SPEC_VALUE, SPEC_DESC)
values ("UPDATE_COMP_PRICES_AFTER_RECLASS","RPO", "0", "End competitor price when location is reclassed")
;
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID749298;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID749298;
%put ERROR- Description                              : NF:Manage competitor data when locations are reclassed;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 02MAY2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID749298;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID749298",
"NF:Manage competitor data when locations are reclassed",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID749298:;
 
 
* End of changes for CHANGE_ID:ID749298;
 
 
***********************************************************************************************;
*************************************  End Change ID749298 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID626118 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID626118;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID626118")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_data..global_setting))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_data..global_setting;
%put NOTE- Change ID                             :ID626118;
%goto ID626118;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID626118;
%goto ID626118;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID626118;
* Insert record into change management table for CHANGE_ID: ID626118;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID626118",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID626118;
 
%end;
 
 
 
 
 
 
proc sql;
 
DELETE FROM &m_di_data..GLOBAL_SETTING
WHERE SPEC_NM ='MAX_CLIENT_ALERT_COUNT' and APP = 'RPO';
 
INSERT INTO &m_di_data..GLOBAL_SETTING (SPEC_NM,APP,SPEC_VALUE,SPEC_DESC) VALUES
('MAX_CLIENT_ALERT_COUNT','RPO','10000',
'Specifies the maximum number of alerts that can be displayed in the SAS Regular Price Optimization UI.');
 
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID626118;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID626118;
%put ERROR- Description                              : New global setting MAX_CLIENT_ALERT_COUNT;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 03MAY2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID626118;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID626118",
"New global setting MAX_CLIENT_ALERT_COUNT",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID626118:;
 
 
* End of changes for CHANGE_ID:ID626118;
 
 
***********************************************************************************************;
*************************************  End Change ID626118 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID742950A ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID742950A;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID742950A")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(&m_di_mon.)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_di_mon.;
%put NOTE- Change ID                             :ID742950A;
%goto ID742950A;
 
%end;
%if not (%sysfunc(exist(&m_di_mon..JOB_PARAM))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_mon..JOB_PARAM;
%put NOTE- Change ID                             :ID742950A;
%goto ID742950A;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID742950A;
%goto ID742950A;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID742950A;
* Insert record into change management table for CHANGE_ID: ID742950A;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID742950A",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID742950A;
 
%end;
 
 
 
 
 
proc sql;
delete from &m_di_mon..JOB_PARAM
where upcase(jobname) = "LOAD_STG2DM_GEO_DATE" and upcase(PARAM_NAME)="FULL_REFRESH";
 
insert into &m_di_mon..JOB_PARAM values("LOAD_STG2DM_GEO_DATE", "full_refresh",'','"0"');
quit;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID742950A;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID742950A;
%put ERROR- Description                              : Add parameter 'FULL_REFRESH' in DI_MON.JOB_PARAM for LOAD_STG2DM_GEO_DATE job;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 05MAY2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID742950A;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID742950A",
"Add parameter 'FULL_REFRESH' in DI_MON.JOB_PARAM for LOAD_STG2DM_GEO_DATE job",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID742950A:;
 
 
* End of changes for CHANGE_ID:ID742950A;
 
 
***********************************************************************************************;
*************************************  End Change ID742950A ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID742950B ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID742950B;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID742950B")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(&m_di_mon.)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_di_mon.;
%put NOTE- Change ID                             :ID742950B;
%goto ID742950B;
 
%end;
%if not (%sysfunc(exist(&m_di_mon..JOB_PARAM))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_mon..JOB_PARAM;
%put NOTE- Change ID                             :ID742950B;
%goto ID742950B;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID742950B;
%goto ID742950B;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID742950B;
* Insert record into change management table for CHANGE_ID: ID742950B;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID742950B",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID742950B;
 
%end;
 
 
 
 
 
proc sql;
alter table &m_di_mon..stg_geo_season_x
add CHANGE_FLG char(1);
 
quit;
 
 
 
proc sql;
alter table &m_didm_stg..stg_geo_season
add CHANGE_FLG char(1);
update &m_didm_stg..stg_geo_season
set CHANGE_FLG='I';
 
quit;
 
 
 
proc datasets nolist library=&m_didm_stg.; modify stg_geo_season;
ic create Not Null (change_flg);
run;quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID742950B;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID742950B;
%put ERROR- Description                              : Add change flag to DI_MON.STG_GEO_SEASON_X and DIDM_STG.STG_GEO_SEASON;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 05MAY2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID742950B;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID742950B",
"Add change flag to DI_MON.STG_GEO_SEASON_X and DIDM_STG.STG_GEO_SEASON",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID742950B:;
 
 
* End of changes for CHANGE_ID:ID742950B;
 
 
***********************************************************************************************;
*************************************  End Change ID742950B ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID742950C ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID742950C;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID742950C")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(&m_didm_stg.)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_didm_stg.;
%put NOTE- Change ID                             :ID742950C;
%goto ID742950C;
 
%end;
%if not (%sysfunc(libref(&m_di_mon)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_di_mon;
%put NOTE- Change ID                             :ID742950C;
%goto ID742950C;
 
%end;
%if not (%sysfunc(exist(&m_didm_stg..Stg_geo_prod_owned_inv))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_didm_stg..Stg_geo_prod_owned_inv;
%put NOTE- Change ID                             :ID742950C;
%goto ID742950C;
 
%end;
%if not (%sysfunc(exist(&m_di_mon..Stg_geo_prod_owned_inv_x))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_mon..Stg_geo_prod_owned_inv_x;
%put NOTE- Change ID                             :ID742950C;
%goto ID742950C;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID742950C;
%goto ID742950C;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID742950C;
* Insert record into change management table for CHANGE_ID: ID742950C;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID742950C",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID742950C;
 
%end;
 
 
 
 
 
proc sql;
alter table &m_di_mon..STG_GEO_PROD_OWNED_INV_X
add CHANGE_FLG char(1);
 
quit;
 
proc sql;
alter table &m_didm_stg..STG_GEO_PROD_OWNED_INV
add CHANGE_FLG char(1);
update &m_didm_stg..STG_GEO_PROD_OWNED_INV
set CHANGE_FLG='I';
 
quit;
 
 
proc datasets nolist library=&m_didm_stg.; modify STG_GEO_PROD_OWNED_INV;
ic create Not Null (change_flg);
run;quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID742950C;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID742950C;
%put ERROR- Description                              : Adding change flag to GEO_PROD_OWN_INV;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 02May2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID742950C;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID742950C",
"Adding change flag to GEO_PROD_OWN_INV",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID742950C:;
 
 
* End of changes for CHANGE_ID:ID742950C;
 
 
***********************************************************************************************;
*************************************  End Change ID742950C ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID742950D ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID742950D;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID742950D")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(&m_didm_stg.)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_didm_stg.;
%put NOTE- Change ID                             :ID742950D;
%goto ID742950D;
 
%end;
%if not (%sysfunc(exist(&m_didm_stg..Stg_sales_mix_day_of_week))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_didm_stg..Stg_sales_mix_day_of_week;
%put NOTE- Change ID                             :ID742950D;
%goto ID742950D;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID742950D;
%goto ID742950D;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID742950D;
* Insert record into change management table for CHANGE_ID: ID742950D;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID742950D",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID742950D;
 
%end;
 
 
 
 
 
proc sql;
alter table &m_didm_stg..Stg_sales_mix_day_of_week
add CHANGE_FLG char(1);
update &m_didm_stg..Stg_sales_mix_day_of_week
set CHANGE_FLG='I';
quit;
 
 
 
proc datasets nolist library=&m_didm_stg.; modify Stg_sales_mix_day_of_week;
ic create Not Null (change_flg);
run;quit;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID742950D;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID742950D;
%put ERROR- Description                              : Adding change flag to SALES_MIX_DAY_OF_WEEK;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 05May2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID742950D;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID742950D",
"Adding change flag to SALES_MIX_DAY_OF_WEEK",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID742950D:;
 
 
* End of changes for CHANGE_ID:ID742950D;
 
 
***********************************************************************************************;
*************************************  End Change ID742950D ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID757659 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID757659;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID757659")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(&m_didm_stg.)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_didm_stg.;
%put NOTE- Change ID                             :ID757659;
%goto ID757659;
 
%end;
%if not (%sysfunc(libref(&m_di_mon.)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_di_mon.;
%put NOTE- Change ID                             :ID757659;
%goto ID757659;
 
%end;
%if not (%sysfunc(exist(&m_didm_stg..Stg_prf_sales))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_didm_stg..Stg_prf_sales;
%put NOTE- Change ID                             :ID757659;
%goto ID757659;
 
%end;
%if not (%sysfunc(exist(&m_di_mon..stg_prf_sales_x))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_mon..stg_prf_sales_x;
%put NOTE- Change ID                             :ID757659;
%goto ID757659;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID757659;
%goto ID757659;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID757659;
* Insert record into change management table for CHANGE_ID: ID757659;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID757659",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID757659;
 
%end;
 
 
 
 
 
proc sql;
alter table &m_didm_stg..stg_prf_sales
add CHANGE_FLG char(1);
quit;
 
data &m_didm_stg..stg_prf_sales;
set &m_didm_stg..stg_prf_Sales;
CHANGE_FLG = 'I';
run;
 
proc sql;
alter table &m_didm_stg..stg_prf_Sales add NOT NULL(CHANGE_FLG);
quit;
 
proc sql;
alter table &m_di_mon..stg_prf_sales_x
add CHANGE_FLG char(1);
quit;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID757659;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID757659;
%put ERROR- Description                              : Adding change flag to PRF_SALES_FACT;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 06May2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID757659;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID757659",
"Adding change flag to PRF_SALES_FACT",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID757659:;
 
 
* End of changes for CHANGE_ID:ID757659;
 
 
***********************************************************************************************;
*************************************  End Change ID757659 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change STG_PRF_SALES_FACT_CONSTR ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: STG_PRF_SALES_FACT_CONSTR;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("STG_PRF_SALES_FACT_CONSTR")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(&m_didm_stg.)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_didm_stg.;
%put NOTE- Change ID                             :STG_PRF_SALES_FACT_CONSTR;
%goto STG_PRF_SALES_FACT_CONSTR;
 
%end;
%if not (%sysfunc(exist(&m_didm_stg..Stg_prf_sales))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_didm_stg..Stg_prf_sales;
%put NOTE- Change ID                             :STG_PRF_SALES_FACT_CONSTR;
%goto STG_PRF_SALES_FACT_CONSTR;
 
%end;
%if not (%sysfunc(exist(&m_di_mon..stg_prf_sales_x))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_mon..stg_prf_sales_x;
%put NOTE- Change ID                             :STG_PRF_SALES_FACT_CONSTR;
%goto STG_PRF_SALES_FACT_CONSTR;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : STG_PRF_SALES_FACT_CONSTR;
%goto STG_PRF_SALES_FACT_CONSTR;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : STG_PRF_SALES_FACT_CONSTR;
* Insert record into change management table for CHANGE_ID: STG_PRF_SALES_FACT_CONSTR;
proc sql;
insert  into di_data.data_model_change_management
values (
"STG_PRF_SALES_FACT_CONSTR",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto STG_PRF_SALES_FACT_CONSTR;
 
%end;
 
 
 
 
 
 
data &m_didm_stg..stg_prf_sales;
set &m_didm_stg..stg_prf_Sales;
run;
 
proc sql;
alter table &m_didm_stg..STG_PRF_SALES add NOT NULL (PROD_ID);
alter table &m_didm_stg..STG_PRF_SALES add NOT NULL (GEO_ID);
alter table &m_didm_stg..STG_PRF_SALES add NOT NULL (START_DT);
alter table &m_didm_stg..STG_PRF_SALES add NOT NULL (SALES_UNITS);
alter table &m_didm_stg..STG_PRF_SALES add NOT NULL (SALES_AMT);
alter table &m_didm_stg..STG_PRF_SALES add NOT NULL (CHANGE_FLG);
quit;
 
 
 
 
* Check for errors while processing CHANGE_ID: STG_PRF_SALES_FACT_CONSTR;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: STG_PRF_SALES_FACT_CONSTR;
%put ERROR- Description                              : Adding dropped constraints back to STG_PRF_SALES_FACT;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 15JUL2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: STG_PRF_SALES_FACT_CONSTR;
proc sql;
insert  into di_data.data_model_change_management
values (
"STG_PRF_SALES_FACT_CONSTR",
"Adding dropped constraints back to STG_PRF_SALES_FACT",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%STG_PRF_SALES_FACT_CONSTR:;
 
 
* End of changes for CHANGE_ID:STG_PRF_SALES_FACT_CONSTR;
 
 
***********************************************************************************************;
*************************************  End Change STG_PRF_SALES_FACT_CONSTR ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID757660 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID757660;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID757660")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(&m_didm_stg.)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_didm_stg.;
%put NOTE- Change ID                             :ID757660;
%goto ID757660;
 
%end;
%if not (%sysfunc(libref(&m_di_mon.)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_di_mon.;
%put NOTE- Change ID                             :ID757660;
%goto ID757660;
 
%end;
%if not (%sysfunc(exist(&m_didm_stg..Stg_prf_stockout))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_didm_stg..Stg_prf_stockout;
%put NOTE- Change ID                             :ID757660;
%goto ID757660;
 
%end;
%if not (%sysfunc(exist(&m_di_mon..stg_prf_stockout_x))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_mon..stg_prf_stockout_x;
%put NOTE- Change ID                             :ID757660;
%goto ID757660;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID757660;
%goto ID757660;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID757660;
* Insert record into change management table for CHANGE_ID: ID757660;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID757660",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID757660;
 
%end;
 
 
 
 
 
proc sql;
alter table &m_didm_stg..stg_prf_stockout
add CHANGE_FLG char(1);
quit;
 
data &m_didm_stg..stg_prf_stockout;
set &m_didm_stg..stg_prf_stockout;
CHANGE_FLG = 'I';
run;
 
proc sql;
alter table &m_didm_stg..stg_prf_stockout add NOT NULL(CHANGE_FLG);
quit;
 
proc sql;
alter table &m_di_mon..stg_prf_stockout_x
add CHANGE_FLG char(1);
quit;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID757660;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID757660;
%put ERROR- Description                              : Adding change flag to PRF_STOCKOUT_FACT;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 06May2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID757660;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID757660",
"Adding change flag to PRF_STOCKOUT_FACT",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID757660:;
 
 
* End of changes for CHANGE_ID:ID757660;
 
 
***********************************************************************************************;
*************************************  End Change ID757660 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change STG_PRF_STOCKOUT_FACT_CONSTR ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: STG_PRF_STOCKOUT_FACT_CONSTR;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("STG_PRF_STOCKOUT_FACT_CONSTR")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(&m_didm_stg.)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_didm_stg.;
%put NOTE- Change ID                             :STG_PRF_STOCKOUT_FACT_CONSTR;
%goto STG_PRF_STOCKOUT_FACT_CONSTR;
 
%end;
%if not (%sysfunc(exist(&m_didm_stg..Stg_prf_stockout))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_didm_stg..Stg_prf_stockout;
%put NOTE- Change ID                             :STG_PRF_STOCKOUT_FACT_CONSTR;
%goto STG_PRF_STOCKOUT_FACT_CONSTR;
 
%end;
%if not (%sysfunc(exist(&m_di_mon..stg_prf_stockout_x))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_mon..stg_prf_stockout_x;
%put NOTE- Change ID                             :STG_PRF_STOCKOUT_FACT_CONSTR;
%goto STG_PRF_STOCKOUT_FACT_CONSTR;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : STG_PRF_STOCKOUT_FACT_CONSTR;
%goto STG_PRF_STOCKOUT_FACT_CONSTR;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : STG_PRF_STOCKOUT_FACT_CONSTR;
* Insert record into change management table for CHANGE_ID: STG_PRF_STOCKOUT_FACT_CONSTR;
proc sql;
insert  into di_data.data_model_change_management
values (
"STG_PRF_STOCKOUT_FACT_CONSTR",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto STG_PRF_STOCKOUT_FACT_CONSTR;
 
%end;
 
 
 
 
 
data &m_didm_stg..stg_prf_stockout;
set &m_didm_stg..stg_prf_stockout;
run;
 
proc sql;
alter table &m_didm_stg..STG_PRF_STOCKOUT add NOT NULL (PROD_ID);
alter table &m_didm_stg..STG_PRF_STOCKOUT add NOT NULL (GEO_ID);
alter table &m_didm_stg..STG_PRF_STOCKOUT add NOT NULL (START_DT);
alter table &m_didm_stg..STG_PRF_STOCKOUT add NOT NULL (END_DT);
alter table &m_didm_stg..stg_prf_stockout add NOT NULL (CHANGE_FLG);
quit;
 
 
 
 
* Check for errors while processing CHANGE_ID: STG_PRF_STOCKOUT_FACT_CONSTR;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: STG_PRF_STOCKOUT_FACT_CONSTR;
%put ERROR- Description                              : Adding dropped constraints back to PRF_STOCKOUT_FACT;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 15JUL2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: STG_PRF_STOCKOUT_FACT_CONSTR;
proc sql;
insert  into di_data.data_model_change_management
values (
"STG_PRF_STOCKOUT_FACT_CONSTR",
"Adding dropped constraints back to PRF_STOCKOUT_FACT",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%STG_PRF_STOCKOUT_FACT_CONSTR:;
 
 
* End of changes for CHANGE_ID:STG_PRF_STOCKOUT_FACT_CONSTR;
 
 
***********************************************************************************************;
*************************************  End Change STG_PRF_STOCKOUT_FACT_CONSTR ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID758581 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID758581;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID758581")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID758581;
%goto ID758581;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID758581;
* Insert record into change management table for CHANGE_ID: ID758581;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID758581",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID758581;
 
%end;
 
 
 
 
 
 
proc sql noprint;
drop table &m_di_data..PRF_SSD_SRC;
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID758581;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID758581;
%put ERROR- Description                              : SIZE PROFILING 3.2 SCHEMA CHANGES PART III;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 13MAY2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID758581;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID758581",
"SIZE PROFILING 3.2 SCHEMA CHANGES PART III",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID758581:;
 
 
* End of changes for CHANGE_ID:ID758581;
 
 
***********************************************************************************************;
*************************************  End Change ID758581 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID722108 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID722108;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID722108")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_data..global_setting))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_data..global_setting;
%put NOTE- Change ID                             :ID722108;
%goto ID722108;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID722108;
%goto ID722108;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID722108;
* Insert record into change management table for CHANGE_ID: ID722108;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID722108",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID722108;
 
%end;
 
 
 
 
 
proc sql;
delete from &m_di_data..global_setting where spec_nm = 'GEO_HIER_TYPE';
delete from &m_di_data..global_setting where spec_nm = 'PROD_HIER_TYPE';
quit;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID722108;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID722108;
%put ERROR- Description                              : Remove global setting GEO_HIER_TYPE and PROD_HIER_TYPE;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 12May2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID722108;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID722108",
"Remove global setting GEO_HIER_TYPE and PROD_HIER_TYPE",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID722108:;
 
 
* End of changes for CHANGE_ID:ID722108;
 
 
***********************************************************************************************;
*************************************  End Change ID722108 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID758332 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID758332;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID758332")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(&m_didm_stg.)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_didm_stg.;
%put NOTE- Change ID                             :ID758332;
%goto ID758332;
 
%end;
%if not (%sysfunc(exist(&m_didm_stg..Stg_budget))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_didm_stg..Stg_budget;
%put NOTE- Change ID                             :ID758332;
%goto ID758332;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID758332;
%goto ID758332;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID758332;
* Insert record into change management table for CHANGE_ID: ID758332;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID758332",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID758332;
 
%end;
 
 
 
 
 
 
 
proc sql;
ALTER TABLE &m_didm_stg..STG_BUDGET
ADD REVISED_BUDGET_AMT integer format = NLNUM20.3   INFORMAT=NLNUM20.3;
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID758332;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID758332;
%put ERROR- Description                              : Adding revised_budget_amt column to STG_BUDGET table;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 13May2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID758332;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID758332",
"Adding revised_budget_amt column to STG_BUDGET table",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID758332:;
 
 
* End of changes for CHANGE_ID:ID758332;
 
 
***********************************************************************************************;
*************************************  End Change ID758332 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID758332_2 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID758332_2;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID758332_2")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID758332_2;
%goto ID758332_2;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID758332_2;
* Insert record into change management table for CHANGE_ID: ID758332_2;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID758332_2",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID758332_2;
 
%end;
 
 
 
 
 
proc sql noprint;
drop table &m_di_data..BUDGET;
quit;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID758332_2;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID758332_2;
%put ERROR- Description                              : Adding revised_budget_amt column to BUDGET table;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 10Aug2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID758332_2;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID758332_2",
"Adding revised_budget_amt column to BUDGET table",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID758332_2:;
 
 
* End of changes for CHANGE_ID:ID758332_2;
 
 
***********************************************************************************************;
*************************************  End Change ID758332_2 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change SET_IX6_IX7 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: SET_IX6_IX7;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("SET_IX6_IX7")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : SET_IX6_IX7;
%goto SET_IX6_IX7;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : SET_IX6_IX7;
* Insert record into change management table for CHANGE_ID: SET_IX6_IX7;
proc sql;
insert  into di_data.data_model_change_management
values (
"SET_IX6_IX7",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto SET_IX6_IX7;
 
%end;
 
 
 
 
 
 
proc sql noprint;
select count(*)
into :_cnt_idx_ix6
from sashelp.vindex
where upcase(libname)=upcase("&m_di_data.")
and upcase(memname) = "PRODUCT_HIER_ASSOC_DM"
and upcase(indxname) = "PROD_HIER_IX6"
;
 
select count(*)
into :_cnt_idx_ix7
from sashelp.vindex
where upcase(libname)=upcase("&m_di_data.")
and upcase(memname) = "PRODUCT_HIER_ASSOC_DM"
and upcase(indxname) = "PROD_HIER_IX7"
;
quit;
 
%if &_cnt_idx_ix7 = 0 %then
%do;
 
%if &_cnt_idx_ix6 >0 %then
%do;
 
proc sql noprint;
 
DROP INDEX PROD_HIER_IX6 FROM &m_di_data..PRODUCT_HIER_ASSOC_DM;
 
quit;
 
%end;
 
proc sql noprint;
 
 
CREATE INDEX PROD_HIER_IX6 ON &m_di_data..PRODUCT_HIER_ASSOC_DM
(
PROD_HIER_SK,
PARENT_PROD_LVL
)
;
 
CREATE INDEX PROD_HIER_IX7 ON &m_di_data..PRODUCT_HIER_ASSOC_DM
(
PROD_HIER_ASSOC_CD,
PARENT_PROD_HIER_SK,
PROD_LVL
)
;
quit;
 
%end;
 
 
 
 
 
* Check for errors while processing CHANGE_ID: SET_IX6_IX7;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: SET_IX6_IX7;
%put ERROR- Description                              : Set indexes IX6 and IX7 on  PRODUCT_HIER_ASSOC_DM;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 20MAY2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: SET_IX6_IX7;
proc sql;
insert  into di_data.data_model_change_management
values (
"SET_IX6_IX7",
"Set indexes IX6 and IX7 on  PRODUCT_HIER_ASSOC_DM",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%SET_IX6_IX7:;
 
 
* End of changes for CHANGE_ID:SET_IX6_IX7;
 
 
***********************************************************************************************;
*************************************  End Change SET_IX6_IX7 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID757468 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID757468;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID757468")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_data..global_setting))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_data..global_setting;
%put NOTE- Change ID                             :ID757468;
%goto ID757468;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID757468;
%goto ID757468;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID757468;
* Insert record into change management table for CHANGE_ID: ID757468;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID757468",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID757468;
 
%end;
 
 
 
 
 
proc sql;
DELETE FROM &m_di_data..global_setting WHERE SPEC_NM = 'UPDATE_COMP_PRICES_AFTER_RECLASS';
INSERT INTO &m_di_data..global_setting(SPEC_NM,APP,SPEC_VALUE,SPEC_DESC)
VALUES  ('UPDATE_COMP_PRICES_AFTER_RECLASS','RPO','0',
'Specifies whether to adjust competitor prices after store reclassification.');
quit;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID757468;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID757468;
%put ERROR- Description                              : Add global setting UPDATE_COMP_PRICES_AFTER_RECLASS;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 20May2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID757468;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID757468",
"Add global setting UPDATE_COMP_PRICES_AFTER_RECLASS",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID757468:;
 
 
* End of changes for CHANGE_ID:ID757468;
 
 
***********************************************************************************************;
*************************************  End Change ID757468 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID761590 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID761590;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID761590")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_data..field_lookup_values))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_data..field_lookup_values;
%put NOTE- Change ID                             :ID761590;
%goto ID761590;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID761590;
%goto ID761590;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52,M2MI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID761590;
* Insert record into change management table for CHANGE_ID: ID761590;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID761590",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID761590;
 
%end;
 
 
 
 
 
proc sql;
 
DELETE FROM &m_di_data..FIELD_LOOKUP_VALUES
WHERE  TABLE_NAME="NOTIFICATION"
and    FIELD_NM="MESSAGE_SK"
and    FIELD_VALUE in ("-1","-2","-3","-4","99991","99992","99993","3","4","5","6","7","8","9","10","11","12","13","14","15")
;
 
insert into &m_di_data..FIELD_LOOKUP_VALUES (TABLE_NAME,     FIELD_NM,     FIELD_VALUE, FIELD_VALUE_NM, FIELD_VALUE_DESC, FIELD_DATATYPE)
values ("NOTIFICATION", "MESSAGE_SK", "6",           "Promotion Recommended By The System", "", "STRING");
insert into &m_di_data..FIELD_LOOKUP_VALUES (TABLE_NAME,     FIELD_NM,     FIELD_VALUE, FIELD_VALUE_NM, FIELD_VALUE_DESC, FIELD_DATATYPE)
values ("NOTIFICATION", "MESSAGE_SK", "5",           "Promotion Imported", "", "STRING");
insert into &m_di_data..FIELD_LOOKUP_VALUES (TABLE_NAME,     FIELD_NM,     FIELD_VALUE, FIELD_VALUE_NM, FIELD_VALUE_DESC, FIELD_DATATYPE)
values ("NOTIFICATION", "MESSAGE_SK", "15",          "Promotion Updated", "", "STRING");
insert into &m_di_data..FIELD_LOOKUP_VALUES (TABLE_NAME,     FIELD_NM,     FIELD_VALUE, FIELD_VALUE_NM, FIELD_VALUE_DESC, FIELD_DATATYPE)
values ("NOTIFICATION", "MESSAGE_SK", "3",           "Promotion With Vendor Deal Imported", "", "STRING");
insert into &m_di_data..FIELD_LOOKUP_VALUES (TABLE_NAME,     FIELD_NM,     FIELD_VALUE, FIELD_VALUE_NM, FIELD_VALUE_DESC, FIELD_DATATYPE)
values ("NOTIFICATION", "MESSAGE_SK", "4",           "Promotion With Vendor Deal Updated", "", "STRING");
insert into &m_di_data..FIELD_LOOKUP_VALUES (TABLE_NAME,     FIELD_NM,     FIELD_VALUE, FIELD_VALUE_NM, FIELD_VALUE_DESC, FIELD_DATATYPE)
values ("NOTIFICATION", "MESSAGE_SK", "11",          "Calendar Imported", "", "STRING");
insert into &m_di_data..FIELD_LOOKUP_VALUES (TABLE_NAME,     FIELD_NM,     FIELD_VALUE, FIELD_VALUE_NM, FIELD_VALUE_DESC, FIELD_DATATYPE)
values ("NOTIFICATION", "MESSAGE_SK", "7",           "Calendar Updated", "", "STRING");
insert into &m_di_data..FIELD_LOOKUP_VALUES (TABLE_NAME,     FIELD_NM,     FIELD_VALUE, FIELD_VALUE_NM, FIELD_VALUE_DESC, FIELD_DATATYPE)
values ("NOTIFICATION", "MESSAGE_SK", "12",           "Campaign Imported", "", "STRING");
insert into &m_di_data..FIELD_LOOKUP_VALUES (TABLE_NAME,     FIELD_NM,     FIELD_VALUE, FIELD_VALUE_NM, FIELD_VALUE_DESC, FIELD_DATATYPE)
values ("NOTIFICATION", "MESSAGE_SK", "8",           "Campaign Updated", "", "STRING");
insert into &m_di_data..FIELD_LOOKUP_VALUES (TABLE_NAME,     FIELD_NM,     FIELD_VALUE, FIELD_VALUE_NM, FIELD_VALUE_DESC, FIELD_DATATYPE)
values ("NOTIFICATION", "MESSAGE_SK", "13",           "Theme Imported", "", "STRING");
insert into &m_di_data..FIELD_LOOKUP_VALUES (TABLE_NAME,     FIELD_NM,     FIELD_VALUE, FIELD_VALUE_NM, FIELD_VALUE_DESC, FIELD_DATATYPE)
values ("NOTIFICATION", "MESSAGE_SK", "9",           "Theme Updated", "", "STRING");
insert into &m_di_data..FIELD_LOOKUP_VALUES (TABLE_NAME,     FIELD_NM,     FIELD_VALUE, FIELD_VALUE_NM, FIELD_VALUE_DESC, FIELD_DATATYPE)
values ("NOTIFICATION", "MESSAGE_SK", "14",           "Event Imported", "", "STRING");
insert into &m_di_data..FIELD_LOOKUP_VALUES (TABLE_NAME,     FIELD_NM,     FIELD_VALUE, FIELD_VALUE_NM, FIELD_VALUE_DESC, FIELD_DATATYPE)
values ("NOTIFICATION", "MESSAGE_SK", "10",           "Event Updated", "", "STRING");
insert into &m_di_data..FIELD_LOOKUP_VALUES (TABLE_NAME,     FIELD_NM,     FIELD_VALUE, FIELD_VALUE_NM, FIELD_VALUE_DESC, FIELD_DATATYPE)
values ("NOTIFICATION", "MESSAGE_SK", "99991",       "Price Changed", "", "STRING");
insert into &m_di_data..FIELD_LOOKUP_VALUES (TABLE_NAME,     FIELD_NM,     FIELD_VALUE, FIELD_VALUE_NM, FIELD_VALUE_DESC, FIELD_DATATYPE)
values ("NOTIFICATION", "MESSAGE_SK", "99992",       "Cost Changed", "", "STRING");
insert into &m_di_data..FIELD_LOOKUP_VALUES (TABLE_NAME,     FIELD_NM,     FIELD_VALUE, FIELD_VALUE_NM, FIELD_VALUE_DESC, FIELD_DATATYPE)
values ("NOTIFICATION", "MESSAGE_SK", "99993",       "Product Changed", "", "STRING");
insert into &m_di_data..FIELD_LOOKUP_VALUES (TABLE_NAME,     FIELD_NM,     FIELD_VALUE, FIELD_VALUE_NM, FIELD_VALUE_DESC, FIELD_DATATYPE)
values ("NOTIFICATION", "MESSAGE_SK", "-1",          "Spots Assigned", "", "STRING");
insert into &m_di_data..FIELD_LOOKUP_VALUES (TABLE_NAME,     FIELD_NM,     FIELD_VALUE, FIELD_VALUE_NM, FIELD_VALUE_DESC, FIELD_DATATYPE)
values ("NOTIFICATION", "MESSAGE_SK", "-2",          "Spots Unassigned", "", "STRING");
insert into &m_di_data..FIELD_LOOKUP_VALUES (TABLE_NAME,     FIELD_NM,     FIELD_VALUE, FIELD_VALUE_NM, FIELD_VALUE_DESC, FIELD_DATATYPE)
values ("NOTIFICATION", "MESSAGE_SK", "-3",          "Status Changed", "", "STRING");
insert into &m_di_data..FIELD_LOOKUP_VALUES (TABLE_NAME,     FIELD_NM,     FIELD_VALUE, FIELD_VALUE_NM, FIELD_VALUE_DESC, FIELD_DATATYPE)
values ("NOTIFICATION", "MESSAGE_SK", "-4",          "Promotion Unapproved", "", "STRING");
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID761590;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID761590;
%put ERROR- Description                              : Add notifications to field_lookup_values;
%put ERROR- Version                                  : D3MICM52,M2MI42;
%put ERROR- Date of Change                           : 24May2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID761590;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID761590",
"Add notifications to field_lookup_values",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID761590:;
 
 
* End of changes for CHANGE_ID:ID761590;
 
 
***********************************************************************************************;
*************************************  End Change ID761590 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID757661 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID757661;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID757661")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID757661;
%goto ID757661;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID757661;
* Insert record into change management table for CHANGE_ID: ID757661;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID757661",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID757661;
 
%end;
 
 
 
 
 
proc sql noprint;
DELETE FROM &m_di_mon..job_param where jobname = 'LOAD_STG2DM_PRF_GEO_PROD_STATUS'
and param_name='etlp_prf_gps_reload_data';
 
Insert into &m_di_mon..job_param
(jobname, param_name, param_value, default_func)
values("LOAD_STG2DM_PRF_GEO_PROD_STATUS", "etlp_prf_gps_reload_data", "0", '"0"')
;
 
DELETE FROM &m_di_mon..job_param where jobname = 'LOAD_STG2DM_PRF_GEO_PROD_STATUS'
and param_name = 'etlp_prf_gps_reload_hist_frm_dt';
 
Insert into &m_di_mon..job_param
(jobname, param_name, param_value, default_func)
values("LOAD_STG2DM_PRF_GEO_PROD_STATUS", "etlp_prf_gps_reload_hist_frm_dt", "0", '"0"')
;
quit;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID757661;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID757661;
%put ERROR- Description                              : NF : Reload hiostory feature in PRF_GEO_PROD_STATUS;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 25MAY2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID757661;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID757661",
"NF : Reload hiostory feature in PRF_GEO_PROD_STATUS",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID757661:;
 
 
* End of changes for CHANGE_ID:ID757661;
 
 
***********************************************************************************************;
*************************************  End Change ID757661 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID758332_1 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID758332_1;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID758332_1")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(&m_di_mon.)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_di_mon.;
%put NOTE- Change ID                             :ID758332_1;
%goto ID758332_1;
 
%end;
%if not (%sysfunc(exist(&m_di_mon..STG_BUDGET_X))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_mon..STG_BUDGET_X;
%put NOTE- Change ID                             :ID758332_1;
%goto ID758332_1;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID758332_1;
%goto ID758332_1;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID758332_1;
* Insert record into change management table for CHANGE_ID: ID758332_1;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID758332_1",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID758332_1;
 
%end;
 
 
 
 
 
 
proc sql;
ALTER TABLE &m_di_mon..STG_BUDGET_X
ADD REVISED_BUDGET_AMT integer format = NLNUM12.2   INFORMAT=NLNUM12.2;
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID758332_1;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID758332_1;
%put ERROR- Description                              : Adding revised_budget_amt column to STG_BUDGET_X table;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 25May2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID758332_1;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID758332_1",
"Adding revised_budget_amt column to STG_BUDGET_X table",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID758332_1:;
 
 
* End of changes for CHANGE_ID:ID758332_1;
 
 
***********************************************************************************************;
*************************************  End Change ID758332_1 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change PARAM_PROMO_EXPORT ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: PARAM_PROMO_EXPORT;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("PARAM_PROMO_EXPORT")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_mon..job_param))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_mon..job_param;
%put NOTE- Change ID                             :PARAM_PROMO_EXPORT;
%goto PARAM_PROMO_EXPORT;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : PARAM_PROMO_EXPORT;
%goto PARAM_PROMO_EXPORT;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : PARAM_PROMO_EXPORT;
* Insert record into change management table for CHANGE_ID: PARAM_PROMO_EXPORT;
proc sql;
insert  into di_data.data_model_change_management
values (
"PARAM_PROMO_EXPORT",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto PARAM_PROMO_EXPORT;
 
%end;
 
 
 
 
 
proc sql noprint;
DELETE FROM &m_di_mon..job_param where jobname = 'DI_EXPORT_RPP_VEHICLE' and param_name='etlp_custom_attr_length';
DELETE FROM &m_di_mon..job_param where jobname = 'DI_EXPORT_RPP_VEHICLE' and param_name='etlp_get_prod_at_level';
DELETE FROM &m_di_mon..job_param where jobname = 'DI_EXPORT_RPP_VEHICLE' and param_name='etlp_get_geo_at_level';
DELETE FROM &m_di_mon..job_param where jobname = 'DI_EXPORT_RPP_PRICE'   and param_name='etlp_get_prod_at_level';
DELETE FROM &m_di_mon..job_param where jobname = 'DI_EXPORT_RPP_PRICE'   and param_name='etlp_get_geo_at_level';
 
Insert into &m_di_mon..job_param
(jobname, param_name, param_value, default_func)
values("DI_EXPORT_RPP_VEHICLE", "etlp_custom_attr_length","2000",'"2000"')
;
 
Insert into &m_di_mon..job_param
(jobname, param_name, param_value, default_func)
values("DI_EXPORT_RPP_VEHICLE", "etlp_get_prod_at_level","",'""')
;
 
Insert into &m_di_mon..job_param
(jobname, param_name, param_value, default_func)
values("DI_EXPORT_RPP_VEHICLE", "etlp_get_geo_at_level","",'""')
;
 
Insert into &m_di_mon..job_param
(jobname, param_name, param_value, default_func)
values("DI_EXPORT_RPP_PRICE", "etlp_get_prod_at_level","",'""')
;
 
Insert into &m_di_mon..job_param
(jobname, param_name, param_value, default_func)
values("DI_EXPORT_RPP_PRICE", "etlp_get_geo_at_level","",'""')
;
 
quit;
 
 
 
 
 
* Check for errors while processing CHANGE_ID: PARAM_PROMO_EXPORT;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: PARAM_PROMO_EXPORT;
%put ERROR- Description                              : Add parameter for length of custom attributes for Vehicle Export;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 01JUN2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: PARAM_PROMO_EXPORT;
proc sql;
insert  into di_data.data_model_change_management
values (
"PARAM_PROMO_EXPORT",
"Add parameter for length of custom attributes for Vehicle Export",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%PARAM_PROMO_EXPORT:;
 
 
* End of changes for CHANGE_ID:PARAM_PROMO_EXPORT;
 
 
***********************************************************************************************;
*************************************  End Change PARAM_PROMO_EXPORT ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID747674 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID747674;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID747674")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_data..global_setting))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_data..global_setting;
%put NOTE- Change ID                             :ID747674;
%goto ID747674;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID747674;
%goto ID747674;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID747674;
* Insert record into change management table for CHANGE_ID: ID747674;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID747674",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID747674;
 
%end;
 
 
 
 
 
proc sql;
DELETE FROM &m_di_data..global_setting WHERE SPEC_NM = 'UNIFORM_COST_METHOD';
INSERT INTO &m_di_data..global_setting(SPEC_NM,APP,SPEC_VALUE,SPEC_DESC)
VALUES  ('UNIFORM_COST_METHOD','RPO','FREQUENCY',
'Specifies the method to select a common cost when costs vary below the uniform pricing level.');
quit;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID747674;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID747674;
%put ERROR- Description                              : Add global setting UNIFORM_COST_METHOD;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 02JUN2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID747674;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID747674",
"Add global setting UNIFORM_COST_METHOD",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID747674:;
 
 
* End of changes for CHANGE_ID:ID747674;
 
 
***********************************************************************************************;
*************************************  End Change ID747674 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID765727 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID765727;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID765727")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID765727;
%goto ID765727;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID765727;
* Insert record into change management table for CHANGE_ID: ID765727;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID765727",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID765727;
 
%end;
 
 
 
 
 
 
proc sql;
 
DELETE FROM &m_di_data..GLOBAL_SETTING
WHERE SPEC_NM ='AUTO_RECOMMEND_ALERT_PRICES' and APP = 'RPO';
 
INSERT INTO &m_di_data..GLOBAL_SETTING (SPEC_NM,APP,SPEC_VALUE,SPEC_DESC) VALUES
('AUTO_RECOMMEND_ALERT_PRICES','RPO','0',
'Specifies whether the system automatically recommends new prices for incoming cost and competitive price alerts.');
 
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID765727;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID765727;
%put ERROR- Description                              : New global setting AUTO_RECOMMEND_ALERT_PRICES;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 08JUN2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID765727;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID765727",
"New global setting AUTO_RECOMMEND_ALERT_PRICES",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID765727:;
 
 
* End of changes for CHANGE_ID:ID765727;
 
 
***********************************************************************************************;
*************************************  End Change ID765727 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ADD_WEEKDAY_CORRECT_FACT ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ADD_WEEKDAY_CORRECT_FACT;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ADD_WEEKDAY_CORRECT_FACT")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ADD_WEEKDAY_CORRECT_FACT;
%goto ADD_WEEKDAY_CORRECT_FACT;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ADD_WEEKDAY_CORRECT_FACT;
* Insert record into change management table for CHANGE_ID: ADD_WEEKDAY_CORRECT_FACT;
proc sql;
insert  into di_data.data_model_change_management
values (
"ADD_WEEKDAY_CORRECT_FACT",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ADD_WEEKDAY_CORRECT_FACT;
 
%end;
 
 
 
 
 
***********************************************************************************************;
 
data &m_di_data..WEEKDAY_CORRECT_FACT;
attrib GEO_HIER_SK          length=4                                      ;
attrib DAY_OF_WEEK          length=4                                      ;
attrib CORRECTION_FACTOR    length=8 FORMAT=NLNUM12.2  INFORMAT=NLNUM12.2 ;
stop; run;
 
proc sql;
alter table &m_di_data..WEEKDAY_CORRECT_FACT add CONSTRAINT PRIM_KEY PRIMARY KEY (GEO_HIER_SK, DAY_OF_WEEK);
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ADD_WEEKDAY_CORRECT_FACT;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ADD_WEEKDAY_CORRECT_FACT;
%put ERROR- Description                              : Add WEEKDAY_CORRECT_FACT table to support DOW profiles;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 13JUN2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ADD_WEEKDAY_CORRECT_FACT;
proc sql;
insert  into di_data.data_model_change_management
values (
"ADD_WEEKDAY_CORRECT_FACT",
"Add WEEKDAY_CORRECT_FACT table to support DOW profiles",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ADD_WEEKDAY_CORRECT_FACT:;
 
 
* End of changes for CHANGE_ID:ADD_WEEKDAY_CORRECT_FACT;
 
 
***********************************************************************************************;
*************************************  End Change ADD_WEEKDAY_CORRECT_FACT ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID739120 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID739120;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID739120")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID739120;
%goto ID739120;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52, M1TKMI43);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID739120;
* Insert record into change management table for CHANGE_ID: ID739120;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID739120",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID739120;
 
%end;
 
 
 
 
 
***********************************************************************************************;
 
%macro di_etl_chk_promo_fact_part;
 
/* get the path for di_data library. */
 
proc sql noprint;
select path into :data_lib_path
from sashelp.vlibnam
where upcase(libname) = upcase("&m_di_data")
and level in (0,1);
quit;
 
/* getting the  values of all partitions */
 
%local etl_partition_level part_sk;
 
%di_util_global_setting_spec(spec_nm=PROD_PARTITION_LVL,
app=ALL,
_spec_value=etl_partition_level,
optional=1);
 
proc sql;
create table work.prod_sk_part as
select distinct(PROD_HIER_SK) as part_sk
from &m_di_data..PRODUCT_HIER_ASSOC_DM
where PROD_HIER_ASSOC_CD =1
and PROD_LVL = &etl_partition_level;
quit;
 
proc sql;
insert into work.prod_sk_part values (0);
quit;
 
/* Setting up library from which partitions will be moved*/
 
%let number_of_part = %di_util_nobs(prod_sk_part);
%put number of partitions  = &number_of_part;
 
%if &number_of_part > 0 %then %do;
 
%do loop = 1 %to &number_of_part;
data sel_row;
point_var = input("&loop",best12.);
set prod_sk_part point = point_var;
call symputx('partition_nm',part_sk, 'l');
output;
stop;
run;
 
%put Partition_nm = &partition_nm;
 
%let trg_path = %di_util_create_folder(relative_dir=1/&partition_nm,parent_dir=&data_lib_path);
libname trg_lib "&trg_path";
 
proc datasets lib = work nolist nowarn memtype = (data view);
delete etl_cons1 temp etl_cons2;
quit;
 
%if %sysfunc(exist(trg_lib.promotion_fact)) and %di_util_nobs(trg_lib.promotion_fact) > 0 %then %do;
 
proc contents nodetails noprint data=trg_lib.promotion_fact
out=work.etl_cons1 out2=etl_cons2;
run;
 
%let const_flg = 0;
%if %di_util_nobs(etl_cons2) = 0 %then %do;
%let const_flg = 1;
%end;
 
data temp(keep = name sorted sortedby);
set work.etl_cons1;
retain cnt 0;
if      (name = 'PROD_HIER_SK' and sorted = 1 and sortedby = 1) then flg = 1;
else if (name = 'GEO_HIER_SK' and sorted = 1 and sortedby = 2)then flg = 1;
else if (name = 'VEHICLE_SK' and sorted = 1 and sortedby = 3)then flg = 1;
else if (name = 'CONDITION_TYPE' and sorted = 1 and sortedby = 4)then flg = 1;
else if (name = 'RANGE_START_DISC_PCT' and sorted = 1 and sortedby = 5)then flg = 1;
else if (name = 'RANGE_END_DISC_PCT' and sorted = 1 and sortedby = 6)then flg = 1;
else if (name = 'START_DT' and sorted = 1 and sortedby = 7)then flg = 1;
else if (name = 'END_DT' and sorted = 1 and sortedby = .)then flg = 1;
else if (name = 'VEHICLE_CATEGORY_SK' and sorted = 1 and sortedby = .)then flg = 1;
else if (name = 'PRICE_VALUE' and sorted = 1 and sortedby = .) then flg = 1;
 
cnt = cnt+flg;
if cnt = . then cnt = 0;
call symputx('sort_flg1',cnt,'l');
 
run;
 
%put sort_flg1 = &sort_flg1;
 
%if &sort_flg1 = 10 %then %do;
%put Data for partition &partition_nm already sorted. No need to resort.;
%end;
 
%else %do;/*&sort_flg1 = 10*/
%if &const_flg = 0 %then %do;
%etl_drop(trg_lib.promotion_fact,ic);
%etl_drop(trg_lib.promotion_fact,index);
%end;
 
proc sort data = trg_lib.promotion_fact;
by prod_hier_sk geo_hier_sk vehicle_sk condition_type range_start_disc_pct range_end_disc_pct start_dt ;
quit;
%if &const_flg = 0 %then %do;
data _null_;
set work.etl_cons2 end=eof;
if _n_ eq 1 then do;
call execute("proc datasets lib = trg_lib nolist; modify promotion_fact;");
end;
call execute("      " || recreate);
if eof then call execute("quit;");
run;
%end;
%end;/*&sort_flg1 = 10*/
%end;/*%sysfunc(exist(trg_lib.promotion_fact)) and %di_util_nobs(trg_lib.promotion_fact) > 0*/
%else %do;
%put Either Promotion Fact in Partition &partition_nm does not exist or have no data;
%end;
 
/*promotion_fact_future*/
 
proc datasets lib = work nolist nowarn memtype = (data view);
delete etl_cons1 temp2 etl_cons2;
quit;
 
%if %sysfunc( exist(trg_lib.promotion_fact_future)) and %di_util_nobs(trg_lib.promotion_fact_future) > 0 %then %do;
 
proc contents nodetails noprint data=trg_lib.promotion_fact_future
out=work.etl_cons1 out2=work.etl_cons2;
run;
 
%let const_flg = 0;
%if %di_util_nobs(etl_cons2) = 0 %then %do;
%let const_flg = 1;
%end;
 
data temp2(keep = name sorted sortedby);
set etl_cons1;
retain cnt 0;
if      (name = 'PROD_HIER_SK' and sorted = 1 and sortedby = 1) then flg = 1;
else if (name = 'GEO_HIER_SK' and sorted = 1 and sortedby = 2)then flg = 1;
else if (name = 'VEHICLE_SK' and sorted = 1 and sortedby = 3)then flg = 1;
else if (name = 'CONDITION_TYPE' and sorted = 1 and sortedby = 4)then flg = 1;
else if (name = 'RANGE_START_DISC_PCT' and sorted = 1 and sortedby = 5)then flg = 1;
else if (name = 'RANGE_END_DISC_PCT' and sorted = 1 and sortedby = 6)then flg = 1;
else if (name = 'START_DT' and sorted = 1 and sortedby = 7)then flg = 1;
else if (name = 'END_DT' and sorted = 1 and sortedby = .)then flg = 1;
else if (name = 'VEHICLE_CATEGORY_SK' and sorted = 1 and sortedby = .)then flg = 1;
else if (name = 'PRICE_VALUE' and sorted = 1 and sortedby = .) then flg = 1;
 
cnt = cnt+flg;
if cnt = . then cnt = 0;
call symputx('sort_flg2',cnt,'l');
run;
 
%put sort_flg = &sort_flg2;
 
%if &sort_flg2 = 10 %then %do;
%put Data for partition &partition_nm already sorted. No need to resort.;
%end;
 
%else %do;
%if &const_flg = 0 %then %do;
%etl_drop(trg_lib.promotion_fact_future,ic);
%etl_drop(trg_lib.promotion_fact_future,index);
%end;
 
proc sort data = trg_lib.promotion_fact_future;
by prod_hier_sk geo_hier_sk vehicle_sk condition_type range_start_disc_pct range_end_disc_pct start_dt ;
quit;
 
%if &const_flg = 0 %then %do;
data _null_;
set work.etl_cons2 end=eof;
if _n_ eq 1 then do;
call execute("proc datasets lib = trg_lib nolist; modify promotion_fact_future;");
end;
call execute("      " || recreate);
if eof then call execute("quit;");
run;
%end;
 
%end;/*&sort_flg2 = 10*/
%end;/*%sysfunc( exist(trg_lib.promotion_fact_future)) and %di_util_nobs(trg_lib.promotion_fact_future) > 0*/
%else %do;
%put Either Promotion Fact Future in Partition &partition_nm does not exist or have no data;
%end;
%end;/*%do loop = 1 %to &number_of_part*/
%end;/*if &number_of_part > 0*/
 
%mend ;
 
%di_etl_chk_promo_fact_part;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID739120;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID739120;
%put ERROR- Description                              : Check the sort order for all promotion_fact and promotion_fact_future partitions;
%put ERROR- Version                                  : D3MICM52, M1TKMI43;
%put ERROR- Date of Change                           : 15JUN2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID739120;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID739120",
"Check the sort order for all promotion_fact and promotion_fact_future partitions",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID739120:;
 
 
* End of changes for CHANGE_ID:ID739120;
 
 
***********************************************************************************************;
*************************************  End Change ID739120 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID761590_2 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID761590_2;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID761590_2")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_data..target_metrics))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_data..target_metrics;
%put NOTE- Change ID                             :ID761590_2;
%goto ID761590_2;
 
%end;
%if not (%sysfunc(exist(&m_di_data..field_lookup_values))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_data..field_lookup_values;
%put NOTE- Change ID                             :ID761590_2;
%goto ID761590_2;
 
%end;
%if not (%sysfunc(exist(&m_di_data..reference_values))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_data..reference_values;
%put NOTE- Change ID                             :ID761590_2;
%goto ID761590_2;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID761590_2;
%goto ID761590_2;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52,M2MI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID761590_2;
* Insert record into change management table for CHANGE_ID: ID761590_2;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID761590_2",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID761590_2;
 
%end;
 
 
 
 
 
 
 
proc sql;
DELETE FROM &m_di_data..field_lookup_values WHERE (table_name='ALL' AND field_nm='KPI_TYPE');
INSERT INTO &m_di_data..field_lookup_values (table_name,field_nm,field_value,field_value_nm,field_value_desc,field_datatype)
VALUES ('ALL','KPI_TYPE','1','actual', 'current year actual', 'INTEGER');
INSERT INTO &m_di_data..field_lookup_values (table_name,field_nm,field_value,field_value_nm,field_value_desc,field_datatype)
VALUES ('ALL','KPI_TYPE','2','actual_ly', 'last year actual', 'INTEGER');
INSERT INTO &m_di_data..field_lookup_values (table_name,field_nm,field_value,field_value_nm,field_value_desc,field_datatype)
VALUES ('ALL','KPI_TYPE','3','baseline', 'baseline', 'INTEGER');
INSERT INTO &m_di_data..field_lookup_values (table_name,field_nm,field_value,field_value_nm,field_value_desc,field_datatype)
VALUES ('ALL','KPI_TYPE','4','forecast', 'forecast considering approved plans only', 'INTEGER');
INSERT INTO &m_di_data..field_lookup_values (table_name,field_nm,field_value,field_value_nm,field_value_desc,field_datatype)
VALUES ('ALL','KPI_TYPE','5','forecast_ta', 'forecast considering tentatively approved plans', 'INTEGER');
INSERT INTO &m_di_data..field_lookup_values (table_name,field_nm,field_value,field_value_nm,field_value_desc,field_datatype)
VALUES ('ALL','KPI_TYPE','6','target', 'budget (provided by customer)', 'INTEGER');
quit;
 
proc sql;
DELETE FROM &m_di_data..reference_values WHERE field_nm='ATTR_TYPE';
INSERT INTO &m_di_data..reference_values (field_nm,field_value,field_short_desc)
VALUES ('ATTR_TYPE','1','Attribute is DECIMAL');
INSERT INTO &m_di_data..reference_values (field_nm,field_value,field_short_desc)
VALUES ('ATTR_TYPE','2','Attribute is STRING');
INSERT INTO &m_di_data..reference_values (field_nm,field_value,field_short_desc)
VALUES ('ATTR_TYPE','3','Attribute is INTEGER');
INSERT INTO &m_di_data..reference_values (field_nm,field_value,field_short_desc)
VALUES ('ATTR_TYPE','4','Attribute is BOOLEAN (0 or 1)');
INSERT INTO &m_di_data..reference_values (field_nm,field_value,field_short_desc)
VALUES ('ATTR_TYPE','5','Attribute is DATE as ddMMMyyyy');
INSERT INTO &m_di_data..reference_values (field_nm,field_value,field_short_desc)
VALUES ('ATTR_TYPE','6','Attribute is DATETIME as ddMMMyyyy:HH:mm:ss');
INSERT INTO &m_di_data..reference_values (field_nm,field_value,field_short_desc)
VALUES ('ATTR_TYPE','7','Attribute is PERCENT');
quit;
 
proc sql;
DELETE FROM &m_di_data..reference_values WHERE field_nm='TARGET_METRICS_TYPE';
quit;
 
data &m_di_data..target_metrics;
set &m_di_data..target_metrics;
attrib TARGET_METRICS_KPI length=4;
target_metrics_kpi = target_metrics_type;
target_metrics_type = 6;
run;
 
proc sql;
ALTER TABLE &m_di_data..target_metrics ADD CONSTRAINT PRIM_KEY PRIMARY KEY
(geo_hier_sk, prod_hier_sk, start_dt, end_dt, target_metrics_kpi, target_metrics_type);
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID761590_2;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID761590_2;
%put ERROR- Description                              : Target metrics enhancements;
%put ERROR- Version                                  : D3MICM52,M2MI42;
%put ERROR- Date of Change                           : 15JUN2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID761590_2;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID761590_2",
"Target metrics enhancements",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID761590_2:;
 
 
* End of changes for CHANGE_ID:ID761590_2;
 
 
***********************************************************************************************;
*************************************  End Change ID761590_2 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID749250 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID749250;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID749250")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID749250;
%goto ID749250;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID749250;
* Insert record into change management table for CHANGE_ID: ID749250;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID749250",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID749250;
 
%end;
 
 
 
 
 
proc sql noprint;
DELETE FROM &m_di_mon..job_param where upcase(jobname) = 'LOAD_STG2DM_GEO_PROD'
and upcase(param_name) = 'ETLP_RELOAD_HISTORY_DATA';
 
Insert into &m_di_mon..job_param
(jobname, param_name, param_value, default_func)
values("LOAD_STG2DM_GEO_PROD", "etlp_reload_history_data", "0", '"0"')
;
 
DELETE FROM &m_di_mon..job_param where upcase(jobname) = 'LOAD_STG2DM_GEO_PROD'
and upcase(param_name) = 'ETLP_RELOAD_HISTORY_FROM_DT';
 
Insert into &m_di_mon..job_param
(jobname, param_name, param_value, default_func)
values("LOAD_STG2DM_GEO_PROD", "etlp_reload_history_from_dt", "0", '"0"')
;
quit;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID749250;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID749250;
%put ERROR- Description                              : NF : Reload hiostory feature in GEO_PROD;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 16JUN2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID749250;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID749250",
"NF : Reload hiostory feature in GEO_PROD",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID749250:;
 
 
* End of changes for CHANGE_ID:ID749250;
 
 
***********************************************************************************************;
*************************************  End Change ID749250 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID768005 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID768005;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID768005")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(&m_didm_stg.)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_didm_stg.;
%put NOTE- Change ID                             :ID768005;
%goto ID768005;
 
%end;
%if not (%sysfunc(exist(&m_didm_stg..STG_CUSTOM_ATTR))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_didm_stg..STG_CUSTOM_ATTR;
%put NOTE- Change ID                             :ID768005;
%goto ID768005;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID768005;
%goto ID768005;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID768005;
* Insert record into change management table for CHANGE_ID: ID768005;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID768005",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID768005;
 
%end;
 
 
 
 
 
proc sql noprint;
alter table &m_didm_stg..STG_CUSTOM_ATTR ADD PROD_ID CHAR(32);
quit;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID768005;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID768005;
%put ERROR- Description                              : Addition of custom attributes for RPP_Plan_Prod_Assgmnt;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 16JUN2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID768005;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID768005",
"Addition of custom attributes for RPP_Plan_Prod_Assgmnt",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID768005:;
 
 
* End of changes for CHANGE_ID:ID768005;
 
 
***********************************************************************************************;
*************************************  End Change ID768005 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID763584 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID763584;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID763584")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_mon..etl_sys_param))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_mon..etl_sys_param;
%put NOTE- Change ID                             :ID763584;
%goto ID763584;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID763584;
%goto ID763584;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID763584;
* Insert record into change management table for CHANGE_ID: ID763584;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID763584",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID763584;
 
%end;
 
 
 
 
 
proc sql noprint;
delete from &m_di_mon..etl_sys_param
where jobname="RPO_ALERTS"
and   param_name="RPO_ALERTS_RUN_DATE_TIME"
;
Insert into &m_di_mon..etl_sys_param
(jobname, param_name, param_value, default_func)
values("RPO_ALERTS", "RPO_ALERTS_RUN_DATE_TIME"," ", '" "');
quit;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID763584;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID763584;
%put ERROR- Description                              : Adding a Parameter in DI_MON.ETL_SYS_PARAM - RPO_ALERTS_RUN_DATE_TIME;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 17JUN2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID763584;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID763584",
"Adding a Parameter in DI_MON.ETL_SYS_PARAM - RPO_ALERTS_RUN_DATE_TIME",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID763584:;
 
 
* End of changes for CHANGE_ID:ID763584;
 
 
***********************************************************************************************;
*************************************  End Change ID763584 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID768006 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID768006;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID768006")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_didm_stg..STG_MDO_IMPORT_PLAN))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_didm_stg..STG_MDO_IMPORT_PLAN;
%put NOTE- Change ID                             :ID768006;
%goto ID768006;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID768006;
%goto ID768006;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID768006;
* Insert record into change management table for CHANGE_ID: ID768006;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID768006",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID768006;
 
%end;
 
 
 
 
 
proc sql;
ALTER TABLE &m_didm_stg..STG_MDO_IMPORT_PLAN ADD ALLOW_MARKDN_DURING_PROMO_CD num 4;
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID768006;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID768006;
%put ERROR- Description                              : Add plan setting allow markdown during promo to stage;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 17JUN2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID768006;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID768006",
"Add plan setting allow markdown during promo to stage",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID768006:;
 
 
* End of changes for CHANGE_ID:ID768006;
 
 
***********************************************************************************************;
*************************************  End Change ID768006 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID768006_1 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID768006_1;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID768006_1")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_mon..STG_MDO_IMPORT_PLAN_X))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_mon..STG_MDO_IMPORT_PLAN_X;
%put NOTE- Change ID                             :ID768006_1;
%goto ID768006_1;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID768006_1;
%goto ID768006_1;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID768006_1;
* Insert record into change management table for CHANGE_ID: ID768006_1;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID768006_1",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID768006_1;
 
%end;
 
 
 
 
 
proc sql;
ALTER TABLE &m_di_mon..STG_MDO_IMPORT_PLAN_X ADD ALLOW_MARKDN_DURING_PROMO_CD num 4;
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID768006_1;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID768006_1;
%put ERROR- Description                              : Add plan setting allow markdown during promo to MON;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 17JUN2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID768006_1;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID768006_1",
"Add plan setting allow markdown during promo to MON",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID768006_1:;
 
 
* End of changes for CHANGE_ID:ID768006_1;
 
 
***********************************************************************************************;
*************************************  End Change ID768006_1 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID768005_1 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID768005_1;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID768005_1")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(&m_di_mon.)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_di_mon.;
%put NOTE- Change ID                             :ID768005_1;
%goto ID768005_1;
 
%end;
%if not (%sysfunc(exist(&m_di_mon..STG_CUSTOM_ATTR_X))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_mon..STG_CUSTOM_ATTR_X;
%put NOTE- Change ID                             :ID768005_1;
%goto ID768005_1;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID768005_1;
%goto ID768005_1;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID768005_1;
* Insert record into change management table for CHANGE_ID: ID768005_1;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID768005_1",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID768005_1;
 
%end;
 
 
 
 
 
proc sql noprint;
alter table &m_di_mon..STG_CUSTOM_ATTR_X ADD PROD_ID CHAR(32);
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID768005_1;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID768005_1;
%put ERROR- Description                              : Addition of custom attributes for RPP_Plan_Prod_Assgmnt;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 20JUN2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID768005_1;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID768005_1",
"Addition of custom attributes for RPP_Plan_Prod_Assgmnt",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID768005_1:;
 
 
* End of changes for CHANGE_ID:ID768005_1;
 
 
***********************************************************************************************;
*************************************  End Change ID768005_1 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID763610 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID763610;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID763610")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(&m_didm_stg)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_didm_stg;
%put NOTE- Change ID                             :ID763610;
%goto ID763610;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID763610;
%goto ID763610;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID763610;
* Insert record into change management table for CHANGE_ID: ID763610;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID763610",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID763610;
 
%end;
 
 
 
 
 
%let stageExists = %sysfunc(libref(DIDM_Stg));
 
%if (&stageExists = 0) %then
%do;
 
%if %sysfunc(exist(&m_didm_stg..STG_RPP_PLAN)) %then %do;
proc sql noprint ;
alter table &m_didm_stg..STG_RPP_PLAN
add ACTIVE_PLAN_ID char(32);
quit;
%end;
 
%end;
 
 
 
* Check for errors while processing CHANGE_ID: ID763610;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID763610;
%put ERROR- Description                              : Add active_plan_id column in stg_rpp_plan;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 22JUN2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID763610;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID763610",
"Add active_plan_id column in stg_rpp_plan",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID763610:;
 
 
* End of changes for CHANGE_ID:ID763610;
 
 
***********************************************************************************************;
*************************************  End Change ID763610 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID725863 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID725863;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID725863")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(&m_di_mon.)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_di_mon.;
%put NOTE- Change ID                             :ID725863;
%goto ID725863;
 
%end;
%if not (%sysfunc(exist(&m_di_mon..JOB_PARAM))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_mon..JOB_PARAM;
%put NOTE- Change ID                             :ID725863;
%goto ID725863;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID725863;
%goto ID725863;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID725863;
* Insert record into change management table for CHANGE_ID: ID725863;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID725863",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID725863;
 
%end;
 
 
 
 
 
 
proc sql;
delete from &m_di_mon..JOB_PARAM
where upcase(jobname) = "LOAD_STG2DM_RPP_PLAN_VEHICLE" and upcase(PARAM_NAME)="FULL_REFRESH";
 
insert into &m_di_mon..JOB_PARAM values("LOAD_STG2DM_RPP_PLAN_VEHICLE", "Full_refresh",'','"0"');
quit;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID725863;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID725863;
%put ERROR- Description                              : Add parameter 'FULL_REFRESH' in DI_MON.JOB_PARAM for Load_STG2DM_Rpp_plan_vehicle;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 22JUN2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID725863;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID725863",
"Add parameter 'FULL_REFRESH' in DI_MON.JOB_PARAM for Load_STG2DM_Rpp_plan_vehicle",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID725863:;
 
 
* End of changes for CHANGE_ID:ID725863;
 
 
***********************************************************************************************;
*************************************  End Change ID725863 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID769767 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID769767;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID769767")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(&m_di_mon.)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_di_mon.;
%put NOTE- Change ID                             :ID769767;
%goto ID769767;
 
%end;
%if not (%sysfunc(exist(&m_didm_stg..stg_target_metrics))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_didm_stg..stg_target_metrics;
%put NOTE- Change ID                             :ID769767;
%goto ID769767;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID769767;
%goto ID769767;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52,M2MI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID769767;
* Insert record into change management table for CHANGE_ID: ID769767;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID769767",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID769767;
 
%end;
 
 
 
 
 
Data &m_di_mon..STG_TARGET_METRICS_X ;
attrib GEO_ID length=$32;
attrib PROD_ID length=$32;
attrib START_DT length=8 format=&m_DTFMT ;
attrib END_DT length=8 format=&m_DTFMT ;
attrib TARGET_METRICS_TYPE length=4;
attrib TARGET_METRICS_VALUE length=8 format=NLNUM12.2 ;
attrib TARGET_METRICS_KPI length=4;
attrib ETLS_EXCEPTION_COND length=$170 ;
attrib ETL_ERROR_JOBRUNTIME length=8 format=DATETIME16. ;
stop;run;
 
data &m_didm_stg..stg_target_metrics;
set &m_didm_stg..stg_target_metrics;
attrib TARGET_METRICS_KPI length=4;
run;
 
proc sql;
alter table &m_didm_stg..STG_TARGET_METRICS add NOT NULL (GEO_ID);
alter table &m_didm_stg..STG_TARGET_METRICS add NOT NULL (PROD_ID);
alter table &m_didm_stg..STG_TARGET_METRICS add NOT NULL (START_DT);
alter table &m_didm_stg..STG_TARGET_METRICS add NOT NULL (END_DT);
alter table &m_didm_stg..STG_TARGET_METRICS add NOT NULL (TARGET_METRICS_KPI);
alter table &m_didm_stg..STG_TARGET_METRICS add NOT NULL (TARGET_METRICS_VALUE);
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID769767;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID769767;
%put ERROR- Description                              : Add TARGET_METRICS_KPI to DIDM_STG.STG_TARGET_METRICS;
%put ERROR- Version                                  : D3MICM52,M2MI42;
%put ERROR- Date of Change                           : 24JUN2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID769767;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID769767",
"Add TARGET_METRICS_KPI to DIDM_STG.STG_TARGET_METRICS",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID769767:;
 
 
* End of changes for CHANGE_ID:ID769767;
 
 
***********************************************************************************************;
*************************************  End Change ID769767 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID769191 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID769191;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID769191")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID769191;
%goto ID769191;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID769191;
* Insert record into change management table for CHANGE_ID: ID769191;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID769191",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID769191;
 
%end;
 
 
 
 
 
 
proc sql;
 
DELETE FROM &m_di_data..GLOBAL_SETTING
WHERE SPEC_NM ='ADJUST_ORDER_QTY_MAX_FLG' and APP = 'SZPK';
 
INSERT INTO &m_di_data..GLOBAL_SETTING (SPEC_NM,APP,SPEC_VALUE,SPEC_DESC) VALUES
('ADJUST_ORDER_QTY_MAX_FLG','SZPK','1',
'Specifies whether to increase the maximum order quantity for the company due to mismatches across deliveries.');
 
DELETE FROM &m_di_data..GLOBAL_SETTING
WHERE SPEC_NM ='ADJUST_ORDER_QTY_MIN_FLG' and APP = 'SZPK';
 
INSERT INTO &m_di_data..GLOBAL_SETTING (SPEC_NM,APP,SPEC_VALUE,SPEC_DESC) VALUES
('ADJUST_ORDER_QTY_MIN_FLG','SZPK','0',
'Specifies whether to reduce the minimum order quantity for the company due to mismatches across deliveries.');
 
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID769191;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID769191;
%put ERROR- Description                              : New global settings ADJUST_ORDER_QTY_MAX_FLG and ADJUST_ORDER_QTY_MIN_FLG;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 28JUN2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID769191;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID769191",
"New global settings ADJUST_ORDER_QTY_MAX_FLG and ADJUST_ORDER_QTY_MIN_FLG",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID769191:;
 
 
* End of changes for CHANGE_ID:ID769191;
 
 
***********************************************************************************************;
*************************************  End Change ID769191 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID742102 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID742102;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID742102")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(&m_didm_stg..)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_didm_stg..;
%put NOTE- Change ID                             :ID742102;
%goto ID742102;
 
%end;
%if not (%sysfunc(exist(&m_didm_stg..stg_comp_price))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_didm_stg..stg_comp_price;
%put NOTE- Change ID                             :ID742102;
%goto ID742102;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID742102;
%goto ID742102;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID742102;
* Insert record into change management table for CHANGE_ID: ID742102;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID742102",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID742102;
 
%end;
 
 
 
 
 
%di_util_drop_constraint(m_lib=&m_didm_stg., m_table=STG_COMP_PRICE, m_column=%str(SHOP_DT), m_constraint=%str(not null));
 
proc sql;
update &m_didm_stg..STG_COMP_PRICE set SHOP_DT = START_DT
where SHOP_DT is Null;
 
alter table &m_didm_stg..STG_COMP_PRICE add NOT NULL (SHOP_DT);
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID742102;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID742102;
%put ERROR- Description                              : Adding Not Null constraint to SHOP_DT column in STG_COMP_PRICE table.;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 29JUN2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID742102;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID742102",
"Adding Not Null constraint to SHOP_DT column in STG_COMP_PRICE table.",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID742102:;
 
 
* End of changes for CHANGE_ID:ID742102;
 
 
***********************************************************************************************;
*************************************  End Change ID742102 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID769779 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID769779;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID769779")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(&m_di_data.)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_di_data.;
%put NOTE- Change ID                             :ID769779;
%goto ID769779;
 
%end;
%if not (%sysfunc(libref(&m_didm_stg.)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_didm_stg.;
%put NOTE- Change ID                             :ID769779;
%goto ID769779;
 
%end;
%if not (%sysfunc(libref(&m_di_mon.)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_di_mon.;
%put NOTE- Change ID                             :ID769779;
%goto ID769779;
 
%end;
%if not (%sysfunc(exist(&m_di_data..Demand_disagg_factor))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_data..Demand_disagg_factor;
%put NOTE- Change ID                             :ID769779;
%goto ID769779;
 
%end;
%if not (%sysfunc(exist(&m_didm_stg..stg_Demand_disagg_factor))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_didm_stg..stg_Demand_disagg_factor;
%put NOTE- Change ID                             :ID769779;
%goto ID769779;
 
%end;
%if not (%sysfunc(exist(&m_di_mon..Stg_demand_disagg_x))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_mon..Stg_demand_disagg_x;
%put NOTE- Change ID                             :ID769779;
%goto ID769779;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID769779;
%goto ID769779;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID769779;
* Insert record into change management table for CHANGE_ID: ID769779;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID769779",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID769779;
 
%end;
 
 
 
 
 
%macro find_start_dt;
%global apln_dt app_dt;
%let apln_dt = 0;
%let app_dt = 0;
 
/* Select APP_DATE from GLOBAL_SETTING table */
proc sql noprint;
select SPEC_VALUE into : apln_dt
from &m_di_data..global_setting
where upcase(SPEC_NM) = "APP_DATE";
quit;
 
%if &apln_dt = %str() %then %do;
%let app_dt = %sysfunc(today());
%end;
%else %do;
data _null_;
app_date = input(symget('apln_dt'), mmddyy10.);
call symputx('app_dt', app_date);
run;
%end;
%mend find_start_dt;
 
%find_start_dt;
 
%macro di_etl_add_start_dt;
data Demand_disagg_factor_old;
set &m_di_data..Demand_disagg_factor;
attrib START_DT length = 8 FORMAT = &m_DTFMT INFORMAT = &m_DTFMT;
run;
 
data Demand_disagg_factor_old;
set Demand_disagg_factor_old;
if START_DT eq . then do;
START_DT =  "&App_dt";
end;
run;
 
data &m_di_data..Demand_disagg_factor;
attrib GEO_HIER_SK      length=4 ;
attrib PROD_HIER_SK     length=6 ;
attrib START_DT         length=8      FORMAT=&m_DTFMT      INFORMAT = &m_DTFMT;
attrib DISAGG_FACTOR    length=8      FORMAT=NLNUM12.4   INFORMAT=NLNUM12.4;
stop;
run;
 
proc sql;
alter table &m_di_data..DEMAND_DISAGG_FACTOR add CONSTRAINT PRIM_KEY PRIMARY KEY (GEO_HIER_SK, PROD_HIER_SK, START_DT);
quit;
 
proc append base=&m_di_data..DEMAND_DISAGG_FACTOR
data=Demand_disagg_factor_old force;
quit;
 
proc sql;
drop table Demand_disagg_factor_old;
quit;
 
/* Add START_DT in stg: stg_Demand_disagg_factor */
 
proc sql;
alter table &m_didm_stg..stg_Demand_disagg_factor
add START_DT num 8 FORMAT= &m_DTFMT INFORMAT = &m_STG_DTINFMT.;
quit;
 
/* Add START_DT in mon: Stg_demand_disagg_x */
data STG_DEMAND_DISAGG_X_old;
set &m_di_mon..STG_DEMAND_DISAGG_X;
attrib START_DT length = 8 format= &m_DTFMT INFORMAT = &m_DTFMT;
run;
 
Data &m_di_mon..STG_DEMAND_DISAGG_X;
attrib PROD_ID length = $32 ;
attrib GEO_ID length = $32 ;
attrib START_DT length = 8 format= &m_DTFMT INFORMAT = &m_DTFMT;
attrib DISAGG_FACTOR length = 8 format=NLNUM12.2 informat=NLNUM12.2 ;
attrib ETLS_EXCEPTION_COND length = $125 ;
attrib ETL_ERROR_JOBRUNTIME length = 8 format = DATETIME16. ;
stop;
run;
 
/*
proc sql;
alter table &m_di_mon..Stg_demand_disagg_x
add START_DT num 8 FORMAT= &m_DTFMT INFORMAT = &m_DTFMT;
quit;
*/
 
proc append base=&m_di_mon..STG_DEMAND_DISAGG_X
data=STG_DEMAND_DISAGG_X_old force;
quit;
 
proc sql;
drop table STG_DEMAND_DISAGG_X_old;
quit;
 
%mend di_etl_add_start_dt;
 
%di_etl_add_start_dt;
 
 
 
* Check for errors while processing CHANGE_ID: ID769779;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID769779;
%put ERROR- Description                              : NF:New column START_DT introduced in DEMAND_DISAGG_FACTOR.;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 30JUN2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID769779;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID769779",
"NF:New column START_DT introduced in DEMAND_DISAGG_FACTOR.",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID769779:;
 
 
* End of changes for CHANGE_ID:ID769779;
 
 
***********************************************************************************************;
*************************************  End Change ID769779 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID766720_1 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID766720_1;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID766720_1")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(&m_di_data.)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_di_data.;
%put NOTE- Change ID                             :ID766720_1;
%goto ID766720_1;
 
%end;
%if not (%sysfunc(libref(&m_didm_stg.)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_didm_stg.;
%put NOTE- Change ID                             :ID766720_1;
%goto ID766720_1;
 
%end;
%if not (%sysfunc(libref(&m_di_mon.)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_di_mon.;
%put NOTE- Change ID                             :ID766720_1;
%goto ID766720_1;
 
%end;
%if not (%sysfunc(exist(&m_di_data..HALO_PRODUCTS))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_data..HALO_PRODUCTS;
%put NOTE- Change ID                             :ID766720_1;
%goto ID766720_1;
 
%end;
%if not (%sysfunc(exist(&m_didm_stg..STG_HALO_PRODUCTS))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_didm_stg..STG_HALO_PRODUCTS;
%put NOTE- Change ID                             :ID766720_1;
%goto ID766720_1;
 
%end;
%if not (%sysfunc(exist(&m_di_mon..stg_halo_products_x))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_mon..stg_halo_products_x;
%put NOTE- Change ID                             :ID766720_1;
%goto ID766720_1;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID766720_1;
%goto ID766720_1;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID766720_1;
* Insert record into change management table for CHANGE_ID: ID766720_1;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID766720_1",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID766720_1;
 
%end;
 
 
 
 
 
 
proc sql;
drop table &m_didm_stg..STG_HALO_PRODUCTS;
quit;
 
proc sql;
drop table &m_di_mon..stg_halo_products_x;
quit;
 
proc sql;
delete from &m_di_mon..job_param
where upcase(trim(left(jobname))) = "LOAD_STG2DM_HALO_PRODUCTS";
quit;
 
proc sql;
delete from &m_di_mon..etl_sys_param
where upcase(trim(left(jobname))) = "LOAD_STG2DM_HALO_PRODUCTS";
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID766720_1;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID766720_1;
%put ERROR- Description                              : Dropping tables and settings related to LOAD_STG2DM_HALO_PRODUCTS.;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 05JUL2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID766720_1;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID766720_1",
"Dropping tables and settings related to LOAD_STG2DM_HALO_PRODUCTS.",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID766720_1:;
 
 
* End of changes for CHANGE_ID:ID766720_1;
 
 
***********************************************************************************************;
*************************************  End Change ID766720_1 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID738983_2 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID738983_2;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID738983_2")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(&m_didm_stg.)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_didm_stg.;
%put NOTE- Change ID                             :ID738983_2;
%goto ID738983_2;
 
%end;
%if not (%sysfunc(exist(&m_didm_stg..STG_PRODUCT_PARENT))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_didm_stg..STG_PRODUCT_PARENT;
%put NOTE- Change ID                             :ID738983_2;
%goto ID738983_2;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID738983_2;
%goto ID738983_2;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID738983_2;
* Insert record into change management table for CHANGE_ID: ID738983_2;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID738983_2",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID738983_2;
 
%end;
 
 
 
 
 
 
 
proc sql;
ALTER TABLE &m_didm_stg..STG_PRODUCT_PARENT
DROP MIN_INV_LVL;
quit;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID738983_2;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID738983_2;
%put ERROR- Description                              : Move min_inv_lvl from PRODUCT_DM to GEO_PROD;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 05July2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID738983_2;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID738983_2",
"Move min_inv_lvl from PRODUCT_DM to GEO_PROD",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID738983_2:;
 
 
* End of changes for CHANGE_ID:ID738983_2;
 
 
***********************************************************************************************;
*************************************  End Change ID738983_2 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID769767_1 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID769767_1;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID769767_1")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(&m_didm_stg.)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_didm_stg.;
%put NOTE- Change ID                             :ID769767_1;
%goto ID769767_1;
 
%end;
%if not (%sysfunc(exist(&m_didm_stg..stg_target_metrics))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_didm_stg..stg_target_metrics;
%put NOTE- Change ID                             :ID769767_1;
%goto ID769767_1;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID769767_1;
%goto ID769767_1;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52,M2MI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID769767_1;
* Insert record into change management table for CHANGE_ID: ID769767_1;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID769767_1",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID769767_1;
 
%end;
 
 
 
 
 
 
proc sql;
alter table &m_didm_stg..STG_TARGET_METRICS add NOT NULL (TARGET_METRICS_TYPE);
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID769767_1;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID769767_1;
%put ERROR- Description                              : Add TARGET_METRICS_KPI to DIDM_STG.STG_TARGET_METRICS;
%put ERROR- Version                                  : D3MICM52,M2MI42;
%put ERROR- Date of Change                           : 5JUL2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID769767_1;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID769767_1",
"Add TARGET_METRICS_KPI to DIDM_STG.STG_TARGET_METRICS",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID769767_1:;
 
 
* End of changes for CHANGE_ID:ID769767_1;
 
 
***********************************************************************************************;
*************************************  End Change ID769767_1 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID769780 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID769780;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID769780")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(&m_didm_stg.)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_didm_stg.;
%put NOTE- Change ID                             :ID769780;
%goto ID769780;
 
%end;
%if not (%sysfunc(libref(&m_di_mon.)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_di_mon.;
%put NOTE- Change ID                             :ID769780;
%goto ID769780;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID769780;
%goto ID769780;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID769780;
* Insert record into change management table for CHANGE_ID: ID769780;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID769780",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID769780;
 
%end;
 
 
 
 
 
 
 
data &m_didm_stg..STG_PRICE_POINT_CORRECTION;
attrib PROD_ID                             length=$32                                          ;
attrib PRICE_POINT_LOWER                   length=8      FORMAT=NLNUM20.3   INFORMAT=NLNUM20.3 ;
attrib PRICE_POINT_UPPER                   length=8      FORMAT=NLNUM20.3   INFORMAT=NLNUM20.3 ;
attrib PRICE_INCREMENT                     length=8      FORMAT=NLNUM20.3   INFORMAT=NLNUM20.3 ;
attrib ADJUST_PRICE_RANGE                  length=8      FORMAT=NLNUM20.3   INFORMAT=NLNUM20.3 ;
stop; run;
 
proc sql;
alter table &m_didm_stg..STG_PRICE_POINT_CORRECTION add NOT NULL (PROD_ID);
alter table &m_didm_stg..STG_PRICE_POINT_CORRECTION add NOT NULL (PRICE_POINT_LOWER);
alter table &m_didm_stg..STG_PRICE_POINT_CORRECTION add NOT NULL (PRICE_POINT_UPPER);
alter table &m_didm_stg..STG_PRICE_POINT_CORRECTION add NOT NULL (PRICE_INCREMENT);
alter table &m_didm_stg..STG_PRICE_POINT_CORRECTION add NOT NULL (ADJUST_PRICE_RANGE);
quit;
 
 
 
data &m_di_mon..STG_PRICE_POINT_CORRECTION_X;
attrib PROD_ID                             length=$32                                          ;
attrib PROD_HIER_SK                        length=6                                            ;
attrib PRICE_POINT_LOWER                   length=8      FORMAT=NLNUM20.3   INFORMAT=NLNUM20.3 ;
attrib PRICE_POINT_UPPER                   length=8      FORMAT=NLNUM20.3   INFORMAT=NLNUM20.3 ;
attrib PRICE_INCREMENT                     length=8      FORMAT=NLNUM20.3   INFORMAT=NLNUM20.3 ;
attrib ADJUST_PRICE_RANGE                  length=8      FORMAT=NLNUM20.3   INFORMAT=NLNUM20.3 ;
attrib ETLS_EXCEPTION_COND length=$250 ;
attrib ETL_ERROR_JOBRUNTIME length=8 format=&DTTMFMT ;
stop; run;
 
 
 
* Check for errors while processing CHANGE_ID: ID769780;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID769780;
%put ERROR- Description                              : Table definitions for Price_point_correction;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 6JUL2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID769780;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID769780",
"Table definitions for Price_point_correction",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID769780:;
 
 
* End of changes for CHANGE_ID:ID769780;
 
 
***********************************************************************************************;
*************************************  End Change ID769780 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID740928 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID740928;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID740928")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(&m_didm_stg.)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_didm_stg.;
%put NOTE- Change ID                             :ID740928;
%goto ID740928;
 
%end;
%if not (%sysfunc(exist(&m_didm_stg..stg_comp_price))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_didm_stg..stg_comp_price;
%put NOTE- Change ID                             :ID740928;
%goto ID740928;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID740928;
%goto ID740928;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID740928;
* Insert record into change management table for CHANGE_ID: ID740928;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID740928",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID740928;
 
%end;
 
 
 
 
 
 
proc sql;
alter table &m_didm_stg..STG_COMP_PRICE add NOT NULL (PRICE);
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID740928;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID740928;
%put ERROR- Description                              : PRICE column in STG_COMP_PRICE should be NOT NULL;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 06JUL2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID740928;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID740928",
"PRICE column in STG_COMP_PRICE should be NOT NULL",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID740928:;
 
 
* End of changes for CHANGE_ID:ID740928;
 
 
***********************************************************************************************;
*************************************  End Change ID740928 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID767063 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID767063;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID767063")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID767063;
%goto ID767063;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID767063;
* Insert record into change management table for CHANGE_ID: ID767063;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID767063",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID767063;
 
%end;
 
 
 
 
 
 
proc sql;
delete from &m_di_data..job where job_id in (13,26,34,35,36,37);
insert into &m_di_data..job(job_id,job_nm,parent_job_id) values (13,'rpo_alert',-1);
insert into &m_di_data..job(job_id,job_nm,parent_job_id) values (26,'rpp_alert',-1);
insert into &m_di_data..job(job_id,job_nm,parent_job_id) values (34,'rpo_price_export',-1);
insert into &m_di_data..job(job_id,job_nm,parent_job_id) values (35,'rpp_price_export',-1);
insert into &m_di_data..job(job_id,job_nm,parent_job_id) values (36,'rpp_vehicle_export',-1);
insert into &m_di_data..job(job_id,job_nm,parent_job_id) values (37,'export_rdm',-1);
quit;
 
proc sort data=&m_di_data..job force;
by job_id;
run;
 
 
 
* Check for errors while processing CHANGE_ID: ID767063;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID767063;
%put ERROR- Description                              : Add new jobs to tkmi_job_ro for RPO and RPP apps;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 6JUL2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID767063;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID767063",
"Add new jobs to tkmi_job_ro for RPO and RPP apps",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID767063:;
 
 
* End of changes for CHANGE_ID:ID767063;
 
 
***********************************************************************************************;
*************************************  End Change ID767063 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID773648 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID773648;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID773648")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID773648;
%goto ID773648;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID773648;
* Insert record into change management table for CHANGE_ID: ID773648;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID773648",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID773648;
 
%end;
 
 
 
 
 
 
proc sql;
 
DELETE FROM &m_di_data..GLOBAL_SETTING
WHERE SPEC_NM ='REC_PACKS_CONTAIN_ALL_SKUS' and APP = 'SZPK';
 
INSERT INTO &m_di_data..GLOBAL_SETTING (SPEC_NM,APP,SPEC_VALUE,SPEC_DESC) VALUES
('REC_PACKS_CONTAIN_ALL_SKUS','SZPK','0',
'Specifies whether recommended packs must include all SKUs in a size set.');
 
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID773648;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID773648;
%put ERROR- Description                              : New global setting REC_PACKS_CONTAIN_ALL_SKUS;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 12JUL2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID773648;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID773648",
"New global setting REC_PACKS_CONTAIN_ALL_SKUS",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID773648:;
 
 
* End of changes for CHANGE_ID:ID773648;
 
 
***********************************************************************************************;
*************************************  End Change ID773648 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change DROP_MODEL_DATA ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: DROP_MODEL_DATA;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("DROP_MODEL_DATA")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_data..model_data))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_data..model_data;
%put NOTE- Change ID                             :DROP_MODEL_DATA;
%goto DROP_MODEL_DATA;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : DROP_MODEL_DATA;
%goto DROP_MODEL_DATA;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : DROP_MODEL_DATA;
* Insert record into change management table for CHANGE_ID: DROP_MODEL_DATA;
proc sql;
insert  into di_data.data_model_change_management
values (
"DROP_MODEL_DATA",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto DROP_MODEL_DATA;
 
%end;
 
 
 
 
 
 
proc sql noprint ;
drop table &m_di_data..model_data;
quit;
 
 
 
* Check for errors while processing CHANGE_ID: DROP_MODEL_DATA;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: DROP_MODEL_DATA;
%put ERROR- Description                              : Drop table MODEL_DATA if it exists;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 02MAY2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: DROP_MODEL_DATA;
proc sql;
insert  into di_data.data_model_change_management
values (
"DROP_MODEL_DATA",
"Drop table MODEL_DATA if it exists",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%DROP_MODEL_DATA:;
 
 
* End of changes for CHANGE_ID:DROP_MODEL_DATA;
 
 
***********************************************************************************************;
*************************************  End Change DROP_MODEL_DATA ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ADD_COL_COPIED_FLG ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ADD_COL_COPIED_FLG;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ADD_COL_COPIED_FLG")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ADD_COL_COPIED_FLG;
%goto ADD_COL_COPIED_FLG;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ADD_COL_COPIED_FLG;
* Insert record into change management table for CHANGE_ID: ADD_COL_COPIED_FLG;
proc sql;
insert  into di_data.data_model_change_management
values (
"ADD_COL_COPIED_FLG",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ADD_COL_COPIED_FLG;
 
%end;
 
 
 
 
 
 
proc sql noprint;
alter table &m_di_data..SIZESET add COPIED_FLG NUM 4;
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ADD_COL_COPIED_FLG;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ADD_COL_COPIED_FLG;
%put ERROR- Description                              : SIZE PROFILING 3.2 SCHEMA CHANGES PART IV;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 13JUL2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ADD_COL_COPIED_FLG;
proc sql;
insert  into di_data.data_model_change_management
values (
"ADD_COL_COPIED_FLG",
"SIZE PROFILING 3.2 SCHEMA CHANGES PART IV",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ADD_COL_COPIED_FLG:;
 
 
* End of changes for CHANGE_ID:ADD_COL_COPIED_FLG;
 
 
***********************************************************************************************;
*************************************  End Change ADD_COL_COPIED_FLG ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change CREATE_DECOMP_TABLES_2 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: CREATE_DECOMP_TABLES_2;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("CREATE_DECOMP_TABLES_2")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : CREATE_DECOMP_TABLES_2;
%goto CREATE_DECOMP_TABLES_2;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : CREATE_DECOMP_TABLES_2;
* Insert record into change management table for CHANGE_ID: CREATE_DECOMP_TABLES_2;
proc sql;
insert  into di_data.data_model_change_management
values (
"CREATE_DECOMP_TABLES_2",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto CREATE_DECOMP_TABLES_2;
 
%end;
 
 
 
 
 
 
data &m_di_data..REPORT_DECOMP;
attrib GEO_HIER_SK                         length=4                                            ;
attrib PROD_HIER_SK                        length=6                                            ;
attrib DATE_SK                             length=4                                            ;
attrib SALES_PREV_PRICE                    length=8      FORMAT=NLNUM20.3   INFORMAT=NLNUM20.3 ;
attrib ACTUAL_SALES                        length=8      FORMAT=NLNUM12.2   INFORMAT=NLNUM12.2 ;
attrib BASE_UNITS                          length=8      FORMAT=NLNUM12.2   INFORMAT=NLNUM12.2 ;
attrib PREV_PRICE_BASE_UNITS               length=8      FORMAT=NLNUM12.2   INFORMAT=NLNUM12.2 ;
attrib OTHER_UNITS                         length=8      FORMAT=NLNUM12.2   INFORMAT=NLNUM12.2 ;
attrib PRICE_UNITS                         length=8      FORMAT=NLNUM12.2   INFORMAT=NLNUM12.2 ;
attrib INV_UNITS                           length=8      FORMAT=NLNUM12.2   INFORMAT=NLNUM12.2 ;
stop; run;
 
proc sql;
CREATE INDEX PROD_HIER_SK ON &m_di_data..REPORT_DECOMP(PROD_HIER_SK);
quit;
 
 
data &m_di_data..REPORT_DECOMP_PS;
attrib GEO_HIER_SK                         length=4                                            ;
attrib PROD_HIER_SK                        length=6                                            ;
attrib DATE_SK                             length=4                                            ;
attrib PS_NUM                              length=8      FORMAT=NLNUM12.2   INFORMAT=NLNUM12.2 ;
attrib PS_UNITS                            length=8      FORMAT=NLNUM12.2   INFORMAT=NLNUM12.2 ;
stop; run;
 
proc sql;
CREATE INDEX PROD_HIER_SK ON &m_di_data..REPORT_DECOMP_PS(PROD_HIER_SK);
quit;
 
 
 
 
 
* Check for errors while processing CHANGE_ID: CREATE_DECOMP_TABLES_2;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: CREATE_DECOMP_TABLES_2;
%put ERROR- Description                              : Create tables for benefit tracking report;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 13SEP2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: CREATE_DECOMP_TABLES_2;
proc sql;
insert  into di_data.data_model_change_management
values (
"CREATE_DECOMP_TABLES_2",
"Create tables for benefit tracking report",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%CREATE_DECOMP_TABLES_2:;
 
 
* End of changes for CHANGE_ID:CREATE_DECOMP_TABLES_2;
 
 
***********************************************************************************************;
*************************************  End Change CREATE_DECOMP_TABLES_2 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID771864 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID771864;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID771864")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(&m_di_mon)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_di_mon;
%put NOTE- Change ID                             :ID771864;
%goto ID771864;
 
%end;
%if not (%sysfunc(libref(&m_didm_stg)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_didm_stg;
%put NOTE- Change ID                             :ID771864;
%goto ID771864;
 
%end;
%if not (%sysfunc(exist(&m_di_mon..job_param))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_mon..job_param;
%put NOTE- Change ID                             :ID771864;
%goto ID771864;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID771864;
%goto ID771864;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52,M2MI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID771864;
* Insert record into change management table for CHANGE_ID: ID771864;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID771864",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID771864;
 
%end;
 
 
 
 
 
 
data &m_didm_stg..STG_RPP_PLAN_COST;
attrib PROD_ID        length=$32                                         ;
attrib GEO_ID         length=$32                                         ;
attrib PLAN_ID        length=$32                                         ;
attrib COST_TYPE      length=8                                           ;
attrib COST           length=8     FORMAT=NLNUM12.2   INFORMAT=NLNUM12.2 ;
stop; run;
 
proc sql;
alter table &m_didm_stg..STG_RPP_PLAN_COST add NOT NULL (PROD_ID);
alter table &m_didm_stg..STG_RPP_PLAN_COST add NOT NULL (GEO_ID);
alter table &m_didm_stg..STG_RPP_PLAN_COST add NOT NULL (PLAN_ID);
alter table &m_didm_stg..STG_RPP_PLAN_COST add NOT NULL (COST_TYPE);
alter table &m_didm_stg..STG_RPP_PLAN_COST add NOT NULL (COST);
quit;
 
 
data &m_di_mon..STG_RPP_PLAN_COST_X;
attrib PROD_ID        length=$32                                         ;
attrib GEO_ID         length=$32                                         ;
attrib PLAN_ID        length=$32                                         ;
attrib COST_TYPE      length=8                                           ;
attrib COST           length=8     FORMAT=NLNUM12.2   INFORMAT=NLNUM12.2 ;
attrib ETLS_EXCEPTION_COND length=$250 ;
attrib ETL_ERROR_JOBRUNTIME length=8 format=DATETIME16. ;
stop; run;
 
/*Update DI_MON.JOB_PARAM table*/
 
proc sql;
delete from &m_di_mon..job_param
where  upcase(trim(left(jobname))) = 'LOAD_STG2DM_RPP_PLAN_COST_FACT'
and  lowcase(trim(left(param_name))) = 'full_refresh';
 
insert into &m_di_mon..job_param values
('LOAD_STG2DM_RPP_PLAN_COST_FACT','Full_refresh','','"0"');
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID771864;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID771864;
%put ERROR- Description                              : Create stage and mon tables for RPP_PLAN_COST_FACT;
%put ERROR- Version                                  : D3MICM52,M2MI42;
%put ERROR- Date of Change                           : 19JUL2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID771864;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID771864",
"Create stage and mon tables for RPP_PLAN_COST_FACT",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID771864:;
 
 
* End of changes for CHANGE_ID:ID771864;
 
 
***********************************************************************************************;
*************************************  End Change ID771864 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID761590_3 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID761590_3;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID761590_3")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_data..field_lookup_values))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_data..field_lookup_values;
%put NOTE- Change ID                             :ID761590_3;
%goto ID761590_3;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID761590_3;
%goto ID761590_3;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52,M2MI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID761590_3;
* Insert record into change management table for CHANGE_ID: ID761590_3;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID761590_3",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID761590_3;
 
%end;
 
 
 
 
 
proc sql;
insert into &m_di_data..FIELD_LOOKUP_VALUES (TABLE_NAME,     FIELD_NM,     FIELD_VALUE, FIELD_VALUE_NM, FIELD_VALUE_DESC, FIELD_DATATYPE)
values ("RPP_PLAN_COST_FACT", "COST_TYPE", "1",           "Invoice", "", "INTEGER");
insert into &m_di_data..FIELD_LOOKUP_VALUES (TABLE_NAME,     FIELD_NM,     FIELD_VALUE, FIELD_VALUE_NM, FIELD_VALUE_DESC, FIELD_DATATYPE)
values ("RPP_PLAN_COST_FACT", "COST_TYPE", "2",           "Landed", "", "INTEGER");
insert into &m_di_data..FIELD_LOOKUP_VALUES (TABLE_NAME,     FIELD_NM,     FIELD_VALUE, FIELD_VALUE_NM, FIELD_VALUE_DESC, FIELD_DATATYPE)
values ("RPP_PLAN_COST_FACT", "COST_TYPE", "3",           "Off-Invoice1", "", "INTEGER");
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID761590_3;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID761590_3;
%put ERROR- Description                              : Add Cost type to be used with RPP_PLAN_COST_FACT;
%put ERROR- Version                                  : D3MICM52,M2MI42;
%put ERROR- Date of Change                           : 19JUL2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID761590_3;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID761590_3",
"Add Cost type to be used with RPP_PLAN_COST_FACT",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID761590_3:;
 
 
* End of changes for CHANGE_ID:ID761590_3;
 
 
***********************************************************************************************;
*************************************  End Change ID761590_3 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID771864_2 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID771864_2;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID771864_2")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(&m_di_mon)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_di_mon;
%put NOTE- Change ID                             :ID771864_2;
%goto ID771864_2;
 
%end;
%if not (%sysfunc(exist(&m_di_mon..etl_sys_param))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_mon..etl_sys_param;
%put NOTE- Change ID                             :ID771864_2;
%goto ID771864_2;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID771864_2;
%goto ID771864_2;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52,M2MI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID771864_2;
* Insert record into change management table for CHANGE_ID: ID771864_2;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID771864_2",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID771864_2;
 
%end;
 
 
 
 
 
proc sql;
delete from &m_di_mon..etl_sys_param
where upcase(jobname) = 'LOAD_STG2DM_RPP_PLAN_COST_FACT'
and lowcase(param_name) = 'etlp_exception_table';
 
insert into &m_di_mon..etl_sys_param values
('LOAD_STG2DM_RPP_PLAN_COST_FACT','etlp_exception_table','DI_MON.STG_RPP_PLAN_COST_X','"DI_MON.STG_RPP_PLAN_COST_X"');
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID771864_2;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID771864_2;
%put ERROR- Description                              : exception table entry in ETL_SYS_PARAM for RPP_PLAN_COST_FACT;
%put ERROR- Version                                  : D3MICM52,M2MI42;
%put ERROR- Date of Change                           : 21JUL2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID771864_2;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID771864_2",
"exception table entry in ETL_SYS_PARAM for RPP_PLAN_COST_FACT",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID771864_2:;
 
 
* End of changes for CHANGE_ID:ID771864_2;
 
 
***********************************************************************************************;
*************************************  End Change ID771864_2 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID769780_2 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID769780_2;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID769780_2")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(&m_di_mon)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_di_mon;
%put NOTE- Change ID                             :ID769780_2;
%goto ID769780_2;
 
%end;
%if not (%sysfunc(exist(&m_di_mon..etl_sys_param))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_mon..etl_sys_param;
%put NOTE- Change ID                             :ID769780_2;
%goto ID769780_2;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID769780_2;
%goto ID769780_2;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID769780_2;
* Insert record into change management table for CHANGE_ID: ID769780_2;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID769780_2",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID769780_2;
 
%end;
 
 
 
 
 
proc sql;
delete from &m_di_mon..etl_sys_param
where upcase(jobname) = 'LOAD_STG2DM_PRICE_POINT_CORRECTION'
and lowcase(param_name) = 'etlp_exception_table';
 
insert into &m_di_mon..etl_sys_param values
('LOAD_STG2DM_PRICE_POINT_CORRECTION','etlp_exception_table','DI_MON.STG_PRICE_POINT_CORRECTION_X','"DI_MON.STG_PRICE_POINT_CORRECTION_X"');
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID769780_2;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID769780_2;
%put ERROR- Description                              : exception table entry in ETL_SYS_PARAM for Price_point_correction;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 21JUL2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID769780_2;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID769780_2",
"exception table entry in ETL_SYS_PARAM for Price_point_correction",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID769780_2:;
 
 
* End of changes for CHANGE_ID:ID769780_2;
 
 
***********************************************************************************************;
*************************************  End Change ID769780_2 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID773092 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID773092;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID773092")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(&m_di_mon)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_di_mon;
%put NOTE- Change ID                             :ID773092;
%goto ID773092;
 
%end;
%if not (%sysfunc(exist(&m_di_mon..job_param))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_mon..job_param;
%put NOTE- Change ID                             :ID773092;
%goto ID773092;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID773092;
%goto ID773092;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID773092;
* Insert record into change management table for CHANGE_ID: ID773092;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID773092",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID773092;
 
%end;
 
 
 
 
 
data temp_job_param;
attrib jobname length=$80 param_name length=$32 param_value length=$160 default_func length=$160 ;
jobname='LOAD_STG2DM_RPP_PLAN'; param_name='etlp_find_scope_exception'; param_value='';default_func ='"0"';output;
jobname='LOAD_STG2DM_RPP_PLAN_PROD_ASGMNT'; param_name='etlp_find_scope_exception'; param_value='';default_func ='"0"';output;
run;
 
data &m_di_mon..job_param;
set temp_job_param(rename=(param_value=etls_0 default_func=etls_1));
 
modify &m_di_mon..job_param key=PRIM_KEY;
param_value=etls_0 ;
default_func=etls_1;
 
if _iorc_ = 0 then do;
/* do nothing */
end;
else do;
output;
end;
 
_iorc_ = 0; _error_ = 0;
run;
 
 
 
* Check for errors while processing CHANGE_ID: ID773092;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID773092;
%put ERROR- Description                              : Add job parameters to check scope/objective scope and plan products;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 21JUL2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID773092;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID773092",
"Add job parameters to check scope/objective scope and plan products",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID773092:;
 
 
* End of changes for CHANGE_ID:ID773092;
 
 
***********************************************************************************************;
*************************************  End Change ID773092 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID777793 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID777793;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID777793")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID777793;
%goto ID777793;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID777793;
* Insert record into change management table for CHANGE_ID: ID777793;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID777793",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID777793;
 
%end;
 
 
 
 
 
 
proc sql;
 
DELETE FROM &m_di_data..GLOBAL_SETTING
WHERE SPEC_NM ='ALLOW_RPO_PRICE_DURING_PROMO' and APP = 'RPO';
 
INSERT INTO &m_di_data..GLOBAL_SETTING (SPEC_NM,APP,SPEC_VALUE,SPEC_DESC) VALUES
('ALLOW_RPO_PRICE_DURING_PROMO','RPO','1',
'Specifies whether to allow a new regular price to take effect during a promotion.');
 
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID777793;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID777793;
%put ERROR- Description                              : New global setting ALLOW_RPO_PRICE_DURING_PROMO;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 25JUL2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID777793;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID777793",
"New global setting ALLOW_RPO_PRICE_DURING_PROMO",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID777793:;
 
 
* End of changes for CHANGE_ID:ID777793;
 
 
***********************************************************************************************;
*************************************  End Change ID777793 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID679163 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID679163;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID679163")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(&m_didm_stg)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_didm_stg;
%put NOTE- Change ID                             :ID679163;
%goto ID679163;
 
%end;
%if not (%sysfunc(exist(&m_didm_stg..stg_mdo_import_plan))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_didm_stg..stg_mdo_import_plan;
%put NOTE- Change ID                             :ID679163;
%goto ID679163;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID679163;
%goto ID679163;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID679163;
* Insert record into change management table for CHANGE_ID: ID679163;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID679163",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID679163;
 
%end;
 
 
 
 
 
 
 
proc sql noprint;
alter table  &m_didm_stg..stg_mdo_import_plan
drop auto_eval_opt_flg;
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID679163;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID679163;
%put ERROR- Description                              : Delete AUTO_EVAL_OPT_FLG column from DIDM_STG.STG_MDO_IMPORT_PLAN;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 26JUL2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID679163;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID679163",
"Delete AUTO_EVAL_OPT_FLG column from DIDM_STG.STG_MDO_IMPORT_PLAN",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID679163:;
 
 
* End of changes for CHANGE_ID:ID679163;
 
 
***********************************************************************************************;
*************************************  End Change ID679163 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID679163_2 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID679163_2;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID679163_2")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(&m_di_mon)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_di_mon;
%put NOTE- Change ID                             :ID679163_2;
%goto ID679163_2;
 
%end;
%if not (%sysfunc(exist(&m_di_mon..stg_mdo_import_plan_x))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_mon..stg_mdo_import_plan_x;
%put NOTE- Change ID                             :ID679163_2;
%goto ID679163_2;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID679163_2;
%goto ID679163_2;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52, M1TKMI43, D2TKMI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID679163_2;
* Insert record into change management table for CHANGE_ID: ID679163_2;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID679163_2",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID679163_2;
 
%end;
 
 
 
 
 
 
 
proc sql noprint;
alter table  &m_di_mon..stg_mdo_import_plan_x
drop auto_eval_opt_flg;
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID679163_2;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID679163_2;
%put ERROR- Description                              : Delete AUTO_EVAL_OPT_FLG column from DI_MON.STG_MDO_IMPORT_PLAN_X;
%put ERROR- Version                                  : D3MICM52, M1TKMI43, D2TKMI42;
%put ERROR- Date of Change                           : 26JUL2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID679163_2;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID679163_2",
"Delete AUTO_EVAL_OPT_FLG column from DI_MON.STG_MDO_IMPORT_PLAN_X",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID679163_2:;
 
 
* End of changes for CHANGE_ID:ID679163_2;
 
 
***********************************************************************************************;
*************************************  End Change ID679163_2 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID777227 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID777227;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID777227")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID777227;
%goto ID777227;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID777227;
* Insert record into change management table for CHANGE_ID: ID777227;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID777227",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID777227;
 
%end;
 
 
 
 
 
 
proc sql;
 
DELETE FROM &m_di_data..GLOBAL_SETTING
WHERE SPEC_NM ='MAX_INNER_PACK_SIZE' and APP = 'SZPK';
 
INSERT INTO &m_di_data..GLOBAL_SETTING (SPEC_NM,APP,SPEC_VALUE,SPEC_DESC) VALUES
('MAX_INNER_PACK_SIZE','SZPK','100',
'Specifies the maximum number of units that can be included in an inner pack.');
 
DELETE FROM &m_di_data..GLOBAL_SETTING
WHERE SPEC_NM ='INNER_PACK_LIMIT' and APP = 'SZPK';
 
INSERT INTO &m_di_data..GLOBAL_SETTING (SPEC_NM,APP,SPEC_VALUE,SPEC_DESC) VALUES
('INNER_PACK_LIMIT','SZPK','10',
'Specifies the maximum number of inner packs of a particular size that can be defined in the pack recommendation settings.');
 
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID777227;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID777227;
%put ERROR- Description                              : New global settings MAX_INNER_PACK_SIZE and INNER_PACK_LIMIT;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 27JUL2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID777227;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID777227",
"New global settings MAX_INNER_PACK_SIZE and INNER_PACK_LIMIT",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID777227:;
 
 
* End of changes for CHANGE_ID:ID777227;
 
 
***********************************************************************************************;
*************************************  End Change ID777227 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID779426 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID779426;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID779426")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID779426;
%goto ID779426;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID779426;
* Insert record into change management table for CHANGE_ID: ID779426;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID779426",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID779426;
 
%end;
 
 
 
 
 
 
proc sql;
 
DELETE FROM &m_di_data..GLOBAL_SETTING WHERE SPEC_NM ='BASELINE_OFFSET';
DELETE FROM &m_di_data..GLOBAL_SETTING WHERE SPEC_NM ='USE_REFERENCE_PRICE';
 
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID779426;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID779426;
%put ERROR- Description                              : Remove USE_REFERENCE_PRICE and BASELINE_OFFSET global settings;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 31JUL2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID779426;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID779426",
"Remove USE_REFERENCE_PRICE and BASELINE_OFFSET global settings",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID779426:;
 
 
* End of changes for CHANGE_ID:ID779426;
 
 
***********************************************************************************************;
*************************************  End Change ID779426 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID742165 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID742165;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID742165")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(&m_di_mon)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_di_mon;
%put NOTE- Change ID                             :ID742165;
%goto ID742165;
 
%end;
%if not (%sysfunc(exist(&m_di_mon..job_param))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_mon..job_param;
%put NOTE- Change ID                             :ID742165;
%goto ID742165;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID742165;
%goto ID742165;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID742165;
* Insert record into change management table for CHANGE_ID: ID742165;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID742165",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID742165;
 
%end;
 
 
 
 
 
proc sql;
 
delete from &m_di_mon..job_param
where jobname ='DI_REPLICATE_MULTIPLE_TABLES' and param_name = 'etlp_src_tab9';
 
insert into &m_di_mon..job_param (jobname, param_name, param_value, default_func)
values ("DI_REPLICATE_MULTIPLE_TABLES", "etlp_src_tab9", "attribute", '"Y"' );
 
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID742165;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID742165;
%put ERROR- Description                              : Replicate ATTRIBUTE table from SAS to RDBMS;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 01AUG2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID742165;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID742165",
"Replicate ATTRIBUTE table from SAS to RDBMS",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID742165:;
 
 
* End of changes for CHANGE_ID:ID742165;
 
 
***********************************************************************************************;
*************************************  End Change ID742165 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID775361 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID775361;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID775361")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(&m_di_mon)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_di_mon;
%put NOTE- Change ID                             :ID775361;
%goto ID775361;
 
%end;
%if not (%sysfunc(exist(&m_di_mon..stg_dimension_levels_x))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_mon..stg_dimension_levels_x;
%put NOTE- Change ID                             :ID775361;
%goto ID775361;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID775361;
%goto ID775361;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID775361;
* Insert record into change management table for CHANGE_ID: ID775361;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID775361",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID775361;
 
%end;
 
 
 
 
 
 
proc sql noprint;
alter table  &m_di_mon..stg_dimension_levels_x
modify ETLS_EXCEPTION_COND char(450);
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID775361;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID775361;
%put ERROR- Description                              : Alter the length of ETLS_EXCEPTION_COND in STG_DIMENSION_LEVELS_X table;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 04AUG2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID775361;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID775361",
"Alter the length of ETLS_EXCEPTION_COND in STG_DIMENSION_LEVELS_X table",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID775361:;
 
 
* End of changes for CHANGE_ID:ID775361;
 
 
***********************************************************************************************;
*************************************  End Change ID775361 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID770137 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID770137;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID770137")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(&m_didm_stg)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_didm_stg;
%put NOTE- Change ID                             :ID770137;
%goto ID770137;
 
%end;
%if not (%sysfunc(exist(&m_didm_stg..stg_mdo_import_plan))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_didm_stg..stg_mdo_import_plan;
%put NOTE- Change ID                             :ID770137;
%goto ID770137;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID770137;
%goto ID770137;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID770137;
* Insert record into change management table for CHANGE_ID: ID770137;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID770137",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID770137;
 
%end;
 
 
 
 
 
proc sql;
alter table &m_didm_stg..stg_mdo_import_plan modify PRICE_VALUE_LIST CHAR(1000);
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID770137;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID770137;
%put ERROR- Description                              : Increase PRICE_VALUE_LIST in didm_stg.stg_mdo_import_plan to char(1000);
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 08AUG2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID770137;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID770137",
"Increase PRICE_VALUE_LIST in didm_stg.stg_mdo_import_plan to char(1000)",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID770137:;
 
 
* End of changes for CHANGE_ID:ID770137;
 
 
***********************************************************************************************;
*************************************  End Change ID770137 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID770137_1 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID770137_1;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID770137_1")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(&m_di_mon)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_di_mon;
%put NOTE- Change ID                             :ID770137_1;
%goto ID770137_1;
 
%end;
%if not (%sysfunc(exist(&m_di_mon..stg_mdo_import_plan_x))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_mon..stg_mdo_import_plan_x;
%put NOTE- Change ID                             :ID770137_1;
%goto ID770137_1;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID770137_1;
%goto ID770137_1;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID770137_1;
* Insert record into change management table for CHANGE_ID: ID770137_1;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID770137_1",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID770137_1;
 
%end;
 
 
 
 
 
proc sql;
alter table &m_di_mon..stg_mdo_import_plan_x modify PRICE_VALUE_LIST CHAR(1000);
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID770137_1;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID770137_1;
%put ERROR- Description                              : Increase PRICE_VALUE_LIST in DI_MON.stg_mdo_import_plan_x to char(1000);
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 08AUG2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID770137_1;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID770137_1",
"Increase PRICE_VALUE_LIST in DI_MON.stg_mdo_import_plan_x to char(1000)",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID770137_1:;
 
 
* End of changes for CHANGE_ID:ID770137_1;
 
 
***********************************************************************************************;
*************************************  End Change ID770137_1 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change PARAM_FCST_EXPORT3 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: PARAM_FCST_EXPORT3;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("PARAM_FCST_EXPORT3")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_mon..job_param))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_mon..job_param;
%put NOTE- Change ID                             :PARAM_FCST_EXPORT3;
%goto PARAM_FCST_EXPORT3;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : PARAM_FCST_EXPORT3;
%goto PARAM_FCST_EXPORT3;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : PARAM_FCST_EXPORT3;
* Insert record into change management table for CHANGE_ID: PARAM_FCST_EXPORT3;
proc sql;
insert  into di_data.data_model_change_management
values (
"PARAM_FCST_EXPORT3",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto PARAM_FCST_EXPORT3;
 
%end;
 
 
 
 
 
 
proc sql noprint;
DELETE FROM &m_di_mon..job_param where jobname = 'DI_EXPORT_SALES_FORECAST' and param_name='etlp_geo_id';
DELETE FROM &m_di_mon..job_param where jobname = 'DI_EXPORT_SALES_FORECAST' and param_name='etlp_prod_id';
DELETE FROM &m_di_mon..job_param where jobname = 'DI_EXPORT_SALES_FORECAST' and param_name='etlp_units_fmt';
DELETE FROM &m_di_mon..job_param where jobname = 'DI_EXPORT_SALES_FORECAST' and param_name='etlp_price_fmt';
DELETE FROM &m_di_mon..job_param where jobname = 'DI_EXPORT_SALES_FORECAST' and param_name='etlp_pct_fmt';
DELETE FROM &m_di_mon..job_param where jobname = 'DI_EXPORT_SALES_FORECAST' and param_name='etlp_geo_prod_ids_table';
DELETE FROM &m_di_mon..job_param where jobname = 'DI_EXPORT_SALES_FORECAST' and param_name='etlp_geo_prod_sks_table';
DELETE FROM &m_di_mon..job_param where jobname = 'DI_EXPORT_SALES_FORECAST' and param_name='etlp_model_group_ids_table';
DELETE FROM &m_di_mon..job_param where jobname = 'DI_EXPORT_SALES_FORECAST' and param_name='etlp_daily_model';
DELETE FROM &m_di_mon..job_param where jobname = 'DI_EXPORT_SALES_FORECAST' and param_name='etlp_daily_output';
 
Insert into &m_di_mon..job_param
(jobname, param_name, param_value, default_func)
values("DI_EXPORT_SALES_FORECAST", "etlp_geo_id","",'""')
;
 
Insert into &m_di_mon..job_param
(jobname, param_name, param_value, default_func)
values("DI_EXPORT_SALES_FORECAST", "etlp_prod_id","",'""')
;
 
Insert into &m_di_mon..job_param
(jobname, param_name, param_value, default_func)
values("DI_EXPORT_SALES_FORECAST", "etlp_units_fmt","FORMAT=NLNUM12.0 INFORMAT=NLNUM12.0",'"FORMAT=NLNUM12.0 INFORMAT=NLNUM12.0"')
;
 
Insert into &m_di_mon..job_param
(jobname, param_name, param_value, default_func)
values("DI_EXPORT_SALES_FORECAST", "etlp_price_fmt","FORMAT=NLNUM12.2 INFORMAT=NLNUM12.2",'"FORMAT=NLNUM12.2 INFORMAT=NLNUM12.2"')
;
 
Insert into &m_di_mon..job_param
(jobname, param_name, param_value, default_func)
values("DI_EXPORT_SALES_FORECAST", "etlp_pct_fmt","FORMAT=NLNUM12.4 INFORMAT=NLNUM12.4",'"FORMAT=NLNUM12.4 INFORMAT=NLNUM12.4"')
;
 
Insert into &m_di_mon..job_param
(jobname, param_name, param_value, default_func)
values("DI_EXPORT_SALES_FORECAST", "etlp_geo_prod_ids_table","",'""')
;
 
Insert into &m_di_mon..job_param
(jobname, param_name, param_value, default_func)
values("DI_EXPORT_SALES_FORECAST", "etlp_geo_prod_sks_table","",'""')
;
 
Insert into &m_di_mon..job_param
(jobname, param_name, param_value, default_func)
values("DI_EXPORT_SALES_FORECAST", "etlp_daily_model","1",'"1-daily, 0-weekly"')
;
 
Insert into &m_di_mon..job_param
(jobname, param_name, param_value, default_func)
values("DI_EXPORT_SALES_FORECAST", "etlp_daily_output","0",'"1-daily, 0-weekly"')
;
 
Insert into &m_di_mon..job_param
(jobname, param_name, param_value, default_func)
values("DI_EXPORT_SALES_FORECAST", "etlp_model_group_ids_table","",'""')
;
 
quit;
 
proc sort data=&m_di_mon..job_param;
by jobname param_name;
run;
 
 
 
 
 
* Check for errors while processing CHANGE_ID: PARAM_FCST_EXPORT3;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: PARAM_FCST_EXPORT3;
%put ERROR- Description                              : Add parameter for Forecast Export;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 01JUN2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: PARAM_FCST_EXPORT3;
proc sql;
insert  into di_data.data_model_change_management
values (
"PARAM_FCST_EXPORT3",
"Add parameter for Forecast Export",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%PARAM_FCST_EXPORT3:;
 
 
* End of changes for CHANGE_ID:PARAM_FCST_EXPORT3;
 
 
***********************************************************************************************;
*************************************  End Change PARAM_FCST_EXPORT3 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change PARAM_FCST_EXPORT2 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: PARAM_FCST_EXPORT2;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("PARAM_FCST_EXPORT2")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_mon..job_param))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_mon..job_param;
%put NOTE- Change ID                             :PARAM_FCST_EXPORT2;
%goto PARAM_FCST_EXPORT2;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : PARAM_FCST_EXPORT2;
%goto PARAM_FCST_EXPORT2;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : PARAM_FCST_EXPORT2;
* Insert record into change management table for CHANGE_ID: PARAM_FCST_EXPORT2;
proc sql;
insert  into di_data.data_model_change_management
values (
"PARAM_FCST_EXPORT2",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto PARAM_FCST_EXPORT2;
 
%end;
 
 
 
 
 
proc sql noprint;
 
select count(*) into :m_etlp_model_group_param_cnt
from &m_di_mon..job_param
where jobname="DI_EXPORT_SALES_FORECAST"
AND param_name='etlp_model_group_ids_table'
 
;
 
quit;
 
/* If no parameter exists for etlp_model_group_ids_table */
%if ( &m_etlp_model_group_param_cnt<1) %then
%do;
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: PARAM_FCST_EXPORT2;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: PARAM_FCST_EXPORT2;
%put ERROR- Description                              : Add parameter for Forecast Export;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 04MAY2012;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: PARAM_FCST_EXPORT2;
proc sql;
insert  into di_data.data_model_change_management
values (
"PARAM_FCST_EXPORT2",
"Add parameter for Forecast Export",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%PARAM_FCST_EXPORT2:;
 
 
* End of changes for CHANGE_ID:PARAM_FCST_EXPORT2;
 
 
***********************************************************************************************;
*************************************  End Change PARAM_FCST_EXPORT2 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ADD_GEO_PROD_BENEFITS_04 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ADD_GEO_PROD_BENEFITS_04;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ADD_GEO_PROD_BENEFITS_04")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ADD_GEO_PROD_BENEFITS_04;
%goto ADD_GEO_PROD_BENEFITS_04;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ADD_GEO_PROD_BENEFITS_04;
* Insert record into change management table for CHANGE_ID: ADD_GEO_PROD_BENEFITS_04;
proc sql;
insert  into di_data.data_model_change_management
values (
"ADD_GEO_PROD_BENEFITS_04",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ADD_GEO_PROD_BENEFITS_04;
 
%end;
 
 
 
 
 
 
data &m_di_data..GEO_PROD_BENEFITS;
attrib PROD_HIER_SK                        length=6 ;
attrib GEO_HIER_SK                         length=4 ;
attrib DATE_SK                             length=4 ;
 
attrib PLANNED_NON_CLRNC_ACT_UNITS         length=8      FORMAT=NLNUM12.2  INFORMAT=NLNUM12.2 ;
attrib NON_PLANNED_ACT_UNITS               length=8      FORMAT=NLNUM12.2  INFORMAT=NLNUM12.2 ;
attrib CLEARANCE_ACT_UNITS                 length=8      FORMAT=NLNUM12.2  INFORMAT=NLNUM12.2 ;
attrib PRICE_PROMO_UNITS                   length=8      FORMAT=NLNUM12.2  INFORMAT=NLNUM12.2 ;
attrib BASE_UNITS_NEW_REG_PRICE            length=8      FORMAT=NLNUM12.2  INFORMAT=NLNUM12.2 ;
attrib BASE_UNITS_PREV_REG_PRICE           length=8      FORMAT=NLNUM12.2  INFORMAT=NLNUM12.2 ;
 
attrib NON_PLANNED_ACT_AMT                 length=8      FORMAT=NLNUM20.3  INFORMAT=NLNUM20.3 ;
attrib CLEARANCE_ACT_AMT                   length=8      FORMAT=NLNUM20.3  INFORMAT=NLNUM20.3 ;
attrib PRICE_PROMO_AMT                     length=8      FORMAT=NLNUM20.3  INFORMAT=NLNUM20.3 ;
attrib BASE_AMT_NEW_REG_PRICE              length=8      FORMAT=NLNUM20.3  INFORMAT=NLNUM20.3 ;
attrib TOTAL_AMT_NEW_REG_PRICE             length=8      FORMAT=NLNUM20.3  INFORMAT=NLNUM20.3 ;
attrib TOTAL_AMT_PREV_REG_PRICE            length=8      FORMAT=NLNUM20.3  INFORMAT=NLNUM20.3 ;
 
attrib NON_PLANNED_ACT_MARGIN              length=8      FORMAT=NLNUM20.3  INFORMAT=NLNUM20.3 ;
attrib CLEARANCE_ACT_MARGIN                length=8      FORMAT=NLNUM20.3  INFORMAT=NLNUM20.3 ;
attrib PRICE_PROMO_MARGIN                  length=8      FORMAT=NLNUM20.3  INFORMAT=NLNUM20.3 ;
attrib BASE_MARGIN_NEW_REG_PRICE           length=8      FORMAT=NLNUM20.3  INFORMAT=NLNUM20.3 ;
attrib TOTAL_MARGIN_NEW_REG_PRICE          length=8      FORMAT=NLNUM20.3  INFORMAT=NLNUM20.3 ;
attrib TOTAL_MARGIN_PREV_REG_PRICE         length=8      FORMAT=NLNUM20.3  INFORMAT=NLNUM20.3 ;
stop; run;
 
proc sql noprint;
alter table &m_di_data..GEO_PROD_BENEFITS add CONSTRAINT PRIM_KEY PRIMARY KEY
(PROD_HIER_SK, GEO_HIER_SK, DATE_SK);
quit;
 
 
 
data &m_di_data..GEO_PROD_BENEFITS_PS;
attrib PROD_HIER_SK                        length=6   ;
attrib GEO_HIER_SK                         length=4   ;
attrib DATE_SK                             length=4   ;
 
attrib PS_NM                               length=$10 ;
attrib PS_UNITS                            length=8      FORMAT=NLNUM12.2 INFORMAT=NLNUM12.2 ;
attrib PS_AMT                              length=8      FORMAT=NLNUM20.3 INFORMAT=NLNUM20.3 ;
attrib PS_MARGIN                           length=8      FORMAT=NLNUM20.3 INFORMAT=NLNUM20.3 ;
 
stop; run;
 
proc sql noprint;
CREATE INDEX GPB_PS_IX1 ON &m_di_data..GEO_PROD_BENEFITS_PS
(PROD_HIER_SK,GEO_HIER_SK, DATE_SK);
quit;
 
 
* Check for errors while processing CHANGE_ID: ADD_GEO_PROD_BENEFITS_04;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ADD_GEO_PROD_BENEFITS_04;
%put ERROR- Description                              : Add GEO_PROD_BENEFITS to support benefits tracking view;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 09AUG2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ADD_GEO_PROD_BENEFITS_04;
proc sql;
insert  into di_data.data_model_change_management
values (
"ADD_GEO_PROD_BENEFITS_04",
"Add GEO_PROD_BENEFITS to support benefits tracking view",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ADD_GEO_PROD_BENEFITS_04:;
 
 
* End of changes for CHANGE_ID:ADD_GEO_PROD_BENEFITS_04;
 
 
***********************************************************************************************;
*************************************  End Change ADD_GEO_PROD_BENEFITS_04 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change RENAME_COL_COPIED_FLG ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: RENAME_COL_COPIED_FLG;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("RENAME_COL_COPIED_FLG")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : RENAME_COL_COPIED_FLG;
%goto RENAME_COL_COPIED_FLG;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : RENAME_COL_COPIED_FLG;
* Insert record into change management table for CHANGE_ID: RENAME_COL_COPIED_FLG;
proc sql;
insert  into di_data.data_model_change_management
values (
"RENAME_COL_COPIED_FLG",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto RENAME_COL_COPIED_FLG;
 
%end;
 
 
 
 
 
 
proc datasets lib=&m_di_data. nolist;
 
modify  SIZESET;
rename copied_flg=custom_flg;
quit;
run;
 
 
 
* Check for errors while processing CHANGE_ID: RENAME_COL_COPIED_FLG;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: RENAME_COL_COPIED_FLG;
%put ERROR- Description                              : Rename COPIED_FLG;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 09AUG2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: RENAME_COL_COPIED_FLG;
proc sql;
insert  into di_data.data_model_change_management
values (
"RENAME_COL_COPIED_FLG",
"Rename COPIED_FLG",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%RENAME_COL_COPIED_FLG:;
 
 
* End of changes for CHANGE_ID:RENAME_COL_COPIED_FLG;
 
 
***********************************************************************************************;
*************************************  End Change RENAME_COL_COPIED_FLG ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID761590_4 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID761590_4;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID761590_4")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_data..target_metrics))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_data..target_metrics;
%put NOTE- Change ID                             :ID761590_4;
%goto ID761590_4;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID761590_4;
%goto ID761590_4;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52,M2MI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID761590_4;
* Insert record into change management table for CHANGE_ID: ID761590_4;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID761590_4",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID761590_4;
 
%end;
 
 
 
 
 
proc sql;
ALTER TABLE &m_di_data..target_metrics ADD NOT NULL (TARGET_METRICS_VALUE);
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID761590_4;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID761590_4;
%put ERROR- Description                              : Minor correction to Target metrics enhancements;
%put ERROR- Version                                  : D3MICM52,M2MI42;
%put ERROR- Date of Change                           : 11AUG2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID761590_4;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID761590_4",
"Minor correction to Target metrics enhancements",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID761590_4:;
 
 
* End of changes for CHANGE_ID:ID761590_4;
 
 
***********************************************************************************************;
*************************************  End Change ID761590_4 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID782275 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID782275;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID782275")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(&m_di_mon.)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_di_mon.;
%put NOTE- Change ID                             :ID782275;
%goto ID782275;
 
%end;
%if not (%sysfunc(exist(&m_di_mon..ETL_SYS_PARAM))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_mon..ETL_SYS_PARAM;
%put NOTE- Change ID                             :ID782275;
%goto ID782275;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID782275;
%goto ID782275;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID782275;
* Insert record into change management table for CHANGE_ID: ID782275;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID782275",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID782275;
 
%end;
 
 
 
 
 
proc sql;
delete from &m_di_mon..ETL_SYS_PARAM
where upcase(jobname) = "ALLJOBS" and upcase(PARAM_NAME)="ETLP_BUDGET_TYPE";
 
delete from &m_di_mon..ETL_SYS_PARAM
where upcase(jobname) = "LOAD_STG2DM_BUDGET" and upcase(PARAM_NAME)="ETLP_BUDGET_TYPE";
 
insert into &m_di_mon..ETL_SYS_PARAM values("LOAD_STG2DM_BUDGET", "etlp_budget_type", "2", '"2"');
quit;
 
proc sql noprint;
alter table  &m_di_mon..STG_BUDGET_X
modify ETLS_EXCEPTION_COND char(450);
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID782275;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID782275;
%put ERROR- Description                              : Update jobname from ALLJOBS to LOAD_STG2DM_BUDGET for ETLP_BUDGET_TYPE parameter in ETL_SYS_PARAM table;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 12AUG2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID782275;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID782275",
"Update jobname from ALLJOBS to LOAD_STG2DM_BUDGET for ETLP_BUDGET_TYPE parameter in ETL_SYS_PARAM table",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID782275:;
 
 
* End of changes for CHANGE_ID:ID782275;
 
 
***********************************************************************************************;
*************************************  End Change ID782275 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID785334 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID785334;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID785334")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(&m_di_mon.)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_di_mon.;
%put NOTE- Change ID                             :ID785334;
%goto ID785334;
 
%end;
%if not (%sysfunc(exist(&m_di_mon..ETL_SYS_PARAM))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_mon..ETL_SYS_PARAM;
%put NOTE- Change ID                             :ID785334;
%goto ID785334;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID785334;
%goto ID785334;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID785334;
* Insert record into change management table for CHANGE_ID: ID785334;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID785334",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID785334;
 
%end;
 
 
 
 
 
 
proc sql;
delete from &m_di_mon..job_param
where jobname = 'LOAD_STG2DM_MDO_IMPORT_PLAN'
and param_name = 'etlp_dipcl_mark';
quit;
 
%di_util_purge_deleted_records (&m_di_mon..job_param);
 
 
 
* Check for errors while processing CHANGE_ID: ID785334;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID785334;
%put ERROR- Description                              : Remove option dipcl_mark from MDO Import.;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 19AUG2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID785334;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID785334",
"Remove option dipcl_mark from MDO Import.",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID785334:;
 
 
* End of changes for CHANGE_ID:ID785334;
 
 
***********************************************************************************************;
*************************************  End Change ID785334 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID785414 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID785414;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID785414")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID785414;
%goto ID785414;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID785414;
* Insert record into change management table for CHANGE_ID: ID785414;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID785414",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID785414;
 
%end;
 
 
 
 
 
 
proc sql;
 
DELETE FROM &m_di_data..GLOBAL_SETTING
WHERE SPEC_NM ='NUM_DAYS_VALID' and APP = 'RPP';
 
INSERT INTO &m_di_data..GLOBAL_SETTING (SPEC_NM,APP,SPEC_VALUE,SPEC_DESC) VALUES
('NUM_DAYS_VALID','RPP','7',
'Defines the number of days in the past the system should consider when populating actual metrics for Promotion Optimization plans.');
 
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID785414;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID785414;
%put ERROR- Description                              : New global setting NUM_DAYS_VALID;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 21AUG2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID785414;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID785414",
"New global setting NUM_DAYS_VALID",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID785414:;
 
 
* End of changes for CHANGE_ID:ID785414;
 
 
***********************************************************************************************;
*************************************  End Change ID785414 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID785339 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID785339;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID785339")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID785339;
%goto ID785339;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID785339;
* Insert record into change management table for CHANGE_ID: ID785339;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID785339",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID785339;
 
%end;
 
 
 
 
 
 
data &m_di_data..DOW_ADJ_FACTOR;
attrib GEO_HIER_SK           length=4;
attrib DAY_OF_WEEK           length=4;
attrib CORRECTION_FACTOR     length=8      FORMAT=NLNUM12.4     INFORMAT=NLNUM12.4 ;
stop; run;
 
data &m_didm_stg..STG_DOW_ADJ_FACTOR;
attrib GEO_ID                length=$32      ;
attrib DAY_OF_WEEK           length=4;
attrib CORRECTION_FACTOR     length=8      FORMAT=NLNUM12.4     INFORMAT=NLNUM12.4 ;
stop; run;
 
proc sql;
alter table &m_didm_stg..STG_DOW_ADJ_FACTOR add NOT NULL (GEO_ID);
alter table &m_didm_stg..STG_DOW_ADJ_FACTOR add NOT NULL (DAY_OF_WEEK);
alter table &m_didm_stg..STG_DOW_ADJ_FACTOR add NOT NULL (CORRECTION_FACTOR);
quit;
 
 
data &m_di_mon..STG_DOW_ADJ_FACTOR_X ;
attrib GEO_ID                length=$32      ;
attrib GEO_HIER_SK           length=4;
attrib DAY_OF_WEEK           length=4;
attrib CORRECTION_FACTOR     length=8      FORMAT=NLNUM12.4     INFORMAT=NLNUM12.4 ;
attrib ETLS_EXCEPTION_COND   length=$170 ;
attrib ETL_ERROR_JOBRUNTIME length=8 format=DATETIME16. ;
stop;run;
 
 
 
* Check for errors while processing CHANGE_ID: ID785339;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID785339;
%put ERROR- Description                              : DOW Event Profile;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 22AUG2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID785339;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID785339",
"DOW Event Profile",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID785339:;
 
 
* End of changes for CHANGE_ID:ID785339;
 
 
***********************************************************************************************;
*************************************  End Change ID785339 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID785339_1 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID785339_1;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID785339_1")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID785339_1;
%goto ID785339_1;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID785339_1;
* Insert record into change management table for CHANGE_ID: ID785339_1;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID785339_1",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID785339_1;
 
%end;
 
 
 
 
 
 
proc sql;
alter table &m_di_data..DOW_ADJ_FACTOR add CONSTRAINT PRIM_KEY PRIMARY KEY(GEO_HIER_SK);
 
alter table &m_di_data..DOW_ADJ_FACTOR add NOT NULL (DAY_OF_WEEK);
alter table &m_di_data..DOW_ADJ_FACTOR add NOT NULL (CORRECTION_FACTOR);
 
quit;
 
proc sql;
ALTER TABLE &m_di_mon..STG_DOW_ADJ_FACTOR_X
DROP GEO_HIER_SK;
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID785339_1;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID785339_1;
%put ERROR- Description                              : DOW Event Profile;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 08SEP2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID785339_1;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID785339_1",
"DOW Event Profile",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID785339_1:;
 
 
* End of changes for CHANGE_ID:ID785339_1;
 
 
***********************************************************************************************;
*************************************  End Change ID785339_1 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID785339_2 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID785339_2;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID785339_2")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID785339_2;
%goto ID785339_2;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID785339_2;
* Insert record into change management table for CHANGE_ID: ID785339_2;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID785339_2",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID785339_2;
 
%end;
 
 
 
 
 
 
proc sql;
ALTER TABLE &m_di_data..DOW_ADJ_FACTOR
DROP CONSTRAINT _NM0001_, _NM0002_, PRIM_KEY;
quit;
 
proc sql;
alter table &m_di_data..DOW_ADJ_FACTOR add CONSTRAINT PRIM_KEY PRIMARY KEY(GEO_HIER_SK, DAY_OF_WEEK);
 
alter table &m_di_data..DOW_ADJ_FACTOR add NOT NULL (CORRECTION_FACTOR);
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID785339_2;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID785339_2;
%put ERROR- Description                              : DOW Event Profile;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 12SEP2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID785339_2;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID785339_2",
"DOW Event Profile",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID785339_2:;
 
 
* End of changes for CHANGE_ID:ID785339_2;
 
 
***********************************************************************************************;
*************************************  End Change ID785339_2 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID785339_3 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID785339_3;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID785339_3")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(&m_di_mon)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_di_mon;
%put NOTE- Change ID                             :ID785339_3;
%goto ID785339_3;
 
%end;
%if not (%sysfunc(exist(&m_di_mon..job_param))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_mon..job_param;
%put NOTE- Change ID                             :ID785339_3;
%goto ID785339_3;
 
%end;
%if not (%sysfunc(exist(&m_di_mon..etl_sys_param))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_mon..etl_sys_param;
%put NOTE- Change ID                             :ID785339_3;
%goto ID785339_3;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID785339_3;
%goto ID785339_3;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID785339_3;
* Insert record into change management table for CHANGE_ID: ID785339_3;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID785339_3",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID785339_3;
 
%end;
 
 
 
 
 
 
 
proc sql noprint ;
DELETE FROM &m_di_mon..job_param where jobname = 'LOAD_SRC2STG_DOW_ADJ_FACTOR' and param_name='etlp_src_file';
 
Insert into &m_di_mon..job_param
(jobname, param_name, param_value, default_func)
values("LOAD_SRC2STG_DOW_ADJ_FACTOR",         "etlp_src_file",             "/data/stg_dow_adj_factor.csv",             '"Y"'   );
quit;
 
proc sql;
Delete from &m_di_mon..etl_sys_param where jobname = 'LOAD_STG2DM_DOW_ADJ_FACTOR' and param_name='etlp_exception_table';
 
Insert into &m_di_mon..Etl_sys_param
(jobname, param_name, param_value, default_func)
values("LOAD_STG2DM_DOW_ADJ_FACTOR",          "etlp_exception_table",      "DI_MON.STG_DOW_ADJ_FACTOR_X",                 '"DI_MON.STG_DOW_ADJ_FACTOR_X"'          )
;
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID785339_3;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID785339_3;
%put ERROR- Description                              : DOW Event Profile;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 27SEP2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID785339_3;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID785339_3",
"DOW Event Profile",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID785339_3:;
 
 
* End of changes for CHANGE_ID:ID785339_3;
 
 
***********************************************************************************************;
*************************************  End Change ID785339_3 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID786675 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID786675;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID786675")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID786675;
%goto ID786675;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID786675;
* Insert record into change management table for CHANGE_ID: ID786675;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID786675",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID786675;
 
%end;
 
 
 
 
 
 
proc sql;
 
DELETE FROM &m_di_data..GLOBAL_SETTING WHERE SPEC_NM ='PROD_RELATION_LVL';
 
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID786675;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID786675;
%put ERROR- Description                              : Remove PROD_RELATION_LVL global setting;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 24AUG2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID786675;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID786675",
"Remove PROD_RELATION_LVL global setting",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID786675:;
 
 
* End of changes for CHANGE_ID:ID786675;
 
 
***********************************************************************************************;
*************************************  End Change ID786675 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID768268 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID768268;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID768268")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_data..PRICE_PROMO_ELASTICITY))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_data..PRICE_PROMO_ELASTICITY;
%put NOTE- Change ID                             :ID768268;
%goto ID768268;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID768268;
%goto ID768268;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID768268;
* Insert record into change management table for CHANGE_ID: ID768268;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID768268",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID768268;
 
%end;
 
 
 
 
 
 
%di_util_drop_constraint(m_lib=&m_di_data., m_table=PRICE_PROMO_ELASTICITY, m_column=%str(data_config_sk), m_constraint=%str(not null));
%di_util_drop_constraint(m_lib=&m_di_data., m_table=PRICE_PROMO_ELASTICITY, m_column=%str(tsf_type), m_constraint=%str(not null));
%di_util_drop_constraint(m_lib=&m_di_data., m_table=PRICE_PROMO_ELASTICITY, m_column=%str(cross_prod_hier_sk), m_constraint=%str(not null));
 
proc sql noprint;
alter table  &m_di_data..PRICE_PROMO_ELASTICITY
drop data_config_sk, tsf_type, cross_prod_hier_sk;
alter table  &m_di_data..PRICE_PROMO_ELASTICITY
modify effect_category char(20);
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID768268;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID768268;
%put ERROR- Description                              : Slim down PRICE_PROMO_ELASTICITY schema;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 24AUG2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID768268;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID768268",
"Slim down PRICE_PROMO_ELASTICITY schema",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID768268:;
 
 
* End of changes for CHANGE_ID:ID768268;
 
 
***********************************************************************************************;
*************************************  End Change ID768268 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID786756 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID786756;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID786756")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID786756;
%goto ID786756;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID786756;
* Insert record into change management table for CHANGE_ID: ID786756;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID786756",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID786756;
 
%end;
 
 
 
 
 
data &m_di_data..GEO_PROD_EXCEPTION;
set &m_di_data..GEO_PROD_EXCEPTION
(rename=(Inventory_flg=Inventory_flg_num
Current_cost_flg=Current_Cost_flg_num
Current_price_flg=Current_price_flg_num));
attrib INVENTORY_FLG LENGTH=$1 CURRENT_PRICE_FLG LENGTH=$1
CURRENT_COST_FLG LENGTH = $1 PROD_DISCONTINUED_FLG LENGTH = $1
GEO_CLOSE_FLG LENGTH = $1;
 
INVENTORY_FLG = LEFT(PUT(INVENTORY_FLG_NUM,BEST.));
CURRENT_PRICE_FLG = LEFT(PUT(CURRENT_PRICE_FLG_NUM,BEST.));
CURRENT_COST_FLG = LEFT(PUT(CURRENT_COST_FLG_NUM,BEST.));
 
drop Inventory_flg_num current_price_flg_num current_cost_flg_num;
run;
 
proc sql;
alter table &m_di_data..GEO_PROD_EXCEPTION add CONSTRAINT PRIM_KEY PRIMARY KEY (GEO_HIER_SK, PROD_HIER_SK);
quit;
 
proc sql;
CREATE INDEX INVENTORY_FLG ON &m_di_data..GEO_PROD_EXCEPTION(INVENTORY_FLG);
CREATE INDEX CURRENT_PRICE_FLG ON &m_di_data..GEO_PROD_EXCEPTION(CURRENT_PRICE_FLG);
CREATE INDEX CURRENT_COST_FLG ON &m_di_data..GEO_PROD_EXCEPTION(CURRENT_COST_FLG);
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID786756;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID786756;
%put ERROR- Description                              : Add Prod and Store close flags to Geo_prod_exception and change datatype;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 26AUG2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID786756;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID786756",
"Add Prod and Store close flags to Geo_prod_exception and change datatype",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID786756:;
 
 
* End of changes for CHANGE_ID:ID786756;
 
 
***********************************************************************************************;
*************************************  End Change ID786756 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change DI_MON_FMTS_A ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: DI_MON_FMTS_A;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("DI_MON_FMTS_A")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(&m_di_mon.)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_di_mon.;
%put NOTE- Change ID                             :DI_MON_FMTS_A;
%goto DI_MON_FMTS_A;
 
%end;
%if not (%sysfunc(exist(&m_di_mon..DUP_SALES_FACT))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_mon..DUP_SALES_FACT;
%put NOTE- Change ID                             :DI_MON_FMTS_A;
%goto DI_MON_FMTS_A;
 
%end;
%if not (%sysfunc(exist(&m_di_mon..DUP_INVENTORY_FACT))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_mon..DUP_INVENTORY_FACT;
%put NOTE- Change ID                             :DI_MON_FMTS_A;
%goto DI_MON_FMTS_A;
 
%end;
%if not (%sysfunc(exist(&m_di_mon..STG_SALES_X))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_mon..STG_SALES_X;
%put NOTE- Change ID                             :DI_MON_FMTS_A;
%goto DI_MON_FMTS_A;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : DI_MON_FMTS_A;
%goto DI_MON_FMTS_A;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : DI_MON_FMTS_A;
* Insert record into change management table for CHANGE_ID: DI_MON_FMTS_A;
proc sql;
insert  into di_data.data_model_change_management
values (
"DI_MON_FMTS_A",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto DI_MON_FMTS_A;
 
%end;
 
 
 
 
 
proc datasets library=di_mon nolist;
modify DUP_SALES_FACT;
informat TOTAL_SALES_AMT NLNUM20.3 ;
format TOTAL_SALES_AMT NLNUM20.3 ;
 
modify  DUP_INVENTORY_FACT;
informat CLOSE_INV_AMT_AT_RETAIL NLNUM20.3 ;
format CLOSE_INV_AMT_AT_RETAIL NLNUM20.3 ;
 
informat CLOSE_INV_AMT_AT_COST NLNUM20.3 ;
format CLOSE_INV_AMT_AT_COST NLNUM20.3 ;
 
modify STG_SALES_X;
informat TOTAL_SALES_QTY NLNUM12.2 ;
format TOTAL_SALES_QTY NLNUM12.2 ;
 
informat TOTAL_SALES_AMT NLNUM20.3 ;
format TOTAL_SALES_AMT NLNUM20.3 ;
 
quit;
 
 
 
* Check for errors while processing CHANGE_ID: DI_MON_FMTS_A;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: DI_MON_FMTS_A;
%put ERROR- Description                              : Updating formats of MON tables to avoid format mismatch.;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 01SEP2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: DI_MON_FMTS_A;
proc sql;
insert  into di_data.data_model_change_management
values (
"DI_MON_FMTS_A",
"Updating formats of MON tables to avoid format mismatch.",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%DI_MON_FMTS_A:;
 
 
* End of changes for CHANGE_ID:DI_MON_FMTS_A;
 
 
***********************************************************************************************;
*************************************  End Change DI_MON_FMTS_A ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change DI_MON_FMTS_B ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: DI_MON_FMTS_B;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("DI_MON_FMTS_B")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(&m_di_mon.)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_di_mon.;
%put NOTE- Change ID                             :DI_MON_FMTS_B;
%goto DI_MON_FMTS_B;
 
%end;
%if not (%sysfunc(exist(&m_di_mon..STG_INVENTORY_X))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_mon..STG_INVENTORY_X;
%put NOTE- Change ID                             :DI_MON_FMTS_B;
%goto DI_MON_FMTS_B;
 
%end;
%if not (%sysfunc(exist(&m_di_mon..STG_SALES_MIX_DAY_OF_WEEK_X))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_mon..STG_SALES_MIX_DAY_OF_WEEK_X;
%put NOTE- Change ID                             :DI_MON_FMTS_B;
%goto DI_MON_FMTS_B;
 
%end;
%if not (%sysfunc(exist(&m_di_mon..STG_CUSTOMER_RETURNS_X))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_mon..STG_CUSTOMER_RETURNS_X;
%put NOTE- Change ID                             :DI_MON_FMTS_B;
%goto DI_MON_FMTS_B;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : DI_MON_FMTS_B;
%goto DI_MON_FMTS_B;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : DI_MON_FMTS_B;
* Insert record into change management table for CHANGE_ID: DI_MON_FMTS_B;
proc sql;
insert  into di_data.data_model_change_management
values (
"DI_MON_FMTS_B",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto DI_MON_FMTS_B;
 
%end;
 
 
 
 
 
proc datasets library=di_mon nolist;
 
modify  STG_INVENTORY_X;
informat CLOSE_INV_AMT_AT_RETAIL NLNUM20.3 ;
format CLOSE_INV_AMT_AT_RETAIL NLNUM20.3 ;
 
informat CLOSE_INV_AMT_AT_COST NLNUM20.3 ;
format CLOSE_INV_AMT_AT_COST NLNUM20.3 ;
 
modify  STG_SALES_MIX_DAY_OF_WEEK_X;
informat DOW_MIX_INDEX NLNUM12.4 ;
format DOW_MIX_INDEX NLNUM12.4 ;
 
modify  STG_CUSTOMER_RETURNS_X;
informat RETURNED_AMT NLNUM20.3 ;
format RETURNED_AMT NLNUM20.3 ;
 
 
quit;
 
 
 
* Check for errors while processing CHANGE_ID: DI_MON_FMTS_B;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: DI_MON_FMTS_B;
%put ERROR- Description                              : Updating formats of MON tables to avoid format mismatch.;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 01SEP2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: DI_MON_FMTS_B;
proc sql;
insert  into di_data.data_model_change_management
values (
"DI_MON_FMTS_B",
"Updating formats of MON tables to avoid format mismatch.",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%DI_MON_FMTS_B:;
 
 
* End of changes for CHANGE_ID:DI_MON_FMTS_B;
 
 
***********************************************************************************************;
*************************************  End Change DI_MON_FMTS_B ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change DI_MON_FMTS_C ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: DI_MON_FMTS_C;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("DI_MON_FMTS_C")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(&m_di_mon.)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_di_mon.;
%put NOTE- Change ID                             :DI_MON_FMTS_C;
%goto DI_MON_FMTS_C;
 
%end;
%if not (%sysfunc(exist(&m_di_mon..DUP_SALES_FACT))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_mon..DUP_SALES_FACT;
%put NOTE- Change ID                             :DI_MON_FMTS_C;
%goto DI_MON_FMTS_C;
 
%end;
%if not (%sysfunc(exist(&m_di_mon..DUP_INVENTORY_FACT))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_mon..DUP_INVENTORY_FACT;
%put NOTE- Change ID                             :DI_MON_FMTS_C;
%goto DI_MON_FMTS_C;
 
%end;
%if not (%sysfunc(exist(&m_di_mon..STG_SALES_X))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_mon..STG_SALES_X;
%put NOTE- Change ID                             :DI_MON_FMTS_C;
%goto DI_MON_FMTS_C;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : DI_MON_FMTS_C;
%goto DI_MON_FMTS_C;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : DI_MON_FMTS_C;
* Insert record into change management table for CHANGE_ID: DI_MON_FMTS_C;
proc sql;
insert  into di_data.data_model_change_management
values (
"DI_MON_FMTS_C",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto DI_MON_FMTS_C;
 
%end;
 
 
 
 
 
proc datasets library=di_mon nolist;
modify DUP_SALES_FACT;
informat TOTAL_SALES_AMT NLNUM20.3 ;
format TOTAL_SALES_AMT NLNUM20.3 ;
 
modify  DUP_INVENTORY_FACT;
informat CLOSE_INV_AMT_AT_RETAIL NLNUM20.3 ;
format CLOSE_INV_AMT_AT_RETAIL NLNUM20.3 ;
 
informat CLOSE_INV_AMT_AT_COST NLNUM20.3 ;
format CLOSE_INV_AMT_AT_COST NLNUM20.3 ;
 
modify STG_SALES_X;
informat TOTAL_SALES_QTY NLNUM12.2 ;
format TOTAL_SALES_QTY NLNUM12.2 ;
 
informat TOTAL_SALES_AMT NLNUM20.3 ;
format TOTAL_SALES_AMT NLNUM20.3 ;
 
quit;
 
 
 
* Check for errors while processing CHANGE_ID: DI_MON_FMTS_C;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: DI_MON_FMTS_C;
%put ERROR- Description                              : Updating formats of MON tables to avoid format mismatch.;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 01SEP2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: DI_MON_FMTS_C;
proc sql;
insert  into di_data.data_model_change_management
values (
"DI_MON_FMTS_C",
"Updating formats of MON tables to avoid format mismatch.",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%DI_MON_FMTS_C:;
 
 
* End of changes for CHANGE_ID:DI_MON_FMTS_C;
 
 
***********************************************************************************************;
*************************************  End Change DI_MON_FMTS_C ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change DI_MON_FMTS_D ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: DI_MON_FMTS_D;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("DI_MON_FMTS_D")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(&m_di_mon.)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_di_mon.;
%put NOTE- Change ID                             :DI_MON_FMTS_D;
%goto DI_MON_FMTS_D;
 
%end;
%if not (%sysfunc(exist(&m_di_mon..STG_INVENTORY_X))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_mon..STG_INVENTORY_X;
%put NOTE- Change ID                             :DI_MON_FMTS_D;
%goto DI_MON_FMTS_D;
 
%end;
%if not (%sysfunc(exist(&m_di_mon..STG_SALES_MIX_DAY_OF_WEEK_X))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_mon..STG_SALES_MIX_DAY_OF_WEEK_X;
%put NOTE- Change ID                             :DI_MON_FMTS_D;
%goto DI_MON_FMTS_D;
 
%end;
%if not (%sysfunc(exist(&m_di_mon..STG_CUSTOMER_RETURNS_X))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_mon..STG_CUSTOMER_RETURNS_X;
%put NOTE- Change ID                             :DI_MON_FMTS_D;
%goto DI_MON_FMTS_D;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : DI_MON_FMTS_D;
%goto DI_MON_FMTS_D;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : DI_MON_FMTS_D;
* Insert record into change management table for CHANGE_ID: DI_MON_FMTS_D;
proc sql;
insert  into di_data.data_model_change_management
values (
"DI_MON_FMTS_D",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto DI_MON_FMTS_D;
 
%end;
 
 
 
 
 
proc datasets library=di_mon nolist;
 
modify  STG_INVENTORY_X;
informat CLOSE_INV_AMT_AT_RETAIL NLNUM20.3 ;
format CLOSE_INV_AMT_AT_RETAIL NLNUM20.3 ;
 
informat CLOSE_INV_AMT_AT_COST NLNUM20.3 ;
format CLOSE_INV_AMT_AT_COST NLNUM20.3 ;
 
modify  STG_SALES_MIX_DAY_OF_WEEK_X;
informat DOW_MIX_INDEX NLNUM12.4 ;
format DOW_MIX_INDEX NLNUM12.4 ;
 
modify  STG_CUSTOMER_RETURNS_X;
informat RETURNED_AMT NLNUM20.3 ;
format RETURNED_AMT NLNUM20.3 ;
 
 
quit;
 
 
 
* Check for errors while processing CHANGE_ID: DI_MON_FMTS_D;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: DI_MON_FMTS_D;
%put ERROR- Description                              : Updating formats of MON tables to avoid format mismatch.;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 01SEP2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: DI_MON_FMTS_D;
proc sql;
insert  into di_data.data_model_change_management
values (
"DI_MON_FMTS_D",
"Updating formats of MON tables to avoid format mismatch.",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%DI_MON_FMTS_D:;
 
 
* End of changes for CHANGE_ID:DI_MON_FMTS_D;
 
 
***********************************************************************************************;
*************************************  End Change DI_MON_FMTS_D ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change DI_MON_FMTS_E ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: DI_MON_FMTS_E;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("DI_MON_FMTS_E")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(&m_di_mon.)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_di_mon.;
%put NOTE- Change ID                             :DI_MON_FMTS_E;
%goto DI_MON_FMTS_E;
 
%end;
%if not (%sysfunc(exist(&m_di_mon..STG_PROMOTION_SALES_X))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_mon..STG_PROMOTION_SALES_X;
%put NOTE- Change ID                             :DI_MON_FMTS_E;
%goto DI_MON_FMTS_E;
 
%end;
%if not (%sysfunc(exist(&m_di_mon..STG_DEMAND_DISAGG_X))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_mon..STG_DEMAND_DISAGG_X;
%put NOTE- Change ID                             :DI_MON_FMTS_E;
%goto DI_MON_FMTS_E;
 
%end;
%if not (%sysfunc(exist(&m_di_mon..STG_PACK_GROUP_GEO_SETTINGS_X))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_mon..STG_PACK_GROUP_GEO_SETTINGS_X;
%put NOTE- Change ID                             :DI_MON_FMTS_E;
%goto DI_MON_FMTS_E;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : DI_MON_FMTS_E;
%goto DI_MON_FMTS_E;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52,M2MI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : DI_MON_FMTS_E;
* Insert record into change management table for CHANGE_ID: DI_MON_FMTS_E;
proc sql;
insert  into di_data.data_model_change_management
values (
"DI_MON_FMTS_E",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto DI_MON_FMTS_E;
 
%end;
 
 
 
 
 
proc datasets library=di_mon nolist;
 
 
modify  STG_PROMOTION_SALES_X;
informat PROMO_SALES_UNITS NLNUM12.4 ;
format PROMO_SALES_UNITS NLNUM12.4 ;
 
modify  STG_DEMAND_DISAGG_X;
informat DISAGG_FACTOR NLNUM12.4 ;
format DISAGG_FACTOR NLNUM12.4 ;
 
modify  STG_PACK_GROUP_GEO_SETTINGS_X;
informat OPENING_COST NLNUM20.3 ;
format OPENING_COST NLNUM20.3 ;
 
informat HANDLING_COST NLNUM20.3 ;
format HANDLING_COST NLNUM20.3 ;
 
modify  STG_INVENTORY_PACK_X;
informat CLOSE_INV_UNITS NLNUM12.2 ;
format CLOSE_INV_UNITS NLNUM12.2 ;
 
informat CLOSE_INV_AMT_AT_RETAIL NLNUM20.3 ;
format CLOSE_INV_AMT_AT_RETAIL NLNUM20.3 ;
 
informat CLOSE_INV_AMT_AT_COST NLNUM20.3 ;
format CLOSE_INV_AMT_AT_COST NLNUM20.3 ;
 
modify  STG_BUDGET_X;
informat TOTAL_BUDGET_AMT NLNUM20.3;
format TOTAL_BUDGET_AMT NLNUM20.3 ;
 
informat USED_BUDGET_AMT NLNUM20.3 ;
format USED_BUDGET_AMT NLNUM20.3 ;
 
informat REVISED_BUDGET_AMT NLNUM20.3;
format REVISED_BUDGET_AMT NLNUM20.3 ;
 
 
modify  STG_TARGET_METRICS_X ;
informat TARGET_METRICS_VALUE NLNUM20.3 ;
format TARGET_METRICS_VALUE NLNUM20.3 ;
 
modify  STG_COMP_PRICE_X ;
informat PRICE NLNUM20.3 ;
format PRICE NLNUM20.3 ;
 
quit;
 
 
 
* Check for errors while processing CHANGE_ID: DI_MON_FMTS_E;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: DI_MON_FMTS_E;
%put ERROR- Description                              : Updating formats of MON tables to avoid format mismatch.;
%put ERROR- Version                                  : D3MICM52,M2MI42;
%put ERROR- Date of Change                           : 01SEP2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: DI_MON_FMTS_E;
proc sql;
insert  into di_data.data_model_change_management
values (
"DI_MON_FMTS_E",
"Updating formats of MON tables to avoid format mismatch.",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%DI_MON_FMTS_E:;
 
 
* End of changes for CHANGE_ID:DI_MON_FMTS_E;
 
 
***********************************************************************************************;
*************************************  End Change DI_MON_FMTS_E ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change DI_MON_FMTS_F ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: DI_MON_FMTS_F;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("DI_MON_FMTS_F")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(&m_di_mon.)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_di_mon.;
%put NOTE- Change ID                             :DI_MON_FMTS_F;
%goto DI_MON_FMTS_F;
 
%end;
%if not (%sysfunc(exist(&m_di_mon..STG_INVENTORY_PACK_X))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_mon..STG_INVENTORY_PACK_X;
%put NOTE- Change ID                             :DI_MON_FMTS_F;
%goto DI_MON_FMTS_F;
 
%end;
%if not (%sysfunc(exist(&m_di_mon..STG_BUDGET_X))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_mon..STG_BUDGET_X;
%put NOTE- Change ID                             :DI_MON_FMTS_F;
%goto DI_MON_FMTS_F;
 
%end;
%if not (%sysfunc(exist(&m_di_mon..STG_TARGET_METRICS_X))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_mon..STG_TARGET_METRICS_X;
%put NOTE- Change ID                             :DI_MON_FMTS_F;
%goto DI_MON_FMTS_F;
 
%end;
%if not (%sysfunc(exist(&m_di_mon..STG_COMP_PRICE_X))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_mon..STG_COMP_PRICE_X;
%put NOTE- Change ID                             :DI_MON_FMTS_F;
%goto DI_MON_FMTS_F;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : DI_MON_FMTS_F;
%goto DI_MON_FMTS_F;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52,M2MI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : DI_MON_FMTS_F;
* Insert record into change management table for CHANGE_ID: DI_MON_FMTS_F;
proc sql;
insert  into di_data.data_model_change_management
values (
"DI_MON_FMTS_F",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto DI_MON_FMTS_F;
 
%end;
 
 
 
 
 
proc datasets library=di_mon nolist;
 
 
 
modify  STG_INVENTORY_PACK_X;
informat CLOSE_INV_UNITS NLNUM12.2 ;
format CLOSE_INV_UNITS NLNUM12.2 ;
 
informat CLOSE_INV_AMT_AT_RETAIL NLNUM20.3 ;
format CLOSE_INV_AMT_AT_RETAIL NLNUM20.3 ;
 
informat CLOSE_INV_AMT_AT_COST NLNUM20.3 ;
format CLOSE_INV_AMT_AT_COST NLNUM20.3 ;
 
modify  STG_BUDGET_X;
informat TOTAL_BUDGET_AMT NLNUM20.3;
format TOTAL_BUDGET_AMT NLNUM20.3 ;
 
informat USED_BUDGET_AMT NLNUM20.3 ;
format USED_BUDGET_AMT NLNUM20.3 ;
 
informat REVISED_BUDGET_AMT NLNUM20.3;
format REVISED_BUDGET_AMT NLNUM20.3 ;
 
 
modify  STG_TARGET_METRICS_X ;
informat TARGET_METRICS_VALUE NLNUM20.3 ;
format TARGET_METRICS_VALUE NLNUM20.3 ;
 
modify  STG_COMP_PRICE_X ;
informat PRICE NLNUM20.3 ;
format PRICE NLNUM20.3 ;
 
quit;
 
 
 
* Check for errors while processing CHANGE_ID: DI_MON_FMTS_F;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: DI_MON_FMTS_F;
%put ERROR- Description                              : Updating formats of MON tables to avoid format mismatch.;
%put ERROR- Version                                  : D3MICM52,M2MI42;
%put ERROR- Date of Change                           : 01SEP2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: DI_MON_FMTS_F;
proc sql;
insert  into di_data.data_model_change_management
values (
"DI_MON_FMTS_F",
"Updating formats of MON tables to avoid format mismatch.",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%DI_MON_FMTS_F:;
 
 
* End of changes for CHANGE_ID:DI_MON_FMTS_F;
 
 
***********************************************************************************************;
*************************************  End Change DI_MON_FMTS_F ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change MDL_GP_PARTS ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: MDL_GP_PARTS;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("MDL_GP_PARTS")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_data..MODEL_GEO_PROD))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_data..MODEL_GEO_PROD;
%put NOTE- Change ID                             :MDL_GP_PARTS;
%goto MDL_GP_PARTS;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : MDL_GP_PARTS;
%goto MDL_GP_PARTS;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : MDL_GP_PARTS;
* Insert record into change management table for CHANGE_ID: MDL_GP_PARTS;
proc sql;
insert  into di_data.data_model_change_management
values (
"MDL_GP_PARTS",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto MDL_GP_PARTS;
 
%end;
 
 
 
 
 
 
 
%let m_subdir=MODEL_GEO_PROD;
%let m_partlib=ZMGP_LIB;
 
 
%di_etl_set_lib (parent_lib=&m_di_data., sub_folder=&m_subdir.,partition_lib=&m_partlib. );
 
%local all_tabs num_tabs tab_name i;
 
proc sql noprint;
select memname into :all_tabs
separated by " "
from dictionary.tables
where libname = "&m_partlib";
quit;
 
proc sql noprint;
select count(*) into :num_tabs
from dictionary.tables
where libname = "&m_partlib";
quit;
 
%put &m_subdir. (&num_tabs): &all_tabs;
 
proc contents nodetails noprint data=&m_di_data..&m_subdir.
out2=work.etl_cons1;
run;
 
%if &num_tabs gt 0 %then
%do;
 
%do i=1 %to &num_tabs;
 
%let tab_name = %scan(&all_tabs, &i);
data &m_partlib..&tab_name;
set &m_partlib..&tab_name;
attrib DOW_GROUP_ID length=4;
DOW_GROUP_ID=0;
run;
 
data _null_;
set work.etl_cons1 end=eof;
if _n_ eq 1 then do;
call execute("proc datasets lib = &m_partlib. nolist; modify &tab_name;");
end;
call execute("      " || recreate);
if eof then call execute("quit;");
run;
 
%end;
 
%end;
 
libname &m_partlib clear;
 
 
* Check for errors while processing CHANGE_ID: MDL_GP_PARTS;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: MDL_GP_PARTS;
%put ERROR- Description                              : Update partitioned MODEL_GEO_PROD tables;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 01SEP2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: MDL_GP_PARTS;
proc sql;
insert  into di_data.data_model_change_management
values (
"MDL_GP_PARTS",
"Update partitioned MODEL_GEO_PROD tables",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%MDL_GP_PARTS:;
 
 
* End of changes for CHANGE_ID:MDL_GP_PARTS;
 
 
***********************************************************************************************;
*************************************  End Change MDL_GP_PARTS ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change DROP_WKDY_CORR_FCTR ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: DROP_WKDY_CORR_FCTR;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("DROP_WKDY_CORR_FCTR")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_data..WEEKDAY_CORRECT_FACT))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_data..WEEKDAY_CORRECT_FACT;
%put NOTE- Change ID                             :DROP_WKDY_CORR_FCTR;
%goto DROP_WKDY_CORR_FCTR;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : DROP_WKDY_CORR_FCTR;
%goto DROP_WKDY_CORR_FCTR;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : DROP_WKDY_CORR_FCTR;
* Insert record into change management table for CHANGE_ID: DROP_WKDY_CORR_FCTR;
proc sql;
insert  into di_data.data_model_change_management
values (
"DROP_WKDY_CORR_FCTR",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto DROP_WKDY_CORR_FCTR;
 
%end;
 
 
 
 
 
 
proc sql noprint;
drop table &m_di_data..WEEKDAY_CORRECT_FACT;
quit;
 
 
 
* Check for errors while processing CHANGE_ID: DROP_WKDY_CORR_FCTR;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: DROP_WKDY_CORR_FCTR;
%put ERROR- Description                              : Drop WEEKDAY_CORRECT_FACT Table;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 02SEP2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: DROP_WKDY_CORR_FCTR;
proc sql;
insert  into di_data.data_model_change_management
values (
"DROP_WKDY_CORR_FCTR",
"Drop WEEKDAY_CORRECT_FACT Table",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%DROP_WKDY_CORR_FCTR:;
 
 
* End of changes for CHANGE_ID:DROP_WKDY_CORR_FCTR;
 
 
***********************************************************************************************;
*************************************  End Change DROP_WKDY_CORR_FCTR ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID756451 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID756451;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID756451")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID756451;
%goto ID756451;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID756451;
* Insert record into change management table for CHANGE_ID: ID756451;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID756451",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID756451;
 
%end;
 
 
 
 
 
 
%di_util_drop_constraint(m_lib=&m_di_data., m_table=RETURN_FACT, m_column=%str(RETURNED_UNITS), m_constraint=%str(not null));
%di_util_drop_constraint(m_lib=&m_di_data., m_table=RETURN_FACT, m_column=%str(RETURNED_AMT), m_constraint=%str(not null));
proc sql;
 
alter table &m_di_data..RETURN_FACT add NOT NULL (RETURNED_UNITS);
alter table &m_di_data..RETURN_FACT add NOT NULL (RETURNED_AMT);
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID756451;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID756451;
%put ERROR- Description                              : Returned_Units and Returned_Amt in Return_fact should be not null;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 27SEP2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID756451;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID756451",
"Returned_Units and Returned_Amt in Return_fact should be not null",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID756451:;
 
 
* End of changes for CHANGE_ID:ID756451;
 
 
***********************************************************************************************;
*************************************  End Change ID756451 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID796478 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID796478;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID796478")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID796478;
%goto ID796478;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID796478;
* Insert record into change management table for CHANGE_ID: ID796478;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID796478",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID796478;
 
%end;
 
 
 
 
 
 
Data &m_di_mon..STG_BUDGET_X ;
attrib GEO_ID length=$32 ;
attrib PROD_ID length=$32 ;
attrib START_DT length=8 format=DATE. ;
attrib END_DT length=8 format=DATE. ;
attrib BUDGET_TYPE length=8 ;
attrib BUDGET_NM length=$100 ;
attrib TOTAL_BUDGET_AMT length=8 FORMAT=NLNUM20.3   INFORMAT=NLNUM20.3;
attrib USED_BUDGET_AMT length=8 FORMAT=NLNUM20.3   INFORMAT=NLNUM20.3;
attrib REVISED_BUDGET_AMT length=8 FORMAT=NLNUM20.3   INFORMAT=NLNUM20.3;
attrib ETLS_EXCEPTION_COND length=$450 ;
attrib ETL_ERROR_JOBRUNTIME length=8 format=DATETIME16. ;
stop;run;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID796478;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID796478;
%put ERROR- Description                              : Changing formats for STG_BUDGET_X to avoid format warnings;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 28SEP2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID796478;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID796478",
"Changing formats for STG_BUDGET_X to avoid format warnings",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID796478:;
 
 
* End of changes for CHANGE_ID:ID796478;
 
 
***********************************************************************************************;
*************************************  End Change ID796478 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change DROP_IDX_GEO_HIER_SK ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: DROP_IDX_GEO_HIER_SK;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("DROP_IDX_GEO_HIER_SK")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : DROP_IDX_GEO_HIER_SK;
%goto DROP_IDX_GEO_HIER_SK;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : DROP_IDX_GEO_HIER_SK;
* Insert record into change management table for CHANGE_ID: DROP_IDX_GEO_HIER_SK;
proc sql;
insert  into di_data.data_model_change_management
values (
"DROP_IDX_GEO_HIER_SK",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto DROP_IDX_GEO_HIER_SK;
 
%end;
 
 
 
 
 
%di_util_drop_constraint(m_lib=&m_di_data., m_table=GEOGRAPHY_ATTRIBUTES, m_column=%str(GEO_HIER_SK), m_constraint=%str(index));
 
 
 
* Check for errors while processing CHANGE_ID: DROP_IDX_GEO_HIER_SK;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: DROP_IDX_GEO_HIER_SK;
%put ERROR- Description                              : Drop index GEO_HIER_SK since it is first column of the primary key.;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 03OCT2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: DROP_IDX_GEO_HIER_SK;
proc sql;
insert  into di_data.data_model_change_management
values (
"DROP_IDX_GEO_HIER_SK",
"Drop index GEO_HIER_SK since it is first column of the primary key.",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%DROP_IDX_GEO_HIER_SK:;
 
 
* End of changes for CHANGE_ID:DROP_IDX_GEO_HIER_SK;
 
 
***********************************************************************************************;
*************************************  End Change DROP_IDX_GEO_HIER_SK ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID802112 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID802112;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID802112")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(&m_di_mon)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_di_mon;
%put NOTE- Change ID                             :ID802112;
%goto ID802112;
 
%end;
%if not (%sysfunc(exist(&m_di_mon..etl_sys_param))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_mon..etl_sys_param;
%put NOTE- Change ID                             :ID802112;
%goto ID802112;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID802112;
%goto ID802112;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID802112;
* Insert record into change management table for CHANGE_ID: ID802112;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID802112",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID802112;
 
%end;
 
 
 
 
 
proc sql;
delete
from &m_di_mon..etl_sys_param
where jobname = 'LOAD_STG2DM_MDO_IMPORT_PLAN'
and param_name eq 'etlp_exception_table2';
 
update &m_di_mon..etl_sys_param
set param_name = 'etlp_exception_table1'
where jobname = 'LOAD_STG2DM_MDO_IMPORT_PLAN'
and param_name eq 'etlp_exception_table';
 
insert into &m_di_mon..etl_sys_param (jobname, param_name, param_value, default_func)
values ('LOAD_STG2DM_MDO_IMPORT_PLAN',
'etlp_exception_table2',
'DI_MON.STG_MDO_IMPORT_PLAN_MEMBER_X',
'"DI_MON.STG_MDO_IMPORT_PLAN_MEMBER_X"');
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID802112;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID802112;
%put ERROR- Description                              : Add multiple etlp_exception_table parameters to etl_sys_param as array;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 03OCT2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID802112;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID802112",
"Add multiple etlp_exception_table parameters to etl_sys_param as array",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID802112:;
 
 
* End of changes for CHANGE_ID:ID802112;
 
 
***********************************************************************************************;
*************************************  End Change ID802112 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID802430 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID802430;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID802430")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID802430;
%goto ID802430;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID802430;
* Insert record into change management table for CHANGE_ID: ID802430;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID802430",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID802430;
 
%end;
 
 
 
 
 
proc sql;
delete
from &m_di_data..reference_values
where field_nm = 'SETTING_TYPE'
and field_value in ('53','54','55');
 
insert
into &m_di_data..reference_values
(
field_nm,
field_value,
field_short_desc
)
values ('SETTING_TYPE','53','ALLOW_MARKDN_DURING_PROMO_CD')
values ('SETTING_TYPE','54','FORCE_MARKDN_PRICE_POINT_VALUE')
values ('SETTING_TYPE','55','LOW_DEMAND_DISCOUNT_PRICE_POINT_VALUE');
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID802430;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID802430;
%put ERROR- Description                              : Add description about setting_type 53 - 55 (MDO) to Reference values;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 18OCT2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID802430;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID802430",
"Add description about setting_type 53 - 55 (MDO) to Reference values",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID802430:;
 
 
* End of changes for CHANGE_ID:ID802430;
 
 
***********************************************************************************************;
*************************************  End Change ID802430 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID801481 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID801481;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID801481")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(&m_di_mon)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_di_mon;
%put NOTE- Change ID                             :ID801481;
%goto ID801481;
 
%end;
%if not (%sysfunc(exist(&m_di_mon..JOB_PARAM))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_mon..JOB_PARAM;
%put NOTE- Change ID                             :ID801481;
%goto ID801481;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID801481;
%goto ID801481;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID801481;
* Insert record into change management table for CHANGE_ID: ID801481;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID801481",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID801481;
 
%end;
 
 
 
 
 
proc sql noprint;
delete from &m_di_mon..JOB_PARAM
where jobname = "LOAD_STG2DM_PROMOTION_FACT"
and
param_name = "etlp_condtn_promo_veh_ctgrs";
 
insert into &m_di_mon..JOB_PARAM
(jobname, param_name, param_value, default_func)
values("LOAD_STG2DM_PROMOTION_FACT", "etlp_condtn_promo_veh_ctgrs", "1,2,3", '"1,2,3"');
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID801481;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID801481;
%put ERROR- Description                              : Adding parameter to check valid vehicle_category_sk for conditional promotions;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 20OCT2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID801481;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID801481",
"Adding parameter to check valid vehicle_category_sk for conditional promotions",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID801481:;
 
 
* End of changes for CHANGE_ID:ID801481;
 
 
***********************************************************************************************;
*************************************  End Change ID801481 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID806199 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID806199;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID806199")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID806199;
%goto ID806199;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID806199;
* Insert record into change management table for CHANGE_ID: ID806199;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID806199",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID806199;
 
%end;
 
 
 
 
 
 
proc sql;
 
DELETE FROM &m_di_data..GLOBAL_SETTING
WHERE SPEC_NM ='BULK_HANDLE_COST' and APP = 'SZPK';
 
INSERT INTO &m_di_data..GLOBAL_SETTING (SPEC_NM,APP,SPEC_VALUE,SPEC_DESC) VALUES
('BULK_HANDLE_COST','SZPK','1.00',
'Specifies the default handling cost for bulk packs.');
 
DELETE FROM &m_di_data..GLOBAL_SETTING
WHERE SPEC_NM ='BULK_OPEN_COST' and APP = 'SZPK';
 
INSERT INTO &m_di_data..GLOBAL_SETTING (SPEC_NM,APP,SPEC_VALUE,SPEC_DESC) VALUES
('BULK_OPEN_COST','SZPK','0.00',
'Specifies the default opening cost for bulk packs.');
 
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID806199;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID806199;
%put ERROR- Description                              : New global settings BULK_HANDLE_COST and BULD_OPEN_COST;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 31OCT2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID806199;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID806199",
"New global settings BULK_HANDLE_COST and BULD_OPEN_COST",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID806199:;
 
 
* End of changes for CHANGE_ID:ID806199;
 
 
***********************************************************************************************;
*************************************  End Change ID806199 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID799889 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID799889;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID799889")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID799889;
%goto ID799889;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID799889;
* Insert record into change management table for CHANGE_ID: ID799889;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID799889",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID799889;
 
%end;
 
 
 
 
 
 
proc sql;
alter table &m_di_data..DATA_LVL modify DATA_LVL_NM char(255);
alter table &m_di_data..DATA_LVL modify DATA_LVL_DESC char(500);
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID799889;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID799889;
%put ERROR- Description                              : Length of DATA_LVL_NM should be enlarged to assort with customized analytical hierarchy;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 02NOV2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID799889;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID799889",
"Length of DATA_LVL_NM should be enlarged to assort with customized analytical hierarchy",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID799889:;
 
 
* End of changes for CHANGE_ID:ID799889;
 
 
***********************************************************************************************;
*************************************  End Change ID799889 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change LENGTH_TO_5 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: LENGTH_TO_5;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("LENGTH_TO_5")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : LENGTH_TO_5;
%goto LENGTH_TO_5;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : LENGTH_TO_5;
* Insert record into change management table for CHANGE_ID: LENGTH_TO_5;
proc sql;
insert  into di_data.data_model_change_management
values (
"LENGTH_TO_5",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto LENGTH_TO_5;
 
%end;
 
 
 
 
 
proc sql;
alter table &m_di_data..PRICING_RULES_COLUMN_META modify COL_TYPE char(5);
alter table &m_di_data..PRICING_RULES_COLUMN_META modify EXPORT_COL_TYPE char(5);
quit;
 
 
 
* Check for errors while processing CHANGE_ID: LENGTH_TO_5;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: LENGTH_TO_5;
%put ERROR- Description                              : Length of COL_TYPE and EXPORT_COL_TYPE in PRICING_RULES_COLUMN_META should be 5;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 02NOV2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: LENGTH_TO_5;
proc sql;
insert  into di_data.data_model_change_management
values (
"LENGTH_TO_5",
"Length of COL_TYPE and EXPORT_COL_TYPE in PRICING_RULES_COLUMN_META should be 5",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%LENGTH_TO_5:;
 
 
* End of changes for CHANGE_ID:LENGTH_TO_5;
 
 
***********************************************************************************************;
*************************************  End Change LENGTH_TO_5 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID810483 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID810483;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID810483")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID810483;
%goto ID810483;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID810483;
* Insert record into change management table for CHANGE_ID: ID810483;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID810483",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID810483;
 
%end;
 
 
 
 
 
 
proc sql;
DELETE FROM &m_di_data..GLOBAL_SETTING WHERE SPEC_NM ='MPLN_MTS_CONFIG';
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID810483;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID810483;
%put ERROR- Description                              : Remove global setting MPLN_MTS_CONFIG;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 14NOV2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID810483;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID810483",
"Remove global setting MPLN_MTS_CONFIG",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID810483:;
 
 
* End of changes for CHANGE_ID:ID810483;
 
 
***********************************************************************************************;
*************************************  End Change ID810483 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID805225 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID805225;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID805225")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID805225;
%goto ID805225;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID805225;
* Insert record into change management table for CHANGE_ID: ID805225;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID805225",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID805225;
 
%end;
 
 
 
 
 
 
proc sql;
 
DELETE FROM &m_di_data..GLOBAL_SETTING
WHERE SPEC_NM ='MAX_FIND_PRODUCT_DETAILS' and APP = 'ALL';
 
INSERT INTO &m_di_data..GLOBAL_SETTING (SPEC_NM,APP,SPEC_VALUE,SPEC_DESC) VALUES
('MAX_FIND_PRODUCT_DETAILS','ALL','6000',
'Specifies the maximum size of query results when searching for products by attribute in an Oracle RDBMS.');
 
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID805225;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID805225;
%put ERROR- Description                              : New global settings MAX_FIND_PRODUCT_DETAILS;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 14NOV2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID805225;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID805225",
"New global settings MAX_FIND_PRODUCT_DETAILS",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID805225:;
 
 
* End of changes for CHANGE_ID:ID805225;
 
 
***********************************************************************************************;
*************************************  End Change ID805225 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID811022 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID811022;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID811022")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID811022;
%goto ID811022;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID811022;
* Insert record into change management table for CHANGE_ID: ID811022;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID811022",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID811022;
 
%end;
 
 
 
 
 
 
proc sql;
 
DELETE FROM &m_di_data..GLOBAL_SETTING
WHERE SPEC_NM ='ACTIVE_PROD_STATUS_EST' and APP = 'ALL';
 
INSERT INTO &m_di_data..GLOBAL_SETTING (SPEC_NM,APP,SPEC_VALUE,SPEC_DESC) VALUES
('ACTIVE_PROD_STATUS_EST','ALL','1,3,5,6,7,8',
'Specifies a list of status values that indicate an active product (SKU) for estimation process.');
 
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID811022;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID811022;
%put ERROR- Description                              : Add global setting ACTIVE_PROD_STATUS_EST;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 15NOV2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID811022;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID811022",
"Add global setting ACTIVE_PROD_STATUS_EST",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID811022:;
 
 
* End of changes for CHANGE_ID:ID811022;
 
 
***********************************************************************************************;
*************************************  End Change ID811022 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID816268 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID816268;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID816268")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(&m_didm_stg)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_didm_stg;
%put NOTE- Change ID                             :ID816268;
%goto ID816268;
 
%end;
%if not (%sysfunc(exist(&m_didm_stg..STG_PACK_TYPE))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_didm_stg..STG_PACK_TYPE;
%put NOTE- Change ID                             :ID816268;
%goto ID816268;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID816268;
%goto ID816268;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID816268;
* Insert record into change management table for CHANGE_ID: ID816268;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID816268",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID816268;
 
%end;
 
 
 
 
 
proc sql;
alter table &m_didm_stg..STG_PACK_TYPE add NOT NULL (PACK_TYPE_NM);
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID816268;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID816268;
%put ERROR- Description                              : Adding NOT NULL constraint to PACK_TYPE_NM of STG_PACK_TYPE table;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 06DEC2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID816268;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID816268",
"Adding NOT NULL constraint to PACK_TYPE_NM of STG_PACK_TYPE table",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID816268:;
 
 
* End of changes for CHANGE_ID:ID816268;
 
 
***********************************************************************************************;
*************************************  End Change ID816268 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID814313 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID814313;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID814313")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(&m_di_mon)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_di_mon;
%put NOTE- Change ID                             :ID814313;
%goto ID814313;
 
%end;
%if not (%sysfunc(exist(&m_di_mon..JOB_PARAM))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_mon..JOB_PARAM;
%put NOTE- Change ID                             :ID814313;
%goto ID814313;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID814313;
%goto ID814313;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52, M2MI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID814313;
* Insert record into change management table for CHANGE_ID: ID814313;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID814313",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID814313;
 
%end;
 
 
 
 
 
proc sql;
 
delete from &m_di_mon..job_param where upcase(jobname) = 'DI_ETL_GEO_PROD_PURGE_JOB'
and lowcase(param_name) = 'etlp_parallel_execution';
 
delete from &m_di_mon..job_param where upcase(jobname) = 'DI_ETL_GEO_PROD_PURGE_JOB'
and lowcase(param_name) = 'etlp_threshold_value';
 
Insert into &m_di_mon..job_param
(jobname, param_name, param_value, default_func)
values("DI_ETL_GEO_PROD_PURGE_JOB", "etlp_parallel_execution",  "1",  '"1"')
values("DI_ETL_GEO_PROD_PURGE_JOB", "etlp_threshold_value",  "0",  '"0"');
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID814313;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID814313;
%put ERROR- Description                              : Adding parameters viz. etlp_parallel_execution and etlp_threshold_value to Job_Param;
%put ERROR- Version                                  : D3MICM52, M2MI42;
%put ERROR- Date of Change                           : 08DEC2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID814313;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID814313",
"Adding parameters viz. etlp_parallel_execution and etlp_threshold_value to Job_Param",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID814313:;
 
 
* End of changes for CHANGE_ID:ID814313;
 
 
***********************************************************************************************;
*************************************  End Change ID814313 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID810405 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID810405;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID810405")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(&m_didm_stg)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_didm_stg;
%put NOTE- Change ID                             :ID810405;
%goto ID810405;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID810405;
%goto ID810405;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52, M2MI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID810405;
* Insert record into change management table for CHANGE_ID: ID810405;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID810405",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID810405;
 
%end;
 
 
 
 
 
data &m_didm_stg..STG_RPP_PLAN_METRIC;
attrib  PLAN_ID length=$32;
attrib  KPI_SK length=4 ;
attrib  FCST_KPI_VALUE length=8 FORMAT=NLNUM20.3   INFORMAT=NLNUM20.3;
attrib  BASE_KPI_VALUE length=8 FORMAT=NLNUM20.3   INFORMAT=NLNUM20.3;
attrib  ACTUAL_KPI_VALUE length=8 FORMAT=NLNUM20.3   INFORMAT=NLNUM20.3;
STOP;
run;
 
proc sql;
alter table &m_didm_stg..STG_RPP_PLAN_METRIC add NOT NULL (PLAN_ID);
alter table &m_didm_stg..STG_RPP_PLAN_METRIC add NOT NULL (KPI_SK);
quit;
 
 
data &m_didm_stg..STG_RPP_PLAN_PROD_METRICS;
attrib  PLAN_ID length=$32;
attrib  PROD_ID length=$32;
attrib  KPI_SK length=4 ;
attrib  FCST_KPI_VALUE length=8  FORMAT=NLNUM20.3   INFORMAT=NLNUM20.3;
attrib  BASE_KPI_VALUE length=8  FORMAT=NLNUM20.3   INFORMAT=NLNUM20.3;
attrib  ACTUAL_KPI_VALUE length=8 FORMAT=NLNUM20.3   INFORMAT=NLNUM20.3;
STOP;
run;
 
proc sql;
alter table &m_didm_stg..STG_RPP_PLAN_PROD_METRICS add NOT NULL (PLAN_ID);
alter table &m_didm_stg..STG_RPP_PLAN_PROD_METRICS add NOT NULL (PROD_ID);
alter table &m_didm_stg..STG_RPP_PLAN_PROD_METRICS add NOT NULL (KPI_SK);
quit;
 
/***** MON tables *****/
 
data &m_di_mon..STG_RPP_PLAN_METRIC_X;
attrib  PLAN_ID length=$32;
attrib  KPI_SK length=4 ;
attrib  FCST_KPI_VALUE length=8 FORMAT=NLNUM20.3   INFORMAT=NLNUM20.3;
attrib  BASE_KPI_VALUE length=8 FORMAT=NLNUM20.3   INFORMAT=NLNUM20.3;
attrib  ACTUAL_KPI_VALUE length=8 FORMAT=NLNUM20.3   INFORMAT=NLNUM20.3;
attrib ETLS_EXCEPTION_COND length=$150 ;
attrib ETL_ERROR_JOBRUNTIME length=8 format = datetime16. ;
STOP;
run;
 
data &m_di_mon..STG_RPP_PLAN_PROD_METRICS_X;
attrib  PLAN_ID length=$32;
attrib  PROD_ID length=$32;
attrib  KPI_SK length=4 ;
attrib  FCST_KPI_VALUE length=8 FORMAT=NLNUM20.3   INFORMAT=NLNUM20.3;
attrib  BASE_KPI_VALUE length=8 FORMAT=NLNUM20.3   INFORMAT=NLNUM20.3;
attrib  ACTUAL_KPI_VALUE length=8 FORMAT=NLNUM20.3   INFORMAT=NLNUM20.3;
attrib ETLS_EXCEPTION_COND length=$150 ;
attrib ETL_ERROR_JOBRUNTIME length=8 format = datetime16. ;
STOP;
run;
 
 
proc sql noprint;
 
delete from &m_di_mon..job_param
where upcase(jobname) = 'LOAD_SRC2STG_RPP_PLAN_METRIC' and lowcase(param_name) = 'etlp_src_file';
 
delete from &m_di_mon..job_param
where upcase(jobname) = 'LOAD_SRC2STG_RPP_PLAN_PROD_METRICS' and lowcase(param_name) = 'etlp_src_file';
 
Insert into &m_di_mon..job_param
(jobname, param_name, param_value, default_func)
values("LOAD_SRC2STG_RPP_PLAN_METRIC","etlp_src_file","/data/stg_rpp_plan_metric.csv",'"Y"')
values("LOAD_SRC2STG_RPP_PLAN_PROD_METRICS","etlp_src_file","/data/stg_rpp_plan_prod_metrics.csv",'"Y"')
;
 
delete from &m_di_mon..job_param
where upcase(jobname) = 'LOAD_STG2DM_RPP_PLAN_METRIC' and lowcase(param_name) = 'etlp_custom_kpi_start_sk';
delete from &m_di_mon..job_param
where upcase(jobname) = 'LOAD_STG2DM_RPP_PLAN_PROD_METRICS' and lowcase(param_name) = 'etlp_custom_kpi_start_sk';
delete from &m_di_mon..job_param
where upcase(jobname) = 'LOAD_STG2DM_RPP_PLAN_PROD_ASGMNT' and lowcase(param_name) = 'etlp_custom_kpi_start_sk';
 
Insert into &m_di_mon..job_param
(jobname, param_name, param_value, default_func)
values ('LOAD_STG2DM_RPP_PLAN_METRIC','etlp_custom_kpi_start_sk','1000','"1000"')
values ('LOAD_STG2DM_RPP_PLAN_PROD_METRICS','etlp_custom_kpi_start_sk','1000','"1000"')
values ('LOAD_STG2DM_RPP_PLAN_PROD_ASGMNT','etlp_custom_kpi_start_sk','1000','"1000"')
;
 
delete from &m_di_mon..etl_sys_param
where upcase(jobname) = 'LOAD_STG2DM_RPP_PLAN_METRIC' and lowcase(param_name) = 'etlp_exception_table';
 
delete from &m_di_mon..etl_sys_param
where upcase(jobname) = 'LOAD_STG2DM_RPP_PLAN_PROD_METRICS' and lowcase(param_name) = 'etlp_exception_table';
 
Insert into &m_di_mon..etl_sys_param
(jobname, param_name, param_value, default_func)
values("LOAD_STG2DM_RPP_PLAN_METRIC", "etlp_exception_table",  "DI_MON.STG_RPP_PLAN_METRIC_X",  '"DI_MON.STG_RPP_PLAN_METRIC_X"')
values("LOAD_STG2DM_RPP_PLAN_PROD_METRICS", "etlp_exception_table",  "DI_MON.STG_RPP_PLAN_PROD_METRICS_X",  '"DI_MON.STG_RPP_PLAN_PROD_METRICS_X"')
;
 
 
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID810405;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID810405;
%put ERROR- Description                              : New stage and mon tables for Rpp_plan_metrics and Rpp_plan_prod_metrics;
%put ERROR- Version                                  : D3MICM52, M2MI42;
%put ERROR- Date of Change                           : 08DEC2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID810405;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID810405",
"New stage and mon tables for Rpp_plan_metrics and Rpp_plan_prod_metrics",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID810405:;
 
 
* End of changes for CHANGE_ID:ID810405;
 
 
***********************************************************************************************;
*************************************  End Change ID810405 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID815119 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID815119;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID815119")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(&m_di_mon)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_di_mon;
%put NOTE- Change ID                             :ID815119;
%goto ID815119;
 
%end;
%if not (%sysfunc(exist(&m_di_mon..job_param))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_mon..job_param;
%put NOTE- Change ID                             :ID815119;
%goto ID815119;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID815119;
%goto ID815119;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID815119;
* Insert record into change management table for CHANGE_ID: ID815119;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID815119",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID815119;
 
%end;
 
 
 
 
 
proc sql;
delete from &m_di_mon..JOB_PARAM
where UPCASE(jobname) in ("LOAD_STG2DM_INVENTORY_FACT", "LOAD_STG2DM_SALES_FACT")
and UPCASE(param_name) ="ETLP_RESTARTOPT";
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID815119;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID815119;
%put ERROR- Description                              : Removing etlp_restartopt parameter from JOB_PARAM table;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 09DEC2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID815119;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID815119",
"Removing etlp_restartopt parameter from JOB_PARAM table",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID815119:;
 
 
* End of changes for CHANGE_ID:ID815119;
 
 
***********************************************************************************************;
*************************************  End Change ID815119 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID819669 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID819669;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID819669")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(&m_didm_stg)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_didm_stg;
%put NOTE- Change ID                             :ID819669;
%goto ID819669;
 
%end;
%if not (%sysfunc(exist(&m_didm_stg..stg_mdo_import_plan))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_didm_stg..stg_mdo_import_plan;
%put NOTE- Change ID                             :ID819669;
%goto ID819669;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID819669;
%goto ID819669;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID819669;
* Insert record into change management table for CHANGE_ID: ID819669;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID819669",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID819669;
 
%end;
 
 
 
 
 
proc sql;
alter table &m_didm_stg..stg_mdo_import_plan modify PRICE_VALUE_LIST CHAR(4000);
alter table &m_didm_stg..stg_mdo_import_plan modify PRICE_ENDING_LIST CHAR(4000);
quit;
 
proc sql;
alter table &m_di_mon..stg_mdo_import_plan_x modify PRICE_VALUE_LIST CHAR(4000);
alter table &m_di_mon..stg_mdo_import_plan_x modify PRICE_ENDING_LIST CHAR(4000);
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID819669;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID819669;
%put ERROR- Description                              : Increase PRICE_VALUE_LIST and PRICE_ENDING_LIST to char(4000) in Stage and mon MDO;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 19DEC2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID819669;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID819669",
"Increase PRICE_VALUE_LIST and PRICE_ENDING_LIST to char(4000) in Stage and mon MDO",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID819669:;
 
 
* End of changes for CHANGE_ID:ID819669;
 
 
***********************************************************************************************;
*************************************  End Change ID819669 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID823398 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID823398;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID823398")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(&m_didm_stg.)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_didm_stg.;
%put NOTE- Change ID                             :ID823398;
%goto ID823398;
 
%end;
%if not (%sysfunc(exist(&m_didm_stg..stg_std_size))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_didm_stg..stg_std_size;
%put NOTE- Change ID                             :ID823398;
%goto ID823398;
 
%end;
%if not (%sysfunc(exist(&m_didm_stg..stg_pack_prod))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_didm_stg..stg_pack_prod;
%put NOTE- Change ID                             :ID823398;
%goto ID823398;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID823398;
%goto ID823398;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID823398;
* Insert record into change management table for CHANGE_ID: ID823398;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID823398",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID823398;
 
%end;
 
 
 
 
 
 
%di_util_drop_constraint(m_lib=&m_didm_stg., m_table=STG_STD_SIZE, m_column=%str(DISPLAY_ORDER), m_constraint=%str(not null));
%di_util_drop_constraint(m_lib=&m_didm_stg., m_table=STG_PACK_PROD, m_column=%str(NUMBER_OF_UNITS), m_constraint=%str(not null));
 
proc sql;
alter table &m_didm_stg..STG_STD_SIZE   add NOT NULL (DISPLAY_ORDER);
alter table &m_didm_stg..STG_PACK_PROD  add NOT NULL (NUMBER_OF_UNITS);
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID823398;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID823398;
%put ERROR- Description                              : Add NOT NULL constraint for DISPLAY_ORDER and NUMBER_OF_UNITS;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 06JAN2012;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID823398;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID823398",
"Add NOT NULL constraint for DISPLAY_ORDER and NUMBER_OF_UNITS",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID823398:;
 
 
* End of changes for CHANGE_ID:ID823398;
 
 
***********************************************************************************************;
*************************************  End Change ID823398 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change DROP_PROMOTION_FACT_FUTURE ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: DROP_PROMOTION_FACT_FUTURE;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("DROP_PROMOTION_FACT_FUTURE")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : DROP_PROMOTION_FACT_FUTURE;
%goto DROP_PROMOTION_FACT_FUTURE;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : DROP_PROMOTION_FACT_FUTURE;
* Insert record into change management table for CHANGE_ID: DROP_PROMOTION_FACT_FUTURE;
proc sql;
insert  into di_data.data_model_change_management
values (
"DROP_PROMOTION_FACT_FUTURE",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto DROP_PROMOTION_FACT_FUTURE;
 
%end;
 
 
 
 
 
 
 
proc sql noprint;
drop table &m_di_data..PROMOTION_FACT_FUTURE ;
quit;
 
 
%let m_subdir=PROMOTION_FACT_FUTURE;
%let m_partlib=ZPFF_LIB;
 
%let parentdir=%di_util_first_libpath(&m_di_data);
 
 
 
%di_etl_set_lib (parent_lib=&m_di_data., sub_folder=&m_subdir.,partition_lib=&m_partlib. );
 
%local all_tabs num_tabs tab_name i;
 
proc sql noprint;
select memname into :all_tabs
separated by " "
from dictionary.tables
where libname = "&m_partlib";
quit;
 
proc sql noprint;
select count(*) into :num_tabs
from dictionary.tables
where libname = "&m_partlib";
quit;
 
%put &m_subdir. (&num_tabs): &all_tabs;
 
%if &num_tabs gt 0 %then
%do;
 
%do i=1 %to &num_tabs;
 
%let tab_name = %scan(&all_tabs, &i);
 
 
proc sql noprint;
drop table &m_partlib..&tab_name;
quit;
 
 
%end;
 
%end;
 
%let _removeDirectory = %sysfunc(pathname(&m_partlib.));
libname &m_partlib clear;
 
x "rmdir &_removeDirectory";
 
 
 
* Check for errors while processing CHANGE_ID: DROP_PROMOTION_FACT_FUTURE;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: DROP_PROMOTION_FACT_FUTURE;
%put ERROR- Description                              : Drop PROMOTION_FACT_FUTURE as it is no longer needed;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 09JAN2012;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: DROP_PROMOTION_FACT_FUTURE;
proc sql;
insert  into di_data.data_model_change_management
values (
"DROP_PROMOTION_FACT_FUTURE",
"Drop PROMOTION_FACT_FUTURE as it is no longer needed",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%DROP_PROMOTION_FACT_FUTURE:;
 
 
* End of changes for CHANGE_ID:DROP_PROMOTION_FACT_FUTURE;
 
 
***********************************************************************************************;
*************************************  End Change DROP_PROMOTION_FACT_FUTURE ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID824127 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID824127;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID824127")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_data..GLOBAL_SETTING))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_data..GLOBAL_SETTING;
%put NOTE- Change ID                             :ID824127;
%goto ID824127;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID824127;
%goto ID824127;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID824127;
* Insert record into change management table for CHANGE_ID: ID824127;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID824127",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID824127;
 
%end;
 
 
 
 
 
 
proc sql;
DELETE from &m_di_data..GLOBAL_SETTING where SPEC_NM = 'CAL_PRICE_ELAS_IDX_PERF';
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID824127;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID824127;
%put ERROR- Description                              : Remove global setting CAL_PRICE_ELAS_IDX_PERF;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 10JAN2012;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID824127;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID824127",
"Remove global setting CAL_PRICE_ELAS_IDX_PERF",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID824127:;
 
 
* End of changes for CHANGE_ID:ID824127;
 
 
***********************************************************************************************;
*************************************  End Change ID824127 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID824171 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID824171;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID824171")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_data..GLOBAL_SETTING))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_data..GLOBAL_SETTING;
%put NOTE- Change ID                             :ID824171;
%goto ID824171;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID824171;
%goto ID824171;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID824171;
* Insert record into change management table for CHANGE_ID: ID824171;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID824171",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID824171;
 
%end;
 
 
 
 
 
 
proc sql;
DELETE from &m_di_data..GLOBAL_SETTING where SPEC_NM = 'DEMAND_DISAGG_DEF_PROD_LVL';
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID824171;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID824171;
%put ERROR- Description                              : Remove global setting DEMAND_DISAGG_DEF_PROD_LVL;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 10JAN2012;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID824171;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID824171",
"Remove global setting DEMAND_DISAGG_DEF_PROD_LVL",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID824171:;
 
 
* End of changes for CHANGE_ID:ID824171;
 
 
***********************************************************************************************;
*************************************  End Change ID824171 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID813171 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID813171;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID813171")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID813171;
%goto ID813171;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID813171;
* Insert record into change management table for CHANGE_ID: ID813171;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID813171",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID813171;
 
%end;
 
 
 
 
 
 
proc sql;
delete from &m_di_data..job where job_id in (38);
insert into &m_di_data..job(job_id,job_nm,parent_job_id) values (38,'benefits_track_highlvl_agg',-1);
quit;
 
proc sort data=&m_di_data..job force;
by job_id;
run;
 
 
 
* Check for errors while processing CHANGE_ID: ID813171;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID813171;
%put ERROR- Description                              : Add benefits_track_highlvl_agg job to tkmi_job_ro (RPO);
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 12JAN2012;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID813171;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID813171",
"Add benefits_track_highlvl_agg job to tkmi_job_ro (RPO)",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID813171:;
 
 
* End of changes for CHANGE_ID:ID813171;
 
 
***********************************************************************************************;
*************************************  End Change ID813171 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID0826411 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID0826411;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID0826411")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID0826411;
%goto ID0826411;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID0826411;
* Insert record into change management table for CHANGE_ID: ID0826411;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID0826411",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID0826411;
 
%end;
 
 
 
 
 
 
proc sql noprint;
drop table &m_di_data..GEO_STORE;
drop table &m_didm_stg..STG_GEO_STORE;
drop table &m_di_mon..STG_GEO_STORE_X;
 
delete from &m_di_mon..etl_sys_param where upcase(jobname)="LOAD_STG2DM_GEO_STORE";
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID0826411;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID0826411;
%put ERROR- Description                              : Drop STG_GEO_STORE, GEO_STORE, STG_GEO_STORE_X Tables;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 18JAN2012;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID0826411;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID0826411",
"Drop STG_GEO_STORE, GEO_STORE, STG_GEO_STORE_X Tables",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID0826411:;
 
 
* End of changes for CHANGE_ID:ID0826411;
 
 
***********************************************************************************************;
*************************************  End Change ID0826411 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID828113 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID828113;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID828113")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID828113;
%goto ID828113;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID828113;
* Insert record into change management table for CHANGE_ID: ID828113;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID828113",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID828113;
 
%end;
 
 
 
 
 
proc sql;
 
DELETE FROM &m_di_data..field_lookup_values where (table_name='ALL' and field_nm='OBJECT_TYPE' and field_value='16');
INSERT INTO &m_di_data..field_lookup_values (table_name,field_nm,field_value,field_value_nm,field_value_desc,field_datatype)
VALUES ('ALL','OBJECT_TYPE','16','PlanProdAssignment', 'PlanProdAssignment', 'INTEGER');
 
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID828113;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID828113;
%put ERROR- Description                              : Adding entry for Field lookup value for OBJECT TYPE 16;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 25JAN2012;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID828113;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID828113",
"Adding entry for Field lookup value for OBJECT TYPE 16",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID828113:;
 
 
* End of changes for CHANGE_ID:ID828113;
 
 
***********************************************************************************************;
*************************************  End Change ID828113 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID831366 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID831366;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID831366")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID831366;
%goto ID831366;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID831366;
* Insert record into change management table for CHANGE_ID: ID831366;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID831366",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID831366;
 
%end;
 
 
 
 
 
proc sql;
delete from &m_di_mon..JOB_PARAM
where UPCASE(jobname) = "LOAD_STG2DM_PRF_GEO_PROD_STATUS"
and UPCASE(param_name) ="ETLP_SRC_REF_DT";
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID831366;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID831366;
%put ERROR- Description                              : Removing etlp_src_ref_dt for PRF_GEO_PROD_STATUS from Job_param table;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 06FEB2012;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID831366;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID831366",
"Removing etlp_src_ref_dt for PRF_GEO_PROD_STATUS from Job_param table",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID831366:;
 
 
* End of changes for CHANGE_ID:ID831366;
 
 
***********************************************************************************************;
*************************************  End Change ID831366 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID811022_1 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID811022_1;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID811022_1")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_data..GLOBAL_SETTING))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_data..GLOBAL_SETTING;
%put NOTE- Change ID                             :ID811022_1;
%goto ID811022_1;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID811022_1;
%goto ID811022_1;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID811022_1;
* Insert record into change management table for CHANGE_ID: ID811022_1;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID811022_1",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID811022_1;
 
%end;
 
 
 
 
 
 
proc sql;
DELETE from &m_di_data..GLOBAL_SETTING where SPEC_NM = 'ACTIVE_PROD_STATUS_EST';
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID811022_1;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID811022_1;
%put ERROR- Description                              : Remove global setting ACTIVE_PROD_STATUS_EST;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 13FEB2012;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID811022_1;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID811022_1",
"Remove global setting ACTIVE_PROD_STATUS_EST",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID811022_1:;
 
 
* End of changes for CHANGE_ID:ID811022_1;
 
 
***********************************************************************************************;
*************************************  End Change ID811022_1 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change P_SUBSET ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: P_SUBSET;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("P_SUBSET")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : P_SUBSET;
%goto P_SUBSET;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D2TKMI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : P_SUBSET;
* Insert record into change management table for CHANGE_ID: P_SUBSET;
proc sql;
insert  into di_data.data_model_change_management
values (
"P_SUBSET",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto P_SUBSET;
 
%end;
 
 
 
 
 
%let parentdir=%di_util_first_libpath(&m_di_data);
 
 
%let moveToSubdir=archive;
%let _dir = %sysfunc(dcreate(&moveToSubdir,&parentdir));
 
%if "&sysscp"="WIN" %then
%do;
%let m_sepchar=\;
%let m_movecmd=move;
%let m_copycmd=copy;
options noxwait;
%end;
 
%else
%do;
%let m_sepchar=/;
%let m_movecmd=mv;
%let m_copycmd=cp;
%end;
 
%if %sysfunc(fileexist(%quote(&parentdir&m_sepchar.&moveToSubdir))) %then
%do;
X "&m_movecmd &parentdir&m_sepchar.inventory_fact_?????.* &parentdir&m_sepchar.&moveToSubdir&m_sepchar." ;
X "&m_movecmd &parentdir&m_sepchar.sales_fact_?????.* &parentdir&m_sepchar.&moveToSubdir&m_sepchar." ;
 
 
/* Truncate these two tables - Instead of truncating move and copy the structure */
libname tmp9876 "&parentdir&m_sepchar.&moveToSubdir&m_sepchar.";
 
%if %di_util_nobs(&m_di_data..price_fact_history) > 0 %then %do;
X "&m_movecmd &parentdir&m_sepchar.price_fact_history.* &parentdir&m_sepchar.&moveToSubdir&m_sepchar." ;
%DI_UTIL_CREATE_LIKE_TABLE( orig_table=tmp9876.price_fact_history, new_table=&m_di_data..price_fact_history  ) ;
%end;
 
%if %di_util_nobs(&m_di_data..cost_fact_history) > 0 %then %do;
X "&m_movecmd &parentdir&m_sepchar.cost_fact_history.* &parentdir&m_sepchar.&moveToSubdir&m_sepchar." ;
%DI_UTIL_CREATE_LIKE_TABLE( orig_table=tmp9876.cost_fact_history, new_table=&m_di_data..cost_fact_history  ) ;
%end;
 
libname tmp9876 clear;
 
%end;
%else %do;
%put WARNING: Directory "&parentdir&m_sepchar.&moveToSubdir" does not exist. Partitioned data not moved;
%end;
 
/* Get Current Date SK - Reduce by 1 and copy inventory file corresponding to that */
%let m_last_week=0;
proc sql noprint;
select spec_value
into :m_last_week
from &m_di_data..global_setting
where spec_nm="CURRENT_DATE_SK"
and app="ALL"
;
quit;
 
%let m_last_week=%trim(%eval(&m_last_week-1));
 
/* Keep a copy of last week inventory */
%if %sysfunc(fileexist(%quote(&parentdir&m_sepchar.&moveToSubdir))) %then
%do;
X "&m_copycmd &parentdir&m_sepchar.&moveToSubdir&m_sepchar.inventory_fact_&m_last_week..* &parentdir&m_sepchar.";
%end;
 
 
 
 
 
 
* Check for errors while processing CHANGE_ID: P_SUBSET;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: P_SUBSET;
%put ERROR- Description                              : Move datasets partitioned to archive subfolder 1 of 2;
%put ERROR- Version                                  : D2TKMI42;
%put ERROR- Date of Change                           : 14FEB2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: P_SUBSET;
proc sql;
insert  into di_data.data_model_change_management
values (
"P_SUBSET",
"Move datasets partitioned to archive subfolder 1 of 2",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%P_SUBSET:;
 
 
* End of changes for CHANGE_ID:P_SUBSET;
 
 
***********************************************************************************************;
*************************************  End Change P_SUBSET ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change MOVE_SUBSET_DATASETS2 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: MOVE_SUBSET_DATASETS2;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("MOVE_SUBSET_DATASETS2")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : MOVE_SUBSET_DATASETS2;
%goto MOVE_SUBSET_DATASETS2;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : MOVE_SUBSET_DATASETS2;
* Insert record into change management table for CHANGE_ID: MOVE_SUBSET_DATASETS2;
proc sql;
insert  into di_data.data_model_change_management
values (
"MOVE_SUBSET_DATASETS2",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto MOVE_SUBSET_DATASETS2;
 
%end;
 
 
 
 
 
%let parentdir=%di_util_first_libpath(&m_di_data);
%let moveToSubdir=archive;
%let _dir = %sysfunc(dcreate(&moveToSubdir,&parentdir));
 
%if "&sysscp"="WIN" %then %do;
%let m_sepchar=\;
%let m_movecmd=move;
%let m_copycmd=copy;
options noxwait;
%end;
 
%else %do;
%let m_sepchar=/;
%let m_movecmd=mv;
%let m_copycmd=cp;
%end;
 
%if %sysfunc(fileexist(%quote(&parentdir&m_sepchar.&moveToSubdir))) %then
%do;
 
libname tmp9876 "&parentdir&m_sepchar.&moveToSubdir&m_sepchar.";
 
%if %di_util_nobs(&m_di_data..cost_fact_current) > 0 %then %do;
X "&m_movecmd &parentdir&m_sepchar.cost_fact_current.* &parentdir&m_sepchar.&moveToSubdir&m_sepchar." ;
%DI_UTIL_CREATE_LIKE_TABLE( orig_table=tmp9876.cost_fact_current, new_table=&m_di_data..cost_fact_current  ) ;
%end;
 
 
%if %di_util_nobs(&m_di_data..cost_fact_future) > 0 %then %do;
X "&m_movecmd &parentdir&m_sepchar.cost_fact_future.* &parentdir&m_sepchar.&moveToSubdir&m_sepchar." ;
%DI_UTIL_CREATE_LIKE_TABLE( orig_table=tmp9876.cost_fact_future, new_table=&m_di_data..cost_fact_future  ) ;
%end;
 
%if %di_util_nobs(&m_di_data..dow_event_sales_fact) > 0 %then %do;
X "&m_movecmd &parentdir&m_sepchar.dow_event_sales_fact.* &parentdir&m_sepchar.&moveToSubdir&m_sepchar." ;
%DI_UTIL_CREATE_LIKE_TABLE( orig_table=tmp9876.dow_event_sales_fact, new_table=&m_di_data..dow_event_sales_fact  ) ;
%end;
 
 
%if %di_util_nobs(&m_di_data..dow_sales_fact) > 0 %then %do;
X "&m_movecmd &parentdir&m_sepchar.dow_sales_fact.* &parentdir&m_sepchar.&moveToSubdir&m_sepchar." ;
%DI_UTIL_CREATE_LIKE_TABLE( orig_table=tmp9876.dow_sales_fact, new_table=&m_di_data..dow_sales_fact  ) ;
%end;
 
%if %di_util_nobs(&m_di_data..future_receipt) > 0 %then %do;
X "&m_movecmd &parentdir&m_sepchar.future_receipt.* &parentdir&m_sepchar.&moveToSubdir&m_sepchar." ;
%DI_UTIL_CREATE_LIKE_TABLE( orig_table=tmp9876.future_receipt, new_table=&m_di_data..future_receipt  ) ;
%end;
 
%if %di_util_nobs(&m_di_data..geo_prod) > 0 %then %do;
X "&m_movecmd &parentdir&m_sepchar.geo_prod.* &parentdir&m_sepchar.&moveToSubdir&m_sepchar." ;
%DI_UTIL_CREATE_LIKE_TABLE( orig_table=tmp9876.geo_prod, new_table=&m_di_data..geo_prod  ) ;
%end;
 
%if %di_util_nobs(&m_di_data..geo_prod_owned_inv) > 0 %then %do;
X "&m_movecmd &parentdir&m_sepchar.geo_prod_owned_inv.* &parentdir&m_sepchar.&moveToSubdir&m_sepchar." ;
%DI_UTIL_CREATE_LIKE_TABLE( orig_table=tmp9876.geo_prod_owned_inv, new_table=&m_di_data..geo_prod_owned_inv  ) ;
%end;
 
%if %di_util_nobs(&m_di_data..geo_prod_status) > 0 %then %do;
X "&m_movecmd &parentdir&m_sepchar.geo_prod_status.* &parentdir&m_sepchar.&moveToSubdir&m_sepchar." ;
%DI_UTIL_CREATE_LIKE_TABLE( orig_table=tmp9876.geo_prod_status, new_table=&m_di_data..geo_prod_status  ) ;
%end;
 
%if %di_util_nobs(&m_di_data..price_fact_current) > 0 %then %do;
X "&m_movecmd &parentdir&m_sepchar.price_fact_current.* &parentdir&m_sepchar.&moveToSubdir&m_sepchar." ;
%DI_UTIL_CREATE_LIKE_TABLE( orig_table=tmp9876.price_fact_current, new_table=&m_di_data..price_fact_current  ) ;
%end;
 
%if %di_util_nobs(&m_di_data..price_fact_future) > 0 %then %do;
X "&m_movecmd &parentdir&m_sepchar.price_fact_future.* &parentdir&m_sepchar.&moveToSubdir&m_sepchar." ;
%DI_UTIL_CREATE_LIKE_TABLE( orig_table=tmp9876.price_fact_future, new_table=&m_di_data..price_fact_future  ) ;
%end;
 
%if %di_util_nobs(&m_di_data..promotion_fact) > 0 %then %do;
X "&m_movecmd &parentdir&m_sepchar.promotion_fact.* &parentdir&m_sepchar.&moveToSubdir&m_sepchar." ;
%DI_UTIL_CREATE_LIKE_TABLE( orig_table=tmp9876.promotion_fact, new_table=&m_di_data..promotion_fact  ) ;
%end;
 
%if %di_util_nobs(&m_di_data..return_fact) > 0 %then %do;
X "&m_movecmd &parentdir&m_sepchar.return_fact.* &parentdir&m_sepchar.&moveToSubdir&m_sepchar." ;
%DI_UTIL_CREATE_LIKE_TABLE( orig_table=tmp9876.return_fact, new_table=&m_di_data..return_fact  ) ;
%end;
 
libname tmp9876 clear;
%end;
%else
%do;
%put WARNING: Directory "&parentdir&m_sepchar.&moveToSubdir" does not exist. Partitioned data not moved;
%end;
 
 
 
 
 
 
 
* Check for errors while processing CHANGE_ID: MOVE_SUBSET_DATASETS2;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: MOVE_SUBSET_DATASETS2;
%put ERROR- Description                              : Move datasets partitioned to archive subfolder 2 of 2;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 14FEB2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: MOVE_SUBSET_DATASETS2;
proc sql;
insert  into di_data.data_model_change_management
values (
"MOVE_SUBSET_DATASETS2",
"Move datasets partitioned to archive subfolder 2 of 2",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%MOVE_SUBSET_DATASETS2:;
 
 
* End of changes for CHANGE_ID:MOVE_SUBSET_DATASETS2;
 
 
***********************************************************************************************;
*************************************  End Change MOVE_SUBSET_DATASETS2 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID823117 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID823117;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID823117")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID823117;
%goto ID823117;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52,M2MI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID823117;
* Insert record into change management table for CHANGE_ID: ID823117;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID823117",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID823117;
 
%end;
 
 
 
 
 
 
 
proc sql;
ALTER TABLE &m_didm_stg..stg_vehicle
ADD VG_MASTER_TYPE integer length=4;
quit;
 
proc sql;
ALTER TABLE &m_di_mon..stg_vehicle_x
ADD VG_MASTER_TYPE integer length=4;
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID823117;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID823117;
%put ERROR- Description                              : Adding column VG_MASTER_TYPE to stg_vehicle.;
%put ERROR- Version                                  : D3MICM52,M2MI42;
%put ERROR- Date of Change                           : 15FEB2012;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID823117;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID823117",
"Adding column VG_MASTER_TYPE to stg_vehicle.",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID823117:;
 
 
* End of changes for CHANGE_ID:ID823117;
 
 
***********************************************************************************************;
*************************************  End Change ID823117 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID834648 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID834648;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID834648")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_data..GLOBAL_SETTING))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_data..GLOBAL_SETTING;
%put NOTE- Change ID                             :ID834648;
%goto ID834648;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID834648;
%goto ID834648;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID834648;
* Insert record into change management table for CHANGE_ID: ID834648;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID834648",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID834648;
 
%end;
 
 
 
 
 
 
proc sql;
DELETE from &m_di_data..GLOBAL_SETTING where SPEC_NM = 'ACTIVE_PROD_STATUS' and APP = 'RPO';
INSERT INTO &m_di_data..GLOBAL_SETTING (SPEC_NM,APP,SPEC_VALUE,SPEC_DESC)
VALUES  ('ACTIVE_PROD_STATUS','RPO','1,3,5,6,7,8',
'Specifies a list of status values that indicate an active product (SKU) for SAS Regular Price Optimization.');
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID834648;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID834648;
%put ERROR- Description                              : Add separate ACTIVE_PROD_STATUS global setting for RPO;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 16FEB2012;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID834648;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID834648",
"Add separate ACTIVE_PROD_STATUS global setting for RPO",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID834648:;
 
 
* End of changes for CHANGE_ID:ID834648;
 
 
***********************************************************************************************;
*************************************  End Change ID834648 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID840135 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID840135;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID840135")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_mon..etl_sys_param))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_mon..etl_sys_param;
%put NOTE- Change ID                             :ID840135;
%goto ID840135;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID840135;
%goto ID840135;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52,M2MI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID840135;
* Insert record into change management table for CHANGE_ID: ID840135;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID840135",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID840135;
 
%end;
 
 
 
 
 
 
proc sql;
DELETE from &m_di_mon..etl_sys_param where jobname = 'LOAD_STG2DM_PROD_REPLACEMENT' and param_name = 'etlp_exception_table';
INSERT INTO &m_di_mon..etl_sys_param (jobname, param_name, param_value, default_func)
values("LOAD_STG2DM_PROD_REPLACEMENT", "etlp_exception_table","DI_MON.STG_PRODUCT_REPLACEMENT_X",'"DI_MON.STG_PRODUCT_REPLACEMENT_X"');
quit;
 
proc sql;
DELETE from &m_di_mon..Job_param where jobname = 'LOAD_SRC2STG_PROD_REPLACEMENT' and param_name = 'etlp_src_file';
INSERT INTO &m_di_mon..Job_param (jobname, param_name, param_value, default_func)
values("LOAD_SRC2STG_PROD_REPLACEMENT",  "etlp_src_file",             "/data/stg_prod_replacement.csv",      '"Y"'   );
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID840135;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID840135;
%put ERROR- Description                              : Add exception_table STG_PRODUCT_REPLACEMENT_X into di_mon.etls_sys_param;
%put ERROR- Version                                  : D3MICM52,M2MI42;
%put ERROR- Date of Change                           : 12MAR2012;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID840135;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID840135",
"Add exception_table STG_PRODUCT_REPLACEMENT_X into di_mon.etls_sys_param",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID840135:;
 
 
* End of changes for CHANGE_ID:ID840135;
 
 
***********************************************************************************************;
*************************************  End Change ID840135 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID845508 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID845508;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID845508")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_data..GLOBAL_SETTING))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_data..GLOBAL_SETTING;
%put NOTE- Change ID                             :ID845508;
%goto ID845508;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID845508;
%goto ID845508;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID845508;
* Insert record into change management table for CHANGE_ID: ID845508;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID845508",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID845508;
 
%end;
 
 
 
 
 
 
proc sql;
UPDATE &m_di_data..GLOBAL_SETTING
set SPEC_DESC = 'Specifies the number of product-location pairs at or above which a price plan is divided into subplans for optimization or evaluation.'
where SPEC_NM = 'MAX_SUBPLAN_ILCNT';
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID845508;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID845508;
%put ERROR- Description                              : Update description for global setting MAX_SUBPLAN_ILCNT;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 21MAR2012;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID845508;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID845508",
"Update description for global setting MAX_SUBPLAN_ILCNT",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID845508:;
 
 
* End of changes for CHANGE_ID:ID845508;
 
 
***********************************************************************************************;
*************************************  End Change ID845508 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID848290 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID848290;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID848290")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_data..GLOBAL_SETTING))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_data..GLOBAL_SETTING;
%put NOTE- Change ID                             :ID848290;
%goto ID848290;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID848290;
%goto ID848290;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID848290;
* Insert record into change management table for CHANGE_ID: ID848290;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID848290",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID848290;
 
%end;
 
 
 
 
 
 
proc sql;
DELETE from &m_di_data..GLOBAL_SETTING where SPEC_NM = 'GENERATED_BULK_PACK_PREFIX';
INSERT INTO &m_di_data..GLOBAL_SETTING (SPEC_NM,APP,SPEC_VALUE,SPEC_DESC)
VALUES  ('GENERATED_BULK_PACK_PREFIX','SZPK','GB',
'Specifies the prefix to add to the names of generated bulk packs. This value should contain no more than 4 characters.');
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID848290;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID848290;
%put ERROR- Description                              : Add global setting GENERATED_BULK_PACK_PREFIX for Pack Opt;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 30MAR2012;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID848290;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID848290",
"Add global setting GENERATED_BULK_PACK_PREFIX for Pack Opt",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID848290:;
 
 
* End of changes for CHANGE_ID:ID848290;
 
 
***********************************************************************************************;
*************************************  End Change ID848290 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID848133 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID848133;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID848133")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_data..GLOBAL_SETTING))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_data..GLOBAL_SETTING;
%put NOTE- Change ID                             :ID848133;
%goto ID848133;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID848133;
%goto ID848133;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID848133;
* Insert record into change management table for CHANGE_ID: ID848133;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID848133",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID848133;
 
%end;
 
 
 
 
 
 
proc sql;
DELETE from &m_di_data..GLOBAL_SETTING where SPEC_NM = 'MIN_BASELINE_DEMAND';
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID848133;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID848133;
%put ERROR- Description                              : Remove global setting MIN_BASELINE_DEMAND;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 30MAR2012;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID848133;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID848133",
"Remove global setting MIN_BASELINE_DEMAND",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID848133:;
 
 
* End of changes for CHANGE_ID:ID848133;
 
 
***********************************************************************************************;
*************************************  End Change ID848133 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID848290_1 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID848290_1;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID848290_1")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_data..GLOBAL_SETTING))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_data..GLOBAL_SETTING;
%put NOTE- Change ID                             :ID848290_1;
%goto ID848290_1;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID848290_1;
%goto ID848290_1;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID848290_1;
* Insert record into change management table for CHANGE_ID: ID848290_1;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID848290_1",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID848290_1;
 
%end;
 
 
 
 
 
 
proc sql;
UPDATE &m_di_data..GLOBAL_SETTING
SET SPEC_DESC = 'Specifies the prefix to add to the IDs of generated bulk packs. This value should contain no more than 4 characters.'
WHERE SPEC_NM = 'GENERATED_BULK_PACK_PREFIX';
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID848290_1;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID848290_1;
%put ERROR- Description                              : Modify description for global setting GENERATED_BULK_PACK_PREFIX;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 02APR2012;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID848290_1;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID848290_1",
"Modify description for global setting GENERATED_BULK_PACK_PREFIX",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID848290_1:;
 
 
* End of changes for CHANGE_ID:ID848290_1;
 
 
***********************************************************************************************;
*************************************  End Change ID848290_1 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID850539 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID850539;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID850539")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_data..GLOBAL_SETTING))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_data..GLOBAL_SETTING;
%put NOTE- Change ID                             :ID850539;
%goto ID850539;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID850539;
%goto ID850539;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID850539;
* Insert record into change management table for CHANGE_ID: ID850539;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID850539",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID850539;
 
%end;
 
 
 
 
 
 
proc sql;
DELETE from &m_di_data..GLOBAL_SETTING where SPEC_NM = 'CASE_PACK_ATTR';
INSERT INTO &m_di_data..GLOBAL_SETTING (SPEC_NM,APP,SPEC_VALUE,SPEC_DESC)
VALUES  ('CASE_PACK_ATTR','ALL','CASE_PACK', 'Specifies the attribute name for the case pack size.');
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID850539;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID850539;
%put ERROR- Description                              : Add global setting CASE_PACK_ATTR;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 05APR2012;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID850539;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID850539",
"Add global setting CASE_PACK_ATTR",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID850539:;
 
 
* End of changes for CHANGE_ID:ID850539;
 
 
***********************************************************************************************;
*************************************  End Change ID850539 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID853574 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID853574;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID853574")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID853574;
%goto ID853574;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID853574;
* Insert record into change management table for CHANGE_ID: ID853574;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID853574",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID853574;
 
%end;
 
 
 
 
 
 
%local  m_plan_low_data_lvl_value m_plan_low_data_lvl_cnt;
proc sql noprint;
 
 
select spec_value into :m_plan_low_data_lvl_value
from &m_di_data..global_setting
where SPEC_NM="GEO_PROD_LOW_DATA_LVL"
and APP="ALL"
 
;
 
select count(*) into :m_plan_low_data_lvl_cnt
from &m_di_data..global_setting
where SPEC_NM="PLAN_LOW_DATA_LVL"
AND APP='RPP'
 
;
 
quit;
 
/* If no setting exists for PLAN_LOW_DATA_LVL then seed it with the value of GEO_PROD_LOW_DATA_LVL */
%if ( &m_plan_low_data_lvl_cnt<1) %then
%do;
proc sql noprint;
INSERT INTO &m_di_data..global_setting (SPEC_NM,APP,SPEC_VALUE,SPEC_DESC)
VALUES  ('PLAN_LOW_DATA_LVL','RPP',"&m_plan_low_data_lvl_value",
'Specifies the lowest location level and lowest product level for plan members.');
quit;
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID853574;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID853574;
%put ERROR- Description                              : Insert PLAN_LOW_DATA_LVL in global_setting;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 18APR2012;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID853574;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID853574",
"Insert PLAN_LOW_DATA_LVL in global_setting",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID853574:;
 
 
* End of changes for CHANGE_ID:ID853574;
 
 
***********************************************************************************************;
*************************************  End Change ID853574 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID853326 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID853326;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID853326")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID853326;
%goto ID853326;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID853326;
* Insert record into change management table for CHANGE_ID: ID853326;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID853326",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID853326;
 
%end;
 
 
 
 
 
 
 
proc sql;
 
drop table &m_di_data..CLR_DC_INV_REPORT;
drop table &m_di_data..CLR_EFF_REPORT;
drop table &m_di_data..CLR_INV_AGING_REPORT;
drop table &m_di_data..CLR_ITEM_SEL_REPORT;
drop table &m_di_data..CLR_MD_PROJECTION_REPORT;
drop table &m_di_data..CLR_MD_PROJECTION_REPORT_WEEKLY;
drop table &m_di_data..MKDN_APPR_REPORT;
drop table &m_di_data..REG_COST_CHG_REPORT;
drop table &m_di_data..REG_COST_HIST_REPORT;
drop table &m_di_data..REG_GM_CHG_REPORT;
drop table &m_di_data..REG_SKU_COST_CHG_REPORT;
drop table &m_di_data..REG_SKU_RETAIL_CHG_REPORT;
drop table &m_di_data..RPP_PGSPOT;
drop table &m_di_data..RPP_PROMOEFF;
drop table &m_di_data..RPP_PROMOPLAN;
drop table &m_di_data..RPP_PROMOSUMM;
drop table &m_di_data..RPP_VENDOR_FUND;
drop table &m_di_data..RPP_VG_SUMMARY;
 
drop table &m_di_data..REPORT_DEMAND_DECOM_DATE_SK;
drop table &m_di_data..REPORT_MEASURES_DATE_SK;
 
quit;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID853326;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID853326;
%put ERROR- Description                              : Drop tables that are no longer used;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 18APR2012;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID853326;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID853326",
"Drop tables that are no longer used",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID853326:;
 
 
* End of changes for CHANGE_ID:ID853326;
 
 
***********************************************************************************************;
*************************************  End Change ID853326 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID854785 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID854785;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID854785")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID854785;
%goto ID854785;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID854785;
* Insert record into change management table for CHANGE_ID: ID854785;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID854785",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID854785;
 
%end;
 
 
 
 
 
%let parentdir=%di_util_first_libpath(&m_di_data);
 
 
%let moveToSubdir=archive;
%let _dir = %sysfunc(dcreate(&moveToSubdir,&parentdir));
 
%if "&sysscp"="WIN" %then
%do;
%let m_sepchar=\;
%let m_movecmd=move;
options noxwait;
%end;
 
%else
%do;
%let m_sepchar=/;
%let m_movecmd=mv;
%end;
 
%if %sysfunc(fileexist(%quote(&parentdir&m_sepchar.&moveToSubdir))) %then
%do;
 
%let sourceDir=promotion_fact;
%if %sysfunc(fileexist(%quote(&parentdir&m_sepchar.&sourceDir))) %then
%do;
X "&m_movecmd &parentdir&m_sepchar.&sourceDir &parentdir&m_sepchar.&moveToSubdir" ;
%end;
 
%let sourceDir=promotion_fact_future;
%if %sysfunc(fileexist(%quote(&parentdir&m_sepchar.&sourceDir))) %then
%do;
X "&m_movecmd &parentdir&m_sepchar.&sourceDir &parentdir&m_sepchar.&moveToSubdir" ;
%end;
 
%let sourceDir=promo_sales_fact;
%if %sysfunc(fileexist(%quote(&parentdir&m_sepchar.&sourceDir))) %then
%do;
X "&m_movecmd &parentdir&m_sepchar.&sourceDir &parentdir&m_sepchar.&moveToSubdir" ;
%end;
 
 
%end;
%else %do;
%put NOTE: Directory "&parentdir&m_sepchar.&moveToSubdir" does not exist.;
%end;
 
 
 
 
 
* Check for errors while processing CHANGE_ID: ID854785;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID854785;
%put ERROR- Description                              : Move folders in di_data that are no longer valid to archive folder;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 20APR2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID854785;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID854785",
"Move folders in di_data that are no longer valid to archive folder",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID854785:;
 
 
* End of changes for CHANGE_ID:ID854785;
 
 
***********************************************************************************************;
*************************************  End Change ID854785 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID854785B ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID854785B;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID854785B")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID854785B;
%goto ID854785B;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID854785B;
* Insert record into change management table for CHANGE_ID: ID854785B;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID854785B",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID854785B;
 
%end;
 
 
 
 
 
%let parentdir=%di_util_first_libpath(&m_di_data);
 
 
%let moveToSubdir=archive;
%let _dir = %sysfunc(dcreate(&moveToSubdir,&parentdir));
 
%if "&sysscp"="WIN" %then
%do;
%let m_sepchar=\;
%let m_movecmd=move;
options noxwait;
%end;
 
%else
%do;
%let m_sepchar=/;
%let m_movecmd=mv;
%end;
 
%if %sysfunc(fileexist(%quote(&parentdir&m_sepchar.&moveToSubdir))) %then
%do;
 
%let sourceDir=prf_sales_fact;
%if %sysfunc(fileexist(%quote(&parentdir&m_sepchar.&sourceDir))) %then
%do;
X "&m_movecmd &parentdir&m_sepchar.&sourceDir &parentdir&m_sepchar.&moveToSubdir" ;
%end;
 
%let sourceDir=prf_stockout_fact;
%if %sysfunc(fileexist(%quote(&parentdir&m_sepchar.&sourceDir))) %then
%do;
X "&m_movecmd &parentdir&m_sepchar.&sourceDir &parentdir&m_sepchar.&moveToSubdir" ;
%end;
 
%let sourceDir=prf_geo_prod_status;
%if %sysfunc(fileexist(%quote(&parentdir&m_sepchar.&sourceDir))) %then
%do;
X "&m_movecmd &parentdir&m_sepchar.&sourceDir &parentdir&m_sepchar.&moveToSubdir" ;
%end;
 
 
%end;
%else %do;
%put NOTE: Directory "&parentdir&m_sepchar.&moveToSubdir" does not exist.;
%end;
 
 
 
 
 
* Check for errors while processing CHANGE_ID: ID854785B;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID854785B;
%put ERROR- Description                              : Move folders prf_sales_fact, prf_stockout_fact and prf_geo_prod_status to archive;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 20APR2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID854785B;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID854785B",
"Move folders prf_sales_fact, prf_stockout_fact and prf_geo_prod_status to archive",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID854785B:;
 
 
* End of changes for CHANGE_ID:ID854785B;
 
 
***********************************************************************************************;
*************************************  End Change ID854785B ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID846366 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID846366;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID846366")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_mon..job_param))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_mon..job_param;
%put NOTE- Change ID                             :ID846366;
%goto ID846366;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID846366;
%goto ID846366;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID846366;
* Insert record into change management table for CHANGE_ID: ID846366;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID846366",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID846366;
 
%end;
 
 
 
 
 
proc sql;
update &m_di_mon..job_param
set param_value = '52',
default_func = '"52"'
WHERE upcase(JOBNAME) = 'LOAD_STG2DM_PROMOTION_FACT'
and PARAM_NAME = 'etlp_price_hist_weeks_keep';
quit;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID846366;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID846366;
%put ERROR- Description                              : Retain 52 weeks of historical simple price promotions in Promotion fact;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 24APR2012;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID846366;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID846366",
"Retain 52 weeks of historical simple price promotions in Promotion fact",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID846366:;
 
 
* End of changes for CHANGE_ID:ID846366;
 
 
***********************************************************************************************;
*************************************  End Change ID846366 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID856810 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID856810;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID856810")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_mon..job_param))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_mon..job_param;
%put NOTE- Change ID                             :ID856810;
%goto ID856810;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID856810;
%goto ID856810;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID856810;
* Insert record into change management table for CHANGE_ID: ID856810;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID856810",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID856810;
 
%end;
 
 
 
 
 
proc sql;
update &m_di_mon..job_param
set param_value = '',
default_func = '"1"'
WHERE upcase(JOBNAME) in ('LOAD_STG2DM_RPP_PLAN','LOAD_STG2DM_RPP_PLAN_PROD_ASGMNT')
and PARAM_NAME = 'etlp_find_scope_exception';
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID856810;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID856810;
%put ERROR- Description                              : Always check for scope violation of PROD_PARTITION_LVL among imported promotion plans;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 25APR2012;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID856810;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID856810",
"Always check for scope violation of PROD_PARTITION_LVL among imported promotion plans",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID856810:;
 
 
* End of changes for CHANGE_ID:ID856810;
 
 
***********************************************************************************************;
*************************************  End Change ID856810 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID861308 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID861308;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID861308")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_data..GEO_PROD_EXCEPTION))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_data..GEO_PROD_EXCEPTION;
%put NOTE- Change ID                             :ID861308;
%goto ID861308;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID861308;
%goto ID861308;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID861308;
* Insert record into change management table for CHANGE_ID: ID861308;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID861308",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID861308;
 
%end;
 
 
 
 
 
proc sql;
create table _index as
select indxname, indxpos, upcase(name) as name
from dictionary.indexes
where libname = upcase("&m_di_data")
and   memname = upcase("GEO_PROD_EXCEPTION")
;
quit;
 
proc sql noprint;
select count(*) into :l_count_prim_key from _index
where indxname='PRIM_KEY';
quit;
 
%if &l_count_prim_key > 0 %then
%do;
proc sql;
alter table &m_di_data..GEO_PROD_EXCEPTION drop CONSTRAINT PRIM_KEY;
quit;
%end;
 
proc sql noprint;
select count(*) into :l_count_cp_idx from _index
where indxname='GP_IDX_GPE';
quit;
 
%if &l_count_cp_idx = 0 %then
%do;
proc sql;
CREATE INDEX GP_IDX_GPE ON &m_di_data..GEO_PROD_EXCEPTION(PROD_HIER_SK, GEO_HIER_SK);
quit;
%end;
 
%di_util_drop_table(_index)
 
 
 
* Check for errors while processing CHANGE_ID: ID861308;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID861308;
%put ERROR- Description                              : Drop PRIM_KEY on GEO_PROD_EXCEPTION;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 10MAY2012;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID861308;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID861308",
"Drop PRIM_KEY on GEO_PROD_EXCEPTION",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID861308:;
 
 
* End of changes for CHANGE_ID:ID861308;
 
 
***********************************************************************************************;
*************************************  End Change ID861308 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID863106 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID863106;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID863106")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_data..GLOBAL_SETTING))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_data..GLOBAL_SETTING;
%put NOTE- Change ID                             :ID863106;
%goto ID863106;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID863106;
%goto ID863106;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM521);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID863106;
* Insert record into change management table for CHANGE_ID: ID863106;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID863106",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID863106;
 
%end;
 
 
 
 
 
 
proc sql;
DELETE from &m_di_data..GLOBAL_SETTING where SPEC_NM = 'CONSLDT_PRICE_GEO_LVL';
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID863106;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID863106;
%put ERROR- Description                              : Remove global setting CONSLDT_PRICE_GEO_LVL;
%put ERROR- Version                                  : D3MICM521;
%put ERROR- Date of Change                           : 15MAY2012;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID863106;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID863106",
"Remove global setting CONSLDT_PRICE_GEO_LVL",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID863106:;
 
 
* End of changes for CHANGE_ID:ID863106;
 
 
***********************************************************************************************;
*************************************  End Change ID863106 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID864476 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID864476;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID864476")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_mon..job_param))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_mon..job_param;
%put NOTE- Change ID                             :ID864476;
%goto ID864476;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID864476;
%goto ID864476;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID864476;
* Insert record into change management table for CHANGE_ID: ID864476;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID864476",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID864476;
 
%end;
 
 
 
 
 
 
proc sql;
DELETE from &m_di_mon..job_param WHERE upcase(JOBNAME) = "LOAD_DM_RPP_APPROVED_ASGMNT"
and upcase(PARAM_NAME) = 'FULL_REFRESH';
 
Insert into &m_di_mon..job_param (jobname, param_name, param_value, default_func)
values("LOAD_DM_RPP_APPROVED_ASGMNT","Full_refresh","",'"1"' );
quit;
 
 
 
 
 
* Check for errors while processing CHANGE_ID: ID864476;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID864476;
%put ERROR- Description                              : Add Full Refresh parameter for LOAD_DM_RPP_APPROVED_ASGMNT;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 30MAY2012;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID864476;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID864476",
"Add Full Refresh parameter for LOAD_DM_RPP_APPROVED_ASGMNT",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID864476:;
 
 
* End of changes for CHANGE_ID:ID864476;
 
 
***********************************************************************************************;
*************************************  End Change ID864476 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID866948 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID866948;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID866948")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_mon..job_param))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_mon..job_param;
%put NOTE- Change ID                             :ID866948;
%goto ID866948;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID866948;
%goto ID866948;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID866948;
* Insert record into change management table for CHANGE_ID: ID866948;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID866948",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID866948;
 
%end;
 
 
 
 
 
 
Proc sql;
delete from &m_di_mon..job_param
where PARAM_NAME='etlp_use_hash_lookup'
and JOBNAME='LOAD_STG2DM_CUSTOM_ATTR';
 
insert into &m_di_mon..job_param
(JOBNAME ,PARAM_NAME ,PARAM_VALUE, DEFAULT_FUNC)
values('LOAD_STG2DM_CUSTOM_ATTR','etlp_use_hash_lookup','1','"1"');
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID866948;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID866948;
%put ERROR- Description                              : Add parameter etlp_use_hash_lookup for LOAD_STG2DM_CUSTOM_ATTR;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 31MAY2012;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID866948;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID866948",
"Add parameter etlp_use_hash_lookup for LOAD_STG2DM_CUSTOM_ATTR",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID866948:;
 
 
* End of changes for CHANGE_ID:ID866948;
 
 
***********************************************************************************************;
*************************************  End Change ID866948 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID895694 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID895694;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID895694")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID895694;
%goto ID895694;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(M1MICM521);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID895694;
* Insert record into change management table for CHANGE_ID: ID895694;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID895694",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID895694;
 
%end;
 
 
 
 
 
data &m_di_data..VENDOR_SUPPORT;
attrib VENDOR_DEAL_ID    length = $32                                                            ;
attrib PROD_HIER_SK      length = 6                                                              ;
attrib GEO_HIER_SK       length = 4                                                              ;
attrib SUPPORT_NAME      length = $32                                                            ;
attrib START_DT          length = 8 FORMAT = &m_DTFMT. INFORMAT = &m_DTFMT.                      ;
attrib END_DT            length = 8 FORMAT = &m_DTFMT. INFORMAT = &m_DTFMT.                      ;
attrib SUPPORT_TYPE      length = 4                                                              ;
attrib SUPPORT_AMT       length = 8 FORMAT = NLNUM20.3 INFORMAT = NLNUM20.3                      ;
attrib APPLY_TO_BASE_FLG length = 4                                                              ;
stop; run;
 
proc sql;
alter table &m_di_data..VENDOR_SUPPORT add CONSTRAINT PRIM_KEY PRIMARY KEY (VENDOR_DEAL_ID, PROD_HIER_SK, GEO_HIER_SK, SUPPORT_NAME);
alter table &m_di_data..VENDOR_SUPPORT add NOT NULL (START_DT);
alter table &m_di_data..VENDOR_SUPPORT add NOT NULL (END_DT);
alter table &m_di_data..VENDOR_SUPPORT add NOT NULL (SUPPORT_TYPE);
alter table &m_di_data..VENDOR_SUPPORT add NOT NULL (SUPPORT_AMT);
alter table &m_di_data..VENDOR_SUPPORT add NOT NULL (APPLY_TO_BASE_FLG);
quit;
 
proc sql;
CREATE INDEX VENDOR_SUPPORT_IX1 ON &m_di_data..VENDOR_SUPPORT
(
PROD_HIER_SK,
GEO_HIER_SK,
START_DT,
END_DT
);
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID895694;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID895694;
%put ERROR- Description                              : Add VENDOR_SUPPORT Long Term Vendor Funding (LTVF) support within the RO system;
%put ERROR- Version                                  : M1MICM521;
%put ERROR- Date of Change                           : 07SEP2012;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID895694;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID895694",
"Add VENDOR_SUPPORT Long Term Vendor Funding (LTVF) support within the RO system",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID895694:;
 
 
* End of changes for CHANGE_ID:ID895694;
 
 
***********************************************************************************************;
*************************************  End Change ID895694 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID895694_STG ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID895694_STG;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID895694_STG")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID895694_STG;
%goto ID895694_STG;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(M1MICM521);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID895694_STG;
* Insert record into change management table for CHANGE_ID: ID895694_STG;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID895694_STG",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID895694_STG;
 
%end;
 
 
 
 
 
 
data &m_didm_stg..STG_VENDOR_SUPPORT;
attrib VENDOR_DEAL_ID                      length = $32                                       ;
attrib PROD_ID                             length = $32                                       ;
attrib GEO_ID                              length = $32                                       ;
attrib SUPPORT_NAME                        length = $32                                       ;
attrib START_DT                            length = 8   FORMAT=&m_DTFMT INFORMAT=&m_STG_DTINFMT;
attrib END_DT                              length = 8   FORMAT=&m_DTFMT INFORMAT=&m_STG_DTINFMT;
attrib SUPPORT_TYPE                        length = 4                                         ;
attrib SUPPORT_AMT                         length = 8    FORMAT=NLNUM20.3   INFORMAT=NLNUM20.3;
attrib APPLY_TO_BASE_FLG                   length = 4                                         ;
attrib CHANGE_FLG                          length = $1                                        ;
stop; run;
 
proc sql;
alter table &m_didm_stg..STG_VENDOR_SUPPORT add NOT NULL (VENDOR_DEAL_ID);
alter table &m_didm_stg..STG_VENDOR_SUPPORT add NOT NULL (PROD_ID);
alter table &m_didm_stg..STG_VENDOR_SUPPORT add NOT NULL (GEO_ID);
alter table &m_didm_stg..STG_VENDOR_SUPPORT add NOT NULL (SUPPORT_NAME);
alter table &m_didm_stg..STG_VENDOR_SUPPORT add NOT NULL (CHANGE_FLG);
quit;
 
 
data &m_di_mon..STG_VENDOR_SUPPORT_X;
attrib VENDOR_DEAL_ID length = $32
PROD_ID        length = $32
GEO_ID         length = $32
SUPPORT_NAME   length = $32
START_DT       length = 8 format=&m_DTFMT
END_DT         length = 8 format=&m_DTFMT
SUPPORT_TYPE   length = 4
SUPPORT_AMT    length = 8 FORMAT=NLNUM20.3
APPLY_TO_BASE_FLG length = 4
CHANGE_FLG     length = $1
ETLS_EXCEPTION_COND length = $100
ETL_ERROR_JOBRUNTIME length = 8 format=DATETIME16. ;
stop; run;
 
proc sql noprint ;
delete from &m_di_mon..etl_sys_param where jobname="LOAD_STG2DM_VENDOR_SUPPORT"
and param_name="etlp_exception_table"
;
Insert into &m_di_mon..etl_sys_param
(jobname, param_name, param_value, default_func)
values("LOAD_STG2DM_VENDOR_SUPPORT",  "etlp_exception_table", "DI_MON.STG_VENDOR_SUPPORT_X",  '"DI_MON.STG_VENDOR_SUPPORT_X"'  )
;
delete from &m_di_mon..job_param where jobname="LOAD_SRC2STG_VENDOR_SUPPORT"
and param_name="etlp_src_file"
;
Insert into &m_di_mon..job_param
(jobname, param_name, param_value, default_func)
values("LOAD_SRC2STG_VENDOR_SUPPORT",  "etlp_src_file", "/data/stg_vendor_support.csv",  '"Y"'  )
;
quit;
 
proc sort data=&m_di_mon..job_param force;
by jobname param_name;
run;
 
proc sort data = &m_di_mon..etl_sys_param force;
by jobname param_name;
run;
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID895694_STG;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID895694_STG;
%put ERROR- Description                              : Add stg and mon for VENDOR_SUPPORT Long Term Vendor Funding (LTVF);
%put ERROR- Version                                  : M1MICM521;
%put ERROR- Date of Change                           : 07SEP2012;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID895694_STG;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID895694_STG",
"Add stg and mon for VENDOR_SUPPORT Long Term Vendor Funding (LTVF)",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID895694_STG:;
 
 
* End of changes for CHANGE_ID:ID895694_STG;
 
 
***********************************************************************************************;
*************************************  End Change ID895694_STG ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change LOOKUP_VALUES_FOR_VENDOR_SUPPORT ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: LOOKUP_VALUES_FOR_VENDOR_SUPPORT;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("LOOKUP_VALUES_FOR_VENDOR_SUPPORT")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : LOOKUP_VALUES_FOR_VENDOR_SUPPORT;
%goto LOOKUP_VALUES_FOR_VENDOR_SUPPORT;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(M1MICM521);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : LOOKUP_VALUES_FOR_VENDOR_SUPPORT;
* Insert record into change management table for CHANGE_ID: LOOKUP_VALUES_FOR_VENDOR_SUPPORT;
proc sql;
insert  into di_data.data_model_change_management
values (
"LOOKUP_VALUES_FOR_VENDOR_SUPPORT",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto LOOKUP_VALUES_FOR_VENDOR_SUPPORT;
 
%end;
 
 
 
 
 
proc sql;
 
DELETE FROM &m_di_data..FIELD_LOOKUP_VALUES
WHERE upcase(FIELD_NM) = 'SUPPORT_TYPE'
AND upcase(TABLE_NAME) = 'VENDOR_SUPPORT';
 
INSERT INTO &m_di_data..FIELD_LOOKUP_VALUES (FIELD_NM, TABLE_NAME, FIELD_VALUE, FIELD_VALUE_NM,
FIELD_VALUE_DESC, FIELD_DATATYPE)
VALUES ('SUPPORT_TYPE', 'VENDOR_SUPPORT', '1', 'AMOUNT_OFF_CASE', 'amount off per case pack', 'INTEGER');
INSERT INTO &m_di_data..FIELD_LOOKUP_VALUES (FIELD_NM, TABLE_NAME, FIELD_VALUE, FIELD_VALUE_NM,
FIELD_VALUE_DESC, FIELD_DATATYPE)
VALUES ('SUPPORT_TYPE', 'VENDOR_SUPPORT', '2', 'AMOUNT_OFF_UNIT', 'amount off per unit', 'INTEGER');
INSERT INTO &m_di_data..FIELD_LOOKUP_VALUES (FIELD_NM, TABLE_NAME, FIELD_VALUE, FIELD_VALUE_NM,
FIELD_VALUE_DESC, FIELD_DATATYPE)
VALUES ('SUPPORT_TYPE', 'VENDOR_SUPPORT', '3', 'PERCENT_OFF_UNIT', 'percent off amount per unit', 'INTEGER');
 
DELETE FROM &m_di_data..FIELD_LOOKUP_VALUES
WHERE upcase(FIELD_NM) = 'APPLY_TO_BASE_FLG'
AND upcase(TABLE_NAME) = 'VENDOR_SUPPORT';
 
INSERT INTO &m_di_data..FIELD_LOOKUP_VALUES (FIELD_NM, TABLE_NAME, FIELD_VALUE, FIELD_VALUE_NM,
FIELD_VALUE_DESC, FIELD_DATATYPE)
VALUES ('APPLY_TO_BASE_FLG', 'VENDOR_SUPPORT', '0', 'NOT_APPLIED_TO_BASE',
'Values are for display only and not applied to base cost', 'INTEGER');
INSERT INTO &m_di_data..FIELD_LOOKUP_VALUES (FIELD_NM, TABLE_NAME, FIELD_VALUE, FIELD_VALUE_NM,
FIELD_VALUE_DESC, FIELD_DATATYPE)
VALUES ('APPLY_TO_BASE_FLG', 'VENDOR_SUPPORT', '1', 'APPLIED_TO_BASE',
'Values are applied to base cost when determining metrics such as margins, etc', 'INTEGER');
quit;
 
 
 
* Check for errors while processing CHANGE_ID: LOOKUP_VALUES_FOR_VENDOR_SUPPORT;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: LOOKUP_VALUES_FOR_VENDOR_SUPPORT;
%put ERROR- Description                              : Add lookup values for VENDOR_SUPPORT;
%put ERROR- Version                                  : M1MICM521;
%put ERROR- Date of Change                           : 10SEP2012;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: LOOKUP_VALUES_FOR_VENDOR_SUPPORT;
proc sql;
insert  into di_data.data_model_change_management
values (
"LOOKUP_VALUES_FOR_VENDOR_SUPPORT",
"Add lookup values for VENDOR_SUPPORT",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%LOOKUP_VALUES_FOR_VENDOR_SUPPORT:;
 
 
* End of changes for CHANGE_ID:LOOKUP_VALUES_FOR_VENDOR_SUPPORT;
 
 
***********************************************************************************************;
*************************************  End Change LOOKUP_VALUES_FOR_VENDOR_SUPPORT ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID905746 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID905746;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID905746")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID905746;
%goto ID905746;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(M1MICM521);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID905746;
* Insert record into change management table for CHANGE_ID: ID905746;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID905746",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID905746;
 
%end;
 
 
 
 
 
proc sql;
alter table &m_didm_stg..STG_RPP_PLAN_PROD_ASGMNT
add PRICE_OVERRIDE_AMT NUM 8 format = NLNUM20.3 INFORMAT=NLNUM20.3;
quit;
 
proc sql;
alter table &m_di_mon..STG_RPP_PLAN_PROD_ASGMNT_X
add PRICE_OVERRIDE_AMT NUM 8 format = NLNUM20.3 INFORMAT=NLNUM20.3;
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID905746;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID905746;
%put ERROR- Description                              : Add PRICE_OVERRIDE_AMT in STG_RPP_PLAN_PROD_ASGMNT;
%put ERROR- Version                                  : M1MICM521;
%put ERROR- Date of Change                           : 11OCT2012;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID905746;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID905746",
"Add PRICE_OVERRIDE_AMT in STG_RPP_PLAN_PROD_ASGMNT",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID905746:;
 
 
* End of changes for CHANGE_ID:ID905746;
 
 
***********************************************************************************************;
*************************************  End Change ID905746 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID935955 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID935955;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID935955")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID935955;
%goto ID935955;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(F1MICM521);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID935955;
* Insert record into change management table for CHANGE_ID: ID935955;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID935955",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID935955;
 
%end;
 
 
 
 
 
 
 
%let l_count_enforce_fair_sharing=0;
 
proc sql noprint;
select count(*) into :l_count_enforce_fair_sharing from &m_di_data..global_setting
where SPEC_NM='ENFORCE_FAIR_SHARING';
quit;
 
 
%if &l_count_enforce_fair_sharing = 0 %then
%do;
 
proc sql;
insert into &m_di_data..GLOBAL_SETTING (spec_nm, app, spec_value, spec_desc)
values ('ENFORCE_FAIR_SHARING', 'SZPK', '0',
'Set to 0 to allow pack swaps among stores to improve cost');
quit;
%end;
%else
%do;
%put NOTE:Global_setting for spec_nm of ENFORCE_FAIR_SHARING already exists.;
%end;
 
 
 
 
%let l_count_force_allocation_qty=0;
 
proc sql noprint;
select count(*) into :l_count_force_allocation_qty from &m_di_data..global_setting
where SPEC_NM='FORCE_ALLOCATION_QTY';
quit;
 
 
%if &l_count_force_allocation_qty = 0 %then
%do;
 
proc sql;
insert into  &m_di_data..GLOBAL_SETTING (spec_nm, app, spec_value, spec_desc)
values ('FORCE_ALLOCATION_QTY', 'SZPK', '0',
'Set to 1 to allocate at least the sum of the stores allocation qty');
quit;
%end;
%else
%do;
%put NOTE:Global_setting for spec_nm of FORCE_ALLOCATION_QTY already exists.;
%end;
 
 
quit;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID935955;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID935955;
%put ERROR- Description                              : Add new global setting for Pack Opt;
%put ERROR- Version                                  : F1MICM521;
%put ERROR- Date of Change                           : 04FEB2013;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID935955;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID935955",
"Add new global setting for Pack Opt",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID935955:;
 
 
* End of changes for CHANGE_ID:ID935955;
 
 
***********************************************************************************************;
*************************************  End Change ID935955 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID938326_attribute_consolidation ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID938326_attribute_consolidation;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID938326_attribute_consolidation")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID938326_attribute_consolidation;
%goto ID938326_attribute_consolidation;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(M2MICM521);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID938326_attribute_consolidation;
* Insert record into change management table for CHANGE_ID: ID938326_attribute_consolidation;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID938326_attribute_consolidation",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID938326_attribute_consolidation;
 
%end;
 
 
 
 
 
 
data &m_didm_stg..STG_ATTRIBUTE_VALUES;
attrib ATTR_NM       length=$40;
attrib OBJECT_TYPE   length=$1 ;
attrib OBJECT_ID     length=$32;
attrib ATTR_VALUE    length=$40;
attrib CHANGE_FLG    length=$1 ;
stop; run;
 
proc sql noprint;
 
alter table &m_didm_stg..STG_ATTRIBUTE_VALUES add NOT NULL (ATTR_NM);
alter table &m_didm_stg..STG_ATTRIBUTE_VALUES add NOT NULL (OBJECT_TYPE);
alter table &m_didm_stg..STG_ATTRIBUTE_VALUES add NOT NULL (OBJECT_ID);
alter table &m_didm_stg..STG_ATTRIBUTE_VALUES add NOT NULL (ATTR_VALUE);
 
delete * from &m_di_mon..job_param
where jobname ='LOAD_SRC2STG_ATTRIBUTE_VALUES' and  param_name = 'etlp_src_file';
 
Insert into &m_di_mon..job_param
(jobname, param_name, param_value, default_func)
values("LOAD_SRC2STG_ATTRIBUTE_VALUES",  "etlp_src_file", "/data/stg_attribute_values.csv",  '"Y"'  );
 
 
delete * from &m_di_mon..job_param
where jobname in ('LOAD_STG2DM_PROD_ATTRIBUTE_VALUES', 'LOAD_STG2DM_GEO_ATTRIBUTE_VALUES') ;
 
Insert into &m_di_mon..job_param
(jobname, param_name, param_value, default_func)
values("LOAD_STG2DM_PROD_ATTRIBUTE_VALUES","etlp_date_format","DATE9.",'"DATE9."')
values("LOAD_STG2DM_PROD_ATTRIBUTE_VALUES","etlp_datetime_format","NLDATM21.",'"NLDATM21."')
values("LOAD_STG2DM_PROD_ATTRIBUTE_VALUES","etlp_use_hash_lookup","1",'"1"')
values("LOAD_STG2DM_GEO_ATTRIBUTE_VALUES","etlp_date_format","DATE9.",'"DATE9."')
values("LOAD_STG2DM_GEO_ATTRIBUTE_VALUES","etlp_datetime_format","NLDATM21.",'"NLDATM21."')
;
 
delete from &m_di_mon..etl_sys_param where jobname in ("LOAD_STG2DM_PROD_ATTRIBUTE_VALUES","LOAD_STG2DM_GEO_ATTRIBUTE_VALUES")
and param_name="etlp_exception_table"
;
Insert into &m_di_mon..etl_sys_param
(jobname, param_name, param_value, default_func)
values("LOAD_STG2DM_PROD_ATTRIBUTE_VALUES","etlp_exception_table", "DI_MON.STG_PRODUCT_ATTRIBUTES_X",'"DI_MON.STG_PRODUCT_ATTRIBUTES_X"' )
values("LOAD_STG2DM_GEO_ATTRIBUTE_VALUES","etlp_exception_table", "DI_MON.STG_GEOGRAPHY_ATTRIBUTES_X",'"DI_MON.STG_GEOGRAPHY_ATTRIBUTES_X"' )
;
 
quit;
 
/*New Exception tables for DQ*/
data &m_di_mon..DQ_PRODUCT_ATTRIBUTE_X;
attrib PROD_HIER_SK length=6;
attrib PROD_LVL length=4;
attrib PROD_ATTR_SK length=4;
attrib PROD_ATTR_VALUE length=$40;
attrib DQ_EXCEPTION_COND length=$100;
attrib DQ_ERROR_JOBRUNTIME length=8 format=NLDATM21. ;
stop;
run;
 
data &m_di_mon..DQ_GEOGRAPHY_ATTRIBUTE_X;
attrib GEO_HIER_SK length=4;
attrib GEO_LVL length=4;
attrib GEO_ATTR_SK length=4;
attrib GEO_ATTR_VALUE length=$40;
attrib DQ_EXCEPTION_COND length=$100;
attrib DQ_ERROR_JOBRUNTIME length=8 format=NLDATM21. ;
stop;
run;
 
 
 
* Check for errors while processing CHANGE_ID: ID938326_attribute_consolidation;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID938326_attribute_consolidation;
%put ERROR- Description                              : Consolidation of product and geography Attribute stage tables.;
%put ERROR- Version                                  : M2MICM521;
%put ERROR- Date of Change                           : 28JAN2013;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID938326_attribute_consolidation;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID938326_attribute_consolidation",
"Consolidation of product and geography Attribute stage tables.",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID938326_attribute_consolidation:;
 
 
* End of changes for CHANGE_ID:ID938326_attribute_consolidation;
 
 
***********************************************************************************************;
*************************************  End Change ID938326_attribute_consolidation ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change NEW_STAGE_52M ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: NEW_STAGE_52M;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("NEW_STAGE_52M")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_mon..etl_sys_param))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_mon..etl_sys_param;
%put NOTE- Change ID                             :NEW_STAGE_52M;
%goto NEW_STAGE_52M;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : NEW_STAGE_52M;
%goto NEW_STAGE_52M;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(M2MICM521);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : NEW_STAGE_52M;
* Insert record into change management table for CHANGE_ID: NEW_STAGE_52M;
proc sql;
insert  into di_data.data_model_change_management
values (
"NEW_STAGE_52M",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto NEW_STAGE_52M;
 
%end;
 
 
 
 
 
%local exist_new_stg_52m_setting;
 
proc sql noprint;
select count(1)
into :exist_new_stg_52m_setting
from &m_di_mon..etl_sys_param
where jobname='ETJOBFLOW'
and param_name = 'new_stage_52m';
quit;
 
%if %eval(&exist_new_stg_52m_setting eq 0) %then %do;
proc sql;
Insert into &m_di_mon..ETL_SYS_PARAM
(jobname, param_name, param_value, default_func)
values("ETJOBFLOW", "new_stage_52m", "1", '"1"');
quit;
%end;
 
%if %symexist(m_delete_and_start_fresh) %then %do;
%if %upcase(&m_delete_and_start_fresh) eq TRUE %then %do;
*New Flow and New stage tables;
proc sql;
update &m_di_mon..ETL_SYS_PARAM
set param_value = "1",
default_func = '"1"'
where jobname='ETJOBFLOW'
and param_name = 'new_stage_52m';
quit;
%end;
%else %do;
*Old Flow and old stage tables;
proc sql;
update &m_di_mon..ETL_SYS_PARAM
set param_value = "0",
default_func = '"0"'
where jobname='ETJOBFLOW'
and param_name = 'new_stage_52m';
quit;
%end;
%end;
%else %do;
%local geo_prod_etl;
*if customer is loading GEO_PROD then it must be old stg model;
proc sql noprint;
select count(1)
into :geo_prod_etl
from &m_di_mon..job_status
where jobname='Load_STG2DM_Geo_prod'
and job_rc le 4;
quit;
 
%if %eval(&geo_prod_etl gt 0) %then %do;
proc sql;
update &m_di_mon..ETL_SYS_PARAM
set param_value = "0",
default_func = '"0"'
where jobname='ETJOBFLOW'
and param_name = 'new_stage_52m';
quit;
%end;
%end;
 
 
 
* Check for errors while processing CHANGE_ID: NEW_STAGE_52M;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: NEW_STAGE_52M;
%put ERROR- Description                              : Determine if Customer is using 5.2M1 or prior Stage or Reduced stg for 5.2M2 and future;
%put ERROR- Version                                  : M2MICM521;
%put ERROR- Date of Change                           : 11FEB2013;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: NEW_STAGE_52M;
proc sql;
insert  into di_data.data_model_change_management
values (
"NEW_STAGE_52M",
"Determine if Customer is using 5.2M1 or prior Stage or Reduced stg for 5.2M2 and future",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%NEW_STAGE_52M:;
 
 
* End of changes for CHANGE_ID:NEW_STAGE_52M;
 
 
***********************************************************************************************;
*************************************  End Change NEW_STAGE_52M ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID848163 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID848163;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID848163")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%put NOTE: This change will be applied on every run.;
%put NOTE- Change ID :ID848163;
 
 
 
%if %symexist(FORCE_ETLJOBFLOW) %then
%do;
%if "&FORCE_ETLJOBFLOW"="NEW_STAGE_52M" %then
%do;
proc sql;
update &m_di_mon..ETL_SYS_PARAM
set param_value = "1",
default_func = '"1"'
where jobname='ETJOBFLOW'
and param_name = 'new_stage_52m';
quit;
%end;
%else %if "&FORCE_ETLJOBFLOW"="CLASSIC" %then
%do;
proc sql;
update &m_di_mon..ETL_SYS_PARAM
set param_value = "0",
default_func = '"0"'
where jobname='ETJOBFLOW'
and param_name = 'new_stage_52m';
quit;
%end;
 
%end;
 
%local exist_new_stg_52m_setting;
 
proc sql noprint;
select param_value
into :etljobflow_setting
from &m_di_mon..etl_sys_param
where jobname='ETJOBFLOW'
and param_name = 'new_stage_52m';
quit;
 
%let etljobflow_setting=&etljobflow_setting;
 
%put etljobflow_setting=&etljobflow_setting;
 
%if "&etljobflow_setting"="1" %then %do;
%put NOTE: ETL job flows are setup to run with staging tables for new customers.;
%put NOTE: This is typically valid for customers installing RO 5.2 m2 and and SO 3.2 m2 releases and beyond.;
%put NOTE: Customers migrating from releases prior to RO 5.2 m2 and SO 3.2 m2 should typically not use this setup.;
%end;
%else
%do;
%put NOTE: ETL job flows are setup to run with staging tables for customers migrating from pre RO 5.2 m2 and and SO 3.2 m2 releases.;
%end;
 
 
%macro populate_etl_job_schedule;
 
%if %sysfunc(fileexist(%quote(%di_util_misc_path()/seed/di_etl_seed.sas))) %then %do;
 
%if (%sysfunc(libref(&m_di_mon.)) = 0) %then %do;
 
%include "%di_util_misc_path()/seed/di_etl_seed.sas";
%mi_etl_job_schedule(di_data=&m_di_data, di_mon_lib=&m_di_mon, adhoc=0);
 
%end;
 
%end;
%else %do;
%put ERROR- File "%di_util_misc_path()/seed/di_etl_seed.sas" must exist. ;
%RETURN;
%end;
 
%mend;
 
%populate_etl_job_schedule;
 
 
 
* Check for errors while processing CHANGE_ID: ID848163;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID848163;
%put ERROR- Description                              : Populating ETL Job Schedule;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 28MAR2012;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID848163;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID848163",
"Populating ETL Job Schedule",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID848163:;
 
 
* End of changes for CHANGE_ID:ID848163;
 
 
***********************************************************************************************;
*************************************  End Change ID848163 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID940403 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID940403;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID940403")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_data..global_setting))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_data..global_setting;
%put NOTE- Change ID                             :ID940403;
%goto ID940403;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID940403;
%goto ID940403;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(M2MICM521);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID940403;
* Insert record into change management table for CHANGE_ID: ID940403;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID940403",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID940403;
 
%end;
 
 
 
 
 
proc sql;
select count (*) into :_exists from &m_di_data..global_setting
where spec_nm = 'FORCE_ALLOCATION_QTY';
quit;
%if &_exists = 0 %then
%do;
proc sql;
insert into &m_di_data..global_setting (SPEC_NM,APP,SPEC_VALUE,SPEC_DESC) values
('FORCE_ALLOCATION_QTY','SZPK','0',
'Specifies whether SAS Pack Optimization always ships an amount greater than or equal to your Allocation Quantity (which is the total of all Store-SKU needs).');
quit;
%end;
%else
%do;
proc sql;
select spec_value into :_current_val from &m_di_data..global_setting
where spec_nm = 'FORCE_ALLOCATION_QTY';
quit;
%if &_current_val NE 0 and &_current_val NE 1 %then
%do;
proc sql;
update &m_di_data..global_setting set spec_value = '0' where spec_nm = 'FORCE_ALLOCATION_QTY';
quit;
%end;
proc sql;
update &m_di_data..global_setting set spec_desc = 'Specifies whether SAS Pack Optimization always ships an amount greater than or equal to your Allocation Quantity (which is the total of all Store-SKU needs).'
where spec_nm = 'FORCE_ALLOCATION_QTY';
quit;
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID940403;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID940403;
%put ERROR- Description                              : Add global setting FORCE_ALLOCATION_QTY;
%put ERROR- Version                                  : M2MICM521;
%put ERROR- Date of Change                           : 12FEB2013;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID940403;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID940403",
"Add global setting FORCE_ALLOCATION_QTY",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID940403:;
 
 
* End of changes for CHANGE_ID:ID940403;
 
 
***********************************************************************************************;
*************************************  End Change ID940403 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID940412 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID940412;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID940412")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_data..global_setting))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_data..global_setting;
%put NOTE- Change ID                             :ID940412;
%goto ID940412;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID940412;
%goto ID940412;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(M2MICM521);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID940412;
* Insert record into change management table for CHANGE_ID: ID940412;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID940412",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID940412;
 
%end;
 
 
 
 
 
proc sql;
select count (*) into :_exists from &m_di_data..global_setting
where spec_nm = 'ENFORCE_FAIR_SHARING';
quit;
%if &_exists = 0 %then
%do;
proc sql;
insert into &m_di_data..global_setting (SPEC_NM,APP,SPEC_VALUE,SPEC_DESC) values
('ENFORCE_FAIR_SHARING','SZPK','0',
'Specifies whether to adjust the distribution of packs more evenly among stores when the quantity of a pack desired at the stores is much higher or lower than the available quantity of that pack.');
quit;
%end;
%else
%do;
proc sql;
select spec_value into :_current_val from &m_di_data..global_setting
where spec_nm = 'ENFORCE_FAIR_SHARING';
quit;
%if &_current_val NE 0 and &_current_val NE 1 %then
%do;
proc sql;
update &m_di_data..global_setting set spec_value = '0' where spec_nm = 'ENFORCE_FAIR_SHARING';
quit;
%end;
proc sql;
update &m_di_data..global_setting set spec_desc = 'Specifies whether to adjust the distribution of packs more evenly among stores when the quantity of a pack desired at the stores is much higher or lower than the available quantity of that pack.'
where spec_nm = 'ENFORCE_FAIR_SHARING';
quit;
%end;
 
 
 
* Check for errors while processing CHANGE_ID: ID940412;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID940412;
%put ERROR- Description                              : Add global setting ENFORCE_FAIR_SHARING;
%put ERROR- Version                                  : M2MICM521;
%put ERROR- Date of Change                           : 12FEB2013;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID940412;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID940412",
"Add global setting ENFORCE_FAIR_SHARING",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID940412:;
 
 
* End of changes for CHANGE_ID:ID940412;
 
 
***********************************************************************************************;
*************************************  End Change ID940412 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID896624 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID896624;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID896624")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID896624;
%goto ID896624;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(M2MICM521);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID896624;
* Insert record into change management table for CHANGE_ID: ID896624;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID896624",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID896624;
 
%end;
 
 
 
 
 
proc sql;
alter table &m_didm_stg..stg_product_replacement
add ORIG_PROD_ACTIVE_DT num 8 informat=&m_STG_DTINFMT format=&m_DTFMT;
;
quit;
 
proc sql;
alter table &m_di_mon..stg_product_replacement_x
add ORIG_PROD_ACTIVE_DT num 8 informat=&m_DTFMT format=&m_DTFMT;
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID896624;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID896624;
%put ERROR- Description                              : Uniquely identify products by adding orig_prod_active_dt to stg_product_replacement;
%put ERROR- Version                                  : M2MICM521;
%put ERROR- Date of Change                           : 12FEB2013;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID896624;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID896624",
"Uniquely identify products by adding orig_prod_active_dt to stg_product_replacement",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID896624:;
 
 
* End of changes for CHANGE_ID:ID896624;
 
 
***********************************************************************************************;
*************************************  End Change ID896624 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID938326_check_partitioning ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID938326_check_partitioning;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID938326_check_partitioning")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID938326_check_partitioning;
%goto ID938326_check_partitioning;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(M2MICM521);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID938326_check_partitioning;
* Insert record into change management table for CHANGE_ID: ID938326_check_partitioning;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID938326_check_partitioning",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID938326_check_partitioning;
 
%end;
 
 
 
 
 
 
data &m_di_mon..DQ_PARTITION_EXCEPTION;
attrib part_sk length=8.;
attrib table_nm length=$50.;
attrib prod_hier_sk length=8.;
attrib DQ_EXCEPTION_COND length=$100;
attrib DQ_ERROR_JOBRUNTIME length=8 format=NLDATM21. ;
stop;
run;
 
 
 
* Check for errors while processing CHANGE_ID: ID938326_check_partitioning;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID938326_check_partitioning;
%put ERROR- Description                              : Create an exception table to consider exceptions related to partitioning;
%put ERROR- Version                                  : M2MICM521;
%put ERROR- Date of Change                           : 09JAN2013;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID938326_check_partitioning;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID938326_check_partitioning",
"Create an exception table to consider exceptions related to partitioning",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID938326_check_partitioning:;
 
 
* End of changes for CHANGE_ID:ID938326_check_partitioning;
 
 
***********************************************************************************************;
*************************************  End Change ID938326_check_partitioning ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID938326_Sales_inv_return_fact ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID938326_Sales_inv_return_fact;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID938326_Sales_inv_return_fact")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID938326_Sales_inv_return_fact;
%goto ID938326_Sales_inv_return_fact;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(M2MICM521);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID938326_Sales_inv_return_fact;
* Insert record into change management table for CHANGE_ID: ID938326_Sales_inv_return_fact;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID938326_Sales_inv_return_fact",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID938326_Sales_inv_return_fact;
 
%end;
 
 
 
 
 
 
data &m_didm_stg..STG_SALES_INVENTORY_RETURNS;
attrib PROD_ID    length = $32;
attrib GEO_ID     length = $32;
attrib WK_START_DT      length = 8 format=&m_DTFMT informat=&m_STG_DTINFMT;
attrib TOTAL_SALES_QTY  length = 8 format=NLNUM12.2 informat=NLNUM12.2;
attrib TOTAL_SALES_AMT  length = 8 format=NLNUM20.3 informat=NLNUM20.3;
attrib CLOSING_INV_UNIT length = 8 format=NLNUM12.2 informat=NLNUM12.2;
attrib RETURNED_UNITS   length = 8 format=NLNUM12.2 informat=NLNUM12.2;
attrib RETURNED_AMT     length = 8 format=NLNUM20.3 informat=NLNUM20.3;
stop;
run;
 
proc sql noprint;
alter table &m_didm_stg..STG_SALES_INVENTORY_RETURNS add NOT NULL (PROD_ID);
alter table &m_didm_stg..STG_SALES_INVENTORY_RETURNS add NOT NULL (GEO_ID);
alter table &m_didm_stg..STG_SALES_INVENTORY_RETURNS add NOT NULL (WK_START_DT);
quit;
 
data &m_di_mon..STG_SALES_INVENTORY_RETURNS_X;
attrib PROD_ID    length = $32;
attrib GEO_ID     length = $32;
attrib WK_START_DT      length = 8 format=&m_DTFMT ;
attrib TOTAL_SALES_QTY  length = 8 format=NLNUM12.2 ;
attrib TOTAL_SALES_AMT  length = 8 format=NLNUM20.3 ;
attrib CLOSING_INV_UNIT length = 8 format=NLNUM12.2 ;
attrib RETURNED_UNITS   length = 8 format=NLNUM12.2 ;
attrib RETURNED_AMT     length = 8 format=NLNUM20.3 ;
attrib ETLS_EXCEPTION_COND    length = $200;
attrib ETL_ERROR_JOBRUNTIME   length = 8 format = NLDATM21.;
stop;
run;
 
proc sql noprint;
delete from &m_di_mon..etl_sys_param
where jobname = "LOAD_STG2DM_SALES_INV_RETURN_FACT" and param_name="etlp_exception_table" ;
 
Insert into &m_di_mon..etl_sys_param
(jobname, param_name, param_value, default_func)
values("LOAD_STG2DM_SALES_INV_RETURN_FACT","etlp_exception_table", "di_mon.STG_SALES_INVENTORY_RETURNS_X",'"di_mon.STG_SALES_INVENTORY_RETURNS_X"' )
;
 
delete from &m_di_mon..job_param where jobname = "LOAD_SRC2STG_SALES_INVENTORY_RETURNS" ;
Insert into &m_di_mon..job_param
(jobname, param_name, param_value, default_func)
values("LOAD_SRC2STG_SALES_INVENTORY_RETURNS","etlp_src_file", "/data/stg_sales_inventory_returns.csv",'"Y"' )
values("LOAD_SRC2STG_SALES_INVENTORY_RETURNS","loadview", "",'"1"' )
;
delete from &m_di_mon..job_param where jobname = "LOAD_STG2DM_SALES_INV_RETURN_FACT" ;
Insert into &m_di_mon..job_param
(jobname, param_name, param_value, default_func)
values("LOAD_STG2DM_SALES_INV_RETURN_FACT","etlp_run_only_facts", " ",'"SALES_FACT INVENTORY_FACT RETURN_FACT"' )
;
 
quit;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID938326_Sales_inv_return_fact;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID938326_Sales_inv_return_fact;
%put ERROR- Description                              : Consolidation of sales, Inventory and return fact stage tables;
%put ERROR- Version                                  : M2MICM521;
%put ERROR- Date of Change                           : 22FEB2013;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID938326_Sales_inv_return_fact;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID938326_Sales_inv_return_fact",
"Consolidation of sales, Inventory and return fact stage tables",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID938326_Sales_inv_return_fact:;
 
 
* End of changes for CHANGE_ID:ID938326_Sales_inv_return_fact;
 
 
***********************************************************************************************;
*************************************  End Change ID938326_Sales_inv_return_fact ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID938326_GEO_PROD_PRICE ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID938326_GEO_PROD_PRICE;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID938326_GEO_PROD_PRICE")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID938326_GEO_PROD_PRICE;
%goto ID938326_GEO_PROD_PRICE;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(M2MICM521);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID938326_GEO_PROD_PRICE;
* Insert record into change management table for CHANGE_ID: ID938326_GEO_PROD_PRICE;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID938326_GEO_PROD_PRICE",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID938326_GEO_PROD_PRICE;
 
%end;
 
 
 
 
 
 
data &m_di_mon..stg_geo_prod_price_x;
attrib PROD_ID        length = $32;
attrib GEO_ID         length = $32;
attrib EFFECTIVE_DT   length = 8 format=&m_DTFMT;
attrib REGULAR_PRICE   length = 8 format = NLNUM20.3;;
attrib ACTUAL_PERM_PRICE    length = 8 format = NLNUM20.3;;
attrib ETLS_EXCEPTION_COND length = $230 ;
attrib ETL_ERROR_JOBRUNTIME length = 8 format =datetime16. ;
stop;
run;
 
data &m_didm_stg..stg_geo_prod_price;
attrib PROD_ID        length = $32;
attrib GEO_ID         length = $32;
attrib EFFECTIVE_DT   length = 8 format=&m_DTFMT informat=&m_STG_DTINFMT;
attrib REGULAR_PRICE   length = 8 format = NLNUM20.3;
attrib ACTUAL_PERM_PRICE    length = 8 format = NLNUM20.3;
stop;
run;
 
proc sql;
alter table &m_didm_stg..STG_GEO_PROD_PRICE add NOT NULL (GEO_ID);
alter table &m_didm_stg..STG_GEO_PROD_PRICE add NOT NULL (PROD_ID);
alter table &m_didm_stg..STG_GEO_PROD_PRICE add NOT NULL (EFFECTIVE_DT);
alter table &m_didm_stg..STG_GEO_PROD_PRICE add NOT NULL (REGULAR_PRICE);
alter table &m_didm_stg..STG_GEO_PROD_PRICE add NOT NULL (ACTUAL_PERM_PRICE);
quit;
 
 
proc sql;
delete from &m_di_mon..etl_sys_param
where upper(jobname) ="LOAD_STG2DM_GEO_PROD_PRICE_FACT" and
param_name="etlp_exception_table";
 
Insert into &m_di_mon..etl_sys_param(jobname, param_name, param_value, default_func)
values("LOAD_STG2DM_GEO_PROD_PRICE_FACT","etlp_exception_table","di_mon.STG_GEO_PROD_PRICE_X",'"di_mon.STG_GEO_PROD_PRICE_X"');
 
delete from &m_di_mon..job_param
where upper(jobname) ="LOAD_STG2DM_GEO_PROD_PRICE_FACT" and
param_name="Full_refresh";
 
Insert into &m_di_mon..job_param(jobname, param_name, param_value, default_func)
values("LOAD_STG2DM_GEO_PROD_PRICE_FACT","Full_refresh","",'"0"');
 
delete from &m_di_mon..job_param
where upper(PARAM_NAME) = "STG_DATA_OVERRIDE"
and upper(jobname) = "LOAD_STG2DM_GEO_PROD_PRICE_FACT";
 
insert into &m_di_mon..job_param(JOBNAME,PARAM_NAME,PARAM_VALUE,DEFAULT_FUNC)
values("LOAD_STG2DM_GEO_PROD_PRICE_FACT","stg_data_override","1",'"1"');
 
delete from &m_di_mon..job_param
where jobname = "LOAD_STG2DM_GEO_PROD_PRICE_FACT" and param_name="etlp_move_futr_to_curr";
 
Insert into &m_di_mon..job_param(jobname, param_name, param_value, default_func)
values("LOAD_STG2DM_GEO_PROD_PRICE_FACT","etlp_move_futr_to_curr","",'"0"'   )
;
 
delete from  &m_di_mon..job_param
where jobname="LOAD_STG2DM_GEO_PROD_PRICE_FACT" and param_name="etlp_reload_history_data" ;
 
Insert into &m_di_mon..job_param(jobname, param_name, param_value, default_func)
values("LOAD_STG2DM_GEO_PROD_PRICE_FACT","etlp_reload_history_data","0",'"0"' )
;
 
delete from &m_di_mon..job_param where jobname = "LOAD_SRC2STG_GEO_PROD_PRICE" ;
Insert into &m_di_mon..job_param(jobname, param_name, param_value, default_func)
values("LOAD_SRC2STG_GEO_PROD_PRICE","etlp_src_file", "/data/stg_geo_prod_price.csv",'"Y"' )
values("LOAD_SRC2STG_GEO_PROD_PRICE","loadview", "",'"1"' )
;
quit;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID938326_GEO_PROD_PRICE;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID938326_GEO_PROD_PRICE;
%put ERROR- Description                              : Consolidation of price_fact and price_fact_future stage tables;
%put ERROR- Version                                  : M2MICM521;
%put ERROR- Date of Change                           : 25FEB2013;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID938326_GEO_PROD_PRICE;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID938326_GEO_PROD_PRICE",
"Consolidation of price_fact and price_fact_future stage tables",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID938326_GEO_PROD_PRICE:;
 
 
* End of changes for CHANGE_ID:ID938326_GEO_PROD_PRICE;
 
 
***********************************************************************************************;
*************************************  End Change ID938326_GEO_PROD_PRICE ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change GEO_PROD_OVERRIDE ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: GEO_PROD_OVERRIDE;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("GEO_PROD_OVERRIDE")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : GEO_PROD_OVERRIDE;
%goto GEO_PROD_OVERRIDE;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(M2MICM521);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : GEO_PROD_OVERRIDE;
* Insert record into change management table for CHANGE_ID: GEO_PROD_OVERRIDE;
proc sql;
insert  into di_data.data_model_change_management
values (
"GEO_PROD_OVERRIDE",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto GEO_PROD_OVERRIDE;
 
%end;
 
 
 
 
 
data &m_didm_stg..STG_GEO_PROD_OVERRIDE;
attrib PROD_ID               length=$32;
attrib GEO_ID                length=$32;
attrib STATUS_VALID_FROM_DT  length=8  FORMAT=&m_DTFMT INFORMAT=&m_STG_DTINFMT;
attrib STATUS                length=$20;
attrib SEASON_CD             length=4;
attrib SALES_DISCONTINUED_DT length=8 FORMAT=&m_DTFMT INFORMAT=&m_STG_DTINFMT;
attrib VENDOR_ID             length=$32 ;
attrib MIN_INV_LVL           length=8 FORMAT=NLNUM12.2 INFORMAT=NLNUM12.2;
attrib CHANGE_FLG            length=$1;
Stop;
Run;
 
 
proc sql;
alter table &m_didm_stg..STG_GEO_PROD_OVERRIDE add NOT NULL (PROD_ID);
alter table &m_didm_stg..STG_GEO_PROD_OVERRIDE add NOT NULL (GEO_ID);
quit;
 
 
data &m_di_mon..STG_GEO_PROD_OVERRIDE_X;
attrib PROD_ID               length=$32;
attrib GEO_ID                length=$32;
attrib STATUS_VALID_FROM_DT  length=8  FORMAT=&m_DTFMT ;
attrib STATUS                length=$20;
attrib SEASON_CD             length=4;
attrib SALES_DISCONTINUED_DT length=8 FORMAT=&m_DTFMT  ;
attrib VENDOR_ID             length=$32 ;
attrib MIN_INV_LVL           length=8;
attrib CHANGE_FLG            length=$1;
attrib ETLS_EXCEPTION_COND length=$200;
attrib ETL_ERROR_JOBRUNTIME length=8 format=&m_DTTMFMT  ;
stop;
run;
 
 
 
data &m_di_data..GEO_PROD_OVERRIDE;
attrib PROD_HIER_SK          length=6;
attrib GEO_HIER_SK           length=4;
attrib SALES_DISCONTINUED_DT length=8 FORMAT=&m_DTFMT ;
attrib INITIAL_SEASON_CD     length=4;
attrib SEASON_CD             length=4;
attrib VENDOR_SK             length=4;
attrib MIN_INV_LVL           length=8 FORMAT=NLNUM12.2;
attrib UPDATED_DTTM          length=8 FORMAT=&m_DTTMFMT;
stop;
run;
 
proc sql;
alter table &m_di_data..GEO_PROD_OVERRIDE add CONSTRAINT PRIM_KEY PRIMARY KEY (PROD_HIER_SK ,GEO_HIER_SK);
alter table &m_di_data..GEO_PROD_OVERRIDE add NOT NULL (UPDATED_DTTM);
quit;
 
 
data &m_di_data..GEO_PROD_STATUS_OVERRIDE;
attrib PROD_HIER_SK          length=6;
attrib GEO_HIER_SK           length=4;
attrib VALID_FROM_DT         length=8 FORMAT=&m_DTFMT ;
attrib VALID_TO_DT           length=8 FORMAT=&m_DTFMT ;
attrib GEO_PROD_STATUS       length=4;
attrib UPDATED_DTTM          length=8 FORMAT=&m_DTTMFMT;
stop;
run;
 
proc sql;
alter table &m_di_data..GEO_PROD_STATUS_OVERRIDE add CONSTRAINT PRIM_KEY PRIMARY KEY (PROD_HIER_SK ,GEO_HIER_SK,  VALID_FROM_DT);
alter table &m_di_data..GEO_PROD_STATUS_OVERRIDE add NOT NULL (VALID_TO_DT);
alter table &m_di_data..GEO_PROD_STATUS_OVERRIDE add NOT NULL (GEO_PROD_STATUS);
alter table &m_di_data..GEO_PROD_STATUS_OVERRIDE add NOT NULL (UPDATED_DTTM);
quit;
 
 
 
proc sql;
delete from  &m_di_mon..job_param
Where upcase(jobname) eq 'LOAD_SRC2STG_GEO_PROD_OVERRIDE' and
param_name = 'etlp_src_file';
 
insert into &m_di_mon..job_param
(jobname,                     param_name,       param_value,                 default_func)
values("LOAD_SRC2STG_GEO_PROD_OVERRIDE", "etlp_src_file", "/data/stg_geo_prod_override.csv", '"Y"' ) ;
quit;
 
 
proc sql noprint ;
delete from &m_di_mon..etl_sys_param where upcase(jobname)="LOAD_STG2DM_GEO_PROD_OVERRIDE"
and param_name="etlp_exception_table"
;
 
Insert into &m_di_mon..etl_sys_param
(jobname, param_name, param_value, default_func)
values("LOAD_STG2DM_GEO_PROD_OVERRIDE",  "etlp_exception_table", "DI_MON.STG_GEO_PROD_OVERRIDE_X",  '"DI_MON.STG_GEO_PROD_OVERRIDE_X"'  )
;
 
quit;
 
proc sql;
delete from &m_di_data..job where job_id in (96);
insert into &m_di_data..job(job_id,job_nm,parent_job_id) values (96,'generate_geo_prod_status',-1);
quit;
 
 
 
* Check for errors while processing CHANGE_ID: GEO_PROD_OVERRIDE;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: GEO_PROD_OVERRIDE;
%put ERROR- Description                              : Create table GEO_PROD_OVERRIDE and STG_GEO_PROD_OVERRIDE;
%put ERROR- Version                                  : M2MICM521;
%put ERROR- Date of Change                           : 26FEB2013;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: GEO_PROD_OVERRIDE;
proc sql;
insert  into di_data.data_model_change_management
values (
"GEO_PROD_OVERRIDE",
"Create table GEO_PROD_OVERRIDE and STG_GEO_PROD_OVERRIDE",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%GEO_PROD_OVERRIDE:;
 
 
* End of changes for CHANGE_ID:GEO_PROD_OVERRIDE;
 
 
***********************************************************************************************;
*************************************  End Change GEO_PROD_OVERRIDE ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID938326_GEO_PROD_COST ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID938326_GEO_PROD_COST;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID938326_GEO_PROD_COST")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID938326_GEO_PROD_COST;
%goto ID938326_GEO_PROD_COST;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(M2MICM521);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID938326_GEO_PROD_COST;
* Insert record into change management table for CHANGE_ID: ID938326_GEO_PROD_COST;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID938326_GEO_PROD_COST",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID938326_GEO_PROD_COST;
 
%end;
 
 
 
 
 
 
data &m_di_mon..stg_geo_prod_cost_x;
attrib PROD_ID length = $32 ;
attrib GEO_ID length = $32 ;
attrib EFFECTIVE_DT length = 8 format = &m_DTFMT informat = &m_DTFMT ;
attrib INVOICE_COST length = 8 format = NLNUM20.3 informat = NLNUM20.3;
attrib LANDED_COST length = 8 format = NLNUM20.3 informat = NLNUM20.3;
attrib ETLS_EXCEPTION_COND length = $200 ;
attrib ETL_ERROR_JOBRUNTIME length = 8 format = DATETIME16. ;
stop;
run;
 
 
data &m_didm_stg..stg_geo_prod_cost;
attrib PROD_ID        length = $32;
attrib GEO_ID         length = $32;
attrib EFFECTIVE_DT   length = 8 format=&m_DTFMT. INFORMAT=&m_STG_DTINFMT.;
attrib INVOICE_COST   length = 8 FORMAT=NLNUM20.3   INFORMAT=NLNUM20.3;
attrib LANDED_COST    length = 8 FORMAT=NLNUM20.3   INFORMAT=NLNUM20.3;
stop;
run;
 
proc sql;
alter table &m_didm_stg..STG_GEO_PROD_COST add NOT NULL (GEO_ID);
alter table &m_didm_stg..STG_GEO_PROD_COST add NOT NULL (PROD_ID);
alter table &m_didm_stg..STG_GEO_PROD_COST add NOT NULL (EFFECTIVE_DT);
quit;
 
 
proc sql;
delete from &m_di_mon..etl_sys_param
where upper(jobname) ="LOAD_STG2DM_GEO_PROD_COST_FACT" and
param_name="etlp_exception_table";
 
Insert into &m_di_mon..etl_sys_param(jobname, param_name, param_value, default_func)
values("LOAD_STG2DM_GEO_PROD_COST_FACT","etlp_exception_table","di_mon.STG_GEO_PROD_COST_X",'"di_mon.STG_GEO_PROD_COST_X"');
 
delete from DI_MON.ETL_SYS_PARAM
where  upcase(JOBNAME) = "LOAD_STG2DM_GEO_PROD_COST_FACT"
and lowcase(PARAM_NAME) = "etlp_cost_types";
 
insert into DI_MON.ETL_SYS_PARAM values
("LOAD_STG2DM_GEO_PROD_COST_FACT","etlp_cost_types","(1,2)",'"(1,2)"'  );
 
delete from &m_di_mon..job_param
where upper(jobname) ="LOAD_STG2DM_GEO_PROD_COST_FACT" and
param_name="Full_refresh";
 
Insert into &m_di_mon..job_param(jobname, param_name, param_value, default_func)
values("LOAD_STG2DM_GEO_PROD_COST_FACT","Full_refresh","",'"0"');
 
delete from &m_di_mon..job_param
where upper(PARAM_NAME) = "STG_DATA_OVERRIDE"
and upper(jobname) = "LOAD_STG2DM_GEO_PROD_COST_FACT";
 
insert into &m_di_mon..job_param(JOBNAME,PARAM_NAME,PARAM_VALUE,DEFAULT_FUNC)
values("LOAD_STG2DM_GEO_PROD_COST_FACT","stg_data_override","",'"1"');
 
delete from &m_di_mon..job_param
where jobname = "LOAD_STG2DM_GEO_PROD_COST_FACT" and param_name="etlp_move_futr_to_curr";
 
Insert into &m_di_mon..job_param(jobname, param_name, param_value, default_func)
values("LOAD_STG2DM_GEO_PROD_COST_FACT","etlp_move_futr_to_curr","",'"0"'   ) ;
 
delete from  &m_di_mon..job_param
where jobname="LOAD_STG2DM_GEO_PROD_COST_FACT" and param_name="etlp_reload_history_data" ;
 
Insert into &m_di_mon..job_param(jobname, param_name, param_value, default_func)
values("LOAD_STG2DM_GEO_PROD_COST_FACT","etlp_reload_history_data","0",'"0"' );
 
delete from &m_di_mon..job_param where jobname = "LOAD_SRC2STG_GEO_PROD_COST" ;
 
Insert into &m_di_mon..job_param(jobname, param_name, param_value, default_func)
values("LOAD_SRC2STG_GEO_PROD_COST","etlp_src_file", "/data/stg_geo_prod_COST.csv",'"Y"' )
values("LOAD_SRC2STG_GEO_PROD_COST","loadview", "",'"1"' )
;
quit;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID938326_GEO_PROD_COST;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID938326_GEO_PROD_COST;
%put ERROR- Description                              : Consolidation of cost_fact and cost_fact_future stage tables;
%put ERROR- Version                                  : M2MICM521;
%put ERROR- Date of Change                           : 26FEB2013;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID938326_GEO_PROD_COST;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID938326_GEO_PROD_COST",
"Consolidation of cost_fact and cost_fact_future stage tables",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID938326_GEO_PROD_COST:;
 
 
* End of changes for CHANGE_ID:ID938326_GEO_PROD_COST;
 
 
***********************************************************************************************;
*************************************  End Change ID938326_GEO_PROD_COST ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID932230 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID932230;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID932230")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID932230;
%goto ID932230;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(M2MICM521);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID932230;
* Insert record into change management table for CHANGE_ID: ID932230;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID932230",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID932230;
 
%end;
 
 
 
 
 
 
proc sql;
delete from &m_di_data..job where job_id in (40);
insert into &m_di_data..job(job_id,job_nm,parent_job_id) values (40,'model_group_validation',-1);
quit;
 
proc sort data=&m_di_data..job force;
by job_id;
run;
 
 
 
* Check for errors while processing CHANGE_ID: ID932230;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID932230;
%put ERROR- Description                              : Add new jobs to tkmi_job_ro for model_group_validation;
%put ERROR- Version                                  : M2MICM521;
%put ERROR- Date of Change                           : 1MAR2013;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID932230;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID932230",
"Add new jobs to tkmi_job_ro for model_group_validation",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID932230:;
 
 
* End of changes for CHANGE_ID:ID932230;
 
 
***********************************************************************************************;
*************************************  End Change ID932230 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID938326_RPP_PLAN_COST ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID938326_RPP_PLAN_COST;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID938326_RPP_PLAN_COST")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID938326_RPP_PLAN_COST;
%goto ID938326_RPP_PLAN_COST;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(M2MICM521);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID938326_RPP_PLAN_COST;
* Insert record into change management table for CHANGE_ID: ID938326_RPP_PLAN_COST;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID938326_RPP_PLAN_COST",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID938326_RPP_PLAN_COST;
 
%end;
 
 
 
 
 
 
proc sql;
delete from &m_di_mon..job_param where
upcase(jobname) = "LOAD_SRC2STG_RPP_PLAN_COST" and
param_name = 'etlp_src_file'
;
Insert into &m_di_mon..job_param(jobname, param_name, param_value, default_func)
values("LOAD_SRC2STG_RPP_PLAN_COST","etlp_src_file", "/data/stg_rpp_plan_cost.csv",'"Y"' );
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID938326_RPP_PLAN_COST;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID938326_RPP_PLAN_COST;
%put ERROR- Description                              : Add etlp_src_file for job LOAD_SRC2STG_RPP_PLAN_COST;
%put ERROR- Version                                  : M2MICM521;
%put ERROR- Date of Change                           : 06MAR2013;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID938326_RPP_PLAN_COST;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID938326_RPP_PLAN_COST",
"Add etlp_src_file for job LOAD_SRC2STG_RPP_PLAN_COST",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID938326_RPP_PLAN_COST:;
 
 
* End of changes for CHANGE_ID:ID938326_RPP_PLAN_COST;
 
 
***********************************************************************************************;
*************************************  End Change ID938326_RPP_PLAN_COST ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID945908_2 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID945908_2;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID945908_2")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID945908_2;
%goto ID945908_2;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(M2MICM521);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID945908_2;
* Insert record into change management table for CHANGE_ID: ID945908_2;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID945908_2",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID945908_2;
 
%end;
 
 
 
 
 
proc sql;
 
delete from &m_di_data..VENDOR where VENDOR_SK = -1 ;
 
insert into &m_di_data..VENDOR (VENDOR_SK, VENDOR_ID, VENDOR_NM)
values (-1,'MULTIPLE_VENDORS', 'Multiple Vendors');
 
 
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID945908_2;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID945908_2;
%put ERROR- Description                              : Multiple Vendors Per Promotion;
%put ERROR- Version                                  : M2MICM521;
%put ERROR- Date of Change                           : 06MAR2013;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID945908_2;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID945908_2",
"Multiple Vendors Per Promotion",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID945908_2:;
 
 
* End of changes for CHANGE_ID:ID945908_2;
 
 
***********************************************************************************************;
*************************************  End Change ID945908_2 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID949482 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID949482;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID949482")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID949482;
%goto ID949482;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(M2MICM521);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID949482;
* Insert record into change management table for CHANGE_ID: ID949482;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID949482",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID949482;
 
%end;
 
 
 
 
 
 
proc sql;
 
DELETE FROM &m_di_data..GLOBAL_SETTING
WHERE SPEC_NM ='MAX_NUM_PROD_REL_RULE_INSTANCES' and APP = 'RPO';
 
INSERT INTO &m_di_data..GLOBAL_SETTING (SPEC_NM,APP,SPEC_VALUE,SPEC_DESC) VALUES
('MAX_NUM_PROD_REL_RULE_INSTANCES','RPO','10000',
'Indicates the maximum number of product relationship rules that can be defined between two sets of products.');
 
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID949482;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID949482;
%put ERROR- Description                              : New global setting MAX_NUM_PROD_REL_RULE_INSTANCES;
%put ERROR- Version                                  : M2MICM521;
%put ERROR- Date of Change                           : 07MAR2013;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID949482;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID949482",
"New global setting MAX_NUM_PROD_REL_RULE_INSTANCES",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID949482:;
 
 
* End of changes for CHANGE_ID:ID949482;
 
 
***********************************************************************************************;
*************************************  End Change ID949482 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID938326_GEO_PROD_COST_1 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID938326_GEO_PROD_COST_1;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID938326_GEO_PROD_COST_1")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID938326_GEO_PROD_COST_1;
%goto ID938326_GEO_PROD_COST_1;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(M2MICM521);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID938326_GEO_PROD_COST_1;
* Insert record into change management table for CHANGE_ID: ID938326_GEO_PROD_COST_1;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID938326_GEO_PROD_COST_1",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID938326_GEO_PROD_COST_1;
 
%end;
 
 
 
 
 
 
proc sql;
alter table &m_didm_stg..STG_GEO_PROD_COST add NOT NULL (INVOICE_COST);
quit;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID938326_GEO_PROD_COST_1;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID938326_GEO_PROD_COST_1;
%put ERROR- Description                              : Consolidation of cost_fact and cost_fact_future stage tables;
%put ERROR- Version                                  : M2MICM521;
%put ERROR- Date of Change                           : 08MAR2013;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID938326_GEO_PROD_COST_1;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID938326_GEO_PROD_COST_1",
"Consolidation of cost_fact and cost_fact_future stage tables",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID938326_GEO_PROD_COST_1:;
 
 
* End of changes for CHANGE_ID:ID938326_GEO_PROD_COST_1;
 
 
***********************************************************************************************;
*************************************  End Change ID938326_GEO_PROD_COST_1 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change FIX_PARAM_DIFFS ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: FIX_PARAM_DIFFS;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("FIX_PARAM_DIFFS")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : FIX_PARAM_DIFFS;
%goto FIX_PARAM_DIFFS;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(M2MICM521);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : FIX_PARAM_DIFFS;
* Insert record into change management table for CHANGE_ID: FIX_PARAM_DIFFS;
proc sql;
insert  into di_data.data_model_change_management
values (
"FIX_PARAM_DIFFS",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto FIX_PARAM_DIFFS;
 
%end;
 
 
 
 
 
 
proc sql noprint;
 
delete from &m_di_mon..job_param where param_name='etlp_exclude_recs_prev_export'
and jobname='ALLJOBS';
 
delete from &m_di_mon..job_param
where jobname='LOAD_SRC2STG_PROD_REPLACEMENT';
 
delete from &m_di_mon..job_param
where jobname= "LOAD_SRC2STG_PRODUCT_REPLACEMENT" and param_name="etlp_src_file" ;
 
insert into &m_di_mon..job_param(jobname, param_name, param_value, default_func)
values("LOAD_SRC2STG_PRODUCT_REPLACEMENT","etlp_src_file", "/data/stg_product_replacement.csv",'"Y"' );
 
delete from &m_di_mon..job_param
where jobname= "LOAD_SRC2STG_PRICE_POINT_CORRECTION" and param_name="etlp_src_file" ;
 
 
insert into &m_di_mon..job_param(jobname, param_name, param_value, default_func)
values("LOAD_SRC2STG_PRICE_POINT_CORRECTION","etlp_src_file", "/data/stg_price_point_correction.csv",'"Y"' );
 
 
delete from &m_di_mon..job_param
where jobname= "LOAD_SRC2STG_PLAN_EXPORT" and param_name="etlp_src_file" ;
 
insert into &m_di_mon..job_param(jobname, param_name, param_value, default_func)
values("LOAD_SRC2STG_PLAN_EXPORT","etlp_src_file", "/data/stg_plan_export.csv",'"Y"' );
 
delete from &m_di_mon..job_param
where jobname= "LOAD_SRC2STG_HIERARCHY_DELETE" and param_name="etlp_src_file" ;
 
insert into &m_di_mon..job_param(jobname, param_name, param_value, default_func)
values("LOAD_SRC2STG_HIERARCHY_DELETE","etlp_src_file", "/data/stg_hierarchy_delete.csv",'"Y"' );
 
delete from &m_di_mon..job_param
where jobname in ('LOAD_SRC2STG_HALO_PRODUCTS', 'LOAD_SRC2STG_GEO_STORE');
 
delete from &m_di_mon..job_param
where jobname= "LOAD_SRC2STG_GEO_PROD_PURGE_LIST" and param_name="etlp_src_file" ;
 
insert into &m_di_mon..job_param(jobname, param_name, param_value, default_func)
values("LOAD_SRC2STG_GEO_PROD_PURGE_LIST","etlp_src_file", "/data/stg_geo_prod_purge_list.csv",'"Y"' );
 
update &m_di_mon..job_param
set default_func='"1"'
where jobname='DI_EXPORT_SALES_FORECAST'
and param_name='etlp_geo_hier_assoc_cd'
;
 
 
quit;
 
 
 
* Check for errors while processing CHANGE_ID: FIX_PARAM_DIFFS;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: FIX_PARAM_DIFFS;
%put ERROR- Description                              : Fix differences found in parameter values;
%put ERROR- Version                                  : M2MICM521;
%put ERROR- Date of Change                           : 07MAR2013;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: FIX_PARAM_DIFFS;
proc sql;
insert  into di_data.data_model_change_management
values (
"FIX_PARAM_DIFFS",
"Fix differences found in parameter values",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%FIX_PARAM_DIFFS:;
 
 
* End of changes for CHANGE_ID:FIX_PARAM_DIFFS;
 
 
***********************************************************************************************;
*************************************  End Change FIX_PARAM_DIFFS ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID938326_PLAN_TYPE ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID938326_PLAN_TYPE;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID938326_PLAN_TYPE")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID938326_PLAN_TYPE;
%goto ID938326_PLAN_TYPE;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(M2MICM521);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID938326_PLAN_TYPE;
* Insert record into change management table for CHANGE_ID: ID938326_PLAN_TYPE;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID938326_PLAN_TYPE",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID938326_PLAN_TYPE;
 
%end;
 
 
 
 
 
proc sql;
delete from &m_di_data..Reference_values
where upcase(field_nm)="PLAN_TYPE";
 
insert into &m_di_data..Reference_values (FIELD_NM, FIELD_VALUE, FIELD_SHORT_DESC) values ('PLAN_TYPE','0','Active Plan');
insert into &m_di_data..Reference_values (FIELD_NM, FIELD_VALUE, FIELD_SHORT_DESC) values ('PLAN_TYPE','1','Alternate Plan');
insert into &m_di_data..Reference_values (FIELD_NM, FIELD_VALUE, FIELD_SHORT_DESC) values ('PLAN_TYPE','2','Include Versioned Plan');
insert into &m_di_data..Reference_values (FIELD_NM, FIELD_VALUE, FIELD_SHORT_DESC) values ('PLAN_TYPE','3','Excluded Versioned Plan');
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID938326_PLAN_TYPE;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID938326_PLAN_TYPE;
%put ERROR- Description                              : Add plan type=3 (excluded plans) and set plan type=2 for Regional plans;
%put ERROR- Version                                  : M2MICM521;
%put ERROR- Date of Change                           : 11MAR2013;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID938326_PLAN_TYPE;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID938326_PLAN_TYPE",
"Add plan type=3 (excluded plans) and set plan type=2 for Regional plans",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID938326_PLAN_TYPE:;
 
 
* End of changes for CHANGE_ID:ID938326_PLAN_TYPE;
 
 
***********************************************************************************************;
*************************************  End Change ID938326_PLAN_TYPE ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID938326_GEO_PROD_COST_2 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID938326_GEO_PROD_COST_2;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID938326_GEO_PROD_COST_2")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID938326_GEO_PROD_COST_2;
%goto ID938326_GEO_PROD_COST_2;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(M2MICM521);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID938326_GEO_PROD_COST_2;
* Insert record into change management table for CHANGE_ID: ID938326_GEO_PROD_COST_2;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID938326_GEO_PROD_COST_2",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID938326_GEO_PROD_COST_2;
 
%end;
 
 
 
 
 
 
proc sql;
 
delete from &m_di_mon..job_param
where upper(jobname) ="LOAD_STG2DM_GEO_PROD_COST_FACT" and
upper(param_name)="FULL_REFRESH";
 
delete from &m_di_mon..job_param
where upper(jobname) ="LOAD_STG2DM_GEO_PROD_COST_FACT" and
upper(param_name)="FUTURE_FULL_REFRESH";
 
Insert into &m_di_mon..job_param(jobname, param_name, param_value, default_func)
values("LOAD_STG2DM_GEO_PROD_COST_FACT","Future_full_refresh","",'"0"');
;
quit;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID938326_GEO_PROD_COST_2;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID938326_GEO_PROD_COST_2;
%put ERROR- Description                              : Changing the job parameter name from FULL_REFRESH to FUTURE_FULL_REFRESH;
%put ERROR- Version                                  : M2MICM521;
%put ERROR- Date of Change                           : 14MAR2013;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID938326_GEO_PROD_COST_2;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID938326_GEO_PROD_COST_2",
"Changing the job parameter name from FULL_REFRESH to FUTURE_FULL_REFRESH",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID938326_GEO_PROD_COST_2:;
 
 
* End of changes for CHANGE_ID:ID938326_GEO_PROD_COST_2;
 
 
***********************************************************************************************;
*************************************  End Change ID938326_GEO_PROD_COST_2 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID938326_GEO_PROD_PRICE_1 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID938326_GEO_PROD_PRICE_1;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID938326_GEO_PROD_PRICE_1")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID938326_GEO_PROD_PRICE_1;
%goto ID938326_GEO_PROD_PRICE_1;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(M2MICM521);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID938326_GEO_PROD_PRICE_1;
* Insert record into change management table for CHANGE_ID: ID938326_GEO_PROD_PRICE_1;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID938326_GEO_PROD_PRICE_1",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID938326_GEO_PROD_PRICE_1;
 
%end;
 
 
 
 
 
 
proc sql;
 
delete from &m_di_mon..job_param
where upper(jobname) ="LOAD_STG2DM_GEO_PROD_PRICE_FACT" and
upper(param_name)="FULL_REFRESH";
 
delete from &m_di_mon..job_param
where upper(jobname) ="LOAD_STG2DM_GEO_PROD_PRICE_FACT" and
upper(param_name)="FUTURE_FULL_REFRESH";
 
Insert into &m_di_mon..job_param(jobname, param_name, param_value, default_func)
values("LOAD_STG2DM_GEO_PROD_PRICE_FACT","Future_full_refresh","",'"0"');
 
quit;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID938326_GEO_PROD_PRICE_1;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID938326_GEO_PROD_PRICE_1;
%put ERROR- Description                              : Changing the job parameter name from FULL_REFRESH to FUTURE_FULL_REFRESH;
%put ERROR- Version                                  : M2MICM521;
%put ERROR- Date of Change                           : 14MAR2013;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID938326_GEO_PROD_PRICE_1;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID938326_GEO_PROD_PRICE_1",
"Changing the job parameter name from FULL_REFRESH to FUTURE_FULL_REFRESH",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID938326_GEO_PROD_PRICE_1:;
 
 
* End of changes for CHANGE_ID:ID938326_GEO_PROD_PRICE_1;
 
 
***********************************************************************************************;
*************************************  End Change ID938326_GEO_PROD_PRICE_1 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID953719 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID953719;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID953719")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID953719;
%goto ID953719;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(M2MICM521);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID953719;
* Insert record into change management table for CHANGE_ID: ID953719;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID953719",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID953719;
 
%end;
 
 
 
 
 
 
proc sql;
 
delete from &m_di_mon..job_param
where upper(jobname) ="DI_ETL_SET_INVENTORY_PRICE_COST";
 
Insert into &m_di_mon..job_param(jobname, param_name, param_value, default_func)
values("DI_ETL_SET_INVENTORY_PRICE_COST","etlp_cost_as_pct_of_price","",'"0.5"');
 
quit;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID953719;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID953719;
%put ERROR- Description                              : Default value for cost-to-price-ratio for derivation of Inv-cost and Inv-retail;
%put ERROR- Version                                  : M2MICM521;
%put ERROR- Date of Change                           : 15MAR2013;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID953719;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID953719",
"Default value for cost-to-price-ratio for derivation of Inv-cost and Inv-retail",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID953719:;
 
 
* End of changes for CHANGE_ID:ID953719;
 
 
***********************************************************************************************;
*************************************  End Change ID953719 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID953719_JOBPARAM ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID953719_JOBPARAM;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID953719_JOBPARAM")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID953719_JOBPARAM;
%goto ID953719_JOBPARAM;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(M2MICM521);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID953719_JOBPARAM;
* Insert record into change management table for CHANGE_ID: ID953719_JOBPARAM;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID953719_JOBPARAM",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID953719_JOBPARAM;
 
%end;
 
 
 
 
 
 
proc sql;
delete from &m_di_mon..job_param
where upper(jobname) ="DI_ETL_SET_INVENTORY_PRICE_COST"
and param_name = "etlp_use_cost_type";
 
Insert into &m_di_mon..job_param(jobname, param_name, param_value,default_func)
values("DI_ETL_SET_INVENTORY_PRICE_COST","etlp_use_cost_type","1",'"1"');
 
quit;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID953719_JOBPARAM;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID953719_JOBPARAM;
%put ERROR- Description                              : Added a job param to use either invoice or landed cost for Inv_cost calculation;
%put ERROR- Version                                  : M2MICM521;
%put ERROR- Date of Change                           : 20MAR2013;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID953719_JOBPARAM;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID953719_JOBPARAM",
"Added a job param to use either invoice or landed cost for Inv_cost calculation",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID953719_JOBPARAM:;
 
 
* End of changes for CHANGE_ID:ID953719_JOBPARAM;
 
 
***********************************************************************************************;
*************************************  End Change ID953719_JOBPARAM ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID938326_GEO_PROD_COST_3 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID938326_GEO_PROD_COST_3;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID938326_GEO_PROD_COST_3")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID938326_GEO_PROD_COST_3;
%goto ID938326_GEO_PROD_COST_3;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(M2MICM521);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID938326_GEO_PROD_COST_3;
* Insert record into change management table for CHANGE_ID: ID938326_GEO_PROD_COST_3;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID938326_GEO_PROD_COST_3",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID938326_GEO_PROD_COST_3;
 
%end;
 
 
 
 
 
%di_util_drop_constraint(m_lib=&m_didm_stg., m_table=STG_GEO_PROD_COST, m_column=%str(INVOICE_COST), m_constraint=%str(not null));
 
 
 
* Check for errors while processing CHANGE_ID: ID938326_GEO_PROD_COST_3;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID938326_GEO_PROD_COST_3;
%put ERROR- Description                              : Drop constraints on column INVOICE_COST;
%put ERROR- Version                                  : M2MICM521;
%put ERROR- Date of Change                           : 25MAR2013;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID938326_GEO_PROD_COST_3;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID938326_GEO_PROD_COST_3",
"Drop constraints on column INVOICE_COST",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID938326_GEO_PROD_COST_3:;
 
 
* End of changes for CHANGE_ID:ID938326_GEO_PROD_COST_3;
 
 
***********************************************************************************************;
*************************************  End Change ID938326_GEO_PROD_COST_3 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID881597 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID881597;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID881597")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID881597;
%goto ID881597;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(M3MICM521);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID881597;
* Insert record into change management table for CHANGE_ID: ID881597;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID881597",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID881597;
 
%end;
 
 
 
 
 
 
 
 
data &m_didm_stg..STG_CURRENCY;
attrib GEO_ID                              length=$32                                           ;
attrib CURRENCY_ID                         length=$3                                            ;
attrib LOCAL_TO_GLOBAL_CONV_RATE           length=8      FORMAT=NLNUM12.4   INFORMAT=NLNUM12.4  ;
stop; run;
 
proc sql;
alter table &m_didm_stg..STG_CURRENCY add NOT NULL (CURRENCY_ID);
alter table &m_didm_stg..STG_CURRENCY add NOT NULL (LOCAL_TO_GLOBAL_CONV_RATE);
quit;
 
 
data &m_di_mon..STG_CURRENCY_X;
attrib GEO_ID                              length=$32                                           ;
attrib CURRENCY_ID                         length=$3                                            ;
attrib LOCAL_TO_GLOBAL_CONV_RATE           length=8      FORMAT=NLNUM12.4   INFORMAT=NLNUM12.4  ;
attrib ETLS_EXCEPTION_COND length=$150 ;
attrib ETL_ERROR_JOBRUNTIME length=8 format = datetime16. ;
STOP;
run;
 
 
 
* Check for errors while processing CHANGE_ID: ID881597;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID881597;
%put ERROR- Description                              : Create staging tables for Currency dimension;
%put ERROR- Version                                  : M3MICM521;
%put ERROR- Date of Change                           : 30APR2013;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID881597;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID881597",
"Create staging tables for Currency dimension",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID881597:;
 
 
* End of changes for CHANGE_ID:ID881597;
 
 
***********************************************************************************************;
*************************************  End Change ID881597 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID881597_2 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID881597_2;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID881597_2")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_data..CURRENCY_DM))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_data..CURRENCY_DM;
%put NOTE- Change ID                             :ID881597_2;
%goto ID881597_2;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID881597_2;
%goto ID881597_2;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(M3MICM521);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID881597_2;
* Insert record into change management table for CHANGE_ID: ID881597_2;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID881597_2",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID881597_2;
 
%end;
 
 
 
 
 
 
 
 
proc sql;
 
drop table &m_di_data..CURRENCY_DM;
 
quit;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID881597_2;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID881597_2;
%put ERROR- Description                              : Drop currency dimension from SAS side if it exists;
%put ERROR- Version                                  : M3MICM521;
%put ERROR- Date of Change                           : 09MAY2013;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID881597_2;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID881597_2",
"Drop currency dimension from SAS side if it exists",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID881597_2:;
 
 
* End of changes for CHANGE_ID:ID881597_2;
 
 
***********************************************************************************************;
*************************************  End Change ID881597_2 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID930467 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID930467;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID930467")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID930467;
%goto ID930467;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(M3MICM521);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID930467;
* Insert record into change management table for CHANGE_ID: ID930467;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID930467",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID930467;
 
%end;
 
 
 
 
 
proc sql;
delete from &m_di_mon..job_param
where upcase(jobname) in ("DI_ETL_CREATE_PRF_META");
 
insert into &m_di_mon..job_param (jobname, param_name, param_value, default_func)
values("DI_ETL_CREATE_PRF_META","create_prf_meta","",'"ALL"');
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID930467;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID930467;
%put ERROR- Description                              : Add parameter create_prf_meta to job_param for the DI_ETL_CREATE_PRF_META job to recreate _meta table;
%put ERROR- Version                                  : M3MICM521;
%put ERROR- Date of Change                           : 03MAY2013;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID930467;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID930467",
"Add parameter create_prf_meta to job_param for the DI_ETL_CREATE_PRF_META job to recreate _meta table",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID930467:;
 
 
* End of changes for CHANGE_ID:ID930467;
 
 
***********************************************************************************************;
*************************************  End Change ID930467 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID918617 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID918617;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID918617")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_data..GLOBAL_SETTING))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_data..GLOBAL_SETTING;
%put NOTE- Change ID                             :ID918617;
%goto ID918617;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID918617;
%goto ID918617;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(M3MICM521);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID918617;
* Insert record into change management table for CHANGE_ID: ID918617;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID918617",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID918617;
 
%end;
 
 
 
 
 
 
proc sql;
DELETE from &m_di_data..GLOBAL_SETTING where SPEC_NM = 'DEMAND_MULTIPLIER_CUTOFFS';
DELETE from &m_di_data..GLOBAL_SETTING where SPEC_NM = 'OUTLIER_GEO_LVL';
DELETE from &m_di_data..GLOBAL_SETTING where SPEC_NM = 'PRICE_ZONE_LVL';
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID918617;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID918617;
%put ERROR- Description                              : Remove global settings DEMAND_MULTIPLIER_CUTOFFS, OUTLIER_GEO_LVL, PRICE_ZONE_LVL;
%put ERROR- Version                                  : M3MICM521;
%put ERROR- Date of Change                           : 03MAY2013;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID918617;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID918617",
"Remove global settings DEMAND_MULTIPLIER_CUTOFFS, OUTLIER_GEO_LVL, PRICE_ZONE_LVL",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID918617:;
 
 
* End of changes for CHANGE_ID:ID918617;
 
 
***********************************************************************************************;
*************************************  End Change ID918617 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID867499 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID867499;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID867499")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_data..GLOBAL_SETTING))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_data..GLOBAL_SETTING;
%put NOTE- Change ID                             :ID867499;
%goto ID867499;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID867499;
%goto ID867499;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(M3MICM521);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID867499;
* Insert record into change management table for CHANGE_ID: ID867499;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID867499",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID867499;
 
%end;
 
 
 
 
 
 
proc sql;
DELETE from &m_di_data..GLOBAL_SETTING where SPEC_NM = 'ALLOW_AUTO_REEVALUATE';
DELETE from &m_di_data..GLOBAL_SETTING where SPEC_NM = 'DUE_DATE_LEAD_TIME';
DELETE from &m_di_data..GLOBAL_SETTING where SPEC_NM = 'TPC_START_LEAD_TIME';
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID867499;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID867499;
%put ERROR- Description                              : Remove global settings ALLOW_AUTO_REEVALUATE, DUE_DATE_LEAD_TIME, TPC_START_LEAD_TIME;
%put ERROR- Version                                  : M3MICM521;
%put ERROR- Date of Change                           : 03MAY2013;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID867499;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID867499",
"Remove global settings ALLOW_AUTO_REEVALUATE, DUE_DATE_LEAD_TIME, TPC_START_LEAD_TIME",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID867499:;
 
 
* End of changes for CHANGE_ID:ID867499;
 
 
***********************************************************************************************;
*************************************  End Change ID867499 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID962898 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID962898;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID962898")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_data..GLOBAL_SETTING))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_data..GLOBAL_SETTING;
%put NOTE- Change ID                             :ID962898;
%goto ID962898;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID962898;
%goto ID962898;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(M3MICM521);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID962898;
* Insert record into change management table for CHANGE_ID: ID962898;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID962898",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID962898;
 
%end;
 
 
 
 
 
 
proc sql;
DELETE from &m_di_data..GLOBAL_SETTING where SPEC_NM = 'USE_MILP';
quit;
 
 
 
* Check for errors while processing CHANGE_ID: ID962898;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID962898;
%put ERROR- Description                              : Remove global setting USE_MILP;
%put ERROR- Version                                  : M3MICM521;
%put ERROR- Date of Change                           : 06MAY2013;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID962898;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID962898",
"Remove global setting USE_MILP",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID962898:;
 
 
* End of changes for CHANGE_ID:ID962898;
 
 
***********************************************************************************************;
*************************************  End Change ID962898 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID40866 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID40866;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID40866")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID40866;
%goto ID40866;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(M3MICM521);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID40866;
* Insert record into change management table for CHANGE_ID: ID40866;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID40866",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID40866;
 
%end;
 
 
 
 
 
 
proc sql;
select count (*) into :_exists from &m_di_data..global_setting
where spec_nm = 'UPDATE_PROFILE_LOOKUP_STATS';
quit;
 
%if &_exists = 0 %then %do;
proc sql;
insert into &m_di_data..global_setting (SPEC_NM,APP,SPEC_VALUE,SPEC_DESC) values
('UPDATE_PROFILE_LOOKUP_STATS','SZPK','1',
'Indicates whether the PROFILE_LOOKUP_STAT table is updated when a profile is returned.');
quit;
%end;
%else %do;
proc sql;
select spec_value into :_current_val from &m_di_data..global_setting
where spec_nm = 'UPDATE_PROFILE_LOOKUP_STATS';
quit;
%if &_current_val NE '0' or &_current_val NE '1' %then %do;
proc sql;
update &m_di_data..global_setting set spec_value = '1' where spec_nm = 'UPDATE_PROFILE_LOOKUP_STATS';
quit;
%end;
proc sql;
update &m_di_data..global_setting set spec_desc =
'Indicates whether the PROFILE_LOOKUP_STAT table is updated when a profile is returned.' where
spec_nm = 'UPDATE_PROFILE_LOOKUP_STATS';
quit;
%end;
 
 
 
* Check for errors while processing CHANGE_ID: ID40866;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID40866;
%put ERROR- Description                              : New global setting UPDATE_PROFILE_LOOKUP_STATS;
%put ERROR- Version                                  : M3MICM521;
%put ERROR- Date of Change                           : 07MAY2013;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID40866;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID40866",
"New global setting UPDATE_PROFILE_LOOKUP_STATS",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID40866:;
 
 
* End of changes for CHANGE_ID:ID40866;
 
 
***********************************************************************************************;
*************************************  End Change ID40866 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID905766 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID905766;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID905766")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID905766;
%goto ID905766;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(M3MICM521);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID905766;
* Insert record into change management table for CHANGE_ID: ID905766;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID905766",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID905766;
 
%end;
 
 
 
 
 
proc sql;
alter table &m_di_mon..stg_rpp_plan_x
add ACTIVE_PLAN_ID char(32)
add WORKFLOW_NM char(40);
quit;
 
proc sql;
alter table &m_didm_stg..stg_rpp_plan
add WORKFLOW_NM char(40);
quit;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID905766;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID905766;
%put ERROR- Description                              : Need to be able to specify workflow states when importing promotions;
%put ERROR- Version                                  : M3MICM521;
%put ERROR- Date of Change                           : 9MAY2013;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID905766;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID905766",
"Need to be able to specify workflow states when importing promotions",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID905766:;
 
 
* End of changes for CHANGE_ID:ID905766;
 
 
***********************************************************************************************;
*************************************  End Change ID905766 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID953266 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID953266;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID953266")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID953266;
%goto ID953266;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(M3MICM521);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID953266;
* Insert record into change management table for CHANGE_ID: ID953266;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID953266",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID953266;
 
%end;
 
 
 
 
 
/* This parameter will provide list of character which are not allowed in ATTR_VALUE when ATTR_TYPE=2 */
proc sql noprint;
 
delete from &m_di_mon..job_param
where jobname in ("LOAD_STG2DM_GEO_ATTRIBUTE_VALUES","LOAD_STG2DM_PROD_ATTRIBUTE_VALUES",
"LOAD_STG2DM_PRODUCT_ATTRIBUTES","LOAD_STG2DM_GEOGRAPHY_ATTRIBUTES") and
param_name="etlp_exclude_char_list";
 
Insert into &m_di_mon..job_param(jobname, param_name, param_value, default_func)
values("LOAD_STG2DM_GEO_ATTRIBUTE_VALUES","etlp_exclude_char_list","",'"|"')
values("LOAD_STG2DM_PROD_ATTRIBUTE_VALUES","etlp_exclude_char_list","",'"|"')
values("LOAD_STG2DM_PRODUCT_ATTRIBUTES","etlp_exclude_char_list","",'"|"')
values("LOAD_STG2DM_GEOGRAPHY_ATTRIBUTES","etlp_exclude_char_list","",'"|"')
;
 
quit;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID953266;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID953266;
%put ERROR- Description                              : Adding a job parameter for Attribute jobs to exclude char list;
%put ERROR- Version                                  : M3MICM521;
%put ERROR- Date of Change                           : 17MAY2013;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID953266;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID953266",
"Adding a job parameter for Attribute jobs to exclude char list",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID953266:;
 
 
* End of changes for CHANGE_ID:ID953266;
 
 
***********************************************************************************************;
*************************************  End Change ID953266 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID918433 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID918433;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID918433")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID918433;
%goto ID918433;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(M3MICM521);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID918433;
* Insert record into change management table for CHANGE_ID: ID918433;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID918433",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID918433;
 
%end;
 
 
 
 
 
 
proc sql;
select count (*) into :_exists from &m_di_data..global_setting
where spec_nm = 'SCHEMA_LOCALES';
quit;
 
%if &_exists = 0 %then %do;
proc sql;
insert into &m_di_data..global_setting (SPEC_NM,APP,SPEC_VALUE,SPEC_DESC) values
('SCHEMA_LOCALES','ALL','', 'Specifies additional languages that are supported.');
quit;
%end;
%else %do;
proc sql;
update &m_di_data..global_setting set spec_desc =
'Specifies additional languages that are supported.' where
spec_nm = 'SCHEMA_LOCALES';
quit;
%end;
 
 
 
* Check for errors while processing CHANGE_ID: ID918433;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID918433;
%put ERROR- Description                              : Add global setting SCHEMA_LOCALES;
%put ERROR- Version                                  : M3MICM521;
%put ERROR- Date of Change                           : 24MAY2013;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID918433;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID918433",
"Add global setting SCHEMA_LOCALES",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID918433:;
 
 
* End of changes for CHANGE_ID:ID918433;
 
 
***********************************************************************************************;
*************************************  End Change ID918433 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ISO_CURR_TABLE_2 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ISO_CURR_TABLE_2;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ISO_CURR_TABLE_2")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ISO_CURR_TABLE_2;
%goto ISO_CURR_TABLE_2;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(M3MICM521);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ISO_CURR_TABLE_2;
* Insert record into change management table for CHANGE_ID: ISO_CURR_TABLE_2;
proc sql;
insert  into di_data.data_model_change_management
values (
"ISO_CURR_TABLE_2",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ISO_CURR_TABLE_2;
 
%end;
 
 
 
 
 
 
 
libname curr_xml xml "%di_util_misc_path()/dbmsc/dl_iso_tble_a1.xml";
 
 
data di_data.iso_currency;
set curr_xml.iso_currency;
if length(alphabetic_code)=3;
if (anyalpha(minor_unit)=0) ;
run;
 
 
libname curr_xml clear;
 
 
 
* Check for errors while processing CHANGE_ID: ISO_CURR_TABLE_2;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ISO_CURR_TABLE_2;
%put ERROR- Description                              : Standard ISO Currency codes;
%put ERROR- Version                                  : M3MICM521;
%put ERROR- Date of Change                           : 29MAY2013;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ISO_CURR_TABLE_2;
proc sql;
insert  into di_data.data_model_change_management
values (
"ISO_CURR_TABLE_2",
"Standard ISO Currency codes",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ISO_CURR_TABLE_2:;
 
 
* End of changes for CHANGE_ID:ISO_CURR_TABLE_2;
 
 
***********************************************************************************************;
*************************************  End Change ISO_CURR_TABLE_2 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID975860_2 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID975860_2;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID975860_2")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID975860_2;
%goto ID975860_2;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(M3MICM521);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID975860_2;
* Insert record into change management table for CHANGE_ID: ID975860_2;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID975860_2",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID975860_2;
 
%end;
 
 
 
 
 
 
 
data &m_di_data..PROD_CROSS_RELATION;
attrib GEO_HIER_SK           length=4;
attrib PROD_HIER_SK          length=6;
attrib CROSS_PROD_HIER_SK    length=6;
attrib CROSS_TYPE            length=$1;
stop;
run;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID975860_2;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID975860_2;
%put ERROR- Description                              : Product cross relation;
%put ERROR- Version                                  : M3MICM521;
%put ERROR- Date of Change                           : 30MAY2013;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID975860_2;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID975860_2",
"Product cross relation",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID975860_2:;
 
 
* End of changes for CHANGE_ID:ID975860_2;
 
 
***********************************************************************************************;
*************************************  End Change ID975860_2 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID881597_3 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID881597_3;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID881597_3")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(&m_di_mon.)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_di_mon.;
%put NOTE- Change ID                             :ID881597_3;
%goto ID881597_3;
 
%end;
%if not (%sysfunc(exist(&m_di_mon..etl_sys_param))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_mon..etl_sys_param;
%put NOTE- Change ID                             :ID881597_3;
%goto ID881597_3;
 
%end;
%if not (%sysfunc(exist(&m_di_mon..job_param))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_mon..job_param;
%put NOTE- Change ID                             :ID881597_3;
%goto ID881597_3;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID881597_3;
%goto ID881597_3;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(M3MICM521);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID881597_3;
* Insert record into change management table for CHANGE_ID: ID881597_3;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID881597_3",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID881597_3;
 
%end;
 
 
 
 
 
proc sql;
 
delete from &m_di_mon..job_param
where upcase(JOBNAME) = "LOAD_STG2DM_CURRENCY_DM"
and upcase(PARAM_NAME) = "FULL_REFRESH";
 
insert into &m_di_mon..job_param(JOBNAME, PARAM_NAME, PARAM_VALUE, DEFAULT_FUNC)
values ("LOAD_STG2DM_CURRENCY_DM","Full_refresh", "", '"0"');
 
delete
from   &m_di_mon..ETL_SYS_PARAM
where  upcase(JOBNAME) = "LOAD_STG2DM_CURRENCY_DM"
and  lowcase(PARAM_NAME) = "etlp_exception_table";
 
insert into &m_di_mon..ETL_SYS_PARAM values
("LOAD_STG2DM_CURRENCY_DM","etlp_exception_table","DI_MON.STG_CURRENCY_X",'"DI_MON.STG_CURRENCY_X"'  );
 
delete
from  &m_di_mon..job_param
where upcase(jobname) = "LOAD_SRC2STG_CURRENCY"
and lowcase(param_name) = "etlp_src_file"
;
 
insert into &m_di_mon..job_param (jobname, param_name, param_value, default_func)
values("LOAD_SRC2STG_CURRENCY","etlp_src_file","/data/stg_currency.csv",'"Y"')
;
 
quit;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID881597_3;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID881597_3;
%put ERROR- Description                              : Add parameters in job_param and etl_sys_param;
%put ERROR- Version                                  : M3MICM521;
%put ERROR- Date of Change                           : 31MAY2013;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID881597_3;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID881597_3",
"Add parameters in job_param and etl_sys_param",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID881597_3:;
 
 
* End of changes for CHANGE_ID:ID881597_3;
 
 
***********************************************************************************************;
*************************************  End Change ID881597_3 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID918433_STG_TABLES ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID918433_STG_TABLES;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID918433_STG_TABLES")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID918433_STG_TABLES;
%goto ID918433_STG_TABLES;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(M3MICM521);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID918433_STG_TABLES;
* Insert record into change management table for CHANGE_ID: ID918433_STG_TABLES;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID918433_STG_TABLES",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID918433_STG_TABLES;
 
%end;
 
 
 
 
 
 
 
data &m_didm_stg..STG_PRODUCT_LANG;
attrib PROD_ID                             length=$32                                          ;
attrib LANG_CD                             length=$11                                          ;
attrib PROD_NM                             length=$160                                         ;
attrib PROD_DESC                           length=$400                                         ;
attrib VOLUME_BASE_UOM                     length=$80                                          ;
attrib BRAND_NM                            length=$160                                         ;
stop; run;
 
 
proc sql;
alter table &m_didm_stg..STG_PRODUCT_LANG add NOT NULL (PROD_ID);
alter table &m_didm_stg..STG_PRODUCT_LANG add NOT NULL (LANG_CD);
quit;
 
 
 
 
data &m_didm_stg..STG_GEOGRAPHY_LANG;
attrib GEO_ID                              length=$32                                         ;
attrib LANG_CD                             length=$11                                          ;
attrib GEO_NM                              length=$160                                         ;
attrib STREET_ADDRESS                      length=$400                                         ;
attrib CITY                                length=$80                                          ;
attrib STATE                               length=$80                                          ;
attrib ZIP_CODE                            length=$80                                          ;
attrib COUNTRY                             length=$80                                          ;
stop; run;
 
 
proc sql;
alter table &m_didm_stg..STG_GEOGRAPHY_LANG add NOT NULL (GEO_ID);
alter table &m_didm_stg..STG_GEOGRAPHY_LANG add NOT NULL (LANG_CD);
quit;
 
 
 
 
data &m_didm_stg..STG_ATTRIBUTE_LANG;
attrib ATTR_NM                             length=$40                                          ;
attrib LANG_CD                             length=$11                                          ;
attrib ATTR_NM_LANG                        length=$160                                         ;
stop; run;
 
 
proc sql;
alter table &m_didm_stg..STG_ATTRIBUTE_LANG add NOT NULL (ATTR_NM);
alter table &m_didm_stg..STG_ATTRIBUTE_LANG add NOT NULL (LANG_CD);
alter table &m_didm_stg..STG_ATTRIBUTE_LANG add NOT NULL (ATTR_NM_LANG);
quit;
 
 
data &m_didm_stg..STG_ATTRIBUTE_VALUES_LANG;
attrib ATTR_NM                             length=$40                                          ;
attrib LANG_CD                             length=$11                                          ;
attrib OBJECT_TYPE                         length=$1                                           ;
attrib OBJECT_ID                           length=$32                                         ;
attrib ATTR_VALUE                          length=$160                                         ;
stop; run;
 
 
proc sql;
alter table &m_didm_stg..STG_ATTRIBUTE_VALUES_LANG add NOT NULL (ATTR_NM);
alter table &m_didm_stg..STG_ATTRIBUTE_VALUES_LANG add NOT NULL (LANG_CD);
alter table &m_didm_stg..STG_ATTRIBUTE_VALUES_LANG add NOT NULL (OBJECT_TYPE);
alter table &m_didm_stg..STG_ATTRIBUTE_VALUES_LANG add NOT NULL (OBJECT_ID);
alter table &m_didm_stg..STG_ATTRIBUTE_VALUES_LANG add NOT NULL (ATTR_VALUE);
quit;
 
 
 
data &m_didm_stg..STG_FIELD_LOOKUP_LANG;
attrib FIELD_NM                            length=$32                                        ;
attrib TABLE_NAME                          length=$32                                        ;
attrib FIELD_VALUE                         length=$100                                       ;
attrib LANG_CD                             length=$11                                        ;
attrib FIELD_VALUE_NM                      length=$400                                       ;
attrib FIELD_VALUE_DESC                    length=$400                                       ;
stop; run;
 
 
proc sql;
alter table &m_didm_stg..STG_FIELD_LOOKUP_LANG add NOT NULL (FIELD_NM);
alter table &m_didm_stg..STG_FIELD_LOOKUP_LANG add NOT NULL (TABLE_NAME);
alter table &m_didm_stg..STG_FIELD_LOOKUP_LANG add NOT NULL (FIELD_VALUE);
alter table &m_didm_stg..STG_FIELD_LOOKUP_LANG add NOT NULL (LANG_CD);
quit;
 
 
data &m_didm_stg..STG_PRICE_CHANGE_PRIORITY_LANG;
attrib PRICE_CHG_PRIORITY                  length=4                                          ;
attrib LANG_CD                             length=$11                                        ;
attrib PRICE_CHG_PRIORITY_NM               length=$160                                       ;
stop; run;
 
 
proc sql;
alter table &m_didm_stg..STG_PRICE_CHANGE_PRIORITY_LANG add NOT NULL (PRICE_CHG_PRIORITY);
alter table &m_didm_stg..STG_PRICE_CHANGE_PRIORITY_LANG add NOT NULL (LANG_CD);
alter table &m_didm_stg..STG_PRICE_CHANGE_PRIORITY_LANG add NOT NULL (PRICE_CHG_PRIORITY_NM);
quit;
 
 
 
data &m_di_mon..STG_PRODUCT_LANG_X;
attrib PROD_ID                             length=$32                                          ;
attrib LANG_CD                             length=$11                                          ;
attrib PROD_NM                             length=$160                                         ;
attrib PROD_DESC                           length=$400                                         ;
attrib VOLUME_BASE_UOM                     length=$80                                          ;
attrib BRAND_NM                            length=$160                                         ;
attrib ETLS_EXCEPTION_COND                 length=$300                                         ;
attrib ETL_ERROR_JOBRUNTIME               length=8      format=&DTTMFMT                       ;
stop; run;
 
 
 
data &m_di_mon..STG_GEOGRAPHY_LANG_x;
attrib GEO_ID                              length=$32                                          ;
attrib LANG_CD                             length=$11                                          ;
attrib GEO_NM                              length=$160                                         ;
attrib STREET_ADDRESS                      length=$400                                         ;
attrib CITY                                length=$80                                          ;
attrib STATE                               length=$80                                          ;
attrib ZIP_CODE                            length=$80                                          ;
attrib COUNTRY                             length=$80                                          ;
attrib ETLS_EXCEPTION_COND                 length=$300                                         ;
attrib ETL_ERROR_JOBRUNTIME               length=8      format=&DTTMFMT                       ;
stop; run;
 
data &m_di_mon..STG_ATTRIBUTE_LANG_x;
attrib ATTR_NM                             length=$40                                          ;
attrib LANG_CD                             length=$11                                          ;
attrib ATTR_NM_LANG                        length=$160                                         ;
attrib ETLS_EXCEPTION_COND                 length=$300                                         ;
attrib ETL_ERROR_JOBRUNTIME               length=8      format=&DTTMFMT                       ;
stop; run;
 
 
 
data &m_di_mon..STG_ATTRIBUTE_VALUES_LANG_x;
attrib ATTR_NM                             length=$40                                          ;
attrib LANG_CD                             length=$11                                          ;
attrib OBJECT_TYPE                         length=$1                                           ;
attrib OBJECT_ID                           length=$32                                          ;
attrib ATTR_VALUE                          length=$160                                         ;
attrib ETLS_EXCEPTION_COND                 length=$300                                         ;
attrib ETL_ERROR_JOBRUNTIME               length=8      format=&DTTMFMT                       ;
stop; run;
 
 
data &m_di_mon..STG_FIELD_LOOKUP_LANG_X;
attrib FIELD_NM                            length=$32                                        ;
attrib TABLE_NAME                          length=$32                                        ;
attrib FIELD_VALUE                         length=$100                                       ;
attrib LANG_CD                             length=$11                                        ;
attrib FIELD_VALUE_NM                      length=$400                                       ;
attrib FIELD_VALUE_DESC                    length=$400                                       ;
attrib ETLS_EXCEPTION_COND                 length=$300                                       ;
attrib ETL_ERROR_JOBRUNTIME               length=8      format=&DTTMFMT                     ;
stop; run;
 
 
data &m_di_mon..STG_PRICE_CHANGE_PRIORITY_LANG_X;
attrib PRICE_CHG_PRIORITY                  length=4                                          ;
attrib LANG_CD                             length=$11                                        ;
attrib PRICE_CHG_PRIORITY_NM               length=$160                                       ;
attrib ETLS_EXCEPTION_COND                 length=$300                                       ;
attrib ETL_ERROR_JOBRUNTIME          length=8      format=&DTTMFMT                     ;
stop; run;
 
proc sql;
delete from  &m_di_mon..job_param Where upcase(jobname) eq 'LOAD_SRC2STG_PRODUCT_LANG' and param_name = 'etlp_src_file';
delete from  &m_di_mon..job_param Where upcase(jobname) eq 'LOAD_SRC2STG_GEOGRAPHY_LANG' and param_name = 'etlp_src_file';
delete from  &m_di_mon..job_param Where upcase(jobname) eq 'LOAD_SRC2STG_ATTRIBUTE_LANG' and param_name = 'etlp_src_file';
delete from  &m_di_mon..job_param Where upcase(jobname) eq 'LOAD_SRC2STG_ATTRIBUTE_VALUES_LANG' and param_name = 'etlp_src_file';
delete from  &m_di_mon..job_param Where upcase(jobname) eq 'LOAD_SRC2STG_FIELD_LOOKUP_LANG' and param_name = 'etlp_src_file';
delete from  &m_di_mon..job_param Where upcase(jobname) eq 'LOAD_SRC2STG_PRICE_CHANGE_PRIORITY_LANG' and param_name = 'etlp_src_file';
 
insert into &m_di_mon..job_param
(jobname,                     param_name,       param_value,                 default_func)
values("LOAD_SRC2STG_PRODUCT_LANG", "etlp_src_file", "/data/stg_product_lang.csv", '"Y"' );
insert into &m_di_mon..job_param
(jobname,                     param_name,       param_value,                 default_func)
values("LOAD_SRC2STG_GEOGRAPHY_LANG", "etlp_src_file", "/data/stg_geography_lang.csv", '"Y"' );
insert into &m_di_mon..job_param
(jobname,                     param_name,       param_value,                 default_func)
values("LOAD_SRC2STG_ATTRIBUTE_LANG", "etlp_src_file", "/data/stg_attribute_lang.csv", '"Y"' );
insert into &m_di_mon..job_param
(jobname,                     param_name,       param_value,                 default_func)
values("LOAD_SRC2STG_ATTRIBUTE_VALUES_LANG", "etlp_src_file", "/data/stg_attribute_values_lang.csv", '"Y"' );
insert into &m_di_mon..job_param
(jobname,                     param_name,       param_value,                 default_func)
values("LOAD_SRC2STG_FIELD_LOOKUP_LANG", "etlp_src_file", "/data/stg_field_lookup_lang.csv", '"Y"' );
insert into &m_di_mon..job_param
(jobname,                     param_name,       param_value,                 default_func)
values("LOAD_SRC2STG_PRICE_CHANGE_PRIORITY_LANG", "etlp_src_file", "/data/stg_price_change_priority_lang.csv", '"Y"' );
quit;
 
 
proc sql noprint ;
delete from &m_di_mon..etl_sys_param where upcase(jobname)="LOAD_STG2DM_PRODUCT_DM_LANG" and param_name="etlp_exception_table";
delete from &m_di_mon..etl_sys_param where upcase(jobname)="LOAD_STG2DM_GEOGRAPHY_DM_LANG" and param_name="etlp_exception_table";
delete from &m_di_mon..etl_sys_param where upcase(jobname)="LOAD_STG2DM_ATTRIBUTES_LANG" and param_name="etlp_exception_table";
delete from &m_di_mon..etl_sys_param where upcase(jobname)="LOAD_STG2DM_FIELD_LOOKUP_VALUES_LANG" and param_name="etlp_exception_table";
delete from &m_di_mon..etl_sys_param where upcase(jobname)="LOAD_STG2DM_PRICE_CHANGE_PRIORITY_LANG" and param_name="etlp_exception_table";
delete from &m_di_mon..etl_sys_param where upcase(jobname)="LOAD_STG2DM_GEO_ATTRIBUTE_VALUES_LANG" and param_name="etlp_exception_table";
delete from &m_di_mon..etl_sys_param where upcase(jobname)="LOAD_STG2DM_PROD_ATTRIBUTE_VALUES_LANG" and param_name="etlp_exception_table";
 
Insert into &m_di_mon..etl_sys_param
(jobname, param_name, param_value, default_func)
values("LOAD_STG2DM_PRODUCT_DM_LANG",  "etlp_exception_table", "DI_MON.STG_PRODUCT_LANG_X",  '"DI_MON.STG_PRODUCT_LANG_X"'  )
;
Insert into &m_di_mon..etl_sys_param
(jobname, param_name, param_value, default_func)
values("LOAD_STG2DM_GEOGRAPHY_DM_LANG",  "etlp_exception_table", "DI_MON.STG_GEOGRAPHY_LANG_x",  '"DI_MON.STG_GEOGRAPHY_LANG_x"'  )
;
 
 
Insert into &m_di_mon..etl_sys_param
(jobname, param_name, param_value, default_func)
values("LOAD_STG2DM_ATTRIBUTES_LANG",  "etlp_exception_table", "DI_MON.STG_ATTRIBUTE_LANG_x",  '"DI_MON.STG_ATTRIBUTE_LANG_x"'  )
;
Insert into &m_di_mon..etl_sys_param
(jobname, param_name, param_value, default_func)
values("LOAD_STG2DM_FIELD_LOOKUP_VALUES_LANG",  "etlp_exception_table", "DI_MON.STG_FIELD_LOOKUP_LANG_X",  '"DI_MON.STG_FIELD_LOOKUP_LANG_X"'  )
;
 
 
Insert into &m_di_mon..etl_sys_param
(jobname, param_name, param_value, default_func)
values("LOAD_STG2DM_PRICE_CHANGE_PRIORITY_LANG",  "etlp_exception_table", "DI_MON.STG_PRICE_CHANGE_PRIORITY_LANG_X",  '"DI_MON.STG_PRICE_CHANGE_PRIORITY_LANG_X"'  )
;
Insert into &m_di_mon..etl_sys_param
(jobname, param_name, param_value, default_func)
values("LOAD_STG2DM_GEO_ATTRIBUTE_VALUES_LANG",  "etlp_exception_table", "DI_MON.STG_ATTRIBUTE_VALUES_LANG_x",  '"DI_MON.STG_ATTRIBUTE_VALUES_LANG_x"'  )
;
 
Insert into &m_di_mon..etl_sys_param
(jobname, param_name, param_value, default_func)
values("LOAD_STG2DM_PROD_ATTRIBUTE_VALUES_LANG",  "etlp_exception_table", "DI_MON.STG_ATTRIBUTE_VALUES_LANG_x",  '"DI_MON.STG_ATTRIBUTE_VALUES_LANG_x"'  )
;
 
quit;
 
proc sql noprint ;
delete from &m_di_mon..job_param where upcase(jobname)="DI_REPLICATE_MULTIPLE_TABLES" and param_name="etlp_src_tab10";
 
insert into &m_di_mon..job_param
(jobname,                     param_name,       param_value,                 default_func)
values("DI_REPLICATE_MULTIPLE_TABLES", "etlp_src_tab10", "field_lookup_values", '"Y"' );
quit;
 
proc sql noprint;
delete from &m_di_data..global_setting WHERE spec_nm ='SCHEMA_LOCALES' and app = 'ALL';
 
insert INTO &m_di_data..global_setting
(spec_nm,          app, spec_value,spec_desc) values
('SCHEMA_LOCALES','ALL',  '',      'Multilanguage Supported by the Solution .Run the Job DI_ETL_set_schema_locale to Set this GLOBAL Setting.');
quit;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID918433_STG_TABLES;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID918433_STG_TABLES;
%put ERROR- Description                              : MULTI LANGUAGE ETL;
%put ERROR- Version                                  : M3MICM521;
%put ERROR- Date of Change                           : 31MAY2013;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID918433_STG_TABLES;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID918433_STG_TABLES",
"MULTI LANGUAGE ETL",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID918433_STG_TABLES:;
 
 
* End of changes for CHANGE_ID:ID918433_STG_TABLES;
 
 
***********************************************************************************************;
*************************************  End Change ID918433_STG_TABLES ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID900227_REF_VALUES ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID900227_REF_VALUES;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_data.data_model_change_management (where=(upper(change_id)=upper("ID900227_REF_VALUES")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID900227_REF_VALUES;
%goto ID900227_REF_VALUES;
 
%end;
 
%put ;
 
 
 
 
%let m_version=%str(M3MICM521);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID900227_REF_VALUES;
* Insert record into change management table for CHANGE_ID: ID900227_REF_VALUES;
proc sql;
insert  into di_data.data_model_change_management
values (
"ID900227_REF_VALUES",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID900227_REF_VALUES;
 
%end;
 
 
 
 
 
proc sql;
delete from &m_di_data..reference_values
where (field_nm = 'SETTING_TYPE'
and field_value in ('57','58','59'))
;
 
insert into &m_di_data..ref