%macro apply_rdbms_data_model_changes(
m_di_trans_vendor=di_trans_vendor,    /* Database vendor */
m_di_trans=di_trans,                  /* libref for rdbms data mart library*/
m_di_data=di_data,                    /* libref for sas data mart library*/
m_di_mon=di_mon,                      /* libref for monitor library */
m_didm_stg=didm_stg,                  /* libref for stage library */
m_DTTMFMT=NLDATM21.,                  /* Date time format */
m_DTFMT=DATE9.,                       /* Date format */
m_experimental_changes=FALSE,         /* For developers only */
m_user=&sysuserid                     /* User Applying Change */
) / minoperator;
 
/* Use libref macro variable for legacy code */
%let dtfmt=&m_DTFMT;
%let DTTMFMT=&m_DTTMFMT;
 
*Check if libref &m_di_trans. is assigned;
%let didmExists = %sysfunc(libref(&m_di_trans.));
 
%if not (&didmExists = 0) %then
%do;
%put ERROR: Library referenced by libref "&m_di_trans." is not assigned.;
%put ERROR- Please assign the library for RDBMS data mart and rerun!;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
*Check if libref &m_di_data. is assigned;
%let didmExists = %sysfunc(libref(&m_di_data.));
 
%if not (&didmExists = 0) %then
%do;
%put ERROR: Library referenced by libref "&m_di_data." is not assigned.;
%put ERROR- Please assign the library for SAS data mart and rerun!;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
%local m_user_lib;
%let m_user_lib = %sysfunc(getoption(user));
options user = &m_di_trans;
 
 
*Create rdbms_DM_change_management table if it does not exist;
%*macro create_chg_mgmt_table(m_di_trans=di_trans);
%let m_chgTable=rdbms_DM_change_management;
 
*  Create &m_chgTable table if it does not exist;
%if not %sysfunc(exist(&m_di_trans..&m_chgTable)) %then
%do;
%put NOTE:  Table &m_di_trans..&m_chgTable table does not exist.  Creating new!;
%if (&m_di_trans_vendor in (SAS)) %then %do;
proc sql noprint;
create table &m_chgTable
(
CHANGE_ID varchar(32) NOT NULL,
CHANGE_DESC varchar(100),
DATE_CHANGE_APPLIED date format datetime18. informat datetime18.,
USER_APPLYING_CHANGE varchar(32)
 
);
 
quit;
 
%end;
 
 
%else %if (&m_di_trans_vendor in (DB2)) %then %do;
%let m_sql_statement=%str(
create table &m_chgTable
(
CHANGE_ID varchar(32) NOT NULL,
CHANGE_DESC varchar(100),
DATE_CHANGE_APPLIED timestamp,
USER_APPLYING_CHANGE varchar(32),
primary key (CHANGE_ID)
)
);
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
%end;
 
 
%else %do;
%let m_sql_statement=%str(
create table &m_chgTable
(
CHANGE_ID varchar(32) NOT NULL,
CHANGE_DESC varchar(100),
DATE_CHANGE_APPLIED date,
USER_APPLYING_CHANGE varchar(32),
primary key (CHANGE_ID)
)
);
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
%end;
 
 
%end;
 
 
 
 
%*mend;
 
%*create_chg_mgmt_table(m_di_trans=di_trans);
 
 
 
 
 
 
*Check baseline data model version;
%*macro check_baseline_dm_version(m_di_data=di_data);
%let m_baseline_dm_spec_name=BASELINE_DATA_MODEL_VERSION;
%let m_baseline_dm_spec_value=;
 
*  Code value in Global_setting if it does not exist;
%if not %sysfunc(exist(&m_di_data..global_setting)) %then
%do;
* quit if global_setting table is not present;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
%else
%do;
 
proc sql noprint;
select spec_value
into :m_baseline_dm_spec_value
from &m_di_data..global_setting
where spec_nm="&m_baseline_dm_spec_name"
;
quit;
 
%put NOTE: The value of BASELINE_DATA_MODEL_VERSION global setting is &m_baseline_dm_spec_value
*If BASELINE_DATA_MODEL_VERSION is missing in global_setting table then quit;
%if (&m_baseline_dm_spec_value=) %then
%do;
%put ERROR: &m_di_data..global_setting table must have a spec_value for spec_nm=BASELINE_DATA_MODEL_VERSION and app=ALL.;
%put ERROR- Current valid values are M1MI42 and D2TKMI42;
 
* if fa_spec table exists in di_trans then it is M1MI42 else it is D2TKMI42;
%if %sysfunc(exist(&m_di_trans..fa_spec)) %then
%do;
%let m_baseline_dm_spec_value=M1MI42;
%end;
%else
%do;
%let m_baseline_dm_spec_value=D2TKMI42;
%end;
 
%put NOTE:  Based on current state of schema BASELINE_DATA_MODEL_VERSION is &m_baseline_dm_spec_value;
%put NOTE-  This value is being inserted into global_setting table for spec_nm=BASELINE_DATA_MODEL_VERSION and app=ALL.;
%put NOTE-  Please ensure that this is correct and rerun.;
 
proc sql;
delete from &m_di_data..global_setting
where upper(spec_nm)="BASELINE_DATA_MODEL_VERSION"
and upper(app)="ALL";
 
insert into &m_di_data..global_setting
(spec_nm,app,spec_value,spec_desc)
values
("BASELINE_DATA_MODEL_VERSION","ALL","&m_baseline_dm_spec_value",
"Baseline (original) version of the data model before changes were applied")
;
quit;
 
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
%else
%do;
%let m_baseline_dm_spec_value=&m_baseline_dm_spec_value;
%put NOTE: BASELINE_DATA_MODEL_VERSION from di_trans.global_setting table is &m_baseline_dm_spec_value;
%end;
 
%end;
 
run;
 
%*mend;
 
%*check_baseline_dm_version(m_di_trans=di_trans);
 
 
 
 
***********************************************************************************************;
************************************  Begin Change DATA_MODEL_VERSION_MGMT ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: DATA_MODEL_VERSION_MGMT;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("DATA_MODEL_VERSION_MGMT")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%put NOTE: This change will be applied on every run : DATA_MODEL_VERSION_MGMT;
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
 
data &m_di_data..DATA_MODEL_VERSION_MANAGEMENT;
 
 
attrib VERSION          length=$10  ;
 
 
attrib VERSION_INCLUDED length=$10  ;
 
 
 
VERSION='D2TKMI42'; VERSION_INCLUDED='D2TKMI42'; output;
 
 
VERSION='M1MI42';   VERSION_INCLUDED='M1MI42'; output;
 
 
VERSION='F1MI42';   VERSION_INCLUDED='M1MI42'; output;
 
 
 
VERSION='M2MI42';   VERSION_INCLUDED='M1MI42'; output;
 
 
VERSION='M2MI42';   VERSION_INCLUDED='F1MI42'; output;
 
 
VERSION='M2MI42';   VERSION_INCLUDED='M2MI42'; output;
 
 
 
VERSION='M1TKMI43'; VERSION_INCLUDED='M1TKMI43'; output;
 
 
VERSION='M1TKMI43'; VERSION_INCLUDED='D2TKMI42'; output;
 
 
 
VERSION='M2TKMI43'; VERSION_INCLUDED='M2TKMI43'; output;
 
 
VERSION='M2TKMI43'; VERSION_INCLUDED='M1TKMI43'; output;
 
 
VERSION='M2TKMI43'; VERSION_INCLUDED='D2TKMI42'; output;
 
 
 
VERSION='F2TKMI43'; VERSION_INCLUDED='F2TKMI43'; output;
 
 
VERSION='F2TKMI43'; VERSION_INCLUDED='M2TKMI43'; output;
 
 
VERSION='F2TKMI43'; VERSION_INCLUDED='M1TKMI43'; output;
 
 
VERSION='F2TKMI43'; VERSION_INCLUDED='D2TKMI42'; output;
 
 
run;
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
 
data &m_di_data..DATA_MODEL_VERSION_MANAGEMENT;
 
 
attrib VERSION          length=$10  ;
 
 
attrib VERSION_INCLUDED length=$10  ;
 
 
 
VERSION='D2TKMI42'; VERSION_INCLUDED='D2TKMI42'; output;
 
 
VERSION='M1MI42';   VERSION_INCLUDED='M1MI42'; output;
 
 
VERSION='F1MI42';   VERSION_INCLUDED='M1MI42'; output;
 
 
 
VERSION='M2MI42';   VERSION_INCLUDED='M1MI42'; output;
 
 
VERSION='M2MI42';   VERSION_INCLUDED='F1MI42'; output;
 
 
VERSION='M2MI42';   VERSION_INCLUDED='M2MI42'; output;
 
 
 
VERSION='M1TKMI43'; VERSION_INCLUDED='M1TKMI43'; output;
 
 
VERSION='M1TKMI43'; VERSION_INCLUDED='D2TKMI42'; output;
 
 
 
VERSION='M2TKMI43'; VERSION_INCLUDED='M2TKMI43'; output;
 
 
VERSION='M2TKMI43'; VERSION_INCLUDED='M1TKMI43'; output;
 
 
VERSION='M2TKMI43'; VERSION_INCLUDED='D2TKMI42'; output;
 
 
 
VERSION='F2TKMI43'; VERSION_INCLUDED='F2TKMI43'; output;
 
 
VERSION='F2TKMI43'; VERSION_INCLUDED='M2TKMI43'; output;
 
 
VERSION='F2TKMI43'; VERSION_INCLUDED='M1TKMI43'; output;
 
 
VERSION='F2TKMI43'; VERSION_INCLUDED='D2TKMI42'; output;
 
 
run;
 
 
 
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: DATA_MODEL_VERSION_MGMT;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: DATA_MODEL_VERSION_MGMT;
%put ERROR- Description                              : Data model versions to enable migration from one version to another;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 24JUL2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: DATA_MODEL_VERSION_MGMT;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"DATA_MODEL_VERSION_MGMT",
"Data model versions to enable migration from one version to another",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%DATA_MODEL_VERSION_MGMT:;
 
 
* End of changes for CHANGE_ID:DATA_MODEL_VERSION_MGMT;
 
 
***********************************************************************************************;
*************************************  End Change DATA_MODEL_VERSION_MGMT ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change GET_DM_VERSIONS_FROM_BASE ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: GET_DM_VERSIONS_FROM_BASE;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("GET_DM_VERSIONS_FROM_BASE")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%put NOTE: This change will be applied on every run : GET_DM_VERSIONS_FROM_BASE;
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
 
 
proc sql noprint;
 
 
select version_included into :m_baseline_versions
separated by ","
from &m_di_data..DATA_MODEL_VERSION_MANAGEMENT
where version="&m_baseline_dm_spec_value"
;
 
 
 
quit;
 
 
 
%put NOTE: Baseline Version from global settings table is &m_baseline_dm_spec_value;
 
 
%put NOTE: This baseline version includes changes in tracks: &m_baseline_versions;
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
 
 
proc sql noprint;
 
 
select version_included into :m_baseline_versions
separated by ","
from &m_di_data..DATA_MODEL_VERSION_MANAGEMENT
where version="&m_baseline_dm_spec_value"
;
 
 
 
quit;
 
 
 
%put NOTE: Baseline Version from global settings table is &m_baseline_dm_spec_value;
 
 
%put NOTE: This baseline version includes changes in tracks: &m_baseline_versions;
 
 
 
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: GET_DM_VERSIONS_FROM_BASE;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: GET_DM_VERSIONS_FROM_BASE;
%put ERROR- Description                              : Data model versions to enable migration from one version to another;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 24JUL2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: GET_DM_VERSIONS_FROM_BASE;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"GET_DM_VERSIONS_FROM_BASE",
"Data model versions to enable migration from one version to another",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%GET_DM_VERSIONS_FROM_BASE:;
 
 
* End of changes for CHANGE_ID:GET_DM_VERSIONS_FROM_BASE;
 
 
***********************************************************************************************;
*************************************  End Change GET_DM_VERSIONS_FROM_BASE ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change RDBMS_DM_DROP_CONSTRAINTS ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: RDBMS_DM_DROP_CONSTRAINTS;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("RDBMS_DM_DROP_CONSTRAINTS")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(&m_di_trans.)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_di_trans.;
%put NOTE: Change ID                             :RDBMS_DM_DROP_CONSTRAINTS;
%goto RDBMS_DM_DROP_CONSTRAINTS;
 
%end;
%if not (%sysfunc(exist(&m_di_trans..RDBMS_DM_CHANGE_MANAGEMENT))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_trans..RDBMS_DM_CHANGE_MANAGEMENT;
%put NOTE: Change ID                             :RDBMS_DM_DROP_CONSTRAINTS;
%goto RDBMS_DM_DROP_CONSTRAINTS;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : RDBMS_DM_DROP_CONSTRAINTS;
%goto RDBMS_DM_DROP_CONSTRAINTS;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : RDBMS_DM_DROP_CONSTRAINTS;
* Insert record into change management table for CHANGE_ID: RDBMS_DM_DROP_CONSTRAINTS;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"RDBMS_DM_DROP_CONSTRAINTS",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto RDBMS_DM_DROP_CONSTRAINTS;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
%let m_sql_statement = %str(
alter table RDBMS_DM_CHANGE_MANAGEMENT drop primary key
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
 
data &m_di_trans..rdbms_dm_change_management;
 
 
set &m_di_trans..rdbms_dm_change_management;
 
 
run;
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: RDBMS_DM_DROP_CONSTRAINTS;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: RDBMS_DM_DROP_CONSTRAINTS;
%put ERROR- Description                              : Drop Constraints on RDBMS_DM_CHANGE_MANAGEMENT table;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 11APR2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: RDBMS_DM_DROP_CONSTRAINTS;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"RDBMS_DM_DROP_CONSTRAINTS",
"Drop Constraints on RDBMS_DM_CHANGE_MANAGEMENT table",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%RDBMS_DM_DROP_CONSTRAINTS:;
 
 
* End of changes for CHANGE_ID:RDBMS_DM_DROP_CONSTRAINTS;
 
 
***********************************************************************************************;
*************************************  End Change RDBMS_DM_DROP_CONSTRAINTS ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID00000A ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID00000A;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID00000A")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID00000A;
%goto ID00000A;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D2TKMI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID00000A;
* Insert record into change management table for CHANGE_ID: ID00000A;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID00000A",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID00000A;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
 
 
%if not (%sysfunc(exist(&m_di_trans..TABLE_PARTITION_META))) %then
%do;
 
 
 
%let m_sql_statement = %str(
CREATE TABLE TABLE_PARTITION_META
(
TABLE_NM                           VARCHAR(32) NOT NULL,
FULL_COPY_FLG                      INTEGER NOT NULL,
PARTITION_FLG                      INTEGER NOT NULL,
ESTIMATION_FLG                     INTEGER NOT NULL
)
 
);
 
 
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
ALTER TABLE TABLE_PARTITION_META  add CONSTRAINT TABLE_PARTITION_META_SK  PRIMARY KEY (TABLE_NM)
);
 
 
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%end;
 
 
 
 
 
%if not (%sysfunc(exist(&m_di_trans..TKMI_GRID_DATA_MAP))) %then
%do;
 
 
 
 
%let m_sql_statement = %str(
CREATE TABLE TKMI_GRID_DATA_MAP
(
PROD_HIER_ASSOC_CD                 INTEGER NOT NULL,
PROD_HIER_SK                       INTEGER NOT NULL,
CAPTAIN_NM                         VARCHAR(255),
PARTITION_SIZE                     NUMERIC(20,3)
)
 
);
 
 
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
 
%let m_sql_statement = %str(
ALTER TABLE TKMI_GRID_DATA_MAP  add CONSTRAINT TKMI_GRID_DATA_MAP_SK  PRIMARY KEY (PROD_HIER_ASSOC_CD,PROD_HIER_SK)
);
 
 
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
 
%end;
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
 
%if not (%sysfunc(exist(&m_di_trans..TABLE_PARTITION_META))) %then
%do;
 
 
 
proc sql;
 
 
 
CREATE TABLE TABLE_PARTITION_META
(
TABLE_NM                           VARCHAR(32) NOT NULL,
FULL_COPY_FLG                      INTEGER NOT NULL,
PARTITION_FLG                      INTEGER NOT NULL,
ESTIMATION_FLG                     INTEGER NOT NULL
)
;
 
 
 
ALTER TABLE TABLE_PARTITION_META  add CONSTRAINT PRIM_KEY  PRIMARY KEY (TABLE_NM);
 
 
quit;
 
 
%end;
 
 
 
%if not (%sysfunc(exist(&m_di_trans..TKMI_GRID_DATA_MAP))) %then
%do;
 
 
 
proc sql;
 
 
 
 
CREATE TABLE TKMI_GRID_DATA_MAP
(
PROD_HIER_ASSOC_CD                 INTEGER NOT NULL,
PROD_HIER_SK                       INTEGER NOT NULL,
CAPTAIN_NM                         VARCHAR(255),
PARTITION_SIZE                     NUMERIC(20,3)
)
;
 
 
 
ALTER TABLE TKMI_GRID_DATA_MAP  add CONSTRAINT PRIM_KEY  PRIMARY KEY (PROD_HIER_ASSOC_CD,PROD_HIER_SK);
 
 
 
quit;
 
 
%end;
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID00000A;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID00000A;
%put ERROR- Description                              : Table partition metadata;
%put ERROR- Version                                  : D2TKMI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID00000A;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID00000A",
"Table partition metadata",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID00000A:;
 
 
* End of changes for CHANGE_ID:ID00000A;
 
 
***********************************************************************************************;
*************************************  End Change ID00000A ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID00000B ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID00000B;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID00000B")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID00000B;
%goto ID00000B;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D2TKMI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID00000B;
* Insert record into change management table for CHANGE_ID: ID00000B;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID00000B",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID00000B;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE)) %then %do;
 
 
%let m_sql_statement = %str(
CREATE TABLE FA_ALERT
(
ALERT_SK                           INTEGER NOT NULL,
MODEL_GROUP_ID                     INTEGER NOT NULL,
DEMAND_MODEL_TYPE                  VARCHAR(20) NOT NULL,
SCORE                              NUMERIC(12,2) NOT NULL,
SCORE_DATE_SK                      INTEGER NOT NULL,
BENCHMARK_SCORE                    NUMERIC(12,2) NOT NULL,
BENCHMARK_DTTM                     DATE NOT NULL,
DEVIATION_FROM_SCORE               NUMERIC(12,2) NOT NULL,
CREATED_DTTM                       DATE NOT NULL,
PRIMARY KEY (ALERT_SK)
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%let m_sql_statement = %str(
CREATE TABLE FA_ALERT_STATUS
(
ALERT_SK                           INTEGER NOT NULL,
USER_NM                            VARCHAR(40) NOT NULL,
ACTIVE_FLG                         INTEGER NOT NULL,
PRIMARY KEY (ALERT_SK,USER_NM)
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%let m_sql_statement = %str(
CREATE TABLE FA_MODEL_GROUP
(
MODEL_GROUP_ID                     INTEGER NOT NULL,
SEASON                             VARCHAR(20),
TAG                                VARCHAR(40),
DEMAND_MODEL_TYPE                  VARCHAR(20),
PRIMARY KEY (MODEL_GROUP_ID)
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%let m_sql_statement = %str(
CREATE TABLE FA_MONITORING_FILTER_PROD_GEO
(
PROD_GEO_SK                        INTEGER NOT NULL,
PROD_GEO_FLG                       INTEGER NOT NULL,
PRIMARY KEY (PROD_GEO_SK,PROD_GEO_FLG)
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%let m_sql_statement = %str(
CREATE TABLE FA_MONITORING_GEO
(
GEO_HIER_SK                        INTEGER NOT NULL,
MODEL_GROUP_ID                     INTEGER NOT NULL,
PRIMARY KEY (GEO_HIER_SK,MODEL_GROUP_ID)
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
CREATE INDEX MDL_GRP_ID_IX1 ON FA_MONITORING_GEO
(
MODEL_GROUP_ID
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%let m_sql_statement = %str(
CREATE TABLE FA_MONITORING_PROD
(
PROD_HIER_SK                       INTEGER NOT NULL,
MODEL_GROUP_ID                     INTEGER NOT NULL,
PRIMARY KEY (PROD_HIER_SK,MODEL_GROUP_ID)
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
CREATE INDEX MDL_GRP_ID_IX2 ON FA_MONITORING_PROD
(
MODEL_GROUP_ID
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%let m_sql_statement = %str(
CREATE TABLE FA_PRESEASON_FILTER_PROD_GEO
(
PROD_GEO_SK                        INTEGER NOT NULL,
PROD_GEO_FLG                       INTEGER NOT NULL,
PRIMARY KEY (PROD_GEO_SK,PROD_GEO_FLG)
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
CREATE INDEX PROD_GEO_FLG_IX1 ON FA_PRESEASON_FILTER_PROD_GEO
(
PROD_GEO_FLG
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%let m_sql_statement = %str(
CREATE TABLE FA_PRESEASON_GEO
(
GEO_HIER_SK                        INTEGER NOT NULL,
MODEL_GROUP_ID                     INTEGER NOT NULL,
PRIMARY KEY (GEO_HIER_SK,MODEL_GROUP_ID)
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
CREATE INDEX MDL_GRP_ID_IX4 ON FA_PRESEASON_GEO
(
MODEL_GROUP_ID
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%let m_sql_statement = %str(
CREATE TABLE FA_PRESEASON_PROD
(
PROD_HIER_SK                       INTEGER NOT NULL,
MODEL_GROUP_ID                     INTEGER NOT NULL,
PRIMARY KEY (PROD_HIER_SK,MODEL_GROUP_ID)
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
CREATE INDEX MDL_GRP_ID_IX5 ON FA_PRESEASON_PROD
(
MODEL_GROUP_ID
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%let m_sql_statement = %str(
CREATE TABLE FA_SCENARIO
(
SCENARIO_NM                        VARCHAR(40) NOT NULL,
SCENARIO_DESC                      VARCHAR(100),
SCENARIO_TYPE                      VARCHAR(20),
BASE_SCENARIO_FLG                  INTEGER NOT NULL,
DISABLED_FLG                       INTEGER,
PRIMARY KEY (SCENARIO_NM)
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%let m_sql_statement = %str(
CREATE TABLE FA_SCENARIO_SPEC
(
SCENARIO_NM                        VARCHAR(40) NOT NULL,
SPEC_NM                            VARCHAR(32) NOT NULL,
SPEC_TYPE                          VARCHAR(5) NOT NULL,
SPEC_TABLE_NM                      VARCHAR(32) NOT NULL,
MODEL_COMP_NM                      VARCHAR(20) NOT NULL,
SPEC_VALUE                         VARCHAR(100) NOT NULL,
PRIMARY KEY (SCENARIO_NM,SPEC_NM,SPEC_TYPE,SPEC_TABLE_NM,MODEL_COMP_NM,SPEC_VALUE)
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%let m_sql_statement = %str(
CREATE TABLE FA_SCENARIO_STATUS
(
MODEL_GROUP_ID                     INTEGER NOT NULL,
SCENARIO_NM                        VARCHAR(40) NOT NULL,
DEMAND_MODEL_TYPE                  VARCHAR(20) NOT NULL,
SCORE                              NUMERIC(12,2),
WEIGHTED_MAPE                      NUMERIC(12,2),
MEDIAN_PE                          NUMERIC(12,2),
ELASTICITY_TAIL                    NUMERIC(12,2),
STATUS                             VARCHAR(10),
PRIMARY KEY (MODEL_GROUP_ID,SCENARIO_NM,DEMAND_MODEL_TYPE)
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%let m_sql_statement = %str(
CREATE TABLE FA_SCORE
(
MODEL_GROUP_ID                     INTEGER NOT NULL,
DEMAND_MODEL_TYPE                  VARCHAR(20) NOT NULL,
BENCHMARK_FLG                      INTEGER NOT NULL,
DATE_SK                            INTEGER NOT NULL,
SCORE                              NUMERIC(12,2),
WEIGHTED_MAPE                      NUMERIC(12,2),
MEDIAN_PE                          NUMERIC(12,2),
ELASTICITY_TAIL                    NUMERIC(12,2),
PRIMARY KEY (MODEL_GROUP_ID,DEMAND_MODEL_TYPE,BENCHMARK_FLG,DATE_SK)
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%let m_sql_statement = %str(
CREATE TABLE FA_SPEC
(
MODEL_GROUP_ID                     INTEGER NOT NULL,
SPEC_NM                            VARCHAR(32) NOT NULL,
SPEC_VALUE                         VARCHAR(100),
PRIMARY KEY (MODEL_GROUP_ID,SPEC_NM)
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
 
proc sql noprint;
 
 
CREATE TABLE FA_ALERT
(
ALERT_SK                           INTEGER NOT NULL,
MODEL_GROUP_ID                     INTEGER NOT NULL,
DEMAND_MODEL_TYPE                  VARCHAR(20) NOT NULL,
SCORE                              NUMERIC(12,2) NOT NULL,
SCORE_DATE_SK                      INTEGER NOT NULL,
BENCHMARK_SCORE                    NUMERIC(12,2) NOT NULL,
BENCHMARK_DTTM                     DATE      FORMAT=&DTTMFMT    INFORMAT=&DTTMFMT   NOT NULL,
DEVIATION_FROM_SCORE               NUMERIC(12,2) NOT NULL,
CREATED_DTTM                       DATE      FORMAT=&DTTMFMT    INFORMAT=&DTTMFMT   NOT NULL
)
;
 
 
 
ALTER TABLE FA_ALERT  add CONSTRAINT PRIM_KEY  PRIMARY KEY (ALERT_SK);
 
 
 
 
CREATE TABLE FA_ALERT_STATUS
(
ALERT_SK                           INTEGER NOT NULL,
USER_NM                            VARCHAR(40) NOT NULL,
ACTIVE_FLG                         INTEGER NOT NULL
)
;
 
 
 
ALTER TABLE FA_ALERT_STATUS  add CONSTRAINT PRIM_KEY  PRIMARY KEY (ALERT_SK,USER_NM);
 
 
 
 
CREATE TABLE FA_MODEL_GROUP
(
MODEL_GROUP_ID                     INTEGER NOT NULL,
SEASON                             VARCHAR(20),
TAG                                VARCHAR(40),
DEMAND_MODEL_TYPE                  VARCHAR(20)
)
;
 
 
 
ALTER TABLE FA_MODEL_GROUP  add CONSTRAINT PRIM_KEY  PRIMARY KEY (MODEL_GROUP_ID);
 
 
 
 
CREATE TABLE FA_MONITORING_FILTER_PROD_GEO
(
PROD_GEO_SK                        INTEGER NOT NULL,
PROD_GEO_FLG                       INTEGER NOT NULL
)
;
 
 
 
ALTER TABLE FA_MONITORING_FILTER_PROD_GEO  add CONSTRAINT PRIM_KEY  PRIMARY KEY (PROD_GEO_SK,PROD_GEO_FLG);
 
 
 
 
CREATE TABLE FA_MONITORING_GEO
(
GEO_HIER_SK                        INTEGER NOT NULL,
MODEL_GROUP_ID                     INTEGER NOT NULL
)
;
 
 
 
ALTER TABLE FA_MONITORING_GEO  add CONSTRAINT PRIM_KEY  PRIMARY KEY (GEO_HIER_SK,MODEL_GROUP_ID);
 
 
 
CREATE INDEX MODEL_GROUP_ID ON FA_MONITORING_GEO
(
MODEL_GROUP_ID
)
;
 
 
 
 
CREATE TABLE FA_MONITORING_PROD
(
PROD_HIER_SK                       INTEGER NOT NULL,
MODEL_GROUP_ID                     INTEGER NOT NULL
)
;
 
 
 
ALTER TABLE FA_MONITORING_PROD  add CONSTRAINT PRIM_KEY  PRIMARY KEY (PROD_HIER_SK,MODEL_GROUP_ID);
 
 
 
CREATE INDEX MODEL_GROUP_ID ON FA_MONITORING_PROD
(
MODEL_GROUP_ID
)
;
 
 
 
 
CREATE TABLE FA_PRESEASON_FILTER_PROD_GEO
(
PROD_GEO_SK                        INTEGER NOT NULL,
PROD_GEO_FLG                       INTEGER NOT NULL
)
;
 
 
 
ALTER TABLE FA_PRESEASON_FILTER_PROD_GEO  add CONSTRAINT PRIM_KEY  PRIMARY KEY (PROD_GEO_SK,PROD_GEO_FLG);
 
 
 
CREATE INDEX PROD_GEO_FLG ON FA_PRESEASON_FILTER_PROD_GEO
(
PROD_GEO_FLG
)
;
 
 
 
 
CREATE TABLE FA_PRESEASON_GEO
(
GEO_HIER_SK                        INTEGER NOT NULL,
MODEL_GROUP_ID                     INTEGER NOT NULL
)
;
 
 
 
ALTER TABLE FA_PRESEASON_GEO  add CONSTRAINT PRIM_KEY  PRIMARY KEY (GEO_HIER_SK,MODEL_GROUP_ID);
 
 
 
CREATE INDEX MODEL_GROUP_ID ON FA_PRESEASON_GEO
(
MODEL_GROUP_ID
)
;
 
 
 
 
CREATE TABLE FA_PRESEASON_PROD
(
PROD_HIER_SK                       INTEGER NOT NULL,
MODEL_GROUP_ID                     INTEGER NOT NULL
)
;
 
 
 
ALTER TABLE FA_PRESEASON_PROD  add CONSTRAINT PRIM_KEY  PRIMARY KEY (PROD_HIER_SK,MODEL_GROUP_ID);
 
 
 
CREATE INDEX MODEL_GROUP_ID ON FA_PRESEASON_PROD
(
MODEL_GROUP_ID
)
;
 
 
 
 
CREATE TABLE FA_SCENARIO
(
SCENARIO_NM                        VARCHAR(40) NOT NULL,
SCENARIO_DESC                      VARCHAR(100),
SCENARIO_TYPE                      VARCHAR(20),
BASE_SCENARIO_FLG                  INTEGER NOT NULL,
DISABLED_FLG                       INTEGER
)
;
 
 
 
ALTER TABLE FA_SCENARIO  add CONSTRAINT PRIM_KEY  PRIMARY KEY (SCENARIO_NM);
 
 
 
 
CREATE TABLE FA_SCENARIO_SPEC
(
SCENARIO_NM                        VARCHAR(40) NOT NULL,
SPEC_NM                            VARCHAR(32) NOT NULL,
SPEC_TYPE                          VARCHAR(5) NOT NULL,
SPEC_TABLE_NM                      VARCHAR(32) NOT NULL,
MODEL_COMP_NM                      VARCHAR(20) NOT NULL,
SPEC_VALUE                         VARCHAR(100) NOT NULL
)
;
 
 
 
ALTER TABLE FA_SCENARIO_SPEC  add CONSTRAINT PRIM_KEY  PRIMARY KEY (SCENARIO_NM,SPEC_NM,SPEC_TYPE,SPEC_TABLE_NM,MODEL_COMP_NM,SPEC_VALUE);
 
 
 
 
CREATE TABLE FA_SCENARIO_STATUS
(
MODEL_GROUP_ID                     INTEGER NOT NULL,
SCENARIO_NM                        VARCHAR(40) NOT NULL,
DEMAND_MODEL_TYPE                  VARCHAR(20) NOT NULL,
SCORE                              NUMERIC(12,2),
WEIGHTED_MAPE                      NUMERIC(12,2),
MEDIAN_PE                          NUMERIC(12,2),
ELASTICITY_TAIL                    NUMERIC(12,2),
STATUS                             VARCHAR(10),
PCT_ELASTICITY_DEFAULTED           NUMERIC(12,4)
 
)
;
 
 
 
ALTER TABLE FA_SCENARIO_STATUS  add CONSTRAINT PRIM_KEY  PRIMARY KEY (MODEL_GROUP_ID,SCENARIO_NM,DEMAND_MODEL_TYPE);
 
 
 
 
CREATE TABLE FA_SCORE
(
MODEL_GROUP_ID                     INTEGER NOT NULL,
DEMAND_MODEL_TYPE                  VARCHAR(20) NOT NULL,
BENCHMARK_FLG                      INTEGER NOT NULL,
DATE_SK                            INTEGER NOT NULL,
SCORE                              NUMERIC(12,2),
WEIGHTED_MAPE                      NUMERIC(12,2),
MEDIAN_PE                          NUMERIC(12,2),
ELASTICITY_TAIL                    NUMERIC(12,2),
PCT_ELASTICITY_DEFAULTED           NUMERIC(12,4)
)
;
 
 
 
ALTER TABLE FA_SCORE  add CONSTRAINT PRIM_KEY  PRIMARY KEY (MODEL_GROUP_ID,DEMAND_MODEL_TYPE,BENCHMARK_FLG,DATE_SK);
 
 
 
 
CREATE TABLE FA_SPEC
(
MODEL_GROUP_ID                     INTEGER NOT NULL,
SPEC_NM                            VARCHAR(32) NOT NULL,
SPEC_VALUE                         VARCHAR(200)
)
;
 
 
 
ALTER TABLE FA_SPEC  add CONSTRAINT PRIM_KEY  PRIMARY KEY (MODEL_GROUP_ID,SPEC_NM);
 
 
 
quit;
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (DB2)) %then %do;
 
 
%let m_sql_statement = %str(
CREATE TABLE FA_ALERT
(
ALERT_SK                           INTEGER NOT NULL,
MODEL_GROUP_ID                     INTEGER NOT NULL,
DEMAND_MODEL_TYPE                  VARCHAR(20) NOT NULL,
SCORE                              NUMERIC(12,2) NOT NULL,
SCORE_DATE_SK                      INTEGER NOT NULL,
BENCHMARK_SCORE                    NUMERIC(12,2) NOT NULL,
BENCHMARK_DTTM                     TIMESTAMP NOT NULL,
DEVIATION_FROM_SCORE               NUMERIC(12,2) NOT NULL,
CREATED_DTTM                       TIMESTAMP NOT NULL,
PRIMARY KEY (ALERT_SK)
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%let m_sql_statement = %str(
CREATE TABLE FA_ALERT_STATUS
(
ALERT_SK                           INTEGER NOT NULL,
USER_NM                            VARCHAR(40) NOT NULL,
ACTIVE_FLG                         INTEGER NOT NULL,
PRIMARY KEY (ALERT_SK,USER_NM)
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%let m_sql_statement = %str(
CREATE TABLE FA_MODEL_GROUP
(
MODEL_GROUP_ID                     INTEGER NOT NULL,
SEASON                             VARCHAR(20),
TAG                                VARCHAR(40),
DEMAND_MODEL_TYPE                  VARCHAR(20),
PRIMARY KEY (MODEL_GROUP_ID)
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%let m_sql_statement = %str(
CREATE TABLE FA_MONITORING_FILTER_PROD_GEO
(
PROD_GEO_SK                        INTEGER NOT NULL,
PROD_GEO_FLG                       INTEGER NOT NULL,
PRIMARY KEY (PROD_GEO_SK,PROD_GEO_FLG)
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%let m_sql_statement = %str(
CREATE TABLE FA_MONITORING_GEO
(
GEO_HIER_SK                        INTEGER NOT NULL,
MODEL_GROUP_ID                     INTEGER NOT NULL,
PRIMARY KEY (GEO_HIER_SK,MODEL_GROUP_ID)
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
CREATE INDEX MDL_GRP_ID_IX1 ON FA_MONITORING_GEO
(
MODEL_GROUP_ID
)ALLOW REVERSE SCANS
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%let m_sql_statement = %str(
CREATE TABLE FA_MONITORING_PROD
(
PROD_HIER_SK                       INTEGER NOT NULL,
MODEL_GROUP_ID                     INTEGER NOT NULL,
PRIMARY KEY (PROD_HIER_SK,MODEL_GROUP_ID)
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
CREATE INDEX MDL_GRP_ID_IX2 ON FA_MONITORING_PROD
(
MODEL_GROUP_ID
)ALLOW REVERSE SCANS
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%let m_sql_statement = %str(
CREATE TABLE FA_PRESEASON_FILTER_PROD_GEO
(
PROD_GEO_SK                        INTEGER NOT NULL,
PROD_GEO_FLG                       INTEGER NOT NULL,
PRIMARY KEY (PROD_GEO_SK,PROD_GEO_FLG)
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
CREATE INDEX PROD_GEO_FLG_IX1 ON FA_PRESEASON_FILTER_PROD_GEO
(
PROD_GEO_FLG
)ALLOW REVERSE SCANS
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%let m_sql_statement = %str(
CREATE TABLE FA_PRESEASON_GEO
(
GEO_HIER_SK                        INTEGER NOT NULL,
MODEL_GROUP_ID                     INTEGER NOT NULL,
PRIMARY KEY (GEO_HIER_SK,MODEL_GROUP_ID)
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
CREATE INDEX MDL_GRP_ID_IX4 ON FA_PRESEASON_GEO
(
MODEL_GROUP_ID
)ALLOW REVERSE SCANS
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%let m_sql_statement = %str(
CREATE TABLE FA_PRESEASON_PROD
(
PROD_HIER_SK                       INTEGER NOT NULL,
MODEL_GROUP_ID                     INTEGER NOT NULL,
PRIMARY KEY (PROD_HIER_SK,MODEL_GROUP_ID)
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
CREATE INDEX MDL_GRP_ID_IX5 ON FA_PRESEASON_PROD
(
MODEL_GROUP_ID
)ALLOW REVERSE SCANS
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%let m_sql_statement = %str(
CREATE TABLE FA_SCENARIO
(
SCENARIO_NM                        VARCHAR(40) NOT NULL,
SCENARIO_DESC                      VARCHAR(100),
SCENARIO_TYPE                      VARCHAR(20),
BASE_SCENARIO_FLG                  INTEGER NOT NULL,
DISABLED_FLG                       INTEGER,
PRIMARY KEY (SCENARIO_NM)
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%let m_sql_statement = %str(
CREATE TABLE FA_SCENARIO_SPEC
(
SCENARIO_NM                        VARCHAR(40) NOT NULL,
SPEC_NM                            VARCHAR(32) NOT NULL,
SPEC_TYPE                          VARCHAR(5) NOT NULL,
SPEC_TABLE_NM                      VARCHAR(32) NOT NULL,
MODEL_COMP_NM                      VARCHAR(20) NOT NULL,
SPEC_VALUE                         VARCHAR(100) NOT NULL,
PRIMARY KEY (SCENARIO_NM,SPEC_NM,SPEC_TYPE,SPEC_TABLE_NM,MODEL_COMP_NM,SPEC_VALUE)
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%let m_sql_statement = %str(
CREATE TABLE FA_SCENARIO_STATUS
(
MODEL_GROUP_ID                     INTEGER NOT NULL,
SCENARIO_NM                        VARCHAR(40) NOT NULL,
DEMAND_MODEL_TYPE                  VARCHAR(20) NOT NULL,
SCORE                              NUMERIC(12,2),
WEIGHTED_MAPE                      NUMERIC(12,2),
MEDIAN_PE                          NUMERIC(12,2),
ELASTICITY_TAIL                    NUMERIC(12,2),
STATUS                             VARCHAR(10),
PRIMARY KEY (MODEL_GROUP_ID,SCENARIO_NM,DEMAND_MODEL_TYPE)
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%let m_sql_statement = %str(
CREATE TABLE FA_SCORE
(
MODEL_GROUP_ID                     INTEGER NOT NULL,
DEMAND_MODEL_TYPE                  VARCHAR(20) NOT NULL,
BENCHMARK_FLG                      INTEGER NOT NULL,
DATE_SK                            INTEGER NOT NULL,
SCORE                              NUMERIC(12,2),
WEIGHTED_MAPE                      NUMERIC(12,2),
MEDIAN_PE                          NUMERIC(12,2),
ELASTICITY_TAIL                    NUMERIC(12,2),
PRIMARY KEY (MODEL_GROUP_ID,DEMAND_MODEL_TYPE,BENCHMARK_FLG,DATE_SK)
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%let m_sql_statement = %str(
CREATE TABLE FA_SPEC
(
MODEL_GROUP_ID                     INTEGER NOT NULL,
SPEC_NM                            VARCHAR(32) NOT NULL,
SPEC_VALUE                         VARCHAR(100),
PRIMARY KEY (MODEL_GROUP_ID,SPEC_NM)
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID00000B;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID00000B;
%put ERROR- Description                              : Add FA Tables (Moving from SAS to RDBMS);
%put ERROR- Version                                  : D2TKMI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID00000B;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID00000B",
"Add FA Tables (Moving from SAS to RDBMS)",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID00000B:;
 
 
* End of changes for CHANGE_ID:ID00000B;
 
 
***********************************************************************************************;
*************************************  End Change ID00000B ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID00000C ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID00000C;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID00000C")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID00000C;
%goto ID00000C;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D2TKMI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID00000C;
* Insert record into change management table for CHANGE_ID: ID00000C;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID00000C",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID00000C;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE)) %then %do;
 
 
%let m_sql_statement = %str(
ALTER TABLE PROCESS_STATUS ADD SCOPE_SK INTEGER
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE PROCESS_STATUS ADD SCOPE_ASSOC_CD INTEGER
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE PROCESS_STATUS ADD PROCESS_TYPE VARCHAR(80)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
 
ALTER TABLE PROCESS_STATUS ADD SCOPE_SK INTEGER;
 
 
ALTER TABLE PROCESS_STATUS ADD SCOPE_ASSOC_CD INTEGER;
 
 
ALTER TABLE PROCESS_STATUS ADD PROCESS_TYPE VARCHAR(80);
 
 
 
 
quit;
 
 
%end;
 
 
%if (&m_di_trans_vendor in (DB2)) %then %do;
 
 
%let m_sql_statement = %str(
ALTER TABLE PROCESS_STATUS ADD COLUMN SCOPE_SK INTEGER
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE PROCESS_STATUS ADD COLUMN SCOPE_ASSOC_CD INTEGER
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE PROCESS_STATUS ADD COLUMN PROCESS_TYPE VARCHAR(80)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID00000C;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID00000C;
%put ERROR- Description                              : Update PROCESS_... tables to support request persistence;
%put ERROR- Version                                  : D2TKMI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID00000C;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID00000C",
"Update PROCESS_... tables to support request persistence",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID00000C:;
 
 
* End of changes for CHANGE_ID:ID00000C;
 
 
***********************************************************************************************;
*************************************  End Change ID00000C ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID669058 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID669058;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID669058")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID669058;
%goto ID669058;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D2TKMI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID669058;
* Insert record into change management table for CHANGE_ID: ID669058;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID669058",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID669058;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE)) %then %do;
 
 
%let m_sql_statement = %str(
ALTER TABLE FA_SCENARIO_STATUS ADD (MEAN_PE NUMERIC(12,2))
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE FA_SCORE ADD (MEAN_PE NUMERIC(12,2))
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
 
proc sql;
 
 
ALTER TABLE FA_SCENARIO_STATUS ADD MEAN_PE NUMERIC(12,2);
 
 
ALTER TABLE FA_SCORE ADD MEAN_PE NUMERIC(12,2);
 
 
quit;
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (DB2)) %then %do;
 
%let m_sql_statement = %str(
ALTER TABLE FA_SCENARIO_STATUS ADD COLUMN MEAN_PE NUMERIC(12,2)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE FA_SCORE ADD COLUMN MEAN_PE NUMERIC(12,2)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
REORG TABLE FA_SCENARIO
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
REORG TABLE FA_SCORE
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID669058;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID669058;
%put ERROR- Description                              : Add MEAN_PE column to FA tables;
%put ERROR- Version                                  : D2TKMI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID669058;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID669058",
"Add MEAN_PE column to FA tables",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID669058:;
 
 
* End of changes for CHANGE_ID:ID669058;
 
 
***********************************************************************************************;
*************************************  End Change ID669058 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID669442 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID669442;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID669442")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID669442;
%goto ID669442;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D2TKMI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID669442;
* Insert record into change management table for CHANGE_ID: ID669442;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID669442",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID669442;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE)) %then %do;
 
%let m_sql_statement = %str(
CREATE TABLE MA_SCENARIO
(
SCENARIO_NM                        VARCHAR(40) NOT NULL,
USER_NM                            VARCHAR(60) NOT NULL,
SCENARIO_DESC                      VARCHAR(100),
SCENARIO_TYPE                      VARCHAR(20),
BASE_SCENARIO_FLG                  INTEGER NOT NULL,
DISABLED_FLG                       INTEGER,
PRIMARY KEY (SCENARIO_NM,USER_NM)
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
CREATE TABLE MA_SCENARIO_SPEC
(
SCENARIO_NM                        VARCHAR(40) NOT NULL,
SPEC_NM                            VARCHAR(32) NOT NULL,
SPEC_TYPE                          VARCHAR(5) NOT NULL,
SPEC_TABLE_NM                      VARCHAR(32) NOT NULL,
MODEL_COMP_NM                      VARCHAR(20) NOT NULL,
SPEC_VALUE                         VARCHAR(100) NOT NULL,
USER_NM                            VARCHAR(60) NOT NULL,
PRIMARY KEY (SCENARIO_NM,SPEC_NM,SPEC_TYPE,SPEC_TABLE_NM,MODEL_COMP_NM,SPEC_VALUE,USER_NM)
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
CREATE TABLE MA_MODEL_GROUP
(
MODEL_GROUP_ID                     INTEGER NOT NULL,
USER_NM                            VARCHAR(60) NOT NULL,
SEASON                             VARCHAR(20),
TAG                                VARCHAR(40),
DEMAND_MODEL_TYPE                  VARCHAR(20),
PRIMARY KEY (MODEL_GROUP_ID,USER_NM)
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
 
proc sql noprint;
 
 
CREATE TABLE MA_MODEL_GROUP
(
MODEL_GROUP_ID                     INTEGER NOT NULL,
USER_NM                            VARCHAR(60) NOT NULL,
SEASON                             VARCHAR(20),
TAG                                VARCHAR(40),
DEMAND_MODEL_TYPE                  VARCHAR(20)
)
;
 
 
 
ALTER TABLE MA_MODEL_GROUP  add CONSTRAINT PRIM_KEY  PRIMARY KEY (MODEL_GROUP_ID,USER_NM);
 
 
 
 
CREATE TABLE MA_SCENARIO
(
SCENARIO_NM                        VARCHAR(40) NOT NULL,
USER_NM                            VARCHAR(60) NOT NULL,
SCENARIO_DESC                      VARCHAR(100),
SCENARIO_TYPE                      VARCHAR(20),
BASE_SCENARIO_FLG                  INTEGER NOT NULL,
DISABLED_FLG                       INTEGER
)
;
 
 
 
ALTER TABLE MA_SCENARIO  add CONSTRAINT PRIM_KEY  PRIMARY KEY (SCENARIO_NM,USER_NM);
 
 
 
 
CREATE TABLE MA_SCENARIO_SPEC
(
SCENARIO_NM                        VARCHAR(40) NOT NULL,
SPEC_NM                            VARCHAR(32) NOT NULL,
SPEC_TYPE                          VARCHAR(5) NOT NULL,
SPEC_TABLE_NM                      VARCHAR(32) NOT NULL,
MODEL_COMP_NM                      VARCHAR(20) NOT NULL,
SPEC_VALUE                         VARCHAR(100) NOT NULL,
USER_NM                            VARCHAR(60) NOT NULL
)
;
 
 
 
ALTER TABLE MA_SCENARIO_SPEC  add CONSTRAINT PRIM_KEY  PRIMARY KEY (SCENARIO_NM,SPEC_NM,SPEC_TYPE,SPEC_TABLE_NM,MODEL_COMP_NM,SPEC_VALUE,USER_NM);
 
 
 
quit;
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (DB2)) %then %do;
 
 
 
%let m_sql_statement = %str(
CREATE TABLE MA_SCENARIO
(
SCENARIO_NM                        VARCHAR(40) NOT NULL,
USER_NM                            VARCHAR(60) NOT NULL,
SCENARIO_DESC                      VARCHAR(100),
SCENARIO_TYPE                      VARCHAR(20),
BASE_SCENARIO_FLG                  INTEGER NOT NULL,
DISABLED_FLG                       INTEGER,
PRIMARY KEY (SCENARIO_NM,USER_NM)
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%let m_sql_statement = %str(
CREATE TABLE MA_SCENARIO_SPEC
(
SCENARIO_NM                        VARCHAR(40) NOT NULL,
SPEC_NM                            VARCHAR(32) NOT NULL,
SPEC_TYPE                          VARCHAR(5) NOT NULL,
SPEC_TABLE_NM                      VARCHAR(32) NOT NULL,
MODEL_COMP_NM                      VARCHAR(20) NOT NULL,
SPEC_VALUE                         VARCHAR(100) NOT NULL,
USER_NM                            VARCHAR(60) NOT NULL,
PRIMARY KEY (SCENARIO_NM,SPEC_NM,SPEC_TYPE,SPEC_TABLE_NM,MODEL_COMP_NM,SPEC_VALUE,USER_NM)
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%let m_sql_statement = %str(
CREATE TABLE MA_MODEL_GROUP
(
MODEL_GROUP_ID                     INTEGER NOT NULL,
USER_NM                            VARCHAR(60) NOT NULL,
SEASON                             VARCHAR(20),
TAG                                VARCHAR(40),
DEMAND_MODEL_TYPE                  VARCHAR(20),
PRIMARY KEY (MODEL_GROUP_ID,USER_NM)
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID669442;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID669442;
%put ERROR- Description                              : MA tables;
%put ERROR- Version                                  : D2TKMI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID669442;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID669442",
"MA tables",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID669442:;
 
 
* End of changes for CHANGE_ID:ID669442;
 
 
***********************************************************************************************;
*************************************  End Change ID669442 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID661595 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID661595;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID661595")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID661595;
%goto ID661595;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D2TKMI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID661595;
* Insert record into change management table for CHANGE_ID: ID661595;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID661595",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID661595;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE)) %then %do;
 
 
%let m_sql_statement = %str(
CREATE TABLE HISTORICAL_FIT
(
MODEL_GROUP_ID                     INTEGER NOT NULL,
SCENARIO_NM                        VARCHAR(40) NOT NULL,
GEO_HIER_SK                        INTEGER NOT NULL,
PROD_HIER_SK                       INTEGER NOT NULL,
DATE_SK                            INTEGER NOT NULL,
SALES_UNITS                        NUMERIC(12,2),
PRICE_RATIO                        NUMERIC(12,2),
SALES_FITTING_UNITS                NUMERIC(12,2),
BASE_UNITS                         NUMERIC(12,2),
DEMAND_MODEL_TYPE                  VARCHAR(20),
PRIMARY KEY (MODEL_GROUP_ID,SCENARIO_NM,GEO_HIER_SK,PROD_HIER_SK,DATE_SK)
)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%let m_sql_statement = %str(
CREATE TABLE HISTORICAL_FIT_ACCURACY
(
MODEL_GROUP_ID                     INTEGER NOT NULL,
SCENARIO_NM                        VARCHAR(40) NOT NULL,
GEO_HIER_SK                        INTEGER NOT NULL,
PROD_HIER_SK                       INTEGER NOT NULL,
DATE_SK                            INTEGER NOT NULL,
DATA_LVL_ID                        INTEGER,
SALES_FITTING_UNITS                NUMERIC(12,2),
SALES_UNITS                        NUMERIC(12,2),
FIT_MAPE                           NUMERIC(12,2),
FIT_APE                            NUMERIC(12,2),
FIT_RMSE                           NUMERIC(12,2),
DEMAND_MODEL_TYPE                  VARCHAR(20),
PRIMARY KEY (MODEL_GROUP_ID,SCENARIO_NM,GEO_HIER_SK,PROD_HIER_SK,DATE_SK)
)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%let m_sql_statement = %str(
CREATE TABLE HOLDOUT_FORECAST
(
MODEL_GROUP_ID                     INTEGER NOT NULL,
SCENARIO_NM                        VARCHAR(40) NOT NULL,
GEO_HIER_SK                        INTEGER NOT NULL,
PROD_HIER_SK                       INTEGER NOT NULL,
DATE_SK                            INTEGER NOT NULL,
SALES_UNC_FCST_UNITS               NUMERIC(12,2),
SALES_UNITS                        NUMERIC(12,2),
CLOSE_INV_UNITS                    NUMERIC(12,2),
PRICE_RATIO                        NUMERIC(12,2),
RECEIPT_UNITS                      NUMERIC(12,2),
SALES_FCST_UNITS                   NUMERIC(12,2),
BASE_UNITS                         NUMERIC(12,2),
START_DT                           DATE,
DEMAND_MODEL_TYPE                  VARCHAR(20),
PRIMARY KEY (MODEL_GROUP_ID,SCENARIO_NM,GEO_HIER_SK,PROD_HIER_SK,DATE_SK)
)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%let m_sql_statement = %str(
CREATE TABLE HOLDOUT_FORECAST_ACCURACY
(
MODEL_GROUP_ID                     INTEGER NOT NULL,
SCENARIO_NM                        VARCHAR(40) NOT NULL,
GEO_HIER_SK                        INTEGER NOT NULL,
PROD_HIER_SK                       INTEGER NOT NULL,
DATE_SK                            INTEGER NOT NULL,
SALES_UNC_FCST_UNITS               NUMERIC(12,2),
SALES_FCST_UNITS                   NUMERIC(12,2),
SALES_UNITS                        NUMERIC(12,2),
CLOSE_INV_UNITS                    NUMERIC(12,2),
ACTUAL_SELL_THROUGH                NUMERIC(12,2),
CONSTRAINED_SELL_THROUGH           NUMERIC(12,2),
CONSTRAINED_FCST_APE               NUMERIC(12,2),
CONSTRAINED_FCST_MAPE              NUMERIC(12,2),
CONSTRAINED_FCST_RMSE              NUMERIC(12,2),
UNCONSTRAINED_SELL_THROUGH         NUMERIC(12,2),
UNCONSTRAINED_FCST_APE             NUMERIC(12,2),
UNCONSTRAINED_FCST_MAPE            NUMERIC(12,2),
UNCONSTRAINED_FCST_RMSE            NUMERIC(12,2),
UNACCOUNTED_SALES_UNITS            NUMERIC(12,2),
DEMAND_MODEL_TYPE                  VARCHAR(20),
PRIMARY KEY (MODEL_GROUP_ID,SCENARIO_NM,GEO_HIER_SK,PROD_HIER_SK,DATE_SK)
)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
 
proc sql;
 
 
 
CREATE TABLE HISTORICAL_FIT
(
MODEL_GROUP_ID                     INTEGER NOT NULL,
SCENARIO_NM                        VARCHAR(40) NOT NULL,
GEO_HIER_SK                        INTEGER NOT NULL,
PROD_HIER_SK                       INTEGER NOT NULL,
DATE_SK                            INTEGER NOT NULL,
SALES_UNITS                        NUMERIC(12,2),
PRICE_RATIO                        NUMERIC(12,2),
SALES_FITTING_UNITS                NUMERIC(12,2),
BASE_UNITS                         NUMERIC(12,2),
DEMAND_MODEL_TYPE                  VARCHAR(20),
SALES_UNITS_UNACCOUNTED            NUMERIC(12,2)
)
;
 
 
 
ALTER TABLE HISTORICAL_FIT  add CONSTRAINT PRIM_KEY  PRIMARY KEY (MODEL_GROUP_ID,SCENARIO_NM,GEO_HIER_SK,PROD_HIER_SK,DATE_SK);
 
 
 
 
CREATE TABLE HISTORICAL_FIT_ACCURACY
(
MODEL_GROUP_ID                     INTEGER NOT NULL,
SCENARIO_NM                        VARCHAR(40) NOT NULL,
GEO_HIER_SK                        INTEGER NOT NULL,
PROD_HIER_SK                       INTEGER NOT NULL,
DATE_SK                            INTEGER NOT NULL,
DATA_LVL_ID                        INTEGER,
SALES_FITTING_UNITS                NUMERIC(12,2),
SALES_UNITS                        NUMERIC(12,2),
FIT_MAPE                           NUMERIC(12,2),
FIT_APE                            NUMERIC(12,2),
FIT_RMSE                           NUMERIC(12,2),
DEMAND_MODEL_TYPE                  VARCHAR(20)
)
;
 
 
 
ALTER TABLE HISTORICAL_FIT_ACCURACY  add CONSTRAINT PRIM_KEY  PRIMARY KEY (MODEL_GROUP_ID,SCENARIO_NM,GEO_HIER_SK,PROD_HIER_SK,DATE_SK);
 
 
 
 
CREATE TABLE HOLDOUT_FORECAST
(
MODEL_GROUP_ID                     INTEGER NOT NULL,
SCENARIO_NM                        VARCHAR(40) NOT NULL,
GEO_HIER_SK                        INTEGER NOT NULL,
PROD_HIER_SK                       INTEGER NOT NULL,
DATE_SK                            INTEGER NOT NULL,
SALES_UNC_FCST_UNITS               NUMERIC(12,2),
SALES_UNITS                        NUMERIC(12,2),
CLOSE_INV_UNITS                    NUMERIC(12,2),
PRICE_RATIO                        NUMERIC(12,2),
RECEIPT_UNITS                      NUMERIC(12,2),
SALES_FCST_UNITS                   NUMERIC(12,2),
BASE_UNITS                         NUMERIC(12,2),
START_DT                           DATE      FORMAT=&DTFMT    INFORMAT=&DTFMT  ,
DEMAND_MODEL_TYPE                  VARCHAR(20)
)
;
 
 
 
ALTER TABLE HOLDOUT_FORECAST  add CONSTRAINT PRIM_KEY  PRIMARY KEY (MODEL_GROUP_ID,SCENARIO_NM,GEO_HIER_SK,PROD_HIER_SK,DATE_SK);
 
 
 
 
CREATE TABLE HOLDOUT_FORECAST_ACCURACY
(
MODEL_GROUP_ID                     INTEGER NOT NULL,
SCENARIO_NM                        VARCHAR(40) NOT NULL,
GEO_HIER_SK                        INTEGER NOT NULL,
PROD_HIER_SK                       INTEGER NOT NULL,
DATE_SK                            INTEGER NOT NULL,
SALES_UNC_FCST_UNITS               NUMERIC(12,2),
SALES_FCST_UNITS                   NUMERIC(12,2),
SALES_UNITS                        NUMERIC(12,2),
CLOSE_INV_UNITS                    NUMERIC(12,2),
ACTUAL_SELL_THROUGH                NUMERIC(12,2),
CONSTRAINED_SELL_THROUGH           NUMERIC(12,2),
CONSTRAINED_FCST_APE               NUMERIC(12,2),
CONSTRAINED_FCST_MAPE              NUMERIC(12,2),
CONSTRAINED_FCST_RMSE              NUMERIC(12,2),
UNCONSTRAINED_SELL_THROUGH         NUMERIC(12,2),
UNCONSTRAINED_FCST_APE             NUMERIC(12,2),
UNCONSTRAINED_FCST_MAPE            NUMERIC(12,2),
UNCONSTRAINED_FCST_RMSE            NUMERIC(12,2),
UNACCOUNTED_SALES_UNITS            NUMERIC(12,2),
DEMAND_MODEL_TYPE                  VARCHAR(20)
)
;
 
 
 
ALTER TABLE HOLDOUT_FORECAST_ACCURACY  add CONSTRAINT PRIM_KEY  PRIMARY KEY (MODEL_GROUP_ID,SCENARIO_NM,GEO_HIER_SK,PROD_HIER_SK,DATE_SK);
 
 
 
 
quit;
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (DB2)) %then %do;
 
 
%let m_sql_statement = %str(
CREATE TABLE HISTORICAL_FIT
(
MODEL_GROUP_ID                     INTEGER NOT NULL,
SCENARIO_NM                        VARCHAR(40) NOT NULL,
GEO_HIER_SK                        INTEGER NOT NULL,
PROD_HIER_SK                       INTEGER NOT NULL,
DATE_SK                            INTEGER NOT NULL,
SALES_UNITS                        NUMERIC(12,2),
PRICE_RATIO                        NUMERIC(12,2),
SALES_FITTING_UNITS                NUMERIC(12,2),
BASE_UNITS                         NUMERIC(12,2),
DEMAND_MODEL_TYPE                  VARCHAR(20),
PRIMARY KEY (MODEL_GROUP_ID,SCENARIO_NM,GEO_HIER_SK,PROD_HIER_SK,DATE_SK)
)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%let m_sql_statement = %str(
CREATE TABLE HISTORICAL_FIT_ACCURACY
(
MODEL_GROUP_ID                     INTEGER NOT NULL,
SCENARIO_NM                        VARCHAR(40) NOT NULL,
GEO_HIER_SK                        INTEGER NOT NULL,
PROD_HIER_SK                       INTEGER NOT NULL,
DATE_SK                            INTEGER NOT NULL,
DATA_LVL_ID                        INTEGER,
SALES_FITTING_UNITS                NUMERIC(12,2),
SALES_UNITS                        NUMERIC(12,2),
FIT_MAPE                           NUMERIC(12,2),
FIT_APE                            NUMERIC(12,2),
FIT_RMSE                           NUMERIC(12,2),
DEMAND_MODEL_TYPE                  VARCHAR(20),
PRIMARY KEY (MODEL_GROUP_ID,SCENARIO_NM,GEO_HIER_SK,PROD_HIER_SK,DATE_SK)
)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%let m_sql_statement = %str(
CREATE TABLE HOLDOUT_FORECAST
(
MODEL_GROUP_ID                     INTEGER NOT NULL,
SCENARIO_NM                        VARCHAR(40) NOT NULL,
GEO_HIER_SK                        INTEGER NOT NULL,
PROD_HIER_SK                       INTEGER NOT NULL,
DATE_SK                            INTEGER NOT NULL,
SALES_UNC_FCST_UNITS               NUMERIC(12,2),
SALES_UNITS                        NUMERIC(12,2),
CLOSE_INV_UNITS                    NUMERIC(12,2),
PRICE_RATIO                        NUMERIC(12,2),
RECEIPT_UNITS                      NUMERIC(12,2),
SALES_FCST_UNITS                   NUMERIC(12,2),
BASE_UNITS                         NUMERIC(12,2),
START_DT                           DATE,
DEMAND_MODEL_TYPE                  VARCHAR(20),
PRIMARY KEY (MODEL_GROUP_ID,SCENARIO_NM,GEO_HIER_SK,PROD_HIER_SK,DATE_SK)
)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%let m_sql_statement = %str(
CREATE TABLE HOLDOUT_FORECAST_ACCURACY
(
MODEL_GROUP_ID                     INTEGER NOT NULL,
SCENARIO_NM                        VARCHAR(40) NOT NULL,
GEO_HIER_SK                        INTEGER NOT NULL,
PROD_HIER_SK                       INTEGER NOT NULL,
DATE_SK                            INTEGER NOT NULL,
SALES_UNC_FCST_UNITS               NUMERIC(12,2),
SALES_FCST_UNITS                   NUMERIC(12,2),
SALES_UNITS                        NUMERIC(12,2),
CLOSE_INV_UNITS                    NUMERIC(12,2),
ACTUAL_SELL_THROUGH                NUMERIC(12,2),
CONSTRAINED_SELL_THROUGH           NUMERIC(12,2),
CONSTRAINED_FCST_APE               NUMERIC(12,2),
CONSTRAINED_FCST_MAPE              NUMERIC(12,2),
CONSTRAINED_FCST_RMSE              NUMERIC(12,2),
UNCONSTRAINED_SELL_THROUGH         NUMERIC(12,2),
UNCONSTRAINED_FCST_APE             NUMERIC(12,2),
UNCONSTRAINED_FCST_MAPE            NUMERIC(12,2),
UNCONSTRAINED_FCST_RMSE            NUMERIC(12,2),
UNACCOUNTED_SALES_UNITS            NUMERIC(12,2),
DEMAND_MODEL_TYPE                  VARCHAR(20),
PRIMARY KEY (MODEL_GROUP_ID,SCENARIO_NM,GEO_HIER_SK,PROD_HIER_SK,DATE_SK)
)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID661595;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID661595;
%put ERROR- Description                              : FA tables Historical Fit and Holdout Forecast;
%put ERROR- Version                                  : D2TKMI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID661595;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID661595",
"FA tables Historical Fit and Holdout Forecast",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID661595:;
 
 
* End of changes for CHANGE_ID:ID661595;
 
 
***********************************************************************************************;
*************************************  End Change ID661595 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID661123_1 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID661123_1;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID661123_1")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID661123_1;
%goto ID661123_1;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D2TKMI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID661123_1;
* Insert record into change management table for CHANGE_ID: ID661123_1;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID661123_1",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID661123_1;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
DELETE FROM FA_SPEC WHERE SPEC_NM = 'HOLDOUT_DETAILS_PROD_LVL'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO FA_SPEC (MODEL_GROUP_ID, SPEC_NM, SPEC_VALUE) VALUES (-1,'HOLDOUT_DETAILS_PROD_LVL','1')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
DELETE FROM FA_SPEC WHERE SPEC_NM = 'HOLDOUT_DETAILS_GEO_LVL'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO FA_SPEC (MODEL_GROUP_ID, SPEC_NM, SPEC_VALUE) VALUES (-1,'HOLDOUT_DETAILS_GEO_LVL','1')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
DELETE FROM FA_SPEC WHERE SPEC_NM = 'HOLDOUT_DETAILS_PROD_LVL';
 
 
INSERT INTO FA_SPEC (MODEL_GROUP_ID, SPEC_NM, SPEC_VALUE) VALUES (-1,'HOLDOUT_DETAILS_PROD_LVL','1');
 
 
DELETE FROM FA_SPEC WHERE SPEC_NM = 'HOLDOUT_DETAILS_GEO_LVL';
 
 
INSERT INTO FA_SPEC (MODEL_GROUP_ID, SPEC_NM, SPEC_VALUE) VALUES (-1,'HOLDOUT_DETAILS_GEO_LVL','1');
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID661123_1;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID661123_1;
%put ERROR- Description                              : Add HOLDOUT_DETAILS_PROD_LVL and HOLDOUT_DETAILS_GEO_LVL FA specs;
%put ERROR- Version                                  : D2TKMI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID661123_1;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID661123_1",
"Add HOLDOUT_DETAILS_PROD_LVL and HOLDOUT_DETAILS_GEO_LVL FA specs",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID661123_1:;
 
 
* End of changes for CHANGE_ID:ID661123_1;
 
 
***********************************************************************************************;
*************************************  End Change ID661123_1 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID673040 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID673040;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID673040")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID673040;
%goto ID673040;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D2TKMI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID673040;
* Insert record into change management table for CHANGE_ID: ID673040;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID673040",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID673040;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
CREATE TABLE FCST_EXPORT_INPUT
(
GEO_HIER_SK                        INTEGER NOT NULL,
PROD_HIER_SK                       INTEGER NOT NULL,
GEO_HIER_ASSOC_CD                  INTEGER NOT NULL,
UNCONSTR_FLG                       INTEGER,
FCST_WEEKS                         INTEGER,
PRIMARY KEY (GEO_HIER_SK,PROD_HIER_SK,GEO_HIER_ASSOC_CD)
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
 
proc sql;
 
 
 
CREATE TABLE FCST_EXPORT_INPUT
(
GEO_HIER_SK                        INTEGER NOT NULL,
PROD_HIER_SK                       INTEGER NOT NULL,
GEO_HIER_ASSOC_CD                  INTEGER NOT NULL,
UNCONSTR_FLG                       INTEGER,
FCST_WEEKS                         INTEGER
)
;
 
 
 
ALTER TABLE FCST_EXPORT_INPUT  add CONSTRAINT PRIM_KEY  PRIMARY KEY (GEO_HIER_SK,PROD_HIER_SK,GEO_HIER_ASSOC_CD);
 
 
 
quit;
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID673040;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID673040;
%put ERROR- Description                              : Input into C code for Forecast Export;
%put ERROR- Version                                  : D2TKMI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID673040;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID673040",
"Input into C code for Forecast Export",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID673040:;
 
 
* End of changes for CHANGE_ID:ID673040;
 
 
***********************************************************************************************;
*************************************  End Change ID673040 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID674812 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID674812;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID674812")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID674812;
%goto ID674812;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D2TKMI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID674812;
* Insert record into change management table for CHANGE_ID: ID674812;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID674812",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID674812;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE)) %then %do;
 
 
%let m_sql_statement = %str(
ALTER TABLE PROCESS_STATUS ADD RESULT_VALUE VARCHAR(1024)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE PROCESS_STATUS ADD RESULT_EXCEPTION VARCHAR(255)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
 
ALTER TABLE PROCESS_STATUS ADD RESULT_VALUE VARCHAR(1024);
 
 
ALTER TABLE PROCESS_STATUS ADD RESULT_EXCEPTION VARCHAR(255);
 
 
 
 
quit;
 
 
%end;
 
 
%if (&m_di_trans_vendor in (DB2)) %then %do;
 
 
%let m_sql_statement = %str(
ALTER TABLE PROCESS_STATUS ADD COLUMN RESULT_VALUE VARCHAR(1024)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE PROCESS_STATUS ADD COLUMN RESULT_EXCEPTION VARCHAR(255)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID674812;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID674812;
%put ERROR- Description                              : Added persistence of TKMIServer requests results;
%put ERROR- Version                                  : D2TKMI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID674812;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID674812",
"Added persistence of TKMIServer requests results",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID674812:;
 
 
* End of changes for CHANGE_ID:ID674812;
 
 
***********************************************************************************************;
*************************************  End Change ID674812 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID679163 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID679163;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID679163")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID679163;
%goto ID679163;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D2TKMI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID679163;
* Insert record into change management table for CHANGE_ID: ID679163;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID679163",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID679163;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE)) %then %do;
 
 
%let m_sql_statement = %str(
ALTER TABLE MDO_PLAN DROP COLUMN AUTO_EVAL_OPT_FLG
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
 
%di_util_drop_constraint(m_lib=di_trans, m_table=mdo_plan, m_column=%str(auto_eval_opt_flg), m_constraint=%str(not null));
 
 
 
proc sql;
 
 
ALTER TABLE MDO_PLAN DROP COLUMN AUTO_EVAL_OPT_FLG;
 
 
quit;
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (DB2)) %then %do;
 
 
%let m_sql_statement = %str(
ALTER TABLE MDO_PLAN DROP COLUMN AUTO_EVAL_OPT_FLG
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID679163;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID679163;
%put ERROR- Description                              : Remove the plan settings AUTO_EVAL_OPT_FLG from MDO_PLAN;
%put ERROR- Version                                  : D2TKMI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID679163;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID679163",
"Remove the plan settings AUTO_EVAL_OPT_FLG from MDO_PLAN",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID679163:;
 
 
* End of changes for CHANGE_ID:ID679163;
 
 
***********************************************************************************************;
*************************************  End Change ID679163 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID675652 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID675652;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID675652")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID675652;
%goto ID675652;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D2TKMI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID675652;
* Insert record into change management table for CHANGE_ID: ID675652;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID675652",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID675652;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE)) %then %do;
 
 
%let m_sql_statement = %str(
alter table GEO_PROD_AGG drop primary key drop index
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
Create Unique Index Geo_Prod_Agg_PK On Geo_Prod_Agg(Prod_Hier_Sk, Geo_Hier_Sk) Nologging Parallel 20
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
Alter Table Geo_Prod_Agg Add Constraint Geo_Prod_Agg_Pk Primary Key (Prod_Hier_Sk, Geo_Hier_Sk) using index Geo_Prod_Agg_PK
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
alter table GEO_PROD_MTS drop primary key drop index
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
Create Unique Index Geo_Prod_Mts_PK On Geo_Prod_Mts(Prod_Hier_Sk, Geo_Hier_Sk) Nologging Parallel 20
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
Alter Table Geo_Prod_Mts Add Constraint Geo_Prod_Mts_Pk Primary Key (Prod_Hier_Sk, Geo_Hier_Sk) using index Geo_Prod_Mts_PK
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
alter table MPLN_RESULT drop primary key drop index
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
Create Unique Index Mpln_Result_PK On Mpln_Result(Agg_Cd, Mdo_Plan_Sk) Nologging Parallel
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
Alter Table Mpln_Result Add Constraint Mpln_Result_Pk Primary Key (Agg_Cd, Mdo_Plan_Sk) using Index Mpln_Result_PK
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
alter table MPLN_GEO_PROD_RESULT drop primary key drop index
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
Create Unique Index Mpln_Geo_Prod_Result_PK On Mpln_Geo_Prod_Result(Agg_Cd, Mdo_Plan_Sk, Geo_Hier_Sk,Prod_Hier_Sk) Nologging Parallel 20
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
Alter Table Mpln_Geo_Prod_Result Add Constraint Mpln_Geo_Prod_Result_Pk Primary Key (Agg_Cd, Mdo_Plan_Sk, Geo_Hier_Sk,Prod_Hier_Sk)  using index Mpln_Geo_Prod_Result_PK
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
alter table mpln_actual_mts drop primary key drop index
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
Create Unique Index Mpln_Actual_Mts_PK On Mpln_Actual_Mts(Agg_Cd, Mdo_Plan_Group_Sk) Nologging Parallel
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
Alter Table Mpln_Actual_Mts Add Constraint Mpln_Actual_Mts_Pk Primary Key (Agg_Cd, Mdo_Plan_Group_Sk) using Index Mpln_Actual_Mts_PK
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
alter table mpln_geo_prod_faw_mts drop primary key drop index
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
Create Unique Index Mpln_Geo_Prod_Faw_Mts_PK On Mpln_Geo_Prod_Faw_Mts(Mdo_Plan_Sk, Prod_Hier_Sk, Geo_Hier_Sk) Nologging Parallel
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
Alter Table Mpln_Geo_Prod_Faw_Mts Add Constraint Mpln_Geo_Prod_Faw_Mts_Pk Primary Key (Mdo_Plan_Sk, Prod_Hier_Sk, Geo_Hier_Sk) using Index Mpln_Geo_Prod_Faw_Mts_PK
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
alter table mpln_geo_prod_mts drop primary key drop index
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
Create Unique Index Mpln_Geo_Prod_Mts_PK On Mpln_Geo_Prod_Mts(Agg_Cd, Mdo_Plan_Sk, Geo_Hier_Sk,Prod_Hier_Sk) Nologging Parallel 20
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
Alter Table Mpln_Geo_Prod_Mts Add Constraint Mpln_Geo_Prod_Mts_Pk Primary Key (Agg_Cd, Mdo_Plan_Sk, Geo_Hier_Sk,Prod_Hier_Sk) using index Mpln_Geo_Prod_Mts_PK
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
alter table mpln_geo_prod_agg drop primary key drop index
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
Create Unique Index Mpln_Geo_Prod_Agg_PK On Mpln_Geo_Prod_Agg(Agg_Cd, Mdo_Plan_Sk, Geo_Hier_Sk,Prod_Hier_Sk) Nologging Parallel 20
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
Alter Table Mpln_Geo_Prod_Agg Add Constraint Mpln_Geo_Prod_Agg_Pk Primary Key (Agg_Cd, Mdo_Plan_Sk, Geo_Hier_Sk,Prod_Hier_Sk) using index Mpln_Geo_Prod_Agg_PK
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
alter table mpln_geo_prod_actual_mts drop primary key drop index
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
Create Unique Index Mpln_Geo_Prod_Actual_Mts_PK On Mpln_Geo_Prod_Actual_Mts(Agg_Cd, Mdo_Plan_Group_Sk, Geo_Hier_Sk,Prod_Hier_Sk) Nologging Parallel 20
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
Alter Table Mpln_Geo_Prod_Actual_Mts  Add Constraint Mpln_Geo_Prod_Actual_Mts_Pk Primary Key (Agg_Cd, Mdo_Plan_Group_Sk, Geo_Hier_Sk, Prod_Hier_Sk)  using Index Mpln_Geo_Prod_Actual_Mts_PK
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
alter table mpln_period_awr_mts drop primary key drop index
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
Create Unique Index Mpln_Period_Awr_Mts_PK
On Mpln_Period_Awr_Mts(Mdo_Plan_Sk, Prod_Hier_Sk, Start_Dt)
Nologging Parallel 20
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
Alter Table Mpln_Period_Awr_Mts
Add Constraint Mpln_Period_Awr_Mts_Pk Primary Key (Mdo_Plan_Sk, Prod_Hier_Sk, Start_Dt)  using Index Mpln_Period_Awr_Mts_PK
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
alter table mpln_price_chg drop primary key drop index
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
Create Unique Index Mpln_Price_Chg_PK On Mpln_Price_Chg(Mdo_Plan_Sk, Geo_Hier_Sk, Prod_Hier_Sk, Start_Dt) Nologging Parallel
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
Alter Table Mpln_Price_Chg
Add Constraint Mpln_Price_Chg_Pk Primary Key (Mdo_Plan_Sk, Geo_Hier_Sk, Prod_Hier_Sk, Start_Dt) using Index Mpln_Price_Chg_PK
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
alter table mpln_price_chg_appr drop primary key drop index
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
Create Unique Index Mpln_Price_Chg_Appr_PK
On Mpln_Price_Chg_Appr(Mdo_Plan_Sk, Geo_Hier_Sk, Start_Dt, Prod_Hier_Sk)
Nologging Parallel 20
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
Alter Table Mpln_Price_Chg_Appr
Add Constraint Mpln_Price_Chg_Appr_Pk Primary Key (Mdo_Plan_Sk, Geo_Hier_Sk, Start_Dt, Prod_Hier_Sk) using Index Mpln_Price_Chg_Appr_PK
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
 
/* This change only applies to Oracle.  Not needed in DB2. */
 
 
%end;
 
 
%if (&m_di_trans_vendor in (DB2)) %then %do;
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID675652;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID675652;
%put ERROR- Description                              : Rename PK and index names (mdo optimization target tables);
%put ERROR- Version                                  : D2TKMI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID675652;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID675652",
"Rename PK and index names (mdo optimization target tables)",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID675652:;
 
 
* End of changes for CHANGE_ID:ID675652;
 
 
***********************************************************************************************;
*************************************  End Change ID675652 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID684088 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID684088;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID684088")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID684088;
%goto ID684088;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D2TKMI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID684088;
* Insert record into change management table for CHANGE_ID: ID684088;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID684088",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID684088;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE)) %then %do;
 
%let m_sql_statement = %str(
ALTER TABLE FA_SCENARIO_STATUS ADD CREATED_DTTM DATE
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
ALTER TABLE FA_SCENARIO_STATUS ADD CREATED_DTTM DATE;
 
 
 
quit;
 
 
%end;
 
 
%if (&m_di_trans_vendor in (DB2)) %then %do;
 
 
%let m_sql_statement = %str(
ALTER TABLE FA_SCENARIO_STATUS ADD COLUMN CREATED_DTTM TIMESTAMP
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
REORG TABLE FA_SCENARIO_STATUS
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID684088;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID684088;
%put ERROR- Description                              : Add column to FA_SCENARIO_STATUS table;
%put ERROR- Version                                  : D2TKMI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID684088;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID684088",
"Add column to FA_SCENARIO_STATUS table",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID684088:;
 
 
* End of changes for CHANGE_ID:ID684088;
 
 
***********************************************************************************************;
*************************************  End Change ID684088 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID687879 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID687879;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID687879")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID687879;
%goto ID687879;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D2TKMI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID687879;
* Insert record into change management table for CHANGE_ID: ID687879;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID687879",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID687879;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE)) %then %do;
 
%let m_sql_statement = %str(
ALTER TABLE HISTORICAL_FIT ADD SALES_UNITS_UNACCOUNTED NUMERIC(12,2)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
ALTER TABLE HISTORICAL_FIT ADD SALES_UNITS_UNACCOUNTED NUMERIC(12,2);
 
 
 
quit;
 
 
%end;
 
 
%if (&m_di_trans_vendor in (DB2)) %then %do;
 
%let m_sql_statement = %str(
ALTER TABLE HISTORICAL_FIT ADD COLUMN SALES_UNITS_UNACCOUNTED NUMERIC(12,2)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
REORG TABLE HISTORICAL_FIT
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID687879;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID687879;
%put ERROR- Description                              : Add column to HISTORICAL_FIT table;
%put ERROR- Version                                  : D2TKMI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID687879;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID687879",
"Add column to HISTORICAL_FIT table",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID687879:;
 
 
* End of changes for CHANGE_ID:ID687879;
 
 
***********************************************************************************************;
*************************************  End Change ID687879 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID688960 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID688960;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID688960")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID688960;
%goto ID688960;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D2TKMI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID688960;
* Insert record into change management table for CHANGE_ID: ID688960;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID688960",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID688960;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
DELETE FROM FA_SPEC WHERE SPEC_NM = 'PCT_TAIL_CUTOFF'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO FA_SPEC (MODEL_GROUP_ID, SPEC_NM, SPEC_VALUE) VALUES (-1,'PCT_TAIL_CUTOFF','1')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
DELETE FROM FA_SPEC WHERE SPEC_NM = 'PCT_TAIL_CUTOFF';
 
 
INSERT INTO FA_SPEC (MODEL_GROUP_ID, SPEC_NM, SPEC_VALUE) VALUES (-1,'PCT_TAIL_CUTOFF','1');
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID688960;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID688960;
%put ERROR- Description                              : Add PCT_TAIL_CUTOFF FA spec;
%put ERROR- Version                                  : D2TKMI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID688960;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID688960",
"Add PCT_TAIL_CUTOFF FA spec",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID688960:;
 
 
* End of changes for CHANGE_ID:ID688960;
 
 
***********************************************************************************************;
*************************************  End Change ID688960 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID688967 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID688967;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID688967")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID688967;
%goto ID688967;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D2TKMI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID688967;
* Insert record into change management table for CHANGE_ID: ID688967;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID688967",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID688967;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
DELETE FROM FA_SPEC WHERE SPEC_NM = 'MIN_LIFE_FILTER'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO FA_SPEC (MODEL_GROUP_ID, SPEC_NM, SPEC_VALUE) VALUES (-1,'MIN_LIFE_FILTER','8')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
DELETE FROM FA_SPEC WHERE SPEC_NM = 'MIN_LIFE_FILTER';
 
 
INSERT INTO FA_SPEC (MODEL_GROUP_ID, SPEC_NM, SPEC_VALUE) VALUES (-1,'MIN_LIFE_FILTER','8');
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID688967;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID688967;
%put ERROR- Description                              : Add MIN_LIFE_FILTER FA spec;
%put ERROR- Version                                  : D2TKMI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID688967;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID688967",
"Add MIN_LIFE_FILTER FA spec",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID688967:;
 
 
* End of changes for CHANGE_ID:ID688967;
 
 
***********************************************************************************************;
*************************************  End Change ID688967 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID690047 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID690047;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID690047")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID690047;
%goto ID690047;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D2TKMI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID690047;
* Insert record into change management table for CHANGE_ID: ID690047;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID690047",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID690047;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE)) %then %do;
 
%let m_sql_statement = %str(
ALTER TABLE FA_SCENARIO_STATUS ADD PCT_ELASTICITY_DEFAULTED NUMERIC(12,4)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE FA_SCENARIO_STATUS RENAME COLUMN MEAN_PE TO WEIGHTED_MEAN_PE
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE FA_SPEC MODIFY SPEC_VALUE VARCHAR(200)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
 
proc sql;
 
 
ALTER TABLE FA_SCENARIO_STATUS ADD PCT_ELASTICITY_DEFAULTED NUMERIC(12,4);
 
 
ALTER TABLE FA_SPEC MODIFY SPEC_VALUE VARCHAR(200);
 
 
quit;
 
 
 
proc datasets library=&m_di_trans nolist;
 
 
modify FA_SCENARIO_STATUS ;
 
 
rename MEAN_PE=WEIGHTED_MEAN_PE;
 
 
quit;
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (DB2)) %then %do;
 
 
%let m_sql_statement = %str(
ALTER TABLE FA_SCENARIO_STATUS ADD COLUMN PCT_ELASTICITY_DEFAULTED NUMERIC(12,4)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE FA_SCENARIO_STATUS DROP COLUMN MEAN_PE
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE FA_SCENARIO_STATUS ADD  COLUMN WEIGHTED_MEAN_PE NUMERIC(12,2)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
ALTER TABLE FA_SPEC ALTER COLUMN SPEC_VALUE SET DATA TYPE VARCHAR(200)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
REORG TABLE FA_SCENARIO_STATUS
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID690047;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID690047;
%put ERROR- Description                              : Add new column PCT_ELASTICITY_DEFAULTED;
%put ERROR- Version                                  : D2TKMI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID690047;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID690047",
"Add new column PCT_ELASTICITY_DEFAULTED",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID690047:;
 
 
* End of changes for CHANGE_ID:ID690047;
 
 
***********************************************************************************************;
*************************************  End Change ID690047 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID693691 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID693691;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID693691")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID693691;
%goto ID693691;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D2TKMI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID693691;
* Insert record into change management table for CHANGE_ID: ID693691;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID693691",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID693691;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
DELETE FROM FA_SPEC WHERE SPEC_NM = 'RUN_FA_MONITORING'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO FA_SPEC (MODEL_GROUP_ID, SPEC_NM, SPEC_VALUE) VALUES (-1,'RUN_FA_MONITORING','0')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
DELETE FROM FA_SPEC WHERE SPEC_NM = 'RUN_FA_MONITORING';
 
 
INSERT INTO FA_SPEC (MODEL_GROUP_ID, SPEC_NM, SPEC_VALUE) VALUES (-1,'RUN_FA_MONITORING','0');
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID693691;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID693691;
%put ERROR- Description                              : Add RUN_FA_MONITORING FA spec;
%put ERROR- Version                                  : D2TKMI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID693691;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID693691",
"Add RUN_FA_MONITORING FA spec",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID693691:;
 
 
* End of changes for CHANGE_ID:ID693691;
 
 
***********************************************************************************************;
*************************************  End Change ID693691 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID690047_1 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID690047_1;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID690047_1")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID690047_1;
%goto ID690047_1;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D2TKMI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID690047_1;
* Insert record into change management table for CHANGE_ID: ID690047_1;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID690047_1",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID690047_1;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE)) %then %do;
 
%let m_sql_statement = %str(
ALTER TABLE FA_SCORE ADD PCT_ELASTICITY_DEFAULTED NUMERIC(12,4)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE FA_SCORE RENAME COLUMN MEAN_PE TO WEIGHTED_MEAN_PE
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
 
proc sql;
 
 
ALTER TABLE FA_SCORE ADD PCT_ELASTICITY_DEFAULTED NUMERIC(12,4);
 
 
quit;
 
 
 
proc datasets library=&m_di_trans nolist;
 
 
modify FA_SCORE ;
 
 
rename MEAN_PE=WEIGHTED_MEAN_PE;
 
 
quit;
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (DB2)) %then %do;
 
 
%let m_sql_statement = %str(
ALTER TABLE FA_SCORE ADD PCT_ELASTICITY_DEFAULTED NUMERIC(12,4)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE FA_SCORE DROP COLUMN MEAN_PE
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE FA_SCORE ADD  COLUMN WEIGHTED_MEAN_PE NUMERIC(12,2)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
REORG TABLE FA_SCORE
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID690047_1;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID690047_1;
%put ERROR- Description                              : Add new column PCT_ELASTICITY_DEFAULTED;
%put ERROR- Version                                  : D2TKMI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID690047_1;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID690047_1",
"Add new column PCT_ELASTICITY_DEFAULTED",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID690047_1:;
 
 
* End of changes for CHANGE_ID:ID690047_1;
 
 
***********************************************************************************************;
*************************************  End Change ID690047_1 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID695994 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID695994;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID695994")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID695994;
%goto ID695994;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D2TKMI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID695994;
* Insert record into change management table for CHANGE_ID: ID695994;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID695994",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID695994;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE)) %then %do;
 
%let m_sql_statement = %str(
CREATE TABLE PRODUCT_ATTRIBUTES
(
PROD_HIER_SK          INTEGER NOT NULL,
PROD_ATTR_SK          INTEGER NOT NULL,
PROD_ATTR_VALUE       VARCHAR(40) NOT NULL,
PRIMARY KEY(PROD_HIER_SK, PROD_ATTR_SK)
)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
CREATE TABLE GEOGRAPHY_ATTRIBUTES
(
GEO_HIER_SK          INTEGER NOT NULL,
GEO_ATTR_SK          INTEGER NOT NULL,
GEO_ATTR_VALUE       VARCHAR(40) NOT NULL,
PRIMARY KEY(GEO_HIER_SK, GEO_ATTR_SK)
)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
 
proc sql noprint;
 
 
 
CREATE TABLE PRODUCT_ATTRIBUTES
(
PROD_HIER_SK                       INTEGER NOT NULL,
PROD_ATTR_SK                       INTEGER NOT NULL,
PROD_ATTR_VALUE                    VARCHAR(40) NOT NULL
)
;
 
 
 
ALTER TABLE PRODUCT_ATTRIBUTES  add CONSTRAINT PRIM_KEY  PRIMARY KEY (PROD_HIER_SK,PROD_ATTR_SK);
 
 
 
 
CREATE TABLE GEOGRAPHY_ATTRIBUTES
(
GEO_HIER_SK                        INTEGER NOT NULL,
GEO_ATTR_SK                        INTEGER NOT NULL,
GEO_ATTR_VALUE                     VARCHAR(40) NOT NULL
)
;
 
 
 
ALTER TABLE GEOGRAPHY_ATTRIBUTES  add CONSTRAINT PRIM_KEY  PRIMARY KEY (GEO_HIER_SK,GEO_ATTR_SK);
 
 
 
 
quit;
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (DB2)) %then %do;
 
 
%let m_sql_statement = %str(
CREATE TABLE PRODUCT_ATTRIBUTES
(
PROD_HIER_SK          INTEGER NOT NULL,
PROD_ATTR_SK          INTEGER NOT NULL,
PROD_ATTR_VALUE       VARCHAR(40) NOT NULL,
PRIMARY KEY(PROD_HIER_SK, PROD_ATTR_SK)
)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
CREATE TABLE GEOGRAPHY_ATTRIBUTES
(
GEO_HIER_SK          INTEGER NOT NULL,
GEO_ATTR_SK          INTEGER NOT NULL,
GEO_ATTR_VALUE       VARCHAR(40) NOT NULL,
PRIMARY KEY(GEO_HIER_SK, GEO_ATTR_SK)
)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID695994;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID695994;
%put ERROR- Description                              : CRP PERFORMANCE Copy attributes tables to rdbms;
%put ERROR- Version                                  : D2TKMI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID695994;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID695994",
"CRP PERFORMANCE Copy attributes tables to rdbms",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID695994:;
 
 
* End of changes for CHANGE_ID:ID695994;
 
 
***********************************************************************************************;
*************************************  End Change ID695994 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID695068 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID695068;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID695068")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID695068;
%goto ID695068;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D2TKMI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID695068;
* Insert record into change management table for CHANGE_ID: ID695068;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID695068",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID695068;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE)) %then %do;
 
 
%let m_sql_statement = %str(
CREATE TABLE MA_SPEC
(
MODEL_GROUP_ID                     INTEGER NOT NULL,
SPEC_NM                            VARCHAR(32) NOT NULL,
SPEC_VALUE                         VARCHAR(200),
USER_NM                            VARCHAR(60) NOT NULL,
PRIMARY KEY (MODEL_GROUP_ID,SPEC_NM,USER_NM)
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
 
proc sql;
 
 
 
CREATE TABLE MA_SPEC
(
MODEL_GROUP_ID                     INTEGER NOT NULL,
SPEC_NM                            VARCHAR(32) NOT NULL,
SPEC_VALUE                         VARCHAR(200),
USER_NM                            VARCHAR(60) NOT NULL
)
;
 
 
 
ALTER TABLE MA_SPEC  add CONSTRAINT PRIM_KEY  PRIMARY KEY (MODEL_GROUP_ID,SPEC_NM,USER_NM);
 
 
 
quit;
 
 
%end;
 
 
%if (&m_di_trans_vendor in (DB2)) %then %do;
 
 
%let m_sql_statement = %str(
CREATE TABLE MA_SPEC
(
MODEL_GROUP_ID                     INTEGER NOT NULL,
SPEC_NM                            VARCHAR(32) NOT NULL,
SPEC_VALUE                         VARCHAR(200),
USER_NM                            VARCHAR(60) NOT NULL,
PRIMARY KEY (MODEL_GROUP_ID,SPEC_NM,USER_NM)
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID695068;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID695068;
%put ERROR- Description                              : ADD MA_SPEC table;
%put ERROR- Version                                  : D2TKMI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID695068;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID695068",
"ADD MA_SPEC table",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID695068:;
 
 
* End of changes for CHANGE_ID:ID695068;
 
 
***********************************************************************************************;
*************************************  End Change ID695068 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID699258 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID699258;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID699258")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID699258;
%goto ID699258;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D2TKMI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID699258;
* Insert record into change management table for CHANGE_ID: ID699258;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID699258",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID699258;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE)) %then %do;
 
%let m_sql_statement = %str(
DELETE FROM FA_SPEC WHERE SPEC_NM = 'HOLDOUT_DETAILS_TABLES'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO FA_SPEC (MODEL_GROUP_ID, SPEC_NM, SPEC_VALUE) VALUES (-1,'HOLDOUT_DETAILS_TABLES','HAA_PPE')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
DELETE FROM FA_SPEC WHERE SPEC_NM = 'HOLDOUT_DETAILS_TABLES';
 
 
INSERT INTO FA_SPEC (MODEL_GROUP_ID, SPEC_NM, SPEC_VALUE) VALUES (-1,'HOLDOUT_DETAILS_TABLES','HAA_PPE');
 
 
 
quit;
 
 
%end;
 
 
%if (&m_di_trans_vendor in (DB2)) %then %do;
 
 
%let m_sql_statement = %str(
DELETE FROM FA_SPEC WHERE SPEC_NM = 'HOLDOUT_DETAILS_TABLES'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO FA_SPEC (MODEL_GROUP_ID, SPEC_NM, SPEC_VALUE) VALUES (-1,'HOLDOUT_DETAILS_TABLES','HAA_PPE')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID699258;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID699258;
%put ERROR- Description                              : Add HOLDOUT_DETAILS_TABLES FA spec;
%put ERROR- Version                                  : D2TKMI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID699258;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID699258",
"Add HOLDOUT_DETAILS_TABLES FA spec",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID699258:;
 
 
* End of changes for CHANGE_ID:ID699258;
 
 
***********************************************************************************************;
*************************************  End Change ID699258 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID700983 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID700983;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID700983")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID700983;
%goto ID700983;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D2TKMI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID700983;
* Insert record into change management table for CHANGE_ID: ID700983;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID700983",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID700983;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE)) %then %do;
 
%let m_sql_statement = %str(
UPDATE FA_SPEC SET SPEC_VALUE = '8' WHERE SPEC_NM = 'HOLDOUT_PERIODS' AND MODEL_GROUP_ID = -1
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
UPDATE FA_SPEC SET SPEC_VALUE = '8' WHERE SPEC_NM = 'HOLDOUT_PERIODS' AND MODEL_GROUP_ID = -1;
 
 
 
quit;
 
 
%end;
 
 
%if (&m_di_trans_vendor in (DB2)) %then %do;
 
 
%let m_sql_statement = %str(
UPDATE FA_SPEC SET SPEC_VALUE = '8' WHERE SPEC_NM = 'HOLDOUT_PERIODS' AND MODEL_GROUP_ID = -1
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID700983;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID700983;
%put ERROR- Description                              : Change default value to 8 for HOLDOUT_PERIODS;
%put ERROR- Version                                  : D2TKMI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID700983;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID700983",
"Change default value to 8 for HOLDOUT_PERIODS",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID700983:;
 
 
* End of changes for CHANGE_ID:ID700983;
 
 
***********************************************************************************************;
*************************************  End Change ID700983 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID693806 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID693806;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID693806")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID693806;
%goto ID693806;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID693806;
* Insert record into change management table for CHANGE_ID: ID693806;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID693806",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID693806;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
alter table mdo_plan_alt_hier_prod drop primary key drop index
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
Create Unique Index mdo_plan_alt_hier_prod_PK On mdo_plan_alt_hier_prod(Mdo_Plan_Sk, Prod_Hier_Sk) Nologging Parallel 20
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
Alter Table mdo_plan_alt_hier_prod Add Constraint mdo_plan_alt_hier_prod_Pk Primary Key (Mdo_Plan_Sk, Prod_Hier_Sk) using index mdo_plan_alt_hier_prod_PK
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
/* No Change */
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID693806;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID693806;
%put ERROR- Description                              : Alter table mdo_plan_alt_hier_prod;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID693806;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID693806",
"Alter table mdo_plan_alt_hier_prod",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID693806:;
 
 
* End of changes for CHANGE_ID:ID693806;
 
 
***********************************************************************************************;
*************************************  End Change ID693806 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID684780 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID684780;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID684780")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID684780;
%goto ID684780;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(M1MI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID684780;
* Insert record into change management table for CHANGE_ID: ID684780;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID684780",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID684780;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE)) %then %do;
 
%let m_sql_statement = %str(
CREATE SEQUENCE SEQ_PKO_PO_IMPORT START WITH 100
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
/* No Change */
 
%end;
 
 
%if (&m_di_trans_vendor in (DB2)) %then %do;
 
%let m_sql_statement = %str(
CREATE SEQUENCE SEQ_PKO_PO_IMPORT
START WITH 100
CYCLE
MAXVALUE    2147483647
MINVALUE    1
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID684780;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID684780;
%put ERROR- Description                              : Add batch import of purchase order plans;
%put ERROR- Version                                  : M1MI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID684780;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID684780",
"Add batch import of purchase order plans",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID684780:;
 
 
* End of changes for CHANGE_ID:ID684780;
 
 
***********************************************************************************************;
*************************************  End Change ID684780 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID704238 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID704238;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID704238")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_trans..PRF_PROFILE))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_trans..PRF_PROFILE;
%put NOTE: Change ID                             :ID704238;
%goto ID704238;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID704238;
%goto ID704238;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(M1MI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID704238;
* Insert record into change management table for CHANGE_ID: ID704238;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID704238",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID704238;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
UPDATE PRF_PROFILE SET MANUAL_FLG = 3 WHERE MANUAL_FLG = 1
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
UPDATE PRF_PROFILE SET MANUAL_FLG = 3 WHERE MANUAL_FLG = 1;
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID704238;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID704238;
%put ERROR- Description                              : Avoid setting PRF_PROFILE.MANUAL_FLG = 1;
%put ERROR- Version                                  : M1MI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID704238;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID704238",
"Avoid setting PRF_PROFILE.MANUAL_FLG = 1",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID704238:;
 
 
* End of changes for CHANGE_ID:ID704238;
 
 
***********************************************************************************************;
*************************************  End Change ID704238 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID703394 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID703394;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID703394")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_trans..PRF_RSLT_SC_ACCURACY))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_trans..PRF_RSLT_SC_ACCURACY;
%put NOTE: Change ID                             :ID703394;
%goto ID703394;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID703394;
%goto ID703394;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(M1MI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID703394;
* Insert record into change management table for CHANGE_ID: ID703394;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID703394",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID703394;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
UPDATE PRF_RSLT_SC_ACCURACY SET TRN_ACCURACY = 1 WHERE TRN_ACCURACY IS NULL
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
UPDATE PRF_RSLT_SC_ACCURACY SET TRN_ACCURACY = 1 WHERE TRN_ACCURACY IS NULL;
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID703394;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID703394;
%put ERROR- Description                              : SZPF - Missing TRN_ACCURACY value causing UI to crash;
%put ERROR- Version                                  : M1MI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID703394;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID703394",
"SZPF - Missing TRN_ACCURACY value causing UI to crash",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID703394:;
 
 
* End of changes for CHANGE_ID:ID703394;
 
 
***********************************************************************************************;
*************************************  End Change ID703394 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID721016 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID721016;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID721016")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID721016;
%goto ID721016;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(M1MI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID721016;
* Insert record into change management table for CHANGE_ID: ID721016;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID721016",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID721016;
 
%end;
 
 
 
 
%put NOTE: Skipping this change since this change should never be applied.;
%put NOTE- Change ID                             :ID721016;
%goto ID721016;
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE)) %then %do;
 
%let m_sql_statement = %str(
CREATE INDEX RPP_PLAN_PROD_METRICS_IX1 ON RPP_PLAN_PROD_METRICS
(
PLAN_SK
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
 
proc sql;
 
 
CREATE INDEX PLAN_SK ON RPP_PLAN_PROD_METRICS
(
PLAN_SK
)
;
 
 
 
quit;
 
 
%end;
 
 
%if (&m_di_trans_vendor in (DB2)) %then %do;
 
 
%let m_sql_statement = %str(
CREATE INDEX RPP_PLAN_PROD_METRICS_IX1 ON RPP_PLAN_PROD_METRICS
(
PLAN_SK
) ALLOW REVERSE SCANS
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID721016;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID721016;
%put ERROR- Description                              : Need RPP indices for performance;
%put ERROR- Version                                  : M1MI42;
%put ERROR- Date of Change                           : 31DEC2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID721016;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID721016",
"Need RPP indices for performance",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID721016:;
 
 
* End of changes for CHANGE_ID:ID721016;
 
 
***********************************************************************************************;
*************************************  End Change ID721016 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID744028 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID744028;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID744028")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID744028;
%goto ID744028;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52,M1TKMI43);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID744028;
* Insert record into change management table for CHANGE_ID: ID744028;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
'ID744028',
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID744028;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE)) %then %do;
 
%let m_sql_statement = %str(
CREATE INDEX MPLN_GPR_AGG_CD_PHSK_IX ON MPLN_GEO_PROD_RESULT
(
AGG_CD,
PROD_HIER_SK
)
NOLOGGING
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
CREATE INDEX MPLN_GPR_AGG_CD_PHSK_IX ON MPLN_GEO_PROD_RESULT
(
AGG_CD,
PROD_HIER_SK
)
;
 
 
quit;
 
 
%end;
 
 
%if (&m_di_trans_vendor in (DB2)) %then %do;
 
%let m_sql_statement = %str(
CREATE INDEX MPLN_GPR_AGG_CD_PHSK_IX ON MPLN_GEO_PROD_RESULT
(
AGG_CD,
PROD_HIER_SK
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID744028;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID744028;
%put ERROR- Description                              : MDO Approvals: Fix non-performant query for "all items" filter;
%put ERROR- Version                                  : D3MICM52,M1TKMI43;
%put ERROR- Date of Change                           : 17MAR2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID744028;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
'ID744028',
'MDO Approvals: Fix non-performant query for "all items" filter',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID744028:;
 
 
* End of changes for CHANGE_ID:ID744028;
 
 
***********************************************************************************************;
*************************************  End Change ID744028 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID741532 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID741532;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID741532")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID741532;
%goto ID741532;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID741532;
* Insert record into change management table for CHANGE_ID: ID741532;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID741532",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID741532;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
 
proc sql;
 
 
DELETE FROM PURGE_QUERY WHERE TABLE_NM='GEO_PROD';
 
 
INSERT INTO purge_query
(table_nm ,database_nm ,purge_order ,purge_frequency ,purge_query_txt, num_days_preserved ,partition_flg ,app_nm)
VALUES  ('GEO_PROD', 'SAS', 13, 91, '%di_purge_geo_prod(libref=DI_DM,dsn=GEO_PROD);', 1103,1,'ALL');
 
 
 
DELETE FROM PURGE_QUERY WHERE TABLE_NM='GEO_PROD_STATUS';
 
 
INSERT INTO purge_query
(table_nm ,database_nm ,purge_order ,purge_frequency ,purge_query_txt, num_days_preserved ,partition_flg ,app_nm)
VALUES ('GEO_PROD_STATUS', 'SAS', 12, 91, '%di_purge_geo_prod_status(libref=DI_DM,dsn=GEO_PROD_STATUS);', 1103,1,'ALL');
 
 
 
 
DELETE FROM PURGE_QUERY WHERE TABLE_NM='FUTURE_RECEIPT';
 
 
INSERT INTO purge_query
(table_nm ,database_nm ,purge_order ,purge_frequency ,purge_query_txt, num_days_preserved ,partition_flg ,app_nm)
VALUES ('FUTURE_RECEIPT ', 'SAS',  4, 91,'%di_purge_future_receipt(libref=DI_DM); ',1103 ,1,'ALL');
 
 
 
 
DELETE FROM PURGE_QUERY WHERE TABLE_NM='RETURN_FACT';
 
 
INSERT INTO purge_query
(table_nm ,database_nm ,purge_order ,purge_frequency ,purge_query_txt, num_days_preserved ,partition_flg ,app_nm)
VALUES ('RETURN_FACT', 'SAS',  1, 91,'%di_purge_return_fact(libref=di_dm); ',1103,1,'ALL');
 
 
 
 
DELETE FROM PURGE_QUERY WHERE TABLE_NM='DOW_SALES_FACT';
 
 
INSERT INTO purge_query
(table_nm ,database_nm ,purge_order ,purge_frequency ,purge_query_txt, num_days_preserved ,partition_flg ,app_nm)
VALUES ('DOW_SALES_FACT', 'SAS', 2, 7, '%di_purge_dow_sales_fact(libref=DI_DM);', 180,1,'ALL');
 
 
 
DELETE FROM PURGE_QUERY WHERE TABLE_NM='DOW_EVENT_SALES_FACT';
 
 
INSERT INTO purge_query
(table_nm ,database_nm ,purge_order ,purge_frequency ,purge_query_txt, num_days_preserved ,partition_flg ,app_nm)
VALUES ('DOW_EVENT_SALES_FACT', 'SAS', 2, 7, '%di_purge_dow_event_sales_fact(libref=DI_DM);', 365,1,'ALL');
 
 
 
quit;
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
 
proc sql;
 
 
DELETE FROM PURGE_QUERY WHERE TABLE_NM='GEO_PROD';
 
 
INSERT INTO purge_query
(table_nm ,database_nm ,purge_order ,purge_frequency ,purge_query_txt, num_days_preserved ,partition_flg ,app_nm)
VALUES  ('GEO_PROD', 'SAS', 13, 91, '%di_purge_geo_prod(libref=DI_DM,dsn=GEO_PROD);', 1103,1,'ALL');
 
 
 
DELETE FROM PURGE_QUERY WHERE TABLE_NM='GEO_PROD_STATUS';
 
 
INSERT INTO purge_query
(table_nm ,database_nm ,purge_order ,purge_frequency ,purge_query_txt, num_days_preserved ,partition_flg ,app_nm)
VALUES ('GEO_PROD_STATUS', 'SAS', 12, 91, '%di_purge_geo_prod_status(libref=DI_DM,dsn=GEO_PROD_STATUS);', 1103,1,'ALL');
 
 
 
 
DELETE FROM PURGE_QUERY WHERE TABLE_NM='FUTURE_RECEIPT';
 
 
INSERT INTO purge_query
(table_nm ,database_nm ,purge_order ,purge_frequency ,purge_query_txt, num_days_preserved ,partition_flg ,app_nm)
VALUES ('FUTURE_RECEIPT ', 'SAS',  4, 91,'%di_purge_future_receipt(libref=DI_DM); ',1103 ,1,'ALL');
 
 
 
 
DELETE FROM PURGE_QUERY WHERE TABLE_NM='RETURN_FACT';
 
 
INSERT INTO purge_query
(table_nm ,database_nm ,purge_order ,purge_frequency ,purge_query_txt, num_days_preserved ,partition_flg ,app_nm)
VALUES ('RETURN_FACT', 'SAS',  1, 91,'%di_purge_return_fact(libref=di_dm); ',1103,1,'ALL');
 
 
 
 
DELETE FROM PURGE_QUERY WHERE TABLE_NM='DOW_SALES_FACT';
 
 
INSERT INTO purge_query
(table_nm ,database_nm ,purge_order ,purge_frequency ,purge_query_txt, num_days_preserved ,partition_flg ,app_nm)
VALUES ('DOW_SALES_FACT', 'SAS', 2, 7, '%di_purge_dow_sales_fact(libref=DI_DM);', 180,1,'ALL');
 
 
 
DELETE FROM PURGE_QUERY WHERE TABLE_NM='DOW_EVENT_SALES_FACT';
 
 
INSERT INTO purge_query
(table_nm ,database_nm ,purge_order ,purge_frequency ,purge_query_txt, num_days_preserved ,partition_flg ,app_nm)
VALUES ('DOW_EVENT_SALES_FACT', 'SAS', 2, 7, '%di_purge_dow_event_sales_fact(libref=DI_DM);', 365,1,'ALL');
 
 
 
quit;
 
 
 
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID741532;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID741532;
%put ERROR- Description                              : Time base purge routine macro required for SZPF partitioned tables;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 24MAR2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID741532;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID741532",
"Time base purge routine macro required for SZPF partitioned tables",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID741532:;
 
 
* End of changes for CHANGE_ID:ID741532;
 
 
***********************************************************************************************;
*************************************  End Change ID741532 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change MOVE_RPP_AGG_TO_RDBMS ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: MOVE_RPP_AGG_TO_RDBMS;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("MOVE_RPP_AGG_TO_RDBMS")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : MOVE_RPP_AGG_TO_RDBMS;
%goto MOVE_RPP_AGG_TO_RDBMS;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : MOVE_RPP_AGG_TO_RDBMS;
* Insert record into change management table for CHANGE_ID: MOVE_RPP_AGG_TO_RDBMS;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"MOVE_RPP_AGG_TO_RDBMS",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto MOVE_RPP_AGG_TO_RDBMS;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
CREATE TABLE AGGREGATION_METRICS (
OBJECT_CAT_TYPE INTEGER NOT NULL,
OBJECT_CAT_SK INTEGER NOT NULL,
 
PROD_LVL INTEGER NOT NULL,
GEO_LVL INTEGER NOT NULL,
 
ORIG_FISCAL_START_DT DATE,
FISCAL_START_DT DATE NOT NULL,
 
PARENT_PROD_HIER_SK INTEGER NOT NULL,
PARENT_GEO_HIER_SK INTEGER NOT NULL,
 
LY_SALES_AMT NUMERIC(20,3),
LY_UNITS NUMERIC(12,2),
LY_GM_PCT NUMERIC(12,4),
LY_GM_AMT NUMERIC(20,3),
LY_PROMO_MARKDN_AMT NUMERIC(20,3),
LY_PROMO_BLEND_PCT NUMERIC(12,4),
LY_CLOSE_INV_UNITS NUMERIC(20,3),
LY_CLOSE_INV_VAL_RETAIL_AMT NUMERIC(20,3),
LY_N_PROMO_ITEMS NUMERIC(12,2),
 
CURR_UNITS NUMERIC(12,2),
CURR_SALES_AMT NUMERIC(20,3),
CURR_GM_PCT NUMERIC(12,4),
CURR_GM_AMT NUMERIC(20,3),
CURR_PROMO_MARKDN_AMT NUMERIC(20,3),
CURR_PROMO_BLEND_PCT NUMERIC(12,4),
CURR_CLOSE_INV_UNITS NUMERIC(12,2),
CURR_CLOSE_INV_VAL_RETAIL_AMT NUMERIC(20,3),
CURR_N_PROMO_ITEMS NUMERIC(20,3),
 
TA_UNITS NUMERIC(12,2),
TA_SALES_AMT NUMERIC(20,3),
TA_GM_AMT NUMERIC(20,3),
TA_GM_PCT NUMERIC(12,4),
TA_PROMO_MARKDN_AMT NUMERIC(20,3),
TA_PROMO_BLEND_PCT NUMERIC(12,4),
TA_N_PROMO_ITEMS NUMERIC(12,2),
TA_CLOSE_INV_UNITS NUMERIC(12,2),
TA_CLOSE_INV_VAL_RETAIL_AMT NUMERIC(20,3),
 
FCST_UNITS NUMERIC(12,2),
FCST_SALES_AMT NUMERIC(20,3),
FCST_GM_AMT NUMERIC(20,3),
FCST_GM_PCT NUMERIC(12,4),
FCST_PROMO_MARKDN_AMT NUMERIC(20,3),
FCST_PROMO_BLEND_PCT NUMERIC(12,4),
FCST_N_PROMO_ITEMS NUMERIC(12,2),
FCST_CLOSE_INV_UNITS NUMERIC(12,2),
FCST_CLOSE_INV_VAL_RETAIL_AMT NUMERIC(20,3),
 
PRIMARY KEY (OBJECT_CAT_TYPE, OBJECT_CAT_SK, PARENT_PROD_HIER_SK, PARENT_GEO_HIER_SK, FISCAL_START_DT)
)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
 
proc sql;
 
 
CREATE TABLE AGGREGATION_METRICS (
OBJECT_CAT_TYPE INTEGER NOT NULL,
OBJECT_CAT_SK INTEGER NOT NULL,
 
PROD_LVL INTEGER NOT NULL,
GEO_LVL INTEGER NOT NULL,
 
ORIG_FISCAL_START_DT DATE,
FISCAL_START_DT DATE NOT NULL,
 
PARENT_PROD_HIER_SK INTEGER NOT NULL,
PARENT_GEO_HIER_SK INTEGER NOT NULL,
 
LY_SALES_AMT NUMERIC(20,3),
LY_UNITS NUMERIC(12,2),
LY_GM_PCT NUMERIC(12,4),
LY_GM_AMT NUMERIC(20,3),
LY_PROMO_MARKDN_AMT NUMERIC(20,3),
LY_PROMO_BLEND_PCT NUMERIC(12,4),
LY_CLOSE_INV_UNITS NUMERIC(20,3),
LY_CLOSE_INV_VAL_RETAIL_AMT NUMERIC(20,3),
LY_N_PROMO_ITEMS NUMERIC(12,2),
 
CURR_UNITS NUMERIC(12,2),
CURR_SALES_AMT NUMERIC(20,3),
CURR_GM_PCT NUMERIC(12,4),
CURR_GM_AMT NUMERIC(20,3),
CURR_PROMO_MARKDN_AMT NUMERIC(20,3),
CURR_PROMO_BLEND_PCT NUMERIC(12,4),
CURR_CLOSE_INV_UNITS NUMERIC(12,2),
CURR_CLOSE_INV_VAL_RETAIL_AMT NUMERIC(20,3),
CURR_N_PROMO_ITEMS NUMERIC(20,3),
 
TA_UNITS NUMERIC(12,2),
TA_SALES_AMT NUMERIC(20,3),
TA_GM_AMT NUMERIC(20,3),
TA_GM_PCT NUMERIC(12,4),
TA_PROMO_MARKDN_AMT NUMERIC(20,3),
TA_PROMO_BLEND_PCT NUMERIC(12,4),
TA_N_PROMO_ITEMS NUMERIC(12,2),
TA_CLOSE_INV_UNITS NUMERIC(12,2),
TA_CLOSE_INV_VAL_RETAIL_AMT NUMERIC(20,3),
 
FCST_UNITS NUMERIC(12,2),
FCST_SALES_AMT NUMERIC(20,3),
FCST_GM_AMT NUMERIC(20,3),
FCST_GM_PCT NUMERIC(12,4),
FCST_PROMO_MARKDN_AMT NUMERIC(20,3),
FCST_PROMO_BLEND_PCT NUMERIC(12,4),
FCST_N_PROMO_ITEMS NUMERIC(12,2),
FCST_CLOSE_INV_UNITS NUMERIC(12,2),
FCST_CLOSE_INV_VAL_RETAIL_AMT NUMERIC(20,3)
 
);
 
 
 
ALTER TABLE AGGREGATION_METRICS  add CONSTRAINT PRIM_KEY  PRIMARY KEY
(OBJECT_CAT_TYPE, OBJECT_CAT_SK, PARENT_PROD_HIER_SK, PARENT_GEO_HIER_SK, FISCAL_START_DT);
 
 
 
quit;
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: MOVE_RPP_AGG_TO_RDBMS;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: MOVE_RPP_AGG_TO_RDBMS;
%put ERROR- Description                              : Move RPP_CAL_AGG and RPP_CAT_AGG tables to RDMBS;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 23MAR2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: MOVE_RPP_AGG_TO_RDBMS;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"MOVE_RPP_AGG_TO_RDBMS",
"Move RPP_CAL_AGG and RPP_CAT_AGG tables to RDMBS",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%MOVE_RPP_AGG_TO_RDBMS:;
 
 
* End of changes for CHANGE_ID:MOVE_RPP_AGG_TO_RDBMS;
 
 
***********************************************************************************************;
*************************************  End Change MOVE_RPP_AGG_TO_RDBMS ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID739114 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID739114;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID739114")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID739114;
%goto ID739114;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID739114;
* Insert record into change management table for CHANGE_ID: ID739114;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID739114",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID739114;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
 
proc sql;
 
 
DELETE FROM PURGE_QUERY WHERE TABLE_NM='MPLN_MTS';
 
 
INSERT INTO purge_query
(table_nm, database_nm, purge_order, purge_frequency,purge_query_txt, num_days_preserved, partition_flg, app_nm)
VALUES ('MPLN_MTS', 'SAS', 1, 7, '%di_purge_mpln_metrics(libref=di_data);', 30,1, 'ALL');
 
 
 
 
DELETE FROM PURGE_QUERY WHERE TABLE_NM='GEO_PROD';
 
 
INSERT INTO purge_query
(table_nm ,database_nm ,purge_order ,purge_frequency ,purge_query_txt, num_days_preserved ,partition_flg ,app_nm)
VALUES  ('GEO_PROD', 'SAS', 13, 91, '%di_purge_geo_prod(libref=DI_DM,dsn=GEO_PROD);', 1103,1,'ALL');
 
 
 
DELETE FROM PURGE_QUERY WHERE TABLE_NM='GEO_PROD_STATUS';
 
 
INSERT INTO purge_query
(table_nm ,database_nm ,purge_order ,purge_frequency ,purge_query_txt, num_days_preserved ,partition_flg ,app_nm)
VALUES ('GEO_PROD_STATUS', 'SAS', 12, 91, '%di_purge_geo_prod_status(libref=DI_DM,dsn=GEO_PROD_STATUS);', 1103,1,'ALL');
 
 
 
 
DELETE FROM PURGE_QUERY WHERE TABLE_NM='FUTURE_RECEIPT';
 
 
INSERT INTO purge_query
(table_nm ,database_nm ,purge_order ,purge_frequency ,purge_query_txt, num_days_preserved ,partition_flg ,app_nm)
VALUES ('FUTURE_RECEIPT ', 'SAS',  4, 91,'%di_purge_future_receipt(libref=DI_DM); ',1103 ,1,'ALL');
 
 
 
 
DELETE FROM PURGE_QUERY WHERE TABLE_NM='RETURN_FACT';
 
 
INSERT INTO purge_query
(table_nm ,database_nm ,purge_order ,purge_frequency ,purge_query_txt, num_days_preserved ,partition_flg ,app_nm)
VALUES ('RETURN_FACT', 'SAS',  1, 91,'%di_purge_return_fact(libref=di_dm); ',1103,1,'ALL');
 
 
 
 
DELETE FROM PURGE_QUERY WHERE TABLE_NM='DOW_SALES_FACT';
 
 
INSERT INTO purge_query
(table_nm ,database_nm ,purge_order ,purge_frequency ,purge_query_txt, num_days_preserved ,partition_flg ,app_nm)
VALUES ('DOW_SALES_FACT', 'SAS', 2, 7, '%di_purge_dow_sales_fact(libref=DI_DM);', 180,1,'ALL');
 
 
 
DELETE FROM PURGE_QUERY WHERE TABLE_NM='DOW_EVENT_SALES_FACT';
 
 
INSERT INTO purge_query
(table_nm ,database_nm ,purge_order ,purge_frequency ,purge_query_txt, num_days_preserved ,partition_flg ,app_nm)
VALUES ('DOW_EVENT_SALES_FACT', 'SAS', 2, 7, '%di_purge_dow_event_sales_fact(libref=DI_DM);', 365,1,'ALL');
 
 
 
quit;
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
 
proc sql;
 
 
DELETE FROM PURGE_QUERY WHERE TABLE_NM='MPLN_MTS';
 
 
INSERT INTO purge_query
(table_nm, database_nm, purge_order, purge_frequency,purge_query_txt, num_days_preserved, partition_flg, app_nm)
VALUES ('MPLN_MTS', 'SAS', 1, 7, '%di_purge_mpln_metrics(libref=di_data);', 30,1, 'ALL');
 
 
 
 
DELETE FROM PURGE_QUERY WHERE TABLE_NM='GEO_PROD';
 
 
INSERT INTO purge_query
(table_nm ,database_nm ,purge_order ,purge_frequency ,purge_query_txt, num_days_preserved ,partition_flg ,app_nm)
VALUES  ('GEO_PROD', 'SAS', 13, 91, '%di_purge_geo_prod(libref=DI_DM,dsn=GEO_PROD);', 1103,1,'ALL');
 
 
 
DELETE FROM PURGE_QUERY WHERE TABLE_NM='GEO_PROD_STATUS';
 
 
INSERT INTO purge_query
(table_nm ,database_nm ,purge_order ,purge_frequency ,purge_query_txt, num_days_preserved ,partition_flg ,app_nm)
VALUES ('GEO_PROD_STATUS', 'SAS', 12, 91, '%di_purge_geo_prod_status(libref=DI_DM,dsn=GEO_PROD_STATUS);', 1103,1,'ALL');
 
 
 
 
DELETE FROM PURGE_QUERY WHERE TABLE_NM='FUTURE_RECEIPT';
 
 
INSERT INTO purge_query
(table_nm ,database_nm ,purge_order ,purge_frequency ,purge_query_txt, num_days_preserved ,partition_flg ,app_nm)
VALUES ('FUTURE_RECEIPT ', 'SAS',  4, 91,'%di_purge_future_receipt(libref=DI_DM); ',1103 ,1,'ALL');
 
 
 
 
DELETE FROM PURGE_QUERY WHERE TABLE_NM='RETURN_FACT';
 
 
INSERT INTO purge_query
(table_nm ,database_nm ,purge_order ,purge_frequency ,purge_query_txt, num_days_preserved ,partition_flg ,app_nm)
VALUES ('RETURN_FACT', 'SAS',  1, 91,'%di_purge_return_fact(libref=di_dm); ',1103,1,'ALL');
 
 
 
 
DELETE FROM PURGE_QUERY WHERE TABLE_NM='DOW_SALES_FACT';
 
 
INSERT INTO purge_query
(table_nm ,database_nm ,purge_order ,purge_frequency ,purge_query_txt, num_days_preserved ,partition_flg ,app_nm)
VALUES ('DOW_SALES_FACT', 'SAS', 2, 7, '%di_purge_dow_sales_fact(libref=DI_DM);', 180,1,'ALL');
 
 
 
DELETE FROM PURGE_QUERY WHERE TABLE_NM='DOW_EVENT_SALES_FACT';
 
 
INSERT INTO purge_query
(table_nm ,database_nm ,purge_order ,purge_frequency ,purge_query_txt, num_days_preserved ,partition_flg ,app_nm)
VALUES ('DOW_EVENT_SALES_FACT', 'SAS', 2, 7, '%di_purge_dow_event_sales_fact(libref=DI_DM);', 365,1,'ALL');
 
 
 
quit;
 
 
 
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID739114;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID739114;
%put ERROR- Description                              : Seed_rdbms needs any entry for purging mpln* tables;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 24MAR2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID739114;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID739114",
"Seed_rdbms needs any entry for purging mpln* tables",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID739114:;
 
 
* End of changes for CHANGE_ID:ID739114;
 
 
***********************************************************************************************;
*************************************  End Change ID739114 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID0735224 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID0735224;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID0735224")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_trans..PROFILE_CLUSTER))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_trans..PROFILE_CLUSTER;
%put NOTE: Change ID                             :ID0735224;
%goto ID0735224;
 
%end;
%if not (%sysfunc(exist(&m_di_trans..PROFILE_SCORE_SETTING))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_trans..PROFILE_SCORE_SETTING;
%put NOTE: Change ID                             :ID0735224;
%goto ID0735224;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID0735224;
%goto ID0735224;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID0735224;
* Insert record into change management table for CHANGE_ID: ID0735224;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID0735224",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID0735224;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE)) %then %do;
%let m_sql_statement = %str(
ALTER TABLE PROFILE_CLUSTER ADD CLASSIFIED_FLG SMALLINT
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE PROFILE_SCORE_SETTING ADD CLASSIFIED_STORE_PENALTY INTEGER
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE REQ_PROFILE_SCORE ADD CLASSIFIED_STORE_PENALTY INTEGER
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
ALTER TABLE &m_di_trans..PROFILE_SCORE_SETTING ADD CLASSIFIED_STORE_PENALTY INTEGER;
 
 
ALTER TABLE &m_di_trans..REQ_PROFILE_SCORE ADD CLASSIFIED_STORE_PENALTY INTEGER;
 
 
quit;
 
 
 
data work.PROFILE_CLUSTER_OLD;
 
 
set &m_di_trans..PROFILE_CLUSTER;
 
 
attrib CLASSIFIED_FLG length=3;
 
 
run;
 
 
 
data &m_di_trans..PROFILE_CLUSTER;
 
 
attrib   PROFILE_ID      length=8;
 
 
attrib   GEO_HIER_SK     length=8;
 
 
attrib   CLUSTER_ID      length=8;
 
 
attrib   CLASSIFIED_FLG  length=3;
 
 
stop; run;
 
 
 
proc sql;
 
 
ALTER TABLE &m_di_trans..PROFILE_CLUSTER  add CONSTRAINT PRIM_KEY  PRIMARY KEY (PROFILE_ID,GEO_HIER_SK);
 
 
quit;
 
 
 
proc append base=&m_di_trans..PROFILE_CLUSTER
data= work.PROFILE_CLUSTER_OLD force;
 
 
quit;
 
 
 
proc sql;
 
 
drop table work.PROFILE_CLUSTER_OLD;
 
 
quit;
 
 
%end;
 
 
%if (&m_di_trans_vendor in (DB2)) %then %do;
%let m_sql_statement = %str(
ALTER TABLE PROFILE_CLUSTER ADD CLASSIFIED_FLG SMALLINT
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE PROFILE_SCORE_SETTING ADD CLASSIFIED_STORE_PENALTY INTEGER
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE REQ_PROFILE_SCORE ADD CLASSIFIED_STORE_PENALTY INTEGER
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID0735224;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID0735224;
%put ERROR- Description                              : Penalize classified stores in profile scoring;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 04APR2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID0735224;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID0735224",
"Penalize classified stores in profile scoring",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID0735224:;
 
 
* End of changes for CHANGE_ID:ID0735224;
 
 
***********************************************************************************************;
*************************************  End Change ID0735224 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID738983 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID738983;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID738983")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID738983;
%goto ID738983;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID738983;
* Insert record into change management table for CHANGE_ID: ID738983;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID738983",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID738983;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE)) %then %do;
%let m_sql_statement = %str(
ALTER TABLE PRODUCT_DM DROP COLUMN MIN_INV_LVL
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
ALTER TABLE PRODUCT_DM DROP COLUMN MIN_INV_LVL;
 
 
quit;
 
 
%end;
 
 
%if (&m_di_trans_vendor in (DB2)) %then %do;
%let m_sql_statement = %str(
ALTER TABLE PRODUCT_DM DROP COLUMN MIN_INV_LVL
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID738983;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID738983;
%put ERROR- Description                              : Move min_inv_lvl from PRODUCT_DM to GEO_PROD;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 05APR2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID738983;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID738983",
"Move min_inv_lvl from PRODUCT_DM to GEO_PROD",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID738983:;
 
 
* End of changes for CHANGE_ID:ID738983;
 
 
***********************************************************************************************;
*************************************  End Change ID738983 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change DROP_MIN_INV_LVL ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: DROP_MIN_INV_LVL;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("DROP_MIN_INV_LVL")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : DROP_MIN_INV_LVL;
%goto DROP_MIN_INV_LVL;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : DROP_MIN_INV_LVL;
* Insert record into change management table for CHANGE_ID: DROP_MIN_INV_LVL;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"DROP_MIN_INV_LVL",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto DROP_MIN_INV_LVL;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE)) %then %do;
%let m_sql_statement = %str(
ALTER TABLE PKO_PRODUCT_DM DROP COLUMN MIN_INV_LVL
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
DROP VIEW PKO_PRODUCT_DM_ALL
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
CREATE VIEW PKO_PRODUCT_DM_ALL AS
SELECT PROD_HIER_SK,PROD_ID,PROD_NM,STD_HIER_PROD_LVL,PROD_DESC,PROD_INTRODUCTION_DT,PROD_DISCONTINUED_DT,
VOLUME,VOLUME_BASE_UOM,BRAND_NM,STD_HIER_LEAF_NODE_FLG,MODEL_PROD_FLG,CREATED_DTTM
FROM PRODUCT_DM
UNION SELECT PROD_HIER_SK,PROD_ID,PROD_NM,STD_HIER_PROD_LVL,PROD_DESC,PROD_INTRODUCTION_DT,PROD_DISCONTINUED_DT,
VOLUME,VOLUME_BASE_UOM,BRAND_NM,STD_HIER_LEAF_NODE_FLG,MODEL_PROD_FLG,CREATED_DTTM
FROM PKO_PRODUCT_DM
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
 
proc sql;
 
 
 
DROP TABLE PKO_PRODUCT_DM_ALL;
 
 
 
ALTER TABLE PKO_PRODUCT_DM DROP COLUMN MIN_INV_LVL;
 
 
 
DROP VIEW PKO_PRODUCT_DM_ALL;
 
 
 
 
CREATE VIEW PKO_PRODUCT_DM_ALL AS
SELECT PROD_HIER_SK,PROD_ID,PROD_NM,STD_HIER_PROD_LVL,PROD_DESC,PROD_INTRODUCTION_DT,PROD_DISCONTINUED_DT,
VOLUME,VOLUME_BASE_UOM,BRAND_NM,STD_HIER_LEAF_NODE_FLG,MODEL_PROD_FLG,CREATED_DTTM
FROM PRODUCT_DM
UNION SELECT PROD_HIER_SK,PROD_ID,PROD_NM,STD_HIER_PROD_LVL,PROD_DESC,PROD_INTRODUCTION_DT,PROD_DISCONTINUED_DT,
VOLUME,VOLUME_BASE_UOM,BRAND_NM,STD_HIER_LEAF_NODE_FLG,MODEL_PROD_FLG,CREATED_DTTM
FROM PKO_PRODUCT_DM;
 
 
 
quit;
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (DB2)) %then %do;
%let m_sql_statement = %str(
ALTER TABLE PKO_PRODUCT_DM DROP COLUMN MIN_INV_LVL
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
DROP VIEW PKO_PRODUCT_DM_ALL
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
CREATE VIEW PKO_PRODUCT_DM_ALL AS
SELECT PROD_HIER_SK,PROD_ID,PROD_NM,STD_HIER_PROD_LVL,PROD_DESC,PROD_INTRODUCTION_DT,PROD_DISCONTINUED_DT,
VOLUME,VOLUME_BASE_UOM,BRAND_NM,STD_HIER_LEAF_NODE_FLG,MODEL_PROD_FLG,CREATED_DTTM
FROM PRODUCT_DM
UNION SELECT PROD_HIER_SK,PROD_ID,PROD_NM,STD_HIER_PROD_LVL,PROD_DESC,PROD_INTRODUCTION_DT,PROD_DISCONTINUED_DT,
VOLUME,VOLUME_BASE_UOM,BRAND_NM,STD_HIER_LEAF_NODE_FLG,MODEL_PROD_FLG,CREATED_DTTM
FROM PKO_PRODUCT_DM
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: DROP_MIN_INV_LVL;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: DROP_MIN_INV_LVL;
%put ERROR- Description                              : Drop min_inv_lvl from PKO_PRODUCT_DM table and view;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 13APR2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: DROP_MIN_INV_LVL;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"DROP_MIN_INV_LVL",
"Drop min_inv_lvl from PKO_PRODUCT_DM table and view",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%DROP_MIN_INV_LVL:;
 
 
* End of changes for CHANGE_ID:DROP_MIN_INV_LVL;
 
 
***********************************************************************************************;
*************************************  End Change DROP_MIN_INV_LVL ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID750213 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID750213;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID750213")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID750213;
%goto ID750213;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID750213;
* Insert record into change management table for CHANGE_ID: ID750213;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID750213",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID750213;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE)) %then %do;
%let m_sql_statement = %str(
ALTER TABLE DI_JOB_RO_STATUS ADD PARTITION_NUMBER VARCHAR(32)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
ALTER TABLE DI_JOB_RO_STATUS ADD PARTITION_NUMBER VARCHAR(32);
 
 
quit;
 
 
%end;
 
 
%if (&m_di_trans_vendor in (DB2)) %then %do;
%let m_sql_statement = %str(
ALTER TABLE DI_JOB_RO_STATUS ADD PARTITION_NUMBER VARCHAR(32)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID750213;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID750213;
%put ERROR- Description                              : Adding new column PARTITION_NUMBER in DI_JOB_RO_STATUS.;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 05APR2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID750213;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID750213",
"Adding new column PARTITION_NUMBER in DI_JOB_RO_STATUS.",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID750213:;
 
 
* End of changes for CHANGE_ID:ID750213;
 
 
***********************************************************************************************;
*************************************  End Change ID750213 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID746931_1 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID746931_1;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID746931_1")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID746931_1;
%goto ID746931_1;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID746931_1;
* Insert record into change management table for CHANGE_ID: ID746931_1;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID746931_1",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID746931_1;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%if (%di_util_varexist(dsname=&m_di_trans..REQUEST, varname=ALLOW_MULTI_STYLE_PACK_REC)=0) %then
%do;
 
 
 
%let m_sql_statement = %str(
ALTER TABLE REQUEST ADD ALLOW_MULTI_STYLE_PACK_REC INTEGER
);
 
 
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%end;
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
%if (%di_util_varexist(dsname=&m_di_trans..REQUEST, varname=ALLOW_MULTI_STYLE_PACK_REC)=0) %then
%do;
 
 
proc sql;
 
 
ALTER TABLE REQUEST ADD ALLOW_MULTI_STYLE_PACK_REC INTEGER;
 
 
quit;
 
 
%end;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID746931_1;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID746931_1;
%put ERROR- Description                              : TABLE REQUEST ADD COLUMN ALLOW_MULTI_STYLE_PACK_REC;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 12APR2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID746931_1;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID746931_1",
"TABLE REQUEST ADD COLUMN ALLOW_MULTI_STYLE_PACK_REC",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID746931_1:;
 
 
* End of changes for CHANGE_ID:ID746931_1;
 
 
***********************************************************************************************;
*************************************  End Change ID746931_1 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID746931 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID746931;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID746931")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_trans..REQUEST))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_trans..REQUEST;
%put NOTE: Change ID                             :ID746931;
%goto ID746931;
 
%end;
%if not (%sysfunc(exist(&m_di_trans..REQ_PACKREC_SETTING))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_trans..REQ_PACKREC_SETTING;
%put NOTE: Change ID                             :ID746931;
%goto ID746931;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID746931;
%goto ID746931;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID746931;
* Insert record into change management table for CHANGE_ID: ID746931;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID746931",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID746931;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
%let m_sql_statement = %str(
ALTER TABLE REQUEST DROP COLUMN ALLOW_MULTI_STYLE_PACK_REC
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
ALTER TABLE REQ_PACKREC_SETTING ADD PROD_ID VARCHAR(32)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
UPDATE REQ_PACKREC_SETTING SET PROD_ID = (select prod_id from PRODUCT_DM where std_hier_prod_lvl=1)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
ALTER TABLE REQ_PACKREC_SETTING ADD ALLOW_MULTI_STYLE_PACK_REC INTEGER
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE REQ_PACKREC_SETTING ADD ALLOW_PRIOR_DELIVERY_PACKS INTEGER
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
ALTER TABLE REQ_PACKREC_SETTING MODIFY PROD_ID VARCHAR(32) NOT NULL
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE REQ_PACKREC_SETTING DROP PRIMARY KEY DROP INDEX
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
CREATE UNIQUE INDEX REQ_PACKREC_SETTING_PK on REQ_PACKREC_SETTING (REQUEST_ID, DELIVERY_ID, PROD_ID) nologging parallel
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE REQ_PACKREC_SETTING ADD CONSTRAINT REQ_PACKREC_SETTING_PK PRIMARY KEY (REQUEST_ID, DELIVERY_ID, PROD_ID) USING INDEX REQ_PACKREC_SETTING_PK
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
ALTER TABLE REQ_PACKREC_INNER ADD PROD_ID VARCHAR(32)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
UPDATE REQ_PACKREC_INNER SET PROD_ID = (select prod_id from PRODUCT_DM where std_hier_prod_lvl=1)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
ALTER TABLE REQ_PACKREC_INNER MODIFY PROD_ID VARCHAR(32) NOT NULL
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE REQ_PACKREC_INNER DROP PRIMARY KEY DROP INDEX
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
CREATE UNIQUE INDEX REQ_PACKREC_INNER_PK on REQ_PACKREC_INNER (REQUEST_ID, DELIVERY_ID, PROD_ID, SIZE_OF_INNER) nologging parallel
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE REQ_PACKREC_INNER ADD CONSTRAINT REQ_PACKREC_INNER_PK PRIMARY KEY (REQUEST_ID, DELIVERY_ID, PROD_ID, SIZE_OF_INNER) USING INDEX REQ_PACKREC_INNER_PK
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
ALTER TABLE REQ_PACKREC_GEO_COST ADD PROD_ID VARCHAR(32)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
UPDATE REQ_PACKREC_GEO_COST SET PROD_ID = (select prod_id from PRODUCT_DM where std_hier_prod_lvl=1)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
ALTER TABLE REQ_PACKREC_GEO_COST MODIFY PROD_ID VARCHAR(32) NOT NULL
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE REQ_PACKREC_GEO_COST DROP PRIMARY KEY DROP INDEX
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
CREATE UNIQUE INDEX REQ_PACKREC_GEO_COST_PK on REQ_PACKREC_GEO_COST (REQUEST_ID, DELIVERY_ID, PROD_ID, GEO_ID, SIZE_OF_INNER) nologging parallel
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE REQ_PACKREC_GEO_COST ADD CONSTRAINT REQ_PACKREC_GEO_COST_PK PRIMARY KEY (REQUEST_ID, DELIVERY_ID, PROD_ID, GEO_ID, SIZE_OF_INNER) USING INDEX REQ_PACKREC_GEO_COST_PK
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
ALTER TABLE &m_di_trans..REQUEST DROP COLUMN ALLOW_MULTI_STYLE_PACK_REC;
 
 
 
ALTER TABLE &m_di_trans..REQ_PACKREC_SETTING ADD PROD_ID VARCHAR(32);
 
 
UPDATE &m_di_trans..REQ_PACKREC_SETTING SET PROD_ID = (select prod_id from &m_di_trans..PRODUCT_DM where std_hier_prod_lvl=1);
 
 
 
ALTER TABLE &m_di_trans..REQ_PACKREC_SETTING ADD ALLOW_MULTI_STYLE_PACK_REC INTEGER;
 
 
ALTER TABLE &m_di_trans..REQ_PACKREC_SETTING ADD ALLOW_PRIOR_DELIVERY_PACKS INTEGER;
 
 
 
ALTER TABLE &m_di_trans..REQ_PACKREC_SETTING MODIFY PROD_ID VARCHAR(32) NOT NULL;
 
 
ALTER TABLE &m_di_trans..REQ_PACKREC_SETTING DROP PRIMARY KEY;
 
 
ALTER TABLE &m_di_trans..REQ_PACKREC_SETTING ADD CONSTRAINT REQ_PACKREC_SETTING_PK PRIMARY KEY (REQUEST_ID, DELIVERY_ID, PROD_ID);
 
 
 
ALTER TABLE &m_di_trans..REQ_PACKREC_INNER ADD PROD_ID VARCHAR(32);
 
 
UPDATE &m_di_trans..REQ_PACKREC_INNER SET PROD_ID = (select prod_id from &m_di_trans..PRODUCT_DM where std_hier_prod_lvl=1);
 
 
 
ALTER TABLE &m_di_trans..REQ_PACKREC_INNER MODIFY PROD_ID VARCHAR(32) NOT NULL;
 
 
ALTER TABLE &m_di_trans..REQ_PACKREC_INNER DROP PRIMARY KEY;
 
 
ALTER TABLE &m_di_trans..REQ_PACKREC_INNER ADD CONSTRAINT REQ_PACKREC_INNER_PK PRIMARY KEY (REQUEST_ID, DELIVERY_ID, PROD_ID, SIZE_OF_INNER);
 
 
 
ALTER TABLE &m_di_trans..REQ_PACKREC_GEO_COST ADD PROD_ID VARCHAR(32);
 
 
UPDATE &m_di_trans..REQ_PACKREC_GEO_COST SET PROD_ID = (select prod_id from &m_di_trans..PRODUCT_DM where std_hier_prod_lvl=1);
 
 
 
ALTER TABLE &m_di_trans..REQ_PACKREC_GEO_COST MODIFY PROD_ID VARCHAR(32) NOT NULL;
 
 
ALTER TABLE &m_di_trans..REQ_PACKREC_GEO_COST DROP PRIMARY KEY;
 
 
ALTER TABLE &m_di_trans..REQ_PACKREC_GEO_COST ADD CONSTRAINT REQ_PACKREC_GEO_COST_PK PRIMARY KEY (REQUEST_ID, DELIVERY_ID, PROD_ID, GEO_ID, SIZE_OF_INNER);
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID746931;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID746931;
%put ERROR- Description                              : Pack Recommendation Settings to support more flexibility in pack recommendation;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 04APR2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID746931;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID746931",
"Pack Recommendation Settings to support more flexibility in pack recommendation",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID746931:;
 
 
* End of changes for CHANGE_ID:ID746931;
 
 
***********************************************************************************************;
*************************************  End Change ID746931 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID750328 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID750328;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID750328")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_trans..PRF_SIZESET))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_trans..PRF_SIZESET;
%put NOTE: Change ID                             :ID750328;
%goto ID750328;
 
%end;
%if not (%sysfunc(exist(&m_di_trans..PRF_CONFIG))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_trans..PRF_CONFIG;
%put NOTE: Change ID                             :ID750328;
%goto ID750328;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID750328;
%goto ID750328;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID750328;
* Insert record into change management table for CHANGE_ID: ID750328;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID750328",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID750328;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
%let m_sql_statement = %str(
ALTER TABLE PRF_SIZESET ADD USER_MODIFIED_FLG INTEGER
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE PRF_SIZESET_MBR ADD SALES_DISTRIBUTION_PCT NUMERIC(12,4)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE PRF_SIZESET_MBR ADD SALES_AUR NUMERIC(12,2)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE PRF_SIZESET_MBR ADD UNITS_IMPUTED NUMERIC(12,2)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
DELETE FROM PRF_CONFIG WHERE PRF_CONFIG_SK=-1 and PRF_CONFIG_TYPE=1 and SPEC_NM='sub_sizeset_flg'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO PRF_CONFIG (PRF_CONFIG_SK, PRF_CONFIG_TYPE, SPEC_NM, SPEC_VALUE, SPEC_TYPE)
VALUES ( -1, 1, 'sub_sizeset_flg', '1', 'INTEGER')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
ALTER TABLE PRF_SIZESET ADD USER_MODIFIED_FLG INTEGER;
 
 
ALTER TABLE PRF_SIZESET_MBR ADD SALES_DISTRIBUTION_PCT NUMERIC(12,4);
 
 
ALTER TABLE PRF_SIZESET_MBR ADD SALES_AUR NUMERIC(12,2);
 
 
ALTER TABLE PRF_SIZESET_MBR ADD UNITS_IMPUTED NUMERIC(12,2);
 
 
DELETE FROM PRF_CONFIG WHERE PRF_CONFIG_SK=-1 and PRF_CONFIG_TYPE=1 and SPEC_NM='sub_sizeset_flg';
 
 
INSERT INTO PRF_CONFIG (PRF_CONFIG_SK, PRF_CONFIG_TYPE, SPEC_NM, SPEC_VALUE, SPEC_TYPE)
VALUES ( -1, 1, 'sub_sizeset_flg', '1', 'INTEGER');
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID750328;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID750328;
%put ERROR- Description                              : SIZE PROFILING 3.2 SCHEMA CHANGES;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 04APR2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID750328;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID750328",
"SIZE PROFILING 3.2 SCHEMA CHANGES",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID750328:;
 
 
* End of changes for CHANGE_ID:ID750328;
 
 
***********************************************************************************************;
*************************************  End Change ID750328 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID719792 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID719792;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID719792")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_trans..MDO_PLAN))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_trans..MDO_PLAN;
%put NOTE: Change ID                             :ID719792;
%goto ID719792;
 
%end;
%if not (%sysfunc(exist(&m_di_trans..MPLN_GEO_PROD_RESULT))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_trans..MPLN_GEO_PROD_RESULT;
%put NOTE: Change ID                             :ID719792;
%goto ID719792;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID719792;
%goto ID719792;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52, M2TKMI43);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID719792;
* Insert record into change management table for CHANGE_ID: ID719792;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID719792",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID719792;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
ALTER TABLE MDO_PLAN ADD UNIFORM_TIMING_NUM_MARKDN INTEGER
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE MDO_PLAN ADD UNIFORM_TIMING_PROD_LVL INTEGER
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE MDO_PLAN ADD UNIFORM_TIMING_GEO_LVL INTEGER
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
ALTER TABLE MPLN_GEO_PROD_RESULT ADD UT_PROD_HIER_SK INTEGER
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE MPLN_GEO_PROD_RESULT ADD UT_GEO_HIER_SK INTEGER
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
INSERT INTO GEO_PROD_SETTING (GEO_PROD_SETTING_SK,GEO_HIER_SK,PROD_HIER_SK,USED_BY_APP,
SETTING_TYPE,SETTING_VAL,SETTING_OVERRIDE_FLG,SETTING_FLOOR,SETTING_CEIL,GEO_HIER_ASSOC_CD)
VALUES (25,1,1,1,50,0,1,0,2.0000,1)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
INSERT INTO GEO_PROD_SETTING (GEO_PROD_SETTING_SK,GEO_HIER_SK,PROD_HIER_SK,USED_BY_APP,
SETTING_TYPE,SETTING_VAL,SETTING_OVERRIDE_FLG,SETTING_FLOOR,SETTING_CEIL,GEO_HIER_ASSOC_CD)
VALUES (26,1,1,1,51,0,1,1.0000,99.0000,1)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
INSERT INTO GEO_PROD_SETTING (GEO_PROD_SETTING_SK,GEO_HIER_SK,PROD_HIER_SK,USED_BY_APP,
SETTING_TYPE,SETTING_VAL,SETTING_OVERRIDE_FLG,SETTING_FLOOR,SETTING_CEIL,GEO_HIER_ASSOC_CD)
VALUES (27,1,1,1,52,0,1,1.0000,99.0000,1)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
ALTER TABLE MDO_PLAN ADD UNIFORM_TIMING_NUM_MARKDN INTEGER;
 
 
ALTER TABLE MDO_PLAN ADD UNIFORM_TIMING_PROD_LVL INTEGER;
 
 
ALTER TABLE MDO_PLAN ADD UNIFORM_TIMING_GEO_LVL INTEGER;
 
 
 
ALTER TABLE MPLN_GEO_PROD_RESULT ADD UT_PROD_HIER_SK INTEGER;
 
 
ALTER TABLE MPLN_GEO_PROD_RESULT ADD UT_GEO_HIER_SK INTEGER;
 
 
 
INSERT INTO GEO_PROD_SETTING (GEO_PROD_SETTING_SK,GEO_HIER_SK,PROD_HIER_SK,USED_BY_APP,
SETTING_TYPE,SETTING_VAL,SETTING_OVERRIDE_FLG,SETTING_FLOOR,SETTING_CEIL,GEO_HIER_ASSOC_CD)
VALUES (25,1,1,1,50,0,1,0,2.0000,1);
 
 
 
INSERT INTO GEO_PROD_SETTING (GEO_PROD_SETTING_SK,GEO_HIER_SK,PROD_HIER_SK,USED_BY_APP,
SETTING_TYPE,SETTING_VAL,SETTING_OVERRIDE_FLG,SETTING_FLOOR,SETTING_CEIL,GEO_HIER_ASSOC_CD)
VALUES (26,1,1,1,51,0,1,1.0000,99.0000,1);
 
 
 
INSERT INTO GEO_PROD_SETTING (GEO_PROD_SETTING_SK,GEO_HIER_SK,PROD_HIER_SK,USED_BY_APP,
SETTING_TYPE,SETTING_VAL,SETTING_OVERRIDE_FLG,SETTING_FLOOR,SETTING_CEIL,GEO_HIER_ASSOC_CD)
VALUES (27,1,1,1,52,0,1,1.0000,99.0000,1);
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID719792;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID719792;
%put ERROR- Description                              : Schema and ETL enhancement for uniform timing (mdo_plan and stg_mdo_import_plan);
%put ERROR- Version                                  : D3MICM52, M2TKMI43;
%put ERROR- Date of Change                           : 30MAR2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID719792;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID719792",
"Schema and ETL enhancement for uniform timing (mdo_plan and stg_mdo_import_plan)",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID719792:;
 
 
* End of changes for CHANGE_ID:ID719792;
 
 
***********************************************************************************************;
*************************************  End Change ID719792 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID747291 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID747291;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID747291")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID747291;
%goto ID747291;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID747291;
* Insert record into change management table for CHANGE_ID: ID747291;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID747291",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID747291;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
DELETE FROM GEO_PROD_SETTING WHERE SETTING_TYPE = 11 AND USED_BY_APP = 1 AND GEO_HIER_SK = 1
AND PROD_HIER_SK = 1
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
DELETE FROM GEO_PROD_SETTING WHERE GEO_PROD_SETTING_SK = 9
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
INSERT INTO GEO_PROD_SETTING (GEO_PROD_SETTING_SK,GEO_HIER_SK,PROD_HIER_SK,USED_BY_APP,
SETTING_TYPE,SETTING_VAL,SETTING_OVERRIDE_FLG,SETTING_FLOOR,SETTING_CEIL,GEO_HIER_ASSOC_CD)
VALUES (9,1,1,1,11,16,1,2.0000,52.0000,1)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
DELETE FROM GEO_PROD_SETTING WHERE SETTING_TYPE = 11 AND USED_BY_APP = 1 AND GEO_HIER_SK = 1
AND PROD_HIER_SK = 1;
 
 
 
DELETE FROM GEO_PROD_SETTING WHERE GEO_PROD_SETTING_SK = 9 ;
 
 
 
INSERT INTO GEO_PROD_SETTING (GEO_PROD_SETTING_SK,GEO_HIER_SK,PROD_HIER_SK,USED_BY_APP,
SETTING_TYPE,SETTING_VAL,SETTING_OVERRIDE_FLG,SETTING_FLOOR,SETTING_CEIL,GEO_HIER_ASSOC_CD)
VALUES (9,1,1,1,11,16,1,2.0000,52.0000,1);
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID747291;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID747291;
%put ERROR- Description                              : Max plan period is set to 52 for MDO;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 06APR2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID747291;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID747291",
"Max plan period is set to 52 for MDO",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID747291:;
 
 
* End of changes for CHANGE_ID:ID747291;
 
 
***********************************************************************************************;
*************************************  End Change ID747291 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change MOVE_WRKBNCH_MNGD_TABLES ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: MOVE_WRKBNCH_MNGD_TABLES;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("MOVE_WRKBNCH_MNGD_TABLES")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(DI_TRANS)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: DI_TRANS;
%put NOTE: Change ID                             :MOVE_WRKBNCH_MNGD_TABLES;
%goto MOVE_WRKBNCH_MNGD_TABLES;
 
%end;
%if not (%sysfunc(libref(DI_DATA)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: DI_DATA;
%put NOTE: Change ID                             :MOVE_WRKBNCH_MNGD_TABLES;
%goto MOVE_WRKBNCH_MNGD_TABLES;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : MOVE_WRKBNCH_MNGD_TABLES;
%goto MOVE_WRKBNCH_MNGD_TABLES;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : MOVE_WRKBNCH_MNGD_TABLES;
* Insert record into change management table for CHANGE_ID: MOVE_WRKBNCH_MNGD_TABLES;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"MOVE_WRKBNCH_MNGD_TABLES",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto MOVE_WRKBNCH_MNGD_TABLES;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
 
 
%let m_sql_statement = %str(
CREATE TABLE ATTR_SPEC
(
MODEL_GROUP_ID              INTEGER NOT NULL,
ATTR_SK                     INTEGER NOT NULL,
EFFECT_CLASS_NM             VARCHAR(40),
SELECTION_TYPE              INTEGER NOT NULL,
ATTR_USAGE                  INTEGER NOT NULL,
CREATED_DTTM                DATE,
CREATED_BY                  VARCHAR(20)
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%let m_sql_statement = %str(
CREATE TABLE BASE_FORECAST_OVERRIDE_GP
(
GEO_HIER_SK                        INTEGER NOT NULL,
PROD_HIER_SK                       INTEGER NOT NULL,
START_DATE_SK                      INTEGER NOT NULL,
END_DATE_SK                        INTEGER NOT NULL,
OVERRIDE_FACTOR                    NUMERIC(12,2),
PRIMARY KEY (GEO_HIER_SK,PROD_HIER_SK,START_DATE_SK)
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
CREATE INDEX BF_OGP_IX1 ON BASE_FORECAST_OVERRIDE_GP
(
GEO_HIER_SK,
PROD_HIER_SK
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%let m_sql_statement = %str(
CREATE TABLE BASE_FORECAST_OVERRIDE_MG
(
MODEL_GROUP_ID                     INTEGER NOT NULL,
START_DATE_SK                      INTEGER NOT NULL,
END_DATE_SK                        INTEGER NOT NULL,
OVERRIDE_FACTOR                    NUMERIC(12,2),
PRIMARY KEY (MODEL_GROUP_ID,START_DATE_SK)
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
CREATE INDEX BF_OMG_IX1 ON BASE_FORECAST_OVERRIDE_MG
(
MODEL_GROUP_ID
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%let m_sql_statement = %str(
CREATE TABLE CONFIG_AUDIT_TRAIL
(
AUDIT_TRAIL_SK                     INTEGER NOT NULL,
ACTION_TYPE                        VARCHAR(40),
OBJECT_TYPE                        VARCHAR(40),
OBJECT_NM                          VARCHAR(100),
NEW_VALUE                          VARCHAR(255),
OLD_VALUE                          VARCHAR(255),
GEO_HIER_SK                        INTEGER,
PROD_HIER_SK                       INTEGER,
USER_NM                            VARCHAR(40),
CREATED_DTTM                       DATE NOT NULL,
PRIMARY KEY (AUDIT_TRAIL_SK)
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
CREATE INDEX AUDIT_TRAIL_IX1 ON CONFIG_AUDIT_TRAIL
(
OBJECT_TYPE
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%let m_sql_statement = %str(
CREATE TABLE CONFIG_GROUP
(
CONFIG_GROUP_ID             INTEGER NOT NULL,
CONFIG_GROUP_NM             VARCHAR(40),
NUM_OF_MODEL_GROUPS         INTEGER,
CONFIG_TEMPLATE_ID          INTEGER,
GEO_HIER_TYPE               INTEGER,
PROD_HIER_TYPE              INTEGER,
GEO_HIER_ASSOC_CD           INTEGER,
PROD_HIER_ASSOC_CD          INTEGER,
PRIMARY KEY (CONFIG_GROUP_ID)
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
CREATE TABLE DATA_CONFIG
(
DATA_CONFIG_SK              INTEGER NOT NULL,
MODEL_GROUP_ID              INTEGER NOT NULL,
DATA_LVL_ID                 INTEGER,
GEO_HIER_SK                 INTEGER,
PROD_HIER_SK                INTEGER,
MODEL_COMP_NM               VARCHAR(5),
BY_GEO_LVL                  INTEGER,
BY_PROD_LVL                 INTEGER,
CREATED_DTTM                DATE,
CREATED_BY                  VARCHAR(20),
PRIMARY KEY (DATA_CONFIG_SK)
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
CREATE TABLE DATA_CONFIG_TEMPLATE
(
CONFIG_TEMPLATE_ID          INTEGER NOT NULL,
CONFIG_TEMPLATE_NM          VARCHAR(40),
CONFIG_TEMPLATE_DESC        VARCHAR(100),
INCLUDE_TS                  INTEGER,
TS_GEO_LVL                  INTEGER,
TS_PROD_LVL                 INTEGER,
TS_BY_GEO_LVL               INTEGER,
TS_BY_PROD_LVL              INTEGER,
INCLUDE_REG                 INTEGER,
REG_GEO_LVL                 INTEGER,
REG_PROD_LVL                INTEGER,
REG_BY_GEO_LVL              INTEGER,
REG_BY_PROD_LVL             INTEGER,
FCST_GEO_LVL                INTEGER,
FCST_PROD_LVL               INTEGER,
FCST_BY_GEO_LVL             INTEGER,
FCST_BY_PROD_LVL            INTEGER,
CREATED_BY                  VARCHAR(20),
CREATED_DTTM                DATE,
PRIMARY KEY (CONFIG_TEMPLATE_ID)
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
CREATE TABLE GLOBAL_SETTING_DETAILS
(
SPEC_NM                     VARCHAR(32) NOT NULL,
APP                         VARCHAR(32) NOT NULL,
CONFIG_CD                   INTEGER NOT NULL,
DEFAULT_SPEC_VALUE          VARCHAR(100),
SPEC_DATATYPE               VARCHAR(40),
SPEC_DATATYPE_EXT           VARCHAR(40),
SPEC_VALUE_MIN              NUMERIC(12,4),
SPEC_VALUE_MAX              NUMERIC(12,4),
SPEC_VALUE_INCR             NUMERIC(12,4),
EDITABLE_FLG                INTEGER,
ENABLED_FLG                 INTEGER,
REQUIRED_FLG                INTEGER,
HIDDEN_FLG                  INTEGER,
MISSING_VAL_OK_FLG          INTEGER,
OVERRIDE_APP_LIST           VARCHAR(100),
REF_QUERY                   VARCHAR(500),
GENERATE_PREFIX_NM          VARCHAR(40),
GENERATE_SUFFIX_MAX         VARCHAR(40),
SPEC_VALUE_LIST_DELIMITER   VARCHAR(3),
DESC_KEY                    VARCHAR(100),
PRIMARY KEY (SPEC_NM,APP,CONFIG_CD)
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
CREATE TABLE GLOBAL_SETTING_GROUP
(
GLOBAL_SETTING_GROUP_NM         VARCHAR(40) NOT NULL,
GLOBAL_SETTING_GROUP_DESC       VARCHAR(100),
GLOBAL_SETTING_GROUP_DESC_KEY   VARCHAR(100),
GLOBAL_SETTING_CATEGORY_FLG     INTEGER,
SETTING_GROUP_PERMISSION_ROLE   VARCHAR(100),
CONFIG_CD                       INTEGER,
PRIMARY KEY (GLOBAL_SETTING_GROUP_NM)
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
CREATE TABLE GLOBAL_SETTING_GROUP_MEMBER
(
SPEC_NM                     VARCHAR(32) NOT NULL,
APP                         VARCHAR(40) NOT NULL,
GLOBAL_SETTING_GROUP_NM     VARCHAR(40) NOT NULL,
PRIMARY KEY (SPEC_NM,APP,GLOBAL_SETTING_GROUP_NM)
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
CREATE TABLE GLOBAL_SETTING_VALUES
(
SPEC_NM                     VARCHAR(32) NOT NULL,
APP                         VARCHAR(40) NOT NULL,
SPEC_VALUE                  VARCHAR(100) NOT NULL,
SPEC_VALUE_DESC             VARCHAR(100),
SPEC_VALUE_DESC_KEY         VARCHAR(100),
PRIMARY KEY (SPEC_NM,APP,SPEC_VALUE)
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
CREATE TABLE MA_SPEC_SEED
(
MODEL_GROUP_ID              INTEGER NOT NULL,
SPEC_NM                     VARCHAR(32) NOT NULL,
USER_NM                     VARCHAR(60) NOT NULL,
SPEC_VALUE                  VARCHAR(200),
PRIMARY KEY (MODEL_GROUP_ID,SPEC_NM,USER_NM)
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%let m_sql_statement = %str(
CREATE TABLE MODEL_GEO_PROD_STATUS_RULE
(
PROD_HIER_SK                INTEGER NOT NULL,
RULE_NM                     VARCHAR(32) NOT NULL,
RULE_VALUE                  VARCHAR(100),
SPEC_VALUE                  VARCHAR(200),
CREATED_DTTM                DATE,
CREATED_BY                  VARCHAR(20),
PRIMARY KEY (PROD_HIER_SK,RULE_NM)
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
CREATE TABLE MODEL_GEO_PROD_STATUS_SPEC
(
SPEC_NM                     VARCHAR(32) NOT NULL,
SPEC_VALUE                  VARCHAR(100),
CREATED_DTTM                DATE,
CREATED_BY                  VARCHAR(20),
PRIMARY KEY (SPEC_NM)
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
CREATE TABLE MODEL_GEO_PROD_STATUS_DETAILS
(
SPEC_NM                     VARCHAR(32) NOT NULL,
SPEC_RULE_FLG               INTEGER NOT NULL,
DEFAULT_SPEC_VALUE          VARCHAR(100),
SPEC_DATATYPE               VARCHAR(40),
SPEC_DATATYPE_EXT           VARCHAR(40),
SPEC_VALUE_MIN              NUMERIC(12,4),
SPEC_VALUE_MAX              NUMERIC(12,4),
SPEC_VALUE_INCR             NUMERIC(12,4),
REF_QUERY                   VARCHAR(500),
SPEC_VALUE_LIST_DELIMITER   VARCHAR(3),
DESCRIPTION                 VARCHAR(100),
DESC_KEY                    VARCHAR(100),
PRIMARY KEY (SPEC_NM,SPEC_RULE_FLG)
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
CREATE TABLE MODEL_GEO_PROD_STATUS_VALUES
(
SPEC_NM                     VARCHAR(32) NOT NULL,
SPEC_RULE_FLG               INTEGER NOT NULL,
SPEC_VALUE                  VARCHAR(100) NOT NULL,
SPEC_VALUE_DESC             VARCHAR(100),
SPEC_VALUE_DESC_KEY         VARCHAR(100),
PRIMARY KEY (SPEC_NM,SPEC_RULE_FLG,SPEC_VALUE)
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
CREATE TABLE MODEL_GROUP
(
MODEL_GROUP_ID              INTEGER NOT NULL,
PROD_HIER_SK                INTEGER,
GEO_HIER_SK                 INTEGER,
NUM_GEO_PRODS               INTEGER,
SCHEDULED_FLG               INTEGER,
ENABLED_FLG                 INTEGER,
REFRESH_FREQ                INTEGER,
CONFIG_GROUP_ID             INTEGER,
SEASON                      VARCHAR(20),
TAG                         VARCHAR(40),
LAST_REFRESH_DTTM           DATE,
CONFIG_TEMPLATE_ID          INTEGER,
PRIMARY KEY (MODEL_GROUP_ID)
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
CREATE TABLE MODEL_SPEC
(
MODEL_GROUP_ID              INTEGER NOT NULL,
MODEL_COMP_NM               VARCHAR(5) NOT NULL,
SPEC_NM                     VARCHAR(32) NOT NULL,
SPEC_TYPE                   VARCHAR(5) NOT NULL,
SPEC_VALUE                  VARCHAR(100),
PRIORITY                    VARCHAR(3),
CREATED_DTTM                DATE,
CREATED_BY                  VARCHAR(20),
PRIMARY KEY (MODEL_GROUP_ID,MODEL_COMP_NM,SPEC_NM,SPEC_TYPE)
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
CREATE TABLE MODEL_SPEC_DEFAULT
(
MODEL_COMP_NM               VARCHAR(5) NOT NULL,
SPEC_NM                     VARCHAR(32) NOT NULL,
SPEC_TYPE                   VARCHAR(5) NOT NULL,
DEFAULT_SPEC_VALUE          VARCHAR(100),
PRIORITY                    VARCHAR(3),
PRIMARY KEY (MODEL_COMP_NM,SPEC_NM,SPEC_TYPE)
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
CREATE TABLE MODEL_SPEC_DETAILS
(
MODEL_COMP_NM               VARCHAR(5) NOT NULL,
SPEC_NM                     VARCHAR(32) NOT NULL,
SPEC_DATATYPE               VARCHAR(40),
SPEC_DATATYPE_EXT           VARCHAR(40),
SPEC_VALUE_MIN              NUMERIC(12,4),
SPEC_VALUE_MAX              NUMERIC(12,4),
SPEC_VALUE_INCR             NUMERIC(12,4),
HIDDEN_FLG                  INTEGER,
OVERRIDE_MODEL_COMP_NM_LIST VARCHAR(100),
REF_QUERY                   VARCHAR(500),
GENERATE_PREFIX_NM          VARCHAR(40),
GENERATE_SUFFIX_MAX         VARCHAR(40),
SPEC_VALUE_LIST_DELIMITER   VARCHAR(3),
SPEC_DESC                   VARCHAR(100),
DESC_KEY                    VARCHAR(100),
PRIMARY KEY (MODEL_COMP_NM,SPEC_NM)
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
CREATE TABLE MODEL_SPEC_TEMPLATE
(
MODEL_SPEC_ID               INTEGER NOT NULL,
MODEL_COMP_NM               VARCHAR(5) NOT NULL,
SPEC_NM                     VARCHAR(32) NOT NULL,
SPEC_TYPE                   VARCHAR(5) NOT NULL,
SPEC_VALUE                  VARCHAR(100),
PRIORITY                    VARCHAR(3),
CREATED_DTTM                DATE,
CREATED_BY                  VARCHAR(20),
PRIMARY KEY (MODEL_SPEC_ID,MODEL_COMP_NM,SPEC_NM,SPEC_TYPE)
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
CREATE TABLE MODEL_SPEC_VALUES
(
MODEL_COMP_NM               VARCHAR(5) NOT NULL,
SPEC_NM                     VARCHAR(32) NOT NULL,
SPEC_VALUE                  VARCHAR(100),
SPEC_VALUE_DESC             VARCHAR(100),
SPEC_VALUE_DESC_KEY         VARCHAR(100),
PRIMARY KEY (MODEL_COMP_NM,SPEC_NM,SPEC_VALUE)
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
CREATE TABLE MODEL_SPEC_WORKFLOW
(
TASK_NM                     VARCHAR(40) NOT NULL,
PARENT_TASK_NM              VARCHAR(40),
TASK_DESC                   VARCHAR(100),
TASK_DESC_KEY               VARCHAR(100),
TASK_LVL                    INTEGER,
SPEC_NM                     VARCHAR(32),
SPEC_TYPE                   VARCHAR(5),
MODEL_COMP_NM               VARCHAR(5),
DOW_FLG                     INTEGER,
HALO_FLG                    INTEGER,
PRIMARY KEY (TASK_NM)
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
CREATE TABLE SCORING_PARAM_CONFIG
(
EFFECT_TYPE                 VARCHAR(40) NOT NULL,
EFFECT_CATEGORY             VARCHAR(40) NOT NULL,
TSF_TYPE                    INTEGER NOT NULL,
EFFECT_EST                  NUMERIC(12,4),
EFFECT_EST_U                NUMERIC(12,4),
EFFECT_EST_L                NUMERIC(12,4),
COUNTER                     VARCHAR(40),
PRIMARY KEY (EFFECT_TYPE,EFFECT_CATEGORY,TSF_TYPE)
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
CREATE TABLE SCORING_PARAM_DEFAULT
(
GEO_HIER_SK                 INTEGER NOT NULL,
PROD_HIER_SK                INTEGER NOT NULL,
EFFECT_TYPE                 VARCHAR(40) NOT NULL,
EFFECT_CATEGORY             VARCHAR(40) NOT NULL,
TSF_TYPE                    INTEGER NOT NULL,
EFFECT_EST                  NUMERIC(12,4),
EFFECT_EST_U                NUMERIC(12,4),
EFFECT_EST_L                NUMERIC(12,4),
PRIMARY KEY (GEO_HIER_SK,PROD_HIER_SK,EFFECT_TYPE,EFFECT_CATEGORY,TSF_TYPE)
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
 
***********************************************************************************************;
 
 
data ATTR_SPEC;
 
 
attrib MODEL_GROUP_ID                      length=4                                            ;
 
 
attrib ATTR_SK                             length=4                                            ;
 
 
attrib EFFECT_CLASS_NM                     length=$40                                          ;
 
 
attrib SELECTION_TYPE                      length=4                                            ;
 
 
attrib ATTR_USAGE                          length=4                                            ;
 
 
attrib CREATED_DTTM                        length=8      FORMAT=&DTTMFMT    INFORMAT=&DTTMFMT  ;
 
 
attrib CREATED_BY                          length=$20                                          ;
 
 
stop; run;
 
 
 
 
***********************************************************************************************;
 
 
data BASE_FORECAST_OVERRIDE_GP;
 
 
attrib GEO_HIER_SK                         length=4                                            ;
 
 
attrib PROD_HIER_SK                        length=6                                            ;
 
 
attrib START_DATE_SK                       length=4                                            ;
 
 
attrib END_DATE_SK                         length=4                                            ;
 
 
attrib OVERRIDE_FACTOR                     length=8      FORMAT=NLNUM12.2   INFORMAT=NLNUM12.2 ;
 
 
stop; run;
 
 
 
proc sql;
 
 
alter table BASE_FORECAST_OVERRIDE_GP add CONSTRAINT PRIM_KEY PRIMARY KEY (GEO_HIER_SK, PROD_HIER_SK, START_DATE_SK);
 
 
alter table BASE_FORECAST_OVERRIDE_GP add NOT NULL (END_DATE_SK);
 
 
quit;
 
 
 
proc sql;
 
 
CREATE INDEX BF_OGP_IX1 ON BASE_FORECAST_OVERRIDE_GP(GEO_HIER_SK, PROD_HIER_SK);
 
 
quit;
 
 
***********************************************************************************************;
 
 
 
data BASE_FORECAST_OVERRIDE_MG;
 
 
attrib MODEL_GROUP_ID                      length=4                                            ;
 
 
attrib START_DATE_SK                       length=4                                            ;
 
 
attrib END_DATE_SK                         length=4                                            ;
 
 
attrib OVERRIDE_FACTOR                     length=8      FORMAT=NLNUM12.2   INFORMAT=NLNUM12.2 ;
 
 
stop; run;
 
 
 
proc sql;
 
 
alter table BASE_FORECAST_OVERRIDE_MG add CONSTRAINT PRIM_KEY PRIMARY KEY (MODEL_GROUP_ID, START_DATE_SK);
 
 
alter table BASE_FORECAST_OVERRIDE_MG add NOT NULL (END_DATE_SK);
 
 
quit;
 
 
 
proc sql;
 
 
CREATE INDEX MODEL_GROUP_ID ON BASE_FORECAST_OVERRIDE_MG(MODEL_GROUP_ID);
 
 
quit;
 
 
***********************************************************************************************;
 
 
 
data CONFIG_AUDIT_TRAIL;
 
 
attrib AUDIT_TRAIL_SK                      length=6                                            ;
 
 
attrib ACTION_TYPE                         length=$40                                          ;
 
 
attrib OBJECT_TYPE                         length=$40                                          ;
 
 
attrib OBJECT_NM                           length=$100                                         ;
 
 
attrib NEW_VALUE                           length=$255                                         ;
 
 
attrib OLD_VALUE                           length=$255                                         ;
 
 
attrib GEO_HIER_SK                         length=4                                            ;
 
 
attrib PROD_HIER_SK                        length=6                                            ;
 
 
attrib USER_NM                             length=$40                                          ;
 
 
attrib CREATED_DTTM                        length=8      FORMAT=&DTTMFMT    INFORMAT=&DTTMFMT  ;
 
 
stop; run;
 
 
 
proc sql;
 
 
alter table CONFIG_AUDIT_TRAIL add CONSTRAINT PRIM_KEY PRIMARY KEY (AUDIT_TRAIL_SK);
 
 
alter table CONFIG_AUDIT_TRAIL add NOT NULL (CREATED_DTTM);
 
 
quit;
 
 
 
proc sql;
 
 
CREATE INDEX OBJECT_TYPE ON CONFIG_AUDIT_TRAIL(OBJECT_TYPE);
 
 
quit;
 
 
***********************************************************************************************;
 
 
 
 
data CONFIG_GROUP;
 
 
attrib CONFIG_GROUP_ID                     length=4                                            ;
 
 
attrib CONFIG_GROUP_NM                     length=$40                                          ;
 
 
attrib NUM_OF_MODEL_GROUPS                 length=4                                            ;
 
 
attrib CONFIG_TEMPLATE_ID                  length=4                                            ;
 
 
attrib GEO_HIER_TYPE                       length=4                                            ;
 
 
attrib PROD_HIER_TYPE                      length=4                                            ;
 
 
attrib GEO_HIER_ASSOC_CD                   length=4                                            ;
 
 
attrib PROD_HIER_ASSOC_CD                  length=4                                            ;
 
 
stop; run;
 
 
 
proc sql;
 
 
alter table CONFIG_GROUP add CONSTRAINT PRIM_KEY PRIMARY KEY (CONFIG_GROUP_ID);
 
 
quit;
 
 
 
***********************************************************************************************;
 
 
data DATA_CONFIG;
 
 
attrib DATA_CONFIG_SK                      length=4                                            ;
 
 
attrib MODEL_GROUP_ID                      length=4                                            ;
 
 
attrib DATA_LVL_ID                         length=4                                            ;
 
 
attrib GEO_HIER_SK                         length=4                                            ;
 
 
attrib PROD_HIER_SK                        length=6                                            ;
 
 
attrib MODEL_COMP_NM                       length=$5                                           ;
 
 
attrib BY_GEO_LVL                          length=4                                            ;
 
 
attrib BY_PROD_LVL                         length=4                                            ;
 
 
attrib CREATED_DTTM                        length=8      FORMAT=&DTTMFMT    INFORMAT=&DTTMFMT  ;
 
 
attrib CREATED_BY                          length=$20                                          ;
 
 
stop; run;
 
 
 
proc sql;
 
 
alter table DATA_CONFIG add CONSTRAINT PRIM_KEY PRIMARY KEY (DATA_CONFIG_SK);
 
 
alter table DATA_CONFIG add NOT NULL (MODEL_GROUP_ID);
 
 
quit;
 
 
 
***********************************************************************************************;
 
 
data DATA_CONFIG_TEMPLATE;
 
 
attrib CONFIG_TEMPLATE_ID                  length=4                                            ;
 
 
attrib CONFIG_TEMPLATE_NM                  length=$40                                          ;
 
 
attrib CONFIG_TEMPLATE_DESC                length=$100                                         ;
 
 
attrib INCLUDE_TS                          length=4                                            ;
 
 
attrib TS_GEO_LVL                          length=4                                            ;
 
 
attrib TS_PROD_LVL                         length=4                                            ;
 
 
attrib TS_BY_GEO_LVL                       length=4                                            ;
 
 
attrib TS_BY_PROD_LVL                      length=4                                            ;
 
 
attrib INCLUDE_REG                         length=4                                            ;
 
 
attrib REG_GEO_LVL                         length=4                                            ;
 
 
attrib REG_PROD_LVL                        length=4                                            ;
 
 
attrib REG_BY_GEO_LVL                      length=4                                            ;
 
 
attrib REG_BY_PROD_LVL                     length=4                                            ;
 
 
attrib FCST_GEO_LVL                        length=4                                            ;
 
 
attrib FCST_PROD_LVL                       length=4                                            ;
 
 
attrib FCST_BY_GEO_LVL                     length=4                                            ;
 
 
attrib FCST_BY_PROD_LVL                    length=4                                            ;
 
 
attrib CREATED_DTTM                        length=8      FORMAT=&DTTMFMT    INFORMAT=&DTTMFMT  ;
 
 
attrib CREATED_BY                          length=$20                                          ;
 
 
stop; run;
 
 
 
proc sql;
 
 
alter table DATA_CONFIG_TEMPLATE add CONSTRAINT PRIM_KEY PRIMARY KEY (CONFIG_TEMPLATE_ID);
 
 
quit;
 
 
 
***********************************************************************************************;
 
 
 
data GLOBAL_SETTING_DETAILS;
 
 
attrib SPEC_NM                             length=$32                                          ;
 
 
attrib APP                                 length=$40                                          ;
 
 
attrib CONFIG_CD                           length=4                                            ;
 
 
attrib DEFAULT_SPEC_VALUE                  length=$100                                         ;
 
 
attrib SPEC_DATATYPE                       length=$40                                          ;
 
 
attrib SPEC_DATATYPE_EXT                   length=$40                                          ;
 
 
attrib SPEC_VALUE_MIN                      length=8      FORMAT=NLNUM12.2   INFORMAT=NLNUM12.2 ;
 
 
attrib SPEC_VALUE_MAX                      length=8      FORMAT=NLNUM12.2   INFORMAT=NLNUM12.2 ;
 
 
attrib SPEC_VALUE_INCR                     length=8      FORMAT=NLNUM12.2   INFORMAT=NLNUM12.2 ;
 
 
attrib EDITABLE_FLG                        length=4                                            ;
 
 
attrib ENABLED_FLG                         length=4                                            ;
 
 
attrib REQUIRED_FLG                        length=4                                            ;
 
 
attrib HIDDEN_FLG                          length=4                                            ;
 
 
attrib MISSING_VAL_OK_FLG                  length=4                                            ;
 
 
attrib OVERRIDE_APP_LIST                   length=$100                                         ;
 
 
attrib REF_QUERY                           length=$500                                         ;
 
 
attrib GENERATE_PREFIX_NM                  length=$40                                          ;
 
 
attrib GENERATE_SUFFIX_MAX                 length=$40                                          ;
 
 
attrib SPEC_VALUE_LIST_DELIMITER           length=$3                                           ;
 
 
attrib DESC_KEY                            length=$100                                         ;
 
 
stop; run;
 
 
 
proc sql;
 
 
alter table GLOBAL_SETTING_DETAILS add CONSTRAINT PRIM_KEY PRIMARY KEY (SPEC_NM, APP, CONFIG_CD);
 
 
quit;
 
 
 
***********************************************************************************************;
 
 
data GLOBAL_SETTING_GROUP;
 
 
attrib GLOBAL_SETTING_GROUP_NM             length=$40                                          ;
 
 
attrib GLOBAL_SETTING_GROUP_DESC           length=$100                                         ;
 
 
attrib GLOBAL_SETTING_GROUP_DESC_KEY       length=$100                                         ;
 
 
attrib GLOBAL_SETTING_CATEGORY_FLG         length=4                                            ;
 
 
attrib SETTING_GROUP_PERMISSION_ROLE       length=$100                                         ;
 
 
attrib CONFIG_CD                           length=4                                            ;
 
 
stop; run;
 
 
 
proc sql;
 
 
alter table GLOBAL_SETTING_GROUP add CONSTRAINT PRIM_KEY PRIMARY KEY (GLOBAL_SETTING_GROUP_NM);
 
 
quit;
 
 
 
***********************************************************************************************;
 
 
data GLOBAL_SETTING_GROUP_MEMBER;
 
 
attrib SPEC_NM                             length=$32                                          ;
 
 
attrib APP                                 length=$40                                          ;
 
 
attrib GLOBAL_SETTING_GROUP_NM             length=$40                                          ;
 
 
stop; run;
 
 
 
proc sql;
 
 
alter table GLOBAL_SETTING_GROUP_MEMBER add CONSTRAINT PRIM_KEY PRIMARY KEY (SPEC_NM, APP, GLOBAL_SETTING_GROUP_NM);
 
 
quit;
 
 
 
***********************************************************************************************;
 
 
data GLOBAL_SETTING_VALUES;
 
 
attrib SPEC_NM                             length=$32                                          ;
 
 
attrib APP                                 length=$40                                          ;
 
 
attrib SPEC_VALUE                          length=$100                                         ;
 
 
attrib SPEC_VALUE_DESC                     length=$100                                         ;
 
 
attrib SPEC_VALUE_DESC_KEY                 length=$100                                         ;
 
 
stop; run;
 
 
 
proc sql;
 
 
alter table GLOBAL_SETTING_VALUES add CONSTRAINT PRIM_KEY PRIMARY KEY (SPEC_NM, APP, SPEC_VALUE);
 
 
quit;
 
 
 
***********************************************************************************************;
 
 
data MA_SPEC_SEED;
 
 
attrib MODEL_GROUP_ID                      length=4                                            ;
 
 
attrib SPEC_NM                             length=$32                                          ;
 
 
attrib USER_NM                             length=$60                                          ;
 
 
attrib SPEC_VALUE                          length=$200                                         ;
 
 
stop; run;
 
 
 
proc sql;
 
 
alter table MA_SPEC_SEED add CONSTRAINT PRIM_KEY PRIMARY KEY (MODEL_GROUP_ID, SPEC_NM, USER_NM);
 
 
quit;
 
 
 
***********************************************************************************************;
 
 
data MODEL_GEO_PROD_STATUS_RULE;
 
 
attrib PROD_HIER_SK                        length=6                                            ;
 
 
attrib RULE_NM                             length=$32                                          ;
 
 
attrib RULE_VALUE                          length=$100                                         ;
 
 
attrib CREATED_DTTM                        length=8      FORMAT=&DTTMFMT    INFORMAT=&DTTMFMT  ;
 
 
attrib CREATED_BY                          length=$20                                          ;
 
 
stop; run;
 
 
 
proc sql;
 
 
alter table MODEL_GEO_PROD_STATUS_RULE add CONSTRAINT PRIM_KEY PRIMARY KEY (PROD_HIER_SK, RULE_NM);
 
 
quit;
 
 
 
***********************************************************************************************;
 
 
data MODEL_GEO_PROD_STATUS_SPEC;
 
 
attrib SPEC_NM                             length=$32                                          ;
 
 
attrib SPEC_VALUE                          length=$100                                         ;
 
 
attrib CREATED_DTTM                        length=8      FORMAT=&DTTMFMT    INFORMAT=&DTTMFMT  ;
 
 
attrib CREATED_BY                          length=$20                                          ;
 
 
stop; run;
 
 
 
proc sql;
 
 
alter table MODEL_GEO_PROD_STATUS_SPEC add CONSTRAINT PRIM_KEY PRIMARY KEY (SPEC_NM);
 
 
quit;
 
 
 
***********************************************************************************************;
 
 
data MODEL_GEO_PROD_STATUS_DETAILS;
 
 
attrib SPEC_NM                             length=$32                                          ;
 
 
attrib SPEC_RULE_FLG                       length=4                                            ;
 
 
attrib DEFAULT_SPEC_VALUE                  length=$100                                         ;
 
 
attrib SPEC_DATATYPE                       length=$40                                          ;
 
 
attrib SPEC_DATATYPE_EXT                   length=$40                                          ;
 
 
attrib SPEC_VALUE_MIN                      length=8      FORMAT=NLNUM12.2   INFORMAT=NLNUM12.2 ;
 
 
attrib SPEC_VALUE_MAX                      length=8      FORMAT=NLNUM12.2   INFORMAT=NLNUM12.2 ;
 
 
attrib SPEC_VALUE_INCR                     length=8      FORMAT=NLNUM12.2   INFORMAT=NLNUM12.2 ;
 
 
attrib REF_QUERY                           length=$500                                         ;
 
 
attrib SPEC_VALUE_LIST_DELIMITER           length=$3                                           ;
 
 
attrib DESCRIPTION                         length=$100                                         ;
 
 
attrib DESC_KEY                            length=$100                                         ;
 
 
stop; run;
 
 
 
proc sql;
 
 
alter table MODEL_GEO_PROD_STATUS_DETAILS add CONSTRAINT PRIM_KEY PRIMARY KEY (SPEC_NM, SPEC_RULE_FLG);
 
 
quit;
 
 
 
***********************************************************************************************;
 
 
 
data MODEL_GEO_PROD_STATUS_VALUES;
 
 
attrib SPEC_NM                             length=$32                                          ;
 
 
attrib SPEC_RULE_FLG                       length=4                                            ;
 
 
attrib SPEC_VALUE                          length=$100                                         ;
 
 
attrib SPEC_VALUE_DESC                     length=$100                                         ;
 
 
attrib SPEC_VALUE_DESC_KEY                 length=$100                                         ;
 
 
stop; run;
 
 
 
proc sql;
 
 
alter table MODEL_GEO_PROD_STATUS_VALUES add CONSTRAINT PRIM_KEY PRIMARY KEY (SPEC_NM, SPEC_RULE_FLG, SPEC_VALUE);
 
 
quit;
 
 
 
***********************************************************************************************;
 
 
data MODEL_GROUP;
 
 
attrib MODEL_GROUP_ID                      length=4                                            ;
 
 
attrib PROD_HIER_SK                        length=6                                            ;
 
 
attrib GEO_HIER_SK                         length=4                                            ;
 
 
attrib NUM_GEO_PRODS                       length=6                                            ;
 
 
attrib SCHEDULED_FLG                       length=4                                            ;
 
 
attrib ENABLED_FLG                         length=4                                            ;
 
 
attrib REFRESH_FREQ                        length=6                                            ;
 
 
attrib CONFIG_GROUP_ID                     length=4                                            ;
 
 
attrib SEASON                              length=$20                                          ;
 
 
attrib TAG                                 length=$40                                          ;
 
 
attrib LAST_REFRESH_DTTM                   length=8      FORMAT=&DTTMFMT    INFORMAT=&DTTMFMT  ;
 
 
attrib CONFIG_TEMPLATE_ID                  length=4                                            ;
 
 
stop; run;
 
 
 
proc sql;
 
 
alter table MODEL_GROUP add CONSTRAINT PRIM_KEY PRIMARY KEY (MODEL_GROUP_ID);
 
 
quit;
 
 
 
***********************************************************************************************;
 
 
data MODEL_SPEC;
 
 
attrib MODEL_GROUP_ID                      length=4                                            ;
 
 
attrib MODEL_COMP_NM                       length=$5                                           ;
 
 
attrib SPEC_NM                             length=$32                                          ;
 
 
attrib SPEC_TYPE                           length=$5                                           ;
 
 
attrib SPEC_VALUE                          length=$100                                         ;
 
 
attrib PRIORITY                            length=$3                                           ;
 
 
attrib CREATED_DTTM                        length=8      FORMAT=&DTTMFMT    INFORMAT=&DTTMFMT  ;
 
 
attrib CREATED_BY                          length=$20                                          ;
 
 
stop; run;
 
 
 
proc sql;
 
 
alter table MODEL_SPEC add CONSTRAINT PRIM_KEY PRIMARY KEY (MODEL_GROUP_ID, MODEL_COMP_NM, SPEC_NM, SPEC_TYPE);
 
 
quit;
 
 
 
***********************************************************************************************;
 
 
data MODEL_SPEC_DEFAULT;
 
 
attrib MODEL_COMP_NM                       length=$5                                           ;
 
 
attrib SPEC_NM                             length=$32                                          ;
 
 
attrib SPEC_TYPE                           length=$5                                           ;
 
 
attrib DEFAULT_SPEC_VALUE                  length=$100                                         ;
 
 
attrib PRIORITY                            length=$3                                           ;
 
 
stop; run;
 
 
 
proc sql;
 
 
alter table MODEL_SPEC_DEFAULT add CONSTRAINT PRIM_KEY PRIMARY KEY (MODEL_COMP_NM, SPEC_NM, SPEC_TYPE);
 
 
quit;
 
 
 
***********************************************************************************************;
 
 
data MODEL_SPEC_DETAILS;
 
 
attrib MODEL_COMP_NM                       length=$5                                           ;
 
 
attrib SPEC_NM                             length=$32                                          ;
 
 
attrib SPEC_DATATYPE                       length=$40                                          ;
 
 
attrib SPEC_DATATYPE_EXT                   length=$40                                          ;
 
 
attrib SPEC_VALUE_MIN                      length=8      FORMAT=NLNUM12.2   INFORMAT=NLNUM12.2 ;
 
 
attrib SPEC_VALUE_MAX                      length=8      FORMAT=NLNUM12.2   INFORMAT=NLNUM12.2 ;
 
 
attrib SPEC_VALUE_INCR                     length=8      FORMAT=NLNUM12.2   INFORMAT=NLNUM12.2 ;
 
 
attrib HIDDEN_FLG                          length=4                                            ;
 
 
attrib OVERRIDE_MODEL_COMP_NM_LIST         length=$100                                         ;
 
 
attrib REF_QUERY                           length=$500                                         ;
 
 
attrib GENERATE_PREFIX_NM                  length=$40                                          ;
 
 
attrib GENERATE_SUFFIX_MAX                 length=$40                                          ;
 
 
attrib SPEC_VALUE_LIST_DELIMITER           length=$3                                           ;
 
 
attrib SPEC_DESC                           length=$100                                         ;
 
 
attrib DESC_KEY                            length=$100                                         ;
 
 
stop; run;
 
 
 
proc sql;
 
 
alter table MODEL_SPEC_DETAILS add CONSTRAINT PRIM_KEY PRIMARY KEY (MODEL_COMP_NM, SPEC_NM);
 
 
quit;
 
 
 
***********************************************************************************************;
 
 
data MODEL_SPEC_TEMPLATE;
 
 
attrib MODEL_SPEC_ID                       length=4                                            ;
 
 
attrib MODEL_COMP_NM                       length=$5                                           ;
 
 
attrib SPEC_NM                             length=$32                                          ;
 
 
attrib SPEC_TYPE                           length=$5                                           ;
 
 
attrib SPEC_VALUE                          length=$100                                         ;
 
 
attrib PRIORITY                            length=$3                                           ;
 
 
attrib CREATED_DTTM                        length=8      FORMAT=&DTTMFMT    INFORMAT=&DTTMFMT  ;
 
 
attrib CREATED_BY                          length=$20                                          ;
 
 
stop; run;
 
 
 
proc sql;
 
 
alter table MODEL_SPEC_TEMPLATE add CONSTRAINT PRIM_KEY PRIMARY KEY (MODEL_SPEC_ID, MODEL_COMP_NM, SPEC_NM, SPEC_TYPE);
 
 
quit;
 
 
 
***********************************************************************************************;
 
 
data MODEL_SPEC_VALUES;
 
 
attrib MODEL_COMP_NM                       length=$5                                           ;
 
 
attrib SPEC_NM                             length=$32                                          ;
 
 
attrib SPEC_VALUE                          length=$100                                         ;
 
 
attrib SPEC_VALUE_DESC                     length=$100                                         ;
 
 
attrib SPEC_VALUE_DESC_KEY                 length=$100                                         ;
 
 
stop; run;
 
 
 
proc sql;
 
 
alter table MODEL_SPEC_VALUES add CONSTRAINT PRIM_KEY PRIMARY KEY (MODEL_COMP_NM, SPEC_NM, SPEC_VALUE);
 
 
quit;
 
 
 
***********************************************************************************************;
 
 
data MODEL_SPEC_WORKFLOW;
 
 
attrib TASK_NM                             length=$40                                          ;
 
 
attrib PARENT_TASK_NM                      length=$40                                          ;
 
 
attrib TASK_DESC                           length=$100                                         ;
 
 
attrib TASK_DESC_KEY                       length=$100                                         ;
 
 
attrib TASK_LVL                            length=4                                            ;
 
 
attrib SPEC_NM                             length=$32                                          ;
 
 
attrib SPEC_TYPE                           length=$5                                           ;
 
 
attrib MODEL_COMP_NM                       length=$5                                           ;
 
 
attrib DOW_FLG                             length=4                                            ;
 
 
attrib HALO_FLG                            length=4                                            ;
 
 
stop; run;
 
 
 
proc sql;
 
 
alter table MODEL_SPEC_WORKFLOW add CONSTRAINT PRIM_KEY PRIMARY KEY (TASK_NM);
 
 
quit;
 
 
 
***********************************************************************************************;
 
 
data SCORING_PARAM_CONFIG;
 
 
attrib EFFECT_TYPE                         length=$40                                          ;
 
 
attrib EFFECT_CATEGORY                     length=$40                                          ;
 
 
attrib TSF_TYPE                            length=4                                            ;
 
 
attrib EFFECT_EST                          length=8      FORMAT=NLNUM12.4   INFORMAT=NLNUM12.4 ;
 
 
attrib EFFECT_EST_U                        length=8      FORMAT=NLNUM12.2   INFORMAT=NLNUM12.2 ;
 
 
attrib EFFECT_EST_L                        length=8      FORMAT=NLNUM12.2   INFORMAT=NLNUM12.2 ;
 
 
attrib COUNTER                             length=$40                                          ;
 
 
stop; run;
 
 
 
proc sql;
 
 
alter table SCORING_PARAM_CONFIG add CONSTRAINT PRIM_KEY PRIMARY KEY (EFFECT_TYPE, EFFECT_CATEGORY, TSF_TYPE);
 
 
quit;
 
 
 
***********************************************************************************************;
 
 
data SCORING_PARAM_DEFAULT;
 
 
attrib GEO_HIER_SK                         length=4                                            ;
 
 
attrib PROD_HIER_SK                        length=6                                            ;
 
 
attrib EFFECT_TYPE                         length=$40                                          ;
 
 
attrib EFFECT_CATEGORY                     length=$40                                          ;
 
 
attrib TSF_TYPE                            length=4                                            ;
 
 
attrib EFFECT_EST                          length=8      FORMAT=NLNUM12.4   INFORMAT=NLNUM12.4 ;
 
 
attrib EFFECT_EST_U                        length=8      FORMAT=NLNUM12.2   INFORMAT=NLNUM12.2 ;
 
 
attrib EFFECT_EST_L                        length=8      FORMAT=NLNUM12.2   INFORMAT=NLNUM12.2 ;
 
 
stop; run;
 
 
 
proc sql;
 
 
alter table SCORING_PARAM_DEFAULT
add CONSTRAINT PRIM_KEY PRIMARY KEY (GEO_HIER_SK, PROD_HIER_SK, EFFECT_TYPE, EFFECT_CATEGORY, TSF_TYPE);
 
 
quit;
 
 
 
***********************************************************************************************;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: MOVE_WRKBNCH_MNGD_TABLES;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: MOVE_WRKBNCH_MNGD_TABLES;
%put ERROR- Description                              : Move workbench managed tables to Oracle;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 07APR2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: MOVE_WRKBNCH_MNGD_TABLES;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"MOVE_WRKBNCH_MNGD_TABLES",
"Move workbench managed tables to Oracle",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%MOVE_WRKBNCH_MNGD_TABLES:;
 
 
* End of changes for CHANGE_ID:MOVE_WRKBNCH_MNGD_TABLES;
 
 
***********************************************************************************************;
*************************************  End Change MOVE_WRKBNCH_MNGD_TABLES ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change GET_DATA_FROM_DI_DM ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: GET_DATA_FROM_DI_DM;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("GET_DATA_FROM_DI_DM")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(DI_TRANS)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: DI_TRANS;
%put NOTE: Change ID                             :GET_DATA_FROM_DI_DM;
%goto GET_DATA_FROM_DI_DM;
 
%end;
%if not (%sysfunc(libref(DI_DATA)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: DI_DATA;
%put NOTE: Change ID                             :GET_DATA_FROM_DI_DM;
%goto GET_DATA_FROM_DI_DM;
 
%end;
%if not (%sysfunc(exist(&m_di_data..MODEL_SPEC))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_data..MODEL_SPEC;
%put NOTE: Change ID                             :GET_DATA_FROM_DI_DM;
%goto GET_DATA_FROM_DI_DM;
 
%end;
%if not (%sysfunc(exist(&m_di_data..ATTR_SPEC))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_data..ATTR_SPEC;
%put NOTE: Change ID                             :GET_DATA_FROM_DI_DM;
%goto GET_DATA_FROM_DI_DM;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : GET_DATA_FROM_DI_DM;
%goto GET_DATA_FROM_DI_DM;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : GET_DATA_FROM_DI_DM;
* Insert record into change management table for CHANGE_ID: GET_DATA_FROM_DI_DM;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"GET_DATA_FROM_DI_DM",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto GET_DATA_FROM_DI_DM;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
* first change USAGE source column in ATTR_SPEC to ATTR_USAGE;
 
 
data work.ATTR_SPEC_OLD;
 
 
attrib ATTR_USAGE          length=4 ;
 
 
drop USAGE;
 
 
 
SET &m_di_data..ATTR_SPEC;
 
 
ATTR_USAGE=USAGE;
 
 
run;
 
 
 
 
 
proc append base = &m_di_trans..ATTR_SPEC data = work.ATTR_SPEC_OLD force; run;
 
 
proc append base = &m_di_trans..BASE_FORECAST_OVERRIDE_GP data = &m_di_data..BASE_FORECAST_OVERRIDE_GP force; run;
 
 
proc append base = &m_di_trans..BASE_FORECAST_OVERRIDE_MG data = &m_di_data..BASE_FORECAST_OVERRIDE_MG force; run;
 
 
proc append base = &m_di_trans..CONFIG_AUDIT_TRAIL data = &m_di_data..CONFIG_AUDIT_TRAIL force; run;
 
 
proc append base = &m_di_trans..CONFIG_GROUP data = &m_di_data..CONFIG_GROUP force; run;
 
 
proc append base = &m_di_trans..DATA_CONFIG data = &m_di_data..DATA_CONFIG force; run;
 
 
proc append base = &m_di_trans..DATA_CONFIG_TEMPLATE data = &m_di_data..DATA_CONFIG_TEMPLATE force; run;
 
 
proc append base = &m_di_trans..GLOBAL_SETTING_DETAILS data = &m_di_data..GLOBAL_SETTING_DETAILS force; run;
 
 
proc append base = &m_di_trans..GLOBAL_SETTING_GROUP data = &m_di_data..GLOBAL_SETTING_GROUP force; run;
 
 
proc append base = &m_di_trans..GLOBAL_SETTING_GROUP_MEMBER data = &m_di_data..GLOBAL_SETTING_GROUP_MEMBER force; run;
 
 
proc append base = &m_di_trans..GLOBAL_SETTING_VALUES data = &m_di_data..GLOBAL_SETTING_VALUES force; run;
 
 
proc append base = &m_di_trans..MA_SPEC_SEED data = &m_di_data..MA_SPEC force; run;
 
 
proc append base = &m_di_trans..MODEL_GEO_PROD_STATUS_RULE data = &m_di_data..MODEL_GEO_PROD_STATUS_RULE force; run;
 
 
proc append base = &m_di_trans..MODEL_GEO_PROD_STATUS_SPEC data = &m_di_data..MODEL_GEO_PROD_STATUS_SPEC force; run;
 
 
proc append base = &m_di_trans..MODEL_GEO_PROD_STATUS_DETAILS data = &m_di_data..MODEL_GEO_PROD_STATUS_DETAILS force; run;
 
 
proc append base = &m_di_trans..MODEL_GEO_PROD_STATUS_VALUES data = &m_di_data..MODEL_GEO_PROD_STATUS_VALUES force; run;
 
 
proc append base = &m_di_trans..MODEL_GROUP data = &m_di_data..MODEL_GROUP force; run;
 
 
proc append base = &m_di_trans..MODEL_SPEC data = &m_di_data..MODEL_SPEC force; run;
 
 
proc append base = &m_di_trans..MODEL_SPEC_DEFAULT data = &m_di_data..MODEL_SPEC_DEFAULT force; run;
 
 
proc append base = &m_di_trans..MODEL_SPEC_DETAILS data = &m_di_data..MODEL_SPEC_DETAILS force; run;
 
 
proc append base = &m_di_trans..MODEL_SPEC_TEMPLATE data = &m_di_data..MODEL_SPEC_TEMPLATE force; run;
 
 
proc append base = &m_di_trans..MODEL_SPEC_VALUES data = &m_di_data..MODEL_SPEC_VALUES force; run;
 
 
proc append base = &m_di_trans..MODEL_SPEC_WORKFLOW data = &m_di_data..MODEL_SPEC_WORKFLOW force; run;
 
 
proc append base = &m_di_trans..SCORING_PARAM_CONFIG data = &m_di_data..SCORING_PARAM_CONFIG force; run;
 
 
proc append base = &m_di_trans..SCORING_PARAM_DEFAULT data = &m_di_data..SCORING_PARAM_DEFAULT force; run;
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
* first change USAGE source column in ATTR_SPEC to ATTR_USAGE;
 
 
data work.ATTR_SPEC_OLD;
 
 
attrib ATTR_USAGE          length=4 ;
 
 
drop USAGE;
 
 
 
SET &m_di_data..ATTR_SPEC;
 
 
ATTR_USAGE=USAGE;
 
 
run;
 
 
 
 
 
proc append base = &m_di_trans..ATTR_SPEC data = work.ATTR_SPEC_OLD force; run;
 
 
proc append base = &m_di_trans..BASE_FORECAST_OVERRIDE_GP data = &m_di_data..BASE_FORECAST_OVERRIDE_GP force; run;
 
 
proc append base = &m_di_trans..BASE_FORECAST_OVERRIDE_MG data = &m_di_data..BASE_FORECAST_OVERRIDE_MG force; run;
 
 
proc append base = &m_di_trans..CONFIG_AUDIT_TRAIL data = &m_di_data..CONFIG_AUDIT_TRAIL force; run;
 
 
proc append base = &m_di_trans..CONFIG_GROUP data = &m_di_data..CONFIG_GROUP force; run;
 
 
proc append base = &m_di_trans..DATA_CONFIG data = &m_di_data..DATA_CONFIG force; run;
 
 
proc append base = &m_di_trans..DATA_CONFIG_TEMPLATE data = &m_di_data..DATA_CONFIG_TEMPLATE force; run;
 
 
proc append base = &m_di_trans..GLOBAL_SETTING_DETAILS data = &m_di_data..GLOBAL_SETTING_DETAILS force; run;
 
 
proc append base = &m_di_trans..GLOBAL_SETTING_GROUP data = &m_di_data..GLOBAL_SETTING_GROUP force; run;
 
 
proc append base = &m_di_trans..GLOBAL_SETTING_GROUP_MEMBER data = &m_di_data..GLOBAL_SETTING_GROUP_MEMBER force; run;
 
 
proc append base = &m_di_trans..GLOBAL_SETTING_VALUES data = &m_di_data..GLOBAL_SETTING_VALUES force; run;
 
 
proc append base = &m_di_trans..MA_SPEC_SEED data = &m_di_data..MA_SPEC force; run;
 
 
proc append base = &m_di_trans..MODEL_GEO_PROD_STATUS_RULE data = &m_di_data..MODEL_GEO_PROD_STATUS_RULE force; run;
 
 
proc append base = &m_di_trans..MODEL_GEO_PROD_STATUS_SPEC data = &m_di_data..MODEL_GEO_PROD_STATUS_SPEC force; run;
 
 
proc append base = &m_di_trans..MODEL_GEO_PROD_STATUS_DETAILS data = &m_di_data..MODEL_GEO_PROD_STATUS_DETAILS force; run;
 
 
proc append base = &m_di_trans..MODEL_GEO_PROD_STATUS_VALUES data = &m_di_data..MODEL_GEO_PROD_STATUS_VALUES force; run;
 
 
proc append base = &m_di_trans..MODEL_GROUP data = &m_di_data..MODEL_GROUP force; run;
 
 
proc append base = &m_di_trans..MODEL_SPEC data = &m_di_data..MODEL_SPEC force; run;
 
 
proc append base = &m_di_trans..MODEL_SPEC_DEFAULT data = &m_di_data..MODEL_SPEC_DEFAULT force; run;
 
 
proc append base = &m_di_trans..MODEL_SPEC_DETAILS data = &m_di_data..MODEL_SPEC_DETAILS force; run;
 
 
proc append base = &m_di_trans..MODEL_SPEC_TEMPLATE data = &m_di_data..MODEL_SPEC_TEMPLATE force; run;
 
 
proc append base = &m_di_trans..MODEL_SPEC_VALUES data = &m_di_data..MODEL_SPEC_VALUES force; run;
 
 
proc append base = &m_di_trans..MODEL_SPEC_WORKFLOW data = &m_di_data..MODEL_SPEC_WORKFLOW force; run;
 
 
proc append base = &m_di_trans..SCORING_PARAM_CONFIG data = &m_di_data..SCORING_PARAM_CONFIG force; run;
 
 
proc append base = &m_di_trans..SCORING_PARAM_DEFAULT data = &m_di_data..SCORING_PARAM_DEFAULT force; run;
 
 
 
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: GET_DATA_FROM_DI_DM;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: GET_DATA_FROM_DI_DM;
%put ERROR- Description                              : Get data for workbench managed tables from di_data to di_trans;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 07APR2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: GET_DATA_FROM_DI_DM;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"GET_DATA_FROM_DI_DM",
"Get data for workbench managed tables from di_data to di_trans",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%GET_DATA_FROM_DI_DM:;
 
 
* End of changes for CHANGE_ID:GET_DATA_FROM_DI_DM;
 
 
***********************************************************************************************;
*************************************  End Change GET_DATA_FROM_DI_DM ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change DROP_WRKBNCH_MNGD_TABLES ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: DROP_WRKBNCH_MNGD_TABLES;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("DROP_WRKBNCH_MNGD_TABLES")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(&m_di_data.)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_di_data.;
%put NOTE: Change ID                             :DROP_WRKBNCH_MNGD_TABLES;
%goto DROP_WRKBNCH_MNGD_TABLES;
 
%end;
%if not (%sysfunc(libref(&m_di_trans.)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_di_trans.;
%put NOTE: Change ID                             :DROP_WRKBNCH_MNGD_TABLES;
%goto DROP_WRKBNCH_MNGD_TABLES;
 
%end;
%if not (%sysfunc(exist(&m_di_trans..attr_spec))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_trans..attr_spec;
%put NOTE: Change ID                             :DROP_WRKBNCH_MNGD_TABLES;
%goto DROP_WRKBNCH_MNGD_TABLES;
 
%end;
%if not (%sysfunc(exist(&m_di_data..ATTR_SPEC))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_data..ATTR_SPEC;
%put NOTE: Change ID                             :DROP_WRKBNCH_MNGD_TABLES;
%goto DROP_WRKBNCH_MNGD_TABLES;
 
%end;
%if not (%sysfunc(exist(&m_di_trans..SCORING_PARAM_DEFAULT))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_trans..SCORING_PARAM_DEFAULT;
%put NOTE: Change ID                             :DROP_WRKBNCH_MNGD_TABLES;
%goto DROP_WRKBNCH_MNGD_TABLES;
 
%end;
%if not (%sysfunc(exist(&m_di_data..SCORING_PARAM_DEFAULT))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_data..SCORING_PARAM_DEFAULT;
%put NOTE: Change ID                             :DROP_WRKBNCH_MNGD_TABLES;
%goto DROP_WRKBNCH_MNGD_TABLES;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : DROP_WRKBNCH_MNGD_TABLES;
%goto DROP_WRKBNCH_MNGD_TABLES;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : DROP_WRKBNCH_MNGD_TABLES;
* Insert record into change management table for CHANGE_ID: DROP_WRKBNCH_MNGD_TABLES;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"DROP_WRKBNCH_MNGD_TABLES",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto DROP_WRKBNCH_MNGD_TABLES;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
 
proc sql;
 
 
DROP TABLE &m_di_data..ATTR_SPEC;
 
 
DROP TABLE &m_di_data..BASE_FORECAST_OVERRIDE_GP;
 
 
DROP TABLE &m_di_data..BASE_FORECAST_OVERRIDE_MG;
 
 
DROP TABLE &m_di_data..CONFIG_AUDIT_TRAIL;
 
 
DROP TABLE &m_di_data..CONFIG_GROUP;
 
 
DROP TABLE &m_di_data..DATA_CONFIG;
 
 
DROP TABLE &m_di_data..DATA_CONFIG_TEMPLATE;
 
 
DROP TABLE &m_di_data..GLOBAL_SETTING_DETAILS;
 
 
DROP TABLE &m_di_data..GLOBAL_SETTING_GROUP;
 
 
DROP TABLE &m_di_data..GLOBAL_SETTING_GROUP_MEMBER;
 
 
DROP TABLE &m_di_data..GLOBAL_SETTING_VALUES;
 
 
DROP TABLE &m_di_data..MA_SPEC_SEED;
 
 
DROP TABLE &m_di_data..MODEL_GEO_PROD_STATUS_RULE;
 
 
DROP TABLE &m_di_data..MODEL_GEO_PROD_STATUS_SPEC;
 
 
DROP TABLE &m_di_data..MODEL_GEO_PROD_STATUS_DETAILS;
 
 
DROP TABLE &m_di_data..MODEL_GEO_PROD_STATUS_VALUES;
 
 
DROP TABLE &m_di_data..MODEL_GROUP;
 
 
DROP TABLE &m_di_data..MODEL_SPEC;
 
 
DROP TABLE &m_di_data..MODEL_SPEC_DEFAULT;
 
 
DROP TABLE &m_di_data..MODEL_SPEC_DETAILS;
 
 
DROP TABLE &m_di_data..MODEL_SPEC_TEMPLATE;
 
 
DROP TABLE &m_di_data..MODEL_SPEC_VALUES;
 
 
DROP TABLE &m_di_data..MODEL_SPEC_WORKFLOW;
 
 
DROP TABLE &m_di_data..SCORING_PARAM_CONFIG;
 
 
DROP TABLE &m_di_data..SCORING_PARAM_DEFAULT;
 
 
quit;
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
 
proc sql;
 
 
DROP TABLE &m_di_data..ATTR_SPEC;
 
 
DROP TABLE &m_di_data..BASE_FORECAST_OVERRIDE_GP;
 
 
DROP TABLE &m_di_data..BASE_FORECAST_OVERRIDE_MG;
 
 
DROP TABLE &m_di_data..CONFIG_AUDIT_TRAIL;
 
 
DROP TABLE &m_di_data..CONFIG_GROUP;
 
 
DROP TABLE &m_di_data..DATA_CONFIG;
 
 
DROP TABLE &m_di_data..DATA_CONFIG_TEMPLATE;
 
 
DROP TABLE &m_di_data..GLOBAL_SETTING_DETAILS;
 
 
DROP TABLE &m_di_data..GLOBAL_SETTING_GROUP;
 
 
DROP TABLE &m_di_data..GLOBAL_SETTING_GROUP_MEMBER;
 
 
DROP TABLE &m_di_data..GLOBAL_SETTING_VALUES;
 
 
DROP TABLE &m_di_data..MA_SPEC_SEED;
 
 
DROP TABLE &m_di_data..MODEL_GEO_PROD_STATUS_RULE;
 
 
DROP TABLE &m_di_data..MODEL_GEO_PROD_STATUS_SPEC;
 
 
DROP TABLE &m_di_data..MODEL_GEO_PROD_STATUS_DETAILS;
 
 
DROP TABLE &m_di_data..MODEL_GEO_PROD_STATUS_VALUES;
 
 
DROP TABLE &m_di_data..MODEL_GROUP;
 
 
DROP TABLE &m_di_data..MODEL_SPEC;
 
 
DROP TABLE &m_di_data..MODEL_SPEC_DEFAULT;
 
 
DROP TABLE &m_di_data..MODEL_SPEC_DETAILS;
 
 
DROP TABLE &m_di_data..MODEL_SPEC_TEMPLATE;
 
 
DROP TABLE &m_di_data..MODEL_SPEC_VALUES;
 
 
DROP TABLE &m_di_data..MODEL_SPEC_WORKFLOW;
 
 
DROP TABLE &m_di_data..SCORING_PARAM_CONFIG;
 
 
DROP TABLE &m_di_data..SCORING_PARAM_DEFAULT;
 
 
quit;
 
 
 
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: DROP_WRKBNCH_MNGD_TABLES;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: DROP_WRKBNCH_MNGD_TABLES;
%put ERROR- Description                              : Drop Workbench tables moved to RDBMS;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 11APR2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: DROP_WRKBNCH_MNGD_TABLES;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"DROP_WRKBNCH_MNGD_TABLES",
"Drop Workbench tables moved to RDBMS",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%DROP_WRKBNCH_MNGD_TABLES:;
 
 
* End of changes for CHANGE_ID:DROP_WRKBNCH_MNGD_TABLES;
 
 
***********************************************************************************************;
*************************************  End Change DROP_WRKBNCH_MNGD_TABLES ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID752048 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID752048;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID752048")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_trans..MODEL_SPEC_DEFAULT))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_trans..MODEL_SPEC_DEFAULT;
%put NOTE: Change ID                             :ID752048;
%goto ID752048;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID752048;
%goto ID752048;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID752048;
* Insert record into change management table for CHANGE_ID: ID752048;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID752048",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID752048;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'FIXED_CAPPING_METHOD'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
values ('FIXED_CAPPING_METHOD','REG','1','ORIGIN',NULL)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'FIXED_CAPPING_METHOD';
 
 
insert into MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
values ('FIXED_CAPPING_METHOD','REG','1','ORIGIN',NULL);
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID752048;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID752048;
%put ERROR- Description                              : Add FIXED_CAPPING_METHOD model spec;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 13APR2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID752048;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID752048",
"Add FIXED_CAPPING_METHOD model spec",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID752048:;
 
 
* End of changes for CHANGE_ID:ID752048;
 
 
***********************************************************************************************;
*************************************  End Change ID752048 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID749351 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID749351;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID749351")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_trans..MODEL_SPEC_DEFAULT))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_trans..MODEL_SPEC_DEFAULT;
%put NOTE: Change ID                             :ID749351;
%goto ID749351;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID749351;
%goto ID749351;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID749351;
* Insert record into change management table for CHANGE_ID: ID749351;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID749351",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID749351;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
DELETE FROM MODEL_SPEC_DEFAULT WHERE SPEC_NM = 'ATREG_COLD_START'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
INSERT INTO MODEL_SPEC_DEFAULT
(SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('ATREG_COLD_START','FCST','-1','0',NULL)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
DELETE FROM MODEL_SPEC_DEFAULT WHERE SPEC_NM = 'ATREG_MODULE'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
INSERT INTO MODEL_SPEC_DEFAULT
(SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('ATREG_MODULE','ALL','-1','0',NULL)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
DELETE FROM MODEL_SPEC_DEFAULT WHERE SPEC_NM = 'BASELINE_OFFSET_TYPE'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
INSERT INTO MODEL_SPEC_DEFAULT
(SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('BASELINE_OFFSET_TYPE','ALL','-1','1',NULL)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
DELETE FROM MODEL_SPEC_DEFAULT WHERE SPEC_NM = 'BFAVG_TSF'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
INSERT INTO MODEL_SPEC_DEFAULT
(SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('BFAVG_TSF','FCST','-1','1',NULL)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
DELETE FROM MODEL_SPEC_DEFAULT WHERE SPEC_NM = 'INT_LOWER_BOUND'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
INSERT INTO MODEL_SPEC_DEFAULT
(SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('INT_LOWER_BOUND','FCST','2','-100',NULL)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
DELETE FROM MODEL_SPEC_DEFAULT WHERE SPEC_NM = 'MAX_PRICE_RATIO'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
INSERT INTO MODEL_SPEC_DEFAULT
(SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('MAX_PRICE_RATIO','ALL','1','1',NULL)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
INSERT INTO MODEL_SPEC_DEFAULT
(SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('MAX_PRICE_RATIO','ALL','2','1',NULL)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
DELETE FROM MODEL_SPEC_DEFAULT WHERE SPEC_NM = 'M_PRICE_CORR'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
INSERT INTO MODEL_SPEC_DEFAULT
(SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('M_PRICE_CORR','REG','-1','0.8',NULL)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
DELETE FROM MODEL_SPEC_DEFAULT WHERE SPEC_NM = 'MIN_STD_EST'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
INSERT INTO MODEL_SPEC_DEFAULT
(SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('MIN_STD_EST','REG','-1','0.00000001',NULL)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
DELETE FROM MODEL_SPEC_DEFAULT WHERE SPEC_NM = 'MISSING_GP_FCST_VALUE'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
INSERT INTO MODEL_SPEC_DEFAULT
(SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('MISSING_GP_FCST_VALUE','FCST','-1','0',NULL)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
DELETE FROM MODEL_SPEC_VALUES WHERE SPEC_NM = 'SALES_INTRO_FROM_GPSTATUS'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
INSERT INTO MODEL_SPEC_VALUES
(SPEC_NM,MODEL_COMP_NM,SPEC_VALUE,SPEC_VALUE_DESC,SPEC_VALUE_DESC_KEY)
VALUES ('SALES_INTRO_FROM_GPSTATUS','FCST','1','Use sales introduction date','mspec.SALES_INTRO_FROM_GPSTATUS.truemeans.txt')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
INSERT INTO MODEL_SPEC_VALUES
(SPEC_NM,MODEL_COMP_NM,SPEC_VALUE,SPEC_VALUE_DESC,SPEC_VALUE_DESC_KEY)
VALUES ('SALES_INTRO_FROM_GPSTATUS','FCST','0','Do not use sales introduction date','mspec.SALES_INTRO_FROM_GPSTATUS.falsemeans.txt')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
DELETE FROM MODEL_SPEC_DEFAULT WHERE SPEC_NM = 'SA_SHIFT'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
INSERT INTO MODEL_SPEC_DEFAULT
(SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('SA_SHIFT','ALL','-1','0',NULL)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
DELETE FROM MODEL_SPEC_DEFAULT WHERE SPEC_NM = 'PF_LOWER_BOUND'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
INSERT INTO MODEL_SPEC_DEFAULT
(SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('PF_LOWER_BOUND','ALL','1','0.0001',NULL)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
INSERT INTO MODEL_SPEC_DEFAULT
(SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('PF_LOWER_BOUND','ALL','2','0.0001',NULL)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
DELETE FROM MODEL_SPEC_DEFAULT WHERE SPEC_NM = 'ATREG_COLD_START';
 
 
 
INSERT INTO MODEL_SPEC_DEFAULT
(SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('ATREG_COLD_START','FCST','-1','0',NULL);
 
 
 
DELETE FROM MODEL_SPEC_DEFAULT WHERE SPEC_NM = 'ATREG_MODULE';
 
 
 
INSERT INTO MODEL_SPEC_DEFAULT
(SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('ATREG_MODULE','ALL','-1','0',NULL);
 
 
 
DELETE FROM MODEL_SPEC_DEFAULT WHERE SPEC_NM = 'BASELINE_OFFSET_TYPE';
 
 
 
INSERT INTO MODEL_SPEC_DEFAULT
(SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('BASELINE_OFFSET_TYPE','ALL','-1','1',NULL);
 
 
 
DELETE FROM MODEL_SPEC_DEFAULT WHERE SPEC_NM = 'BFAVG_TSF';
 
 
 
INSERT INTO MODEL_SPEC_DEFAULT
(SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('BFAVG_TSF','FCST','-1','1',NULL);
 
 
 
DELETE FROM MODEL_SPEC_DEFAULT WHERE SPEC_NM = 'INT_LOWER_BOUND';
 
 
 
INSERT INTO MODEL_SPEC_DEFAULT
(SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('INT_LOWER_BOUND','FCST','2','-100',NULL);
 
 
 
DELETE FROM MODEL_SPEC_DEFAULT WHERE SPEC_NM = 'MAX_PRICE_RATIO';
 
 
 
INSERT INTO MODEL_SPEC_DEFAULT
(SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('MAX_PRICE_RATIO','ALL','1','1',NULL);
 
 
 
INSERT INTO MODEL_SPEC_DEFAULT
(SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('MAX_PRICE_RATIO','ALL','2','1',NULL);
 
 
 
DELETE FROM MODEL_SPEC_DEFAULT WHERE SPEC_NM = 'M_PRICE_CORR';
 
 
 
INSERT INTO MODEL_SPEC_DEFAULT
(SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('M_PRICE_CORR','REG','-1','0.8',NULL);
 
 
 
DELETE FROM MODEL_SPEC_DEFAULT WHERE SPEC_NM = 'MIN_STD_EST';
 
 
 
INSERT INTO MODEL_SPEC_DEFAULT
(SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('MIN_STD_EST','REG','-1','0.00000001',NULL);
 
 
 
DELETE FROM MODEL_SPEC_DEFAULT WHERE SPEC_NM = 'MISSING_GP_FCST_VALUE';
 
 
 
INSERT INTO MODEL_SPEC_DEFAULT
(SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('MISSING_GP_FCST_VALUE','FCST','-1','0',NULL);
 
 
 
DELETE FROM MODEL_SPEC_VALUES WHERE SPEC_NM = 'SALES_INTRO_FROM_GPSTATUS';
 
 
 
INSERT INTO MODEL_SPEC_VALUES
(SPEC_NM,MODEL_COMP_NM,SPEC_VALUE,SPEC_VALUE_DESC,SPEC_VALUE_DESC_KEY)
VALUES ('SALES_INTRO_FROM_GPSTATUS','FCST','1','Use sales introduction date','mspec.SALES_INTRO_FROM_GPSTATUS.truemeans.txt');
 
 
 
INSERT INTO MODEL_SPEC_VALUES
(SPEC_NM,MODEL_COMP_NM,SPEC_VALUE,SPEC_VALUE_DESC,SPEC_VALUE_DESC_KEY)
VALUES ('SALES_INTRO_FROM_GPSTATUS','FCST','0','Do not use sales introduction date','mspec.SALES_INTRO_FROM_GPSTATUS.falsemeans.txt');
 
 
 
DELETE FROM MODEL_SPEC_DEFAULT WHERE SPEC_NM = 'SA_SHIFT';
 
 
 
INSERT INTO MODEL_SPEC_DEFAULT
(SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('SA_SHIFT','ALL','-1','0',NULL);
 
 
 
DELETE FROM MODEL_SPEC_DEFAULT WHERE SPEC_NM = 'PF_LOWER_BOUND';
 
 
 
INSERT INTO MODEL_SPEC_DEFAULT
(SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('PF_LOWER_BOUND','ALL','1','0.0001',NULL);
 
 
 
INSERT INTO MODEL_SPEC_DEFAULT
(SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('PF_LOWER_BOUND','ALL','2','0.0001',NULL);
 
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID749351;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID749351;
%put ERROR- Description                              : Fixes to model_spec_default for advanced specs;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 14APR2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID749351;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID749351",
"Fixes to model_spec_default for advanced specs",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID749351:;
 
 
* End of changes for CHANGE_ID:ID749351;
 
 
***********************************************************************************************;
*************************************  End Change ID749351 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID749351_1 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID749351_1;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID749351_1")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_trans..MODEL_SPEC_DEFAULT))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_trans..MODEL_SPEC_DEFAULT;
%put NOTE: Change ID                             :ID749351_1;
%goto ID749351_1;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID749351_1;
%goto ID749351_1;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID749351_1;
* Insert record into change management table for CHANGE_ID: ID749351_1;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID749351_1",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID749351_1;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
DELETE FROM MODEL_SPEC_DEFAULT WHERE SPEC_NM = 'SALES_INTRO_FROM_GPSTATUS'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO MODEL_SPEC_DEFAULT
(SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('SALES_INTRO_FROM_GPSTATUS','FCST','-1','0',NULL)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
DELETE FROM MODEL_SPEC_DEFAULT WHERE SPEC_NM = 'SALES_INTRO_FROM_GPSTATUS';
 
 
INSERT INTO MODEL_SPEC_DEFAULT
(SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('SALES_INTRO_FROM_GPSTATUS','FCST','-1','0',NULL);
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID749351_1;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID749351_1;
%put ERROR- Description                              : Fixes to default for SALES_INTRO_FROM_GPSTATUS;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 14APR2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID749351_1;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID749351_1",
"Fixes to default for SALES_INTRO_FROM_GPSTATUS",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID749351_1:;
 
 
* End of changes for CHANGE_ID:ID749351_1;
 
 
***********************************************************************************************;
*************************************  End Change ID749351_1 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change PRE_ID753541 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: PRE_ID753541;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("PRE_ID753541")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : PRE_ID753541;
%goto PRE_ID753541;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : PRE_ID753541;
* Insert record into change management table for CHANGE_ID: PRE_ID753541;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"PRE_ID753541",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto PRE_ID753541;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
 
%di_util_delete_sequence(m_sequence_name=%str(SEQ_ALERT_COMP_THRSHLD_RULE_SK), m_schema_name=%str(&di_trans_schema))     ;
 
 
 
%di_util_delete_sequence(m_sequence_name=%str(SEQ_ALERT_COMP_RANGE_RULE_SK), m_schema_name=%str(&di_trans_schema));
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: PRE_ID753541;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: PRE_ID753541;
%put ERROR- Description                              : Drop Sequences to be created in change id ID753541;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 20APR2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: PRE_ID753541;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"PRE_ID753541",
"Drop Sequences to be created in change id ID753541",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%PRE_ID753541:;
 
 
* End of changes for CHANGE_ID:PRE_ID753541;
 
 
***********************************************************************************************;
*************************************  End Change PRE_ID753541 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID753541 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID753541;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID753541")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID753541;
%goto ID753541;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID753541;
* Insert record into change management table for CHANGE_ID: ID753541;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID753541",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID753541;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
 
%let m_sql_statement = %str(
CREATE SEQUENCE SEQ_ALERT_COMP_THRSHLD_RULE_SK START WITH 100000
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
CREATE TABLE ALERT_COMP_THRSHLD_RULE
(
ALERT_COMP_THRSHLD_RULE_SK INTEGER PRIMARY KEY,
PROD_HIER_SK                  INTEGER NOT NULL,
GEO_HIER_SK                   INTEGER NOT NULL,
GEO_HIER_ASSOC_CD             INTEGER NOT NULL,
THRESHOLD_VALUE_TYPE          INTEGER NOT NULL
)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
ALTER TABLE ALERT_COMP_THRSHLD_RULE ADD CONSTRAINT ALERT_COMP_THRSHLD_RULE_IX1
UNIQUE (GEO_HIER_ASSOC_CD, PROD_HIER_SK, GEO_HIER_SK)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
CREATE SEQUENCE SEQ_ALERT_COMP_RANGE_RULE_SK START WITH 100000
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
CREATE TABLE ALERT_COMP_THRSHLD_RANGE_RULE
(
ALERT_COMP_RANGE_RULE_SK   INTEGER PRIMARY KEY,
ALERT_COMP_THRSHLD_RULE_SK INTEGER ,
MIN_RANGE_VALUE               NUMERIC(12,2) NOT NULL,
MAX_RANGE_VALUE               NUMERIC(12,2) NOT NULL,
THRESHOLD_VALUE               NUMERIC(12,2) NOT NULL
)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
ALTER TABLE ALERT_COMP_THRSHLD_RANGE_RULE ADD CONSTRAINT
ALERT_COMP_THRSHLD_RNG_RL_IX1 UNIQUE (ALERT_COMP_THRSHLD_RULE_SK,MIN_RANGE_VALUE, MAX_RANGE_VALUE)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
 
 
proc sql;
 
 
 
CREATE TABLE ALERT_COMP_THRSHLD_RULE
(
ALERT_COMP_THRSHLD_RULE_SK INTEGER PRIMARY KEY,
PROD_HIER_SK                  INTEGER NOT NULL,
GEO_HIER_SK                   INTEGER NOT NULL,
GEO_HIER_ASSOC_CD             INTEGER NOT NULL,
THRESHOLD_VALUE_TYPE          INTEGER NOT NULL
);
 
 
 
ALTER TABLE ALERT_COMP_THRSHLD_RULE ADD CONSTRAINT ALERT_COMP_THRSHLD_RULE_IX1
UNIQUE (GEO_HIER_ASSOC_CD, PROD_HIER_SK, GEO_HIER_SK);
 
 
 
 
CREATE TABLE ALERT_COMP_THRSHLD_RANGE_RULE
(
ALERT_COMP_RANGE_RULE_SK   INTEGER PRIMARY KEY,
ALERT_COMP_THRSHLD_RULE_SK INTEGER ,
MIN_RANGE_VALUE               NUMERIC(12,2) NOT NULL,
MAX_RANGE_VALUE               NUMERIC(12,2) NOT NULL,
THRESHOLD_VALUE               NUMERIC(12,2) NOT NULL
);
 
 
 
ALTER TABLE ALERT_COMP_THRSHLD_RANGE_RULE ADD CONSTRAINT ALERT_COMP_THRSHLD_RNG_RL_IX1
UNIQUE (ALERT_COMP_THRSHLD_RULE_SK, MIN_RANGE_VALUE, MAX_RANGE_VALUE);
 
 
 
 
quit;
 
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID753541;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID753541;
%put ERROR- Description                              : Adding tables for Competitor price change threshold;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 20APR2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID753541;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID753541",
"Adding tables for Competitor price change threshold",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID753541:;
 
 
* End of changes for CHANGE_ID:ID753541;
 
 
***********************************************************************************************;
*************************************  End Change ID753541 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID713182 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID713182;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID713182")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_trans..MODEL_SPEC_DEFAULT))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_trans..MODEL_SPEC_DEFAULT;
%put NOTE: Change ID                             :ID713182;
%goto ID713182;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID713182;
%goto ID713182;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID713182;
* Insert record into change management table for CHANGE_ID: ID713182;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID713182",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID713182;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
DELETE FROM MODEL_SPEC_DEFAULT WHERE SPEC_NM = 'HEDONIC_VOL_TSF'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('HEDONIC_VOL_TSF','ALL','-1','1',NULL)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
DELETE FROM MODEL_SPEC_DEFAULT WHERE SPEC_NM = 'HEDONIC_VOL_TSF';
 
 
INSERT INTO MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('HEDONIC_VOL_TSF','ALL','-1','1',NULL);
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID713182;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID713182;
%put ERROR- Description                              : Add HEDONIC_VOL_TSF model spec;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 25APR2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID713182;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID713182",
"Add HEDONIC_VOL_TSF model spec",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID713182:;
 
 
* End of changes for CHANGE_ID:ID713182;
 
 
***********************************************************************************************;
*************************************  End Change ID713182 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID0750384 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID0750384;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID0750384")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(&m_di_trans.)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_di_trans.;
%put NOTE: Change ID                             :ID0750384;
%goto ID0750384;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID0750384;
%goto ID0750384;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID0750384;
* Insert record into change management table for CHANGE_ID: ID0750384;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID0750384",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID0750384;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
%let m_sql_statement = %str(
CREATE TABLE REQ_PACKREC_DELIVERY_TYPE (
REQUEST_ID               INTEGER NOT NULL,
DELIVERY_ID              INTEGER NOT NULL,
DELIVERY_TYPE_ID         INTEGER NOT NULL,
DELIVERY_TYPE_NM         VARCHAR(40)
)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
CREATE UNIQUE INDEX REQ_PACKREC_DEL_TYPE_PK on REQ_PACKREC_DELIVERY_TYPE (REQUEST_ID, DELIVERY_ID) nologging parallel
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE REQ_PACKREC_DELIVERY_TYPE ADD CONSTRAINT REQ_PACKREC_DEL_TYPE_PK PRIMARY KEY (REQUEST_ID, DELIVERY_ID) USING INDEX REQ_PACKREC_DEL_TYPE_PK
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
CREATE TABLE &m_di_trans..REQ_PACKREC_DELIVERY_TYPE (
REQUEST_ID               INTEGER NOT NULL,
DELIVERY_ID              INTEGER NOT NULL,
DELIVERY_TYPE_ID         INTEGER NOT NULL,
DELIVERY_TYPE_NM         VARCHAR(40),
CONSTRAINT PRIM_KEY PRIMARY KEY (REQUEST_ID, DELIVERY_ID)
);
 
 
quit;
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID0750384;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID0750384;
%put ERROR- Description                              : New Request table to support delivery types in pack recommendation;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 04APR2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID0750384;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID0750384",
"New Request table to support delivery types in pack recommendation",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID0750384:;
 
 
* End of changes for CHANGE_ID:ID0750384;
 
 
***********************************************************************************************;
*************************************  End Change ID0750384 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID726328 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID726328;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID726328")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_trans..MODEL_SPEC_DEFAULT))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_trans..MODEL_SPEC_DEFAULT;
%put NOTE: Change ID                             :ID726328;
%goto ID726328;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID726328;
%goto ID726328;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID726328;
* Insert record into change management table for CHANGE_ID: ID726328;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID726328",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID726328;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
DELETE FROM MODEL_SPEC_DEFAULT WHERE SPEC_NM = 'EXCLUDE_NP_FROM_SHARE'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('EXCLUDE_NP_FROM_SHARE','FCST','2','0',NULL)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
DELETE FROM MODEL_SPEC_DEFAULT WHERE SPEC_NM = 'EXCLUDE_NP_FROM_SHARE';
 
 
INSERT INTO MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('EXCLUDE_NP_FROM_SHARE','FCST','2','0',NULL);
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID726328;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID726328;
%put ERROR- Description                              : Add new model spec EXCLUDE_NP_FROM_SHARE;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 03MAY2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID726328;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID726328",
"Add new model spec EXCLUDE_NP_FROM_SHARE",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID726328:;
 
 
* End of changes for CHANGE_ID:ID726328;
 
 
***********************************************************************************************;
*************************************  End Change ID726328 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change UNIFORM_TIMING_NOT_NULL ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: UNIFORM_TIMING_NOT_NULL;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("UNIFORM_TIMING_NOT_NULL")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : UNIFORM_TIMING_NOT_NULL;
%goto UNIFORM_TIMING_NOT_NULL;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52,M2TKMI43);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : UNIFORM_TIMING_NOT_NULL;
* Insert record into change management table for CHANGE_ID: UNIFORM_TIMING_NOT_NULL;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"UNIFORM_TIMING_NOT_NULL",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto UNIFORM_TIMING_NOT_NULL;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
UPDATE MDO_PLAN SET UNIFORM_TIMING_NUM_MARKDN = 0 WHERE UNIFORM_TIMING_NUM_MARKDN IS NULL
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
UPDATE MDO_PLAN SET UNIFORM_TIMING_PROD_LVL = DECISION_PROD_LVL WHERE UNIFORM_TIMING_PROD_LVL IS NULL
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
UPDATE MDO_PLAN SET UNIFORM_TIMING_GEO_LVL = DECISION_GEO_LVL WHERE UNIFORM_TIMING_GEO_LVL IS NULL
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
ALTER TABLE MDO_PLAN
MODIFY
(
UNIFORM_TIMING_NUM_MARKDN INTEGER NOT NULL,
UNIFORM_TIMING_PROD_LVL INTEGER NOT NULL,
UNIFORM_TIMING_GEO_LVL INTEGER NOT NULL
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
 
Proc sql;
 
 
 
UPDATE MDO_PLAN SET UNIFORM_TIMING_NUM_MARKDN = 0 WHERE UNIFORM_TIMING_NUM_MARKDN IS NULL;
 
 
UPDATE MDO_PLAN SET UNIFORM_TIMING_PROD_LVL = DECISION_PROD_LVL WHERE UNIFORM_TIMING_PROD_LVL IS NULL;
 
 
UPDATE MDO_PLAN SET UNIFORM_TIMING_GEO_LVL = DECISION_GEO_LVL WHERE UNIFORM_TIMING_GEO_LVL IS NULL;
 
 
 
ALTER TABLE MDO_PLAN ADD NOT NULL (UNIFORM_TIMING_NUM_MARKDN);
 
 
ALTER TABLE MDO_PLAN ADD NOT NULL (UNIFORM_TIMING_PROD_LVL);
 
 
ALTER TABLE MDO_PLAN ADD NOT NULL (UNIFORM_TIMING_GEO_LVL);
 
 
 
quit;
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: UNIFORM_TIMING_NOT_NULL;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: UNIFORM_TIMING_NOT_NULL;
%put ERROR- Description                              : Modify Uniform Timing Columns in MDO_PLAN to Not Null;
%put ERROR- Version                                  : D3MICM52,M2TKMI43;
%put ERROR- Date of Change                           : 26APR2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: UNIFORM_TIMING_NOT_NULL;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"UNIFORM_TIMING_NOT_NULL",
"Modify Uniform Timing Columns in MDO_PLAN to Not Null",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%UNIFORM_TIMING_NOT_NULL:;
 
 
* End of changes for CHANGE_ID:UNIFORM_TIMING_NOT_NULL;
 
 
***********************************************************************************************;
*************************************  End Change UNIFORM_TIMING_NOT_NULL ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID727189 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID727189;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID727189")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID727189;
%goto ID727189;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52, M2TKMI43);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID727189;
* Insert record into change management table for CHANGE_ID: ID727189;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID727189",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID727189;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
ALTER TABLE MPLN_GEO_PROD_RESULT
ADD
(
DELAY_MARGIN_AMT NUMERIC(20,3),
DELAY_END_INV_AT_RISK_UNITS NUMERIC(12,2),
DELAY_MARKDN_LOSS_AMT NUMERIC(20,3),
DELAY_SALES_UNITS NUMERIC(12,2),
DELAY_END_INV_UNITS NUMERIC(12,2)
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
ALTER TABLE MPLN_RESULT
ADD
(
DELAY_MARGIN_AMT NUMERIC(20,3),
DELAY_END_INV_AT_RISK_UNITS NUMERIC(12,2),
DELAY_MARKDN_LOSS_AMT NUMERIC(20,3),
DELAY_SALES_UNITS NUMERIC(12,2),
DELAY_END_INV_UNITS NUMERIC(12,2)
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
 
Proc sql;
 
 
 
ALTER TABLE MPLN_GEO_PROD_RESULT
ADD
DELAY_MARGIN_AMT NUMERIC(20,3),
DELAY_END_INV_AT_RISK_UNITS NUMERIC(12,2),
DELAY_MARKDN_LOSS_AMT NUMERIC(20,3),
DELAY_SALES_UNITS NUMERIC(12,2),
DELAY_END_INV_UNITS NUMERIC(12,2)
;
 
 
 
ALTER TABLE MPLN_RESULT
ADD
DELAY_MARGIN_AMT NUMERIC(20,3),
DELAY_END_INV_AT_RISK_UNITS NUMERIC(12,2),
DELAY_MARKDN_LOSS_AMT NUMERIC(20,3),
DELAY_SALES_UNITS NUMERIC(12,2),
DELAY_END_INV_UNITS NUMERIC(12,2)
;
 
 
 
quit;
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID727189;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID727189;
%put ERROR- Description                              : Additional columns required to persist Delay Plan metrics;
%put ERROR- Version                                  : D3MICM52, M2TKMI43;
%put ERROR- Date of Change                           : 03MAY2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID727189;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID727189",
"Additional columns required to persist Delay Plan metrics",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID727189:;
 
 
* End of changes for CHANGE_ID:ID727189;
 
 
***********************************************************************************************;
*************************************  End Change ID727189 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID755863 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID755863;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID755863")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID755863;
%goto ID755863;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52, M2TKMI43);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID755863;
* Insert record into change management table for CHANGE_ID: ID755863;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID755863",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID755863;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
ALTER TABLE MPLN_GEO_PROD_RESULT
ADD
(
LOW_DEMAND_NUM_MEMBERS INTEGER
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
ALTER TABLE MPLN_RESULT
ADD
(
LOW_DEMAND_NUM_MEMBERS INTEGER
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
 
Proc sql;
 
 
 
ALTER TABLE MPLN_GEO_PROD_RESULT
ADD
LOW_DEMAND_NUM_MEMBERS INTEGER
;
 
 
 
ALTER TABLE MPLN_RESULT
ADD
LOW_DEMAND_NUM_MEMBERS INTEGER
;
 
 
 
quit;
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID755863;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID755863;
%put ERROR- Description                              : Add Count of Low Baseline demand prod/geo as a new Markdown metrics;
%put ERROR- Version                                  : D3MICM52, M2TKMI43;
%put ERROR- Date of Change                           : 03MAY2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID755863;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID755863",
"Add Count of Low Baseline demand prod/geo as a new Markdown metrics",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID755863:;
 
 
* End of changes for CHANGE_ID:ID755863;
 
 
***********************************************************************************************;
*************************************  End Change ID755863 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID750624 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID750624;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID750624")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_trans..MODEL_SPEC_DEFAULT))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_trans..MODEL_SPEC_DEFAULT;
%put NOTE: Change ID                             :ID750624;
%goto ID750624;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID750624;
%goto ID750624;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID750624;
* Insert record into change management table for CHANGE_ID: ID750624;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID750624",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID750624;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
DELETE FROM MODEL_SPEC_DEFAULT WHERE SPEC_NM = 'FCST_DISAGG_METHOD'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('FCST_DISAGG_METHOD','FCST','1','1',NULL)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('FCST_DISAGG_METHOD','FCST','2','1',NULL)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
DELETE FROM MODEL_SPEC_DEFAULT WHERE SPEC_NM = 'FCST_DISAGG_METHOD';
 
 
INSERT INTO MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('FCST_DISAGG_METHOD','FCST','1','1',NULL);
 
 
INSERT INTO MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('FCST_DISAGG_METHOD','FCST','2','1',NULL);
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID750624;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID750624;
%put ERROR- Description                              : Add new model spec FCST_DISAGG_METHOD;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 04MAY2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID750624;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID750624",
"Add new model spec FCST_DISAGG_METHOD",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID750624:;
 
 
* End of changes for CHANGE_ID:ID750624;
 
 
***********************************************************************************************;
*************************************  End Change ID750624 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID749317 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID749317;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID749317")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID749317;
%goto ID749317;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID749317;
* Insert record into change management table for CHANGE_ID: ID749317;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID749317",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID749317;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
 
%let m_sql_statement = %str(
ALTER TABLE ALERT_COST ADD INVC_COST_AMT_CHANGE NUMERIC(20,3)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE ALERT_COST ADD INVC_COST_PCT_CHANGE NUMERIC(12,2)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
 
ALTER TABLE ALERT_COST ADD INVC_COST_AMT_CHANGE NUMERIC(20,3);
 
 
ALTER TABLE ALERT_COST ADD INVC_COST_PCT_CHANGE NUMERIC(12,2);
 
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID749317;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID749317;
%put ERROR- Description                              : Display current cost and cost change in new cost alerts;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 04MAY2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID749317;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID749317",
"Display current cost and cost change in new cost alerts",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID749317:;
 
 
* End of changes for CHANGE_ID:ID749317;
 
 
***********************************************************************************************;
*************************************  End Change ID749317 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID750199 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID750199;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID750199")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_trans..MODEL_SPEC_DEFAULT))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_trans..MODEL_SPEC_DEFAULT;
%put NOTE: Change ID                             :ID750199;
%goto ID750199;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID750199;
%goto ID750199;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID750199;
* Insert record into change management table for CHANGE_ID: ID750199;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID750199",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID750199;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
DELETE FROM MODEL_SPEC_DEFAULT WHERE SPEC_NM = 'PRICE_SP' AND MODEL_COMP_NM = 'TS'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('PRICE_SP','TS','-1','1',NULL)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
DELETE FROM MODEL_SPEC_DEFAULT WHERE SPEC_NM = 'PRICE_SS' AND MODEL_COMP_NM = 'TS'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('PRICE_SS','TS','-1','0',NULL)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
DELETE FROM MODEL_SPEC_DEFAULT WHERE SPEC_NM = 'PS_SP' AND MODEL_COMP_NM = 'TS'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('PS_SP','TS','-1','1',NULL)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
DELETE FROM MODEL_SPEC_DEFAULT WHERE SPEC_NM = 'PS_SS' AND MODEL_COMP_NM = 'TS'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('PS_SS','TS','-1','0',NULL)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
DELETE FROM MODEL_SPEC_DEFAULT WHERE SPEC_NM = 'INV_ADJ_SP' AND MODEL_COMP_NM = 'TS'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('INV_ADJ_SP','TS','-1','1',NULL)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
DELETE FROM MODEL_SPEC_DEFAULT WHERE SPEC_NM = 'INV_ADJ_SS' AND MODEL_COMP_NM = 'TS'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('INV_ADJ_SS','TS','-1','0',NULL)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
DELETE FROM MODEL_SPEC_DEFAULT WHERE SPEC_NM = 'PL_ADJ_SP' AND MODEL_COMP_NM = 'TS'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('PL_ADJ_SP','TS','-1','1',NULL)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
DELETE FROM MODEL_SPEC_DEFAULT WHERE SPEC_NM = 'PL_ADJ_SS' AND MODEL_COMP_NM = 'TS'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('PL_ADJ_SS','TS','-1','0',NULL)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
DELETE FROM MODEL_SPEC_DEFAULT WHERE SPEC_NM = 'SEASON_SP' AND MODEL_COMP_NM = 'TS'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('SEASON_SP','TS','-1','1',NULL)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
DELETE FROM MODEL_SPEC_DEFAULT WHERE SPEC_NM = 'SEASON_SS' AND MODEL_COMP_NM = 'TS'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('SEASON_SS','TS','-1','0',NULL)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
DELETE FROM MODEL_SPEC_DEFAULT WHERE SPEC_NM = 'PRICE_SP' AND MODEL_COMP_NM = 'TS';
 
 
INSERT INTO MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('PRICE_SP','TS','-1','1',NULL);
 
 
 
DELETE FROM MODEL_SPEC_DEFAULT WHERE SPEC_NM = 'PRICE_SS' AND MODEL_COMP_NM = 'TS';
 
 
INSERT INTO MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('PRICE_SS','TS','-1','0',NULL);
 
 
DELETE FROM MODEL_SPEC_DEFAULT WHERE SPEC_NM = 'PS_SP' AND MODEL_COMP_NM = 'TS';
 
 
INSERT INTO MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('PS_SP','TS','-1','1',NULL);
 
 
DELETE FROM MODEL_SPEC_DEFAULT WHERE SPEC_NM = 'PS_SS' AND MODEL_COMP_NM = 'TS';
 
 
INSERT INTO MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('PS_SS','TS','-1','0',NULL);
 
 
DELETE FROM MODEL_SPEC_DEFAULT WHERE SPEC_NM = 'INV_ADJ_SP' AND MODEL_COMP_NM = 'TS';
 
 
INSERT INTO MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('INV_ADJ_SP','TS','-1','1',NULL);
 
 
DELETE FROM MODEL_SPEC_DEFAULT WHERE SPEC_NM = 'INV_ADJ_SS' AND MODEL_COMP_NM = 'TS';
 
 
INSERT INTO MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('INV_ADJ_SS','TS','-1','0',NULL);
 
 
DELETE FROM MODEL_SPEC_DEFAULT WHERE SPEC_NM = 'PL_ADJ_SP' AND MODEL_COMP_NM = 'TS';
 
 
INSERT INTO MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('PL_ADJ_SP','TS','-1','1',NULL);
 
 
DELETE FROM MODEL_SPEC_DEFAULT WHERE SPEC_NM = 'PL_ADJ_SS' AND MODEL_COMP_NM = 'TS';
 
 
INSERT INTO MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('PL_ADJ_SS','TS','-1','0',NULL);
 
 
DELETE FROM MODEL_SPEC_DEFAULT WHERE SPEC_NM = 'SEASON_SP' AND MODEL_COMP_NM = 'TS';
 
 
INSERT INTO MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('SEASON_SP','TS','-1','1',NULL);
 
 
DELETE FROM MODEL_SPEC_DEFAULT WHERE SPEC_NM = 'SEASON_SS' AND MODEL_COMP_NM = 'TS';
 
 
INSERT INTO MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('SEASON_SS','TS','-1','0',NULL);
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID750199;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID750199;
%put ERROR- Description                              : Add TS specs price_sp/ss,ps_sp/ss,inv_adj_sp/ss,pl_adj_sp/ss,season_sp/ss;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 05MAY2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID750199;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID750199",
"Add TS specs price_sp/ss,ps_sp/ss,inv_adj_sp/ss,pl_adj_sp/ss,season_sp/ss",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID750199:;
 
 
* End of changes for CHANGE_ID:ID750199;
 
 
***********************************************************************************************;
*************************************  End Change ID750199 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID757899 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID757899;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID757899")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_trans..PRF_SIZESET_MBR))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_trans..PRF_SIZESET_MBR;
%put NOTE: Change ID                             :ID757899;
%goto ID757899;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID757899;
%goto ID757899;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID757899;
* Insert record into change management table for CHANGE_ID: ID757899;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID757899",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID757899;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE)) %then %do;
%let m_sql_statement = %str(
ALTER TABLE PRF_SIZESET_MBR ADD POST_IMPUTATION_SALES_UNITS NUMERIC(12,2)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
CREATE TABLE PRF_PROD_SIZE_EXCLUDE
(
PROFILING_PROJECT_SK          INTEGER NOT NULL,
PROD_HIER_SK                  INTEGER NOT NULL,
STD_SIZE_CD                   INTEGER NOT NULL,
PRIMARY KEY (PROFILING_PROJECT_SK, PROD_HIER_SK, STD_SIZE_CD)
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
 
proc sql;
 
 
CREATE TABLE PRF_PROD_SIZE_EXCLUDE
(
PROFILING_PROJECT_SK          INTEGER NOT NULL,
PROD_HIER_SK                  INTEGER NOT NULL,
STD_SIZE_CD                   INTEGER NOT NULL,
CONSTRAINT PRIM_KEY PRIMARY KEY (PROFILING_PROJECT_SK, PROD_HIER_SK, STD_SIZE_CD)
)
;
 
 
quit;
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (DB2)) %then %do;
%let m_sql_statement = %str(
ALTER TABLE PRF_SIZESET_MBR ADD POST_IMPUTATION_SALES_UNITS NUMERIC(12,2)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
CREATE TABLE PRF_PROD_SIZE_EXCLUDE
(
PROFILING_PROJECT_SK          INTEGER NOT NULL,
PROD_HIER_SK                  INTEGER NOT NULL,
STD_SIZE_CD                   INTEGER NOT NULL,
PRIMARY KEY (PROFILING_PROJECT_SK, PROD_HIER_SK, STD_SIZE_CD)
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID757899;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID757899;
%put ERROR- Description                              : SIZE PROFILING 3.2 SCHEMA CHANGES PART II;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 05MAY2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID757899;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID757899",
"SIZE PROFILING 3.2 SCHEMA CHANGES PART II",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID757899:;
 
 
* End of changes for CHANGE_ID:ID757899;
 
 
***********************************************************************************************;
*************************************  End Change ID757899 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID757899_2 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID757899_2;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID757899_2")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_trans..PRF_SIZESET_MBR))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_trans..PRF_SIZESET_MBR;
%put NOTE: Change ID                             :ID757899_2;
%goto ID757899_2;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID757899_2;
%goto ID757899_2;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID757899_2;
* Insert record into change management table for CHANGE_ID: ID757899_2;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID757899_2",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID757899_2;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
ALTER TABLE PRF_SIZESET_MBR ADD POST_IMPUTATION_SALES_UNITS NUMERIC(12,2);
 
 
quit;
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID757899_2;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID757899_2;
%put ERROR- Description                              : SIZE PROFILING 3.2 SCHEMA CHANGES PART II;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 15SEP2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID757899_2;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID757899_2",
"SIZE PROFILING 3.2 SCHEMA CHANGES PART II",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID757899_2:;
 
 
* End of changes for CHANGE_ID:ID757899_2;
 
 
***********************************************************************************************;
*************************************  End Change ID757899_2 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID757500 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID757500;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID757500")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID757500;
%goto ID757500;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52,M2TKMI43);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID757500;
* Insert record into change management table for CHANGE_ID: ID757500;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID757500",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID757500;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
ALTER TABLE GEO_PROD_MTS
ADD
(
SEASON_START_INV_UNITS NUMERIC(12,2),
SEASON_START_INV_VAL_AT_RET NUMERIC(20,3),
SEASON_TO_DT_REVENUE_AMT NUMERIC(20,3)
)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
ALTER TABLE MPLN_GEO_PROD_MTS
ADD
(
SEASON_START_INV_UNITS NUMERIC(12,2),
SEASON_START_INV_VAL_AT_RET NUMERIC(20,3),
SEASON_TO_DT_REVENUE_AMT NUMERIC(20,3)
)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
 
proc sql;
 
 
 
ALTER TABLE GEO_PROD_MTS ADD SEASON_START_INV_UNITS NUMERIC(12,2);
 
 
ALTER TABLE GEO_PROD_MTS ADD SEASON_START_INV_VAL_AT_RET NUMERIC(20,3);
 
 
ALTER TABLE GEO_PROD_MTS ADD SEASON_TO_DT_REVENUE_AMT NUMERIC(20,3);
 
 
 
ALTER TABLE MPLN_GEO_PROD_MTS ADD SEASON_START_INV_UNITS NUMERIC(12,2);
 
 
ALTER TABLE MPLN_GEO_PROD_MTS ADD SEASON_START_INV_VAL_AT_RET NUMERIC(20,3);
 
 
ALTER TABLE MPLN_GEO_PROD_MTS ADD SEASON_TO_DT_REVENUE_AMT NUMERIC(20,3);
 
 
 
quit;
 
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID757500;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID757500;
%put ERROR- Description                              : Add columns to geo_prod_mts and mpln_geo_prod_mts;
%put ERROR- Version                                  : D3MICM52,M2TKMI43;
%put ERROR- Date of Change                           : 06MAY2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID757500;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID757500",
"Add columns to geo_prod_mts and mpln_geo_prod_mts",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID757500:;
 
 
* End of changes for CHANGE_ID:ID757500;
 
 
***********************************************************************************************;
*************************************  End Change ID757500 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID757540 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID757540;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID757540")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID757540;
%goto ID757540;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52,M2TKMI43);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID757540;
* Insert record into change management table for CHANGE_ID: ID757540;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID757540",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID757540;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
CREATE TABLE BUDGET
(
BUDGET_NM VARCHAR(100),
BUDGET_TYPE INTEGER NOT NULL,
GEO_HIER_SK INTEGER NOT NULL,
PROD_HIER_SK INTEGER NOT NULL,
START_DT DATE NOT NULL,
END_DT DATE NOT NULL,
TOTAL_BUDGET_AMT NUMERIC(20,3) NOT NULL,
USED_BUDGET_AMT NUMERIC(20,3) NOT NULL,
REVISED_BUDGET_AMT NUMERIC(20,3),
PRIMARY KEY (GEO_HIER_SK, PROD_HIER_SK, START_DT, BUDGET_TYPE)
)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
 
proc sql;
 
 
 
CREATE TABLE BUDGET
(
BUDGET_NM VARCHAR(100),
BUDGET_TYPE INTEGER NOT NULL,
GEO_HIER_SK INTEGER NOT NULL,
PROD_HIER_SK INTEGER NOT NULL,
START_DT DATE NOT NULL,
END_DT DATE NOT NULL,
TOTAL_BUDGET_AMT NUMERIC(20,3) NOT NULL,
USED_BUDGET_AMT NUMERIC(20,3) NOT NULL,
REVISED_BUDGET_AMT NUMERIC(20,3),
CONSTRAINT PRIM_KEY PRIMARY KEY (GEO_HIER_SK, PROD_HIER_SK, START_DT, BUDGET_TYPE)
);
 
 
 
quit;
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID757540;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID757540;
%put ERROR- Description                              : Add budget table to transacted schema;
%put ERROR- Version                                  : D3MICM52,M2TKMI43;
%put ERROR- Date of Change                           : 06MAY2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID757540;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID757540",
"Add budget table to transacted schema",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID757540:;
 
 
* End of changes for CHANGE_ID:ID757540;
 
 
***********************************************************************************************;
*************************************  End Change ID757540 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID758390 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID758390;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID758390")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID758390;
%goto ID758390;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52,M2TKMI43);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID758390;
* Insert record into change management table for CHANGE_ID: ID758390;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID758390",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID758390;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
ALTER TABLE MPLN_RESULT
ADD INV_AT_RISK_NUM_MEMBERS INTEGER
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
ALTER TABLE MPLN_GEO_PROD_RESULT
ADD INV_AT_RISK_NUM_MEMBERS INTEGER
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
ALTER TABLE MPLN_RESULT
ADD INV_AT_RISK_NUM_MEMBERS INTEGER
;
 
 
 
ALTER TABLE MPLN_GEO_PROD_RESULT
ADD INV_AT_RISK_NUM_MEMBERS INTEGER
;
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID758390;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID758390;
%put ERROR- Description                              : Add inventory at risk number of members;
%put ERROR- Version                                  : D3MICM52,M2TKMI43;
%put ERROR- Date of Change                           : 09MAY2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID758390;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID758390",
"Add inventory at risk number of members",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID758390:;
 
 
* End of changes for CHANGE_ID:ID758390;
 
 
***********************************************************************************************;
*************************************  End Change ID758390 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID759165 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID759165;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID759165")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID759165;
%goto ID759165;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID759165;
* Insert record into change management table for CHANGE_ID: ID759165;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID759165",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID759165;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
ALTER TABLE FA_SCENARIO_STATUS
ADD WEIGHTED_MAPE_FIT NUMERIC(12,2)
ADD MEDIAN_PE_FIT NUMERIC(12,2)
ADD WEIGHTED_MEAN_PE_FIT NUMERIC(12,2)
ADD HOLIDAY_ID INTEGER
ADD HOLIDAY_NM VARCHAR(40)
ADD MAX_HD_RMSE_FIT NUMERIC(12,2)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
ALTER TABLE FA_SCORE
ADD WEIGHTED_MAPE_FIT NUMERIC(12,2)
ADD MEDIAN_PE_FIT NUMERIC(12,2)
ADD WEIGHTED_MEAN_PE_FIT NUMERIC(12,2)
ADD HOLIDAY_ID INTEGER
ADD HOLIDAY_NM VARCHAR(40)
ADD MAX_HD_RMSE_FIT NUMERIC(12,2)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
ALTER TABLE FA_SCENARIO_STATUS
ADD WEIGHTED_MAPE_FIT NUMERIC(12,2)
ADD MEDIAN_PE_FIT NUMERIC(12,2)
ADD WEIGHTED_MEAN_PE_FIT NUMERIC(12,2)
ADD HOLIDAY_ID INTEGER
ADD HOLIDAY_NM VARCHAR(40)
ADD MAX_HD_RMSE_FIT NUMERIC(12,2)
;
 
 
 
ALTER TABLE FA_SCORE
ADD WEIGHTED_MAPE_FIT NUMERIC(12,2)
ADD MEDIAN_PE_FIT NUMERIC(12,2)
ADD WEIGHTED_MEAN_PE_FIT NUMERIC(12,2)
ADD HOLIDAY_ID INTEGER
ADD HOLIDAY_NM VARCHAR(40)
ADD MAX_HD_RMSE_FIT NUMERIC(12,2)
;
 
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID759165;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID759165;
%put ERROR- Description                              : Enhancements to MA and FA;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 11MAY2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID759165;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID759165",
"Enhancements to MA and FA",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID759165:;
 
 
* End of changes for CHANGE_ID:ID759165;
 
 
***********************************************************************************************;
*************************************  End Change ID759165 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID0755732 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID0755732;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID0755732")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID0755732;
%goto ID0755732;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID0755732;
* Insert record into change management table for CHANGE_ID: ID0755732;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID0755732",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID0755732;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
%let m_sql_statement = %str(
UPDATE PROFILE_SCORE_SETTING SET CLASSIFIED_STORE_PENALTY = 1
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
UPDATE PROFILE_SCORE_SETTING SET CLASSIFIED_STORE_PENALTY = 1;
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID0755732;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID0755732;
%put ERROR- Description                              : Default value of CLASSIFIED_STORE_PENALTY in PROFILE_SCORE_SETTING should be 1;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 05MAY2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID0755732;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID0755732",
"Default value of CLASSIFIED_STORE_PENALTY in PROFILE_SCORE_SETTING should be 1",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID0755732:;
 
 
* End of changes for CHANGE_ID:ID0755732;
 
 
***********************************************************************************************;
*************************************  End Change ID0755732 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID759742 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID759742;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID759742")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID759742;
%goto ID759742;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID759742;
* Insert record into change management table for CHANGE_ID: ID759742;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID759742",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID759742;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
update ALERT_COST set
INVC_COST_AMT_CHANGE = INVC_COST - PREV_INVC_COST,
INVC_COST_PCT_CHANGE = (INVC_COST - PREV_INVC_COST) / PREV_INVC_COST
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
update ALERT_COST set
INVC_COST_AMT_CHANGE = INVC_COST - PREV_INVC_COST,
INVC_COST_PCT_CHANGE = (INVC_COST - PREV_INVC_COST) / PREV_INVC_COST ;
 
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID759742;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID759742;
%put ERROR- Description                              : ROMR74410 Display current cost and cost change in new cost alerts;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 13MAY2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID759742;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID759742",
"ROMR74410 Display current cost and cost change in new cost alerts",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID759742:;
 
 
* End of changes for CHANGE_ID:ID759742;
 
 
***********************************************************************************************;
*************************************  End Change ID759742 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID758581 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID758581;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID758581")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID758581;
%goto ID758581;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID758581;
* Insert record into change management table for CHANGE_ID: ID758581;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID758581",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID758581;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
ALTER TABLE PRF_JOB ADD JOB_TYPE INTEGER DEFAULT 1 NOT NULL
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE PRF_JOB RENAME COLUMN PROFILING_PROJECT_SK TO CONTEXT_SK
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE PRF_JOB MODIFY CONTEXT_SK INTEGER  NULL
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
DROP TABLE PRF_RSLT_SG_ATTR
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
 
 
data &m_di_trans..PRF_JOB;
 
 
set &m_di_trans..PRF_JOB;
 
 
ATTRIB JOB_TYPE LENGTH=4;
 
 
 
JOB_TYPE=1;
 
 
RUN;
 
 
 
proc sql;
 
 
ALTER TABLE PRF_JOB  add CONSTRAINT PRIM_KEY  PRIMARY KEY (PRF_JOB_SK);
 
 
quit;
 
 
 
 
proc datasets library=&m_di_trans.  nolist nodetails nowarn ;
 
 
MODIFY PRF_JOB;
 
 
RENAME  PROFILING_PROJECT_SK=CONTEXT_SK;
 
 
IC DELETE _NM0002_;
 
 
 
QUIT;
 
 
 
proc sql;
 
 
DROP TABLE PRF_RSLT_SG_ATTR;
 
 
quit;
 
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID758581;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID758581;
%put ERROR- Description                              : SIZE PROFILING 3.2 SCHEMA CHANGES PART III;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 13MAY2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID758581;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID758581",
"SIZE PROFILING 3.2 SCHEMA CHANGES PART III",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID758581:;
 
 
* End of changes for CHANGE_ID:ID758581;
 
 
***********************************************************************************************;
*************************************  End Change ID758581 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID722108 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID722108;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID722108")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID722108;
%goto ID722108;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID722108;
* Insert record into change management table for CHANGE_ID: ID722108;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID722108",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID722108;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
UPDATE CONFIG_GROUP SET GEO_HIER_ASSOC_CD = 0 WHERE GEO_HIER_TYPE = 2
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
UPDATE CONFIG_GROUP SET PROD_HIER_ASSOC_CD = 0 WHERE PROD_HIER_TYPE = 2
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
UPDATE CONFIG_GROUP SET GEO_HIER_ASSOC_CD = 0 WHERE GEO_HIER_TYPE = 2;
 
 
UPDATE CONFIG_GROUP SET PROD_HIER_ASSOC_CD = 0 WHERE PROD_HIER_TYPE = 2;
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID722108;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID722108;
%put ERROR- Description                              : Remove global setting GEO_HIER_TYPE and PROD_HIER_TYPE;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 15MAY2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID722108;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID722108",
"Remove global setting GEO_HIER_TYPE and PROD_HIER_TYPE",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID722108:;
 
 
* End of changes for CHANGE_ID:ID722108;
 
 
***********************************************************************************************;
*************************************  End Change ID722108 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID722108_1 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID722108_1;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID722108_1")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID722108_1;
%goto ID722108_1;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID722108_1;
* Insert record into change management table for CHANGE_ID: ID722108_1;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID722108_1",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID722108_1;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
ALTER TABLE CONFIG_GROUP DROP COLUMN GEO_HIER_TYPE
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE CONFIG_GROUP DROP COLUMN PROD_HIER_TYPE
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
ALTER TABLE CONFIG_GROUP DROP COLUMN GEO_HIER_TYPE;
 
 
ALTER TABLE CONFIG_GROUP DROP COLUMN PROD_HIER_TYPE;
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID722108_1;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID722108_1;
%put ERROR- Description                              : Drop GEO_HIER_TYPE and PROD_HIER_TYPE columns from CONFIG_GROUP table;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 16MAY2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID722108_1;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID722108_1",
"Drop GEO_HIER_TYPE and PROD_HIER_TYPE columns from CONFIG_GROUP table",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID722108_1:;
 
 
* End of changes for CHANGE_ID:ID722108_1;
 
 
***********************************************************************************************;
*************************************  End Change ID722108_1 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID760165 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID760165;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID760165")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_trans..MODEL_SPEC_DEFAULT))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_trans..MODEL_SPEC_DEFAULT;
%put NOTE: Change ID                             :ID760165;
%goto ID760165;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID760165;
%goto ID760165;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID760165;
* Insert record into change management table for CHANGE_ID: ID760165;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID760165",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID760165;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
DELETE FROM MODEL_SPEC_DEFAULT WHERE SPEC_NM = 'MAX_FIT_APE'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('MAX_FIT_APE','MA','-1','1000',NULL)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('MAX_FIT_APE','FA','-1','1000',NULL)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
DELETE FROM FA_SPEC WHERE SPEC_NM = 'MAX_FIT_APE'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO FA_SPEC (MODEL_GROUP_ID,SPEC_NM,SPEC_VALUE)
VALUES (-1,'MAX_FIT_APE','1000')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
DELETE FROM MODEL_SPEC_DEFAULT WHERE SPEC_NM = 'MAX_FIT_APE';
 
 
INSERT INTO MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('MAX_FIT_APE','MA','-1','1000',NULL);
 
 
INSERT INTO MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('MAX_FIT_APE','FA','-1','1000',NULL);
 
 
 
DELETE FROM FA_SPEC WHERE SPEC_NM = 'MAX_FIT_APE';
 
 
INSERT INTO FA_SPEC (MODEL_GROUP_ID,SPEC_NM,SPEC_VALUE)
VALUES (-1,'MAX_FIT_APE','1000');
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID760165;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID760165;
%put ERROR- Description                              : Add MAX_FIT_APE as an FA spec and MA spec;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 16MAY2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID760165;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID760165",
"Add MAX_FIT_APE as an FA spec and MA spec",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID760165:;
 
 
* End of changes for CHANGE_ID:ID760165;
 
 
***********************************************************************************************;
*************************************  End Change ID760165 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID0760288 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID0760288;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID0760288")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(&m_di_trans.)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_di_trans.;
%put NOTE: Change ID                             :ID0760288;
%goto ID0760288;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID0760288;
%goto ID0760288;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID0760288;
* Insert record into change management table for CHANGE_ID: ID0760288;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID0760288",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID0760288;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
%let m_sql_statement = %str(
CREATE TABLE REQ_INVENTORY (
REQUEST_ID               INTEGER NOT NULL,
PROD_ID                  VARCHAR(32) NOT NULL,
GEO_ID                   varchar(32) NOT NULL,
RECEIPT_DT               DATE NOT NULL,
UNITS                    INTEGER NOT NULL
)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
CREATE UNIQUE INDEX REQ_INVENTORY_PK on REQ_INVENTORY (REQUEST_ID, PROD_ID, GEO_ID, RECEIPT_DT) nologging parallel
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE REQ_INVENTORY ADD CONSTRAINT REQ_INVENTORY_PK PRIMARY KEY (REQUEST_ID, PROD_ID, GEO_ID, RECEIPT_DT) USING INDEX REQ_INVENTORY_PK
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
 
PROC SQL;
 
 
CREATE TABLE REQ_INVENTORY (
REQUEST_ID               INTEGER NOT NULL,
PROD_ID                  VARCHAR(32) NOT NULL,
GEO_ID                   varchar(32) NOT NULL,
RECEIPT_DT               DATE NOT NULL,
UNITS                    INTEGER NOT NULL
);
 
 
CREATE UNIQUE INDEX REQ_INVENTORY_PK on REQ_INVENTORY (REQUEST_ID, PROD_ID, GEO_ID, RECEIPT_DT) ;
 
 
ALTER TABLE REQ_INVENTORY ADD CONSTRAINT PRIM_KEY PRIMARY KEY (REQUEST_ID, PROD_ID, GEO_ID, RECEIPT_DT) ;
 
 
 
QUIT;
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID0760288;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID0760288;
%put ERROR- Description                              : New table REQ_INVENTORY needed for packopt;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 18MAY2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID0760288;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID0760288",
"New table REQ_INVENTORY needed for packopt",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID0760288:;
 
 
* End of changes for CHANGE_ID:ID0760288;
 
 
***********************************************************************************************;
*************************************  End Change ID0760288 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID760260 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID760260;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID760260")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(&m_di_trans.)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_di_trans.;
%put NOTE: Change ID                             :ID760260;
%goto ID760260;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID760260;
%goto ID760260;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52,M2MI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID760260;
* Insert record into change management table for CHANGE_ID: ID760260;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID760260",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID760260;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
%let m_sql_statement = %str(
insert into geo_prod_setting(GEO_PROD_SETTING_SK,USED_BY_APP,GEO_HIER_SK,GEO_HIER_ASSOC_CD,PROD_HIER_SK,SETTING_TYPE,SETTING_OVERRIDE_FLG,SETTING_VAL,SETTING_FLOOR,SETTING_CEIL)   values ( 20025, 2, 1, 1, 1, 25, 1, 3.0, 0.0, 0.0)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into geo_prod_setting(GEO_PROD_SETTING_SK,USED_BY_APP,GEO_HIER_SK,GEO_HIER_ASSOC_CD,PROD_HIER_SK,SETTING_TYPE,SETTING_OVERRIDE_FLG,SETTING_VAL,SETTING_FLOOR,SETTING_CEIL)   values ( 20026, 2, 1, 1, 1, 26, 1, 3.0, 0.0, 0.0)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into geo_prod_setting(GEO_PROD_SETTING_SK,USED_BY_APP,GEO_HIER_SK,GEO_HIER_ASSOC_CD,PROD_HIER_SK,SETTING_TYPE,SETTING_OVERRIDE_FLG,SETTING_VAL,SETTING_FLOOR,SETTING_CEIL)   values ( 20027, 2, 1, 1, 1, 27, 1, -1.0, 0.0, 0.0)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into geo_prod_setting(GEO_PROD_SETTING_SK,USED_BY_APP,GEO_HIER_SK,GEO_HIER_ASSOC_CD,PROD_HIER_SK,SETTING_TYPE,SETTING_OVERRIDE_FLG,SETTING_VAL,SETTING_FLOOR,SETTING_CEIL)   values ( 20028, 2, 1, 1, 1, 28, 1, -1.0, 0.0, 0.0)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into geo_prod_setting(GEO_PROD_SETTING_SK,USED_BY_APP,GEO_HIER_SK,GEO_HIER_ASSOC_CD,PROD_HIER_SK,SETTING_TYPE,SETTING_OVERRIDE_FLG,SETTING_VAL,SETTING_FLOOR,SETTING_CEIL)   values ( 20029, 2, 1, 1, 1, 29, 1, 0.0, 0.00, 0.0)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into geo_prod_setting(GEO_PROD_SETTING_SK,USED_BY_APP,GEO_HIER_SK,GEO_HIER_ASSOC_CD,PROD_HIER_SK,SETTING_TYPE,SETTING_OVERRIDE_FLG,SETTING_VAL,SETTING_FLOOR,SETTING_CEIL)   values ( 20030, 2, 1, 1, 1, 30, 1, 0.0, 0.00, 0.0)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into geo_prod_setting(GEO_PROD_SETTING_SK,USED_BY_APP,GEO_HIER_SK,GEO_HIER_ASSOC_CD,PROD_HIER_SK,SETTING_TYPE,SETTING_OVERRIDE_FLG,SETTING_VAL,SETTING_FLOOR,SETTING_CEIL)   values ( 20031, 2, 1, 1, 1, 31, 1, 0.0, 0.00, 1.0)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into geo_prod_setting(GEO_PROD_SETTING_SK,USED_BY_APP,GEO_HIER_SK,GEO_HIER_ASSOC_CD,PROD_HIER_SK,SETTING_TYPE,SETTING_OVERRIDE_FLG,SETTING_VAL,SETTING_FLOOR,SETTING_CEIL)   values ( 20032, 2, 1, 1, 1, 32, 1, 0.0, 0.00, 10.0)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
insert into geo_prod_setting(GEO_PROD_SETTING_SK,USED_BY_APP,GEO_HIER_SK,GEO_HIER_ASSOC_CD,PROD_HIER_SK,SETTING_TYPE,SETTING_OVERRIDE_FLG,SETTING_VAL,SETTING_FLOOR,SETTING_CEIL)   values ( 20025, 2, 1, 1, 1, 25, 1, 3.0, 0.0, 0.0);
 
 
insert into geo_prod_setting(GEO_PROD_SETTING_SK,USED_BY_APP,GEO_HIER_SK,GEO_HIER_ASSOC_CD,PROD_HIER_SK,SETTING_TYPE,SETTING_OVERRIDE_FLG,SETTING_VAL,SETTING_FLOOR,SETTING_CEIL)   values ( 20026, 2, 1, 1, 1, 26, 1, 3.0, 0.0, 0.0);
 
 
insert into geo_prod_setting(GEO_PROD_SETTING_SK,USED_BY_APP,GEO_HIER_SK,GEO_HIER_ASSOC_CD,PROD_HIER_SK,SETTING_TYPE,SETTING_OVERRIDE_FLG,SETTING_VAL,SETTING_FLOOR,SETTING_CEIL)   values ( 20027, 2, 1, 1, 1, 27, 1, -1.0, 0.0, 0.0);
 
 
insert into geo_prod_setting(GEO_PROD_SETTING_SK,USED_BY_APP,GEO_HIER_SK,GEO_HIER_ASSOC_CD,PROD_HIER_SK,SETTING_TYPE,SETTING_OVERRIDE_FLG,SETTING_VAL,SETTING_FLOOR,SETTING_CEIL)   values ( 20028, 2, 1, 1, 1, 28, 1, -1.0, 0.0, 0.0);
 
 
insert into geo_prod_setting(GEO_PROD_SETTING_SK,USED_BY_APP,GEO_HIER_SK,GEO_HIER_ASSOC_CD,PROD_HIER_SK,SETTING_TYPE,SETTING_OVERRIDE_FLG,SETTING_VAL,SETTING_FLOOR,SETTING_CEIL)   values ( 20029, 2, 1, 1, 1, 29, 1, 0.0, 0.00, 0.0);
 
 
insert into geo_prod_setting(GEO_PROD_SETTING_SK,USED_BY_APP,GEO_HIER_SK,GEO_HIER_ASSOC_CD,PROD_HIER_SK,SETTING_TYPE,SETTING_OVERRIDE_FLG,SETTING_VAL,SETTING_FLOOR,SETTING_CEIL)   values ( 20030, 2, 1, 1, 1, 30, 1, 0.0, 0.00, 0.0);
 
 
insert into geo_prod_setting(GEO_PROD_SETTING_SK,USED_BY_APP,GEO_HIER_SK,GEO_HIER_ASSOC_CD,PROD_HIER_SK,SETTING_TYPE,SETTING_OVERRIDE_FLG,SETTING_VAL,SETTING_FLOOR,SETTING_CEIL)   values ( 20031, 2, 1, 1, 1, 31, 1, 0.0, 0.00, 1.0);
 
 
insert into geo_prod_setting(GEO_PROD_SETTING_SK,USED_BY_APP,GEO_HIER_SK,GEO_HIER_ASSOC_CD,PROD_HIER_SK,SETTING_TYPE,SETTING_OVERRIDE_FLG,SETTING_VAL,SETTING_FLOOR,SETTING_CEIL)   values ( 20032, 2, 1, 1, 1, 32, 1, 0.0, 0.00, 10.0);
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID760260;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID760260;
%put ERROR- Description                              : DEFAULT OPTIMIZATION SETTINGS;
%put ERROR- Version                                  : D3MICM52,M2MI42;
%put ERROR- Date of Change                           : 19MAY2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID760260;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID760260",
"DEFAULT OPTIMIZATION SETTINGS",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID760260:;
 
 
* End of changes for CHANGE_ID:ID760260;
 
 
***********************************************************************************************;
*************************************  End Change ID760260 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID761056 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID761056;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID761056")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(&m_di_trans.)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_di_trans.;
%put NOTE: Change ID                             :ID761056;
%goto ID761056;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID761056;
%goto ID761056;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52,M2MI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID761056;
* Insert record into change management table for CHANGE_ID: ID761056;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID761056",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID761056;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
%let m_sql_statement = %str(
CREATE TABLE CAT_CUSTOM_ATTR_LIST_VALUE (
CAT_CUSTOM_ATTR_SK INTEGER NOT NULL,
ATTR_VALUE VARCHAR2(40) NOT NULL
)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
ALTER TABLE CATEGORY_PLAN ADD EVAL_OPT_RESULT_DTTM TIMESTAMP NULL
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE CALENDAR ADD EVAL_OPT_RESULT_DTTM TIMESTAMP NULL
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE CAT_CUSTOM_ATTR ADD HIDDEN_FLG INTEGER NULL
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE CAT_CUSTOM_ATTR ADD EDIT_FLG INTEGER NULL
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
 
proc sql;
 
 
CREATE TABLE CAT_CUSTOM_ATTR_LIST_VALUE (
CAT_CUSTOM_ATTR_SK INTEGER NOT NULL,
ATTR_VALUE VARCHAR(40) NOT NULL
);
 
 
 
ALTER TABLE CATEGORY_PLAN ADD EVAL_OPT_RESULT_DTTM DATE;
 
 
ALTER TABLE CALENDAR ADD EVAL_OPT_RESULT_DTTM DATE;
 
 
ALTER TABLE CAT_CUSTOM_ATTR ADD HIDDEN_FLG INTEGER ;
 
 
ALTER TABLE CAT_CUSTOM_ATTR ADD EDIT_FLG INTEGER ;
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID761056;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID761056;
%put ERROR- Description                              : Custom Attribute Extensions;
%put ERROR- Version                                  : D3MICM52,M2MI42;
%put ERROR- Date of Change                           : 19MAY2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID761056;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID761056",
"Custom Attribute Extensions",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID761056:;
 
 
* End of changes for CHANGE_ID:ID761056;
 
 
***********************************************************************************************;
*************************************  End Change ID761056 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID733774 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID733774;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID733774")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID733774;
%goto ID733774;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID733774;
* Insert record into change management table for CHANGE_ID: ID733774;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID733774",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID733774;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
CREATE TABLE NUM_GEO_PROD
(
PROD_HIER_SK                  INTEGER NOT NULL,
PROD_HIER_ASSOC_CD            INTEGER NOT NULL,
GEO_HIER_SK                   INTEGER NOT NULL,
GEO_HIER_ASSOC_CD             INTEGER NOT NULL,
USER_NM                       VARCHAR(40) NOT NULL,
PRIMARY KEY (PROD_HIER_SK, PROD_HIER_ASSOC_CD, GEO_HIER_SK, GEO_HIER_ASSOC_CD, USER_NM)
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%let m_sql_statement = %str(
CREATE TABLE COVERAGE_INPUT
(
PROD_HIER_SK                  INTEGER NOT NULL,
PROD_HIER_ASSOC_CD            INTEGER NOT NULL,
GEO_HIER_SK                   INTEGER NOT NULL,
GEO_HIER_ASSOC_CD             INTEGER NOT NULL,
USER_NM                       VARCHAR(40) NOT NULL,
PRIMARY KEY(PROD_HIER_SK, PROD_HIER_ASSOC_CD, GEO_HIER_SK, GEO_HIER_ASSOC_CD, USER_NM)
)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%let m_sql_statement = %str(
CREATE TABLE COVERAGE_OUTPUT
(
PROD_HIER_SK                  INTEGER NOT NULL,
PROD_HIER_ASSOC_CD            INTEGER NOT NULL,
GEO_HIER_SK                   INTEGER NOT NULL,
GEO_HIER_ASSOC_CD             INTEGER NOT NULL,
USER_NM                       VARCHAR(40) NOT NULL,
PRIMARY KEY(PROD_HIER_SK, PROD_HIER_ASSOC_CD, GEO_HIER_SK, GEO_HIER_ASSOC_CD, USER_NM)
)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
 
proc sql;
 
 
CREATE TABLE NUM_GEO_PROD
(
PROD_HIER_SK                  INTEGER NOT NULL,
PROD_HIER_ASSOC_CD            INTEGER NOT NULL,
GEO_HIER_SK                   INTEGER NOT NULL,
GEO_HIER_ASSOC_CD             INTEGER NOT NULL,
USER_NM                       VARCHAR(40) NOT NULL
);
 
 
ALTER TABLE NUM_GEO_PROD ADD CONSTRAINT PRIM_KEY PRIMARY KEY (PROD_HIER_SK, PROD_HIER_ASSOC_CD, GEO_HIER_SK, GEO_HIER_ASSOC_CD, USER_NM) ;
 
 
 
CREATE TABLE COVERAGE_INPUT
(
PROD_HIER_SK                  INTEGER NOT NULL,
PROD_HIER_ASSOC_CD            INTEGER NOT NULL,
GEO_HIER_SK                   INTEGER NOT NULL,
GEO_HIER_ASSOC_CD             INTEGER NOT NULL,
USER_NM                       VARCHAR(40) NOT NULL
);
 
 
ALTER TABLE COVERAGE_INPUT ADD CONSTRAINT PRIM_KEY PRIMARY KEY (PROD_HIER_SK, PROD_HIER_ASSOC_CD, GEO_HIER_SK, GEO_HIER_ASSOC_CD, USER_NM) ;
 
 
 
CREATE TABLE COVERAGE_OUTPUT
(
PROD_HIER_SK                  INTEGER NOT NULL,
PROD_HIER_ASSOC_CD            INTEGER NOT NULL,
GEO_HIER_SK                   INTEGER NOT NULL,
GEO_HIER_ASSOC_CD             INTEGER NOT NULL,
USER_NM                       VARCHAR(40) NOT NULL
);
 
 
ALTER TABLE COVERAGE_OUTPUT ADD CONSTRAINT PRIM_KEY PRIMARY KEY (PROD_HIER_SK, PROD_HIER_ASSOC_CD, GEO_HIER_SK, GEO_HIER_ASSOC_CD, USER_NM) ;
 
 
quit;
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID733774;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID733774;
%put ERROR- Description                              : New tables NUM_GEO_PROD, COVERAGE_INPUT, COVERAGE_OUTPUT;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 23MAY2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID733774;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID733774",
"New tables NUM_GEO_PROD, COVERAGE_INPUT, COVERAGE_OUTPUT",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID733774:;
 
 
* End of changes for CHANGE_ID:ID733774;
 
 
***********************************************************************************************;
*************************************  End Change ID733774 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID761590 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID761590;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID761590")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID761590;
%goto ID761590;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52,M2MI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID761590;
* Insert record into change management table for CHANGE_ID: ID761590;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID761590",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID761590;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
 
%let m_sql_statement = %str(
ALTER TABLE CATEGORY_PLAN ADD ACTION_RESULT_DTTM TIMESTAMP NULL
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE CATEGORY_PLAN ADD ACTION_CONTEXT_SK INTEGER
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE CATEGORY_PLAN ADD ACTION_NM VARCHAR(40) NULL
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE CATEGORY_PLAN ADD ACTION_PROCESS_CD INTEGER
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
ALTER TABLE CALENDAR ADD ACTION_RESULT_DTTM TIMESTAMP NULL
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE CALENDAR ADD ACTION_CONTEXT_SK INTEGER
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE CALENDAR ADD ACTION_NM VARCHAR(40) NULL
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE CALENDAR ADD ACTION_PROCESS_CD INTEGER
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
ALTER TABLE RPP_PLAN ADD ACTION_RESULT_DTTM TIMESTAMP NULL
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE RPP_PLAN ADD ACTION_CONTEXT_SK INTEGER
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE RPP_PLAN ADD ACTION_NM VARCHAR(40) NULL
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE RPP_PLAN ADD ACTION_PROCESS_CD INTEGER
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
 
proc sql;
 
 
ALTER TABLE CATEGORY_PLAN ADD ACTION_RESULT_DTTM DATE ;
 
 
ALTER TABLE CATEGORY_PLAN ADD ACTION_CONTEXT_SK INTEGER;
 
 
ALTER TABLE CATEGORY_PLAN ADD ACTION_NM VARCHAR(40) ;
 
 
ALTER TABLE CATEGORY_PLAN ADD ACTION_PROCESS_CD INTEGER;
 
 
 
ALTER TABLE CALENDAR ADD ACTION_RESULT_DTTM DATE ;
 
 
ALTER TABLE CALENDAR ADD ACTION_CONTEXT_SK INTEGER;
 
 
ALTER TABLE CALENDAR ADD ACTION_NM VARCHAR(40) ;
 
 
ALTER TABLE CALENDAR ADD ACTION_PROCESS_CD INTEGER;
 
 
 
ALTER TABLE RPP_PLAN ADD ACTION_RESULT_DTTM DATE ;
 
 
ALTER TABLE RPP_PLAN ADD ACTION_CONTEXT_SK INTEGER;
 
 
ALTER TABLE RPP_PLAN ADD ACTION_NM VARCHAR(40) ;
 
 
ALTER TABLE RPP_PLAN ADD ACTION_PROCESS_CD INTEGER;
 
 
quit;
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID761590;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID761590;
%put ERROR- Description                              : Added action support;
%put ERROR- Version                                  : D3MICM52,M2MI42;
%put ERROR- Date of Change                           : 23MAY2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID761590;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID761590",
"Added action support",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID761590:;
 
 
* End of changes for CHANGE_ID:ID761590;
 
 
***********************************************************************************************;
*************************************  End Change ID761590 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID757832_2 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID757832_2;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID757832_2")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID757832_2;
%goto ID757832_2;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52,M2TKMI43);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID757832_2;
* Insert record into change management table for CHANGE_ID: ID757832_2;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID757832_2",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID757832_2;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
ALTER TABLE MPLN_RESULT ADD NUM_MEMBERS INTEGER
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE MPLN_GEO_PROD_RESULT ADD NUM_MEMBERS INTEGER
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
ALTER TABLE MPLN_RESULT ADD NUM_MEMBERS INTEGER;
 
 
ALTER TABLE MPLN_GEO_PROD_RESULT ADD NUM_MEMBERS INTEGER;
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID757832_2;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID757832_2;
%put ERROR- Description                              : Move column num_members from table mpln_geo_prod_agg to mpln_result and mpln_geo_prod_result;
%put ERROR- Version                                  : D3MICM52,M2TKMI43;
%put ERROR- Date of Change                           : 25MAY2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID757832_2;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID757832_2",
"Move column num_members from table mpln_geo_prod_agg to mpln_result and mpln_geo_prod_result",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID757832_2:;
 
 
* End of changes for CHANGE_ID:ID757832_2;
 
 
***********************************************************************************************;
*************************************  End Change ID757832_2 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change PKO_BULK_PACK_SIZE ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: PKO_BULK_PACK_SIZE;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("PKO_BULK_PACK_SIZE")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : PKO_BULK_PACK_SIZE;
%goto PKO_BULK_PACK_SIZE;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : PKO_BULK_PACK_SIZE;
* Insert record into change management table for CHANGE_ID: PKO_BULK_PACK_SIZE;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"PKO_BULK_PACK_SIZE",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto PKO_BULK_PACK_SIZE;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
 
%if not (%sysfunc(exist(&m_di_trans..PKO_BULK_PACK_SIZE))) %then
%do;
 
 
 
%let m_sql_statement = %str(
CREATE TABLE PKO_BULK_PACK_SIZE
(
BULK_PACK_SIZE_SK                  INTEGER NOT NULL,
BUY_SK                             INTEGER,
DELIVERY_SK                        INTEGER,
BULKSIZE                           INTEGER NOT NULL,
INNER_PACK_HANDLE_COST             NUMERIC(20,3),
OUTER_PACK_HANDLE_COST             NUMERIC(20,3),
OPENING_COST                       NUMERIC(20,3),
PRIMARY KEY (BULK_PACK_SIZE_SK)
)
);
 
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1)
 
%let m_sql_statement = %str(
CREATE SEQUENCE SEQ_BULK_PACK_SIZE_SK START WITH 100000;
 
 
);
 
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%end;
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
 
%if not (%sysfunc(exist(&m_di_trans..PKO_BULK_PACK_SIZE))) %then
%do;
 
 
 
proc sql;
 
 
CREATE TABLE PKO_BULK_PACK_SIZE
(
BULK_PACK_SIZE_SK                  INTEGER NOT NULL,
BUY_SK                             INTEGER,
DELIVERY_SK                        INTEGER,
BULKSIZE                           INTEGER NOT NULL,
INNER_PACK_HANDLE_COST             NUMERIC(20,3),
OUTER_PACK_HANDLE_COST             NUMERIC(20,3),
OPENING_COST                       NUMERIC(20,3)
)
;
 
 
 
ALTER TABLE PKO_BULK_PACK_SIZE add CONSTRAINT PRIM_KEY PRIMARY KEY (BULK_PACK_SIZE_SK);
 
 
quit;
 
 
 
%end;
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: PKO_BULK_PACK_SIZE;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: PKO_BULK_PACK_SIZE;
%put ERROR- Description                              : Add Table PKO_BULK_PACK_SIZE;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 06NOV2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: PKO_BULK_PACK_SIZE;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"PKO_BULK_PACK_SIZE",
"Add Table PKO_BULK_PACK_SIZE",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%PKO_BULK_PACK_SIZE:;
 
 
* End of changes for CHANGE_ID:PKO_BULK_PACK_SIZE;
 
 
***********************************************************************************************;
*************************************  End Change PKO_BULK_PACK_SIZE ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ADD_PROCESS_NM ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ADD_PROCESS_NM;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ADD_PROCESS_NM")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ADD_PROCESS_NM;
%goto ADD_PROCESS_NM;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52,F1MI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ADD_PROCESS_NM;
* Insert record into change management table for CHANGE_ID: ADD_PROCESS_NM;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ADD_PROCESS_NM",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ADD_PROCESS_NM;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
 
%if (%di_util_varexist(dsname=&m_di_trans..REQ_CONTEXT, varname=PROCESS_NM)=0) %then
%do;
 
 
 
%let m_sql_statement = %str(
ALTER TABLE REQ_CONTEXT ADD PROCESS_NM VARCHAR(40)
);
 
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%end;
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
%if (%di_util_varexist(dsname=&m_di_trans..REQ_CONTEXT, varname=PROCESS_NM)=0) %then
%do;
 
 
proc sql;
 
 
ALTER TABLE REQ_CONTEXT ADD PROCESS_NM VARCHAR(40);
 
 
quit;
 
 
%end;
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ADD_PROCESS_NM;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ADD_PROCESS_NM;
%put ERROR- Description                              : Update schema changes for pack;
%put ERROR- Version                                  : D3MICM52,F1MI42;
%put ERROR- Date of Change                           : 26MAY2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ADD_PROCESS_NM;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ADD_PROCESS_NM",
"Update schema changes for pack",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ADD_PROCESS_NM:;
 
 
* End of changes for CHANGE_ID:ADD_PROCESS_NM;
 
 
***********************************************************************************************;
*************************************  End Change ADD_PROCESS_NM ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID762905 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID762905;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID762905")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID762905;
%goto ID762905;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID762905;
* Insert record into change management table for CHANGE_ID: ID762905;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID762905",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID762905;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
ALTER TABLE PKO_PURCHASE_ORDER_PLAN DROP COLUMN STYLECOLORS_IN_BUYS
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE PKO_PURCHASE_ORDER_PLAN DROP COLUMN STYLECOLORS_WITH_NEED
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE PKO_PURCHASE_ORDER_PLAN DROP COLUMN STORES_IN_DELIVERIES
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE PKO_PURCHASE_ORDER_PLAN DROP COLUMN STORES_WITH_NEED
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
CREATE TABLE PKO_PACK_PRODUCT_SETTING
(
PACK_PRODUCT_SETTING_SK            INTEGER NOT NULL,
PROD_HIER_SK                       INTEGER NOT NULL,
BUY_SK                             INTEGER,
DELIVERY_SK                        INTEGER,
NUM_PACK_REC_MAX                   INTEGER,
SIZE_OF_OUTER_MAX                  INTEGER,
BREAK_PACKS                        INTEGER,
REC_MULTICOLOR                     INTEGER,
OPEN_COST_PER_INNER                NUMERIC(20,3),
OUTER_HANDLE_DSCT_RATE             NUMERIC(12,4),
PRIMARY KEY (PACK_PRODUCT_SETTING_SK)
)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
CREATE SEQUENCE SEQ_PACK_PRODUCT_SETTING_SK START WITH 100000
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
ALTER TABLE PKO_DELIVERY ADD REC_MULTICOLOR INTEGER
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
ALTER TABLE PKO_PACKREC_INNER ADD PACK_PRODUCT_SETTING_SK INTEGER
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE PKO_BULK_PACK_SIZE ADD PACK_PRODUCT_SETTING_SK INTEGER
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE PKO_LIMIT_PACK ADD PACK_PRODUCT_SETTING_SK INTEGER
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
CREATE TABLE PKO_DELIVERY_PRODUCT
(
DELIVERY_PRODUCT_SK                INTEGER NOT NULL,
DELIVERY_SK                        INTEGER NOT NULL,
PROD_HIER_SK                       INTEGER NOT NULL,
PRIMARY KEY (DELIVERY_PRODUCT_SK)
)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
CREATE SEQUENCE SEQ_DELIVERY_PRODUCT_SK START WITH 100000
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
CREATE TABLE PKO_DELIVERY_STYLECOLOR
(
DELIVERY_STYLECOLOR_SK             INTEGER NOT NULL,
DELIVERY_SK                        INTEGER NOT NULL,
PROD_HIER_SK                       INTEGER NOT NULL,
PROD_ID                            VARCHAR(32) NOT NULL,
PRIMARY KEY (DELIVERY_STYLECOLOR_SK)
)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
CREATE SEQUENCE SEQ_DELIVERY_STYLECOLOR_SK START WITH 100000
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
 
proc sql;
 
 
ALTER TABLE PKO_PURCHASE_ORDER_PLAN DROP COLUMN STYLECOLORS_IN_BUYS;
 
 
ALTER TABLE PKO_PURCHASE_ORDER_PLAN DROP COLUMN STYLECOLORS_WITH_NEED;
 
 
ALTER TABLE PKO_PURCHASE_ORDER_PLAN DROP COLUMN STORES_IN_DELIVERIES;
 
 
ALTER TABLE PKO_PURCHASE_ORDER_PLAN DROP COLUMN STORES_WITH_NEED;
 
 
 
CREATE TABLE PKO_PACK_PRODUCT_SETTING
(
PACK_PRODUCT_SETTING_SK            INTEGER NOT NULL,
PROD_HIER_SK                       INTEGER NOT NULL,
BUY_SK                             INTEGER,
DELIVERY_SK                        INTEGER,
NUM_PACK_REC_MAX                   INTEGER,
SIZE_OF_OUTER_MAX                  INTEGER,
BREAK_PACKS                        INTEGER,
REC_MULTICOLOR                     INTEGER,
OPEN_COST_PER_INNER                NUMERIC(20,3),
OUTER_HANDLE_DSCT_RATE             NUMERIC(12,4)
) ;
 
 
 
ALTER TABLE PKO_PACK_PRODUCT_SETTING add CONSTRAINT PRIM_KEY PRIMARY KEY (PACK_PRODUCT_SETTING_SK);
 
 
 
ALTER TABLE PKO_DELIVERY ADD REC_MULTICOLOR INTEGER ;
 
 
 
ALTER TABLE PKO_PACKREC_INNER ADD PACK_PRODUCT_SETTING_SK INTEGER ;
 
 
ALTER TABLE PKO_BULK_PACK_SIZE ADD PACK_PRODUCT_SETTING_SK INTEGER ;
 
 
ALTER TABLE PKO_LIMIT_PACK ADD PACK_PRODUCT_SETTING_SK INTEGER ;
 
 
 
CREATE TABLE PKO_DELIVERY_PRODUCT
(
DELIVERY_PRODUCT_SK                INTEGER NOT NULL,
DELIVERY_SK                        INTEGER NOT NULL,
PROD_HIER_SK                       INTEGER NOT NULL
);
 
 
 
ALTER TABLE PKO_DELIVERY_PRODUCT add CONSTRAINT PRIM_KEY PRIMARY KEY (DELIVERY_PRODUCT_SK);
 
 
 
 
CREATE TABLE PKO_DELIVERY_STYLECOLOR
(
DELIVERY_STYLECOLOR_SK             INTEGER NOT NULL,
DELIVERY_SK                        INTEGER NOT NULL,
PROD_HIER_SK                       INTEGER NOT NULL,
PROD_ID                            VARCHAR(32) NOT NULL
);
 
 
 
ALTER TABLE PKO_DELIVERY_STYLECOLOR add CONSTRAINT PRIM_KEY PRIMARY KEY (DELIVERY_STYLECOLOR_SK);
 
 
quit;
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID762905;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID762905;
%put ERROR- Description                              : Update schema changes for pack;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 26MAY2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID762905;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID762905",
"Update schema changes for pack",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID762905:;
 
 
* End of changes for CHANGE_ID:ID762905;
 
 
***********************************************************************************************;
*************************************  End Change ID762905 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID762925 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID762925;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID762925")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_trans..MODEL_SPEC_DEFAULT))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_trans..MODEL_SPEC_DEFAULT;
%put NOTE: Change ID                             :ID762925;
%goto ID762925;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID762925;
%goto ID762925;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID762925;
* Insert record into change management table for CHANGE_ID: ID762925;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID762925",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID762925;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
DELETE FROM MODEL_SPEC_DEFAULT WHERE MODEL_COMP_NM = 'FA' AND SPEC_NM = 'MAPE_WEIGHT'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
DELETE FROM MODEL_SPEC_DEFAULT WHERE MODEL_COMP_NM = 'FA' AND SPEC_NM = 'MAPE_WEIGHT';
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID762925;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID762925;
%put ERROR- Description                              : Remove MAPE_WEIGHT as FA spec;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 26MAY2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID762925;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID762925",
"Remove MAPE_WEIGHT as FA spec",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID762925:;
 
 
* End of changes for CHANGE_ID:ID762925;
 
 
***********************************************************************************************;
*************************************  End Change ID762925 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID761781 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID761781;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID761781")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_trans..PROFILING_PROJECT))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_trans..PROFILING_PROJECT;
%put NOTE: Change ID                             :ID761781;
%goto ID761781;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID761781;
%goto ID761781;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID761781;
* Insert record into change management table for CHANGE_ID: ID761781;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID761781",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID761781;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
%let m_sql_statement = %str(
ALTER TABLE PROFILING_PROJECT ADD OUT_OF_DATE_FLG INTEGER DEFAULT 0 NOT NULL
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
 
data &m_di_trans..PROFILING_PROJECT;
 
 
set &m_di_trans..PROFILING_PROJECT;
 
 
ATTRIB OUT_OF_DATE_FLG LENGTH=4;
 
 
 
OUT_OF_DATE_FLG=0;
 
 
RUN;
 
 
 
proc sql;
 
 
ALTER TABLE PROFILING_PROJECT  add CONSTRAINT PRIM_KEY  PRIMARY KEY (PROFILING_PROJECT_SK);
 
 
quit;
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID761781;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID761781;
%put ERROR- Description                              : Add out_of_date_flg to PROFILING_PROJECT table;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 26MAY2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID761781;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID761781",
"Add out_of_date_flg to PROFILING_PROJECT table",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID761781:;
 
 
* End of changes for CHANGE_ID:ID761781;
 
 
***********************************************************************************************;
*************************************  End Change ID761781 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID762209 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID762209;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID762209")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID762209;
%goto ID762209;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID762209;
* Insert record into change management table for CHANGE_ID: ID762209;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID762209",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID762209;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
ALTER TABLE ALERT_COST ADD RPO_PLAN_SK INTEGER
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE ALERT_COST ADD RPO_PLAN_MEMBER_SK INTEGER
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
ALTER TABLE ALERT_COMP ADD RPO_PLAN_SK INTEGER
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE ALERT_COMP ADD RPO_PLAN_MEMBER_SK INTEGER
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%let m_sql_statement = %str(
ALTER TABLE RPO_PLAN ADD PROCESS_RUN_DTTM DATE
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE RPO_PLAN ADD PROCESS_OPTION INTEGER DEFAULT 1 NOT NULL
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE RPO_PLAN ADD RPO_PLAN_TYPE INTEGER DEFAULT 1 NOT NULL
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
 
proc sql;
 
 
ALTER TABLE ALERT_COST ADD RPO_PLAN_SK INTEGER;
 
 
ALTER TABLE ALERT_COST ADD RPO_PLAN_MEMBER_SK INTEGER;
 
 
 
ALTER TABLE ALERT_COMP ADD RPO_PLAN_SK INTEGER;
 
 
ALTER TABLE ALERT_COMP ADD RPO_PLAN_MEMBER_SK INTEGER;
 
 
 
 
ALTER TABLE RPO_PLAN ADD PROCESS_RUN_DTTM DATE;
 
 
quit;
 
 
 
data &m_di_trans..RPO_PLAN;
 
 
set &m_di_trans..RPO_PLAN;
 
 
ATTRIB PROCESS_OPTION LENGTH=4;
 
 
ATTRIB RPO_PLAN_TYPE LENGTH=4;
 
 
 
PROCESS_OPTION=1;
 
 
RPO_PLAN_TYPE=1;
 
 
RUN;
 
 
 
proc sql;
 
 
alter table &m_di_trans..RPO_PLAN add NOT NULL (PROCESS_OPTION);
 
 
alter table &m_di_trans..RPO_PLAN add NOT NULL (RPO_PLAN_TYPE);
 
 
quit;
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID762209;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID762209;
%put ERROR- Description                              : Recommending prices for products with alerts;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 23MAY2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID762209;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID762209",
"Recommending prices for products with alerts",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID762209:;
 
 
* End of changes for CHANGE_ID:ID762209;
 
 
***********************************************************************************************;
*************************************  End Change ID762209 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID733892 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID733892;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID733892")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(&m_di_trans.)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_di_trans.;
%put NOTE: Change ID                             :ID733892;
%goto ID733892;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID733892;
%goto ID733892;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID733892;
* Insert record into change management table for CHANGE_ID: ID733892;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID733892",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID733892;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
CREATE TABLE FA_SCORING_RULE (
FA_SCORING_RULE_SK       INTEGER NOT NULL,
WEIGHT                   NUMERIC(12,4),
MEASURE                  VARCHAR(40)
)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE FA_SCORING_RULE ADD CONSTRAINT FA_SCORING_RULE_PK PRIMARY KEY (FA_SCORING_RULE_SK)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
CREATE TABLE FA_SCORING_RANGE_RULE (
FA_SCORING_RANGE_RULE_SK   INTEGER NOT NULL,
FA_SCORING_RULE_SK       INTEGER NOT NULL,
RANGE_START_VALUE        NUMERIC(12,4),
RANGE_END_VALUE          NUMERIC(12,4),
VALUE                    NUMERIC(12,4)
)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE FA_SCORING_RANGE_RULE ADD CONSTRAINT FA_SCORING_RANGE_RULE_PK PRIMARY KEY (FA_SCORING_RANGE_RULE_SK)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
CREATE TABLE FA_SCORING_RULE (
FA_SCORING_RULE_SK       INTEGER NOT NULL,
WEIGHT                   NUMERIC(12,4),
MEASURE                  VARCHAR(40)
);
 
 
ALTER TABLE FA_SCORING_RULE ADD CONSTRAINT FA_SCORING_RULE_PK PRIMARY KEY (FA_SCORING_RULE_SK);
 
 
 
CREATE TABLE FA_SCORING_RANGE_RULE (
FA_SCORING_RANGE_RULE_SK   INTEGER NOT NULL,
FA_SCORING_RULE_SK       INTEGER NOT NULL,
RANGE_START_VALUE        NUMERIC(12,4),
RANGE_END_VALUE          NUMERIC(12,4),
VALUE                    NUMERIC(12,4)
);
 
 
ALTER TABLE FA_SCORING_RANGE_RULE ADD CONSTRAINT FA_SCORING_RANGE_RULE_PK PRIMARY KEY (FA_SCORING_RANGE_RULE_SK);
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID733892;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID733892;
%put ERROR- Description                              : New tables FA_SCORING_RULE and FA_SCORING_RANGE_RULE for FA;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 02JUN2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID733892;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID733892",
"New tables FA_SCORING_RULE and FA_SCORING_RANGE_RULE for FA",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID733892:;
 
 
* End of changes for CHANGE_ID:ID733892;
 
 
***********************************************************************************************;
*************************************  End Change ID733892 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID739353 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID739353;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID739353")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_trans..MODEL_SPEC_DEFAULT))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_trans..MODEL_SPEC_DEFAULT;
%put NOTE: Change ID                             :ID739353;
%goto ID739353;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID739353;
%goto ID739353;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID739353;
* Insert record into change management table for CHANGE_ID: ID739353;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID739353",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID739353;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
DELETE FROM MODEL_SPEC_DEFAULT WHERE SPEC_NM = 'DOW_PROFILE'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('DOW_PROFILE','DOW','-1','1',NULL)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
DELETE FROM MODEL_SPEC_DEFAULT WHERE SPEC_NM = 'DAILY_FCST_METHOD'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('DAILY_FCST_METHOD','DOW','-1','1',NULL)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
DELETE FROM MODEL_SPEC_DEFAULT WHERE SPEC_NM = 'DOW_PROFILE';
 
 
INSERT INTO MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('DOW_PROFILE','DOW','-1','1',NULL);
 
 
 
DELETE FROM MODEL_SPEC_DEFAULT WHERE SPEC_NM = 'DAILY_FCST_METHOD';
 
 
INSERT INTO MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('DAILY_FCST_METHOD','DOW','-1','1',NULL);
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID739353;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID739353;
%put ERROR- Description                              : Add DOW specs DOW_PROFILE and DAILY_FCST_METHOD;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 05JUN2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID739353;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID739353",
"Add DOW specs DOW_PROFILE and DAILY_FCST_METHOD",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID739353:;
 
 
* End of changes for CHANGE_ID:ID739353;
 
 
***********************************************************************************************;
*************************************  End Change ID739353 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID765135 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID765135;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID765135")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_trans..MODEL_SPEC_DEFAULT))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_trans..MODEL_SPEC_DEFAULT;
%put NOTE: Change ID                             :ID765135;
%goto ID765135;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID765135;
%goto ID765135;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID765135;
* Insert record into change management table for CHANGE_ID: ID765135;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID765135",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID765135;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
UPDATE MODEL_SPEC_DEFAULT SET DEFAULT_SPEC_VALUE = '' WHERE SPEC_NM = 'HOLDOUT_DETAILS_TABLES'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
UPDATE MODEL_SPEC_DEFAULT SET DEFAULT_SPEC_VALUE = '' WHERE SPEC_NM = 'HOLDOUT_DETAILS_TABLES';
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID765135;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID765135;
%put ERROR- Description                              : Change default value for FA spec HOLDOUT_DETAILS_TABLES;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 06JUN2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID765135;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID765135",
"Change default value for FA spec HOLDOUT_DETAILS_TABLES",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID765135:;
 
 
* End of changes for CHANGE_ID:ID765135;
 
 
***********************************************************************************************;
*************************************  End Change ID765135 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID762768 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID762768;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID762768")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID762768;
%goto ID762768;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID762768;
* Insert record into change management table for CHANGE_ID: ID762768;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID762768",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID762768;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
DELETE FROM FA_SCENARIO_STATUS
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
DELETE FROM FA_SCORE
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
ALTER TABLE FA_SCENARIO_STATUS MODIFY MEDIAN_PE NUMERIC(12,4)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE FA_SCENARIO_STATUS MODIFY ELASTICITY_TAIL NUMERIC(12,4)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE FA_SCENARIO_STATUS MODIFY PCT_ELASTICITY_DEFAULTED NUMERIC(12,4)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE FA_SCENARIO_STATUS MODIFY MEDIAN_PE_FIT NUMERIC(12,4)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE FA_SCENARIO_STATUS MODIFY MAX_HD_RMSE_FIT NUMERIC(12,4)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE FA_SCENARIO_STATUS MODIFY SCORE NUMERIC(12,4)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
ALTER TABLE FA_SCENARIO_STATUS DROP COLUMN WEIGHTED_MAPE
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE FA_SCENARIO_STATUS DROP COLUMN WEIGHTED_MEAN_PE
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE FA_SCENARIO_STATUS DROP COLUMN WEIGHTED_MAPE_FIT
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE FA_SCENARIO_STATUS DROP COLUMN WEIGHTED_MEAN_PE_FIT
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
ALTER TABLE FA_SCENARIO_STATUS ADD
(
INV_WEIGHTED_MAPE NUMERIC(12,4),
INV_WEIGHTED_MEAN_PE NUMERIC(12,4),
SALES_WEIGHTED_MAPE NUMERIC(12,4),
SALES_WEIGHTED_MEAN_PE NUMERIC(12,4),
REVENUE_WEIGHTED_MAPE NUMERIC(12,4),
REVENUE_WEIGHTED_MEAN_PE NUMERIC(12,4),
INV_WEIGHTED_MAPE_FIT NUMERIC(12,4),
INV_WEIGHTED_MEAN_PE_FIT NUMERIC(12,4),
SALES_WEIGHTED_MAPE_FIT NUMERIC(12,4),
SALES_WEIGHTED_MEAN_PE_FIT NUMERIC(12,4),
REVENUE_WEIGHTED_MAPE_FIT NUMERIC(12,4),
REVENUE_WEIGHTED_MEAN_PE_FIT NUMERIC(12,4)
)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
ALTER TABLE FA_SCORE MODIFY MEDIAN_PE NUMERIC(12,4)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE FA_SCORE MODIFY ELASTICITY_TAIL NUMERIC(12,4)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE FA_SCORE MODIFY PCT_ELASTICITY_DEFAULTED NUMERIC(12,4)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE FA_SCORE MODIFY MEDIAN_PE_FIT NUMERIC(12,4)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE FA_SCORE MODIFY MAX_HD_RMSE_FIT NUMERIC(12,4)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE FA_SCORE MODIFY SCORE NUMERIC(12,4)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
ALTER TABLE FA_SCORE DROP COLUMN WEIGHTED_MAPE
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE FA_SCORE DROP COLUMN WEIGHTED_MEAN_PE
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE FA_SCORE DROP COLUMN WEIGHTED_MAPE_FIT
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE FA_SCORE DROP COLUMN WEIGHTED_MEAN_PE_FIT
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
ALTER TABLE FA_SCORE ADD
(
INV_WEIGHTED_MAPE NUMERIC(12,4),
INV_WEIGHTED_MEAN_PE NUMERIC(12,4),
SALES_WEIGHTED_MAPE NUMERIC(12,4),
SALES_WEIGHTED_MEAN_PE NUMERIC(12,4),
REVENUE_WEIGHTED_MAPE NUMERIC(12,4),
REVENUE_WEIGHTED_MEAN_PE NUMERIC(12,4),
INV_WEIGHTED_MAPE_FIT NUMERIC(12,4),
INV_WEIGHTED_MEAN_PE_FIT NUMERIC(12,4),
SALES_WEIGHTED_MAPE_FIT NUMERIC(12,4),
SALES_WEIGHTED_MEAN_PE_FIT NUMERIC(12,4),
REVENUE_WEIGHTED_MAPE_FIT NUMERIC(12,4),
REVENUE_WEIGHTED_MEAN_PE_FIT NUMERIC(12,4)
)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
 
proc sql;
 
 
DELETE FROM FA_SCENARIO_STATUS;
 
 
DELETE FROM FA_SCORE;
 
 
 
ALTER TABLE FA_SCENARIO_STATUS MODIFY MEDIAN_PE NUMERIC(12,4);
 
 
ALTER TABLE FA_SCENARIO_STATUS MODIFY ELASTICITY_TAIL NUMERIC(12,4);
 
 
ALTER TABLE FA_SCENARIO_STATUS MODIFY PCT_ELASTICITY_DEFAULTED NUMERIC(12,4);
 
 
ALTER TABLE FA_SCENARIO_STATUS MODIFY MEDIAN_PE_FIT NUMERIC(12,4);
 
 
ALTER TABLE FA_SCENARIO_STATUS MODIFY MAX_HD_RMSE_FIT NUMERIC(12,4);
 
 
ALTER TABLE FA_SCENARIO_STATUS MODIFY SCORE NUMERIC(12,4);
 
 
 
ALTER TABLE FA_SCENARIO_STATUS DROP COLUMN WEIGHTED_MAPE;
 
 
ALTER TABLE FA_SCENARIO_STATUS DROP COLUMN WEIGHTED_MEAN_PE;
 
 
ALTER TABLE FA_SCENARIO_STATUS DROP COLUMN WEIGHTED_MAPE_FIT;
 
 
ALTER TABLE FA_SCENARIO_STATUS DROP COLUMN WEIGHTED_MEAN_PE_FIT;
 
 
 
ALTER TABLE FA_SCENARIO_STATUS ADD INV_WEIGHTED_MAPE NUMERIC(12,4);
 
 
ALTER TABLE FA_SCENARIO_STATUS ADD INV_WEIGHTED_MEAN_PE NUMERIC(12,4);
 
 
ALTER TABLE FA_SCENARIO_STATUS ADD SALES_WEIGHTED_MAPE NUMERIC(12,4);
 
 
ALTER TABLE FA_SCENARIO_STATUS ADD SALES_WEIGHTED_MEAN_PE NUMERIC(12,4);
 
 
ALTER TABLE FA_SCENARIO_STATUS ADD REVENUE_WEIGHTED_MAPE NUMERIC(12,4);
 
 
ALTER TABLE FA_SCENARIO_STATUS ADD REVENUE_WEIGHTED_MEAN_PE NUMERIC(12,4);
 
 
ALTER TABLE FA_SCENARIO_STATUS ADD INV_WEIGHTED_MAPE_FIT NUMERIC(12,4);
 
 
ALTER TABLE FA_SCENARIO_STATUS ADD INV_WEIGHTED_MEAN_PE_FIT NUMERIC(12,4);
 
 
ALTER TABLE FA_SCENARIO_STATUS ADD SALES_WEIGHTED_MAPE_FIT NUMERIC(12,4);
 
 
ALTER TABLE FA_SCENARIO_STATUS ADD SALES_WEIGHTED_MEAN_PE_FIT NUMERIC(12,4);
 
 
ALTER TABLE FA_SCENARIO_STATUS ADD REVENUE_WEIGHTED_MAPE_FIT NUMERIC(12,4);
 
 
ALTER TABLE FA_SCENARIO_STATUS ADD REVENUE_WEIGHTED_MEAN_PE_FIT NUMERIC(12,4);
 
 
 
ALTER TABLE FA_SCORE MODIFY MEDIAN_PE NUMERIC(12,4);
 
 
ALTER TABLE FA_SCORE MODIFY ELASTICITY_TAIL NUMERIC(12,4);
 
 
ALTER TABLE FA_SCORE MODIFY PCT_ELASTICITY_DEFAULTED NUMERIC(12,4);
 
 
ALTER TABLE FA_SCORE MODIFY MEDIAN_PE_FIT NUMERIC(12,4);
 
 
ALTER TABLE FA_SCORE MODIFY MAX_HD_RMSE_FIT NUMERIC(12,4);
 
 
ALTER TABLE FA_SCORE MODIFY SCORE NUMERIC(12,4);
 
 
 
ALTER TABLE FA_SCORE DROP COLUMN WEIGHTED_MAPE;
 
 
ALTER TABLE FA_SCORE DROP COLUMN WEIGHTED_MEAN_PE;
 
 
ALTER TABLE FA_SCORE DROP COLUMN WEIGHTED_MAPE_FIT;
 
 
ALTER TABLE FA_SCORE DROP COLUMN WEIGHTED_MEAN_PE_FIT;
 
 
 
ALTER TABLE FA_SCORE ADD INV_WEIGHTED_MAPE NUMERIC(12,4);
 
 
ALTER TABLE FA_SCORE ADD INV_WEIGHTED_MEAN_PE NUMERIC(12,4);
 
 
ALTER TABLE FA_SCORE ADD SALES_WEIGHTED_MAPE NUMERIC(12,4);
 
 
ALTER TABLE FA_SCORE ADD SALES_WEIGHTED_MEAN_PE NUMERIC(12,4);
 
 
ALTER TABLE FA_SCORE ADD REVENUE_WEIGHTED_MAPE NUMERIC(12,4);
 
 
ALTER TABLE FA_SCORE ADD REVENUE_WEIGHTED_MEAN_PE NUMERIC(12,4);
 
 
ALTER TABLE FA_SCORE ADD INV_WEIGHTED_MAPE_FIT NUMERIC(12,4);
 
 
ALTER TABLE FA_SCORE ADD INV_WEIGHTED_MEAN_PE_FIT NUMERIC(12,4);
 
 
ALTER TABLE FA_SCORE ADD SALES_WEIGHTED_MAPE_FIT NUMERIC(12,4);
 
 
ALTER TABLE FA_SCORE ADD SALES_WEIGHTED_MEAN_PE_FIT NUMERIC(12,4);
 
 
ALTER TABLE FA_SCORE ADD REVENUE_WEIGHTED_MAPE_FIT NUMERIC(12,4);
 
 
ALTER TABLE FA_SCORE ADD REVENUE_WEIGHTED_MEAN_PE_FIT NUMERIC(12,4);
 
 
 
quit;
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID762768;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID762768;
%put ERROR- Description                              : Output weighted measurements in scenario_status table for all three candidate weights;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 06JUN2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID762768;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID762768",
"Output weighted measurements in scenario_status table for all three candidate weights",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID762768:;
 
 
* End of changes for CHANGE_ID:ID762768;
 
 
***********************************************************************************************;
*************************************  End Change ID762768 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID733774_1 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID733774_1;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID733774_1")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID733774_1;
%goto ID733774_1;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID733774_1;
* Insert record into change management table for CHANGE_ID: ID733774_1;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID733774_1",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID733774_1;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
ALTER TABLE NUM_GEO_PROD ADD NUM_GEO_PRODS INTEGER
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
ALTER TABLE NUM_GEO_PROD ADD NUM_GEO_PRODS INTEGER;
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID733774_1;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID733774_1;
%put ERROR- Description                              : Fix table NUM_GEO_PROD;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 23MAY2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID733774_1;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID733774_1",
"Fix table NUM_GEO_PROD",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID733774_1:;
 
 
* End of changes for CHANGE_ID:ID733774_1;
 
 
***********************************************************************************************;
*************************************  End Change ID733774_1 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID765897 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID765897;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID765897")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID765897;
%goto ID765897;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52,M2MI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID765897;
* Insert record into change management table for CHANGE_ID: ID765897;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID765897",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID765897;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
update VEHICLE_CATEGORY set VEHICLE_CATEGORY_NM='Miles', VEHICLE_CATEGORY_DESC='Buy N1 of P1 [ and N2 of P2 ] and get M Miles' where VEHICLE_CATEGORY_SK = 51
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
update VEHICLE_CATEGORY set VEHICLE_CATEGORY_NM='MilesHigh', VEHICLE_CATEGORY_DESC='Buy N1 of P1 [ and N2 of P2 ] and get M Miles' where VEHICLE_CATEGORY_SK = 52
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into VEHICLE_CATEGORY (VEHICLE_CATEGORY_SK, VEHICLE_CATEGORY_NM, VEHICLE_CATEGORY_DESC, VEHICLE_CATEGORY_TYPE, ACTIVE_FLG, PRICE_FLG)
values (53, 'Points', 'Buy N1 of P1 [ and N2 of P2 ] and get P Points', 'PRICE', 1, 1)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into VEHICLE_CATEGORY (VEHICLE_CATEGORY_SK, VEHICLE_CATEGORY_NM, VEHICLE_CATEGORY_DESC, VEHICLE_CATEGORY_TYPE, ACTIVE_FLG, PRICE_FLG)
values (54, 'PointsHigh', 'Buy N1 of P1 [ and N2 of P2 ] and get P Points', 'PRICE', 1, 1)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
update VEHICLE set VEHICLE_CATEGORY_SK = 53 where VEHICLE_SK in (select VEHICLE_SK
from VEHICLE, CUSTOM_ATTR
where VEHICLE_CATEGORY_SK=51
and VEHICLE_SK=OBJECT_SK
and CAT_CUSTOM_ATTR_SK=-110
and ATTR_VALUE = '2')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
update VEHICLE set VEHICLE_CATEGORY_SK = 54 where VEHICLE_SK in (select VEHICLE_SK
from VEHICLE, CUSTOM_ATTR
where VEHICLE_CATEGORY_SK=52
and VEHICLE_SK=OBJECT_SK
and CAT_CUSTOM_ATTR_SK=-117
and ATTR_VALUE = '2')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
delete from CAT_CUSTOM_ATTR where CAT_CUSTOM_ATTR_SK in (-110, -117)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from CUSTOM_ATTR where CAT_CUSTOM_ATTR_SK in (-110, -117)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
update CUSTOM_ATTR
set CAT_CUSTOM_ATTR_SK = CAT_CUSTOM_ATTR_SK - 21
where CAT_CUSTOM_ATTR_SK <= -104 and CAT_CUSTOM_ATTR_SK >= -109
and OBJECT_SK in (select VEHICLE_SK from VEHICLE where VEHICLE_CATEGORY_SK = 53)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
update CUSTOM_ATTR
set CAT_CUSTOM_ATTR_SK = CAT_CUSTOM_ATTR_SK - 20
where CAT_CUSTOM_ATTR_SK <= -111 and CAT_CUSTOM_ATTR_SK >= -116
and OBJECT_SK in (select VEHICLE_SK from VEHICLE where VEHICLE_CATEGORY_SK = 54)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-125, 53, 7,'BuyCount1',          '', 2)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-126, 53, 7,'BuyAmount1',         '', 2)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-127, 53, 7,'BuyCount2',          '', 2)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-128, 53, 7,'BuyAmount2',         '', 2)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-129, 53, 7,'GetCount',           '', 2)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-130, 53, 7,'GetValue',           '', 2)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-131, 54, 7,'BuyCount1',          '', 2)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-132, 54, 7,'BuyAmount1',         '', 2)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-133, 54, 7,'BuyCount2',          '', 2)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-134, 54, 7,'BuyAmount2',         '', 2)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-135, 54, 7,'GetCount',           '', 2)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-136, 54, 7,'GetValue',           '', 2)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
 
proc sql;
 
 
 
update VEHICLE_CATEGORY set VEHICLE_CATEGORY_NM='Miles', VEHICLE_CATEGORY_DESC='Buy N1 of P1 [ and N2 of P2 ] and get M Miles' where VEHICLE_CATEGORY_SK = 51;
 
 
update VEHICLE_CATEGORY set VEHICLE_CATEGORY_NM='MilesHigh', VEHICLE_CATEGORY_DESC='Buy N1 of P1 [ and N2 of P2 ] and get M Miles' where VEHICLE_CATEGORY_SK = 52;
 
 
insert into VEHICLE_CATEGORY (VEHICLE_CATEGORY_SK, VEHICLE_CATEGORY_NM, VEHICLE_CATEGORY_DESC, VEHICLE_CATEGORY_TYPE, ACTIVE_FLG, PRICE_FLG)
values (53, 'Points', 'Buy N1 of P1 [ and N2 of P2 ] and get P Points', 'PRICE', 1, 1);
 
 
insert into VEHICLE_CATEGORY (VEHICLE_CATEGORY_SK, VEHICLE_CATEGORY_NM, VEHICLE_CATEGORY_DESC, VEHICLE_CATEGORY_TYPE, ACTIVE_FLG, PRICE_FLG)
values (54, 'PointsHigh', 'Buy N1 of P1 [ and N2 of P2 ] and get P Points', 'PRICE', 1, 1);
 
 
 
create table WORK.VEHICLE2 as select * from VEHICLE;
 
 
 
update VEHICLE set VEHICLE_CATEGORY_SK = 53 where VEHICLE_SK in (select VEHICLE_SK
from WORK.VEHICLE2, CUSTOM_ATTR
where VEHICLE_CATEGORY_SK=51
and VEHICLE_SK=OBJECT_SK
and CAT_CUSTOM_ATTR_SK=-110
and ATTR_VALUE = '2');
 
 
 
update VEHICLE set VEHICLE_CATEGORY_SK = 54 where VEHICLE_SK in (select VEHICLE_SK
from WORK.VEHICLE2, CUSTOM_ATTR
where VEHICLE_CATEGORY_SK=52
and VEHICLE_SK=OBJECT_SK
and CAT_CUSTOM_ATTR_SK=-117
and ATTR_VALUE = '2');
 
 
 
delete from CAT_CUSTOM_ATTR where CAT_CUSTOM_ATTR_SK in (-110, -117);
 
 
delete from CUSTOM_ATTR where CAT_CUSTOM_ATTR_SK in (-110, -117);
 
 
 
update CUSTOM_ATTR
set CAT_CUSTOM_ATTR_SK = CAT_CUSTOM_ATTR_SK - 21
where CAT_CUSTOM_ATTR_SK <= -104 and CAT_CUSTOM_ATTR_SK >= -109
and OBJECT_SK in (select VEHICLE_SK from VEHICLE where VEHICLE_CATEGORY_SK = 53);
 
 
 
update CUSTOM_ATTR
set CAT_CUSTOM_ATTR_SK = CAT_CUSTOM_ATTR_SK - 20
where CAT_CUSTOM_ATTR_SK <= -111 and CAT_CUSTOM_ATTR_SK >= -116
and OBJECT_SK in (select VEHICLE_SK from VEHICLE where VEHICLE_CATEGORY_SK = 54);
 
 
 
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-125, 53, 7,'BuyCount1',          '', 2);
 
 
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-126, 53, 7,'BuyAmount1',         '', 2);
 
 
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-127, 53, 7,'BuyCount2',          '', 2);
 
 
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-128, 53, 7,'BuyAmount2',         '', 2);
 
 
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-129, 53, 7,'GetCount',           '', 2);
 
 
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-130, 53, 7,'GetValue',           '', 2);
 
 
 
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-131, 54, 7,'BuyCount1',          '', 2);
 
 
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-132, 54, 7,'BuyAmount1',         '', 2);
 
 
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-133, 54, 7,'BuyCount2',          '', 2);
 
 
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-134, 54, 7,'BuyAmount2',         '', 2);
 
 
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-135, 54, 7,'GetCount',           '', 2);
 
 
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-136, 54, 7,'GetValue',           '', 2);
 
 
 
quit;
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID765897;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID765897;
%put ERROR- Description                              : Separate MilesPoints into two price types;
%put ERROR- Version                                  : D3MICM52,M2MI42;
%put ERROR- Date of Change                           : 08JUN2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID765897;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID765897",
"Separate MilesPoints into two price types",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID765897:;
 
 
* End of changes for CHANGE_ID:ID765897;
 
 
***********************************************************************************************;
*************************************  End Change ID765897 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID761590_2 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID761590_2;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID761590_2")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID761590_2;
%goto ID761590_2;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52, M2MI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID761590_2;
* Insert record into change management table for CHANGE_ID: ID761590_2;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID761590_2",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID761590_2;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
 
%let m_sql_statement = %str(
CREATE TABLE RPP_PLAN_COST_FACT
(
PLAN_SK INTEGER NOT NULL,
PROD_HIER_SK INTEGER NOT NULL,
GEO_HIER_SK INTEGER NOT NULL,
COST NUMERIC(12,2) NOT NULL
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%let m_sql_statement = %str(
CREATE INDEX RPP_PLAN_COST_FACT_IX1 ON RPP_PLAN_COST_FACT
(
PLAN_SK
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
 
proc sql;
 
 
 
CREATE TABLE RPP_PLAN_COST_FACT
(
PLAN_SK INTEGER NOT NULL,
PROD_HIER_SK INTEGER NOT NULL,
GEO_HIER_SK INTEGER NOT NULL,
COST NUMERIC(12,2) NOT NULL
)
;
 
 
 
create index PLAN_SK on RPP_PLAN_COST_FACT(PLAN_SK);
 
 
 
quit;
 
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID761590_2;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID761590_2;
%put ERROR- Description                              : Add table for promotion specific cost fact;
%put ERROR- Version                                  : D3MICM52, M2MI42;
%put ERROR- Date of Change                           : 08JUN2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID761590_2;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID761590_2",
"Add table for promotion specific cost fact",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID761590_2:;
 
 
* End of changes for CHANGE_ID:ID761590_2;
 
 
***********************************************************************************************;
*************************************  End Change ID761590_2 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID0661257 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID0661257;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID0661257")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID0661257;
%goto ID0661257;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID0661257;
* Insert record into change management table for CHANGE_ID: ID0661257;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID0661257",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID0661257;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
%let m_sql_statement = %str(
ALTER TABLE REQUEST ADD ADJUST_ORDER_QTY_MIN_FLG INTEGER
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE REQUEST ADD ADJUST_ORDER_QTY_MAX_FLG INTEGER
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
ALTER TABLE REQUEST ADD ADJUST_ORDER_QTY_MIN_FLG INTEGER;
 
 
ALTER TABLE REQUEST ADD ADJUST_ORDER_QTY_MAX_FLG INTEGER;
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID0661257;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID0661257;
%put ERROR- Description                              : NF: Adjust store_order_min and max for stored inventory;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 10JUN2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID0661257;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID0661257",
"NF: Adjust store_order_min and max for stored inventory",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID0661257:;
 
 
* End of changes for CHANGE_ID:ID0661257;
 
 
***********************************************************************************************;
*************************************  End Change ID0661257 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID767638 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID767638;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID767638")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_trans..MODEL_SPEC_DEFAULT))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_trans..MODEL_SPEC_DEFAULT;
%put NOTE: Change ID                             :ID767638;
%goto ID767638;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID767638;
%goto ID767638;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID767638;
* Insert record into change management table for CHANGE_ID: ID767638;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID767638",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID767638;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
DELETE FROM MODEL_SPEC_DEFAULT WHERE SPEC_NM = 'DOW_PROFILE'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('DOW_PROFILE','FCST','1','1',NULL)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('DOW_PROFILE','FCST','2','1',NULL)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
DELETE FROM MODEL_SPEC_DEFAULT WHERE SPEC_NM = 'DAILY_FCST_METHOD'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('DAILY_FCST_METHOD','FCST','1','1',NULL)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('DAILY_FCST_METHOD','FCST','2','1',NULL)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
DELETE FROM MODEL_SPEC_DEFAULT WHERE SPEC_NM = 'DOW_PROFILE';
 
 
INSERT INTO MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('DOW_PROFILE','FCST','1','1',NULL);
 
 
INSERT INTO MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('DOW_PROFILE','FCST','2','1',NULL);
 
 
 
DELETE FROM MODEL_SPEC_DEFAULT WHERE SPEC_NM = 'DAILY_FCST_METHOD';
 
 
INSERT INTO MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('DAILY_FCST_METHOD','FCST','1','1',NULL);
 
 
INSERT INTO MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('DAILY_FCST_METHOD','FCST','2','1',NULL);
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID767638;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID767638;
%put ERROR- Description                              : Change model specs DOW_PROFILE and DAILY_FCST_METHOD component from DOW to FCST;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 15JUN2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID767638;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID767638",
"Change model specs DOW_PROFILE and DAILY_FCST_METHOD component from DOW to FCST",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID767638:;
 
 
* End of changes for CHANGE_ID:ID767638;
 
 
***********************************************************************************************;
*************************************  End Change ID767638 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID768125 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID768125;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID768125")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID768125;
%goto ID768125;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID768125;
* Insert record into change management table for CHANGE_ID: ID768125;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID768125",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID768125;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE)) %then %do;
 
%let m_sql_statement = %str(
ALTER TABLE DATA_CONFIG_TEMPLATE DROP COLUMN INCLUDE_TS
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE DATA_CONFIG_TEMPLATE DROP COLUMN INCLUDE_REG
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE DATA_CONFIG_TEMPLATE RENAME COLUMN FCST_GEO_LVL TO DOW_GEO_LVL
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE DATA_CONFIG_TEMPLATE RENAME COLUMN FCST_PROD_LVL TO DOW_PROD_LVL
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE DATA_CONFIG_TEMPLATE RENAME COLUMN FCST_BY_GEO_LVL TO DOW_BY_GEO_LVL
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE DATA_CONFIG_TEMPLATE RENAME COLUMN FCST_BY_PROD_LVL TO DOW_BY_PROD_LVL
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
 
proc sql;
 
 
ALTER TABLE DATA_CONFIG_TEMPLATE DROP COLUMN INCLUDE_TS;
 
 
ALTER TABLE DATA_CONFIG_TEMPLATE DROP COLUMN INCLUDE_REG;
 
 
quit;
 
 
 
proc datasets library=&m_di_trans nolist;
 
 
modify DATA_CONFIG_TEMPLATE ;
 
 
rename FCST_GEO_LVL = DOW_GEO_LVL;
 
 
rename FCST_PROD_LVL = DOW_PROD_LVL;
 
 
rename FCST_BY_GEO_LVL = DOW_BY_GEO_LVL;
 
 
rename FCST_BY_PROD_LVL = DOW_BY_PROD_LVL;
 
 
quit;
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (DB2)) %then %do;
 
%let m_sql_statement = %str(
ALTER TABLE DATA_CONFIG_TEMPLATE DROP COLUMN INCLUDE_TS
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE DATA_CONFIG_TEMPLATE DROP COLUMN INCLUDE_REG
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE DATA_CONFIG_TEMPLATE RENAME COLUMN FCST_GEO_LVL TO DOW_GEO_LVL
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE DATA_CONFIG_TEMPLATE RENAME COLUMN FCST_PROD_LVL TO DOW_PROD_LVL
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE DATA_CONFIG_TEMPLATE RENAME COLUMN FCST_BY_GEO_LVL TO DOW_BY_GEO_LVL
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE DATA_CONFIG_TEMPLATE RENAME COLUMN FCST_BY_PROD_LVL TO DOW_BY_PROD_LVL
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
REORG TABLE DATA_CONFIG_TEMPLATE
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID768125;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID768125;
%put ERROR- Description                              : Modify DATA_CONFIG_TEMPLATE table to support DOW component;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 16JUN2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID768125;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID768125",
"Modify DATA_CONFIG_TEMPLATE table to support DOW component",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID768125:;
 
 
* End of changes for CHANGE_ID:ID768125;
 
 
***********************************************************************************************;
*************************************  End Change ID768125 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID767774 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID767774;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID767774")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_trans..MA_SCENARIO_STATUS))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_trans..MA_SCENARIO_STATUS;
%put NOTE: Change ID                             :ID767774;
%goto ID767774;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID767774;
%goto ID767774;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID767774;
* Insert record into change management table for CHANGE_ID: ID767774;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID767774",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID767774;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
DROP TABLE MA_SCENARIO_STATUS
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
DROP TABLE MA_SCENARIO_STATUS;
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID767774;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID767774;
%put ERROR- Description                              : Drop table MA_SCENARIO_STATUS from schema;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 15JUN2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID767774;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID767774",
"Drop table MA_SCENARIO_STATUS from schema",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID767774:;
 
 
* End of changes for CHANGE_ID:ID767774;
 
 
***********************************************************************************************;
*************************************  End Change ID767774 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID767635 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID767635;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID767635")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_trans..MODEL_SPEC_DEFAULT))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_trans..MODEL_SPEC_DEFAULT;
%put NOTE: Change ID                             :ID767635;
%goto ID767635;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID767635;
%goto ID767635;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID767635;
* Insert record into change management table for CHANGE_ID: ID767635;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID767635",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID767635;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
DELETE FROM MODEL_SPEC_DEFAULT WHERE SPEC_NM = 'DOW_EVENT_PROD_AGG'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('DOW_EVENT_PROD_AGG','DOW','-1','0',NULL)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
DELETE FROM MODEL_SPEC_DEFAULT WHERE SPEC_NM = 'DOW_EVENT_PROD_AGG';
 
 
INSERT INTO MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
VALUES ('DOW_EVENT_PROD_AGG','DOW','-1','0',NULL);
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID767635;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID767635;
%put ERROR- Description                              : Add DOW spec DOW_EVENT_PROD_AGG;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 15JUN2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID767635;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID767635",
"Add DOW spec DOW_EVENT_PROD_AGG",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID767635:;
 
 
* End of changes for CHANGE_ID:ID767635;
 
 
***********************************************************************************************;
*************************************  End Change ID767635 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID768006 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID768006;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID768006")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID768006;
%goto ID768006;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID768006;
* Insert record into change management table for CHANGE_ID: ID768006;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID768006",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID768006;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
ALTER TABLE MDO_PLAN ADD ALLOW_MARKDN_DURING_PROMO_CD INTEGER
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
INSERT INTO GEO_PROD_SETTING (GEO_PROD_SETTING_SK,GEO_HIER_SK,PROD_HIER_SK,USED_BY_APP,SETTING_TYPE,SETTING_VAL,SETTING_OVERRIDE_FLG,SETTING_FLOOR,SETTING_CEIL,GEO_HIER_ASSOC_CD)
VALUES (28,1,1,1,53,1,1,1,2,1)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
ALTER TABLE MDO_PLAN ADD ALLOW_MARKDN_DURING_PROMO_CD INTEGER;
 
 
 
INSERT INTO GEO_PROD_SETTING (GEO_PROD_SETTING_SK,GEO_HIER_SK,PROD_HIER_SK,USED_BY_APP,SETTING_TYPE,SETTING_VAL,SETTING_OVERRIDE_FLG,SETTING_FLOOR,SETTING_CEIL,GEO_HIER_ASSOC_CD)
VALUES (28,1,1,1,53,1,1,1,2,1);
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID768006;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID768006;
%put ERROR- Description                              : Add plan setting and pricing rule for allow markdown during promo;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 16JUN2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID768006;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID768006",
"Add plan setting and pricing rule for allow markdown during promo",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID768006:;
 
 
* End of changes for CHANGE_ID:ID768006;
 
 
***********************************************************************************************;
*************************************  End Change ID768006 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID768547 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID768547;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID768547")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID768547;
%goto ID768547;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID768547;
* Insert record into change management table for CHANGE_ID: ID768547;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID768547",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID768547;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
ALTER TABLE PKO_BUY ADD USE_SHARED_PACK_CONFIGS INTEGER
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE PKO_DELIVERY ADD USE_SHARED_PACK_CONFIGS INTEGER
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
ALTER TABLE PKO_BUY ADD USE_SHARED_PACK_CONFIGS INTEGER ;
 
 
ALTER TABLE PKO_DELIVERY ADD USE_SHARED_PACK_CONFIGS INTEGER ;
 
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID768547;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID768547;
%put ERROR- Description                              : Support Style-level Configurations in client;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 21JUN2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID768547;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID768547",
"Support Style-level Configurations in client",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID768547:;
 
 
* End of changes for CHANGE_ID:ID768547;
 
 
***********************************************************************************************;
*************************************  End Change ID768547 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID763412 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID763412;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID763412")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID763412;
%goto ID763412;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID763412;
* Insert record into change management table for CHANGE_ID: ID763412;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID763412",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID763412;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
CREATE TABLE PKOPT_PLANNED_QTY (
PLANNED_QTY_SK INTEGER NOT NULL,
IMPORT_ID INTEGER NOT NULL,
PROD_ID VARCHAR(32) NOT NULL,
PROD_HIER_SK INTEGER,
GEO_ID VARCHAR(32) NOT NULL,
GEO_HIER_SK INTEGER,
QTY INTEGER NOT NULL,
PRIMARY KEY (PLANNED_QTY_SK)
)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
CREATE SEQUENCE SEQ_PLANNED_QTY_SK START WITH 100000
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
CREATE INDEX PKOPT_PLANNED_QTY_IX1 ON PKOPT_PLANNED_QTY
(
IMPORT_ID
)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
CREATE INDEX PKOPT_PLANNED_QTY_IX2 ON PKOPT_PLANNED_QTY
(
PROD_ID
)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
CREATE TABLE PKO_EXTERNAL_NEED_SUMMARY
(
PKO_EXTERNAL_NEED_SUM_SK           INTEGER NOT NULL,
PKO_NEED_LOCATION_GROUP_SK         INTEGER NOT NULL,
NEED_DT                            DATE,
NEED                               INTEGER NOT NULL,
DELIVERY_SEQUENCE_ID               INTEGER NOT NULL,
PROD_HIER_SK                       INTEGER NOT NULL,
IMPORT_ID                          INTEGER NOT NULL,
PRIMARY KEY (PKO_EXTERNAL_NEED_SUM_SK)
)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
CREATE SEQUENCE SEQ_PKO_EXTERNAL_NEED_SUM_SK START WITH 100000
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
 
proc sql;
 
 
 
CREATE TABLE PKOPT_PLANNED_QTY (
PLANNED_QTY_SK INTEGER NOT NULL,
IMPORT_ID INTEGER NOT NULL,
PROD_ID VARCHAR(32) NOT NULL,
PROD_HIER_SK INTEGER,
GEO_ID VARCHAR(32) NOT NULL,
GEO_HIER_SK INTEGER,
QTY INTEGER NOT NULL
) ;
 
 
 
ALTER TABLE PKOPT_PLANNED_QTY ADD CONSTRAINT PKOPT_PLANNED_QTY PRIMARY KEY (PLANNED_QTY_SK);
 
 
 
CREATE INDEX IMPORT_ID ON PKOPT_PLANNED_QTY
(
IMPORT_ID
) ;
 
 
 
CREATE INDEX PROD_ID ON PKOPT_PLANNED_QTY
(
PROD_ID
) ;
 
 
 
CREATE TABLE PKO_EXTERNAL_NEED_SUMMARY
(
PKO_EXTERNAL_NEED_SUM_SK           INTEGER NOT NULL,
PKO_NEED_LOCATION_GROUP_SK         INTEGER NOT NULL,
NEED_DT                            DATE,
NEED                               INTEGER NOT NULL,
DELIVERY_SEQUENCE_ID               INTEGER NOT NULL,
PROD_HIER_SK                       INTEGER NOT NULL,
IMPORT_ID                          INTEGER NOT NULL
) ;
 
 
 
ALTER TABLE PKO_EXTERNAL_NEED_SUMMARY ADD CONSTRAINT PKO_EXTERNAL_NEED_SUMMARY PRIMARY KEY (PKO_EXTERNAL_NEED_SUM_SK);
 
 
 
quit;
 
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID763412;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID763412;
%put ERROR- Description                              : Store level plan imports;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 21JUN2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID763412;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID763412",
"Store level plan imports",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID763412:;
 
 
* End of changes for CHANGE_ID:ID763412;
 
 
***********************************************************************************************;
*************************************  End Change ID763412 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID0767188 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID0767188;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID0767188")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(&m_di_trans.)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_di_trans.;
%put NOTE: Change ID                             :ID0767188;
%goto ID0767188;
 
%end;
%if not (%sysfunc(exist(&m_di_trans..REQ_PACKREC_SETTING))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_trans..REQ_PACKREC_SETTING;
%put NOTE: Change ID                             :ID0767188;
%goto ID0767188;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID0767188;
%goto ID0767188;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID0767188;
* Insert record into change management table for CHANGE_ID: ID0767188;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID0767188",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID0767188;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
%let m_sql_statement = %str(
ALTER TABLE REQ_PACKREC_SETTING ADD USE_SHARED_PACK_CONFIGS INTEGER
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
ALTER TABLE REQ_PACKREC_SETTING ADD USE_SHARED_PACK_CONFIGS INTEGER;
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID0767188;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID0767188;
%put ERROR- Description                              : NF: Packopt Schema change for shared pack configs by style;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 21JUN2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID0767188;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID0767188",
"NF: Packopt Schema change for shared pack configs by style",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID0767188:;
 
 
* End of changes for CHANGE_ID:ID0767188;
 
 
***********************************************************************************************;
*************************************  End Change ID0767188 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID763412_1 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID763412_1;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID763412_1")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID763412_1;
%goto ID763412_1;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID763412_1;
* Insert record into change management table for CHANGE_ID: ID763412_1;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID763412_1",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID763412_1;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
ALTER TABLE PKOPT_PLANNED_QTY DROP COLUMN PROD_HIER_SK
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE PKOPT_PLANNED_QTY DROP COLUMN GEO_HIER_SK
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
ALTER TABLE PKOPT_PLANNED_QTY DROP COLUMN PROD_HIER_SK ;
 
 
ALTER TABLE PKOPT_PLANNED_QTY DROP COLUMN GEO_HIER_SK ;
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID763412_1;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID763412_1;
%put ERROR- Description                              : Store level plan imports;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 22JUN2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID763412_1;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID763412_1",
"Store level plan imports",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID763412_1:;
 
 
* End of changes for CHANGE_ID:ID763412_1;
 
 
***********************************************************************************************;
*************************************  End Change ID763412_1 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID769264 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID769264;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID769264")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID769264;
%goto ID769264;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID769264;
* Insert record into change management table for CHANGE_ID: ID769264;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID769264",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID769264;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
ALTER TABLE PKO_DELIVERY ADD SKU_MIN INTEGER
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE PKO_STORE_NEED ADD SKU_MIN INTEGER
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
ALTER TABLE PKO_DELIVERY ADD SKU_MIN INTEGER ;
 
 
ALTER TABLE PKO_STORE_NEED ADD SKU_MIN INTEGER ;
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID769264;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID769264;
%put ERROR- Description                              : SKU x Store Minimums in Client;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 22JUN2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID769264;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID769264",
"SKU x Store Minimums in Client",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID769264:;
 
 
* End of changes for CHANGE_ID:ID769264;
 
 
***********************************************************************************************;
*************************************  End Change ID769264 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID733774_2 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID733774_2;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID733774_2")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID733774_2;
%goto ID733774_2;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID733774_2;
* Insert record into change management table for CHANGE_ID: ID733774_2;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID733774_2",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID733774_2;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
DROP TABLE COVERAGE_INPUT
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%let m_sql_statement = %str(
DROP TABLE COVERAGE_OUTPUT
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
CREATE TABLE COVERAGE_OUTPUT
(
PROD_HIER_SK                  INTEGER NOT NULL,
PROD_HIER_ASSOC_CD            INTEGER NOT NULL,
GEO_HIER_SK                   INTEGER NOT NULL,
GEO_HIER_ASSOC_CD             INTEGER NOT NULL,
PRIMARY KEY(PROD_HIER_SK, PROD_HIER_ASSOC_CD, GEO_HIER_SK, GEO_HIER_ASSOC_CD)
)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
 
proc sql;
 
 
 
DROP TABLE COVERAGE_INPUT;
 
 
CREATE TABLE COVERAGE_OUTPUT
(
PROD_HIER_SK                  INTEGER NOT NULL,
PROD_HIER_ASSOC_CD            INTEGER NOT NULL,
GEO_HIER_SK                   INTEGER NOT NULL,
GEO_HIER_ASSOC_CD             INTEGER NOT NULL
);
 
 
ALTER TABLE COVERAGE_OUTPUT ADD CONSTRAINT PRIM_KEY PRIMARY KEY (PROD_HIER_SK, PROD_HIER_ASSOC_CD, GEO_HIER_SK, GEO_HIER_ASSOC_CD) ;
 
 
 
quit;
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID733774_2;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID733774_2;
%put ERROR- Description                              : Remove COVERAGE_INPUT table and COVERAGE_OUTPUT user_nm column.;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 23MAY2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID733774_2;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID733774_2",
"Remove COVERAGE_INPUT table and COVERAGE_OUTPUT user_nm column.",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID733774_2:;
 
 
* End of changes for CHANGE_ID:ID733774_2;
 
 
***********************************************************************************************;
*************************************  End Change ID733774_2 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID763412_2 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID763412_2;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID763412_2")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID763412_2;
%goto ID763412_2;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID763412_2;
* Insert record into change management table for CHANGE_ID: ID763412_2;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID763412_2",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID763412_2;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
ALTER TABLE PKO_IMPORTED_NEED ADD TOTAL INTEGER
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
ALTER TABLE PKO_IMPORTED_NEED ADD TOTAL INTEGER;
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID763412_2;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID763412_2;
%put ERROR- Description                              : Store level plan imports;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 27JUN2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID763412_2;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID763412_2",
"Store level plan imports",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID763412_2:;
 
 
* End of changes for CHANGE_ID:ID763412_2;
 
 
***********************************************************************************************;
*************************************  End Change ID763412_2 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID769228 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID769228;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID769228")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID769228;
%goto ID769228;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID769228;
* Insert record into change management table for CHANGE_ID: ID769228;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID769228",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID769228;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
CREATE TABLE PKO_NEED_LOCGRP_PRODUCT
(
PKO_NEED_LOCGRP_PRODUCT_SK         INTEGER NOT NULL,
PKO_NEED_LOCATION_GROUP_SK         INTEGER NOT NULL,
PROD_HIER_SK                       INTEGER NOT NULL,
PRIMARY KEY (PKO_NEED_LOCGRP_PRODUCT_SK)
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
CREATE SEQUENCE SEQ_PKO_NEED_LOCGRP_PRODUCT_SK START WITH 100000
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
 
proc sql;
 
 
 
CREATE TABLE PKO_NEED_LOCGRP_PRODUCT
(
PKO_NEED_LOCGRP_PRODUCT_SK         INTEGER NOT NULL,
PKO_NEED_LOCATION_GROUP_SK         INTEGER NOT NULL,
PROD_HIER_SK                       INTEGER NOT NULL
)
;
 
 
ALTER TABLE PKO_NEED_LOCGRP_PRODUCT ADD CONSTRAINT PKO_NEED_LOCGRP_PRODUCT PRIMARY KEY (PKO_NEED_LOCGRP_PRODUCT_SK);
 
 
quit;
 
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID769228;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID769228;
%put ERROR- Description                              : Remove products from a delivery;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 28JUN2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID769228;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID769228",
"Remove products from a delivery",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID769228:;
 
 
* End of changes for CHANGE_ID:ID769228;
 
 
***********************************************************************************************;
*************************************  End Change ID769228 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID761590_3 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID761590_3;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID761590_3")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID761590_3;
%goto ID761590_3;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52,M2MI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID761590_3;
* Insert record into change management table for CHANGE_ID: ID761590_3;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID761590_3",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID761590_3;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
 
%let m_sql_statement = %str(
ALTER TABLE RPP_PLAN_COST_FACT ADD COST_TYPE INTEGER
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
 
ALTER TABLE RPP_PLAN_COST_FACT ADD COST_TYPE INTEGER;
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID761590_3;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID761590_3;
%put ERROR- Description                              : Add cost type column to promotion specific cost fact;
%put ERROR- Version                                  : D3MICM52,M2MI42;
%put ERROR- Date of Change                           : 01JUL2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID761590_3;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID761590_3",
"Add cost type column to promotion specific cost fact",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID761590_3:;
 
 
* End of changes for CHANGE_ID:ID761590_3;
 
 
***********************************************************************************************;
*************************************  End Change ID761590_3 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID764696 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID764696;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID764696")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID764696;
%goto ID764696;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID764696;
* Insert record into change management table for CHANGE_ID: ID764696;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID764696",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID764696;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
ALTER TABLE TABLE_PARTITION_META ADD ETL_STG2DM INTEGER
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE TABLE_PARTITION_META ADD SORT_ORDER varchar(255)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
delete from TABLE_PARTITION_META
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('ALLOWED_PRICE_CHG_DATE',1,0,0,null,'PROD_HIER_SK GEO_HIER_ASSOC_CD GEO_HIER_SK ALLOWED_DATE PRICE_TYPE PRIORITY')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('ATTR_GEO_DM',1,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('ATTR_GEO_HIER_ASSOC_DM',1,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('ATTR_GEO_LVL',1,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('ATTR_GEO_SCOPE',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('ATTR_HIERARCHY_HISTORY',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('ATTR_INPUT_GEO_LVL',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('ATTR_INPUT_PROD_LVL',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('ATTR_MAP',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('ATTR_PROD_DM',0,1,0,0,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('ATTR_PROD_HIER_ASSOC_DM',0,1,0,0,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('ATTR_PROD_LVL',1,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('ATTR_PROD_SCOPE',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('ATTR_REG',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('ATTR_SPEC',1,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('ATTR_SPEC_PREV',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('ATTRIBUTE',1,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('ATTRIBUTE_HISTORY',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('BASE_FORECAST',1,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('BASE_FORECAST_AVG',1,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('BASE_FORECAST_OVERRIDE_GP',1,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('BASE_FORECAST_OVERRIDE_GP_LOW',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('BASE_FORECAST_OVERRIDE_MG',1,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('BAYESIAN_MODEL',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('BUDGET',1,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('CLR_DC_INV_REPORT',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('CLR_EFF_REPORT',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('CLR_INV_AGING_REPORT',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('CLR_ITEM_SEL_REPORT',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('CLR_MD_PROJECTION_REPORT',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('CLR_MD_PROJECTION_REPORT_WEEKLY',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('COMP_PRICE_FACT',0,0,0,null,'GEO_HIER_SK PROD_HIER_SK COMPETITOR_SK PRICE_TYPE START_DT')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('COMP_PRICE_FACT_CURRENT',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('COMP_PRICE_VALIDITY_RULE',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('COMPETITOR',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('CONFIG_AUDIT_TRAIL',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('CONFIG_GROUP',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('COST_FACT_CURRENT',0,1,0,1,'PROD_HIER_SK GEO_HIER_SK COST_TYPE')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('COST_FACT_FUTURE',0,1,0,1,'PROD_HIER_SK GEO_HIER_SK COST_TYPE VALID_FROM_DT')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('COST_FACT_HISTORY',0,1,0,1,'PROD_HIER_SK GEO_HIER_SK COST_TYPE VALID_FROM_DT')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('DATA_CONFIG',1,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('DATA_CONFIG_TEMPLATE',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('DATA_LVL',1,0,0,null,'GEO_LVL PROD_LVL DATE_LVL PROD_HIER_ASSOC_CD GEO_HIER_ASSOC_CD')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('DATE_DM',1,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('DATE_HIER_ASSOC_DM',1,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('DATE_LVL',1,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('DEMAND_DISAGG_FACTOR',0,0,0,null,'PROD_HIER_SK GEO_HIER_SK START_DT')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('DEMAND_DISAGG_FACTOR_DEFAULT',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('DISAGG_FACTOR',1,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('DOW_SALES_FACT',0,1,0,1,'PROD_HIER_SK GEO_HIER_SK DATE_SK DAY_OF_WEEK')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('DOW_EVENT_SALES_FACT',0,1,0,1,'PROD_HIER_SK GEO_HIER_SK DATE_SK DAY_OF_WEEK')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('EXCEPTION_TYPE',1,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('FIELD_LOOKUP_VALUES',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('FUTURE_RECEIPT',0,1,0,1,'PROD_HIER_SK GEO_HIER_SK RECEIPT_DT')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('GEO_DATE',1,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('GEO_PROD',0,1,0,1,'PROD_HIER_SK GEO_HIER_SK')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('GEO_PROD_ACCUM_MEASURE',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('GEO_PROD_EXCEPTION',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('GEO_PROD_OWNED_INV',0,1,0,1,'PROD_HIER_SK GEO_HIER_SK DATE_SK')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('GEO_PROD_PERFORMANCE',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('GEO_PROD_PURGE_LIST',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('GEO_PROD_STATUS',0,1,0,1,'PROD_HIER_SK GEO_HIER_SK VALID_FROM_DT')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('GEO_PROD_VAT',0,1,0,0,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('GEO_STORE',1,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('GEOGRAPHY_ATTR_LOOKUP',1,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('GEOGRAPHY_ATTRIBUTES',1,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('GEOGRAPHY_DM',1,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('GEOGRAPHY_HIER_ASSOC_DM',1,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('GEOGRAPHY_LVL',1,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('GLOBAL_SETTING',1,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('GLOBAL_SETTING_DETAILS',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('GLOBAL_SETTING_GROUP',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('GLOBAL_SETTING_GROUP_MEMBER',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('GLOBAL_SETTING_PREV',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('GLOBAL_SETTING_VALUES',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('HALO_FACTOR',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('HALO_GEO_PROD',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('HALO_PARAM',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('HALO_PRODUCTS',0,0,0,null,'CAUSE_PROD_HIER_SK EFFECT_PROD_HIER_SK')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('HALO_VAR',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('HEDONIC_PRICE',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('HEDONIC_SCORE',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('HIERARCHY_ASSOC_DM',1,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('HIERARCHY_HISTORY',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('INVENTORY_FACT',0,1,0,1,'PROD_HIER_SK GEO_HIER_SK DATE_SK')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('JOB',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('JOB_INSTANCE',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('JOB_INSTANCE_PARAM',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('JOB_STATUS',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('MKDN_APPR_REPORT',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('MODEL_DATA_AGG',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('MODEL_DATA_CALIB_PS',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('MODEL_DATA_LOW',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('MODEL_EXCEPTION',1,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('MODEL_FIT_STAT',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('MODEL_GEO_HIER_ASSOC_DM',1,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('MODEL_GEO_PROD',1,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('MODEL_GEO_PROD_STATUS',1,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('MODEL_GEO_PROD_STATUS_DETAILS',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('MODEL_GEO_PROD_STATUS_INC',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('MODEL_GEO_PROD_STATUS_RULE',1,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('MODEL_GEO_PROD_STATUS_SPEC',1,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('MODEL_GEO_PROD_STATUS_VALUES',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('MODEL_GROUP',1,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('MODEL_GROUP_FACTOR',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('MODEL_GROUP_STATS',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('MODEL_PARAM_EST',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('MODEL_PROD_HIER_ASSOC_DM',1,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('MODEL_SPEC',1,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('MODEL_SPEC_DEFAULT',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('MODEL_SPEC_DETAILS',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('MODEL_SPEC_PREV',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('MODEL_SPEC_TEMPLATE',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('MODEL_SPEC_VALUES',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('MODEL_SPEC_WORKFLOW',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('MOVING_HEDONIC_SCORE',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('MPLN_GEO_PROD_ACCUM_MTS',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('MPLN_PERIOD_ACTUAL_MTS',1,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('MPLN_PERIOD_EST_MTS',1,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('MPLN_PERIOD_EST_MTS_HIST',1,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('MPLN_STORE_EST_MTS',1,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PACK_DM',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PACK_FUTURE_RECEIPT',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PACK_GROUP',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PACK_GROUP_GEO_SETTINGS',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PACK_HIER_DM',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PACK_INVENTORY_FACT',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PACK_LVL',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PACK_PACK_GROUP',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PACK_PROD',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PACK_TYPE',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PERIOD_IN_LIFECYCLE',1,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PRF_GEO_PROD_STATUS',0,0,0,1,'PROD_HIER_SK GEO_HIER_SK VALID_FROM_DT')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PRF_GEO_PROD_STATUS_META',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PRF_PROD_PRTN_MBR',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PRF_PROJ_PROD',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PRF_SALES_DATA_SUMMARY',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PRF_SALES_FACT',0,0,0,1,'PROD_HIER_SK GEO_HIER_SK DATE_SK')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PRF_SALES_FACT_META',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PRF_SSD_AGG',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PRF_SSD_SRC',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PRF_SSD_SSET',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PRF_STOCKOUT_FACT',0,0,0,1,'PROD_HIER_SK GEO_HIER_SK START_DT END_DT')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PRF_STOCKOUT_FACT_META',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PRF_STR_CLSF',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PRF_STR_CLSF_A',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PRICE_CHANGE_PRIORITY',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PRICE_FACT_CURRENT',0,1,0,1,'PROD_HIER_SK GEO_HIER_SK')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PRICE_FACT_FUTURE',0,1,0,1,'PROD_HIER_SK GEO_HIER_SK VALID_FROM_DT')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PRICE_FACT_HISTORY',0,1,0,1,'PROD_HIER_SK GEO_HIER_SK VALID_FROM_DT')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PRICE_PROMO_ELASTICITY',1,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PROD_DATA_CONFIG',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PROD_GEO_HIER_ASSOC',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PROD_GEO_RELATION',0,1,0,0,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PROD_LIFECYCLE_CURVE',1,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PROD_SIZE_PTCP',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PROD_SIZESET',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PRODUCT_ATTR_LOOKUP',0,1,0,0,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PRODUCT_ATTRIBUTES',0,1,0,0,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PRODUCT_CROSS_EFFECT_SPEC',0,1,0,0,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PRODUCT_DM',0,1,0,0,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PRODUCT_HIER_ASSOC_DM',0,1,0,0,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PRODUCT_LVL',1,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PRODUCT_RELATION',0,1,0,0,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PROMO_FACTOR',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PROMO_FACTOR_DECOM',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PROMO_SALES_FACT',0,1,0,1,'PROD_HIER_SK GEO_HIER_SK START_DT END_DT')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PROMOTION_FACT',0,1,0,1,'PROD_HIER_SK GEO_HIER_SK VEHICLE_SK CONDITION_TYPE RANGE_START_DISC_PCT RANGE_END_DISC_PCT START_DT')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PROMOTION_FACT_FUTURE',0,1,0,1,'PROD_HIER_SK GEO_HIER_SK VEHICLE_SK CONDITION_TYPE RANGE_START_DISC_PCT RANGE_END_DISC_PCT START_DT')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PSYCHOLOGICAL_POINTS',1,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('REFERENCE_VALUES',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('REG_COST_CHG_REPORT',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('REG_COST_HIST_REPORT',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('REG_GM_CHG_REPORT',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('REG_PRC_CHG_REPORT',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('REG_SKU_COST_CHG_REPORT',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('REG_SKU_RETAIL_CHG_REPORT',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('REPORT_BY_EVENT',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('REPORT_CATEGORY_X_IMPACT',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('REPORT_DATA_LVL',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('REPORT_DEMAND_DECOM_DATE_SK',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('REPORT_MEASURES_BY_PS',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('REPORT_MEASURES_DATE_SK',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('RETURN_FACT',0,1,0,1,'PROD_HIER_SK GEO_HIER_SK DATE_SK')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('RETURN_RATE_AVG',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('RPP_CAL_AGG',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('RPP_CAT_AGG',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('RPP_PGSPOT',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('RPP_PROMOEFF',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('RPP_PROMOPLAN',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('RPP_PROMOSUMM',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('RPP_VENDOR_FUND',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('RPP_VG_SUMMARY',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('SALES_AVG',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('SALES_AVG_LOW',1,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('SALES_FACT',0,1,0,1,'PROD_HIER_SK GEO_HIER_SK DATE_SK')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('SALES_MIX_DAY_OF_WEEK',1,0,0,null,'GEO_HIER_SK PROD_HIER_SK DAY_OF_WEEK')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('SCORE_DATA',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('SCORING_PARAM',1,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('SCORING_PARAM_UNCAPPED',1,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('SCORING_PARAM_AVG',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('SCORING_PARAM_CONFIG',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('SCORING_PARAM_DEFAULT',1,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('SIZESET',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('SIZESET_MBR',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('STORE_CATEGORY',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('STORE_CATEGORY_MBR',0,0,0,null,'GEO_HIER_SK STORE_CATEGORY_ID')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('STORE_EXCLUDED',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('STR_GRP_MBR',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('TARGET_METRICS',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('TREND_SEASONALITY',1,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('UNACC_DISCOUNT',1,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('VEHICLE_SUPPORT_MAP',1,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('VEHICLE_SUPPORT_MAP_PREV',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('VENDOR',1,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
ALTER TABLE TABLE_PARTITION_META ADD ETL_STG2DM INTEGER ;
 
 
ALTER TABLE TABLE_PARTITION_META ADD SORT_ORDER varchar(255);
 
 
 
delete from TABLE_PARTITION_META;
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('ALLOWED_PRICE_CHG_DATE',1,0,0,null,'PROD_HIER_SK GEO_HIER_ASSOC_CD GEO_HIER_SK ALLOWED_DATE PRICE_TYPE PRIORITY');
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('ATTR_GEO_DM',1,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('ATTR_GEO_HIER_ASSOC_DM',1,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('ATTR_GEO_LVL',1,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('ATTR_GEO_SCOPE',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('ATTR_HIERARCHY_HISTORY',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('ATTR_INPUT_GEO_LVL',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('ATTR_INPUT_PROD_LVL',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('ATTR_MAP',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('ATTR_PROD_DM',0,1,0,0,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('ATTR_PROD_HIER_ASSOC_DM',0,1,0,0,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('ATTR_PROD_LVL',1,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('ATTR_PROD_SCOPE',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('ATTR_REG',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('ATTR_SPEC',1,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('ATTR_SPEC_PREV',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('ATTRIBUTE',1,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('ATTRIBUTE_HISTORY',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('BASE_FORECAST',1,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('BASE_FORECAST_AVG',1,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('BASE_FORECAST_OVERRIDE_GP',1,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('BASE_FORECAST_OVERRIDE_GP_LOW',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('BASE_FORECAST_OVERRIDE_MG',1,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('BAYESIAN_MODEL',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('BUDGET',1,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('CLR_DC_INV_REPORT',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('CLR_EFF_REPORT',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('CLR_INV_AGING_REPORT',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('CLR_ITEM_SEL_REPORT',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('CLR_MD_PROJECTION_REPORT',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('CLR_MD_PROJECTION_REPORT_WEEKLY',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('COMP_PRICE_FACT',0,0,0,null,'GEO_HIER_SK PROD_HIER_SK COMPETITOR_SK PRICE_TYPE START_DT');
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('COMP_PRICE_FACT_CURRENT',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('COMP_PRICE_VALIDITY_RULE',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('COMPETITOR',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('CONFIG_AUDIT_TRAIL',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('CONFIG_GROUP',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('COST_FACT_CURRENT',0,1,0,1,'PROD_HIER_SK GEO_HIER_SK COST_TYPE');
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('COST_FACT_FUTURE',0,1,0,1,'PROD_HIER_SK GEO_HIER_SK COST_TYPE VALID_FROM_DT');
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('COST_FACT_HISTORY',0,1,0,1,'PROD_HIER_SK GEO_HIER_SK COST_TYPE VALID_FROM_DT');
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('DATA_CONFIG',1,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('DATA_CONFIG_TEMPLATE',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('DATA_LVL',1,0,0,null,'GEO_LVL PROD_LVL DATE_LVL PROD_HIER_ASSOC_CD GEO_HIER_ASSOC_CD');
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('DATE_DM',1,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('DATE_HIER_ASSOC_DM',1,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('DATE_LVL',1,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('DEMAND_DISAGG_FACTOR',0,0,0,null,'PROD_HIER_SK GEO_HIER_SK START_DT');
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('DEMAND_DISAGG_FACTOR_DEFAULT',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('DISAGG_FACTOR',1,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('DOW_SALES_FACT',0,1,0,1,'PROD_HIER_SK GEO_HIER_SK DATE_SK DAY_OF_WEEK');
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('DOW_EVENT_SALES_FACT',0,1,0,1,'PROD_HIER_SK GEO_HIER_SK DATE_SK DAY_OF_WEEK');
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('EXCEPTION_TYPE',1,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('FIELD_LOOKUP_VALUES',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('FUTURE_RECEIPT',0,1,0,1,'PROD_HIER_SK GEO_HIER_SK RECEIPT_DT');
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('GEO_DATE',1,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('GEO_PROD',0,1,0,1,'PROD_HIER_SK GEO_HIER_SK');
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('GEO_PROD_ACCUM_MEASURE',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('GEO_PROD_EXCEPTION',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('GEO_PROD_OWNED_INV',0,1,0,1,'PROD_HIER_SK GEO_HIER_SK DATE_SK');
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('GEO_PROD_PERFORMANCE',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('GEO_PROD_PURGE_LIST',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('GEO_PROD_STATUS',0,1,0,1,'PROD_HIER_SK GEO_HIER_SK VALID_FROM_DT');
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('GEO_PROD_VAT',0,1,0,0,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('GEO_STORE',1,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('GEOGRAPHY_ATTR_LOOKUP',1,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('GEOGRAPHY_ATTRIBUTES',1,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('GEOGRAPHY_DM',1,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('GEOGRAPHY_HIER_ASSOC_DM',1,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('GEOGRAPHY_LVL',1,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('GLOBAL_SETTING',1,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('GLOBAL_SETTING_DETAILS',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('GLOBAL_SETTING_GROUP',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('GLOBAL_SETTING_GROUP_MEMBER',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('GLOBAL_SETTING_PREV',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('GLOBAL_SETTING_VALUES',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('HALO_FACTOR',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('HALO_GEO_PROD',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('HALO_PARAM',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('HALO_PRODUCTS',0,0,0,null,'CAUSE_PROD_HIER_SK EFFECT_PROD_HIER_SK');
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('HALO_VAR',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('HEDONIC_PRICE',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('HEDONIC_SCORE',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('HIERARCHY_ASSOC_DM',1,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('HIERARCHY_HISTORY',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('INVENTORY_FACT',0,1,0,1,'PROD_HIER_SK GEO_HIER_SK DATE_SK');
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('JOB',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('JOB_INSTANCE',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('JOB_INSTANCE_PARAM',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('JOB_STATUS',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('MKDN_APPR_REPORT',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('MODEL_DATA_AGG',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('MODEL_DATA_CALIB_PS',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('MODEL_DATA_LOW',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('MODEL_EXCEPTION',1,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('MODEL_FIT_STAT',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('MODEL_GEO_HIER_ASSOC_DM',1,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('MODEL_GEO_PROD',1,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('MODEL_GEO_PROD_STATUS',1,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('MODEL_GEO_PROD_STATUS_DETAILS',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('MODEL_GEO_PROD_STATUS_INC',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('MODEL_GEO_PROD_STATUS_RULE',1,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('MODEL_GEO_PROD_STATUS_SPEC',1,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('MODEL_GEO_PROD_STATUS_VALUES',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('MODEL_GROUP',1,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('MODEL_GROUP_FACTOR',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('MODEL_GROUP_STATS',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('MODEL_PARAM_EST',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('MODEL_PROD_HIER_ASSOC_DM',1,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('MODEL_SPEC',1,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('MODEL_SPEC_DEFAULT',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('MODEL_SPEC_DETAILS',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('MODEL_SPEC_PREV',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('MODEL_SPEC_TEMPLATE',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('MODEL_SPEC_VALUES',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('MODEL_SPEC_WORKFLOW',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('MOVING_HEDONIC_SCORE',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('MPLN_GEO_PROD_ACCUM_MTS',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('MPLN_PERIOD_ACTUAL_MTS',1,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('MPLN_PERIOD_EST_MTS',1,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('MPLN_PERIOD_EST_MTS_HIST',1,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('MPLN_STORE_EST_MTS',1,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PACK_DM',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PACK_FUTURE_RECEIPT',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PACK_GROUP',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PACK_GROUP_GEO_SETTINGS',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PACK_HIER_DM',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PACK_INVENTORY_FACT',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PACK_LVL',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PACK_PACK_GROUP',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PACK_PROD',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PACK_TYPE',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PERIOD_IN_LIFECYCLE',1,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PRF_GEO_PROD_STATUS',0,0,0,1,'PROD_HIER_SK GEO_HIER_SK VALID_FROM_DT');
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PRF_GEO_PROD_STATUS_META',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PRF_PROD_PRTN_MBR',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PRF_PROJ_PROD',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PRF_SALES_DATA_SUMMARY',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PRF_SALES_FACT',0,0,0,1,'PROD_HIER_SK GEO_HIER_SK DATE_SK');
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PRF_SALES_FACT_META',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PRF_SSD_AGG',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PRF_SSD_SRC',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PRF_SSD_SSET',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PRF_STOCKOUT_FACT',0,0,0,1,'PROD_HIER_SK GEO_HIER_SK START_DT END_DT');
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PRF_STOCKOUT_FACT_META',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PRF_STR_CLSF',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PRF_STR_CLSF_A',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PRICE_CHANGE_PRIORITY',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PRICE_FACT_CURRENT',0,1,0,1,'PROD_HIER_SK GEO_HIER_SK');
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PRICE_FACT_FUTURE',0,1,0,1,'PROD_HIER_SK GEO_HIER_SK VALID_FROM_DT');
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PRICE_FACT_HISTORY',0,1,0,1,'PROD_HIER_SK GEO_HIER_SK VALID_FROM_DT');
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PRICE_PROMO_ELASTICITY',1,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PROD_DATA_CONFIG',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PROD_GEO_HIER_ASSOC',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PROD_GEO_RELATION',0,1,0,0,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PROD_LIFECYCLE_CURVE',1,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PROD_SIZE_PTCP',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PROD_SIZESET',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PRODUCT_ATTR_LOOKUP',0,1,0,0,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PRODUCT_ATTRIBUTES',0,1,0,0,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PRODUCT_CROSS_EFFECT_SPEC',0,1,0,0,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PRODUCT_DM',0,1,0,0,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PRODUCT_HIER_ASSOC_DM',0,1,0,0,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PRODUCT_LVL',1,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PRODUCT_RELATION',0,1,0,0,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PROMO_FACTOR',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PROMO_FACTOR_DECOM',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PROMO_SALES_FACT',0,1,0,1,'PROD_HIER_SK GEO_HIER_SK START_DT END_DT');
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PROMOTION_FACT',0,1,0,1,'PROD_HIER_SK GEO_HIER_SK VEHICLE_SK CONDITION_TYPE RANGE_START_DISC_PCT RANGE_END_DISC_PCT START_DT');
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PROMOTION_FACT_FUTURE',0,1,0,1,'PROD_HIER_SK GEO_HIER_SK VEHICLE_SK CONDITION_TYPE RANGE_START_DISC_PCT RANGE_END_DISC_PCT START_DT');
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('PSYCHOLOGICAL_POINTS',1,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('REFERENCE_VALUES',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('REG_COST_CHG_REPORT',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('REG_COST_HIST_REPORT',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('REG_GM_CHG_REPORT',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('REG_PRC_CHG_REPORT',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('REG_SKU_COST_CHG_REPORT',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('REG_SKU_RETAIL_CHG_REPORT',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('REPORT_BY_EVENT',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('REPORT_CATEGORY_X_IMPACT',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('REPORT_DATA_LVL',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('REPORT_DEMAND_DECOM_DATE_SK',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('REPORT_MEASURES_BY_PS',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('REPORT_MEASURES_DATE_SK',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('RETURN_FACT',0,1,0,1,'PROD_HIER_SK GEO_HIER_SK DATE_SK');
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('RETURN_RATE_AVG',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('RPP_CAL_AGG',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('RPP_CAT_AGG',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('RPP_PGSPOT',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('RPP_PROMOEFF',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('RPP_PROMOPLAN',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('RPP_PROMOSUMM',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('RPP_VENDOR_FUND',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('RPP_VG_SUMMARY',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('SALES_AVG',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('SALES_AVG_LOW',1,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('SALES_FACT',0,1,0,1,'PROD_HIER_SK GEO_HIER_SK DATE_SK');
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('SALES_MIX_DAY_OF_WEEK',1,0,0,null,'GEO_HIER_SK PROD_HIER_SK DAY_OF_WEEK');
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('SCORE_DATA',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('SCORING_PARAM',1,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('SCORING_PARAM_UNCAPPED',1,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('SCORING_PARAM_AVG',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('SCORING_PARAM_CONFIG',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('SCORING_PARAM_DEFAULT',1,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('SIZESET',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('SIZESET_MBR',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('STORE_CATEGORY',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('STORE_CATEGORY_MBR',0,0,0,null,'GEO_HIER_SK STORE_CATEGORY_ID');
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('STORE_EXCLUDED',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('STR_GRP_MBR',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('TARGET_METRICS',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('TREND_SEASONALITY',1,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('UNACC_DISCOUNT',1,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('VEHICLE_SUPPORT_MAP',1,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('VEHICLE_SUPPORT_MAP_PREV',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER) VALUES ('VENDOR',1,0,0,null,null);
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID764696;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID764696;
%put ERROR- Description                              : Adding new columns etl_stg2dm & sort_order to table_partition_meta.;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 04JUL2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID764696;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID764696",
"Adding new columns etl_stg2dm & sort_order to table_partition_meta.",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID764696:;
 
 
* End of changes for CHANGE_ID:ID764696;
 
 
***********************************************************************************************;
*************************************  End Change ID764696 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID763266 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID763266;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID763266")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID763266;
%goto ID763266;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID763266;
* Insert record into change management table for CHANGE_ID: ID763266;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID763266",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID763266;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
ALTER TABLE PKO_BUY ADD ALLOW_PRIOR_DELIVERY_PACKS INTEGER
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE PKO_DELIVERY ADD ALLOW_PRIOR_DELIVERY_PACKS INTEGER
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE PKO_PACK_PRODUCT_SETTING ADD ALLOW_PRIOR_DELIVERY_PACKS INTEGER
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
ALTER TABLE PKO_BUY ADD ALLOW_PRIOR_DELIVERY_PACKS INTEGER ;
 
 
ALTER TABLE PKO_DELIVERY ADD ALLOW_PRIOR_DELIVERY_PACKS INTEGER ;
 
 
ALTER TABLE PKO_PACK_PRODUCT_SETTING ADD ALLOW_PRIOR_DELIVERY_PACKS INTEGER ;
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID763266;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID763266;
%put ERROR- Description                              : Specify Carry-over Packs;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 06JUL2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID763266;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID763266",
"Specify Carry-over Packs",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID763266:;
 
 
* End of changes for CHANGE_ID:ID763266;
 
 
***********************************************************************************************;
*************************************  End Change ID763266 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID749317_2 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID749317_2;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID749317_2")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID749317_2;
%goto ID749317_2;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID749317_2;
* Insert record into change management table for CHANGE_ID: ID749317_2;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID749317_2",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID749317_2;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
ALTER TABLE RPO_PLAN ADD APPLY_FUTURE_PROMOTIONS INTEGER
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
ALTER TABLE RPO_PLAN ADD APPLY_FUTURE_PROMOTIONS INTEGER;
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID749317_2;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID749317_2;
%put ERROR- Description                              : The system shall allow a user to optimize regular prices by accounting for future promotions.;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 04MAY2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID749317_2;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID749317_2",
"The system shall allow a user to optimize regular prices by accounting for future promotions.",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID749317_2:;
 
 
* End of changes for CHANGE_ID:ID749317_2;
 
 
***********************************************************************************************;
*************************************  End Change ID749317_2 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID0773201 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID0773201;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID0773201")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(&m_di_trans.)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_di_trans.;
%put NOTE: Change ID                             :ID0773201;
%goto ID0773201;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID0773201;
%goto ID0773201;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID0773201;
* Insert record into change management table for CHANGE_ID: ID0773201;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID0773201",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID0773201;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
%let m_sql_statement = %str(
create table REQ_SKU_STORE_MIN (
REQUEST_ID      INTEGER NOT NULL,
DELIVERY_ID     INTEGER NOT NULL,
PROD_ID         VARCHAR(32) NOT NULL,
GEO_ID          VARCHAR(32) NOT NULL,
ORDER_MIN       INTEGER NOT NULL,
PRIMARY KEY (REQUEST_ID, DELIVERY_ID, PROD_ID, GEO_ID)
)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
data &m_di_trans..REQ_SKU_STORE_MIN;
 
 
attrib REQUEST_ID   length=4;
 
 
attrib DELIVERY_ID  length=4;
 
 
attrib PROD_ID      length=$32;
 
 
attrib GEO_ID       length=$32;
 
 
attrib ORDER_MIN    length=8;
 
 
stop;
 
 
run;
 
 
proc sql;
 
 
alter table &m_di_trans..REQ_SKU_STORE_MIN add
constraint prim_key PRIMARY KEY (REQUEST_ID, DELIVERY_ID, PROD_ID, GEO_ID);
 
 
quit;
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID0773201;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID0773201;
%put ERROR- Description                              : Add Packopt Request Table REQ_SKU_STORE_MIN;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 07JUL2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID0773201;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID0773201",
"Add Packopt Request Table REQ_SKU_STORE_MIN",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID0773201:;
 
 
* End of changes for CHANGE_ID:ID0773201;
 
 
***********************************************************************************************;
*************************************  End Change ID0773201 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID763270 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID763270;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID763270")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID763270;
%goto ID763270;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID763270;
* Insert record into change management table for CHANGE_ID: ID763270;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID763270",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID763270;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
CREATE TABLE PKO_DELIVERY_TYPE (
DELIVERY_TYPE_SK INTEGER NOT NULL,
PURCHASE_ORDER_PLAN_SK INTEGER,
DELIVERY_TYPE_ID INTEGER NOT NULL,
DELIVERY_TYPE_NM VARCHAR(40),
PRIMARY KEY (DELIVERY_TYPE_SK)
)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
INSERT INTO PKO_DELIVERY_TYPE (DELIVERY_TYPE_SK, DELIVERY_TYPE_NM, DELIVERY_TYPE_ID) VALUES(100, 'Floor Set', 1)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO PKO_DELIVERY_TYPE (DELIVERY_TYPE_SK, DELIVERY_TYPE_NM, DELIVERY_TYPE_ID) VALUES(101, 'Flow One', 2)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO PKO_DELIVERY_TYPE (DELIVERY_TYPE_SK, DELIVERY_TYPE_NM, DELIVERY_TYPE_ID) VALUES(102, 'Promotion Buy', 3)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO PKO_DELIVERY_TYPE (DELIVERY_TYPE_SK, DELIVERY_TYPE_NM, DELIVERY_TYPE_ID) VALUES(103, 'Flow Two', 4)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO PKO_DELIVERY_TYPE (DELIVERY_TYPE_SK, DELIVERY_TYPE_NM, DELIVERY_TYPE_ID) VALUES(104, 'Flow Three', 5)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO PKO_DELIVERY_TYPE (DELIVERY_TYPE_SK, DELIVERY_TYPE_NM, DELIVERY_TYPE_ID) VALUES(105, 'Sell Off', 6)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO PKO_DELIVERY_TYPE (DELIVERY_TYPE_SK, DELIVERY_TYPE_NM, DELIVERY_TYPE_ID) VALUES(106, 'Transition', 7)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
CREATE SEQUENCE SEQ_DELIVERY_TYPE_SK START WITH 100000
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
ALTER TABLE PKO_DELIVERY ADD DELIVERY_TYPE_ID INTEGER
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
 
proc sql;
 
 
CREATE TABLE PKO_DELIVERY_TYPE (
DELIVERY_TYPE_SK INTEGER NOT NULL,
PURCHASE_ORDER_PLAN_SK INTEGER,
DELIVERY_TYPE_ID INTEGER NOT NULL,
DELIVERY_TYPE_NM VARCHAR(40)
) ;
 
 
ALTER TABLE PKO_DELIVERY_TYPE ADD CONSTRAINT PRIM_KEY PRIMARY KEY (DELIVERY_TYPE_SK) ;
 
 
 
INSERT INTO PKO_DELIVERY_TYPE (DELIVERY_TYPE_SK, DELIVERY_TYPE_NM, DELIVERY_TYPE_ID) VALUES(100, 'Floor Set', 1);
 
 
INSERT INTO PKO_DELIVERY_TYPE (DELIVERY_TYPE_SK, DELIVERY_TYPE_NM, DELIVERY_TYPE_ID) VALUES(101, 'Flow One', 2);
 
 
INSERT INTO PKO_DELIVERY_TYPE (DELIVERY_TYPE_SK, DELIVERY_TYPE_NM, DELIVERY_TYPE_ID) VALUES(102, 'Promotion Buy', 3);
 
 
INSERT INTO PKO_DELIVERY_TYPE (DELIVERY_TYPE_SK, DELIVERY_TYPE_NM, DELIVERY_TYPE_ID) VALUES(103, 'Flow Two', 4);
 
 
INSERT INTO PKO_DELIVERY_TYPE (DELIVERY_TYPE_SK, DELIVERY_TYPE_NM, DELIVERY_TYPE_ID) VALUES(104, 'Flow Three', 5);
 
 
INSERT INTO PKO_DELIVERY_TYPE (DELIVERY_TYPE_SK, DELIVERY_TYPE_NM, DELIVERY_TYPE_ID) VALUES(105, 'Sell Off', 6);
 
 
INSERT INTO PKO_DELIVERY_TYPE (DELIVERY_TYPE_SK, DELIVERY_TYPE_NM, DELIVERY_TYPE_ID) VALUES(106, 'Transition', 7);
 
 
 
ALTER TABLE PKO_DELIVERY ADD DELIVERY_TYPE_ID INTEGER;
 
 
 
quit;
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID763270;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID763270;
%put ERROR- Description                              : Determine Packs Across Deliveries;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 07JUL2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID763270;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID763270",
"Determine Packs Across Deliveries",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID763270:;
 
 
* End of changes for CHANGE_ID:ID763270;
 
 
***********************************************************************************************;
*************************************  End Change ID763270 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change DROP_NOT_NULL_CLUSTER_ID ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: DROP_NOT_NULL_CLUSTER_ID;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("DROP_NOT_NULL_CLUSTER_ID")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : DROP_NOT_NULL_CLUSTER_ID;
%goto DROP_NOT_NULL_CLUSTER_ID;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : DROP_NOT_NULL_CLUSTER_ID;
* Insert record into change management table for CHANGE_ID: DROP_NOT_NULL_CLUSTER_ID;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"DROP_NOT_NULL_CLUSTER_ID",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto DROP_NOT_NULL_CLUSTER_ID;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
ALTER TABLE REQ_PROD_GEO_PROFILE MODIFY (CLUSTER_ID NULL)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
 
%di_util_drop_constraint(m_lib=di_trans, m_table=REQ_PROD_GEO_PROFILE, m_column=%str(CLUSTER_ID), m_constraint=%str(not null));
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: DROP_NOT_NULL_CLUSTER_ID;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: DROP_NOT_NULL_CLUSTER_ID;
%put ERROR- Description                              : Drop NOT NULL Constraint on CLUSTER_ID;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 14JUL2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: DROP_NOT_NULL_CLUSTER_ID;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"DROP_NOT_NULL_CLUSTER_ID",
"Drop NOT NULL Constraint on CLUSTER_ID",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%DROP_NOT_NULL_CLUSTER_ID:;
 
 
* End of changes for CHANGE_ID:DROP_NOT_NULL_CLUSTER_ID;
 
 
***********************************************************************************************;
*************************************  End Change DROP_NOT_NULL_CLUSTER_ID ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID774840 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID774840;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID774840")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_trans..MODEL_SPEC_DEFAULT))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_trans..MODEL_SPEC_DEFAULT;
%put NOTE: Change ID                             :ID774840;
%goto ID774840;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID774840;
%goto ID774840;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID774840;
* Insert record into change management table for CHANGE_ID: ID774840;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID774840",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID774840;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
UPDATE MODEL_SPEC_DEFAULT SET DEFAULT_SPEC_VALUE = '0' WHERE SPEC_NM = 'PS_1'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
UPDATE MODEL_SPEC_DEFAULT SET DEFAULT_SPEC_VALUE = '0' WHERE SPEC_NM = 'PS_1';
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID774840;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID774840;
%put ERROR- Description                              : Update default value for PS_xx specs;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 17JUL2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID774840;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID774840",
"Update default value for PS_xx specs",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID774840:;
 
 
* End of changes for CHANGE_ID:ID774840;
 
 
***********************************************************************************************;
*************************************  End Change ID774840 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change RENAME_PRIMARY_KEY_02 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: RENAME_PRIMARY_KEY_02;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("RENAME_PRIMARY_KEY_02")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : RENAME_PRIMARY_KEY_02;
%goto RENAME_PRIMARY_KEY_02;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : RENAME_PRIMARY_KEY_02;
* Insert record into change management table for CHANGE_ID: RENAME_PRIMARY_KEY_02;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"RENAME_PRIMARY_KEY_02",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto RENAME_PRIMARY_KEY_02;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
 
 
%di_util_rename_pk(m_table_name=%str(RPO_PLAN_RESULT),              m_pk_name=%str(RPO_PLAN_RESULT_PK));
 
 
%di_util_rename_pk(m_table_name=%str(RPO_PLAN_MEMBER_RESULT),       m_pk_name=%str(RPO_PLAN_MEMBER_RESULT_PK));
 
 
%di_util_rename_pk(m_table_name=%str(RPO_PLAN_MEMBER_RESULT_KPI),   m_pk_name=%str(RPO_PLAN_MEMBER_RESULT_KPI_PK));
 
 
%di_util_rename_pk(m_table_name=%str(RPO_PLAN_MEMBER_AGG),          m_pk_name=%str(RPO_PLAN_MEMBER_AGG_PK));
 
 
%di_util_rename_pk(m_table_name=%str(RPO_GEO_PROD_AGG),             m_pk_name=%str(RPO_GEO_PROD_AGG_PK));
 
 
%di_util_rename_pk(m_table_name=%str(COMP_PRICE_RULE_RESULT),       m_pk_name=%str(COMP_PRICE_RULE_RESULT_PK));
 
 
%di_util_rename_pk(m_table_name=%str(MARGIN_RULE_RESULT),           m_pk_name=%str(MARGIN_RULE_RESULT_PK));
 
 
%di_util_rename_pk(m_table_name=%str(MIN_MAX_RULE_RESULT),          m_pk_name=%str(MIN_MAX_RULE_RESULT_PK));
 
 
%di_util_rename_pk(m_table_name=%str(PRICING_RELN_RULE_RESULT),     m_pk_name=%str(PRICING_RELN_RULE_RESULT_PK));
 
 
%di_util_rename_pk(m_table_name=%str(GRID_RULE_RESULT),             m_pk_name=%str(GRID_RULE_RESULT_PK));
 
 
%di_util_rename_pk(m_table_name=%str(SAME_PRICE_SET_RELN),          m_pk_name=%str(SAME_PRICE_SET_RELN_PK));
 
 
%di_util_rename_pk(m_table_name=%str(SAME_PRICE_SET),               m_pk_name=%str(SAME_PRICE_SET_PK));
 
 
%di_util_rename_pk(m_table_name=%str(PROCESS_MESSAGE_DETAIL),       m_pk_name=%str(PROCESS_MESSAGE_DETAIL_PK));
 
 
%di_util_rename_pk(m_table_name=%str(RPP_PLAN_PROD_ASGMNT),         m_pk_name=%str(RPP_PLAN_PROD_ASGMNT_PK));
 
 
%di_util_rename_pk(m_table_name=%str(CUSTOM_ATTR),                  m_pk_name=%str(CUSTOM_ATTR_PK));
 
 
%di_util_rename_pk(m_table_name=%str(RPP_PLAN_METRIC),              m_pk_name=%str(RPP_PLAN_METRIC_PK));
 
 
%di_util_rename_pk(m_table_name=%str(RPP_PLAN_PROD_METRICS),        m_pk_name=%str(RPP_PLAN_PROD_METRICS_PK));
 
 
%di_util_rename_pk(m_table_name=%str(RPP_NOTIFICATION),             m_pk_name=%str(RPP_NOTIFICATION_PK));
 
 
%di_util_rename_pk(m_table_name=%str(PROCESS_MESSAGE_DETAIL),       m_pk_name=%str(PROCESS_MESSAGE_DETAIL_PK));
 
 
%di_util_rename_pk(m_table_name=%str(AGGREGATION_METRICS),          m_pk_name=%str(AGGREGATION_METRICS_PK));
 
 
%di_util_rename_pk(m_table_name=%str(RPP_PLAN_OPT_SETTING),         m_pk_name=%str(RPP_PLAN_OPT_SETTING_PK));
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
*  Do not rename primary keys since performance is very slow and renaming is of no use. ;
 
proc sql;
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: RENAME_PRIMARY_KEY_02;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: RENAME_PRIMARY_KEY_02;
%put ERROR- Description                              : Rename primary keys;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 14JUL2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: RENAME_PRIMARY_KEY_02;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"RENAME_PRIMARY_KEY_02",
"Rename primary keys",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%RENAME_PRIMARY_KEY_02:;
 
 
* End of changes for CHANGE_ID:RENAME_PRIMARY_KEY_02;
 
 
***********************************************************************************************;
*************************************  End Change RENAME_PRIMARY_KEY_02 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change PRF_COPY_SIZESET_CHG ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: PRF_COPY_SIZESET_CHG;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("PRF_COPY_SIZESET_CHG")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : PRF_COPY_SIZESET_CHG;
%goto PRF_COPY_SIZESET_CHG;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : PRF_COPY_SIZESET_CHG;
* Insert record into change management table for CHANGE_ID: PRF_COPY_SIZESET_CHG;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"PRF_COPY_SIZESET_CHG",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto PRF_COPY_SIZESET_CHG;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
ALTER TABLE PRF_SIZESET DROP COLUMN USER_MODIFIED_FLG
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE PRF_SIZESET ADD COPIED_FLG INTEGER
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE PRF_PLAN ADD COPIED_FLG INTEGER
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
ALTER TABLE PRF_SIZESET DROP COLUMN USER_MODIFIED_FLG;
 
 
ALTER TABLE PRF_SIZESET ADD COPIED_FLG INTEGER;
 
 
ALTER TABLE PRF_PLAN ADD COPIED_FLG INTEGER;
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: PRF_COPY_SIZESET_CHG;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: PRF_COPY_SIZESET_CHG;
%put ERROR- Description                              : Size Profiling 32 Schema changes part 4;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 14JUL2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: PRF_COPY_SIZESET_CHG;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"PRF_COPY_SIZESET_CHG",
"Size Profiling 32 Schema changes part 4",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%PRF_COPY_SIZESET_CHG:;
 
 
* End of changes for CHANGE_ID:PRF_COPY_SIZESET_CHG;
 
 
***********************************************************************************************;
*************************************  End Change PRF_COPY_SIZESET_CHG ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID776254 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID776254;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID776254")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID776254;
%goto ID776254;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52,M2MI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID776254;
* Insert record into change management table for CHANGE_ID: ID776254;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID776254",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID776254;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
INSERT INTO vehicle_category (VEHICLE_CATEGORY_SK,VEHICLE_CATEGORY_NM,VEHICLE_CATEGORY_DESC, ACTIVE_FLG, PRICE_FLG, VEHICLE_CATEGORY_TYPE)
VALUES  (40, 'CustomPrice1', 'Custom Price', 0, 2, 'PRICE')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO vehicle_category (VEHICLE_CATEGORY_SK,VEHICLE_CATEGORY_NM,VEHICLE_CATEGORY_DESC, ACTIVE_FLG, PRICE_FLG, VEHICLE_CATEGORY_TYPE)
VALUES  (41, 'CustomPrice2', 'Custom Price', 0, 2, 'PRICE')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO vehicle_category (VEHICLE_CATEGORY_SK,VEHICLE_CATEGORY_NM,VEHICLE_CATEGORY_DESC, ACTIVE_FLG, PRICE_FLG, VEHICLE_CATEGORY_TYPE)
VALUES  (42, 'CustomPrice3', 'Custom Price', 0, 2, 'PRICE')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO vehicle_category (VEHICLE_CATEGORY_SK,VEHICLE_CATEGORY_NM,VEHICLE_CATEGORY_DESC, ACTIVE_FLG, PRICE_FLG, VEHICLE_CATEGORY_TYPE)
VALUES  (43, 'CustomPrice4', 'Custom Price', 0, 2, 'PRICE')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO vehicle_category (VEHICLE_CATEGORY_SK,VEHICLE_CATEGORY_NM,VEHICLE_CATEGORY_DESC, ACTIVE_FLG, PRICE_FLG, VEHICLE_CATEGORY_TYPE)
VALUES  (44, 'CustomPrice5', 'Custom Price', 0, 2, 'PRICE')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO vehicle_category (VEHICLE_CATEGORY_SK,VEHICLE_CATEGORY_NM,VEHICLE_CATEGORY_DESC, ACTIVE_FLG, PRICE_FLG, VEHICLE_CATEGORY_TYPE)
VALUES  (45, 'CustomPrice6', 'Custom Price', 0, 2, 'PRICE')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO vehicle_category (VEHICLE_CATEGORY_SK,VEHICLE_CATEGORY_NM,VEHICLE_CATEGORY_DESC, ACTIVE_FLG, PRICE_FLG, VEHICLE_CATEGORY_TYPE)
VALUES  (46, 'CustomPrice7', 'Custom Price', 0, 2, 'PRICE')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO vehicle_category (VEHICLE_CATEGORY_SK,VEHICLE_CATEGORY_NM,VEHICLE_CATEGORY_DESC, ACTIVE_FLG, PRICE_FLG, VEHICLE_CATEGORY_TYPE)
VALUES  (47, 'CustomPrice8', 'Custom Price', 0, 2, 'PRICE')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO vehicle_category (VEHICLE_CATEGORY_SK,VEHICLE_CATEGORY_NM,VEHICLE_CATEGORY_DESC, ACTIVE_FLG, PRICE_FLG, VEHICLE_CATEGORY_TYPE)
VALUES  (48, 'CustomPrice9', 'Custom Price', 0, 2, 'PRICE')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO vehicle_category (VEHICLE_CATEGORY_SK,VEHICLE_CATEGORY_NM,VEHICLE_CATEGORY_DESC, ACTIVE_FLG, PRICE_FLG, VEHICLE_CATEGORY_TYPE)
VALUES  (49, 'CustomPrice10', 'Custom Price', 0, 2, 'PRICE')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-140, 40, 7,'Value',     '0', 1)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-141, 40, 7,'ValueType', '1', 3)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-142, 41, 7,'Value',     '0', 1)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-143, 41, 7,'ValueType', '1', 3)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-144, 42, 7,'Value',     '0', 1)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-145, 42, 7,'ValueType', '1', 3)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-146, 43, 7,'Value',     '0', 1)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-147, 43, 7,'ValueType', '1', 3)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-148, 44, 7,'Value',     '0', 1)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-149, 44, 7,'ValueType', '1', 3)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-150, 45, 7,'Value',     '0', 1)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-151, 45, 7,'ValueType', '1', 3)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-152, 46, 7,'Value',     '0', 1)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-153, 46, 7,'ValueType', '1', 3)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-154, 47, 7,'Value',     '0', 1)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-155, 47, 7,'ValueType', '1', 3)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-156, 48, 7,'Value',     '0', 1)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-157, 48, 7,'ValueType', '1', 3)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-158, 49, 7,'Value',     '0', 1)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-159, 49, 7,'ValueType', '1', 3)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
INSERT INTO vehicle_category (VEHICLE_CATEGORY_SK,VEHICLE_CATEGORY_NM,VEHICLE_CATEGORY_DESC, ACTIVE_FLG, PRICE_FLG, VEHICLE_CATEGORY_TYPE)
VALUES  (40, 'CustomPrice1', 'Custom Price', 0, 2, 'PRICE');
 
 
INSERT INTO vehicle_category (VEHICLE_CATEGORY_SK,VEHICLE_CATEGORY_NM,VEHICLE_CATEGORY_DESC, ACTIVE_FLG, PRICE_FLG, VEHICLE_CATEGORY_TYPE)
VALUES  (41, 'CustomPrice2', 'Custom Price', 0, 2, 'PRICE');
 
 
INSERT INTO vehicle_category (VEHICLE_CATEGORY_SK,VEHICLE_CATEGORY_NM,VEHICLE_CATEGORY_DESC, ACTIVE_FLG, PRICE_FLG, VEHICLE_CATEGORY_TYPE)
VALUES  (42, 'CustomPrice3', 'Custom Price', 0, 2, 'PRICE');
 
 
INSERT INTO vehicle_category (VEHICLE_CATEGORY_SK,VEHICLE_CATEGORY_NM,VEHICLE_CATEGORY_DESC, ACTIVE_FLG, PRICE_FLG, VEHICLE_CATEGORY_TYPE)
VALUES  (43, 'CustomPrice4', 'Custom Price', 0, 2, 'PRICE');
 
 
INSERT INTO vehicle_category (VEHICLE_CATEGORY_SK,VEHICLE_CATEGORY_NM,VEHICLE_CATEGORY_DESC, ACTIVE_FLG, PRICE_FLG, VEHICLE_CATEGORY_TYPE)
VALUES  (44, 'CustomPrice5', 'Custom Price', 0, 2, 'PRICE');
 
 
INSERT INTO vehicle_category (VEHICLE_CATEGORY_SK,VEHICLE_CATEGORY_NM,VEHICLE_CATEGORY_DESC, ACTIVE_FLG, PRICE_FLG, VEHICLE_CATEGORY_TYPE)
VALUES  (45, 'CustomPrice6', 'Custom Price', 0, 2, 'PRICE');
 
 
INSERT INTO vehicle_category (VEHICLE_CATEGORY_SK,VEHICLE_CATEGORY_NM,VEHICLE_CATEGORY_DESC, ACTIVE_FLG, PRICE_FLG, VEHICLE_CATEGORY_TYPE)
VALUES  (46, 'CustomPrice7', 'Custom Price', 0, 2, 'PRICE');
 
 
INSERT INTO vehicle_category (VEHICLE_CATEGORY_SK,VEHICLE_CATEGORY_NM,VEHICLE_CATEGORY_DESC, ACTIVE_FLG, PRICE_FLG, VEHICLE_CATEGORY_TYPE)
VALUES  (47, 'CustomPrice8', 'Custom Price', 0, 2, 'PRICE');
 
 
INSERT INTO vehicle_category (VEHICLE_CATEGORY_SK,VEHICLE_CATEGORY_NM,VEHICLE_CATEGORY_DESC, ACTIVE_FLG, PRICE_FLG, VEHICLE_CATEGORY_TYPE)
VALUES  (48, 'CustomPrice9', 'Custom Price', 0, 2, 'PRICE');
 
 
INSERT INTO vehicle_category (VEHICLE_CATEGORY_SK,VEHICLE_CATEGORY_NM,VEHICLE_CATEGORY_DESC, ACTIVE_FLG, PRICE_FLG, VEHICLE_CATEGORY_TYPE)
VALUES  (49, 'CustomPrice10', 'Custom Price', 0, 2, 'PRICE');
 
 
 
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-140, 40, 7,'Value',     '0', 1);
 
 
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-141, 40, 7,'ValueType', '1', 3);
 
 
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-142, 41, 7,'Value',     '0', 1);
 
 
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-143, 41, 7,'ValueType', '1', 3);
 
 
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-144, 42, 7,'Value',     '0', 1);
 
 
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-145, 42, 7,'ValueType', '1', 3);
 
 
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-146, 43, 7,'Value',     '0', 1);
 
 
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-147, 43, 7,'ValueType', '1', 3);
 
 
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-148, 44, 7,'Value',     '0', 1);
 
 
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-149, 44, 7,'ValueType', '1', 3);
 
 
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-150, 45, 7,'Value',     '0', 1);
 
 
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-151, 45, 7,'ValueType', '1', 3);
 
 
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-152, 46, 7,'Value',     '0', 1);
 
 
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-153, 46, 7,'ValueType', '1', 3);
 
 
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-154, 47, 7,'Value',     '0', 1);
 
 
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-155, 47, 7,'ValueType', '1', 3);
 
 
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-156, 48, 7,'Value',     '0', 1);
 
 
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-157, 48, 7,'ValueType', '1', 3);
 
 
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-158, 49, 7,'Value',     '0', 1);
 
 
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-159, 49, 7,'ValueType', '1', 3);
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID776254;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID776254;
%put ERROR- Description                              : Custom Price Type support;
%put ERROR- Version                                  : D3MICM52,M2MI42;
%put ERROR- Date of Change                           : 11JUL2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID776254;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID776254",
"Custom Price Type support",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID776254:;
 
 
* End of changes for CHANGE_ID:ID776254;
 
 
***********************************************************************************************;
*************************************  End Change ID776254 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID776757 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID776757;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID776757")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID776757;
%goto ID776757;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID776757;
* Insert record into change management table for CHANGE_ID: ID776757;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID776757",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID776757;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE)) %then %do;
 
%let m_sql_statement = %str(
ALTER TABLE FA_SCORING_RANGE_RULE RENAME COLUMN VALUE TO RULE_VALUE
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
 
proc datasets library=&m_di_trans nolist;
 
 
modify FA_SCORING_RANGE_RULE ;
 
 
rename VALUE=RULE_VALUE;
 
 
quit;
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (DB2)) %then %do;
 
%let m_sql_statement = %str(
ALTER TABLE FA_SCORING_RANGE_RULE DROP COLUMN VALUE
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE FA_SCORING_RANGE_RULE ADD  COLUMN RULE_VALUE NUMERIC(12,4)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
REORG TABLE FA_SCORING_RANGE_RULE
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID776757;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID776757;
%put ERROR- Description                              : Rename column value to rule_value in FA_SCORING_RANGE_RULE;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 21JUL2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID776757;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID776757",
"Rename column value to rule_value in FA_SCORING_RANGE_RULE",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID776757:;
 
 
* End of changes for CHANGE_ID:ID776757;
 
 
***********************************************************************************************;
*************************************  End Change ID776757 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID776757_1 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID776757_1;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID776757_1")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID776757_1;
%goto ID776757_1;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID776757_1;
* Insert record into change management table for CHANGE_ID: ID776757_1;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID776757_1",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID776757_1;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE)) %then %do;
 
%let m_sql_statement = %str(
ALTER TABLE FA_SCORING_RANGE_RULE RENAME COLUMN RULE_VALUE TO RANGE_VALUE
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
 
proc datasets library=&m_di_trans nolist;
 
 
modify FA_SCORING_RANGE_RULE ;
 
 
rename RULE_VALUE=RANGE_VALUE;
 
 
quit;
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (DB2)) %then %do;
 
%let m_sql_statement = %str(
ALTER TABLE FA_SCORING_RANGE_RULE DROP COLUMN RULE_VALUE
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE FA_SCORING_RANGE_RULE ADD  COLUMN RANGE_VALUE NUMERIC(12,4)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
REORG TABLE FA_SCORING_RANGE_RULE
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID776757_1;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID776757_1;
%put ERROR- Description                              : Rename column rule_value to range_value in FA_SCORING_RANGE_RULE;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 21JUL2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID776757_1;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID776757_1",
"Rename column rule_value to range_value in FA_SCORING_RANGE_RULE",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID776757_1:;
 
 
* End of changes for CHANGE_ID:ID776757_1;
 
 
***********************************************************************************************;
*************************************  End Change ID776757_1 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID753658 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID753658;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID753658")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID753658;
%goto ID753658;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID753658;
* Insert record into change management table for CHANGE_ID: ID753658;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID753658",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID753658;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
ALTER TABLE PROCESS_STATUS ADD PROCESS_WEIGHT INTEGER DEFAULT 0
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
 
proc sql;
 
 
alter table &m_di_trans..PROCESS_STATUS add PROCESS_WEIGHT num 4;
 
 
update &m_di_trans..PROCESS_STATUS set PROCESS_WEIGHT=0;
 
 
quit;
 
 
 
proc sql;
 
 
alter table &m_di_trans..PROCESS_STATUS add NOT NULL (PROCESS_WEIGHT);
 
 
quit;
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID753658;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID753658;
%put ERROR- Description                              : Data Mapping Algorithm That Takes The Number Of Active Plan Members Into Account...;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 04MAY2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID753658;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID753658",
"Data Mapping Algorithm That Takes The Number Of Active Plan Members Into Account...",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID753658:;
 
 
* End of changes for CHANGE_ID:ID753658;
 
 
***********************************************************************************************;
*************************************  End Change ID753658 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID777046 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID777046;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID777046")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID777046;
%goto ID777046;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID777046;
* Insert record into change management table for CHANGE_ID: ID777046;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID777046",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID777046;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
ALTER TABLE PKO_PACK_TOTAL ADD NUM_STORES INTEGER DEFAULT 0 NOT NULL
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
 
proc sql;
 
 
alter table &m_di_trans..PKO_PACK_TOTAL ADD NUM_STORES INTEGER ;
 
 
update &m_di_trans..PKO_PACK_TOTAL set NUM_STORES=0;
 
 
quit;
 
 
 
proc sql;
 
 
alter table &m_di_trans..PKO_PACK_TOTAL add NOT NULL (NUM_STORES);
 
 
quit;
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID777046;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID777046;
%put ERROR- Description                              : Show store totals in pack totals view;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 21JUL2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID777046;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID777046",
"Show store totals in pack totals view",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID777046:;
 
 
* End of changes for CHANGE_ID:ID777046;
 
 
***********************************************************************************************;
*************************************  End Change ID777046 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID776254_2 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID776254_2;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID776254_2")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID776254_2;
%goto ID776254_2;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52,M2MI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID776254_2;
* Insert record into change management table for CHANGE_ID: ID776254_2;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID776254_2",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID776254_2;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
delete from vehicle_category where vehicle_category_sk >= 40 and vehicle_category_sk <=49
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
INSERT INTO vehicle_category (VEHICLE_CATEGORY_SK,VEHICLE_CATEGORY_NM,VEHICLE_CATEGORY_DESC, ACTIVE_FLG, PRICE_FLG, VEHICLE_CATEGORY_TYPE)
VALUES  (40, 'Custom1', 'Custom Price', 0, 2, 'PRICE')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO vehicle_category (VEHICLE_CATEGORY_SK,VEHICLE_CATEGORY_NM,VEHICLE_CATEGORY_DESC, ACTIVE_FLG, PRICE_FLG, VEHICLE_CATEGORY_TYPE)
VALUES  (41, 'Custom2', 'Custom Price', 0, 2, 'PRICE')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO vehicle_category (VEHICLE_CATEGORY_SK,VEHICLE_CATEGORY_NM,VEHICLE_CATEGORY_DESC, ACTIVE_FLG, PRICE_FLG, VEHICLE_CATEGORY_TYPE)
VALUES  (42, 'Custom3', 'Custom Price', 0, 2, 'PRICE')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO vehicle_category (VEHICLE_CATEGORY_SK,VEHICLE_CATEGORY_NM,VEHICLE_CATEGORY_DESC, ACTIVE_FLG, PRICE_FLG, VEHICLE_CATEGORY_TYPE)
VALUES  (43, 'Custom4', 'Custom Price', 0, 2, 'PRICE')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO vehicle_category (VEHICLE_CATEGORY_SK,VEHICLE_CATEGORY_NM,VEHICLE_CATEGORY_DESC, ACTIVE_FLG, PRICE_FLG, VEHICLE_CATEGORY_TYPE)
VALUES  (44, 'Custom5', 'Custom Price', 0, 2, 'PRICE')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO vehicle_category (VEHICLE_CATEGORY_SK,VEHICLE_CATEGORY_NM,VEHICLE_CATEGORY_DESC, ACTIVE_FLG, PRICE_FLG, VEHICLE_CATEGORY_TYPE)
VALUES  (45, 'Custom6', 'Custom Price', 0, 2, 'PRICE')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO vehicle_category (VEHICLE_CATEGORY_SK,VEHICLE_CATEGORY_NM,VEHICLE_CATEGORY_DESC, ACTIVE_FLG, PRICE_FLG, VEHICLE_CATEGORY_TYPE)
VALUES  (46, 'Custom7', 'Custom Price', 0, 2, 'PRICE')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO vehicle_category (VEHICLE_CATEGORY_SK,VEHICLE_CATEGORY_NM,VEHICLE_CATEGORY_DESC, ACTIVE_FLG, PRICE_FLG, VEHICLE_CATEGORY_TYPE)
VALUES  (47, 'Custom8', 'Custom Price', 0, 2, 'PRICE')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO vehicle_category (VEHICLE_CATEGORY_SK,VEHICLE_CATEGORY_NM,VEHICLE_CATEGORY_DESC, ACTIVE_FLG, PRICE_FLG, VEHICLE_CATEGORY_TYPE)
VALUES  (48, 'Custom9', 'Custom Price', 0, 2, 'PRICE')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO vehicle_category (VEHICLE_CATEGORY_SK,VEHICLE_CATEGORY_NM,VEHICLE_CATEGORY_DESC, ACTIVE_FLG, PRICE_FLG, VEHICLE_CATEGORY_TYPE)
VALUES  (49, 'Custom0', 'Custom Price', 0, 2, 'PRICE')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
delete from CAT_CUSTOM_ATTR where CAT_CUSTOM_ATTR_SK <= -140 and CAT_CUSTOM_ATTR_SK >= -159
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-140, 40, 7,'Value',         '0', 2)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-141, 40, 7,'ValueType',     '1', 2)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-142, 40, 7,'PriceConflict', '1', 2)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-143, 41, 7,'Value',         '0', 2)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-144, 41, 7,'ValueType',     '1', 2)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-145, 41, 7,'PriceConflict', '1', 2)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-146, 42, 7,'Value',         '0', 2)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-147, 42, 7,'ValueType',     '1', 2)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-148, 42, 7,'PriceConflict', '1', 2)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-149, 43, 7,'Value',         '0', 2)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-150, 43, 7,'ValueType',     '1', 2)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-151, 43, 7,'PriceConflict', '1', 2)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-152, 44, 7,'Value',         '0', 2)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-153, 44, 7,'ValueType',     '1', 2)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-154, 44, 7,'PriceConflict', '1', 2)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-155, 45, 7,'Value',         '0', 2)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-156, 45, 7,'ValueType',     '1', 2)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-157, 45, 7,'PriceConflict', '1', 2)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-158, 46, 7,'Value',         '0', 2)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-159, 46, 7,'ValueType',     '1', 2)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-160, 46, 7,'PriceConflict', '1', 2)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-161, 47, 7,'Value',         '0', 2)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-162, 47, 7,'ValueType',     '1', 2)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-163, 47, 7,'PriceConflict', '1', 2)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-164, 48, 7,'Value',         '0', 2)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-165, 48, 7,'ValueType',     '1', 2)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-166, 48, 7,'PriceConflict', '1', 2)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-167, 49, 7,'Value',         '0', 2)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-168, 49, 7,'ValueType',     '1', 2)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-169, 49, 7,'PriceConflict', '1', 2)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
delete from vehicle_category where vehicle_category_sk >= 40 and vehicle_category_sk <=49;
 
 
 
INSERT INTO vehicle_category (VEHICLE_CATEGORY_SK,VEHICLE_CATEGORY_NM,VEHICLE_CATEGORY_DESC, ACTIVE_FLG, PRICE_FLG, VEHICLE_CATEGORY_TYPE)
VALUES  (40, 'Custom1', 'Custom Price', 0, 2, 'PRICE');
 
 
INSERT INTO vehicle_category (VEHICLE_CATEGORY_SK,VEHICLE_CATEGORY_NM,VEHICLE_CATEGORY_DESC, ACTIVE_FLG, PRICE_FLG, VEHICLE_CATEGORY_TYPE)
VALUES  (41, 'Custom2', 'Custom Price', 0, 2, 'PRICE');
 
 
INSERT INTO vehicle_category (VEHICLE_CATEGORY_SK,VEHICLE_CATEGORY_NM,VEHICLE_CATEGORY_DESC, ACTIVE_FLG, PRICE_FLG, VEHICLE_CATEGORY_TYPE)
VALUES  (42, 'Custom3', 'Custom Price', 0, 2, 'PRICE');
 
 
INSERT INTO vehicle_category (VEHICLE_CATEGORY_SK,VEHICLE_CATEGORY_NM,VEHICLE_CATEGORY_DESC, ACTIVE_FLG, PRICE_FLG, VEHICLE_CATEGORY_TYPE)
VALUES  (43, 'Custom4', 'Custom Price', 0, 2, 'PRICE');
 
 
INSERT INTO vehicle_category (VEHICLE_CATEGORY_SK,VEHICLE_CATEGORY_NM,VEHICLE_CATEGORY_DESC, ACTIVE_FLG, PRICE_FLG, VEHICLE_CATEGORY_TYPE)
VALUES  (44, 'Custom5', 'Custom Price', 0, 2, 'PRICE');
 
 
INSERT INTO vehicle_category (VEHICLE_CATEGORY_SK,VEHICLE_CATEGORY_NM,VEHICLE_CATEGORY_DESC, ACTIVE_FLG, PRICE_FLG, VEHICLE_CATEGORY_TYPE)
VALUES  (45, 'Custom6', 'Custom Price', 0, 2, 'PRICE');
 
 
INSERT INTO vehicle_category (VEHICLE_CATEGORY_SK,VEHICLE_CATEGORY_NM,VEHICLE_CATEGORY_DESC, ACTIVE_FLG, PRICE_FLG, VEHICLE_CATEGORY_TYPE)
VALUES  (46, 'Custom7', 'Custom Price', 0, 2, 'PRICE');
 
 
INSERT INTO vehicle_category (VEHICLE_CATEGORY_SK,VEHICLE_CATEGORY_NM,VEHICLE_CATEGORY_DESC, ACTIVE_FLG, PRICE_FLG, VEHICLE_CATEGORY_TYPE)
VALUES  (47, 'Custom8', 'Custom Price', 0, 2, 'PRICE');
 
 
INSERT INTO vehicle_category (VEHICLE_CATEGORY_SK,VEHICLE_CATEGORY_NM,VEHICLE_CATEGORY_DESC, ACTIVE_FLG, PRICE_FLG, VEHICLE_CATEGORY_TYPE)
VALUES  (48, 'Custom9', 'Custom Price', 0, 2, 'PRICE');
 
 
INSERT INTO vehicle_category (VEHICLE_CATEGORY_SK,VEHICLE_CATEGORY_NM,VEHICLE_CATEGORY_DESC, ACTIVE_FLG, PRICE_FLG, VEHICLE_CATEGORY_TYPE)
VALUES  (49, 'Custom0', 'Custom Price', 0, 2, 'PRICE');
 
 
 
delete from CAT_CUSTOM_ATTR where CAT_CUSTOM_ATTR_SK <= -140 and CAT_CUSTOM_ATTR_SK >= -159;
 
 
 
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-140, 40, 7,'Value',         '0', 2);
 
 
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-141, 40, 7,'ValueType',     '1', 2);
 
 
INSERT INTO CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-142, 40, 7,'PriceConflict', '1', 2);
 
 
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-143, 41, 7,'Value',         '0', 2);
 
 
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-144, 41, 7,'ValueType',     '1', 2);
 
 
INSERT INTO CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-145, 41, 7,'PriceConflict', '1', 2);
 
 
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-146, 42, 7,'Value',         '0', 2);
 
 
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-147, 42, 7,'ValueType',     '1', 2);
 
 
INSERT INTO CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-148, 42, 7,'PriceConflict', '1', 2);
 
 
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-149, 43, 7,'Value',         '0', 2);
 
 
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-150, 43, 7,'ValueType',     '1', 2);
 
 
INSERT INTO CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-151, 43, 7,'PriceConflict', '1', 2);
 
 
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-152, 44, 7,'Value',         '0', 2);
 
 
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-153, 44, 7,'ValueType',     '1', 2);
 
 
INSERT INTO CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-154, 44, 7,'PriceConflict', '1', 2);
 
 
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-155, 45, 7,'Value',         '0', 2);
 
 
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-156, 45, 7,'ValueType',     '1', 2);
 
 
INSERT INTO CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-157, 45, 7,'PriceConflict', '1', 2);
 
 
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-158, 46, 7,'Value',         '0', 2);
 
 
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-159, 46, 7,'ValueType',     '1', 2);
 
 
INSERT INTO CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-160, 46, 7,'PriceConflict', '1', 2);
 
 
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-161, 47, 7,'Value',         '0', 2);
 
 
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-162, 47, 7,'ValueType',     '1', 2);
 
 
INSERT INTO CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-163, 47, 7,'PriceConflict', '1', 2);
 
 
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-164, 48, 7,'Value',         '0', 2);
 
 
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-165, 48, 7,'ValueType',     '1', 2);
 
 
INSERT INTO CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-166, 48, 7,'PriceConflict', '1', 2);
 
 
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-167, 49, 7,'Value',         '0', 2);
 
 
insert into CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-168, 49, 7,'ValueType',     '1', 2);
 
 
INSERT INTO CAT_CUSTOM_ATTR  (CAT_CUSTOM_ATTR_SK, OBJECT_CAT_SK, OBJECT_CAT_TYPE, ATTR_NM, ATTR_DEFAULT_VALUE, ATTR_VALUE_TYPE) VALUES  (-169, 49, 7,'PriceConflict', '1', 2);
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID776254_2;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID776254_2;
%put ERROR- Description                              : Custom Price Type support;
%put ERROR- Version                                  : D3MICM52,M2MI42;
%put ERROR- Date of Change                           : 22JUL2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID776254_2;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID776254_2",
"Custom Price Type support",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID776254_2:;
 
 
* End of changes for CHANGE_ID:ID776254_2;
 
 
***********************************************************************************************;
*************************************  End Change ID776254_2 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID773092 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID773092;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID773092")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID773092;
%goto ID773092;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID773092;
* Insert record into change management table for CHANGE_ID: ID773092;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID773092",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID773092;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
UPDATE RPP_PLAN set OBJECTIVE_SK = SCOPE_SK where OBJECTIVE_SK is NULL
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
UPDATE RPP_PLAN set OBJECTIVE_SK = SCOPE_SK where OBJECTIVE_SK is NULL;
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID773092;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID773092;
%put ERROR- Description                              : Update Objective_SK to scope_SK in RPP_PLAN where objective_SK is null;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 21JUL2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID773092;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID773092",
"Update Objective_SK to scope_SK in RPP_PLAN where objective_SK is null",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID773092:;
 
 
* End of changes for CHANGE_ID:ID773092;
 
 
***********************************************************************************************;
*************************************  End Change ID773092 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID772003 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID772003;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID772003")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID772003;
%goto ID772003;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52,M2MI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID772003;
* Insert record into change management table for CHANGE_ID: ID772003;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID772003",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID772003;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
alter table RPP_VENDOR_DEAL add STATE_CD INTEGER
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
alter table RPP_VENDOR_DEAL add STATE_CD INTEGER;
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID772003;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID772003;
%put ERROR- Description                              : Vendor deals on regional plans;
%put ERROR- Version                                  : D3MICM52,M2MI42;
%put ERROR- Date of Change                           : 26JUL2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID772003;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID772003",
"Vendor deals on regional plans",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID772003:;
 
 
* End of changes for CHANGE_ID:ID772003;
 
 
***********************************************************************************************;
*************************************  End Change ID772003 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID778001 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID778001;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID778001")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID778001;
%goto ID778001;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52,M2MI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID778001;
* Insert record into change management table for CHANGE_ID: ID778001;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID778001",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID778001;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
ALTER TABLE RPP_PLAN ADD FCST_UNITS_ADJUST_TYPE INTEGER
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
ALTER TABLE RPP_PLAN ADD FCST_UNITS_ADJUST_TYPE INTEGER;
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID778001;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID778001;
%put ERROR- Description                              : SUPPORT FOR FORECAST OVERRIDE EXTENSIONS;
%put ERROR- Version                                  : D3MICM52,M2MI42;
%put ERROR- Date of Change                           : 28JUL2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID778001;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID778001",
"SUPPORT FOR FORECAST OVERRIDE EXTENSIONS",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID778001:;
 
 
* End of changes for CHANGE_ID:ID778001;
 
 
***********************************************************************************************;
*************************************  End Change ID778001 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID778944 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID778944;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID778944")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_trans..MODEL_SPEC_DEFAULT))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_trans..MODEL_SPEC_DEFAULT;
%put NOTE: Change ID                             :ID778944;
%goto ID778944;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID778944;
%goto ID778944;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID778944;
* Insert record into change management table for CHANGE_ID: ID778944;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID778944",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID778944;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'LCP_CURVE_TYPE'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'LCP_CURVE_TYPE';
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID778944;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID778944;
%put ERROR- Description                              : Drop model spec LCP_CURVE_TYPE;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 28JUL2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID778944;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID778944",
"Drop model spec LCP_CURVE_TYPE",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID778944:;
 
 
* End of changes for CHANGE_ID:ID778944;
 
 
***********************************************************************************************;
*************************************  End Change ID778944 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID778947 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID778947;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID778947")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_trans..MODEL_SPEC_DEFAULT))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_trans..MODEL_SPEC_DEFAULT;
%put NOTE: Change ID                             :ID778947;
%goto ID778947;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID778947;
%goto ID778947;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID778947;
* Insert record into change management table for CHANGE_ID: ID778947;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID778947",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID778947;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'LCP_FACTOR_UPPER_BOUND'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
values ('LCP_FACTOR_UPPER_BOUND','ALL','1','100',NULL)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
values ('LCP_FACTOR_UPPER_BOUND','ALL','2','100',NULL)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'LCP_FACTOR_UPPER_BOUND';
 
 
insert into MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
values ('LCP_FACTOR_UPPER_BOUND','ALL','1','100',NULL);
 
 
insert into MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
values ('LCP_FACTOR_UPPER_BOUND','ALL','2','100',NULL);
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID778947;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID778947;
%put ERROR- Description                              : Add model spec LCP_FACTOR_UPPER_BOUND;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 28JUL2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID778947;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID778947",
"Add model spec LCP_FACTOR_UPPER_BOUND",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID778947:;
 
 
* End of changes for CHANGE_ID:ID778947;
 
 
***********************************************************************************************;
*************************************  End Change ID778947 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID779284 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID779284;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID779284")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID779284;
%goto ID779284;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID779284;
* Insert record into change management table for CHANGE_ID: ID779284;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID779284",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID779284;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
alter table MDO_PLAN modify PRICE_VALUE_LIST VARCHAR(1000)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
alter table MDO_PLAN modify PRICE_VALUE_LIST VARCHAR(1000);
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID779284;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID779284;
%put ERROR- Description                              : Increase PRICE_VALUE_LIST in MDO_PLAN to hold enough values for price ranges;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 28JUL2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID779284;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID779284",
"Increase PRICE_VALUE_LIST in MDO_PLAN to hold enough values for price ranges",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID779284:;
 
 
* End of changes for CHANGE_ID:ID779284;
 
 
***********************************************************************************************;
*************************************  End Change ID779284 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID779284_1 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID779284_1;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID779284_1")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID779284_1;
%goto ID779284_1;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID779284_1;
* Insert record into change management table for CHANGE_ID: ID779284_1;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID779284_1",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID779284_1;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
alter table PRICE_GRID add PRICE_VALUE_SUMMARY_LIST VARCHAR(1000)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
alter table PRICE_GRID add PRICE_VALUE_SUMMARY_LIST VARCHAR(1000);
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID779284_1;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID779284_1;
%put ERROR- Description                              : Add PRICE_VALUE_RANGE_LIST to PRICE_GRID which will be summary of price range;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 29JUL2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID779284_1;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID779284_1",
"Add PRICE_VALUE_RANGE_LIST to PRICE_GRID which will be summary of price range",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID779284_1:;
 
 
* End of changes for CHANGE_ID:ID779284_1;
 
 
***********************************************************************************************;
*************************************  End Change ID779284_1 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID779284MIG ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID779284MIG;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID779284MIG")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID779284MIG;
%goto ID779284MIG;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID779284MIG;
* Insert record into change management table for CHANGE_ID: ID779284MIG;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID779284MIG",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID779284MIG;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
 
proc sql;
 
 
create table work.price_grid_summary as
select pr.price_grid_sk,
pr.price_range_start_val,
pr.price_range_end_val,
pr.price_disc_value_list
from &m_di_trans..price_grid pg,
&m_di_trans..price_grid_range pr
where pg.used_by_app = 1
and pr.price_grid_sk = pg.price_grid_sk
and pg.price_value_type in (1,2)
order by pr.price_grid_sk;
 
 
quit;
 
 
 
data work.price_grid_summary;
 
 
set work.price_grid_summary;
 
 
by price_grid_sk;
 
 
attrib price_value_summary_list length=$1000;
 
 
retain price_value_summary_list '';
 
 
 
if first.price_grid_sk then price_value_summary_list = '';
 
 
 
if not missing(price_disc_value_list);
 
 
 
if first.price_grid_sk and last.price_grid_sk then do;
 
 
price_value_summary_list = price_disc_value_list;
 
 
end;
 
 
else do;
 
 
if first.price_grid_sk or (not last.price_grid_sk) then
price_value_summary_list = cats(price_value_summary_list,price_disc_value_list,':',left(put(price_range_end_val,22.2)),'|');
 
 
if last.price_grid_sk then
price_value_summary_list = cats(price_value_summary_list,price_disc_value_list);
 
 
end;
 
 
if last.price_grid_sk then output;
 
 
drop price_range_start_val price_range_end_val price_disc_value_list;
 
 
run;
 
 
 
%di_dm_trans_update(
upload_lib=work,
upload_table=price_grid_summary,
update_table=price_grid,
sql= %str(update &m_di_trans..price_grid pg set price_value_summary_list = (SELECT price_value_summary_list
FROM work.price_grid_summary ps WHERE pg.price_grid_sk = ps.price_grid_sk))
);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
 
proc sql;
 
 
create table work.price_grid_summary as
select pr.price_grid_sk,
pr.price_range_start_val,
pr.price_range_end_val,
pr.price_disc_value_list
from &m_di_trans..price_grid pg,
&m_di_trans..price_grid_range pr
where pg.used_by_app = 1
and pr.price_grid_sk = pg.price_grid_sk
and pg.price_value_type in (1,2)
order by pr.price_grid_sk;
 
 
quit;
 
 
 
data work.price_grid_summary;
 
 
set work.price_grid_summary;
 
 
by price_grid_sk;
 
 
attrib price_value_summary_list length=$1000;
 
 
retain price_value_summary_list '';
 
 
 
if first.price_grid_sk then price_value_summary_list = '';
 
 
 
if not missing(price_disc_value_list);
 
 
 
if first.price_grid_sk and last.price_grid_sk then do;
 
 
price_value_summary_list = price_disc_value_list;
 
 
end;
 
 
else do;
 
 
if first.price_grid_sk or (not last.price_grid_sk) then
price_value_summary_list = cats(price_value_summary_list,price_disc_value_list,':',left(put(price_range_end_val,22.2)),'|');
 
 
if last.price_grid_sk then
price_value_summary_list = cats(price_value_summary_list,price_disc_value_list);
 
 
end;
 
 
if last.price_grid_sk then output;
 
 
drop price_range_start_val price_range_end_val price_disc_value_list;
 
 
run;
 
 
 
%di_dm_trans_update(
upload_lib=work,
upload_table=price_grid_summary,
update_table=price_grid,
sql= %str(update &m_di_trans..price_grid pg set price_value_summary_list = (SELECT price_value_summary_list
FROM work.price_grid_summary ps WHERE pg.price_grid_sk = ps.price_grid_sk))
);
 
 
 
 
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID779284MIG;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID779284MIG;
%put ERROR- Description                              : Add PRICE_VALUE_RANGE_LIST to PRICE_GRID which will be summary of price range;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 29JUL2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID779284MIG;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID779284MIG",
"Add PRICE_VALUE_RANGE_LIST to PRICE_GRID which will be summary of price range",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID779284MIG:;
 
 
* End of changes for CHANGE_ID:ID779284MIG;
 
 
***********************************************************************************************;
*************************************  End Change ID779284MIG ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID742165 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID742165;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID742165")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID742165;
%goto ID742165;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID742165;
* Insert record into change management table for CHANGE_ID: ID742165;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID742165",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID742165;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
 
%let m_sql_statement = %str(
CREATE TABLE ATTRIBUTE
(
ATTR_SK   INTEGER NOT NULL,
ATTR_NM   VARCHAR(40) NOT NULL,
ATTR_TYPE INTEGER
)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%let m_sql_statement = %str(
ALTER TABLE ATTRIBUTE ADD CONSTRAINT ATTRIBUTE_PK PRIMARY KEY (ATTR_SK)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
 
proc sql;
 
 
 
CREATE TABLE ATTRIBUTE
(
ATTR_SK   INTEGER NOT NULL,
ATTR_NM   VARCHAR(40) NOT NULL,
ATTR_TYPE INTEGER
)    ;
 
 
 
 
ALTER TABLE ATTRIBUTE ADD CONSTRAINT PRIM_KEY PRIMARY KEY (ATTR_SK) ;
 
 
 
quit;
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID742165;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID742165;
%put ERROR- Description                              : Add replicate table ATTRIBUTE into transact schema for Product Search;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 01AUG2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID742165;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID742165",
"Add replicate table ATTRIBUTE into transact schema for Product Search",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID742165:;
 
 
* End of changes for CHANGE_ID:ID742165;
 
 
***********************************************************************************************;
*************************************  End Change ID742165 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID742165_2 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID742165_2;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID742165_2")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(&m_di_data.)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_di_data.;
%put NOTE: Change ID                             :ID742165_2;
%goto ID742165_2;
 
%end;
%if not (%sysfunc(exist(&m_di_data..ATTRIBUTE))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_data..ATTRIBUTE;
%put NOTE: Change ID                             :ID742165_2;
%goto ID742165_2;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID742165_2;
%goto ID742165_2;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID742165_2;
* Insert record into change management table for CHANGE_ID: ID742165_2;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID742165_2",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID742165_2;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
 
 
proc sql noprint;
 
 
select count(*)
into :_cnt_ATTRIBUTE
from &m_di_trans..ATTRIBUTE
;
 
 
quit;
 
 
 
%if &_cnt_ATTRIBUTE = 0 %then
%do;
 
 
 
 
%di_dm_trans_append
(
di_trans=&m_di_trans.,
trans_table=ATTRIBUTE,
append_table=&m_di_data..ATTRIBUTE,
bulkload=1
);
 
 
 
 
%end;
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
 
 
proc sql noprint;
 
 
select count(*)
into :_cnt_ATTRIBUTE
from &m_di_trans..ATTRIBUTE
;
 
 
quit;
 
 
 
%if &_cnt_ATTRIBUTE = 0 %then
%do;
 
 
 
 
%di_dm_trans_append
(
di_trans=&m_di_trans.,
trans_table=ATTRIBUTE,
append_table=&m_di_data..ATTRIBUTE,
bulkload=1
);
 
 
 
 
%end;
 
 
 
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID742165_2;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID742165_2;
%put ERROR- Description                              : Get data for ATTRIBUTE table;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 01AUG2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID742165_2;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID742165_2",
"Get data for ATTRIBUTE table",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID742165_2:;
 
 
* End of changes for CHANGE_ID:ID742165_2;
 
 
***********************************************************************************************;
*************************************  End Change ID742165_2 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change CPY_PROD_GEO_ATTRS ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: CPY_PROD_GEO_ATTRS;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("CPY_PROD_GEO_ATTRS")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(&m_di_data.)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_di_data.;
%put NOTE: Change ID                             :CPY_PROD_GEO_ATTRS;
%goto CPY_PROD_GEO_ATTRS;
 
%end;
%if not (%sysfunc(exist(&m_di_data..PRODUCT_ATTRIBUTES))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_data..PRODUCT_ATTRIBUTES;
%put NOTE: Change ID                             :CPY_PROD_GEO_ATTRS;
%goto CPY_PROD_GEO_ATTRS;
 
%end;
%if not (%sysfunc(exist(&m_di_data..GEOGRAPHY_ATTRIBUTES))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_data..GEOGRAPHY_ATTRIBUTES;
%put NOTE: Change ID                             :CPY_PROD_GEO_ATTRS;
%goto CPY_PROD_GEO_ATTRS;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : CPY_PROD_GEO_ATTRS;
%goto CPY_PROD_GEO_ATTRS;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : CPY_PROD_GEO_ATTRS;
* Insert record into change management table for CHANGE_ID: CPY_PROD_GEO_ATTRS;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"CPY_PROD_GEO_ATTRS",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto CPY_PROD_GEO_ATTRS;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
 
proc sql noprint;
 
 
select count(*)
into :_cnt_prod_ATTRIBUTE
from &m_di_trans..PRODUCT_ATTRIBUTES
;
 
 
quit;
 
 
 
%if &_cnt_prod_ATTRIBUTE = 0 %then
%do;
 
 
 
 
%di_dm_trans_append
(
di_trans=&m_di_trans.,
trans_table=product_attributes,
append_table=&m_di_data..product_attributes,
bulkload=1
);
 
 
 
 
%end;
 
 
 
proc sql noprint;
 
 
select count(*)
into :_cnt_geo_ATTRIBUTE
from &m_di_trans..GEOGRAPHY_ATTRIBUTES
;
 
 
quit;
 
 
 
%if &_cnt_geo_ATTRIBUTE = 0 %then
%do;
 
 
 
 
%di_dm_trans_append
(
di_trans=&m_di_trans.,
trans_table=GEOGRAPHY_ATTRIBUTES,
append_table=&m_di_data..GEOGRAPHY_ATTRIBUTES,
bulkload=1
);
 
 
 
 
%end;
 
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
 
proc sql noprint;
 
 
select count(*)
into :_cnt_prod_ATTRIBUTE
from &m_di_trans..PRODUCT_ATTRIBUTES
;
 
 
quit;
 
 
 
%if &_cnt_prod_ATTRIBUTE = 0 %then
%do;
 
 
 
 
%di_dm_trans_append
(
di_trans=&m_di_trans.,
trans_table=product_attributes,
append_table=&m_di_data..product_attributes,
bulkload=1
);
 
 
 
 
%end;
 
 
 
proc sql noprint;
 
 
select count(*)
into :_cnt_geo_ATTRIBUTE
from &m_di_trans..GEOGRAPHY_ATTRIBUTES
;
 
 
quit;
 
 
 
%if &_cnt_geo_ATTRIBUTE = 0 %then
%do;
 
 
 
 
%di_dm_trans_append
(
di_trans=&m_di_trans.,
trans_table=GEOGRAPHY_ATTRIBUTES,
append_table=&m_di_data..GEOGRAPHY_ATTRIBUTES,
bulkload=1
);
 
 
 
 
%end;
 
 
 
 
 
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: CPY_PROD_GEO_ATTRS;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: CPY_PROD_GEO_ATTRS;
%put ERROR- Description                              : Get data for PRODUCT_ATTRIBUTES and GEOGRAPHY_ATTRIBUTES;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 01AUG2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: CPY_PROD_GEO_ATTRS;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"CPY_PROD_GEO_ATTRS",
"Get data for PRODUCT_ATTRIBUTES and GEOGRAPHY_ATTRIBUTES",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%CPY_PROD_GEO_ATTRS:;
 
 
* End of changes for CHANGE_ID:CPY_PROD_GEO_ATTRS;
 
 
***********************************************************************************************;
*************************************  End Change CPY_PROD_GEO_ATTRS ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID780082 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID780082;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID780082")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_trans..MODEL_SPEC_DEFAULT))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_trans..MODEL_SPEC_DEFAULT;
%put NOTE: Change ID                             :ID780082;
%goto ID780082;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID780082;
%goto ID780082;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID780082;
* Insert record into change management table for CHANGE_ID: ID780082;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID780082",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID780082;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'DAILY_FCST_METHOD'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'DAILY_FCST_METHOD';
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID780082;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID780082;
%put ERROR- Description                              : Remove model spec DAILY_FCST_METHOD;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 02AUG2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID780082;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID780082",
"Remove model spec DAILY_FCST_METHOD",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID780082:;
 
 
* End of changes for CHANGE_ID:ID780082;
 
 
***********************************************************************************************;
*************************************  End Change ID780082 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID780102 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID780102;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID780102")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID780102;
%goto ID780102;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID780102;
* Insert record into change management table for CHANGE_ID: ID780102;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID780102",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID780102;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
alter table FCST_EXPORT_INPUT add DAILY_MODEL INTEGER
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
alter table FCST_EXPORT_INPUT add DAILY_OUTPUT INTEGER
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
alter table FCST_EXPORT_INPUT add DAILY_MODEL INTEGER ;
 
 
alter table FCST_EXPORT_INPUT add DAILY_OUTPUT INTEGER ;
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID780102;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID780102;
%put ERROR- Description                              : Add DAILY_MODEL and DAILY_OUTPUT columns to FCST_EXPORT_INPUT table;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 03AUG2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID780102;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID780102",
"Add DAILY_MODEL and DAILY_OUTPUT columns to FCST_EXPORT_INPUT table",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID780102:;
 
 
* End of changes for CHANGE_ID:ID780102;
 
 
***********************************************************************************************;
*************************************  End Change ID780102 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID760260_2 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID760260_2;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID760260_2")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(&m_di_trans.)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_di_trans.;
%put NOTE: Change ID                             :ID760260_2;
%goto ID760260_2;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID760260_2;
%goto ID760260_2;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID760260_2;
* Insert record into change management table for CHANGE_ID: ID760260_2;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID760260_2",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID760260_2;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
update  GEO_PROD_SETTING set SETTING_CEIL = 1.0 where GEO_PROD_SETTING_SK = 20032
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
update  GEO_PROD_SETTING set SETTING_CEIL = 1.0 where GEO_PROD_SETTING_SK = 20032;
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID760260_2;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID760260_2;
%put ERROR- Description                              : DEFAULT OPTIMIZATION SETTINGS...correcting default value;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 02AUG2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID760260_2;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID760260_2",
"DEFAULT OPTIMIZATION SETTINGS...correcting default value",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID760260_2:;
 
 
* End of changes for CHANGE_ID:ID760260_2;
 
 
***********************************************************************************************;
*************************************  End Change ID760260_2 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID781186 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID781186;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID781186")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID781186;
%goto ID781186;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID781186;
* Insert record into change management table for CHANGE_ID: ID781186;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID781186",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID781186;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'RUN_MDO_ANALYSIS'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from FA_SPEC where SPEC_NM = 'RUN_MDO_ANALYSIS'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'RUN_MDO_ANALYSIS';
 
 
delete from FA_SPEC where SPEC_NM = 'RUN_MDO_ANALYSIS';
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID781186;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID781186;
%put ERROR- Description                              : Remove FA spec Remove FA spec RUN_MDO_ANALYSIS;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 05AUG2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID781186;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID781186",
"Remove FA spec Remove FA spec RUN_MDO_ANALYSIS",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID781186:;
 
 
* End of changes for CHANGE_ID:ID781186;
 
 
***********************************************************************************************;
*************************************  End Change ID781186 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID778001_2 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID778001_2;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID778001_2")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID778001_2;
%goto ID778001_2;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52,M2MI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID778001_2;
* Insert record into change management table for CHANGE_ID: ID778001_2;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID778001_2",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID778001_2;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
ALTER TABLE RPP_PLAN_PROD_ASGMNT ADD FCST_UNITS_ADJUST_TYPE INTEGER
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE RPP_PLAN_PROD_ASGMNT ADD FCST_UNITS_ADJUST NUMERIC(20,3)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
ALTER TABLE RPP_PLAN_PROD_ASGMNT ADD FCST_UNITS_ADJUST_TYPE INTEGER;
 
 
ALTER TABLE RPP_PLAN_PROD_ASGMNT ADD FCST_UNITS_ADJUST NUMERIC(20,3);
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID778001_2;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID778001_2;
%put ERROR- Description                              : SUPPORT FOR FORECAST OVERRIDE EXTENSIONS;
%put ERROR- Version                                  : D3MICM52,M2MI42;
%put ERROR- Date of Change                           : 28JUL2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID778001_2;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID778001_2",
"SUPPORT FOR FORECAST OVERRIDE EXTENSIONS",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID778001_2:;
 
 
* End of changes for CHANGE_ID:ID778001_2;
 
 
***********************************************************************************************;
*************************************  End Change ID778001_2 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ADD_GEO_PROD_RPP_TABLE ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ADD_GEO_PROD_RPP_TABLE;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ADD_GEO_PROD_RPP_TABLE")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(&m_di_trans.)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_di_trans.;
%put NOTE: Change ID                             :ADD_GEO_PROD_RPP_TABLE;
%goto ADD_GEO_PROD_RPP_TABLE;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ADD_GEO_PROD_RPP_TABLE;
%goto ADD_GEO_PROD_RPP_TABLE;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ADD_GEO_PROD_RPP_TABLE;
* Insert record into change management table for CHANGE_ID: ADD_GEO_PROD_RPP_TABLE;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ADD_GEO_PROD_RPP_TABLE",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ADD_GEO_PROD_RPP_TABLE;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
%let m_sql_statement = %str(
create table GEO_PROD_RPP (
PROD_HIER_SK                INTEGER NOT NULL,
GEO_HIER_SK                 INTEGER NOT NULL,
PLAN_SK                     INTEGER NOT NULL,
REGULAR_PRICE               NUMERIC(20,3),
COST                        NUMERIC(20,3),
MIN_VENDOR_DEAL_COST        NUMERIC(20,3),
MAX_VENDOR_DEAL_COST        NUMERIC(20,3),
MIN_PROMOTION_PRICE         NUMERIC(20,3),
MAX_PROMOTION_PRICE         NUMERIC(20,3),
BASE_SALES_UNITS            NUMERIC(20,3),
BASE_SALES_AMT              NUMERIC(20,3),
BASE_COST_AMT               NUMERIC(20,3),
FCST_SALES_UNITS            NUMERIC(20,3),
FCST_SALES_AMT              NUMERIC(20,3),
FCST_COST_AMT               NUMERIC(20,3),
ACTUAL_SALES_UNITS          NUMERIC(20,3),
ACTUAL_SALES_AMT            NUMERIC(20,3),
ACTUAL_COST_AMT             NUMERIC(20,3)
)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
ALTER TABLE GEO_PROD_RPP ADD CONSTRAINT GEO_PROD_RPP_PK PRIMARY KEY (PROD_HIER_SK,GEO_HIER_SK,PLAN_SK)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
create table GEO_PROD_RPP (
PROD_HIER_SK                INTEGER NOT NULL,
GEO_HIER_SK                 INTEGER NOT NULL,
PLAN_SK                     INTEGER NOT NULL,
REGULAR_PRICE               NUMERIC(20,3),
COST                        NUMERIC(20,3),
MIN_VENDOR_DEAL_COST        NUMERIC(20,3),
MAX_VENDOR_DEAL_COST        NUMERIC(20,3),
MIN_PROMOTION_PRICE         NUMERIC(20,3),
MAX_PROMOTION_PRICE         NUMERIC(20,3),
BASE_SALES_UNITS            NUMERIC(20,3),
BASE_SALES_AMT              NUMERIC(20,3),
BASE_COST_AMT               NUMERIC(20,3),
FCST_SALES_UNITS            NUMERIC(20,3),
FCST_SALES_AMT              NUMERIC(20,3),
FCST_COST_AMT               NUMERIC(20,3),
ACTUAL_SALES_UNITS          NUMERIC(20,3),
ACTUAL_SALES_AMT            NUMERIC(20,3),
ACTUAL_COST_AMT             NUMERIC(20,3)
);
 
 
 
ALTER TABLE GEO_PROD_RPP ADD CONSTRAINT GEO_PROD_RPP_PK PRIMARY KEY (PROD_HIER_SK,GEO_HIER_SK,PLAN_SK) ;
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ADD_GEO_PROD_RPP_TABLE;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ADD_GEO_PROD_RPP_TABLE;
%put ERROR- Description                              : New export tables/fields for Promotion Optimization to support report data mart;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 04AUG2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ADD_GEO_PROD_RPP_TABLE;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ADD_GEO_PROD_RPP_TABLE",
"New export tables/fields for Promotion Optimization to support report data mart",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ADD_GEO_PROD_RPP_TABLE:;
 
 
* End of changes for CHANGE_ID:ADD_GEO_PROD_RPP_TABLE;
 
 
***********************************************************************************************;
*************************************  End Change ADD_GEO_PROD_RPP_TABLE ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID781517 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID781517;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID781517")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_trans..MODEL_SPEC_DEFAULT))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_trans..MODEL_SPEC_DEFAULT;
%put NOTE: Change ID                             :ID781517;
%goto ID781517;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID781517;
%goto ID781517;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID781517;
* Insert record into change management table for CHANGE_ID: ID781517;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID781517",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID781517;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'COMPUTE_BASELINE_OFFSET'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
values ('COMPUTE_BASELINE_OFFSET','ALL','1','0',NULL)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
values ('COMPUTE_BASELINE_OFFSET','ALL','2','0',NULL)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'COMPUTE_BASELINE_OFFSET';
 
 
insert into MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
values ('COMPUTE_BASELINE_OFFSET','ALL','1','0',NULL);
 
 
insert into MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
values ('COMPUTE_BASELINE_OFFSET','ALL','2','0',NULL);
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID781517;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID781517;
%put ERROR- Description                              : Add model spec COMPUTE_BASELINE_OFFSET;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 08AUG2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID781517;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID781517",
"Add model spec COMPUTE_BASELINE_OFFSET",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID781517:;
 
 
* End of changes for CHANGE_ID:ID781517;
 
 
***********************************************************************************************;
*************************************  End Change ID781517 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID781306 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID781306;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID781306")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_trans..MODEL_SPEC_DEFAULT))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_trans..MODEL_SPEC_DEFAULT;
%put NOTE: Change ID                             :ID781306;
%goto ID781306;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID781306;
%goto ID781306;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID781306;
* Insert record into change management table for CHANGE_ID: ID781306;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID781306",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID781306;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'DEREG_TOLERANCE_FACTOR'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
values ('DEREG_TOLERANCE_FACTOR','ALL','-1','3',NULL)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'DEREG_TOLERANCE_FACTOR_MINOBS'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
values ('DEREG_TOLERANCE_FACTOR_MINOBS','ALL','-1','12',NULL)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'DEREG_MIN_FACTOR'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
values ('DEREG_MIN_FACTOR','ALL','-1','0.001',NULL)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'DEREG_TOLERANCE_FACTOR';
 
 
insert into MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
values ('DEREG_TOLERANCE_FACTOR','ALL','-1','3',NULL);
 
 
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'DEREG_TOLERANCE_FACTOR_MINOBS';
 
 
insert into MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
values ('DEREG_TOLERANCE_FACTOR_MINOBS','ALL','-1','12',NULL);
 
 
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'DEREG_MIN_FACTOR';
 
 
insert into MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
values ('DEREG_MIN_FACTOR','ALL','-1','0.001',NULL);
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID781306;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID781306;
%put ERROR- Description                              : Add model specs DEREG_TOLERANCE_FACTOR, DEREG_TOLERANCE_FACTOR_MINOBS and DEREG_MIN_FACTOR;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 08AUG2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID781306;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID781306",
"Add model specs DEREG_TOLERANCE_FACTOR, DEREG_TOLERANCE_FACTOR_MINOBS and DEREG_MIN_FACTOR",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID781306:;
 
 
* End of changes for CHANGE_ID:ID781306;
 
 
***********************************************************************************************;
*************************************  End Change ID781306 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID781663 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID781663;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID781663")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_trans..MODEL_SPEC_DEFAULT))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_trans..MODEL_SPEC_DEFAULT;
%put NOTE: Change ID                             :ID781663;
%goto ID781663;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID781663;
%goto ID781663;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID781663;
* Insert record into change management table for CHANGE_ID: ID781663;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID781663",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID781663;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'BASELINE_CF_PR1'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
values ('BASELINE_CF_PR1','ALL','1','1.00',NULL)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
values ('BASELINE_CF_PR1','ALL','2','1.00',NULL)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'USE_BASELINE_CF'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
values ('USE_BASELINE_CF','ALL','1','1',NULL)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
values ('USE_BASELINE_CF','ALL','2','1',NULL)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'BASELINE_CF_PR1';
 
 
insert into MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
values ('BASELINE_CF_PR1','ALL','1','1.00',NULL);
 
 
insert into MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
values ('BASELINE_CF_PR1','ALL','2','1.00',NULL);
 
 
 
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'USE_BASELINE_CF';
 
 
insert into MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
values ('USE_BASELINE_CF','ALL','1','1',NULL);
 
 
insert into MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
values ('USE_BASELINE_CF','ALL','2','1',NULL);
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID781663;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID781663;
%put ERROR- Description                              : Add model specs BASELINE_CF_PR1 and USE_BASELINE_CF;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 08AUG2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID781663;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID781663",
"Add model specs BASELINE_CF_PR1 and USE_BASELINE_CF",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID781663:;
 
 
* End of changes for CHANGE_ID:ID781663;
 
 
***********************************************************************************************;
*************************************  End Change ID781663 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID781594 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID781594;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID781594")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_trans..MODEL_SPEC_DEFAULT))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_trans..MODEL_SPEC_DEFAULT;
%put NOTE: Change ID                             :ID781594;
%goto ID781594;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID781594;
%goto ID781594;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID781594;
* Insert record into change management table for CHANGE_ID: ID781594;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID781594",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID781594;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'MIN_HIST_INV'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
values ('MIN_HIST_INV','ALL','-1','3',NULL)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'MIN_HIST_INV';
 
 
insert into MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
values ('MIN_HIST_INV','ALL','-1','3',NULL);
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID781594;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID781594;
%put ERROR- Description                              : Add model spec MIN_HIST_INV;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 08AUG2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID781594;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID781594",
"Add model spec MIN_HIST_INV",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID781594:;
 
 
* End of changes for CHANGE_ID:ID781594;
 
 
***********************************************************************************************;
*************************************  End Change ID781594 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change RENAME_COL_COPIED_FLG ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: RENAME_COL_COPIED_FLG;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("RENAME_COL_COPIED_FLG")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_trans..PRF_SIZESET))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_trans..PRF_SIZESET;
%put NOTE: Change ID                             :RENAME_COL_COPIED_FLG;
%goto RENAME_COL_COPIED_FLG;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : RENAME_COL_COPIED_FLG;
%goto RENAME_COL_COPIED_FLG;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : RENAME_COL_COPIED_FLG;
* Insert record into change management table for CHANGE_ID: RENAME_COL_COPIED_FLG;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"RENAME_COL_COPIED_FLG",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto RENAME_COL_COPIED_FLG;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
%let m_sql_statement = %str(
ALTER TABLE PRF_SIZESET RENAME COLUMN COPIED_FLG TO CUSTOM_FLG
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE PRF_PLAN RENAME COLUMN COPIED_FLG TO CUSTOM_FLG
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc datasets lib=&m_di_trans. nolist;
 
 
 
modify  PRF_SIZESET;
 
 
rename copied_flg=custom_flg;
 
 
quit;
 
 
run;
 
 
proc datasets lib=&m_di_trans. nolist;
 
 
 
modify  PRF_PLAN;
 
 
rename copied_flg=custom_flg;
 
 
quit;
 
 
run;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: RENAME_COL_COPIED_FLG;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: RENAME_COL_COPIED_FLG;
%put ERROR- Description                              : Rename COPIED_FLG;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 09AUG2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: RENAME_COL_COPIED_FLG;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"RENAME_COL_COPIED_FLG",
"Rename COPIED_FLG",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%RENAME_COL_COPIED_FLG:;
 
 
* End of changes for CHANGE_ID:RENAME_COL_COPIED_FLG;
 
 
***********************************************************************************************;
*************************************  End Change RENAME_COL_COPIED_FLG ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID782326 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID782326;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID782326")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID782326;
%goto ID782326;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID782326;
* Insert record into change management table for CHANGE_ID: ID782326;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID782326",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID782326;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'MAX_FIT_APE' and MODEL_COMP_NM = 'MA'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
values ('MAX_FIT_APE','MA','-1','1000',NULL)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'MAPE_GEO_LVL' and MODEL_COMP_NM = 'MA'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
values ('MAPE_GEO_LVL','MA','-1','1',NULL)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'MAPE_PROD_LVL' and MODEL_COMP_NM = 'MA'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
values ('MAPE_PROD_LVL','MA','-1','1',NULL)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'LAST_INSAMPLE_WEEK' and MODEL_COMP_NM = 'MA'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
values ('LAST_INSAMPLE_WEEK','MA','-1','',NULL)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'MAX_FIT_APE' and MODEL_COMP_NM = 'MA' ;
 
 
insert into MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
values ('MAX_FIT_APE','MA','-1','1000',NULL);
 
 
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'MAPE_GEO_LVL' and MODEL_COMP_NM = 'MA' ;
 
 
insert into MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
values ('MAPE_GEO_LVL','MA','-1','1',NULL);
 
 
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'MAPE_PROD_LVL' and MODEL_COMP_NM = 'MA' ;
 
 
insert into MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
values ('MAPE_PROD_LVL','MA','-1','1',NULL);
 
 
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'LAST_INSAMPLE_WEEK' and MODEL_COMP_NM = 'MA' ;
 
 
insert into MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
values ('LAST_INSAMPLE_WEEK','MA','-1','',NULL);
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID782326;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID782326;
%put ERROR- Description                              : Fix MA_SPEC_SEED missing specs and re-check MODEL_SPEC_DEFAULT;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 10AUG2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID782326;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID782326",
"Fix MA_SPEC_SEED missing specs and re-check MODEL_SPEC_DEFAULT",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID782326:;
 
 
* End of changes for CHANGE_ID:ID782326;
 
 
***********************************************************************************************;
*************************************  End Change ID782326 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID782915 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID782915;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID782915")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID782915;
%goto ID782915;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID782915;
* Insert record into change management table for CHANGE_ID: ID782915;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID782915",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID782915;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
delete from FA_SCORING_RULE
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into FA_SCORING_RULE (FA_SCORING_RULE_SK,WEIGHT,MEASURE)
values (1,0.0,'ELASTICITY_TAIL')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into FA_SCORING_RULE (FA_SCORING_RULE_SK,WEIGHT,MEASURE)
values (2,0.0,'INV_WEIGHTED_MAPE')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into FA_SCORING_RULE (FA_SCORING_RULE_SK,WEIGHT,MEASURE)
values (3,0.0,'INV_WEIGHTED_MAPE_FIT')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into FA_SCORING_RULE (FA_SCORING_RULE_SK,WEIGHT,MEASURE)
values (4,0.0,'INV_WEIGHTED_MEAN_PE')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into FA_SCORING_RULE (FA_SCORING_RULE_SK,WEIGHT,MEASURE)
values (5,0.0,'INV_WEIGHTED_MEAN_PE_FIT')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into FA_SCORING_RULE (FA_SCORING_RULE_SK,WEIGHT,MEASURE)
values (6,0.0,'MAX_HD_RMSE_FIT')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into FA_SCORING_RULE (FA_SCORING_RULE_SK,WEIGHT,MEASURE)
values (7,0.0,'MEDIAN_PE')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into FA_SCORING_RULE (FA_SCORING_RULE_SK,WEIGHT,MEASURE)
values (8,0.0,'MEDIAN_PE_FIT')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into FA_SCORING_RULE (FA_SCORING_RULE_SK,WEIGHT,MEASURE)
values (9,0.0,'PCT_ELASTICITY_DEFAULTED')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into FA_SCORING_RULE (FA_SCORING_RULE_SK,WEIGHT,MEASURE)
values (10,0.0,'REVENUE_WEIGHTED_MAPE')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into FA_SCORING_RULE (FA_SCORING_RULE_SK,WEIGHT,MEASURE)
values (11,0.0,'REVENUE_WEIGHTED_MAPE_FIT')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into FA_SCORING_RULE (FA_SCORING_RULE_SK,WEIGHT,MEASURE)
values (12,0.0,'REVENUE_WEIGHTED_MEAN_PE')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into FA_SCORING_RULE (FA_SCORING_RULE_SK,WEIGHT,MEASURE)
values (13,0.0,'REVENUE_WEIGHTED_MEAN_PE_FIT')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into FA_SCORING_RULE (FA_SCORING_RULE_SK,WEIGHT,MEASURE)
values (14,0.0,'SALES_WEIGHTED_MAPE')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into FA_SCORING_RULE (FA_SCORING_RULE_SK,WEIGHT,MEASURE)
values (15,0.0,'SALES_WEIGHTED_MAPE_FIT')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into FA_SCORING_RULE (FA_SCORING_RULE_SK,WEIGHT,MEASURE)
values (16,0.0,'SALES_WEIGHTED_MEAN_PE')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into FA_SCORING_RULE (FA_SCORING_RULE_SK,WEIGHT,MEASURE)
values (17,0.0,'SALES_WEIGHTED_MEAN_PE_FIT')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
delete from FA_SCORING_RANGE_RULE
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into FA_SCORING_RANGE_RULE (FA_SCORING_RANGE_RULE_SK,FA_SCORING_RULE_SK,RANGE_START_VALUE,RANGE_END_VALUE,RANGE_VALUE)
values (1,1,-99999999.99,99999999.99,0)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into FA_SCORING_RANGE_RULE (FA_SCORING_RANGE_RULE_SK,FA_SCORING_RULE_SK,RANGE_START_VALUE,RANGE_END_VALUE,RANGE_VALUE)
values (2,2,-99999999.99,99999999.99,0)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into FA_SCORING_RANGE_RULE (FA_SCORING_RANGE_RULE_SK,FA_SCORING_RULE_SK,RANGE_START_VALUE,RANGE_END_VALUE,RANGE_VALUE)
values (3,3,-99999999.99,99999999.99,0)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into FA_SCORING_RANGE_RULE (FA_SCORING_RANGE_RULE_SK,FA_SCORING_RULE_SK,RANGE_START_VALUE,RANGE_END_VALUE,RANGE_VALUE)
values (4,4,-99999999.99,99999999.99,0)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into FA_SCORING_RANGE_RULE (FA_SCORING_RANGE_RULE_SK,FA_SCORING_RULE_SK,RANGE_START_VALUE,RANGE_END_VALUE,RANGE_VALUE)
values (5,5,-99999999.99,99999999.99,0)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into FA_SCORING_RANGE_RULE (FA_SCORING_RANGE_RULE_SK,FA_SCORING_RULE_SK,RANGE_START_VALUE,RANGE_END_VALUE,RANGE_VALUE)
values (6,6,-99999999.99,99999999.99,0)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into FA_SCORING_RANGE_RULE (FA_SCORING_RANGE_RULE_SK,FA_SCORING_RULE_SK,RANGE_START_VALUE,RANGE_END_VALUE,RANGE_VALUE)
values (7,7,-99999999.99,99999999.99,0)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into FA_SCORING_RANGE_RULE (FA_SCORING_RANGE_RULE_SK,FA_SCORING_RULE_SK,RANGE_START_VALUE,RANGE_END_VALUE,RANGE_VALUE)
values (8,8,-99999999.99,99999999.99,0)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into FA_SCORING_RANGE_RULE (FA_SCORING_RANGE_RULE_SK,FA_SCORING_RULE_SK,RANGE_START_VALUE,RANGE_END_VALUE,RANGE_VALUE)
values (9,9,-99999999.99,99999999.99,0)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into FA_SCORING_RANGE_RULE (FA_SCORING_RANGE_RULE_SK,FA_SCORING_RULE_SK,RANGE_START_VALUE,RANGE_END_VALUE,RANGE_VALUE)
values (10,10,-99999999.99,99999999.99,0)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into FA_SCORING_RANGE_RULE (FA_SCORING_RANGE_RULE_SK,FA_SCORING_RULE_SK,RANGE_START_VALUE,RANGE_END_VALUE,RANGE_VALUE)
values (11,11,-99999999.99,99999999.99,0)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into FA_SCORING_RANGE_RULE (FA_SCORING_RANGE_RULE_SK,FA_SCORING_RULE_SK,RANGE_START_VALUE,RANGE_END_VALUE,RANGE_VALUE)
values (12,12,-99999999.99,99999999.99,0)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into FA_SCORING_RANGE_RULE (FA_SCORING_RANGE_RULE_SK,FA_SCORING_RULE_SK,RANGE_START_VALUE,RANGE_END_VALUE,RANGE_VALUE)
values (13,13,-99999999.99,99999999.99,0)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into FA_SCORING_RANGE_RULE (FA_SCORING_RANGE_RULE_SK,FA_SCORING_RULE_SK,RANGE_START_VALUE,RANGE_END_VALUE,RANGE_VALUE)
values (14,14,-99999999.99,99999999.99,0)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into FA_SCORING_RANGE_RULE (FA_SCORING_RANGE_RULE_SK,FA_SCORING_RULE_SK,RANGE_START_VALUE,RANGE_END_VALUE,RANGE_VALUE)
values (15,15,-99999999.99,99999999.99,0)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into FA_SCORING_RANGE_RULE (FA_SCORING_RANGE_RULE_SK,FA_SCORING_RULE_SK,RANGE_START_VALUE,RANGE_END_VALUE,RANGE_VALUE)
values (16,16,-99999999.99,99999999.99,0)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into FA_SCORING_RANGE_RULE (FA_SCORING_RANGE_RULE_SK,FA_SCORING_RULE_SK,RANGE_START_VALUE,RANGE_END_VALUE,RANGE_VALUE)
values (17,17,-99999999.99,99999999.99,0)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
delete from FA_SCORING_RULE;
 
 
insert into FA_SCORING_RULE (FA_SCORING_RULE_SK,WEIGHT,MEASURE)
values (1,0.0,'ELASTICITY_TAIL');
 
 
insert into FA_SCORING_RULE (FA_SCORING_RULE_SK,WEIGHT,MEASURE)
values (2,0.0,'INV_WEIGHTED_MAPE');
 
 
insert into FA_SCORING_RULE (FA_SCORING_RULE_SK,WEIGHT,MEASURE)
values (3,0.0,'INV_WEIGHTED_MAPE_FIT');
 
 
insert into FA_SCORING_RULE (FA_SCORING_RULE_SK,WEIGHT,MEASURE)
values (4,0.0,'INV_WEIGHTED_MEAN_PE');
 
 
insert into FA_SCORING_RULE (FA_SCORING_RULE_SK,WEIGHT,MEASURE)
values (5,0.0,'INV_WEIGHTED_MEAN_PE_FIT');
 
 
insert into FA_SCORING_RULE (FA_SCORING_RULE_SK,WEIGHT,MEASURE)
values (6,0.0,'MAX_HD_RMSE_FIT');
 
 
insert into FA_SCORING_RULE (FA_SCORING_RULE_SK,WEIGHT,MEASURE)
values (7,0.0,'MEDIAN_PE');
 
 
insert into FA_SCORING_RULE (FA_SCORING_RULE_SK,WEIGHT,MEASURE)
values (8,0.0,'MEDIAN_PE_FIT');
 
 
insert into FA_SCORING_RULE (FA_SCORING_RULE_SK,WEIGHT,MEASURE)
values (9,0.0,'PCT_ELASTICITY_DEFAULTED');
 
 
insert into FA_SCORING_RULE (FA_SCORING_RULE_SK,WEIGHT,MEASURE)
values (10,0.0,'REVENUE_WEIGHTED_MAPE');
 
 
insert into FA_SCORING_RULE (FA_SCORING_RULE_SK,WEIGHT,MEASURE)
values (11,0.0,'REVENUE_WEIGHTED_MAPE_FIT');
 
 
insert into FA_SCORING_RULE (FA_SCORING_RULE_SK,WEIGHT,MEASURE)
values (12,0.0,'REVENUE_WEIGHTED_MEAN_PE');
 
 
insert into FA_SCORING_RULE (FA_SCORING_RULE_SK,WEIGHT,MEASURE)
values (13,0.0,'REVENUE_WEIGHTED_MEAN_PE_FIT');
 
 
insert into FA_SCORING_RULE (FA_SCORING_RULE_SK,WEIGHT,MEASURE)
values (14,0.0,'SALES_WEIGHTED_MAPE');
 
 
insert into FA_SCORING_RULE (FA_SCORING_RULE_SK,WEIGHT,MEASURE)
values (15,0.0,'SALES_WEIGHTED_MAPE_FIT');
 
 
insert into FA_SCORING_RULE (FA_SCORING_RULE_SK,WEIGHT,MEASURE)
values (16,0.0,'SALES_WEIGHTED_MEAN_PE');
 
 
insert into FA_SCORING_RULE (FA_SCORING_RULE_SK,WEIGHT,MEASURE)
values (17,0.0,'SALES_WEIGHTED_MEAN_PE_FIT');
 
 
 
delete from FA_SCORING_RANGE_RULE;
 
 
insert into FA_SCORING_RANGE_RULE (FA_SCORING_RANGE_RULE_SK,FA_SCORING_RULE_SK,RANGE_START_VALUE,RANGE_END_VALUE,RANGE_VALUE)
values (1,1,-99999999.99,99999999.99,0);
 
 
insert into FA_SCORING_RANGE_RULE (FA_SCORING_RANGE_RULE_SK,FA_SCORING_RULE_SK,RANGE_START_VALUE,RANGE_END_VALUE,RANGE_VALUE)
values (2,2,-99999999.99,99999999.99,0);
 
 
insert into FA_SCORING_RANGE_RULE (FA_SCORING_RANGE_RULE_SK,FA_SCORING_RULE_SK,RANGE_START_VALUE,RANGE_END_VALUE,RANGE_VALUE)
values (3,3,-99999999.99,99999999.99,0);
 
 
insert into FA_SCORING_RANGE_RULE (FA_SCORING_RANGE_RULE_SK,FA_SCORING_RULE_SK,RANGE_START_VALUE,RANGE_END_VALUE,RANGE_VALUE)
values (4,4,-99999999.99,99999999.99,0);
 
 
insert into FA_SCORING_RANGE_RULE (FA_SCORING_RANGE_RULE_SK,FA_SCORING_RULE_SK,RANGE_START_VALUE,RANGE_END_VALUE,RANGE_VALUE)
values (5,5,-99999999.99,99999999.99,0);
 
 
insert into FA_SCORING_RANGE_RULE (FA_SCORING_RANGE_RULE_SK,FA_SCORING_RULE_SK,RANGE_START_VALUE,RANGE_END_VALUE,RANGE_VALUE)
values (6,6,-99999999.99,99999999.99,0);
 
 
insert into FA_SCORING_RANGE_RULE (FA_SCORING_RANGE_RULE_SK,FA_SCORING_RULE_SK,RANGE_START_VALUE,RANGE_END_VALUE,RANGE_VALUE)
values (7,7,-99999999.99,99999999.99,0);
 
 
insert into FA_SCORING_RANGE_RULE (FA_SCORING_RANGE_RULE_SK,FA_SCORING_RULE_SK,RANGE_START_VALUE,RANGE_END_VALUE,RANGE_VALUE)
values (8,8,-99999999.99,99999999.99,0);
 
 
insert into FA_SCORING_RANGE_RULE (FA_SCORING_RANGE_RULE_SK,FA_SCORING_RULE_SK,RANGE_START_VALUE,RANGE_END_VALUE,RANGE_VALUE)
values (9,9,-99999999.99,99999999.99,0);
 
 
insert into FA_SCORING_RANGE_RULE (FA_SCORING_RANGE_RULE_SK,FA_SCORING_RULE_SK,RANGE_START_VALUE,RANGE_END_VALUE,RANGE_VALUE)
values (10,10,-99999999.99,99999999.99,0);
 
 
insert into FA_SCORING_RANGE_RULE (FA_SCORING_RANGE_RULE_SK,FA_SCORING_RULE_SK,RANGE_START_VALUE,RANGE_END_VALUE,RANGE_VALUE)
values (11,11,-99999999.99,99999999.99,0);
 
 
insert into FA_SCORING_RANGE_RULE (FA_SCORING_RANGE_RULE_SK,FA_SCORING_RULE_SK,RANGE_START_VALUE,RANGE_END_VALUE,RANGE_VALUE)
values (12,12,-99999999.99,99999999.99,0);
 
 
insert into FA_SCORING_RANGE_RULE (FA_SCORING_RANGE_RULE_SK,FA_SCORING_RULE_SK,RANGE_START_VALUE,RANGE_END_VALUE,RANGE_VALUE)
values (13,13,-99999999.99,99999999.99,0);
 
 
insert into FA_SCORING_RANGE_RULE (FA_SCORING_RANGE_RULE_SK,FA_SCORING_RULE_SK,RANGE_START_VALUE,RANGE_END_VALUE,RANGE_VALUE)
values (14,14,-99999999.99,99999999.99,0);
 
 
insert into FA_SCORING_RANGE_RULE (FA_SCORING_RANGE_RULE_SK,FA_SCORING_RULE_SK,RANGE_START_VALUE,RANGE_END_VALUE,RANGE_VALUE)
values (15,15,-99999999.99,99999999.99,0);
 
 
insert into FA_SCORING_RANGE_RULE (FA_SCORING_RANGE_RULE_SK,FA_SCORING_RULE_SK,RANGE_START_VALUE,RANGE_END_VALUE,RANGE_VALUE)
values (16,16,-99999999.99,99999999.99,0);
 
 
insert into FA_SCORING_RANGE_RULE (FA_SCORING_RANGE_RULE_SK,FA_SCORING_RULE_SK,RANGE_START_VALUE,RANGE_END_VALUE,RANGE_VALUE)
values (17,17,-99999999.99,99999999.99,0);
 
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID782915;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID782915;
%put ERROR- Description                              : Seed FA_SCORING_RULE and FA_SCORING_RANGE_RULE tables;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 12AUG2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID782915;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID782915",
"Seed FA_SCORING_RULE and FA_SCORING_RANGE_RULE tables",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID782915:;
 
 
* End of changes for CHANGE_ID:ID782915;
 
 
***********************************************************************************************;
*************************************  End Change ID782915 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change DROP_INV_FLG ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: DROP_INV_FLG;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("DROP_INV_FLG")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : DROP_INV_FLG;
%goto DROP_INV_FLG;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : DROP_INV_FLG;
* Insert record into change management table for CHANGE_ID: DROP_INV_FLG;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"DROP_INV_FLG",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto DROP_INV_FLG;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
 
%let m_sql_statement = %str(
ALTER TABLE RPP_PLAN_PROD_ASGMNT DROP COLUMN INVENTORY_FLG
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
 
ALTER TABLE RPP_PLAN_PROD_ASGMNT DROP COLUMN INVENTORY_FLG;
 
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: DROP_INV_FLG;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: DROP_INV_FLG;
%put ERROR- Description                              : Drop INVENTORY_FLG column from RPP_PLAN_PROD_ASGMNT;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 15AUG2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: DROP_INV_FLG;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"DROP_INV_FLG",
"Drop INVENTORY_FLG column from RPP_PLAN_PROD_ASGMNT",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%DROP_INV_FLG:;
 
 
* End of changes for CHANGE_ID:DROP_INV_FLG;
 
 
***********************************************************************************************;
*************************************  End Change DROP_INV_FLG ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ADD_INV_FLG ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ADD_INV_FLG;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ADD_INV_FLG")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ADD_INV_FLG;
%goto ADD_INV_FLG;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ADD_INV_FLG;
* Insert record into change management table for CHANGE_ID: ADD_INV_FLG;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ADD_INV_FLG",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ADD_INV_FLG;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
ALTER TABLE RPP_PLAN_PROD_ASGMNT ADD INVENTORY_FLG INTEGER
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
ALTER TABLE RPP_PLAN_PROD_ASGMNT ADD INVENTORY_FLG INTEGER;
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ADD_INV_FLG;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ADD_INV_FLG;
%put ERROR- Description                              : Add INVENTORY_FLG column for RPP_PLAN_PROD_ASGMNT;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 17AUG2010;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ADD_INV_FLG;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ADD_INV_FLG",
"Add INVENTORY_FLG column for RPP_PLAN_PROD_ASGMNT",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ADD_INV_FLG:;
 
 
* End of changes for CHANGE_ID:ADD_INV_FLG;
 
 
***********************************************************************************************;
*************************************  End Change ADD_INV_FLG ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID783636 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID783636;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID783636")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID783636;
%goto ID783636;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID783636;
* Insert record into change management table for CHANGE_ID: ID783636;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID783636",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID783636;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'HALO_GEO_LVL'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
values ('HALO_GEO_LVL','ALL','-1','1',NULL)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'HALO_GEO_LVL';
 
 
insert into MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
values ('HALO_GEO_LVL','ALL','-1','1',NULL);
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID783636;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID783636;
%put ERROR- Description                              : Fix MA_SPEC_SEED missing specs and re-check MODEL_SPEC_DEFAULT;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 10AUG2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID783636;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID783636",
"Fix MA_SPEC_SEED missing specs and re-check MODEL_SPEC_DEFAULT",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID783636:;
 
 
* End of changes for CHANGE_ID:ID783636;
 
 
***********************************************************************************************;
*************************************  End Change ID783636 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID785355 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID785355;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID785355")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID785355;
%goto ID785355;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID785355;
* Insert record into change management table for CHANGE_ID: ID785355;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID785355",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID785355;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'FCST_IDM_FCST_LVL' and MODEL_COMP_NM = 'FCST'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'FCST_IDM_DISAGG_LVL' and MODEL_COMP_NM = 'FCST'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'FCST_IDM_MODEL' and MODEL_COMP_NM = 'FCST'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'FCST_IDM_FCST_LVL' and MODEL_COMP_NM = 'FCST';
 
 
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'FCST_IDM_DISAGG_LVL' and MODEL_COMP_NM = 'FCST';
 
 
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'FCST_IDM_MODEL' and MODEL_COMP_NM = 'FCST';
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID785355;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID785355;
%put ERROR- Description                              : Remove model specs FCST_IDM_FCST_LVL, FCST_IDM_DISAGG_LVL, FCST_IDM_MODEL;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 19AUG2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID785355;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID785355",
"Remove model specs FCST_IDM_FCST_LVL, FCST_IDM_DISAGG_LVL, FCST_IDM_MODEL",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID785355:;
 
 
* End of changes for CHANGE_ID:ID785355;
 
 
***********************************************************************************************;
*************************************  End Change ID785355 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID785283 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID785283;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID785283")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID785283;
%goto ID785283;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID785283;
* Insert record into change management table for CHANGE_ID: ID785283;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID785283",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID785283;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
update MODEL_SPEC_DEFAULT set SPEC_TYPE = '-1' where SPEC_NM = 'FCST_MINOBS' and MODEL_COMP_NM = 'FCST'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
update MODEL_SPEC_DEFAULT set SPEC_TYPE = '-1' where SPEC_NM = 'FCST_MINOBS_TREND' and MODEL_COMP_NM = 'FCST'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
update MODEL_SPEC_DEFAULT set SPEC_TYPE = '-1' where SPEC_NM = 'FCST_MINOBS' and MODEL_COMP_NM = 'FCST';
 
 
update MODEL_SPEC_DEFAULT set SPEC_TYPE = '-1' where SPEC_NM = 'FCST_MINOBS_TREND' and MODEL_COMP_NM = 'FCST';
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID785283;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID785283;
%put ERROR- Description                              : Change spec type to -1 for model specs FCST_MINOBS and FCST_MINOBS_TREND;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 19AUG2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID785283;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID785283",
"Change spec type to -1 for model specs FCST_MINOBS and FCST_MINOBS_TREND",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID785283:;
 
 
* End of changes for CHANGE_ID:ID785283;
 
 
***********************************************************************************************;
*************************************  End Change ID785283 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID767635_1 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID767635_1;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID767635_1")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID767635_1;
%goto ID767635_1;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID767635_1;
* Insert record into change management table for CHANGE_ID: ID767635_1;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID767635_1",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID767635_1;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
update MODEL_SPEC_DEFAULT set SPEC_NM = 'DOW_EVENT_GEO_AGG' where SPEC_NM = 'DOW_EVENT_PROD_AGG'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
update MODEL_SPEC set SPEC_NM = 'DOW_EVENT_GEO_AGG' where SPEC_NM = 'DOW_EVENT_PROD_AGG'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
update MODEL_SPEC_DEFAULT set SPEC_NM = 'DOW_EVENT_GEO_AGG' where SPEC_NM = 'DOW_EVENT_PROD_AGG';
 
 
update MODEL_SPEC set SPEC_NM = 'DOW_EVENT_GEO_AGG' where SPEC_NM = 'DOW_EVENT_PROD_AGG';
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID767635_1;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID767635_1;
%put ERROR- Description                              : Change DOW spec DOW_EVENT_PROD_AGG to DOW_EVENT_GEO_AGG;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 21AUG2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID767635_1;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID767635_1",
"Change DOW spec DOW_EVENT_PROD_AGG to DOW_EVENT_GEO_AGG",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID767635_1:;
 
 
* End of changes for CHANGE_ID:ID767635_1;
 
 
***********************************************************************************************;
*************************************  End Change ID767635_1 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID785810 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID785810;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID785810")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID785810;
%goto ID785810;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID785810;
* Insert record into change management table for CHANGE_ID: ID785810;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID785810",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID785810;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'FIXED_CAPPING_METHOD' and SPEC_TYPE = '2'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into MODEL_SPEC_DEFAULT (MODEL_COMP_NM,SPEC_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
values ('REG','FIXED_CAPPING_METHOD','2','ORIGIN',NULL)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'FIXED_CAPPING_METHOD' and SPEC_TYPE = '2';
 
 
insert into MODEL_SPEC_DEFAULT (MODEL_COMP_NM,SPEC_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
values ('REG','FIXED_CAPPING_METHOD','2','ORIGIN',NULL);
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID785810;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID785810;
%put ERROR- Description                              : Add FIXED_CAPPING_METHOD model spec for SHARE model;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 22AUG2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID785810;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID785810",
"Add FIXED_CAPPING_METHOD model spec for SHARE model",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID785810:;
 
 
* End of changes for CHANGE_ID:ID785810;
 
 
***********************************************************************************************;
*************************************  End Change ID785810 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID786113 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID786113;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID786113")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID786113;
%goto ID786113;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID786113;
* Insert record into change management table for CHANGE_ID: ID786113;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID786113",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID786113;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
update MODEL_SPEC_DEFAULT set DEFAULT_SPEC_VALUE = '0.3' where SPEC_NM = 'DOW_MIN_SPLIT_PCT'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
update MODEL_SPEC_DEFAULT set DEFAULT_SPEC_VALUE = '0.3' where SPEC_NM = 'DOW_MIN_SPLIT_PCT';
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID786113;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID786113;
%put ERROR- Description                              : Change DOW spec DOW_EVENT_PROD_AGG to DOW_EVENT_GEO_AGG;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 22AUG2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID786113;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID786113",
"Change DOW spec DOW_EVENT_PROD_AGG to DOW_EVENT_GEO_AGG",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID786113:;
 
 
* End of changes for CHANGE_ID:ID786113;
 
 
***********************************************************************************************;
*************************************  End Change ID786113 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change MOVE_HALO_PRODS_TO_RDBMS ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: MOVE_HALO_PRODS_TO_RDBMS;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("MOVE_HALO_PRODS_TO_RDBMS")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : MOVE_HALO_PRODS_TO_RDBMS;
%goto MOVE_HALO_PRODS_TO_RDBMS;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : MOVE_HALO_PRODS_TO_RDBMS;
* Insert record into change management table for CHANGE_ID: MOVE_HALO_PRODS_TO_RDBMS;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"MOVE_HALO_PRODS_TO_RDBMS",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto MOVE_HALO_PRODS_TO_RDBMS;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
CREATE TABLE HALO_PRODUCTS (
CAUSE_PROD_HIER_SK INTEGER NOT NULL,
EFFECT_PROD_HIER_SK INTEGER NOT NULL
)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
ALTER TABLE HALO_PRODUCTS add CONSTRAINT HALO_PRODUCTS_PK
PRIMARY KEY (CAUSE_PROD_HIER_SK, EFFECT_PROD_HIER_SK)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
CREATE TABLE HALO_PRODUCTS (
CAUSE_PROD_HIER_SK INTEGER NOT NULL,
EFFECT_PROD_HIER_SK INTEGER NOT NULL
) ;
 
 
 
ALTER TABLE HALO_PRODUCTS add CONSTRAINT HALO_PRODUCTS_PK
PRIMARY KEY (CAUSE_PROD_HIER_SK, EFFECT_PROD_HIER_SK);
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: MOVE_HALO_PRODS_TO_RDBMS;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: MOVE_HALO_PRODS_TO_RDBMS;
%put ERROR- Description                              : Move HALO_PRODUCTS Table from SAS to RDBMS;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 22AUG2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: MOVE_HALO_PRODS_TO_RDBMS;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"MOVE_HALO_PRODS_TO_RDBMS",
"Move HALO_PRODUCTS Table from SAS to RDBMS",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%MOVE_HALO_PRODS_TO_RDBMS:;
 
 
* End of changes for CHANGE_ID:MOVE_HALO_PRODS_TO_RDBMS;
 
 
***********************************************************************************************;
*************************************  End Change MOVE_HALO_PRODS_TO_RDBMS ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change XFR_DATA_FOR_HALO_PRODS ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: XFR_DATA_FOR_HALO_PRODS;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("XFR_DATA_FOR_HALO_PRODS")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(DI_TRANS)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: DI_TRANS;
%put NOTE: Change ID                             :XFR_DATA_FOR_HALO_PRODS;
%goto XFR_DATA_FOR_HALO_PRODS;
 
%end;
%if not (%sysfunc(libref(DI_DATA)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: DI_DATA;
%put NOTE: Change ID                             :XFR_DATA_FOR_HALO_PRODS;
%goto XFR_DATA_FOR_HALO_PRODS;
 
%end;
%if not (%sysfunc(exist(&m_di_data..HALO_PRODUCTS))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_data..HALO_PRODUCTS;
%put NOTE: Change ID                             :XFR_DATA_FOR_HALO_PRODS;
%goto XFR_DATA_FOR_HALO_PRODS;
 
%end;
%if not (%sysfunc(exist(&m_di_trans..HALO_PRODUCTS))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_trans..HALO_PRODUCTS;
%put NOTE: Change ID                             :XFR_DATA_FOR_HALO_PRODS;
%goto XFR_DATA_FOR_HALO_PRODS;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : XFR_DATA_FOR_HALO_PRODS;
%goto XFR_DATA_FOR_HALO_PRODS;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : XFR_DATA_FOR_HALO_PRODS;
* Insert record into change management table for CHANGE_ID: XFR_DATA_FOR_HALO_PRODS;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"XFR_DATA_FOR_HALO_PRODS",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto XFR_DATA_FOR_HALO_PRODS;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
 
proc append base = &m_di_trans..HALO_PRODUCTS data = &m_di_data..HALO_PRODUCTS force; run;
 
 
 
proc sql;
 
 
DROP TABLE &m_di_data..HALO_PRODUCTS;
 
 
quit;
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
 
proc append base = &m_di_trans..HALO_PRODUCTS data = &m_di_data..HALO_PRODUCTS force; run;
 
 
 
proc sql;
 
 
DROP TABLE &m_di_data..HALO_PRODUCTS;
 
 
quit;
 
 
 
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: XFR_DATA_FOR_HALO_PRODS;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: XFR_DATA_FOR_HALO_PRODS;
%put ERROR- Description                              : Get data for HALO_PRODUCTS table from di_data to di_trans;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 22AUG2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: XFR_DATA_FOR_HALO_PRODS;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"XFR_DATA_FOR_HALO_PRODS",
"Get data for HALO_PRODUCTS table from di_data to di_trans",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%XFR_DATA_FOR_HALO_PRODS:;
 
 
* End of changes for CHANGE_ID:XFR_DATA_FOR_HALO_PRODS;
 
 
***********************************************************************************************;
*************************************  End Change XFR_DATA_FOR_HALO_PRODS ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID787294 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID787294;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID787294")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID787294;
%goto ID787294;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID787294;
* Insert record into change management table for CHANGE_ID: ID787294;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID787294",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID787294;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
update DATA_CONFIG set MODEL_COMP_NM = 'DOW' where MODEL_COMP_NM = 'FCST'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
update DATA_CONFIG set MODEL_COMP_NM = 'DOW' where MODEL_COMP_NM = 'FCST';
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID787294;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID787294;
%put ERROR- Description                              : Correct DATA_CONFIG table to have DOW component name in place of FCST;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 25AUG2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID787294;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID787294",
"Correct DATA_CONFIG table to have DOW component name in place of FCST",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID787294:;
 
 
* End of changes for CHANGE_ID:ID787294;
 
 
***********************************************************************************************;
*************************************  End Change ID787294 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID787735 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID787735;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID787735")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID787735;
%goto ID787735;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52,M2TKMI43);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID787735;
* Insert record into change management table for CHANGE_ID: ID787735;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID787735",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID787735;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
ALTER TABLE MPLN_GEO_PROD_RESULT  ADD FW_INV_AT_OWNED_PRICE NUMERIC(20,3)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE MPLN_RESULT           ADD FW_INV_AT_OWNED_PRICE NUMERIC(20,3)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE MPLN_GEO_PROD_FAW_MTS ADD FAW_OWNED_PRICE NUMERIC(20,3)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
ALTER TABLE MPLN_GEO_PROD_RESULT  ADD FW_INV_AT_OWNED_PRICE NUMERIC(20,3);
 
 
ALTER TABLE MPLN_RESULT           ADD FW_INV_AT_OWNED_PRICE NUMERIC(20,3);
 
 
ALTER TABLE MPLN_GEO_PROD_FAW_MTS ADD FAW_OWNED_PRICE NUMERIC(20,3);
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID787735;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID787735;
%put ERROR- Description                              : Add columns for Financial Inventory Value (owned value);
%put ERROR- Version                                  : D3MICM52,M2TKMI43;
%put ERROR- Date of Change                           : 29AUG2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID787735;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID787735",
"Add columns for Financial Inventory Value (owned value)",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID787735:;
 
 
* End of changes for CHANGE_ID:ID787735;
 
 
***********************************************************************************************;
*************************************  End Change ID787735 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID760263 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID760263;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID760263")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID760263;
%goto ID760263;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID760263;
* Insert record into change management table for CHANGE_ID: ID760263;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID760263",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID760263;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
DELETE FROM PURGE_QUERY
WHERE table_nm in ('IDX_MODEL_DATA','IDX_PROMO_FACTOR','IDX_PROMO_FACTOR_DECOM',
'IDX_SCORING_PARAM','IDX_SCORING_PARAM_AVG','IDX_MODEL_DATA_CALIB','Inventory_Sparse_Refresh',
'Inventory_Sparse','ATTR_SPEC','CONFIG_AUDIT_TRAIL','DATA_CONFIG','DATA_CONFIG_TEMPLATE',
'MODEL_GROUP','MODEL_SPEC','MODEL_SPEC_TEMPLATE','MODEL_GEO_PROD_STATUS_RULE',
'MODEL_GEO_PROD_STATUS_SPEC','PROD_DATA_CONFIG')
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
DELETE FROM PURGE_QUERY
WHERE table_nm in ('IDX_MODEL_DATA','IDX_PROMO_FACTOR','IDX_PROMO_FACTOR_DECOM',
'IDX_SCORING_PARAM','IDX_SCORING_PARAM_AVG','IDX_MODEL_DATA_CALIB','Inventory_Sparse_Refresh',
'Inventory_Sparse','ATTR_SPEC','CONFIG_AUDIT_TRAIL','DATA_CONFIG','DATA_CONFIG_TEMPLATE',
'MODEL_GROUP','MODEL_SPEC','MODEL_SPEC_TEMPLATE','MODEL_GEO_PROD_STATUS_RULE',
'MODEL_GEO_PROD_STATUS_SPEC','PROD_DATA_CONFIG');
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID760263;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID760263;
%put ERROR- Description                              : Remove obsolete entries from Purge_query;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 01SEP2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID760263;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID760263",
"Remove obsolete entries from Purge_query",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID760263:;
 
 
* End of changes for CHANGE_ID:ID760263;
 
 
***********************************************************************************************;
*************************************  End Change ID760263 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID789244 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID789244;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID789244")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID789244;
%goto ID789244;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID789244;
* Insert record into change management table for CHANGE_ID: ID789244;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID789244",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID789244;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE)) %then %do;
 
%let m_sql_statement = %str(
ALTER TABLE MODEL_SPEC_DETAILS DROP COLUMN SPEC_DESC
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE MODEL_SPEC_VALUES DROP COLUMN SPEC_VALUE_DESC
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE MODEL_GEO_PROD_STATUS_DETAILS DROP COLUMN DESCRIPTION
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE MODEL_GEO_PROD_STATUS_VALUES DROP COLUMN SPEC_VALUE_DESC
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE GLOBAL_SETTING_VALUES DROP COLUMN SPEC_VALUE_DESC
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
 
proc sql;
 
 
ALTER TABLE MODEL_SPEC_DETAILS DROP COLUMN SPEC_DESC;
 
 
ALTER TABLE MODEL_SPEC_VALUES DROP COLUMN SPEC_VALUE_DESC;
 
 
ALTER TABLE MODEL_GEO_PROD_STATUS_DETAILS DROP COLUMN DESCRIPTION;
 
 
ALTER TABLE MODEL_GEO_PROD_STATUS_VALUES DROP COLUMN SPEC_VALUE_DESC;
 
 
ALTER TABLE GLOBAL_SETTING_VALUES DROP COLUMN SPEC_VALUE_DESC;
 
 
quit;
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (DB2)) %then %do;
 
%let m_sql_statement = %str(
ALTER TABLE MODEL_SPEC_DETAILS DROP COLUMN SPEC_DESC
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE MODEL_SPEC_VALUES DROP COLUMN SPEC_VALUE_DESC
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE MODEL_GEO_PROD_STATUS_DETAILS DROP COLUMN DESCRIPTION
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE MODEL_GEO_PROD_STATUS_VALUES DROP COLUMN SPEC_VALUE_DESC
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
ALTER TABLE GLOBAL_SETTING_VALUES DROP COLUMN SPEC_VALUE_DESC
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID789244;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID789244;
%put ERROR- Description                              : Drop description columns from global setting and model spec config tables;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 01SEP2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID789244;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID789244",
"Drop description columns from global setting and model spec config tables",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID789244:;
 
 
* End of changes for CHANGE_ID:ID789244;
 
 
***********************************************************************************************;
*************************************  End Change ID789244 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ADD_GEO_PROD_SETTINGS ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ADD_GEO_PROD_SETTINGS;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ADD_GEO_PROD_SETTINGS")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ADD_GEO_PROD_SETTINGS;
%goto ADD_GEO_PROD_SETTINGS;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(M1MI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ADD_GEO_PROD_SETTINGS;
* Insert record into change management table for CHANGE_ID: ADD_GEO_PROD_SETTINGS;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ADD_GEO_PROD_SETTINGS",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ADD_GEO_PROD_SETTINGS;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
 
%let m_sql_statement = %str(
DELETE FROM geo_prod_setting WHERE GEO_PROD_SETTING_SK=20005
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into geo_prod_setting(GEO_PROD_SETTING_SK,USED_BY_APP,GEO_HIER_SK,GEO_HIER_ASSOC_CD,
PROD_HIER_SK,SETTING_TYPE,SETTING_OVERRIDE_FLG,SETTING_VAL,SETTING_FLOOR,SETTING_CEIL)
values ( 20005, 2, 1, 1, 1,  5, 1,  100.0, 0.0000, 100.0000)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
DELETE FROM geo_prod_setting WHERE GEO_PROD_SETTING_SK=20006
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into geo_prod_setting(GEO_PROD_SETTING_SK,USED_BY_APP,GEO_HIER_SK,GEO_HIER_ASSOC_CD,
PROD_HIER_SK,SETTING_TYPE,SETTING_OVERRIDE_FLG,SETTING_VAL,SETTING_FLOOR,SETTING_CEIL)
values ( 20006, 2, 1, 1, 1,  6, 1,  100.0, 0.0000, 100.0000)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
DELETE FROM geo_prod_setting WHERE GEO_PROD_SETTING_SK=20019
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into geo_prod_setting(GEO_PROD_SETTING_SK,USED_BY_APP,GEO_HIER_SK,GEO_HIER_ASSOC_CD,
PROD_HIER_SK,SETTING_TYPE,SETTING_OVERRIDE_FLG,SETTING_VAL,SETTING_FLOOR,SETTING_CEIL)
values ( 20019, 2, 1, 1, 1, 19, 1, 100.0, 0.00,  100.0)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
DELETE FROM geo_prod_setting WHERE GEO_PROD_SETTING_SK=20020
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into geo_prod_setting(GEO_PROD_SETTING_SK,USED_BY_APP,GEO_HIER_SK,GEO_HIER_ASSOC_CD,
PROD_HIER_SK,SETTING_TYPE,SETTING_OVERRIDE_FLG,SETTING_VAL,SETTING_FLOOR,SETTING_CEIL)
values ( 20020, 2, 1, 1, 1, 20, 1, 100.0, 0.00,  100.0)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
DELETE FROM geo_prod_setting WHERE GEO_PROD_SETTING_SK=20021
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into geo_prod_setting(GEO_PROD_SETTING_SK,USED_BY_APP,GEO_HIER_SK,GEO_HIER_ASSOC_CD,
PROD_HIER_SK,SETTING_TYPE,SETTING_OVERRIDE_FLG,SETTING_VAL,SETTING_FLOOR,SETTING_CEIL)
values ( 20021, 2, 1, 1, 1, 21, 1, 100.0, 0.00,  100.0)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%let m_sql_statement = %str(
DELETE FROM geo_prod_setting WHERE GEO_PROD_SETTING_SK=20022
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into geo_prod_setting(GEO_PROD_SETTING_SK,USED_BY_APP,GEO_HIER_SK,GEO_HIER_ASSOC_CD,
PROD_HIER_SK,SETTING_TYPE,SETTING_OVERRIDE_FLG,SETTING_VAL,SETTING_FLOOR,SETTING_CEIL)
values ( 20022, 2, 1, 1, 1, 22, 1, 100.0, 0.00,  100.0)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
DELETE FROM geo_prod_setting WHERE GEO_PROD_SETTING_SK=20023
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into geo_prod_setting(GEO_PROD_SETTING_SK,USED_BY_APP,GEO_HIER_SK,GEO_HIER_ASSOC_CD,
PROD_HIER_SK,SETTING_TYPE,SETTING_OVERRIDE_FLG,SETTING_VAL,SETTING_FLOOR,SETTING_CEIL)
values ( 20023, 2, 1, 1, 1, 23, 1, 100.0, 0.00,  100.0)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
DELETE FROM geo_prod_setting WHERE GEO_PROD_SETTING_SK=20024
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into geo_prod_setting(GEO_PROD_SETTING_SK,USED_BY_APP,GEO_HIER_SK,GEO_HIER_ASSOC_CD,
PROD_HIER_SK,SETTING_TYPE,SETTING_OVERRIDE_FLG,SETTING_VAL,SETTING_FLOOR,SETTING_CEIL)
values ( 20024, 2, 1, 1, 1, 24, 1, 100.0, 0.00,  100.0)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
 
DELETE FROM geo_prod_setting WHERE GEO_PROD_SETTING_SK=20005;
 
 
insert into geo_prod_setting(GEO_PROD_SETTING_SK,USED_BY_APP,GEO_HIER_SK,GEO_HIER_ASSOC_CD,
PROD_HIER_SK,SETTING_TYPE,SETTING_OVERRIDE_FLG,SETTING_VAL,SETTING_FLOOR,SETTING_CEIL)
values ( 20005, 2, 1, 1, 1,  5, 1,  100.0, 0.0000, 100.0000);
 
 
 
DELETE FROM geo_prod_setting WHERE GEO_PROD_SETTING_SK=20006;
 
 
insert into geo_prod_setting(GEO_PROD_SETTING_SK,USED_BY_APP,GEO_HIER_SK,GEO_HIER_ASSOC_CD,
PROD_HIER_SK,SETTING_TYPE,SETTING_OVERRIDE_FLG,SETTING_VAL,SETTING_FLOOR,SETTING_CEIL)
values ( 20006, 2, 1, 1, 1,  6, 1,  100.0, 0.0000, 100.0000);
 
 
 
DELETE FROM geo_prod_setting WHERE GEO_PROD_SETTING_SK=20019;
 
 
insert into geo_prod_setting(GEO_PROD_SETTING_SK,USED_BY_APP,GEO_HIER_SK,GEO_HIER_ASSOC_CD,
PROD_HIER_SK,SETTING_TYPE,SETTING_OVERRIDE_FLG,SETTING_VAL,SETTING_FLOOR,SETTING_CEIL)
values ( 20019, 2, 1, 1, 1, 19, 1, 100.0, 0.00,  100.0);
 
 
 
DELETE FROM geo_prod_setting WHERE GEO_PROD_SETTING_SK=20020;
 
 
insert into geo_prod_setting(GEO_PROD_SETTING_SK,USED_BY_APP,GEO_HIER_SK,GEO_HIER_ASSOC_CD,
PROD_HIER_SK,SETTING_TYPE,SETTING_OVERRIDE_FLG,SETTING_VAL,SETTING_FLOOR,SETTING_CEIL)
values ( 20020, 2, 1, 1, 1, 20, 1, 100.0, 0.00,  100.0);
 
 
 
DELETE FROM geo_prod_setting WHERE GEO_PROD_SETTING_SK=20021;
 
 
insert into geo_prod_setting(GEO_PROD_SETTING_SK,USED_BY_APP,GEO_HIER_SK,GEO_HIER_ASSOC_CD,
PROD_HIER_SK,SETTING_TYPE,SETTING_OVERRIDE_FLG,SETTING_VAL,SETTING_FLOOR,SETTING_CEIL)
values ( 20021, 2, 1, 1, 1, 21, 1, 100.0, 0.00,  100.0);
 
 
 
 
DELETE FROM geo_prod_setting WHERE GEO_PROD_SETTING_SK=20022;
 
 
insert into geo_prod_setting(GEO_PROD_SETTING_SK,USED_BY_APP,GEO_HIER_SK,GEO_HIER_ASSOC_CD,
PROD_HIER_SK,SETTING_TYPE,SETTING_OVERRIDE_FLG,SETTING_VAL,SETTING_FLOOR,SETTING_CEIL)
values ( 20022, 2, 1, 1, 1, 22, 1, 100.0, 0.00,  100.0);
 
 
 
DELETE FROM geo_prod_setting WHERE GEO_PROD_SETTING_SK=20023;
 
 
insert into geo_prod_setting(GEO_PROD_SETTING_SK,USED_BY_APP,GEO_HIER_SK,GEO_HIER_ASSOC_CD,
PROD_HIER_SK,SETTING_TYPE,SETTING_OVERRIDE_FLG,SETTING_VAL,SETTING_FLOOR,SETTING_CEIL)
values ( 20023, 2, 1, 1, 1, 23, 1, 100.0, 0.00,  100.0);
 
 
 
DELETE FROM geo_prod_setting WHERE GEO_PROD_SETTING_SK=20024;
 
 
insert into geo_prod_setting(GEO_PROD_SETTING_SK,USED_BY_APP,GEO_HIER_SK,GEO_HIER_ASSOC_CD,
PROD_HIER_SK,SETTING_TYPE,SETTING_OVERRIDE_FLG,SETTING_VAL,SETTING_FLOOR,SETTING_CEIL)
values ( 20024, 2, 1, 1, 1, 24, 1, 100.0, 0.00,  100.0);
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ADD_GEO_PROD_SETTINGS;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ADD_GEO_PROD_SETTINGS;
%put ERROR- Description                              : Additiona seed values for GEO_PROD_SETTINGS table;
%put ERROR- Version                                  : M1MI42;
%put ERROR- Date of Change                           : 01SEP2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ADD_GEO_PROD_SETTINGS;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ADD_GEO_PROD_SETTINGS",
"Additiona seed values for GEO_PROD_SETTINGS table",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ADD_GEO_PROD_SETTINGS:;
 
 
* End of changes for CHANGE_ID:ADD_GEO_PROD_SETTINGS;
 
 
***********************************************************************************************;
*************************************  End Change ADD_GEO_PROD_SETTINGS ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID790541 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID790541;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID790541")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID790541;
%goto ID790541;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID790541;
* Insert record into change management table for CHANGE_ID: ID790541;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID790541",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID790541;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
 
 
proc sql;
 
 
 
DELETE FROM &m_di_trans..PURGE_QUERY WHERE TABLE_NM='GEO_PROD_BENEFITS';
 
 
 
INSERT INTO &m_di_trans..purge_query
(table_nm ,database_nm ,purge_order ,purge_frequency ,purge_query_txt, num_days_preserved ,partition_flg ,app_nm)
VALUES  ('GEO_PROD_BENEFITS', 'SAS', 1, 30, '%di_purge_geo_prod_benefits(libref=DI_DM);', 742,1,'RPO');
 
 
 
DELETE FROM &m_di_trans..PURGE_QUERY WHERE TABLE_NM='GEO_PROD_BENEFITS_PS';
 
 
INSERT INTO &m_di_trans..purge_query
(table_nm ,database_nm ,purge_order ,purge_frequency ,purge_query_txt, num_days_preserved ,partition_flg ,app_nm)
VALUES ('GEO_PROD_BENEFITS_PS', 'SAS', 1, 30, '%di_purge_geo_prod_benefits_ps(libref=DI_DM);', 742,1,'RPO');
 
 
 
quit;
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
 
 
proc sql;
 
 
 
DELETE FROM &m_di_trans..PURGE_QUERY WHERE TABLE_NM='GEO_PROD_BENEFITS';
 
 
 
INSERT INTO &m_di_trans..purge_query
(table_nm ,database_nm ,purge_order ,purge_frequency ,purge_query_txt, num_days_preserved ,partition_flg ,app_nm)
VALUES  ('GEO_PROD_BENEFITS', 'SAS', 1, 30, '%di_purge_geo_prod_benefits(libref=DI_DM);', 742,1,'RPO');
 
 
 
DELETE FROM &m_di_trans..PURGE_QUERY WHERE TABLE_NM='GEO_PROD_BENEFITS_PS';
 
 
INSERT INTO &m_di_trans..purge_query
(table_nm ,database_nm ,purge_order ,purge_frequency ,purge_query_txt, num_days_preserved ,partition_flg ,app_nm)
VALUES ('GEO_PROD_BENEFITS_PS', 'SAS', 1, 30, '%di_purge_geo_prod_benefits_ps(libref=DI_DM);', 742,1,'RPO');
 
 
 
quit;
 
 
 
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID790541;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID790541;
%put ERROR- Description                              : Add purge macros for new tables viz. GEO_PROD_BENEFITS and GEO_PROD_BENEFITS_PS;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 07SEP2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID790541;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID790541",
"Add purge macros for new tables viz. GEO_PROD_BENEFITS and GEO_PROD_BENEFITS_PS",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID790541:;
 
 
* End of changes for CHANGE_ID:ID790541;
 
 
***********************************************************************************************;
*************************************  End Change ID790541 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID791890 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID791890;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID791890")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID791890;
%goto ID791890;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID791890;
* Insert record into change management table for CHANGE_ID: ID791890;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID791890",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID791890;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'ATREG_COLD_START'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from MODEL_SPEC where SPEC_NM = 'ATREG_COLD_START'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'ATREG_MODULE'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from MODEL_SPEC where SPEC_NM = 'ATREG_MODULE'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'BASE_FORECAST_OVERRIDE'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from MODEL_SPEC where SPEC_NM = 'BASE_FORECAST_OVERRIDE'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'DESEASON_SOURCE'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from MODEL_SPEC where SPEC_NM = 'DESEASON_SOURCE'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'DETREND_SOURCE'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from MODEL_SPEC where SPEC_NM = 'DETREND_SOURCE'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'DMREG_SELECT_TYPE'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from MODEL_SPEC where SPEC_NM = 'DMREG_SELECT_TYPE'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'EST_MODE'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from MODEL_SPEC where SPEC_NM = 'EST_MODE'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'EXCLUDE_NP_FROM_SHARE'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from MODEL_SPEC where SPEC_NM = 'EXCLUDE_NP_FROM_SHARE'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'FCST_DAILY_TO_WEEKLY'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from MODEL_SPEC where SPEC_NM = 'FCST_DAILY_TO_WEEKLY'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'FCST_INTERMITTENT'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from MODEL_SPEC where SPEC_NM = 'FCST_INTERMITTENT'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'FCST_OUTTYPE'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from MODEL_SPEC where SPEC_NM = 'FCST_OUTTYPE'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'FCST_TS_CS'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from MODEL_SPEC where SPEC_NM = 'FCST_TS_CS'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'MAX_PRICE_RATIO'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from MODEL_SPEC where SPEC_NM = 'MAX_PRICE_RATIO'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'MISC_ADJ'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from MODEL_SPEC where SPEC_NM = 'MISC_ADJ'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'RRP'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from MODEL_SPEC where SPEC_NM = 'RRP'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'VARIABLE_SELECT'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from MODEL_SPEC where SPEC_NM = 'VARIABLE_SELECT'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'ATREG_COLD_START';
 
 
delete from MODEL_SPEC where SPEC_NM = 'ATREG_COLD_START';
 
 
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'ATREG_MODULE';
 
 
delete from MODEL_SPEC where SPEC_NM = 'ATREG_MODULE';
 
 
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'BASE_FORECAST_OVERRIDE';
 
 
delete from MODEL_SPEC where SPEC_NM = 'BASE_FORECAST_OVERRIDE';
 
 
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'DESEASON_SOURCE';
 
 
delete from MODEL_SPEC where SPEC_NM = 'DESEASON_SOURCE';
 
 
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'DETREND_SOURCE';
 
 
delete from MODEL_SPEC where SPEC_NM = 'DETREND_SOURCE';
 
 
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'DMREG_SELECT_TYPE';
 
 
delete from MODEL_SPEC where SPEC_NM = 'DMREG_SELECT_TYPE';
 
 
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'EST_MODE';
 
 
delete from MODEL_SPEC where SPEC_NM = 'EST_MODE';
 
 
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'EXCLUDE_NP_FROM_SHARE';
 
 
delete from MODEL_SPEC where SPEC_NM = 'EXCLUDE_NP_FROM_SHARE';
 
 
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'FCST_DAILY_TO_WEEKLY';
 
 
delete from MODEL_SPEC where SPEC_NM = 'FCST_DAILY_TO_WEEKLY';
 
 
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'FCST_INTERMITTENT';
 
 
delete from MODEL_SPEC where SPEC_NM = 'FCST_INTERMITTENT';
 
 
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'FCST_OUTTYPE';
 
 
delete from MODEL_SPEC where SPEC_NM = 'FCST_OUTTYPE';
 
 
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'FCST_TS_CS';
 
 
delete from MODEL_SPEC where SPEC_NM = 'FCST_TS_CS';
 
 
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'MAX_PRICE_RATIO';
 
 
delete from MODEL_SPEC where SPEC_NM = 'MAX_PRICE_RATIO';
 
 
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'MISC_ADJ';
 
 
delete from MODEL_SPEC where SPEC_NM = 'MISC_ADJ';
 
 
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'RRP';
 
 
delete from MODEL_SPEC where SPEC_NM = 'RRP';
 
 
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'VARIABLE_SELECT';
 
 
delete from MODEL_SPEC where SPEC_NM = 'VARIABLE_SELECT';
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID791890;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID791890;
%put ERROR- Description                              : Remove several model specs and remove component specialization from others;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 09SEP2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID791890;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID791890",
"Remove several model specs and remove component specialization from others",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID791890:;
 
 
* End of changes for CHANGE_ID:ID791890;
 
 
***********************************************************************************************;
*************************************  End Change ID791890 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID792047 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID792047;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID792047")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID792047;
%goto ID792047;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID792047;
* Insert record into change management table for CHANGE_ID: ID792047;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID792047",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID792047;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
update MODEL_SPEC_DEFAULT set DEFAULT_SPEC_VALUE = '1' where SPEC_NM = 'SALES_INTRO_FROM_GPSTATUS'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
update MODEL_SPEC_DEFAULT set DEFAULT_SPEC_VALUE = '1' where SPEC_NM = 'SALES_INTRO_FROM_GPSTATUS';
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID792047;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID792047;
%put ERROR- Description                              : Change default value for model spec SALES_INTRO_FROM_GPSTATUS to 1;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 12SEP2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID792047;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID792047",
"Change default value for model spec SALES_INTRO_FROM_GPSTATUS to 1",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID792047:;
 
 
* End of changes for CHANGE_ID:ID792047;
 
 
***********************************************************************************************;
*************************************  End Change ID792047 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID792049 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID792049;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID792049")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID792049;
%goto ID792049;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID792049;
* Insert record into change management table for CHANGE_ID: ID792049;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID792049",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID792049;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
update MODEL_SPEC_DEFAULT set DEFAULT_SPEC_VALUE = 'WEEK' where SPEC_NM = 'SEASON_FREQ'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
update MODEL_SPEC_DEFAULT set DEFAULT_SPEC_VALUE = 'WEEK' where SPEC_NM = 'SEASON_FREQ';
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID792049;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID792049;
%put ERROR- Description                              : Change default value for model spec SEASON_FREQ to WEEK;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 12SEP2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID792049;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID792049",
"Change default value for model spec SEASON_FREQ to WEEK",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID792049:;
 
 
* End of changes for CHANGE_ID:ID792049;
 
 
***********************************************************************************************;
*************************************  End Change ID792049 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID792051 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID792051;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID792051")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID792051;
%goto ID792051;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID792051;
* Insert record into change management table for CHANGE_ID: ID792051;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID792051",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID792051;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
update MODEL_SPEC_DEFAULT set MODEL_COMP_NM = 'ALL' where SPEC_NM = 'TS_COMP_UPPER_BOUND'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
update MODEL_SPEC_DEFAULT set MODEL_COMP_NM = 'ALL' where SPEC_NM = 'TS_COMP_LOWER_BOUND'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
update MODEL_SPEC_DEFAULT set MODEL_COMP_NM = 'ALL' where SPEC_NM = 'TS_COMP_UPPER_BOUND';
 
 
update MODEL_SPEC_DEFAULT set MODEL_COMP_NM = 'ALL' where SPEC_NM = 'TS_COMP_LOWER_BOUND';
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID792051;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID792051;
%put ERROR- Description                              : Change TS_COMP_LOWER_BOUND & TS_COMP_UPPER_BOUND model specs component to ALL;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 12SEP2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID792051;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID792051",
"Change TS_COMP_LOWER_BOUND & TS_COMP_UPPER_BOUND model specs component to ALL",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID792051:;
 
 
* End of changes for CHANGE_ID:ID792051;
 
 
***********************************************************************************************;
*************************************  End Change ID792051 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID792884 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID792884;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID792884")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_trans..PRF_SIZESET))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_trans..PRF_SIZESET;
%put NOTE: Change ID                             :ID792884;
%goto ID792884;
 
%end;
%if not (%sysfunc(exist(&m_di_trans..PRF_SIZESET_MBR))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_trans..PRF_SIZESET_MBR;
%put NOTE: Change ID                             :ID792884;
%goto ID792884;
 
%end;
%if not (%sysfunc(exist(&m_di_trans..PRF_PLAN))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_trans..PRF_PLAN;
%put NOTE: Change ID                             :ID792884;
%goto ID792884;
 
%end;
%if not (%sysfunc(exist())) %then
%do;
%put NOTE: Skip this change since this table does not exist: ;
%put NOTE: Change ID                             :ID792884;
%goto ID792884;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID792884;
%goto ID792884;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID792884;
* Insert record into change management table for CHANGE_ID: ID792884;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID792884",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID792884;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
%let m_sql_statement = %str(
UPDATE PRF_SIZESET SET CUSTOM_FLG = 0 WHERE CUSTOM_FLG IS NULL
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
UPDATE PRF_PLAN SET CUSTOM_FLG = 0 WHERE CUSTOM_FLG IS NULL
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
UPDATE PRF_SIZESET_MBR SET SALES_DISTRIBUTION_PCT = 0 WHERE SALES_DISTRIBUTION_PCT IS NULL
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
UPDATE PRF_SIZESET_MBR SET SALES_AUR = 0 WHERE SALES_AUR IS NULL
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
UPDATE PRF_SIZESET_MBR SET UNITS_IMPUTED = 0 WHERE UNITS_IMPUTED IS NULL
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
UPDATE PRF_SIZESET_MBR SET POST_IMPUTATION_SALES_UNITS = 0 WHERE POST_IMPUTATION_SALES_UNITS IS NULL
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
UPDATE PRF_SIZESET SET CUSTOM_FLG = 0 WHERE CUSTOM_FLG IS NULL;
 
 
UPDATE PRF_PLAN SET CUSTOM_FLG = 0 WHERE CUSTOM_FLG IS NULL;
 
 
UPDATE PRF_SIZESET_MBR SET SALES_DISTRIBUTION_PCT = 0 WHERE SALES_DISTRIBUTION_PCT IS NULL;
 
 
UPDATE PRF_SIZESET_MBR SET SALES_AUR = 0 WHERE SALES_AUR IS NULL;
 
 
UPDATE PRF_SIZESET_MBR SET UNITS_IMPUTED = 0 WHERE UNITS_IMPUTED IS NULL;
 
 
UPDATE PRF_SIZESET_MBR SET POST_IMPUTATION_SALES_UNITS = 0 WHERE POST_IMPUTATION_SALES_UNITS IS NULL;
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID792884;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID792884;
%put ERROR- Description                              : Provide default values for 3.2 columns;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 15SEP2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID792884;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID792884",
"Provide default values for 3.2 columns",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID792884:;
 
 
* End of changes for CHANGE_ID:ID792884;
 
 
***********************************************************************************************;
*************************************  End Change ID792884 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID794818 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID794818;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID794818")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID794818;
%goto ID794818;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID794818;
* Insert record into change management table for CHANGE_ID: ID794818;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID794818",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID794818;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
update MODEL_SPEC set SPEC_VALUE = 'SIMPLE' where SPEC_NM = 'FCST_DISAGG_BESTN_LIST' and SPEC_VALUE = 'IDM'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
update MODEL_SPEC_DEFAULT set DEFAULT_SPEC_VALUE = 'SIMPLE' where SPEC_NM = 'FCST_DISAGG_BESTN_LIST' and DEFAULT_SPEC_VALUE = 'IDM'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
update MODEL_SPEC set SPEC_VALUE = 'SIMPLE' where SPEC_NM = 'INT_BESTN_LIST' and SPEC_VALUE = 'IDM'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
update MODEL_SPEC_DEFAULT set DEFAULT_SPEC_VALUE = 'SIMPLE' where SPEC_NM = 'INT_BESTN_LIST' and DEFAULT_SPEC_VALUE = 'IDM'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
update MODEL_SPEC set SPEC_VALUE = 'SIMPLE' where SPEC_NM = 'FCST_DISAGG_BESTN_LIST' and SPEC_VALUE = 'IDM';
 
 
update MODEL_SPEC_DEFAULT set DEFAULT_SPEC_VALUE = 'SIMPLE' where SPEC_NM = 'FCST_DISAGG_BESTN_LIST' and DEFAULT_SPEC_VALUE = 'IDM';
 
 
update MODEL_SPEC set SPEC_VALUE = 'SIMPLE' where SPEC_NM = 'INT_BESTN_LIST' and SPEC_VALUE = 'IDM';
 
 
update MODEL_SPEC_DEFAULT set DEFAULT_SPEC_VALUE = 'SIMPLE' where SPEC_NM = 'INT_BESTN_LIST' and DEFAULT_SPEC_VALUE = 'IDM';
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID794818;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID794818;
%put ERROR- Description                              : Remove IDM as a model spec value;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 23SEP2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID794818;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID794818",
"Remove IDM as a model spec value",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID794818:;
 
 
* End of changes for CHANGE_ID:ID794818;
 
 
***********************************************************************************************;
*************************************  End Change ID794818 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID793322 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID793322;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID793322")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID793322;
%goto ID793322;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID793322;
* Insert record into change management table for CHANGE_ID: ID793322;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID793322",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID793322;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
update MODEL_SPEC_DEFAULT set DEFAULT_SPEC_VALUE = '10.0' where SPEC_NM = 'TS_SEASON_VAR'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
update MODEL_SPEC_DEFAULT set DEFAULT_SPEC_VALUE = '20.0' where SPEC_NM = 'TS_SEASON_MAX'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
update MODEL_SPEC_DEFAULT set DEFAULT_SPEC_VALUE = '10.0' where SPEC_NM = 'TS_SEASON_VAR';
 
 
update MODEL_SPEC_DEFAULT set DEFAULT_SPEC_VALUE = '20.0' where SPEC_NM = 'TS_SEASON_MAX';
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID793322;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID793322;
%put ERROR- Description                              : Change type and default value for model specs TS_SEASON_VAR and TS_SEASON_MAX;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 15SEP2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID793322;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID793322",
"Change type and default value for model specs TS_SEASON_VAR and TS_SEASON_MAX",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID793322:;
 
 
* End of changes for CHANGE_ID:ID793322;
 
 
***********************************************************************************************;
*************************************  End Change ID793322 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID794546 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID794546;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID794546")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID794546;
%goto ID794546;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID794546;
* Insert record into change management table for CHANGE_ID: ID794546;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID794546",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID794546;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
ALTER TABLE PKO_BUY ADD USE_GROSS_NEEDS_FLG INTEGER
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
ALTER TABLE PKO_BUY ADD USE_GROSS_NEEDS_FLG INTEGER ;
 
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID794546;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID794546;
%put ERROR- Description                              : Allow user to specify needs as net;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 22SEP2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID794546;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID794546",
"Allow user to specify needs as net",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID794546:;
 
 
* End of changes for CHANGE_ID:ID794546;
 
 
***********************************************************************************************;
*************************************  End Change ID794546 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID791033 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID791033;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID791033")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID791033;
%goto ID791033;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID791033;
* Insert record into change management table for CHANGE_ID: ID791033;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID791033",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID791033;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER)
VALUES ('GEO_PROD_BENEFITS',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER)
VALUES ('GEO_PROD_BENEFITS_PS',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER)
VALUES ('GEO_PROD_BENEFITS',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER)
VALUES ('GEO_PROD_BENEFITS_PS',0,0,0,null,null);
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID791033;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID791033;
%put ERROR- Description                              : Adding new entries for Geo Prod Benefits to table_partition_meta.;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 22SEP2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID791033;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID791033",
"Adding new entries for Geo Prod Benefits to table_partition_meta.",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID791033:;
 
 
* End of changes for CHANGE_ID:ID791033;
 
 
***********************************************************************************************;
*************************************  End Change ID791033 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change DROP_MA_SPEC_TABLE ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: DROP_MA_SPEC_TABLE;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("DROP_MA_SPEC_TABLE")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(&m_di_data.)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_di_data.;
%put NOTE: Change ID                             :DROP_MA_SPEC_TABLE;
%goto DROP_MA_SPEC_TABLE;
 
%end;
%if not (%sysfunc(libref(&m_di_trans.)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: &m_di_trans.;
%put NOTE: Change ID                             :DROP_MA_SPEC_TABLE;
%goto DROP_MA_SPEC_TABLE;
 
%end;
%if not (%sysfunc(exist(&m_di_data..ma_spec))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_data..ma_spec;
%put NOTE: Change ID                             :DROP_MA_SPEC_TABLE;
%goto DROP_MA_SPEC_TABLE;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : DROP_MA_SPEC_TABLE;
%goto DROP_MA_SPEC_TABLE;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : DROP_MA_SPEC_TABLE;
* Insert record into change management table for CHANGE_ID: DROP_MA_SPEC_TABLE;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"DROP_MA_SPEC_TABLE",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto DROP_MA_SPEC_TABLE;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
 
proc sql;
 
 
DROP TABLE &m_di_data..MA_SPEC;
 
 
quit;
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
 
proc sql;
 
 
DROP TABLE &m_di_data..MA_SPEC;
 
 
quit;
 
 
 
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: DROP_MA_SPEC_TABLE;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: DROP_MA_SPEC_TABLE;
%put ERROR- Description                              : Drop MA_SPEC moved to RDBMS;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 23SEP2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: DROP_MA_SPEC_TABLE;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"DROP_MA_SPEC_TABLE",
"Drop MA_SPEC moved to RDBMS",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%DROP_MA_SPEC_TABLE:;
 
 
* End of changes for CHANGE_ID:DROP_MA_SPEC_TABLE;
 
 
***********************************************************************************************;
*************************************  End Change DROP_MA_SPEC_TABLE ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change TABLE_PART_META_01 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: TABLE_PART_META_01;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("TABLE_PART_META_01")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : TABLE_PART_META_01;
%goto TABLE_PART_META_01;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : TABLE_PART_META_01;
* Insert record into change management table for CHANGE_ID: TABLE_PART_META_01;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"TABLE_PART_META_01",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto TABLE_PART_META_01;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER)
VALUES ('DATA_MODEL_CHANGE_MANAGEMENT',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER)
VALUES ('DATA_MODEL_VERSION_MANAGEMENT',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER)
VALUES ('PRICING_RULES_COLUMN_META',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER)
VALUES ('PRICING_RULES_RULE_META',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER)
VALUES ('PURGE_RESULT_TABLE',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER)
VALUES ('REPORT_DECOMP',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER)
VALUES ('REPORT_DECOMP_PS',0,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER)
VALUES ('DOW_ADJ_FACTOR',1,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER)
VALUES ('DOW_PROD_GEO_GROUP_ATTR',1,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER)
VALUES ('DOW_PROFILE',1,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER)
VALUES ('MODEL_GEO_PROD_STATUS_META',1,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER)
VALUES ('PRICE_POINT_CORRECTION',1,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
delete from TABLE_PARTITION_META where TABLE_NM = 'VARIABLE_SELECT'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from TABLE_PARTITION_META where TABLE_NM = 'ATTR_SPEC'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from TABLE_PARTITION_META where TABLE_NM = 'BASE_FORECAST_OVERRIDE_GP'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from TABLE_PARTITION_META where TABLE_NM = 'BASE_FORECAST_OVERRIDE_MG'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from TABLE_PARTITION_META where TABLE_NM = 'BUDGET'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from TABLE_PARTITION_META where TABLE_NM = 'CONFIG_AUDIT_TRAIL'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from TABLE_PARTITION_META where TABLE_NM = 'CONFIG_GROUP'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from TABLE_PARTITION_META where TABLE_NM = 'DATA_CONFIG'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from TABLE_PARTITION_META where TABLE_NM = 'DATA_CONFIG_TEMPLATE'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from TABLE_PARTITION_META where TABLE_NM = 'GLOBAL_SETTING_DETAILS'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from TABLE_PARTITION_META where TABLE_NM = 'GLOBAL_SETTING_GROUP'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from TABLE_PARTITION_META where TABLE_NM = 'GLOBAL_SETTING_GROUP_MEMBER'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from TABLE_PARTITION_META where TABLE_NM = 'GLOBAL_SETTING_VALUES'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from TABLE_PARTITION_META where TABLE_NM = 'HALO_PRODUCTS'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from TABLE_PARTITION_META where TABLE_NM = 'MODEL_GEO_PROD_STATUS_DETAILS'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from TABLE_PARTITION_META where TABLE_NM = 'MODEL_GEO_PROD_STATUS_RULE'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from TABLE_PARTITION_META where TABLE_NM = 'MODEL_GEO_PROD_STATUS_SPEC'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from TABLE_PARTITION_META where TABLE_NM = 'MODEL_GEO_PROD_STATUS_VALUES'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from TABLE_PARTITION_META where TABLE_NM = 'MODEL_GROUP'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from TABLE_PARTITION_META where TABLE_NM = 'MODEL_SPEC'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from TABLE_PARTITION_META where TABLE_NM = 'MODEL_SPEC_DEFAULT'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from TABLE_PARTITION_META where TABLE_NM = 'MODEL_SPEC_DETAILS'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from TABLE_PARTITION_META where TABLE_NM = 'MODEL_SPEC_TEMPLATE'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from TABLE_PARTITION_META where TABLE_NM = 'MODEL_SPEC_VALUES'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from TABLE_PARTITION_META where TABLE_NM = 'MODEL_SPEC_WORKFLOW'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from TABLE_PARTITION_META where TABLE_NM = 'MPLN_GEO_PROD_ACCUM_MTS'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from TABLE_PARTITION_META where TABLE_NM = 'PRF_SSD_SRC'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from TABLE_PARTITION_META where TABLE_NM = 'PROD_DATA_CONFIG'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from TABLE_PARTITION_META where TABLE_NM = 'RPP_CAL_AGG'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from TABLE_PARTITION_META where TABLE_NM = 'RPP_CAT_AGG'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from TABLE_PARTITION_META where TABLE_NM = 'SCORING_PARAM_CONFIG'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from TABLE_PARTITION_META where TABLE_NM = 'SCORING_PARAM_DEFAULT'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER)
VALUES ('DATA_MODEL_CHANGE_MANAGEMENT',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER)
VALUES ('DATA_MODEL_VERSION_MANAGEMENT',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER)
VALUES ('PRICING_RULES_COLUMN_META',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER)
VALUES ('PRICING_RULES_RULE_META',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER)
VALUES ('PURGE_RESULT_TABLE',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER)
VALUES ('REPORT_DECOMP',0,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER)
VALUES ('REPORT_DECOMP_PS',0,0,0,null,null);
 
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER)
VALUES ('DOW_ADJ_FACTOR',1,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER)
VALUES ('DOW_PROD_GEO_GROUP_ATTR',1,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER)
VALUES ('DOW_PROFILE',1,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER)
VALUES ('MODEL_GEO_PROD_STATUS_META',1,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER)
VALUES ('PRICE_POINT_CORRECTION',1,0,0,null,null);
 
 
 
delete from TABLE_PARTITION_META where TABLE_NM = 'VARIABLE_SELECT';
 
 
delete from TABLE_PARTITION_META where TABLE_NM = 'ATTR_SPEC';
 
 
delete from TABLE_PARTITION_META where TABLE_NM = 'BASE_FORECAST_OVERRIDE_GP';
 
 
delete from TABLE_PARTITION_META where TABLE_NM = 'BASE_FORECAST_OVERRIDE_MG';
 
 
delete from TABLE_PARTITION_META where TABLE_NM = 'BUDGET';
 
 
delete from TABLE_PARTITION_META where TABLE_NM = 'CONFIG_AUDIT_TRAIL';
 
 
delete from TABLE_PARTITION_META where TABLE_NM = 'CONFIG_GROUP';
 
 
delete from TABLE_PARTITION_META where TABLE_NM = 'DATA_CONFIG';
 
 
delete from TABLE_PARTITION_META where TABLE_NM = 'DATA_CONFIG_TEMPLATE';
 
 
delete from TABLE_PARTITION_META where TABLE_NM = 'GLOBAL_SETTING_DETAILS';
 
 
delete from TABLE_PARTITION_META where TABLE_NM = 'GLOBAL_SETTING_GROUP';
 
 
delete from TABLE_PARTITION_META where TABLE_NM = 'GLOBAL_SETTING_GROUP_MEMBER';
 
 
delete from TABLE_PARTITION_META where TABLE_NM = 'GLOBAL_SETTING_VALUES';
 
 
delete from TABLE_PARTITION_META where TABLE_NM = 'HALO_PRODUCTS';
 
 
delete from TABLE_PARTITION_META where TABLE_NM = 'MODEL_GEO_PROD_STATUS_DETAILS';
 
 
delete from TABLE_PARTITION_META where TABLE_NM = 'MODEL_GEO_PROD_STATUS_RULE';
 
 
delete from TABLE_PARTITION_META where TABLE_NM = 'MODEL_GEO_PROD_STATUS_SPEC';
 
 
delete from TABLE_PARTITION_META where TABLE_NM = 'MODEL_GEO_PROD_STATUS_VALUES';
 
 
delete from TABLE_PARTITION_META where TABLE_NM = 'MODEL_GROUP';
 
 
delete from TABLE_PARTITION_META where TABLE_NM = 'MODEL_SPEC';
 
 
delete from TABLE_PARTITION_META where TABLE_NM = 'MODEL_SPEC_DEFAULT';
 
 
delete from TABLE_PARTITION_META where TABLE_NM = 'MODEL_SPEC_DETAILS';
 
 
delete from TABLE_PARTITION_META where TABLE_NM = 'MODEL_SPEC_TEMPLATE';
 
 
delete from TABLE_PARTITION_META where TABLE_NM = 'MODEL_SPEC_VALUES';
 
 
delete from TABLE_PARTITION_META where TABLE_NM = 'MODEL_SPEC_WORKFLOW';
 
 
delete from TABLE_PARTITION_META where TABLE_NM = 'MPLN_GEO_PROD_ACCUM_MTS';
 
 
delete from TABLE_PARTITION_META where TABLE_NM = 'PRF_SSD_SRC';
 
 
delete from TABLE_PARTITION_META where TABLE_NM = 'PROD_DATA_CONFIG';
 
 
delete from TABLE_PARTITION_META where TABLE_NM = 'RPP_CAL_AGG';
 
 
delete from TABLE_PARTITION_META where TABLE_NM = 'RPP_CAT_AGG';
 
 
delete from TABLE_PARTITION_META where TABLE_NM = 'SCORING_PARAM_CONFIG';
 
 
delete from TABLE_PARTITION_META where TABLE_NM = 'SCORING_PARAM_DEFAULT';
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: TABLE_PART_META_01;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: TABLE_PART_META_01;
%put ERROR- Description                              : Synchronize table_partition_meta for 5.2;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 27SEP2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: TABLE_PART_META_01;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"TABLE_PART_META_01",
"Synchronize table_partition_meta for 5.2",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%TABLE_PART_META_01:;
 
 
* End of changes for CHANGE_ID:TABLE_PART_META_01;
 
 
***********************************************************************************************;
*************************************  End Change TABLE_PART_META_01 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change REMOVE_GEO_STORE ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: REMOVE_GEO_STORE;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("REMOVE_GEO_STORE")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : REMOVE_GEO_STORE;
%goto REMOVE_GEO_STORE;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : REMOVE_GEO_STORE;
* Insert record into change management table for CHANGE_ID: REMOVE_GEO_STORE;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"REMOVE_GEO_STORE",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto REMOVE_GEO_STORE;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
delete from TABLE_PARTITION_META where TABLE_NM = 'GEO_STORE'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from TABLE_PARTITION_META where TABLE_NM = 'GEO_PROD_BENEFITS'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from TABLE_PARTITION_META where TABLE_NM = 'GEO_PROD_BENEFITS_PS'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from TABLE_PARTITION_META where TABLE_NM = 'SALES_AVG'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER)
VALUES ('GEO_PROD_BENEFITS',1,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER)
VALUES ('GEO_PROD_BENEFITS_PS',1,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER)
VALUES ('SALES_AVG',1,0,0,null,null)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
delete from TABLE_PARTITION_META where TABLE_NM = 'GEO_STORE';
 
 
delete from TABLE_PARTITION_META where TABLE_NM = 'GEO_PROD_BENEFITS';
 
 
delete from TABLE_PARTITION_META where TABLE_NM = 'GEO_PROD_BENEFITS_PS';
 
 
delete from TABLE_PARTITION_META where TABLE_NM = 'SALES_AVG';
 
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER)
VALUES ('GEO_PROD_BENEFITS',1,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER)
VALUES ('GEO_PROD_BENEFITS_PS',1,0,0,null,null);
 
 
INSERT INTO TABLE_PARTITION_META (TABLE_NM,FULL_COPY_FLG,PARTITION_FLG,ESTIMATION_FLG,ETL_STG2DM,SORT_ORDER)
VALUES ('SALES_AVG',1,0,0,null,null);
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: REMOVE_GEO_STORE;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: REMOVE_GEO_STORE;
%put ERROR- Description                              : Remove GEO_STORE from table_partition_meta for 5.2;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 06JUN2012;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: REMOVE_GEO_STORE;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"REMOVE_GEO_STORE",
"Remove GEO_STORE from table_partition_meta for 5.2",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%REMOVE_GEO_STORE:;
 
 
* End of changes for CHANGE_ID:REMOVE_GEO_STORE;
 
 
***********************************************************************************************;
*************************************  End Change REMOVE_GEO_STORE ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change TABLE_PART_META_SORT ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: TABLE_PART_META_SORT;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("TABLE_PART_META_SORT")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%put NOTE: This change will be applied on every run : TABLE_PART_META_SORT;
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
 
proc sort data=&m_di_trans..TABLE_PARTITION_META OUT=work.TABLE_PARTITION_META;
 
 
by table_nm;
 
 
run;
 
 
 
proc sql;
 
 
delete * from &m_di_trans..TABLE_PARTITION_META ;
 
 
insert into &m_di_trans..TABLE_PARTITION_META
select * from work.TABLE_PARTITION_META;
 
 
drop table work.TABLE_PARTITION_META;
 
 
quit;
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
 
proc sort data=&m_di_trans..TABLE_PARTITION_META OUT=work.TABLE_PARTITION_META;
 
 
by table_nm;
 
 
run;
 
 
 
proc sql;
 
 
delete * from &m_di_trans..TABLE_PARTITION_META ;
 
 
insert into &m_di_trans..TABLE_PARTITION_META
select * from work.TABLE_PARTITION_META;
 
 
drop table work.TABLE_PARTITION_META;
 
 
quit;
 
 
 
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: TABLE_PART_META_SORT;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: TABLE_PART_META_SORT;
%put ERROR- Description                              : Sort table_partition_meta;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 27SEP2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: TABLE_PART_META_SORT;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"TABLE_PART_META_SORT",
"Sort table_partition_meta",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%TABLE_PART_META_SORT:;
 
 
* End of changes for CHANGE_ID:TABLE_PART_META_SORT;
 
 
***********************************************************************************************;
*************************************  End Change TABLE_PART_META_SORT ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change COMMONLST_FILE ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: COMMONLST_FILE;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("COMMONLST_FILE")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(libref(DI_TRANS)) = 0) %then
%do;
%put NOTE: Skip this change since this library is not assigned: DI_TRANS;
%put NOTE: Change ID                             :COMMONLST_FILE;
%goto COMMONLST_FILE;
 
%end;
%if not (%sysfunc(exist(DI_TRANS.TABLE_PARTITION_META))) %then
%do;
%put NOTE: Skip this change since this table does not exist: DI_TRANS.TABLE_PARTITION_META;
%put NOTE: Change ID                             :COMMONLST_FILE;
%goto COMMONLST_FILE;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : COMMONLST_FILE;
%goto COMMONLST_FILE;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : COMMONLST_FILE;
* Insert record into change management table for CHANGE_ID: COMMONLST_FILE;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"COMMONLST_FILE",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto COMMONLST_FILE;
 
%end;
 
 
 
 
%put NOTE: Skipping this change since this change should never be applied.;
%put NOTE- Change ID                             :COMMONLST_FILE;
%goto COMMONLST_FILE;
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
 
%let DI_MISC_PATH=%di_util_misc_path();
 
 
 
%if %sysfunc(exist(DI_TRANS.TABLE_PARTITION_META))
%then %do;
 
 
filename comm "&DI_MISC_PATH/dbmsc/common-files.lst";
 
 
data _null_;
 
 
file comm lrecl=32000;;
 
 
set di_trans.table_partition_meta (where=(full_copy_flg=1));
 
 
table_nm=lowcase(table_nm);
 
 
 
indfile=trim(table_nm) || ".sas7bdat" ;
 
 
put comm @1 indfile;
 
 
 
if (lowcase(table_nm) not in ("attr_spec","model_data_agg","psychological_points","model_exception","price_point_correction",
"iso_currency","prod_cross_relation") ) then do;
 
 
indfile=trim(table_nm) || ".sas7bndx" ;
 
 
put comm @1 indfile;
 
 
end;
 
 
run;
 
 
filename comm clear;
 
 
 
 
%end;
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
 
%let DI_MISC_PATH=%di_util_misc_path();
 
 
 
%if %sysfunc(exist(DI_TRANS.TABLE_PARTITION_META))
%then %do;
 
 
filename comm "&DI_MISC_PATH/dbmsc/common-files.lst";
 
 
data _null_;
 
 
file comm lrecl=32000;;
 
 
set di_trans.table_partition_meta (where=(full_copy_flg=1));
 
 
table_nm=lowcase(table_nm);
 
 
 
indfile=trim(table_nm) || ".sas7bdat" ;
 
 
put comm @1 indfile;
 
 
 
if (lowcase(table_nm) not in ("attr_spec","model_data_agg","psychological_points","model_exception","price_point_correction",
"iso_currency","prod_cross_relation") ) then do;
 
 
indfile=trim(table_nm) || ".sas7bndx" ;
 
 
put comm @1 indfile;
 
 
end;
 
 
run;
 
 
filename comm clear;
 
 
 
 
%end;
 
 
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: COMMONLST_FILE;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: COMMONLST_FILE;
%put ERROR- Description                              : Refresh Table Partition Meta;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 05JUN2012;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: COMMONLST_FILE;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"COMMONLST_FILE",
"Refresh Table Partition Meta",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%COMMONLST_FILE:;
 
 
* End of changes for CHANGE_ID:COMMONLST_FILE;
 
 
***********************************************************************************************;
*************************************  End Change COMMONLST_FILE ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change DROP_PACK_OPT_PROD_SETTING ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: DROP_PACK_OPT_PROD_SETTING;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("DROP_PACK_OPT_PROD_SETTING")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_trans..PACK_OPT_PROD_SETTING))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_trans..PACK_OPT_PROD_SETTING;
%put NOTE: Change ID                             :DROP_PACK_OPT_PROD_SETTING;
%goto DROP_PACK_OPT_PROD_SETTING;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : DROP_PACK_OPT_PROD_SETTING;
%goto DROP_PACK_OPT_PROD_SETTING;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : DROP_PACK_OPT_PROD_SETTING;
* Insert record into change management table for CHANGE_ID: DROP_PACK_OPT_PROD_SETTING;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"DROP_PACK_OPT_PROD_SETTING",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto DROP_PACK_OPT_PROD_SETTING;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
DROP TABLE PACK_OPT_PROD_SETTING
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
DROP TABLE PACK_OPT_PROD_SETTING;
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: DROP_PACK_OPT_PROD_SETTING;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: DROP_PACK_OPT_PROD_SETTING;
%put ERROR- Description                              : Drop table PACK_OPT_PROD_SETTING from schema;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 28SEP2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: DROP_PACK_OPT_PROD_SETTING;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"DROP_PACK_OPT_PROD_SETTING",
"Drop table PACK_OPT_PROD_SETTING from schema",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%DROP_PACK_OPT_PROD_SETTING:;
 
 
* End of changes for CHANGE_ID:DROP_PACK_OPT_PROD_SETTING;
 
 
***********************************************************************************************;
*************************************  End Change DROP_PACK_OPT_PROD_SETTING ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change DROP_PACK_OPT_PROD_DC_SETTING ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: DROP_PACK_OPT_PROD_DC_SETTING;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("DROP_PACK_OPT_PROD_DC_SETTING")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_trans..PACK_OPT_PROD_DC_SETTING))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_trans..PACK_OPT_PROD_DC_SETTING;
%put NOTE: Change ID                             :DROP_PACK_OPT_PROD_DC_SETTING;
%goto DROP_PACK_OPT_PROD_DC_SETTING;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : DROP_PACK_OPT_PROD_DC_SETTING;
%goto DROP_PACK_OPT_PROD_DC_SETTING;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : DROP_PACK_OPT_PROD_DC_SETTING;
* Insert record into change management table for CHANGE_ID: DROP_PACK_OPT_PROD_DC_SETTING;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"DROP_PACK_OPT_PROD_DC_SETTING",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto DROP_PACK_OPT_PROD_DC_SETTING;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
DROP TABLE PACK_OPT_PROD_DC_SETTING
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
DROP TABLE PACK_OPT_PROD_DC_SETTING;
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: DROP_PACK_OPT_PROD_DC_SETTING;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: DROP_PACK_OPT_PROD_DC_SETTING;
%put ERROR- Description                              : Drop table PACK_OPT_PROD_DC_SETTING from schema;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 28SEP2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: DROP_PACK_OPT_PROD_DC_SETTING;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"DROP_PACK_OPT_PROD_DC_SETTING",
"Drop table PACK_OPT_PROD_DC_SETTING from schema",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%DROP_PACK_OPT_PROD_DC_SETTING:;
 
 
* End of changes for CHANGE_ID:DROP_PACK_OPT_PROD_DC_SETTING;
 
 
***********************************************************************************************;
*************************************  End Change DROP_PACK_OPT_PROD_DC_SETTING ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID733917 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID733917;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID733917")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID733917;
%goto ID733917;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID733917;
* Insert record into change management table for CHANGE_ID: ID733917;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID733917",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID733917;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
 
%di_util_drop_constraint(m_lib=DI_TRANS, m_table=RPO_PLAN_MEMBER_RESULT_KPI,m_column=BASE_SALES_UNITS,m_constraint=not null, m_engine=ORACLE);
 
 
%di_util_drop_constraint(m_lib=DI_TRANS, m_table=RPO_PLAN_MEMBER_RESULT_KPI,m_column=BASE_REVENUE_AMT,m_constraint=not null, m_engine=ORACLE);
 
 
%di_util_drop_constraint(m_lib=DI_TRANS, m_table=RPO_PLAN_MEMBER_RESULT_KPI,m_column=BASE_MARGIN_AMT,m_constraint=not null, m_engine=ORACLE);
 
 
%di_util_drop_constraint(m_lib=DI_TRANS, m_table=RPO_PLAN_MEMBER_RESULT_KPI,m_column=BASE_MARGIN_PCT,m_constraint=not null, m_engine=ORACLE);
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
 
%di_util_drop_constraint(m_lib=di_trans, m_table=RPO_PLAN_MEMBER_RESULT_KPI, m_column=%str(BASE_SALES_UNITS), m_constraint=%str(not null));
 
 
%di_util_drop_constraint(m_lib=di_trans, m_table=RPO_PLAN_MEMBER_RESULT_KPI, m_column=%str(BASE_REVENUE_AMT), m_constraint=%str(not null));
 
 
%di_util_drop_constraint(m_lib=di_trans, m_table=RPO_PLAN_MEMBER_RESULT_KPI, m_column=%str(BASE_MARGIN_AMT), m_constraint=%str(not null));
 
 
%di_util_drop_constraint(m_lib=di_trans, m_table=RPO_PLAN_MEMBER_RESULT_KPI, m_column=%str(BASE_MARGIN_PCT), m_constraint=%str(not null));
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID733917;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID733917;
%put ERROR- Description                              : Drop NOT NULL Constraints for KPIs in RPO_PLAN_MEMBER_RESULT_KPI;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 28SEP2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID733917;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID733917",
"Drop NOT NULL Constraints for KPIs in RPO_PLAN_MEMBER_RESULT_KPI",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID733917:;
 
 
* End of changes for CHANGE_ID:ID733917;
 
 
***********************************************************************************************;
*************************************  End Change ID733917 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID795430 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID795430;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID795430")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID795430;
%goto ID795430;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID795430;
* Insert record into change management table for CHANGE_ID: ID795430;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID795430",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID795430;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
update model_spec set spec_value = '20.0' where spec_nm = 'TS_SEASON_MAX' and model_group_id = -1
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
update model_spec_default set default_spec_value = '20.0' where spec_nm = 'TS_SEASON_MAX'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
update model_spec set spec_value = '10.0' where spec_nm = 'TS_SEASON_VAR' and model_group_id = -1
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
update model_spec_default set default_spec_value = '10.0' where spec_nm = 'TS_SEASON_VAR'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
update model_spec set spec_value = '20.0' where spec_nm = 'TS_SEASON_MAX' and model_group_id = -1;
 
 
update model_spec_default set default_spec_value = '20.0' where spec_nm = 'TS_SEASON_MAX';
 
 
update model_spec set spec_value = '10.0' where spec_nm = 'TS_SEASON_VAR' and model_group_id = -1;
 
 
update model_spec_default set default_spec_value = '10.0' where spec_nm = 'TS_SEASON_VAR';
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID795430;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID795430;
%put ERROR- Description                              : TS_SEASON_VAR and TS_SEASON_MAX migration - step 1;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 28SEP2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID795430;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID795430",
"TS_SEASON_VAR and TS_SEASON_MAX migration - step 1",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID795430:;
 
 
* End of changes for CHANGE_ID:ID795430;
 
 
***********************************************************************************************;
*************************************  End Change ID795430 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID795430_1 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID795430_1;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID795430_1")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID795430_1;
%goto ID795430_1;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID795430_1;
* Insert record into change management table for CHANGE_ID: ID795430_1;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID795430_1",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID795430_1;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
update model_spec set spec_value = exp(to_number(spec_value))
where spec_nm = 'TS_SEASON_MAX' and model_group_id != -1
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
 
proc sql;
 
 
update &m_di_trans..model_spec set spec_value = put(exp(input(spec_value,BEST10.)),BEST10.)
where spec_nm = 'TS_SEASON_MAX' and model_group_id <> -1;
 
 
quit;
 
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID795430_1;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID795430_1;
%put ERROR- Description                              : TS_SEASON_VAR and TS_SEASON_MAX migration - step 2;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 28SEP2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID795430_1;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID795430_1",
"TS_SEASON_VAR and TS_SEASON_MAX migration - step 2",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID795430_1:;
 
 
* End of changes for CHANGE_ID:ID795430_1;
 
 
***********************************************************************************************;
*************************************  End Change ID795430_1 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID797643 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID797643;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID797643")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID797643;
%goto ID797643;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID797643;
* Insert record into change management table for CHANGE_ID: ID797643;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID797643",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID797643;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'FA_SCORE_FUNC'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
delete from FA_SPEC where SPEC_NM = 'FA_SCORE_FUNC'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'FA_SCORE_FUNC';
 
 
delete from FA_SPEC where SPEC_NM = 'FA_SCORE_FUNC';
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID797643;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID797643;
%put ERROR- Description                              : Remove FA_SCORE_FUNC FA spec;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 29SEP2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID797643;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID797643",
"Remove FA_SCORE_FUNC FA spec",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID797643:;
 
 
* End of changes for CHANGE_ID:ID797643;
 
 
***********************************************************************************************;
*************************************  End Change ID797643 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID797052 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID797052;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID797052")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_trans..MODEL_SPEC_DEFAULT))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_trans..MODEL_SPEC_DEFAULT;
%put NOTE: Change ID                             :ID797052;
%goto ID797052;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID797052;
%goto ID797052;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID797052;
* Insert record into change management table for CHANGE_ID: ID797052;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID797052",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID797052;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'MAX_PRICE_RATIO'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
values ('MAX_PRICE_RATIO','ALL','1','1.0',NULL)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
%let m_sql_statement = %str(
insert into MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
values ('MAX_PRICE_RATIO','ALL','2','1.0',NULL)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'MAX_PRICE_RATIO';
 
 
insert into MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
values ('MAX_PRICE_RATIO','ALL','1','1.0',NULL);
 
 
insert into MODEL_SPEC_DEFAULT (SPEC_NM,MODEL_COMP_NM,SPEC_TYPE,DEFAULT_SPEC_VALUE,PRIORITY)
values ('MAX_PRICE_RATIO','ALL','2','1.0',NULL);
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID797052;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID797052;
%put ERROR- Description                              : Surface model spec MAX_PRICE_RATIO for user editing;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 30SEP2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID797052;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID797052",
"Surface model spec MAX_PRICE_RATIO for user editing",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID797052:;
 
 
* End of changes for CHANGE_ID:ID797052;
 
 
***********************************************************************************************;
*************************************  End Change ID797052 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID761590_4 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID761590_4;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID761590_4")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID761590_4;
%goto ID761590_4;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52,M2MI42);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID761590_4;
* Insert record into change management table for CHANGE_ID: ID761590_4;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID761590_4",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID761590_4;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
CREATE TABLE RPP_METRICS
(
OBJECT_CAT_SK   INTEGER NOT NULL,
OBJECT_CAT_TYPE INTEGER NOT NULL,
PROD_HIER_SK    INTEGER NOT NULL,
GEO_HIER_SK     INTEGER NOT NULL,
START_DT        DATE NOT NULL,
END_DT          DATE NOT NULL,
KPI             INTEGER NOT NULL,
KPI_TYPE        INTEGER NOT NULL,
KPI_VALUE       NUMERIC(20,3) NOT NULL
)
 
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
%let m_sql_statement = %str(
ALTER TABLE RPP_METRICS add CONSTRAINT RPP_METRICS_PK
PRIMARY KEY (OBJECT_CAT_SK,OBJECT_CAT_TYPE,PROD_HIER_SK,GEO_HIER_SK,START_DT)
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
CREATE TABLE RPP_METRICS
(
OBJECT_CAT_SK   INTEGER NOT NULL,
OBJECT_CAT_TYPE INTEGER NOT NULL,
PROD_HIER_SK    INTEGER NOT NULL,
GEO_HIER_SK     INTEGER NOT NULL,
START_DT        DATE NOT NULL,
END_DT          DATE NOT NULL,
KPI             INTEGER NOT NULL,
KPI_TYPE        INTEGER NOT NULL,
KPI_VALUE       NUMERIC(20,3) NOT NULL
)
;
 
 
 
ALTER TABLE RPP_METRICS add CONSTRAINT RPP_METRICS_PK
PRIMARY KEY (OBJECT_CAT_SK,OBJECT_CAT_TYPE,PROD_HIER_SK,GEO_HIER_SK,START_DT);
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID761590_4;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID761590_4;
%put ERROR- Description                              : Table for storing custom metrics for calendar and category plans;
%put ERROR- Version                                  : D3MICM52,M2MI42;
%put ERROR- Date of Change                           : 05OCT2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID761590_4;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID761590_4",
"Table for storing custom metrics for calendar and category plans",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID761590_4:;
 
 
* End of changes for CHANGE_ID:ID761590_4;
 
 
***********************************************************************************************;
*************************************  End Change ID761590_4 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID799648 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID799648;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID799648")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_trans..MODEL_SPEC_DEFAULT))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_trans..MODEL_SPEC_DEFAULT;
%put NOTE: Change ID                             :ID799648;
%goto ID799648;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID799648;
%goto ID799648;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquote(&m_baseline_versions),
_string_to_search=%bquote(&m_version),_found_posn=%bquote(m_version_posn), _delim=%bquote(,)  )
%if ( &m_version_posn > 0 ) %then
%do;
%put ;
%put NOTE: Log and Skip!! Baseline schema includes change : ID799648;
* Insert record into change management table for CHANGE_ID: ID799648;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID799648",
'Skip!! This change is included in baseline',
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%goto ID799648;
 
%end;
 
 
 
 
%if (&m_di_trans_vendor in (ORACLE POSTGRE DB2)) %then %do;
 
%let m_sql_statement = %str(
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'LIMIT_PRICE_RATIO_UPPER'
);
 
 
%di_dm_trans_exe(pass_through_sql=%quote(&m_sql_statement),session_flg=1);
 
 
 
 
%end;
 
 
%if (&m_di_trans_vendor in (SAS)) %then %do;
 
proc sql;
 
 
 
delete from MODEL_SPEC_DEFAULT where SPEC_NM = 'LIMIT_PRICE_RATIO_UPPER';
 
 
 
quit;
 
 
%end;
 
 
 
 
* Check for errors while processing CHANGE_ID: ID799648;
%if &syscc > 4 %then %do;
%put ERROR: Error occurred while processing change_id: ID799648;
%put ERROR- Description                              : Remove LIMIT_PRICE_RATIO_UPPER model spec;
%put ERROR- Version                                  : D3MICM52;
%put ERROR- Date of Change                           : 07OCT2011;
%put ERROR-  ;
%put ERROR- The value of syscc is &syscc;
%goto EXIT_RDBMS_DATA_MODEL_CHANGES;
%return;
%end;
 
 
* Insert record into change management table for CHANGE_ID: ID799648;
proc sql;
insert  into di_trans.rdbms_DM_change_management
values (
"ID799648",
"Remove LIMIT_PRICE_RATIO_UPPER model spec",
%sysfunc(datetime()),
"&m_user"
);
quit;
 
 
%ID799648:;
 
 
* End of changes for CHANGE_ID:ID799648;
 
 
***********************************************************************************************;
*************************************  End Change ID799648 ************************************;
***********************************************************************************************;
 
 
 
 
***********************************************************************************************;
************************************  Begin Change ID800510 ***********************************;
***********************************************************************************************;
 
 
* Check to see if this change has already been applied. CHANGE_ID: ID800510;
%let m_ldate=;
%let m_ldesc=;
%let m_luser=;
 
data _null_;
 
set di_trans.rdbms_DM_change_management (where=(upper(change_id)=upper("ID800510")));
call symputx("m_ldesc", change_desc);
call symputx("m_ldate", date_change_applied);
call symputx("m_luser", user_applying_change);
 
run;
 
 
%if not (%sysfunc(exist(&m_di_trans..MODEL_SPEC_DEFAULT))) %then
%do;
%put NOTE: Skip this change since this table does not exist: &m_di_trans..MODEL_SPEC_DEFAULT;
%put NOTE: Change ID                             :ID800510;
%goto ID800510;
 
%end;
%if (%length(&m_ldate)>2) %then
%do;
%put ;
%put NOTE: Skipping!! Already applied change : ID800510;
%goto ID800510;
 
%end;
 
%put ;
 
 
 
 
%*global m_version_posn;
%let m_version=%str(D3MICM52);
%di_util_find_word(_list_of_words_to_find=%bquo