<%/*--------------------------------------------------------------------------------------|
|Copyright (c) 2010, SAS Institute, Inc.  All Rights Reserved.
|
|NAME: rules/tiles/weakDependency.jsp
|DESCRIPTION: JSP page to display a rule that sets a user variable used by another rule
|---------------------------------------------------------------------------------------*/%>
 

<%@ include file="/common/taglibsT3.jsp" %>
<%@ page contentType="text/html; charset=UTF-8" %>

<%-- Access variables passed from caller --%>
<tiles:importAttribute name="rule" />
<tiles:importAttribute name="none" />

<c:choose>

   <c:when test="${empty rule.weakDependencies}"></c:when>

   <c:when test="${rule.workflow.state!='Coding' && rule.workflow.state!='Testing' && rule.workflow.state!='Production'}">
      <c:set var='sep' value=' '/>
      <c:forEach var="d" items="${rule.weakDependencies}">${sep}Rule ${d.baseRuleId}.${d.version}<c:set var='sep' value=', '/></c:forEach>
   </c:when>

   <c:otherwise>
      <c:set var='sep' value=' '/>
      <c:forEach var="d" items="${rule.weakDependencies}">
         ${sep}#${fn:substring(d.ruleType.name,0,1)}${d.baseRuleId}: ${fn:escapeXml(d.name)} - ${d.workflowState}&nbsp;&nbsp;<i>(sets ${fn:toUpperCase(d.keywords)})</i> <%-- S0881932 --%>
         <c:set var='sep' value='<br>'/>
      </c:forEach>
   </c:otherwise>

</c:choose>
