<%/*--------------------------------------------------------------------------------------|
|Copyright (c) 2005-2008, SAS Institute, Inc.  All Rights Reserved.
|
|NAME: rules/tiles/transactionProperties.jsp
|DESCRIPTION: JSP page to allow the setting and display of transactions
|---------------------------------------------------------------------------------------*/%>


<%@ include file="/common/taglibsT3.jsp" %>
<%@ page contentType="text/html; charset=UTF-8" %>


<%@ page import="java.util.List" %>


<SCRIPT language="JavaScript" src="common/scripts/cf.js"></SCRIPT>
<script type="text/javascript" src='common/scripts/jquery.js'></script>
<script language="JavaScript" src="common/scripts/jquery.fcm.dynaform.js"></script>
<script language="JavaScript" src="rules/scripts/rules.js"></script>
<script language="JavaScript" src="rules/scripts/tasks.js"></script>
<script language="JavaScript" src="rules/scripts/ruleActions.js"></script>
<script language="JavaScript" src="rules/scripts/dynamicRows.js"></script>
<script language="JavaScript" src="rules/scripts/itemPriorityList.js"></script>
<script language="JavaScript" src="rules/scripts/autoSizing.js"></script>
<SCRIPT language="JavaScript" src="common/scripts/calendar.js"></SCRIPT>
<SCRIPT language="JavaScript" src="rules/scripts/sort.js"></SCRIPT>
<SCRIPT language="JavaScript" src="rules/scripts/transactions.js"></SCRIPT>
<SCRIPT language="JavaScript" src="rules/scripts/expander.js"></SCRIPT>

<STYLE>
.softNone
{
   color:black;
   font-style:italic;
   font-family:'AvenirNext',sans-serif;
   font-size:0.88rem;
}
</STYLE>


<script>

$(document).ready(function(){  // RAPTOR-2399
<!-- want to make the form readonly for predefined transactions -->
<c:if test="${transactionType.stock || updtTrxTyp==false}">
$('#transactionForm input[type=checkbox]').prop('disabled', true); // RAPTOR-2399
</c:if>
setComponentSelections();
});
</script>


<%-- Value of preRequisites is set when transaction code is parsed --%>
<input type="hidden" name="preRequisites"   id="preRequisites"   value="" />
<input type="hidden" name="preRequisiteIds" id="preRequisiteIds" value="" />

<TABLE  border="0" name="transactionPropertiesTable" style="border:0px;margin-left:0px; margin-right:10px" class="ruleIdeTable"
   cellspacing="0" cellpadding="0" width="100%">


   <%-- Establish column width and alignment on page --%>
   <tr class="ruleIdeTableDataRow" border=1>
        <td style="width:1%;" class="ruleIdeTableLabel"> &nbsp;</td>
        <td style="width:1%;"> &nbsp;</td>
        <td style="width:1%;"> &nbsp;</td>
        <td style="width:50%"> &nbsp;</td>
        <td style="width:1%;" class="ruleIdeTableLabel"> &nbsp;</td>
        <td style="width:10%"> &nbsp;</td>
        <td style="width:20%"> &nbsp;</td>
        <td style="width:1%;"> &nbsp;</td>
        <td style="width:1%;"> &nbsp;</td>
   <tr>


   <%-- Set time format (pending notice from Sriram on using a property for this) --%>
   <c:set var="pageTimeFormat" value="${timeFormat}"/>
   <c:if test="${empty pageTimeFormat}">
      <c:set var="pageTimeFormat" value="${timeFormat}"/>
   </c:if>

   <tr class="ruleIdeTableDataRow"><td colspan="9" valign="top" style="height:20px;" class="ruleIdeTableLabel"></td></tr>


    <tr class="ruleIdeTableDataRow" >
      <td valign="top" class="ruleIdeTableLabel" style="text-align:right"><fmt:message key="rules.ruleListDetailContent.tableHeader.id.txt"/>:&nbsp;</td>
      <td colspan="8" valign="top" style="text-align:left" style="padding:0px 0px 0px 0px;">
      	<input type="hidden" name="id" id="transactionId" value="${transactionType.id}"/>${transactionType.id}
      </td>
   </tr>
   <tr class="ruleIdeTableDataRow" >
      <td valign="top" class="ruleIdeTableLabel" style="text-align:right"><fmt:message key="rules.transactionDetailContent.transactionType.txt"/>:&nbsp;</td>
      <td colspan="8" valign="top" style="padding:0px 0px 0px 0px;text-align:left;">
      <c:choose>
      	<c:when test="${transactionType.stock || updtTrxTyp==false}">
      		<input type="hidden" name="desc" id="desc" value="${esapi:encodeForHTMLAttribute(transactionType.desc)}">
      		${esapi:encodeForHTML(transactionType.desc)}
      	</c:when>
      	<c:otherwise>
      		<input type="text" name="desc" id="desc" style="width:100%" value="${esapi:encodeForHTMLAttribute(transactionType.desc)}" maxlength="170">
      	</c:otherwise>
      </c:choose>
      </td>
   </tr>
  <c:set var="compTitle"><fmt:message key='rules.rule.componentTitle.ACCOUNT.txt'/></c:set>
  <tiles:insertTemplate template="component.jsp" flush="true">
     <tiles:putAttribute name="compTypeCode"    value="ACCOUNT" />
     <tiles:putAttribute name="compSubTypeCode" value=""        />
     <tiles:putAttribute name="compHead"        value="true"    />
     <tiles:putAttribute name="compTail"        value="true"    />
     <tiles:putAttribute name="compTitle"       value='${compTitle}'    />
  </tiles:insertTemplate>

  <c:set var="compTitle"><fmt:message key='rules.rule.componentTitle.ACTIVITY.txt'/></c:set>
  <tiles:insertTemplate template="component.jsp" flush="true">
     <tiles:putAttribute name="compTypeCode"    value="ACTIVITY" />
     <tiles:putAttribute name="compSubTypeCode" value="_mono"    />
     <tiles:putAttribute name="compHead"        value="true"     />
     <tiles:putAttribute name="compTail"        value="false"    />
     <tiles:putAttribute name="compTitle"       value="${compTitle}"    />
  </tiles:insertTemplate>
  <tiles:insertTemplate template="component.jsp" flush="true">
     <tiles:putAttribute name="compTypeCode"    value="ACTIVITY" />
     <tiles:putAttribute name="compSubTypeCode" value="_mast"    />
     <tiles:putAttribute name="compHead"        value="false"    />
     <tiles:putAttribute name="compTail"        value="false"    />
  </tiles:insertTemplate>
  <tiles:insertTemplate template="component.jsp" flush="true">
     <tiles:putAttribute name="compTypeCode"    value="ACTIVITY" />
     <tiles:putAttribute name="compSubTypeCode" value="_detl"    />
     <tiles:putAttribute name="compHead"        value="false"    />
     <tiles:putAttribute name="compTail"        value="true"     />
  </tiles:insertTemplate>

  <c:set var="compTitle"><fmt:message key='rules.rule.componentTitle.CHANNEL.txt'/></c:set>
  <tiles:insertTemplate template="component.jsp" flush="true">
     <tiles:putAttribute name="compTypeCode"    value="CHANNEL" />
     <tiles:putAttribute name="compSubTypeCode" value=""        />
     <tiles:putAttribute name="compHead"        value="true"    />
     <tiles:putAttribute name="compTail"        value="true"    />
     <tiles:putAttribute name="compTitle"       value="${compTitle}"    />
  </tiles:insertTemplate>

  <c:set var="compTitle"><fmt:message key='rules.rule.componentTitle.AUTHENTICATION.txt'/></c:set>
  <tiles:insertTemplate template="component.jsp" flush="true">
     <tiles:putAttribute name="compTypeCode"    value="AUTHENTICATION" />
     <tiles:putAttribute name="compSubTypeCode" value=""               />
     <tiles:putAttribute name="compHead"        value="true"           />
     <tiles:putAttribute name="compTail"        value="true"    />
     <tiles:putAttribute name="compTitle"       value="${compTitle}"    />
  </tiles:insertTemplate>

  <c:set var="compTitle"><fmt:message key='rules.rule.componentTitle.CUSTOMER.txt'/></c:set>
  <tiles:insertTemplate template="component.jsp" flush="true">
     <tiles:putAttribute name="compTypeCode"    value="CUSTOMER" />
     <tiles:putAttribute name="compSubTypeCode" value=""         />
     <tiles:putAttribute name="compHead"        value="true"     />
     <tiles:putAttribute name="compTail"        value="true"    />
     <tiles:putAttribute name="compTitle"       value="${compTitle}"    />
   </tiles:insertTemplate>


   <tr class="ruleIdeTableDataRow"><td colspan="9" valign="top" style="height:20px;" class="ruleIdeTableLabel"></td></tr>

</TABLE>



