<%/*--------------------------------------------------------------------------------------|
|Copyright (c) 2007, SAS Institute, Inc.  All Rights Reserved.
|
|NAME: rules/tiles/printRule.jsp
|DESCRIPTION: JSP page to print a rule definition (not really a tile, used with <% include)
|---------------------------------------------------------------------------------------*/%>


<STYLE>
.softNone
{
   color:gray;
   font-style:italic;
   font-family:sans-serif;
   font-size:x-small;
}
</STYLE>

<%@ page contentType="text/html; charset=UTF-8" %>
<%@ include file="/common/taglibsT3.jsp" %>
<h3 id="title">${title}</h3>

<table  align="center" width="100%" cellspacing="0" cellpadding="0" style="margin-top:0px" border="0">

  <tr>
    <td style="width:1%;">&nbsp;</td>
    <td style="width:50%">&nbsp;</td>
    <td style="width:1%;">&nbsp;</td>
    <td style="width:35%">&nbsp;</td>
    <td style="width:1%;">&nbsp;</td>
  </tr>

  <tr>
    <td nowrap><b><fmt:message key="rules.printRule.ruleName.txt"/>:&nbsp;&nbsp;</td>
    <td id="name">${name}</td>
    <td nowrap><b>&nbsp;&nbsp;<fmt:message key="rules.printRule.createdBy.txt"/>:&nbsp;&nbsp;</td>
    <td nowrap id='createdInfo'>${createdInfo}</td>
  </tr>

  <tr>
    <td nowrap><b><fmt:message key="rules.printRule.ruleID.txt"/>:&nbsp;&nbsp;</td>
    <td nowrap id='ruleFormattedId'>
    	<fmt:message key="rules.printRule.rule.fmt.txt">
    		<fmt:param>${ruleTypeInfo}</fmt:param>
			<fmt:param>${baseRuleIdInfo}</fmt:param>
		</fmt:message>
		<span id='ruleTypeInfo' style="display:none;">${ruleTypeInfo}</span>
		<span id='baseRuleIdInfo' style="display:none;">${baseRuleIdInfo}</span>
    </td>
    <td nowrap><b>&nbsp;&nbsp;<fmt:message key="rules.printRule.updatedBy.txt"/>:&nbsp;&nbsp;</td>
    <td nowrap id='updatedInfo'>${updatedInfo}</td>
  </tr>

  <tr>
    <td nowrap><b><fmt:message key="rules.printRule.businessUnit.txt"/>:&nbsp;&nbsp;</td>
    <td nowrap><span id="ruleBusinessUnitInfo">${ruleBusinessUnitInfo}</span></td>
    <td nowrap><b>&nbsp;&nbsp;<fmt:message key="rules.printRule.executionOrder.txt"/>:&nbsp;&nbsp;</td>
    <td colspan="1" id="executionOrderInfo">${executionOrderInfo}</td>
  </tr>

  <c:set var="visibility" value="visible"/>                                                  <%-- S0750302 --%>
  <c:if test="${!empty enableXAMS}">                                                         <%-- S0750302 --%>
     <c:set var="visibility" value="hidden"/>                                                <%-- S0750302 --%>
  </c:if>                                                                                    <%-- S0750302 --%>

  <tr>
    <td nowrap style="visibility:${visibility}" id="queueLabel"><b><fmt:message key="rules.printRule.queue.txt"/>:&nbsp;&nbsp;</td>   <%-- S0750302 --%>
    <td nowrap style="visibility:${visibility}" id="queueId">${queueId}</td>                 <%-- S0750302 --%>
    <td nowrap><b>&nbsp;&nbsp;<fmt:message key="rules.printRule.alertType.txt"/>:&nbsp;&nbsp;</td>
    <td nowrap id="alertType">${alertType}</td>
  </tr>

  <tr>
    <td colspan="5">&nbsp;</td>
  </tr>

  <tr>
    <td nowrap><b><fmt:message key="rules.printRule.transactionScope.txt"/>:&nbsp;&nbsp;</td>
    <td nowrap colspan='4' id="multiOrgId">${multiOrgNodeId}</td>
  </tr>

  <tr>
    <td colspan="5">&nbsp;</td>
  </tr>

  <tr>
    <td nowrap><b><fmt:message key="rules.printRule.transactionType.txt"/>:&nbsp;&nbsp;</td>
    <td colspan="4" id="transactionType">${transactionType}</td>
  </tr>

  <tr><td>&nbsp;</td></tr>
    <tr>
    <td nowrap><b><fmt:message key="rules.printRule.maxExecutionTime.txt"/>:&nbsp;&nbsp;</td>
    <td colspan="4" id="maxExecutionTime">${operationalTimeLimit}</td>
  </tr>

  <tr><td>&nbsp;</td></tr>

  <tr>
    <td nowrap><b><fmt:message key="rules.printRule.description.txt"/>:&nbsp;&nbsp;</td>
    <td colspan="3" id="description">${description}</td>
  </tr>

  <tr><td>&nbsp;</td></tr>

  <tr>
    <td nowrap><b><fmt:message key="rules.printRule.alertReason.txt"/>:&nbsp;&nbsp;</td>
    <td colspan="3" id="alertReason">${alertReason}</td>
  </tr>

  <tr><td>&nbsp;</td></tr>

  <tr>
    <td nowrap><b><fmt:message key="rules.printRule.dependencies.txt"/>:&nbsp;&nbsp;</td>
    <td colspan="3"><span id="preRequisitesForDisplay">${preRequisitesForDisplay}</span>
                    <span id="dependencySeparator">${dependencySeparator}</span>
                    <span id="weakRequisitesForDisplay">${weakRequisitesForDisplay}</span></td>
  </tr>

  <tr><td>&nbsp;</td></tr>

  <tr>
    <td nowrap><b><fmt:message key="rules.printRule.variables.txt"/>:&nbsp;&nbsp;</td>
    <td colspan="3" id="usedVariablesForDisplay">${usedVariablesForDisplay}</td>
  </tr>

  <tr><td>&nbsp;</td></tr>

  <tr>
    <td nowrap><b><fmt:message key="rules.printRule.code.txt"/>:&nbsp;&nbsp;</td>
    <td colspan="3" id="code"><pre>${code}</pre></td>
  </tr>

</TABLE>

