<%/*--------------------------------------------------------------------------------------|
|Copyright (c) 2007, SAS Institute, Inc.  All Rights Reserved.
|
|NAME: rules/tiles/formatMsec.jsp
|DESCRIPTION: JSP page to format milliseconds of elapsed time into hh:mm:ss if msec > 10000
|---------------------------------------------------------------------------------------*/%>

<%@ include file="/common/taglibsT3.jsp" %>
<%@ page contentType="text/html; charset=UTF-8" %>
<%-- We access msec via request scope because I could not get tiles:put to pass a number --%>

<c:choose>

  <c:when test="${msec >= 10000}">
    <c:set var='hh' value="${msec/3600000}"/>
    <c:set var='mm' value="${(msec - ((hh-(hh%1))*3600000))/60000}"/>
    <c:set var='ss' value="${(msec/1000) % 60}"/>
    <fmt:formatNumber value="${hh - (hh%1)}" maxFractionDigits="0"/>:<fmt:formatNumber value="${mm - (mm%1)}" minIntegerDigits="2" maxFractionDigits="0"/>:<fmt:formatNumber value="${ss}" minIntegerDigits="2" maxFractionDigits="0"/>
  </c:when>

  <c:otherwise>
    <fmt:formatNumber value="${msec}" maxFractionDigits="0"/>
  </c:otherwise>

</c:choose>


