<%/*--------------------------------------------------------------------------------------|
|Copyright (c) 2008, SAS Institute, Inc.  All Rights Reserved.
|
|NAME: rules/tiles/consoleMonitorColumnHider.jsp
|DESCRIPTION: JSP page to display a selector for columns as a moveable DIV
|---------------------------------------------------------------------------------------*/%>


<%@ include file="/common/taglibsT3.jsp" %>
<%@ page contentType="text/html; charset=UTF-8" %>
<%-- Access variables passed from caller --%>
<tiles:importAttribute name="nameType" />
<tiles:importAttribute name="nameTitle" />
<tiles:importAttribute name="metricNames" />
<tiles:importAttribute name="onlyEvens" ignore="true" />



<div id='${nameType}ConsoleMonitorColumnHider' style='position:absolute;z-index:1000;left:-10000px;top:100px;display:inline;cursor:pointer;' onmousedown="consoleMonitorDragMouseDown('${nameType}')" onmouseup="consoleMonitorDragMouseUp()">
  <table class='mainTable'>
    <tr class="tableColumnHeaderRow" style="color:#353535;">
      <th class="centeredTableHeader" style='text-align:left;border-right:0px;cursor:default;' title='Click to show or hide columns' nowrap><b>${nameTitle}</b></td>
      <th class="centeredTableHeader" style='text-align:right;border-left:0px;cursor:default;' title='Close' onclick='showHideConsoleMonitorColumnHider("${nameType}")'><b>&nbsp;&nbsp;X</b></td>
    </tr>
    <c:forEach var="metricName" items="${metricNames}" varStatus='status'>
      <c:choose>
      <c:when test="${onlyEvens!='true' || (onlyEvens=='true' && status.index%2==0)}">
         <tr><td id='select_${nameType}_${metricName}'
                 class="configurationTableDataRow" colspan=2 style='display:inline;background-color:white;font-weight:bold;color:black;' nowrap
                 onmouseover='consoleMonitorHover(this)'
                 onmouseout='consoleMonitorUnhover(this)'
                 onclick='showHideConsoleMonitorColumn("${nameType}","${metricName}",this)' title="Click to show or hide <fmt:message key='console.monitor.pipeline.${metricName}.desc.txt'/>"><fmt:message key='console.monitor.pipeline.${metricName}.label.txt'/></td></tr>
      </c:when>
      <c:otherwise>
      </c:otherwise>
      </c:choose>
    </c:forEach>
  </table>
</div>
