<%/*--------------------------------------------------------------------------------------|
|Copyright (c) 2009, SAS Institute, Inc.  All Rights Reserved.
|
|NAME: rules/tiles/component.jsp
|DESCRIPTION: JSP page to display a component
|---------------------------------------------------------------------------------------*/%>


<%@ include file="/common/taglibsT3.jsp" %>
<%@ page contentType="text/html; charset=UTF-8" %>

<%-- Access variables passed from caller --%>
<tiles:importAttribute name="compTypeCode" />
<tiles:importAttribute name="compSubTypeCode" />
<tiles:importAttribute name="compHead"/>
<tiles:importAttribute name="compTail"/>
<tiles:importAttribute name="compTitle" ignore="true"/>



<c:set var="compKey">${compTypeCode}${compSubTypeCode}</c:set>
<c:set var="compTypeLabel" value="${sasEditorSelectorMaps.compLabelMap[compKey][0].typeLabel}" />
<c:set var="compSubTypeLabelResourceKey" value="${sasEditorSelectorMaps.compLabelMap[compKey][0].subTypeLabelResourceKey}" />
<c:set var="compSubTypeLabel"><c:if test="${not empty compSubTypeLabelResourceKey}"><fmt:message key="${compSubTypeLabelResourceKey}"/></c:if></c:set>

<c:set var="compOpenBorderColor"      value="#F5DEB3" />
<c:if test="${compTail=='true'}">
 <c:set var="compOpenBorderColor"     value="#719db9" />
</c:if>

<c:set var="compClosedBorderColor"    value="#e0e2e5" />

<c:if test="${empty compTitle}">
	<c:set var="compTitle" value="${compTypeLabel}" />
</c:if>

  <c:if test="${compHead=='true'}">
   <tr id="${compTypeCode}Head" style="display:;" class="ruleIdeTableComponentRow">
     <td id="${compTypeCode}LabelTD" style="white-space:nowrap;text-align:right">&nbsp;&nbsp;&nbsp;&nbsp;${compTitle}:&nbsp;</td>
     <td colspan='7' id="${compTypeCode}ValueTD"
         onclick="showHideComponent('${compTypeCode}','${compSubTypeCode}')"
         onmouseover="componentHover(this)" onmouseout="componentUnhover(this)"
         class="componentClosedHead" style="">
        <div style="float:left;"><img id="${compTypeCode}ImgDn" style="display:;" src="admin/images/sprite_arrow_right_light.png"/><img id="${compTypeCode}ImgUp" src="admin/images/sprite_arrow_down_light.png" style="display:none;" />&nbsp;</div>
        <div id="${compTypeCode}Values" style="text-align:left;color:white;padding-left:5px;"><i><fmt:message key="rules.rule.not.relevant.txt"/></i></div>
     </td>
     <td>&nbsp;</td>
   </tr>
  </c:if>

  <c:if test="${not empty compSubTypeLabel}">
   <tr id="${compTypeCode}${compSubTypeCode}LabelTR" style="display:none;" class="ruleIdeTableComponentRow">
     <td>&nbsp;</td>
     <td class="componentSubTypeLabel" colspan="7">${compSubTypeLabel} &nbsp; </td>
     <td >&nbsp;</td>
   </tr>
  </c:if>

   <tr id="${compTypeCode}${compSubTypeCode}All" style="display:none;" class="ruleIdeTableComponentRow">
     <td>&nbsp;</td>
     <td class="componentSubTypeLineLeft"> &nbsp; </td>
     <td class="componentSubTypeLine">&nbsp;&nbsp;<input type=checkbox id='Checkbox${compTypeCode}${compSubTypeCode}All' value='' onclick="toggleAll(this,'${compTypeCode}${compSubTypeCode}')"></td>
     <td class="componentSubTypeLine componentSubTypeLineLabel" onclick="toggleCheckbox('Checkbox${compTypeCode}${compSubTypeCode}All');toggleAll(document.getElementById('Checkbox${compTypeCode}${compSubTypeCode}All'),'${compTypeCode}${compSubTypeCode}')">
         <c:if test="${empty compSubTypeLabel}"><fmt:message key="rules.components.select.allTypes.fmt.txt"><fmt:param>${compTitle}</fmt:param></fmt:message></c:if>
         <c:if test="${not empty compSubTypeLabel}"><fmt:message key="rules.components.select.subTypes.fmt.txt"><fmt:param>${compSubTypeLabel}</fmt:param></fmt:message></c:if>
     </td>
     <td class="componentSubTypeLine">&nbsp;</td>
     <td class="componentSubTypeLine">&nbsp;</td>
     <td class="componentSubTypeLine">&nbsp;</td>
     <td class="componentSubTypeLineRight">&nbsp;</td>
     <td>&nbsp;</td>
   </tr>

   <c:set var="openClose" value="close"/>
   <c:forEach var="compValue" items="${sasEditorSelectorMaps.compLabelMap[compKey]}" varStatus="status">

     <c:set var="compLastStyle" value="border-bottom:1px solid ${compClosedBorderColor}"/>
     <c:if test="${ status.count==fn:length(sasEditorSelectorMaps.compLabelMap[compKey]) || (status.count%2==1 && status.count==fn:length(sasEditorSelectorMaps.compLabelMap[compKey])-1) }">
       <c:set var="compLastStyle" value="border-bottom:1px solid ${compOpenBorderColor}"/>
     </c:if>

     <c:choose>
       <c:when test="${status.count%2==1}">
         <tr id="${compTypeCode}${compSubTypeCode}${status.count}" style="display:none;">
           <td>&nbsp;</td>
           <td class="componentSubTypeLineLeft" style="${compLastStyle}">&nbsp;</td>
           <td class="componentSubTypeLine" style="${compLastStyle}">
              &nbsp;&nbsp;<input id="component_${compTypeCode}${compSubTypeCode}${compValue.value}"
                     type=checkbox
                     component='${compTypeLabel}'
                     value='${compValue.id}:${compValue.associates}:${compValue.name}'
                     onclick="changeCompList('${compTypeCode}')">
           </td>
           <td class="componentSubTypeLine componentSubTypeLineLabel" style="${compLastStyle};"
               id="componentTD:${compValue.id}:${compValue.fields}:${compValue.value}"
               component='${compTypeLabel}'
               onclick="toggleCheckbox('component_${compTypeCode}${compSubTypeCode}${compValue.value}');changeCompList('${compTypeCode}')">
              ${compValue.desc} (${compValue.value})
           </td>
           <c:set var="openClose" value="open"/>
       </c:when>
       <c:otherwise>
           <td class="componentSubTypeLine" style="${compLastStyle}">
              &nbsp;&nbsp;<input id="component_${compTypeCode}${compSubTypeCode}${compValue.value}"
                     type=checkbox
                     component='${compTypeLabel}'
                     value='${compValue.id}:${compValue.associates}:${compValue.name}'
                     onclick="changeCompList('${compTypeCode}')">
           </td>
           <td colspan="3" class="componentSubTypeLineRight componentSubTypeLineLabel"  style="${compLastStyle};"
               id="componentTD:${compValue.id}:${compValue.fields}:${compValue.value}"
               component='${compTypeLabel}'
               onclick="toggleCheckbox('component_${compTypeCode}${compSubTypeCode}${compValue.value}');changeCompList('${compTypeCode}')">
              ${compValue.desc} (${compValue.value})
           </td>
           <td>&nbsp;</td>
           <c:set var="openClose" value="close"/>
         </tr>
       </c:otherwise>
     </c:choose>

   </c:forEach>

   <c:if test="${openClose!='close'}">
      <td colspan="4" class="componentSubTypeLineRight" style="${compLastStyle}">&nbsp;</td>
      <td>&nbsp;</td>
     </tr>
   </c:if>


<c:set var="notRelevant"><fmt:message key="rules.rule.not.relevant.txt"/></c:set>

<SCRIPT>
// Collect the component definitions for Javascript
var compTypeCodes;
if (!compTypeCodes)
  compTypeCodes = new Array();
var cst = compTypeCodes["${compTypeCode}"];
if (!cst) {
  cst = new Array();
  compTypeCodes["${compTypeCode}"] = cst;
}
cst.push("${compSubTypeCode}");
var NOT_RELEVANT_TEXT="${esapi:encodeForJavaScript(notRelevant)}";
</SCRIPT>





