<%/*--------------------------------------------------------------------------------------|
|Copyright (c) 2010, SAS Institute, Inc.  All Rights Reserved.
|
|NAME: rules/tiles/columnHider.jsp
|DESCRIPTION: JSP page to display a selector for columns as a moveable DIV
|
|To use the columnHider to allow your user to show/hide columns in a table:
|
|1. Include scripts/columnHider.js in your page
|2. Pick a unique name for your table's column hider (alphanum+underscores to be safe), for example:
|   myImportantData
|3. Include tiles/columnHider.jsp where you want the show/hider symbol to be, for example:
|   <tiles:insert page="/rules/tiles/columnHider.jsp" flush="true">
|     <tiles:put name="columnHiderName" value="myImportantData" />
|   </tiles:insert>
|4. In your page's onload, call columnHiderOnLoad(namelist) where namelist is a
|   blank-separated list of the unique names you made up for this page.  For example:
|   onload="columnHiderOnLoad('myImportantData myEntertainingData')"
|5. In every <TH> and <TD> to be shown/hidden, include columnhiderid= where the value is
|   the column hider name plus and underscore plus the column name.  For example:
|   <TH columnhiderid="myImportantData_total_amt">...
|6. Each <TH> innerHTML is used to form the show/hide selector popup
|7. If there is a <TH> that should be shown/hidden but not appear in the popup,
|   end its name with +++
|
|---------------------------------------------------------------------------------------*/%>


<%@ include file="/common/taglibsT3.jsp" %>
<%@ page contentType="text/html; charset=UTF-8" %>
<%-- Access variables passed from caller --%>
<tiles:importAttribute name="columnHiderName" />

<style>
.columnHider th,
.columnHider td {
	font-size:0.70rem !important;
}
</style>

<image src='analyst/images/down.gif' onclick='showHideColumnHider("${columnHiderName}")' title="<esapi:encodeForHTMLAttribute><fmt:message key='rules.columnHider.selectColumns.title.txt'/></esapi:encodeForHTMLAttribute>" style='cursor:pointer;' />

<div id='${columnHiderName}_ColumnHiderDiv' class="columnHider" style='position:absolute;z-index:1000;left:-10000px;top:100px;display:inline;cursor:pointer;border:#7F9DB9 1px solid;'>
  <table id="${columnHiderName}_ColumnHiderTable" class='mainTable' border=1>
    <thead>
      <tr class="tableColumnHeaderRow" style="color:#353535;">
        <th class="centeredTableHeader" style='text-align:left;border-right:0px;cursor:default;' nowrap colspan='3'><b><fmt:message key="rules.columnHider.selectColumns.txt" /></b></th>
        <th class="centeredTableHeader" style='text-align:right;border-left:0px;cursor:default;' nowrap colspan='1'>
          <b title="<esapi:encodeForHTMLAttribute><fmt:message key='rules.columnHider.showAllColumns.title.txt'/></esapi:encodeForHTMLAttribute>" onclick='flipEveryColumn("${columnHiderName}",true)' style="cursor:pointer;">&nbsp;&nbsp;<fmt:message key="rules.columnHider.reset.txt" />&nbsp;&nbsp;</b>
          <b title="<esapi:encodeForHTMLAttribute><fmt:message key='rules.columnHider.reverseSettings.title.txt'/></esapi:encodeForHTMLAttribute>" onclick='flipEveryColumn("${columnHiderName}")' style="cursor:pointer;">&nbsp;&nbsp;<fmt:message key="rules.columnHider.flip.txt" />&nbsp;&nbsp;</b>
          <b title="<esapi:encodeForHTMLAttribute><fmt:message key='rules.columnHider.close.title.txt'/></esapi:encodeForHTMLAttribute>" onclick='showHideColumnHider("${columnHiderName}")' style="cursor:pointer;">&nbsp;&nbsp;[X]&nbsp;</b>
        </th>
      </tr>
    </thead>
    <tbody id="${columnHiderName}_ColumnHiderBody">
    </tbody>
  </table>
</div>



