<%@ include file="/common/taglibsT3.jsp"%>
<%@ page contentType="text/html; charset=UTF-8"%>
<style>
DIV.scrollableGrid {
	BORDER-RIGHT: none;
	BORDER-TOP: none;
	BORDER-LEFT: none;
	BORDER-BOTTOM: none;
	OVERFLOW: auto;
	TOP: 0px;
	LEFT: 0px;
	position: relative;
	vertical-align: top;
}

DIV.scrollableGrid thead th {
	z-index: 30;
	position: relative;
	top: expression(getElementById("ruleDiv").scrollTop );
}

.rowSelected {
	background-color: #ddddee;
	color: #3300CC;
}

eXtremeTable .odd a,.even a {
	color: Black;
	font-size: 0.88rem;
	background-color: #FFFFFF;
}

.eXtremeTable .odd td,.eXtremeTable .even td {
	padding-top: 2px;
	padding-right: 3px;
	padding-bottom: 2px;
	padding-left: 3px;
	vertical-align: middle;
	font-family: 'AvenirNext', verdana, arial, helvetica, sans-serif;
	font-size: 0.88rem;
}

.eXtremeTable .odd {
	background-color: #FFFFFF;
}

.eXtremeTable .even {
	background-color: #f0f1f2;
}

.eXtremeTable .toolbar {
	font-family: 'AvenirNext', verdana, arial, helvetica, sans-serif;
	font-size: 0.70rem;
	margin-right: 1px;
}

.eXtremeTable .toolbar td {
	color: #444444;
	padding: 0px 3px 0px 3px;
	text-align: center;
}

.eXtremeTable .separator {
	width: 7px;
}

.eXtremeTable .title {
	color: #444444;
	font-weight: bold;
	font-family: 'AvenirNext', 'Trebuchet MS', Verdana, Arial, Helvetica, sans-serif;
	font-size: 1rem;
	vertical-align: bottom;
}

.eXtremeTable .title span {
	margin-left: 0px;
}

.eXtremeTable .tableHeaderSort {
	border-top: 1px solid #E6DAC2;
	border-bottom: 1px solid #E6DAC2;
	border-right: none;
	border-left: none;
	color: #353535;
	font-weight: bold;
	font-family: 'AvenirNext', 'Trebuchet MS', Verdana, Arial, Helvetica, sans-serif;
	font-size: 0.70rem;
	background-color: #e0e2e5;
	text-decoration: underline;
}

.eXtremeTable .calcRow {
	background-color: #e0e2e5;
	border-top: solid 1px;
	border-color: #c6cad0;
}

.eXtremeTable .calcTitle {
	background-color: #e0e2e5;
	color: black;
	font-family: 'AvenirNext', verdana, arial, helvetica, sans-serif;
	font-weight: bold;
	font-size: 0.88rem;
	border-top: solid 1px;
	border-color: #c6cad0;
}

.eXtremeTable .calcResult {
	background-color: #e0e2e5;
	color: black;
	font-family: 'AvenirNext', verdana, arial, helvetica, sans-serif;
	border-top: solid 1px;
	border-color: #c6cad0;
	text-align: right;
}
</style>



<%-- ----------------------------------------------- --%>
<%-- Include non-PDF info only if not creating a PDF --%>
<%-- ----------------------------------------------- --%>
<c:if test="${empty param.ec_eti}">

	<script language="JavaScript" src='common/scripts/jquery.js'></script>
	<script language="JavaScript" src='common/scripts/i18n.js'></script>
	<script language="JavaScript" src="rules/scripts/dynamicRows.js"></script>
	<script language="JavaScript" src="rules/scripts/itemPriorityList.js"></script>
	<script language="JavaScript" src="rules/scripts/autoSizing.js"></script>
	<SCRIPT language="JavaScript" src="common/scripts/calendar.js"></SCRIPT>
	<SCRIPT language="JavaScript" src="rules/scripts/sort.js"></SCRIPT>
	<script language="JavaScript" src="rules/scripts/rules.js"></script>
	<script language="JavaScript" src="rules/scripts/segments.js"></script>
	<script language="JavaScript">
  //<!--

var definer = '${esapi:encodeForJavaScript(definer)}';
var activity = '${esapi:encodeForJavaScript(activity)}';
var segment = '${esapi:encodeForJavaScript(segment)}';
var workflow = definer + 'Segments';
var segmorgid = '${segmorgid}';
var depth = '${esapi:encodeForJavaScript(depth)}';

  <c:if test="${refreshOverview}">
  refreshVariableFolders();
  </c:if>

  function ignoreReturn(evt)
  {
     if(!evt) evt = window.event;
     if(evt.keyCode == 13) return false;
     return true;
  }

  var segmentUpNbrs = new Array();
  var segmentNames = new Array();

  <c:forEach var="segment" items="${segments}" >
  //-->
  </script>
	<pre id="segmentUpNbr${segment.segmentId}" style="display: none">${fn:escapeXml(segment.lstUpdtNbr)}</pre>
	<pre id="segmentName${segment.segmentId}" style="display: none">${fn:escapeXml(segment.segmentAcronym)}</pre>
	<script>
  //<!--
     segmentUpNbrs[${segment.segmentId}] = document.getElementById("segmentUpNbr${segment.segmentId}").innerHTML;
     segmentNames[${segment.segmentId}] = document.getElementById("segmentName${segment.segmentId}").innerHTML;
  </c:forEach>

  //-->
  </script>


	<div id="rulesTabScrollableDiv" class="rulesTabScrollableClass">

		<%-- Error handling code --%>
		<div onclick="this.innerHTML='<br>'">
			<c:url var="reloadURL"
				value="/listSegments.action?definer=${definer}&activity=${activity}&segment=${segment}&segmorgid=${segmorgid}&depth=${depth}" />
			<tiles:insertDefinition name="ruleSystemMessageLayout" flush="true">
				<tiles:putAttribute name="reloadURL" value="${reloadURL}" />
				<tiles:putAttribute name="refreshURL" value="${reloadURL}&refresh=true" />
				<tiles:putAttribute name="objectTypeName" value="Segment" />
			</tiles:insertDefinition>			
		</div>


		<%-- Title --%>
		<div align="left"
			style="font-size: 10pt; margin: 0px 0px 0px 0px; color: #353535; font-weight: bold; width: 100%;">
			<div style="float: left">
				<fmt:message key="rules.segments.list.title.txt" />
			</div>
			<div style="float: right; font-weight: normal; font-size: xx-small;">
			</div>
		</div>
		<br>

		<table class="mainTable" id="segmentsTable" width="100%" align="left"
			style="margin: 0px 0px 0px 0px; -moz-user-select: none;"
			onselectstart='return false;' border="0" cellspacing="0"
			cellpadding="0">
			<thead>
				<TR class="tableColumnHeaderRow">
					<TH class="centeredTableHeader" nowrap>&nbsp;<fmt:message
							key="variable.variablesDetailContent.tableHeader.segment.txt" />
					</TH>
					<TH class="centeredTableHeader" nowrap>&nbsp;<fmt:message
							key="variable.segmentsDetailContent.tableHeader.length.txt" />
					</TH>
					<TH class="centeredTableHeader" nowrap>&nbsp;<fmt:message
							key="variable.segmentsDetailContent.tableHeader.prefix.txt" />
					</TH>
					<TH class="centeredTableHeader" nowrap>&nbsp;<fmt:message
							key="variable.segmentsDetailContent.tableHeader.keys.txt" />
					</TH>
					<TH class="centeredTableHeader" nowrap>&nbsp;<fmt:message
							key="variable.segmentsDetailContent.tableHeader.label.txt" />
					</TH>
					<TH class="centeredTableHeader" nowrap>&nbsp;<fmt:message
							key="variable.segmentsDetailContent.tableHeader.created.txt" />
					</TH>
					<TH class="centeredTableHeader" nowrap>&nbsp;<fmt:message
							key="variable.segmentsDetailContent.tableHeader.updated.txt" />
					</TH>
				</TR>
			</thead>

			<TBODY id="ruleTableBody">

				<c:if test="${empty segments}">
					<TR rowspan="2">
						<TD align="right" style="font-size: 10pt;" colspan="100%"><center>
								<em><fmt:message
										key="variable.segmentsDetailContent.noSegmentsDefined.txt" />
							</center>
							</em></TD>
					</TR>
				</c:if>

				<c:if test="${not empty segments}">
					<c:forEach var="segment" items="${segments}" varStatus="status">

						<TR style="cursor: pointer;" id="${status.count}"
							class="dataRow${status.count%2+1}_tableRow"
							onClick='handleRowSelectionSegment(${segment.segmentId}, segmentUpNbrs[${segment.segmentId}], segmentNames[${segment.segmentId}], this, "rowSelected", event)'
							;
               ondblclick='viewSegment();'>

							<TD class="textTableCell">${fn:escapeXml(segment.segmentAcronym)}
							<TD class="numericTableCell">${segment.segmentLength}</TD>
							<TD class="textTableCell">${fn:toUpperCase(segment.segmentPrefixChar)}
							</TD>
							<TD class="textTableCell">${fn:escapeXml(segment.segmentKeyFieldNames)}
							</TD>
							<TD class="textTableCell">${fn:escapeXml(segment.segmentDesc)}
							</TD>
							<TD class="textTableCell"><span dateFormat="${dateFormat} ${timeFormat}" sortvalue="${segment.createTimestampUtcMillis}"><fmt:formatDate value='${segment.createTimestamp}' pattern='${dateTimeFormat}' timeZone='${userTimeZone}'/></span>
								<fmt:message key="variable.segmentDetailContent.byUser.fmt.txt">
									<fmt:param>${fn:escapeXml(segment.createUser)}</fmt:param>
								</fmt:message>
							</TD>
							<TD class="textTableCell"><span dateFormat="${dateFormat} ${timeFormat}" sortvalue="${segment.lstUpdtTimestampUtcMillis}"><fmt:formatDate value='${segment.lstUpdtTimestamp}' pattern='${dateTimeFormat}' timeZone='${userTimeZone}'/></span>
								<fmt:message key="variable.segmentDetailContent.byUser.fmt.txt">
									<fmt:param>${fn:escapeXml(segment.lstUpdtUser)}</fmt:param>
								</fmt:message>
							</TD>
						</TR>

					</c:forEach>
				</c:if>

			</TBODY>
		</table>
	</div>

</c:if>


<div id="rulesExportDiv" style="display: none;">
	<span id="ruleData" style="width: 100%"> <ec:table
			items="segments" var="segments" action=""
			title="Ignored Title" width="100%" sortable="false"
			filterable="false" showExports="true" showStatusBar="true"
			tableId="ruleData" styleClass="mainTable" rowsDisplayed="20"
			view="html2">
			<ec:exportPdf imageName="pdf" fileName="segments.pdf"
				tooltip="Export PDF" headerColor="#353535"
				headerBackgroundColor="#e0e2e5"
				headerTitle='<fmt:message key="rules.segments.list.title.txt"/>'
				view="pdfRulesList" />
			<ec:row>
				<c:set var="color" value="black" />
				<%-- ------------------------------------------------------- --%>
				<%-- Include rows if PDF requested and based on request type --%>
				<%-- ------------------------------------------------------- --%>
				<c:if test="${not empty param.ec_eti}">
					<ec:column property="segmentAcronym" title="Segment"
						headerClass="tableHeader"
						headerStyle="border-top:1px solid #c6cad0;border-right:none;color:#353535;font-weight:bold;"
						styleClass="textTableCell" />
					<ec:column property="segmentLength" title="Length"
						headerClass="tableHeader"
						headerStyle="border-top:1px solid #c6cad0;border-right:none;color:#353535;font-weight:bold;"
						styleClass="textTableCell" />
					<ec:column property="segmentAcronym" title="Prefix"
						headerClass="tableHeader"
						headerStyle="border-top:1px solid #c6cad0;border-right:none;color:#353535;font-weight:bold;"
						styleClass="textTableCell" />
					<ec:column property="segmentKeyFieldNames" title="Key"
						headerClass="tableHeader"
						headerStyle="border-top:1px solid #c6cad0;border-right:none;color:#353535;font-weight:bold;"
						styleClass="textTableCell" />
					<ec:column property="segmentDesc" title="Label"
						headerClass="tableHeader"
						headerStyle="border-top:1px solid #c6cad0;border-right:none;color:#353535;font-weight:bold;"
						styleClass="textTableCell" />
					<ec:column property="createUser" title="Create User"
						headerClass="tableHeader"
						headerStyle="border-top:1px solid #c6cad0;border-right:none;color:#353535;font-weight:bold;"
						styleClass="textTableCell" />
					<ec:column property="createTimestamp" title="Create Date"
						headerClass="tableHeader"
						headerStyle="border-top:1px solid #c6cad0;border-right:none;color:#353535;font-weight:bold;"
						styleClass="textTableCell" />
					<ec:column property="lstUpdtUser" title="Update User"
						headerClass="tableHeader"
						headerStyle="border-top:1px solid #c6cad0;border-right:none;color:#353535;font-weight:bold;"
						styleClass="textTableCell" />
					<ec:column property="lstUpdtTimestamp" title="Update Date"
						headerClass="tableHeader"
						headerStyle="border-top:1px solid #c6cad0;border-right:none;color:#353535;font-weight:bold;"
						styleClass="textTableCell" />
				</c:if>
			</ec:row>


		</ec:table> <br>
	<br>
	</span>
</div>



<script>
   attachEventHandlerToTableCells(['segmentsTable']);

</script>





