
// Delete the indicated variable
function deleteVariable(id, nbr, name, segment, moid)
{
   var segElement = document.getElementById("segmentAcronym");
   if (segment=='RUA' || (segment=='all' && segElement && segElement.innerHTML=='RUA'))
   {
     alert($i18n("variable.variables.js.cannotDeleteAttributeVariable.alert.fmt.txt", [name]));
     return;
   }
   if (!confirm($i18n("variable.variables.js.confirmVariableDeletion.confirm.fmt.txt", [name])))
       return;
   target = 'deleteVariables.action' +
                             '?idList=' + id +
                             '&nbrList=' + nbr +
                             '&nameList=' + encodeURIComponent(name) +
                             '&__sfmrt=' + getCookie("__sfmrt") +
                             '&definer=' + definer + '&activity=' + activity + '&segment=' + segment + '&segmorgid=' + segmorgid + '&depth=' + depth;
   parent.frames[ "detail" ].location.href = target;
}


// Delete variables selected from list
function deleteVariables()
{
   // Setup multiple selections
   setSelectedVariables();
   if (selectedVariableIds.length == 0)
   {
         alert($i18n("variable.variables.js.selectVariables.alert.txt"));
         return;
   }
   var segs=selectedVariableSegments.split(",");
   for (var i=0; i<segs.length; i++)
   {
     if (segs[i]=='RUA')
     {
       alert($i18n("variable.variables.js.cannotDeleteAuthVariable.alert.fmt.txt", [selectedVariableNames.split(",")[i]]));
       return;
     }
   }
   if (!confirm($i18n("variable.variables.js.confirmVariablesDeletion.confirm.txt")))
       return;

   target = 'deleteVariables.action' +
                             '?idList=' + selectedVariableIds +
                             '&nbrList=' + selectedVariableUpNbrs +
                             '&nameList=' + selectedVariableNames +
                             '&__sfmrt=' + getCookie("__sfmrt") +
                             '&definer=' + definer + '&activity=' + activity + '&segment=' + segment + '&segmorgid=' + segmorgid + '&depth=' + depth;
   // parent.frames[ "detail" ].location.href = target;
   $df.postURL("detail", target);
}


// Export variables selected from list
function exportVariables()
{
   // Setup multiple selections
   setSelectedVariables();
   if (selectedVariableIds.length == 0)
   {
         alert($i18n("variable.variables.js.selectVariables.alert.txt"));
         return;
   }
   var segs=selectedVariableSegments.split(",");
   for (var i=0; i<segs.length; i++)
   {
     if (segs[i]=='RUA')
     {
       alert($i18n("variable.variables.js.cannotExportAuthVariable.alert.fmt.txt", [selectedVariableNames.split(",")[i]]));
       return;
     }
   }
   target = 'exportVariables.action' +
                             '?idList=' + selectedVariableIds +
                             '&nbrList=' + selectedVariableUpNbrs +
                             '&nameList=' + encodeURIComponent(selectedVariableNames) +
                             '&definer=' + definer + '&activity=' + activity + '&segment=' + segment + '&segmorgid=' + segmorgid + '&depth=' + depth;
//   parent.frames[ "detail" ].location.href = target;
   $df.postURL("detail", target);
}



// Edit variable selected from list
function editVariable()
{
    setSelectedVariables();
    if (selectedVariableId == '')
    {
       alert($i18n("variable.variables.js.selectOneVariable.alert.txt"));
       return;
    }
   _editVariable(selectedVariableId, selectedVariableUpNbr, selectedVariableName);
}

// Edit the indicated variable
function _editVariable(selectedVariableId, selectedVariableUpNbr, selectedVariableName)
{
    if (selectedVariableId == '')
    {
       alert($i18n("variable.variables.js.selectOneVariable.alert.txt"));
       return;
    }
    target = 'editVariable.action' +
             '?variableId=' + selectedVariableId +
             '&variableUpNbr=' + selectedVariableUpNbr +
             '&variableName=' + encodeURIComponent(selectedVariableName) +
             '&definer=' + definer + '&activity=' + activity + '&segment=' + segment + '&segmorgid=' + segmorgid + '&depth=' + depth;
    setBusyDetail();
    parent.sas.fscf.getCurrentDetailToolbar().setContentFor("editVariable");
    parent.frames[ "detail" ].location.href = target;
}

// Create a new variable and display form for updating it
function createVariable()
{
  if (segment=="RUA")
  {
     alert($i18n("variable.variables.js.cannotCreateOrDeleteAuthVariables.alert.txt"));
     return;
  }
  if (workingBuId == wildBuId && segment!="I##") // S1010617
  {
     alert($i18n("variable.variables.js.selectBusinessUnit.alert.txt")); // S1010617
     return; // S1010617
  }
  target = 'addVariable.action' +
           '?definer=' + definer + '&activity=' + activity + '&segment=' + segment + '&segmorgid=' + segmorgid + '&depth=' + depth;
  setBusyDetail();
  parent.sas.fscf.getCurrentDetailToolbar().setContentFor("newVariable");
  parent.frames[ "detail" ].location.href = target;
}

// If true first parm, displays message and return first parm
function testAndComplain(test, complaint) {
   if (test)
      alert($i18n("variable.variables.js.cannotSaveVariable.alert.fmt.txt", [complaint]));
   return test;
}

// Persist the variable displayed
var variableNameRegularExpression = new RegExp("^\\w{1,30}$");
var variableInitialNumberRegularExpression = new RegExp("^[+-]?\\d{1,32}(\\.\\d*)?$");
var variableRepCountRegularExpression = new RegExp("^\\d{1,9}$");
function saveVariable()
{
  var businessName = document.getElementById("businessName").value.replace(/^\s*|\s*$/g,"");
  var desc = document.getElementById("variableDesc").value.replace(/^\s*|\s*$/g,""); // Trim whitespace
  var id = document.getElementById("variableId").value;
  var upnbr = document.getElementById("variableUpNbr").value;
  var fieldId = document.getElementById("fieldId").value;
  var fieldName = document.getElementById("fieldName").value;
  var repCount = document.getElementById("repCount").value;
  var segmentIdVersion = document.getElementById("segmentIdVersion").value;
  var segmentAcronym = document.getElementById("segmentAcronym").value;
  var segmentPrefixChar = document.getElementById("segmentPrefixChar").value;
  var value = document.getElementById("variableInitial").value.replace(/^\s*|\s*$/g,""); // Trim whitespace
  var segmentDesc = document.getElementById("segmentDesc").value;
  var lstUpdtTimestamp = document.getElementById("lstUpdtTimestamp").value;
  var createTimestamp = document.getElementById("createTimestamp").value;
  var lstUpdtUser = document.getElementById("lstUpdtUser").value;
  var createUser = document.getElementById("createUser").value;
  var testUseCount = document.getElementById("testUseCount").value;
  var prodUseCount = document.getElementById("prodUseCount").value;
  var segmentId = document.getElementById("segmentId").value;
  var startingPosition = document.getElementById("startingPosition").value;

  // RUA variables do not allow type changes
  var leng;
  var type;
  var typeSelector = document.getElementById("variableTypeSelector");
  if (!typeSelector)
  {
    leng = document.getElementById("fieldLength").value;
    type = document.getElementById("variableType").value;
  }
  else
  {
    var val = typeSelector.options[typeSelector.selectedIndex].value.split(' ');
    type = val[0];
    leng = val[1] ? val[1] : 8;
  }
  var maskingTypeSelector=document.getElementById("maskingTypeSelector");
  var maskingTypeValue="";
  if(!maskingTypeSelector){
	  var maskingType=document.getElementById("maskingType");
  	  if(maskingType){//no masking type for RUA
  		  maskingTypeValue=document.getElementById("maskingType").value;
  	  }
  }
  else{
	maskingTypeValue=maskingTypeSelector.options[maskingTypeSelector.selectedIndex].value.split(' ');
  }  
  
  // Assure repCount is reasonable and jives with name
  if (!variableRepCountRegularExpression.test(repCount)) {
      alert($i18n("variable.variables.js.replicationCountTooLarge.alert.fmt.txt", [repCount]));
      return;
  }
  
  if(repCount < 1){
	  alert($i18n("rules.ruleAction.ruleService.notPositiveInteger.fmt.txt",[repCount]));
	  return;
  }
  var dataPopValueSelector=document.getElementById("dataPopValueSelector");
  var dataPopValue="";
  if(!dataPopValueSelector){
	  var dataPop=document.getElementById("dataPopValue");
	  if(dataPop){
	   dataPopValue=document.getElementById("dataPopValue").value;
	  }
  }
  else{
	  dataPopValue=dataPopValueSelector.options[dataPopValueSelector.selectedIndex].value.split(' ');
  } 
  var parts = businessName.split("_");
  var startingRep = parts[parts.length-1];
  if (repCount != '1' && !variableRepCountRegularExpression.test(startingRep)) {
      alert($i18n("variable.variables.js.variableNameEndWithUnderscore.alert.txt"));
      return;
  }

  target = 'saveVariable.action' +
           '?variableId=' + id +
           '&variableUpNbr=' + upnbr +
           '&businessName=' + encodeURIComponent(businessName) +
           '&fieldName=' + fieldName +
           '&repCount=' + repCount +
           '&segmentIdVersion=' + segmentIdVersion +
           '&segmentAcronym=' + segmentAcronym +
           '&segmentPrefixChar=' + segmentPrefixChar +
           '&variableType=' + type +
           '&fieldLength=' + leng +
           '&fieldId=' + fieldId +
           '&variableInitial=' + encodeURIComponent(value) +
           '&variableDesc=' + encodeURIComponent(desc) +
           '&segmentDesc=' + encodeURIComponent(segmentDesc) +
           '&lstUpdtTimestamp=' + lstUpdtTimestamp +
           '&createTimestamp=' + createTimestamp +
           '&lstUpdtUser=' + encodeURIComponent(lstUpdtUser) +
           '&createUser=' + encodeURIComponent(createUser) +
           '&testUseCount=' + testUseCount +
           '&prodUseCount=' + prodUseCount +
           '&segmentId=' + segmentId +
           '&startingPosition=' + startingPosition +
           '&definer=' + definer +
           '&activity=' + activity +
           '&segment=' + segment +
           '&segmorgid=' + segmorgid +
           '&depth=' + depth +           
           '&maskingType=' + maskingTypeValue +
           '&dataPopValue=' + dataPopValue +
           '&__sfmrt=' + getCookie("__sfmrt")
           ;
  setBusyDetail();
  $df.postURL("detail", target); // S1077519
}



// Establish initial sort order (or retain the order already established)
function initVariablesSortOrder()
{
   if (!isDefined(parent._rulesSortOrder))
      parent._rulesSortOrder = new Array();
   if (!isDefined(parent._rulesSortOrder[workflow])) {
      if (definer=='V')
         setSortOrder("0", "desc"); // Default order for user vars is by descending update timestamp
      else
         setSortOrder("0", "asc");  // Default order for system vars is by ascending variable name
   }
}

// Sort variables upon initial display of list
function sortVariables(tableId)
{
   initVariablesSortOrder();

   colId = parent._rulesSortOrder[workflow].colId;
   order = parent._rulesSortOrder[workflow].order;
   //alert("Sorting by " + colId + ", " + order);

   var table = getElement(tableId);
   var headerRow = table.tHead.rows[0];
   var cellCount = headerRow.cells.length;
   var headerCell = headerRow.cells[colId];
   var dataType = headerCell.getAttribute("famSortType");

   sortTable(tableId, headerCell.cellIndex, dataType);

   if(order == "desc") // need to find a better way to do desc sorting
      sortTable(tableId, headerCell.cellIndex, dataType);
}


// Display list of variables based on the specified definer (user/system), activity (used/all), segment (3chars/all), segmorgid (tenantMO), and depth (full/lean)
function showVariables()
{
  selectedNodes = _variablesTree.getSelectedNodes();
  var selectedId;
  if (selectedNodes && selectedNodes[0])
     selectedId = selectedNodes[0].getId();
  else
      selectedId = 'V_all_all';

  setCookieForTab(selectedId, null, "_listVariables");

  // a request for all uservars is actually a request for a segment list
  var selParts = selectedId.split("_");
  if (selParts[2]=='RUA2') { // Circumvent bug in IE
      selParts[2] = 'RUA';
  }
  if (selParts.length<4) // no segmorgid for system or RUA segments
      selParts.push("");
  var target = 'listVariables.action';
  if(selParts[0]!='system'){
	  target += '?definer=' + selParts[0] + '&activity=' + selParts[1] + '&segment=' + selParts[2] + '&segmorgid=' + selParts[3] + '&depth=lean';
	  updateDetailToolbar(selParts[0], selParts[2], selParts[3]);
  }
  else{
	  target += '?definer=' + selParts[0] + '&activity=' + selParts[1] + '&segment=' + selParts[2] + '&segmorgid=&depth=lean&componentType='+selParts[3];  
	  updateDetailToolbar(selParts[0], selParts[2], '');
  }
  parent.frames[ "detail" ].location.href = target;
}


// Re-display the list of variables for a variables definer. activity, segment, segmorgid, and depth
function reshowVariables(newActivity)
{
  activity = (newActivity) ? newActivity : activity;
  var target = 'listVariables.action' + '?definer=' + definer + '&activity=' + activity + '&segment=' + segment + '&segmorgid=' + segmorgid + '&depth=' + depth + "&refreshOverview=true";
  updateDetailToolbar(definer, segment, segmorgid);
  parent.frames[ "detail" ].location.href = target;
}


// Toggle between showing and hiding unused variables as well as used ones
function showHideUnused()
{
  var target = 'listVariables.action' +
               '?definer=' + definer +
               '&activity=' + ((activity=='used') ? 'all' : 'used') +
               '&segmorgid=' + segmorgid +
               '&segment=' + segment +
               '&componentType='+ componentType +
               '&depth=' + depth;
  setBusyDetail();
  parent.sas.fscf.getCurrentDetailToolbar().toggleShowHide();
  parent.frames[ "detail" ].location.href = target;
}


// Toggle between showing and hiding additional details in variable list
function showHideDepth()
{
  var target = 'listVariables.action' +
               '?definer=' + definer +
               '&activity=' + activity +
               '&segment=' + segment +
               '&segmorgid=' + segmorgid +
               '&depth=' + ((depth=='full') ? 'lean' : 'full');
  setBusyDetail();
  parent.frames[ "detail" ].location.href = target;
}


// Toggle between showing and hiding additional details in rule list
function showHideDepthRules()
{
  var target = 'viewVariable.action' +
               '?variableId=' + variableId +
               '&variableUpNbr=' + variableUpNbr +
               '&definer=' + definer +
               '&activity=' + activity +
               '&segmorgid=' + segmorgid +
               '&segment=' + segment +
               '&depth=' + ((depth=='full') ? 'lean' : 'full');
  setBusyDetail();
  parent.frames[ "detail" ].location.href = target;
}



// for single select
var selectedVariableId = '';
var selectedVariableUpNbr = '';
var selectedVariableName = '';
var selectedVariableSegment = '';

// for multi select
var selectedVariableIds = '';
var selectedVariableUpNbrs = '';
var selectedVariableNames = '';
var selectedVariableSegments = '';

function handleRowSelectionVariable(id, upnbr, name, segment, row, className, event)
{
   var variable = new Object();
   variable.id = id;
   variable.upnbr = upnbr;
   variable.name = name;
   variable.segment = segment;
   highlightRow(row, className, event, variable);
}

function setSelectedVariable(id, upnbr, name, segment)
{
   selectedVariableId = id;
   selectedVariableUpNbr = upnbr;
   selectedVariableName = name;
   selectedVariableSegment = segment;
}

function setSelectedVariables()
{
     selectedVariableId = ''
     selectedVariableUpNbr = '';
     selectedVariableName = '';
     selectedVariableSegment = ''
     selectedVariableIds = ''
     selectedVariableUpNbrs = '';
     selectedVariableNames = '';
     selectedVariableSegments = ''

     // iterate through keys in hashmap
     for(var i in _highlightedRowMap)
     {
         var selection = _highlightedRowMap[i];
         if (selection != null && isDefined(selection))
         {
           var variable = selection.mappedObject;
           selectedVariableIds += variable.id + ",";
           selectedVariableUpNbrs += variable.upnbr + ",";
           selectedVariableNames += variable.name + ",";
           selectedVariableSegments += variable.segment + ",";
         }
     }

     // trim out the extra ',' for multi select
     if (selectedVariableIds.length > 0)
        selectedVariableIds = selectedVariableIds.substring(0, selectedVariableIds.length -1);
     if (selectedVariableUpNbrs.length > 0)
        selectedVariableUpNbrs = selectedVariableUpNbrs.substring(0, selectedVariableUpNbrs.length -1);
     if (selectedVariableNames.length > 0)
        selectedVariableNames = selectedVariableNames.substring(0, selectedVariableNames.length -1);
     if (selectedVariableSegments.length > 0)
        selectedVariableSegments = selectedVariableSegments.substring(0, selectedVariableSegments.length -1);

     // for single select
     var list = selectedVariableIds.split(',');
     if (list.length == 1)
     {
       selectedVariableId = list[0];
       selectedVariableUpNbr = selectedVariableUpNbrs.split(',')[0];
       selectedVariableName = selectedVariableNames.split(',')[0];
       selectedVariableSegment = selectedVariableSegments.split(',')[0];
     }
}




// Creates a printable form of variable definitions
function printVariables()
{
  // Setup multiple selections
  setSelectedVariables();
  if (selectedVariableIds.length == 0)
  {
    alert($i18n("variable.variables.js.selectVariables.alert.txt"));
    return;
  }
  var w = window.open("rules/printableVariables.jsp",
                      'PrintableVariables'+new Date().valueOf(),
                      'menubar=0,toolbar=0,resizable=1, scrollbars=1, status=1, width=800, height=600');
  w.focus();
}


// View variable selected from list
function viewVariable()
{
    // alert('definer=' + definer + '&activity=' + activity + '&segment=' + segment + '&segmorgid=' + segmorgid + '&depth=' + depth);
    setSelectedVariables();
    if (selectedVariableId == '')
    {
       alert($i18n("variable.variables.js.selectOneVariable.alert.txt"));
       return;
    }
   _viewVariable(selectedVariableId, selectedVariableUpNbr, selectedVariableName);
}

// View the indicated variable
function _viewVariable(selectedVariableId, selectedVariableUpNbr, selectedVariableName)
{
    if (selectedVariableId == '')
    {
        alert($i18n("variable.variables.js.selectOneVariable.alert.txt"));
       return;
    }
    target = 'viewVariable.action' +
             '?variableId=' + selectedVariableId +
             '&variableUpNbr=' + selectedVariableUpNbr +
             '&variableName=' + encodeURIComponent(selectedVariableName) +
             '&definer=' + definer + '&activity=' + activity + '&segment=' + segment + '&segmorgid=' + segmorgid + '&depth=' + depth;
    setBusyDetail();
	parent.sas.fscf.getCurrentDetailToolbar().setContentFor("viewVariable");
    parent.frames[ "detail" ].location.href = target;
}


// When something changes that affects the counts in the overview window, reload it
function refreshVariableFolders()
{
	   var refreshSelection = definer + '_' + activity + '_' + segment;
	   if (segmorgid && segmorgid.length > 0) {
		   refreshSelection += '_' + segmorgid;
	   }
	   var target = 'listVariableFolders.action' +
	         '?workflow=' + workflow + '&refreshSelection=' + refreshSelection +
	         '&definer=' + definer + '&activity=' + activity + '&segment=' + segment + '&segmorgid=' + segmorgid + '&depth=' + depth;
	   updateDetailToolbar(definer, segment, segmorgid);
	   parent.frames[ "overview" ].location.href = target;
}

function updateDetailToolbar(definer, segment, segmorgid) {
	
	  if (definer == 'system') {
		   parent.sas.fscf.getCurrentDetailToolbar().setContentFor("systemVariables");
	  } else if (definer == 'I' && segment!='all') {
	       parent.sas.fscf.getCurrentDetailToolbar().setContentFor("inputClientVariables", segment, false, false, segmorgid);
	  } else if (definer=='I' && segment == 'all') {
		   parent.sas.fscf.getCurrentDetailToolbar().setContentFor("allInputClientVariables", segment, false, false, segmorgid);
	  } else if (definer == 'O' && segment!='all') {
	       parent.sas.fscf.getCurrentDetailToolbar().setContentFor("outputClientVariables", segment, false, false, segmorgid);
	  } else if (definer=='O' && segment == 'all') {
		   parent.sas.fscf.getCurrentDetailToolbar().setContentFor("allOutputClientVariables", segment, false, false, segmorgid);
	 // } else if (definer == 'I') {
	   //    parent.sas.fscf.getCurrentDetailToolbar().setContentFor("clientSegments", segment, false, false, segmorgid);
	  }else if (segment == 'RUA') {
		   parent.sas.fscf.getCurrentDetailToolbar().setContentFor("RUAVariables");
	  } else if (segment == 'all') {
		   parent.sas.fscf.getCurrentDetailToolbar().setContentFor("allUserVariables", segment, false, false, segmorgid);
	  } else {
		   parent.sas.fscf.getCurrentDetailToolbar().setContentFor("userVariables", segment, false, false, segmorgid);
	  }
}