var sasSpinner = "common/images/spinner.gif";
//tree
function showDetail(frameName, methodName){
    var tree = transactionTree;
    var selectedNodes = tree.getSelectedNodes();
    if(selectedNodes.length == 1)
    {
        var selectedNode = selectedNodes[0];
		setBusy();
		setCookieForTab(selectedNode.getId(), null, "_listTransactionTypes");
		var action = selectedNode.parameters.join('&');
		// console.log("action=" + action, "\nmethodName="+methodName);
		action = action.replace('#methodName#',methodName);
		action = action + '&__sfmrt=' + getCookie("__sfmrt");
	    if(methodName.startsWith('delete'))$df.postURL(frameName, action);
	    else parent.frames[ "detail" ].location.href=action;
    }
}

//button actions for custom transactions
function doNewTransactionAction(){
	
   setBusy();
   var action = 'createTransactionType.action?__sfmrt=' + getCookie("__sfmrt");
   $df.postURL("overview", action);
}

function doSaveAction(){
   if(document.getElementById("desc").value.trim()==""){
	 alert( $i18n("rules.transactionDetailContent.js.doSaveAction.alert0.txt"));
	 return false;
   }
   setBusy();
   var $form = $("#transactionForm");
   
   if ($form.length){
       document.getElementById("componentIds").value = getComponentIdArray().join(" ");
	   $form.submit();
   } 
}

function doDeleteAction(){
	
	var tree = parent.frames['overview'].transactionTree;
	var selectedNodes = tree.getSelectedNodes();
	
	if(selectedNodes.length == 0 || selectedNodes[0].parentId == 0){
	 alert($i18n("rules.transactionDetailContent.js.doDeleteAction.alert0.txt"));
	 return;
	}
	if (selectedNodes.length == 1){
		if(confirm($i18n("rules.transactionDetailContent.js.doDeleteAction.confirm0.txt"))){
			parent.frames['overview'].showDetail('overview','deleteTransactionType.action');
			setCookieForTab("-2",null, "_listTransactionTypes");
		 }
		return;
	}
	alert($i18n("rules.transactionDetailContent.js.doDeleteAction.alert1.txt"));

}
//button actions for predefined transactions
function saveTransactionList(){
	$("input:checkbox").prop('disabled', false);
	setBusyDetail();
	document.predefinedForm.submit();
}
//show predefined transaction when selecting it from the table
function showTxnDef(method, destWorkflow, newWindow, selectedTxnId,stock){	
	 setSelectedTxns();
	 if (selectedTxnId == '')
	   {
	      alert($i18n("rules.transactionDetailContent.js.doDeleteAction.alert0.txt"));
	      return;
	}
	// escape # character
	   selectedTxnDesc = selectedTxnDesc.replace(/#/g, '%23').replace(/%/g, '%25');

	var link = method + "?stock=1&id=" + selectedTxnId;

	setBusyDetail();
 	parent.sas.fscf.getCurrentDetailToolbar().setContentFor("predefinedTransaction");
    link += '&__sfmrt=' + getCookie("__sfmrt");
	$df.postURL("detail", link);

}

function handleTxnSelection(id, desc, acronym,tableName, row, className, event)
{
    var txn = new Object();
    txn.id = id;
    txn.desc = desc;
    txn.acronym = acronym;
    txn.tableName = tableName;
    txn.position = getPositionOfTableRow(row);
    highlightRow(row, className, event, txn);
}

function setSelectedTxns()
{
    var selectedTxnIdList= new Array();
    var selectedTxnDescList= new Array();
    var selectedTxnAcronymList= new Array();
    var selectedTxnTableNameList= new Array();

    selectedTxnId = '';
    selectedTxnDesc = '';
    selectedTxnAcronym = '';
    selectedTxnTableName = '';

    // iterate through keys in hashmap
    for(var i in _highlightedRowMap)
    {
        var selection = _highlightedRowMap[i];
        if(selection != null && isDefined(selection))
        {
          var rule = selection.mappedObject;
          var p = rule.position;
          selectedTxnIdList[p] = rule.id;
          selectedTxnDescList[p] = rule.desc;
          selectedTxnAcronymList[p] = rule.acronym;
          selectedTxnTableNameList[p] = rule.tableName;
        }
    }

    // Assign values in their displayed order (trim multi, leading, and trailing commas)
    selectedTxnIds = selectedTxnIdList.join(",").replace(/^,*|,*$/g,"").replace(/,+/g,",");
    selectedTxnDescs = selectedTxnDescList.join(",").replace(/^,*|,*$/g,"").replace(/,+/g,",");
    selectedTxnAcronyms = selectedTxnAcronymList.join(",").replace(/^,*|,*$/g,"").replace(/,+/g,",");
    selectedTxnTableNames = selectedTxnTableNameList.join(",").replace(/^,*|,*$/g,"").replace(/,+/g,",");

    // Show single selection if only one selected
    if (selectedRuleIds.split(',').length == 1)
    {
      selectedTxnId = selectedTxnIds.split(',')[0];
      selectedTxnDesc = selectedTxnDescs.split(',')[0];
      selectedTxnAcronym = selectedTxnAcronyms.split(',')[0];
      selectedTxnTableName = selectedTxnTableNames.split(',')[0];
   }

}
function returnToList(){
	var action ="viewPredefinedTransactions.action?__sfmrt=" + getCookie("__sfmrt");
	$df.postURL("detail", action);
}
/*****************************************************************COMPONENT SELECTIONS***********************************************************/
//Turns component selections for this rule into an array of ids (includes implicit component ids)
function getComponentIdArray() {
var compIdsSet = new Array();
// Get the components from checkboxes
var inputTags = document.getElementsByTagName("INPUT");
for (var t=0; t<inputTags.length; t++) {
 var inputTag=inputTags[t];
 if (inputTag.id && inputTag.id.substr(0,10)=="component_" && inputTag.checked) {
   var assocIds = inputTag.value.split(":")[1].split(" ");
   for (var a=0; a<assocIds.length; a++)
     compIdsSet[assocIds[a]] = assocIds[a];
 }
}
var compIdsArray = new Array();
for (var c in compIdsSet)
 compIdsArray.push(c);
for (var s=0; s<SystemComponentIds.length; s++)
 compIdsArray.push(SystemComponentIds[s]);
compIdsArray.sort();
return compIdsArray;
}

//Set component selections and pre-set based on contents of componentIds list
function loadComponentSelections() {
// Set checkboxes for the indicated component IDs
var selectedCompIdsSet = getSet(document.getElementById("componentIds").value);
setComponentSelections(selectedCompIdsSet, true);

// See if any pre-set matches the selected components
var selectedCompIds = getSet(getComponentIdArray().join(" ")).toString();
var transactionId = document.getElementById("transactionId");

}
// Selects/unselects displayed components based on the set of componentIds passed in
function setComponentSelections(selectedCompIds, saveNotNecessary){

  if (!selectedCompIds)
	  selectedCompIds = TransactionComponentsMap[document.getElementById("transactionId").value];	
  if (selectedCompIds==undefined)
    selectedCompIds = new Array();
  for (var compTypeCode in compTypeCodes) {
    for (var c=0; c<compTypeCodes[compTypeCode].length; c++) {
      var compSubTypeCode = compTypeCodes[compTypeCode][c];
      var allTag = document.getElementById("Checkbox"+compTypeCode+compSubTypeCode+"All");
      if (allTag)
        allTag.checked = false;
      for (var i=1; ;i++) {
        var trId = compTypeCode+compSubTypeCode+(i++);
        var trTag = document.getElementById(trId);
        if (!trTag) break;
        var inputTags = trTag.getElementsByTagName("INPUT");
        var compId = inputTags[0].value.split(':')[0];
        inputTags[0].checked = selectedCompIds[compId];
        if (inputTags[1]) {
           compId = inputTags[1].value.split(':')[0];
           inputTags[1].checked = selectedCompIds[compId];
        }
      }
    }
    setCompList(compTypeCode);
  } 
}

//Changes components and sets the display list
function changeCompList(compTypeCode) {
  setCompList(compTypeCode);
}

//Sets the compact list of component values based on which ones are checked
function setCompList(compTypeCode) {
  compTypeCode = compTypeCode.split('_')[0]; // Strip any subType
  var compList = new Array();
  var inputTags = document.getElementsByTagName("INPUT");
  for (var i=0; i<inputTags.length; i++) {
    if (inputTags[i].id && inputTags[i].id.substr(0,10+compTypeCode.length)=="component_"+compTypeCode && inputTags[i].checked)
      compList.push(inputTags[i].value.split(":")[2]);
  }
  document.getElementById(compTypeCode+"Values").innerHTML = compList.length==0 ? "<I>"+NOT_RELEVANT_TEXT+"</i>" : compList.join(", ");
  setComponentExpansions();
  setComponentTitles();
}
// Re-create cntl-space expansions based on new component selections
function setComponentExpansions() {
	  clearExpansionCache();
	  loadFieldExpansions();
	  loadOverviewExpansions();
}

//Highlight onhover
function componentHover(tag) {
	if (tag.className.indexOf('Closed')>0)
	 tag.className = 'componentClosedHeadHover';
	else
	 tag.className = 'componentOpenHeadHover';
	//tag.style.textDecoration = 'underline';
}
//Remove highlight when not hovering
function componentUnhover(tag) {
	if (tag.className.indexOf('Closed')>0)
	 tag.className = 'componentClosedHead';
	else
	 tag.className = 'componentOpenHead';
	//tag.style.textDecoration = 'none';
}
//Changes display show/hide setting for component type details
function showHideComponent(compTypeCode,compSubTypeCode) {
  if (document.getElementById(compTypeCode + compSubTypeCode + "All").style.display=='none')
     setComponentDisplay(compTypeCode,"");
  else
     setComponentDisplay(compTypeCode,"none");
  componentUnhover(document.getElementById(compTypeCode + "ValueTD"));
}

// Sets display attibute for a component type
function setComponentDisplay(compTypeCode,disp) {
  // Show/hide component details
  var trs = document.getElementsByTagName("TR");
  for (var tr in trs) {
    if (trs[tr].id && trs[tr].id.substr(0,compTypeCode.length)==compTypeCode && trs[tr].id!=compTypeCode+"Head")
        trs[tr].style.display=disp;
  }

  // Flip expand/collapse button and header colors
  var imUp = document.getElementById(compTypeCode+"ImgUp");
  var imDn = document.getElementById(compTypeCode+"ImgDn");
  var vals = document.getElementById(compTypeCode+"Values");
  var valTD = document.getElementById(compTypeCode+"ValueTD");
  if (disp=='none') {
    imUp.style.display = 'none';
    imDn.style.display = '';
    //valTD.title = "Click to show or hide component choices";
    //vals.className = "componentValuesClosed";
    valTD.className = 'componentClosedHead';
  }
  else {
    imUp.style.display = '';
    imDn.style.display = 'none';
    //vals.className = "componentValuesOpen";
    valTD.className = 'componentOpenHead';
  }
}

//Checks or unchecks all values of a component type (or subType)
function toggleAll(tag,code) {
  var inputTags = document.getElementsByTagName("INPUT");
  for (var inputTag in inputTags) {
    if (inputTags[inputTag].id && inputTags[inputTag].id.substr(0,10+code.length)=='component_'+code)
        inputTags[inputTag].checked = tag.checked;
  }
  changeCompList(code);
}

// Checks or unchecks a component selection
function toggleCheckbox(id) {
  var tag = document.getElementById(id);
  tag.checked = !tag.checked;
}

//Sets titles for components
function setComponentTitles() {
  var tdTags = document.getElementsByTagName("TD");
  for (var i=0; i<tdTags.length; i++) {
    var tagId = tdTags[i].id;
    if (tagId.substr(0,12)=="componentTD:") {
      var compTip = new Array();
      var segments = ComponentSegmentsMap[tagId.split(":")[1]];
      if (segments) {
        for (var s=0; s<segments.length; s++) {
          compTip[s] = SegmentLabelMap[segments[s]];
        }
      }
      else
        compTip[0] = $i18n("rules.transactionDetailContent.js.noneApplicable.txt");
      var segments="\n"+$i18n("rules.transactionDetailContent.js.segments.txt")+":";
      compTip.unshift(segments);
      var fldList = tagId.split(":")[2].split(" ");
      for (var f=0; f<fldList.length; f++) {
        compTip.unshift(fldList[f] + "=" + tagId.split(":")[3]);
      }
      var keyFields=$i18n("rules.transactionDetailContent.js.keyFields.txt")+":";
      compTip.unshift(keyFields);
      tdTags[i].title = compTip.join("\n");
    }
  }
}

function saveTransactionActionsList(){
	$("input:checkbox").prop('disabled', false);
	setBusyDetail();
	document.actionsForm.submit();
}

