// Make a new segment
function newSegment()
{
  target = 'newSegment.action' +
           '?definer=' + definer + '&activity=' + activity + '&segment=' + segment + '&segmorgid=' + segmorgid + '&depth=' + depth;
  setBusyDetail();
  parent.sas.fscf.getCurrentDetailToolbar().setContentFor("newSegment");
  parent.frames[ "detail" ].location.href = target;
}


// Edit a segment selected from list
function editSegment()
{
    setSelectedSegments();
    if (selectedSegmentId == '')
    {
       alert($i18n("variable.segment.js.selectSegment.alert.txt"));
       return;
    }
    _editSegment(selectedSegmentId, selectedSegmentUpNbr, selectedSegmentName, selectedSegmentMoId);
}

// Edit the indicated segment
function _editSegment(selectedSegmentId, selectedSegmentUpNbr, selectedSegmentName, selectedSegmentMoId, method)
{
    if (selectedSegmentId == '' && selectedSegmentName == '')
    {
       alert($i18n("variable.segment.js.selectSegment.alert.txt"));
       return;
    }
    if (!method)
        method = 'editSegment';
    target = method + '.action' +
             '?segmentId='    + selectedSegmentId +
             '&segmentUpNbr=' + selectedSegmentUpNbr +
             '&segmentName='  + encodeURIComponent(selectedSegmentName) +
             '&segmentMoId=' + selectedSegmentMoId +
             '&definer=' + definer + '&activity=' + activity + '&segment=' + segment + '&segmorgid=' + segmorgid + '&depth=' + depth;
    setBusyDetail();
	parent.sas.fscf.getCurrentDetailToolbar().setContentFor(method);
    parent.frames[ "detail" ].location.href = target;
}


// View segment selected from list
function viewSegment()
{
    setSelectedSegments();
    if (selectedSegmentId == '')
    {
        alert($i18n("variable.segment.js.selectSegment.alert.txt"));
       return;
    }
    _viewSegment(selectedSegmentId, selectedSegmentUpNbr, selectedSegmentName, selectedSegmentMoId);
}

// View the indicated segment
function _viewSegment(selectedSegmentId, selectedSegmentUpNbr, selectedSegmentName, selectedSegmentMoId)
{
    _editSegment(selectedSegmentId, selectedSegmentUpNbr, selectedSegmentName, selectedSegmentMoId, 'viewSegment');
}

// for single select
var selectedSegmentId = '';
var selectedSegmentUpNbr = '';
var selectedSegmentName = '';
var selectedSegmentMoId = '';

// for multi select
var selectedSegmentIds = '';
var selectedSegmentUpNbrs = '';
var selectedSegmentNames = '';
var selectedSegmentMoIds = '';

function handleRowSelectionSegment(id, upnbr, name, moid, row, className, event)
{
   var segment = new Object();
   segment.id = id;
   segment.upnbr = upnbr;
   segment.name = name;
   segment.moid = moid;
   highlightRow(row, className, event, segment);
}

function setSelectedSegment(id, upnbr, name, moid)
{
   selectedSegmentId = id;
   selectedSegmentUpNbr = upnbr;
   selectedSegmentName = name;
   selectedSegmentMoId = moid;
}

function setSelectedSegments()
{
     selectedSegmentId = ''
     selectedSegmentUpNbr = '';
     selectedSegmentName = '';
     selectedSegmentMoId = '';
     selectedSegmentIds = ''
     selectedSegmentUpNbrs = '';
     selectedSegmentNames = '';
     selectedSegmentMoIds = '';

     // iterate through keys in hashmap
     for(var i in _highlightedRowMap)
     {
         var selection = _highlightedRowMap[i];
         if (selection != null && isDefined(selection))
         {
           var segment = selection.mappedObject;
           selectedSegmentIds += segment.id + ",";
           selectedSegmentUpNbrs += segment.upnbr + ",";
           selectedSegmentNames += segment.name + ",";
           selectedSegmentMoIds += segment.moid + ",";
         }
     }

     // trim out the extra ',' for multi select
     if (selectedSegmentIds.length > 0)
        selectedSegmentIds = selectedSegmentIds.substring(0, selectedSegmentIds.length -1);
     if (selectedSegmentUpNbrs.length > 0)
        selectedSegmentUpNbrs = selectedSegmentUpNbrs.substring(0, selectedSegmentUpNbrs.length -1);
     if (selectedSegmentNames.length > 0)
        selectedSegmentNames = selectedSegmentNames.substring(0, selectedSegmentNames.length -1);
     if (selectedSegmentMoIds.length > 0)
        selectedSegmentMoIds = selectedSegmentMoIds.substring(0, selectedSegmentMoIds.length -1);

     // for single select
     var list = selectedSegmentIds.split(',');
     if (list.length == 1)
     {
       selectedSegmentId = list[0];
       selectedSegmentUpNbr = selectedSegmentUpNbrs.split(',')[0];
       selectedSegmentName = selectedSegmentNames.split(',')[0];
       selectedSegmentMoId = selectedSegmentMoIds.split(',')[0];
     }
}


// Re-display the list of user segments
function reshowSegments()
{
  var target = 'listSegments.action' +
           '?definer=' + definer + '&activity=' + activity + '&segment=' + segment + '&segmorgid=' + segmorgid + '&depth=' + depth;
  parent.frames[ "detail" ].location.href = target;
}





// When something changes that affects the counts in the overview window, reload it
function refreshVariableFolders()
{
   var refreshSelection = definer + '_' + activity + '_' + segment;
   if (segmorgid && segmorgid.length > 0) {
	   refreshSelection += '_' + segmorgid;
   }
   var target = 'listVariableFolders.action' +
         '?workflow=' + workflow + '&refreshSelection=' + refreshSelection +
         '&definer=' + definer + '&activity=' + activity + '&segment=' + segment + '&segmorgid=' + segmorgid + '&depth=' + depth;
   updateDetailToolbar(definer, segment, segmorgid);
   parent.frames[ "overview" ].location.href = target;
}


// Fills in displayable keyField names and fieldIds from keyItems array
function regenKeyFieldsFromKeyItems() {
    var fieldNames = new Array();
    fieldNames[0] = '<tr><td><i>'+ $i18n("variable.segmentUpdateContent.none.txt") + '</i></td></tr>';
    var keyLength = 0;
    for (var kk=0; kk<keyItems.length; kk++) {
        fieldNames[kk] = getDisplayKey(kk, keyItems[kk].fieldName + "&nbsp;&nbsp; (" + keyItems[kk].fieldLength + " " + $i18n("variable.segmentUpdateContent.bytes.txt") + ")");
        keyLength += keyItems[kk].fieldLength;
    }
    document.getElementById("keyNames").innerHTML = "<table class='keyTable'>" + fieldNames.join("\n") + '</table>';
    document.getElementById("keyLength").innerHTML = keyLength;
}

// Returns -1, 0, or +1 for sorting key fields by field name
function keyItemComparator(keyItem1, keyItem2) {
    if (keyItem1.fieldName > keyItem2.fieldName)
       return  1;
    if (keyItem1.fieldName < keyItem2.fieldName)
       return -1;
    return 0;
}

// Add a key to the list of keys for a segment
function addKey() {
    var selector = document.getElementById('keyId');
    var totalLength = 0;
    var kk=0;
    for (; kk<keyItems.length; kk++) {
        if (keyItems[kk].fieldId==selector.value)
            break;
        totalLength += keyItems[kk].fieldLength;
    }
    if (kk == keyItems.length) {
        var text = selector.options[selector.selectedIndex].text;
        var fieldName = text.split(":")[0];
        var fieldLength = parseInt(text.split('Character')[1]);
        if (totalLength + fieldLength > 100)
            alert($i18n("variable.segment.js.exceededLengthLimit.alert.fmt.txt", [fieldLength, fieldName, (totalLength+fieldLength)]));
        else {
            keyItems.push(getKeyItem(fieldName, fieldLength, selector.value));
            keyItems.sort(keyItemComparator);
            regenKeyFieldsFromKeyItems();
        }
    }
    selector.selectedIndex = 0;
    selector.blur();
}

// Removes the indicated key from the list
function removeKey(idx) {
    keyItems.splice(idx,1);
    regenKeyFieldsFromKeyItems();
}

// Returns the innerHTML for a segment key name
function getDisplayKey(idx, txt) {
    txt = txt.split(":")[0];
    var disp = '<tr><td>' +
               '<div style="float:right"><img src="images/rules/delete.gif" onclick="removeKey(' + idx + ')" style="cursor:pointer;" title="' + $i18n("variable.segmentUpdateContent.keys.removeKey.title.txt") + '"/></div>' +
               '<div style="float:left">' + txt + '</div>' +
               '</td></tr>';
    return disp;
}

