// for single select
var selectedLookupListId = '';
var selectedLookupListUpNbr = '';
var selectedLookupListName = '';
var selectedLookupListFile = '';
// for multi select
var selectedLookupListIds = '';
var selectedLookupListUpNbrs = '';
var selectedLookupListNames = '';
var selectedLookupListFiles = '';

//refresh LookupListContents
function refreshContents()
{
   parent.frames[ "overview" ].location.href = 'uploadExistingLookupListContentsFile.action?refresh=true';
}

// Display list of lookup lists based on overview selection (all/age/ose)
function showLookupLists(contentOrList)
{
  if (!contentOrList) {
     var selectedNodes = _lookupListsTree.getSelectedNodes();
     var nodeId = selectedNodes[0].getId();
	  contentOrList = nodeId;
     setCookieForTab(nodeId, null, "_listLookupLists");
  }

  if (contentOrList == "content") {
	   parent.sas.fscf.getCurrentDetailToolbar().setContentFor("contentFiles");
  } else {
	   parent.sas.fscf.getCurrentDetailToolbar().setContentFor("lookupLists");
  }

  var target = "listLookupLists.action?contentOrList=" + contentOrList;
  parent.frames[ "detail" ].location.href = target;
}

// View lookup list selected from list
function viewLookupList()
{
    setSelectedLookupLists();
    if (selectedLookupListId == '')
    {
       alert($i18n("rules.lookupLists.js.selectOneToProcess.alert.txt"));
       return;
    }
   _viewLookupList(selectedLookupListId, selectedLookupListUpNbr, selectedLookupListName, selectedLookupListFile);
}
function _viewLookupList(selectedLookupListId, selectedLookupListUpNbr, selectedLookupListName, selectedLookupListFile)
{
    if (selectedLookupListId == '')
    {
        alert($i18n("rules.lookupLists.js.selectOneToProcess.alert.txt"));
       return;
    }
    if (isLookupListFromForeignBusinessUnit(selectedLookupListId, selectedLookupListName, "viewed"))
      return;
    var target = 'viewLookupList.action' +
                 '?lookupListId=' + selectedLookupListId +
                 '&lookupListName=' + selectedLookupListName +
                 '&lookupListInds=' + selectedLookupListFile +
                 '&contentOrList=' + contentOrList;
    setBusyDetail();
    if (contentOrList == "content") {
        parent.sas.fscf.getCurrentDetailToolbar().setContentFor("viewContentFile");
    } else {
        parent.sas.fscf.getCurrentDetailToolbar().setContentFor("viewLookupList", selectedLookupListId);
    }
    parent.frames[ "detail" ].location.href = target;
}

//Display screen to create a new lookup list
function newLookupList()
{
  var target = 'newLookupList.action?contentOrList=' + contentOrList +
                                  '&listType=RULEONLY';
  setBusyDetail();
  parent.sas.fscf.getCurrentDetailToolbar().setContentFor("newLookupList");
  parent.frames[ "detail" ].location.href = target;
}

function newAnalystLookupList()
{
   var target = 'newLookupList.action?contentOrList=' + contentOrList +
      '&listType=ANALYST';
   setBusyDetail();
   parent.sas.fscf.getCurrentDetailToolbar().setContentFor("newAnalystList");
   parent.frames[ "detail" ].location.href = target;
}

// Display screen to register a lookup list
function activateLookupLists()
{
   // Setup multiple selections
   setSelectedLookupLists();
   if (selectedLookupListId == '')
	{
	     alert($i18n("rules.lookupLists.js.selectOneToProcess.alert.txt"));
	     return;
	}

   var target = 'activateLookupList.action?inds=' +
                          '&idList=' + selectedLookupListIds +
                          '&nbrList=' + selectedLookupListUpNbrs +
                          '&nameList=' + selectedLookupListNames +
                          '&indsList=' + selectedLookupListFiles;
                      ;
   setBusyDetail();
   
   //internet explorer doesn't support the endswith function
   //https://developer.mozilla.org/en/docs/Web/JavaScript/Reference/Global_Objects/String/endsWith
   if (!String.prototype.endsWith) {
	   if (!String.prototype.endsWith) {
		   String.prototype.endsWith = function(search, this_len) {
		     if (this_len === undefined || this_len > this.length) {
		       this_len = this.length;
		     }
		     return this.substring(this_len - search.length, this_len) === search;
		   };
	   }
   }
   
   //RAPTOR-4923 - if we have a RULEONLY list selected, the next page will be the createLookupList page, so the toolbar needs to be different
   for( var i in _highlightedRowMap ) {
	   if ( i.endsWith( "ruleList" ) ) {
		   parent.sas.fscf.getCurrentDetailToolbar().setContentFor("newLookupList");
	   } else {
		   parent.sas.fscf.getCurrentDetailToolbar().setContentFor("newLookupListFromContent");
	   }
   }
   
   parent.frames[ "detail" ].location.href = target;
}

// Cancel out of an upload request for a new file
function cancelNewFileUploadRequest()
{
  document.getElementById("inds").style.display = "";
  document.getElementById("uploadForm").style.display = "none";
  return;
}

function showLookupListContents( name, inds, columns, listType, firstRow, viewFrame ) {
	showLookupListContents( name, inds, columns, listType, firstRow, viewFrame, 0 ); //listId only used on create
}

// Display contents of a lookup list (first page only - next pages come from form in lookupListContents.jsp)
function showLookupListContents( name, inds, columns, listType, firstRow, viewFrame, listId )
{
  var selector = document.getElementById("inds");

  // Question mark means user selected "Upload new lookup list contents"
  if (inds=='?')
  {
     var target = lookupListUploadAction+'?method=uploadNewLookupListContentsFile.action'+
                                         '&target=lookupListContentsFrame' +
     					                 '&contentOrList=' + encodeURIComponent(contentOrList) +
     					                 '&listType=' + encodeURIComponent(listType) +
     					                 '&inds=' + "" +
     					                 '&listId=' + encodeURIComponent(listId) +
     					                 '&__sfmrt=' + getCookie("__sfmrt");
         if(!window.showModalDialog){
            var width = 420;
            var height = 200;
            popUpWindowFinished();
            popUpWindowOpened(target, width, height); 
         }    
         else {
            var returnValue = window.showModalDialog(target, window, "dialogHeight:200px;dialogWidth:420px;resizable:1;scroll:0;status:0;help:0;");
         }
	 if (returnValue)
     {
        var slen = selector.options.length;
        for (var i=0; i<slen; i++)
        {
           if (selector.options[i].value==returnValue)
           {
              selector.selectedIndex = 0;
              return;
           }
        }
        selector.selectedIndex = 0;
     }
     else {
        selector.selectedIndex = 0;
     }
  }
  // Non-question mark non-blank means user selected a contents file
  else if (inds != '')
  {
     var msg = getIndsBadFileNameMessage(inds);
     if (msg)
     {
        alert(msg);
        if (selector)
            selector.selectedIndex = 0;
        frames[ viewFrame ].location.href = "rules/beige.htm";
     }
     else
     {
        // RAPTOR-1787, RAPTOR-2430
        const url = "showLookupListContents.action";
        if (columns.length === 0) {
            const queryParams = "?name=" + encodeURIComponent(name) +
	            "&inds=" + encodeURIComponent(inds) +
	            "&listType=" + encodeURIComponent(listType) +
	            "&columns=" + encodeURIComponent(columns) +
	            "&firstRow=" + firstRow;
            frames[ viewFrame ].location.href = url + queryParams;
        } else {
             // RAPTOR-5064 No need to send in Columns. Caused Performance overhead and column  detail is returned anyway
             if (listType != "ANALYST") {
                  columns="";
            }        
        	const formData = {
        			"name": name,
        			"inds": inds,
        			"listType": listType,
        			"columns": columns,   
        			"firstRow": firstRow
        	};
            $.post(url, formData, function( lookupListData ) {
				var iframe = frames[viewFrame];
				if (iframe && iframe.document) {
					switch(iframe.document.readyState) {
						case 'loading':
							iframe.document.addEventListener('DOMContentLoaded', function() {
								iframe.document.documentElement.insertAdjacentHTML('afterbegin', lookupListData);
							});
							break;
						case 'interactive':
							iframe.document.documentElement.insertAdjacentHTML('afterbegin', lookupListData);
							break;
						case 'complete':
							if(!iframe.document.documentElement) {
								iframe.document.appendChild(iframe.document.createElement("html"));
								iframe.document.documentElement.insertAdjacentHTML = ('afterbegin', "<head></head>\n<body style=\"background-color:#e0e2e5;\">\n\n\n\n</body>");
							}
							iframe.document.documentElement.insertAdjacentHTML('afterbegin', lookupListData);
							break;
						default :
							break;
					}
				}
            });
        }
     }
  }
}

function updateFileSelectDropdown() {
	var selector = window.parent.document.getElementById("inds");

	var target = lookupListRest + "lookupListContentsFiles";
	
	$.get(target, "", function( response ) {
		
		var fileList = response.items;
		var slen = selector.options.length;
		var flen = fileList.length;
		
        for (var i=2; i<slen; i++) {
        	
            var found = false;
            
            for (var j=0; j<flen; j++) {
        	   if( selector.options[i].value == fileList[j] ) {
        		   found = true;
        		   fileList.splice( j, 1 );
        		   break;
        	   }
            }
            
            if (!found && selector.selectedIndex != i) {
            	selector.options.remove( i );
            }
        }
        
    } );
}

// Download content file
function downloadContentFile()
{
   if (isLookupListFromForeignBusinessUnit(lookupListId, lookupListName, "downloaded"))
      return;

   fileType = "";
   var target = "downloadLookupListContents.action?contentOrList=" + contentOrList + "&fileType=" + fileType + "&inds=" + encodeURIComponent(lookupListInds);
   var width = 500;
   var height = 190;
   var url = lookupListFileTypeAction + "?method=downloadLookupListContents.action"
   	  + "&contentOrList=" + contentOrList 
      + "&fileType=" + fileType
      + "&inds=" + encodeURIComponent(lookupListInds) 
      + "&downloadFrame="+  target;
   if (lookupListInds.indexOf(".sor") != -1) {
      popUpWindowFinished();
      popUpWindowOpened(url, width, height);

	   if (!fileType)
		   return;
   }

   frames[ "downloadFrame" ].location.href = target;
}

// Upload content file
function uploadContentFile()
{
   if (isLookupListFromForeignBusinessUnit(lookupListId, lookupListName, "uploaded"))
      return;
      var url=lookupListUploadAction+'?method=uploadExistingLookupListContentsFile.action' +
                     '&contentOrList=' + contentOrList +
                     '&target=detail' +
                     '&lookupListId='+ lookupListId +
                     '&inds=' + lookupListInds +
                     '&__sfmrt=' + getCookie("__sfmrt");
          if(!window.showModalDialog){
            var width = 420;
            var height = 200;
            popUpWindowFinished();
            popUpWindowOpened(url, width, height); 
          }    
          else {
            var returnValue = window.showModalDialog(url,window, "dialogHeight:200px;dialogWidth:420px;resizable:1;scroll:0;status:0;help:0;");
    }
   if (returnValue)    // S1156319
      setBusyDetail(); // S1070343
}


// Display the list of lookup lists
function reshowLookupLists(newContentOrList)
{
  contentOrList = (newContentOrList) ? newContentOrList : contentOrList;
  var target = "listLookupLists.action?contentOrList=" + contentOrList;
  if (contentOrList == "content") {
	   parent.sas.fscf.getCurrentDetailToolbar().setContentFor("contentFiles");
 } else {
	   parent.sas.fscf.getCurrentDetailToolbar().setContentFor("lookupLists");
 }
  
  //update the active / inactive tabs over on the left
  setCookieForTab(newContentOrList, null, "_listLookupLists");
  parent.frames[ "overview" ].location.href = "listLookupListFolders.action";
  
  parent.frames[ "detail" ].location.href = target;
}

// Edit the lookup list selected from list
function editLookupList()
{
    setSelectedLookupLists();
    if (selectedLookupListId == '')
    {
       alert($i18n("rules.lookupLists.js.selectOneToProcess.alert.txt"));
       return;
    }
   _editLookupList(selectedLookupListId);
}

// Update the indicated lookup list
function _editLookupList(selectedLookupListId)
{
    if (selectedLookupListId == '')
    {
        alert($i18n("rules.lookupLists.js.selectOneToProcess.alert.txt"));
       return;
    }
    if (selectedLookupListId < 0)
    {
        alert($i18n("rules.lookupLists.js.cannotBeEdited.alert.txt"));
        return;
    }
    if (isLookupListFromForeignBusinessUnit(selectedLookupListId, selectedLookupListName, "edited"))
      return;
    target = 'viewLookupList.action' +
             '?update=1' +
             '&contentOrList=' + contentOrList +
             '&lookupListId=' + selectedLookupListId;
    setBusyDetail();
    parent.sas.fscf.getCurrentDetailToolbar().setContentFor("editLookupList", selectedLookupListId);
    parent.frames[ "detail" ].location.href = target;
}

function handleRowSelectionLookupList(id, upnbr, name, inds, row, className, event)
{
   var lookupList = new Object();
   lookupList.id = id;
   lookupList.upnbr = upnbr;
   lookupList.name = name;
   lookupList.inds = inds;
   highlightRow(row, className, event, lookupList);
}

var selectedRule;
function handleRowSelectionRule(id, upnbr, state, row, className, event)
{
   var rule = new Object();
   rule.id = id;
   rule.upnbr = upnbr;
   rule.state = state;
   selectedRule = rule;
   var trs = document.getElementById("ruleTableBody").getElementsByTagName("TR");
   for (var i=0; i<trs.length;i++)
   {
      var tds = trs[i].getElementsByTagName("TD");
      for (var j=0; j<tds.length;j++)
      {
         if (i % 2 == 0)
            tds[j].style.backgroundColor = 'white';
         else
            tds[j].style.backgroundColor = '#e0e2e5';
      }
   }
   var tds = row.getElementsByTagName("TD");
   for (var i=0; i<tds.length;i++)
   {
      tds[i].style.backgroundColor = '#ddddee';
   }
}

function _setSelectedLookupList(id, upnbr, name, inds)
{
   selectedLookupListId = id;
   selectedLookupListUpNbr = upnbr;
   selectedLookupListName = encodeURIComponent(name);
   selectedLookupListFile = encodeURIComponent(inds);
}

function setSelectedLookupLists()
{
     selectedLookupListId = ''
     selectedLookupListUpNbr = '';
     selectedLookupListName = '';
     selectedLookupListFile = '';
     selectedLookupListIds = ''
     selectedLookupListUpNbrs = '';
     selectedLookupListNames = '';
     selectedLookupListFiles = '';

     // iterate through keys in hashmap
     for(var i in _highlightedRowMap)
     {
         var selection = _highlightedRowMap[i];
         if (selection != null && isDefined(selection))
         {
           var lookupList = selection.mappedObject;
           selectedLookupListIds += lookupList.id + ",";
           selectedLookupListUpNbrs += lookupList.upnbr + ",";
           selectedLookupListNames += (lookupList.id>0 ? encodeURIComponent(lookupList.name.replace(/^\s*|\s*$/g,"")) : "") + ",";
           selectedLookupListFiles += encodeURIComponent(lookupList.inds.replace(/^\s*|\s*$/g,"")) + ",";
         }
     }

     // trim out the extra ',' for multi select
     if (selectedLookupListIds.length > 0)
        selectedLookupListIds = selectedLookupListIds.substring(0, selectedLookupListIds.length -1);
     if (selectedLookupListUpNbrs.length > 0)
        selectedLookupListUpNbrs = selectedLookupListUpNbrs.substring(0, selectedLookupListUpNbrs.length -1);
     if (selectedLookupListNames.length > 0)
        selectedLookupListNames = selectedLookupListNames.substring(0, selectedLookupListNames.length -1);
     if (selectedLookupListFiles.length > 0)
        selectedLookupListFiles = selectedLookupListFiles.substring(0, selectedLookupListFiles.length -1);

     // for single select
     var list = selectedLookupListIds.split(',');
     if (list.length == 1)
     {
       selectedLookupListId = selectedLookupListIds;
       selectedLookupListUpNbr = selectedLookupListUpNbrs;
       selectedLookupListName = selectedLookupListNames;
       selectedLookupListFile = selectedLookupListFiles;
     }
}


// Returns a message if file name is not valid for a content file
function getIndsBadFileNameMessage(inds)
{
  // These patterns also appear in RulesServiceImpl.java
  if (!inds || inds.replace(/^\s*|\s*$/g,"")=='')
     return $i18n("rules.lookupLists.js.missingFileName.alert.txt");
//  if (!inds.match("^[\\.a-zA-Z0-9_\\- ]{1,60}\\.csv$") && !inds.match("^[a-zA-Z_]\\w{0,31}\\.sas7bdat$"))
//     return "File name \"" + inds + "\" is not a valid .csv or .sas7bdat file name.\n\n" +
//            "Lookup list content file names must be either a valid SAS dataset name ending with .sas7bdat or\n" +
//            "a .csv file of 1-64 letters, numbers, underscores, hyphens, blanks, or dots.";
}


// Displays rule details in a form suitable for printing
function showPrintableRule(id,upnbr,state)
{
   if (!id)
   {
      if (!selectedRule)
      {
          alert($i18n("rules.lookupLists.js.selectOneToProcess.alert.txt"));
         return;
      }
      id = selectedRule.id;
      upnbr = selectedRule.upnbr;
      state = selectedRule.state;
   }
   var link = "printRules.action?idList=" + id + "&lockVersionList=" + upnbr + "&workflow=" + state + "&destWorkflow=" + state + "&userId=";
   var w = window.open(link,'PrintableRule'+new Date().valueOf(),'menubar=0,toolbar=0,resizable=1, scrollbars=1, status=1, width=700, height=550');
   w.focus();
}
