<%@ page language="java" session="true" %>
<%/*--------------------------------------------------------------------------------------|
|Copyright (c) 2007, SAS Institute, Inc.  All Rights Reserved.
|
|NAME: rules/rulesPrintableVersion.jsp
|DESCRIPTION: JSP page to print one or more rule definitions from a rule list (it fills in
|             in the standard rule-printing template supplied by the Action class)
|---------------------------------------------------------------------------------------*/%>

<%@ include file="/common/taglibsT3.jsp" %>
<%@ page contentType="text/html; charset=UTF-8" %>

<style type=text/css>@import "common/styles/calendar.css";</style>

<script language="JavaScript" src="rules/scripts/rules.js"></script>
<script language='JavaScript' src='rules/scripts/ruleSasTest.js'></script>
<script language='JavaScript' src='rules/scripts/findReplace.js'></script>
<script language='JavaScript' src='rules/scripts/expander.js'></script>
<script language='JavaScript' src="common/scripts/calendar.js"></script>
<%-- script language="JavaScript" src="rules/scripts/mylistboxAssignments.js"></script --%>

<HTML>

<HEAD>
  <title>
   <c:choose>
	<c:when test="${empty productName}">
		SAS&reg; Fraud Management -
	</c:when>
	<c:otherwise>
		${fn:replace(fn:replace(productName, "<sup>", ""), "</sup>", "")} -
	</c:otherwise>
   </c:choose>
   <fmt:message key="rules.rulesPrintableVersion.rules.txt" />
  </title>
  <STYLE>
  TD {font-family: helvetica,ariel,sans-serif;
      vertical-align: top;
      color: black;
      font-size: x-small;
     }
  .toc { border:1px solid #dddddd;
       }
  </STYLE>
</HEAD>



<BODY marginheight="0" marginwidth="0">



<%-- Set rule values that will be used in the included rule-print-layout file --%>
<c:set var="NONE"><span class='softNone'><fmt:message key="rules.rulesPrintableVersion.noneValue.txt" /></span></c:set>


<h2><c:choose>
	<c:when test="${empty productName}">
		SAS&reg; Fraud Management
	</c:when>
	<c:otherwise>
		${productName}
	</c:otherwise>
</c:choose> <fmt:message key="rules.rulesPrintableVersion.rules.txt" /><br>
<span style="font-size:small;font-weight:normal;"><fmt:formatDate value="<%=new java.util.Date()%>" pattern="${dateTimeFormat}" timeZone="${userTimeZone}"/></span>
</h2>

 <%-- Error handling code --%>
 <div onclick="this.innerHTML='<br>'">
   	<c:url var="reloadURL" value="printRules.action?idList=${selectedRuleIds}&lockVersionList=${selectedRuleLockVersions}&destWorkflow=${destWorkflow}&showAll=${showAll}"/>   	
	<tiles:insertDefinition name="ruleSystemMessageLayout" flush="true">
		<tiles:putAttribute name="reloadURL" value="${reloadURL}" />
		<tiles:putAttribute name="refreshURL" value="${reloadURL}&refresh=true" />
		<tiles:putAttribute name="objectTypeName" value="Rule" />
	</tiles:insertDefinition>
 </div>
 
<table width="100%" border="1" cellspacing="0" cellpadding="4" class="toc">
  <tr>  <th class="toc" nowrap align=left><fmt:message key="rules.rulesPrintableVersion.rule.txt" />
        <th class="toc" nowrap align=left><fmt:message key="rules.rulesPrintableVersion.ruleType.txt" />
        <th class="toc" nowrap align=left><fmt:message key="rules.rulesPrintableVersion.ruleName.txt" />
        <th class="toc" nowrap align=left width="95%"><fmt:message key="rules.rulesPrintableVersion.description.txt" />
  </tr>
  <c:forEach var="r" items="${rules}">
    <tr><td class="toc" nowrap><fmt:message key="rules.rulesPrintableVersion.rule.txt" /> ${r.baseRuleId}.${r.version}
        <td class="toc" nowrap><c:if test="${empty r.ruleType}">${NONE}</c:if><fmt:message key="rules.ruleType.${r.ruleType}.txt"/>
        <td class="toc" nowrap><c:if test="${empty r.name}">${NONE}</c:if>${fn:escapeXml(r.name)}  <%-- S0881932 --%>
        <td class="toc"><c:if test="${empty r.description || fn:trim(r.description)==''}">${NONE}</c:if>${fn:escapeXml(r.description)}  <%-- S0881932 --%>
    </tr>
  </c:forEach>
</table>
<br/>

<c:forEach var="r" items="${rules}">

   <div style="page-break-after:always;">&nbsp;</div>
   <hr>

   <c:set var="title">
     <c:choose>
        <c:when test="${empty r.baseRuleId && empty r.version && empty r.name}">${NONE}</c:when>
        <c:otherwise><fmt:message key="rules.rulesPrintableVersion.rule.txt" /> ${r.baseRuleId}.${r.version}: ${esapi:encodeForHTML(r.name)}</c:otherwise>  <%-- S0881932 --%>
     </c:choose>
   </c:set>
   <c:set var="name">
     <c:choose>
        <c:when test="${empty r.name}">${NONE}</c:when>
        <c:otherwise>${esapi:encodeForHTML(r.name)}</c:otherwise>
     </c:choose>
   </c:set>
   <c:set var="baseRuleIdInfo">
     <c:choose>
        <c:when test="${empty r.baseRuleId && empty r.version && empty r.workflowState}">${NONE}</c:when>
        <c:otherwise>${r.baseRuleId}.${r.version} (<fmt:message key="rules.ruleState.${r.workflowState}.txt"/>)</c:otherwise>
     </c:choose>
   </c:set>
   <c:set var="ruleBusinessUnitInfo">
     <c:choose>
        <c:when test="${empty r.businessUnitItem}">${NONE}</c:when>
        <c:otherwise>${esapi:encodeForHTML(r.businessUnitItem.buName)} (${fn:trim(r.businessUnitItem.rootMultiOrgNodeKey)})</c:otherwise>
     </c:choose>
   </c:set>
   <c:set var="checkoutInfo">
     <c:choose>
        <c:when test="${empty r.checkoutTime || r.workflowState != 'Coding'}">${NONE}</c:when>
        <c:otherwise>${r.checkoutTime} &nbsp;<fmt:message key="rules.rulesPrintableVersion.byUser.fmt.txt"><fmt:param>${esapi:encodeForHTML(r.checkoutUser)}</fmt:param></fmt:message>
        </c:otherwise>
     </c:choose>
   </c:set>
   <c:set var="createdInfo">
     <c:choose>
        <c:when test="${empty r.createTimestamp}">${NONE}</c:when>
        <c:otherwise><span sortValue="${r.createTimestamp.getTime()}"><fmt:formatDate value='${r.createTimestamp}' pattern='${dateTimeFormat}' timeZone='${userTimeZone}'/></span> &nbsp;
        	<fmt:message key="rules.rulesPrintableVersion.byUser.fmt.txt"><fmt:param>${esapi:encodeForHTML(r.createUser)}</fmt:param></fmt:message>
        </c:otherwise>
     </c:choose>
   </c:set>
   <c:set var="ruleTypeInfo">
     <c:choose>
        <c:when test="${empty r.ruleType}">${NONE}</c:when>
        <c:otherwise><fmt:message key="rules.ruleType.${r.ruleType}.txt"/></c:otherwise>
     </c:choose>
   </c:set>
   <c:set var="updatedInfo">
     <c:choose>
        <c:when test="${empty r.lastUpdateTimestamp}">${NONE}</c:when>
        <c:otherwise>
            <fmt:formatDate value='${r.lastUpdateTimestamp}' pattern='${dateTimeFormat}' timeZone='${userTimeZone}'/>
            &nbsp;
        	<fmt:message key="rules.rulesPrintableVersion.byUser.fmt.txt">
        		<fmt:param>${esapi:encodeForHTML(r.lastUpdateUser)}</fmt:param>
        	</fmt:message>
        </c:otherwise>
     </c:choose>
   </c:set>
   <c:set var="multiOrgNodeId">
     <c:choose>
        <c:when test="${empty r.multiOrgNode}">${NONE}</c:when>
        <c:otherwise>${esapi:encodeForHTML(r.multiOrgNode.label)} (${r.multiOrgNode.key})</c:otherwise>
     </c:choose>
   </c:set>
   <c:set var="queueId">
     <c:choose>
        <c:when test="${empty queueMap[r.id]}">${NONE}</c:when>
        <c:otherwise>${esapi:encodeForHTML(queueMap[r.id].name)} (${queueMap[r.id].status})</c:otherwise>  <%-- S0881932 --%>
     </c:choose>
   </c:set>
   <c:set var="transactionType">${r.transactionTypeLabel}</c:set>

   <c:set var="description">
     <c:choose>
        <c:when test="${empty r.description || fn:trim(r.description)==''}">${NONE}</c:when>
        <c:otherwise>${esapi:encodeForHTML(r.description)}</c:otherwise>
     </c:choose>
   </c:set>
   <c:set var="operationalTimeLimit">
     <c:choose>
        <c:when test="${empty r.operationalTimeLimit || fn:trim(r.operationalTimeLimit)==''}">${NONE}</c:when>
        <c:otherwise>${esapi:encodeForHTML(r.operationalTimeLimit)}</c:otherwise>
     </c:choose>
   </c:set>
   <c:set var="alertReason">
     <c:choose>
        <c:when test="${empty r.alertReason || fn:trim(r.alertReason)==''}">${NONE}</c:when>
        <c:otherwise>${esapi:encodeForHTML(r.alertReason)}</c:otherwise>
     </c:choose>
   </c:set>
   <c:set var="alertType">
     <c:choose>
        <c:when test="${empty r.alertTypeCode || r.alertTypeCode==' '}">${NONE}</c:when>
        <c:otherwise>${alertTypeMap[r.alertTypeCode].desc} (${r.alertTypeCode})</c:otherwise>
     </c:choose>
   </c:set>
   <c:set var="executionOrderInfo">
     <c:choose>
       <c:when test="${empty r.executionOrderType}">
          ${NONE}
       </c:when>
       <c:when test="${-1 == r.executionOrderType}">
            <fmt:message key="rules.rulesPrintableVersion.executionOrder.PreRule.fmt.txt">
				<fmt:param>${r.executionOrderPriority}</fmt:param>
			</fmt:message>
       </c:when>
       <c:when test="${0 == r.executionOrderType}">
         <fmt:message key="rules.rulesPrintableVersion.executionOrder.MainRule.txt"/>
       </c:when>
       <c:when test="${1 == r.executionOrderType}">
            <fmt:message key="rules.rulesPrintableVersion.executionOrder.PostRule.fmt.txt">
				<fmt:param>${r.executionOrderPriority}</fmt:param>
			</fmt:message>
       </c:when>
       <c:otherwise>
            <fmt:message key="rules.rulesPrintableVersion.executionOrder.typeAndPriority.fmt.txt">
				<fmt:param>${r.executionOrderType}</fmt:param>
				<fmt:param>${r.executionOrderPriority}</fmt:param>
			</fmt:message>
       </c:otherwise>
     </c:choose>
   </c:set>
   <c:set var="preRequisitesForDisplay">
     <c:choose>
        <c:when test="${empty r.ruleDependencies}"></c:when>
        <c:when test="${r.workflowState!='Coding' && r.workflowState!='Testing' && r.workflowState!='Production'}">
           <c:set var='sep' value=' '/>
           <c:forEach var="d" items="${r.ruleDependencies}">${sep}${d.baseRuleId}<c:set var='sep' value=', '/></c:forEach>
        </c:when>
        <c:otherwise>
           <c:set var='sep' value=' '/>
           <c:forEach var="d" items="${r.ruleDependencies}">${sep}#${fn:substring(depRulesMap[d.baseRuleId].ruleType,0,1)}${d.baseRuleId}: ${esapi:encodeForHTML(depRulesMap[d.baseRuleId].name)} - ${depRulesMap[d.baseRuleId].workflowState}
           	<i><fmt:message key="rules.rulesPrintableVersion.forMacro.fmt.txt"><fmt:param>%HasRuleFired</fmt:param></fmt:message></i> <c:set var='sep' value='<br>'/>
           </c:forEach>  <%-- S0881932 --%>
        </c:otherwise>
     </c:choose>
   </c:set>
   <c:set var="dependencySeparator">
     <c:choose>
       <c:when test="${not empty r && not empty r.weakDependencies && not empty r.ruleDependencies }"><br></c:when>
       <c:when test="${    empty r ||(    empty r.weakDependencies &&     empty r.ruleDependencies)}">${NONE}</c:when>
       <c:otherwise> </c:otherwise>
     </c:choose>
   </c:set>
   <c:set var="weakRequisitesForDisplay">
     <tiles:insertTemplate template="tiles/weakDependency.jsp" flush="false">
       <tiles:putAttribute name="rule" value="${r}" />
       <tiles:putAttribute name="none" value="" />
     </tiles:insertTemplate>
   </c:set>
   <c:set var="usedVariablesForDisplay">
     <c:choose>
        <c:when test="${empty r.usedVariableList}">${NONE}</c:when>
        <c:otherwise>
           <c:set var='sep' value=''/>
           <c:forEach var="v" items="${r.usedVariableList}">${sep}<c:if test="${not empty fieldNameMap[v.variableId]}"> ${fn:toUpperCase(fieldNameMap[v.variableId])}</c:if><c:set var='sep' value=','/></c:forEach>
        </c:otherwise>
     </c:choose>
   </c:set>
   <c:set var="code">
     <c:choose>
        <c:when test="${empty r.code}">${NONE}</c:when>
        <c:otherwise>${esapi:encodeForHTML(r.code)}</c:otherwise>  <%-- S0881932 --%>
     </c:choose>
   </c:set>


   <%-- Include common print layout (used here as well as from rule code editor) --%>
   <%@ include file="/rules/tiles/printRule.jsp" %>


</c:forEach>


</BODY>
</HTML>


