<%@ include file="/common/taglibsT3.jsp" %>
<%@ page contentType="text/html; charset=UTF-8" %>

  <script language='JavaScript' src='common/scripts/jquery.js'></script>
  <script language='JavaScript' src='<c:url value="/common/scripts/i18n.js"/>'></script>
  <script language="JavaScript" src="common/scripts/jquery.fcm.dynaform.js"></script>
  <script language="JavaScript" src="rules/scripts/dynamicRows.js"></script>
  <script language="JavaScript" src="rules/scripts/itemPriorityList.js"></script>
  <script language="JavaScript" src="rules/scripts/autoSizing.js"></script>
  <SCRIPT language="JavaScript" src="common/scripts/calendar.js"></SCRIPT>
  <SCRIPT language="JavaScript" src="rules/scripts/sort.js"></SCRIPT>
  <script language="JavaScript" src="rules/scripts/rules.js"></script>
  <script language="JavaScript" src="rules/scripts/lookupLists.js"></script>
  <script language="JavaScript" src="rules/scripts/lookupListActions.js"></script>

  <c:if test='${isTenantInstall == true}'> <c:set var='tenant' value='tenant'/> </c:if>

  <c:set var="hasRuleLookupLists" value="false"/>
  <c:set var="hasAnalystLookupLists" value="false"/>
  <c:forEach var="listInfo" items="${listsInfo}" varStatus="status">
    <c:if test="${listInfo.type=='RULEONLY'}">
       <c:set var="hasRuleLookupLists" value="true"/>
    </c:if>
    <c:if test="${listInfo.type=='ANALYST'}">
       <c:set var="hasAnalystLookupLists" value="true"/>
    </c:if>
  </c:forEach>

<c:choose>
	<c:when test="${empty productName}">
<pre id="tabTitle" style="display:none;">SAS&reg; Fraud Management - <fmt:message key="creditfraud.tab.lookupLists.txt" /></pre>
	</c:when>
	<c:otherwise>
<pre id="tabTitle" style="display:none;">${fn:replace(fn:replace(productName, "<sup>", ""), "</sup>", "")} - <fmt:message key="creditfraud.tab.lookupLists.txt" /></pre>
	</c:otherwise>
</c:choose>
  <script language="JavaScript">
  //<!--
  try { // S1070343
    if (parent.document)
      parent.document.title = document.getElementById("tabTitle").innerHTML;
  } catch(e) { // S1070343
    // Ignore S1070343
  } // S1070343

  var activatedFlag = "${activatedFlag}";
  if( activatedFlag != "" ) {
	//update the active / inactive tabs over on the left
	setCookieForTab("list", null, "_listLookupLists");
	parent.frames[ "overview" ].location.href = "listLookupListFolders.action?skipRefreshFlag=1";
  }

  
  var lookupListDeActivateAction =  '<c:url value="/deactivateLookupListsPopup.action" />';
  var lookupListFileTypeAction = '<c:url value="/downloadLookupListPopup.action" />';
  var lookupListUploadAction = '<c:url value="/uploadLookupListPopup.action"/>';
  
  var contentOrList = "${contentOrList}"

  if (contentOrList == "content") {
	   parent.sas.fscf.getCurrentDetailToolbar().setContentFor("contentFiles");
  } else {
	   parent.sas.fscf.getCurrentDetailToolbar().setContentFor("lookupLists");
  }

  function ignoreReturn(evt)
  {
     if(!evt) evt = window.event;
     if(evt.keyCode == 13) return false;
     return true;
  }

  var lookupListUpNbrs = new Array();
  var lookupListNames = new Array();
  var lookupListFiles = new Array();

  <c:forEach var="listInfo" items="${listsInfo}" >
  //-->
  </script>
     <pre id="lookupListUpNbr${listInfo.id}" style="display:none">${fn:escapeXml(listInfo.lstupdtNbr)}</pre>
     <pre id="lookupListName${listInfo.id}"  style="display:none">${fn:escapeXml(listInfo.name)}</pre>
     <pre id="lookupListFile${listInfo.id}"  style="display:none">${fn:escapeXml(listInfo.inds)}</pre>
  <script>
  //<!--
     lookupListUpNbrs[${listInfo.id}] = document.getElementById("lookupListUpNbr${listInfo.id}").innerHTML;
     lookupListNames[${listInfo.id}]  = document.getElementById("lookupListName${listInfo.id}").innerHTML;
     lookupListFiles[${listInfo.id}]  = document.getElementById("lookupListFile${listInfo.id}").innerHTML;
  </c:forEach>

  //-->
  </script>

  <script>
  parent._lookupListIdsFromForeignBusinessUnits = new Array();
  <c:forEach var="id" items="${lookupListIdsFromForeignBusinessUnits}">
  	parent._lookupListIdsFromForeignBusinessUnits["${id}"] = true;
  </c:forEach>
  </script>

   <span style='height:0.5em'/>
   <div id="rulesTabScrollableDiv" class="rulesTabScrollableClass">

   <%-- Error handling code --%>
   <style>
     .confirmationMessage { text-align:left; }
     .errorMessage { text-align:left; }
   </style>
   <div onclick="this.innerHTML='<br>'">
		<c:url var="reloadURL" value="/listLookupLists.action?contentOrList=${contentOrList}" />
		<tiles:insertDefinition name="ruleSystemMessageLayout" flush="true">
			<tiles:putAttribute name="reloadURL" value="${reloadURL}" />
			<tiles:putAttribute name="refreshURL" value="${reloadURL}&refresh=true" />
			<tiles:putAttribute name="objectTypeName" value="Rule" />
		</tiles:insertDefinition>
   </div>

  <table width="98%">
  <tr><td>

  <%-- Title --%>
  <div align="left" style="width:98%;">
     <h4><fmt:message key="rules.lookupLists.ose.${contentOrList}.title.txt"/></h4>
  </div>

  <table class="mainTable" id="lookupListsTable" width="98%" align="left" style="margin:0px 0px 0px 0px;-moz-user-select:none;" onselectstart='return false;' border="0" cellspacing="0" cellpadding="0">
     <thead>
       <TR class="tableColumnHeaderRow">

           <TH class="centeredTableHeader" nowrap rules:sortAsText>&nbsp;<fmt:message key="rules.ruleListDetailContent.tableHeader.id.txt" /></TH>
           <TH class="centeredTableHeader" nowrap rules:sortAsText>&nbsp;<fmt:message key="rules.lookupListsDetailContent.tableHeader.listName.txt" /></TH>

           <TH class="centeredTableHeader" nowrap rules:sortAsText title="<esapi:encodeForHTMLAttribute><fmt:message key='rules.lookupListsDetailContent.tableHeader.keyFields.title.txt' /></esapi:encodeForHTMLAttribute>">&nbsp;<fmt:message key="rules.lookupListsDetailContent.tableHeader.keyFields.txt" /></TH>

           <TH class="centeredTableHeader" nowrap rules:sortAsText title="<esapi:encodeForHTMLAttribute><fmt:message key='rules.lookupListsDetailContent.tableHeader.dataFields.title.txt' /></esapi:encodeForHTMLAttribute>">&nbsp;<fmt:message key="rules.lookupListsDetailContent.tableHeader.dataFields.txt" /></TH>
           <c:if test="${isUsingWildBu}"> <%-- S1010617 --%>
             <TH class="centeredTableHeader" nowrap rules:sortAsText title="<esapi:encodeForHTMLAttribute><fmt:message key='rules.lookupListsDetailContent.tableHeader.businessUnit.title.txt' /></esapi:encodeForHTMLAttribute>">&nbsp;<fmt:message key="rules.lookupListsDetailContent.tableHeader.businessUnit.txt" /></TH>
           </c:if>
           <TH class="centeredTableHeader" nowrap rules:sortAsText title="<esapi:encodeForHTMLAttribute><fmt:message key='rules.lookupListsDetailContent.tableHeader.description.title.txt' /></esapi:encodeForHTMLAttribute>">&nbsp;<fmt:message key="rules.lookupListsDetailContent.tableHeader.description.txt" /></TH>
           <TH class="centeredTableHeader" nowrap rules:sortAsNum  title="<esapi:encodeForHTMLAttribute><fmt:message key='rules.lookupListsDetailContent.tableHeader.rules.title.txt' /></esapi:encodeForHTMLAttribute>">&nbsp;<fmt:message key="rules.lookupListsDetailContent.tableHeader.rules.txt" /></TH>

           <TH class="centeredTableHeader" nowrap rules:sortAsText>&nbsp;<fmt:message key="rules.lookupListsDetailContent.tableHeader.contentFile.txt" /></TH>
         <c:if test="${includeRefreshDateTime}"> <!-- S1070343 -->
            <TH class="centeredTableHeader" nowrap rules:sortAsLocalDate>&nbsp;<fmt:message key="rules.lookupListsDetailContent.tableHeader.lastLoaded.txt" /></TH>
         </c:if>
       </TR>
     </thead>

     <TBODY id="ruleTableBody">

      <c:if test="${!hasRuleLookupLists}">
        <TR rowspan="2">
           <TD align="right" style="font-size:10pt;" colspan="100%"><center><em><fmt:message key="rules.lookupListsDetailContent.noLookupLists.txt" /></center></em></TD>
        </TR>
      </c:if>

      <c:if test="${hasRuleLookupLists}">
        <c:forEach var="listInfo" items="${listsInfo}" varStatus="status">
           <c:if test="${listInfo.type=='RULEONLY'}">
             <TR style="cursor:pointer;" id="${status.count}_ruleList" class="dataRow${status.count%2+1}_tableRow"
                 onClick='handleRowSelectionLookupList(${listInfo.id}, lookupListUpNbrs[${listInfo.id}], lookupListNames[${listInfo.id}], lookupListFiles[${listInfo.id}], this, "rowSelected", event)'
                 ondblclick='viewLookupList();'>

                  <TD class="textTableCell">${fn:trim(fn:escapeXml(listInfo.id))}</TD>
                  <TD class="textTableCell">${fn:trim(fn:escapeXml(listInfo.name))}</TD>
                  <TD class="textTableCell" >${fn:trim(fn:escapeXml(listInfo.untypedKeyColumns))}</TD>
                  <TD class="textTableCell" >${fn:trim(fn:escapeXml(listInfo.untypedDataColumns))}</TD>
                  <c:if test="${isUsingWildBu}"> <%-- S1010617 --%>
                    <TD class="textTableCell" >${fn:trim(fn:escapeXml(listInfo.businessUnitName))}</TD>
                  </c:if>
                  <TD class="textTableCell" >${fn:trim(fn:escapeXml(listInfo.desc))}</TD>
                  <TD class="numericTableCell" ><c:if test="${listInfo.ruleCount>0}">${listInfo.ruleCount}</c:if></TD>
                  <TD class="textTableCell" >${fn:trim(fn:escapeXml(listInfo.inds))}</TD>
                  <c:if test="${includeRefreshDateTime}"> <!-- S1070343 -->
                    <TD class="textTableCell" nowrap><span dateFormat="${dateFormat} ${timeFormat}" sortvalue="${listInfo.refreshDateUtcMillis}"><fmt:formatDate value='${listInfo.refreshDate}' pattern='${dateTimeFormat}' timeZone='${userTimeZone}'/></span>&nbsp;
                  </c:if>
                </TD>
             </TR>
           </c:if>
        </c:forEach>
      </c:if>

     </TBODY>
  </table>
</td></tr>

 <c:if test="${hasAnalystLookupLists}">
   <tr><td>

   <div align="left" style="width:98%;">
      <h4><fmt:message key="rules.lookupLists.ose.analyst.${contentOrList}.title.txt"/></h4>
   </div>

   <table class="mainTable" id="analystlookupListsTable" width="98%" align="left" style="margin:0px 0px 0px 0px;-moz-user-select:none;" onselectstart='return false;' border="0" cellspacing="0" cellpadding="0">
     <thead>

       <TR class="tableColumnHeaderRow">
           <TH class="centeredTableHeader" nowrap rules:sortAsText>&nbsp;<fmt:message key="rules.ruleListDetailContent.tableHeader.id.txt" /></TH>
           <TH class="centeredTableHeader" nowrap rules:sortAsText>&nbsp;<fmt:message key="rules.lookupListsDetailContent.tableHeader.listName.txt" /></TH>
           <TH class="centeredTableHeader" nowrap rules:sortAsText title="<esapi:encodeForHTMLAttribute><fmt:message key='rules.lookupListsDetailContent.tableHeader.analystKeyField.title.txt' /></esapi:encodeForHTMLAttribute>">&nbsp;<fmt:message key="rules.lookupListsDetailContent.tableHeader.analystKeyField.txt" /></TH>
           <c:if test="${isUsingWildBu}"> <%-- S1010617 --%>
             <TH class="centeredTableHeader" nowrap rules:sortAsText title="<esapi:encodeForHTMLAttribute><fmt:message key='rules.lookupListsDetailContent.tableHeader.businessUnit.title.txt' /></esapi:encodeForHTMLAttribute>">&nbsp;<fmt:message key="rules.lookupListsDetailContent.tableHeader.businessUnit.txt" /></TH>
           </c:if>
           <TH class="centeredTableHeader" nowrap rules:sortAsText title="<esapi:encodeForHTMLAttribute><fmt:message key='rules.lookupListsDetailContent.tableHeader.description.title.txt' /></esapi:encodeForHTMLAttribute>">&nbsp;<fmt:message key="rules.lookupListsDetailContent.tableHeader.description.txt" /></TH>
           <TH class="centeredTableHeader" nowrap rules:sortAsNum  title="<esapi:encodeForHTMLAttribute><fmt:message key='rules.lookupListsDetailContent.tableHeader.rules.title.txt' /></esapi:encodeForHTMLAttribute>">&nbsp;<fmt:message key="rules.lookupListsDetailContent.tableHeader.rules.txt" /></TH>
           <TH class="centeredTableHeader" nowrap rules:sortAsNum  title="<esapi:encodeForHTMLAttribute><fmt:message key='rules.lookupListsDetailContent.tableHeader.strategies.title.txt' /></esapi:encodeForHTMLAttribute>">&nbsp;<fmt:message key="rules.lookupListsDetailContent.tableHeader.strategies.txt" /></TH>
           <TH class="centeredTableHeader" nowrap rules:sortAsNum  title="<esapi:encodeForHTMLAttribute><fmt:message key='rules.lookupListsDetailContent.tableHeader.entries.title.txt' /></esapi:encodeForHTMLAttribute>">&nbsp;<fmt:message key="rules.lookupListsDetailContent.tableHeader.entries.txt" /></TH>

           <c:if test="${includeRefreshDateTime}"> <!-- S1070343 -->
             <TH class="centeredTableHeader" nowrap rules:sortAsLocalDate>&nbsp;<fmt:message key="rules.lookupListsDetailContent.tableHeader.lastUpdated.txt" /></TH>
           </c:if>
       </TR>
     </thead>

     <TBODY id="analsystListTableBody">

      <c:if test="${not empty listsInfo}">
        <c:forEach var="listInfo" items="${listsInfo}" varStatus="status">
           <c:if test="${listInfo.type!='RULEONLY'}">
             <TR style="cursor:pointer;" id="${status.count}_analystList" class="dataRow${status.count%2+1}_tableRow"
                 onClick='handleRowSelectionLookupList(${listInfo.id}, lookupListUpNbrs[${listInfo.id}], lookupListNames[${listInfo.id}], lookupListFiles[${listInfo.id}], this, "rowSelected", event)'
                 ondblclick='viewLookupList();'>

                  <TD class="textTableCell">${fn:trim(fn:escapeXml(listInfo.id))}</TD>
                  <TD class="textTableCell">${fn:trim(fn:escapeXml(listInfo.name))}</TD>
                  <TD class="textTableCell" >
                    <c:set var="foundFirstKey" value="false"/>
                    <c:set var="foundFirstAdditionalKey" value="false"/>
                   	<c:forEach var="column" items="${listInfo.columns}">
                    <c:if test="${column.usage == 'KEY'}">
                     	<c:if test="${foundFirstKey}">
                   			<c:if test="${!foundFirstAdditionalKey}">
                     			+
                     			<c:set var="foundFirstAdditionalKey" value="true"/>
	                     	</c:if>
	                    </c:if>
                    	<c:if test="${!foundFirstKey}">
                     		${fn:trim(fn:escapeXml(column.name))}
                     		<c:set var="foundFirstKey" value="true"/>
                     	</c:if>
 					</c:if>
                  	</c:forEach>
                  </TD>
                  <c:if test="${isUsingWildBu}"> <%-- S1010617 --%>
                    <TD class="textTableCell" >${fn:trim(fn:escapeXml(listInfo.businessUnitName))}</TD>
                  </c:if>

                  <TD class="textTableCell" >${fn:trim(fn:escapeXml(listInfo.desc))}</TD>
                  <TD class="numericTableCell" ><c:if test="${listInfo.ruleCount>0}">${listInfo.ruleCount}</c:if></TD>
                  <TD class="numericTableCell" ><c:if test="${listInfo.strategyCount>0}">${listInfo.strategyCount}</c:if></TD>
                  <TD class="numericTableCell" ><c:if test="${listInfo.totalRows>0}">${listInfo.totalRows}</c:if></TD>

                  <c:if test="${includeRefreshDateTime}"> <!-- S1070343 -->
                     <TD class="textTableCell" nowrap><span dateFormat="${dateFormat} ${timeFormat}" sortvalue="${listInfo.refreshDateUtcMillis}"><fmt:formatDate value='${listInfo.refreshDate}' pattern='${dateTimeFormat}' timeZone='${userTimeZone}'/></span>&nbsp;
                  </c:if>
                </TD>
             </TR>
           </c:if>
        </c:forEach>
      </c:if>

     </TBODY>
  </table>
  </td></tr>
</c:if>

</table>

<%-- Iframe for avoiding download Runtime Error has occurred Error:Access is denied --%>
<iframe width="0" height="0" id="downloadFrame" name="downloadFrame" src="rules/beige.htm" style="display:none"></iframe>


<script>
   attachEventHandlerToTableCells(['lookupListsTable']);
   <c:if test="${hasAnalystLookupLists}">
   attachEventHandlerToTableCells(['analystlookupListsTable']);
   </c:if>
</script>


</div>
