<%/*--------------------------------------------------------------------------------------|
|Copyright (c) 2006, SAS Institute, Inc.  All Rights Reserved.
|
|NAME: rules/lookupListContents.jsp
|DESCRIPTION: Display pageable contents of a lookup list
|---------------------------------------------------------------------------------------*/%>

<%@ include file="/common/taglibsT3.jsp" %>
<%@ page contentType="text/html; charset=UTF-8" %>

<HTML>
<HEAD>
    <meta http-equiv="cache-control" content="no-cache"/>
    <TITLE><fmt:message key="rules.lookupListContents.pageTitle.txt"/></TITLE>

    <script language='JavaScript' src='<c:url value="/common/scripts/jquery.js"/>'></script>
    <script language='JavaScript' src='<c:url value="/common/scripts/i18n.js"/>'></script>
    <SCRIPT language='JavaScript' src='<c:url value="/common/scripts/sasSolutions.js"/>'></SCRIPT>
    <SCRIPT language='JavaScript' src='<c:url value="/common/scripts/cf.js"/>'></SCRIPT>
    <SCRIPT language='JavaScript' src='<c:url value="/rules/scripts/ruleSasTest.js"/>'></SCRIPT>
    <SCRIPT language='JavaScript' src='<c:url value="/rules/scripts/lookupLists.js"/>'></SCRIPT>
    <link rel="stylesheet" href="resources/sas/hc/ui/core/themes/sas_base/fonts.css" type="text/css"/>
    <link rel='stylesheet' href='resources/sap/ui/core/themes/sas_corporate/library.css' type='text/css'>
    <link rel='stylesheet' href='resources/sap/ui/commons/themes/sas_corporate/library.css' type='text/css'>
	<link rel="stylesheet" href="resources/sas/hc/ui/core/themes/sas_corporate/library.css" type="text/css"/>
	<link rel="stylesheet" href="resources/sas/hc/ui/commons/themes/sas_corporate/library.css" type="text/css"/>
	<link rel="stylesheet" href="resources/sap/m/themes/sas_corporate/library.css" type="text/css"/>
    <STYLE type='text/css'>@import '<c:url value="/common/styles/sasStyles.css"/>';</style>
    <link rel='stylesheet' href='<c:url value="/common/styles/cf.css"/>' type='text/css'>
    <style type='text/css'>@import '<c:url value="/admin/styles/admin.css"/>';</STYLE>

    <script>
        var lookupListRest = '<c:url value="/rest/businessunits/"/>'
       
       // List colnames in containing frame (if creating new lookup list)
       function showColumns() {
    	   
           var columnTags = parent.document.getElementById('columnTags');
           if (columnTags) {
              var columnNames = new Array();
              var tagText = decodeURIComponent(columnTags.innerHTML); // S1020196
              var checkboxes = columnTags.querySelectorAll('input[type="checkbox"]');
              var checkboxInfo = {};
               checkboxes.forEach(function (checkbox) {
                   var checkboxName = checkbox.name.substring(3);
                   var isChecked = checkbox.checked;
                   checkboxInfo[checkboxName] = isChecked;
               });
              <c:forEach var="column" items="${listInfo.columns}" >
                 var checked = "";
                 <c:if test="${column.isKey()}">
                    if (tagText && tagText!='' && tagText.indexOf('<INPUT')<0) checked = " checked='checked'";
                 </c:if>
                 var dataType = "$";
                 <c:if test="${column.isNumeric()}">
                 	 dataType = "#";
                 </c:if>
                 if(checkboxInfo["${column.name}"]) checked = " checked='checked'";
                 columnNames.push("<input type='checkbox' name='COL${column.name}' id='COL"+dataType+"${column.name}'" + checked + ">${column.name}");
              </c:forEach>

              columnTags.innerHTML = columnNames.join("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
              
              updateFileSelectDropdown();
              
              var doDecrement = "${doDecrement}";
              if( doDecrement ) {
              	var lastUpdateNumberInput = window.parent.document.getElementById("lstUpdtNbrCreate");
              	var lastUpdateNumber = lastUpdateNumberInput.value;
              	lastUpdateNumberInput.value = parseInt(lastUpdateNumber) - 1;
              }
           }
        }
    </script>
</HEAD>

<BODY
    onload="i18n.init();showColumns();"
    onunload=""
    onblur=""
    onmousemove=""
    style="overflow: auto; background-color:#f0f1f2; border:1px solid #c6cad0;border-top:1px solid #f0f1f2;"
    marginheight="0"
    marginwidth="0" >

<%-- Submit the parms that cause the display of the table --%>
<form name="contentsForm" action="<c:url value="/showLookupListContents.action"/>" method="post">
  <input type="hidden" id="method"    name="method"    value='showLookupListContents'/>
  <input type="hidden" id="name"      name="name"      value="${fn:escapeXml(listInfo.name)}"/>
  <input type="hidden" id="inds"      name="inds"      value="${fn:escapeXml(listInfo.inds)}"/>
  <input type="hidden" id="columns"   name="columns"   value="${fn:escapeXml(listInfo.typedColumns)}"/>
  <input type="hidden" id="listType"  name="listType"  value="${listInfo.type}"/>
  <input type="hidden" id="totalRows" name="totalRows" value="${listInfo.totalRows}"/>
  <input type="hidden" id="firstRow"  name="firstRow"  value="${listInfo.firstRow}"/>
  <input type="hidden" id="rowCount"  name="rowCount"  value="${rowCount}"/>
</form>

<%-- The table of results --%>
<div id="actualContents">

<c:choose>

  <c:when test="${not empty errorMessage}">
    <br><br>
    <div style="background-color:#f0f1f2;width:100%;">
      <center>
        <br>
         <c:choose>
           <c:when test="${not empty errorMessageList}">
           	  <i>${fn:escapeXml(prefix)}</i>
           	  <br>
  			  <c:forEach var="msg" items="${errorMessageList}">
  				<i>${fn:escapeXml(msg)}</i>
  				<br>
  			  </c:forEach>
  		    </c:when>
  		
  		  <c:otherwise>
  			<i>&nbsp;&nbsp;${fn:escapeXml(errorMessage)}</i>
  		  </c:otherwise>
  		</c:choose>
      </center>
    </div>
  </c:when>


  <c:otherwise>
  	<div width="100%" style="background-color:#f0f1f2; margin-top:-2px;">
  	
  	 <div onclick="this.innerHTML='<br>'">
   		<c:url var="reloadURL" value="/showLookupListContents.action" />
		<tiles:insertDefinition name="ruleSystemMessageLayout" flush="true">
			<tiles:putAttribute name="reloadURL" value="${reloadURL}" />
			<tiles:putAttribute name="refreshURL" value="${reloadURL}?refresh=true" />
			<tiles:putAttribute name="objectTypeName" value="Rule" />
		</tiles:insertDefinition>
 	</div>

        <c:if test="${listInfo.type=='RULEONLY'}">
        <div class="configurationTableTitle" style="float:left;background-color:#f0f1f2;border-bottom:0px;margin-top:6px;margin-left:1px;">
           <b>&nbsp;&nbsp;${listInfo.inds}</b>
        </div>
        </c:if>

        <div style="float:right;font-size:xx-small;margin-top:2px;">
             <c:choose>
             <c:when test="${listInfo.firstRow <= 1}">
                 <img src="<c:url value='/images/rules/double_left_03g.gif' />" border="0"></span>&nbsp;&nbsp;
                 <img src="<c:url value='/images/rules/left_03g.gif' />" border="0"></span>&nbsp;&nbsp;
             </c:when>
             <c:otherwise>
                 <span onclick="document.contentsForm.firstRow.value=1;document.contentsForm.submit()" title="<esapi:encodeForHTMLAttribute><fmt:message key="rules.lookupListContents.navigation.first.title.txt"/></esapi:encodeForHTMLAttribute>">
                     <img src="<c:url value='/images/rules/double_left_03b.gif' />" border="0">
                 </span>&nbsp;&nbsp;
                 <span onclick="document.contentsForm.firstRow.value=${listInfo.firstRow-rowCount};document.contentsForm.submit()" title="<esapi:encodeForHTMLAttribute><fmt:message key="rules.lookupListContents.navigation.previous.title.txt"/></esapi:encodeForHTMLAttribute>">
                     <img src="<c:url value='/images/rules/left_03b.gif' />" border="0">
                 </span>&nbsp;&nbsp;
             </c:otherwise>
             </c:choose>

             <c:choose>
             <c:when test="${(listInfo.firstRow+shownCount) > listInfo.totalRows}">
                 <img src="<c:url value='/images/rules/right_03g.gif' />" border="0"></span>&nbsp;&nbsp;
                 <img src="<c:url value='/images/rules/double_right_03g.gif' />" border="0"></span>&nbsp;&nbsp;
             </c:when>
             <c:otherwise>
                 <span onclick="document.contentsForm.firstRow.value=${listInfo.firstRow+rowCount};document.contentsForm.submit()" title="<esapi:encodeForHTMLAttribute><fmt:message key="rules.lookupListContents.navigation.next.title.txt"/></esapi:encodeForHTMLAttribute>">
                     <img src="<c:url value='/images/rules/right_03b.gif' />" border="0">
                 </span>&nbsp;&nbsp;
                 <span onclick="document.contentsForm.firstRow.value=${listInfo.totalRows-rowCount+1};document.contentsForm.submit()" title="<esapi:encodeForHTMLAttribute><fmt:message key="rules.lookupListContents.navigation.last.title.txt"/></esapi:encodeForHTMLAttribute>">
                     <img src="<c:url value='/images/rules/double_right_03b.gif' />" border="0">
                 </span>&nbsp;&nbsp;
             </c:otherwise>
             </c:choose>
             <br><fmt:message key='rules.lookupListContents.navigation.rowRange.fmt.txt'><fmt:param>${listInfo.firstRow}</fmt:param><fmt:param>${listInfo.firstRow + shownCount - 1}</fmt:param><fmt:param>${listInfo.totalRows}</fmt:param></fmt:message>
        </div>
      </div>
      <TABLE class="mainTable" align="center" width="98%" style="border-collapse:separate;border-top:1px solid #C6CAD0;border-bottom:1px solid #C6CAD0;border-left:1px solid #C6CAD0;border-right: 1px solid #F5DEB3;background-color:white" id="contentsTable" cellspacing="0" cellpadding="5">
         <thead>
           <TR class="tableColumnHeaderRow" >
              <c:forEach var="column" items="${listInfo.columns}" >
                 <TH class="centeredTableHeader" nowrap style="border-left:1px solid #e0e2e5;">&nbsp;${column.name}</TH>
              </c:forEach>
           </TR>
         </thead>
         <TBODY id="ruleTableBody">
          <c:if test="${empty listInfo.contents}">
            <TR rowspan="2">
               <TD align="right" style="font-size:8pt;border-left:1px solid #e0e2e5;" colspan="100%"><center><em><fmt:message key="rules.lookupListContents.noData.txt"/></center></em></TD>
            </TR>
          </c:if>
          <c:if test="${not empty listInfo.contents}">
            <c:forEach var="row" items="${listInfo.contents}" varStatus="status">
               <%-- Not honoring color alternation in css dataRow${status.count%2+1}_tableRow, so do it by hand --%>
               <c:set var="bgcolor" value="white"/>
               <c:if test="${status.count%2==0}"><c:set var="bgcolor" value="#f0f1f2"/></c:if>
               <TR id="${status.count}" class="dataRow${status.count%2+1}_tableRow" >

               <c:forEach var="column" items="${listInfo.columns}" >
                  <c:if test="{$column.isNumeric()}">
                     <c:set var="cls" value="numericTableCell"/>
                  </c:if>
                  <TD style="background-color:${bgcolor};vertical-align:top;border-left:1px solid #e0e2e5;" class="${cls}" >
                     &nbsp;${fn:trim(fn:escapeXml(row[(fn:toUpperCase(column.name))]))}
                  </TD>
               </c:forEach>
               </TR>
            </c:forEach>
          </c:if>
         </TBODY>
      </TABLE>


      <%-- If this file is not in the parent selection list, add it --%>
      <script>
         var indsSelector = window.parent.document.getElementById("inds");
         if (indsSelector != null)
         {
         if (indsSelector.options)
         {
           var i;
           for (i=0; i<indsSelector.options.length;i++)
           {
             if (indsSelector.options[i].value=="${listInfo.inds}")
               break;
           }
           if (i==indsSelector.options.length)
           {
             var opt = window.parent.document.createElement("option");
             opt.value = "${listInfo.inds}";
             opt.text = "${listInfo.inds}";
             indsSelector.options[i] = opt;
             indsSelector.selectedIndex = i;
           }
         }
         }

     	 try { refreshContents(); } catch(e) { } // Ignore this

      </script>

  </c:otherwise>



</c:choose>
</div>

</BODY>
</HTML>





