<%@ include file="/common/taglibsT3.jsp" %>
<%@ page contentType="text/html; charset=UTF-8" %>
   <style type="text/css">@import "common/styles/sasStyles.css";</style>
   <script language="JavaScript" src="common/scripts/tree.js"></script>
   <script language="JavaScript" src="rules/scripts/variables.js"></script>
   <script language="JavaScript" src="rules/scripts/lookupLists.js"></script>

<!-- Tree header. -->
<div id="navhead" class="mmhide_navhd" style="display:none;"></div>
<div class="sapUiTreeHeader" id="consoleHeader" role="heading">
  <div class="sapUiTreeTitle"><fmt:message key="console.consoleOverviewContent.title.txt" /></div>
</div>

<!-- Nested tables with fixed height -->
<table id="overview_table" cellspacing=0 cellpadding=2 border="0"  >
   <tr>
      <td id="navcol" align="left" valign="top" nowrap>

<script language="JavaScript">
//<!--

   function show()
   {
     var selectedNode = _consoleTree.getSelectedNodes()[0];
     var nodeId = selectedNode.getId();
     setCookieForTab(nodeId);
     if (!selectedNode)
     {
        parent.sas.fscf.getCurrentDetailToolbar().setContentFor();
     	parent.frames[ "detail" ].location.href = 'common/blank.html';
        return;
     }
     var params = selectedNode.parameters;
     if (!params)
     {
        parent.sas.fscf.getCurrentDetailToolbar().setContentFor();
      	parent.frames[ "detail" ].location.href = 'common/blank.html';
        return;
      }
     params = params.split(",");
     var method = params[0];
     var type = params[1];
     var serverHost=params[2];
     var title = params[2];
     if(params.length>3) var dataSource= params[3];
     if (!method)
     {
        parent.sas.fscf.getCurrentDetailToolbar().setContentFor();
      	parent.frames[ "detail" ].location.href = 'common/blank.html';
        return;
      }
     // var action = detailAction + '?method=' + method;
     action = "";
     
     if (method=="showDeployment")
     {
    	setBusy();
        // action= detailAction + '?method=' + method + "&deployableTarget=" + params[1] + "&multiOrgNodeKey=" + params[2];
        action= "showConsoleDeployment.action?&multiOrgNodeKey=" + params[2];
        parent.sas.fscf.getCurrentDetailToolbar().setContentFor('deployment');
        parent.frames[ "detail" ].location.href = action;
     }
     else
     {
     	var params = "";
        if (type)
           params += "&type=" + type;
        if (serverHost)
            params += "&serverHost=" + serverHost;
        if (title)
           params += "&title=" + title;
        if (dataSource){
           params += "&dataSource=" + dataSource;
        }

        if (method=="pingServers") {
            parent.sas.fscf.getCurrentDetailToolbar().setContentFor('pingServers');
            action = "pingServers.action?type=" + type;
        } else if (method=="monPerf") {
            parent.sas.fscf.getCurrentDetailToolbar().setContentFor('monPerf',type);
            action = "monitorPerformance.action?barsPerPage=" + getCookie('console_barsPerPage') + params;           
        } else if (method=="playRecording") {
            parent.sas.fscf.getCurrentDetailToolbar().setContentFor('playRecording');
            action = "playPerformanceRecoding.action?" + params;         
        } else if (method=="viewProperties") {
            parent.sas.fscf.getCurrentDetailToolbar().setContentFor('viewProperties');
            action = "viewConsoleProperties.action?type=" + type;
        } else if (method=="viewMessageFailures") {
            parent.sas.fscf.getCurrentDetailToolbar().setContentFor('viewMessageFailures');
            action = "viewMessageFailures.action?type=" + type;
        }
        parent.frames[ "detail" ].location.href = action;
     }

   }


   function hideBusy()
   {
      var windowObj = (top != self) ? top : self;
      var frameDiv = windowObj.document.getElementById("frameDiv");
      if(frameDiv)
         frameDiv.style.display="none";

      var busyMsgTop = windowObj.document.getElementById("busyMessageDiv");
      if(busyMsgTop)
         busyMsgTop.style.display="none";
   }
   hideBusy();

   function endsWith(str, suffix) {
	    return str.indexOf(suffix, str.length - suffix.length) !== -1;
	}


   // Remove padding so menubar appears to be glued to the top
   document.body.style.padding = "0";
   document.getElementById("navhead").style.padding = "0";

    // To identify new or modified objects
   var _selectedObject = getCookieForTab("-1");
   var _consoleNodes = new Array();

   // CheatSheet: function Node( nodeId, parentId, image, title, tip, parameters, state, italic, owner )
   _consoleNodes[_consoleNodes.length] = new Node("pipe",         0,          "folder",        "<fmt:message key='console.consoleOverviewContent.deploy.transactionPipeline.txt'/>", "<fmt:message key='console.consoleOverviewContent.deploy.transactionPipeline.txt'/>", "",               "", "", "");


   _consoleNodes[_consoleNodes.length] = new Node("deployment",   "pipe",   "folder","<fmt:message key='console.consoleOverviewContent.deploy.deploy.txt'/>",               "<fmt:message key='console.consoleOverviewContent.deploy.deploy.txt'/>",               "",               "", "", "");
	<c:forEach var="dPackage" items="${deploymentPackages}" varStatus="ii">
	<c:if test="${ii.first}">if (_selectedObject == "-1") _selectedObject='deploy_${fn:trim(dPackage.key)}';</c:if>
	  var changes = "${dPackage.descriptionOfChanges}";
	  var descChanges;
	  if(endsWith(changes,"no changes")){
		 descChanges = changes.replace("no changes","<fmt:message key='console.consoleOverviewContent.nochanges.txt'/>");
	  }
	  if(endsWith(changes,"added")){
		 descChanges = changes.replace("added","<fmt:message key='console.consoleOverviewContent.added.txt'/>");
	  }
	  if(endsWith(changes,"updated")){
		 descChanges = changes.replace("updated","<fmt:message key='console.consoleOverviewContent.updated.txt'/>");
	  }
	  if(endsWith(changes,"deactivated")){
		 descChanges = changes.replace("deactivated","<fmt:message key='console.consoleOverviewContent.deactivated.txt'/>");
	  }
	  if(endsWith(changes,"added models")){
			 descChanges = changes.replace("added models","<fmt:message key='console.consoleOverviewContent.addedModels.txt'/>");
	   }
	  if(endsWith(changes,"models removed")){
			 descChanges = changes.replace("models removed","<fmt:message key='console.consoleOverviewContent.modelsRemoved.txt'/>");
	   }
  	  _consoleNodes[_consoleNodes.length] = new Node("deploy_${fn:trim(dPackage.key)}", "deployment",  "DeployedJob", "${dPackage.decoratedName}", descChanges, "showDeployment,${(ii.count)-1},${dPackage.key}","", "", "");
	</c:forEach>

   _consoleNodes[_consoleNodes.length] = new Node("monitor",      "pipe",     "folder",        "<fmt:message key='console.consoleOverviewContent.monitor.monitor.txt'/>",              "<fmt:message key='console.consoleOverviewContent.monitor.monitor.txt'/>",              "",               "", "", "");
   _consoleNodes[_consoleNodes.length] = new Node("ping",         "monitor",  "query",          "<fmt:message key='console.consoleOverviewContent.monitor.status.txt'/>",               "<fmt:message key='console.consoleOverviewContent.monitor.status.txt'/>",               "pingServers",        "", "", "");

   <c:if test="${isJOSE==true}">
     _consoleNodes[_consoleNodes.length] = new Node("monOse",       "monitor",        "RunningPerson",  "<fmt:message key='console.consoleOverviewContent.monitor.scoringActivity.txt'/>","<fmt:message key='console.consoleOverviewContent.monitor.scoringActivity.txt'/>","", "", "", "");
     <c:forEach var="oseServer" items="${oseServers}" varStatus="ii">
       _consoleNodes[_consoleNodes.length] = new Node("${oseServer.host}",       "monOse",        "RunningPerson",  "${oseServer.host}","<fmt:message key='console.consoleOverviewContent.monitor.scoringActivity.txt'/>","monPerf,JOSE,${esapi:encodeForURL(oseServer.host)}", "", "", "");
     </c:forEach>
   </c:if>
 
   _consoleNodes[_consoleNodes.length] = new Node("inspect",      "pipe",      "folder",       "<fmt:message key='console.consoleOverviewContent.inspect.inspect.txt'/>",              "<fmt:message key='console.consoleOverviewContent.inspect.inspect.txt'/>",              "",               "", "", "");
   _consoleNodes[_consoleNodes.length] = new Node("recordings",   "inspect",   "folder",        "<fmt:message key='console.consoleOverviewContent.inspect.recordings.txt'/>",          "<fmt:message key='console.consoleOverviewContent.inspect.recordings.txt'/>",           "",               "", "", "");
   <c:forEach var="r" begin="1" end="${fn:length(recordings)}">
     <c:set var="recording" value="${recordings[fn:length(recordings)-r]}"/>
      _consoleNodes[_consoleNodes.length] = new Node("recording${r}","recordings","DeployedJob",   "${recording}",        "${recording}",         "playRecording,${recording}","", "", "");
   </c:forEach>

   _consoleNodes[_consoleNodes.length] = new Node("config",       "pipe",      "folder",       "<fmt:message key='console.consoleOverviewContent.configureProperties.configureProperties.txt'/>",            "<fmt:message key='console.consoleOverviewContent.configureProperties.configureProperties.txt'/>",              "",               "", "", "");

   _consoleNodes[_consoleNodes.length] = new Node("consoleprop",      "config",    "edit",          "<fmt:message key='console.consoleOverviewContent.configureProperties.consoleProperties.txt'/>",       "<fmt:message key='console.consoleOverviewContent.configureProperties.setPropertyValues.txt'/>",         "viewProperties,Console",  "", "", "");

   _consoleNodes[_consoleNodes.length]  = new Node("sysmon", 0, "folder","<fmt:message key='fcm.monitor.alertManagementIntegrationPoint.txt'/>", "<fmt:message key='fcm.monitor.alertManagementIntegrationPoint.txt'/>","","","","");
   _consoleNodes[_consoleNodes.length] = new Node(_consoleNodes.length,"sysmon", "edit","<fmt:message key='fcm.monitor.alertManagementECMSubmissionMonitor.txt'/>", "<fmt:message key='fcm.monitor.alertManagementECMSubmissionMonitor.txt'/>","viewMessageFailures,ECMI","", "", "");

   var openFolders = "pipe|deployment|monitor|inspect|config|sysmon";
   if ("recordings" === "${param.openFolder}")
      openFolders += "|recordings";
   <c:forEach var="instance" items="${agsInstances}" varStatus="inst">
	   else if ("${instance.instanceName}jvmLogs" == "${param.openFolder}")
	      openFolders += "|${instance.instanceName}jvmLogs|${instance.instanceName}|logs";
	   else if ("${instance.instanceName}sasLogs" == "${param.openFolder}")
	      openFolders += "|${instance.instanceName}sasLogs|${instance.instanceName}|logs";
   </c:forEach>

   // Cheatsheet: function Tree( name, nodes, start, open, selected, eventHandler, extend, location, enabled, treeImages, nodeImages )
   _consoleTree = new Tree("_consoleTree", _consoleNodes, 0, openFolders, _selectedObject, "show();",
                             false, false, true, "common/images/tree/", "images/rules/" );

   // Show selected node
   show();


//-->
</script>

 </td>
   </tr>
</table>



