<!DOCTYPE html>
<%@ include file="/common/taglibsT3.jsp" %>
<%-- this file uses leading tabs; don't insert leading spaces --%>
<%@ page contentType="text/html; charset=UTF-8" %>


<html>
<head>
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<link rel="stylesheet" href="resources/sas/hc/ui/core/themes/sas_base/fonts.css" type="text/css"/>
	<link rel="stylesheet" href="resources/sas/hc/ui/core/themes/sas_corporate/library.css" type="text/css"/>
	<link rel="stylesheet" href="resources/sas/hc/ui/commons/themes/sas_corporate/library.css" type="text/css"/>
	<link rel="stylesheet" href="resources/sap/m/themes/sas_corporate/library.css" type="text/css"/>
	<style type='text/css'>@import 'common/styles/sasStyles.css';</style>
	<link rel='stylesheet' href='common/styles/cf.css' type='text/css'/>

	<script language='JavaScript' src='common/scripts/jquery.js'></script>
	<script language='JavaScript' src='common/scripts/sasSolutions.js'></script>
	<script language='JavaScript' src='common/scripts/cf.js'></script>
	<script language="JavaScript" src="common/scripts/i18n.js"></script>
	<script language='JavaScript' src='admin/scripts/fulfillment.js'></script>
</head>
<body class="details" onload="i18n.init();removeBusy();onLoadHandler()">

<div id="FFContent" style="margin-left:10px">

<div style="margin:10px 10px 10px 10px" align="center">
	<tiles:insertDefinition name="fcmSystemMessages" flush="true"/>
</div>

<%-- TODO: Reveal Sensitive Data Section - param "mask" is not used by the mid-tier
<div style="width:95%; text-align: left">
	<tiles:insertTemplate template="../common/displayRevealLinkT3.jsp" flush="true">
   		<tiles:putAttribute name="revealFunction" value="revealSensitiveData('${esapi:encodeForJavaScript(type)}', 'false')"/>
	</tiles:insertTemplate>
</div>
--%>

<c:if test="${empty errorMessage}">
<form name="resubmitMessages" action="resubmitMessage.action" method="post">
	<input type="hidden" name="method" value="resubmitMessage"/>
	<input type="hidden" name="messageAction" value=""/>
	<input type="hidden" name="type" id="msgType" value="${esapi:encodeForHTMLAttribute(type)}"/>


	<div style="text-align:left">
		<h4>
			<c:if test="${type=='ECMI'}">
				<fmt:message key="fcm.ECMI.failures.title.fmt.txt">
						<fmt:param value="${fn:length(messageFailures)}"/>
						<fmt:param value="${total}"/>
					</fmt:message>
			</c:if>
		</h4>
	</div>
    <table id="container" class="mainTable" style="width:95%" cellpadding="0" cellspacing="0" border="0">
		<tr>
			<td style="padding:0px;">
      		<div id="fulfillmentFailuresDiv" class="defaultScrollableGrid" onscroll="repositionTHs(this)" >
      		<table  id="fulfillmentFailuresTable" cellpadding="0" cellspacing="0" border="0" style="background:#CFCBB1;width:100%;border-collapse:separate">
		       <thead>
			   <tr class="tableColumnHeaderRow">
				<th class="centeredTableHeader" style="border-top:none;white-space: nowrap"><label title="<fmt:message key="fcm.ff.failures.selectAll.txt" />"><input type="checkbox" onclick="selectAllFF(this.checked)"/></label></th>
				<th class="tableHeader" style="border-top:none;white-space: nowrap" ><fmt:message key="fcm.ff.failures.date.txt" /></th>
				<th class="tableHeader" style="border-top:none;white-space: nowrap" ><fmt:message key="fcm.ff.failures.time.txt" /></th>
				<c:if test="${type=='ECMI'}">
					   <th class="tableHeader" style="border-top:none;white-space: nowrap" ><fmt:message key="fcm.ff.failures.event.txt" /></th>
				</c:if>
				<th class="tableHeader" style="border-top:none;white-space: nowrap" ><fmt:message key="fcm.ff.failures.alert.txt" /></th>
				<th class="tableHeader" style="border-top:none;white-space: nowrap" ><fmt:message key="fcm.ff.failures.type.txt" /></th>
				<th class="tableHeader" style="border-top:none;white-space: nowrap" ><fmt:message key="fcm.ff.failures.entity.txt" /></th>
				<th class="tableHeader" style="border-top:none;white-space: nowrap" ><fmt:message key="fcm.ff.failures.errorCode.txt" /></th>
				<th class="tableHeader" style="border-top:none;border-right:none;white-space: nowrap" ><fmt:message key="fcm.ff.failures.errorDesc.txt" /></th>
			   </tr>
		       </thead>
       			<tbody >

			<c:choose>
				<c:when test="${empty messageFailures}">
					<tr class="dataRow1_tableRow">
					   <td class="imageTableCell lastCol" colspan="10" >
					   <c:if test="${type=='ECMI'}"><fmt:message key="fcm.ECMI.failures.noneExist.txt" /></c:if>
					   </td>
					</tr>
				</c:when>
				<c:otherwise>
					<c:forEach var="mf" items="${messageFailures}" varStatus="status">
						<tr class="dataRow${status.count%2+1}_tableRow">
						   <c:if test="${type=='ECMI'}">
							<td class="imageTableCell" ><input type="checkbox" name="messageIDs" value="${esapi:encodeForHTMLAttribute(mf.ecmID)}"/></td>
							</c:if>
						   <td class="textTableCell" ><esapi:encodeForHTML><fmt:formatDate value="${mf.statusTimestamp}" pattern="${dateFormat}"/></esapi:encodeForHTML></td>
						   <td class="textTableCell" ><esapi:encodeForHTML><fmt:formatDate value="${mf.statusTimestamp}" pattern="${timeFormat}"/></esapi:encodeForHTML></td>
						   <c:if test="${type=='ECMI'}">
							<td class="textTableCell" > ${esapi:encodeForHTML(mf.event)}</td>
						   </c:if>
						   <td class="textTableCell" > ${esapi:encodeForHTML(mf.alertID)}</td>
						   <td class="textTableCell" > ${esapi:encodeForHTML(mf.alertType)}</td>
						   <td class="textTableCell" > <sfmmsk:maskData value="${mf.alertValue}" maskType="ID" /> </td>
						   <td class="textTableCell" > ${esapi:encodeForHTML(mf.error.errorCode)}</td>
						   <td class="textTableCell lastCol"  > ${esapi:encodeForHTML(mf.error.errorDescription)}</td>
						</tr>
					</c:forEach>
				</c:otherwise>
  			</c:choose>
    			</tbody>
    		</table>
    		</div>
    	</td>
    </tr>
  </table>

</form>
</c:if>
</div>

</body>
</html>


