<%@ include file="/common/taglibsT3.jsp" %>
<%@ page contentType="text/html; charset=UTF-8" %>

<script language="JavaScript" src="common/scripts/cf.js"></script>
<script language="JavaScript" src="common/scripts/jquery.fcm.dynaform.js"></script>
<script language="JavaScript" src="rules/scripts/rules.js"></script>
<script language="JavaScript" src="rules/scripts/ruleActions.js"></script>
<script language="JavaScript" src="rules/scripts/dynamicRows.js"></script>
<script language="JavaScript" src="rules/scripts/itemPriorityList.js"></script>
<script language="JavaScript" src="rules/scripts/autoSizing.js"></script>
<SCRIPT language="JavaScript" src="common/scripts/calendar.js"></SCRIPT>
<SCRIPT language="JavaScript" src="rules/scripts/sort.js"></SCRIPT>
<script>
i18n.init();

function deployRules()
{
   setBusyDetail();
   document.deploymentForm.submit();
}

<%-- needed by ruleActions.js --%>
var workflow = 'Current';


var ruleNames = new Array();

<c:forEach var="rule" items="${deployableProductionRules}" >
//-->
</script>
   <pre id="ruleName${rule.id}" style="display:none">${fn:escapeXml(rule.name)}</pre>
<script>
//<!--
   ruleNames[${rule.id}] = document.getElementById("ruleName${rule.id}").innerHTML;
</c:forEach>
//-->

<c:forEach var="rule" items="${deployableTestingRules}" >
//-->
</script>
   <pre id="ruleName${rule.id}" style="display:none">${fn:escapeXml(rule.name)}</pre>
<script>
//<!--
   ruleNames[${rule.id}] = document.getElementById("ruleName${rule.id}").innerHTML;
</c:forEach>
//-->


<c:forEach var="rule" items="${deactivatedRules}" >
//-->
</script>
   <pre id="ruleName${rule.id}" style="display:none">${fn:escapeXml(rule.name)}</pre>
<script>
//<!--
   ruleNames[${rule.id}] = document.getElementById("ruleName${rule.id}").innerHTML;
</c:forEach>
//-->
</script>
<c:choose>
	<c:when test="${empty productName}">
<pre id="tabTitle" style="display:none;">SAS&reg; Fraud Management - <fmt:message key="creditfraud.tab.rules.txt" /> <fmt:message key="rules.ruleDeploymentDetailContent.table.title.deployment.txt" /></pre>
	</c:when>
	<c:otherwise>
<pre id="tabTitle" style="display:none;">${fn:replace(fn:replace(productName,"<sup>", ""), "</sup>", "")} - <fmt:message key="creditfraud.tab.rules.txt" /> <fmt:message key="rules.ruleDeploymentDetailContent.table.title.deployment.txt" /></pre>
	</c:otherwise>
</c:choose>
<script language="JavaScript">
  if (parent.document)
    parent.document.title = document.getElementById("tabTitle").innerHTML;
</script>
<c:if test="${updatedClientSegments!=null}">
<style type="text/css">
/* Popup container */
.popup {
    position: relative;
    display: inline-block;
}

/* The actual popup (appears on top) */
.popup .popuptext {
    visibility:hidden;
    font-size:0.79rem;
	position:absolute;
	z-index:50;
	border-collapse: separate;
	box-shadow: 2px 2px 4px #ccc;
	border-radius:6px;
	border:1px solid #c6cad0;
	padding:8px;
	margin-top:5px;
	margin-left:5px;
	background-image: linear-gradient(to bottom, white, #c3d5e5);
	filter:progid:DXImageTransform.Microsoft.gradient(GradientType=0,startColorstr=white, endColorstr=#c3d5e5);
	text-align:left;

}
.popup li{
font-size:0.79rem;
}
.popup span{
font-size:0.79rem;
}
.popup table{
font-size:0.79rem;
border: 1px solid black;
width: 400px;
}
.popup thead th{
font-size:0.79rem;
border: 1px solid black;
font-weight: bold;
background-color:#ABCAE9;
padding:5px;
}
.popup tbody td{
font-size:0.79rem;
border: 1px solid black;
padding:5px;
}

/* Toggle this class when clicking on the popup container (hide and show the popup) */
.popup .show {
    visibility: visible;
    -webkit-animation: fadeIn 1s;
    animation: fadeIn 1s
}
.copyToClipboard{
	cursor:pointer;
	border-radius: 4px;
    border: none;
    padding: 5px 5px;
    text-align: center;
    text-decoration: none;
    display: inline-block;
    font-size: 0.79rem;
    background-image: linear-gradient(to bottom, white, #c3d5e5);
    filter:progid:DXImageTransform.Microsoft.gradient(GradientType=0,startColorstr=white, endColorstr=#c3d5e5);
}

/* Add animation (fade in the popup) */
 @-webkit-keyframes fadeIn {
    from {opacity: 0;}
    to {opacity: 1;}
}

@keyframes fadeIn {
    from {opacity: 0;}
    to {opacity:1 ;}
}
</style>

<div class="popup" id="popup">
  <span class="popuptext" id="updatedClientSegments">
	  <div style="width:100%;text-align:right;">
	  <a href="#" title="<fmt:message key="creditfraud.common.systemMessages.close.txt"/>" onclick="closePopup();">
		<span class="sapUiBtnIco sapUiBtnIcoL sapUiIcon" style="font-family: sas-icons; text-align:right;" data-sap-ui-icon-content="&#xf10c;"></span>
	  </a>
	  </div>
	  <fmt:message  key="rules.ruleDeploymentDetailContent.sucessfullyDeployedUpdatedSegments.fmt.txt">
	  <fmt:param>${updatedClientSegments}</fmt:param>
	  </fmt:message>
	  <div style="padding:5px;width:100%;text-align:center;">
	  <button type="button" id="copyButton" class="copyToClipboard">
	  <fmt:message key='rules.ruleDeploymentDetailContent.UpdatedSegments.copyToClipboard.txt'/>
	  </button>
	  <div id="msg"></div>
	  </div>

  </span>
</div>
<script>
closePopup();

function closePopup() {
    var popup = document.getElementById("updatedClientSegments");
    popup.classList.toggle("show");
}

document.getElementById("copyButton").addEventListener("click", function() {
    copyToClipboardMsg(document.getElementById("copy"), "msg");
});
function copyToClipboardMsg(elem, msgElem) {
	var succeed = copyToClipboard(elem);
  var msg;
  if (!succeed) {
      msg = $i18n("rules.ruleDeploymentDetailContent.copyNotSupported.txt");
  } else {
      msg = $i18n("rules.ruleDeploymentDetailContent.textCopiedToClipboard.txt");
  }
  if (typeof msgElem === "string") {
      msgElem = document.getElementById(msgElem);
  }
  msgElem.innerHTML = msg;
  setTimeout(function() {
      msgElem.innerHTML = "";
  }, 2000);
}

function copyToClipboard(elem){
	//var element = document.body; // Example, select the "whole" document
	// Change selected area
	var r = document.createRange();
	r.selectNode(elem);
	var s = window.getSelection();
	s.removeAllRanges();
	s.addRange(r);
	var succeed;
	try {
	// copy the selection
	  succeed = document.execCommand("copy");
	} catch(e) {
	  succeed = false;
	}
	return succeed;
}

</script>
</c:if>

<span style='height:0.5em'/>
<div id="rulesTabScrollableDiv" class="rulesTabScrollableClass">

<%-- Error handling code --%>
<tiles:insertDefinition name="ruleSystemMessageLayout" flush="true" />


<table width="98%">
<tr>
<td>
<div title="<esapi:encodeForHTMLAttribute><fmt:message key='rules.ruleDeploymentDetailContent.target.directory.title.fmt.txt'><fmt:param>${deploymentDirectory}</fmt:param></fmt:message></esapi:encodeForHTMLAttribute>">
 <h4>
 <fmt:message key="rules.ruleDeploymentDetailContent.table.title.deployment.txt" />:&nbsp;
 	<c:choose>
	 	<c:when test="${deployableTargetToDisplay == 'Current'}"><fmt:message key="rules.ruleDeploymentDetailContent.target.current.txt" /></c:when>
	 	<c:when test="${isActiveDeployment !=null}"><fmt:message key="rules.ruleListOverviewContent.activeDeployment.txt" /></c:when>
	 	<c:otherwise>${esapi:encodeForHTML(deployableTargetToDisplay)}</c:otherwise>
 	</c:choose>
 <br>
<c:if test="${isActiveDeployment ==null}">
	<fmt:message key="rules.ruleDeploymentDetailContent.table.title.target.txt" />: ${deploymentDirectory}
</c:if>
</h4>
</div>
</td>
<td style="text-align:right;">
<c:if test="${isActiveDeployment!=null}"><div id="msgDiv"></div></c:if>
</td>
</tr>
</table>

<c:if test="${isActiveDeployment==null}">
<form name="deploymentForm" id="deploymentForm" action="performDeployment.action" method="post">
   <input type="hidden" name="method" value="performDeployment">
   <input type="hidden" name="deplyableTargetDisplay" value="${esapi:encodeForHTMLAttribute(deployableTargetToDisplay)}" >
   <input type="hidden" name="multiOrgNodeKey" value="${esapi:encodeForURL(multiOrgNodeKey)}" >
   <table width="98%">
   <tr><td>
   <div>
   <h4><fmt:message key="rules.ruleDeploymentDetailContent.table.title.productionRules.txt" /></h4>
   </div>
   <table class="mainTable" style="width:98%;" id="productionRulesTable" align="left" style="margin:0px 0px 0px 0px;" onselectstart="return false;" border="1" cellspacing="0" cellpadding="0">
     <thead>
         <TR class="tableColumnHeaderRow">
             <TH class="centeredTableHeader" style="width:6%;" nowrap rules:sortAsNum title="<esapi:encodeForHTMLAttribute><fmt:message key='rules.ruleListDetailContent.tableHeader.id.title.txt'/></esapi:encodeForHTMLAttribute>">&nbsp;<fmt:message key="rules.ruleListDetailContent.tableHeader.id.txt"/></TH>
             <TH class="centeredTableHeader" style="width:20%;" nowrap rules:sortAsText>&nbsp;<fmt:message key="rules.ruleListDetailContent.tableHeader.name.txt"/></TH>

         	 <c:choose>
         	 <c:when test="${isTenantInstall==true}">
             <TH class="centeredTableHeader" style="width:12%;" nowrap rules:sortAsText>&nbsp;<fmt:message key="rules.ruleListDetailContent.tableHeader.alertType.txt"/></TH>
         	 </c:when>
         	 <c:otherwise>
             <TH class="centeredTableHeader" style="width:12%;" nowrap rules:sortAsText>&nbsp;<fmt:message key="rules.ruleListDetailContent.tableHeader.type.txt"/></TH>
         	 </c:otherwise>
         	 </c:choose>

             <c:choose>
             <c:when test="${showBU == true}">
             <TH class="centeredTableHeader" style="width:12%;" nowrap rules:sortAsText>&nbsp;<fmt:message key="rules.ruleListDetailContent.tableHeader.businessUnit.txt"/></TH>
             </c:when>
             </c:choose>

             <c:choose>
             <c:when test="${showDescription == true}">
             <TH class="centeredTableHeader" style="width:12%;" nowrap rules:sortAsText>&nbsp;<fmt:message key="rules.ruleListDetailContent.tableHeader.description.txt"/></TH>
             </c:when>
             </c:choose>

             <TH class="centeredTableHeader" style="width:12%;" nowrap rules:sortAsText>&nbsp;<fmt:message key="rules.ruleListDetailContent.tableHeader.multiOrg.txt"/></TH>
             <TH class="centeredTableHeader" nowrap rules:sortAsText>&nbsp;<fmt:message key="rules.ruleListDetailContent.tableHeader.lastUpdatedBy.txt"/></TH>
             <TH class="centeredTableHeader" nowrap rules:sortAsLocalDate>&nbsp;<fmt:message key="rules.ruleListDetailContent.tableHeader.lastUpdatedTime.txt"/></TH>
             <%--<TH class="centeredTableHeader" nowrap rules:sortAsText>&nbsp;State</TH> --%>
             <TH class="centeredTableHeader" nowrap rules:sortAsLocalDate>&nbsp;<fmt:message key="rules.ruleDeploymentDetailContent.tableHeader.lastDeployedTime.txt"/></TH>
         </TR>
     </thead>
     <TBODY id="productionRulesTableBody">
       <c:choose>
          <c:when test="${empty deployableProductionRules}">
          <TR rowspan="2">
             <TD align="right" style="font-size:10pt;" colspan="100%"><center><em><fmt:message key="rules.ruleDeploymentDetailContent.noDeployableRules.txt"/></center></em></TD>
          </TR>
          </c:when>
          <c:otherwise>
            <c:forEach var="rule" items="${deployableProductionRules}" varStatus="status">
             <TR style="cursor:pointer;" id="${rule.id}"  class="dataRow${status.count%2+1}_tableRow"
                  <c:if test='${not empty updtRules && updtRules}'>
                    ondblclick="processMultiSelectRequest('printRules', '', false);"
                  </c:if>
                    onclick='handleRowSelection(${esapi:encodeForJavaScript(rule.id)}, ${esapi:encodeForJavaScript(rule.baseRuleId)}, ruleNames[${esapi:encodeForJavaScript(rule.id)}],"${esapi:encodeForJavaScript(rule.ruleTypeName)}","${esapi:encodeForJavaScript(fn:escapeXml(rule.description))}","${esapi:encodeForJavaScript(rule.operationalTimeLimit)}",${esapi:encodeForJavaScript(rule.version)}, ${esapi:encodeForJavaScript(rule.lockVersion)},${esapi:encodeForJavaScript(rule.isDeployed)}, "${esapi:encodeForJavaScript(rule.workflowState)}", "${esapi:encodeForJavaScript(rule.guidedRule)}", "${esapi:encodeForJavaScript(rule.transactionTypeId)}", "${esapi:encodeForJavaScript(rule.multiOrgNodeId)}","${esapi:encodeForJavaScript(rule.queueId)}","${esapi:encodeForJavaScript(rule.alertTypeCode)}","${esapi:encodeForJavaScript(rule.alertReason)}", "${esapi:encodeForJavaScript(rule.executionOrderPriority)}", this,"rowSelected",event);'>
                <TD class="textTableCell" > &nbsp;${rule.baseRuleId}.${rule.version}</TD>
                <TD class="textTableCell" >&nbsp;
                   ${fn:escapeXml(rule.name)}
                </TD>

             <c:choose>
             <c:when test='${isTenantInstall==true}'>
               <TD class="textTableCell">&nbsp;
                  <c:forEach var="alrt" items="${alertTypeInfo}">
                    <c:if test="${not empty rule.alertTypeCode && rule.alertTypeCode != ' ' && rule.alertTypeCode==alrt.key}">
                        ${alrt.value.desc} (${rule.alertTypeCode})
                    </c:if>
                  </c:forEach>
               </TD>
             </c:when>
             <c:otherwise>
               <TD class="textTableCell">&nbsp;
                  <fmt:message key="rules.ruleType.${rule.ruleTypeName}.txt"/>
                  <c:if test="${not empty rule.alertTypeCode && rule.alertTypeCode != ' '}">(${rule.alertTypeCode})</c:if></TD>
             </c:otherwise>
             </c:choose>

             <c:choose>
             <c:when test="${showBU == true}">
             <TD class="textTableCell" >&nbsp;${rule.businessUnitName}</TD>
             </c:when>
             </c:choose>

             <c:choose>
             <c:when test="${showDescription == true}">
             <c:choose>
                <c:when test="${fn:length(rule.description) < 32 }">
                   <TD class="textTableCell" >&nbsp;${fn:escapeXml(rule.description)}</TD>
                </c:when>
                <c:otherwise>
                   <TD class="textTableCell" >&nbsp;${fn:escapeXml(fn:substring(rule.description, 0, 32))}...</TD>
                </c:otherwise>
             </c:choose>
             </c:when>
             </c:choose>

             <TD class="textTableCell" > &nbsp;
                ${fn:trim(fn:escapeXml(rule.multiOrgLabel))} (${fn:trim(fn:escapeXml(rule.multiOrgNodeKey))})
             </TD>
             <TD class="textTableCell" > &nbsp;${fn:escapeXml(rule.lastUpdateUser)}</TD>
             <TD class="textTableCell" ><span dateFormat="${dateFormat} ${timeFormat}" sortvalue="${rule.lastUpdateTimestampUtcMillis}"><fmt:formatDate value='${rule.lastUpdateTimestamp}' pattern='${dateTimeFormat}' timeZone='${userTimeZone}'/></span>&nbsp;</TD>
             <%--<TD class="textTableCell" > &nbsp;${rule.workflowState}</TD> --%>
             <TD class="textTableCell" ><span dateFormat="${dateFormat} ${timeFormat}" sortvalue="${rule.dateDeployedUtcMillis}"><fmt:formatDate value='${rule.dateDeployed}' pattern='${dateTimeFormat}' timeZone='${userTimeZone}'/></span>&nbsp;</TD>
              </TR>
             </c:forEach>
          </c:otherwise>
       </c:choose>
     </TBODY>
   </table>
   </td></tr>

   <c:if test="${deployTestingRules == true}">
   <tr><td>
   <div>
   <h4><fmt:message key="rules.ruleDeploymentDetailContent.table.title.testingRules.txt"/></h4>
   </div>
   <table class="mainTable" id="testingRulesTable" style="width:98%;" align="left" style="margin:0px 0px 0px 0px;" onselectstart="return false;" border="1" cellspacing="0" cellpadding="0">
       <thead>
         <TR class="tableColumnHeaderRow">
             <TH class="centeredTableHeader" style="width:6%;" nowrap rules:sortAsNum title="<esapi:encodeForHTMLAttribute><fmt:message key='rules.ruleListDetailContent.tableHeader.id.title.txt'/></esapi:encodeForHTMLAttribute>">&nbsp;<fmt:message key="rules.ruleListDetailContent.tableHeader.id.txt"/></TH>
             <TH class="centeredTableHeader" style="width:20%;" nowrap rules:sortAsText>&nbsp;<fmt:message key="rules.ruleListDetailContent.tableHeader.name.txt"/></TH>

         	 <c:choose>
         	 <c:when test="${isTenantInstall==true}">
             <TH class="centeredTableHeader" style="width:12%;" nowrap rules:sortAsText>&nbsp;<fmt:message key="rules.ruleListDetailContent.tableHeader.alertType.txt"/></TH>
         	 </c:when>
         	 <c:otherwise>
             <TH class="centeredTableHeader" style="width:12%;" nowrap rules:sortAsText>&nbsp;<fmt:message key="rules.ruleListDetailContent.tableHeader.type.txt"/></TH>
         	 </c:otherwise>
         	 </c:choose>

             <c:choose>
             <c:when test="${showBU == true}">
             <TH class="centeredTableHeader" style="width:12%;" nowrap rules:sortAsText>&nbsp;<fmt:message key="rules.ruleListDetailContent.tableHeader.businessUnit.txt"/></TH>
             </c:when>
             </c:choose>

             <c:choose>
             <c:when test="${showDescription == true}">
             <TH class="centeredTableHeader" style="width:12%;" nowrap rules:sortAsText>&nbsp;<fmt:message key="rules.ruleListDetailContent.tableHeader.description.txt"/></TH>
             </c:when>
             </c:choose>

             <TH class="centeredTableHeader" style="width:12%;" nowrap rules:sortAsText>&nbsp;<fmt:message key="rules.ruleListDetailContent.tableHeader.multiOrg.txt"/></TH>
             <TH class="centeredTableHeader" nowrap rules:sortAsText>&nbsp;<fmt:message key="rules.ruleListDetailContent.tableHeader.lastUpdatedBy.txt"/></TH>
             <TH class="centeredTableHeader" nowrap rules:sortAsLocalDate>&nbsp;<fmt:message key="rules.ruleListDetailContent.tableHeader.lastUpdatedTime.txt"/></TH>
             <%--<TH class="centeredTableHeader" nowrap rules:sortAsText>&nbsp;State</TH> --%>
             <TH class="centeredTableHeader" nowrap rules:sortAsLocalDate>&nbsp;<fmt:message key="rules.ruleDeploymentDetailContent.tableHeader.lastDeployedTime.txt"/></TH>
         </TR>
       </thead>
       <TBODY id="testingRulesTableBody">
       <c:choose>
          <c:when test="${empty deployableTestingRules}">
          <TR rowspan="2">
             <TD align="right" style="font-size:10pt;" colspan="100%"><center><em><fmt:message key="rules.ruleDeploymentDetailContent.noDeployableRules.txt"/></center></em></TD>
          </TR>
          </c:when>
          <c:otherwise>
            <c:forEach var="rule" items="${deployableTestingRules}" varStatus="status">

             <TR style="cursor:pointer;" id="${rule.id}" class="dataRow${status.count%2+1}_tableRow"
                    ondblclick="processMultiSelectRequest('printRules', '', false);"
                    onclick='handleRowSelection(${esapi:encodeForJavaScript(rule.id)}, ${esapi:encodeForJavaScript(rule.baseRuleId)}, ruleNames[${esapi:encodeForJavaScript(rule.id)}], "${esapi:encodeForJavaScript(fn:escapeXml(rule.description))}","${esapi:encodeForJavaScript(rule.operationalTimeLimit)}",${esapi:encodeForJavaScript(rule.version)}, ${esapi:encodeForJavaScript(rule.lockVersion)},${esapi:encodeForJavaScript(rule.isDeployed)}, "${esapi:encodeForJavaScript(rule.workflowState)}", "${esapi:encodeForJavaScript(rule.guidedRule)}", "${esapi:encodeForJavaScript(rule.transactionTypeId)}", "${esapi:encodeForJavaScript(rule.multiOrgNodeId)}","${esapi:encodeForJavaScript(rule.queueId)}","${esapi:encodeForJavaScript(rule.alertTypeCode)}","${esapi:encodeForJavaScript(rule.alertReason)}", "${esapi:encodeForJavaScript(rule.executionOrderPriority)}", this,"rowSelected",event);'>

                <TD class="textTableCell" > &nbsp;${rule.baseRuleId}.${rule.version}</TD>
                <TD class="textTableCell" >&nbsp;
                   ${fn:escapeXml(rule.name)}
                </TD>

             	<c:choose>
             	<c:when test='${isTenantInstall==true}'>
               	<TD class="textTableCell">&nbsp;
                  	<c:forEach var="alrt" items="${alertTypeInfo}">
                    	<c:if test="${not empty rule.alertTypeCode && rule.alertTypeCode != ' ' && rule.alertTypeCode==alrt.key}">
                        	${alrt.value.desc} (${rule.alertTypeCode})
                    	</c:if>
                  	</c:forEach>
               	</TD>
             	</c:when>
             	<c:otherwise>
               	<TD class="textTableCell">&nbsp;
               	   <fmt:message key="rules.ruleType.${rule.ruleTypeName}.txt"/>
                  	<c:if test="${not empty rule.alertTypeCode && rule.alertTypeCode != ' '}">(${rule.alertTypeCode})</c:if></TD>
             	</c:otherwise>
            	</c:choose>

                <c:choose>
                <c:when test="${showBU == true}">
                <TD class="textTableCell" >&nbsp;${rule.businessUnitName}</TD>
                </c:when>
                </c:choose>

                <c:choose>
                <c:when test="${showDescription == true}">
                <c:choose>
                <c:when test="${fn:length(rule.description) < 32 }">
                   <TD class="textTableCell" >&nbsp;${fn:escapeXml(rule.description)}</TD>
                </c:when>
                <c:otherwise>
                   <TD class="textTableCell" >&nbsp;${fn:escapeXml(fn:substring(rule.description, 0, 32))}...</TD>
                </c:otherwise>
                </c:choose>
                </c:when>
                </c:choose>


             <TD class="textTableCell" > &nbsp;
                ${fn:trim(fn:escapeXml(rule.multiOrgLabel))} (${fn:trim(fn:escapeXml(rule.multiOrgNodeKey))})
             </TD>
             <TD class="textTableCell" > &nbsp;${fn:escapeXml(rule.lastUpdateUser)}</TD>
             <TD class="textTableCell" ><span dateFormat="${dateFormat} ${timeFormat}" sortvalue="${rule.lastUpdateTimestampUtcMillis}"><fmt:formatDate value='${rule.lastUpdateTimestamp}' pattern='${dateTimeFormat}' timeZone='${userTimeZone}'/></span>&nbsp;</TD>
             <%--<TD class="textTableCell" > &nbsp;${rule.workflowState}</TD> --%>
             <TD class="textTableCell" ><span dateFormat="${dateFormat} ${timeFormat}" sortvalue="${rule.dateDeployedUtcMillis}"><fmt:formatDate value='${rule.dateDeployed}' pattern='${dateTimeFormat}' timeZone='${userTimeZone}'/></span>&nbsp;</TD>
              </TR>
             </c:forEach>
          </c:otherwise>
       </c:choose>
       </TBODY>
   </table>

   </td></tr>
   </c:if>

   <c:if test="${deactivatedRules != null &&  !(empty deactivatedRules)}">
   <tr><td>
   <div>
   <h4><fmt:message key="rules.ruleDeploymentDetailContent.table.title.deactivatedRules.txt"/></h4>
   </div>
   <table class="mainTable" id="deactivatedRulesTable" style="width:98%;" align="left" style="margin:0px 0px 0px 0px;" onselectstart="return false;" border="1" cellspacing="0" cellpadding="0">
       <thead>
         <TR class="tableColumnHeaderRow">
             <TH class="centeredTableHeader" style="width:6%;" nowrap rules:sortAsNum title="<esapi:encodeForHTMLAttribute><fmt:message key='rules.ruleListDetailContent.tableHeader.id.title.txt'/></esapi:encodeForHTMLAttribute>">&nbsp;<fmt:message key="rules.ruleListDetailContent.tableHeader.id.txt"/></TH>
             <TH class="centeredTableHeader" style="width:20%;" nowrap rules:sortAsText>&nbsp;<fmt:message key="rules.ruleListDetailContent.tableHeader.name.txt"/></TH>

         	 <c:choose>
         	 <c:when test="${isTenantInstall==true}">
             <TH class="centeredTableHeader" style="width:12%;" nowrap rules:sortAsText>&nbsp;<fmt:message key="rules.ruleListDetailContent.tableHeader.alertType.txt"/></TH>
         	 </c:when>
         	 <c:otherwise>
             <TH class="centeredTableHeader" style="width:12%;" nowrap rules:sortAsText>&nbsp;<fmt:message key="rules.ruleListDetailContent.tableHeader.type.txt"/></TH>
         	 </c:otherwise>
         	 </c:choose>

             <c:choose>
             <c:when test="${showBU == true}">
             <TH class="centeredTableHeader" style="width:12%;" nowrap rules:sortAsText>&nbsp;<fmt:message key="rules.ruleListDetailContent.tableHeader.businessUnit.txt"/></TH>
             </c:when>
             </c:choose>

             <c:choose>
             <c:when test="${showDescription == true}">
             <TH class="centeredTableHeader" style="width:12%;" nowrap rules:sortAsText>&nbsp;<fmt:message key="rules.ruleListDetailContent.tableHeader.description.txt"/></TH>
             </c:when>
             </c:choose>

             <TH class="centeredTableHeader" style="width:12%;" nowrap rules:sortAsText>&nbsp;<fmt:message key="rules.ruleListDetailContent.tableHeader.multiOrg.txt"/></TH>
             <TH class="centeredTableHeader" nowrap rules:sortAsText>&nbsp;<fmt:message key="rules.ruleListDetailContent.tableHeader.lastUpdatedBy.txt"/></TH>
             <TH class="centeredTableHeader" nowrap rules:sortAsLocalDate>&nbsp;<fmt:message key="rules.ruleListDetailContent.tableHeader.lastUpdatedTime.txt"/></TH>
             <TH class="centeredTableHeader" nowrap rules:sortAsLocalDate>&nbsp;<fmt:message key="rules.ruleDeploymentDetailContent.tableHeader.lastDeployedTime.txt"/></TH>
         </TR>
       </thead>
       <TBODY id="deactivatedRulesTableBody">
            <c:forEach var="rule" items="${deactivatedRules}" varStatus="status">
             <TR style="cursor:pointer;" id="${rule.id}" class="dataRow${status.count%2+1}_tableRow"
                    ondblclick="processMultiSelectRequest('printRules', '', false);"
                    onclick='handleRowSelection(${esapi:encodeForJavaScript(rule.id)}, ${esapi:encodeForJavaScript(rule.baseRuleId)}, ruleNames[${esapi:encodeForJavaScript(rule.id)}],"${esapi:encodeForJavaScript(rule.ruleTypeName)}", "${esapi:encodeForJavaScript(fn:escapeXml(rule.description))}","${esapi:encodeForJavaScript(rule.operationalTimeLimit)}",${esapi:encodeForJavaScript(rule.version)}, ${esapi:encodeForJavaScript(rule.lockVersion)},${esapi:encodeForJavaScript(rule.isDeployed)}, "${esapi:encodeForJavaScript(rule.workflowState)}", "${esapi:encodeForJavaScript(rule.guidedRule)}", "${esapi:encodeForJavaScript(rule.transactionTypeId)}", "${esapi:encodeForJavaScript(rule.multiOrgNodeId)}","${esapi:encodeForJavaScript(rule.queueId)}","${esapi:encodeForJavaScript(rule.alertTypeCode)}","${esapi:encodeForJavaScript(rule.alertReason)}", "${esapi:encodeForJavaScript(rule.executionOrderPriority)}", this,"rowSelected",event);'>
                <TD class="textTableCell" > &nbsp;${rule.baseRuleId}.${rule.version}</TD>
                <TD class="textTableCell" >&nbsp;
                   ${fn:escapeXml(rule.name)}
                </TD>

                <c:choose>
             	<c:when test='${isTenantInstall==true}'>
               	<TD class="textTableCell">&nbsp;
                  	<c:forEach var="alrt" items="${alertTypeInfo}">
                    	<c:if test="${not empty rule.alertTypeCode && rule.alertTypeCode != ' ' && rule.alertTypeCode==alrt.key}">
                        	${alrt.value.desc} (${rule.alertTypeCode})
                    	</c:if>
                  	</c:forEach>
               	</TD>
             	</c:when>
             	<c:otherwise>
               	<TD class="textTableCell">&nbsp;
               	   <fmt:message key="rules.ruleType.${rule.ruleTypeName}.txt"/>
                  	<c:if test="${not empty rule.alertTypeCode && rule.alertTypeCode != ' '}">(${rule.alertTypeCode})</c:if></TD>
             	</c:otherwise>
            	</c:choose>

                <c:choose>
                <c:when test="${showBU == true}">
                <TD class="textTableCell" >&nbsp;${rule.businessUnitName}</TD>
                </c:when>
                </c:choose>

                <c:choose>
                <c:when test="${showDescription == true}">
                <c:choose>
                <c:when test="${fn:length(rule.description) < 32 }">
                   <TD class="textTableCell" >&nbsp;${fn:escapeXml(rule.description)}</TD>
                </c:when>
                <c:otherwise>
                   <TD class="textTableCell" >&nbsp;${fn:escapeXml(fn:substring(rule.description, 0, 32))}...</TD>
                </c:otherwise>
                </c:choose>
                </c:when>
                </c:choose>


                <TD class="textTableCell" > &nbsp;
                ${fn:trim(fn:escapeXml(rule.multiOrgLabel))} (${fn:trim(fn:escapeXml(rule.multiOrgNodeKey))})
                </TD>
                <TD class="textTableCell" > &nbsp;${fn:escapeXml(rule.lastUpdateUser)}</TD>
                <TD class="textTableCell" ><span dateFormat="${dateFormat} ${timeFormat}" sortvalue="${rule.lastUpdateTimestampUtcMillis}"><fmt:formatDate value='${rule.lastUpdateTimestamp}' pattern='${dateTimeFormat}' timeZone='${userTimeZone}'/></span>&nbsp;</TD>
                <TD class="textTableCell" ><span dateFormat="${dateFormat} ${timeFormat}" sortvalue="${rule.dateDeployedUtcMillis}"><fmt:formatDate value='${rule.dateDeployed}' pattern='${dateTimeFormat}' timeZone='${userTimeZone}'/></span>&nbsp;</TD>
              </TR>
             </c:forEach>
       </TBODY>
   </table>

   </td></tr>
   </c:if>
</c:if>
<!--------------------------------------------------------ACTIVE DEPLOYMENT---------------------------------------------------------->
   <c:if test="${isActiveDeployment!=null && (isActiveDeployment==true)}">
   <script>
   function getTableUrl(){
  		//var state = sas.fscf.getCookie("cf_lastRulesState"); 
		var url = 'rest/businessunits/${buId}/rules?filter=state==\'Production\' or state==\'Testing\' or state==\'Deactivated\'';		
		// the fields in the next line must be present for all tables as they are the base fields used by print rule
		url += '&fields=id,baseRuleId,revision,name,state,description,ruleTypeName,businessUnitId,alertTypeId,executionOrderType,executionOrderPriority,multiOrgNodeId,multiOrgNode,guidedRule,lastUpdateUser,lastUpdateTimestamp,transactionTypeId';
		url += ',operationalState,metrics';
		return url;
   }

   function getActiveDeployment(confirmationMessage){
     
	   var active=$.ajax({
			async:true,
			cache:false,
			type: "GET",
			url: getTableUrl(),
			dataType: "json",
			contentType:"application/json; charset=utf-8"
		});
	   $.when(active).fail(function(){
		   console.log("Failed to retrieve rules.")
	   });
	   $.when(active).done(function(){
		   
		   var activeRules=JSON.parse(active.responseText);
		   if(confirmationMessage){
			   var msg='';
			   msg+='<div class="inlineMessage inlineMessageSuccess">';
			   msg+='<div class="inlineMessageIcon"><span class="sapUiBtnIco sapUiBtnIcoL sapUiIcon" style="font-family: sas-icons;" data-sap-ui-icon-content="&#xf160;"></span></div>';
			   msg+='<div class="inlineMessageMessage">'+confirmationMessage+'</div>';
			   msg+='<div class="inlineMessageClose">';
			   msg+='<a href="#" title="<fmt:message key="creditfraud.common.systemMessages.close.txt"/>" onclick="this.parentNode.parentNode.style.display=\'none\';">';
			   msg+='<span class="sapUiBtnIco sapUiBtnIcoL sapUiIcon" style="font-family: sas-icons;" data-sap-ui-icon-content="&#xf10c;"></span>';
			   msg+='</a>';
			   msg+='</div>';
			   msg+='</div>';
			   $("#msgDiv").html("");
			   $("#msgDiv").append(msg);
			   $(document).click(function() {
				    $("#msgDiv").html("");
			   });
	   	   }
		   $("#enableRulesTableBody").html("");
		   var tr='';
		   j=0;
		   for(i=0;i<activeRules.items.length;i++){
			   
			   if(!(activeRules.items[i].operationalState =="-2" && activeRules.items[i].state =="Deactivated")){//don't display deactivated rules not present in ode	
				   tr+='<TR style="cursor:pointer;" id=\"'+activeRules.items[i].id+'\" ';
				   var version="";
				   if(activeRules.items[i].metrics){
					   version=activeRules.items[i].metrics.version;
				   }
				   tr+='onclick="handleRowSelection('+activeRules.items[i].id+', '+activeRules.items[i].baseRuleId+',\''+activeRules.items[i].ruleTypeName+'\',ruleNames['+activeRules.items[i].id+'], \'\',\'\',\''+activeRules.items[i].revision+'\', \''+version+'\',\''+activeRules.items[i].operationalState+'\', \'Production\', \''+activeRules.items[i].guidedRule+'\', \''+activeRules.items[i].transactionTypeId+'\', '+activeRules.items[i].multiOrgNodeId+',\'\',\''+activeRules.items[i].alertTypeId+'\',\'\', \''+activeRules.items[i].executionOrderPriority+'\', this,\'rowSelected\',event);"';
				   if(j % 2 == 0)tr+=' class="dataRow1_tableRow">';
				   else tr+=' class="dataRow2_tableRow">';
				   tr+='<td class="textTableCell" >&nbsp;'+activeRules.items[i].baseRuleId+'.'+activeRules.items[i].revision+'</td>';
				   tr+='<td class="textTableCell" >&nbsp;'+activeRules.items[i].name+'</td>';
				   tr+='<td class="textTableCell" >&nbsp;'+activeRules.items[i].multiOrgNode+'</td>';
				   tr+='<td class="textTableCell" >&nbsp;'+activeRules.items[i].state+'</td>';
				   tr+='<td class="textTableCell" style="text-align:center;" >';
				   if(activeRules.items[i].operationalState=='0')
				   	tr+='<img src="images/rules/greendot.gif"/></td>';
				   else if(activeRules.items[i].operationalState=='1')
					tr+='<img src="images/rules/reddot.gif"/></td>';
				   else if ((activeRules.items[i].operationalState=='-1' || activeRules.items[i].operationalState=='-2')){
					   if(activeRules.items[i].configuredOperationalState=='0'){
	 			   			tr+='<div style="opacity: 0.4;filter: alpha(opacity=40);"><img src="images/rules/greendot.gif" /></div></td>';//light green
	 			   	 	}
					   if(activeRules.items[i].configuredOperationalState=='1'){
		 			   		tr+='<div style="opacity: 0.4;filter: alpha(opacity=40);"><img src="images/rules/reddot.gif" style="opacity: 0.4;filter: alpha(opacity=40);"/></div></td>';//light red 			   	
					   }
				   }
				   if(activeRules.items[i].metrics){
					   tr+='<td class="textTableCell" style="border:none;text-align:right;width:3%;">'+activeRules.items[i].metrics.overall.ardFiredTxnCount.value+'</td><td class="textTableCell" style="border:none;text-align:center;width:1%;">:</td><td class="textTableCell" style="text-align:right;width:3%;">'+activeRules.items[i].metrics.overall.ardTxnPopulation.value+'</td>';
					   tr+='<td class="textTableCell"><div>';
					   tr+=getSpark(activeRules.items[i].metrics.historical.ardFiredTxnCount.values);
					   tr+='</div></td>';
					   tr+='<td class="textTableCell" style="border:none;text-align:right;width:3%;">'+activeRules.items[i].metrics.overall.alrtFiredTxnCount.value+'</td><td class="textTableCell" style="border:none;text-align:center;width:1%;">:</td><td class="textTableCell" style="text-align:right;width:3%;">'+activeRules.items[i].metrics.overall.alrtTxnPopulation.value+'</td>';
					   tr+='<td class="textTableCell"><div>';
					   tr+=getSpark(activeRules.items[i].metrics.historical.alrtFiredTxnCount.values);
					   tr+='</div></td>';
					   tr+='<td class="textTableCell" style="text-align:center">';
					   if(activeRules.items[i].metrics.overall.execTimeExceededCount.value==1){
						   <c:set var="alt">
						   	<fmt:message key="rules.rulesPage.rules.runTime.exceeded.txt"/>
						   </c:set>
						   	tr+='<img src="admin/images/WarningStatus.gif" alt="${alt}"/></TD>';
					   }
					   else if(activeRules.items[i].metrics.overall.execTimeExceededCount.value>=2){
						   <c:set var="alt">
							   <fmt:message key="rules.rulesPage.rules.runTime.exceeded.nTimes.fmt.txt">
							   	<fmt:param>2 or more</fmt:param>
							   </fmt:message>
							</c:set>
							   tr+='<img src="admin/images/caution.gif" alt="${alt}"/></TD>';
					   }else{
						   tr+='&nbsp;</td>';
					   }
				   }else{
					   tr+='<td class="textTableCell" style="border:none;text-align:right;width:3%;">&nbsp;</td><td class="textTableCell" style="border:none;text-align:center;width:1%;"></td><td class="textTableCell" style="text-align:right;width:3%;">&nbsp;</td><td class="textTableCell"></td>';
					   tr+='<td class="textTableCell" style="border:none;text-align:right;width:3%;">&nbsp;</td><td class="textTableCell" style="border:none;text-align:center;width:1%;"></td><td class="textTableCell" style="text-align:right;width:3%;">&nbsp;</td><td class="textTableCell"></td>';
					   tr+='<td class="textTableCell" style="text-align:center">&nbsp;</td>';
				   }
				   tr+='</tr>';
				   j++;
			   }
		   }		   
		   $("#enableRulesTableBody").append(tr); 
		   //attachEventHandlerToTableCells(['enableRulesTable']);
		   
	   });
   }
   getActiveDeployment();
   
  
   </script>
   <table width="98%">   
   <tr><td>
   <table class="mainTable" id="enableRulesTable" style="width:98%;" align="left" style="margin:0px 0px 0px 0px;" onselectstart="return false;" border="1" cellspacing="0" cellpadding="0">
       <thead>
         <TR class="tableColumnHeaderRow">
             
             <TH class="centeredTableHeader"  style="width:6%;" nowrap rules:sortAsNum title="<esapi:encodeForHTMLAttribute><fmt:message key='rules.ruleListDetailContent.tableHeader.id.title.txt'/></esapi:encodeForHTMLAttribute>">&nbsp;<fmt:message key="rules.ruleListDetailContent.tableHeader.id.txt"/></TH>
             <TH class="centeredTableHeader"  style="width:15%;" nowrap rules:sortAsText>&nbsp;<fmt:message key="rules.ruleListDetailContent.tableHeader.name.txt"/></TH>
             <TH class="centeredTableHeader"  style="width:12%;" nowrap rules:sortAsNum>&nbsp;<fmt:message key="rules.ruleListDetailContent.tableHeader.transactionScope.txt"/></TH>
             <TH class="centeredTableHeader"  style="width:6%;" nowrap rules:sortAsNum title="<esapi:encodeForHTMLAttribute><fmt:message key='rules.ruleListDetailContent.tableHeader.state.txt'/></esapi:encodeForHTMLAttribute>">&nbsp;<fmt:message key="rules.ruleListDetailContent.tableHeader.state.txt"/></TH>
             <TH class="centeredTableHeader"  style="width:6%;" nowrap rules:sortAsNum><fmt:message key="rules.rule.status.txt"/></TH>
             <TH class="centeredTableHeader"  style="width:10%;" nowrap rules:sortAsNum  colspan="4">&nbsp;<fmt:message key="rules.rule.customerImpactRatio.txt"/> </TH>
             <TH class="centeredTableHeader"  style="width:10%;" nowrap rules:sortAsNum  colspan="4">&nbsp;<fmt:message key="rules.rule.analystImpactRatio.txt"/></TH>
             <TH class="centeredTableHeader"  style="width:6%;" nowrap rules:sortAsNum><fmt:message key="rules.rule.executionTime.txt"/></TH>
         </TR>
       </thead>
       <TBODY id="enableRulesTableBody">
       </TBODY>
       </table>
	</td></tr>
	</table>


   </c:if>
<!--------------------------------------------------------ACTIVE DEPLOYMENT---------------------------------------------------------->
<!----------------------------------------------------------- MODELS-------------------------------------------------------------- -->
   <!-- Deployable -->
   <c:if test="${deployableModels !=null && !(empty deployableModels)}">
   <tr><td>
   <div>
   <h4><fmt:message key="fcm.models.modelDeploymentDetailContent.table.title.deployableModels.txt"/></h4>
   </div>
   <table class="mainTable" id="deployableModelsTable" style="width:98%;" align="left" style="margin:0px 0px 0px 0px;" border="1" cellspacing="0" cellpadding="0">
       <thead>
         <TR class="tableColumnHeaderRow">
             <TH class="centeredTableHeader" style="width:6%;" nowrap rules:sortAsNum >&nbsp;<fmt:message key="rules.ruleListDetailContent.tableHeader.id.txt"/></TH>
             <TH class="centeredTableHeader" style="width:20%;" nowrap rules:sortAsText>&nbsp;<fmt:message key="rules.ruleListDetailContent.tableHeader.name.txt"/></TH>
             <TH class="centeredTableHeader" style="width:12%;" nowrap rules:sortAsText>&nbsp;<fmt:message key="fcm.models.overview.model.txt"/></TH>
             <TH class="centeredTableHeader" style="width:12%;" nowrap rules:sortAsText>&nbsp;<fmt:message key="fcm.models.scoreField.txt"/></TH>
             <TH class="centeredTableHeader" style="width:12%;" nowrap rules:sortAsText>&nbsp;<fmt:message key="rules.ruleListDetailContent.tableHeader.multiOrg.txt"/></TH>
             <TH class="centeredTableHeader" nowrap rules:sortAsText>&nbsp;<fmt:message key="rules.ruleListDetailContent.tableHeader.lastUpdatedBy.txt"/></TH>
             <TH class="centeredTableHeader" nowrap rules:sortAsLocalDate>&nbsp;<fmt:message key="rules.ruleListDetailContent.tableHeader.lastUpdatedTime.txt"/></TH>
             <TH class="centeredTableHeader" nowrap rules:sortAsLocalDate>&nbsp;<fmt:message key="rules.ruleDeploymentDetailContent.tableHeader.lastDeployedTime.txt"/></TH>
         </TR>
       </thead>
       <TBODY id="deployableModelsTableBody">
            <c:forEach var="deployableModel" items="${deployableModels}" varStatus="status">
             <TR id="${deployableModel.id}" class="dataRow${status.count%2+1}_tableRow">
                <TD class="textTableCell" > &nbsp;${deployableModel.id}</TD>
                <TD class="textTableCell" >&nbsp;${fn:escapeXml(deployableModel.label)}</TD>
                <TD class="textTableCell" >&nbsp;${fn:escapeXml(deployableModel.model)}</TD>
                <TD class="textTableCell" > &nbsp;
                <c:forEach var="scoreField" items="${scoreFields}">
                	<c:forEach var="resultFieldId" items="${deployableModel.resultFieldIds}" varStatus="cnt">
	                    <c:if test="${resultFieldId==scoreField.FIELD_ID}"> 
		      			<c:if test="${cnt.count>1}">, </c:if>${fn:escapeXml(scoreField.FIELD_NAME)}
		      			</c:if>
		      		</c:forEach>
	      		</c:forEach>
                </TD>
                <TD class="textTableCell" > &nbsp;
                <c:forEach var="modelMO" items="${deployableModel.multiOrgNodes}" varStatus="status">
                		${fn:escapeXml(modelMO.label)}
				</c:forEach>
                </TD>
             	<TD class="textTableCell" > &nbsp;${fn:escapeXml(deployableModel.lastUpdateUser)}</TD>
             	<TD class="textTableCell" ><span dateFormat="${dateFormat} ${timeFormat}" sortvalue="${deployableModel.lastUpdateTimestamp}"><fmt:formatDate value='${deployableModel.lastUpdateTimestamp}' pattern='${dateTimeFormat}' timeZone='${userTimeZone}'/></span>&nbsp;</TD>
             	<TD class="textTableCell" ><span dateFormat="${dateFormat} ${timeFormat}" sortvalue="${deployableModel.lastDeployedTimestamp}"><fmt:formatDate value='${deployableModel.lastDeployedTimestamp}' pattern='${dateTimeFormat}' timeZone='${userTimeZone}'/></span>&nbsp;</TD>
              </TR>
             </c:forEach>
       </TBODY>
   </table>
   </td></tr>
   </c:if>
   <!-- Removed -->
   <c:if test="${removedModels !=null && !(empty removedModels)}">
   <tr><td>
   <div>
   <h4><fmt:message key="fcm.models.modelDeploymentDetailContent.table.title.removedModels.txt"/></h4>
   </div>
   <table class="mainTable" id="removedModelsTable" style="width:98%;" align="left" style="margin:0px 0px 0px 0px;" border="1" cellspacing="0" cellpadding="0">
       <thead>
         <TR class="tableColumnHeaderRow">
             <TH class="centeredTableHeader" style="width:6%;"  nowrap rules:sortAsNum>&nbsp;<fmt:message key="rules.ruleListDetailContent.tableHeader.id.txt"/></TH>
             <TH class="centeredTableHeader" style="width:20%;" nowrap rules:sortAsText>&nbsp;<fmt:message key="rules.ruleListDetailContent.tableHeader.name.txt"/></TH>
             <TH class="centeredTableHeader" style="width:12%;" nowrap rules:sortAsText>&nbsp;<fmt:message key="fcm.models.overview.model.txt"/></TH>
             <TH class="centeredTableHeader" style="width:12%;" nowrap rules:sortAsText>&nbsp;<fmt:message key="fcm.models.scoreField.txt"/></TH>
             <TH class="centeredTableHeader" style="width:12%;" nowrap rules:sortAsText>&nbsp;<fmt:message key="rules.ruleListDetailContent.tableHeader.multiOrg.txt"/></TH>
             <TH class="centeredTableHeader" nowrap rules:sortAsText>&nbsp;<fmt:message key="rules.ruleListDetailContent.tableHeader.lastUpdatedBy.txt"/></TH>
             <TH class="centeredTableHeader" nowrap rules:sortAsLocalDate>&nbsp;<fmt:message key="rules.ruleListDetailContent.tableHeader.lastUpdatedTime.txt"/></TH>
             <TH class="centeredTableHeader" nowrap rules:sortAsLocalDate>&nbsp;<fmt:message key="rules.ruleDeploymentDetailContent.tableHeader.lastDeployedTime.txt"/></TH>
         </TR>
       </thead>
       <TBODY id="removedModelsTableBody">
            <c:forEach var="removedModel" items="${removedModels}" varStatus="status">
             <TR style="cursor:pointer;" id="${removedModel.id}" class="dataRow${status.count%2+1}_tableRow">
                <TD class="textTableCell" > &nbsp;${removedModel.id}</TD>
                <TD class="textTableCell" >&nbsp;${fn:escapeXml(removedModel.label)}</TD>
                <TD class="textTableCell" >&nbsp;${fn:escapeXml(removedModel.model)}</TD>
                <TD class="textTableCell" > &nbsp;
                <c:forEach var="scoreField" items="${scoreFields}">
                	<c:forEach var="resultFieldId" items="${removedModel.resultFieldIds}" varStatus="cnt">
	                    <c:if test="${resultFieldId==scoreField.FIELD_ID}"> 
		      			<c:if test="${cnt.count>1}">, </c:if>${fn:escapeXml(scoreField.FIELD_NAME)}
		      			</c:if>
		      		</c:forEach>
	      		</c:forEach>
                </TD>
                <TD class="textTableCell" > &nbsp;
                <c:forEach var="modelMO" items="${removedModel.multiOrgNodes}" varStatus="status">
                		${fn:escapeXml(modelMO.label)}
				</c:forEach>
                </TD>
             	<TD class="textTableCell" > &nbsp;${fn:escapeXml(removedModel.lastUpdateUser)}</TD>
             	<TD class="textTableCell" ><span dateFormat="${dateFormat} ${timeFormat}" sortvalue="${removedModel.lastUpdateTimestamp}"><fmt:formatDate value='${removedModel.lastUpdateTimestamp}' pattern='${dateTimeFormat}' timeZone='${userTimeZone}'/></span>&nbsp;</TD>
             	<TD class="textTableCell" ><span dateFormat="${dateFormat} ${timeFormat}" sortvalue="${removedModel.lastDeployedTimestamp}"><fmt:formatDate value='${removedModel.lastDeployedTimestamp}' pattern='${dateTimeFormat}' timeZone='${userTimeZone}'/></span>&nbsp;</TD>
              </TR>
             </c:forEach>
       </TBODY>
   </table>
   </td></tr>
   </c:if>

<!----------------------------------------------------------- MODELS-------------------------------------------------------------- -->

</table>

</div>

<script>
   attachEventHandlerToTableCells(['productionRulesTable', 'testingRulesTable', 'deactivatedRulesTable']);
 </script>
 <!-- TBD David's scripts to be refactored -->
<script>
//<!--

function myscrollingTableSizeToFit(name, objList)
{
   divObj = document.getElementById(name+"Div");
   tblObj = document.getElementById(name+"Table");

   if(tblObj && divObj)
   {
      var screenWidth = getClientWidth();
      var screenHeight = getClientHeight();

      var bot = 0;
      if(objList)
      {
         for(var i = 0; i < objList.length; i++)
         {
            if(document.getElementById(objList[i]))
               bot += document.getElementById(objList[i]).offsetHeight;
         }

      }

      var top = getTopPosition(tblObj);


      var maxHeight = ((screenHeight-top-bot) *0.80 );



      divObj.style.height = (maxHeight < tblObj.offsetHeight ? maxHeight : tblObj.offsetHeight)
   }

}
myscrollingTableSizeToFit('rule',['buttonTable']);



function myDeployRules()
{
        var sasSpinner = "common/images/spinner.gif";
        formElem = document.main;

        //setBusyDetail();

        // Display the spinner while we wait

        mysetErrorWarningDisplay( document, 'sasLog', 'SAS Log',
        '<image src="' + sasSpinner + '" border="0" height="15" width="15"/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' );


        mysetErrorWarningDisplay(document, 'sasLog',  'SAS Log',
         '<font color=blue><b>'+' Results&nbsp;&nbsp;&nbsp;')

        formElem.submit();
}

function mysetErrorWarningDisplay( doc, destinationTab, destinationLabel, html )
{

    var statusArea = doc.getElementById( "errorWarningDisplay" );
    if (statusArea)
    {
        statusArea.innerHTML = "<span onclick=''>" +  html + "</span>";
        statusArea.title = "Show " + destinationLabel;
        statusArea.style.cursor = "pointer";
    }

}

<c:if test="${not empty confirmationMessage && empty errorMessage}">

var selectedNode = parent.frames[ "overview" ]._consoleTree.getSelectedNodes()[0];

if (selectedNode!=null){
	var title=selectedNode.getTitle();
	title= title.replace(/\*$/, '');
	selectedNode.setTitle(title);
	selectedNode.setTip("no changes");
}

</c:if>
//-->
</script>

</form>



