// (c) 2014, SAS Institute Inc.

sap.ui.define([
    "jquery.sap.global",
    "sap/ui/core/Core",
    "sap/ui/core/library",
    "sap/ui/unified/library", // For cell context menus, TODO see if we still use these in SAS version.
    "sap/ui/commons/library",
    "sas/hc/ui/core/Core"
], function(jQuery, Core) {

    "use strict";

    /**
    * @namespace
    * @name sas.hc.ui.table
    * @public
    */

    // delegate further initialization of this library to the Core
    sap.ui.getCore().initLibrary({
        name : "sas.hc.ui.table",
        dependencies : [
            "sap.ui.core",
            "sap.ui.commons",
            "sas.hc.m",
            "sas.hc.typescript"
        ],
        noLibraryCSS: false,
        types : [
            "sas.hc.ui.table.SelectionBehavior",
            "sas.hc.ui.table.SelectionMode",
            "sas.hc.ui.table.SortOrder",
            "sas.hc.ui.table.VisibleRowCountMode",
            "sas.hc.ui.table.FilteredSelectionBehavior",
            "sas.hc.ui.table.SharedDomRef"
        ],
        interfaces : [],
        controls : [
            "sas.hc.ui.table.CheckBox",
            "sas.hc.ui.table.Column",
            "sas.hc.ui.table.ColumnBase",
            "sas.hc.ui.table.ColumnGroup",
            "sas.hc.ui.table.ColumnDragBar",
            "sas.hc.ui.table.ColumnDragBarHandleIcon",
            "sas.hc.ui.table.ColumnMenu",
            "sas.hc.ui.table.DraggableRowDelegate",
            "sas.hc.ui.table.DroppableTableDelegate",
            "sas.hc.ui.table.ItemNavigation",
            "sas.hc.ui.table.Row",
            "sas.hc.ui.table.SelectAllControl",
            "sas.hc.ui.table.Table",
            "sas.hc.ui.table.TableAccExtension",
            "sas.hc.ui.table.TableAccRenderExtension",
            "sas.hc.ui.table.TableExtension",
            "sas.hc.ui.table.TableGrouping",
            "sas.hc.ui.table.TableKeyboardDelegate",
            "sas.hc.ui.table.TableKeyboardExtension",
            "sas.hc.ui.table.TableOptionsColumnsDialog",
            "sas.hc.ui.table.TableOptionsMenuButton",
            "sas.hc.ui.table.TablePointerExtension",
            "sas.hc.ui.table.TableUtils",
            "sas.hc.ui.table.TreeSelectionModel",
            "sas.hc.ui.table.TreeTable",
            "sas.hc.ui.table.TriStateSelectAll",
            "sas.hc.ui.table.WideRow",
            "sas.hc.ui.table.WideTable",
            "sas.hc.ui.table.WideTreeTable",
            "sas.hc.ui.table.multiDimensional.MultiDimensionalTable"
        ],
        elements : [],
        extensions: {
            flChangeHandlers: {
                "sas.hc.ui.table.Column": {
                    "propertyChange" : "default"
                },
                "sas.hc.ui.table.Table" : {
                    "moveElements": "default"
                },
                "sas.hc.ui.table.AnalyticalTable" : {
                    "moveElements": "default"
                }
            }
        },
        version : "904001.11.16.20251118090100_f0htmcm94p"
    });

    /**
     * Table-like controls, mainly for desktop scenarios.
     *
     * @namespace
     * @alias sas.hc.ui.table
     * @author SAP SE
     * @version 904001.11.16.20251118090100_f0htmcm94p
     * @public
     */
    var tableLib = sas.hc.ui.table;

    /**
     * Selection behavior of the table
     *
     * @version 904001.11.16.20251118090100_f0htmcm94p
     * @enum {string}
     * @public
     * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
     */
    tableLib.SelectionBehavior = {

        /**
         * Rows can be selected on the complete row.
         * @public
         */
        Row : "Row",

        /**
         * Rows can only be selected on the row selector.
         * @public
         */
        RowSelector : "RowSelector",

        /**
         * Rows can only be selected on the row (and the selector is hidden).
         * @public
         */
        RowOnly : "RowOnly"

    };


    /**
     * Selection mode of the table
     *
     * @version 904001.11.16.20251118090100_f0htmcm94p
     * @enum {string}
     * @public
     * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
     */
    tableLib.SelectionMode = {

        /**
         * Select multiple rows at a time (toggle behavior).
         * @public
         */
        MultiToggle : "MultiToggle",

        /**
         * Select one row at a time.
         * @public
         */
        Single : "Single",

        /**
         * No rows can be selected.
         * @public
         */
        None : "None",

        /**
         * For use only in TreeTable or WideTreeTable. Enables selecting a parent to select children. Parents can be marked as partially selected.
         * @public
         */
        ParentChild: "ParentChild"

    };

    /**
     * Behavior of the table's selection state when filtering is applied to the table's view.
     * The 'rememberSelections' property must be set to 'true' for this behavior to be evident.
     * Only useful when also using the 'selectionIdProperty'.
     *
     * @type {{RetainAll: string, RetainMatching: string}}
     * @enum {string}
     * @public
     */
    tableLib.FilteredSelectionBehavior = {
        /**
         * Retain all items previously selected, including those filtered out of view.
         * @public
         */
        RetainAll : "RetainAll",

        /**
         * Retain the selection state of only the items matching the filtered view.
         * @public
         */
        RetainMatching : "RetainMatching"
    };


    /**
     * Sort order of a column
     *
     * @version 904001.11.16.20251118090100_f0htmcm94p
     * @enum {string}
     * @public
     * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
     */
    tableLib.SortOrder = {

        /**
         * Sort Order: ascending.
         * @public
         */
        Ascending : "Ascending",

        /**
         * Sort Order: descending.
         * @public
         */
        Descending : "Descending"

    };


    /**
     * VisibleRowCountMode of the table
     *
     * @version 904001.11.16.20251118090100_f0htmcm94p
     * @enum {string}
     * @public
     * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
     */
    tableLib.VisibleRowCountMode = {

        /**
         * The table always has as many rows as defined in the visibleRowCount property.
         * @public
         */
        Fixed : "Fixed",

        /**
         * The table automatically fills the height of the surrounding container.
         * The visibleRowCount property is automatically changed accordingly.
         * All rows need the same height, otherwise the auto mode doesn't always work as expected.
         * The height of all siblings within the same layout container of the table will be subtracted from the available height.
         * For performance reasons, it is recommended to add no siblings in the table's parent container.
         * @public
         */
        Auto : "Auto"

    };

    /**
     * Shared DOM Reference IDs of the table.
     *
     * Contains IDs of shared DOM references, which should be accessible to inheriting controls via getDomRef() function.
     *
     * @version 904001.11.16.20251118090100_f0htmcm94p
     * @enum {string}
     * @public
     */
    tableLib.SharedDomRef = {

        /**
         * The element id of the Horizontal Scroll Bar of the sas.hc.ui.table.Table.
         * @public
         */
        HorizontalScrollBar : "hsb",

        /**
         * The element id of the Vertical Scroll Bar of the sas.hc.ui.table.Table.
         * @public
         */
        VerticalScrollBar : "vsb"
    };

    /**
     * Details about the group event to distinguish between different actions associated with grouping
     * @enum {string}
     * @public
     * @type {{group: string, ungroup: string, ungroupAll: string, moveUp: string, moveDown: string, showGroupedColumn: string, hideGroupedColumn: string}}
     */
    tableLib.GroupEventType = {
        /**
         * Group Column
         * @public
         */
        group: "group",
        /**
         * Ungroup Column
         * @public
         */
        ungroup: "ungroup",
        /**
         * Ungroup All Columns
         * @public
         */
        ungroupAll: "ungroupAll",
        /**
         * Change the group order of the columns. Move column one position up in the group sequence
         * @public
         */
        moveUp: "moveUp",
        /**
         * Change the group order of the columns. Move column one position down in the group sequence
         * @public
         */
        moveDown: "moveDown",
        /**
         * Show grouped column also as a column, not just as group header
         * @public
         */
        showGroupedColumn: "showGroupedColumn",
        /**
         * Show grouped column only as group header
         * @public
         */
        hideGroupedColumn: "hideGroupedColumn"
    };

    // TODO Determine if this is used anywhere.
    //factory for table to create labels an textviews to be overwritten by commons and mobile library
    if (!tableLib.TableHelper) {
        tableLib.TableHelper = {
            createLabel: function(mConfig){
                var Label = sap.ui.requireSync("sas/hc/m/Label");
                return new Label(mConfig);
                // throw new Error("no Label control available!");
            },
            createTextView: function(mConfig){
                var Label = sap.ui.requireSync("sas/hc/m/Label");
                return new Label(mConfig);
                // throw new Error("no TextView control available!");
            },
            createTextField: function(mConfig){
                var Input = sap.ui.requireSync("sas/hc/m/Input");
                return new Input(mConfig);
                // throw new Error("no TextField control available!");
            },
            createImage: function(mConfig){
                var Image = sap.ui.requireSync("sas/hc/m/Image");
                return new Image(mConfig);
                // throw new Error("no Image control available!");
            },
            addTableClass: function() {
                return "sapUiTableM";
            },
            bFinal: false /* if true, the helper must not be overwritten by an other library */
        };
    }

    // Table package logger
    var logger = sas.log.getLogger("sas.hc.ui.table");
    var Level = sas.log.Level;

    tableLib._getLogger = function(sClass) {
        return {
            getLevel: function() {
                return logger.getLevel();
            },

            setLevel: function() {
                logger.setLevel.apply(logger, arguments);
                return this;
            },

            isLoggable: function() {
                return logger.isLoggable.apply(logger, arguments);
            },

            fatal: function(sMsg, details) {
                if (logger.isLoggable(Level.FATAL)) {
                    logger.fatal(sClass + ": " + sMsg, details);
                }
                return this;
            },

            error: function(sMsg, details) {
                if (logger.isLoggable(Level.ERROR)) {
                    logger.error(sClass + ": " + sMsg, details);
                }
                return this;
            },

            warning: function(sMsg, details) {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.warning(sClass + ": " + sMsg, details);
                }
                return this;
            },

            info: function(sMsg, details) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info(sClass + ": " + sMsg, details);
                }
                return this;
            },

            debug: function(sMsg, details) {
                if (logger.isLoggable(Level.DEBUG)) {
                    logger.debug(sClass + ": " + sMsg, details);
                }
                return this;
            },

            trace: function(sMsg, details) {
                if (logger.isLoggable(Level.TRACE)) {
                    logger.trace(sClass + ": " + sMsg, details);
                }
                return this;
            }
        };
    };



    return tableLib;

});

