// @sasPreCore
sap.ui.define(['jquery.sap.global','./util/ComponentServiceClassResolver','./util/ServicesUtil', 'sap/ui/core/Core','sas/hc/ui/core/Core'],
    function(jQuery,ComponentServiceClassResolver,ServicesUtil) {
        var keepAliveService=undefined;
        var util={
            ComponentServiceClassResolver:ComponentServiceClassResolver,
            ServicesUtil:ServicesUtil,
            APP_READY: "appReady",
            BEFORE_SIGN_OUT: 'before_sign_out',

            // I think isUrlCrossDomain should live in sas.hc.ui.core.util.Url.js instead of
            // of here.   For now I just put a function there as well which references back to this one.
            // This util.js seems like it could become a real dumping ground of unrelated things.
            isUrlCrossDomain:function(sUrl){
                if(sUrl === undefined ) {
                    return false;
                }
                var oUri = URI.parse(sUrl);
                if(!oUri.protocol){
                    return false; // relative url ?.
                }else{
                    // check if commons is externalized?
                    var hcExtLoc = sas && sas.config && sas.config.get('commonsUrl');
                    // externalization of html commons is not possible without supporting CORS.
                    if(typeof hcExtLoc === 'string' && hcExtLoc !== ''){
                        // accessing commons resource from url.
                        var commonsCntxUrl = sas.config.get('commonsContextUrl');
                        if(typeof commonsCntxUrl === 'string' && commonsCntxUrl !== '' && sUrl.indexOf(commonsCntxUrl+"/") === 0){
                            return false;
                        }
                    }

                    // check if sUrl is of same protocol
                    if(oUri.protocol+":" !== location.protocol){
                        return true;
                    }else{
                        // check if the host name are same.
                        if(oUri.hostname !== location.hostname){
                            return true;
                        }else{
                            // https://url.spec.whatwg.org/#concept-url-port
                            // https://url.spec.whatwg.org/#port-state
                            // If buffer is equal to url's scheme's default port, set buffer to the empty string.
                            // Hence set port to empty string if its a default port as per https://url.spec.whatwg.org/#default-port
                            // No need to check for the protocol again as it was taken care in previous checks.
                            var port = (oUri.port === '80' || oUri.port === '443') ? "" : oUri.port;
                            // check if the ports are same.
                            // ports are same even when uri port is undefined and location.port is empty string
                            if((port !== null && port !== location.port)
                                        || (port === null && location.port !== "")){
                                return true;
                            }
                            // https://developer.mozilla.org/en-US/docs/Web/Security/Same-origin_policy
                            // for now ignore if both apps are from different web context.
                        }
                    }
                }
                return false; // case of relative url.
            },
            getStyle:function(sLibraryName,sClassName, sProp){
                var styleSheet = this.getStyleSheet(sLibraryName);
                if(!styleSheet) {
                    return;
                }
                var classes = styleSheet.rules || styleSheet.cssRules;
                if(!classes) {
                    return;
                }
                sClassName = "."+sClassName;
                for(var x=0; x<classes.length; x++) {
                    if(classes[x].selectorText===sClassName) {
                        var oClass = classes[x];
                        if(sProp !== undefined){
                            return oClass.style[sProp];
                        }
                        return oClass.style;
                    }
                }
            },
            getStyleSheet:function(sLibraryName){
                sLibraryName = "sap-ui-theme-"+sLibraryName;
                var allLinks = document.styleSheets;
                for(var i in allLinks){
                    if (allLinks.hasOwnProperty(i)) {
                        var styleLink = allLinks[i];
                        if(styleLink.ownerNode.id === sLibraryName){
                            return styleLink;
                        }
                    }
                }
            },
            disableBrowserContextMenu:function(){
                // Disable the browser's context menu on the page.  Other elements on
                // the page can provide their own context menu support but by default,
                // there won't be any menu shown.  The Ctrl key can re-enable the menu.
                jQuery(document.body).on("contextmenu", function(e){
                    if(!e.ctrlKey){
                        e.preventDefault();
                    }
                });
            },
            startTimeoutManager:function() {
                // start session timeout manager.
                if(sas.timeoutManager){
                    // register logoff on timed out event.
                    sas.eventBus.subscribe(sas.timeoutManager.events.TIMED_OUT,util.timeout);
                    sas.timeoutManager.start(true);
                }
            },
            doOnAppReady:function(){
                sas.eventBus.publish(util.APP_READY, {appId: sas.config.getAppId()});
                // remove splash screen
                var splashScr = $('#sas-hc-splash');
                if(splashScr){
                    splashScr.remove();
                }

                var transitionScr = $('#sas-hc-splashTransition');
                if(transitionScr){
                    transitionScr.remove();
                }

                // Tell application switcher bootstrap (top frame) to remove its splash screen.
                if(sas.applicationSwitcher){
                    sas.applicationSwitcher.removeSplash();
                }
                jQuery.sap.measure.end("sasBootstrapComplete");
            },

            timeout:function(){
                // log off.
                var url = sas.config.getSessionTimeoutUrl();
                if(url){

                    // hacky... we get timeout urls as flashvars from the flex jsp application tag.  They are ultimately retrieved
                    // via WIP ServletUtil and end up retaining all request parameters  of the original request (??).
                    // Typically this is good however the app switcher dynamically adds a request parameter to determine whether it has already
                    // bootstrapped itself or not.  This request parm is called launchedFromAppSwitcher.  We NEVER want a return to application
                    // from timeout to already ahve this value set or it will not bootstrap the app switcher code properly because it thinks
                    // it has already been done.
                    // If launchedFromAppSwitcher is present as a query parm on timeout URL just get rid of it.
                    var timeoutUrl=decodeURIComponent(url);

                    // HTMLCOMMONS-12412/SAS9TRIAGE-182
                    var altTimeoutActivityInterval = sas.config.get('altTimeoutActivityInterval');
                    if(altTimeoutActivityInterval) {
                        sas.log.trace('sas.hc.ui.core.util',"#timeout","invalidate session");
                        var url = "rest/commons/InvalidateSession"; // SASApp/InvalidateSession 
                        sas.ajax({type: "GET", async: true, url: url});
                    }

                    var UrlUtil = sap.ui.requireSync('sas/hc/ui/core/util/Url');
                    timeoutUrl=UrlUtil.removeQueryStringParameter(timeoutUrl,"launchedFromAppSwitcher");
                    if(sas.applicationSwitcher){
                        sas.applicationSwitcher.timeout(decodeURIComponent(timeoutUrl));
                    }else{
                        // This needs to be on top window because of app switcher and iframes.
                        window.location.href=decodeURIComponent(timeoutUrl);
                    }
                }
            },
            pingServer:function(successHandler,errorHandler){
                if(typeof keepAliveService === 'undefined'){
                    //resolve keep alive service
                    keepAliveService = ComponentServiceClassResolver.getServiceClassInstance(ComponentServiceClassResolver.KEEPALIVE_SERVICE);
                }
                if(typeof keepAliveService !== 'undefined' && keepAliveService){ // check for non null object
                    keepAliveService.ping(successHandler,errorHandler);
                }
            }
        };
        /**
         * Utility function to get proxy Url for a given Url. Proxy Url is generally used to make cross domain calls.
         * @param {string} sUrl          :Original Url as string for which proxy Url is needed. The Url is not validated for any scheme.
         * @param {boolean} bAuthenticate :boolean, set to true if original Url requires authentication. False otherwise.
         * @returns {string}            :Proxy Url as string if original Url is cross domain. The proxy Url is relative to
         *                       the web application. Returns original Url otherwise.
         */
        util.getProxyUrl=function(sUrl,bAuthenticate){
            if(util.isUrlCrossDomain(sUrl)){
                // possibly a cross domain Url. Generate a proxy Url.
                var q = {};
                // check for authentication.
                if(bAuthenticate === true){
                    q['sas-commons-auth'] = true;
                }
                q['sas-commons-destUrl'] = sUrl;
                var cdpsUrl = util._getCrossDomainProxyUrl();
                if(cdpsUrl){
                    return cdpsUrl+"?"+jQuery.param(q);
                }
            }
            return sUrl;
        };

        /**
         * return a 32 bit int hashcode for any string
         * @param {string} str TODO-jsdoc
         * @returns {int} TODO-jsdoc
         */
        util.hash = function(str) {
            var hash = 0, char;
            if (typeof str !== 'string' || str.length === 0) {
                return hash;
            }
            for (var i = 0; i < str.length; i++) {
                char = str.charCodeAt(i);
                /*eslint-disable no-bitwise */
                hash = ((hash << 5) - hash) + char;
                hash = hash & hash; // Convert to 32bit integer
                /*eslint-enable no-bitwise */
            }
            return hash;
        };
        /**
         * Utility function to sing out from application. If application switcher is ON then application switcher log off mechanism is used.
         */
        util.signout= function() {
            // fire before signout for apps to do some clean up
            sas.eventBus.publish(util.BEFORE_SIGN_OUT);
            // use app switcher mechanism if available.
            if(sas.applicationSwitcher) {
                sas.applicationSwitcher.logoff();
            } else{
                var signoutSrv = sap.ui.requireSync("sas/hc/ui/core/util/SignoutService").instance;
                if(signoutSrv && signoutSrv.signout){
                    signoutSrv.signout();
                }
            }
        };
        /**
         * Make properties of input object immutable preventing values of existing
         * properties from being modified and marking all existing properties as non-configurable.
         * @param {object} obj:Object of which properties need to be immutable. Must be an object.
         * @param {boolean} deep: True for recursive immutation. Defaults to false/undefined.
         * @returns {object} Same object with immutable properties. Same input argument is returned it is not an object.
         * @see Object.seal
         */
        util.immutate=function(obj,deep){
            if(typeof obj !== 'object') {
                return obj;
            }
            for (var prop in obj){
                if (obj.hasOwnProperty(prop)) {
                    try{
                        Object.defineProperty(obj,prop,{
                            enumerable: true,
                            writable:false,
                            configurable:false,
                            value:!!deep && typeof obj[prop] === 'object' ? util.immutate(obj[prop],deep) : obj[prop]
                        });
                    }catch (err){
                        // ignore if a property is not configurable.
                    }
                }
            }
            return obj;
        };

        /**
         * Collection of all loaded Help Resource Bundles
         * @type {Array}
         */
        util.mHelpResourceBundles = [];

        /**
         * Retrieves a HelpPopup resource bundle for the given library and locale.
         *
         * If only one argument is given, it is assumed to be the libraryName. The locale
         * then falls back to the current {@link sap.ui.core.Configuration.prototype.getLanguage session locale}.
         * If no argument is given, the library also falls back to a default: "sap.ui.core".
         *
         * @param {string} sLibraryName name of the library to retrieve the bundle for
         * @param {string} sLocale locale to retrieve the resource bundle for
         * @return {jQuery.sap.util.ResourceBundle} the best matching resource bundle for the given parameters or undefined
         */
        util.getHelpResourceBundle = function(sLibraryName, sLocale) {
            jQuery.sap.assert((sLibraryName === undefined && sLocale === undefined) || typeof sLibraryName === "string", "sLibraryName must be a string or there is no argument given at all");
            jQuery.sap.assert(sLocale === undefined || typeof sLocale === "string", "sLocale must be a string or omitted");

            var core = sap.ui.getCore();
            sLibraryName = sLibraryName || "sap.ui.core";
            sLocale = sLocale || core.getConfiguration().getLanguage();
            var sKey = sLibraryName + "/" + sLocale;
            if (!util.mHelpResourceBundles[sKey]) {
                var sURL = sap.ui.resource(sLibraryName, 'HelpPopup.properties');
                util.mHelpResourceBundles[sKey] = jQuery.sap.resources({url: sURL, locale: sLocale});
            }
            return util.mHelpResourceBundles[sKey];
        };

        /**
         * A promise that keeps track of whether or not the Help Center application is available.
         *
         * @type {object}
         */
        util.HELP_SERVICE = null;

        /**
         * Check if the Help Center application is available
         *
         * @returns {object} A promise that is resolved if able to access Help Center and rejected otherwise
         */
        util.getHelpService = function() {
            if (!util.HELP_SERVICE) {
                util.HELP_SERVICE = ComponentServiceClassResolver.getServiceClassInstance(ComponentServiceClassResolver.HELP);
            }

            return util.HELP_SERVICE;
        };

        /**
         * Get version of specified library name asynchronously.
         * @param {string} strLibName: Name of the library to get version for.
         * @param {Array} arrAvailableLibs: Optional array of libraries. Generally its sap.ui.getVersionInfo().libraries.
         * @return {String} library version of specified library name.
         */
        util.getLibraryVersion = function(strLibName,arrAvailableLibs){
            var version=undefined;
            jQuery.sap.assert((typeof strLibName === "string" && strLibName !== ''), "strLibName must be a non empty string");
            jQuery.sap.assert(Array.isArray(arrAvailableLibs), "arrAvailableLibs must be an Array of loaded libraries");

            if(typeof strLibName !== "string" || strLibName === '' || !Array.isArray(arrAvailableLibs)){
                return;
            }
            arrAvailableLibs.every(function(currentVal){
                if(currentVal.name === strLibName){
                    version = currentVal.version;
                    return false; // break
                }
                return true; // to continue traversing array.
            });
            return version;
        };

        /**
         * Get version of specified library name asynchronously.
         * @param {string} strLibName: Name of the library to get version for.
         * @return {Promise} Resolves to specified library version {String} information if found. Rejected otherwise.
         */
        util.getLibraryVersionAsync = function(strLibName){
            jQuery.sap.assert((typeof strLibName === "string" && strLibName !== ''), "strLibName must be a non empty string");

            if(typeof strLibName !== "string" || strLibName === ''){
                return Promise.reject();
            }
            return new Promise(function(resolve, reject){
                sap.ui.getVersionInfo({async:true}).then(function(oVersionInfo){
                    var version = util.getLibraryVersion(strLibName, oVersionInfo.libraries);
                    version ? resolve(version) : reject();
                },reject);
            });
        };


        /**
         * Get cross domain proxy path based on the configuration.
         * @private
         */
        util._getCrossDomainProxyUrl = function(){
            var sasConf = sas && sas.config;
            if(sasConf){
                // if cross domain proxy config value doesn't start or contain '/' (a case with local cdps)
                // then treat it as running locally within application.
                var retUrl = (/\//.test(sasConf.getCrossDomainProxy()) ? "" : sasConf.getContextPath()+"/")+sasConf.getCrossDomainProxy();
                return retUrl;
            }
        };
        /**
         * Default bootHook registered. Don't invoke this API directly.
         * @private
         */
        util._bootHook = function(){
            try{
                var _finalPromise = Promise.resolve();
                if(_bootHandlers.length > 0){
                    jQuery.sap.measure.start("sasCoreBootHookComplete");
                    var allPrmses = [], retPromise;

                    while(_bootHandlers.length > 0){
                        allPrmses.push(_bootHandlers.shift().call());
                    }

                    retPromise = Promise.all(allPrmses);
                    retPromise.then(function(){
                        jQuery.sap.measure.end("sasCoreBootHookComplete");
                    });
                    _finalPromise = retPromise;
                }
            }catch(err){
                sas && sas.log && sas.log.error("sas.hc.ui.core.util._bootHook: Error executing handlers",err);
            }
            var nonBlocking = sas && sas.config && sas.config.get('nonBlockingBootHooks');
            return nonBlocking=== true ? Promise.resolve(): _finalPromise;
        };

        var _bootHandlers = [];
        /**
         * API to register a boot hook that gets executed in boot strap mechanism after all openUI libraries are loaded.
         * @param {function} handler is a function and MUST return a Promise OR jQuery.Deferred#promise. Handler must resolve the promise
         * on completion. Important. Not resolving the promise would hold up boot process and application startup forever.
         * @private
         */
        util.registerBootHook = function(handler){
            jQuery.sap.assert((typeof handler === "function"), "handler must be a function that returns promise.");
            _bootHandlers.push(handler);
        };

        /**
         * When performance matters, use the DOM API to update the text on the DOM element
         * in the SAP control.
         *
         * @param {object} oControl control that has the element
         * @param {string} sClass element's style class
         * @param {string} sValue the text context value
         * @private
         */
        util.updateTextContent = function(oControl, sClass, sValue){
            var oDomRef,
                oElement;

            if (!oControl || !sClass){
                return false;
            }

            oDomRef = oControl.getDomRef();
            if (oDomRef) {
                oElement = oDomRef.querySelector("." + sClass);
                return this.updateTextContentElement(oElement, sValue);
            }
            return false;
        };

        /**
         * When performance matters, use the DOM API to update the text on the DOM element.
         *
         * @param {object} oElement the DOM element
         * @param {string} sValue the text context value
         * @private
         */
        util.updateTextContentElement = function(oElement, sValue){
            jQuery.sap.assert( typeof sValue === "string", "sValue must be a string");

            if (oElement) {
                oElement.textContent = sValue;
                return true;
            }
            return false;
        };

        /**
         * Checks if the version on framework same as that of its parent if any.
         * @private
         * @returns {Promise} that resolves to true if self version matches with that of parent's. Rejects otherwise.
         */
        util._hasSameVersionAsParent = function (){
            try{
                if(window !== window.top
                            && top.sap
                            && top.sap.ui
                            && top.sap.ui.getVersionInfo){
                    return new Promise(function(resolve,reject){
                        var topRet,
                            libraryName= "sap.ui.core";

                        function completePromise(arr){
                            if(arr[0]){
                                var topVersion=util.getLibraryVersion(libraryName,arr[0].libraries);
                                topVersion && topVersion === arr[1] ? resolve(true) : reject();
                            }else{
                                reject();
                            }
                        };

                        topRet =  top.sap.ui.getVersionInfo({async:true});
                        if(topRet instanceof top.Promise){
                            Promise.all([topRet,util.getLibraryVersionAsync(libraryName)]).then(completePromise,reject);
                        }else{
                            util.getLibraryVersionAsync(libraryName).then(function(selfVersion){
                                completePromise([topRet,selfVersion]);
                            },
                            reject);
                        }
                    });
                }
            }catch(err){
                // security error will be thrown in case of
                // apps loaded from cross origin.
                // suppress the error.
            }
            return Promise.reject();
        };

        util.deepFreeze = function (obj) {

            // Retrieve the property names defined on obj
            var propNames = Object.getOwnPropertyNames(obj);

            // Freeze properties before freezing self
            propNames.forEach(function(name) {
                var prop = obj[name];

                // Freeze prop if it is an object
                if (typeof prop == 'object' && prop !== null)
                    util.deepFreeze(prop);
            });

            // Freeze self (no-op if already frozen)
            return Object.freeze(obj);
        };

        util.doOnInit = function (sViewName) {
            var initView = function(skipDetach){
                skipDetach !== true && sap.ui.getCore().detachThemeChanged(initView);
                var sas_hc_view, welcomePromise = Promise.resolve();
                // invoke Welcome Experience only in Viya
                var welcomeExpClass = ComponentServiceClassResolver.getServiceClass("WELCOME_EXPERIENCE");
                if (welcomeExpClass) {
                    welcomePromise = sap.ui.requireSync(jQuery.sap.getResourceName(welcomeExpClass,'')).start();
                }
                Promise.all([
                    welcomePromise,
                    new Promise(function(fnFulfill, fnReject) {
                        // invoke application
                        // lazy load 'sap/ui/core/library'
                        sas_hc_view = sap.ui.view({id:sas.config.getAppId(), viewName:sViewName, type:sap.ui.requireSync('sap/ui/core/library').mvc.ViewType.JS, height:'100%'});
                        sas_hc_view.attachEventOnce('afterRendering',fnFulfill);
                        sas_hc_view.placeAt("sas_hc_content");
                        sap.ui.requireSync('sas/hc/ui/core/Narrator').initRegions();
                    })
                ]).then(function() {
                    util.doOnAppReady();
                });

            };
            if(sas.config && sas.config.get('nonBlockingBootHooks') === true){
                sap.ui.getCore().isThemeApplied() ? initView(true) : sap.ui.getCore().attachThemeChanged(initView);
            }else{
                initView(true);
            }

        };

        util.isInstanceOf = function(obj, strClassName, isMetadata){
            if(!obj || !strClassName) return false;
            var metadata = isMetadata===true ? obj : obj.getMetadata && obj.getMetadata(),
                objClassName = metadata && metadata.getName();
            if(objClassName === strClassName) return true;
            return objClassName ? util.isInstanceOf(metadata.getParent(), strClassName, true) : false;
        };

        return util;
    }
,true);
