// (c) 2014, SAS Institute Inc.

sap.ui.define(['jquery.sap.global', 'sap/ui/base/DataType', 'sap/ui/core/Core','sas/hc/ui/core/Core'],
    function(jQuery, DataType) {
        "use strict";
        /**
         * @namespace
         * @name sas.hc.ui.core
         * @public
         */

        /**
         * @namespace
         * @name sas.hc.ui.core.actions
         * @public
         */

        /**
         * @namespace
         * @name sas.hc.ui.core.actions.events
         * @public
         */

        /**
         * @namespace
         * @name sas.hc.ui.core.applicationSwitcher
         * @public
         */

        /**
         * @namespace
         * @name sas.hc.ui.core.delegate
         * @public
         */

        /**
         * @namespace
         * @name sas.hc.ui.core.theme
         * @public
         */

        /**
         * @namespace
         * @name sas.hc.ui.core.theme.service
         * @public
         */

        /**
         * @namespace
         * @name sas.hc.ui.core.util
         * @public
         */

        /**
         * @namespace
         * @name sas.hc.ui.model
         * @public
         */

        /**
         * @namespace
         * @name sas.hc.ui.services
         * @public
         */

        /**
         * @namespace
         * @name sas.hc.ui.services.notifications
         * @public
         */

        /**
         * @namespace
         * @name sas.hc.ui.services.petrichor
         * @public
         */

        /**
         * @namespace
         * @name sas.hc.ui.services.petrichor.appRegistry
         * @public
         */

        /**
         * @namespace
         * @name sas.hc.ui.services.petrichor.fonts
         * @public
         */

        // delegate further initialization of this library to the Core
        sap.ui.getCore().initLibrary({
            name : "sas.hc.ui.core",
            dependencies : ["sap.ui.core"],
            types : [
            ],
            interfaces : [
                "sas.hc.ui.core.IScrollContainer"
            ],
            controls : [
                "sas.hc.contributor.responsive.ResponsiveContributor",
                "sas.hc.contributor.responsive.ResponsiveReporter",
                "sas.hc.ui.core.AnimationUtil",
                "sas.hc.ui.core.BootTask",
                "sas.hc.ui.core.ClearFocusRingTask",
                "sas.hc.ui.core.ComponentContainer",
                "sas.hc.ui.core.Configuration",
                "sas.hc.ui.core.ContextMenuHandler",
                "sas.hc.ui.core.ContextMenuTask",
                "sas.hc.ui.core.Control",
                "sas.hc.ui.core.Core",
                "sas.hc.ui.core.CSRFTask",
                "sas.hc.ui.core.CustomData",
                "sas.hc.ui.core.DataState",
                "sas.hc.ui.core.Earcon",
                "sas.hc.ui.core.Element",
                "sas.hc.ui.core.extraConfig",
                "sas.hc.ui.core.globalErrorHandler",
                "sas.hc.ui.core.GlobalSettings",
                "sas.hc.ui.core.HorizontalScrollDelegate",
                "sas.hc.ui.core.HTML",
                "sas.hc.ui.core.Icon",
                "sas.hc.ui.core.IconPool",
                "sas.hc.ui.core.InvisibleText",
                "sas.hc.ui.core.Item",
                "sas.hc.ui.core.LayoutData",
                "sas.hc.ui.core.LeftNavDataProvider",
                "sas.hc.ui.core.LeftNavPetDataProvider",
                "sas.hc.ui.core.ListItem",
                "sas.hc.ui.core.LocalBusyIndicator",
                "sas.hc.ui.core.Message",
                "sas.hc.ui.core.MonkeyPatchApplySettingsTask",
                "sas.hc.ui.core.Narrator",
                "sas.hc.ui.core.RegistryTask",
                "sas.hc.ui.core.ScrollBar",
                "sas.hc.ui.core.ScrollDelegate",
                "sas.hc.ui.core.SeparatorItem",
                "sas.hc.ui.core.splashA11Y",
                "sas.hc.ui.core.Styles",
                "sas.hc.ui.core.SVGCache",
                "sas.hc.ui.core.TimeoutHandlerTask",
                "sas.hc.ui.core.Title",
                "sas.hc.ui.core.TooltipBase",
                "sas.hc.ui.core.TouchDetectionTask",
                "sas.hc.ui.core.UIComponent",
                "sas.hc.ui.core.util",
                "sas.hc.ui.core.UtilTask",
                "sas.hc.ui.core.VariantLayoutData",
                "sas.hc.ui.core.VersionInfoTask",
                "sas.hc.ui.core.VerticalScrollDelegate",
                "sas.hc.ui.core.waitFor",
                "sas.hc.ui.core.actionManager.ActionChallenge",
                "sas.hc.ui.core.actionManager.ActionExtensionInfo",
                "sas.hc.ui.core.actionManager.ActionExtensionSupport",
                "sas.hc.ui.core.actionManager.ActionManager",
                "sas.hc.ui.core.actionManager.actions.BaseAction",
                "sas.hc.ui.core.actionManager.actions.BaseUndoableAction",
                "sas.hc.ui.core.actionManager.actions.BaseUndoableTransactionalAction",
                "sas.hc.ui.core.actionManager.actions.GenericTransactionalAction",
                "sas.hc.ui.core.actionManager.actions.TransactionalActionWithPrimary",
                "sas.hc.ui.core.actionManager.events.ActionExecutionPendingEvent",
                "sas.hc.ui.core.actionManager.events.ActionStateChangeEvent",
                "sas.hc.ui.core.applicationSwitcher.Application",
                "sas.hc.ui.core.applicationSwitcher.ApplicationSwitcher",
                "sas.hc.ui.core.applicationSwitcher.ApplicationSwitcherBootTask",
                "sas.hc.ui.core.applicationSwitcher.ApplicationSwitcherModel",
                "sas.hc.ui.core.applicationSwitcher.ApplicationSwitcherPetrichorModel",
                "sas.hc.ui.core.cache.CacheManagerTask",
                "sas.hc.ui.core.cache.UserPreferencesCache",
                "sas.hc.ui.core.delegate.Draggable",
                "sas.hc.ui.core.delegate.Droppable",
                "sas.hc.ui.core.delegate.TableClickHandlerDelegate",
                "sas.hc.ui.core.delegate.ToolbarItemNavigation",
                "sas.hc.ui.core.mvc.HTMLView",
                "sas.hc.ui.core.mvc.JSAppView",
                "sas.hc.ui.core.mvc.JSONView",
                "sas.hc.ui.core.mvc.JSView",
                "sas.hc.ui.core.mvc.TemplateView",
                "sas.hc.ui.core.mvc.View",
                "sas.hc.ui.core.mvc.XMLView",
                "sas.hc.ui.core.search.OpenSearchProvider",
                "sas.hc.ui.core.search.SearchProvider",
                "sas.hc.ui.core.settings.GlobalSettingsHelper",
                "sas.hc.ui.core.theme.ApplicationTheme",
                "sas.hc.ui.core.theme.ApplicationThemeProvider",
                "sas.hc.ui.core.theme.CustomApplicationThemeProvider",
                "sas.hc.ui.core.theme.EmbeddedApplicationTheme",
                "sas.hc.ui.core.theme.EmbeddedApplicationThemeProvider",
                "sas.hc.ui.core.theme.IconInitialization",
                "sas.hc.ui.core.theme.ThemeBootTask",
                "sas.hc.ui.core.theme.ThemeDescriptor",
                "sas.hc.ui.core.theme.ThemeUtil",
                "sas.hc.ui.core.theme.service.ThemeService",
                "sas.hc.ui.core.theme.service.ThemeServiceProxy",
                "sas.hc.ui.core.theme.service.petrichor.PetrichorApplicationTheme",
                "sas.hc.ui.core.theme.service.petrichor.PetrichorThemeService",
                "sas.hc.ui.core.theme.service.wip.WIPApplicationTheme",
                "sas.hc.ui.core.theme.service.wip.WIPThemeService",
                "sas.hc.ui.core.tmpl.DOMAttribute",
                "sas.hc.ui.core.tmpl.DOMElement",
                "sas.hc.ui.core.tmpl.Template",
                "sas.hc.ui.core.tmpl.TemplateControl",
                "sas.hc.ui.core.util.CalendarUtil",
                "sas.hc.ui.core.util.ComponentServiceClassResolver",
                "sas.hc.ui.core.util.DomToCanvasUtil",
                "sas.hc.ui.core.util.jqXHRRetryHandler",
                "sas.hc.ui.core.util.LongPressUtil",
                "sas.hc.ui.core.util.ltjsLoaderUtil",
                "sas.hc.ui.core.util.LTJSUtil",
                "sas.hc.ui.core.util.ObjectProxy",
                "sas.hc.ui.core.util.PetKeepAliveService",
                "sas.hc.ui.core.util.PetSignoutService",
                "sas.hc.ui.core.util.PetUserInfoService",
                "sas.hc.ui.core.util.ProfilingUtil",
                "sas.hc.ui.core.util.SASCollatorUtil",
                "sas.hc.ui.core.util.ServicesUtil",
                "sas.hc.ui.core.util.SignoutService",
                "sas.hc.ui.core.util.StringUtil",
                "sas.hc.ui.core.util.Timer",
                "sas.hc.ui.core.util.Url",
                "sas.hc.ui.core.util.UserInfo",
                "sas.hc.ui.core.util.WIPKeepAliveService",
                "sas.hc.ui.core.util.WIPUserInfoService",
                "sas.hc.ui.model.JSONModel",
                "sas.hc.ui.model.PageableContext",
                "sas.hc.ui.model.PageableJSONListBinding",
                "sas.hc.ui.model.PageableJSONModel",
                "sas.hc.ui.model.PageableJSONTreeBinding",
                "sas.hc.ui.model.PageableJSONTreeBindingAdapter",
                "sas.hc.ui.model.PageableJSONTreeModel",
                "sas.hc.ui.model.SimpleModelCache",
                "sas.hc.ui.services.RestService",
                "sas.hc.ui.services.ServiceRegistry",
                "sas.hc.ui.services.notifications.AbstractNotificationsService",
                "sas.hc.ui.services.notifications.NotificationsService",
                "sas.hc.ui.services.notifications.PetrichorNotificationsAdapterService",
                "sas.hc.ui.services.petrichor.appRegistry.AppRegistryService",
                "sas.hc.ui.services.petrichor.avatar.AvatarService",
                "sas.hc.ui.services.petrichor.comments.CommentService",
                "sas.hc.ui.services.petrichor.files.FileService",
                "sas.hc.ui.services.petrichor.fonts.FontService",
                "sas.hc.ui.services.petrichor.notifications.NotificationsService",
                "sas.hc.ui.services.petrichor.preferences.PreferencesService",
                "sas.hc.ui.services.petrichor.theme.ThemeService",
                "sas.hc.ui.core.ServerSideEventBus"

            ],
            elements : [
                "sas.hc.ui.core.ScrollDelegate",
                "sas.hc.ui.core.HorizontalScrollDelegate",
                "sas.hc.ui.core.VerticalScrollDelegate"
            ],
            version : "904001.11.16.20251118090100_f0htmcm94p"
        });

        var thisLib = sas.hc.ui.core;
        /**
         *
         * Represents an interface for controls which require Horizontal / Vertical Scrolling such as sas.hc.m.Tokenizer.
         * The classes which implement this interface are:
         * - sas.hc.m.Tokenizer
         *
         * Note: This interface can be used by IconTabbar & Breadcrumb at a later date.
         *
         * @name sas.hc.ui.core.IScrollContainer
         * @interface
         * @public
         * @ui5-metamodel This interface also will be described in the UI5 (legacy) designtime metamodel
         *
         * Methods: (+) indicates public, (-) indicates private)
         * (+) onAfterScrollComplete
         * (+) getScrollState
         */

        //-----------------------------------------------------------------------------
        //Begin of Library Initialization coding, copied from shared.js
        //-----------------------------------------------------------------------------

        var lazy = sap.ui.lazyRequire;

        function each(sPackage,aClasses,sShortcutPkg) {
            for(var i=0; i<aClasses.length; i++) {
                if ( sShortcutPkg ) {
                    lazy(sShortcutPkg, aClasses[i].toLowerCase(), sPackage + aClasses[i]);
                } else {
                    lazy(sPackage + aClasses[i], "new extend getMetadata");
                }
            }
        }

        // lazy imports
        each("sas.hc.ui.core.mvc.", ["JSAppView"], "sas.hc.ui");

        // Initialize icons
        if(!sas.applicationSwitcher || !sas.applicationSwitcher._isMainApplication()){
            var IconInitialization = sap.ui.requireSync("sas/hc/ui/core/theme/IconInitialization");
            IconInitialization.initThemeDescriptorIcons();
            // add UserInfo require to fetch user information async'ly
            sap.ui.requireSync("sas/hc/ui/core/util/UserInfo");

            // create system level actionManager to handle undo/redo stack
            var actionManager=undefined;
            Object.defineProperty(sas,'actionManager',{
                get:function(){
                    if(actionManager === undefined){
                        // initialized ActionManager
                        var ActionManager = sap.ui.requireSync("sas/hc/ui/core/actionManager/ActionManager");
                        actionManager = new ActionManager();
                    }
                    return actionManager;
                },
                enumerable:true,
            });

        }

        // Backward-compatible name mapping
        thisLib.delegate.ItemDefaultAction = thisLib.delegate.TableClickHandlerDelegate;


        /////////////////////////////////////////////////////////////////////////////////////////////////////
        //////////////////////////////////SETTINGS CONSTANTS////////////////////////////////////////////
        /////////////////////////////////////////////////////////////////////////////////////////////////////
        /**
         * The name of the sas.eventBus Channel on which an event of the type change would be dispatched.
         * @public
         */
        thisLib.SETTINGS_CHANNEL ="settingsChannel";

        /**
         * This event will be fired against the settingsChannel of sas.eventBus after settings are persisted.
         * @public
         */
        thisLib.SETTINGS_CHANGE = "settingsChange";

        /**
         * A color representation in hex format.
         *
         * @typedef {string} sas.hc.ui.core.Color
         *
         * @static
         * @public
         *
         */
        thisLib.Color = DataType.createType("sas.hc.ui.core.Color", {
            isValid: function (value) {
                var hexPattern = new RegExp("^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$");
                return hexPattern.test(value);
            }
        },
        DataType.getType("string")
        );


        sap.ui.requireSync('sas/hc/ui/core/GlobalSettings');

        /////////////////////////////////////////////////////////////////////////////////////////////////////
        ///////////////////////////END SETTINGS CONSTANTS//////////////////////////////////////////////
        /////////////////////////////////////////////////////////////////////////////////////////////////////

        thisLib.CustomExternalFocusStyles = {
            'sasCustomExternalFocusStyles': [
                {'selector':'*:focus, html.sap-desktop .sapMBtn:focus > .sapMFocusable, .sasSlider .sliderPseudoFocus .sasThumb, .sasSlider .sasHighlightColor.sliderPseudoFocus , html.sap-desktop .sapMSwtCont:focus > .sapMSwt,html.sap-desktop .sapUiCalItem:focus > .sapUiCalItemText, .sapUiTriCb:focus .sapUiTriCbInner, html.sap-desktop .sapMCb:not(.sapMCbBgDis):not(.sapMCbHasLabel):focus > .sapMCbBg, .sapUiBtnS.sapUiBtnIconOnly.sapUiBtnStd:focus > span.sapUiBtnIco', 'styles':{'outline-color':'@FOCUSCOLOR !important;' ,'outline-width':'@FOCUSTHICKNESS !important' }},
                {'selector':'.sapMSF.sapMFocus .sapMSFF, .sapUiMnu .sapUiMnuItm:not(.sapUiMnuItmDsbl):not(.sasUiMnuItmDisabledFocusEnabled):focus, html.sap-desktop .sapMSegBBtn.sapMSegBBtnFocusable:focus,.sapUiMnuItm.sapUiMnuItmDsbl.sasUiMnuItmDisabledFocus', 'styles':{'outline':'@FOCUSTHICKNESS dotted @FOCUSCOLOR !important;' }},
                {'selector':'.sapMSlt.sasMSltFocused:after,.sapMFocus .sapMInputDivWrapper:before,.sapMTextArea.sapMFocus:after, .sapMSelectListItemBase.sapMSelectListItemBaseSelected::before, html[data-sap-ui-browser*="ie"].sap-desktop .sasCustomFocusIndicatorStyles .sapMSegBBtn.sapMSegBBtnFocusable:focus:before, html[data-sap-ui-browser*="ed"].sap-desktop .sasCustomFocusIndicatorStyles .sapMSegBBtn.sapMSegBBtnFocusable:focus:before, html[data-sap-ui-browser*="ie"] .sapUiAcd .sapUiAcdSectionHdr:focus::after, .sapMComboBox.sapMFocus:after, html[data-sap-ui-browser*="ed"] .sapUiAcd .sapUiAcdSectionHdr:focus::after, .sapMComboBox.sapMFocus:after, html[data-sap-ui-browser^="ie"].sap-desktop .sapMCb:not(.sapMCbBgDis):not(.sapMCbHasLabel):focus > .sapMCbBg:before, html[data-sap-ui-browser^="ed"].sap-desktop .sapMCb:not(.sapMCbBgDis):not(.sapMCbHasLabel):focus > .sapMCbBg:before,html[data-sap-ui-browser^="ie"] .sapUiMnu .sapUiMnuItm:not(.sapUiMnuItmDsbl):not(.sasUiMnuItmDisabledFocusEnabled):focus::after,html[data-sap-ui-browser^="ed"] .sapUiMnu .sapUiMnuItm:not(.sapUiMnuItmDsbl):not(.sasUiMnuItmDisabledFocusEnabled):focus::after,html[data-sap-ui-browser^="ie"] .sapUiMnuItm.sapUiMnuItmDsbl.sasUiMnuItmDisabledFocus::after,html[data-sap-ui-browser^="ed"] .sapUiMnuItm.sapUiMnuItmDsbl.sasUiMnuItmDisabledFocus::after, html[data-sap-ui-browser^="ie"].sap-desktop .sapMFocus > .sapMSFF:before,html[data-sap-ui-browser^="ed"].sap-desktop .sapMFocus > .sapMSFF:before', 'styles':{'border':'@FOCUSTHICKNESS dotted @FOCUSCOLOR !important;' }},
                {'selector':':focus::before, :focus::after, .sasSlider .sasSliderArrowThumbs .sliderPseudoFocus:before, html[data-sap-ui-browser*="ie"] .sapMBtn:focus .sapMBtnFocusDiv, html[data-sap-ui-browser*="ed"] .sapMBtn:focus .sapMBtnFocusDiv,html[data-sap-ui-browser^="ie"].sap-desktop .sapUiCalItem:not(.sapUiCalItemDsbl):focus > .sapUiCalItemText::after, html[data-sap-ui-browser^="ed"].sap-desktop .sapUiCalItem:not(.sapUiCalItemDsbl):focus > .sapUiCalItemText::after,html[data-sap-ui-browser^="ie"].sap-desktop .sapMToken:focus .sapMTokenText::before, html[data-sap-ui-browser^="ie"].sap-desktop .sapMToken.sasMGroupToken:focus .sasMGroupTokenButton::before, html[data-sap-ui-browser^="ed"].sap-desktop .sapMToken:focus .sapMTokenText::before, html[data-sap-ui-browser^="ed"].sap-desktop .sapMToken.sasMGroupToken:focus .sasMGroupTokenButton::before, html[data-sap-ui-browser^="ie"] .sapUiMnuItm.sapUiMnuItmDsbl.sasUiMnuItmDisabledFocus::after, html[data-sap-ui-browser^="ed"] .sapUiMnuItm.sapUiMnuItmDsbl.sasUiMnuItmDisabledFocus::after,html[data-sap-ui-browser^="ie"] .sapUiTriCb:focus .sapUiTriCbInner::after, html[data-sap-ui-browser^="ed"] .sapUiTriCb:focus .sapUiTriCbInner::after,html[data-sap-ui-browser^="ie"] .sapUiMnu .sapUiMnuItm:not(.sapUiMnuItmDsbl):not(.sasUiMnuItmDisabledFocusEnabled):focus::after, html[data-sap-ui-browser^="ed"] .sapUiMnu .sapUiMnuItm:not(.sapUiMnuItmDsbl):not(.sasUiMnuItmDisabledFocusEnabled):focus::after, .sapMSB:focus .sapMSBInner:after', 'styles':{'border-color':'@FOCUSCOLOR !important;', 'border-width':'@FOCUSTHICKNESS !important' }},
                {'selector':'html[data-sap-ui-browser*="ie"].sap-desktop .sasCustomFocusIndicatorStyles .sapMSegBBtn.sapMSegBBtnFocusable:focus, html[data-sap-ui-browser*="ed"].sap-desktop .sasCustomFocusIndicatorStyles .sapMSegBBtn.sapMSegBBtnFocusable:focus, html[data-sap-ui-browser*="ie"] .sapUiLoSplitter > .sapUiLoSplitterBar:focus, html[data-sap-ui-browser*="ed"] .sapUiLoSplitter > .sapUiLoSplitterBar:focus, html[data-sap-ui-browser^="ie"] .sapUiMnu :not(.sapUiMnuItmDsbl).sapUiMnuItm:focus, html[data-sap-ui-browser^="ed"] .sapUiMnu :not(.sapUiMnuItmDsbl).sapUiMnuItm:focus, html[data-sap-ui-browser^="ie"] .sapUiMnuItm.sapUiMnuItmDsbl.sasUiMnuItmDisabledFocus, html[data-sap-ui-browser^="ed"] .sapUiMnuItm.sapUiMnuItmDsbl.sasUiMnuItmDisabledFocus,html[data-sap-ui-browser^="ie"].sap-desktop .sapMFocus > .sapMSFF, html[data-sap-ui-browser^="ed"].sap-desktop .sapMFocus > .sapMSFF, .sasUiBreadcrumb .sasUiBreadCrumbVertical.sapMSltExpanded .sapMSltArrow:focus', 'styles':{'outline':'none !important;'  }},
                {'selector':'html[data-sap-ui-browser*="ie"] .sasUiBreadcrumb .sasUiBreadCrumbVertical.sapMSltExpanded .sapMSltArrow:focus::after, html[data-sap-ui-browser*="ed"] .sasUiBreadcrumb .sasUiBreadCrumbVertical.sapMSltExpanded .sapMSltArrow:focus::after', 'styles':{'border':'none !important;' }},
                {'selector':'html[data-sap-ui-browser*="ie"] .sapUiTableCnt .sapUiTableRowHdr :not(.sapMCbBgDis):not(.sapMCbHasLabel).sapMCb:focus::before, html[data-sap-ui-browser*="ed"] .sapUiTableCnt .sapUiTableRowHdr :not(.sapMCbBgDis):not(.sapMCbHasLabel).sapMCb:focus::before, html[data-sap-ui-browser*="ie"] .sapUiTableColHdrCnt .sapUiTableSelAllEnabled.sapUiTableColRowHdr :not(.sapMCbBgDis):not(.sapMCbHasLabel).sapMCb:focus::before, html[data-sap-ui-browser*="ed"] .sapUiTableColHdrCnt .sapUiTableSelAllEnabled.sapUiTableColRowHdr :not(.sapMCbBgDis):not(.sapMCbHasLabel).sapMCb:focus::before, html[data-sap-ui-browser*="ie"] .sapUiTableCnt .sapUiTableRowHdr .sapMRb:focus::before, html[data-sap-ui-browser*="ed"] .sapUiTableCnt .sapUiTableRowHdr .sapMRb:focus::before, html[data-sap-ui-browser*="ie"] .sapUiTable .sapMRbB:focus::after, html[data-sap-ui-browser*="ed"] .sapUiTable .sapMRbB:focus::after, html[data-sap-ui-browser*="ie"] .sapUiTable .sapUiTableCol:focus, html[data-sap-ui-browser*="ed"] .sapUiTable .sapUiTableCol:focus, html[data-sap-ui-browser*="ie"] .sapUiTableTr > td:focus, html[data-sap-ui-browser*="ed"] .sapUiTableTr > td:focus', 'styles':{'box-shadow':'inset 0 0 0 @FOCUSTHICKNESS @FOCUSCOLOR !important'}},
                {'selector':'.sasLIRightClick', 'styles':{'outline-color':'@FOCUSCOLOR !important;' ,'outline-width':'@FOCUSTHICKNESS !important' }},
                {'selector':'html[data-sap-ui-browser*="ie"] .sasLIRightClick::after, html[data-sap-ui-browser*="ed"] .sasLIRightClick::after, .sapUiTreeNode.sasLIRightClick:before', 'styles':{'border-color':'@FOCUSCOLOR !important;', 'border-width':'@FOCUSTHICKNESS !important' }}
            ]
        };

        /******
         * Currently, the following styles are a direct copy of the above custom external focus styles with the addition of adding the .clearFocusRing selector.
         * .clearFocusRing is set on the body in javascript. Any additions made to CustomExternalFocusStyles must also be added to ClearFocusRingStyles.
         */
        thisLib.ClearFocusRingStyles = {
            'sasClearFocusRingStyles': [
                {'selector':'.clearFocusRing *:focus, html.sap-desktop .clearFocusRing .sapMBtn:focus > .sapMFocusable,.clearFocusRing .sasSlider .sliderPseudoFocus .sasThumb, .clearFocusRing .sasSlider .sasHighlightColor.sliderPseudoFocus , html.sap-desktop .clearFocusRing .sapMSwtCont:focus > .sapMSwt,html.sap-desktop .clearFocusRing .sapUiCalItem:focus > .sapUiCalItemText, .clearFocusRing .sapUiTriCb:focus .sapUiTriCbInner, html.sap-desktop .clearFocusRing .sapMCb:not(.sapMCbBgDis):not(.sapMCbHasLabel):focus > .sapMCbBg, .clearFocusRing .sapUiBtnS.sapUiBtnIconOnly.sapUiBtnStd:focus > span.sapUiBtnIco', 'styles':{'outline':'none !important;'}},
                {'selector':'.clearFocusRing .sapUiMnu .sapUiMnuItm:not(.sapUiMnuItmDsbl):focus, html.sap-desktop .clearFocusRing .sapMSegBBtn.sapMSegBBtnFocusable:focus', 'styles':{'outline':'none !important;'}},
                {'selector':'.clearFocusRing .sapMSelectListItemBase.sapMSelectListItemBaseSelected::before, html[data-sap-ui-browser*="ie"].sap-desktop .clearFocusRing .sasCustomFocusIndicatorStyles .sapMSegBBtn.sapMSegBBtnFocusable:focus:before, html[data-sap-ui-browser*="ed"].sap-desktop .clearFocusRing .sasCustomFocusIndicatorStyles .sapMSegBBtn.sapMSegBBtnFocusable:focus:before,html[data-sap-ui-browser*="ie"] .clearFocusRing .sapUiAcd .sapUiAcdSectionHdr:focus::after, html[data-sap-ui-browser*="ed"] .clearFocusRing .sapUiAcd .sapUiAcdSectionHdr:focus::after,html[data-sap-ui-browser^="ie"] .clearFocusRing .sapUiTriCb:focus .sapUiTriCbInner::after, html[data-sap-ui-browser^="ed"] .clearFocusRing .sapUiTriCb:focus .sapUiTriCbInner::after', 'styles':{'border':'none !important;' }},
                {'selector':'.clearFocusRing :focus::before, .clearFocusRing :focus::after, .clearFocusRing .sasSlider .sasSliderArrowThumbs .sliderPseudoFocus:before, html[data-sap-ui-browser*="ie"] .clearFocusRing .sapMBtn:focus .sapMBtnFocusDiv, html[data-sap-ui-browser*="ed"] .clearFocusRing .sapMBtn:focus .sapMBtnFocusDiv,html[data-sap-ui-browser^="ie"].sap-desktop .clearFocusRing .sapUiCalItem:not(.sapUiCalItemDsbl):focus > .sapUiCalItemText::after, html[data-sap-ui-browser^="ed"].sap-desktop .clearFocusRing .sapUiCalItem:not(.sapUiCalItemDsbl):focus > .sapUiCalItemText::after,html[data-sap-ui-browser^="ie"].sap-desktop .clearFocusRing .sapMToken:focus .sapMTokenText::before, html[data-sap-ui-browser^="ie"].sap-desktop .clearFocusRing .sapMToken.sasMGroupToken:focus .sasMGroupTokenButton::before, html[data-sap-ui-browser^="ed"].sap-desktop .clearFocusRing .sapMToken:focus .sapMTokenText::before, html[data-sap-ui-browser^="ed"].sap-desktop .clearFocusRing .sapMToken.sasMGroupToken:focus .sasMGroupTokenButton::before, .clearFocusRing .sapMComboBox.sapMInputBaseReadonly.sapMFocus:after, html[data-sap-ui-browser^="ie"].sap-desktop .clearFocusRing .sapMCb:not(.sapMCbBgDis):not(.sapMCbHasLabel):focus > .sapMCbBg:before, html[data-sap-ui-browser^="ed"].sap-desktop .clearFocusRing .sapMCb:not(.sapMCbBgDis):not(.sapMCbHasLabel):focus > .sapMCbBg:before, .clearFocusRing .sapMSB:focus .sapMSBInner:after', 'styles':{'border':'none !important;' }},
                {'selector':'html[data-sap-ui-browser*="ie"].sap-desktop .clearFocusRing .sasCustomFocusIndicatorStyles .sapMSegBBtn.sapMSegBBtnFocusable:focus, html[data-sap-ui-browser*="ed"].sap-desktop .clearFocusRing .sasCustomFocusIndicatorStyles .sapMSegBBtn.sapMSegBBtnFocusable:focus, html[data-sap-ui-browser*="ie"] .clearFocusRing .sapUiLoSplitter > .sapUiLoSplitterBar:focus, html[data-sap-ui-browser*="ed"] .clearFocusRing .sapUiLoSplitter > .sapUiLoSplitterBar:focus', 'styles':{'outline':'none !important;'  }},
                {'selector':'html[data-sap-ui-browser*="ie"] .clearFocusRing .sapUiTableCnt .sapUiTableRowHdr :not(.sapMCbBgDis):not(.sapMCbHasLabel).sapMCb:focus::before, html[data-sap-ui-browser*="ed"] .clearFocusRing .sapUiTableCnt .sapUiTableRowHdr :not(.sapMCbBgDis):not(.sapMCbHasLabel).sapMCb:focus::before, html[data-sap-ui-browser*="ie"] .clearFocusRing .sapUiTableColHdrCnt .sapUiTableSelAllEnabled.sapUiTableColRowHdr :not(.sapMCbBgDis):not(.sapMCbHasLabel).sapMCb:focus::before, html[data-sap-ui-browser*="ed"] .clearFocusRing .sapUiTableColHdrCnt .sapUiTableSelAllEnabled.sapUiTableColRowHdr :not(.sapMCbBgDis):not(.sapMCbHasLabel).sapMCb:focus::before, html[data-sap-ui-browser*="ie"] .clearFocusRing .sapUiTableCnt .sapUiTableRowHdr .sapMRb:focus::before, html[data-sap-ui-browser*="ed"] .clearFocusRing .sapUiTableCnt .sapUiTableRowHdr .sapMRb:focus::before, html[data-sap-ui-browser*="ie"] .clearFocusRing .sapUiTable .sapMRbB:focus::after, html[data-sap-ui-browser*="ed"] .clearFocusRing .sapUiTable .sapMRbB:focus::after, html[data-sap-ui-browser*="ie"] .clearFocusRing .sapUiTable .sapUiTableCol:focus, html[data-sap-ui-browser*="ed"] .clearFocusRing .sapUiTable .sapUiTableCol:focus, html[data-sap-ui-browser*="ie"] .clearFocusRing .sapUiTableTr > td:focus, html[data-sap-ui-browser*="ed"] .clearFocusRing .sapUiTableTr > td:focus', 'styles':{'box-shadow':'none !important;'}},
                {'selector':'.sasCustomFocusIndicatorStyles.clearFocusRing .sapMFocus.sapMInputBaseReadonly .sapMInputDivWrapper:before,.sasCustomFocusIndicatorStyles.clearFocusRing .sapMFocus.sapMInputBaseDisabled .sapMInputDivWrapper:before,.sasCustomFocusIndicatorStyles.clearFocusRing .sapMFocus.sapMTextArea.sapMInputBaseReadonly:after,.sasCustomFocusIndicatorStyles.clearFocusRing .sapMFocus.sapMTextArea.sapMInputBaseDisabled:after', 'styles':{'border':'none !important'}}
            ]
        };

        return sas.hc.ui.core;
    }
);
