// (c) 2014, SAS Institute Inc.

sap.ui.define(['jquery.sap.global', 'sap/ui/core/Core', 'sas/hc/ui/core/Core'
],
    function(jQuery) {
        "use strict";

        /**
         * @namespace
         * @name sas.hc.ui.commons
         * @public
         */

        /**
         * @namespace
         * @name sas.hc.ui.commons.banner
         * @public
         */

        /**
         * @namespace
         * @name sas.hc.ui.commons.banner.help
         * @public
         */

        /**
         * @namespace
         * @name sas.hc.ui.commons.breadcrumb
         * @public
         */

        /**
         * @namespace
         * @name sas.hc.ui.commons.dualselector
         * @public
         */

        /**
         * @namespace
         * @name sas.hc.ui.commons.facetFilter
         * @public
         */

        /**
         * @namespace
         * @name sas.hc.ui.commons.facetFilter.listFacetClasses
         * @public
         */

        /**
         * @namespace
         * @name sas.hc.ui.commons.formControl
         * @public
         */

        /**
         * @namespace
         * @name sas.hc.ui.commons.formControl.controls
         * @public
         */

        /**
         * @namespace
         * @name sas.hc.ui.commons.formControl.uiconfig
         * @public
         */

        /**
         * @namespace
         * @name sas.hc.ui.commons.formControl.views
         * @public
         */

        /**
         * @namespace
         * @name sas.hc.ui.commons.keyboardShortcuts
         * @public
         */

        /**
         * @namespace
         * @name sas.hc.ui.commons.landmarks
         * @public
         */

        /**
         * @namespace
         * @name sas.hc.ui.commons.logViewer
         * @public
         */

        /**
         * @namespace
         * @name sas.hc.ui.commons.navigation
         * @public
         */

        /**
         * @namespace
         * @name sas.hc.ui.commons.notifications
         * @public
         */

        /**
         * @namespace
         * @name sas.hc.ui.commons.propPane
         * @public
         */

        /**
         * @namespace
         * @name sas.hc.ui.commons.recent
         * @public
         */

        /**
         * @namespace
         * @name sas.hc.ui.commons.settings
         * @public
         */

        /**
         * @namespace
         * @name sas.hc.ui.commons.settings.controls
         * @public
         */

        /**
         * @namespace
         * @name sas.hc.ui.commons.settings.providers
         * @public
         */

        /**
         * @namespace
         * @name sas.hc.ui.commons.settings.utils
         * @public
         */

        /**
         * @namespace
         * @name sas.hc.ui.commons.verticalTab
         * @public
         */

        /**
         * @namespace
         * @name sas.hc.ui.commons.windowshade
         * @public
         */

        /**
         * @namespace
         * @name sas.hc.ui.commons.wizard
         * @public
         */

        // delegate further initialization of this library to the Core
        sap.ui.getCore().initLibrary({
            name : "sas.hc.ui.commons",
            dependencies : [
                "sap.ui.core",
                "sap.ui.commons",
                "sap.ui.layout",
                "sap.ui.ux3",
                "sas.hc.ui.layout",
                "sas.ltjs.sasicu",
                "sas.hc.ui.services.search",
                "sas.hc.ui.table"],
            types : [
                "sas.hc.ui.commons.CustomControlType"
            ],
            interfaces : [
                "sas.hc.ui.commons.formControl/ControlFactoryInterface",
                "sas.hc.ui.commons.formControl/views/FormFactoryInterface"
            ],
            controls : [
                "sas.hc.ui.commons.Accordion",
                "sas.hc.ui.commons.AccordionSection",
                "sas.hc.ui.commons.ApplicationHeader",
                "sas.hc.ui.commons.AppSwitcherMenu",
                "sas.hc.ui.commons.Area",
                "sas.hc.ui.commons.AutoComplete",
                "sas.hc.ui.commons.Avatar",
                "sas.hc.ui.commons.BadgeButton",
                "sas.hc.ui.commons.Button",
                "sas.hc.ui.commons.Callout",
                "sas.hc.ui.commons.CalloutBase",
                "sas.hc.ui.commons.Carousel",
                "sas.hc.ui.commons.CascadeSelect",
                "sas.hc.ui.commons.CascadeSelectItem",
                "sas.hc.ui.commons.CheckBox",
                "sas.hc.ui.commons.ColorPicker",
                "sas.hc.ui.commons.ComboBox",
                "sas.hc.ui.commons.CompositeControl",
                "sas.hc.ui.commons.DatePicker",
                "sas.hc.ui.commons.Dialog",
                "sas.hc.ui.commons.DropdownBox",
                "sas.hc.ui.commons.FileUploader",
                "sas.hc.ui.commons.FileUploaderParameter",
                "sas.hc.ui.commons.FindAndReplaceDialog",
                "sas.hc.ui.commons.FormattedTextView",
                "sas.hc.ui.commons.HorizontalDivider",
                "sas.hc.ui.commons.Image",
                "sas.hc.ui.commons.ImageMap",
                "sas.hc.ui.commons.InPlaceEdit",
                "sas.hc.ui.commons.Label",
                "sas.hc.ui.commons.LeftNav",
                "sas.hc.ui.commons.LeftNavBuilder",
                "sas.hc.ui.commons.LeftNavContainer",
                "sas.hc.ui.commons.LeftNavItem",
                "sas.hc.ui.commons.Link",
                "sas.hc.ui.commons.ListBox",
                "sas.hc.ui.commons.Menu",
                "sas.hc.ui.commons.MenuBar",
                "sas.hc.ui.commons.MenuButton",
                "sas.hc.ui.commons.MenuButton_A11Y",
                "sas.hc.ui.commons.MenuItem",
                "sas.hc.ui.commons.MenuItemBase",
                "sas.hc.ui.commons.MenuTextFieldItem",
                "sas.hc.ui.commons.Message",
                "sas.hc.ui.commons.MessageBar",
                "sas.hc.ui.commons.MessageBox",
                "sas.hc.ui.commons.MessageList",
                "sas.hc.ui.commons.MessageToast",
                "sas.hc.ui.commons.Paginator",
                "sas.hc.ui.commons.Panel",
                "sas.hc.ui.commons.PasswordField",
                "sas.hc.ui.commons.ProgressIndicator",
                "sas.hc.ui.commons.RadioButton",
                "sas.hc.ui.commons.RadioButtonGroup",
                "sas.hc.ui.commons.RatingIndicator",
                "sas.hc.ui.commons.ResponsiveContainer",
                "sas.hc.ui.commons.ResponsiveContainerRange",
                "sas.hc.ui.commons.RichTooltip",
                "sas.hc.ui.commons.RoadMap",
                "sas.hc.ui.commons.RoadMapStep",
                "sas.hc.ui.commons.RowRepeater",
                "sas.hc.ui.commons.RowRepeaterFilter",
                "sas.hc.ui.commons.RowRepeaterSorter",
                "sas.hc.ui.commons.SearchField",
                "sas.hc.ui.commons.SearchProvider",
                "sas.hc.ui.commons.SegmentedButton",
                "sas.hc.ui.commons.SessionTimeoutDialog",
                "sas.hc.ui.commons.SplitButton",
                "sas.hc.ui.commons.Splitter",
                "sas.hc.ui.commons.Tab",
                "sas.hc.ui.commons.TabStrip",
                "sas.hc.ui.commons.TextArea",
                "sas.hc.ui.commons.TextField",
                "sas.hc.ui.commons.TextView",
                "sas.hc.ui.commons.Title",
                "sas.hc.ui.commons.ToggleButton",
                "sas.hc.ui.commons.Toolbar",
                "sas.hc.ui.commons.ToolbarSeparator",
                "sas.hc.ui.commons.Tree",
                "sas.hc.ui.commons.TreeNode",
                "sas.hc.ui.commons.LargeTree",
                "sas.hc.ui.commons.LargeTreeKeyboardExtension",
                "sas.hc.ui.commons.LargeTreeKeyboardDelegate",
                "sas.hc.ui.commons.TriStateCheckBox",
                "sas.hc.ui.commons.ValueHelpField",
                "sas.hc.ui.commons.banner.Banner",
                "sas.hc.ui.commons.banner.BannerV",
                "sas.hc.ui.commons.banner.BannerHeadingV",
                "sas.hc.ui.commons.banner.BannerAvatarMenuItemUnified",
                "sas.hc.ui.commons.banner.BannerObjectMarker",
                "sas.hc.ui.commons.banner.BannerAvatarMenuItem",
                "sas.hc.ui.commons.banner.BannerOptionsMenuButton",
                "sas.hc.ui.commons.banner.FirstInitialButton",
                "sas.hc.ui.commons.banner.BannerOverflowToolbarLayoutData",
                "sas.hc.ui.commons.banner.help.AboutContentPETProvider",
                "sas.hc.ui.commons.banner.help.AboutContentProvider",
                "sas.hc.ui.commons.banner.help.AboutPopover",
                "sas.hc.ui.commons.banner.help.AbstractAboutModel",
                "sas.hc.ui.commons.banner.help.DefaultHelpPage",
                "sas.hc.ui.commons.banner.help.HelpAboutController",
                "sas.hc.ui.commons.banner.help.HelpCenterPage",
                "sas.hc.ui.commons.banner.help.HelpCenterService",
                "sas.hc.ui.commons.banner.help.HelpContentProvider",
                "sas.hc.ui.commons.banner.help.HelpPopover",
                "sas.hc.ui.commons.banner.help.WebDocService",
                "sas.hc.ui.commons.breadcrumb.Breadcrumb",
                "sas.hc.ui.commons.breadcrumb.BreadcrumbConfirmationSelect",
                "sas.hc.ui.commons.breadcrumb.BreadcrumbItem",
                "sas.hc.ui.commons.breadcrumb.BreadcrumbListItem",
                "sas.hc.ui.commons.breadcrumb.InteractiveBreadcrumbItem",
                "sas.hc.ui.commons.breadcrumb.InteractiveBreadcrumbSelect",
                "sas.hc.ui.commons.breadcrumb.InteractiveBreadcrumbSelectList",
                "sas.hc.ui.commons.dualselector.DualSelector",
                "sas.hc.ui.commons.dualselector.delegates.DualSelectorDelegate",
                "sas.hc.ui.commons.dualselector.delegates.ListDelegate",
                "sas.hc.ui.commons.dualselector.delegates.TableDelegate",
                "sas.hc.ui.commons.dualselector.dsCustomAssets.DualSelectorStandardListItem",
                "sas.hc.ui.commons.dualselector.dsCustomAssets.DualSelectorTextItem",
                "sas.hc.ui.commons.dualselector.dsLayouts.ListLayout",
                "sas.hc.ui.commons.dualselector.dsLayouts.MoveLayout",
                "sas.hc.ui.commons.dualselector.dsLayouts.ReShuffleLayout",
                "sas.hc.ui.commons.dualselector.dsLayouts.SourceLayout",
                "sas.hc.ui.commons.dualselector.dsLayouts.TargetLayout",
                "sas.hc.ui.commons.dualselector.dsMove.MoveManager",
                "sas.hc.ui.commons.dualselector.dsMove.ReShuffleManager",
                "sas.hc.ui.commons.facetFilter.BaseFacet",
                "sas.hc.ui.commons.facetFilter.BaseFilterProvider",
                "sas.hc.ui.commons.facetFilter.DateRangeFacet",
                "sas.hc.ui.commons.facetFilter.FacetAccordion",
                "sas.hc.ui.commons.facetFilter.FacetPanel",
                "sas.hc.ui.commons.facetFilter.FacetToken",
                "sas.hc.ui.commons.facetFilter.FacetTokenizer",
                "sas.hc.ui.commons.facetFilter.FilterUtil",
                "sas.hc.ui.commons.facetFilter.InputFacet",
                "sas.hc.ui.commons.facetFilter.ListFacet",
                "sas.hc.ui.commons.facetFilter.ListFacetListItem",
                "sas.hc.ui.commons.facetFilter.ListFacetRadioListItem",
                "sas.hc.ui.commons.facetFilter.ModelFilterProvider",
                "sas.hc.ui.commons.facetFilter.NoFilterListItem",
                "sas.hc.ui.commons.facetFilter.NumericRangeFacet",
                "sas.hc.ui.commons.facetFilter.PageableListFacet",
                "sas.hc.ui.commons.facetFilter.RemoteFilterProvider",
                "sas.hc.ui.commons.facetFilter.SearchServiceFilterProvider",
                "sas.hc.ui.commons.facetFilter.SelectAllListItem",
                "sas.hc.ui.commons.facetFilter.facetSettings.facetSettingsDialog",
                "sas.hc.ui.commons.facetFilter.facetSettings.facetSettingsView",
                "sas.hc.ui.commons.facetFilter.listFacetClasses.DefaultListFacetImpl",
                "sas.hc.ui.commons.facetFilter.listFacetClasses.MoreDialog",
                "sas.hc.ui.commons.facetFilter.listFacetClasses.MoreView",
                "sas.hc.ui.commons.facetFilter.listFacetClasses.PageableListFacetImpl",
                "sas.hc.ui.commons.form.Form",
                "sas.hc.ui.commons.form.FormContainer",
                "sas.hc.ui.commons.form.FormElement",
                "sas.hc.ui.commons.form.FormLayout",
                "sas.hc.ui.commons.form.GridContainerData",
                "sas.hc.ui.commons.form.GridElementData",
                "sas.hc.ui.commons.form.GridLayout",
                "sas.hc.ui.commons.form.ResponsiveLayout",
                "sas.hc.ui.commons.form.SimpleForm",
                "sas.hc.ui.commons.formControl.CompositeField",
                "sas.hc.ui.commons.formControl.ControlFactory",
                "sas.hc.ui.commons.formControl.DynamicField",
                "sas.hc.ui.commons.formControl.Field",
                "sas.hc.ui.commons.formControl.FieldBase",
                "sas.hc.ui.commons.formControl.FormControl",
                "sas.hc.ui.commons.formControl.FormControlLayout",
                "sas.hc.ui.commons.formControl.Group",
                "sas.hc.ui.commons.formControl.ModelObject",
                "sas.hc.ui.commons.formControl.Prompt",
                "sas.hc.ui.commons.formControl.PropertyPropagator",
                "sas.hc.ui.commons.formControl.builders.DynamicFieldBuilder",
                "sas.hc.ui.commons.formControl.builders.FormBuilder",
                "sas.hc.ui.commons.formControl.builders.FormElementBuilder",
                "sas.hc.ui.commons.formControl.builders.FormFieldBuilder",
                "sas.hc.ui.commons.formControl.builders.LayoutManager",
                "sas.hc.ui.commons.formControl.controls.DateRange",
                "sas.hc.ui.commons.formControl.uiconfig.ActionButtonUIConfig",
                "sas.hc.ui.commons.formControl.uiconfig.CascadeSelectUIConfig",
                "sas.hc.ui.commons.formControl.uiconfig.ClassInstanceUIConfig",
                "sas.hc.ui.commons.formControl.uiconfig.ComboBoxUIConfig",
                "sas.hc.ui.commons.formControl.uiconfig.CompositeInputUIConfig",
                "sas.hc.ui.commons.formControl.uiconfig.CompositeSelectUIConfig",
                "sas.hc.ui.commons.formControl.uiconfig.DualSelectorUIConfig",
                "sas.hc.ui.commons.formControl.uiconfig.ListUIConfig",
                "sas.hc.ui.commons.formControl.uiconfig.SegmentedButtonUIConfig",
                "sas.hc.ui.commons.formControl.uiconfig.SliderUIConfig",
                "sas.hc.ui.commons.formControl.uiconfig.SwitchUIConfig",
                "sas.hc.ui.commons.formControl.uiconfig.TableUIConfig",
                "sas.hc.ui.commons.formControl.uiconfig.UIConfig",
                "sas.hc.ui.commons.formControl.views.FieldLayoutData",
                "sas.hc.ui.commons.formControl.views.Form",
                "sas.hc.ui.commons.formControl.views.FormContainer",
                "sas.hc.ui.commons.formControl.views.FormControlAccordionView",
                "sas.hc.ui.commons.formControl.views.FormControlInput",
                "sas.hc.ui.commons.formControl.views.FormControlInputFormatter",
                "sas.hc.ui.commons.formControl.views.FormControlInputRangeValidationAdapter",
                "sas.hc.ui.commons.formControl.views.FormControlLabel",
                "sas.hc.ui.commons.formControl.views.FormControlList",
                "sas.hc.ui.commons.formControl.views.FormControlListItem",
                "sas.hc.ui.commons.formControl.views.FormControlListView",
                "sas.hc.ui.commons.formControl.views.FormControlPanel",
                "sas.hc.ui.commons.formControl.views.FormControlResponsiveGridLayout",
                "sas.hc.ui.commons.formControl.views.FormControlView",
                "sas.hc.ui.commons.formControl.views.FormElement",
                "sas.hc.ui.commons.formControl.views.FormFactory",
                "sas.hc.ui.commons.formControl.views.GroupLayoutData",
                "sas.hc.ui.commons.keyboardShortcuts.DisplayDialog",
                "sas.hc.ui.commons.keyboardShortcuts.EditableDialog",
                "sas.hc.ui.commons.keyboardShortcuts.FileImporter",
                "sas.hc.ui.commons.keyboardShortcuts.KeyboardShortcuts",
                "sas.hc.ui.commons.keyboardShortcuts.KeyHelper",
                "sas.hc.ui.commons.keyboardShortcuts.ShortcutsInput",
                "sas.hc.ui.commons.keyboardShortcuts.Utils",
                "sas.hc.ui.commons.landmarks.Landmarks",
                "sas.hc.ui.commons.layout.AbsoluteLayout",
                "sas.hc.ui.commons.layout.BorderLayout",
                "sas.hc.ui.commons.layout.BorderLayoutArea",
                "sas.hc.ui.commons.layout.HorizontalLayout",
                "sas.hc.ui.commons.layout.MatrixLayout",
                "sas.hc.ui.commons.layout.MatrixLayoutCell",
                "sas.hc.ui.commons.layout.MatrixLayoutRow",
                "sas.hc.ui.commons.layout.PositionContainer",
                "sas.hc.ui.commons.layout.ResponsiveFlowLayout",
                "sas.hc.ui.commons.layout.ResponsiveFlowLayoutData",
                "sas.hc.ui.commons.layout.VerticalLayout",
                "sas.hc.ui.commons.logViewer.LogViewer",
                "sas.hc.ui.commons.navigation.AbstractContentNavigationModel",
                "sas.hc.ui.commons.navigation.AbstractDataDescriptor",
                "sas.hc.ui.commons.navigation.AbstractOperationsResultDescriptor",
                "sas.hc.ui.commons.navigation.AbstractPermissionsDescriptor",
                "sas.hc.ui.commons.navigation.AbstractTypeDescriptor",
                "sas.hc.ui.commons.navigation.AbstractValidationResultDescriptor",
                "sas.hc.ui.commons.notifications.NotificationList",
                "sas.hc.ui.commons.notifications.NotificationListItem",
                "sas.hc.ui.commons.notifications.NotificationsBadge",
                "sas.hc.ui.commons.propPane.PropertyPane",
                "sas.hc.ui.commons.propPane.PropertyPaneLayout",
                "sas.hc.ui.commons.queryBuilder.BaseGroupNode",
                "sas.hc.ui.commons.queryBuilder.BaseNode",
                "sas.hc.ui.commons.queryBuilder.QueryBuilder",
                "sas.hc.ui.commons.recent.RecentDialog",
                "sas.hc.ui.commons.recent.RecentDialogAbstractModel",
                "sas.hc.ui.commons.recent.RecentDialogPETModel",
                "sas.hc.ui.commons.recent.RecentDialogWIPModel",
                "sas.hc.ui.commons.settings.AbstractSettingsService",
                "sas.hc.ui.commons.settings.DefaultSideMenuService",
                "sas.hc.ui.commons.settings.PetrichorSettingsAdapterService",
                "sas.hc.ui.commons.settings.Settings",
                "sas.hc.ui.commons.settings.SettingsManager",
                "sas.hc.ui.commons.settings.WIPSettingsService",
                "sas.hc.ui.commons.settings.controls.FocusPreview",
                "sas.hc.ui.commons.settings.controls.MessageResetter",
                "sas.hc.ui.commons.settings.controls.ProfilePictureChooser",
                "sas.hc.ui.commons.settings.controls.SideMenuList",
                "sas.hc.ui.commons.settings.controls.SideMenuListItem",
                "sas.hc.ui.commons.settings.controls.ThemeChooser",
                "sas.hc.ui.commons.settings.providers.AbstractSettingsProvider",
                "sas.hc.ui.commons.settings.providers.GlobalSettingsProvider",
                "sas.hc.ui.commons.settings.providers.HomeSettingsProvider",
                "sas.hc.ui.commons.settings.utils.FieldAndGroupUtil",
                "sas.hc.ui.commons.themeDesigner.ApplicationThemePopup",
                "sas.hc.ui.commons.themeDesigner.BackListItem",
                "sas.hc.ui.commons.themeDesigner.Constants",
                "sas.hc.ui.commons.themeDesigner.DataPalette",
                "sas.hc.ui.commons.themeDesigner.ImageHelper",
                "sas.hc.ui.commons.themeDesigner.InContextHelper",
                "sas.hc.ui.commons.themeDesigner.LessController",
                "sas.hc.ui.commons.themeDesigner.LessSupport",
                "sas.hc.ui.commons.themeDesigner.ServerActions",
                "sas.hc.ui.commons.themeDesigner.ValidationInput",
                "sas.hc.ui.commons.themeDesigner.actions.ActionHelper",
                "sas.hc.ui.commons.themeDesigner.actions.ChangeBooleanAction",
                "sas.hc.ui.commons.themeDesigner.actions.ChangeColorAction",
                "sas.hc.ui.commons.themeDesigner.actions.ChangeDataPaletteColorAction",
                "sas.hc.ui.commons.themeDesigner.actions.ChangeFontAction",
                "sas.hc.ui.commons.themeDesigner.actions.ChangeImageAction",
                "sas.hc.ui.commons.themeDesigner.actions.EventHelper",
                "sas.hc.ui.commons.themeDesigner.actions.ResetOverridesAction",
                "sas.hc.ui.commons.themeDesigner.actions.SaveHelper",
                "sas.hc.ui.commons.themeDesigner.control.ImageImporter",
                "sas.hc.ui.commons.themeDesigner.services.Constants",
                "sas.hc.ui.commons.themeDesigner.services.CustomThemeService",
                "sas.hc.ui.commons.themeDesigner.services.PublishedCustomThemeService",
                "sas.hc.ui.commons.themeDesigner.services.ThemePublishJobService",
                "sas.hc.ui.commons.undoredo.UndoRedoButtons",
                "sas.hc.ui.commons.verticalTab.VerticalTab",
                "sas.hc.ui.commons.verticalTab.VerticalTabBar",
                "sas.hc.ui.commons.verticalTab.VerticalTabBarContainer",
                "sas.hc.ui.commons.verticalTab.VerticalTabSideBarContainer",
                "sas.hc.ui.commons.windowshade.WindowShade",
                "sas.hc.ui.commons.windowshade.WindowShadeSection",
                "sas.hc.ui.commons.windowshade.WindowShadeSectionLayoutData",
                "sas.hc.ui.commons.wizard.WizardComponent",
                "sas.hc.ui.commons.wizard.WizardStep",
                "sas.hc.ui.commons.KeyboardTooltipPopover",
                "sas.hc.ui.commons.KeyboardTooltipPopoverHandler"
            ],
            elements : [
            ],
            version : "904001.11.16.20251118090100_f0htmcm94p"
        });

        // import JSAppViewBuilder to register build to JSAppView.
        sap.ui.require(['sas/hc/ui/core/mvc/JSAppView'],function(JSAppView){
            JSAppView.builder = "sas/hc/ui/commons/JSAppViewBuilder";
        });
        sap.ui.require(['sas/hc/ui/core/mvc/JSMashupView'],function(JSMashupView){
            JSMashupView.builder = "sas/hc/ui/commons/JSMashupViewBuilder";
        });

        //lazy imports for MessageBox
        sap.ui.lazyRequire("sas.hc.ui.commons.SessionTimeoutDialog", "show");

        jQuery.sap.require('sap.ui.Device');
        jQuery.sap.require("sas.hc.ui.core.util");
        if (sap.ui.Device.system.desktop) {
            var fnNewKeyboardTooltipPopoverHandler = function () {
                var KeyboardTooltipPopoverHandler = sap.ui.requireSync("sas/hc/ui/commons/KeyboardTooltipPopoverHandler");
                new KeyboardTooltipPopoverHandler();
            };

            sas.eventBus.subscribe(sas.hc.ui.core.util.APP_READY, function () {
                if (!sap.ui.getCore().isThemeApplied()) {
                    sap.ui.getCore().attachThemeChanged(fnNewKeyboardTooltipPopoverHandler);
                } else {
                    fnNewKeyboardTooltipPopoverHandler();
                }
            }, this);
        }

        /////////////////////////////////////////////////////////
        ////Constants for FacetPanel HTMLCOMMONS-5720////
        //////////////////////////////////////////////////////////
        sas.hc.ui.commons.facetFilter = sas.hc.ui.commons.facetFilter || {};
        sas.hc.ui.commons.facetFilter.queryOperators = {
            IN : "IN",
            NOT_IN : "NOT_IN"
        };

        /**
         * Different types of the Custom control that can be added to the DualSelctor.
         *
         * @enum {string}
         * @public
         */
        sas.hc.ui.commons.dualselector.CustomControlType = {
            /*eslint-disable shikari/sas-i18n-ems */
            Text: "Text",
            /*eslint-enable shikari/sas-i18n-ems */
            Number: "Number",
            DateTimeComposite: "DateTimeComposite",
            None: "None"
        };

        sap.ui.require(["sas/hc/ui/core/CommonsDialogDisplayHelper"], function(CommonsDialogDisplayHelper) {
            //register this object as provider.
            CommonsDialogDisplayHelper.provider = "sas/hc/ui/commons/CommonsDialogDisplayHelperImpl";
        });

        // initialize landmarks on app ready.
        sas.eventBus.subscribeOnce(sas.hc.ui.core.util.APP_READY, function () {
            var Landmarks = sap.ui.requireSync("sas/hc/ui/commons/landmarks/Landmarks");
            Landmarks.getSingleton().initWatch();
        });

        return sas.hc.ui.commons;
    }
);
