/**
 * Provides helper sas.hc.ui.commons.LargeTreeKeyboardDelegate
 *
 * @class Extension for sas.hc.ui.commons.LargeTreeKeyboardDelegate which handles keyboard related things.
 *
 * @extends sas.hc.ui.table.TableKeyboardDelegate
 * @author SAS
 * @version 904001.11.16.20251118090100_f0htmcm94p
 * @constructor
 * @private
 */

sap.ui.define(['sas/hc/ui/table/TableKeyboardDelegate', 'sas/hc/ui/table/TableGrouping'],
    function(TableKeyboardDelegate, TableGrouping) {
        "use strict";

        var LargeTreeKeyboardDelegate = TableKeyboardDelegate.extend("sas.hc.ui.commons.LargeTreeKeyboardDelegate", {});

        /*Opens the tree node when click on right arrow key and closes it when click on left arrow key*/
        LargeTreeKeyboardDelegate.prototype.onkeyup = function(oEvent) {
            if (oEvent.keyCode === jQuery.sap.KeyCodes.ARROW_RIGHT) {
                if (LargeTreeKeyboardDelegate.toggleGroupHeader(this, oEvent.target, true)) {
                    oEvent.preventDefault();
                    return;
                }
            } else if(oEvent.keyCode === jQuery.sap.KeyCodes.ARROW_LEFT) {
                if (LargeTreeKeyboardDelegate.toggleGroupHeader(this, oEvent.target, false)) {
                    oEvent.preventDefault();
                    return;
                }
            }
        };

        /*Navigate using up/down arrow key and press Enter key selects row*/
        LargeTreeKeyboardDelegate.prototype.onkeydown = function(oEvent) {
            if (oEvent.keyCode === jQuery.sap.KeyCodes.ENTER) {
                oEvent.preventDefault(); // To prevent the browser window to scroll down.
                oEvent.stopImmediatePropagation(true);
                this._onSelect(oEvent);
            }
        };

        //S1414433
        LargeTreeKeyboardDelegate.toggleGroupHeader  = function(oTable, oRef, bExpand) {
            var $Ref = jQuery(oRef),
                $GroupRef;

            if ($Ref.hasClass("sapUiTableTd")) {
                $GroupRef = $Ref.closest("tr");
            }
            var oBinding = oTable.getBinding("rows");
            if ($GroupRef && $GroupRef.length > 0 && oBinding) {
                var iRowIndex = oTable.getFirstVisibleRow() + parseInt($GroupRef.attr("data-sap-ui-rowindex"), 10);
                var bIsExpanded = TableGrouping.toggleGroupHeader(oTable, iRowIndex, bExpand);
                var bChanged = bIsExpanded === true || bIsExpanded === false;
                if (bChanged && oTable._onGroupHeaderChanged) {
                    oTable._onGroupHeaderChanged(iRowIndex, bIsExpanded);
                }
                return bChanged;
            }
            return false;
        };

        return LargeTreeKeyboardDelegate;
    });
