// (c) 2014, SAS Institute Inc.

jQuery.sap.declare("sas.hc.typescript.library");
jQuery.sap.require("sap.ui.core.Core");

/**
 * @namespace
 * @name sas.hc.typescript
 * @public
*/

// library dependencies
jQuery.sap.require("sap.ui.core.library");


/*
* Define bridge functions for OpenUI and TypeScript.  Pulled from VACommons library.js
*/
(function() {
    //Coppied from sap-ui-core.js
    // Name conversion function that converts a name in unified resource name syntax to a name in UI5 module name syntax.
    var urnToUI5 = function(sName) {
        if ( /\.js$/.test(sName) ) {
            sName = sName.slice(0, -3);
        }

        if ( /^sap\/ui\/thirdparty\/jquery\/jquery-/.test(sName) ) {
            return "sap.ui.thirdparty.jquery.jquery-" + sName.slice("sap/ui/thirdparty/jquery/jquery-".length);
        } else if ( /^jquery\.sap\./.test(sName) ) {
            return sName; // do nothing
        }
        return sName.replace(/\//g, ".");
    };

    //can't do relative paths since OpenUI does not share context.
    // Use our own relative require to sort of match amd.
    var require = function(fullPath) {
        if (Array.isArray(fullPath) && arguments.length > 1)
            return sap.ui.require.apply(this, arguments);

        //Make sure the file is loaded. If not then request it.
        //  Amd doesn't do this, but if meets some of your requrements.
        jQuery.sap.require(urnToUI5(fullPath));

        return sap.ui.require(fullPath);
    };

    window.define = function(name, deps, container) {
        //special case: typings/sashc is not a real dependancy
        var specialCases = ["require", "exports", "module", "typings/sashc"];
        var specialIndexOfs = [];
        var i, len;
        var args = [name, deps, container];

        if(container === undefined) {
            container = deps;
            deps = name;
            args.pop();
        }
        if(deps === undefined) {
            container = deps;
            deps === undefined;
            args.pop();
        }
        if(deps) {
            for(i = 0, len = specialCases.length; i < len; ++i) {
                var index = specialIndexOfs[i] = deps.indexOf(specialCases[i]);
                if(index !== -1) {
                    deps.splice(index, 1);
                }
            }
        }

        if(deps)  {
            args[args.length - 1 ] = function(){
                //for loop to avoid v8 deoptimization. https://github.com/petkaantonov/bluebird/wiki/Optimization-killers#3-managing-arguments
                var export_args = [];
                var module =  {
                    exports: {}
                };
                for(i = 0, len = arguments.length; i < len; ++i) {
                    export_args.push(arguments[i]);
                }
                //reverse for loop so instertion matches removal.
                for(i =  specialCases.length - 1; i >= 0; --i) {
                    var index = specialIndexOfs[i];
                    if(index !== -1) {
                        switch(specialCases[i]) {
                            case "require" :
                                export_args.splice(index, 0, require);
                                break;
                            case "module":
                                export_args.splice(index, 0, module);
                                break;
                            case "exports":
                                export_args.splice(index, 0, module.exports);
                                break;
                            default:
                                export_args.splice(index, 0, window); //work arround modules using typings/sashc's  _ variable as a window object
                        }
                    }
                }
                if( typeof container === "function") {
                    return container.apply(window, export_args) || module.exports;
                }
                return container;
            };
        }

        args.push(true); //export result to global namespace.
        sap.ui.define.apply(window, args);
    };

    window.openuiExtend = function(string, container, base) {
        var key;
        var proto = {};
        for (key in container.prototype) {
            if (container.prototype.hasOwnProperty(key))
                proto[key] = container.prototype[key];
        }
        if (container.metadata) proto.metadata=container.metadata;
        if (container.renderer) proto.renderer=container.renderer;
        proto.constructor = container;

        base.extend(string, proto);
    };

})();


// delegate further initialization of this library to the Core
sap.ui.getCore().initLibrary({
    name : "sas.hc.typescript",
    dependencies : ["sap.ui.core"],
    noLibraryCSS: true,
    types : [
    ],
    interfaces : [
    ],
    controls : [
    ],
    elements : [
    ],
    version : "904001.11.16.20251118090100_f0htmcm94p"});
