// (c) 2015, SAS Institute Inc.
sap.ui.define([
    "jquery.sap.global",
    "./_ObjectInspectorNamedButton",
    "sas/hc/ui/core/Core"
], function(jQuery, ObjectInspectorNamedButton, Core) {
    "use strict";

    // icon path constants
    var SELECTED_ICON_PATH = sas.icons.HC.FAVORITEDINDICATOR,
        NOT_SELECTED_ICON_PATH = sas.icons.HC.FAVORITENOTSELECTED;

    /**
     * Constructor for a new FavoritesButton.
     *
     * Handles state with the "selected" property.
     * Depending on state, a different icon will show.
     *
     * @class
     * @name sas.hc.m.objectInspector.FavoritesButton
     * @extends sas.hc.m.objectInspector.ObjectInspectorNamedButton
     * @version 904001.11.16.20251118090100_f0htmcm94p
     * @author Jonathan Brink
     * @constructor
     * @public
     */
    var FavoritesButton = ObjectInspectorNamedButton.extend("sas.hc.m.objectInspector.FavoritesButton", /** @lends sas.hc.m.objectInspector.FavoritesButton.prototype */ {
        metadata: {
            library: "sas.hc.m",
            properties: {
                selected: {type: "boolean", defaultValue: false, group: "Appearance"}
            }
        },
        renderer: {
        }
    });

    /**
     * init lifecycle callback.
     * @private
     */
    FavoritesButton.prototype.init = function() {
        if (ObjectInspectorNamedButton.prototype.init) {
            ObjectInspectorNamedButton.prototype.init.apply(this, arguments);
        }

        this.setType(ObjectInspectorNamedButton.FAVORITES);

        // set default icon
        this.setSelected(!!this.getSelected());

        this._onPress = this.toggleSelected.bind(this);
        this.attachPress(this._onPress);
    };

    FavoritesButton.prototype.exit = function() {
        if (ObjectInspectorNamedButton.prototype.exit) {
            ObjectInspectorNamedButton.prototype.exit.apply(this, arguments);
        }
        this._onPress = undefined;
    };

    FavoritesButton.prototype.clone = function() {
        var oClone = ObjectInspectorNamedButton.prototype.clone.apply(this, arguments);

        // fix "selected" event
        oClone.detachPress(this._onPress);
        oClone.attachPress(oClone.toggleSelected.bind(oClone));

        return oClone;
    };

    /**
     * "selected" property setter override
     * prevent invalidation
     * manages icon property value
     * @param {boolean} bSelected value of selected
     * @public
     */
    FavoritesButton.prototype.setSelected = function(bSelected) {
        this.setProperty('selected', bSelected, true);
        if (bSelected === true) {
            this.setIcon(SELECTED_ICON_PATH);
        } else {
            this.setIcon(NOT_SELECTED_ICON_PATH);
        }
    };

    /**
     * toggle the "selected" property
     * @public
     */
    FavoritesButton.prototype.toggleSelected = function() {
        var bNewSelectedState = true;
        if (this.getSelected() === true) {
            bNewSelectedState = false;
        }
        this.setSelected(bNewSelectedState);
    };

    return FavoritesButton;
}, /* bExport= */ true);
