// (c) 2014, SAS Institute Inc.

sap.ui.define(['jquery.sap.global', 'sap/ui/core/Core',
    "sap/m/library", // library dependency
    "sap/ui/core/library", // library dependency
    "sas/hc/tnt/library", // library dependency
    "sas/hc/ui/unified/library", // library dependency
    "sas/hc/ui/core/library", // library dependency
    "sas/ltjs/sasicu/library" // library dependency
],
    function(jQuery) {
        "use strict";

        /**
         * @namespace
         * @name sas.hc.m
         * @public
         */

        /**
         * @namespace
         * @name sas.hc.m.colorpicker
         * @public
         */

        /**
         * @namespace
         * @name sas.hc.m.colorpicker.layout
         * @public
         */

        /**
         * @namespace
         * @name sas.hc.m.delegate
         * @public
         */

        /**
         * @namespace
         * @name sas.hc.m.facetSearch
         * @public
         */

        /**
         * @namespace
         * @name sas.hc.m.fontChooser
         * @public
         */

        /**
         * @namespace
         * @name sas.hc.m.objectInspector
         * @public
         */

        /**
         * @namespace
         * @name sas.hc.m.slider
         * @public
         */

        /**
         * @namespace
         * @name sas.hc.m.slider.a11y
         * @public
         */

        /**
         * @namespace
         * @name sas.hc.m.tags
         * @public
         */

        /**
         * @namespace
         * @name sas.hc.m.tokenInput
         * @public
         */

        /**
         * @namespace
         * @name sas.hc.m.userGroup
         * @public
         */

        /**
         * @namespace
         * @name sas.hc.m.welcome
         * @public
         */

        // delegate further initialization of this library to the Core
        sap.ui.getCore().initLibrary({
            name: "sas.hc.m",
            dependencies: [
                "sap.m",
                "sap.ui.core",
                "sas.hc.tnt",
                "sas.hc.ui.unified",
                "sas.hc.ui.core",
                "sas.ltjs.sasicu"
            ],
            types: [
                "sas.hc.m.InputLabelPosition",
                "sas.hc.m.MessageDialogAction",
                "sas.hc.m.MessageDialogType",
                "sas.hc.m.MessageSummaryLayoutModeType",
                "sas.hc.m.MessageSummaryFilterButtonType",
                "sas.hc.m.TabState",
                "sas.hc.m.InfoFormat",
                "sas.hc.m.TabHeaderOrientation",
                "sas.hc.m.DialogSize",
            ],
            interfaces: [],
            controls: [
                "sas.hc.m.a11yHelper",
                "sas.hc.m.AbstractNumericFormatter",
                "sas.hc.m.ActionListItem",
                "sas.hc.m.ActionSelect",
                "sas.hc.m.ActionSheet",
                "sas.hc.m.App",
                "sas.hc.m.ARIALiveConstants",
                "sas.hc.m.ARIARoleConstants",
                "sas.hc.m.BannerHeading",
                "sas.hc.m.Bar",
                "sas.hc.m.BaseValidationAdapter",
                "sas.hc.m.BusyDialog",
                "sas.hc.m.BusyIndicator",
                "sas.hc.m.Button",
                "sas.hc.m.Carousel",
                "sas.hc.m.CheckBox-A11Y",
                "sas.hc.m.CheckBox",
                "sas.hc.m.ColorPickerResponsivePopover",
                "sas.hc.m.Column",
                "sas.hc.m.ColumnListItem",
                "sas.hc.m.ComboBox",
                "sas.hc.m.ComboBoxBase",
                "sas.hc.m.ComboBoxTextField",
                "sas.hc.m.CompositeInput",
                "sas.hc.m.CompositeInputPropertyItem",
                "sas.hc.m.CustomListItem",
                "sas.hc.m.CustomTile",
                "sas.hc.m.CustomTileStyled",
                "sas.hc.m.DatePicker",
                "sas.hc.m.DateRangeSelection",
                "sas.hc.m.DateTimeComposite",
                "sas.hc.m.DateTimeCompositeUtil",
                "sas.hc.m.DateTimeInput",
                "sas.hc.m.DateTimePicker",
                "sas.hc.m.DefaultNumericFormatter",
                "sas.hc.m.Dialog",
                "sas.hc.m.DisplayListItem",
                "sas.hc.m.ExpandableTextArea",
                "sas.hc.m.FacetFilter",
                "sas.hc.m.FacetFilterItem",
                "sas.hc.m.FacetFilterList",
                "sas.hc.m.FeedInput",
                "sas.hc.m.FeedListItem",
                "sas.hc.m.FlexBox",
                "sas.hc.m.FlexItemData",
                "sas.hc.m.FormattedText",
                "sas.hc.m.GroupHeaderListItem",
                "sas.hc.m.GroupToken",
                "sas.hc.m.GrowingEnablement",
                "sas.hc.m.GrowingList",
                "sas.hc.m.HBox",
                "sas.hc.m.Header",
                "sas.hc.m.Heading",
                "sas.hc.m.HelpPopup",
                "sas.hc.m.IconTabBar",
                "sas.hc.m.IconTabFilter",
                "sas.hc.m.IconTabHeader",
                "sas.hc.m.IconTabSeparator",
                "sas.hc.m.IconTabTextValidationAdapter",
                "sas.hc.m.Image",
                "sas.hc.m.Input",
                "sas.hc.m.InputBase",
                "sas.hc.m.InputListItem",
                "sas.hc.m.InputValidationAdapter",
                "sas.hc.m.Label",
                "sas.hc.m.Link",
                "sas.hc.m.List",
                "sas.hc.m.ListBase",
                "sas.hc.m.ListDesktopBehaviorEnablement",
                "sas.hc.m.ListItemBase",
                "sas.hc.m.ListItemDesktopBehaviorEnablement",
                "sas.hc.m.ListScrollEnablement",
                "sas.hc.m.MaxLengthValidationAdapter",
                "sas.hc.m.Menu",
                "sas.hc.m.MenuButton",
                "sas.hc.m.MenuItem",
                "sas.hc.m.MessageBox",
                "sas.hc.m.MessageDialog",
                "sas.hc.m.MessagePage",
                "sas.hc.m.MessagePopover",
                "sas.hc.m.MessagePopoverItem",
                "sas.hc.m.MessageStrip",
                "sas.hc.m.MessageSummary",
                "sas.hc.m.MessageToast",
                "sas.hc.m.MessageView",
                "sas.hc.m.MonthPicker",
                "sas.hc.m.MonthPickerDialog",
                "sas.hc.m.MultiComboBox",
                "sas.hc.m.MultiInput",
                "sas.hc.m.NavContainer",
                "sas.hc.m.NavListItem",
                "sas.hc.m.NumericStepper",
                "sas.hc.m.ObjectAttribute",
                "sas.hc.m.ObjectHeader",
                "sas.hc.m.ObjectIdentifier",
                "sas.hc.m.ObjectListItem",
                "sas.hc.m.ObjectMarker",
                "sas.hc.m.ObjectNumber",
                "sas.hc.m.ObjectStatus",
                "sas.hc.m.OverflowButton",
                "sas.hc.m.OverflowList",
                "sas.hc.m.OverflowListItem",
                "sas.hc.m.OverflowToolbar",
                "sas.hc.m.OverflowToolbarAssociativePopover",
                "sas.hc.m.OverflowToolbarAssociativePopoverControls",
                "sas.hc.m.OverflowToolbarButton",
                "sas.hc.m.OverflowToolbarLayoutData",
                "sas.hc.m.P13nColumnsItem",
                "sas.hc.m.P13nColumnsPanel",
                "sas.hc.m.P13nConditionPanel",
                "sas.hc.m.P13nDialog",
                "sas.hc.m.P13nDimMeasureItem",
                "sas.hc.m.P13nDimMeasurePanel",
                "sas.hc.m.P13nFilterItem",
                "sas.hc.m.P13nFilterPanel",
                "sas.hc.m.P13nGroupItem",
                "sas.hc.m.P13nGroupPanel",
                "sas.hc.m.P13nItem",
                "sas.hc.m.P13nPanel",
                "sas.hc.m.P13nSortItem",
                "sas.hc.m.P13nSortPanel",
                "sas.hc.m.Page",
                "sas.hc.m.PageableLayout",
                "sas.hc.m.PageAccessibleLandmarkInfo",
                "sas.hc.m.PagingButton",
                "sas.hc.m.Panel",
                "sas.hc.m.PDFViewer",
                "sas.hc.m.PlanningCalendar",
                "sas.hc.m.Popover",
                "sas.hc.m.PopoverPatches",
                "sas.hc.m.ProgressIndicator",
                "sas.hc.m.PullToRefresh",
                "sas.hc.m.QuarterPicker",
                "sas.hc.m.QuarterPickerDialog",
                "sas.hc.m.RadioButton",
                "sas.hc.m.RadioButtonGroup",
                "sas.hc.m.RangeValidationAdapter",
                "sas.hc.m.RatingIndicator",
                "sas.hc.m.ResponsivePopover",
                "sas.hc.m.ResponsiveToolbar",
                "sas.hc.m.ScrollContainer",
                "sas.hc.m.SearchButton",
                "sas.hc.m.SearchField",
                "sas.hc.m.SegmentedButton",
                "sas.hc.m.SegmentedButtonItem",
                "sas.hc.m.Select",
                "sas.hc.m.SelectDialog",
                "sas.hc.m.SelectList",
                "sas.hc.m.Shell",
                "sas.hc.m.Slider",
                "sas.hc.m.SplitApp",
                "sas.hc.m.SplitContainer",
                "sas.hc.m.StandardListItem",
                "sas.hc.m.StandardTile",
                "sas.hc.m.StandardTreeItem",
                "sas.hc.m.SuggestionItem",
                "sas.hc.m.Switch",
                "sas.hc.m.TabbableInterface",
                "sas.hc.m.Table",
                "sas.hc.m.TableSelectDialog",
                "sas.hc.m.TabStripSelectList",
                "sas.hc.m.Text",
                "sas.hc.m.TextArea",
                "sas.hc.m.Tile",
                "sas.hc.m.TileContainer",
                "sas.hc.m.TimePicker",
                "sas.hc.m.TimePickerComboBox",
                "sas.hc.m.TimePickerComboBoxes",
                "sas.hc.m.TimePickerSlider",
                "sas.hc.m.TimePickerSliders",
                "sas.hc.m.Title",
                "sas.hc.m.TitleCheckBox",
                "sas.hc.m.ToggleButton",
                "sas.hc.m.Token",
                "sas.hc.m.Tokenizer",
                "sas.hc.m.Toolbar",
                "sas.hc.m.ToolbarLayoutData",
                "sas.hc.m.ToolbarSeparator",
                "sas.hc.m.ToolbarSpacer",
                "sas.hc.m.ToolHeaderOverflowButton",
                "sas.hc.m.Tree",
                "sas.hc.m.TreeItemBase",
                "sas.hc.m.UploadCollection",
                "sas.hc.m.UploadCollectionItem",
                "sas.hc.m.UploadCollectionParameter",
                "sas.hc.m.UploadCollectionToolbarPlaceholder",
                "sas.hc.m.Validator",
                "sas.hc.m.VBox",
                "sas.hc.m.ViewSettingsCustomItem",
                "sas.hc.m.ViewSettingsDialog",
                "sas.hc.m.ViewSettingsFilterItem",
                "sas.hc.m.ViewSettingsItem",
                "sas.hc.m.WeekPicker",
                "sas.hc.m.WeekPickerDialog",
                "sas.hc.m.ZeroState",
                "sas.hc.m.colorpicker.ColorPicker",
                "sas.hc.m.colorpicker.layout.BasicCustomContent",
                "sas.hc.m.colorpicker.layout.ColorPickerContainer",
                "sas.hc.m.colorpicker.model.ColorChangeObject",
                "sas.hc.m.delegate.ValueStateMessage",
                "sas.hc.m.facetSearch.FacetSearch",
                "sas.hc.m.facetSearch.FacetSearchListItem",
                "sas.hc.m.facetSearch.FacetSearchListView",
                "sas.hc.m.facetSearch.FacetSearchModel",
                "sas.hc.m.fontChooser.CustomSelectList",
                "sas.hc.m.fontChooser.CustomStyleItem",
                "sas.hc.m.fontChooser.FontChooser",
                "sas.hc.m.fontChooser.FontChooserVO",
                "sas.hc.m.fontChooser.FontFamilySelect",
                "sas.hc.m.objectInspector.FormatUtil",
                "sas.hc.m.objectInspector.ObjectInspector",
                "sas.hc.m.objectInspector.ObjectInspectorBase",
                "sas.hc.m.slider.BaseSlider",
                "sas.hc.m.slider.DateTimeStepEnum",
                "sas.hc.m.slider.HorizontalSlider",
                "sas.hc.m.slider.InputTypeEnum",
                "sas.hc.m.slider.VerticalSlider",
                "sas.hc.m.slider.a11y.A11ySlider",
                "sas.hc.m.slider.operatorMenu.OperatorEnum",
                "sas.hc.m.tags.TagInput",
                "sas.hc.m.tags.TagDialog",
                "sas.hc.m.tags.TagInfoProvider",
                "sas.hc.m.tokenInput.TokenInput",
                "sas.hc.m.tokenInput.TokenInputInfoDataProvider",
                "sas.hc.m.tokenInput.TokenInputDialog",
                "sas.hc.m.userGroup.UserGroupSelector",
                "sas.hc.m.userGroup.UserGroupInput",
                "sas.hc.m.userGroup.UserGroupDialog",
                "sas.hc.m.userGroup.UserGroupInfoProvider",
                "sas.hc.m.util.DateUtil"
            ],
            elements: [],
            version: "904001.11.16.20251118090100_f0htmcm94p"
        });

        var thisLib = sas.hc.m;

        //Tell the Icon pool that we want to use our subclasses rather than the base SAP version
        sap.ui.require(["sap/ui/core/IconPool", "sas/hc/m/Image"], function(
            IconPool,
            Image
        ) {
            IconPool.setImageClass(Image);
        });
        /////////////////////////////////////////////////////
        // Monkey patch Custom styles.
        /////////////////////////////////////////////////////

        // moved to respective files.

        /////////////////////////////////////////////////////
        // END: Monkey patch for Custom styles.
        /////////////////////////////////////////////////////

        /**
         * A subset of input label position types that fit to a simple API returning one string.
         *
         * @enum {string}
         * @public
         * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
         */
        thisLib.InputLabelPosition = {
            /**
             * default (Left)
             * @public
             */
            Left: "Left",

            /**
             * An input control for specifying label position to be top.
             * @public
             */
            Top: "Top"
        };

        //storage for holding the enum for display Mode
        thisLib.ColorPickerDisplayModes = {};

        //The displayMode object; Picked string values and not objects as I am unsure in XML mode.
        Object.defineProperties(sas.hc.m.ColorPickerDisplayModes, {
            /**
             * This mode referred as <code>sas.hc.m.ColorPicker.BASIC</code>
             * always displays the BASIC Color Picker Tab of the Color Picker Container When opened.
             * @public
             */
            BASIC: { value: "basic", enumerable: true },

            /**
             * This mode referred as <code>sas.hc.m.ColorPicker.CUSTOM</code>
             * always displays the CUSTOM Color Picker Tab of the Color Picker Container When opened.
             * @public
             */
            CUSTOM: { value: "custom", enumerable: true }
        });

        //prevent new properties from being added.
        Object.freeze && Object.freeze(sas.hc.m.ColorPickerDisplayModes);

        /**
         * Enum for specifying various actions supported by MessageDialog
         * @enum {string}
         * @public
         */
        thisLib.MessageDialogAction = {
            Ok: "OK",
            Cancel: "CANCEL",
            Yes: "YES",
            No: "NO",
            Abort: "ABORT",
            Retry: "RETRY",
            Ignore: "IGNORE",
            Close: "CLOSE",
            Delete: "DELETE",
            Save: "SAVE",
            DontSave: "DONT_SAVE",
            Discard: "DISCARD",
            Apply: "APPLY",
            Reset: "RESET",
            CloseTab: "CLOSE_TAB",
            Continue: "CONTINUE"
        };

        /**
         * Enum for the available MessageDialog types
         * @enum {string}
         * @public
         */
        thisLib.MessageDialogType = {
            Information: "Information",
            Warning: "Warning",
            Error: "Error"
        };
        /**
         * Enum for specifying the different layout modes that MessageSummary supports
         *
         * * List Mode is best used for a flat list of messages that are relatively brief.
         * * NavigationList is best used when the message text or message detail can be lengthy.
         * * WindowShade is best used when the messages may be relevant to more than one item.
         *
         *
         * @enum {string}
         * @public
         */
        thisLib.MessageSummaryLayoutModeType = {
            List: "List",
            NavigationList: "NavigationList",
            WindowShade: "WindowShade"
        };

        /**
         * Enum for specifying the different message types that MessageSummary supports
         * @enum {string}
         * @public
         */
        thisLib.MessageSummaryFilterButtonType = {
            Information: "Information",
            Warning: "Warning",
            Error: "Error",
            Success: "Success"
        };

        /**
         * Different states for the Tab (sas.hc.m.IconTabFilter) in IconTabBar
         *
         * @enum {string}
         * @public
         */
        thisLib.TabState = {
            /**
             * State is readonly.
             * @public
             */
            ReadOnly: "ReadOnly",

            /**
             * State is not valid.
             * @public
             */
            Alert: "Alert",

            /**
             * State is valid.
             * @public
             */
            Ready: "Ready",

            /**
             * State indicates unsaved changes in the tab's content area.
             * @public
             */
            Dirty: "Dirty",

            /**
             * State is processing.
             * @public
             */
            Processing: "Processing",

            /**
             * State is not specified.
             * @public
             */
            None: "None"
        };

        /**
         * Enum for specifying different layout types for Dialog
         *
         * @enum {string}
         * @public
         */
        thisLib.DialogLayout = {
            /**
             * Layout is a fixed size. The height and width are determined by the size property regardless of the content. If size is set to Auto this layout is ignored.
             * @public
             */
            Fixed: "Fixed",

            /**
             * Layout is a responsive size. The height of the dialog is determined by the content. The size property determines min/max widths of the dialog. Auto sets the default min/max widths.
             * @public
             */
            Responsive: "Responsive"
        };

        /**
         * Enum for specifying different sizes for Dialog
         *
         * @enum {string}
         * @public
         */
        thisLib.DialogSize = {
            /**
             * Dialog is of size Auto. The "layout" property is ignored.
             * @public
             */
            Auto: "Auto",

            /**
             * Dialog is of size Large. If "layout" is set to FIXED this creates a 48x60rem dialog. If "layout" is set to Responsive; the dialog has a min/max width of 20rem - 48rem, and a max-height of 75% upto 60rem total. These values are subject to change by the UX specification.
             * @public
             */
            Large: "Large",

            /**
             * Dialog is of size Medium. If "layout" is set to FIXED this creates a 60x72rem dialog. If "layout" is set to Responsive; the dialog has a min/max width of 30rem - 72rem, and a max-height of 75% upto 60rem total. These values are subject to change by the UX specification.
             * @public
             */
            Medium: "Medium",

            /**
             * Dialog is of size small. If "layout" is set to FIXED this creates a 24x40rem dialog. If "layout" is set to Responsive; the dialog has a min/max width of 10rem - 24rem, and a max-height of 50% upto 40rem total. These values are subject to change by the UX specification.
             * @public
             */
            Small: "Small"
        };

        /**
         * Different text format options for the information text, which is the
         * {@link sas.hc.m.StandardListItem#setInfo info} property of StandardListItem.
         *
         * @see sas.hc.m.StandardListItem#setInfo
         * @enum {string}
         * @public
         * @since 8.0
         */
        thisLib.InfoFormat = {
            /**
             * Info text is separated from title/description, which is preferable for numeric values.
             * @public
             */
            Separated: "Separated",

            /**
             * Info text is concatenated with title/description, which is sometimes preferable for text strings.
             * @public
             */
            Concatenated: "Concatenated"
        };

        /**
         * Enum for specifying the orientation of sas.hc.m.IconTabHeader
         *
         * @enum {string}
         * @public
         */
        thisLib.TabHeaderOrientation = {
            /**
             * Orientation of IconTabHeader is horizontal.
             * @public
             */
            Horizontal: "Horizontal",

            /**
             * Orientation of IconTabHeader is vertical.
             * @public
             */
            Vertical: "Vertical"
        };

        /**
         * Pre-defined sizes for Tiles based on {@link sas.hc.m.TileBsae sas.hc.m.TileBase}.<br />
         * The `Auto` option will allow the natural FlexBox sizing to occur.<br />
         * Use `Custom` when the size doesn't match one of the other pre-defined sizes.
         * @enum {string}
         * @public
         * @since 8.0
         * @deprecated Since 9.0. Please use the Tile's `height` and `width` properties instead.
         */
        thisLib.TileSize = {
            Small: "Small",
            Medium: "Medium",
            Large: "Large",
            Auto: "Auto",
            Custom: "Custom"
        };

        /**
         * Height/Width values used when implementing `sas.hc.m.TileSize`.
         * @enum {string}
         * @private
         * @since 8.0
         * @deprecated Since 9.0. Used to implement TileBase's deprecated `size` property.
         */
        thisLib._TileSizeConfig = {
            Small: {
                width: "8rem",
                height: "9.5rem"
            },
            Medium: {
                width: "11rem",
                height: "11.2rem"
            },
            Large: {
                width: "18.75rem",
                height: "15.6rem"
            }
        };

        /**
         * Pre-defined width values used when setting a Tile's `width` property.
         * @enum {string}
         * @public
         * @since 9.0
         */
        thisLib.TileWidth = {
            Small: "7rem",
            Medium: "10rem",
            Large: "18rem"
        };

        /**
         * The type of accent border to apply.
         * Used by TileBase's `accentBorderType` property
         * @enum {string}
         * @public
         * @since 8.0
         */
        thisLib.AccentBorderType = {
            Off: "Off",
            Grey: "Grey",
            GraphPaletteColor1: "GraphPaletteColor1",
            GraphPaletteColor2: "GraphPaletteColor2",
            GraphPaletteColor3: "GraphPaletteColor3",
            GraphPaletteColor4: "GraphPaletteColor4",
            GraphPaletteColor5: "GraphPaletteColor5",
            GraphPaletteColor6: "GraphPaletteColor6",
            GraphPaletteColor7: "GraphPaletteColor7",
            GraphPaletteColor8: "GraphPaletteColor8"
        };
        // inject MessageDisplayHelperImpl
        sap.ui.require(["sas/hc/ui/core/MessageDisplayHelper"], function(
            MessageDisplayHelper
        ) {
            MessageDisplayHelper.provider = "sas/hc/m/MessageDisplayHelperImpl";
        });

        /**
         * Enum for setting role on sas.hc.m.Popover
         * related to the {@link sas.hc.m.Popover Popover}
         * control.
         *
         * @enum {string}
         * @public
         */
        thisLib.PopoverAccessibleRole = {
            None: "None",
            Dialog: "Dialog"
        };

        return sas.hc.m;
    }
);
