sap.ui.jsfragment("sas.fscf.views.fragments.ImportRulesSuccessDialog", {

	_data: null,
	
	getData: function() {
		return this._data;
	},
	
	setData: function(data) {
		this._data = data;
	},
	
    _ruleColumns: [{
		   "property":"baseRuleId",
		   "parts":["baseRuleId","revision"],
		   "label":sas.fscf.rb.getText("rules.rulesPage.rules.table.column.id.txt"), 
		   "width":10,
		   "formatter":"ID"
	   },
	   {
		   "property":"name", 
		   "label":sas.fscf.rb.getText("rules.rulesPage.rules.table.column.name.txt"), 
		   "width":14,
		   "formatter":0
	   },
	   {
		   "property":"type",
		   "label":sas.fscf.rb.getText("rules.rulesPage.rules.table.column.type.txt"), 
		   "width":14,
		   "formatter":"RuleType"
	   },
	   {
		   "property":"messages", 
		   "label":sas.fscf.rb.getText("rules.rulesPage.rules.table.column.messages.txt"), 
		   "width":62,
		   "wrapping":true,
		   "formatter":"ImportedMessages"
	   }
	],
    _variableColumns: [{
		   "property":"name", 
		   "label":sas.fscf.rb.getText("rules.rulesPage.rules.table.column.name.txt"), 
		   "width":14,
		   "formatter":0
	   },
	   {
		   "property":"dataType",
		   "parts":["dataType","dataTypeLength"],
		   "label":sas.fscf.rb.getText("rules.rulesPage.rules.table.column.type.txt"), 
		   "width":14,
		   "formatter":"dataTypeLabel"
	   },
	   {
		   "property":"messages", 
		   "label":sas.fscf.rb.getText("rules.rulesPage.rules.table.column.messages.txt"), 
		   "width":62,
		   "wrapping":true,
		   "formatter":"ImportedMessages"
	   }
	],
	createContent: function(oController) {
	
	},	
	defineColumns: function(oTable, columns) {
		var _this = this;
		for (var i = 0; i < columns.length; i++) {
			oTable.addColumn(
					new sas.hc.ui.table.Column({
						label: _this.getHeaderLabel(columns[i].label),
						template: new sas.hc.m.Text({
								text: {path: (columns[i].parts) ? undefined : columns[i].property,
									   parts: (columns[i].parts) ? columns[i].parts : undefined,
	                                   formatter: this.getTextFormatter(columns[i].formatter)
	                                  },
								wrapping: columns[i].wrapping ? true : false
							}).addStyleClass((columns[i].property == "importedMessages") ? "cfImportedMessages" : ""),
						sortProperty: columns[i].property,
						visible: true,
						width: columns[i].width + "%"
					})
			);
		}		
	}, 	
	addRuleResultsTable: function(oVertLayout, model) {
		var _this = this;	
		var ruleImportedResults = model.getData().ruleImportedResults;
		var oRuleTable = new sas.hc.ui.table.Table({
			id: this.sId + 'RuleTable',
			editable: false,
			showTableOptions: false,
			visibleRowCountMode: sas.hc.ui.table.VisibleRowCountMode.Auto,
			minAutoRowCount: Math.min(ruleImportedResults.length + 1, (model.getData().variableImportedResults.length > 0) ? 10 : 20),
            showAlternateRowShading: true,
            width: "100%"
		});
		
		_this.defineColumns(oRuleTable,_this._ruleColumns);

		var oRuleMessage = new sas.hc.m.Label({
			text: sas.fscf.rb.getText("fcm.import.rules.successMessage.txt")
		});
		
		oRuleTable.setModel(model);
		oRuleTable.bindRows("/ruleImportedResults");	
		
		oVertLayout.addContent(oRuleMessage);
		oVertLayout.addContent(oRuleTable);		
	},
	addVariableResultsTable: function(oVertLayout, model) {
		var _this = this;
        var variableImportedResults=model.getData().variableImportedResults;      
		var oVariableTable = new sas.hc.ui.table.Table({
			id: this.sId + 'VariableTable',
			editable: false,
			showTableOptions: false,
			visibleRowCountMode: sas.hc.ui.table.VisibleRowCountMode.Auto,
			visibleRowCount: Math.max(variableImportedResults.length, 10),
            showAlternateRowShading: true,
            width: "100%"
		});
		
		_this.defineColumns(oVariableTable,_this._variableColumns);
		
		var oVariableMessage = new sas.hc.m.Label({
			text: sas.fscf.rb.getText("fcm.import.variable.header.txt")
		});
		if (model.getData().ruleImportedResults.length > 0) {
			oVariableMessage.addStyleClass("cfVariableImportedResultsLabel");
		}
		
		oVariableTable.setModel(model);
		oVariableTable.bindRows("/variableImportedResults");
		
		oVertLayout.addContent(oVariableMessage);
   	    oVertLayout.addContent(oVariableTable);		
	},
	lazyLoadContent: function() {
		jQuery.sap.require("sas.hc.m.Dialog");
    	jQuery.sap.require("sas.hc.ui.commons.layout.VerticalLayout");
		jQuery.sap.require("sas.hc.ui.table.Table");
		jQuery.sap.require("sas.hc.ui.table.Column");
        jQuery.sap.require("sas.hc.m.Label");
        jQuery.sap.require("sas.hc.m.List");        
        jQuery.sap.require("sas.hc.m.StandardListItem");        

		var _this = this;
		
		var data = _this.getData();		
		var model = new sap.ui.model.json.JSONModel(data);
						
	   	var oVertLayout = new sas.hc.ui.commons.layout.VerticalLayout({
    	    id: this.sId + "_VertLayout",
        });

	   	if (data.ruleImportedResults.length == 0 && 
	   	    data.variableImportedResults.length == 0 ) {
	   		
	   		var oMessage = new sas.hc.m.Label({
				text: sas.fscf.rb.getText("fcm.import.nothingImported.txt")
			});
	   		
	   		oVertLayout.addContent(oMessage);
	   	}
	   	
	   	if (data.ruleImportedResults.length > 0) {
		   	_this.addRuleResultsTable(oVertLayout, model);
	   	}
	   	
	   	if (data.variableImportedResults.length > 0 ) {
		   	_this.addVariableResultsTable(oVertLayout, model);
	   	}
	   		 	  
        var oDialog = new sas.hc.m.Dialog({
        	id: "importRulesSuccessDialog",
        	title: sas.fscf.rb.getText('fcm.import.importSuccess.txt'),
    	    content: [
    	              oVertLayout
    	    ],
    	    rightButton:  new sas.hc.m.Button({
    	    	text: sas.fscf.rb.getText('fcm.application.close.txt'),
    	        press: function() {
    	        	oDialog.close();
    	        }
    	    }),
    	    contentHeight: (window.innerHeight * 0.8) + "px",
    	    contentWidth: (window.innerWidth * 0.7) + "px"
        });
        
        oDialog.attachAfterClose(function(oEvent) {
        	this.destroy();
        });

        return oDialog;
    },
    
	getHeaderLabel: function(label) {
		var oLabel = new sas.hc.m.Label({
			text: label
		});
    	return oLabel;
	},
	
	getTextFormatter: function(type) {
		if (type == "ID"){
			return function(val, val2) {
				return val + "." + val2;
			}
		} else if (type == "RuleType"){
			return function(val) {
				if (val && val != "" && val != " ") {
					return sas.fscf.rb.getText("rules.rulesPage.rules.type." + val.toLowerCase() + ".txt");
				}
				return val;
			}
		} else if (type == "ImportedMessages"){
			return function(val) {
				if ($.isArray(val)) {
					return "- " + val.join(".\n- ") + ".";
				}
				return val;
			}
		} else if (type == "dataTypeLabel") {
			return function(val, val2) {
				if (val == null)
					return val;
				if (val == "Character")
				   return sas.fscf.rb.getText("fcm.import.variable.type.character.fmt.txt",[val2]);
				else
				   return sas.fscf.rb.getText("fcm.import.variable.type."+val.toLowerCase()+".txt");
			}		
		} else {
			return function(val) {
				return val;
			}
		}
	}	
    
});
