sap.ui.jsfragment("sas.fscf.views.fragments.AlertCreationConfigurationDialog", {

    _bExplore: false,
    _bValidate: false,
    _bCodingApproach:false,
    _bGuidedApproach:false,
    _bEditMode: false,
    alertDestinationLabel:null,
	alertDestinationSelect:null,
	alertTypeLabel:null,
	alertTypeSelect:null,
	alertReasonLabel:null,
	alertReasonText:null,


    isExplore: function() {
    	return this._bExplore;
    },

    setExplore: function(bExplore) {
    	this._bExplore = bExplore;
    },
    isCodingApproach: function() {
    	return this._bCodingApproach;
    },

    setCodingApproach: function(bCodingApproach) {
    	this._bCodingApproach = bCodingApproach;
    },
    isGuidedApproach: function() {
    	return this._bGuidedApproach;
    },

    setGuidedApproach: function(bGuidedApproach) {
    	this._bGuidedApproach = bGuidedApproach;
    },

    getExploreContext: function() {
    	return this._oExploreContext;
    },

    setExploreContext: function(oExploreContext) {
    	this._oExploreContext = oExploreContext;
    },

	createContent: function(oController) {

	},

    isValidate: function() {
	    	return this._bValidate;
	},
    setValidate: function(bValidate) {
	    	this._bValidate = bValidate;
	 },


	lazyLoadContent: function() {
		var _this = this;
		_this._bEditMode = sas.fscf.getCurrentPageView().jsonRule != null;
        var oDialog = new sas.hc.m.Dialog({
        	id: "AlertCreationConfigurationDialog",
        	title: _this.isExplore() ? sas.fscf.rb.getText('primaryTable.relatedRows.createAlert.fmt.txt', _this.getExploreContext().txnId) : sas.fscf.rb.getText('rules.rulesPage.guidedView.form.alertCreationConfiguration.txt'),
    	    content: [
    	              new sas.hc.ui.layout.Grid({
      	  				hSpacing: 1,
      	  				vSpacing: 1,
	  				    width: "650px",
      	  				content: [

		        alertDestinationLabel = new sas.hc.m.Label({
					id: this.sId + "alertDestinationLabel",
					text: sas.fscf.rb.getText('rules.rulesPage.guidedView.form.alertDestination.txt'),
					required:_this.isCodingApproach() ? false : true,
					width:"395px",
					layoutData : new sas.hc.ui.layout.GridData({
						span : "L5 M5 S5"
					})
			    }),

			    alertDestinationSelect=this.getAlertDestinationSelect(),

			    alertTypeLabel = new sas.hc.m.Label({
					id: this.sId + "alertTypeLabel",
					text: sas.fscf.rb.getText("rules.rulesPage.guidedView.form.alertType.txt"),
					required:_this.isCodingApproach()? false : true,
					width:"395px",
					layoutData : new sap.ui.layout.GridData({
							linebreakL: true,
							linebreakM: true,
							linebreakS: true,
							span:"L5 M5 S5"
					})
			    }),

			    alertTypeSelect=this.getAlertTypeSelect(),

			    alertReasonLabel= new sas.hc.m.Label({
			    	id:this.sId + "alertReasonLabel",
			    	text : sas.fscf.rb.getText("rules.rulesPage.guidedView.form.alertReason.txt"),
			    	required : false,
					width: "395px",
					layoutData : new sap.ui.layout.GridData({
							linebreakL: true,
							linebreakM: true,
							linebreakS: true,
							span:"L5 M5 S5"
					})
			    }),

			    alertReasonText = new sas.hc.m.TextArea({
					 	id: this.sId + "alertReasonText",
					 	value: sas.fscf.getCurrentPageView().jsonRule.alertReason,
						width:"350px",
						rows:3,
						maxLength:255,
						layoutData : new sas.hc.ui.layout.GridData({
							span : "L7 M7 S7"
						})
				}),
				alertReasonText.attachChange( function(oEvent){
					sas.fscf.removeAllMessageStrips();
					sas.fscf.getCurrentPageView().setDirty(true);
				})
	    	    ],
    	    }),

    	    ],
    	    leftButton: new sas.hc.m.Button({
    	    	text: _this.isValidate() ? sas.fscf.rb.getText('rules.rulesPage.guidedView.save.txt') : sas.fscf.rb.getText('fcm.application.ok.txt'),
    	    	enabled:_this.isValidate() ? false : true,
    	    	press: function() {
    	        	var alertDestinationSelected=alertDestinationSelect.getSelectedKey();
    	        	var alertTypeSelected=alertTypeSelect.getSelectedKey();
    	         	var alertReasonTextValue=alertReasonText.getValue();
    	         	if(_this.isCodingApproach()){
						sas.fscf.getCurrentPageView().jsonRule.queueId=alertDestinationSelected;
		    	        sas.fscf.getCurrentPageView().jsonRule.alertTypeId=alertTypeSelected;
		    	        sas.fscf.getCurrentPageView().jsonRule.alertReason=alertReasonTextValue;

	        	        if(_this.isValidate()){//save directly if after validation
	        	        	sas.fscf.getCurrentPageView().jsonRuleIncomplete=false;
	        	        	sap.ui.getCore().byId(sap.ui.getCore().byId("AlertCreationConfigurationDialog").getLeftButton()).setEnabled(false);
	        	        	if(sas.fscf.getCurrentPageView().getCodingView().getPromote()==true){//promote the rule
	        	        		sas.fscf.removeAllMessageStrips();
	        	        		sas.fscf.getCurrentPageView().getCodingView().save(function () {
	        		   				// success callback
	        		   				sas.fscf.getApplicationView().setBusyIndicatorDelay(0).setBusy(true);
	        		   		    	sas.fscf.getCurrentPageView().getSubView("Rules").promoteRuleToTesting(sas.fscf.getCurrentPageView().jsonRule.id);
	        		   		    	sas.fscf.getCurrentPageView().switchToMainContent();
	        		   				sas.fscf.getApplicationView().setBusy(false);
	        		   		    	return;
	        		   			}, function () {
	        		   				// failure callback
	        		   				return;
	        		   			});
	        	        		sas.fscf.getCurrentPageView().getCodingView().setPromote(false);
	        	        	}else if(sas.fscf.getCurrentPageView().getCodingView().getClose()==true){	        	        		
	        	        		sas.fscf.getCurrentPageView().getCodingView().save(function () {
	        	        			// success callback
	        	        			sas.fscf.getCurrentPageView().switchToMainContent();
	        	        			return;
	        		   		    }, function () {
	        		   				// failure callback
	        		   				return;
	        		   			});
	        	        		sas.fscf.getCurrentPageView().getCodingView().setClose(false);
	        		   		}
	        	        	else{
	        	        		sas.fscf.getCurrentPageView().getCodingView().save();//will close dialog after saving
	        	        	}
	        	        }
	        	        else{
	        	        	oDialog.close();
	        	        }
    	         	}
    	         	else if (_this.isGuidedApproach()) {
    	         		
	    	        	if(alertDestinationSelected!="" && alertTypeSelected!=""){
		    	        	sap.ui.getCore().byId("RulesPageGuidedViewActionsViewconfigureButton1").setIcon("sap-icon://hc/complete");
		    	        	sap.ui.getCore().byId("RulesPageGuidedViewActionsViewconfigureButton1").setEnabled(true);
		    	        	sap.ui.getCore().byId("RulesPageGuidedViewActionsViewalertActionCheckBox").setValueState(sap.ui.core.ValueState.None);
		    	        	sas.fscf.getCurrentPageView().jsonRule.queueId=alertDestinationSelected;
		    	        	sas.fscf.getCurrentPageView().jsonRule.alertTypeId=alertTypeSelected;
		    	        	sas.fscf.getCurrentPageView().jsonRule.alertReason=alertReasonTextValue;

	    	        	}else{//alert action not configured
		    	        	sap.ui.getCore().byId("RulesPageGuidedViewActionsViewalertActionCheckBox").setValueState(sap.ui.core.ValueState.None);
		    	        	sap.ui.getCore().byId("RulesPageGuidedViewActionsViewconfigureButton1").setIcon("sap-icon://hc/configuration");
		    	        	for(i=0;i<sas.fscf.getCurrentPageView().jsonRule.expressions.expressions[0].thenActions.length;i++){
		    	        		if(sas.fscf.getCurrentPageView().jsonRule.expressions.expressions[0].thenActions[i].id=="50101"){
		    	        			sas.fscf.getCurrentPageView().jsonRule.expressions.expressions[0].thenActions.splice(i,1);//remove alert action
		    	        		}
		    	        	}
		    	        	sas.fscf.getCurrentPageView().jsonRule.queueId=null;
		    	        	sas.fscf.getCurrentPageView().jsonRule.alertTypeId=null;
		    	        	sas.fscf.getCurrentPageView().jsonRule.alertReason=null;
	    	        	}

	        	        if(_this.isValidate()){//save directly if after validation
	        	        	sas.fscf.getCurrentPageView().jsonRuleIncomplete=false;
	        	        	sap.ui.getCore().byId(sap.ui.getCore().byId("AlertCreationConfigurationDialog").getLeftButton()).setEnabled(false);
	        	        	if(sas.fscf.getCurrentPageView().getGuidedView().getPromote()==true){//promote the rule	        	        		
	        	        		sas.fscf.getCurrentPageView().getGuidedView().save(function () {
	        		   				// success callback
	        		   				sas.fscf.getCurrentPageView().setBusyIndicatorDelay(0).setBusy(true);
	        		   		    	sas.fscf.getCurrentPageView().getSubView("Rules").promoteRuleToTesting(sas.fscf.getCurrentPageView().jsonRule.id);
	        		   		    	sas.fscf.getCurrentPageView().switchToMainContent();
	        		   		    	sas.fscf.getCurrentPageView().setBusyIndicatorDelay(0).setBusy(false);
	        		   		    	return;
	        		   			}, function () {
	        		   				// failure callback
	        		   				return;
	        		   			});
	        	        		sas.fscf.getCurrentPageView().getGuidedView().setPromote(false);
	        	        	}else if(sas.fscf.getCurrentPageView().getGuidedView().getClose()==true){
	        	        		sas.fscf.getCurrentPageView().getGuidedView().save(function () {
		        		   			// success callback
		        		   		    sas.fscf.getCurrentPageView().switchToMainContent();
		        		   		    return;
		        		   		    }, function () {
		        		   				// failure callback
		        		   				return;
		        		   			});
	        	        		sas.fscf.getCurrentPageView().getGuidedView().setClose(false);
		        		   	}else{
		        		   		sas.fscf.getCurrentPageView().getGuidedView().save();//will close dialog after saving
	        	        	}
	        	        }
	        	        else{
	        	        	oDialog.close();
	        	        }
    	         	}else {
        	        	if(alertDestinationSelected!="" && alertTypeSelected!=""){
        	        		oDialog.setBusyIndicatorDelay(0).setBusy(true);
    	        		    var jsonData = {
    	        		    		"transactionId":_this.getExploreContext().txnId,
    	  		        			"transactionType":_this.getExploreContext().txnAcronym,
    	  		        			"type":alertTypeSelected,
    	  		        			"alertReason":alertReasonTextValue,
    	  		        			"queueId":alertDestinationSelected
   	  		        		};
        	        		sas.ajax({url:"rest/alerts", type: "POST", data: jsonData, headers:sas.fscf.getAjaxHeaders()})
      	        		  	  .done(function(oData){
      	            	         oDialog.close();
     	        		  		 sas.fscf.showMessageStrip(sap.ui.core.MessageType.Success, sas.fscf.rb.getText("explore.explorePage.guidedView.createdAlert.fmt.txt", oData.id), sas.fscf.getCurrentPageView().sId + "GuidedViewBorderLayoutCenter1");
      		        		  }).fail(function(oObj,textStatus,errorThrown){
      		        			 oDialog.setBusy(false);
      		        			 if (oObj.responseJSON && oObj.responseJSON.message) {
      		        				  sas.fscf.showMessageStrip(sap.ui.core.MessageType.Error, oObj.responseJSON.message, oDialog.sId);
      		        			 }
      		        		});
        	        	} else {
        	        		if(alertDestinationSelected=="" ||alertDestinationSelected==null ){
        	        			alertDestinationSelect.setValueState(sap.ui.core.ValueState.Error);
        	        			alertDestinationSelect.setValueStateText(sas.fscf.rb.getText("rules.rulesPage.guidedView.form.missingAlertDestination.error.txt"));
        	        		}
        	        		if(alertTypeSelected=="" || alertTypeSelected==null){
        	        			alertTypeSelect.setValueState(sap.ui.core.ValueState.Error);
        	        			alertTypeSelect.setValueStateText(sas.fscf.rb.getText("rules.rulesPage.guidedView.form.missingAlertType.error.txt"));
        	        		}
        	        	}
    	        	}
    	        }
    	    }),
    	    rightButton:  new sas.hc.m.Button({
    	    	text: sas.fscf.rb.getText('rules.rulesPage.cancel.txt'),
    	        press: function() {
					if(sap.ui.getCore().byId("RulesPageCodingView")!= null){
						sap.ui.getCore().byId("RulesPageCodingView").getEditor().setReadOnly(false);
						sap.ui.getCore().byId(sas.fscf.getCurrentPageView().getCodingView().sId+"ToolbarSaveButton").setEnabled(sas.fscf.getCurrentPageView().isDirty());
						sap.ui.getCore().byId(sas.fscf.getCurrentPageView().getCodingView().sId+"PromoteButton").setEnabled(true);
						sap.ui.getCore().byId(sas.fscf.getCurrentPageView().getCodingView().sId+"CloseButton").setEnabled(true);
					}
					if(sap.ui.getCore().byId("RulesPageGuidedView")!= null){
						sap.ui.getCore().byId(sas.fscf.getCurrentPageView().getGuidedView().sId+"ToolbarSaveButton").setEnabled(sas.fscf.getCurrentPageView().isDirty());
						sap.ui.getCore().byId(sas.fscf.getCurrentPageView().getGuidedView().sId+"PromoteButton").setEnabled(true);
						sap.ui.getCore().byId(sas.fscf.getCurrentPageView().getGuidedView().sId+"CloseButton").setEnabled(true);
					}
    	        	oDialog.close();
    	        }
    	    })
        });

        if (!this.isExplore() && this.isValidate()) {
		    this.validateForm(alertDestinationSelect,alertTypeSelect);
		}

        oDialog.attachAfterClose(function(oEvent) {
        	alertDestinationLabel=null;
        	alertDestinationSelect=null;
        	alertTypeLabel=null;
        	alertTypeSelect=null;
        	alertReasonLabel=null;
        	alertReasonText=null;
        	this.destroy();
        });

        return oDialog;
    },
    getAlertDestinationSelect: function(){
    	jQuery.sap.require("sap.ui.model.Sorter");
    	jQuery.sap.require("sap.ui.commons.ListBox");
    	var _this = this;
    	var alertDestinationList = new sas.hc.m.Select({
    		id: this.sId + "alertDestinationSelect",
    		selectedKey : sas.fscf.getCurrentPageView().jsonRule.queueId ? sas.fscf.getCurrentPageView().jsonRule.queueId : "",
    		width:"350px",
    		layoutData : new sas.hc.ui.layout.GridData({
    			span : "L7 M7 S7"
    		})
    	});
    	sas.ajax({url:'rest/queues?fields=id,name,status,priority', headers:sas.fscf.getAjaxHeaders()})
		  .done(function(oData){
			if(oData.count == 0){
				sap.ui.getCore().byId(sap.ui.getCore().byId("AlertCreationConfigurationDialog").getLeftButton()).setEnabled(false);
			}else{  
				var model = new sap.ui.model.json.JSONModel(oData);
				model.setSizeLimit(100000);
				alertDestinationList.setModel(model);
				alertDestinationList.bindAggregation("items", {
		            path: "/items",
		            factory: function(sId, oContext) {
		                  return new sap.ui.core.ListItem(sId, {
		                	  key:  oContext.getProperty("id"),
		                	  text: oContext.getProperty("name")+ " (" + sas.fscf.rb.getText("rules.rulesPage.codingView.alertConfig."+oContext.getProperty("status")+".txt") + "-"+oContext.getProperty("priority") + ")",
		                  });
		            },
		            sorter: new sap.ui.model.Sorter("name")
		        });
			}
			alertDestinationList.insertItem(new sas.hc.ui.core.Item({key: "",text: sas.fscf.rb.getText("fcm.application.none.txt")}),0);

			alertDestinationList.attachChange(function(oEvent){
				var alertDestinationSelected=this.getSelectedKey();
				if(alertDestinationSelected!="")this.setValueState(sap.ui.core.ValueState.None);
				if(_this.isValidate()){
		        	var leftButton = sap.ui.getCore().byId(sap.ui.getCore().byId("AlertCreationConfigurationDialog").getLeftButton());
		        	if(alertDestinationSelected==''){
		        		leftButton.setEnabled(false);
		        	}else if(alertDestinationSelected !='' && alertTypeSelect.getSelectedKey()!=''){
		        		leftButton.setEnabled(true);
		        	}
		        }
				sas.fscf.removeAllMessageStrips();
				sas.fscf.getCurrentPageView().setDirty(true);


	    	});


		 }).fail(function(oObj,textStatus){
	         console.info("Failed to get queues. ");
		 });
    	return alertDestinationList;
    },

    getAlertTypeSelect: function(){
    	jQuery.sap.require("sap.ui.model.Sorter");
    	jQuery.sap.require("sap.ui.commons.ListBox");

    	var _this = this;
    	var alertTypeList = new sas.hc.m.Select({
    		id: this.sId + "alertTypeSelect",
    		selectedKey : sas.fscf.getCurrentPageView().jsonRule.alertTypeId ? sas.fscf.getCurrentPageView().jsonRule.alertTypeId : "" ,
    		width:"350px",
    		layoutData : new sas.hc.ui.layout.GridData({
    			span : "L7 M7 S7"
    		})
    	});
    	var url='rest/alerttypes?fields=id,name&transactionId='+sas.fscf.getCurrentPageView().jsonRule.transactionTypeId;
		if(_this.isExplore()){
			url='rest/alerttypes?fields=id,name&transactionAcronym='+_this._oExploreContext.txnAcronym;
		}
    	sas.ajax({url:url, headers:sas.fscf.getAjaxHeaders()})
		  .done(function(oData){
			if(oData.count == 0){
				sap.ui.getCore().byId(sap.ui.getCore().byId("AlertCreationConfigurationDialog").getLeftButton()).setEnabled(false);
			}else{  
				var model = new sap.ui.model.json.JSONModel(oData);
				model.setSizeLimit(100000);
				alertTypeList.setModel(model);
				alertTypeList.bindAggregation("items", {
		            path: "/items",
		            factory: function(sId, oContext) {
		                  return new sap.ui.core.ListItem(sId, {
		                	  key:  oContext.getProperty("id"),
		                	  text: oContext.getProperty("name"),
		                  });
		            },
		            sorter: new sap.ui.model.Sorter("name")
		        });
			}
			alertTypeList.insertItem(new sas.hc.ui.core.Item({key: "",text: sas.fscf.rb.getText("fcm.application.none.txt")}),0);
			if(oData.count==0)
				alertTypeList.setSelectedKey("");//select None if no alert types exist

			alertTypeList.attachChange(function(oEvent){
				var alertTypeSelected=this.getSelectedKey();
				if(alertTypeSelected!="")this.setValueState(sap.ui.core.ValueState.None);
		        if (_this.isExplore()) {
		        	_this.updateAlertDestinationBasedOnAlertType(sap.ui.getCore().byId(_this.sId + "alertDestinationSelect"),this,sap.ui.getCore().byId("AlertCreationConfigurationDialog"));
		        }

		        if(_this.isValidate()){
		        	var leftButton = sap.ui.getCore().byId(sap.ui.getCore().byId("AlertCreationConfigurationDialog").getLeftButton());
		        	if(alertTypeSelected==''){
		        		leftButton.setEnabled(false);
		        	}else if (alertTypeSelected !='' && alertDestinationSelect.getSelectedKey() !=''){
		        		leftButton.setEnabled(true);
		        	}
		        }
		        sas.fscf.removeAllMessageStrips();
	    		sas.fscf.getCurrentPageView().setDirty(true);
	    	});

			if (_this.isExplore()) {
				if (_this.getExploreContext().alertType != null) {
					alertTypeList.setSelectedKey(_this.getExploreContext().alertType.id);
				}
				if (alertTypeList.getSelectedKey()) {
					alertTypeList.fireChange({selectedItem: alertTypeList.getItemByKey(alertTypeList.getSelectedKey())});
				}
			}


		 }).fail(function(oObj,textStatus){
	         console.info("Failed to get alert types.");
		 });

    	return alertTypeList;
    },
    updateAlertDestinationBasedOnAlertType: function(alertDestinationSelect,alertTypeSelect,oDialog) {
    	var _this = this;
    	var leftButton = sap.ui.getCore().byId(oDialog.getLeftButton());
    	sas.ajax({url:"rest/transactions/alertedStatus?transactionId=" + _this.getExploreContext().txnId + "&transactionStorageType=" + _this.getExploreContext().txnAcronym + "&alertTypeId=" + alertTypeSelect.getSelectedKey(), type: "GET", dataType:"json", headers:sas.fscf.getAjaxHeaders()})
		  .done(function(oData){
			  if (oData && oData.alertId && oData.queueId) {
				  alertDestinationSelect.setSelectedKey(oData.queueId);
  				  sas.fscf.showMessageStrip(sap.ui.core.MessageType.Information, sas.fscf.rb.getText("explore.explorePage.guidedView.alertExists.fmt.txt", oData.alertId), oDialog.sId);
				  alertDestinationSelect.setEnabled(false);
				  leftButton.setEnabled(false);
			  } else {
  				  sas.fscf.removeAllMessageStrips();
				  alertDestinationSelect.setEnabled(true);
				  leftButton.setEnabled(true);
			  }
		  }).fail(function(oObj,textStatus){
			  sas.fscf.removeAllMessageStrips();
			  alertDestinationSelect.setEnabled(true);
			  leftButton.setEnabled(true);
		  });
    },
    validateForm: function(alertDestinationSelect,alertTypeSelect){
    	var alertDestinationSelected=sas.fscf.getCurrentPageView().jsonRule.queueId;
    	var alertTypeSelected=sas.fscf.getCurrentPageView().jsonRule.alertTypeId;
    	if(alertTypeSelected!=null) alertTypeSelected=alertTypeSelected.trim();

    	if(this.isGuidedApproach()){//guided rule
	    	if(sap.ui.getCore().byId("RulesPageGuidedViewActionsViewconfigureButton1").getEnabled()==true){
	    		if(alertDestinationSelected=="" ||alertDestinationSelected==null ){
	    			alertDestinationSelect.setValueState(sap.ui.core.ValueState.Error);
	    			alertDestinationSelect.setValueStateText(sas.fscf.rb.getText("rules.rulesPage.guidedView.form.missingAlertDestination.error.txt"));
	    		}
	    		if(alertTypeSelected=="" || alertTypeSelected==null){
	    			alertTypeSelect.setValueState(sap.ui.core.ValueState.Error);
	    			alertTypeSelect.setValueStateText(sas.fscf.rb.getText("rules.rulesPage.guidedView.form.missingAlertType.error.txt"));
	    		}
	    	}
    	}else{//coding approach
    		if(alertDestinationSelected=="" ||alertDestinationSelected==null ){
    			alertDestinationSelect.setValueState(sap.ui.core.ValueState.Error);
    			alertDestinationSelect.setValueStateText(sas.fscf.rb.getText("rules.rulesPage.guidedView.form.missingAlertDestination.error.txt"));
    		}
    		if(alertTypeSelected=="" || alertTypeSelected==null){
    			alertTypeSelect.setValueState(sap.ui.core.ValueState.Error);
    			alertTypeSelect.setValueStateText(sas.fscf.rb.getText("rules.rulesPage.guidedView.form.missingAlertType.error.txt"));
    		}
    	}
    },
    destroyAll:function(){
    	sap.ui.getCore().byId("RulesPageCodingViewAlertConfigurationDialogalertDestinationLabel").destroy();
    	sap.ui.getCore().byId("RulesPageCodingViewAlertConfigurationDialogalertDestinationSelect").destroy();
    	sap.ui.getCore().byId("RulesPageCodingViewAlertConfigurationDialogalertTypeLabel").destroy();
    	sap.ui.getCore().byId("RulesPageCodingViewAlertConfigurationDialogalertTypeSelect").destroy();
    	sap.ui.getCore().byId("RulesPageCodingViewAlertConfigurationDialogalertReasonLabel").destroy();
    	sap.ui.getCore().byId("RulesPageCodingViewAlertConfigurationDialogalertReasonText").destroy();
    }

});
