jQuery.sap.require("sas.hc.m.RangeValidationAdapter");
jQuery.sap.require("sas.fscf.views.estimation.HcHelper");
jQuery.sap.require("sas.fscf.views.estimation.EstimationHelper");

sap.ui.jsfragment("sas.fscf.views.estimation.NewEstimationDialog", {
	createContent: function (controller) {/* jshint -W034 */
		"use strict";                     /* jshint +W034 */

        const HcHelper = sas.fscf.views.estimation.HcHelper;
        const reduceSpaceAboveDialogButtons = HcHelper.reduceSpaceAboveDialogButtons;
        const setTableParentHeightTo100Percent = HcHelper.setTableParentHeightTo100Percent;
        const EstimationHelper = sas.fscf.views.estimation.EstimationHelper;
		const MessageStripBuilder = EstimationHelper.MessageStripBuilder;
        const SpacerFactory = EstimationHelper.SpacerFactory;
        const getGmtOffsetString = EstimationHelper.getGmtOffsetString;
        const getLocalizedRuleState = EstimationHelper.getLocalizedRuleState;
        const getText = EstimationHelper.getText;
        const parseInteger = EstimationHelper.parseInteger;

        const formatter = EstimationHelper.getFormatter();

		const getNewInputElementGridData = function () {
			return new sas.hc.ui.layout.GridData({
				span: "L10 M10 S10",
			} );
		};

		const getNewInputElementNarrowerGridData = function () {
			return new sas.hc.ui.layout.GridData({
				span: "L9 M9 S9",
			} );
		};

		const getNewLabelGridData = function () {
			return new sap.ui.layout.GridData({
				linebreakL: true,
				linebreakM: true,
				linebreakS: true,
				span: "L2 M2 S2",
			} );
		};

		const getNewLabelWiderGridData = function () {
			return new sap.ui.layout.GridData({
				linebreakL: true,
				linebreakM: true,
				linebreakS: true,
				span: "L3 M3 S3",
			} );
		};

        const nameLabel = new sas.hc.m.Label({
			id: this.sId + "NameLabel",
			text: getText("rules.rulesPage.name.txt"),
			required: true,
			layoutData: getNewLabelGridData(),
		} );

        const nameInput = new sas.hc.m.Input({
			id: this.sId + "NameInput",
            value: "",
            maxLength: 50,
			required :true,
			width: "100%",
			layoutData: getNewInputElementGridData(),
		} );
		nameInput
			.attachBrowserEvent("keypress", controller.getNameKeyInputValidator,      controller)
        	.attachBrowserEvent("keyup",    controller.handleEstimationDialogChanged, controller)
        	.attachBrowserEvent("paste",    controller.getNameValidator,              controller);

    	const rulesLabel = new sas.hc.m.Label({
			id: this.sId + "RulesLabel",
			text: getText("rules.items.rules.txt"),
			required:true,
			layoutData: getNewLabelGridData(),
    	} );

    	const ruleTable = new sas.hc.ui.table.Table({
        	id: this.sId + "RuleTable",
			editable: false,
			enableBusyIndicator: true,
			enablePixelScrolling: false,
			selectionMode: sas.hc.ui.table.SelectionMode.MultiToggle,
			selectionBehavior: sas.hc.ui.table.SelectionBehavior.Row,
			rememberSelections: true,
			showAlternateRowShading: true,
			showSelectionControls: true,
            showTableOptions: false,
			visibleRowCountMode: sas.hc.ui.table.VisibleRowCountMode.Auto,
            minAutoRowCount: 18,
        	width: "100%",
			layoutData: getNewInputElementGridData(),
			columns: [
				new sas.hc.ui.table.Column ({
					label: new sas.hc.m.Label({text: getText("rules.rulesPage.rules.table.column.id.txt")}),
					tooltip: getText("rules.estimation.rule.id.and.veresion.column.tip.label"),
					template: new sas.hc.m.Text({
						text: "{displayIdString}",
						tooltip: "{id}",
					} ),
					sortProperty: "displayId",
					width: "12%",
				} ),
				new sas.hc.ui.table.Column ({
					label: new sas.hc.m.Label({text: getText("rules.rulesPage.rules.table.column.name.txt")}),
					tooltip: getText("rules.estimation.rule.name.label"),
					template: new sas.hc.m.Text({
						text: "{name}",
						tooltip: "{name}",
					} ),
					sortProperty: "name",
					width: "60%",
				} ),
				new sas.hc.ui.table.Column ({
					label: getText("rules.estimation.alert.column.title"),
					tooltip: getText("rules.estimation.alert.type.label"),
					template: new sas.hc.m.Text({
						text: "{alertType/id}",
                        tooltip: "{alertType/fullDescription}",
					} ),
					sortProperty: "alertTypeId",
					width: "10%",
				} ),
				new sas.hc.ui.table.Column ({
					label: new sas.hc.m.Label({text: getText("rules.rulesPage.rules.state.txt")}),
					tooltip: getText("rules.estimation.rule.state.label"),
                    template: new sas.hc.m.Text({
                        text: {
                            path: "state",
                            formatter: getLocalizedRuleState,
                        },
                    } ),
					sortProperty: "state",
					width: "18%",
				} ),
			],
            rowSelectionChange: [controller.handleEstimationRuleSelectionChange, controller],
        } );
        ruleTable.setModel(controller.getRulesForNewEstimation());
        ruleTable.bindRows({
        	path: "/modelData",
        	sorter: [
        		new sap.ui.model.Sorter("state", true),	// Sort rule state in descending order, and then
        		new sap.ui.model.Sorter("name", false), // sort rule name in ascending order
        	],
        } );

        // BEGIN: Date Range
        const dateRangeLabel = new sas.hc.m.Label({
        	id: this.sId + "DateRangeLabel",
        	text: getText("rules.estimation.date.range.input.label"),
        	required: true,
        	layoutData: getNewLabelWiderGridData(),
        } );

        const startDateLabel = new sas.hc.m.Label({
        	id: this.sId + "StartDateLabel",
			text: getText("rules.estimation.start.date.input.label"),
			// TODO: figure out a way so that we don't have to prepend the minus sign below!
        	tooltip: getText("rules.estimation.start.date.time.tip.label") + "  (" + getGmtOffsetString() + ")",
        } );

        const startDateText = new sas.hc.m.Text({
        	id: this.sId + "StartDateText",
        } );

        const endDateLabel = new sas.hc.m.Label({
        	id: this.sId + "EndDateLabel",
        	text: getText("rules.estimation.end.date.input.label"),
        	tooltip: getText("rules.estimation.end.date.time.tip.label") + "  (" + getGmtOffsetString() + ")",
        } );

        const endDateText = new sas.hc.m.Text({
        	id: this.sId + "EndDateText",
        } );

        const doHandleCalendarSelect = function (calendar) {
        	let startDateValue = " ";
        	let endDateValue = " ";
            const selectedDates = calendar.getSelectedDates();

            if (selectedDates && (selectedDates.length > 0)) {
                const startoDate = selectedDates[0].getStartDate();
                if (startoDate) {
                    startDateValue = formatter.formatWebappDate(startoDate, false);
                }
                const endDate = selectedDates[0].getEndDate();
                if (endDate) {
                    endDateValue = formatter.formatWebappDate(endDate, false);
                }
            }
            startDateText.setText(startDateValue);
            endDateText.setText(endDateValue);
            controller.handleEstimationDialogCalendarSelect();
        };

        const handleCalendarSelect = function (event) {
        	doHandleCalendarSelect(event.getSource());
        };

        const calendar = new sas.hc.ui.unified.Calendar({
        	id: this.sId + "DateRangeCalendar",
        	intervalSelection: true,
        	select: handleCalendarSelect,
        	maxDate: new Date(),
        } );
        calendar.addEventDelegate({
        	onAfterRendering: function (event) {
        		// Add a border to the calendar.  By default, an embedded calendar doesn't have a border, unlike the popup version!
        		const $calendar = event.srcControl.$();
				const $monthButton = $calendar.find("button.sapUiCalHeadB");
        		if ($monthButton.length) {
					let border = $monthButton.css("border");
					if (border === "") {
						border = "1px solid #CDCDCD";
					}
					$calendar.css("border", border);
					let borderRadius = $monthButton.css("border-radius");
					if (borderRadius === "") {
						borderRadius = "2px";
					}
					$calendar.css("border-radius", borderRadius);
        		}
        	}
		} );

        const startTimePicker = new sas.hc.m.TimePicker({
            id: this.sId + "StartTimePicker",
            width: "5rem",
            valueFormat: "HH:mm",
            displayFormat: "HH:mm",
            value: "00:00",
			readOnly: true,
			maskMode: sap.m.TimePickerMaskMode.On,
        } );

        const endTimePicker = new sas.hc.m.TimePicker({
            id: this.sId + "EndTimePicker",
            width: "5rem",
            valueFormat: "HH:mm",
            displayFormat: "HH:mm",
            value: "23:59",
            readOnly: true,
        } );

        const enableTimeInputs = function (enable) {
        	const toEnable = (enable === undefined) ? true : enable;
        	[startDateLabel, startTimePicker, endDateLabel, endTimePicker].forEach(function (each) {
        		each.setEnabled(toEnable);
        	} );
        };

        // Calendar with the read-only Start Date and End Date below it.
		const calendarVbox = new sas.hc.m.VBox({
    		id: this.sId + "CalendarVBox",
            alignItems: sap.m.FlexAlignItems.Center,
            justifyContent: sap.m.FlexJustifyContent.Center,
            items: [
				calendar,
				SpacerFactory.verticalSpacer("0.2rem"),
                new sas.hc.m.HBox({
                    width: "21rem",
                    alignItems: sap.m.FlexAlignItems.Center,
                    justifyContent: sap.m.FlexJustifyContent.SpaceBetween,
                    items: [
                    	startDateLabel,
                    	new sas.hc.m.HBox({
                            alignItems: sap.m.FlexAlignItems.Center,
                            justifyContent: sap.m.FlexJustifyContent.End,
                            items: [startDateText, SpacerFactory.horizontalSpacer("0.5rem"), startTimePicker],
                        } ),
                    ],
				} ),
				SpacerFactory.verticalSpacer("0.2rem"),
                new sas.hc.m.HBox({
                    width: "21em",
                    alignItems: sap.m.FlexAlignItems.Center,
                    justifyContent: sap.m.FlexJustifyContent.SpaceBetween,
                    items: [
                    	endDateLabel,
                    	new sas.hc.m.HBox({
                            alignItems: sap.m.FlexAlignItems.Center,
                            justifyContent: sap.m.FlexJustifyContent.End,
                            items: [endDateText, SpacerFactory.horizontalSpacer("0.5rem"), endTimePicker],
                        } ),
                    ],
                } ),
            ],
        } );

		// BEGIN: Calendar methods
		const disableAllCalendarDates = function (aCalendar) {
    		const maxDate = aCalendar.getMaxDate();
    		aCalendar.setMinDate(maxDate);
    		aCalendar.addDisabledDate(new sap.ui.unified.DateRange({
    			startDate: maxDate,
    		} ) );
		};

		const resetCalendar = function () {
			calendar
    			.destroyDisabledDates()
    			.destroySelectedDates()
    			.destroySpecialDates();
        	endDateText.setText("");
        	startDateText.setText("");
		};

		// @param dateRange - sap.ui.unified.DateRange
        const selectDateRange = function (dateRange) {
        	calendar
        		.destroySelectedDates()
            	.insertSelectedDate(dateRange);
            doHandleCalendarSelect(calendar);
        };

        // @param dateRange - sap.ui.unified.DateRange
        // @param color - sap.ui.unified.CalendarDayType
        const doHighlightDateRange = function (dateRange, color, tooltip) {
        	const startDate = dateRange.getStartDate();
        	const endDate = dateRange.getEndDate();
    		const dateTypeRange = new sas.hc.ui.unified.DateTypeRange({
    			startDate: startDate,
    			endDate: endDate,
    			type: color,
    			tooltip: ((tooltip !== undefined) ? tooltip : ""),
    		} );
            calendar.addSpecialDate(dateTypeRange);
        };

        // @param dateRange - sap.ui.unified.DateRange
        const highlightSlowPathDateRange = function (dateRange) {
    		const slowPathDateRangeText = formatter.formatLongDate(dateRange.getStartDate()) + " - " + formatter.formatLongDate(dateRange.getEndDate());
            const slowPathInfo = (getText("rules.estimation.user.variable.calculation.required.period.label") + ":\n") + slowPathDateRangeText;
            doHighlightDateRange(dateRange, sap.ui.unified.CalendarDayType.Type02, slowPathInfo);
        };

        // @param dateRange - sap.ui.unified.DateRange
        const highlightFastPathDateRange = function (dateRange) {
    		const fastPathDateRangeText = formatter.formatLongDate(dateRange.getStartDate()) + " - " + formatter.formatLongDate(dateRange.getEndDate());
            const fastPathInfo = (getText("rules.estimation.user.variable.calculation.not.required.period.label") + ":\n") + fastPathDateRangeText;
    		doHighlightDateRange(dateRange, sap.ui.unified.CalendarDayType.Type03, fastPathInfo);
        };
        // END: Calendar methods

        const messageStrip = new MessageStripBuilder({
            text: "",
            showCloseButton: false,
            showIcon: true,
		} ).build();

        const showMessage = function (message, messageType) {
        	messageStrip
        		.setShowCloseButton(false)
        		.setText(message)
        		.setType((messageType !== undefined) ? messageType : sap.ui.core.MessageType.Information)
        		.setVisible(true);
        };

        const dateRangeNoteVBox = new sas.hc.m.VBox({
    		id: this.sId + "DateRangeNoteVbox",
            alignItems: sap.m.FlexAlignItems.Center,
            justifyContent: sap.m.FlexJustifyContent.Start,
            items: [SpacerFactory.verticalSpacer("1rem"), messageStrip],
            width: "50%",	// Needed for IE11 only...works fine without it for Chrome, Edge and Firefox.
        } );

        const dateRangeHBox = new sas.hc.m.HBox({
    		id: this.sId + "CalendarHbox",
            alignItems: sap.m.FlexAlignItems.Start,
            justifyContent: sap.m.FlexJustifyContent.Start,
            items: [
				calendarVbox,
				SpacerFactory.horizontalSpacer("0.5rem"),
            	dateRangeNoteVBox,
            ],
    		layoutData: getNewInputElementNarrowerGridData(),
        } );

		// BEGIN: User variable elements
		const userVarsLabel = new sas.hc.m.Label({
			text: getText("rules.estimation.user.variables.input.label"),
			required: false,
		} );
		
		
		const userTestRuleLabel = new sas.hc.m.Label({
			text: getText("rules.estimation.user.testrule.input.label"),
			required: false,
		} );
		
		const ENABLE_USER_VARS_CALCULATION = getText("rules.estimation.enable.calculation.checkbox.label");
		const FORCE_USER_VARS_RECALCULATION = getText("rules.estimation.force.recalculation.checkbox.label");
		const EXCLUDE_TESTING_RULES = getText("rules.estimation.excludeTestingRules.txt");
		
		const userUseTestRulesCheckBox = new sas.hc.m.CheckBox({
            id: this.sId + "userUseTestRulesCheckBox",
			text: EXCLUDE_TESTING_RULES,
			selected: false,
			enabled: true,
			editable: true,
			layoutData: getNewInputElementNarrowerGridData(),
		} );

		const userVarsCalculationCheckBox = new sas.hc.m.CheckBox({
            id: this.sId + "UserVarsCalculationCheckBox",
			text: ENABLE_USER_VARS_CALCULATION,
			selected: true,
			enabled: false,
			editable: false,
			layoutData: getNewInputElementNarrowerGridData(),
		} );

		const userVarsPrimingDurationLabel = new sas.hc.m.Label({
			text: getText("rules.estimation.priming.duration.input.label"),
			required: false,
		} );

        const userVarsPrimingDurationValidator = new sas.hc.m.RangeValidationAdapter({
            minValue: 0,
            maxValue: 500,
            inclusive: true,
        } );

        const userVarsPrimingDurationInput = new sas.hc.m.Input({
            id: this.sId + "UserVarsPrimingDurationInput",
            type: sap.m.InputType.Number,
            allowIntegerOnly: true,
            maxLength: 3,
            value: 14,
            enabled: false,
            width: "3rem",
            formatValue: false,
            valueLiveUpdate: true,
        } );
		userVarsPrimingDurationInput.setValidator(userVarsPrimingDurationValidator);
		userVarsPrimingDurationInput.attachBrowserEvent("keyup", controller.handleEstimationDialogChanged, controller);

		const adjustRadioButtonPadding = function (rButton) {
			const $rButton = rButton.$();
			// Vertically-align the radio button.
			$rButton.css({
				display: "flex",
				"align-items": "center",
				"justify-content": "center",
			} );
			 // HC-override: move up the radio button label.  Original: 0,.275rem
			 $rButton.find(".sapMLabel")[0].style.setProperty("padding-top", "0rem", "important");
		};

		const daysRButton = new sas.hc.m.RadioButton({
			id: this.sId + "PrimingRadioButton1",
			text: getText("rules.estimation.days.radiobutton.label"),
			selected: true,
			groupName: "priming",
		} ).addEventDelegate({
			onAfterRendering: function (event) {
				adjustRadioButtonPadding(event.srcControl);
			},
		} );

		const hoursRButton = new sas.hc.m.RadioButton({
			id: this.sId + "PrimingRadioButton2",
			text: getText("rules.estimation.hours.radiobutton.label"),
			groupName: "priming",
		} ).addEventDelegate({
			onAfterRendering: function (event) {
				adjustRadioButtonPadding(event.srcControl);
			},
		} );

		const primingRadioButtonsHBox = new sas.hc.m.HBox({
			alignItems: sap.m.FlexAlignItems.Center,
			justifyContent: sap.m.FlexJustifyContent.Start,
			height: "1.5rem",
			items: [daysRButton, hoursRButton],
		} );

		const userVarsPrimingHBox = new sas.hc.m.HBox({
			alignItems: sap.m.FlexAlignItems.Center,
			justifyContent: sap.m.FlexJustifyContent.Start,
			items: [
				SpacerFactory.horizontalSpacer("2rem"),
				userVarsPrimingDurationLabel,
				SpacerFactory.horizontalSpacer("0.5rem"),
				userVarsPrimingDurationInput,
				SpacerFactory.horizontalSpacer("0.5rem"),
				primingRadioButtonsHBox,
			],
			layoutData: getNewInputElementNarrowerGridData(),
		} );

		const splitTxnsOptionTemplate = new sas.hc.ui.core.Item({
            key: "{name}",
            text: "{label}",
        } );
		const splitTxnsOptionsSelect = new sas.hc.m.Select({
			id: this.sId + "SplitTxnsOptionsSelect",
			items: {
                path: "/options",
                sorter: new sap.ui.model.Sorter("label", false),
                template: splitTxnsOptionTemplate,
			},
			enabled: false,
			selectedKey: controller.getDefaultSelectedSplitTxnsOptionKey(),
			layoutData: getNewInputElementNarrowerGridData(),
		} );
		const splitTxnsOptions = {"options": controller.getSplitTxnsOptions()};
		const splitTxnsOptionsModel = new sap.ui.model.json.JSONModel(splitTxnsOptions);
		splitTxnsOptionsSelect.setModel(splitTxnsOptionsModel);

		const parallelProcessingCheckBox = new sas.hc.m.CheckBox({
            id: this.sId + "ParallelProcessingCheckBox",
			text: getText("rules.estimation.use.parallel.processing.checkbox.label"),
            selected: false,
		} ).attachSelect(function (event) {
			splitTxnsOptionsSelect.setEnabled(event.getSource().getSelected());
		} );

		const paralleProcessingHBox = new sas.hc.m.HBox({
			alignItems: sap.m.FlexAlignItems.Center,
			justifyContent: sap.m.FlexJustifyContent.Start,
			items: [
				SpacerFactory.horizontalSpacer("1.5rem"),
				parallelProcessingCheckBox,
				SpacerFactory.horizontalSpacer("0.5rem"),
				splitTxnsOptionsSelect,
			],
			layoutData: getNewInputElementNarrowerGridData(),
		} );
		const enableParallelProcessingElts = function (enable) {
			const toEnable = (enable === undefined) ? true : enable;
			parallelProcessingCheckBox.setEnabled(toEnable);
			splitTxnsOptionsSelect.setEnabled(parallelProcessingCheckBox.getSelected());
		};

		const userTestRuleVBox = new sas.hc.m.VBox({
    		id: this.sId + "userTestRuleVBox",
            alignItems: sap.m.FlexAlignItems.Start,
            justifyContent: sap.m.FlexJustifyContent.Center,
            items: [
                userUseTestRulesCheckBox,
                SpacerFactory.verticalSpacer("0.4rem"),          
			],
			layoutData: getNewInputElementNarrowerGridData(),
        } );
        
        const userVarsVBox = new sas.hc.m.VBox({
    		id: this.sId + "UserVarsVBox",
            alignItems: sap.m.FlexAlignItems.Start,
            justifyContent: sap.m.FlexJustifyContent.Center,
            items: [
                userVarsCalculationCheckBox,
                SpacerFactory.verticalSpacer("0.4rem"),
                userVarsPrimingHBox,
                SpacerFactory.verticalSpacer("0.4rem"),
				paralleProcessingHBox,
			],
			layoutData: getNewInputElementNarrowerGridData(),
        } );


		userUseTestRulesCheckBox.attachSelect(function (event) {
			userUseTestRulesCheckBox.setEnabled(true);
			
		} );
		
		const enableUserVarsCalculationElements = function (enable) {
			const toEnable = (enable === undefined) ? true : enable;
			[userVarsPrimingDurationLabel, userVarsPrimingDurationInput, daysRButton, hoursRButton].forEach(function (each) {
				each.setEnabled(toEnable);
			} );
			enableParallelProcessingElts(enable);
			if (!toEnable) {
				splitTxnsOptionsSelect.setEnabled(false);
			}
		};
		userVarsCalculationCheckBox.attachSelect(function (event) {
			enableUserVarsCalculationElements(event.getSource().getSelected());
			userVarsCalculationCheckBox.setEnabled(false);
			
		} );

        const enableUserVarsElements = function (enable) {
			const toEnable = (enable === undefined) ? true : enable;
			userVarsLabel.setEnabled(toEnable);
			enableUserVarsCalculationElements(enable);
		};
		// END: User variable elements
        // END: Date Range

        // BEGIN: Additional settings
		const maxFiredTxnsLabel = new sas.hc.m.Label({
			id: this.sId + "MaxFiredTxnsLabel",
			text: getText("rules.estimation.fired.transactions.limit.input.label"),
			required: false,
			layoutData: getNewLabelWiderGridData(),
		} );

        const maxFiredTxnsValidator = new sas.hc.m.RangeValidationAdapter({
            minValue: 1,
			maxValue: 10000, // This will be set by the controller's setUpMaxFiredTxnsInput() method, with data from the server.
            inclusive: true,
        } );

        const maxFiredTxnsInput = new sas.hc.m.Input({
            id: this.sId + "MaxFiredTxnsInput",
            type: sap.m.InputType.Number,
			allowIntegerOnly: true,
			value: 1000,     // Default to 1000...initial value will be set by controller's setUpMaxFiredTxnsInput()
            maxLength: 6,
            width: "5rem",
			formatValue: false,
			valueLiveUpdate: true,
		} );
		maxFiredTxnsInput.setValidator(maxFiredTxnsValidator);
        maxFiredTxnsInput.attachLiveChange(function () {
			controller.handleEstimationDialogChanged();
		} );

		const logLabel = new sas.hc.m.Label({
			id: this.sId + "LogLabel",
			text: getText("rules.estimation.log.input.label"),
			required: false,
			layoutData: getNewLabelWiderGridData(),
		} );

        const logDetailsLabel = new sas.hc.m.Label({
            id: this.sId + "LogDetailsLabel",
            text: getText("rules.estimation.include.additional.details.checkbox.label"),
            tooltip: getText("rules.estimation.include.additional.details.tip.label"),
        } );

        const logDetailsSwitch = new sas.hc.m.Switch({
            id: this.sId + "LogDetailsSwitch",
            ariaLabelledBy: logDetailsLabel,
            customTextOn: getText("fcm.application.yes.txt"),
            customTextOff: getText("fcm.application.no.txt"),
            state: false,
            enabled: true,
        } );

        const logDetailsHBox = new sas.hc.m.HBox({
            id: this.sId + "LogDetailsHBox",
            alignItems: sap.m.FlexAlignItems.Center,
            items: [logDetailsSwitch, SpacerFactory.horizontalSpacer("0.5rem"), logDetailsLabel],
            layoutData: getNewInputElementNarrowerGridData(),
        } );
        // END Additional settings

        // BEGIN: Dialog buttons
        const backButton = new sas.hc.m.Button({
	    	text: ("< " + getText("rules.estimation.back.button.title")),
	    	enabled: false,
	        press: [controller.handleEstimateionDialogBackButtonClick, controller],
        } );

        const nextButton = new sas.hc.m.Button({
	    	text: (getText("rules.estimation.next.button.title") + " >"),
	    	enabled: false,
	    	press: [controller.handleEstimateionDialogNextButtonClick, controller],
	    } );

        const handleRunButtonClick = function () {
                estimationDialog.setBusyIndicatorDelay(0).setBusy(true);
        	controller.handleCreateEstimation();
        };

        const runButton = new sas.hc.m.Button({
	    	text: getText("rules.ruleDetailMenu.run.txt"),
	    	enabled: false,
	        press: handleRunButtonClick,
        } );

        const cancelButton = new sas.hc.m.Button({
	    	text: getText("rules.rulesPage.cancel.txt"),
	        press: function() {
	        	estimationDialog.close();
	        }
	    } );
        // END: Dialog buttons

		// BEGIN: move to common module
		const isControlInErrorState = function (control) {
			return (control.getValueState() === sap.ui.core.ValueState.Error);
		};

		const isNumericInputValid = function (control) {
            if (isControlInErrorState(control)) {
                return false;
            }
            const value = parseInteger(control.getValue());
            const validator = control.getValidator();
			return (value >= validator.getMinValue()) && (value <= validator.getMaxValue());
		};
		// END: move to common module

		// Estimation Dialog
        const generalTabControls = [
        	nameLabel, nameInput,
        	rulesLabel, ruleTable
        ];
        const dateRangeTabControls = [
			dateRangeLabel, dateRangeHBox,
			userTestRuleLabel,userTestRuleVBox,
			userVarsLabel, userVarsVBox,
        ];
        const additionalSettingsTabControls = [
        	maxFiredTxnsLabel, maxFiredTxnsInput,
        	logLabel, logDetailsHBox,
        ];

		const grid = new sas.hc.ui.layout.Grid({
            id: this.sId + "Grid",
    		hSpacing: 0,
    		vSpacing: 1,
            // height: "100%", // "32rem",
    		width: "50rem",
    		content: [generalTabControls],
		} );

        const estimationDialog = new sas.hc.m.Dialog({ //jshint ignore:line, turn off the warning on estimationDialog.close() in the  block of code where cancelButton is defined.
        	id: this.sId + "NewEstimationDialog",
        	title: getText("rules.ruleEstimatesDetailMenu.newEstimation.txt"),
            content: [grid],
            contentHeight: "80%",
            centerAfterResize: true,
    	    buttons: [backButton, nextButton, runButton, cancelButton],
    	    beforeOpen: [controller.handleEstimationDialogBeforeOpen, controller],
		} );
		estimationDialog.addEventDelegate({
			onAfterRendering: function (event) {
				setTableParentHeightTo100Percent(ruleTable);
                reduceSpaceAboveDialogButtons(event.srcControl);
			},
		} );

		// RAPTOR-5347
		estimationDialog.dismantle = function () {
        	(generalTabControls.concat(dateRangeTabControls).concat(additionalSettingsTabControls))
    		.forEach(function (each) {
    			each.destroy();
    		} );
	    	this.destroy();
	    	controller.handleEstimationDialogClose();
		}
		
        estimationDialog.attachAfterClose(function () {
        	this.dismantle();
        } );

        // BEGIN: Methods for the controller.
        estimationDialog.disableButtons = function () {
        	[backButton, nextButton, runButton, cancelButton].forEach(function (each) {
        		each.setEnabled(false);
        	} );
        	return this;
        };

        estimationDialog.enableUserVarsElements = function (enable) {
        	enableUserVarsElements(enable);
        };

        estimationDialog.focusToday = function () {
        	calendar.focusDate(new Date());
        };
        
        // RAPTOR-5347
        estimationDialog.forceClose = function () {
        	this.dismantle();
        };

        estimationDialog.getCalendar = function () {
        	return calendar;
        };

        estimationDialog.getEndTimePicker = function () {
        	return endTimePicker;
        };

        estimationDialog.getLogDetailsSwitch = function () {
        	return logDetailsSwitch;
        };

		estimationDialog.getMaxFiredTxnsInput = function () {
			return maxFiredTxnsInput;
		};

        estimationDialog.getNameInput = function () {
        	return nameInput;
        };

		estimationDialog.getNextButton = function () {
			return nextButton;
		};

		estimationDialog.getParallelProcessingCheckBox = function () {
			return parallelProcessingCheckBox;
		};

        estimationDialog.getRuleTable = function () {
        	return ruleTable;
        };

        estimationDialog.getRunButton = function () {
        	return runButton;
        };

		estimationDialog.getSplitTxnsOptionsSelect = function () {
			return splitTxnsOptionsSelect;
		};

        estimationDialog.getStartTimePicker = function () {
        	return startTimePicker;
        };

		estimationDialog.getUserUseTestRulesCheckBox = function () {
			return userUseTestRulesCheckBox;
        };
		
		estimationDialog.getUserVarsCalculationCheckBox = function () {
			return userVarsCalculationCheckBox;
        };
        
        estimationDialog.getUserVarsLabel = function () {
            return userVarsLabel;
        };
        
        estimationDialog.getUserTestRuleLabel = function () {
            return userTestRuleLabel;
        };      

		estimationDialog.getUserVarsPrimingDurationInput = function () {
			return userVarsPrimingDurationInput;
		};

        estimationDialog.hideTab = function () {
        	grid.removeAllContent();
        };

        estimationDialog.initWizard = function (wizard) {
        	wizard.addTab(generalTabControls);
        	wizard.addTab(dateRangeTabControls);
        	wizard.addTab(additionalSettingsTabControls);
            return this;
		};

		estimationDialog.isDaysSelected = function () {
			return daysRButton.getSelected();
		};

		estimationDialog.isMaxFiredTxnsInputValid = function () {
			return isNumericInputValid(maxFiredTxnsInput);
		};

		estimationDialog.isUserVarsPrimingDaysDurationValid = function () {
			return isNumericInputValid(userVarsPrimingDurationInput);
		};

		estimationDialog.nameUserVarsCalculationCheckBoxEnableCalculation = function () {
			userVarsCalculationCheckBox.setText(ENABLE_USER_VARS_CALCULATION);
		};

		estimationDialog.nameUserVarsCalculationCheckBoxForceRecalculation = function () {
			userVarsCalculationCheckBox.setText(FORCE_USER_VARS_RECALCULATION);
		};

        estimationDialog.purgeDateRangeInfo = function () {
            messageStrip
            	.setVisible(false)
            	.setText("");
        };

		estimationDialog.setCheckboxInteractivity = function (checkbox, properties) {
			const toBeReadOnly = (properties.readOnly !== undefined) ? properties.readOnly : false;
			const toBeEnabled = (properties.enable !== undefined) ? properties.enable : true;

			checkbox
			 	.setEnabled(toBeEnabled)
			 	.setEditable(!toBeReadOnly);
		};
		
        estimationDialog.setUpButtons = function () {
    		backButton.setEnabled(controller.isCanGoToPreviousTab());
    		nextButton.setEnabled(controller.isCanGoToNextTab());
			runButton.setEnabled(controller.isCanCreateEstimation());
			cancelButton.setEnabled(true);
            return this;
        };

        // @param earliestTrxDate - Date
        // @param defaultDateRange - sap.ui.unified.DateRange
        // @param fastPathDateRange - sap.ui.unified.DateRange
        // @param slowPathDateRange - sap.ui.unified.DateRange
		estimationDialog.setUpCalendar = function (earliestTrxDate, defaultDateRange, fastPathDateRange, slowPathDateRange) {
        	resetCalendar();

        	if (earliestTrxDate !== null) {
        		calendar.setMinDate(earliestTrxDate);

        		if (defaultDateRange !== null) {
        			selectDateRange(defaultDateRange);
        		}
        		if (fastPathDateRange !== null) {
        			highlightFastPathDateRange(fastPathDateRange);
        		}
        		if (slowPathDateRange !== null) {
        			highlightSlowPathDateRange(slowPathDateRange);
        		}
        		enableTimeInputs();
        	} else {
        		// There are no transactions to support estimations.  So disable all dates.
        		disableAllCalendarDates(calendar);
        		enableTimeInputs(false);
        	}
            return this;
        };

        estimationDialog.setUpMaxFiredTxnsInput = function (maxFiredTxnsSettings) {
        	if ((maxFiredTxnsValidator.getMinValue() === 1) && (maxFiredTxnsValidator.getMaxValue() === 10000)) {
        		maxFiredTxnsValidator.setMaxValue(maxFiredTxnsSettings.maxCount);
        		maxFiredTxnsInput.setValue(maxFiredTxnsSettings.defaultCount);
        	}
        };

        estimationDialog.showTab = function (wizardTab) {
        	wizardTab.controls.forEach(function (each) {
        		grid.addContent(each);
        	} );
        };

        estimationDialog.showErrorMessage = function (message) {  // Shown at top of the dialog, below the title
            sas.fscf.showErrorMessageStrip(message, this.sId);
            return this;
        };

        estimationDialog.showWarningMessage = function (message) { // Shown at top of the dialog, below the title
            sas.fscf.showWarningMessageStrip(message, this.sId);
            return this;
        };

        const SLOW_PATH_WARNING_MESSAGE = getText("rules.esimtation.slow.path.warning.msg");
        estimationDialog.showSlowPathWarning = function () {       // Embedded in the page, to the right of the calendar.
        	showMessage(SLOW_PATH_WARNING_MESSAGE, sap.ui.core.MessageType.Warning);
            return this;
        };
        // END: Methods for the controller.

        return estimationDialog;
    },
} );
