jQuery.sap.require("sas.fscf.views.PrimaryView");

sap.ui.jsview("sas.fscf.views.RulesPageRules", {
    getControllerName: function () {
    	// mix in PrimaryView
    	jQuery.extend(true, this, sas.fscf.views.PrimaryView);

    	return "sas.fscf.views.RulesPageRules";
    },

    STATE_CODING: "Coding",
    STATE_TESTING: "Testing",
    STATE_PRODUCTION: "Production",
    STATE_TRASH: "Trash",

    _columns: {
    	"Coding": [
   			{
   			   "property":"baseRuleId",
   			   "parts":["baseRuleId","revision"],
   			   "label":sas.fscf.rb.getText("rules.rulesPage.rules.table.column.id.txt"),
   			   "tooltip":"id",
   			   "width":60,
   			   "formatter":"ID"
   		   },
   		   {
   			   "property":"name",
   			   "label":sas.fscf.rb.getText("rules.rulesPage.rules.table.column.name.txt"),
   			   "width":180,
   			   "formatter":0
   		   },
   		   {
   			   "property":"ruleTypeName",
   			   "parts":["ruleTypeName","alertTypeId"],
   			   "label":sas.fscf.rb.getText("rules.rulesPage.rules.table.column.type.txt"),
   			   "width":100,
   			   "formatter":"RuleType"
  		   },
   		   {
   			   "property":"executionOrderType",
   			   "parts":["executionOrderType","executionOrderPriority"],
   			   "label":sas.fscf.rb.getText("rules.rulesPage.rules.table.column.orderAndPriority.txt"),
   			   "width":100,
   			   "formatter":"OrderPriority"
   		   },
   		   {
   			   "property":"description",
   			   "label":sas.fscf.rb.getText("rules.rulesPage.rules.table.column.description.txt"),
   			   "width":300,
   			   "formatter":0
   		   },
   		   {
   			   "property":"multiOrgNodeDisplayName",
   			   "parts":["multiOrgNodeDisplayName","multiOrgNodeKey"],
   			   "label":sas.fscf.rb.getText("rules.rulesPage.rules.table.column.transactionScope.txt"),
   			   "width":150,
   			   "formatter":"TransScope"
   		   },
   		   {
   			   "property":"guidedRule",
   			   "label":sas.fscf.rb.getText("rules.rulesPage.rules.table.column.guided.txt"),
   			   "width":100,
   			   "formatter":"YesNo"
   		   },
  		   {
   			   "property":"lastUpdateUser",
   			   "label":sas.fscf.rb.getText("rules.rulesPage.rules.table.column.lastUpdatedBy.txt"),
   			   "width":150,
   			   "formatter":0
   		   },
   		   {
   			   "property":"lastUpdateTimestamp",
   			   "label":sas.fscf.rb.getText("rules.rulesPage.rules.table.column.lastUpdatedTime.txt"),
   			   "width":300,
   			   "formatter":"DateTime"
   		   }
   	   ],
   	   "Testing": [
   		   {
   			   "property":"baseRuleId",
   			   "parts":["baseRuleId","revision"],
   			   "label":sas.fscf.rb.getText("rules.rulesPage.rules.table.column.id.txt"),
   			   "tooltip":"id",
   			   "width":60,
   			   "formatter":"ID"
   		   },
   		   {
   			   "property":"name",
   			   "label":sas.fscf.rb.getText("rules.rulesPage.rules.table.column.name.txt"),
   			   "width":180,
   			   "formatter":0
   		   },
   		   {
   			   "property":"ruleTypeName",
   			   "parts":["ruleTypeName","alertTypeId"],
  			   "label":sas.fscf.rb.getText("rules.rulesPage.rules.table.column.type.txt"),
   			   "width":100,
   			   "formatter":"RuleType"
   		   },
   		   {
   			   "property":"executionOrderType",
   			   "parts":["executionOrderType","executionOrderPriority"],
   			   "label":sas.fscf.rb.getText("rules.rulesPage.rules.table.column.orderAndPriority.txt"),
   			   "width":100,
   			   "formatter":"OrderPriority"
   		   },
   		   {
   			   "property":"multiOrgNodeDisplayName",
   			   "parts":["multiOrgNodeDisplayName","multiOrgNodeKey"],
   			   "label":sas.fscf.rb.getText("rules.rulesPage.rules.table.column.transactionScope.txt"),
   			   "width":150,
   			   "formatter":"TransScope"
   		   },
   		   {
   			   "property":"pendingApproval",
   			   "parts":["pendingApproval","lastUpdateUser"],
   			   "label":sas.fscf.rb.getText("rules.rulesPage.rules.table.column.promoteRequested.txt"),
   			   "width":100,
   			   "formatter":"RequestedBy"
   		   },
   		   {
   			   "property":"operationalState",
   			   "parts":["operationalState","configuredOperationalState"],
   			   "label":sas.fscf.rb.getText("rules.rulesPage.rules.table.column.status.txt"),
   			   "width":40,
   			   "formatter":"OpState",
   			   "type":1,
   			   "hAlign":sap.ui.core.HorizontalAlign.Center,
   			   "exclude":!sas.fscf.deployTestingRules
   		   },
   		   {
   			   "property":"metrics/overall/ardFiredTxnCount/value",
   			   "parts":["metrics/overall/ardFiredTxnCount/value","metrics/overall/ardTxnPopulation/value","metrics/historical/ardFiredTxnCount/values"],
   			   "partsDescriptions":[sas.fscf.rb.getText("rules.rulesPage.rules.customerImpactRatio.negativeDecisions.txt"),sas.fscf.rb.getText("rules.rulesPage.rules.impactRatio.transactionsProcessed.txt")],
  			   "label":sas.fscf.rb.getText("rules.rulesPage.rules.table.column.customerImpactRatio.txt"),
   			   "width":125,
   			   "formatter":0,
   			   "type":2,
   			   "exclude":!sas.fscf.deployTestingRules
   		   },
   		   {
   			   "property":"metrics/overall/alrtFiredTxnCount/value",
   			   "parts":["metrics/overall/alrtFiredTxnCount/value","metrics/overall/alrtTxnPopulation/value","metrics/historical/alrtFiredTxnCount/values"],
   			   "partsDescriptions":[sas.fscf.rb.getText("rules.rulesPage.rules.analystImpactRatio.alertsFired.txt"),sas.fscf.rb.getText("rules.rulesPage.rules.impactRatio.transactionsProcessed.txt")],
   			   "label":sas.fscf.rb.getText("rules.rulesPage.rules.table.column.analystImpactRatio.txt"),
   			   "width":125,
   			   "formatter":0,
   			   "type":2,
   			   "exclude":!sas.fscf.deployTestingRules
   		   },
   		   {
   			   "property":"metrics/overall/execTimeExceededCount/value",
   			   "label":sas.fscf.rb.getText("rules.rulesPage.rules.table.column.runTime.txt"),
   			   "width":40,
   			   "formatter":"RunTime",
   			   "type":1,
   			   "hAlign":sap.ui.core.HorizontalAlign.Center,
   			   "exclude":!sas.fscf.deployTestingRules
  		   },
			 {
				 "property":"lastUpdateUser",
				 "label":sas.fscf.rb.getText("rules.rulesPage.rules.table.column.lastUpdatedBy.txt"),
				 "width":150,
				 "formatter":0
			 },
			 {
				 "property":"lastUpdateTimestamp",
				 "label":sas.fscf.rb.getText("rules.rulesPage.rules.table.column.lastUpdatedTime.txt"),
				 "width":300,
				 "formatter":"DateTime"
			 }
   	   ],
   	   "Production": [
   		   {
  			   "property":"baseRuleId",
   			   "parts":["baseRuleId","revision"],
   			   "label":sas.fscf.rb.getText("rules.rulesPage.rules.table.column.id.txt"),
   			   "tooltip":"id",
   			   "width":60,
   			   "formatter":"ID"
   		   },
   		   {
   			   "property":"name",
   			   "label":sas.fscf.rb.getText("rules.rulesPage.rules.table.column.name.txt"),
   			   "width":180,
   			   "formatter":0
   		   },
   		   {
   			   "property":"ruleTypeName",
   			   "parts":["ruleTypeName","alertTypeId"],
  			   "label":sas.fscf.rb.getText("rules.rulesPage.rules.table.column.type.txt"),
   			   "width":100,
   			   "formatter":"RuleType"
   		   },
   		   {
   			   "property":"executionOrderType",
   			   "parts":["executionOrderType","executionOrderPriority"],
   			   "label":sas.fscf.rb.getText("rules.rulesPage.rules.table.column.orderAndPriority.txt"),
   			   "width":100,
   			   "formatter":"OrderPriority"
   		   },
   		   {
   			   "property":"multiOrgNodeDisplayName",
   			   "parts":["multiOrgNodeDisplayName","multiOrgNodeKey"],
   			   "label":sas.fscf.rb.getText("rules.rulesPage.rules.table.column.transactionScope.txt"),
   			   "width":150,
   			   "formatter":"TransScope"
   		   },
   		   {
   			   "property":"pendingApproval",
   			   "parts":["pendingApproval","lastUpdateUser"],
   			   "label":sas.fscf.rb.getText("rules.rulesPage.rules.table.column.deleteRequested.txt"),
   			   "width":100,
   			   "formatter":"RequestedBy"
   		   },
   		   {
   			   "property":"operationalState",
   			   "parts":["operationalState","configuredOperationalState"],
   			   "label":sas.fscf.rb.getText("rules.rulesPage.rules.table.column.status.txt"),
   			   "width":40,
   			   "formatter":"OpState",
   			   "type":1,
   			   "hAlign":sap.ui.core.HorizontalAlign.Center
   		   },
   		   {
   			   "property":"metrics/overall/ardFiredTxnCount/value",
   			   "parts":["metrics/overall/ardFiredTxnCount/value","metrics/overall/ardTxnPopulation/value","metrics/historical/ardFiredTxnCount/values"],
   			   "partsDescriptions":[sas.fscf.rb.getText("rules.rulesPage.rules.customerImpactRatio.negativeDecisions.txt"),sas.fscf.rb.getText("rules.rulesPage.rules.impactRatio.transactionsProcessed.txt")],
  			   "label":sas.fscf.rb.getText("rules.rulesPage.rules.table.column.customerImpactRatio.txt"),
   			   "width":125,
   			   "formatter":0,
   			   "type":2
   		   },
   		   {
   			   "property":"metrics/overall/alrtFiredTxnCount/value",
   			   "parts":["metrics/overall/alrtFiredTxnCount/value","metrics/overall/alrtTxnPopulation/value","metrics/historical/alrtFiredTxnCount/values"],
   			   "partsDescriptions":[sas.fscf.rb.getText("rules.rulesPage.rules.analystImpactRatio.alertsFired.txt"),sas.fscf.rb.getText("rules.rulesPage.rules.impactRatio.transactionsProcessed.txt")],
   			   "label":sas.fscf.rb.getText("rules.rulesPage.rules.table.column.analystImpactRatio.txt"),
   			   "width":125,
   			   "formatter":0,
   			   "type":2
   		   },
   		   {
   			   "property":"metrics/overall/execTimeExceededCount/value",
   			   "label":sas.fscf.rb.getText("rules.rulesPage.rules.table.column.runTime.txt"),
   			   "width":40,
   			   "formatter":"RunTime",
   			   "type":1,
   			   "hAlign":sap.ui.core.HorizontalAlign.Center
  		   },
			 {
				 "property":"lastUpdateUser",
				 "label":sas.fscf.rb.getText("rules.rulesPage.rules.table.column.lastUpdatedBy.txt"),
				 "width":150,
				 "formatter":0
			 },
			 {
				 "property":"lastUpdateTimestamp",
				 "label":sas.fscf.rb.getText("rules.rulesPage.rules.table.column.lastUpdatedTime.txt"),
				 "width":300,
				 "formatter":"DateTime"
			 }
	   ]

	},

	getTableKey: function() {
   		var key = sas.fscf.getCookie("cf_lastRulesState");
   		if (!key) {
   			key = this.STATE_PRODUCTION;
   		}
   		// Coding and Trash have the same columns
   		if (key == this.STATE_TRASH) {
   			key = this.STATE_CODING;
   		}
   		return key;
	},

	afterUpdateColumns: function() {
	},

    _bShowPanels: false,

	updateToolbar: function() {
		var _this = this;
   		var state = sas.fscf.getCookie("cf_lastRulesState");
		var oToolbar = sap.ui.getCore().byId(this.sId + "Toolbar");
		if (oToolbar) {
			if (oToolbar.getContent().length == 0) {
                var oButton1 = new sas.hc.m.Button({
       				id: oToolbar.sId + 'StateCodingButton',
		            text: sas.fscf.rb.getText("rules.rulesPage.rules.states.coding.txt"),
                    press: this.handleStatePress
		        });
                oButton1._key = _this.STATE_CODING;
                var oButton2 = new sas.hc.m.Button({
       				id: oToolbar.sId + 'StateTestingButton',
		            text: sas.fscf.rb.getText("rules.rulesPage.rules.states.testing.txt"),
                    press: this.handleStatePress
		        });
                oButton2._key = _this.STATE_TESTING;
                var oButton3 = new sas.hc.m.Button({
       				id: oToolbar.sId + 'StateProductionButton',
		            text: sas.fscf.rb.getText("rules.rulesPage.rules.states.production.txt"),
                    press: this.handleStatePress
		        });
                oButton3._key = _this.STATE_PRODUCTION;
                var oButton4 = new sas.hc.m.Button({
       				id: oToolbar.sId + 'StateTrashButton',
		            text: sas.fscf.rb.getText("rules.rulesPage.rules.states.trash.txt"),
                    press: this.handleStatePress
		        });
                oButton4._key = _this.STATE_TRASH;
		      	if (!state) {
		        	state = _this.STATE_PRODUCTION;
		    		sas.fscf.setCookie("cf_lastRulesState", state, sas.fscf.getNYearsFromNow(1));
		      	}
		      	var selectedButton = oButton1;
		      	if (state == _this.STATE_TESTING) {
		      		selectedButton = oButton2;
		      	} else if (state == _this.STATE_PRODUCTION) {
		      		selectedButton = oButton3;
		      	} else if (state == _this.STATE_TRASH) {
		      		selectedButton = oButton4;
		      	}
				oToolbar.addContent(new sas.hc.m.SegmentedButton({
	                id: oToolbar.sId + 'StateButtons',
		            buttons: [ oButton1,
		                       oButton2,
		                       oButton3,
		                       oButton4
		            ],
		            selectedButton: selectedButton
		        }).addStyleClass("cfRulesStateButtons"));
			}
			while (oToolbar.getContent().length > 1) {
				var item = oToolbar.getContent()[1];
				oToolbar.removeContent(item);
				item.destroy();
			}
			switch (state) {
				case _this.STATE_CODING:
                    var oUserFilterButton1 = new sas.hc.m.Button({
           				id: oToolbar.sId + 'UserFilterAllButton',
			            text: sas.fscf.rb.getText("rules.rulesPage.rules.actions.all.txt"),
                        press: this.handleUserFilterAllPress
			        });
                    var oUserFilterButton2 = new sas.hc.m.Button({
           				id: oToolbar.sId + 'UserFilterMineButton',
			            text: sas.fscf.rb.getText("rules.rulesPage.rules.actions.mine.txt"),
                        press: this.handleUserFilterMinePress
			        });
					oToolbar.addContent(new sas.hc.m.SegmentedButton({
		                id: oToolbar.sId + 'UserFilterButton',
			            buttons: [ oUserFilterButton1,
			                       oUserFilterButton2
			            ],
			            selectedButton: (sas.fscf.getCookie("cf_lastUserFilterMine") == "1") ? oUserFilterButton2 : oUserFilterButton1
			        }));
		            var oNewMenu = new sas.hc.m.Menu({
		                id: oToolbar.sId + 'NewMenu',
	                    items: [
	                        new sas.hc.m.MenuItem({
	    		                id: oToolbar.sId + 'NewMenuGuidedApproachMenuItem',
	                            text: sas.fscf.rb.getText("rules.rulesPage.rules.coding.actions.guidedApproach.txt"),
	                            press: this.handleNewGuidedApproachPress
	                        }),
	                        new sas.hc.m.MenuItem({
	    		                id: oToolbar.sId + 'NewMenuCodeEditorMenuItem',
	                            text: sas.fscf.rb.getText("rules.rulesPage.rules.coding.actions.codingApproach.txt"),
	                            press: this.handleNewCodingApproachPress
	                        })
	                    ]
	                });
		            oToolbar.addContent(new sas.hc.m.MenuButton({
		                id: oToolbar.sId + 'NewMenuButton',
		                icon: sas.icons.HC.NEWSTARBURST,
		                tooltip: sas.fscf.rb.getText("fcm.overview.new.txt"),
	                    showDownArrowIconOnly: true,
		                menu:  oNewMenu
		            }));
		            oToolbar.addContent(new sas.hc.m.Button({
		                id: oToolbar.sId + 'ImportButton',
		                icon: sas.icons.HC.IMPORT,
		                tooltip: sas.fscf.rb.getText("fcm.overview.import.txt"),
		                press: this.handleImportPress
		            }));
		            oToolbar.addContent(new sas.hc.m.Button({
		                id: oToolbar.sId + 'EditButton',
		                icon: sas.icons.HC.EDIT,
		                tooltip: sas.fscf.rb.getText("fcm.application.edit.txt"),
		                press: this.handleEditPress,
		                enabled: false
		            }));
		            oToolbar.addContent(new sas.hc.m.Button({
		                id: oToolbar.sId + 'PromoteToTestingButton',
		                icon: sas.icons.HC.PROMOTED,
		                tooltip: sas.fscf.rb.getText("rules.rulesPage.rules.coding.actions.promoteToTesting.txt"),
		                press: this.handlePromoteToTestingPress,
		                enabled: false
		            }));
		            oToolbar.addContent(new sas.hc.m.Button({
		                id: oToolbar.sId + 'DeleteButton',
		                icon: sas.icons.HC.DELETE,
		                tooltip: sas.fscf.rb.getText("fcm.overview.delete.txt"),
		                press: this.handleDeletePress,
		                enabled: false
		            }));
		            oToolbar.addContent(new sas.hc.m.Button({
		                id: oToolbar.sId + 'ShowHistoryButton',
		                icon: sas.icons.HC.HISTORY,
		                tooltip: sas.fscf.rb.getText("rules.rulesPage.rules.actions.showHistory.txt"),
						press: [this.handleShowHistoryPress, this],
		                enabled: false
		            }));
		            oToolbar.addContent(new sas.hc.m.Button({
		                id: oToolbar.sId + 'ExportButton',
		                icon: sas.icons.HC.EXPORT,
		                tooltip: sas.fscf.rb.getText("fcm.overview.export.txt"),
		                press: this.handleExportPress,
		                enabled: false
		            }));
		            oToolbar.addContent(new sas.hc.m.Button({
		                id: oToolbar.sId + 'PrintButton',
		                icon: sas.icons.HC.PRINT,
		                tooltip: sas.fscf.rb.getText("fcm.application.print.txt"),
		                press: this.handlePrintPress,
		                enabled: false
		            }));
		            oToolbar.addContent(new sas.hc.m.Button({
		                id: oToolbar.sId + 'PrioritizeButton',
		                icon: sas.icons.HC.RANKING,
		                tooltip: sas.fscf.rb.getText("fcm.overview.prioritize.txt"),
		                press: this.handlePrioritizePress
		            }));
					oToolbar.addContent(new sas.hc.m.Button({
					    id: oToolbar.sId + 'RefreshButton',
					    icon: sas.icons.HC.REFRESH,
					    tooltip: sas.fscf.rb.getText("fcm.application.refresh.txt"),
					    press: this.handleRefreshPress
					}));
					break;
				case _this.STATE_TESTING:
					if (!sas.fscf.userHasPrivilege("PWARULE")) {//User cannot promote without approval, this stays the same
			            oToolbar.addContent(new sas.hc.m.Button({
			                id: oToolbar.sId + 'RequestPromoteToProductionButton',
			                icon: "sap-icon://hr-approval",
			                tooltip: sas.fscf.rb.getText("rules.rulesPage.rules.testing.actions.requestPromoteToProduction.txt"),
			                press: this.handleRequestPromoteToProductionPress,
			                enabled: false
			            }));
					}
		            oToolbar.addContent(new sas.hc.m.Button({
		                id: oToolbar.sId + 'PromoteToProductionButton',
		                icon: sas.icons.HC.PROMOTED,
		                tooltip: sas.fscf.rb.getText("rules.rulesPage.rules.testing.actions.promoteToProduction.txt"),
		                press: this.handlePromoteToProductionPress,
		                enabled: false
		            }));
		            oToolbar.addContent(new sas.hc.m.Button({
		                id: oToolbar.sId + 'DisableButton',
		                icon: sas.icons.HC.DEACTIVATE,
		                tooltip: sas.fscf.rb.getText("rules.rulesPage.rules.production.actions.disable.txt"),
		                press: this.handleDisablePress,
		                enabled: false
		            }));
		            oToolbar.addContent(new sas.hc.m.Button({
		                id: oToolbar.sId + 'EnableButton',
		                icon: sas.icons.HC.ACTIVATE,
		                tooltip: sas.fscf.rb.getText("rules.rulesPage.rules.production.actions.enable.txt"),
		                press: this.handleEnablePress,
		                enabled: false
		            }));
		            oToolbar.addContent(new sas.hc.m.Button({
		                id: oToolbar.sId + 'MoveToCodingButton',
		                icon: sas.icons.HC.CODE,
		                tooltip: sas.fscf.rb.getText("rules.rulesPage.rules.testing.actions.moveToCoding.txt"),
		                press: this.handleMoveToCodingPress,
		                enabled: false
		            }));
		            oToolbar.addContent(new sas.hc.m.Button({
		                id: oToolbar.sId + 'ShowHistoryButton',
		                icon: sas.icons.HC.HISTORY,
		                tooltip: sas.fscf.rb.getText("rules.rulesPage.rules.actions.showHistory.txt"),
						press: [this.handleShowHistoryPress, this],
		                enabled: false
		            }));
		            oToolbar.addContent(new sas.hc.m.Button({
		                id: oToolbar.sId + 'ExportButton',
		                icon: sas.icons.HC.EXPORT,
		                tooltip: sas.fscf.rb.getText("fcm.overview.export.txt"),
		                press: this.handleExportPress,
		                enabled: false
		            }));
		            oToolbar.addContent(new sas.hc.m.Button({
		                id: oToolbar.sId + 'PrintButton',
		                icon: sas.icons.HC.PRINT,
		                tooltip: sas.fscf.rb.getText("fcm.application.print.txt"),
		                press: this.handlePrintPress,
		                enabled: false
		            }));
					oToolbar.addContent(new sas.hc.m.Button({
					    id: oToolbar.sId + 'RefreshButton',
					    icon: sas.icons.HC.REFRESH,
					    tooltip: sas.fscf.rb.getText("fcm.application.refresh.txt"),
					    press: this.handleRefreshPress
					}));
					break;
				case _this.STATE_PRODUCTION:
		            oToolbar.addContent(new sas.hc.m.Button({
		                id: oToolbar.sId + 'DisableButton',
		                icon: sas.icons.HC.DEACTIVATE,
		                tooltip: sas.fscf.rb.getText("rules.rulesPage.rules.production.actions.disable.txt"),
		                press: this.handleDisablePress,
		                enabled: false
		            }));
		            oToolbar.addContent(new sas.hc.m.Button({
		                id: oToolbar.sId + 'EnableButton',
		                icon: sas.icons.HC.ACTIVATE,
		                tooltip: sas.fscf.rb.getText("rules.rulesPage.rules.production.actions.enable.txt"),
		                press: this.handleEnablePress,
		                enabled: false
		            }));
					if (!sas.fscf.userHasPrivilege("DWARULE")) {//User cannot delete without approval, this stays the same
			            oToolbar.addContent(new sas.hc.m.Button({
			                id: oToolbar.sId + 'RequestDeleteButton',
			                icon: "sap-icon://hr-approval",
			                tooltip: sas.fscf.rb.getText("rules.rulesPage.rules.production.actions.requestDelete.txt"),
			                press: this.handleRequestDeletePress,
			                enabled: false
			            }));
					}
		            oToolbar.addContent(new sas.hc.m.Button({
		                id: oToolbar.sId + 'DeleteButton',
		                icon: sas.icons.HC.DELETE,
		                tooltip: sas.fscf.rb.getText("fcm.overview.delete.txt"),
		                press: this.handleDeletePress,
		                enabled: false
		            }));
		            oToolbar.addContent(new sas.hc.m.Button({
		                id: oToolbar.sId + 'CreateNewVersionButton',
		                icon: sas.icons.HC.CODE,
		                tooltip: sas.fscf.rb.getText("rules.rulesPage.rules.actions.createNewVersion.txt"),
		                press: [this.handleCreateNewVersionPress, this],
		                enabled: false
		            }));
		            oToolbar.addContent(new sas.hc.m.Button({
		                id: oToolbar.sId + 'ShowHistoryButton',
		                icon: sas.icons.HC.HISTORY,
		                tooltip: sas.fscf.rb.getText("rules.rulesPage.rules.actions.showHistory.txt"),
						press: [this.handleShowHistoryPress, this],
		                enabled: false
		            }));
		            oToolbar.addContent(new sas.hc.m.Button({
		                id: oToolbar.sId + 'ExportButton',
		                icon: sas.icons.HC.EXPORT,
		                tooltip: sas.fscf.rb.getText("fcm.overview.export.txt"),
		                press: this.handleExportPress,
		                enabled: false
		            }));
		            oToolbar.addContent(new sas.hc.m.Button({
		                id: oToolbar.sId + 'PrintButton',
		                icon: sas.icons.HC.PRINT,
		                tooltip: sas.fscf.rb.getText("fcm.application.print.txt"),
		                press: this.handlePrintPress,
		                enabled: false
		            }));
					oToolbar.addContent(new sas.hc.m.Button({
					    id: oToolbar.sId + 'RefreshButton',
					    icon: sas.icons.HC.REFRESH,
					    tooltip: sas.fscf.rb.getText("fcm.application.refresh.txt"),
					    press: this.handleRefreshPress
					}));
					break;
				case _this.STATE_TRASH:
		            oToolbar.addContent(new sas.hc.m.Button({
		                id: oToolbar.sId + 'EmptyFromTrashButton',
		                icon: sas.icons.HC.REMOVEITEM,
		                tooltip: sas.fscf.rb.getText("rules.rulesPage.rules.trash.actions.emptyFromTrash.txt"),
		                press: this.handleDeleteFromTrashPress,
		                enabled: false
		            }));
		            oToolbar.addContent(new sas.hc.m.Button({
		                id: oToolbar.sId + 'EmptyAllTrashButton',
		                icon: sas.icons.HC.CLEARALL,
		                tooltip: sas.fscf.rb.getText("rules.rulesPage.rules.trash.actions.emptyAllTrash.txt"),
		                press: this.handleEmptyTrashPress
		            }));
		            oToolbar.addContent(new sas.hc.m.Button({
		                id: oToolbar.sId + 'CreateNewVersionButton',
		                icon: sas.icons.HC.CODE,
		                tooltip: sas.fscf.rb.getText("rules.rulesPage.rules.actions.createNewVersion.txt"),
		                press: [this.handleCreateNewVersionPress, this],
		                enabled: false
		            }));
		            oToolbar.addContent(new sas.hc.m.Button({
		                id: oToolbar.sId + 'ShowHistoryButton',
		                icon: sas.icons.HC.HISTORY,
		                tooltip: sas.fscf.rb.getText("rules.rulesPage.rules.actions.showHistory.txt"),
		                press: [this.handleShowHistoryPress, this],
		                enabled: false
		            }));
		            oToolbar.addContent(new sas.hc.m.Button({
		                id: oToolbar.sId + 'PrintButton',
		                icon: sas.icons.HC.PRINT,
		                tooltip: sas.fscf.rb.getText("fcm.application.print.txt"),
		                press: this.handlePrintPress,
		                enabled: false
		            }));
					oToolbar.addContent(new sas.hc.m.Button({
					    id: oToolbar.sId + 'RefreshButton',
					    icon: sas.icons.HC.REFRESH,
					    tooltip: sas.fscf.rb.getText("fcm.application.refresh.txt"),
					    press: this.handleRefreshPress
					}));
					break;
				default:
					break;
			}
		}
	},

	updateToolbarEnablement: function(selectedRowsData) {
   		var state = sas.fscf.getCookie("cf_lastRulesState");
		var oToolbar = sap.ui.getCore().byId(this.sId + "Toolbar");
		var numItemsSelected = selectedRowsData.length;
		var bAnyRows = this.getTableHasAnyRows();

		let userHasUpdatePrivilege = sas.fscf.userHasPrivilege("UPDTRULE");
		let userHasPromotePrivilege = sas.fscf.userHasPrivilege("PWARULE") || sas.fscf.userHasPrivilege("APRULE");
		if (oToolbar) {
			switch (state) {
				case this.STATE_CODING:
					var o = sap.ui.getCore().byId(oToolbar.sId + 'NewMenuButton');
					if (o) {
						o.setEnabled(userHasUpdatePrivilege);
					}
					o = sap.ui.getCore().byId(oToolbar.sId + 'ImportButton');
					if (o) {
						o.setEnabled(userHasUpdatePrivilege);
					}
					o = sap.ui.getCore().byId(oToolbar.sId + 'EditButton');
					if (o) {
						o.setEnabled(userHasUpdatePrivilege && numItemsSelected == 1);
					}
					o = sap.ui.getCore().byId(oToolbar.sId + 'PromoteToTestingButton');
					if (o) {
						let promoteButtonEnabled = numItemsSelected >= 1 && userHasUpdatePrivilege;
						o.setEnabled(promoteButtonEnabled);
					}
					o = sap.ui.getCore().byId(oToolbar.sId + 'DeleteButton');
					if (o) {
						o.setEnabled(userHasUpdatePrivilege && numItemsSelected >= 1);
					}
					o = sap.ui.getCore().byId(oToolbar.sId + 'ShowHistoryButton');
					if (o) {
						o.setEnabled(numItemsSelected == 1);
					}
					o = sap.ui.getCore().byId( oToolbar.sId + 'ExportButton');
					if (o) {
						o.setEnabled(userHasUpdatePrivilege && numItemsSelected >= 1);
					}
					o = sap.ui.getCore().byId(oToolbar.sId + 'PrintButton');
					if (o) {
						o.setEnabled(numItemsSelected >= 1);
					}
					o = sap.ui.getCore().byId(oToolbar.sId + 'PrioritizeButton');
					if (o) {
						o.setEnabled(userHasUpdatePrivilege);
					}
					break;
				case this.STATE_TESTING:
					var o = sap.ui.getCore().byId(oToolbar.sId + 'RequestPromoteToProductionButton');
					if (o) {
						var bCanRequest = numItemsSelected >= 1 && userHasUpdatePrivilege;
						if (bCanRequest) {
							for (var i = 0; i < selectedRowsData.length; i++) {
								// cannot request if already requested
								if (selectedRowsData[i].pendingApproval) {
									bCanRequest = false;
									break;
								}
							}
						}
						o.setEnabled(bCanRequest);
					}
					o = sap.ui.getCore().byId(oToolbar.sId + 'PromoteToProductionButton');
					if (o) {
						var bCanPromote = userHasPromotePrivilege && numItemsSelected >= 1;
						//cannot promote others' rules without at least one of the 2 privileges PWA or AP 
						if (!sas.fscf.userHasPrivilege("PWARULE") && !sas.fscf.userHasPrivilege("APRULE")){
							bCanPromote= false;
						}
						if (bCanPromote) {
							if (!sas.fscf.userHasPrivilege("PWARULE")) {//user cannot promote without approval, this stays the same								
								for (var i = 0; i < selectedRowsData.length; i++) {
									// have to be requested and by somebody else to promote (cannot review your own)
									if (selectedRowsData[i].pendingApproval) {
										if (selectedRowsData[i].lastUpdateUser == sas.fscf.currentUser.name) {
											bCanPromote = false;
											break;
										}
									} else {
										bCanPromote = false;
										break;
									}
								}
							}
						}
						o.setEnabled(bCanPromote);
					}
					o = sap.ui.getCore().byId(oToolbar.sId + 'DisableButton');
					if (o) {
						var bCanDisable = sas.fscf.userHasPrivilege("DISENARULE") && numItemsSelected >= 1;
						o.setEnabled(bCanDisable);
					}
					o = sap.ui.getCore().byId(oToolbar.sId + 'EnableButton');
					if (o) {
						var bCanEnable = sas.fscf.userHasPrivilege("DISENARULE") && numItemsSelected >= 1;
						o.setEnabled(bCanEnable);
					}
					o = sap.ui.getCore().byId(oToolbar.sId + 'MoveToCodingButton');
					if (o) {
						o.setEnabled(numItemsSelected >= 1);
					}
					o = sap.ui.getCore().byId(oToolbar.sId + 'ShowHistoryButton');
					if (o) {
						o.setEnabled(numItemsSelected == 1);
					}
					o = sap.ui.getCore().byId(oToolbar.sId + 'ExportButton');
					if (o) {
						o.setEnabled(userHasUpdatePrivilege && numItemsSelected >= 1);
					}
					o = sap.ui.getCore().byId(oToolbar.sId + 'PrintButton');
					if (o) {
						o.setEnabled(numItemsSelected >= 1);
					}
					break;
				case this.STATE_PRODUCTION:
					var o = sap.ui.getCore().byId(oToolbar.sId + 'DisableButton');
					if (o) {
						var bCanDisable = sas.fscf.userHasPrivilege("DISENARULE") && numItemsSelected >= 1;
						o.setEnabled(bCanDisable);
					}
					o = sap.ui.getCore().byId(oToolbar.sId + 'EnableButton');
					if (o) {
						var bCanEnable = sas.fscf.userHasPrivilege("DISENARULE") && numItemsSelected >= 1;
						o.setEnabled(bCanEnable);
					}
					o = sap.ui.getCore().byId(oToolbar.sId + 'RequestDeleteButton');
					if (o) {
						let userHasPrivileges = 
								sas.fscf.userHasPrivilege("DWARULE") || sas.fscf.userHasPrivilege("ADRULE") ||
								sas.fscf.userHasPrivilege("UPDTRULE");
								
								
						var bCanRequest = userHasPrivileges && numItemsSelected >= 1;
						if (bCanRequest) {
							for (var i = 0; i < selectedRowsData.length; i++) {
								// cannot request if already requested
								if (selectedRowsData[i].pendingApproval) {
									bCanRequest = false;
									break;
								}
							}
						}
						o.setEnabled(bCanRequest);
					}
					o = sap.ui.getCore().byId(oToolbar.sId + 'DeleteButton');
					if (o) {
						var bCanDelete = numItemsSelected >= 1;
						//cannot promote others' rules without at least one of the 2 privileges PWA or AP 
						if (!sas.fscf.userHasPrivilege("DWARULE") && !sas.fscf.userHasPrivilege("ADRULE")){
							bCanDelete= false;
						}
						if (bCanDelete) {
							if (!sas.fscf.userHasPrivilege("DWARULE")) {
								for (var i = 0; i < selectedRowsData.length; i++) {
									// have to be requested and by somebody else to delete (cannot review your own)
									if (selectedRowsData[i].pendingApproval) {
										if (selectedRowsData[i].lastUpdateUser == sas.fscf.currentUser.name) {
											bCanDelete = false;
											break;
										}
									} else {
										bCanDelete = false;
										break;
									}
								}
							}
						}
						o.setEnabled(bCanDelete);
					}
					o = sap.ui.getCore().byId(oToolbar.sId + 'CreateNewVersionButton');
					if (o) {
						o.setEnabled(sas.fscf.userHasPrivilege("UPDTRULE") && numItemsSelected == 1);
					}
					o = sap.ui.getCore().byId(oToolbar.sId + 'ShowHistoryButton');
					if (o) {
						o.setEnabled(numItemsSelected == 1);
					}
					o = sap.ui.getCore().byId(oToolbar.sId + 'ExportButton');
					if (o) {
						o.setEnabled(userHasUpdatePrivilege && numItemsSelected >= 1);
					}
					o = sap.ui.getCore().byId(oToolbar.sId + 'PrintButton');
					if (o) {
						o.setEnabled(numItemsSelected >= 1);
					}
					break;
				case this.STATE_TRASH:
					var o = sap.ui.getCore().byId(oToolbar.sId + 'EmptyFromTrashButton');
					if (o) {
						o.setEnabled(sas.fscf.userHasPrivilege("UPDTRULE") && numItemsSelected >= 1);
					}
					o = sap.ui.getCore().byId(oToolbar.sId + 'EmptyAllTrashButton');
					if (o) {
						o.setEnabled(sas.fscf.userHasPrivilege("UPDTRULE") && bAnyRows);
					}
					o = sap.ui.getCore().byId(oToolbar.sId + 'CreateNewVersionButton');
					if (o) {
						o.setEnabled(sas.fscf.userHasPrivilege("UPDTRULE") && numItemsSelected == 1);
					}
					o = sap.ui.getCore().byId(oToolbar.sId + 'ShowHistoryButton');
					if (o) {
						o.setEnabled(numItemsSelected == 1);
					}
					o = sap.ui.getCore().byId(oToolbar.sId + 'PrintButton');
					if (o) {
						o.setEnabled(numItemsSelected >= 1);
					}
					break;
				default:
					break;
			}
		}
	},

	updatePanels: function() {
	},

	getTableUrl: function(searchTerm) {
   		var state = sas.fscf.getCookie("cf_lastRulesState");
		var url = 'rest/businessunits/' + this.getBUId() + '/rules?filter=state==\'' + state + '\'';
		if (state == this.STATE_CODING && sas.fscf.getCookie("cf_lastUserFilterMine") == "1") {
			url += ' and createUser==\'@currentUser\'';
		}
		if (searchTerm && searchTerm.length > 0) {
			// cast all pieces to lowercase to make sure the search is case insensitive
			var searchTermLower = searchTerm.toLowerCase();
			url += ' and ((name!=null and name.toLowerCase().contains(\'' + searchTermLower + '\')) or (description!=null and description.toLowerCase().contains(\'' + searchTermLower + '\')) or (ruleCode!=null and ruleCode.toLowerCase().contains(\'' + searchTermLower + '\')))';
		}
		// the fields in the next line must be present for all tables as they are the base fields used by the columns and to edit a rule, etc.
		// extra fields that are only used by print are and should be gotten separately in handlePrintPress
		url += '&fields=id,baseRuleId,revision,name,description,ruleTypeName,operationalTimeLimit,businessUnitId,alertTypeId,executionOrderType,executionOrderPriority,multiOrgNodeId,multiOrgNodeDisplayName,multiOrgNodeKey,guidedRule,lastUpdateUser,lastUpdateTimestamp,lastUpdateNumber,transactionTypeId,queueId,alertReason,pendingApproval';
		if (searchTerm && searchTerm.length > 0) {
			url += ',ruleCode';
		}
		if ((state == this.STATE_TESTING && sas.fscf.deployTestingRules) || state == this.STATE_PRODUCTION) {
			url += ',operationalState,configuredOperationalState,metrics';
		}
		return url;
	},

	doDefaultAction: function() {
    	var _this = sap.ui.getCore().byId("RulesPageRulesView");
   		var state = sas.fscf.getCookie("cf_lastRulesState");
		
		switch (state) {
            case _this.STATE_CODING:
                if(sas.fscf.userHasPrivilege("UPDTRULE")) {
                    _this.handleEditPress();
                } else {
                    _this.handlePrintPress();
                }
                break;
            case _this.STATE_TESTING:
                _this.handlePrintPress();
                break;
            case _this.STATE_PRODUCTION:
                _this.handlePrintPress();
                break;
            case _this.STATE_TRASH:
                _this.handlePrintPress();
                break;
            default:
                break;
        }
	},

	getTextFormatter: function(type) {
		if (type == "DateTime") {
			return function(val) {
				if (val == undefined || val == null) {
					return val;
				}
				var date = new Date(val);
				if (isNaN(date.getTime())) {
					return val;
				}
				return sas.fscf.dateTimeFormatter.format(date, true);	// true means use UTC
			}
		} else if (type == "YesNo"){
			return function(val) {
				if (val == true || val == "true") {
					return sas.fscf.rb.getText("fcm.application.yes.txt");
				} else if (val == false || val == "false") {
					return sas.fscf.rb.getText("fcm.application.no.txt");
				}
				return val;
			}
		} else if (type == "OrderPriority"){
			return function(val, val2) {
				if (val == 0) {
					return sas.fscf.rb.getText("rules.rulesPage.rules.order.main.txt");
				} else if (val == 1) {
					return sas.fscf.rb.getText("rules.rulesPage.rules.order.post.txt") + " : " + val2;
				} else if (val == -1) {
					return sas.fscf.rb.getText("rules.rulesPage.rules.order.pre.txt") + " : " + val2;
				}
				return val;
			}
		} else if (type == "TransScope"){
			return function(val, val2) {
				if (val2 && val2 != "" && val2 != " ") {
					return val + " (" + val2 + ")";
				}
				return val;
			}
		} else if (type == "ID"){
			return function(val, val2) {
				return val + "." + val2;
			}
		} else if (type == "RuleType"){
			return function(val, val2) {
				if (val2 && val2 != "" && val2 != " ") {
					if (val && val != "" && val != " ") {
						return sas.fscf.rb.getText("rules.rulesPage.rules.type." + val.toLowerCase() + ".txt") + " (" + val2 + ")";
					}
					return val + " (" + val2 + ")";
				}
				if (val && val != "" && val != " ") {
					return sas.fscf.rb.getText("rules.rulesPage.rules.type." + val.toLowerCase() + ".txt");
				}
				return val;
			}
		} else if (type == "RequestedBy"){
			return function(val, val2) {
				if (val) {
					return sas.fscf.rb.getText("rules.rulesPage.rules.requestAction.byUser.fmt.txt", val2);
				}
				return "";
			}
		} else {
			return function(val) {
				return val;
			}
		}
	},

	getIconURI: function(type) {
		if (type == "OpState") {
			return function(val, val2) {
				if (val == 0) {
					return sas.icons.HC.SUBMITTEDSTATUS;
				} else if (val == 1) {
					return sas.icons.HC.STOPPEDSTATUS;
				} else if (val2 == 0) {
					return sas.icons.HC.SUBMITTEDSTATUS;
				} else if (val2 == 1) {
					return sas.icons.HC.STOPPEDSTATUS;
				}
			}
		} else if (type == "RunTime") {
			return function(val) {
				if (val == 1) {
					return sas.icons.HC.WARNINGSTATUS;
				} else if (val >= 2) {
					return sas.icons.HC.IMPORTANTSTATUS;
				}
			}
		}
	},

	getIconTooltip: function(type) {
		if (type == "OpState") {
			return function(val, val2) {
				if (val == 0) {
					return sas.fscf.rb.getText("rules.rulesPage.rules.opState.running.txt");
				} else if (val == 1) {
					return sas.fscf.rb.getText("rules.rulesPage.rules.opState.disabled.txt");
				} else if (val2 == 0) {
					return sas.fscf.rb.getText("rules.rulesPage.rules.opState.pending.txt");
				} else if (val2 == 1) {
					return sas.fscf.rb.getText("rules.rulesPage.rules.opState.pending.txt") + ", " + sas.fscf.rb.getText("rules.rulesPage.rules.opState.disabled.txt");
				}
			}
		} else if (type == "RunTime") {
			return function(val) {
				if (val == 1) {
					return sas.fscf.rb.getText("rules.rulesPage.rules.runTime.exceeded.txt");
				} else if (val >= 2) {
					return sas.fscf.rb.getText("rules.rulesPage.rules.runTime.exceeded.nTimes.fmt.txt", val);
				}
			}
		}
	},

	getIconOpacity: function(type) {
		if (type == "OpState") {
			return function(val, val2) {
				if (val == 0 || val == 1) {
					return 1.0;
				} else {
					return 0.3;
				}
			}
		} else if (type == "RunTime") {
			return function(val) {
				return 1.0;
			}
		}
	},

	switchToState: function(state) {
   		var curState = sas.fscf.getCookie("cf_lastRulesState");
   		if (state != curState) {
   			var oButton = sap.ui.getCore().byId(this.sId + "ToolbarState" + state + "Button");
   			if (oButton) {
   				oButton.firePress();
   			}
   		}
	},

	handleStatePress: function(e) {
  		sas.fscf.removeAllMessageStrips();
		sas.fscf.setCookie("cf_lastRulesState", e.getSource()._key, sas.fscf.getNYearsFromNow(1));
    	var _this = sap.ui.getCore().byId("RulesPageRulesView");
  		_this.update(true);
	},

    handleUserFilterAllPress: function(e) {
  		sas.fscf.removeAllMessageStrips();
		sas.fscf.setCookie("cf_lastUserFilterMine", "0", sas.fscf.getNYearsFromNow(1));
    	var _this = sap.ui.getCore().byId("RulesPageRulesView");
    	_this.updateTable();
    },

    handleUserFilterMinePress: function(e) {
  		sas.fscf.removeAllMessageStrips();
		sas.fscf.setCookie("cf_lastUserFilterMine", "1", sas.fscf.getNYearsFromNow(1));
    	var _this = sap.ui.getCore().byId("RulesPageRulesView");
    	_this.updateTable();
    },

	handleNewGuidedApproachPress: function(e) {
  		sas.fscf.removeAllMessageStrips();
		sas.fscf.ruleApproach = sas.fscf.RULE_APPROACH_GUIDED;
		sas.fscf.getCurrentPageView().jsonRule = null;
		sas.fscf.getCurrentPageView().getRulePropertiesDialog(false).open();
	},

	handleNewCodingApproachPress: function(e) {
  		sas.fscf.removeAllMessageStrips();
		sas.fscf.ruleApproach = sas.fscf.RULE_APPROACH_CODING;
		sas.fscf.getCurrentPageView().jsonRule = null;
		sas.fscf.getCurrentPageView().getRulePropertiesDialog(true).open();
	},

	handleImportPress: function(e) {
  		sas.fscf.removeAllMessageStrips();
    	var view = sap.ui.jsfragment({
            type: sap.ui.core.mvc.ViewType.JS,
            id: this.sId + "ImportRulesDialog",
            fragmentName: "sas.fscf.views.fragments.ImportRulesDialog"
        });
    	view.open();
	},

	handleEditPress: function(e) {
  		sas.fscf.removeAllMessageStrips();
    	var _this = sap.ui.getCore().byId("RulesPageRulesView");
		var rowData = _this.getTableSelectedRowsData()[0];
		if (rowData) {
		   sas.fscf.ruleApproach = (rowData["guidedRule"]) ? parent.sas.fscf.RULE_APPROACH_GUIDED : parent.sas.fscf.RULE_APPROACH_CODING;

		   sas.fscf.getCurrentPageView().jsonRule = {
				"id":rowData["id"],
				"name":rowData["name"],
				"revision":rowData["revision"],
				"lastUpdateNumber":rowData["lastUpdateNumber"],
				"transactionTypeId":rowData["transactionTypeId"],
				"multiOrgNodeId":rowData["multiOrgNodeId"],
				"description":rowData["description"],
				"createUser":rowData["createUser"],
				"businessUnitId":rowData["businessUnitId"],
				"guidedRule":rowData["guidedRule"],
				"alertTypeId":rowData["alertTypeId"],
				"queueId":rowData["queueId"],
				"alertReason":rowData["alertReason"],
				"operationalTimeLimit":rowData["operationalTimeLimit"]
		   };

		   /****/
		   if (rowData["guidedRule"] == true) {
				sas.fscf.ruleApproach = sas.fscf.RULE_APPROACH_GUIDED;
				//sas.fscf.getCurrentPageView().isDevEnv = parent.frames["overview"].getContent("isDevEnv");
				_this.getExpressionsRuleCode(true,rowData["id"]);
			}else{
				sas.fscf.ruleApproach = sas.fscf.RULE_APPROACH_CODING;
				sas.fscf.getCurrentPageView().jsonRule.ruleTypeName=rowData["ruleTypeName"];
				//sas.fscf.getCurrentPageView().isDevEnv = frames["overview"].getContent("isDevEnv");
		    	_this.getExpressionsRuleCode(false,rowData["id"]);
			}
		   /****/
		}
	},

	promoteRuleToTesting: function(id) {
		this.changeRuleState(this.STATE_TESTING, sas.fscf.rb.getText("rules.rulesPage.ruleAction.one.movedTo.Testing.txt"), [id]);
		this.switchToState(this.STATE_TESTING);		
	},

	handlePromoteToTestingPress: function(e) {
		sas.fscf.removeAllMessageStrips();
		
    	var _this = sap.ui.getCore().byId("RulesPageRulesView");    	

    	var proceed = function() {
    		sap.ui.getCore().byId("RulesPageRulesViewToolbarPromoteToTestingButton").setEnabled(false);
			_this.changeRuleState(_this.STATE_TESTING, sas.fscf.rb.getText("rules.rulesPage.ruleAction.movedTo.Testing.txt"));			
		}
		
		if (_this.getTableSelectedRowsData().length > 5) {
			sas.hc.m.MessageDialog.warning({
	            title: sas.fscf.rb.getText('fcm.application.confirm.txt'),
	            text: sas.fscf.rb.getText('rules.rulesPage.ruleAction.moveLargeNumber.confirm.fmt.msg.txt', _this.getTableSelectedRowsData().length),
	            buttonActions: [sas.hc.m.MessageDialogAction.Ok, sas.hc.m.MessageDialogAction.Cancel]
	        }).attachButtonPress(function(e) {
	            var action = e.getParameter("origin").getMessageDialogAction();
				if (action == sas.hc.m.MessageDialogAction.Ok) {
					proceed();
				}
	        });			
		} else {
			proceed();
		}
	},

	handleRequestDeletePress: function(e) {
  		sas.fscf.removeAllMessageStrips();
    	var _this = sap.ui.getCore().byId("RulesPageRulesView");
       	var view = sap.ui.jsfragment({
             type: sap.ui.core.mvc.ViewType.JS,
             id: _this.sId + "RequestActionDialog",
             fragmentName: "sas.fscf.views.fragments.RequestActionDialog"
        });
       	view.setActionType(1);
    	var dialog = view.lazyLoadContent();
       	dialog.open();
	},

	handleDeletePress: function(e) {
  		sas.fscf.removeAllMessageStrips();
   		var state = sas.fscf.getCookie("cf_lastRulesState");

    	var _this = sap.ui.getCore().byId("RulesPageRulesView");    	

    	var proceed = function() {
        	if (state != _this.STATE_PRODUCTION || 
        	   (sas.fscf.userHasPrivilege("DWARULE") || sas.fscf.userHasPrivilege("ADRULE"))) {//user can deactivate without approval or can approve and deactivate) {
        		sap.ui.getCore().byId("RulesPageRulesViewToolbarDeleteButton").setEnabled(false);
        		_this.changeRuleState(_this.STATE_TRASH, sas.fscf.rb.getText("rules.rulesPage.ruleAction.movedTo.Trash.txt"));
        	} else {
            	var view = sap.ui.jsfragment({
                    type: sap.ui.core.mvc.ViewType.JS,
                    id: _this.sId + "RequestActionDialog",
                    fragmentName: "sas.fscf.views.fragments.RequestActionDialog"
                });
               	view.setActionType(1);
            	var dialog = view.lazyLoadContent();
               	dialog.open();
        	}
		}
		
		if (_this.getTableSelectedRowsData().length > 5) {
			sas.hc.m.MessageDialog.warning({
	            title: sas.fscf.rb.getText('fcm.application.confirm.txt'),
	            text: sas.fscf.rb.getText('rules.rulesPage.ruleAction.moveLargeNumber.confirm.fmt.msg.txt', _this.getTableSelectedRowsData().length),
	            buttonActions: [sas.hc.m.MessageDialogAction.Ok, sas.hc.m.MessageDialogAction.Cancel]
	        }).attachButtonPress(function(e) {
	            var action = e.getParameter("origin").getMessageDialogAction();
				if (action == sas.hc.m.MessageDialogAction.Ok) {
					proceed();
				}
	        });			
		} else {
			proceed();
		}		
	},

	handleDeleteFromTrashPress: function(e) {
		sap.ui.getCore().byId("RulesPageRulesViewToolbarEmptyFromTrashButton").setEnabled(false);
		sas.fscf.removeAllMessageStrips();  		
		sas.hc.m.MessageDialog.warning({
            title: sas.fscf.rb.getText('fcm.application.confirm.txt'),
            text: sas.fscf.rb.getText('rules.rulesPage.rules.trash.actions.emptyFromTrash.confirm.msg.txt'),
            buttonActions: [sas.hc.m.MessageDialogAction.Ok, sas.hc.m.MessageDialogAction.Cancel]
        }).attachButtonPress(function(e) {
            var action = e.getParameter("origin").getMessageDialogAction();
			if (action == sas.hc.m.MessageDialogAction.Ok) {
		    	var _this = sap.ui.getCore().byId("RulesPageRulesView");
		    	sap.ui.getCore().byId("RulesPageRulesViewToolbarEmptyFromTrashButton").setEnabled(false);
				sas.fscf.getApplicationView().setBusyIndicatorDelay(0).setBusy(true);
				var rowsData = _this.getTableSelectedRowsData();
				var jsonData = [];
				for (var i = 0; i < rowsData.length; i++) {
					jsonData.push({id: rowsData[i]["id"]});
				}
				sas.ajax({url:"rest/businessunits/" + rowsData[0]["businessUnitId"] + "/rules/", type: "DELETE", data: jsonData, headers:sas.fscf.getAjaxHeaders()})
			  	  .done(function(oData){
			  		 sas.fscf.showMessageStrip(sap.ui.core.MessageType.Success, sas.fscf.rb.getText("rules.rulesPage.ruleAction.deletedFrom.Trash.txt"), _this.sId + "BorderLayoutCenter");
			  		 _this.updateTable();
			  		sap.ui.getCore().byId("RulesPageRulesViewToolbarEmptyFromTrashButton").setEnabled(true);
					sas.fscf.getApplicationView().setBusy(false);
		  		  }).fail(function(oObj,textStatus,errorThrown){
		  			 if (oObj.responseJSON && oObj.responseJSON.message) {
		  				  sas.fscf.showMessageStrip(sap.ui.core.MessageType.Error, oObj.responseJSON.message, _this.sId + "BorderLayoutCenter");
		  			 } else {
		 				  sas.fscf.showMessageStrip(sap.ui.core.MessageType.Error, oObj.status + " " + oObj.statusText, _this.sId + "BorderLayoutCenter");
		  			 }
		  			sap.ui.getCore().byId("RulesPageRulesViewToolbarEmptyFromTrashButton").setEnabled(true);
					sas.fscf.getApplicationView().setBusy(false);
		  		  });
			}
        });
	},

	handleShowHistoryPress: function(e) {
  		sas.fscf.removeAllMessageStrips();
		const selectedRule = this.getTableSelectedRowsData()[0];

    	const dialogView = sap.ui.jsfragment({
            type: sap.ui.core.mvc.ViewType.JS,
            id: this.sId + "ShowHistoryDialog",
            fragmentName: "sas.fscf.views.fragments.ShowHistoryDialog"
        });
    	dialogView.setSelectedRule(selectedRule);
    	dialogView.setIsRuleStateAllowsCreateVersion(this.isRuleStateAllowsCreateVersion()); // RAPTOR-1783

    	dialogView.lazyLoadContent().open();
	},

	handleExportPress: function(e) {
  		sap.ui.getCore().byId("RulesPageRulesViewToolbarExportButton").setEnabled(false);
  		sas.fscf.removeAllMessageStrips();
    	var _this = sap.ui.getCore().byId("RulesPageRulesView");
    	sas.fscf.getApplicationView().setBusyIndicatorDelay(0).setBusy(true);
    	var rowsData = _this.getTableSelectedRowsData();
		var jsonData = [];
		for (var i = 0; i < rowsData.length; i++) {
			jsonData.push({id: rowsData[i]["id"]});
		}

		var xhr = new XMLHttpRequest();
		xhr.open('POST', "rest/businessunits/" + rowsData[0]["businessUnitId"] + "/exportRules", true);
		xhr.responseType = 'arraybuffer';
		xhr.onload = function () {
		    if (this.status === 200) {
		        var filename = "";
		        var disposition = xhr.getResponseHeader('Content-Disposition');
		        if (disposition && disposition.indexOf('attachment') !== -1) {
		            var filenameRegex = /filename[^;=\n]*=((['"]).*?\2|[^;\n]*)/;
		            var matches = filenameRegex.exec(disposition);
		            if (matches != null && matches[1]) filename = matches[1].replace(/['"]/g, '');
		        }
	        	filename = sas.fscf.rb.getText("fcm.export.file.name.txt") + '.xml';
		        var type = xhr.getResponseHeader('Content-Type');

		        var blob;
		        try {
		        	blob = new Blob([this.response], { type: type });
		        } catch (err) {
		        	try {
			        	blob = new File([this.response], filename, { type: type });
		        	} catch (err) {
		        	}
		        }
		        if (typeof window.navigator.msSaveBlob !== 'undefined') {
		            window.navigator.msSaveBlob(blob, filename);
		        } else {
		            var URL = window.URL || window.webkitURL;
		            var downloadUrl = URL.createObjectURL(blob);

		            if (filename) {
		                // use HTML5 a[download] attribute to specify filename
		                var a = document.createElement("a");
		                // safari doesn't support this yet
		                if (typeof a.download === 'undefined') {
		                    window.location = downloadUrl;
		                } else {
		                    a.href = downloadUrl;
		                    a.download = filename;
		                    document.body.appendChild(a);
		                    a.click();
		                }
		            } else {
		                window.location = downloadUrl;
		            }

		            setTimeout(function () { URL.revokeObjectURL(downloadUrl); }, 100); // cleanup
		        }
		        sas.fscf.getApplicationView().setBusy(false);
		    } else {
		    	sas.fscf.showMessageStrip(sap.ui.core.MessageType.Error, this.status + " " + this.statusText, _this.sId + "BorderLayoutCenter");
		    	sas.fscf.getApplicationView().setBusy(false);
		    }
		};
		xhr.setRequestHeader('Content-Type', 'application/json');
		xhr.setRequestHeader('Accept', 'text/xml; charset=utf-8');
		var ajaxHeaders = sas.fscf.getAjaxHeaders();
		for (var elem in ajaxHeaders) {
			xhr.setRequestHeader(elem, ajaxHeaders[elem]);
		}
		xhr.send(JSON.stringify(jsonData));
		sap.ui.getCore().byId("RulesPageRulesViewToolbarExportButton").setEnabled(true);
	},

	handlePrintPress: function (e) {
		sap.ui.getCore().byId("RulesPageRulesViewToolbarPrintButton").setEnabled(false);
		const self = sap.ui.getCore().byId("RulesPageRulesView");

		self.printRules(self.getTableSelectedRowsData());
	},

	printRules: function(rowsData, state) {
  		sas.fscf.removeAllMessageStrips();
  		sap.ui.getCore().byId("RulesPageRulesViewToolbarPrintButton").setEnabled(false);
		sas.fscf.getApplicationView().setBusyIndicatorDelay(0).setBusy(true);
		const self = this;

		sas.ajax({url:"rest/alerttypes", contentType:"application/json; charset=utf-8", dataType:"json", headers:sas.fscf.getAjaxHeaders()})
          .done(function(oData){
          	const alertTypes = oData.items;
          	const ruleState = state ? state : sas.fscf.getCookie("cf_lastRulesState");
          	let url = 'rest/businessunits/' + rowsData[0]["businessUnitId"] + '/rules?filter=state==\'' + ruleState + '\' and (';
			for (let i = 0; i < rowsData.length; i++) {
				url += 'id==' + rowsData[i]["id"];
				if (i != rowsData.length - 1) {
					url += ' or ';
				}
			}
			url += ')&fields=id,baseRuleId,name,state,keywords,ruleTypeName,createUser,createTimestamp,businessUnitName,queueName,transactionTypeDisplayName,transactionTypeAcronym,operationalTimeLimit,ruleVariables,ruleDependencies,ruleCode';

	        sas.ajax({url:url, contentType:"application/json; charset=utf-8", dataType:"json", headers:sas.fscf.getAjaxHeaders()})
	          .done(function(oData){
	      		var noneSafe = function (str) {
	    			if (!str || str == " " || str == "  " || str == "   ") {
	    				return '<span class="cfSoftNone">' + sas.fscf.rb.getText("fcm.application.none.txt") + '</span>';
	    			}
	    			return sas.fscf.escapeHTML(str);
	    		};
	      		var getAlertTypeFormatted = function (id) {
	      			if (id && id != " ") {
		    			for (var i = 0; i < alertTypes.length; i++) {
		    				if (alertTypes[i].id == id) {
		    					return alertTypes[i].description + " (" + alertTypes[i].id + ")";
		    				}
		    			}
	      			}
	    			return "";
	    		};
	      		var printWindowName = "PrintableRule" + new Date().valueOf();
	    		var w = window.open("", printWindowName, "menubar=0,toolbar=0,resizable=1,scrollbars=1,status=1,width=800,height=900");
	    		w.document.open();
	    		w.document.writeln('<!DOCTYPE html>');
	    		w.document.writeln('<html>');
	    		w.document.writeln('<head>');
	    		w.document.writeln('<meta charset="UTF-8">');
	    		w.document.writeln('<meta http-equiv="X-UA-Compatible" content="IE=edge">');
	    		w.document.writeln('<title>' + sas.fscf.rb.getText("rules.rulesPage.rules.print.documentTitle.fmt.txt", sas.config.appName) + '</title>');
	    		w.document.writeln('<link rel="stylesheet" href="resources/sas/hc/ui/core/themes/sas_base/fonts.css" type="text/css">');
	    		w.document.writeln('<link rel="stylesheet" href="resources/sap/ui/core/themes/sas_corporate/library.css" type="text/css">');
	    		w.document.writeln('<style>');
	    		w.document.writeln('.cfPrint {margin:0px;font-size:0.9rem;color:#000000;}');
	    		w.document.writeln('.cfPrint header {margin-bottom:20px;}');
	    		w.document.writeln('.cfPrint h2 {margin:0px;}');
	    		w.document.writeln('.cfPrint table {border-collapse:collapse;width:100%;}');
	    		w.document.writeln('.cfPrint tr {vertical-align:top;}');
	    		w.document.writeln('.cfPrint .cfMain th {font-weight:bold;white-space:nowrap;border:1px solid #d4d4d4;text-align:left;padding:3px 6px;}');
	    		w.document.writeln('.cfPrint .cfMain th:last-of-type {width:95%;white-space:normal;}');
	    		w.document.writeln('.cfPrint .cfMain td {white-space:nowrap;border:1px solid #d4d4d4;text-align:left;padding:3px 6px;}');
	    		w.document.writeln('.cfPrint .cfMain td:last-of-type {white-space:normal;}');
	    		w.document.writeln('.cfPrint .cfDetails td {text-align:left;padding:1px 2px;}');
	    		w.document.writeln('.cfPrint .cfDetails td:nth-of-type(odd) {width:5%;}');
	    		w.document.writeln('.cfPrint .cfDetails td:nth-of-type(even) {width:45%;}');
	    		w.document.writeln('.cfPrint .cfDetails td.cfLabel {white-space:nowrap;font-weight:bold;}');
	    		w.document.writeln('.cfPrint .cfDetails td.cfDoubleSpace {padding:15px 2px 1px 2px;}');
	    		w.document.writeln('.cfPrint .cfDetails td.cfCode {white-space:pre-wrap;font-family:Courier, courier}');
	    		w.document.writeln('.cfPrint .cfSoftNone {color:#b4b4b4;font-style:italic;}');
	    		w.document.writeln('.cfPrint .cfPageBreak {page-break-after:always;width:100%;}');
	    		w.document.writeln('.cfPrint .cfDivider {height:1px;width:100%;border-bottom:1px solid #d4d4d4;}');
	    		w.document.writeln('</style>');
	    		w.document.writeln('</head>');
	    		w.document.writeln('<body class="sapUiBody sapUiSizeCompact cfPrint">');
	    		w.document.writeln('<header><h2>' + sas.fscf.rb.getText("rules.rulesPage.rules.print.documentTitle.fmt.txt", sas.config.appName) + '</h2>');
	    		w.document.writeln('<div>' + sas.fscf.dateTimeFormatter.format(new Date()) + '</div></header>');
	    		w.document.writeln('<table class="cfMain">');
	    		w.document.writeln('<tr>');
	    		w.document.writeln('<th>' + sas.fscf.rb.getText("rules.rulesPage.rules.print.ruleID.txt") + '</th>');
	    		w.document.writeln('<th>' + sas.fscf.rb.getText("rules.rulesPage.rules.print.ruleType.txt") + '</th>');
	    		w.document.writeln('<th>' + sas.fscf.rb.getText("rules.rulesPage.rules.print.ruleName.txt") + '</th>');
	    		w.document.writeln('<th>' + sas.fscf.rb.getText("rules.rulesPage.rules.print.description.txt") + '</th>');
	    		w.document.writeln('</tr>');
	    		for (var i = 0; i < rowsData.length; i++) {
	    			w.document.writeln('<tr>');
	    			w.document.writeln('<td>' + rowsData[i]["baseRuleId"] + '.' + rowsData[i]["revision"] + '</td>');
	    			w.document.writeln('<td>' + sas.fscf.rb.getText("rules.rulesPage.rules.type." + rowsData[i]["ruleTypeName"].toLowerCase() + ".txt") + '</td>');
	    			w.document.writeln('<td>' + noneSafe(rowsData[i]["name"]) + '</td>');
	    			w.document.writeln('<td>' + noneSafe(rowsData[i]["description"]) + '</td>');
	    			w.document.writeln('</tr>');
	    		}
	    		w.document.writeln('</table>');
	    		var extraRuleData;
	    		for (var i = 0; i < rowsData.length; i++) {
	    			for (var j = 0; j < oData.items.length; j++) {
	    				if (oData.items[j]["id"] == rowsData[i]["id"]) {
	    					extraRuleData = oData.items[j];
	    					break;
	    				}
	    			}
	    			w.document.writeln('<div class="cfPageBreak">&nbsp;</div>');
	    			w.document.writeln('<div class="cfDivider">&nbsp;</div>');
	    			w.document.writeln('<h3>' + sas.fscf.rb.getText("rules.rulesPage.rules.print.ruleTitle.fmt.txt", [rowsData[i]["baseRuleId"] + '.' + rowsData[i]["revision"], rowsData[i]["name"]]) + '</h3>');
	    			w.document.writeln('<table class="cfDetails">');
	    			w.document.writeln('<tr>');
	    			w.document.writeln('<td class="cfLabel">' + sas.fscf.rb.getText("rules.rulesPage.rules.print.ruleName.txt") + '</td>');
	    			w.document.writeln('<td>' + noneSafe(rowsData[i]["name"]) + '</td>');
	    			w.document.writeln('<td class="cfLabel">' + sas.fscf.rb.getText("rules.rulesPage.rules.print.created.txt") + '</td>');
	    			// w.document.writeln('<td>' + sas.fscf.dateTimeFormatter.format(new Date(extraRuleData["createTimestamp"])) + '</td>');
	    			w.document.writeln('<td>' + sas.fscf.dateTimeFormatter.format(new Date(extraRuleData["createTimestamp"]), true) + '</td>');
	    			w.document.writeln('</tr>');
	    			w.document.writeln('<tr>');
	    			w.document.writeln('<td class="cfLabel">' + sas.fscf.rb.getText("rules.rulesPage.rules.print.ruleID.txt") + '</td>');
	    			w.document.writeln('<td>' + rowsData[i]["baseRuleId"] + '.' + rowsData[i]["revision"] + '</td>');
	    			w.document.writeln('<td class="cfLabel">' + sas.fscf.rb.getText("rules.rulesPage.rules.print.createdBy.txt") + '</td>');
	    			w.document.writeln('<td>' + noneSafe(extraRuleData["createUser"]) + '</td>');
	    			w.document.writeln('</tr>');
	    			w.document.writeln('<tr>');
	    			w.document.writeln('<td class="cfLabel">' + sas.fscf.rb.getText("rules.rulesPage.rules.print.ruleState.txt") + '</td>');
	    			w.document.writeln('<td>' + sas.fscf.rb.getText("rules.rulesPage.rules.states." + extraRuleData["state"].toLowerCase() + ".txt") + '</td>');
	    			w.document.writeln('<td class="cfLabel">' + sas.fscf.rb.getText("rules.rulesPage.rules.print.lastUpdated.txt") + '</td>');
	    			// w.document.writeln('<td>' + sas.fscf.dateTimeFormatter.format(new Date(rowsData[i]["lastUpdateTimestamp"])) + '</td>');
	    			w.document.writeln('<td>' + sas.fscf.dateTimeFormatter.format(new Date(rowsData[i]["lastUpdateTimestamp"]), true) + '</td>');
	    			w.document.writeln('</tr>');
	    			w.document.writeln('<tr>');
	    			w.document.writeln('<td class="cfLabel">' + sas.fscf.rb.getText("rules.rulesPage.rules.print.ruleType.txt") + '</td>');
	    			w.document.writeln('<td>' + sas.fscf.rb.getText("rules.rulesPage.rules.type." + rowsData[i]["ruleTypeName"].toLowerCase() + ".txt") + '</td>');
	    			w.document.writeln('<td class="cfLabel">' + sas.fscf.rb.getText("rules.rulesPage.rules.print.lastUpdatedBy.txt") + '</td>');
	    			w.document.writeln('<td>' + noneSafe(rowsData[i]["lastUpdateUser"]) + '</td>');
	    			w.document.writeln('</tr>');
	    			w.document.writeln('<tr>');
	    			w.document.writeln('<td class="cfLabel">' + sas.fscf.rb.getText("rules.rulesPage.rules.print.businessUnit.txt") + '</td>');
	    			w.document.writeln('<td>' + noneSafe(extraRuleData["businessUnitName"]) + '</td>');
	    			w.document.writeln('<td class="cfLabel">' + sas.fscf.rb.getText("rules.rulesPage.rules.print.executionOrder.txt") + '</td>');
	    			w.document.write('<td>');
	    			if (rowsData[i]["executionOrderType"] == -1) {
	    				w.document.write(sas.fscf.rb.getText("rules.rulesPage.rules.order.pre.txt"));
	    			} else if (rowsData[i]["executionOrderType"] == 1) {
	    				w.document.write(sas.fscf.rb.getText("rules.rulesPage.rules.order.post.txt"));
	    			} else {
	    				w.document.write(sas.fscf.rb.getText("rules.rulesPage.rules.order.main.txt"));
	    			}
	    			if (rowsData[i]["executionOrderType"] == -1 || rowsData[i]["executionOrderType"] == 1) {
	    				w.document.write(' : ' + rowsData[i]["executionOrderPriority"]);
	    			}
	    			w.document.writeln('</td>');
	    			w.document.writeln('</tr>');
	    			w.document.writeln('<tr>');
	    			w.document.writeln('<td class="cfLabel">' + sas.fscf.rb.getText("rules.rulesPage.rules.print.queue.txt") + '</td>');
	    			w.document.writeln('<td>' + noneSafe(extraRuleData["queueName"]) + '</td>');
	    			w.document.writeln('<td class="cfLabel">' + sas.fscf.rb.getText("rules.rulesPage.rules.print.alertType.txt") + '</td>');
	    			w.document.writeln('<td>' + noneSafe(getAlertTypeFormatted(rowsData[i]["alertTypeId"])) + '</td>');
	    			w.document.writeln('</tr>');
	    			w.document.writeln('<tr>');
	    			w.document.writeln('<td class="cfDoubleSpace cfLabel">' + sas.fscf.rb.getText("rules.rulesPage.rules.print.transactionScope.txt") + '</td>');
	    			w.document.writeln('<td class="cfDoubleSpace" colspan="3">' + noneSafe(rowsData[i]["multiOrgNodeDisplayName"] + ' (' + rowsData[i]["multiOrgNodeKey"] + ')') + '</td>');
	    			w.document.writeln('</tr>');
	    			w.document.writeln('<tr>');
	    			w.document.writeln('<td class="cfDoubleSpace cfLabel">' + sas.fscf.rb.getText("rules.rulesPage.rules.print.transactionType.txt") + '</td>');
	    			w.document.writeln('<td class="cfDoubleSpace" colspan="3">' + noneSafe(extraRuleData["transactionTypeDisplayName"] + ((extraRuleData["transactionTypeAcronym"]) ? ' (' + extraRuleData["transactionTypeAcronym"] + ')' : '')) + '</td>');
	    			w.document.writeln('</tr>');
	    			w.document.writeln('<tr>');
	    			w.document.writeln('<td class="cfDoubleSpace cfLabel">' + sas.fscf.rb.getText("rules.rulesPage.rules.print.description.txt") + '</td>');
	    			w.document.writeln('<td class="cfDoubleSpace" colspan="3">' + noneSafe(rowsData[i]["description"]) + '</td>');
	    			w.document.writeln('</tr>');
	    			w.document.writeln('<tr>');
	    			w.document.writeln('<td class="cfDoubleSpace cfLabel">' + sas.fscf.rb.getText("rules.rulesPage.maxExecutionTime.txt") + '</td>');
	    			w.document.writeln('<td class="cfDoubleSpace" colspan="3">' + noneSafe(rowsData[i]["operationalTimeLimit"]) + '</td>');
	    			w.document.writeln('</tr>');
	    			w.document.writeln('<tr>');
	    			w.document.writeln('<td class="cfDoubleSpace cfLabel">' + sas.fscf.rb.getText("rules.rulesPage.rules.print.alertReason.txt") + '</td>');
	    			w.document.writeln('<td class="cfDoubleSpace" colspan="3">' + noneSafe(rowsData[i]["alertReason"]) + '</td>');
	    			w.document.writeln('</tr>');
	    			var ruleDependencies = [];
	    			var ruleDependencyTypeStr;
	    			if (extraRuleData["ruleDependencies"]) {
	        			for (var k = 0; k < extraRuleData["ruleDependencies"].length; k++) {
	        				if (extraRuleData["ruleDependencies"][k]["dependencyType"] == "WEAK") {
	        					ruleDependencyTypeStr = "("+sas.fscf.rb.getText("rules.rulesPage.ruleProperties.sets.txt")+" "+extraRuleData["ruleDependencies"][k]["rule"]["keywords"]+")";
	        				} else {
	        					ruleDependencyTypeStr = "("+sas.fscf.rb.getText("rules.rulesPage.ruleProperties.for.txt")+" %hasRuleFired)";
	        				}
	        				let ruleTypeName = (sas.fscf.getCookie("cf_lastRulesState") == sap.ui.getCore().byId("RulesPageRulesView").STATE_TRASH) 
								? extraRuleData["ruleDependencies"][k]["rule"]["ruleTypeName"] 
								: extraRuleData["ruleDependencies"][k]["rule"]["ruleTypeName"][0];
	        				ruleDependencies.push("<div>#" + ruleTypeName +extraRuleData["ruleDependencies"][k]["rule"]["baseRuleId"]+": "+extraRuleData["ruleDependencies"][k]["rule"]["name"]+" - "+extraRuleData["ruleDependencies"][k]["rule"]["state"]+" "+ruleDependencyTypeStr+"</div>");
	        			}
	    			}
	    			w.document.writeln('<tr>');
	    			w.document.writeln('<td class="cfDoubleSpace cfLabel">' + sas.fscf.rb.getText("rules.rulesPage.rules.print.dependencies.txt") + '</td>');
	    			w.document.writeln('<td class="cfDoubleSpace" colspan="3">' + ((ruleDependencies.length > 0) ? ruleDependencies.join("") : noneSafe("")) + '</td>');
	    			w.document.writeln('</tr>');
	    			var ruleVariables = [];
	    			if (extraRuleData["ruleVariables"]) {
		    			for (var k = 0; k < extraRuleData["ruleVariables"].length; k++) {
		    				ruleVariables.push(extraRuleData["ruleVariables"][k]["altName"]);
		    			}
	    			}
	    			w.document.writeln('<tr>');
	    			w.document.writeln('<td class="cfDoubleSpace cfLabel">' + sas.fscf.rb.getText("rules.rulesPage.rules.print.variables.txt") + '</td>');
	    			w.document.writeln('<td class="cfDoubleSpace" colspan="3">' + noneSafe(ruleVariables.join(", ")) + '</td>');
	    			w.document.writeln('</tr>');
	    			w.document.writeln('<tr>');
	    			w.document.writeln('<td class="cfDoubleSpace cfLabel">' + sas.fscf.rb.getText("rules.rulesPage.rules.print.code.txt") + '</td>');
	    			w.document.writeln('<td class="cfDoubleSpace cfCode" colspan="3">' + noneSafe(extraRuleData["ruleCode"]) + '</td>');
	    			w.document.writeln('</tr>');
	    			w.document.writeln('</table>');
	    		}
	    		w.document.writeln('</body>');
	    		w.document.writeln('</html>');
	    		w.document.close();
	            setTimeout(function () { w.focus(); /*w.print();*/ }, 300);
	            sap.ui.getCore().byId("RulesPageRulesViewToolbarPrintButton").setEnabled(true);
	        }).fail(function(oObj,textStatus){
	        	sap.ui.getCore().byId("RulesPageRulesViewToolbarPrintButton").setEnabled(true);
	        	console.info("an error occurred getting the extra rule data");
	        }).always(function () {
				sas.fscf.getApplicationView().setBusy(false);
			});
          }).fail(function(oObj,textStatus){
        	sap.ui.getCore().byId("RulesPageRulesViewToolbarPrintButton").setEnabled(true);
       	    console.info("an error occurred getting the alert types");
          }).always(function () {
				sas.fscf.getApplicationView().setBusy(false);
		  });
	},

	handlePrioritizePress: function(e) {
  		sas.fscf.removeAllMessageStrips();
    	var view = sap.ui.jsfragment({
            type: sap.ui.core.mvc.ViewType.JS,
            id: this.sId + "PrioritizeRulesDialog",
            fragmentName: "sas.fscf.views.fragments.PrioritizeRulesDialog"
        });
    	view.open();
	},

	handleRefreshPress: function() {
  		sas.fscf.removeAllMessageStrips();
    	var _this = sap.ui.getCore().byId("RulesPageRulesView");
		_this.updateTable();
	},

	handleRequestPromoteToProductionPress: function(e) {
  		sas.fscf.removeAllMessageStrips();
    	var _this = sap.ui.getCore().byId("RulesPageRulesView");
       	var view = sap.ui.jsfragment({
            type: sap.ui.core.mvc.ViewType.JS,
            id: this.sId + "RequestActionDialog",
            fragmentName: "sas.fscf.views.fragments.RequestActionDialog"
        });
       	view.setActionType(0);
    	var dialog = view.lazyLoadContent();
       	dialog.open();
	},

	handlePromoteToProductionPress: function(e) {
		sas.fscf.removeAllMessageStrips(); 		
		
    	var _this = sap.ui.getCore().byId("RulesPageRulesView");    	

    	var proceed = function() {
        	//if (sas.fscf.userHasPrivilege("PWARULE")) {
        	if (sas.fscf.userHasPrivilege("PWARULE") || sas.fscf.userHasPrivilege("APRULE")) {//user can promote without approval or can approve and promote
        		sap.ui.getCore().byId("RulesPageRulesViewToolbarPromoteToProductionButton").setEnabled(false);
        		_this.changeRuleState(_this.STATE_PRODUCTION, sas.fscf.rb.getText("rules.rulesPage.ruleAction.movedTo.Production.txt"));
        	} else {
            	var view = sap.ui.jsfragment({
                    type: sap.ui.core.mvc.ViewType.JS,
                    id: this.sId + "RequestActionDialog",
                    fragmentName: "sas.fscf.views.fragments.RequestActionDialog"
                });
               	view.setActionType(0);
            	var dialog = view.lazyLoadContent();
               	dialog.open();
        	}
		}
		
		if (_this.getTableSelectedRowsData().length > 5) {
			sas.hc.m.MessageDialog.warning({
	            title: sas.fscf.rb.getText('fcm.application.confirm.txt'),
	            text: sas.fscf.rb.getText('rules.rulesPage.ruleAction.moveLargeNumber.confirm.fmt.msg.txt', _this.getTableSelectedRowsData().length),
	            buttonActions: [sas.hc.m.MessageDialogAction.Ok, sas.hc.m.MessageDialogAction.Cancel]
	        }).attachButtonPress(function(e) {
	            var action = e.getParameter("origin").getMessageDialogAction();
				if (action == sas.hc.m.MessageDialogAction.Ok) {
					proceed();
				}
	        });			
		} else {
			proceed();
		}
	},

	handleMoveToCodingPress: function(e) {
		sas.fscf.removeAllMessageStrips();		
		
    	var _this = sap.ui.getCore().byId("RulesPageRulesView");    	

    	var proceed = function() {
    		sap.ui.getCore().byId("RulesPageRulesViewToolbarMoveToCodingButton").setEnabled(false);
    		_this.changeRuleState(_this.STATE_CODING, sas.fscf.rb.getText("rules.rulesPage.ruleAction.movedTo.Coding.txt"));
		}
		
		if (_this.getTableSelectedRowsData().length > 5) {
			sas.hc.m.MessageDialog.warning({
	            title: sas.fscf.rb.getText('fcm.application.confirm.txt'),
	            text: sas.fscf.rb.getText('rules.rulesPage.ruleAction.moveLargeNumber.confirm.fmt.msg.txt', _this.getTableSelectedRowsData().length),
	            buttonActions: [sas.hc.m.MessageDialogAction.Ok, sas.hc.m.MessageDialogAction.Cancel]
	        }).attachButtonPress(function(e) {
	            var action = e.getParameter("origin").getMessageDialogAction();
				if (action == sas.hc.m.MessageDialogAction.Ok) {
					proceed();
				}
	        });			
		} else {
			proceed();
		}
	},

	// RAPTOR-1783 Refactored and created the createNewVersion method, which is called by ShowHistoryDialog.
	handleCreateNewVersionPress: function(e) {
		sap.ui.getCore().byId("RulesPageRulesViewToolbarCreateNewVersionButton").setEnabled(false);
		const selectedRule = this.getTableSelectedRowsData()[0];       
		this.createNewVersion(selectedRule, selectedRule.id);
	},

	// errorMessageContainerId is optional.  Specify this if the error messages are to be
	// displayed in a dialog from which the create new version request is originated.
	createNewVersion: function(selectedRule, selectedVersionId, errorMessageContainerId, successHandler) {
		sas.fscf.removeAllMessageStrips();
		sas.fscf.getApplicationView().setBusyIndicatorDelay(0).setBusy(true);

		const successMessageHolderId = this.sId + "BorderLayoutCenter";
		const errorMessageHolderId = errorMessageContainerId ? errorMessageContainerId : successMessageHolderId;
		const url = "rest/businessunits/" + selectedRule.businessUnitId + "/rules/" + selectedVersionId + "/revisions";
		const self = this;

		sas.ajax({url: url, type: "POST", headers:sas.fscf.getAjaxHeaders()})
			.done(function(_oData) {
				sap.ui.getCore().byId("RulesPageRulesViewToolbarCreateNewVersionButton").setEnabled(true);
				sas.fscf.showMessageStrip(sap.ui.core.MessageType.Success,
					sas.fscf.rb.getText("rules.rulesPage.ruleAction.createNewVersion.fmt.txt", selectedRule.name),
					successMessageHolderId );
				self.updateTable();
				sas.fscf.getApplicationView().setBusy(false);
				if (successHandler) {
					successHandler();
				}
			} )
			.fail(function(oObj, _textStatus, _errorThrown) {
				const message = (oObj.responseJSON && oObj.responseJSON.message)
					? oObj.responseJSON.message
					: (oObj.status + " " + oObj.statusText);

				sas.fscf.showMessageStrip(sap.ui.core.MessageType.Error, message, errorMessageHolderId);
				sap.ui.getCore().byId("RulesPageRulesViewToolbarCreateNewVersionButton").setEnabled(true);
				sas.fscf.getApplicationView().setBusy(false);
			} );
	},

	handleEmptyTrashPress: function(e) {
		sap.ui.getCore().byId("RulesPageRulesViewToolbarEmptyAllTrashButton").setEnabled(false);
		sas.fscf.removeAllMessageStrips();  		
		sas.hc.m.MessageDialog.warning({
            title: sas.fscf.rb.getText('fcm.application.confirm.txt'),
            text: sas.fscf.rb.getText('rules.rulesPage.rules.trash.actions.emptyAllTrash.confirm.msg.txt'),
            buttonActions: [sas.hc.m.MessageDialogAction.Ok, sas.hc.m.MessageDialogAction.Cancel]
        }).attachButtonPress(function(e) {
            var action = e.getParameter("origin").getMessageDialogAction();
			if (action == sas.hc.m.MessageDialogAction.Ok) {
		    	var _this = sap.ui.getCore().byId("RulesPageRulesView");
				var rowsData = _this.getTableRowsData();
				if (rowsData.length == 0) {
					return;
				}
				sas.fscf.getApplicationView().setBusyIndicatorDelay(0).setBusy(true);
				var jsonData = [];
				for (var i = 0; i < rowsData.length; i++) {
					jsonData.push({id: rowsData[i]["id"]});
				}
				sas.ajax({url:"rest/businessunits/" + rowsData[0]["businessUnitId"] + "/rules/", type: "DELETE", data: jsonData, headers:sas.fscf.getAjaxHeaders()})
			  	  .done(function(oData){
			  		 sas.fscf.showMessageStrip(sap.ui.core.MessageType.Success, sas.fscf.rb.getText("rules.rulesPage.ruleAction.empty.Trash.txt"), _this.sId + "BorderLayoutCenter");
			  		 _this.updateTable();
			  		 sas.fscf.getApplicationView().setBusy(false);
			 		 sap.ui.getCore().byId("RulesPageRulesViewToolbarEmptyAllTrashButton").setEnabled(true);
		  		  }).fail(function(oObj,textStatus,errorThrown){
		  			 if (oObj.responseJSON && oObj.responseJSON.message) {
		  				  sas.fscf.showMessageStrip(sap.ui.core.MessageType.Error, oObj.responseJSON.message, _this.sId + "BorderLayoutCenter");
		  			 } else {
		 				  sas.fscf.showMessageStrip(sap.ui.core.MessageType.Error, oObj.status + " " + oObj.statusText, _this.sId + "BorderLayoutCenter");
		  			 }
		  			 sap.ui.getCore().byId("RulesPageRulesViewToolbarEmptyAllTrashButton").setEnabled(true);
					 sas.fscf.getApplicationView().setBusy(false);
		  		  });
			}
        });
	},

	handleEnablePress: function(e) {
		sap.ui.getCore().byId("RulesPageRulesViewToolbarEnableButton").setEnabled(false);
		sas.fscf.removeAllMessageStrips();  		
    	var _this = sap.ui.getCore().byId("RulesPageRulesView");
    	_this.changeRuleEnableState(true, sas.fscf.rb.getText("rules.rulesPage.ruleAction.enable.txt"));
	},

	handleDisablePress: function(e) {
		sap.ui.getCore().byId("RulesPageRulesViewToolbarDisableButton").setEnabled(false);
		sas.fscf.removeAllMessageStrips();  		
    	var _this = sap.ui.getCore().byId("RulesPageRulesView");
		sas.fscf.getApplicationView().setBusyIndicatorDelay(0).setBusy(true);
		var rowsData = _this.getTableSelectedRowsData();
		var jsonData = [];
		for (var i = 0; i < rowsData.length; i++) {
			jsonData.push({id: rowsData[i]["id"]});
		}
		sas.ajax({url:"rest/businessunits/" + _this.getBUId() + "/rules/dependents", type: "POST", data: jsonData, headers:sas.fscf.getAjaxHeaders()})
	  	  .done(function(oData){
	  		  var disabledIds = [];
			  disabledIds=Object.keys(oData);
			  if (disabledIds.length > 0) {
				var confMsg = "";
				for (var i = 0; i < disabledIds.length; i++) {
				  if (oData[disabledIds[i]].indexOf(",") == -1) {
					  confMsg += sas.fscf.rb.getText("rules.rulesPage.rules.production.actions.confirmDependencies.singular.fmt.txt",[oData[disabledIds[i]],disabledIds[i]]);
				  } else {
					  confMsg += sas.fscf.rb.getText("rules.rulesPage.rules.production.actions.confirmDependencies.plural.fmt.txt",[oData[disabledIds[i]],disabledIds[i]]);
				  }
				}
				confMsg += sas.fscf.rb.getText("rules.rulesPage.rules.production.actions.confirmProceed.txt")
				sap.ui.getCore().byId("RulesPageRulesViewToolbarDisableButton").setEnabled(true);
				sas.fscf.getApplicationView().setBusy(false);
				sas.hc.m.MessageDialog.warning({
		            title: sas.fscf.rb.getText('fcm.application.confirm.txt'),
		            text: confMsg,
		            buttonActions: [sas.hc.m.MessageDialogAction.Ok, sas.hc.m.MessageDialogAction.Cancel]
		        }).attachButtonPress(function(e) {
		            var action = e.getParameter("origin").getMessageDialogAction();
					if (action == sas.hc.m.MessageDialogAction.Ok) {
				      	_this.changeRuleEnableState(false, sas.fscf.rb.getText("rules.rulesPage.ruleAction.disable.txt"));
					}
		        });
			  } else {
			   	_this.changeRuleEnableState(false, sas.fscf.rb.getText("rules.rulesPage.ruleAction.disable.txt"));
			  }
  		  }).fail(function(oObj,textStatus,errorThrown){
  			 if (oObj.responseJSON && oObj.responseJSON.message) {
  				  sas.fscf.showMessageStrip(sap.ui.core.MessageType.Error, oObj.responseJSON.message, _this.sId + "BorderLayoutCenter");
  			 } else {
				  sas.fscf.showMessageStrip(sap.ui.core.MessageType.Error, oObj.status + " " + oObj.statusText, _this.sId + "BorderLayoutCenter");
 			 }
  			sap.ui.getCore().byId("RulesPageRulesViewToolbarDisableButton").setEnabled(true);
			sas.fscf.getApplicationView().setBusy(false);
  		  });
	},

	changeRuleEnableState: function(bEnabled, successMessage) {
		var _this = this;
		sas.fscf.getApplicationView().setBusyIndicatorDelay(0).setBusy(true);
		var rowsData = this.getTableSelectedRowsData();
		var opState = (bEnabled) ? "0" : "1";
		var jsonData = [];
		for (var i = 0; i < rowsData.length; i++) {
			jsonData.push({id: rowsData[i]["id"], configuredOperationalState: opState});
		}
		sas.ajax({url:"rest/businessunits/" + _this.getBUId() + "/rules", type: "PUT", data: jsonData, headers:sas.fscf.getAjaxHeaders()})
	  	  .done(function(oData){
	  		 sas.fscf.showMessageStrip(sap.ui.core.MessageType.Success, successMessage, _this.sId + "BorderLayoutCenter");
	  		 _this.updateTable();
			 sas.fscf.getApplicationView().setBusy(false);
	 		 sap.ui.getCore().byId("RulesPageRulesViewToolbarDisableButton").setEnabled(true);
	 		 sap.ui.getCore().byId("RulesPageRulesViewToolbarEnableButton").setEnabled(true);	 		
  		  }).fail(function(oObj,textStatus,errorThrown){
  			 if (oObj.responseJSON && oObj.responseJSON.message) {
  				  sas.fscf.showMessageStrip(sap.ui.core.MessageType.Error, oObj.responseJSON.message, _this.sId + "BorderLayoutCenter");
  			 } else {
				  sas.fscf.showMessageStrip(sap.ui.core.MessageType.Error, oObj.status + " " + oObj.statusText, _this.sId + "BorderLayoutCenter");
 			 }
  			 sap.ui.getCore().byId("RulesPageRulesViewToolbarDisableButton").setEnabled(true);
  			 sap.ui.getCore().byId("RulesPageRulesViewToolbarEnableButton").setEnabled(true);
			 sas.fscf.getApplicationView().setBusy(false);
  		  });
	},

	changeRuleState: function(toState, successMessage, ids, requestReviewData) {
		var _this = this;	
		sas.fscf.getApplicationView().setBusyIndicatorDelay(0).setBusy(true);
		var ruleIds = [];
		if (ids) {
			ruleIds = ids;
		} else {
			var rowsData = this.getTableSelectedRowsData();
			for (var i = 0; i < rowsData.length; i++) {
				ruleIds.push(rowsData[i]["id"]);
			}
		}
	    var jsonData = {
	    	ruleIds: ruleIds,
	    	workflow: {
	    		"destination":toState,
	    		"source":_this.getRuleState()
	    	}
   		};
	    if (requestReviewData) {
	    	jsonData.workflow.toEmailAddress = requestReviewData.toEmailAddress;
	    	jsonData.workflow.userNotes = requestReviewData.userNotes;
	    }	    
		sas.ajax({url:"rest/businessunits/" + _this.getBUId() + "/rules/state", type: "PUT", data: jsonData, headers:sas.fscf.getAjaxHeaders()})
	  	  .done(function(oData){	  		  
	  		  sas.fscf.showMessageStrip(sap.ui.core.MessageType.Success, successMessage, _this.sId + "BorderLayoutCenter");
	  		 _this.updateTable();
	  		_this.enableAllAgain();
  		  }).fail(function(oObj,textStatus,errorThrown){
  			  _this.enableAllAgain();
  			 if (oObj.responseJSON && oObj.responseJSON.message) {
  				  sas.fscf.showMessageStrip(sap.ui.core.MessageType.Error, oObj.responseJSON.message, _this.sId + "BorderLayoutCenter");
  			 } else {
				  sas.fscf.showMessageStrip(sap.ui.core.MessageType.Error, oObj.status + " " + oObj.statusText, _this.sId + "BorderLayoutCenter");
 			 }
  			
  			
  		  });
	},
	enableAllAgain: function(){
		if(sap.ui.getCore().byId("RulesPageRulesViewToolbarPromoteToTestingButton")){
  			sap.ui.getCore().byId("RulesPageRulesViewToolbarPromoteToTestingButton").setEnabled(true);
  		}
  		if(sap.ui.getCore().byId("RulesPageRulesViewToolbarPromoteToProductionButton")){
  			sap.ui.getCore().byId("RulesPageRulesViewToolbarPromoteToProductionButton").setEnabled(true);
  		}
  		if(sap.ui.getCore().byId("RulesPageRulesViewToolbarMoveToCodingButton")){
  			sap.ui.getCore().byId("RulesPageRulesViewToolbarMoveToCodingButton").setEnabled(true);
  		}
  		if(sap.ui.getCore().byId("RulesPageRulesViewToolbarDeleteButton")){
  			sap.ui.getCore().byId("RulesPageRulesViewToolbarDeleteButton").setEnabled(true);
  		}
		sas.fscf.getApplicationView().setBusy(false);
	},

    getBUId: function() {
   		return sas.fscf.getCookie("cf_lastRulesBU");
    },
    getBUName: function() {
   		return sas.fscf.getCookie("cf_lastRulesBUName");
    },
	getExpressionsRuleCode: function(guided,id){
		var _this = sap.ui.getCore().byId("RulesPageRulesView");
		var fields = "expressions,state";
		if(guided==false)
			fields += ",ruleCode";
		// get the rule's expressions
		sas.ajax({url:'rest/businessunits/'+this.getBUId()+'/rules/'+id+'?fields='+fields, headers:sas.fscf.getAjaxHeaders()})
		  .done(function(oData){
			    var expressions = oData.expressions;
			    var state = oData.state;
			    if (state != "Coding"){
			    	//bail out, refresh page, put up banner
			    	sas.fscf.showMessageStrip(sap.ui.core.MessageType.Warning, sas.fscf.rb.getText('rules.rulesPage.ruleAction.codingRuleNotAvailable.error.txt'), _this.sId);			    	
					_this.updateTable();
					return;
			    }
			    if(expressions){
			    	sas.fscf.getCurrentPageView().jsonRule.expressions = expressions;
			    }else{
			    	sas.fscf.getCurrentPageView().jsonRule.expressions = parent.sas.fscf.getEmptyRuleExpressions();
			    }
				if(!guided){
				   	var ruleCode = oData.ruleCode;
					if(ruleCode){
						sas.fscf.getCurrentPageView().jsonRule.ruleCode = ruleCode;
					}else{
						sas.fscf.getCurrentPageView().jsonRule.ruleCode = "";
					}
				}
				sas.fscf.getCurrentPageView().jsonRule.businessUnitName= _this.getBUName();
				if(guided == true){
					parent.sas.fscf.getCurrentPageView().initIdsForExpressions("F", parent.sas.fscf.getCurrentPageView().jsonRule.expressions.expressions[0].condition.expressions);
				   	parent.sas.fscf.getCurrentPageView().switchToGuidedContent();
				   	parent.sas.fscf.loadRule(parent.sas.fscf.getCurrentPageView().getGuidedView());

				}else{
				   	parent.sas.fscf.getCurrentPageView().switchToCodingContent();
				   	parent.sas.fscf.loadRule(sas.fscf.getCurrentPageView().getCodingView());
				}
			}).fail(function(oObj,textStatus){
			    console.log("failure getting rule's expressions");
				sas.fscf.getCurrentPageView().jsonRule.expressions= parent.sas.fscf.getEmptyRuleExpressions();
				if(!guided){
					sas.fscf.getCurrentPageView().jsonRule.ruleCode= "";
				}

			});
	},

	getRuleState: function () { // RAPTOR-1783
		return sas.fscf.getCookie("cf_lastRulesState");
	},

	isRuleStateAllowsCreateVersion: function (ruleState) {
		const myRuleState = ruleState || this.getRuleState();

		return [this.STATE_PRODUCTION, this.STATE_TRASH].indexOf(myRuleState) !== -1;
	},
});
