sap.ui.jsview("sas.fscf.views.RulesPageGuided", {
    getControllerName: function () {
        return "sas.fscf.views.RulesPageGuided";
    },
    _promote:false,
    setPromote: function (promote){
    	this._promote=promote;
    },
    getPromote: function (){
    	return this._promote;
    },	
    _close:false,
    setClose: function (close){
    	this._close=close;
    },
    getClose: function (){
    	return this._close;
    },
    createContent: function(oController) {
    	jQuery.sap.require("sas.hc.ui.commons.layout.BorderLayout");
    	jQuery.sap.require("sas.hc.ui.commons.layout.BorderLayoutArea");
        jQuery.sap.require("sas.hc.m.ResponsiveToolbar");
        jQuery.sap.require("sas.hc.m.ToolbarSpacer");
        jQuery.sap.require("sas.hc.m.Link");
        jQuery.sap.require("sas.hc.m.Label");
        jQuery.sap.require("sas.hc.m.Button");
        jQuery.sap.require("sas.hc.m.ToggleButton");
        jQuery.sap.require("sas.hc.ui.layout.Splitter");
        jQuery.sap.require("sas.hc.ui.layout.SplitterLayoutData");
		jQuery.sap.require("sas.hc.m.MessageDialog");
		jQuery.sap.require("sas.hc.m.MessageDialogAction");
        jQuery.sap.require("sas.fscf.views.GuidedHelper");
        jQuery.sap.require("sas.fscf.views.OperatorLogic");

    	var _this = this;

    	this.addStyleClass("cfGuidedView");

    	var oReturnButton =  new sas.hc.m.Button({
            id: this.sId + "ReturnButton",
    	    icon : "sap-icon://nav-back",    	    
    	    tooltip:sas.fscf.rb.getText("rules.rulesPage.returnToRules.txt"),
    	    ariaLabel:sas.fscf.rb.getText("rules.rulesPage.returnToRules.txt"),
    	    enabled:true,
    	    press: function(){_this.back();}
        });
    	oReturnButton.addStyleClass("cfFirstToolbarItem");

    	var oRuleNameLabel = new sas.hc.m.Label({
  			id: this.sId + "ToolbarRuleNameLabel",
            text: sas.fscf.getCurrentPageView().jsonRule.name
		});
    	oRuleNameLabel.addStyleClass("cfRuleNameLabel");

    	var oSaveButton = new sas.hc.m.Button({
        	id: this.sId + "ToolbarSaveButton",
    		icon: 'sap-icon://hc/save',
	    	tooltip: sas.fscf.rb.getText("rules.rulesPage.guidedView.save.txt"),
	    	ariaLabel: sas.fscf.rb.getText("rules.rulesPage.guidedView.save.txt"),
	    	enabled: false,
     		press: function (oEvent) {
     			var _tButton = oEvent.oSource;
    			var _pressed = oEvent.mParameters.pressed;
    			var ruleFormGrid = sap.ui.getCore().byId("RulesPageGuidedViewFormView_RuleGuidedFormGrid");
    			if(ruleFormGrid.getVisible()){
    				var oFormView = sap.ui.getCore().byId(_this.sId + 'FormView');
    				oFormView.updateModelFromFullForm(true);
    				_this.validateAlertAction();
    				if(sas.fscf.getCurrentPageView().jsonRuleIncomplete==true){
    					//do nothing
    				}
    				else{
    					_this.save();
    				}
    			}
    			else{
    				_this.validateAlertAction();
    				if(sas.fscf.getCurrentPageView().jsonRuleIncomplete==true){
    					//do nothing
    				}
    				else{
    					_this.save();
    				}
    				// since changing the form view steps on the press state of the toggle button,
    				// re-do the press state of the toggle button after slight delay
    			}
    		}
		});
    	
    	var oRulePropertiesButton =  new sas.hc.m.Button({
            id: this.sId + "ToolbarRulePropertiesButton",
    	    icon : "sap-icon://hc/properties",    	    
    	    tooltip:sas.fscf.rb.getText("rules.rulesPage.properties.txt"),
    	    ariaLabel:sas.fscf.rb.getText("rules.rulesPage.properties.txt"),
    	    enabled:true,
    	    press: function(){sas.fscf.removeAllMessageStrips();_this.getRuleProperties();}
        });

    	var oToggleFormButton = new sas.hc.m.ToggleButton({
        	id: this.sId + "ToolbarFormViewButton",
    		icon: 'sap-icon://hc/form',
   			tooltip: sas.fscf.rb.getText("rules.rulesPage.guidedView.formView.txt"),
   			ariaLabel: sas.fscf.rb.getText("rules.rulesPage.guidedView.formView.txt"),
    		press: function(oEvent) {
    			sas.fscf.removeAllMessageStrips();
    			var _tButton = oEvent.oSource;
    			var _pressed = oEvent.mParameters.pressed;
    			var ruleFormGrid = sap.ui.getCore().byId("RulesPageGuidedViewFormView_RuleGuidedFormGrid");
    			if(ruleFormGrid.getVisible()){
    				var oFormView = sap.ui.getCore().byId(_this.sId + 'FormView');
    				oFormView.updateModelFromFullForm(true);
    				if(sas.fscf.getCurrentPageView().jsonRuleIncomplete==true){
    					_tButton.setPressed(true);
    				}
    				else{
	    				setTimeout(function () {
	    					_this.toggleFormView(_pressed);
	    					_tButton.setPressed(!_pressed);
	    					_tButton.setPressed(_pressed);
	    				}, 100);
    				}
    			}
    			else{
    				_this.toggleFormView(_pressed);
    				setTimeout(function () {
    					_tButton.setPressed(!_pressed);
    					_tButton.setPressed(_pressed);
    				}, 100);
    				// since changing the form view steps on the press state of the toggle button,
    				// re-do the press state of the toggle button after slight delay
    			}
    		}
		});
		oToggleFormButton.addStyleClass("cfFirstButton");
    	// Workaround a ToggleButton bug where the icon on the button does
    	// not inherit the title and aria label of the button
    	oToggleFormButton.onAfterRendering = function() {
	    	if (sas.hc.m.ToggleButton.prototype.onAfterRendering) {
        		sas.hc.m.ToggleButton.prototype.onAfterRendering.apply(this);
        	}
        	// must be set after rendering when the dom ref will exist
	    	var icon = $("#"+this.getDomRef().id+"-img")[0]; 
        	icon.setAttribute("title", sas.fscf.rb.getText("rules.rulesPage.guidedView.formView.txt"));
        	icon.setAttribute("aria-label", sas.fscf.rb.getText("rules.rulesPage.guidedView.formView.txt"));
    	};

    	var oPromoteButton = new sas.hc.m.Button({
            id: this.sId + "PromoteButton",
    	    text:sas.fscf.rb.getText("fcm.application.promote.txt"),
    	    enabled:true,
    	    press: function(){_this.promote();}
        });
    	
    	var oCloseButton = new sas.hc.m.Button({
            id: this.sId + "CloseButton",
    	    text:sas.fscf.rb.getText("fcm.application.close.txt"),
    	    enabled:true,
    	    press: function(){_this.back();}
        });
    	oCloseButton.addStyleClass("cfLastToolbarItem");
    	
        var oToolbar1 = new sas.hc.m.ResponsiveToolbar({
        	id: this.sId + "Toolbar",
    	    content: [
    	            oReturnButton,
    	            oRuleNameLabel,
    	      		new sas.hc.m.Label({
    	      			id: this.sId + "ToolbarBusinessUnitLabel",
    	                text: sas.fscf.rb.getText("rules.rulesPage.guidedView.businessUnit.txt") + " " + sas.fscf.getCurrentPageView().jsonRule.businessUnitName
    	    		}),
    	    		oToggleFormButton,
    	    		oRulePropertiesButton,
    	    		oSaveButton,
					new sas.hc.m.Button({
   			        	id: this.sId + "ToolbarPreviewButton",
			    		icon: 'sap-icon://hc/code',
		   			    tooltip: sas.fscf.rb.getText("rules.rulesPage.guidedView.preview.txt"),
		   			    ariaLabel: sas.fscf.rb.getText("rules.rulesPage.guidedView.preview.txt"),
   			     		press: function (e) {
   			     			sas.fscf.removeAllMessageStrips();
   			     			_this.preview();
   			    		}
					}),
  			      	new sas.hc.m.ToolbarSpacer({
					}),
					oPromoteButton,
					oCloseButton
    	    ]
    	});

        var oSplitter1LayoutData1 = new sas.hc.ui.layout.SplitterLayoutData({
        	resizable: true,
            size: "17%"
        });
        var oSplitter1LayoutData2 = new sas.hc.ui.layout.SplitterLayoutData({
        	resizable: true,
        	size: "auto"
        });
        

        var oPaletteView = sap.ui.view({
            type: sap.ui.core.mvc.ViewType.JS,
            id: this.sId + "PaletteView",
            viewName: "sas.fscf.views.Palette",
            height: "99%",
            layoutData: oSplitter1LayoutData1
        });
        oPaletteView.lazyLoadContent();

        var oGridToolbarView = sap.ui.view({
            type: sap.ui.core.mvc.ViewType.JS,
            id: this.sId + "GridToolbarView",
            viewName: "sas.fscf.views.GridToolbar"
        });

        var oSplitter2LayoutData1 = new sas.hc.ui.layout.SplitterLayoutData({
        	resizable: true,
            size: "60%"
        });
        var oSplitter2LayoutData2 = new sas.hc.ui.layout.SplitterLayoutData({
        	resizable: true,
        	size: "auto"
        });
        
        var oGridView = sap.ui.view({
            type: sap.ui.core.mvc.ViewType.JS,
            id: this.sId + "GridView",
            viewName: "sas.fscf.views.Grid",
            layoutData: oSplitter2LayoutData1
        });
        oGridView.setStartMessage(sas.fscf.rb.getText("rules.rulesPage.guidedView.grid.start.txt"));
        oGridView.lazyLoadContent();

        oGridToolbarView.setGrid(oGridView);
        oGridToolbarView.lazyLoadContent();

        var oIconTabBarInfo = new sas.hc.m.IconTabBar({
        	id: this.sId + "TabBar",
            layoutData: oSplitter2LayoutData2
        });

        var oSplitter3LayoutData1 = new sas.hc.ui.layout.SplitterLayoutData({
        	resizable: true,
            size: "80%"
        });
        var oSplitter3LayoutData2 = new sas.hc.ui.layout.SplitterLayoutData({
        	resizable: true,
        	size: "auto"
        });
        
        var oFormView = sap.ui.view({
            type: sap.ui.core.mvc.ViewType.JS,
            id: this.sId + "FormView",
            viewName: "sas.fscf.views.Form",
            layoutData: oSplitter3LayoutData1
        });

        var oActionsView = sap.ui.view({
            type: sap.ui.core.mvc.ViewType.JS,
            id: this.sId + "ActionsView",
            viewName: "sas.fscf.views.Actions",
            layoutData: oSplitter3LayoutData2
        });

        var oSplitter3 = new sas.hc.ui.layout.Splitter({
            id: this.sId + 'Splitter3',
            contentAreas: [oFormView, oActionsView],
            width: "100%",
            height: "100%"
        });
        oSplitter3.addStyleClass("cfSplitter3");

        var oIconActionsTab = new sas.hc.m.IconTabFilter( this.sId + "ActionsTab", {
        	text:sas.fscf.rb.getText("rules.rulesPage.guidedView.tabs.conditionsAndActions.txt"),
        	closable:false
        });
        oIconActionsTab.addContent( oSplitter3 );
        oIconTabBarInfo.addItem( oIconActionsTab );

        var oRelatedRowsView = sap.ui.view({
        	type: sap.ui.core.mvc.ViewType.JS,
        	id: this.sId + "RelatedRowsView",
        	viewName: "sas.fscf.views.RelatedRows"
        });
        oRelatedRowsView.lazyLoadContent();

        var oIconRelatedRowsTab = new sas.hc.m.IconTabFilter( this.sId + "RelatedRowsTab", {
        	text:sas.fscf.rb.getText("rules.rulesPage.guidedView.tabs.relatedRows.txt"),
        	closable:false
        });
        oIconRelatedRowsTab.addContent( oRelatedRowsView );
        oIconTabBarInfo.addItem( oIconRelatedRowsTab );

        var oSplitter2 = new sas.hc.ui.layout.Splitter({
            id: this.sId + 'Splitter2',
            contentAreas: [oGridView, oIconTabBarInfo],
            orientation: sap.ui.core.Orientation.Vertical,
            width: "100%",
            height: "100%"
        });
        oSplitter2.addStyleClass("cfSplitter2");

        var oBorderLayoutTop2 = new sas.hc.ui.commons.layout.BorderLayoutArea({
            id: this.sId + "BorderLayoutTop2",
			size: "2rem",
			content: [
			          oGridToolbarView
			]
		});
        oBorderLayoutTop2.addStyleClass("cfGridToolbarArea");

        var oBorderLayout2 = new sas.hc.ui.commons.layout.BorderLayout({
            id: this.sId + "BorderLayout2",
    		top: oBorderLayoutTop2,
    	    center: new sas.hc.ui.commons.layout.BorderLayoutArea({
                id: this.sId + "BorderLayoutCenter2",
    			content: [
    			          oSplitter2
      			]
      		}),
    		layoutData: oSplitter1LayoutData2
    	});

        var oSplitter1 = new sas.hc.ui.layout.Splitter({
            id: this.sId + 'Splitter1',
            contentAreas: [oPaletteView, oBorderLayout2],
            width: "100%",
            height: "100%"
        });

        var oBorderLayout1 = new sas.hc.ui.commons.layout.BorderLayout({
            id: this.sId + "BorderLayout1",
    		top: new sas.hc.ui.commons.layout.BorderLayoutArea({
                id: this.sId + "BorderLayoutTop1",
    			size: "2rem",
    			content: [
    			          oToolbar1
    			]
    		}),
    	    center: new sas.hc.ui.commons.layout.BorderLayoutArea({
                id: this.sId + "BorderLayoutCenter1",
    			content: [
    			          oSplitter1
      			]
      		})
    	});

        return oBorderLayout1;
    },

    getCurrentTab: function() {
    	return sap.ui.getCore().byId(this.sId + "TabBar").getSelectedKey();
    },

    toggleFormView: function(bFormView) {
    	var oBorderLayoutCenter1 = sap.ui.getCore().byId(this.sId + 'BorderLayoutCenter1');
    	var oBorderLayoutCenter2 = sap.ui.getCore().byId(this.sId + 'BorderLayoutCenter2');
    	var oSplitter1 = sap.ui.getCore().byId(this.sId + 'Splitter1');
    	var oSplitter2 = sap.ui.getCore().byId(this.sId + 'Splitter2');
    	var oGridView = sap.ui.getCore().byId(this.sId + 'GridView');
    	var oActionsTab = sap.ui.getCore().byId(this.sId + 'ActionsTab');
    	var oSplitter3 = sap.ui.getCore().byId(this.sId + 'Splitter3');
    	var oFormView = sap.ui.getCore().byId(this.sId + 'FormView');
    	var oActionsView = sap.ui.getCore().byId(this.sId + 'ActionsView');
    	if (bFormView) {
				oSplitter1.setVisible(false);
				oBorderLayoutCenter2.removeContent(oSplitter2);
				oSplitter2.removeContentArea(oGridView);
		    	oSplitter3.removeContentArea(oFormView);
				this.addStyleClass("cfFullFormView");
				oFormView.getLayoutData().setSize("60%");
				oSplitter2.insertContentArea(oFormView, 0);
				oBorderLayoutCenter1.addContent(oSplitter2);
				oActionsTab.setText(sas.fscf.rb.getText("rules.rulesPage.guidedView.tabs.actions.txt"));
				oSplitter3.setVisible(false);
				oSplitter3.removeContentArea(oActionsView);
				oSplitter3.getParent().addContent(oActionsView);
				var expressionsFormGrid = sap.ui.getCore().byId("RulesPageGuidedViewFormView_RuleExpressionsFormGrid");
				expressionsFormGrid.removeContent();
				expressionsFormGrid.destroyContent(true);
				expressionsFormGrid.setVisible(false);
				var ruleFormGrid = sap.ui.getCore().byId("RulesPageGuidedViewFormView_RuleGuidedFormGrid");
				ruleFormGrid.setVisible(true);
				ruleFormGrid.destroyContent();
				//oFormView.updateModelFromSplitForm();
				oFormView.initForm(ruleFormGrid);
				oFormView.synchPopulationIndicator(sap.ui.getCore().byId(this.sId + 'GridToolbarViewGridToolbarPopulationIndicator'));
				if (!sas.fscf.getCurrentPageView().jsonRule.expressions.expressions[0].properties) {
					sas.fscf.getCurrentPageView().jsonRule.expressions.expressions[0].properties = {};
				}
				sas.fscf.getCurrentPageView().jsonRule.expressions.expressions[0].properties.view = "form";
				sas.fscf.removeAllMessageStrips();
				sas.fscf.getCurrentPageView().setDirty(true);
		    	this._bDirtySinceLastFormView = false;

		} else {
	    		oActionsTab.setText(sas.fscf.rb.getText("rules.rulesPage.guidedView.tabs.conditionsAndActions.txt"));
				oSplitter3.getParent().removeContent(oActionsView);
				oSplitter3.insertContentArea(oActionsView, 1);
				oSplitter3.setVisible(true);
	    		oSplitter2.removeContentArea(oFormView);
				this.removeStyleClass("cfFullFormView");
				oFormView.getLayoutData().setSize("80%");
				oSplitter2.insertContentArea(oGridView, 0);
		    	oSplitter3.insertContentArea(oFormView, 0);
				oBorderLayoutCenter1.removeContent(oSplitter2);
				oBorderLayoutCenter2.addContent(oSplitter2);
				oSplitter1.setVisible(true);
				//oFormView.updateModelFromFullForm();
				var ruleFormGrid = sap.ui.getCore().byId("RulesPageGuidedViewFormView_RuleGuidedFormGrid");
				ruleFormGrid.setVisible(false);
				ruleFormGrid.destroyContent();
				var expressionsFormGrid = sap.ui.getCore().byId("RulesPageGuidedViewFormView_RuleExpressionsFormGrid");
				expressionsFormGrid.removeContent();
				expressionsFormGrid.destroyContent(true);
				if (!sas.fscf.getCurrentPageView().jsonRule.expressions.expressions[0].properties) {
					sas.fscf.getCurrentPageView().jsonRule.expressions.expressions[0].properties = {};
				}
				sas.fscf.getCurrentPageView().jsonRule.expressions.expressions[0].properties.view = "grid";
		    	if (this._bDirtySinceLastFormView) {
					// reset the grid and palette
					oGridView.removeAllPanels(true);
					// reload the grid
					sas.fscf.loadRule(this);
		    	}
				oFormView.initSplitForm();
				expressionsFormGrid.setVisible(true);
				sas.fscf.removeAllMessageStrips();
				sas.fscf.getCurrentPageView().setDirty(true);
		    	this._bDirtySinceLastFormView = false;
		}
	},

    reload: function() {
	  	this.getPalette().reload();
		var ruleFormGrid = sap.ui.getCore().byId("RulesPageGuidedViewFormView_RuleGuidedFormGrid");
		if (ruleFormGrid.getVisible()) {
		  	this.getForm().reload();
		} else {
			this.getGrid().reload();
		}
		this.getActionsView().reload();
	},
	
	getActionsView:function(){
		return sap.ui.getCore().byId("RulesPageGuidedViewActionsView");
	},
//	getAlertCreationConfigurationDialog:function(){
//		return sap.ui.getCore().byId("RulesPageGuidedViewActionsViewAlertCreationConfigurationDialog");
//	},
    getPalette: function() {
    	return sap.ui.getCore().byId("RulesPageGuidedViewPaletteView");
    },

    getGrid: function() {
    	return sap.ui.getCore().byId("RulesPageGuidedViewGridView");
    },

    getForm: function() {
    	return sap.ui.getCore().byId("RulesPageGuidedViewFormView");
    },

    getRelatedRows: function() {
    	return sap.ui.getCore().byId("RulesPageGuidedViewRelatedRowsView");
    },

    back: function() {
    	var _this = this;
    	if (sas.fscf.getCurrentPageView().isDirty()) {
    		sas.hc.m.MessageDialog.warning({
                title: sas.fscf.rb.getText('rules.rulesPage.guidedView.confirm.save.txt'),
                text: sas.fscf.rb.getText('rules.rulesPage.guidedView.confirm.close.txt'),
                buttonActions: [sas.hc.m.MessageDialogAction.Yes, sas.hc.m.MessageDialogAction.No, sas.hc.m.MessageDialogAction.Cancel]
            }).attachButtonPress(function(e) {
                var action = e.getParameter("origin").getMessageDialogAction();
				if (action == sas.hc.m.MessageDialogAction.Yes) {
					sap.ui.getCore().byId("RulesPageGuidedViewCloseButton").setEnabled(false);
					sap.ui.getCore().byId("RulesPageGuidedViewPromoteButton").setEnabled(false);
					_this.setClose(true);
					_this.validateAlertAction();
		   			_this.save(function () {
		   				// success callback
		   		    	sas.fscf.getCurrentPageView().switchToMainContent();
		   		    	return;
		   			}, function () {
		   				// failure callback
		   				return;
		   			});
				} else if (action == sas.hc.m.MessageDialogAction.No) {
					sas.fscf.getApplicationView().setBusyIndicatorDelay(0).setBusy(true);
			    	sas.fscf.getCurrentPageView().switchToMainContent();
			    	sas.fscf.getApplicationView().setBusy(false);
					return;
				}
            });
    	} else {
	    	sas.fscf.getCurrentPageView().switchToMainContent();
			return;
    	}
    },

    promote: function() {
    	var _this = this;
    	if (sas.fscf.getCurrentPageView().isDirty()) {
    		sas.hc.m.MessageDialog.warning({
                title: sas.fscf.rb.getText('rules.rulesPage.guidedView.confirm.save.txt'),
                text: sas.fscf.rb.getText('rules.rulesPage.guidedView.confirm.promote.txt'),
            	buttonActions: [sas.hc.m.MessageDialogAction.Ok, sas.hc.m.MessageDialogAction.Cancel]
            }).attachButtonPress(function(e) {
                var action = e.getParameter("origin").getMessageDialogAction();
				if (action == sas.hc.m.MessageDialogAction.Ok) {
					sap.ui.getCore().byId("RulesPageGuidedViewCloseButton").setEnabled(false);
					sap.ui.getCore().byId("RulesPageGuidedViewPromoteButton").setEnabled(false);
					_this.setPromote(true);
					_this.validateAlertAction();
					if(sas.fscf.getCurrentPageView().jsonRuleIncomplete==true){
						//do nothing
					}
					else{
			   			_this.save(function () {
			   				// success callback
							sas.fscf.getApplicationView().setBusyIndicatorDelay(0).setBusy(true);
			   		    	sas.fscf.getCurrentPageView().getSubView("Rules").promoteRuleToTesting(sas.fscf.getCurrentPageView().jsonRule.id);
			   		    	sas.fscf.getCurrentPageView().switchToMainContent();
			   		    	return;
			   			}, function () {
			   				// failure callback
			   				return;
			   			});
					}
				}
            });
    	} else {
			sas.fscf.getApplicationView().setBusyIndicatorDelay(0).setBusy(true);
	    	sas.fscf.getCurrentPageView().getSubView("Rules").promoteRuleToTesting(sas.fscf.getCurrentPageView().jsonRule.id);
	    	sas.fscf.getCurrentPageView().switchToMainContent();
			return;
    	}
    },

    save: function(successCallback, failureCallback) {
    	var _this = this;
    	
		if(sas.fscf.getCurrentPageView().jsonRuleIncomplete==true){
			//do nothing
		}
		else{
				sas.fscf.getApplicationView().setBusyIndicatorDelay(0).setBusy(true);
		    	var ruleFormGrid = sap.ui.getCore().byId("RulesPageGuidedViewFormView_RuleGuidedFormGrid");
		   	    if (ruleFormGrid.getVisible()){
		   	    	var oFormView = sap.ui.getCore().byId(this.sId + 'FormView');
		   	    	oFormView.updateModelFromFullForm();
		   	    	oFormView.clearRulePanelData();
		   	    } else {
		   	    	_this.getGrid().storeRulePanelData();
		   	    }
		   	    //only save alert reason if alert is configured properly
		   	    sas.fscf.getCurrentPageView().jsonRule.alertReason=(sas.fscf.getCurrentPageView().jsonRule.queueId != '') ? sas.fscf.getCurrentPageView().jsonRule.alertReason : '';
				var jsonRule = {
					"id":sas.fscf.getCurrentPageView().jsonRule.id,
					"lastUpdateNumber": sas.fscf.getCurrentPageView().jsonRule.lastUpdateNumber,
					"queueId":sas.fscf.getCurrentPageView().jsonRule.queueId,
					"alertTypeId":sas.fscf.getCurrentPageView().jsonRule.alertTypeId,
					"alertReason": sas.fscf.getCurrentPageView().jsonRule.alertReason,
					"expressions":sas.fscf.getCurrentPageView().jsonRule.expressions,
					"guidedRule": true
				};
				var urlString = 'rest/businessunits/' + sas.fscf.getCurrentPageView().jsonRule.businessUnitId + '/rules/'+ jsonRule.id;
				var requestType = "PUT";
		   		sas.ajax({url:urlString, type: requestType, data: jsonRule, headers:sas.fscf.getAjaxHeaders()})
		   		  .done(function(oData){
		   			  sas.fscf.getCurrentPageView().jsonRule.lastUpdateNumber = oData.lastUpdateNumber;
		   			  if(sap.ui.getCore().byId("AlertCreationConfigurationDialog"))
		   				  sap.ui.getCore().byId("AlertCreationConfigurationDialog").close();
		   					  
		   			  sas.fscf.getCurrentPageView().setDirty(false);
		   			  sas.fscf.getApplicationView().setBusy(false);
  		   			  
		   			if (oData.errors.length>0)
			   			  sas.fscf.showMessageStrip(sap.ui.core.MessageType.Warning, sas.fscf.rb.getText('rules.rulesPage.guidedView.ruleSavedSuccessfullyErrors.txt'), _this.sId);
	   			    else
			   			  sas.fscf.showMessageStrip(sap.ui.core.MessageType.Success, sas.fscf.rb.getText('rules.rulesPage.guidedView.ruleSavedSuccessfully.txt'), _this.sId);
		   			if (successCallback) {
		   			    successCallback.call();
		   			}
		   		  }).fail(function(oObj,textStatus,errorThrown){
		   			  sas.fscf.getApplicationView().setBusy(false);
		   			  if(errorThrown == "Conflict"){
		   		  			sas.fscf.showMessageStrip(sap.ui.core.MessageType.Error, sas.fscf.rb.getText('rules.rulesPage.guidedView.cannotSaveEditedElsewhere.txt'), _this.sId);
		   			  } else if (oObj.responseJSON && oObj.responseJSON.message) {
		   		  			sas.fscf.showMessageStrip(sap.ui.core.MessageType.Error, oObj.responseJSON.message, _this.sId);
		   			  } else {
		   		  			sas.fscf.showMessageStrip(sap.ui.core.MessageType.Error, sas.fscf.rb.getText('rules.rulesPage.guidedView.errorSavingRule.txt') + " - " + errorThrown, _this.sId);
		   			  }
		  			  if (failureCallback) {
		   				  failureCallback.call();
		   			  }
				});
		}
    },

    preview: function() {
    	var _this = this;
    	if (sas.fscf.getCurrentPageView().isDirty()) {
    		sas.hc.m.MessageDialog.warning({
                title: sas.fscf.rb.getText('rules.rulesPage.guidedView.confirm.save.txt'),
                text: sas.fscf.rb.getText('rules.rulesPage.guidedView.confirm.preview.txt'),
                buttonActions: [sas.hc.m.MessageDialogAction.Ok, sas.hc.m.MessageDialogAction.Cancel]
            }).attachButtonPress(function(e) {
                var action = e.getParameter("origin").getMessageDialogAction();
				if (action == sas.hc.m.MessageDialogAction.Ok) {
    				//_this.validateAlertAction();
					var canSave = true;
					var ruleFormGrid = sap.ui.getCore().byId("RulesPageGuidedViewFormView_RuleGuidedFormGrid");
	    			if(ruleFormGrid.getVisible()){
	    				var oFormView = sap.ui.getCore().byId(_this.sId + 'FormView');
						oFormView.updateModelFromFullForm(true);
						if(sas.fscf.getCurrentPageView().jsonRuleIncomplete==true){
							canSave = false;
						}
					}
    				_this.validateAlertAction();
    				if(!canSave&&sas.fscf.getCurrentPageView().jsonRuleIncomplete==true){
    					//do nothing
    				}
    				else{
    					_this.save(function () {
			   				// success callback
		    				sas.fscf.getCurrentPageView().getPreviewRuleDialog().open();
			   		    	return;
			   			}, function () {
			   				// failure callback
			   				return;
			   			});
    				}
				}
            });
    	} else {
			sas.fscf.getCurrentPageView().getPreviewRuleDialog().open();
			return;
    	}
    },

    _dirtySet: function(bDirty) {
    	sap.ui.getCore().byId(this.sId + "ToolbarSaveButton").setEnabled(bDirty);
    	if (bDirty) {
        	this._bDirtySinceLastFormView = bDirty;
    	}
    },

    _destroyAll: function() {
    	this.getPalette().destroy();
    	this.getGrid().destroy();
    	this.getForm().destroy();
        this.getActionsView().destroy();
        //this.getAlertCreationConfigurationDialog().destroy();
        if(sap.ui.getCore().byId("RulesPageGuidedViewAlertCreationConfigurationDialogalertDestinationLabel"))
        	sap.ui.getCore().byId("RulesPageGuidedViewAlertCreationConfigurationDialogalertDestinationLabel").destroy();
        if(sap.ui.getCore().byId("RulesPageGuidedViewAlertCreationConfigurationDialogalertTypeLabel"))
        	sap.ui.getCore().byId("RulesPageGuidedViewAlertCreationConfigurationDialogalertTypeLabel").destroy();
        var i=0;
        for(i=0;i<100;i++){
        	if (sap.ui.getCore().byId("RulesPageGuidedViewActionsViewdecisionSelect-"+i)) {
            sap.ui.getCore().byId("RulesPageGuidedViewActionsViewdecisionSelect-"+i).destroy();
        	}else{break;}
        }

        for(i=0;i<100;i++){
        	if(sap.ui.getCore().byId("RulesPageGuidedViewActionsViewAlertCreationConfigurationDialogalertDestinationSelect-"+i)){
        		sap.ui.getCore().byId("RulesPageGuidedViewActionsViewAlertCreationConfigurationDialogalertDestinationSelect-"+i).destroy();
        	}else{break;}
        }

    },
    getActionConfiguration: function(validate) {
    	var view = sap.ui.jsfragment({
            type: sap.ui.core.mvc.ViewType.JS,
            id: this.sId + "AlertCreationConfigurationDialog",
            fragmentName: "sas.fscf.views.fragments.AlertCreationConfigurationDialog"
        });
    	view.setGuidedApproach(true);
    	if(validate!=null)
    		view.setValidate(validate);
    	return view.lazyLoadContent();
    },
    validateAlertAction: function(){
    		sas.fscf.getCurrentPageView().jsonRuleIncomplete=false;
    	    var createAlertChk = sap.ui.getCore().byId("RulesPageGuidedViewActionsViewalertActionCheckBox");
    	    var createAlert = createAlertChk.getChecked();
    	    var alertCnfgBtn=sap.ui.getCore().byId("RulesPageGuidedViewActionsViewconfigureButton1");
    		var alertCnfg=alertCnfgBtn.getEnabled();
	    	var alertDestination=sas.fscf.getCurrentPageView().jsonRule.queueId;
	    	var alertType=sas.fscf.getCurrentPageView().jsonRule.alertTypeId;
	    	if(alertType!=null)alertType=alertType.trim();
	    	if((alertCnfg || createAlert) && (alertDestination==null || alertDestination=="" || alertType==null || alertType=="")){
	    		if(createAlert){
	    			createAlertChk.setValueState(sap.ui.core.ValueState.Error);
	    			sap.ui.getCore().byId("RulesPageGuidedViewActionsView").setIgnoreState(true);
	    		}
	    		var view =this.getActionConfiguration(true);
	    		view.open();
	    		sas.fscf.getCurrentPageView().jsonRuleIncomplete=true;
	    	}
	 },
	 getRuleProperties: function(){
	    	var view = sap.ui.jsfragment({
	            type: sap.ui.core.mvc.ViewType.JS,
	            id: this.sId + "RulePropertiesDialog",
	            fragmentName: "sas.fscf.views.fragments.RulePropertiesDialog"
	        });	    	
	    	var fields = "expressions";	
	    	// get the rule's saved expressions (we only want to edit/save the rule's properties)
	    	sas.ajax({url:'rest/businessunits/'+sas.fscf.getCurrentPageView().jsonRule.businessUnitId+'/rules/'+sas.fscf.getCurrentPageView().jsonRule.id+'?fields='+fields, headers:sas.fscf.getAjaxHeaders()})
	    	  .done(function(oData){	    	  
	    	    	var expressions = oData.expressions;
	    	    	if(expressions){
	    	    		sas.fscf.getCurrentPageView().jsonRule.expressions = expressions;
	    	    	}else{
	    	    		sas.fscf.getCurrentPageView().jsonRule.expressions = sas.fscf.getEmptyRuleExpressions();
	    	    	}
	    	    	return view.lazyLoadContent().open();
	    	}).fail(function(oObj,textStatus){
	    	     	console.log("failure getting rule's expressions");
	    		    sas.fscf.getCurrentPageView().jsonRule.expressions= sas.fscf.getEmptyRuleExpressions();
	    	});
	    	
	 }

});
