sap.ui.jsview("sas.fscf.views.RulesPageCoding", {
    getControllerName: function () {
        return "sas.fscf.views.RulesPageCoding";
    },

    _bInit: false,
    _isSaving:false, //do not do rule validation while the rule is saving
    _willingToWaitUntil: 0,
    
    _promote:false,
    
    // RAPTOR-3977 IE 11 does NOT support shorthand function declaration inside an object literal
    // Method definition: https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Functions/Method_definitions
    // Browser compatibility: https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Functions/Method_definitions#browser_compatibility
    setPromote: function (promote) {
    	this._promote=promote;
    },
    
    getPromote: function () {
    	return this._promote;
    },
    
    _close:false,
    
    setClose: function (close){
    	this._close=close;
    },
    
    getClose: function () {
    	return this._close;
    },
    
    _showCheckSyntaxButton:false,
    setShowCheckSyntaxButton: function(showCheckSyntaxButton){    	
   		if(showCheckSyntaxButton != null ){
   			this._showCheckSyntaxButton=showCheckSyntaxButton;
   		}
   		else{
   			this._showCheckSyntaxButton = this.getSystemProperty('webapp_show_rule_syntax_button',this.setCheckSyntaxButtonVisibility);
   		}
   	},
   	getShowCheckSyntaxButton: function(){
   		return this._showCheckSyntaxButton;
   	},
    /*
    _useSyntaxCheckShortcut:false,
    setUseSyntaxCheckShortcut: function(useSyntaxCheckShortcut){    	
   		if(useSyntaxCheckShortcut != null ){
   			this._useSyntaxCheckShortcut=useSyntaxCheckShortcut;
   		}
   		else{
   			this.getSystemProperty('webapp.use.syntax.check.shortcut',this.setSyntaxCheckShortcut);
   		}
   	},
   	getUseSyntaxCheckShortcut: function(){
   		return this._useSyntaxCheckShortcut;
   	},
   	*/
   	_doneTypingInterval:500,
   	setDoneTypingInterval: function(doneTypingInterval){    	
   		if(doneTypingInterval != null ){
   			this._doneTypingInterval=doneTypingInterval;
   		}
   		else{
   			this.getSystemProperty('webapp_done_typing_interval',this.setDoneTypeingValue);
   		}
   	},
   	getDoneTypingInterval: function(){
   		return this._doneTypingInterval;
   	},
   	
   	_enableAutoCompleter:true,
    setEnableAutoCompleter: function(enableAutoCompleter){    	
   		if(enableAutoCompleter != null ){
   			this._enableAutoCompleter=enableAutoCompleter;
   		}
   		else{
   			this.getSystemProperty('webapp_enable_autocompleter',this.setAutoCompleteEnabled);
   		}
   	},
   	getEnableAutoCompleter: function(){
   		return this._enableAutoCompleter;
   	},
    isInit: function() {
    	return this._bInit;
    },

    setInit: function(bInit) {
    	this._bInit = bInit;
    },

    _editor: null,

    getEditor: function() {
    	return this._editor;
    },

    _verified: false,
    isVerified: function() {
    	return this._verified;
    },

    setVerified: function(verified) {
    	this._verified = verified;
    },
    alwaysDisable:(sas.fscf.getCurrentPageView().jsonRule.ruleTypeName=="Queue")? false : true,
    getAlwaysDisable:function(){
    	return this.alwaysDisable;
    },
   	setAlwaysDisable: function(){
   		if(sas.fscf.getCurrentPageView().jsonRule.ruleTypeName=="Queue")
   			this.alwaysDisable=false;
   		else if(sas.fscf.getCurrentPageView().jsonRule.ruleTypeName=="Variable")
   			this.alwaysDisable=true;
   		else
   			this.alwaysDisable= this.queuedResponseMacros=="";
   	},
	queuedResponseMacros:"",
   	setQueuedResponseMacros:function(){
   		this.queuedResponseMacros=this.getQueuedResponseMacros();
   	},
	getMacroMatch: function(){
		return new RegExp(this.queuedResponseMacros,'i')
	},


    createContent: function(oController) {
    	jQuery.sap.require("sas.hc.ui.commons.layout.BorderLayout");
    	jQuery.sap.require("sas.hc.ui.commons.layout.BorderLayoutArea");
        jQuery.sap.require("sas.hc.m.ResponsiveToolbar");
        jQuery.sap.require("sas.hc.m.ToolbarSpacer");
        jQuery.sap.require("sas.hc.m.Link");
        jQuery.sap.require("sas.hc.m.Label");
        jQuery.sap.require("sas.hc.m.Button");
        jQuery.sap.require("sas.hc.ui.layout.Splitter");
        jQuery.sap.require("sas.hc.ui.layout.SplitterLayoutData");
		jQuery.sap.require("sas.hc.m.MessageDialog");
		jQuery.sap.require("sas.hc.m.MessageDialogAction");
        jQuery.sap.require("sas.fscf.views.GuidedHelper");
        jQuery.sap.require("sas.fscf.views.OperatorLogic");
        jQuery.sap.require('sas.hc.ui.commons.codeEditor.CodeEditor');
		jQuery.sap.require('sas.hc.ui.thirdparty.ace.ace');
	    jQuery.sap.require('AntlrMain');
	    var AntlrMain=ace.require('antlr/main').AntlrMain;
	    var AntlrInst = new AntlrMain();

    	var _this = this;

    	_this.setQueuedResponseMacros();
    	_this.setShowCheckSyntaxButton();
    	//_this.setUseSyntaxCheckShortcut();
    	_this.setDoneTypingInterval();
    	_this.setEnableAutoCompleter();
    	_this.setAlwaysDisable();


    	this.addStyleClass("cfCodingView");

    	var oReturnButton =  new sas.hc.m.Button({
            id: this.sId + "ReturnButton",
    	    icon : "sap-icon://nav-back",
    	    tooltip:sas.fscf.rb.getText("rules.rulesPage.returnToRules.txt"),
    	    ariaLabel:sas.fscf.rb.getText("rules.rulesPage.returnToRules.txt"),
    	    enabled:true,
    	    press: function(){sas.fscf.removeAllMessageStrips();_this.back();}
        });
    	oReturnButton.addStyleClass("cfFirstToolbarItem");

    	var oRuleNameLabel = new sas.hc.m.Label({
  			id: this.sId + "ToolbarRuleNameLabel",
            text: sas.fscf.getCurrentPageView().jsonRule.name
		});
    	oRuleNameLabel.addStyleClass("cfRuleNameLabel");
    	    	
    	var oSyntaxCheckSuccessLabel = new sas.hc.m.Label({
  			id: this.sId + "ToolbarSyntaxCheckSuccessLabel",
            text:"",
            visible:false
		});    	
    	oSyntaxCheckSuccessLabel.addStyleClass("cfSuccessLabel");
    	
    	var oSyntaxCheckErrorLabel = new sas.hc.m.Label({
  			id: this.sId + "ToolbarSyntaxCheckErrorLabel",
            text:"",
            visible:false
		});
    	oSyntaxCheckErrorLabel.addStyleClass("cfErrorLabel");

    	var oSaveButton = new sas.hc.m.Button({
        	id: this.sId + "ToolbarSaveButton",
    		icon: 'sap-icon://hc/save',
	    	tooltip: sas.fscf.rb.getText("rules.rulesPage.guidedView.save.txt"),
	    	ariaLabel: sas.fscf.rb.getText("rules.rulesPage.guidedView.save.txt"),
	    	enabled: false,
     		press: function (oEvent) {
     			sas.fscf.removeAllMessageStrips();
				_this.save();
    		}
		});

    	var oRulePropertiesButton =  new sas.hc.m.Button({
            id: this.sId + "editablePropertiesButton",
    	    icon : "sap-icon://hc/properties",
    	    tooltip:sas.fscf.rb.getText("rules.rulesPage.properties.txt"),
    	    ariaLabel:sas.fscf.rb.getText("rules.rulesPage.properties.txt"),
    	    enabled:true,
    	    press: function(){sas.fscf.removeAllMessageStrips();_this.getRuleProperties().open();}
        });
    	var oConfigureAlertButton =  new sas.hc.m.Button({
            id: this.sId + "configureAlertButton",
    	    icon : "sap-icon://hc/configuration",
    	    enabled:(sas.fscf.getCurrentPageView().jsonRule.ruleTypeName=="Queue")? true : false,
    	    tooltip:sas.fscf.rb.getText("rules.rulesPage.guidedView.form.alertCreationConfiguration.txt"),
    	    ariaLabel:sas.fscf.rb.getText("rules.rulesPage.guidedView.form.alertCreationConfiguration.txt"),
    	    press: function(){sas.fscf.removeAllMessageStrips();_this.getAlertConfiguration(false).open();}
        });
        oConfigureAlertButton.addStyleClass("cfFirstButton");
    	var oTestRuleButton =  new sas.hc.m.Button({
            id: this.sId + "TestRuleButton",
    	    icon : "sap-icon://hc/test",
    	    enabled:false, // disable on page load RAPTOR-3574, enable after syntax check
    	    tooltip:sas.fscf.rb.getText("rules.rulesPage.rules.testRule.txt"),
    	    ariaLabel:sas.fscf.rb.getText("rules.rulesPage.rules.testRule.txt"),
    	    press: function(){
    	    	sas.fscf.removeAllMessageStrips();
    	     	_this.testRule();
    	   }
        });
        var oCheckSyntaxButton =  new sas.hc.m.Button({
            id: this.sId + "CheckSyntaxButton",
    	    icon : "sap-icon://hc/grooveAttributes",    	    
    	    visible:false,
    	    tooltip:sas.fscf.rb.getText("rules.rulesPage.rules.checkSyntax.txt"),
    	    ariaLabel:sas.fscf.rb.getText("rules.rulesPage.rules.checkSyntax.txt"),
    	    press: function(){
    	    	sas.fscf.removeAllMessageStrips();
    	    	this.setEnabled(false);//don't want them pressing the syntax checker multiple times
    	    	sap.ui.getCore().byId("RulesPageCodingView").remoteSyntaxCheck(_this.getEditor());
    	   }
        });
        
    	var oPromoteButton = new sas.hc.m.Button({
            id: this.sId + "PromoteButton",
    	    text:sas.fscf.rb.getText("fcm.application.promote.txt"),
    	    enabled:true,
    	    press: function(){sas.fscf.removeAllMessageStrips();_this.promote();}
        });

    	var oCloseButton = new sas.hc.m.Button({
            id: this.sId + "CloseButton",
    	    text:sas.fscf.rb.getText("fcm.application.close.txt"),
    	    enabled:true,
    	    press: function(){
    	    	sas.fscf.removeAllMessageStrips();
    	    	_this.back();
    	    	}
        });
    	oCloseButton.addStyleClass("cfLastToolbarItem");

        var oToolbar1 = new sap.m.Toolbar({
        	id: this.sId + "Toolbar",
    	    content: [
      	            oReturnButton,
    	            oRuleNameLabel,
    	      		new sas.hc.m.Label({
    	      			id: this.sId + "ToolbarBusinessUnitLabel",
    	                text: sas.fscf.rb.getText("rules.rulesPage.guidedView.businessUnit.txt") + " " + sas.fscf.getCurrentPageView().jsonRule.businessUnitName
    	    		}),
    	    		oConfigureAlertButton,
    	    		oRulePropertiesButton,
    	    		oSaveButton,
    	    		oTestRuleButton,
					oCheckSyntaxButton,					
					oSyntaxCheckSuccessLabel,
					oSyntaxCheckErrorLabel,
  			      	new sas.hc.m.ToolbarSpacer({
					}),
		      		new sas.hc.m.Label({
		                text: sas.fscf.rb.getText("rules.rulesPage.guidedView.population.txt")
		    		}),
    				new sas.hc.m.ProgressIndicator({
    				    id: _this.sId + 'PopulationIndicator',
    				    width : "24%",
    				    percentValue : 100,
    				    displayValue : sas.fscf.percentFormatter.format(1),
    				    showValue : true,
    				    state: sap.ui.core.ValueState.None
    				}).addStyleClass("cfPopulationIndicator"),
    				oPromoteButton,
    				oCloseButton
    	    ]
    	});

        var oSplitter2LayoutData1 = new sas.hc.ui.layout.SplitterLayoutData({
        	resizable: true,
            size: "60%"
        });
        var oSplitter2LayoutData2 = new sas.hc.ui.layout.SplitterLayoutData({
        	resizable: true,
        	size: "auto"
        });

        var keywords = AntlrInst.getKeywords();
	    	//("integer|string|real|boolean|date").split("|");
	    keywords+="in,missing,and,or";
	    keywords=keywords.split(",");

        var keywordsLength=keywords.length;
        var bu=sas.fscf.getCurrentPageView().jsonRule.businessUnitId;
        var txnType=sas.fscf.getCurrentPageView().jsonRule.transactionTypeId;
        var ruleTypeName=sas.fscf.getCurrentPageView().jsonRule.ruleTypeName;
        var id=sas.fscf.getCurrentPageView().jsonRule.id;


        var customHighlight = {
                "start": [{
                    token: "comment",
                    regex: "\\/\\/.*$"
                }, {
                    token: "comment",
                    regex: "\\/\\*",
                    next: "comment"
                }, {
                    token: "string", // single line
                    regex: '["](?:(?:\\\\.)|(?:[^"\\\\]))*?["]'
                }, {
                    token: "string", // single line
                    regex: "['](?:(?:\\\\.)|(?:[^'\\\\]))*?[']"
                }, {
                    token: "constant.numeric", // hex
                    regex: "0[xX][0-9a-fA-F]+\\b"
                }, {
                    token: "constant.numeric", // float
                    regex: "[+-]?\\d+(?:(?:\\.\\d*)?(?:[eE][+-]?\\d+)?)?\\b"
                }, {
                    token: "constant.language.boolean",
                    regex: "(?:true|false)\\b"
                },{
                    token: "text",//macro variable
                    regex: "&\w*\."
                }, {
                    onMatch: function(value) {
                        if (keywords.indexOf(value) >= 0){
                        	if(value.match(/%\w*/))//macro
                        		return "text";
                        	else
                        		return "keyword";
                        }
                        else
                            return "identifier";
                    },
                    regex: "[%a-zA-Z_$][%a-zA-Z0-9_$]*\\b"
                }, {
                    token: "keyword.operator",
                    regex: "!|\\$|%|&|\\*|\\-\\-|\\-|\\+\\+|\\+|~|===|==|=|!=|!==|<=|>=|<<=|>>=|>>>=|<>|<|>|!|&&|\\|\\||\\?\\:|\\*=|%=|\\+=|\\-=|&=|\\^="
                }, {
                    token: "punctuation.operator",
                    regex: "\\?|\\:|\\,|\\;|\\."
                }, {
                    token: "paren.lparen",
                    regex: "[[({]"
                }, {
                    token: "paren.rparen",
                    regex: "[\\])}]"
                }, {
                    token: "text",
                    regex: "\\s+"
                }],
                "comment": [{
                    token: "comment",
                    regex: ".*?\\*\\/",
                    next: "start"
                }, {
                    token: "comment",
                    regex: ".+"
                }]
            };

        var oEditor = new sas.hc.ui.commons.codeEditor.CodeEditor(this.sId + "CustomCodeEditor", {
            content: sas.fscf.getCurrentPageView().jsonRule.ruleCode ? sas.fscf.getCurrentPageView().jsonRule.ruleCode : '',
            gutterVisible:true,
            indentGuidesVisible:true,
            langMode:sas.hc.ui.commons.codeEditor.LanguageMode.Custom,
            highlightRules: customHighlight,
            //foldingEnabled: true,
            //indentEnabled:true,
           layoutData: oSplitter2LayoutData1

        });

        _this._editor = oEditor;
	
		     /*
	         * Please do not add any code without review and performance test
	         * in this function since it is time-critical and impacts usability.
	         */
	        var doneTypingInterval = 1;
			oEditor.attachBrowserEvent("keydown", function() {
				_this.setInit(false);
				//if(sas.fscf.getCurrentPageView().getCodingView().getUseSyntaxCheckShortcut() == false){
				if(sas.fscf.getCurrentPageView().getCodingView().getShowCheckSyntaxButton() == false){
					addDelay(function typing(oEditor) { }, oEditor, doneTypingInterval );
				}
			});
	
		     /*
	         * Please do not add any code without review and performance test
	         * in this function since it is time-critical and impacts usability.
	         */
			//var finalDoneTypingInterval = 500;
	        oEditor.attachBrowserEvent("keyup", function() {
	        	//if(sas.fscf.getCurrentPageView().getCodingView().getUseSyntaxCheckShortcut() == false){
				if(sas.fscf.getCurrentPageView().getCodingView().getShowCheckSyntaxButton() == false){	        		
	        		addDelay(remoteSyntaxCheck, oEditor, sas.fscf.getCurrentPageView().getCodingView().getDoneTypingInterval());
	        	}
	        });
		/*
         * Add delay time-out function for editing
         */
 	   function addDelay(method,oEditor, delay) {
 		    clearTimeout(method._tId);
 		    method._tId= setTimeout(function(){
 		        method(oEditor);
 		    }, delay);
 		}

		function setEnabledForAlertConfig(oEditor){
			if(_this.getAlwaysDisable()==false && sas.fscf.getCurrentPageView().jsonRule.ruleTypeName=="Authorization"){
				if(sap.ui.getCore().byId("RulesPageCodingView")){
				   var text=oEditor.getText();
		       	   var queuedResponseRule = text.match(_this.getMacroMatch())!=null;
		       	   sap.ui.getCore().byId("RulesPageCodingViewconfigureAlertButton").setEnabled(queuedResponseRule);
	       	   }
			}
		}

		/*
		 * This function performs a remote call to validate the
		 * rule.
		 */
		function remoteSyntaxCheck(oEditor) {
			sap.ui.getCore().byId("RulesPageCodingView").remoteSyntaxCheck(oEditor);
		 }

 		/*
		 * On Text change handler handles
		 * initializations when you first load the rule code
	 	 * as well as keeping track if the rule needs verification
		 */
       oEditor.attachTextChanged(function(e){
    	   setTimeout(function(){oEditor.focus();},20);
		   sas.fscf.removeAllMessageStrips();
		   
		   //RAPTOR-3574 only enable the test rule button if there are no syntax errors and the save button is disabled
		   sap.ui.getCore().byId("RulesPageCodingViewTestRuleButton").setEnabled(false);
		   
		   sap.ui.getCore().byId("RulesPageCodingViewToolbarSyntaxCheckSuccessLabel").setVisible(false);
		   sap.ui.getCore().byId("RulesPageCodingViewToolbarSyntaxCheckSuccessLabel").setText("");
		   sap.ui.getCore().byId("RulesPageCodingViewToolbarSyntaxCheckErrorLabel").setVisible(false);
		   sap.ui.getCore().byId("RulesPageCodingViewToolbarSyntaxCheckErrorLabel").setText("");
			
    	   if (!_this.isInit()) {
    		   sas.fscf.getCurrentPageView().setDirty(true);
			   //sap.ui.getCore().byId("RulesPageCodingViewCheckSyntaxButton").setEnabled(true);
    		   _this.setVerified(false);
    	   }else{
    		   _this.setInit(false);//original rule code loaded
    		   //sap.ui.getCore().byId("RulesPageCodingViewCheckSyntaxButton").setEnabled(false);
   			   remoteSyntaxCheck(this);
    	   }
    	   var text = this.getText();//doc.getValue();
    	   /*if(text==""){
    		   sap.ui.getCore().byId("RulesPageCodingViewCheckSyntaxButton").setEnabled(false);
    	   }  */  	   
    	   //added for remoteSyntaxCheck
    	   //ruleCode = text;
    	   //if(sas.fscf.getCurrentPageView().getCodingView().getUseSyntaxCheckShortcut() == false){
    	   if(sas.fscf.getCurrentPageView().getCodingView().getShowCheckSyntaxButton() == false){
    		   addDelay(remoteSyntaxCheck, oEditor, 1000);
    	   }

    	   //enable/disable alert config button    	   
    	addDelay(setEnabledForAlertConfig,oEditor,1000);
    	   

     	   var selectedText =this.getSelectedText();
     	   var caretPosition=this.caretPosition();

    	   /***SYNTAX CHECK***/
     	   var annotations = AntlrInst.validate(text);
     	   this.clearGutterIcons();
           if(annotations!=null){
	     	    for(i=0;i<annotations.length;i++){
	     	    	this.addGutterIcons([{lineIndex:annotations[i].row, icons:[{icon:sas.icons.ERRORSTATUSNODE_GOJS,tooltip:annotations[i].text}]}]);
	     	    }
            }

           /***RAPTOR-3613 - change (<caret>) to ( <caret> )***/
           if (e.mParameters.addedCharCount === 2 && e.mParameters.text === '()') {
        	   this.insert('  ');
        	   var selection = this.selection();
        	   this.selection(selection.start - 1, selection.end - 1); // move caret position back by 1
           }
           
           /***AUTO-INDENT***/
           //want to do this on carriage return


//     	   var row=caretPosition.line;
//     	   var lines = text.split('\n');
//     	   var subText="";
//     	   var currLine=lines[row];
//     	   var prevLine='';
//     	   var currTabs=0;
//     	   var prevTabs=0;
//     	   if(row!=0)prevLine=lines[row-1];
//     	   for(i=0;i<row;i++){//add the carriage returns back in for all except last
//     		   subText+=lines[i]+'\n';
//     	   }
//
//     	   if(row!=0){
//     		 currTabs=currLine.split('\t').length;
//     		 prevTabs=prevLine.split('\t').length;
//     	   }
//     	   var dos=text.split("do;").length-1;
//     	   var ends=text.split("end;").length-1;
//     	   var whiles=text.split("do while").length-1;
//
//     	   if((dos+whiles)>ends && row!=0 && subText.match('\n$')!=null && ((currLine.match('\t$')==null || currTabs==prevTabs)  && currLine.match('[^\t].*')==null)){
//     		   if(prevLine.match("then do;$")!=null || prevLine.match("do while\\(+[\\<\\w\\>]+\\);")!=null){
//         		   var tabs='';
//         		   var endTabs='';
//            	   if(prevLine.match('\t*')){
//            		   var noOfTabs=prevLine.split('\t').length;
//	            	   for(i=0;i<noOfTabs;i++){
//	            		   tabs+='\t';
//	            	   }
//
//	            	   for(i=0;i<noOfTabs-1;i++){
//	            		   endTabs+='\t';
//	            	   }
//            	   }
//         		   oEditor.insert(tabs+"\n"+endTabs+"end;");
//         		   oEditor.gotoLine(row+1);
//         	   }
//     	   }
//
     	});

        this.loadAutoCompleter(oEditor);




        oEditor.resize('100%', '100%');
        oEditor.activate();

        var oIconTabBarInfo = new sas.hc.m.IconTabBar({
        	id: this.sId + "TabBar",
            layoutData: oSplitter2LayoutData2
        });

        var oRelatedRowsView = sap.ui.view({
        	type: sap.ui.core.mvc.ViewType.JS,
        	id: this.sId + "RelatedRowsView",
        	viewName: "sas.fscf.views.RelatedRows"
        });
        oRelatedRowsView.setCoding(true);
        oRelatedRowsView.lazyLoadContent();

        var oIconRelatedRowsTab = new sas.hc.m.IconTabFilter( this.sId + "RelatedRowsTab", {
        	text:sas.fscf.rb.getText("rules.rulesPage.guidedView.tabs.relatedRows.txt"),
        	closable:false
        });
        oIconRelatedRowsTab.addContent( oRelatedRowsView );
        oIconTabBarInfo.addItem( oIconRelatedRowsTab );

        var oAlertRowsView = sap.ui.view({
        	type: sap.ui.core.mvc.ViewType.JS,
        	id: this.sId + "AlertRowsView",
        	viewName: "sas.fscf.views.AlertRows"
        });
        oAlertRowsView.setCoding(true);
        oAlertRowsView.lazyLoadContent();

        var oIconAlertsTab = new sas.hc.m.IconTabFilter( this.sId + "AlertsTab", {
        	text:sas.fscf.rb.getText("rules.rulesPage.codingView.tabs.alerts.txt"),
        	closable:false
        });
        oIconAlertsTab.addContent( oAlertRowsView );
        oIconTabBarInfo.addItem( oIconAlertsTab );

        var oLogView = sap.ui.view({
        	type: sap.ui.core.mvc.ViewType.JS,
        	id: this.sId + "LogView",
        	viewName: "sas.fscf.views.Log"
        });

        var oIconLogTab = new sas.hc.m.IconTabFilter( this.sId + "LogTab", {
        	text:sas.fscf.rb.getText("rules.rulesPage.codingView.tabs.log.txt"),
        	closable:false
        });
        oIconLogTab.addContent( oLogView );
        oIconTabBarInfo.addItem( oIconLogTab );

        var oSplitter2 = new sas.hc.ui.layout.Splitter({
            id: this.sId + 'Splitter2',
            contentAreas: [oEditor, oIconTabBarInfo],
            orientation: sap.ui.core.Orientation.Vertical,
            width: "100%",
            height: "100%"
        });
        oSplitter2.addStyleClass("cfSplitter2");

        var oBorderLayout1 = new sas.hc.ui.commons.layout.BorderLayout({
            id: this.sId + "BorderLayout1",
    		top: new sas.hc.ui.commons.layout.BorderLayoutArea({
                id: this.sId + "BorderLayoutTop1",
    			size: "2rem",
    			content: [
    			          oToolbar1
    			]
    		}),
    	    center: new sas.hc.ui.commons.layout.BorderLayoutArea({
                id: this.sId + "BorderLayoutCenter1",
    			content: [
    			          oSplitter2
      			]
      		})
    	});

        return oBorderLayout1;
    },

    setPopulationIndicator: function(total, current) {
		var oProgIndicator = sap.ui.getCore().byId(this.sId + "PopulationIndicator");
		if (oProgIndicator) {
			if (total != 0) {
				oProgIndicator.setPercentValue((current / total) * 100);
				oProgIndicator.setDisplayValue(sas.fscf.percentFormatter.format(current / total) + " (" + sas.fscf.rb.getText("rules.rulesPage.guidedView.population.xofy.fmt.txt", [sas.fscf.floatFormatter.format(current), sas.fscf.floatFormatter.format(total)]) + ")");
			} else {
				oProgIndicator.setPercentValue(100);
				oProgIndicator.setDisplayValue(sas.fscf.percentFormatter.format(1));
			}
		}
    },

    getCurrentTab: function() {
    	return sap.ui.getCore().byId(this.sId + "TabBar").getSelectedKey();
    },

    getRelatedRows: function() {
    	return sap.ui.getCore().byId(this.sId + "RelatedRowsView");
    },

    getAlertRows: function() {
    	return sap.ui.getCore().byId(this.sId + "AlertRowsView");
    },

    getLogView: function() {
    	return sap.ui.getCore().byId(this.sId + "LogView");
    },

    back: function() {
    	var _this = this;
    	if (sas.fscf.getCurrentPageView().isDirty()) {
    		sas.hc.m.MessageDialog.warning({
                title: sas.fscf.rb.getText('rules.rulesPage.guidedView.confirm.save.txt'),
                text: sas.fscf.rb.getText('rules.rulesPage.guidedView.confirm.close.txt'),
                buttonActions: [sas.hc.m.MessageDialogAction.Yes, sas.hc.m.MessageDialogAction.No, sas.hc.m.MessageDialogAction.Cancel]
            }).attachButtonPress(function(e) {
                var action = e.getParameter("origin").getMessageDialogAction();
				if (action == sas.hc.m.MessageDialogAction.Yes) {
					sap.ui.getCore().byId("RulesPageCodingViewCloseButton").setEnabled(false);
					sap.ui.getCore().byId("RulesPageCodingViewPromoteButton").setEnabled(false);
					_this.setClose(true);
		   			_this.save(function () {
		   				// success callback
		   		    	sas.fscf.getCurrentPageView().switchToMainContent();
		   		    	return;
		   			}, function () {
		   				// failure callback
		   				return;
		   			});
				} else if (action == sas.hc.m.MessageDialogAction.No) {
					sas.fscf.getApplicationView().setBusyIndicatorDelay(0).setBusy(true);
			    	sas.fscf.getCurrentPageView().switchToMainContent();
			    	sas.fscf.getApplicationView().setBusy(false);
					return;
				}
            });
    	} else {
	    	sas.fscf.getCurrentPageView().switchToMainContent();
			return;
    	}
    },

    promote: function() {
    	var _this = this;    	
    	if (sas.fscf.getCurrentPageView().isDirty()) {
    		sas.hc.m.MessageDialog.warning({
                title: sas.fscf.rb.getText('rules.rulesPage.guidedView.confirm.save.txt'),
                text: sas.fscf.rb.getText('rules.rulesPage.guidedView.confirm.promote.txt'),
            	buttonActions: [sas.hc.m.MessageDialogAction.Ok, sas.hc.m.MessageDialogAction.Cancel]
            }).attachButtonPress(function(e) {
                var action = e.getParameter("origin").getMessageDialogAction();
				if (action == sas.hc.m.MessageDialogAction.Ok) {
					sap.ui.getCore().byId("RulesPageCodingViewCloseButton").setEnabled(false);
					sap.ui.getCore().byId("RulesPageCodingViewPromoteButton").setEnabled(false);
					_this.setPromote(true);
		   			_this.save(function () {
		   				// success callback
		   				sas.fscf.getApplicationView().setBusyIndicatorDelay(0).setBusy(true);
		   		    	sas.fscf.getCurrentPageView().getSubView("Rules").promoteRuleToTesting(sas.fscf.getCurrentPageView().jsonRule.id);
		   		    	sas.fscf.getCurrentPageView().switchToMainContent();
		   		    	return;
		   			}, function () {
		   				// failure callback
		   				return;
		   			});
				}
            });
    	} else {
    		sas.fscf.getApplicationView().setBusyIndicatorDelay(0).setBusy(true);
	    	sas.fscf.getCurrentPageView().getSubView("Rules").promoteRuleToTesting(sas.fscf.getCurrentPageView().jsonRule.id);
	    	sas.fscf.getCurrentPageView().switchToMainContent();
			return;
    	}
    },
	addSyntaxGutterIcons:function(oEditor, errors) {
		var _this = this;
		//need to consolidate messages for a single line
		var output = [];
		errors.forEach(function(item) {
			var existing = output.filter(function(v, i) {
				return v.row == item.row;
			});
			if (existing.length) {
				var existingIndex = output.indexOf(existing[0]);
				output[existingIndex].message = output[existingIndex].message.concat(item.message);
			} else {
				if (typeof item.message == 'string')
				item.message = [item.message];
				output.push(item);
			}
		});
				
		var enableTestRule=true;
		if(
			(sap.ui.getCore().byId("RulesPageCodingViewToolbarSaveButton").getEnabled()== true)||//only want to enable test if rule has been saved
			(sas.fscf.getCurrentPageView().jsonRule.ruleCode.length==0)//only want to enable test if rule code is not empty
		){
			enableTestRule=false;
		}
		
		var errors=0;
		var warnings=0;
		for(var i=0;i<output.length;i++){

			var message="";
			for(j=0;j<output[i].message.length;j++){
				message+="\n"+output[i].message[j];
			}
			_this.setVerified(true);
			
			if (output[i].warning == true) {
				oEditor.addGutterIcons([{lineIndex:output[i].row-1, icons:[{icon:sas.icons.HC.WARNINGSTATUSNODE_GOJS,tooltip:message}]}]);
				warnings++;
			} else {
				if(output[i].row > 0){
					enableTestRule=false;//disable test button if an error exist
					oEditor.addGutterIcons([{lineIndex:output[i].row-1, icons:[{icon:sas.icons.HC.ERRORSTATUSNODE_GOJS,tooltip:message}]}]);
					errors++;
				}

			}
		}
		
		//if using on demand remote syntax check,show syntax check results in toolbar
		if(sas.fscf.getCurrentPageView().getCodingView().getShowCheckSyntaxButton() == true){
			
			var syntaxResult="";
			var resultType="";
			
			sap.ui.getCore().byId("RulesPageCodingViewToolbarSyntaxCheckSuccessLabel").setVisible(false);
			sap.ui.getCore().byId("RulesPageCodingViewToolbarSyntaxCheckSuccessLabel").setText(syntaxResult);
			sap.ui.getCore().byId("RulesPageCodingViewToolbarSyntaxCheckErrorLabel").setVisible(false);
			sap.ui.getCore().byId("RulesPageCodingViewToolbarSyntaxCheckErrorLabel").setText(syntaxResult);
			
			if(errors==0 && warnings==0){
				syntaxResult = sas.fscf.rb.getText("rules.rulesPage.codingView.success.txt");
				resultType="Success";				
			}else if (errors>0 && warnings>0){
				syntaxResult = warnings + " " + sas.fscf.rb.getText("rules.rulesPage.codingView.warnings.txt")+ ", " + errors + " " + sas.fscf.rb.getText("rules.rulesPage.codingView.errors.txt");
				resultType="Error";
			}else if( errors==0 && warnings>0){
				syntaxResult = warnings + " " + sas.fscf.rb.getText("rules.rulesPage.codingView.warnings.txt");
				resultType="Error";
			}else{
				syntaxResult = errors + " " + sas.fscf.rb.getText("rules.rulesPage.codingView.errors.txt");
				resultType="Error";
			}
			sap.ui.getCore().byId("RulesPageCodingViewToolbarSyntaxCheck"+resultType+"Label").setVisible(true);
			sap.ui.getCore().byId("RulesPageCodingViewToolbarSyntaxCheck"+resultType+"Label").setText(syntaxResult);
		}
		
		sap.ui.getCore().byId("RulesPageCodingViewTestRuleButton").setEnabled(enableTestRule);
		sap.ui.getCore().byId("RulesPageCodingViewCheckSyntaxButton").setEnabled(true);
	},
    save: function(successCallback, failureCallback) {
    	var _this = this;
    	//RAPTOR-3568   	
    	sap.ui.getCore().byId("RulesPageCodingViewToolbarSaveButton").setEnabled(false);//disable save button as soon as you press it
    	sap.ui.getCore().byId("RulesPageCodingViewCheckSyntaxButton").setEnabled(false);//disable check syntax button
    	sap.ui.getCore().byId("RulesPageCodingViewTestRuleButton").setEnabled(false);//disable test button (precautionary)
    	_this.getEditor().setReadOnly(true);//don't allow them to modify the code while the rule is saving
    	sap.ui.getCore().byId("RulesPageCodingViewToolbarSyntaxCheckSuccessLabel").setVisible(false);
		sap.ui.getCore().byId("RulesPageCodingViewToolbarSyntaxCheckSuccessLabel").setText("");
		sap.ui.getCore().byId("RulesPageCodingViewToolbarSyntaxCheckErrorLabel").setVisible(false);
		sap.ui.getCore().byId("RulesPageCodingViewToolbarSyntaxCheckErrorLabel").setText("");

    	sas.fscf.getCurrentPageView().jsonRuleIncomplete=false;
    	_this.validateRule();
		if(sas.fscf.getCurrentPageView().jsonRuleIncomplete==true){  // TODO some validation?
			//do nothing
		}
		else{
			   //only save alert reason if alert is configured properly
			   sas.fscf.getCurrentPageView().jsonRule.alertReason=(sas.fscf.getCurrentPageView().jsonRule.queueId != '') ? sas.fscf.getCurrentPageView().jsonRule.alertReason : '';
			   sas.fscf.getCurrentPageView().jsonRule.ruleCode=_this.getEditor().getText();
			   var jsonRule = {
					"id":sas.fscf.getCurrentPageView().jsonRule.id,
					"lastUpdateNumber": sas.fscf.getCurrentPageView().jsonRule.lastUpdateNumber,
					"queueId":sas.fscf.getCurrentPageView().jsonRule.queueId,
					"alertTypeId":sas.fscf.getCurrentPageView().jsonRule.alertTypeId,
					"alertReason": sas.fscf.getCurrentPageView().jsonRule.alertReason,
					"ruleCode": sas.fscf.getCurrentPageView().jsonRule.ruleCode,
					"expressions":sas.fscf.getCurrentPageView().jsonRule.expressions,
					"guidedRule": false
				};
				var urlString = 'rest/businessunits/' + sas.fscf.getCurrentPageView().jsonRule.businessUnitId + '/rules/'+ jsonRule.id;
				var requestType = "PUT";
				sas.fscf.getApplicationView().setBusyIndicatorDelay(0).setBusy(true);
		   		sas.ajax({url:urlString, type: requestType, data: jsonRule, headers:sas.fscf.getAjaxHeaders()})
		   		  .done(function(oData){
		   			  sas.fscf.getCurrentPageView().setDirty(false);
		   			  sas.fscf.getApplicationView().setBusy(false);
		   			  _this.getEditor().setReadOnly(false);//make code editable again
		   			  sap.ui.getCore().byId("RulesPageCodingViewCheckSyntaxButton").setEnabled(true);
		   			  sas.fscf.getCurrentPageView().jsonRule.lastUpdateNumber = oData.lastUpdateNumber;
		   			  if (oData.errors.length>0)
			   			  sas.fscf.showMessageStrip(sap.ui.core.MessageType.Warning, sas.fscf.rb.getText('rules.rulesPage.guidedView.ruleSavedSuccessfullyErrors.txt'), "RulesPageCodingViewBorderLayoutCenter1");
		   			  else
			   			  sas.fscf.showMessageStrip(sap.ui.core.MessageType.Success, sas.fscf.rb.getText('rules.rulesPage.guidedView.ruleSavedSuccessfully.txt'), "RulesPageCodingViewBorderLayoutCenter1");

		   			  if(sap.ui.getCore().byId("AlertCreationConfigurationDialog"))
		   				  sap.ui.getCore().byId("AlertCreationConfigurationDialog").close();
		   			  if (successCallback) {
		   				  successCallback.call();
		   			  }else{
		   				_this.addSyntaxGutterIcons(_this.getEditor(), oData.errors);
		   			  }
		   		  }).fail(function(oObj,textStatus,errorThrown){
		   			  sas.fscf.getApplicationView().setBusy(false);
					  _this.getEditor().setReadOnly(false);// make code editable again
					  sap.ui.getCore().byId("RulesPageCodingViewCheckSyntaxButton").setEnabled(true);
		   			  if(errorThrown == "Conflict"){
		   		  			sas.fscf.showMessageStrip(sap.ui.core.MessageType.Error, sas.fscf.rb.getText('rules.rulesPage.guidedView.cannotSaveEditedElsewhere.txt'), "RulesPageCodingViewBorderLayoutCenter1");
		   			  } else if (oObj.responseJSON.message) {
		   		  			sas.fscf.showMessageStrip(sap.ui.core.MessageType.Error, oObj.responseJSON.message, "RulesPageCodingViewBorderLayoutCenter1");
		   			  } else {
		   		  			sas.fscf.showMessageStrip(sap.ui.core.MessageType.Error, sas.fscf.rb.getText('rules.rulesPage.guidedView.errorSavingRule.txt') + " - " + errorThrown, "RulesPageCodingViewBorderLayoutCenter1");
		   			  }
		  			  if (failureCallback) {
		   				  failureCallback.call();
		   			  }
				});
		}
    },
    testRule: function(){
    	var _this = this;
    	sap.ui.getCore().byId("RulesPageCodingViewToolbarSyntaxCheckSuccessLabel").setVisible(false);
		sap.ui.getCore().byId("RulesPageCodingViewToolbarSyntaxCheckSuccessLabel").setText("");
		sap.ui.getCore().byId("RulesPageCodingViewToolbarSyntaxCheckErrorLabel").setVisible(false);
		sap.ui.getCore().byId("RulesPageCodingViewToolbarSyntaxCheckErrorLabel").setText("");

    	sas.fscf.removeAllMessageStrips();
    	if (sas.fscf.getCurrentPageView().isDirty()) {
    		sas.hc.m.MessageDialog.warning({
                title: sas.fscf.rb.getText('rules.rulesPage.guidedView.confirm.save.txt'),
                text: sas.fscf.rb.getText('rules.rulesPage.guidedView.saveRuleBeforeTesting.close.txt'),
                buttonActions: [sas.hc.m.MessageDialogAction.Ok, sas.hc.m.MessageDialogAction.Cancel]
            }).attachButtonPress(function(e) {
                var action = e.getParameter("origin").getMessageDialogAction();
				if (action == sas.hc.m.MessageDialogAction.Ok) {
		   			_this.save(function () {
		   				// success callback
		   				_this.runTest();
		   		    	return;
		   			}, function () {
		   				// failure callback
		   				return;
		   			});
				} else if (action == sas.hc.m.MessageDialogAction.Cancel) {
					return;
				}
            });
    	} else {
    		_this.runTest();
    	}

    },
    runTest:function(){
    	var _this = this;
    	sas.fscf.getApplicationView().setBusyIndicatorDelay(0).setBusy(true);
    	var urlString = 'rest/businessunits/' + sas.fscf.getCurrentPageView().jsonRule.businessUnitId + '/rules/'+ sas.fscf.getCurrentPageView().jsonRule.id+'/ruleTest?limit=-1';
		var requestType = "PUT";
		var dataBody={};
		sas.ajax({url:urlString, type: requestType, data: dataBody, headers:sas.fscf.getAjaxHeaders()})
		  .done(function(oData){
			 if(oData.errorCount>0){
				 for(i=0;i<oData.logEvents.length;i++){
					 if(oData.logEvents[i].level=="ERROR"){
						 sas.fscf.showMessageStrip(sap.ui.core.MessageType.Error, oData.logEvents[i].message, "RulesPageCodingViewBorderLayoutCenter1");
						 break;
					 }
				 }
			 }else if(oData.warningCount>0){
				 for(i=0;i<oData.logEvents.length;i++){
					 if(oData.logEvents[i].level=="WARNING"){
						 sas.fscf.showMessageStrip(sap.ui.core.MessageType.Warning, oData.logEvents[i].message, "RulesPageCodingViewBorderLayoutCenter1");
						 break;
					 }
				 }
			 }else{
				 sas.fscf.showMessageStrip(sap.ui.core.MessageType.Success, sas.fscf.rb.getText("rules.rulesPage.rules.actions.testRuleSuccess.txt"), "RulesPageCodingViewBorderLayoutCenter1");
			 }
			 _this.setPopulationIndicator(oData.totalCount, oData.matchCount);
			 _this.getRelatedRows().update();
			 _this.getAlertRows().update();
			 _this.getLogView().update(oData);
			 sas.fscf.getApplicationView().setBusy(false);
		  }).fail(function(oObj,textStatus,errorThrown){
	  			 if (oObj.responseJSON && oObj.responseJSON.message) {
	  				  sas.fscf.showMessageStrip(sap.ui.core.MessageType.Error, oObj.responseJSON.message, "RulesPageCodingViewBorderLayoutCenter1");
	  			 } else {
	 				  sas.fscf.showMessageStrip(sap.ui.core.MessageType.Error, oObj.status + " " + oObj.statusText, "RulesPageCodingViewBorderLayoutCenter1");
	  			 }
	  			 sas.fscf.getApplicationView().setBusy(false);
		});
    },
    _dirtySet: function(bDirty) {
    	sap.ui.getCore().byId(this.sId + "ToolbarSaveButton").setEnabled(bDirty);
    },

    _destroyAll: function() {
    },
    getRuleProperties: function(){
    	sap.ui.getCore().byId("RulesPageCodingViewToolbarSyntaxCheckSuccessLabel").setVisible(false);
		sap.ui.getCore().byId("RulesPageCodingViewToolbarSyntaxCheckSuccessLabel").setText("");
		sap.ui.getCore().byId("RulesPageCodingViewToolbarSyntaxCheckErrorLabel").setVisible(false);
		sap.ui.getCore().byId("RulesPageCodingViewToolbarSyntaxCheckErrorLabel").setText("");

    	var view = sap.ui.jsfragment({
            type: sap.ui.core.mvc.ViewType.JS,
            id: this.sId + "RulePropertiesDialog",
            fragmentName: "sas.fscf.views.fragments.RulePropertiesDialog"
        });
    	view.setCodingApproach(true);
    	return view.lazyLoadContent();
    },
    getSystemProperty:function(systemPropertyId,propertyCallback){
    	var urlString = 'rest/systemProperties/systemProperty?systemPropertyId='+systemPropertyId; 
    	var systemPropertyCall = sas.ajax({
 			async:true,
 			cache:false, 			
 			url: urlString,
 			dataType: "json",
 			contentType:"application/json; charset=utf-8",
 			headers:sas.fscf.getAjaxHeaders()
    	});   
    	$.when(systemPropertyCall).fail(function(oObj,textStatus,errorThrown){
			 if (oObj.responseJSON && oObj.responseJSON.message) {
				  sas.fscf.showMessageStrip(sap.ui.core.MessageType.Error, oObj.responseJSON.message, "RulesPageCodingViewBorderLayoutCenter1");
			 } else {
				  sas.fscf.showMessageStrip(sap.ui.core.MessageType.Error, oObj.status + " " + oObj.statusText, "RulesPageCodingViewBorderLayoutCenter1");
			 }
    	});
    	$.when(systemPropertyCall).done(function(systemPropertyData) {    		
    		var propertyValue = systemPropertyData.value.toLowerCase();
    		if( propertyValue==='true' || propertyValue ==='false'){
    			propertyValue=(propertyValue === 'true');
    		}
    		if(propertyCallback){
   			propertyCallback(propertyValue);
    		}else{
    			return propertyValue;
    		}
    	});
    },
    setCheckSyntaxButtonVisibility:function(showCheckSyntaxButton){    	
    	sas.fscf.getCurrentPageView().getCodingView().setShowCheckSyntaxButton(showCheckSyntaxButton);
    	sap.ui.getCore().byId("RulesPageCodingViewCheckSyntaxButton").setVisible(showCheckSyntaxButton);
    },
    /*
    setSyntaxCheckShortcut:function(useSyntaxCheckShortcut){
    	sas.fscf.getCurrentPageView().getCodingView().setUseSyntaxCheckShortcut(useSyntaxCheckShortcut);
    	if(useSyntaxCheckShortcut == true){
		    // USER CNTRL + SHIFT + S to check code syntax  
	    	var config=[{ctrlKey:true, altKey:false, shiftKey:true, keyCode: 83, handle:function(e){sap.ui.getCore().byId("RulesPageCodingView").remoteSyntaxCheck(sap.ui.getCore().byId("RulesPageCodingViewCustomCodeEditor"));}}];    
	    	sap.ui.getCore().byId("RulesPageCodingViewCustomCodeEditor").regShortcuts(config);
    	}
    },
    */
     setDoneTypeingValue:function(doneTypingInterval){
    	sas.fscf.getCurrentPageView().getCodingView().setDoneTypingInterval(doneTypingInterval);
    },
    setAutoCompleteEnabled:function(enableAutoCompleter){
    	sas.fscf.getCurrentPageView().getCodingView().setEnableAutoCompleter(enableAutoCompleter);
    	var codeEditor=sas.fscf.getCurrentPageView().getCodingView().getEditor();
    	if(codeEditor != null){
    		codeEditor.setAutoCompleteEnabled(enableAutoCompleter);
    	}
    },
    getQueuedResponseMacros:function(){
    	var bu=sas.fscf.getCurrentPageView().jsonRule.businessUnitId;
    	var txnType=sas.fscf.getCurrentPageView().jsonRule.transactionTypeId;
        var urlString = 'rest/actions/queuedResponseMacros?businessUnit=' + bu+ '&transactionType='+ txnType;
    	var queuedMacrosCall=sas.ajax({
    		async:false,
    		cache:true,
    		url:urlString,
    		dataType: "json",
    		contentType:"application/json; charset=utf-8",
    		headers:sas.fscf.getAjaxHeaders()
    	});
    	$.when(queuedMacrosCall).fail(function(oObj,textStatus,errorThrown){
 			 if (oObj.responseJSON && oObj.responseJSON.message) {
 				  sas.fscf.showMessageStrip(sap.ui.core.MessageType.Error, oObj.responseJSON.message, "RulesPageCodingViewBorderLayoutCenter1");
 			 } else {
				  sas.fscf.showMessageStrip(sap.ui.core.MessageType.Error, oObj.status + " " + oObj.statusText, "RulesPageCodingViewBorderLayoutCenter1");
 			 }
    	});

    	return queuedMacrosCall.responseJSON.items[0];
    },
    getAlertConfiguration: function(validate){
    	sap.ui.getCore().byId("RulesPageCodingViewToolbarSyntaxCheckSuccessLabel").setVisible(false);
		sap.ui.getCore().byId("RulesPageCodingViewToolbarSyntaxCheckSuccessLabel").setText("");
		sap.ui.getCore().byId("RulesPageCodingViewToolbarSyntaxCheckErrorLabel").setVisible(false);
		sap.ui.getCore().byId("RulesPageCodingViewToolbarSyntaxCheckErrorLabel").setText("");

    	var view = sap.ui.jsfragment({
            type: sap.ui.core.mvc.ViewType.JS,
            id: this.sId + "AlertConfigurationDialog",
            fragmentName: "sas.fscf.views.fragments.AlertCreationConfigurationDialog"
        });
    	view.setCodingApproach(true);
    	if(validate!=null)
    		view.setValidate(validate);
    	return view.lazyLoadContent();
    },
    validateRule:function(){
    	var _this=this;
    	if(sap.ui.getCore().byId("RulesPageCodingViewconfigureAlertButton").getEnabled()==true){
    			if (sas.fscf.getCurrentPageView().jsonRule.queueId ==undefined || sas.fscf.getCurrentPageView().jsonRule.queueId == '' || sas.fscf.getCurrentPageView().jsonRule.alertTypeId==undefined || sas.fscf.getCurrentPageView().jsonRule.alertTypeId=='') {
    		    		var view =_this.getAlertConfiguration(true).open();
    		    		sas.fscf.getCurrentPageView().jsonRuleIncomplete=true;
    			}
    	}
    },
    initAutoCompleter: function(customAutoCompleter,actionData, fieldData, lookupListData, functionListData,legalRulesData){
		customAutoCompleter.list.length=0;
		for(i=0;i<actionData.length;i++){
			if(actionData[i].CODE.toUpperCase().includes("HASRULEFIRED")){
						var functionName=actionData[i].CODE.substring(0,actionData[i].CODE.indexOf("("));
						for(ii=0;ii<legalRulesData.length;ii++){
							customAutoCompleter.list.push({
								text: functionName+"(#"+legalRulesData[ii].baseRuleId+")",
								help: sas.fscf.rb.getText('rules.rulesPage.codingView.testIfHasFired.fmt.txt',[legalRulesData[ii].name])
							});
						}
			}
			if(actionData[i].CODE.toUpperCase().includes("SET")){
				var functionName=actionData[i].CODE.substring(0,actionData[i].CODE.indexOf("("));
				for(ii=0;ii<fieldData.length;ii++){
					if(fieldData[ii].name.match(/[v]\d\d(?=_)/)){
						customAutoCompleter.list.push({
							text: functionName+"("+fieldData[ii].altName+")",
							help: actionData[i].ACTIONDESC
						});
					}
				}
	}
			else{
				customAutoCompleter.list.push({
					text:actionData[i].CODE,
					help: actionData[i].ACTIONDESC
				});
			}
		}
		var acr=[];
		for(i=0;i<fieldData.length;i++){
			if(fieldData[i].altName.substring(0,4).indexOf("_")!=-1){
				var help="";
				if(fieldData[i].name.match(/[v]\d\d(?=_)/)){//load all user variables which are used in SET
					var altName=fieldData[i].altName;
					var fieldType="";
					if(fieldData[i].variableType=="Character")
						fieldType=fieldData[i].variableType+fieldData[i].length;
					else
						fieldType=fieldData[i].variableType;
					help=fieldData[i].displayName +":"+fieldData[i].description+"("+fieldType+")"
					customAutoCompleter.list.push({
						text: altName,
						help: help
					});
				}
				else{
					var acronym=fieldData[i].altName.substring(0,3);//e.g.smh_
					if(fieldData[i].altName.substring(0,1)=="_")//client variables
						acronym=fieldData[i].altName.substring(0,2);//e.g. _a
					if(!customAutoCompleter.list.some(function(el){ return el.text === acronym})){
						customAutoCompleter.list.push({
							text: acronym,
							help: help
						});
					}
				}
			}
		}
		var allPropertyNames = Object.keys(functionListData);
		for (var j=0; j<allPropertyNames.length; j++) {
		    var name = allPropertyNames[j];
		    var value = functionListData[name];

		    var args= value["requiredArgCount"];
		    var argStr="";
		    if(args==0)
		    	argStr=="()";
		    else
		    	argStr="";
		    for(var ii=1;ii<args+1;ii++){
		    	if(ii==1)
		    		argStr+="(";
		    	argStr+="<arg"+ii+">";
		    	if(ii<args)
		    		argStr+=",";
		    	if(ii==args)
		    		argStr+=")";

		    }
		    customAutoCompleter.list.push({
				text: value["name"]+argStr,
				help: ""
			});
		}
		for(i=0;i<lookupListData.length;i++){
			customAutoCompleter.list.push({
				text: lookupListData[i].value,
				help: lookupListData[i].label
			});
		}
		return customAutoCompleter;
	},
    loadAutoCompleter:function(oEditor){
        var _this=this;
        var bu=sas.fscf.getCurrentPageView().jsonRule.businessUnitId;
        var txnType=sas.fscf.getCurrentPageView().jsonRule.transactionTypeId;
        var ruleTypeName=sas.fscf.getCurrentPageView().jsonRule.ruleTypeName;
        var id=sas.fscf.getCurrentPageView().jsonRule.id;
        var actionCall=sas.ajax({
 			async:true,
 			cache:false,
 			//url: 'rest/actions?businessUnit='+bu+'+&transactionType='+txnType+'&enabled=1',
 			url: 'rest/actions/codeEditor?businessUnit='+bu+'&transactionType='+txnType+'&ruleTypeName='+ruleTypeName,
 			dataType: "json",
 			contentType:"application/json; charset=utf-8",
 			headers:sas.fscf.getAjaxHeaders()
 		}),
 		fieldCall=sas.ajax({
 			async:true,
 			cache:false,
 			url: 'rest/businessunits/'+bu+'/fieldtypes?filter=ruleAccessible=true&txnType='+txnType,
 			dataType: "json",
 			contentType:"application/json; charset=utf-8",
 			headers:sas.fscf.getAjaxHeaders()
 		}),
 		lookupListCall=sas.ajax({
 			async:true,
 			cache:false,
 			url: 'rest/businessunits/'+bu+'/lookupListPrompts',
 			dataType: "json",
 			contentType:"application/json; charset=utf-8",
 			headers:sas.fscf.getAjaxHeaders()
 		}),
         functionListCall=sas.ajax({
 			async:true,
 			cache:false,
 			url: 'rest/businessunits/'+ruleTypeName+'/recognizedFunctions',
 			dataType: "json",
 			contentType:"application/json; charset=utf-8",
 			headers:sas.fscf.getAjaxHeaders()
 		}),
		legalRulesCall=sas.ajax({
			async:true,
			cache:false,
			url: 'rest/businessunits/'+bu+'/rules?filter=(id=='+id+')&fields=id,name,baseRuleId,ruleTypeName,legalPreReqRules',
			dataType: "json",
			contentType:"application/json; charset=utf-8",
			headers:sas.fscf.getAjaxHeaders()
	   	});
 		$.when(actionCall).fail(function(oObj,textStatus,errorThrown){
 			 if (oObj.responseJSON && oObj.responseJSON.message) {
 				  sas.fscf.showMessageStrip(sap.ui.core.MessageType.Error, oObj.responseJSON.message, "RulesPageCodingViewBorderLayoutCenter1");
 			 } else {
				  sas.fscf.showMessageStrip(sap.ui.core.MessageType.Error, oObj.status + " " + oObj.statusText, "RulesPageCodingViewBorderLayoutCenter1");
 			 }
 		});
 		$.when(fieldCall).fail(function(oObj,textStatus,errorThrown){
 			 if (oObj.responseJSON && oObj.responseJSON.message) {
 				  sas.fscf.showMessageStrip(sap.ui.core.MessageType.Error, oObj.responseJSON.message, "RulesPageCodingViewBorderLayoutCenter1");
 			 } else {
				  sas.fscf.showMessageStrip(sap.ui.core.MessageType.Error, oObj.status + " " + oObj.statusText, "RulesPageCodingViewBorderLayoutCenter1");
 			 }
 		});
 		$.when(lookupListCall).fail(function(oObj,textStatus,errorThrown){
 			 if (oObj.responseJSON && oObj.responseJSON.message) {
 				  sas.fscf.showMessageStrip(sap.ui.core.MessageType.Error, oObj.responseJSON.message, "RulesPageCodingViewBorderLayoutCenter1");
 			 } else {
				  sas.fscf.showMessageStrip(sap.ui.core.MessageType.Error, oObj.status + " " + oObj.statusText, "RulesPageCodingViewBorderLayoutCenter1");
 			 }
 		});
 		$.when(functionListCall).fail(function(oObj,textStatus,errorThrown){
 			 if (oObj.responseJSON && oObj.responseJSON.message) {
 				  sas.fscf.showMessageStrip(sap.ui.core.MessageType.Error, oObj.responseJSON.message, "RulesPageCodingViewBorderLayoutCenter1");
 			 } else {
				  sas.fscf.showMessageStrip(sap.ui.core.MessageType.Error, oObj.status + " " + oObj.statusText, "RulesPageCodingViewBorderLayoutCenter1");
 			 }
 		});
 		$.when(legalRulesCall).fail(function(oObj,textStatus,errorThrown){
 			 if (oObj.responseJSON && oObj.responseJSON.message) {
 				  sas.fscf.showMessageStrip(sap.ui.core.MessageType.Error, oObj.responseJSON.message, "RulesPageCodingViewBorderLayoutCenter1");
 			 } else {
				  sas.fscf.showMessageStrip(sap.ui.core.MessageType.Error, oObj.status + " " + oObj.statusText, "RulesPageCodingViewBorderLayoutCenter1");
 			 }
 		});
 		$.when(actionCall,fieldCall,lookupListCall,functionListCall,legalRulesCall).done(function(actionData,fieldData,lookupListData,functionListData,legalRulesData) {
 		if(sas.fscf.getCurrentPageView().getCodingView()){
 			var actionData=actionData[0].items;
 			var fieldData=fieldData[0].items;//to use for acronyms
 			var functionListData=functionListData[0];
 			if(lookupListData[0]!=null)
 				var lookupListData=lookupListData[0];
 			else var lookupListData=[];
 			if(legalRulesData[0].items[0].legalPreReqRules!=null)
				var legalRulesData=legalRulesData[0].items[0].legalPreReqRules;
			else var legalRulesData=[];

 	       /*****************************************************************************************/

 	       var customAutoCompleter = {
                list: [],
                openByShortcut: true,// enable auto-complete with cntrl+space
                getPrefix: function(line, col) {
                	var wordReg = /[\w%()#]+$/; // any RegExp to match your need (NEEDS TO BE CASE INSENSITIVE)
        	        var line = this._ctrl.model().getLine(line);
        	        if (line) {
        	        	var textBeforeCaret = line.substring(0, col);
        	        	var lastWordStart = textBeforeCaret.search(wordReg);
        	         	/***************************************************FIELDS**********************************************************************/
        	        	if(line.length>2 && line.match(/_{0,1}[\w]_{1,}/)!=null){
        	        		var j = textBeforeCaret.substring(lastWordStart).length;
 	        	            for(i=0;i<fieldData.length;i++){
 	        					if(fieldData[i].altName.substring(0,j).toUpperCase()==textBeforeCaret.substring(lastWordStart).toUpperCase()){
 	        						var found = customAutoCompleter.list.some(function (el) {
 		        	            	    return el.text === fieldData[i].altName;
 		        	            	});
 	        						if(!found){
 	        							if(fieldData[i].variableType=="Character")
 	        								fieldType=fieldData[i].variableType+fieldData[i].length;
 	        							else
 	        									fieldType=fieldData[i].variableType;
 	        							customAutoCompleter.list.push({
 	        	                            text: fieldData[i].altName,
 	        	                            help: fieldData[i].displayName +":"+fieldData[i].description+"("+fieldType+")"
 	        	                         });
 	        						}
 	        					}
 	        	            }
        	        	}
        	        	/*****************************************************************************************************************************/
        	        	return (lastWordStart === -1) ? '' : textBeforeCaret.substring(lastWordStart);
        	        }
        	        return "";
 	       	    }
 		    };
 	        _this.initAutoCompleter(customAutoCompleter,actionData, fieldData, lookupListData, functionListData,legalRulesData);
 	        oEditor.setAutoCompleteEnabled(sas.fscf.getCurrentPageView().getCodingView().getEnableAutoCompleter()); 	
 		    oEditor.setAutoCompleter(customAutoCompleter);
 		  }
 		  //oEditor.setPairBrackets(false);
 		});//close .$with
    },

    /*
	 * This function performs a remote call to validate the
	 * rule.
	 */
	remoteSyntaxCheck:function(oEditor) {
		var _this=sap.ui.getCore().byId("RulesPageCodingView");
		/***
			Extreme amount of time (in ms) that we would wait for a respose before starting another syntax check
		***/
		var timeWillingToWait = 300000;// 5 minutes
		/***
			Check if we've waited enough time for the previous ruleValidation to complete.
			If we haven't waited long enough then return without submitting another ruleValidation.
			If we waited enough time, then :
				- push the willingToWaitUntil another timeWillingToWait
				- allow another ruleValidation to kickoff
		***/
		if(_this._willingToWaitUntil !== 0){
			if (Date.now() <_this._willingToWaitUntil){
				return;
			}else{
				_this._willingToWaitUntil = 0;
			}
		}
		var ruleCode = oEditor.getText();
		if (_this.isVerified() == false && ruleCode!= "") {
			_this._willingToWaitUntil= Date.now() + timeWillingToWait;
			//rest call
			var data={ruleCode:ruleCode};
			var dataJson=JSON.stringify(data);
			var urlString = 'rest/businessunits/'+sas.fscf.getCurrentPageView().jsonRule.businessUnitId+'/rules/'+sas.fscf.getCurrentPageView().jsonRule.id+'/ruleValidations';
			var requestType = "PUT";
			sas.ajax({url:urlString, type: requestType, data: dataJson, headers:sas.fscf.getAjaxHeaders()}).done(function(oData){
				_this._willingToWaitUntil = 0;
				if(sap.ui.getCore().byId("RulesPageCodingView")){
					oEditor.clearGutterIcons();				
					_this.addSyntaxGutterIcons(oEditor, oData.items);
				}

			}).fail(function(oObj,textStatus,errorThrown){
				_this._willingToWaitUntil = 0;
				if(sap.ui.getCore().byId("RulesPageCodingView")){
					sap.ui.getCore().byId("RulesPageCodingViewCheckSyntaxButton").setEnabled(true);
					if (oObj.responseJSON.message) {
						oEditor.addGutterIcons([{lineIndex:0, icons:[{icon:sas.icons.HC.IMPORTANTSTATUSNODE_GOJS,tooltip:message}]}]);
					}
				}
				
			});
		}else{
			sap.ui.getCore().byId("RulesPageCodingViewCheckSyntaxButton").setEnabled(true);
		}
	 }
});
