jQuery.sap.declare("sas.fscf.views.PrimaryTableView");

sas.fscf.views.PrimaryTableView = {

    _bExplore: false,

    isExplore: function() {
    	return this._bExplore;
    },

    setExplore: function(bExplore) {
    	this._bExplore = bExplore;
    },

    _bCoding: false,

    isCoding: function() {
    	return this._bCoding;
    },

    setCoding: function(bCoding) {
    	this._bCoding = bCoding;
    },

    _oEstimation: null,

    isEstimation: function() {
    	return this._oEstimation !== null;
    },

    getEstimation: function() {
    	return this._oEstimation;
    },

    setEstimation: function(oData) {
    	this._oEstimation = oData;
    },

	_fields: [],
	_contextSpecificFields: [],
	_fieldVariableTypes: [],
	_colLimit: 200,

	createContent: function(oController) {
	},

	lazyLoadContent: function(oController) {
      if (this.getContent().length == 0) {
		jQuery.sap.require("sas.hc.ui.table.Table");
		jQuery.sap.require("sas.hc.ui.table.Column");
		jQuery.sap.require("sap.ui.model.json.JSONModel");
    	jQuery.sap.require("sas.hc.ui.unified.Menu");
        jQuery.sap.require("sas.hc.ui.unified.MenuItem");
        jQuery.sap.require("sas.hc.m.MessageDialog");

		var _this = this;

		sas.ajax({url:this.getFieldtypesUrl(), type: "GET", headers:sas.fscf.getAjaxHeaders()})
	  	  .done(function(oData){
	          _this._fieldtypesModel = new sap.ui.model.json.JSONModel(oData);
	      	 _this.continueLazyLoadContent(oController);
		  }).fail(function(oObj,textStatus,errorThrown){
	  	      console.info("Failed to get fieldtypes.");
	          _this._fieldtypesModel = new sap.ui.model.json.JSONModel({});
		      _this.continueLazyLoadContent(oController);
		  });
      }
    },

    continueLazyLoadContent: function(oController) {
		var _this = this;

		var model = new sap.ui.model.json.JSONModel({});

		var table = new sas.hc.ui.table.Table({
			id: this.sId + this.getTableIdSuffix(),
			editable: true,
			showTableOptions: false,
			visibleRowCountMode: sas.hc.ui.table.VisibleRowCountMode.Auto,
			minAutoRowCount: 15,
            showAlternateRowShading: true
		} );
		if(table.sId.includes("TransactionTable")){
			table.setMinAutoRowCount(1);
		}
		table.setModel(model);
		table.bindRows("/items");
    	table.onAfterRendering = function() {
        	if (sas.hc.ui.table.Table.prototype.onAfterRendering) {
        		sas.hc.ui.table.Table.prototype.onAfterRendering.apply(this);
        	}
        	this.getColumns().forEach(function(col) {
				col.getMenu().onBeforeRendering = function() {
		        	if (sas.hc.ui.table.ColumnMenu.prototype.onBeforeRendering) {
		        		sas.hc.ui.table.ColumnMenu.prototype.onBeforeRendering.apply(this);
		        	}
		        	if (!this.getItems()[this.getItems().length - 1]._bCustomized) {
		        		var oMenuAddColumn = new sas.hc.ui.unified.Menu({
			            });
		        		var oMenuItemAddColumn = new sas.hc.ui.unified.MenuItem({
			                text: sas.fscf.rb.getText("primaryTable.actions.AddColumn.txt"),
			                submenu: oMenuAddColumn
			            });
		        		var oMenuItemAddColumnBefore = new sas.hc.ui.unified.MenuItem({
			                text: sas.fscf.rb.getText("primaryTable.actions.AddColumn.Before.txt"),
			                select: function(oEvent) {
			                	_this.addColumnDialog(col.getIndex(), 0);
			                }
			            });
		        		oMenuItemAddColumnBefore._bCustomized = true;
		        		oMenuAddColumn.addItem(oMenuItemAddColumnBefore);
		        		var oMenuItemAddColumnAfter = new sas.hc.ui.unified.MenuItem({
			                text: sas.fscf.rb.getText("primaryTable.actions.AddColumn.After.txt"),
			                select: function(oEvent) {
			                	_this.addColumnDialog(col.getIndex(), 1);
			                }
			            });
		        		oMenuItemAddColumnAfter._bCustomized = true;
		        		oMenuAddColumn.addItem(oMenuItemAddColumnAfter);
		        		oMenuItemAddColumn._bCustomized = true;
			        	this.addItem(oMenuItemAddColumn);
		        		var oMenuItemRemoveColumn = new sas.hc.ui.unified.MenuItem({
			                text: sas.fscf.rb.getText("primaryTable.actions.RemoveColumn.txt"),
			                select: function(oEvent) {
			                	_this.removeColumn(table, col);
			                }
			            });
		        		oMenuItemRemoveColumn._bCustomized = true;
			        	this.addItem(oMenuItemRemoveColumn);
		        	}
				};
        	});
    	};
		table.attachColumnMove(function(oEvent) {
			var i = $.inArray(oEvent.mParameters.column.getSortProperty(), _this._fields);
			if (i !== -1) {
				_this._fields.splice(i, 1); // remove the field
				_this._fields.splice(oEvent.mParameters.newPos, 0, oEvent.mParameters.column.getSortProperty()); // add it back in the new position
				_this.storeFields();
			}
		});

		this.attachContextMenu(table);

        this.addContent(table);

       	this.update();
	},

    getTable: function () {
    	return sap.ui.getCore().byId(this.sId + this.getTableIdSuffix());
    },

	update: function() {
		//console.info("updating primary table");
		var _this = this;
		this.setBusy(true);

		var table = sap.ui.getCore().byId(_this.sId + _this.getTableIdSuffix());

		if (!table) {
			this.setBusy(false);
			// if table hasn't loaded and rendered yet, keep trying until it has
        	setTimeout(function() {
            	_this.update();
        	}, 500);
			return;
		}

		// add the columns if they have not already been added
		if (table.getColumns().length == 0) {
			var defaultColumns = this.getDefaultColumns();
			if (defaultColumns) {
				// add the initially visible columns
				this._fields = defaultColumns.match(/\S+/g) || [];	// split into array, removing all whitespace
				this.pruneFieldsByAccess(this._fields);
				this._fieldVariableTypes = [];
				for (var i = 0; i < this._fields.length; i++) {
					this._fieldVariableTypes[i] = this.getFieldVariableType(this._fields[i]);
					table.addColumn(
							new sas.hc.ui.table.Column({
								label: _this.getHeaderLabel(this._fields[i]),
								template: new sas.hc.m.Text({
									text: {path: this._fields[i],
	                                       formatter: this.getTextFormatterForVariableType(this._fieldVariableTypes[i])
	                                      },
									wrapping: false
								}),
								sortProperty: this._fields[i],
								visible: true,
								width: "200px"
							})
					);
				}
			}
		}
		
		var contextSpecificFields = _this.getContextSpecificFields();
		// remove any context specific columns that were there that are no longer there
		if (_this._contextSpecificFields && $.isArray(_this._contextSpecificFields)) {
			for (var j = _this._contextSpecificFields.length - 1; j >= 0; j--) {
				if ($.inArray(_this._contextSpecificFields[j], contextSpecificFields) !== -1) {
					// don't remove the column if it is still a context specific field
					continue;
				}
				// otherwise remove the column as it was a context specific field but is no longer
				var ci = $.inArray(_this._contextSpecificFields[j], _this._fields);
	    		_this._fields.splice(ci, 1); // remove the field
	    		table.removeColumn(ci);
			}
		}
		_this._contextSpecificFields = contextSpecificFields;
		// add context specific field columns if any		
		if (contextSpecificFields && $.isArray(contextSpecificFields)) {
			for (var i = contextSpecificFields.length - 1; i >= 0; i--) {
				_this.addColumn(1, 0, contextSpecificFields[i], true, true);
			}
		}

		// update the rows and re-bind the data model
        sas.ajax({url:this.getQueryUrl(), dataType:"json", headers:sas.fscf.getAjaxHeaders()})
          .done(function(oData){
        	  table.getModel().setData(oData);
  			  _this.setBusy(false);
        }).fail(function(oObj,textStatus){
        	console.info("an error occurred getting the primary table rows");
			_this.setBusy(false);
        });
	},

	getHeaderLabel: function(fieldName) {
		var oLabel = new sas.hc.m.Label({
			text: fieldName
		});
		this.annotateHeaderLabel(oLabel, fieldName);
    	return oLabel;
	},

    getFieldVariableType: function(fieldName) {
    	if (this._fieldtypesModel.getData().items) {
        	for (var i = 0; i < this._fieldtypesModel.getData().items.length; i++) {
        		if (this._fieldtypesModel.getData().items[i].altName == fieldName) {
        			return this._fieldtypesModel.getData().items[i].variableType;
        		}
        	}
    	}
    	return null;
    },

    getFieldAccess: function(fieldName) {
    	if (this._fieldtypesModel.getData().items) {
        	for (var i = 0; i < this._fieldtypesModel.getData().items.length; i++) {
        		if (this._fieldtypesModel.getData().items[i].altName == fieldName) {
        			return this._fieldtypesModel.getData().items[i].access;
        		}
        	}
    	}
    	return null;
    },

    getTextFormatterForVariableType: function(variableType) {
    	if (variableType == "Numeric") {
    		return function(val) {
    			if (val == undefined || val == null) {
    				return val;
    			}
    			var num = Number(val);
    			if (isNaN(num) || num % 1 === 0) {		// don't format integers
    				return val;
    			}
        		return sas.fscf.floatFormatterTranData.format(val);
    		};
    	} else if (variableType == "Currency") {
       		return function(val) {
       			if (val == undefined || val == null) {
       				return val;
       			}
       			var num = Number(val);
       			if (isNaN(num)) {
       				return val;
       			}
           		return sas.fscf.currencyFormatter.format(val);
       		};
    	} else if (variableType == "DateTime") {
    		return function(val) {
    			if (val == undefined || val == null) {
    				return val;
    			}
    			var date = new Date(val);
    			if (isNaN(date.getTime())) {
    				return val;
    			}
    			var bUTC = val.length > 0 && val.lastIndexOf("Z") == val.length - 1;	// if it ends in Z it is UTC
        		return sas.fscf.dateTimeFormatter.format(date, bUTC);					// true for second arg means use UTC
    		};
    	} else if (variableType == "Date") {
    		return function(val) {
    			if (val == undefined || val == null) {
    				return val;
    			}
    			var date = new Date(val);
    			if (isNaN(date.getTime())) {
    				return val;
    			}
    			var bUTC = val.length > 0 && val.lastIndexOf("Z") == val.length - 1;	// if it ends in Z it is UTC
        		return sas.fscf.dateFormatter.format(date, bUTC);						// true for second arg means use UTC
    		};
    	} else if (variableType == "Time") {
    		return function(val) {
    			if (val == undefined || val == null) {
    				return val;
    			}
    			var date = new Date("2000/01/01 " + val);
    			if (isNaN(date.getTime())) {
    				date = new Date(val);
        			if (isNaN(date.getTime())) {
        				return val;
        			}
    			}
    			var bUTC = val.length > 0 && val.lastIndexOf("Z") == val.length - 1;	// if it ends in Z it is UTC
        		return sas.fscf.timeFormatter.format(date, bUTC);						// true for second arg means use UTC
    		};
    	} else {
    		return function(val) {
        		return val;
    		};
    	}
    },

    addColumnDialog: function(columnIndex, indexDelta) {
    	if (this._fields.length == this._colLimit) {
    		sas.hc.m.MessageDialog.warning({
                title: sas.fscf.rb.getText('primaryTable.actions.AddColumn.columnLimit.txt'),
                text: sas.fscf.rb.getText('primaryTable.actions.AddColumn.columnLimit.msg.fmt.txt', this._colLimit),
                buttonActions: [sas.hc.m.MessageDialogAction.Ok]
            }).attachButtonPress(function(e) {
				return;
            });
    	} else {
	        var view = sap.ui.jsfragment({
	            type: sap.ui.core.mvc.ViewType.JS,
	            id: this.sId + "AddColumnDialog",
	            fragmentName: "sas.fscf.views.fragments.AddColumnDialog"
	        });
	        view.setOpenerId(this.sId);
	        view.setFields(this._fields);
	        view.setFieldtypesModel(this._fieldtypesModel);
	        view.setColumnIndex(columnIndex);
	        view.setIndexDelta(indexDelta);
	        var dialog = view.lazyLoadContent();
	        dialog.open();
    	}
    },

    addColumn: function(columnIndex, indexDelta, field, bSkipMove, bSkipUpdate) {
		var table = sap.ui.getCore().byId(this.sId + this.getTableIdSuffix());
		var i = $.inArray(field, this._fields);
		if (i == -1) {
			// not already in table, insert new
			i = columnIndex + indexDelta;
			this._fields.splice(i, 0, field);
			table.insertColumn(
				new sas.hc.ui.table.Column({
					label: this.getHeaderLabel(field),
					template: new sas.hc.m.Text({
						text: {path: field,
                               formatter: this.getTextFormatterForVariableType(this.getFieldVariableType(field))
                              },
						wrapping: false
					}),
					sortProperty: field,
					visible: true,
					width: "200px"
				}),
				i
			);
			if (!bSkipUpdate) {
				this.storeFields();
				this.update();
			}
		} else {
			// already in table, move (remove and insert)
			if (!bSkipMove && i != columnIndex + indexDelta) {
				var col = table.removeColumn(i);
				this._fields.splice(i, 1);
				if (i < columnIndex + indexDelta) {
					indexDelta--;
				}
				i = columnIndex + indexDelta;
				this._fields.splice(i, 0, field);
				table.insertColumn(col, i);
				this.storeFields();
			}
		}
    },

    removeColumn: function(table, column) {
    	if (this._fields.length == 1) {
    		sas.hc.m.MessageDialog.warning({
                title: sas.fscf.rb.getText('primaryTable.actions.RemoveColumn.lastColumn.txt'),
                text: sas.fscf.rb.getText('primaryTable.actions.RemoveColumn.lastColumn.msg.txt'),
                buttonActions: [sas.hc.m.MessageDialogAction.Ok]
            }).attachButtonPress(function(e) {
				return;
            });
    	} else {
    		this._fields.splice(column.getIndex(), 1); // remove the field
    		this.storeFields();
    		table.removeColumn(column.getIndex());
    	}
    },

    getBUId: function() {
   		return sas.fscf.getCookie("cf_lastRulesBU");
    },

    /*******************************************************************
     * The following items must be implemented in the
     * view class that mixes in PrimaryTableView
     *******************************************************************
    getFieldtypesUrl: function() {
    },

	getTableIdSuffix: function() {
	},

	attachContextMenu: function(table) {
	},

	getDefaultColumns: function() {
	},
	
	pruneFieldsByAccess: function(fields) {
	},

    padFields: function(fields) {
	},

    storeFields: function() {
    },

    getSchema: function() {
    },

    getContextSpecificFields: function() {
    },

    getQueryUrl: function() {
    },

	annotateHeaderLabel: function(oLabel) {
	}
     ******************************************************************/
};
