sap.ui.jsview("sas.fscf.views.PreferencePageOverview", {
    getControllerName: function () {
        return "sas.fscf.views.PreferencePageOverview";
    },

    createContent: function(oController) {
        jQuery.sap.require("sap.m.Toolbar");
        jQuery.sap.require("sas.hc.m.Button");
        jQuery.sap.require("sas.hc.m.MenuButton");
        jQuery.sap.require("sas.hc.m.Menu");
        jQuery.sap.require("sas.hc.m.MenuItem");

        var oToolbar = new sap.m.Toolbar({
    	    id: this.sId + 'Toolbar'
    	});
        oToolbar.setContentFor = function(type, canModify, canAddGrid, canAddAlertType) {
        	if (canModify === undefined) {
        		canModify = false;
        	}
        	oToolbar.destroyContent();

        	if (type == 'any') {

		        if (canAddGrid){
			        var newButton = new sas.hc.m.MenuButton({
			    	    id: this.sId + 'NewButton',
			        	text: sas.fscf.rb.getText("fcm.overview.new.txt"),
			        	icon : "sap-icon://hc/newStarburst",
						enabled: canModify,
			        	tooltip: sas.fscf.rb.getText("fcm.templates.fileRelatedActions.txt")
			        });

			        //Create the menu
			        var oMenu1 = new sas.hc.m.Menu("gridMenu1", {
			        	tooltip: sas.fscf.rb.getText("fcm.templates.menuFileRelatedActions.txt")
			        });

			        //Create the items and add them to the menu
			        var oMenuItem1 = new sas.hc.m.MenuItem("newGrid", {
			        	text: sas.fscf.rb.getText("fcm.preferences.new.gridTemplate.txt"),
			        	press: function() {
			        		frames['overview'].doPreferenceAction('createGridTemplate.action?');
			        	}
			        });
			        oMenu1.addItem(oMenuItem1);

			        //Attach the Menus to the MenuButtons
			        newButton.setMenu(oMenu1);

			        oToolbar.addContent(newButton);
		        }

	    		oToolbar.addContent(
	           		    new sas.hc.m.Button({
	                	    id: this.sId + 'RefreshButton',
	   				        text: sas.fscf.rb.getText("fcm.preferences.refreshCache.txt"),
	   				        icon : "sap-icon://hc/refresh",
	    					enabled: canModify,
	   				        press: function() {
	   				        	frames['overview'].doPreferenceAction('refreshCache');
	   				        }
	        		    })
	            );
        	}
        };
    	return oToolbar;
    }
});
