sap.ui.jsview("sas.fscf.views.Grid", {
    getControllerName: function () {
        return "sas.fscf.views.Grid";
    },

    _bExplore: false,

    isExplore: function() {
    	return this._bExplore;
    },

    setExplore: function(bExplore) {
    	this._bExplore = bExplore;
    },

    createContent: function(oController) {
    },

    lazyLoadContent: function() {
      if (this.getContent().length == 0) {
    	jQuery.sap.require('sas.hc.ui.commons.layout.HorizontalLayout');
    	jQuery.sap.require('sas.hc.m.Panel');
        jQuery.sap.require("sap.m.Toolbar");
        jQuery.sap.require("sap.m.Label");
        jQuery.sap.require("sas.hc.m.Button");
    	jQuery.sap.require("sas.hc.ui.unified.Menu");
        jQuery.sap.require("sas.hc.ui.unified.MenuItem");
        jQuery.sap.require("sap.ui.commons.ListBox");
        jQuery.sap.require("sap.ui.core.ListItem");
        jQuery.sap.require("sap.ui.model.json.JSONModel");
        jQuery.sap.require("sas.hc.m.SearchField");
        jQuery.sap.require("sap.ui.model.Filter");
        jQuery.sap.require("sap.ui.model.FilterOperator");
        jQuery.sap.require("sas.hc.m.Label");
        jQuery.sap.require("sas.hc.m.Select");
        jQuery.sap.require("sas.hc.ui.core.Item");
        jQuery.sap.require("sap.m.InputType");
        jQuery.sap.require("sas.hc.m.Input");
        jQuery.sap.require("sas.hc.m.MultiInput");
        jQuery.sap.require("sas.hc.m.Token");
    	jQuery.sap.require("sas.hc.ui.commons.layout.VerticalLayout");
    	jQuery.sap.require('sap.ui.thirdparty.jqueryui.jquery-ui-core');
    	jQuery.sap.require('sap.ui.thirdparty.jqueryui.jquery-ui-widget');
    	jQuery.sap.require('sap.ui.thirdparty.jqueryui.jquery-ui-mouse');
    	jQuery.sap.require('sap.ui.thirdparty.jqueryui.jquery-ui-sortable');
    	jQuery.sap.require('sap.ui.thirdparty.jqueryui.jquery-ui-droppable');
    	jQuery.sap.require('sap.ui.thirdparty.jqueryui.jquery-ui-draggable');

    	var _this = this;

    	this.addStyleClass("cfGridView");

        var oHLayout = new sas.hc.ui.commons.layout.HorizontalLayout({
    	    id: this.sId + "HorizLayout",
    		content: [
    		]
    	});

		oHLayout.onAfterRendering = function() {
        	if (sas.hc.ui.commons.layout.HorizontalLayout.prototype.onAfterRendering) {
        		sas.hc.ui.commons.layout.HorizontalLayout.prototype.onAfterRendering.apply(this);
        	}
        	_this.refreshCenteredMessage();
			$("#" + _this.sId + "HorizLayout").parent().droppable({
				accept: ".sapMLIB",
	            hoverClass: "cfGridViewDropHover",
				drop: function( event, ui ) {
					var oListItemId = ui.draggable.context.id;
					var oListItem = sap.ui.getCore().byId(oListItemId);
					_this.addPanel(null, _this.getContent()[0], "", oListItem.getTitle(), oListItem._fieldId, oListItem._variableType, sas.fscf.operators.EQUAL, null, oListItem._min, oListItem._max);
                    var scrollPane = document.getElementById(_this.getParent().sId + "-content-0");
                    setTimeout(function () {
                    	scrollPane.scrollLeft = scrollPane.scrollWidth + 1000;  // scroll all the way to the right/end
                    }, 5000);
				}
			});
		};

        this.addContent(oHLayout);
      }
    },
    _startMessage: "",
    getStartMessage: function() {
    	return this._startMessage;
    },
    setStartMessage: function(msg) {
    	this._startMessage = msg;
    },
	showCenteredMessage: function(parentId, type, message, customIconContent) {
		var $p = $("#" + parentId);
    	if ($p.length == 0) {
    		return;
    	}
		$p.find('.inlineMessage').remove();
    	if (!type) {
    		type = sap.ui.core.MessageType.Information;
    	}
    	var centeredMessageClass;
    	var centeredMessageIconContent;
    	switch (type) {
    		case sap.ui.core.MessageType.Success:
    			centeredMessageClass = "inlineMessageSuccess";
    			centeredMessageIconContent = "&#xf160;";
    			break;
    		case sap.ui.core.MessageType.Warning:
    			centeredMessageClass = "inlineMessageWarning";
    			centeredMessageIconContent = "&#xf018;";
    			break;
    		case sap.ui.core.MessageType.Error:
    			centeredMessageClass = "inlineMessageError";
    			centeredMessageIconContent = "&#xf22f;";
    			break;
    		default:
    			centeredMessageClass = "inlineMessageInfo";
    			centeredMessageIconContent = "&#xf330;";
    	}
		var markup = [];
		markup[markup.length] = '<div class="inlineMessage ' + centeredMessageClass + ' inlineMessageTransparent' + '" role="note" aria-live="assertive" aria-labelledby="' + parentId + '-inlineMessageMessage">';
		markup[markup.length] = '<div class="inlineMessageIcon">';
		markup[markup.length] = '<span class="sapUiBtnIco sapUiBtnIcoL sapUiIcon" style="font-family: sas-icons;" data-sap-ui-icon-content="' + ((customIconContent) ? customIconContent : centeredMessageIconContent) + '"></span>';
		markup[markup.length] = '</div>';
		markup[markup.length] = '<div class="inlineMessageMessage" id="' + parentId + '-inlineMessageMessage">';
		markup[markup.length] = message;
		markup[markup.length] = '</div>';
		markup[markup.length] = '</div>';
        $p.prepend(markup.join(''));
       	var $m = $p.find('.inlineMessage').first();
       	$m.css({position : 'absolute', zIndex : '5', margin: '0px', left: '33%', top: '25%', maxWidth: '33%'});
    },
    hideCenteredMessage: function(parentId) {
    	var $p = $('#' + parentId);
    	if ($p.length == 0) {
    		return;
    	}
		$p.find('.inlineMessage').remove();
    },
    refreshCenteredMessage: function() {
       	if (this.getContent()[0].getContent().length == 0) {
       		this.showCenteredMessage(this.sId, sap.ui.core.MessageType.Information, this.getStartMessage(), "&#xf0f7;");
       	} else {
       		this.hideCenteredMessage(this.sId);
       	}
    },
    getNextId: function(parentHLayout, parentId) {
    	if (parentHLayout.getContent().length > 0) {
    		var pieces = parentHLayout.getContent()[parentHLayout.getContent().length - 1]._pId.split("-");
    		pieces[pieces.length - 1] = parseInt(pieces[pieces.length - 1]) + 1;
    		return pieces.join("-");
    	} else {
    		var pieces = parentId.split("-");
    		pieces[0] = "F";
    		pieces[pieces.length] = 1;
    		return pieces.join("-");
    	}
    },
    addGroup: function(id, parentHLayout, parentId, type) {
    	this.customSetBusy(true);

        var _this = this;
    	_this.hideCenteredMessage(_this.sId);

    	var pId = id;
    	if (pId == null || pId == undefined) {
    		pId = _this.getNextId(parentHLayout, parentId);
    	}

    	var title;
    	if (type == "AND") {
    		title = sas.fscf.rb.getText("rules.rulesPage.guidedView.form.inclusionSets.all.txt");
    	} else if (type == "OR") {
    		title = sas.fscf.rb.getText("rules.rulesPage.guidedView.form.inclusionSets.any.txt");
    	} else if (type == "NOR") {
    		title = sas.fscf.rb.getText("rules.rulesPage.guidedView.form.inclusionSets.none.txt");
    	}

		var oPanel = new sas.hc.m.Panel({
			expandable: false,
			content: [
			]
		});
        oPanel.addStyleClass("cfGroup");
        oPanel._pId = pId;
		oPanel._isGroup = true;
		oPanel._groupType = type;
		// set name attribute
    	oPanel.onAfterRendering = function() {
        	if (sas.hc.m.Panel.prototype.onAfterRendering) {
        		sas.hc.m.Panel.prototype.onAfterRendering.apply(this);
        	}
        	// must be set after rendering when the dom ref will exist
        	this.getDomRef().setAttribute("name", this._pId);
    	};

        var oPanelHeaderToolbar = new sap.m.Toolbar({
        	id: oPanel.sId + "HeaderToolbar",
        	content: [
      	      		new sap.m.Label({
    	                text: title
    	    		}).addStyleClass("cfGridPanelHdrLabel")
        	]
        }).addStyleClass("cfGridPanelHdrTB");
	    var oButton = new sas.hc.m.Button({
	    	id: oPanel.sId + "_CloseButton",
    		icon: 'sap-icon://hc/close',
    		tooltip: sas.fscf.rb.getText("rules.rulesPage.guidedView.grid.remove.txt"),
    		press: function() {
    			_this.removeGroup(oPanel);
    		}
		});
	    oButton.addStyleClass("cfGridPanelHdrButton");
		// set name attribute
    	oButton.onAfterRendering = function() {
        	if (sas.hc.m.Button.prototype.onAfterRendering) {
        		sas.hc.m.Button.prototype.onAfterRendering.apply(this);
        	}
        	// must be set after rendering when the dom ref will exist
        	this.getDomRef().setAttribute("name", "CloseButton");
    	};
    	oPanelHeaderToolbar.addContent(oButton);
    	oPanel.setHeaderToolbar(oPanelHeaderToolbar);

	   	var oHorizLayout = new sas.hc.ui.commons.layout.HorizontalLayout({
	   		id: oPanel.sId + "_HorizLayout",
    		content: [
    		]
        });
		// set name attribute
	   	oHorizLayout.onAfterRendering = function() {
        	if (sas.hc.ui.commons.layout.HorizontalLayout.prototype.onAfterRendering) {
        		sas.hc.ui.commons.layout.HorizontalLayout.prototype.onAfterRendering.apply(this);
        	}
        	// must be set after rendering when the dom ref will exist
        	this.getDomRef().setAttribute("name", "HorizLayout");
    	};
    	oPanel.addContent(oHorizLayout);

		var oMenu = new sas.hc.ui.unified.Menu(oPanel.sId + "_Menu");
		// set name attribute
    	oMenu.onAfterRendering = function() {
        	if (sas.hc.ui.unified.Menu.prototype.onAfterRendering) {
        		sas.hc.ui.unified.Menu.prototype.onAfterRendering.apply(this);
        	}
        	// must be set after rendering when the dom ref will exist
        	this.getDomRef().setAttribute("name", "Menu");
    	};
        oPanel.setAggregation("contextMenu", oMenu);

        var oMenuItem = new sas.hc.ui.unified.MenuItem({
        	id: oPanel.sId + "_RemoveMenuItem",
            text: sas.fscf.rb.getText("rules.rulesPage.guidedView.grid.remove.txt")
        });
        oMenuItem.attachSelect(function() {
            _this.removeGroup(oPanel);
        });
		// set name attribute
    	oMenuItem.onAfterRendering = function() {
        	if (sas.hc.ui.unified.MenuItem.prototype.onAfterRendering) {
        		sas.hc.ui.unified.MenuItem.prototype.onAfterRendering.apply(this);
        	}
        	// must be set after rendering when the dom ref will exist
        	this.getDomRef().setAttribute("name", "RemoveMenuItem");
    	};
        oMenu.addItem(oMenuItem);

        parentHLayout.addContent(oPanel);

    	_this.customSetBusy(false);

    	return oPanel;
    },
    removeGroup: function(oPanel) {
    	if ($.type(oPanel) === 'string') {
    		oPanel = sap.ui.getCore().byId(oPanel);
    	}
    	if (!oPanel) {
    		return;
    	}
    	var parentHLayout = sap.ui.getCore().byId(oPanel.sId + "_HorizLayout");
    	for (var i = parentHLayout.getContent().length - 1; i >= 0; i--) {
    		this.removePanel(parentHLayout.getContent()[i], parentHLayout, (i == 0));
    	}
    },
    updatePageButtonEnablement: function (lbox, pageUpButton, pageDownButton) {
   		var lb = document.getElementById(lbox.sId);
   		pageUpButton.setEnabled(lb.scrollTop > 0);
		pageDownButton.setEnabled(lb.scrollTop < lb.children[0].offsetHeight - lb.offsetHeight);
    },
    commonListBoxOnAfterRendering: function(lbox, panel, pageUpButton, pageDownButton) {
   		if (lbox.getItems().length == 0) {
            lbox.addStyleClass("topBorder");
       	} else {
            lbox.removeStyleClass("topBorder");
       	}
   		// remove page buttons before calculating available height for items
		// remove doesn't work the 1st time, so add first then remove
		panel.addStyleClass("pagable");
		panel.removeStyleClass("pagable");
		var visibleItems = Math.floor($("#" + lbox.sId).height() / 24);
		if (lbox.getItems().length > visibleItems) {
			// show search field
			if (panel._type == 0 && !panel._filtering && panel._searchable == null) {
				panel._searchable = true;
				panel.addStyleClass("searchable");
			}
			// show page buttons
			panel.addStyleClass("pagable");
    		this.updatePageButtonEnablement(lbox, pageUpButton, pageDownButton);
		} else {
    		// remove doesn't work the 1st time, so add first then remove
			panel.addStyleClass("pagable");
			panel.removeStyleClass("pagable");
			pageUpButton.setEnabled(false);
			pageDownButton.setEnabled(false);
		}

		var li, $li, cls, lifullpct, lipct;
		for (var i = 0; i < lbox.getItems().length; i++) {
			li = lbox.getItems()[i];
			$li = $("#" + li.sId);
		    $li.find('.cfUiLbxIBar').remove(); // remove any bar that might already be there
		    lifullpct = (li._fullpct != undefined) ? (li._fullpct / lbox._maxfullpct) : li._pct;
		    lipct = (li._pct != undefined) ? (li._pct / lbox._maxfullpct) : 0;
		    lipct = Math.min(lipct, lifullpct);		// lipct should never be bigger than lifullpct
			$("<span class='cfUiLbxIBar'><div class='cfUiLbxIBarInner' style='width:" +  (50 * lifullpct) + "px;left:" + (50 - Math.max(50 * lifullpct, (lifullpct > 0) ? 1 : 0)) + "px" + ((lifullpct > 0) ? ";min-width:1px" : "") + "'></div><div class='cfUiLbxIBarInner2' style='width:" +  (50 * lipct) + "px;left:" + (50 - Math.max(50 * lipct, (lipct > 0) ? 1 : 0)) + "px" + ((lipct > 0) ? ";min-width:1px" : "") + "'></div></span>").insertAfter($li.find(".sapUiLbxITxt"));
		    $li.find('.cfUiLbxIBadge').remove(); // remove any badge that might already be there
		    if (li._fraudCount == undefined || li._fraudCount <= 0) {
		    	cls = " class='hidden'";
		    } else if (li._riskLevel == 0) {
		    	cls = " class='lowRisk'";
		    } else if (li._riskLevel == 1) {
		    	cls = " class='mediumRisk'";
		    } else if (li._riskLevel >= 2) {
		    	cls = " class='highRisk'";
		    }
			$("<span class='cfUiLbxIBadge'><span" + cls + ">" + li._fraudCount + "</span></span>").insertAfter($li.find(".sapUiLbxITxt"));
		}
    },
    commonListBoxHandleSelect: function(oEvent, _this) {
    	var oPanel = _this.getPanelForListBox(this);
        var field = oPanel._fieldType;
        var fieldId = oPanel._fieldId;
        var variableType = oPanel._variableType;
        var value, exp;

       	// handle anything that was selected that is no longer selected
       	var bStillSelected = false;
       	if (this._priorSelectedIndices && this._priorSelectedIndices.length > 0) {
           	for (var i = 0; i < this._priorSelectedIndices.length; i++) {
           		bStillSelected = false;
           		for (var j = 0; j < oEvent.mParameters.selectedIndices.length; j++) {
           			if (oEvent.mParameters.selectedIndices[j] == this._priorSelectedIndices[i]) {
           				bStillSelected = true;
           				break;
           			}
           		}
           		if (!bStillSelected) {
           			if (this.getItems()[this._priorSelectedIndices[i]]) {
                        value = this.getItems()[this._priorSelectedIndices[i]].getKey();
                        _this.selectValueInData(this.getModel().getData(), value, variableType, false);
                        if (oPanel._type == 1) {
                        	if (!this.getItems()[this._priorSelectedIndices[i]]._exp) {
                        		this.getItems()[this._priorSelectedIndices[i]]._exp = _this.getExpForRange(value);
                        	}
                        }
                        exp = this.getItems()[this._priorSelectedIndices[i]]._exp;
                        if (exp) {
           	               	_this.getForm().removeCondition(oPanel._pId, {
           	               		type: ((exp.leftValue != null) && (exp.leftValue != undefined)) ? "RANGE" : "COMPARE",
           	               		operator: exp.operator,
           	               		fieldId: fieldId,
           	               		fieldName: field,
           	               		fieldType: variableType,
           	               		value: exp.value,
           	               		leftValue: exp.leftValue,
           	               		rightValue: exp.rightValue,
           	               		leftOperator: exp.leftOperator,
           	               		rightOperator: exp.rightOperator
           	               	});
                        } else {
           	               	_this.getForm().removeCondition(oPanel._pId, {
           	               		type: "COMPARE",
           	               		operator: oPanel._bNot ? sas.fscf.operators.NE : sas.fscf.operators.EQUAL,
           	               		fieldId: fieldId,
           	               		fieldName: field,
           	               		fieldType: variableType,
           	               		value: value
           	               	});
                        }
           			}
           		}
           	}
       	} else {
       		// if first selection in this list box, then clear the selection in the other list box if there is any
       		var other_lbox = _this.getOtherListBoxForPanel(oPanel);
       		if (other_lbox) {
       			_this.notifyDeselects(oPanel, other_lbox, false);
       	    	other_lbox.clearSelection();
       	    	other_lbox._priorSelectedIndices = null;
       		}
       	}

       	// handle anything newly selected
       	var bWasSelected = false;
       	for (var i = 0; i < oEvent.mParameters.selectedIndices.length; i++) {
       		bWasSelected = false;
           	if (this._priorSelectedIndices) {
               	for (var j = 0; j < this._priorSelectedIndices.length; j++) {
           			if (this._priorSelectedIndices[j] == oEvent.mParameters.selectedIndices[i]) {
           				bWasSelected = true;
           				break;
           			}
               	}
           	}
       		if (!bWasSelected) {
                value = this.getItems()[oEvent.mParameters.selectedIndices[i]].getKey();
                _this.selectValueInData(this.getModel().getData(), value, variableType, true);
                if (oPanel._type == 1) {
                	if (!this.getItems()[oEvent.mParameters.selectedIndices[i]]._exp) {
                		this.getItems()[oEvent.mParameters.selectedIndices[i]]._exp = _this.getExpForRange(value);
                	}
                }
                exp = this.getItems()[oEvent.mParameters.selectedIndices[i]]._exp;
                if (exp) {
   	               	_this.getForm().addCondition(oPanel._pId, {
   	               		type: ((exp.leftValue != null) && (exp.leftValue != undefined)) ? "RANGE" : "COMPARE",
   	               		operator: exp.operator,
   	               		fieldId: fieldId,
   	               		fieldName: field,
   	               		fieldType: variableType,
   	               		value: exp.value,
   	               		leftValue: exp.leftValue,
   	               		rightValue: exp.rightValue,
   	               		leftOperator: exp.leftOperator,
   	               		rightOperator: exp.rightOperator
   	               	}, true);
                } else {
   	               	_this.getForm().addCondition(oPanel._pId, {
   	               		type: "COMPARE",
   	               		operator: oPanel._bNot ? sas.fscf.operators.NE : sas.fscf.operators.EQUAL,
   	               		fieldId: fieldId,
   	               		fieldName: field,
   	               		fieldType: variableType,
   	               		value: value
   	               	});
                }
       		}
       	}
       	
       	if (oEvent.mParameters.selectedIndices.length == 0) {
       		oPanel._value = "";
       		if (oPanel._bNot) {
       			oPanel._operator = sas.fscf.operators.NE;
       		} else {
       			oPanel._operator = sas.fscf.operators.EQUAL;
       		}  
       	} else if (oEvent.mParameters.selectedIndices.length == 1) {
       		oPanel._value = this.getItems()[oEvent.mParameters.selectedIndices[0]].getKey();
       		if (oPanel._bNot) {
       			oPanel._operator = sas.fscf.operators.NE;
       		} else {
       			oPanel._operator = sas.fscf.operators.EQUAL;
       		}  
       	} else {
       		oPanel._value = [];
           	for (var i = 0; i < oEvent.mParameters.selectedIndices.length; i++) {
           		oPanel._value[oPanel._value.length] = this.getItems()[oEvent.mParameters.selectedIndices[i]].getKey();
           	}
       		if (oPanel._bNot) {
       			oPanel._operator = sas.fscf.operators.NOTIN;
       		} else {
       			oPanel._operator = sas.fscf.operators.IN;
       		}  
       	}

       	_this.updateOperatorSelectEqualsItem(oPanel);
       	
    	_this.getRelatedRows().update();
       	_this.updateCounts(oPanel._pId);
    },
    setNot: function(bNot, oPanel) {
    	//numeric + currency panels should not become NOT'd 
    	if( oPanel._type == 1 ){
    		if( oPanel.getHeaderToolbar() ) {
    		    oPanel.getHeaderToolbar().removeContent(0).destroy();
    		}
    		oPanel._bNot = false;
    		oPanel.removeStyleClass("cfNot");
    		return;
    	} 	
    	
    	if (bNot) {
    		oPanel._bNot = true;
    		if( oPanel.getHeaderToolbar() ) {
    		    oPanel.getHeaderToolbar().insertContent(sas.icons.pool.createControlByURI("sap-icon://hc/cancel"));
    		}
    		oPanel.removeStyleClass("cfNot");
    		oPanel.addStyleClass("cfNot");
    		oPanel._operator = sas.fscf.getNegativeOperator(oPanel._operator);
    	} else {
    		if( oPanel.getHeaderToolbar() && oPanel._bNot ) {
    		    oPanel.getHeaderToolbar().removeContent(0).destroy();
    		}
    		oPanel._bNot = false;
    		oPanel.removeStyleClass("cfNot");
    		oPanel._operator = sas.fscf.getPositiveOperator(oPanel._operator);
    	}
    	this.updateOperatorSelect(oPanel);
    	this.updatePanelMenu(oPanel);
    },
    createOperatorInput: function(oPanel, value) {
    	var _this = this;
   		var oOperatorInput = new sas.hc.m.Input({
           	id: oPanel.sId + "_OperatorInput",
            value: value,
            placeholder: sas.fscf.rb.getText("rules.rulesPage.guidedView.grid.filter.txt")
        });
   		// set initial size and name attribute
   		oOperatorInput.onAfterRendering = function() {
           	if (sas.hc.m.Input.prototype.onAfterRendering) {
           		sas.hc.m.Input.prototype.onAfterRendering.apply(this);
           	}
   			$("#" + this.sId).find("input").attr("size", 16);
           	// must be set after rendering when the dom ref will exist
           	this.getDomRef().setAttribute("name", "OperatorInput");
   		};

        oOperatorInput.attachChange(function(oEvent) {            	
			_this.updateAfterOperatorInputChange(oPanel, oEvent.mParameters.newValue);
        });
        	        
        oOperatorInput.addStyleClass("cfGridCellOperatorInput");

        return oOperatorInput;
    },
    createOperatorMultiInput: function(oPanel, value) {
    	var _this = this;
   		var oOperatorInput = new sas.hc.m.MultiInput({
   			id: oPanel.sId + "_OperatorInput",
   			width: "100%"
        }).addStyleClass("cfEmptyMultiInput");
   		
     	//there's a Error: adding element with duplicate id '__panel8_OperatorInput-valueHelpIcon'
   		var helpIcon = sap.ui.getCore().byId(oOperatorInput.sId + "-valueHelpIcon");
   		if( helpIcon != undefined ) {
   			helpIcon.destroy();
   		}

		for (var k = 0; k < value.length; k++) {
			oOperatorInput.addToken(new sas.hc.m.Token({key: value[k], text:value[k]}).attachDelete(_this.getForm().handleTokenDelete));
		}
		_this.getForm().updateMultiInputClass(oOperatorInput);
   		// set initial name attribute
   		oOperatorInput.onAfterRendering = function() {
           	if (sas.hc.m.MultiInput.prototype.onAfterRendering) {
           		sas.hc.m.MultiInput.prototype.onAfterRendering.apply(this);
           	}
           	// must be set after rendering when the dom ref will exist
           	this.getDomRef().setAttribute("name", "OperatorInput");
   		};

        oOperatorInput.attachTokenUpdate(function(oEvent) {
			if (oEvent.mParameters.type == "removed" || oEvent.mParameters.type == "added") {
    			_this.getForm().updateMultiInputClass(oOperatorInput);
				if (oEvent.mParameters.type == "removed") {
					var value = [];
					for (var i = 0; i < this.getTokens().length; i++) {
						value[value.length] = this.getTokens()[i].getKey();
					}
					_this.updateAfterOperatorInputChange(oPanel, value);					
				}
			}
			
			if( oEvent.getParameters().type == "removed" ) {
    		    oEvent.oSource.focus();
    		}
			
			return true;
        });                	
        
        // not getting the token added events under attachTokenUpdate for some reason, so this manually adds the tokens ourselves
        oOperatorInput.attachChange(function(oEvent) {
			this.addToken(new sas.hc.m.Token({key: oEvent.mParameters.newValue, text:oEvent.mParameters.newValue}).attachDelete(_this.getForm().handleTokenDelete));
			_this.getForm().updateMultiInputClass(oOperatorInput);
			this.setValue("");
			this.focus();
			var value = [];
			for (var i = 0; i < this.getTokens().length; i++) {
				value[value.length] = this.getTokens()[i].getKey();
			}
			_this.updateAfterOperatorInputChange(oPanel, value);
        });
        	        
        oOperatorInput.addStyleClass("cfGridCellOperatorInput");

        return oOperatorInput;
    },
    createOperatorComboBoxInput: function(oPanel, value) {
    	var _this = this;
    	var oOperatorInput = new sas.hc.m.ComboBox({
    		id: oPanel.sId + "_OperatorInput",
    		width: "100%"
    	});
    	
    	oOperatorInput.setOpenDropdownOnInput( true );
    	oOperatorInput.setInlineAutocomplete( true );

    	// set initial name attribute
   		oOperatorInput.onAfterRendering = function() {
           	if (sas.hc.m.ComboBox.prototype.onAfterRendering) {
           		sas.hc.m.ComboBox.prototype.onAfterRendering.apply(this);
           	}
   		};

        // must be set after rendering when the dom ref will exist
        this.getDomRef().setAttribute("name", "OperatorInput");

        oOperatorInput.attachChange(function(oEvent) {            	
			_this.updateAfterOperatorInputChange(oPanel, oEvent.mParameters.newValue);
        });
        
        sas.fscf.getLookupListsForBox( oOperatorInput, oPanel._fieldType, value );

        return oOperatorInput;

    },
    updateOperatorSelect: function(oPanel) {
    	var oOperatorSelect = this.getOperatorSelectForPanel(oPanel); 
    	if (oOperatorSelect) {
    		var items = oOperatorSelect.getItems();
        	if (oPanel._bNot) {
        		for (var i = 0; i < items.length; i++) {
        			items[i].setKey(sas.fscf.getNegativeOperator(items[i].getKey()));
        			items[i].setText(sas.fscf.getLocalizedOperatorVerbose(items[i].getKey()));
        		}
        	} else {
        		for (var i = 0; i < items.length; i++) {
        			items[i].setKey(sas.fscf.getPositiveOperator(items[i].getKey()));
        			items[i].setText(sas.fscf.getLocalizedOperatorVerbose(items[i].getKey()));
        		}
        	}
    	}
    },
    updateOperatorSelectEqualsItem: function(oPanel) {
    	var oOperatorSelect = this.getOperatorSelectForPanel(oPanel); 
    	if (oOperatorSelect) {
    		var item = oOperatorSelect.getItems()[0];
        	if (oPanel._bNot) {
        		if (($.isArray(oPanel._value)) && (oPanel._value.length > 1)) {
        			item.setKey( sas.fscf.operators.NOTIN );
        			item.setText(sas.fscf.getLocalizedOperatorVerbose(item.getKey()));
        		} else {
        			item.setKey( sas.fscf.operators.NE );
        			item.setText(sas.fscf.getLocalizedOperatorVerbose(item.getKey()));
        		}
        	} else {
        		if (($.isArray(oPanel._value)) && (oPanel._value.length > 1)) {
        			item.setKey( sas.fscf.operators.IN );
        			item.setText(sas.fscf.getLocalizedOperatorVerbose(item.getKey()));
        		} else {
        			item.setKey( sas.fscf.operators.EQUAL );
        			item.setText(sas.fscf.getLocalizedOperatorVerbose(item.getKey()));
        		}
        	}
    	}
    },
    updateSelectedOperator: function(oPanel) {
    	var oOperatorSelect = this.getOperatorSelectForPanel(oPanel); 
    	if (oOperatorSelect) {
    		oOperatorSelect.setSelectedKey(oPanel._operator);
    	}
    },
    updatePanelMenu: function(oPanel) {
    	var _this = this;
    	
        oPanel.destroyAggregation("contextMenu");
        
		var oMenu = new sas.hc.ui.unified.Menu(oPanel.sId + "_Menu");
		// set name attribute
    	oMenu.onAfterRendering = function() {
        	if (sas.hc.ui.unified.Menu.prototype.onAfterRendering) {
        		sas.hc.ui.unified.Menu.prototype.onAfterRendering.apply(this);
        	}
        	// must be set after rendering when the dom ref will exist
        	this.getDomRef().setAttribute("name", "Menu");
    	};
        oPanel.setAggregation("contextMenu", oMenu);

        if (oPanel._type != 1) {
            var oMenuItem = new sas.hc.ui.unified.MenuItem({
            	id: oPanel.sId + "_NotMenuItem",
                text: sas.fscf.rb.getText("rules.rulesPage.guidedView.grid.not.txt"),
                icon: (oPanel._bNot) ? "sap-icon://hc/checkmark" : "sap-icon://hc/blank"
            });
            oMenuItem.attachSelect(function() {
            	if (oPanel._bNot) {
            		_this.setNot(false, oPanel);
            	} else {
            		_this.setNot(true, oPanel);
            	}
            	_this.getForm().negateCondition(oPanel._pId);
            	var ret = _this.getForm().findCondition(oPanel._pId);
            	if (oPanel._filtering) {
                	_this.updatePanel(oPanel, _this.getListBoxForPanel(oPanel), ret.exp, false, function() {
                    	_this.getRelatedRows().update();
                    	_this.updateCounts();
                	});
            	} else {
                	_this.getRelatedRows().update();
                	_this.updateCounts();
            	}
            });
    		// set name attribute
        	oMenuItem.onAfterRendering = function() {
            	if (sas.hc.ui.unified.MenuItem.prototype.onAfterRendering) {
            		sas.hc.ui.unified.MenuItem.prototype.onAfterRendering.apply(this);
            	}
            	// must be set after rendering when the dom ref will exist
            	this.getDomRef().setAttribute("name", "NotMenuItem");
        	};
            oMenu.addItem(oMenuItem);
            oPanel._oNotMenuItem = oMenuItem;
        }
        
        var oMenuItem2 = new sas.hc.ui.unified.MenuItem({
        	id: oPanel.sId + "_RemoveMenuItem",
            text: sas.fscf.rb.getText("rules.rulesPage.guidedView.grid.remove.txt"),
            startsSection: (oPanel._type != 1)
        });
        oMenuItem2.attachSelect(function() {
            _this.removePanel(oPanel, _this.getParentHLayoutForPanel(oPanel), true);
        });
		// set name attribute
    	oMenuItem2.onAfterRendering = function() {
        	if (sas.hc.ui.unified.MenuItem.prototype.onAfterRendering) {
        		sas.hc.ui.unified.MenuItem.prototype.onAfterRendering.apply(this);
        	}
        	// must be set after rendering when the dom ref will exist
        	this.getDomRef().setAttribute("name", "RemoveMenuItem");
    	};
        oMenu.addItem(oMenuItem2);
    },
    addPanel: function(id, parentHLayout, parentId, fieldType, fieldId, variableType, operator, value, min, max, from, to, g_from, g_to, g_by, not, overrideGroupBy, successCallback, failureCallback) {
    	this.customSetBusy(true);

        var _this = this;
    	_this.hideCenteredMessage(_this.sId);
    	var type = 0;
    	if (variableType == "Numeric" || variableType == "Currency") {
    		type = 1; //range
    	}

    	if (type == 1) {
            if ((from == undefined) || (from == null) || isNaN(from)) {
           		if ((min == undefined) || (min == null)) {
               		from = 0;
               	} else {
       				from = min + Math.round(Math.abs(max - min) * 0.25);
       				from = Math.round(from * 100) / 100;	// limit to at most 2 decimal places
               	}
            }
            if ((to == undefined) || (to == null) || isNaN(to)) {
           		if ((max == undefined) || (max == null)) {
               		to = 1000;
               	} else {
                   	to = max - Math.round(Math.abs(max - min) * 0.25);
       				to = Math.round(to * 100) / 100;	// limit to at most 2 decimal places
               	}
            }
            
    		if ((g_from == undefined) || (g_from == null) || isNaN(g_from)) {
           		if ((min == undefined) || (min == null)) {
               		g_from = 0;
               	} else {
               		g_from = Math.floor(min / 100) * 100;		// nearest number below ending in 2 zeros
               	}
            }
            if ((g_to == undefined) || (g_to == null) || isNaN(g_to)) {
           		if ((max == undefined) || (max == null)) {
               		g_to = 1000;
               	} else {
               		g_to = Math.ceil(max / 100) * 100;		// nearest number above ending in 2 zeros
               		if (g_from == g_to) {
               			g_to = g_from + 1000;
               		}
               	}
            }
            if ((g_by == undefined) || (g_by == null) || isNaN(g_by)) {
           		if ((max == undefined) || (max == null)) {
               		g_by = 100;
               	} else {
                   	g_by = Math.round(Math.abs(g_to - g_from) / sas.fscf.defaultNoOfGroups);
                   	if (g_by <= 0) {
                   		g_by == 100;
                   	}
               	}
            }
    	}
    	
    	//if using a equal or in operator, the query needs to be blank so that all transactions are returned
    	//then the mergeValueIntoData function does the real work of selecting the relevant transactions
    	var q = "";
    	if( sas.fscf.isFilteringOperator( operator ) ) {
		    q = sas.fscf.getQueryForOperator(operator, fieldType, value, variableType);
    	}
    	
		var obj = sas.fscf.getQueryObject((_this.isExplore() ? "facets" : "risk"), (_this.isExplore() ? "esdb" : null), q, fieldType, variableType, from, to, g_from, g_to, g_by);
        sas.ajax({url:obj.url, type:"POST", data:obj.data, headers:sas.fscf.getAjaxHeaders()})
          .done(function(oData){
        	var data = null;
        	if (oData && oData[Object.keys(oData)[0]]) {
            	if (oData[Object.keys(oData)[0]]['children']) {
            		data = oData[Object.keys(oData)[0]]['children'][0];
            	}
        	} else {
    	    	_this.customSetBusy(false);
            	_this.showCenteredMessage(_this.sId, sap.ui.core.MessageType.Error, _this.getServerErrorMessage(), null);
                if (failureCallback) {
                	failureCallback.call();
                }
            	return;
        	}
        	if (_this.isExplore() && (variableType == "Numeric" || variableType == "Currency")) {
        		data = _this.reorderData(obj.data, data);
        	}
        	if ( sas.fscf.isEqualOrInOperator( operator ) ) {
            	data = _this.mergeValueIntoData(data, value, variableType);
        	}

        	var model = new sap.ui.model.json.JSONModel(data);
        	var pId = id;
        	if (pId == null || pId == undefined) {
        		pId = _this.getNextId(parentHLayout, parentId);
        	}

        	var oPanelContent = null;
    		var oPanel = new sas.hc.m.Panel({
    			expandable: false,
    			content: [
    			]
    		});
    		oPanel._pId = pId;
    		oPanel._type = 0;
    		oPanel._fieldId = fieldId;
    		oPanel._fieldType = fieldType;
    		oPanel._variableType = variableType;
    		oPanel._operator = operator;
    		oPanel._value = value;
    		oPanel._searchable = null;
    		oPanel._groupBy = false;
    		oPanel._from = from;
    		oPanel._to = to;
    		oPanel._g_from = g_from;
    		oPanel._g_to = g_to;
    		oPanel._g_by = g_by;
           	oPanel._filtering = sas.fscf.isFilteringOperator( operator );
    		if (type == 1) {
    			oPanel._type = 1;
    			oPanel.addStyleClass("range");
    			oPanel._searchable = false;
    			if (!overrideGroupBy) {
        			oPanel._groupBy = true;
        			oPanel.addStyleClass("groupBy");
    			}
    		}
    		if (not) {
    			_this.setNot(true, oPanel);
    		}
			if (sas.fscf.isValuelessOperator(operator)) {	// add valueless class if it is a valueless operator
    			oPanel.addStyleClass("valueless");
			}
    		// set name attribute
        	oPanel.onAfterRendering = function() {
            	if (sas.hc.m.Panel.prototype.onAfterRendering) {
            		sas.hc.m.Panel.prototype.onAfterRendering.apply(this);
            	}
            	// must be set after rendering when the dom ref will exist
            	this.getDomRef().setAttribute("name", this._pId);
        	};

            var oListBox = new sap.ui.commons.ListBox({
            	id: oPanel.sId + "_ListBox",
              	allowMultiSelect: !(oPanel._type == 1 && parentHLayout != _this.getContent()[0]),	// range lists in groups must be single select; others are multi-select
               	displayIcons: false,
               	displaySecondaryValues: true,
               	secondaryValueTextAlign: sap.ui.core.TextAlign.End,
               	enabled: sas.fscf.isEqualOrInOperator( oPanel._operator ) || sas.fscf.isNumericOperator( oPanel._operator ) || ( oPanel._operator == undefined )
            });
            oListBox.addStyleClass("cfGridCellListBox");

            oListBox.setModel(model);
            _this.bindAggregationListBox(oListBox, oPanel);

            oListBox._fieldId = fieldId;
            oListBox.attachSelect(_this, _this.commonListBoxHandleSelect);

    		// set name attribute and adjust classes, visibility and enablement
        	oListBox.onAfterRendering = function() {
               	if (sap.ui.commons.ListBox.prototype.onAfterRendering) {
               		sap.ui.commons.ListBox.prototype.onAfterRendering.apply(this);
               	}
            	// must be set after rendering when the dom ref will exist
            	this.getDomRef().setAttribute("name", "ListBox");

            	_this.commonListBoxOnAfterRendering(this, oPanel, oPageUpButton, oPageDownButton);
        	};

        	//needs to be done once oPanel and oListBox exist
			if( sas.fscf.isLookupListOperator( operator ) ) {
        		_this.mergeLookupListIntoData( data, oPanel, oListBox, "" );
        	}
        	
            var oSearch = new sas.hc.m.SearchField({
            	id: oPanel.sId + "_SearchField",
                placeholder: sas.fscf.rb.getText("rules.rulesPage.guidedView.search.txt"),
                width: "100%"
            });
            oSearch.addStyleClass("cfGridCellSearchField");
            oSearch.attachSearch(function(oEvent){
            	_this.customSetBusy(true);
            	_this.hideCenteredMessage(_this.sId);
            	
         		var selItems = oListBox.getSelectedItems();
         		var selIndices = oListBox.getSelectedIndices();

         		var q = "(" + fieldType + ":*" + sas.fscf.escapeSafeValue(oEvent.mParameters.query) + "*)"; 
        		var obj = sas.fscf.getQueryObject((_this.isExplore() ? "facets" : "risk"), (_this.isExplore() ? "esdb" : null), encodeURIComponent(q), fieldType, oPanel._variableType, oPanel._from, oPanel._to, oPanel._g_from, oPanel._g_to, oPanel._g_by);
                sas.ajax({url:obj.url, type:"POST", data:obj.data, headers:sas.fscf.getAjaxHeaders()})
                .done(function(oData){
      	            var data = null;
      	            if (oData && oData[Object.keys(oData)[0]]) {
      	           	    if (oData[Object.keys(oData)[0]]['children']) {
      	           		    data = oData[Object.keys(oData)[0]]['children'][0];
      	           	    } else {
      	           	    	data = {"children":[], "name": fieldType, "size": 0};
      	           	    }
      	            } else {
      	        	    _this.customSetBusy(false);
      	        	    _this.showCenteredMessage(_this.sId, sap.ui.core.MessageType.Error, _this.getServerErrorMessage(), null);
      	        	    return;
      	            }

      	            if( !sas.fscf.isLookupListOperator( oPanel._operator ) ) {

      	            	// merge what was selected before the search
      	            	var key, liData;
      	            	for (var j = 0; j < selItems.length; j++) {
      	            		key = selItems[j].getKey();
      	            		// list could be sorted, so factor in index from binding
      	            		liData = oListBox.getModel().getData().children[oListBox.getBinding("items").aIndices[selIndices[j]]];
      	            		data = _this.mergeValueIntoData(data, key, oPanel._variableType, liData);
      	            	}
                  	
      	            	var model = new sap.ui.model.json.JSONModel(data);
        	            oListBox.setModel(model);
        	            
        	            // re-select what was selected before the re-bind
        	            for (var j = 0; j < selItems.length; j++) {
        	            	key = selItems[j].getKey();
        	            	for (var k = 0; k < oListBox.getItems().length; k++) {
        	            		if (oListBox.getItems()[k].getKey() == key) {
        	            			_this.selectListBoxItem(oListBox, k);
        	            			break;
        	            		}
        	            	}
        	            }
        	            
        	            _this.updateCountsForSearchPanel(oPanel, q);

  					} else {
  						_this.mergeLookupListIntoData( data, oPanel, oListBox, q );
  					}
					
       	    	    _this.customSetBusy(false);	  	    	  
                }).fail(function(oObj,textStatus){
        	    	_this.customSetBusy(false);
                });         		
            });
    		// set name attribute
        	oSearch.onAfterRendering = function() {
            	if (sas.hc.m.SearchField.prototype.onAfterRendering) {
            		sas.hc.m.SearchField.prototype.onAfterRendering.apply(this);
            	}
            	// must be set after rendering when the dom ref will exist
            	this.getDomRef().setAttribute("name", "SearchField");
        	};

   	        var oPageUpButton = new sas.hc.m.Button({
            	id: oPanel.sId + "_PageUpButton",
   			  	icon: 'sap-icon://hc/arrowSmallUpBtn',
   			   	tooltip: sas.fscf.rb.getText("rules.rulesPage.guidedView.grid.pageUp.txt"),
   			   	width: "100%",
   			   	enabled: false,
   			   	press: function() {
   			   		var lbox = _this.getListBoxForPanel(oPanel);
  		    		var lb = document.getElementById(lbox.sId);
   		    		var lbi = document.getElementById(lbox.getItems()[0].sId);
   		    		lb.scrollTop = Math.max(lb.scrollTop - (Math.floor(lb.offsetHeight / lbi.offsetHeight) * lbi.offsetHeight), 0);
   		    		lb.scrollTop -= lb.scrollTop % lbi.offsetHeight;
   		    	    lbox.removeStyleClass("topBorder");
   		    		_this.updatePageButtonEnablement(lbox, oPageUpButton, oPageDownButton);
   		    	}
   		    });
   	        oPageUpButton.addStyleClass("cfGridCellPageButton");
    		// set name attribute
   	        oPageUpButton.onAfterRendering = function() {
            	if (sas.hc.m.Button.prototype.onAfterRendering) {
            		sas.hc.m.Button.prototype.onAfterRendering.apply(this);
            	}
            	// must be set after rendering when the dom ref will exist
            	this.getDomRef().setAttribute("name", "PageUpButton");
        	};

   	        var oPageDownButton = new sas.hc.m.Button({
            	id: oPanel.sId + "_PageDownButton",
   		    	icon: 'sap-icon://hc/arrowSmallDownBtn',
   		    	tooltip: sas.fscf.rb.getText("rules.rulesPage.guidedView.grid.pageDown.txt"),
   		    	width: "100%",
   		    	press: function() {
   			   		var lbox = _this.getListBoxForPanel(oPanel);
   		    		var lb = document.getElementById(lbox.sId);
   		    		var lbi = document.getElementById(lbox.getItems()[0].sId);
   		    		lb.scrollTop = Math.min(lb.scrollTop + (Math.floor(lb.offsetHeight / lbi.offsetHeight) * lbi.offsetHeight),
   		    								lb.children[0].offsetHeight - lb.offsetHeight);
   		    		if (lb.scrollTop % lbi.offsetHeight != 0) {
   		    	        lbox.addStyleClass("topBorder");
   		    		} else {
   		    	        lbox.removeStyleClass("topBorder");
   		    		}
   		    		// prevent slight scroll down of parent containers that happens when bottom is reached
   		    		if (lb.scrollTop == lb.children[0].offsetHeight - lb.offsetHeight) {
   		    			setTimeout(function () {
   		    	    		lb.parentElement.parentElement.scrollTop = 0;
   		    	    		lb.parentElement.parentElement.parentElement.scrollTop = 0;
   		    			}, 100);
   		    		}
   		    		_this.updatePageButtonEnablement(lbox, oPageUpButton, oPageDownButton);
   		    	}
   			});
   	        oPageDownButton.addStyleClass("cfGridCellPageButton");
    		// set name attribute
   	        oPageDownButton.onAfterRendering = function() {
            	if (sas.hc.m.Button.prototype.onAfterRendering) {
            		sas.hc.m.Button.prototype.onAfterRendering.apply(this);
            	}
            	// must be set after rendering when the dom ref will exist
            	this.getDomRef().setAttribute("name", "PageDownButton");
        	};

   	        var aVLContent = [
                   oSearch,
                   oPageUpButton,
                   oListBox,
                   oPageDownButton
            ];

        	if (type == 1) {
        		var text = sas.fscf.rb.getText("rules.rulesPage.guidedView.grid.min.fmt.txt", ((min == undefined) || (min == null)) ? " " : sas.fscf.floatFormatter.format(min));
        		var oMinLabel = new sas.hc.m.Label({
                	id: oPanel.sId + "_MinLabel",
        		    text: text,
        		    tooltip: text
        		});
        		text = sas.fscf.rb.getText("rules.rulesPage.guidedView.grid.max.fmt.txt", ((max == undefined) || (max == null)) ? " " : sas.fscf.floatFormatter.format(max));
        		var oMaxLabel = new sas.hc.m.Label({
                	id: oPanel.sId + "_MaxLabel",
        		    text: text,
        		    tooltip: text
        		});

                var oRangeLabels = new sas.hc.ui.commons.layout.HorizontalLayout({
                	id: oPanel.sId + "_RangeLabels",
                    content: [
                        oMinLabel,
                        oMaxLabel
                    ]
                });
                oRangeLabels.addStyleClass("cfGridCellRangeLabels");

        		var oFromInput = new sas.hc.m.Input({
                	id: oPanel.sId + "_FromInput",
                    type: sap.m.InputType.Number,
                    value: sas.fscf.floatFormatter.format(g_from),
                    placeholder: sas.fscf.rb.getText("rules.rulesPage.guidedView.grid.from.txt")
                });
        		// set initial size and name attribute
        		oFromInput.onAfterRendering = function() {
                	if (sas.hc.m.Input.prototype.onAfterRendering) {
                		sas.hc.m.Input.prototype.onAfterRendering.apply(this);
                	}
        			$("#" + this.sId).find("input").attr("size", 8);
                	// must be set after rendering when the dom ref will exist
                	this.getDomRef().setAttribute("name", "FromInput");
        		};
        		var oToInput = new sas.hc.m.Input({
                	id: oPanel.sId + "_ToInput",
                    type: sap.m.InputType.Number,
                    value: sas.fscf.floatFormatter.format(g_to),
                    placeholder: sas.fscf.rb.getText("rules.rulesPage.guidedView.grid.to.txt")
                });
        		// set initial size and name attribute
        		oToInput.onAfterRendering = function() {
                	if (sas.hc.m.Input.prototype.onAfterRendering) {
                		sas.hc.m.Input.prototype.onAfterRendering.apply(this);
                	}
        			$("#" + this.sId).find("input").attr("size", 8);
                	// must be set after rendering when the dom ref will exist
                	this.getDomRef().setAttribute("name", "ToInput");
        		};

        		var handleInputChange = function (oEvent) {
        			_this.updateRangesAfterInputChange(oPanel._pId, true);
        		};
                oFromInput.attachChange(handleInputChange);
                oToInput.attachChange(handleInputChange);

                var oRangeInputs = new sas.hc.ui.commons.layout.HorizontalLayout({
                	id: oPanel.sId + "_RangeInputs",
                    content: [
                        oFromInput,
                        oToInput
                    ]
                });
                oRangeInputs.addStyleClass("cfGridCellRangeInputs");

                if (overrideGroupBy) {
                	oFromInput.setValue(sas.fscf.floatFormatter.format(from));
                	oToInput.setValue(sas.fscf.floatFormatter.format(to));
                }
                
        		var oGroupSizeLabel = new sas.hc.m.Label({
                	id: oPanel.sId + "_GroupSizeLabel",
        		    text: sas.fscf.rb.getText("rules.rulesPage.guidedView.grid.groupSize.txt")
        		});
        		var oGroupSizeInput = new sas.hc.m.Input({
                	id: oPanel.sId + "_GroupSizeInput",
                    type: sap.m.InputType.Number,
                    value: sas.fscf.floatFormatter.format(g_by),
                    placeholder: sas.fscf.rb.getText("rules.rulesPage.guidedView.grid.size.txt")
                });
        		// set initial size and name attribute
        		oGroupSizeInput.onAfterRendering = function() {
                	if (sas.hc.m.Input.prototype.onAfterRendering) {
                		sas.hc.m.Input.prototype.onAfterRendering.apply(this);
                	}
        			$("#" + this.sId).find("input").attr("size", 8);
                	// must be set after rendering when the dom ref will exist
                	this.getDomRef().setAttribute("name", "GroupSizeInput");
        		};

        		var handleGroupSizeInputChange = function (oEvent) {
        			_this.updateRangesAfterInputChange(oPanel._pId, true);
        		};
        		oGroupSizeInput.attachChange(handleInputChange);

                var oGroupSizeItems = new sas.hc.ui.commons.layout.HorizontalLayout({
                	id: oPanel.sId + "_GroupSizeItems",
                    content: [
                        oGroupSizeLabel,
                        oGroupSizeInput
                    ]
                });
                oGroupSizeItems.addStyleClass("cfGridCellGroupSizeItems");
                
                aVLContent.unshift(oGroupSizeItems); //prepend to beginning
                aVLContent.unshift(oRangeInputs);    //prepend to beginning
                aVLContent.unshift(oRangeLabels);    //prepend to beginning                	

                var oRangeListBox = new sap.ui.commons.ListBox({
                	id: oPanel.sId + "_RangeListBox",
                  	allowMultiSelect: (parentHLayout == _this.getContent()[0]),	// range lists in groups must be single select; others are multi-select
                   	displayIcons: false, //true,
                   	displaySecondaryValues: true,
                   	secondaryValueTextAlign: sap.ui.core.TextAlign.End
                });
                oRangeListBox.addStyleClass("cfGridCellListBox");

                oRangeListBox.setModel(model);
                _this.bindAggregationRangeListBox(oRangeListBox, oPanel);

                if (overrideGroupBy) {
                    aVLContent.splice(5, 1, oRangeListBox); //swap list boxes
                }
	
        		// set name attribute and adjust classes, visibility and enablement
            	oRangeListBox.onAfterRendering = function() {
                   	if (sap.ui.commons.ListBox.prototype.onAfterRendering) {
                   		sap.ui.commons.ListBox.prototype.onAfterRendering.apply(this);
                   	}
                	// must be set after rendering when the dom ref will exist
                	this.getDomRef().setAttribute("name", "RangeListBox");
	
                	_this.commonListBoxOnAfterRendering(this, oPanel, oPageUpButton, oPageDownButton);
            	};
	
                oRangeListBox.attachSelect(_this, _this.commonListBoxHandleSelect);
        	}
        	
       		var oOperatorSelect = new sas.hc.m.Select({
	           	id: oPanel.sId + "_OperatorSelect",
	           	width: "100%"
	   		});

            var operators;
            if (sas.fscf.isMultivalueOperator(oPanel._operator)) {
            	operators = sas.fscf.getInOperators();
            } else {
            	operators = sas.fscf.getEqualOperators();
            }
            
            if (oPanel._variableType == "Character") {
            	operators = operators.concat( sas.fscf.getFilteringOperators(), sas.fscf.getLookupListOperators() );
            } else {
               	operators = operators.concat( sas.fscf.getMissingOperators() );
            }
            operators = sas.fscf.filterForPositiveOperators( operators );
            
            var oSelectItemI;
            var key;
            for (var i = 0; i < operators.length; i++) {
               	key = oPanel._bNot ? sas.fscf.getNegativeOperator(operators[i]): operators[i];
               	oSelectItemI = new sas.hc.ui.core.Item({
               		key: key,
                  	text: sas.fscf.getLocalizedOperatorVerbose(key)
               	});
               	oOperatorSelect.addItem(oSelectItemI);
               	if (oPanel._operator == key) {
               		oOperatorSelect.setSelectedKey(key);
               	}
            }
            oOperatorSelect.attachChange(function(oEvent) {
                _this.updateOperator(oPanel, this.getSelectedKey());
                
                if (!oPanel._filtering) {
  				  if (oPanel._variableType == "Numeric" || oPanel._variableType == "Currency") {
  	        		  oPanel.addStyleClass("searchable");
  	        		  oPanel.removeStyleClass("searchable");
  				  } else {
  					  	if 	(oPanel._searchable) {
  		        		  	oPanel.removeStyleClass("searchable");
  		        		 	oPanel.addStyleClass("searchable");
  					  	}
  				  	}
                } else {
          		  	oPanel.addStyleClass("searchable");
          		  	oPanel.removeStyleClass("searchable");
          	  	}
            });
            
            oOperatorSelect.addStyleClass("cfGridCellOperatorSelect");
        		
       		var oOperatorInput;
        		
           	if ($.isArray(value) && !sas.fscf.isLookupListOperator( oPanel._operator ) ) {
           		oOperatorInput = _this.createOperatorMultiInput(oPanel, value);                	
           	} else if (!sas.fscf.isLookupListOperator( oPanel._operator )) {
           		oOperatorInput = _this.createOperatorInput(oPanel, value);                	
            } else {
           		oOperatorInput = _this.createOperatorComboBoxInput(oPanel, value);
           	}

            if (type == 0) {
                aVLContent.splice(1, 0, oOperatorInput);	//insert after search field
                aVLContent.splice(1, 0, oOperatorSelect);	//insert after search field
        	}

            var oPanelHeaderToolbar = new sap.m.Toolbar({
            	id: oPanel.sId + "HeaderToolbar",
            	content: [
          	      		new sap.m.Label({
        	                text: fieldType
        	    		}).addStyleClass("cfGridPanelHdrLabel")
            	]
            }).addStyleClass("cfGridPanelHdrTB");
        	if (type == 1) {
        		var oButton = new sas.hc.m.Button({
                	id: oPanel.sId + "_GroupByButton",
   		    		icon: 'sap-icon://hc/groupBy',
   		    		tooltip: sas.fscf.rb.getText("rules.rulesPage.guidedView.grid.groupBy.txt"),
   		    		press: function() {
   		    			_this.toggleGroupBy(oPanel);
   		    		}
   				});
        	    oButton.addStyleClass("cfGridPanelHdrButton");
        		oButton.addStyleClass("groupBy");
        		if (!overrideGroupBy) {
            		oButton.addStyleClass("toggled");
        		}
        		// set name attribute
            	oButton.onAfterRendering = function() {
                	if (sas.hc.m.Button.prototype.onAfterRendering) {
                		sas.hc.m.Button.prototype.onAfterRendering.apply(this);
                	}
                	// must be set after rendering when the dom ref will exist
                	this.getDomRef().setAttribute("name", "GroupByButton");
            	};
            	oPanelHeaderToolbar.addContent(oButton);
        	}
		    var oButton2 = new sas.hc.m.Button({
               	id: oPanel.sId + "_CloseButton",
	    		icon: 'sap-icon://hc/close',
	    		tooltip: sas.fscf.rb.getText("rules.rulesPage.guidedView.grid.remove.txt"),
	    		press: function() {
	    			_this.removePanel(oPanel, parentHLayout, true);
	    		}
			})
		    oButton2.addStyleClass("cfGridPanelHdrButton");
			// set name attribute
	    	oButton2.onAfterRendering = function() {
	        	if (sas.hc.m.Button.prototype.onAfterRendering) {
	        		sas.hc.m.Button.prototype.onAfterRendering.apply(this);
	        	}
	        	// must be set after rendering when the dom ref will exist
	        	this.getDomRef().setAttribute("name", "CloseButton");
	    	};
        	oPanelHeaderToolbar.addContent(oButton2);
        	if (oPanel._bNot) {
                oPanelHeaderToolbar.insertContent(sas.icons.pool.createControlByURI("sap-icon://hc/cancel"));                    
            } 
        	oPanel.setHeaderToolbar(oPanelHeaderToolbar);

        	_this.updatePanelMenu(oPanel);
        	
		   	var oVertLayout = new sas.hc.ui.commons.layout.VerticalLayout({
	    	    id: oPanel.sId + "_VertLayout",
                content: aVLContent
            });
   	    	oPanel.addContent(oVertLayout);

            parentHLayout.addContent(oPanel);

            if (_this._anySelected || _this._anyFiltered) {
            	_this.updateCounts();
            } else {
        		_this.setPopulationIndicator(_this._overallTotalPopulation, _this._overallCurrentPopulation);
            }

	    	_this.customSetBusy(false);

            if (successCallback) {
            	successCallback.call(oPanel);  //oPanel will be this inside the successCallback function
            }
        }).fail(function(oObj,textStatus){
	    	_this.customSetBusy(false);
        	_this.showCenteredMessage(_this.sId, sap.ui.core.MessageType.Error, _this.getServerErrorMessage(), null);
            if (failureCallback) {
            	failureCallback.call();
            }
        });
    },
    bindAggregationListBox: function(oListBox, oPanel) {
    	var _this = this;
    	oListBox.destroyAggregation("items");
    	oListBox._maxfullpct = 0;
    	var text, addText, tooltipText;
        oListBox.bindAggregation("items", {
           	path: "/children",
           	startIndex: (((oPanel._type != 1) || (isNaN(oPanel._from) && isNaN(oPanel._to))) ? 0 : ((oPanel._from == oPanel._to) ? 5 : ((Math.abs(oPanel._to - oPanel._from) == 1) ? 9 : 10))),
            factory: function(sId, oContext) {
            	text = _this.getDisplayNameFromName(oContext.getProperty("name"));
            	if (_this._bPercentages) {
           			addText = sas.fscf.percentFormatter.format(oContext.getProperty("pct") / 100);
       				if (oContext.getProperty("fullpct") == -1) {
               			tooltipText = text + "  --  " + addText;
       				} else if ((oContext.getProperty("fullpct") == undefined) || (oContext.getProperty("fullpct") < oContext.getProperty("pct"))) {
       					tooltipText = text + "  --  " + sas.fscf.rb.getText("rules.rulesPage.guidedView.population.xofy.fmt.txt", [addText, addText]);
       				} else {
       					tooltipText = text + "  --  " + sas.fscf.rb.getText("rules.rulesPage.guidedView.population.xofy.fmt.txt", [addText, sas.fscf.percentFormatter.format(oContext.getProperty("fullpct") / 100)]);
       				}
            	} else {
       				addText = sas.fscf.floatFormatter.format(oContext.getProperty("size"));
       				if (oContext.getProperty("fullsize") == -1) {
               			tooltipText = text + "  --  " + addText;
       				} else if ((oContext.getProperty("fullsize") == undefined) || (oContext.getProperty("fullsize") < oContext.getProperty("size"))) {
               			tooltipText = text + "  --  " + sas.fscf.rb.getText("rules.rulesPage.guidedView.population.xofy.fmt.txt", [addText, addText]);
       				} else {
               			tooltipText = text + "  --  " + sas.fscf.rb.getText("rules.rulesPage.guidedView.population.xofy.fmt.txt", [addText, sas.fscf.floatFormatter.format(oContext.getProperty("fullsize"))]);
       				}
            	}
                var li = new sap.ui.core.ListItem(sId, {
                      key: _this.getKeyFromName(oContext.getProperty("name")),
                      text: text,
                      additionalText: addText,
                      tooltip: tooltipText
                });
                li._pct = (oContext.getProperty("pct") != undefined) ? oContext.getProperty("pct") / 100 : 0;
                li._fullpct = (oContext.getProperty("fullpct") != undefined && oContext.getProperty("fullpct") != -1 && oContext.getProperty("fullpct") >= oContext.getProperty("pct")) ? oContext.getProperty("fullpct") / 100 : li._pct;
                if (li._fullpct != undefined) {
                    oListBox._maxfullpct = Math.max(oListBox._maxfullpct, li._fullpct);
                } else {
                    oListBox._maxfullpct = Math.max(oListBox._maxfullpct, li._pct);
                }
                li._fraudCount = (oContext.getProperty("subSize")) ? oContext.getProperty("subSize") : 0;
                li._riskLevel = oContext.getProperty("scoreLevel");
                return li;
            },
           	sorter: (oPanel._type != 1) ? [		// numeric lists don't get sorted
           	     _this.getSelSorter(),   // force selected ones always to the top
                 _this.getSorter(oPanel._variableType)
           	] : null
        });
    },
    bindAggregationRangeListBox: function(oRangeListBox, oPanel) {
    	var _this = this;
		oRangeListBox.destroyAggregation("items");
    	oRangeListBox._maxfullpct = 0;
    	if (!(isNaN(oPanel._from) && isNaN(oPanel._to))) {
        	var text, addText, tooltipText;
            oRangeListBox.bindAggregation("items", {
               	path: "/children",
               	startIndex: 0,
               	length: ((oPanel._from == oPanel._to) ? 5 : ((Math.abs(oPanel._to - oPanel._from) == 1) ? 9 : 10)),
                factory: function(sId, oContext) {
                	var i = parseInt(oContext.sPath.substr(oContext.sPath.lastIndexOf("/") + 1)); 
                	text = _this.getDisplayNameFromName(oContext.getProperty("name"));
                	if (_this._bPercentages) {
               			addText = sas.fscf.percentFormatter.format(oContext.getProperty("pct") / 100);
           				if (oContext.getProperty("fullpct") == -1) {
                   			tooltipText = text + "  --  " + addText;
           				} else if ((oContext.getProperty("fullpct") == undefined) || (oContext.getProperty("fullpct") < oContext.getProperty("pct"))) {
           					tooltipText = text + "  --  " + sas.fscf.rb.getText("rules.rulesPage.guidedView.population.xofy.fmt.txt", [addText, addText]);
           				} else {
           					tooltipText = text + "  --  " + sas.fscf.rb.getText("rules.rulesPage.guidedView.population.xofy.fmt.txt", [addText, sas.fscf.percentFormatter.format(oContext.getProperty("fullpct") / 100)]);
           				}
                	} else {
           				addText = sas.fscf.floatFormatter.format(oContext.getProperty("size"));            				
           				if (oContext.getProperty("fullsize") == -1) {
                   			tooltipText = text + "  --  " + addText;
           				} else if ((oContext.getProperty("fullsize") == undefined) || (oContext.getProperty("fullsize") < oContext.getProperty("size"))) {
                   			tooltipText = text + "  --  " + sas.fscf.rb.getText("rules.rulesPage.guidedView.population.xofy.fmt.txt", [addText, addText]);
           				} else {
                   			tooltipText = text + "  --  " + sas.fscf.rb.getText("rules.rulesPage.guidedView.population.xofy.fmt.txt", [addText, sas.fscf.floatFormatter.format(oContext.getProperty("fullsize"))]);
           				}
                	}
                    var li = new sap.ui.core.ListItem(sId, {
                        key: _this.getKeyFromName(oContext.getProperty("name")),
                  	    icon: "resources/sas/fscf/views/range" + ((oPanel._from == oPanel._to) ? "1" : "2") + "-" + (i + ((Math.abs(oPanel._to - oPanel._from) == 1 && i >= 6) ? 2 : 1)) + ".png",
                        text: text,
                        additionalText: addText,
                        tooltip: tooltipText
                    });
                    li._pct = (oContext.getProperty("pct") != undefined) ? oContext.getProperty("pct") / 100 : 0;
                    li._fullpct = (oContext.getProperty("fullpct") != undefined && oContext.getProperty("fullpct") != -1 && oContext.getProperty("fullpct") >= oContext.getProperty("pct")) ? oContext.getProperty("fullpct") / 100 : li._pct;
                    if (li._fullpct != undefined) {
                        oRangeListBox._maxfullpct = Math.max(oRangeListBox._maxfullpct, li._fullpct);
                    } else {
                        oRangeListBox._maxfullpct = Math.max(oRangeListBox._maxfullpct, li._pct);
                    }
                    li._fraudCount = (oContext.getProperty("subSize")) ? oContext.getProperty("subSize") : 0;
                    li._riskLevel = oContext.getProperty("scoreLevel");
                    return li;
                }
            });
    	}
    },
    updatePanel: function(oPanel, lbox, exp, bReset, successCallback) {    	
    	if ($.type(oPanel) === 'string') {
    		oPanel = sap.ui.getCore().byId(oPanel);
    	}
    	if (!oPanel) {
    		return;
    	}
    	
    	if( !exp ) {
			bReset = true;
    	}
    	
    	this.customSetBusy(true);
        var _this = this;
    	_this.hideCenteredMessage(_this.sId);
    	var fieldType;
    	if (exp) {
    		fieldType = exp.fieldName;
    	}
    	var value;
    	if (exp) {
        	value = (sas.fscf.isMultivalueOperator(exp.operator)) ? exp.values : exp.value;
    	}
    	
    	//if using a equal or in operator, the query needs to be blank so that all transactions are returned
    	//then the mergeValueIntoData function does the real work of selecting the relevant transactions
    	var q = "";
    	if( !bReset ) {
    		//if bReset true then q should be just ""
    		if( sas.fscf.isFilteringOperator( exp.operator ) ) {
    			q = sas.fscf.getQueryForOperator( exp.operator, fieldType, value, exp.fieldType);
    		}
    	}
    	
		var obj = sas.fscf.getQueryObject((_this.isExplore() ? "facets" : "risk"), (_this.isExplore() ? "esdb" : null), q, fieldType, oPanel._variableType, oPanel._from, oPanel._to, oPanel._g_from, oPanel._g_to, oPanel._g_by);
        sas.ajax({url:obj.url, type:"POST", data:obj.data, headers:sas.fscf.getAjaxHeaders()})
          .done(function(oData){
	          var data = null;
	          if (oData && oData[Object.keys(oData)[0]]) {
	           	  if (oData[Object.keys(oData)[0]]['children']) {
	           		  data = oData[Object.keys(oData)[0]]['children'][0];
	           	  } else {
	           		  data = [];
	           		  data.children = [];
		          }
	          } else {
	        	  _this.customSetBusy(false);
	        	  _this.showCenteredMessage(_this.sId, sap.ui.core.MessageType.Error, _this.getServerErrorMessage(), null);
	        	  return;
	          }
	          oPanel._filtering = sas.fscf.isFilteringOperator(oPanel._operator);
	          if (!oPanel._filtering) {		// add search bar if needed
	        	  if( sas.fscf.isEqualOrInOperator( oPanel._operator ) || oPanel._type == 1 ) {
      		  		  lbox.setEnabled(true);
      	  		  } else {
      	  			  lbox.setEnabled(false);
      	  		  }
				  if (oPanel._variableType == "Numeric" || oPanel._variableType == "Currency") {
	        		  oPanel.addStyleClass("searchable");
	        		  oPanel.removeStyleClass("searchable");
				  } else {
					  if (oPanel._searchable) {
		        		  oPanel.removeStyleClass("searchable");
		        		  oPanel.addStyleClass("searchable");
					  }
				  }
	          } else {
        		  lbox.setEnabled(false);
        		  oPanel.addStyleClass("searchable");
        		  oPanel.removeStyleClass("searchable");
        	  }
        	  
        	  if ( sas.fscf.isEqualOrInOperator( oPanel._operator ) && oPanel._type == 0 ) {
              	  data = _this.mergeValueIntoData(data, value, oPanel._variableType);
          	  }
          	  if( sas.fscf.isLookupListOperator( oPanel._operator ) ) {
          		  oPanel._value = value;
          		  _this.mergeLookupListIntoData( data, oPanel, lbox, q );
          	  }
        	  if (sas.fscf.isValuelessOperator(oPanel._operator)) {
        		  oPanel.removeStyleClass("valueless");
        		  oPanel.addStyleClass("valueless");        		  
        	  } else {
        		  oPanel.addStyleClass("valueless");        		  
        		  oPanel.removeStyleClass("valueless");
        	  }
        	  
        	  if( oPanel._type == 1 ){
        		  if( exp ) {
        		      if( exp.operator && !isNaN( exp.value ) ) {
    		              // simple numeric
    				      oPanel._value = parseInt( value );
    				      oPanel._to = oPanel._value;
    				      oPanel._from = oPanel._value;
    				      oPanel._operator = exp.operator;
        		      }
        		  }
        		  
        		  if( !isNaN( oPanel._value ) ) {
					//value is just a number and operator is like GT or something
					//need to convert to the format updateRangeValues is looking for
					oPanel._value = _this.getRangeForExp( {
						type: "COMPARE",
						operator: oPanel._operator,
						value: oPanel._value
					} );
					oPanel._operator = sas.fscf.operators.EQUAL;
				  }
    				
    		      // update the range inputs
    			  if( !oPanel._groupBy ) {
    				  if( exp && exp.leftValue != undefined )
    			  		  oPanel._from = exp.leftValue;
    			  	  if( exp && exp.rightValue != undefined )
    			  		  oPanel._to = exp.rightValue;
    			  	    
    				  var fromInput = sap.ui.getCore().byId( oPanel.sId + "_FromInput" );
    				  fromInput.setValue( oPanel._from ); 
    		          var toInput = sap.ui.getCore().byId( oPanel.sId + "_ToInput" );
    		          toInput.setValue( oPanel._to ); 
    		      }
    	      } else {
    	          oPanel._value = value;
    	      }
        	  
	          var model = new sap.ui.model.json.JSONModel(data);
	          lbox.setModel(model);
	          if (oPanel._type == 1) {
	        	  if (oPanel._groupBy) {
	        		  _this.bindAggregationListBox(lbox, oPanel);
	        	  } else {
	        		  _this.bindAggregationRangeListBox(lbox, oPanel);
	        	  }
	          }
	          var other_lbox = _this.getOtherListBoxForPanel(oPanel);
	          if (other_lbox) {
	        	  other_lbox.setModel(model);
	        	  if (oPanel._groupBy) {
	        		  _this.bindAggregationRangeListBox(other_lbox, oPanel);
	        	  } else {
	        		  _this.bindAggregationListBox(other_lbox, oPanel);
	        	  }
	          }

	          if ( sas.fscf.isEqualOrInOperator( oPanel._operator ) && value != undefined && value != null && value != "" && oPanel._type == 0 ) {
		          	// select values if its an equal statement
	        	    var updatedValue;
      	    		var key;
	        	    if ($.isArray(value)) {
	        	    	updatedValue = [];
						for (var j = 0; j < value.length; j++) {
							key = value[j];
							for (var k = 0; k < lbox.getItems().length; k++) {
								if (lbox.getItems()[k].getKey() == key) {
									_this.selectListBoxItem(lbox, k);
									updatedValue[updatedValue.length] = key;
									break;
								}
							}
						}
						if (updatedValue.length == 0) {
							updatedValue = undefined;
						}
	        	    } else {
						key = value;
						for (var k = 0; k < lbox.getItems().length; k++) {
							if (lbox.getItems()[k].getKey() == key) {
								_this.selectListBoxItem(lbox, k);
								updatedValue = key;
								break;
							}
						}	        	    	
	        	    }
	        	    oPanel._value = updatedValue;
	          }

	          if (oPanel._type != 1) {
		          _this.updateOperatorInput(oPanel);
	          }
	          
  	    	  _this.customSetBusy(false);	  	    	  

              if (successCallback) {
            	  successCallback.call(_this, oPanel);  //oPanel will be the first argument to the successCallback function
              }
          }).fail(function(oObj,textStatus){
  	    	_this.customSetBusy(false);
          	_this.showCenteredMessage(_this.sId, sap.ui.core.MessageType.Error, _this.getServerErrorMessage(), null);
          });
    },
    update: function() {
    	this.updateCounts();
    },
    updateOperator: function(oPanel, operator) {
		var previousOperator = oPanel._operator;
		oPanel._operator = operator;
		if (sas.fscf.isValuelessOperator(operator)) {
			oPanel.removeStyleClass("valueless");
			oPanel.addStyleClass("valueless");
		} else {
			oPanel.addStyleClass("valueless");
			oPanel.removeStyleClass("valueless");
		}
		this.updateOperatorInput(oPanel);
		oPanel._filtering = sas.fscf.isFilteringOperator(operator);
		var lbox = this.getListBoxForPanel(oPanel);
	    if (!oPanel._filtering) {		// add search bar if needed
	    	if( sas.fscf.isEqualOrInOperator( oPanel._operator ) || oPanel._type == 1 ) {
	    		lbox.setEnabled(true);
	    	} else {
	    		lbox.setEnabled(false);
	    	}
	    	if (oPanel._variableType == "Numeric" || oPanel._variableType == "Currency") {
	    		oPanel.addStyleClass("searchable");
	    		oPanel.removeStyleClass("searchable");
	    	} else {
	    		if (oPanel._searchable) {
	    			oPanel.removeStyleClass("searchable");
	    			oPanel.addStyleClass("searchable");
	    		}
	    	}
	    } else {
	    	lbox.setEnabled(false);
	    	oPanel.addStyleClass("searchable");
	    	oPanel.removeStyleClass("searchable");
        }
		
		var ret = this.getForm().findCondition(oPanel._pId);
		if (ret.exp) {
			ret.exp.operator = operator;
			if ($.isArray(oPanel._value)) {
				ret.exp.value = oPanel._value[0];
				ret.exp.values = oPanel._value;
			} else {
				ret.exp.value = oPanel._value;
				ret.exp.values = [ oPanel._value ];
			}
		}
		var bBlank = ($.isArray(oPanel._value)) ? (oPanel._value.length == 0) : ((oPanel._value == undefined) || (oPanel._value == null) || (oPanel._value == ""));
		if (bBlank) {
			if (ret.exp) {
				this.getForm().removeCondition(oPanel._pId, ret.exp);
			} else {
				if ( sas.fscf.isMissingOperator( oPanel._operator ) ) {
					ret.exp = {
	   	               		type: "COMPARE",
	   	               		operator: oPanel._operator,
	   	               		fieldId: oPanel._fieldId,
	   	               		fieldName: oPanel._fieldType,
	   	               		fieldType: oPanel._variableType,
	   	               		value: ""
	   	               	};
					this.getForm().addCondition(oPanel._pId, ret.exp);
					bBlank = false;
				}
			}
		} else {
			if (ret.exp) {
				if (ret.exp.type == "RANGE") {
					ret.exp = {
	   	               		type: "COMPARE",
	   	               		operator: oPanel._operator,
	   	               		fieldId: oPanel._fieldId,
	   	               		fieldName: oPanel._fieldType,
	   	               		fieldType: oPanel._variableType,
	   	               		value: ""
	   	               	};
					this.getForm().updateCondition(oPanel._pId, ret.exp);					
				} else {
					if (oPanel._variableType == "Numeric" || oPanel._variableType == "Currency") {
						if ((ret.exp.value != undefined && ret.exp.value != null) && ((ret.exp.value[0] == " " && ret.exp.value[1] == "{") || ret.exp.value[0] == "[")) {
							ret.exp.value = "";							
						}
					}
					this.getForm().updateCondition(oPanel._pId, ret.exp);
				}
			} else {
				ret.exp = {
   	               		type: "COMPARE",
   	               		operator: oPanel._operator,
   	               		fieldId: oPanel._fieldId,
   	               		fieldName: oPanel._fieldType,
   	               		fieldType: oPanel._variableType,
   	               		value: (!$.isArray(oPanel._value)) ? oPanel._value : undefined,
   	               		values: ($.isArray(oPanel._value)) ? oPanel._value : undefined
   	               	};
				this.getForm().addCondition(oPanel._pId, ret.exp);
			}
		}

		var bReset = bBlank || (sas.fscf.isFilteringOperator(previousOperator) && !sas.fscf.isFilteringOperator(ret.exp.operator));
      	this.updatePanel(oPanel, this.getListBoxForPanel(oPanel), ret.exp, bReset, function() {
           	this.getRelatedRows().update();
           	this.updateCounts();
       	});
    },
    updateOperatorInput: function(oPanel) {
    	var _this = this;
		var oInput = this.getOperatorInputForPanel(oPanel);
		if (sas.fscf.isMultivalueOperator(oPanel._operator)) {
			if (!(oInput instanceof sas.hc.m.MultiInput)) {
				if( oInput instanceof sas.hc.m.ComboBox ) {
					oPanel._value = ""; //it doesn't make sense to use a lookup list name in any other type of statement
				}
	        	var vl = this.getVerticalLayoutForPanel(oPanel);
	        	oInput = vl.removeContent(2); 	//remove current filter input
	        	oInput.destroy();				//destroy current filter input
	        	oInput = null;
	        	if (!$.isArray(oPanel._value)) {
	        		if (oPanel._value != null && oPanel._value.length > 0) {
		        		oPanel._value = new Array(oPanel._value);
	        		} else {
	        			oPanel._value = new Array();
	        		}
	        	}
	            oInput = this.createOperatorMultiInput(oPanel, oPanel._value);
	            vl.insertContent(oInput, 2);	//insert new filter input
			} else {
				oInput.destroyTokens();
				if ($.isArray(oPanel._value)) {
					for (var k = 0; k < oPanel._value.length; k++) {
						oInput.addToken(new sas.hc.m.Token({key: oPanel._value[k], text:oPanel._value[k]}).attachDelete(_this.getForm().handleTokenDelete));
					}
					_this.getForm().updateMultiInputClass(oInput);
				}
			}
		} else if ( sas.fscf.isLookupListOperator(oPanel._operator)) {
			if (!(oInput instanceof sas.hc.m.ComboBox)) {
				var vl = this.getVerticalLayoutForPanel(oPanel);
	        	oInput = vl.removeContent(2); 	//remove current filter input
	        	oInput.destroy();				//destroy current filter input
	        	oInput = null;
	        	oPanel._value = "";	//dont want to put a transaction value as the name of the lookup list
	            oInput = this.createOperatorComboBoxInput(oPanel, oPanel._value);
	            vl.insertContent(oInput, 2);	//insert new filter input
			} else {
				//already a combobox input
				if ($.isArray(oPanel._value)) {
					oPanel._value = oPanel._value[0];
				}
				oInput.setValue(oPanel._value);
				
				//if the selected item doesn't match the value (the value was chosen from the form view at the bottom
				//this makes sure the correct item gets selected on the panel
				var text = "";
				if( oInput.getSelectedItem() )
					text = oInput.getSelectedItem().mProperties.text;
				if( text != oPanel._value ) {
					var items = oInput.getItems();
					var notFound = true;
					for( var i = 0; i < items.length; i++) {
						if( items[i].mProperties.text == oPanel._value ) {
							oInput.setSelectedKey( items[i].mProperties.key );
							notFound = false;
							break;
						}
					}
					
					if( notFound ) {
						//if not found in the list at all, select nothing
						oInput.setSelectedKey();
						oInput.setValue(oPanel._value);
					}
				}
			}
		} else {
			if ( !(oInput instanceof sas.hc.m.Input) ) {
				if( oInput instanceof sas.hc.m.ComboBox ) {
					oPanel._value = ""; //it doesn't make sense to use a lookup list name in any other type of statement
				}
	        	var vl = this.getVerticalLayoutForPanel(oPanel);
	        	oInput = vl.removeContent(2); 	//remove current filter input
	        	oInput.destroy();				//destroy current filter input
	        	oInput = null;
	        	if ($.isArray(oPanel._value)) {
	        		if (oPanel._value.length > 0) {
		        		oPanel._value = oPanel._value[0];
	        		} else {
	        			oPanel._value = "";
	        		}
	        	}
	            oInput = this.createOperatorInput(oPanel, oPanel._value);
	            vl.insertContent(oInput, 2);	//insert new filter input
			} else {
				if ($.isArray(oPanel._value)) {
					oPanel._value = oPanel._value[0];
				}
				oInput.setValue(oPanel._value);
			}
		}
		this.updateOperatorSelectEqualsItem(oPanel);
    },
    removePanel: function(oPanel, parentHLayout, bUpdateCounts) {
    	if ($.type(oPanel) === 'string') {
    		oPanel = sap.ui.getCore().byId(oPanel);
    	}
    	if (!oPanel) {
    		return;
    	}
    	this.hideCenteredMessage(this.sId);
    	var fieldType = oPanel._fieldType;
    	var iof = parentHLayout.indexOfContent(oPanel);
    	var indices = oPanel._pId.split("-");
    	var level = indices.length - 1;
    	parentHLayout.removeContent(oPanel);
    	var lbox = this.getListBoxForPanel(oPanel);
    	var bIsFiltered = sas.fscf.isFilteringOperator(oPanel._operator);
		if (!bIsFiltered) {
	    	if (lbox.getSelectedIndices().length == 0) {
	        	lbox = this.getOtherListBoxForPanel(oPanel);
	    	}
		}
    	var bAnySelectedThisPanel = this.notifyDeselects(oPanel, lbox, true);
    	oPanel.destroy();
    	// remove any parent group panel if there is one and it is empty
    	if (level > 1 && parentHLayout.getContent().length == 0) {
    		indices.length = indices.length - 1;
    		var oGroup = this.getPanelNamed(indices.join("-"));
    		var g_parentHLayout;
    		if (level > 2) {
    			indices.length = indices.length - 1;
    			g_parentHLayout = sap.ui.getCore().byId(this.getPanelNamed(indices.join("-")).sId + "_HorizLayout");
    		} else {
    			g_parentHLayout = this.getContent()[0];
    		}
    		iof = g_parentHLayout.indexOfContent(oGroup);
    		g_parentHLayout.removeContent(oGroup);
    		oGroup.destroy();
    		parentHLayout = g_parentHLayout;
    		level--;
    	}
    	this.modifyIds(parentHLayout, iof, level, -1);
    	if (bUpdateCounts && (bAnySelectedThisPanel || bIsFiltered)) {
        	if (this.getContent()[0].getContent().length > 0) {
            	this.getRelatedRows().update();
            	this.updateCounts();
        	} else {
        		this.setPopulationIndicator(this._overallTotalPopulation, this._overallCurrentPopulation);
            	this.getRelatedRows().update();
        		this._anySelected = false;
        		this._anyFiltered = false;
        	}
    	}
    },
    modifyIds: function(parent, startIndex, level, delta){
    	var oPanel;
    	var pId;
    	var indices;
    	var subPanels;
    	var subPanel;
    	for (var i = startIndex; i < parent.getContent().length; i++) {
    		oPanel = parent.getContent()[i];
    		pId = oPanel._pId;
        	indices = pId.split("-");
        	if (level > indices.length - 1) {
        		return;
        	}
        	indices[level] = parseInt(indices[level]) + delta;
    		pId = indices.join("-");
    		oPanel._pId = pId;
    		// get sub-panels if there are any
    		subPanels = oPanel.getDomRef().getElementsByClassName("sapMPanel");
    		for (var j = 0; j < subPanels.length; j++) {
    			subPanel = sap.ui.getCore().byId(subPanels[j].id);
        		pId = subPanel._pId;
            	indices = pId.split("-");
            	indices[level] = parseInt(indices[level]) + delta;
        		pId = indices.join("-");
        		subPanel._pId = pId;
    		}
    	}
    },
    removeAllPanels: function(bSkipNotify) {
    	this.hideCenteredMessage(this.sId);
    	var panels = this.getContent()[0].removeAllContent();
		this.setPopulationIndicator(this._overallTotalPopulation, this._overallCurrentPopulation);
		var palette = this.getPalette();
		this._anyFiltered = false;
		for (var i = panels.length - 1; i >=0; i--) {
			this._anyFiltered = this._anyFiltered || sas.fscf.isFilteringOperator(panels[i]._operator);
    		if (!bSkipNotify) {
    			this.getForm().removeAllConditions();
    		}
			panels[i].destroy();
		}
		if (this._anySelected || this._anyFiltered) {
			sas.fscf.removeAllMessageStrips();
			sas.fscf.getCurrentPageView().setDirty(true);
	    	this.getRelatedRows().update();
		}
		this._anySelected = false;
		this._anyFiltered = false;
    },
    storeRulePanelData: function() {
		if (!sas.fscf.getCurrentPageView().jsonRule.expressions.expressions[0].properties) {
			sas.fscf.getCurrentPageView().jsonRule.expressions.expressions[0].properties = {};
		}

		var panelDataSegments = [];
		this.getPanelDataForExpressions("F", sas.fscf.getCurrentPageView().jsonRule.expressions.expressions[0].condition.expressions, panelDataSegments);

		sas.fscf.getCurrentPageView().jsonRule.expressions.expressions[0].properties.panelData = "{" + panelDataSegments.join(",") + "}";
    },
    getPanelDataForExpressions: function(baseId, exps, panelDataSegments) {
    	if (!exps) {
    		return;
    	}
    	var id, panel;
    	// when the rule reopens, the ids will be sequential, so store the panelData
    	// with sequential ids rather than the ids that are in the expressions
		for (var i = 0; i < exps.length; i++) {
			if(exps[i]!=null){
				id = baseId + "-" + (i + 1);
				panel = this.getPanelNamed(exps[i].id);   // look up the panel by the id in the expression, but use the sequential id for everything else
				if (panel) {
					if (panel._type == 1) {
						if (panel._groupBy) {
							panelDataSegments[panelDataSegments.length] = '"' + id + '":{"groupBy":' + panel._groupBy + ', "g_from":' + panel._g_from + ', "g_to":' + panel._g_to + ', "g_by":' + panel._g_by + '}';
						} else {
							panelDataSegments[panelDataSegments.length] = '"' + id + '":{"groupBy":' + panel._groupBy + ', "from":' + panel._from + ', "to":' + panel._to + '}';
						}
					}
					if ((exps[i]["type"] == "OR") || (exps[i]["type"] == "AND") || (exps[i]["type"] == "NOR")) {
						this.getPanelDataForExpressions(id, exps[i].expressions, panelDataSegments);
					}					
				}
			}
		}
    },
    updateRangesAfterInputChange: function (pId, bNotifyForm) {
		var oPanel = this.getPanelNamed(pId);
		var oListBox = this.getListBoxForPanel(oPanel);
		var oOtherListBox = this.getOtherListBoxForPanel(oPanel);
		var oFromInput = sap.ui.getCore().byId(oPanel.sId + "_FromInput");
		var oToInput = sap.ui.getCore().byId(oPanel.sId + "_ToInput");
		var oGroupSizeInput = sap.ui.getCore().byId(oPanel.sId + "_GroupSizeInput");
		var by;

		if (oPanel._groupBy) {
			by = sas.fscf.floatFormatter.parse(oGroupSizeInput.getValue());
			if (isNaN(by) || by <= 0) {
				oGroupSizeInput.setValueState(sap.ui.core.ValueState.Error);
			}
		}
		
		if ((oFromInput.getValueState() != sap.ui.core.ValueState.Error) &&
			(oToInput.getValueState() != sap.ui.core.ValueState.Error) &&
			(oGroupSizeInput.getValueState() != sap.ui.core.ValueState.Error)) {
			var from = sas.fscf.floatFormatter.parse(oFromInput.getValue());
			var to = sas.fscf.floatFormatter.parse(oToInput.getValue());
			if (isNaN(from) && !isNaN(to)) {
				from = to;
			} else if (isNaN(to) && !isNaN(from)) {
				to = from;
			}
			if (from > to) {
				var temp = from;
				from = to;
				to = temp;
			}
			var prior_from = oPanel._from;
			var prior_to = oPanel._to;
			if (oPanel._groupBy) {
				oPanel._g_from = Math.floor(from);
				oPanel._g_to = Math.floor(to);
				oPanel._g_by = Math.floor(by);
				oFromInput.setValue( oPanel._g_from );
				oToInput.setValue( oPanel._g_to );
			} else {
				oPanel._from = from;
				oPanel._to = to;
				oFromInput.setValue( from );
				oToInput.setValue( to );
			}
			if (isNaN(from) && isNaN(to)) {
				oPanel._value = undefined;
			} else {
				if( !isNaN( oPanel._value ) ) {
					//value is just a number and operator is like GT or something
					//need to convert to the format updateRangeValues is looking for
					oPanel._value = this.getRangeForExp( {
						type: "COMPARE",
						operator: oPanel._operator,
						from: from,
                        to: to
					} );
					oPanel._operator = sas.fscf.operators.EQUAL;
				}
				
				oPanel._value = this.updateRangeValues(oPanel._value, prior_from, prior_to, from, to);
			}

			var exp = this.getExpForRange(oPanel._value);			
			if (exp) {
	      		exp.type = ((exp.leftValue != null) && (exp.leftValue != undefined)) ? "RANGE" : "COMPARE";
				exp.fieldId = oPanel._fieldId;
				exp.fieldName = oPanel._fieldType;
				exp.fieldType = oPanel._variableType;
				if ($.isArray(oPanel._value)) {
					exp.values = oPanel._value;
					exp.operator = sas.fscf.operators.IN;
				} else {
					exp.value = oPanel._value;
				}
			}
			
			var numWereSelected = oListBox.getSelectedIndices().length;
			if (numWereSelected == 0 && oOtherListBox) {
				numWereSelected = oOtherListBox.getSelectedIndices().length;
			}
			
	      	this.updatePanel(oPanel, oListBox, exp, true, function() {
	        	// get all of the selections
				var selIndices = oListBox.getSelectedIndices();
				var selItems = oListBox.getSelectedItems();
				oListBox._priorSelectedIndices = selIndices;

				// notify the form
				if (bNotifyForm || selIndices.length > 1) {
					var exp;
		            var field = oPanel._fieldType;
		            var fieldId = oPanel._fieldId;
		            var variableType = oPanel._variableType;
		            if (selItems.length > 0) {
						for (var j = 0; j < selItems.length; j++) {
			                if (oPanel._type == 1) {
			                	if (!oListBox.getItems()[selIndices[j]]._exp) {
			                		oListBox.getItems()[selIndices[j]]._exp = this.getExpForRange($.isArray(oPanel._value) ? oPanel._value[j] : oPanel._value);
			                	}
			                }
			                exp = oListBox.getItems()[selIndices[j]]._exp;
			                if (exp) {
								this.getForm().replaceCondition($.isArray(oPanel._value) ? oPanel._pId + "-" + (j + 1): oPanel._pId, {
		    	               		type: ((exp.leftValue != null) && (exp.leftValue != undefined)) ? "RANGE" : "COMPARE",
		    	               		operator: exp.operator,
		    	               		fieldId: fieldId,
		    	               		fieldName: field,
		    	               		fieldType: variableType,
		    	               		value: exp.value,
		    	               		leftValue: exp.leftValue,
		    	               		rightValue: exp.rightValue,
		    	               		leftOperator: exp.leftOperator,
		    	               		rightOperator: exp.rightOperator
		    	               	});
			                }
						}
						if (numWereSelected > selItems.length) {
							for (var k = selItems.length + 1; k <= numWereSelected; k++) {
				               	this.getForm().removeCondition(oPanel._pId + "-" + k, null, false);								
							}
							if ($.isArray(oPanel._value)) {
								oPanel._value.length = selItems.length;
							}
						} else {
							this.getForm().initSplitForm();
						}
		            } else if (numWereSelected > 0) {
		               	this.getForm().removeCondition(oPanel._pId, null, false);
		            }
				}						
				
	           	this.getRelatedRows().update();
	           	this.updateCounts();
	       	});		
		}
	},
	updateAfterOperatorInputChange: function (oPanel, value) {
		oPanel._value = value;
		var ret = this.getForm().findCondition(oPanel._pId);
		if (ret.exp) {
			if ($.isArray(oPanel._value)) {
				ret.exp.values = oPanel._value;
			} else {
				ret.exp.value = oPanel._value;
			}
		}

		var bBlank = ($.isArray(oPanel._value)) ? (oPanel._value.length == 0) : ((oPanel._value == undefined) || (oPanel._value == null) || (oPanel._value == ""));
		if (bBlank) {
			if (ret.exp) {
				this.getForm().removeCondition(oPanel._pId, ret.exp);
			}
		} else {
			if (ret.exp) {
				this.getForm().updateCondition(oPanel._pId, ret.exp);
			} else {
				ret.exp = {
   	               		type: "COMPARE",
   	               		operator: oPanel._operator,
   	               		fieldId: oPanel._fieldId,
   	               		fieldName: oPanel._fieldType,
   	               		fieldType: oPanel._variableType,
   	               		value: (!$.isArray(oPanel._value)) ? oPanel._value : undefined,
   	               		values: ($.isArray(oPanel._value)) ? oPanel._value : undefined
   	               	};
				this.getForm().addCondition(oPanel._pId, ret.exp);
			}
		}

		var bReset = bBlank;
      	this.updatePanel(oPanel, this.getListBoxForPanel(oPanel), ret.exp, bReset, function() {
           	this.getRelatedRows().update();
           	this.updateCounts();
       	});		
	},
	notifyDeselects: function(panel, lbox, bModifyIds) {
    	if (lbox) {
    		if (lbox.getSelectedIndices().length > 0) {
               	this.getForm().removeCondition(panel._pId, null, bModifyIds);
        		return true;
    		} else {
    			// attempt to remove a matching expression in the model anyways, as the user may have created
    			// an expression in the full form using a field that has no data, in which case there will be
    			// a panel with nothing selected for that expression
               	this.getForm().removeCondition(panel._pId, null, bModifyIds);
    			return false;
    		}
    	}
    },
    selectListBoxItem: function(oListBox, index) {
    	if (oListBox.getItems()[index]) {
    		$lbi = $(oListBox.getItems()[index].getDomRef());
    		$lbi.addClass("sapUiLbxISel");
    		$lbi.attr("aria-selected", true);
    		oListBox.addSelectedIndex(index);
    	}
    },
    deselectListBoxItem: function(oListBox, index) {
    	if (oListBox.getItems()[index]) {
    		$lbi = $(oListBox.getItems()[index].getDomRef());
    		$lbi.removeClass("sapUiLbxISel");
    		$lbi.attr("aria-selected", false);
    		oListBox.removeSelectedIndex(index);
    	}
    },
    selectListBoxItemFromExp: function(bSelect, lbox, exp) {
    	var _this = this;
    	if (lbox && exp && ( sas.fscf.isEqualOrInOperator(exp.operator) || exp.fieldType == "Numeric" || exp.fieldType == "Currency" ) ) {
    		if ((exp.type == "COMPARE" && sas.fscf.isMultivalueOperator(exp.operator)) && !(exp.value && exp.value.length > 0)) {
        		var value;
				var bFound = false;
        		for (var j = 0; j < exp.values.length; j++) {
        			value = exp.values[j];
            		var li;
            		_this.selectValueInData(lbox.getModel().getData(), value, exp.fieldType, bSelect);
					bFound = false;
            		for (var i = 0; i < lbox.getItems().length; i++) {
       					li = lbox.getItems()[i];
       					if (li.getKey() == value) {
	   						bFound = true;
       						bSelect ? this.selectListBoxItem(lbox, i) : this.deselectListBoxItem(lbox, i);
       						break;
       					}
            		}
	        		if (!bFound && bSelect) {
    					var newItem = new sap.ui.core.ListItem({
                              key: value,
                              text: value,
                              additionalText: _this._bPercentages ? sas.fscf.percentFormatter.format(0) : sas.fscf.floatFormatter.format(0)
                        });
    					lbox.addItem(newItem);
    					this.selectListBoxItem(lbox, lbox.indexOfItem(newItem));
	        		}
        		}
        	}
    		else if ((exp.fieldType == "Numeric") || (exp.fieldType == "Currency")) {
   	        		var li;
   	        		var value = _this.getRangeForExp(exp);
					_this.selectValueInData(lbox.getModel().getData(), value, exp.fieldType, bSelect);
					var bFound = false;
  	        		for (var i = 0; i < lbox.getItems().length; i++) {
   	   					li = lbox.getItems()[i];
	   					if (li.getKey() == value) {
   	   						bFound = true;
   	   						bSelect ? this.selectListBoxItem(lbox, i) : this.deselectListBoxItem(lbox, i);
   	   						break;
   	   					}
   	        		}
        	} else {
	        		var li;
					_this.selectValueInData(lbox.getModel().getData(), exp.value, exp.fieldType, bSelect);
					var bFound = false;
	        		for (var i = 0; i < lbox.getItems().length; i++) {
	   					li = lbox.getItems()[i];
	   					if (li.getKey() == exp.value) {
	   						bFound = true;
	   						bSelect ? this.selectListBoxItem(lbox, i) : this.deselectListBoxItem(lbox, i);
	   						break;
	   					}
	        		}
	        		if (!bFound && bSelect) {
    					var newItem = new sap.ui.core.ListItem({
                              key: exp.value,
                              text: exp.value,
                              additionalText: _this._bPercentages ? sas.fscf.percentFormatter.format(0) : sas.fscf.floatFormatter.format(0)
                        });
    					lbox.addItem(newItem);
    					this.selectListBoxItem(lbox, lbox.indexOfItem(newItem));
	        		}
        	}
    	}
    },
    conditionModified: function(pId, expBefore, expAfter) {
    	var _this = this;

    	if (!expAfter || !expAfter.fieldName) {
    		return;
    	}
		//console.info("conditionModified, pId = " + pId + ", expBefore = " + JSON.stringify(expBefore) + ", expAfter = " + JSON.stringify(expAfter));
    	sas.fscf.removeAllMessageStrips();
		sas.fscf.getCurrentPageView().setDirty(true);
    	var oPanel = this.getPanelNamed(pId);
    	if (!oPanel) {
    		// could be a multi-select OR block, so try the parent
    		var id_indices = pId.split("-");
    		id_indices.length = id_indices.length - 1;
    		pId = id_indices.join("-");
    		oPanel = this.getPanelNamed(pId);
    	}
    	if (oPanel) {
        	var lbox = this.getListBoxForPanel(oPanel);
        	if( expAfter._setFromForm ) {
    			oPanel._setFromForm = true;
    		}
        	if ( expAfter.operator ) {
        		//for character fields and simple numerics
        		this.updatePanel(oPanel, lbox, expAfter, false, this.finishConditionModified);
        	} else {
        		//for ranges    				
        		if( oPanel._groupBy ) {				
	    			var new_g_by = Math.abs(parseInt(expAfter.rightValue) - parseInt(expAfter.leftValue));
		    		var inp = sap.ui.getCore().byId(oPanel.sId + "_GroupSizeInput");
		    		if (inp) {
		    			inp.setValue(sas.fscf.floatFormatter.format(new_g_by));
		    		}

		    		var i = (parseInt(expBefore.leftValue) - oPanel._g_from) / oPanel._g_by;
		    		var total = lbox.getItems().length;
		    		var new_g_from = parseInt(expAfter.leftValue) - (new_g_by * i);
		    		inp = sap.ui.getCore().byId(oPanel.sId + "_FromInput");
		    		if (inp) {
		    			inp.setValue(sas.fscf.floatFormatter.format(new_g_from));
		    		}
		    		
		    		inp = sap.ui.getCore().byId(oPanel.sId + "_ToInput");
		    		if (inp) {
		    			inp.setValue(sas.fscf.floatFormatter.format(new_g_from + (new_g_by * total)));
		    		}
        		} else {
					inp = sap.ui.getCore().byId(oPanel.sId + "_FromInput");
		    		if (inp) {
		    			inp.setValue( expAfter.leftValue );
		    		}
		    		
		    		inp = sap.ui.getCore().byId(oPanel.sId + "_ToInput");
		    		if (inp) {
		    			inp.setValue( expAfter.rightValue );
		    		}
        		}
				oPanel._value = this.updateRangeValuesForGroupBy(oPanel._value, expBefore.leftValue, expBefore.rightValue, expAfter.leftValue, expAfter.rightValue);
	    		this.updateRangesAfterInputChange(oPanel._pId, false);
	    		this.finishConditionModified(oPanel);
	    	}
        }
    },
    finishConditionModified: function(oPanel) {
    	this.getRelatedRows().update();
       	this.updateCounts(null, function () {
       		// success callback
       		sas.fscf.removeAllMessageStrips();
    		sas.fscf.getCurrentPageView().setDirty(true);
       	});
    },
    conditionDeleted: function(pId, exp) {
    	if (!pId || !exp) {
    		return;
    	}
		//console.info("conditionDeleted, pId = " + pId + ", exp = " + JSON.stringify(exp));
    	var oPanel = this.getPanelNamed(pId);
    	if (!oPanel) {
    		// could be a multi-select OR block, so try the parent
    		var id_indices = pId.split("-");
    		id_indices.length = id_indices.length - 1;
    		pId = id_indices.join("-");
    		oPanel = this.getPanelNamed(pId);
    	}
    	if (oPanel) {
            oPanel._operator = sas.fscf.operators.EQUAL;   	// reset operator
        	var lbox = this.getListBoxForPanel(oPanel);
        	exp.value = undefined;		// reset value
        	exp.values = undefined;		// reset value
        	this.updatePanel(oPanel, lbox, exp, true, this.finishConditionDeleted);
        }
    },
    finishConditionDeleted: function(oPanel) {
        this.setNot(false, oPanel);   // turn off not if it is on
        oPanel._value = null;		  // reset value
        oPanel._filtering = false;	  // reset filtering
    	var lbox = this.getListBoxForPanel(oPanel);
        lbox.setEnabled(true);
    	lbox = this.getOtherListBoxForPanel(oPanel);
    	if (lbox) {
            lbox.setEnabled(true);
    	}
       	this.updateOperatorSelectEqualsItem(oPanel);
       	this.updateSelectedOperator(oPanel);
       	this.getRelatedRows().update();
       	this.updateCounts(null, function () {
       		// success callback
       		sas.fscf.removeAllMessageStrips();
    		sas.fscf.getCurrentPageView().setDirty(true);
       	});
    },
    containsField: function(fieldType) {
    	if (this.getContent()[0]) {
        	for (var i = 0; i < this.getContent()[0].getContent().length; i++) {
        		if (this.getContent()[0].getContent()[i]._fieldType == fieldType) {
        			return true;
        		}
        	}
    	}
    	return false;
    },
    getPanelNamed: function(name) {
    	var elems = document.getElementsByName(name);
    	if (elems.length > 0) {
        	return sap.ui.getCore().byId(elems[0].id);
    	} else {
    		return null;
    	}
    },
    reload: function(continueCallback) {
    	this.getRelatedRows().update();
    	this.updateCounts();
    },
    getPalette: function() {
    	return sap.ui.getCore().byId(this.sId.substr(0, this.sId.indexOf("GridView")) + "PaletteView");
    },
    getForm: function() {
    	return sap.ui.getCore().byId(this.sId.substr(0, this.sId.indexOf("GridView")) + "FormView");
    },
    getRelatedRows: function() {
    	return sap.ui.getCore().byId(this.sId.substr(0, this.sId.indexOf("GridView")) + "RelatedRowsView");
    },
    _oData: null,
    _anySelected: false,
    _anyFiltered: false,
    _overallTotalPopulation: 0,
    _overallCurrentPopulation: 0,
    _bPercentages: false,
    getAllSelData: function(overridePanelId, overrideQSegment) {
    	// get all of the selections
    	var allSelData = {};
    	var panel;
    	allSelData.selItems = [];
    	allSelData.fields = [];
    	allSelData.variableTypes = [];
    	allSelData.groupTypes = [];
    	allSelData.froms = [];
    	allSelData.tos = [];
    	allSelData.g_froms = [];
    	allSelData.g_tos = [];
    	allSelData.g_bys = [];
    	allSelData.qsegments = [];
    	var ret;

		this._anySelected = false;
		this._anyFiltered = false;
    	for (var i = 0; i < this.getContent()[0].getContent().length; i++) {
    		panel = this.getContent()[0].getContent()[i];
			this._anyFiltered = this._anyFiltered || sas.fscf.isFilteringOperator(panel._operator);
			allSelData.groupTypes[allSelData.groupTypes.length] = panel._groupType;
    		if (panel._isGroup) {
    			ret = this.processSelItemsForGroup(panel, overridePanelId, overrideQSegment);
    		} else {
    			ret = this.processSelItemsForPanel(panel, overridePanelId, overrideQSegment);
    		}
    		if (ret) {
    			allSelData.fields[allSelData.fields.length] = ret.fields;
    			allSelData.variableTypes[allSelData.variableTypes.length] = ret.variableTypes;
    			allSelData.froms[allSelData.froms.length] = ret.froms;
    			allSelData.tos[allSelData.tos.length] = ret.tos;
    			allSelData.g_froms[allSelData.g_froms.length] = ret.g_froms;
    			allSelData.g_tos[allSelData.g_tos.length] = ret.g_tos;
    			allSelData.g_bys[allSelData.g_bys.length] = ret.g_bys;
    			allSelData.selItems[allSelData.selItems.length] = ret.selItems;
    			if (ret.anySelected) {
    				this._anySelected = true;
    			}
       			allSelData.qsegments[allSelData.qsegments.length] = ret.qsegments;
       			if (ret.overrideSelItems) {
       				allSelData.overrideSelItems = ret.overrideSelItems;
       			}
    		}
    	}
    	
    	return allSelData;
    },
    getCountsQForPanel: function(oPanel, index, level, prior_index, allSelData, bSearchPanel) {
       	var q = "*:*";
   		if (allSelData.qsegments.length > 0) {
   			var ruleOverallType = sas.fscf.getCurrentPageView().jsonRule.expressions.expressions[0].condition.type;
   			var qsegments_mod = [];
   			var qsegments_group_mod, groupType, qsegment_group;
   			for (var i = 0; i < allSelData.qsegments.length; i++) {
   				if ($.isArray(allSelData.qsegments[i])) {
   					groupType = allSelData.groupTypes[i];
   					// omit the qsegment for the current group if the rule overall type is OR or NOR, unless the current panel is a filtering operator or a search
   					if (level == 0 && (ruleOverallType == "OR" || ruleOverallType == "NOR") && !(oPanel._filtering || bSearchPanel)) {
   						continue;
   					}
   					// omit the qsegment for the current group if its group type is OR or NOR, unless the current panel is a filtering operator or a search
   					if (level > 0 && i == prior_index && (groupType == "OR" || groupType == "NOR") && !(oPanel._filtering || bSearchPanel)) {
   						continue;
   					}
   					qsegments_group_mod = [];
   					for (var j = 0; j < allSelData.qsegments[i].length; j++) {
       					if (!allSelData.qsegments[i][j]) {
       						continue;
       					}
           				// omit the qsegment for the current panel, unless it is a filtering operator or a search
   						if ((level == 0 && i == index && !(oPanel._filtering || bSearchPanel)) ||
   							(level > 0 && i == prior_index && j == index && !(oPanel._filtering || bSearchPanel))) {
   							continue;
   						}
           				// omit the qsegment for the other panels in the current group if the current group type is OR or NOR
   						if ((groupType == "OR" || groupType == "NOR") && level > 0 && i == prior_index && j != index) {
   							continue;
   						}
       					qsegments_group_mod[qsegments_group_mod.length] = allSelData.qsegments[i][j];
   					}
   					if (qsegments_group_mod.length == 0) {
   						continue;
   					}
   					qsegment_group = "(";
   					if (groupType == "NOR") {
   						qsegment_group += "*:* NOT (";
   						qsegment_group += qsegments_group_mod.join(" OR ");
   						qsegment_group += ")";
   					} else {
   						qsegment_group += qsegments_group_mod.join(" " + groupType + " ");
   					}
   					qsegment_group += ")";
   					qsegments_mod[qsegments_mod.length] = qsegment_group;
   				} else {
   					if (!allSelData.qsegments[i]) {
   						continue;
   					}
   					// omit the qsegment if the rule overall type is OR or NOR, unless the current panel is a filtering operator or a search
   					if ((ruleOverallType == "OR" || ruleOverallType == "NOR") && !(level == 0 && i == index && (oPanel._filtering || bSearchPanel))) {
   						continue;
   					}
       				// omit the qsegment for the current panel, unless it is a filtering operator or a search
					if (level == 0 && i == index && !(oPanel._filtering || bSearchPanel)) {
						continue;
					}
   					if(!allSelData.qsegments[i].includes(":\"\"") && !allSelData.qsegments[i].includes(":)")){
            	 		qsegments_mod[qsegments_mod.length] = allSelData.qsegments[i];
           			}
   				}
   			}
   			if (qsegments_mod.length > 0) {
    			if (ruleOverallType == "OR") {
    				q = encodeURIComponent(qsegments_mod.join(" OR "));
    			} else if (ruleOverallType == "NOR") {
       	   			q = "*:* NOT (" + encodeURIComponent(qsegments_mod.join(" OR ")) + ")";
       			} else if (ruleOverallType == "AND") {
       				q = encodeURIComponent(qsegments_mod.join(" AND "));
       			}
   			}
   		}
   		return q;
    },
    getCountsQForAllQSegments: function(allSelData) {
    	var q = "*:*";
		if (allSelData.qsegments.length > 0) {
			var groupType, qsegment_group;
			for (var i = allSelData.qsegments.length - 1; i >= 0 ; i--) {
				if (!allSelData.qsegments[i]) {
					allSelData.qsegments.splice(i, 1);
					continue;
				}
				if ($.isArray(allSelData.qsegments[i])) {
        			for (var j = allSelData.qsegments[i].length - 1; j >= 0 ; j--) {
        				if (!allSelData.qsegments[i][j]) {
        					allSelData.qsegments[i].splice(j, 1);
        					continue;
        				}
        			}
        			if (allSelData.qsegments[i].length == 0) {
        				allSelData.qsegments.splice(i, 1);
        				continue;
        			}
   					groupType = allSelData.groupTypes[i];
   					qsegment_group = "(";
   					if (groupType == "NOR") {
   						qsegment_group += "*:* NOT (";
   						qsegment_group += allSelData.qsegments[i].join(" OR ");
   						qsegment_group += ")";
   					} else {
   						qsegment_group += allSelData.qsegments[i].join(" " + groupType + " ");
   					}
   					qsegment_group += ")";
   					allSelData.qsegments[i] = qsegment_group; 
				}
			}
			var qsegments=[];
				for (var i = allSelData.qsegments.length - 1; i >= 0; i--) {
					if(!allSelData.qsegments[i].includes(":\"\"") && !allSelData.qsegments[i].includes(":)")){
            	 		qsegments[qsegments.length] = allSelData.qsegments[i];
           			}
				}
			if (qsegments.length > 0) {
    			var ruleOverallType = sas.fscf.getCurrentPageView().jsonRule.expressions.expressions[0].condition.type;
    			if (ruleOverallType == "OR") {
    				q = encodeURIComponent(qsegments.join(" OR "));
    			} else if (ruleOverallType == "NOR") {
    	   			q = "*:* NOT (" + encodeURIComponent(qsegments.join(" OR ")) + ")";
    			} else {
    				q = encodeURIComponent(qsegments.join(" AND "));
    			}
			}
		}
		return q;
    },
    updateCounts: function(lastSelectionPanelId, successCallback, failureCallback) {
    	this.customSetBusy(true);

    	var _this = this;
    	_this.refreshCenteredMessage();

    	var allSelData = _this.getAllSelData();
    	
    	this.updateCountsForPanel(0, _this.getContent()[0], 0, null, null, allSelData, lastSelectionPanelId, successCallback, failureCallback);    	
    },
    updateCountsForPanel: function(index, parentHLayout, level, prior_parentHLayout, prior_index, allSelData, lastSelectionPanelId, successCallback, failureCallback) {
    	var _this = this;
    	var oPanel = parentHLayout.getContent()[index];
    	if (oPanel) {
        	if (oPanel._isGroup) {
    	    	_this.updateCountsForPanel(0, sap.ui.getCore().byId(oPanel.sId + "_HorizLayout"), level + 1, parentHLayout, index, allSelData, lastSelectionPanelId, successCallback, failureCallback);    			
        	} else {
        		if (!lastSelectionPanelId || oPanel._pId != lastSelectionPanelId) {
                   	// update the counts and re-bind the data model
        			var q = _this.getCountsQForPanel(oPanel, index, level, prior_index, allSelData);

               		var obj;
               		if (level > 0) {
                   		obj = sas.fscf.getQueryObject((_this.isExplore() ? "facets" : "risk"), (_this.isExplore() ? "esdb" : null), q, allSelData.fields[prior_index][index], allSelData.variableTypes[prior_index][index], allSelData.froms[prior_index][index], allSelData.tos[prior_index][index], allSelData.g_froms[prior_index][index], allSelData.g_tos[prior_index][index], allSelData.g_bys[prior_index][index]);
               		} else {
                   		obj = sas.fscf.getQueryObject((_this.isExplore() ? "facets" : "risk"), (_this.isExplore() ? "esdb" : null), q, allSelData.fields[index], allSelData.variableTypes[index], allSelData.froms[index], allSelData.tos[index], allSelData.g_froms[index], allSelData.g_tos[index], allSelData.g_bys[index]);
               		}
               		_this._lastReqObj = obj;
                    sas.ajax({url:obj.url, type:"POST", data:obj.data, headers:sas.fscf.getAjaxHeaders()})
                      .done(function(oData){
                    	  _this._oData = oData;
                       	  if (oData && oData[Object.keys(oData)[0]]) {
                       		  if (oData[Object.keys(oData)[0]]['children']) {
                       			  data = oData[Object.keys(oData)[0]]['children'][0];
                       		  } else {
                       			  data = [];
                       			  data.children = [];
                       		  }
                       	  }

           				  if (oPanel._isGroup) {
           					  _this.postProcessSelItemsForGroup(oPanel, (level > 0) ? allSelData.selItems[prior_index][index] : allSelData.selItems[index]);
           				  } else {
           					  if( sas.fscf.isLookupListOperator( oPanel._operator ) ) {
           				  		  //_this.mergeLookupListIntoData( data, oPanel, _this.getListBoxForPanel(oPanel), q );
           				  	  }
           					  _this.postProcessSelItemsForPanel(oPanel,null,null,obj);
           				  }
               			
              	    	  _this.updateCountsForPanel(index + 1, parentHLayout, level, prior_parentHLayout, prior_index, allSelData, lastSelectionPanelId, successCallback, failureCallback);
                      }).fail(function(oObj,textStatus){
                       	  _this.customSetBusy(false);
                       	  _this.showCenteredMessage(_this.sId, sap.ui.core.MessageType.Error, _this.getServerErrorMessage(), null);
                          if (failureCallback) {
                        	  failureCallback.call();
                          }
                      });    	
            	} else {
        			if (oPanel._isGroup) {
     					_this.postProcessSelItemsForGroup(oPanel, (level > 0) ? allSelData.selItems[prior_index][index] : allSelData.selItems[index]);
        			} else {
     					_this.postProcessSelItemsForPanel(oPanel, true);
        			}
        		
            	   	_this.updateCountsForPanel(index + 1, parentHLayout, level, prior_parentHLayout, prior_index, allSelData, lastSelectionPanelId, successCallback, failureCallback);    			
            	}
        	}
    	} else {
    		if (level > 0) {
    	    	_this.updateCountsForPanel(prior_index + 1, prior_parentHLayout, level - 1, null, null, allSelData, lastSelectionPanelId, successCallback, failureCallback);
    		} else {
    			var q = _this.getCountsQForAllQSegments(allSelData);
                sas.ajax({url:sas.fscf.getQueryUrl("search", (_this.isExplore() ? "esdb" : null), q, ""), dataType:"json", headers:sas.fscf.getAjaxHeaders()})
                 .done(function(oData){
        			if (oData && oData[Object.keys(oData)[0]]) {
        	        	_this._overallTotalPopulation = oData[Object.keys(oData)[0]]["total"];
        				if(oData[Object.keys(oData)[0]]["match"]) {
							_this.setPopulationIndicator(_this._overallTotalPopulation, oData[Object.keys(oData)[0]]["match"]);
						} else {
							_this.setPopulationIndicator(_this._overallTotalPopulation, oData[Object.keys(oData)[0]]["count"]);
						}
        			}
        			
        	    	_this.customSetBusy(false);

                    if (successCallback) {
                    	successCallback.call();
                    }    		
                 }).fail(function(oObj,textStatus){
    	  	    	_this.customSetBusy(false);
    	
    	            if (failureCallback) {
    	            	failureCallback.call();
    	            }    		
                 });    			
    		}
    	}
    },
    updateCountsForSearchPanel: function(overridePanel, overrideQSegment) {
    	this.customSetBusy(true);

    	var _this = this;
    	_this.refreshCenteredMessage();

    	var allSelData = _this.getAllSelData(overridePanel._pId, overrideQSegment);
   	
		var parentHLayout = overridePanel.getParent();
		var index = parentHLayout.indexOfContent(overridePanel);
		var level = 0;
		var prior_index = null;
		var parentPanel = parentHLayout.getParent();
		if (parentPanel != _this) {
			level = 1;
			parentHLayout = parentPanel.getParent();
			prior_index = parentHLayout.indexOfContent(parentPanel);
		}
		var q = _this.getCountsQForPanel(overridePanel, index, level, prior_index, allSelData, true);
   		var obj = sas.fscf.getQueryObject((_this.isExplore() ? "facets" : "risk"), (_this.isExplore() ? "esdb" : null), q, overridePanel._fieldType, overridePanel._variableType, overridePanel._from, overridePanel._to, overridePanel._g_from, overridePanel._g_to, overridePanel._g_by);
   		_this._lastReqObj = obj;
        sas.ajax({url:obj.url, type:"POST", data:obj.data, headers:sas.fscf.getAjaxHeaders()})
          .done(function(oData){
           	  _this._oData = oData;

			  _this.postProcessSelItemsForPanel(overridePanel, false, true);
         }).fail(function(oObj,textStatus){
         });    			
    },
    processSelItemsForPanel: function(oPanel, overridePanelId, overrideQSegment) {
    	if (!oPanel._isGroup) {
    		var overrideSelItems;
        	var panel = oPanel;
    		var lbox = this.getListBoxForPanel(panel);
    		var selItems = lbox.getSelectedItems();
        	var bAnySelected = selItems.length > 0;
        	var qsegment = "";
        	if( !panel._operator ) {
        		var qsegments = [];
				for (var j = 0; j < selItems.length; j++) {
    	    		qsegment = panel._fieldType + ":" + selItems[j].getKey();
        	    	qsegments[qsegments.length] = qsegment;
    	    	}
    	    	qsegment = "(" + qsegments.join(" OR ") + ")";
        	} else {
        		qsegment = sas.fscf.getQueryForOperator(panel._operator, panel._fieldType, panel._value, panel._variableType);
        	}
			if (overridePanelId && overridePanelId == panel._pId) {
    			qsegment = overrideQSegment;
    			overrideSelItems = selItems; 
			}
			return {fields: panel._fieldType, variableTypes: panel._variableType, froms: panel._from, tos: panel._to, g_froms: panel._g_from, g_tos: panel._g_to, g_bys: panel._g_by, selItems: selItems, anySelected: bAnySelected, qsegments: qsegment, overrideSelItems: overrideSelItems};
    	}
    },
    processSelItemsForGroup: function(oPanel, overridePanelId, overrideQSegment) {
    	if (oPanel._isGroup) {
        	var panel, lbox, selItems;
        	var allSelItems = [];
        	var fields = [];
        	var variableTypes = [];
        	var froms = [];
        	var tos = [];
        	var g_froms = [];
        	var g_tos = [];
        	var g_bys = [];
        	var qsegment = "";
        	var qsegments = [];
    		var overrideSelItems;
        	var bAnySelected = false;
        	for (var i = 0; i < sap.ui.getCore().byId(oPanel.sId + "_HorizLayout").getContent().length; i++) {
        		panel = sap.ui.getCore().byId(oPanel.sId + "_HorizLayout").getContent()[i];
        		fields[fields.length] = panel._fieldType;
        		variableTypes[variableTypes.length] = panel._variableType;
        		lbox = this.getListBoxForPanel(panel);
        		froms[froms.length] = panel._from;
        		tos[tos.length] = panel._to;
        		g_froms[g_froms.length] = panel._g_from;
        		g_tos[g_tos.length] = panel._g_to;
        		g_bys[g_bys.length] = panel._g_by;
        		selItems = lbox.getSelectedItems();
        		allSelItems[allSelItems.length] = selItems;
        		if (selItems.length > 0) {
        			bAnySelected = true;
       	    		qsegment = panel._fieldType + ":";
       	    		if (panel._type != 1) {
           	    		qsegment += "\"";
       	    		}
       	    		qsegment += selItems[0].getKey();
       	    		if (panel._type != 1) {
           	    		qsegment += "\"";
       	    		}
        	    	qsegments[qsegments.length] = qsegment;
        		} else {
        			qsegments[qsegments.length] = sas.fscf.getQueryForOperator(panel._operator, panel._fieldType, panel._value, panel._variableType);
        		}
    			if (overridePanelId && overridePanelId == panel._pId) {
        			qsegments[qsegments.length - 1] = overrideQSegment;
        			overrideSelItems = selItems; 
    			}
        	}
			return {fields: fields, variableTypes: variableTypes, froms: froms, tos: tos, g_froms: g_froms, g_tos: g_tos, g_bys: g_bys, selItems: allSelItems, anySelected: bAnySelected, qsegments: qsegments, overrideSelItems: overrideSelItems};
    	}
    },
    postProcessSelItemsForPanel: function(oPanel, bLastSelectionPanel, bSearchPanel,objSearch) {
        if (!oPanel._isGroup) {
            var panel = oPanel;
            var lbox, other_lbox, dataForField, sourceArray, mergeArray, mergeData, key, bFound;
            lbox = this.getListBoxForPanel(panel);
            other_lbox = this.getOtherListBoxForPanel(panel);
            dataForField = this.getDataForField(panel._fieldType);
            var selItems = lbox.getSelectedItems();
            if ( (this._anySelected || this._anyFiltered) && !oPanel._setFromForm ) {
                // merge
                if (dataForField) {
                    mergeArray = dataForField['children'];
                } else {
                    mergeArray = null;
                }
                try {
                    sourceArray = lbox.getModel().getData()['children'];
                } catch (ex) {
                    sourceArray = null;
                }
                if (sourceArray) {
                    if (!bLastSelectionPanel) {
                        mergeData = this.getMergeArrayDataForNameWithoutRemove(mergeArray, panel._value);
                        if(!mergeData){
                            if (!(bSearchPanel && sourceArray[0]['sel'] == 1 )) {
                                if(mergeArray){
                                    var existObject = mergeArray.find(function(obj) {
                                        return obj.sel === 1;
                                    });  
                                }
                                if(!existObject){
                                    var newUrl = this.madeNewUrl(objSearch,panel._fieldType,panel._value);                               
                                    sas.ajax({url:newUrl, type:"POST", data:objSearch.data, headers:sas.fscf.getAjaxHeaders()})
                                    .done((oData) => {
                                    this._oData = oData;
                                    this.postProcessSelItemsForPanelWithAllData(mergeArray,panel,bLastSelectionPanel,bSearchPanel,panel._fieldType,panel._value,true);
                                    }).fail(function(oObj,textStatus){
                                    });
                                }else{
                            this.postProcessSelItemsForPanelWithAllData(mergeArray,panel,bLastSelectionPanel,bSearchPanel,panel._fieldType,panel._value,false);
                        }                    
                            }
                        }else{
                            this.postProcessSelItemsForPanelWithAllData(mergeArray,panel,bLastSelectionPanel,bSearchPanel,panel._fieldType,panel._value,false);
                        }
                    }
                }
            }else{
                var oPanel=panel;
                oPanel._setFromForm = undefined;
                if (dataForField) {
                    // replace and re-bind
                    if (this.isExplore() && (panel._variableType == "Numeric" || panel._variableType == "Currency")) {
                        dataForField = this.reorderData(this._lastReqObj.data, dataForField);
                    }               
                    lbox.getModel().setData(dataForField);
                    if (other_lbox) {
                        other_lbox.getModel().setData(dataForField);
                    }
                    if( oPanel._type == 1 ) {
                        var expr = this.getExpForRange( oPanel._value );
                        if( expr ) {
                            expr.fieldId = oPanel._fieldId;
                            expr.fieldName = oPanel._fieldType;
                            expr.fieldType = oPanel._variableType;
                            expr.id = oPanel._pId;
                            this.selectListBoxItemFromExp( true, lbox, expr );
                            this.selectListBoxItemFromExp( true, other_lbox, expr );
                        }
                    }
                } else {
                    // re-bind
                    lbox.getModel().refresh();
                    lbox.getBinding("items").sort(lbox.getBinding("items").aSorters);
                    if (other_lbox) {
                        other_lbox.getModel().refresh();
                        other_lbox.getBinding("items").sort(other_lbox.getBinding("items").aSorters);
                    }                   
                }
            }
            lbox._priorSelectedIndices = lbox.getSelectedIndices();
            // important to null out these two private variables at the end
            this._lastReqObj = null;
            this._oData = null;
        }
    },
    madeNewUrl: function(objSearch,type,value){
        var oldUrl = objSearch.url;
        var newurl,newValue;

        if(Array.isArray(value)){
          newValue="\""+value.toString().replaceAll("\"", "&quot;").replaceAll(",","\" OR "+ type + ":\"")+"\""
        }else{
          newValue=value;
        }
        if(oldUrl.includes("risk")){
            if(newValue != null && (newValue.includes("OR") ||newValue.includes("["))){
                newValue=" AND (" + type + ":" + newValue + ")";
            }else if(newValue != null){
                newValue=" AND (" + type + ":*" + newValue + "*)";
            }else{
              newValue="";
            }
            newUrl= oldUrl.replace(/(q=.*?)(?=&)/, `$1${encodeURIComponent(newValue)}`);
        }else{
            if(newValue != null && (newValue.includes("OR") ||newValue.includes("["))){
                newUrl = oldUrl +encodeURIComponent(" AND (" + type + ":" + newValue + ")");
            }else if(newValue != null){
                newUrl = oldUrl +encodeURIComponent(" AND (" + type + ":*" + newValue + "*)"); 
            }else{
              newUrl=oldUrl;
            }
        }
        return newUrl;
    },
    postProcessSelItemsForPanelWithAllData: function(mergeArray,panel,bLastSelectionPanel,bSearchPanel,type,value,newdata) {
        if (!panel._isGroup) {
            var lbox, other_lbox, dataForField, sourceArray,mergeArrayNewData, mergeData, key, bFound;
            lbox = this.getListBoxForPanel(panel);
            other_lbox = this.getOtherListBoxForPanel(panel);
            dataForField = this.getDataForField(panel._fieldType);
            var selItems = lbox.getSelectedItems();
                try {
                    sourceArray = lbox.getModel().getData()['children'];
                } catch (ex) {
                    sourceArray = null;
                }
                if(newdata){
                    if (dataForField) {
                        mergeArrayNewData = dataForField['children'];
                    } else {
                        mergeArrayNewData = null;
                    }
                }
                for (var j = sourceArray.length - 1; j >= 0; j--) {
                // preserve totals for Numerics, but not for Character
                    if (panel._variableType == "Numeric" || panel._variableType == "Currency") {
                        if (sourceArray[j]['fullsize'] == undefined) {
                            sourceArray[j]['fullsize'] = sourceArray[j]['size'];
                        }
                        if (sourceArray[j]['fullpct'] == undefined) {
                            sourceArray[j]['fullpct'] = sourceArray[j]['pct'];
                        }
                    } else {
                        if (sourceArray[j]['fullsize'] == undefined) {
                            sourceArray[j]['fullsize'] = -1;
                        }
                        if (sourceArray[j]['fullpct'] == undefined) {
                            sourceArray[j]['fullpct'] = -1;
                        }                               
                    }
                    mergeData = this.getMergeArrayDataForName(mergeArray, sourceArray[j]['name']);
                    if (mergeData) {
                        sourceArray[j]['size'] = mergeData['size'];
                        sourceArray[j]['pct'] = mergeData['pct'];
                    } else {
                        if (!(bSearchPanel && sourceArray[j]['sel'] == 1 )) {
                            if(mergeArrayNewData){
                                mergeData = this.getMergeArrayDataForName(mergeArrayNewData , sourceArray[j]['name']);
                                if(Array.isArray(value)){
                                    existValue = value.includes(sourceArray[j]['name']);
                                }else{
                                    existValue = sourceArray[j]['name'] === value;
                                }
                                if(existValue && mergeData){
                                    sourceArray[j]['size'] = mergeData['size'];
                                    sourceArray[j]['pct'] = mergeData['pct'];
                                }else{
                                    sourceArray[j]['size'] = 0;
                                    sourceArray[j]['pct'] = 0;  
                                }
                            }else{
                                sourceArray[j]['size'] = 0;
                                sourceArray[j]['pct'] = 0;
                            }                                        
                        }
                    }
                    if( sas.fscf.isLookupListOperator( panel._operator ) ) {
                        if( sourceArray[j]['size'] == 0 ) {
                            //remove values with 0 count on INLIST panels
                            sourceArray.splice( j, 1 );
                        }
                    }
                }
                // any still left in mergeArray were not found and need to be added
                    if (mergeArray) {
                        for (var j = 0; j < mergeArray.length; j++) {
                            sourceArray.push(mergeArray[j]);
                            sourceArray[sourceArray.length - 1]['fullsize'] = -1;
                            sourceArray[sourceArray.length - 1]['fullpct'] = -1;
                        }
                    }
                    // re-bind
                    lbox.getModel().refresh();
                    lbox.getBinding("items").sort(lbox.getBinding("items").aSorters);
                    if (other_lbox) {
                        other_lbox.getModel().refresh();
                        other_lbox.getBinding("items").sort(other_lbox.getBinding("items").aSorters);
                    }

                    // re-select what was selected before the re-bind
                    if (selItems) {
                        for (var j = 0; j < selItems.length; j++) {
                            key = selItems[j].getKey();
                            bFound = false;
                            for (var k = 0; k < lbox.getItems().length; k++) {
                                if (lbox.getItems()[k].getKey() == key) {
                                    this.selectListBoxItem(lbox, k);
                                    bFound = true;
                                    break;
                                }
                            }
                            if (!bFound && !sas.fscf.isLookupListOperator( oPanel._operator ) ) {
                                var newItem = new sap.ui.core.ListItem({
                                      key: key,
                                      text: selItems[j].getText(),
                                      additionalText: selItems[j].getAdditionalText()
                                });
                                newItem._pct = 0;
                                newItem._fullpct = 0;
                                lbox.insertItem(newItem, (lbox.getSelectedIndices().length > 0) ? lbox.getSelectedIndices()[lbox.getSelectedIndices().length - 1] + 1 : 0);
                                this.selectListBoxItem(lbox, lbox.indexOfItem(newItem));
                            }
                        }
                    }
            lbox._priorSelectedIndices = lbox.getSelectedIndices();
            // important to null out these two private variables at the end
            this._lastReqObj = null;
            this._oData = null;
        }
    },
    postProcessSelItemsForGroup: function(oPanel, selItems) {
    	if (oPanel._isGroup) {
    		var panel;
        	for (var i = 0; i < sap.ui.getCore().byId(oPanel.sId + "_HorizLayout").getContent().length; i++) {
        		panel = sap.ui.getCore().byId(oPanel.sId + "_HorizLayout").getContent()[i];
        		this.postProcessSelItemsForPanel(panel);
        	}
    	}
    },
    reorderData: function(reqData, resData) {
    	if (resData == undefined || resData == null) {
    		return resData;
    	}
    	var fieldName = resData.name;
    	var reqArr = reqData.aggs[fieldName].range.ranges;
    	var resArr = resData.children;
    	var temp;
    	for (var reqi = 0; reqi < reqArr.length; reqi++) {
    		for (var resi = reqi; resi < resArr.length; resi++) {
    			if (resArr[resi].name.indexOf("|" + reqArr[reqi].displayName) != -1) {
    				if (resi == reqi) {
    					// already in the right position
    					break;
    				}
    				// swap the two items
    				temp = resArr[resi];
    				resArr[resi] = resArr[reqi];
    				resArr[reqi] = temp;
    				break;
    			}
    		}
    	}
    	return resData;
    },
    mergeValueIntoData: function(oData, value, variableType, liData) {
    	if (value == undefined || value == null || value == "" || oData == undefined || oData == null || oData['children'] == undefined) {
    		return oData;
    	}
    	var bFound = false;
    	if ($.isArray(value)) {
    		for (var j = 0; j < value.length; j++) {
    			bFound = false;
        		for (var i = 0; i < oData['children'].length; i++) {
        			if ((oData['children'][i].name == value[j]) || 
           					((variableType == "Currency" || variableType == "Numeric") && 
           							(oData['children'][i].name.indexOf(value[j] + "|") == 0 || 
           							(oData['children'][i].name.indexOf("{") == 0) && (" " + oData['children'][i].name).indexOf(value[j] + "|") == 0))) {
        				bFound = true;
        				oData['children'][i].sel = 1;
        				break;
        			}
        		}
        		if (!bFound && (variableType != "Currency" && variableType != "Numeric")) {
        			oData['children'][oData['children'].length] = {"name": value[j], "pct": 0, "size": 0, "sel": 1};
        			oData['size'] = oData['size'] + 1;
        		}
    		}
    	} else {
    		for (var i = 0; i < oData['children'].length; i++) {
    			if ((oData['children'][i].name == value) || 
       					((variableType == "Currency" || variableType == "Numeric") && 
       							(oData['children'][i].name.indexOf(value + "|") == 0 || 
       							(oData['children'][i].name.indexOf("{") == 0) && (" " + oData['children'][i].name).indexOf(value + "|") == 0))) {
    				bFound = true;
    				oData['children'][i].sel = 1;
    				break;
    			}
    		}
    		if (!bFound && (variableType != "Currency" && variableType != "Numeric")) {
    			if (liData) {
    				if (liData.sel != 1) {
    					liData.sel = 1;
    				}
        			oData['children'][oData['children'].length] = liData;
    			} else {
        			oData['children'][oData['children'].length] = {"name": value, "pct": 0, "size": 0, "sel": 1};
    			}
    			oData['size'] = oData['size'] + 1;
    		}
    	}
    	return oData;
    },
    mergeLookupListIntoData: function( data, oPanel, lbox, q ) {
		var _this = this;
		
		if( !oPanel ) {
			return;
		}
		
		var listName = oPanel._value;
		var fieldName = oPanel._fieldType
		
		if( listName == "" || listName == undefined || listName == null ) {
			return;
		}

    	//get the values in this lookup list
    	var bu = sas.fscf.getCurrentPageView().jsonRule.businessUnitId;
        sas.ajax({url:"rest/businessunits/" + bu + "/lookuplists", type:"GET", headers:sas.fscf.getAjaxHeaders()}).done(function (oData) {
			//for some reason apparently there's not a 'get by name' endpoint
			var id;
			for( var i = 0; i < oData.items.length; i++ ) {
				if( listName == oData.items[i].name ) {
					id = oData.items[i].id;
					break;
				}
			}
			if( id ) {
				//a list with the right name was found - get it to see what the values are
				sas.ajax({url:"rest/businessunits/" + bu + "/lookuplists/" + id + "/contents", type:"GET", headers:sas.fscf.getAjaxHeaders()}).done(function (oData) {

					var listContent = [];
					for ( var i = 0; i < oData.count; i++ ) {
						listContent = listContent.concat( oData.items[i][fieldName] );
					}
					
      	            var key;
      	            for (var j = 0; j < listContent.length; j++) {
      	            	key = listContent[j];
      	           		_this.selectValueInData(data, key, "Character", false );
      	            }

					var model = new sap.ui.model.json.JSONModel(data);
        	        lbox.setModel(model);

        	        for (var j = 0; j < listContent.length; j++) {
						key = listContent[j];
						for (var k = 0; k < lbox.getItems().length; k++) {
							if (lbox.getItems()[k].getKey() == key) {
								_this.selectListBoxItem(lbox, k);
								break;
							}
						}
					}
        	        
        	        _this.updateCountsForSearchPanel(oPanel, q);
        	        _this.customSetBusy(false);
        	        
				});
			} else {
				console.log( "nope" );
				return;
			}

        });
    },
    selectValueInData: function(oData, value, variableType, bSelect) {
    	if (value == undefined || value == null || oData == undefined || oData == null || oData['children'] == undefined) {
    		return;
    	}
    	var bFound = false;
   		for (var i = 0; i < oData['children'].length; i++) {
   			if ((oData['children'][i].name == value) || 
   					((variableType == "Currency" || variableType == "Numeric") && 
   							(oData['children'][i].name.indexOf(value + "|") == 0 || 
   							(oData['children'][i].name.indexOf("{") == 0) && (" " + oData['children'][i].name).indexOf(value + "|") == 0))) {
				bFound = true;
   				oData['children'][i].sel = (bSelect) ? 1 : 0;
   				break;
   			}
   		}
   		if (!bFound && bSelect) {
			oData['children'][oData['children'].length] = {"name": value, "pct": 0, "size": 0, "sel": 1};
			oData['size'] = oData['size'] + 1;   			
   		}
    },
    getDataForField: function(fieldType) {
    	if (!this._oData || !this._oData[Object.keys(this._oData)[0]]) {
    		return null;
    	}
    	var fields = this._oData[Object.keys(this._oData)[0]]['children'];
    	if (!fields) {
    		return null;
    	}
    	for (var i = 0; i < fields.length; i++) {
    		if (fields[i]['name'] == fieldType) {
    			return fields[i];
    		}
    	}
    	return null;
    },
    getMergeArrayDataForName: function(mergeArray, name) {
    	if (!mergeArray) {
    		return;
    	}
    	for (var i = 0; i < mergeArray.length; i++) {
    		if (mergeArray[i]['name'] == name) {
    			var item = mergeArray.splice(i, 1)[0];		// remove the item from mergeArray after it is found
    			return {"size":item['size'], "pct":item['pct']};
    		}
    	}
		return;
    },
    getMergeArrayDataForNameWithoutRemove: function(mergeArray, name) {
        if (!mergeArray) {
            return;
        }
        for (var i = 0; i < mergeArray.length; i++) {
            if (mergeArray[i]['name'] == name) { 
                var item = mergeArray.slice(i, i + 1)[0];
                return {"size":item['size'], "pct":item['pct']};
            }
        }
        return;
    },
    setPopulationIndicator: function(total, current) {
		var oProgIndicator = sap.ui.getCore().byId(this.sId.substr(0, this.sId.indexOf("GridView")) + "GridToolbarViewGridToolbarPopulationIndicator");
		if ( oProgIndicator && total != undefined ) {
			if(current==undefined){
				current=0;
			}
			if (total != 0) {
				oProgIndicator.setPercentValue((current / total) * 100);
				oProgIndicator.setDisplayValue(sas.fscf.percentFormatter.format(current / total) + " (" + sas.fscf.rb.getText("rules.rulesPage.guidedView.population.xofy.fmt.txt", [sas.fscf.floatFormatter.format(current), sas.fscf.floatFormatter.format(total)]) + ")");
			} else {
				oProgIndicator.setPercentValue(100);
				oProgIndicator.setDisplayValue(sas.fscf.percentFormatter.format(1));
			}
		}
    },
    getRangeForExp: function(exp) {
    	if (!exp) {
    		return null;
    	}
    	var range_segments = [];
    	if (exp.type == "COMPARE") {
    		if (exp.operator == "EQUAL") {
        		range_segments[range_segments.length] = "[";    			
        		range_segments[range_segments.length] = exp.from;
        		range_segments[range_segments.length] = " TO ";
        		range_segments[range_segments.length] = exp.to;
        		range_segments[range_segments.length] = "]";
    		} else if (exp.operator == "LTE" || exp.operator == "LT") {
        		range_segments[range_segments.length] = " {* TO ";
        		range_segments[range_segments.length] = exp.to;
        		if (exp.operator == "LTE") {
            		range_segments[range_segments.length] = "]";    			
        		} else {
            		range_segments[range_segments.length] = "}";    			
        		}
    		} else if (exp.operator == "GTE" || exp.operator == "GT") {
        		if (exp.operator == "GTE") {
            		range_segments[range_segments.length] = "[";    			
        		} else {
            		range_segments[range_segments.length] = " {";    			
        		}
        		range_segments[range_segments.length] = exp.from;
        		range_segments[range_segments.length] = " TO *}";
    		}
    	} else if (exp.type == "RANGE") {
    		if (exp.leftOperator == "LTE") {
        		range_segments[range_segments.length] = "[";    			
    		} else {
        		range_segments[range_segments.length] = " {";    			
    		}
    		range_segments[range_segments.length] = exp.leftValue;
    		range_segments[range_segments.length] = " TO ";
    		range_segments[range_segments.length] = exp.rightValue;
    		if (exp.rightOperator == "LTE") {
        		range_segments[range_segments.length] = "]";    			
    		} else {
        		range_segments[range_segments.length] = "}";    			
    		}    		
    	}
    	return range_segments.join("");
    },
    getExpForRange: function(range) {
    	var exp = undefined;
    	if (range == undefined || range == null ) {
    		return {};
    	}
    	if ($.isArray(range)) {
    		range = range[0];
    	}
    	var bLeftIncl = true;
    	if (range.indexOf("{") == 0) {
    		bLeftIncl = false;
    		range = range.substr(1, range.length - 1);
    	} else if (range.indexOf(" {") == 0) {
    		bLeftIncl = false;
    		range = range.substr(2, range.length - 2);
    	} else if (range.indexOf("[") == 0) {
    		range = range.substr(1, range.length - 1);
    	}
    	var bRightIncl = false;
    	if (range.lastIndexOf("}") == range.length - 1) {
    		range = range.substr(0, range.length - 1);
    	} else if (range.lastIndexOf("]") == range.length - 1) {
    		bRightIncl = true;
    		range = range.substr(0, range.length - 1);
    	}
    	var nums = range.split(" TO ");
    	if (nums.length == 2) {
        	if (nums[0] == "*") {
        		var to = parseFloat(nums[1]);
        		if (!isNaN(to)) {
        			if (bRightIncl) {
        	        	exp = {type:"COMPARE", operator:"LTE", value:to};
        			} else {
        	        	exp = {type:"COMPARE", operator:"LT", value:to};
        			}
        		}        		
        	} else if (nums[1] == "*") {
        		var from = parseFloat(nums[0]);
        		if (!isNaN(from)) {
        			if (bLeftIncl) {
        	        	exp = {type:"COMPARE", operator:"GTE", value:from};
        			} else {
        	        	exp = {type:"COMPARE", operator:"GT", value:from};
        			}
        		}        		
        	} else {
        		var from = parseFloat(nums[0]);
        		var to = parseFloat(nums[1]);
        		if (!isNaN(from) && !isNaN(to)) {
        			if (from == to) {
        	        	exp = {type:"COMPARE", operator:"EQUAL", value:from};
        			} else {
        	        	exp = {type:"RANGE", leftValue:from, rightValue:to};
        				if (bLeftIncl) {
        					exp.leftOperator = "LTE";
        				} else {
        					exp.leftOperator = "LT";
        				}
        				if (bRightIncl) {
        					exp.rightOperator = "LTE";
        				} else {
        					exp.rightOperator = "LT";
        				}
        			}
        		}
        	}
    	}
    	return exp;
    },
    updateRangeValues: function(value, prior_from, prior_to, from, to) {
    	if (value == undefined || value == null) {
    		return value;
    	}
    	var bIsArray = $.isArray(value);
    	if (!bIsArray) {
    		value = new Array(value);
    	}
    	for (var i = 0; i < value.length; i++) {
        	if (value[i].indexOf("*") != -1) {
            	if (prior_from != from) {
            		value[i] = value[i].replace(new RegExp('\\s' + prior_from + '\\}', 'g'), ' ' + from + '}');
                	value[i] = value[i].replace(new RegExp('\\s' + prior_from + '\\]', 'g'), ' ' + from + ']');
            	}
            	if (prior_to != to) {
                	value[i] = value[i].replace(new RegExp('\\{' + prior_to + '\\s', 'g'), '{' + to + ' ');
                	value[i] = value[i].replace(new RegExp('\\[' + prior_to + '\\s', 'g'), '[' + to + ' ');
            	}
        	} else {
            	if (prior_from != from) {
                	value[i] = value[i].replace(new RegExp('\\{' + prior_from + '\\s', 'g'), '{' + from + ' ');
                	value[i] = value[i].replace(new RegExp('\\[' + prior_from + '\\s', 'g'), '[' + from + ' ');
            		value[i] = value[i].replace(new RegExp('\\s' + prior_from + '\\}', 'g'), ' ' + from + '}');
                	value[i] = value[i].replace(new RegExp('\\s' + prior_from + '\\]', 'g'), ' ' + from + ']');
            	}
            	if (prior_to != to) {
            		value[i] = value[i].replace(new RegExp('\\s' + prior_to + '\\}', 'g'), ' ' + to + '}');
                	value[i] = value[i].replace(new RegExp('\\s' + prior_to + '\\]', 'g'), ' ' + to + ']');
                	value[i] = value[i].replace(new RegExp('\\{' + prior_to + '\\s', 'g'), '{' + to + ' ');
                	value[i] = value[i].replace(new RegExp('\\[' + prior_to + '\\s', 'g'), '[' + to + ' ');
            	}
	        	if (from == to) {
                	value[i] = value[i].replace(new RegExp('\\s\\{', 'g'), '[');
                	value[i] = value[i].replace(new RegExp('\\{', 'g'), '[');
                	value[i] = value[i].replace(new RegExp('\\}', 'g'), ']');
	        	}
        	}
    	}
    	if (!bIsArray) {
    		return value[0];
    	}
    	return value;
    },
    updateRangeValuesForGroupBy: function(value, prior_leftValue, prior_rightValue, leftValue, rightValue) {
    	if (value == undefined || value == null) {
    		return value;
    	}
    	var bIsArray = $.isArray(value);
    	if (!bIsArray) {
    		value = new Array(value);
    	}
    	
    	// make sure the args are numbers/integers
    	prior_leftValue = parseInt(prior_leftValue);
    	prior_rightValue = parseInt(prior_rightValue);
    	leftValue = parseInt(leftValue);
    	rightValue = parseInt(rightValue);
    	
		var prior_g_by = Math.abs(prior_rightValue - prior_leftValue);
		var new_g_by = Math.abs(rightValue - leftValue);
		var exps = [];
		var i;
    	for (var j = 0; j < value.length; j++) {
    		exps[j] = this.getExpForRange(value[j]);
    		if (exps[j].leftValue == prior_leftValue && exps[j].rightValue == prior_rightValue) {
    			i = j;
    		}
    	}
    	exps[i].leftValue = leftValue;
    	exps[i].rightValue = rightValue;
    	for (var j = i - 1; j >= 0; j--) {
    		exps[j].leftValue = leftValue - (new_g_by * ((prior_leftValue - exps[j].leftValue) / prior_g_by));
    		exps[j].rightValue = exps[j].leftValue + new_g_by;
    	}
    	for (var j = i + 1; j < exps.length; j++) {
    		exps[j].leftValue = leftValue + (new_g_by * ((exps[j].leftValue - prior_leftValue) / prior_g_by));
    		exps[j].rightValue = exps[j].leftValue + new_g_by;
    	}
    	for (var j = 0; j < exps.length; j++) {
    		value[j] = this.getRangeForExp(exps[j]);
    	}
    	if (!bIsArray) {
    		return value[0];
    	}
    	return value;    	
    },
    getKeyFromName: function(name) {
    	var s = name.split("|");
    	if (s.length > 0) {
    		if (s[0].indexOf("{") == 0) {
    			return " " + s[0];		// pad an opening curly brace with a space
    		}
    		return s[0];
    	}
    	return name;
    },
    getDisplayNameFromName: function(name) {
    	var s = name.split("|");
    	if (s.length == 2) {
    		return s[1];
    	} else if (s.length > 2) {
    		s.shift(); // remove first element
    		return s.join("|");  // rejoin remaining pieces
    	}
    	return name;
    },
    getParentHLayoutForPanel: function(oPanel) {
    	return oPanel.getParent();
    },
    getVerticalLayoutForPanel: function(oPanel) {
    	return sap.ui.getCore().byId(oPanel.sId + "_VertLayout");
    },
    getListBoxForPanel: function(oPanel) {
    	if (oPanel._type == 1 && !oPanel._groupBy) {
        	return sap.ui.getCore().byId(oPanel.sId + "_RangeListBox");
    	}
    	return sap.ui.getCore().byId(oPanel.sId + "_ListBox");
    },
    getOtherListBoxForPanel: function(oPanel) {
    	if (oPanel._type != 1) {
    		return null;
    	} 
		if (!oPanel._groupBy) {
        	return sap.ui.getCore().byId(oPanel.sId + "_ListBox");
    	}
    	return sap.ui.getCore().byId(oPanel.sId + "_RangeListBox");
    },
    getPanelForListBox: function(oListBox) {
    	return sap.ui.getCore().byId(oListBox.sId.substring(0, oListBox.sId.lastIndexOf("_"))); // remove the last _ and everything after
    },
    getRangeLabelsForPanel: function(oPanel) {
    	return sap.ui.getCore().byId(oPanel.sId + "_RangeLabels");
    },
    getRangeInputsForPanel: function(oPanel) {
    	return sap.ui.getCore().byId(oPanel.sId + "_RangeInputs");
    },
    getGroupSizeItemsForPanel: function(oPanel) {
    	return sap.ui.getCore().byId(oPanel.sId + "_GroupSizeItems");
    },
    getOperatorSelectForPanel: function(oPanel) {
    	return sap.ui.getCore().byId(oPanel.sId + "_OperatorSelect");
    },
    getOperatorInputForPanel: function(oPanel) {
    	return sap.ui.getCore().byId(oPanel.sId + "_OperatorInput");
    },
    toggleGroupBy: function(oPanel) {
    	var _this = this;
    	_this.hideCenteredMessage(_this.sId);
    	if (oPanel._groupBy) {
        	var vl = this.getVerticalLayoutForPanel(oPanel);
            vl.removeContent(5); 		//remove current list box
            setTimeout(function() {		// slight delay for current list box to disappear
        		oPanel._groupBy = false;
        		// remove doesn't work the 1st time, so add first then remove
            	oPanel.addStyleClass("groupBy");
            	oPanel.removeStyleClass("groupBy");
        		// remove doesn't work the 1st time, so add first then remove
        		sap.ui.getCore().byId(oPanel.sId + "_GroupByButton").addStyleClass("toggled");
        		sap.ui.getCore().byId(oPanel.sId + "_GroupByButton").removeStyleClass("toggled");
            	var ri = _this.getRangeInputsForPanel(oPanel);
            	ri.getContent()[0].setValue((isNaN(oPanel._from)) ? "" : sas.fscf.floatFormatter.format(oPanel._from));
            	ri.getContent()[1].setValue((isNaN(oPanel._to)) ? "" : sas.fscf.floatFormatter.format(oPanel._to));
            	var lbox = _this.getListBoxForPanel(oPanel);
                vl.insertContent(lbox, 5);	//insert other list box
                lbox.setEnabled( true );
            }, 100);
    	} else {
        	var vl = this.getVerticalLayoutForPanel(oPanel);
            vl.removeContent(5); 		//remove current list box
            setTimeout(function() {		// slight delay for current list box to disappear
	    		oPanel._groupBy = true;
	        	oPanel.addStyleClass("groupBy");
	   			sap.ui.getCore().byId(oPanel.sId + "_GroupByButton").addStyleClass("toggled");
            	var ri = _this.getRangeInputsForPanel(oPanel);
            	ri.getContent()[0].setValue((isNaN(oPanel._g_from)) ? "" : sas.fscf.floatFormatter.format(oPanel._g_from));
            	ri.getContent()[1].setValue((isNaN(oPanel._g_to)) ? "" : sas.fscf.floatFormatter.format(oPanel._g_to));
            	ri = _this.getGroupSizeItemsForPanel(oPanel);
            	ri.getContent()[1].setValue((isNaN(oPanel._g_by)) ? "" : sas.fscf.floatFormatter.format(oPanel._g_by));
	        	var lbox = _this.getListBoxForPanel(oPanel);
	            vl.insertContent(lbox, 5);	//insert other list box
	            lbox.setEnabled( true );
            }, 100);
   		}
    },
    togglePercentages: function(bPercentages) {
    	this._bPercentages = bPercentages;
    	var _this = this;
    	_this.refreshCenteredMessage();

    	// get all of the selections
    	var panel, lbox, selItems;
    	var allSelItems = [];

    	var panels = $("#"+this.getContent()[0].sId).find(".sapMPanel");
		for (var i = 0; i < panels.length; i++) {
			panel = sap.ui.getCore().byId(panels[i].id);
			if (!panel._isGroup) {
	    		lbox = _this.getListBoxForPanel(panel);
	    		selItems = lbox.getSelectedItems();
	    		allSelItems[allSelItems.length] = selItems;
			} else {
	    		allSelItems[allSelItems.length] = null;
			}
    	}
    	// re-bind
		for (var i = 0; i < panels.length; i++) {
			panel = sap.ui.getCore().byId(panels[i].id);
			if (!panel._isGroup) {
	    		lbox = _this.getListBoxForPanel(panel);
	    		if (panel._type != 1) {
	    			_this.bindAggregationListBox(lbox, panel);
	    		} else {	    			
		    		if (panel._groupBy) {
		    			_this.bindAggregationListBox(lbox, panel);
		    			var other_lbox = _this.getOtherListBoxForPanel(panel);
		    			if (other_lbox) {
			    			_this.bindAggregationRangeListBox(other_lbox, panel);
		    			}
		    		} else {
		    			_this.bindAggregationRangeListBox(lbox, panel);
		    			var other_lbox = _this.getOtherListBoxForPanel(panel);
		    			if (other_lbox) {
			    			_this.bindAggregationListBox(other_lbox, panel);
		    			}
		    		}
	    		}
			}
    	}
		// re-select what was selected before the re-bind
		for (var i = 0; i < panels.length; i++) {
			panel = sap.ui.getCore().byId(panels[i].id);
			if (!panel._isGroup) {
	    		lbox = _this.getListBoxForPanel(panel);
				for (var j = 0; j < allSelItems[i].length; j++) {
					key = allSelItems[i][j].getKey();
					for (var k = 0; k < lbox.getItems().length; k++) {
						if (lbox.getItems()[k].getKey() == key) {
							_this.selectListBoxItem(lbox, k);
							break;
						}
					}
				}
			}
    	}
    },

    customSetBusy: function(bBusy) {
    	if (!bBusy) {
    		this.setBusy(false);
    	} else {
    		// only set the busy on this if the parent is not already busy
    		if (!sap.ui.getCore().byId(this.sId.substr(0, this.sId.indexOf("GridView"))).isBusy()) {
    			this.setBusy(true);
    		}
    	}
    },

    SORT_BY_COUNT_DESCENDING: 0,
    SORT_BY_COUNT_ASCENDING: 1,
    SORT_BY_VALUE_DESCENDING: 2,
    SORT_BY_VALUE_ASCENDING: 3,
    SORT_BY_FRAUD_DESCENDING: 4,
    SORT_BY_FRAUD_ASCENDING: 5,

    getSortOrder: function() {
 		if (this._sortOrder == undefined) {
 			this._sortOrder = this.SORT_BY_COUNT_DESCENDING;
 		}
    	return this._sortOrder;
    },

    setSortOrder: function(sortOrder) {
    	if ((sortOrder == this.SORT_BY_COUNT_DESCENDING) ||
    		(sortOrder == this.SORT_BY_COUNT_ASCENDING) ||
    		(sortOrder == this.SORT_BY_VALUE_DESCENDING) ||
    		(sortOrder == this.SORT_BY_VALUE_ASCENDING) ||
    		(sortOrder == this.SORT_BY_FRAUD_DESCENDING) ||
    		(sortOrder == this.SORT_BY_FRAUD_ASCENDING)) {
        	this._sortOrder = sortOrder;
        	var panel, lbox, selItems, sorter, bFound, newItem;
        	var panels = $("#"+this.getContent()[0].sId).find(".sapMPanel");
			for (var i = 0; i < panels.length; i++) {
				panel = sap.ui.getCore().byId(panels[i].id);
				if (!panel._isGroup) {
					if (panel._type == 1) {
						continue;		// don't sort numerics
					}
		    		lbox = this.getListBoxForPanel(panel);

		        	// get all of the selections
		    		selItems = lbox.getSelectedItems();

		    		sorter = [this.getSelSorter(), this.getSorter(panel._variableType)];
		        	lbox.getBinding("items").sort(sorter);

		    		// re-select what was selected before the sort
	    			for (var j = 0; j < selItems.length; j++) {
	    				key = selItems[j].getKey();
	    				bFound = false;
	    				for (var k = 0; k < lbox.getItems().length; k++) {
	    					if (lbox.getItems()[k].getKey() == key) {
	    						this.selectListBoxItem(lbox, k);
	    						bFound = true;
	    						break;
	    					}
	    				}
	    				if (!bFound) {
	    					var newItem = new sap.ui.core.ListItem({
	                              key: key,
	                              text: selItems[j].getText(),
	                              additionalText: selItems[j].getAdditionalText()
	                        });
	    					lbox.addItem(newItem);
    						this.selectListBoxItem(lbox, lbox.indexOfItem(newItem));
	    				}
	    			}
				}
			}
        }
    },

    getSelSorter: function() {
    	var sorter;
		sorter = new sap.ui.model.Sorter("sel", true);
		sorter.fnCompare = function(a, b) {
            if (a == b) return 0;
			if (a == undefined || a < b) return -1;
            if (b == undefined || a > b) return  1;
		};
		return sorter;
    },

    getSorter: function(variableType) {
    	var sorter;
		switch (this.getSortOrder()) {
			case this.SORT_BY_VALUE_DESCENDING:
				sorter = new sap.ui.model.Sorter("name", true);
	        	if (variableType == "Numeric" || variableType == "Currency") {
					sorter.fnCompare = function(a, b) {
				    	var an = parseFloat(a);
				    	var bn = parseFloat(b);
			            if (an == bn) return 0;
						if (isNaN(an) || an < bn) return -1;
			            if (isNaN(bn) || an > bn) return  1;
					};
	        	}
				break;
			case this.SORT_BY_VALUE_ASCENDING:
				sorter = new sap.ui.model.Sorter("name", false);
	        	if (variableType == "Numeric" || variableType == "Currency") {
					sorter.fnCompare = function(a, b) {
				    	var an = parseFloat(a);
				    	var bn = parseFloat(b);
			            if (an == bn) return 0;
						if (isNaN(an) || an < bn) return -1;
			            if (isNaN(bn) || an > bn) return  1;
					};
	        	}
				break;
			case this.SORT_BY_FRAUD_DESCENDING:
				sorter = new sap.ui.model.Sorter("subSize", true);
				sorter.fnCompare = function(a, b) {
		            if (a == b) return 0;
					if (a == undefined || a < b) return -1;
		            if (b == undefined || a > b) return  1;
				};
				break;
			case this.SORT_BY_FRAUD_ASCENDING:
				sorter = new sap.ui.model.Sorter("subSize", false);
				sorter.fnCompare = function(a, b) {
		            if (a == b) return 0;
					if (a == undefined || a < b) return -1;
		            if (b == undefined || a > b) return  1;
				};
				break;
			case this.SORT_BY_COUNT_ASCENDING:
				sorter = new sap.ui.model.Sorter(this._bPercentages ? "pct" : "size", false);
				break;
			case this.SORT_BY_COUNT_DESCENDING:
			default:
				sorter = new sap.ui.model.Sorter(this._bPercentages ? "pct" : "size", true);
		}
		return sorter;
    },

    getServerErrorMessage: function() {
    	if (this.isExplore()) {
           	return sas.fscf.rb.getText("rules.rulesPage.guidedView.grid.ess.error.txt")
    	}
    	return sas.fscf.rb.getText("rules.rulesPage.guidedView.grid.tas.error.txt")
    },

    convertToFormattedNumber: function(str) {
    	var n = parseFloat(str);
    	if (!isNaN(n)) {
    		return sas.fscf.floatFormatter.format(n);
    	}
		return str;
    }
});
