var i=0;
var a=0;
var ruleFormSplitter1;
var ruleConditions = [];
var ruleModel = [];
var operatorSelectItems = [];
var inclusionSelectItems = [];

sap.ui.jsview("sas.fscf.views.Form", {

	_valid_numeric_key_codes: [13, 32, 44, 45, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 0, 8],
	
    getControllerName: function () {
        return "sas.fscf.views.Form";
    },

    createContent: function(oController) {
    	var _this = this;
    	this.addStyleClass("cfFormView");

    	var ruleExpressionsFormGrid = new sas.hc.ui.layout.VerticalLayout({
    		id: this.sId + '_RuleExpressionsFormGrid',
    		width: "100%",
    		content: []
		});

    	var ruleGuidedFormGrid = new sas.hc.ui.layout.VerticalLayout({
    			id: this.sId + '_RuleGuidedFormGrid',
    			width: "100%",
				visible: false,
				content: []
		});

    	_this.initSplitForm();

    	var ruleFormVerticalLayout = new sas.hc.ui.commons.layout.VerticalLayout({
   		    id: this.sId + '_RuleFormVerticalLayout',
   		    width: "100%",
            content: [
                ruleExpressionsFormGrid,
                ruleGuidedFormGrid
            ]
        });

        return ruleFormVerticalLayout;
    },

    printObject:function(o) {
    	  var out = '';
    	  for (var p in o) {
    	    out += p + ': ' + o[p] + '\n';
    	  }
    	  alert(out);
    },

    setAutoCompleteModel:function(fieldName,inputField){
    	var inputContent = "(" + fieldName + ":*" + inputField.getValue() + "*)";
    	sas.ajax({url:"rest/transactions/facets?q=" + inputContent + "&fields=" + fieldName + "&name=" + sas.fscf.getCurrentPageView().jsonRule.transactionTypeId + "&scope=" + sas.fscf.getCurrentPageView().jsonRule.multiOrgNodeId, dataType:"json", headers:sas.fscf.getAjaxHeaders()})
		.done(function(oData){
			if (oData[Object.keys(oData)[0]]) {
				if (oData[Object.keys(oData)[0]]['children']) {
					var data = oData[Object.keys(oData)[0]]['children'][0];
					var autoCompleteModel = new sap.ui.model.json.JSONModel(data);
					inputField.setModel(autoCompleteModel);
				}
			}
		}).fail(function(oObj,textStatus){
			console.log("Failed to get data");
		});
    	return inputField;
    },

    getFieldTypeComboBox: function(selectedField,forRange){
    	var _this = this;
    	jQuery.sap.require("sap.ui.model.Sorter");
    	jQuery.sap.require("sap.ui.model.Filter");
    	jQuery.sap.require("sap.ui.model.FilterOperator");

   		var fieldTypesModel = this.getPalette()._model;
    	fieldTypesModel.setSizeLimit(100000);

    	var fieldTypeComboBox = new sas.hc.m.ComboBox({
    		name: "fieldComboBox",
    		width:"300px"
    	});
    	// control is missing getSelectedItem function, so add it
    	fieldTypeComboBox.getSelectedItem = function() {
    		return sap.ui.getCore().byId(this.getSelectedItemId());
    	};

    	var charFilter = new sap.ui.model.Filter("variableType",
                           		                 sap.ui.model.FilterOperator.NE,
                           		                 "Character");
    	fieldTypeComboBox.bindAggregation("items", {
            path: "/items",
            factory: function(sId, oContext) {
                  var li = new sas.hc.ui.core.ListItem(sId, {
                        key: oContext.getProperty("id"),
                        text: oContext.getProperty("altName")
                  });
                  li._variableType = oContext.getProperty("variableType");
                  return li;
            },
            sorter: new sap.ui.model.Sorter("altName"),
            filters: (forRange) ? [charFilter] : []			// filter out Character fields for range
        });

    	fieldTypeComboBox.setModel(fieldTypesModel);
    	fieldTypeComboBox.setSelectedKey(selectedField);
    	fieldTypeComboBox.attachChange(function (oEvent) {
    		_this.somethingChangedInFullForm();
        });
    	fieldTypeComboBox.attachLiveChange(function (oEvent) {
    		fieldTypeComboBox.setValueState(sap.ui.core.ValueState.None);
        });
    	return fieldTypeComboBox;
    },

    getLocalizedItem: function(itemKey){
    	var localizedItem = new sas.hc.ui.core.Item({
        	  key: itemKey,
        	  text: sas.fscf.getLocalizedOperator(itemKey)
        });
    	return localizedItem;
    },
    
    getLocalizedItemVerbose: function(itemKey){
    	var localizedItem = new sas.hc.ui.core.Item({
        	  key: itemKey,
        	  text: sas.fscf.getLocalizedOperatorVerbose(itemKey)
        });
    	return localizedItem;
    },

    getOperatorSelect: function(selectedOperator,toolbarType){
    	var _this = this;
    	if(toolbarType == null){
    		toolbarType = "Numeric";
    	}
    	var operatorSelect = new sas.hc.m.Select({
			name:"expressionOperatorSelect",
    	});
    	if(toolbarType=="Numeric" || toolbarType=="Currency"){
    		_this.setNumericOperatorDropdown( operatorSelect );
    	}
    	else if(toolbarType=="Character"){
    		_this.setCharacterOperatorDropdown( operatorSelect );
    	}
    	else if(toolbarType=="Range"){
    		operatorSelect.setWidth("80px");
    		operatorSelect.addItem(_this.getLocalizedItem( sas.fscf.operators.LT ));
    		operatorSelect.addItem(_this.getLocalizedItem( sas.fscf.operators.LTE ));
    	}
    	if(selectedOperator!=null && selectedOperator!=""){
    		operatorSelect.setSelectedKey(selectedOperator);
    		operatorSelectItems[operatorSelect.getId()]=selectedOperator;
    	}
    	else{
    		operatorSelectItems[operatorSelect.getId()]=operatorSelect.getItems()[0].getKey();
    	}
    	operatorSelect.attachChange(function (oEvent) {
    		if(this.getSelectedKey()=="CUSTOM"){
    			_this.getFunctionDialog().open();
    		}
    		operatorSelectItems[this.getId()]=this.getSelectedKey();
    		_this.somethingChangedInFullForm();
        });
    	return operatorSelect;
    },

    setNumericOperatorDropdown: function( operatorSelect ) {
    	var ops = sas.fscf.getEqualOperators().concat( sas.fscf.getNumericOperators(), sas.fscf.getInOperators(), sas.fscf.getMissingOperators() );
		for( var i = 0; i < ops.length; i++ ) {
			operatorSelect.addItem( this.getLocalizedItem( ops[i] ) );
		}
    },
    setCharacterOperatorDropdown: function( operatorSelect ) {
    	var ops = sas.fscf.getEqualOperators().concat( sas.fscf.getInOperators(), sas.fscf.getFilteringOperators(), sas.fscf.getLookupListOperators() );
		for( var i = 0; i < ops.length; i++ ) {
			operatorSelect.addItem( this.getLocalizedItemVerbose( ops[i] ) );
		}
    },
    
    getOperatorText: function(selectedInclusion){
    	var operatorTextView = new sap.ui.commons.TextView({
        	  wrapping : false,
        	  text : sas.fscf.getLocalizedOperator(selectedInclusion)
    	});
    	return operatorTextView;
    },

    getMajorInclusionSelect: function(tId,selectedIncl,isNested){
    	var _this = this;
    	var inclSpacerWidth = "0px";//isNested?"30px":"0px";
    	var oInclusionSelect = new sas.hc.m.Select({
    		   name:"inclusionOperatorSelect",
    		   items: [
    		           new sas.hc.ui.core.Item({
    		        	   //id: this.sId + "inclusionSelect_all",
    		        	   key: "AND",
    		        	   text: sas.fscf.rb.getText("rules.rulesPage.guidedView.form.inclusionSets.all.txt")
    		           }),
    		           new sas.hc.ui.core.Item({
    		        	   //id: this.sId + "inclusionSelect_any",
    		        	   key: "OR",
    		        	   text: sas.fscf.rb.getText("rules.rulesPage.guidedView.form.inclusionSets.any.txt")
    		           }),
    		           new sas.hc.ui.core.Item({
    		        	   //id: this.sId + "inclusionSelect_none",
    		        	   key: "NOR",
    		        	   text: sas.fscf.rb.getText("rules.rulesPage.guidedView.form.inclusionSets.none.txt")
    		           }),
    		          ]
    	 });
    	oInclusionSelect.setSelectedKey(selectedIncl);
    	if(selectedIncl!=null && selectedIncl!=""){
    		inclusionSelectItems[oInclusionSelect.getId()]=selectedIncl;
    	} else {
    		inclusionSelectItems[oInclusionSelect.getId()]=oInclusionSelect.getSelectedKey();
    	}
    	oInclusionSelect.attachChange(function (oEvent) {
    		inclusionSelectItems[this.getId()]=this.getSelectedKey();
    		_this.somethingChangedInFullForm();
        });
    	var toolbarInclusionSelect = new sap.m.Toolbar({
    		content: [
    		          new sap.m.ToolbarSpacer({width:inclSpacerWidth}),
    		          oInclusionSelect
    		]
    	});
    	toolbarInclusionSelect._tId = tId;
    	if(isNested){
    		toolbarInclusionSelect.addStyleClass("nestedExpression");
    	}
    	if (tId == ("F-0" + _this.id_suffix)) {
    		toolbarInclusionSelect.addContent(
    		    new sap.m.ToolbarSpacer({
    		    	width: "30px"
    			})
    		);
    		toolbarInclusionSelect.addContent(
    			new sap.ui.commons.TextView({
    				semanticColor : sap.ui.commons.TextViewColor.Negative,
    				wrapping : false
    			})
    		);
    		toolbarInclusionSelect.addContent(
		      	new sap.m.ToolbarSpacer({
				})
		    );
    		toolbarInclusionSelect.addContent(
	      		new sap.m.Label({
	                text: sas.fscf.rb.getText("rules.rulesPage.guidedView.population.txt")
	    		})
	      	);
    		toolbarInclusionSelect.addContent(
				new sas.hc.m.ProgressIndicator({
				    id: _this.sId + 'FullFormPopulationIndicator',
				    width : "24%",
				    percentValue : 100,
				    displayValue : sas.fscf.percentFormatter.format(1),
				    showValue : true,
				    state: sap.ui.core.ValueState.None
				})
			);
    	}

    	//set name attribute
    	toolbarInclusionSelect.onAfterRendering = function() {
        	if (sap.m.Toolbar.prototype.onAfterRendering) {
        		sap.m.Toolbar.prototype.onAfterRendering.apply(this);
        	}
        	// must be set after rendering when the dom ref will exist
        	var ruleFormGrid = sap.ui.getCore().byId(_this.sId + '_RuleGuidedFormGrid');
        	if(ruleFormGrid.indexOfContent(toolbarInclusionSelect)!=-1){
        		toolbarInclusionSelect.getDomRef().setAttribute("name", toolbarInclusionSelect._tId);
        	}
    	};
    	toolbarInclusionSelect._isMajor = true;
    	return toolbarInclusionSelect;
    },

    getMajorInclusionText: function(selIncl,isNested){
    	var inclTextSpacerWidth = "0px";//isNested ? "30px" : "0px";
    	if(selIncl=="AND"){
    		selIncl = sas.fscf.rb.getText("rules.rulesPage.guidedView.form.inclusionSets.all.txt") + ":";
    	}
    	else if(selIncl=="OR"){
    		selIncl = sas.fscf.rb.getText("rules.rulesPage.guidedView.form.inclusionSets.any.txt") + ":";
    	}
    	else if(selIncl=="NOR"){
    		selIncl = sas.fscf.rb.getText("rules.rulesPage.guidedView.form.inclusionSets.none.txt") + ":";
    	}
    	var majorInclusionField = new sap.ui.commons.TextView({
        	  wrapping : false,
        	  text : selIncl
    	});
    	var toolbarInclusionText = new sap.m.Toolbar({
    		content: [
    		          new sap.m.ToolbarSpacer({width:inclTextSpacerWidth}),
    		          majorInclusionField
    		]
    	});
    	if(isNested){
    		toolbarInclusionText.addStyleClass("nestedExpressionSplitForm");
    	}
    	toolbarInclusionText._isMajor = true;
    	return toolbarInclusionText;
    },

    initForm: function(fullFormGrid){
    	var _this = this;

		var ruleModel = sas.fscf.getCurrentPageView().jsonRule.expressions.expressions[0].condition;
		var exs = ruleModel["expressions"];
    	var selectedInclusionOperator = ruleModel["type"];
    	fullFormGrid.addContent(_this.getMajorInclusionSelect("F-0" + _this.id_suffix,selectedInclusionOperator,false));
    	if(exs==null || exs == [] || exs==""){
    		fullFormGrid.addContent(_this.getToolbar("F-1" + _this.id_suffix,"",false,true));
    	}
    	else if(exs!=null && exs != []){
    		if(exs.length==0){
    			fullFormGrid.addContent(_this.getToolbar("F-1" + _this.id_suffix,"",false,true));
    		}
    		else {
        		for(var d=0;d<exs.length;d++){
        			var expressionType = exs[d]["type"];
        			if(expressionType!="OR" && expressionType!="AND" && expressionType!="NOR"){
        				if(d==0){
        					fullFormGrid.addContent(_this.getToolbar(exs[d]["id"] + _this.id_suffix,exs[d],false,true));
        				}
        				else{
        					fullFormGrid.addContent(_this.getToolbar(exs[d]["id"] + _this.id_suffix,exs[d],false));
        				}
        			}
        			else{
        				if(d==0){
        					fullFormGrid.addContent(_this.getToolbar("F-1" + _this.id_suffix,"",false,true));
        				}
        				var subSelectedInclusionOperator= exs[d]["type"];
        				fullFormGrid.addContent(_this.getMajorInclusionSelect(exs[d]["id"] + _this.id_suffix,subSelectedInclusionOperator,true));
        				var subExs = exs[d]["expressions"];
        				for(var s = 0; s < subExs.length; s++){
        					fullFormGrid.addContent(_this.getToolbar(subExs[s]["id"] + _this.id_suffix,subExs[s],true));
        				}
        			}
        		}
        	}
    	}
    	return fullFormGrid;
    },

    id_suffix: "_Toolbar",

    getRootId: function(id) {
    	return id.substr(0, id.length - this.id_suffix.length);
    },

    getNextId: function(tId){
    	var indices = this.getRootId(tId).split("-");
    	indices[indices.length - 1] = parseInt(indices[indices.length - 1]) + 1;
    	return indices.join("-") + this.id_suffix;
    },

    modifyIds: function(parent, startIndex, level, delta){
    	var toolbar;
    	var tId;
    	for (var i = startIndex; i < parent.getContent().length; i++) {
    		toolbar = parent.getContent()[i];
    		tId = toolbar._tId;
        	var indices = this.getRootId(tId).split("-");
        	if (level > indices.length - 1) {
        		return;
        	}
        	indices[level] = parseInt(indices[level]) + delta;
    		tId = indices.join("-") + this.id_suffix;
    		toolbar._tId = tId;
    	}
    },

    modifyModelIds: function(parent, startIndex, level, delta){
    	var id;
    	for (var i = startIndex; i < parent.length; i++) {
    		id = parent[i].id;
        	var indices = id.split("-");
        	if (level > indices.length - 1) {
        		return;
        	}
        	indices[level] = parseInt(indices[level]) + delta;
    		id = indices.join("-");
    		parent[i].id = id;
    		// get sub-groups if there are any
			if ((parent[i]["type"] == "OR") || (parent[i]["type"] == "AND") || (parent[i]["type"] == "NOR")) {
   				this.modifyModelIds(parent[i].expressions, 0, level, delta);
			}
    	}
    },

    initSplitForm: function(){
    	var _this = this;
    	var splitFormGrid = sap.ui.getCore().byId(this.sId + "_RuleExpressionsFormGrid");
    	var ruleModel = sas.fscf.getCurrentPageView().jsonRule.expressions.expressions[0].condition;
    	var exs = ruleModel["expressions"];
    	var selIncl = ruleModel["type"];
    	splitFormGrid.destroyContent();
    	if(exs!=null && exs!=[] && exs!=""){
    		splitFormGrid.addContent(_this.getMajorInclusionText(selIncl,false));
    	}
    	for(var i = 0; i < exs.length; i++){
    		var expressionType = exs[i]["type"];
        	if(expressionType!="OR" && expressionType!="AND" && expressionType!="NOR"){
        		splitFormGrid.addContent(this.getRuleExpressionToolbar(exs[i]["id"] + this.id_suffix,exs[i],false));
        	} else {
        		var subExs = exs[i]["expressions"];
        		var subSelIncl = exs[i]["type"];
        		splitFormGrid.addContent(_this.getMajorInclusionText(subSelIncl,true));
    	    	for(var j = 0; j < subExs.length; j++){
    	    		splitFormGrid.addContent(this.getRuleExpressionToolbar(subExs[j]["id"] + this.id_suffix,subExs[j],true));
    	    	}
        	}
    	}
    	return splitFormGrid;
    },

    getFunctionDialog: function(toolbar,modButton){
    	var oDialog = new sas.hc.m.Dialog({
        	title: sas.fscf.rb.getText('rules.rulesPage.guidedView.form.modifiers.additionalModifiers.txt'),
        	width: "200px",
    	    content: [
    	              new sas.hc.ui.layout.Grid({
      	  				hSpacing: 1,
      	  				vSpacing: 1,
      	  				content: [
      	  				      ignoreCaseCB = new sas.hc.ui.commons.CheckBox({
      	  				       	  	text : sas.fscf.rb.getText('rules.rulesPage.guidedView.form.modifiers.ignoreCase.txt'),
      	  				       	  	checked : (toolbar._modifiers.indexOf("IC") != -1),
      	  				       	  	layoutData : new sap.ui.layout.GridData({
      	  				       	  		span : "L8 M8 S8",
      	  				       	  		linebreakL: true,
      	  				       	  		linebreakM: true,
      	  				       	  		linebreakS: true
      	  				       	  	}),
      	  				       	  	change : function() {
      	  				       	  		if(ignoreCaseCB.getChecked()){
      	  				       	  			toolbar._modifiers.push("IC");
      	  				       	  		}
      	  				       	  		else{
      	  				       	  			var index = toolbar._modifiers.indexOf("IC");
      	  				       	  			toolbar._modifiers.splice(index,1);
      	  				       	  		}
      	  				       	  	}
      	  				      }),
      	  				      compressCB = new sas.hc.ui.commons.CheckBox({
	  				       	  		text : sas.fscf.rb.getText('rules.rulesPage.guidedView.form.modifiers.ignoreWhiteSpace.txt'),
	  				       	  		checked : (toolbar._modifiers.indexOf("CM") != -1),
	  				       	  		layoutData : new sap.ui.layout.GridData({
	  				       	  			span : "L8 M8 S8",
	  				       	  			linebreakL: true,
	  				       	  			linebreakM: true,
	  				       	  			linebreakS: true
	  				       	  		}),
	  				       	  		change : function() {
	  				       	  			if(compressCB.getChecked()){
	  				       	  				toolbar._modifiers.push("CM");
	  				       	  			}else{
	  				       	  				var index = toolbar._modifiers.indexOf("CM");
	  				       	  				toolbar._modifiers.splice(index,1);
	  				       	  			}
	  				       	  		}
      	  				      }),
	    	    ],
    	    }),
    	    ],
    	    leftButton: new sas.hc.m.Button({
    	    	text: sas.fscf.rb.getText('fcm.application.ok.txt'),
    	        press: function() {
    	        	sas.fscf.removeAllMessageStrips();
    	        	sas.fscf.getCurrentPageView().setDirty(true);
    	        	if(toolbar._modifiers.length>0){
    	        		modButton.setIcon("sap-icon://hc/attributes");
    	        		//modButton.setPressed(true);
    	        	}
    	        	else{
    	        		modButton.setIcon("sap-icon://hc/file");
    	        		//modButton.setPressed(false);
    	        	}
    	        	oDialog.close();
    	        }
    	    })
        });
    	return oDialog;
    },
    
    putLookupListsInComboBox: function( comboBox ) {
    	//comboBox as a combo box item
    	var keyField;
    	var _this = this;
    	
    	if( !comboBox || !comboBox.oParent || !comboBox.oParent.sId )
			return;

		//find out what key field is
    	var oParent = sap.ui.getCore().byId( comboBox.oParent.sId );
    	for( var i = 0; i < oParent.mAggregations.content.length; i++ ) {
    		//apparently .includes doesn't work in IE
    		//if( oParent.mAggregations.content[i].sId.includes( "box" ) && oParent.mAggregations.content[i].sId != comboBox.sId ) {
    		if( oParent.mAggregations.content[i].sId.indexOf( "box" ) > -1 && oParent.mAggregations.content[i].sId != comboBox.sId ) {
    			keyField = oParent.mAggregations.content[i].mProperties.value;
    			break; 
    		}
    	}
    	
    	_this.getLookupListsForBox( comboBox, keyField );
    },

    getToolbar: function(tId,expressionArr,isNested,firstToolbar,expressionType){
    	var _this = this;
    	var ruleFormGuidedToolbar = i+"ruleFormGuidedToolbar";
    	var spacerWidth = "30px";
    	i++;
    	var ruleFormGrid = sap.ui.getCore().byId(this.sId + '_RuleGuidedFormGrid');
    	var fieldSelect = i+"fieldSelect";
    	var operatorSelect = i+"operatorSelect";
    	var addModifiersButton = i+"addModifiersButton";
    	var criteriaInput = i+"criteriaInput";
    	var errorTextView = i+"errorTextView";
    	var multiInputSelect = i+"multiInputSelect";
    	var comboBoxInputSelect = i+"comboBoxInputSelect";
    	var leftOperatorSelect, rightOperatorSelect, addConditionButton, addFieldMenuItem, addRangeMenuItem, deleteFieldButton, addNestedRuleButton;

    	if(!expressionType){expressionType=expressionArr["type"];}

    	if(expressionType!="RANGE"){
    		ruleFormGuidedToolbar = new sap.m.Toolbar({
    			content: [
    			      toolbarSpacer = new sap.m.ToolbarSpacer({width:spacerWidth}),

	                  fieldSelect = this.getFieldTypeComboBox(expressionArr["fieldId"]),

	                  operatorSelect = this.getOperatorSelect(expressionArr["operator"],expressionArr["fieldType"]),

	                  addModifiersButton =  new sas.hc.m.Button({
	                	  icon: "sap-icon://hc/file",
	                	  tooltip: "Add Modifiers",
	                	  visible: (expressionArr["fieldType"] == "Character" && sas.fscf.getCurrentPageView().isDevEnv == "true") ? true : false,
	                	  press: function() {
	                		  _this.getFunctionDialog(ruleFormGuidedToolbar,addModifiersButton).open();
	                	  }
	                  }),

	                  criteriaInput = new sas.hc.m.Input({
	                	name : "valueInput",
	                	maxLength : 50,
	                	width : "220px",
	                	showSuggestion: true,
	      				type: (expressionArr["fieldType"] == "Currency" || expressionArr["fieldType"] == "Numeric") ? sap.m.InputType.Number : sap.m.InputType.Text,
	  	                value : (expressionArr["fieldType"] == "Currency" || expressionArr["fieldType"] == "Numeric") && expressionArr["value"]!=null ? sas.fscf.floatFormatter.format(expressionArr["value"]) : expressionArr["value"],
	  	                enabled : fieldSelect.getSelectedItem() == undefined? false : true,
	      				displaySecondaryValues: true,
	      				suggestionItems: {
	      					path: "/children",
	      					template: new sap.ui.core.Item({text: "{name}"})
	      				}
	      			  }),
	      			  
	      			  comboBoxInputSelect = new sas.hc.m.ComboBox({
	      	    		name: "comboBoxInputSelect",
	      	    		width: "220px",
	      	    		openDropdownOnInput: true,
	      	    		inlineAutocomplete: true
	      	    	  }),

	                  multiInputSelect = new sas.hc.m.MultiInput({
	                	  name : "multiInputSelect",
	                	  width : "500px"
	                  }).addStyleClass("cfEmptyMultiInput"),

	                  addConditionButton = new sas.hc.m.MenuButton({
	                	  icon : "sap-icon://hc/add",
	                	  tooltip : sas.fscf.rb.getText("rules.rulesPage.guidedView.form.addCondition.txt"),
	                      showDownArrowIconOnly: true,
	                	  menu: new sas.hc.m.Menu({
	                          items: [
	                              addFieldMenuItem = new sas.hc.m.MenuItem({
	                                  text: sas.fscf.rb.getText("rules.rulesPage.guidedView.form.simpleCondition.txt"),
	        	                	  press: function() {
	        	                	  	  var nextId = _this.getNextId(ruleFormGuidedToolbar._tId);
	        	                		  _this.modifyIds(ruleFormGrid, (ruleFormGrid.indexOfContent(ruleFormGuidedToolbar))+1, isNested ? 2 : 1, 1);
	        	                		  if(!isNested){
	        	                			  ruleFormGrid.insertContent(
	        	                				_this.getToolbar(nextId,"",false),(ruleFormGrid.indexOfContent(ruleFormGuidedToolbar))+1
	        	                			  );
	        	                		  }
	        	                		  else{
	        	                			  ruleFormGrid.insertContent(
	  	        	                			_this.getToolbar(nextId,"",true),(ruleFormGrid.indexOfContent(ruleFormGuidedToolbar))+1
	  	        	                		  );
	        	                		  }
	        	                	  }
	                              }),
	                              addRangeMenuItem = new sas.hc.m.MenuItem({
	                                  text: sas.fscf.rb.getText("rules.rulesPage.guidedView.form.rangeCondition.txt"),
	        	                	  press: function() {
	        	                	  	  var nextId = _this.getNextId(ruleFormGuidedToolbar._tId);
	        	                		  _this.modifyIds(ruleFormGrid, (ruleFormGrid.indexOfContent(ruleFormGuidedToolbar))+1, isNested ? 2 : 1, 1);
	        	                		  if(!isNested){
	        	                			  ruleFormGrid.insertContent(
	        	                				_this.getToolbar(nextId,"",false,false,"RANGE"),(ruleFormGrid.indexOfContent(ruleFormGuidedToolbar))+1
	        	                			  );
	        	                		  }
	        	                		  else{
	        	                			  ruleFormGrid.insertContent(
	        	  	                			_this.getToolbar(nextId,"",true,false,"RANGE"),(ruleFormGrid.indexOfContent(ruleFormGuidedToolbar))+1
	        	  	                		  );
	        	                		  }
	        	                	  }
	                              })
	                          ]
	                      })
	                   }),

	                  deleteFieldButton =  new sas.hc.m.Button({
	                	  icon : "sap-icon://hc/delete",
	                	  //enabled : !firstToolbar,
	                	  press: function() {
	                		  _this.handleDelete(ruleFormGuidedToolbar, ruleFormGrid);
	                	  }
	                  }),

	                  addNestedRuleButton =  new sas.hc.m.Button({
	                	  //text : "Nested Group" sas.fscf.rb.getText("rules.rulesPage.guidedView.form.nested.txt"),
	                	  icon : "sap-icon://hc/nestedGroup",
	                	  visible : !isNested,
	                	  press: function() {
	                	  	  var nextId = _this.getNextId(ruleFormGuidedToolbar._tId);
	                		  _this.modifyIds(ruleFormGrid, (ruleFormGrid.indexOfContent(ruleFormGuidedToolbar))+1, isNested ? 2 : 1, 1);
	                		  ruleFormGrid.insertContent(
	                			  _this.getMajorInclusionSelect(nextId,"OR",true),(ruleFormGrid.indexOfContent(ruleFormGuidedToolbar))+1
	                		  );
	                		  ruleFormGrid.insertContent(
		                		  _this.getToolbar(_this.getRootId(nextId) + "-" + 1 + _this.id_suffix,"",true),(ruleFormGrid.indexOfContent(ruleFormGuidedToolbar))+2
		                	  );
	                	  }
	                  }),

	                  errorTextView = new sap.ui.commons.TextView({
	            		  semanticColor : sap.ui.commons.TextViewColor.Negative,
	                	  wrapping : false
	                  })
	               ]
    		});
    		if(expressionArr["modifiers"]){ruleFormGuidedToolbar._modifiers = expressionArr["modifiers"];}else{ruleFormGuidedToolbar._modifiers = [];}
    		multiInputSelect.addValidator(function(args){
    			_this.somethingChangedInFullForm();
    			multiInputSelect.setValueState(sap.ui.core.ValueState.None);
    			var inputText = multiInputSelect.getValue();
    			if(fieldSelect.getSelectedItem()._variableType=="Numeric" || fieldSelect.getSelectedItem()._variableType=="Currency"){
    				if(isNaN(sas.fscf.floatFormatter.parse(inputText))){
    					multiInputSelect.setValueState(sap.ui.core.ValueState.Error);
    					multiInputSelect.setValueStateText(sas.fscf.rb.getText("rules.rulesPage.guidedView.form.inputValueNumber.error.txt"));
    					return;
    				}
    			}
    			return new sas.hc.m.Token({key:(expressionArr["fieldType"] == "Currency" || expressionArr["fieldType"] == "Numeric") ? "" + sas.fscf.floatFormatter.parse(inputText) : inputText, text:inputText}).attachDelete(_this.handleTokenDelete);
			});
    		multiInputSelect.attachTokenUpdate(function(oEvent) {
    			_this.updateMultiInputClass(multiInputSelect);
    			
    			if( multiInputSelect.getTokens().length > 0 ) {
    			    criteriaInput.setValue( multiInputSelect.getTokens()[0].getText() );
    			} else {
    			    criteriaInput.setValue( "" );
    			}
    			
    		    _this.somethingChangedInFullForm();
    		    
    		    if( oEvent.getParameters().type == "removed" ) {
    		    	oEvent.oSource.focus();
    		    }
    		});

    		if( sas.fscf.isMissingOperator( operatorSelect.getSelectedKey() ) ){
    			criteriaInput.setVisible(false);
    			multiInputSelect.setVisible(false);
    			comboBoxInputSelect.setVisible(false);
    		}
    		else if(sas.fscf.isMultivalueOperator(operatorSelect.getSelectedKey())){
				criteriaInput.setVisible(false);
				comboBoxInputSelect.setVisible(false);
				multiInputSelect.setVisible(true);
				multiInputSelect.setEnabled(true);
				var inputArray = expressionArr["values"];
				for(var k = 0; k < inputArray.length; k++){
					if( inputArray[k].trim() != "" ) {
						multiInputSelect.addToken(new sas.hc.m.Token({key: inputArray[k], text:(expressionArr["fieldType"] == "Currency" || expressionArr["fieldType"] == "Numeric") ? sas.fscf.floatFormatter.format(inputArray[k]) : inputArray[k]}).attachDelete(_this.handleTokenDelete));
					}
				}
				_this.updateMultiInputClass(multiInputSelect);
				
				if( inputArray.length > 0 ) {
				    criteriaInput.setValue( inputArray[0] );
			    }
			}
    		else if(sas.fscf.isLookupListOperator(operatorSelect.getSelectedKey())){
    			comboBoxInputSelect.setVisible(true);
    			comboBoxInputSelect.setEnabled(true);
    			multiInputSelect.setVisible(false);
    			criteriaInput.setVisible(false);
    			
    			if( comboBoxInputSelect.getValue() == "" || comboBoxInputSelect.getValue() == null || comboBoxInputSelect.getValue() == undefined ) {
					comboBoxInputSelect.setValue( criteriaInput.getValue() );
				}
    		}
    		else{
    			criteriaInput.setVisible(true);
    			criteriaInput.setEnabled(true);
				multiInputSelect.setVisible(false);
				comboBoxInputSelect.setVisible(false);
				
				multiInputSelect.removeAllTokens();
				multiInputSelect.addToken(
				new sas.hc.m.Token({
				    key: criteriaInput.getValue().trim(),
				    text: criteriaInput.getValue().trim()
				}).attachDelete(_this.handleTokenDelete));
				_this.updateMultiInputClass( multiInputSelect );
    		}

    		fieldSelect.attachChange(function (oEvent) {
    			errorTextView.setText("");
    			if(fieldSelect.getSelectedItem()==undefined){
    				criteriaInput.setEnabled(false);
    				multiInputSelect.setEnabled(false);
    			}
    			else{
    				operatorSelect.removeAllItems();

        	         if(fieldSelect.getSelectedItem()._variableType=="Numeric" || fieldSelect.getSelectedItem()._variableType=="Currency"){
        	        	 addModifiersButton.setVisible(false);
        	        	 criteriaInput.setType(sap.m.InputType.Number);
        	        	 _this.setNumericOperatorDropdown( operatorSelect );
        	        	 operatorSelect.setSelectedKey(operatorSelect.getItems()[0].getKey());

        	        	 if (criteriaInput.getValue().match(/[a-z]/i)) {
         				     // characters found
        	        		 errorTextView.setText(sas.fscf.rb.getText("rules.rulesPage.guidedView.form.inputValueNumber.error.txt"));
        					 criteriaInput.setValueState(sap.ui.core.ValueState.Error);
        					 criteriaInput.setValue("");
         				}
        	         }
        	         else if(fieldSelect.getSelectedItem()._variableType=="Character"){
        	        	 if(sas.fscf.getCurrentPageView().isDevEnv == "true"){
        	        		 addModifiersButton.setVisible(true);
        	        	 }
        	        	 criteriaInput.setType(sap.m.InputType.Text);
        	        	 _this.setCharacterOperatorDropdown( operatorSelect );
        	        	 operatorSelect.setSelectedKey(operatorSelect.getItems()[0].getKey());
        	         }
        	         if( sas.fscf.isMissingOperator( operatorSelect.getSelectedKey() ) ){
    	    			criteriaInput.setVisible(false);
    	    			multiInputSelect.setVisible(false);
    	    			comboBoxInputSelect.setVisible(false);
    	    		} else {
    	    			criteriaInput.setVisible(true);
    	    			criteriaInput.setEnabled(true);
    					multiInputSelect.setVisible(false);
    					comboBoxInputSelect.setVisible(false);
    	    		}
    			}
       		});
    		operatorSelect.attachChange(function (oEvent) {
    			if( sas.fscf.isMissingOperator( operatorSelect.getSelectedKey() ) ) {
    				//operatorSelect.setWidth("308px");
    				criteriaInput.setValue("");
    				criteriaInput.setVisible(false);
    				multiInputSelect.removeAllTokens();
    				multiInputSelect.setVisible(false);
    				comboBoxInputSelect.setValue("");
    				comboBoxInputSelect.setSelectedKey("");
    				comboBoxInputSelect.setVisible(false);
    			}
    			else if(sas.fscf.isMultivalueOperator(operatorSelect.getSelectedKey())){
    				//operatorSelect.setWidth("100px");
    				criteriaInput.setVisible(false);
    				multiInputSelect.setVisible(true);
    				multiInputSelect.setEnabled(true);
    				comboBoxInputSelect.setVisible(false);
    			}
    			else if(sas.fscf.isLookupListOperator(operatorSelect.getSelectedKey())){
    				comboBoxInputSelect.setVisible(true);
    				comboBoxInputSelect.setEnabled(true);
    				criteriaInput.setVisible(false);
    				multiInputSelect.setVisible(false);
    				_this.putLookupListsInComboBox( comboBoxInputSelect );
    			}
    			else{
    				//operatorSelect.setWidth("100px");
    				criteriaInput.setVisible(true);
    				criteriaInput.setEnabled(true);
    				multiInputSelect.setVisible(false);
    				comboBoxInputSelect.setVisible(false);
    			}
    		});
    		criteriaInput.onkeydown = function(event) { // S1382385
				if (event.keyCode === jQuery.sap.KeyCodes.TAB) {
    	        	let suggestionPopup = criteriaInput._oSuggestionPopup;
    	        	if (suggestionPopup && suggestionPopup.isOpen()) { 	        			
    	        		suggestionPopup.close();
    	        	}
    		    } else {
    		    	sas.hc.m.Input.prototype.onkeydown.apply(this, arguments);
    			}
    		};		
    		var typingTimer;
			var doneTypingInterval = 1000;		
    		criteriaInput.attachBrowserEvent("input", function(e) {
    			errorTextView.setText("");
    			clearTimeout(typingTimer);
    			typingTimer = setTimeout(function() {
        			_this.setAutoCompleteModel(fieldSelect.getValue(), criteriaInput);
    			}, doneTypingInterval);
    			//criteriaInput.setValueState(sap.ui.core.ValueState.None);
    			if(fieldSelect.getSelectedItem()==undefined){
    				errorTextView.setText(sas.fscf.rb.getText("rules.rulesPage.guidedView.form.variableNotSelected.error.txt"));
					criteriaInput.setValueState(sap.ui.core.ValueState.Error);
					e.preventDefault();
    			}
    			else if(fieldSelect.getSelectedItem()._variableType=="Numeric" || fieldSelect.getSelectedItem()._variableType=="Currency"){
					if (!($.inArray(e.which, _this._valid_numeric_key_codes) >= 0)) {
						errorTextView.setText(sas.fscf.rb.getText("rules.rulesPage.guidedView.form.inputValueNumber.error.txt"));
						criteriaInput.setValueState(sap.ui.core.ValueState.Error);
						e.preventDefault();
					}
    			}
            });
       		criteriaInput.attachChange(function (oEvent) {
       			if(criteriaInput.getValue().trim()!=""){
       			    multiInputSelect.removeAllTokens();
       			    multiInputSelect.addToken(
       			    new sas.hc.m.Token({
       			        key: criteriaInput.getValue().trim(),
       			        text: criteriaInput.getValue().trim()
       			    }).attachDelete(_this.handleTokenDelete));
       			    _this.updateMultiInputClass( multiInputSelect );
       			    
       			    _this.somethingChangedInFullForm();
       			} else {
       			    multiInputSelect.removeAllTokens();
       			}
       		});
       		comboBoxInputSelect.attachChange(function (oEvent) {
    			if(comboBoxInputSelect.getValue().trim()!=""){
           			_this.somethingChangedInFullForm();
           		}
       		});
    	} else {
    		var leftInput, rightInput;
    		ruleFormGuidedToolbar = new sap.m.Toolbar({
    	        content: [
    	                  toolbarSpacer = new sap.m.ToolbarSpacer({width:spacerWidth}),

    	                  leftInput = new sas.hc.m.Input({
    	                	  name:"leftValueInput",
    	                	  maxLength : 50,
    	                	  width : "220px",
    	                      type: sap.m.InputType.Number,
    	                      // S1411860, S1409697
    	                      // Unlike the Form Editor in the Palette View, with the standalone Form Editor here "leftValue" 
    	                      // may not be defined, eg. clicking + > Range Condition.  So it's necessary to check to make sure
    	                      // "leftValue" is a number (including 0) before calling the formatter to format it.  Otherwise,
    	                      // set the value to an empty string.
    	                      // Same applies to "rightValue" below.
    	                	  value: $.isNumeric(expressionArr["leftValue"]) ? sas.fscf.floatFormatter.format(expressionArr["leftValue"]) : "",
    	                  }),

    	                  leftOperatorSelect = this.getOperatorSelect(expressionArr["leftOperator"] ? expressionArr["leftOperator"] : "LT","Range"),

    	                  fieldSelect = this.getFieldTypeComboBox(expressionArr["fieldId"],true),

    	                  rightOperatorSelect = this.getOperatorSelect(expressionArr["rightOperator"] ? expressionArr["rightOperator"] : "LT","Range"),

    	                  rightInput = new sas.hc.m.Input({
    	                	  name:"rightValueInput",
    	                	  maxLength : 50,
    	                	  width : "220px",
    	                      type: sap.m.InputType.Number,
    	                	  value: $.isNumeric(expressionArr["rightValue"]) ? sas.fscf.floatFormatter.format(expressionArr["rightValue"]) : "",
    	                  }),

    	                  addConditionButton = new sas.hc.m.MenuButton({
    	                	  icon : "sap-icon://hc/add",
    	                	  tooltip : sas.fscf.rb.getText("rules.rulesPage.guidedView.form.addCondition.txt"),
    	                      showDownArrowIconOnly: true,
    	                	  menu: new sas.hc.m.Menu({
    	                          items: [
    	                              addFieldMenuItem = new sas.hc.m.MenuItem({
    	                                  text: sas.fscf.rb.getText("rules.rulesPage.guidedView.form.simpleCondition.txt"),
    	                                  press: function() {
    	        	                	  	  var nextId = _this.getNextId(ruleFormGuidedToolbar._tId);
    	        	                		  _this.modifyIds(ruleFormGrid, (ruleFormGrid.indexOfContent(ruleFormGuidedToolbar))+1, isNested ? 2 : 1, 1);
    	        	                		  if(!isNested){
    	        	                			  ruleFormGrid.insertContent(
    	        	                				_this.getToolbar(nextId,"",false),(ruleFormGrid.indexOfContent(ruleFormGuidedToolbar))+1
    	        	                			  );
    	        	                		  } else{
    	        	                			  ruleFormGrid.insertContent(
    	        	  	                			_this.getToolbar(nextId,"",true),(ruleFormGrid.indexOfContent(ruleFormGuidedToolbar))+1
    	        	  	                		  );
    	        	                		  }
    	        	                	  }
    	                              }),
    	                              addRangeMenuItem = new sas.hc.m.MenuItem({
    	                                  text: sas.fscf.rb.getText("rules.rulesPage.guidedView.form.rangeCondition.txt"),
    	                                  press: function() {
    	        	                	  	  var nextId = _this.getNextId(ruleFormGuidedToolbar._tId);
    	        	                		  _this.modifyIds(ruleFormGrid, (ruleFormGrid.indexOfContent(ruleFormGuidedToolbar))+1, isNested ? 2 : 1, 1);
    	        	                		  if(!isNested){
    	        	                			  ruleFormGrid.insertContent(
    	        	                				_this.getToolbar(nextId,"",false,false,"RANGE"),(ruleFormGrid.indexOfContent(ruleFormGuidedToolbar))+1
    	        	                			  );
    	        	                		  } else{
    	        	                			  ruleFormGrid.insertContent(
    	        	  	                			_this.getToolbar(nextId,"",true,false,"RANGE"),(ruleFormGrid.indexOfContent(ruleFormGuidedToolbar))+1
    	        	  	                		  );
    	        	                		  }
    	        	                	  }
    	                              })
    	                          ]
    	                      })
    	                   }),
    	                  deleteFieldButton =  new sas.hc.m.Button({
    	                	  icon : "sap-icon://hc/delete",
    	                	  press: function() {
    	                		  _this.handleDelete(ruleFormGuidedToolbar, ruleFormGrid);
    	                	  }
    	                  }),
    	                  addNestedRuleButton =  new sas.hc.m.Button({
    	                	  //text : "Nested Group",//sas.fscf.rb.getText("rules.rulesPage.guidedView.form.nested.txt"),
    	                	  icon : "sap-icon://hc/nestedGroup",
    	                	  visible : !isNested,
    	                	  press: function() {
    	                	  	  var nextId = _this.getNextId(ruleFormGuidedToolbar._tId);
    	                		  _this.modifyIds(ruleFormGrid, (ruleFormGrid.indexOfContent(ruleFormGuidedToolbar))+1, isNested ? 2 : 1, 1);
    	                		  ruleFormGrid.insertContent(
    	                			  _this.getMajorInclusionSelect(nextId,"OR",true),(ruleFormGrid.indexOfContent(ruleFormGuidedToolbar))+1
    	                		  );
    	                		  ruleFormGrid.insertContent(
    		                		  _this.getToolbar(_this.getRootId(nextId) + "-" + 1 + _this.id_suffix,"",true),(ruleFormGrid.indexOfContent(ruleFormGuidedToolbar))+2
    		                	  );
    	                	  }
    	                  })
    	              ]
        		});

       		leftInput.attachChange(function (oEvent) {
				if ((sas.fscf.floatFormatter.parse(oEvent.mParameters.newValue) > sas.fscf.floatFormatter.parse(rightInput.getValue())) &&
				    (this.getValueState() != sap.ui.core.ValueState.Error)) {
					// swap to right if greater than right
					var temp = rightInput.getValue();
					rightInput.setValue(oEvent.mParameters.newValue);
					leftInput.setValue(temp);
				}
           		_this.somethingChangedInFullForm();
       		});
       		leftInput.attachLiveChange(function (oEvent) {
				if (sas.fscf.floatFormatter.parse(leftInput.getValue()) == sas.fscf.floatFormatter.parse(rightInput.getValue())) {
					leftInput.setValueStateText(sas.fscf.rb.getText("rules.rulesPage.guidedView.form.rangeValueSame.error.txt"));
					leftInput.setValueState(sap.ui.core.ValueState.Error);
					leftInput.openValueStateMessage();
				}
       		});
       		rightInput.attachChange(function (oEvent) {
				if ((sas.fscf.floatFormatter.parse(oEvent.mParameters.newValue) < sas.fscf.floatFormatter.parse(leftInput.getValue())) &&
					(this.getValueState() != sap.ui.core.ValueState.Error)) {
					// swap to left if less than left
					var temp = leftInput.getValue();
					leftInput.setValue(oEvent.mParameters.newValue);
					rightInput.setValue(temp);
				}
           		_this.somethingChangedInFullForm();
       		});
       		rightInput.attachLiveChange(function (oEvent) {
				if (sas.fscf.floatFormatter.parse(leftInput.getValue()) == sas.fscf.floatFormatter.parse(rightInput.getValue())) {
					rightInput.setValueStateText(sas.fscf.rb.getText("rules.rulesPage.guidedView.form.rangeValueSame.error.txt"));
					rightInput.setValueState(sap.ui.core.ValueState.Error);
					rightInput.openValueStateMessage();
				}
				sas.fscf.removeAllMessageStrips();
				sas.fscf.getCurrentPageView().setDirty(true);
       		});
       		//Might be a way to prevent text from being entered using UI5 methods instead of the following javascript
       		leftInput.attachBrowserEvent("keypress", function(e) {
                if (!($.inArray(e.which, _this._valid_numeric_key_codes) >= 0)) {
                    e.preventDefault();
                    leftInput.setValueStateText(sas.fscf.rb.getText("rules.rulesPage.guidedView.form.inputValueNumber.error.txt"));
					leftInput.setValueState(sap.ui.core.ValueState.Error);
                }
            });
       		rightInput.attachBrowserEvent("keypress", function(e) {
                if (!($.inArray(e.which, _this._valid_numeric_key_codes) >= 0)) {
                    e.preventDefault();
                    rightInput.setValueStateText(sas.fscf.rb.getText("rules.rulesPage.guidedView.form.inputValueNumber.error.txt"));
					rightInput.setValueState(sap.ui.core.ValueState.Error);
                }
            });
    	}
    	ruleFormGuidedToolbar._isNested = isNested;
    	ruleFormGuidedToolbar._tId = tId;
    	if(isNested){
    		ruleFormGuidedToolbar.addStyleClass("nestedExpression");
    	}

    	//set any name attributes that need to be set
    	ruleFormGuidedToolbar.onAfterRendering = function() {
        	if (sap.m.Toolbar.prototype.onAfterRendering) {
        		sap.m.Toolbar.prototype.onAfterRendering.apply(this);
        	}
        	// must be set after rendering when the dom ref will exist
        	ruleFormGuidedToolbar.getDomRef().setAttribute("name", ruleFormGuidedToolbar._tId);
        	if(isNested){
        		var myElements = document.querySelectorAll(".nestedExpression.sapMIBar.sapMTB.sapMTB-Auto-CTX.sapMTBInactive.sapMTBNewFlex");
        		for (var i = 0; i < myElements.length; i++) {
        			currentToolbar = sap.ui.getCore().byId(myElements[i].id);
        			if(!myElements[i+1]){
        				myElements[i].style.borderTop = "none";
        				myElements[i].style.borderBottom = "1px solid #CECECE";
        				myElements[i].style.borderRadius = "0px 0px 5px 5px";
        				myElements[i].style.paddingBottom = "2px";
        			}
        			else{
        				if(currentToolbar._isMajor){
        					myElements[i].style.marginTop = "3px";
        					myElements[i].style.borderBottom = "none";
        					myElements[i].style.borderTop = "1px solid #CECECE";
        					myElements[i].style.borderRadius = "5px 5px 0px 0px";
        				}
        				else{
        					nextToolbar = sap.ui.getCore().byId(myElements[i+1].id);
        					if(nextToolbar._isMajor){
        						myElements[i].style.borderTop = "none";
        						myElements[i].style.borderBottom = "1px solid #CECECE";
        						myElements[i].style.borderRadius = "0px 0px 5px 5px";
        						myElements[i].style.marginBottom = "5px";
        						myElements[i].style.paddingBottom = "2px";
        					}
        					else{
        						myElements[i].style.borderTop = "none";
        						myElements[i].style.borderBottom = "none";
        					}
        				}
        			}
        		}
        	}
        	/*if(isNested && expressionType=="RANGE"){
        		var myElements = document.querySelectorAll(".nestedExpression.sapMIBar.sapMTB.sapMTB-Auto-CTX.sapMTBInactive.sapMTBNewFlex");
        		for (var i = 0; i < myElements.length; i++) {
        		    myElements[i].style.width = "1075px";
        		}
        	}*/
    	};
    	if( comboBoxInputSelect && fieldSelect ) {
    		fieldSelect.onAfterRendering = function() {
    			//must be set once the fieldSelect box's value has loaded
    			_this.putLookupListsInComboBox( comboBoxInputSelect );
    		}
    	}
    	if (operatorSelect) {
    		operatorSelect.onAfterRendering = function() {
            	if (sas.hc.m.Select.prototype.onAfterRendering) {
            		sas.hc.m.Select.prototype.onAfterRendering.apply(this);
            	}
            	// must be set after rendering when the dom ref will exist
            	operatorSelect.getDomRef().setAttribute("name", "operatorSelect");
        	};
    	}
    	if (leftOperatorSelect) {
    		leftOperatorSelect.onAfterRendering = function() {
            	if (sas.hc.m.Select.prototype.onAfterRendering) {
            		sas.hc.m.Select.prototype.onAfterRendering.apply(this);
            	}
            	// must be set after rendering when the dom ref will exist
            	leftOperatorSelect.getDomRef().setAttribute("name", "leftOperatorSelect");
        	};
    	}
    	if (rightOperatorSelect) {
    		rightOperatorSelect.onAfterRendering = function() {
            	if (sas.hc.m.Select.prototype.onAfterRendering) {
            		sas.hc.m.Select.prototype.onAfterRendering.apply(this);
            	}
            	// must be set after rendering when the dom ref will exist
            	rightOperatorSelect.getDomRef().setAttribute("name", "rightOperatorSelect");
        	};
    	}
    	addConditionButton.onAfterRendering = function() {
        	if (sas.hc.m.MenuButton.prototype.onAfterRendering) {
        		sas.hc.m.MenuButton.prototype.onAfterRendering.apply(this);
        	}
        	// must be set after rendering when the dom ref will exist
        	addConditionButton.getDomRef().setAttribute("name", "addButton");
    	};
    	addConditionButton.getMenu().onAfterRendering = function() {
        	if (sas.hc.m.Menu.prototype.onAfterRendering) {
        		sas.hc.m.Menu.prototype.onAfterRendering.apply(this);
        	}
        	// must be set after rendering when the dom ref will exist
        	addConditionButton.getMenu().getDomRef().setAttribute("name", "addButtonMenu");
    	};
  	    addFieldMenuItem.onAfterRendering = function() {
  	    	if (sas.hc.m.MenuItem.prototype.onAfterRendering) {
  	    		sas.hc.m.MenuItem.prototype.onAfterRendering.apply(this);
  	    	}
  	    	// must be set after rendering when the dom ref will exist
  	    	addFieldMenuItem.getDomRef().setAttribute("name", "addSimpleMenuItem");
   	    };
   	    addRangeMenuItem.onAfterRendering = function() {
   	    	if (sas.hc.m.MenuItem.prototype.onAfterRendering) {
   	    		sas.hc.m.MenuItem.prototype.onAfterRendering.apply(this);
   	    	}
   	    	// must be set after rendering when the dom ref will exist
   	    	addRangeMenuItem.getDomRef().setAttribute("name", "addRangeMenuItem");
   	    };
    	deleteFieldButton.onAfterRendering = function() {
        	if (sas.hc.m.Button.prototype.onAfterRendering) {
        		sas.hc.m.Button.prototype.onAfterRendering.apply(this);
        	}
        	// must be set after rendering when the dom ref will exist
        	deleteFieldButton.getDomRef().setAttribute("name", "deleteButton");
    	};
    	addNestedRuleButton.onAfterRendering = function() {
        	if (sas.hc.m.Button.prototype.onAfterRendering) {
        		sas.hc.m.Button.prototype.onAfterRendering.apply(this);
        	}
        	// must be set after rendering when the dom ref will exist
        	addNestedRuleButton.getDomRef().setAttribute("name", "addGroupButton");
    	};
    	return ruleFormGuidedToolbar;
    },
    
    handleDelete: function(ruleFormGuidedToolbar, ruleFormGrid) {
    	var _this = this;
    	var ibefore = ruleFormGrid.indexOfContent(ruleFormGuidedToolbar) - 1;
    	var iof = ruleFormGrid.indexOfContent(ruleFormGuidedToolbar);
		var level = ruleFormGuidedToolbar._isNested ? 2 : 1;
		// disable delete if this is the only top-level toolbar
    	if (!ruleFormGuidedToolbar._isNested) {
    		  var contentArray = ruleFormGrid.getContent();
    		  var numberTopLevelToolbars = 0;
    		  for(var k = 0; k < contentArray.length; k++){
    			  if(!contentArray[k]._isMajor && !contentArray[k]._isNested){
    				  numberTopLevelToolbars++;
    				  if(numberTopLevelToolbars==2)break;
    			  }
    		  }
    		  if(numberTopLevelToolbars==1){
    			  ruleFormGrid.insertContent(
    				 _this.getToolbar("F-1" + _this.id_suffix,"",false,true),iof
          		  );
    			  var noToolbarsLeft = true;
    		  }
		  }
		  if (ruleFormGuidedToolbar._isNested) {
			  // remove preceding row also if it is a subgroup with no children left
  		      if (ruleFormGrid.getContent()[ibefore]._isMajor) {
  			  		if (!ruleFormGrid.getContent()[ibefore+2] ||
  			  			!ruleFormGrid.getContent()[ibefore+2]._isNested) {
  			  			ruleFormGrid.removeContent(ruleFormGrid.getContent()[ibefore]);
  			  			iof = ibefore;
            		    level = 1;
  			  		}
  		  	  }
		  }
		  ruleFormGrid.removeContent(ruleFormGuidedToolbar);
		  if(!noToolbarsLeft){this.modifyIds(ruleFormGrid, iof, level, -1);}
		  _this.somethingChangedInFullForm();
    },
    
    // this is to work around a bug in MultiInput where tokens are not deleting
    // this function and all attachDelete calls to it can be removed if/when the bug is fixed
    handleTokenDelete: function(oEvent){
    	if( !oEvent || !oEvent.oSource || !oEvent.oSource.oParent || !oEvent.oSource.oParent.oParent ) {
    		return;
    	}
		var multiInput = oEvent.oSource.oParent.oParent;
		multiInput.removeToken(oEvent.oSource);
		multiInput.fireTokenUpdate({type:"removed", removedTokens:new Array(oEvent.oSource), token:oEvent.oSource});
	},

	updateMultiInputClass: function(multiInput){
		if (multiInput.getTokens().length > 0) {
    		// remove doesn't always work the 1st time, so add first then remove
			multiInput.addStyleClass("cfEmptyMultiInput");
			multiInput.removeStyleClass("cfEmptyMultiInput");
		} else {
			multiInput.addStyleClass("cfEmptyMultiInput");
		}
	},
	
    getRuleExpressionToolbar: function(tId,expressionArr,isNested){
    	var _this = this;
    	var splitFormToolbarSpacerWidth = "30px";//isNested ? "30px" : "0px";
    	a++;
    	var ruleExpressionToolbar = a+"ruleExpressionToolbar";
    	var deleteExpressionButton;
    	var expressionValue, expressionLeftValue, expressionRightValue, oldValue, multiExpressionValue, comboBoxValue;
    	var expressionType = expressionArr["type"];
    	if(expressionType!="RANGE"){
    	  ruleExpressionToolbar = new sap.m.Toolbar({
	        content: [
	                  new sap.m.ToolbarSpacer({width:splitFormToolbarSpacerWidth}),
	                  expressionField = new sap.ui.commons.TextView({
	                	  wrapping : false,
	                	  text : expressionArr["fieldName"]//.toUpperCase()
	                  }),
	                  expressionFieldId = new sap.ui.commons.TextView({
	                	  wrapping : false,
	                	  visible : false,
	                	  text : expressionArr["fieldId"]//.toUpperCase()
	                  }),
	                  _this.getOperatorText(expressionArr["operator"]),
	                  expressionValue = new sas.hc.m.Input({
	                	  name : "valueInput",
		  	              value : (expressionArr["fieldType"] == "Currency" || expressionArr["fieldType"] == "Numeric") && expressionArr["value"]!=null ? sas.fscf.floatFormatter.format(expressionArr["value"]) : expressionArr["value"],
	                      type: (expressionArr["fieldType"] == "Currency" || expressionArr["fieldType"] == "Numeric") ? sap.m.InputType.Number : sap.m.InputType.Text,
	                      maxLength : 50,
	                      width : "220px"
	                  }),

					  comboBoxValue = new sas.hc.m.ComboBox({
						  name: "comboBoxValue",
						  width: "220px",
						  openDropdownOnInput: true,
						  inlineAutocomplete: true
					  }),
	                  
	                  multiExpressionValue = new sas.hc.m.MultiInput({
	                	  name : "multiExpressionValue",
	                	  width : "500px"
	                  }).addStyleClass("cfEmptyMultiInput"),
	                  deleteExpressionButton =  new sas.hc.m.Button({
  	                	  icon : "sap-icon://hc/delete",
  	                	  press: function() {
							 var exp;
							 if (ruleExpressionToolbar._type == "COMPARE" && !sas.fscf.isMultivalueOperator(sas.fscf.getOperatorKey(ruleExpressionToolbar.getContent()[3].getText()))) {
								exp = {
				   	               		type: ruleExpressionToolbar._type,
				   	               		operator: sas.fscf.getOperatorKey(ruleExpressionToolbar.getContent()[3].getText()),
				   	               		fieldName: ruleExpressionToolbar.getContent()[1].getText(),
				   	               		fieldId: ruleExpressionToolbar.getContent()[2].getText(),
				   	               		fieldType: ruleExpressionToolbar._fieldType,
				   	               		value: (ruleExpressionToolbar._fieldType == "Currency" || ruleExpressionToolbar._fieldType == "Numeric") ? "" + sas.fscf.floatFormatter.parse(ruleExpressionToolbar.getContent()[4].getValue()) : ruleExpressionToolbar.getContent()[4].getValue()
								 };
							 } else if (sas.fscf.isMultivalueOperator(sas.fscf.getOperatorKey(ruleExpressionToolbar.getContent()[3].getText()))) {
								var values = [];
								for (var i = 0; i < ruleExpressionToolbar.getContent()[6].getTokens().length; i++) {
		 	 						values.push((ruleExpressionToolbar._fieldType == "Currency" || ruleExpressionToolbar._fieldType == "Numeric") ? "" + sas.fscf.floatFormatter.parse(ruleExpressionToolbar.getContent()[6].getTokens()[i].getKey()) : ruleExpressionToolbar.getContent()[6].getTokens()[i].getKey());
								}
								exp = {
				   	               		type: ruleExpressionToolbar._type,
				   	               		operator: sas.fscf.getOperatorKey(ruleExpressionToolbar.getContent()[3].getText()),
				   	               		fieldName: ruleExpressionToolbar.getContent()[1].getText(),
				   	               		fieldId: ruleExpressionToolbar.getContent()[2].getText(),
				   	               		fieldType: ruleExpressionToolbar._fieldType,
				   	               		values: values
								 };
							 }
							 _this.getGrid().conditionDeleted(_this.getRootId(ruleExpressionToolbar._tId), exp);
  	                		 _this.removeCondition(_this.getRootId(ruleExpressionToolbar._tId));
  	                		 ruleExpressionToolbar.destroy(true);
  	                		 sap.ui.getCore().byId(_this.sId + '_RuleExpressionsFormGrid').removeContent(ruleExpressionToolbar);
  	                	  }
  	                  })
	              ]
    		});

    	    multiExpressionValue.addValidator(function(args){
  	  			multiExpressionValue.setValueState(sap.ui.core.ValueState.None);
  	  			var inputText = multiExpressionValue.getValue();
  	  			if(expressionArr["fieldType"] == "Currency" || expressionArr["fieldType"] == "Numeric"){
  	  				if(isNaN(sas.fscf.floatFormatter.parse(inputText))){
  	  					multiExpressionValue.setValueState(sap.ui.core.ValueState.Error);
  	  					multiExpressionValue.setValueStateText(sas.fscf.rb.getText("rules.rulesPage.guidedView.form.inputValueNumber.error.txt"));
  	  					return;
  	  				}
  	  			}
  	  			return new sas.hc.m.Token({key: (expressionArr["fieldType"] == "Currency" || expressionArr["fieldType"] == "Numeric") ? "" + sas.fscf.floatFormatter.parse(inputText) : inputText, text:inputText}).attachDelete(_this.handleTokenDelete);
			});

    	  	if( sas.fscf.isMissingOperator( expressionArr["operator"] ) ) {
    	  		expressionValue.setVisible(false);
    	  		comboBoxValue.setVisible(false);
    			multiExpressionValue.setVisible(false);
    		}
    		else if( sas.fscf.isMultivalueOperator(expressionArr["operator"] ) ) {
    			expressionValue.setVisible(false);
    			comboBoxValue.setVisible(false);
				multiExpressionValue.setVisible(true);
				var inputArray = expressionArr["values"];
				for(var k = 0; k < inputArray.length; k++){
					multiExpressionValue.addToken(new sas.hc.m.Token({key: inputArray[k], text:(expressionArr["fieldType"] == "Currency" || expressionArr["fieldType"] == "Numeric") ? sas.fscf.floatFormatter.format(inputArray[k]) : inputArray[k]}).attachDelete(_this.handleTokenDelete));
				}
				_this.updateMultiInputClass(multiExpressionValue);
			}
			else if(sas.fscf.isLookupListOperator(expressionArr["operator"])){
				expressionValue.setVisible(false);
    			comboBoxValue.setVisible(true);
    			multiExpressionValue.setVisible(false);
    			
    			comboBoxValue.setValue( expressionValue.getValue() );
			}
    		else{
    			expressionValue.setVisible(true);
    			comboBoxValue.setVisible(false);
    			multiExpressionValue.setVisible(false);
    		}

	   		//expressionValue.attachBrowserEvent("focus", function (event) {
	  		expressionValue.onAfterRendering = function() {
	        	if (sas.hc.m.Input.prototype.onAfterRendering) {
	        		sas.hc.m.Input.prototype.onAfterRendering.apply(this);
	        	}
				$("#" + this.sId + "-inner").focus(function (event) {
		 			//console.info("value is " + event.target.value);
	     			if(expressionArr["fieldType"] == "Currency" || expressionArr["fieldType"] == "Numeric"){
	     				oldValue = "" + sas.fscf.floatFormatter.parse(event.target.value);
	     			} else {
			 			oldValue = event.target.value;
	     			}
		   		});
			};
     		expressionValue.attachChange(function (oEvent) {
     			//console.info("value changed from " + oldValue + " to " + oEvent.mParameters.newValue);
     			if(expressionValue.getValue()=="" || expressionValue.getValue()==null || expressionValue.getValue()==undefined){
     				expressionValue.setValueStateText(sas.fscf.rb.getText("rules.rulesPage.guidedView.form.emptyField.error.txt"));
					expressionValue.setValueState(sap.ui.core.ValueState.Error);
     			}
     			else if(!sas.fscf.getCurrentPageView().jsonRuleIncomplete){
     				var oldExp = {
     						type: ruleExpressionToolbar._type,
     						operator: sas.fscf.getOperatorKey(ruleExpressionToolbar.getContent()[3].getText()),
     						fieldName: ruleExpressionToolbar.getContent()[1].getText(),
     						fieldId: ruleExpressionToolbar.getContent()[2].getText(),
     						fieldType: ruleExpressionToolbar._fieldType,
     						value: oldValue
     				};
     				var newExp = {
     						type: ruleExpressionToolbar._type,
     						operator: sas.fscf.getOperatorKey(ruleExpressionToolbar.getContent()[3].getText()),
     						fieldName: ruleExpressionToolbar.getContent()[1].getText(),
     						fieldId: ruleExpressionToolbar.getContent()[2].getText(),
     						fieldType: ruleExpressionToolbar._fieldType,
     						value: (expressionArr["fieldType"] == "Currency" || expressionArr["fieldType"] == "Numeric") ? "" + sas.fscf.floatFormatter.parse(oEvent.mParameters.newValue) : oEvent.mParameters.newValue
     				};
     				//if the value was set from the form inputs, let the grid know so it updates correctly
     				if( newExp.fieldType != "Character" ) {
     					newExp._setFromForm = true;
     				}
     				_this.getGrid().conditionModified(_this.getRootId(ruleExpressionToolbar._tId), oldExp, newExp);
     				_this.replaceCondition(_this.getRootId(ruleExpressionToolbar._tId), newExp);

     				oldValue = (expressionArr["fieldType"] == "Currency" || expressionArr["fieldType"] == "Numeric") ? "" + sas.fscf.floatFormatter.parse(oEvent.mParameters.newValue) : oEvent.mParameters.newValue;
     			}
       		});
     		expressionValue.attachBrowserEvent("keypress", function(e) {
     			if(expressionArr["fieldType"] == "Currency" || expressionArr["fieldType"] == "Numeric"){
					if (!($.inArray(e.which, _this._valid_numeric_key_codes) >= 0)) {
						expressionValue.setValueStateText(sas.fscf.rb.getText("rules.rulesPage.guidedView.form.inputValueNumber.error.txt"));
						expressionValue.setValueState(sap.ui.core.ValueState.Error);
						expressionValue.openValueStateMessage();
						e.preventDefault();
					}
					else{
						sas.fscf.getCurrentPageView().jsonRuleIncomplete=false;
						sas.fscf.removeAllMessageStrips();
		     			sas.fscf.getCurrentPageView().setDirty(true);
		     			var myElements = document.querySelectorAll(".sapMIBar.sapMTB.sapMTB-Auto-CTX.sapMTBInactive.sapMTBNewFlex");
		     			for (var i = 3; i < myElements.length; i++) {
		     				currentToolbar = sap.ui.getCore().byId(myElements[i].id);
		     				if(!currentToolbar._isMajor){
		     					var expr = currentToolbar.getContent()[4];
		     					setTimeout(function () {
		     						if(expr.getValueState() == sap.ui.core.ValueState.Error){
		     							sas.fscf.getCurrentPageView().jsonRuleIncomplete=true;
		     							sas.fscf.getCurrentPageView().setDirty(false);
		     						}
		     					}, 100);
		     				}
		     			}
					}
				}
     		});
     		
     		comboBoxValue.onAfterRendering = function() {
	        	if (sas.hc.m.ComboBox.prototype.onAfterRendering) {
	        		sas.hc.m.ComboBox.prototype.onAfterRendering.apply(this);
	        	}
	        	
	        	if( ruleExpressionToolbar.getContent()[5].getItems() == "" || ruleExpressionToolbar.getContent()[5].getItems() == undefined || ruleExpressionToolbar.getContent()[5].getItems() == null ){
	        		_this.getLookupListsForBox( ruleExpressionToolbar.getContent()[5], ruleExpressionToolbar.getContent()[1].getText() );
				}
	        	
				$("#" + this.sId + "-inner").focus(function (event) {
		 			//console.info("value is " + event.target.value);
	     			if(expressionArr["fieldType"] == "Currency" || expressionArr["fieldType"] == "Numeric"){
	     				oldValue = "" + sas.fscf.floatFormatter.parse(event.target.value);
	     			} else {
			 			oldValue = event.target.value;
	     			}
		   		});
			};
     		comboBoxValue.attachChange(function (oEvent) {
     			//console.info("value changed from " + oldValue + " to " + oEvent.mParameters.newValue);
     			if(oEvent.mParameters.newValue=="" || oEvent.mParameters.newValue==null || oEvent.mParameters.newValue==undefined){
     				comboBoxValue.setValueStateText(sas.fscf.rb.getText("rules.rulesPage.guidedView.form.emptyField.error.txt"));
					comboBoxValue.setValueState(sap.ui.core.ValueState.Error);
     			}
     			else if(!sas.fscf.getCurrentPageView().jsonRuleIncomplete){
     				var oldExp = {
     						type: ruleExpressionToolbar._type,
     						operator: sas.fscf.getOperatorKey(ruleExpressionToolbar.getContent()[3].getText()),
     						fieldName: ruleExpressionToolbar.getContent()[1].getText(),
     						fieldId: ruleExpressionToolbar.getContent()[2].getText(),
     						fieldType: ruleExpressionToolbar._fieldType,
     						value: oldValue
     				};
     				var newExp = {
     						type: ruleExpressionToolbar._type,
     						operator: sas.fscf.getOperatorKey(ruleExpressionToolbar.getContent()[3].getText()),
     						fieldName: ruleExpressionToolbar.getContent()[1].getText(),
     						fieldId: ruleExpressionToolbar.getContent()[2].getText(),
     						fieldType: ruleExpressionToolbar._fieldType,
     						value: (expressionArr["fieldType"] == "Currency" || expressionArr["fieldType"] == "Numeric") ? "" + sas.fscf.floatFormatter.parse(oEvent.mParameters.newValue) : oEvent.mParameters.newValue
     				};
     				_this.getGrid().conditionModified(_this.getRootId(ruleExpressionToolbar._tId), oldExp, newExp);
     				_this.replaceCondition(_this.getRootId(ruleExpressionToolbar._tId), newExp);

     				oldValue = (expressionArr["fieldType"] == "Currency" || expressionArr["fieldType"] == "Numeric") ? "" + sas.fscf.floatFormatter.parse(oEvent.mParameters.newValue) : oEvent.mParameters.newValue;
     			}
       		});

     		// important to add this listener after the initial tokens have already been added
    	  	multiExpressionValue.attachTokenUpdate(function(oEvent) {
				if (oEvent.mParameters.type == "removed" || oEvent.mParameters.type == "added") {
	    			_this.updateMultiInputClass(multiExpressionValue);
	 				var oldExp = {
 						type: ruleExpressionToolbar._type,
 						operator: sas.fscf.getOperatorKey(ruleExpressionToolbar.getContent()[3].getText()),
 						fieldName: ruleExpressionToolbar.getContent()[1].getText(),
 						fieldId: ruleExpressionToolbar.getContent()[2].getText(),
 						fieldType: ruleExpressionToolbar._fieldType,
 						value: (oEvent.mParameters.type == "removed") ? oEvent.mParameters.removedTokens[0].getKey() : ""
 					};
 	 				var values = [];
 	 				for (var i = 0; i < oEvent.oSource.getTokens().length; i++) {
 	 					if ((oEvent.mParameters.type == "added") && (i == (oEvent.oSource.getTokens().length - 1))) {
 	 						values.push((expressionArr["fieldType"] == "Currency" || expressionArr["fieldType"] == "Numeric") ? "" + sas.fscf.floatFormatter.parse(oEvent.oSource.getTokens()[i].getKey()) : oEvent.oSource.getTokens()[i].getKey());
 	 					} else {
 	 	 					values.push(oEvent.oSource.getTokens()[i].getKey());
 	 					}
 	 				}
 					var newExp = {
 						type: ruleExpressionToolbar._type,
 						operator: sas.fscf.getOperatorKey(ruleExpressionToolbar.getContent()[3].getText()),
 						fieldName: ruleExpressionToolbar.getContent()[1].getText(),
 						fieldId: ruleExpressionToolbar.getContent()[2].getText(),
 						fieldType: ruleExpressionToolbar._fieldType,
 						value: (oEvent.mParameters.type == "added") ? ((expressionArr["fieldType"] == "Currency" || expressionArr["fieldType"] == "Numeric") ? "" + sas.fscf.floatFormatter.parse(oEvent.mParameters.addedTokens[0].getKey()) : oEvent.mParameters.addedTokens[0].getKey()) : "",
 						values: values
 					};
 					_this.getGrid().conditionModified(_this.getRootId(ruleExpressionToolbar._tId), oldExp, newExp);
 					newExp.value = "";
 					_this.replaceCondition(_this.getRootId(ruleExpressionToolbar._tId), newExp);
 					
 					if( oEvent.getParameters().type == "removed" ) {
 						oEvent.oSource.focus();
 	    		    }
				}
				return true;
    	  	});
    	}
    	else{
    		ruleExpressionToolbar = new sap.m.Toolbar({
    	        content: [
    	                  new sap.m.ToolbarSpacer({width:splitFormToolbarSpacerWidth}),
    	                  expressionLeftValue = new sas.hc.m.Input({
    	                	  name : "leftValueInput",
    		  	              value : sas.fscf.floatFormatter.format(expressionArr["leftValue"]),
    	                      type: sap.m.InputType.Number,
    	                      width : "220px",
    	                      maxLength : 50
    	                  }),
    	                  _this.getOperatorText(expressionArr["leftOperator"]),
    	                  expressionField = new sap.ui.commons.TextView({
    	                	  wrapping : false,
    	                	  text : expressionArr["fieldName"]//.toUpperCase()
    	                  }),
    	                  expressionFieldId = new sap.ui.commons.TextView({
    	                	  wrapping : false,
    	                	  visible : false,
    	                	  text : expressionArr["fieldId"]//.toUpperCase()
    	                  }),
    	                  _this.getOperatorText(expressionArr["rightOperator"]),
    	                  expressionRightValue = new sas.hc.m.Input({
    	                	  name : "rightValueInput",
    		  	              value : sas.fscf.floatFormatter.format(expressionArr["rightValue"]),
    	                      type: sap.m.InputType.Number,
    	                      width : "220px",
    	                      maxLength : 50
    	                  }),
    	                  deleteExpressionButton =  new sas.hc.m.Button({
      	                	  icon : "sap-icon://hc/delete",
      	                	  press: function() {
	   							 var exp;
								 if (ruleExpressionToolbar._type == "RANGE") {
									exp = {
					   	               		type: ruleExpressionToolbar._type,
					   	               		fieldName: ruleExpressionToolbar.getContent()[3].getText(),
					   	               		fieldId: ruleExpressionToolbar.getContent()[4].getText(),
					   	               		fieldType: ruleExpressionToolbar._fieldType,
					   	               		leftValue: (ruleExpressionToolbar._fieldType == "Currency" || ruleExpressionToolbar._fieldType == "Numeric") ? "" + sas.fscf.floatFormatter.parse(ruleExpressionToolbar.getContent()[1].getValue()) : ruleExpressionToolbar.getContent()[1].getValue(),
					   	               		rightValue: (ruleExpressionToolbar._fieldType == "Currency" || ruleExpressionToolbar._fieldType == "Numeric") ? "" + sas.fscf.floatFormatter.parse(ruleExpressionToolbar.getContent()[6].getValue()) : ruleExpressionToolbar.getContent()[6].getValue(),
					   	               		leftOperator: sas.fscf.getOperatorKey(ruleExpressionToolbar.getContent()[2].getText()),
					   	               		rightOperator: sas.fscf.getOperatorKey(ruleExpressionToolbar.getContent()[5].getText())
									 };
								 }
								 _this.getGrid().conditionDeleted(_this.getRootId(ruleExpressionToolbar._tId), exp);
								 _this.removeCondition(_this.getRootId(ruleExpressionToolbar._tId));
      	                		 ruleExpressionToolbar.destroy(true);
      	                		 sap.ui.getCore().byId(_this.sId + '_RuleExpressionsFormGrid').removeContent(ruleExpressionToolbar);
      	                		//_this.updateModelFromSplitForm();
      	                		 //_this.initSplitForm();
      	                	  }
      	                  })
    	              ]
        		});
//	   		expressionLeftValue.attachBrowserEvent("focus", function (event) {
	  		expressionLeftValue.onAfterRendering = function() {
	        	if (sas.hc.m.Input.prototype.onAfterRendering) {
	        		sas.hc.m.Input.prototype.onAfterRendering.apply(this);
	        	}
				$("#" + this.sId + "-inner").focus(function (event) {
		 			//console.info("value is " + sas.fscf.floatFormatter.parse(event.target.value));
     				oldValue = "" + sas.fscf.floatFormatter.parse(event.target.value);
		   		});
			};
     		expressionLeftValue.attachChange(function (oEvent) {
     			if(expressionLeftValue.getValue()=="" || expressionLeftValue.getValue()==null || expressionLeftValue.getValue()==undefined){
     				expressionLeftValue.setValueStateText(sas.fscf.rb.getText("rules.rulesPage.guidedView.form.emptyField.error.txt"));
					expressionLeftValue.setValueState(sap.ui.core.ValueState.Error);
     			}
     			else{
     				//console.info("left value changed from " + oldValue + " to " + oEvent.mParameters.newValue);
     				var oldExp = {
     						type: ruleExpressionToolbar._type,
     						fieldName: ruleExpressionToolbar.getContent()[3].getText(),
     						fieldId: ruleExpressionToolbar.getContent()[4].getText(),
     						fieldType: ruleExpressionToolbar._fieldType,
     						leftValue: oldValue,
     						rightValue: "" + sas.fscf.floatFormatter.parse(ruleExpressionToolbar.getContent()[6].getValue()),
     						leftOperator: sas.fscf.getOperatorKey(ruleExpressionToolbar.getContent()[2].getText()),
     						rightOperator: sas.fscf.getOperatorKey(ruleExpressionToolbar.getContent()[5].getText())
     				};
     				if ((sas.fscf.floatFormatter.parse(oEvent.mParameters.newValue) > sas.fscf.floatFormatter.parse(ruleExpressionToolbar.getContent()[6].getValue())) &&
     						(this.getValueState() != sap.ui.core.ValueState.Error)) {
     					// swap to right if greater than right
     					var temp = ruleExpressionToolbar.getContent()[6].getValue();
     					ruleExpressionToolbar.getContent()[6].setValue(oEvent.mParameters.newValue);
     					ruleExpressionToolbar.getContent()[1].setValue(temp);
     				}
     				var newExp;
     				var bConverted = false;
     				if (sas.fscf.floatFormatter.parse(ruleExpressionToolbar.getContent()[1].getValue()) == sas.fscf.floatFormatter.parse(ruleExpressionToolbar.getContent()[6].getValue())) {
     					// convert to a simple condition if the numbers are the same
     					newExp = {
     							type: "COMPARE",
     							fieldName: ruleExpressionToolbar.getContent()[3].getText(),
     							fieldId: ruleExpressionToolbar.getContent()[4].getText(),
     							fieldType: ruleExpressionToolbar._fieldType,
     							value: "" + sas.fscf.floatFormatter.parse(ruleExpressionToolbar.getContent()[1].getValue()),
     							operator: sas.fscf.getOperatorKey(ruleExpressionToolbar.getContent()[2].getText())
     					};
     					bConverted = true;
     				} else {
     					newExp = {
     							type: ruleExpressionToolbar._type,
     							fieldName: ruleExpressionToolbar.getContent()[3].getText(),
     							fieldId: ruleExpressionToolbar.getContent()[4].getText(),
     							fieldType: ruleExpressionToolbar._fieldType,
     							leftValue: "" + sas.fscf.floatFormatter.parse(ruleExpressionToolbar.getContent()[1].getValue()),
     							rightValue: "" + sas.fscf.floatFormatter.parse(ruleExpressionToolbar.getContent()[6].getValue()),
     							leftOperator: sas.fscf.getOperatorKey(ruleExpressionToolbar.getContent()[2].getText()),
     							rightOperator: sas.fscf.getOperatorKey(ruleExpressionToolbar.getContent()[5].getText())
     					};
     				}
     				//if the value was set from the form inputs, let the grid know so it updates correctly
     				if( newExp.fieldType != "Character" ) {
     					newExp._setFromForm = true;
     				}
     				_this.getGrid().conditionModified(_this.getRootId(ruleExpressionToolbar._tId), oldExp, newExp);
     				_this.replaceCondition(_this.getRootId(ruleExpressionToolbar._tId), newExp);
     				if (bConverted) {
     					_this.initSplitForm();
     				}

     				oldValue = "" + sas.fscf.floatFormatter.parse(oEvent.mParameters.newValue);
     			}
       		});
	   		//expressionRightValue.attachBrowserEvent("focus", function (event) {
	  		expressionRightValue.onAfterRendering = function() {
	        	if (sas.hc.m.Input.prototype.onAfterRendering) {
	        		sas.hc.m.Input.prototype.onAfterRendering.apply(this);
	        	}
				$("#" + this.sId + "-inner").focus(function (event) {
		 			//console.info("value is " + sas.fscf.floatFormatter.parse(event.target.value));
     				oldValue = "" + sas.fscf.floatFormatter.parse(event.target.value);
		   		});
			};
     		expressionRightValue.attachChange(function (oEvent) {
     			if(expressionRightValue.getValue()=="" || expressionRightValue.getValue()==null || expressionRightValue.getValue()==undefined){
     				expressionRightValue.setValueStateText(sas.fscf.rb.getText("rules.rulesPage.guidedView.form.emptyField.error.txt"));
					expressionRightValue.setValueState(sap.ui.core.ValueState.Error);
     			}
     			else{
     				//console.info("right value changed from " + oldValue + " to " + oEvent.mParameters.newValue);
     				var oldExp = {
     						type: ruleExpressionToolbar._type,
     						fieldName: ruleExpressionToolbar.getContent()[3].getText(),
     						fieldId: ruleExpressionToolbar.getContent()[4].getText(),
     						fieldType: ruleExpressionToolbar._fieldType,
     						leftValue: "" + sas.fscf.floatFormatter.parse(ruleExpressionToolbar.getContent()[1].getValue()),
     						rightValue: oldValue,
     						leftOperator: sas.fscf.getOperatorKey(ruleExpressionToolbar.getContent()[2].getText()),
     						rightOperator: sas.fscf.getOperatorKey(ruleExpressionToolbar.getContent()[5].getText())
     				};
     				if ((sas.fscf.floatFormatter.parse(oEvent.mParameters.newValue) < sas.fscf.floatFormatter.parse(ruleExpressionToolbar.getContent()[1].getValue())) &&
     						(this.getValueState() != sap.ui.core.ValueState.Error)) {
     					// swap to left if less than left
     					var temp = ruleExpressionToolbar.getContent()[1].getValue();
     					ruleExpressionToolbar.getContent()[1].setValue(oEvent.mParameters.newValue);
     					ruleExpressionToolbar.getContent()[6].setValue(temp);
     				}
     				var newExp;
     				var bConverted = false;
     				if (sas.fscf.floatFormatter.parse(ruleExpressionToolbar.getContent()[1].getValue()) == sas.fscf.floatFormatter.parse(ruleExpressionToolbar.getContent()[6].getValue())) {
     					// convert to a simple condition if the numbers are the same
     					newExp = {
     							type: "COMPARE",
     							fieldName: ruleExpressionToolbar.getContent()[3].getText(),
     							fieldId: ruleExpressionToolbar.getContent()[4].getText(),
     							fieldType: ruleExpressionToolbar._fieldType,
     							value: "" + sas.fscf.floatFormatter.parse(ruleExpressionToolbar.getContent()[1].getValue()),
     							operator: sas.fscf.getOperatorKey(ruleExpressionToolbar.getContent()[2].getText())
     					};
     					bConverted = true;
     				} else {
     					newExp = {
     							type: ruleExpressionToolbar._type,
     							fieldName: ruleExpressionToolbar.getContent()[3].getText(),
     							fieldId: ruleExpressionToolbar.getContent()[4].getText(),
     							fieldType: ruleExpressionToolbar._fieldType,
     							leftValue: "" + sas.fscf.floatFormatter.parse(ruleExpressionToolbar.getContent()[1].getValue()),
     							rightValue: "" + sas.fscf.floatFormatter.parse(ruleExpressionToolbar.getContent()[6].getValue()),
     							leftOperator: sas.fscf.getOperatorKey(ruleExpressionToolbar.getContent()[2].getText()),
     							rightOperator: sas.fscf.getOperatorKey(ruleExpressionToolbar.getContent()[5].getText())
     					};
     				}
     				//if the value was set from the form inputs, let the grid know so it updates correctly
     				if( newExp.fieldType != "Character" ) {
     					newExp._setFromForm = true;
     				}
     				_this.getGrid().conditionModified(_this.getRootId(ruleExpressionToolbar._tId), oldExp, newExp);
     				_this.replaceCondition(_this.getRootId(ruleExpressionToolbar._tId), newExp);
     				if (bConverted) {
     					_this.initSplitForm();
     				}

     				oldValue = "" + sas.fscf.floatFormatter.parse(oEvent.mParameters.newValue);
     			}
       		});
     		//Might be a way to prevent text from being entered using UI5 methods instead of the following javascript
       		expressionLeftValue.attachBrowserEvent("keypress", function(e) {
     			if(expressionArr["fieldType"] == "Currency" || expressionArr["fieldType"] == "Numeric"){
					if (!($.inArray(e.which, _this._valid_numeric_key_codes) >= 0)) {
						expressionLeftValue.setValueStateText(sas.fscf.rb.getText("rules.rulesPage.guidedView.form.inputValueNumber.error.txt"));
						expressionLeftValue.setValueState(sap.ui.core.ValueState.Error);
						e.preventDefault();
					}
				}
            });
       		expressionRightValue.attachBrowserEvent("keypress", function(e) {
     			if(expressionArr["fieldType"] == "Currency" || expressionArr["fieldType"] == "Numeric"){
					if (!($.inArray(e.which, _this._valid_numeric_key_codes) >= 0)) {
						expressionRightValue.setValueStateText(sas.fscf.rb.getText("rules.rulesPage.guidedView.form.inputValueNumber.error.txt"));
						expressionRightValue.setValueState(sap.ui.core.ValueState.Error);
						e.preventDefault();
					}
				}
            });
    	}

    	ruleExpressionToolbar._type = expressionArr["type"];
    	ruleExpressionToolbar._fieldType = expressionArr["fieldType"];
    	ruleExpressionToolbar._tId = tId;

    	if(isNested){
    		ruleExpressionToolbar.addStyleClass("nestedExpressionSplitForm");
    	}
    	
    	//set any name attributes that need to be set
    	ruleExpressionToolbar.onAfterRendering = function() {
        	if (sap.m.Toolbar.prototype.onAfterRendering) {
        		sap.m.Toolbar.prototype.onAfterRendering.apply(this);
        	}
        	// must be set after rendering when the dom ref will exist
        	ruleExpressionToolbar.getDomRef().setAttribute("name", ruleExpressionToolbar._tId);
        	if(isNested){
        		var myElements = document.querySelectorAll(".nestedExpressionSplitForm.sapMIBar.sapMTB.sapMTB-Auto-CTX.sapMTBInactive.sapMTBNewFlex");
        		for (var i = 0; i < myElements.length; i++) {
        			currentToolbar = sap.ui.getCore().byId(myElements[i].id);
        			if(!myElements[i+1]){
        				myElements[i].style.borderTop = "none";
        				myElements[i].style.borderBottom = "1px solid #CECECE";
        				myElements[i].style.borderRadius = "0px 0px 0px 5px";
        				myElements[i].style.paddingBottom = "2px";
        			}
        			else{
        				if(currentToolbar._isMajor){
        					myElements[i].style.marginTop = "3px";
        					myElements[i].style.borderBottom = "none";
        					myElements[i].style.borderTop = "1px solid #CECECE";
        					myElements[i].style.borderRadius = "5px 0px 0px 0px";
        				}
        				else{
        					nextToolbar = sap.ui.getCore().byId(myElements[i+1].id);
        					if(nextToolbar._isMajor){
        						myElements[i].style.borderTop = "none";
        						myElements[i].style.borderBottom = "1px solid #CECECE";
        						myElements[i].style.borderRadius = "0px 0px 0px 5px";
        						myElements[i].style.marginBottom = "5px";
        						myElements[i].style.paddingBottom = "2px";
        					}
        					else{
        						myElements[i].style.borderTop = "none";
        						myElements[i].style.borderBottom = "none";
        					}
        				}
        			}
        		}
        	}
    	};
    	deleteExpressionButton.onAfterRendering = function() {
        	if (sas.hc.m.Button.prototype.onAfterRendering) {
        		sas.hc.m.Button.prototype.onAfterRendering.apply(this);
        	}
        	// must be set after rendering when the dom ref will exist
        	deleteExpressionButton.getDomRef().setAttribute("name", "deleteButton");
    	};
    	return ruleExpressionToolbar;
    },

    arrayContains: function(a, keyVal) {
        for (var i = 0; i < a.length; i++) {
            if (a[i] == keyVal) {
                return true;
            }
        }
        return false;
    },

    findCondition: function(pId) {
    	var ruleModel = sas.fscf.getCurrentPageView().jsonRule.expressions.expressions[0].condition;

    	var exps = ruleModel["expressions"];
    	return this._findCondition(pId, exps);
    },

    _findCondition: function(pId, exps, parent_exps, parent_i, level) {
    	if (level == undefined) {
    		level = 1;
    	}
    	var pIndices = pId.split("-");
    	var indices;
    	var i;
		for (i = 0; i < exps.length; i++) {
			if (exps[i]["id"] == pId) {
		    	return {exp: exps[i], parent_exps: exps, parent_i: i, g_parent_exps: parent_exps, g_parent_i: parent_i};
			}
			indices = exps[i]["id"].split("-");
			if (parseInt(indices[level]) > parseInt(pIndices[level])) {
		    	return {exp: null, parent_exps: exps, parent_i: i, g_parent_exps: parent_exps, g_parent_i: parent_i};
			} else if (parseInt(indices[level]) == parseInt(pIndices[level])) {
				if ((exps[i]["type"] == "OR") || (exps[i]["type"] == "AND") || (exps[i]["type"] == "NOR")) {
    				return this._findCondition(pId, exps[i].expressions, exps, i, level + 1);
				}
			}
		}
    	return {exp: null, parent_exps: exps, parent_i: i, g_parent_exps: parent_exps, g_parent_i: parent_i};
    },

    addCondition: function(pId, exp, bOverrideIn) {
    	var ruleModel = sas.fscf.getCurrentPageView().jsonRule.expressions.expressions[0].condition;
    	var exs = ruleModel["expressions"];
    	exp.id = pId;

    	if(exs==null || exs==[] || exs == ""){
    		ruleModel["expressions"] = [exp];
    	} else{
    		var exps = ruleModel["expressions"];
        	var ret = this._findCondition(pId, exps);
        	if (ret.exp) {
        		if (bOverrideIn || (ret.exp["type"] == "OR") || (ret.exp["type"] == "AND")) {
        			if (((ret.exp["type"] == "OR") && (ret.exp.expressions[0]["fieldId"] == exp.fieldId)) ||
           				((ret.exp["type"] == "AND") && (ret.exp.expressions[0]["fieldId"] == exp.fieldId))) {
           				// multi-select case and there is already an OR or an AND block
           				// add it to the end
           				var id_pieces = ret.exp.expressions[ret.exp.expressions.length - 1].id.split("-");
           				id_pieces[id_pieces.length - 1] = parseInt(id_pieces[id_pieces.length - 1]) + 1;
           				exp.id = id_pieces.join("-");
               			ret.exp.expressions[ret.exp.expressions.length] = exp;
           			} else if (ret.exp["fieldId"] == exp.fieldId) {
           				// multi-select case and there is not already an OR block
           				// remove from the group and put it into a new subgroup
           	    		var newSubGroup = ret.parent_exps.splice(ret.parent_i, 1);
           				newSubGroup[0].id = pId + "-" + 1;
               			// add the new exp to the end of the new subgroup
           				exp.id = pId + "-" + 2;
               			newSubGroup[newSubGroup.length] = exp;
               			// add the new subgroup as an OR or an AND at the i position
               			if (exp.operator == sas.fscf.operators.NE ) {
                   			ret.parent_exps.splice(ret.parent_i, 0 ,{id: pId, type:"AND", operator:"AND", expressions:newSubGroup});
               			} else {
                   			ret.parent_exps.splice(ret.parent_i, 0 ,{id: pId, type:"OR", operator:"OR", expressions:newSubGroup});
               			}
       			    }
        		} else {
        			if (sas.fscf.isMultivalueOperator(ret.exp["operator"]) && (ret.exp["fieldId"] == exp.fieldId)) {
           				// multi-select case and there is already an IN
           				// add the value to to the end of the values array
        				ret.exp["value"] = "";
        				ret.exp["values"].push(exp.value);
           			} else if (ret.exp["fieldId"] == exp.fieldId) {
           				// multi-select case and there is not already an IN
           				// make it an IN
           				if (ret.exp["operator"] == sas.fscf.operators.NE) {
           					ret.exp["operator"] = sas.fscf.operators.NOTIN;
           				} else {
           					ret.exp["operator"] = sas.fscf.operators.IN;
           				}
           				ret.exp["values"] = [];
        				ret.exp["values"].push(ret.exp.value);
        				ret.exp["values"].push(exp.value);
        				ret.exp["value"] = "";
       			    }
        		}
			} else {
				// insert or append it at the i position
				ret.parent_exps.splice(ret.parent_i, 0, exp);
			}
			ruleModel["expressions"] = exps;
    	}
    	sas.fscf.getCurrentPageView().jsonRule.expressions.expressions[0].condition = ruleModel;
    	sas.fscf.removeAllMessageStrips();
		sas.fscf.getCurrentPageView().setDirty(true);
    	this.initSplitForm();
    },

    negateCondition: function(pId) {
    	var ruleModel = sas.fscf.getCurrentPageView().jsonRule.expressions.expressions[0].condition;

    	var exps = ruleModel["expressions"];
    	var ret = this._findCondition(pId, exps);
    	if (ret.exp) {
			if (ret.exp["type"] == "OR") {
				// convert OR, EQUAL to AND, NE
				for (let i = 0; i < ret.exp.expressions.length; i++) {
					if (ret.exp.expressions[i]["operator"] == sas.fscf.operators.EQUAL ) {
						ret.exp.expressions[i]["operator"] = sas.fscf.operators.NE;
					}
				}
				ret.exp["type"] = "AND";
				ret.exp["operator"] = "AND";
			} else if (ret.exp["type"] == "AND") {
				// convert AND, NE to OR, EQUAL
				for (let i = 0; i < ret.exp.expressions.length; i++) {
					if (ret.exp.expressions[i]["operator"] == sas.fscf.operators.NE) {
						ret.exp.expressions[i]["operator"] = sas.fscf.operators.EQUAL;
					}
				}
				ret.exp["type"] = "OR";
				ret.exp["operator"] = "OR";
			} else if (ret.exp["type"] == "COMPARE") {
				ret.exp["operator"] = sas.fscf.negateOperator( ret.exp["operator"] );
			}
    	}

    	ruleModel["expressions"] = exps;
    	sas.fscf.getCurrentPageView().jsonRule.expressions.expressions[0].condition = ruleModel;
    	sas.fscf.removeAllMessageStrips();
		sas.fscf.getCurrentPageView().setDirty(true);
    	this.initSplitForm();
    },

    updateCondition: function(pId, exp) {
    	this.replaceCondition(pId, exp);
    	this.initSplitForm();
    },

    removeCondition: function(pId, exp, bModifyIds) {
    	var ruleModel = sas.fscf.getCurrentPageView().jsonRule.expressions.expressions[0].condition;
    	var exps = ruleModel["expressions"];
    	var ret = this._findCondition(pId, exps);
    	if (ret.exp) {
			if ((ret.exp["type"] == "OR" || ret.exp["type"] == "AND") && exp) {
				// handle the multi-select case which maps to an OR or an AND
    			for (let k = 0; k < ret.exp.expressions.length; k++) {
    				if (this.isEqualForRemoval(ret.exp.expressions[k], exp)) {
    					ret.exp.expressions.splice(k, 1);
    					if (ret.exp.expressions[k]) {
    			        	this.modifyModelIds(ret.exp.expressions, k, ret.exp.expressions[k].id.split("-").length - 1, -1);
    					}
    					break;
    				}
    			}
	    		if (ret.exp.expressions.length == 1) {
					// simplify the subgroup if it is now a single expression
	    			var temp_exp = ret.exp.expressions[0];
	    			temp_exp.id = ret.parent_exps[ret.parent_i].id;
	    			ret.parent_exps.splice(ret.parent_i, 1, temp_exp);
				} else if (ret.exp.expressions.length == 0) {
					// remove the subgroup if it is now empty
	    			ret.parent_exps.splice(ret.parent_i, 1);
			    	if (bModifyIds) {
			    		if (ret.parent_exps[ret.parent_i]) {
				        	this.modifyModelIds(ret.parent_exps, ret.parent_i, ret.parent_exps[ret.parent_i].id.split("-").length - 1, -1);
			    		}
			    	}
	    		}
			} else if (sas.fscf.isMultivalueOperator(ret.exp["operator"]) && (exp && exp.value && exp.value.length > 0)) {
				// handle the multi-select case which maps to an IN
				for (let k = 0; k < ret.exp.values.length; k++) {
					if (ret.exp.values[k] == exp.value) {
						ret.exp.values.splice(k, 1);
						break;
					}
				}
				if (ret.exp.values.length == 1) {
					// simplify the expression if it is now a single value
					ret.exp.type = "COMPARE";
					if (ret.exp.operator == sas.fscf.operators.NOTIN) {
						ret.exp.operator = sas.fscf.operators.NE;
					} else {
						ret.exp.operator = sas.fscf.operators.EQUAL;
					}
					ret.exp.value = ret.exp.values.pop();
					ret.exp.values = undefined;
				} else if (ret.exp.values.length == 0) {
					// remove the expression if it is now empty
	    			ret.parent_exps.splice(ret.parent_i, 1);
			    	if (bModifyIds) {
			    		if (ret.parent_exps[ret.parent_i]) {
				        	this.modifyModelIds(ret.parent_exps, ret.parent_i, ret.parent_exps[ret.parent_i].id.split("-").length - 1, -1);
			    		}
			    	}
				}
			} else {
				// remove the condition
    			ret.parent_exps.splice(ret.parent_i, 1);
				// if in a subgroup that is now empty, remove the subgroup
    			if (ret.g_parent_exps) {
    	    		if (ret.parent_exps.length == 0) {
    	    			ret.g_parent_exps.splice(ret.g_parent_i, 1);
    			    	if (bModifyIds) {
    			    		if (ret.g_parent_exps[ret.g_parent_i]) {
        			        	this.modifyModelIds(ret.g_parent_exps, ret.g_parent_i, ret.g_parent_exps[ret.g_parent_i].id.split("-").length - 1, -1);
    			    		}
    			    	}
    	    		} else {
    			    	if (bModifyIds) {
    			    		if (ret.parent_exps[ret.parent_i]) {
        			        	this.modifyModelIds(ret.parent_exps, ret.parent_i, ret.parent_exps[ret.parent_i].id.split("-").length - 1, -1);
    			    		}
    			    	}
    	    		}
    			} else {
			    	if (bModifyIds) {
			    		if (ret.parent_exps[ret.parent_i]) {
				        	this.modifyModelIds(ret.parent_exps, ret.parent_i, ret.parent_exps[ret.parent_i].id.split("-").length - 1, -1);
			    		}
			    	}
    			}
			}
    	} else {
    		// the user removed a panel that had no selections - even though there was no matching expression, the other
    		// ids after pId still need to be modified
    		if (bModifyIds) {
        		if (ret.parent_exps[ret.parent_i]) {
                	this.modifyModelIds(ret.parent_exps, ret.parent_i, ret.parent_exps[ret.parent_i].id.split("-").length - 1, -1);
        		}
    		}
    	}

    	ruleModel["expressions"] = exps;
    	sas.fscf.getCurrentPageView().jsonRule.expressions.expressions[0].condition = ruleModel;
    	sas.fscf.removeAllMessageStrips();
		sas.fscf.getCurrentPageView().setDirty(true);
    	this.initSplitForm();
    },

    isEqualForRemoval: function(exp, exp2) {
		if(exp["fieldId"]==exp2.fieldId && exp["type"]==exp2.type){
			if (exp["type"]=="COMPARE") {
				if (exp["operator"]==exp2.operator && exp["value"]==exp2.value) {
					return true;
				}
			} else if (exp["type"]=="RANGE") {
    			if (exp["leftOperator"]==exp2.leftOperator && exp["leftValue"]==exp2.leftValue &&
    				exp["rightOperator"]==exp2.rightOperator && exp["rightValue"]==exp2.rightValue) {
					return true;
    			}
			}
		}
		return false;
    },

    removeAllConditions: function() {
    	// zero out the expressions
    	sas.fscf.getCurrentPageView().jsonRule.expressions.expressions[0].condition.expressions.length = 0;
    	this.initSplitForm();
    },

    replaceCondition: function(pId, exp) {
    	var ruleModel = sas.fscf.getCurrentPageView().jsonRule.expressions.expressions[0].condition;
    	var exps = ruleModel["expressions"];
		exp.id = pId;
    	var ret = this._findCondition(pId, exps);
    	if (ret.exp) {
			ret.parent_exps[ret.parent_i] = exp;
    	}
    	ruleModel["expressions"] = exps;
    	sas.fscf.getCurrentPageView().jsonRule.expressions.expressions[0].condition = ruleModel;
    	sas.fscf.removeAllMessageStrips();
		sas.fscf.getCurrentPageView().setDirty(true);
    },

    filterFloat: function (value) {
        if(/^(\-|\+)?([0-9]+(\.[0-9]+)?|Infinity)$/
          .test(value)){
          return Number(value);
        }
      return false;
    },

    updateModelFromFullForm: function(finalCheck){
    	var _this=this;
    	sas.fscf.getCurrentPageView().jsonRuleIncomplete = false;

    	var ruleModel = sas.fscf.getCurrentPageView().jsonRule.expressions.expressions[0].condition;
    	ruleModel["expressions"].length = 0;
    	var checkExpArray = [];
    	var checkExpArrayNested = [];
    	var mainErrorText;
    	var allItems = document.getElementById(_this.sId + "_RuleGuidedFormGrid");

    		if(allItems.children!=undefined){
    			var subItems = allItems.children;
    			var level = -1;
    			var j = 0;
    			var k = 0;
    			var majorInclusion = sap.ui.getCore().byId(subItems[0].children[0].id).getContent()[1];
    			for(var b=0;b<subItems.length;b++){
    				if(subItems[b].children!=undefined){
    				  if(subItems[b].children[0]!=undefined){
    					var previousToolbarIsNested = b!=0 ? sap.ui.getCore().byId(subItems[b-1].children[0].id)._isNested : false;
    					var currentToolbar = sap.ui.getCore().byId(subItems[b].children[0].id);
    					if(currentToolbar._isMajor){ //inclusion field

    						var selectedInclusionField = currentToolbar.getContent()[1];

    						if(level==-1){
    							ruleModel["type"] = selectedInclusionField.getSelectedKey();
    							mainErrorText = currentToolbar.getContent()[3];
    							if(ruleModel["type"]=="NOR"){
    								ruleModel["operator"] = "OR";
    							} else{
    								ruleModel["operator"] = ruleModel["type"];
    							}
    							level++;
    						} else{
    							if(previousToolbarIsNested){
									j++;
								}
    							k=0;
    							var lastNestedInclusion = selectedInclusionField;
    							if(ruleModel["expressions"][j]==null || ruleModel["expressions"][j]==undefined){
									ruleModel["expressions"][j] = {};
								}
    							ruleModel["expressions"][j]["type"] = selectedInclusionField.getSelectedKey();
    							if(ruleModel["expressions"][j]["type"]=="NOR"){
    								ruleModel["expressions"][j]["operator"] = "OR";
    							} else{
    								ruleModel["expressions"][j]["operator"] = ruleModel["expressions"][j]["type"];
    							}
    						}
    					} else if(!currentToolbar._isMajor){ //toolbar with input fields

    						var s2Items = subItems[b].children[0].children;

    						if($('#'+s2Items[1].id).find('[name="leftValueInput"]').length > 0){ //range toolbar
          				    	var leftInputField = currentToolbar.getContent()[1];
          				    	var leftOperatorField = currentToolbar.getContent()[2];
          				    	var variableField = currentToolbar.getContent()[3];
          				    	var rightOperatorField = currentToolbar.getContent()[4];
          				    	var rightInputField = currentToolbar.getContent()[5];

    							if(leftInputField.getValue().trim() == "" || leftInputField.getValue() == null || leftInputField.getValue() == undefined ||
    									leftOperatorField.getSelectedKey() == "" || leftOperatorField.getSelectedKey() == null || leftOperatorField.getSelectedKey() == undefined ||
    									variableField.getValue() == "" || variableField.getValue() == null || variableField.getValue() == undefined ||
    									rightOperatorField.getSelectedKey() == "" || rightOperatorField.getSelectedKey() == null || rightOperatorField.getSelectedKey() == undefined ||
    									rightInputField.getValue() == "" || rightInputField.getValue() == null || rightInputField.getValue() == undefined ||
    									variableField.getSelectedItem() == null ){
    								if(!currentToolbar._isNested){
    									if(variableField.getSelectedItem() != null){
    										if(finalCheck){
    											if(leftInputField.getValue().trim()==""){
    												sas.fscf.getCurrentPageView().jsonRuleIncomplete = true;
    												leftInputField.setValueState(sap.ui.core.ValueState.Error);
    												leftInputField.setValueStateText(sas.fscf.rb.getText("rules.rulesPage.guidedView.form.emptyField.error.txt"));
    												mainErrorText.setText(sas.fscf.rb.getText("rules.rulesPage.guidedView.form.correctAllErrors.error.txt"));
    											}
    										}
    										if(finalCheck){
    	          				    			if(rightInputField.getValue().trim()==""){
    	          				    				sas.fscf.getCurrentPageView().jsonRuleIncomplete = true;
    	          				    				rightInputField.setValueState(sap.ui.core.ValueState.Error);
    	          				    				rightInputField.setValueStateText(sas.fscf.rb.getText("rules.rulesPage.guidedView.form.emptyField.error.txt"));
    	          				    				mainErrorText.setText(sas.fscf.rb.getText("rules.rulesPage.guidedView.form.correctAllErrors.error.txt"));
    	          				    			}
    	          				    		}
    									} else if(variableField.getSelectedItem() == null && variableField.getValue()!=""){
    										if(finalCheck){
    											variableField.setValueState(sap.ui.core.ValueState.Error);
    											errorText.setText(sas.fscf.rb.getText("rules.rulesPage.guidedView.form.variableNotValid.error.txt"));
    											mainErrorText.setText(sas.fscf.rb.getText("rules.rulesPage.guidedView.form.correctAllErrors.error.txt"));
    											sas.fscf.getCurrentPageView().jsonRuleIncomplete = true;
    										}
    									}
    								} else{
    									if(finalCheck){
    										if(leftInputField.getValue().trim()==""){
												sas.fscf.getCurrentPageView().jsonRuleIncomplete = true;
												leftInputField.setValueState(sap.ui.core.ValueState.Error);
												leftInputField.setValueStateText(sas.fscf.rb.getText("rules.rulesPage.guidedView.form.emptyField.error.txt"));
												mainErrorText.setText(sas.fscf.rb.getText("rules.rulesPage.guidedView.form.correctAllErrors.error.txt"));
											}
    										if(variableField.getSelectedItem() == null){
    											sas.fscf.getCurrentPageView().jsonRuleIncomplete = true;
												variableField.setValueState(sap.ui.core.ValueState.Error);
												errorText.setText(sas.fscf.rb.getText("rules.rulesPage.guidedView.form.variableNotValid.error.txt"));
												mainErrorText.setText(sas.fscf.rb.getText("rules.rulesPage.guidedView.form.correctAllErrors.error.txt"));
    										}
										}
    									if(finalCheck){
	          				    			if(rightInputField.getValue().trim()==""){
	          				    				sas.fscf.getCurrentPageView().jsonRuleIncomplete = true;
	          				    				rightInputField.setValueState(sap.ui.core.ValueState.Error);
	          				    				rightInputField.setValueStateText(sas.fscf.rb.getText("rules.rulesPage.guidedView.form.emptyField.error.txt"));
	          				    				mainErrorText.setText(sas.fscf.rb.getText("rules.rulesPage.guidedView.form.correctAllErrors.error.txt"));
	          				    			}
	          				    		}
    								}
								} else{
    								if(!currentToolbar._isNested){
    									mainErrorText.setText("");
    									if(previousToolbarIsNested){
        									j++;
        								}
    									if(leftInputField.getValueState() == sap.ui.core.ValueState.Error || rightInputField.getValueState() == sap.ui.core.ValueState.Error){
    										sas.fscf.getCurrentPageView().jsonRuleIncomplete = true;
    										if(finalCheck){
    											mainErrorText.setText(sas.fscf.rb.getText("rules.rulesPage.guidedView.form.correctAllErrors.error.txt"));
    										}
    									}
    									if(ruleModel["expressions"][j]==null || ruleModel["expressions"][j]==undefined){
    										ruleModel["expressions"][j] = {type:"RANGE",fieldName:"",fieldId:"",fieldType: "Character",leftOperator:"",rightOperator:"",leftValue:"",rightValue:""};
	    								}
    									ruleModel["expressions"][j]["leftValue"] = "" + sas.fscf.floatFormatter.parse(leftInputField.getValue());
	        							ruleModel["expressions"][j]["leftOperator"] = leftOperatorField.getSelectedKey();
	        							ruleModel["expressions"][j]["fieldName"] = variableField.getValue();
	        							ruleModel["expressions"][j]["fieldId"] = variableField.getSelectedKey();
	        							ruleModel["expressions"][j]["fieldType"] = variableField.getSelectedItem()._variableType;
	        							ruleModel["expressions"][j]["rightOperator"] = rightOperatorField.getSelectedKey();
	        							ruleModel["expressions"][j]["rightValue"] = "" + sas.fscf.floatFormatter.parse(rightInputField.getValue());
	        							j++;
	        							k=0;
    								} else if(currentToolbar._isNested){
    									mainErrorText.setText("");
    									if(ruleModel["expressions"][j]["expressions"]==null || ruleModel["expressions"][j]["expressions"]==undefined){
        									ruleModel["expressions"][j]["expressions"] = [{type:"RANGE",fieldName:"",fieldId:"",fieldType: "Character",leftOperator:"",rightOperator:"",leftValue:"",rightValue:""}];
        								}
    									if(leftInputField.getValueState() == sap.ui.core.ValueState.Error || rightInputField.getValueState() == sap.ui.core.ValueState.Error){
    										sas.fscf.getCurrentPageView().jsonRuleIncomplete = true;
    										if(finalCheck){
    											mainErrorText.setText(sas.fscf.rb.getText("rules.rulesPage.guidedView.form.correctAllErrors.error.txt"));
    										}
    									}
    									if(ruleModel["expressions"][j]["expressions"][k]==null || ruleModel["expressions"][j]["expressions"]==undefined){
        									ruleModel["expressions"][j]["expressions"][k] = {type:"RANGE",fieldName:"",fieldId:"",fieldType: "Character",leftOperator:"",rightOperator:"",leftValue:"",rightValue:""};
        								}
    									ruleModel["expressions"][j]["expressions"][k]["leftValue"] = "" + sas.fscf.floatFormatter.parse(leftInputField.getValue());
	        							ruleModel["expressions"][j]["expressions"][k]["leftOperator"] = leftOperatorField.getSelectedKey();
	        							ruleModel["expressions"][j]["expressions"][k]["fieldName"] = variableField.getValue();
	        							ruleModel["expressions"][j]["expressions"][k]["fieldId"] = variableField.getSelectedKey();
	        							ruleModel["expressions"][j]["expressions"][k]["fieldType"] = variableField.getSelectedItem()._variableType;
	        							ruleModel["expressions"][j]["expressions"][k]["rightOperator"] = rightOperatorField.getSelectedKey();
	        							ruleModel["expressions"][j]["expressions"][k]["rightValue"] = "" + sas.fscf.floatFormatter.parse(rightInputField.getValue());
	        							k++;
    								}
    	    					}
    						} else { //regular toolbar

								var variableField = currentToolbar.getContent()[1];
								var operatorField = currentToolbar.getContent()[2];
          				    	var inputField = currentToolbar.getContent()[4];
          				    	var comboBoxField = currentToolbar.getContent()[5];
          				    	var multiInputField = currentToolbar.getContent()[6];
          				    	var errorText = currentToolbar.getContent()[10];
          				    	
          				    	//there's like a empty token in there for some reason, get rid of that
          				    	var tokens = multiInputField.getTokens();
          				    	for( var i = tokens.length-1; i >= 0; i-- ){
          				    		if( tokens[i].getKey().trim() == "" ) {
          				    			multiInputField.removeToken( tokens[i] );
          				    		}	
          				    	}

          				    	//For IN operator - multi input
          				    	var allTokens = multiInputField.getTokens();
          				    	var multiInputArray = [];
          				    	if(allTokens[0]){
          				    		for(let i = 0, n = allTokens.length; i < n; i++) {
          				    			multiInputArray.push(allTokens[i].getKey());
          				    		}
    							}

        						if(variableField.getValue() == "" || variableField.getValue() == null || variableField.getValue()==undefined ||
        						   operatorField.getSelectedKey() == "" || operatorField.getSelectedKey() == null || operatorField.getSelectedKey()==undefined ||
        						   (inputField.getValue().trim()=="" && !sas.fscf.isMissingOperator( operatorField.getSelectedKey() ) && !sas.fscf.isMultivalueOperator(operatorField.getSelectedKey()) && !sas.fscf.isLookupListOperator(operatorField.getSelectedKey())) ||
        						   (multiInputField.getTokens()=="" && sas.fscf.isMultivalueOperator(operatorField.getSelectedKey())) ||
        						   (sas.fscf.isLookupListOperator(operatorField.getSelectedKey()) && (comboBoxField.getValue() == "" || comboBoxField.getValue() == null || comboBoxField.getValue() == undefined ) ) ||
        						   variableField.getSelectedItem() == null
        						){
        							if(!currentToolbar._isNested){
        								if(variableField.getSelectedItem() != null){
        									if(finalCheck){
        										sas.fscf.getCurrentPageView().jsonRuleIncomplete = true;
        										if(sas.fscf.isMultivalueOperator(operatorField.getSelectedKey())){
        											multiInputField.setValueState(sap.ui.core.ValueState.Error);
        											errorText.setText(sas.fscf.rb.getText("rules.rulesPage.guidedView.form.emptyField.error.txt"));
        											mainErrorText.setText(sas.fscf.rb.getText("rules.rulesPage.guidedView.form.correctAllErrors.error.txt"));
        										} else{
        											if( sas.fscf.isLookupListOperator(operatorField.getSelectedKey())) {
        												comboBoxField.setValueState(sap.ui.core.ValueState.Error);
        												comboBoxField.setValueStateText(sas.fscf.rb.getText("rules.rulesPage.guidedView.form.emptyField.error.txt"));
        											} else if(!sas.fscf.isMissingOperator( operatorField.getSelectedKey() )){
        												inputField.setValueState(sap.ui.core.ValueState.Error);
        												//errorText.setText(sas.fscf.rb.getText("rules.rulesPage.guidedView.form.emptyField.error.txt"));
        												inputField.setValueStateText(sas.fscf.rb.getText("rules.rulesPage.guidedView.form.emptyField.error.txt"));
        											}
        										}
        									}
        								} else if(variableField.getSelectedItem() == null && variableField.getValue()!=""){
        									if(finalCheck){
        										variableField.setValueState(sap.ui.core.ValueState.Error);
        										errorText.setText(sas.fscf.rb.getText("rules.rulesPage.guidedView.form.variableNotValid.error.txt"));
        										mainErrorText.setText(sas.fscf.rb.getText("rules.rulesPage.guidedView.form.correctAllErrors.error.txt"));
        										sas.fscf.getCurrentPageView().jsonRuleIncomplete = true;
        									}
        								}
        							} else{
        								if(finalCheck){
        									if(variableField.getSelectedItem() == null){
    											sas.fscf.getCurrentPageView().jsonRuleIncomplete = true;
												variableField.setValueState(sap.ui.core.ValueState.Error);
												errorText.setText(sas.fscf.rb.getText("rules.rulesPage.guidedView.form.variableNotValid.error.txt"));
												mainErrorText.setText(sas.fscf.rb.getText("rules.rulesPage.guidedView.form.correctAllErrors.error.txt"));
    										}
        									if(sas.fscf.isMultivalueOperator(operatorField.getSelectedKey())){
        										multiInputField.setValueState(sap.ui.core.ValueState.Error);
    											errorText.setText(sas.fscf.rb.getText("rules.rulesPage.guidedView.form.emptyField.error.txt"));
    											mainErrorText.setText(sas.fscf.rb.getText("rules.rulesPage.guidedView.form.correctAllErrors.error.txt"));
        									}
        									if(inputField.getValue().trim()=="" && !sas.fscf.isMissingOperator( operatorField.getSelectedKey() ) && !sas.fscf.isMultivalueOperator(operatorField.getSelectedKey()) && !sas.fscf.isLookupListOperator(operatorField.getSelectedKey())){
                  				    			sas.fscf.getCurrentPageView().jsonRuleIncomplete = true;
                  				    			inputField.setValueState(sap.ui.core.ValueState.Error);
                  				    			//errorText.setText(sas.fscf.rb.getText("rules.rulesPage.guidedView.form.emptyField.error.txt"));
                  				    			inputField.setValueStateText(sas.fscf.rb.getText("rules.rulesPage.guidedView.form.emptyField.error.txt"));
                  				    		}
                  				    		if( sas.fscf.isLookupListOperator(operatorField.getSelectedKey()) && comboBoxField.getValue().trim()=="") {
        										comboBoxField.setValueState(sap.ui.core.ValueState.Error);
        										comboBoxField.setValueStateText(sas.fscf.rb.getText("rules.rulesPage.guidedView.form.emptyField.error.txt"));
        									}
              							}
        							}
								} else{
        							if(!currentToolbar._isNested){
        								if(previousToolbarIsNested){
        									j++;
        								}
        								if(finalCheck){
        									if(majorInclusion.getSelectedKey() == "AND" && _this.arrayContains(checkExpArray, variableField.getSelectedKey() + ":" + operatorField.getSelectedKey())){
        										errorText.setText(sas.fscf.rb.getText("rules.rulesPage.guidedView.form.fieldAlreadySet.error.txt"));
        										sas.fscf.getCurrentPageView().jsonRuleIncomplete = true;
        										variableField.setValueState(sap.ui.core.ValueState.Error);
        									} else{
        										checkExpArray.push(variableField.getSelectedKey() + ":" + operatorField.getSelectedKey());
        									}
        									if(inputField.getValueState() == sap.ui.core.ValueState.Error){
        										sas.fscf.getCurrentPageView().jsonRuleIncomplete = true;
        									}
        								/*
        								//this is causing the error message to display and then immediately disappear
        								} else if(!finalCheck){
        									variableField.setValueState(sap.ui.core.ValueState.None);
        									operatorField.setValueState(sap.ui.core.ValueState.None);
        									//inputField.setValueState(sap.ui.core.ValueState.None);
        									comboBoxField.setValueState(sap.ui.core.ValueState.None);
        									multiInputField.setValueState(sap.ui.core.ValueState.None);
        									majorInclusion.setValueState(sap.ui.core.ValueState.None);
        									errorText.setText("");
        									mainErrorText.setText("");
        								*/
        								}
        								if(ruleModel["expressions"][j]==null || ruleModel["expressions"][j]==undefined){
        									ruleModel["expressions"][j] = {type:"COMPARE",fieldName:"",fieldId:"",fieldType: "Character",operator:"",value:""};
        								}
        								ruleModel["expressions"][j]["fieldName"] = variableField.getValue();
        								ruleModel["expressions"][j]["fieldId"] = variableField.getSelectedKey();
        								ruleModel["expressions"][j]["fieldType"] = variableField.getSelectedItem()._variableType;
        								ruleModel["expressions"][j]["operator"] = operatorField.getSelectedKey();
        								ruleModel["expressions"][j]["modifiers"] = currentToolbar._modifiers;
        								if(sas.fscf.isMultivalueOperator(operatorField.getSelectedKey())){
        									ruleModel["expressions"][j]["values"] = multiInputArray;
        								} else if(sas.fscf.isLookupListOperator(operatorField.getSelectedKey())){
        									ruleModel["expressions"][j]["value"] = comboBoxField.getValue();
        								}else{
        									ruleModel["expressions"][j]["value"] = (variableField.getSelectedItem()._variableType == "Currency" || variableField.getSelectedItem()._variableType == "Numeric") ? "" + sas.fscf.floatFormatter.parse(inputField.getValue()) : inputField.getValue();
        								}
	        							j++;
	        							k=0;
        							} else if(currentToolbar._isNested){
        								if(finalCheck){
        									if(lastNestedInclusion.getSelectedKey() == "AND" && _this.arrayContains(checkExpArrayNested, variableField.getSelectedKey() + ":" + operatorField.getSelectedKey())){
        										errorText.setText(sas.fscf.rb.getText("rules.rulesPage.guidedView.form.fieldAlreadySet.error.txt"));
        										sas.fscf.getCurrentPageView().jsonRuleIncomplete = true;
        										variableField.setValueState(sap.ui.core.ValueState.Error);
        									} else{
        										checkExpArrayNested.push(variableField.getSelectedKey() + ":" + operatorField.getSelectedKey());
        									}
        									if(lastNestedInclusion.getSelectedKey() == majorInclusion.getSelectedKey()){
        										sas.fscf.getCurrentPageView().jsonRuleIncomplete = true;
        										lastNestedInclusion.setValueStateText(sas.fscf.rb.getText("rules.rulesPage.guidedView.form.inclusionSame.error.txt"));
        										lastNestedInclusion.setValueState(sap.ui.core.ValueState.Error);
        										majorInclusion.setValueStateText(sas.fscf.rb.getText("rules.rulesPage.guidedView.form.inclusionSame.error.txt"));
        										majorInclusion.setValueState(sap.ui.core.ValueState.Error);
        									}
        									if(inputField.getValueState() == sap.ui.core.ValueState.Error){
        										sas.fscf.getCurrentPageView().jsonRuleIncomplete = true;
        									}
        								} else if(!finalCheck){
        									variableField.setValueState(sap.ui.core.ValueState.None);
        									operatorField.setValueState(sap.ui.core.ValueState.None);
        									comboBoxField.setValueState(sap.ui.core.ValueState.None);
        									//inputField.setValueState(sap.ui.core.ValueState.None);
        									multiInputField.setValueState(sap.ui.core.ValueState.None);
        									majorInclusion.setValueState(sap.ui.core.ValueState.None);
        									lastNestedInclusion.setValueState(sap.ui.core.ValueState.None);
        									errorText.setText("");
        									mainErrorText.setText("");
        								}
        								if(ruleModel["expressions"][j]["expressions"]==null || ruleModel["expressions"][j]["expressions"]==undefined){
        									ruleModel["expressions"][j]["expressions"] = [{type:"COMPARE",fieldName:"",fieldId:"",fieldType: "Character",operator:"",value:""}];
        								}
        								if(ruleModel["expressions"][j]["expressions"][k]==null || ruleModel["expressions"][j]["expressions"]==undefined){
        									ruleModel["expressions"][j]["expressions"][k] = {type:"COMPARE",fieldName:"",fieldId:"",fieldType: "Character",operator:"",value:""};
        								}
        								ruleModel["expressions"][j]["expressions"][k]["fieldName"] = variableField.getValue();
        								ruleModel["expressions"][j]["expressions"][k]["fieldId"] = variableField.getSelectedKey();
        								ruleModel["expressions"][j]["expressions"][k]["fieldType"] = variableField.getSelectedItem()._variableType;
        								ruleModel["expressions"][j]["expressions"][k]["operator"] = operatorField.getSelectedKey();
        								ruleModel["expressions"][j]["expressions"][k]["modifiers"] = currentToolbar._modifiers;
        								if(sas.fscf.isMultivalueOperator(operatorField.getSelectedKey())){
        									ruleModel["expressions"][j]["expressions"][k]["values"] = multiInputArray;
        								}else if (sas.fscf.isLookupListOperator(operatorField.getSelectedKey())) {
        									ruleModel["expressions"][j]["expressions"][k]["value"] = comboBoxField.getValue();
        								} else{
        									ruleModel["expressions"][j]["expressions"][k]["value"] = (variableField.getSelectedItem()._variableType == "Currency" || variableField.getSelectedItem()._variableType == "Numeric") ? "" + sas.fscf.floatFormatter.parse(inputField.getValue()) : inputField.getValue();
        								}
        								k++;
        							}
        						}
        					}
    					}
    				}
    			}
    		}
    	}
    	sas.fscf.getCurrentPageView().jsonRule.expressions.expressions[0].condition = ruleModel;
    	sas.fscf.getCurrentPageView().initIdsForExpressions("F", sas.fscf.getCurrentPageView().jsonRule.expressions.expressions[0].condition.expressions);
    },

    clearRulePanelData: function() {
    	if (sas.fscf.getCurrentPageView().jsonRule.expressions.expressions[0].properties) {
    		sas.fscf.getCurrentPageView().jsonRule.expressions.expressions[0].properties.panelData = undefined;
    	}
    },
    
    setPopulationIndicator: function(total, current) {
    	//console.info("in setPopulationIndicator, total = " + total + ", current = " + current);
		var oProgIndicator = sap.ui.getCore().byId(this.sId + "FullFormPopulationIndicator");
		if (oProgIndicator) {
			if (total != 0) {
				oProgIndicator.setPercentValue((current / total) * 100);
				oProgIndicator.setDisplayValue(sas.fscf.percentFormatter.format(current / total) + " (" + sas.fscf.rb.getText("rules.rulesPage.guidedView.population.xofy.fmt.txt", [sas.fscf.floatFormatter.format(current), sas.fscf.floatFormatter.format(total)]) + ")");
			} else {
				oProgIndicator.setPercentValue(100);
				oProgIndicator.setDisplayValue(sas.fscf.percentFormatter.format(1));
			}
		}
    },

    synchPopulationIndicator: function(anotherProgIndicator) {
		var oProgIndicator = sap.ui.getCore().byId(this.sId + "FullFormPopulationIndicator");
		if (oProgIndicator) {
			oProgIndicator.setPercentValue(anotherProgIndicator.getPercentValue());
			oProgIndicator.setDisplayValue(anotherProgIndicator.getDisplayValue());
		}
    },

    somethingChangedInFullForm: function() {
    	//console.info("in somethingChangedInFullForm");
    	var _this = this;
    	// set the dirty flag
    	sas.fscf.removeAllMessageStrips();
		sas.fscf.getCurrentPageView().setDirty(true);
		// slight delay to make sure the change is fully done processing before we continue
		setTimeout(function () {
			// update the rule model
	    	_this.updateModelFromFullForm();
	    	_this.reload();
		}, 100);
    },

    reload: function() {
    	var _this = this;
    	// update the population indicator
        sas.ajax({url:sas.fscf.getQueryUrlFromRuleModel("search", null, []), dataType:"json", headers:sas.fscf.getAjaxHeaders()})
          .done(function(oData){
        	  if (Object.keys(oData) && Object.keys(oData)[0]) {
            	  _this.setPopulationIndicator(oData[Object.keys(oData)[0]]["total"], oData[Object.keys(oData)[0]]["match"]);
        	  }
	    }).fail(function(oObj,textStatus){
	       console.info("an error occurred getting the totals");
	    });
    	// update the related rows
    	_this.getRelatedRows().update();
    },
    
    getPalette: function() {
    	// Strip off FormView from this.sId, which is RulesPageGuidedViewFormView, and then concatenate it with "PaletteView".
    	return sap.ui.getCore().byId(this.sId.substr(0, this.sId.indexOf("FormView")) + "PaletteView");
    },

    getGrid: function() {
    	return sap.ui.getCore().byId(this.sId.substr(0, this.sId.indexOf("FormView")) + "GridView");
    },

    getActions: function() {
    	return sap.ui.getCore().byId(this.sId.substr(0, this.sId.indexOf("FormView")) + "ActionsView");
    },

    getRelatedRows: function() {
    	return sap.ui.getCore().byId(this.sId.substr(0, this.sId.indexOf("FormView")) + "RelatedRowsView");
    },

    getActionConfiguration: function() {
    	var view = sap.ui.jsfragment({
            type: sap.ui.core.mvc.ViewType.JS,
            id: this.sId + "AlertCreationConfigurationDialog",
            fragmentName: "sas.fscf.views.fragments.AlertCreationConfigurationDialog"
        });
    	return view.lazyLoadContent();
    },
    
    getLookupListsForBox: function( comboBox, keyField ) {
		sas.fscf.getLookupListsForBox( comboBox, keyField, comboBox._lastValue );
    }
} );
