jQuery.sap.declare('sas.fscf.CustomBootTask');

jQuery.sap.require('sas.hc.ui.core.Core');
jQuery.sap.require('sas.hc.ui.core.BootTask');
jQuery.sap.require('sap.ui.core.format.NumberFormat');
jQuery.sap.require('sap.ui.core.format.DateFormat');
jQuery.sap.require('sap.ui.unified.Calendar');

sas.hc.ui.core.BootTask.extend("sas.fscf.CustomBootTask", {
    name: 'SAS-fscf-CustomBootTask'
});

sas.fscf.CustomBootTask.prototype.run = function () {
	// Do stuff here to participate in the boot strap
	// Generally stuff you want to do before application view is instantiated.

    jQuery.sap.includeStyleSheet("resources/sas/fscf/fscf.css");

    sas.config.initialSessionMaxInActiveInterval = sas.config.sessionMaxInActiveInterval;
    sas.config.initialSessionTimeoutWarningDuration = sas.config.sessionTimeoutWarningDuration;
    sas.fscf.NLS_BASE = 'sas.fscf';
    sas.fscf.MESSAGE_BUNDLE_PATH = 'resources/sas/fscf/messagebundle.properties';
    sas.fscf.rb = sap.ui.getCore().getLibraryResourceBundle(sas.fscf.NLS_BASE);
	var resp = sas.ajax({url:'rest/users/@currentUser'});
	resp.done(function(oData){
	      sas.fscf.currentUser = oData;
	      sas.fscf.SFM_TOKEN = btoa(resp.getResponseHeader("__sfmrt"));
	}).fail(function(oObj,textStatus){			
       console.info("Failed to get current user.");
	});

	sas.fscf.escapeHTML = function(str) {
	    var p = document.createElement("p");
	    p.appendChild(document.createTextNode(str));
	    return p.innerHTML;
	};
    sas.fscf.floatFormatter = sap.ui.core.format.NumberFormat.getFloatInstance({maxFractionDigits: 2});
    sas.fscf.floatFormatterTranData = sap.ui.core.format.NumberFormat.getFloatInstance({pattern: sas.config.get('fscf').decimalFormat});
    sas.fscf.percentFormatter = sap.ui.core.format.NumberFormat.getPercentInstance({minFractionDigits:2,maxFractionDigits:2});
    sas.fscf.currencyFormatter = sap.ui.core.format.NumberFormat.getCurrencyInstance({pattern: sas.config.get('fscf').currencyFormat});
    sas.fscf.dateTimeFormatter = sap.ui.core.format.DateFormat.getDateTimeInstance({pattern: sas.config.get('fscf').dateTimeFormat});
    sas.fscf.dateFormatter = sap.ui.core.format.DateFormat.getDateInstance({pattern: sas.config.get('fscf').dateFormat});
    sas.fscf.timeFormatter = sap.ui.core.format.DateFormat.getTimeInstance({pattern: sas.config.get('fscf').timeFormat});
	sas.fscf.floatAbbreviations = [" ", 
	                               sas.fscf.rb.getText("fcm.application.abbreviation.thousand.txt"), 
	                               sas.fscf.rb.getText("fcm.application.abbreviation.million.txt"), 
	                               sas.fscf.rb.getText("fcm.application.abbreviation.billion.txt"), 
	                               sas.fscf.rb.getText("fcm.application.abbreviation.trillion.txt"), 
	                               sas.fscf.rb.getText("fcm.application.abbreviation.quadrillion.txt")];
	sas.fscf.abbreviateFloat = function(n, formatter) {
	    // what tier? (determines suffix)
		var tier = 0;
		if (Math.abs(n) >= 1000) tier = 1;
		if (Math.abs(n) >= 1000000) tier = 2;
		if (Math.abs(n) >= 1000000000) tier = 3;
		if (Math.abs(n) >= 1000000000000) tier = 4;
		if (Math.abs(n) >= 1000000000000000) tier = 5;

	    // determine scale
	    var scale = Math.pow(10, tier * 3);

	    // scale the number
	    var scaled = n / scale;
	    	    
	    // increase tier and rescale if not already at the max tier and scaled is 1000
	    if (tier < 5 && Math.round(scaled * 100) / 100 == 1000) {		// 2 decimal places
	    	tier++;
		    scale = Math.pow(10, tier * 3);
		    scaled = n / scale;
	    }
	    
	    // format number and add suffix
	    var suffix = sas.fscf.floatAbbreviations[tier];
	    if (!formatter) {
	    	formatter = sas.fscf.floatFormatter;
	    }
	    return formatter.format(scaled) + suffix;
	};
	sas.fscf.abbreviateCurrency = function(n) {
		return sas.fscf.abbreviateFloat(n, sas.fscf.currencyFormatter);
	};
    sas.fscf.enableDynamicLookupLists = sas.config.get('fscf').enableDynamicLookupLists;
    sas.fscf.deployTestingRules = sas.config.get('fscf').deployTestingRules;
    sas.fscf.RULE_APPROACH_GUIDED = 0;
    sas.fscf.RULE_APPROACH_CODING = 1;

/*    sas.fscf.helpUrlLookup = {
    	"ITabReports":"a_reports.htm",
    	"ITabStrategies":"a_strategies.htm",
    	"ITabTemplates":"a_templates.htm",
    	"ITabNotifications":"a_notifications.htm",
    	"ITabGroups":"a_groupTab.htm",
    	"ITabUsers":"a_users.htm",
    	"ITabModel":"a_modelTab.htm",
    	"ITabAnalystWorkstation":"fcmAppMain.htm",
    	"ITabPreference":"a_preferences.htm",
    	"ITabRules":"r_rulesView.htm",
    	"ITabConsole":"r_consoleView.htm",
    	"ITabLoader":"a_incrloader.htm"
    };*/
    sas.fscf.resizeContainers = function () {
		$("#sas_hc_content .sasFCHContent").css("overflow", "hidden");
		$("#sas_hc_content .sasFCHContent").height(
				$("#sas_hc_content .sasFCHContent").parent().height() -
				$("#sas_hc_content .sasFHCHeader").height());
    	$("#sas_hc_content .sapMITBContainerContent").height(
    			$("#sas_hc_content .sasFCHContent").height() -
    			$("#sas_hc_content .sapMITH").height() - 3);
    	var $iframe = $("iframe[name='overview']");
    	if ($iframe.length) {
    		var h = Math.floor($iframe.parent().height() -
    				($iframe.position().top - $iframe.parent().position().top)) - 6;
    		$iframe.css("height", h + "px")
    	}
    	$iframe = $("iframe[name='detail']");
    	if ($iframe.length) {
    		var h = Math.floor($iframe.parent().height() -
    				($iframe.position().top - $iframe.parent().position().top)) - 6;
    		$iframe.css("height", h + "px")
    	}
    };
    $(document).ready(sas.fscf.resizeContainers);
    $(window).resize(sas.fscf.resizeContainers);
	sas.fscf.sessionBindIFrames = function () {
		$("iframe").load(function (e) {
			sas.fscf.sessionUserActivity();
			$(e.target).contents().click(function (e) {
				sas.fscf.sessionUserActivity();
				return true;
			});
		});
	};
	sas.fscf.setCookie = function(name,value,expireDate)
	{
		if(!value || value == '')
		{
			sas.fscf.removeCookie(name,'');
			return;
		}

		var theDate;
		if(expireDate)
		{
			theDate = expireDate;
		}
		else
		{
			theDate = new Date();
			theDate.setDate(theDate.getDate()+1);
		}

		document.cookie = name + "=" + escape(value) + ";expires=" + theDate.toGMTString();
	};
	sas.fscf.getCookie = function(name,defaultValue)
	{
		if (name == "__sfmrt") {
			return sas.fscf.tokenValue();
		}
		var cookies = document.cookie.split("; ");
		for(var i=0; i < cookies.length; i++)
		{
			var theCookie = cookies[i].split("=");
			if (name == theCookie[0])
				return unescape(theCookie[1]);
		}

		return defaultValue;
	};
	sas.fscf.removeCookie = function(name,value)
	{
		var theDate = new Date();
		theDate.setDate(theDate.getDate()-1);
		document.cookie = name + "=" + escape(value) + ";expires=" + theDate.toGMTString();
	};
	sas.fscf.tokenValue = function() {
		if (sas.fscf.SFM_TOKEN==undefined) {
			console.warn("Did not find sas.fscf.SFM_TOKEN");		  
			return "";
		}
	
		return atob(sas.fscf.SFM_TOKEN);
	};
	sas.fscf.getAjaxHeaders = function()
	{
		// common headers that must go on our ajax calls
		return {"__sfmrt":sas.fscf.getCookie("__sfmrt")};
	};
	sas.fscf.getNYearsFromNow = function(n)
	{
		var d = new Date();
		d.setFullYear(d.getFullYear() + n);
		return d;
	};
	sas.fscf.userHasPrivilege = function(privilege)
	{
		// Someone could ask for has privilege before the asynchronous ajax call to the rest feed
		// that sets sas.fscf.currentUser (above) is finished, so this does up to 15 time-delayed checks
		// for sas.fscf.currentUser if needed. Once sas.fscf.currentUser is done being set once,
		// the time-delayed checks won't ever be needed/used. Typically only 1 time-delayed check is
		// ever needed if any.
		var doCheck = function(privilege) {
			if (sas.fscf.currentUser) {
				for (var i = 0; i < sas.fscf.currentUser.roles.length; i++) {
					for (var j = 0; j < sas.fscf.currentUser.roles[i].privileges.length; j++) {
						if (sas.fscf.currentUser.roles[i].privileges[j].name == privilege) {
							return true;
						}
					}
				}
			}
			return false;
		};
		
		if (sas.fscf.currentUser) {
			return doCheck(privilege);
		} else {
			var count = 0;
			var timer = setInterval(function () {
				if (sas.fscf.currentUser || (count > 15)) {
	    			clearInterval(timer);
	    			return doCheck(privilege);
				} else {
					count++;
				}
			}, 500);			
		}
	};
};

// register with sas hc
(function () {
    sas.hc.ui.getCore().registerTask(new sas.fscf.CustomBootTask());
}())
