jQuery.sap.require("sas.hc.m.MessageStrip");
jQuery.sap.require("sas.hc.m.MessageDialog");
        
sap.ui.controller("sas.fscf.Application", {

    getView: function() {
        return this.oView;
    },

    onInit: function () {
		sas.fscf.getEmptyRuleExpressions = function() {
			return {type:"ExpressionList",expressions:[{type:"IF",condition:{"type": "AND","operator": "AND",expressions:[]},properties:{view:"grid"},thenActions:[]}]};
		};
    },

    
    onBeforeRendering: function () {
/*    	//Overwrite browser and devices link 
    	sas.fscf.banner = sap.ui.getCore().byId("sas_fscf_appContainer_banner");
    	var aboutPopover = sas.fscf.banner._helpAboutController._getViewer("ABOUT");
    	if(aboutPopover.getContent()) { 
        	aboutPopover.destroyContent();
    	}
    	sas.hc.ui.commons.banner.help.AboutContentPETProvider.prototype.getPlatformLink=function(){
    		return "http://support.sas.com/kb/46/addl/fusion_46539_1_3rd_party_support_matrix_current.pdf"
    	}
    	var myModel = new sas.hc.ui.commons.banner.help.AboutContentPETProvider();// (viya or AboutContentProvider for wip)
    	aboutPopover.setModel(myModel);*/
    },

    onAfterRendering: function () {
    	sas.fscf.sessionUserActivity = function () {
    		sas.eventBus.publish(sas.timeoutManager.events.USER_ACTIVE);
    	};
    	window.addEventListener("click", function(e){
    		sas.fscf.sessionUserActivity();
    		//console.log("CLICK " + new Date().getTime());
    	}, false);    	

    	sas.fscf.banner = sap.ui.getCore().byId("sas_fscf_appContainer_banner");
    	sas.fscf.banner.setShowSearch(false);
    	sas.fscf.banner.setShowNotifications(false);
    	sas.fscf.banner.setHelpUrl('common/help.jsp');
    	sas.fscf.banner.setUserName(sas.config.get('fscf').userId);
    	sas.fscf.banner.setUserLastLoginMsg = function (lastLoginMsg) {
    		$('#banner-userLastLoginMsg').remove();
    		$('#sas_fscf_appContainer_banner-toolbar').find('.sapMTBSpacer').after('<span id="banner-userLastLoginMsg" style="font-size:0.7rem;margin-right:1rem">' + lastLoginMsg + '</span>');
    	};
    	sas.fscf.banner.onBeforerRendering = function () {
        	if (sas.hc.ui.commons.banner.Banner.prototype.onBeforeRendering) {
        		sas.hc.ui.commons.banner.Banner.prototype.onBeforeRendering.apply(this);
        	}
    	};
    	sas.fscf.banner.onAfterRendering = function () {
        	if (sas.hc.ui.commons.banner.Banner.prototype.onAfterRendering) {
        		sas.hc.ui.commons.banner.Banner.prototype.onAfterRendering.apply(this);
        	}
            setTimeout(function () {
            	sas.fscf.banner.setUserLastLoginMsg(sas.config.get('fscf').userLastLoginMsg);
            }, 1000);
    	};
    	sas.fscf.banner.addExtraButton = function (title, idFragment, onclick, icon, fontSize) {
    		var extraBB = [];
    		extraBB[extraBB.length] = '<button title="' + title + '" class="bannerExtraButton sapMBtn sapMBtnBase sasIconBtn" id="banner-' + idFragment + '" aria-label="' + title + '" data-sap-ui="banner-' + idFragment + '" onclick="' + onclick + '">';
    		extraBB[extraBB.length] = '<span class="sapMBtnDefault sapMBtnHoverable sapMBtnIconFirst sapMBtnInner sapMFocusable sapMIE" id="banner-' + idFragment + '-inner">';
    		extraBB[extraBB.length] = '<span class="sapMBtnCustomIcon sapMBtnIcon sapMBtnIconLeft sapUiIcon" id="banner-' + idFragment + '-img" role="presentation" style=\'font-family: "sas-icons"\' data-sap-ui-icon-content="' + icon + '" data-sap-ui="banner-' + idFragment + '-img"></span>';
    		extraBB[extraBB.length] = '<span class="sapMBtnFocusDiv"></span>';
    		extraBB[extraBB.length] = '</span>';
    		extraBB[extraBB.length] = '</button>';
    			
    		if ($('#banner-userLastLoginMsg').length) {
    			$('#banner-userLastLoginMsg').after(extraBB.join(''));
    		} else {
        		$('#sas_fscf_appContainer_banner-toolbar').find('.sapMTBSpacer').after(extraBB.join(''));
    		}
    	};
    	sas.fscf.banner.removeAllExtraButtons = function () {
    		$('.bannerExtraButton').remove();
    	};
    	sas.fscf.banner.handleTabChange = function (tabKey) {
    		sas.fscf.setCookie("cf_lastTab", tabKey);
    		this.removeAllExtraButtons();
    		sas.fscf.banner.setHelpUrl('common/help.jsp');
    	};
    	if (sas.fscf.tabBar) {
        	sas.fscf.tabBar.attachSelect(function(e){this.handleTabChange(e.mParameters.key)}, sas.fscf.banner);
    	}
    	sas.fscf.getCurrentOverviewToolbar = function(){
        	if (sas.fscf.tabBar) {
        		return sap.ui.getCore().byId(sap.ui.getCore().byId(sas.fscf.tabBar.getSelectedKey()).getContent()[0].sId + "OverviewViewToolbar") ||
        			   sap.ui.getCore().byId(sap.ui.getCore().byId(sas.fscf.tabBar.getSelectedKey()).getContent()[0].sId + "LegacyViewOverviewViewToolbar");
        	} else {
        		return sap.ui.getCore().byId(sas.fscf.singleView.sId + "OverviewViewToolbar") ||
        			   sap.ui.getCore().byId(sas.fscf.singleView.sId + "LegacyViewOverviewViewToolbar");
        	}
    	};
    	sas.fscf.getCurrentDetailToolbar = function(){
        	if (sas.fscf.tabBar) {
        		return sap.ui.getCore().byId(sap.ui.getCore().byId(sas.fscf.tabBar.getSelectedKey()).getContent()[0].sId + "DetailsViewToolbar") ||
        			   sap.ui.getCore().byId(sap.ui.getCore().byId(sas.fscf.tabBar.getSelectedKey()).getContent()[0].sId + "LegacyViewDetailsViewToolbar");
        	} else {
        		return sap.ui.getCore().byId(sas.fscf.singleView.sId + "DetailsViewToolbar") ||
        			   sap.ui.getCore().byId(sas.fscf.singleView.sId + "LegacyViewDetailsViewToolbar");
        	}
    	};
    	sas.fscf.getCurrentDetailView = function(){
        	if (sas.fscf.tabBar) {
        		return sap.ui.getCore().byId(sap.ui.getCore().byId(sas.fscf.tabBar.getSelectedKey()).getContent()[0].sId + "DetailsView") ||
        			   sap.ui.getCore().byId(sap.ui.getCore().byId(sas.fscf.tabBar.getSelectedKey()).getContent()[0].sId + "LegacyViewDetailsView");
        	} else {
        		return sap.ui.getCore().byId(sas.fscf.singleView.sId + "DetailsView") ||
        			   sap.ui.getCore().byId(sas.fscf.singleView.sId + "LegacyViewDetailsView");
        	}
    	};
    	sas.fscf.getCurrentPageView = function(){
        	if (sas.fscf.tabBar) {
        		return sap.ui.getCore().byId(sas.fscf.tabBar.getSelectedKey()).getContent()[0];
        	} else {
        		return sas.fscf.singleView;
        	}
    	};
    	sas.fscf.getApplicationView = function(){
       		return sap.ui.getCore().byId("sas_fscf");
    	};
        sas.fscf.showMessageStrip = function(type, message, containerId) {
			var container = sap.ui.getCore().byId(containerId);
			if (container && container.insertContent) {
	            // remove and destroy any message strip that is already there
	        	var ms = sap.ui.getCore().byId(container.sId + "-messageStrip");
	        	if (ms) {
	        		container.removeContent(ms);
	        		ms.destroy();
	        	}
	        	// create message strip
	        	if (!type) {
	        		type = sap.ui.core.MessageType.Information;
	        	}
	    		ms = new sas.hc.m.MessageStrip({
	                id: container.sId + "-messageStrip",
	                text: message,
	                type: type,
	                showIcon: true,
	                showCloseButton: true,
	                close: function() {
	                   // remove and destroy the message strip rather than just let it be hidden (default behavior)
	                   ms = container.removeContent(ms);
	                   ms.destroy();
	                }
	            });
				// insert/show message strip
	        	container.insertContent(ms);
			}
        };
        sas.fscf.showErrorMessageStrip = function (message, containerId) {
        	sas.fscf.showMessageStrip(sap.ui.core.MessageType.Error, message, containerId);
        };
        sas.fscf.showInfoMessageStrip = function (message, containerId) {
        	sas.fscf.showMessageStrip(sap.ui.core.MessageType.Information, message, containerId);
        };
        sas.fscf.showSuccessMessageStrip = function (message, containerId) {
        	sas.fscf.showMessageStrip(sap.ui.core.MessageType.Success, message, containerId);
        };
        sas.fscf.showWarningMessageStrip = function (message, containerId) {
        	sas.fscf.showMessageStrip(sap.ui.core.MessageType.Warning, message, containerId);
        };
        sas.fscf.removeAllMessageStrips = function() {
        	var elements = $(".sapMMsgStrip");
        	var ms;
        	for (var i = 0; i < elements.length; i++) {
        		ms = sap.ui.getCore().byId(elements[i].id);
        		if (ms) {
        			var container = ms.getParent();
        			if (container && container.removeContent) {
	        			ms = container.removeContent(ms);
	        			ms.destroy();
        			}
        		}
        	}
        	
        };
        sas.fscf.showMessageDialog = function(type, message) {
        	if (type == sap.ui.core.MessageType.Error) {
        		sas.hc.m.MessageDialog.error({
                    title: sas.fscf.rb.getText('fcm.application.message.type.error.txt'),
                    text: message
                });
        	} else if (type == sap.ui.core.MessageType.Warning) {
        		sas.hc.m.MessageDialog.warning({
                    title: sas.fscf.rb.getText('fcm.application.message.type.warning.txt'),
                    text: message
                });
        	} else if (type == sap.ui.core.MessageType.Success) {
        		sas.hc.m.MessageDialog.information({
                    title: sas.fscf.rb.getText('fcm.application.message.type.success.txt'),
                    text: message
                });
        	} else {
        		sas.hc.m.MessageDialog.information({
                    title: sas.fscf.rb.getText('fcm.application.message.type.information.txt'),
                    text: message
                });
        	}    	
        };
    	sas.fscf.openPopout = function(tabName){
    		return window.open("popoutTab.action?tabName="+tabName, "FCMPopoutWin",
    				"toolbar=no,location=no,menubar=no,scrollbars=yes,status=yes,"+
    				"resizable=yes,copyhistory=no,left=" + (screen.width - (screen.width * 0.6) - 20) + 
    				",top=" + (screen.height - (screen.height * 0.6) - 65) +
    				",width=" + (screen.width * 0.6) + 
    				",height=" + (screen.height * 0.6));
    	};
    	sas.fscf.explore = function(multiOrgId, field, value){
    		var win = sas.fscf.openPopout("explore");
    		$(win.document).ready(function() {
    			var count = 0;
    			var timer = setInterval(function () {
    				if ((win.sas && win.sap && win.sap.ui.getCore().byId("ExplorePageGuidedView")) || (count > 15)) {
    	    			clearInterval(timer);
    	    			win.sas.ajax({url:"rest/multiorgs/" + multiOrgId, type: "GET", dataType:"json", headers:sas.fscf.getAjaxHeaders()})
    	    		  	  .done(function(oData){
    	    		  		  if (oData.items) {
    	    		  			  var multiOrgKey = oData.items[0].key; 
    	    			  		  
    	      					  var exps = win.sas.fscf.getCurrentPageView().jsonRule.expressions.expressions[0].condition.expressions;
	    	    				  exps[exps.length] = {
	    	    						"id": "F-1",
	    	   	                        "type": "COMPARE",
	    	   	                        "operator": "EQUAL",
	    	   	                        "fieldId": 24,
	    	   	                        "fieldName": "SMH_MULTI_ORG_NODE_KEY",
	    	   	                        "fieldType": "Character",
	    	   	                        "value": multiOrgKey
    	    	                  };
	    	    				  exps[exps.length] = {
	    	   							"id": "F-2",
	    	   	                        "type": "COMPARE",
	    	   	                        "operator": "EQUAL",
	    	   	                        "fieldId": 24,
	    	   	                        "fieldName": field,
	    	   	                        "fieldType": "Character",
	    	   	                        "value": value
	    	       	              };
	    	    				  win.sas.fscf.ruleApproach = win.sas.fscf.RULE_APPROACH_GUIDED;
	    	    				  win.sas.fscf.loadRule(win.sap.ui.getCore().byId("ExplorePageGuidedView"));
    	    		  		  }
    	    			  }).fail(function(oObj,textStatus){
	      					  var exps = win.sas.fscf.getCurrentPageView().jsonRule.expressions.expressions[0].condition.expressions;
    	    				  exps[exps.length] = {
    	    						"id": "F-1",
    	   	                        "type": "COMPARE",
    	   	                        "operator": "IN",
    	   	                        "fieldId": 24,
    	   	                        "fieldName": "SMH_MULTI_ORG_NODE_KEY",
    	   	                        "fieldType": "Character",
    	   	                        "values": []
	    	                  };
    	    				  exps[exps.length] = {
    	   							"id": "F-2",
    	   	                        "type": "COMPARE",
    	   	                        "operator": "EQUAL",
    	   	                        "fieldId": 24,
    	   	                        "fieldName": field,
    	   	                        "fieldType": "Character",
    	   	                        "value": value
    	       	              };
    	    				  win.sas.fscf.ruleApproach = win.sas.fscf.RULE_APPROACH_GUIDED;
    	    				  win.sas.fscf.loadRule(win.sap.ui.getCore().byId("ExplorePageGuidedView"));
    	    			});		    	    			
    				} else {
    					count++;
    				}
    			}, 500);
    		});
    	};
    	if (sas.fscf.tabBar) {
        	this.oView.handleTabChange(sas.fscf.tabBar.getSelectedKey());
    	} else {
            var tabs = sas.config.get('fscf').tabs;
        	this.oView.handleTabChange("ITab" + tabs[0].name);
    	}
    },

    onExit: function () {
    }

});
