/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

sap.ui.define(['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * Header renderer.
	 * @namespace
	 */
	var HeaderRenderer = {
	};

	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.ui.unified.calendar.Header} oHead an object representation of the control that should be rendered
	 */
	HeaderRenderer.render = function(oRm, oHead){
		var sLanguage = sap.ui.getCore().getConfiguration().getLocale().getLanguage();
		var sTooltip = oHead.getTooltip_AsString();
		var sId = oHead.getId();
		var mAccProps = {};
		// SAS Edit Start
		// S1314354
		//var sLabelNext = sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified").getText("CALENDAR_BTN_NEXT");
		//var sLabelPrev = sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified").getText("CALENDAR_BTN_PREV");
		//SAS Edit End

		oRm.write("<div");
		oRm.writeControlData(oHead);
		oRm.addClass("sapUiCalHead");
		oRm.writeClasses();

		if (sTooltip) {
			oRm.writeAttributeEscaped('title', sTooltip);
		}

		oRm.writeAccessibilityState(oHead);

		oRm.write(">"); // div element

		oRm.write("<button");
		oRm.writeAttributeEscaped('id', sId + '-prev');

		// SAS Edit Start
		// S1314354
		// This allows us to set tooltip on Button
		oRm.writeAttributeEscaped('title', this.getPreviousTooltip(oHead));
		oRm.writeAccessibilityState(null, { label: this.getPreviousTooltip(oHead)});
		//oRm.writeAttribute('aria-label', this.getPreviousTooltip(oHead));
		// SAS Edit End

		oRm.addClass("sapUiCalHeadPrev");
		if (!oHead.getEnabledPrevious()) {
			oRm.addClass("sapUiCalDsbl");
			oRm.writeAttribute('disabled', "disabled");
		}
		oRm.writeAttribute('tabindex', "-1");
		oRm.writeClasses();
		oRm.write(">"); // button element

		//SAS Edit Start
		/* oRm.writeIcon("sap-icon://slim-arrow-left", null, { title: null }); */
		this.renderHeaderPreviousIcon(oRm, oHead);
		//SAS Edit End

		oRm.write("</button>");

		var iFirst = -1;
		var iLast = -1;
		var i = 0;
		var iBtn;
		for (i = 0; i < 3; i++) {
			if (oHead["getVisibleButton" + i]()) {
				if (iFirst < 0) {
					iFirst = i;
				}
				iLast = i;
			}
		}

		for (i = 0; i < 3; i++) {
			// for Chinese and Japanese the date should be displayed in year, month, day order
			if (sLanguage.toLowerCase() === "ja" || sLanguage.toLowerCase() === "zh") {
				iBtn = 2 - i;
			} else {
				iBtn = i;
			}
			this.renderCalendarButtons(oRm, oHead, sId, iFirst, iLast, mAccProps, iBtn);
		}

		oRm.write("<button");
		oRm.writeAttributeEscaped('id', sId + '-next');

		// SAS Edit Start
		// S1314354
		// This allows us to set tooltip on Button
		oRm.writeAttribute('title', this.getNextTooltip(oHead));
		oRm.writeAccessibilityState(null, { label: this.getNextTooltip(oHead)});
		//oRm.writeAttribute('aria-label', this.getNextTooltip(oHead));
		// SAS Edit End

		oRm.addClass("sapUiCalHeadNext");
		if (!oHead.getEnabledNext()) {
			oRm.addClass("sapUiCalDsbl");
			oRm.writeAttribute('disabled', "disabled");
		}
		oRm.writeAttribute('tabindex', "-1");
		oRm.writeClasses();

		oRm.write(">"); // button element

		//SAS Edit Start
		/* oRm.writeIcon("sap-icon://slim-arrow-right", null, { title: null }); */
		this.renderHeaderNextIcon(oRm, oHead);
		//SAS Edit End

		oRm.write("</button>");

		oRm.write("</div>");

	};

	HeaderRenderer.renderCalendarButtons = function (oRm, oHead, sId, iFirst, iLast, mAccProps, i) {
		if (oHead["getVisibleButton" + i]()) {
			oRm.write("<button");
			oRm.writeAttributeEscaped('id', sId + '-B' + i);
			oRm.addClass("sapUiCalHeadB");
			oRm.addClass("sapUiCalHeadB" + i);
			if (iFirst == i) {
				oRm.addClass("sapUiCalHeadBFirst");
			}
			if (iLast == i) {
				oRm.addClass("sapUiCalHeadBLast");
			}
			oRm.writeAttribute('tabindex', "-1");
			oRm.writeClasses();
			if (oHead["getAriaLabelButton" + i]()) {
				mAccProps["label"] = jQuery.sap.encodeHTML(oHead["getAriaLabelButton" + i]());
			}
			oRm.writeAccessibilityState(null, mAccProps);
			mAccProps = {};
			oRm.write(">"); // button element
			var sText = oHead["getTextButton" + i]() || "";
			var sAddText = oHead["getAdditionalTextButton" + i]() || "";
			if (sAddText) {
				oRm.write("<span");
				oRm.writeAttributeEscaped('id', sId + '-B' + i + "-Text");
				oRm.addClass("sapUiCalHeadBText");
				oRm.writeClasses();
				oRm.write(">"); // span element
				oRm.writeEscaped(sText);
				oRm.write("</span>");

				oRm.write("<span");
				oRm.writeAttributeEscaped('id', sId + '-B' + i + "-AddText");
				oRm.addClass("sapUiCalHeadBAddText");
				oRm.writeClasses();
				oRm.write(">"); // span element
				oRm.writeEscaped(sAddText);
				oRm.write("</span>");
			} else {
				oRm.writeEscaped(sText);
			}
			oRm.write("</button>");
		}
	};

	//SAS Edit Start
	//GUIDESINF-916
	HeaderRenderer.renderHeaderPreviousIcon = function(oRm, oHead) {
		oRm.writeIcon("sap-icon://slim-arrow-left", null, { title: null });
	};

	HeaderRenderer.renderHeaderNextIcon = function(oRm, oHead) {
		oRm.writeIcon("sap-icon://slim-arrow-right", null, { title: null });
	};
	//SAS Edit End

	// SAS Edit Start
	// S1314354
	// This allows us to intercept and set tooltip on Button for FF
	HeaderRenderer.getPreviousTooltip = function() {
		var sLabelPrev = sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified").getText("CALENDAR_BTN_PREV");
		return sLabelPrev;
	};

	HeaderRenderer.getNextTooltip = function() {
		var sLabelNext = sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified").getText("CALENDAR_BTN_NEXT");
		return sLabelNext;
	};
	// SAS Edit End

	return HeaderRenderer;

}, /* bExport= */ true);
