sap.ui.require.preload({
	"sap/ui/layout/AlignedFlowLayout.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/core/Control\",\"./library\",\"sap/ui/core/ResizeHandler\",\"./AlignedFlowLayoutRenderer\"],function(e,t,i,o,n){\"use strict\";var s=t.extend(\"sap.ui.layout.AlignedFlowLayout\",{metadata:{library:\"sap.ui.layout\",properties:{minItemWidth:{type:\"sap.ui.core.AbsoluteCSSSize\",defaultValue:\"12rem\"},maxItemWidth:{type:\"sap.ui.core.AbsoluteCSSSize\",defaultValue:\"24rem\"}},defaultAggregation:\"content\",aggregations:{content:{type:\"sap.ui.core.Control\",multiple:!0},endContent:{type:\"sap.ui.core.Control\",multiple:!0}}}});return s.prototype.init=function(){this._iEndItemWidth=-1,this._sResizeListenerId=o.register(this,this._onResize.bind(this))},s.prototype.exit=function(){this._sResizeListenerId&&(o.deregister(this._sResizeListenerId),this._sResizeListenerId=\"\")},s.prototype._onRenderingOrThemeChanged=function(){var e=this.getDomRef(),t=this.getDomRef(\"endItem\"),i=this.getContent().length&&e&&t;if(i){var o=window.getComputedStyle(e,null),n=o.getPropertyValue(\"padding-top\"),s=t.style;sap.ui.getCore().getConfiguration().getRTL()?s.left=o.getPropertyValue(\"padding-left\"):s.right=o.getPropertyValue(\"padding-right\"),s.bottom=n}this._onResize(null,e,t),i&&(e.lastElementChild.style.width=this._iEndItemWidth+\"px\")},s.prototype.onAfterRendering=s.prototype._onRenderingOrThemeChanged,s.prototype.onThemeChanged=s.prototype._onRenderingOrThemeChanged,s.prototype._onResize=function(e,t,i){if(!(e&&e.size.width===e.oldSize.width||0===this.getContent().length)&&(t=t||this.getDomRef())){var o=this.getRenderer().CSS_CLASS+\"OneLine\",n=!0;if(i=i||this.getDomRef(\"endItem\")){var s=t.lastElementChild.style;s.height=\"\",s.display=\"\",t.classList.remove(o);var r,a=this.getLastItemDomRef(),h=i.offsetHeight,p=i.offsetWidth,l=a.offsetLeft;if(sap.ui.getCore().getConfiguration().getRTL())r=l;else{var f=l+a.offsetWidth;r=t.offsetWidth-f}this._iEndItemWidth=p,n=r>=p,n?this.checkItemsWrapping(t)?i.offsetTop<a.offsetTop?(s.height=h+\"px\",s.display=\"block\"):(s.height=\"0\",s.display=\"\"):(i.offsetTop<a.offsetTop&&(s.height=h+\"px\"),s.display=\"block\"):(s.height=h+\"px\",s.display=\"block\")}!this.checkItemsWrapping(t)&&n?t.classList.add(o):t.classList.remove(o)}},s.prototype.checkItemsWrapping=function(e){if(!(e=e||this.getDomRef()))return!1;var t=e.firstElementChild,i=this.getLastItemDomRef();if(!t||!i)return!1;var o=t.offsetTop,n=i.offsetTop,s=t.offsetHeight;return n>=o+s||!!(i=this.getDomRef(\"endItem\"))&&n>=o+s},s.prototype.getLastItemDomRef=function(){var e=this.getContent(),t=e.length;if(t){var i=e[t-1],o=i.getDomRef();if(o)return o.parentElement}return null},s.prototype.getLastVisibleDomRef=function(){return this.getDomRef(\"endItem\")||this.getLastItemDomRef()},s.prototype.getNumberOfSpacers=function(){var t=this.getContent().length;if(0===t)return 0;var i,o=t,n=this.getMinItemWidth();return-1!==n.lastIndexOf(\"rem\")?i=e.sap.remToPx(n):-1!==n.lastIndexOf(\"px\")&&(i=parseFloat(n)),i&&(o=Math.abs(document.documentElement.clientWidth/i)),o=Math.min(o,t-2),o=Math.max(1,o),Math.floor(o)},s});",
	"sap/ui/layout/AlignedFlowLayoutRenderer.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"./library\"],function(e){\"use strict\";var t={};return t.CSS_CLASS=\"sapUiAFLayout\",t.render=function(e,r){var i=r.getContent();e.write(\"<ul\"),e.writeControlData(r),e.addClass(t.CSS_CLASS),e.writeClasses(),e.write(\">\"),this.renderItems(e,r,i),this.renderEndItem(e,r),this.renderSpacers(e,r),e.write(\"</ul>\")},t.renderItems=function(e,t,r){r=r||t.getContent();for(var i=0;i<r.length;i++)this.renderItem(e,t,r[i])},t.renderItem=function(e,r,i){e.write(\"<li\"),e.addClass(t.CSS_CLASS+\"Item\"),e.addStyle(\"flex-basis\",r.getMinItemWidth()),e.addStyle(\"max-width\",r.getMaxItemWidth()),e.writeClasses(),e.writeStyles(),e.write(\">\"),e.renderControl(i),e.write(\"</li>\")},t.renderEndItem=function(e,r,i){if(i=i||r.getEndContent(),i.length){e.write(\"<li\"),e.writeAttribute(\"id\",r.getId()+\"-endItem\"),e.addClass(t.CSS_CLASS+\"End\"),r.getContent().length&&e.addStyle(\"flex-basis\",r.getMinItemWidth()),e.writeClasses(),e.writeStyles(),e.write(\">\");for(var n=0;n<i.length;n++)this.renderEndContent(e,r,i[n]);e.write(\"</li>\")}},t.renderEndContent=function(e,t,r){e.renderControl(r)},t.renderSpacers=function(e,r){for(var i=r.getNumberOfSpacers(),n=r.getMinItemWidth(),d=r.getMaxItemWidth(),s=t.CSS_CLASS,a=0;a<i;a++)e.write(\"<li\"),a===i-1&&e.writeAttribute(\"id\",r.getId()+\"-last\"),e.addClass(s+\"Item\"),e.addClass(s+\"Spacer\"),e.addStyle(\"flex-basis\",n),e.addStyle(\"max-width\",d),e.writeClasses(),e.writeStyles(),e.write(\"></li>\")},t},!0);",
	"sap/ui/layout/AssociativeSplitter.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"./Splitter\",\"./SplitterRenderer\",\"jquery.sap.global\"],function(t,e,i){\"use strict\";function s(t){var e=t.getLayoutData();!e||e.getResizable&&e.getSize&&e.getMinSize||(i.sap.log.warning('Content \"'+t.getId()+'\" for the Splitter contained wrong LayoutData. The LayoutData has been replaced with default values.'),e=null),e||t.setLayoutData(new sap.ui.layout.SplitterLayoutData)}function a(t){var e=function(t){t.preventDefault()},i=null;i=function(){document.removeEventListener(\"touchend\",i),document.removeEventListener(\"touchmove\",e),document.removeEventListener(\"mouseup\",i),document.removeEventListener(\"mousemove\",e)},t?(this._ignoreMouse=!0,document.addEventListener(\"touchend\",i),document.addEventListener(\"touchmove\",e)):(document.addEventListener(\"mouseup\",i),document.addEventListener(\"mousemove\",e))}var n=t.extend(\"sap.ui.layout.AssociativeSplitter\",{metadata:{associations:{associatedContentAreas:{type:\"sap.ui.core.Control\",multiple:!0,singularName:\"associatedContentArea\"}}},renderer:e});return n.prototype.init=function(){t.prototype.init.call(this),this._keyListeners={increase:this._onKeyboardResize.bind(this,\"inc\",1),decrease:this._onKeyboardResize.bind(this,\"dec\",1),increaseMore:this._onKeyboardResize.bind(this,\"incMore\",2),decreaseMore:this._onKeyboardResize.bind(this,\"decMore\",2),max:this._onKeyboardResize.bind(this,\"max\",1),min:this._onKeyboardResize.bind(this,\"min\",1)},this._enableKeyboardListeners()},n.prototype._enableKeyboardListeners=function(){t.prototype._enableKeyboardListeners.call(this),this.onsaprightmodifiers=this._keyListeners.increase,this.onsapleftmodifiers=this._keyListeners.decrease,this.onsapupmodifiers=this._keyListeners.decrease,this.onsapdownmodifiers=this._keyListeners.increase,this.onsapright=this._keyListeners.increaseMore,this.onsapdown=this._keyListeners.increaseMore,this.onsapleft=this._keyListeners.decreaseMore,this.onsapup=this._keyListeners.decreaseMore,this.onsapend=this._keyListeners.max,this.onsaphome=this._keyListeners.min,this._keyboardEnabled=!0},n.prototype.addAssociatedContentArea=function(t){return this._needsInvalidation=!0,s(t),this.addAssociation(\"associatedContentAreas\",t)},n.prototype.indexOfAssociatedContentArea=function(t){for(var e=this._getContentAreas(),i=0;i<e.length;i++)if(t==e[i])return i;return-1},n.prototype.insertAssociatedContentArea=function(t,e){var i=t.getId();this._needsInvalidation=!0,s(t);for(var a=this.getAssociatedContentAreas(),n=0;n<a.length;n++)a[n]===i&&a.splice(n,1);a.splice(e,0,i),this.setAssociation(\"associatedContentAreas\",null);var o=this;a.forEach(function(t){o.addAssociation(\"associatedContentAreas\",t)})},n.prototype.removeAssociatedContentArea=function(t){this.removeAssociation(\"associatedContentAreas\",t)},n.prototype._getContentAreas=function(){var t=this.getAssociatedContentAreas()||[],e=this.getContentAreas(),i=t.map(function(t){return sap.ui.getCore().byId(t)}).filter(function(t){return t});return e.concat(i)},n.prototype.onmousedown=function(t){if(!this._ignoreMouse){i(t.target).hasClass(\"sapUiLoSplitterBarIcon\")&&(t.target=t.target.parentElement);var e=this.getId();t.target.id&&0===t.target.id.indexOf(e+\"-splitbar\")&&(this._ignoreTouch=!0,this._onBarMoveStart(t),this._oLastDOMclicked=t.target)}},n.prototype.ondblclick=function(t){var e,i,s=this.getId();t.target.contains(this._oLastDOMclicked)&&this._oLastDOMclicked.id.indexOf(s+\"-splitbar\")>-1&&(e=parseInt(this._oLastDOMclicked.id.substr((s+\"-splitbar-\").length),10),i=this._getContentAreas()[e],i._currentPosition=this.getCalculatedSizes()[e],i._lastPosition=i._lastPosition||i._currentPosition,i._currentPosition===i._lastPosition?this._resizeContents(e,-1*this.getCalculatedSizes()[e],!0):(this._resizeContents(e,i._lastPosition,!0),i._lastPosition=null))},n.prototype.ontouchstart=function(t){if(!this._ignoreTouch){i(t.target).hasClass(\"sapUiLoSplitterBarIcon\")&&(t.target=t.target.parentElement);var e=this.getId();t.target.id&&0===t.target.id.indexOf(e+\"-splitbar\")&&t.changedTouches&&t.changedTouches[0]&&(this._ignoreMouse=!0,this._onBarMoveStart(t.changedTouches[0],!0))}},n.prototype._onBarMoveStart=function(t,e){var s=this.getId();this.disableAutoResize(!0);var n=t[this._moveCord],o=parseInt(t.target.id.substr((s+\"-splitbar-\").length),10),r=parseInt(t.target.parentElement.id.substr((s+\"-splitbar-\").length),10),h=o+1?o:r,c=i(t.target);\"sapUiLoSplitterBarIcon\"===c.attr(\"class\")&&(c=c.parent());var d=this.getCalculatedSizes(),l=this._bHorizontal?c.innerWidth():c.innerHeight(),u=this._getContentAreas(),p=u[h].getLayoutData(),g=u[h+1].getLayoutData();if(!p.getResizable()||!g.getResizable())return void a(e);for(var _=0-l,v=0;v<=h;++v)_+=d[v]+l;this._move={start:n,relStart:_,barNum:h,bar:i(t.target),c1Size:d[h],c1MinSize:p?parseInt(p.getMinSize(),10):0,c2Size:d[h+1],c2MinSize:g?parseInt(g.getMinSize(),10):0},e?(document.addEventListener(\"touchend\",this._boundBarMoveEnd),document.addEventListener(\"touchmove\",this._boundBarMove)):(document.addEventListener(\"mouseup\",this._boundBarMoveEnd),document.addEventListener(\"mousemove\",this._boundBarMove)),this._$SplitterOverlay.css(\"display\",\"block\"),this._$SplitterOverlay.appendTo(this.getDomRef()),this._$SplitterOverlayBar.css(this._sizeDirNot,\"\"),this._move.bar.css(\"visibility\",\"hidden\"),this._onBarMove(t)},n.prototype._resizeContents=function(t,e,s){var a,n,o,r,h,c,d,l,u,p,g,_,v,y,f,z,m=parseFloat(this._move.c1Size).toFixed(5),S=parseFloat(this._move.c2Size).toFixed(5),b=parseFloat(m),L=parseFloat(S);if(isNaN(e))return void i.sap.log.warning(\"Splitter: Received invalid resizing values - resize aborted.\");a=this._getContentAreas(),n=a[t].getLayoutData(),o=a[t+1].getLayoutData(),r=n.getSize(),h=o.getSize(),c=this.$(\"content-\"+t),d=this.$(\"content-\"+(t+1)),l=b+e,u=L-e,p=parseInt(n.getMinSize(),10),g=parseInt(o.getMinSize(),10),_=this.getOrientation(),v=\"Horizontal\"===_?this.$().width():this.$().height(),l<p?(z=p-l,e+=z,l=p,u-=z):u<g&&(z=g-u,e-=z,u=g,l-=z),s?\"auto\"===r&&\"auto\"!==h?(f=this._pxToPercent(u,v),o.setSize(f)):\"auto\"!==r&&\"auto\"===h?(y=this._pxToPercent(l,v),n.setSize(y)):(y=this._pxToPercent(l,v),f=this._pxToPercent(u,v),n.setSize(y),o.setSize(f)):(y=this._pxToPercent(l,v),f=this._pxToPercent(u,v),c.css(this._sizeType,y),d.css(this._sizeType,f))},n.prototype._pxToPercent=function(t,e){return 100*t/e+\"%\"},n.prototype._recalculateSizes=function(){var t,e,s,a,n,o,r=[],h=this._getContentAreas(),c=this.getOrientation(),d=[],l=[],u=[];for(t=0;t<h.length;++t)s=h[t].getLayoutData(),e=s?s.getSize():\"auto\",r.push(e);var p=this._calculateAvailableContentSize(r)+1;for(this._calculatedSizes=[],t=0;t<r.length;++t)e=r[t],e.indexOf(\"px\")>-1?(o=parseInt(e,10),p-=o,this._calculatedSizes[t]=o):e.indexOf(\"%\")>-1?u.push(t):\"auto\"===e?(s=h[t].getLayoutData(),s&&0!==parseInt(s.getMinSize(),10)?l.push(t):d.push(t)):i.sap.log.error(\"Illegal size value: \"+r[t]);var g=!1;p<0&&(g=!0,p=0);var _=p;p=\"Horizontal\"===c?this.$().width():this.$().height();var v=u.length;for(t=0;t<v;++t)n=u[t],a=1===v&&1===h.length?p:parseFloat(r[n])/100*p,this._calculatedSizes[n]=a,_-=a;p=_,p<0&&(g=!0,p=0),a=Math.floor(p/(l.length+d.length),0);var y=l.length;for(t=0;t<y;++t){n=l[t];var f=parseInt(h[n].getLayoutData().getMinSize(),10);f>a?(this._calculatedSizes[n]=f,p-=f):(this._calculatedSizes[n]=a,p-=a)}p<0&&(g=!0,p=0),_=p;var z=d.length;for(a=Math.floor(p/z,0),t=0;t<z;++t)n=d[t],this._calculatedSizes[n]=a,_-=a;g&&i.sap.log.info(\"[Splitter] The set sizes and minimal sizes of the splitter contents are bigger than the available space in the UI.\"),this._calculatedSizes=this._calculatedSizes},n.prototype._ensureAllSplittersCollapsed=function(t){for(var e=this._getContentAreas(),i=!1,s=0;s<e.length;s++){var a=e[s].getLayoutData().getSize().slice(0,-2);\"0\"!==a&&\"au\"!==a?s===e.length-1&&i&&this._getContentAreas()[t+1].setLayoutData(new sap.ui.layout.SplitterLayoutData({size:\"100%\"})):i=!0}},n});",
	"sap/ui/layout/changeHandler/AddFormContainer.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"sap/ui/fl/Utils\",\"jquery.sap.global\",\"sap/ui/fl/changeHandler/Base\",\"sap/ui/fl/changeHandler/JsControlTreeModifier\"],function(e,t,n,o){\"use strict\";var r={};return r.applyChange=function(n,o,r){var i=r.modifier,a=r.appComponent,p=r.view,u=n.getDefinition();if(u.texts&&u.texts.groupLabel&&u.texts.groupLabel.value&&u.content&&u.content.group&&(u.content.group.selector||u.content.group.id)){var c=u.texts.groupLabel.value,l=u.content.group.index,g=u.content.group.selector||{id:u.content.group.id},f=t.extend({},g);f.id=f.id+\"--title\";var s=i.createControl(\"sap.ui.core.Title\",a,p,f),d=i.createControl(\"sap.ui.layout.form.FormContainer\",a,p,g);i.setProperty(s,\"text\",c),i.insertAggregation(d,\"title\",s,0,p),i.insertAggregation(o,\"formContainers\",d,l,p)}else e.log.error(\"Change does not contain sufficient information to be applied: [\"+u.layer+\"]\"+u.namespace+\"/\"+u.fileName+\".\"+u.fileType)},r.completeChangeContent=function(e,t,r){var i=e.getDefinition(),a=r.appComponent;if(!t.newLabel)throw new Error(\"Cannot create a new group: oSpecificChangeInfo.groupLabel attribute required\");if(n.setTextInChange(i,\"groupLabel\",t.newLabel,\"XFLD\"),i.content||(i.content={}),i.content.group||(i.content.group={}),void 0===t.index)throw new Error(\"Cannot create a new group: oSpecificChangeInfo.index attribute required\");if(i.content.group.index=t.index,!t.newControlId)throw new Error(\"Cannot create a new group: oSpecificChangeInfo.newControlId attribute required\");i.content.group.selector=o.getSelector(t.newControlId,a)},r},!0);",
	"sap/ui/layout/changeHandler/AddFormField.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"sap/ui/fl/Utils\",\"sap/ui/fl/changeHandler/ChangeHandlerMediator\"],function(e,n){\"use strict\";var t={};return t.applyChange=function(t,i,o){var r=t.getDefinition(),a=o.view,d=r.content.newFieldIndex,c=o.modifier,l=t.getDependentControl(\"parentFormContainer\",o),f=n.getChangeHandlerSettings({scenario:\"addODataFieldWithLabel\",oDataServiceVersion:r.content&&r.content.oDataServiceVersion}),g=f&&f.content&&f.content.createFunction;if(function(e){var n=e.content,t=!1;return n&&(t=e.content.newFieldSelector&&void 0!==e.content.newFieldIndex&&e.content.bindingPath&&e.content.oDataServiceVersion&&g),n&&t}(r)){var p=r.content,u=p.newFieldSelector,h=jQuery.extend({},p.newFieldSelector);h.id=h.id+\"-field\";var s=p.bindingPath,C={appComponent:o.appComponent,view:o.view,fieldSelector:h,bindingPath:s},w=g(c,C),v=c.createControl(\"sap.ui.layout.form.FormElement\",o.appComponent,a,u);return c.insertAggregation(v,\"label\",w.label,0,a),c.insertAggregation(v,\"fields\",w.control,0,a),c.insertAggregation(l,\"formElements\",v,d,a),!0}e.log.error(\"Change does not contain sufficient information to be applied or ChangeHandlerMediator could not be retrieved: [\"+r.layer+\"]\"+r.namespace+\"/\"+r.fileName+\".\"+r.fileType)},t.completeChangeContent=function(e,n,t){var i=t.appComponent,o=e.getDefinition();if(o.content||(o.content={}),!n.parentId)throw new Error(\"oSpecificChangeInfo.parentId attribute required\");if(e.addDependentControl(n.parentId,\"parentFormContainer\",t),!n.bindingPath)throw new Error(\"oSpecificChangeInfo.bindingPath attribute required\");if(o.content.bindingPath=n.bindingPath,!n.newControlId)throw new Error(\"oSpecificChangeInfo.newControlId attribute required\");if(o.content.newFieldSelector=t.modifier.getSelector(n.newControlId,i),void 0===n.index)throw new Error(\"oSpecificChangeInfo.targetIndex attribute required\");if(o.content.newFieldIndex=n.index,void 0===n.oDataServiceVersion)throw new Error(\"oSpecificChangeInfo.oDataServiceVersion attribute required\");o.content.oDataServiceVersion=n.oDataServiceVersion},t},!0);",
	"sap/ui/layout/changeHandler/AddSimpleFormField.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"sap/ui/fl/Utils\",\"sap/ui/fl/changeHandler/ChangeHandlerMediator\"],function(e,n){\"use strict\";var t={};return t.applyChange=function(t,i,o){var r=t.getDefinition(),a=t.getDependentControl(\"targetContainerHeader\",o),c=n.getChangeHandlerSettings({scenario:\"addODataFieldWithLabel\",oDataServiceVersion:r.content&&r.content.oDataServiceVersion}),d=c&&c.content&&c.content.createFunction,l=o.modifier;if(function(e){var n=e.content,t=!1;return n&&(t=e.content.newFieldSelector&&void 0!==e.content.newFieldIndex&&e.content.bindingPath&&e.content.oDataServiceVersion&&d),n&&t}(r)){var g=r.content,f=g.newFieldSelector,p=g.bindingPath,h=g.newFieldIndex,s=l.getAggregation(i,\"content\"),u=s.slice(),v=s.indexOf(a),b=0,w=0;if(1===s.length||s.length===v+1)b=s.length;else{var C=0;for(C=v+1;C<s.length;C++){var S=l.getControlType(s[C]);if(\"sap.m.Label\"===S||\"sap.ui.comp.smartfield.SmartLabel\"===S){if(w==h){b=C;break}w++}if(\"sap.ui.core.Title\"===S||\"sap.m.Toolbar\"===S){b=C;break}C===s.length-1&&(b=s.length)}}var m={appComponent:o.appComponent,view:o.view,fieldSelector:f,bindingPath:p},I=d(l,m);u.splice(b,0,I.label,I.control),l.removeAllAggregation(i,\"content\");for(var D=0;D<u.length;++D)l.insertAggregation(i,\"content\",u[D],D,o.view);return!0}e.log.error(\"Change does not contain sufficient information to be applied or ChangeHandlerMediator could not be retrieved: [\"+r.layer+\"]\"+r.namespace+\"/\"+r.fileName+\".\"+r.fileType)},t.completeChangeContent=function(e,n,t){var i=t.appComponent,o=t.view,r=e.getDefinition();if(r.content||(r.content={}),!n.parentId)throw new Error(\"oSpecificChangeInfo.parentId attribute required\");var a=t.modifier.bySelector(n.parentId,i,o),c=a.getTitle()||a.getToolbar();if(c&&e.addDependentControl(c.getId(),\"targetContainerHeader\",t),!n.bindingPath)throw new Error(\"oSpecificChangeInfo.bindingPath attribute required\");if(r.content.bindingPath=n.bindingPath,!n.newControlId)throw new Error(\"oSpecificChangeInfo.newControlId attribute required\");if(r.content.newFieldSelector=t.modifier.getSelector(n.newControlId,i),void 0===n.index)throw new Error(\"oSpecificChangeInfo.targetIndex attribute required\");if(r.content.newFieldIndex=n.index,void 0===n.oDataServiceVersion)throw new Error(\"oSpecificChangeInfo.oDataServiceVersion attribute required\");r.content.oDataServiceVersion=n.oDataServiceVersion},t},!0);",
	"sap/ui/layout/changeHandler/AddSimpleFormGroup.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"sap/ui/fl/Utils\",\"sap/ui/fl/changeHandler/Base\",\"sap/ui/fl/changeHandler/JsControlTreeModifier\"],function(e,n,t){\"use strict\";var o={};o.CONTENT_AGGREGATION=\"content\";var r=function(e,n,t){for(var o=0;o<t.length;o++){var r=e.getControlType(t[o]);if(-1!==n.indexOf(r))return!1;if(e.getVisible(t[o]))return!0}},i=function(e,n,t,o){var i,a=-1;if(0===o)return o;r(e,n,t)&&a++;for(var l=0;l<t.length;l++){var u=e.getControlType(t[l]);if(n.indexOf(u)>-1&&++a===o)return i=t[l],t.indexOf(i)}return t.length};return o.applyChange=function(n,t,r){var a=r.modifier,l=r.view,u=r.appComponent,c=n.getDefinition();if(c.texts&&c.texts.groupLabel&&c.texts.groupLabel.value&&c.content&&c.content.group&&(c.content.group.selector||c.content.group.id)){var p,g=c.content.group.selector;p=g?g.idIsLocal?u.createId(g.id):g.id:c.content.group.id;var f,d,s=c.texts.groupLabel.value,C=a.getAggregation(t,o.CONTENT_AGGREGATION);\"number\"==typeof c.content.group.index?f=c.content.group.index:(d=c.content.group.relativeIndex,f=i(a,[\"sap.ui.core.Title\",\"sap.m.Title\",\"sap.m.Toolbar\",\"sap.m.OverflowToolbar\"],C,d));var v=a.createControl(\"sap.ui.core.Title\",u,l,p);a.setProperty(v,\"text\",s),a.insertAggregation(t,\"content\",v,f,l)}else e.log.error(\"Change does not contain sufficient information to be applied: [\"+c.layer+\"]\"+c.namespace+\"/\"+c.fileName+\".\"+c.fileType);return!0},o.completeChangeContent=function(e,o,r){var i=e.getDefinition(),a=r.appComponent;if(!o.newLabel)throw new Error(\"oSpecificChangeInfo.newLabel attribute required\");if(n.setTextInChange(i,\"groupLabel\",o.newLabel,\"XFLD\"),i.content||(i.content={}),i.content.group||(i.content.group={}),!o.newControlId)throw new Error(\"oSpecificChangeInfo.newControlId attribute required\");if(i.content.group.selector=t.getSelector(o.newControlId,a),void 0===o.index)throw new Error(\"oSpecificChangeInfo.index attribute required\");i.content.group.relativeIndex=o.index},o.getControlIdFromChangeContent=function(e){var n;return e&&e._oDefinition&&(n=e._oDefinition.content.group.id),n},o},!0);",
	"sap/ui/layout/changeHandler/HideSimpleForm.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"sap/ui/fl/changeHandler/JsControlTreeModifier\"],function(e){\"use strict\";var t={},n=function(e,t){var n=t.getControlType(e);return\"sap.ui.core.Title\"===n||\"sap.m.Title\"===n||\"sap.m.Toolbar\"===n||\"sap.m.OverflowToolbar\"===n},o=function(e,t){var o;for(o=0;o<e.length;++o)if(n(e[o],t))return e[o]};return t.applyChange=function(e,t,r){var i=r.modifier,a=r.view,l=r.appComponent,g=e.getDefinition(),m=i.bySelector(g.content.elementSelector||g.content.sHideId,l,a),s=i.getAggregation(t,\"content\"),f=-1;i.removeAllAggregation(t,\"content\");for(var c=0;c<s.length;++c)i.insertAggregation(t,\"content\",s[c],c,a);if(\"hideSimpleFormField\"===g.changeType)s.some(function(e,t){if(e===m&&(f=t,i.setVisible(e,!1)),f>=0&&t>f){if(\"sap.m.Label\"===i.getControlType(e)||\"sap.ui.comp.smartfield.SmartLabel\"===i.getControlType(e)||n(e,i))return!0;i.setVisible(e,!1)}});else if(\"removeSimpleFormGroup\"===g.changeType){var p=o(s,i),u=p&&!m;s.some(function(e,o){if(p){if(u)f=0,i.setVisible(e,!1),u=!1;else if(e===m&&(f=o),f>=0&&o>f){if(n(e,i))return 0===f&&(i.removeAggregation(t,\"content\",e,a),i.insertAggregation(t,\"content\",e,0,a)),!0;i.setVisible(e,!1)}}else i.setVisible(e,!1)}),m&&i.removeAggregation(t,\"content\",m,a)}return!0},t._getStableElement=function(e){return\"sap.ui.layout.form.FormContainer\"===e.getMetadata().getName()?e.getTitle()||e.getToolbar():\"sap.ui.layout.form.FormElement\"===e.getMetadata().getName()?e.getLabel():e},t.completeChangeContent=function(t,n,o){var r=t.getDefinition();if(!n.removedElement||!n.removedElement.id)throw new Error(\"oSpecificChangeInfo.removedElement.id attribute required\");var i=this._getStableElement(sap.ui.getCore().byId(n.removedElement.id));r.content.elementSelector=e.getSelector(i,o.appComponent),t.addDependentControl(i,\"elementSelector\",o)},t},!0);",
	"sap/ui/layout/changeHandler/MoveSimpleForm.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/fl/changeHandler/JsControlTreeModifier\"],function(e,t){\"use strict\";var r={};r.CHANGE_TYPE_MOVE_FIELD=\"moveSimpleFormField\",r.CHANGE_TYPE_MOVE_GROUP=\"moveSimpleFormGroup\",r.sTypeTitle=\"sap.ui.core.Title\",r.sTypeMTitle=\"sap.m.Title\",r.sTypeToolBar=\"sap.m.Toolbar\",r.sTypeOverflowToolBar=\"sap.m.OverflowToolbar\",r.sTypeLabel=\"sap.m.Label\",r.sTypeSmartLabel=\"sap.ui.comp.smartfield.SmartLabel\",r.CONTENT_AGGREGATION=\"content\";var o=function(e,t,r){for(var o=0;o<r.length;o++){var n=e.getControlType(r[o]);if(-1!==t.indexOf(n))return!1;if(e.getVisible(r[o]))return!0}},n=function(t,r,n,a,l){if(o(t,l,r)){var p=a.view,i=a.appComponent,g=i.createId(e.sap.uid()),c=t.createControl(\"sap.ui.core.Title\",i,p,g);t.setProperty(c,\"text\",\"\"),t.insertAggregation(n,\"content\",c,0,p)}return t.getAggregation(n,\"content\")},a=function(e,t,r,n){var a,l=-1;o(e,t,r)&&l++;for(var p=0;p<r.length;p++){var i=e.getControlType(r[p]);if(t.indexOf(i)>-1&&++l===n){a=r[p];break}}return r.indexOf(a)},l=function(e,t,o){if(t>=e.length||-1===t)return!0;var n=o.getControlType(e[t]);return r.sTypeTitle===n||r.sTypeToolBar===n||r.sTypeMTitle===n||r.sTypeOverflowToolBar===n},p=function(e,t,r,o){var n=0;for(n=t+1;n<r.length;++n){var a=e.getControlType(r[n]);if(o.indexOf(a)>-1)break}return n-t},i=function(e,t,o){return p(e,o,t,[r.sTypeTitle,r.sTypeMTitle,r.sTypeToolBar,r.sTypeOverflowToolBar,r.sTypeLabel,r.sTypeSmartLabel])},g=function(t,r,o,n,a){if(l(r,o,t)){n=a?n+1:n;for(var p,g=0,c=o;c<r.length&&g<n;)++g,p=i(t,r,c),c+=p;return c}e.sap.log.error(\"Illegal argument. iIndex has to point to a Label.\")},c=function(e,t,r,o,n){for(var a=r,l=0;l<n;l++)a.splice(o+l,0,e[t+l]);return a},s=function(e){var t=e.getTitle();return t||(t=e.getToolbar()),t},d=function(e,o,n,a,l){var p=s(o.element),i=t.getSelector(e,l.appComponent),g={elementSelector:t.getSelector(p,l.appComponent),source:{groupIndex:o.sourceIndex},target:{groupIndex:o.targetIndex}};return{changeType:r.CHANGE_TYPE_MOVE_GROUP,targetSelector:i,movedControl:p,movedElements:[g]}},T=function(e,o,n,a,l){var p=t.getSelector(e,l.appComponent),i=o.element.getLabel(),g=t.getSelector(i,l.appComponent),c=s(a.parent),d=s(n.parent),T=t.getSelector(c,l.appComponent),u=t.getSelector(d,l.appComponent),m={elementSelector:g,source:{groupSelector:u,fieldIndex:o.sourceIndex},target:{groupSelector:T,fieldIndex:o.targetIndex}};return{changeType:r.CHANGE_TYPE_MOVE_FIELD,targetSelector:p,target:c,source:d,movedControl:i,movedElements:[m]}},u=function(e,t,r,o,n){e.removeAllAggregation(t,r.CONTENT_AGGREGATION);for(var a=0;a<o.length;++a)e.insertAggregation(t,r.CONTENT_AGGREGATION,o[a],a,n)};return r.applyChange=function(t,o,l){var s,d,T=l.modifier,m=l.view,f=l.appComponent,v=t.getContent(),y=v.movedElements[0],C=T.getAggregation(o,r.CONTENT_AGGREGATION);if(t.getChangeType()===r.CHANGE_TYPE_MOVE_FIELD){var E=T.bySelector(y.elementSelector||y.element,f,m),I=C.indexOf(E),O=i(T,C,I);s=T.bySelector(y.target.groupSelector||y.target.groupId,f,m);var S=C.indexOf(s),x=T.bySelector(y.source.groupSelector||y.source.groupId,f,m),b=C.indexOf(x),G=g(T,C,S,y.target.fieldIndex,b===S&&y.source.fieldIndex<y.target.fieldIndex),h=i(T,C,G);d=C.slice();var _,A,N,w,M=d.slice(I,I+O);I<G?(_=d.slice(0,I),N=d.slice(I+O,G+h),w=d.slice(G+h,d.length),d=_.concat(N.concat(M.concat(w)))):I>G&&(A=d.slice(0,G+h),N=d.slice(G+h,I),w=d.slice(I+O,d.length),d=A.concat(M.concat(N.concat(w)))),I!=G&&u(T,o,r,d,m)}else if(t.getChangeType()===r.CHANGE_TYPE_MOVE_GROUP){var P=[r.sTypeTitle,r.sTypeToolBar,r.sTypeMTitle,r.sTypeOverflowToolBar],F=T.bySelector(y.elementSelector||y.element,f,m);0!==y.target.groupIndex&&F||(C=n(T,C,o,l,P,v.newControlId));var L=F?C.indexOf(F):0,B=a(T,P,C,y.target.groupIndex);s=C[B];var D=p(T,B,C,P),H=p(T,L,C,P);d=C.slice(),d.splice(L,H),B=d.indexOf(s);var R=y.source.groupIndex<y.target.groupIndex?D:0;d=c(C,L,d,B+R,H),u(T,o,r,d,m)}else e.sap.log.warning(\"Unknown change type detected. Cannot apply to SimpleForm\");return!0},r.completeChangeContent=function(t,r,o){var n,a=o.modifier,l=o.view,p=o.appComponent,i=a.bySelector(r.selector,p,l),g=r.movedElements;g.length>1&&e.sap.log.warning(\"Moving more than 1 Formelement is not yet supported.\");var c=g[0];c.element=sap.ui.getCore().byId(c.id);var s=e.extend({},r.source),u=e.extend({},r.target);u.parent||(u.parent=sap.ui.getCore().byId(u.id)),s.parent||(s.parent=sap.ui.getCore().byId(s.id)),i&&c.element&&u.parent?\"moveSimpleFormGroup\"===r.changeType?n=d(i,c,0,0,o):\"moveSimpleFormField\"===r.changeType&&(n=T(i,c,s,u,o)):e.sap.log.error(\"Element not found. This may caused by an instable id!\");var m=t.getDefinition();m.content.targetSelector=n.targetSelector,m.content.movedElements=n.movedElements,n.source&&n.target&&(t.addDependentControl(n.source,\"sourceParent\",o),t.addDependentControl(n.target,\"targetParent\",o)),t.addDependentControl([n.movedControl],\"movedElements\",o)},r},!0);",
	"sap/ui/layout/changeHandler/RenameFormContainer.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"sap/ui/fl/changeHandler/Base\",\"sap/ui/fl/Utils\"],function(e,t){\"use strict\";var n={},r={TARGET_ALIAS:\"target\"};return n.applyChange=function(e,n,i){var o=i.modifier,a=e.getDefinition(),f=e.getDependentControl(r.TARGET_ALIAS,i),d=o.getAggregation(f,\"title\");if(a.texts&&a.texts.formText&&this._isProvided(a.texts.formText.value)){var u=a.texts.formText.value;return\"string\"==typeof d?o.setProperty(f,\"title\",u):o.setProperty(d,\"text\",u),!0}t.log.error(\"Change does not contain sufficient information to be applied: [\"+a.layer+\"]\"+a.namespace+\"/\"+a.fileName+\".\"+a.fileType)},n.completeChangeContent=function(t,n,i){var o=t.getDefinition();if(!n.renamedElement||!n.renamedElement.id)throw new Error(\"Rename of the group cannot be executed: oSpecificChangeInfo.renamedElement attribute required\");if(!this._isProvided(n.value))throw new Error(\"Rename of the group cannot be executed: oSpecificChangeInfo.value attribute required\");t.addDependentControl(n.renamedElement.id,r.TARGET_ALIAS,i),e.setTextInChange(o,\"formText\",n.value,\"XGRP\")},n._isProvided=function(e){return\"string\"==typeof e},n},!0);",
	"sap/ui/layout/changeHandler/RenameSimpleForm.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"sap/ui/fl/changeHandler/Base\",\"sap/ui/fl/changeHandler/JsControlTreeModifier\",\"sap/ui/fl/Utils\"],function(e,t,n){\"use strict\";var r={};return r.applyChange=function(e,t,r){var i=r.modifier,o=r.view,a=r.appComponent,l=e.getDefinition(),f=l.content.elementSelector||l.content.sRenameId,c=i.bySelector(f,a,o);if(l.texts&&l.texts.formText&&this._isProvided(l.texts.formText.value)){if(!t)throw new Error(\"no Control provided for renaming\");var d=l.texts.formText.value;return i.setProperty(c,\"text\",d),!0}n.log.error(\"Change does not contain sufficient information to be applied: [\"+l.layer+\"]\"+l.namespace+\"/\"+l.fileName+\".\"+l.fileType)},r.completeChangeContent=function(n,r,i){var o=n.getDefinition();if(!r.changeType)throw new Error(\"oSpecificChangeInfo.changeType attribute required\");if(!r.renamedElement||!r.renamedElement.id)throw new Error(\"oSpecificChangeInfo.renamedElement attribute required\");var a,l=sap.ui.getCore().byId(r.renamedElement.id);if(\"renameLabel\"===r.changeType?a=l.getLabel():\"renameTitle\"===r.changeType&&(a=l.getTitle()),o.content.elementSelector=t.getSelector(a,i.appComponent),n.addDependentControl(a,\"elementSelector\",i),!this._isProvided(r.value))throw new Error(\"oSpecificChangeInfo.value attribute required\");e.setTextInChange(o,\"formText\",r.value,\"XFLD\")},r._isProvided=function(e){return\"string\"==typeof e},r},!0);",
	"sap/ui/layout/changeHandler/UnhideSimpleForm.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"sap/ui/fl/changeHandler/JsControlTreeModifier\"],function(e){\"use strict\";var t={};return t.applyChange=function(e,t,n){var o=n.modifier,r=n.view,i=n.appComponent,l=e.getDefinition(),a=o.bySelector(l.content.elementSelector||l.content.sUnhideId,i,r),p=o.getAggregation(t,\"content\"),d=-1;return\"unhideSimpleFormField\"===l.changeType&&p.some(function(e,t){if(e===a&&(d=t,o.setVisible(e,!0)),d>=0&&t>d){if(\"sap.m.Label\"===o.getControlType(e)||\"sap.ui.comp.smartfield.SmartLabel\"===o.getControlType(e)||\"sap.ui.core.Title\"===o.getControlType(e)||\"sap.m.Title\"===o.getControlType(e)||\"sap.m.Toolbar\"===o.getControlType(e)||\"sap.m.OverflowToolbar\"===o.getControlType(e))return!0;o.setVisible(e,!0)}}),!0},t.completeChangeContent=function(t,n,o){var r=t.getDefinition();if(n.sUnhideId){var i=sap.ui.getCore().byId(n.sUnhideId);r.content.elementSelector=e.getSelector(i,o.appComponent),t.addDependentControl(i,\"elementSelector\",o)}else{if(!n.revealedElementId)throw new Error(\"oSpecificChangeInfo.revealedElementId attribute required\");var l=sap.ui.getCore().byId(n.revealedElementId||n.sUnhideId),a=l.getLabel();r.content.elementSelector=e.getSelector(a,o.appComponent),t.addDependentControl(a,\"elementSelector\",o)}},t},!0);",
	"sap/ui/layout/FixFlex.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/core/Control\",\"sap/ui/core/EnabledPropagator\",\"sap/ui/core/ResizeHandler\",\"./library\",\"sap/ui/core/delegate/ScrollEnablement\",\"./FixFlexRenderer\"],function(e,i,t,r,l,s,o){\"use strict\";var n=i.extend(\"sap.ui.layout.FixFlex\",{metadata:{library:\"sap.ui.layout\",properties:{vertical:{type:\"boolean\",group:\"Appearance\",defaultValue:!0},fixFirst:{type:\"boolean\",group:\"Misc\",defaultValue:!0},fixContentSize:{type:\"sap.ui.core.CSSSize\",group:\"Dimension\",defaultValue:\"auto\"},minFlexSize:{type:\"int\",defaultValue:0}},aggregations:{fixContent:{type:\"sap.ui.core.Control\",multiple:!0,singularName:\"fixContent\"},flexContent:{type:\"sap.ui.core.Control\",multiple:!1}},designtime:\"sap/ui/layout/designtime/FixFlex.designtime\"}});return t.call(n.prototype),n.prototype.init=function(){this._scroller=new s(this,null,{scrollContainerId:this.getId()}),this._innerScroller=new s(this,this.getId()+\"-FlexibleContainer\",{scrollContainerId:this.getId()+\"-Flexible\"})},n.prototype.getScrollDelegate=function(){return this._innerScroller},n.prototype._handlerResizeNoFlexBoxSupport=function(){var e,i,t=this.$();t.is(\":visible\")&&(e=this.$(\"Fixed\"),i=this.$(\"Flexible\"),e.removeAttr(\"style\"),i.removeAttr(\"style\"),this.getVertical()?(\"auto\"!==this.getFixContentSize()&&e.height(this.getFixContentSize()),i.height(Math.floor(t.height()-e.height()))):\"auto\"!==this.getFixContentSize()?(e.width(this.getFixContentSize()),i.width(Math.floor(t.width()-e.width()))):(i.width(Math.floor(t.width()-e.width())),e.width(Math.floor(e.width()))))},n.prototype._deregisterControl=function(){this.sResizeListenerNoFlexBoxSupportId&&(r.deregister(this.sResizeListenerNoFlexBoxSupportId),this.sResizeListenerNoFlexBoxSupportId=null),this.sResizeListenerNoFlexBoxSupportFixedId&&(r.deregister(this.sResizeListenerNoFlexBoxSupportFixedId),this.sResizeListenerNoFlexBoxSupportFixedId=null),this.sResizeListenerFixFlexScroll&&(r.deregister(this.sResizeListenerFixFlexScroll),this.sResizeListenerFixFlexScroll=null),this.sResizeListenerFixFlexScrollFlexPart&&(r.deregister(this.sResizeListenerFixFlexScrollFlexPart),this.sResizeListenerFixFlexScrollFlexPart=null),this.sResizeListenerFixFlexContainerScroll&&(r.deregister(this.sResizeListenerFixFlexContainerScroll),this.sResizeListenerFixFlexContainerScroll=null)},n.prototype._changeScrolling=function(){var e,i,t=this.$(),r=this.getMinFlexSize(),l=this.getVertical();l?(e=this.$().height()-this.$(\"Fixed\").height(),i=\"height\"):(e=this.$().width()-this.$(\"Fixed\").width(),i=\"width\"),e<=parseInt(this.getMinFlexSize(),10)?(t.addClass(\"sapUiFixFlexScrolling\"),t.removeClass(\"sapUiFixFlexInnerScrolling\"),l?(this._scroller.setVertical(!0),this._innerScroller.setVertical(!1)):(this._scroller.setHorizontal(!0),this._innerScroller.setHorizontal(!1)),this.$(\"FlexibleContainer\").children().height()>r?this.$(\"Flexible\").attr(\"style\",\"min-\"+i+\":\"+r+\"px\"):this.$(\"Flexible\").attr(\"style\",i+\":\"+r+\"px\")):(t.addClass(\"sapUiFixFlexInnerScrolling\"),t.removeClass(\"sapUiFixFlexScrolling\"),l?(this._scroller.setVertical(!1),this._innerScroller.setVertical(!0)):(this._scroller.setHorizontal(!1),this._innerScroller.setHorizontal(!0)),this._changeFlexibleContainerScroll(),this.$(\"Flexible\").removeAttr(\"style\"))},n.prototype._changeFlexibleContainerScroll=function(){var e=this.$(\"FlexibleContainer\"),i=e.height(),t=e.children().height();i!=t&&(i>t?e.removeClass(\"sapUiFixFlexFlexibleContainerGrowing\"):e.addClass(\"sapUiFixFlexFlexibleContainerGrowing\"))},n.prototype.exit=function(){this._deregisterControl(),this._scroller&&(this._scroller.destroy(),this._scroller=null),this._innerScroller&&(this._innerScroller.destroy(),this._innerScroller=null)},n.prototype.onBeforeRendering=function(){var e=this._scroller,i=this._innerScroller,t=0!=this.getMinFlexSize();this._deregisterControl(),e.setVertical(!1),e.setHorizontal(!1),i.setVertical(t),i.setHorizontal(t)},n.prototype.onAfterRendering=function(){if(e.support.hasFlexBoxSupport||(this.sResizeListenerNoFlexBoxSupportFixedId=r.register(this.getDomRef(\"Fixed\"),e.proxy(this._handlerResizeNoFlexBoxSupport,this)),this.sResizeListenerNoFlexBoxSupportId=r.register(this.getDomRef(),e.proxy(this._handlerResizeNoFlexBoxSupport,this)),this._handlerResizeNoFlexBoxSupport()),0!==this.getMinFlexSize()){this.sResizeListenerFixFlexScroll=r.register(this.getDomRef(),e.proxy(this._changeScrolling,this)),this.sResizeListenerFixFlexScrollFlexPart=r.register(this.getDomRef(\"Fixed\"),e.proxy(this._changeScrolling,this));var i=this.$(\"FlexibleContainer\").children()[0];i&&(this.sResizeListenerFixFlexContainerScroll=r.register(i,e.proxy(this._changeFlexibleContainerScroll,this))),this._changeScrolling()}},n});",
	"sap/ui/layout/FixFlexRenderer.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\"],function(e){\"use strict\";var i={};return i.render=function(i,t){i.write(\"<div\"),i.writeControlData(t),i.addClass(\"sapUiFixFlex\"),0!==t.getMinFlexSize()&&i.addClass(\"sapUiFixFlexInnerScrolling\"),t.getVertical()||i.addClass(\"sapUiFixFlexRow\"),e.support.hasFlexBoxSupport||i.addClass(\"sapUiFixFlex-Legacy\"),i.writeClasses(),i.write(\">\"),t.getFixFirst()?(this.renderFixChild(i,t),this.renderFlexChild(i,t)):(this.renderFlexChild(i,t),this.renderFixChild(i,t)),i.write(\"</div>\")},i.renderFixChild=function(e,i){var t=i.getFixContent();e.write('<div id=\"'+i.getId()+'-Fixed\" class=\"sapUiFixFlexFixed\"'),\"auto\"!==i.getFixContentSize()&&(i.getVertical()?e.addStyle(\"height\",i.getFixContentSize()):e.addStyle(\"width\",i.getFixContentSize()),e.writeStyles()),e.write(\">\");for(var r=0;r<t.length;r++)e.renderControl(t[r]);e.write(\"</div>\")},i.renderFlexChild=function(e,i){var t=i.getFlexContent();e.write('<div id=\"'+i.getId()+'-Flexible\" class=\"sapUiFixFlexFlexible\">'),e.write('<div id=\"'+i.getId()+'-FlexibleContainer\" class=\"sapUiFixFlexFlexibleContainer\"'),0!==i.getMinFlexSize()&&(i.getVertical()?e.write('style=\"min-height:'+i.getMinFlexSize()+'px\"'):e.write('style=\"min-width:'+i.getMinFlexSize()+'px\"')),e.write(\">\"),e.renderControl(t),e.write(\"</div>\"),e.write(\"</div>\")},i},!0);",
	"sap/ui/layout/flexibility/Form.flexibility.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"sap/ui/layout/changeHandler/AddFormContainer\",\"sap/ui/layout/changeHandler/AddFormField\"],function(d,a){\"use strict\";return{moveControls:\"default\",addGroup:d,addFormField:a}},!0);",
	"sap/ui/layout/flexibility/FormContainer.flexibility.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"sap/ui/layout/changeHandler/RenameFormContainer\",\"sap/ui/layout/changeHandler/AddFormField\"],function(e,a){\"use strict\";return{hideControl:\"default\",renameGroup:e,moveControls:\"default\",addFormField:a}},!0);",
	"sap/ui/layout/flexibility/FormElement.flexibility.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"sap/ui/fl/changeHandler/BaseRename\"],function(e){\"use strict\";return{hideControl:\"default\",unhideControl:\"default\",renameField:e.createRenameChangeHandler({propertyName:\"label\",translationTextType:\"XFLD\",changePropertyName:\"fieldLabel\"})}},!0);",
	"sap/ui/layout/flexibility/SimpleForm.flexibility.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"sap/ui/layout/changeHandler/RenameSimpleForm\",\"sap/ui/layout/changeHandler/MoveSimpleForm\",\"sap/ui/layout/changeHandler/HideSimpleForm\",\"sap/ui/layout/changeHandler/UnhideSimpleForm\",\"sap/ui/layout/changeHandler/AddSimpleFormGroup\",\"sap/ui/layout/changeHandler/AddSimpleFormField\"],function(e,i,l,m,a,r){\"use strict\";return{renameLabel:e,renameTitle:e,moveSimpleFormField:i,moveSimpleFormGroup:i,hideSimpleFormField:l,unhideSimpleFormField:m,removeSimpleFormGroup:l,addSimpleFormGroup:a,addSimpleFormField:r}},!0);",
	"sap/ui/layout/form/Form.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"sap/ui/core/Control\",\"sap/ui/layout/library\",\"./FormRenderer\"],function(t,e,o){\"use strict\";var a=t.extend(\"sap.ui.layout.form.Form\",{metadata:{library:\"sap.ui.layout\",properties:{width:{type:\"sap.ui.core.CSSSize\",group:\"Dimension\",defaultValue:null},editable:{type:\"boolean\",group:\"Misc\",defaultValue:!1}},defaultAggregation:\"formContainers\",aggregations:{formContainers:{type:\"sap.ui.layout.form.FormContainer\",multiple:!0,singularName:\"formContainer\"},title:{type:\"sap.ui.core.Title\",altTypes:[\"string\"],multiple:!1},toolbar:{type:\"sap.ui.core.Toolbar\",multiple:!1},layout:{type:\"sap.ui.layout.form.FormLayout\",multiple:!1}},associations:{ariaLabelledBy:{type:\"sap.ui.core.Control\",multiple:!0,singularName:\"ariaLabelledBy\"}},designtime:\"sap/ui/layout/designtime/form/Form.designtime\"}});return a.prototype.toggleContainerExpanded=function(t){var e=this.getLayout();e&&e.toggleContainerExpanded(t)},a.prototype.contentOnAfterRendering=function(t,e){var o=this.getLayout();o&&o.contentOnAfterRendering&&o.contentOnAfterRendering(t,e)},a.prototype.onLayoutDataChange=function(t){var e=this.getLayout();e&&e.onLayoutDataChange&&e.onLayoutDataChange(t)},a.prototype.onBeforeFastNavigationFocus=function(t){var e=this.getLayout();e&&e.onBeforeFastNavigationFocus&&e.onBeforeFastNavigationFocus(t)},a.prototype.setEditable=function(t){var e=this.getEditable();if(this.setProperty(\"editable\",t,!0),t!=e&&this.getDomRef()){t?(this.$().addClass(\"sapUiFormEdit\").addClass(\"sapUiFormEdit-CTX\"),this.$().removeAttr(\"aria-readonly\")):(this.$().removeClass(\"sapUiFormEdit\").removeClass(\"sapUiFormEdit-CTX\"),this.$().attr(\"aria-readonly\",\"true\"));for(var o=this.getFormContainers(),a=0;a<o.length;a++){o[a].invalidateLabels()}}return this},a.prototype.setToolbar=function(t){return t=e.form.FormHelper.setToolbar.call(this,t),this.setAggregation(\"toolbar\",t),this},a.prototype.invalidate=function(e){this._bNoInvalidate||t.prototype.invalidate.apply(this,arguments)},a.prototype.getContainerRenderedDomRef=function(t){var e=this.getLayout();return e&&e.getContainerRenderedDomRef?e.getContainerRenderedDomRef(t):null},a.prototype.getElementRenderedDomRef=function(t){var e=this.getLayout();return e&&e.getElementRenderedDomRef?e.getElementRenderedDomRef(t):null},a});",
	"sap/ui/layout/form/FormContainer.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/core/Element\",\"sap/ui/core/theming/Parameters\",\"sap/ui/layout/library\"],function(e,t,o,n){\"use strict\";function a(e){this._bIsBeingDestroyed||(this._oExpandButton=e,this.setAggregation(\"_expandButton\",this._oExpandButton),i.call(this))}function i(){if(this._oExpandButton){var e,t,a,i;this.getExpanded()?(e=o._getThemeImage(\"_sap_ui_layout_Form_FormContainerColImageURL\"),t=o._getThemeImage(\"_sap_ui_layout_Form_FormContainerColImageDownURL\"),a=\"-\",i=this._rb.getText(\"FORM_COLLAPSE\")):(e=o._getThemeImage(\"_sap_ui_layout_Form_FormContainerExpImageURL\"),t=o._getThemeImage(\"_sap_ui_layout_Form_FormContainerExpImageDownURL\"),a=\"+\",i=this._rb.getText(\"FORM_EXPAND\")),e&&(a=\"\"),n.form.FormHelper.setButtonContent(this._oExpandButton,a,i,e,t)}}function r(e){this.setExpanded(!this.getExpanded())}var s=t.extend(\"sap.ui.layout.form.FormContainer\",{metadata:{library:\"sap.ui.layout\",properties:{expanded:{type:\"boolean\",group:\"Misc\",defaultValue:!0},expandable:{type:\"boolean\",group:\"Misc\",defaultValue:!1},visible:{type:\"boolean\",group:\"Misc\",defaultValue:!0}},defaultAggregation:\"formElements\",aggregations:{formElements:{type:\"sap.ui.layout.form.FormElement\",multiple:!0,singularName:\"formElement\"},title:{type:\"sap.ui.core.Title\",altTypes:[\"string\"],multiple:!1},toolbar:{type:\"sap.ui.core.Toolbar\",multiple:!1},_expandButton:{type:\"sap.ui.core.Control\",multiple:!1,visibility:\"hidden\"}},associations:{ariaLabelledBy:{type:\"sap.ui.core.Control\",multiple:!0,singularName:\"ariaLabelledBy\"}},designtime:\"sap/ui/layout/designtime/form/FormContainer.designtime\"}});return s.prototype.init=function(){this._rb=sap.ui.getCore().getLibraryResourceBundle(\"sap.ui.layout\")},s.prototype.exit=function(){this._oExpandButton&&delete this._oExpandButton,this._rb=void 0},s.prototype.setExpandable=function(e){return this.setProperty(\"expandable\",e),e&&(this._oExpandButton?i.call(this):this._bExpandButtonRequired||(this._bExpandButtonRequired=!0,n.form.FormHelper.createButton.call(this,this.getId()+\"--Exp\",r,a))),this},s.prototype.setExpanded=function(e){this.setProperty(\"expanded\",e,!0),i.call(this);var t=this.getParent();return t&&t.toggleContainerExpanded&&t.toggleContainerExpanded(this),this},s.prototype.setToolbar=function(e){return e=n.form.FormHelper.setToolbar.call(this,e),this.setAggregation(\"toolbar\",e),this},s.prototype.contentOnAfterRendering=function(e,t){var o=this.getParent();o&&o.contentOnAfterRendering&&o.contentOnAfterRendering(e,t)},s.prototype.onLayoutDataChange=function(e){var t=this.getParent();t&&t.onLayoutDataChange&&t.onLayoutDataChange(e)},s.prototype._checkProperties=function(){var t=0;return!this.getExpandable()||this.getTitle()&&!this.getToolbar()||(e.sap.log.warning(\"Expander only displayed if title is set\",this.getId(),\"FormContainer\"),t=1),t},s.prototype.getRenderedDomRef=function(){var e=this,t=this.getParent();return t&&t.getContainerRenderedDomRef?t.getContainerRenderedDomRef(e):null},s.prototype.getElementRenderedDomRef=function(e){var t=this.getParent();return t&&t.getElementRenderedDomRef?t.getElementRenderedDomRef(e):null},s.prototype.invalidateLabels=function(){for(var e=this.getFormElements(),t=0;t<e.length;t++){e[t].invalidateLabel()}},s.prototype.isVisible=function(){return this.getVisible()},s});",
	"sap/ui/layout/form/FormElement.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/core/Element\",\"sap/ui/base/ManagedObjectObserver\",\"sap/ui/layout/library\"],function(e,t,i,s){\"use strict\";function a(e){if(e.child)r.call(this,e.child,e.mutation);else if(e.children)for(var t=0;t<e.chlidren.length;t++)r.call(this,e.children[t],e.mutation);g.call(this)}function r(t,i){\"insert\"==i?(t.getMetadata().isInstanceOf(\"sap.ui.core.IFormContent\")||e.sap.log.warning(t+\" is not valid Form content\",this),p.call(this,t)):u.call(this,t)}function l(e){\"required\"==e.name&&this.invalidateLabel()}function n(){if(this.getRequired&&this.getRequired())return!0;for(var e=this.getParent(),t=e.getFields(),i=0;i<t.length;i++){var s=t[i];if(s.getRequired&&!0===s.getRequired()&&(!s.getEditable||s.getEditable()))return!0}return!1}function o(){if(this.getDisplayOnly){if(!this.isPropertyInitial(\"displayOnly\"))return this.getDisplayOnly();var e=this.getParent(),t=e.getParent();if(t){var i=t.getParent();if(i)return!i.getEditable()}}return!1}function h(){return!(this.getWrapping&&!this.isPropertyInitial(\"wrapping\"))||this.getWrapping()}function g(){var e=this.getFields(),t=e.length>0?e[0]:null,i=this._oLabel;i?i.setLabelFor(t):(i=this.getLabel())instanceof sap.ui.core.Control&&i.setAlternativeLabelFor(t)}function p(e){e.addDelegate(this._oFieldDelegate),!this._bNoObserverChange&&e.getMetadata().getProperty(\"required\")&&this._oObserver.observe(e,{properties:[\"required\"]})}function u(e){e.removeDelegate(this._oFieldDelegate),this._bNoObserverChange||this._oObserver.unobserve(e)}function d(e){var t=this.oElement.getParent();t&&t.contentOnAfterRendering&&t.contentOnAfterRendering(this.oElement,e.srcControl)}var b=t.extend(\"sap.ui.layout.form.FormElement\",{metadata:{library:\"sap.ui.layout\",properties:{visible:{type:\"boolean\",group:\"Misc\",defaultValue:!0}},defaultAggregation:\"fields\",aggregations:{label:{type:\"sap.ui.core.Label\",altTypes:[\"string\"],multiple:!1},_label:{type:\"sap.ui.core.Label\",multiple:!1,visibility:\"hidden\"},fields:{type:\"sap.ui.core.Control\",multiple:!0,singularName:\"field\"}},designtime:\"sap/ui/layout/designtime/form/FormElement.designtime\"}});return b.prototype.init=function(){this._oFieldDelegate={oElement:this,onAfterRendering:d},this._oObserver=new i(this._observeChanges.bind(this)),this._oObserver.observe(this,{aggregations:[\"fields\"]})},b.prototype.exit=function(){this._oLabel&&delete this._oLabel,this.getFields().forEach(function(e){e&&e.removeDelegate(this._oFieldDelegate)},this),this._oFieldDelegate=void 0,this._oObserver.disconnect(),this._oObserver=void 0},b.prototype.setLabel=function(e){if(!this._oLabel){var t=this.getLabel();t&&(t.setAlternativeLabelFor&&t.setAlternativeLabelFor(null),t.isRequired&&(t.isRequired=t._sapuiIsRequired,t._sapuiIsRequired=void 0,t.disableRequiredChangeCheck(!1)),t.isDisplayOnly&&(t.isDisplayOnly=t._sapuiIsDisplayOnly,t._sapuiIsDisplayOnly=void 0),t.isWrapping&&(t.isWrapping=t._sapuiIsWrapping,t._sapuiIsWrapping=void 0))}this.setAggregation(\"label\",e);var i=e;return\"string\"==typeof i?this._oLabel?this._oLabel.setText(i):(this._oLabel=s.form.FormHelper.createLabel(i),this.setAggregation(\"_label\",this._oLabel,!0),this._oLabel.disableRequiredChangeCheck(!0),this._oLabel.isRequired&&(this._oLabel.isRequired=n),this._oLabel.isDisplayOnly&&(this._oLabel.isDisplayOnly=o),this._oLabel.setWrapping&&this._oLabel.setWrapping(!0)):(this._oLabel&&(this._oLabel.destroy(),delete this._oLabel),i&&i.isRequired&&(i._sapuiIsRequired=i.isRequired,i.isRequired=n,i.disableRequiredChangeCheck(!0)),i&&i.isDisplayOnly&&(i._sapuiIsDisplayOnly=i.isDisplayOnly,i.isDisplayOnly=o),i&&i.isWrapping&&(i._sapuiIsWrapping=i.isWrapping,i.isWrapping=h)),g.call(this),this},b.prototype.destroyLabel=function(){return this.destroyAggregation(\"label\"),this._oLabel&&(this._oLabel.destroy(),delete this._oLabel),this},b.prototype.getLabelControl=function(){return this._oLabel?this._oLabel:this.getLabel()},b.prototype.updateFields=function(){var e,t=this.getFields(),i=0;for(i=0;i<t.length;i++)e=t[i],u.call(this,e);for(this.updateAggregation(\"fields\"),t=this.getFields(),i=0;i<t.length;i++)e=t[i],p.call(this,e);return g.call(this),this},b.prototype.enhanceAccessibilityState=function(t,i){var s=this.getLabelControl();if(s&&s!=t&&!(t instanceof sap.m.Button)){var a=i.labelledby;if(a){var r=a.split(\" \");e.inArray(s.getId(),r)<0&&(r.splice(0,0,s.getId()),a=r.join(\" \"))}else a=s.getId();i.labelledby=a}return i},b.prototype.onLayoutDataChange=function(e){var t=this.getParent();t&&t.onLayoutDataChange&&t.onLayoutDataChange(e)},b.prototype.getRenderedDomRef=function(){var e=this,t=this.getParent();return t&&t.getElementRenderedDomRef?t.getElementRenderedDomRef(e):null},b.prototype.invalidateLabel=function(){var e=this.getLabelControl();e&&e.invalidate()},b.prototype.isVisible=function(){return this.getVisible()},b.prototype._observeChanges=function(e){e.object==this?\"fields\"==e.name&&a.call(this,e):l.call(this,e)},b});",
	"sap/ui/layout/form/FormLayout.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/core/Control\",\"sap/ui/layout/library\",\"./FormLayoutRenderer\"],function(e,t,n,r){\"use strict\";function o(e,t){var n=sap.ui.require(t);return e&&\"function\"==typeof n&&e instanceof n}var i=n.BackgroundDesign,a=t.extend(\"sap.ui.layout.form.FormLayout\",{metadata:{library:\"sap.ui.layout\",properties:{backgroundDesign:{type:\"sap.ui.layout.BackgroundDesign\",group:\"Appearance\",defaultValue:i.Translucent}}}});return a.prototype.contentOnAfterRendering=function(t,r){n.form.FormHelper.bArrowKeySupport&&e(r.getFocusDomRef()).data(\"sap.InNavArea\",!0)},a.prototype.toggleContainerExpanded=function(e){var t=e.getExpanded();this.getDomRef()&&(t?e.$(\"content\").css(\"display\",\"\"):e.$(\"content\").css(\"display\",\"none\"))},a.prototype.getLayoutDataForElement=function(e,t){var n=e.getLayoutData();if(n){if(o(n,t))return n;if(o(n,\"sap/ui/core/VariantLayoutData\"))for(var r=n.getMultipleLayoutData(),i=0;i<r.length;i++){var a=r[i];if(o(a,t))return a}}},a.prototype.onsapright=function(e){if(n.form.FormHelper.bArrowKeySupport){sap.ui.getCore().getConfiguration().getRTL()?this.navigateBack(e):this.navigateForward(e)}},a.prototype.onsapleft=function(e){if(n.form.FormHelper.bArrowKeySupport){sap.ui.getCore().getConfiguration().getRTL()?this.navigateForward(e):this.navigateBack(e)}},a.prototype.onsapdown=function(t){if(n.form.FormHelper.bArrowKeySupport){var r,i=t.srcControl,a=this.findElement(i),f=a.element;i=a.rootControl,f&&o(f,\"sap/ui/layout/form/FormElement\")?r=this.findFieldBelow(i,f):f&&o(f,\"sap/ui/layout/form/FormContainer\")&&(r=this.findFirstFieldOfNextElement(f,0)),r&&(e.sap.focus(r),t.preventDefault())}},a.prototype.onsapup=function(t){if(n.form.FormHelper.bArrowKeySupport){var r,i=t.srcControl,a=0,f=this.findElement(i),l=f.element;if(i=f.rootControl,l&&o(l,\"sap/ui/layout/form/FormElement\"))r=this.findFieldAbove(i,l);else if(l&&o(l,\"sap/ui/layout/form/FormContainer\")){var s=l.getParent();a=s.indexOfFormContainer(l),r=this.findLastFieldOfLastElementInPrevContainer(s,a-1)}r&&(e.sap.focus(r),t.preventDefault())}},a.prototype.onsaphome=function(t){if(n.form.FormHelper.bArrowKeySupport){var r,o=t.srcControl,i=0,a=this.findElement(o),f=a.element,l=f.getParent(),s=l.getParent();i=s.indexOfFormContainer(l),r=this.findFirstFieldOfFirstElementInNextContainer(s,i),r&&(e.sap.focus(r),t.preventDefault())}},a.prototype.onsaptop=function(t){if(n.form.FormHelper.bArrowKeySupport){var r,i,a=t.srcControl,f=this.findElement(a),l=f.element;l&&o(l,\"sap/ui/layout/form/FormElement\")?i=l.getParent():l&&o(l,\"sap/ui/layout/form/FormContainer\")&&(i=l);var s=i.getParent();r=this.findFirstFieldOfForm(s),r&&(e.sap.focus(r),t.preventDefault())}},a.prototype.onsapend=function(t){if(n.form.FormHelper.bArrowKeySupport){var r,o=t.srcControl,i=0,a=this.findElement(o),f=a.element,l=f.getParent(),s=l.getParent();i=s.indexOfFormContainer(l),r=this.findLastFieldOfLastElementInPrevContainer(s,i),r&&(e.sap.focus(r),t.preventDefault())}},a.prototype.onsapbottom=function(t){if(n.form.FormHelper.bArrowKeySupport){var r,i,a=t.srcControl,f=this.findElement(a),l=f.element;l&&o(l,\"sap/ui/layout/form/FormElement\")?i=l.getParent():l&&o(l,\"sap/ui/layout/form/FormContainer\")&&(i=l);var s=i.getParent(),d=s.getFormContainers(),m=d.length;r=this.findLastFieldOfLastElementInPrevContainer(s,m-1),r&&(e.sap.focus(r),t.preventDefault())}},a.prototype.onsapexpand=function(e){var t,n=e.srcControl,r=this.findElement(n),i=r.element;t=o(i,\"sap/ui/layout/form/FormContainer\")?i:i.getParent(),t.getExpandable()&&n===t._oExpandButton&&t.setExpanded(!0)},a.prototype.onsapcollapse=function(e){var t,n=e.srcControl,r=this.findElement(n),i=r.element;t=o(i,\"sap/ui/layout/form/FormContainer\")?i:i.getParent(),t.getExpandable()&&n===t._oExpandButton&&t.setExpanded(!1)},a.prototype.onsapskipforward=function(t){var n=t.srcControl,r=this.findElement(n),i=r.element;n=r.rootControl;var a,f;i&&o(i,\"sap/ui/layout/form/FormElement\")?f=i.getParent():i&&o(i,\"sap/ui/layout/form/FormContainer\")&&(f=i);var l=f.getParent(),s=l.indexOfFormContainer(f);(a=this.findFirstFieldOfFirstElementInNextContainer(l,s+1))&&(e.sap.focus(a),t.preventDefault())},a.prototype.onsapskipback=function(t){var n=t.srcControl,r=this.findElement(n),i=r.element;n=r.rootControl;var a,f;i&&o(i,\"sap/ui/layout/form/FormElement\")?f=i.getParent():i&&o(i,\"sap/ui/layout/form/FormContainer\")&&(f=i);for(var l=f.getParent(),s=l.getFormContainers(),d=l.indexOfFormContainer(f);!a&&d>0;){var m=s[d-1];m.getExpandable()&&!m.getExpanded()||(a=this.findFirstFieldOfFirstElementInPrevContainer(l,d-1)),d-=1}a&&(e.sap.focus(a),t.preventDefault())},a.prototype.onBeforeFastNavigationFocus=function(t){if(e.contains(this.getDomRef(),t.source))t.srcControl=e(t.source).control(0),t.forward?this.onsapskipforward(t):this.onsapskipback(t);else{var n=t.forward?this.findFirstFieldOfForm(this.getParent()):this.findFirstFieldOfLastContainerOfForm(this.getParent());n&&(e.sap.focus(n),t.preventDefault())}},a.prototype.findElement=function(e){for(var t=e.getParent(),n=e;t&&!o(t,\"sap/ui/layout/form/FormElement\")&&(!t||!o(t,\"sap/ui/layout/form/FormContainer\"))&&(!t||!o(t,\"sap/ui/layout/form/Form\"));)n=t,t=t.getParent();return{rootControl:n,element:t}},a.prototype.navigateForward=function(t){var n,r=t.srcControl,i=0,a=this.findElement(r),f=a.element;if(r=a.rootControl,f&&o(f,\"sap/ui/layout/form/FormElement\")){if(i=r==f.getLabelControl()?-1:f.indexOfField(r),!(n=this.findNextFieldOfElement(f,i+1))){var l=f.getParent();if(i=l.indexOfFormElement(f),!(n=this.findFirstFieldOfNextElement(l,i+1))){var s=l.getParent();i=s.indexOfFormContainer(l),n=this.findFirstFieldOfFirstElementInNextContainer(s,i+1)}}}else f&&o(f,\"sap/ui/layout/form/FormContainer\")&&(n=this.findFirstFieldOfNextElement(f,0));n&&(e.sap.focus(n),t.preventDefault())},a.prototype.tabForward=function(t){var n,r,i=t.srcControl,a=0,f=this.findElement(i),l=f.element;if(i=f.rootControl,l&&o(l,\"sap/ui/layout/form/FormElement\")){if(a=i==l.getLabelControl()?-1:l.indexOfField(i),!(r=this.findNextFieldOfElement(l,a+1,!0))){var s=l.getParent();a=s.indexOfFormElement(l),r=this.findFirstFieldOfNextElement(s,a+1,!0),r||(n=s.getParent(),a=n.indexOfFormContainer(s),r=this.findFirstFieldOfFirstElementInNextContainer(n,a+1,!0))}}else l&&o(l,\"sap/ui/layout/form/FormContainer\")&&((r=this.findFirstFieldOfNextElement(l,0,!0))||(n=l.getParent(),a=n.indexOfFormContainer(l),r=this.findFirstFieldOfFirstElementInNextContainer(n,a+1,!0)));r&&(e.sap.focus(r),t.preventDefault())},a.prototype.findNextFieldOfElement=function(e,t,n){for(var r,o=e.getFields(),i=o.length,a=t;a<i;a++){var f=o[a],l=this._getDomRef(f);if(1==n){if((!f.getEditable||f.getEditable())&&(!f.getEnabled||f.getEnabled())&&l){r=l;break}}else if((!f.getEnabled||f.getEnabled())&&l){r=l;break}}return r},a.prototype.findFirstFieldOfNextElement=function(e,t,n){for(var r,o=e.getFormElements(),i=o.length,a=t;!r&&a<i;){var f=o[a];r=1==n?this.findNextFieldOfElement(f,0,!0):this.findNextFieldOfElement(f,0),a++}return r},a.prototype.findFirstFieldOfForm=function(e){var t,n=e.getFormContainers(),r=n[0];return r.getExpandable()&&!r.getExpanded()||(t=this.findFirstFieldOfNextElement(r,0)),t},a.prototype.findFirstFieldOfLastContainerOfForm=function(e){for(var t,n=e.getFormContainers(),r=n.length;!t&&r>0;){var o=n[r-1];o.getExpandable()&&!o.getExpanded()||(t=this.findFirstFieldOfFirstElementInPrevContainer(e,r-1)),r-=1}return t},a.prototype.findFirstFieldOfFirstElementInNextContainer=function(e,t,n){for(var r,o=e.getFormContainers(),i=o.length,a=t;!r&&a<i;){var f=o[a];if(f.getExpandable()&&n&&(r=f._oExpandButton.getFocusDomRef()))break;f.getExpandable()&&!f.getExpanded()||(r=1==n?this.findFirstFieldOfNextElement(f,0,!0):this.findFirstFieldOfNextElement(f,0)),a++}return r},a.prototype.findFirstFieldOfFirstElementInPrevContainer=function(e,t){for(var n,r=e.getFormContainers(),o=r.length,i=t;!n&&i<o&&i>=0;){var a=r[i];a.getExpandable()&&!a.getExpanded()||(n=this.findFirstFieldOfNextElement(a,0)),i++}return n},a.prototype.navigateBack=function(t){var n,r,i=t.srcControl,a=0,f=this.findElement(i),l=f.element;if(i=f.rootControl,l&&o(l,\"sap/ui/layout/form/FormElement\")){if(a=i==l.getLabelControl()?0:l.indexOfField(i),!(r=this.findPrevFieldOfElement(l,a-1))){var s=l.getParent();a=s.indexOfFormElement(l),r=this.findLastFieldOfPrevElement(s,a-1),r||(n=s.getParent(),a=n.indexOfFormContainer(s),r=this.findLastFieldOfLastElementInPrevContainer(n,a-1))}}else l&&o(l,\"sap/ui/layout/form/FormContainer\")&&(n=l.getParent(),a=n.indexOfFormContainer(l),r=this.findLastFieldOfLastElementInPrevContainer(n,a-1));r&&(e.sap.focus(r),t.preventDefault())},a.prototype.tabBack=function(t){var n,r,i=t.srcControl,a=0,f=this.findElement(i),l=f.element;if(i=f.rootControl,l&&o(l,\"sap/ui/layout/form/FormElement\")){if(a=i==l.getLabelControl()?0:l.indexOfField(i),!(r=this.findPrevFieldOfElement(l,a-1,!0))){var s=l.getParent();a=s.indexOfFormElement(l),r=this.findLastFieldOfPrevElement(s,a-1,!0),r||(n=s.getParent(),a=n.indexOfFormContainer(s),s.getExpandable()&&(r=s._oExpandButton.getFocusDomRef()),r||(r=this.findLastFieldOfLastElementInPrevContainer(n,a-1,!0)))}}else l&&o(l,\"sap/ui/layout/form/FormContainer\")&&(n=l.getParent(),a=n.indexOfFormContainer(l),r=this.findLastFieldOfLastElementInPrevContainer(n,a-1,!0));r&&(e.sap.focus(r),t.preventDefault())},a.prototype.findPrevFieldOfElement=function(e,t,n){for(var r,o=e.getFields(),i=t;i>=0;i--){var a=o[i],f=this._getDomRef(a);if(1==n){if((!a.getEditable||a.getEditable())&&(!a.getEnabled||a.getEnabled())&&f){r=f;break}}else if((!a.getEnabled||a.getEnabled())&&f){r=f;break}}return r},a.prototype.findLastFieldOfPrevElement=function(e,t,n){for(var r,o=e.getFormElements(),i=t;!r&&i>=0;){var a=o[i],f=a.getFields().length;r=1==n?this.findPrevFieldOfElement(a,f-1,!0):this.findPrevFieldOfElement(a,f-1),i--}return r},a.prototype.findLastFieldOfLastElementInPrevContainer=function(e,t,n){for(var r,o=e.getFormContainers(),i=t;!r&&i>=0;){var a=o[i];if(a.getExpandable()&&!a.getExpanded()&&n&&(r=a._oExpandButton.getFocusDomRef()))break;if(!a.getExpandable()||a.getExpanded()){var f=a.getFormElements().length;r=1==n?this.findLastFieldOfPrevElement(a,f-1,!0):this.findLastFieldOfPrevElement(a,f-1,0)}i--}return r},a.prototype.findFieldBelow=function(e,t){var n=t.getParent(),r=n.indexOfFormElement(t),o=this.findFirstFieldOfNextElement(n,r+1);if(!o){var i=n.getParent();r=i.indexOfFormContainer(n),o=this.findFirstFieldOfFirstElementInNextContainer(i,r+1)}return o},a.prototype.findFieldAbove=function(e,t){for(var n,r=t.getParent(),o=r.indexOfFormElement(t),i=r.getFormElements(),a=o-1;!n&&a>=0;){var f=i[a];n=this.findPrevFieldOfElement(f,0),a--}if(!n){var l=r.getParent();o=l.indexOfFormContainer(r),n=this.findLastFieldOfLastElementInPrevContainer(l,o-1)}return n},a.prototype._getDomRef=function(t){var n=t.getFocusDomRef();return e(n).is(\":sapFocusable\")||(n=void 0),n},a.prototype.getContainerRenderedDomRef=function(t){return this.getDomRef()?e.sap.domById(t.getId()):null},a.prototype.getElementRenderedDomRef=function(t){return this.getDomRef()?e.sap.domById(t.getId()):null},a});",
	"sap/ui/layout/form/FormLayoutRenderer.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"sap/ui/layout/library\",\"sap/ui/core/library\",\"sap/ui/core/theming/Parameters\",\"sap/ui/layout/form/Form\"],function(e,t,r,i){\"use strict\";var a=t.TitleLevel,n=e.BackgroundDesign,l={};return l.render=function(e,t){var r=e,a=t.getParent();a&&a instanceof i&&this.renderForm(r,t,a)},l.renderForm=function(e,t,i){var a=i.getToolbar();if(e.write(\"<div\"),e.writeControlData(t),e.addClass(this.getMainClass()),a&&e.addClass(\"sapUiFormToolbar\"),this.addBackgroundClass(e,t),e.writeClasses(),e.write(\">\"),a)e.renderControl(a);else{var n=r.get(\"sap.ui.layout.FormLayout:_sap_ui_layout_FormLayout_FormTitleSize\");this.renderTitle(e,i.getTitle(),void 0,!1,n,i.getId())}this.renderContainers(e,t,i),e.write(\"</div>\")},l.getMainClass=function(){return\"sapUiFormLayout\"},l.addBackgroundClass=function(e,t){var r=t.getBackgroundDesign();r!=n.Transparent&&e.addClass(\"sapUiFormBackgr\"+r)},l.renderContainers=function(e,t,r){for(var i=r.getFormContainers(),a=0,n=i.length;a<n;a++){var l=i[a];l.isVisible()&&this.renderContainer(e,t,l)}},l.renderContainer=function(e,t,r){var i=r.getExpandable(),n=r.getToolbar(),l=r.getTitle();e.write(\"<section\"),e.writeElementData(r),e.addClass(\"sapUiFormContainer\"),n?e.addClass(\"sapUiFormContainerToolbar\"):l&&e.addClass(\"sapUiFormContainerTitle\"),r.getTooltip_AsString()&&e.writeAttributeEscaped(\"title\",r.getTooltip_AsString()),e.writeClasses(),this.writeAccessibilityStateContainer(e,r),e.write(\">\"),n?e.renderControl(n):this.renderTitle(e,l,r._oExpandButton,i,a.H4,r.getId()),i&&(e.write(\"<div id='\"+r.getId()+\"-content'\"),r.getExpanded()||(e.addStyle(\"display\",\"none\"),e.writeStyles()),e.write(\">\"));for(var o=r.getFormElements(),s=0,d=o.length;s<d;s++){var g=o[s];g.isVisible()&&this.renderElement(e,t,g)}i&&e.write(\"</div>\"),e.write(\"</section>\")},l.renderElement=function(e,t,r){var i=r.getLabelControl();e.write(\"<div\"),e.writeElementData(r),e.addClass(\"sapUiFormElement\"),i&&e.addClass(\"sapUiFormElementLbl\"),e.writeClasses(),e.write(\">\"),i&&e.renderControl(i);var a=r.getFields();if(a&&a.length>0)for(var n=0,l=a.length;n<l;n++){var o=a[n];e.renderControl(o)}e.write(\"</div>\")},l.renderTitle=function(e,t,i,n,l,o){if(t){var s=r.get(\"sap.ui.layout.FormLayout:_sap_ui_layout_FormLayout_FormSubTitleSize\");if(l&&(s=l),\"string\"!=typeof t&&t.getLevel()!=a.Auto&&(s=t.getLevel()),e.write(\"<\"+s+\" \"),e.addClass(\"sapUiFormTitle\"),e.addClass(\"sapUiFormTitle\"+s),\"string\"!=typeof t?(e.writeElementData(t),t.getTooltip_AsString()&&e.writeAttributeEscaped(\"title\",t.getTooltip_AsString()),t.getEmphasized()&&e.addClass(\"sapUiFormTitleEmph\")):e.writeAttribute(\"id\",o+\"--title\"),e.writeClasses(),e.write(\">\"),n&&i&&e.renderControl(i),\"string\"==typeof t)e.writeEscaped(t,!0);else{var d=t.getIcon();if(d){var g=[],u={title:null};u.id=t.getId()+\"-ico\",e.writeIcon(d,g,u)}e.writeEscaped(t.getText(),!0)}e.write(\"</\"+s+\">\")}},l.writeAccessibilityStateContainer=function(e,t){var r={},i=t.getTitle(),a=t.getToolbar();if(a)t.getAriaLabelledBy()&&0!=t.getAriaLabelledBy().length||(r.labelledby={value:a.getId(),append:!0});else if(i){var n=\"\";n=\"string\"==typeof i?t.getId()+\"--title\":i.getId(),r.labelledby={value:n,append:!0}}(r.labelledby||t.getAriaLabelledBy().length>0)&&(r.role=\"form\"),e.writeAccessibilityState(t,r)},l},!0);",
	"sap/ui/layout/form/FormRenderer.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/layout/library\"],function(t,e){\"use strict\";var a={};return a.render=function(a,r){var i=a,l=r.getLayout(),d={role:\"form\"};i.write(\"<div\"),i.writeControlData(r),i.addClass(\"sapUiForm\"),i.addClass(\"sapUiFormLblColon\"),i.writeAttribute(\"data-sap-ui-customfastnavgroup\",\"true\");var s=e.form.FormHelper.addFormClass();s&&i.addClass(s),r.getEditable()?(i.addClass(\"sapUiFormEdit\"),i.addClass(\"sapUiFormEdit-CTX\")):d.readonly=\"\",r.getWidth()&&i.addStyle(\"width\",r.getWidth()),r.getTooltip_AsString()&&i.writeAttributeEscaped(\"title\",r.getTooltip_AsString()),i.writeClasses(),i.writeStyles();var o=r.getTitle(),g=r.getToolbar();if(g)r.getAriaLabelledBy()&&0!=r.getAriaLabelledBy().length||(d.labelledby=g.getId());else if(o){var n=\"\";n=\"string\"==typeof o?r.getId()+\"--title\":o.getId(),d.labelledby={value:n,append:!0}}i.writeAccessibilityState(r,d),i.write(\">\"),l?i.renderControl(l):t.sap.log.warning('Form \"'+r.getId()+'\" - Layout missing!',\"Renderer\",\"Form\"),i.write(\"</div>\")},a},!0);",
	"sap/ui/layout/form/GridContainerData.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"sap/ui/core/LayoutData\",\"sap/ui/layout/library\"],function(a,t){\"use strict\";return a.extend(\"sap.ui.layout.form.GridContainerData\",{metadata:{library:\"sap.ui.layout\",properties:{halfGrid:{type:\"boolean\",group:\"Misc\",defaultValue:!1}}}})});",
	"sap/ui/layout/form/GridElementData.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"sap/ui/core/LayoutData\",\"sap/ui/layout/library\"],function(a,e){\"use strict\";return a.extend(\"sap.ui.layout.form.GridElementData\",{metadata:{library:\"sap.ui.layout\",properties:{hCells:{type:\"sap.ui.layout.form.GridElementCells\",group:\"Appearance\",defaultValue:\"auto\"},vCells:{type:\"int\",group:\"Appearance\",defaultValue:1}}}})});",
	"sap/ui/layout/form/GridLayout.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"./FormLayout\",\"sap/ui/layout/library\",\"./GridLayoutRenderer\"],function(t,e,n,r){\"use strict\";var i=e.extend(\"sap.ui.layout.form.GridLayout\",{metadata:{library:\"sap.ui.layout\",properties:{singleColumn:{type:\"boolean\",group:\"Misc\",defaultValue:!1}}}});return i.prototype.toggleContainerExpanded=function(t){this.invalidate()},i.prototype.onAfterRendering=function(){var t=this.getParent();if(t)for(var e=t.getFormContainers(),n=0;n<e.length;n++){var r=e[n];r.getExpandable()&&r._oExpandButton&&r._oExpandButton.$().attr(\"tabindex\",\"-1\")}},i.prototype.contentOnAfterRendering=function(t,n){e.prototype.contentOnAfterRendering.apply(this,arguments),n.getFormDoNotAdjustWidth&&n.getFormDoNotAdjustWidth()||n.$().css(\"width\",\"100%\")},i.prototype.onLayoutDataChange=function(t){this.getDomRef()&&this.invalidate()},i.prototype.onsaptabnext=function(t){this.tabForward(t)},i.prototype.onsaptabprevious=function(t){this.tabBack(t)},i.prototype.findFieldOfElement=function(t,n,r){if(!r)return e.prototype.findPrevFieldOfElement.apply(this,arguments);if(!t.isVisible())return null;var i,o=t.getFields();n=o.length-1;for(var a=n;a>=0;a--){var f=o[a];if(!(r<f.$().offset().left&&0!=a)){var l=this._getDomRef(f);if((!f.getEnabled||f.getEnabled())&&l){i=l;break}}}return i},i.prototype.findFieldBelow=function(t,e){var n,r=e.getParent(),i=r.indexOfFormElement(e);if(r.isVisible())for(var o=r.getFormElements(),a=o.length,f=i+1,l=t.$().offset().left;!n&&f<a;){var d=o[f];n=this.findFieldOfElement(d,0,l),f++}if(!n){var s=r.getParent();i=s.indexOfFormContainer(r),n=this.findFirstFieldOfFirstElementInNextContainer(s,i+1)}return n},i.prototype.findFieldAbove=function(t,e){var n,r=e.getParent(),i=r.indexOfFormElement(e);if(r.isVisible())for(var o=r.getFormElements(),a=i-1,f=t.$().offset().left;!n&&a>=0;){var l=o[a];n=this.findFieldOfElement(l,0,f),a--}if(!n){var d=r.getParent();i=d.indexOfFormContainer(r),n=this.findLastFieldOfLastElementInPrevContainer(d,i-1)}return n},i.prototype.getContainerRenderedDomRef=function(t){return null},i.prototype.getElementRenderedDomRef=function(e){if(this.getDomRef()){var n=this.getSingleColumn(),r=e.getParent(),i=this.getLayoutDataForElement(r,\"sap/ui/layout/form/GridContainerData\");if((n||!i||!i.getHalfGrid())&&!this.getRenderer().checkFullSizeElement(this,e))return t.sap.domById(e.getId())}return null},i});",
	"sap/ui/layout/form/GridLayoutRenderer.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/core/Renderer\",\"./FormLayoutRenderer\"],function(e,t,r){\"use strict\";var i=t.extend(r);return i.renderForm=function(e,t,r){var i,a,l=t.getSingleColumn(),n=16,o=!1,s=0,d=r.getFormContainers(),g=d.length,p=0,u=r.getToolbar(),w=r.getTitle();if(l)n/=2,s=n;else for(s=n/2,p=0;p<g;p++)if((a=this.getContainerData(t,d[p]))&&a.getHalfGrid()){o=!0;break}if(e.write('<table role=\"presentation\"'),e.writeControlData(t),e.write(' cellpadding=\"0\" cellspacing=\"0\"'),e.addStyle(\"border-collapse\",\"collapse\"),e.addStyle(\"table-layout\",\"fixed\"),e.addStyle(\"width\",\"100%\"),e.addClass(\"sapUiGrid\"),this.addBackgroundClass(e,t),u&&e.addClass(\"sapUiFormToolbar\"),e.writeStyles(),e.writeClasses(),e.write(\">\"),e.write(\"<colgroup>\"),e.write(\"<col span=\"+s+\">\"),o&&e.write('<col class = \"sapUiGridSpace\"span=1>'),l||e.write(\"<col span=\"+s+\">\"),e.write(\"</colgroup><tbody>\"),u||w){var c=n;if(o&&c++,e.write('<tr class=\"sapUiGridTitle\"><th colspan='+c+\">\"),u)e.renderControl(u);else{var f=sap.ui.core.theming.Parameters.get(\"sap.ui.layout.FormLayout:_sap_ui_layout_FormLayout_FormTitleSize\");this.renderTitle(e,w,void 0,!1,f,r.getId())}e.write(\"</th></tr>\")}p=0;for(var C,h;p<g;)i=d[p],i._checkProperties(),i.isVisible()&&(a=this.getContainerData(t,i),a&&a.getHalfGrid()&&!l?(C=d[p+1],h=void 0,C&&C.isVisible()&&(h=this.getContainerData(t,C)),h&&h.getHalfGrid()?(C._checkProperties(),this.renderContainerHalfSize(e,t,i,C,n),p++):this.renderContainerHalfSize(e,t,i,void 0,n)):this.renderContainerFullSize(e,t,i,n,o)),p++;e.write(\"</tbody></table>\")},i.renderContainerFullSize=function(e,t,r,i,a){var l=r.getExpandable(),n=r.getTooltip_AsString(),o=r.getToolbar(),s=r.getTitle();if(o||s){var d=i;a&&d++,e.write('<tr class=\"sapUiGridConteinerFirstRow sapUiGridConteinerHeaderRow\"><td colspan='+d),e.addClass(\"sapUiGridHeader\"),n&&e.writeAttributeEscaped(\"title\",n),o?e.addClass(\"sapUiFormContainerToolbar\"):s&&e.addClass(\"sapUiFormContainerTitle\"),e.writeClasses(),e.write(\">\"),o?e.renderControl(o):this.renderTitle(e,r.getTitle(),r._oExpandButton,l,!1,r.getId()),e.write(\"</td></tr>\")}if(!l||r.getExpanded()){for(var g,p,u=r.getFormElements(),w=[],c=!1,f=0,C=u.length;f<C;f++)g=u[f],g.isVisible()&&(p=w[0]&&w[0][0]==i,e.write(\"<tr\"),c||(c=!0,o||s||e.addClass(\"sapUiGridConteinerFirstRow\")),this.checkFullSizeElement(t,g)||\"full\"==w[0]||p||(e.writeElementData(g),e.addClass(\"sapUiFormElement\")),e.writeClasses(),e.write(\">\"),p?w.splice(0,1):w=this.renderElement(e,t,g,!1,i,a,w),e.write(\"</tr>\"),(\"full\"==w[0]||p)&&(f-=1));if(w.length>0)for(var h=0;h<w.length;h++)e.write(\"<tr></tr>\")}},i.renderContainerHalfSize=function(e,t,r,i,a){var l,n,o,s=a/2,d=r.getExpandable(),g=r.getTooltip_AsString(),p=r.getTitle(),u=r.getToolbar(),w=[];d&&!r.getExpanded()||(w=r.getFormElements());var c=w.length,f=[],C=0,h=!1;if(i&&(h=i.getExpandable(),l=i.getTooltip_AsString(),n=i.getTitle(),o=i.getToolbar(),h&&!i.getExpanded()||(f=i.getFormElements()),C=f.length),(p||n||u||o)&&(e.write('<tr class=\"sapUiGridConteinerFirstRow sapUiGridConteinerHeaderRow\"><td colspan='+s),e.addClass(\"sapUiGridHeader\"),g&&e.writeAttributeEscaped(\"title\",g),u?e.addClass(\"sapUiFormContainerToolbar\"):p&&e.addClass(\"sapUiFormContainerTitle\"),e.writeClasses(),e.write(\">\"),u?e.renderControl(u):p&&this.renderTitle(e,p,r._oExpandButton,d,!1,r.getId()),e.write(\"</td><td></td><td colspan=\"+s),e.addClass(\"sapUiGridHeader\"),l&&e.writeAttributeEscaped(\"title\",l),o?e.addClass(\"sapUiFormContainerToolbar\"):n&&e.addClass(\"sapUiFormContainerTitle\"),e.writeClasses(),e.write(\">\"),o?e.renderControl(o):n&&this.renderTitle(e,n,i._oExpandButton,h,!1,i.getId()),e.write(\"</td></tr>\")),!d||r.getExpanded()||!h||i.getExpanded()){for(var m,E,b,F,T=[],v=[],U=0,G=0,y=!1;U<c||G<C;)m=w[U],E=f[G],b=T[0]&&T[0][0]==s,F=v[0]&&v[0][0]==s,m&&m.isVisible()||E&&E.isVisible()||b||F?(e.write(\"<tr\"),y||(y=!0,u||p||o||n||e.addClass(\"sapUiGridConteinerFirstRow\")),e.writeClasses(),e.write(\">\"),b?(T[0][2]>0&&e.write(\"<td colspan=\"+T[0][2]+\"></td>\"),T.splice(0,1)):(m&&m.isVisible()&&(!d||r.getExpanded())?T=this.renderElement(e,t,m,!0,s,!1,T):e.write(\"<td colspan=\"+s+\"></td>\"),\"full\"!=T[0]&&U++),e.write(\"<td></td>\"),F?(v[0][2]>0&&e.write(\"<td colspan=\"+v[0][2]+\"></td>\"),v.splice(0,1)):(E&&E.isVisible()&&(!h||i.getExpanded())?v=this.renderElement(e,t,E,!0,s,!1,v):e.write(\"<td colspan=\"+s+\"></td>\"),\"full\"!=v[0]&&G++),e.write(\"</tr>\")):(U++,G++);if(T.length>0||v.length>0)for(var S=0;S<T.length||S<v.length;S++)e.write(\"<tr></tr>\")}},i.renderElement=function(t,r,i,a,l,n,o){var s=i.getLabelControl(),d=0,g=i.getFields(),p=0,u=0,w=!1,c=1,f=1,C=0;if(this.checkFullSizeElement(r,i)){if(o.length>0&&\"full\"!=o[0])return e.sap.log.error('Element \"'+i.getId()+'\" - Too much fields for one row!',\"Renderer\",\"GridLayout\"),o;if(n&&(l+=1),s&&\"full\"!=o[0])return t.write(\"<td colspan=\"+l+' class=\"sapUiFormElementLbl sapUiGridLabelFull\">'),t.renderControl(s),t.write(\"</td>\"),[\"full\"];if(o.splice(0,1),f=this.getElementData(r,g[0]).getVCells(),t.write(\"<td colspan=\"+l),f>1&&a)for(t.write(\" rowspan=\"+f),C=0;C<f-1;C++)o.push([l,void 0,!1]);return t.write(\" >\"),t.renderControl(g[0]),t.write(\"</td>\"),o}o.length>0&&o[0][0]>0&&(l=l-o[0][0]+o[0][2],w=o[0][1],d=o[0][2],o.splice(0,1));var h,m=d,E=\"\";if((s||d>0)&&(m=3,s&&0==d&&(h=this.getElementData(r,s))&&\"auto\"!=(E=h.getHCells())&&\"full\"!=E&&(m=parseInt(E,10)),t.write(\"<td colspan=\"+m+' class=\"sapUiFormElementLbl\">'),s&&t.renderControl(s),l-=m,t.write(\"</td>\")),g&&g.length>0){var b,F=l,T=g.length,v=0,U=0;for(v=0,U=g.length;v<U;v++)b=g[v],(h=this.getElementData(r,b))&&\"auto\"!=h.getHCells()&&(F-=parseInt(h.getHCells(),10),T-=1);var G=0;for(v=0,G=0,U=g.length;v<U;v++){if(b=g[v],h=this.getElementData(r,b),E=\"auto\",c=1,f=1,h&&(E=h.getHCells(),f=h.getVCells()),\"auto\"==E?F>0?(c=Math.floor(F/T),c<1&&(c=1),G++,u+=c,G==T&&F>u&&(c+=F-u)):c=1:c=parseInt(E,10),(p+=c)>l){e.sap.log.error('Element \"'+i.getId()+'\" - Too much fields for one row!',\"Renderer\",\"GridLayout\"),p-=c;break}if(f>1)for(C=0;C<f-1;C++)s&&(d=m),o.length>C?(o[C][0]=o[C][0]+c,o[C][2]=d):o.push([m+c,void 0,d]);if(n&&p>=Math.floor(l/2)&&!w&&(c+=1,w=!0,f>1))for(C=0;C<f-1;C++)o[C][1]=!0;t.write(\"<td\"),c>1&&t.write(\" colspan=\"+c),f>1&&t.write(\" rowspan=\"+f),t.write(\" >\"),t.renderControl(b),t.write(\"</td>\")}}if(p<l){var y=l-p;a||!n||w||y++,t.write(\"<td colspan=\"+y+\" ></td>\")}return o},i.checkFullSizeElement=function(e,t){var r=t.getFields();return!(1!=r.length||!this.getElementData(e,r[0])||\"full\"!=this.getElementData(e,r[0]).getHCells())},i.getContainerData=function(e,t){return e.getLayoutDataForElement(t,\"sap/ui/layout/form/GridContainerData\")},i.getElementData=function(e,t){return e.getLayoutDataForElement(t,\"sap/ui/layout/form/GridElementData\")},i},!0);",
	"sap/ui/layout/form/ResponsiveGridLayout.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/layout/Grid\",\"sap/ui/layout/GridData\",\"./Form\",\"./FormContainer\",\"./FormElement\",\"./FormLayout\",\"sap/ui/layout/library\",\"sap/ui/core/Control\",\"sap/ui/core/ResizeHandler\",\"./ResponsiveGridLayoutRenderer\"],function(t,e,a,n,i,r,o,s,l,u,d){\"use strict\";function p(t){var e,a,n,i,r=t.getFormContainers(),o=r.length,s=0,l=0,u=[],d=0;for(d=0;d<o;d++)n=r[d],n._checkProperties(),n.isVisible()&&(s++,u.push(n));for(d=0;d<s;d++)if(n=u[d],n.isVisible()){l++,i=n.getId(),e=void 0,a=void 0;var p=u[d+1];a=this.mContainers[i]&&this.mContainers[i][1]?this.mContainers[i][1]:f.call(this,n);var y=n.getTitle(),_=n.getToolbar();_||y||n.getExpandable()?(this.mContainers[i]&&this.mContainers[i][0]?e=this.mContainers[i][0]:(e=g.call(this,n,a),h(a,!0)),L(e,n,l,p,s)):(this.mContainers[i]&&this.mContainers[i][0]&&m(this.mContainers[i][0]),h(a,!1),L(a,n,l,p,s)),this.mContainers[i]=[e,a]}if(s<Object.keys(this.mContainers).length)for(i in this.mContainers){var b=!1;for(d=0;d<o;d++)if(n=r[d],i==n.getId()&&n.isVisible()){b=!0;break}b||C.call(this,i)}}function g(t,e){var a=t.getId();return new c(a+\"---Panel\",{container:t,layout:this,content:e})}function m(t){t.setContent(\"\"),t.setLayout(\"\"),t.setContainer(\"\"),t.destroy()}function f(a){var n=a.getId()+\"--Grid\",i=new e(n,{vSpacing:0,hSpacing:0,containerQuery:!0});i.__myParentLayout=this,i.__myParentContainerId=a.getId(),i.addStyleClass(\"sapUiFormResGridCont\"),i.getContent=function(){var t=sap.ui.getCore().byId(this.__myParentContainerId);if(t){for(var e,a,n=[],i=t.getFormElements(),r=0;r<i.length;r++){var o=i[r];if(o.isVisible()){a=o.getLabelControl(),a&&n.push(a),e=o.getFields();for(var s=0;s<e.length;s++)n.push(e[s])}}return n}return!1},i.getAriaLabelledBy=function(){var t=sap.ui.getCore().byId(this.__myParentContainerId);return!t||t.getToolbar()||t.getTitle()||t.getExpandable()?[]:t.getAriaLabelledBy()};var r={labelSpan:0,span:0,firstField:!1,defaultFields:0,row:0,myRow:!1,freeFields:0,finished:!1},o={id:\"XL\",getEffectiveSpan:function(t){var e=t._getEffectiveSpanXLarge();return e||(e=t._getEffectiveSpanLarge()),e},getEmptySpan:function(t){var e=t.getEmptySpanXL();return e<0&&(e=t.getEmptySpanL()),e},getLabelSpan:function(t){return t.getLabelSpanXL()},setIndent:function(t,e){t.setIndentXL(e)},setLinebreak:function(t,e){t.setLinebreakXL(e)}};t.extend(o,r);var s={id:\"L\",getEffectiveSpan:function(t){return t._getEffectiveSpanLarge()},getEmptySpan:function(t){return t.getEmptySpanL()},getLabelSpan:function(t){return t.getLabelSpanL()},setIndent:function(t,e){t.setIndentL(e)},setLinebreak:function(t,e){t.setLinebreakL(e)}};t.extend(s,r);var l={id:\"M\",getEffectiveSpan:function(t){return t._getEffectiveSpanMedium()},getEmptySpan:function(t){return t.getEmptySpanM()},getLabelSpan:function(t){return t.getLabelSpanM()},setIndent:function(t,e){t.setIndentM(e)},setLinebreak:function(t,e){t.setLinebreakM(e)}};t.extend(l,r);var u={id:\"S\",getEffectiveSpan:function(t){return t._getEffectiveSpanSmall()},getEmptySpan:function(t){return t.getEmptySpanS()},getLabelSpan:function(t){return t.getLabelSpanS()},setIndent:function(t,e){t.setIndentS(e)},setLinebreak:function(t,e){t.setLinebreakS(e)}};t.extend(u,r);var d=[o,s,l,u];return i._getLayoutDataForControl=function(e){var a=this.__myParentLayout,n=a.getLayoutDataForElement(e,\"sap/ui/layout/GridData\"),i=e.getParent(),p=i.getLabelControl();if(n)return p==e&&n._setStylesInternal(\"sapUiFormElementLbl\"),n;var g,m=sap.ui.getCore().byId(this.__myParentContainerId),f=a.getLayoutDataForElement(m,\"sap/ui/layout/GridData\"),y=m.getParent(),h=0;for(h=0;h<d.length;h++)g=d[h],t.extend(g,r),g.labelSpan=g.getLabelSpan(a);if(a.getAdjustLabelSpan()&&(y.getFormContainers().length>=1&&a.getColumnsM()>1&&(l.labelSpan=a.getLabelSpanL()),f&&12==f._getEffectiveSpanLarge()&&(s.labelSpan=a.getLabelSpanM(),l.labelSpan=a.getLabelSpanM()),1!=y.getFormContainers().length&&1!=a.getColumnsL()||(s.labelSpan=a.getLabelSpanM(),l.labelSpan=a.getLabelSpanM())),o.labelSpan<0&&(o.labelSpan=s.labelSpan),p==e)return a.oDummyLayoutData.setSpan(\"XL\"+o.labelSpan+\" L\"+s.labelSpan+\" M\"+l.labelSpan+\" S\"+u.labelSpan),a.oDummyLayoutData.setLinebreak(!0),a.oDummyLayoutData.setIndentXL(0).setIndentL(0).setIndentM(0).setIndentS(0),a.oDummyLayoutData._setStylesInternal(\"sapUiFormElementLbl\"),a.oDummyLayoutData;var L;p&&(L=a.getLayoutDataForElement(p,\"sap/ui/layout/GridData\"));var C,_,b,c=i.getFields(),v=c.length,S=1,D=!1,F=0;for(h=0;h<d.length;h++)g=d[h],g.span=12-g.getEmptySpan(a),p&&(L&&(b=g.getEffectiveSpan(L))&&(g.labelSpan=b),g.labelSpan<12&&(g.span=g.span-g.labelSpan)),g.spanFields=g.span;for(F=0;F<v;F++)if((C=c[F])!=e)if(_=a.getLayoutDataForElement(C,\"sap/ui/layout/GridData\"))for(h=0;h<d.length;h++)g=d[h],(b=g.getEffectiveSpan(_))&&b<g.span&&(g.span=g.span-b);else S++;else 1==S&&(D=!0);var G=[];for(h=0;h<d.length;h++)g=d[h],g.firstField=D,g.defaultFields=S,g.span<S&&(g.defaultFields=0,g.row=0,g.myRow=!1,g.freeFields=g.spanFields,g.span=g.spanFields,g.finished=!1,G.push(g));if(G.length>0)for(F=0;F<v;F++)for(C=c[F],_=void 0,C!=e&&(_=a.getLayoutDataForElement(C,\"sap/ui/layout/GridData\")),h=0;h<G.length;h++)g=G[h],g.finished||(_?(b=g.getEffectiveSpan(_),g.span=g.span-b):b=1,g.freeFields>=b?(g.freeFields=g.freeFields-b,_||g.defaultFields++):g.myRow?g.finished=!0:(g.freeFields=g.spanFields-b,g.row++,_?(g.defaultFields=0,g.span=g.spanFields-b):(g.defaultFields=1,g.span=g.spanFields),C==e&&(g.firstField=!0)),C==e&&(g.myRow=!0));var I,R=0,M=\"\";for(h=0;h<d.length;h++)g=d[h],\"S\"!=g.id||g.labelSpan<12?g.firstField?(R=g.span-Math.floor(g.span/g.defaultFields)*g.defaultFields,I=Math.floor(g.span/g.defaultFields)+R):I=Math.floor(g.span/g.defaultFields):I=12,M&&(M+=\" \"),M=M+g.id+I,g.setLinebreak(a.oDummyLayoutData,g.firstField&&g.row>0),g.setIndent(a.oDummyLayoutData,g.firstField&&g.row>0?g.labelSpan:0);return a.oDummyLayoutData.setSpan(M),a.oDummyLayoutData.setLinebreak(D&&!p),a.oDummyLayoutData._setStylesInternal(void 0),a.oDummyLayoutData},i._onParentResizeOrig=i._onParentResize,i._onParentResize=function(){if(!this.getDomRef())return void this._cleanup();if(t(this.getDomRef()).is(\":visible\")){var e=this.__myParentLayout;if(e._mainGrid&&e._mainGrid.__bIsUsed){var a=e._mainGrid.$();a.hasClass(\"sapUiRespGridMedia-Std-Phone\")?this._toggleClass(\"Phone\"):a.hasClass(\"sapUiRespGridMedia-Std-Tablet\")?this._toggleClass(\"Tablet\"):a.hasClass(\"sapUiRespGridMedia-Std-Desktop\")?this._toggleClass(\"Desktop\"):this._toggleClass(\"LargeDesktop\")}else{for(var n,i=e.getParent().getFormContainers(),r=0;r<i.length;r++)if(i[r].isVisible()){n=i[r];break}if(!n||!e.mContainers[n.getId()]||n.getId()!=this.__myParentContainerId)return;if(e.mContainers[this.__myParentContainerId][0]){var o=e.mContainers[this.__myParentContainerId][0].getDomRef(),s=o.clientWidth;s<=e.getBreakpointM()?this._toggleClass(\"Phone\"):s>e.getBreakpointM()&&s<=e.getBreakpointL()?this._toggleClass(\"Tablet\"):s>e.getBreakpointL()&&s<=e.getBreakpointXL()?this._toggleClass(\"Desktop\"):this._toggleClass(\"LargeDesktop\")}else this._setBreakPointTablet(e.getBreakpointM()),this._setBreakPointDesktop(e.getBreakpointL()),this._setBreakPointLargeDesktop(e.getBreakpointXL()),this._onParentResizeOrig()}}},i._getAccessibleRole=function(){var t=sap.ui.getCore().byId(this.__myParentContainerId),e=this.__myParentLayout;if(e._mainGrid&&e._mainGrid.__bIsUsed&&!t.getToolbar()&&!t.getTitle()&&!t.getExpandable()&&t.getAriaLabelledBy().length>0)return\"form\"},i.getUIArea=function(){var t=this.__myParentLayout;return t?t.getUIArea():null},i}function y(t){t.__myParentContainerId&&(t.__myParentContainerId=void 0),t.__myParentLayout=void 0,t.destroy()}function h(t,e){e?t.__originalGetLayoutData&&(t.getLayoutData=t.__originalGetLayoutData,delete t.__originalGetLayoutData):t.__originalGetLayoutData||(t.__originalGetLayoutData=t.getLayoutData,t.getLayoutData=function(){var t,e=this.__myParentLayout,a=sap.ui.getCore().byId(this.__myParentContainerId);return a&&(t=e.getLayoutDataForElement(a,\"sap/ui/layout/GridData\")),t||this.getAggregation(\"layoutData\")})}function L(t,e,n,i,r){var o;o=t instanceof c?sap.ui.getCore().byId(t.getLayout()):t.__myParentLayout;var s=o.getLayoutDataForElement(e,\"sap/ui/layout/GridData\");if(!s){var l=o.getColumnsM(),u=o.getColumnsL(),d=o.getColumnsXL(),p=n%u==1,g=n%u==0,m=n>u*(Math.ceil(r/u)-1),f=n<=u,y=n%l==1,h=n%l==0,L=n>l*(Math.ceil(r/l)-1),C=n<=l,_=!1,b=g,v=m,S=f;if(d>0&&(_=n%d==1,b=n%d==0,v=n>d*(Math.ceil(r/d)-1),S=n<=d),i){var D=o.getLayoutDataForElement(i,\"sap/ui/layout/GridData\");D&&(D.getLinebreak()||D.getLinebreakXL())&&(b=!0,v=!1),D&&(D.getLinebreak()||D.getLinebreakL())&&(g=!0,m=!1),D&&(D.getLinebreak()||D.getLinebreakM())&&(h=!0,L=!1)}var F=\"\";b&&(F=\"sapUiFormResGridLastContXL\"),g&&(F&&(F+=\" \"),F+=\"sapUiFormResGridLastContL\"),h&&(F&&(F+=\" \"),F+=\"sapUiFormResGridLastContM\"),v&&(F&&(F+=\" \"),F+=\"sapUiFormResGridLastRowXL\"),m&&(F&&(F+=\" \"),F+=\"sapUiFormResGridLastRowL\"),L&&(F&&(F+=\" \"),F+=\"sapUiFormResGridLastRowM\"),S&&(F&&(F+=\" \"),F+=\"sapUiFormResGridFirstRowXL\"),f&&(F&&(F+=\" \"),F+=\"sapUiFormResGridFirstRowL\"),C&&(F&&(F+=\" \"),F+=\"sapUiFormResGridFirstRowM\"),s=t.getLayoutData(),s?(s.setLinebreakL(p),s.setLinebreakM(y)):(s=new a(t.getId()+\"--LD\",{linebreakL:p,linebreakM:y}),t.setLayoutData(s)),d>0&&s.setLinebreakXL(_),s._setStylesInternal(F)}}function C(t){var e=this.mContainers[t],a=e[1];a&&y(a);var n=e[0];n&&m(n),delete this.mContainers[t]}function _(t){var a,n=t.getFormContainers(),i=[],r=0,o=0,s=0,l=0;for(s=0;s<n.length;s++)a=n[s],a.isVisible()&&(r++,i.push(a));if(r>1||!this.getSingleContainerFullSize()){var u,d=Math.floor(12/this.getColumnsM()),p=Math.floor(12/this.getColumnsL()),g=\"\",m=this.getColumnsXL();if(m>=0&&(u=Math.floor(12/m),g=g+\"XL\"+u+\" \"),g=g+\"L\"+p+\" M\"+d+\" S12\",this._mainGrid){this._mainGrid.setDefaultSpan(g);var f=this._mainGrid.getContent();o=f.length;var y=!1;for(s=0;s<o;s++){var h=f[s];if(a=void 0,(a=h.getContainer?sap.ui.getCore().byId(h.getContainer()):sap.ui.getCore().byId(h.__myParentContainerId))&&a.isVisible()){if(a!=i[l]){y=!0;break}var L=this.mContainers[a.getId()];if(L[0]&&L[0]!=h){y=!0;break}if(!L[0]&&L[1]&&L[1]!=h){y=!0;break}l++}else this._mainGrid.removeContent(h)}y&&(this._mainGrid.removeAllContent(),o=0)}else this._mainGrid=new e(t.getId()+\"--Grid\",{defaultSpan:g,hSpacing:0,vSpacing:0,containerQuery:!0}).setParent(this),this._mainGrid.addStyleClass(\"sapUiFormResGridMain\"),this._mainGrid._onParentResizeOrig=this._mainGrid._onParentResize,this._mainGrid._onParentResize=function(){this._onParentResizeOrig();var t=this.getParent();for(var e in t.mContainers)t.mContainers[e][1]._onParentResize()};if(this._mainGrid._setBreakPointTablet(this.getBreakpointM()),this._mainGrid._setBreakPointDesktop(this.getBreakpointL()),this._mainGrid._setBreakPointLargeDesktop(this.getBreakpointXL()),this._mainGrid.__bIsUsed=!0,o<r){var C=0;for(o>0&&(C=o--),s=C;s<n.length;s++)if(a=n[s],a.isVisible()){var _=a.getId();this.mContainers[_]&&(this.mContainers[_][0]?this._mainGrid.addContent(this.mContainers[_][0]):this.mContainers[_][1]&&this._mainGrid.addContent(this.mContainers[_][1]))}}}else this._mainGrid&&(this._mainGrid.__bIsUsed=!1)}var b=o.extend(\"sap.ui.layout.form.ResponsiveGridLayout\",{metadata:{library:\"sap.ui.layout\",properties:{labelSpanXL:{type:\"int\",group:\"Misc\",defaultValue:-1},labelSpanL:{type:\"int\",group:\"Misc\",defaultValue:4},labelSpanM:{type:\"int\",group:\"Misc\",defaultValue:2},labelSpanS:{type:\"int\",group:\"Misc\",defaultValue:12},adjustLabelSpan:{type:\"boolean\",group:\"Misc\",defaultValue:!0},emptySpanXL:{type:\"int\",group:\"Misc\",defaultValue:-1},emptySpanL:{type:\"int\",group:\"Misc\",defaultValue:0},emptySpanM:{type:\"int\",group:\"Misc\",defaultValue:0},emptySpanS:{type:\"int\",group:\"Misc\",defaultValue:0},columnsXL:{type:\"int\",group:\"Misc\",defaultValue:-1},columnsL:{type:\"int\",group:\"Misc\",defaultValue:2},columnsM:{type:\"int\",group:\"Misc\",defaultValue:1},singleContainerFullSize:{type:\"boolean\",group:\"Misc\",defaultValue:!0},breakpointXL:{type:\"int\",group:\"Misc\",defaultValue:1440},breakpointL:{type:\"int\",group:\"Misc\",defaultValue:1024},breakpointM:{type:\"int\",group:\"Misc\",defaultValue:600}}}}),c=l.extend(\"sap.ui.layout.form.ResponsiveGridLayoutPanel\",{metadata:{aggregations:{content:{type:\"sap.ui.layout.Grid\",multiple:!1}},associations:{container:{type:\"sap.ui.layout.form.FormContainer\",multiple:!1},layout:{type:\"sap.ui.layout.form.ResponsiveGridLayout\",multiple:!1}}},getLayoutData:function(){var t,e=sap.ui.getCore().byId(this.getContainer()),a=sap.ui.getCore().byId(this.getLayout());return a&&e&&(t=a.getLayoutDataForElement(e,\"sap/ui/layout/GridData\")),t||this.getAggregation(\"layoutData\")},getCustomData:function(){var t=sap.ui.getCore().byId(this.getContainer());if(t)return t.getCustomData()},refreshExpanded:function(){var t=sap.ui.getCore().byId(this.getContainer());t&&(t.getExpanded()?this.$().removeClass(\"sapUiRGLContainerColl\"):this.$().addClass(\"sapUiRGLContainerColl\"))},renderer:function(t,e){var a=sap.ui.getCore().byId(e.getContainer()),n=sap.ui.getCore().byId(e.getLayout()),i=e.getContent(),r=a.getExpandable(),o=a.getTooltip_AsString(),s=a.getToolbar(),l=a.getTitle();t.write(\"<div\"),t.writeControlData(e),t.addClass(\"sapUiRGLContainer\"),r&&!a.getExpanded()&&t.addClass(\"sapUiRGLContainerColl\"),s?t.addClass(\"sapUiFormContainerToolbar\"):l&&t.addClass(\"sapUiFormContainerTitle\"),o&&t.writeAttributeEscaped(\"title\",o),t.writeClasses(),n.getRenderer().writeAccessibilityStateContainer(t,a),t.write(\">\"),s?t.renderControl(s):a.getTitle()&&n.getRenderer().renderTitle(t,l,a._oExpandButton,r,!1,a.getId()),i&&(t.write(\"<div\"),t.addClass(\"sapUiRGLContainerCont\"),t.writeClasses(),t.write(\">\"),t.renderControl(i),t.write(\"</div>\")),t.write(\"</div>\")}});return b.prototype.init=function(){this.mContainers={},this.oDummyLayoutData=new a(this.getId()+\"--Dummy\")},b.prototype.exit=function(){for(var t in this.mContainers)C.call(this,t);this._mainGrid&&(this._mainGrid.destroy(),delete this._mainGrid),this.oDummyLayoutData.destroy(),this.oDummyLayoutData=void 0},b.prototype.onBeforeRendering=function(t){var e=this.getParent();e&&e instanceof n&&(e._bNoInvalidate=!0,p.call(this,e),_.call(this,e),e._bNoInvalidate=!1)},b.prototype.onAfterRendering=function(t){if(this._mainGrid&&this._mainGrid.__bIsUsed)for(var e in this.mContainers)this.mContainers[e][1]._sContainerResizeListener&&(u.deregister(this.mContainers[e][1]._sContainerResizeListener),this.mContainers[e][1]._sContainerResizeListener=null)},b.prototype.contentOnAfterRendering=function(t,e){o.prototype.contentOnAfterRendering.apply(this,arguments),!e.getWidth||e.getWidth()&&\"auto\"!=e.getWidth()||e.getFormDoNotAdjustWidth&&e.getFormDoNotAdjustWidth()||e.$().css(\"width\",\"100%\")},b.prototype.toggleContainerExpanded=function(t){var e=t.getId();if(this.mContainers[e]&&this.mContainers[e][0]){this.mContainers[e][0].refreshExpanded()}},b.prototype.onLayoutDataChange=function(t){var e=t.srcControl;if(e instanceof i)this._mainGrid&&(this._mainGrid.onLayoutDataChange(t),this.invalidate());else if(!(e instanceof r)){var a=e.getParent();if(a instanceof r){var n=a.getParent(),o=n.getId();this.mContainers[o]&&this.mContainers[o][1]&&this.mContainers[o][1].onLayoutDataChange(t)}}},b.prototype.onsapup=function(t){this.onsapleft(t)},b.prototype.onsapdown=function(t){this.onsapright(t)},b.prototype.getContainerRenderedDomRef=function(t){if(this.getDomRef()){var e=t.getId();if(this.mContainers[e]){if(this.mContainers[e][0]){return this.mContainers[e][0].getDomRef()}if(this.mContainers[e][1]){return this.mContainers[e][1].getDomRef()}}}return null},b.prototype.getElementRenderedDomRef=function(t){return null},b});",
	"sap/ui/layout/form/ResponsiveGridLayoutRenderer.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"sap/ui/core/Renderer\",\"./FormLayoutRenderer\"],function(e,r){\"use strict\";var n=e.extend(r);return n.getMainClass=function(){return\"sapUiFormResGrid\"},n.renderContainers=function(e,r,n){for(var t=n.getFormContainers(),i=[],o=0,a=0;a<t.length;a++){var s=t[a];s.isVisible()&&(o++,i.push(s))}o>0&&(o>1||!r.getSingleContainerFullSize()?e.renderControl(r._mainGrid):r.mContainers[i[0].getId()][0]?e.renderControl(r.mContainers[i[0].getId()][0]):e.renderControl(r.mContainers[i[0].getId()][1]))},n},!0);",
	"sap/ui/layout/form/ResponsiveLayout.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/layout/ResponsiveFlowLayout\",\"sap/ui/layout/ResponsiveFlowLayoutData\",\"./Form\",\"./FormContainer\",\"./FormElement\",\"./FormLayout\",\"sap/ui/layout/library\",\"sap/ui/core/Control\",\"./ResponsiveLayoutRenderer\"],function(t,e,a,n,i,o,r,s,l,u){\"use strict\";function d(t){var e,a,n,i,o=t.getFormContainers(),r=o.length,s=0,l=0;for(l=0;l<r;l++)if(e=o[l],e._checkProperties(),e.isVisible()){s++,a=e.getId(),n=void 0,i=void 0,i=this.mContainers[a]&&this.mContainers[a][1]?this.mContainers[a][1]:m.call(this,e,void 0);var u=e.getTitle(),d=e.getToolbar();d||u||e.getExpandable()?(this.mContainers[a]&&this.mContainers[a][0]?n=this.mContainers[a][0]:(n=g.call(this,e,i),h(i,!0)),i.removeStyleClass(\"sapUiRLContainer\")):(this.mContainers[a]&&this.mContainers[a][0]&&(C(this.mContainers[a][0]),h(i,!1)),i.addStyleClass(\"sapUiRLContainer\"));var f=y.call(this,e,i);this.mContainers[a]=[n,i,f]}if(s<Object.keys(this.mContainers).length)for(a in this.mContainers){var p=!1;for(l=0;l<r;l++)if(e=o[l],a==e.getId()&&e.isVisible()){p=!0;break}p||v.call(this,a)}}function g(t,e){var a=t.getId();return new I(a+\"--Panel\",{container:t,layout:this,content:e})}function C(t){t.setContent(\"\"),t.setLayout(\"\"),t.setContainer(\"\"),t.destroy()}function y(t,e){var a=t.getId(),n=t.getFormElements(),i=n.length,o=0,r={};this.mContainers[a]&&this.mContainers[a][2]&&(r=this.mContainers[a][2]);var s,l,u,d,g=-1,C=0;for(C=0;C<i;C++)if(u=n[C],u.isVisible()){d=u.getId(),L.call(this,t,u,r,e,C),r[d]?(s=r[d][0],(g=e.indexOfContent(s))!=o&&(e.removeContent(s),e.insertContent(s,o),g=o)):(s=m.call(this,t,u),s.addStyleClass(\"sapUiRLElement\"),u.getLabel()&&s.addStyleClass(\"sapUiRLElementWithLabel\"),r[d]=[s,void 0],g++,e.insertContent(s,g));var y=u.getFields();u.getLabel()&&y.length>1?(r[d][1]?l=r[d][1]:(l=m.call(this,t,u,!0),l.addStyleClass(\"sapUiRLElementFields\"),r[d][1]=l),f.call(this,l,y)):r[d][1]&&(l=r[d][1],p(l),r[d][1]=void 0),o++}if(o<Object.keys(r).length)for(d in r){var h=!1;for(C=0;C<i;C++)if(u=n[C],d==u.getId()&&u.isVisible()){h=!0;break}h||(r[d][1]&&(l=r[d][1],p(l)),s=r[d][0],e.removeContent(s),p(s),delete r[d])}return r}function m(t,n,i){var o;if(n&&!i)o=n.getId()+\"--RFLayout\";else if(n&&i)o=n.getId()+\"--content--RFLayout\";else{if(!t)return!1;o=t.getId()+\"--RFLayout\"}var r=new e(o);return r.__myParentLayout=this,r.__myParentContainerId=t.getId(),n?(r.__myParentElementId=n.getId(),i?r.getContent=function(){var t=sap.ui.getCore().byId(this.__myParentElementId);return!!t&&t.getFields()}:(r.getContent=function(){var t=sap.ui.getCore().byId(this.__myParentElementId);if(t){var e=[],a=t.getLabelControl(),n=t.getFields();if(!a||n.length<=1)e=n,a&&e.unshift(a);else{var i=this.__myParentLayout,o=this.__myParentContainerId,r=t.getId();a&&e.push(a),i.mContainers[o]&&i.mContainers[o][2]&&i.mContainers[o][2][r]&&i.mContainers[o][2][r][1]&&e.push(i.mContainers[o][2][r][1])}return e}return!1},r._addContentClass=function(t,e){if(0==e){var a=sap.ui.getCore().byId(this.__myParentElementId);if(a){if(t==a.getLabelControl())return\"sapUiFormElementLbl\"}}return null})):t&&(r._getAccessibleRole=function(){var t=sap.ui.getCore().byId(this.__myParentContainerId);if(this.__myParentLayout._mainRFLayout&&!t.getToolbar()&&!t.getTitle()&&!t.getExpandable()&&t.getAriaLabelledBy().length>0)return\"form\"},r.getAriaLabelledBy=function(){var t=sap.ui.getCore().byId(this.__myParentContainerId);return!t||t.getToolbar()||t.getTitle()||t.getExpandable()?[]:t.getAriaLabelledBy()}),n&&!i||!n&&!t.getToolbar()&&!t.getTitle()&&!t.getExpandable()?h(r,!1):r.setLayoutData(new a({margin:!1})),r}function h(t,e){e?t.__originalGetLayoutData&&(t.getLayoutData=t.__originalGetLayoutData,delete t.__originalGetLayoutData):t.__originalGetLayoutData||(t.__originalGetLayoutData=t.getLayoutData,t.getLayoutData=function(){var t,e=this.__myParentLayout,a=sap.ui.getCore().byId(this.__myParentContainerId),n=sap.ui.getCore().byId(this.__myParentElementId);return n?t=e.getLayoutDataForElement(n,\"sap/ui/layout/ResponsiveFlowLayoutData\"):a&&(t=e.getLayoutDataForElement(a,\"sap/ui/layout/ResponsiveFlowLayoutData\")),t||(n?e._defaultLayoutData:void 0)})}function f(t,e){for(var n,i=0,o=0;o<e.length;o++){var r=e[o];n=this.getLayoutDataForElement(r,\"sap/ui/layout/ResponsiveFlowLayoutData\"),n?i+=n.getWeight():i++}n=t.getLayoutData(),n?n.setWeight(i):t.setLayoutData(new a({weight:i}))}function p(t){t.__myParentContainerId&&(t.__myParentContainerId=void 0),t.__myParentElementId&&(t.__myParentElementId=void 0),t.__myParentLayout=void 0,t.destroy()}function v(t){var e,a=this.mContainers[t],n=a[2];if(n)for(var i in n)n[i][1]&&p(n[i][1]),e=n[i][0],p(e),delete n[i];(e=a[1])&&(e.removeAllContent(),p(e));var o=a[0];o&&C(o),delete this.mContainers[t]}function L(t,e,a,n,i){var o=e.getId(),r=o+\"--RFLayout\",s=sap.ui.getCore().byId(r);if(!a[o]&&s){var l=s.__myParentContainerId;a[o]=this.mContainers[l][2][o],n.insertContent(s,i),s.__myParentContainerId=t.getId(),a[o][1]&&(a[o][1].__myParentContainerId=t.getId()),delete this.mContainers[l][2][o]}}function _(t){var a,n=t.getFormContainers(),i=[],o=0,r=0,s=0,l=0;for(s=0;s<n.length;s++)a=n[s],a.isVisible()&&(o++,i.push(a));if(o>1){if(this._mainRFLayout){var u=this._mainRFLayout.getContent();r=u.length;var d=!1;for(s=0;s<r;s++){var g=u[s];if(a=void 0,(a=g.getContainer?sap.ui.getCore().byId(g.getContainer()):sap.ui.getCore().byId(g.__myParentContainerId))&&a.isVisible()){if(a!=i[l]){d=!0;break}var C=this.mContainers[a.getId()];if(C[0]&&C[0]!=g){d=!0;break}if(!C[0]&&C[1]&&C[1]!=g){d=!0;break}l++}else this._mainRFLayout.removeContent(g)}d&&(this._mainRFLayout.removeAllContent(),r=0)}else this._mainRFLayout=new e(t.getId()+\"--RFLayout\").setParent(this);if(r<o){var y=0;for(r>0&&(y=r--),s=y;s<o;s++){a=i[s];var m=a.getId();this.mContainers[m]&&(this.mContainers[m][0]?this._mainRFLayout.addContent(this.mContainers[m][0]):this.mContainers[m][1]&&this._mainRFLayout.addContent(this.mContainers[m][1]))}}}}var c=r.extend(\"sap.ui.layout.form.ResponsiveLayout\",{metadata:{library:\"sap.ui.layout\"}}),I=l.extend(\"sap.ui.layout.form.ResponsiveLayoutPanel\",{metadata:{aggregations:{content:{type:\"sap.ui.layout.ResponsiveFlowLayout\",multiple:!1}},associations:{container:{type:\"sap.ui.layout.form.FormContainer\",multiple:!1},layout:{type:\"sap.ui.layout.form.ResponsiveLayout\",multiple:!1}}},getLayoutData:function(){var t,e=sap.ui.getCore().byId(this.getContainer()),a=sap.ui.getCore().byId(this.getLayout());return a&&e&&(t=a.getLayoutDataForElement(e,\"sap/ui/layout/ResponsiveFlowLayoutData\")),t},getCustomData:function(){var t=sap.ui.getCore().byId(this.getContainer());if(t)return t.getCustomData()},refreshExpanded:function(){var t=sap.ui.getCore().byId(this.getContainer());t&&(t.getExpanded()?this.$().removeClass(\"sapUiRLContainerColl\"):this.$().addClass(\"sapUiRLContainerColl\"))},renderer:function(t,e){var a=sap.ui.getCore().byId(e.getContainer()),n=sap.ui.getCore().byId(e.getLayout()),i=e.getContent();if(a&&n){var o=a.getExpandable(),r=a.getTooltip_AsString(),s=a.getToolbar(),l=a.getTitle();t.write(\"<div\"),t.writeControlData(e),t.addClass(\"sapUiRLContainer\"),o&&!a.getExpanded()&&t.addClass(\"sapUiRLContainerColl\"),s?t.addClass(\"sapUiFormContainerToolbar\"):l&&t.addClass(\"sapUiFormContainerTitle\"),r&&t.writeAttributeEscaped(\"title\",r),t.writeClasses(),n.getRenderer().writeAccessibilityStateContainer(t,a),t.write(\">\"),s?t.renderControl(s):a.getTitle()&&n.getRenderer().renderTitle(t,l,a._oExpandButton,o,!1,a.getId()),i&&(t.write(\"<div\"),t.addClass(\"sapUiRLContainerCont\"),t.writeClasses(),t.write(\">\"),t.renderControl(i),t.write(\"</div>\")),t.write(\"</div>\")}}});return c.prototype.init=function(){this.mContainers={},this._defaultLayoutData=new a({margin:!1})},c.prototype.exit=function(){for(var t in this.mContainers)v.call(this,t);this._mainRFLayout&&(this._mainRFLayout.destroy(),delete this._mainRFLayout),this._defaultLayoutData.destroy(),delete this._defaultLayoutData},c.prototype.onBeforeRendering=function(t){var e=this.getParent();e&&e instanceof n&&(e._bNoInvalidate=!0,d.call(this,e),_.call(this,e),e._bNoInvalidate=!1)},c.prototype.contentOnAfterRendering=function(t,e){r.prototype.contentOnAfterRendering.apply(this,arguments),!e.getWidth||e.getWidth()&&\"auto\"!=e.getWidth()||e.getFormDoNotAdjustWidth&&e.getFormDoNotAdjustWidth()||e.$().css(\"width\",\"100%\")},c.prototype.toggleContainerExpanded=function(t){var e=t.getId();if(this.mContainers[e]&&this.mContainers[e][0]){this.mContainers[e][0].refreshExpanded()}},c.prototype.onLayoutDataChange=function(t){var e,a,n,r=t.srcControl;if(r instanceof i)this._mainRFLayout&&this._mainRFLayout.onLayoutDataChange(t);else if(r instanceof o)a=r.getParent().getId(),this.mContainers[a]&&this.mContainers[a][1]&&this.mContainers[a][1].onLayoutDataChange(t);else{var s=r.getParent();if(s instanceof o&&(e=s.getParent(),a=e.getId(),n=s.getId(),this.mContainers[a]&&this.mContainers[a][2]&&this.mContainers[a][2][n])){if(this.mContainers[a][2][n][1]){var l=s.getFields();f.call(this,this.mContainers[a][2][n][1],l)}this.mContainers[a][2][n][0].onLayoutDataChange(t)}}},c.prototype.onsapup=function(t){this.onsapleft(t)},c.prototype.onsapdown=function(t){this.onsapright(t)},c.prototype.getContainerRenderedDomRef=function(t){if(this.getDomRef()){var e=t.getId();if(this.mContainers[e]){if(this.mContainers[e][0]){return this.mContainers[e][0].getDomRef()}if(this.mContainers[e][1]){return this.mContainers[e][1].getDomRef()}}}return null},c.prototype.getElementRenderedDomRef=function(t){if(this.getDomRef()){var e=t.getParent(),a=t.getId(),n=e.getId();if(this.mContainers[n]&&this.mContainers[n][2]){var i=this.mContainers[n][2];if(i[a]){return i[a][0].getDomRef()}}}return null},c});",
	"sap/ui/layout/form/ResponsiveLayoutRenderer.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"sap/ui/core/Renderer\",\"./FormLayoutRenderer\"],function(e,r){\"use strict\";var n=e.extend(r);return n.getMainClass=function(){return\"sapUiFormResLayout\"},n.renderContainers=function(e,r,n){for(var t=n.getFormContainers(),o=[],i=0,a=0;a<t.length;a++){var s=t[a];s.isVisible()&&(i++,o.push(s))}i>0&&(i>1?e.renderControl(r._mainRFLayout):r.mContainers[o[0].getId()][0]?e.renderControl(r.mContainers[o[0].getId()][0]):e.renderControl(r.mContainers[o[0].getId()][1]))},n},!0);",
	"sap/ui/layout/form/SimpleForm.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/core/Control\",\"./Form\",\"./FormContainer\",\"./FormElement\",\"./FormLayout\",\"sap/ui/base/ManagedObjectObserver\",\"sap/ui/layout/library\",\"sap/ui/core/ResizeHandler\",\"./SimpleFormRenderer\"],function(e,t,a,i,s,n,o,r,l,h){\"use strict\";function u(){var e=this.getAggregation(\"form\");e.getLayout()&&(this._bChangedByMe=!0,e.destroyLayout(),k.call(this),this._bChangedByMe=!1);var t;switch(this.getLayout()){case j.ResponsiveLayout:G&&x||this._bResponsiveLayoutRequested||(G=sap.ui.require(\"sap/ui/layout/form/ResponsiveLayout\"),x=sap.ui.require(\"sap/ui/layout/ResponsiveFlowLayoutData\"),G&&x||(sap.ui.require([\"sap/ui/layout/form/ResponsiveLayout\",\"sap/ui/layout/ResponsiveFlowLayoutData\"],g.bind(this)),this._bResponsiveLayoutRequested=!0)),G&&x&&(t=new G(this.getId()+\"--Layout\"));break;case j.GridLayout:V&&W&&z||this._bGridLayoutRequested||(V=sap.ui.require(\"sap/ui/layout/form/GridLayout\"),W=sap.ui.require(\"sap/ui/layout/form/GridContainerData\"),z=sap.ui.require(\"sap/ui/layout/form/GridElementData\"),V&&W&&z||(sap.ui.require([\"sap/ui/layout/form/GridLayout\",\"sap/ui/layout/form/GridContainerData\",\"sap/ui/layout/form/GridElementData\"],d.bind(this)),this._bGridLayoutRequested=!0)),V&&W&&z&&(t=new V(this.getId()+\"--Layout\"));break;case j.ResponsiveGridLayout:q||this._bResponsiveGridLayoutRequested||(q=sap.ui.require(\"sap/ui/layout/form/ResponsiveGridLayout\"))||(sap.ui.require([\"sap/ui/layout/form/ResponsiveGridLayout\"],p.bind(this)),this._bResponsiveGridLayoutRequested=!0),q&&(t=new q(this.getId()+\"--Layout\"))}return!!t&&(this._bChangedByMe=!0,e.setLayout(t),this._bChangedByMe=!1,!0)}function g(e,t){G=e,x=t,this._bResponsiveLayoutRequested=!1,y.call(this)}function d(e,t,a){V=e,W=t,z=a,this._bGridLayoutRequested=!1,y.call(this)}function p(e){q=e,this._bResponsiveGridLayoutRequested=!1,y.call(this)}function y(){this._bIsBeingDestroyed||(u.call(this),c.call(this),this.getDomRef()&&f.call(this))}function m(){this._bChangedByMe=!0;for(var e=this.getAggregation(\"form\"),t=e.getFormContainers(),a=0;a<t.length;a++){var i=t[a];I(this._changedFormContainers,i),i.getLayoutData()&&i.destroyLayoutData();for(var s=i.getFormElements(),n=0;n<s.length;n++){var o=s[n];I(this._changedFormElements,o),o.getLayoutData()&&o.destroyLayoutData();var r=o.getLabel();r&&E.call(this,r);for(var l=o.getFields(),h=0;h<l.length;h++){var u=l[h];E.call(this,u)}}}this._bChangedByMe=!1}function c(){this._bChangedByMe=!0;for(var e=this.getAggregation(\"form\"),t=e.getFormContainers(),a=0;a<t.length;a++){var i=t[a];I(this._changedFormContainers,i),M.call(this,i);for(var s=i.getFormElements(),n=0;n<s.length;n++){var o=s[n];I(this._changedFormElements,o),F.call(this,o);var r=o.getLabel();r&&C.call(this,r,this._iLabelWeight,!1,!0,this.getLabelMinWidth());for(var l=o.getFields(),h=0;h<l.length;h++){var u=l[h];C.call(this,u,5,!1,!0)}}}this._bChangedByMe=!1}function f(){this._bChangedByMe=!0,this._changedFormContainers=[];var e=this.getLayout(),t=this.getAggregation(\"form\").getLayout();switch(t.setBackgroundDesign(this.getBackgroundDesign()),e){case j.ResponsiveLayout:this._applyLinebreaks();for(var a=0;a<this._changedFormElements.length;a++){var i=this._changedFormElements[a];O.call(this,i)}break;case j.GridLayout:T.call(this);break;case j.ResponsiveGridLayout:t.setLabelSpanXL(this.getLabelSpanXL()),t.setLabelSpanL(this.getLabelSpanL()),t.setLabelSpanM(this.getLabelSpanM()),t.setLabelSpanS(this.getLabelSpanS()),t.setAdjustLabelSpan(this.getAdjustLabelSpan()),t.setEmptySpanXL(this.getEmptySpanXL()),t.setEmptySpanL(this.getEmptySpanL()),t.setEmptySpanM(this.getEmptySpanM()),t.setEmptySpanS(this.getEmptySpanS()),t.setColumnsXL(this.getColumnsXL()),t.setColumnsL(this.getColumnsL()),t.setColumnsM(this.getColumnsM()),t.setSingleContainerFullSize(this.getSingleContainerFullSize()),t.setBreakpointXL(this.getBreakpointXL()),t.setBreakpointL(this.getBreakpointL()),t.setBreakpointM(this.getBreakpointM())}this._changedFormElements=[],this._bChangedByMe=!1}function b(e){var t=e.getId();return(\" \"+this._aLayouts.join(\" \")+\" \").indexOf(\" \"+t+\" \")>-1}function L(e,t,a,i){var s=new x({weight:e,linebreak:!0===t,linebreakable:!0===a});return i&&s.setMinWidth(i),this._aLayouts.push(s.getId()),s}function v(e){var t;switch(this.getLayout()){case j.ResponsiveLayout:t=n.prototype.getLayoutDataForElement(e,\"sap/ui/layout/ResponsiveFlowLayoutData\");break;case j.GridLayout:t=n.prototype.getLayoutDataForElement(e,\"sap/ui/layout/form/GridElementData\");break;case j.ResponsiveGridLayout:t=n.prototype.getLayoutDataForElement(e,\"sap/ui/layout/GridData\")}return t}function _(){if(this._bResponsiveLayoutRequested||this._bGridLayoutRequested||this._bResponsiveGridLayoutRequested)return!1;if(!this.getAggregation(\"form\").getLayout()){var e=this._bChangedByMe,t=u.call(this);if(this._bChangedByMe=e,!t)return!1}return!0}function C(t,a,i,s,n){if(this.getLayout()==j.ResponsiveLayout&&_.call(this)){this._bLayoutDataChangedByMe=!0;var o=v.call(this,t);o&&b.call(this,o)||(o=t.getLayoutData(),P(o,\"sap/ui/core/VariantLayoutData\")?o.addMultipleLayoutData(L.call(this,a,i,s,n)):o?e.sap.log.warning(\"ResponsiveFlowLayoutData can not be set on Field \"+t.getId(),\"_createFieldLayoutData\",\"SimpleForm\"):t.setLayoutData(L.call(this,a,i,s,n))),this._bLayoutDataChangedByMe=!1}}function F(e){this.getLayout()==j.ResponsiveLayout&&_.call(this)&&(this._bLayoutDataChangedByMe=!0,e.setLayoutData(new x({linebreak:!0,margin:!1})),this._bLayoutDataChangedByMe=!1)}function M(e){var t=this.getLayout();if((t==j.ResponsiveLayout||t==j.GridLayout)&&_.call(this)){switch(this._bLayoutDataChangedByMe=!0,t){case j.ResponsiveLayout:e.setLayoutData(new x({minWidth:280}));break;case j.GridLayout:this.getMaxContainerCols()>1?e.setLayoutData(new W({halfGrid:!0})):e.setLayoutData(new W({halfGrid:!1}))}this._bLayoutDataChangedByMe=!1}}function E(e){this._bLayoutDataChangedByMe=!0;var t=v.call(this,e);if(t)for(var a=t.getId(),i=0;i<this._aLayouts.length;i++){var s=this._aLayouts[i];if(a==s){t.destroy(),this._aLayouts.splice(i,1);break}}this._bLayoutDataChangedByMe=!1}function D(e,t){var a=R.call(this,t);return e.addFormElement(a),a}function B(e,t,a){var i=R.call(this,t);return e.insertFormElement(i,a),i}function R(e){var t=new s;return F.call(this,t),e&&(e.addStyleClass(\"sapUiFormLabel-CTX\"),t.setLabel(e),v.call(this,e)||C.call(this,e,this._iLabelWeight,!1,!0,this.getLabelMinWidth())),t.isVisible=function(){for(var e=this.getFields(),t=!1,a=0;a<e.length;a++){if(e[a].getVisible()){t=!0;break}}return t},t}function S(e){var t=new i;return M.call(this,t),t.getAriaLabelledBy=function(){var e=this.getToolbar();return e?e.getAriaLabelledBy():[]},e&&(P(e,\"sap/ui/core/Title\")?t.setTitle(e):e.getMetadata().isInstanceOf(\"sap.ui.core.Toolbar\")&&t.setToolbar(e)),t}function O(e){var t,a,i=this._iMaxWeight,s=e.getFields(),n=s.length,o=e.getLabel(),r=0;for(this._bLayoutDataChangedByMe=!0,o&&v.call(this,o)&&(i-=v.call(this,o).getWeight()),r=0;r<s.length;r++)t=s[r],a=v.call(this,t),P(a,\"sap/ui/layout/ResponsiveFlowLayoutData\")&&!b.call(this,a)&&(i-=a.getWeight(),n--);var l=Math.floor(i/n),h=i%n;for(r=0;r<s.length;r++){t=s[r],a=v.call(this,t);var u=l;a?b.call(this,a)&&P(a,\"sap/ui/layout/ResponsiveFlowLayoutData\")&&(h>0&&(u++,h--),a.setWeight(u)):C.call(this,t,u,!1,0==r)}this._bLayoutDataChangedByMe=!1}function T(){this._bLayoutDataChangedByMe=!0;for(var e=this.getAggregation(\"form\"),t=e.getFormContainers(),a=t.length,i=0;i<a;i++){var s=t[i];this.getMaxContainerCols()<=1||i==a-1&&a%2>0?s.getLayoutData().setHalfGrid(!1):s.getLayoutData().getHalfGrid()||s.getLayoutData().setHalfGrid(!0)}this._bLayoutDataChangedByMe=!1}function k(){this._sResizeListenerId&&(l.deregister(this._sResizeListenerId),this._sResizeListenerId=null)}function I(e,t){for(var a=!1,i=0;i<e.length;i++){if(e[i]==t){a=!0;break}}a||e.push(t)}function w(e){if(\"visible\"==e.name){e.object.getParent().invalidate()}}function A(e){for(var t=[],a=e.getFormContainers(),i=0;i<a.length;i++){var s=a[i],n=s.getTitle();if(n)t.push(n);else{var o=s.getToolbar();o&&t.push(o)}for(var r=s.getFormElements(),l=0;l<r.length;l++){var h=r[l],u=h.getLabel();u&&t.push(u);for(var g=h.getFields(),d=0;d<g.length;d++){var p=g[d];t.push(p)}}}return t}function P(e,t){var a=sap.ui.require(t);return e&&\"function\"==typeof a&&e instanceof a}var G,x,q,V,W,z,X=r.BackgroundDesign,j=r.form.SimpleFormLayout,H=t.extend(\"sap.ui.layout.form.SimpleForm\",{metadata:{library:\"sap.ui.layout\",properties:{maxContainerCols:{type:\"int\",group:\"Appearance\",defaultValue:2},minWidth:{type:\"int\",group:\"Appearance\",defaultValue:-1},width:{type:\"sap.ui.core.CSSSize\",group:\"Dimension\",defaultValue:null},editable:{type:\"boolean\",group:\"Misc\",defaultValue:null},labelMinWidth:{type:\"int\",group:\"Misc\",defaultValue:192},layout:{type:\"sap.ui.layout.form.SimpleFormLayout\",group:\"Misc\",defaultValue:j.ResponsiveLayout},labelSpanXL:{type:\"int\",group:\"Misc\",defaultValue:-1},labelSpanL:{type:\"int\",group:\"Misc\",defaultValue:4},labelSpanM:{type:\"int\",group:\"Misc\",defaultValue:2},labelSpanS:{type:\"int\",group:\"Misc\",defaultValue:12},adjustLabelSpan:{type:\"boolean\",group:\"Misc\",defaultValue:!0},emptySpanXL:{type:\"int\",group:\"Misc\",defaultValue:-1},emptySpanL:{type:\"int\",group:\"Misc\",defaultValue:0},emptySpanM:{type:\"int\",group:\"Misc\",defaultValue:0},emptySpanS:{type:\"int\",group:\"Misc\",defaultValue:0},columnsXL:{type:\"int\",group:\"Misc\",defaultValue:-1},columnsL:{type:\"int\",group:\"Misc\",defaultValue:2},columnsM:{type:\"int\",group:\"Misc\",defaultValue:1},singleContainerFullSize:{type:\"boolean\",group:\"Misc\",defaultValue:!0},breakpointXL:{type:\"int\",group:\"Misc\",defaultValue:1440},breakpointL:{type:\"int\",group:\"Misc\",defaultValue:1024},breakpointM:{type:\"int\",group:\"Misc\",defaultValue:600},backgroundDesign:{type:\"sap.ui.layout.BackgroundDesign\",group:\"Appearance\",defaultValue:X.Translucent}},defaultAggregation:\"content\",aggregations:{content:{type:\"sap.ui.core.Element\",multiple:!0,singularName:\"content\"},form:{type:\"sap.ui.layout.form.Form\",multiple:!1,visibility:\"hidden\"},title:{type:\"sap.ui.core.Title\",altTypes:[\"string\"],multiple:!1},toolbar:{type:\"sap.ui.core.Toolbar\",multiple:!1}},associations:{ariaLabelledBy:{type:\"sap.ui.core.Control\",multiple:!0,singularName:\"ariaLabelledBy\"}},designtime:\"sap/ui/layout/designtime/form/SimpleForm.designtime\"}});return H.prototype.init=function(){this._iMaxWeight=8,this._iLabelWeight=3,this._iCurrentWidth=0;var e=new a(this.getId()+\"--Form\");e.getTitle=function(){return this.getParent().getTitle()},e._origInvalidate=e.invalidate,e.invalidate=function(e){if(this.bOutput&&this._origInvalidate(e),!this._bIsBeingDestroyed){var t=this.getParent();t&&t._formInvalidated(e)}},e.getAriaLabelledBy=function(){var e=this.getParent();return e?e.getAriaLabelledBy():null},e._origOnLayoutDataChange=e.onLayoutDataChange,e.onLayoutDataChange=function(e){this._origOnLayoutDataChange(e);var t=this.getParent();t&&t._onLayoutDataChange(e)},this.setAggregation(\"form\",e),this._aElements=null,this._aLayouts=[],this._changedFormContainers=[],this._changedFormElements=[],this._oObserver=new o(w.bind(this))},H.prototype.exit=function(){var e=this.getAggregation(\"form\");e.invalidate=e._origInvalidate,k.call(this);for(var t=0;t<this._aLayouts.length;t++){var a=sap.ui.getCore().byId(this._aLayouts[t]);a&&a.destroy&&a.destroy()}this._aLayouts=[],this._aElements=null,this._changedFormContainers=[],this._changedFormElements=[],this._oObserver.disconnect(),this._oObserver=void 0},H.prototype.onBeforeRendering=function(){k.call(this);var e=this.getAggregation(\"form\");if(!this._bResponsiveLayoutRequested&&!this._bGridLayoutRequested&&!this._bResponsiveGridLayoutRequested){var t=!0;e.getLayout()||(t=u.call(this)),t&&f.call(this)}},H.prototype.onAfterRendering=function(){this.getLayout()==j.ResponsiveLayout&&(this._bChangedByMe=!0,this.$().css(\"visibility\",\"hidden\"),this._applyLinebreaks(),this._sResizeListenerId=l.register(this.getDomRef(),e.proxy(this._resize,this)),this._bChangedByMe=!1)},H.prototype.setEditable=function(e){return this._bChangedByMe=!0,this.setProperty(\"editable\",e,!0),this.getAggregation(\"form\").setEditable(e),this._bChangedByMe=!1,this},H.prototype.setToolbar=function(e){return this._bChangedByMe=!0,this.getAggregation(\"form\").setToolbar(e),this._bChangedByMe=!1,this},H.prototype.getToolbar=function(){return this.getAggregation(\"form\").getToolbar()},H.prototype.destroyToolbar=function(){return this._bChangedByMe=!0,this.getAggregation(\"form\").destroyToolbar(),this._bChangedByMe=!1,this},H.prototype.setLabelMinWidth=function(e){if(this.setProperty(\"labelMinWidth\",e,!0),this.getLayout()==j.ResponsiveLayout){this._bLayoutDataChangedByMe=!0;for(var t=this.getContent(),a=0;a<t.length;a++){var i=t[a];if(i.getMetadata().isInstanceOf(\"sap.ui.core.Label\")){var s=v.call(this,i);P(s,\"sap/ui/layout/ResponsiveFlowLayoutData\")&&b.call(this,s)&&s.setMinWidth(e)}}this._bLayoutDataChangedByMe=!1}return this},H.prototype.indexOfContent=function(e){var t=this._aElements;if(t)for(var a=0;a<t.length;a++)if(t[a]==e)return a;return-1},H.prototype.addContent=function(t){t=this.validateAggregation(\"content\",t,!0),this.indexOfContent(t)>=0&&(e.sap.log.warning(\"SimpleForm.addContent: Content element '\"+t+\"' already assigned. Please remove before adding!\",this),this.removeContent(t)),this._aElements||(this._aElements=[]),this._bChangedByMe=!0;var a,n,o,r,l,h=this._aElements.length,u=this.getAggregation(\"form\");return P(t,\"sap/ui/core/Title\")||t.getMetadata().isInstanceOf(\"sap.ui.core.Toolbar\")?(n=S.call(this,t),u.addFormContainer(n),this._changedFormContainers.push(n)):t.getMetadata().isInstanceOf(\"sap.ui.core.Label\")?(h>0&&(a=this._aElements[h-1],r=a.getParent(),r instanceof s?n=r.getParent():r instanceof i&&(n=r)),n||(n=S.call(this),u.addFormContainer(n),this._changedFormContainers.push(n)),o=D.call(this,n,t)):(h>0?(a=this._aElements[h-1],r=a.getParent(),r instanceof s?(n=r.getParent(),o=r,l=v.call(this,t),P(l,\"sap/ui/layout/ResponsiveFlowLayoutData\")&&!b.call(this,l)&&l.getLinebreak()&&(o=D.call(this,n))):r instanceof i&&(n=r,o=D.call(this,n))):(n=S.call(this),u.addFormContainer(n),this._changedFormContainers.push(n),o=D.call(this,n)),C.call(this,t,5,!1,!0),o.addField(t),I(this._changedFormElements,o)),this._aElements.push(t),this._oObserver.observe(t,{properties:[\"visible\"]}),this.invalidate(),this._bChangedByMe=!1,this},H.prototype.insertContent=function(t,a){t=this.validateAggregation(\"content\",t,!0),this.indexOfContent(t)>=0&&(e.sap.log.warning(\"SimpleForm.insertContent: Content element '\"+t+\"' already assigned. Please remove before insert!\",this),this.removeContent(t)),this._aElements||(this._aElements=[]);var i,s=this._aElements.length;if(i=a<0?0:a>s?s:a,i!==a&&e.sap.log.warning(\"SimpleForm.insertContent: index '\"+a+\"' out of range [0,\"+s+\"], forced to \"+i),i==s)return this.addContent(t),this;this._bChangedByMe=!0;var n,o,r,l,h,u,g,d,p,y,m,c=this._aElements[i],f=this.getAggregation(\"form\"),L=0,_=0;if(P(t,\"sap/ui/core/Title\")||t.getMetadata().isInstanceOf(\"sap.ui.core.Toolbar\")){if(0!=a||P(c,\"sap/ui/core/Title\")||c.getMetadata().isInstanceOf(\"sap.ui.core.Toolbar\")){if(n=S.call(this,t),P(c,\"sap/ui/core/Title\")||c.getMetadata().isInstanceOf(\"sap.ui.core.Toolbar\"))r=c.getParent(),h=f.indexOfFormContainer(r);else{if(l=c.getParent(),r=l.getParent(),h=f.indexOfFormContainer(r)+1,L=r.indexOfFormElement(l),!c.getMetadata().isInstanceOf(\"sap.ui.core.Label\")&&((u=l.indexOfField(c))>0||l.getLabel())){for(o=D.call(this,n),this._changedFormElements.push(o),I(this._changedFormElements,l),g=l.getFields(),_=u;_<g.length;_++)y=g[_],o.addField(y);L++}for(d=r.getFormElements(),_=L;_<d.length;_++)n.addFormElement(d[_])}f.insertFormContainer(n,h)}else n=c.getParent().getParent(),P(t,\"sap/ui/core/Title\")?n.setTitle(t):n.setToolbar(t);this._changedFormContainers.push(n)}else if(t.getMetadata().isInstanceOf(\"sap.ui.core.Label\")){if(P(c,\"sap/ui/core/Title\")||c.getMetadata().isInstanceOf(\"sap.ui.core.Toolbar\"))r=c.getParent(),h=f.indexOfFormContainer(r),p=f.getFormContainers(),0==h?(n=S.call(this),f.insertFormContainer(n,h),this._changedFormContainers.push(n)):n=p[h-1],o=D.call(this,n,t);else if(c.getMetadata().isInstanceOf(\"sap.ui.core.Label\"))r=c.getParent().getParent(),L=r.indexOfFormElement(c.getParent()),o=B.call(this,r,t,L);else if(l=c.getParent(),r=l.getParent(),L=r.indexOfFormElement(l)+1,0!=(u=l.indexOfField(c))||l.getLabel())for(o=B.call(this,r,t,L),I(this._changedFormElements,l),g=l.getFields(),_=u;_<g.length;_++)y=g[_],o.addField(y);else o=l,o.setLabel(t),C.call(this,t,this._iLabelWeight,!1,!0,this.getLabelMinWidth());this._changedFormElements.push(o)}else{if(m=v.call(this,t),P(c,\"sap/ui/core/Title\")||c.getMetadata().isInstanceOf(\"sap.ui.core.Toolbar\"))r=c.getParent(),h=f.indexOfFormContainer(r),0==h?(n=S.call(this),f.insertFormContainer(n,h),this._changedFormContainers.push(n)):(p=f.getFormContainers(),n=p[h-1]),d=n.getFormElements(),o=0==d.length?D.call(this,n):P(m,\"sap/ui/layout/ResponsiveFlowLayoutData\")&&!b.call(this,m)&&m.getLinebreak()?D.call(this,n):d[d.length-1],o.addField(t);else if(c.getMetadata().isInstanceOf(\"sap.ui.core.Label\"))l=c.getParent(),n=l.getParent(),L=n.indexOfFormElement(l),0==L?o=B.call(this,n,null,0):P(m,\"sap/ui/layout/ResponsiveFlowLayoutData\")&&!b.call(this,m)&&m.getLinebreak()?o=B.call(this,n,null,L):(d=n.getFormElements(),o=d[L-1]),o.addField(t);else if(o=c.getParent(),u=o.indexOfField(c),P(m,\"sap/ui/layout/ResponsiveFlowLayoutData\")&&!b.call(this,m)&&m.getLinebreak()&&u>0)for(n=o.getParent(),L=n.indexOfFormElement(o),I(this._changedFormElements,o),g=o.getFields(),o=B.call(this,n,void 0,L+1),o.addField(t),_=u;_<g.length;_++)y=g[_],o.addField(y);else o.insertField(t,u);I(this._changedFormElements,o),C.call(this,t,5,!1,!0)}return this._aElements.splice(i,0,t),this._oObserver.observe(t,{properties:[\"visible\"]}),this.invalidate(),this._bChangedByMe=!1,this},H.prototype.removeContent=function(t){var a=null,i=-1,s=0;if(this._aElements){if(\"string\"==typeof t&&(t=sap.ui.getCore().byId(t)),\"object\"==typeof t)for(s=0;s<this._aElements.length;s++)if(this._aElements[s]==t){t=s;break}\"number\"==typeof t&&(t<0||t>=this._aElements.length?e.sap.log.warning(\"Element.removeAggregation called with invalid index: Items, \"+t):(i=t,a=this._aElements[i]))}if(a){this._bChangedByMe=!0;var n,o,r,l,h=this.getAggregation(\"form\");if(P(a,\"sap/ui/core/Title\")||a.getMetadata().isInstanceOf(\"sap.ui.core.Toolbar\"))if(n=a.getParent(),n.setTitle(null),n.setToolbar(null),i>0){r=n.getFormElements();var u=h.indexOfFormContainer(n),g=h.getFormContainers()[u-1];if(r.length>0&&!r[0].getLabel()){var d=g.getFormElements(),p=d[d.length-1];for(l=r[0].getFields(),s=0;s<l.length;s++)p.addField(l[s]);I(this._changedFormElements,p),n.removeFormElement(r[0]),r[0].destroy(),r.splice(0,1)}for(s=0;s<r.length;s++)g.addFormElement(r[s]);I(this._changedFormContainers,g),h.removeFormContainer(n),n.destroy()}else 0==n.getFormElements().length&&(h.removeFormContainer(n),n.destroy());else if(a.getMetadata().isInstanceOf(\"sap.ui.core.Label\")){o=a.getParent(),n=o.getParent(),o.setLabel(null);var y=n.indexOfFormElement(o);if(0==y)0==o.getFields().length?(n.removeFormElement(o),o.destroy(),0!=n.getFormElements().length||n.getTitle()||n.getToolbar()||(h.removeFormContainer(n),n.destroy())):I(this._changedFormElements,o);else{r=n.getFormElements();var m=r[y-1];for(l=o.getFields(),s=0;s<l.length;s++)m.addField(l[s]);I(this._changedFormElements,m),n.removeFormElement(o),o.destroy()}}else o=a.getParent(),o.removeField(a),0!=o.getFields().length||o.getLabel()?I(this._changedFormElements,o):(n=o.getParent(),n.removeFormElement(o),o.destroy(),0!=n.getFormElements().length||n.getTitle()||n.getToolbar()||(h.removeFormContainer(n),n.destroy()));return this._aElements.splice(i,1),a.setParent(null),this._oObserver.unobserve(a),E.call(this,a),this.invalidate(),this._bChangedByMe=!1,a}return null},H.prototype.removeAllContent=function(){var e=0;if(this._aElements){this._bChangedByMe=!0;var t=this.getAggregation(\"form\"),a=t.getFormContainers();for(e=0;e<a.length;e++){var i=a[e];i.setTitle(null),i.setToolbar(null);for(var s=i.getFormElements(),n=0;n<s.length;n++){var o=s[n];o.setLabel(null),o.removeAllFields()}i.destroyFormElements()}for(t.destroyFormContainers(),e=0;e<this._aElements.length;e++){var r=this._aElements[e];E.call(this,r),this._oObserver.unobserve(r)}var l=this._aElements;return this._aElements=null,this.invalidate(),this._bChangedByMe=!1,l}return[]},H.prototype.destroyContent=function(){var e=this.removeAllContent();if(e){this._bChangedByMe=!0;for(var t=0;t<e.length;t++)e[t].destroy();this.invalidate(),this._bChangedByMe=!1}return this},H.prototype.getContent=function(){return this._aElements||(this._aElements=this.getAggregation(\"content\",[])),this._aElements.slice()},H.prototype.setLayout=function(e){var t=this.getLayout();if(e!=t&&m.call(this),this.setProperty(\"layout\",e),e!=t){u.call(this)&&c.call(this)}return this},H.prototype.clone=function(e){this._bChangedByMe=!0;for(var a=t.prototype.clone.apply(this,arguments),i=this.getContent(),s=0;s<i.length;s++){var n=i[s],o=n.getLayoutData();this._oObserver.unobserve(n);var r=n.clone(e);if(this._oObserver.observe(n,{properties:[\"visible\"]}),o)if(P(o,\"sap/ui/core/VariantLayoutData\"))for(var l=o.getMultipleLayoutData(),h=0;h<l.length;h++)b.call(this,l[h])&&a._aLayouts.push(r.getLayoutData().getMultipleLayoutData()[h].getId());else b.call(this,o)&&a._aLayouts.push(r.getLayoutData().getId());a.addContent(r)}return this._bChangedByMe=!1,a},H.prototype._applyLinebreaks=function(){if(G&&!this._bResponsiveLayoutRequested){this._bLayoutDataChangedByMe=!0;for(var e=this.getAggregation(\"form\"),t=e.getFormContainers(),a=this.getDomRef(),i=this.$(),s=1;s<t.length;s++){var n=t[s],o=n.getLayoutData();!a||i.outerWidth(!0)>this.getMinWidth()?s%this.getMaxContainerCols()==0?o.setLinebreak(!0):o.setLinebreak(!1):o.setLinebreak(!0)}if(a&&\"hidden\"==i.css(\"visibility\")){var r=this;setTimeout(function(){r.getDomRef()&&r.$().css(\"visibility\",\"\")},10)}this._bLayoutDataChangedByMe=!1}},H.prototype._resize=function(e){this._bChangedByMe=!0,this._iCurrentWidth!=e.size.width&&(this._iCurrentWidth=e.size.width,this._applyLinebreaks(),this._bChangedByMe=!1)},H.prototype._formInvalidated=function(e){if(!this._bChangedByMe){var t=A(this.getAggregation(\"form\")),a=0,i=0,s=!1;if(!this._aElements||t.length<this._aElements.length)s=!0;else for(a=0;a<t.length;a++){var n=t[a],o=this._aElements[i];if(n!==o){var r=t[a+1];if(r===o){this.insertContent(n,a);break}if((r=this._aElements[i+1])===n){s=!0;break}break}i++}if(s)for(this.removeAllContent(),a=0;a<t.length;a++){var l=t[a];this.addContent(l)}}},H.prototype._onLayoutDataChange=function(e){if(!this._bLayoutDataChangedByMe&&!this._bIsBeingDestroyed)switch(this.getLayout()){case j.ResponsiveLayout:var t=e.srcControl;if(t.getParent()instanceof s){var a=this.indexOfContent(t);this.removeContent(t),this.insertContent(t,a)}}},H});",
	"sap/ui/layout/form/SimpleFormRenderer.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([],function(){\"use strict\";var e={};return e.render=function(e,t){t._bChangedByMe=!0,e.write(\"<div\"),e.writeControlData(t),e.addClass(\"sapUiSimpleForm\"),t.getWidth()&&e.addStyle(\"width\",t.getWidth()),e.writeStyles(),e.writeClasses(),e.write(\">\");var r=t.getAggregation(\"form\");e.renderControl(r),e.write(\"</div>\"),t._bChangedByMe=!1},e},!0);",
	"sap/ui/layout/Grid.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/core/Control\",\"./library\",\"sap/ui/Device\",\"sap/ui/core/ResizeHandler\",\"sap/ui/base/ManagedObjectObserver\",\"./GridRenderer\"],function(e,t,i,a,s,n,o){\"use strict\";var r=t.extend(\"sap.ui.layout.Grid\",{metadata:{library:\"sap.ui.layout\",properties:{width:{type:\"sap.ui.core.CSSSize\",group:\"Dimension\",defaultValue:\"100%\"},vSpacing:{type:\"float\",group:\"Dimension\",defaultValue:1},hSpacing:{type:\"float\",group:\"Dimension\",defaultValue:1},position:{type:\"sap.ui.layout.GridPosition\",group:\"Dimension\",defaultValue:\"Left\"},defaultSpan:{type:\"sap.ui.layout.GridSpan\",group:\"Behavior\",defaultValue:\"XL3 L3 M6 S12\"},defaultIndent:{type:\"sap.ui.layout.GridIndent\",group:\"Behavior\",defaultValue:\"XL0 L0 M0 S0\"},containerQuery:{type:\"boolean\",group:\"Behavior\",defaultValue:!1}},defaultAggregation:\"content\",aggregations:{content:{type:\"sap.ui.core.Control\",multiple:!0,singularName:\"content\"}},associations:{ariaLabelledBy:{type:\"sap.ui.core.Control\",multiple:!0,singularName:\"ariaLabelledBy\"}},designtime:\"sap/ui/layout/designtime/Grid.designtime\"}});return function(){r.prototype.init=function(){this._iBreakPointTablet=a.media._predefinedRangeSets[a.media.RANGESETS.SAP_STANDARD_EXTENDED].points[0],this._iBreakPointDesktop=a.media._predefinedRangeSets[a.media.RANGESETS.SAP_STANDARD_EXTENDED].points[1],this._iBreakPointLargeDesktop=a.media._predefinedRangeSets[a.media.RANGESETS.SAP_STANDARD_EXTENDED].points[2],this._indentXLChanged=!1,this._spanXLChanged=!1,this._oObserver=new n(r.prototype._observeChanges.bind(this)),this._oObserver.observe(this,{aggregations:[\"content\"]})},r.prototype.onAfterRendering=function(){this.getContainerQuery()?(this._sContainerResizeListener=s.register(this,e.proxy(this._onParentResize,this)),this._onParentResize()):this._attachMediaContainerWidthChange(this._handleMediaChange,this,a.media.RANGESETS.SAP_STANDARD_EXTENDED)},r.prototype.onBeforeRendering=function(){this._cleanup()},r.prototype.exit=function(){this._cleanup(),this._oObserver&&(this._oObserver.disconnect(),this._oObserver=null)},r.prototype._cleanup=function(){this._sContainerResizeListener&&(s.deregister(this._sContainerResizeListener),this._sContainerResizeListener=null),this._detachMediaContainerWidthChange(this._handleMediaChange,this,a.media.RANGESETS.SAP_STANDARD_EXTENDED)},r.prototype._observeVisibility=function(e){this._oObserver.observe(e,{properties:[\"visible\"]})},r.prototype._unobserveVisibility=function(e){this._oObserver.unobserve(e,{properties:[\"visible\"]})},r.prototype._observeChanges=function(t){var i=t.object,a=t.name,s=t.mutation,n=t.child;if(i===this)\"insert\"===s?this._observeVisibility(n):\"remove\"===s&&this._unobserveVisibility(n);else if(\"visible\"===a){var o=this.getContent().indexOf(i);e(this.$().children()[o]).toggleClass(\"sapUiRespGridSpanInvisible\",!t.current)}},r.prototype._handleMediaChange=function(e){this._toggleClass(e.name)},r.prototype._setBreakPointTablet=function(e){this._iBreakPointTablet=e},r.prototype._setBreakPointDesktop=function(e){this._iBreakPointDesktop=e},r.prototype._setBreakPointLargeDesktop=function(e){this._iBreakPointLargeDesktop=e},r.prototype.setDefaultIndent=function(e){return/XL/gi.test(e)&&this._setIndentXLChanged(!0),this.setProperty(\"defaultIndent\",e)},r.prototype._setIndentXLChanged=function(e){this._indentXLChanged=e},r.prototype._getIndentXLChanged=function(){return this._indentXLChanged},r.prototype.setDefaultSpan=function(e){return/XL/gi.test(e)&&this._setSpanXLChanged(!0),this.setProperty(\"defaultSpan\",e)},r.prototype._setSpanXLChanged=function(e){this._spanXLChanged=e},r.prototype._getSpanXLChanged=function(){return this._spanXLChanged},r.prototype._onParentResize=function(){var t=this.getDomRef();if(!t)return void this._cleanup();if(e(t).is(\":visible\")){var i=t.clientWidth;i<=this._iBreakPointTablet?this._toggleClass(\"Phone\"):i>this._iBreakPointTablet&&i<=this._iBreakPointDesktop?this._toggleClass(\"Tablet\"):i>this._iBreakPointDesktop&&i<=this._iBreakPointLargeDesktop?this._toggleClass(\"Desktop\"):this._toggleClass(\"LargeDesktop\")}},r.prototype._toggleClass=function(e){var t=this.$();t&&(t.hasClass(\"sapUiRespGridMedia-Std-\"+e)||(t.toggleClass(\"sapUiRespGridMedia-Std-\"+e,!0),\"Phone\"===e?t.toggleClass(\"sapUiRespGridMedia-Std-Desktop\",!1).toggleClass(\"sapUiRespGridMedia-Std-Tablet\",!1).toggleClass(\"sapUiRespGridMedia-Std-LargeDesktop\",!1):\"Tablet\"===e?t.toggleClass(\"sapUiRespGridMedia-Std-Desktop\",!1).toggleClass(\"sapUiRespGridMedia-Std-Phone\",!1).toggleClass(\"sapUiRespGridMedia-Std-LargeDesktop\",!1):\"LargeDesktop\"===e?t.toggleClass(\"sapUiRespGridMedia-Std-Desktop\",!1).toggleClass(\"sapUiRespGridMedia-Std-Phone\",!1).toggleClass(\"sapUiRespGridMedia-Std-Tablet\",!1):t.toggleClass(\"sapUiRespGridMedia-Std-Phone\",!1).toggleClass(\"sapUiRespGridMedia-Std-Tablet\",!1).toggleClass(\"sapUiRespGridMedia-Std-LargeDesktop\",!1),this.fireEvent(\"mediaChanged\",{media:e})))},r.prototype._getLayoutDataForControl=function(e){var t=e.getLayoutData();if(t){if(t instanceof sap.ui.layout.GridData)return t;if(\"sap.ui.core.VariantLayoutData\"==t.getMetadata().getName())for(var i=t.getMultipleLayoutData(),a=0;a<i.length;a++){var s=i[a];if(s instanceof sap.ui.layout.GridData)return s}}},r.prototype.onLayoutDataChange=function(e){this.getDomRef()&&this.invalidate()},r.prototype._getAccessibleRole=function(){return null},r.prototype.getAccessibilityInfo=function(){return{children:this.getContent().filter(function(e){return e.$().is(\":visible\")})}}}(),r});",
	"sap/ui/layout/GridData.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/core/LayoutData\",\"./library\"],function(e,t,n){\"use strict\";var a=t.extend(\"sap.ui.layout.GridData\",{metadata:{library:\"sap.ui.layout\",properties:{span:{type:\"sap.ui.layout.GridSpan\",group:\"Behavior\",defaultValue:null},spanXL:{type:\"int\",group:\"Behavior\",defaultValue:null},spanL:{type:\"int\",group:\"Behavior\",defaultValue:null},spanM:{type:\"int\",group:\"Behavior\",defaultValue:null},spanS:{type:\"int\",group:\"Behavior\",defaultValue:null},indent:{type:\"sap.ui.layout.GridIndent\",group:\"Behavior\",defaultValue:null},indentXL:{type:\"int\",group:\"Behavior\",defaultValue:null},indentL:{type:\"int\",group:\"Behavior\",defaultValue:null},indentM:{type:\"int\",group:\"Behavior\",defaultValue:null},indentS:{type:\"int\",group:\"Behavior\",defaultValue:null},visibleXL:{type:\"boolean\",group:\"Behavior\",defaultValue:!0},visibleL:{type:\"boolean\",group:\"Behavior\",defaultValue:!0},visibleM:{type:\"boolean\",group:\"Behavior\",defaultValue:!0},visibleS:{type:\"boolean\",group:\"Behavior\",defaultValue:!0},moveBackwards:{type:\"sap.ui.layout.GridIndent\",group:\"Misc\",defaultValue:null},moveForward:{type:\"sap.ui.layout.GridIndent\",group:\"Misc\",defaultValue:null},linebreak:{type:\"boolean\",group:\"Misc\",defaultValue:!1},linebreakXL:{type:\"boolean\",group:\"Misc\",defaultValue:!1},linebreakL:{type:\"boolean\",group:\"Misc\",defaultValue:!1},linebreakM:{type:\"boolean\",group:\"Misc\",defaultValue:!1},linebreakS:{type:\"boolean\",group:\"Misc\",defaultValue:!1},spanLarge:{type:\"int\",group:\"Behavior\",defaultValue:null,deprecated:!0},spanMedium:{type:\"int\",group:\"Behavior\",defaultValue:null,deprecated:!0},spanSmall:{type:\"int\",group:\"Behavior\",defaultValue:null,deprecated:!0},indentLarge:{type:\"int\",group:\"Behavior\",defaultValue:null,deprecated:!0},indentMedium:{type:\"int\",group:\"Behavior\",defaultValue:null,deprecated:!0},indentSmall:{type:\"int\",group:\"Behavior\",defaultValue:null,deprecated:!0},visibleOnLarge:{type:\"boolean\",group:\"Behavior\",defaultValue:!0,deprecated:!0},visibleOnMedium:{type:\"boolean\",group:\"Behavior\",defaultValue:!0,deprecated:!0},visibleOnSmall:{type:\"boolean\",group:\"Behavior\",defaultValue:!0,deprecated:!0}}}});return function(){a.prototype._setStylesInternal=function(e){e&&e.length>0?this._sStylesInternal=e:this._sStylesInternal=void 0},a.prototype._getEffectiveSpanXLarge=function(){var e=this.getSpanXL();if(e&&e>0&&e<13)return e;var t=/XL([1-9]|1[0-2])(?:\\s|$)/i,n=t.exec(this.getSpan());if(n){var a=n[0];if(a&&(a=a.toUpperCase(),\"XL\"===a.substr(0,2)))return parseInt(a.substr(2),10)}},a.prototype._getEffectiveSpanLarge=function(){var e=this.getSpanL();if(e&&e>0&&e<13)return e;var t=/\\bL([1-9]|1[0-2])(?:\\s|$)/i,n=t.exec(this.getSpan());if(n){var a=n[0];if(a&&(a=a.toUpperCase(),\"L\"===a.substr(0,1)))return parseInt(a.substr(1),10)}},a.prototype._getEffectiveSpanMedium=function(){var e=this.getSpanM();if(e&&e>0&&e<13)return e;var t=/M([1-9]|1[0-2])(?:\\s|$)/i,n=t.exec(this.getSpan());if(n){var a=n[0];if(a&&(a=a.toUpperCase(),\"M\"===a.substr(0,1)))return parseInt(a.substr(1),10)}},a.prototype._getEffectiveSpanSmall=function(){var e=this.getSpanS();if(e&&e>0&&e<13)return e;var t=/S([1-9]|1[0-2])(?:\\s|$)/i,n=t.exec(this.getSpan());if(n){var a=n[0];if(a&&(a=a.toUpperCase(),\"S\"===a.substr(0,1)))return parseInt(a.substr(1),10)}},a.prototype.init=function(){this._bLinebreakXLChanged=!1},a.prototype.setLinebreakXL=function(e){return this.setProperty(\"linebreakXL\",e),this._bLinebreakXLChanged=!0,this},a.prototype._getLinebreakXLChanged=function(){return this._bLinebreakXLChanged},a.prototype.setSpanLarge=function(t){return this.setSpanL(t),e.sap.log.warning(\"Deprecated property spanLarge is used, please use spanL instead.\"),this},a.prototype.setSpanMedium=function(t){return e.sap.log.warning(\"Deprecated property spanMedium is used, please use spanM instead.\"),this.setSpanM(t)},a.prototype.setSpanSmall=function(t){return e.sap.log.warning(\"Deprecated property spanSmall is used, please use spanS instead.\"),this.setSpanS(t)},a.prototype.setIndentLarge=function(t){return e.sap.log.warning(\"Deprecated property indentLarge is used, please use indentL instead.\"),this.setIndentL(t)},a.prototype.setIndentMedium=function(t){return e.sap.log.warning(\"Deprecated property indentMedium is used, please use indentM instead.\"),this.setIndentM(t)},a.prototype.setIndentSmall=function(t){return e.sap.log.warning(\"Deprecated property indentSmall is used, please use indentS instead.\"),this.setIndentS(t)},a.prototype.setVisibleOnLarge=function(t){return e.sap.log.warning(\"Deprecated property visibleOnLarge is used, please use visibleL instead.\"),this.setVisibleL(t)},a.prototype.setVisibleOnMedium=function(t){return e.sap.log.warning(\"Deprecated property visibleOnMedium is used, please use visibleM instead.\"),this.setVisibleM(t)},a.prototype.setVisibleOnSmall=function(t){return e.sap.log.warning(\"Deprecated property visibleOnSmall is used, please use visibleS instead.\"),this.setVisibleS(t)},a.prototype.getSpanLarge=function(){return e.sap.log.warning(\"Deprecated property spanLarge is used, please use spanL instead.\"),this.getSpanL()},a.prototype.getSpanMedium=function(){return e.sap.log.warning(\"Deprecated property spanMedium is used, please use spanM instead.\"),this.getSpanM()},a.prototype.getSpanSmall=function(){return e.sap.log.warning(\"Deprecated property spanSmall is used, please use spanS instead.\"),this.getSpanS()},a.prototype.getIndentLarge=function(){return e.sap.log.warning(\"Deprecated property indentLarge is used, please use indentL instead.\"),this.getIndentL()},a.prototype.getIndentMedium=function(){return e.sap.log.warning(\"Deprecated property indentMedium is used, please use indentM instead.\"),this.getIndentM()},a.prototype.getIndentSmall=function(){return e.sap.log.warning(\"Deprecated property indentSmall is used, please use indentS instead.\"),this.getIndentS()},a.prototype.getVisibleOnLarge=function(){return e.sap.log.warning(\"Deprecated property visibleOnLarge is used, please use visibleL instead.\"),this.getVisibleL()},a.prototype.getVisibleOnMedium=function(){return e.sap.log.warning(\"Deprecated property visibleOnMedium is used, please use visibleM instead.\"),this.getVisibleM()},a.prototype.getVisibleOnSmall=function(){return e.sap.log.warning(\"Deprecated property visibleOnSmall is used, please use visibleS instead.\"),this.getVisibleS()}}(),a},!0);",
	"sap/ui/layout/GridRenderer.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"sap/ui/Device\",\"sap/ui/layout/library\"],function(e,s){\"use strict\";var a=s.GridPosition,i={};return i.render=function(s,i){var r=/^([X][L](?:[0-9]|1[0-1]))? ?([L](?:[0-9]|1[0-1]))? ?([M](?:[0-9]|1[0-1]))? ?([S](?:[0-9]|1[0-1]))?$/i,d=/^([X][L](?:[1-9]|1[0-2]))? ?([L](?:[1-9]|1[0-2]))? ?([M](?:[1-9]|1[0-2]))? ?([S](?:[1-9]|1[0-2]))?$/i;s.write(\"<div\"),s.writeControlData(i),s.addClass(\"sapUiRespGrid\");var t=i._getCurrentMediaContainerRange(e.media.RANGESETS.SAP_STANDARD_EXTENDED).name;s.addClass(\"sapUiRespGridMedia-Std-\"+t);var p=i.getHSpacing();.5==p?p=\"05\":0!==p&&1!==p&&2!==p&&(p=1),s.addClass(\"sapUiRespGridHSpace\"+p);var n=i.getVSpacing();.5==n?n=\"05\":0!==n&&1!==n&&2!==n&&(n=1),s.addClass(\"sapUiRespGridVSpace\"+n);var l=i.getPosition();l&&(l=l.toUpperCase(),l===a.Center.toUpperCase()?s.addClass(\"sapUiRespGridPosCenter\"):l===a.Right.toUpperCase()&&s.addClass(\"sapUiRespGridPosRight\")),s.writeClasses();var C=i.getWidth();\"100%\"!==C&&\"auto\"!==C&&\"inherit\"!==C&&(C=0==p?\"width: \"+C:\"width: -webkit-calc(\"+C+\" - \"+p+\"rem); width: calc(\"+C+\" - \"+p+\"rem); \",s.writeAttribute(\"style\",C));var g,L=i._getAccessibleRole();L&&(g={role:L}),s.writeAccessibilityState(i,g),s.write(\">\");for(var o=i.getContent(),U=i.getDefaultSpan(),S=[\"\",\"XL3\",\"L3\",\"M6\",\"S12\"],v=[\"\",\"XL0\",\"L0\",\"M0\",\"S0\"],R=d.exec(U),G=i._getSpanXLChanged(),b=i._getIndentXLChanged(),u=i.getDefaultIndent(),X=r.exec(u),c=0;c<o.length;c++){s.write(\"<div\");var f=i._getLayoutDataForControl(o[c]),h=!1;if(o[c].getVisible()||s.addClass(\"sapUiRespGridSpanInvisible\"),f){var w=!1;!0===f.getLinebreak()?s.addClass(\"sapUiRespGridBreak\"):(!0===f.getLinebreakXL()&&(w=!0,s.addClass(\"sapUiRespGridBreakXL\")),!0===f.getLinebreakL()&&(w||f._getLinebreakXLChanged()||s.addClass(\"sapUiRespGridBreakXL\"),s.addClass(\"sapUiRespGridBreakL\")),!0===f.getLinebreakM()&&s.addClass(\"sapUiRespGridBreakM\"),!0===f.getLinebreakS()&&s.addClass(\"sapUiRespGridBreakS\"));var M,I,k=f.getSpan();if(k&&0!=!k.lenght?(M=d.exec(k),/XL/gi.test(k)&&(h=!0)):M=R,M){for(var _=1;_<M.length;_++){var D=M[_];D||(D=R[_])||(D=S[_]),\"L\"===D.substr(0,1)&&(I=D.substr(1,2));var B=f.getSpanXL(),x=f.getSpanL(),y=f.getSpanM(),A=f.getSpanS();D=D.toUpperCase(),\"XL\"===D.substr(0,2)&&B>0&&B<13?(s.addClass(\"sapUiRespGridSpanXL\"+B),h=!0):\"L\"===D.substr(0,1)&&x>0&&x<13?(s.addClass(\"sapUiRespGridSpanL\"+x),I=x):\"M\"===D.substr(0,1)&&y>0&&y<13?s.addClass(\"sapUiRespGridSpanM\"+y):\"S\"===D.substr(0,1)&&A>0&&A<13?s.addClass(\"sapUiRespGridSpanS\"+A):(\"XL\"!==D.substr(0,2)||G||h)&&s.addClass(\"sapUiRespGridSpan\"+D)}G||h||s.addClass(\"sapUiRespGridSpanXL\"+I)}var V,H,E=f.getIndent();E&&0!=E.length?(V=r.exec(E),/XL/gi.test(E)&&(b=!0)):V=X,V||(V=X)||(V=void 0);var P=f.getIndentXL(),m=f.getIndentL(),F=f.getIndentM(),N=f.getIndentS();if(V){for(var _=1;_<V.length;_++){var T=V[_];T||(T=X&&X[_]?X[_]:v[_]),T&&(T=T.toUpperCase(),\"L\"===T.substr(0,1)&&(H=T.substr(1,2)),\"XL\"===T.substr(0,2)&&P>0&&P<12?(s.addClass(\"sapUiRespGridIndentXL\"+P),b=!0):\"L\"===T.substr(0,1)&&m>0&&m<12?(s.addClass(\"sapUiRespGridIndentL\"+m),H=m):\"M\"===T.substr(0,1)&&F>0&&F<12?s.addClass(\"sapUiRespGridIndentM\"+F):\"S\"===T.substr(0,1)&&N>0&&N<12?s.addClass(\"sapUiRespGridIndentS\"+N):/^(XL0)? ?(L0)? ?(M0)? ?(S0)?$/.exec(T)||s.addClass(\"sapUiRespGridIndent\"+T))}b||H&&H>0&&s.addClass(\"sapUiRespGridIndentXL\"+H)}f.getVisibleXL()||s.addClass(\"sapUiRespGridHiddenXL\"),f.getVisibleL()||s.addClass(\"sapUiRespGridHiddenL\"),f.getVisibleM()||s.addClass(\"sapUiRespGridHiddenM\"),f.getVisibleS()||s.addClass(\"sapUiRespGridHiddenS\");var $=f.getMoveBackwards();if($&&$.length>0){var W=r.exec($);if(W)for(var _=1;_<W.length;_++){var j=W[_];j&&s.addClass(\"sapUiRespGridBwd\"+j.toUpperCase())}}var q=f.getMoveForward();if(q&&q.length>0){var z=r.exec(q);if(z)for(var _=1;_<z.length;_++){var J=z[_];J&&s.addClass(\"sapUiRespGridFwd\"+J.toUpperCase())}}f._sStylesInternal&&s.addClass(f._sStylesInternal)}if(!f){var D=\"\";if(R)for(var _=1;_<R.length;_++)D=R[_],D||(D=1==_&&R[_+1]?\"X\"+R[_+1]:S[_]),s.addClass(\"sapUiRespGridSpan\"+D.toUpperCase());else for(var _=1;_<S.length;_++)D=S[_],s.addClass(\"sapUiRespGridSpan\"+D.toUpperCase());var T=\"\";if(X)for(var _=1;_<X.length;_++)T=X[_],T||(T=1==_&&X[_+1]?\"X\"+X[_+1]:v[_]),(\"X\"!==T.substr(0,1)&&\"0\"!==T.substr(1,1)||\"X\"==T.substr(0,1)&&\"0\"!==T.substr(2,1))&&s.addClass(\"sapUiRespGridIndent\"+T.toUpperCase())}s.writeClasses(),s.write(\">\"),s.renderControl(o[c]),s.write(\"</div>\")}s.write(\"</div>\")},i},!0);",
	"sap/ui/layout/HorizontalLayout.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"sap/ui/core/Control\",\"./library\",\"./HorizontalLayoutRenderer\"],function(t,e,o){\"use strict\";var i=t.extend(\"sap.ui.layout.HorizontalLayout\",{metadata:{library:\"sap.ui.layout\",properties:{allowWrapping:{type:\"boolean\",group:\"Misc\",defaultValue:!1}},defaultAggregation:\"content\",aggregations:{content:{type:\"sap.ui.core.Control\",multiple:!0,singularName:\"content\"}},designtime:\"sap/ui/layout/designtime/HorizontalLayout.designtime\"}});return i.prototype.getAccessibilityInfo=function(){return{children:this.getContent()}},i});",
	"sap/ui/layout/HorizontalLayoutRenderer.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([],function(){\"use strict\";var r={};return r.render=function(r,t){var a=r,e=!t.getAllowWrapping();a.write(\"<div\"),a.writeControlData(t),a.addClass(\"sapUiHLayout\"),e&&a.addClass(\"sapUiHLayoutNoWrap\"),a.writeClasses(),a.write(\">\");for(var i=t.getContent(),s=0;s<i.length;s++)e&&a.write(\"<div class='sapUiHLayoutChildWrapper'>\"),a.renderControl(i[s]),e&&a.write(\"</div>\");a.write(\"</div>\")},r},!0);",
	"sap/ui/layout/library.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"sap/ui/base/DataType\",\"sap/ui/core/library\"],function(o){\"use strict\";return sap.ui.getCore().initLibrary({name:\"sap.ui.layout\",version:\"904001.7.0.20251118090100_f0htmcm94p\",dependencies:[\"sap.ui.core\"],designtime:\"sap/ui/layout/designtime/library.designtime\",types:[\"sap.ui.layout.BackgroundDesign\",\"sap.ui.layout.GridIndent\",\"sap.ui.layout.GridPosition\",\"sap.ui.layout.GridSpan\",\"sap.ui.layout.BlockBackgroundType\",\"sap.ui.layout.form.GridElementCells\",\"sap.ui.layout.form.SimpleFormLayout\"],interfaces:[],controls:[\"sap.ui.layout.AlignedFlowLayout\",\"sap.ui.layout.DynamicSideContent\",\"sap.ui.layout.FixFlex\",\"sap.ui.layout.Grid\",\"sap.ui.layout.HorizontalLayout\",\"sap.ui.layout.ResponsiveFlowLayout\",\"sap.ui.layout.ResponsiveSplitter\",\"sap.ui.layout.ResponsiveSplitterPage\",\"sap.ui.layout.Splitter\",\"sap.ui.layout.VerticalLayout\",\"sap.ui.layout.BlockLayoutCell\",\"sap.ui.layout.BlockLayoutRow\",\"sap.ui.layout.BlockLayout\",\"sap.ui.layout.form.Form\",\"sap.ui.layout.form.FormLayout\",\"sap.ui.layout.form.GridLayout\",\"sap.ui.layout.form.ResponsiveGridLayout\",\"sap.ui.layout.form.ResponsiveLayout\",\"sap.ui.layout.form.SimpleForm\"],elements:[\"sap.ui.layout.GridData\",\"sap.ui.layout.ResponsiveFlowLayoutData\",\"sap.ui.layout.SplitterLayoutData\",\"sap.ui.layout.form.FormContainer\",\"sap.ui.layout.form.FormElement\",\"sap.ui.layout.form.GridContainerData\",\"sap.ui.layout.PaneContainer\",\"sap.ui.layout.SplitPane\",\"sap.ui.layout.form.GridElementData\"],extensions:{flChangeHandlers:{\"sap.ui.layout.BlockLayout\":{moveControls:\"default\"},\"sap.ui.layout.BlockLayoutRow\":{moveControls:\"default\",hideControl:\"default\",unhideControl:\"default\"},\"sap.ui.layout.BlockLayoutCell\":\"sap/ui/layout/flexibility/BlockLayoutCell\",\"sap.ui.layout.DynamicSideContent\":{moveControls:\"default\",hideControl:\"default\",unhideControl:\"default\"},\"sap.ui.layout.form.SimpleForm\":\"sap/ui/layout/flexibility/SimpleForm\",\"sap.ui.layout.Grid\":{moveControls:\"default\",hideControl:\"default\",unhideControl:\"default\"},\"sap.ui.layout.FixFlex\":{moveControls:\"default\",hideControl:\"default\",unhideControl:\"default\"},\"sap.ui.layout.form.Form\":\"sap/ui/layout/flexibility/Form\",\"sap.ui.layout.form.FormContainer\":\"sap/ui/layout/flexibility/FormContainer\",\"sap.ui.layout.form.FormElement\":\"sap/ui/layout/flexibility/FormElement\",\"sap.ui.layout.HorizontalLayout\":{moveControls:\"default\",hideControl:\"default\",unhideControl:\"default\"},\"sap.ui.layout.Splitter\":{moveControls:\"default\",hideControl:\"default\",unhideControl:\"default\"},\"sap.ui.layout.VerticalLayout\":{moveControls:\"default\",hideControl:\"default\",unhideControl:\"default\"}},\"sap.ui.support\":{publicRules:!0,internalRules:!0}}}),sap.ui.layout.BackgroundDesign={Solid:\"Solid\",Transparent:\"Transparent\",Translucent:\"Translucent\"},sap.ui.layout.GridIndent=o.createType(\"sap.ui.layout.GridIndent\",{isValid:function(o){return/^(([Xx][Ll](?:[0-9]|1[0-1]))? ?([Ll](?:[0-9]|1[0-1]))? ?([Mm](?:[0-9]|1[0-1]))? ?([Ss](?:[0-9]|1[0-1]))?)$/.test(o)}},o.getType(\"string\")),sap.ui.layout.GridPosition={Left:\"Left\",Right:\"Right\",Center:\"Center\"},sap.ui.layout.GridSpan=o.createType(\"sap.ui.layout.GridSpan\",{isValid:function(o){return/^(([Xx][Ll](?:[1-9]|1[0-2]))? ?([Ll](?:[1-9]|1[0-2]))? ?([Mm](?:[1-9]|1[0-2]))? ?([Ss](?:[1-9]|1[0-2]))?)$/.test(o)}},o.getType(\"string\")),sap.ui.layout.BlockBackgroundType={Default:\"Default\",Light:\"Light\",Mixed:\"Mixed\",Accent:\"Accent\",Dashboard:\"Dashboard\"},sap.ui.layout.BlockRowColorSets={ColorSet1:\"ColorSet1\",ColorSet2:\"ColorSet2\",ColorSet3:\"ColorSet3\",ColorSet4:\"ColorSet4\"},sap.ui.layout.BlockLayoutCellColorSet={ColorSet1:\"ColorSet1\",ColorSet2:\"ColorSet2\",ColorSet3:\"ColorSet3\",ColorSet4:\"ColorSet4\",ColorSet5:\"ColorSet5\",ColorSet6:\"ColorSet6\",ColorSet7:\"ColorSet7\",ColorSet8:\"ColorSet8\",ColorSet9:\"ColorSet9\",ColorSet10:\"ColorSet10\",ColorSet11:\"ColorSet11\"},sap.ui.layout.BlockLayoutCellColorShade={ShadeA:\"ShadeA\",ShadeB:\"ShadeB\",ShadeC:\"ShadeC\",ShadeD:\"ShadeD\"},sap.ui.layout.form=sap.ui.layout.form||{},sap.ui.layout.form.GridElementCells=o.createType(\"sap.ui.layout.form.GridElementCells\",{isValid:function(o){return/^(auto|full|([1-9]|1[0-6]))$/.test(o)}},o.getType(\"string\")),sap.ui.layout.form.SimpleFormLayout={ResponsiveLayout:\"ResponsiveLayout\",GridLayout:\"GridLayout\",ResponsiveGridLayout:\"ResponsiveGridLayout\"},sap.ui.layout.SideContentVisibility={AlwaysShow:\"AlwaysShow\",ShowAboveL:\"ShowAboveL\",ShowAboveM:\"ShowAboveM\",ShowAboveS:\"ShowAboveS\",NeverShow:\"NeverShow\"},sap.ui.layout.SideContentFallDown={BelowXL:\"BelowXL\",BelowL:\"BelowL\",BelowM:\"BelowM\",OnMinimumWidth:\"OnMinimumWidth\"},sap.ui.layout.SideContentPosition={End:\"End\",Begin:\"Begin\"},sap.ui.layout.form.FormHelper||(sap.ui.layout.form.FormHelper={createLabel:function(o){throw new Error(\"no Label control available!\")},createButton:function(o,t,a){throw new Error(\"no Button control available!\")},setButtonContent:function(o,t,a,e,l){throw new Error(\"no Button control available!\")},addFormClass:function(){return null},setToolbar:function(o){return o},bArrowKeySupport:!0,bFinal:!1}),sap.ui.layout});",
	"sap/ui/layout/library.support.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"./rules/Form.support\"],function(e){\"use strict\";return{name:\"sap.ui.layout\",niceName:\"UI5 Layout Library\",ruleset:[e]}},!0);",
	"sap/ui/layout/PaneContainer.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"./library\",\"sap/ui/core/Element\",\"./AssociativeSplitter\",\"sap/ui/core/library\"],function(t,e,i,n){\"use strict\";var r=n.Orientation,o=e.extend(\"sap.ui.layout.PaneContainer\",{metadata:{library:\"sap.ui.layout\",properties:{orientation:{type:\"sap.ui.core.Orientation\",group:\"Behavior\",defaultValue:r.Horizontal}},defaultAggregation:\"panes\",aggregations:{panes:{type:\"sap.ui.core.Element\",multiple:!0,singularName:\"pane\"}}}});return o.prototype.init=function(){this._oSplitter=new i({orientation:this.getOrientation(),height:\"100%\"}),this._oSplitter._bUseIconForSeparator=!1},o.prototype.setOrientation=function(t){return this._oSplitter.setOrientation(t),this.setProperty(\"orientation\",t,!0)},o.prototype._getPanesInInterval=function(t){return this.getPanes().filter(function(e){return e instanceof sap.ui.layout.SplitPane&&e._isInInterval(t)})},o.prototype.setLayoutData=function(t){return this._oSplitter.setLayoutData(t)},o.prototype.insertPane=function(t,e){var i=this.insertAggregation(\"panes\",t,e),n={onAfterRendering:function(){this.triggerResize(),this.removeEventDelegate(n)}};return t instanceof o&&t._oSplitter&&t._oSplitter.addEventDelegate(n,t._oSplitter),i},o.prototype.removePane=function(t){var e=this.removeAggregation(\"panes\",t),i={onAfterRendering:function(){this.triggerResize(),this.removeEventDelegate(i)}};return this.getPanes().forEach(function(t){t instanceof o&&t._oSplitter&&t._oSplitter.addEventDelegate(i,t._oSplitter)}),e},o});",
	"sap/ui/layout/ResponsiveFlowLayout.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/core/Control\",\"./ResponsiveFlowLayoutData\",\"./library\",\"sap/ui/core/ResizeHandler\",\"sap/ui/Device\",\"./ResponsiveFlowLayoutRenderer\"],function(t,e,i,n,o,r,a){\"use strict\";var s=e.extend(\"sap.ui.layout.ResponsiveFlowLayout\",{metadata:{library:\"sap.ui.layout\",properties:{responsive:{type:\"boolean\",group:\"Misc\",defaultValue:!0}},defaultAggregation:\"content\",aggregations:{content:{type:\"sap.ui.core.Control\",multiple:!0,singularName:\"content\"}},associations:{ariaLabelledBy:{type:\"sap.ui.core.Control\",multiple:!0,singularName:\"ariaLabelledBy\"}}}});return function(){s.prototype.init=function(){this._rows=[],this._bIsRegistered=!1,this._proxyComputeWidths=t.proxy(l,this),this._iRowCounter=0},s.prototype.exit=function(){delete this._rows,this._IntervalCall&&(t.sap.clearDelayedCall(this._IntervalCall),this._IntervalCall=void 0),this._resizeHandlerComputeWidthsID&&o.deregister(this._resizeHandlerComputeWidthsID),delete this._resizeHandlerComputeWidthsID,delete this._proxyComputeWidths,this.oRm&&(this.oRm.destroy(),delete this.oRm),delete this._$DomRef,delete this._oDomRef,delete this._iRowCounter};var e=function(t){for(var e,n=t.getContent(),o=[],r=-1,a={},s={},h=\"\",l=0,p=0,u=0,g=!1,f=!1,c=!1,C=0;C<n.length;C++){l=i.MIN_WIDTH,p=i.WEIGHT,g=i.LINEBREAK,f=i.MARGIN,c=i.LINEBREAKABLE,e=d(n[C]),e instanceof i&&(g=e.getLinebreak(),l=e.getMinWidth(),p=e.getWeight(),f=e.getMargin(),c=e.getLinebreakable()),(r<0||g)&&(r++,o.push({height:-1,cont:[]})),u=o[r].cont.length,h=n[C].getId()+\"-cont\"+r+\"_\"+u,a={minWidth:l,weight:p,linebreakable:c,padding:f,control:n[C],id:h,breakWith:[]};var _=!1;if(!c)for(var m=u;m>0;m--)if(s=o[r].cont[m-1],s.linebreakable){s.breakWith.push(a),_=!0;break}_||o[r].cont.push(a)}t._rows=o},n=function(e,i,n){var o=[],r=1e7,a=-1,s=function(i){var n=t.sap.byId(e.cont[i].id);if(n.length>0){var s=n[0].offsetLeft;r>=s&&(o.push({cont:[]}),a++),r=s,o[a].cont.push(e.cont[i])}};if(sap.ui.getCore().getConfiguration().getRTL())for(var h=e.cont.length-1;h>=0;h--)s(h);else for(var h=0;h<e.cont.length;h++)s(h);return o},a=function(t,e){var i=[],n=-1,o=0,r=0,a=0,s=0,h=0,l=0,d=0;for(l=0;l<t.cont.length;l++){for(o=0,r=0,d=a;d<=l;d++)r+=t.cont[d].weight;for(d=a;d<=l;d++)s=e/r*t.cont[d].weight,s=Math.floor(s),h=t.cont[d].minWidth,o+=Math.max(s,h);(-1==n||o>e)&&(i.push({cont:[]}),-1!==n&&(a=l),n++),i[n].cont.push(t.cont[l])}return i},h=function(t,e){if(t.length!=e.length)return!0;for(var i=0;i<t.length;i++)if(t[i].cont.length!=e[i].cont.length)return!0;return!1};s.prototype.renderContent=function(t,e){var i,n=t,o=0,r=[],a=0,s=0,h=0,l=0,d=0,p=0,u=0,g=0,f=[],c=[],C=this.getId(),_=\"\",m=this._getRenderManager();for(a=0;a<n.length;a++){p=0,r.length=0,o=100,c.length=0,c.push(\"sapUiRFLRow\"),n[a].cont.length<=1&&c.push(\"sapUiRFLCompleteRow\");var w=C+\"-row\"+this._iRowCounter,R={};for(m.writeHeader(w,R,c),d=0,s=0;s<n[a].cont.length;s++)d+=n[a].cont[s].weight;for(h=0;h<n[a].cont.length;h++){if(i=n[a].cont[h],u=0,g=0,i.breakWith.length>0){u=i.weight,g=i.minWidth;for(var v=0;v<i.breakWith.length;v++)u+=i.breakWith[v].weight,g+=i.breakWith[v].minWidth}_=n[a].cont[h].id,c.length=0,R={\"min-width\":i.breakWith.length>0?g:i.minWidth},p=100/d*i.weight;var y=R[\"min-width\"]/e*100,D=Math.ceil(y),W=Math.floor(p);p=100!==W&&D>W?D:W,p=o<p?o:p,o-=p,r.push(p),o>0&&h===n[a].cont.length-1&&(p+=o),c.push(\"sapUiRFLContainer\"),R.width=p+\"%\",R[\"min-width\"]=R[\"min-width\"]+\"px\",m.writeHeader(_,R,c),c.length=0,c.push(\"sapUiRFLContainerContent\"),i.breakWith.length>0&&c.push(\"sapUiRFLMultiContainerContent\"),i.padding&&c.push(\"sapUiRFLPaddingClass\");var I=this._addContentClass(i.control,h);if(I&&c.push(I),R={},m.writeHeader(\"\",R,c),i.breakWith.length>0){_=n[a].cont[h].id+\"-multi0\",c.length=0,R={\"min-width\":g+\"px\"};var b=100/u*i.weight;b=Math.floor(b),f.push(b),c.push(\"sapUiRFLMultiContent\"),R.width=b+\"%\",n[a].cont[h].padding&&c.push(\"sapUiRFLPaddingClass\"),m.writeHeader(_,R,c);var L=b;for(m.renderControl(i.control),m.write(\"</div>\"),l=0;l<i.breakWith.length;l++)_=i.breakWith[l].id+\"-multi\"+(l+1),c.length=0,R={\"min-width\":i.breakWith[l].minWidth+\"px\"},b=100/u*i.breakWith[l].weight,b=Math.floor(b),f.push(b),L+=b,L<100&&l===i.breakWith.length-1&&(b+=100-L),c.push(\"sapUiRFLMultiContent\"),R.width=b+\"%\",i.breakWith[l].padding&&c.push(\"sapUiRFLPaddingClass\"),m.writeHeader(_,R,c),m.renderControl(i.breakWith[l].control),m.write(\"</div>\")}else m.renderControl(i.control);m.write(\"</div>\"),m.write(\"</div>\")}m.write(\"</div>\"),this._iRowCounter++}};var l=function(e){if(this._iRowCounter=0,this._oDomRef=this.getDomRef(),this._oDomRef){var i=this.getId(),s=t(this._oDomRef).width(),l=!1;if(this._rows){for(var d=0;d<this._rows.length;d++){var p=this._$DomRef.find(\"#\"+i+\"-row\"+d),u=a(this._rows[d],s),g=n(this._rows[d]);l=h(g,u);var f=this._getElementRect(p),c=this._rows[d].oRect;f&&c&&(l=l||f.width!==c.width&&f.height!==c.height),l=l||\"boolean\"==typeof e&&e,(this._bLayoutDataChanged||l)&&(r.browser.internet_explorer?t(this._oDomRef).empty():this._oDomRef.innerHTML=\"\",this._bLayoutDataChanged=!1,this.renderContent(u,s))}if(\"\"===this._oDomRef.innerHTML){this._getRenderManager().flush(this._oDomRef);for(var d=0;d<this._rows.length;d++){var C=this._getElementRect(t.sap.byId(i+\"-row\"+d));this._rows[d].oRect=C}}0===this._rows.length&&this._resizeHandlerComputeWidthsID&&(o.deregister(this._resizeHandlerComputeWidthsID),delete this._resizeHandlerComputeWidthsID)}}};s.prototype.onBeforeRendering=function(){e(this),this._resizeHandlerFullLengthID&&(o.deregister(this._resizeHandlerFullLengthID),delete this._resizeHandlerFullLengthID)},s.prototype.onAfterRendering=function(e){this._oDomRef=this.getDomRef(),this._$DomRef=t(this._oDomRef),this._proxyComputeWidths(!0),this.getResponsive()?this._resizeHandlerComputeWidthsID||(this._resizeHandlerComputeWidthsID=o.register(this,this._proxyComputeWidths)):this._resizeHandlerComputeWidthsID&&(o.deregister(this._resizeHandlerComputeWidthsID),delete this._resizeHandlerComputeWidthsID)},s.prototype.onThemeChanged=function(t){\"LayoutDataChange\"===t.type&&(this._bLayoutDataChanged=!0),this._resizeHandlerComputeWidthsID||(this._resizeHandlerComputeWidthsID=o.register(this,this._proxyComputeWidths)),e(this),this._proxyComputeWidths()},s.prototype.onLayoutDataChange=s.prototype.onThemeChanged;var d=function(t){var e=t.getLayoutData();if(e){if(e instanceof i)return e;if(\"sap.ui.core.VariantLayoutData\"==e.getMetadata().getName())for(var n=e.getMultipleLayoutData(),o=0;o<n.length;o++){var r=n[o];if(r instanceof i)return r}}};s.prototype.addContent=function(e){e&&this._IntervalCall&&(t.sap.clearDelayedCall(this._IntervalCall),this._IntervalCall=void 0),this.addAggregation(\"content\",e)},s.prototype.insertContent=function(e,i){e&&this._IntervalCall&&(t.sap.clearDelayedCall(this._IntervalCall),this._IntervalCall=void 0),this.insertAggregation(\"content\",e,i)},s.prototype.removeContent=function(e){e&&this._IntervalCall&&(t.sap.clearDelayedCall(this._IntervalCall),this._IntervalCall=void 0),this.removeAggregation(\"content\",e)},s.prototype._getAccessibleRole=function(){return null},s.prototype._addContentClass=function(t,e){return null},s.prototype._getElementRect=function(t){var e=t&&t.rect();return e&&(e.height=e.height.toFixed(1),e.width=e.width.toFixed(1)),e},s.prototype._getRenderManager=function(){return this.oRm||(this.oRm=sap.ui.getCore().createRenderManager(),this.oRm.writeStylesAndClasses=function(){this.writeStyles(),this.writeClasses()},this.oRm.writeHeader=function(t,e,i){if(this.write('<div id=\"'+t+'\"'),e)for(var n in e)\"width\"===n&&\"100%\"===e[n]&&this.addClass(\"sapUiRFLFullLength\"),this.addStyle(n,e[n]);for(var o=0;o<i.length;o++)this.addClass(i[o]);this.writeStylesAndClasses(),this.write(\">\")}),this.oRm}}(),s});",
	"sap/ui/layout/ResponsiveFlowLayoutData.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/core/LayoutData\",\"./library\"],function(e,t,a){\"use strict\";var i=t.extend(\"sap.ui.layout.ResponsiveFlowLayoutData\",{metadata:{library:\"sap.ui.layout\",properties:{minWidth:{type:\"int\",group:\"Misc\",defaultValue:100},weight:{type:\"int\",group:\"Misc\",defaultValue:1},linebreak:{type:\"boolean\",group:\"Misc\",defaultValue:!1},margin:{type:\"boolean\",group:\"Misc\",defaultValue:!0},linebreakable:{type:\"boolean\",group:\"Misc\",defaultValue:!0}}}});return i.MIN_WIDTH=100,i.WEIGHT=1,i.LINEBREAK=!1,i.MARGIN=!0,i.LINEBREAKABLE=!0,i.prototype.setWeight=function(t){return t>=1?this.setProperty(\"weight\",t):(e.sap.log.warning(\"Values smaller than 1 are invalid. Default value '1' is used instead\",this),this.setProperty(\"weight\",i.WEIGHT)),this},i.prototype.setLinebreak=function(t){return 0==this.getLinebreakable()&&t?e.sap.log.warning(\"Setting 'linebreak' AND 'linebreakable' doesn't make any sense. Please set either 'linebreak' or 'linebreakable'\",this):this.setProperty(\"linebreak\",t),this},i.prototype.setLinebreakable=function(t){return!0===this.getLinebreak()&&!1===t?e.sap.log.warning(\"Setting 'linebreak' AND 'linebreakable' doesn't make any sense. Please set either 'linebreak' or 'linebreakable'\",this):this.setProperty(\"linebreakable\",t),this},i});",
	"sap/ui/layout/ResponsiveFlowLayoutRenderer.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([],function(){\"use strict\";var e={};return function(){e.render=function(e,i){e.write(\"<div\"),e.writeControlData(i),e.addClass(\"sapUiRFL\"),e.writeClasses();var t,r=i._getAccessibleRole();r&&(t={role:r}),e.writeAccessibilityState(i,t),e.write(\">\"),e.write(\"</div>\")}}(),e},!0);",
	"sap/ui/layout/rules/Form.support.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/support/library\"],function(e,t){\"use strict\";function a(e,t){var a=sap.ui.require(t);return e&&\"function\"==typeof a&&e instanceof a}function o(e){if(e){if(\"sap.ui.layout.form.SimpleForm\"==e.getMetadata().getName())return!0}return!1}function i(e){if(e){var t=e.getMetadata();if(\"sap.ui.comp.smartform.SmartForm\"==t.getName()||\"sap.m.Panel\"==t.getName()&&\"sap.ui.comp.smartform.SmartForm\"==e.getParent().getMetadata().getName())return!0}return!1}function r(e,t,a){var o=e.getTitle(),i=e.getToolbar();if(o&&i){var r=e.getId();a.addIssue({severity:d.Medium,details:t+\" \"+r+\" has Title and Toolbar assigned.\",context:{id:r}})}}function s(e,t,a){var o=e.getId(),i=e.getMetadata();i.isInstanceOf(\"sap.ui.core.IFormContent\")||a.addIssue({severity:d.High,details:i.getName()+\" \"+o+\" is not allowed as \"+t+\" content.\",context:{id:o}})}function n(e,t,o){var i=e.getToolbar();if(i){var r,s=e.getId(),n=e.getAriaLabelledBy();i.getContent?r=i.getContent():i.getItems&&(r=i.getItems());for(var l=0;l<r.length;l++){var m=r[l];if(a(m,\"sap/ui/core/Title\")||\"sap.m.Title\"==m.getMetadata().getName()){for(var u=!1,p=0;p<n.length;p++){var c=n[p];if(m.getId()==c){u=!0;break}}u||o.addIssue({severity:d.Medium,details:\"in\"+t+\" \"+s+\" AriaLabelledBy for Title in Toolbar is missing.\",context:{id:s}})}}}}function l(e,t,a,o,i,r){var s=o.getMetadata().getName(),n=i.getMetadata().getName(),l=e.getMetadata().getName(),m=e.getId(),u=!1,p=!1;switch(s){case\"sap.ui.layout.form.ResponsiveGridLayout\":\"sap.ui.layout.GridData\"!=n?u=!0:\"sap.ui.layout.form.FormElement\"==l&&(p=!0);break;case\"sap.ui.layout.form.ResponsiveLayout\":\"sap.ui.layout.ResponsiveFlowLayoutData\"!=n&&(u=!0);break;case\"sap.ui.layout.form.GridLayout\":\"sap.ui.layout.form.GridElementData\"!=n?\"sap.ui.layout.form.FormContainer\"==l&&\"sap.ui.layout.form.GridContainerData\"==n||(u=!0):\"sap.ui.layout.form.FormElement\"==l&&(p=!0)}u&&r.addIssue({severity:d.Low,details:t+\" \"+a+\" uses \"+s+\", therefore \"+n+\" is not supported on \"+l+\" \"+m+\".\",context:{id:m}}),p&&r.addIssue({severity:d.Low,details:t+\" \"+a+\" uses \"+s+\", but \"+n+\" is not supported on \"+l+\" \"+m+\".\",context:{id:m}})}function m(e,t,a,o,i){var r=e.getLayoutData();if(r)if(\"sap.ui.core.VariantLayoutData\"==r.getMetadata().getName())for(var s=r.getMultipleLayoutData(),n=0;n<s.length;n++)r=s[n],l(e,t,a,o,r,i);else l(e,t,a,o,r,i)}var u=t.Categories,d=t.Severity,p=t.Audiences;return[{id:\"formResponsiveLayout\",audiences:[p.Control],categories:[u.Functionality],enabled:!0,minversion:\"1.48\",title:\"Form: Use of ResponsiveLayout\",description:\"ResponsiveLayout should not be used any longer because of UX requirements\",resolution:\"Use the ResponsiveGridLayout instead\",resolutionurls:[{text:\"API Reference: Form\",href:\"https://sapui5.hana.ondemand.com/#docs/api/symbols/sap.ui.layout.form.Form.html\"},{text:\"API Reference: SimpleForm\",href:\"https://sapui5.hana.ondemand.com/#docs/api/symbols/sap.ui.layout.form.SimpleForm.html\"},{text:\"API Reference: ResponsiveGridLayout\",href:\"https://sapui5.hana.ondemand.com/#docs/api/symbols/sap.ui.layout.form.ResponsiveGridLayout.html\"}],check:function(e,t,a){a.getElementsByClassName(\"sap.ui.layout.form.Form\").forEach(function(t){var a=t.getLayout();if(a&&\"sap.ui.layout.form.ResponsiveLayout\"==a.getMetadata().getName()){var r,s=t.getParent(),n=\"Form\";if(o(s))r=s.getId(),n=\"SimpleForm\";else{if(i(s))return;r=t.getId()}e.addIssue({severity:d.Medium,details:n+\" \"+r+\" uses ResponsiveLayout.\",context:{id:r}})}})}},{id:\"formTitleAndToolbar\",audiences:[p.Application],categories:[u.Functionality],enabled:!0,minversion:\"1.48\",title:\"Form: Title and Toolbar at same time\",description:\"A Form or FormContainer can only have a Title or a Toolbar assigned, not both\",resolution:\"Use either Title or a Toolbar\",resolutionurls:[{text:\"API Reference: Form\",href:\"https://sapui5.hana.ondemand.com/#docs/api/symbols/sap.ui.layout.form.Form.html\"},{text:\"API Reference: SimpleForm\",href:\"https://sapui5.hana.ondemand.com/#docs/api/symbols/sap.ui.layout.form.SimpleForm.html\"},{text:\"API Reference: FormContainer\",href:\"https://sapui5.hana.ondemand.com/#docs/api/symbols/sap.ui.layout.form.FormContainer.html\"}],check:function(e,t,a){a.getElementsByClassName(\"sap.ui.layout.form.Form\").forEach(function(t){o(t.getParent())||r(t,\"Form\",e)}),a.getElementsByClassName(\"sap.ui.layout.form.FormContainer\").forEach(function(t){r(t,\"FormContainer\",e)}),a.getElementsByClassName(\"sap.ui.layout.form.SimpleForm\").forEach(function(t){r(t,\"SimpleForm\",e)})}},{id:\"formTitleOrAriaLabel\",audiences:[p.Application],categories:[u.Accessibility],enabled:!0,minversion:\"1.48\",title:\"Form: Container must have a Title\",description:\"A FormContainer must have some Title information.\\n This can be a Title on the FormContainer or some Title assigned via AriaLabelledBy.\\n If no Title is assigned to the FormContainer there must be at least a Title set on the Form or assigned via AriaLabelledBy on the Form.\",resolution:\"Set a Title on Form or FormContainer or assign it via AriaLabelledBy\",resolutionurls:[{text:\"API Reference: Form\",href:\"https://sapui5.hana.ondemand.com/#docs/api/symbols/sap.ui.layout.form.Form.html\"},{text:\"API Reference: SimpleForm\",href:\"https://sapui5.hana.ondemand.com/#docs/api/symbols/sap.ui.layout.form.SimpleForm.html\"},{text:\"API Reference: FormContainer\",href:\"https://sapui5.hana.ondemand.com/#docs/api/symbols/sap.ui.layout.form.FormContainer.html\"}],check:function(e,t,a){a.getElementsByClassName(\"sap.ui.layout.form.FormContainer\").forEach(function(t){var a=t.getParent();if(a){var r,s=a.getParent(),n=\"Form\";if(o(s))r=s.getId(),n=\"SimpleForm\";else{if(i(s))return;r=a.getId()}t.getTitle()||0!=t.getAriaLabelledBy().length||a.getTitle()||0!=a.getAriaLabelledBy().length||e.addIssue({severity:d.High,details:\"In \"+n+\" \"+r+\", FormContainer\"+t.getId()+\" has no Title assigned.\",context:{id:t.getId()}})}})}},{id:\"formAllowedContent\",audiences:[p.Application],categories:[u.Usability],enabled:!0,minversion:\"1.48\",title:\"Form: Content not allowed\",description:\"It is not allowed to use any layout as content of a Form or nest Forms This leads to issues with screen reader support, keyboard support and field alignment.\\nIt is also not supported to use other unsupported controls as content of the Form as it is not sure this controls will meet the alingment and intartaction requirements of the Form.\",resolution:\"Use only labels and controls implementing interface sap.ui.core.IFormContent as content of a Form\",resolutionurls:[{text:\"API Reference: Form\",href:\"https://sapui5.hana.ondemand.com/#docs/api/symbols/sap.ui.layout.form.Form.html\"},{text:\"API Reference: SimpleForm\",href:\"https://sapui5.hana.ondemand.com/#docs/api/symbols/sap.ui.layout.form.SimpleForm.html\"},{text:\"API Reference: FormElement\",href:\"https://sapui5.hana.ondemand.com/#docs/api/symbols/sap.ui.layout.form.FormElement.html\"},{text:\"API Reference: IFormContent\",href:\"https://sapui5.hana.ondemand.com/#docs/api/symbols/sap.ui.core.IFormContent.html\"}],check:function(e,t,r){r.getElementsByClassName(\"sap.ui.layout.form.Form\").forEach(function(t){var a=t.getParent();if(!o(a)&&!i(a))for(var r=t.getFormContainers(),n=0;n<r.length;n++)for(var l=r[n],m=l.getFormElements(),u=0;u<m.length;u++)for(var d=m[u],p=d.getFields(),c=0;c<p.length;c++){var f=p[c];s(f,\"Form\",e)}}),r.getElementsByClassName(\"sap.ui.layout.form.SimpleForm\").forEach(function(t){for(var o=t.getContent(),i=0;i<o.length;i++){var r=o[i];a(r,\"sap/ui/core/Title\")||r.getMetadata().isInstanceOf(\"sap.ui.core.Toolbar\")||r.getMetadata().isInstanceOf(\"sap.ui.core.Label\")||s(r,\"SimpleForm\",e)}}),r.getElementsByClassName(\"sap.ui.comp.smartform.SmartForm\").forEach(function(t){for(var a=t.getGroups(),o=0;o<a.length;o++)for(var i=a[o],r=i.getGroupElements(),n=0;n<r.length;n++)for(var l=r[n],m=l.getElements(),u=0;u<m.length;u++){var d=m[u];s(d,\"SmartForm\",e)}})}},{id:\"formTitleInToolbarAria\",audiences:[p.Application],categories:[u.Accessibility],enabled:!0,minversion:\"1.48\",title:\"Form: Title in Toolbar needs to be set to AriaLabelledBy\",description:\"If a Toolbar is used in a Form or FormContainer and the Toolbar has a Title inside it must be set to AriaLabelledBy to enable screen reader support\",resolution:\"Set the Title used inside the Toolbar to AriaLabelledBy of the Form or FormContainer.\",resolutionurls:[{text:\"API Reference: Form\",href:\"https://sapui5.hana.ondemand.com/#docs/api/symbols/sap.ui.layout.form.Form.html\"},{text:\"API Reference: SimpleForm\",href:\"https://sapui5.hana.ondemand.com/#docs/api/symbols/sap.ui.layout.form.SimpleForm.html\"},{text:\"API Reference: FormContainer\",href:\"https://sapui5.hana.ondemand.com/#docs/api/symbols/sap.ui.layout.form.FormContainer.html\"}],check:function(e,t,a){a.getElementsByClassName(\"sap.ui.layout.form.Form\").forEach(function(t){o(t.getParent())||n(t,\"Form\",e)}),a.getElementsByClassName(\"sap.ui.layout.form.FormContainer\").forEach(function(t){o(t.getParent().getParent())||n(t,\"FormContainer\",e)}),a.getElementsByClassName(\"sap.ui.layout.form.SimpleForm\").forEach(function(t){n(t,\"SimpleForm\",e)})}},{id:\"formPropertiesOfOtherLayout\",audiences:[p.Application],categories:[u.Consistency],enabled:!0,minversion:\"1.48\",title:\"SimpleForm: Properties not valid for layout\",description:\"Some properties of SimpleForm are only valid for a special layout. If they are used with a different layout they have no effect.\",resolution:\"Use only properties that are valid for the layout used\",resolutionurls:[{text:\"API Reference: SimpleForm\",href:\"https://sapui5.hana.ondemand.com/#docs/api/symbols/sap.ui.layout.form.SimpleForm.html\"}],check:function(e,t,a){a.getElementsByClassName(\"sap.ui.layout.form.SimpleForm\").forEach(function(t){var a=t.getId(),o=t.getLayout(),i=[],r=function(e){t.isPropertyInitial(e)||i.push(e)};o!=sap.ui.layout.form.SimpleFormLayout.ResponsiveGridLayout&&(r(\"labelSpanXL\"),r(\"labelSpanL\"),r(\"labelSpanM\"),r(\"labelSpanS\"),r(\"adjustLabelSpan\"),r(\"emptySpanXL\"),r(\"emptySpanL\"),r(\"emptySpanM\"),r(\"emptySpanS\"),r(\"columnsXL\"),r(\"columnsL\"),r(\"columnsM\"),r(\"singleContainerFullSize\"),r(\"breakpointXL\"),r(\"breakpointL\"),r(\"breakpointM\")),o!=sap.ui.layout.form.SimpleFormLayout.ResponsiveLayout&&(r(\"minWidth\"),r(\"labelMinWidth\")),o==sap.ui.layout.form.SimpleFormLayout.ResponsiveGridLayout&&r(\"maxContainerCols\");for(var s=0;s<i.length;s++)e.addIssue({severity:d.Low,details:\"SimpleForm \"+a+\" with Layout \"+o+\" doesn't support use of property \"+i[s]+\".\",context:{id:a}})})}},{id:\"formEditableContent\",audiences:[p.Application],categories:[u.Usability],enabled:!0,minversion:\"1.48\",title:\"Form: Editable content must match editable property\",description:\"The editable property of the Form is used to align the Labels and add screen reader information. If editable controls are used in Form, the property must be set, otherwise it should not be set.\",resolution:\"Set the editable property according to the content of the Form.\",resolutionurls:[{text:\"API Reference: Form\",href:\"https://sapui5.hana.ondemand.com/#docs/api/symbols/sap.ui.layout.form.Form.html\"},{text:\"API Reference: SimpleForm\",href:\"https://sapui5.hana.ondemand.com/#docs/api/symbols/sap.ui.layout.form.SimpleForm.html\"},{text:\"API Reference: FormElement\",href:\"https://sapui5.hana.ondemand.com/#docs/api/symbols/sap.ui.layout.form.FormElement.html\"}],check:function(e,t,r){r.getElementsByClassName(\"sap.ui.layout.form.Form\").forEach(function(t){var r,s=t.getEditable(),n=t.getParent(),l=n?n.getMetadata():void 0,m=\"Form\";if(o(n))r=n.getId(),m=\"SimpleForm\";else{if(i(n))return;r=t.getId()}for(var u=!1,p=!1,c=t.getFormContainers(),f=0;f<c.length;f++){for(var h=c[f],y=h.getFormElements(),g=0;g<y.length;g++){for(var F=y[g],b=F.getFields(),v=0;v<b.length;v++){var I=b[v];if(l=I.getMetadata(),s&&(a(I,\"sap/ui/core/Icon\")||l.hasProperty(\"displayOnly\")&&I.getDisplayOnly())){u=!0;break}if((a(I,\"sap/m/InputBase\")||a(I,\"sap/m/CheckBox\")||a(I,\"sap/m/RadioButton\")||a(I,\"sap/m/RadioButtonGroup\")||a(I,\"sap/m/Button\")&&F.getLabel()||a(I,\"sap/m/Slider\")||l.hasProperty(\"displayOnly\")&&!I.getDisplayOnly())&&(p=!0,!s)){u=!0;break}}if(u)break}u||!s||p||(u=!0)}u&&(s?e.addIssue({severity:d.High,details:m+\" \"+r+\" is set to editable but has only non-editable content.\",context:{id:r}}):e.addIssue({severity:d.High,details:m+\" \"+r+\" is set to non-editable but has editable content.\",context:{id:r}}))})}},{id:\"formWrongLayoutData\",audiences:[p.Application],categories:[u.Consistency],enabled:!0,minversion:\"1.48\",title:\"Form: LayoutData assigned to Form content not valid for layout\",description:\"Layout data on Form content can be used to influence the appearance of Form. Depending on the layout used, different LayoutData can be used.\",resolution:\"Use only valid LayoutData that are suitable for the layout used\",resolutionurls:[{text:\"API Reference: ResponsiveGridLayout\",href:\"https://sapui5.hana.ondemand.com/#docs/api/symbols/sap.ui.layout.form.ResponsiveGridLayout.html\"},{text:\"API Reference: ResponsiveLayout\",href:\"https://sapui5.hana.ondemand.com/#docs/api/symbols/sap.ui.layout.form.ResponsiveLayout.html\"}],check:function(e,t,a){a.getElementsByClassName(\"sap.ui.layout.form.Form\").forEach(function(t){var a,r=t.getLayout(),s=t.getParent(),n=\"Form\";o(s)?(a=s.getId(),n=\"SimpleForm\"):i(s)?(a=s.getId(),n=\"SmartForm\"):a=t.getId();for(var l=t.getFormContainers(),u=0;u<l.length;u++){var d=l[u],p=d.getFormElements();m(d,n,a,r,e);for(var c=0;c<p.length;c++){var f=p[c],h=f.getFields();m(f,n,a,r,e);for(var y=0;y<h.length;y++)m(h[y],n,a,r,e)}}})}},{id:\"formMissingLabel\",audiences:[p.Application],categories:[u.Accessibility],enabled:!0,minversion:\"1.48\",title:\"Form: Label for Form content missing\",description:\"For accessibility reasons, each field must have a label. \\n If Label is assigned to FormElement, it will be automatically assigned to the corresponding fields. \\n But if no Label is assigned to FormElement, the application must use the ariaLabelledBy property of the field to assign a label.\",resolution:\"Assign a label to the field\",resolutionurls:[{text:\"API Reference: Form\",href:\"https://sapui5.hana.ondemand.com/#docs/api/symbols/sap.ui.layout.form.Form.html\"},{text:\"API Reference: SimpleForm\",href:\"https://sapui5.hana.ondemand.com/#docs/api/symbols/sap.ui.layout.form.SimpleForm.html\"},{text:\"API Reference: FormElement\",href:\"https://sapui5.hana.ondemand.com/#docs/api/symbols/sap.ui.layout.form.FormElement.html\"}],check:function(e,t,r){r.getElementsByClassName(\"sap.ui.layout.form.Form\").forEach(function(t){var r,s=t.getParent(),n=s?s.getMetadata():void 0,l=\"Form\";if(o(s))r=s.getId(),l=\"SimpleForm\";else{if(i(s))return;r=t.getId()}for(var m=t.getFormContainers(),u=0;u<m.length;u++){var p=m[u];if(p.getVisible()&&p.getExpanded())for(var c=p.getFormElements(),f=0;f<c.length;f++){var h=c[f],y=h.getLabel();if(!y&&h.getVisible())for(var g=h.getFields(),F=0;F<g.length;F++){var b=g[F],v=b.getId();n=b.getMetadata(),!n.getAssociation(\"ariaLabelledBy\")||b.getAriaLabelledBy()&&0!=b.getAriaLabelledBy().length||a(b,\"sap/m/Button\")||a(b,\"sap/m/CheckBox\")&&b.getText()||a(b,\"sap/m/RadioButton\")&&b.getText()||e.addIssue({severity:d.High,details:\"In \"+l+\" \"+r+\", no label has been assigned to field \"+n.getName()+\" \"+v+\".\",context:{id:v}})}}}})}},{id:\"formLabelAsField\",audiences:[p.Application],categories:[u.Usability],enabled:!0,minversion:\"1.48\",title:\"Form: Label is used as field\",description:\"FormElements can have Labels and Fields. \\n Depending on the layout used and device and screen sizes, the way labels and fields are shown might differ. \\n If labels are used as fields, this will lead to misaligned fields and labels in the Form and might have an effect on the screen reader support.\",resolution:\"Use Labels only in the Label aggregation\",resolutionurls:[{text:\"API Reference: Form\",href:\"https://sapui5.hana.ondemand.com/#docs/api/symbols/sap.ui.layout.form.Form.html\"},{text:\"API Reference: FormElement\",href:\"https://sapui5.hana.ondemand.com/#docs/api/symbols/sap.ui.layout.form.FormElement.html\"}],check:function(e,t,a){a.getElementsByClassName(\"sap.ui.layout.form.Form\").forEach(function(t){var a,r=t.getParent(),s=r?r.getMetadata():void 0,n=\"Form\";if(!o(r)){i(r)?(a=r.getId(),n=\"SmartForm\"):a=t.getId();for(var l=t.getFormContainers(),m=0;m<l.length;m++)for(var u=l[m],p=u.getFormElements(),c=0;c<p.length;c++)for(var f=p[c],h=f.getFields(),y=0;y<h.length;y++){var g=h[y],F=g.getId();s=g.getMetadata(),s.isInstanceOf(\"sap.ui.core.Label\")&&e.addIssue({severity:d.High,details:n+\" \"+a+\": \"+s.getName()+\" \"+F+\" is used as field.\",context:{id:F}})}}})}}]},!0);",
	"sap/ui/layout/SplitPane.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"./library\",\"sap/ui/core/Element\"],function(t,e){\"use strict\";var a=e.extend(\"sap.ui.layout.SplitPane\",{metadata:{library:\"sap.ui.layout\",properties:{demandPane:{type:\"boolean\",group:\"Behavior\",defaultValue:!0},requiredParentWidth:{type:\"int\",defaultValue:800}},defaultAggregation:\"content\",aggregations:{content:{type:\"sap.ui.core.Control\",multiple:!1,singularName:\"content\"}}}});return a.prototype.setLayoutData=function(t){var e=this.getContent();return e?e.setLayoutData(t):this},a.prototype.onLayoutDataChange=function(){var t=this.getParent();t&&t._oSplitter._delayedResize()},a.prototype._isInInterval=function(t){return this.getRequiredParentWidth()<=t},a});",
	"sap/ui/layout/Splitter.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/core/Control\",\"./library\",\"sap/ui/core/library\",\"sap/ui/core/ResizeHandler\",\"sap/ui/core/RenderManager\",\"./SplitterRenderer\"],function(e,t,i,o,s,n,r){\"use strict\";function a(e,t){if(e===t)return!1;if(!e||!t||void 0===e.length||void 0===t.length)return!0;if(e.length!=t.length)return!0;for(var i=0;i<e.length;++i)if(e[i]!==t[i])return!0;return!1}function h(e){var t=function(e){e.preventDefault()},i=null;i=function(){document.removeEventListener(\"touchend\",i),document.removeEventListener(\"touchmove\",t),document.removeEventListener(\"mouseup\",i),document.removeEventListener(\"mousemove\",t)},e?(this._ignoreMouse=!0,document.addEventListener(\"touchend\",i),document.addEventListener(\"touchmove\",t)):(document.addEventListener(\"mouseup\",i),document.addEventListener(\"mousemove\",t))}function l(t){var i=t.getLayoutData();!i||i.getResizable&&i.getSize&&i.getMinSize||(e.sap.log.warning('Content \"'+t.getId()+'\" for the Splitter contained wrong LayoutData. The LayoutData has been replaced with default values.'),i=null),i||t.setLayoutData(new sap.ui.layout.SplitterLayoutData)}var d=o.Orientation,u=t.extend(\"sap.ui.layout.Splitter\",{metadata:{library:\"sap.ui.layout\",properties:{orientation:{type:\"sap.ui.core.Orientation\",group:\"Behavior\",defaultValue:d.Horizontal},width:{type:\"sap.ui.core.CSSSize\",group:\"Appearance\",defaultValue:\"100%\"},height:{type:\"sap.ui.core.CSSSize\",group:\"Appearance\",defaultValue:\"100%\"}},defaultAggregation:\"contentAreas\",aggregations:{contentAreas:{type:\"sap.ui.core.Control\",multiple:!0,singularName:\"contentArea\"}},events:{resize:{parameters:{id:{type:\"string\"},oldSizes:{type:\"int[]\"},newSizes:{type:\"int[]\"}}}},designtime:\"sap/ui/layout/designtime/Splitter.designtime\"}}),p=sap.ui.getCore().getLibraryResourceBundle(\"sap.ui.layout\");return u.prototype.init=function(){this._needsInvalidation=!1,this._liveResize=!0,this._keyboardEnabled=!0,this._bHorizontal=!0,this._calculatedSizes=[],this._move={},this._resizeTimeout=null,this._resizeCallback=this._delayedResize.bind(this),this._resizeHandlerId=null,this._autoResize=!0,this.enableAutoResize(),this._boundBarMoveEnd=this._onBarMoveEnd.bind(this),this._boundBarMove=this._onBarMove.bind(this),this._switchOrientation(),this._bRtl=sap.ui.getCore().getConfiguration().getRTL(),this._keyListeners={increase:this._onKeyboardResize.bind(this,\"inc\",20),decrease:this._onKeyboardResize.bind(this,\"dec\",20),increaseMore:this._onKeyboardResize.bind(this,\"incMore\",20),decreaseMore:this._onKeyboardResize.bind(this,\"decMore\",20),max:this._onKeyboardResize.bind(this,\"max\",20),min:this._onKeyboardResize.bind(this,\"min\",20)},this._enableKeyboardListeners(),this._bUseIconForSeparator=!0},u.prototype.exit=function(){this.disableAutoResize(),delete this._resizeCallback,delete this._boundBarMoveEnd,delete this._boundBarMove},u.prototype.triggerResize=function(e){e?this._resize():this._delayedResize()},u.prototype.getCalculatedSizes=function(){return this._calculatedSizes},u.prototype.enableAutoResize=function(e){if(!e||this._autoResize){this._autoResize=!0;var t=this;sap.ui.getCore().attachInit(function(){t._resizeHandlerId=s.register(t,t._resizeCallback)}),this._delayedResize()}},u.prototype.disableAutoResize=function(e){s.deregister(this._resizeHandlerId),e||(this._autoResize=!1)},u.prototype.enableLiveResize=function(){this._liveResize=!0,this.$().toggleClass(\"sapUiLoSplitterAnimated\",!1)},u.prototype.disableLiveResize=function(){this._liveResize=!1,this.$().toggleClass(\"sapUiLoSplitterAnimated\",!0)},u.prototype.enableKeyboardSupport=function(){this.$().find(\".sapUiLoSplitterBar\").attr(\"tabindex\",\"0\"),this._enableKeyboardListeners()},u.prototype.disableKeyboardSupport=function(){this.$().find(\".sapUiLoSplitterBar\").attr(\"tabindex\",\"-1\"),this._disableKeyboardListeners()},u.prototype.onBeforeRendering=function(){this._switchOrientation()},u.prototype.onAfterRendering=function(){this._resize()},u.prototype.onLayoutDataChange=function(){this._delayedResize()},u.prototype.ontouchstart=function(e){if(!this._ignoreTouch){var t=this.getId();e.target.id&&0==e.target.id.indexOf(t+\"-splitbar\")&&e.changedTouches&&e.changedTouches[0]&&(this._ignoreMouse=!0,this._onBarMoveStart(e.changedTouches[0],!0))}},u.prototype.onmousedown=function(e){if(!this._ignoreMouse){var t=this.getId();e.target.id&&0==e.target.id.indexOf(t+\"-splitbar\")&&(this._ignoreTouch=!0,this._onBarMoveStart(e))}},u.prototype._onBarMoveStart=function(t,i){var o=this.getId();this.disableAutoResize(!0);var s=t[this._moveCord],n=parseInt(t.target.id.substr((o+\"-splitbar-\").length),10),r=e(t.target),a=this.getCalculatedSizes(),l=this._bHorizontal?r.innerWidth():r.innerHeight(),d=this._getContentAreas(),u=d[n].getLayoutData(),p=d[n+1].getLayoutData();if(!u.getResizable()||!p.getResizable())return void h(i);for(var c=0-l,g=0;g<=n;++g)c+=a[g]+l;this._move={start:s,relStart:c,barNum:n,bar:e(t.target),c1Size:a[n],c1MinSize:u?parseInt(u.getMinSize(),10):0,c2Size:a[n+1],c2MinSize:p?parseInt(p.getMinSize(),10):0},i?(document.addEventListener(\"touchend\",this._boundBarMoveEnd),document.addEventListener(\"touchmove\",this._boundBarMove)):(document.addEventListener(\"mouseup\",this._boundBarMoveEnd),document.addEventListener(\"mousemove\",this._boundBarMove)),this._onBarMove(t)},u.prototype._onBarMove=function(e){e.preventDefault&&e.preventDefault();var t=e;e.changedTouches&&e.changedTouches[0]&&(t=e.changedTouches[0]);var i=t[this._moveCord],o=i-this._move.start;this.getOrientation()==d.Horizontal&&this._bRtl&&(o=-o);var s=this._move.c1Size+o,n=this._move.c2Size-o;if(s>=0&&n>=0&&s>=this._move.c1MinSize&&n>=this._move.c2MinSize&&this._liveResize){var r=this._move.start-t[this._moveCord];this.getOrientation()==d.Horizontal&&this._bRtl&&(r=-r),this._resizeContents(this._move.barNum,-r,!1)}},u.prototype._onBarMoveEnd=function(t){this._ignoreMouse=!1,this._ignoreTouch=!1;var i=t;t.changedTouches&&t.changedTouches[0]&&(i=t.changedTouches[0]);var o=i[this._moveCord],s=this._move.start-o;this.getOrientation()==d.Horizontal&&this._bRtl&&(s=-s),s=this._onBarMovedForFullyCollapsibleContentArea(s,this._move.barNum),this._resizeContents(this._move.barNum,-s,!0),document.removeEventListener(\"mouseup\",this._boundBarMoveEnd),document.removeEventListener(\"mousemove\",this._boundBarMove),document.removeEventListener(\"touchend\",this._boundBarMoveEnd),document.removeEventListener(\"touchmove\",this._boundBarMove),this.enableAutoResize(!0),e.sap.focus(this._move.bar)},u.prototype._resizeContents=function(t,i,o){if(isNaN(i))return void e.sap.log.warning(\"Splitter: Received invalid resizing values - resize aborted.\");var s,n=this._getContentAreas(),r=n[t].getLayoutData(),a=n[t+1].getLayoutData(),h=this.$(\"content-\"+t),l=this.$(\"content-\"+(t+1)),d=this._move.c1Size+i,u=this._move.c2Size-i,p=this._checkFullyCollapsibleContentArea(t)?0:parseInt(r.getMinSize(),10),c=this._checkFullyCollapsibleContentArea(t+1)?0:parseInt(a.getMinSize(),10);d<p?(s=p-d,i+=s,d=p,u-=s):u<c&&(s=c-u,i-=s,u=c,d-=s),o?this.setSizeInLayoutdata(t,d,u):(h.css(this._sizeType,d+\"px\"),l.css(this._sizeType,u+\"px\"),this.hideContentAreaScrollBar(h,d),this.hideContentAreaScrollBar(l,u))},u.prototype._checkFullyCollapsibleContentArea=function(e){return!1},u.prototype._onBarMovedForFullyCollapsibleContentArea=function(e,t){return e},u.prototype._onArrowKeyPressedForFullyCollapsibleContentArea=function(e,t){return e},u.prototype._onHomeKeyPressed=function(e,t){return e},u.prototype._onEndKeyPressed=function(e,t){return e},u.prototype.setSizeInLayoutdata=function(e,t,i){var o=this._getContentAreas(),s=o[e].getLayoutData(),n=o[e+1].getLayoutData(),r=s.getSize(),a=n.getSize();\"auto\"===r&&\"auto\"!==a?n.setSize(i+\"px\"):\"auto\"!==r&&\"auto\"===a?s.setSize(t+\"px\"):(s.setSize(t+\"px\"),n.setSize(i+\"px\"))},u.prototype.hideContentAreaScrollBar=function(e,t){},u.prototype._delayedResize=function(t){void 0===t&&(t=0),this.getDomRef()&&(e.sap.clearDelayedCall(this._resizeTimeout),e.sap.delayedCall(t,this,\"_resize\",[]))},u.prototype._resizeBars=function(e){var t,i,o=this.$();for(t=0;t<e.length-1;++t)i=this.$(\"splitbar-\"+t),i.css(this._sizeTypeNot,\"\");for(t=0;t<e.length-1;++t){i=this.$(\"splitbar-\"+t);var s=this._bHorizontal?o.height():o.width();i.css(this._sizeType,\"\"),i.css(this._sizeTypeNot,s+\"px\")}},u.prototype._resize=function(){var e=this.getDomRef();if(e&&!n.getPreserveAreaRef().contains(e)){var t=this.$(),i=0;if(t&&t.length>0&&(i=this._bHorizontal?t[0].clientWidth:t[0].clientHeight),0!==i){var o,s=0,r=this._getContentAreas();this._resizeBars(r);var h=this.getCalculatedSizes();this._recalculateSizes();var l=this.getCalculatedSizes(),d=!1;for(s=0;s<l.length;++s)if(0!==l[s]){d=!0;break}if(d){var u=!0;for(s=0;s<r.length;++s){var p=this.$(\"content-\"+s),c=r[s];p.css(this._sizeType,l[s]+\"px\"),p.css(this._sizeTypeNot,\"\"),this.hideContentAreaScrollBar(p,l[s]);var g=c.getLayoutData(),_=g&&g.getResizable();if(s>0){var v=_&&u;o=this.$(\"splitbar-\"+(s-1)),o.toggleClass(\"sapUiLoSplitterNoResize\",!v),o.attr(\"tabindex\",v&&this._keyboardEnabled?\"0\":\"-1\")}u=_}this._resizeBars(r),a(h,l)&&this.fireResize({oldSizes:h,newSizes:l})}}}},u.prototype._calculateAvailableContentSize=function(e){var t=0,i=this.$(),o=this._bHorizontal?i.innerWidth():i.innerHeight(),s=0,n=!1;for(t=0;t<e.length;++t){e[t].indexOf(\"%\")>-1&&s++,\"auto\"==e[t]&&(n=!0)}s+=n?1:0;var r=0;for(t=0;t<this._getContentAreas().length;++t){var a=this.$(\"content-\"+t);this.getOrientation()===sap.ui.core.Orientation.Horizontal?r+=parseFloat(a.css(\"padding-left\"))+parseFloat(a.css(\"padding-right\")):r+=parseFloat(a.css(\"padding-top\"))+parseFloat(a.css(\"padding-bottom\"))}o-=r;var h=e.length-1,l=0,d=0;for(t=0;t<h;++t)this._bHorizontal?this.$(\"splitbar-\"+t)[0]&&(d=Math.ceil(this.$(\"splitbar-\"+t)[0].getBoundingClientRect().width)):this.$(\"splitbar-\"+t).innerHeight()&&(d=this.$(\"splitbar-\"+t).innerHeight()),isNaN(d)||(l+=d);return o-l},u.prototype._recalculateSizes=function(){var t,i,o,s,n,r=[],a=this._getContentAreas();for(t=0;t<a.length;++t)o=a[t].getLayoutData(),i=o?o.getSize():\"auto\",i.indexOf(\"-\")>-1&&(i=\"auto\"),r.push(i);this._calculatedSizes=[];var h=this._calculateAvailableContentSize(r),l=[],d=[],u=[],p=h;for(t=0;t<r.length;++t){i=r[t];var c;i.indexOf(\"px\")>-1?(c=this.calcSizeFromPixels(i,t),p-=c,this._calculatedSizes[t]=c):i.indexOf(\"%\")>-1?u.push(t):\"auto\"==r[t]?(o=a[t].getLayoutData(),o&&0!=parseInt(o.getMinSize(),10)?d.push(t):l.push(t)):e.sap.log.error(\"Illegal size value: \"+r[t])}var g=!1;p<0&&(g=!0,p=0),p=this.calcSizeFromPercentage(p,h,u,r),h=p,h<0&&(g=!0,h=0),s=d.length+l.length===0?0:Math.floor(h/(d.length+l.length),0);var _=d.length;for(t=0;t<_;++t){n=d[t];var v=parseInt(a[n].getLayoutData().getMinSize(),10);v>s?(this._calculatedSizes[n]=v,h-=v):(this._calculatedSizes[n]=s,h-=s)}h<0&&(g=!0,h=0),p=h;var y=l.length;for(s=0===y?0:Math.floor(h/y,0),t=0;t<y;++t)n=l[t],this._calculatedSizes[n]=s,p-=s;!g&&p>0&&(l.length>0?(this._calculatedSizes[l[0]]+=p,p=0):d.length>0&&(this._calculatedSizes[d[0]]+=p,p=0)),g&&e.sap.log.info(\"[Splitter] The set sizes and minimal sizes of the splitter contents are bigger than the available space in the UI.\")},u.prototype.calcSizeFromPixels=function(e,t){return parseInt(e,10)},u.prototype.calcSizeFromPercentage=function(e,t,i,o){for(var s=i.length,n=0;n<s;++n){var r=i[n],a=Math.floor(parseFloat(o[r])/100*t,0);this._calculatedSizes[r]=a,e-=a}return e},u.prototype._switchOrientation=function(){this._bHorizontal=this.getOrientation()===d.Horizontal,this._bHorizontal?(this._sizeDirNot=\"top\",this._sizeTypeNot=\"height\",this._sizeType=\"width\",this._moveCord=\"pageX\",this._bRtl?this._sizeDir=\"right\":this._sizeDir=\"left\"):(this._moveCord=\"pageY\",this._sizeType=\"height\",this._sizeTypeNot=\"width\",this._sizeDir=\"top\",this._sizeDirNot=\"left\");var e=this.$();e.toggleClass(\"sapUiLoSplitterH\",this._bHorizontal),e.toggleClass(\"sapUiLoSplitterV\",!this._bHorizontal)},u.prototype._onKeyboardResize=function(t,i,o){var s=this.getId()+\"-splitbar-\";if(o&&o.target&&o.target.id&&0===o.target.id.indexOf(s)){var n=parseInt(o.target.id.substr(s.length),10),r=this.getCalculatedSizes();this._move.c1Size=r[n],this._move.c2Size=r[n+1];var a=0;switch(t){case\"inc\":a=i,a=this._onArrowKeyPressedForFullyCollapsibleContentArea(a,n);break;case\"incMore\":a=10*i;break;case\"dec\":a=0-i,a=this._onArrowKeyPressedForFullyCollapsibleContentArea(a,n);break;case\"decMore\":a=0-10*i;break;case\"max\":a=999999,a=this._onEndKeyPressed(a,n);break;case\"min\":a=-999999,a=this._onHomeKeyPressed(a,n);break;default:e.sap.log.warn(\"[Splitter] Invalid keyboard resize type\")}this._resizeContents(n,a,!0)}},u.prototype._enableKeyboardListeners=function(){this.onsapright=this._keyListeners.increase,this.onsapdown=this._keyListeners.increase,this.onsapleft=this._keyListeners.decrease,this.onsapup=this._keyListeners.decrease,this.onsappageup=this._keyListeners.decreaseMore,this.onsappagedown=this._keyListeners.increaseMore,this.onsapend=this._keyListeners.max,this.onsaphome=this._keyListeners.min,this._keyboardEnabled=!0},u.prototype._disableKeyboardListeners=function(){delete this.onsapincreasemodifiers,delete this.onsapdecreasemodifiers,delete this.onsapendmodifiers,delete this.onsaphomemodifiers,this._keyboardEnabled=!1},u.prototype._getText=function(e,t){return p?p.getText(e,t):e},u.prototype.invalidate=function(e){(e&&-1!=this.indexOfContentArea(e)||e&&e instanceof sap.ui.core.CustomData&&e.getWriteToDom()||void 0===e||this._needsInvalidation)&&(this._needsInvalidation=!1,t.prototype.invalidate.apply(this,arguments))},u.prototype.setOrientation=function(e){var t=this.setProperty(\"orientation\",e,!0);return this._switchOrientation(),this._delayedResize(),this.$().find(\".sapUiLoSplitterBar\").attr(\"aria-orientation\",this._bHorizontal?\"vertical\":\"horizontal\"),t},u.prototype.setWidth=function(e){return this.setProperty(\"width\",e,!0),this.$().css(\"width\",this.getProperty(\"width\")),this},u.prototype.setHeight=function(e){return this.setProperty(\"height\",e,!0),this.$().css(\"height\",this.getProperty(\"height\")),this},u.prototype.addContentArea=function(e){return this._needsInvalidation=!0,l(e),this.addAggregation(\"contentAreas\",e)},u.prototype.removeContentArea=function(e){return this._needsInvalidation=!0,this.removeAggregation(\"contentAreas\",e)},u.prototype.removeAllContentArea=function(){return this._needsInvalidation=!0,this.removeAllAggregation(\"contentAreas\")},u.prototype.destroyContentArea=function(){return this._needsInvalidation=!0,this.destroyAggregation(\"contentAreas\")},u.prototype.insertContentArea=function(e,t){return this._needsInvalidation=!0,l(e),this.insertAggregation(\"contentAreas\",e,t)},u.prototype._getContentAreas=function(){return this.getContentAreas()},u});",
	"sap/ui/layout/SplitterLayoutData.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"sap/ui/core/LayoutData\",\"./library\"],function(e,a){\"use strict\";return e.extend(\"sap.ui.layout.SplitterLayoutData\",{metadata:{library:\"sap.ui.layout\",properties:{resizable:{type:\"boolean\",group:\"Behavior\",defaultValue:!0},size:{type:\"sap.ui.core.CSSSize\",group:\"Dimension\",defaultValue:\"auto\"},minSize:{type:\"int\",group:\"Dimension\",defaultValue:0}}}})});",
	"sap/ui/layout/SplitterRenderer.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"sap/ui/core/library\"],function(t){\"use strict\";var e=t.Orientation,i={};return i.render=function(t,i){var r=i.getOrientation()===e.Horizontal,a=r?\"sapUiLoSplitterH\":\"sapUiLoSplitterV\",n=sap.ui.getCore().getConfiguration().getAnimation();t.write(\"<div\"),t.writeControlData(i),t.addClass(\"sapUiLoSplitter\"),t.addClass(a),n&&!i._liveResize&&t.addClass(\"sapUiLoSplitterAnimated\"),t.writeClasses(),t.addStyle(\"width\",i.getWidth()),t.addStyle(\"height\",i.getHeight()),t.writeStyles(),t.write(\">\"),this.renderInitialContent(t,i),t.write(\"</div>\")},i.renderInitialContent=function(t,i){for(var r=i.getId(),a=i.getOrientation()===e.Horizontal,n=a?\"width\":\"height\",o=i._getContentAreas(),l=o.length,s=i.getCalculatedSizes(),d=0;d<l;++d){var p=o[d].getLayoutData(),c=\"0\";s[d]?c=s[d]+\"px\":p&&(c=p.getSize()),this.renderSectionContainer(t,i,c,n,d,l),t.renderControl(o[d]),t.write(\"</section>\"),d<l-1&&(this.renderSplitBar(t,i,a,d),this.renderGripIcon(t,i,r,a,d),t.write(\"</div>\"))}this.renderOverlay(t,i),this.renderGripIcon(t,i,r,a,\"Overlay\"),t.write(\"</div></div>\")},i.renderGripIcon=function(t,e,i,r,a){var n=\"sap-icon://\"+(r?\"horizontal\":\"vertical\")+\"-grip\";t.writeIcon(n,\"sapUiLoSplitterBarIcon\",{id:i+\"-splitbar-\"+a+\"-icon\",title:null,\"aria-label\":null})},i.renderSectionContainer=function(t,e,i,r,a,n){t.write('<section id=\"'+e.getId()+\"-content-\"+a+'\" style=\"'+r+\": \"+i+';\" class=\"sapUiLoSplitterContent\">')},i.renderSplitBar=function(t,e,i,r){t.write('<div id=\"'+e.getId()+\"-splitbar-\"+r+'\" role=\"separator\" title=\"'+e._getText(\"SPLITTER_MOVE\")+'\" class=\"sapUiLoSplitterBar\" aria-orientation=\"'+(i?\"vertical\":\"horizontal\")+'\" tabindex=\"0\">')},i.renderOverlay=function(t,e){t.write('<div id=\"'+e.getId()+'-overlay\" class=\"sapUiLoSplitterOverlay\" style=\"display: none;\"><div id=\"'+e.getId()+'-overlayBar\" class=\"sapUiLoSplitterOverlayBar\">')},i},!0);",
	"sap/ui/layout/VerticalLayout.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"sap/ui/core/Control\",\"sap/ui/core/EnabledPropagator\",\"./library\",\"./VerticalLayoutRenderer\"],function(t,e,i,o){\"use strict\";var a=t.extend(\"sap.ui.layout.VerticalLayout\",{metadata:{library:\"sap.ui.layout\",properties:{width:{type:\"sap.ui.core.CSSSize\",group:\"Dimension\",defaultValue:null},enabled:{type:\"boolean\",group:\"Behavior\",defaultValue:!0}},defaultAggregation:\"content\",aggregations:{content:{type:\"sap.ui.core.Control\",multiple:!0,singularName:\"content\"}},designtime:\"sap/ui/layout/designtime/VerticalLayout.designtime\"}});return a.prototype.setWidth=function(t){return this.setProperty(\"width\",t,!0),this.getDomRef()&&(this.getDomRef().style.width=this.getWidth()),this},a.prototype.getAccessibilityInfo=function(){return{children:this.getContent()}},e.call(a.prototype),a});",
	"sap/ui/layout/VerticalLayoutRenderer.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([],function(){\"use strict\";var t={};return t.render=function(t,e){var i=t;i.write(\"<DIV\"),i.writeControlData(e),i.addClass(\"sapUiVlt\"),i.addClass(\"sapuiVlt\"),e.getWidth()&&\"\"!=e.getWidth()&&i.addStyle(\"width\",e.getWidth()),i.writeStyles(),i.writeClasses(),i.write(\">\");for(var r=e.getContent(),a=0;a<r.length;a++)i.write('<DIV class=\"sapUiVltCell sapuiVltCell\">'),i.renderControl(r[a]),i.write(\"</DIV>\");i.write(\"</DIV>\")},t},!0);",
	"sap/ui/layout/manifest.json": "{\"_version\":\"1.9.0\",\"sap.app\":{\"_version\":\"1.2.0\",\"id\":\"sap.ui.layout\",\"type\":\"library\",\"applicationVersion\":{\"version\":\"9.4.0-0\"},\"title\":\"The OpenUI5-based library, sap.ui.layout.\"},\"sap.ui5\":{\"_version\":\"1.1.0\",\"dependencies\":{\"libs\":{\"sap.ui.core\":{}}},\"library\":{\"i18n\":\"messagebundle.properties\"}}}"
}, "sap/ui/layout/library-preload");